<?xml version="1.0"?>

<st-source>
<time-stamp>From VisualWorks®, 7.4 of December 5, 2005 on May 29, 2006 at 4:16:06 am</time-stamp>
<!-- Bundle Swazoo(1.1.4,janko)* -->


<component-property>
<name>Swazoo</name> <type>bundle</type>
<property>parcelName</property> <value>'Swazoo'</value>
</component-property>

<component-property>
<name>Swazoo</name> <type>bundle</type>
<property>prerequisiteParcels</property> <value>#(#('SUnit' ''))</value>
</component-property>

<component-property>
<name>Swazoo</name> <type>bundle</type>
<property>developmentPrerequisites</property> <value>#(#(#parcel 'SUnit' ''))</value>
</component-property>

<component-property>
<name>Swazoo</name> <type>bundle</type>
<property>comment</property> <value>'Swazoo (Smalltalk Web Application Zoo) is an open source, vendor agnostic,
dialect neutral Smalltalk HTTP server with resource and web request
resolution framework. Swazoo is currently supported on Squeak,
VisualWorks, Gemstone and Dolphin Smalltalk. Currently (nov2005) its main features are:

    * HTTP 1.1 and virtual site support
    * concept of hierarchical Resources allows pluggable addition of new
	  web resourcers like static page servers, wikis, dynamic web applications ...
    * clean web request resolution framework
    * resources for static web serving, basic authentication and session support
    * SSL support via OpenSSL interface

Quick installation steps are:

1. copy everything from the goodies/other/Swazoo to your prefered
   directory, together with original visual.im
2. load bundle or parcel Swazoo
3. In a workspace doIt SwazooServer configureFrom: ''sites.cnf''
4. in your browser open http://localhost:8888

Additional steps for adding SSL support:

5. on Linux, be sure you have openssl installed
6. load bundle or parcel Swazoo-SSL
7. in a workspace doIt SwazooServer configureFrom: ''sites-ssl.cnf''
8. in your browser open https://localhost:8889  (don''t forget s in https:// !)

More about Swazoo:

	http://wiki.cs.uiuc.edu/CampSmalltalk/Swazoo
	http://sourceforge.net/projects/swazoo

If you have any questions, suggestions or are wiling to help, please join our
 mailing list: 

	http://lists.sourceforge.net/lists/listinfo/swazoo-devel

More recent work is in Cincom Public Repository in bundles Swazoo and Swazoo-SSL, to join please
follow instructions here:

	http://www.cincomsmalltalk.com/CincomSmalltalkWiki/PostgreSQL+Access+Page


Happy Swazoo-ing from your Swazoo team :)
'</value>
</component-property>

<component-property>
<name>Swazoo</name> <type>bundle</type>
<property>version</property> <value>'1.1'</value>
</component-property><!-- Bundle Sport(2 012,janko)= -->


<component-property>
<name>Sport</name> <type>bundle</type>
<property>parcelName</property> <value>'OSkPortability'</value>
</component-property>

<component-property>
<name>Sport</name> <type>bundle</type>
<property>developmentPrerequisites</property> <value>#(#(#parcel 'FileOut30' ''))</value>
</component-property>

<component-property>
<name>Sport</name> <type>bundle</type>
<property>comment</property> <value>'©Bruce Badger 2004, 2005, 2006. Licensed under the LGPL.

This bundle represents the deployable state of the Smalltalk portability library used for the PostgreSQL library, Swazoo and OpenSkills systems.  See the comments on the sub-pundles for further details.'</value>
</component-property><!-- Package SpExceptions(2 012,janko)= -->


<component-property>
<name>SpExceptions</name> <type>package</type>
<property>comment</property> <value>'©Bruce Badger 2004. Licensed under the LGPL.
'</value>
</component-property>

<class>
<name>SpExceptionContext</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpExceptions</category>
<attributes>
<package>SpExceptions</package>
</attributes>
</class>

<class>
<name>SpExceptionCodeForSqueak</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpExceptions</category>
<attributes>
<package>SpExceptions</package>
</attributes>
</class>

<class>
<name>SpExceptionCodeForGemStone</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpExceptions</category>
<attributes>
<package>SpExceptions</package>
</attributes>
</class>

<class>
<name>SpAbstractError</name>
<environment>Smalltalk</environment>
<super>Core.Error</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpExceptions</category>
<attributes>
<package>SpExceptions</package>
</attributes>
</class>

<class>
<name>SpError</name>
<environment>Smalltalk</environment>
<super>SpAbstractError</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpExceptions</category>
<attributes>
<package>SpExceptions</package>
</attributes>
</class>






<methods>
<class-id>SpExceptionCodeForSqueak class</class-id> <category>code strings</category>

<body package="SpExceptions">codeString
	"^a String
	I return the string which is the source code for the GemStone compatibility classes."

	"(Filename named: 'SpExceptions-squeak.st') writeStream nextPutAll: self codeString; close"

	^'Error subclass: #SpAbstractError
	instanceVariableNames: ''parameter''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpExceptions''!

!SpAbstractError methodsFor: ''accessing'' stamp: ''BB 1/25/2006 21:52''!
errorString
	^self messageText! !

!SpAbstractError methodsFor: ''accessing'' stamp: ''BB 1/23/2006 22:03''!
parameter
	^parameter ! !

!SpAbstractError methodsFor: ''accessing'' stamp: ''BB 1/23/2006 22:03''!
parameter: anObject 
	parameter := anObject! !


!SpAbstractError methodsFor: ''signalling'' stamp: ''BB 1/23/2006 22:11''!
raiseSignal
	"Raise an an exception."
	^ self signal! !

!SpAbstractError methodsFor: ''signalling'' stamp: ''BB 1/25/2006 22:02''!
raiseSignal: aString 
	"Raise an an exception."
	^ self signal: aString! !


!SpAbstractError methodsFor: ''priv handling'' stamp: ''BB 1/23/2006 22:16''!
isResumable
	"Determine whether an exception is resumable."

	^self class mayResume! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpAbstractError class
	instanceVariableNames: ''''!

!SpAbstractError class methodsFor: ''signalling'' stamp: ''BB 1/23/2006 22:08''!
raiseSignal
	"Raise an an exception."
	^ self signal! !

!SpAbstractError class methodsFor: ''signalling'' stamp: ''BB 1/23/2006 21:24''!
raiseSignal: aString 
	"Raise an an exception."
	^ self signal: aString! !


!SpAbstractError class methodsFor: ''testing'' stamp: ''BB 1/23/2006 22:17''!
mayResume

	^false! !


SpAbstractError subclass: #SpError
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpExceptions''!


Object subclass: #SpExceptionContext
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpExceptions''!
!SpExceptionContext commentStamp: ''&lt;historical&gt;'' prior: 0!
Exceptions vary quite a bit between Smalltalk implementaions, despite the presence of the ANSI Smalltalk specification.  This class representss a portable exception context in which a block can be executed, exceptions trapped and handlers defined.!


"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpExceptionContext class
	instanceVariableNames: ''''!

!SpExceptionContext class methodsFor: ''native exceptions'' stamp: ''BB 1/19/2006 15:48''!
brokenPipeException
	"I return the exception that get''s thrown when a socket connection gets 
	broken."

	^ProtocolClientError! !


!SpExceptionContext class methodsFor: ''instance creation'' stamp: ''BB 1/19/2006 15:45''!
for: aBlock onAnyExceptionDo: exceptionBlock 
	"^an Object 
	I execute aBlock and if there is any exception I evaluate exceptionBlock.  Essentially, I look out for the most abstract kind of exception which , of course, will vary between Smalltalk implementations."

	^aBlock on: Exception do: exceptionBlock! !

!SpExceptionContext class methodsFor: ''instance creation'' stamp: ''BB 1/19/2006 15:44''!
for: aBlock on: anException do: exceptionBlock 
	"^an Object 
	I return the result of evaluating aBlock. In VisualWorks and other 
	Smalltalks which are ANSI compliant, I delegate to aBlock."

	^aBlock on: anException do: exceptionBlock! !
'</body>
</methods>


<methods>
<class-id>SpExceptionContext class</class-id> <category>native exceptions</category>

<body package="SpExceptions">brokenPipeException
	"I return the exception that get's thrown when a socket connection gets 
	broken."

	^OsTransferFaultError</body>
</methods>

<methods>
<class-id>SpExceptionContext class</class-id> <category>instance creation</category>

<body package="SpExceptions">for: aBlock on: anException do: exceptionBlock 
	"^an Object 
	I return the result of evaluating aBlock. In VisualWorks and other 
	Smalltalks which are ANSI compliant, I delegate to aBlock."

	^aBlock on: anException do: exceptionBlock</body>

<body package="SpExceptions">for: aBlock onAnyExceptionDo: exceptionBlock 
	"^an Object 
	I execute aBlock and if there is any exception I evaluate exceptionBlock.  Essentially, I look out for the most abstract kind of exception which , of course, will vary between Smalltalk implementations."

	^aBlock on: Exception do: exceptionBlock</body>
</methods>


<methods>
<class-id>SpExceptionCodeForGemStone class</class-id> <category>code strings</category>

<body package="SpExceptions">codeString
	"^a String
	I return the string which is the source code for the GemStone compatibility classes."

	"(Filename named: 'SpExceptions.gs') writeStream nextPutAll: self codeString; close"

	^'!
! From ! GEMSTONE: 6.1, Thu Apr 17 20:11:38 US/Pacific 2003; IMAGE: GemStone v6.1 kernel classes filein completed at 17/04/2003 20:22:36

! GemStone v6.1 kernel classes filein of stripped sources completed at 17/04/2003 20:31:50

! 

! On March 11, 2006, 10:28:49 am
!
!
! SymbolDictionary ''SpExceptions''
!
run
| symList newDict |
symList := System myUserProfile symbolList.
symList do: [ :element |
    (element includesKey: #SpExceptions)
        ifTrue: [ ^element ]
].
newDict := SymbolDictionary new.
newDict at: #SpExceptions put: newDict.
System myUserProfile insertDictionary: newDict at: 1.
^newDict
%
doit
(Object subclass: ''SpAbstractError''  instVarNames: #( handler gsCategory gsSignalNumber                    gsArguments messageText parameter)  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpExceptions  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(SpAbstractError subclass: ''SpError''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpExceptions  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(SpError subclass: ''SpAnyGemStoneError''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpExceptions  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(SpError subclass: ''SpStreamError''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpExceptions  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpExceptionContext''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpExceptions  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpExceptionTests''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpExceptions  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
SpAbstractError immediateInvariant.
%
doit
SpError immediateInvariant.
%
doit
SpAnyGemStoneError immediateInvariant.
%
doit
SpStreamError immediateInvariant.
%
doit
SpExceptionContext immediateInvariant.
%
doit
SpExceptionTests immediateInvariant.
%

! Remove existing behavior from SpAbstractError
doit
SpAbstractError removeAllMethods.
SpAbstractError class removeAllMethods.
%
! ------------------- Class methods for SpAbstractError
category: ''accessing''
classmethod: SpAbstractError
exceptionCategory
	"^a LanguageDictionary
I return the SpExceptionCategory - I create it if necessary.   An exception category is always an insance of LanguageDictionary (yes, really).  LanguageDictionaries are just SymbolDictionaries keyed on symbols which are language names, e.g. #English.  We have an English entry, which has a value of an array.  This array represents the exception numbers and the text to be displayed when the exception is raised.  We have just one exception number, and the text to be displayed is the result of sending &gt;&gt;asString to the first elemnt of the arguments created when the exception is raised - so we have an Array with one element (the number 1) at index 1 of the Array of errors in English.  Phew.  See the GemStone Programming Guide is you really want to understand GemStone exceptions."

	^SpExceptions at: #SpExceptionCategory
		ifAbsentPut: 
			[(LanguageDictionary new)
				at: #English put: (Array with: #(1));
				yourself]
%
category: ''accessing''
classmethod: SpAbstractError
signalNumber
"^an Integer
All Sp Exceptions use the signal number 1.  They are then differenciated by class, per ANSI."

	^1
%
category: ''raising''
classmethod: SpAbstractError
raise: anException
	"^a SpError
I raise anException which should be one of my instances.  Here in GemStone (until ANSI exceptions) we have to signal exceptions using System&gt;&gt;signal ..."

"	^System 
		signal: 1
		args: (Array with: anException messageText)
		signalDictionary: self exceptionCategory"
"I think the above should work - but it doesn''t :-( "

^self raiseSignal: anException messageText
%
category: ''raising''
classmethod: SpAbstractError
raiseSignal
	"^a SpError
I raise an exception with no specific message."

	^self raiseSignal: nil
%
category: ''raising''
classmethod: SpAbstractError
raiseSignal: aString 
	"^a SpError
I raise an exception.  Here in GemStone (until ANSI exceptions) we have to signal exceptions using System&gt;&gt;signal ..."

	| arguments |
	arguments := OrderedCollection with: self new.
	aString notNil ifTrue: [arguments add: aString].
	^System 
		signal: 1
		args: arguments asArray
		signalDictionary: self exceptionCategory
%
category: ''testing''
classmethod: SpAbstractError
mayResume
	"^a Boolean
	By default exceptions may not resume.  My subclasses may override."

	^false
%
! ------------------- Instance methods for SpAbstractError
category: ''accessing''
method: SpAbstractError
arguments
	"^an Array
I return the arguments array for the exception I represent."

	^(Array new: 2) 
		at: 1 put: self class;
		at: 2 put: self messageText;
"		at: 3 put: self parameter; "
		yourself
%
category: ''accessing''
method: SpAbstractError
arguments: anArray
	"^self
The arguments array contains my class as the first element, then optionally a message text, and lastly a parameter."

	self gsArguments: anArray.
	anArray size &gt; 1 ifTrue: [self messageText: (anArray at: 2)].
	anArray size &gt; 2 ifTrue: [self parameter: (anArray at: 3)].
	^self
%
category: ''accessing''
method: SpAbstractError
exceptionCategory
	^self class exceptionCategory
%
category: ''accessing''
method: SpAbstractError
gsArguments
	^gsArguments
%
category: ''accessing''
method: SpAbstractError
gsArguments: anArgumentsArray
	gsArguments := anArgumentsArray.
	self
%
category: ''accessing''
method: SpAbstractError
gsCategory
	^gsCategory
%
category: ''accessing''
method: SpAbstractError
gsCategory: aGemStoneExceptionCategory
	gsCategory := aGemStoneExceptionCategory.
	^self
%
category: ''accessing''
method: SpAbstractError
gsSignalNumber
	^gsSignalNumber
%
category: ''accessing''
method: SpAbstractError
gsSignalNumber: aGemStoneExceptionSignalNumber
	gsSignalNumber := aGemStoneExceptionSignalNumber.
	^self
%
category: ''accessing''
method: SpAbstractError
handler
	"^self
I return my handler."
	
	^handler
%
category: ''accessing''
method: SpAbstractError
handler: aHandler
	"^self
I record the handler here, just in case"
	
	handler := aHandler.
	^self
%
category: ''accessing''
method: SpAbstractError
messageText
	"^a String 
I return the text of the error message."

	^messageText
%
category: ''accessing''
method: SpAbstractError
messageText: aString
	"^self 
I record the text of the error message."

	messageText := aString.
	^self
%
category: ''accessing''
method: SpAbstractError
parameter
	"^self 
I return the parameter for this exception."

	^parameter
%
category: ''accessing''
method: SpAbstractError
parameter: anObject
	"^self 
I record the parameter for this exception."

	parameter := anObject.
	^self
%
category: ''accessing''
method: SpAbstractError
signalNumber
	^self class signalNumber
%
category: ''license''
method: SpAbstractError
license
	"^a License 
	Copyright 2004 Bruce Badger
	This software is licenced under the LGPL."

	^nil
%
category: ''services''
method: SpAbstractError
pass
"^self
If I have an active handler, I use &gt;&gt;resignal to pass the exception *as I originaly received it* to the next outer handler.
If you end up here because of a &gt;&gt;halt, put a breakpoint in SpExceptionContext class&gt;&gt;doCatchingAnything: where the Sp exception instance is created ... then you will see where the halt *really* is.  Any suggestions on how to do this properly in GemStone would be most welcome."

	self handler isNil ifFalse: [
		self handler
			resignal: self gsCategory
			number: self gsSignalNumber
			args: self gsArguments].
	^self

	
%
category: ''services''
method: SpAbstractError
raise
"^self
If an exception class is resumable, I don''t actually raise the exception at all for now.  Ugh.  This is because I can''t work out how to get the GemStone exceptions to resume nicely."

	#wip yourself.
	^self class mayResume
		ifTrue: [self]
		ifFalse: [self class raise: self].
%
category: ''services''
method: SpAbstractError
resume
	"^self
This has no meaning with GemStone exceptions.  I don''t know what to do here, and doing nothing could cause problems (like corruption, even) so I raise an ''Uncontinuable Error'' (see the last page of the Error Handling section of the GemStone programming guide."

	self class mayResume 
		ifFalse: 
			[System 
				signal: (ErrorSymbols at: #rtErrUncontinuable)
				args: #()
				signalDictionary: GemStoneError].
	^self
%
category: ''testing''
method: SpAbstractError
isNoticeResponse
	"^a Boolean 
	I return true if I am a notice response, otherwise, I return false. By default, I return false."

	^false
%

! Remove existing behavior from SpError
doit
SpError removeAllMethods.
SpError class removeAllMethods.
%
! ------------------- Class methods for SpError
! ------------------- Instance methods for SpError

! Remove existing behavior from SpAnyGemStoneError
doit
SpAnyGemStoneError removeAllMethods.
SpAnyGemStoneError class removeAllMethods.
%
! ------------------- Class methods for SpAnyGemStoneError
category: ''accessing''
classmethod: SpAnyGemStoneError
signalNumber
"^an Integer
I return my unique GemStone signal number."

	^nil
%
! ------------------- Instance methods for SpAnyGemStoneError

! Remove existing behavior from SpStreamError
doit
SpStreamError removeAllMethods.
SpStreamError class removeAllMethods.
%
! ------------------- Class methods for SpStreamError
! ------------------- Instance methods for SpStreamError

! Remove existing behavior from SpExceptionContext
doit
SpExceptionContext removeAllMethods.
SpExceptionContext class removeAllMethods.
%
! ------------------- Class methods for SpExceptionContext
category: ''instance creation''
classmethod: SpExceptionContext
for: aBlock on: anExceptionClass do: exceptionBlock 
	"^an Object
I run aBlock in &gt;&gt;do:catchExceptionsOfClass: and either get a result of an exception of anExceptionClass (or subclass) or some other object.  If the result is some other object, I return it.  Otherwise I return the result of evaluating exceptionBlock."

	| result |
	result := self do: aBlock catchExceptionsOfClass: anExceptionClass.
	^(result isKindOf: anExceptionClass) 
		ifTrue: [exceptionBlock value: result]
		ifFalse: [result]
%
category: ''instance creation''
classmethod: SpExceptionContext
for: aBlock onAnyExceptionDo: exceptionBlock 
	"^an Object 
	I execute aBlock and if there is any exception I evaluate exceptionBlock.  Essentially, I look out for the most abstract kind of exception which , of course, will vary between Smalltalk implementations."

	| result |
	result := self doCatchingAnything: aBlock .
	^(result isKindOf: SpAbstractError) 
		ifTrue: [exceptionBlock value: result]
		ifFalse: [result]
%
category: ''native exceptions''
classmethod: SpExceptionContext
brokenPipeException
	"I return the exception that get''s thrown when a socket connection gets 
	broken. This is used in PostgreSQLConnection&gt;&gt;close."

	^SpAnyGemStoneError
%
category: ''private''
classmethod: SpExceptionContext
do: aBlock catchExceptionsOfClass: anExceptionClass 
	"^an Object
The objective is to execute aBlock.  If there is an exception which is a kind of anExceptionClass I catch it, and see if the exception raised is either anExceptionClass or one of its subclasses.  If it is, I return the exception from the block which will cause some exception handling code to be run (see my sender)."

	Exception 
		category: SpAbstractError exceptionCategory
		number: nil
		do: 
			[:exceptionHandler :category :signalNumber :exceptionArguments | 
			| anException |
			(exceptionArguments notEmpty 
				and: [(anException := exceptionArguments at: 1) isKindOf: anExceptionClass]) 
					ifTrue: 
						[anException
							handler: exceptionHandler;
							gsCategory: category;
							gsSignalNumber: signalNumber;	
							arguments: exceptionArguments.
						^anException]
					ifFalse: 
						[exceptionHandler 
							resignal: category
							number: signalNumber
							args: exceptionArguments]].
	^aBlock value
%
category: ''private''
classmethod: SpExceptionContext
doCatchingAnything: aBlock 
	"^an Object
The objective is to execute aBlock.  If there is any exception I catch it and return an SpAbscractError exception from the block which will cause some exception handling code to be run (see my sender)."

	Exception 
		category: nil
		number: nil
		do: 
			[:exceptionHandler :category :signalNumber :exceptionArguments | 
			| anException |
			anException := SpAbstractError new.
			anException
				handler: exceptionHandler;
				gsCategory: category;
				gsSignalNumber: signalNumber;
				arguments: exceptionArguments.
			^anException].
	^aBlock value
%
! ------------------- Instance methods for SpExceptionContext

! Remove existing behavior from SpExceptionTests
doit
SpExceptionTests removeAllMethods.
SpExceptionTests class removeAllMethods.
%
! ------------------- Class methods for SpExceptionTests
category: ''testing''
classmethod: SpExceptionTests
test01
	"Just throw an exception"

	"SpExceptionTests test01"

	^SpError raiseSignal
%
category: ''testing''
classmethod: SpExceptionTests
test02
	"Catch an exception"

	"SpExceptionTests test02"

	SpExceptionContext 
		for: [self test01]
		on: SpError
		do: [:ex| ex halt]
%
category: ''testing''
classmethod: SpExceptionTests
test03
	"Raise an exception raised in a handle block"

	"SpExceptionTests test03"

	SpExceptionContext 
		for: [self test01]
		on: SpError
		do: [:ex| self test01]
%
category: ''testing''
classmethod: SpExceptionTests
test04
	"Catch an exception raised in a handle block"

	"SpExceptionTests test04"

	SpExceptionContext 
		for: [self test03]
		on: SpError
		do: [:ex| ex halt]
%
category: ''testing''
classmethod: SpExceptionTests
test05
	"Catch an exception by secifying a superclass of the raised exception class."

	"SpExceptionTests test05"

	SpExceptionContext 
		for: [self test01]
		on: SpAbstractError
		do: [:ex| ex halt]
%
! ------------------- Instance methods for SpExceptionTests'</body>
</methods>

<!-- Package SpTimes(2 012,janko)= -->


<component-property>
<name>SpTimes</name> <type>package</type>
<property>comment</property> <value>'©Bruce Badger 2004. Licensed under the LGPL.
'</value>
</component-property>

<class>
<name>SpTimesCodeForGemStone</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpTimes</category>
<attributes>
<package>SpTimes</package>
</attributes>
</class>

<class>
<name>SpDate</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>underlyingDate </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpTimes</category>
<attributes>
<package>SpTimes</package>
</attributes>
</class>

<class>
<name>SpTimesCodeForSqueak</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpTimes</category>
<attributes>
<package>SpTimes</package>
</attributes>
</class>

<class>
<name>SpTimestamp</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>underlyingTimestamp </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpTimes</category>
<attributes>
<package>SpTimes</package>
</attributes>
</class>





<methods>
<class-id>SpTimesCodeForSqueak class</class-id> <category>code strings</category>

<body package="SpTimes">codeString
	"^a String
	I return the string which is the source code for the OpenSkills GemStone time classes."

	"(Filename named: 'SpTimes-squeak.st') writeStream nextPutAll: self codeString; close"

	^'Object subclass: #SpDate
	instanceVariableNames: ''underlyingDate''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpTimes''!

!SpDate methodsFor: ''services'' stamp: ''BB 1/25/2006 15:47''!
addDays: anInteger 
	"^an OSkDate
I don''t change the date I represent.  Rather, I create a new date which represents my date offset by anInteger days."

	^SpDate fromDays: self asDays + anInteger! !

!SpDate methodsFor: ''services'' stamp: ''BB 1/25/2006 15:47''!
addYears: anInteger 
	"^an OSkDate
I don''t change the date I represent.  Rather, I create a new date which represents my date offset by anInteger years."

	^SpDate onDate: (Date 
				newDay: self underlyingDate dayOfMonth
				monthNumber: self underlyingDate monthIndex
				year: self underlyingDate year + anInteger)! !


!SpDate methodsFor: ''printing'' stamp: ''BB 1/25/2006 15:46''!
asISO8610String 
	|targetStream|
	targetStream := WriteStream on: String new.
	self asISO8610StringOn: targetStream.
	^targetStream contents! !

!SpDate methodsFor: ''printing'' stamp: ''BB 1/25/2006 15:46''!
asISO8610StringOn: aStream 
	aStream
		nextPutAll: self underlyingDate year printString;
		nextPut: $-.
	self underlyingDate monthIndex &lt; 10 ifTrue: [aStream nextPut: $0].
	aStream
		nextPutAll: self underlyingDate monthIndex printString;
		nextPut: $-.
	self underlyingDate dayOfMonth &lt; 10 ifTrue: [aStream nextPut: $0].
	aStream nextPutAll: self underlyingDate dayOfMonth printString.
	^self! !


!SpDate methodsFor: ''converting'' stamp: ''BB 1/25/2006 15:45''!
asDays
	"^an Integer
	I return the integer number of days between January 1, 1901 and
	the date I represent. "

	^self underlyingDate asDays! !


!SpDate methodsFor: ''comparing'' stamp: ''BB 1/25/2006 15:45''!
hash
	"^an Object"

	^self underlyingDate hash! !

!SpDate methodsFor: ''comparing'' stamp: ''BB 1/25/2006 15:44''!
&lt; anotherOSkDate 
	"^a Boolean
	Answer true if anotherOSkDate is less (i.e. earlier) than me."

	^self underlyingDate &lt; anotherOSkDate underlyingDate! !

!SpDate methodsFor: ''comparing'' stamp: ''BB 1/25/2006 15:45''!
= anotherOSkDate 
	"^a Boolean
	Answer true if anotherOSkDate is equivalent to me."

	^self underlyingDate = anotherOSkDate underlyingDate! !

!SpDate methodsFor: ''comparing'' stamp: ''BB 1/25/2006 15:45''!
&gt; anotherOSkDate 
	"^a Boolean
	Answer true if anotherOSkDate is greater (i.e. later) than me."

	^self underlyingDate &gt; anotherOSkDate underlyingDate! !


!SpDate methodsFor: ''accessing'' stamp: ''BB 1/25/2006 15:37''!
underlyingDate
	^underlyingDate! !


!SpDate methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 15:36''!
onDate: aDate 
	underlyingDate := aDate.
	^self! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpDate class
	instanceVariableNames: ''''!

!SpDate class methodsFor: ''prvate'' stamp: ''BB 1/25/2006 15:35''!
integerOfLength: aLength FromString: aString 
	"^an Integer or nil
	I parse an integer from aString, if I have problems I return nil.  I make sure
	the string form of the integer is exactly aLength characters long."

	"OSkDate integerOfLength: 4 FromString: ''2004''"

	^(aString size == aLength and: 
			[(aString asOrderedCollection select: [:aDigit | aDigit isDigit not]) 
				isEmpty]) 
		ifFalse: [nil]
		ifTrue: [aString asNumber]! !

!SpDate class methodsFor: ''prvate'' stamp: ''BB 1/25/2006 15:35''!
parseDateFromISO8601Stream: sourceStream 
	"^a Date or nil
	I parse an ISO 8601 date from sourceStream.  If there are any parsing
	problems, I return nil."
 
	| yyyy mm dd |
	yyyy := self integerOfLength: 4 FromString: (sourceStream upTo: $-).
	mm := self integerOfLength: 2 FromString: (sourceStream upTo: $-).
	dd := self integerOfLength: 2 FromString: (sourceStream next: 2).
	(yyyy isNil or: [mm isNil or: [dd isNil]]) ifTrue: [^nil].
	^SpExceptionContext 
		for: 
			[Date 
				newDay: dd
				monthNumber: mm
				year: yyyy]
		on: SpError
		do: [:ex | nil]! !


!SpDate class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:33''!
fromDays: anInteger
	^self new onDate: (Date fromDays: anInteger)! !

!SpDate class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:35''!
fromISO8610Stream: aStream 
	| date |
	date := SpExceptionContext 
				for: [self parseDateFromISO8601Stream: aStream]
				on: SpError
				do: [:ex | nil].
	^date isNil ifTrue: [nil] ifFalse: [self onDate: date]! !

!SpDate class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:36''!
fromISO8610String: aString 
	^aString size == 10 
		ifFalse: [nil]
		ifTrue: [self fromISO8610Stream: aString readStream]! !

!SpDate class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:36''!
onDate: aDate
	^self new onDate: aDate! !

!SpDate class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:36''!
today
	^self onDate: Date today! !


Object subclass: #SpTimestamp
	instanceVariableNames: ''underlyingTimestamp''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpTimes''!

!SpTimestamp methodsFor: ''private'' stamp: ''BB 1/25/2006 15:29''!
underlyingTimestamp
	^underlyingTimestamp! !


!SpTimestamp methodsFor: ''services'' stamp: ''BB 1/25/2006 15:31''!
asRFC1123String
	"^a String
	c.f  &gt;&gt;asRFC1123StringOn: "

	| targetStream |
	targetStream := String new writeStream.
	self asRFC1123StringOn: targetStream.
	^targetStream contents! !

!SpTimestamp methodsFor: ''services'' stamp: ''BB 1/29/2006 21:11''!
asRFC1123StringOn: targetStream 
	"^self
	Code taken from Swazoo Timestamp extenton with the following 
	comment: FIXME: Assumes server''s clock is GMT. Should convert server''s
	clock to GMT if it is not. Besides that, this whole method is really ugly."
	targetStream
		nextPutAll: (self underlyingTimestamp asDate weekday copyFrom: 1 to: 3);
		 nextPutAll: '', ''.
	self underlyingTimestamp day &lt; 10
		ifTrue: [targetStream nextPut: $0].
	self underlyingTimestamp asDate printOn: targetStream format: #(1 2 3 $  2 1 ).
	targetStream space.
	self underlyingTimestamp printHMSOn: targetStream.
	targetStream nextPutAll: '' GMT''! !

!SpTimestamp methodsFor: ''services'' stamp: ''BB 1/25/2006 15:31''!
asSeconds
	"^an Integer
I return the timestamp as a number of seconds."

	^self underlyingTimestamp asSeconds! !


!SpTimestamp methodsFor: ''comparing'' stamp: ''BB 1/25/2006 15:30''!
hash
	^self underlyingTimestamp hash! !

!SpTimestamp methodsFor: ''comparing'' stamp: ''BB 1/25/2006 15:28''!
&lt;= anOSkTimeStamp 
	^self underlyingTimestamp &lt;= anOSkTimeStamp underlyingTimestamp! !

!SpTimestamp methodsFor: ''comparing'' stamp: ''BB 1/25/2006 15:29''!
= anOSkTimeStamp
^self underlyingTimestamp = anOSkTimeStamp underlyingTimestamp! !

!SpTimestamp methodsFor: ''comparing'' stamp: ''BB 1/25/2006 15:30''!
&gt; anOSkTimeStamp
^self underlyingTimestamp &gt; anOSkTimeStamp underlyingTimestamp! !


!SpTimestamp methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 15:27''!
asNowUTC
	"^self
Cheat for now and assumen that Timestamp&gt;&gt;now is UTC."

	underlyingTimestamp := TimeStamp now.
	^self! !

!SpTimestamp methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 15:27''!
fromDate: aDate andTime: aTime 
	"^self
Initialize myself on the basis of aDate and aTime."

	underlyingTimestamp := TimeStamp fromDate: aDate andTime: aTime.
	^self! !

!SpTimestamp methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 15:28''!
fromSeconds: anInteger 
	"^an OSkTimestamp
I return an instance of myself that represents anInteger number of seconds since January 1, 1901 0:00:00.000.  BTW, negative values of anInteger are fine."

	underlyingTimestamp := TimeStamp fromSeconds: anInteger.
	^self! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpTimestamp class
	instanceVariableNames: ''''!

!SpTimestamp class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:26''!
fromDate: aDate andTime: aTime 
	^self new fromDate: aDate andTime: aTime! !

!SpTimestamp class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:26''!
fromRFC1123String: aString 
	"^an OSkTimestamp"

	| sourceStream dd mmm yyyy time |
	^SpExceptionContext for: 
			[sourceStream := ReadStream on: aString.
			sourceStream upTo: Character space.
			dd := sourceStream upTo: Character space.
			mmm := sourceStream upTo: Character space.
			yyyy := sourceStream upTo: Character space.
			time := sourceStream upTo: Character space.
			self fromDate: (Date 
						newDay: dd asNumber
						month: mmm
						year: yyyy asNumber)
				andTime: (Time readFrom: (ReadStream on: time))]
		onAnyExceptionDo: 
			[:exception | 
			SpError raiseSignal: ''Error parsing RFC1123 date: '' , aString]! !

!SpTimestamp class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:26''!
fromSeconds: anInteger 
	"^an OSkTimestamp
I return an instance of myself that represents anInteger number of seconds since ..."

	^self new fromSeconds: anInteger! !

!SpTimestamp class methodsFor: ''instance creation'' stamp: ''BB 1/25/2006 15:26''!
now
	"^an OSkTimestamp
	I return a new instance of myself which represents the time now in the
	UTC (GMT ish) time zone."

	^self new asNowUTC! !
'</body>
</methods>


<methods>
<class-id>SpDate class</class-id> <category>private</category>

<body package="SpTimes">parseDateFromISO8601Stream: sourceStream 
	"^a Date or nil
	I parse an ISO 8601 date from sourceStream.  If there are any parsing
	problems, I return nil."

	| yyyy mm dd |
	yyyy := self integerOfLength: 4 FromString: (sourceStream upTo: $-).
	mm := self integerOfLength: 2 FromString: (sourceStream upTo: $-).
	dd := self integerOfLength: 2 FromString: (sourceStream next: 2).
	(yyyy isNil or: [mm isNil or: [dd isNil]]) ifTrue: [^nil].
	^SpExceptionContext 
		for: 
			[Date 
				newDay: dd
				monthNumber: mm
				year: yyyy]
		on: GenericException
		do: [:ex | nil]</body>

<body package="SpTimes">integerOfLength: aLength FromString: aString 
	"^an Integer or nil
	I parse an integer from aString, if I have problems I return nil.  I make sure
	the string form of the integer is exactly aLength characters long."

	"OSkDate integerOfLength: 4 FromString: '2004'"

	^(aString size == aLength and: 
			[(aString asOrderedCollection select: [:aDigit | aDigit isDigit not]) 
				isEmpty]) 
		ifFalse: [nil]
		ifTrue: [aString asNumber]</body>
</methods>

<methods>
<class-id>SpDate class</class-id> <category>instanceCreation</category>

<body package="SpTimes">fromISO8610String: aString 
	^aString size == 10 
		ifFalse: [nil]
		ifTrue: [self fromISO8610Stream: aString readStream]</body>

<body package="SpTimes">fromDays: anInteger
	^self new onDate: (Date fromDays: anInteger)</body>

<body package="SpTimes">fromISO8610Stream: aStream 
	| date |
	date := SpExceptionContext 
				for: [self parseDateFromISO8601Stream: aStream]
				on: SpError
				do: [:ex | nil].
	^date isNil ifTrue: [nil] ifFalse: [self onDate: date]</body>

<body package="SpTimes">today
	^self onDate: Date today</body>

<body package="SpTimes">onDate: aDate
	^self new onDate: aDate</body>
</methods>


<methods>
<class-id>SpDate</class-id> <category>printing</category>

<body package="SpTimes">asISO8610String
	|targetStream|
	targetStream := WriteStream on: String new.
	self asISO8610StringOn: targetStream.
	^targetStream contents</body>

<body package="SpTimes">asISO8610StringOn: aStream 
	aStream
		nextPutAll: self underlyingDate year printString;
		nextPut: $-.
	self underlyingDate monthIndex &lt; 10 ifTrue: [aStream nextPut: $0].
	aStream
		nextPutAll: self underlyingDate monthIndex printString;
		nextPut: $-.
	self underlyingDate dayOfMonth &lt; 10 ifTrue: [aStream nextPut: $0].
	aStream nextPutAll: self underlyingDate dayOfMonth printString.
	^self</body>

<body package="SpTimes">printOn: aStream 
	self asISO8610StringOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>SpDate</class-id> <category>converting</category>

<body package="SpTimes">asDays
	"^an Integer
	I return the integer number of days between January 1, 1901 and
	the date I represent. "

	^self underlyingDate asDays</body>
</methods>

<methods>
<class-id>SpDate</class-id> <category>initialize-release</category>

<body package="SpTimes">onDate: aDate 
	underlyingDate := aDate.
	^self</body>
</methods>

<methods>
<class-id>SpDate</class-id> <category>accessing</category>

<body package="SpTimes">underlyingDate
	^underlyingDate</body>
</methods>

<methods>
<class-id>SpDate</class-id> <category>services</category>

<body package="SpTimes">addDays: anInteger 
	"^an OSkDate
I don't change the date I represent.  Rather, I create a new date which represents my date offset by anInteger days."

	^SpDate fromDays: self asDays + anInteger</body>

<body package="SpTimes">addYears: anInteger 
	"^an OSkDate
I don't change the date I represent.  Rather, I create a new date which represents my date offset by anInteger years.  If we are adding years to the 29th Feb, we need to worry about leap years. "

	| newDayNumber |
	newDayNumber := (self underlyingDate monthIndex == 2 
				and: [self underlyingDate dayOfMonth == 29]) 
					ifTrue: [anInteger \\ 4 == 0 ifTrue: [29] ifFalse: [28]]
					ifFalse: [self underlyingDate dayOfMonth].
	^SpDate onDate: (Date 
				newDay: newDayNumber
				monthNumber: self underlyingDate monthIndex
				year: self underlyingDate year + anInteger)</body>
</methods>

<methods>
<class-id>SpDate</class-id> <category>comparing</category>

<body package="SpTimes">&gt; anotherOSkDate 
	"^a Boolean
	Answer true if anotherOSkDate is greater (i.e. later) than me."

	^self underlyingDate &gt; anotherOSkDate underlyingDate</body>

<body package="SpTimes">min: anSpDate 
	^self &lt; anSpDate ifTrue: [self] ifFalse: [anSpDate]</body>

<body package="SpTimes">max: anSpDate 
	^self &gt; anSpDate ifTrue: [self] ifFalse: [anSpDate]</body>

<body package="SpTimes">= anotherOSkDate 
	"^a Boolean
	Answer true if anotherOSkDate is equivalent to me."

	^self underlyingDate = anotherOSkDate underlyingDate</body>

<body package="SpTimes">&lt; anotherOSkDate 
	"^a Boolean
	Answer true if anotherOSkDate is less (i.e. earlier) than me."

	^self underlyingDate &lt; anotherOSkDate underlyingDate</body>

<body package="SpTimes">hash
	"^an Object"

	^self underlyingDate hash</body>
</methods>


<methods>
<class-id>SpTimesCodeForGemStone class</class-id> <category>code strings</category>

<body package="SpTimes">codeString
	"^a String
	I return the string which is the source code for the OpenSkills GemStone time classes."

	"(Filename named: 'SpTimes.gs') writeStream nextPutAll: self codeString; close"

	^'!
! From ! GEMSTONE: 6.1, Thu Apr 17 20:11:38 US/Pacific 2003; IMAGE: GemStone v6.1 kernel classes filein completed at 17/04/2003 20:22:36

! GemStone v6.1 kernel classes filein of stripped sources completed at 17/04/2003 20:31:50

! 

! On August 12, 2004, 11:35:53 am
!
!
! SymbolDictionary ''SpTimes''
!
run
| symList newDict |
symList := System myUserProfile symbolList.
symList do: [ :element |
    (element includesKey: #SpTimes)
        ifTrue: [ ^element ]
].
newDict := SymbolDictionary new.
newDict at: #SpTimes put: newDict.
System myUserProfile insertDictionary: newDict at: 1.
^newDict
%
doit
(Object subclass: ''SpDate''  instVarNames: #( underlyingDate)  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpTimes  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpTimestamp''  instVarNames: #( underlyingTimestamp)  classVars: #()  classInstVars: #( threeCharacterWeekDayName)  poolDictionaries: #[]  inDictionary: SpTimes  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
SpDate immediateInvariant.
%
doit
SpTimestamp immediateInvariant.
%

! Remove existing behavior from SpDate
doit
SpDate removeAllMethods.
SpDate class removeAllMethods.
%
! ------------------- Class methods for SpDate
category: ''instance creation''
classmethod: SpDate
fromDays: numberOfDays
	"Answer with an instance of Date that is dayCount days since 1901 began."
	"This is based on the VisualWorks implementation."
	| aDate correction |
	aDate := self
		newDay: 1 + (numberOfDays rem: 1461)
							"There are 1461 days in a 4-year cycle.
							 This doesn''t handle leap-centuries quite right:
							 we fix this up below."
		year: 1901 + ((numberOfDays quo: 1461) * 4).
	"Now correct for leap-centuries."
	correction := numberOfDays - aDate asDays.
	^correction = 0
		ifTrue: [aDate]
		ifFalse: [aDate addDays: correction]
%
category: ''instance creation''
classmethod: SpDate
fromISO8610Stream: aStream 
	| date |
	date := SpExceptionContext 
				for: [self parseDateFromISO8601Stream: aStream]
				on: SpError
				do: [:ex | nil].
	^date isNil ifTrue: [nil] ifFalse: [self onDate: date]
%
category: ''instance creation''
classmethod: SpDate
fromISO8610String: aString
	^self fromISO8610Stream: aString readStream
%
category: ''instance creation''
classmethod: SpDate
newDay: julianDay year: year
"^an SpDate
I return a new instance of myself."

	^self onDate: (Date newDay: julianDay year: year)
%
category: ''instance creation''
classmethod: SpDate
onDate: aDate
	^self new onDate: aDate
%
category: ''instance creation''
classmethod: SpDate
today
	^self onDate: Date today
%
category: ''private''
classmethod: SpDate
integerOfLength: aLength FromString: aString 
	"^an Integer or nil
	I parse an integer from aString, if I have problems I return nil.  I make sure
	the string form of the integer is exactly aLength characters long."

	"SpDate integerOfLength: 4 FromString: ''2004''"

	^(aString size == aLength and: 
			[(aString asOrderedCollection select: [:aDigit | aDigit isDigit not]) 
				isEmpty]) 
		ifFalse: [nil]
		ifTrue: [aString asNumber]
%
category: ''private''
classmethod: SpDate
parseDateFromISO8601Stream: sourceStream 
	"^a Date or nil
	I parse an ISO 8601 date from sourceStream.  If there are any parsing
	problems, I return nil."

	"SpDate parseDateFromISO8601Stream: (ReadStream on: ''2004-01-42'')"

	| yyyy mm dd |
	yyyy := self integerOfLength: 4 FromString: (sourceStream upTo: $-).
	mm := self integerOfLength: 2 FromString: (sourceStream upTo: $-).
	sourceStream atEnd ifFalse: [
		dd := self integerOfLength: 2 FromString: sourceStream upToEnd].
	(yyyy isNil or: [mm isNil or: [dd isNil]]) ifTrue: [^nil].
	^SpExceptionContext 
		for: 
			[Date 
				newDay: dd
				monthNumber: mm
				year: yyyy]
		on: SpError
		do: [:ex | nil]
%
! ------------------- Instance methods for SpDate
category: ''accessing''
method: SpDate
underlyingDate
	^underlyingDate
%
category: ''comparing'' 
method: SpDate
&lt; anotherSpDate 
        "^a Boolean
        Answer true if anotherSpDate is less (i.e. earlier) than me."

        ^self underlyingDate &lt; anotherSpDate underlyingDate
%
category: ''comparing''
method: SpDate
= anotherSpDate 
	"^a Boolean
	Answer true if anotherSpDate is equivalent to me."

	^self underlyingDate = anotherSpDate underlyingDate
%
category: ''comparing''
method: SpDate
&gt; anotherSpDate
        "^a Boolean
        Answer true if anotherSpDate is greater (i.e. later) than me."

        ^self underlyingDate &gt; anotherSpDate underlyingDate
%
category: ''comparing''
method: SpDate
hash
	"^an Object"

	^self underlyingDate hash
%
category: ''converting''
method: SpDate
asDays
	"^an Integer
	I return the integer number of days between January 1, 1901 and
	the date I represent. 
	This is the VisualWorks implementation."

	| yearIndex |
	yearIndex := self year - 1901.
	^yearIndex * 365  "elapsed years"
		+ (yearIndex // 4)  "ordinary leap years"
		+ ((yearIndex + 300) // 400)  "leap centuries, first one is 2000, i.e. yearIndex = 99"
		- (yearIndex // 100)  "non-leap centuries"
		+ self julianDay - 1
%
category: ''initialize-release''
method: SpDate
onDate: aDate 
	underlyingDate := aDate.
	^self
%
category: ''printing''
method: SpDate
asISO8610String
	|targetStream|
	targetStream := WriteStream on: String new.
	self asISO8610StringOn: targetStream.
	^targetStream contents
%
category: ''printing''
method: SpDate
asISO8610StringOn: aStream 
	aStream
		nextPutAll: self underlyingDate year printString;
		nextPut: $-.
	self underlyingDate monthIndex &lt; 10 ifTrue: [aStream nextPut: $0].
	aStream
		nextPutAll: self underlyingDate monthIndex printString;
		nextPut: $-.
	self underlyingDate dayOfMonth &lt; 10 ifTrue: [aStream nextPut: $0].
	aStream nextPutAll: self underlyingDate dayOfMonth printString.
	^self
%
category: ''services''
method: SpDate
addDays: anInteger
	^self class onDate: (self underlyingDate addDays: anInteger)
%
category: ''services''
method: SpDate
julianDay
"^an Integer
I return my julian day number.  Jan 1st is 1."
	^self underlyingDate dayOfYear
%
category: ''services''
method: SpDate
year
"^an Integer
I return my year as an Integer."
	^self underlyingDate year
%

! Remove existing behavior from SpTimestamp
doit
SpTimestamp removeAllMethods.
SpTimestamp class removeAllMethods.
%
! ------------------- Class methods for SpTimestamp
category: ''instance creation''
classmethod: SpTimestamp
fromDate: aDate andTime: aTime 
	^self new fromDate: aDate andTime: aTime
%
category: ''instance creation''
classmethod: SpTimestamp
fromRFC1123String: aString 
	"^an SpTimestamp"

	| sourceStream dd mmm yyyy time |
	^SpExceptionContext 
		for: 
			[sourceStream := ReadStream on: aString.
			sourceStream upTo: Character space.
			dd := sourceStream upTo: Character space.
			mmm := sourceStream upTo: Character space.
			yyyy := sourceStream upTo: Character space.
			time := sourceStream upTo: Character space.
			self fromDate: (Date 
						newDay: dd asNumber
						month: mmm
						year: yyyy asNumber)
				andTime: (Time fromString:  time)]
		on: Exception
		do: [:exception | SpError raiseSignal: ''Error parsing RFC1123 date: '' , aString]
%
category: ''instance creation''
classmethod: SpTimestamp
now
	"^an SpTimestamp
	I return a new instance of myself which represents the time now in the
	UTC (GMT ish) time zone."

	^self new asNowUTC
%
category: ''statics''
classmethod: SpTimestamp
threeCharacterWeekDayName
%
category: ''statics''
classmethod: SpTimestamp
threeCharacterWeekDayNames
"^an Array
I return the array of strings which are the three character abriviations of the names of the days of the week.  Starting on Monday."

	^#(''Mon'' ''Tue'' ''Wed'' ''Thu'' ''Fri'' ''Sat'' ''Sun'')
%
! ------------------- Instance methods for SpTimestamp
category: ''comparing''
method: SpTimestamp
&lt;= anSpTimeStamp 
	^self underlyingTimestamp &lt;= anSpTimeStamp underlyingTimestamp
%
category: ''comparing''
method: SpTimestamp
= anSpTimeStamp
^self underlyingTimestamp = anSpTimeStamp underlyingTimestamp
%
category: ''comparing''
method: SpTimestamp
&gt; anSpTimeStamp
^self underlyingTimestamp &gt; anSpTimeStamp underlyingTimestamp
%
category: ''initialize-release''
method: SpTimestamp
asNowUTC
	"^self
	Cheat for now and assumen that DateTime&gt;&gt;now is UTC."

	underlyingTimestamp := DateTime now.
	^self
%
category: ''initialize-release''
method: SpTimestamp
fromDate: aDate andTime: aTime 
	"^self
Initialize myself on the basis of aDate and aTime."

	underlyingTimestamp := DateTime newWithDate: aDate time: aTime.
	^self
%
category: ''printing''
method: SpTimestamp
asRFC1123String
	"^a String
	c.f  &gt;&gt;asRFC1123StringOn: "

	| targetStream |
	targetStream := WriteStream on: String new.
	self asRFC1123StringOn: targetStream.
	^targetStream contents
%
category: ''printing''
method: SpTimestamp
asRFC1123StringOn: targetStream
	"^a self
	I write a string representing my underlying DataTime of the form:
		Tue, 23 Mar 2004 15:24:12 GMT
	to targetStream"
	"SpTimestamp now asRFC1123String"

	targetStream
		nextPutAll: (self class threeCharacterWeekDayNames 
					at: self underlyingTimestamp dayOfWeek);
		nextPutAll: '', '';
		nextPutAll: (self underlyingTimestamp
					asStringUsingFormat: #(1 2 3 $  2 1 $: true true false));
		nextPutAll: '' GMT''.
	^self
%
category: ''private''
method: SpTimestamp
underlyingTimestamp
	^underlyingTimestamp
%'</body>
</methods>


<methods>
<class-id>SpTimestamp class</class-id> <category>instance creation</category>

<body package="SpTimes">now
	"^an OSkTimestamp
	I return a new instance of myself which represents the time now in the
	UTC (GMT ish) time zone."

	^self new asNowUTC</body>

<body package="SpTimes">fromDate: aDate andTime: aTime 
	^self new fromDate: aDate andTime: aTime</body>

<body package="SpTimes">fromSeconds: anInteger 
	"^an OSkTimestamp
I return an instance of myself that represents anInteger number of seconds since ..."

	^self new fromSeconds: anInteger</body>

<body package="SpTimes">fromRFC1123String: aString 
	"^an OSkTimestamp"

	| sourceStream dd mmm yyyy time |
	^SpExceptionContext for: 
			[sourceStream := ReadStream on: aString.
			sourceStream upTo: Character space.
			dd := sourceStream upTo: Character space.
			mmm := sourceStream upTo: Character space.
			yyyy := sourceStream upTo: Character space.
			time := sourceStream upTo: Character space.
			self fromDate: (Date 
						newDay: dd asNumber
						month: mmm
						year: yyyy asNumber)
				andTime: (Time readFrom: (ReadStream on: time))]
		onAnyExceptionDo: 
			[:exception | 
			SpError raiseSignal: 'Error parsing RFC1123 date: ' , aString]</body>
</methods>


<methods>
<class-id>SpTimestamp</class-id> <category>services</category>

<body package="SpTimes">asRFC1123String
	"^a String
	c.f  &gt;&gt;asRFC1123StringOn: "

	| targetStream |
	targetStream := String new writeStream.
	self asRFC1123StringOn: targetStream.
	^targetStream contents</body>

<body package="SpTimes">asSeconds
	"^an Integer
I return the timestamp as a number of seconds."

	^self underlyingTimestamp asSeconds</body>

<body package="SpTimes">asRFC1123StringOn: targetStream
	"^self
	Code taken from Swazoo Timestamp extenton with the following comment:
	FIXME: Assumes server's clock is GMT.  Should convert server's clock to GMT if it is not.  Besides that, this whole method is really ugly."


	targetStream nextPutAll: (self underlyingTimestamp asDate weekday copyFrom: 1 to: 3);
	nextPutAll: ', '.
	self underlyingTimestamp day &lt; 10 ifTrue: [targetStream nextPut: $0].
	self underlyingTimestamp asDate printOn: targetStream format: #(1 2 3 $  2 1).
	targetStream space.
	self underlyingTimestamp hour 
		printOn: targetStream
		paddedWith: $0
		to: 2
		base: 10.
	targetStream nextPut: $:.
	self underlyingTimestamp minute 
		printOn: targetStream
		paddedWith: $0
		to: 2
		base: 10.
	targetStream nextPut: $:.
	self underlyingTimestamp second 
		printOn: targetStream
		paddedWith: $0
		to: 2
		base: 10.
	targetStream nextPutAll: ' GMT'.
	^self</body>
</methods>

<methods>
<class-id>SpTimestamp</class-id> <category>comparing</category>

<body package="SpTimes">hash
	^self underlyingTimestamp hash</body>

<body package="SpTimes">&lt;= anOSkTimeStamp 
	^self underlyingTimestamp &lt;= anOSkTimeStamp underlyingTimestamp</body>

<body package="SpTimes">= anOSkTimeStamp
^self underlyingTimestamp = anOSkTimeStamp underlyingTimestamp</body>

<body package="SpTimes">&gt; anOSkTimeStamp
^self underlyingTimestamp &gt; anOSkTimeStamp underlyingTimestamp</body>
</methods>

<methods>
<class-id>SpTimestamp</class-id> <category>initialize-release</category>

<body package="SpTimes">asNowUTC
	"^self
Cheat for now and assumen that Timestamp&gt;&gt;now is UTC."

	underlyingTimestamp := Timestamp now.
	^self</body>

<body package="SpTimes">fromDate: aDate andTime: aTime 
	"^self
Initialize myself on the basis of aDate and aTime."

	underlyingTimestamp := Timestamp fromDate: aDate andTime: aTime.
	^self</body>

<body package="SpTimes">fromSeconds: anInteger 
	"^an OSkTimestamp
I return an instance of myself that represents anInteger number of seconds since January 1, 1901 0:00:00.000.  BTW, negative values of anInteger are fine."

	underlyingTimestamp := Timestamp fromSeconds: anInteger.
	^self</body>
</methods>

<methods>
<class-id>SpTimestamp</class-id> <category>private</category>

<body package="SpTimes">underlyingTimestamp
	^underlyingTimestamp</body>
</methods>

<!-- Package SpSockets(2 012,janko)= -->


<component-property>
<name>SpSockets</name> <type>package</type>
<property>comment</property> <value>'©Bruce Badger 2004. Licensed under the LGPL.

See the comment on the OSkSocket class.  For background information, see the "man socket" man page on Linux.'</value>
</component-property>

<class>
<name>SpSocketAddress</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpSockets</category>
<attributes>
<package>SpSockets</package>
</attributes>
</class>

<class>
<name>SpSocket</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>communicationDomain socketType protocolNumber underlyingSocket </inst-vars>
<class-inst-vars>addressFamilies protocolFamilies socketTypes socketOptionLevels socketOptions fileControlOptions </class-inst-vars>
<imports></imports>
<category>SpSockets</category>
<attributes>
<package>SpSockets</package>
</attributes>
</class>

<comment>
<class-id>SpSocket</class-id>
<body>OSkSocket  instances represent BSD sockets.  The idea here is to stick as closely to the BSD (Posix) spec terminology as possible.  I've cheated and taken the Linux man pages as being a good description of BSD sockets, and all the names etc are taken from the linux man pages (start with man socket).

The key steps in using a BSD socket for a server is:
	o int socket(int domain, int type, int protocol) [see: man socket]
		- create a new instance of a socket  where domain is the protocol
		 family (see below), type is the communication semantics (see below)
		 and protocol is a specific protocol (though there is usually only one
		 protocol for a given domain/type combination).
		 See: OSkSocket class&gt;&gt;forDomain:type:protocol:
	o  int  bind(int  sockfd, struct sockaddr *my_addr, socklen_t addrlen) [see: man bind]
		- let the socket know what address it is representing.  sockfd is the id of 
		 the socket, sockaddr is the address to be represented and addrlen is 
		 the length in bytes of the address. 
		 See OSkSocket&gt;&gt;bindSocketAddress: 
	o int listen(int s, int backlog) [see: man listen]
		- have the socket s listen for inbound requests, and allow up to backlog
		 requests to be queued at any one time.
		 See OSkSocket&gt;&gt;listenBackloggingUpTo: 
	o  int   accept(int   s,  struct  sockaddr  *addr,  socklen_t *addrlen) [see: man accept]
		- accept the next inbound request from the backlog.  Accept the request from
		 socket s, and spawn a new socket to handle the request (freeing s to accept
		 the next accept).  The new socket if defined in sockaddr which has a length of
		 addrlen..
		 See OSkSocket&gt;&gt;accept

For sockets connecting to existing server sockets, the steps are"
	o socket() [as above]
	o  int  connect(int sockfd, const struct sockaddr *serv_addr, socklen_t addrlen)
		- Have socket sockfd connect to the remote socket at serv_addr (where serv_addr
		 is addrlen bytes long).  
		 See OSkSocket&gt;&gt;connectTo:

A socket appears in many ways to be a file descriptor, and the regular read and write operations can be used once a socket is open.  Accordingly, some of the file control (man fcntl) options can be used.  Of particular interest is the idea of blocking and non-blocking operation.

Blocking is the default mode for an active socket.  This means that (for example) when reading from a socket the entire process(!) blocks waiting for the read operation to complete.  In non-blocking mode the same read operation would return immediately, but might not return anything useful.

See man accept for more information on blocking/non-blocking.

So, roughly speaking, blocking is easier to program for because you code as if the read always gets something.  A blocking interface is harder because you have to check if you got something, and try again later if you didn't - but non-blocking lets the process get on with other things while your thread is waiting, and this can be a Very Good Thing.

Now, VisualWorks seems to interpret blocking to be per Smalltalk Process.  To make this work, the VisualWorks socket implementation always asks the operating system for non-blocking sockets, but presents these as approproate (blocking or non-blocking) to the Smalltalk Process.  This means that work can continue in a VisualWorks VM even when a socket is being used in (apparantly) blocking mode.

A GemStone Gem asks the operating system for the kind of socket asked for by the Process.  So, if a request is made for a blocking socket, the entire Gem blocks on reads from that socket. 

Just beware the difference between blocking and non-blocking sockets, and also of the differing implemenmtations between Smalltalk dialects.


</body>
</comment>

<class>
<name>SpSocketsCodeForSqueak</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpSockets</category>
<attributes>
<package>SpSockets</package>
</attributes>
</class>

<class>
<name>SpSocketsCodeForGemStone</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpSockets</category>
<attributes>
<package>SpSockets</package>
</attributes>
</class>

<class>
<name>SpIPAddress</name>
<environment>Smalltalk</environment>
<super>SpSocketAddress</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>hostAddress portNumber </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpSockets</category>
<attributes>
<package>SpSockets</package>
</attributes>
</class>

<class>
<name>SpSocketError</name>
<environment>Smalltalk</environment>
<super>SpError</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpSockets</category>
<attributes>
<package>SpSockets</package>
</attributes>
</class>







<methods>
<class-id>SpSocket class</class-id> <category>services</category>

<body package="SpSockets">initialize
	^self resetAllDefinedValues</body>

<body package="SpSockets">newSocketPair
	"^an Array
	I return an array containing two OSkSockets each representing one end of a
	#PF_UNIX connection."

	^self socketPairForDomain: #PF_UNIX type: #SOCK_STREAM</body>
</methods>

<methods>
<class-id>SpSocket class</class-id> <category>instance creation - private</category>

<body package="SpSockets">forDomain: aCommunicationsDomain type: aSocketType 
	"^an OSkSocket
	Default the protocol to zero - this is the default  in the Spec anyway.  See man socket.."

	^self 
		forDomain: aCommunicationsDomain
		type: aSocketType
		protocol: 0</body>

<body package="SpSockets">socketPairForDomain: aCommunicationsDomain type: aSocketType 
	"^an OSkSocket
	see: man socketpair
	Default the protocol to zero - this is the default  in the Spec anyway. "

	^self 
		socketPairForDomain: aCommunicationsDomain
		type: aSocketType
		protocol: 0</body>

<body package="SpSockets">forDomain: aDomainSymbol type: aSocketTypeSymbol protocol: aProtocolNumber 
	"^an OSkSocket
	Equivalent of int socket(int domain, int type, int protocol);  see man socket.
	I return a new instance of myself that represents a socket configured for the
	specified domain type and protocol ."

	| newNativeSocket |
	newNativeSocket := SocketAccessor 
				family: (self protocolFamilies at: aDomainSymbol)
				type: (self socketTypes at: aSocketTypeSymbol).
	^self new 
		onNativeSocket: newNativeSocket
		forDomain: aDomainSymbol
		type: aSocketTypeSymbol
		protocol: aProtocolNumber</body>

<body package="SpSockets">socketPairForDomain: aDomainSymbol type: aTypeSymbol protocol: aProtocolNumber 
	"^an OSkSocket
	See: man socketpair
	Equivalent of int socketpair(int d, int type, int protocol, int sv[2]); 
	I return and array containing two new instances of myself each representing
	one end of a connection.
	Note that VW does not let one specify the domain/type/protocol of the pair, but
	they seem to be redundant anyway since #PF_UNIX (aka #PF_LOCAL.) is all that
	is supported by BSD sockets (in Linux) anyway."

	^SocketAccessor openPair collect: 
			[:newNativeSocket | 
			self new 
				onNativeSocket: newNativeSocket
				forDomain: aDomainSymbol
				type: aTypeSymbol
				protocol: aProtocolNumber]</body>
</methods>

<methods>
<class-id>SpSocket class</class-id> <category>private</category>

<body package="SpSockets">onNativeclientSocket: aNativeSocket for: aServerSocket 
	"^an OSkSocket
I create a new instance of my self at the request of aServerSocket  where
this new instance will be a connected client socket (connected via aNativeSoket)."

	^self new onNativeclientSocket: aNativeSocket for: aServerSocket</body>

<body package="SpSockets">resetAllDefinedValues
	"^self
	I simply set the all the symbol dictionaries containing defined values to
	nil, forcing them to be re-initialized on demand."

	"OSkSocket resetAllDefinedValues"

	addressFamilies := nil.
	protocolFamilies := nil.
	socketTypes := nil.
	fileControlOptions := nil.
	^self</body>
</methods>

<methods>
<class-id>SpSocket class</class-id> <category>defined symbols</category>

<body package="SpSockets">socketTypes
	"^an IdentityDictionary
	I return the dictionary mapping each defined socket type symbol to it's numeric
	value.  See socket.h and look for the #define SOCK_xxx lines.
	If you modify this method, evaluate the following:
		'OSkSocket resetAllDefinedValues' "

	socketTypes isNil 
		ifTrue: 
			[socketTypes := (IdentityDictionary new)
						at: #SOCK_STREAM put: 1;
						yourself].
	^socketTypes</body>

<body package="SpSockets">fileControlOptions
	"^an IdentityDictionary
	I return the dictionary mapping each defined file control symbol to it's numeric
	value.  See fcntl.h and look for the at: #O_xxx lines.
	Really this is here for the O_NONBLOCK option which sets the fd (file descriptor)
	of a socket to non-blocking mode when used in an fcntl() function.
	If you modify this method, evaluate the following:
		'OSkSocket resetAllDefinedValues' "

	fileControlOptions isNil 
		ifTrue: 
			[fileControlOptions := (IdentityDictionary new)
						at: #O_ACCMODE put: 0003;
						at: #O_RDONLY put: 00;
						at: #O_WRONLY put: 01;
						at: #O_RDWR put: 02;
						at: #O_CREAT put: 0100;
						at: #O_EXCL put: 0200;
						at: #O_NOCTTY put: 0400;
						at: #O_TRUNC put: 01000;
						at: #O_APPEND put: 02000;
						at: #O_NONBLOCK put: 04000;
						at: #O_NDELAY put: 04000;
						at: #O_SYNC put: 010000;
						at: #FASYNC put: 020000;
						at: #O_DIRECT put: 040000;
						at: #O_LARGEFILE put: 0100000;
						at: #O_DIRECTORY put: 0200000;
						at: #O_NOFOLLOW put: 0400000;
						yourself].
	^fileControlOptions</body>

<body package="SpSockets">addressFamilies
	"^an IdentityDictionary
	I return the dictionary mapping each defined address family symbol to it's numeric
	value.  See socket.h and look for the #def AF_xxx lines.
	If you modify this method, evaluate the following:
		'OSkSocket resetAllDefinedValues' "

	addressFamilies isNil 
		ifTrue: 
			[addressFamilies := (IdentityDictionary new)
						at: #AF_UNIX put: 1;
						at: #AF_LOCAL put: 1;
						at: #AF_INET put: 2;
						yourself].
	^addressFamilies</body>

<body package="SpSockets">socketOptionLevels
	"^an IdentityDictionary
	I return the dictionary mapping each defined socket option level symbol to it's numeric
	value.  See socket.h and look for the #define SOL_xxx lines.
	If you modify this method, evaluate the following:
		'OSkSocket resetAllDefinedValues' "

	socketOptionLevels isNil 
		ifTrue: 
			[socketOptionLevels := (IdentityDictionary new)
						at: #SOL_SOCKET put: 1;
						yourself].
	^socketOptionLevels</body>

<body package="SpSockets">protocolFamilies
	"^an IdentityDictionary
	I return the dictionary mapping each defined protocol family symbol to it's numeric
	value.  See socket.h and look for the #def PF_xxx lines.
	If you modify this method, evaluate the following:
		'OSkSocket resetAllDefinedValues' "

	protocolFamilies isNil 
		ifTrue: 
			[protocolFamilies := (IdentityDictionary new)
						at: #PF_UNIX put: (self addressFamilies at: #AF_UNIX);
						at: #PF_LOCAL put: (self addressFamilies at: #AF_LOCAL);
						at: #PF_INET put: (self addressFamilies at: #AF_INET);
						yourself].
	^protocolFamilies</body>

<body package="SpSockets">socketOptions
	"^an IdentityDictionary
	I return the dictionary mapping each defined socket option symbol to it's numeric
	value.  See socket.h and look for the #define SO_xxx lines.
	If you modify this method, evaluate the following:
		'OSkSocket resetAllDefinedValues' "

	socketOptions isNil 
		ifTrue: 
			[socketOptions := (IdentityDictionary new)
						at: #SO_REUSEADDR put: 2;
						yourself].
	^socketOptions</body>
</methods>

<methods>
<class-id>SpSocket class</class-id> <category>instance creation</category>

<body package="SpSockets">newTCPSocket
	"^an OSkSocket
	I create and return a new socket configured to be of a streaming type handle the 
	IPv4 protocol family (default protocol).  This is a tcp_socket (see man 7 ip)."

	^self forDomain: #PF_INET type: #SOCK_STREAM</body>

<body package="SpSockets">connectToServerOnHost: hostName port: portNumber 
	"^an OSkSocket 
	I return a new instance of myself which represents a socket connecter to a server listening on portNumber at hostName."

	| newSocket |
	newSocket := self newTCPSocket.
	newSocket connectTo: (SpIPAddress hostName: hostName port: portNumber).
	^newSocket</body>
</methods>


<methods>
<class-id>SpSocket</class-id> <category>initialize-release</category>

<body package="SpSockets">onNativeSocket: aSocket forDomain: aCommunicationDomain type: aSocketType protocol: aProtocolNumber 
	"^self
	I initialize myself as a socket defined by the communications domain, type and protocol.  This
	follows the equivalent of the using the socket()  or socketpair() function."

	communicationDomain := aCommunicationDomain.
	socketType := aSocketType.
	protocolNumber := aProtocolNumber.
	underlyingSocket := aSocket.
	^self</body>
</methods>

<methods>
<class-id>SpSocket</class-id> <category>testing</category>

<body package="SpSockets">isActive
	^self underlyingSocket isActive</body>
</methods>

<methods>
<class-id>SpSocket</class-id> <category>services-accessing</category>

<body package="SpSockets">getPeerName
	"^an OSkSocketAddress
	see man getpeername.
	I return the socket address of the other/remote/peer end of the socket I represent."

	^SpSocketAddress on: self underlyingSocket getPeer for: self</body>

<body package="SpSockets">getSocketName
	"^an OSkSocketAddress
	see: man getsockname
	I return my local socket address which may be any subclass of 
	OSkSocketAddress."

	^SpSocketAddress on: self underlyingSocket getName for: self</body>
</methods>

<methods>
<class-id>SpSocket</class-id> <category>services-streams</category>

<body package="SpSockets">writeStream
	"^nil
While this is convinient, it would mean that sockets would depend on streams, and we want to avoid that.
Use {my stream class} on: {my socket} instead."

	^self shouldNotImplement</body>

<body package="SpSockets">readStream
	"^nil
While this is convinient, it would mean that sockets would depend on streams, and we want to avoid that.
Use {my stream class} on: {my socket} instead."

	^self shouldNotImplement</body>
</methods>

<methods>
<class-id>SpSocket</class-id> <category>services-options</category>

<body package="SpSockets">setAddressReuse: aBoolean 
	"^self
	c.f. self class &gt;&gt;socketOptions and self &gt;&gt;setOptionForLevel:optionID:value:
	If a boolean is true, I set address reuse on, otherwise I set address reuse off."

	| optionValue |
	optionValue := aBoolean ifTrue: [1] ifFalse: [0].
	self 
		setOptionForLevel: (self class socketOptionLevels at: #SOL_SOCKET)
		optionID: (self class socketOptions at: #SO_REUSEADDR)
		value: optionValue.
	^self</body>
</methods>

<methods>
<class-id>SpSocket</class-id> <category>accessing</category>

<body package="SpSockets">socketType
	^socketType</body>

<body package="SpSockets">protocolNumber
	^protocolNumber</body>

<body package="SpSockets">communicationDomain
	^communicationDomain</body>
</methods>

<methods>
<class-id>SpSocket</class-id> <category>services-io</category>

<body package="SpSockets">read: targetNumberOfBytes 
	"^a ByteArray
	I attempt to read the targetNumberOfBytes from my underlying socket.  If the targetNumberOfBytes
	are not available, I return what I can get."

	| targetByteArray numberOfBytesActuallyRead |
	^SpExceptionContext 
		for: 
			[targetByteArray := ByteArray new: targetNumberOfBytes.
			numberOfBytesActuallyRead := self underlyingSocket 
						readInto: targetByteArray.
			targetByteArray copyFrom: 1 to: numberOfBytesActuallyRead]
		on: Error
		do: [:ex | SpSocketError signalWith: ex]</body>

<body package="SpSockets">readInto: aByteArray startingAt: startIndex for: aNumberOfBytes 
	"^an Integer
I return the number of bytes actually read."
	^self underlyingSocket 
		readInto: aByteArray
		startingAt: startIndex
		for: aNumberOfBytes</body>

<body package="SpSockets">readyForRead
	"^a Boolean
I return true if a read operation will return some number of bytes."

	^self underlyingSocket bytesForRead &gt; 0</body>

<body package="SpSockets">writeFrom: aByteArray startingAt: startIndex for: length 
	"^an Integer
I return the number of bytes actually written."

	^self underlyingSocket 
		writeFrom: aByteArray
		startingAt: startIndex
		for: length</body>

<body package="SpSockets">write: sourceByteArray 
	"^an Integer
	I write the contents of the sourceByteArray to my underlying Socket.
	I return the number of bytes written."

	^SpExceptionContext 
		for: [self underlyingSocket writeFrom: sourceByteArray]
		on: Error
		do: [:ex | SpSocketError signalWith: ex]</body>

<body package="SpSockets">waitForReadDataUpToMs: aNumberOfMilliseconds 
	"^a Boolean
	I return true if we think data became available within aNumberOfMilliseconds, and
	false if we timed out.
	Martin Kobetic on the vwnc list said that getting a successful read wait but finding
	no bytes available to read means that the remote end closed the socket - so in this
	case I now raise an exception."

	| readWaitSuccessful |
	readWaitSuccessful := (self underlyingSocket 
				readWaitWithTimeoutMs: aNumberOfMilliseconds) not.
	(readWaitSuccessful and: [self readyForRead not]) 
		ifTrue: 
			[self close.
			SpSocketError raiseSignal: 'Socket unexpectedly closed by other end!'].
	^readWaitSuccessful</body>
</methods>

<methods>
<class-id>SpSocket</class-id> <category>private</category>

<body package="SpSockets">onNativeclientSocket: aNativeSocket for: aServerSocket 
	"^self
	I initialize myself with the same properties as aServerSocket and with
	aNativeSocket as my underlying socket."

	communicationDomain := aServerSocket communicationDomain.
	socketType := aServerSocket socketType.
	protocolNumber := aServerSocket protocolNumber.
	underlyingSocket := aNativeSocket.
	^self</body>

<body package="SpSockets">underlyingSocket
	^underlyingSocket</body>
</methods>

<methods>
<class-id>SpSocket</class-id> <category>services-status</category>

<body package="SpSockets">acceptRetryingIfTransientErrors
	"^an OSkSocket
	I try to do an accept.  If I get an exception which is 'transient' I retry."

	^SpExceptionContext 
		for: [self accept]
		on: OSErrorHolder transientErrorSignal
		do: [:ex | ex restart]</body>

<body package="SpSockets">connectTo: aSocketAddress 
	"^self
	I instruct my underlying socket to connect to aSocketAddress."

	self underlyingSocket connectTo: aSocketAddress asNativeSocketAddress.
	^self</body>

<body package="SpSockets">listenBackloggingUpTo: aNumberOfConnections 
	"^self
	I set the socket I represent listening for incomming connections, allowing a 
	backlog of up to aNumberOfConnections."

	self underlyingSocket listenFor: aNumberOfConnections.
	^self</body>

<body package="SpSockets">setOptionForLevel: aLevelNumber optionID: anOptionNumber value: aValue 
	"^self
	see man 2 setsockopt
	From the manpage:
	Getsockopt  and  setsockopt  manipulate  the  options associated with a
       socket.  Options may exist at multiple protocol levels; they are always
       present at the uppermost socket level."

	self underlyingSocket 
		setOptionsLevel: aLevelNumber
		name: anOptionNumber
		value: aValue.
	^self</body>

<body package="SpSockets">close
	"^self
	The same as the close() posix function."

	self underlyingSocket close.
	^self</body>

<body package="SpSockets">accept
	"^an OSkSocket
	I accept the next connection made to the server socket I represent.  I return a new
	instance of OSkSocket which represents the socket over which information can be
	exchanged.
	NOTE: this call will block waiting for an inbound connection"

	^SpExceptionContext 
		for: [self class onNativeclientSocket: self underlyingSocket accept for: self]
		on: Error
		do: [:ex | SpSocketError signalWith: ex]</body>

<body package="SpSockets">bindSocketAddress: aSocketAddress 
	"^self
	Equivalent of:  bind(int  sockfd, struct sockaddr *my_addr, socklen_t addrlen);
	see man bind.
	Bind the socket to aSocketAddress."

	self underlyingSocket bindTo: (aSocketAddress asNativeSocketAddress).
	^self</body>
</methods>


<methods>
<class-id>SpSocketAddress class</class-id> <category>instance creation</category>

<body package="SpSockets">on: subjectAddress for: aSocket 
	"^an OSkSocketAddress
	Well, in the future there may be more than one kind of socket address,
	but for now there is just OSkIPAddress, so I return one of those on the 
	details embodied in the subjectAddress. 
	No use is made of aSocket as yet, but it will be useful when there
	are more kinds of socket address supported."

	^SpIPAddress host: subjectAddress hostAddress port: subjectAddress port</body>
</methods>


<methods>
<class-id>SpSocketsCodeForSqueak class</class-id> <category>code strings</category>

<body package="SpSockets">codeString
	"^a String
	I return the string which is the source code for the OpenSkills GemStone sockets classes."

	"(Filename named: 'SpSockets-squeak.st') writeStream nextPutAll: self codeString; close"

	^'Object subclass: #SpSocket
	instanceVariableNames: ''underlyingSocket socketAddress''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpSockets''!

!SpSocket methodsFor: ''initialize-release'' stamp: ''BB 1/22/2006 17:00''!
onUnderlyingSocket: aSocket 
	underlyingSocket := aSocket.
	^self! !


!SpSocket methodsFor: ''private'' stamp: ''BB 1/25/2006 21:48''!
onNativeclientSocket: aNativeSocket for: aServerSocket 
	"^self
	I initialize myself with the same properties as aServerSocket and with
	aNativeSocket as my underlying socket."

"	communicationDomain := aServerSocket communicationDomain.
	socketType := aServerSocket socketType.
	protocolNumber := aServerSocket protocolNumber."
	underlyingSocket := aNativeSocket.
	^self! !

!SpSocket methodsFor: ''private'' stamp: ''BB 1/22/2006 18:44''!
underlyingSocket
	^underlyingSocket! !


!SpSocket methodsFor: ''services-accessing'' stamp: ''BB 1/31/2006 21:50''!
getPeerName
	"^an OSkSocketAddress
	see man getpeername.
	I return the socket address of the other/remote/peer end of the socket I
	represent."
	^ SpIPAddress host: self underlyingSocket remoteAddress port: self underlyingSocket remotePort! !

!SpSocket methodsFor: ''services-accessing'' stamp: ''BB 1/31/2006 21:56''!
getSocketName
	"^an OSkSocketAddress
	see: man getsockname
	I return my local socket address which may be any subclass of 
	OSkSocketAddress."
	^ SpIPAddress host: self underlyingSocket localAddress port: self underlyingSocket localPort! !


!SpSocket methodsFor: ''services-status'' stamp: ''BB 1/31/2006 16:50''!
accept
	"^an OSkSocket
	I accept the next connection made to the server socket I represent.
	This is a *blocking* request. That is, this method will not exit until
	an inbound socket connection is made. When that happens the new
	socket connected to the client (not the server socket) will be returned."
	^ SpExceptionContext
		for: [| clientSpecificSocket | 
			[(clientSpecificSocket := self underlyingSocket
						waitForAcceptFor: 1
						ifTimedOut: [nil]) isNil] whileTrue.
			self class onNativeclientSocket: clientSpecificSocket for: self]
		on: Error
		do: [:ex | SpSocketError new parameter: ex;
				 raiseSignal: ''Error while trying to accept a socket connection.'']! !

!SpSocket methodsFor: ''services-status'' stamp: ''BB 1/25/2006 21:26''!
acceptRetryingIfTransientErrors
		"^an OSkSocket
	I try to do an accept.  If I get an exception which is ''transient'' I retry.
	For now in Squeak, I just do the accept"

	"^SpExceptionContext 
		for: [self accept]
		on: OSErrorHolder transientErrorSignal
		do: [:ex | ex restart]"
	^self accept! !

!SpSocket methodsFor: ''services-status'' stamp: ''BB 1/25/2006 16:40''!
bindSocketAddress: aSocketAddress 
	"^self
	Equivalent of: bind(int sockfd, struct sockaddr *my_addr, socklen_t
	addrlen); see man bind. Bind the socket to aSocketAddress.
	It seems that Squeak merges the ''bind'' and the ''listen'', so here I''ll just
	remember the socket address and use it when I get the listen request."
	socketAddress := aSocketAddress.
	^self! !

!SpSocket methodsFor: ''services-status'' stamp: ''BB 1/23/2006 11:09''!
close
	"^self
	The same as the close() posix function."
	self underlyingSocket close! !

!SpSocket methodsFor: ''services-status'' stamp: ''BB 1/22/2006 18:47''!
connectTo: aSocketAddress 
	"^self
	I instruct my underlying socket to connect to aSocketAddress."
	self underlyingSocket connectTo: aSocketAddress hostAddress port: aSocketAddress portNumber! !

!SpSocket methodsFor: ''services-status'' stamp: ''BB 1/25/2006 20:57''!
listenBackloggingUpTo: aNumberOfConnections 
	"^self
	I set the socket I represent listening for incomming connections,
	allowing a 	backlog of up to aNumberOfConnections.
	Note that Squeak combines bind and listen so I noted the socket address
	when I was asked to bind - and I use that now.
	OK - I really wanter to be able to specify the interface, but that seems 
	to be broken - I get a primative error when I try to use it"
	self underlyingSocket
		listenOn: socketAddress portNumber
		backlogSize: aNumberOfConnections"
		interface: socketAddress hostAddress".
 	^self! !


!SpSocket methodsFor: ''testing'' stamp: ''BB 1/25/2006 21:21''!
isActive
	"^a Boolean
	There is no simple &gt;&gt;isActive test, it seems."
	^ self underlyingSocket isConnected
		or: [self underlyingSocket isWaitingForConnection]! !


!SpSocket methodsFor: ''services-io'' stamp: ''BB 1/23/2006 11:08''!
readInto: aByteArray startingAt: startIndex for: aNumberOfBytes 
	"^an Integer
	I return the number of bytes actually read.
	In Squeak it seems we can not specify the number of bytes to be read.
	We get what its there no matter how much their is!!"

	| actuallyRead |
	actuallyRead := self underlyingSocket receiveDataInto: aByteArray startingAt: startIndex.
	actuallyRead &gt; aNumberOfBytes
		ifTrue: [1 halt].
	^ actuallyRead! !

!SpSocket methodsFor: ''services-io'' stamp: ''BB 1/23/2006 09:10''!
readyForRead
	"^a Boolean
I return true if a read operation will return some number of bytes."

	^self underlyingSocket dataAvailable! !

!SpSocket methodsFor: ''services-io'' stamp: ''BB 1/31/2006 17:18''!
read: targetNumberOfBytes 
	"^a ByteArray
	I attempt to read the targetNumberOfBytes from my underlying socket.
	If the targetNumberOfBytes
	are not available, I return what I can get."
	| targetByteArray numberOfBytesActuallyRead |
	^ SpExceptionContext
		for: [targetByteArray := ByteArray new: targetNumberOfBytes.
			numberOfBytesActuallyRead := self underlyingSocket receiveDataInto: targetByteArray.
			targetByteArray copyFrom: 1 to: numberOfBytesActuallyRead]
		on: Error
		do: [:ex | SpSocketError raiseSignal: ex]! !

!SpSocket methodsFor: ''services-io'' stamp: ''BB 1/23/2006 09:57''!
waitForReadDataUpToMs: aNumberOfMilliseconds 
	"^a Boolean
	I return true if we think data became available within
	aNumberOfMilliseconds, and false if we timed out.
	Squeak wants a timeout in seconds, so I convert it here."
	| aNumberOfSeconds |
	aNumberOfSeconds := (aNumberOfMilliseconds / 1000) ceiling.
	self underlyingSocket
		waitForDataFor: aNumberOfSeconds
		ifClosed: [SpError signal: ''Socket closed while waiting for data''.
			^ false]
		ifTimedOut: [^ false].
	^ true! !

!SpSocket methodsFor: ''services-io'' stamp: ''BB 1/23/2006 08:56''!
writeFrom: aByteArray startingAt: startIndex for: length 
	"^an Integer
	I return the number of bytes actually written."
	^ self underlyingSocket
		sendSomeData: aByteArray
		startIndex: startIndex
		count: length! !

!SpSocket methodsFor: ''services-io'' stamp: ''BB 1/31/2006 22:56''!
write: sourceByteArray 
	"^an Integer
	I write the contents of the sourceByteArray to my underlying Socket.
	I return the number of bytes written."
	^ SpExceptionContext
		for: [self underlyingSocket sendSomeData: sourceByteArray]
		on: Error
		do: [:ex | SpSocketError raiseSignal: ex]! !


!SpSocket methodsFor: ''services-options'' stamp: ''BB 1/25/2006 19:58''!
setAddressReuse: aBoolean 
	"^self
	c.f. self class &gt;&gt;socketOptions and self &gt;&gt;setOptionForLevel:optionID:value:
	If a boolean is true, I set address reuse on, otherwise I set address reuse
	off. "
	"self underlyingSocket setOption: ''SO_REUSEADDR'' value: aBoolean"! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpSocket class
	instanceVariableNames: ''''!

!SpSocket class methodsFor: ''private'' stamp: ''BB 1/25/2006 21:34''!
onNativeclientSocket: aNativeSocket for: aServerSocket 
	"^an OSkSocket
I create a new instance of my self at the request of aServerSocket  where
this new instance will be a connected client socket (connected via aNativeSoket)."

	^self new onNativeclientSocket: aNativeSocket for: aServerSocket! !


!SpSocket class methodsFor: ''instance creation'' stamp: ''BB 1/22/2006 18:41''!
connectToServerOnHost: hostName port: portNumber 
	"^an OSkSocket 
	I return a new instance of myself which represents a socket connecter
	to a server listening on portNumber at hostName."
	| newSocket |
	newSocket := self newTCPSocket.
	newSocket
		connectTo: (SpIPAddress hostName: hostName port: portNumber).
	^ newSocket! !

!SpSocket class methodsFor: ''instance creation'' stamp: ''BB 1/30/2006 22:48''!
newTCPSocket
	"^an OSkSocket
	I return a new instance of myself that represents an unconfigured TCP
	socket."
	Socket initializeNetwork.
	^ self new onUnderlyingSocket: Socket newTCP! !


Object subclass: #SpSocketAddress
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpSockets''!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpSocketAddress class
	instanceVariableNames: ''''!

!SpSocketAddress class methodsFor: ''instance creation'' stamp: ''BB 1/31/2006 21:41''!
on: subjectAddress for: aSocket 
	"^an OSkSocketAddress
	Well, in the future there may be more than one kind of socket address,
	but for now there is just OSkIPAddress, so I return one of those on the 
	details embodied in the subjectAddress. 
	No use is made of aSocket as yet, but it will be useful when there
	are more kinds of socket address supported."

	^SpIPAddress host: subjectAddress hostAddress port: subjectAddress port! !


SpSocketAddress subclass: #SpIPAddress
	instanceVariableNames: ''hostAddress portNumber''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpSockets''!

!SpIPAddress methodsFor: ''printing'' stamp: ''BB 1/31/2006 21:51''!
hostAddressString
	| targetStream |
	targetStream := String new writeStream.
	targetStream
		nextPutAll: (self hostAddress at: 1) printString;
		nextPut: $.;
		nextPutAll: (self hostAddress at: 2) printString;
		nextPut: $.;
		nextPutAll: (self hostAddress at: 3) printString;
		nextPut: $.;
		nextPutAll: (self hostAddress at: 4) printString.
	^targetStream contents! !


!SpIPAddress methodsFor: ''initialize-release'' stamp: ''BB 1/22/2006 17:55''!
host: aHostAddress port: aPortNumber 
	hostAddress := aHostAddress.
	portNumber := aPortNumber! !


!SpIPAddress methodsFor: ''accessing'' stamp: ''BB 1/22/2006 18:47''!
hostAddress
	^ hostAddress! !

!SpIPAddress methodsFor: ''accessing'' stamp: ''BB 1/22/2006 18:47''!
portNumber
	^ portNumber! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpIPAddress class
	instanceVariableNames: ''''!

!SpIPAddress class methodsFor: ''instance creation'' stamp: ''BB 1/22/2006 17:56''!
connectToServerOnHost: hostName port: portNumber 
	"^an OSkSocket 
	I return a new instance of myself which represents a socket connecter
	to a server listening on portNumber at hostName."
	| newSocket |
	newSocket := self newTCPSocket.
	newSocket
		connectTo: (SpIPAddress hostName: hostName port: portNumber).
	^ newSocket! !

!SpIPAddress class methodsFor: ''instance creation'' stamp: ''BB 1/22/2006 17:54''!
hostName: aHostNameString port: aPortNumber 
	"^an OSkSocketAddress
	I translate aHostNameString to an IP address and then create
	a new instance of myself with &gt;&gt;host:port:"
	^ self
		host: (NetNameResolver addressForName: aHostNameString)
		port: aPortNumber! !

!SpIPAddress class methodsFor: ''instance creation'' stamp: ''BB 1/22/2006 17:51''!
host: aHostAddress port: aPortNumber 
	"^an OSkSocketAddress
	I create a new instance of myself which represents an IP address/port
	combination (a TCP/IP address, really). Note that aHostAddress must be a
	four element byte 
	array (e.g. #[127 0 0 1]) ."
	^ self new host: aHostAddress port: aPortNumber! !


SpError subclass: #SpSocketError
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpSockets''!
'</body>
</methods>


<methods>
<class-id>SpIPAddress class</class-id> <category>instanceCreation</category>

<body package="SpSockets">hostName: aHostNameString port: aPortNumber 
	"^an OSkSocketAddress
	I translate aHostNameString to an IP address and then create
	a new instance of myself with &gt;&gt;host:port:"

	^self host: (IPSocketAddress hostAddressByName: aHostNameString)
		port: aPortNumber</body>

<body package="SpSockets">host: aHostAddress port: aPortNumber 
	"^an OSkSocketAddress
	I create a new instance of myself which represents an IP address/port combination
	(a TCP/IP address, really).  Note that aHostAddress must be a four element byte 
	array (e.g. #[127 0 0 1]) ."

	^self new host: aHostAddress port: aPortNumber</body>
</methods>


<methods>
<class-id>SpIPAddress</class-id> <category>services - private</category>

<body package="SpSockets">asNativeSocketAddress
	"^an IPSocketAddress
	I return a VisualWorks IPSocketAddress which represents the same IP address I do."

	^IPSocketAddress hostAddress: self hostAddress port: self portNumber</body>
</methods>

<methods>
<class-id>SpIPAddress</class-id> <category>initialize-release</category>

<body package="SpSockets">host: aHostAddress port: aPortNumber 
	hostAddress := aHostAddress.
	portNumber := aPortNumber.
	^self</body>
</methods>

<methods>
<class-id>SpIPAddress</class-id> <category>accessing</category>

<body package="SpSockets">hostAddress
	^hostAddress</body>

<body package="SpSockets">portNumber
	^portNumber</body>
</methods>

<methods>
<class-id>SpIPAddress</class-id> <category>printing</category>

<body package="SpSockets">hostAddressString
	| targetStream |
	targetStream := String new writeStream.
	targetStream
		nextPutAll: (self hostAddress at: 1) printString;
		nextPut: $.;
		nextPutAll: (self hostAddress at: 2) printString;
		nextPut: $.;
		nextPutAll: (self hostAddress at: 3) printString;
		nextPut: $.;
		nextPutAll: (self hostAddress at: 4) printString.
	^targetStream contents</body>
</methods>


<methods>
<class-id>SpSocketsCodeForGemStone class</class-id> <category>code strings</category>

<body package="SpSockets">codeString
	"^a String
	I return the string which is the source code for the OpenSkills GemStone sockets classes."

	"(Filename named: 'SpSockets.gs') writeStream nextPutAll: self codeString; close"

	^'!
! From ! GEMSTONE: 6.1, Thu Apr 17 20:11:38 US/Pacific 2003; IMAGE: GemStone v6.1 kernel classes filein completed at 17/04/2003 20:22:36

! GemStone v6.1 kernel classes filein of stripped sources completed at 17/04/2003 20:31:50

! 

! On October 5, 2005, 5:03:36 pm
!
!
! SymbolDictionary ''SpSockets''
!
run
| symList newDict |
symList := System myUserProfile symbolList.
symList do: [ :element |
    (element includesKey: #SpSockets)
        ifTrue: [ ^element ]
].
newDict := SymbolDictionary new.
newDict at: #SpSockets put: newDict.
System myUserProfile insertDictionary: newDict at: 1.
^newDict
%
doit
(SpError subclass: ''SpSocketError''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpSockets  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpSocket''  instVarNames: #( communicationDomain socketType protocolNumber                    underlyingSocket)  classVars: #()  classInstVars: #( addressFamilies protocolFamilies socketTypes socketOptionLevels socketOptions fileControlOptions)  poolDictionaries: #[]  inDictionary: SpSockets  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpSocketAddress''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpSockets  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(SpSocketAddress subclass: ''SpIPAddress''  instVarNames: #( hostAddress portNumber)  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpSockets  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
SpSocketError immediateInvariant.
%
doit
SpSocket immediateInvariant.
%
doit
SpSocketAddress immediateInvariant.
%
doit
SpIPAddress immediateInvariant.
%

! Remove existing behavior from SpSocketError
doit
SpSocketError removeAllMethods.
SpSocketError class removeAllMethods.
%
! ------------------- Class methods for SpSocketError
! ------------------- Instance methods for SpSocketError

! Remove existing behavior from SpSocket
doit
SpSocket removeAllMethods.
SpSocket class removeAllMethods.
%
! ------------------- Class methods for SpSocket
category: ''defined symbols''
classmethod: SpSocket
addressFamilies
	"^an IdentityDictionary
	I return the dictionary mapping each defined address family symbol to it''s numeric
	value.  See socket.h and look for the #def AF_xxx lines.
	If you modify this method, evaluate the following:
		''SpSocket resetAllDefinedValues'' "

	addressFamilies isNil 
		ifTrue: 
			[addressFamilies := (IdentityDictionary new)
						at: #AF_UNIX put: 1;
						at: #AF_LOCAL put: 1;
						at: #AF_INET put: 2;
						yourself].
	^addressFamilies
%
category: ''defined symbols''
classmethod: SpSocket
fileControlOptions
	"^an IdentityDictionary
	I return the dictionary mapping each defined file control symbol to it''s numeric
	value.  See fcntl.h and look for the at: #O_xxx lines.
	Really this is here for the O_NONBLOCK option which sets the fd (file descriptor)
	of a socket to non-blocking mode when used in an fcntl() function.
	If you modify this method, evaluate the following:
		''SpSocket resetAllDefinedValues'' "

	fileControlOptions isNil 
		ifTrue: 
			[fileControlOptions := (IdentityDictionary new)
						at: #O_ACCMODE put: 0003;
						at: #O_RDONLY put: 00;
						at: #O_WRONLY put: 01;
						at: #O_RDWR put: 02;
						at: #O_CREAT put: 0100;
						at: #O_EXCL put: 0200;
						at: #O_NOCTTY put: 0400;
						at: #O_TRUNC put: 01000;
						at: #O_APPEND put: 02000;
						at: #O_NONBLOCK put: 04000;
						at: #O_NDELAY put: 04000;
						at: #O_SYNC put: 010000;
						at: #FASYNC put: 020000;
						at: #O_DIRECT put: 040000;
						at: #O_LARGEFILE put: 0100000;
						at: #O_DIRECTORY put: 0200000;
						at: #O_NOFOLLOW put: 0400000;
						yourself].
	^fileControlOptions
%
category: ''defined symbols''
classmethod: SpSocket
protocolFamilies
	"^an IdentityDictionary
	I return the dictionary mapping each defined protocol family symbol to it''s numeric
	value.  See socket.h and look for the #def PF_xxx lines.
	If you modify this method, evaluate the following:
		''SpSocket resetAllDefinedValues'' "

	protocolFamilies isNil 
		ifTrue: 
			[protocolFamilies := (IdentityDictionary new)
						at: #PF_UNIX put: (self addressFamilies at: #AF_UNIX);
						at: #PF_LOCAL put: (self addressFamilies at: #AF_LOCAL);
						at: #PF_INET put: (self addressFamilies at: #AF_INET);
						yourself].
	^protocolFamilies
%
category: ''defined symbols''
classmethod: SpSocket
socketOptionLevels
	"^an IdentityDictionary
	I return the dictionary mapping each defined socket option level symbol to it''s numeric
	value.  See socket.h and look for the #define SOL_xxx lines.
	If you modify this method, evaluate the following:
		''SpSocket resetAllDefinedValues'' "

	socketOptionLevels isNil 
		ifTrue: 
			[socketOptionLevels := (IdentityDictionary new)
						at: #SOL_SOCKET put: 1;
						yourself].
	^socketOptionLevels
%
category: ''defined symbols''
classmethod: SpSocket
socketOptions
	"^an IdentityDictionary
	I return the dictionary mapping each defined socket option symbol to it''s numeric
	value.  See socket.h and look for the #define SO_xxx lines.
	If you modify this method, evaluate the following:
		''SpSocket resetAllDefinedValues'' "

	socketOptions isNil 
		ifTrue: 
			[socketOptions := (IdentityDictionary new)
						at: #SO_REUSEADDR put: 2;
						yourself].
	^socketOptions
%
category: ''defined symbols''
classmethod: SpSocket
socketTypes
	"^an IdentityDictionary
	I return the dictionary mapping each defined socket type symbol to it''s numeric
	value.  See socket.h and look for the #define SOCK_xxx lines.
	If you modify this method, evaluate the following:
		''SpSocket resetAllDefinedValues'' "

	socketTypes isNil 
		ifTrue: 
			[socketTypes := (IdentityDictionary new)
						at: #SOCK_STREAM put: 1;
						yourself].
	^socketTypes
%
category: ''instance creation''
classmethod: SpSocket
forDomain: aCommunicationsDomain type: aSocketType 
	"^an SpSocket
	Default the protocol to zero - this is the default  in the Spec anyway.  See man socket.."

	^self 
		forDomain: aCommunicationsDomain
		type: aSocketType
		protocol: 0
%
category: ''instance creation''
classmethod: SpSocket
forDomain: aDomainSymbol type: aSocketTypeSymbol protocol: aProtocolNumber 
	"^an SpSocket
	Equivalent of int socket(int domain, int type, int protocol);  see man socket.
	I return a new instance of myself that represents a socket configured for the
	specified domain type and protocol .
	Note in GS we can''t specify any of the regular socket stuff - it''s TCP Stream only!"

	| newNativeSocket |
	newNativeSocket := GsSocket new.
	^self new 
		onNativeSocket: newNativeSocket
		forDomain: aDomainSymbol
		type: aSocketTypeSymbol
		protocol: aProtocolNumber
%
category: ''instance creation''
classmethod: SpSocket
socketPairForDomain: aCommunicationsDomain type: aSocketType 
	"^an SpSocket
	see: man socketpair
	Default the protocol to zero - this is the default  in the Spec anyway. "

	^self 
		socketPairForDomain: aCommunicationsDomain
		type: aSocketType
		protocol: 0
%
category: ''instance creation''
classmethod: SpSocket
socketPairForDomain: aDomainSymbol type: aTypeSymbol protocol: aProtocolNumber 
	"^an SpSocket
	See: man socketpair
	Equivalent of int socketpair(int d, int type, int protocol, int sv[2]); 
	I return and array containing two new instances of myself each representing
	one end of a connection.
	No direct way to do this in GS - I''ll look at it when I need it."

	"SocketAccessor openPair collect: 
			[:newNativeSocket | 
			self new 
				onNativeSocket: newNativeSocket
				forDomain: aDomainSymbol
				type: aTypeSymbol
				protocol: aProtocolNumber]"
	^1 halt: ''Doh! - not supported in GS''
%
category: ''private''
classmethod: SpSocket
onNativeclientSocket: aNativeSocket for: aServerSocket 
	"^an SpSocket
I create a new instance of my self at the request of aServerSocket  where
this new instance will be a connected client socket (connected via aNativeSoket)."

	^self new onNativeclientSocket: aNativeSocket for: aServerSocket
%
category: ''private''
classmethod: SpSocket
resetAllDefinedValues
	"^self
	I simply set the all the symbol dictionaries containing defined values to
	nil, forcing them to be re-initialized on demand."

	"SpSocket resetAllDefinedValues"

	addressFamilies := nil.
	protocolFamilies := nil.
	socketTypes := nil.
	^self
%
category: ''services''
classmethod: SpSocket
connectToServerOnHost: hostName port: portNumber 
	"^an SpSocket 
	I return a new instance of myself which represents a socket connecter to a server listening on portNumber at hostName."

	| newSocket |
	newSocket := self newTCPSocket.
	newSocket connectTo: (SpIPAddress hostName: hostName port: portNumber).
	^newSocket
%
category: ''services''
classmethod: SpSocket
initialize
	^self resetAllDefinedValues
%
category: ''services''
classmethod: SpSocket
newSocketPair
	"^an Array
	I return an array containing two SpSockets each representing one end of a
	#PF_UNIX connection."

	^self socketPairForDomain: #PF_UNIX type: #SOCK_STREAM
%
category: ''services''
classmethod: SpSocket
newTCPSocket
	"^an SpSocket
	I create and return a new socket configured to be of a streaming type handle the 
	IPv4 peotocol family (default protocol).  This is a tcp_socket (see man 7 ip)."

	^self forDomain: #PF_INET type: #SOCK_STREAM
%
! ------------------- Instance methods for SpSocket
category: ''accessing''
method: SpSocket
communicationDomain
	^communicationDomain
%
category: ''accessing''
method: SpSocket
protocolNumber
	^protocolNumber
%
category: ''accessing''
method: SpSocket
socketType
	^socketType
%
category: ''initialize-release''
method: SpSocket
onNativeSocket: aSocket forDomain: aCommunicationDomain type: aSocketType protocol: aProtocolNumber 
	"^self
	I initialize myself as a socket defined by the communications domain, type and protocol.  This
	follows the equivalent of the using the socket()  or socketpair() function."

	communicationDomain := aCommunicationDomain.
	socketType := aSocketType.
	protocolNumber := aProtocolNumber.
	underlyingSocket := aSocket.
	^self
%
category: ''private''
method: SpSocket
onNativeclientSocket: aNativeSocket for: aServerSocket 
	"^self
	I initialize myself with the same properties as aServerSocket and with
	aNativeSocket as my underlying socket."

	communicationDomain := aServerSocket communicationDomain.
	socketType := aServerSocket socketType.
	protocolNumber := aServerSocket protocolNumber.
	underlyingSocket := aNativeSocket.
	^self
%
category: ''private''
method: SpSocket
underlyingSocket
	^underlyingSocket
%
category: ''services-accessing''
method: SpSocket
getPeerName
	"^an SpSocketAddress
	see man getpeername.
	I return the socket address of the other/remote/peer end of the socket I represent."

	^SpIPAddress host: self underlyingSocket peerAddress port: self underlyingSocket peerPort
%
category: ''services-accessing''
method: SpSocket
getSocketName
	"^an SpSocketAddress
	see: man getsockname
	I return my local socket address which may be any subclass of 
	SpSocketAddress."

	^SpIPAddress host: self underlyingSocket address port: self underlyingSocket port
%
category: ''services-io''
method: SpSocket
read: targetNumberOfBytes 
	"^a ByteArray
	I attempt to read the targetNumberOfBytes from my underlying socket.  If the targetNumberOfBytes
	are not available, I return what I can get.
	Note that here I make sure that I behave in the same way as VisualWorks - i.e. I make blocking
	with respect to the Smalltalk Pocess.  So if a Smalltalk process invokes this method it will block until
	a read is possible - however, the other processes in the Gem will *not* block."

	| targetByteArray numberOfBytesActuallyRead |
	[self underlyingSocket readWillNotBlock] whileFalse: [Processor yield].
	targetByteArray := ByteArray new: targetNumberOfBytes.
	numberOfBytesActuallyRead := self underlyingSocket 
				read: targetNumberOfBytes
				into: targetByteArray.
	^numberOfBytesActuallyRead &gt; 0
		ifTrue: [targetByteArray copyFrom: 1 to: numberOfBytesActuallyRead]
		ifFalse: [ByteArray new]
%
category: ''services-io''
method: SpSocket
readInto: aByteArray startingAt: startIndex for: aNumberOfBytes 
	"^an Integer
I return the number of bytes actually read."

	^self underlyingSocket 
		read: aNumberOfBytes
		into: aByteArray
		startingAt: startIndex
%
category: ''services-io''
method: SpSocket
readyForRead
	"^a Boolean
I return true if a read operation will return some number of bytes."

	^self underlyingSocket readWillNotBlock
%
category: ''services-io''
method: SpSocket
waitForReadDataUpToMs: aNumberOfMilliseconds 
	"^a Boolean
	I return true if we think data became available within aNumberOfMilliseconds, and
	false if we timed out."

	^self underlyingSocket readWillNotBlockWithin: aNumberOfMilliseconds
%
category: ''services-io''
method: SpSocket
write: sourceByteArray 
	"^an Integer
	I write the contents of the sourceByteArray to my underlying Socket.
	I return the number of bytes written."

	| result |
	result := self underlyingSocket write: sourceByteArray size
				from: sourceByteArray.
	result isNil 
		ifTrue: 
			[| errorMessageStream |
			errorMessageStream := WriteStream on: String new.
			errorMessageStream
				nextPutAll: ''Error code: '';
				nextPutAll: self underlyingSocket lastErrorCode printString;
				nextPutAll: '', Error string: '';
				nextPutAll: self underlyingSocket lastErrorString printString;
				nextPutAll: '', Error symbol: '';
				nextPutAll: self underlyingSocket lastErrorSymbol printString.
			SpSocketError raiseSignal: errorMessageStream contents].
	^result
%
category: ''services-io''
method: SpSocket
writeFrom: aByteArray startingAt: startIndex for: length 
	"^an Integer
I return the number of bytes actually written."

	^self underlyingSocket 
		write: length
		from: aByteArray
		startingAt: startIndex
%
category: ''services-options''
method: SpSocket
setAddressReuse: aBoolean 
	"^self
	c.f. self class &gt;&gt;socketOptions and self &gt;&gt;setOptionForLevel:optionID:value:
	If a boolean is true, I set address reuse on, otherwise I set address reuse off."

	^self underlyingSocket option: ''REUSEADDR'' put: aBoolean
%
category: ''services-status''
method: SpSocket
accept
	"^an SpSocket
	I accept the next connection made to the server socket I represent.  I return a new
	instance of SpSocket which represents the socket over which information can be
	exchanged.
	NOTE: this call will block waiting for an inbound connection"

	^SpSocket onNativeclientSocket: (self underlyingSocket accept) for: self
%
category: ''services-status''
method: SpSocket
acceptRetryingIfTransientErrors
	"^an SpSocket
	I try to do an accept.  If I get an exception which is ''transient'' I retry.
	... except that in GemStone, I don''t do that - because I don''t know how."

	^self accept
%
category: ''services-status''
method: SpSocket
bindSocketAddress: aSocketAddress 
	"^self
	Equivalent of:  bind(int  sockfd, struct sockaddr *my_addr, socklen_t addrlen);
	see man bind.
	Bind the socket to aSocketAddress."

	self underlyingSocket bindTo: aSocketAddress portNumber toAddress: aSocketAddress hostAddressString.
	^self
%
category: ''services-status''
method: SpSocket
close
	"^self
	The same as the close() posix function."

	self underlyingSocket close.
	^self
%
category: ''services-status''
method: SpSocket
connectTo: aSocketAddress 
	"^self
	I instruct my underlying socket to connect to aSocketAddress."

	self underlyingSocket connectTo: aSocketAddress portNumber on: aSocketAddress hostAddressString.
	^self
%
category: ''services-status''
method: SpSocket
listenBackloggingUpTo: aNumberOfConnections 
	"^self
	I set the socket I represent listening for incomming connections, allowing a 
	backlog of up to aNumberOfConnections."

	self underlyingSocket makeListener: aNumberOfConnections.
	^self
%
category: ''services-status''
method: SpSocket
setOptionForLevel: aLevelNumber optionID: anOptionNumber value: aValue 
	"^self
	see man 2 setsockopt
	From the manpage:
	Getsockopt  and  setsockopt  manipulate  the  options associated with a
       socket.  Options may exist at multiple protocol levels; they are always
       present at the uppermost socket level."

	1 halt: ''Doh!  - can''''t do this in GemStone yet.''.
	self underlyingSocket 
		setOptionsLevel: aLevelNumber
		name: anOptionNumber
		value: aValue.
	^self
%
category: ''services-streams''
method: SpSocket
readStream
	"^nil
While this is convinient, it would mean that sockets would depend on streams, and we want to avoid that.
Use {my stream class} on: {my socket} instead."

	^self shouldNotImplement
%
category: ''services-streams''
method: SpSocket
writeStream
	"^nil
While this is convinient, it would mean that sockets would depend on streams, and we want to avoid that.
Use {my stream class} on: {my socket} instead."

	^self shouldNotImplement
%
category: ''testing''
method: SpSocket
isActive
	^self underlyingSocket isActive
%

! Remove existing behavior from SpSocketAddress
doit
SpSocketAddress removeAllMethods.
SpSocketAddress class removeAllMethods.
%
! ------------------- Class methods for SpSocketAddress
category: ''instance creation''
classmethod: SpSocketAddress
on: subjectAddress for: aSocket 
	"^an SpSocketAddress
	Well, in the future there may be more than one kind of socket address,
	but for now there is just SpIPAddress, so I return one of those on the 
	details embodied in the subjectAddress. 
	No use is made of aSocket as yet, but it will be useful when there
	are more kinds of socket address supported."

	^SpIPAddress host: subjectAddress hostAddress port: subjectAddress port
%
! ------------------- Instance methods for SpSocketAddress

! Remove existing behavior from SpIPAddress
doit
SpIPAddress removeAllMethods.
SpIPAddress class removeAllMethods.
%
! ------------------- Class methods for SpIPAddress
category: ''instanceCreation''
classmethod: SpIPAddress
host: aHostAddress port: aPortNumber 
	"^an SpSocketAddress
	I create a new instance of myself which represents an IP address/port combination
	(a TCP/IP address, really).  Note that aHostAddress must be a four element byte 
	array (e.g. #[127 0 0 1]) ."

	^self new host: aHostAddress port: aPortNumber
%
category: ''services''
classmethod: SpIPAddress
hostName: aHostNameString port: aPortNumber 
	"^an SpSocketAddress
	I translate aHostNameString to an IP address and then create
	a new instance of myself with &gt;&gt;host:port:"

	^self host: (GsSocket getHostAddressByName: aHostNameString)
		port: aPortNumber
%
! ------------------- Instance methods for SpIPAddress
category: ''accessing''
method: SpIPAddress
hostAddress
	^hostAddress
%
category: ''accessing''
method: SpIPAddress
portNumber
	^portNumber
%
category: ''initialize-release''
method: SpIPAddress
host: aHostAddress port: aPortNumber 
	hostAddress := aHostAddress.
	portNumber := aPortNumber.
	^self
%
category: ''printing''
method: SpIPAddress
hostAddressString
	^hostAddress
%'</body>
</methods>



<initialize>
<class-id>SpSocket</class-id>
</initialize><!-- Package SpEnvironmental(2 012,janko)= -->


<component-property>
<name>SpEnvironmental</name> <type>package</type>
<property>comment</property> <value>'©Bruce Badger 2004. Licensed under the LGPL.
'</value>
</component-property>

<class>
<name>SpEnvironment</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars>imageShutdownTaskBlocks </class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<class>
<name>SpStringUtilities</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<class>
<name>SpModel</name>
<environment>Smalltalk</environment>
<super>UI.Model</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<class>
<name>SpEnvironmentalCodeForGemStone</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<class>
<name>SpEnvironmentalCodeForSqueak</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<class>
<name>SpWeakArray</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<class>
<name>SpRandom</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>underlyingRandomStream </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<class>
<name>SpMD5Digest</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars>currentMD5Class </class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<class>
<name>SpTranscript</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpEnvironmental</category>
<attributes>
<package>SpEnvironmental</package>
</attributes>
</class>

<comment>
<class-id>SpTranscript</class-id>
<body>OSkTranscript is a portable transcript.  It will try to do the right thing in VW, GemStone or anywhere else.</body>
</comment>










<methods>
<class-id>SpWeakArray class</class-id> <category>instanceCreation</category>

<body package="SpEnvironmental">new: anInteger 
	"^a WeakArray 
	I don't return an instance of myself, I return a real WeakArray."

	^WeakArray new: anInteger</body>

<body package="SpEnvironmental">withAll: aCollection 
	"^a WeakArray 
	I don't return an instance of myself at all. I return a real Weak array."

	^WeakArray withAll: aCollection</body>
</methods>


<methods>
<class-id>SpTranscript class</class-id> <category>logging</category>

<body package="SpEnvironmental">nextPut: anObject 
	^self show: (String with: anObject)</body>

<body package="SpEnvironmental">cr
	^SpEnvironment isHeadless ifTrue: [self] ifFalse: [Transcript cr]</body>

<body package="SpEnvironmental">nextPutAll: aCollection 
	^self show: aCollection</body>

<body package="SpEnvironmental">show: aString 
	^SpEnvironment isHeadless 
		ifTrue: [self]
		ifFalse: [Transcript show: aString]</body>
</methods>


<methods>
<class-id>SpRandom class</class-id> <category>code strings</category>

<body package="SpEnvironmental">codeString
	"^a String
	I return the string which is the source code for the GemStone compatibility classes."

	"(Filename named: 'Random.gs') writeStream nextPutAll: self codeString; close"

	^
'!=========================================================================
! Copyright (C) GemStone Systems, Inc. 1986-1998.  All Rights Reserved.
!
! $Id: random.gs,v 50.9 1998/01/15 23:49:11 darrel Exp $
!
! Superclass Hierarchy:
!   Stream, Object.
!
!=========================================================================

run
Stream subclass: ''Random''
  instVarNames: #( ''seed'' ''hi'' ''lo'')
  classVars: #( ''a'' ''m'' ''r'' ''q'')
  classInstVars: #()
  poolDictionaries: #[]
  inDictionary: UserGlobals
  constraints: #[  ]
  instancesInvariant: false
  isModifiable: false

%
removeallmethods Random
removeallclassmethods Random

category: ''For Documentation Installation only''
classmethod: Random
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
''Class Random is a port of Jeff Sutherland''''s implementation of the
 Park &amp; Miller random number generator.

From Jeff Sutherland''''s original posting:

"In summary...(this is) a generator which has a full period, is
demonstrably random, and can be implemented correctly on almost
any system.  The generator has been exhaustively tested and its
characteristics are well understood... Moreover, it has become a
standard ... subroutine DNUN in the IMSL library and ... DRAND
in the simulation language SLAM II...  we feel confident in
recommending this random number generator as a minimal standard
against which all others should be judged."

This code has received minimal testing on an IBM P75 486 machine
and may break on a Pentium.  It is written in Enfin Smalltalk but
a port to another Smalltalk is trivial.  The validate function works
but any bugs you find are surely mine.  Send me a note at
jsutherland@vmark.com.'' .
doc documentClassWith: txt.

self description: doc.
%

category: ''accessing''
method: Random
nextPut: anObject
 "Random numbers do not implement nextPut: so provide an
 error notification."

 ^self shouldNotImplement: #nextPut:
%
method: Random
contents
 "Random numbers do not have a contents so provide
 an error notification."

 ^self shouldNotImplement: #contents
%
method: Random
flush
 "Random numbers do not need to flush."

 ^self shouldNotImplement: #flush
%
category: ''testing''
method: Random
atEnd
 "Answer false that the stream is not at an end."

 ^false
%

category: ''Accessing''
method: Random
seed

   "Return the value of the instance variable ''seed''."
   ^seed
%
category: ''Accessing''
method: Random
next
 "Answer the next random number."

"Real Random Number generator Version 2 from Park and Miller, 1988"
  hi := seed quo: q.
  lo := seed - (q * hi).
  seed := (a * lo) - (r * hi).
  seed &gt; 0 ifFalse: [
    seed := seed + m].
  ^ seed / m.
%
category: ''accessing''
method: Random
between: min and: max

   "Return a random value x such that min &lt;= x &lt; max"

  ^(self next * (max - min)) + min
%

category: ''Initialization''
method: Random
seed: aSeed
  seed := aSeed.
  hi := lo := nil.
%

category: ''Private''
method: Random
initialize

  "Initialize an instance, seeded by the time of day"

  self seed: System _timeMs
%

category: ''Instance Creation''
classmethod: Random
new
 ^super new initialize.
%

category: ''Testing''
classmethod: Random
testRandom
       "Random testRandom will check your hardware environment"
|num|
num := Random new initialize.
num seed: 1.
10000 timesRepeat: [
  num next.
].
(1043618065 = num seed)
  ifTrue: [ ^''OK.'' ]
  ifFalse: [ ^''Bad result. Fix this generator
             by referring to Park &amp; Miller,^M
             Communications of the ACM 31:10:1192-1201, 1988.'' ].
%
category: ''Testing''
classmethod: Random
speed
       "Random speed will benchmark the efficiency of random number
generation"

|rand|

rand := self new.

^(System millisecondsToRun: [ 1000 timesRepeat: [rand next]
  ]) / 1000.0
%

!=========================================================================
category: ''(as yet unclassified)''
classmethod: Random
initialize

  "Class initialization"

  a := 16807.0.
  m := 2147483647.0.
  q := m // a.
  r := m \\ a.
%

run
  Random initialize.
%
'</body>
</methods>


<methods>
<class-id>SpStringUtilities class</class-id> <category>services-encoding</category>

<body package="SpEnvironmental">string: subjectString asBytesUsingEncodingNamed: anEncodingName 
	^subjectString asByteArrayEncoding: anEncodingName</body>

<body package="SpEnvironmental">stringFromBytes: aByteArray 
	"^a String
In GemStone ['Hello, World' asByteArray asString] returns the string 'aByteArray' !
This is the boring long way of getting a string from a ByteArray - but it does work
in GemStone."

	"HTTPString stringFromBytes: ('Hello, World' asByteArray)"

	| targetStream |
	targetStream := WriteStream on: String new.
	aByteArray do: [:aByte | targetStream nextPut: aByte asCharacter].
	^targetStream contents</body>

<body package="SpEnvironmental">bytes: subjectBytes asStringUsingEncodingNames: anEncodingName 
	^subjectBytes asStringEncoding: anEncodingName</body>
</methods>

<methods>
<class-id>SpStringUtilities class</class-id> <category>services</category>

<body package="SpEnvironmental">trimBlanksFrom: aString 
	"^a String
I return a copy of aString with all leading and trailing blanks removed."

	| first last |
	first := 1.
	last := aString size.
	[last &gt; 0 and: [(aString at: last) isSeparator]] 
		whileTrue: [last := last - 1].
	^last == 0 
		ifTrue: [String new]
		ifFalse: 
			[[first &lt; last and: [(aString at: first) isSeparator]] 
				whileTrue: [first := first + 1].
			aString copyFrom: first to: last]</body>

<body package="SpEnvironmental">prevIndexOf: anElement from: startIndex to: stopIndex in: aString
	"Answer the previous index of anElement within the receiver between startIndex and stopIndex
	 working backwards through the receiver.  If the receiver does not contain anElement, answer nil"

	startIndex to: stopIndex by: -1 do:
		[:i |
		(aString at: i) = anElement
			ifTrue: [^i]].
	^nil</body>

<body package="SpEnvironmental">tokensBasedOn: separatorString in: aString 
	"Answer an OrderedCollection of the sub-sequences
	 of the receiver that are separated by anObject."

	| result lastIdx idx lastToken |
	result := OrderedCollection new.
	aString size = 0 ifTrue: [^result].
	lastIdx := 0.
	
	[idx := aString findString: separatorString startingAt: lastIdx + 1.
	idx &gt; 0] 
			whileTrue: 
				[idx == (lastIdx + 1) 
					ifTrue: [result addLast: String new]
					ifFalse: [result addLast: (aString copyFrom: lastIdx + 1 to: idx - 1)].
				lastIdx := idx].
	lastToken := lastIdx = aString size 
				ifTrue: [String new]
				ifFalse: [aString copyFrom: lastIdx + 1 to: aString size].
	result addLast: lastToken.
	^result</body>
</methods>


<methods>
<class-id>SpEnvironmentalCodeForSqueak class</class-id> <category>code strings</category>

<body package="SpEnvironmental">codeString
	"^a String
	I return the string which is the source code for the GemStone compatibility classes."

	"(Filename named: 'SpEnvironmental-squeak.st') writeStream nextPutAll: self codeString; close"

	^'Object subclass: #SpEnvironment
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpEnvironmental''!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpEnvironment class
	instanceVariableNames: ''''!

!SpEnvironment class methodsFor: ''services'' stamp: ''BB 1/23/2006 08:48''!
streamStartPosition
	"^an Integer
	Streams start at position 0 in VisualWorks &amp; Squeak, and position 1 in
	GemStone(!!). "
	^ 0! !

!SpEnvironment class methodsFor: ''services'' stamp: ''BB 1/30/2006 17:11''!
writeStackDumpForException: exception to: targetStream 
	targetStream nextPutAll: ''SpEnvironment class&gt;&gt;writeStackDumpForException:to: does not work yet :-/''! !


!SpEnvironment class methodsFor: ''testing'' stamp: ''BB 1/24/2006 11:46''!
isGemStone
	^false! !

!SpEnvironment class methodsFor: ''testing'' stamp: ''BB 1/25/2006 22:07''!
isHeadless
	^false! !

!SpEnvironment class methodsFor: ''testing'' stamp: ''BB 1/24/2006 11:47''!
isSqueak
	^true! !

!SpEnvironment class methodsFor: ''testing'' stamp: ''BB 1/24/2006 11:47''!
isVisualWorks
	^false! !


!SpEnvironment class methodsFor: ''image shutdown'' stamp: ''BB 1/31/2006 22:37''!
addImageShutdownTask: aBlock for: anObject ! !


Object subclass: #SpStringUtilities
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpEnvironmental''!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpStringUtilities class
	instanceVariableNames: ''''!

!SpStringUtilities class methodsFor: ''services-encoding'' stamp: ''BB 1/23/2006 12:02''!
bytes: subjectBytes asStringUsingEncodingNames: anEncodingName 
	^ subjectBytes asString! !

!SpStringUtilities class methodsFor: ''services-encoding'' stamp: ''BB 1/23/2006 11:59''!
string: subjectString asBytesUsingEncodingNamed: anEncodingName 
	^ subjectString asByteArray! !


Object subclass: #SpTranscript
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpEnvironmental''!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpTranscript class
	instanceVariableNames: ''''!

!SpTranscript class methodsFor: ''logging'' stamp: ''BB 1/25/2006 22:07''!
cr
	^ SpEnvironment isHeadless
		ifTrue: [self]
		ifFalse: [Transcript cr]! !

!SpTranscript class methodsFor: ''logging'' stamp: ''BB 1/25/2006 22:08''!
nextPutAll: aCollection 
	^self show: aCollection! !

!SpTranscript class methodsFor: ''logging'' stamp: ''BB 1/25/2006 22:08''!
nextPut: anObject 
	^self show: (String with: anObject)! !

!SpTranscript class methodsFor: ''logging'' stamp: ''BB 1/25/2006 22:07''!
show: aString 
	^ SpEnvironment isHeadless
		ifTrue: [self]
		ifFalse: [Transcript show: aString]! !


Object subclass: #SpWeakArray
	instanceVariableNames: ''''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpEnvironmental''!

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

SpWeakArray class
	instanceVariableNames: ''''!

!SpWeakArray class methodsFor: ''instance creation'' stamp: ''BB 1/22/2006 15:58''!
new: anInteger 
	"^a WeakArray 
	I don''t return an instance of myself, I return a real WeakArray."

	^WeakArray new: anInteger! !

!SpWeakArray class methodsFor: ''instance creation'' stamp: ''BB 1/22/2006 16:01''!
withAll: aCollection 
	"^a WeakArray 
	I don''t return an instance of myself at all. I return a real Weak array."
	^ WeakArray withAll: aCollection asArray! !
'</body>
</methods>


<methods>
<class-id>SpMD5Digest class</class-id> <category>encoding</category>

<body package="SpEnvironmental">currentMD5Class
	"^a Class
	Return the MD5 class to be used in this environment.  The MD5 class was moved ."

	"NativeMD5Digest currentMD5Class"

	currentMD5Class isNil 
		ifTrue: 
			[currentMD5Class := 'Security.MD5' asQualifiedReference 
						ifDefinedDo: [:theClass | theClass]
						elseDo: ['Net.MD5' asQualifiedReference value]].
	^currentMD5Class</body>

<body package="SpEnvironmental">byteHash: bytes 
	"^a ByteArray
	Just return the digest for bytes by delegating to  the MD5 class."

	^self currentMD5Class byteHash: bytes</body>
</methods>


<methods>
<class-id>SpEnvironmentalCodeForGemStone class</class-id> <category>code strings</category>

<body package="SpEnvironmental">codeString
	"^a String
	I return the string which is the source code for the GemStone compatibility classes."

	"(Filename named: 'SpEnvironmental.gs') writeStream nextPutAll: self codeString; close"

	^'!
! From ! GEMSTONE: 6.1, Thu Apr 17 20:11:38 US/Pacific 2003; IMAGE: GemStone v6.1 kernel classes filein completed at 17/04/2003 20:22:36

! GemStone v6.1 kernel classes filein of stripped sources completed at 17/04/2003 20:31:50

! 

! On May 24, 2006, 11:23:17 pm
!
!
! SymbolDictionary ''SpEnvironmental''
!
run
| symList newDict |
symList := System myUserProfile symbolList.
symList do: [ :element |
    (element includesKey: #SpEnvironmental)
        ifTrue: [ ^element ]
].
newDict := SymbolDictionary new.
newDict at: #SpEnvironmental put: newDict.
System myUserProfile insertDictionary: newDict at: 1.
^newDict
%
doit
(Object subclass: ''SpEnvironment''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpEnvironmental  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpMD5Digest''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpEnvironmental  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpModel''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpEnvironmental  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpStringUtilities''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpEnvironmental  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpTranscript''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpEnvironmental  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpWeakArray''  instVarNames: #()  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpEnvironmental  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
SpEnvironment immediateInvariant.
%
doit
SpMD5Digest immediateInvariant.
%
doit
SpModel immediateInvariant.
%
doit
SpStringUtilities immediateInvariant.
%
doit
SpTranscript immediateInvariant.
%
doit
SpWeakArray immediateInvariant.
%

! Remove existing behavior from SpEnvironment
doit
SpEnvironment removeAllMethods.
SpEnvironment class removeAllMethods.
%
! ------------------- Class methods for SpEnvironment
category: ''compiling''
classmethod: SpEnvironment
evaluate: aString in: anEnvironment
"This is a no-op for now since nothing in practice has needed it in GemStone."
	^self
%
category: ''compiling''
classmethod: SpEnvironment
evaluate: aString receiver: anObject in: anEnvironment 
"This is a no-op for now since nothing in practice has needed it in GemStone."
	^self
%
category: ''development''
classmethod: SpEnvironment
madeObsoleteBy: aBlock 
	"^an Object
I cause halt the code and ask the developer to use the code in aBlock, rather than the obsolete code."

	(self isHeadless or: [self isGemStone]) 
		ifFalse: 
			[1 
				halt: ''please use the code in the block, not the obsolete code - thanks.''].
	^aBlock value
%
category: ''development''
classmethod: SpEnvironment
workInProgress
	"^self
This method does nothing, but can be used to ''mark'' methods still needing work.  Simply send this message, and use browse senders to find things still in need of attention."

	^self
%
category: ''image shutdown''
classmethod: SpEnvironment
addImageShutdownTask: aBlock for: anObject 
	"^self
	This is a no-op in GemStone"

	^self
%
category: ''image shutdown''
classmethod: SpEnvironment
removeShutdownActionFor: anObject 
	"^self
	This is a no-op in GemStone"

	^self
%
category: ''os commands''
classmethod: SpEnvironment
runShellCommandString: aCommandString 
	^System performOnServer: aCommandString
%
category: ''queries''
classmethod: SpEnvironment
allSubclassesOf: aClass
"^an Array
I return the array of classes which are subclasses of aClass."

	^ClassOrganizer new allSubclassesOf: aClass
%
category: ''services''
classmethod: SpEnvironment
characterFromInteger: anInteger 
	^Character withValue: anInteger
%
category: ''services''
classmethod: SpEnvironment
integerFromString: aString 
	"^an Integer
We need this because of what looks like a bug in GemStone''s String&gt;&gt;asNumber (e.g. ''16rFF'' -&gt; 1.6000000000000000E+01, not 255).  Also, fromString: requires that aString not have any leading alphabetic characters.
Oh, and note the stupid fix for GemStone reseting the stream to the begining after doing an upToEnd."

"SpEnvironment integerFromString: ''ubuntu''" 

	| rawStream cleanedString |
	rawStream := ReadStream on: aString.
	cleanedString := ''0''.
	[rawStream atEnd] whileFalse: 
			[rawStream peek isDigit 
				ifTrue: [cleanedString := rawStream upToEnd.
						rawStream position: aString size; next. ]
				ifFalse: [rawStream next]].
	^Integer fromString: cleanedString
%
category: ''services''
classmethod: SpEnvironment
streamStartPosition
	"^an Integer
Streams start at position 0 in VisualWorks, and position 1 in GemStone(!)."

	^1
%
category: ''services''
classmethod: SpEnvironment
writeStackDumpForException: anException context: aContext to: targetStream 
"This is a no-op for now."
"	((RuntimePackager.RuntimeImageDumper new)
		instVarAt: 1 put: targetStream;
		yourself) dumpExceptionReport: anException context: aContext."
	^self
%
category: ''testing''
classmethod: SpEnvironment
isGemStone
	^true
%
category: ''testing''
classmethod: SpEnvironment
isVisualWorks
	^false
%
! ------------------- Instance methods for SpEnvironment

! Remove existing behavior from SpMD5Digest
doit
SpMD5Digest removeAllMethods.
SpMD5Digest class removeAllMethods.
%
! ------------------- Class methods for SpMD5Digest
! ------------------- Instance methods for SpMD5Digest

! Remove existing behavior from SpModel
doit
SpModel removeAllMethods.
SpModel class removeAllMethods.
%
! ------------------- Class methods for SpModel
! ------------------- Instance methods for SpModel

! Remove existing behavior from SpStringUtilities
doit
SpStringUtilities removeAllMethods.
SpStringUtilities class removeAllMethods.
%
! ------------------- Class methods for SpStringUtilities
category: ''services''
classmethod: SpStringUtilities
bytesAsString: aByteArray
	"^a String
No encoding in GemStone ... yet."

	" SpStringUtilities bytesAsString: #(72 101 108 108 111 44 32 87 111 114 108 100 46) "

	| targetString |
	targetString := String new: aByteArray size.
	1 to: aByteArray size
		do: [:index | targetString at: index put: (Character withValue: (aByteArray at: index))].
	^targetString
%
category: ''services''
classmethod: SpStringUtilities
prevIndexOf: anElement from: startIndex to: stopIndex in: aString
	"Answer the previous index of anElement within the receiver between startIndex and stopIndex
	 working backwards through the receiver.  If the receiver does not contain anElement, answer nil"

	startIndex to: stopIndex by: -1 do:
		[:i |
		(aString at: i) = anElement
			ifTrue: [^i]].
	^nil
%
category: ''services''
classmethod: SpStringUtilities
tokensBasedOn: separatorString in: aString 
	"Answer an OrderedCollection of the sub-sequences
	 of the receiver that are separated by anObject."

	| result lastIdx idx lastToken |
	result := OrderedCollection new.
	lastIdx := 0.
	
	[idx := aString findString: separatorString startingAt: lastIdx + 1.
	idx &gt; 0] 
			whileTrue: 
				[idx == (lastIdx + 1)
					ifTrue: [result addLast: String new]
					ifFalse: [result addLast: (aString copyFrom: lastIdx + 1 to: idx - 1)].
				lastIdx := idx].
	lastToken := lastIdx = aString size 
				ifTrue: [String new]
				ifFalse: [aString copyFrom: lastIdx + 1 to: aString size].
	result addLast: lastToken.
	^result
%
category: ''services''
classmethod: SpStringUtilities
trimBlanksFrom: aString 
	"^a String
I return a copy of aString with all leading and trailing blanks removed."

	| first last |
	first := 1.
	last := aString size.
	[last &gt; 0 and: [(aString at: last) isSeparator]] 
		whileTrue: [last := last - 1].
	^last == 0 
		ifTrue: [String new]
		ifFalse: 
			[[first &lt; last and: [(aString at: first) isSeparator]] 
				whileTrue: [first := first + 1].
			aString copyFrom: first to: last]
%
category: ''services-encoding''
classmethod: SpStringUtilities
bytes: subjectBytes asStringUsingEncodingNames: anEncodingName 
	"^a String
No encoding in GemStone ... yet."

	^self bytesAsString: subjectBytes
%
category: ''services-encoding''
classmethod: SpStringUtilities
string: subjectString asBytesUsingEncodingNamed: anEncodingName 
"^a ByteArray 
No encoding in GemStone ... yet."

	^subjectString asByteArray
%
category: ''services-encoding''
classmethod: SpStringUtilities
stringFromBytes: aByteArray 
	"^a String
In GemStone [''Hello, World'' asByteArray asString] returns the string ''aByteArray'' !
This is the boring long way of getting a string from a ByteArray - but it does work
in GemStone."

	"HTTPString stringFromBytes: (''Hello, World'' asByteArray)"

	| targetStream |
	targetStream := WriteStream on: String new.
	aByteArray do: [:aByte | targetStream nextPut: aByte asCharacter].
	^targetStream contents
%
! ------------------- Instance methods for SpStringUtilities

! Remove existing behavior from SpTranscript
doit
SpTranscript removeAllMethods.
SpTranscript class removeAllMethods.
%
! ------------------- Class methods for SpTranscript
category: ''logging''
classmethod: SpTranscript
cr
"^self
This is a no-op for now."
	^self
%
category: ''logging''
classmethod: SpTranscript
nextPut: anObject 
	^self show: (String with: anObject)
%
category: ''logging''
classmethod: SpTranscript
nextPutAll: aCollection 
	^self show: aCollection
%
category: ''logging''
classmethod: SpTranscript
show: aString 
"^self
This is a no-op for now."
	^self
%
! ------------------- Instance methods for SpTranscript

! Remove existing behavior from SpWeakArray
doit
SpWeakArray removeAllMethods.
SpWeakArray class removeAllMethods.
%
! ------------------- Class methods for SpWeakArray
category: ''instance creation''
classmethod: SpWeakArray
new: anInteger 
	"^a WeakArray 
	I don''t return an instance of myself, I return an Array -  until I can think of a better GemStone alternative."

	^Array new: anInteger
%
category: ''instance creation''
classmethod: SpWeakArray
withAll: aCollection 
	"^a WeakArray 
	I don''t return an instance of myself at all. I return an Array -  until I can think of a better GemStone alternative."

	^Array withAll: aCollection
%
! ------------------- Instance methods for SpWeakArray'</body>
</methods>


<methods>
<class-id>SpEnvironment class</class-id> <category>testing</category>

<body package="SpEnvironmental">isHeadless
	^self isVisualWorks and: 
			[(Smalltalk bindingFor: #HeadlessImage) notNil 
				and: [HeadlessImage default isHeadless]]</body>

<body package="SpEnvironmental">isSqueak
	^false</body>

<body package="SpEnvironmental">isVisualWorks
	^true</body>

<body package="SpEnvironmental">isGemStone
	^false</body>
</methods>

<methods>
<class-id>SpEnvironment class</class-id> <category>services</category>

<body package="SpEnvironmental">streamStartPosition
	"^an Integer
Streams start at position 0 in VisualWorks, and position 1 in GemStone(!)."

	^0</body>

<body package="SpEnvironmental">writeStackDumpForException: anException context: aContext to: targetStream 
	((RuntimePackager.RuntimeImageDumper new)
		instVarAt: 1 put: targetStream;
		yourself) dumpExceptionReport: anException context: aContext.
	^self</body>

<body package="SpEnvironmental">characterFromInteger: anInteger 
	^Character value: anInteger</body>

<body package="SpEnvironmental">integerFromString: aString
"^an Integer
We need this because of what looks like a bug in GemStone's String&gt;&gt;asNumber (e.g. '16rFF' -&gt; 1.6000000000000000E+01, not 255)."

	^aString asNumber</body>
</methods>

<methods>
<class-id>SpEnvironment class</class-id> <category>os commands</category>

<body package="SpEnvironmental">runShellCommandString: aCommandString 
	^UnixProcess cshOne: aCommandString</body>
</methods>

<methods>
<class-id>SpEnvironment class</class-id> <category>development</category>

<body package="SpEnvironmental">madeObsoleteBy: aBlock 
	"^an Object
I cause halt the code and ask the developer to use the code in aBlock, rather than the obsolete code."

	(self isHeadless or: [self isGemStone]) 
		ifFalse: 
			[1 
				halt: 'please use the code in the block, not the obsolete code - thanks.'].
	^aBlock value</body>

<body package="SpEnvironmental">workInProgress
	"^self
This method does nothing, but can be used to 'mark' methods still needing work.  Simply send this message, and use browse senders to find things still in need of attention.
A simpler way to do this is to add '#wip yourself' to the method.  Then you can look for all references to the Symbol #wip."

	^self</body>
</methods>

<methods>
<class-id>SpEnvironment class</class-id> <category>queries</category>

<body package="SpEnvironmental">allSubclassesOf: aClass
"^an Array
I return the array of classes which are subclasses of aClass."

	^aClass allSubclasses asArray</body>
</methods>

<methods>
<class-id>SpEnvironment class</class-id> <category>compiling</category>

<body package="SpEnvironmental">evaluate: aString receiver: anObject in: anEnvironment 
	^Compiler new 
		evaluate: aString
		in: nil
		allowReceiver: true
		receiver: anObject
		environment: anEnvironment
		notifying: nil
		ifFail: []</body>

<body package="SpEnvironmental">evaluate: aString in: anEnvironment
	^Compiler 
		evaluate: aString
		for: nil
		in: anEnvironment
		notifying: nil
		logged: false</body>
</methods>

<methods>
<class-id>SpEnvironment class</class-id> <category>image shutdown</category>

<body package="SpEnvironmental">removeShutdownActionFor: anObject 
	"^self
	I remove the task block for an object it it has one.  If the collection of tasks is now
	empty, I remove myself as an ObjectMemory dependent."

	(self imageShutdownTaskBlocks includesKey: anObject) 
		ifTrue: 
			[imageShutdownTaskBlocks removeKey: anObject.
			imageShutdownTaskBlocks isEmpty 
				ifTrue: [ObjectMemory removeDependent: self]].
	^self</body>

<body package="SpEnvironmental">addImageShutdownTask: aBlock for: anObject 
	"^self
	I add aBlock to the list of actions and note that this is for anObject.  If there are
	currenty no tasks, I add myself as an ObejctMemort dependant."

	self imageShutdownTaskBlocks isEmpty 
		ifTrue: [ObjectMemory addDependent: self].
	self imageShutdownTaskBlocks at: anObject put: aBlock.
	^self</body>

<body package="SpEnvironmental">imageShutdownTaskBlocks
	imageShutdownTaskBlocks isNil 
		ifTrue: [imageShutdownTaskBlocks := IdentityDictionary new].
	^imageShutdownTaskBlocks</body>

<body package="SpEnvironmental">update: aspect with: aParameter from: sender 
	(sender == ObjectMemory and: [aspect == #aboutToSnapshot]) 
		ifTrue: 
			[self imageShutdownTaskBlocks values 
				do: [:aShutdownTask | aShutdownTask value]].
	^self</body>
</methods>

<!-- Package SpFiles(2 012,janko)= -->


<class>
<name>SpFileStream</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>underlyingStream filename </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpFiles</category>
<attributes>
<package>SpFiles</package>
</attributes>
</class>

<class>
<name>SpFilesCodeForSqueak</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpFiles</category>
<attributes>
<package>SpFiles</package>
</attributes>
</class>

<class>
<name>SpFilename</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>underlyingFilename </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpFiles</category>
<attributes>
<package>SpFiles</package>
</attributes>
</class>

<class>
<name>SpFilesCodeForGemStone</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpFiles</category>
<attributes>
<package>SpFiles</package>
</attributes>
</class>





<methods>
<class-id>SpFileStream class</class-id> <category>instance creation</category>

<body package="SpFiles">appendingToFilename: anOSkFilename 
	"^an OSkFileStream
I create a new instance of myself to append to the file identified by anOSkFilename."

	^self new appendingToFilename: anOSkFilename</body>

<body package="SpFiles">writingToFileNamed: aString 
	"^an OSkFileStream
I create a new instance of myself to write to a file named aString."

	^self new writingToFileNamed: aString</body>

<body package="SpFiles">readingFromFilename: anOSkFilename 
	"^an OSkFileStream
I create a new instance of myself to read the file identified by anOSkFilename."

	^self new readingFromFilename: anOSkFilename</body>

<body package="SpFiles">readingFromFileNamed: aString 
	"^an OSkFileStream
I create a new instance of myself to read from a file named aString."

	^self new readingFromFileNamed: aString</body>

<body package="SpFiles">writingToFilename: anOSkFilename 
	"^an OSkFileStream
I create a new instance of myself to append to the file identified by anOSkFilename."

	^self new writingToFilename: anOSkFilename</body>
</methods>


<methods>
<class-id>SpFileStream</class-id> <category>services</category>

<body package="SpFiles">upTo: anObject
	^self underlyingStream upTo: anObject</body>

<body package="SpFiles">position: aNumber
	^self underlyingStream position: aNumber</body>

<body package="SpFiles">close
	^self underlyingStream close</body>

<body package="SpFiles">closed
	^self underlyingStream closed</body>

<body package="SpFiles">nextPut: anObject 
	^self underlyingStream nextPut: anObject</body>

<body package="SpFiles">cr
	^self underlyingStream cr</body>

<body package="SpFiles">atEnd
	^self underlyingStream atEnd</body>

<body package="SpFiles">position
	^self underlyingStream position</body>

<body package="SpFiles">skip: anInteger
	^self underlyingStream skip: anInteger</body>

<body package="SpFiles">nextPutAll: aCollection 
	^self underlyingStream nextPutAll: aCollection</body>

<body package="SpFiles">throughAll: aCollection
	^self underlyingStream throughAll: aCollection</body>

<body package="SpFiles">store: anObject 
	^self underlyingStream store: anObject</body>

<body package="SpFiles">next
	^self underlyingStream next</body>

<body package="SpFiles">flush
	^self underlyingStream flush</body>

<body package="SpFiles">upToAll: aCollection
	^self underlyingStream upToAll: aCollection</body>

<body package="SpFiles">upToEnd
	^self underlyingStream upToEnd</body>

<body package="SpFiles">peek
	^self underlyingStream peek</body>
</methods>

<methods>
<class-id>SpFileStream</class-id> <category>accessing</category>

<body package="SpFiles">underlyingStream
	^underlyingStream</body>

<body package="SpFiles">filename: anObject
	filename := anObject</body>

<body package="SpFiles">contentsStream
	^self underlyingStream contents readStream</body>

<body package="SpFiles">filename
	^filename</body>
</methods>

<methods>
<class-id>SpFileStream</class-id> <category>initialize-release</category>

<body package="SpFiles">appendingToFilename: anOSkFilename 
	filename := anOSkFilename asString.
	underlyingStream := anOSkFilename underlyingFilename appendStream.
	underlyingStream lineEndTransparent.
	^self</body>

<body package="SpFiles">writingToFileNamed: aString 
	"^self
I initialize myself to write to a file named aString."

	filename := aString.
	underlyingStream := (Filename named: aString) writeStream.
	underlyingStream lineEndTransparent.
	^self</body>

<body package="SpFiles">readingFromFilename: anOSkFilename 
	filename := anOSkFilename asString.
	underlyingStream := anOSkFilename underlyingFilename readStream.
	underlyingStream lineEndTransparent.
	^self</body>

<body package="SpFiles">readingFromFileNamed: aString 
	"^self
I initialize myself to write to a file named aString."

	filename := aString.
	underlyingStream := (Filename named: aString) readStream.
	underlyingStream lineEndTransparent.
	^self</body>

<body package="SpFiles">writingToFilename: anOSkFilename 
	filename := anOSkFilename asString.
	underlyingStream := anOSkFilename underlyingFilename writeStream.
	underlyingStream lineEndTransparent.
	^self</body>
</methods>


<methods>
<class-id>SpFilename class</class-id> <category>instance creation</category>

<body package="SpFiles">named: aString 
	"^an OSkFilename
I create a new instance of myself to represent the filename identified by aString."

	^self new named: aString</body>
</methods>


<methods>
<class-id>SpFilename</class-id> <category>services</category>

<body package="SpFiles">appendStream
	"^an OSkFileStream
I create an append stream on the file I represent."

	^SpFileStream appendingToFilename: self</body>

<body package="SpFiles">writeStream
	"^an OSkFileStream
I create a write stream on the file I represent."

	^SpFileStream writingToFilename: self</body>

<body package="SpFiles">readStream
	"^an OSkFileStream
I create a read stream on the file I represent."

	^SpFileStream readingFromFilename: self</body>

<body package="SpFiles">asString
	^self underlyingFilename asString</body>
</methods>

<methods>
<class-id>SpFilename</class-id> <category>testing</category>

<body package="SpFiles">exists
	"^a Boolian
I return true if the file I represent actually exists, otherwise false."

	^self underlyingFilename exists</body>
</methods>

<methods>
<class-id>SpFilename</class-id> <category>initialize-release</category>

<body package="SpFiles">named: aString 
	"^self
I initialize myself to represent the filename identified by aString."

	underlyingFilename := Filename named: aString.
	^self</body>
</methods>

<methods>
<class-id>SpFilename</class-id> <category>private</category>

<body package="SpFiles">underlyingFilename
	"^a Filename
I return the Filename instance that I am a wrapper for."

	^underlyingFilename</body>
</methods>


<methods>
<class-id>SpFilesCodeForSqueak class</class-id> <category>code strings</category>

<body package="SpFiles">codeString
	"^a String
	I return the string which is the source code for the GemStone compatibility classes."

	"(Filename named: 'SpFiles-squeak.st') writeStream nextPutAll: self codeString; close"

	^'Object subclass: #SpFilename
	instanceVariableNames: ''underlyingFilename''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpFiles''!

!SpFilename methodsFor: ''testing'' stamp: ''BB 1/25/2006 15:56''!
exists
	"^a Boolian
I return true if the file I represent actually exists, otherwise false."

	^self underlyingFilename exists! !


!SpFilename methodsFor: ''private'' stamp: ''BB 1/25/2006 15:56''!
underlyingFilename
	"^a Filename
I return the Filename instance that I am a wrapper for."

	^underlyingFilename! !


Object subclass: #SpFileStream
	instanceVariableNames: ''underlyingStream filename''
	classVariableNames: ''''
	poolDictionaries: ''''
	category: ''SpFiles''!

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:00''!
atEnd
	^self underlyingStream atEnd! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:00''!
close
	^self underlyingStream close! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:00''!
closed
	^self underlyingStream closed! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:01''!
cr
	^self underlyingStream cr! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:01''!
flush
	^self underlyingStream flush! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:01''!
next
	^self underlyingStream next! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:01''!
nextPutAll: aCollection 
	^self underlyingStream nextPutAll: aCollection! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:01''!
nextPut: anObject 
	^self underlyingStream nextPut: anObject! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:01''!
peek
	^self underlyingStream peek! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:01''!
position
	^self underlyingStream position! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:02''!
position: aNumber
	^self underlyingStream position: aNumber! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:02''!
skip: anInteger
	^self underlyingStream skip: anInteger! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:02''!
store: anObject 
	^self underlyingStream store: anObject! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:02''!
throughAll: aCollection
	^self underlyingStream throughAll: aCollection! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:05''!
upToAll: aCollection
	^self underlyingStream upToAll: aCollection! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:05''!
upToEnd
	^self underlyingStream upToEnd! !

!SpFileStream methodsFor: ''services'' stamp: ''BB 1/25/2006 16:02''!
upTo: anObject
	^self underlyingStream upTo: anObject! !


!SpFileStream methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 15:58''!
appendingToFilename: anOSkFilename 
	filename := anOSkFilename asString.
	underlyingStream := anOSkFilename underlyingFilename appendStream.
	underlyingStream lineEndTransparent.
	^self! !

!SpFileStream methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 15:58''!
readingFromFileNamed: aString 
	"^self
I initialize myself to write to a file named aString."

	filename := aString.
	underlyingStream := (FileUrl named: aString) readStream.
	underlyingStream lineEndTransparent.
	^self! !

!SpFileStream methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 15:58''!
readingFromFilename: anOSkFilename 
	filename := anOSkFilename asString.
	underlyingStream := anOSkFilename underlyingFilename readStream.
	underlyingStream lineEndTransparent.
	^self! !

!SpFileStream methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 16:00''!
writingToFileNamed: aString 
	"^self
I initialize myself to write to a file named aString."

	filename := aString.
	underlyingStream := (FileUrl named: aString) writeStream.
	underlyingStream lineEndTransparent.
	^self! !

!SpFileStream methodsFor: ''initialize-release'' stamp: ''BB 1/25/2006 15:59''!
writingToFilename: anOSkFilename 
	filename := anOSkFilename asString.
	underlyingStream := anOSkFilename underlyingFilename writeStream.
	underlyingStream lineEndTransparent.
	^self! !


!SpFileStream methodsFor: ''accessing'' stamp: ''BB 1/25/2006 15:57''!
contentsStream
	^self underlyingStream contents readStream! !

!SpFileStream methodsFor: ''accessing'' stamp: ''BB 1/25/2006 15:57''!
filename
	^filename! !

!SpFileStream methodsFor: ''accessing'' stamp: ''BB 1/25/2006 15:57''!
filename: anObject
	filename := anObject! !

!SpFileStream methodsFor: ''accessing'' stamp: ''BB 1/25/2006 15:58''!
underlyingStream
	^underlyingStream! !
'</body>
</methods>


<methods>
<class-id>SpFilesCodeForGemStone class</class-id> <category>code strings</category>

<body package="SpFiles">codeString
	"^a String
	I return the string which is the source code for the GemStone compatibility classes."

	"(Filename named: 'SpFiles.gs') writeStream nextPutAll: self codeString; close"

	^'!
! From ! GEMSTONE: 6.1, Thu Apr 17 20:11:38 US/Pacific 2003; IMAGE: GemStone v6.1 kernel classes filein completed at 17/04/2003 20:22:36

! GemStone v6.1 kernel classes filein of stripped sources completed at 17/04/2003 20:31:50

! 

! On September 9, 2005, 12:19:21 pm
!
!
! SymbolDictionary ''SpFiles''
!
run
| symList newDict |
symList := System myUserProfile symbolList.
symList do: [ :element |
    (element includesKey: #SpFiles)
        ifTrue: [ ^element ]
].
newDict := SymbolDictionary new.
newDict at: #SpFiles put: newDict.
System myUserProfile insertDictionary: newDict at: 1.
^newDict
%
doit
(Object subclass: ''SpFilename''  instVarNames: #( filenameString)  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpFiles  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
(Object subclass: ''SpFileStream''  instVarNames: #( underlyingStream filename)  classVars: #()  classInstVars: #()  poolDictionaries: #[]  inDictionary: SpFiles  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
SpFilename immediateInvariant.
%
doit
SpFileStream immediateInvariant.
%

! Remove existing behavior from SpFilename
doit
SpFilename removeAllMethods.
SpFilename class removeAllMethods.
%
! ------------------- Class methods for SpFilename
category: ''instance creation''
classmethod: SpFilename
named: aString 
	"^an SpFilename
I create a new instance of myself to represent the filename identified by aString."

	^self new named: aString
%
! ------------------- Instance methods for SpFilename
category: ''initialize-release''
method: SpFilename
named: aFilenameString 
        "^self
I initialize myself to represent the filename identified by aString."

        filenameString := aFilenameString.
        ^self 
%
category: ''private''
method: SpFilename
filenameString
        ^filenameString
%
category: ''services''
method: SpFilename
appendStream
	"^an SpFileStream
I create an append stream on the file I represent."

	^SpFileStream appendingToFilename: self
%
category: ''services''
method: SpFilename
asString
	^self filenameString
%
category: ''services''
method: SpFilename
readStream
	"^an SpFileStream
I create a read stream on the file I represent."

	^SpFileStream readingFromFilename: self
%
category: ''services''
method: SpFilename
writeStream
	"^an SpFileStream
I create a write stream on the file I represent."

	^SpFileStream writingToFilename: self
%
category: ''testing''
method: SpFilename
exists
	"^a Boolian
I return true if the file I represent actually exists, otherwise false."

	^GsFile exists: self filenameString
%

! Remove existing behavior from SpFileStream
doit
SpFileStream removeAllMethods.
SpFileStream class removeAllMethods.
%
! ------------------- Class methods for SpFileStream
category: ''instance creation''
classmethod: SpFileStream
appendingToFilename: anSpFilename 
	"^an SpFileStream
I create a new instance of myself to append to the file identified by anSpFilename."

	^self new appendingToFilename: anSpFilename
%
category: ''instance creation''
classmethod: SpFileStream
readingFromFilename: anSpFilename 
	"^an SpFileStream
I create a new instance of myself to read the file identified by anSpFilename."

	^self new readingFromFilename: anSpFilename
%
category: ''instance creation''
classmethod: SpFileStream
readingFromFileNamed: aString 
	"^an SpFileStream
I create a new instance of myself to read from a file named aString."

	^self new readingFromFileNamed: aString
%
category: ''instance creation''
classmethod: SpFileStream
writingToFilename: anSpFilename 
	"^an SpFileStream
I create a new instance of myself to append to the file identified by anSpFilename."

	^self new writingToFilename: anSpFilename
%
category: ''instance creation''
classmethod: SpFileStream
writingToFileNamed: aString 
	"^an SpFileStream
I create a new instance of myself to write to a file named aString."

	^self new writingToFileNamed: aString
%
! ------------------- Instance methods for SpFileStream
category: ''accessing''
method: SpFileStream
contentsStream
	^self underlyingStream contents readStream
%
category: ''accessing''
method: SpFileStream
filename
	^filename
%
category: ''accessing''
method: SpFileStream
filename: anObject
	filename := anObject
%
category: ''accessing''
method: SpFileStream
underlyingStream
	^underlyingStream
%
category: ''initialize-release''
method: SpFileStream
appendingToFilename: anSpFilename 
	filename := anSpFilename asString.
	underlyingStream := GsFile openAppend: anSpFilename filenameString.
	^self
%
category: ''initialize-release''
method: SpFileStream
readingFromFilename: anSpFilename 
	filename := anSpFilename asString.
	underlyingStream := GsFile openRead: anSpFilename filenameString.
	^self

%
category: ''initialize-release''
method: SpFileStream
readingFromFileNamed: aString 
	"^self
I initialize myself to read from a file named aString."

	filename := aString.
	underlyingStream := GsFile openRead: aString.
	^self
%
category: ''initialize-release''
method: SpFileStream
writingToFilename: anSpFilename 
	filename := anSpFilename asString.
	underlyingStream := GsFile openWrite: anSpFilename filenameString.
	^self

%
category: ''initialize-release''
method: SpFileStream
writingToFileNamed: aString 
	"^self
I initialize myself to write to a file named aString."

	filename := aString.
	underlyingStream := GsFile openWrite: aString.
	^self
%
category: ''services''
method: SpFileStream
atEnd
	^self underlyingStream atEnd
%
category: ''services''
method: SpFileStream
close
	^self underlyingStream close
%
category: ''services''
method: SpFileStream
closed
	^self underlyingStream isOpen not
%
category: ''services''
method: SpFileStream
cr
	^self underlyingStream cr
%
category: ''services''
method: SpFileStream
flush
	^self underlyingStream flush
%
category: ''services''
method: SpFileStream
next
	^self underlyingStream next
%
category: ''services''
method: SpFileStream
nextPut: anObject
	^self underlyingStream nextPut: anObject
%
category: ''services''
method: SpFileStream
nextPutAll: aCollection 
	^self underlyingStream nextPutAll: aCollection
%
category: ''services''
method: SpFileStream
peek
	^self underlyingStream peek
%
category: ''services''
method: SpFileStream
position
	^self underlyingStream position
%
category: ''services''
method: SpFileStream
position: aNumber
	^self underlyingStream position: aNumber
%
category: ''services''
method: SpFileStream
skip: anInteger
	^self underlyingStream skip: anInteger
%
category: ''services''
method: SpFileStream
throughAll: aCollection
	^self underlyingStream throughAll: aCollection
%
category: ''services''
method: SpFileStream
upTo: anObject 
	"^a Collection
I return the content of my underlying file up to anObject or the end of the file, excluding anObject.  The stream (file) is left positioned *after* anObject."

	| targetStream |
	targetStream := WriteStream on: String new.
	[self underlyingStream atEnd or: [self underlyingStream peek == anObject]] 
		whileFalse: [targetStream nextPut: self underlyingStream next].
	self underlyingStream atEnd ifFalse: [self underlyingStream next].
	^targetStream contents
%
category: ''services''
method: SpFileStream
upToAll: aCollection
	^self underlyingStream upToAll: aCollection
%'</body>
</methods>

<!-- Package SpPortabilityTools(2 012,janko)= -->


<component-property>
<name>SpPortabilityTools</name> <type>package</type>
<property>comment</property> <value>'See the comment on the class OSkPortabilityToolBox'</value>
</component-property>

<class>
<name>SpPortabilityToolBox</name>
<environment>Smalltalk</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>SpPortabilityTools</category>
<attributes>
<package>SpPortabilityTools</package>
</attributes>
</class>

<comment>
<class-id>SpPortabilityToolBox</class-id>
<body>This class is home to tools and scripts that help manage the portability code.

	To export the portability the complete library to the currently logged in GemStone session:

		"OSkPortabilityToolBox compileAllPortabilityLibraryInGemStone"



</body>
</comment>


<methods>
<class-id>SpPortabilityToolBox class</class-id> <category>code</category>

<body package="SpPortabilityTools">gsRandomClassCodeString
"^a String
This is the GemStone source code of an implementation of the Random class written by GemStone."

	"(Filename named: 'GsRandom.gs') writeStream nextPutAll: self codeString; close"

	^'!=========================================================================
! Copyright (C) GemStone Systems, Inc. 1986-1998.  All Rights Reserved.
!
! $Id: random.gs,v 50.9 1998/01/15 23:49:11 darrel Exp $
!
! Superclass Hierarchy:
!   Stream, Object.
!
!=========================================================================

!
! From ! GEMSTONE: 6.1, Thu Apr 17 20:11:38 US/Pacific 2003; IMAGE: GemStone v6.1 kernel classes filein completed at 17/04/2003 20:22:36

! GemStone v6.1 kernel classes filein of stripped sources completed at 17/04/2003 20:31:50

! 

! On July 21, 2004, 7:49:40 am
!
!
! SymbolDictionary ''GsRandom''
!
run
| symList newDict |
symList := System myUserProfile symbolList.
symList do: [ :element |
    (element includesKey: #GsRandom)
        ifTrue: [ ^element ]
].
newDict := SymbolDictionary new.
newDict at: #GsRandom put: newDict.
System myUserProfile insertDictionary: newDict at: 1.
^newDict
%
doit
(Stream subclass: ''Random''  instVarNames: #( seed hi lo)  classVars: #( a m q r)  classInstVars: #()  poolDictionaries: #[]  inDictionary: GsRandom  constraints: #[]  instancesInvariant: false  isModifiable: true)
.
%
doit
Random immediateInvariant.
%

! Remove existing behavior from Random
doit
Random removeAllMethods.
Random class removeAllMethods.
%
! ------------------- Class methods for Random
category: ''(as yet unclassified)''
classmethod: Random
initialize

  "Class initialization"

  a := 16807.0.
  m := 2147483647.0.
  q := m // a.
  r := m \\ a.
%
category: ''For Documentation Installation only''
classmethod: Random
installDocumentation

| doc txt |
doc := GsClassDocumentation newForClass: self.

txt := (GsDocText new) details:
''Class Random is a port of Jeff Sutherland''''s implementation of the
 Park &amp; Miller random number generator.

From Jeff Sutherland''''s original posting:

"In summary...(this is) a generator which has a full period, is
demonstrably random, and can be implemented correctly on almost
any system.  The generator has been exhaustively tested and its
characteristics are well understood... Moreover, it has become a
standard ... subroutine DNUN in the IMSL library and ... DRAND
in the simulation language SLAM II...  we feel confident in
recommending this random number generator as a minimal standard
against which all others should be judged."

This code has received minimal testing on an IBM P75 486 machine
and may break on a Pentium.  It is written in Enfin Smalltalk but
a port to another Smalltalk is trivial.  The validate function works
but any bugs you find are surely mine.  Send me a note at
jsutherland@vmark.com.'' .
doc documentClassWith: txt.

self description: doc.
%
category: ''Instance Creation''
classmethod: Random
new
 ^super new initialize.
%
category: ''Testing''
classmethod: Random
speed
       "Random speed will benchmark the efficiency of random number
generation"

|rand|

rand := self new.

^(System millisecondsToRun: [ 1000 timesRepeat: [rand next]
  ]) / 1000.0
%
category: ''Testing''
classmethod: Random
testRandom
       "Random testRandom will check your hardware environment"
|num|
num := Random new initialize.
num seed: 1.
10000 timesRepeat: [
  num next.
].
(1043618065 = num seed)
  ifTrue: [ ^''OK.'' ]
  ifFalse: [ ^''Bad result. Fix this generator
             by referring to Park &amp; Miller,^M
             Communications of the ACM 31:10:1192-1201, 1988.'' ].
%
! ------------------- Instance methods for Random
category: ''Accessing''
method: Random
next
 "Answer the next random number."

"Real Random Number generator Version 2 from Park and Miller, 1988"
  hi := seed quo: q.
  lo := seed - (q * hi).
  seed := (a * lo) - (r * hi).
  seed &gt; 0 ifFalse: [
    seed := seed + m].
  ^ seed / m.
%
category: ''Accessing''
method: Random
seed

   "Return the value of the instance variable ''seed''."
   ^seed
%
category: ''accessing''
method: Random
between: min and: max

   "Return a random value x such that min &lt;= x &lt; max"

  ^(self next * (max - min)) + min
%
category: ''accessing''
method: Random
contents
 "Random numbers do not have a contents so provide
 an error notification."

 ^self shouldNotImplement: #contents
%
category: ''accessing''
method: Random
flush
 "Random numbers do not need to flush."

 ^self shouldNotImplement: #flush
%
category: ''accessing''
method: Random
nextPut: anObject
 "Random numbers do not implement nextPut: so provide an
 error notification."

 ^self shouldNotImplement: #nextPut:
%
category: ''Initialization''
method: Random
seed: aSeed
  seed := aSeed.
  hi := lo := nil.
%
category: ''Private''
method: Random
initialize

  "Initialize an instance, seeded by the time of day"

  self seed: System _timeMs
%
category: ''testing''
method: Random
atEnd
 "Answer false that the stream is not at an end."

 ^false
%'</body>
</methods>

<methods>
<class-id>SpPortabilityToolBox class</class-id> <category>tools</category>

<body package="SpPortabilityTools">compileAllPortabilityLibraryInGemStone
	(GbxClassReader on: SpExceptionCodeForGemStone codeString readStream) 
		fileIn.
	(GbxClassReader on: SpTimesCodeForGemStone codeString readStream)
		fileIn.
	(GbxClassReader on: SpSocketsCodeForGemStone codeString readStream) 
		fileIn.
	(GbxClassReader on: SpEnvironmentalCodeForGemStone codeString readStream) 
		fileIn.
	(GbxClassReader on: SpFilesCodeForGemStone codeString readStream) 
		fileIn.
	(GbxClassReader on: self gsRandomClassCodeString readStream) 
		fileIn.
	^self</body>
</methods>

<!-- Package Swazoo-Compatibility(1.1.3,janko)= -->


<name-space>
<name>Swazoo</name>
<environment>Smalltalk</environment>
<private>false</private>
<imports>
			private Smalltalk.*
			</imports>
<category>Swazoo</category>
<attributes>
<package>Swazoo-Compatibility</package>
</attributes>
</name-space>

<class>
<name>SwazooStream</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>socket readBuffer writeStream </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo</category>
<attributes>
<package>Swazoo-Compatibility</package>
</attributes>
</class>

<class>
<name>HTTPStream</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>underlyingStream </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-Compatibility</package>
</attributes>
</class>

<class>
<name>HTTPWriteStream</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPStream</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>stream </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-Compatibility</package>
</attributes>
</class>

<class>
<name>HTTPReadStream</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPStream</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-Compatibility</package>
</attributes>
</class>

<class>
<name>SwazooCompiler</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>accessor </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo</category>
<attributes>
<package>Swazoo-Compatibility</package>
</attributes>
</class>

<class>
<name>HTTPString</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Compatibility</category>
<attributes>
<package>Swazoo-Compatibility</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPString</class-id>
<body>This class contains some utility methods that were previously implemented as extentions to system classes.  This is really a stop-gap until, perhaps, the SwazooStream yeilds HTTPStrings.

</body>
</comment>

<class>
<name>SwazooSocket</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>accessor </inst-vars>
<class-inst-vars>socketClass </class-inst-vars>
<imports></imports>
<category>Swazoo-Core</category>
<attributes>
<package>Swazoo-Compatibility</package>
</attributes>
</class>










<methods>
<class-id>Swazoo.SwazooStream class</class-id> <category>instance creation</category>

<body package="Swazoo-Compatibility">socket: aSwazooSocket 
	^self new setSocket: aSwazooSocket</body>

<body package="Swazoo-Compatibility">connectedPair
	^SwazooSocket connectedPair collect: [:each | self socket: each]</body>
</methods>


<methods>
<class-id>Swazoo.SwazooStream</class-id> <category>accessing</category>

<body package="Swazoo-Compatibility">nextPut: aCharacter 
	self nextPutAll: (String with: aCharacter).
	^aCharacter</body>

<body package="Swazoo-Compatibility">cr
	self nextPut: Character cr</body>

<body package="Swazoo-Compatibility">print: anObject 
	anObject printOn: self</body>

<body package="Swazoo-Compatibility">atEnd
	^false</body>

<body package="Swazoo-Compatibility">next: anInteger 
	"^aString
	We use a Stream to convert the ByteArray to a String because in GemStone
	ByteArray&gt;&gt;asString always returns the string 'aByteArray' :-/
	... but of course, this does not handle character encoding properly."

	| targetStream |
	targetStream := WriteStream on: String new.
	(self nextBytes: anInteger) 
		do: [:aByte | targetStream nextPut: aByte asCharacter].
	^targetStream contents</body>

<body package="Swazoo-Compatibility">nextPutAll: aString 
	self nextPutBytes: aString asByteArray.
	^aString</body>

<body package="Swazoo-Compatibility">space
	self nextPut: Character space</body>

<body package="Swazoo-Compatibility">next
	^(self next: 1) first</body>

<body package="Swazoo-Compatibility">flush
	"actually write to the tcp socket"
	| contents remaining |
	contents := self writeStream contents.
	remaining := contents size.
	[remaining &gt; 0] whileTrue: [| written |
		written := self socket 
			write: (contents copyFrom: contents size - remaining + 1 to: contents size).
		remaining := remaining - written].
	self initWriteStream.</body>

<body package="Swazoo-Compatibility">socket
	^socket</body>

<body package="Swazoo-Compatibility">peek
	^self peekByte asCharacter</body>

<body package="Swazoo-Compatibility">upTo: aCharacter 
	| ws char |
	ws := String new writeStream.
	[char := self next.
	char = aCharacter] whileFalse: [ws nextPut: char].
	^ws contents</body>

<body package="Swazoo-Compatibility">close
	self socket close</body>
</methods>

<methods>
<class-id>Swazoo.SwazooStream</class-id> <category>accessing-bytes</category>

<body package="Swazoo-Compatibility">nextPutByte: aByte 
	self nextPutBytes: (ByteArray with: aByte).
	^aByte</body>

<body package="Swazoo-Compatibility">nextByte
	^(self nextBytes: 1) first</body>

<body package="Swazoo-Compatibility">peekByte
	self syncBuffer.
	^self readBuffer peek</body>

<body package="Swazoo-Compatibility">nextBytes: requestedNumberOfBytes 
	"^a ByteArray
I read the requestedNumberOfBytes from my underlying ReadStream.  This is expexted to be the raw HTTP byte stream."

	| nextBytes |
	nextBytes := ByteArray new: requestedNumberOfBytes.
	1 to: requestedNumberOfBytes
		do: 
			[:index | 
			self syncBuffer.
			nextBytes at: index put: self readBuffer next].
	^nextBytes</body>

<body package="Swazoo-Compatibility">nextPutBytes: aByteArray 
	self writeStream nextPutAll: aByteArray.
	^aByteArray</body>
</methods>

<methods>
<class-id>Swazoo.SwazooStream</class-id> <category>private-initialize</category>

<body package="Swazoo-Compatibility">setSocket: aSwazooSocket 
	self socket: aSwazooSocket.
	self readBuffer: (ReadStream on: ByteArray new)</body>

<body package="Swazoo-Compatibility">initWriteStream
	"temporary stream. flush it to socket ocassionaly!"
	writeStream := WriteStream on: (ByteArray new: 1000)</body>
</methods>

<methods>
<class-id>Swazoo.SwazooStream</class-id> <category>private</category>

<body package="Swazoo-Compatibility">writeStream
	writeStream isNil ifTrue: [self initWriteStream].
	^writeStream</body>

<body package="Swazoo-Compatibility">readBuffer: aStream
	readBuffer := aStream</body>

<body package="Swazoo-Compatibility">socket: aSocket
	socket := aSocket</body>

<body package="Swazoo-Compatibility">syncBuffer
	self readBuffer atEnd ifTrue: [self fillBuffer]</body>

<body package="Swazoo-Compatibility">readBuffer
	"^a ReadStream
I return a ReadStream on the current read buffer.  See &gt;&gt;fillBuffer to understand how the buffer is filled."
	^readBuffer</body>

<body package="Swazoo-Compatibility">fillBuffer
	self readBuffer: (ReadStream on: (self socket read: 1024) ).
	self readBuffer atEnd 
		ifTrue: [SpError raiseSignal: 'No data available.  Socket probably closed']</body>
</methods>


<methods>
<class-id>Swazoo.HTTPStream class</class-id> <category>instance creation</category>

<body package="Swazoo-Compatibility">onStream: aStream 
	^self new onStream: aStream</body>
</methods>


<methods>
<class-id>Swazoo.HTTPStream</class-id> <category>accessing-private</category>

<body package="Swazoo-Compatibility">underlyingStream
	^underlyingStream</body>
</methods>

<methods>
<class-id>Swazoo.HTTPStream</class-id> <category>initialize-release</category>

<body package="Swazoo-Compatibility">onStream: aStream 
	underlyingStream := aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPStream</class-id> <category>accessing</category>

<body package="Swazoo-Compatibility">contents
	^self underlyingStream contents</body>
</methods>


<methods>
<class-id>Swazoo.HTTPWriteStream</class-id> <category>accessing</category>

<body package="Swazoo-Compatibility">ht
	"^self
I write a horzintal tab to my underlying stream.  HT is the term used in RFC2616."

	self underlyingStream nextPut: Character tab.
	^self</body>

<body package="Swazoo-Compatibility">lf
	"^self
I write a LF pair to my underlying stream."

	self underlyingStream nextPut: Character lf.
	^self</body>

<body package="Swazoo-Compatibility">sp
	"^self
I write a space to my underlying stream.  SP is the term used in RFC2616."

	self underlyingStream nextPut: Character space.
	^self</body>

<body package="Swazoo-Compatibility">nextPutAll: aCollection 
	"^self
I write aCollection to my underlying stream.  For now, I'll let anything go."

	^self underlyingStream nextPutAll: aCollection</body>

<body package="Swazoo-Compatibility">nextPutLine: aCollection 
	"^self
I write aCollection to my underlying stream followed by a &gt;&gt;crlf."

	self underlyingStream nextPutAll: aCollection.
	self crlf.
	^self</body>

<body package="Swazoo-Compatibility">crlf
	"^self
I write a CRLF pair to my underlying stream."

	self
		cr;
		lf.
	^self</body>

<body package="Swazoo-Compatibility">cr
	"^self
I write a CR to my underlying stream."

	self underlyingStream nextPut: Character cr.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPString class</class-id> <category>tokens</category>

<body package="Swazoo-Compatibility">subCollectionsFrom: aCollection delimitedBy: anObject 
	"^an OrderedCollection
I return the ordered collection of sub-collections from aCollection, delimited
by anObject."

	"HTTPString subCollectionsFrom: 'aaa/bbb/' delimitedBy: $/"

	| subCollections sourceStream |
	subCollections := OrderedCollection new.
	sourceStream := ReadStream on: aCollection.
	[sourceStream atEnd] 
		whileFalse: [subCollections add: (sourceStream upTo: anObject)].
	(aCollection isEmpty 
		or: [(sourceStream
				skip: -1;
				next) == anObject]) 
			ifTrue: [subCollections add: aCollection class new].
	^subCollections</body>
</methods>

<methods>
<class-id>Swazoo.HTTPString class</class-id> <category>decoding</category>

<body package="Swazoo-Compatibility">stringFromBytes: aByteArray 
	"^a String
In GemStone ['Hello, World' asByteArray asString] returns the string 'aByteArray' !
This is the boring long way of getting a string from a ByteArray - but it does work
in GemStone."

	"HTTPString stringFromBytes: ('Hello, World' asByteArray)"

	| targetStream |
	targetStream := WriteStream on: String new.
	aByteArray do: [:aByte | targetStream nextPut: aByte asCharacter].
	^targetStream contents</body>

<body package="Swazoo-Compatibility">decodedHTTPFrom: aCharacterArray 
	"Code taken from the swazoo specific extention to the CharacterArray class"

	| targetStream sourceStream |
	targetStream := WriteStream on: aCharacterArray class new.
	sourceStream := ReadStream on: aCharacterArray.
	[sourceStream atEnd] whileFalse: 
			[| char |
			char := sourceStream next.
			char = $% 
				ifTrue: 
					[targetStream 
						nextPut: (SpEnvironment integerFromString: '16r' , (sourceStream next: 2)) 
								asCharacter]
				ifFalse: 
					[char == $+ 
						ifTrue: [targetStream nextPut: Character space]
						ifFalse: [targetStream nextPut: char]]].
	^targetStream contents</body>

<body package="Swazoo-Compatibility">trimBlanksFrom: aString 
	"^a String
I return a copy of aString with all leading and trailing blanks removed."

	| first last |
	first := 1.
	last := aString size.
	[last &gt; 0 and: [(aString at: last) isSeparator]] 
		whileTrue: [last := last - 1].
	^last == 0 
		ifTrue: [String new]
		ifFalse: 
			[[first &lt; last and: [(aString at: first) isSeparator]] 
				whileTrue: [first := first + 1].
			aString copyFrom: first to: last]</body>

<body package="Swazoo-Compatibility">isHTTPReservedCharacter: aCharacter 
	"Code taken from the swazoo specific extention to the Character class"

	^(aCharacter isAlphaNumeric or: ['-_.!~*''()' includes: aCharacter]) not</body>

<body package="Swazoo-Compatibility">encodedHTTPFrom: aCharacterArray 
	"Code taken from the swazoo specific extention to the CharacterArray class"

	| targetStream |
	targetStream := WriteStream on: aCharacterArray class new.
	aCharacterArray do: 
			[:char | 
			(self isHTTPReservedCharacter: char) 
				ifTrue: 
					[targetStream nextPut: $%.
					char asInteger 
						printOn: targetStream
						paddedWith: $0
						to: 2
						base: 16]
				ifFalse: [targetStream nextPut: char]].
	^targetStream contents</body>
</methods>

<methods>
<class-id>Swazoo.HTTPString class</class-id> <category>instance creation</category>

<body package="Swazoo-Compatibility">newRandomString: anInteger 
	| numbersThroughAlphas targetStream char random |
	numbersThroughAlphas := (48 to: 122) collect: [:each | each asCharacter].
	targetStream := WriteStream on: (String new: anInteger).
	random := Random new.
	[targetStream contents size &lt; anInteger] whileTrue: 
			[char := numbersThroughAlphas 
						at: (random next * (numbersThroughAlphas size - 1)) rounded + 1.
			char isAlphaNumeric ifTrue: [targetStream nextPut: char]].
	^targetStream contents</body>
</methods>


<methods>
<class-id>Swazoo.HTTPReadStream</class-id> <category>accessing</category>

<body package="Swazoo-Compatibility">next: numberOfElements
	^self underlyingStream next: numberOfElements</body>

<body package="Swazoo-Compatibility">upToEnd
	^self underlyingStream upToEnd</body>

<body package="Swazoo-Compatibility">peek
	"^an object or nil
I return the next object in the underlying stream if there is one."

	^self underlyingStream peek</body>

<body package="Swazoo-Compatibility">next
	^self underlyingStream next</body>

<body package="Swazoo-Compatibility">nextBytes: anInteger 
	^self underlyingStream nextBytes: anInteger</body>

<body package="Swazoo-Compatibility">upTo: aCharacter 
	"^a String
Much of the Swazoo reading assumes characters rather than bytes.  Here we get the bytes from the underlying stream and convert each byte into a character."

	| subjectBytes targetString |
	subjectBytes := self underlyingStream upTo: aCharacter.
	targetString := String new: subjectBytes size.
	1 to: subjectBytes size
		do: [:index | targetString at: index put: (subjectBytes at: index) asCharacter].
	^targetString</body>

<body package="Swazoo-Compatibility">nextUnfoldedLine
	"^a String
c.f. RFC 2616 2.2 Basic Rules
   HTTP/1.1 header field values can be folded onto multiple lines if the
   continuation line begins with a space or horizontal tab.
So, I read the next line, the I read subsequent lines until I get to one that is not a contuation.  I add the contents of the continuation lines to the target stream.  I leave my underlying stream positioned at the immediately after the last continuation.  If the initial line is empty this is the last line in the stream, so I read no more."

	| targetStream |
	targetStream := WriteStream on: String new.
	self writeNextLineTo: targetStream.
	targetStream contents isEmpty 
		ifFalse: 
			[
			[| nextCharacter |
			nextCharacter := self peek.
			nextCharacter notNil 
				and: [nextCharacter == Character space or: [nextCharacter == Character tab]]] 
					whileTrue: [self writeNextLineTo: targetStream]].
	^targetStream contents</body>

<body package="Swazoo-Compatibility">nextLine
	"^a String
I return the next line from my underlying stream.  This means reading everything up to the next crlf."

	| targetStream |
	targetStream := WriteStream on: String new.
	self writeNextLineTo: targetStream.
	^targetStream contents</body>

<body package="Swazoo-Compatibility">writeNextLineTo: aStream 
	aStream nextPutAll: (self underlyingStream upTo: Character cr).
	^self underlyingStream peek = Character lf 
		ifTrue: [self underlyingStream next]
		ifFalse: [SwazooHTTPParseError raiseSignal: 'CR without LF']</body>
</methods>


<methods>
<class-id>Swazoo.SwazooSocket class</class-id> <category>private</category>

<body package="Swazoo-Compatibility">socketClass: aClass 
	"^self
I record the class of my underlying socket."

	socketClass := aClass.
	^self</body>

<body package="Swazoo-Compatibility">socketClass
	"^a Class
I return the class of my underlying socket.  This may in fact be a pseudo socket thing if we are testing."

	socketClass isNil ifTrue: [socketClass := SpSocket].
	^socketClass</body>

<body package="Swazoo-Compatibility">accessor: aSocketAccessor 
	^self new accessor: aSocketAccessor</body>
</methods>

<methods>
<class-id>Swazoo.SwazooSocket class</class-id> <category>instance creation</category>

<body package="Swazoo-Compatibility">connectedPair
	^self socketClass newSocketPair collect: [:each | self accessor: each]</body>

<body package="Swazoo-Compatibility">serverOnIP: anIPString port: anInteger 
	| newSocket |
	newSocket := self socketClass newTCPSocket.
	newSocket
		setAddressReuse: true;
		bindSocketAddress: (SpIPAddress hostName: anIPString port: anInteger).
	^self accessor: newSocket</body>

<body package="Swazoo-Compatibility">connectTo: aHostString port: anInteger 
	| newSocket |
	newSocket := self socketClass newTCPSocket.
	newSocket 
		connectTo: (SpIPAddress hostName: aHostString port: anInteger).
	^self accessor: newSocket</body>
</methods>


<methods>
<class-id>Swazoo.SwazooSocket</class-id> <category>server accessing</category>

<body package="Swazoo-Compatibility">accept
	^self class accessor: self accessor acceptRetryingIfTransientErrors</body>

<body package="Swazoo-Compatibility">listenFor: anInteger 
	self accessor listenBackloggingUpTo: anInteger</body>
</methods>

<methods>
<class-id>Swazoo.SwazooSocket</class-id> <category>testing</category>

<body package="Swazoo-Compatibility">isActive
	^self accessor isActive</body>
</methods>

<methods>
<class-id>Swazoo.SwazooSocket</class-id> <category>accessing</category>

<body package="Swazoo-Compatibility">remoteAddress
	^self accessor getPeerName hostAddressString</body>

<body package="Swazoo-Compatibility">write: aByteArray 
	^self accessor write: aByteArray</body>

<body package="Swazoo-Compatibility">localAddress
	^self accessor getSocketName hostAddressString</body>

<body package="Swazoo-Compatibility">close
	self accessor close</body>

<body package="Swazoo-Compatibility">read: anInteger timeout: aNumberOfMilliseconds 
	^(self accessor waitForReadDataUpToMs: aNumberOfMilliseconds) 
		ifTrue: [self read: anInteger]
		ifFalse: [ByteArray new]</body>

<body package="Swazoo-Compatibility">read: anInteger 
	"^a ByteArray
I delegate this to my underlying socket.  I always return bytes, not characters.  Character encoding issues must be handles by the sender."

	| readByteArray |
	readByteArray := self accessor read: anInteger.
	^readByteArray</body>
</methods>

<methods>
<class-id>Swazoo.SwazooSocket</class-id> <category>private</category>

<body package="Swazoo-Compatibility">accessor
	^accessor</body>

<body package="Swazoo-Compatibility">stream
	^SwazooStream socket: self</body>

<body package="Swazoo-Compatibility">accessor: aSocketAccessor 
	accessor := aSocketAccessor.</body>
</methods>


<methods>
<class-id>Swazoo.SwazooCompiler class</class-id> <category>evaluation</category>

<body package="Swazoo-Compatibility">evaluate: aString receiver: anObject 
	^SpEnvironment 
		evaluate: aString
		receiver: anObject
		in: self class environment</body>

<body package="Swazoo-Compatibility">evaluate: aString 
	^SpEnvironment evaluate: aString in: self class environment</body>
</methods>


<methods>
<class-id>OS.Filename</class-id> <category>swazoo</category>

<body package="Swazoo-Compatibility">lastModified
	| info |
	info := self dates at: #modified.
	^SpTimestamp fromDate: info first andTime: info last</body>

<body package="Swazoo-Compatibility">etag
	"^a String
The etag of a file entity is taken to be the date last modified as a String.  We use the SpTimestamp in "

	| dateElements |
	dateElements := self dates at: #modified.
	^(SpTimestamp fromDate: (dateElements at: 1) andTime: (dateElements at: 2)) 
		asRFC1123String</body>
</methods>

<!-- Package Swazoo-Core(1.1.3,janko)= -->


<component-property>
<name>Swazoo-Core</name> <type>package</type>
<property>parcelName</property> <value>'Swazoo-Core'</value>
</component-property>

<component-property>
<name>Swazoo-Core</name> <type>package</type>
<property>packageName</property> <value>'Swazoo-Core'</value>
</component-property>

<component-property>
<name>Swazoo-Core</name> <type>package</type>
<property>comment</property> <value>'Core of Swazoo, a Smalltalk Web Application Server. 

Main class is SwazooServer! Another important class is Site

'</value>
</component-property>

<component-property>
<name>Swazoo-Core</name> <type>package</type>
<property>version</property> <value>'1.0'</value>
</component-property>

<class>
<name>SwazooServer</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>sites servers </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Core</category>
<attributes>
<package>Swazoo-Core</package>
</attributes>
</class>

<class>
<name>Resource</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>enabled uriPattern parent </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Core</category>
<attributes>
<package>Swazoo-Core</package>
</attributes>
</class>

<class>
<name>CompositeResource</name>
<environment>Swazoo</environment>
<super>Swazoo.Resource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>children </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Core</category>
<attributes>
<package>Swazoo-Core</package>
</attributes>
</class>

<class>
<name>Site</name>
<environment>Swazoo</environment>
<super>Swazoo.CompositeResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>name serving </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Core</category>
<attributes>
<package>Swazoo-Core</package>
</attributes>
</class>

<shared-variable>
<name>Singleton</name>
<environment>Swazoo.SwazooServer</environment>
<private>false</private>
<constant>false</constant>
<category>As yet unclassified</category>
<attributes>
<package>Swazoo-Core</package>
</attributes>
</shared-variable>






<methods>
<class-id>Swazoo.Resource class</class-id> <category>instance creation</category>

<body package="Swazoo-Core">uriPattern: aString 
	^self new uriPattern: aString</body>

<body package="Swazoo-Core">new
	^super new initialize</body>
</methods>


<methods>
<class-id>Swazoo.Resource</class-id> <category>testing</category>

<body package="Swazoo-Core">isEnabled
	^enabled</body>

<body package="Swazoo-Core">canAnswer
	^self isEnabled and: [self isValidlyConfigured]</body>

<body package="Swazoo-Core">isValidlyConfigured
	^self uriPattern ~= ''</body>
</methods>

<methods>
<class-id>Swazoo.Resource</class-id> <category>start/stop</category>

<body package="Swazoo-Core">start</body>

<body package="Swazoo-Core">stop</body>

<body package="Swazoo-Core">disable
	enabled := false</body>

<body package="Swazoo-Core">enable
	enabled := true</body>
</methods>

<methods>
<class-id>Swazoo.Resource</class-id> <category>authentication</category>

<body package="Swazoo-Core">unauthorizedResponse
	"Resource should call this method and return its result immediately, if request is not authorized 
	to access that resource and a HTTP authorization is needed"
	^Swazoo.HTTPAuthenticationChallenge newForResource: self</body>

<body package="Swazoo-Core">unauthorizedResponsePage
	"Resource should override this method with it's own html message"
	^'&lt;HTML&gt;
  &lt;HEAD&gt;
    &lt;TITLE&gt;Authentication error&lt;/TITLE&gt;
  &lt;/HEAD&gt;
  &lt;BODY&gt;
    &lt;H1&gt;401 Authentication error&lt;/H1&gt;
    &lt;P&gt;Bad username or password&lt;/P&gt;
  &lt;/BODY&gt;
&lt;/HTML&gt;'</body>

<body package="Swazoo-Core">authenticationRealm
	"rfc2617 3.2.1: A string to be displayed to users so they know which username and
     password to use. This string should contain at least the name of
     the host performing the authentication and might additionally
     indicate the collection of users who might have access. An example
     might be 'registered_users@gotham.news.com' "
	^'Swazoo server'</body>

<body package="Swazoo-Core">authenticationScheme
	"#Basic or #Digest, see rfc2617. Digest is recomended because password
	goes encrypted to server"
	^#Digest</body>
</methods>

<methods>
<class-id>Swazoo.Resource</class-id> <category>accessing</category>

<body package="Swazoo-Core">parent
	^parent</body>

<body package="Swazoo-Core">helpResolve: aResolution 
	^aResolution resolveLeafResource: self</body>

<body package="Swazoo-Core">root
	^self parent isNil
		ifTrue: [self]
		ifFalse: [self parent root]</body>

<body package="Swazoo-Core">uriPattern: anIdentifier 
	anIdentifier notNil ifTrue: [uriPattern := anIdentifier]</body>

<body package="Swazoo-Core">currentUrl
	| stream |
	stream := WriteStream on: String new.
	self printUrlOn: stream.
	^stream contents</body>

<body package="Swazoo-Core">printUrlOn: aWriteStream 
	self parent printUrlOn: aWriteStream.
	aWriteStream nextPutAll: self uriPattern</body>

<body package="Swazoo-Core">uriPattern
	^uriPattern</body>
</methods>

<methods>
<class-id>Swazoo.Resource</class-id> <category>private-initialize</category>

<body package="Swazoo-Core">initUriPattern
	self uriPattern: ''</body>

<body package="Swazoo-Core">initialize
	self enable.
	self initUriPattern</body>

<body package="Swazoo-Core">onResourceCreated
	"Received after the resource has been added to its parent resource. Opportunity to perform initialization that depends on knowledge of the resource tree structure"</body>
</methods>

<methods>
<class-id>Swazoo.Resource</class-id> <category>serving</category>

<body package="Swazoo-Core">answerTo: aRequest
	"override in your Resource and return a HTTPResponse"
	^nil</body>
</methods>

<methods>
<class-id>Swazoo.Resource</class-id> <category>private</category>

<body package="Swazoo-Core">parent: aResource
	parent := aResource</body>

<body package="Swazoo-Core">match: anIdentifier 
	^self uriPattern match: anIdentifier</body>
</methods>


<methods>
<class-id>Swazoo.CompositeResource</class-id> <category>testing</category>

<body package="Swazoo-Core">includesResource: aResource
	^self children includes: aResource.</body>

<body package="Swazoo-Core">isRootPath
	^self uriPattern = '/'</body>

<body package="Swazoo-Core">hasNoResources
	^self children isEmpty</body>
</methods>

<methods>
<class-id>Swazoo.CompositeResource</class-id> <category>accessing</category>

<body package="Swazoo-Core">helpResolve: aResolution 
	^aResolution resolveCompositeResource: self</body>

<body package="Swazoo-Core">children
	children isNil ifTrue: [self initChildren].
	^children</body>

<body package="Swazoo-Core">printUrlOn: aWriteStream 
	super printUrlOn: aWriteStream.
	self isRootPath ifFalse: [aWriteStream nextPut: $/]</body>

<body package="Swazoo-Core">currentUrl
	| string |
	string := super currentUrl.
	^string last = $/
		ifTrue: [string]
		ifFalse: [string , '/']</body>
</methods>

<methods>
<class-id>Swazoo.CompositeResource</class-id> <category>adding/removing</category>

<body package="Swazoo-Core">addResource: aResource
	self children add: aResource.
	aResource parent: self.
	aResource onResourceCreated.
	^aResource</body>

<body package="Swazoo-Core">addResources: anOrderedCollection
	anOrderedCollection do: [ :each |
		self addResource: each].
	^anOrderedCollection</body>

<body package="Swazoo-Core">removeResource: aResource
	self children remove: aResource ifAbsent: [nil]</body>
</methods>

<methods>
<class-id>Swazoo.CompositeResource</class-id> <category>initialize-release</category>

<body package="Swazoo-Core">initChildren
	children := OrderedCollection new.</body>

<body package="Swazoo-Core">initialize
	super initialize.
	self initChildren</body>
</methods>


<methods>
<class-id>Swazoo.Site</class-id> <category>testing</category>

<body package="Swazoo-Core">match: aSiteIdentifier 
	self uriPattern detect: [:each | each match: aSiteIdentifier]
		ifNone: [^false].
	^true</body>

<body package="Swazoo-Core">isRootPath
	^false</body>

<body package="Swazoo-Core">isServing
	"is this site on-line?"
	^serving notNil and: [serving]</body>
</methods>

<methods>
<class-id>Swazoo.Site</class-id> <category>start/stop</category>

<body package="Swazoo-Core">stop
	| registry |
	registry := SwazooServer singleton.
	self aliases do: [:each | | server |
		server := registry serverFor: each.
		(registry servers includes: server) 
			ifTrue: 
				[server removeSite: self.
				server hasNoSites ifTrue: 
					[registry removeServer: server.
					server stop]]].
		self serving: false.</body>

<body package="Swazoo-Core">start
	| registry |
	registry := SwazooServer singleton.
	[self aliases do: [:each | | server |
		server := registry serverFor: each.
		server addSite: self.
		(registry servers includes: server) 
			ifFalse: 
				[registry addServer: server.
				server isServing ifFalse: [server start] ] ].
	] ifCurtailed: [self stop].
	self serving: true.</body>
</methods>

<methods>
<class-id>Swazoo.Site</class-id> <category>configuration</category>

<body package="Swazoo-Core">readCompositeFrom: aStream storingInto: aComposite 
	| tag |
	
	[tag := self nextTagFrom: aStream.
	tag = '/CompositeResource']
		whileFalse: 
			[| thingy |
			thingy := self compile: tag.
			aComposite addResource: thingy.
			(thingy isKindOf: CompositeResource)
				ifTrue: [self readCompositeFrom: aStream storingInto: thingy]]</body>

<body package="Swazoo-Core">compile: tag 
	^SwazooCompiler evaluate: tag</body>

<body package="Swazoo-Core">nextTagFrom: aStream 
	aStream upTo: $&lt;.
	^aStream atEnd ifTrue: [nil] ifFalse: [aStream upTo: $&gt;]</body>

<body package="Swazoo-Core">readFrom: aStream 
	| tag |
	tag := self nextTagFrom: aStream.
	tag isNil ifTrue: [^nil].
	tag = 'Site' ifFalse: [^SwazooSiteError error: 'invalid site specification!'].
	[tag := self nextTagFrom: aStream.
	tag = '/Site'] 	whileFalse: 
			[| thingy |
			thingy := self compile: tag.
			(thingy isKindOf: SiteIdentifier)
				ifTrue: [self addAlias: thingy]
				ifFalse: 
					[self addResource: thingy.
					(thingy isKindOf: CompositeResource) 
						ifTrue: [self readCompositeFrom: aStream storingInto: thingy]]]</body>
</methods>

<methods>
<class-id>Swazoo.Site</class-id> <category>accessing</category>

<body package="Swazoo-Core">name
	"a short name of that site. Example: for host www.ibm.com, name it ibm"
	name isNil ifTrue: [^''].
	^name</body>

<body package="Swazoo-Core">ip
	"IP address of this site. Swazoo can have virtual sites, that is, more than one 
	site can share the same ip and port!
	IP can be a number or full DNS name. For example: server.ibm.com or 234.12.45.66"
	^self uriPattern first ip</body>

<body package="Swazoo-Core">uriPattern
	uriPattern isNil ifTrue: [self initUriPattern].
	^uriPattern</body>

<body package="Swazoo-Core">aliases
	^self uriPattern</body>

<body package="Swazoo-Core">address
	^self host</body>

<body package="Swazoo-Core">addAlias: anAlias 
	self uriPattern add: anAlias</body>

<body package="Swazoo-Core">helpResolve: aResolution 
	^aResolution resolveSite: self</body>

<body package="Swazoo-Core">host
	"hostname of this site. Example: www.ibm.com. 
	hostname must be unique on that server.
	Don't mix with ip, which also can be something like www.ibm.com. 
	There can be many sites with different hostnames on the same ip ! "
	self uriPattern isEmpty ifTrue: [^''].
	^self uriPattern first host</body>

<body package="Swazoo-Core">host: aHostString ip: anIPString port: aNumber 
	"see comments in methods host and ip ! "
	"hostname must be unique! "
	(SwazooServer singleton siteHostnamed: aHostString) notNil 
		ifTrue: [^SwazooSiteError error: 'Site with that hostname already exist!'].
	self uriPattern isEmpty ifTrue: [self uriPattern add: SiteIdentifier new].
	self uriPattern first 
		setIp: anIPString
		port: aNumber
		host: aHostString</body>

<body package="Swazoo-Core">name: aString
	"a short name of that site. Example: for host www.ibm.com, name it ibm"
	"name must be unique"
	(SwazooServer singleton siteNamed: aString) notNil 
		ifTrue: [^SwazooSiteError error: 'Site with that name already exist!'].
	name := aString</body>

<body package="Swazoo-Core">printUrlOn: aWriteStream 
	self uriPattern first printUrlOn: aWriteStream</body>

<body package="Swazoo-Core">port
	^self uriPattern first port</body>
</methods>

<methods>
<class-id>Swazoo.Site</class-id> <category>private-initialize</category>

<body package="Swazoo-Core">initUriPattern
	self uriPattern: OrderedCollection new</body>

<body package="Swazoo-Core">initialize
	super initialize.
	self stop. "in case you initialize working site"
	self initUriPattern</body>
</methods>

<methods>
<class-id>Swazoo.Site</class-id> <category>private</category>

<body package="Swazoo-Core">port: aNumber
	self uriPattern first port: aNumber</body>

<body package="Swazoo-Core">host: aString
	self uriPattern first host: aString</body>

<body package="Swazoo-Core">serving: aBoolean
	serving := aBoolean</body>

<body package="Swazoo-Core">ip: aString
	self uriPattern first  ip: aString</body>
</methods>


<methods>
<class-id>Swazoo.SwazooServer class</class-id> <category>configuration</category>

<body package="Swazoo-Core">configureFrom: aFilenameString 
	| sites stream |
	self singleton removeAllSites.
	stream := aFilenameString asFilename readStream.
	[sites := self readSitesFrom: stream] ensure: [stream close].
	sites do: [:each | 
		self singleton addSite: each.
		each start]</body>
</methods>

<methods>
<class-id>Swazoo.SwazooServer class</class-id> <category>accessing</category>

<body package="Swazoo-Core">siteNamed: aString
	^self singleton siteNamed: aString</body>

<body package="Swazoo-Core">siteHostnamed: aString
	^self singleton siteHostnamed: aString</body>

<body package="Swazoo-Core">singleton
	Singleton isNil ifTrue: [self initSingleton].
	^Singleton</body>
</methods>

<methods>
<class-id>Swazoo.SwazooServer class</class-id> <category>start/stop</category>

<body package="Swazoo-Core">start
	"start all sites"
	self singleton start</body>

<body package="Swazoo-Core">stopSite: aString
	"stop site with that name"
	self singleton stopSite: aString</body>

<body package="Swazoo-Core">stop
	"stop all sites"
	self singleton stop</body>

<body package="Swazoo-Core">startSite: aString
	"start site with that name"
	self singleton startSite: aString</body>
</methods>

<methods>
<class-id>Swazoo.SwazooServer class</class-id> <category>private</category>

<body package="Swazoo-Core">new
	^self shouldNotImplement</body>

<body package="Swazoo-Core">readSitesFrom: aStream 
	| sites instance |
	sites := OrderedCollection new.
	[instance := Site new readFrom: aStream.
	instance notNil] whileTrue: [sites add: instance].
	^sites</body>

<body package="Swazoo-Core">initSingleton
	Singleton := super new.</body>
</methods>


<methods>
<class-id>Swazoo.SwazooServer</class-id> <category>private-servers</category>

<body package="Swazoo-Core">newServerFor: aSiteIdentifier
	^ aSiteIdentifier newServer.</body>

<body package="Swazoo-Core">addServer: aHTTPServer
	self servers add: aHTTPServer</body>

<body package="Swazoo-Core">removeServer: aHTTPServer
	self servers remove: aHTTPServer</body>

<body package="Swazoo-Core">serverFor: aSiteIdentifier 
	^self servers detect: [:each | (each ip = aSiteIdentifier ip) &amp; (each port = aSiteIdentifier port)]
		ifNone: [self newServerFor: aSiteIdentifier]</body>
</methods>

<methods>
<class-id>Swazoo.SwazooServer</class-id> <category>private</category>

<body package="Swazoo-Core">servers
	servers isNil ifTrue: [self initServers].
	^servers</body>

<body package="Swazoo-Core">sites
	sites isNil ifTrue: [self initSites].
	^sites</body>
</methods>

<methods>
<class-id>Swazoo.SwazooServer</class-id> <category>initialize-release</category>

<body package="Swazoo-Core">initServers
	servers := Set new.</body>

<body package="Swazoo-Core">initSites
	sites := OrderedCollection new.</body>

<body package="Swazoo-Core">initialize
	self initSites.
	self initServers.</body>
</methods>

<methods>
<class-id>Swazoo.SwazooServer</class-id> <category>start/stop</category>

<body package="Swazoo-Core">stopSite: aString
	"stop site with that name"
	| site |
	site := self siteNamed: aString.
	site notNil ifTrue: [site stop].</body>

<body package="Swazoo-Core">startSite: aString
	"start site with that name"
	| site |
	site := self siteNamed: aString.
	site notNil ifTrue: [site start].</body>
</methods>

<methods>
<class-id>Swazoo.SwazooServer</class-id> <category>sites</category>

<body package="Swazoo-Core">siteHostnamed: aString
	"find a site with that hostname"
	| string |
	string := aString isNil ifTrue: [''] ifFalse: [aString asLowercase].
	^self sites detect: [:each | each host asLowercase = string] ifNone: [nil].</body>

<body package="Swazoo-Core">addSite: aSite
	(self siteNamed: aSite name) notNil 
		ifTrue: [^SwazooSiteError error: 'Site with that name already exist!'].
	(self siteHostnamed: aSite host) notNil 
		ifTrue: [^SwazooSiteError error: 'Site with that hostname already exist!'].
	self sites add: aSite</body>

<body package="Swazoo-Core">removeSite: aSite 
	aSite stop.
	self sites remove: aSite</body>

<body package="Swazoo-Core">removeAllSites
	self sites copy do: [:each | self removeSite: each]</body>

<body package="Swazoo-Core">siteNamed: aString
	"find a site with that short name"
	| string |
	string := aString isNil ifTrue: [''] ifFalse: [aString asLowercase].
	^self sites detect: [:each | each name asLowercase = string] ifNone: [nil].</body>

<body package="Swazoo-Core">allSites
	^self sites copy</body>
</methods>

<!-- Package Swazoo-HTTP(1.1.4,janko)* -->


<component-property>
<name>Swazoo-HTTP</name> <type>package</type>
<property>comment</property> <value>'HTTP Server, connections, request parsing and resolution, response composition'</value>
</component-property>

<class>
<name>HTTPServer</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>ip port connections sites socket loop isMultiThreading </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-HTTP</package>
</attributes>
</class>

<class>
<name>URIIdentifier</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-HTTP</package>
</attributes>
</class>

<class>
<name>SiteIdentifier</name>
<environment>Swazoo</environment>
<super>Swazoo.URIIdentifier</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>ip port host </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-HTTP</package>
</attributes>
</class>

<class>
<name>HTTPConnection</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>stream loop server lastResponse </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-HTTP</package>
</attributes>
</class>

<class>
<name>URIResolution</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>position request </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-HTTP</package>
</attributes>
</class>

<class>
<name>ServerRootComposite</name>
<environment>Swazoo</environment>
<super>Swazoo.CompositeResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-HTTP</package>
</attributes>
</class>

<class>
<name>SwazooURI</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>protocol hostname port identifier queries </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-HTTP</package>
</attributes>
</class>








<methods>
<class-id>Swazoo.HTTPServer class</class-id> <category>instance creation</category>

<body package="Swazoo-HTTP">new
	^super new initialize</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServer class</class-id> <category>accessing</category>

<body package="Swazoo-HTTP">version
	^'Swazoo 2.0 Smalltalk Web Server'</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServer class</class-id> <category>intialize-release</category>

<body package="Swazoo-HTTP">initialize
	SpEnvironment addImageShutdownTask: [self shutDown] for: self</body>

<body package="Swazoo-HTTP">shutDown 
	"HTTPServer shutDown"
	self allInstances do: [:each | each stop].
	SpEnvironment removeShutdownActionFor: self.</body>
</methods>


<methods>
<class-id>Swazoo.HTTPServer</class-id> <category>testing</category>

<body package="Swazoo-HTTP">isServing
	^self loop notNil</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServer</class-id> <category>start/stop</category>

<body package="Swazoo-HTTP">stop
	self loop isNil 
		ifFalse: 
			[self connections copy do: [:each | each close].
			self loop terminate.
			self loop: nil.
			self socket close.
			self socket: nil]</body>

<body package="Swazoo-HTTP">start
	self loop isNil 
		ifTrue: 
			[self socket: (self socketClass serverOnIP: self ip port: self port).
			self socket listenFor: 50.
			self loop: ([[self acceptConnection] repeat] 
						forkAt: Processor userBackgroundPriority)]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServer</class-id> <category>multithreading</category>

<body package="Swazoo-HTTP">isMultiThreading
	"^a Boolean
I return true if each inbound HTTP connection will be handled in its own thread.  See the senders of this message to see where that is important.  Note that the default mode is mult-threaded because this is how Swazoo has worked so far.  This is tricky for the application programmer, though, as they must ensure that they work in a thread safe way (e.g. avoid the many threads updating the same object).  For those deploying to GemStone, you wil find things much easier if you do *not* run multithreaded, but rather run many gems each with a single-threaded Swazoo instance (and your app logic) in each.  Also in GemStone, run the main loop in the foreground, c.f. &gt;&gt;mainLoopInForeground"

	isMultiThreading isNil ifTrue: [self setMultiThreading].
	^isMultiThreading</body>

<body package="Swazoo-HTTP">setSingleThreading
	"^self
I record that this HTTP server is to operate in a single-threaded mode.  c.f. isMultiThreading"

	isMultiThreading := false.
	^self</body>

<body package="Swazoo-HTTP">setMultiThreading
	"^self
I record that this HTTP server is to operate in a multi-threaded mode.  c.f. isMultiThreading"

	isMultiThreading := true.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServer</class-id> <category>sites</category>

<body package="Swazoo-HTTP">addSite: aSite
	(self sites includesResource: aSite) ifFalse: [^self sites addResource: aSite]</body>

<body package="Swazoo-HTTP">removeSite: aSite 
	^self sites removeResource: aSite</body>

<body package="Swazoo-HTTP">hasNoSites
	^self sites hasNoResources</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServer</class-id> <category>private-initialize</category>

<body package="Swazoo-HTTP">port: aNumber
	port := aNumber</body>

<body package="Swazoo-HTTP">initialize
	self initConnections.
	self initSites</body>

<body package="Swazoo-HTTP">port
	^port</body>

<body package="Swazoo-HTTP">initSites
	sites := ServerRootComposite new</body>

<body package="Swazoo-HTTP">ip: anIPString 
	ip := anIPString</body>

<body package="Swazoo-HTTP">ip
	^ip</body>

<body package="Swazoo-HTTP">initConnections
	connections := OrderedCollection new.</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServer</class-id> <category>serving</category>

<body package="Swazoo-HTTP">answerTo: aRequest 
	| response |
	response := URIResolution resolveRequest: aRequest startingAt: self sites.
	^response isNil
		ifTrue: [HTTPResponse notFound]
		ifFalse: [response]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServer</class-id> <category>private</category>

<body package="Swazoo-HTTP">acceptConnection
	"^self
I accept the next inbound TCP/IP connection.  The operating system libraries queue these up for me, so I can just handle one at a time.  I create an HTTPConnection instance to actually handle the interaction with the client - if I am in single threaded mode, the connection will completely handle the request before returning control to me, but in multi-threaded mode the connection forks the work into a sepparate thread in this image and control is immediately returned to me (the application programmer must worry about thread safety in this case."

	| clientConnection |
	clientConnection := SpExceptionContext 
				for: [HTTPConnection socket: self socket accept]
				on: SpError
				do: [:ex | Transcript show: 'Socket accept error: ' , ex errorString; cr. ^self].
	self addConnection: clientConnection.
	clientConnection interact.
	^self</body>

<body package="Swazoo-HTTP">loop
	^loop</body>

<body package="Swazoo-HTTP">addConnection: aConnection 
	self connections add: aConnection.
	aConnection server: self</body>

<body package="Swazoo-HTTP">sites
	sites isNil ifTrue: [self initSites].
	^sites</body>

<body package="Swazoo-HTTP">socket: aSocket
	socket := aSocket</body>

<body package="Swazoo-HTTP">socketClass
	"^a Class
I use SwazooSocket to wrap the actual socket.  SwazooSocket does some of the byte translation work for me."

	^SwazooSocket</body>

<body package="Swazoo-HTTP">removeConnection: aConnection 
	self connections remove: aConnection ifAbsent: [nil]</body>

<body package="Swazoo-HTTP">loop: aProcess
	loop := aProcess</body>

<body package="Swazoo-HTTP">socket
	^socket</body>

<body package="Swazoo-HTTP">connections
	connections isNil ifTrue: [self initConnections].
	^connections</body>
</methods>


<methods>
<class-id>Swazoo.URIIdentifier</class-id> <category>testing</category>

<body package="Swazoo-HTTP">match: anotherIdentifier 
	^(self typeMatch: anotherIdentifier) 
		and: [self valueMatch: anotherIdentifier]</body>
</methods>

<methods>
<class-id>Swazoo.URIIdentifier</class-id> <category>comparing</category>

<body package="Swazoo-HTTP">= anIdentifier 
	^self match: anIdentifier</body>

<body package="Swazoo-HTTP">hash
	^1</body>
</methods>

<methods>
<class-id>Swazoo.URIIdentifier</class-id> <category>private</category>

<body package="Swazoo-HTTP">typeMatch: anotherIdentifier 
	^self class == anotherIdentifier class</body>

<body package="Swazoo-HTTP">valueMatch: anotherIdentifier 
	^self subclassResponsibility</body>
</methods>


<methods>
<class-id>Swazoo.SiteIdentifier class</class-id> <category>instance creation</category>

<body package="Swazoo-HTTP">ip: anIP port: aPort host: hostName 
	^self new 
		setIp: anIP
		port: aPort
		host: hostName</body>
</methods>


<methods>
<class-id>Swazoo.SiteIdentifier</class-id> <category>initialize-release</category>

<body package="Swazoo-HTTP">newServer
	^ HTTPServer new ip: self ip;  port: self port</body>

<body package="Swazoo-HTTP">setIp: anIP port: aPort host: hostName 
	self ip: anIP.
	self port: aPort.
	self host: hostName</body>
</methods>

<methods>
<class-id>Swazoo.SiteIdentifier</class-id> <category>accessing</category>

<body package="Swazoo-HTTP">port
	^port</body>

<body package="Swazoo-HTTP">ip
	^ip</body>

<body package="Swazoo-HTTP">host
	^host</body>

<body package="Swazoo-HTTP">currentUrl
	| stream |
	stream := WriteStream on: String new.
	self printUrlOn: stream.
	^stream contents</body>
</methods>

<methods>
<class-id>Swazoo.SiteIdentifier</class-id> <category>private</category>

<body package="Swazoo-HTTP">ip: aString
	ip := aString</body>

<body package="Swazoo-HTTP">port: aNumber
	port := aNumber</body>

<body package="Swazoo-HTTP">printString
	^'a Swazoo.SiteIndentifier
	host: ', self host, '
	ip: ', self ip, '
	port: ', self port printString</body>

<body package="Swazoo-HTTP">printHostPortStringOn: stream 
	stream nextPutAll: self host.
	self port = 80 ifFalse: [stream nextPut: $:; nextPutAll: self port printString]</body>

<body package="Swazoo-HTTP">printUrlOn: aWriteStream 
	aWriteStream nextPutAll: 'http://'.
	self printHostPortStringOn: aWriteStream</body>

<body package="Swazoo-HTTP">valueMatch: aSiteIdentifier
	"ip can be in numbers or named!"
	"VW specific!"
	^(IPSocketAddress hostName: self ip port: self port) =
		(IPSocketAddress hostName: aSiteIdentifier ip port: aSiteIdentifier port)
			and: [self host match: aSiteIdentifier host]</body>

<body package="Swazoo-HTTP">host: aString
	host := aString</body>
</methods>


<methods>
<class-id>Swazoo.HTTPConnection class</class-id> <category>instance creation</category>

<body package="Swazoo-HTTP">socket: aSocket 
	^self new stream: aSocket stream</body>
</methods>


<methods>
<class-id>Swazoo.HTTPConnection</class-id> <category>private-handling</category>

<body package="Swazoo-HTTP">nextPutResponse: aMessage toRequest: aRequest 
	| shouldClose |
	shouldClose := aRequest wantsConnectionClose.
	shouldClose ifTrue: [aMessage informConnectionClose].
	aRequest isHead 
		ifTrue: [aMessage writeHeaderTo: self stream]
		ifFalse: [aMessage writeTo: self stream].
	self stream flush.
	shouldClose ifTrue: [self close].
	aMessage isRedirectLink ifTrue: [self close]. "otherwise browser does not redirect?! "</body>

<body package="Swazoo-HTTP">getAndDispatchMessages
	"^self
	The HTTPRequest is read from my socket stream.  I then pass this request to my server to get a response.  If somethng goes wrong while getting hold of the request, we call that a 400 - a bad request.  If anything happens after that, it's an internal server error.  (hmm - should we close the image if we get an internal server error?  If we don't, what state is the image in, then ... ??)"

	| task |
	task := SwazooTask new.
	self readRequestFor: task.
	self produceResponseFor: task.
	"self close"</body>

<body package="Swazoo-HTTP">nextPutError: aResponse 
	aResponse informConnectionClose.
	aResponse writeTo: self stream.
	self stream flush.</body>

<body package="Swazoo-HTTP">produceResponseFor: aTask 
	"Given the request in aTask I try to make a response.  If there are any unhandled 
	exceptions, respond with an internal server error."
	aTask request isNil ifTrue: [^nil].
	SpExceptionContext for: 
		[aTask response: (self server answerTo: aTask request).
		self nextPutResponse: aTask response toRequest: aTask request]
	onAnyExceptionDo: 
		[:ex | 
		self nextPutError: HTTPResponse internalServerError.
		ex defaultAction. "usually raise an UHE window"
		self close]</body>

<body package="Swazoo-HTTP">readRequestFor: aSwazooTask 
	"I read the next request from my socket and add it to aSwazooTask.  If I have any 
	problems and need to force a bad request (400) response, I add this response to aSwazooTask."
	| request |
	SpExceptionContext for: 
		[request := HTTPRequest readFrom: self stream.
		(request httpVersion last = 1 
			and: [(request headers includesFieldOfClass: HTTPHostField) not]) 
				ifTrue: [aSwazooTask response: HTTPResponse badRequest].
		request
			peer: self stream socket remoteAddress;
			ip: self stream socket localAddress;
			setTimestamp; parent: self.
		aSwazooTask request: request]
	on: SpError
	do: [:ex | 
		aSwazooTask response: HTTPResponse badRequest.
		self nextPutError: aSwazooTask response].</body>
</methods>

<methods>
<class-id>Swazoo.HTTPConnection</class-id> <category>serving</category>

<body package="Swazoo-HTTP">interact
	"longer description is below method"
	| interactionBlock |
	interactionBlock := 
		[SpExceptionContext 
			for: [[true] whileTrue: 
				[self getAndDispatchMessages.
				Processor yield] ]
		on: SpError
		do: [:ex | self close]].
	self server isMultiThreading 
		ifTrue: [self loop: (interactionBlock forkAt: Processor userBackgroundPriority)]
		ifFalse: [interactionBlock value].
	^self

"I represent a specifc connection with an HTTP client (a browser, probably) over which will come an HTTP request.  Here, I fork the handling of the request so that the current thread (which is most likely the HTTP server main loop) can carry on with the next request.  This means that more than one request may being handled in the image at a time, and that means that the application developer must worry about thread safety - e.g the problem of a given business object being updated by more than one HTTP request thread.
For a GemStone implementation of Swazoo, one may want only one request is handled at a time, multi-threadedness being handled by having multiple gems.  This is a nice option because the application developer does not have to worry about thread safety in this case - GemStone handles the hard stuff.
*And* the thing called a loop that was in this method was no such thing.  In all circumstances, &gt;&gt;getAndDispatchMessages handles exactly one requst and then closes the socket! (very non-HTTP1.1).  Anyway, for now I'm just going to make that explicit.  This needs to be re-visited to support HTTP 1.1."</body>

<body package="Swazoo-HTTP">close
	self stream close.
	self server removeConnection: self.
	self loop notNil ifTrue: [self loop terminate]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPConnection</class-id> <category>private-accessing</category>

<body package="Swazoo-HTTP">socket
	^self stream socket</body>

<body package="Swazoo-HTTP">loop
	^loop</body>

<body package="Swazoo-HTTP">server
	^server</body>

<body package="Swazoo-HTTP">lastResponse: aHTTPResponse
	lastResponse := aHTTPResponse</body>

<body package="Swazoo-HTTP">stream: aSwazooStream 
	stream := aSwazooStream</body>

<body package="Swazoo-HTTP">lastResponse
	"to pair with new request, for http digest authentication etc."
	^lastResponse</body>

<body package="Swazoo-HTTP">server: aServer 
	server := aServer</body>

<body package="Swazoo-HTTP">stream
	^stream</body>

<body package="Swazoo-HTTP">loop: aProcess
	loop := aProcess</body>
</methods>


<methods>
<class-id>Swazoo.ServerRootComposite</class-id> <category>accessing</category>

<body package="Swazoo-HTTP">helpResolve: aResolution 
	^aResolution resolveServerRoot: self</body>
</methods>


<methods>
<class-id>Swazoo.URIResolution class</class-id> <category>instance creation</category>

<body package="Swazoo-HTTP">resolveRequest: aRequest startingAt: aResource 
	^(self new initializeRequest: aRequest) visitResource: aResource</body>
</methods>


<methods>
<class-id>Swazoo.URIResolution</class-id> <category>resolving</category>

<body package="Swazoo-HTTP">resolveSite: aSite 
	(aSite canAnswer and: [self siteMatch: aSite]) ifFalse: [^nil].
	^self visitChildrenOf: aSite advancing: false</body>

<body package="Swazoo-HTTP">visitResource: aResource 
	^aResource helpResolve: self</body>

<body package="Swazoo-HTTP">resolveServerRoot: aServerRoot 
	^self resolveTransparentComposite: aServerRoot</body>

<body package="Swazoo-HTTP">resolveLeafResource: aResource 
	(aResource canAnswer and: [self stringMatch: aResource]) ifFalse: [^nil].
	^self getAnswerFrom: aResource</body>

<body package="Swazoo-HTTP">resolveCompositeResource: aResource 
	(aResource canAnswer and: [aResource match: self currentIdentifier]) 
		ifFalse: [^nil].
	^self visitChildrenOf: aResource advancing: true</body>

<body package="Swazoo-HTTP">visitChildrenOf: aResource advancing: aBoolean 
	| response |
	self atEnd &amp; aBoolean ifTrue: [^self getAnswerFrom: aResource].
	aBoolean ifTrue: [self advance].
	aResource children do: 
			[:each | 
			response := self visitResource: each.
			response isNil ifFalse: [^response]].
	^aBoolean ifTrue: [self retreat] ifFalse: [nil]</body>

<body package="Swazoo-HTTP">resolveTransparentComposite: aCompositeResource 
	^self visitChildrenOf: aCompositeResource advancing: false</body>
</methods>

<methods>
<class-id>Swazoo.URIResolution</class-id> <category>accessing</category>

<body package="Swazoo-HTTP">atEnd
	^self position = self request uri identifierPath size</body>

<body package="Swazoo-HTTP">fullPath
	^self request uri identifierPath</body>

<body package="Swazoo-HTTP">request
	^request</body>

<body package="Swazoo-HTTP">position
	^position</body>

<body package="Swazoo-HTTP">tailPath
	| fullPath |
	fullPath := self fullPath.
	^fullPath copyFrom: self position + 1 to: fullPath size</body>

<body package="Swazoo-HTTP">resourcePath
	^self request uri identifierPath copyFrom: 1 to: self position</body>
</methods>

<methods>
<class-id>Swazoo.URIResolution</class-id> <category>private-initialize</category>

<body package="Swazoo-HTTP">initializeRequest: aRequest 
	self request: aRequest.
	self request resolution: self.
	self position: 1</body>
</methods>

<methods>
<class-id>Swazoo.URIResolution</class-id> <category>private</category>

<body package="Swazoo-HTTP">retreat
	self position: self position - 1.
	^nil</body>

<body package="Swazoo-HTTP">siteMatch: aSite 
	| siteIdentifier hostName |
	hostName := self request headers 
				fieldOfClass: HTTPHostField
				ifPresent: [:field | field hostName]
				ifAbsent: [self request requestLine requestURI hostname].
	siteIdentifier := SiteIdentifier 
				ip: self request ip
				port: self request port
				host: hostName.
	^aSite match: siteIdentifier</body>

<body package="Swazoo-HTTP">tailStream
	^ReadStream on: self tailPath</body>

<body package="Swazoo-HTTP">currentPath
	^self request uri identifierPath copyFrom: 1 to: self position</body>

<body package="Swazoo-HTTP">position: anInteger
	position := anInteger</body>

<body package="Swazoo-HTTP">advance
	self position: self position + 1</body>

<body package="Swazoo-HTTP">request: aRequest
	request := aRequest</body>

<body package="Swazoo-HTTP">stringMatch: aResource 
	^aResource uriPattern = self currentIdentifier</body>

<body package="Swazoo-HTTP">currentIdentifier
	^self currentPath last</body>

<body package="Swazoo-HTTP">getAnswerFrom: aResource
	^aResource answerTo: self request</body>
</methods>


<methods>
<class-id>Swazoo.SwazooURI class</class-id> <category>instance creation</category>

<body package="Swazoo-HTTP">fromString: aString
	^self new fromString: aString</body>

<body package="Swazoo-HTTP">value: aString
	^self new value: aString</body>
</methods>


<methods>
<class-id>Swazoo.SwazooURI</class-id> <category>testing</category>

<body package="Swazoo-HTTP">isDirectory
	^self identifier last = $/</body>
</methods>

<methods>
<class-id>Swazoo.SwazooURI</class-id> <category>printing</category>

<body package="Swazoo-HTTP">printOn: targetStream 
	(self hostname notNil and: [self protocol notNil]) 
		ifTrue: 
			[targetStream
				nextPutAll: self protocol;
				nextPutAll: '://'].
	self hostname isNil ifFalse: [targetStream nextPutAll: self hostname].
	(self port notNil and: [self port ~= 80]) 
		ifTrue: 
			[targetStream
				nextPut: $:;
				nextPutAll: self port printString].
	targetStream nextPutAll: self identifier.
	self printQueriesOn: targetStream.
	^self</body>

<body package="Swazoo-HTTP">asString
	| targetStream |
	targetStream := WriteStream on: String new.
	self printOn: targetStream.
	^targetStream contents</body>

<body package="Swazoo-HTTP">printQueriesOn: targetStream 
	| firstQuery |
	self queries isEmpty 
		ifFalse: 
			[firstQuery := self queries at: 1.
			targetStream
				nextPut: $?;
				nextPutAll: firstQuery key;
				nextPut: $=;
				nextPutAll: firstQuery value.
			2 to: self queries size
				do: 
					[:queryIndex | 
					| aQuery |
					aQuery := self queries at: queryIndex.
					targetStream
						nextPut: $&amp;;
						nextPutAll: aQuery key;
						nextPut: $=;
						nextPutAll: aQuery value]].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.SwazooURI</class-id> <category>initialize-release</category>

<body package="Swazoo-HTTP">fromString: aString 
	| sourceStream |
	sourceStream := ReadStream on: aString.
	self fromStream: sourceStream.
	^self</body>

<body package="Swazoo-HTTP">fromStream: sourceStream 
	self readProtocolFrom: sourceStream.
	self readHostFrom: sourceStream.
	self readPortFrom: sourceStream.
	self readIdentifierFrom: sourceStream.
	self readQueryFrom: sourceStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.SwazooURI</class-id> <category>accessing-queries</category>

<body package="Swazoo-HTTP">queries: anOrderedCollection 
	"^self
The queries must be an OrderedCollection of Associations c.f. &gt;&gt;queries"

	queries := anOrderedCollection.
	^self</body>

<body package="Swazoo-HTTP">queryAt: aString ifAbsent: aBlock 
	"^aString
I return the value of the first query I find with the key aString.  If there are none I execute aBlock."

	| result |
	result := self queries detect: [:aQuery | aQuery key = aString]
				ifNone: [aBlock].
	^result isNil ifTrue: [aBlock value] ifFalse: [result value]</body>

<body package="Swazoo-HTTP">includesQuery: aString 
	| result |
	result := self queries detect: [:aQuery | aQuery key = aString]
				ifNone: [nil].
	^result notNil</body>

<body package="Swazoo-HTTP">queries
	"^an OrderedCollection
This is an ordered colleciton of associations.  It can't be a dictionary, because it is legal to have many entries with the same key value."

	queries isNil ifTrue: [queries := OrderedCollection new].
	^queries</body>

<body package="Swazoo-HTTP">queryAt: aString 
	^self queryAt: aString ifAbsent: [nil]</body>

<body package="Swazoo-HTTP">queriesNamed: aString 
	^self queries select: [:aQuery | aQuery key = aString]</body>
</methods>

<methods>
<class-id>Swazoo.SwazooURI</class-id> <category>accessing</category>

<body package="Swazoo-HTTP">host: aString 
	| rs |
	rs := ReadStream on: aString.
	self hostname: (rs upTo: $: ).
	rs atEnd ifFalse: [self port: rs upToEnd asNumber]</body>

<body package="Swazoo-HTTP">host
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: self hostname.
	self port = self defaultPort 
		ifFalse: 
			[ws nextPut: $:.
			self port printOn: ws].
	^ws contents</body>

<body package="Swazoo-HTTP">hostname: aHostname 
	hostname := aHostname</body>

<body package="Swazoo-HTTP">port
	"^an Integer
The port number defaults to 80 for HTTP."

	^port isNil ifTrue: [80] ifFalse: [port]</body>

<body package="Swazoo-HTTP">identifier
	^identifier</body>

<body package="Swazoo-HTTP">identifierPath
	| parts |
	parts := (HTTPString subCollectionsFrom: self identifier delimitedBy: $/) 
				collect: [:each | HTTPString decodedHTTPFrom: each].
	self identifier first = $/ ifTrue: [parts addFirst: '/'].
	^parts reject: [:each | each isEmpty]</body>

<body package="Swazoo-HTTP">identifierPathString
	"^aString
I return the 'directory' part of the path name."

	| sourceStream targetStream |
	targetStream := WriteStream on: String new.
	sourceStream := ReadStream on: self identifier.
	[sourceStream atEnd] whileFalse: 
			[| fragment |
			fragment := sourceStream throughAll: '/'.
			fragment last = $/ ifTrue: [targetStream nextPutAll: fragment]].
	^targetStream contents</body>

<body package="Swazoo-HTTP">protocol: aString
	protocol := aString.</body>

<body package="Swazoo-HTTP">port: anInteger 
	port := anInteger</body>

<body package="Swazoo-HTTP">identifier: anObject
	identifier := anObject</body>

<body package="Swazoo-HTTP">hostname
	^hostname</body>

<body package="Swazoo-HTTP">value
	"1 halt: 'Use &gt;&gt;asString or &gt;&gt;printOn: instead'. "
	^self asString</body>

<body package="Swazoo-HTTP">protocol
	protocol isNil ifTrue: [self protocol: 'http'].
	^protocol</body>
</methods>

<methods>
<class-id>Swazoo.SwazooURI</class-id> <category>private</category>

<body package="Swazoo-HTTP">readPortFrom: aStream 
	"^self
I read the port nnumber from the URI presumed to be in aStream.  If a port number has been specified, the stream should be positioned right at before a $: charcter.  So, if the next chacter is a :, we have a port number.  I read up to one of $/, $? or the end of the stream depending on wether there is a path, query or nothing following the host.  The stream is left positioned at the terminating character."

	| targetStream |
	targetStream := WriteStream on: String new.
	aStream peek == $: 
		ifTrue: 
			[| terminators |
			terminators := Array 
						with: $/
						with: $?
						with: nil.
			aStream next.
			
			[| nextCharacter |
			nextCharacter := aStream peek.
			terminators includes: nextCharacter] 
					whileFalse: 
						[| nextDigit |
						nextDigit := aStream next.
						nextDigit isDigit ifTrue: [targetStream nextPut: nextDigit]].
			targetStream contents isEmpty 
				ifFalse: [port := targetStream contents asNumber]].
	^self</body>

<body package="Swazoo-HTTP">readIdentifierFrom: sourceStream 

	self identifier: (sourceStream upTo: $?).
	^self</body>

<body package="Swazoo-HTTP">readHostFrom: aStream 
	"^self
I read the host name from the URI presumed to be in aStream.  The stream should be positioned right at the start, or just after the '//' of the protocol.  The host name is terminated by one of $:, $/, $? or the end of the stream depending on wether there is a port, path, query or nothing following the host.  If the host name is of zero length, I record a nil host name.  The stream is left positioned at the terminating character."

	| hostnameStream |
	hostnameStream := WriteStream on: String new.
	[|nextCharacter| 
	nextCharacter := aStream peek.
	#($: $/ $? nil) includes: nextCharacter]
		whileFalse: [hostnameStream nextPut: aStream next].
	 hostnameStream contents isEmpty ifFalse: [hostname := hostnameStream contents].
	^self</body>

<body package="Swazoo-HTTP">defaultPort
	^80</body>

<body package="Swazoo-HTTP">readProtocolFrom: aStream 
	"^self
I read the protocol from the URI presumed to be in aStream.  The protocol preceeds '://' in the URI.  I leave the stream position either right after the '//' if there is a protocol, otherwise I reset the position to the start of the stream."

	| candidateProtocol |
	candidateProtocol := aStream upTo: $:.
	(aStream size - aStream position &gt;= 2 
		and: [aStream next == $/ and: [aStream next == $/]]) 
			ifTrue: [self protocol: candidateProtocol]
			ifFalse: [aStream reset].
	^self</body>

<body package="Swazoo-HTTP">readQueryFrom: sourceStream 
	"^self
*BAD* - currently assumes that we start positioned right after the $?
This is a first-cut at getting query values into an ordered collection of associations.  This is very crude, and should be changed to look for terminating characters rather than assuming that the end of the stream is the end of the URI."

	[sourceStream atEnd] whileFalse: 
			[| name stringValue |
			name := sourceStream upTo: $=.
			stringValue := HTTPString decodedHTTPFrom: (sourceStream upTo: $&amp;).
			self queries add: name -&gt; stringValue].
	^self</body>
</methods>



<initialize>
<class-id>Swazoo.HTTPServer</class-id>
</initialize><!-- Package Swazoo-Messages(1.1.3,janko)* -->


<class>
<name>MimeObject</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>contentType value </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<class>
<name>SwazooTask</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>request response </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.SwazooTask</class-id>
<body>A SwazooTask is simply a request-response pair.  This class just makes the task (ha!) of dealing with requests and responses a bit easier.</body>
</comment>

<class>
<name>HTTPPostDatum</name>
<environment>Swazoo</environment>
<super>Swazoo.MimeObject</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>filename </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<class>
<name>HTTPMessage</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>parent headers </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<class>
<name>HTTPRequest</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPMessage</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>requestLine peer timestamp ip environmentData resolution encrypted authenticated </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<class>
<name>HTTPPost</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPRequest</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>postData entityBody </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPPost</class-id>
<body>HTTPPost 

rfc26216 section 9.5

   The POST method is used to request that the origin server accept the
   entity enclosed in the request as a new subordinate of the resource
   identified by the Request-URI in the Request-Line.

Instance Variables:
	entityBody	&lt;&gt;	
	postData	&lt;HTTPPostDataArray&gt;	

</body>
</comment>

<class>
<name>HTTPPut</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPRequest</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>putData </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPPut</class-id>
<body>HTTPPut 

rfc26216 section 9.6

   The PUT method requests that the enclosed entity be stored under the
   supplied Request-URI. If the Request-URI refers to an already
   existing resource, the enclosed entity SHOULD be considered as a
   modified version of the one residing on the origin server. If the
   Request-URI does not point to an existing resource, and that URI is
   capable of being defined as a new resource by the requesting user
   agent, the origin server can create the resource with that URI. If a
   new resource is created, the origin server MUST inform the user agent
   via the 201 (Created) response. If an existing resource is modified,
   either the 200 (OK) or 204 (No Content) response codes SHOULD be sent
   to indicate successful completion of the request. If the resource
   could not be created or modified with the Request-URI, an appropriate
   error response SHOULD be given that reflects the nature of the
   problem. The recipient of the entity MUST NOT ignore any Content-*
   (e.g. Content-Range) headers that it does not understand or implement
   and MUST return a 501 (Not Implemented) response in such cases.

Instance Variables:
	putData	&lt;&gt;	

</body>
</comment>

<class>
<name>HTTPDelete</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPRequest</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPDelete</class-id>
<body>HTTPDelete 

rfc26216 section 9.7

The DELETE method requests that the origin server delete the resource
   identified by the Request-URI. This method MAY be overridden by human
   intervention (or other means) on the origin server. The client cannot
   be guaranteed that the operation has been carried out, even if the
   status code returned from the origin server indicates that the action
   has been completed successfully. However, the server SHOULD NOT
   indicate success unless, at the time the response is given, it
   intends to delete the resource or move it to an inaccessible
   location.
 ...
</body>
</comment>

<class>
<name>HTTPHead</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPRequest</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPHead</class-id>
<body>HTTPHead

rfc26216 section 9.4

   The HEAD method is identical to GET except that the server MUST NOT
   return a message-body in the response. The metainformation contained
   in the HTTP headers in response to a HEAD request SHOULD be identical
   to the information sent in response to a GET request. This method can
   be used for obtaining metainformation about the entity implied by the
   request without transferring the entity-body itself. This method is
   often used for testing hypertext links for validity, accessibility,
   and recent modification.

</body>
</comment>

<class>
<name>HTTPResponse</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPMessage</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>code entity </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<class>
<name>FileResponse</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPResponse</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<class>
<name>HTTPOptions</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPRequest</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPOptions</class-id>
<body>HTTPOptions

rfc26216 section 9.2

   The OPTIONS method represents a request for information about the
   communication options available on the request/response chain
   identified by the Request-URI. This method allows the client to
   determine the options and/or requirements associated with a resource,
   or the capabilities of a server, without implying a resource action
   or initiating a resource retrieval.

</body>
</comment>

<class>
<name>HTTPGet</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPRequest</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPGet</class-id>
<body>HTTPGet 

rfc26216 section 9.3

   The GET method means retrieve whatever information (in the form of an
   entity) is identified by the Request-URI. If the Request-URI refers
   to a data-producing process, it is the produced data which shall be
   returned as the entity in the response and not the source text of the
   process, unless that text happens to be the output of the process.
</body>
</comment>

<class>
<name>HTTPPostDataArray</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>underlyingCollection </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPPostDataArray</class-id>
<body>Introduced the HTTPPostDataArray to hold post data in an HTTPRequest in place of a Dictionary.  This is because it is legal for there to be more than one entry with the same name (key) and using a Dictionary  looses data (!).

Instance Variables:
	underlyingCollection	&lt;&gt;	

</body>
</comment>

<class>
<name>HTTPTrace</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPRequest</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPTrace</class-id>
<body>HTTPTrace 

rfc26216 section 9.8

   The TRACE method is used to invoke a remote, application-layer loop-
   back of the request message. The final recipient of the request
   SHOULD reflect the message received back to the client as the
   entity-body of a 200 (OK) response
</body>
</comment>

<class>
<name>HTTPRequestLine</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>method requestURI httpVersion </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Messages</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</class>





<shared-variable>
<name>StatusCodes</name>
<environment>Swazoo.HTTPResponse</environment>
<private>false</private>
<constant>false</constant>
<category>As yet unclassified</category>
<attributes>
<package>Swazoo-Messages</package>
</attributes>
</shared-variable>














<methods>
<class-id>Swazoo.MimeObject</class-id> <category>private-accessing</category>

<body package="Swazoo-Messages">defaultContentType
	^'application/octet-stream'</body>
</methods>

<methods>
<class-id>Swazoo.MimeObject</class-id> <category>accessing</category>

<body package="Swazoo-Messages">contentType: anObject
	contentType := anObject</body>

<body package="Swazoo-Messages">value
	^value</body>

<body package="Swazoo-Messages">contentType
	^contentType isNil ifTrue: [self defaultContentType] ifFalse: [contentType]</body>

<body package="Swazoo-Messages">value: anObject
	value := anObject</body>
</methods>


<methods>
<class-id>Swazoo.SwazooTask</class-id> <category>accessing</category>

<body package="Swazoo-Messages">response
	^response</body>

<body package="Swazoo-Messages">response: aHTTPResponse
	response := aHTTPResponse</body>

<body package="Swazoo-Messages">request
	^request</body>

<body package="Swazoo-Messages">request: aHTTPRequest
	request := aHTTPRequest</body>
</methods>


<methods>
<class-id>Swazoo.HTTPPostDatum</class-id> <category>private-accessing</category>

<body package="Swazoo-Messages">defaultContentType
	^'text/plain'</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPostDatum</class-id> <category>accessing</category>

<body package="Swazoo-Messages">filename: aString
	filename := aString</body>

<body package="Swazoo-Messages">filename
	^filename</body>
</methods>


<methods>
<class-id>Swazoo.HTTPMessage</class-id> <category>accessing</category>

<body package="Swazoo-Messages">parent
	^parent</body>

<body package="Swazoo-Messages">parent: aConnection
	parent := aConnection</body>

<body package="Swazoo-Messages">headers
	headers isNil ifTrue: [self initHeaders].
	^headers</body>
</methods>

<methods>
<class-id>Swazoo.HTTPMessage</class-id> <category>initialize-release</category>

<body package="Swazoo-Messages">initHeaders
	headers := HTTPHeaders new.
	self addInitialHeaders.</body>

<body package="Swazoo-Messages">addInitialHeaders
	"^self 
This is a no-op.  My subclasses may wish to add some initial headers."

	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPRequest class</class-id> <category>tests support</category>

<body package="Swazoo-Messages">request: aUriString from: aHostString at: anIPString 
	"For testing only (I'm guessing / hoping!).
A request is manufactured that has a request line method of &gt;&gt;methodName and a request line URI with an identifier of aUriString.  A Host header is added to the headers and the ip address is set to anIP string.
This may result in a corrupt or invalid request, but that's the natutre of testing, I guess."

	^self new 
		request: aUriString
		from: aHostString
		at: anIPString</body>

<body package="Swazoo-Messages">request: aUriString 
	"For testing only (I'm guessing / hoping!).  The idea to to create a request for a resource with the URI 'someHost/aUriString'."

	^self 
		request: aUriString
		from: 'someHost'
		at: 'someIP'</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">methodName
	"HTTP method used for a request"
	^self subclassResponsibility</body>

<body package="Swazoo-Messages">allMethodNames
	"...of all request methods we support there"
	self subclasses collect: [:each | each methodName].</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest class</class-id> <category>instance creation</category>

<body package="Swazoo-Messages">newFor: aRequestLine readFrom: aStream 
	"to support an additional http method, simply subclass a HTTPRequest!"
	| targetClass |
	targetClass := aRequestLine method = 'GET' 
		ifTrue: [HTTPGet] "most used anyway"
		ifFalse: [self subclasses detect: [:each | each methodName = aRequestLine method] ifNone: [nil] ].
	targetClass isNil ifTrue: [^HTTPException notImplemented].
	^targetClass new for: aRequestLine readFrom: aStream</body>

<body package="Swazoo-Messages">readFrom: aStream 
	"^an HTTPRequest
I create and return a new instance of one of my subclasses which will represent the HTTP request presumed to be the contents of aStream.
The first step is to work out which of my subclasses to create.  I do this by parsing the 'request-line' from the stream.  The request-line contains the 'method', and I look for the subclass that handles this method and delegate the rest of the message parsing to a new instance of that class."

	| sourceStream requestLine |
	sourceStream := HTTPReadStream onStream: aStream.
	requestLine := HTTPRequestLine readFrom: sourceStream.
	^self newFor: requestLine readFrom: sourceStream</body>
</methods>


<methods>
<class-id>Swazoo.HTTPRequest</class-id> <category>testing</category>

<body package="Swazoo-Messages">isOptions
	^false</body>

<body package="Swazoo-Messages">isTrace
	^false</body>

<body package="Swazoo-Messages">isGet
	^false</body>

<body package="Swazoo-Messages">isDelete
	^false</body>

<body package="Swazoo-Messages">wantsConnectionClose
	self isClose ifTrue: [^true].
	^self httpVersion last = 0 and: [self isKeepAlive not]</body>

<body package="Swazoo-Messages">isKeepAlive
	| header |
	header := self connection.
	header isNil ifTrue: [^false].
	^'*Keep-Alive*' match: self connection</body>

<body package="Swazoo-Messages">isPut
	^false</body>

<body package="Swazoo-Messages">isFromNetscape
	"NS&gt;7.0 or Mozilla or Firefox"
	^'*Gecko*' match: self userAgent</body>

<body package="Swazoo-Messages">isFromLinux
	^'*Linux*' match: self userAgent</body>

<body package="Swazoo-Messages">isAuthenticated
	^self authenticated isNil not</body>

<body package="Swazoo-Messages">hasCookie
	"check if  Cookie:  was in request header"

	^self headers includesFieldOfClass: HTTPCookieField</body>

<body package="Swazoo-Messages">isPost
	^false</body>

<body package="Swazoo-Messages">isFromWindows
	^'*Windows*' match: self userAgent</body>

<body package="Swazoo-Messages">isEncrypted
	^self encrypted isNil not</body>

<body package="Swazoo-Messages">isFromMSIE
	^'*MSIE*' match: self userAgent</body>

<body package="Swazoo-Messages">isHead
	^false</body>

<body package="Swazoo-Messages">isClose
	| connectionField |
	connectionField := self headers fieldOfClass: HTTPConnectionField
				ifNone: [nil].
	^connectionField notNil and: [connectionField connectionTokenIsClose]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest</class-id> <category>initialize-release</category>

<body package="Swazoo-Messages">initRequestLine
	requestLine := HTTPRequestLine new</body>

<body package="Swazoo-Messages">for: aRequestLine readFrom: aStream 
	"^self
I parse my headers from aStream and update my URI and HTTP version information from aRequest line.  I need to parse the headers first because, for some reason, the URI insists on knowing the host, and this is taken from the Host: header field."

	requestLine := aRequestLine.
	headers := HTTPHeaders readFrom: aStream.
	self setTimestamp.
	^self</body>

<body package="Swazoo-Messages">setTimestamp
	timestamp := Timestamp now</body>

<body package="Swazoo-Messages">initEnvironmentData
	environmentData := Dictionary new</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest</class-id> <category>printing</category>

<body package="Swazoo-Messages">printOn: aStream 
	aStream nextPutAll: 'an HTTPRequest'.
	self peer isNil 
		ifFalse: 
			[aStream
				nextPutAll: ' from: ';
				nextPutAll: self peer].
	aStream nextPutAll: ' at: '.
	self timestamp asRFC1123StringOn: aStream.
	aStream
		nextPutAll: ' url: '.
	self uri printOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest</class-id> <category>accessing-queries</category>

<body package="Swazoo-Messages">queryAt: aKey 
	^self uri queryAt: aKey</body>

<body package="Swazoo-Messages">includesQuery: aString 
	^self uri includesQuery: aString</body>

<body package="Swazoo-Messages">queryAt: aKey ifAbsent: aBlock 
	^self uri queryAt: aKey ifAbsent: aBlock</body>

<body package="Swazoo-Messages">queryData
	^self uri queryData</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest</class-id> <category>accessing</category>

<body package="Swazoo-Messages">environmentAt: aKey put: aValue 
	self environmentData at: aKey put: aValue</body>

<body package="Swazoo-Messages">uri
	^self requestLine requestURI</body>

<body package="Swazoo-Messages">resolution
	^resolution</body>

<body package="Swazoo-Messages">session
	^self environmentAt: #session</body>

<body package="Swazoo-Messages">session: aSession 
	self environmentAt: #session put: aSession</body>

<body package="Swazoo-Messages">methodName
	"HTTP method used for a request"
	^self class methodName</body>

<body package="Swazoo-Messages">timestamp
	^timestamp</body>

<body package="Swazoo-Messages">httpVersion
	^self requestLine httpVersion</body>

<body package="Swazoo-Messages">resolution: anObject
	resolution := anObject</body>

<body package="Swazoo-Messages">requestLine
	"^an HTTPRequestLine"

	requestLine isNil ifTrue: [self initRequestLine].
	^requestLine</body>

<body package="Swazoo-Messages">ip
	^ip</body>

<body package="Swazoo-Messages">peer
	^peer</body>

<body package="Swazoo-Messages">resourcePath
	^self resolution resourcePath</body>

<body package="Swazoo-Messages">tailPath
	^self resolution tailPath</body>

<body package="Swazoo-Messages">environmentAt: aKey 
	^self environmentAt: aKey ifAbsent: [nil]</body>

<body package="Swazoo-Messages">environmentAt: aKey ifAbsent: aBlock 
	^self environmentData at: aKey ifAbsent: aBlock</body>

<body package="Swazoo-Messages">uriString
	^self uri identifier</body>

<body package="Swazoo-Messages">urlString
	^self uri value</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest</class-id> <category>services</category>

<body package="Swazoo-Messages">respondUsing: responseBlock 
	"^an HTTPResponse
By default, I let aBlock handle creating the response by passing myself as the agrument to the block.  My subclasses may override this method and directly respond.  This is most likely for Unsupported requests and for things like OPTIONS requsts.  c.f. HTTPServer&gt;&gt;answerTo: "

	^responseBlock value: self</body>

<body package="Swazoo-Messages">conditionalHeaderFields
	"^an OrderedCollection
I return my collection of conditional header fields.  A conditional GET requires that each of these is checked against the current state of the target resource."

	^self headers fields select: [:aField | aField isConditional]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest</class-id> <category>accessing-headers</category>

<body package="Swazoo-Messages">referer
	| field |
	field := self headers fieldOfClass: HTTPRefererField ifNone: [nil].
	^field isNil ifTrue: [nil] ifFalse: [field uri]</body>

<body package="Swazoo-Messages">contentLength
	^(self headers fieldOfClass: HTTPContentLengthField) contentLength</body>

<body package="Swazoo-Messages">cookie
	| field |
	field := self headers fieldOfClass: HTTPCookieField ifNone: [nil].
	^field isNil ifTrue: [nil] ifFalse: [field valuesAsString]</body>

<body package="Swazoo-Messages">userAgent
	| userAgentField |
	userAgentField := self headers fieldOfClass: HTTPUserAgentField
				ifNone: [nil].
	^userAgentField isNil ifTrue: [nil] ifFalse: [userAgentField productTokens]</body>

<body package="Swazoo-Messages">connection
	^(self headers fieldOfClass: HTTPConnectionField ifNone: [^nil]) 
		connectionToken</body>

<body package="Swazoo-Messages">host
	^(self headers fieldOfClass: HTTPHostField ifNone: [^String new]) 
		hostName</body>

<body package="Swazoo-Messages">port
	"^an Integer
I return the port number to which the request was directed."

	^(self httpVersion at: 2) = 1 
		ifTrue: [(self headers fieldOfClass: HTTPHostField) portNumber]
		ifFalse: [self requestLine requestURI port]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequest</class-id> <category>private</category>

<body package="Swazoo-Messages">peer: anObject
	peer := anObject</body>

<body package="Swazoo-Messages">ip: anObject
	ip := anObject</body>

<body package="Swazoo-Messages">setEncrypted
	encrypted := true</body>

<body package="Swazoo-Messages">request: aUriString from: aHostString at: anIPString 
	"For testing only (I'm guessing / hoping!).
A request is manufactured that has a request line method of &gt;&gt;methodName and a request line URI with an identifier of aUriString.  A Host header is added to the headers and the ip address is set to anIP string.  I also set the HTTP version to #(1 1).
This may result in a corrupt or invalid request, but that's the natutre of testing, I guess."

	requestLine := (HTTPRequestLine new)
				method: self class methodName;
				requestURI: ((SwazooURI new)
							identifier: aUriString;
							yourself);
				httpVersion: #(1 1);
				yourself.
	self headers addField: (HTTPHostField newWithValueFrom: aHostString).
	self ip: anIPString.
	^self</body>

<body package="Swazoo-Messages">authenticated
	^authenticated</body>

<body package="Swazoo-Messages">queries
	^self uri queries</body>

<body package="Swazoo-Messages">setAuthenticated 	
	authenticated := true</body>

<body package="Swazoo-Messages">encrypted
	^encrypted</body>

<body package="Swazoo-Messages">environmentData
	environmentData isNil ifTrue: [self initEnvironmentData].
	^environmentData</body>
</methods>


<methods>
<class-id>Swazoo.HTTPPost class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">methodName
	^'POST'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPPost</class-id> <category>testing</category>

<body package="Swazoo-Messages">isPost
	^true</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPost</class-id> <category>initialize-release</category>

<body package="Swazoo-Messages">initPostData
	postData := HTTPPostDataArray new</body>

<body package="Swazoo-Messages">for: aRequestLine readFrom: aStream 
	| mediaType |
	super for: aRequestLine readFrom: aStream.
	((self headers includesFieldOfClass: ContentTypeField) 
		and: [self headers includesFieldOfClass: HTTPContentLengthField]) 
			ifFalse: 
				[^SwazooHTTPPostError 
					raiseSignal: 'Both Content-Type and Content-Length needed'].
	mediaType := (self headers fieldOfClass: ContentTypeField) mediaType.
	mediaType = 'application/x-www-form-urlencoded' 
		ifTrue: [^self urlencodedDataFrom: aStream].
	mediaType = 'multipart/form-data' 
		ifTrue: [^self multipartDataFrom: aStream].
	self applicationOctetStreamFrom: aStream</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPost</class-id> <category>accessing</category>

<body package="Swazoo-Messages">postDataAt: aKey do: aBlock 
	| val |
	val := self postData at: aKey ifAbsent: [nil].
	val isNil ifFalse: [aBlock value: val]</body>

<body package="Swazoo-Messages">entityBody
	^entityBody</body>

<body package="Swazoo-Messages">postDataAt: aKey put: aPostDatum 
	"for testing purposes"

	self postData at: aKey put: aPostDatum</body>

<body package="Swazoo-Messages">postDataAt: aKey putString: aString 
	"for testing purposes"

	self postDataAt: aKey put: (HTTPPostDatum new value: aString)</body>

<body package="Swazoo-Messages">postDataStringAt: aKey 
	^(self postDataAt: aKey ifAbsent: [^nil]) value</body>

<body package="Swazoo-Messages">emptyData
	^self postData select: [:each | each value isEmpty]</body>

<body package="Swazoo-Messages">postDataAt: aKey 
	^self postDataAt: aKey ifAbsent: [nil]</body>

<body package="Swazoo-Messages">postKeysAndValuesDo: aTwoArgBlock 
	self postData 
		keysAndValuesDo: [:key :each | aTwoArgBlock value: key value: each value]</body>

<body package="Swazoo-Messages">postDataAt: aKey ifAbsent: aBlock 
	^self postData at: aKey ifAbsent: aBlock</body>

<body package="Swazoo-Messages">postDataKeys
	^self postData keys</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPost</class-id> <category>private</category>

<body package="Swazoo-Messages">tokensIn: aSourceCollection basedOnAll: aSequenceableCollection 
	"Answer an OrderedCollection of the sub-sequences
	 of the receiver that are separated by aSequenceableCollection."

	| tokenPosition sourcePosition targetCollection |
	sourcePosition := 1.
	targetCollection := OrderedCollection new.
	
	[tokenPosition := aSourceCollection 
				indexOfSubCollection: aSequenceableCollection
				startingAt: sourcePosition.
	tokenPosition = 0] 
			whileFalse: 
				[targetCollection 
					add: (aSourceCollection copyFrom: sourcePosition to: tokenPosition - 1).
				sourcePosition := tokenPosition + aSequenceableCollection size].
	targetCollection 
		add: (aSourceCollection copyFrom: sourcePosition to: aSourceCollection size).
	^targetCollection</body>

<body package="Swazoo-Messages">urlencodedDataFrom: aStream 
	| e tokens |
	(self headers includesFieldOfClass: HTTPContentLengthField) ifFalse: [^self].
	e := aStream nextBytes: self contentLength.
	tokens := HTTPString subCollectionsFrom: (HTTPString stringFromBytes: e)
				delimitedBy: $&amp;.
	(tokens 
		collect: [:each | HTTPString subCollectionsFrom: each delimitedBy: $=]) 
			do: 
				[:keyVal | 
				| datum |
				datum := HTTPPostDatum new.
				datum 
					value: (HTTPString decodedHTTPFrom: (keyVal last 
									collect: [:char | char = $+ ifTrue: [Character space] ifFalse: [char]])).
				self postDataAt: keyVal first put: datum]</body>

<body package="Swazoo-Messages">postData
	postData isNil ifTrue: [self initPostData].
	^postData</body>

<body package="Swazoo-Messages">multipartDataFrom: aStream 
	| e tokens boundary contentTypeField |
	self headers fieldOfClass: HTTPContentLengthField
		ifNone: [^SwazooHTTPPostError raiseSignal: 'Content-Length header missing'].
	e := aStream nextBytes: self contentLength.
	contentTypeField := self headers fieldOfClass: ContentTypeField
				ifNone: [^self].
	boundary := contentTypeField transferCodings at: 'boundary'
				ifAbsent: [^self].
	tokens := self tokensIn: e basedOnAll: boundary asByteArray.
	tokens do: 
			[:bytes | 
			| part |
			part := self partFromBytes: bytes.
			part isNil ifFalse: [self postData at: part key put: part value]]</body>

<body package="Swazoo-Messages">partFromBytes: bytes 
	| str rs name datum |
	str := HTTPString trimBlanksFrom: (HTTPString stringFromBytes: bytes).
	str = '--' ifTrue: [^nil].
	rs := str readStream.
	name := nil.
	datum := HTTPPostDatum new.
	[rs atEnd] whileFalse: 
			[| line |
			line := rs upTo: Character cr.
			rs peek = Character lf 
				ifTrue: 
					[| field |
					rs next.
					line isEmpty 
						ifTrue: 
							[| entity |
							name isNil ifTrue: [^nil].
							entity := rs upToEnd.
							entity size &lt;= 4 
								ifTrue: [datum value: entity species new]
								ifFalse: [datum value: (entity copyFrom: 1 to: entity size - 4)].
							^name -&gt; datum].
					field := HeaderField fromLine: line.
					field isContentDisposition 
						ifTrue: [name := (field parameterAt: 'name') copyWithout: $"].
					field isContentType ifTrue: [datum contentType: field mediaType]]]</body>

<body package="Swazoo-Messages">applicationOctetStreamFrom: aStream 
	"^self 
rfc 2046 says:
The recommended action for an implementation that receives an 'application/octet-stream' entity is to simply offer to put the data in a file, with any Content-Transfer-Encoding undone, or perhaps to use it as input to a user-specified process.
This method used to do a crlf -&gt; cr conversion on the octet-stream, but was not clear why."

	self entityBody: (HTTPString 
				stringFromBytes: (aStream nextBytes: self contentLength)).
	^self</body>

<body package="Swazoo-Messages">entityBody: aString
	entityBody := aString</body>
</methods>


<methods>
<class-id>Swazoo.HTTPPut class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">methodName
	^'PUT'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPPut</class-id> <category>reading</category>

<body package="Swazoo-Messages">octetDataFrom: aStream 
	self headers fieldOfClass: HTTPContentLengthField
		ifNone: [^SwazooHTTPPutError raiseSignal: 'Missing Content-Length'].
	self putData: (aStream nextBytes: self contentLength)</body>

<body package="Swazoo-Messages">readFrom: aStream 
	| contentTypeField |
	super readFrom: aStream.
	contentTypeField := self headers fieldOfClass: ContentTypeField
				ifNone: [SwazooHTTPPutError raiseSignal: 'Missing Content-Type'].
	contentTypeField mediaType = 'application/octet-stream' 
		ifTrue: [self octetDataFrom: aStream]
		ifFalse: [self urlencodedDataFrom: aStream].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPut</class-id> <category>testing</category>

<body package="Swazoo-Messages">isPut
	^true</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPut</class-id> <category>accessing</category>

<body package="Swazoo-Messages">putData
	^putData</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPut</class-id> <category>private</category>

<body package="Swazoo-Messages">putData: aString
	putData := aString</body>
</methods>


<methods>
<class-id>Swazoo.HTTPHead class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">methodName
	^'HEAD'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPHead</class-id> <category>testing</category>

<body package="Swazoo-Messages">isHead
	^true</body>
</methods>


<methods>
<class-id>Swazoo.HTTPDelete class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">methodName
	"HTTP method used for a request"
	^'DELETE'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPDelete</class-id> <category>testing</category>

<body package="Swazoo-Messages">isDelete
	^true</body>
</methods>


<methods>
<class-id>Swazoo.HTTPResponse class</class-id> <category>response types</category>

<body package="Swazoo-Messages">notFound
	^super new
		code: 404;
		entity: '&lt;HTML&gt;
&lt;HEAD&gt;&lt;TITLE&gt;Not Found&lt;/TITLE&gt;&lt;/HEAD&gt;
&lt;BODY&gt;
&lt;H1&gt;404 Not Found&lt;/H1&gt;
&lt;P&gt;The requested resource was not found on this server.&lt;/P&gt;
&lt;/BODY&gt;&lt;/HTML&gt;'</body>

<body package="Swazoo-Messages">unauthorized
	^super new code: 401</body>

<body package="Swazoo-Messages">methodNotAllowed
"c.f. RFC 2616  10.4.6
   The method specified in the Request-Line is not allowed for the
   resource identified by the Request-URI. The response MUST include an
   Allow header containing a list of valid methods for the requested
   resource. "
	^super new code: 405</body>

<body package="Swazoo-Messages">forbidden
	^super new
		code: 403;
		entity: '&lt;HTML&gt;
&lt;HEAD&gt;&lt;TITLE&gt;Forbidden&lt;/TITLE&gt;&lt;/HEAD&gt;
&lt;BODY&gt;
&lt;H1&gt;403 Forbidden&lt;/H1&gt;
&lt;P&gt;Access to the requested resource is forbidden.&lt;/P&gt;
&lt;/BODY&gt;&lt;/HTML&gt;'</body>

<body package="Swazoo-Messages">badRequest
	^super new code: 400</body>

<body package="Swazoo-Messages">movedPermanently
	^super new code: 301</body>

<body package="Swazoo-Messages">notModified
	^super new code: 304</body>

<body package="Swazoo-Messages">found
	^super new code: 302</body>

<body package="Swazoo-Messages">internalServerError
	^super new
		code: 500;
		entity: '&lt;HTML&gt;
&lt;HEAD&gt;&lt;TITLE&gt;Not Found&lt;/TITLE&gt;&lt;/HEAD&gt;
&lt;BODY&gt;
&lt;H1&gt;500 Internal Server Error&lt;/H1&gt;
&lt;P&gt;The server experienced an error while processing this request.  If this problem persists, please contact the webmaster.&lt;/P&gt;
&lt;/BODY&gt;&lt;/HTML&gt;'</body>

<body package="Swazoo-Messages">ok
	^super new code: 200</body>

<body package="Swazoo-Messages">seeOther
	"^an HTTPResponse
The response to the request can be found under a different URI and SHOULD be retrieved using a GET method on that resource. This method exists primarily to allow the output of a POST-activated script to redirect the user agent to a selected resource.
See RFC 2616 10.3.4."

	^super new code: 303</body>

<body package="Swazoo-Messages">redirectLink
	"^an HTTPResponse
Note that 302 is really the 'found' response.  This code should really be 303 (&gt;&gt;seeOther).  However, because many clients take 302 &amp; 303 to be the same and because older clients don't understand 303, 302 is commonly used in this case.  See RFC 2616 10.3.4."

	^super new code: 302</body>

<body package="Swazoo-Messages">notImplemented
	^super new code: 501</body>
</methods>

<methods>
<class-id>Swazoo.HTTPResponse class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">statusTextForCode: aNumber
	^StatusCodes at: aNumber ifAbsent: ['']</body>
</methods>

<methods>
<class-id>Swazoo.HTTPResponse class</class-id> <category>class initialization</category>

<body package="Swazoo-Messages">initialize
	"self initialize"

	StatusCodes := (Dictionary new)
				add: 100 -&gt; 'Continue';
				add: 101 -&gt; 'Switching Protocols';
				add: 200 -&gt; 'OK';
				add: 201 -&gt; 'Created';
				add: 202 -&gt; 'Accepted';
				add: 203 -&gt; 'Non-Authoritative Information';
				add: 204 -&gt; 'No Content';
				add: 205 -&gt; 'Reset Content';
				add: 206 -&gt; 'Partial Content';
				add: 300 -&gt; 'Multiple Choices';
				add: 301 -&gt; 'Moved Permanently';
				add: 302 -&gt; 'Found';
				add: 303 -&gt; 'See Other';
				add: 304 -&gt; 'Not Modified';
				add: 305 -&gt; 'Use Proxy';
				add: 307 -&gt; 'Temporary Redirect';
				add: 400 -&gt; 'Bad Request';
				add: 401 -&gt; 'Unauthorized';
				add: 402 -&gt; 'Payment Required';
				add: 403 -&gt; 'Forbidden';
				add: 404 -&gt; 'Not Found';
				add: 405 -&gt; 'Method Not Allowed';
				add: 406 -&gt; 'Not Acceptable';
				add: 407 -&gt; 'Proxy Authentication Required';
				add: 408 -&gt; 'Request Time-out';
				add: 409 -&gt; 'Conflict';
				add: 410 -&gt; 'Gone';
				add: 411 -&gt; 'Length Required';
				add: 412 -&gt; 'Precondition Failed';
				add: 413 -&gt; 'Request Entity Too Large';
				add: 414 -&gt; 'Request-URI Too Large';
				add: 415 -&gt; 'Unsupported Media Type';
				add: 416 -&gt; 'Requested range not satisfiable';
				add: 417 -&gt; 'Expectation Failed';
				add: 500 -&gt; 'Internal Server Error';
				add: 501 -&gt; 'Not Implemented';
				add: 502 -&gt; 'Bad Gateway';
				add: 503 -&gt; 'Service Unavailable';
				add: 504 -&gt; 'Gateway Time-out';
				add: 505 -&gt; 'HTTP Version not supported';
				yourself.
	self postInitialize.</body>
</methods>


<methods>
<class-id>Swazoo.HTTPResponse</class-id> <category>testing</category>

<body package="Swazoo-Messages">isInternalServerError
	^self code = 500</body>

<body package="Swazoo-Messages">isOk
	^self code = 200</body>

<body package="Swazoo-Messages">isFound
	^self code = 302</body>

<body package="Swazoo-Messages">isUnauthorized
	^self code = 401</body>

<body package="Swazoo-Messages">isBadRequest
	^self code = 400</body>

<body package="Swazoo-Messages">isNotFound
	^self code = 404</body>

<body package="Swazoo-Messages">isSeeOther
	^self code = 303</body>

<body package="Swazoo-Messages">isNotModified
	^self code = 304</body>

<body package="Swazoo-Messages">isRedirectLink
	^self code = 302</body>

<body package="Swazoo-Messages">isMovedPermanently
	^self code = 301</body>

<body package="Swazoo-Messages">isNotImplemented
	^self code = 501</body>
</methods>

<methods>
<class-id>Swazoo.HTTPResponse</class-id> <category>initialize-release</category>

<body package="Swazoo-Messages">addServerHeader
	^self headers 
		addField: (HTTPServerField new productTokens: HTTPServer version)</body>

<body package="Swazoo-Messages">addDefaultBody
	self entity: '&lt;HTML&gt;
&lt;HEAD&gt;&lt;TITLE&gt;', (StatusCodes at: self code), '&lt;/TITLE&gt;&lt;/HEAD&gt;
  &lt;BODY&gt;
   &lt;H2&gt;', self code printString, ' ', (StatusCodes at: self code), '&lt;/H2&gt;
   &lt;P&gt;The server experienced an error while processing this request. &lt;BR&gt;
   If this problem persists, please contact the webmaster.&lt;/P&gt;
  &lt;P&gt;Swazoo Smalltalk Web Server&lt;/P&gt;
  &lt;/BODY&gt;
&lt;/HTML&gt;'</body>

<body package="Swazoo-Messages">code: anInteger 
	code := anInteger.
	(#(200) includes: code) ifFalse: [self addDefaultBody].</body>

<body package="Swazoo-Messages">addInitialHeaders
	self addServerHeader.
	self addDateHeader</body>

<body package="Swazoo-Messages">addDateHeader
	"^self
Note that the server must have it's clock set to GMT"

	self headers addField: (HTTPDateField new date: SpTimestamp now).
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPResponse</class-id> <category>private-printing</category>

<body package="Swazoo-Messages">printContentLengthOn: aStream 
	aStream
		nextPutAll: 'Content-Length: ';
		print: (self entity notNil ifTrue: [self entity size] ifFalse: [0]).
	self crlfOn: aStream</body>

<body package="Swazoo-Messages">printHeadersOn: aStream 
	"^self
Write the headers (key-value pairs) to aStream.  The key
must be a String."

	self headers fields do: 
			[:aField | 
			aField printOn: aStream.
			self crlfOn: aStream]</body>

<body package="Swazoo-Messages">crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf</body>

<body package="Swazoo-Messages">endHeaderOn: aStream 
	self crlfOn: aStream</body>

<body package="Swazoo-Messages">printStatusOn: aStream 
	aStream
		nextPutAll: 'HTTP/1.1 ';
		print: self code;
		space;
		nextPutAll: (self class statusTextForCode: self code).
	self crlfOn: aStream</body>

<body package="Swazoo-Messages">printEntityOn: aStream 
	self entity isNil ifFalse: [aStream nextPutBytes: self entity]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPResponse</class-id> <category>accessing</category>

<body package="Swazoo-Messages">entity
	^entity</body>

<body package="Swazoo-Messages">writeHeaderTo: aStream 
	self printStatusOn: aStream.
	self printHeadersOn: aStream.
	self printContentLengthOn: aStream.
	self endHeaderOn: aStream</body>

<body package="Swazoo-Messages">code
	^code</body>

<body package="Swazoo-Messages">entity: anEntity 
	entity := anEntity asByteArray</body>

<body package="Swazoo-Messages">codeText
	^self class statusTextForCode: self code</body>

<body package="Swazoo-Messages">writeTo: aStream 
	self writeHeaderTo: aStream.
	self printEntityOn: aStream</body>
</methods>

<methods>
<class-id>Swazoo.HTTPResponse</class-id> <category>accessing-headers</category>

<body package="Swazoo-Messages">cookie: aString 
	| newField |
	newField := HTTPSetCookieField new.
	newField addCookie: aString.
	self headers addField: newField.
	^self</body>

<body package="Swazoo-Messages">contentType: aString 
	self headers addField: (ContentTypeField new mediaType: aString).
	^self</body>

<body package="Swazoo-Messages">contentType
	"^a String
Return the media type from my Content-Type header field."

	^self headers 
		fieldOfClass: ContentTypeField
		ifPresent: [:field | field mediaType]
		ifAbsent: ['application/octet-stream']</body>

<body package="Swazoo-Messages">location: aString 
	self headers addField: (HTTPLocationField new uriString: aString).
	^self</body>

<body package="Swazoo-Messages">addHeaderName: aName value: aValue 
	^self headers addField: (GenericHeaderField newForFieldName: aName withValueFrom: aValue)</body>
</methods>

<methods>
<class-id>Swazoo.HTTPResponse</class-id> <category>private</category>

<body package="Swazoo-Messages">informConnectionClose
	self headers 
		fieldOfClass: HTTPConnectionField
		ifPresent: [:field | field setToClose]
		ifAbsent: [self headers addField: HTTPConnectionField new setToClose].
	^self</body>
</methods>


<methods>
<class-id>Swazoo.FileResponse</class-id> <category>accessing</category>

<body package="Swazoo-Messages">entity: aMimeObject 
	entity := aMimeObject</body>
</methods>

<methods>
<class-id>Swazoo.FileResponse</class-id> <category>accessing-headers</category>

<body package="Swazoo-Messages">contentType
	^self entity contentType</body>
</methods>

<methods>
<class-id>Swazoo.FileResponse</class-id> <category>private-printing</category>

<body package="Swazoo-Messages">printEntityOn: aStream 
	| rs |
	self entity isNil 
		ifFalse: 
			[rs := self entity value readStream.
			rs lineEndTransparent.
			SpExceptionContext 
				for: 
					[[[rs atEnd] whileFalse: [aStream nextPutAll: (rs nextAvailable: 2000)]] 
						ensure: [rs close]]
				on: SpError
				do: [:ex | ex return]]</body>

<body package="Swazoo-Messages">printContentLengthOn: aStream 
	self entity isNil 
		ifFalse: 
			[aStream
				nextPutAll: 'Content-Length: ';
				print: self entity value fileSize.
			self crlfOn: aStream]</body>

<body package="Swazoo-Messages">printHeadersOn: aStream 
	self contentType: self entity contentType.
	super printHeadersOn: aStream</body>
</methods>


<methods>
<class-id>Swazoo.HTTPOptions class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">methodName
	^'OPTIONS'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPOptions</class-id> <category>services</category>

<body package="Swazoo-Messages">respondUsing: responseBlock 
	"^an HTTPResponse
I represent a request for the options supported by this server.  I respond with a 200 (OK) and a list of my supported methods in an Allow: header.  I ignore the responseBlock."

	| response allowField |
	response := HTTPResponse ok.
	allowField := HTTPAllowField new.
	allowField methods addAll: self class allMethodNames.
	response headers addField: allowField.
	^response</body>
</methods>

<methods>
<class-id>Swazoo.HTTPOptions</class-id> <category>testing</category>

<body package="Swazoo-Messages">isOptions
	^true</body>
</methods>


<methods>
<class-id>Swazoo.HTTPGet class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">methodName
	^'GET'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPGet</class-id> <category>testing</category>

<body package="Swazoo-Messages">isGet
	^true</body>
</methods>


<methods>
<class-id>Swazoo.HTTPPostDataArray</class-id> <category>testing</category>

<body package="Swazoo-Messages">isEmpty
	^self underlyingCollection isEmpty</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPostDataArray</class-id> <category>accessing</category>

<body package="Swazoo-Messages">at: aKey 
	^(self allAt: aKey) last</body>

<body package="Swazoo-Messages">at: key put: anObject 
	self underlyingCollection add: (Association key: key value: anObject).
	^anObject</body>

<body package="Swazoo-Messages">keys
"^a Set
I mimick the behavior of a Dictionay which I replace.  I return a set of the keys in my underlying collection of associations."

	^(self underlyingCollection collect: [:anAssociation| anAssociation key]) asSet</body>

<body package="Swazoo-Messages">at: aKey ifAbsent: aBlock 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates isEmpty ifTrue: [aBlock value] ifFalse: [candidates last value]</body>

<body package="Swazoo-Messages">includesValue: aString 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation value value = aString].
	^candidates notEmpty</body>

<body package="Swazoo-Messages">associations
	^self underlyingCollection</body>

<body package="Swazoo-Messages">nameForValue: aString
	^(self allNamesForValue: aString) last</body>

<body package="Swazoo-Messages">includesKey: aKey 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates notEmpty</body>

<body package="Swazoo-Messages">allAt: aKey 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates collect: [:anAssociation| anAssociation value]</body>

<body package="Swazoo-Messages">allNamesForValue: aString 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation value value = aString].
	^candidates collect: [:anAssociation| anAssociation key]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPostDataArray</class-id> <category>enumerating</category>

<body package="Swazoo-Messages">keysAndValuesDo: aTwoArgumentBlock 
	self underlyingCollection do: 
		[:anAssociation | aTwoArgumentBlock value: anAssociation key value: anAssociation value]</body>

<body package="Swazoo-Messages">select: aBlock 
"^an Object
I run the select on the values of the associations in my underlying collection.  This mimicks the behavior when a Dictionary was used in my place."
	^self underlyingCollection select:  [:anAssociation| aBlock value: anAssociation value]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPPostDataArray</class-id> <category>private</category>

<body package="Swazoo-Messages">underlyingCollection
	underlyingCollection isNil 
		ifTrue: [underlyingCollection := OrderedCollection new].
	^underlyingCollection</body>
</methods>


<methods>
<class-id>Swazoo.HTTPRequestLine class</class-id> <category>instance creation</category>

<body package="Swazoo-Messages">readFrom: aStream 
	"^an HTTPRequestLine
I return a new instance of myself which represents a request line read from aStream.  If no valid request line can be found, I throw an exception."

	^self new readFrom: aStream</body>
</methods>


<methods>
<class-id>Swazoo.HTTPRequestLine</class-id> <category>initialize-release</category>

<body package="Swazoo-Messages">parseHTTPVersionFrom: sourceStream 
	| major minor |
	sourceStream upTo: $/.
	major := (sourceStream upTo: $.) asNumber.
	minor := (sourceStream upTo: Character cr) asNumber.
	self httpVersion: (Array with: major with: minor).
	sourceStream next.
	^self</body>

<body package="Swazoo-Messages">parseURIFrom: sourceStream 
	"^self
Really, we should parse the URI directly out of the stream."

	requestURI := SwazooURI fromString: (sourceStream upTo: Character space).
	^self</body>

<body package="Swazoo-Messages">readFrom: sourceStream 
	"^self
I initialize myself to represents a request line read from aStream.  If no valid request line can be found, I throw an exception."

	self skipLeadingBlankLinesIn: sourceStream.
	method := sourceStream upTo: Character space.
	self parseURIFrom: sourceStream.
	self parseHTTPVersionFrom: sourceStream.
	^self</body>

<body package="Swazoo-Messages">skipLeadingBlankLinesIn: aStream 
	"^self
RFC 2616:
In the interest of robustness, servers SHOULD ignore any empty
line(s) received where a Request-Line is expected. In other words, if
the server is reading the protocol stream at the beginning of a
message and receives a CRLF first, it should ignore the CRLF."

	[aStream peek == Character cr] whileTrue: 
			[((aStream next: 2) at: 2 == Character lf) 
				ifFalse: [SwazooHTTPParseError raiseSignal: 'CR without LF']].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequestLine</class-id> <category>accessing</category>

<body package="Swazoo-Messages">method
	^method</body>

<body package="Swazoo-Messages">requestURI
	^requestURI</body>

<body package="Swazoo-Messages">httpVersion
	^httpVersion</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequestLine</class-id> <category>private</category>

<body package="Swazoo-Messages">method: aString
"For development testing only"
	method := aString.
	^self</body>

<body package="Swazoo-Messages">requestURI: aString 
	"Development testing only!"

	requestURI := aString.
	^self</body>

<body package="Swazoo-Messages">httpVersion: anArray 
	httpVersion := anArray.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPTrace class</class-id> <category>accessing</category>

<body package="Swazoo-Messages">methodName
	^'TRACE'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPTrace</class-id> <category>testing</category>

<body package="Swazoo-Messages">isTrace
	^true</body>
</methods>



<initialize>
<class-id>Swazoo.HTTPResponse</class-id>
</initialize><!-- Package Swazoo-Headers(1.1.1,janko)= -->


<class>
<name>HTTPHeaders</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>fields </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-HTTP</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HeaderField</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars>httpFieldNameToClassDictionary </class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>SpecificHeaderField</name>
<environment>Swazoo</environment>
<super>Swazoo.HeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>ContentDispositionField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>type parameters </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPLastModifiedField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>date </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPContentLengthField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>contentLength </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPHostField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>hostName portNumber </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPAcceptField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>mediaTypes </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPConnectionField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>connectionToken </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPConnectionField</class-id>
<body>c.f. RFC 2616 14.10

   The Connection header has the following grammar:

       Connection = "Connection" ":" 1#(connection-token)
       connection-token  = token

</body>
</comment>

<class>
<name>HTTPLocationField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>uri </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPETagField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>entityTag </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPETagField</class-id>
<body>RFC 2626 14.19 ETag

   The ETag response-header field provides the current value of the
   entity tag for the requested variant. The headers used with entity
   tags are described in sections 14.24, 14.26 and 14.44. The entity tag
   MAY be used for comparison with other entities from the same resource
   (see section 13.3.3).

      ETag = "ETag" ":" entity-tag

   Examples:

      ETag: "xyzzy"
      ETag: W/"xyzzy"
      ETag: ""

</body>
</comment>

<class>
<name>HTTPCacheControlField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>private maxAge </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>ContentTypeField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>mediaType transferCodings </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPIfModifiedSinceField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>date </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPCookieField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>values </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPDateField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>date </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPWWWAuthenticateField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPWWWAuthenticateDigestField</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPWWWAuthenticateField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPRefererField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>uri </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPRefererField</class-id>
<body>RFC 2616: 14.36 Referer

   The Referer[sic] request-header field allows the client to specify,
   for the server's benefit, the address (URI) of the resource from
   which the Request-URI was obtained (the "referrer", although the
   header field is misspelled.) The Referer request-header allows a
   server to generate lists of back-links to resources for interest,
   logging, optimized caching, etc. It also allows obsolete or mistyped
   links to be traced for maintenance. The Referer field MUST NOT be
   sent if the Request-URI was obtained from a source that does not have
   its own URI, such as input from the user keyboard.

       Referer        = "Referer" ":" ( absoluteURI | relativeURI )

   Example:

       Referer: http://www.w3.org/hypertext/DataSources/Overview.html

   If the field value is a relative URI, it SHOULD be interpreted
   relative to the Request-URI. The URI MUST NOT include a fragment. See
   section 15.1.3 for security considerations.

</body>
</comment>

<class>
<name>HTTPAuthorizationField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>credentials </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPAuthorizationBasicField</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPAuthorizationField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>userid password </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPAuthorizationDigestField</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPAuthorizationField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPServerField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>productTokens </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPIfRangeField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPAllowField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>methods </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>GenericHeaderField</name>
<environment>Swazoo</environment>
<super>Swazoo.HeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>name value </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPMatchField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>entityTags </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPIfMatchField</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPMatchField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPIfMatchField</class-id>
<body>From RFC 2616

14.24 If-Match

   The If-Match request-header field is used with a method to make it
   conditional. A client that has one or more entities previously
   obtained from the resource can verify that one of those entities is
   current by including a list of their associated entity tags in the
   If-Match header field. Entity tags are defined in section 3.11. The
   purpose of this feature is to allow efficient updates of cached
   information with a minimum amount of transaction overhead. It is also
   used, on updating requests, to prevent inadvertent modification of
   the wrong version of a resource. As a special case, the value "*"
   matches any current entity of the resource.

       If-Match = "If-Match" ":" ( "*" | 1#entity-tag )

   If any of the entity tags match the entity tag of the entity that
   would have been returned in the response to a similar GET request
   (without the If-Match header) on that resource, or if "*" is given

   and any current entity exists for that resource, then the server MAY
   perform the requested method as if the If-Match header field did not
   exist.

   A server MUST use the strong comparison function (see section 13.3.3)
   to compare the entity tags in If-Match.

   If none of the entity tags match, or if "*" is given and no current
   entity exists, the server MUST NOT perform the requested method, and
   MUST return a 412 (Precondition Failed) response. This behavior is
   most useful when the client wants to prevent an updating method, such
   as PUT, from modifying a resource that has changed since the client
   last retrieved it.

   If the request would, without the If-Match header field, result in
   anything other than a 2xx or 412 status, then the If-Match header
   MUST be ignored.

   The meaning of "If-Match: *" is that the method SHOULD be performed
   if the representation selected by the origin server (or by a cache,
   possibly using the Vary mechanism, see section 14.44) exists, and
   MUST NOT be performed if the representation does not exist.

   A request intended to update a resource (e.g., a PUT) MAY include an
   If-Match header field to signal that the request method MUST NOT be
   applied if the entity corresponding to the If-Match value (a single
   entity tag) is no longer a representation of that resource. This
   allows the user to indicate that they do not wish the request to be
   successful if the resource has been changed without their knowledge.
   Examples:

       If-Match: "xyzzy"
       If-Match: "xyzzy", "r2d2xxxx", "c3piozzzz"
       If-Match: *

   The result of a request having both an If-Match header field and
   either an If-None-Match or an If-Modified-Since header fields is
   undefined by this specification.

</body>
</comment>

<class>
<name>HTTPWWWAuthenticateBasicField</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPWWWAuthenticateField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>realm </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPUserAgentField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>productTokens </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPUserAgentField</class-id>
<body>RFC 2616: 14.43 User-Agent

   The User-Agent request-header field contains information about the
   user agent originating the request. This is for statistical purposes,
   the tracing of protocol violations, and automated recognition of user
   agents for the sake of tailoring responses to avoid particular user
   agent limitations. User agents SHOULD include this field with
   requests. The field can contain multiple product tokens (section 3.8)
   and comments identifying the agent and any subproducts which form a
   significant part of the user agent. By convention, the product tokens
   are listed in order of their significance for identifying the
   application.

       User-Agent     = "User-Agent" ":" 1*( product | comment )

   Example:

       User-Agent: CERN-LineMode/2.15 libwww/2.17b3</body>
</comment>

<class>
<name>HTTPIfUnmodifiedSinceField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPSetCookieField</name>
<environment>Swazoo</environment>
<super>Swazoo.SpecificHeaderField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>cookies </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<class>
<name>HTTPIfNoneMatchField</name>
<environment>Swazoo</environment>
<super>Swazoo.HTTPMatchField</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Headers</category>
<attributes>
<package>Swazoo-Headers</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPIfNoneMatchField</class-id>
<body>This is a confitional header field.  The HTTP client is asking for a resource on the basis of this condition.  So, we need to have first found the resource, and then we can considder the condition, as follows ...

From RFC 2616:

14.26 If-None-Match

   The If-None-Match request-header field is used with a method to make
   it conditional. A client that has one or more entities previously
   obtained from the resource can verify that none of those entities is
   current by including a list of their associated entity tags in the
   If-None-Match header field. The purpose of this feature is to allow
   efficient updates of cached information with a minimum amount of
   transaction overhead. It is also used to prevent a method (e.g. PUT)
   from inadvertently modifying an existing resource when the client
   believes that the resource does not exist.

   As a special case, the value "*" matches any current entity of the
   resource.

       If-None-Match = "If-None-Match" ":" ( "*" | 1#entity-tag )

   If any of the entity tags match the entity tag of the entity that
   would have been returned in the response to a similar GET request
   (without the If-None-Match header) on that resource, or if "*" is
   given and any current entity exists for that resource, then the
   server MUST NOT perform the requested method, unless required to do
   so because the resource's modification date fails to match that
   supplied in an If-Modified-Since header field in the request.
   Instead, if the request method was GET or HEAD, the server SHOULD
   respond with a 304 (Not Modified) response, including the cache-
   related header fields (particularly ETag) of one of the entities that
   matched. For all other request methods, the server MUST respond with
   a status of 412 (Precondition Failed).

   See section 13.3.3 for rules on how to determine if two entities tags
   match. The weak comparison function can only be used with GET or HEAD
   requests.

   If none of the entity tags match, then the server MAY perform the
   requested method as if the If-None-Match header field did not exist,
   but MUST also ignore any If-Modified-Since header field(s) in the
   request. That is, if no entity tags match, then the server MUST NOT
   return a 304 (Not Modified) response.

   If the request would, without the If-None-Match header field, result
   in anything other than a 2xx or 304 status, then the If-None-Match
   header MUST be ignored. (See section 13.3.4 for a discussion of
   server behavior when both If-Modified-Since and If-None-Match appear
   in the same request.)

   The meaning of "If-None-Match: *" is that the method MUST NOT be
   performed if the representation selected by the origin server (or by
   a cache, possibly using the Vary mechanism, see section 14.44)
   exists, and SHOULD be performed if the representation does not exist.
   This feature is intended to be useful in preventing races between PUT
   operations.

   Examples:

       If-None-Match: "xyzzy"
       If-None-Match: W/"xyzzy"
       If-None-Match: "xyzzy", "r2d2xxxx", "c3piozzzz"
       If-None-Match: W/"xyzzy", W/"r2d2xxxx", W/"c3piozzzz"
       If-None-Match: *

   The result of a request having both an If-None-Match header field and
   either an If-Match or an If-Unmodified-Since header fields is
   undefined by this specification.</body>
</comment>


































<methods>
<class-id>Swazoo.HTTPHeaders class</class-id> <category>instance creation</category>

<body package="Swazoo-Headers">readFrom: aStream 
	"^an HTTPHeaders
I return a new instance of myself which contains fields parsed from aStream."

	^self new readFrom: aStream</body>
</methods>


<methods>
<class-id>Swazoo.HTTPHeaders</class-id> <category>services</category>

<body package="Swazoo-Headers">getOrMakeFieldOfClass: aClass 
	"^a HeaderField
If I contain a field of class aClass, I return it.   Otherwise I create a new instance if the field class and add it to my collection of headers."

	^self fieldOfClass: aClass
		ifNone: 
			[| newField |
			newField := aClass new.
			self addField: newField.
			newField]</body>

<body package="Swazoo-Headers">fieldNamed: aString ifNone: aBlock 
	"^aString
If I contain a field named aString, I return it.  Otherwise I evaluate aBlock."

	^self fields at: aString asUppercase ifAbsent: aBlock</body>

<body package="Swazoo-Headers">fieldNamed: aFieldName ifPresent: presentBlock ifAbsent: absentBlock 
	"^an Object
I look for a field named aFieldName among my fields.  If I find it, I return the result of evaluating presentBlock with the found field as an argument, otherwise I return the result of evaluate the absentBlock"

	| foundField |
	foundField := self fieldNamed: aFieldName ifNone: [nil].
	^foundField isNil 
		ifTrue: [absentBlock value]
		ifFalse: [presentBlock value: foundField]</body>

<body package="Swazoo-Headers">fieldOfClass: aClass ifNone: aBlock 
	"^aString
If I contain a field of class aClass, I return it.   Otherwise I evaluate aBlock."

	^self fields detect: [:aField | aField class == aClass] ifNone: aBlock</body>

<body package="Swazoo-Headers">addField: aField 
	"HTTPSpec1.1 Sec4.2
Multiple message-header fields with the same field-name MAY be present in a message if and only if the entire field-value for that header field is defined as a comma-separated list [i.e., #(values)]. It MUST be possible to combine the multiple header fields into one 'field-name: field-value' pair, without changing the semantics of the message, by appending each subsequent field-value to the first, each separated by a comma. The order in which header fields with the same field-name are received is therefore significant to the interpretation of the combined field value, and thus a proxy MUST NOT change the order of these field values when a message is forwarded.
Note that we have to use the field name here as we may be adding a field for which there is no class, i.e. it's a GenericHeaderField."

	(self includesFieldNamed: aField name) 
		ifTrue: [(self fieldNamed: aField name) combineWith: aField]
		ifFalse: [self fields at: aField name asUppercase put: aField].
	^self</body>

<body package="Swazoo-Headers">fieldNamed: aString 
	"^aString
If I contain a field named aString, I return it.  Otherwise an exception is thrown.
This is a bad way of getting a field.  Use &gt;&gt; fieldOfClass: instead."

	| targetString |
	targetString := aString asUppercase.
	^self fields detect: [:aField | aField name asUppercase = targetString]</body>

<body package="Swazoo-Headers">fieldOfClass: fieldClass ifPresent: presentBlock ifAbsent: absentBlock 
	"^an Object
I look for a field of class fieldClass among my fields.  If I find it, I return the result of evaluating presentBlock with the found field as an argument, otherwise I return the result of evaluate the absentBlock"

	| foundField |
	foundField := self fieldOfClass: fieldClass ifNone: [nil].
	^foundField isNil 
		ifTrue: [absentBlock value]
		ifFalse: [presentBlock value: foundField]</body>

<body package="Swazoo-Headers">fieldOfClass: aClass 
	"^aString
If I contain a field of class aClass, I return it.   Otherwise an exception is thrown."

	^self fields detect: [:aField | aField class == aClass]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPHeaders</class-id> <category>emitting</category>

<body package="Swazoo-Headers">writeOn: aStream 
	"^self
I write all my fields to aStream."

	self fields do: 
			[:aField | 
			aField printOn: aStream.
			self crlfOn: aStream]</body>

<body package="Swazoo-Headers">crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf</body>
</methods>

<methods>
<class-id>Swazoo.HTTPHeaders</class-id> <category>testing</category>

<body package="Swazoo-Headers">includesFieldOfClass: aClass 
	"^a Boolean
I return true if one of my fields is of class aClass."

	^self 
		fieldOfClass: aClass
		ifPresent: [:aField | true]
		ifAbsent: [false]</body>

<body package="Swazoo-Headers">includesFieldNamed: aString 
	"^a Boolean
I return true if one of my fields has the name aString."

	| targetField |
	targetField := self fieldNamed: aString ifNone: [nil].
	^targetField notNil</body>
</methods>

<methods>
<class-id>Swazoo.HTTPHeaders</class-id> <category>initialize-release</category>

<body package="Swazoo-Headers">readFieldFromString: aString 
	"^self
First I get the field parsed from aString, then I add the new field to my collection of fields.  Adding the new field may involve merging field values if I already have a field of that class."

	self addField: (HeaderField fromLine: aString).
	^self</body>

<body package="Swazoo-Headers">readFrom: aStream 
	"^an HTTPHeaders
I return a new instance of myself which contains fields parsed from aStream.  Everything upto the next blank line is a header field."

	
	[| nextLine |
	nextLine := aStream nextUnfoldedLine.
	nextLine isEmpty 
		ifTrue: [true]
		ifFalse: 
			[self readFieldFromString: nextLine.
			false]] 
			whileFalse: [].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPHeaders</class-id> <category>private</category>

<body package="Swazoo-Headers">fields
	fields isNil ifTrue: [fields := Dictionary new].
	^fields</body>
</methods>


<methods>
<class-id>Swazoo.HeaderField class</class-id> <category>private</category>

<body package="Swazoo-Headers">classForFieldName: aString 
	"^a Class
If I can find a specific header field with a name matching aString I return that.  Otherwise I return the GenericHeaderField class."

	^self httpFieldNameToClassDictionary at: aString
		ifAbsent: [GenericHeaderField]</body>

<body package="Swazoo-Headers">httpFieldNameToClassDictionary
	"^a Class
I return the dictionarry of my subclasses keyed on the name of the field they represent.
Note that we only need *Request* headers listed in here because they are the only thing we will be parsing for."

	"After a change here, remeber to do 'HeaderField resetHttpFieldNameToClassDictionary' "

	httpFieldNameToClassDictionary isNil 
		ifTrue: 
			[| headerClasses |
			headerClasses := OrderedCollection new.
			headerClasses
				add: ContentDispositionField;
				add: HTTPContentLengthField;
				add: ContentTypeField;
				add: HTTPAcceptField;
				add: HTTPAuthorizationField;
				add: HTTPConnectionField;
				add: HTTPHostField;
				add: HTTPIfMatchField;
				add: HTTPIfModifiedSinceField;
				add: HTTPIfNoneMatchField;
				add: HTTPIfRangeField;
				add: HTTPIfUnmodifiedSinceField;
				add: HTTPRefererField;
				add: HTTPUserAgentField.
			httpFieldNameToClassDictionary := Dictionary new.
			headerClasses do: 
					[:aClass | 
					httpFieldNameToClassDictionary at: aClass fieldName asUppercase put: aClass]].
	^httpFieldNameToClassDictionary</body>

<body package="Swazoo-Headers">newForFieldName: fieldNameString withValueFrom: fieldValueString 
	^self subclassResponsibility</body>

<body package="Swazoo-Headers">resetHttpFieldNameToClassDictionary
	
	httpFieldNameToClassDictionary := nil .
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HeaderField class</class-id> <category>instance creation</category>

<body package="Swazoo-Headers">fromLine: aString 
	| sourceStream fieldName fieldValue fieldClass |
	sourceStream := ReadStream on: aString.
	fieldName := (HTTPString trimBlanksFrom: (sourceStream upTo: $:)) 
				asUppercase.
	fieldClass := self classForFieldName: fieldName.
	fieldValue := HTTPString trimBlanksFrom: sourceStream upToEnd.
	^fieldClass newForFieldName: fieldName withValueFrom: fieldValue</body>
</methods>


<methods>
<class-id>Swazoo.HeaderField</class-id> <category>services</category>

<body package="Swazoo-Headers">combineWith: aHeaderField 
	SwazooHeaderFieldParseError raiseSignal: 'Not supported'</body>
</methods>

<methods>
<class-id>Swazoo.HeaderField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isConditional
	^false</body>

<body package="Swazoo-Headers">isContentDisposition
	^false</body>

<body package="Swazoo-Headers">isContentType
	^false</body>
</methods>

<methods>
<class-id>Swazoo.HeaderField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">values
	^self subclassResponsibility</body>

<body package="Swazoo-Headers">fieldName
	^self subclassResponsibility</body>

<body package="Swazoo-Headers">name
	^self subclassResponsibility</body>
</methods>

<methods>
<class-id>Swazoo.HeaderField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream
	^self subclassResponsibility</body>

<body package="Swazoo-Headers">valuesAsString
	| targetStream |
	targetStream := WriteStream on: String new.
	self valuesAsStringOn: targetStream.
	^targetStream contents</body>

<body package="Swazoo-Headers">printOn: aStream 
	aStream
		nextPutAll: self name;
		nextPutAll: ': '.
	self valuesAsStringOn: aStream.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.SpecificHeaderField class</class-id> <category>private</category>

<body package="Swazoo-Headers">newForFieldName: fieldNameString withValueFrom: fieldValueString 
	^self newWithValueFrom: fieldValueString</body>

<body package="Swazoo-Headers">newWithValueFrom: fieldValueString 
	^self new valueFrom: fieldValueString</body>
</methods>

<methods>
<class-id>Swazoo.SpecificHeaderField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^self subclassResponsibility</body>
</methods>


<methods>
<class-id>Swazoo.SpecificHeaderField</class-id> <category>initialize-release</category>

<body package="Swazoo-Headers">valueFrom: fieldValueString 
	self parseValueFrom: fieldValueString.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.SpecificHeaderField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">parameterAt: aString ifAbsent: aBlock 
1 halt: 'use the transfer encodings of the field, not this'.
	^self parameters at: aString ifAbsent: aBlock</body>

<body package="Swazoo-Headers">name
	^self class fieldName</body>

<body package="Swazoo-Headers">values
	^Array with: self value</body>
</methods>

<methods>
<class-id>Swazoo.SpecificHeaderField</class-id> <category>private</category>

<body package="Swazoo-Headers">readParametersFrom: sourceStream 
	"^a Dictionary
c.f. RFC 2616 3.6 Transfer Codings"

	| parameters |
	parameters := Dictionary new.
	[sourceStream atEnd] whileFalse: 
			[| attribute value |
			attribute := HTTPString trimBlanksFrom: (sourceStream upTo: $=).
			value := HTTPString trimBlanksFrom: (sourceStream upTo: $;).
			parameters at: attribute put: value].
	^parameters</body>

<body package="Swazoo-Headers">parseValueFrom: aString
	^self subclassResponsibility</body>
</methods>


<methods>
<class-id>Swazoo.HTTPLastModifiedField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Last-Modified'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPLastModifiedField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	self date asRFC1123StringOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPLastModifiedField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">date
	^date</body>

<body package="Swazoo-Headers">date: aDate 
	date := aDate.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPContentLengthField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Content-Length'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPContentLengthField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	self contentLength printOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPContentLengthField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">contentLength
	^contentLength</body>
</methods>

<methods>
<class-id>Swazoo.HTTPContentLengthField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString
	contentLength := aString asNumber.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPHostField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Host'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPHostField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: self hostName.
	portNumber notNil 
		ifTrue: 
			[aStream nextPut: $:.
			self portNumber printOn: aStream].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPHostField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">hostName
	^hostName</body>

<body package="Swazoo-Headers">portNumber
	^portNumber isNil ifTrue: [80] ifFalse: [portNumber]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPHostField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	| sourceStream portNumberString |
	sourceStream := ReadStream on: aString.
	hostName := sourceStream upTo: $:.
	portNumberString := sourceStream atEnd 
				ifTrue: [String new]
				ifFalse: [sourceStream upToEnd].
	portNumberString notEmpty 
		ifTrue: [portNumber := portNumberString asNumber].
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPAcceptField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Accept'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPAcceptField</class-id> <category>services</category>

<body package="Swazoo-Headers">combineWith: aHeaderField 
	"^self
I simply take my values and concatenate the values of aHeaderField."

	self mediaTypes addAll: aHeaderField mediaTypes.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAcceptField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">mediaTypes
	mediaTypes isNil ifTrue: [mediaTypes := OrderedCollection new].
	^mediaTypes</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAcceptField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: targetStream 
	self mediaTypes isEmpty 
		ifFalse: 
			[targetStream nextPutAll: self mediaTypes first.
			2 to: self mediaTypes size
				do: 
					[:methodIndex | 
					targetStream
						nextPut: $,;
						nextPutAll: (self mediaTypes at: methodIndex)]].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAcceptField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	mediaTypes := HTTPString subCollectionsFrom: aString delimitedBy: $,.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPConnectionField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Connection'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPConnectionField</class-id> <category>services</category>

<body package="Swazoo-Headers">setToClose
	self connectionToken: 'close'.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPConnectionField</class-id> <category>testing</category>

<body package="Swazoo-Headers">connectionTokenIsClose
	^self connectionToken = 'close'</body>
</methods>

<methods>
<class-id>Swazoo.HTTPConnectionField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">connectionToken
	"^a String
Common values are 'close' and 'keep-alive'."

	^connectionToken</body>

<body package="Swazoo-Headers">connectionToken: aString 
	"^self"

	connectionToken := aString.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPConnectionField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: connectionToken.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPConnectionField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	connectionToken := HTTPString trimBlanksFrom: aString.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPLocationField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Location'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPLocationField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	self uri printOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPLocationField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">uriString: aString 
	uri := SwazooURI fromString: aString.
	^self</body>

<body package="Swazoo-Headers">uri
	^uri</body>

<body package="Swazoo-Headers">uri: aSwazooURI 
	uri := aSwazooURI.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPCookieField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Cookie'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPETagField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'ETag'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPETagField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream
		nextPut: $";
		nextPutAll: self entityTag;
		nextPut: $".
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPETagField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">entityTag: aString 
	entityTag := aString.
	^self</body>

<body package="Swazoo-Headers">entityTag
	^entityTag</body>
</methods>


<methods>
<class-id>Swazoo.HTTPCacheControlField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Cache-Control'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPCacheControlField</class-id> <category>services</category>

<body package="Swazoo-Headers">setPublic
	"^self
I am being told that the entity in my message is a public one that can be cached on public caches, i.e. caches that can be drawn upon by many clients.  This is probably not what you want if the entity contains personal information!  c.f. &gt;&gt;setPrivate  Note that expicitly setting cache-control public actually loosens some other rules and means resources can be used by cached beyond their normal life."

	private := false.
	^self</body>

<body package="Swazoo-Headers">mustRevalidate
	"^a Boolean
 If an origin server wishes to force any HTTP/1.1 cache, no matter how it is configured, to validate every request, it SHOULD use the 'must- revalidate' cache-control directive (see section 14.9).
We'll make this always false for now. "

	^false</body>

<body package="Swazoo-Headers">setNotPublicOrPrivate
	"^self
I am being told that the entity in my message is not explicity public or private.  This is the default and means that public caches may retain copies of the resource, but should not be as relaxed about the rules as with an explicitly public resource. c.f &gt;&gt;setPublic &amp; &gt;&gt;setPrivate."

	private := nil.
	^self</body>

<body package="Swazoo-Headers">setPrivate
	"^self
I am being told that the entity in my message is a private one that can only be cached on private caches, i.e. caches that can be drawn upon a single clients.  An example of a private cache is the one *inside* your web browser.   This is probably what you want if the entity contains personal information."

	private := true.
	^self</body>

<body package="Swazoo-Headers">maxAge: anIntegerOrNil 
	"^self
I record the number of seconds for which the resource is 'fresh' and after which will expire and become 'stale' for caching purposes.  Setting this to nil means the max age is unspecified, and this is the default.  This directive takes presidence over any Expires header when a cache or client is handling an HTTP message."

	maxAge := anIntegerOrNil.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPCacheControlField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPut: Character space.
	self private notNil 
		ifTrue: 
			[self writePublicOrPrivateTo: aStream.
			self maxAge notNil ifTrue: [aStream nextPutAll: ', ']].
	self maxAge notNil ifTrue: [self writeMaxAgeTo: aStream].
	^self</body>

<body package="Swazoo-Headers">writePublicOrPrivateTo: aStream 
	"^self
I write the either the public or the private directive to aStream"

	self private 
		ifTrue: [aStream nextPutAll: 'private']
		ifFalse: [aStream nextPutAll: 'public'].
	^self</body>

<body package="Swazoo-Headers">writeMaxAgeTo: aStream 
	"^self
I write the maxAge directive to aStream"

	aStream nextPutAll: 'max-age='.
	self maxAge printOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPCacheControlField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">maxAge
	"^an Integer or nil
I return my max age which is either an integer number of seconds for which the entity can be considdered fresh, or nil, in which case other headers such as Expires can be used by a cache to determine the expiration time of the entity."

	^maxAge</body>

<body package="Swazoo-Headers">directives
	1 halt: 'now, form the directives string'</body>

<body package="Swazoo-Headers">directives: aString 
	1 halt: 'Please set the directives you want using my service methods'.
	^self</body>

<body package="Swazoo-Headers">private
	"^a Boolean or nil
There are three possible values for private.  Explicity true (the entity can only be cached in private caches), explicity false (this is a public entity and can be held in a shared/public cache perhaps even when stale) or nil (the default which means that the entity may be held in a public shared cache, but only until it goes stale)."

	^private</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfModifiedSinceField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'If-Modified-Since'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfModifiedSinceField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isCacheHitFor: anEntity 
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent.  So in my case, I'm looking to see that the entity has not changed since my date.
anEntity *must* respond to &gt;&gt;lastModified"

	^anEntity lastModified &lt;= self date</body>

<body package="Swazoo-Headers">isConditional
	^true</body>
</methods>

<methods>
<class-id>Swazoo.HTTPIfModifiedSinceField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">date
	^date</body>
</methods>

<methods>
<class-id>Swazoo.HTTPIfModifiedSinceField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	self date asRFC1123StringOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPIfModifiedSinceField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	date := SpTimestamp fromRFC1123String: aString.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.ContentTypeField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Content-Type'</body>
</methods>


<methods>
<class-id>Swazoo.ContentTypeField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isContentType
	^true</body>
</methods>

<methods>
<class-id>Swazoo.ContentTypeField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">mediaType
	^mediaType isNil ifTrue: [self defaultMediaType] ifFalse: [mediaType]</body>

<body package="Swazoo-Headers">mediaType: aString 
	mediaType := aString.
	^self</body>

<body package="Swazoo-Headers">defaultMediaType
	"^a String
See RFC 2616 '7.2.1 Type'.  If no media type is specified, application/octet-stream is the default."

	^'application/octet-stream'</body>

<body package="Swazoo-Headers">transferCodings
	transferCodings isNil ifTrue: [transferCodings := String new].
	^transferCodings</body>
</methods>

<methods>
<class-id>Swazoo.ContentTypeField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: self mediaType.
	self transferCodings isEmpty 
		ifFalse: 
			[aStream
				nextPut: Character space;
				nextPutAll: self transferCodings].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.ContentTypeField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	| sourceStream |
	sourceStream := aString readStream.
	mediaType := (HTTPString trimBlanksFrom: (sourceStream upTo: $;)).
	transferCodings := self readParametersFrom: sourceStream.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPDateField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Date'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPDateField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	self date asRFC1123StringOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPDateField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">date: aDate 
	"^self
Note that this is an HTTP Date, and so is really a timestamp :-/ "

	date := aDate.
	^self</body>

<body package="Swazoo-Headers">date
	^date</body>
</methods>


<methods>
<class-id>Swazoo.ContentDispositionField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Content-Disposition'</body>
</methods>


<methods>
<class-id>Swazoo.ContentDispositionField</class-id> <category>services</category>

<body package="Swazoo-Headers">parameterAt: aString 
	^parameters at: aString ifAbsent: [nil]</body>
</methods>

<methods>
<class-id>Swazoo.ContentDispositionField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isContentDisposition
	^true</body>
</methods>

<methods>
<class-id>Swazoo.ContentDispositionField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	| sourceStream |
	sourceStream := aString readStream.
	type := HTTPString trimBlanksFrom: (sourceStream upTo: $;).
	parameters := self readParametersFrom: sourceStream.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPWWWAuthenticateField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'WWW-Authenticate'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPWWWAuthenticateField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isBasic
	"^a Boolean
I return true if I represent a header for basic authentication. c.f. RFC 2617 sec 2."

	^false</body>

<body package="Swazoo-Headers">isDigest
	"^a Boolean
I return true if I represent a header for digest authentication. c.f. RFC 2617 sec 3."

	^false</body>
</methods>


<methods>
<class-id>Swazoo.HTTPWWWAuthenticateDigestField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isDigest
	"^a Boolean
I return true if I represent a header for digest authentication. c.f. RFC 2617 sec 3."

	^true</body>
</methods>


<methods>
<class-id>Swazoo.HTTPRefererField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Referer'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPRefererField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	self uri printOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRefererField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">uri
	^uri</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRefererField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	uri := SwazooURI fromString: aString.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPAuthorizationField class</class-id> <category>private</category>

<body package="Swazoo-Headers">newForFieldName: fieldNameString withValueFrom: fieldValueString 
	"^an HTTPAuthorizationField
I return an instance of one of my concrete subclasses.  To get to this point, the field name *must* be 'AUTHORIZATION'."

	| sourceStream schemeName |
	sourceStream := ReadStream on: fieldValueString.
	schemeName := sourceStream upTo: Character space.
	^schemeName = 'Basic' 
		ifTrue: [HTTPAuthorizationBasicField newWithValueFrom: sourceStream upToEnd]
		ifFalse: [HTTPAuthorizationDigestField newWithValueFrom: sourceStream upToEnd]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAuthorizationField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Authorization'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPAuthorizationField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: self credentials.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAuthorizationField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">credentials
	^credentials</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAuthorizationField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	credentials := HTTPString trimBlanksFrom: aString.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPAuthorizationBasicField</class-id> <category>services</category>

<body package="Swazoo-Headers">userid
	"^a String
I return the userid string (as defined in RFC 2617 pp.2) part of the user-pass value in my credentials."

	userid isNil ifTrue: [self resolveUserPass].
	^userid</body>

<body package="Swazoo-Headers">password
	"^a String
I return the password string (as defined in RFC 2617 pp.2) part of the user-pass value in my credentials."

	password isNil ifTrue: [self resolveUserPass].
	^password</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAuthorizationBasicField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: 'Basic '.
	super valuesAsStringOn: aStream.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAuthorizationBasicField</class-id> <category>private</category>

<body package="Swazoo-Headers">resolveUserPass
	"^self
I look at my credentials string and pull out the userid and password.  Note that having to check for atEnd before the upToEnd is for GemStone which crashes if upToEnd is used when already atEnd."

	"(Base64EncodingReadStream on: 'YnJ1Y2U6c3F1aWRzdXBwbGllZHBhc3N3b3Jk' ) upToEnd asString "

	| userPassString sourceStream |
	userPassString := HTTPString 
				stringFromBytes: (Base64EncodingReadStream on: self credentials) upToEnd.
	sourceStream := ReadStream on: userPassString.
	userid := sourceStream upTo: $:.
	password := sourceStream atEnd 
				ifTrue: [String new]
				ifFalse: [sourceStream upToEnd].
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPAuthorizationDigestField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: 'Digest '.
	super valuesAsStringOn: aStream.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPServerField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Server'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPServerField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: self productTokens.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServerField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">productTokens
	^productTokens</body>

<body package="Swazoo-Headers">productTokens: aString 
	productTokens := aString.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfRangeField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'If-Range'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPAllowField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Allow'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPAllowField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: targetStream 
	self methods isEmpty 
		ifFalse: 
			[targetStream nextPutAll: self methods first.
			2 to: self methods size
				do: 
					[:methodIndex | 
					targetStream
						nextPut: $,;
						nextPutAll: (self methods at: methodIndex)]].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPAllowField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">methods
	methods isNil ifTrue: [methods := OrderedCollection new].
	^methods</body>
</methods>


<methods>
<class-id>Swazoo.GenericHeaderField class</class-id> <category>instance creation</category>

<body package="Swazoo-Headers">newForFieldName: fieldNameString withValueFrom: fieldValueString 
	^self new forFieldName: fieldNameString andValue: fieldValueString</body>
</methods>


<methods>
<class-id>Swazoo.GenericHeaderField</class-id> <category>services</category>

<body package="Swazoo-Headers">combineWith: aHeaderField 
	"^self
I simply take my values and concatenate the values of aHeaderField."

	value := self value , ', ' , aHeaderField value.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.GenericHeaderField</class-id> <category>initialize-release</category>

<body package="Swazoo-Headers">forFieldName: fieldNameString andValue: fieldValueString 
	name := fieldNameString.
	value := fieldValueString.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.GenericHeaderField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">value
	^value</body>

<body package="Swazoo-Headers">values
	^(HTTPString subCollectionsFrom: self value delimitedBy: $,) 
		collect: [:each | HTTPString trimBlanksFrom: each]</body>

<body package="Swazoo-Headers">name
	^name</body>

<body package="Swazoo-Headers">fieldName
1 halt: 'use &gt;&gt;name instead'.
	^self name</body>
</methods>

<methods>
<class-id>Swazoo.GenericHeaderField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: value.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPMatchField</class-id> <category>services</category>

<body package="Swazoo-Headers">addEntityTag: aString 
	self entityTags add: aString.
	^self</body>

<body package="Swazoo-Headers">combineWith: aHeaderField 
	"^self
I add the entity tags of aHeaderField to my own collection of entity tags."

	self entityTags addAll: aHeaderField entityTags.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPMatchField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isConditional
	^true</body>

<body package="Swazoo-Headers">matchesAnyCurrentEntity
	^entityTags = '*'</body>
</methods>

<methods>
<class-id>Swazoo.HTTPMatchField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">entityTags
	^self matchesAnyCurrentEntity 
		ifTrue: [nil]
		ifFalse: 
			[entityTags isNil ifTrue: [entityTags := OrderedCollection new].
			entityTags]</body>
</methods>

<methods>
<class-id>Swazoo.HTTPMatchField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: targetStream 
	self write: self entityTags first asQuotedStringTo: targetStream.
	2 to: self entityTags size
		do: 
			[:tagIndex | 
			targetStream nextPut: $,.
			self write: (self entityTags at: tagIndex) asQuotedStringTo: targetStream].
	^self</body>

<body package="Swazoo-Headers">write: aString asQuotedStringTo: targetStream 
	"^self
See RFC 2616 2.2"

	targetStream nextPut: $".
	aString do: 
			[:character | 
			character == $" 
				ifTrue: [targetStream nextPutAll: '\"']
				ifFalse: [targetStream nextPut: character]].
	targetStream nextPut: $".
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPMatchField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	aString = '*' 
		ifTrue: [entityTags := aString]
		ifFalse: 
			[| sourceStream |
			entityTags := OrderedCollection new.
			sourceStream := ReadStream on: aString.
			[sourceStream atEnd] whileFalse: 
					[| entityTag |
					sourceStream upTo: $".
					entityTag := sourceStream upTo: $".
					entityTags add: entityTag.
					sourceStream upTo: $,]].
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfMatchField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'If-Match'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfMatchField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isCacheHitFor: anEntity 
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent. 
anEntity *must* respond to &gt;&gt;entutyTag"

	1 halt.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPWWWAuthenticateBasicField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isBasic
	"^a Boolean
I return true if I represent a header for basic authentication. c.f. RFC 2617 sec 2."

	^true</body>
</methods>

<methods>
<class-id>Swazoo.HTTPWWWAuthenticateBasicField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">realm
	"^a String
I return the realm for which I represent an autentication challenge.  This string will be presented to the browser user in the login dialog."

	^realm</body>

<body package="Swazoo-Headers">realm: anObject
	realm := anObject</body>
</methods>

<methods>
<class-id>Swazoo.HTTPWWWAuthenticateBasicField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream
		nextPutAll: 'Basic realm="';
		nextPutAll: self realm;
		nextPut: $".
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPUserAgentField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'User-Agent'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPUserAgentField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: productTokens.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPUserAgentField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">productTokens
	^productTokens</body>
</methods>

<methods>
<class-id>Swazoo.HTTPUserAgentField</class-id> <category>private</category>

<body package="Swazoo-Headers">parseValueFrom: aString 
	"^self
I could try and parse out the product name and version numbers, but there is no need to worry about this at the moment, so I just record the string."

	productTokens := HTTPString trimBlanksFrom: aString.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfUnmodifiedSinceField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'If-Unmodified-Since'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfUnmodifiedSinceField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isConditional
	^true</body>

<body package="Swazoo-Headers">isCacheHitFor: anEntity 
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent. 
anEntity *must* respond to &gt;&gt;entutyTag"

	1 halt.
	^self</body>
</methods>


<methods>
<class-id>Swazoo.HTTPSetCookieField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'Set-Cookie'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPSetCookieField</class-id> <category>services</category>

<body package="Swazoo-Headers">combineWith: aSetCookieField 
	"^self
I add the cookies of aSetCookieField to my own collection of cookies."

	self cookies addAll: aSetCookieField cookies.
	^self</body>

<body package="Swazoo-Headers">addCookie: aCookieString
	^self cookies add: aCookieString</body>
</methods>

<methods>
<class-id>Swazoo.HTTPSetCookieField</class-id> <category>printing</category>

<body package="Swazoo-Headers">valuesAsStringOn: aStream 
	aStream nextPutAll: (self cookies at: 1).
	2 to: self cookies size
		do: 
			[:cookieIndex | 
			aStream
				nextPutAll: ', ';
				nextPutAll: (self cookies at: cookieIndex)].
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPSetCookieField</class-id> <category>accessing</category>

<body package="Swazoo-Headers">cookies
	cookies isNil ifTrue: [cookies := OrderedCollection new].
	^cookies</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfNoneMatchField class</class-id> <category>accessing</category>

<body package="Swazoo-Headers">fieldName
	^'If-None-Match'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPIfNoneMatchField</class-id> <category>testing</category>

<body package="Swazoo-Headers">isCacheHitFor: anEntity 
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent.  So in my case, I'm looking to see that the entity has a tag which is in my collection of entityTags.
anEntity *must* respond to &gt;&gt;entityTag"

	^self entityTags includes: anEntity entityTag</body>
</methods>

<!-- Package Swazoo-Exceptions(1.1.1,janko)= -->


<class>
<name>SwazooHTTPParseError</name>
<environment>Swazoo</environment>
<super>SpError</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Exceptions</category>
<attributes>
<package>Swazoo-Exceptions</package>
</attributes>
</class>

<class>
<name>HTTPException</name>
<environment>Swazoo</environment>
<super>Core.Error</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>response </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Support</category>
<attributes>
<package>Swazoo-Exceptions</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.HTTPException</class-id>
<body>HTTPException immediatelly returns attached HTTP response to client. That way it is easier to respond with different status codes (like 201 Created). Not only error ones! You can respond somewhere deeply in code of your resource with raising that exception and adding a prepared HTTPResponse. 
This exception is non-resumable!

Example of ways to raise http response (200 Ok):

	HTTPException raiseResponse: (HTTPResponse new code: 200).
	HTTPException raiseResponseCode: 200.
	HTTPException ok.

Instance Variables:
	response	&lt;HTTPResponse&gt;	a response to be sent to client

</body>
</comment>

<class>
<name>SwazooSiteError</name>
<environment>Swazoo</environment>
<super>SpError</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Exceptions</category>
<attributes>
<package>Swazoo-Exceptions</package>
</attributes>
</class>

<class>
<name>SwazooHTTPRequestError</name>
<environment>Swazoo</environment>
<super>SpError</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Exceptions</category>
<attributes>
<package>Swazoo-Exceptions</package>
</attributes>
</class>

<class>
<name>SwazooHTTPPostError</name>
<environment>Swazoo</environment>
<super>Swazoo.SwazooHTTPRequestError</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Exceptions</category>
<attributes>
<package>Swazoo-Exceptions</package>
</attributes>
</class>

<class>
<name>SwazooHTTPPutError</name>
<environment>Swazoo</environment>
<super>Swazoo.SwazooHTTPRequestError</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Exceptions</category>
<attributes>
<package>Swazoo-Exceptions</package>
</attributes>
</class>

<class>
<name>SwazooHeaderFieldParseError</name>
<environment>Swazoo</environment>
<super>SpError</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Exceptions</category>
<attributes>
<package>Swazoo-Exceptions</package>
</attributes>
</class>








<methods>
<class-id>Swazoo.HTTPException class</class-id> <category>responses-client error</category>

<body package="Swazoo-Exceptions">methodNotAllowed
	^self raiseResponse: (HTTPResponse new code: 405)</body>

<body package="Swazoo-Exceptions">gone
	^self raiseResponse: (HTTPResponse new code: 410)</body>

<body package="Swazoo-Exceptions">requestTimeout
	^self raiseResponse: (HTTPResponse new code: 408)</body>

<body package="Swazoo-Exceptions">forbidden
	^self raiseResponse: (HTTPResponse new code: 403)</body>

<body package="Swazoo-Exceptions">badRequest
	^self raiseResponse: (HTTPResponse new code: 400)</body>

<body package="Swazoo-Exceptions">unathorized
	^self raiseResponse: (HTTPResponse new code: 401)</body>

<body package="Swazoo-Exceptions">unsupportedMediaType
	^self raiseResponse: (HTTPResponse new code: 415)</body>

<body package="Swazoo-Exceptions">notAcceptable
	^self raiseResponse: (HTTPResponse new code: 406)</body>

<body package="Swazoo-Exceptions">lengthRequired
	^self raiseResponse: (HTTPResponse new code: 411)</body>

<body package="Swazoo-Exceptions">paymentRequired
	^self raiseResponse: (HTTPResponse new code: 402)</body>

<body package="Swazoo-Exceptions">conflict
	^self raiseResponse: (HTTPResponse new code: 409)</body>

<body package="Swazoo-Exceptions">requestedRangeNotSatisfiable
	^self raiseResponse: (HTTPResponse new code: 416)</body>

<body package="Swazoo-Exceptions">preconditionFailed
	^self raiseResponse: (HTTPResponse new code: 412)</body>

<body package="Swazoo-Exceptions">notFound
	^self raiseResponse: (HTTPResponse new code: 404)</body>

<body package="Swazoo-Exceptions">expectationFailed
	^self raiseResponse: (HTTPResponse new code: 416)</body>

<body package="Swazoo-Exceptions">requestEntityTooLarge
	^self raiseResponse: (HTTPResponse new code: 413)</body>

<body package="Swazoo-Exceptions">requestURITooLong
	^self raiseResponse: (HTTPResponse new code: 414)</body>

<body package="Swazoo-Exceptions">proxyAuthenticationRequired
	^self raiseResponse: (HTTPResponse new code: 407)</body>
</methods>

<methods>
<class-id>Swazoo.HTTPException class</class-id> <category>responses-succesfull</category>

<body package="Swazoo-Exceptions">ok
	^self raiseResponse: HTTPResponse ok</body>

<body package="Swazoo-Exceptions">accepted
	^self raiseResponse: (HTTPResponse new code: 202)</body>

<body package="Swazoo-Exceptions">noContent
	^self raiseResponse: (HTTPResponse new code: 204)</body>

<body package="Swazoo-Exceptions">created
	^self raiseResponse: (HTTPResponse new code: 201)</body>

<body package="Swazoo-Exceptions">partialContent
	^self raiseResponse: (HTTPResponse new code: 206)</body>

<body package="Swazoo-Exceptions">nonAuthorativeInformation
	^self raiseResponse: (HTTPResponse new code: 203)</body>

<body package="Swazoo-Exceptions">resetContent
	^self raiseResponse: (HTTPResponse new code: 205)</body>
</methods>

<methods>
<class-id>Swazoo.HTTPException class</class-id> <category>responses-informational</category>

<body package="Swazoo-Exceptions">continue
	^self raiseResponse: (HTTPResponse new code: 100)</body>

<body package="Swazoo-Exceptions">switchingProtocols
	^self raiseResponse: (HTTPResponse new code: 101)</body>
</methods>

<methods>
<class-id>Swazoo.HTTPException class</class-id> <category>responses-server error</category>

<body package="Swazoo-Exceptions">internalServerError
	^self raiseResponse: (HTTPResponse new code: 500)</body>

<body package="Swazoo-Exceptions">notImplemented
	^self raiseResponse: (HTTPResponse new code: 501)</body>

<body package="Swazoo-Exceptions">httpVersionNotSupported
	^self raiseResponse: (HTTPResponse new code: 505)</body>

<body package="Swazoo-Exceptions">serviceUnavailable
	^self raiseResponse: (HTTPResponse new code: 503)</body>

<body package="Swazoo-Exceptions">badGateway
	^self raiseResponse: (HTTPResponse new code: 502)</body>

<body package="Swazoo-Exceptions">gatewayTimeout
	^self raiseResponse: (HTTPResponse new code: 504)</body>
</methods>

<methods>
<class-id>Swazoo.HTTPException class</class-id> <category>responses-redirection</category>

<body package="Swazoo-Exceptions">found
	^self raiseResponse: (HTTPResponse new code: 302)</body>

<body package="Swazoo-Exceptions">temporaryRedirect
	^self raiseResponse: (HTTPResponse new code: 307)</body>

<body package="Swazoo-Exceptions">seeOther
	^self raiseResponse: (HTTPResponse new code: 303)</body>

<body package="Swazoo-Exceptions">notModified
	^self raiseResponse: (HTTPResponse new code: 304)</body>

<body package="Swazoo-Exceptions">useProxy
	^self raiseResponse: (HTTPResponse new code: 305)</body>

<body package="Swazoo-Exceptions">movedPermanently
	^self raiseResponse: (HTTPResponse new code: 301)</body>

<body package="Swazoo-Exceptions">multipleChoices
	^self raiseResponse: (HTTPResponse new code: 300)</body>
</methods>

<methods>
<class-id>Swazoo.HTTPException class</class-id> <category>signalling</category>

<body package="Swazoo-Exceptions">raiseResponse: aHTTPResponse
	"Raise an exception to immediatelly return that response."
	^self new 
		response: aHTTPResponse;
		raiseSignal.</body>

<body package="Swazoo-Exceptions">raiseResponseCode: aNumber
	"Raise an exception to immediatelly return http response with that code"
	^self raiseResponse: (HTTPResponse new code: aNumber)</body>
</methods>


<methods>
<class-id>Swazoo.HTTPException</class-id> <category>accessing</category>

<body package="Swazoo-Exceptions">response
	^response</body>

<body package="Swazoo-Exceptions">response: aHTTPResponse
	response := aHTTPResponse</body>
</methods>

<!-- Package Swazoo-Resources(1.1.2,janko)= -->


<component-property>
<name>Swazoo-Resources</name> <type>package</type>
<property>comment</property> <value>'Swazoo Resource framework, concept of hierarchical Resources allows pluggable addition of new web resourcers like static page servers, wikis, dynamic web applications ...

* resources for static web serving, basic authentication and session support'</value>
</component-property>

<class>
<name>FileMappingResource</name>
<environment>Swazoo</environment>
<super>Swazoo.Resource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>directoryIndex filePath </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Resources</category>
<attributes>
<package>Swazoo-Resources</package>
</attributes>
</class>

<class>
<name>RedirectionResource</name>
<environment>Swazoo</environment>
<super>Swazoo.Resource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>targetUri </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Resources</category>
<attributes>
<package>Swazoo-Resources</package>
</attributes>
</class>

<class>
<name>SwazooCacheControl</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>request cacheTarget etag lastModified </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo</category>
<attributes>
<package>Swazoo-Resources</package>
</attributes>
</class>

<class>
<name>FileResource</name>
<environment>Swazoo</environment>
<super>Swazoo.FileMappingResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Resources</category>
<attributes>
<package>Swazoo-Resources</package>
</attributes>
</class>

<class>
<name>HomeResource</name>
<environment>Swazoo</environment>
<super>Swazoo.FileResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Resources</category>
<attributes>
<package>Swazoo-Resources</package>
</attributes>
</class>

<shared-variable>
<name>ContentTypes</name>
<environment>Swazoo.FileResource</environment>
<private>false</private>
<constant>false</constant>
<category>As yet unclassified</category>
<attributes>
<package>Swazoo-Resources</package>
</attributes>
</shared-variable>







<methods>
<class-id>Swazoo.FileMappingResource class</class-id> <category>instance creation</category>

<body package="Swazoo-Resources">uriPattern: aString filePath: aFilePath 
	^(self uriPattern: aString) filePath: aFilePath</body>

<body package="Swazoo-Resources">uriPattern: aString filePath: aFilePath directoryIndex: anotherString 
	^(self uriPattern: aString)
		filePath: aFilePath;
		directoryIndex: anotherString</body>
</methods>


<methods>
<class-id>Swazoo.FileMappingResource</class-id> <category>accessing</category>

<body package="Swazoo-Resources">filePath
	^filePath</body>

<body package="Swazoo-Resources">directoryIndex: aString 
	directoryIndex := aString</body>

<body package="Swazoo-Resources">filePath: aString 
	filePath := aString</body>

<body package="Swazoo-Resources">directoryIndex
	^directoryIndex</body>
</methods>

<methods>
<class-id>Swazoo.FileMappingResource</class-id> <category>serving</category>

<body package="Swazoo-Resources">answerTo: aRequest 
	(self checkExistence: aRequest) ifFalse: [^nil].
	(self checkURI: aRequest) 
		ifFalse: 
			[| response |
			response := HTTPResponse movedPermanently.
			response headers 
				addField: (HTTPLocationField new uriString: aRequest uri identifier , '/').
			^response].
	^self file: (self fileFor: aRequest) answerTo: aRequest</body>
</methods>

<methods>
<class-id>Swazoo.FileMappingResource</class-id> <category>private-initialize</category>

<body package="Swazoo-Resources">initialize
	super initialize.
	self directoryIndex: 'index.html'</body>
</methods>

<methods>
<class-id>Swazoo.FileMappingResource</class-id> <category>private</category>

<body package="Swazoo-Resources">fileDirectory
	^self filePath asFilename</body>

<body package="Swazoo-Resources">rootFileFor: aRequest 
	^aRequest tailPath inject: self fileDirectory
		into: 
			[:subPath :each | 
			(#('.' '..') includes: (HTTPString trimBlanksFrom: each)) 
				ifTrue: [subPath]
				ifFalse: [subPath construct: each]]</body>

<body package="Swazoo-Resources">fileFor: aRequest 
	| fn |
	fn := self rootFileFor: aRequest.
	fn isDirectory ifTrue: [fn := fn construct: self directoryIndex].
	^fn</body>

<body package="Swazoo-Resources">checkURI: aRequest 
	| needsFinalSlash |
	needsFinalSlash := (self rootFileFor: aRequest) isDirectory 
				and: [aRequest uri isDirectory not].
	^needsFinalSlash not</body>

<body package="Swazoo-Resources">checkExistence: aRequest 
	(self rootFileFor: aRequest) exists ifFalse: [^false].
	^(self fileFor: aRequest) exists</body>

<body package="Swazoo-Resources">file: aFilename answerTo: aRequest 
	^self subclassResponsibility</body>
</methods>


<methods>
<class-id>Swazoo.RedirectionResource class</class-id> <category>instance creation</category>

<body package="Swazoo-Resources">uriPattern: aString targetUri: bString 
	^(self uriPattern: aString) targetUri: bString</body>
</methods>


<methods>
<class-id>Swazoo.RedirectionResource</class-id> <category>private-initialize</category>

<body package="Swazoo-Resources">targetUri
	^targetUri</body>

<body package="Swazoo-Resources">targetUri: aString 
	targetUri := aString</body>
</methods>

<methods>
<class-id>Swazoo.RedirectionResource</class-id> <category>serving</category>

<body package="Swazoo-Resources">answerTo: aRequest 
	| answer |
	answer := HTTPResponse movedPermanently.
	answer headers addField: (HTTPLocationField new uriString: self targetUri).
	^answer</body>
</methods>


<methods>
<class-id>Swazoo.SwazooCacheControl</class-id> <category>testing</category>

<body package="Swazoo-Resources">lastModified
	lastModified isNil ifTrue: [lastModified := self generateLastModified].
	^lastModified</body>

<body package="Swazoo-Resources">isNotModified
	"Compare the cacheTarget with the request headers and answer if the client's version is not modified.
	Takes into account http version, and uses best practices defined by HTTP spec"

	^self isIfNoneMatch not or: [self isIfModifiedSince not]</body>

<body package="Swazoo-Resources">isRequestStrongValidator
	| field |
	field := request headers fieldOfClass: HTTPIfNoneMatchField ifNone: [nil].
	^field notNil and: [field entityTags isEmpty not]</body>

<body package="Swazoo-Resources">lastModified: aRFC1123TimeStampString 
	lastModified := aRFC1123TimeStampString</body>

<body package="Swazoo-Resources">isIfModifiedSince
	"Answers true if either 
		- the request does not included the header
		-or there is not a match"

	| ifModifiedSince |
	ifModifiedSince := request headers fieldOfClass: HTTPIfModifiedSinceField
				ifNone: [nil].
	^ifModifiedSince isNil or: [self lastModified &gt; ifModifiedSince date]</body>

<body package="Swazoo-Resources">isIfNoneMatch
	"Answers true if either 
		- the request does not included the header
		-or there is not a match"

	| field |
	field := request headers fieldOfClass: HTTPIfNoneMatchField ifNone: [nil].
	^field isNil or: [(field entityTags includes: self etag) not]</body>
</methods>

<methods>
<class-id>Swazoo.SwazooCacheControl</class-id> <category>accessing</category>

<body package="Swazoo-Resources">cacheTarget
	^cacheTarget</body>

<body package="Swazoo-Resources">request: aHTTPGet cacheTarget: anObject 
	request := aHTTPGet.
	cacheTarget := anObject</body>

<body package="Swazoo-Resources">etag
	etag isNil ifTrue: [etag := self generateETag].
	^etag</body>

<body package="Swazoo-Resources">etag: aString 
	etag := aString</body>
</methods>

<methods>
<class-id>Swazoo.SwazooCacheControl</class-id> <category>operations</category>

<body package="Swazoo-Resources">generateLastModified
	^self cacheTarget lastModified</body>

<body package="Swazoo-Resources">generateETag
	^self cacheTarget etag</body>

<body package="Swazoo-Resources">addResponseHeaders: aResponse 
	"Add response headers to the response.
	We MUST differentiate between 200/302 responses"

	^aResponse isNotModified 
		ifTrue: [self addNotModifedHeaders: aResponse]
		ifFalse: [self basicAddResponseHeaders: aResponse]</body>

<body package="Swazoo-Resources">addNotModifedHeaders: aResponse 
	"RFC2616 10.3.5
	If the conditional GET used a strong cache validator (see section 13.3.3), the response SHOULD NOT include other entity-headers. ... this prevents inconsistencies between cached entity-bodies and updated headers. "

	self isRequestStrongValidator 
		ifTrue: [aResponse headers addField: (HTTPETagField new entityTag: self etag)]
		ifFalse: [self basicAddResponseHeaders: aResponse].
	^aResponse</body>

<body package="Swazoo-Resources">basicAddResponseHeaders: aResponse 
	"RFC 2616 13.3.4
	HTTP/1.1 origin servers: 
      	- SHOULD send an entity tag validator unless it is not feasible to generate one.
		- SHOULD send a Last-Modified value "

	aResponse headers addField: (HTTPETagField new entityTag: self etag).
	aResponse headers addField: (HTTPLastModifiedField new date: self lastModified).
	^aResponse</body>
</methods>


<methods>
<class-id>Swazoo.FileResource class</class-id> <category>class initialization</category>

<body package="Swazoo-Resources">initialize
	"self initialize"

	ContentTypes := (Dictionary new)
				add: '.txt' -&gt; 'text/plain';
				add: '.html' -&gt; 'text/html';
				add: '.htm' -&gt; 'text/html';
				add: '.css' -&gt; 'text/css';
				add: '.png' -&gt; 'image/png';
				add: '.gif' -&gt; 'image/gif';
				add: '.jpg' -&gt; 'image/jpeg';
				add: '.m3u' -&gt; 'audio/mpegurl';
				add: '.ico' -&gt; 'image/x-icon';
				add: '.pdf' -&gt; 'application/pdf';
				yourself</body>
</methods>


<methods>
<class-id>Swazoo.FileResource</class-id> <category>private</category>

<body package="Swazoo-Resources">file: aFilename answerTo: aRequest 
	| cacheControl response |
	cacheControl := SwazooCacheControl new request: aRequest
				cacheTarget: aFilename.
	response := cacheControl isNotModified 
				ifTrue: [HTTPResponse notModified]
				ifFalse: 
					[FileResponse ok entity: ((MimeObject new)
								value: aFilename;
								contentType: (self contentTypeFor: aFilename extension))].
	cacheControl addResponseHeaders: response.
	^response</body>

<body package="Swazoo-Resources">contentTypeFor: aString 
	^ContentTypes at: aString ifAbsent: ['application/octet-stream']</body>
</methods>


<methods>
<class-id>Swazoo.HomeResource</class-id> <category>private</category>

<body package="Swazoo-Resources">validateHomePath: aString 
	^aString first = $~</body>

<body package="Swazoo-Resources">rootFileFor: aRequest 
	| homeKey file |
	homeKey := aRequest tailPath first copyFrom: 2
				to: aRequest tailPath first size.
	file := (self fileDirectory construct: homeKey) construct: 'html'.
	(aRequest tailPath copyFrom: 2 to: aRequest tailPath size) 
		do: [:each | each = '..' ifFalse: [file := file construct: each]].
	^file</body>
</methods>

<methods>
<class-id>Swazoo.HomeResource</class-id> <category>accessing</category>

<body package="Swazoo-Resources">answerTo: aRequest 
	aRequest tailPath isEmpty ifTrue: [^nil].
	(self validateHomePath: aRequest tailPath first) ifFalse: [^nil].
	^super answerTo: aRequest</body>
</methods>



<initialize>
<class-id>Swazoo.FileResource</class-id>
</initialize><!-- Package Swazoo-Examples(1.1.1,janko)= -->


<class>
<name>AuthorizationResource</name>
<environment>Swazoo</environment>
<super>Swazoo.CompositeResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>targetUri </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Authorization</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>GoodbyeCruelWorld</name>
<environment>Swazoo</environment>
<super>Swazoo.Resource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Resources</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>ACLResource</name>
<environment>Swazoo</environment>
<super>Swazoo.AuthorizationResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>users </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Authorization</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>SwazooActivePageResource</name>
<environment>Swazoo</environment>
<super>Swazoo.FileMappingResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>file request ws </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-ActivePages</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>HelloWorldResource</name>
<environment>Swazoo</environment>
<super>Swazoo.Resource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Resources</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>SwazooActivePage</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>file request ws </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-ActivePages</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.SwazooActivePage</class-id>
<body>Example resources and other nonfinished stuff</body>
</comment>

<class>
<name>CookieSessionResource</name>
<environment>Swazoo</environment>
<super>Swazoo.CompositeResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>sessions expirationProcess lock </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Sessions</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>MozillaSidebarResource</name>
<environment>Swazoo</environment>
<super>Swazoo.Resource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Resources</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>ExampleSidebarResource</name>
<environment>Swazoo</environment>
<super>Swazoo.MozillaSidebarResource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Resources</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>SwazooSession</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>timestamp id values </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Sessions</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>

<class>
<name>SessionTestResource</name>
<environment>Swazoo</environment>
<super>Swazoo.Resource</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Sessions</category>
<attributes>
<package>Swazoo-Examples</package>
</attributes>
</class>












<methods>
<class-id>Swazoo.AuthorizationResource class</class-id> <category>instance creation</category>

<body package="Swazoo-Examples">uriPattern: aString targetUri: anotherString 
	^(self uriPattern: aString) setTargetUri: anotherString</body>
</methods>


<methods>
<class-id>Swazoo.AuthorizationResource</class-id> <category>private-initialize</category>

<body package="Swazoo-Examples">setTargetUri: aString 
	self targetUri: aString</body>
</methods>

<methods>
<class-id>Swazoo.AuthorizationResource</class-id> <category>serving</category>

<body package="Swazoo-Examples">answerTo: aRequest 
	aRequest tailPath isEmpty ifFalse: [^nil].
	^(self requestIsLogin: aRequest) 
		ifTrue: 
			[(self authorizeLogin: aRequest) 
				ifTrue: [self redirectionResponse]
				ifFalse: [self loginIncorrectResponse]]
		ifFalse: [self loginResponse]</body>
</methods>

<methods>
<class-id>Swazoo.AuthorizationResource</class-id> <category>private-accessing</category>

<body package="Swazoo-Examples">passwordForLogin: aString 
	^self subclassResponsibility</body>

<body package="Swazoo-Examples">authorizedLogins
	^self subclassResponsibility</body>

<body package="Swazoo-Examples">targetUri
	^targetUri</body>

<body package="Swazoo-Examples">targetUri: aString
	targetUri := aString</body>
</methods>

<methods>
<class-id>Swazoo.AuthorizationResource</class-id> <category>accessing</category>

<body package="Swazoo-Examples">helpResolve: aResolution 
	(aResolution atEnd 
		or: [self authorizeSession: aResolution request session]) ifFalse: [^nil].
	^super helpResolve: aResolution</body>
</methods>

<methods>
<class-id>Swazoo.AuthorizationResource</class-id> <category>private</category>

<body package="Swazoo-Examples">loginResponse
	| response ws |
	response := HTTPResponse ok.
	ws := WriteStream on: String new.
	ws
		nextPutAll: '&lt;HTML&gt;';
		cr;
		nextPutAll: '&lt;HEAD&gt;&lt;TITLE&gt;Login Required&lt;/TITLE&gt;&lt;/HEAD&gt;';
		cr;
		nextPutAll: '&lt;BODY bgcolor="#ffffff"&gt;';
		cr;
		nextPutAll: '&lt;H2&gt;Login Required&lt;/H2&gt;';
		cr;
		nextPutAll: '&lt;P&gt;You must enter a valid login and password before accessing resources beyond this point.&lt;/P&gt;';
		cr;
		nextPutAll: '&lt;FORM method="POST"&gt;';
		cr;
		nextPutAll: '&lt;INPUT type="hidden" name="swazooCommand" value="login"&gt;';
		cr;
		nextPutAll: '&lt;TABLE&gt;';
		cr;
		nextPutAll: '&lt;TR&gt;&lt;TD&gt;Login: &lt;/TD&gt;&lt;TD&gt;&lt;INPUT type="text" name="login"&gt;&lt;/TD&gt;&lt;/TR&gt;';
		cr;
		nextPutAll: '&lt;TR&gt;&lt;TD&gt;Password: &lt;/TD&gt;&lt;TD&gt;&lt;INPUT type="password" name="password"&gt;&lt;/TD&gt;&lt;/TR&gt;';
		cr;
		nextPutAll: '&lt;/TABLE&gt;';
		cr;
		nextPutAll: '&lt;INPUT type="submit" value="Login"&gt;';
		cr;
		nextPutAll: '&lt;/FORM&gt;';
		cr;
		nextPutAll: '&lt;/BODY&gt;';
		cr;
		nextPutAll: '&lt;/HTML&gt;'.
	response entity: ws contents.
	^response</body>

<body package="Swazoo-Examples">authorizeSession: aSession 
	| login |
	login := aSession at: #authorizedLogin.
	^login isNil not and: [self authorizedLogins includes: login]</body>

<body package="Swazoo-Examples">authorizeLogin: aRequest 
	| login password authorized |
	login := (aRequest postDataAt: 'login' ifAbsent: [^false]) value.
	password := (aRequest postDataAt: 'password' ifAbsent: [^false]) value.
	authorized := (self authorizedLogins includes: login) 
				and: [(self passwordForLogin: login) = password].
	authorized ifTrue: [aRequest session at: #authorizedLogin put: login].
	^authorized</body>

<body package="Swazoo-Examples">requestIsLogin: aRequest 
	aRequest isPost ifFalse: [^false].
	aRequest postDataAt: 'swazooCommand'
		do: [:datum | datum value = 'login' ifTrue: [^true]].
	^false</body>

<body package="Swazoo-Examples">loginIncorrectResponse
	| response ws |
	response := HTTPResponse ok.
	ws := WriteStream on: String new.
	ws
		nextPutAll: '&lt;HTML&gt;';
		cr;
		nextPutAll: '&lt;HEAD&gt;&lt;TITLE&gt;Login Incorrect&lt;/TITLE&gt;&lt;/HEAD&gt;';
		cr;
		nextPutAll: '&lt;BODY bgcolor="#ffffff"&gt;';
		cr;
		nextPutAll: '&lt;H2&gt;Login Incorrect&lt;/H2&gt;';
		cr;
		nextPutAll: '&lt;P&gt;Login incorrect.  Please go back and try again.&lt;/P&gt;';
		cr;
		nextPutAll: '&lt;/BODY&gt;';
		cr;
		nextPutAll: '&lt;/HTML&gt;'.
	response entity: ws contents.
	^response</body>

<body package="Swazoo-Examples">redirectionResponse
	^(HTTPResponse found)
		addHeaderName: 'Location' value: self targetUri;
		yourself</body>
</methods>


<methods>
<class-id>Swazoo.SwazooActivePageResource</class-id> <category>private</category>

<body package="Swazoo-Examples">shouldInterpret: aFilename 
	^aFilename extension = '.sap'</body>
</methods>

<methods>
<class-id>Swazoo.SwazooActivePageResource</class-id> <category>accessing</category>

<body package="Swazoo-Examples">file: aFilename answerTo: aRequest 
	| page |
	(self shouldInterpret: aFilename) ifFalse: [^nil].
	page := SwazooActivePage file: aFilename request: aRequest.
	^(HTTPResponse ok)
		contentType: 'text/html';
		entity: page asHTML</body>
</methods>


<methods>
<class-id>Swazoo.MozillaSidebarResource</class-id> <category>serving</category>

<body package="Swazoo-Examples">answerTo: aRequest 
	aRequest tailPath isEmpty ifFalse: [^nil].
	^(aRequest includesQuery: 'contents') 
		ifTrue: [self sidebarResponseTo: aRequest]
		ifFalse: [self installationResponseTo: aRequest]</body>
</methods>

<methods>
<class-id>Swazoo.MozillaSidebarResource</class-id> <category>private-accessing</category>

<body package="Swazoo-Examples">title
	^self subclassResponsibility</body>
</methods>

<methods>
<class-id>Swazoo.MozillaSidebarResource</class-id> <category>private</category>

<body package="Swazoo-Examples">sidebarResponseTo: aRequest 
	^self subclassResponsibility</body>

<body package="Swazoo-Examples">installationResponseTo: aRequest 
	| ws |
	ws := WriteStream on: String new.
	ws
		nextPutAll: '&lt;HTML&gt;
&lt;SCRIPT LANGUAGE="JavaScript"&gt;
&lt;!--
   function focus() {
   document.forms[0].school_code.focus()
   }

   function addNetscapePanel() {
      if ((typeof window.sidebar == "object") &amp;&amp; (typeof window.sidebar.addPanel == "function"))
      {
         window.sidebar.addPanel ("';
		nextPutAll: self title;
		nextPutAll: '", "';
		nextPutAll: aRequest urlString;
		nextPutAll: '?contents","");
         window.history.back();
      }
      else
      {
         var rv = window.confirm ("This page is only meaningful for users of Netscape 6." + "Would you like to learn more?");
         if (rv)
            document.location.href = "http://home.netscape.com";
      }
   }
//--&gt;
&lt;/SCRIPT&gt;
&lt;BODY onLoad=''addNetscapePanel()''&gt;
&lt;/HTML&gt;'.
	^HTTPResponse ok entity: ws contents</body>
</methods>


<methods>
<class-id>Swazoo.SessionTestResource</class-id> <category>private</category>

<body package="Swazoo-Examples">responseToPost: aRequest 
	aRequest postDataAt: 'name'
		do: [:datum | aRequest session at: #name put: datum value].
	^self responseToGet: aRequest</body>

<body package="Swazoo-Examples">responseToGet: aRequest 
	| ws name |
	ws := WriteStream on: String new.
	ws
		nextPutAll: '&lt;HTML&gt;&lt;HEAD&gt;&lt;TITLE&gt;Test Of Sessions&lt;/TITLE&gt;&lt;/HEAD&gt;&lt;BODY&gt;';
		cr.
	name := aRequest session at: #name.
	name isNil 
		ifFalse: 
			[ws
				nextPutAll: '&lt;P&gt;Welcome back, ';
				nextPutAll: name;
				nextPutAll: '.&lt;/P&gt;';
				cr].
	ws
		nextPutAll: '&lt;P&gt;What is your name?&lt;/P&gt;';
		nextPutAll: '&lt;FORM method="POST"&gt;&lt;INPUT name="name" type="text"&gt;&lt;INPUT type="submit"&gt;&lt;/FORM&gt;';
		cr.
	ws nextPutAll: '&lt;/BODY&gt;&lt;/HTML&gt;'.
	^ws contents</body>
</methods>

<methods>
<class-id>Swazoo.SessionTestResource</class-id> <category>serving</category>

<body package="Swazoo-Examples">answerTo: aRequest
	^HTTPResponse ok entity: (aRequest isGet 
				ifTrue: [self responseToGet: aRequest]
				ifFalse: [self responseToPost: aRequest])</body>
</methods>


<methods>
<class-id>Swazoo.ACLResource class</class-id> <category>instance creation</category>

<body package="Swazoo-Examples">uriPattern: aString targetUri: anotherString listFile: aFilePath 
	| rs inst |
	rs := aFilePath asFilename readStream.
	inst := self uriPattern: aString targetUri: anotherString.
	[inst readUsersFrom: rs] ensure: [rs close].
	^inst</body>
</methods>


<methods>
<class-id>Swazoo.ACLResource</class-id> <category>accessing</category>

<body package="Swazoo-Examples">users: aDictionary
	users := aDictionary</body>
</methods>

<methods>
<class-id>Swazoo.ACLResource</class-id> <category>private-accessing</category>

<body package="Swazoo-Examples">authorizedLogins
	^self users keys</body>

<body package="Swazoo-Examples">users
	users isNil ifTrue: [self initUsers].
	^users</body>

<body package="Swazoo-Examples">passwordForLogin: aString 
	^self users at: aString</body>
</methods>

<methods>
<class-id>Swazoo.ACLResource</class-id> <category>private-initialize</category>

<body package="Swazoo-Examples">readUsersFrom: aStream 
	| pair |
	self initUsers.
	[aStream atEnd] whileFalse: 
			[pair := (aStream upTo: Character cr) tokensBasedOn: $,.
			self users at: pair first put: pair last]</body>

<body package="Swazoo-Examples">initUsers
	self users: Dictionary new</body>

<body package="Swazoo-Examples">setUsers: aDictionary 
	self users: aDictionary</body>
</methods>


<methods>
<class-id>Swazoo.SwazooSession class</class-id> <category>instance creation</category>

<body package="Swazoo-Examples">new
	^super new initialize</body>
</methods>


<methods>
<class-id>Swazoo.SwazooSession</class-id> <category>private-initialize</category>

<body package="Swazoo-Examples">values
	^values</body>

<body package="Swazoo-Examples">initialize
	self initValues.
	self touch</body>

<body package="Swazoo-Examples">setTimestamp
	timestamp := SpTimestamp now</body>

<body package="Swazoo-Examples">initValues
	values := Dictionary new</body>
</methods>

<methods>
<class-id>Swazoo.SwazooSession</class-id> <category>accessing</category>

<body package="Swazoo-Examples">timestamp
	^timestamp</body>

<body package="Swazoo-Examples">removeKey: aKey 
	self values removeKey: aKey ifAbsent: []</body>

<body package="Swazoo-Examples">includesKey: aKey 
	^self values includesKey: aKey</body>

<body package="Swazoo-Examples">at: anObject 
	^self at: anObject ifAbsent: [nil]</body>

<body package="Swazoo-Examples">at: aKey put: anObject 
	self values at: aKey put: anObject</body>

<body package="Swazoo-Examples">at: anObject ifAbsentPut: aBlock 
	(self values includesKey: anObject) 
		ifFalse: [self values at: anObject put: aBlock value].
	^self values at: anObject</body>

<body package="Swazoo-Examples">id
	^id</body>

<body package="Swazoo-Examples">at: anObject ifAbsent: aBlock 
	^self values at: anObject ifAbsent: aBlock</body>

<body package="Swazoo-Examples">touch
	self setTimestamp</body>

<body package="Swazoo-Examples">id: anObject
	id := anObject</body>
</methods>


<methods>
<class-id>Swazoo.GoodbyeCruelWorld</class-id> <category>serving</category>

<body package="Swazoo-Examples">answerTo: aRequest
	| response |
	response := HTTPResponse notFound.
	response 
		entity: '&lt;html&gt;&lt;head&gt;&lt;title&gt;Goodbye&lt;/title&gt;&lt;/head&gt;&lt;body&gt;I am not really here.&lt;/body&gt;&lt;/html&gt;'.
	^response</body>
</methods>


<methods>
<class-id>Swazoo.ExampleSidebarResource</class-id> <category>private-accessing</category>

<body package="Swazoo-Examples">title
	^'Swazoo Sites'</body>
</methods>

<methods>
<class-id>Swazoo.ExampleSidebarResource</class-id> <category>private</category>

<body package="Swazoo-Examples">sidebarResponseTo: aRequest 
	^HTTPResponse ok 
		entity: '
&lt;HTML&gt;
&lt;HEAD&gt;
 &lt;TITLE&gt;Swazoo Sites&lt;/TITLE&gt;
&lt;/HEAD&gt;
&lt;BODY bgcolor="#ffffff"&gt;
&lt;B&gt;The following sites are running on Swazoo:&lt;/B&gt;
&lt;UL&gt;
 &lt;LI&gt;&lt;A target=''_content'' href="http://www.eranova.si"&gt;Eranova&lt;/A&gt;&lt;/LI&gt;
 &lt;LI&gt;&lt;A target=''_content'' href="http://www.reasonability.net"&gt;Reasonability&lt;/A&gt;&lt;/LI&gt;
 &lt;LI&gt;&lt;A target=''_content'' href="http://www.signalground.com"&gt;Signal Ground&lt;/A&gt;&lt;/LI&gt;
 &lt;LI&gt;&lt;A target=''_content'' href="http://www.swazoo.org"&gt;swazoo.org&lt;/A&gt; (soon!)&lt;/LI&gt;
&lt;/UL&gt;
&lt;/BODY&gt;
&lt;/HTML&gt;'</body>
</methods>


<methods>
<class-id>Swazoo.HelloWorldResource</class-id> <category>serving</category>

<body package="Swazoo-Examples">answerTo: aRequest 
	| response |
	response := HTTPResponse ok.
	response
		contentType: 'text/html';
		entity: '&lt;html&gt;&lt;head&gt;&lt;title&gt;Hello World&lt;/title&gt;&lt;/head&gt;&lt;body&gt;Hello World!&lt;/body&gt;&lt;/html&gt;'.
	^response</body>
</methods>


<methods>
<class-id>Swazoo.SwazooActivePage class</class-id> <category>instance creation</category>

<body package="Swazoo-Examples">new
	^super new initialize</body>

<body package="Swazoo-Examples">file: aFilename request: aRequest 
	^(self new)
		file: aFilename;
		request: aRequest</body>
</methods>


<methods>
<class-id>Swazoo.SwazooActivePage</class-id> <category>converting</category>

<body package="Swazoo-Examples">asHTML
	| rs |
	rs := self file readStream.
	^[self invokeMethodFrom: rs] ensure: [rs close]</body>
</methods>

<methods>
<class-id>Swazoo.SwazooActivePage</class-id> <category>accessing</category>

<body package="Swazoo-Examples">file
	^file</body>

<body package="Swazoo-Examples">request: anObject
	request := anObject</body>

<body package="Swazoo-Examples">file: anObject
	file := anObject</body>

<body package="Swazoo-Examples">request
	^request</body>
</methods>

<methods>
<class-id>Swazoo.SwazooActivePage</class-id> <category>private-initialize</category>

<body package="Swazoo-Examples">initialize
	ws := WriteStream on: String new</body>
</methods>

<methods>
<class-id>Swazoo.SwazooActivePage</class-id> <category>private</category>

<body package="Swazoo-Examples">invokeMethodFrom: aStream 
	^SwazooCompiler evaluate: (self methodBodyFrom: aStream) receiver: self</body>

<body package="Swazoo-Examples">methodBodyFrom: aStream 
	| bodyStream |
	bodyStream := WriteStream on: String new.
	[aStream atEnd] whileFalse: 
			[(aStream peekFor: $&lt;) 
				ifTrue: 
					[(aStream peekFor: $?) 
						ifTrue: 
							[bodyStream nextPutAll: (aStream upToAll: '?&gt;') trimBlanks.
							aStream atEnd ifFalse: [aStream skip: 2]]
						ifFalse: 
							[bodyStream
								space;
								nextPutAll: 'ws nextPut: $&lt;; nextPutAll: ';
								print: (aStream upToAll: '&lt;?');
								nextPutAll: '. ']]
				ifFalse: 
					[bodyStream
						space;
						nextPutAll: 'ws nextPutAll: ';
						print: (aStream upToAll: '&lt;?');
						nextPutAll: '. ']].
	bodyStream
		cr;
		nextPutAll: '^ws contents'.
	^bodyStream contents</body>
</methods>


<methods>
<class-id>Swazoo.CookieSessionResource</class-id> <category>private-expiration</category>

<body package="Swazoo-Examples">secondsBeforeExpiration
	^1800	"30 minutes"</body>

<body package="Swazoo-Examples">stopExpirationProcess
	| mightBeMe |
	self expirationProcess isNil ifTrue: [^self].
	mightBeMe := self expirationProcess.
	self expirationProcess: nil.
	mightBeMe terminate</body>

<body package="Swazoo-Examples">startExpirationProcess
	| expired nowTime |
	self expirationProcess: 
			[
			[(Delay forSeconds: 60) wait.
			expired := OrderedCollection new.
			self lock critical: 
					[nowTime := Timestamp now asSeconds.
					self sessions do: 
							[:each | 
							each timestamp asSeconds + self secondsBeforeExpiration &lt; nowTime 
								ifTrue: [expired add: each]].
					expired do: [:each | self forget: each]]] 
					repeat] 
					fork</body>

<body package="Swazoo-Examples">nudgeExpirationProcess
	self expirationProcess isNil ifTrue: [self startExpirationProcess]</body>
</methods>

<methods>
<class-id>Swazoo.CookieSessionResource</class-id> <category>accessing</category>

<body package="Swazoo-Examples">helpResolve: aResolution 
	^aResolution request hasCookie 
		ifTrue: [self existingSessionResolutionTo: aResolution]
		ifFalse: [self newSessionResolutionTo: aResolution]</body>
</methods>

<methods>
<class-id>Swazoo.CookieSessionResource</class-id> <category>private-initialize</category>

<body package="Swazoo-Examples">initLock
	lock := RecursionLock new</body>

<body package="Swazoo-Examples">initSessions
	sessions := Dictionary new</body>

<body package="Swazoo-Examples">initialize
	super initialize.
	self initSessions.
	self initLock</body>
</methods>

<methods>
<class-id>Swazoo.CookieSessionResource</class-id> <category>private</category>

<body package="Swazoo-Examples">setCookieFor: aSession in: aResponse path: aResourcePath 
	| ws |
	ws := WriteStream on: String new.
	ws
		nextPutAll: 'session=';
		nextPutAll: aSession id;
		nextPutAll: '; path=/'.
	aResourcePath size &gt; 1 
		ifTrue: 
			[(aResourcePath copyFrom: 2 to: aResourcePath size) do: 
					[:each | 
					ws
						nextPutAll: each;
						nextPut: $/]].
	aResponse addHeaderName: 'Set-Cookie' value: ws contents</body>

<body package="Swazoo-Examples">lock
	lock isNil ifTrue: [self initLock].
	^lock</body>

<body package="Swazoo-Examples">expirationProcess: aProcess
	expirationProcess := aProcess</body>

<body package="Swazoo-Examples">lookupSessionIn: aRequest 
	| rs |
	rs := ReadStream on: aRequest cookie.
	rs upTo: $=.
	^self lock critical: [self sessions at: (rs upTo: $;) ifAbsent: [nil]]</body>

<body package="Swazoo-Examples">remember: aSession 
	self lock critical: 
			[self sessions at: aSession id put: aSession.
			self nudgeExpirationProcess]</body>

<body package="Swazoo-Examples">existingSessionResolutionTo: aResolution 
	| session response request |
	request := aResolution request.
	session := self lookupSessionIn: request.
	^session isNil 
		ifTrue: [self newSessionResolutionTo: aResolution]
		ifFalse: 
			[request session: session.
			response := super helpResolve: aResolution.
			response isNil ifTrue: [request session: nil] ifFalse: [session touch].
			response]</body>

<body package="Swazoo-Examples">newSession
	| session id |
	session := SwazooSession new.
	self lock critical: 
			[
			[id := HTTPString newRandomString: 25.
			self sessions includesKey: id] whileTrue.
			session id: id.
			self remember: session].
	^session</body>

<body package="Swazoo-Examples">expirationProcess
	^expirationProcess</body>

<body package="Swazoo-Examples">forget: session 
	self lock critical: 
			[self sessions removeKey: session id.
			self sessions isEmpty ifTrue: [self stopExpirationProcess]]</body>

<body package="Swazoo-Examples">newSessionResolutionTo: aResolution 
	| session response request myPath |
	session := self newSession.
	request := aResolution request.
	request session: session.
	myPath := aResolution currentPath.
	response := super helpResolve: aResolution.
	response isNil 
		ifTrue: 
			[request session: nil.
			self forget: session]
		ifFalse: 
			[self 
				setCookieFor: session
				in: response
				path: myPath].
	^response</body>

<body package="Swazoo-Examples">sessions
	sessions isNil ifTrue: [self initSessions].
	^sessions</body>
</methods>

<!-- Package Swazoo-Tests(1.1.3,janko)= -->


<component-property>
<name>Swazoo-Tests</name> <type>package</type>
<property>prerequisiteParcels</property> <value>#(#('SUnit' ''))</value>
</component-property>

<component-property>
<name>Swazoo-Tests</name> <type>package</type>
<property>packageName</property> <value>'Swazoo-Tests'</value>
</component-property>

<component-property>
<name>Swazoo-Tests</name> <type>package</type>
<property>comment</property> <value>'SUnit tests for Swazoo'</value>
</component-property>

<component-property>
<name>Swazoo-Tests</name> <type>package</type>
<property>parcelName</property> <value>'Swazoo-Tests'</value>
</component-property>

<component-property>
<name>Swazoo-Tests</name> <type>package</type>
<property>developmentPrerequisites</property> <value>#(#(#any 'SUnit' ''))</value>
</component-property>

<component-property>
<name>Swazoo-Tests</name> <type>package</type>
<property>version</property> <value>'1.0'</value>
</component-property>

<class>
<name>SiteIdentifierTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>identifier </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>ResourceTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>resource </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>ACLResourceTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>resource </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>HelloWorldResourceTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>hello </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooURITest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>fooURI barURI queryURI </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooTestStream</name>
<environment>Swazoo</environment>
<super>Core.ReadStream</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooActivePageTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>page </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SiteTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>site </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooStreamTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>input output </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>RedirectionResourceTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>resource </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>HomeResourceTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>resource </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooCompilerTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooSessionTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>session </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>HeaderFieldTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>FileResourceTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>resource </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooSocketTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>input output </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>GoodbyeTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>goodbye </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>HTTPResponseTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>response </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>HTTPReadStreamTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>stream </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooServerTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>server </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>HTTPServerTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>server stream </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooBaseExtensionsTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>CompositeResourceTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>composite </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>URIParsingTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>TestPseudoSocket</name>
<environment>Swazoo</environment>
<super>Core.Object</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>byteStreamToServer byteStreamFromServer clientWaitSemaphore serverWaitSemaphore ipAddress </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<comment>
<class-id>Swazoo.TestPseudoSocket</class-id>
<body>TestPseudoSocket is a drop in replacement for a SwazooSocket that can be used during testing to feed bytes into a running SwazooHTTPServer and grab the responses without having to start a real socket pair.

So, to the HTTP server it must look like a server socket.  To the tester it must look like a write stream (to send bytes to the HTTP server) and a read stream (to read the HTTP responses).</body>
</comment>

<class>
<name>SwazooConfigurationTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooActivePageResourceTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>resource </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>URIResolutionTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars></inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>HTTPRequestTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>request </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>

<class>
<name>SwazooCacheControlTest</name>
<environment>Swazoo</environment>
<super>XProgramming.SUnit.TestCase</super>
<private>false</private>
<indexed-type>none</indexed-type>
<inst-vars>resource cacheTarget request cacheControl </inst-vars>
<class-inst-vars></class-inst-vars>
<imports></imports>
<category>Swazoo-Tests</category>
<attributes>
<package>Swazoo-Tests</package>
</attributes>
</class>































<methods>
<class-id>Swazoo.SiteIdentifierTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	identifier := SiteIdentifier 
				ip: '127.0.0.1'
				port: 80
				host: 'localhost'</body>
</methods>

<methods>
<class-id>Swazoo.SiteIdentifierTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testCurrentUrl
	self assert: identifier currentUrl = 'http://localhost'.
		identifier := SiteIdentifier 
				ip: '127.0.0.1'
				port: 81
				host: 'localhost'.
	self assert: identifier currentUrl = 'http://localhost:81'</body>

<body package="Swazoo-Tests">testPortMismatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.1'
				port: 81
				host: 'localhost'.
	self deny: (identifier match: another)</body>

<body package="Swazoo-Tests">testMatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.1'
				port: 80
				host: 'localhost'.
	self assert: (identifier match: another)</body>

<body package="Swazoo-Tests">testCaseInsensitiveMatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.1'
				port: 80
				host: 'lOCaLhOST'.
	self assert: (identifier match: another)</body>

<body package="Swazoo-Tests">testHostMismatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.1'
				port: 80
				host: 'thisIsMyMachine'.
	self deny: (identifier match: another)</body>

<body package="Swazoo-Tests">testIPMismatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.2'
				port: 80
				host: 'localhost'.
	self deny: (identifier match: another)</body>
</methods>


<methods>
<class-id>Swazoo.ResourceTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testNilURIPatternDoesNothing
	| pattern |
	pattern := resource uriPattern.
	resource uriPattern: nil.
	self assert: resource uriPattern = pattern</body>

<body package="Swazoo-Tests">testEnabledByDefault
	self assert: resource isEnabled</body>

<body package="Swazoo-Tests">testEmptyURIPatternInvalid
	resource uriPattern: ''.
	self deny: resource isValidlyConfigured</body>

<body package="Swazoo-Tests">testValidlyConfigured
	self assert: resource isValidlyConfigured</body>
</methods>

<methods>
<class-id>Swazoo.ResourceTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	resource := Resource uriPattern: 'foo'</body>
</methods>

<methods>
<class-id>Swazoo.ResourceTest</class-id> <category>private</category>

<body package="Swazoo-Tests">crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf</body>

<body package="Swazoo-Tests">basicGet: uri
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET ', uri, ' HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: swazoo.org'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)</body>

<body package="Swazoo-Tests">basicGetUri: uriString host: hostname port: port 
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET ' , uriString , ' HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: ' , hostname.
	port notNil 
		ifTrue: 
			[ws
				nextPut: $:;
				print: port].
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)</body>

<body package="Swazoo-Tests">basicGetUri: uriString
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET ' , uriString , ' HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: swazoo.org'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)</body>
</methods>


<methods>
<class-id>Swazoo.ACLResourceTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	| users |
	users := Dictionary new.
	users at: 'peter' put: 'gabriel'.
	users at: 'alan' put: 'kay'.
	resource := ACLResource new.
	resource setUsers: users</body>
</methods>

<methods>
<class-id>Swazoo.ACLResourceTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testAuthorizedLogins
	self
		assert: resource authorizedLogins size = 2;
		assert: (resource authorizedLogins includes: 'peter');
		assert: (resource authorizedLogins includes: 'alan');
		deny: (resource authorizedLogins includes: 'gosling');
		deny: (resource authorizedLogins includes: 'gabriel')</body>

<body package="Swazoo-Tests">testPasswords
	self
		assert: (resource passwordForLogin: 'peter') = 'gabriel';
		assert: (resource passwordForLogin: 'alan') = 'kay'</body>

<body package="Swazoo-Tests">testReadUsers
	| ws |
	ws := WriteStream on: String new.
	ws
		nextPutAll: 'peter,gabriel';
		cr.
	ws
		nextPutAll: 'alan,kay';
		cr.
	resource
		setUsers: nil;
		readUsersFrom: (ReadStream on: ws contents).
	self
		testAuthorizedLogins;
		testPasswords</body>

<body package="Swazoo-Tests">testSessionAuthorization
	| session |
	session := SwazooSession new.
	session at: #authorizedLogin put: 'peter'.
	self assert: (resource authorizeSession: session).
	session at: #authorizedLogin put: 'alan'.
	self assert: (resource authorizeSession: session).
	session at: #authorizedLogin put: 'gosling'.
	self deny: (resource authorizeSession: session)</body>
</methods>


<methods>
<class-id>Swazoo.HelloWorldResourceTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	hello := HelloWorldResource uriPattern: 'hello.html'</body>
</methods>

<methods>
<class-id>Swazoo.HelloWorldResourceTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testResponse
	| request response |
	request := HTTPGet request: 'hello.html'.
	response := URIResolution resolveRequest: request startingAt: hello.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'hello.html'</body>
</methods>


<methods>
<class-id>Swazoo.SwazooURITest</class-id> <category>running</category>

<body package="Swazoo-Tests">testIdentifierPath
	self assert: fooURI identifierPath 
				= (OrderedCollection with: '/' with: 'index.html').
	self assert: queryURI identifierPath 
				= (OrderedCollection with: '/' with: 'index.html').
	self 
		assert: barURI identifierPath = (OrderedCollection with: '/' with: 'files')</body>

<body package="Swazoo-Tests">setUp
	fooURI := SwazooURI fromString: 'www.foo.com/index.html'.
	queryURI := SwazooURI fromString: 'www.foo.com/index.html?foo=1&amp;bar=hi'.
	barURI := SwazooURI fromString: 'www.bar.com:8080/files/'</body>

<body package="Swazoo-Tests">testPort
	self assert: fooURI port = 80.
	self assert: queryURI port = 80.
	self assert: barURI port = 8080</body>

<body package="Swazoo-Tests">testQueries
	self deny: (queryURI includesQuery: 'hi').
	self assert: (queryURI includesQuery: 'foo').
	self assert: (queryURI includesQuery: 'bar').
	self assert: (queryURI queryAt: 'foo') = '1'.
	self assert: (queryURI queryAt: 'bar') = 'hi'</body>

<body package="Swazoo-Tests">testIdentifier
	self assert: fooURI identifier = '/index.html'.
	self assert: queryURI identifier = '/index.html'.
	self assert: barURI identifier = '/files/'</body>

<body package="Swazoo-Tests">testValue
	self assert: fooURI value = 'http://www.foo.com/index.html'.
	self assert: queryURI value = 'http://www.foo.com/index.html?foo=1&amp;bar=hi'.
	self assert: barURI value = 'http://www.bar.com:8080/files/'</body>

<body package="Swazoo-Tests">testHostname
	self assert: fooURI hostname = 'www.foo.com'.
	self assert: queryURI hostname = 'www.foo.com'.
	self assert: barURI hostname = 'www.bar.com'</body>

<body package="Swazoo-Tests">testIsDirectory
	self deny: fooURI isDirectory.
	self deny: queryURI isDirectory.
	self assert: barURI isDirectory</body>
</methods>


<methods>
<class-id>Swazoo.SwazooTestStream</class-id> <category>accessing</category>

<body package="Swazoo-Tests">nextBytes: anInteger
	^(self next: anInteger) asByteArray</body>
</methods>


<methods>
<class-id>Swazoo.SwazooActivePageTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	page := SwazooActivePage new</body>
</methods>

<methods>
<class-id>Swazoo.SwazooActivePageTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testMethodInvocation
	| rs |
	rs := ReadStream 
				on: '&lt;HTML&gt;&lt;? 1 to: 5 do: [:i | ?&gt;&lt;H1&gt;Paragraph &lt;? ws print: i. ?&gt;&lt;/H1&gt;&lt;? ]. ?&gt;&lt;/HTML&gt;'.
	self assert: (page invokeMethodFrom: rs) 
				= '&lt;HTML&gt;&lt;H1&gt;Paragraph 1&lt;/H1&gt;&lt;H1&gt;Paragraph 2&lt;/H1&gt;&lt;H1&gt;Paragraph 3&lt;/H1&gt;&lt;H1&gt;Paragraph 4&lt;/H1&gt;&lt;H1&gt;Paragraph 5&lt;/H1&gt;&lt;/HTML&gt;'</body>
</methods>


<methods>
<class-id>Swazoo.SwazooStreamTest</class-id> <category>running</category>

<body package="Swazoo-Tests">tearDown
	input close.
	output close</body>

<body package="Swazoo-Tests">setUp
	| pair |
	pair := SwazooStream connectedPair.
	input := pair first.
	output := pair last</body>
</methods>

<methods>
<class-id>Swazoo.SwazooStreamTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testNextPutBytes
	| bytes1 bytes2 bytes3 |
	bytes1 := ByteArray withAll: #(1 2 3 4).
	bytes2 := ByteArray withAll: #(5 4 3 2 1).
	bytes3 := ByteArray withAll: #(1 1 2 3 5).
	(Array 
		with: bytes1
		with: bytes2
		with: bytes3) do: 
				[:each | 
				self assert: (input nextPutBytes: each) = each.
				input flush.
				self assert: (output nextBytes: each size) = each]</body>

<body package="Swazoo-Tests">testNextPut
	#($A $M $Y $b $r $z) do: 
			[:each | 
			self assert: (input nextPut: each) = each. 
			input flush.
			self assert: output next = each]</body>

<body package="Swazoo-Tests">testErrorOnInputClose
	self should: 
			[input close.
			output next]
		raise: Error</body>

<body package="Swazoo-Tests">testPeek
	#($K $J $D $j $m $z) do: 
			[:each | 
			input nextPut: each.
			input flush.
			self assert: output peek = each.
			output next]</body>

<body package="Swazoo-Tests">testNextPutByte
	| bytes |
	bytes := ByteArray 
				with: 6
				with: 5
				with: 0
				with: 2.
	bytes do: 
			[:each | 
			self assert: (input nextPutByte: each) = each. 
			input flush.
			self assert: output nextByte = each]</body>

<body package="Swazoo-Tests">testConnectedPair
	(Array with: input with: output) 
		do: [:each | self assert: (each isKindOf: SwazooStream)]</body>

<body package="Swazoo-Tests">testNextPutAll
	#('123' 'abc' 'swazoo') do: 
			[:each | 
			self assert: (input nextPutAll: each) = each. 
			input flush.
			self assert: (output next: each size) = each]</body>

<body package="Swazoo-Tests">testPeekByte
	| bytes |
	bytes := ByteArray withAll: #(5 2 8 4 11 231).
	bytes do: 
			[:each | 
			input nextPutByte: each.
			input flush.
			self assert: output peekByte = each.
			output nextByte]</body>
</methods>


<methods>
<class-id>Swazoo.SiteTest</class-id> <category>running</category>

<body package="Swazoo-Tests">addSecondAlias
	site addAlias: (SiteIdentifier 
				ip: '127.0.0.2'
				port: 8202
				host: 'swazoo2.org')</body>

<body package="Swazoo-Tests">setUp
	super setUp.
	site := Site new.
	site addAlias: (SiteIdentifier
			ip: '127.0.0.1'
			port: 8200
			host: 'swazoo.org')</body>
</methods>

<methods>
<class-id>Swazoo.SiteTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testCurrentUrl
	site currentUrl = 'http://swazoo.org:8200'.
	self addSecondAlias.
	site currentUrl = 'http://swazoo.org:8200'.</body>

<body package="Swazoo-Tests">testCurrentUrl80
	| aSite |
	aSite := Site new.
	aSite addAlias: (SiteIdentifier
			ip: '127.0.0.1'
			port: 80
			host: 'swazoo.org').
	aSite currentUrl = 'http://swazoo.org'.
	aSite currentUrl = 'http://swazoo.org'</body>
</methods>


<methods>
<class-id>Swazoo.RedirectionResourceTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	resource := RedirectionResource uriPattern: 'foo'
				targetUri: 'http://abc.def.com'</body>
</methods>

<methods>
<class-id>Swazoo.RedirectionResourceTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testGetResource
	| request response |
	request := HTTPGet request: 'foo'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 301.
	self assert: (response headers fieldNamed: 'Location') uri asString 
				= 'http://abc.def.com'.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'foo'</body>
</methods>


<methods>
<class-id>Swazoo.HomeResourceTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	resource := HomeResource uriPattern: '/' filePath: 'home'</body>

<body package="Swazoo-Tests">testRootFileFor
	| request |
	request := HTTPGet request: '/~someUser'.
	URIResolution new initializeRequest: request.
	self assert: (resource rootFileFor: request) 
				= (('home' asFilename construct: 'someUser') construct: 'html')</body>

<body package="Swazoo-Tests">testValidateHomePath
	self assert: (resource validateHomePath: '~somebody').
	self assert: (resource validateHomePath: '~somebodyElse').
	self deny: (resource validateHomePath: 'someplace').
	self deny: (resource validateHomePath: 'some~body')</body>
</methods>


<methods>
<class-id>Swazoo.SwazooCompilerTest</class-id> <category>running</category>

<body package="Swazoo-Tests">testEvaluateReceiver
	self assert: (SwazooCompiler evaluate: 'self + 2 * 3' receiver: 1) = 9</body>

<body package="Swazoo-Tests">testEvaluate
	self assert: (SwazooCompiler evaluate: '1 + 2 * 3') = 9</body>
</methods>


<methods>
<class-id>Swazoo.SwazooSessionTest</class-id> <category>running</category>

<body package="Swazoo-Tests">testAtIfAbsent
	self assert: (session at: #testKey ifAbsent: [#foo]) == #testValue.
	self assert: (session at: #foo ifAbsent: [#bar]) == #bar</body>

<body package="Swazoo-Tests">setUp
	session := SwazooSession new.
	session at: #testKey put: #testValue</body>

<body package="Swazoo-Tests">testAtIfAbsentPut
	self assert: (session at: #testKey ifAbsentPut: [#foo]) == #testValue.
	self assert: (session at: #foo ifAbsentPut: [#bar]) == #bar.
	self assert: (session at: #foo) == #bar</body>
</methods>

<methods>
<class-id>Swazoo.SwazooSessionTest</class-id> <category>As yet unclassified</category>

<body package="Swazoo-Tests">testIncludesKey
	self assert: (session includesKey: #testKey).
	self deny: (session includesKey: #bar)</body>

<body package="Swazoo-Tests">testRemoveKey
	session removeKey: #testKey.
	self deny: (session includesKey: #testKey).
	session removeKey: #bar</body>
</methods>


<methods>
<class-id>Swazoo.HeaderFieldTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testContentTypeMultiple
	"   HTTP/1.1 header field values can be folded onto multiple lines if the
   continuation line begins with a space or horizontal tab. All linear
   white space, including folding, has the same semantics as SP. A
   recipient MAY replace any linear white space with a single SP before
   interpreting the field value or forwarding the message downstream.

       LWS            = [CRLF] 1*( SP | HT )"

	| requestStream request field |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.1';
		nextPutLine: 'Host: 127.0.0.1';
		nextPutLine: 'Content-Type: text/html; ';
		nextPutLine: ' charset=iso-8859-1';
		crlf.
	request := HTTPRequest readFrom: (ReadStream on: requestStream contents).
	field := request headers fieldNamed: 'content-type'.
	self assert: field name = 'Content-Type'.
	self assert: field mediaType = 'text/html'.
	self assert: (field transferCodings at: 'charset') = 'iso-8859-1'</body>

<body package="Swazoo-Tests">testCombine
	"Entity tags must be quoted strings - RFC 2616 3.11"

	| header1 header2 header3 |
	header1 := HeaderField fromLine: 'If-Match: "a"'.
	header2 := HeaderField fromLine: 'If-Match: "b","c"'.
	header3 := HeaderField fromLine: 'If-Match: "d"'.
	header1 combineWith: header2.
	self assert: header1 valuesAsString = '"a","b","c"'.
	header1 combineWith: header3.
	self assert: header1 valuesAsString = '"a","b","c","d"'</body>

<body package="Swazoo-Tests">testValues
	"Entity tags are held internally as simple strings.  Any necessary leading and trailing double quotes are added by the header fields as needed.  Note that it is OK to have a comma in an entity tag - see the second of the group of 3 tags below."

	| header |
	header := HeaderField fromLine: 'If-Match: "xyzzy" '.
	self assert: header name = 'If-Match'.
	self assert: header entityTags first = 'xyzzy'.
	header := HeaderField 
				fromLine: 'If-Match: "xyzzy", "r2d2,xxxx", "c3piozzzz" '.
	self assert: header name = 'If-Match'.
	self assert: header entityTags first = 'xyzzy'.
	self assert: (header entityTags at: 2) = 'r2d2,xxxx'.
	self assert: header entityTags last = 'c3piozzzz'</body>
</methods>


<methods>
<class-id>Swazoo.SwazooSocketTest</class-id> <category>running</category>

<body package="Swazoo-Tests">tearDown
	input close.
	output close</body>

<body package="Swazoo-Tests">setUp
	| pair |
	pair := SwazooSocket connectedPair.
	input := pair first.
	output := pair last</body>
</methods>

<methods>
<class-id>Swazoo.SwazooSocketTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testReadTimeout
	input write: (ByteArray withAll: #(1 2 3)).
	self assert: (output read: 3 timeout: 40) = (ByteArray withAll: #(1 2 3)).
	self assert: (output read: 3 timeout: 40) = ByteArray new</body>

<body package="Swazoo-Tests">testPartialRead
	| bytes |
	bytes := ByteArray withAll: #(5 4 3).
	self assert: (input write: bytes) = 3.
	self assert: (output read: 5) = bytes</body>

<body package="Swazoo-Tests">testNetworkConnection
	| server sem |
	input close.
	output close.
	sem := Semaphore new.
	
	[server := SwazooSocket serverOnIP: '127.0.0.1' port: 65423.
	server listenFor: 50.
	
	[input := server accept.
	sem signal] fork.
	output := SwazooSocket connectTo: 'localhost' port: 65423.
	sem wait.
	self testReadWrite] 
			ensure: [server close]</body>

<body package="Swazoo-Tests">testConnectedPair
	(Array with: input with: output) 
		do: [:each | self assert: (each isKindOf: SwazooSocket)]</body>

<body package="Swazoo-Tests">testReadWrite
	| bytes |
	bytes := ByteArray withAll: #(1 2 3 4 5).
	self assert: (input write: bytes) = 5.
	self assert: (output read: 5) = bytes.
	bytes := ByteArray with: 4.
	self assert: (input write: bytes) = 1.
	self assert: (output read: 1) = bytes</body>
</methods>


<methods>
<class-id>Swazoo.FileResourceTest</class-id> <category>running</category>

<body package="Swazoo-Tests">tearDown
	('fResTest' asFilename construct: 'abc.html') delete.
	'fResTest' asFilename delete</body>

<body package="Swazoo-Tests">setUp
	| directory firstFile ws |
	directory := 'fResTest' asFilename.
	directory exists ifFalse: [directory makeDirectory].
	firstFile := directory construct: 'abc.html'.
	ws := firstFile writeStream.
	[ws nextPutAll: 'hello'] ensure: [ws close].
	resource := FileResource uriPattern: 'foo' filePath: 'fResTest'</body>
</methods>

<methods>
<class-id>Swazoo.FileResourceTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testNonexistantFile
	| request response |
	request := HTTPGet request: 'foo/notThere.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil</body>

<body package="Swazoo-Tests">testRelativeFile
	| request response |
	request := HTTPGet request: 'foo/../', resource fileDirectory tail, '/abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil</body>

<body package="Swazoo-Tests">testRedirection
	| request response |
	request := HTTPGet request: 'foo'.
	resource directoryIndex: 'abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 301.
	self assert: (response headers fieldNamed: 'Location') uri asString 
				= 'http://foo/'.
	self assert: (response headers fieldNamed: 'Location') uri host = 'foo'</body>

<body package="Swazoo-Tests">testSafeConstruct
	| request response |
	request := HTTPGet request: 'foo/../abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	request := HTTPGet request: 'foo/.. /./abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200</body>

<body package="Swazoo-Tests">testDirectoryIndex
	| request response |
	request := HTTPGet request: 'foo/'.
	resource directoryIndex: 'abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'foo'</body>

<body package="Swazoo-Tests">testETag
	"Filename etags do not have the leading and trailing double quotes.  Header fields add the quotes as necessary"

	| request response etag |
	request := HTTPGet request: 'foo/abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self 
		assert: (etag := (response headers fieldOfClass: HTTPETagField) entityTag) 
				notNil.
	request := HTTPGet request: 'foo/abc.html'.
	request headers addField: (HTTPIfNoneMatchField new addEntityTag: etag).
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 304.
	self assert: (response headers fieldOfClass: HTTPETagField) entityTag = etag.
	request := HTTPGet request: 'foo/abc.html'.
	request headers addField: (HTTPIfNoneMatchField new valueFrom: '"wrong"').
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: (response headers fieldOfClass: HTTPETagField) entityTag = etag</body>

<body package="Swazoo-Tests">testContentType
	self assert: (resource contentTypeFor: '.txt') = 'text/plain'.
	self assert: (resource contentTypeFor: '.html') = 'text/html'</body>

<body package="Swazoo-Tests">testExistantFile
	| request response |
	request := HTTPGet request: 'foo/abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'foo'</body>
</methods>


<methods>
<class-id>Swazoo.GoodbyeTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	goodbye := GoodbyeCruelWorld uriPattern: 'goodbye.html'</body>

<body package="Swazoo-Tests">siteCompositeRootWith: aResource 
	| tSite tComposite |
	tSite := Site new.
	tSite addAlias: (SiteIdentifier
			ip: '127.0.0.1'
			port: 8200
			host: 'swazoo.org').
	tSite addResource: (tComposite := CompositeResource uriPattern: '/').
	tComposite addResource: aResource.
	^tSite</body>
</methods>

<methods>
<class-id>Swazoo.GoodbyeTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testCurrentUrl
	self siteCompositeRootWith: goodbye.
	self assert: goodbye currentUrl = 'http://swazoo.org:8200/goodbye.html'</body>

<body package="Swazoo-Tests">testResponse
	| request response |
	request := HTTPGet request: 'goodbye.html'.
	response := URIResolution resolveRequest: request startingAt: goodbye.
	self assert: response code = 404.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'goodbye.html'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPResponseTest</class-id> <category>private</category>

<body package="Swazoo-Tests">crlf
	^String with: Character cr with: Character lf</body>
</methods>

<methods>
<class-id>Swazoo.HTTPResponseTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testOK
	| ws ls |
	response := HTTPResponse ok.
	ws := WriteStream on: String new.
	response printStatusOn: ws.
	ls := HTTPReadStream onStream: (ReadStream on: ws contents).
	self assert: ls nextLine = 'HTTP/1.1 200 OK'</body>

<body package="Swazoo-Tests">testResponseTypes
	self assert: (HTTPResponse badRequest) isBadRequest.
	self assert: (HTTPResponse found) isFound.
	self assert: (HTTPResponse internalServerError) isInternalServerError.
	self assert: (HTTPResponse movedPermanently) isMovedPermanently.
	self assert: (HTTPResponse notFound) isNotFound.
	self assert: (HTTPResponse notImplemented) isNotImplemented.
	self assert: (HTTPResponse notModified) isNotModified.
	self assert: (HTTPResponse ok) isOk.
	self assert: (HTTPResponse redirectLink) isRedirectLink.
	self assert: (HTTPResponse seeOther) isSeeOther.</body>

<body package="Swazoo-Tests">testInternalServerError
	| ws ls |
	response := HTTPResponse internalServerError.
	ws := WriteStream on: String new.
	response printStatusOn: ws.
	ls := HTTPReadStream onStream: (ReadStream on: ws contents).
	self assert: ls nextLine = 'HTTP/1.1 500 Internal Server Error'</body>
</methods>


<methods>
<class-id>Swazoo.HTTPReadStreamTest</class-id> <category>private</category>

<body package="Swazoo-Tests">crlfOn: ws 
	ws
		nextPut: Character cr;
		nextPut: Character lf</body>
</methods>

<methods>
<class-id>Swazoo.HTTPReadStreamTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testSingleLineWithCRLF
	| ws comparisonString |
	comparisonString := 'abcd'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	self crlfOn: ws.
	stream := HTTPReadStream onStream: (ReadStream on: ws contents).
	self assert: stream nextLine = comparisonString</body>

<body package="Swazoo-Tests">testSingleLineWithCR
	| ws comparisonString errored |
	comparisonString := 'abcd' , (String with: Character cr) , 'efg'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	ws nextPut: Character cr.
	stream := HTTPReadStream onStream: (ReadStream on: ws contents).
	errored := false.
	SpExceptionContext 
		for: [stream nextLine]
		on: SpError
		do: [:ex | errored := true].
	self assert: errored</body>

<body package="Swazoo-Tests">testLinesWithDoubleCRLF
	| ws comparisonString |
	comparisonString := 'abcd'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	self crlfOn: ws.
	self crlfOn: ws.
	stream := HTTPReadStream onStream: (ReadStream on: ws contents).
	self assert: stream nextLine = comparisonString.
	self assert: stream nextLine = ''</body>
</methods>


<methods>
<class-id>Swazoo.SwazooServerTest</class-id> <category>running</category>

<body package="Swazoo-Tests">tearDown
	super tearDown.
	server 
		stop;
		initialize.</body>

<body package="Swazoo-Tests">setUp
	super setUp.
	server := SwazooServer singleton.
	server initialize.</body>
</methods>

<methods>
<class-id>Swazoo.SwazooServerTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testDuplicateNames
	| site |
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self should: [site name: 'test'] raise: Error.
	self shouldnt: [site host: 'test.org'] raise: Error.
	self should: [Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80] raise: Error.</body>

<body package="Swazoo-Tests">testAccessingSite
	| site |
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self assert: (SwazooServer siteNamed: 'test') notNil.
	site := SwazooServer siteNamed: 'test'.
	self assert: (site name = 'test').
	self assert: (SwazooServer siteHostnamed: 'test.org') notNil.
	site := SwazooServer siteHostnamed: 'test.org'.
	self assert: (site host = 'test.org').</body>

<body package="Swazoo-Tests">testStartingSite
	| site |
	site := Site new name: 'test'; host: 'test.org' ip: 'localhost' port: 8765.
	server addSite: site.
	self assert: site isServing not.
	SwazooServer startSite: 'test'.
	self assert: server servers size = 1.
	self assert: site isServing.
	SwazooServer stopSite: 'test'.
	self assert: site isServing not.
	self assert: server servers size = 0.</body>

<body package="Swazoo-Tests">testAddingSite
	| site |
	self assert: server sites size = 0.
	self assert: (server siteNamed: 'test') isNil.
	self assert: (server siteHostnamed: 'test.org') isNil.
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self assert: (server siteNamed: 'test') notNil.
	self assert: (server siteHostnamed: 'test.org') notNil.
	server removeSite: site.
	self assert: server sites size = 0.</body>
</methods>


<methods>
<class-id>Swazoo.HTTPServerTest</class-id> <category>running</category>

<body package="Swazoo-Tests">tearDown
	server stop.
	stream close.
	stream := nil.
	Delay forMilliseconds: 500.
	ObjectMemory compactingGC</body>

<body package="Swazoo-Tests">setUp
	(Delay forMilliseconds: 100) wait.
	ObjectMemory compactingGC.
	server := HTTPServer new.
	[server ip: 'localhost'; port: 8123.
	server start]
		fork.
	(Delay forMilliseconds: 100) wait.
	stream := (SocketAccessor newTCPclientToHost: 'localhost' port: 8123) 
				readAppendStream</body>
</methods>

<methods>
<class-id>Swazoo.HTTPServerTest</class-id> <category>tests</category>

<body package="Swazoo-Tests">testStopServing
	server stop.
	self deny: server isServing</body>

<body package="Swazoo-Tests">testServing
	self assert: server isServing</body>
</methods>


<methods>
<class-id>Swazoo.SwazooBaseExtensionsTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testStringNewRandom
	| sizes strings |
	sizes := #(5 20 6127 2 100).
	strings := sizes collect: [:each |  HTTPString newRandomString: each].
	strings with: sizes do: [:string :size | self assert: string size = size]</body>

<body package="Swazoo-Tests">testCharacterArrayTrimBlanks
	self 
		assert: (HTTPString trimBlanksFrom: '   a b c d e f g') = 'a b c d e f g'.
	self assert: (HTTPString trimBlanksFrom: 'no blanks') = 'no blanks'.
	self assert: (HTTPString trimBlanksFrom: ' leading') = 'leading'.
	self assert: (HTTPString trimBlanksFrom: 'trailing ') = 'trailing'.
	self assert: (HTTPString trimBlanksFrom: '') = ''.
	self 
		assert: (HTTPString 
				trimBlanksFrom: (String with: Character cr with: Character lf)) isEmpty</body>

<body package="Swazoo-Tests">testFilenameEtag
	"The filename etag is a simple string and does not contain double quotes.  Header fields apply double quotes as necessary when writing themselves."

	| fn etag1 etag2 |
	fn := 'etagTest' asFilename.
	fn writeStream close.
	etag1 := fn etag.
	(Delay forSeconds: 1) wait.
	fn writeStream close.
	
	[etag2 := fn etag.
	self assert: (etag1 isKindOf: String).
	self assert: (etag2 isKindOf: String).
	self deny: etag1 = etag2] 
			ensure: [fn delete]</body>
</methods>


<methods>
<class-id>Swazoo.CompositeResourceTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	composite := CompositeResource uriPattern: '/'</body>
</methods>

<methods>
<class-id>Swazoo.CompositeResourceTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testValidlyConfigured
	self assert: composite isValidlyConfigured</body>

<body package="Swazoo-Tests">testAddResource
	| child |
	composite addResource: (child := HelloWorldResource uriPattern: 'hello.html').
	self assert: composite children size = 1.
	self assert: composite children first == child.
	self assert: child parent == composite</body>

<body package="Swazoo-Tests">sampleInSite
	| site |
	site := Site new.
	site addAlias: (SiteIdentifier
			ip: '127.0.0.1'
			port: 8200
			host: 'swazoo.org').
	site addResource: composite</body>

<body package="Swazoo-Tests">testNilURIPatternDoesNothing
	| pattern |
	pattern := composite uriPattern.
	composite uriPattern: nil.
	self assert: composite uriPattern = pattern</body>

<body package="Swazoo-Tests">testEmptyURIPatternInvalid
	composite uriPattern: ''.
	self deny: composite isValidlyConfigured</body>

<body package="Swazoo-Tests">testCurrentUrl
	| child leaf |	
	self sampleInSite.
	self assert: composite currentUrl = 'http://swazoo.org:8200/'.
	composite addResource: (child := CompositeResource uriPattern: 'foo').
	self assert: child currentUrl = 'http://swazoo.org:8200/foo/'.
	child addResource: (leaf := HelloWorldResource uriPattern: 'hi.html').
	self assert: leaf currentUrl = 'http://swazoo.org:8200/foo/hi.html'.</body>

<body package="Swazoo-Tests">testAddResources
	| child1 child2 |
	child1 := HelloWorldResource uriPattern: 'hello1.html'.
	child2 := HelloWorldResource uriPattern: 'hello2.html'.
	composite addResources: (Array with: child1 with: child2).
	self assert: composite children size = 2.
	composite children
		do: 
			[:each | 
			self assert: (composite children includes: each).
			self assert: each parent == composite]</body>
</methods>


<methods>
<class-id>Swazoo.URIParsingTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">test20SimpleFullURIWithNoPort

|uri|
uri := SwazooURI fromString: 'http://abc.com/smith/home.html?a=1&amp;b=2'.
self assert: (uri protocol = 'http').
self assert: (uri hostname = 'abc.com'). 
self assert: (uri port = 80).
self assert: (uri identifier = '/smith/home.html').
self assert: (uri asString = 'http://abc.com/smith/home.html?a=1&amp;b=2').</body>

<body package="Swazoo-Tests">test10SimpleFullURIWithQuery

|uri|
uri := SwazooURI fromString: 'http://abc.com:8080/smith/home.html?a=1&amp;b=2'.
self assert: (uri protocol = 'http').
self assert: (uri hostname = 'abc.com'). 
self assert: (uri port = 8080).
self assert: (uri identifier = '/smith/home.html').
self assert: (uri asString = 'http://abc.com:8080/smith/home.html?a=1&amp;b=2').</body>

<body package="Swazoo-Tests">test15SimpleFullURIWithPort80

|uri|
uri := SwazooURI fromString: 'http://abc.com:80/smith/home.html?a=1&amp;b=2'.
self assert: (uri protocol = 'http').
self assert: (uri hostname = 'abc.com'). 
self assert: (uri port = 80).
self assert: (uri identifier = '/smith/home.html').
self assert: (uri asString = 'http://abc.com/smith/home.html?a=1&amp;b=2').</body>

<body package="Swazoo-Tests">test05SimpleFullURI

|uri|
uri := SwazooURI fromString: 'http://abc.com:8080/smith/home.html'.
self assert: (uri protocol = 'http').
self assert: (uri hostname = 'abc.com'). 
self assert: (uri port = 8080).
self assert: (uri identifier = '/smith/home.html').
self assert: (uri asString = 'http://abc.com:8080/smith/home.html').</body>
</methods>


<methods>
<class-id>Swazoo.TestPseudoSocket class</class-id> <category>instance creation</category>

<body package="Swazoo-Tests">newTCPSocket
	"^a TestPseudoSocket
I simply return a new instance of myself."

	^self new</body>

<body package="Swazoo-Tests">serverOnIP: host port: port 
	"^self
I'm only pretending to be a socket class, so I ignore the host and port."

	^self new</body>
</methods>


<methods>
<class-id>Swazoo.TestPseudoSocket</class-id> <category>socket stuff</category>

<body package="Swazoo-Tests">isActive
	"^self
I am pretending to be a socket, and the sender wants to know if I am active.  Of course I am!."

	^true</body>

<body package="Swazoo-Tests">setAddressReuse: aBoolean 
	"^self
This is a no-op for me."

	^self</body>

<body package="Swazoo-Tests">listenBackloggingUpTo: anInteger 
	"^self
This is a no-op for me."

	^self</body>

<body package="Swazoo-Tests">listenFor: anInteger 
	"^self
This is a no-op for now."

	^self</body>

<body package="Swazoo-Tests">stream
	"^self
I have to pretend to be a socket stream too."

	^self</body>

<body package="Swazoo-Tests">getSocketName
	^ipAddress</body>

<body package="Swazoo-Tests">getPeerName
	^ipAddress</body>

<body package="Swazoo-Tests">close
	"^self
The server has finished with us at this point, so we signal the semaphore to give the client end chance to grab the response."

	self clientWaitSemaphore signal.
	^self</body>

<body package="Swazoo-Tests">bindSocketAddress: anOSkIPAddress 
	"^self
This is a no-op for me."

	ipAddress := anOSkIPAddress.
	^self</body>

<body package="Swazoo-Tests">acceptRetryingIfTransientErrors
	"^another TestSocketThing
	The sender expects me to block until a request comes in 'over the socket'.  What I really do is wait for someone to ask me to 'send in' a Byte array and then I return myself.  Note that I will only handle one request at a time!"

	self serverWaitSemaphore wait.
	^self</body>

<body package="Swazoo-Tests">flush
	^self</body>
</methods>

<methods>
<class-id>Swazoo.TestPseudoSocket</class-id> <category>stream-toServer</category>

<body package="Swazoo-Tests">peek
	"^a Character
It seems that the HTTP server is expecting Characters not Bytes - this will have to change."

	^byteStreamToServer isNil 
		ifTrue: [nil]
		ifFalse: [self byteStreamToServer peek asCharacter]</body>

<body package="Swazoo-Tests">next
	^self byteStreamToServer next</body>

<body package="Swazoo-Tests">read: integerNumberOfBytes 
	"^a ByteArray
I read the next numberOfBytes from my underlying stream."

	^byteStreamToServer isNil 
		ifTrue: [ByteArray new]
		ifFalse: [self byteStreamToServer nextAvailable: integerNumberOfBytes]</body>

<body package="Swazoo-Tests">upTo: aCharacter 
	"a ByteString
For some reason, we have to look for a character in a ByteStream - this is a Swazoo thing."

	^(self byteStreamToServer upTo: aCharacter asInteger) asByteString</body>

<body package="Swazoo-Tests">socket
	"^self
I am being asked this as if I am a socket stream.  I return myself because I'm pretending to be both the socket and the socket stream."

	^self</body>
</methods>

<methods>
<class-id>Swazoo.TestPseudoSocket</class-id> <category>accessing</category>

<body package="Swazoo-Tests">serverWaitSemaphore
	"^a Semaphore
I return the semaphore I use to control 'server' activity."

	serverWaitSemaphore isNil ifTrue: [serverWaitSemaphore := Semaphore new].
	^serverWaitSemaphore</body>

<body package="Swazoo-Tests">byteStreamFromServer: aByteStream 
	byteStreamFromServer := aByteStream.
	^self</body>

<body package="Swazoo-Tests">byteStreamFromServer
	^byteStreamFromServer</body>

<body package="Swazoo-Tests">byteStreamToServer: aByteStream 
	byteStreamToServer := aByteStream.
	^self</body>

<body package="Swazoo-Tests">byteStreamToServer
	^byteStreamToServer</body>

<body package="Swazoo-Tests">clientWaitSemaphore
	"^a Semaphore
I return the semaphore I use to control 'client' activity."

	clientWaitSemaphore isNil ifTrue: [clientWaitSemaphore := Semaphore new].
	^clientWaitSemaphore</body>
</methods>

<methods>
<class-id>Swazoo.TestPseudoSocket</class-id> <category>stream-fromServer</category>

<body package="Swazoo-Tests">print: anObject 
	self nextPutAll: anObject printString asByteArray.
	^self</body>

<body package="Swazoo-Tests">nextPut: aCharacter 
	self byteStreamFromServer nextPut: aCharacter asInteger</body>

<body package="Swazoo-Tests">write: aByteArray 
	"^an Integer
	I write the contents of the sourceByteArray to my underlying Socket.
	I return the number of bytes written."

	self byteStreamFromServer nextPutAll: aByteArray.
	^aByteArray size</body>

<body package="Swazoo-Tests">nextPutAll: aCollection 
	"^self
At present it seems that aCollection will always be a string of chacters."

	^self byteStreamFromServer nextPutAll: aCollection asByteArray</body>

<body package="Swazoo-Tests">nextPutBytes: aByteArray 
	self byteStreamFromServer nextPutAll: aByteArray</body>

<body package="Swazoo-Tests">space
	self nextPut: Character space.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.TestPseudoSocket</class-id> <category>actions-client</category>

<body package="Swazoo-Tests">writeBytesToServer: aByteArray 
	"^self
This is where we make the bytes available over the pseudo socket.  Unlike a socket this is a one off thing (at least in this implementation of the pseudo socket).  Once the bytes are written, control passes to the server and stays there until the server sends a close to what it thinks is the client socket, but is really me."

	| results |
	self byteStreamToServer: (ReadStream on: aByteArray).
	self byteStreamFromServer: (WriteStream on: (ByteArray new: 1000)).
	self serverWaitSemaphore signal.
	self clientWaitSemaphore wait.
	results := self byteStreamFromServer contents.
	self byteStreamToServer: nil.
	self byteStreamFromServer: nil.
	^results</body>
</methods>


<methods>
<class-id>Swazoo.SwazooConfigurationTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testSingleResourceSite
	| rs site resource |
	rs := ReadStream on: '&lt;Site&gt;
&lt;SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''&gt;
 &lt;HelloWorldResource uriPattern: ''/''&gt;
&lt;/Site&gt;'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	resource := site children first.
	self assert: resource class == HelloWorldResource.
	self assert: resource uriPattern = '/'.
	self assert: resource parent == site.
	self assert: resource currentUrl = 'http://swazoo.org/'.</body>

<body package="Swazoo-Tests">testFileResourceSite
	| rs site resource |
	rs := ReadStream 
				on: '&lt;Site&gt;
&lt;SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''&gt;
 &lt;FileResource uriPattern: ''/'' filePath: ''files''&gt;
&lt;/Site&gt;'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	resource := site children first.
	self assert: resource class == FileResource.
	self assert: resource uriPattern = '/'.
	self assert: resource filePath = 'files'.
	self assert: resource parent == site.
	self assert: resource currentUrl = 'http://swazoo.org/'.</body>

<body package="Swazoo-Tests">testSiteTag
	| rs config tag |
	rs := ReadStream on: '  &lt;Site&gt;  

&lt;/Site&gt;   '.
	config := Site new.
	tag := config nextTagFrom: rs.
	self assert: tag = 'Site'.
	tag := config nextTagFrom: rs.
	self assert: tag = '/Site'.
	self assert: (config nextTagFrom: rs) isNil</body>

<body package="Swazoo-Tests">testMultipleResourcesSite
	| rs site resource1 resource2 |
	rs := ReadStream 
				on: '&lt;Site&gt;
 &lt;HelloWorldResource uriPattern: ''/''&gt;
 &lt;HelloWorldResource uriPattern: ''/''&gt;
&lt;/Site&gt;'.
	site := Site new readFrom: rs.
	self assert: site children size = 2.
	resource1 := site children first.
	self assert: resource1 class == HelloWorldResource.
	self assert: resource1 uriPattern = '/'.
	resource2 := site children last.
	self assert: resource2 class == HelloWorldResource.
	self assert: resource2 uriPattern = '/'</body>

<body package="Swazoo-Tests">testEmptySite
	| rs site alias |
	rs := ReadStream 
				on: '&lt;Site&gt;
 &lt;SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''&gt;
&lt;/Site&gt;'.
	site := Site new readFrom: rs.
	self assert: site aliases size = 1.
	self assert: site currentUrl = 'http://swazoo.org/'.
	alias := site aliases first.
	self assert: alias host = 'swazoo.org'.
	self assert: alias ip = '192.168.1.66'.
	self assert: alias port = 80</body>

<body package="Swazoo-Tests">testMultipleSites
	| rs sites site alias1 alias2 |
	rs := ReadStream 
				on: '&lt;Site&gt;
 &lt;SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''&gt;
 &lt;SiteIdentifier ip: ''192.168.1.66'' port: 81 host: ''swazoo.org''&gt;
&lt;/Site&gt;
&lt;Site&gt;
&lt;/Site&gt;'.
	sites := SwazooServer readSitesFrom: rs.
	self assert: sites size = 2.
	site := sites first.
	self assert: site aliases size = 2.
	alias1 := site aliases first.
	self assert: alias1 host = 'swazoo.org'.
	self assert: alias1 ip = '192.168.1.66'.
	self assert: alias1 port = 80.
	alias2 := site aliases last.
	self assert: alias2 host = 'swazoo.org'.
	self assert: alias2 ip = '192.168.1.66'.
	self assert: alias2 port = 81</body>

<body package="Swazoo-Tests">testCompositeResourceSite
	| rs site composite howdy duh hithere |
	rs := ReadStream 
				on: '&lt;Site&gt;
 &lt;CompositeResource uriPattern: ''/''&gt;
  &lt;HelloWorldResource uriPattern: ''howdy''&gt;
  &lt;CompositeResource uriPattern: ''duh''&gt;
   &lt;HelloWorldResource uriPattern: ''hithere''&gt;
  &lt;/CompositeResource&gt;
 &lt;/CompositeResource&gt;
&lt;/Site&gt;'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	composite := site children first.
	self assert: composite class == CompositeResource.
	self assert: composite uriPattern = '/'.
	self assert: composite children size = 2.
	self assert: composite parent == site.
	howdy := composite children first.
	self assert: howdy class == HelloWorldResource.
	self assert: howdy uriPattern = 'howdy'.
	self assert: howdy parent == composite.
	duh := composite children last.
	self assert: duh children size = 1.
	self assert: duh class == CompositeResource.
	self assert: duh uriPattern = 'duh'.
	self assert: duh parent == composite.
	hithere := duh children first.
	self assert: hithere class == HelloWorldResource.
	self assert: hithere uriPattern = 'hithere'.
	self assert: hithere parent == duh.</body>
</methods>


<methods>
<class-id>Swazoo.SwazooActivePageResourceTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	| fn |
	fn := 'sapTestDir' asFilename.
	fn makeDirectory.
	(fn construct: 'file.sap') writeStream close.
	(fn construct: 'file.html') writeStream close.
	resource := SwazooActivePageResource uriPattern: 'saps'
				filePath: 'sapTestDir'</body>

<body package="Swazoo-Tests">tearDown
	| fn |
	fn := 'sapTestDir' asFilename.
	(fn construct: 'file.sap') delete.
	(fn construct: 'file.html') delete.
	fn delete</body>
</methods>

<methods>
<class-id>Swazoo.SwazooActivePageResourceTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testInterpretedFile
	| request response |
	request := HTTPGet request: 'saps/file.sap'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200</body>

<body package="Swazoo-Tests">testUninterpretedFile
	| request response |
	request := HTTPGet request: 'saps/file.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil</body>
</methods>


<methods>
<class-id>Swazoo.URIResolutionTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testSiteMatch
	| request site visitor |
	request := HTTPGet 
				request: 'foo'
				from: 'localhost:1234'
				at: '1.2.3.4'.
	visitor := URIResolution new initializeRequest: request.
	site := Site new addAlias: (SiteIdentifier 
						ip: '1.2.3.4'
						port: 1234
						host: 'localhost').
	self assert: (visitor siteMatch: site)</body>

<body package="Swazoo-Tests">testSiteMismatch
	| request site visitor |
	request := HTTPGet 
				request: 'foo'
				from: 'localhost:1234'
				at: '1.2.3.4'.
	visitor := URIResolution new initializeRequest: request.
	site := Site new addAlias: (SiteIdentifier 
						ip: '1.2.3.4'
						port: 1234
						host: 'remotehost').
	self deny: (visitor siteMatch: site)</body>

<body package="Swazoo-Tests">testCompositeNoAnswer
	| resource request response |
	resource := CompositeResource uriPattern: 'base'.
	resource addResource: (HelloWorldResource uriPattern: 'hi').
	request := HTTPGet request: 'tail/hi'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil</body>

<body package="Swazoo-Tests">testTailPath
	| request resolution |
	request := HTTPGet 
				request: 'foo/bar/baz/quux'
				from: 'localhost:1234'
				at: '1.2.3.4'.
	resolution := URIResolution new initializeRequest: request.
	self 
		assert: resolution tailPath = #('bar' 'baz' 'quux') asOrderedCollection.
	resolution advance.
	self assert: resolution tailPath = #('baz' 'quux') asOrderedCollection.
	resolution advance.
	self assert: resolution tailPath = #('quux') asOrderedCollection.
	resolution advance.
	self assert: resolution tailPath isEmpty</body>

<body package="Swazoo-Tests">testStringMismatch
	| request visitor resource |
	request := HTTPGet request: 'foo'.
	visitor := URIResolution new initializeRequest: request.
	resource := HelloWorldResource uriPattern: 'Foo'.
	self deny: (visitor stringMatch: resource)</body>

<body package="Swazoo-Tests">testFirstCompositeChildWins
	| request hello goodbye response composite |
	composite := CompositeResource uriPattern: 'foo'.
	hello := HelloWorldResource new uriPattern: 'something.html'.
	goodbye := GoodbyeCruelWorld new uriPattern: 'something.html'.
	composite addResource: hello.
	composite addResource: goodbye.
	request := HTTPGet request: 'foo/something.html'.
	response := URIResolution resolveRequest: request startingAt: composite.
	self assert: response code = 200.
	self assert: request resourcePath size = 2.
	self assert: request resourcePath first = 'foo'.
	self assert: request resourcePath last = 'something.html'</body>

<body package="Swazoo-Tests">testStringMatch
	| request visitor resource |
	request := HTTPGet request: 'foo'.
	visitor := URIResolution new initializeRequest: request.
	resource := HelloWorldResource uriPattern: 'foo'.
	self assert: (visitor stringMatch: resource)</body>

<body package="Swazoo-Tests">testCompositeItselfCannotAnswer
	| resource request response |
	resource := CompositeResource uriPattern: 'base'.
	request := HTTPGet request: 'base'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil</body>

<body package="Swazoo-Tests">testCompositeAnswer
	| resource request response |
	resource := CompositeResource uriPattern: 'base'.
	resource addResource: (HelloWorldResource uriPattern: 'hi').
	request := HTTPGet request: 'base/hi'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 2.
	self assert: request resourcePath first = 'base'.
	self assert: request resourcePath last = 'hi'</body>

<body package="Swazoo-Tests">testNoAnswerWhenDisabled
	| resource request response |
	resource := HelloWorldResource uriPattern: 'hi'.
	resource disable.
	request := HTTPGet request: 'hi'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil</body>

<body package="Swazoo-Tests">testLeafAnswer
	| resource request response |
	resource := HelloWorldResource uriPattern: 'hi'.
	request := HTTPGet request: 'hi'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'hi'</body>

<body package="Swazoo-Tests">testSiteAnswer
	| resource request response |
	resource := Site new addAlias: (SiteIdentifier
					ip: '1.2.3.4'
					port: 80
					host: 'foo.com').
	resource addResource: (HelloWorldResource uriPattern: '/').
	request := HTTPGet
				request: '/'
				from: 'foo.com'
				at: '1.2.3.4'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = '/'</body>

<body package="Swazoo-Tests">testResourcePath
	| request resolution |
	request := HTTPGet 
				request: 'foo/bar/baz/quux'
				from: 'localhost:1234'
				at: '1.2.3.4'.
	resolution := URIResolution new initializeRequest: request.
	self assert: resolution resourcePath = #('foo') asOrderedCollection.
	resolution advance.
	self assert: resolution resourcePath = #('foo' 'bar') asOrderedCollection.
	resolution advance.
	self 
		assert: resolution resourcePath = #('foo' 'bar' 'baz') asOrderedCollection.
	resolution advance.
	self assert: resolution resourcePath = #('foo' 'bar' 'baz' 'quux') asOrderedCollection</body>
</methods>


<methods>
<class-id>Swazoo.HTTPRequestTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">test10ConnectionClose
	request := self basicGetHTTP10.
	self assert: request wantsConnectionClose</body>

<body package="Swazoo-Tests">testNo11ConnectionClose
	request := self basicGet.
	self deny: request wantsConnectionClose</body>

<body package="Swazoo-Tests">testPostRawEntity
	| requestStream post |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'POST /foobar HTTP/1.0';
		nextPutLine: 'Host: foo.com';
		nextPutLine: 'Content-Type: text/plain';
		nextPutLine: 'Content-Length: 12';
		crlf;
		nextPutLine: 'Hello, World'.
	post := HTTPRequest 
				readFrom: (SwazooTestStream on: requestStream contents).
	self assert: post postData isEmpty.
	self assert: post entityBody = 'Hello, World'</body>

<body package="Swazoo-Tests">testHeaderAtIfPresent
	request := self basicGet.
	self assert: (request headers 
				fieldOfClass: HTTPIfRangeField
				ifPresent: [:header | header == (request headers fieldOfClass: HTTPIfRangeField)]
				ifAbsent: [true]).
	self assert: (request headers 
				fieldOfClass: HTTPHostField
				ifPresent: [:header | header == (request headers fieldOfClass: HTTPHostField)]
				ifAbsent: [false])</body>

<body package="Swazoo-Tests">testBasicGet
	request := self basicGet.
	self assert: request isGet.
	self deny: request isHead.
	self deny: request isPost.
	self deny: request isPut</body>

<body package="Swazoo-Tests">testBasicGetHost
	request := self basicGet.
	self assert: request host = 'foo.com'</body>

<body package="Swazoo-Tests">testPortedGetPort
	request := self portedGet.
	self assert: request port = 8888</body>

<body package="Swazoo-Tests">testReferer
	request := self fullGet.
	self 
		assert: request referer asString = 'http://www.bar.com/takeMeThere.html'</body>

<body package="Swazoo-Tests">testUserAgent
	request := self fullGet.
	self 
		assert: request userAgent = 'Mozilla/4.72 [en] (X11; I; Linux 2.3.51 i686)'</body>

<body package="Swazoo-Tests">testBasicHead
	request := self basicHead.
	self assert: request isHead.
	self deny: request isGet.
	self deny: request isPost.
	self deny: request isPut</body>

<body package="Swazoo-Tests">testConnection
	request := self fullGet.
	self assert: request connection = 'Keep-Alive'</body>

<body package="Swazoo-Tests">testNoEqualsQueries
	"The last assert here used to check that 'request queryAt: 'WSDL'' is nil, but a test for an empty string is more consistent with query argument formats."

	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET /test/typed.asmx?WSDL HTTP/1.1';
		nextPutLine: 'Host: foo.com:8888';
		crlf.
	request := HTTPRequest readFrom: (ReadStream on: requestStream contents).
	self assert: (request includesQuery: 'WSDL').
	self assert: (request queryAt: 'WSDL') isEmpty</body>

<body package="Swazoo-Tests">test10KeepAliveConnectionClose
	request := self basicGetHTTP10Keepalive.
	self deny: request wantsConnectionClose</body>

<body package="Swazoo-Tests">testPostUrlEncodedData
	| requestStream post |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'POST / HTTP/1.1';
		nextPutLine: 'Host: foo.com';
		nextPutLine: 'Content-Type: application/x-www-form-urlencoded';
		nextPutLine: 'Content-Length: 31';
		crlf;
		nextPutLine: 'address=+fs&amp;product=&amp;quantity=1'.
	post := HTTPRequest 
				readFrom: (SwazooTestStream on: requestStream contents).
	self assert: (post postDataAt: 'address') value = ' fs'.
	self assert: (post postDataAt: 'product') value = ''.
	self assert: (post postDataAt: 'quantity') value = '1'</body>

<body package="Swazoo-Tests">testBasicGetPort
	request := self basicGet.
	self assert: request port = 80</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequestTest</class-id> <category>testing-bad requests</category>

<body package="Swazoo-Tests">test121MissingContentType
	| requestStream result |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'POST /foobar HTTP/1.0';
		nextPutLine: 'Host: foo.com';
"	      nextPutLine: 'Content-Type: text/plain'. &lt;---- this is missing! - and should be for this test"
		nextPutLine: 'Content-Length: 12';
		crlf;
		nextPutLine: 'Hello, World'.
	result := SpExceptionContext 
				for: [HTTPRequest readFrom: (SwazooTestStream on: requestStream contents)]
				on: SpError
				do: [:ex | ex].
	self assert: result class == SwazooHTTPPostError.
	^self</body>

<body package="Swazoo-Tests">test120RequestWithCRButNoLF
	| requestStream result |
	requestStream := WriteStream on: String new.
	requestStream
		nextPutAll: 'GET / HTTP/1.1';
		cr.
	result := SpExceptionContext 
				for: [HTTPRequest readFrom: (ReadStream on: requestStream contents)]
				on: SpError
				do: [:ex | ex].
	self assert: result class == SwazooHTTPParseError.
	^self</body>
</methods>

<methods>
<class-id>Swazoo.HTTPRequestTest</class-id> <category>private</category>

<body package="Swazoo-Tests">basicGetHTTP10Keepalive
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.0';
		nextPutLine: 'Connection: Keep-Alive';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)</body>

<body package="Swazoo-Tests">basicHead
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'HEAD / HTTP/1.1';
		nextPutLine: 'Host: foo.com';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)</body>

<body package="Swazoo-Tests">basicGetHTTP10
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.0';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)</body>

<body package="Swazoo-Tests">fullGet
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET /aaa/bbb/ccc.html?foo=bar&amp;baz=quux HTTP/1.1';
		nextPutLine: 'Connection: Keep-Alive';
		nextPutLine: 'User-Agent: Mozilla/4.72 [en] (X11; I; Linux 2.3.51 i686)';
		nextPutLine: 'Host: foo.com:8888';
		nextPutLine: 'Referer: http://www.bar.com/takeMeThere.html';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)</body>

<body package="Swazoo-Tests">portedGet
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.1';
		nextPutLine: 'Host: foo.com:8888';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)</body>

<body package="Swazoo-Tests">basicGet
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.1';
		nextPutLine: 'Host: foo.com';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)</body>

<body package="Swazoo-Tests">crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf</body>
</methods>


<methods>
<class-id>Swazoo.SwazooCacheControlTest</class-id> <category>running</category>

<body package="Swazoo-Tests">setUp
	| directory firstFile ws |
	directory := 'fResTest' asFilename.
	directory exists ifFalse: [directory makeDirectory].
	firstFile := directory construct: 'abc.html'.
	ws := firstFile writeStream.
	[ws nextPutAll: 'hello'] ensure: [ws close].
	resource := FileResource uriPattern: 'foo' filePath: 'fResTest'.
	request := HTTPGet request: 'foo/abc.html'.
	URIResolution resolveRequest: request startingAt: resource.
	cacheControl := SwazooCacheControl new request: request
				cacheTarget: (cacheTarget := resource fileFor: request)</body>

<body package="Swazoo-Tests">tearDown
	('fResTest' asFilename construct: 'abc.html') delete.
	'fResTest' asFilename delete</body>
</methods>

<methods>
<class-id>Swazoo.SwazooCacheControlTest</class-id> <category>testing</category>

<body package="Swazoo-Tests">testIfModifiedSinceNot
	| response |
	request headers addField: (HTTPIfModifiedSinceField new 
				valueFrom: cacheTarget lastModified asRFC1123String).
	self assert: cacheControl isNotModified.
	self assert: cacheControl isIfModifiedSince not.
	response := HTTPResponse notModified.
	cacheControl addResponseHeaders: response.
	self 
		assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified') date 
				= cacheTarget lastModified</body>

<body package="Swazoo-Tests">testIfModifiedSinceModified
	| response timestampInThePast |
	request := HTTPGet request: 'foo/abc.html'.
	timestampInThePast := SpTimestamp fromDate: (Date today subtractDays: 1)
				andTime: Time now.
	request headers addField: (HTTPIfModifiedSinceField new 
				valueFrom: timestampInThePast asRFC1123String).
	cacheControl := SwazooCacheControl new request: request
				cacheTarget: cacheTarget.
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfModifiedSince.
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self 
		assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified') date 
				= cacheTarget lastModified</body>

<body package="Swazoo-Tests">testIfNoneMatchHeaderMatch
	"same etag"

	| response |
	request headers addField: (HTTPIfNoneMatchField new addEntityTag: cacheTarget etag).
	self assert: cacheControl isNotModified.
	self deny: cacheControl isIfNoneMatch.

	"do NOT include last-modified"
	response := HTTPResponse notModified.
	cacheControl addResponseHeaders: response.
	self assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified' ifNone: [nil])  isNil</body>

<body package="Swazoo-Tests">testIfNoneMatchHeaderNone
	"same etag"

	| response |
	request := HTTPGet request: 'foo/abc.html'.
	request headers addField: (HTTPIfNoneMatchField new valueFrom: 'blah').
	cacheControl := SwazooCacheControl new request: request
				cacheTarget: cacheTarget.
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfNoneMatch.
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self 
		assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified') date 
				= cacheTarget lastModified</body>

<body package="Swazoo-Tests">testNoHeaders
	| response |
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfNoneMatch.
	self assert: cacheControl isIfModifiedSince.

	"add both"
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self 
		assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified') date 
				= cacheTarget lastModified</body>
</methods>



</st-source>
