"{ Encoding: utf8 }" !
!Collection methodsFor:'*Aida-Daily collections'!

allDailyCollectionDated: aDate
	"all on that date in any of daily collections"
	^self inject: OrderedCollection new into: [:col :each | col addAll: (each allDated: aDate). col]

"DailyCollection allInstances allDailyCollectionDated:
		DailyCollection allInstances allDailyCollectionDates asOrderedCollection last."
! !

!Collection methodsFor:'*Aida-Daily collections'!

allDailyCollectionDates
	"all dates which occur of any of daily collections"
	^self allDailyCollectionDays collect: [:each | Date fromDays: each].

"DailyCollection allInstances allDailyCollectionDates"
! !

!Collection methodsFor:'*Aida-Daily collections'!

allDailyCollectionDays
	"all day numbers which occur of any of daily collections"
	^self inject: Set new into: [:set :each | set addAll: each allDays. set].

"DailyCollection allInstances allDailyCollectionDays"
! !

!Collection methodsFor:'*Aida-Daily collections'!

allDailyCollectionEntries
	"sorted by date"
	| days |
	days := self allDailyCollectionDays.
	days := days asSortedCollection.
	^days inject: OrderedCollection new into: [:col :day |
		self do: [:daily | (daily days includesKey: day) ifTrue: [col addAll: (daily days at: day)] ].
		col].

"DailyCollection allInstances allDailyCollectionEntries"
! !

!Collection methodsFor:'*Aida-Daily collections'!

allDailyCollectionFromDate: aStartDate to: anEndDate
	"sorted by date"
	| startDay endDay daysInRange |
	startDay := aStartDate asDays. endDay := anEndDate asDays.
	daysInRange := self allDailyCollectionDays select: [:each | each >= startDay and: [each <= endDay] ].
	daysInRange := daysInRange asSortedCollection.
	^daysInRange inject: OrderedCollection new into: [:col :day |
		self do: [:daily | (daily days includesKey: day) ifTrue: [col addAll: (daily days at: day)] ].
		col].

"DailyCollection allInstances allDailyCollectionFromDate: (Date readSloFrom: '1.1.2004' readStream)
	to: (Date readSloFrom: '31.12.2006' readStream)"
! !

!Collection methodsFor:'*Aida-Daily collections'!

allDailyCollectionYear: aNumber
	^self
		allDailyCollectionFromDate: (SpDate newDay: 1 month: 1 year: aNumber)
		to: (SpDate newDay: 31 month: 12 year: aNumber)

"DailyCollection allInstances allDailyCollectionYear: 2004 "
! !

!Collection methodsFor:'*Aida-Daily collections'!

allDailyCollectionYears
	"all years on which occur of anything of daily collections. Sorted!!"
	^SortedCollection
		withAll: (self allDailyCollectionDates inject: Set new into: [:set :each | set add: each year. set])
		sortBlock: [:a :b | a < b].

"DailyCollection allInstances allDailyCollectionYears"
! !

!Collection methodsFor:'*Aida-Daily collections'!

allDailyCollectionYearsForKindOf: aClass
	"all years on which occur of anything of that class. Sorted!!"
	"optimize that!!"
	^(self inject: Set new into: [:set :each | set addAll: (each allYearsForKindOf: aClass). set])
		asSortedCollection

"DailyCollection allInstances allDailyCollectionYearsForKindOf: AIDA.Invoice"
! !

!String methodsFor:'*Aida'!

asCollectionOfHtmlHeadings
	"find all headings H1-5 and return a collection of headings, complete with tags"
	| in tag collection line |
	in := self readStream. collection := OrderedCollection new.
	[in atEnd] whileFalse:
		[in upTo: $<. in atEnd ifFalse: [tag := in upTo: $>].
		(tag size >= 2 and: [tag first asLowercase = $h and: [(tag at: 2) isDigit]] ) ifTrue:
			[tag := String with: $h with: (tag at: 2). "cleaned, without any parms!!"
			line := '<', tag, '>', (in upToAll: '</', tag, '>'), '</', tag, '>'.
			collection add: line] ].
	^collection

" '<h1>Heading1</h1><h2>Heading2</h2>' asCollectionOfHtmlHeadings"
" '<h1><b>Heading1</b></h1>' asCollectionOfHtmlHeadings"
! !

!String methodsFor:'*Aida'!

asSloveneWithoutCircumflexes
	"convert Unicode csz string with ^ (sumniki) to plain ascii csz"
	"'c^s^z^C^S^Z^' convertToSloveneChars asSloveneWithoutCircumflexes"
	^self collect:
		[:ch | ch asInteger > 127
			ifTrue:
				[ch = AIDASite charc ifTrue: [$c]
					ifFalse: [ ch  = AIDASite charC ifTrue: [$C]
					ifFalse: [ ch  = AIDASite chars ifTrue: [$s]
					ifFalse: [ ch  = AIDASite charS ifTrue: [$S]
					ifFalse: [ ch  = AIDASite charz ifTrue: [$z]
					ifFalse: [ ch  = AIDASite charZ ifTrue: [$Z]
					ifFalse: [$- ] ]]]]]
				]
			ifFalse: [ch] ]
! !

!String methodsFor:'*Aida'!

asWikiExceptLinksHtml
	"render this string in Wiki format (leave links in square brackets intact) and return Html"
	^WikiRender exceptLinksFrom: self
! !

!String methodsFor:'*Aida'!

asWikiHtml
	"render this string in Wiki format and return Html"
	^WikiRender from: self
! !

!String methodsFor:'*Aida'!

asWikiLinksOnlyHtml
	"render this string in Wiki format (links in square brackets only) and return Html"
	^WikiRender linksOnlyFrom: self
! !

!String methodsFor:'*Aida'!

contentsAsMethod
	"return a body of method with a literal array with contents of that string"
	| input output |
	input := self readStream.
	output := WriteStream with: String new.
	output nextPutAll: '^#('.
	[ [input atEnd] whileFalse: [output nextPutAll: input next asInteger asString; nextPut: $ ].
	output nextPutAll: ')' ]
		ensure: [input close].
	^output contents

" 'visual.cha'contentsAsMethod "
! !

!String methodsFor:'*Aida'!

convertToSloveneChars
	"convert csz string with ^ as 'sumnik' to proper unicode string"
	"'Mivs^ek' convertToSloveneChars"
	| in out ch |
	in := self readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[ch := in next.
		(in peek = $^ ) ifTrue: [(#($c $C $s $S $z $Z) includes: ch) ifTrue:
			[in next.
			ch = $c ifTrue: [ch := AIDASite charc]. ch = $C ifTrue: [ch := AIDASite charC].
			ch = $s ifTrue: [ch := AIDASite chars].         ch = $S ifTrue: [ch := AIDASite charS].
			ch = $z ifTrue: [ch := AIDASite charz]. ch = $Z ifTrue: [ch := AIDASite charZ] ] ].
		out nextPut: ch].
	^out contents
! !

!String methodsFor:'*Aida'!

ensureUnicodeSloveneChars
	"if string has other that unicode slovene chars, try to correct them!!"
	"'Miv©ek' ensureUnicodeSloveneChars"
	| in out ch uniSet |
	in := self readStream. out := WriteStream on: String new. uniSet := AIDASite charCszSet.
	[in atEnd] whileFalse:
		[ch := in next.
		(ch asInteger < 128 or: [uniSet includes: ch])
			ifTrue: [out nextPut: ch]
			ifFalse: [out nextPut:
				([(AIDASite convert: (String with: ch) fromCodepage: #'iso-8859-2') first]
					on: Error do: [:ex | ch]) ] ].
	^out contents
! !

!String methodsFor:'*Aida'!

isValidEMailAddress
	(self includes: $@) ifFalse: [^false].
	^(self trimBlanks contains: [:char |
		char isAlphaNumeric not and: [(#($. $- $_  $@) includes: char) not] ]) not

" 'janko.mivsek@eranova.si' isValidEMailAddress"
! !

!Collection methodsFor:'*Aida'!

isWebElement
	^true "more or less"
! !

!Collection methodsFor:'*Aida'!

isWebPage
	^false
! !

!Number methodsFor:'*Aida'!

printDotString
	"format and return the number with dots between thousandths:  '3.120.123' "
	| mrds millions thousanths rest text number |
	number := self abs.
	mrds := number // 1000000000.
	millions := (number \\ 1000000000)  // 1000000.
	thousanths := (number \\ 1000000) // 1000.
	rest := (number \\ 1000).
	text := ''.
	mrds > 0 ifTrue:
		[text := mrds printString, '.', (millions withZeros), '.',
		(thousanths withZeros), '.', (rest withZeros).
		^text].
	millions > 0    ifTrue:
		[text := millions printString, '.',
		(thousanths withZeros), '.', (rest withZeros).
		^text].
	thousanths > 0
		ifTrue:
			[text := thousanths printString, '.',
			(rest withZeros)]
		ifFalse: [text := rest printString].
	^(self < 0 ifTrue: ['- '] ifFalse: ['']), text

"
-123 printDotString  '- 123'
"
! !

!Collection methodsFor:'*Aida'!

printHTMLPageOn: aStream forSession: aSession
	"only inner html, for ajax element updates"
	self do: [:element |
		element notNil ifTrue: [element printHTMLPageOn: aStream forSession: aSession] ].
! !

!String methodsFor:'*Aida'!

trimBlanks
	^SpStringUtilities trimBlanksFrom: self
! !

!PositionableStream methodsFor:'*Aida'!

upToSeparator
	"Answer a subcollection from position to the occurrence (if any, exclusive) of a separator.
	The stream is left positioned after the separator.
	If no separator is found answer everything."

	| newStream element |
	newStream := collection class new writeStream.
	[self atEnd]
		whileFalse:
			[element := self next.
			element isSeparator
				ifTrue: [^newStream contents].
			newStream nextPut: element.].
	^newStream contents

" 'abc def' readStream upToSeparator"
! !

!String methodsFor:'*Aida'!

withHeadingAnchors
	"add anchors before all H1-5 tags, each with sequence number of that tag, eg: <a name=h-15>"
	| in out tag number |
	in := self readStream. number := 1.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[out nextPutAll: (in upTo: $<).
		in atEnd ifFalse: [tag := in upTo: $>] ifTrue: [tag := nil].
		(tag size = 2 and: [tag first asLowercase = $h and: [tag last isDigit]] ) ifTrue:
			[out nextPutAll: '<a name="h-', number printString, '"></a>'.
			number := number +1].
		tag notNil ifTrue: [out nextPutAll: '<', tag, '>']].
	^out contents

"'<h1>Heading1</h1><h2>Heading2</h2>' withHeadingAnchors"
! !

!String methodsFor:'*Aida'!

withHtmlBreaks
	"changes all cr with <br>"
	^self copyReplaceAll: (String with: Character cr) with: '<br>'

"('aaa', (String with: Character cr), 'bbb') withHtmlBreaks"
! !

!Number methodsFor:'*Aida'!

withZeros
	"return three digit number with leading zeros"
	^(self < 100 ifTrue: ['0'] ifFalse: ['']),
	(self < 10 ifTrue: ['0'] ifFalse: ['']),
	self printString.
! !

!String methodsFor:'*Aida'!

withoutHtmlTags
	"strip all tags, replace <br> and <p> with cr"
	| in out tag |
	in := self readStream.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[out nextPutAll: (in upTo: $<).
		in atEnd ifFalse: [tag := in upTo: $>].
		(tag = 'br') | (tag = 'p') ifTrue: [out nextPut: Character cr ] ].
	^out contents

"'<span>by Michael A. <br>Prospero</span>' withoutHtmlTags"
! !

