'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#HelloWorldResourceTest
	instanceVariableNames:'hello'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!HelloWorldResourceTest methodsFor:'running'!

setUp
	hello := HelloWorldResource uriPattern: 'hello.html'
! !

!HelloWorldResourceTest methodsFor:'testing'!

testResponse
	| request response |
	request := HTTPGet request: 'hello.html'.
	response := URIResolution resolveRequest: request startingAt: hello.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'hello.html'
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SpExceptionContext
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Exceptions'
!

SpExceptionContext comment:'Exceptions vary quite a bit between Smalltalk implementaions, despite the presence of the ANSI Smalltalk specification.  This class representss a portable exception context in which a block can be executed, exceptions trapped and handlers defined.'
!

!SpExceptionContext class methodsFor:'instance creation'!

for: aBlock on: anException do: exceptionBlock
	"^an Object
	I return the result of evaluating aBlock. In VisualWorks and other
	Smalltalks which are ANSI compliant, I delegate to aBlock."

	^aBlock on: anException do: exceptionBlock
!

for: aBlock onAnyExceptionDo: exceptionBlock
	"^an Object
	I execute aBlock and if there is any exception I evaluate exceptionBlock.
	Essentially, I look out for the most abstract kind of exception which ,
	of course, will vary between Smalltalk implementations."

	^aBlock on: Exception do: exceptionBlock
! !

!SpExceptionContext class methodsFor:'native exceptions'!

brokenPipeException
	"I return the exception that get's thrown when a socket connection gets
	broken."

	^ProtocolClientError
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Error subclass:#SpAbstractError
	instanceVariableNames:'parameter'
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Exceptions'
!

!SpAbstractError class methodsFor:'signalling'!

raiseSignal
	"Raise an an exception."
	^ self signal
!

raiseSignal: aString
	"Raise an an exception."
	^ self signal: aString
! !

!SpAbstractError class methodsFor:'testing'!

mayResume

	^false
! !

!SpAbstractError methodsFor:'accessing'!

errorString
	^self messageText
!

parameter
	^parameter 
!

parameter: anObject
	parameter := anObject
! !

!SpAbstractError methodsFor:'priv handling'!

isResumable
	"Determine whether an exception is resumable."

	^self class mayResume
! !

!SpAbstractError methodsFor:'signalling'!

raiseSignal
	"Raise an an exception."
	^ self signal
!

raiseSignal: aString
	"Raise an an exception."
	^ self signal: aString
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#HeaderField
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

HeaderField class instanceVariableNames:'httpFieldNameToClassDictionary'

"
 No other class instance variables are inherited by this class.
"
!

!HeaderField class methodsFor:'instance creation'!

fromLine: aString
	| sourceStream fieldName fieldValue fieldClass |
	sourceStream := ReadStream on: aString.
	fieldName := (HTTPString trimBlanksFrom: (sourceStream upTo: $:))
				asUppercase.
	fieldClass := self classForFieldName: fieldName.
	fieldValue := HTTPString trimBlanksFrom: sourceStream upToEnd.
	^fieldClass newForFieldName: fieldName withValueFrom: fieldValue
! !

!HeaderField class methodsFor:'private'!

classForFieldName: aString
	"^a Class
If I can find a specific header field with a name matching aString I return that.  Otherwise I return the GenericHeaderField class."

	^self httpFieldNameToClassDictionary at: aString
		ifAbsent: [GenericHeaderField]
!

httpFieldNameToClassDictionary
	"^a Class
I return the dictionarry of my subclasses keyed on the name of the field they represent.
Note that we only need *Request* headers listed in here because they are the only thing we will be parsing for."

	"After a change here, remeber to do 'HeaderField resetHttpFieldNameToClassDictionary' "

	httpFieldNameToClassDictionary isNil
		ifTrue:
			[| headerClasses |
			headerClasses := OrderedCollection new.
			headerClasses
				add: ContentDispositionField;
				add: HTTPContentLengthField;
				add: ContentTypeField;
				add: HTTPAcceptField;
				add: HTTPAuthorizationField;
				add: HTTPConnectionField;
				add: HTTPHostField;
				add: HTTPIfMatchField;
				add: HTTPIfModifiedSinceField;
				add: HTTPIfNoneMatchField;
				add: HTTPIfRangeField;
				add: HTTPIfUnmodifiedSinceField;
				add: HTTPRefererField;
				add: HTTPUserAgentField.
			httpFieldNameToClassDictionary := Dictionary new.
			headerClasses do:
					[:aClass |
					httpFieldNameToClassDictionary at: aClass fieldName asUppercase put: aClass]].
	^httpFieldNameToClassDictionary
!

newForFieldName: fieldNameString withValueFrom: fieldValueString
	^self subclassResponsibility
!

resetHttpFieldNameToClassDictionary

	httpFieldNameToClassDictionary := nil .
	^self
! !

!HeaderField methodsFor:'accessing'!

fieldName
	^self subclassResponsibility
!

name
	^self subclassResponsibility
!

values
	^self subclassResponsibility
! !

!HeaderField methodsFor:'printing'!

printOn: aStream
	aStream
		nextPutAll: self name;
		nextPutAll: ': '.
	self valuesAsStringOn: aStream.
	^self
!

valuesAsString
	| targetStream |
	targetStream := WriteStream on: String new.
	self valuesAsStringOn: targetStream.
	^targetStream contents
!

valuesAsStringOn: aStream
	^self subclassResponsibility
! !

!HeaderField methodsFor:'services'!

combineWith: aHeaderField
	SwazooHeaderFieldParseError raiseSignal: 'Not supported'
! !

!HeaderField methodsFor:'testing'!

isConditional
	^false
!

isContentDisposition
	^false
!

isContentType
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#HeaderFieldTest
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!HeaderFieldTest methodsFor:'testing'!

testCombine
	"Entity tags must be quoted strings - RFC 2616 3.11"

	| header1 header2 header3 |
	header1 := HeaderField fromLine: 'If-Match: "a"'.
	header2 := HeaderField fromLine: 'If-Match: "b","c"'.
	header3 := HeaderField fromLine: 'If-Match: "d"'.
	header1 combineWith: header2.
	self assert: header1 valuesAsString = '"a","b","c"'.
	header1 combineWith: header3.
	self assert: header1 valuesAsString = '"a","b","c","d"'
!

testContentTypeMultiple
	"   HTTP/1.1 header field values can be folded onto multiple lines if the
   continuation line begins with a space or horizontal tab. All linear
   white space, including folding, has the same semantics as SP. A
   recipient MAY replace any linear white space with a single SP before
   interpreting the field value or forwarding the message downstream.

       LWS            = [CRLF] 1*( SP | HT )"

	| requestStream request field |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.1';
		nextPutLine: 'Host: 127.0.0.1';
		nextPutLine: 'Content-Type: text/html; ';
		nextPutLine: ' charset=iso-8859-1';
		crlf.
	request := HTTPRequest readFrom: (ReadStream on: requestStream contents).
	field := request headers fieldNamed: 'content-type'.
	self assert: field name = 'Content-Type'.
	self assert: field mediaType = 'text/html'.
	self assert: (field transferCodings at: 'charset') = 'iso-8859-1'
!

testValues
	"Entity tags are held internally as simple strings.  Any necessary leading and trailing double quotes are added by the header fields as needed.  Note that it is OK to have a comma in an entity tag - see the second of the group of 3 tags below."

	| header |
	header := HeaderField fromLine: 'If-Match: "xyzzy" '.
	self assert: header name = 'If-Match'.
	self assert: header entityTags first = 'xyzzy'.
	header := HeaderField 
				fromLine: 'If-Match: "xyzzy", "r2d2,xxxx", "c3piozzzz" '.
	self assert: header name = 'If-Match'.
	self assert: header entityTags first = 'xyzzy'.
	self assert: (header entityTags at: 2) = 'r2d2,xxxx'.
	self assert: header entityTags last = 'c3piozzzz'
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpAbstractError subclass:#SpError
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Exceptions'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

HeaderField subclass:#SpecificHeaderField
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!SpecificHeaderField class methodsFor:'accessing'!

fieldName
	^self subclassResponsibility
! !

!SpecificHeaderField class methodsFor:'private'!

newForFieldName: fieldNameString withValueFrom: fieldValueString
	^self newWithValueFrom: fieldValueString
!

newWithValueFrom: fieldValueString
	^self new valueFrom: fieldValueString
! !

!SpecificHeaderField methodsFor:'accessing'!

name
	^self class fieldName
!

parameterAt: aString ifAbsent: aBlock
1 halt: 'use the transfer encodings of the field, not this'.
	^self parameters at: aString ifAbsent: aBlock
!

values
	^Array with: self value
! !

!SpecificHeaderField methodsFor:'initialize-release'!

valueFrom: fieldValueString
	self parseValueFrom: fieldValueString.
	^self
! !

!SpecificHeaderField methodsFor:'private'!

parseValueFrom: aString
	^self subclassResponsibility
!

readParametersFrom: sourceStream
	"^a Dictionary
c.f. RFC 2616 3.6 Transfer Codings"

	| parameters |
	parameters := Dictionary new.
	[sourceStream atEnd] whileFalse:
			[| attribute value |
			attribute := HTTPString trimBlanksFrom: (sourceStream upTo: $=).
			value := HTTPString trimBlanksFrom: (sourceStream upTo: $;).
			parameters at: attribute put: value].
	^parameters
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebHelpPage
	instanceVariableNames:'parent app view title body'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Parts'
!

WebHelpPage comment:'WebHelpPage contains help for particulal view on particular WebApp

Instance Variables:
	parent  <WebHelp>       back link to WebHelp
	app             <Symbol>        a name of WebApplication subclass
	view    <Symbol>        view of app for which is this help page
	title           <String>                title of that help page
	body    <String>                help content for that App and view in Wiki format

'
!

!WebHelpPage class methodsFor:'instance creation'!

newForApp: anAppNameSymbol view: aSymbol parent: aWebHelp
	^super new
		app: anAppNameSymbol;
		view: aSymbol;
		parent: aWebHelp
! !

!WebHelpPage methodsFor:'accessing'!

app
	^app
!

app: aSymbol
	app := aSymbol
!

body
	body isNil ifTrue: [^''].
	^body
!

body: aString
	body := aString
!

parent
	^parent
!

parent: aWebHelp
	parent := aWebHelp
!

preferedUrl
	^'/help/',  self app asString, '/', self view asString, '.html'
!

title
	title isNil ifTrue: [^''].
	^title
!

title: anObject
	title := anObject
!

view
	^view
!

view: aSymbol
	view := aSymbol
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#VersionedObjectTest
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Tests'
!

!VersionedObjectTest methodsFor:'testing'!

testFirstCreation
	| o |
	o := VersionedObject new.
	self assert: o versionNumber = '1'.
	self assert:  o isCurrentVersion.
	self assert:  o isOldestVersion.
	self assert:  o isNewestVersion.
	self assert:  o parentVersion isNil.
	self assert:  o nextVersion isNil.
!

testNewVersion
	| o o2 |
	o := VersionedObject new.
	o2 := o asNewVersion.
	self assert: o2 versionNumber = '2'.
	self deny:  o2 isCurrentVersion.
	self deny:  o2 isOldestVersion.
	self assert:  o2 isNewestVersion.
	self assert: o2 parentVersion == o.
!

testNewVersionOfExample
	| o o2 |
	o := VersionedExample new. o title: 'test'; body: 'this is test'.
	o2 := o asNewVersion.
	self assert: o2 title = o title.
	self assert: o2 body = o body.
!

testSearchByNumber
	| o1 o2 o3 |
	o1 := VersionedExample new. o1 title: 'first'. o2 := o1 asNewVersion. o2 title: 'second'.
	o3 := o2 asNewVersion. o3 title: 'third'.
	self assert: ((o2 versionWithNumber: '1') versionNumber = '1').
	self assert: ((o2 versionWithNumber: '2') versionNumber = '2').
	self assert: ((o2 versionWithNumber: '3') versionNumber = '3').
	self assert: ((o2 versionWithNumber: '4') isNil).
!

testVersionIncrement
	| o o2 |
	o := VersionedObject new. o versionNumber: '1234'.
	o2 := o asNewVersion.
	self assert: o2 versionNumber = '1235'.
! !

!VersionedObjectTest methodsFor:'testing-identity swap'!

testIdentityPreservation
	| o1 o2 c |
	o1 := VersionedExample new. o1 title: 'test'.
	o2 := o1 asNewVersion.  o2 title: 'sectest'.
	c := o1 currentVersion.
	self assert: c == o1.
	o2 setCurrentVersion.
	self assert: c == o1 currentVersion. "identity must be preserved!! "
!

testSetCurrent
	| o1 o2 |
	o1 := VersionedObject new. o2 := o1 asNewVersion.
	self assert:  o1 isCurrentVersion.
	self deny:  o2 isCurrentVersion.
	o2 setCurrentVersion.
	self assert:  o1 isCurrentVersion. "o1 and o2 identities are swapped!! "
	self deny:  o2 isCurrentVersion.
!

testSwap3Objects
	| o1 o2 o3 |
	o1 := VersionedExample new. o1 title: 'first'. o2 := o1 asNewVersion. o2 title: 'second'.
	o3 := o2 asNewVersion. o3 title: 'third'. o3 version setCurrent. "to debug more easily"
	self assert: o1 version next == o2.
	self assert: o2 version parent == o1. self assert: o2 version next == o3.
	self assert: o3 version parent == o2.
	o1 setCurrentVersion.
	self assert: o3 version next == o2. "test chain integrity"
	self assert: o2 version parent == o3. self assert: o2 version next == o1.
	self assert: o1 version parent == o2.
	self assert: o1 title = 'third'. self assert: o2 title = 'second'. self assert: o3 title = 'first'.
!

testSwap3Objects2
	| o1 o2 o3 |
	o1 := VersionedExample new. o1 title: 'first'. o2 := o1 asNewVersion. o2 title: 'second'.
	o3 := o2 asNewVersion. o3 title: 'third'.
	self assert: o1 version next == o2.
	self assert: o2 version parent == o1. self assert: o2 version next == o3.
	self assert: o3 version parent == o2.
	o3 setCurrentVersion.
	self assert: o3 version next == o2. "test chain integrity"
	self assert: o2 version parent == o3. self assert: o2 version next == o1.
	self assert: o1 version parent == o2.
	self assert: o1 title = 'third'. self assert: o2 title = 'second'. self assert: o3 title = 'first'.
!

testSwapIdentity
	| o1 o2 |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'.
	self assert: o1 isCurrentVersion.
	self assert: o1 title = 'first'. self assert: o2 title = 'second'.
	o2 setCurrentVersion.
	self assert: o1 isCurrentVersion. "because of identity swap!! "
	self assert: o1 title = 'second'. self assert: o2 title = 'first'.
!

testSwapIdentity2
	| o1 o2 s1 s2 |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'.
	s1 := o1 version. s2 := o2 version.
	self assert: s1 object title = 'first'. self assert: s2 object title = 'second'.
	o2 setCurrentVersion.
	"version chain order must be preserved!!"
	self assert: s1 object title = 'first'. self assert: s2 object title = 'second'.
!

testSwapIdentity3
	| o1 o2 |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'. o2 version setCurrent. "to debug more easily"
	o1 setCurrentVersion.
	self assert: o1 version object == o1. "check references to spec and back"
	self assert: o2 version object == o2.
	self assert: o1 version parent == o2. "test chain integrity"
	self assert: o2 version next == o1.
!

testSwapIdentity4
	| o1 o2 |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'.
	o2 setCurrentVersion.  "to test other part of VersionedObject swapIdentity"
	self assert: o1 version object == o1. "check references to spec and back"
	self assert: o2 version object == o2.
	self assert: o1 version parent == o2. "test chain integrity"
	self assert: o2 version next == o1.
! !

!VersionedObjectTest methodsFor:'testing-url links'!

testWebLink
	| o1 o2 link |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'.
	link := WebLink linkTo: o1.
	self assert: link ooReference == o1.
	self deny: (link parms includesKey: 'version').
	link := WebLink linkTo: o2.
	self assert: link ooReference == o1.  "o1 is current version!! "
	self assert: (link parms at: 'version') = '2'.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#HtmlRender
	instanceVariableNames:'source inputStream outputStream'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

HtmlRender comment:'For rendering formated text into HTML. Currently Wiki format supported (in WikRender subclass)

Thanks to WikiWorks authors for original code, which is adopted here!!
'
!

!HtmlRender class methodsFor:'instance creation'!

from: aString
	"render aString in Wiki syntax and return Html string"
	| stream |
	stream := WriteStream on: String new.
	self from: aString into: stream.
	^stream contents
!

from: aString into: aStream
	"only cr, convert cr-lf or lf to cr"
	| in out ch |

	in := aString readStream. out := (String new: aString size) writeStream.
	[in atEnd] whileFalse:
		[ch := in next.
		ch = Character cr ifTrue: [in peek = Character lf ifTrue: [in next]]. "skip"
		ch = Character lf ifTrue: [ch := Character cr].
		out nextPut: ch].
	^self new
		source: aString;
		inputStream: out contents readStream;
		outputStream: aStream;
		render.
! !

!HtmlRender methodsFor:'acessing'!

source
	"a source text to be parsed"
	^source
! !

!HtmlRender methodsFor:'html-tags'!

break
	self !!= '<br>'
!

bulletList: aBlock
	self startBulletList.
	aBlock value.
	self closeBulletList
!

closeBulletList
	self !!= '</ul>'
!

closeListItem
	self !!= '</li>'
!

closeNumberList
	self !!= '</ol>'
!

closeTableCell
	self !!= '</td>'
!

heading: aBlock
	self heading: aBlock level: 2
!

heading: aBlock level: anInteger
	self
		,= '<h';
		,= anInteger;
		,= ' ><font face="Arial" >'.
	aBlock value.
	self
		,= '</font></h';
		,= anInteger;
		!!= '>'
!

horizontalRule
	self !!= '<hr >'
!

inlineImage: aBlock
	self ,= '<img src="'.
	aBlock value.
	self !!= '" border="0" >'
!

italicize: aBlock
	self ,= '<i >'.
	aBlock value.
	self ,= '</i>'
!

linkTo: urlBlock titled: titleBlock
	self ,= '<a href="'.
	urlBlock value.
	self ,= '" >'.
	titleBlock value.
	self ,= '</a>'
!

listItem: aBlock
	self startListItem.
	aBlock value.
	self closeListItem
!

paragraph
	self !!= '<p >'
!

precise: aBlock
	self ,= '<pre >'.
	aBlock value.
	self !!= '</pre>'
!

startBulletList
	self ,= '<ul >'
!

startListItem
	self ,= '<li >'
!

startNumberList
	self ,= '<ol >'
!

startTableCell: align
	self ,= '<td align="'.
	self ,= align.
	self ,= '" >'
!

startTableRow
	self startTableRow: 'center'
!

startTableRow: align
	self ,= '<tr >'.
	self startTableCell: align
! !

!HtmlRender methodsFor:'initialize-release'!

inputStream: aStream
	inputStream := aStream
!

outputStream: aStream
	outputStream := aStream
! !

!HtmlRender methodsFor:'private'!

source: aString
	source := aString
! !

!HtmlRender methodsFor:'streaming'!

!!= anObject
	self
		,= anObject;
		cr.
	^anObject
!

,= anObject
	anObject class == Character ifTrue: [^outputStream nextPut: anObject].
	outputStream nextPutAll: anObject
"       ^anObject sendOver: outputStream"
!

cr
	outputStream cr.
!

space
	outputStream space
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:36'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpError subclass:#SwazooHTTPRequestError
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Exceptions'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebElement
	instanceVariableNames:'parent elements attributes other'
	classVariableNames:'Colors'
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebElement class methodsFor:'instance creation'!

new
	| instance |
	instance := super basicNew.
	self == WebElement ifTrue: [instance setCreationMethod].
	^instance
!

newClass: aSymbol
	"new with CSS class as specified"
	^self new class: aSymbol
!

newDiv
	"element enclosed in div tag"
	^self new setDiv
!

newId: aSymbol
	"new with id as specified"
	^self new id: aSymbol
! !

!WebElement class methodsFor:'color values'!

colorDictionary
	"return a dictionary of color names as keys and hex values for colors in
	some web elements such as page and table background, text, links etc."
	Colors isNil ifTrue: [self initColorDictionary].
	^Colors
!

initColorDictionary
	"WebElement initColorDictionary"
	"WebElement colorDictionary"
	Colors := IdentityDictionary new.
	Colors
		at: #white                              put: #'ffffff';
		at: #red                                        put: #'ff0000' ;
		at: #green                              put: #'00ff00' ;
		at: #blue                               put: #'0000ff' ;
		at: #magenda                    put: #'ff00ff';
		at: #cyan                               put: #'00ffff' ;
		at: #yellow                             put: #'ffff00' ;
		at: #black                              put: #'000000';

		at: #aquamarine                 put: #'70db93';

		at: #bakerschocolade    put: #'5c3317';
		at: #blueviolet put: #'9f5f9f';
		at: #brass              put: #'b5a642';
		at: #brightgold put: #'d9d919';
		at: #brown              put: #'a62a2a';
		at: #bronze             put: #'8c7853';
		at: #bronzeii           put: #'a67d3d';

		at: #cadetblue          put: #'5f9f9f';
		at: #coolcooper         put: #'d98719';
		at: #cooper                     put: #'b87333';
		at: #coral                      put: #'ff7f00';
		at: #cornflowerblue     put: #'42426f';

		at: #darkbrown          put: #'5c4033';
		at: #darkgreen          put: #'2f4f2f';
		at: #darkgreencooper put: #'4a766e';
		at: #darkolivegreen     put: #'4f4f2f';
		at: #darkorchid         put: #'9932cd';
		at: #darkpurple         put: #'871f78';
		at: #darkslateblue      put: #'6b238e';
		at: #darkslategrey      put: #'2f4f4f';
		at: #darktan                    put: #'97694f';
		at: #darkturquoise      put: #'7093db';
		at: #darkwood           put: #'855e42';
		at: #dimgrey            put: #'545454';
		at: #dustyrose          put: #'856363';

		at: #feldspar                   put: #'d19275';
		at: #firebrick                  put: #'8e2323';
		at: #forestgreen                put: #'238e23';

		at: #gold                       put: #'cd7f32';
		at: #goldenrod          put: #'dbdb70';
		at: #grey                       put: #'c0c0c0';
		at: #greencooper        put: #'527f76';
		at: #greenyellow                put: #'93db70';

		at: #huntergreen                put: #'215e21';

		at: #indianred          put: #'4e2f2f';

		at: #khaki                      put: #'9f9f5f';

		at: #lightblue          put: #'c0d9d9';
		at: #lightgrey          put: #'a8a8a8';
		at: #lightsteelblue     put: #'8f8fbd';
		at: #lightwood          put: #'e9c2a6';
		at: #limegreen          put: #'32cd32';

		at: #mandarianorange    put: #'e47833';
		at: #maroon                     put: #'8e236b';
		at: #mediumaquamarine   put: #'32cd99';
		at: #mediumblue put: #'3232cd';
		at: #mediumforestgreen  put: #'6b8e23';
		at: #mediumgoldenrod    put: #'eaeaae';
		at: #mediumorchid       put: #'9370db';
		at: #mediumseagreen     put: #'426f42';
		at: #mediumslateblue    put: #'7f00ff';
		at: #mediumspringgreen  put: #'7fff00';
		at: #mediumturquoise    put: #'70dbdb';
		at: #mediumvioletred            put: #'db7093';
		at: #mediumwood put: #'a68064';
		at: #midnightblue       put: #'2f2f4f';

		at: #navyblue           put: #'23238e ';
		at: #neonblue           put: #'4d4dff';
		at: #neonpink           put: #'ff6ec7';
		at: #newmidnightblue    put: #'00009c';
		at: #newtan                     put: #'ebc79e ';

		at: #oldgold                    put: #'cfb53b ';
		at: #orange                     put: #'ff7f00';
		at: #orangered          put: #'ff2400';
		at: #orchid                     put: #'db70db';

		at: #palegreen          put: #'8fbc8f';
		at: #pink                       put: #'bc8f8f';
		at: #plum                       put: #'eaadea';

		at: #quartz                     put: #'d9d9f3';

		at: #richblue                   put: #'5959ab';

		at: #salmon                     put: #'6f4242';
		at: #scarlet                    put: #'8c1717';
		at: #seagreen           put: #'238e68';
		at: #semiswetchocolate          put: #'6b4226';
		at: #sienna                     put: #'8e6b23';
		at: #silver                     put: #'e6e8fa';
		at: #skyblue                    put: #'3299cc';
		at: #slateblue          put: #'007fff';
		at: #spicypink          put: #'ff1cae';
		at: #springgreen                put: #'00ff7f';
		at: #steelblue          put: #'236b8e';
		at: #summersky          put: #'38b0de';

		at: #tan                                put: #'db9370';
		at: #thistle                    put: #'d8bfd8';
		at: #turquoise          put: #'adeaea';

		at: #verydarkbrown      put: #'5c4033';
		at: #verylightgrey      put: #'cdcdcd';
		at: #violet                     put: #'4f2f4f';
		at: #violetred          put: #'cc3299';

		at: #wheat                      put: #'d8d8bf';
		at: #yellowgreen                put: #'99cc32'.
!

valueForColor: aColorSymbolOrString
	"return a hex value for specified color. Case of color string is not important.
	return red if color is unknown"
	| color |
	color := aColorSymbolOrString asString asLowercase asSymbol.
	^self colorDictionary at: color ifAbsent: [^self colorDictionary at: #red].

"
WebElement valueForColor: 'blue'
"
! !

!WebElement class methodsFor:'printing'!

printWebPageFor: aSession

	"do a page of all colors in a color dicionary"

	| colors page table col |
	colors := self colorDictionary keys.
	page := WebPage new.
	page title: 'Web Color Table'.
	table := WebTable new.
	col := 0.
	table add: WebTableRow new.
	colors do: [:color |
		(col \\ 5 = 0) ifTrue: [table add: WebTableRow new]. col := col + 1.
		table add: (WebTableCell new bgColor: (self valueForColor: color);
			addBreak;
			addText: '<font face=helvetica size=-1>';
			addText: (color printString); addBreak;
			addText: ((self valueForColor: color) printString); addBreak;
			addText: (color printString) color: #white; addBreak;
			addText: ((self valueForColor: color) printString) color: #white; addBreak;
			addText: '</font>').
		].
	page add: table.
	^page

"WebElement printWebPageFor: (WebSession new)"
! !

!WebElement methodsFor:'accessing'!

app
	"return anApplication on which we are composing a web page"
	| object |
	self parent isNil ifTrue:
		[object := self firstAppFromStack.
		^object isNil ifTrue: [nil] ifFalse: [object ] ].
	^parent app
!

helpLink
	^self app helpLink
!

parent
	^parent
!

session
	"return a Session for which we are composing a web page"
	self parent isNil ifTrue: [^self app session].
	^parent session
!

site
	"return a Site on which we are composing a web page"
	| app |
	self parent isNil ifTrue:
		[app := self firstAppFromStack.
		^app isNil ifTrue: [nil] ifFalse: [app site] ].
	^parent site
!

style
	"return a WebStyle on which we are composing a web page"
	self parent isNil ifTrue: [^self firstSessionFromStack site style].
	^parent style
! !

!WebElement methodsFor:'adding ajax components'!

addDateInputFieldAspect: aSymbol for: anObject
	"with popup calendar"
	self add: (WebDateInputField new aspect:  aSymbol for: anObject)
!

addDelayedFieldAspect: aSymbol for: anObject
	"for Ajax instant posting, posting is done with a delay. Usefull for live-search fields"
	^self add: (WebDelayedField new aspect:  aSymbol for: anObject)
!

addDelayedFieldAspect: aSymbol for: anObject size: aNumber
	"for Ajax instant posting, posting is done with a delay. Usefull for live-search fields"
	^self add: ((WebDelayedField new aspect:  aSymbol for: anObject) size: aNumber)
!

addInPlaceEditableTextAspect: aSymbol for: anObject
	self add: (WebInPlaceEditableText aspect:  aSymbol for: anObject)
!

addInPlaceEditableTextAspect: aSymbol for: anObject size: aNumberOrPoint
	self add: (WebInPlaceEditableText aspect:  aSymbol for: anObject size: aNumberOrPoint)
!

addInPlaceEditableTextAspect: aSymbol for: anObject size: aNumberOrPoint allow: aBoolean
	self add:
		(WebInPlaceEditableText aspect:  aSymbol for: anObject size: aNumberOrPoint allow: aBoolean)
!

addRichEditorAspect: aSymbol for: anObject
	"JavaScript HTML WYSIWYG editor instead of textarea"
	self add: (WebRichEditor new aspect:  aSymbol for: anObject)
!

addRichEditorAspect: aSymbol for: anObject size: aPoint
	"JavaScript HTML WYSIWYG editor instead of textarea"
	self add: ((WebRichEditor new aspect:  aSymbol for: anObject) size: aPoint)
! !

!WebElement methodsFor:'adding form elements'!

addAspect: aSymbol for: anObject input: aBoolean size: aSizeNumberOrPoint

	"adds an auto converted text of aspect for that object. If imput argument is true, then add
	an input field or text area, depending in size (eg. size: 5 or size: 5@5)"

	aBoolean
		ifFalse:
			[self addText: (WebFormElement autoConvertToString: (anObject perform: aSymbol))]
		ifTrue:
			[(aSizeNumberOrPoint isKindOf: Number)
				ifTrue:
					[self add:
						(WebInputField new
							size: aSizeNumberOrPoint;
							aspect: aSymbol for: anObject)].
			(aSizeNumberOrPoint isKindOf: Point)
				ifTrue:
					[self add:
						(WebTextArea new
							size: aSizeNumberOrPoint;
							aspect: aSymbol for: anObject)]
			].
!

addButtonText: aString
	^self add: (WebButton text: aString)
!

addButtonText: aString action: aSymbol
	"for more than one buttons. Action method is a composed name from 'action', aView, Symbol.
	example: for view #main, action #addFolder is action method #actionMainAddFolder"
	^self add: (WebButton text: aString action: aSymbol)
!

addCheckboxAspect: aSymbol for: anObject
	"aspect method will be called and true/false will be set/clear on an object"
	^self add: (WebCheckBox aspect:  aSymbol for: anObject)
!

addCheckboxObject: anObject from: aCollection
	"if checked, this object will be put in collection. If object is initially in collection,
	checkbox will be checked. Usefull for easy selection among many objects"
	^self add: (WebCheckBox object: anObject from: aCollection)
!

addInputFieldAspect: aSymbol for: anObject
	^self add: (WebInputField new aspect:  aSymbol for: anObject)
!

addInputFieldAspect: aSymbol for: anObject size: aNumber
	^self add: ((WebInputField new aspect:  aSymbol for: anObject) size: aNumber)
!

addMenuAspect: aSymbol collection: aCollection selected: aSelectedCollection
	"Multiple selection menu.. Aspect of every element in aColection will be shown in menu.
	Selection will be put in aSelectedCollection. Here also an initial selection can be set"
	^self add: (WebMenu aspect: aSymbol collection: aCollection selected: aSelectedCollection)
!

addMenuAspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject
	"Single selection menu.. Aspect of every element in aColection will be shown in menu.
	Single selection will be put in an seelcted aspect of object. Here also initial selection can be set"
	^self add:
		(WebMenu aspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject)
!

addMenuCollection: aCollection selected: aSelectedCollection
	"Multiple selection menu..Every element (text!!) in aColection will be shown in menu.
	Selection will be put   in aSelectedCollection. Here also an initial selection can be set"
	^self add: (WebMenu collection: aCollection selected: aSelectedCollection)
!

addMenuCollection: aCollection selectedToAspect: aSymbol2 of: anObject
	"Single selection menu. Every element (text!!) in aColection will be shown in menu.
	Single selection will be put in an seelcted aspect of object. Here also initial selection can be set"
	^self add: (WebMenu collection: aCollection selectedToAspect: aSymbol2 of: anObject)
!

addPasswordFieldAspect: aSymbol for: anObject
	^self add: (WebInputField new type: #password; aspect:  aSymbol for: anObject)
!

addPasswordFieldAspect: aSymbol for: anObject size: aNumber
	^self add: ((WebInputField new type: #password; aspect:  aSymbol for: anObject) size: aNumber)
!

addTextAreaAspect: aSymbol for: anObject
	^self add: (WebTextArea new aspect:  aSymbol for: anObject)
!

addTextAreaAspect: aSymbol for: anObject size: aPoint
	^self add: ((WebTextArea new aspect:  aSymbol for: anObject) size: aPoint)
! !

!WebElement methodsFor:'adding images'!

addGif: aSymbol
	"this method will be called in your webStyle and this method
	should return a gif in byte array format"
	self add: (WebImage gif: aSymbol)
!

addGif: aSymbol size: aPoint
	"this method will be called in your webStyle and this method
	should return a gif in byte array format"
	self add: (WebImage gif: aSymbol size: aPoint)
!

addImage: anImageOrURL

	self add: (WebImage image: anImageOrURL)
!

addImage: anImageOrURL imageMap: aWebImageMap

	self add:
		((WebImage image: anImageOrURL)
			imageMap: aWebImageMap)
!

addImage: anImageOrURL size: aPoint

	self add: (WebImage image: anImageOrURL size: aPoint)
!

addImage: anImageOrURL size: aPoint align: aSymbol

	self add: ((WebImage image: anImageOrURL size: aPoint) align: aSymbol)
!

addImage: anImageOrURL size: aPoint valign: aSymbol

	self add: ((WebImage image: anImageOrURL size: aPoint) valign: aSymbol)
!

addJpeg: aSymbol
	"this method will be called in your webStyle and this method
	should return a gif in byte array format"
	self add: (WebImage jpeg: aSymbol)
!

addJpeg: aSymbol size: aPoint
	"this method will be called in your webStyle and this method
	should return a gif in byte array format"
	self add: (WebImage jpeg: aSymbol size: aPoint)
!

addLiveImage: aWebLiveImage

	self add:
		((WebImage image: aWebLiveImage)
			size: (aWebLiveImage width)@(aWebLiveImage height))
!

addLiveImage: aWebLiveImage imageMap: aWebImageMap

	self add:
		((WebImage image: aWebLiveImage)
			size: (aWebLiveImage width)@(aWebLiveImage height);
			imageMap: aWebImageMap)
!

addMethodImage: aWebMethodImage

	self add:
		(WebImage image: aWebMethodImage)
!

addMethodImage: aWebMethodImage size: aPoint

	self add:
		((WebImage image: aWebMethodImage) size: aPoint)
!

addPng: aSymbol
	"this method will be called in your webStyle and this method
	should return a png in byte array format"
	self add: (WebImage png: aSymbol)
!

addPng: aSymbol size: aPoint
	"this method will be called in your webStyle and this method
	should return a png in byte array format"
	self add: (WebImage png: aSymbol size: aPoint)
! !

!WebElement methodsFor:'adding links'!

addAnchorName: aString
	self add: (WebAnchor name: aString)
!

addLinkTo: anObject gif: aGifSymbol title: aString
	self add: ((WebLink linkTo: anObject) title: aString; addGif: aGifSymbol)
!

addLinkTo: anObject gif: aGifSymbol title: aString size: aPoint
	self add: ((WebLink linkTo: anObject) title: aString; addGif: aGifSymbol size: aPoint)
!

addLinkTo: anObject gif: aGifSymbol title: aString view: aViewSymbol
	self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) addGif: aGifSymbol)
!

addLinkTo: anObject gif: aGifSymbol title: aString view: aViewSymbol
	 parameter: aParmString value: aValueString

	self add: (((WebLink linkTo: anObject)
		title: aString; view: aViewSymbol;
		parameter: aParmString value: aValueString)
			addGif: aGifSymbol)
!

addLinkTo: anObject image: anImageOrURL
	self add: ((WebLink linkTo: anObject) addImage: anImageOrURL)
!

addLinkTo: anObject image: anImageOrURL parameter: aParmString value: aValueString
	self add: (((WebLink linkTo: anObject)
		parameter: aParmString value: aValueString) addImage: anImageOrURL)
!

addLinkTo: anObject image: anImageOrURL size: aPoint
	self add: ((WebLink linkTo: anObject) addImage: anImageOrURL size: aPoint)
!

addLinkTo: anObject image: anImageOrURL view: aViewSymbol
	self add: (((WebLink linkTo: anObject) view: aViewSymbol) addImage: anImageOrURL)
!

addLinkTo: anObject jpeg: aSymbol title: aString
	self add: ((WebLink linkTo: anObject) title: aString; addJpeg: aSymbol)
!

addLinkTo: anObject jpeg: aSymbol title: aString view: aViewSymbol
	self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) addJpeg: aSymbol)
!

addLinkTo: anObject message: aSymbol

	self add: (WebLink message: aSymbol  linkTo: anObject)
!

addLinkTo: anObject png: aPngSymbol title: aString
	self add: ((WebLink linkTo: anObject) title: aString; addPng: aPngSymbol)
!

addLinkTo: anObject png: aPngSymbol title: aString view: aViewSymbol
	self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) addPng: aPngSymbol)
!

addLinkTo: anObject png: aPngSymbol title: aString view: aViewSymbol
	 parameter: aParmString value: aValueString

	self add: (((WebLink linkTo: anObject)
		title: aString; view: aViewSymbol;
		parameter: aParmString value: aValueString)
			addPng: aPngSymbol)
!

addLinkTo: anObject text: aString

	self add: (WebLink text: aString  linkTo: anObject)
!

addLinkTo: anObject text: aString attributes: anArray

	self add: (WebLink text: aString  attributes: anArray linkTo: anObject)
!

addLinkTo: anObject text: aString header: aNumber
	self add: (WebLink text: aString  header: aNumber linkTo: anObject)
!

addLinkTo: anObject text: aString parameter: aParmString value: aValueString
	self add: (WebLink text: aString  linkTo: anObject
		parameter: aParmString value: aValueString)
!

addLinkTo: anObject text: aString
	parameter: a1ParmString value: a1ValueString
	parameter: a2ParmString value: a2ValueString

	self add: (WebLink text: aString  linkTo: anObject
		parameter: a1ParmString value: a1ValueString
		parameter: a2ParmString value: a2ValueString)
!

addLinkTo: anObject text: aString view: aViewString
	self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString; yourself)
!

addLinkTo: anObject text: aString view: aViewString  parameter: aParmString value: aValueString
	self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString;
		parameter: aParmString value: aValueString; yourself)
!

addLinkTo: anObject text: aString view: aViewString
		parameter: aParm1String value: aValue1String
		parameter: aParm2String value: aValue2String

	self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString;
		parameter: aParm1String value: aValue1String;
		parameter: aParm2String value: aValue2String; yourself)
!

addPDFLinkTo: anObject

	self add: ((WebLink linkTo: anObject) addGif: #pdfBigGif)
!

addSecureLinkTo: anObject text: aString

	self add: ((WebLink text: aString  linkTo: anObject) security: #grayed)
!

addSecureLinkTo: anObject
	text: aString parameter: aParmString value: aValueString

	self add: ((WebLink text: aString  linkTo: anObject
		parameter: aParmString value: aValueString) security: #grayed)
!

addSecureLinkTo: anObject text: aString view: aViewString
	self add: ((WebLink text: aString  linkTo: anObject
		view: aViewString) security: #grayed)
! !

!WebElement methodsFor:'adding other elements'!

addBreak

	self add: (WebSeparator break).
!

addComment: aString
	self add: (WebComment text: aString).
!

addErrorReport
	self add: self app errorReport
!

addHelpLink
	"link to help page for current view and App. If not exist, then nothing, exept for
	admin - link to creation of new help page"
	self add: self helpLink
!

addNbSp

	self addText: '&nbsp;'.
!

addNbSp: aNumber

	aNumber timesRepeat: [self addNbSp].
!

addPageBreak
	"for printing to printer, to break into a new page!!"
	self add: ((WebElement newClass: #pageBreak)
		addComment: 'Page break'; yourself).
!

addParagraph

	self add: (WebSeparator paragraph).
!

addRulerSize: aNumber

	self add: (WebSeparator rulerSize: aNumber).
! !

!WebElement methodsFor:'adding text'!

addSpace
	"just a simple space, nothing more"
	self addText: ' '
!

addText: aString

	self add: (WebText text: aString)
!

addText: aString attributes:  aSymbolArray

	self add: ((WebText text: aString) textAttributes: aSymbolArray)
!

addText: aString attributes:  aSymbolArray color: aColorSymbol

	self add: ((WebText text: aString) attributes: aSymbolArray; color: aColorSymbol)
!

addText: aString attributes:  aSymbolArray font: aFontString

	self add: ((WebText text: aString) attributes: aSymbolArray; font: aFontString)
!

addText: aString attributes:  aSymbolArray font: aFontString color: aColorSymbol

	self add: ((WebText text: aString)
		textAttributes: aSymbolArray; font: aFontString; color: aColorSymbol)
!

addText: aString  color: aColorSymbol

	self add: ((WebText text: aString)  color: aColorSymbol)
!

addText: aString font: aFontString

	self add: ((WebText text: aString) font: aFontString)
!

addText: aString  font: aFontString color: aColorSymbol

	self add: ((WebText text: aString)  font: aFontString; color: aColorSymbol)
!

addText: aString header: aNumber

	self add: ((WebText text: aString) header: aNumber)
!

addText: aString header: aNumber color:  aColorSymbol

	self add: ((WebText text: aString) header: aNumber; color:  aColorSymbol)
!

addText: aString header: aNumber font: aFontString

	self add: ((WebText text: aString) header: aNumber; font: aFontString)
!

addText: aString header: aNumber font: aFontString color: aColorSymbol

	self add: ((WebText text: aString)
		header: aNumber; font: aFontString; color: aColorSymbol)
!

addText: aString style: aStyleString

	self add: ((WebText text: aString) style: aStyleString)
!

addTextAspect: aSymbol for: anObject
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	self app inEditMode
		ifTrue: [self addInputFieldAspect: aSymbol for: anObject]
		ifFalse: [self addText: (anObject perform: aSymbol)]
!

addTextAspect: aSymbol for: anObject attributes: aSymbolOrArray
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	self app inEditMode
		ifTrue: [self addInputFieldAspect: aSymbol for: anObject]
		ifFalse: [self addText: (anObject perform: aSymbol) attributes: aSymbolOrArray]
!

addTextBig: aString
	self addText: '<big>', aString, '</big>'
!

addTextBold: aString
	self addText: aString attributes: #bold
!

addTextBoldAspect: aSymbol for: anObject
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	self addTextAspect: aSymbol for: anObject attributes: #bold
!

addTextCode: aString
	self addText: '<code>', aString, '</code>'.
!

addTextH1: aString
	self addText: aString header: 1
!

addTextH2: aString
	self addText: aString header: 2
!

addTextH3: aString
	self addText: aString header: 3
!

addTextH4: aString
	self addText: aString header: 4
!

addTextH5: aString
	self addText: aString header: 5
!

addTextItalic: aString
	self addText: aString attributes: #italic
!

addTextPreformated: aString
	self addText: '<pre>', aString, '</pre>'.
!

addTextSmall: aString
	self addText: '<small>', aString, '</small>'
! !

!WebElement methodsFor:'attributes'!

align: aSymbol
	"element alignment #left #center #right"
	self attributesAt: #align put: aSymbol asString
!

class: aSymbol
	"style class of that element. Used for Cascaded Style Sheets"
	self attributesAt: #class put: aSymbol
!

id
	^self attributesAt: #id
!

id: aSymbol
	"set a unique id of that element on a page. Used in javascript, urls, style sheets"
	| app |
	app := self app.
	self id notNil ifTrue: [(app form isRegistered: self) ifTrue: [app form removeId: self id]].
	self attributesAt: #id put: aSymbol asSymbol.
	app form registerIdFor: self.
!

registerId
	"put into current form ids dictionary for faster search from AJAX requests"
	self id notNil ifTrue: [^nil]. "must be already registered!! "
	self app notNil ifTrue: [self app form registerIdFor: self]
!

setDiv
	self div: true
!

style: aString
	"redefine a style of that element with CSS syntax, example:
	style: '{color: blue; font-style: italic}'   "
	self attributesAt: #style put: aString
!

title: aString
	"title of an element. it will be shown when mouse pause over it"
	self attributesAt: #title put:
		"slovene csz are converted if char ^ is after such a char"
		((aString includes: $^ ) ifTrue: [aString convertToSloveneChars] ifFalse: [aString])
! !

!WebElement methodsFor:'events'!

onClick: aJavascriptCode
	self attributesAt: #onClick add: aJavascriptCode
!

onDblClick: aJavascriptCode
	self attributesAt: #onDblClick add: aJavascriptCode
!

onKeyDown: aJavascriptCode
	self attributesAt: #onKeyDown add: aJavascriptCode
!

onKeyPress: aJavascriptCode
	self attributesAt: #onKeyPress add: aJavascriptCode
!

onKeyUp: aJavascriptCode
	self attributesAt: #onKeyUp add: aJavascriptCode
!

onMouseDown: aJavascriptCode
	self attributesAt: #onMouseDown add: aJavascriptCode
!

onMouseMove: aJavascriptCode
	self attributesAt: #onMouseMove add: aJavascriptCode
!

onMouseOut: aJavascriptCode
	self attributesAt: #onMouseOut add: aJavascriptCode
!

onMouseOver: aJavascriptCode
	self attributesAt: #onMouseOver add: aJavascriptCode
!

onMouseUp: aJavascriptCode
	self attributesAt: #onMouseUp add: aJavascriptCode
! !

!WebElement methodsFor:'events-ajax'!

hide
	"hide me from web page"
	self registerId.
	self addText: '<script>Element.hide(''', self id, ''')</script>'
!

onClickHide: anElementOrId
	"hide specified element on mouse click on me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.hide(''', idSymbol asString, ''')'.
!

onClickShow: anElementOrId
	"show specified element on mouse click on me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.show(''', idSymbol asString, ''')'.
!

onClickToggle: anElementOrId
	"toggle visibility of specified element on mouse click on me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.toggle(''', idSymbol asString, ''')'.
!

onClickUpdate: anElementOrId
	"update (and show if not yet) a specified element from server (AJAX)"
	self onClickUpdate: anElementOrId with: nil
!

onClickUpdate: anElementOrId with: aParmString
	"update a specified element from server (AJAX) wtih calling an element method with a parameter"
	| idSymbol url parms  |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	url := self ajaxCallUrl.
	parms:= self ajaxCallUrlParametersFor: anElementOrId.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	self onClick: 'new Ajax.Updater(''', idSymbol asString, ''', ''', url,
		''', {method: ''post'', postBody: ''', parms, ''', evalScripts: true})'
!

onMouseOutHide: anElementOrId
	"hide specified element when mouse get out of me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOut: 'Element.hide(''', idSymbol asString, ''')'.
!

onMouseOutShow: anElementOrId
	"show specified element when mouse get out of me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOut: 'Element.show(''', idSymbol asString, ''')'.
!

onMouseOutUpdate: anElementOrId
	"update (and show if not yet) a specified element from server (AJAX)"
	self onMouseOutUpdate: anElementOrId with: nil
!

onMouseOutUpdate: anElementOrId with: aParmString
	"update a specified element from server (AJAX) wtih calling an element method with a parameter"
	| idSymbol url parms  |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	url := self ajaxCallUrl.
	parms:= self ajaxCallUrlParametersFor: anElementOrId.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	self onMouseOut: 'new Ajax.Updater(''', idSymbol asString, ''', ''', url,
		''', {method: ''post'', postBody: ''', parms, ''', evalScripts: true})'
!

onMouseOverHide: anElementOrId
	"hide specified element when mouse come over me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOver: 'Element.hide(''', idSymbol asString, ''')'.
!

onMouseOverShow: anElementOrId
	"show specified element when mouse come over me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOver: 'Element.show(''', idSymbol asString, ''')'.
!

onMouseOverSyncUpdate: anElementOrId
	"update (and show if not yet) a specified element from server (AJAX)"
	"wait until AJAX response returns (synchronous update)"
	self onMouseOverSyncUpdate: anElementOrId with: nil
!

onMouseOverSyncUpdate: anElementOrId with: aParmString
	"update a specified element from server (AJAX) wtih calling an element method with a parameter"
	"wait until AJAX response returns (synchronous update)"
	| idSymbol url parms  |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	url := self ajaxCallUrl.
	parms:= self ajaxCallUrlParametersFor: anElementOrId.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	self onMouseOver: 'new Ajax.Updater(''', idSymbol asString, ''', ''', url,
		''', {method: ''post'', postBody: ''', parms, ''', evalScripts: true, asynchronous: false})'
!

onMouseOverUpdate: anElementOrId
	"update (and show if not yet) a specified element from server (AJAX)"
	self onMouseOverUpdate: anElementOrId with: nil
!

onMouseOverUpdate: anElementOrId with: aParmString
	"update a specified element from server (AJAX) wtih calling an element method with a parameter"
	| idSymbol url parms  |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	url := self ajaxCallUrl.
	parms:= self ajaxCallUrlParametersFor: anElementOrId.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	self onMouseOver: 'new Ajax.Updater(''', idSymbol asString, ''', ''', url,
		''', {method: ''post'', postBody: ''', parms, ''', evalScripts: true})'
!

show
	"show me (if not already) on web page"
	self registerId.
	self addText: '<script>Element.show(''', self id, ''')</script>'
!

toogle
	"toogle element visibility on  web page"
	self registerId.
	self addText: '<script>Element.toggle(''', self id, ''')</script>'
!

updateEverySeconds: aNumber
	"periodically update itself from server (AJAX) with calling an element method with a parameter"
	self updateEverySeconds: aNumber with: nil
!

updateEverySeconds: aNumber with: aParmString
	"periodically update itself from server (AJAX) with calling an element method with a parameter"
	| url parms  |
	self registerId. self id.
	url := self ajaxCallUrl.
	parms:= self ajaxCallUrlParametersFor: self id.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	self scriptAfter: 'new Ajax.PeriodicalUpdater(''', self id asString, ''', ''', url,
		''', {method: ''post'', postBody: ''', parms,
		''', evalScripts: true, frequency: ', aNumber printString, '})'
! !

!WebElement methodsFor:'initialize-release'!

initAttributes
	attributes := Dictionary new.
!

initElements
	elements := OrderedCollection new.
!

initOther
	other := Dictionary new.
!

initScriptBefore
	self other removeKey: #scriptBefore ifAbsent: []
!

initTable
	"just remove from other, later will be initalized lazily"
	self other isNil ifTrue: [^nil].
	self other
		removeKey: #currentTable ifAbsent: [];
		removeKey: #currentRow ifAbsent: [];
		removeKey: #currentCell ifAbsent: [].
!

initTableIfNessesary
	"if not already exist"
	self otherAt: #currentTable ifAbsent: [self newTable]
! !

!WebElement methodsFor:'printing'!

prepareAttributesToPrintOn: aSession
	"override if you like to change or otherwise prepare attribute values"
!

prepareToHTMLPrintOn: aSession
	"all preparations just before html rendering"
	self prepareAttributesToPrintOn: aSession.  "some pre-html preparation of values"
!

printAttribute: aNameSymbol value: aValue on: aStream for: aSession
	"if value is true/false, then if true, just print an atribute name, otherwise ommit both"
	"multivalue attributes are supposed to be javascript only!! "
	| multiValue |
	aStream nextPut:  $ .
	((aValue ~= false) | (aValue == true)) ifTrue: [aStream nextPutAll: aNameSymbol asString].
	(aValue isKindOf: Boolean) ifTrue: [^self].
	multiValue := aValue class == OrderedCollection.    aStream nextPutAll: '="'.
	multiValue not ifTrue: [aStream
		nextPutAll: (AIDASite convertToWeb: aValue asString on: aSession); nextPutAll: '"'. ^self].
	aValue do: [:value |
		aStream nextPutAll:  (AIDASite convertToWeb: value asString on: aSession).
		aStream nextPutAll: '; ']. "javascript sentence separator"
	aStream nextPutAll: '"'.
!

printAttributesOn: aStream for: aSession
	"start and end of tag is not my responsibility!!"
	self attributes isNil ifTrue: [^self].
	self attributes keysAndValuesDo: [:name :value |
		self printAttribute: name value: value on: aStream for: aSession]
!

printHTMLPageOn: aStream forSession: aSession
	"WebElement with some attributes is enclosed inside <div> tag, for tricks with CSS"
	self prepareToHTMLPrintOn: aSession.
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	self insideDivTag ifTrue:
		[aStream nextPutAll: self ident, '<div'. self printAttributesOn: aStream for: aSession.
		aStream nextPutAll: '>', self eol].
	elements notNil ifTrue: [elements do: [:element |
		element notNil ifTrue: [element printHTMLPageOn: aStream forSession: aSession] ] ].
	self insideDivTag ifTrue: [aStream nextPutAll: self ident, '</div>', self eol].
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].
! !

!WebElement methodsFor:'private'!

adaptFormElements
	"in case of AJAX request, otherwise WebForm should do that!! "
	self isFormElement ifTrue: [self adapt].
	self elements do: [:each | each adaptFormElements]
!

cell: aWebTableCell
	self initTableIfNessesary.
	self otherAt: #currentCell put: aWebTableCell.
!

colorValue: aColorSymbol
	"Hex number format is: #rrbbgg if not in that format, then it can be a color name as defined in
	class variable Colors (class method initColorDictionary). If unknown color, then attribute is set to nil"
	| attribute |
	attribute := aColorSymbol asString asLowercase asSymbol.
	attribute := WebElement colorDictionary at: attribute ifAbsent:
		[attribute asString do: [:chr |
			(chr isDigit or: [chr asInteger between: $a asInteger and: $f asInteger]) ifFalse: [^self] ] ].
	^'#', (attribute asString copyWithout: $# )

"WebElement new colorValue: #red"
!

div
	^self otherAt: #divElement ifAbsent: [false]
!

div: aBoolean
	"if an element is DIV tag"
	self otherAt: #divElement put: aBoolean
!

elements
	elements isNil ifTrue: [self initElements].
	^elements
!

form
	"aWebForm on which that element was created. Used for form element model adapting.
	Usually an app form for view, on which this element was created.
	Use it in conjunction with #method for Ajax"
	^self otherAt: #form ifAbsent:
		[self parent notNil
			ifTrue: [self parent form]
			ifFalse: [nil]  ] "maybe app form?"
!

form: aSymbol
	"form on which that element was created. Used for form element model adapting"
	"Usually an app form for view, on which this element was created."
	self otherAt: #form put: aSymbol
!

insideDivTag
	"to enclose or not in div tag. Only if element have any attribute!!"
	^self div | (self class == WebElement and: [self attributes notNil]).
!

method
	"a method which created this element, always from some App.
	Valid only for aWebElement, never for its subclasses!!"
	^self otherAt: #method ifAbsent: [nil]
!

method: aSymbol
	"a method which created this element, always from some App.
	Valid only for aWebElement, never for its subclasses!!"
	self otherAt: #method put: aSymbol.
	self form: self app form
!

parent: aWebElement
	parent := aWebElement
!

row: aWebTableRow
	self initTableIfNessesary.
	self otherAt: #currentRow put: aWebTableRow.
!

scriptAfter
	^self otherAt: #scriptAfter ifAbsent: [nil]
!

scriptBefore
	^self otherAt: #scriptBefore ifAbsent: [nil]
!

setCreationMethod
	"find a name of a method which created me"
	| context |
	context := thisContext.
	[context notNil] whileTrue: [
		(context receiver isKindOf: WebApplication) ifTrue: [^self method: context selector].
		context := context sender].
!

table: aWebTable
	self otherAt: #currentTable put: aWebTable.
! !

!WebElement methodsFor:'private-ajax'!

ajaxCallUrl
	"relative url of an app observee object. This url is used for AJAX calls back to the server"
	| app object |
	app := self app.
	object := app observee isVersionedObject
		ifTrue: [app observee currentVersion] ifFalse: [app observee].
	^app site urlResolver halfUrlFor: object
!

ajaxCallUrlExtended
	"relative url of an app observee object. This url is used for AJAX calls back to the server"
	"also includes 'ajaxRequest' in query part, to distinguish ajax request from others"
	| viewParm versionParm |
	viewParm := 'view=', self form view asString.
	versionParm := ''.
	self app observee isVersionedObject ifTrue:
		[self app observee isCurrentVersion ifFalse:
			[versionParm := 'version=' self app observee versionNumber, '&'] ].
	^self ajaxCallUrl, '?', viewParm, '&', versionParm, 'ajaxRequest'
!

ajaxCallUrlParametersFor: anElementOrId
	"ajax url must have 'ajaxRequest' parm in query part!! Deal also with versioned objects"
	| idSymbol ajaxForm viewParm versionParm |
	idSymbol := anElementOrId isSymbol
		ifTrue: [ajaxForm := self form. anElementOrId]
		ifFalse: [anElementOrId isNil
			ifTrue: [ajaxForm := self app form. #nil]
			ifFalse: [ajaxForm := anElementOrId form.
				anElementOrId registerId. anElementOrId id] ].
	viewParm := 'view=', ajaxForm view asString.
	versionParm := ''.
	self app observee isVersionedObject ifTrue:
		[self app observee isCurrentVersion
			ifFalse: [versionParm := 'version=', self app observee versionNumber, '&'] ].
	^viewParm, '&', versionParm, 'ajaxRequest&ajaxGetElementId=', idSymbol asString
! !

!WebElement methodsFor:'private-attributes'!

attributes
	^attributes
!

attributesAt: aSymbol
	self attributes isNil ifTrue: [^nil].
	^self attributes at: aSymbol ifAbsent: [nil]
!

attributesAt: aSymbol add: aString
	"some attributes can have more than one value (like javascript for events)"
	self attributes isNil ifTrue: [self initAttributes].
	(self attributes at: aSymbol ifAbsentPut: [OrderedCollection new]) add: aString
!

attributesAt: aSymbol put: aString
	self attributes isNil ifTrue: [self initAttributes].
	self attributes at: aSymbol put: aString
! !

!WebElement methodsFor:'private-identation'!

eol
	self setNewline.
	^String with: Character cr with: Character lf.
!

ident
	"ident this tag to its level"
	| depth eol|
	eol := ''.
	self shouldIdent & self isNewline not ifTrue: [eol := self eol].
	depth := (self identationLevel - self identDepth) max: 0.
	self identDepth: self identationLevel.
	^eol, (String new: depth withAll: Character tab )
!

identDepth
	"how idented we are"
	| app |
	app := self app.
	^app notNil ifTrue: [app identDepth] ifFalse: [0].
!

identDepth: aNumber
	"how idented we are"
	| app |
	app := self app.
	^app isNil ifTrue: [0] ifFalse: [app identDepth: aNumber]
!

identMore
	"ident inside tag content to its level and one deepier"
	self isNewline ifFalse: [self eol].
	self identDepth: self identationLevel+1.
	^String new: self identationLevel+1 withAll: $ 
!

identationLevel
	"How much we need to ident. Top element has level 0"
	^self parent notNil
		ifTrue: [self shouldIdent ifTrue: [self parent identationLevel + 1] ifFalse: [self parent identationLevel]]
		ifFalse: [0]
!

isNewline
	"are we at start of new line?"
	| app |
	app := self app.
	^app notNil ifTrue: [app isNewline] ifFalse: [false]
!

level
	"How deep we are in element hierarchy. Top element has level 0"
	^self parent notNil
		ifTrue: [self parent level + 1]
		ifFalse: [0]
!

setNewline
	"we are no longer at start of line"
	| app |
	app := self app.
	app notNil ifTrue: [app setNewline].
!

shouldIdent
	"true, if this element should be idented in html page"
	^self insideDivTag
! !

!WebElement methodsFor:'private-other'!

other
	^other
!

otherAt: aSymbol
	^self otherAt: aSymbol ifAbsent: [nil]
!

otherAt: aSymbol ifAbsent: aBlock
	self other isNil ifTrue: [^aBlock value].
	^self other at: aSymbol ifAbsent: aBlock
!

otherAt: aSymbol ifAbsentPut: aBlock
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol ifAbsent: [self other at: aSymbol put: aBlock value]
!

otherAt: aSymbol put: anObject
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol put: anObject
! !

!WebElement methodsFor:'scripts'!

script: aString
	"add this JavaScript  to scripts executed after this element"
	self scriptAfter: aString
!

scriptAfter: aString
	"add this JavaScript  to scripts executed after this element"
	(self otherAt: #scriptAfter ifAbsentPut: [WebScript new]) script: aString
!

scriptBefore: aString
	"add this JavaScript  to scripts executed before this element"
	(self otherAt: #scriptBefore ifAbsentPut: [WebScript new]) script: aString
! !

!WebElement methodsFor:'subelements'!

add: aWebElement
	"Include new element as one of the receiver's elements.  Answer aWebElement.
	If you nest a web page into another web page, then add only elements of it"
	self checkAndInitElements.  "if not composite element, then error"
	"if nested web pages then add elements without header"
	(aWebElement isKindOf: WebApplication) ifTrue: [^self halt].
	((aWebElement isKindOf: WebPage) and: [self isKindOf: WebPage])
		ifTrue: [^elements add: aWebElement elements].
	aWebElement parent: self.
	^elements add: aWebElement.
!

allElements
	"get a collection of all subelements of elements down in a hierarcy of this element"
	| collection |
	collection := OrderedCollection new.
	self elements notNil ifTrue:
		[collection addAll: self elements.
		self elements do: [:each | collection addAll: each allElements] ].
	^collection

"
| el |
el := WebElement new.
el add: (WebLink image: nil  linkTo: nil).
el add: (WebText text: 'aaa').
el allElements.
"
!

allElementsOfClass: aClass

"returns a collection of subelements of given class, actualy type of an element. Broswe entire hierarchy of that element"

	| found |
	found := OrderedCollection new.
	(self class = aClass) ifTrue: [found add: self].
      (self elements isKindOf: Collection)
		ifTrue: [self elements do:
			[:element | found addAll: (element allElementsOfClass: aClass)]]
		ifFalse:
			[(self elements isKindOf: WebElement)   "nil or other excluded"
				ifTrue: [found addAll:       "only one element"
					(self elements allElementsOfClass: aClass)]].
	^found
!

allOOLinks
	"return collection of all objects to which this page has a link"
	| ooLinks |
	ooLinks := self allElements select: [:element |
		(element isKindOf: WebLink) and: [element ooReference notNil] ].
	^ooLinks collect: [:each | each ooReference].

"
| el |
el := WebElement new.
el add: (WebLink linkTo: Date today); addText: 'aaaa'.
el allOOLinks
"
!

clear
	"remove all subelements"
	self initElements.
!

first
	"Answer the first element.  If the receiver is empty, provide an error
	notification."

	self checkAndInitElements.  "if not composite element, then error"
	^elements first
!

last
	"Answer the last element.  If the receiver is empty, create an error notification."

	self checkAndInitElements.  "if not composite element, then error"
	^elements last
! !

!WebElement methodsFor:'tables'!

cell
	"return a current table cell"
	self initTableIfNessesary.
	^self otherAt: #currentCell
!

clearTableInfo
	"clear all table information"
	self initTable
!

newCell
	"add a new cell to current table row. Return a new WebTableCell so that you can send messages
	to it immediatelly - color, width, addText etc."
	self cell: WebTableCell new.
	self row add: self cell.
	^self cell
!

newRow
	"add a new row to current table. Return a new WebTableRow so that you can send messages
	to it immediatelly - color, width etc. Also reset current row and current cell to a new ones. "
	self row: WebTableRow new.
	self table add: self row.
	self newCell.
	^self row
!

newTable
	"add a new table to this element. Return a new WebTable so that you can send messages
	to it immediatelly - color, width etc. Also reset current row and current cell to a new ones. "
	self table: WebTable new.
	self add: self table.
	self newRow.
	^self table
!

row
	"return a current table row"
	self initTableIfNessesary.
	^self otherAt: #currentRow
!

table
	"return a current web table. If not yet exist, create it"
	self initTableIfNessesary.
	^self otherAt: #currentTable
! !

!WebElement methodsFor:'testing'!

checkAndInitElements

	"lazy initialization od elements, when needed. Only for composite elements, else error"

	self isComposite
		ifTrue:[(elements = nil) ifTrue: [elements := OrderedCollection new.       ]]
		ifFalse: [Smalltalk error: 'This is not a composite WebElement'].
!

isComposite

	"true, if this element is allowed to be composed by subelements.
	This method should be overriden by subclasess if a new element is not a         composite."

	^true
!

isFormElement
	^false
!

isWebApplication
	^false
!

isWebElement
	^true
!

isWebPage
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPConnectionField
	instanceVariableNames:'connectionToken'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

HTTPConnectionField comment:'c.f. RFC 2616 14.10

   The Connection header has the following grammar:

       Connection = "Connection" ":" 1#(connection-token)
       connection-token  = token

'
!

!HTTPConnectionField class methodsFor:'accessing'!

fieldName
	^'Connection'
! !

!HTTPConnectionField methodsFor:'accessing'!

connectionToken
	"^a String
Common values are 'close' and 'keep-alive'."

	^connectionToken
!

connectionToken: aString
	"^self"

	connectionToken := aString.
	^self
! !

!HTTPConnectionField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPutAll: connectionToken.
	^self
! !

!HTTPConnectionField methodsFor:'private'!

parseValueFrom: aString
	connectionToken := HTTPString trimBlanksFrom: aString.
	^self
! !

!HTTPConnectionField methodsFor:'services'!

setToClose
	self connectionToken: 'close'.
	^self
! !

!HTTPConnectionField methodsFor:'testing'!

connectionTokenIsClose
	^self connectionToken = 'close'
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SwazooHTTPRequestError subclass:#SwazooHTTPPostError
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Exceptions'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#HTTPPostDataArray
	instanceVariableNames:'underlyingCollection'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Messages'
!

HTTPPostDataArray comment:'Introduced the HTTPPostDataArray to hold post data in an HTTPRequest in place of a Dictionary.  This is because it is legal for there to be more than one entry with the same name (key) and using a Dictionary  looses data (!!).

Instance Variables:
	underlyingCollection    <>

'
!

!HTTPPostDataArray methodsFor:'accessing'!

allAt: aKey
	| candidates |
	candidates := self underlyingCollection
				select: [:anAssociation | anAssociation key = aKey].
	^candidates collect: [:anAssociation| anAssociation value]
!

allNamesForValue: aString
	| candidates |
	candidates := self underlyingCollection
				select: [:anAssociation | anAssociation value value = aString].
	^candidates collect: [:anAssociation| anAssociation key]
!

associations
	^self underlyingCollection
!

at: aKey
	^(self allAt: aKey) last
!

at: aKey ifAbsent: aBlock
	| candidates |
	candidates := self underlyingCollection
				select: [:anAssociation | anAssociation key = aKey].
	^candidates isEmpty ifTrue: [aBlock value] ifFalse: [candidates last value]
!

at: key put: anObject
	self underlyingCollection add: (Association key: key value: anObject).
	^anObject
!

includesKey: aKey
	| candidates |
	candidates := self underlyingCollection
				select: [:anAssociation | anAssociation key = aKey].
	^candidates notEmpty
!

includesValue: aString
	| candidates |
	candidates := self underlyingCollection
				select: [:anAssociation | anAssociation value value = aString].
	^candidates notEmpty
!

keys
"^a Set
I mimick the behavior of a Dictionay which I replace.  I return a set of the keys in my underlying collection of associations."

	^(self underlyingCollection collect: [:anAssociation| anAssociation key]) asSet
!

nameForValue: aString
	^(self allNamesForValue: aString) last
! !

!HTTPPostDataArray methodsFor:'enumerating'!

keysAndValuesDo: aTwoArgumentBlock
	self underlyingCollection do:
		[:anAssociation | aTwoArgumentBlock value: anAssociation key value: anAssociation value]
!

select: aBlock
"^an Object
I run the select on the values of the associations in my underlying collection.  This mimicks the behavior when a Dictionary was used in my place."
	^self underlyingCollection select:  [:anAssociation| aBlock value: anAssociation value]
! !

!HTTPPostDataArray methodsFor:'private'!

printOn: aStream
	aStream nextPutAll: 'a Swazoo.HttpPostDataArray
	'.
	self underlyingCollection do: [:each | aStream nextPutAll: each key printString , '->',
		each value value printString, '
	'].
!

underlyingCollection
	underlyingCollection isNil
		ifTrue: [underlyingCollection := OrderedCollection new].
	^underlyingCollection
! !

!HTTPPostDataArray methodsFor:'testing'!

isEmpty
	^self underlyingCollection isEmpty
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebComment
	instanceVariableNames:'text'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebComment class methodsFor:'instance creation'!

new
	^super new initialize
!

text: aString
	^self new text: aString

"WebText text: 'test'"
! !

!WebComment methodsFor:'accessing'!

text
	^text
!

text: aString
	text := aString.
! !

!WebComment methodsFor:'initialize-release'!

initialize
	text := ''.
! !

!WebComment methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	aStream nextPutAll: self ident, '<!!-- '.
	aStream nextPutAll: self text.
	aStream nextPutAll: ' -->', self eol.
! !

!WebComment methodsFor:'private'!

shouldIdent
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SwazooHTTPRequestError subclass:#SwazooHTTPPutError
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Exceptions'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#Resource
	instanceVariableNames:'enabled uriPattern parent'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Core'
!

Resource comment:'Resource is an abstract class for all so called web resources. Such resource has its url address and can serve with responding to web requests. Every resource need to #answerTo: aHTTPRequest with aHTTPResponse. Site is a subclass of a Resource. You can subclass it with your own implementation. There is also a CompositeResource, which can hold many subresources. Site is also aCopmpositeResource and therefore you can add your own resources to your site.'
!

!Resource class methodsFor:'instance creation'!

new
	^super new initialize
!

uriPattern: aString
	^self new uriPattern: aString
! !

!Resource methodsFor:'accessing'!

currentUrl
	| stream |
	stream := WriteStream on: String new.
	self printUrlOn: stream.
	^stream contents
!

helpResolve: aResolution
	^aResolution resolveLeafResource: self
!

parent
	^parent
!

printUrlOn: aWriteStream
	self parent printUrlOn: aWriteStream.
	aWriteStream nextPutAll: self uriPattern
!

root
	^self parent isNil
		ifTrue: [self]
		ifFalse: [self parent root]
!

uriPattern
	^uriPattern
!

uriPattern: anIdentifier
	anIdentifier notNil ifTrue: [uriPattern := anIdentifier]
! !

!Resource methodsFor:'authentication'!

authenticationRealm
	"rfc2617 3.2.1: A string to be displayed to users so they know which username and
     password to use. This string should contain at least the name of
     the host performing the authentication and might additionally
     indicate the collection of users who might have access. An example
     might be 'registered_users@gotham.news.com' "
	^'Swazoo server'
!

authenticationScheme
	"#Basic or #Digest, see rfc2617. Digest is recomended because password
	goes encrypted to server"
	^#Digest
!

unauthorizedResponse
	"Resource should call this method and return its result immediately, if request is not authorized
	to access that resource and a HTTP authorization is needed"
"       ^HTTPAuthenticationChallenge newForResource: self " 
!

unauthorizedResponsePage
	"Resource should override this method with it's own html message"
	^'<HTML>
  <HEAD>
    <TITLE>Authentication error</TITLE>
  </HEAD>
  <BODY>
    <H1>401 Authentication error</H1>
    <P>Bad username or password</P>
  </BODY>
</HTML>'
! !

!Resource methodsFor:'private'!

match: anIdentifier
	^self uriPattern match: anIdentifier
!

parent: aResource
	parent := aResource
! !

!Resource methodsFor:'private-initialize'!

initUriPattern
	self uriPattern: ''
!

initialize
	self enable.
	self initUriPattern
!

onResourceCreated
	"Received after the resource has been added to its parent resource. Opportunity to perform initialization that depends on knowledge of the resource tree structure"
! !

!Resource methodsFor:'serving'!

answerTo: aRequest
	"override in your Resource and return a HTTPResponse"
	^nil
! !

!Resource methodsFor:'start/stop'!

disable
	enabled := false
!

enable
	enabled := true
!

start
!

stop
! !

!Resource methodsFor:'testing'!

canAnswer
	^self isEnabled and: [self isValidlyConfigured]
!

isEnabled
	^enabled
!

isValidlyConfigured
	^self uriPattern ~= ''
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#HTTPServerTest
	instanceVariableNames:'server stream'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!HTTPServerTest methodsFor:'running'!

setUp
	| socket |
	(Delay forMilliseconds: 100) wait.
	server := HTTPServer new.
	[server ip: 'localhost'; port: 8123.
	server start]
		fork.
	(Delay forMilliseconds: 100) wait.
" 	stream := (SocketAccessor newTCPclientToHost: 'localhost' port: 8123) 
				readAppendStream"
	socket := SpSocket connectToServerOnHost:  'localhost' port: 8123.
	stream := SwazooStream socket: socket 
!

tearDown
	server stop.
	stream close.
	stream := nil.
	Delay forMilliseconds: 500.
! !

!HTTPServerTest methodsFor:'tests'!

testServing
	self assert: server isServing
!

testStopServing
	server stop.
	self deny: server isServing
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpError subclass:#SwazooHTTPParseError
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Exceptions'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebTableCell
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebTableCell class methodsFor:'instance creation'!

new
	^super new initialize
! !

!WebTableCell methodsFor:'attributes'!

align: aSymbol
	"set a horizontal aligment if cell content. It can be #left, #center or #right"
	self attributesAt: #align put: aSymbol asString.
!

background: aWebImage
	"bachground image"
	self attributesAt: #background put:
		(((aWebImage isKindOf: WebImage) ifTrue: [aWebImage] ifFalse: [WebImage image: aWebImage])
			urlOnSession: self session)
!

bgColor: aColorSymbol
	"set the color of table cell background. It can be in hex format (for example #00FF00)
	or name of color (for example #White)"
	self attributesAt: #bgcolor put: (self colorValue: aColorSymbol)
!

color: aColorSymbol
	self    bgColor: aColorSymbol
!

colspan: aNumber
	"set the number of columns this cell will span"
	self attributesAt: #colspan put: aNumber printString.
!

height: aNumber
	| text |
	text := aNumber <= 1
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #height put: text
!

nowrap: aBoolean
	"if true then text is not wrapped in new lines of a cell but a cell is expanded to carry all the text"
	self attributesAt: #nowrap put: aBoolean.
!

rowspan: aNumber
	"set the number of rows this cell will span"
	self attributesAt: #rowspan put: aNumber printString.
!

setHeader
"       self changeClassTo: WebTableHeader"
	self become: (self as: WebTableHeader)
!

valign: aSymbol
	"set a verttical aligment if cell content. It can be #top, #middle, #bottom or #centerline"
	self attributesAt: #valign put: aSymbol asString.
!

width: aNumber
	"set the width of a cell. If nil, then cell automaticaly addjust itself.
	If number is between 0 and 1 then width is percent of table width.
	If number above 1 then width in pixels"
	| text |
	text := aNumber <= 1
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #width put: text
! !

!WebTableCell methodsFor:'initialize-release'!

initialize
! !

!WebTableCell methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	aStream nextPutAll: self ident, '<td'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>'.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</td>', self eol.
! !

!WebTableCell methodsFor:'testing'!

isTableHeader
	^false
!

shouldIdent
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPUserAgentField
	instanceVariableNames:'productTokens'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

HTTPUserAgentField comment:'RFC 2616: 14.43 User-Agent

   The User-Agent request-header field contains information about the
   user agent originating the request. This is for statistical purposes,
   the tracing of protocol violations, and automated recognition of user
   agents for the sake of tailoring responses to avoid particular user
   agent limitations. User agents SHOULD include this field with
   requests. The field can contain multiple product tokens (section 3.8)
   and comments identifying the agent and any subproducts which form a
   significant part of the user agent. By convention, the product tokens
   are listed in order of their significance for identifying the
   application.

       User-Agent     = "User-Agent" ":" 1*( product | comment )

   Example:

       User-Agent: CERN-LineMode/2.15 libwww/2.17b3'
!

!HTTPUserAgentField class methodsFor:'accessing'!

fieldName
	^'User-Agent'
! !

!HTTPUserAgentField methodsFor:'accessing'!

productTokens
	^productTokens
! !

!HTTPUserAgentField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPutAll: productTokens.
	^self
! !

!HTTPUserAgentField methodsFor:'private'!

parseValueFrom: aString
	"^self
I could try and parse out the product name and version numbers, but there is no need to worry about this at the moment, so I just record the string."

	productTokens := HTTPString trimBlanksFrom: aString.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#HTTPString
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Compatibility'
!

HTTPString comment:'This class contains some utility methods that were previously implemented as extentions to system classes.  This is really a stop-gap until, perhaps, the SwazooStream yeilds HTTPStrings.

'
!

!HTTPString class methodsFor:'instance creation'!

newRandomString: anInteger
	| numbersThroughAlphas targetStream char random |
	numbersThroughAlphas := (48 to: 122) collect: [:each | each asCharacter].
	targetStream := WriteStream on: (String new: anInteger).
	random := Random new.
	[targetStream contents size < anInteger] whileTrue:
			[char := numbersThroughAlphas
						at: (random next * (numbersThroughAlphas size - 1)) rounded + 1.
			char isAlphaNumeric ifTrue: [targetStream nextPut: char]].
	^targetStream contents
! !

!HTTPString class methodsFor:'decoding'!

decodedHTTPFrom: aCharacterArray
	"Code taken from the swazoo specific extention to the CharacterArray class"

	| targetStream sourceStream |
	targetStream := WriteStream on: aCharacterArray class new.
	sourceStream := ReadStream on: aCharacterArray.
	[sourceStream atEnd] whileFalse:
			[| char |
			char := sourceStream next.
			char = $%
				ifTrue:
					[targetStream
						nextPut: (SpEnvironment integerFromString: '16r' , (sourceStream next: 2))
								asCharacter]
				ifFalse:
					[char == $+
						ifTrue: [targetStream nextPut: Character space]
						ifFalse: [targetStream nextPut: char]]].
	^targetStream contents
!

encodedHTTPFrom: aCharacterArray
	"Code taken from the swazoo specific extention to the CharacterArray class"

	| targetStream |
	targetStream := WriteStream on: aCharacterArray class new.
	aCharacterArray do:
			[:char |
			(self isHTTPReservedCharacter: char)
				ifTrue:
					[targetStream nextPut: $%.
					char asInteger
						printOn: targetStream
						paddedWith: $0
						to: 2
						base: 16]
				ifFalse: [targetStream nextPut: char]].
	^targetStream contents
!

isHTTPReservedCharacter: aCharacter
	"Code taken from the swazoo specific extention to the Character class"

	^(aCharacter isAlphaNumeric or: ['-_.!!~*''()' includes: aCharacter]) not
!

stringFromBytes: aByteArray
	"^a String
In GemStone ['Hello, World' asByteArray asString] returns the string 'aByteArray' !!
This is the boring long way of getting a string from a ByteArray - but it does work
in GemStone."

	"HTTPString stringFromBytes: ('Hello, World' asByteArray)"

	| targetStream |
	targetStream := WriteStream on: String new.
	aByteArray do: [:aByte | targetStream nextPut: aByte asCharacter].
	^targetStream contents
!

trimBlanksFrom: aString
	"^a String
I return a copy of aString with all leading and trailing blanks removed."

	| first last |
	first := 1.
	last := aString size.
	[last > 0 and: [(aString at: last) isSeparator]]
		whileTrue: [last := last - 1].
	^last == 0
		ifTrue: [String new]
		ifFalse:
			[[first < last and: [(aString at: first) isSeparator]]
				whileTrue: [first := first + 1].
			aString copyFrom: first to: last]
! !

!HTTPString class methodsFor:'tokens'!

subCollectionsFrom: aCollection delimitedBy: anObject
	"^an OrderedCollection
I return the ordered collection of sub-collections from aCollection, delimited
by anObject."

	"HTTPString subCollectionsFrom: 'aaa/bbb/' delimitedBy: $/"

	| subCollections sourceStream |
	subCollections := OrderedCollection new.
	sourceStream := ReadStream on: aCollection.
	[sourceStream atEnd]
		whileFalse: [subCollections add: (sourceStream upTo: anObject)].
	(aCollection isEmpty
		or: [(sourceStream
				skip: -1;
				next) == anObject])
			ifTrue: [subCollections add: aCollection class new].
	^subCollections
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#DailyCollection
	instanceVariableNames:'days'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

!DailyCollection methodsFor:'accessing'!

allDated: aDate

	^(self days at: aDate asDays ifAbsent: [^#()] ) copy
!

allDates
	"all dates on which something exist"
	^self allDays collect: [:each | Date fromDays: each]
!

allFromDate: aStartDate to: anEndDate
	| startDay endDay daysInRange |
	startDay := aStartDate asDays. endDay := anEndDate asDays.
	daysInRange := self allDays select: [:each | each >= startDay and: [each <= endDay] ].
	daysInRange := daysInRange asSortedCollection.
	^daysInRange inject: OrderedCollection new into: [:col :each | col addAll: (self days at: each). col]

"DailyCollection allInstances last allFromDate: (Date readSloFrom: '1.1.2004' readStream)
	to: (Date readSloFrom: '31.12.2006' readStream)"
!

allLastMonth
	^self allMonthly: Date today - Date today day
!

allLastWeek
	^self allWeekly: Date today - 7
!

allLastYear
	^self allYear: Date today year - 1
!

allMonthly: aDate
	^self
		allFromDate: aDate firstDayOfMonth
		to: aDate firstDayInMonth + aDate daysInMonth - 1
!

allSinceDate: aDate
	^self allFromDate: aDate to: Date today
!

allThisMonth
	^self allMonthly: Date today
!

allThisWeek
	^self allWeekly: Date today
!

allThisYear
	^self allYear: Date today year
!

allToday
	^self allDated: Date today
!

allWeekly: aDate
	^self
		allFromDate: aDate - aDate weekdayIndex + 1
		to: aDate - aDate weekdayIndex + 1 + 7
!

allYear: aNumber
	^self
		allFromDate: (SpDate newDay: 1 month: 1 year: aNumber)
		to: (SpDate newDay: 31 month: 12 year: aNumber)
!

allYears
	"all years on which something exist"
	^SortedCollection
		withAll: (self allDates inject: Set new into: [:set :each | set add: each year. set])
		sortBlock: [:a :b | a < b]

"DailyCollection allInstances last allYears"
!

allYesterday
	^self allDated: Date today - 1
!

firstInYear: aYear
	"on 1st january of that year"
	| col |
	col := self allDated: (SpDate newDay: 1 month: 1 year: aYear).
	col isEmpty ifTrue: [^nil].
	^col first
!

last: aNumber
	"find last number of values, starting from today and back in past. Most recent first!!"
	| collection dayColl |
	collection := OrderedCollection new.
	dayColl := SortedCollection withAll: self days keys sortBlock: [:a :b | a > b].
	dayColl do: [:day || coll |
		coll := (self days at: day) copy reverse.
		collection addAll: (coll copyFrom: 1 to: ((aNumber - collection size) min: coll size) ).
		collection size = aNumber ifTrue: [^collection] ].
	^collection

"LogisticSystem default owner events size last: 1000"
!

lastDayInYear: aYear
	"on 31 december of that year"
	^self allDated: (SpDate newDay: 31 month: 12 year: aYear).
!

size
	days isNil ifTrue: [^0].
	^self days values inject: 0 into: [:sum :each | sum + each size].
! !

!DailyCollection methodsFor:'adding - removing'!

add: newObject

	self add: newObject onDate: newObject date
!

add: newObject onDate: aDate
	(self includes: newObject onDate: aDate) ifTrue: [^nil].
	self existCheckDate: aDate.
	(self days at: aDate asDays) add: newObject.
	^newObject
!

addAll: aCollection

	aCollection do: [:each | self add: each].
	^aCollection
!

addAll: aCollection onDate: aDate

	self existCheckDate: aDate.
	^aCollection do: [:each |       self add: each onDate: aDate].
!

addFirst: newObject inYear: aYear
	"put in first place at 1st jan of this year"
	| date |
	date := SpDate newDay: 1 month: 1 year: aYear.
	(self includes: newObject onDate: date) ifTrue: [^nil].
	self existCheckDate: date.
	(self days at: date asDays) addFirst: newObject.
	^newObject
!

addLast: newObject inYear: aYear
	"put in first place at 1st jan of this year"
	| date |
	date := SpDate newDay: 31 month: 12 year: aYear.
	(self includes: newObject onDate: date) ifTrue: [^nil].
	self existCheckDate: date.
	(self days at: date asDays) addLast: newObject.
	^newObject
!

move: anObject fromDate: aDate toDate: aNewDate
	| collection |
	collection := self days at: aDate asDays.
	collection remove: anObject.
	self add: anObject onDate: aNewDate
!

remove: oldObject
	^self remove: oldObject ifAbsent: [self notFoundError]
!

remove: oldObject ifAbsent: anExceptionBlock
	| collection |
	collection := self days at: oldObject date asDays ifAbsent: [^anExceptionBlock value].
	collection remove: oldObject ifAbsent: [^anExceptionBlock value].
!

removeAll: aCollection
	"Remove each element of aCollection from the receiver.  If successful for each,
	answer aCollection."
	aCollection do: [:each | self remove: each].
	^aCollection
! !

!DailyCollection methodsFor:'private'!

days
	days isNil ifTrue: [self initDays].
	^days
!

existCheckDate: aDate

	(self days includesKey: aDate asDays) ifFalse:
		[self days at: aDate asDays put: OrderedCollection new].
!

initDays
	days := Dictionary new.
! !

!DailyCollection methodsFor:'private-accessing'!

all
	| dayCol |
	dayCol := SortedCollection
		withAll: self days keys
		sortBlock: [:a :b | a > b].
	^dayCol inject: OrderedCollection new into: [:col :each | col addAll: (self days at: each); yourself ].
!

allDays
	"all day numbers on which something exist"
	^self days keys
!

allDaysForKindOf: aClass
	"all day numbers on which something of that class exist"
	^self days keys select: [:day |
		(self days at: day) contains: [:each | each isKindOf: aClass] ].
!

allYearsForKindOf: aClass
	"all years on which something of that class exist"
	| allDays currentYear years skipToDay |
	allDays := self days keys asSortedCollection. allDays isEmpty ifTrue: [^#()].
	currentYear := (SpDate fromDays: allDays first) year.
	years := Set new. skipToDay := 0.
	allDays do: [:day |
		day >= skipToDay ifTrue:
			[((self days at: day) contains: [:entry | entry isKindOf: aClass]) ifTrue:
				[years add: currentYear. currentYear := currentYear + 1.
				skipToDay := (SpDate newDay: 1 month: 1 year: currentYear) asDays] ] ].
	^years asSortedCollection

"DailyCollection allInstances last allYearsForKindOf: AIDA.Invoice "
! !

!DailyCollection methodsFor:'testing'!

contains: aBlock
	"Evaluate aBlock with each of the receiver's elements as the argument.
	Answer true if aBlock ever evaluates to true, otherwise answer false."

	self detect: aBlock ifNone: [^false].
	^true
!

includes: anObject
	"Answer whether anObject is one of the receiver's elements."

	self days values do: [:each | (each includes: anObject) ifTrue: [^true]].
	^false
!

includes: anObject onDate: aDate
	| values |
	values := self days at: aDate asDays ifAbsent: [^false].
	^values includes: anObject
!

isEmpty
	"Answer whether the receiver contains any elements."

	^self size = 0
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SwazooStreamTest
	instanceVariableNames:'input output'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!SwazooStreamTest methodsFor:'running'!

setUp
	| pair |
	pair := SwazooStream connectedPair.
	input := pair first.
	output := pair last
!

tearDown
	input close.
	output close
! !

!SwazooStreamTest methodsFor:'testing'!

testConnectedPair
	(Array with: input with: output) 
		do: [:each | self assert: (each isKindOf: SwazooStream)]
!

testErrorOnInputClose
	self should: 
			[input close.
			output next]
		raise: Error
!

testNextPut
	#($A $M $Y $b $r $z) do: 
			[:each | 
			self assert: (input nextPut: each) = each. 
			input flush.
			self assert: output next = each]
!

testNextPutAll
	#('123' 'abc' 'swazoo') do: 
			[:each | 
			self assert: (input nextPutAll: each) = each. 
			input flush.
			self assert: (output next: each size) = each]
!

testNextPutByte
	| bytes |
	bytes := ByteArray 
				with: 6
				with: 5
				with: 0
				with: 2.
	bytes do: 
			[:each | 
			self assert: (input nextPutByte: each) = each. 
			input flush.
			self assert: output nextByte = each]
!

testNextPutBytes
	| bytes1 bytes2 bytes3 |
	bytes1 := ByteArray withAll: #(1 2 3 4).
	bytes2 := ByteArray withAll: #(5 4 3 2 1).
	bytes3 := ByteArray withAll: #(1 1 2 3 5).
	(Array 
		with: bytes1
		with: bytes2
		with: bytes3) do: 
				[:each | 
				self assert: (input nextPutBytes: each) = each.
				input flush.
				self assert: (output nextBytes: each size) = each]
!

testPeek
	#($K $J $D $j $m $z) do: 
			[:each | 
			input nextPut: each.
			input flush.
			self assert: output peek = each.
			output next]
!

testPeekByte
	| bytes |
	bytes := ByteArray withAll: #(5 2 8 4 11 231).
	bytes do: 
			[:each | 
			input nextPutByte: each.
			input flush.
			self assert: output peekByte = each.
			output nextByte]
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#VersionSpecTest
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Tests'
!

!VersionSpecTest methodsFor:'testing'!

testFirstCreation
	| spec |
	spec := VersionSpec firstFor: ''.
	self assert: spec number = '1'.
	self assert:  spec isCurrent.
	self assert:  spec isOldest.
	self assert:  spec isNewest.
!

testSearchByNumber
	| o spec |
	o := VersionedObject new.
	spec := VersionSpec newFromParent: o for: VersionedObject new.
	self assert: ((spec versionSpecWithNumber: '2') number = '2').
	self assert: ((spec versionSpecWithNumber: '1') number = '1').
	self assert: (spec versionSpecWithNumber: '3') isNil.
!

testSecondCreation
	| o spec |
	o := VersionedObject new.
	spec := VersionSpec newFromParent: o for: VersionedObject new.
	self assert: spec number = '2'.
	self deny:  spec isCurrent.
	self deny:  spec isOldest.
	self assert:  spec isNewest.
	self assert: spec parent == o.
	spec setCurrent.
	self assert:  spec isCurrent.
	self deny: spec parent version isCurrent.
!

testSetCurrent
	| o spec |
	o := VersionedObject new.
	spec := VersionSpec newFromParent: o for: VersionedObject new.
	self assert:  o isCurrentVersion.
	self deny:  spec isCurrent.
	spec setCurrent.
	self assert:  spec isCurrent.
	self deny: o isCurrentVersion.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

ReadStream subclass:#SwazooTestStream
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!SwazooTestStream methodsFor:'accessing'!

nextBytes: anInteger
	^(self next: anInteger) asByteArray
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebPage
	instanceVariableNames:'session'
	classVariableNames:'WellKnownPages'
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebPage class methodsFor:'instance creation'!

newOn: aSession
	^self new session: aSession
! !

!WebPage class methodsFor:'accessing'!

wellKnownPages

	"return a dictionary of well known WebPages, such as error reporting    pages etc."

"       (WellKnownPages notNil)
		ifTrue: [^WellKnownPages]
		ifFalse: [self initWellKnownPages. #WellKnownPages]
"
	self initWellKnownPages.
	^WellKnownPages
! !

!WebPage class methodsFor:'initialize'!

buildNotFoundPage

	"this page report an URL not found error"

	| page |
	page := WebPage new.
	page
		name: 'URLNotFound';
		title: 'URL not found error'.
	page
		add:
			((WebText
				text: 'Error')
				header: 1);
		add: (WebSeparator rulerSize: 5);
		add:
			((WebText
				text: 'Document with this URL not found on our server,
						Please correct and try again. Thank you.')
				attributes: #bold);
		add: (WebSeparator rulerSize: 5);
		add:
			((WebText
				text: 'AIDA/Web, Smalltalk Web Server, (C) EraNova d.o.o., Ljubljana, Slovenia')).

	^page
!

initWellKnownPages

	"make a dictionary of well known pages, such as error reporting etc."

	WellKnownPages := Dictionary new.
	WellKnownPages at: #URLNotFound put: self buildNotFoundPage.

"WebPage initWellKnownPages"
! !

!WebPage methodsFor:'accessing'!

app
	"return anApplication on which we are composing this web page"
	self session isNil ifTrue: [^nil].
	^self session lastApp
!

contentType
	"return 'text/html' as content type for web pages"
	^'text/html'
!

script: aString
	"add this JavaScript  to scripts executed at the opening of page"
	self scriptBefore: aString.
!

session
	"reference to a session on which this page is created"
	^session
!

title
	^self otherAt: #pageTitle ifAbsent: ['']
!

title: aString
	self otherAt: #pageTitle put: aString convertToSloveneChars
! !

!WebPage methodsFor:'attributes'!

alink: aSymbol
	"set the color of active link text. It can be in hex format (for example #00FF00)
	or name of color (for example #White)"
	self attributesAt: #alink put: (self colorValue: aSymbol)
!

alinkColor: aSymbol
	self alink: aSymbol.
!

background: anImageOrURL
	"set the URL for the background image"
	self attributesAt: #background put:
		(anImageOrURL isString
			ifTrue: [anImageOrURL]
			ifFalse: [self site urlResolver halfUrlFor: anImageOrURL]).
!

bgColor: aSymbol
	"set the color of page background)"
	self attributesAt: #bgcolor put: (self colorValue: aSymbol)
!

bgImage: anImageOrURL
	self background: anImageOrURL.
!

link: aSymbol
	"set the color of link text."
	self attributesAt: #link put: (self colorValue: aSymbol).
!

linkColor: aSymbol
	self vlink: aSymbol.
!

text: aSymbol
	"set the color of page text."
	self attributesAt: #text put: (self colorValue: aSymbol).
!

textColor: aSymbol
	self text: aSymbol.
!

vlink: aSymbol
	"set the color of visited link text."
	self attributesAt: #vlink put: (self colorValue: aSymbol).
!

vlinkColor: aSymbol
	self vlink: aSymbol.
! !

!WebPage methodsFor:'header elements'!

addJavascript: aScriptString
	self addScriptWithParms: 'language="JavaScript" type="text/javascript"' script: aScriptString
!

addLinkToAlternateScreenStyleSheet: anObjectOrUrl
	| url |
	url := anObjectOrUrl isString
		ifTrue: [anObjectOrUrl]
		ifFalse: [self site urlResolver halfUrlFor: anObjectOrUrl].
	self addHeader: 'link' value: 'rel="alternate stylesheet" type="text/css" media="screen" href="', url, '" '
!

addLinkToJavascript: anObjectOrUrl
	| url |
	url := anObjectOrUrl isString
		ifTrue: [anObjectOrUrl]
		ifFalse: [self site urlResolver halfUrlFor: anObjectOrUrl].
	self addScriptWithParms: ' src="', url, '" language="JavaScript" type="text/javascript"' script: ''.
!

addLinkToPrintStyleSheet: anObjectOrUrl
	| url |
	url := anObjectOrUrl isString
		ifTrue: [anObjectOrUrl]
		ifFalse: [self site urlResolver halfUrlFor: anObjectOrUrl].
	self addHeader: 'link' value: 'rel="stylesheet" type="text/css" media="print" href="', url, '" '
!

addLinkToScreenStyleSheet: anObjectOrUrl
	| url |
	url := anObjectOrUrl isString
		ifTrue: [anObjectOrUrl]
		ifFalse: [self site urlResolver halfUrlFor: anObjectOrUrl].
	self addHeader: 'link' value: 'rel="stylesheet" type="text/css" media="screen" href="', url, '" '
!

addMetaContentType: aString
	"example: 'text/html; charset=iso8859-2'"
	self addHeader: 'meta' value: 'http-equiv="Content-Type"  content="', aString, '" '
!

addMetaDescription: aString
	self addHeader: 'meta' value: 'name="description" content="', aString, '"'
!

addMetaKeywords: aString
	"keywords separated with , "
	self addHeader: 'meta' value: 'name="keywords" content="', aString, '"'
!

printDummyJavascriptSnippetOn: aStream
| snippet |
	snippet :=
'<script language="JavaScript">
...
</script>'.
	aStream nextPutAll: snippet
!

redirectAfter: aSecondsNumber toUrl: aString
	"redirection or refresh of specified url, does not work on Mozilla!! "
	self addHeader: 'meta' value: 'http-equiv="REFRESH"  content="',
		aSecondsNumber printString, '; url=', aString, '" '
! !

!WebPage methodsFor:'initialize - release'!

cleanup
	"clear all elements and web table info, when page is not needed anymore"
	self initElements.
	self initAttributes.
	self initScript.
	self initPageHeaderLinks.
	self clearTableInfo.
!

initHeaders
	self otherAt: #pageHeaders put: OrderedCollection new.
!

initPageHeaderLinks
	self initHeaders.
	self site isNil ifTrue: [^nil].
	self addMetaContentType: 'text/html; charset=UTF-8'.
	self addLinkToScreenStyleSheet: self site style screenCssResource.
	self addLinkToPrintStyleSheet: self site style printCssResource.
	self addLinkToJavascript: self site style javascriptResource.
!

initScript
	self initScriptBefore
!

postInitialize
	self initPageHeaderLinks
! !

!WebPage methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	aStream
		nextPutAll: '<!!-- AIDA/Web, Smalltalk Web Application Server -->', self eol;
		nextPutAll: '<!!-- (C) EraNova d.o.o., Ljubljana, Slovenia (www.eranova.si) -->', self eol.
	aStream
		nextPutAll: '<html>', self eol, ' <head>', self eol;
		nextPutAll: '  <title>' ,  (AIDASite convertToWeb: self title on: aSession), '</title>', self eol.
	self printHeaderElementsOn: aStream.
	self scriptBefore notNil
		ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession. self eol].
	aStream nextPutAll: ' </head>', self eol.
	aStream nextPutAll: ' <body'. self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	self isWebApplication
		ifTrue: [self form printHTMLPageOn: aStream forSession: aSession] "form for current view"
		ifFalse: [super printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll:  self ident, ' </body>', self eol, '</html>', self eol.
	self cleanup.
!

printHeaderElementsOn: aStream
	self headers isNil ifTrue: [^self].
	self headers do: [:assoc |
		aStream nextPutAll: '  <', assoc key, ' '.
		assoc key = 'script'
			ifTrue: [| array | array := assoc value class == Array
				ifTrue: [assoc value] ifFalse: [Array with: assoc value with: ''].
				aStream nextPutAll: (array at: 1), '>', (array at: 2), '</script>']
			ifFalse: [aStream nextPutAll: assoc value, '>'].
		aStream nextPutAll: self eol].
!

printWebPageFor: aSession
	^self
! !

!WebPage methodsFor:'private'!

addHeader: aTagString value: aString
	self headers isNil ifTrue: [self initHeaders].
	self headers add: (aTagString -> aString)
!

addScriptWithParms: aString script: aScriptString
	self headers isNil ifTrue: [self initHeaders].
	self headers add: ('script' -> (Array with: aString with: aScriptString) )
!

headers
	^self otherAt: #pageHeaders ifAbsent: [nil]
!

identDepth
	^self otherAt: #identDepth ifAbsent: [0]
!

identDepth: aNumber
	"current depth of identation. If 0, the we are at the start of the line"
	self otherAt: #identDepth put: aNumber
!

isNewline
	^self identDepth = 0
!

session: aSession
	session := aSession
!

setNewline
	self identDepth: 0
! !

!WebPage methodsFor:'testing'!

isComposite

	"a WebPage is a composite element"
	^true
!

isWapDocument
	^false
!

isWebApplication
	^false
!

isWebPage
	^true
!

shouldIdent
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebFormElement
	instanceVariableNames:'aspect object adaptor enterTab'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebFormElement class methodsFor:'instance creation'!

new
	^super basicNew initialize
! !

!WebFormElement class methodsFor:'auto type converting'!

autoConvertString: aString toObject: anObject
	"try to convert string depending on object type"
	(anObject isKindOf: String) ifTrue: [^aString].
	(anObject isKindOf: Integer) ifTrue: [^aString asInteger].
	(anObject isKindOf: FixedPoint) ifTrue: [^aString asFixedPoint: anObject scale].
	(anObject isKindOf: Date) ifTrue: [^Date readSloFrom: aString readStream].
	anObject isNil ifTrue: [^aString].
	^aString
!

autoConvertToString: anObject
	"try to convert object to string depending on object type"
	(anObject isKindOf: String) ifTrue: [^anObject].
	(anObject isKindOf: Integer) ifTrue: [^anObject printDotString].
	(anObject isKindOf: FixedPoint) ifTrue: [^anObject printDotString].
	(anObject isKindOf: Date) ifTrue: [^anObject shorterPrintSloString].
	^anObject printString
! !

!WebFormElement methodsFor:'accessing'!

adaptor
	^adaptor
!

adaptor: aProtocolAdaptor
	adaptor := aProtocolAdaptor.
!

aspect
	^aspect
!

aspect: aSymbol
	aspect := aSymbol.
!

object
	^object
!

object: anObject

	"set the object, which instance variable is presented as aspect in this fom element"

	object := anObject.
!

value
	^self adaptor value
!

value: aValue
	"set the value of this form element"
	self adaptor value:  aValue.
! !

!WebFormElement methodsFor:'attributes'!

name
	^self attributesAt: #name
!

name: aString
	self attributesAt: #name put: aString
!

noTab
	"skip this form element when tabulating with TAB"
	"This attribute specifies the position of the current element in the tabbing order of that form"
	self tabIndex: 0.
!

tabIndex
	"This attribute specifies the position of the current element in the tabbing order of that form"
	^(self attributes at: #tabindex ifAbsent: [^nil]) asInteger
!

tabIndex: aNumber
	"This attribute specifies the position of the current element in the tabbing order
	for the current document"
	self attributes at: #tabindex put: aNumber printString
!

type: aString
	"set the type of  this form element"
	self attributesAt: #type put: aString
! !

!WebFormElement methodsFor:'events'!

activate
	"move focus and select the text in that form field. (focus+select)"
	self registerId.
	self scriptAfter: 'Field.activate(''', self id, ''')'
!

focus
	"move the input focus to that form field"
	self registerId.
	self scriptAfter: 'Field.focus(''', self id, ''')'
!

ignoreEnterKey
	"don't allow ENTER/RETURN key to submit a form unintentionally, for instance"
	self scriptAfter: 'Event.observe(''', self id, ''', ''keypress'', function(event) {
		if (event.keyCode == Event.KEY_RETURN) { Event.stop(event); } } )'
!

onChange: aJavascriptCode
	self attributesAt: #onChange add: aJavascriptCode
!

onEnterTabulate
	"It goes to the next element in tabulation order"
	"This allows ENTER key to be used for tabulation, like a TAB. "
	self enterTab: true. "to make tabulation script late, just before htmlPrint"
!

onEnterTabulateTo: aFormElementOrId
	"allow ENTER key to be used for tabulation, like a TAB"
	| nextId |
	nextId := (aFormElementOrId isKindOf: WebElement)
		ifTrue: [aFormElementOrId id] ifFalse: [aFormElementOrId asString].
	nextId isNil ifTrue: [nextId := ''].
	self scriptAfter: 'Event.observe(''', self id, ''', ''keypress'', function(event) {
		if (event.keyCode == Event.KEY_RETURN) {
			Event.stop(event); $(''', nextId, ''').activate(); } } )'
!

onFocus: aJavascriptCode
	self attributesAt: #onFocus add: aJavascriptCode
!

onSelect: aJavascriptCode
	self attributesAt: #onSelect add: aJavascriptCode
!

select
	"select a whole input. Be sure to focut it first!!"
	self registerId.
	self scriptAfter: 'Field.select(''', self id, ''')'
! !

!WebFormElement methodsFor:'events-ajax'!

onChangePost
	"after field change immediatelly post contents to server (AJAX)"
	self onChangePostAndUpdate: nil
!

onChangePostAndUpdate: anElementOrId
	"after field change, post contents to server and AJAX update anElementOrId  "
	self onChange: (self scriptForPostAndUpdate: anElementOrId with: nil)
!

onChangePostAndUpdate: anElementOrId with: aParmString
	"after field change, post contents to server and AJAX update anElementOrId  with a parameter"
	self onChange: (self scriptForPostAndUpdate: anElementOrId with: aParmString)
!

onChangePostAndUpdateSelf
	"DONT WORK YET!!"
	"after field change, post contents to server and AJAX update that form element  "
	self registerId.
	self onChangePostAndUpdate: self
!

onKeyPressPostAndUpdate: anElementOrId
	"after any key press in a field, post contents to server (AJAX)"
	self onKeyPress: (self scriptForPostAndUpdate: anElementOrId  with: nil)
!

onKeyUpPostAndUpdate: anElementOrId
	"after any key  release in a field, post contents to server (AJAX)"
	self onKeyUp: (self scriptForPostAndUpdate: anElementOrId with: nil)
! !

!WebFormElement methodsFor:'initialize-release'!

initialize
	self name: ''.
"       self app form registerFormElementsIn: self "
! !

!WebFormElement methodsFor:'model adapting'!

adapt
	"set appropriate aspect adaptor for that element"
	(self aspect isKindOf: Symbol) ifTrue:
		[self adaptor: ((AIDAAspectAdaptor forAspect: self aspect) subject: self object)].
	(self aspect  isKindOf: Number) ifTrue:
		"adapt to an element of collection"
		[self adaptor: ((AIDAIndexedAdaptor forIndex: self aspect) subject: self object)]
!

aspect: aSymbol for: anObject
	"set the link between this form element and an aspect (name of instance variable)
	of an object , which value is presented in this webFormElement. The appropriate
	aspect adaptor is generated after page composition in aWebApplication printWebView
	method to check also elements which were added to subelements later!!. Name of a form
	element is set to an aspect name, if not already set differently"
	self aspect: aSymbol.
	self object: anObject
! !

!WebFormElement methodsFor:'printing'!

addEnterTabScriptIfNessesary
	self enterTab ifFalse: [^nil].
	self onEnterTabulateTo: (self app form nextTabOrderFrom: self)
!

prepareToHTMLPrintOn: aSession
	super prepareToHTMLPrintOn: aSession.
	self addEnterTabScriptIfNessesary.
! !

!WebFormElement methodsFor:'private'!

enterTab
	"is tabulation witn Enter key enabled?"
	enterTab isNil ifTrue: [^false].
	^enterTab
!

enterTab: aBoolean
	enterTab := aBoolean
! !

!WebFormElement methodsFor:'private-ajax'!

scriptForPostAndUpdate: anElementOrId with: aParmString
	| url idSymbol parms |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId]
		ifFalse: [anElementOrId isNil
			ifTrue: [#nil] ifFalse: [anElementOrId registerId. anElementOrId id] ].
	self registerId.
	url := self ajaxCallUrl.
	parms := self ajaxCallUrlParametersFor: anElementOrId.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	^'var field = Form.Element.serialize(''', self id asString, '''); new Ajax.Updater(''', idSymbol asString, ''', ''', "url, ''', {method: ''get'', parameters: ''', parms, ''' + field, evalScripts: true})'"
url, ''', {method: ''post'', postBody: field + ''', ('&', parms), ''', evalScripts: true})'
! !

!WebFormElement methodsFor:'testing'!

isAutocompleteField
	^false
!

isButton
	^false
!

isCheckBox
	^false
!

isDateInputField
	^false
!

isEmpty
	"input field is empty or nil"
	| vlue |
	vlue := self object perform: self aspect.
	^vlue isNil
		or: [((vlue isKindOf: String) and: [vlue isEmpty])
			or: [(vlue isKindOf: Number) and: [vlue = 0] ]]
!

isFileInputField
	^false
!

isFormElement
	^true
!

isInputField
	^false
!

isListBox
	^false
!

isMenu
	^false
!

isRadioButton
	^false
!

isTextArea
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebHelp
	instanceVariableNames:'pages'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Parts'
!

WebHelp comment:'WebHelp for easy made of help system. each view of each App can have its own help page. Each aWebHelpPage has url like http://www.server.com/help/AdminApp/main.html for view #main in AdminApp.


Instance Variables:
	pages   <Dictionary of Dictionary> key=App class name,
											value=dictionary key: view, value aWebHelpPage

'
!

!WebHelp methodsFor:'accessing'!

add: aWebHelpPage
	self forApp: aWebHelpPage app view: aWebHelpPage view put: aWebHelpPage
!

existApp: anApp view: aSymbol
	^(self forApp:anApp view: aSymbol) notNil
!

forApp: anApp view: aSymbol
	| appName |
	appName := (anApp isKindOf: WebApplication) ifTrue: [anApp class name] ifFalse: [anApp].
	^(self pages at: appName ifAbsent: [^nil]) at: aSymbol asSymbol ifAbsent: [nil]
!

forApp: anApp view: aSymbol put: aWebHelpPage
	| appName |
	appName := (anApp isKindOf: WebApplication) ifTrue: [anApp class name] ifFalse: [anApp].
	(self pages at: appName ifAbsentPut: [Dictionary new]) at: aSymbol asSymbol put: aWebHelpPage
! !

!WebHelp methodsFor:'initialize-release'!

initPages
	pages := Dictionary new.
! !

!WebHelp methodsFor:'private'!

pages
	pages isNil ifTrue: [self initPages].
	^pages
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebList
	instanceVariableNames:'name kind type'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebList class methodsFor:'instance creation'!

kind: aSymbol
	"should be #ordered, #unordered, #definition"

	^self new initialize kind: aSymbol
!

new
	^super new initialize
!

newDefinition
	^self kind: #definition
!

newOrdered
	^self kind: #ordered
!

newUnordered
	^self kind: #unordered
! !

!WebList methodsFor:'accessing'!

kind
	^kind
!

kind: aSymbol
	"should be #ordered, #unordered, #definition. By default is #definition"

	kind := aSymbol.
!

name
	^name
!

name:  aString
	"set the name of this list. Used for accessing the selections from WebForm or WebApplication"

	name := aString.
! !

!WebList methodsFor:'adding/removing'!

add: anElement
	"ensure always WebListItem as subelement of list"
	| element |
	element := (anElement class == WebListItem)
		ifTrue: [anElement]
		ifFalse: [WebListItem newListItem add: anElement; yourself].
	^super add: element
!

addDefinition: anElement
	"ensure always WebListItem as subelement of list"
	| element |
	element := (anElement class == WebListItem)
		ifTrue: [anElement setDefinition]
		ifFalse: [WebListItem newDefinition add: anElement; yourself].
	^super add: element
!

addDefinitionTerm: anElement
	"ensure always WebListItem as subelement of list"
	| element |
	element := (anElement class == WebListItem)
		ifTrue: [anElement setDefinitionTerm]
		ifFalse: [WebListItem newDefinitionTerm add: anElement; yourself].
	^super add: element
!

addLinkTo: anObject text: aString
	"add new line to the list with text and link to some object"
	| line |
	line := WebListItem new.
	line    addLinkTo: anObject text: aString.
	self add: line
!

addLinkTo: anObject text: aString class: aSymbol
	"add new line to the list with text and link to some object. Set class for CSS too"
	| line |
	line := WebListItem new class: aSymbol.
	line    addLinkTo: anObject text: aString.
	self add: line
!

addLinkTo: anObject text: aString id: aSymbol
	"add new line to the list with text and link to some object. set id too"
	| line |
	line := WebListItem new id: aSymbol.
	line    addLinkTo: anObject text: aString.
	self add: line
!

addLinkTo: anObject text: aString withBullet: anImageOrURL
	"add new line to the list with bullet image and text and link to some object"
	| line |
	line := WebListItem new.
	line add: (WebImage image: anImageOrURL); add: (WebLink text: aString linkTo: anObject).
	self  add: line
!

addText: aString
	"make a new element with aString. Attributes are same as previous text."
	| line |
	line := WebListItem new.
	line addText: aString.
	self  add: line
!

addText: aString class: aSymbol
	"add list item with specified text. set class for CSS to that item too"
	| line |
	line := WebListItem new class: aSymbol.
	line addText: aString.
	self  add: line
!

addText: aString id: aSymbol
	"add list item with specified text. set id to that item too"
	| line |
	line := WebListItem new id: aSymbol.
	line addText: aString.
	self  add: line
!

addText: aString withBullet: anImageOrURL
	"add new line to the list with bullet image and text"
	| line |
	line := WebListItem new.
	line add: (WebImage image: anImageOrURL); addText: aString.
	self  add: line
! !

!WebList methodsFor:'initialize-release'!

initialize
	kind := #definition.
! !

!WebList methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	| tag |
	self prepareToHTMLPrintOn: aSession.
	self kind == #ordered ifTrue: [tag := 'ol'].
	self kind == #unordered ifTrue: [tag := 'ul'].
	self kind == #definition ifTrue: [tag := 'dl'].
	aStream nextPutAll: self ident, '<', tag.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</', tag, '>', self eol.
! !

!WebList methodsFor:'testing'!

shouldIdent
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#HTTPHeaders
	instanceVariableNames:'fields'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPHeaders class methodsFor:'instance creation'!

readFrom: aStream
	"^an HTTPHeaders
I return a new instance of myself which contains fields parsed from aStream."

	^self new readFrom: aStream
! !

!HTTPHeaders methodsFor:'emitting'!

crlfOn: aStream
	aStream
		nextPut: Character cr;
		nextPut: Character lf
!

writeOn: aStream
	"^self
I write all my fields to aStream."

	self fields do:
			[:aField |
			aField printOn: aStream.
			self crlfOn: aStream]
! !

!HTTPHeaders methodsFor:'initialize-release'!

readFieldFromString: aString
	"^self
First I get the field parsed from aString, then I add the new field to my collection of fields.  Adding the new field may involve merging field values if I already have a field of that class."

	self addField: (HeaderField fromLine: aString).
	^self
!

readFrom: aStream
	"^an HTTPHeaders
I return a new instance of myself which contains fields parsed from aStream.  Everything upto the next blank line is a header field."


	[| nextLine |
	nextLine := aStream nextUnfoldedLine.
	nextLine isEmpty
		ifTrue: [true]
		ifFalse:
			[self readFieldFromString: nextLine.
			false]]
			whileFalse: [].
	^self
! !

!HTTPHeaders methodsFor:'private'!

fields
	fields isNil ifTrue: [fields := Dictionary new].
	^fields
! !

!HTTPHeaders methodsFor:'services'!

addField: aField
	"HTTPSpec1.1 Sec4.2
Multiple message-header fields with the same field-name MAY be present in a message if and only if the entire field-value for that header field is defined as a comma-separated list [i.e., #(values)]. It MUST be possible to combine the multiple header fields into one 'field-name: field-value' pair, without changing the semantics of the message, by appending each subsequent field-value to the first, each separated by a comma. The order in which header fields with the same field-name are received is therefore significant to the interpretation of the combined field value, and thus a proxy MUST NOT change the order of these field values when a message is forwarded.
Note that we have to use the field name here as we may be adding a field for which there is no class, i.e. it's a GenericHeaderField."

	(self includesFieldNamed: aField name)
		ifTrue: [(self fieldNamed: aField name) combineWith: aField]
		ifFalse: [self fields at: aField name asUppercase put: aField].
	^self
!

fieldNamed: aString
	"^aString
If I contain a field named aString, I return it.  Otherwise an exception is thrown.
This is a bad way of getting a field.  Use >> fieldOfClass: instead."

	| targetString |
	targetString := aString asUppercase.
	^self fields detect: [:aField | aField name asUppercase = targetString]
!

fieldNamed: aString ifNone: aBlock
	"^aString
If I contain a field named aString, I return it.  Otherwise I evaluate aBlock."

	^self fields at: aString asUppercase ifAbsent: aBlock
!

fieldNamed: aFieldName ifPresent: presentBlock ifAbsent: absentBlock
	"^an Object
I look for a field named aFieldName among my fields.  If I find it, I return the result of evaluating presentBlock with the found field as an argument, otherwise I return the result of evaluate the absentBlock"

	| foundField |
	foundField := self fieldNamed: aFieldName ifNone: [nil].
	^foundField isNil
		ifTrue: [absentBlock value]
		ifFalse: [presentBlock value: foundField]
!

fieldOfClass: aClass
	"^aString
If I contain a field of class aClass, I return it.   Otherwise an exception is thrown."

	^self fields detect: [:aField | aField class == aClass] ifNone: [^nil]
!

fieldOfClass: aClass ifNone: aBlock
	"^aString
If I contain a field of class aClass, I return it.   Otherwise I evaluate aBlock."

	^self fields detect: [:aField | aField class == aClass] ifNone: aBlock
!

fieldOfClass: fieldClass ifPresent: presentBlock ifAbsent: absentBlock
	"^an Object
I look for a field of class fieldClass among my fields.  If I find it, I return the result of evaluating presentBlock with the found field as an argument, otherwise I return the result of evaluate the absentBlock"

	| foundField |
	foundField := self fieldOfClass: fieldClass ifNone: [nil].
	^foundField isNil
		ifTrue: [absentBlock value]
		ifFalse: [presentBlock value: foundField]
!

getOrMakeFieldOfClass: aClass
	"^a HeaderField
If I contain a field of class aClass, I return it.   Otherwise I create a new instance if the field class and add it to my collection of headers."

	^self fieldOfClass: aClass
		ifNone:
			[| newField |
			newField := aClass new.
			self addField: newField.
			newField]
! !

!HTTPHeaders methodsFor:'testing'!

includesFieldNamed: aString
	"^a Boolean
I return true if one of my fields has the name aString."

	| targetField |
	targetField := self fieldNamed: aString ifNone: [nil].
	^targetField notNil
!

includesFieldOfClass: aClass
	"^a Boolean
I return true if one of my fields is of class aClass."

	^self
		fieldOfClass: aClass
		ifPresent: [:aField | true]
		ifAbsent: [false]
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#HTTPResponseTest
	instanceVariableNames:'response'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!HTTPResponseTest methodsFor:'private'!

crlf
	^String with: Character cr with: Character lf
! !

!HTTPResponseTest methodsFor:'testing'!

testInternalServerError
	| ws ls |
	response := HTTPResponse internalServerError.
	ws := WriteStream on: String new.
	response printStatusOn: ws.
	ls := HTTPReadStream onStream: (ReadStream on: ws contents).
	self assert: ls nextLine = 'HTTP/1.1 500 Internal Server Error'
!

testOK
	| ws ls |
	response := HTTPResponse ok.
	ws := WriteStream on: String new.
	response printStatusOn: ws.
	ls := HTTPReadStream onStream: (ReadStream on: ws contents).
	self assert: ls nextLine = 'HTTP/1.1 200 OK'
!

testResponseTypes
	self assert: (HTTPResponse badRequest) isBadRequest.
	self assert: (HTTPResponse found) isFound.
	self assert: (HTTPResponse internalServerError) isInternalServerError.
	self assert: (HTTPResponse movedPermanently) isMovedPermanently.
	self assert: (HTTPResponse notFound) isNotFound.
	self assert: (HTTPResponse notImplemented) isNotImplemented.
	self assert: (HTTPResponse notModified) isNotModified.
	self assert: (HTTPResponse ok) isOk.
	self assert: (HTTPResponse redirectLink) isRedirectLink.
	self assert: (HTTPResponse seeOther) isSeeOther.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebPage subclass:#WebApplication
	instanceVariableNames:'observee view forms'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

!WebApplication class methodsFor:'instance creation'!

new
	^super new initialize
!

newFor: anObject on: aSession
	"guess a class from anObject class name (class name + 'Views') and create instance of it"
	| instance |
	instance := self newFromNameFor: anObject on: aSession.
	instance isNil ifTrue: [^nil].
	^instance session: aSession; postInitialize
! !

!WebApplication class methodsFor:'accessing'!

allViews
	^self allComposedViews
!

allWebAppClasses
	"return an ordered collection with a WebApplication class all their subclasses ordered
	by levels of inheritance and by class name on the same level"
	| classes |
	classes := OrderedCollection new.
	self allWebAppClassesTo: classes.
	^classes

"WebApplication allWebAppClasses"
!

defaultView
	^'main'
! !

!WebApplication class methodsFor:'private'!

allComposedViewMethods
	| methods |
	methods := self selectors select: [:each | 'view*' match:each asString].
	methods := methods reject: [:each |
		#(view view: viewAllowed viewMethodForView: ) includes: each].
	^self superclass isWebApplication
		ifTrue: [methods addAll: self superclass allComposedViewMethods; yourself]
		ifFalse: [methods]

"WebDemoApp new class allComposedViewMethods"
!

allComposedViews
	"remove 'view' and lowercase start of remining part of method to get a view name from method"
	^self allComposedViewMethods collect: [:each |
		((String with: (each at: 5) asLowercase),
			(each copyReplaceFrom: 1 to: 5 with: String new)) asSymbol].

"WebDemoApp new class allComposedViews"
!

allWebAppClassesTo: aCollection
	"return an ordered collection with a WebApplication class all their subclasses ordered
	by levels of inheritance and by class name on the same level"
	| subcls |
	aCollection add: self.
	subcls := SortedCollection withAll: self subclasses
				sortBlock: [:a :b | a name < b name].
	subcls do: [:subclass | subclass allWebAppClassesTo: aCollection]
!

appClassLevel
	"return the level of inheritance of a class, relative to a WebApplication class"
	| level cls |
	level := 1.
	cls := self.
	[cls == WebApplication] whileFalse:
			[level := level + 1.
			cls := cls superclass].
	^level
!

capitalizeName: aString
	"make first char uppercase"
	aString isEmpty ifTrue: [^''].
	^(String with: aString first asUppercase), (aString copyFrom: 2 to: aString size)

"WebApplication capitalizeName: 'main' "
!

composedActionMethodNameForView: aViewName
	^('action', (self capitalizeName: aViewName asString)) asSymbol

"WebApplication composedActionMethodNameForView: 'main'"
!

composedActionMethodNameForView: aViewName buttonName: aString
	^((self composedActionMethodNameForView: aViewName) asString,
		(self capitalizeName: aString)) asSymbol.

"WebApplication composedActionMethodNameForView: 'main' buttonName: 'addFolder'"
!

composedMethodNameForView: aViewName
	^('view', (self capitalizeName: aViewName asString)) asSymbol

"WebApplication new class composedMethodNameForView: 'main'"
!

isWebApplication
	^true
!

newFromNameFor: anObject on: aSession
	"Try to create of AnObjectApp instance if exist."
	| className class |
	className := (anObject class name asString, 'App') asSymbol.
	class := [Smalltalk at: className] on: Error do: [:ex | ^nil].
	(class allSuperclasses includes: WebApplication) ifFalse: [^nil].
	^class new observee: anObject; session: aSession; postInitialize.

"WebApplication newFromNameFor: WebDiscussions new "
!

viewMethodDict
	"obsolete, just for compatibility"
	^Dictionary new.
! !

!WebApplication class methodsFor:'security'!

allowAllUpdatesFor: aWebUserOrGroup on: anAIDASite
	"set access rigths to allow all updates on that web app for specified user or group
	on specified server"
	self allWebAppClasses do: [:appClass |
		appClass allViews do: [:appView |
			anAIDASite securityManager
				setAccessRights: (appClass updateRightSymbolFor: appView)
				for: aWebUserOrGroup
				on: appClass name] ].

"
WebSecurityManagerApp allowAllUpdatesFor:
	(WebSecurityManager default adminUser)
		on: AIDASite default
"
!

allowAllViewsFor: aWebUserOrGroup on: anAIDASite
	"set access rigths to allow all views on all web apps for specified user or group on specified site"
	self allWebAppClasses do: [:appClass |
		appClass allViews do: [:appView |
			anAIDASite securityManager
				setAccessRights: (appClass viewRightSymbolFor: appView)
				for: aWebUserOrGroup
				on: appClass name] ].
"
WebApplication allowAllViewsFor:
	(WebSecurityManager default adminUser)
	on: AIDASite default
"
!

encryptSymbolFor: aViewSymbol
	"if view does not exist, then use a default (first) view. Be sure to use a
	sublclass of WebApplication when calling that method to find the right default view"
	| view allViews|
	allViews := self allViews.
	allViews isEmpty ifTrue: [^nil].
	view := (allViews includes: aViewSymbol asSymbol)
		ifTrue: [aViewSymbol]
		ifFalse: [self defaultView].
	view := (String with: view asString first asUppercase),
		(view asString copyFrom: 2 to: view asString size).
	^('encrypt', view asString) asSymbol
!

updateRightSymbolFor: aViewSymbol
	"return a right symbol, used for setting/testing rights to update a page with specified view.
	A symbol is composed as follows: '#upd',<aViewSymbol> for expample for view #brief
	result is #updbrief"
	"if view does not exist, then use a default (first) view. Be sure to use a
	sublclass of WebApplication when calling that method to find the right defult view"
	| view allViews|
	allViews := self allViews.
	allViews isEmpty ifTrue: [^nil].
	view := (allViews includes: aViewSymbol asSymbol)
		ifTrue: [aViewSymbol]
		ifFalse: [self defaultView].
	view := (String with: view asString first asUppercase),
		(view asString copyFrom: 2 to: view asString size).
	^('upd', view) asSymbol
!

viewRightSymbolFor: aViewSymbol
	"return a right symbol, used for setting/testing rights to view a page with specified view.
	a symbol is composed as follows: '#view',<aViewSymbol> for expample for view #brief
	result is #viewbrief"
	"if view does not exist, then use a default (first) view. Be sure to use a
	sublclass of WebApplication when calling that method to find the right defult view"
	| view allViews|
	allViews := self allViews. allViews isEmpty ifTrue: [^nil].
	view := (allViews includes: aViewSymbol asSymbol)
		ifTrue: [aViewSymbol]
		ifFalse: [self defaultView].
	view := (String with: view asString first asUppercase),
		(view asString copyFrom: 2 to: view asString size).
	^('view', view) asSymbol
! !

!WebApplication class methodsFor:'view, action methods'!

actionMethodForView: aViewSymbol
	"obsolete, only for WebSecurityManagerApp !!"
	| method viewSymbol |
	viewSymbol := aViewSymbol asString isEmpty
		ifTrue: [self defaultView] ifFalse: [aViewSymbol asSymbol].
	method := self composedActionMethodNameForView: viewSymbol.
	(self canUnderstand: method) ifFalse: [^nil].
	^method
!

actionMethodForView: aViewSymbol buttonName: aString
	"if no method for that button name, try to call action method without button name"
	| method viewSymbol |
	viewSymbol := aViewSymbol asString isEmpty
		ifTrue: [self defaultView] ifFalse: [aViewSymbol asSymbol].
	method := self composedActionMethodNameForView: viewSymbol buttonName: aString.
	(self canUnderstand: method) ifTrue: [^method].
	'search' = aString ifTrue: [^#actionSearch].
	method := self composedActionMethodNameForView: viewSymbol.
	(self canUnderstand: method) ifTrue: [^method].
	^nil
!

viewMethodForView: aViewSymbol
	"registered views have a precedence over composed method names"
	| method viewSymbol |
	viewSymbol := aViewSymbol asString isEmpty
		ifTrue: [self defaultView] ifFalse: [aViewSymbol asSymbol].
	method := self viewMethodDict at: viewSymbol ifAbsent: [nil].
	method isNil ifTrue: [method := self composedMethodNameForView: viewSymbol].
	(self canUnderstand: method) ifFalse: [^nil].
	^method

"WebDemoApp new class viewMethodForView: #imageGallery"
! !

!WebApplication methodsFor:'accessing'!

app
	^self
!

defaultView
	"default view is first view in method registerViews. If none, then it is 'main' "
	^self class defaultView
!

form
	"a form for current view"
	^self formForView: self view.
!

inDefaultView
	^(self view = self defaultView asSymbol) | (self view = #'')
!

inError
	^self error notNil and: [self error notEmpty]
!

observee
	"return reference to an object, for which this app acts as an observer - to make an user interface
	of them"
	^observee
!

site
	"reference to a site on which this app shows some object. "
	^self session site
!

style
	^self site style
!

user
	"reference to a user of current session "
	^self session user
!

view
	"name of a view to the object, currently/last generated. This name is included into
	hidden field named 'id5273', which is used to identify correct form when it is posted
	by the web user"
	^view isNil ifTrue: [''] ifFalse: [view]
! !

!WebApplication methodsFor:'accessing-modes'!

inEditMode
	^self mode = #edit
!

inViewMode
	^self mode = #view
!

mode
	| mode |
	mode := self otherAt: #Mode.
	^mode isNil
		ifTrue: [self setViewMode. self mode]
		ifFalse: [mode]
!

setEditMode
	self mode: #edit
!

setViewMode
	self mode: #view
! !

!WebApplication methodsFor:'accessing-other'!

error
	^self otherAt: #Error
!

error: aString
	"error message to be written on web page. "
	self otherAt: #Error put: aString
!

process
	"a BPM.Process instance, on which this app is activated by some task"
	^self otherAt: #Process
!

process: aBPMProcess
	self other at: #Process put: aBPMProcess
!

search
	^self otherAt: #Search
!

search: aString
	"search input field"
	self otherAt: #Search put: aString
! !

!WebApplication methodsFor:'clipboard'!

clipboard
	^self session clipboard
!

copyToClipboard
	"copy an url and title of current view of observee object to web clipboard"
	| object |
	object := self observee isVersionedObject
		ifTrue: [self observee currentVersion] "so that link will be aways same regardles of version!!"
		ifFalse: [self observee].
	title := (object class canUnderstand: #id) ifTrue: [object id, ' '] ifFalse: [''].
	title := (object class canUnderstand: #title) ifTrue: [title, object title] ifFalse: [nil].
	title isNil ifTrue:
		[title := (object class canUnderstand: #indexTitle) ifTrue: [object indexTitle] ].
	title isNil ifTrue: [title := self title].
	self clipboard
		title: title;
		url: (self site urlResolver halfUrlFor: object);
		object: object
!

pasteFromClipboard
	"get a DocLink with title and url. Nil if clipboard empty"
	self clipboard isEmpty ifTrue: [^nil].
	^self clipboard asDocLink
! !

!WebApplication methodsFor:'initialize-release'!

cleanup
	"clear all elements and web table info, when page is not needed anymore"
	self initScript. self initAttributes.
	self clearTableInfo.
	self form
		initElements;
		clearTableInfo.
	self initPageHeaderLinks.
!

clear
	"delete all elements of a WebPage for this WebApplication. It clears all in a form for current view."
	self form clear.
	self form initIdField.
!

initForms
	forms := Dictionary new.
!

initialize
	super clear.  "clear all in case of cascading inits"
	self initAttributes.
	self bgColor: #ffffff.
	self initForms.
	"self setViewMode."
! !

!WebApplication methodsFor:'private'!

acceptInputs
	"this method read form inputs (if any) and write them to the appropriate aspects of model
	objects. You must use this method in your printWebPage method, if you want form processing
	before printing a result web page. If a page for posted view is not current, then it is
	regenerated before input reading"
	| request postView |
	request := self session lastRequest.
	postView := request postDataStringAt: WebForm idFieldName.
	postView isNil ifTrue: [^nil].
	self view asSymbol ~= postView asSymbol
		ifTrue: [self printWebView: postView].  "refresh view"
	self form acceptFormInputFrom: request.
	self callActionMethodForButton: (self buttonNameFrom: request)
!

add: aWebElement
	"add to a form (for current view) actually !!"
	^self form add: aWebElement
!

announceAction: anActionSymbol onView: aSymbol
"       self announce:
		(AppActionTrigered for: self observee on: self session
			view: aSymbol action: anActionSymbol)"
!

announceView: aSymbol
"       self  announce:
		(AppViewShowed for: self observee on: self session view: aSymbol)"
!

buttonNameFrom: aRequest
	"return a name of button pressed. Name defines an action to be called"
	| buttonNames |
	buttonNames := (self form fieldSet select: [:each | each isButton]) collect: [:each | each name].
	^buttonNames detect: [:each | aRequest postDataKeys includes: each] ifNone: ['']
!

callActionMethodForButton: aString
	"name of button pressed is in argument"
	| methd |
	methd := self class actionMethodForView: self view buttonName: aString.
	methd notNil ifTrue:
		[(methd asString last = $: )  "obsolete methods have session for argument"
			ifTrue: [self perform: methd asSymbol with: self session]
			ifFalse: [self perform: methd asSymbol] ].
	self announceAction: aString asSymbol onView: self view
!

doesNotUnderstand: aMessage
	"forward a message to a style for processing"
	^self style
		perform: aMessage selector
		withArguments: aMessage arguments
!

isWebApplication
	^true
!

mode: aSymbol
	"portlet modes #view #edit "
	self otherAt: #Mode put: aSymbol
!

observee: anObject
	"set the reference to an object, for which this app acts as an observer - to make an user interface
	of them"
	observee := anObject
!

view: aString
	view := aString asSymbol.
	view = #'' ifTrue: [view := #main].
! !

!WebApplication methodsFor:'private-ajax'!

ajaxAcceptInputOn: aWebForm
	"AJAX request can post input field data too!! accept it!!"
	aWebForm ajaxAcceptFormInputFrom: self session lastRequest
!

ajaxUpdateOfOld: anOldElement
	"update (recreate or refresh) that element"
	| parm |
	anOldElement isNil ifTrue:  [^WebElement new].
	anOldElement method isNil ifTrue: [^anOldElement]. "in case of form elements it will return new value!!"
	parm := self session lastRequest isPost
		ifTrue: [self session lastRequest postDataStringAt: 'parm']
		ifFalse: [self session lastRequest queryAt: 'parm'].
	(self class canUnderstand: anOldElement method) "for elements created with App methods"
		ifTrue: [parm isNil
			ifTrue: [^self perform: anOldElement method] "this really recreate an element"
			ifFalse: [^self perform: anOldElement method with: parm ]]. "object method: parm"
	(anOldElement class canUnderstand: anOldElement method) "for standalone components"
		ifTrue: [(anOldElement method asString last = $: )
			ifTrue: [^anOldElement perform: anOldElement method with: parm ]
			ifFalse: [^anOldElement perform: anOldElement method] ].
	^anOldElement "similar case as above"
!

respondToAjaxAutocompleteOn: aWebForm
	| fieldName fieldValue field choices e |
	fieldName := self session lastRequest postData keys detect: [:each | 'field*' match: each] ifNone: nil.
	fieldValue := (self session lastRequest postDataAt: fieldName) value.
	fieldValue := AIDASite convert: fieldValue fromCodepage: #utf8.
	field := aWebForm fields at: fieldName.
	choices := field getChoicesForEntry: fieldValue.
	e := WebList newUnordered.
	choices do: [:each || string |
		string := each convertToSloveneChars.
		e add: (WebRawText text: (AIDASite convert: string toCodepage: #utf8))].
	^e
!

respondToAjaxInPlaceEditingOn: aWebForm
	| fieldValue field response |
	field := aWebForm elementId: self session lastRequest ajaxElementId.
	field isFormated & self session lastRequest isAjaxWikiFormatedRequest not  ifFalse:
		[fieldValue := (self session lastRequest postDataAt: 'value') value.
		fieldValue := AIDASite convert: fieldValue fromCodepage: #utf8.
		field allow ifTrue: [field object perform: (field aspect asString, ':') asSymbol with: fieldValue] ].
	response := (field object perform: field aspect).
	self session lastRequest isAjaxWikiFormatedRequest
		ifTrue: [response := response asWikiHtml].
	response := AIDASite convert: response toCodepage: #utf8.
	^WebElement new add: (WebRawText text: response); yourself
!

respondToAjaxRequest
	| oldElement ajaxForm e |
	ajaxForm := self formForView: self session lastRequest view asSymbol.
	oldElement := ajaxForm elementId: self session lastRequest ajaxElementId.
	self session lastRequest isAjaxInPlaceEditingRequest
		ifTrue: [^self respondToAjaxInPlaceEditingOn: ajaxForm].
	self session lastRequest isAjaxPostWithInput ifTrue: [self ajaxAcceptInputOn: ajaxForm].
	self session lastRequest isAjaxAutocompleteRequest
		ifTrue: [^self respondToAjaxAutocompleteOn: ajaxForm].
	e := self ajaxUpdateOfOld: oldElement. "update (recreate or refresh) that element"
	e adaptFormElements.
	ajaxForm registerFormElementsIn: e.
	e prepareToHTMLPrintOn: self session. "to prepare again"
	^e elements "because you need to send inner html of element only, not its tags"
! !

!WebApplication methodsFor:'private-bpm'!

isControledByBPMProcess
	"by a BPM process instance, which control a workflow of this app too"
	^self process notNil
!

setProcessFromTaskId
	"set a reference to a BPM process instance, which control a workflow of this app too"
	| uuid workitem |
	uuid := self session lastRequest queryAt: 'taskId' ifAbsent: [^nil].
	workitem := self site repository bpm worklist itemWithTaskUuid: uuid for: self user.
	workitem isNil ifTrue: [^nil].
	self process: workitem task process.
	workitem subscribeToApp: self.
! !

!WebApplication methodsFor:'private-forms'!

formForView: aViewSymbol
	| viewName |
	viewName := aViewSymbol asSymbol.
	viewName = #'' ifTrue: [viewName := #main].
	^(self forms at: viewName ifAbsentPut:
		[AIDA.WebForm new parent: self; view: viewName])
!

forms
	"a dictionary of forms for each view"
	forms isNil ifTrue: [self initForms].
	^forms
! !

!WebApplication methodsFor:'private-printing'!

errorReport
	"error report, if any"
	| e |
	e := WebElement newId: #error.
	self error notNil ifTrue: [e addText: self error style: '{color: red}'].
	self error: nil.
	^e
!

helpLink
	"link to help page for current view and App. If not exist, then nothing, exept for
	admin - link to creation of new help page"
	| link viewName |
	self class == WebHelpPageApp ifTrue: [^WebElement new].
	viewName := self inDefaultView ifTrue: ['main'] ifFalse: [self view asString].
	link := WebLink newClass: #helpLink.
	(self site help existApp: self view: viewName)
		ifTrue: [link text: ('<b>', self style helpText, '</b>')
			linkTo: (self site help forApp: self view: viewName)]
		ifFalse: [self user isAdmin
			ifTrue: [link text: '<b>', self style addHelpText, '</b>' linkTo: self site help; view: 'newPage';
				parameter: 'app' value: self class name asString;
				parameter: 'hview' value: viewName]
			ifFalse: [^WebElement new] ].
	^link
!

performViewMethod: aSymbol
	"obsolete method calls have session for argument!!"
	^(aSymbol asString last = $: )
		ifTrue: [self perform: aSymbol asSymbol with: self session]
		ifFalse: [self perform: aSymbol asSymbol]
!

printCurrentWebView
	"build a web page for a view in a view attributem, that is a current view"
	| printView |
	printView := (self class viewMethodForView: self view) notNil
		ifTrue: [self view asSymbol]
		ifFalse: [self class defaultView asSymbol].
	self session lastView: printView.
	^self printWebView: printView.
!

printWebPage
	| toLogin |
	self isObserveeVersioned ifTrue: [self checkObserveeVersion].
	toLogin := false. "self isEncryptionSatisfied ifTrue: [toLogin := true]."
	(self session lastRequest isPost and: [self session lastRequest isAjaxRequest not]) ifTrue:
		[self updateAllowed ifTrue: [self acceptInputs] ifFalse: [toLogin := true] ].
	toLogin ifTrue:
		[(self observee == self site admin and: [self session newView = 'login']) ifFalse:
			[self redirectTo: self site admin view: #login].
		^WebPage new].
	self session lastApp: self.
	self session lastRequest isAjaxRequest ifTrue: [^self respondToAjaxRequest].
	self view: self session newView.
	self session redirectLink notNil ifTrue: [^WebPage new].
	self setProcessFromTaskId. "for BPM engine, if present"
	^self printCurrentWebView.
!

printWebPageFor: aSession
	"OBSOLETE!!"
	^self printWebPage
!

printWebView: aViewName
	"build a web page for that view"
	| method page |
	self initPageHeaderLinks.
	method := self class viewMethodForView: aViewName.
	method isNil ifTrue: [^self clear; addText: 'ERROR: view named ', aViewName printString,
		' does not exist' header: 3].
	self clear. self view: aViewName.
	^self viewAllowed
		ifTrue: [page := self performViewMethod: method.
			page isWebApplication ifTrue: [page form registerFormElementsIn: page form].
			self storeThisUrl.
			self announceView: aViewName.
			page]
		ifFalse: [self redirectTo: self site admin view: #login.
			WebPage new].
!

storeThisUrl
	"to a User. It is helpull for return after logon, for instance"
	self user lastAppUrl: self session lastRequest uriString
! !

!WebApplication methodsFor:'private-versions'!

changeObserveeToVersion
	| object |
	object := self observee versionWithNumber: self versionFromRequest.
	object notNil ifTrue: [self observee: object]
!

checkObserveeVersion
	"change observee to point to correct version if necessary"
	self isVersionRequest ifTrue: [^self changeObserveeToVersion].
	self observee isCurrentVersion ifFalse: [self observee: self observee currentVersion].
!

isObserveeVersioned
	^self observee isVersionedObject
!

isVersionRequest
	^(self session lastRequest queryAt: 'version') notNil
!

versionFromRequest
	^self session lastRequest queryAt: 'version'
! !

!WebApplication methodsFor:'redirection'!

newView: aSymbol
	"in action methods, to direct to a specified view after button pressed"
	self session newView: aSymbol
!

redirectTo: anObjectOrUrlString
	"redirect browser to a default view for specified object or url link"
	self session redirectLink: (WebLink text:'' linkTo: anObjectOrUrlString).
!

redirectTo: anObjectOrUrlString view: aSymbol
	"redirect browser to a specified view for specified object or url link"
	self session redirectLink: (WebLink text:'' linkTo: anObjectOrUrlString view: aSymbol).
!

redirectTo: anObjectOrUrlString view: aSymbol parameter: aParmString value: aValueString
	"redirect browser to a specified view for specified object or url link"
	self session redirectLink: ((WebLink text:'' linkTo: anObjectOrUrlString view: aSymbol)
		 parameter: aParmString value: aValueString).
!

redirectToView: aSymbol
	"redirect browser to a different view for same observee"
	self session redirectLink: (WebLink text:'' linkTo: self observee view: aSymbol).
! !

!WebApplication methodsFor:'searching'!

actionMainSearch
	self actionSearch
!

actionSearch
	"a generic action when search button is pressed. It can be in almost every page."
	self indexApp searchString: self search. self search: ''.
	self indexApp actionMain.
	self redirectTo: self site index view: #results
!

indexApp
	^self site index webAppFor: self session
!

indexObservee
	"index or reindex observee of that app"
	^self site index indexObject: self observee
! !

!WebApplication methodsFor:'security'!

initAdminAccess
	"admin group has rights to all views and updates in all Apps!! "
	self site securityManager initAdminAccess.
!

isEncryptionSatisfied
	^(self mustBeEncrypted: self session newView) and: [self session lastRequest isEncrypted not]
!

mustBeEncrypted
	"check  if current view must be sent encrypted"
	^self mustBeEncrypted: self view
!

mustBeEncrypted: aViewSymbol
	"check  if this view must be sent encrypted"
	| right |
	(self observee = self site admin) & (aViewSymbol = #login) ifTrue: [^true].
	 right := self site securityManager
		isUser: self user
		allowedTo: (self class encryptSymbolFor: aViewSymbol)
		on: self class name.
	^right
!

updateAllowed
	"check if update is allowed to this observee object with specified view"
	"update for admin login page is always allowed"
	"reregister rights for admin if denial is encountered "
	| right |
	(self observee = self site admin) & (self view = #login) ifTrue: [^true].
	 right := self site securityManager
		isUser: self user allowedTo: (self class updateRightSymbolFor: self view)
		on: self class name.
	(right not and: [self session adminAllowed])
		ifTrue: [self initAdminAccess. ^true].
	^right
!

viewAllowed
	"check if page view is allowed to this observee object with specified view"
	"admin logon page always allowed"
	"reregister rights for admin if denial is encountered "
	| right |
	(self observee = self site admin) & (self view = #login) ifTrue: [^true].
	 right := self site securityManager
		isUser: self user allowedTo: (self class viewRightSymbolFor: self view)
		on: self class name.
	(right not and: [self session adminAllowed])
		ifTrue: [self initAdminAccess. ^true].
	^right
! !

!WebApplication methodsFor:'statistics'!

statisticsPageLink
	"returns a link to a page with day/hour statistic graphs of visits"
	| url link |
	url := self site urlResolver halfUrlFor: self observee.
	link := WebLink linkTo: self site statistics.
	link
		view: 'page';
		parameter: 'url' value: url.
	^link
!

visitsCount
	"returns number of visits of this page"
	^self webCounter total
!

webCounter
	"returns a counter which counts visits to this page"
	^self site urlResolver
		counterFor: self observee
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebApplication subclass:#WebFrameApp
	instanceVariableNames:'date'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

!WebFrameApp methodsFor:'accessing'!

date
	date isNil ifTrue: [self date: Date today].
	^date
!

date: anObject
	date := anObject
! !

!WebFrameApp methodsFor:'date calculations'!

adjustViewingDate
	"read url parameters and adjust a viewing date accordingly"
	| adjusted |
	adjusted := false.
	(self session lastRequest includesQuery: 'day') ifTrue:
		[self date: (SpDate
			newDay: (self session lastRequest queryAt: 'day') asInteger
			month: self date monthIndex
			year: self date year). adjusted := true].
	(self session lastRequest includesQuery: 'month') ifTrue:
		[self date: (SpDate
			newDay: 1
			month: (self session lastRequest queryAt: 'month') asInteger
			year: self date year). adjusted := true].
	(self session lastRequest includesQuery: 'year') ifTrue:
		[self date: (SpDate
			newDay: 1
			month: self date monthIndex
			year: (self session lastRequest queryAt: 'year') asInteger).
			adjusted := true].
	adjusted ifFalse: [date := Date today].
!

currentMonth
	^self currentYear and: [self date monthIndex = Date today monthIndex]
!

currentYear
	^self date year = Date today year
!

firstDayInMonth
	^SpDate newDay: 1 month: self date monthIndex year: self date year
!

firstDayInNextMonth
	^SpDate
		newDay: 1
		month: (self lastDayInMonth + 1) monthIndex
		year: (self lastDayInMonth + 1) year
!

firstDayInNextYear
	^SpDate
		newDay: 1
		month: self firstDayInMonth monthIndex
		year: self firstDayInMonth year + 1
!

firstDayInPreviousMonth
	^Date
		newDay: 1
		month: (self firstDayInMonth - 1) monthIndex
		year: (self firstDayInMonth - 1) year
!

firstDayInPreviousYear
	^SpDate
		newDay: 1
		month: self firstDayInMonth monthIndex
		year: self firstDayInMonth year + 1
!

lastDayInMonth
	^SpDate newDay: self date daysInMonth month: self date monthIndex year: self date year
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#URLResolverTest
	instanceVariableNames:'server site'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Tests'
!

!URLResolverTest methodsFor:'running'!

setUp
	server := Swazoo.SwazooServer singleton.
	server initialize.  "to remove all stuff and stop it"
	site := AIDASite newNamed: 'test'.
!

tearDown
	site := server siteNamed: 'test'.
	site stop.
	server removeSite: site.
	server := nil. site := nil.
! !

!URLResolverTest methodsFor:'testing'!

testSetUp
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SpEnvironment
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Environmental'
!

!SpEnvironment class methodsFor:'compiling'!

evaluate: aString in: anEnvironment
    ^ Parser
        evaluate:aString 
        in:anEnvironment 
        receiver:nil
        notifying:nil
        logged:false 
        ifFail:nil
!

evaluate: aString receiver: anObject in: anEnvironment
    ^ Parser
        evaluate:aString 
        in:anEnvironment 
        receiver:anObject
        notifying:nil
        logged:false 
        ifFail:nil
! !

!SpEnvironment class methodsFor:'image shutdown'!

addImageShutdownTask: aBlock for: anObject 
! !

!SpEnvironment class methodsFor:'queries'!

allSubclassesOf: aClass
	"^an Array
	I return the array of classes which are subclasses of aClass."

	^aClass allSubclasses asArray

"SpEnvironment allSubclassesOf: Error"
! !

!SpEnvironment class methodsFor:'services'!

characterFromInteger: anInteger
	^Character value: anInteger

"SpEnvironment characterFromInteger: 32"
!

integerFromString: aString
	"^an Integer
	We need this because of what looks like a bug in GemStone's String>>asNumber
	(e.g. '16rFF' -> 1.6000000000000000E+01, not 255)."

	^aString asNumber

"SpEnvironment integerFromString: '32' "
!

streamStartPosition
	"^an Integer
	Streams start at position 0 in VisualWorks & Squeak, and position 1 in
	GemStone(!!). "
	^ 0
!

writeStackDumpForException: exception to: targetStream
	targetStream nextPutAll:
		'SpEnvironment class>>writeStackDumpForException:to: does not work yet :-/'
! !

!SpEnvironment class methodsFor:'testing'!

isDolphin
	^false
!

isGemStone
	^false
!

isHeadless
	^false
!

isSqueak
	^true
!

isVisualWorks
	^false
!

onUnix
	"we are running on Unix, yes or no?"
	^SmalltalkImage current platformName = 'unix'
!

onWindows
	"we are running on Windows, yes or no?"
	^SmalltalkImage current platformName = 'windows'
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SwazooURI
	instanceVariableNames:'protocol hostname port identifier queries'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-HTTP'
!

!SwazooURI class methodsFor:'instance creation'!

fromString: aString
	^self new fromString: aString
!

value: aString
	^self new value: aString
! !

!SwazooURI methodsFor:'accessing'!

host
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: self hostname.
	self port = self defaultPort
		ifFalse:
			[ws nextPut: $:.
			self port printOn: ws].
	^ws contents
!

host: aString
	| rs |
	rs := ReadStream on: aString.
	self hostname: (rs upTo: $: ).
	rs atEnd ifFalse: [self port: rs upToEnd asNumber]
!

hostname
	^hostname
!

hostname: aHostname
	hostname := aHostname
!

identifier
	^identifier
!

identifier: anObject
	identifier := anObject
!

identifierPath
	| parts |
	parts := (HTTPString subCollectionsFrom: self identifier delimitedBy: $/)
				collect: [:each | HTTPString decodedHTTPFrom: each].
	self identifier first = $/ ifTrue: [parts addFirst: '/'].
	^parts reject: [:each | each isEmpty]
!

identifierPathString
	"^aString
I return the 'directory' part of the path name."

	| sourceStream targetStream |
	targetStream := WriteStream on: String new.
	sourceStream := ReadStream on: self identifier.
	[sourceStream atEnd] whileFalse:
			[| fragment |
			fragment := sourceStream throughAll: '/'.
			fragment last = $/ ifTrue: [targetStream nextPutAll: fragment]].
	^targetStream contents
!

port
	"^an Integer
The port number defaults to 80 for HTTP."

	^port isNil ifTrue: [80] ifFalse: [port]
!

port: anInteger
	port := anInteger
!

protocol
	protocol isNil ifTrue: [self protocol: 'http'].
	^protocol
!

protocol: aString
	protocol := aString.
!

value
	"1 halt: 'Use >>asString or >>printOn: instead'. "
	^self asString
! !

!SwazooURI methodsFor:'accessing-queries'!

includesQuery: aString
	| result |
	result := self queries detect: [:aQuery | aQuery key = aString]
				ifNone: [nil].
	^result notNil
!

queries
	"^an OrderedCollection
This is an ordered colleciton of associations.  It can't be a dictionary, because it is legal to have many entries with the same key value."

	queries isNil ifTrue: [queries := OrderedCollection new].
	^queries
!

queries: anOrderedCollection
	"^self
The queries must be an OrderedCollection of Associations c.f. >>queries"

	queries := anOrderedCollection.
	^self
!

queriesNamed: aString
	^self queries select: [:aQuery | aQuery key = aString]
!

queryAt: aString
	^self queryAt: aString ifAbsent: [nil]
!

queryAt: aString ifAbsent: aBlock
	"^aString
I return the value of the first query I find with the key aString.  If there are none I execute aBlock."

	| result |
	result := self queries detect: [:aQuery | aQuery key = aString]
				ifNone: [aBlock].
	^result == aBlock ifTrue: [aBlock value] ifFalse: [result value]
! !

!SwazooURI methodsFor:'initialize-release'!

fromStream: sourceStream
	self readProtocolFrom: sourceStream.
	self readHostFrom: sourceStream.
	self readPortFrom: sourceStream.
	self readIdentifierFrom: sourceStream.
	self readQueryFrom: sourceStream.
	^self
!

fromString: aString
	| sourceStream |
	sourceStream := ReadStream on: (HTTPString decodedHTTPFrom: aString).
	self fromStream: sourceStream.
	^self
! !

!SwazooURI methodsFor:'printing'!

asString
	| targetStream |
	targetStream := WriteStream on: String new.
	self printOn: targetStream.
	^targetStream contents
!

printOn: targetStream
	(self hostname notNil and: [self protocol notNil])
		ifTrue:
			[targetStream
				nextPutAll: self protocol;
				nextPutAll: '://'].
	self hostname notNil ifTrue: [targetStream nextPutAll: self hostname].
	(self hostname notNil and: [self port notNil and: [self port ~= 80]])
		ifTrue:
			[targetStream
				nextPut: $:;
				nextPutAll: self port printString].
	targetStream nextPutAll: self identifier.
	self printQueriesOn: targetStream.
	^self
!

printQueriesOn: targetStream
	| firstQuery |
	self queries isEmpty
		ifFalse:
			[firstQuery := self queries at: 1.
			targetStream
				nextPut: $?;
				nextPutAll: firstQuery key;
				nextPut: $=;
				nextPutAll: firstQuery value.
			2 to: self queries size
				do:
					[:queryIndex |
					| aQuery |
					aQuery := self queries at: queryIndex.
					targetStream
						nextPut: $&;
						nextPutAll: aQuery key;
						nextPut: $=;
						nextPutAll: aQuery value]].
	^self
! !

!SwazooURI methodsFor:'private'!

defaultPort
	^80
!

readHostFrom: aStream
	"^self
I read the host name from the URI presumed to be in aStream.  The stream should be positioned right at the start, or just after the '//' of the protocol.  The host name is terminated by one of $:, $/, $? or the end of the stream depending on wether there is a port, path, query or nothing following the host.  If the host name is of zero length, I record a nil host name.  The stream is left positioned at the terminating character."

	| hostnameStream |
	hostnameStream := WriteStream on: String new.
	[|nextCharacter|
	nextCharacter := aStream peek.
	#($: $/ $? nil) includes: nextCharacter]
		whileFalse: [hostnameStream nextPut: aStream next].
	 hostnameStream contents isEmpty ifFalse: [hostname := hostnameStream contents].
	^self
!

readIdentifierFrom: sourceStream

	self identifier: (sourceStream upTo: $?).
	^self
!

readPortFrom: aStream
	"^self
I read the port nnumber from the URI presumed to be in aStream.  If a port number has been specified, the stream should be positioned right at before a $: charcter.  So, if the next chacter is a :, we have a port number.  I read up to one of $/, $? or the end of the stream depending on wether there is a path, query or nothing following the host.  The stream is left positioned at the terminating character."

	| targetStream |
	targetStream := WriteStream on: String new.
	aStream peek == $:
		ifTrue:
			[| terminators |
			terminators := Array
						with: $/
						with: $?
						with: nil.
			aStream next.

			[| nextCharacter |
			nextCharacter := aStream peek.
			terminators includes: nextCharacter]
					whileFalse:
						[| nextDigit |
						nextDigit := aStream next.
						nextDigit isDigit ifTrue: [targetStream nextPut: nextDigit]].
			targetStream contents isEmpty
				ifFalse: [port := targetStream contents asNumber]].
	^self
!

readProtocolFrom: aStream
	"^self
I read the protocol from the URI presumed to be in aStream.  The protocol preceeds '://' in the URI.  I leave the stream position either right after the '//' if there is a protocol, otherwise I reset the position to the start of the stream."

	| candidateProtocol |
	candidateProtocol := aStream upTo: $:.
	(aStream size - aStream position >= 2
		and: [aStream next == $/ and: [aStream next == $/]])
			ifTrue: [self protocol: candidateProtocol]
			ifFalse: [aStream reset].
	^self
!

readQueryFrom: sourceStream
	[sourceStream atEnd] whileFalse:
		[| nameValue name value |
		nameValue := sourceStream upTo: $& .
		name := nameValue copyUpTo: $= .
		value := nameValue readStream upTo: $= "if any"; upToEnd.
		self queries add: name -> (HTTPString decodedHTTPFrom: value)].
	^self
! !

!SwazooURI methodsFor:'testing'!

isDirectory
	^self identifier last = $/
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebFormElement subclass:#WebInputField
	instanceVariableNames:'size maxLength type'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebInputField class methodsFor:'instance creation'!

adaptIndex: aNumber ofCollection: aCollection

	^self new aspect: aNumber for: aCollection
!

aspect: aSymbol for: anObject
	^self new aspect: aSymbol for: anObject
!

aspect: aSymbol for: anObject size: aNumber
	^self new aspect: aSymbol for: anObject size: aNumber
!

size: aNumber aspect: aSymbol forObject: anObject
	"OBSOLETE!!"
	^self new size: aNumber; aspect: aSymbol for: anObject
! !

!WebInputField methodsFor:'attributes'!

maxLength: aNumber
	"maximum number of characters allowed in this input field"
	self attributesAt: #maxlength put: aNumber printString
!

resetHidden
	self hidden: false
!

resetPassword
	self password: false
!

setHidden
	self hidden: true
!

setPassword
	self password: true
!

size: aNumber
	"number of characters displayed in this input field"
	self attributesAt: #size put: aNumber printString
! !

!WebInputField methodsFor:'initialize-release'!

aspect: aSymbol for: anObject size: aNumber
	^self aspect: aSymbol for: anObject; size: aNumber
!

initialize
	super initialize.
	self type: 'text'.
! !

!WebInputField methodsFor:'printing'!

prepareAttributesToPrintOn: aSession
	self value notNil ifTrue:
		[self attributesAt: #value put:
			(WebFormElement autoConvertToString: self value)]
!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self ident, '<input'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>'.
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].
! !

!WebInputField methodsFor:'private'!

hidden
	^self type = 'hidden'
!

hidden: aBoolean
	"make this input field hidden one"
	aBoolean ifTrue: [self type: 'hidden']
!

password
	^self type = 'password'
!

password: aBoolean
	"if true, then value will not be shown in input field"
	self type: 'password'.
!

saveThroughAdapterValue: aValueString
	| vlue |
	vlue :=  AIDASite convertFromWeb: aValueString on: self session. "ensure unicode!!"
	vlue := (WebFormElement autoConvertString:  vlue toObject: self value).
	self value: vlue.
! !

!WebInputField methodsFor:'testing'!

isHidden
	^self type = 'hidden'
!

isInputField
	^true
!

isPassword
	^self type = 'password'
!

shouldIdent
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#FileProxy
	instanceVariableNames:'site filename timestamps content contentType codepage elements
		bodyTagIndex imgTagIndexes linkTagIndexes servletTagIndexes'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!FileProxy class methodsFor:'instance creation'!

from: aFilenameString onSite: aSite
	"read a file and make a HTML proxy of it. Return nil, if file does not exist or cannot be opened.
	Also record a server for which you make a proxy"
	| proxy |
	proxy := self new site: aSite; from: aFilenameString.
	proxy indexContent.
	^proxy
! !

!FileProxy methodsFor:'accessing'!

codepage
	" #iso2 by default"
	codepage isNil ifTrue: [self codepage: #'iso-8859-2'].
	^codepage.
!

content
	content isNil ifTrue:
		[(self contentType ~= 'text/html')
			ifTrue: [self refreshContent]
			ifFalse: [self content: ''] ].
	^content
!

contentType
	"MIME type of original content. 'unknown' if not known"
	contentType isNil ifTrue: [self contentType: 'unknown'].
	^contentType.
!

filename
        | homeDir |
#fixme.
        (filename isKindOf: Filename) ifTrue: [self filename: filename].
        filename isNil ifTrue: [^''].
        (filename includes: $: ) ifTrue:   " TEMPORARY !!!!!!"
                [filename := filename copyReplaceAll: (filename copyUpTo: ':') with: ''.
                homeDir := self site homeDirectory copyReplaceAll: (filename copyUpTo: ':') with: ''.
                filename := filename copyReplaceAll: homeDir with: ''].
        ^(self site homeDirectory,
                (SpFilename named:(filename copyReplaceAll: self site homeDirectory with: ''))).
!

put: aString
	"replace self with contents in aString from PUT request"
	self content: aString.
	self writeToFile
!

site
	^site
!

size
	"size of content in bytes"
	(self contentType = 'text/html')
		ifTrue: [^self elements inject: 0 into: [:sum : e | sum + e size] ]
		ifFalse: [^self content size]
! !

!FileProxy methodsFor:'accessing-tags'!

bodyTagIndex
	"index of element, which represent body tag in original html file"
	^bodyTagIndex
!

bodyTagIndex: anInteger
	"set the index of element, which represent body tag in original html file"
	bodyTagIndex := anInteger.
!

clearImgTagIndexes
	imgTagIndexes := OrderedCollection new.
!

clearLinkTagIndexes
	linkTagIndexes := OrderedCollection new.
!

clearServletTagIndexes
	servletTagIndexes := OrderedCollection new.
!

imgTagIndexes
	"indexes of elements, which represent image tags in original html file"
	imgTagIndexes isNil ifTrue: [self clearImgTagIndexes].
	^imgTagIndexes
!

linkTagIndexes
	"indexes of elements, which represent link tags in original html file"
	linkTagIndexes isNil ifTrue: [self clearLinkTagIndexes].
	^linkTagIndexes
!

servletTagIndexes
	"indexes of elements, which represent servlet in original html file"
	servletTagIndexes isNil ifTrue: [self clearServletTagIndexes].
	^servletTagIndexes
! !

!FileProxy methodsFor:'accessing-timestamps'!

accessedTimestamp
	^Timestamp
		fromDate: ((self timestamps at: #accessed ifAbsent: [^nil]) at: 1)
		andTime: ((self timestamps at: #accessed ifAbsent: [^nil]) at: 2)
!

createdTimestamp
	(self timestamps includesKey: #created) ifFalse: [^self modifiedTimestamp].
	^Timestamp
		fromDate: ((self timestamps at: #created) at: 1)
		andTime: ((self timestamps at: #created) at: 2).
!

expiresTimestamp
	"for broswer: after 6 hours by default. It is good to reload from time to time
	if changes were made "
	^Timestamp fromSeconds: (Timestamp now asSeconds + (6 * 3600))
!

modifiedTimestamp
	^Timestamp
		fromDate: ((self timestamps at: #modified ifAbsent: [^nil]) at: 1)
		andTime: ((self timestamps at: #modified ifAbsent: [^nil]) at: 2)
! !

!FileProxy methodsFor:'indexing'!

indexContent
	"index text in server global index"
	self contentType = 'text/html' ifTrue: [self site index indexObject: self]
!

indexText
	"pure text, without tags, for indexer"
	| stream bodyStart element text |
	bodyStart := (1 to: self elements size)
		detect: [:index | '<BODY*' match: (self elements at: index)] ifNone: [1].
	stream := WriteStream on: String new.
	bodyStart + 1 to: self elements size do:  [:index |
		element := self elements at: index.
		(element notEmpty and: [element first ~= $<]) ifTrue: [stream nextPutAll: element] ].
	text := stream contents "copyReplaceAll: WebElement new eol with: ' '".
	text := text copyReplaceAll: '&nbsp;' with: ' '.
	^text
!

indexTitle
	"find title, if noone, then return url"
	1 to: self elements size do: [:index |
		('<TITLE*' match: (self elements at: index)) ifTrue: [^self elements at: index+1] ].
	^self site urlResolver halfUrlFor: self
! !

!FileProxy methodsFor:'initialize - release'!

clearElements
	elements := OrderedCollection new.
!

refreshContent
	self from: self filename asString.
!

releaseContent
	"release origContent and elements to save memory"
	content := nil.
	elements := nil.
! !

!FileProxy methodsFor:'parsing'!

absoluteTagFrom: aTagString urlStart: anURLString

	""

	| tag url |
	tag := (aTagString copyReplaceAll: '\' with: '/').
	((tag copyFrom: 1 to: 3) = '../')
		ifFalse:  "not relative to parent directory"
			[^((tag copyUpTo: $"), '"', anURLString,
				(tag copyFrom: ((tag indexOf: $") + 1) to: tag size))]
		ifTrue:
			[tag := tag readStream upTo: $/; upToEnd.
			url := anURLString copyFrom: 1 to: (anURLString lastIndexOf: $/).
			^self absoluteTagFrom: tag urlStart: url].
!

from: aString
        | file relFilename |
        file := (SpFilename named: aString). file exists ifFalse: [^nil].
        relFilename := (file asString copyReplaceAll: self site homeDirectory with: '').
        self filename: (relFilename isEmpty ifTrue: ['\'] ifFalse: [relFilename]).
        self refreshTimestamps.
        self contentType: (self contentTypeOfFile: file).
        self contentType = 'text/html'
                ifTrue:
                        [self content: file contentsOfEntireFile.
                        self codepage: (self detectCodepage: self content).
                        self content: (AIDASite convert: self content fromCodepage: self codepage).
                        "self prepareHTMLPage. self makeAbsoluteImgTags. self content: nil"]
                ifFalse: [ | stream |
                        [stream := file readStream binary. self content: stream contents] ensure: [stream close] ]
!

makeAbsoluteImgTags
	"if image url's are relative, make them absolute. Also do it for a body tag (background image).
	Url is constructed from a imageServer address from WebServer settings, and from filename with   homeDirectory substracted. "
	| fname urlStart index tag bodyTag |
	fname := (self filename asString) copyReplaceAll: (self site homeDirectory) with: ''.
	fname := fname copyFrom: 1 to: (fname lastIndexOf: (AIDASite slash at: 1)).
	urlStart := 'http://', self site address, (fname copyReplaceAll: '\' with: '/').
	self imgTagIndexes do: [:inx  | tag := self elements at: inx.
		('*http://*' match: tag) ifFalse:    "not an absolute source url"
			[self elements at: inx put: (self absoluteTagFrom: tag urlStart: urlStart)] ].
	self bodyTagIndex notNil ifTrue:
		[bodyTag := self elements at: bodyTagIndex.
		(('*background*' match:  bodyTag) and: [('*http://*' match:  bodyTag) not])
			ifTrue:
				[index := bodyTag asLowercase findString: 'background' startingAt: 1.
				index := bodyTag findString: '"' startingAt: index.
				(( bodyTag at: index+1) = $#) ifTrue: [^self]. "only colored background"
				self elements at: bodyTagIndex put:
					((bodyTag copyFrom: 1 to: index), urlStart,
						(bodyTag copyFrom: index + 1 to: bodyTag size)) ] ].
!

prepareHTMLPage
	"decompose content into elements (texts and tags)"
	| stream tag index |
	self clearElements. self clearImgTagIndexes.
	self clearLinkTagIndexes. self clearServletTagIndexes.
	stream := ReadStream on: self content.
	index := 1.
	[stream atEnd] whileFalse:
		[self elements add: (stream upTo: $<). index := index + 1.
		tag := ('<', (stream upTo: $>), '>').
		('<aida*' match: tag) ifTrue: [self servletTagIndexes add: index].
		('*img*' match: tag) ifTrue: [self imgTagIndexes add: index].
		('*href*' match: tag)
			ifTrue: [self linkTagIndexes add: index]
			ifFalse:
				[(('*body*' match: tag) and: [('*/body*' match: tag) not])
					ifTrue: [self bodyTagIndex: index]].
		self elements add: tag. index := index + 1.
		].
"
	self elements markDirty.
	self imgTagIndexes markDirty.
	self linkTagIndexes markDirty.
"
! !

!FileProxy methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	"convert elements into a HTML stream"
	aStream nextPutAll: self content asByteString. "temporary text/html too!! "
	self sizeAboveMark ifTrue: [self releaseContent].  "for large files"

"
	self contentType = 'text/html'
		ifTrue:
			[index := 1.
			self elements do: [:each |
				each == self elements last ifTrue: [^self].
				(self servletTagIndexes includes: index)
					ifTrue: [self printServlet: index on: aStream forSession: aSession]
					ifFalse: [aStream nextPutAll:
						(AIDASite convertToWeb: each on: aSession)].
				index := index + 1 ] ]
		ifFalse:
			[aStream nextPutAll: self content asByteString].
"
!

printString
	^('aFileProxy for: ', self filename asString)
!

printWebPageFor: aSession
	self fileStillExist ifFalse: [self removeYourself. ^WebPage new].
	self hasFileChanged ifTrue:
		[self refreshContent.
		self indexContent].
	^self
! !

!FileProxy methodsFor:'printing - servlets'!

argumentsFrom: aMessageString

	^Array new: 0 "for now!! "
!

methodFrom: aMessageString

	^aMessageString asSymbol "for now!! "
!

printServlet: index on: aStream forSession: aSession

	| tag appClass message app element |
	tag := (self elements at: index) copy readStream.
	appClass := (tag upTo: $ ; upTo: $ ) asSymbol.
	message := tag upTo: $>.
	app := aSession servletAppFor: appClass.
	app isNil ifTrue: [^self ].
	element := self servletPerform: message on: app.
	element notNil ifTrue:
		[element printHTMLPageOn: aStream forSession: aSession].
!

servletPerform: aMessageString on: aWebApp

	| method |
	method := (self methodFrom: aMessageString).
	(aWebApp class canUnderstand: method) ifFalse: [^nil].
	^aWebApp
		perform: method
		withArguments: (self argumentsFrom: aMessageString).
! !

!FileProxy methodsFor:'private'!

codepage: aSymbol
	codepage := aSymbol.
!

content: aString
	content := aString.
!

contentType: aMIMEString
	"MIME type of original content"
	contentType := aMIMEString.
!

contentTypeOfFile: aFilename
	"return a MIME type of aFilename. 'unknown' if filename extension is not known"
	|  fileExtension fileString |
	fileString := aFilename asString.
	(fileString includes: $.) ifFalse: [^'unknown'].
	fileExtension := (fileString copyFrom: (fileString indexOf: $.) to: fileString size) asLowercase.
	(fileExtension = '.htm' or: [fileExtension = '.html']) ifTrue: [^'text/html'].
	(fileExtension = '.gif') ifTrue: [^'image/gif'].
	(fileExtension = '.jpg' or: [fileExtension = '.jpeg']) ifTrue: [^'image/jpeg'].
	^'unknown'
!

detectCodepage: aString
	" "
	| win1250 iso2 sevenBit above127 |
	win1250 := 0.
	aString do: [:ch | (#(200 154 138 158 142) includes: ch asInteger) ifTrue: [win1250 := win1250+1] ].
	iso2 := 0.
	aString do: [:ch | (#(200 185 169 190 174) includes: ch asInteger) ifTrue: [iso2 := iso2+1] ].
	sevenBit := 0.
"       aString do: [:ch | (#(94 123 91 96 64) includes: ch asInteger) ifTrue: [sevenBit := sevenBit+1] ]."
	above127 := 0.
	aString do: [:ch | ch asInteger > 127 ifTrue: [above127 := above127+1] ].
	above127 = 0
		ifTrue: [sevenBit ~= 0 ifTrue: [^#'7bit'] ifFalse: [^#csz] ]
		ifFalse: [iso2 > win1250 ifTrue: [^#'iso-8859-2'] ifFalse: [^#'win-1250'] ].
!

elements

	"all elements (texts and tags) of a gtml page"

	elements isNil ifTrue:
		[self clearElements.
		(self contentType = 'text/html') ifTrue: [self refreshContent] ].
	^elements
!

filename: aFilename
	filename := aFilename asString copyReplaceAll: self site homeDirectory with: ''.
!

refreshTimestamps
        self timestamps: (SpFilename named:self filename) dates.
!

removeYourself
	"remove from url resolver and elsewhere"
	self site urlResolver removeObject: self.
!

site: anAIDASite
	site := anAIDASite.
!

timestamps
	timestamps isNil ifTrue: [self timestamps: Dictionary new.].
	^timestamps
!

timestamps: aDictionary
	" a dictionary with a DateAndTime at:
	#accessed #modified #statusChanged #created"
	timestamps := aDictionary.
!

writeToFile
	| stream |
	[stream := self filename writeStream. stream binary.
	stream nextPutAll: self content]
		ensure: [stream close].
	self refreshTimestamps.
! !

!FileProxy methodsFor:'testing'!

fileStillExist
	^self filename exists
!

hasFileChanged
	"check if original file changed since last visit"
	^self modifiedTimestamp ~= (self filename dates at: #modified).
!

isWebElement
	^false
!

isWebPage
	^true
!

sizeAboveMark

	"test if content is above specified size"
	^self size > (50 * 1024) "bytes"
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPSetCookieField
	instanceVariableNames:'cookies'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPSetCookieField class methodsFor:'accessing'!

fieldName
	^'Set-Cookie'
! !

!HTTPSetCookieField methodsFor:'accessing'!

cookies
	cookies isNil ifTrue: [cookies := OrderedCollection new].
	^cookies
! !

!HTTPSetCookieField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPutAll: (self cookies at: 1).
	2 to: self cookies size
		do:
			[:cookieIndex |
			aStream
				nextPutAll: ', ';
				nextPutAll: (self cookies at: cookieIndex)].
	^self
! !

!HTTPSetCookieField methodsFor:'services'!

addCookie: aCookieString
	^self cookies add: aCookieString
!

combineWith: aSetCookieField
	"^self
I add the cookies of aSetCookieField to my own collection of cookies."

	self cookies addAll: aSetCookieField cookies.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SpSocketBasicTests
	instanceVariableNames:'serverPort serverSocket serverAcceptLoop acceptedSocket'
	classVariableNames:''
	poolDictionaries:''
	category:'SPortDev-SocketsTesting'
!

!SpSocketBasicTests methodsFor:'services'!

serverIPAddress
	^SpIPAddress hostName: 'localhost' port: self serverPort
!

serverPort
	serverPort isNil ifTrue: [serverPort := 20000].
	^serverPort
!

serverPort: anInteger
	serverPort := anInteger.
	^self
!

startServer
	serverSocket := SpSocket newTCPSocket.
	serverSocket bindSocketAddress: self serverIPAddress.
	serverSocket listenBackloggingUpTo: 5.
	serverAcceptLoop := 
		[acceptedSocket := serverSocket accept.
		acceptedSocket write: (acceptedSocket read: 1024) ]
			forkAt: Processor userBackgroundPriority.
	^self
!

stopServer
	serverAcceptLoop terminate.
	acceptedSocket notNil ifTrue: [acceptedSocket close]. 
	serverSocket close.
	^self
! !

!SpSocketBasicTests methodsFor:'tests'!

test03CreateSocket
	"Using the simple service to create a TCP socket"

	| socket |
	[socket := SpSocket   newTCPSocket] 
			ensure: [socket close].
	^self
!

test11BindSocket
	"Using the simple service to create a TCP socket.  Same effect at test 01 and test 02"

	| aServerSocket |
	[| ipAddress |
	aServerSocket := SpSocket newTCPSocket.
	ipAddress := SpIPAddress hostName: 'localhost' port: 20011.
	aServerSocket bindSocketAddress: ipAddress] 
			ensure: [aServerSocket close]
!

test12BindSocket
	"As 11, but set the address reuse option  on before binding."

	| aServerSocket |
	
	[| ipAddress |
	aServerSocket := SpSocket newTCPSocket.
	aServerSocket setAddressReuse: true.
	ipAddress := SpIPAddress hostName: 'localhost' port: 20012.
	aServerSocket bindSocketAddress: ipAddress] 
			ensure: [aServerSocket close]
!

test21Listen
	"Create a socket, set it to listen and close it again.
	To check this out on Linux:
		Put a breakpoint in the ensure block
		Run the method using SUnit debug
		From a linux shell prompt:'netstat -na | grep 20021'
		note the socket is listening
		Resume the Smalltalk process & let the socket close
		Run netstat again - socket not listed any more."

	| aServerSocket |
	[| ipAddress |
	aServerSocket := SpSocket newTCPSocket.
	ipAddress := SpIPAddress hostName: 'localhost' port: 20021.
	aServerSocket bindSocketAddress: ipAddress.
	aServerSocket listenBackloggingUpTo: 5.] 
			ensure: [aServerSocket close]
!

test31Accept
	"accept connection from a bound listening socket.  Close without having 
	handled any requests."

	|aServerSocket |
	[| ipAddress acceptLoopProcess |
	aServerSocket := SpSocket newTCPSocket.
	ipAddress := SpIPAddress hostName: 'localhost' port: 20031.
	aServerSocket bindSocketAddress: ipAddress.
	aServerSocket listenBackloggingUpTo: 5.
	acceptLoopProcess := [aServerSocket accept] forkAt: Processor userBackgroundPriority.
	(Delay forMilliseconds: 200) wait.
	acceptLoopProcess terminate] 
			ensure: [aServerSocket close]
!

test32Accept
	"As 31, but using the startServer stopServer services of this test class."

	self serverPort: 20032.
	self startServer.
	(Delay forMilliseconds: 200) wait.
	self stopServer.
	^self
!

test41Connect
	"accept connections from a bound listening socket.  connect another
	socket to that port and close everything.
	If you hit a socket in use problem, use netstat -an to see what is going on, and
	wait for any TIME_WAITs to expire."

	| clientSocket |
	self serverPort: self serverPort + 41.
	self startServer.
	[clientSocket := SpSocket newTCPSocket.
	clientSocket connectTo: self serverIPAddress] 
			ensure: 
				[(Delay forMilliseconds: 200) wait.
				clientSocket close].
	self stopServer
!

test51IO
	"Establish a client connection to a server socket, write something over the socket (the
	server will reflect it back), and read from the socket."

	| clientSocket |
	self serverPort: self serverPort + 51.
	self startServer.
	[| subjectBytes readBytes |
	clientSocket := SpSocket newTCPSocket.
	clientSocket connectTo: self serverIPAddress.
	subjectBytes := 'Hello, World' asByteArray.
	clientSocket write: subjectBytes.
	readBytes := clientSocket read: 1024.
	self assert: readBytes = subjectBytes] 
			ensure: 
				[(Delay forMilliseconds: 200) wait.
				clientSocket close].
	self stopServer
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#VersionSpec
	instanceVariableNames:'object number current parent next'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

VersionSpec comment:'VersionSpec defines a versioned object by its number and position in version chain.

Instance Variables:
	number  <String>         number of that version. Integer by default, but it can be any string
	current <Boolean> true, if this version is current, that is, most important, released, etc.
	parent  <Object> parent, that is, previous version of that object, nil if noone
	next            <Object> next version of that object, nil if noone

'
!

!VersionSpec class methodsFor:'instance creation'!

firstFor: anObject
	"for a first version of an object"
	^super new
		object: anObject;
		setDefaultNumber;
		setCurrent
!

newFromParent: anOldObject for: aNewObject
	| newSpec |
	newSpec := super new
		object: aNewObject;
		parent: anOldObject;
		setIncrementedNumberFromParent;
		clearCurrent.
	aNewObject version: newSpec.
	anOldObject version next: aNewObject.
	^newSpec
! !

!VersionSpec class methodsFor:'private'!

new
	^self shouldNotImplement
! !

!VersionSpec methodsFor:'accessing'!

allVersionSpecs
	^self olderVersionSpecs, (Array with: self), self newerVersionSpecs
!

currentVersionSpec
	"find a version spec of current object in a chain"
	self isCurrent ifTrue: [^self].
	^self olderVersionSpecs detect: [:each | each isCurrent] ifNone:
		[^self newerVersionSpecs detect: [:each | each isCurrent]
			ifNone: [self error: 'no current version!!'] ].
!

newerVersionSpecs
	"return all version specs of that object, newer than this one"
	self isNewest ifTrue: [^#()].
	^OrderedCollection new
		add: self next version; addAll: self next version newerVersionSpecs;
		yourself
!

next
	"next version of an object in version chain, if any"
	^next
!

number
	"version number, integer by default, but it can be any string"
	^number
!

number: aString
	number := aString
!

object
	"object for which is this version spec"
	^object
!

olderVersionSpecs
	"return all version specs of that object, older than this one"
	self isOldest ifTrue: [^#()].
	^OrderedCollection new
		addAll: self parent version olderVersionSpecs; add: self parent version;
		yourself
!

otherVersionSpecs
	"older and newer versions, if any"
	^self olderVersionSpecs, self newerVersionSpecs
!

parent
	"older version of an object in version chain, if any. It is a parent of that object,
	because it is derived from it"
	^parent
!

setCurrent
	self current: true.
	self otherVersionSpecs do: [:each | each clearCurrent].
!

versionSpecWithNumber: aString
	"find spec  with that version number"
	self number = aString ifTrue: [^self].
	^self olderVersionSpecs detect: [:each | each number = aString] ifNone:
		[^self newerVersionSpecs detect: [:each | each number = aString] ifNone: [nil] ].
! !

!VersionSpec methodsFor:'initalize-release'!

setDefaultNumber
	self isOldest
		ifTrue: [self number: '1']
		ifFalse: [self setIncrementedNumberFromParent]
!

setIncrementedNumberFromParent
	"for now, later it should increment last number in string"
	self number: (self parent version number asInteger + 1) printString
! !

!VersionSpec methodsFor:'private'!

clearCurrent
	current := false
!

current
	"this version current one? Current version object have a direct url, without 'version=' in query part"
	^current
!

current: aBoolean
	current := aBoolean
!

next: anObject
	next := anObject
!

object: anObject
	object := anObject
!

parent: anObject
	parent := anObject
!

printString
	^'aVersionSpec version: ', self number
! !

!VersionSpec methodsFor:'testing'!

isCurrent
	^self current
!

isNewest
	^self next isNil
!

isOldest
	^self parent isNil
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebForm
	instanceVariableNames:'view ids fields tabOrder'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebForm class methodsFor:'constants'!

idFieldName
	"this name is used to name a hidden field which is included in every form to identify
	it from other forms. The name is so strange so that you probably won't name your field the same"

	^'id5273'
! !

!WebForm methodsFor:'accessing'!

app
	^self parent
!

clear
	"delete all elements on the form. Also reset instance variables fields and fieldNum"
	super clear.
	self initFields. self initTabOrder.
!

view
	"for which app view is that form"
	^view
! !

!WebForm methodsFor:'events'!

onReset: aJavascriptCode
	self attributesAt: #onReset put: aJavascriptCode
!

onSubmit: aJavascriptCode
	self attributesAt: #onSubmit put: aJavascriptCode
! !

!WebForm methodsFor:'initialize-release'!

initFieldSet
	"with all fields for fast check, if field is already registered"
	^self fields at: #set put: Set new.
!

initFields
	fields := Dictionary new.
	self initFieldSet. "with all fields for fast check, if field is already registered"
!

initIdField
	"hidden id field in a form will provide  view identification of posted form"
	self add: (WebInputField new
		name: (self class idFieldName);
		type: #hidden;
		aspect: #view
		for: self app).
!

initIds
	ids := Dictionary new.
	ids at: #setOfRegisteredElements put: Set new.
!

initTabOrder
	tabOrder := OrderedCollection new.
! !

!WebForm methodsFor:'model adapting'!

acceptFormInputFrom: aRequest
	"read a post data from request and write values to the valueModels of fields in a form.
	For checkboxes and radiobuttons, a set of values is expected under the same name"
	| postData |
	postData := HTTPPostDataArray new. "like Dictionary, but multiple values per key"
	self uncheckAllChecboxes. self uncheckAllRadioButtons.
	aRequest  postKeysAndValuesDo: [:key :value | postData at: key put: value].
	self fields keysAndValuesDo: [:key :field |
		(postData includesKey: key) ifTrue:
			[field isCheckBox ifTrue: [field acceptFormInputFrom: postData].
			field isRadioButton ifTrue: [field acceptFormInputFrom: postData].
			field isMenu ifTrue: [field acceptFormInputFrom: postData].
			field isButton ifTrue: ["do nothing"].
			field isFileInputField ifTrue:
				[field value: (postData at: key).
				field acceptFileAttributesFrom: aRequest field: key].
			(field isInputField | field isTextArea)
				ifTrue: [field saveThroughAdapterValue: (postData at: key)]
				]]
!

adaptFormElement: aWebFormElement
	"set appropriate aspect adaptor for that element"
	aWebFormElement isFormElement ifFalse: [^nil].
	(aWebFormElement isRadioButton | aWebFormElement isCheckBox)
		ifTrue: [aWebFormElement joinToForm: self]
		ifFalse:        [aWebFormElement adapt]
!

ajaxAcceptFormInputFrom: aRequest
	"Ajax have only one input per request!!"
	| k postData |
	aRequest isPost not ifTrue:
			[k :=  aRequest queryData keys detect: [:each | 'field*' match: each] ifNone: nil.
			postData := Dictionary new at: k put: (aRequest queryAt: k); yourself]
		ifFalse:
			[k :=  aRequest postData keys detect: [:each | 'field*' match: each] ifNone: nil.
			postData := Dictionary new at: k put: (aRequest postDataAt: k) value; yourself].
	self fields keysAndValuesDo: [:key :field |
		(postData includesKey: key) ifTrue:
			[field isCheckBox ifTrue: [field acceptFormInputFrom: postData].
			field isRadioButton ifTrue: [field acceptFormInputFrom: postData].
			field isMenu ifTrue: [field acceptFormInputFrom: postData].
			field isButton ifTrue: ["do nothing"].
			field isFileInputField ifTrue:
				[field value: (postData at: key).
				field acceptFileAttributesFrom: aRequest field: key].
			(field isInputField | field isTextArea)
				ifTrue: [field saveThroughAdapterValue: (postData at: key)]
				]]
!

registerFormElementsIn: aWebElement
	"find and register (add to fields ans set aspect adapters) all form elements in this and subelements"
	aWebElement isNil ifTrue: [^nil].
	aWebElement isFormElement ifTrue:
		[(aWebElement name isNil or: [aWebElement name isEmpty])
			ifTrue:
				[aWebElement name: 'field', (self fields size + 1 - 1"set") printString.
				self addToFields: aWebElement]
			ifFalse:
				[(self alreadyRegistered: aWebElement) ifFalse: [self addToFields: aWebElement]].
		self adaptFormElement: aWebElement].
	aWebElement isComposite ifTrue:
		[aWebElement elements do: [:each | self registerFormElementsIn: each] ]
!

uncheckAllChecboxes
	self fieldSet do: [:each | each isCheckBox ifTrue: [each uncheckValue] ]
!

uncheckAllRadioButtons
! !

!WebForm methodsFor:'printing'!

prepareToHTMLPrintOn: aSession
	super prepareToHTMLPrintOn: aSession.
	self reorderTabulation. "late reordering to ensure that all form elements are present"
!

printHTMLPageOn: aStream forSession: aSession
	| action |
	self prepareToHTMLPrintOn: aSession.
	action := aSession fullUrlForCurrentPage.
	aStream nextPutAll:
		self ident, '<form  method=post action="', action, '"', ' enctype="multipart/form-data"'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll:  self ident, '</form>', self eol.
! !

!WebForm methodsFor:'private'!

shouldIdent
	^true
!

tabOrder
	"return a collection of all fields in this form, ordered by tab order"
	tabOrder isNil ifTrue: [self initTabOrder].
	^tabOrder
!

view: anObject
	view := anObject
! !

!WebForm methodsFor:'private-fields'!

addToFields: aWebFormElement
	"and to tab order"
	(self alreadyRegistered: aWebFormElement) ifTrue: [^self error: 'already exist!!'].
	self fields at: aWebFormElement name put: aWebFormElement.
	self tabOrder add: aWebFormElement.
	^self fieldSet add: aWebFormElement
!

alreadyRegistered: aWebFormElement
	^self fieldSet includes: aWebFormElement
!

fieldSet
	^self fields at: #set ifAbsent: [self initFieldSet].
!

fields
	"return a dictionary of all fields in this form. a field name is used as a key"
	fields isNil ifTrue: [self initFields].
	^fields
! !

!WebForm methodsFor:'private-ids'!

elementForMethod: aSymbol
	^self registeredSet detect: [:each | each method = aSymbol] ifNone: [nil]
!

elementId: aSymbol
	^self ids at: aSymbol ifAbsent: [nil].
!

ids
	"dictionary of elements which have id defined, for fast access to them from AJAX requests"
	ids isNil ifTrue: [self initIds].
	^ids
!

isRegistered: anElement
	^self registeredSet includes: anElement
!

isRegisteredMethod: aSymbol
	aSymbol = #'doesNotUnderstand:' ifTrue: [^false]. "WebStyle methods are somehow such"
	^self registeredSet contains: [:each | each method = aSymbol].
!

nextId
	" example: #id9 "
	^('id', (self ids size+1) printString) asSymbol
!

registerIdFor: anElement
	(anElement method notNil and: [self app session lastRequest isAjaxRequest
		and: [self isRegisteredMethod: anElement method]])
			ifTrue: [self registerIdFor: anElement instead: (self elementForMethod: anElement method)].
	anElement id isNil ifTrue: [^anElement id: self nextId]. "auto id if not manually defined!! "
	(self isRegistered: anElement) ifTrue: [^nil].
	(self ids includesKey: anElement id) ifTrue: [^nil"self error: 'element with that id already exist!!'"].
	self ids at: anElement id put: anElement.
	self registeredSet add: anElement.
!

registerIdFor: anElement instead: anOldElement
	"new anElement should have same id as an old one"
	anOldElement isNil ifTrue: [^nil].
	self registeredSet remove: anOldElement ifAbsent: []; add: anElement.
	self ids removeKey: anOldElement id ifAbsent: [].
	anElement attributesAt: #id put: anOldElement id. "anElement id: would deadlock!! "
	self ids at: anElement id put: anElement.
!

registeredSet
	^self ids at: #setOfRegisteredElements
!

removeId: aSymbol
	| element |
	element := self ids at: aSymbol ifAbsent: [^nil].
	self ids removeKey: aSymbol.
	self registeredSet remove: element ifAbsent: [].
! !

!WebForm methodsFor:'private-tabulation'!

nextTabOrderFrom: aFormElement
	"next element to tab into"
	| inx |
	self tabOrder isEmpty ifTrue: [^nil].
	inx := self tabOrder indexOf: aFormElement.
	inx = 0 ifTrue: [^self tabOrder first].
	inx = self tabOrder size ifTrue: [^self tabOrder last].
	^self tabOrder at: inx+1
! !

!WebForm methodsFor:'tabulation'!

fieldWithTabIndex: aNumber
	"return a form element with that tab index"
	^self tabOrder detect: [:field | field tabIndex = aNumber] ifNone: [nil].
!

reorderTabulation
	"reorders tabOrder to match tabIndex order of form elements"
	| old withIndex |
	old := self tabOrder copy.
	self initTabOrder.
	withIndex := old select: [:each | each tabIndex notNil and: [each tabIndex ~= 0] ].
	withIndex := SortedCollection withAll: withIndex sortBlock: [:a :b | a tabIndex < b tabIndex].
	self tabOrder addAll: withIndex.
	withIndex := withIndex asSet.
	 "those without tab index at the end"
	self tabOrder addAll: (old reject: [:each | withIndex includes: each  ]).
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#HTTPStream
	instanceVariableNames:'underlyingStream'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Compatibility'
!

!HTTPStream class methodsFor:'instance creation'!

onStream: aStream
	^self new onStream: aStream
! !

!HTTPStream methodsFor:'accessing'!

contents
	^self underlyingStream contents
! !

!HTTPStream methodsFor:'accessing-private'!

underlyingStream
	^underlyingStream
! !

!HTTPStream methodsFor:'initialize-release'!

onStream: aStream
	underlyingStream := aStream.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SwazooSocketTest
	instanceVariableNames:'input output'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!SwazooSocketTest methodsFor:'running'!

setUp
	| pair |
	pair := SwazooSocket connectedPair.
	input := pair first.
	output := pair last
!

tearDown
	input close.
	output close
! !

!SwazooSocketTest methodsFor:'testing'!

testConnectedPair
	(Array with: input with: output) 
		do: [:each | self assert: (each isKindOf: SwazooSocket)]
!

testNetworkConnection
	| server sem |
	input close.
	output close.
	sem := Semaphore new.
	
	[server := SwazooSocket serverOnIP: '127.0.0.1' port: 65423.
	server listenFor: 50.
	
	[input := server accept.
	sem signal] fork.
	output := SwazooSocket connectTo: 'localhost' port: 65423.
	sem wait.
	self testReadWrite] 
			ensure: [server close]
!

testPartialRead
	| bytes |
	bytes := ByteArray withAll: #(5 4 3).
	self assert: (input write: bytes) = 3.
	self assert: (output read: 5) = bytes
!

testReadTimeout
	input write: (ByteArray withAll: #(1 2 3)).
	self assert: (output read: 3 timeout: 40) = (ByteArray withAll: #(1 2 3)).
	self assert: (output read: 3 timeout: 40) = ByteArray new
!

testReadWrite
	| bytes |
	bytes := ByteArray withAll: #(1 2 3 4 5).
	self assert: (input write: bytes) = 5.
	self assert: (output read: 5) = bytes.
	bytes := ByteArray with: 4.
	self assert: (input write: bytes) = 1.
	self assert: (output read: 1) = bytes
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPCacheControlField
	instanceVariableNames:'directives private maxAge noStore noCache mustRevalidate'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPCacheControlField class methodsFor:'accessing'!

fieldName
	^'Cache-Control'
! !

!HTTPCacheControlField methodsFor:'accessing'!

directives
	"for easy setting directives in one string"
	^directives
!

directives: aString
	"for easy setting directives in one string"
	"example: 'no-store, no-cache, must-revalidate'"
	directives := aString
!

maxAge
	"^an Integer or nil
I return my max age which is either an integer number of seconds for which the entity can be considdered fresh, or nil, in which case other headers such as Expires can be used by a cache to determine the expiration time of the entity."

	^maxAge
!

private
	"^a Boolean or nil
There are three possible values for private.  Explicity true (the entity can only be cached in private caches), explicity false (this is a public entity and can be held in a shared/public cache perhaps even when stale) or nil (the default which means that the entity may be held in a public shared cache, but only until it goes stale)."

	^private
! !

!HTTPCacheControlField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPut: Character space.
	self directives notNil ifTrue: [aStream nextPutAll: self directives].
	self private notNil
		ifTrue:
			[self writePublicOrPrivateTo: aStream.
			self maxAge notNil ifTrue: [aStream nextPutAll: ', ']].
	self maxAge notNil ifTrue: [self writeMaxAgeTo: aStream].
	^self
!

writeMaxAgeTo: aStream
	"^self
I write the maxAge directive to aStream"

	aStream nextPutAll: 'max-age='.
	self maxAge printOn: aStream.
	^self
!

writePublicOrPrivateTo: aStream
	"^self
I write the either the public or the private directive to aStream"

	self private
		ifTrue: [aStream nextPutAll: 'private']
		ifFalse: [aStream nextPutAll: 'public'].
	^self
! !

!HTTPCacheControlField methodsFor:'services'!

maxAge: anIntegerOrNil
	"^self
I record the number of seconds for which the resource is 'fresh' and after which will expire and become 'stale' for caching purposes.  Setting this to nil means the max age is unspecified, and this is the default.  This directive takes presidence over any Expires header when a cache or client is handling an HTTP message."

	maxAge := anIntegerOrNil.
	^self
!

setNotPublicOrPrivate
	"^self
I am being told that the entity in my message is not explicity public or private.  This is the default and means that public caches may retain copies of the resource, but should not be as relaxed about the rules as with an explicitly public resource. c.f >>setPublic & >>setPrivate."

	private := nil.
	^self
!

setPrivate
	"^self
I am being told that the entity in my message is a private one that can only be cached on private caches, i.e. caches that can be drawn upon a single clients.  An example of a private cache is the one *inside* your web browser.   This is probably what you want if the entity contains personal information."

	private := true.
	^self
!

setPublic
	"^self
I am being told that the entity in my message is a public one that can be cached on public caches, i.e. caches that can be drawn upon by many clients.  This is probably not what you want if the entity contains personal information!!  c.f. >>setPrivate  Note that expicitly setting cache-control public actually loosens some other rules and means resources can be used by cached beyond their normal life."

	private := false.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#AIDARoot
	instanceVariableNames:''
	classVariableNames:'Root Lock'
	poolDictionaries:''
	category:'Aida-Support'
!

!AIDARoot class methodsFor:'critical sections'!

critical: aBlock
	"For protecting critical sections in parallel execution of web requests. Use it always
	when you do things, which cannot be disturbed by another request. Example:
		WebTransactionMonitor critical: [<a block with critical section>]. "

	^self localCritical: aBlock
!

localCritical: aBlock
	"For protecting critical sections in parallel execution of web requests. Use it always
	when you do things, which cannot be disturbed by another request. Example:
		WebTransactionMonitor critical: [<a block with critical section>]. "

	^self lock critical: aBlock
! !

!AIDARoot class methodsFor:'private'!

initLock
	Lock := RecursionLock new.
!

initRoot
	Root := self newRootObject.
!

lock
	Lock isNil ifTrue: [self initLock].
	^Lock
!

newRoot: anObject named: aSymbol

	| createAnyway |
	(self root includesKey: aSymbol) ifTrue:
		[createAnyway := Dialog confirm: 'Root named ',
			aSymbol asString, ' already exist!! Do you realy want to replace it?'.
		createAnyway ifFalse: [^nil] ].
	self root at: aSymbol put: anObject.
	self inGemstone ifTrue: [GBSM currentSession commitTransaction]
!

newRootObject
	^Dictionary new
!

removeRootNamed: aSymbol
	| realyRemove |
	(self root includesKey: aSymbol) ifTrue:
		[realyRemove := Dialog confirm: 'Do you realy want to remove a root named ',
			aSymbol asString, ' ?'.
		realyRemove ifFalse: [^nil] ].
	self root removeKey: aSymbol ifAbsent: [].
!

root
	Root isNil ifTrue: [self initRoot].
	^Root
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SpSocket
	instanceVariableNames:'underlyingSocket socketAddress'
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Sockets'
!

!SpSocket class methodsFor:'instance creation'!

connectToServerOnHost: hostName port: portNumber
	"^a SpSocket
	I return a new instance of myself which represents a socket connecter
	to a server listening on portNumber at hostName."
	| newSocket |
	newSocket := self newTCPSocket.
	newSocket
		connectTo: (SpIPAddress hostName: hostName port: portNumber).
	^ newSocket
!

newSocketPair
	"I return an array containing two SpSockets each representing one end of a
	TCP connection. Port is fixed (for now)!! "
	"SpSocket newSocketPair"
	| s1 s2 s3 |
	[s1 := self newTCPSocket
		setAddressReuse: true;
		bindSocketAddress: (SpIPAddress hostName: 'localhost' port: 3523);
		listenBackloggingUpTo: 50.
	s2 := SpSocket connectToServerOnHost: 'localhost' port: 3523.
	s3 := s1 accept]
		ifCurtailed:    [s1 close. s2 close].
	s1 close.
	^Array with: s3 with: s2
!

newTCPSocket
	"^a SpSocket
	I return a new instance of myself that represents an unconfigured TCP socket."

	Socket initializeNetwork.
	^self new onUnderlyingSocket: Socket newTCP
! !

!SpSocket class methodsFor:'private'!

onNativeclientSocket: aNativeSocket for: aServerSocket
	"^a SpSocket
	I create a new instance of my self at the request of aServerSocket  where
	this new instance will be a connected client socket (connected via aNativeSoket)."

	^self new onNativeclientSocket: aNativeSocket for: aServerSocket
! !

!SpSocket methodsFor:'initialize-release'!

onUnderlyingSocket: aSocket
	underlyingSocket := aSocket.
	^self
! !

!SpSocket methodsFor:'private'!

onNativeclientSocket: aNativeSocket for: aServerSocket
	"^self
	I initialize myself with the same properties as aServerSocket and with
	aNativeSocket as my underlying socket."

"       communicationDomain := aServerSocket communicationDomain.
	socketType := aServerSocket socketType.
	protocolNumber := aServerSocket protocolNumber."

	underlyingSocket := aNativeSocket.
	^self
!

underlyingSocket
	^underlyingSocket
! !

!SpSocket methodsFor:'services-accessing'!

getPeerName
	"^a SpSocketAddress
	see man getpeername.
	I return the socket address of the other/remote/peer end of the socket I represent."

	^ SpIPAddress
		host: self underlyingSocket remoteAddress
		port: self underlyingSocket remotePort
!

getSocketName
	"^a SpSocketAddress
	see: man getsockname
	I rreturn my local socket address which may be any subclass of SpSocketAddress."

	^ SpIPAddress
		host: self underlyingSocket localAddress
		port: self underlyingSocket localPort
! !

!SpSocket methodsFor:'services-io'!

read: targetNumberOfBytes
	"^a ByteArray
	I attempt to read the targetNumberOfBytes from my underlying socket.
	If the targetNumberOfBytes      are not available, I return what I can get."

	| targetByteArray numberOfBytesActuallyRead |
	^ SpExceptionContext
		for:
			[targetByteArray := ByteArray new: targetNumberOfBytes.
			numberOfBytesActuallyRead := self underlyingSocket
				receiveDataInto: targetByteArray.
			targetByteArray copyFrom: 1 to: numberOfBytesActuallyRead]
		on: Error
		do: [:ex | SpSocketError raiseSignal: ex]
!

readInto: aByteArray startingAt: startIndex for: aNumberOfBytes
	"^an Integer
	I return the number of bytes actually read.     In Squeak it seems we can not specify the
	number of bytes to be read.     We get what its there no matter how much their is!!"
	| actuallyRead |
	actuallyRead := self underlyingSocket receiveDataInto: aByteArray startingAt: startIndex.
	actuallyRead > aNumberOfBytes
		ifTrue: [1 halt].
	^ actuallyRead
!

readyForRead
	"^a Boolean
	I return true if a read operation will return some number of bytes."

	^self underlyingSocket dataAvailable
!

waitForReadDataUpToMs: aNumberOfMilliseconds
	"^a Boolean
	I return true if we think data became available within
	aNumberOfMilliseconds, and false if we timed out.
	Squeak wants a timeout in seconds, so I convert it here."

	| aNumberOfSeconds |
	aNumberOfSeconds := (aNumberOfMilliseconds / 1000) ceiling.
	self underlyingSocket
		waitForDataFor: aNumberOfSeconds
		ifClosed: [SpError signal: 'Socket closed while waiting for data'. ^false]
		ifTimedOut: [^false].
	^true
!

write: sourceByteArray
	"^an Integer
	I write the contents of the sourceByteArray to my underlying Socket.
	I return the number of bytes written."

	^SpExceptionContext
		for: [self underlyingSocket sendSomeData: sourceByteArray]
		on: Error
		do: [:ex | SpSocketError raiseSignal: ex]
!

writeFrom: aByteArray startingAt: startIndex for: length
	"^an Integer
	I return the number of bytes actually written."

	^self underlyingSocket
		sendSomeData: aByteArray
		startIndex: startIndex
		count: length
! !

!SpSocket methodsFor:'services-options'!

setAddressReuse: aBoolean
	"^self
	c.f. self class >>socketOptions and self >>setOptionForLevel:optionID:value:
	If a boolean is true, I set address reuse on, otherwise I set address reuse     off. "

	"self underlyingSocket setOption: 'SO_REUSEADDR' value: aBoolean"
! !

!SpSocket methodsFor:'services-status'!

accept
	"^a SpSocket
	I accept the next connection made to the server socket I represent.
	This is a *blocking* request. That is, this method will not exit until
	an inbound socket connection is made. When that happens the new
	socket connected to the client (not the server socket) will be returned."
	^ SpExceptionContext
		for: [| clientSpecificSocket |
			[(clientSpecificSocket := self underlyingSocket
				waitForAcceptFor: 1
				ifTimedOut: [nil]) isNil] whileTrue.
			self class onNativeclientSocket: clientSpecificSocket for: self]
		on: Error
		do: [:ex | SpSocketError new
			parameter: ex;
			raiseSignal: 'Error while trying to accept a socket connection.']
!

acceptRetryingIfTransientErrors

	"^a SpSocket
	I try to do an accept.  If I get an exception which is 'transient' I retry.
	For now in Squeak, I just do the accept"

	"^SpExceptionContext
		for: [self accept]
		on: OSErrorHolder transientErrorSignal
		do: [:ex | ex restart]"

	^self accept
!

bindSocketAddress: aSocketAddress
	"^self
	Equivalent of: bind(int sockfd, struct sockaddr *my_addr, socklen_t     addrlen);
	see man bind. Bind the socket to aSocketAddress.        It seems that Squeak merges
	the 'bind' and the 'listen', so here I'll just  remember the socket address and
	use it when I get the listen request."

	socketAddress := aSocketAddress.
	^self
!

close
	"^self
	The same as the close() posix function."

	self underlyingSocket close
!

connectTo: aSocketAddress
	"^self
	I instruct my underlying socket to connect to aSocketAddress."

	self underlyingSocket
		connectTo: aSocketAddress hostAddress
		port: aSocketAddress portNumber
!

listenBackloggingUpTo: aNumberOfConnections
        "^self
        I set the socket I represent listening for incomming connections,
        allowing a      backlog of up to aNumberOfConnections.
        Note that Squeak combines bind and listen so I noted the socket address
        when I was asked to bind - and I use that now.
        OK - I really wanter to be able to specify the interface, but that seems
        to be broken - I get a primitive error when I try to use it"

        self underlyingSocket 
            bindTo:socketAddress portNumber address:nil;
            listenWithBacklog:aNumberOfConnections.

        ^self
! !

!SpSocket methodsFor:'testing'!

isActive
	"^a Boolean
	In Squeak there is no simple >>isActive test, it seems."

	^self underlyingSocket isConnected
		or: [self underlyingSocket isWaitingForConnection]
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebMethodResource
	instanceVariableNames:'site object method contentType preferedUrl'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

!WebMethodResource class methodsFor:'instance creation'!

fromMethod: aSymbol on: anObject contentType: aString preferedUrl: aString2 site: anAIDASite
	^super new
		object: anObject;
		method: aSymbol;
		contentType: aString;
		preferedUrl: aString2;
		site: anAIDASite
!

fromMethod: aSymbol on: anObject contentType: aString site: anAIDASite
	^super new
		object: anObject;
		method: aSymbol;
		contentType: aString;
		site: anAIDASite
! !

!WebMethodResource methodsFor:'accessing'!

contentType
	"MIME type for our resource"
	contentType isNil ifTrue: [self contentType: 'image/gif'].
	^contentType
!

contentType: aString
	contentType := aString
!

expiresTimestamp
	"one hour from now, to avoid reloading of images"
	^SpTimestamp fromSeconds: SpTimestamp now asSeconds + 3600
!

method
	^method
!

method: aSymbol
	method := aSymbol
!

object
	^object
!

object: anObject
	object := anObject
!

preferedUrl
	^preferedUrl
!

preferedUrl: aString
	preferedUrl := aString
!

site
	"a Site on which this resource will be shown"
	^site
!

site: anAIDASite
	site := anAIDASite
! !

!WebMethodResource methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	aStream nextPutAll: (self object perform: self method) asByteArray asString.
!

printWebPageFor: aSession
	^self
! !

!WebMethodResource methodsFor:'testing'!

isWebElement
	^false
!

isWebPage
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPServerField
	instanceVariableNames:'productTokens'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPServerField class methodsFor:'accessing'!

fieldName
	^'Server'
! !

!HTTPServerField methodsFor:'accessing'!

productTokens
	^productTokens
!

productTokens: aString
	productTokens := aString.
	^self
! !

!HTTPServerField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPutAll: self productTokens.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SwazooServer
	instanceVariableNames:'sites servers'
	classVariableNames:'Singleton'
	poolDictionaries:''
	category:'Swazoo-Core'
!

SwazooServer comment:'SwazooServer is where it all begins in Swazoo!!
SwazooServer singleton : return one and only one server which holds the Sites. Also used to start and stop all sites ato once, to add new sited etc. When running, a collection of HTTPServers is also stored in SwazooServer singleton.

SwazooServer demoStart  will create and run a demo site on http://localhost:8888 which
			      returns a web page with ''Hello World!!'''
!

!SwazooServer class methodsFor:'*Aida'!

demoStart
	self singleton demoStart
!

demoStop
	self singleton demoStop
! !

!SwazooServer class methodsFor:'accessing'!

singleton
	Singleton isNil ifTrue: [self initSingleton].
	^Singleton
!

siteHostnamed: aString
	^self singleton siteHostnamed: aString
!

siteNamed: aString
	^self singleton siteNamed: aString
! !

!SwazooServer class methodsFor:'configuration'!

configureFrom: aFilenameString
        | sites stream |
        self singleton removeAllSites.
        stream := (SpFilename named:aFilenameString) readStream.
        [sites := self readSitesFrom: stream] ensure: [stream close].
        sites do: [:each |
                self singleton addSite: each.
                each start]
!

exampleConfigurationFile
	"example sites.cnf, which will serve static files from current directory and respond with
	'Hello Worlrd' from url http://localhost:8888/foo/Howdy"

"<Site>
	<SiteIdentifier ip: '127.0.0.1' port: 8888 host: 'localhost' >
	<CompositeResource uriPattern: '/'>
		<CompositeResource uriPattern: 'foo'>
			<HelloWorldResource uriPattern: 'Howdy'>
		</CompositeResource>
	</CompositeResource>
	<FileResource uriPattern: '/' filePath: '.'>
</Site>
"
! !

!SwazooServer class methodsFor:'initialize'!

initialize
! !

!SwazooServer class methodsFor:'private'!

initSingleton
	Singleton := super new initialize.
!

new
	^self shouldNotImplement
!

prepareDemoSite
	"on http://localhost:8888 to return 'Hello Word' "
	| site |
	site := Site newNamed: 'demo'. "which is also added to SwazoServer"
	site host: 'localhost' ip: 'localhost' port: 8888.
	site addResource: (HelloWorldResource uriPattern: '/').
	^site
!

readSitesFrom: aStream
	| sites instance |
	sites := OrderedCollection new.
	[instance := Site new readFrom: aStream.
	instance notNil] whileTrue: [sites add: instance].
	^sites
! !

!SwazooServer class methodsFor:'start/stop'!

start
	"start all sites"
	self singleton start
!

startSite: aString
	"start site with that name"
	self singleton startSite: aString
!

stop
	"stop all sites"
	self singleton stop
!

stopSite: aString
	"stop site with that name"
	self singleton stopSite: aString
! !

!SwazooServer methodsFor:'*Aida'!

demoStart
	(self siteNamed: 'aidademo') isNil ifTrue:
		[AIDASite newNamed: 'aidademo'].
	self startSite: 'aidademo'
!

demoStop
	self stopSite: 'aidademo'
! !

!SwazooServer methodsFor:'initialize-release'!

initServers
	servers := Set new.
!

initSites
	sites := OrderedCollection new.
!

initialize
	self initSites.
	self initServers.
! !

!SwazooServer methodsFor:'private'!

servers
	servers isNil ifTrue: [self initServers].
	^servers
!

sites
	sites isNil ifTrue: [self initSites].
	^sites
! !

!SwazooServer methodsFor:'private-servers'!

addServer: aHTTPServer
	self servers add: aHTTPServer
!

newServerFor: aSiteIdentifier
	^ aSiteIdentifier newServer.
!

removeServer: aHTTPServer
	self servers remove: aHTTPServer
!

serverFor: aSiteIdentifier
	^self servers detect: [:each | (each ip = aSiteIdentifier ip) & (each port = aSiteIdentifier port)]
		ifNone: [self newServerFor: aSiteIdentifier]
! !

!SwazooServer methodsFor:'sites'!

addSite: aSite
	(self siteNamed: aSite name) notNil
		ifTrue: [^SwazooSiteError error: 'Site with that name already exist!!'].
	(self siteHostnamed: aSite host) notNil
		ifTrue: [^SwazooSiteError error: 'Site with that hostname already exist!!'].
	self sites add: aSite
!

allSites
	^self sites copy
!

removeAllSites
	self sites copy do: [:each | self removeSite: each]
!

removeSite: aSite
	aSite stop.
	self sites remove: aSite
!

siteHostnamed: aString
	"find a site with that hostname"
	| string |
	string := aString isNil ifTrue: [''] ifFalse: [aString asLowercase].
	^self sites detect: [:each |
		each host notNil and: [each host asLowercase = string] ] ifNone: [nil].
!

siteNamed: aString
	"find a site with that short name"
	| string |
	string := aString isNil ifTrue: [''] ifFalse: [aString asLowercase].
	^self sites detect: [:each | each name asLowercase = string] ifNone: [nil].
! !

!SwazooServer methodsFor:'start/stop'!

start
	self sites do: [:site | site start].
!

startSite: aString
	"start site with that name"
	| site |
	site := self siteNamed: aString.
	site notNil ifTrue: [site start].
!

stop
	self sites do: [:site | site stop].
!

stopSite: aString
	"stop site with that name"
	| site |
	site := self siteNamed: aString.
	site notNil ifTrue: [site stop].
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#Numberer
	instanceVariableNames:'counters'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

Numberer comment:'Numberer is used to provide counters for things like invoice numbers

Instance Variables:
	counters        <Dictionary>     counters for different purposes

'
!

!Numberer methodsFor:'accessing'!

currentCounter: aSymbol
	"get curent (last nextCounter) number"
	(self counters includesKey: aSymbol) ifFalse: [self resetCounter: aSymbol].
	^self counters at: aSymbol
!

nextCounter: aSymbol
	"get next number and increment this counter"
	^self counters at: aSymbol put: (self peekCounter: aSymbol)
!

peekCounter: aSymbol
	"get next number but not increment it"
	(self counters includesKey: aSymbol) ifFalse: [self resetCounter: aSymbol].
	^(self counters at: aSymbol) + 1
!

resetCounter: aSymbol
	"put counter to 0, peekCounter will then return 1"
	self counters at: aSymbol put: 0
! !

!Numberer methodsFor:'initialize-release'!

initCounters
	counters := Dictionary new
! !

!Numberer methodsFor:'private'!

counters
	counters isNil ifTrue: [self initCounters].
	^counters
!

decrementCounter: aSymbol
	"get next number and increment this counter"
	^self counters at: aSymbol put: (((self currentCounter: aSymbol) - 1) max: 0)
!

setCounter: aSymbol to: aNumber
	"use it sparingly!!"
	^self counters at: aSymbol put: aNumber
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebUserGroup
	instanceVariableNames:'name users'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!WebUserGroup class methodsFor:'instance creation'!

newActivating
	^super new name: self activatingGroupName
!

newAdmin
	^super new name: self adminGroupName
!

newAllUsers
	^super new name: self allUsersGroupName
!

newRegistered
	^super new name: self registeredGroupName
! !

!WebUserGroup class methodsFor:'defaults'!

activatingGroupName
	"group of users waiting to confirm registration"
	^'Users waiting activation'
!

adminGroupName
	"return a name of group for administrators"
	^'Administrators'
!

allUsersGroupName
	"return a name of group, where all users are there by default"
	^'AllUsers'
!

guestGroupName
	"return a name of group for guests"
	^self allUsersGroupName
!

registeredGroupName
	"return a name of group of registered users"
	^'Registered Users'
! !

!WebUserGroup methodsFor:'accessing'!

allUsers
	^self users copy
!

menuName
	"in dropdown menus"
	^name
!

name
	name isNil ifTrue: [self name: ''].
	^name
!

name: aString
	name := aString.
!

uuid
	"some unique identifier. Hash for now, probably unique enough!! "
	^self hash printString
! !

!WebUserGroup methodsFor:'adding - removing'!

addUser: aWebUser
	self users add: aWebUser.
	aWebUser addToGroup: self.
!

removeUser: aWebUser
	self users remove: aWebUser ifAbsent: [].
	aWebUser removeFromGroup: self.
! !

!WebUserGroup methodsFor:'printing'!

printString
	^'aWebUserGroup: ', self name
! !

!WebUserGroup methodsFor:'private'!

initUsers
	users  := Set new.
!

migrateToUnicode
	"from iso8859-2"
	"WebUserGroup allInstances do: [:each | each migrateToUnicode]"
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].
!

users
	users isNil ifTrue: [self initUsers].
	^users
! !

!WebUserGroup methodsFor:'testing'!

includes: aWebUser
	^self users includes: aWebUser
!

isActivatingGroup
	"group of users waiting to confirm registration"
	^self name = self class activatingGroupName
!

isAdminGroup
	^self name = self class adminGroupName
!

isAllUsersGroup
	^self name = self class allUsersGroupName
!

isGuestGroup
	^self name = self class guestGroupName
!

isRegisteredGroup
	^self name = self class registeredGroupName
!

isWebUser
	^false
!

isWebUserGroup
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SwazooTask
	instanceVariableNames:'request response'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Messages'
!

SwazooTask comment:'A SwazooTask is simply a request-response pair.  This class just makes the task (ha!!) of dealing with requests and responses a bit easier.'
!

!SwazooTask methodsFor:'accessing'!

request
	^request
!

request: aHTTPRequest
	request := aHTTPRequest
!

response
	^response
!

response: aHTTPResponse
	response := aHTTPResponse
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebApplication subclass:#WebHelpPageApp
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Parts'
!

!WebHelpPageApp methodsFor:'actions'!

actionEdit
	self newView: #main
!

actionMainEdit
	self redirectToView: #edit
!

actionNew
	self observee parent add: self observee.
	self newView: #main
! !

!WebHelpPageApp methodsFor:'printing'!

viewEdit
	| e |
	e := WebElement new.
	e cell addTextH4: 'Help page for ', self observee app asString, ', view #', self observee view.
	e newRow.
	e cell addText: 'Title'; addBreak;
		addInputFieldAspect: #title for: self observee size: 79. e newRow.
	e cell addText: 'Contents'; addBreak;
		addRichEditorAspect: #body for: self observee size: 80@20. e newRow.
	e cell addButtonText: 'Save help page'.
	self pageFrameWith: e title: self title
!

viewMain
	| e |
	e := WebElement new.
	e table width: 1 "100%".
	e cell addTextH1: 'Pomoc: ', self observee title. e newRow.
	self canBeEdited ifTrue: [e cell addButtonText: 'Edit' action: #edit. e newRow].
	e cell addText: self observee body asWikiLinksOnlyHtml.
	self pageFrameWith: e title: self title
!

viewNew
	self viewEdit
! !

!WebHelpPageApp methodsFor:'testing'!

canBeEdited
	^self user isAdmin
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#Scheduler
	instanceVariableNames:'site queue loop lock'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

Scheduler comment:'Scheduler is a service for running scheduled events. Events can be single or periodic (daily, hourly, ...).
When event is triggered, its block is executed in a separate low priority process. Scheduler time resolution is 1 second.

Example of periodic event:
	self site scheduler everyHourAt: 30 "minutes" runBlock: [Trascript show: ''half a hour!!].

Instance Variables:
	site            <anAIDASite>
	queue   <OrderedCollection>     queue of events, waiting for execution
	loop    <Process>               loop process, every second looks into queue to run an event
	lock            <RecursionLock> to protect queue operations

'
!

!Scheduler class methodsFor:'instance creation'!

newOn: anAIDASite
	^super new initialize; site: anAIDASite
! !

!Scheduler methodsFor:'events-periodic'!

everyDayAt: aTimeOrHour runBlock: aBlock
	| event |
	event := ScheduledEvent newOn: self.
	event everyDayAt: aTimeOrHour runBlock: aBlock.
	self scheduleEvent: event.
	^event
!

everyHourAt: aMinuteNumber  runBlock: aBlock
	| event |
	event := ScheduledEvent newOn: self.
	event everyHourAt: aMinuteNumber  runBlock: aBlock.
	self scheduleEvent: event.
	^event
!

everyMinuteAt: aSecondNumber callMethod: aSymbol of: anObject
	| event |
	event := ScheduledEvent newOn: self.
	event everyMinuteAt: aSecondNumber callMethod: aSymbol of: anObject.
	self scheduleEvent: event.
	^event
!

everyMinuteAt: aSecondNumber  runBlock: aBlock
	| event |
	event := ScheduledEvent newOn: self.
	event everyMinuteAt: aSecondNumber  runBlock: aBlock.
	self scheduleEvent: event.
	^event
!

everyMonthday: aDayNumber at: aTime  runBlock: aBlock
!

everyWeekday: aDaySymbol at: aTime  runBlock: aBlock
! !

!Scheduler methodsFor:'events-single'!

at: aTimestamp callMethod: aSymbol of: anObject
	| event |
	event := ScheduledEvent newOn: self.
	event at: aTimestamp callMethod: aSymbol of: anObject.
	self scheduleEvent: event.
	^event
!

at: aTimestamp runBlock: aBlock
	| event |
	event := ScheduledEvent newOn: self.
	event at: aTimestamp runBlock: aBlock.
	self scheduleEvent: event.
	^event
! !

!Scheduler methodsFor:'initialize-release'!

initQueue
	queue := OrderedCollection new.
!

initialize
! !

!Scheduler methodsFor:'private'!

considerMissedEvents
	"events which we miss to run, eg. if scheduler didn't run for a while"
	self removeMissedEvents "and nothing more, for now"
!

insertToQueueEvent: aScheduledEvent
	self lock critical:
		[self queue isEmpty ifTrue: [^self queue add: aScheduledEvent].
		aScheduledEvent timestamp >= self queue last timestamp
			ifTrue: [^self queue add: aScheduledEvent].
		aScheduledEvent timestamp < self queue first timestamp
			ifTrue: [^self queue addFirst: aScheduledEvent].
		self queue size to: 1 by: -1 do: [:inx |
			aScheduledEvent timestamp >= (queue at: inx) timestamp ifTrue:
				[^self queue add: aScheduledEvent beforeIndex: inx+1] ]
		]
!

isLoopRunning
	^self loop notNil
!

lock
	lock isNil ifTrue: [lock := RecursionLock new].
	^lock
!

loop
	^loop
!

loop: aProcess
	loop := aProcess
!

printString
	^'aScheduler on site: ', (self site notNil ifTrue: [self site name] ifFalse: [''])
!

queue
	"queue of events next one to run on first place"
	queue isNil ifTrue: [self initQueue].
	^queue
!

removeMissedEvents
	| now event |
	self lock critical:
		[self queue isEmpty ifTrue: [^nil].
		now := Timestamp now asSeconds.
		[now > self queue first timestamp asSeconds] whileTrue:
			[event := self queue first.
			self queue removeFirst.
			event isPeriodic ifTrue: [event reschedule].
			self queue isEmpty ifTrue: [^nil] ]
		]
!

scheduleEvent: aScheduledEvent
	self insertToQueueEvent: aScheduledEvent.
!

schedulerPriority
	^Processor userInterruptPriority
!

site
	^site
!

site: anAIDASite
	site := anAIDASite
!

startLoop
	self isLoopRunning ifTrue: [self stopLoop].
	self loop:
		([ [true] whileTrue:
			[| event now |
			self lock critical:
				[self queue notEmpty ifTrue:
					[event := self queue first. now := Timestamp now asSeconds.
					now = event timestamp asSeconds
						ifTrue:  [event run. self queue removeFirst]
						ifFalse: [now > event timestamp asSeconds  ifTrue: [self removeMissedEvents]] ]].
			(Delay forSeconds: 1) wait]
		] forkAt: self schedulerPriority)
!

stopLoop
	self loop notNil ifTrue: [self loop terminate. self loop: nil].
! !

!Scheduler methodsFor:'start/stop'!

start
	self considerMissedEvents.
	self startLoop
!

stop
	self stopLoop
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebTable
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebTable class methodsFor:'instance creation'!

new
	^super new initialize
! !

!WebTable methodsFor:'attributes'!

bgColor: aColorSymbol
	self attributesAt: #bgcolor put: (self colorValue: aColorSymbol)
!

border: aNumber
	"set the width of table border. default is 0"
	self attributesAt: #border put: aNumber printString.
!

cellPadding: aNumber
	"define spacing between vertically adjacent cells"
	self attributesAt: #cellpadding put: aNumber printString.
!

cellSpacing: aNumber
	"define spacing between adjacent cells horizontally"
	self attributesAt: #cellspacing put: aNumber printString.
!

color: aColorSymbol
	self    bgColor: aColorSymbol
!

height: aNumber
	| text |
	text := aNumber <= 1
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #height put: text
!

width: aNumber
	"set the width of entire table If nil, then table automaticaly addjust itself.
	If number is between 0 and 1 then width is percent of document width.
	If number above 1 then width in pixels"
	| text |
	text := aNumber <= 1
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #width put: text
! !

!WebTable methodsFor:'initialize-release'!

initialize
	"self border: 0."
! !

!WebTable methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self ident, '<table'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</table>', self eol.
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].
! !

!WebTable methodsFor:'testing'!

shouldIdent
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebCounter
	instanceVariableNames:'started day year dailyCounts hourlyCounts todayHourlyCounts total
		yearlyHistory'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!WebCounter class methodsFor:'instance creation'!

new
	^super new reset
! !

!WebCounter class methodsFor:'odb specific'!

instVarMap
	"Gemstone odb"

	^super instVarMap,
		#(      (todayHourlyCounts nil) )
!

replicationSpec
	"Gemstone"
	^super replicationSpec,
		#(      (started max 2)
			(day replicate)
			(year replicate)
			(dailyCounts max 2)
			(hourlyCounts max 2)
			(total replicate)
			(yearlyHistory stub)    )
!

setupOdbStorage
	"Versant"

	self
		store: #(started dailyCounts hourlyCounts total )
		as: #(Integer IntegerArray IntegerArray Integer).
! !

!WebCounter class methodsFor:'summing'!

sumCounters: aCounterCollection

	"return a new counter with sum of all specified counters"
	| sumCounter |
	sumCounter := WebCounter new.
	aCounterCollection do: [:counter |
		sumCounter addCounter: counter].
	^sumCounter
! !

!WebCounter class methodsFor:'testing'!

throughMidnightTest

	Janko := WebCounter new.
	[100 timesRepeat:
		[Janko incCounter.
		(Delay forSeconds: 1) wait]
	] fork.
	^Janko inspect

"WebCounter throughMidnightTest"
!

throughNewYearTest

	Janko := WebCounter new.
	[100 timesRepeat:
		[Janko incCounter.
		(Delay forSeconds: 1) wait]
	] fork.
	^Janko inspect

"WebCounter throughNewYearTest"
! !

!WebCounter methodsFor:'accessing'!

allCountsInYear: aYearNumber

	aYearNumber = self year
		ifTrue: [^self dailyCounts copy]
		ifFalse:
			[^(self yearlyHistory
				at: aYearNumber
				ifAbsent: [^Array new: 366 withAll: 0]) copy]
!

allCountsThatYear

	"return array of counts for each day in current year"

	^self allCountsInYear: Date today year
!

allHourlyCounts

	^self hourlyCounts copy
!

allTodayHourlyCounts

	^self todayHourlyCounts copy
!

countsFrom: aStartDate to: anEndDate

	| collection |
	collection := OrderedCollection new.
	aStartDate asDays to: anEndDate asDays do: [:days |
		collection add: (self countsOnDate: (Date fromDays: days))].
	^collection
!

countsMonthlyFromDate: aDate
	| date collection |
	date := SpDate newDay: 1
		month: aDate monthIndex
		year: aDate year.
	collection := OrderedCollection new.
	[date < SpDate today] whileTrue:
		[collection add: (self countsOnMonth: date monthIndex year: date year).
		date := SpDate newDay: 1
			month: (date + 31) monthIndex
			year: (date + 31) year].
	^collection

"AIDASite default totalCounter countsMonthlyFromDate: Date today - 6"
!

countsMonthlyOnYear: aYear

	^(1 to: 12) collect: [:month | self countsOnMonth: month year: aYear]

"WebServer default totalCounter countsMonthlyOnYear: 1999"
!

countsOnDate: aDate

	| counts |
	counts := self allCountsInYear: aDate year.
	^counts at: aDate day
!

countsOnHour: aNumber

	^self hourlyCounts at: aNumber
!

countsOnMonth: aMonth year: aYear

	| counts date |
	date := SpDate newDay: 1 month: aMonth year: aYear.
	counts := self allCountsInYear: date year.
	^(date day to: date day + date daysInMonth - 1)
		inject: 0 into: [:sum :dy | sum + (counts at: dy)]

"WebServer default totalCounter countsOnMonth: 10 year: 1999"
!

countsTodayOnHour: aNumber

	^self todayHourlyCounts at: aNumber
!

currentWeekCounts

	| firstDay collection |
	firstDay := Date today - Date today weekdayIndex + 1.
	collection := OrderedCollection new.
	firstDay to: firstDay + 6 do: [:date |
		collection add: (self countsOnDate: date)].
	^collection
!

started
	"return a timestamp, from when web visits are counted"

	started isNil ifTrue: [self initStarted].
	^Timestamp fromSeconds: started
!

today

	"return number of requests today"

	^self countsOnDate: Date today
!

todayHourlyCounts: anObject
	todayHourlyCounts := anObject
!

total
	"total number of visits, registered by this counter"

	total isNil ifTrue: [self initTotal].
	^total.
!

yesterday

	"return number of requests yesterday"

	^self countsOnDate: Date today - 1
! !

!WebCounter methodsFor:'adding'!

addCounter: aWebCounter
	"add counts from specified counter"
	aWebCounter year = self year ifTrue:
		[self addArray: aWebCounter dailyCounts to: self dailyCounts].
	self addArray: aWebCounter hourlyCounts to: self hourlyCounts.
	self total: self total + aWebCounter total.
	aWebCounter yearlyHistory keysAndValuesDo: [:yr :array |
		self addArray: array to: (self yearlyHistory at: yr ifAbsentPut: [Array new: 366 withAll: 0]) ].

"WebCounter new addCounter: WebCounter new"
! !

!WebCounter methodsFor:'counting'!

countRequest: aWebRequest

	"register a request by incrementing daily, hourly and total counter."

	self incCounterOnTimestamp: aWebRequest timestamp
!

incCounter

	"increment daily, hourly and total counter with date and time now"

	self incCounterOnTimestamp: SpTimestamp now
!

incCounterOnTimestamp: aTimestamp

	"increment daily, hourly and total counter with date and time defined"


	self incDailyCounterOnDate: aTimestamp asDate.
	self incHourlyCounterOnTimestamp: aTimestamp.
	self incTotal.
! !

!WebCounter methodsFor:'initialize - release'!

initDailyCounts
	dailyCounts := Array new: 366 withAll: 0.
	self year: Date today year.
!

initHourlyCounts
	hourlyCounts := Array new: 24 withAll: 0.
!

initStarted
	"set a timestamp to a current time"
	started := SpTimestamp now asSeconds.
!

initTodayHourlyCounts

	todayHourlyCounts := Array new: 24 withAll: 0.
	self day: Date today day.
!

initTotal

	self total: 0.
!

initYearlyHistory
	yearlyHistory := Dictionary new.
!

reset

	"set all counters to zero and set started timestamp to now. YOU WILL LOOSE ALL HISTORY
	OF COUNTS !! "

	self initDailyCounts.
	self initHourlyCounts.
	self initTotal.
	self initStarted.
! !

!WebCounter methodsFor:'printing'!

printString

	^'aWebCounter total: ', self total printDotString
! !

!WebCounter methodsFor:'private'!

addArray: aFirstArray to: aSecondArray

	1 to: aFirstArray size do: [:index |
		aSecondArray
			at: index
			put: (aFirstArray at: index) + (aSecondArray at: index)]
!

checkIfNewYear

	(Date today year = (self year + 1)) ifTrue:
		[self yearlyHistory
			at: self year
			put: self dailyCounts.
		self initDailyCounts.
		self year: Date today year].
!

dailyCounts
	"array of counters for each day in current year. When new year arrives, counters are
	copied in a yearlyHistory"

	dailyCounts isNil ifTrue: [self initDailyCounts].
	^dailyCounts
!

day
	day isNil ifTrue: [self day: Date today dayOfYear].
	^day
!

day: aNumber
	day := aNumber
!

hourlyCounts
	"array of counters for each hour in a day."

	hourlyCounts isNil ifTrue: [self initHourlyCounts].
	^hourlyCounts
!

incDailyCounterOnDate: aDate
	aDate year = self year
		ifTrue:
			[self dailyCounts at: aDate day put: (self  dailyCounts at: aDate day) + 1]
		ifFalse:
			[self checkIfNewYear.
			self incHistoryCounterOnDate: aDate].
!

incHistoryCounterOnDate: aDate
	| array |
	aDate year < self year ifTrue: [^self error: 'future years not allowed'].
	array := (self yearlyHistory at: aDate year ifAbsentPut: [Array new: 366 withAll: 0] ).
	array at: aDate day put: (array at: aDate day)+1
!

incHourlyCounterOnTime: aTime
	| hours |
	hours := aTime hours.
	self hourlyCounts at: hours+1   put: (self  hourlyCounts at: hours+1) + 1.
!

incHourlyCounterOnTimestamp: aTimestamp
	| hours |
	hours := aTimestamp asTime hours.
	self hourlyCounts at: hours+1 put: (self  hourlyCounts at: hours+1) + 1.
	self incTodayHourlyCounterOnTimestamp: aTimestamp
!

incTodayHourlyCounterOnTimestamp: aTimestamp

	| hours dayOfYear |
	dayOfYear := aTimestamp asDate day.
	self day ~= dayOfYear   ifTrue:
		[self initTodayHourlyCounts.
		self day: dayOfYear].
	hours := aTimestamp asTime hours.
	self todayHourlyCounts
		at: hours+1
		put: (self  todayHourlyCounts at: hours+1) + 1.
!

incTotal

	self total: self total + 1.
!

todayHourlyCounts
	"array of counters for each hour today."

	todayHourlyCounts isNil ifTrue: [self initTodayHourlyCounts].
	^todayHourlyCounts
!

total: aNumber
	total := aNumber.
!

year
	year isNil ifTrue: [self year: Date today year].
	^year
!

year: aNumber
	year := aNumber.
!

yearlyHistory
	yearlyHistory isNil ifTrue: [self initYearlyHistory].
	^yearlyHistory
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebApplication subclass:#WebHelpApp
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Parts'
!

!WebHelpApp methodsFor:'printing'!

viewNewPage
	| appName viewName helpPage |
	appName := (self session lastRequest queryAt: 'app') asSymbol.
	viewName := (self session lastRequest queryAt: 'hview') asSymbol.
	helpPage := WebHelpPage newForApp: appName view: viewName parent: self observee.
	self redirectTo: helpPage view: #new.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpError subclass:#SpSocketError
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Sockets'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SwazooCompiler
	instanceVariableNames:'accessor'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Compatibility'
!

!SwazooCompiler class methodsFor:'evaluation'!

evaluate: aString
	^SpEnvironment evaluate: aString in: self class environment
!

evaluate: aString receiver: anObject
	^SpEnvironment
		evaluate: aString
		receiver: anObject
		in: self class environment
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpError subclass:#SwazooHeaderFieldParseError
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Exceptions'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebImageMap
	instanceVariableNames:'areas'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebImageMap class methodsFor:'instance creation'!

new
	^super new initialize
! !

!WebImageMap methodsFor:'adding areas'!

addCirclePos: aPositionPoint diameter: aNumber  link: aWebLink

	| coords |
	coords := Array
		with: aPositionPoint x
		with: aPositionPoint y
		with: aNumber.
	self addShape: #circle coordinates: coords link: aWebLink
!

addRectanglePos: aPositionPoint size: aSizePoint  link: aWebLink

	| coords |
	coords := Array
		with: aPositionPoint x
		with: aPositionPoint y
		with: (aPositionPoint + aSizePoint) x
		with: (aPositionPoint + aSizePoint) y.
	self addShape: #rect coordinates: coords link: aWebLink
!

addShape: aShapeSymbol coordinates: anArray link: aWebLink

	self areas add:
		(Array with: aShapeSymbol with: anArray with: aWebLink)
! !

!WebImageMap methodsFor:'attributes'!

name
	^self attributesAt: #name
!

name: aString
	self attributesAt: #name put: aString.
! !

!WebImageMap methodsFor:'initialize - release'!

initAreas
	areas := OrderedCollection new.
!

initialize
	self name: self randomName.
! !

!WebImageMap methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	| link |
	self prepareToHTMLPrintOn: aSession.
	aStream nextPutAll: self ident, '<map'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '"> ', self eol.
	self areas do: [:area |
		aStream nextPutAll: self identMore,
			'<area shape="'; nextPutAll: (area at: 1) asString; nextPutAll: '" coords="'.
		 1 to: (area at: 2) size do: [:inx  |
			inx > 1 ifTrue: [aStream nextPutAll: ','].
			aStream nextPutAll: ((area at: 2) at: inx) printString].
		link := (area at: 3).
		link prepareAttributesToPrintOn:  aSession.
		link printAttributesOn: aStream for: aSession.
		aStream nextPutAll: '"> ', self eol].
	aStream nextPutAll: self ident, '</map>', self eol.
! !

!WebImageMap methodsFor:'private'!

areas
	areas isNil ifTrue: [self initAreas].
	^areas
!

randomName

	^'map', ((Random new next * 100) truncated) printString
!

shouldIdent
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebFieldSet
	instanceVariableNames:'legend'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

WebFieldSet comment:'FieldSet element groups one or more input fields together. It usually (depends on style) also enclose them with border. Legend is for writing a name of the filedset on the corner'
!

!WebFieldSet class methodsFor:'instance creation'!

new
	"Answer a newly created and initialized instance."
	^super new initialize
!

newLegend: aString
	^self new legend: aString
! !

!WebFieldSet methodsFor:'accessing'!

legend
	^legend
!

legend: aString
	"a label to be shown on left top corner of fieldset"
	legend := aString
! !

!WebFieldSet methodsFor:'initialize-release'!

initialize
	"Initialize a newly created instance. This method must answer the receiver."

	" *** Replace this comment with the appropriate initialization code *** "
	^self
! !

!WebFieldSet methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	aStream nextPutAll: self ident, '<fieldset'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	self legend notNil ifTrue:
		[aStream nextPutAll: self identMore, '<legend>', self legend, '</legend>', self eol].
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</fieldset>', self eol.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SwazooServerTest
	instanceVariableNames:'server'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!SwazooServerTest methodsFor:'running'!

setUp
	super setUp.
	server := SwazooServer singleton.
	server initialize.
!

tearDown
	super tearDown.
	server 
		stop;
		initialize.
! !

!SwazooServerTest methodsFor:'testing'!

testAccessingSite
	| site |
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self assert: (SwazooServer siteNamed: 'test') notNil.
	site := SwazooServer siteNamed: 'test'.
	self assert: (site name = 'test').
	self assert: (SwazooServer siteHostnamed: 'test.org') notNil.
	site := SwazooServer siteHostnamed: 'test.org'.
	self assert: (site host = 'test.org').
!

testAddingSite
	| site |
	self assert: server sites size = 0.
	self assert: (server siteNamed: 'test') isNil.
	self assert: (server siteHostnamed: 'test.org') isNil.
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self assert: (server siteNamed: 'test') notNil.
	self assert: (server siteHostnamed: 'test.org') notNil.
	server removeSite: site.
	self assert: server sites size = 0.
!

testDuplicateNames
	| site |
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self should: [site name: 'test'] raise: Error.
	self shouldnt: [site host: 'test.org'] raise: Error.
	self should: [Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80] raise: Error.
!

testStartingSite
	| site |
	site := Site new name: 'test'; host: 'test.org' ip: 'localhost' port: 8765.
	server addSite: site.
	self assert: site isServing not.
	SwazooServer startSite: 'test'.
	self assert: server servers size = 1.
	self assert: site isServing.
	SwazooServer stopSite: 'test'.
	self assert: site isServing not.
	self assert: server servers size = 0.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPAuthorizationField
	instanceVariableNames:'credentials'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPAuthorizationField class methodsFor:'accessing'!

fieldName
	^'Authorization'
! !

!HTTPAuthorizationField class methodsFor:'private'!

newForFieldName: fieldNameString withValueFrom: fieldValueString
	"^an HTTPAuthorizationField
I return an instance of one of my concrete subclasses.  To get to this point, the field name *must* be 'AUTHORIZATION'."

	| sourceStream schemeName |
	sourceStream := ReadStream on: fieldValueString.
	schemeName := sourceStream upTo: Character space.
	^schemeName = 'Basic'
		ifTrue: [HTTPAuthorizationBasicField newWithValueFrom: sourceStream upToEnd]
		ifFalse: [HTTPAuthorizationDigestField newWithValueFrom: sourceStream upToEnd]
! !

!HTTPAuthorizationField methodsFor:'accessing'!

credentials
	^credentials
! !

!HTTPAuthorizationField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPutAll: self credentials.
	^self
! !

!HTTPAuthorizationField methodsFor:'private'!

parseValueFrom: aString
	credentials := HTTPString trimBlanksFrom: aString.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPRefererField
	instanceVariableNames:'uri'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

HTTPRefererField comment:'RFC 2616: 14.36 Referer

   The Referer[sic] request-header field allows the client to specify,
   for the server''s benefit, the address (URI) of the resource from
   which the Request-URI was obtained (the "referrer", although the
   header field is misspelled.) The Referer request-header allows a
   server to generate lists of back-links to resources for interest,
   logging, optimized caching, etc. It also allows obsolete or mistyped
   links to be traced for maintenance. The Referer field MUST NOT be
   sent if the Request-URI was obtained from a source that does not have
   its own URI, such as input from the user keyboard.

       Referer        = "Referer" ":" ( absoluteURI | relativeURI )

   Example:

       Referer: http://www.w3.org/hypertext/DataSources/Overview.html

   If the field value is a relative URI, it SHOULD be interpreted
   relative to the Request-URI. The URI MUST NOT include a fragment. See
   section 15.1.3 for security considerations.

'
!

!HTTPRefererField class methodsFor:'accessing'!

fieldName
	^'Referer'
! !

!HTTPRefererField methodsFor:'accessing'!

uri
	^uri
! !

!HTTPRefererField methodsFor:'printing'!

valuesAsStringOn: aStream
	self uri printOn: aStream.
	^self
! !

!HTTPRefererField methodsFor:'private'!

parseValueFrom: aString
	uri := SwazooURI fromString: aString.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebInputField subclass:#WebDateInputField
	instanceVariableNames:'button'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

WebDateInputField comment:'WebDateInputField is used for entry of dates with help od JavaScript calendar (http://www.dynarch.com/projects/calendar/), fro Romanian author Mihai Bazon.
See also WebStyle calendar* methods, specially calendarCSS and calendarLang*

Usage is similar as usual input field. Example:
	element addDateInputFieldAspect: #methodName for: self observee

Instance Variables:
	button  <WebImage>
'
!

!WebDateInputField methodsFor:'initialize-release'!

initialize
	super initialize.
	self size: 11.
	self app style ensureJavascriptAndCssForCalendarInHeader.
	self app style ensureJsResourceForCalendarSetup.
! !

!WebDateInputField methodsFor:'printing'!

addCalendarSetupScriptOn: aStream
	aStream nextPutAll: '<script type="text/javascript">Calendar.setup({ inputField : "', self inputFieldId,                '", ifFormat : "', self inputFieldFormat,
		'", button : "', self buttonId, '"});</script>', self eol
!

buttonId
	^self button id
!

buttonImage
	"from WebStyle calendarButtonGif !! "
	| methodImage |
	methodImage := WebMethodImage
		fromMethod: #calendarButtonGif
		on: self style
		contentType: 'image/gif'
		site: self style site.
	^(WebImage image: methodImage)
		title: 'Izberite datum';
		imageAlign: #middle;
		onMouseOver: 'this.style.cursor=''pointer'' ';
		onMouseOut: 'this.style.cursor=''default'' '
!

inputFieldFormat
	"the date format"
	^'%e.%m.%Y'  "17.01.1965"
!

inputFieldId
	^self id
!

printHTMLPageOn: aStream forSession: aSession
	self registerId.
	self button: self buttonImage. self button registerId.
	super printHTMLPageOn: aStream forSession: aSession.
	self button printHTMLPageOn: aStream forSession: aSession.
	self addCalendarSetupScriptOn: aStream.
! !

!WebDateInputField methodsFor:'private'!

button
	^button
!

button: aWebButton
	button := aWebButton
! !

!WebDateInputField methodsFor:'testing'!

isDateInputField
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SpFilenameTest
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'SPortDev-FilesTesting'
!

!SpFilenameTest methodsFor:'testing'!

testExists
"
	| fname |
	fname := 'swazoo.image' asFilename.
	self assert: fname exists.
	fname := 'swo.image' asFilename.
	self deny: fname exists.
"
!

testFileReadWrite
        | fname stream |
        fname := SpFilename named:'test.file'.
        [stream := fname writeStream.
        stream nextPutAll: 'hello']
                ensure: [stream close].
        [stream := fname readStream.
        self assert: stream upToEnd = 'hello']
                ensure: [stream close. fname delete].
!

testFileTimestamps
        | fname stream |
        fname := SpFilename named:'test.file'.
        [stream := fname appendStream]
                ensure: [stream close].
        self assert: fname createdTimestamp asDate = SpDate today.
        self assert: fname modifiedTimestamp asDate = SpDate today.
        fname delete.
!

testFilenameCreation
        | f |
        f := SpFilename named:'test.file'.
        self assert: f asString = 'test.file'
!

testNewDirectory
        | dname |
        dname := SpFilename named:'testdir'.
        self deny: dname exists.
        dname makeDirectory.
        self assert: dname exists.
        dname delete.
        self deny: dname exists.
!

testNewFile
        | fname stream |
        fname := SpFilename named:'test.file'.
        self deny: fname exists.
        [stream := fname appendStream]
                ensure: [stream close].
        self assert: fname exists.
        fname delete.
        self deny: fname exists.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#DocLink
	instanceVariableNames:'title url object'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

!DocLink class methodsFor:'instance creation'!

new
	"Answer a newly created and initialized instance."

	^super new initialize
! !

!DocLink methodsFor:'accessing'!

object
	^object
!

object: anObject
	object := anObject
!

title
	^title
!

title: aString
	title := aString
!

url
	^url
!

url: aString
	url := aString
!

uuid
	^self hash printString
! !

!DocLink methodsFor:'converting'!

asWebLink
	^WebLink text: self title linkTo: self url
! !

!DocLink methodsFor:'initialize-release'!

initialize
	^self
! !

!DocLink methodsFor:'private'!

migrateToUnicode
	"DocLink allInstances do: [:each | each migrateToUnicode]"
	title notNil ifTrue: [title := title ensureUnicodeSloveneChars]
!

printString
	^'a Doclink
		title:  ', (self title notNil ifTrue: [self title] ifFalse: ['']), '
		url: ', (self url notNil ifTrue: [self url] ifFalse: ['']), '
		object: ', self object printString
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#AIDAProtocolAdaptor
	instanceVariableNames:'subject'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

!AIDAProtocolAdaptor methodsFor:'accessing'!

subject

	^subject
!

subject: anObject

	subject := anObject
!

value
!

value: aValue
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#DirectoryProxy
	instanceVariableNames:'server filename fileDates origContent origCodepage contentType
		elements bodyTagIndex imgTagIndexes linkTagIndexes
		servletTagIndexes'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebSessionManager
	instanceVariableNames:'site sessionsByID sessionsByAddress activeSessions'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!WebSessionManager class methodsFor:'instance creation'!

newOn: aSite
	^super new
		initialize;
		site: aSite
! !

!WebSessionManager class methodsFor:'accessing'!

default
	^AIDASite default sessionManager
! !

!WebSessionManager methodsFor:'Aida-Core'!

allHostAddresses

	"return a collection of all different host IP addresses"

	| allRequests allHosts addr |
	allRequests := self allRequestsByTime.
	allHosts := OrderedCollection new.
	allRequests do: [:request |
		addr := request envVariables at: #'remote_addr'.
		(allHosts includes: addr) ifFalse: [allHosts add: addr].
	].
	^allHosts.
! !

!WebSessionManager methodsFor:'accessing'!

activeSessions
	activeSessions isNil ifTrue: [self initActiveSessions].
	^activeSessions
!

allGuestSessions
	^self allSessions select: [:each | each user isGuest].
!

allSessions
	^self sessionsByID values asSet addAll: self activeSessions values; yourself
!

sessionsByAddress
	^sessionsByAddress
!

sessionsByID
	^sessionsByID
!

site
	^site
! !

!WebSessionManager methodsFor:'accessing-requests'!

allRequestsByTime

	"return a collection of all requests for all sessions, ordered by time (the newest request first). "

	| allRequests  |
	allRequests := OrderedCollection new.
	self sessionsByID do: [:session |
		session requests notNil ifTrue:
			[allRequests addAll: session requests]].
	^allRequests asSortedCollection:
		[:requestA :requestB | requestA timestamp > requestB timestamp]

"WebSessionManager instance allRequestsByTime"
!

allTodayRequestsByTime

	"return a collection of all requests for all sessions, ordered by time (the newest request first). "

	| allRequests |
	allRequests := self allRequestsByTime.
	^allRequests select: [:request | request timestamp asDate = Date today]

"WebSessionManager default allTodayRequestsByTime"
!

allTodayRequestsNotOurs

	""

	| allRequests |
	allRequests := self allTodayRequestsByTime.
	^allRequests select: [:request | ('194.165.99*' match: request address) not and:
		[(('*.gif*' match: request path asLowercase) | ('*.jpg*' match: request path asLowercase)) not]]

"WebSessionManager default allTodayRequestsNotOurs"
!

allYesterdayRequestsByTime

	"return a collection of all requests for all sessions, ordered by time (the newest request first). "

	| allRequests |
	allRequests := self allRequestsByTime.
	^allRequests select: [:request | request timestamp asDate = (Date today - 1)]

"WebSessionManager default allYesterdayRequestsByTime"
!

allYesterdayRequestsNotOurs

	""

	| allRequests |
	allRequests := self allYesterdayRequestsByTime.
	^allRequests select: [:request | ('194.165.99*' match: request address) not and:
		[(('*.gif*' match: request path asLowercase) | ('*.jpg*' match: request path asLowercase)) not]]

"WebSessionManager default allYesterdayRequestsNotOurs"
! !

!WebSessionManager methodsFor:'adding-removing'!

findOrMakeSessionFor: aRequest
	"Try to find a session among currently live sessions. It helps with a session id in a query
	part of url. If not found, or id not in query string, then make a new session"
	| session id cookie |
	(self hasSSLBinding: aRequest) ifTrue: [^self bindSSLSessionFor: aRequest].
	(aRequest hasCookie and: [aRequest idFromCookie notNil])
		ifTrue: [id := aRequest idFromCookie. cookie := true. self site log: ' cookie ' ]
		ifFalse:
			[cookie := false. id := aRequest queryAt: 'id' ifAbsent: [(self newSessionCookie: cookie) id] ].
	session := (self existSessionWithID: id asInteger)
		ifTrue: [self findSessionWithID: id asInteger]
		ifFalse: [self newSessionCookie: cookie id: id asInteger].
	session requests size = 1
		ifTrue: [self countNewVisitor] ifFalse:         [self checkAndCountReturningVisitor: session].
	session checkExpirationAndPossiblyLogoutFor: aRequest.
	session lastRequest: aRequest.
	session cookie: cookie. cookie ifFalse: [session addSessionID].

	(aRequest includesQuery:  'language') ifTrue:
		[session language: (aRequest queryAt: 'language') asSymbol].
	^session.
!

releaseNonactiveSessions
	"release from memory all nonactive sessions"
	self activeSessions values do: [:each |
		each isActive ifFalse:
			[self site critical: [self removeFromActiveSessions: each] ] ].
!

removeAllSessions

	| allKeys |
	allKeys :=      self sessionsByAddress keys.
	allKeys do: [:key | self sessionsByAddress removeKey: key].
	allKeys :=      self sessionsByID keys.
	allKeys do: [:key | self sessionsByID removeKey: key].
!

removeGuestSessions
	^self allGuestSessions do: [:each |
		each parent == self ifTrue: [each removeYourself] ifFalse: [self removeSession: each] ].
!

removeSession: aWebSession
	self activeSessions removeKey: aWebSession id ifAbsent: [].
	self activeSessions removeKey: aWebSession secureId ifAbsent: [].
	self sessionsByID removeKey: aWebSession id ifAbsent: [].
	self sessionsByID removeKey: aWebSession secureId ifAbsent: [].
	self    sessionsByAddress removeKey: aWebSession ifAbsent: [].
! !

!WebSessionManager methodsFor:'initialize-release'!

initActiveSessions
	activeSessions := Dictionary new.
!

initAppsForObjects
	"WebSessionManager default initAppsForObjects"
	self activeSessions values do: [:each | each initAppsForObjects]
!

initialize
	sessionsByID := Dictionary new.
	sessionsByAddress := Dictionary new.
	self initActiveSessions.

"WebSessionManager default initialize"
! !

!WebSessionManager methodsFor:'private'!

bindSSLSessionFor: aRequest
	"Try to find a session among currently live sessions. It helps with a session id in a query
	part of url. If not found, or id not in query string, then make a new session"
	| session id |
	id := aRequest queryAt: 'sessionId' ifAbsent: [self error: 'no session id!!'].
	session := (self existSessionWithID: id asInteger)
		ifTrue: [self findSessionWithID: id asInteger]
		ifFalse: [self error: 'no session with that id'].
	session requests size = 1
		ifTrue: [self countNewVisitor]
		ifFalse:        [self checkAndCountReturningVisitor: session].
	session lastRequest: aRequest.

	(aRequest includesQuery:  'language') ifTrue:
		[session language: (aRequest queryAt: 'language') asSymbol].

	^session.
!

checkAndCountReturningVisitor: aSession
	"returning visitor is those who is not active more than 1h"
	(aSession isActive not and: [aSession requests size > 1]) ifTrue:
		[self site critical: [self site returningVisitorsCounter incCounter] ]
!

countNewVisitor
	self site critical:
		[self site newVisitorsCounter incCounter]
!

existSessionWithID: anIDNumber
	| exist |
	exist := self activeSessions includesKey: anIDNumber.
	exist ifTrue: [^true].
	^self sessionsByID includesKey: anIDNumber
!

findSessionWithID: anIDNumber
	| session |
	session := self activeSessions at: anIDNumber ifAbsent: [nil].
	session notNil ifTrue: [^session].
	session := self sessionsByID at: anIDNumber ifAbsent: [nil].
	self addToActiveSessions: session.
	^session
!

hasSSLBinding: aRequest
	"if sessionId=456546464 exist in query part of request. This means that this is
	a SSL session with its own cookie and must be bind to a normal session with sessionId"

	^aRequest isEncrypted and: [aRequest includesQuery: 'sessionId']
!

newSessionCookie: aBoolean
	"open and return a fresh new session"
	| session |
	session := WebSession newOn: self.
	self site log: ' new session '.
	self addToActiveSessions: session.
	session cookie: aBoolean.
	^session
!

newSessionCookie: aBoolean id: aSessionID
	"open and return a fresh new session"
	| session |
	session := WebSession newOn: self.
	aSessionID notNil ifTrue: [session id: aSessionID].
	self site log: ' new session '.
	self addToActiveSessions: session.
	session cookie: aBoolean.
	^session
!

site: anAIDASite
	site := anAIDASite.
! !

!WebSessionManager methodsFor:'private - active sessions'!

addToActiveSessions: aWebSession
	self site critical:
		[self activeSessions
			at: aWebSession id put: aWebSession;
			at: aWebSession secureId put: aWebSession]
!

removeFromActiveSessions: aWebSession
	"remove from active sessions and archive it in main dictionary, if not already"
	self site critical:
		[self activeSessions
			removeKey: aWebSession id ifAbsent: [];
			removeKey: aWebSession secureId ifAbsent: [].
		(self sessionsByID includesKey: aWebSession id) ifFalse:
			[self sessionsByID
				at: aWebSession id put: aWebSession;
				at: aWebSession secureId put: aWebSession] ].
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#ImageStream
	instanceVariableNames:'imageStream progressValue'
	classVariableNames:'GrayPalette256 ImageKindTable ColorPalette256'
	poolDictionaries:''
	category:'Aida-Imaging'
!

ImageStream comment:'ImageStream

Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.
'
!

!ImageStream class methodsFor:'instance creation'!

on: aStream
	^self new on: aStream
! !

!ImageStream class methodsFor:'accessing'!

fromClipboard
	"ImageStream show: ImageStream fromClipboard."

	| pixmap image |
	pixmap := Pixmap fromClipboard.
	image := pixmap asImage.
	^image
!

fromDisplay
	"ImageStream show: ImageStream fromDisplay."

	^self fromDisplay: Screen default bounds
!

fromDisplay: aRectangle
	"ImageStream show: (ImageStream fromDisplay: (0 @ 0 extent: 100 @ 100))."

	^Screen default completeContentsOfArea: aRectangle
!

fromUser
	"ImageStream show: ImageStream fromUser."

	^self fromDisplay: Rectangle fromUser
!

imageKindTable
	"ImageStream imageKindTable."

	ImageKindTable isNil
		ifTrue:
			[| aDictionary |
			aDictionary := Dictionary new.
			aDictionary at: 'bos' put: #BosImageStream.
			aDictionary at: 'boss' put: #BosImageStream.
			aDictionary at: 'bmp' put: #BmpImageStream.
			aDictionary at: 'bmpf' put: #BmpImageStream.
			aDictionary at: 'gif' put: #GifImageStream.
			aDictionary at: 'giff' put: #GifImageStream.
			aDictionary at: 'jpg' put: #JpegImageStream.
			aDictionary at: 'jpeg' put: #JpegImageStream.
			aDictionary at: 'pic' put: #PictImageStream.
			aDictionary at: 'pict' put: #PictImageStream.
			ImageKindTable := aDictionary].
	^ImageKindTable
!

imageStreamClassForFileName: aFilename
	"ImageStream imageStreamClassForFileName: 'zzz.gif' asFilename."

	| aString aSymbol aClass |
	aString := (aFilename asString reverse copyUpTo: $.) reverse.
	aString := aString asLowercase.
	aSymbol := self imageKindTable at: aString ifAbsent: [nil].
	aSymbol isNil ifTrue: [^nil].
	aClass := Smalltalk at: aSymbol ifAbsent: [nil].
	^aClass
!

toClipboard: anImage
	"ImageStream toClipboard: Image fromUser."

	| pixmap |
	pixmap := anImage asRetainedMedium.
	pixmap toClipboard.
	^anImage
! !

!ImageStream class methodsFor:'class initialization'!

initialize
	"ImageStream initialize."

	ImageKindTable := nil.
	self flushPalettes
!

install
	"ImageStream install."

	self colorPalette256.
	self grayPalette256
! !

!ImageStream class methodsFor:'constants of palette'!

colorPalette256
	"ImageStream colorPalette256."

	| anArray |
	ColorPalette256 notNil ifTrue: [^ColorPalette256].
	anArray := Compiler evaluate: '#(
		#(8191 8191 8191)
		#(8191 8191 6553)
		#(8191 8191 4915)
		#(8191 8191 3276)
		#(8191 8191 1638)
		#(8191 8191 0)
		#(8191 6553 8191)
		#(8191 6553 6553)
		#(8191 6553 4915)
		#(8191 6553 3276)
		#(8191 6553 1638)
		#(8191 6553 0)
		#(8191 4915 8191)
		#(8191 4915 6553)
		#(8191 4915 4915)
		#(8191 4915 3276)
		#(8191 4915 1638)
		#(8191 4915 0)
		#(8191 3276 8191)
		#(8191 3276 6553)
		#(8191 3276 4915)
		#(8191 3276 3276)
		#(8191 3276 1638)
		#(8191 3276 0)
		#(8191 1638 8191)
		#(8191 1638 6553)
		#(8191 1638 4915)
		#(8191 1638 3276)
		#(8191 1638 1638)
		#(8191 1638 0)
		#(8191 0 8191)
		#(8191 0 6553)
		#(8191 0 4915)
		#(8191 0 3276)
		#(8191 0 1638)
		#(8191 0 0)
		#(6553 8191 8191)
		#(6553 8191 6553)
		#(6553 8191 4915)
		#(6553 8191 3276)
		#(6553 8191 1638)
		#(6553 8191 0)
		#(6553 6553 8191)
		#(6553 6553 6553)
		#(6553 6553 4915)
		#(6553 6553 3276)
		#(6553 6553 1638)
		#(6553 6553 0)
		#(6553 4915 8191)
		#(6553 4915 6553)
		#(6553 4915 4915)
		#(6553 4915 3276)
		#(6553 4915 1638)
		#(6553 4915 0)
		#(6553 3276 8191)
		#(6553 3276 6553)
		#(6553 3276 4915)
		#(6553 3276 3276)
		#(6553 3276 1638)
		#(6553 3276 0)
		#(6553 1638 8191)
		#(6553 1638 6553)
		#(6553 1638 4915)
		#(6553 1638 3276)
		#(6553 1638 1638)
		#(6553 1638 0)
		#(6553 0 8191)
		#(6553 0 6553)
		#(6553 0 4915)
		#(6553 0 3276)
		#(6553 0 1638)
		#(6553 0 0)
		#(4915 8191 8191)
		#(4915 8191 6553)
		#(4915 8191 4915)
		#(4915 8191 3276)
		#(4915 8191 1638)
		#(4915 8191 0)
		#(4915 6553 8191)
		#(4915 6553 6553)
		#(4915 6553 4915)
		#(4915 6553 3276)
		#(4915 6553 1638)
		#(4915 6553 0)
		#(4915 4915 8191)
		#(4915 4915 6553)
		#(4915 4915 4915)
		#(4915 4915 3276)
		#(4915 4915 1638)
		#(4915 4915 0)
		#(4915 3276 8191)
		#(4915 3276 6553)
		#(4915 3276 4915)
		#(4915 3276 3276)
		#(4915 3276 1638)
		#(4915 3276 0)
		#(4915 1638 8191)
		#(4915 1638 6553)
		#(4915 1638 4915)
		#(4915 1638 3276)
		#(4915 1638 1638)
		#(4915 1638 0)
		#(4915 0 8191)
		#(4915 0 6553)
		#(4915 0 4915)
		#(4915 0 3276)
		#(4915 0 1638)
		#(4915 0 0)
		#(3276 8191 8191)
		#(3276 8191 6553)
		#(3276 8191 4915)
		#(3276 8191 3276)
		#(3276 8191 1638)
		#(3276 8191 0)
		#(3276 6553 8191)
		#(3276 6553 6553)
		#(3276 6553 4915)
		#(3276 6553 3276)
		#(3276 6553 1638)
		#(3276 6553 0)
		#(3276 4915 8191)
		#(3276 4915 6553)
		#(3276 4915 4915)
		#(3276 4915 3276)
		#(3276 4915 1638)
		#(3276 4915 0)
		#(3276 3276 8191)
		#(3276 3276 6553)
		#(3276 3276 4915)
		#(3276 3276 3276)
		#(3276 3276 1638)
		#(3276 3276 0)
		#(3276 1638 8191)
		#(3276 1638 6553)
		#(3276 1638 4915)
		#(3276 1638 3276)
		#(3276 1638 1638)
		#(3276 1638 0)
		#(3276 0 8191)
		#(3276 0 6553)
		#(3276 0 4915)
		#(3276 0 3276)
		#(3276 0 1638)
		#(3276 0 0)
		#(1638 8191 8191)
		#(1638 8191 6553)
		#(1638 8191 4915)
		#(1638 8191 3276)
		#(1638 8191 1638)
		#(1638 8191 0)
		#(1638 6553 8191)
		#(1638 6553 6553)
		#(1638 6553 4915)
		#(1638 6553 3276)
		#(1638 6553 1638)
		#(1638 6553 0)
		#(1638 4915 8191)
		#(1638 4915 6553)
		#(1638 4915 4915)
		#(1638 4915 3276)
		#(1638 4915 1638)
		#(1638 4915 0)
		#(1638 3276 8191)
		#(1638 3276 6553)
		#(1638 3276 4915)
		#(1638 3276 3276)
		#(1638 3276 1638)
		#(1638 3276 0)
		#(1638 1638 8191)
		#(1638 1638 6553)
		#(1638 1638 4915)
		#(1638 1638 3276)
		#(1638 1638 1638)
		#(1638 1638 0)
		#(1638 0 8191)
		#(1638 0 6553)
		#(1638 0 4915)
		#(1638 0 3276)
		#(1638 0 1638)
		#(1638 0 0)
		#(0 8191 8191)
		#(0 8191 6553)
		#(0 8191 4915)
		#(0 8191 3276)
		#(0 8191 1638)
		#(0 8191 0)
		#(0 6553 8191)
		#(0 6553 6553)
		#(0 6553 4915)
		#(0 6553 3276)
		#(0 6553 1638)
		#(0 6553 0)
		#(0 4915 8191)
		#(0 4915 6553)
		#(0 4915 4915)
		#(0 4915 3276)
		#(0 4915 1638)
		#(0 4915 0)
		#(0 3276 8191)
		#(0 3276 6553)
		#(0 3276 4915)
		#(0 3276 3276)
		#(0 3276 1638)
		#(0 3276 0)
		#(0 1638 8191)
		#(0 1638 6553)
		#(0 1638 4915)
		#(0 1638 3276)
		#(0 1638 1638)
		#(0 1638 0)
		#(0 0 8191)
		#(0 0 6553)
		#(0 0 4915)
		#(0 0 3276)
		#(0 0 1638)
		#(7645 0 0)
		#(7099 0 0)
		#(6007 0 0)
		#(5461 0 0)
		#(4369 0 0)
		#(3822 0 0)
		#(2730 0 0)
		#(2184 0 0)
		#(1092 0 0)
		#(546 0 0)
		#(0 7645 0)
		#(0 7099 0)
		#(0 6007 0)
		#(0 5461 0)
		#(0 4369 0)
		#(0 3822 0)
		#(0 2730 0)
		#(0 2184 0)
		#(0 1092 0)
		#(0 546 0)
		#(0 0 7645)
		#(0 0 7099)
		#(0 0 6007)
		#(0 0 5461)
		#(0 0 4369)
		#(0 0 3822)
		#(0 0 2730)
		#(0 0 2184)
		#(0 0 1092)
		#(0 0 546)
		#(7645 7645 7645)
		#(7099 7099 7099)
		#(6007 6007 6007)
		#(5461 5461 5461)
		#(4369 4369 4369)
		#(3822 3822 3822)
		#(2730 2730 2730)
		#(2184 2184 2184)
		#(1092 1092 1092)
		#(546 546 546)
		#(0 0 0)
	)' logged: false.
	anArray := anArray
				collect:
					[:array |
					| r g b color |
					r := array at: 1.
					g := array at: 2.
					b := array at: 3.
					ColorValue scalingValue = 8191
						ifTrue: [color := ColorValue
										scaledRed: r
										scaledGreen: g
										scaledBlue: b]
						ifFalse:
							[r := r / 8191.
							g := g / 8191.
							b := b / 8191.
							color := ColorValue
										red: r
										green: g
										blue: b].
					color yourself].
	ColorPalette256 := MappedPalette withColors: anArray reverse.
	^ColorPalette256
!

flushPalettes
	"ImageStream flushPalettes."

	ColorPalette256 := nil.
	GrayPalette256 := nil
!

grayPalette256
	"ImageStream grayPalette256."

	| paletteSize anArray |
	GrayPalette256 notNil ifTrue: [^GrayPalette256].
	paletteSize := 256.
	anArray := Array new: paletteSize.
	1 to: paletteSize
		do:
			[:index |
			| color |
			color := ColorValue brightness: 1 - (index - 1 / (paletteSize - 1)).
			anArray at: index put: color].
	GrayPalette256 := MappedPalette withColors: anArray reverse.
	^GrayPalette256
! !

!ImageStream class methodsFor:'controls'!

assert: assertBlock do: doBlock ensure: ensureBlock
	assertBlock value.
	[doBlock value]
		valueNowOrOnUnwindDo: [ensureBlock value]
! !

!ImageStream class methodsFor:'copyright'!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'
!

system
	^'Goodies'
!

version
	^'003'
! !

!ImageStream class methodsFor:'saving'!

save
        "ImageStream save."

        | encodingName fileName classCollection aStream |
        encodingName := #default.
        fileName := 'ImgStrm.st'.
        classCollection := self saveClasses.
        aStream := ((SpFilename named:fileName) withEncoding: encodingName) writeStream.
        [Cursor write
                showWhile:
                        [| timeStamp |
                        timeStamp := Date today shortPrintString , ' ' , Time now shortPrintString.
                        aStream cr.
                        aStream nextChunkPut: timeStamp printString.
                        aStream cr; cr.
                        (self comment isNil or: [self comment isEmpty])
                                ifFalse:
                                        [aStream nextChunkPut: self comment printString.
                                        aStream cr; cr].
                        classCollection
                                do:
                                        [:aClass |
                                        aStream nextChunkPut: aClass definition.
                                        aStream cr; cr].
                        classCollection
                                do:
                                        [:aClass |
                                        | sourceCodeStream |
                                        aStream nextPut: Character newPage.
                                        aStream cr.
                                        sourceCodeStream := SourceCodeStream on: aStream.
                                        aClass fileOutSourceOn: sourceCodeStream.
                                        aStream cr]]]
                valueNowOrOnUnwindDo: [aStream close].
        ^classCollection
!

saveClasses
	"ImageStream saveClasses."

	| patternCollection classCollection |
	patternCollection := #('*ImageStream*' '*Progress*').
	classCollection := Smalltalk organization superclassOrder: self category.
	classCollection := classCollection
				select:
					[:aClass |
					| string something |
					string := aClass name asString.
					something := patternCollection detect: [:it | it match: string]
								ifNone: [nil].
					something notNil].
	^classCollection , Progress saveClasses
! !

!ImageStream class methodsFor:'viewing'!

show: anImage
	"ImageStream show: Image fromUser."

	| image extent window |
	(anImage isKindOf: OpaqueImage)
		ifTrue: [image := anImage]
		ifFalse: [image := CachedImage on: anImage].
	extent := 64 @ 64 max: (image extent min: Screen default bounds extent - 60 asPoint).
	window := ScheduledWindow new.
	window label: 'Image'.
	window minimumSize: extent.
	window component: image.
	window open.
	^anImage
! !

!ImageStream methodsFor:'accessing'!

nextImage
	^self subclassResponsibility
!

nextPutImage: anImage
	^self subclassResponsibility
! !

!ImageStream methodsFor:'initialize-release'!

on: aStream
	imageStream := aStream.
	(imageStream respondsTo: #binary)
		ifTrue: [imageStream binary].
	self progressValue: (ValueHolder with: nil)
! !

!ImageStream methodsFor:'private'!

convertValue: value from: fromScale to: toScale
	^value = 0
		ifTrue: [0]
		ifFalse: [value = fromScale
				ifTrue: [toScale]
				ifFalse: [(value + 1 * (toScale + 1) / (fromScale + 1)) rounded - 1 max: 0]]
!

errorCanNotRead
	self error: 'can''t read the image'.
	^nil
!

errorCanNotWrite
	self error: 'can''t write the image'.
	^nil
!

hasMagicNumber: aByteArray
	| position array |
	position := imageStream position.
	imageStream size - position >= aByteArray size
		ifTrue:
			[array := (imageStream next: aByteArray size) asByteArray.
			array = aByteArray ifTrue: [^true]].
	imageStream position: position.
	^false
! !

!ImageStream methodsFor:'progress'!

compute: aBlock
	(self progressValue isKindOf: ValueHolder)
		ifTrue: [self progressValue compute: aBlock]
!

progress
	^self progressValue value
!

progress: normalizedNumber
	(0 <= normalizedNumber and: [normalizedNumber <= 1])
		ifTrue:
			[| truncatedValue |
			truncatedValue := normalizedNumber roundTo: 0.005.
			self progressValue value = truncatedValue ifFalse: [self progressValue value: truncatedValue]]
!

progressValue
	^progressValue
!

progressValue: aValueHolder
	progressValue := aValueHolder
! !

!ImageStream methodsFor:'stream access'!

atEnd
	^imageStream atEnd
!

close
	imageStream close
!

contents
	^imageStream contents
!

cr
	^imageStream nextPut: Character cr asInteger
!

lf
	^imageStream nextPut: Character lf asInteger
!

next
	^imageStream next
!

next: size
	^imageStream next: size
!

nextLong
	^(imageStream next bitShift: 24)
		+ (imageStream next bitShift: 16) + (imageStream next bitShift: 8) + imageStream next
!

nextLongPut: a32BitW
	imageStream nextPut: ((a32BitW bitShift: -24)
			bitAnd: 255).
	imageStream nextPut: ((a32BitW bitShift: -16)
			bitAnd: 255).
	imageStream nextPut: ((a32BitW bitShift: -8)
			bitAnd: 255).
	imageStream nextPut: (a32BitW bitAnd: 255).
	^a32BitW
!

nextPut: aByte
	^imageStream nextPut: aByte
!

nextPutAll: aByteArray
	^imageStream nextPutAll: aByteArray
!

nextWord
	^(imageStream next bitShift: 8)
		+ imageStream next
!

nextWordPut: a16BitW
	imageStream nextPut: ((a16BitW bitShift: -8)
			bitAnd: 255).
	imageStream nextPut: (a16BitW bitAnd: 255).
	^a16BitW
!

position
	^imageStream position
!

position: anInteger
	^imageStream position: anInteger
!

size
	^imageStream size
!

skip: anInteger
	^imageStream skip: anInteger
!

space
	^imageStream nextPut: Character space asInteger
!

tab
	^imageStream nextPut: Character tab asInteger
! !

!ImageStream methodsFor:'viewing'!

show: anImage
	^self class show: anImage
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

HTTPStream subclass:#HTTPReadStream
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Compatibility'
!

!HTTPReadStream methodsFor:'accessing'!

next
	^self underlyingStream next
!

next: numberOfElements
	^self underlyingStream next: numberOfElements
!

nextBytes: anInteger
	^self underlyingStream nextBytes: anInteger
!

nextLine
	"^a String
I return the next line from my underlying stream.  This means reading everything up to the next crlf."

	| targetStream |
	targetStream := WriteStream on: String new.
	self writeNextLineTo: targetStream.
	^targetStream contents
!

nextUnfoldedLine
	"^a String
c.f. RFC 2616 2.2 Basic Rules
   HTTP/1.1 header field values can be folded onto multiple lines if the
   continuation line begins with a space or horizontal tab.
So, I read the next line, the I read subsequent lines until I get to one that is not a contuation.  I add the contents of the continuation lines to the target stream.  I leave my underlying stream positioned at the immediately after the last continuation.  If the initial line is empty this is the last line in the stream, so I read no more."

	| targetStream |
	targetStream := WriteStream on: String new.
	self writeNextLineTo: targetStream.
	targetStream contents isEmpty
		ifFalse:
			[
			[| nextCharacter |
			nextCharacter := self peek.
			nextCharacter notNil
				and: [nextCharacter == Character space or: [nextCharacter == Character tab]]]
					whileTrue: [self writeNextLineTo: targetStream]].
	^targetStream contents
!

peek
	"^an object or nil
I return the next object in the underlying stream if there is one."

	^self underlyingStream peek
!

upTo: aCharacter
	"^a String
Much of the Swazoo reading assumes characters rather than bytes.  Here we get the bytes from the underlying stream and convert each byte into a character."

	| subjectBytes targetString |
	subjectBytes := self underlyingStream upTo: aCharacter.
	targetString := String new: subjectBytes size.
	1 to: subjectBytes size
		do: [:index | targetString at: index put: (subjectBytes at: index) asCharacter].
	^targetString
!

upToEnd
	^self underlyingStream upToEnd
!

writeNextLineTo: aStream
	aStream nextPutAll: (self underlyingStream upTo: Character cr).
	^self underlyingStream peek = Character lf
		ifTrue: [self underlyingStream next]
		ifFalse: [SwazooHTTPParseError raiseSignal: 'CR without LF']
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebSeparator
	instanceVariableNames:'type size length'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebSeparator class methodsFor:'instance creation'!

break

	^ self new type: #break
!

paragraph

	^ self new type: #paragraph
!

rulerSize: aNumber

	^(self new) type: #ruler; size: aNumber
! !

!WebSeparator methodsFor:'accessing'!

type
	^type
!

type: aSymbol
	"#ruler #paragraph #break"
	type := aSymbol.
! !

!WebSeparator methodsFor:'attributes'!

size: aNumber
	"size of a ruler"
	self attributesAt: #size put: aNumber printString.
! !

!WebSeparator methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	| tag |
	self prepareToHTMLPrintOn: aSession.
	type = #paragraph ifTrue: [tag := 'p'].
	type = #break ifTrue: [tag := 'br'].
	type = #ruler ifTrue: [tag := 'hr'].
	aStream nextPutAll: self ident, '<', tag.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
! !

!WebSeparator methodsFor:'testing'!

shouldIdent
	^self type ~= #break
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#HTTPConnection
	instanceVariableNames:'stream loop server lastResponse'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-HTTP'
!

!HTTPConnection class methodsFor:'instance creation'!

socket: aSocket
	^self new stream: aSocket stream
! !

!HTTPConnection methodsFor:'private-accessing'!

lastResponse
	"to pair with new request, for http digest authentication etc."
	^lastResponse
!

lastResponse: aHTTPResponse
	lastResponse := aHTTPResponse
!

loop
	^loop
!

loop: aProcess
	loop := aProcess
!

server
	^server
!

server: aServer
	server := aServer
!

socket
	^self stream socket
!

stream
	^stream
!

stream: aSwazooStream
	stream := aSwazooStream
! !

!HTTPConnection methodsFor:'private-handling'!

getAndDispatchMessages
	"^self
	The HTTPRequest is read from my socket stream.  I then pass this request to my server to get a response.  If somethng goes wrong while getting hold of the request, we call that a 400 - a bad request.  If anything happens after that, it's an internal server error.  (hmm - should we close the image if we get an internal server error?  If we don't, what state is the image in, then ... ??)"

	| task |
	task := SwazooTask new.
	self readRequestFor: task.
	self produceResponseFor: task.
	"self close"
!

nextPutError: aResponse
	aResponse informConnectionClose.
	aResponse writeTo: self stream.
	self stream flush.
!

nextPutResponse: aMessage toRequest: aRequest
	| shouldClose |
	shouldClose := aRequest wantsConnectionClose.
	shouldClose ifTrue: [aMessage informConnectionClose].
	aRequest isHead
		ifTrue: [aMessage writeHeaderTo: self stream]
		ifFalse: [aMessage writeTo: self stream].
	self stream flush.
	shouldClose ifTrue: [self close].
	aMessage isRedirectLink ifTrue: [self close]. "otherwise browser does not redirect?!! "
!

produceResponseFor: aTask
	"Given the request in aTask I try to make a response.  If there are any unhandled
	exceptions, respond with an internal server error."
	aTask request isNil ifTrue: [^nil].
	SpExceptionContext for:
		[aTask response: (self server answerTo: aTask request).
		self nextPutResponse: aTask response toRequest: aTask request]
	onAnyExceptionDo:
		[:ex |
		self nextPutError: HTTPResponse internalServerError.
		ex defaultAction. "usually raise an UHE window"
		self close]
!

readRequestFor: aSwazooTask
	"I read the next request from my socket and add it to aSwazooTask.  If I have any
	problems and need to force a bad request (400) response, I add this response to aSwazooTask."
	| request |
	SpExceptionContext for:
		[request := HTTPRequest readFrom: self stream.
		request uri port: self server port.
		(request httpVersion last = 1
			and: [(request headers includesFieldOfClass: HTTPHostField) not])
				ifTrue: [aSwazooTask response: HTTPResponse badRequest].
		request
			peer: self stream socket remoteAddress;
			ip: self stream socket localAddress;
			setTimestamp; parent: self.
		aSwazooTask request: request]
	on: SpError, HTTPException
	do: [:ex |
		aSwazooTask response: HTTPResponse badRequest.
		self nextPutError: aSwazooTask response.
		self close].
! !

!HTTPConnection methodsFor:'serving'!

close
	self stream close.
	self server removeConnection: self.
	self loop notNil ifTrue: [self loop terminate]
!

interact
	"longer description is below method"
	| interactionBlock |
	interactionBlock :=
		[SpExceptionContext
			for: [[true] whileTrue:
				[self getAndDispatchMessages.
				Processor yield] ]
		on: SpError
		do: [:ex | self close]].
	self server isMultiThreading
		ifTrue: [self loop: (interactionBlock forkAt: Processor userBackgroundPriority)]
		ifFalse: [interactionBlock value].
	^self

"I represent a specifc connection with an HTTP client (a browser, probably) over which will come an HTTP request.  Here, I fork the handling of the request so that the current thread (which is most likely the HTTP server main loop) can carry on with the next request.  This means that more than one request may being handled in the image at a time, and that means that the application developer must worry about thread safety - e.g the problem of a given business object being updated by more than one HTTP request thread.
For a GemStone implementation of Swazoo, one may want only one request is handled at a time, multi-threadedness being handled by having multiple gems.  This is a nice option because the application developer does not have to worry about thread safety in this case - GemStone handles the hard stuff.
*And* the thing called a loop that was in this method was no such thing.  In all circumstances, >>getAndDispatchMessages handles exactly one requst and then closes the socket!! (very non-HTTP1.1).  Anyway, for now I'm just going to make that explicit.  This needs to be re-visited to support HTTP 1.1."
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebMethodResource subclass:#WebLivePDFCreator
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

WebLivePDFCreator comment:'WebLivePDFCreator created PDF from HTML source together with Table of contents!! It uses external HTMLDOC converter (http://www.htmldoc.org/)
'
!

!WebLivePDFCreator class methodsFor:'instance creation'!

fromHtmlMethod: aMethodSymbol on: anObject site: anAIDASite
	"this method should return a complete html page!! "
	| docname |
	docname := (anObject class canUnderstand: #preferedUrlName)
		ifTrue: [anObject preferedUrlName] ifFalse: ['live'].
	^self fromMethod: aMethodSymbol on: anObject
		contentType: 'application/pdf' preferedUrl: '/generated/', docname, '.pdf' site: anAIDASite
! !

!WebLivePDFCreator methodsFor:'accessing'!

aidaDontCache
	"refresh content always!! "
	^true
!

expiresTimestamp
	^nil
! !

!WebLivePDFCreator methodsFor:'converting'!

convertToPdf: aHtmlString
        | fname pdfname stream |
        fname := (Random new next * 1000) truncated printString, '.html'.
        pdfname := (Random new next * 1000) truncated printString, '.pdf'.
        [stream := (SpFilename named:fname) writeStream. stream nextPutAll: aHtmlString]
                ensure: [stream close].
        UnixProcess cshOne: 'htmldoc --batch htmldoc.book --outfile ', pdfname, ' ', fname.
        (SpFilename named:fname) delete.
        [stream := (SpFilename named:pdfname) readStream binary. ^stream contents]
                ensure: [stream close. (SpFilename named:pdfname) delete].
! !

!WebLivePDFCreator methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	| html pdf |
	html := AIDASite convert: (self object perform: self method) toCodepage: #'iso-8859-2'.
	pdf := self convertToPdf: html.
	aStream nextPutAll:  pdf asByteString.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

HTTPStream subclass:#HTTPWriteStream
	instanceVariableNames:'stream'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Compatibility'
!

!HTTPWriteStream methodsFor:'accessing'!

cr
	"^self
I write a CR to my underlying stream."

	self underlyingStream nextPut: Character cr.
	^self
!

crlf
	"^self
I write a CRLF pair to my underlying stream."

	self
		cr;
		lf.
	^self
!

ht
	"^self
I write a horzintal tab to my underlying stream.  HT is the term used in RFC2616."

	self underlyingStream nextPut: Character tab.
	^self
!

lf
	"^self
I write a LF pair to my underlying stream."

	self underlyingStream nextPut: Character lf.
	^self
!

nextPutAll: aCollection
	"^self
I write aCollection to my underlying stream.  For now, I'll let anything go."

	^self underlyingStream nextPutAll: aCollection
!

nextPutLine: aCollection
	"^self
I write aCollection to my underlying stream followed by a >>crlf."

	self underlyingStream nextPutAll: aCollection.
	self crlf.
	^self
!

sp
	"^self
I write a space to my underlying stream.  SP is the term used in RFC2616."

	self underlyingStream nextPut: Character space.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

HTTPAuthorizationField subclass:#HTTPAuthorizationBasicField
	instanceVariableNames:'userid password'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPAuthorizationBasicField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPutAll: 'Basic '.
	super valuesAsStringOn: aStream.
	^self
! !

!HTTPAuthorizationBasicField methodsFor:'private'!

resolveUserPass
	"^self
I look at my credentials string and pull out the userid and password.  Note that having to check for atEnd before the upToEnd is for GemStone which crashes if upToEnd is used when already atEnd."

	"(Base64EncodingReadStream on: 'YnJ1Y2U6c3F1aWRzdXBwbGllZHBhc3N3b3Jk' ) upToEnd asString "

	| userPassString sourceStream |
	userPassString := HTTPString
				stringFromBytes: (Base64EncodingReadStream on: self credentials) upToEnd.
	sourceStream := ReadStream on: userPassString.
	userid := sourceStream upTo: $:.
	password := sourceStream atEnd
				ifTrue: [String new]
				ifFalse: [sourceStream upToEnd].
	^self
! !

!HTTPAuthorizationBasicField methodsFor:'services'!

password
	"^a String
I return the password string (as defined in RFC 2617 pp.2) part of the user-pass value in my credentials."

	password isNil ifTrue: [self resolveUserPass].
	^password
!

userid
	"^a String
I return the userid string (as defined in RFC 2617 pp.2) part of the user-pass value in my credentials."

	userid isNil ifTrue: [self resolveUserPass].
	^userid
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SwazooIntegrationTest
	instanceVariableNames:'server site'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Tests'
!

SwazooIntegrationTest comment:'All tests are commented out because they are DANGEROUS to live Swazoo systems!!

Instance Variables:
	server  <SwazooServer>  description of server
	site    <Object | Proxy>        description of site

'
!

!SwazooIntegrationTest methodsFor:'defaults'!

siteHost
	^'localhost'
!

siteIP
	^'localhost'
!

siteName
	^'test'
!

sitePort
	^8765
!

siteRootUri
	^'/'
!

siteSSLPort
	^8766
! !

!SwazooIntegrationTest methodsFor:'private'!

localSendUrl: aString
	"sends request with that RELATIVE url to the site localy - it simulates a real network request. "
	| request httpServer |
	request := Swazoo.HTTPRequest request: aString from: self siteHost at: self siteIP.
	request uri port: self sitePort.
	httpServer := server servers asOrderedCollection first.
	^httpServer answerTo: request
!

sendUrl: aString
	"sends a real network request with that RELATIVE url to the site with parameters from defaults.
	Returns a Net.HttpResponse"
	| client request |
	client := Net.HttpClient new.
	request := Net.HttpRequest get: 'http://', self siteHost, ':', self sitePort printString, aString.
	^client executeRequest: request.
! !

!SwazooIntegrationTest methodsFor:'running'!

setUp
	server := Swazoo.SwazooServer singleton.
	"server initialize." "DANGEROUS!! "  "to remove all stuff and stop it"
	"site := AIDASite newNamed: self siteName.
	site
		host: self siteHost;
		ip: self siteIP;
		port: self sitePort;
		sslPort: self siteSSLPort. "
!

tearDown
	"site := server siteNamed: self siteName.
	site stop.
	server removeSite: site.
	server := nil.
	site := nil."
! !

!SwazooIntegrationTest methodsFor:'testing'!

testAccessingByName
"
	self assert: (Swazoo.SwazooServer siteNamed: self siteName) notNil.
	self assert: (Swazoo.SwazooServer siteHostnamed: self siteHost) notNil
"
!

testAdminPage
"
	| |
	server startSite: self siteName.
	self shouldnt: [self sendUrl: '/admin.html'] raise: Error.
	self shouldnt: [self sendUrl: '/admin.html?view=login'] raise: Error.
	server stopSite: self siteName.
"
!

testDummyRequest
"
	server startSite: self siteName.
	self should: [self sendUrl: '/dummycompletelydummy.html'] raise: Net.HttpObjectNotFound.
	server stopSite: self siteName.
"
!

testLocalAdminPage
"
	| response |
	server startSite: self siteName.
	response := self localSendUrl: '/admin.html'.
	self assert: response isRedirectLink.
	response := self localSendUrl: '/admin.html?view=login'.
	self assert: response isOk.
	server stopSite: self siteName.
"
!

testLocalDummyRequest
"
	| response |
	server startSite: self siteName.
	response := self localSendUrl: '/dummycompletelydummy.html'.
	self assert: response isNotFound.
	server stopSite: self siteName.
"
!

testSetUp
"
	self assert: (server sites size = 1).
	self assert: (site ip = self siteIP).
	self assert: (site host = self siteHost).
	self assert: (site port = self sitePort).
	self assert: site isServing not.
"
!

testStarting
	server startSite: self siteName.
	self assert: (server siteNamed: self siteName) isServing.
	self assert: (server servers asOrderedCollection first isServing).
	server stopSite: self siteName.
	self deny: (server siteNamed: self siteName) isServing.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebMethodResource subclass:#WebMethodImage
	instanceVariableNames:'lastUsed'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

WebMethodImage class instanceVariableNames:'Cache'

"
 No other class instance variables are inherited by this class.
"
!

WebMethodImage comment:'This image is actually in-lined in a method, which is called on defined object and must return a ByteArray of image contents.

Instance Variables:
	contentType     <String>         content type of an image eg. ''image/gif'', which is default.
	method  <Symbol>        symbol of a method to be called on object
	object  <Object>        object on which a method will be called

'
!

!WebMethodImage class methodsFor:'instance creation'!

fromMethod: aSymbol on: anObject contentType: aString site: anAIDASite
	"cached one only preservers its url, but method is still called everytime image is shown!!"
	| cached |
	cached := self imageForObject: anObject andMethod: aSymbol.
	^cached notNil
		ifTrue: [cached]
		ifFalse: [super new
			object: anObject;
			method: aSymbol;
			contentType: aString;
			site: anAIDASite;
			addToCache]
! !

!WebMethodImage class methodsFor:'caching'!

cache
	Cache isNil ifTrue: [self initCache].
	^Cache
!

imageForObject: anObject andMethod: aSymbol

	^self cache detect: [:each | each object == anObject and: [each method = aSymbol] ] ifNone: [nil]
!

initCache
	Cache := Set new.
! !

!WebMethodImage methodsFor:'accessing'!

expiresTimestamp
	"one hour from now, to avoid reloading of images"
	^SpTimestamp fromSeconds: SpTimestamp now asSeconds + 3600
!

lastUsed
	"timestamp of last usage. Used for caching algorithms. Set at HTML generation"

	lastUsed isNil ifTrue: [self lastUsed: SpTimestamp now].
	^lastUsed
!

lastUsed: aTimestamp
	"timestamp of last usage. Used for caching algorithms"

	lastUsed := aTimestamp
!

preferedUrl
	| ext |
	ext := self site mimeMap extensionForType: self contentType.
	ext isNil ifTrue: [ext := '.html'].
	^'/img/' , self method asString asLowercase , ext
!

resolver
	^self site urlResolver
! !

!WebMethodImage methodsFor:'caching'!

addToCache
	self makeRoomInCache.
	self class cache add: self.
!

cacheHysteresis
	"when removing from cache, make room for that number of entries"
	^10
!

makeRoomInCache
	"if cache is full, remove least used images"
	| cached  toRemove |
	self class cache size < self maxCacheSize ifTrue: [^self].
	cached := (SortedCollection
		withAll: self class cache
		sortBlock: [:a :b | a lastUsed < b lastUsed]) asOrderedCollection.
	self cacheHysteresis timesRepeat:
		[toRemove := cached first.
		toRemove removeFromCache.
		cached removeFirst]
!

maxCacheSize
	^50
!

removeFromCache
	self class cache remove: self ifAbsent: [].
	self removeFromURLResolver.
!

removeFromURLResolver
	self resolver notNil
		ifTrue: [self resolver removeObject: self]
! !

!WebMethodImage methodsFor:'printing'!

printString
	^'WebMethodImage #', self method asString, ' on ', self object class name
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebUser
	instanceVariableNames:'parent id username password name surname company address city zip
		country email phone fax groups otherValues'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!WebUser class methodsFor:'instance creation'!

new
	^super new initialize
!

newAdmin
	^self new
		name: self adminName;
		surname: self adminSurname;
		email: self adminEMail;
		username: self adminUsername;
		password: self adminPassword
!

newGuest
	^self new
		name: self guestName;
		surname: self guestSurname;
		email: self guestEMail;
		username: self guestUsername;
		password: self guestPassword
! !

!WebUser class methodsFor:'defaults'!

adminEMail
	^'admin'
!

adminName
	^'Admin'
!

adminPassword
	^'password'
!

adminSurname
	^''
!

adminUsername
	^'admin'
!

guestEMail
	^'guest'
!

guestName
	^'Guest'
!

guestPassword
	^'guest'
!

guestSurname
	^''
!

guestUsername
	^'guest'
! !

!WebUser methodsFor:'accessing'!

address
	address isNil ifTrue: [^''].
	^address
!

address: aString
	address := aString.
!

allGroups
	^groups copy
!

asPerson
	"parallel Person object (from Party framework if present, otherwise nil)"
	^self otherValuesAt: #Person ifAbsent: [^self initPerson]
!

asWebUser
	^self
!

city
	city isNil ifTrue: [^''].
	^city
!

city: aString
	city := aString.
!

company
	company isNil ifTrue: [^''].
	^company
!

company: aString
	company := aString.
!

country
	country isNil ifTrue: [^''].
	^country
!

country: aString
	country := aString.
!

email
	email isNil ifTrue: [^''].
	^email
!

email: aString
	email := aString.
!

fax
	fax isNil ifTrue: [^''].
	^fax
!

fax: aString
	fax := aString.
!

id
	"unique id of that user"
	^id
!

id: aNumber
	id := aNumber.
!

menuName
	"in dropdown menus"
	^self surnameName
!

name
	name isNil ifTrue: [self asPerson notNil ifTrue: [^self asPerson name] ifFalse: [^''] ].
	^name
!

name: aString
	self asPerson notNil ifTrue: [^self asPerson name: aString].
	name := aString trimBlanks.
!

nameSurname
	^self name, ' ', self surname
!

password
	password isNil ifTrue: [^''].
	^password
!

password: aString
	password := aString asLowercase trimBlanks.
!

phone
	phone isNil ifTrue: [^''].
	^phone
!

phone: aString
	phone := aString.
!

someId
	"just return some text, possibly surnameName"
	self surnameName trimBlanks notEmpty ifTrue: [^self surnameName].
	self email notEmpty ifTrue: [^self email].
	^'----'
!

surname
	surname isNil ifTrue: [self asPerson notNil ifTrue: [^self asPerson surname] ifFalse: [^''] ].
	^surname
!

surname: aString
	self asPerson notNil ifTrue: [^self asPerson surname: aString].
	surname := aString trimBlanks.
!

surnameName
	^self surname, ' ', self name
!

username

	username isNil ifTrue: [^''].
	^username.
!

username: aString
	username := aString asLowercase trimBlanks.
!

uuid
	"some unique identifier. Hash for now, probably unique enough!! "
	^self hash printString
!

zip
	zip isNil ifTrue: [^''].
	^zip
!

zip: aString
	zip := aString.
! !

!WebUser methodsFor:'accessing-other'!

autoLogout
	"logout after 15min of inactivity. default is NO!! "
	^self otherValuesAt: #AutoLogout ifAbsent: [false]
!

autoLogout: aBoolean
	"logout after 15min of inactivity"
	^self otherValuesAt: #AutoLogout put: aBoolean
!

lastAppUrl
	"an url which last WebApplication was called. "
	^self otherValuesAt: #LastAppUrl ifAbsent: [nil].
!

lastAppUrl: aString
	"an url which last WebApplication was called. It is set AFTER the app view is generated!!"
	^self otherValuesAt: #LastAppUrl put: aString
!

logoutFromUrl
	"From which page user logout. To be redirected back after login"
	^self otherValuesAt: #LogoutFromUrl ifAbsent: [nil].
!

logoutFromUrl: aString
	"From which page user logout. To be redirected back after login"
	^self otherValuesAt: #LogoutFromUrl put: aString
! !

!WebUser methodsFor:'groups'!

addToActivatingGroup
	self parent addActivatingUser: self
!

addToGroup: aWebUserGroup
	self groups add: aWebUserGroup
!

addToRegisteredGroup
	self parent addRegisteredUser: self
!

becomeAdmin
	self parent adminGroup addUser: self
!

removeFromGroup: aWebUserGroup
	self groups remove: aWebUserGroup ifAbsent: []
! !

!WebUser methodsFor:'initialize-release'!

initId
	self id: (Random new next * 1000000000) asInteger.
!

initOtherValues
	otherValues := Dictionary new.
!

initPerson
	^nil
!

initialize
	self initId
! !

!WebUser methodsFor:'printing'!

printString
	^'aWebUser named ', self surname, ', ', self name, ' (', self username, ') '
! !

!WebUser methodsFor:'private'!

groups
	groups isNil ifTrue: [self initGroups].
	^groups
!

initGroups
	groups := Set new.
!

migrateToUnicode
	"from iso8859-2"
	"WebUser allInstances do: [:each | each migrateToUnicode]"
	username notNil ifTrue: [username := username ensureUnicodeSloveneChars].
	password notNil ifTrue: [password := password ensureUnicodeSloveneChars].
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].
	surname notNil ifTrue: [surname := surname ensureUnicodeSloveneChars].
	company notNil ifTrue: [company := company ensureUnicodeSloveneChars].
	city notNil ifTrue: [city := city ensureUnicodeSloveneChars].
	country notNil ifTrue: [country := country ensureUnicodeSloveneChars].
!

otherValues
	^otherValues
!

otherValuesAt: aString
	^self otherValuesAt: aString ifAbsent: [nil]
!

otherValuesAt: aString ifAbsent: aBlock
	self otherValues isNil ifTrue: [^aBlock value].
	^self otherValues at: aString ifAbsent: [aBlock value]
!

otherValuesAt: aString put: anObject
	self otherValues isNil ifTrue: [self initOtherValues].
	^self otherValues at: aString put: anObject
!

parent
	^parent
!

parent: aWebSecurityManager
	parent := aWebSecurityManager
!

person: aPerson
	"connect to parrallel Person from Party framework"
	self otherValuesAt: #Person put: aPerson.
	aPerson asWebUser ~= self ifTrue: [aPerson webUser: self].
! !

!WebUser methodsFor:'testing'!

hasEMail

	"at least email must be entered to accept a new user"

	^self email ~= ''
!

isActivating
	"user needs to confirm registration"
	^self groups contains: [:each | each isActivatingGroup]
!

isAdmin
	"all from Administrators group are admins, also default Admin user"
	^self groups contains: [:each | each isAdminGroup]
!

isGuest
	"all non registered visitors have the same user: a Guest"
	^self name = 'Guest' and: [(self username = 'guest') & (self password = 'guest')]
!

isRegistered
	^self groups contains: [:each | each isRegisteredGroup]
!

isWebUser
	^true
!

isWebUserGroup
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

HTTPAuthorizationField subclass:#HTTPAuthorizationDigestField
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPAuthorizationDigestField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPutAll: 'Digest '.
	super valuesAsStringOn: aStream.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:37'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebClipboard
	instanceVariableNames:'title url object'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

WebClipboard comment:'Used for cut/copy/paste page references (not page contents!!) for easier hyperlinking of pages. Every page should have copy action. Then you can paste url to related links section in some other page.

Instance Variables:
	title   <String> title of a page
	url     <String>        url link to a page

'
!

!WebClipboard methodsFor:'accessing'!

object
	^object
!

object: anObject
	object := anObject
!

title
	^title
!

title: anObject
	title := anObject
!

url
	^url
!

url: anObject
	url := anObject
! !

!WebClipboard methodsFor:'converting'!

asDocLink
	"return clipboard contents as a new DocLink"
	^DocLink new
		title: self title;
		url: self url;
		object: self object
!

copyFromDocLink: aDocLink
	self title: aDocLink title.
	self url: aDocLink url.
	self object: aDocLink object
! !

!WebClipboard methodsFor:'testing'!

isEmpty
	^(self url isNil or: [self url isEmpty]) and: [self object isNil].
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SwazooConfigurationTest
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!SwazooConfigurationTest methodsFor:'testing'!

testCompositeResourceSite
	| rs site composite howdy duh hithere |
	rs := ReadStream 
				on: '<Site>
 <CompositeResource uriPattern: ''/''>
  <HelloWorldResource uriPattern: ''howdy''>
  <CompositeResource uriPattern: ''duh''>
   <HelloWorldResource uriPattern: ''hithere''>
  </CompositeResource>
 </CompositeResource>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	composite := site children first.
	self assert: composite class == CompositeResource.
	self assert: composite uriPattern = '/'.
	self assert: composite children size = 2.
	self assert: composite parent == site.
	howdy := composite children first.
	self assert: (howdy class == HelloWorldResource).
	self assert: howdy uriPattern = 'howdy'.
	self assert: howdy parent == composite.
	duh := composite children last.
	self assert: duh children size = 1.
	self assert: duh class == CompositeResource.
	self assert: duh uriPattern = 'duh'.
	self assert: duh parent == composite.
	hithere := duh children first.
	self assert: hithere class == HelloWorldResource.
	self assert: hithere uriPattern = 'hithere'.
	self assert: hithere parent == duh.
!

testEmptySite
	| rs site alias |
	rs := ReadStream 
				on: '<Site>
 <SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site aliases size = 1.
	self assert: site currentUrl = 'http://swazoo.org/'.
	alias := site aliases first.
	self assert: alias host = 'swazoo.org'.
	self assert: alias ip = '192.168.1.66'.
	self assert: alias port = 80
!

testFileResourceSite
	| rs site resource |
	rs := ReadStream 
				on: '<Site>
<SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''>
 <FileResource uriPattern: ''/'' filePath: ''files''>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	resource := site children first.
	self assert: resource class == FileResource.
	self assert: resource uriPattern = '/'.
	self assert: resource filePath = 'files'.
	self assert: resource parent == site.
	self assert: resource currentUrl = 'http://swazoo.org/'.
!

testMultipleResourcesSite
	| rs site resource1 resource2 |
	rs := ReadStream 
				on: '<Site>
 <HelloWorldResource uriPattern: ''/''>
 <HelloWorldResource uriPattern: ''/''>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site children size = 2.
	resource1 := site children first.
	self assert: (resource1 class == HelloWorldResource).
	self assert: resource1 uriPattern = '/'.
	resource2 := site children last.
	self assert: resource2 class == HelloWorldResource.
	self assert: resource2 uriPattern = '/'
!

testMultipleSites
	| rs sites site alias1 alias2 |
	rs := ReadStream 
				on: '<Site>
 <SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''>
 <SiteIdentifier ip: ''192.168.1.66'' port: 81 host: ''swazoo.org''>
</Site>
<Site>
</Site>'.
	sites := SwazooServer readSitesFrom: rs.
	self assert: sites size = 2.
	site := sites first.
	self assert: site aliases size = 2.
	alias1 := site aliases first.
	self assert: alias1 host = 'swazoo.org'.
	self assert: alias1 ip = '192.168.1.66'.
	self assert: alias1 port = 80.
	alias2 := site aliases last.
	self assert: alias2 host = 'swazoo.org'.
	self assert: alias2 ip = '192.168.1.66'.
	self assert: alias2 port = 81
!

testSingleResourceSite
	| rs site resource |
	rs := ReadStream on: '<Site>
<SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''>
 <HelloWorldResource uriPattern: ''/''>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	resource := site children first.
	self assert: (resource class == HelloWorldResource).
	self assert: resource uriPattern = '/'.
	self assert: resource parent == site.
	self assert: resource currentUrl = 'http://swazoo.org/'.
!

testSiteTag
	| rs config tag |
	rs := ReadStream on: '  <Site>  

</Site>   '.
	config := Site new.
	tag := config nextTagFrom: rs.
	self assert: tag = 'Site'.
	tag := config nextTagFrom: rs.
	self assert: tag = '/Site'.
	self assert: (config nextTagFrom: rs) isNil
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpError subclass:#SwazooSiteError
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Exceptions'
!


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#URIResolution
	instanceVariableNames:'position request'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-HTTP'
!

!URIResolution class methodsFor:'instance creation'!

resolveRequest: aRequest startingAt: aResource
	^(self new initializeRequest: aRequest) visitResource: aResource
! !

!URIResolution methodsFor:'accessing'!

atEnd
	^self position = self request uri identifierPath size
!

fullPath
	^self request uri identifierPath
!

position
	^position
!

request
	^request
!

resourcePath
	^self request uri identifierPath copyFrom: 1 to: self position
!

tailPath
	| fullPath |
	fullPath := self fullPath.
	^fullPath copyFrom: self position + 1 to: fullPath size
! !

!URIResolution methodsFor:'private'!

advance
	self position: self position + 1
!

currentIdentifier
	^self currentPath last
!

currentPath
	^self request uri identifierPath copyFrom: 1 to: self position
!

getAnswerFrom: aResource
	^aResource answerTo: self request
!

position: anInteger
	position := anInteger
!

request: aRequest
	request := aRequest
!

retreat
	self position: self position - 1.
	^nil
!

siteMatch: aSite
	| siteIdentifier hostName |
	hostName := self request headers
				fieldOfClass: HTTPHostField
				ifPresent: [:field | field hostName]
				ifAbsent: [self request requestLine requestURI hostname].
	siteIdentifier := SiteIdentifier
				ip: self request ip
				port: self request port
				host: (hostName notNil ifTrue: [hostName] ifFalse: ['']).
	^aSite match: siteIdentifier
!

stringMatch: aResource
	^aResource uriPattern = self currentIdentifier
!

tailStream
	^ReadStream on: self tailPath
! !

!URIResolution methodsFor:'private-initialize'!

initializeRequest: aRequest
	self request: aRequest.
	self request resolution: self.
	self position: 1
! !

!URIResolution methodsFor:'resolving'!

resolveCompositeResource: aResource
	(aResource canAnswer and: [aResource match: self currentIdentifier])
		ifFalse: [^nil].
	^self visitChildrenOf: aResource advancing: true
!

resolveLeafResource: aResource
	(aResource canAnswer and: [self stringMatch: aResource]) ifFalse: [^nil].
	^self getAnswerFrom: aResource
!

resolveServerRoot: aServerRoot
	^self resolveTransparentComposite: aServerRoot
!

resolveSite: aSite
	(aSite canAnswer and: [self siteMatch: aSite]) ifFalse: [^nil].
	^self visitChildrenOf: aSite advancing: false
!

resolveTransparentComposite: aCompositeResource
	^self visitChildrenOf: aCompositeResource advancing: false
!

visitChildrenOf: aResource advancing: aBoolean
	| response |
	self atEnd & aBoolean ifTrue: [^self getAnswerFrom: aResource].
	aBoolean ifTrue: [self advance].
	aResource children do:
			[:each |
			response := self visitResource: each.
			response isNil ifFalse: [^response]].
	^aBoolean ifTrue: [self retreat] ifFalse: [nil]
!

visitResource: aResource
	^aResource helpResolve: self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

AIDAProtocolAdaptor subclass:#AIDAAspectAdaptor
	instanceVariableNames:'aspect'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

!AIDAAspectAdaptor class methodsFor:'instance creation'!

forAspect: aSymbol

	^super new aspect: aSymbol
! !

!AIDAAspectAdaptor methodsFor:'accessing'!

aspect

	^aspect
!

aspect: aSymbol

	aspect := aSymbol
!

value

	^self subject perform: self aspect
!

value: aValue

	self subject perform: (self aspect asString, ':') asSymbol with: aValue
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebDiscussionsResponse
	instanceVariableNames:'timestamp title author authorsEmail user body responses parent'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Parts'
!

!WebDiscussionsResponse class methodsFor:'instance creation'!

new
	^super new initialize.
! !

!WebDiscussionsResponse methodsFor:'accessing'!

allParents

	| collection |
	collection := OrderedCollection new.
	self parent notNil ifTrue:
		[collection add: self parent.
		collection addAllFirst: self parent allParents].
	^collection
!

author
	author isNil ifTrue: [self author: ''].
	^author
!

author: aString
	author := aString.
!

authorsEmail
	authorsEmail isNil ifTrue: [self authorsEmail: ''].
	^authorsEmail
!

authorsEmail: aString
	authorsEmail := aString.
!

body
	body isNil ifTrue: [self body: ''].
	^body
!

body: aString
	body := aString.
!

date
	^self timestamp asDate
!

discussion
	"original discussion, where this response belongs"
	self allParents size > 1
		ifTrue: [^self allParents at: 2]
		ifFalse: [^self]

"WebServer default webDiscussions"
!

htmlBody
	| htmlBody |
	(self body isNil) ifTrue: [htmlBody := '']
		ifFalse:
		[htmlBody := self body
			copyReplaceAll: (String with: Character cr)
			with: '<br>'].

	^htmlBody
!

parent
	^parent.
!

parent: aWebDiscussionsResponse
	parent := aWebDiscussionsResponse.
!

responseCount

	"return a number of all responses down in hierarchy"

	| count |
	count := self responses size.
	self responses do: [:each | count := count + each responseCount].
	^count
!

responses
	responses isNil ifTrue: [self initResponses].
	^responses
!

time
	^self timestamp asTime
!

timestamp
	"date and time of response"
	timestamp isNil ifTrue: [self timestamp: Timestamp now].
	^timestamp
!

timestamp: aTimestamp
	timestamp := aTimestamp.
!

title
	title isNil ifTrue: [self title: ''].
	^title
!

title: aString
	title := aString.
!

top
	"reference to aWebDiscussions as parent of all responses"
	^self allParents first

"WebServer default webDiscussions"
!

user
	"a web user, which created a response"
	^user
!

user: aWebUser
	user := aWebUser.
! !

!WebDiscussionsResponse methodsFor:'adding-removing'!

addDiscussionsResponse: aWebDiscussionsMessage user: aWebUser
	"add an empty dicussions response"
	 WebTransactionMonitor critical:
		[(self responses includes: aWebDiscussionsMessage) ifFalse:
			[self responses add: aWebDiscussionsMessage.
			aWebDiscussionsMessage
				parent: self;
				timestamp: SpTimestamp now;
				user: aWebUser.
			self top addToNewest: aWebDiscussionsMessage.
		"aWebDiscussionsMessage notifyNewResponse"] ].
!

deleteDiscussionsResponse: aWebDiscussionsMessage
	"delete this  response, if don't have subresponses"
	aWebDiscussionsMessage responses notEmpty ifTrue: [^nil].
	WebTransactionMonitor critical:
		[self responses remove: aWebDiscussionsMessage ifAbsent: [^nil].
		aWebDiscussionsMessage parent: nil.
		self top removeFromNewest: aWebDiscussionsMessage].
!

notifyNewResponse

	"send by e-mail notification of new response"
	|  msgSubject msgBody |
	msgSubject := 'New response in discussion: ', self discussion title.
	msgBody := 'New response: ', self title, ' from author: ', self author.
	[AIDASite default urgentEMailSubject: msgSubject body: msgBody] fork.
! !

!WebDiscussionsResponse methodsFor:'initialize-release'!

initResponses
	responses := OrderedCollection new.
!

initialize
! !

!WebDiscussionsResponse methodsFor:'printing'!

printString
 ^'WebDiscussionsResponse titled: ', self title.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebFrameApp subclass:#WebIndexApp
	instanceVariableNames:'searchString results page'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Parts'
!

!WebIndexApp methodsFor:'accessing'!

page
	"return current result page number to show. Each page shows 10 hits"
	page isNil ifTrue: [self page: 1].
	^page
!

page: aNumber

	page := aNumber.
!

resultWithHash: aString
	"find an object in results with that hash value"
	^(self results detect: [:each | each key hash asString = aString] ifNone: [Association new]) key
!

results
	"here the results of a search are stored."
	results isNil ifTrue: [self initResults].
	^results
!

results: aCollection
	results := aCollection
!

searchString
	searchString isNil ifTrue: [self searchString: ''].
	^searchString
!

searchString: aString

	searchString := aString.
! !

!WebIndexApp methodsFor:'actions'!

actionMain
	"search default web index for objects containing words from searchString, store results
	in attribute results and st the next view as 'results' in order to print result web page"
	self results: (self observee objectsForWords: self searchString).
	self page: 1.
	self newView: #results
!

actionResults
	self actionMain
! !

!WebIndexApp methodsFor:'initialize-release'!

initResults
	results := OrderedCollection new.
! !

!WebIndexApp methodsFor:'printing'!

viewCopyToClipboard
	"put this refrence to web clipboard"
	| result |
	result := self resultWithHash: (self session lastRequest queryAt: 'uuid').
	result notNil ifTrue: [(result webAppFor: self session) copyToClipboard].
	^self redirectToView: #results "to have an url without view=paste"
!

viewMain
	| element |
	self clear. self title: 'Search our web site'.
	element := WebElement new.
      element table width: 480.
	element cell    addText: ('<font face= "arial, helvetica" size=+2><b>', self title).
	element newRow.
	element cell color: self tableHeaderColor;
		add: (self smallText: 'Find the following words: ');
		add: (WebInputField new size: 30; aspect: #searchString for: self);
		add: (WebButton new text: 'Search').
	^self pageFrameWith: element title: self title
!

viewResults
	| e |
	self page: (self session lastRequest queryAt: 'page' ifAbsent: [self page]) asInteger.
	self clear. self title: 'Search results'.
	e := WebElement new.
      e table width: 1. "100%"
	e cell addTextH1: self title. e newRow.
	e cell color: self tableHeaderColor;
		addInputFieldAspect: #searchString for: self size: 40; addButtonText: 'Search'.
	e newRow. e cell add: self resultNumberElement.
	e newRow. e add: self resultsElement.
	e newRow.
	e cell align: #center; add: self pageSelectionElement.
	^self pageFrameWith: e title: self title.
! !

!WebIndexApp methodsFor:'printing-elements'!

abstractTextSize

	^400
!

chopText: aString toSize: aNumber
	| inStream outStream |
	inStream := aString readStream.
	outStream := WriteStream on: String new.
	1 to: aString size
		do:
			[:count |
			inStream atEnd ifTrue: [^outStream contents].
			(count >= aNumber and: [inStream peek = $ ])
				ifTrue: [^outStream contents , ' ...'].
			outStream nextPut: inStream next].
	^outStream contents

	"WebIndexApp new chopText: 'hojladri hojladra' toSize: 5"
!

miniSearchFormElement
	| form actionLink |
	self cleanup.
	form := self defaultForm.
	actionLink := (WebLink text: '' linkTo: self observee)  view: 'results'.
	form
		actionUrl: (actionLink composeURLOn: self session);
		target: 'Vsebina'.
	form
		addText: '<center>';
		add: (WebInputField new size: 15;
				aspect: #searchString for: self);
		addBreak;
		add: (WebButton new text: '&nbsp;&nbsp;&nbsp;Najdi&nbsp;&nbsp;&nbsp;');
		addText: '</center>'.
	form registrateWebFormElements.
	^form
!

pageSelectionElement

	| element pages |
	element := WebElement new.
	pages := self results size = 0
		ifTrue: [0]
		ifFalse: [(self results size // self resultsOnPage) + 1].
	pages = 1 ifTrue: [^element].
	element addText: '<font face="helvetica, arial" size="-1">'.
	1 to: pages do: [:index |
		index = self page
			ifTrue: [element addText: index printString attributes: #bold]
			ifFalse:
				[element add:
					((WebLink text: index printString linkTo: self observee )
						view: #results;
						parameter: 'page' value: index printString)].
		element addNbSp ].
	element addText: '</font>'.
	^element
!

resultNumberElement


	| element start end |
	element := WebElement new.
	(self results size = 0) ifTrue:
		[element add: (self smallText: '0 hits' attributes: #bold). ^element].
	(self results size = 1) ifTrue:
		[element add: (self smallText: '1 hit' attributes: #bold). ^element].

	start := (self page-1)*self resultsOnPage+1.
	(start+self resultsOnPage > self results size)
		ifTrue: [end := self results size]
		ifFalse: [end := start+self resultsOnPage-1].
	element cell add:
		(self smallText:  (start printString, ' - ', end printString,
			' from ', self results size printString, ' hits') attributes: #bold).
	^element
!

resultsElement
	"return a web element for search results"
	| e abstract objTitle modifiedText modifiedDate first last assoc |
	first := (self page - 1) * self resultsOnPage + 1.
	last := (first + self resultsOnPage - 1) min: self results size.
	e := WebList  newDefinition id: #searchRslts.
	first to: last do: [:index |
		assoc := self results at: index.
		objTitle := (assoc key class canUnderstand: #indexTitle)
			ifTrue: [assoc key indexTitle] ifFalse: [self chopText: assoc key indexText toSize: 50].
		abstract := (assoc key class canUnderstand: #indexAbstract)
			ifTrue: [assoc key indexAbstract]
			ifFalse: [self chopText: assoc key indexText trimNewlines toSize: self abstractTextSize].
		modifiedText := ''.
		(assoc key class canUnderstand: #modified) ifTrue:
			[modifiedDate := assoc key modified. modifiedDate notNil ifTrue:
				[modifiedText := 'changed: <b> ', modifiedDate shortPrintSloString, '</b>,  '] ].
		e addDefinitionTerm: (WebElement new addText: (index printDotString, '.  ');
			addLinkTo: assoc key text: objTitle;
			addLinkTo: self gif: #copyIconGif title: 'Copy to web clipboard'
				view: #copyToClipboard parameter: 'uuid' value: assoc key hash asString; yourself).
		e addDefinition: (WebElement new addText: abstract).
"
		e newCell color: self tableRowColor; addText:
			('modifiedText, 'visits: <b>',
			(self site urlResolver counterFor: assoc key) total printDotString, '</b>')
"
		].
	^e
!

resultsOnPage
	^10
!

searchFormServlet
	"servlet for using in static pages such as frames for search"
	| indexApp |
	self session cookie ifTrue:
		[indexApp := self site index webAppFor: self session.
		^indexApp miniSearchFormElement]
!

searchLinkServlet
	"servlet for using in static pages such as frames for search"
	| element |
	element := WebElement new.
	element add: ((WebLink text: 'Search' linkTo: self site index)).
	^element
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

AIDAProtocolAdaptor subclass:#AIDAIndexedAdaptor
	instanceVariableNames:'index'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

!AIDAIndexedAdaptor class methodsFor:'instance creation'!

forIndex: aNumber

	^super new index: aNumber
! !

!AIDAIndexedAdaptor methodsFor:'accessing'!

index

	^index
!

index: aNumber

	index := aNumber
!

value

	^self subject at: self index
!

value: aValue

	self subject at: self index put: aValue
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebScript
	instanceVariableNames:'script'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebScript class methodsFor:'instance creation'!

script: aString
	^super new script: aString
! !

!WebScript methodsFor:'accessing'!

script
	^script
!

script: aString
	"add to others if already exists, separate with JavaScript separator ; "
	script isNil ifTrue: [script := ''].
	(script notEmpty and: [script last = $; ]) ifFalse: [script := script, '; '].
	script := script, aString trimBlanks.
	"always end with ; "
	(script notEmpty and: [script last ~= $; ]) ifTrue: [script := script , ';' ]
! !

!WebScript methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	aStream nextPutAll: '<script type="text/javascript">'.
	script notNil ifTrue: [aStream nextPutAll: script].
	aStream nextPutAll: '</script>', self eol.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SwazooCompilerTest
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!SwazooCompilerTest methodsFor:'running'!

testEvaluate
	self assert: (SwazooCompiler evaluate: '1 + 2 * 3') = 9
!

testEvaluateReceiver
	self assert: (SwazooCompiler evaluate: 'self + 2 * 3' receiver: 1) = 9
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPAllowField
	instanceVariableNames:'methods'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPAllowField class methodsFor:'accessing'!

fieldName
	^'Allow'
! !

!HTTPAllowField methodsFor:'accessing'!

methods
	methods isNil ifTrue: [methods := OrderedCollection new].
	^methods
! !

!HTTPAllowField methodsFor:'printing'!

valuesAsStringOn: targetStream
	self methods isEmpty
		ifFalse:
			[targetStream nextPutAll: self methods first.
			2 to: self methods size
				do:
					[:methodIndex |
					targetStream
						nextPut: $,;
						nextPutAll: (self methods at: methodIndex)]].
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebLiveImage
	instanceVariableNames:'gif refreshed width height painter'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Imaging'
!

WebLiveImage comment:'WebLiveImage is used for live, dynamic GIF image construction.

Instance Variables:
	gif                     <ByteArray>     content of image in GIF format
	refreshed       <Timestamp>     timestamp of last gif creation, used for caching algoritms

'
!

!WebLiveImage class methodsFor:'accessing'!

cache
	Cache isNil ifTrue: [self initCache].
	^Cache
!

initCache
	Cache := Set new.
! !

!WebLiveImage methodsFor:'accessing'!

height
	"height of image, default is 300 pixels"
	height isNil ifTrue: [self height: 300].
	^height
!

height: anInteger
	height := anInteger.
!

painter
	"painter is an object, which actually paints an image. It must respond to message displayOn: anGraphicsContect. By default, painter is self and paints some hello message. Subclasses should override displayOn: appropriately"

	painter isNil ifTrue: [self painter: self].
	^painter
!

painter: anObject
	painter := anObject.
!

width
	"width of image, default is 500 pixels"
	width isNil ifTrue: [self width: 500].
	^width
!

width: anInteger
	width := anInteger.
! !

!WebLiveImage methodsFor:'drawing'!

displayOn: aGraphicsContext

	"default painting - some hello message. Subclasses should override for some more paintings"

	| composite text |
	composite := CompositePart new.
	text := 'This is a live GIF image' asText.
	text emphasizeAllWith: (Array with: #bold with: #color -> ColorValue blue).
	text := text asComposedText.
	composite add: text at: 100 @ (height/2).
	composite displayOn: aGraphicsContext.
!

drawImage
	"it paints a drawing with a painter and convert it to GIF"
	| pixmap graphicsContext image stream |
	pixmap := Pixmap extent: self width @ self height.
	graphicsContext := pixmap graphicsContext.
	self painter displayOn: graphicsContext.
	image := pixmap asImage.
	stream := GifImageStream on: ByteArray new writeStream.
	[stream nextPutImage: image. self gif: stream contents]
		valueNowOrOnUnwindDo: [stream close].
! !

!WebLiveImage methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	"refresh gif if nesessary and put it into a HTML stream"
	Processor activeProcess priority: (Processor activeProcess priority - 3).
	self refreshNeeded ifTrue:
		[self drawImage.
		self addToCache].
	aStream nextPutAll: self gif asByteString.
	Processor activeProcess priority: (Processor activeProcess priority + 3).
	self lastUsed: Timestamp now.

"       aSession server urlResolver removeObject: self "
!

printWebPageFor: aWebSession
	^self
! !

!WebLiveImage methodsFor:'private'!

contentType
	"MIME type for our image"
	^'image/gif'
!

gif
	"returns a representation of a image in GIF format"
	^gif
!

gif: aByteArray

	"also set a refreshed timestamp"

	gif := aByteArray.
	self refreshed: Timestamp now.
!

isComposite
	^false
!

lastUsed
	"timestamp of last usage. Used for caching algorithms. Set at HTML generation"

	lastUsed isNil ifTrue: [self lastUsed: Timestamp now].
	^lastUsed
!

lastUsed: aTimestamp
	"timestamp of last usage. Used for caching algorithms"

	lastUsed := aTimestamp
!

preferedUrl
	| random |
	random := (Random new next * 10000) truncated printString.
	^'/image/live-', random, '.gif'
!

refreshed
	"timestamp of last gif creation. Used for caching algorithms. Set,when calling gif: method"

	refreshed isNil ifTrue: [self refreshed: Timestamp now].
	^refreshed
!

refreshed: aTimestamp
	"timestamp of last gif creation. Used for caching algorithms"

	refreshed := aTimestamp
!

resolver
	^resolver
!

resolver: anObject
	resolver := anObject
! !

!WebLiveImage methodsFor:'private-caching'!

addToCache
	self makeRoomInCache.
	self class cache add: self.
!

cacheHysteresis
	"when removing from cache, make room for that number of entries"
	^10
!

makeRoomInCache
	"if cache is full, remove least used images"
	| cached  toRemove |
	self class cache size < self maxCacheSize ifTrue: [^self].
	cached := (SortedCollection
		withAll: self class cache
		sortBlock: [:a :b | a lastUsed < b lastUsed]) asOrderedCollection.
	self cacheHysteresis timesRepeat:
		[toRemove := cached first.
		toRemove removeFromCache.
		cached removeFirst]
!

maxCacheSize
	^50
!

removeFromCache
	self class cache remove: self ifAbsent: [].
	self removeFromURLResolver.
	self gif: nil.
!

removeFromURLResolver
	self resolver notNil
		ifTrue: [self resolver removeObject: self]
! !

!WebLiveImage methodsFor:'testing'!

isWebElement
	^false
!

isWebPage
	^true
!

refreshNeeded
	^self gif isNil
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#HTTPRequestTest
	instanceVariableNames:'request'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!HTTPRequestTest methodsFor:'private'!

basicGet
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.1';
		nextPutLine: 'Host: foo.com';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)
!

basicGetHTTP10
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.0';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)
!

basicGetHTTP10Keepalive
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.0';
		nextPutLine: 'Connection: Keep-Alive';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)
!

basicHead
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'HEAD / HTTP/1.1';
		nextPutLine: 'Host: foo.com';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)
!

crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf
!

fullGet
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET /aaa/bbb/ccc.html?foo=bar&baz=quux HTTP/1.1';
		nextPutLine: 'Connection: Keep-Alive';
		nextPutLine: 'User-Agent: Mozilla/4.72 [en] (X11; I; Linux 2.3.51 i686)';
		nextPutLine: 'Host: foo.com:8888';
		nextPutLine: 'Referer: http://www.bar.com/takeMeThere.html';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)
!

portedGet
	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET / HTTP/1.1';
		nextPutLine: 'Host: foo.com:8888';
		crlf.
	^HTTPRequest readFrom: (ReadStream on: requestStream contents)
! !

!HTTPRequestTest methodsFor:'testing'!

test10ConnectionClose
	request := self basicGetHTTP10.
	self assert: request wantsConnectionClose
!

test10KeepAliveConnectionClose
	request := self basicGetHTTP10Keepalive.
	self deny: request wantsConnectionClose
!

testBasicGet
	request := self basicGet.
	self assert: request isGet.
	self deny: request isHead.
	self deny: request isPost.
	self deny: request isPut
!

testBasicGetHost
	request := self basicGet.
	self assert: request host = 'foo.com'
!

testBasicGetPort
	request := self basicGet.
	self assert: request port = 80
!

testBasicHead
	request := self basicHead.
	self assert: request isHead.
	self deny: request isGet.
	self deny: request isPost.
	self deny: request isPut
!

testConnection
	request := self fullGet.
	self assert: request connection = 'Keep-Alive'
!

testHeaderAtIfPresent
	request := self basicGet.
	self assert: (request headers 
				fieldOfClass: HTTPIfRangeField
				ifPresent: [:header | header == (request headers fieldOfClass: HTTPIfRangeField)]
				ifAbsent: [true]).
	self assert: (request headers 
				fieldOfClass: HTTPHostField
				ifPresent: [:header | header == (request headers fieldOfClass: HTTPHostField)]
				ifAbsent: [false])
!

testNo11ConnectionClose
	request := self basicGet.
	self deny: request wantsConnectionClose
!

testNoEqualsQueries
	"The last assert here used to check that 'request queryAt: 'WSDL'' is nil, but a test for an empty string is more consistent with query argument formats."

	| requestStream |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'GET /test/typed.asmx?WSDL HTTP/1.1';
		nextPutLine: 'Host: foo.com:8888';
		crlf.
	request := HTTPRequest readFrom: (ReadStream on: requestStream contents).
	self assert: (request includesQuery: 'WSDL').
	self assert: (request queryAt: 'WSDL') isEmpty
!

testPortedGetPort
	request := self portedGet.
	self assert: request port = 8888
!

testPostRawEntity
	| requestStream post |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'POST /foobar HTTP/1.0';
		nextPutLine: 'Host: foo.com';
		nextPutLine: 'Content-Type: text/plain';
		nextPutLine: 'Content-Length: 12';
		crlf;
		nextPutLine: 'Hello, World'.
	post := HTTPRequest 
				readFrom: (SwazooTestStream on: requestStream contents).
	self assert: post postData isEmpty.
	self assert: post entityBody = 'Hello, World'
!

testPostUrlEncodedData
	| requestStream post |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'POST / HTTP/1.1';
		nextPutLine: 'Host: foo.com';
		nextPutLine: 'Content-Type: application/x-www-form-urlencoded';
		nextPutLine: 'Content-Length: 31';
		crlf;
		nextPutLine: 'address=+fs&product=&quantity=1'.
	post := HTTPRequest 
				readFrom: (SwazooTestStream on: requestStream contents).
	self assert: (post postDataAt: 'address') value = ' fs'.
	self assert: (post postDataAt: 'product') value = ''.
	self assert: (post postDataAt: 'quantity') value = '1'
!

testReferer
	request := self fullGet.
	self 
		assert: request referer asString = 'http://www.bar.com/takeMeThere.html'
!

testUserAgent
	request := self fullGet.
	self 
		assert: request userAgent = 'Mozilla/4.72 [en] (X11; I; Linux 2.3.51 i686)'
! !

!HTTPRequestTest methodsFor:'testing-bad requests'!

test120RequestWithCRButNoLF
	| requestStream result |
	requestStream := WriteStream on: String new.
	requestStream
		nextPutAll: 'GET / HTTP/1.1';
		cr.
	result := SpExceptionContext 
				for: [HTTPRequest readFrom: (ReadStream on: requestStream contents)]
				on: SpError
				do: [:ex | ex].
	self assert: result class == SwazooHTTPParseError.
	^self
!

test121MissingContentType
	| requestStream result |
	requestStream := HTTPWriteStream onStream: (WriteStream on: String new).
	requestStream
		nextPutLine: 'POST /foobar HTTP/1.0';
		nextPutLine: 'Host: foo.com';
"	      nextPutLine: 'Content-Type: text/plain'. <---- this is missing!! - and should be for this test"
		nextPutLine: 'Content-Length: 12';
		crlf;
		nextPutLine: 'Hello, World'.
	result := SpExceptionContext 
				for: [HTTPRequest readFrom: (SwazooTestStream on: requestStream contents)]
				on: SpError
				do: [:ex | ex].
	self assert: result class == SwazooHTTPPostError.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SwazooCacheControl
	instanceVariableNames:'request cacheTarget etag lastModified'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Resources'
!

!SwazooCacheControl methodsFor:'accessing'!

cacheTarget
	^cacheTarget
!

etag
	etag isNil ifTrue: [etag := self generateETag].
	^etag
!

etag: aString
	etag := aString
!

request: aHTTPGet cacheTarget: anObject
	request := aHTTPGet.
	cacheTarget := anObject
! !

!SwazooCacheControl methodsFor:'operations'!

addNotModifedHeaders: aResponse
	"RFC2616 10.3.5
	If the conditional GET used a strong cache validator (see section 13.3.3), the response SHOULD NOT include other entity-headers. ... this prevents inconsistencies between cached entity-bodies and updated headers. "

	self isRequestStrongValidator
		ifTrue: [aResponse headers addField: (HTTPETagField new entityTag: self etag)]
		ifFalse: [self basicAddResponseHeaders: aResponse].
	^aResponse
!

addResponseHeaders: aResponse
	"Add response headers to the response.
	We MUST differentiate between 200/302 responses"

	^aResponse isNotModified
		ifTrue: [self addNotModifedHeaders: aResponse]
		ifFalse: [self basicAddResponseHeaders: aResponse]
!

basicAddResponseHeaders: aResponse
	"RFC 2616 13.3.4
	HTTP/1.1 origin servers:
	- SHOULD send an entity tag validator unless it is not feasible to generate one.
		- SHOULD send a Last-Modified value "

	aResponse headers addField: (HTTPETagField new entityTag: self etag).
	aResponse headers addField: (HTTPLastModifiedField new timestamp: self lastModified).
	^aResponse
!

generateETag
	^self cacheTarget etag
!

generateLastModified
	^self cacheTarget lastModified
! !

!SwazooCacheControl methodsFor:'testing'!

isIfModifiedSince
	"Answers true if either
		- the request does not included the header
		-or there is not a match"

	| ifModifiedSince |
	ifModifiedSince := request headers fieldOfClass: HTTPIfModifiedSinceField
				ifNone: [nil].
	^ifModifiedSince isNil or: [self lastModified > ifModifiedSince date]
!

isIfNoneMatch
	"Answers true if either
		- the request does not included the header
		-or there is not a match"

	| field |
	field := request headers fieldOfClass: HTTPIfNoneMatchField ifNone: [nil].
	^field isNil or: [(field entityTags includes: self etag) not]
!

isNotModified
	"Compare the cacheTarget with the request headers and answer if the client's version is not modified.
	Takes into account http version, and uses best practices defined by HTTP spec"

	^self isIfNoneMatch not or: [self isIfModifiedSince not]
!

isRequestStrongValidator
	| field |
	field := request headers fieldOfClass: HTTPIfNoneMatchField ifNone: [nil].
	^field notNil and: [field entityTags isEmpty not]
!

lastModified
	lastModified isNil ifTrue: [lastModified := self generateLastModified].
	^lastModified
!

lastModified: aRFC1123TimeStampString
	lastModified := aRFC1123TimeStampString
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPMatchField
	instanceVariableNames:'entityTags'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPMatchField methodsFor:'accessing'!

entityTags
	^self matchesAnyCurrentEntity
		ifTrue: [nil]
		ifFalse:
			[entityTags isNil ifTrue: [entityTags := OrderedCollection new].
			entityTags]
! !

!HTTPMatchField methodsFor:'printing'!

valuesAsStringOn: targetStream
	self write: self entityTags first asQuotedStringTo: targetStream.
	2 to: self entityTags size
		do:
			[:tagIndex |
			targetStream nextPut: $,.
			self write: (self entityTags at: tagIndex) asQuotedStringTo: targetStream].
	^self
!

write: aString asQuotedStringTo: targetStream
	"^self
See RFC 2616 2.2"

	targetStream nextPut: $".
	aString do:
			[:character |
			character == $"
				ifTrue: [targetStream nextPutAll: '\"']
				ifFalse: [targetStream nextPut: character]].
	targetStream nextPut: $".
	^self
! !

!HTTPMatchField methodsFor:'private'!

parseValueFrom: aString
	aString = '*'
		ifTrue: [entityTags := aString]
		ifFalse:
			[| sourceStream |
			entityTags := OrderedCollection new.
			sourceStream := ReadStream on: aString.
			[sourceStream atEnd] whileFalse:
					[| entityTag |
					sourceStream upTo: $".
					entityTag := sourceStream upTo: $".
					entityTags add: entityTag.
					sourceStream upTo: $,]].
	^self
! !

!HTTPMatchField methodsFor:'services'!

addEntityTag: aString
	self entityTags add: aString.
	^self
!

combineWith: aHeaderField
	"^self
I add the entity tags of aHeaderField to my own collection of entity tags."

	self entityTags addAll: aHeaderField entityTags.
	^self
! !

!HTTPMatchField methodsFor:'testing'!

isConditional
	^true
!

matchesAnyCurrentEntity
	^entityTags = '*'
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SpDate
	instanceVariableNames:'underlyingDate'
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Times'
!

!SpDate class methodsFor:'instance creation'!

fromDays: anInteger
	^self new onDate: (Date fromDays: anInteger)
!

fromISO8610Stream: aStream
	| date |
	date := SpExceptionContext
		for: [self parseDateFromISO8601Stream: aStream]
		on: SpError
		do: [:ex | nil].
	^date isNil ifTrue: [nil] ifFalse: [self onDate: date]
!

fromISO8610String: aString
	^aString size == 10
		ifFalse: [nil]
		ifTrue: [self fromISO8610Stream: aString readStream]
!

newDay: day month: month year: year
	^self new onDate: (Date newDay: day month: month year: year) 
!

newDay: day monthNumber: month year: year
	^self new onDate: (Date newDay: day month: month year: year) 
!

onDate: aDate
	^self new onDate: aDate
!

today
	^self onDate: Date today
! !

!SpDate class methodsFor:'private'!

integerOfLength: aLength FromString: aString
	"^an Integer or nil
	I parse an integer from aString, if I have problems I return nil.  I make sure
	the string form of the integer is exactly aLength characters long."
	"SpDate integerOfLength: 4 FromString: '2004'"
	^(aString size == aLength and:
		[(aString asOrderedCollection select: [:aDigit | aDigit isDigit not]) isEmpty])
			ifFalse: [nil]
			ifTrue: [aString asNumber]
!

parseDateFromISO8601Stream: sourceStream
	"^a Date or nil
	I parse an ISO 8601 date from sourceStream.  If there are any parsing
	problems, I return nil."
	| yyyy mm dd |
	yyyy := self integerOfLength: 4 FromString: (sourceStream upTo: $-).
	mm := self integerOfLength: 2 FromString: (sourceStream upTo: $-).
	dd := self integerOfLength: 2 FromString: (sourceStream next: 2).
	(yyyy isNil or: [mm isNil or: [dd isNil]]) ifTrue: [^nil].
	^SpExceptionContext
		for: [Date newDay: dd month: mm year: yyyy]
		on: SpError
		do: [:ex | nil]
! !

!SpDate methodsFor:'*Aida'!

+ aNumber
	^self addDays: aNumber
!

- aNumber
	"subtract number of days from a date."
	^self subtractDays: aNumber
!

monthAndDayString
	"with leading zeros, example: 05-16 for 16may"
	^(self monthIndex < 10 ifTrue: ['0'] ifFalse: ['']), self monthIndex printString, '-',
		(self dayOfMonth < 10 ifTrue: ['0'] ifFalse: ['']), self dayOfMonth printString

"SpDate today monthAndDayString"
!

printISOString
	^self year printString,
		(self monthIndex < 10 ifTrue: ['0'] ifFalse: ['']), self monthIndex printString,
		(self dayOfMonth < 10 ifTrue: ['0'] ifFalse: ['']), self dayOfMonth printString

"Date today printISOString   "
!

shortPrintSloString
	^self underlyingDate dayOfMonth printString, '.',
		self underlyingDate monthIndex printString, '.', self year printString.

"SpDate today shortPrintSloString"
!

shorterPrintSloString
	"year in two digits only"
	| yeart |
	yeart := (self year \\ 100) printString. yeart size = 1 ifTrue: [yeart := '0', yeart].
	^self dayOfMonth printString, '.', self monthIndex printString, '.', yeart.

"Date today shorterPrintSloString"
! !

!SpDate methodsFor:'accessing'!

day
	^self underlyingDate day
!

daysInMonth
	^self underlyingDate daysInMonth
!

monthIndex
	^self underlyingDate monthIndex
!

weekdayIndex
	"Sunday=1, ... , Saturday=7"
	^self underlyingDate weekdayIndex
!

year
	^self underlyingDate year
! !

!SpDate methodsFor:'comparing'!

< anotherSpDate
	"^a Boolean
	Answer true if anotherSpDate is less (i.e. earlier) than me."
	^self underlyingDate < anotherSpDate underlyingDate
!

= anotherOSkDate
	"^a Boolean

	Answer true if anotherOSkDate is equivalent to me."
	^self underlyingDate = anotherOSkDate underlyingDate
!

> anotherOSkDate
	"^a Boolean
	Answer true if anotherOSkDate is greater (i.e. later) than me."
	^self underlyingDate > anotherOSkDate underlyingDate
!

hash
	"^an Object"
	^self underlyingDate hash
! !

!SpDate methodsFor:'converting'!

asDays
	"^an Integer
	I return the integer number of days between January 1, 1901 and
	the date I represent. "
	^self underlyingDate asSeconds / (3600*24)
! !

!SpDate methodsFor:'initialize-release'!

onDate: aDate
	underlyingDate := aDate.
	^self
! !

!SpDate methodsFor:'printing'!

asISO8610String
	|targetStream|
	targetStream := WriteStream on: String new.
	self asISO8610StringOn: targetStream.
	^targetStream contents
!

asISO8610StringOn: aStream
	aStream
		nextPutAll: self underlyingDate year printString;
		nextPut: $-.
	self underlyingDate monthIndex < 10 ifTrue: [aStream nextPut: $0].
	aStream
		nextPutAll: self underlyingDate monthIndex printString;
		nextPut: $-.
	self underlyingDate dayOfMonth < 10 ifTrue: [aStream nextPut: $0].
	aStream nextPutAll: self underlyingDate dayOfMonth printString.
	^self
!

printOn: aStream
	self underlyingDate printOn: aStream
! !

!SpDate methodsFor:'private'!

underlyingDate
	^underlyingDate
! !

!SpDate methodsFor:'services'!

addDays: anInteger
	"^a SpDate
	I don't change the date I represent.  Rather, I create a new date which represents
	my date offset by anInteger days."
	^SpDate fromDays: self asDays + anInteger
!

addYears: anInteger
	"^an OSkDate
	I don't change the date I represent.  Rather, I create a new date which represents my
	date offset by anInteger years."
	^SpDate onDate:
		(Date newDay: self underlyingDate dayOfMonth
			month: self underlyingDate monthIndex
			year: self underlyingDate year + anInteger)
!

subtractDays: anInteger
	"^a SpDate
	I don't change the date I represent.  Rather, I create a new date which represents
	my date offset by anInteger days."
	^SpDate fromDays: self asDays - anInteger
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#MIMEMap
	instanceVariableNames:'mimeTypes fileExtensions'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!MIMEMap class methodsFor:'instance creation'!

new
	^super new initialize
! !

!MIMEMap class methodsFor:'accessing'!

apacheMimeTypes
	"from /etc/httpd/mime.types after Apache v1.3 is installed"

^'application/EDI-Consent
application/EDI-X12
application/EDIFACT
application/activemessage
application/andrew-inset        ez
application/applefile
application/atomicmail
application/cals-1840
application/commonground
application/cybercash
application/cu-seeme            csm cu
application/dca-rft
application/dec-dx
application/eshop
application/excel               xls
application/ghostview
application/hyperstudio
application/iges
application/mac-binhex40        hqx
application/mac-compactpro      cpt
application/macwriteii
application/marc
application/mathematica
application/msword              doc dot wrd
application/news-message-id
application/news-transmission
application/octet-stream        bin dms lha lzh exe class
application/oda                 oda
application/pdf                 pdf
application/pgp                 pgp
application/pgp-encrypted
application/pgp-keys
application/pgp-signature       pgp
application/postscript          ai eps ps
application/powerpoint          ppt
application/remote-printing
application/rtf                 rtf
application/slate
application/wita
application/wordperfect5.1      wp5
application/x-123               wk
application/x-Wingz             wz
application/x-bcpio             bcpio
application/x-bzip2             bz2
application/x-cdlink            vcd
application/x-chess-pgn         pgn
application/x-compress          z Z
application/x-cpio              cpio
application/x-csh               csh
application/x-debian-package    deb
application/x-director          dcr dir dxr
application/x-dvi               dvi
application/x-gtar              gtar tgz
application/x-gunzip            gz
application/x-gzip              gz
application/x-hdf               hdf
application/x-httpd-php         phtml pht php
application/x-javascript        js
application/x-kword             kwd kwt
application/x-kspread           ksp
application/x-kpresenter        kpr kpt
application/x-kchart            chrt
application/x-koan              skp skd skt skm
application/x-latex             latex
application/x-maker             frm maker frame fm fb book fbdoc
application/x-mif               mif
application/x-msdos-program     com exe bat
application/x-netcdf            nc cdf
application/x-ns-proxy-autoconfig       pac
application/x-perl              pl pm
application/x-rad               rad
application/x-rpm               rpm spm
application/x-sh                sh
application/x-shar              shar
application/x-shockwave-flash   swf
application/x-stuffit           sit
application/x-sv4cpio           sv4cpio
application/x-sv4crc            sv4crc
application/x-tar               tar
application/x-tcl               tcl
application/x-tex               tex
application/x-texinfo           texinfo texi
application/x-troff             t tr roff
application/x-troff-man         man
application/x-troff-me          me
application/x-troff-ms          ms
application/x-ustar             ustar
application/x-wais-source       src
application/zip                 zip
audio/basic                     au snd
audio/midi                      mid midi kar
audio/mpeg                      mpga mp2 mp3
audio/x-aiff                    aif aifc aiff
audio/x-realaudio               ra
audio/x-wav                     wav
chemical/x-pdb                  pdb xyz
image/gif                       gif
image/ief                       ief
image/jpeg                      jpeg jpg jpe
image/png                       png
image/tiff                      tiff tif
image/x-cmu-raster              ras
image/x-portable-anymap         pnm
image/x-portable-bitmap         pbm
image/x-portable-graymap        pgm
image/x-portable-pixmap         ppm
image/x-rgb                     rgb
image/x-xbitmap                 xbm
image/x-xpixmap                 xpm
image/x-xwindowdump             xwd
message/external-body
message/news
message/partial
message/rfc822
model/iges                      igs iges
model/mesh                      msh mesh silo
model/vrml                      wrl vrml
multipart/alternative
multipart/appledouble
multipart/digest
multipart/mixed
multipart/parallel
text/css                        css
text/html                       html htm
text/plain                      asc txt c cc h hh cpp hpp
text/richtext                   rtx
text/rtf                        rtf
text/sgml                       sgml sgm
text/tab-separated-values       tsv
text/x-setext                   etx
text/x-vCalendar                vcs
text/x-vCard                    vcf
text/xml                        xml dtd
video/dl                        dl
video/fli                       fli
video/gl                        gl
video/mpeg                      mp2 mpe mpeg mpg
video/quicktime                 qt mov
video/x-msvideo                 avi
video/x-sgi-movie               movie
x-conference/x-cooltalk         ice
x-world/x-vrml                  wrl vrml
audio/x-pn-realaudio rmm ram
audio/vnd.rn-realaudio ra
application/smil smi smil
text/vnd.rn-realtext rt
video/vnd.rn-realvideo rv
image/vnd.rn-realflash rf swf
application/x-shockwave-flash2-preview rf swf
application/sdp sdp
application/x-sdp sdp
application/vnd.rn-realmedia rm
image/vnd.rn-realpix rp
'
!

arrayFromApacheMimeTypes
	| collection stream |
	collection:= OrderedCollection new.
	stream := ReadStream on: self apacheMimeTypes.
	[stream atEnd] whileFalse:
		[ | col line word |
		col := OrderedCollection new.
		line := (stream upTo: Character cr) readStream.
		[line atEnd] whileFalse: [word := line upToSeparator. word notEmpty ifTrue: [col add: word] ].
		collection add: col].
	^collection

"MIMEMap arrayFromApacheMimeTypes"
!

default
	^AIDASite default mimeMap
! !

!MIMEMap methodsFor:'accessing'!

extensionForType: aString
	"only first one if more than one ext exist for this mime type"
	| exts string |
	string := aString = 'image/pjpeg' ifTrue: ['image/jpeg'] ifFalse: [aString]. "wierd IE problem"
	string := aString = 'image/x-png' ifTrue: ['image/png'] ifFalse: [string]. "wierd IE problem"
	exts := self mimeTypes at: string asLowercase ifAbsent: [#()].
	^exts notEmpty ifTrue: [exts first] ifFalse: [nil]

"MIMEMap new extensionForType: 'image/jpeg'"
!

extensionsForType: aString
	^self mimeTypes at: aString asLowercase ifAbsent: [#()].

"MIMEMap new extensionsForType: 'image/jpeg'"
!

iconForType: aString
	"a name of icon to represent this content type, from WebStyle imgs-filetype icons"
	aString isNil ifTrue: [^#unknownSmallPng].
	'text/plain' = aString ifTrue: [^#txtSmallPng].
	'text/xml' = aString ifTrue: [^#xmlSmallPng].
	'application/pdf' = aString ifTrue: [^#pdfSmallPng].
	'application/msword' = aString ifTrue: [^#wordSmallPng].
	'application/rtf' = aString ifTrue: [^#wordSmallPng].
	'application/excel' = aString ifTrue: [^#excelSmallPng].
	'application/powerpoint' = aString ifTrue: [^#powerpointSmallPng].
	'application/zip' = aString ifTrue: [^#zipSmallPng].
	('image/*' match: aString) ifTrue: [^#imageSmallPng].
	('audio/*' match: aString) ifTrue: [^#multimediaSmallPng].
	('video/*' match: aString) ifTrue: [^#multimediaSmallPng].
	^#unknownSmallPng

"MIMEMap new iconForType: 'image/jpeg'"
!

typeForExtension: aString
	| ext |
	ext := aString asLowercase copyWithout: $. .
	^self fileExtensions at: ext ifAbsent: [nil].

"MIMEMap new typeForExtension: 'jpg'"
! !

!MIMEMap methodsFor:'adding-removing'!

addType: aTypeString andExtension: anExtensionString
	| exts |
	exts := self mimeTypes at: aTypeString ifAbsentPut: [OrderedCollection new].
	(exts includes: anExtensionString) ifFalse: [exts add: anExtensionString].
	self fileExtensions at: anExtensionString ifAbsentPut: [aTypeString].
!

removeType: aTypeString andExtension: anExtensionString
	| exts |
	exts := self mimeTypes at: aTypeString ifAbsent: [OrderedCollection new].
	(exts includes: anExtensionString) ifTrue: [exts remove: anExtensionString].
	exts isEmpty ifTrue: [self mimeTypes removeKey: aTypeString ifAbsent: [] ].
	self fileExtensions removeKey: anExtensionString ifAbsent: [].
! !

!MIMEMap methodsFor:'initialize-release'!

initFileExtensions
	fileExtensions := Dictionary new.
!

initFromApacheMimeTypes
	"see class method. Only mime types, which have some extension defined, are set!! "
	| collection |
	collection := self class arrayFromApacheMimeTypes.
	collection do: [:col |
		2 to: col size do: [:inx | self addType: col first andExtension: (col at: inx)] ]

"MIMEMap new"
!

initMimeTypes
	mimeTypes := Dictionary new.
!

initialize
	self initFromApacheMimeTypes
! !

!MIMEMap methodsFor:'private'!

fileExtensions
	fileExtensions isNil ifTrue: [self initFileExtensions].
	^fileExtensions
!

mimeTypes
	mimeTypes isNil ifTrue: [self initMimeTypes].
	^mimeTypes
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebAdmin
	instanceVariableNames:'host ip port'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Admin'
!

!WebAdmin methodsFor:'accessing'!

host
	^host
!

host: aString
	host := aString
!

ip
	^ip
!

ip: aString
	ip := aString
!

port
	^port
!

port: aNumber
	port := aNumber
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebLiveImage subclass:#WebGraph
	instanceVariableNames:'data margin title graphics'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Imaging'
!

!WebGraph methodsFor:'accessing'!

data
	data isNil ifTrue: [data := #(120 200 500 230 90 80 200 100 40)].
	^data
!

data: anArray
	data := anArray
!

getMax
	| b max1 maxim maxAt |
	max1 := 0.
	b := self data size.
	1 to: b
		do: [:x | (data at: x) > max1 ifTrue:
					[max1 := data at: x.
					maxAt := x]].
	maxim := max1.
	^Array with: maxim with: maxAt.
!

graphics
	graphics isNil ifTrue: [self initGraphics].
	^graphics
!

margin
	margin isNil ifTrue: [self margin: (self marginFor: (self getMax at: 1))].
	^margin
!

margin: aNumber

	margin := aNumber.
!

title
	title isNil ifTrue: [title := 'Here comes the title'].
	^title
!

title: aString
	title:= aString
! !

!WebGraph methodsFor:'constants'!

distance
	^(self xRightPosition - self xLeftPosition) // self data size
!

height
	^300
!

width
	^500
!

xLeftPosition
	^50
!

xRightPosition
	^self width - 20
!

yBottomPosition
	^self height - 30
!

yTopPosition
	^40
! !

!WebGraph methodsFor:'drawing'!

displayOn: aGraphicsContext
	| rectangle |
	self initGraphics.
	rectangle := Rectangle origin: 2 @ 2 extent: (self width - 4) @ (self height - 4).
	self graphics add: rectangle asStroker.
	self drawAxle.
	self drawYPoints.
	self graph.
	self drawTitle.
	self graphics displayOn: aGraphicsContext.
!

drawAxle
	| points yAxis xAxis z c a grayLine blackLine b |
	z := self xLeftPosition.
	c := self yBottomPosition.
	b := self yTopPosition.
	a := self xRightPosition.
	points := List new: 2.
	points add: z @ (self yTopPosition - 10);
		add: z @ (c + 5).
	yAxis := Spline controlPoints: points.
	points := List new: 2.
	points add: (z - 5) @ c;
		add: a @ c.
	xAxis := Spline controlPoints: points.
	graphics add: yAxis asStroker;
		add: xAxis asStroker.
	b to: c - ((c - b) // 5)
		by: (c - b) // 5
		do:
			[:x |
			points := List new: 2.
			points add: (z + 1) @ x;
				add: a @ x.
			grayLine := Spline controlPoints: points.
			graphics add: ((GraphicsAttributesWrapper on: grayLine asStroker)
						attributes: (GraphicsAttributes new paint: ColorValue veryLightGray)).
			points := List new: 2.
			points add: (z - 5) @ x;
				add: z @ x.
			blackLine := Spline controlPoints: points.
			graphics add: blackLine asStroker]
!

drawGraphWindow
	"WebGraph new drawGraphWindow"
	| win rectangle |
	win := ScheduledWindow new.
	win label: 'Graf obiskov na spletno stran'.
	win minimumSize: self width @ self height.
	graphics := CompositePart new.
	rectangle := Rectangle origin: 2 @ 2 extent: (self width - 4) @ (self height - 4).
	graphics add: rectangle asStroker.
	self drawAxle.
	self drawYPoints.
	self graph.
	self drawTitle.
	win component: (BoundedWrapper on: graphics).
	win open
!

drawTitle
	| aTitle |
	aTitle:= (self title asComposedText compositionWidth: (self width-40)) centered.
	self graphics add: aTitle at: 20@10
!

drawYPoints
	| string c stepOne step mark b |
	c := self yBottomPosition.
	b := self yTopPosition.
	stepOne := 0.
	step :=self stepFor:(self getMax at: 1).
	c to: b
		by: (0-((c - b) // 5))
		do:
			[:x |
			string := stepOne printString.
			mark := (string asText emphasizeAllWith: #small) asComposedText.
			mark compositionWidth: 30.
			mark rightFlush.
			graphics add: mark at: (self xLeftPosition - 40) @ ( x -13).
			stepOne := stepOne + step]
!

graph
	"WebGraph new drawGraph"

	| aData aRectangle z c |
	z := self xLeftPosition + 1.
	c := self yBottomPosition.
	1 to: self data size
		do:
			[:x |
			aData := data at: x.
			aRectangle := Rectangle left: z
						right: z + self distance - 2
						top: c - (self heightInPixelsFor: aData)
						bottom: c.
			z := z + self distance.
			graphics add: ((GraphicsAttributesWrapper on: aRectangle asFiller)
						attributes: (GraphicsAttributes new paint: ColorValue blue))]
! !

!WebGraph methodsFor:'initialize-release'!

initGraphics
	graphics := CompositePart new
! !

!WebGraph methodsFor:'transformations'!

heightInPixelsFor:  aNumber

	^(((self yBottomPosition - self yTopPosition) / self margin) * aNumber) truncated

"
|graf|
graf := WebGraf new.
graf data: #(10 20 30 40 50).
graf heightInPixelsFor: 15.
"
!

marginFor:  aNumber

	| margin |
	aNumber < 10 ifTrue: [^10].
	margin := 10 ** ((aNumber log: 10) truncated + 1).
	margin = (aNumber * 10) ifTrue: [^margin / 10].
	aNumber > (margin / 2) ifTrue: [^margin].
	aNumber > (margin / 4) ifTrue: [^margin / 2].
	^margin / 4.

"WebGraf new marginFor: 1001"
!

stepFor:  aNumber

	^(self marginFor: aNumber) / 5

"WebGraf new stepFor: 1001"
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Resource subclass:#CompositeResource
	instanceVariableNames:'children'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Core'
!

!CompositeResource methodsFor:'accessing'!

children
	children isNil ifTrue: [self initChildren].
	^children
!

currentUrl
	| string |
	string := super currentUrl.
	^string last = $/
		ifTrue: [string]
		ifFalse: [string , '/']
!

helpResolve: aResolution
	^aResolution resolveCompositeResource: self
!

printUrlOn: aWriteStream
	super printUrlOn: aWriteStream.
	self isRootPath ifFalse: [aWriteStream nextPut: $/]
! !

!CompositeResource methodsFor:'adding/removing'!

addResource: aResource
	self children add: aResource.
	aResource parent: self.
	aResource onResourceCreated.
	^aResource
!

addResources: anOrderedCollection
	anOrderedCollection do: [ :each |
		self addResource: each].
	^anOrderedCollection
!

removeResource: aResource
	self children remove: aResource ifAbsent: [nil]
! !

!CompositeResource methodsFor:'initialize-release'!

initChildren
	children := OrderedCollection new.
!

initialize
	super initialize.
	self initChildren
! !

!CompositeResource methodsFor:'testing'!

hasNoResources
	^self children isEmpty
!

includesResource: aResource
	^self children includes: aResource.
!

isRootPath
	^self uriPattern = '/'
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebStyle
	instanceVariableNames:'site resources searchButton'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

!WebStyle class methodsFor:'instance creation'!

newOnSite: anAIDASite

	^super new site: anAIDASite
! !

!WebStyle class methodsFor:'accessing'!

default
	^AIDASite default style
! !

!WebStyle methodsFor:'WEB-Applications'!

changeToSqueakArraysIn: aFileoutName
        "change method images to sqeak syntax, example: #(12 34 56) to  #(12 34 56)"
        "WebStyle new changeToSqueakArraysIn: 'WebStyle.st' "
        | in out chunk fstream |
        [in := (SpFilename named:aFileoutName) readStream.
        out := WriteStream on: String new.
        [in atEnd] whileFalse:
                [chunk := in upToAll: '#('.
                out nextPutAll: chunk. in atEnd not ifTrue: [out nextPutAll: '#(' . in next: 2 ].
                chunk := in upTo: $] .
                out nextPutAll: chunk. out nextPutAll: ')'].
        ] ensure: [in close].
        (SpFilename named: aFileoutName) delete.
        [fstream := (SpFilename named: aFileoutName) writeStream.
        fstream nextPutAll: out contents]
                ensure: [fstream close].
        ^out contents
! !

!WebStyle methodsFor:'accessing'!

app
	"try to find a first sender up in calling stack, who is  WebApplication"
	^self firstAppFromStack
!

observee

	^self app observee
!

session
	"try to find a first sender up in calling stack, who is AIDASite and find a session in
	its local variable stack"

	^self firstSessionFromStack
!

site
	^site
! !

!WebStyle methodsFor:'frame navigation'!

navBarAdminElement
	| element |
	self app user isAdmin ifFalse: [^WebElement new].
	element := (WebElement newClass: #navdiv)
		add: (self navHeader: ' ADMIN' bullet: #bulletManTranspWhiteGif);
		add: (WebList newUnordered
			addLinkTo: self site admin text: 'Login' view: 'login';
			addLinkTo: self site admin text: 'Logout'  view: 'logout';
			addSecureLinkTo: self site admin text: 'Sites' view: 'sites';
			addSecureLinkTo: self site admin text: 'Settings' view: 'settings';
			addSecureLinkTo: self site securityManager text: 'Security';
			addSecureLinkTo: self site admin text: 'Uptime' view: 'serverStatistics';
			addSecureLinkTo: self site statistics text: 'Statistics';
"                       addSecureLinkTo: self site admin text: 'Tests' view: #tests;"
			yourself);
		yourself.
	^element
!

navBarContactElement
	| element |
	element := (WebElement newClass: #navdiv)
		add: (self navLinkTo: 'mailto:info@eranova.si'
			header: 'info@eranova.si' bullet: #bulletLetterTranspWhiteGif);
		yourself.
	^element
!

navBarDemosIn: element
	element         add: ((WebElement newClass: #navdiv)
		add: (self navHeader: ' DEMOS' bullet: #bulletStarTranspWhiteGif);
		add: (WebList newUnordered
			addLinkTo: self site discussions text: 'Discussions';
			addLinkTo: self site demo       text: 'Image gallery' view: #imageGallery;
			addLinkTo: self site demo       text: 'Live image' view: #liveImage;
"                       addLinkTo: self site demo text: 'File upload' view: #fileUpload; "
			addLinkTo: self site demo text: 'Tabs' view: #tabs;
			addLinkTo: self site demo text: 'Grid, tabs, menus' view: #grid;
			addLinkTo: self site demo text: 'Javascript' view: #javascript;
			addLinkTo: self site demo text: 'Ajax' view: #ajax;
			addLinkTo: self site demo text: 'Rich Editor' view: #richEditor;
			addLinkTo: self site demo text: 'Calendar' view: #calendar;
			yourself);
		yourself)
!

navBarMainLinksElement
	| element |
	element         := (WebElement newClass: #navdiv)
		add: (self navHeader: ' AIDA LINKS' bullet: #bulletSquareDownTranspWhiteGif);
		add: (WebList newUnordered
			addLinkTo: 'http://www.aidaweb.si' text: 'Website';
			addLinkTo: 'http://www.aidaweb.si/tutorial.html' text: 'Tutorial';
			addLinkTo: 'http://www.aidaweb.si/documentation.html' text: 'Documentation';
			addLinkTo: 'http://www.aidaweb.si/screenshots.html' text: 'Screenshots';
			addLinkTo: 'http://www.aidaweb.si/development.html' text: 'Development';
			yourself);
		yourself.
	^element
!

navHeader: aString bullet: aSymbol
	^(WebText header: 3)
		addGif: aSymbol size: 13@13; addText: aString; yourself.
!

navHeader: aString bullet: aSymbol linkTo: anObject
	^(WebText header: 3)
		addGif: aSymbol size: 13@13; addLinkTo: anObject text: aString; yourself.
!

navHeader: aString bullet: aSymbol linkTo: anObject view: aView
	^(WebText header: 3)
		addGif: aSymbol size: 13@13; addLinkTo: anObject text: aString view: aView; yourself.
!

navHeader: aString bullet: aSymbol linkTo: anObject view: aView parameter: aParmString value: aValueString
	^(WebText header: 3)
		addGif: aSymbol size: 13@13; addLinkTo: anObject text: aString
		view: aView parameter: aParmString value: aValueString;
			yourself.
!

navLinkTo: anObject header: aString bullet: aSymbol
	| element |
	element := WebText header: 3.
	element
		addGif: aSymbol size: 13@13;
		addLinkTo: anObject text: ' ', aString.
	^element
!

navigationBarElement
	| element |
	element := WebElement newId: #navigation.
	element add: self navBarMainLinksElement.
	self navBarDemosIn: element.
	element add: self navBarAdminElement.
"       element add: self navBarSearchElement."
	element add: self navBarContactElement.
	^element
! !

!WebStyle methodsFor:'frame printing'!

contactElement

	| element |
	element := WebElement new.
	element
		addText: '<font face=helvetica size=-2>Send comments to: <br>';
		addText: '<b><a href="mailto:info@eranova.si">';
		addText: '<font face=helvetica size=-1>info@eranova.si</font></a></b></font>'.
	^element
!

copyrightElement
	| element |
	element := WebElement new.
	element
		addLinkTo: 'http://www.eranova.si/' text: '<font face=helvetica size=-1>(C) EraNova d.o.o</font>'.
	^element
!

defaultPageTitle
	^'First page'
!

headerBanner
	^WebElement newId: #banner
!

headerDashboard
	"login, font size selection, etc"
	^(WebElement newId: #dashboard)
		add: self headerLogin;
		add: ((WebElement newId: #switcher)
			addHelpLink; addNbSp;
			addGif: #textFontSizeGif size: 54@15;
			addLinkTo: '/' gif: #textSizeSmallGif title: 'Small font size' size: 16@15;
			addLinkTo: '/' gif: #textSizeMediumGif title: 'Medium font size' size: 16@15;
			addLinkTo: '/' gif: #textSizeLargeGif title: 'Large font size' size: 16@15;
			yourself);
"               add: (WebElement new style: '{flow: right}'; addGif: #cornerDashboardRightGif; yourself);"
		yourself
!

headerElement
	^(WebElement newId: #header)
		add: ((WebElement newId: #logo)
			addImage: '/img/eranovalogogif.gif' ); yourself
!

headerLogin
	| e name |
	e := WebElement new.
	name := self app user isGuest
		ifTrue: [self guestUserText]
		ifFalse: [self app user name, ' ', self app user surname].
	e addNbSp: 3; addGif: #keyGif; addTextBold: ' ', name.
	self app user isGuest
		ifTrue: [e addLinkTo: self site admin text: ' | ', self loginText view: 'login']
		ifFalse: [e addLinkTo: self site admin text: ' | ', self logoutText view: 'logout'].
	^e
!

htmlHeaderElements
	self app addMetaDescription: 'Demo of AIDA/Web Smalltalk Web Application server'.
	self app addMetaKeywords: 'Smalltalk, Web, Web Server, Web Applications, HTML'.
!

lastChangedElement
	| e |
	e := WebElement newId: #sitePageChanged. e table width: 1.
	e cell align: #center; addRulerSize: 1; addBreak.
	e cell addText: 'Zadnjic^ obnovljeno: '.
	self observee modifiedTimestamp notNil ifTrue:
		[e cell addTextBold: self app observee modifiedTimestamp asDate shortPrintSloString].
	^e
!

lastChangedText
	^'Updated: '
!

pageFrameWideNoNavigationWith: aWebElement title: aTitleString
	"set a web page just with header and wide element below"
	| element |
	self app clear;  title: aTitleString. self app htmlHeaderElements.
"       self app        add: self headerBanner. "
	element := (WebElement newId: #container)
		add: self headerElement;        add: self headerDashboard;
		add: ((WebElement newId: #contentWide)
			add: aWebElement; yourself);
		yourself.
	^self app add: element; yourself
!

pageFrameWideNoNavigationWith: aWebElement title: aTitleString printHeader: aHeaderElement
	"set a web page just with header and wide element below"
	| element containerId |
	self app clear;  title: aTitleString. self app htmlHeaderElements.
"       self app        add: self headerBanner. "
	containerId := aHeaderElement elements notEmpty ifTrue: [#containerPadded] ifFalse: [#container].
	element := (WebElement newId: containerId)
		add: self headerElement;        add: self headerDashboard;
		add: ((WebElement newId: #contentWide)
			add: aWebElement; yourself);
		yourself.
	^self app
		add: aHeaderElement; "print header"
		add: element; yourself
!

pageFrameWith: aWebElement title: aTitleString
	"set a web page with standard  page look (navigation bar, header) "
	^self pageFrameWith: aWebElement wide: WebElement new title: aTitleString
!

pageFrameWith: aWebElement wide: aWideElement title: aTitleString
	"set a web page with standard  page look (navigation bar, header) "
	"Wide element comes below content besides navigation and it have full page width"
	| element |
	self app clear;  title: aTitleString. self app htmlHeaderElements.
"       self app        add: self headerBanner. "
	element := (WebElement newId: #container)
		add: self headerElement;        add: self headerDashboard;
		add: ((WebElement newId: #content)
			add: self navigationBarElement; add: aWebElement;  yourself);
		add: ((WebElement newId: #contentWide)
			add: aWideElement; yourself);
		yourself.
	^self app add: element; yourself
!

pageFrameWith: aWebElement wide: aWideElement title: aTitleString printHeader: aHeaderElement
	"set a web page with standard  page look (navigation bar, header) "
	"Wide element comes below content besides navigation and it have full page width"
	"printHeader if exist is added first, out of all other elements"
	| element containerId |
	self app clear;  title: aTitleString. self app htmlHeaderElements.
"       self app        add: self headerBanner. "
	containerId := aHeaderElement elements notEmpty ifTrue: [#containerPadded] ifFalse: [#container].
	element := (WebElement newId: containerId)
		add: self headerElement;        add: self headerDashboard;
		add: ((WebElement newId: #content)
			add: self navigationBarElement; add: aWebElement;  yourself);
		add: ((WebElement newId: #contentWide)
			add: aWideElement; yourself);
		yourself.
	^self app
		add: aHeaderElement; "print header"
		add: element; yourself
!

searchButton
	searchButton isNil ifTrue:
		[searchButton := WebButton new
			title: 'Search'; text: 'S'; action: #search; style: '{font-size: 90%}';
			tabIndex: 99;
			id: #search234;
			yourself].
	^searchButton
!

sitePageFrameWith: aWebElement title: aTitleString
	| element |
	self app title: aTitleString.
	element := (WebElement newId: #container)
		add: self headerElement;
		add: ((WebElement newId: #sitePage)
			add: aWebElement;
			yourself);
		yourself.
	^self app add: element; yourself
!

wikiPageFrameWith: aWebElement title: aTitleString
	"called from WikiPageApp and SitePageApp"
	| element |
	self app title: aTitleString.
	element := (WebElement newId: #container)
		add: ((WebElement newId: #wikiPage)
			add: aWebElement;
			yourself);
		yourself.
	^self app add: element; yourself
! !

!WebStyle methodsFor:'imgs-bullets'!

arrowBigBlueGif
	"'imgs/sun-ar_lg_blue_r.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 15 0 13 0 128 1 0 89 79 191 255 255 255 33 249 4 1 0 0 1 0 44 0 0 0 0 15 0 13 0 0 2 26 140 143 169 0 234 220 92 130 114 50 4 179 62 186 223 224 109 21 248 85 212 120 162 209 56 22 0 59 )
!

arrowBigRedGif
	"'imgs/sun-ar_lg_red_r.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 15 0 13 0 128 1 0 205 43 64 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 15 0 13 0 64 2 27 140 143 169 6 189 217 192 155 47 170 136 179 92 150 6 231 49 224 161 105 100 137 81 221 52 34 5 0 59 )
!

arrowBigYellowGif
	"'imgs/sun-ar_lg_yell_r_pad.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 24 0 21 0 128 1 0 251 226 73 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 24 0 21 0 64 2 37 140 143 169 123 224 15 29 155 180 34 105 233 203 188 251 186 101 209 8 124 1 102 166 234 202 133 171 171 145 81 10 119 53 139 231 74 1 0 59 )
!

arrowCircledGreyGif
	"'imgs/adobe-grey_arrow.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 10 0 10 0 145 0 0 102 102 102 255 255 255 153 153 153 204 204 204 33 249 4 0 0 0 0 0 44 0 0 0 0 10 0 10 0 0 2 29 76 38 0 50 22 169 162 56 241 69 84 237 138 192 65 238 41 159 1 49 213 215 124 146 131 45 77 80 0 0 59 )
!

arrowCircledRedGif
	"'imgs/adobe-red_arrow.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 10 0 10 0 162 0 0 255 0 0 255 255 255 255 153 155 255 204 204 254 242 243 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 10 0 10 0 0 3 33 24 49 2 32 131 168 230 170 32 163 6 10 152 222 14 7 40 96 229 144 20 55 133 217 201 13 165 41 144 222 3 7 9 0 59 )
!

arrowDownBigRedGif
	"'imgs/sun-ar_lg_red_d_pad.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 24 0 21 0 128 1 0 204 51 51 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 24 0 21 0 64 2 39 140 143 169 203 224 12 163 92 14 76 90 235 221 188 67 221 105 226 19 146 222 137 94 32 186 158 173 106 5 160 41 101 182 119 167 113 202 115 5 0 59 )
!

arrowNextBigGif
	"'imgs/nav_arrow_right.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 20 0 19 0 213 0 0 237 237 237 245 245 245 242 242 242 234 234 234 246 246 246 253 253 253 235 235 235 251 251 251 249 249 249 254 254 254 241 241 241 236 236 236 247 247 247 239 239 239 248 248 248 250 250 250 228 228 228 229 229 229 224 224 224 243 243 243 222 222 222 252 252 252 233 233 233 217 217 217 225 225 225 219 219 219 237 237 238 233 234 234 225 225 224 218 218 218 227 227 227 226 226 226 230 231 231 221 222 222 232 232 231 231 231 231 237 238 238 229 229 228 234 234 233 249 249 248 220 219 220 234 234 235 240 241 241 251 250 250 220 220 221 246 247 247 221 222 221 227 226 227 221 221 221 239 238 238 227 227 228 241 241 242 230 230 230 245 245 246 232 232 232 238 238 238 244 244 244 240 240 240 186 186 186 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 9 0 0 59 0 44 0 0 0 0 20 0 19 0 0 8 230 0 119 232 208 145 99 135 193 131 8 19 10 12 128 99 96 65 133 16 117 48 192 193 208 33 196 132 58 90 40 192 193 177 33 193 139 6 117 4 184 33 128 0 2 134 30 31 42 212 49 97 65 14 28 39 30 20 72 192 209 34 70 1 27 110 204 32 240 160 66 2 6 52 83 34 212 161 0 132 1 5 1 28 28 40 192 180 2 195 0 54 117 52 24 49 128 100 210 7 43 14 32 96 64 128 35 84 130 58 110 120 176 1 32 199 132 0 4 184 214 192 33 32 199 13 142 5 6 222 248 64 195 4 128 27 57 114 40 80 113 163 129 6 3 21 193 146 144 16 65 132 133 1 41 6 40 30 96 161 230 71 129 0 36 188 136 80 34 2 4 8 50 32 8 16 96 51 36 0 10 24 48 112 144 224 2 70 140 6 157 15 234 0 16 130 2 11 20 29 22 24 72 61 20 64 134 12 23 12 12 160 141 113 193 133 5 95 85 130 20 57 251 49 200 161 198 143 31 12 8 0 )
!

arrowNextRedPng
	"'imgs/suse/suse-arrow-next.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 15 0 0 0 14 8 3 0 0 0 199 84 182 221 0 0 0 4 103 65 77 65 0 0 175 200 55 5 138 233 0 0 0 25 116 69 88 116 83 111 102 116 119 97 114 101 0 65 100 111 98 101 32 73 109 97 103 101 82 101 97 100 121 113 201 101 60 0 0 1 23 80 76 84 69 117 160 37 139 191 44 143 197 45 114 156 36 146 200 46 147 202 46 154 209 53 115 158 36 143 196 45 120 165 38 105 145 33 103 141 47 101 91 89 77 108 90 137 192 75 7 9 5 50 53 62 195 184 201 77 83 74 100 105 78 152 165 184 73 75 74 2 10 0 30 50 39 154 184 174 104 143 56 20 27 35 73 81 92 94 87 78 116 158 53 102 140 43 159 165 165 96 127 54 157 163 179 132 149 165 56 53 46 138 195 89 134 193 101 166 189 205 151 207 47 105 135 187 24 19 13 17 13 27 131 159 144 107 130 148 9 20 24 140 156 171 26 28 40 112 146 113 110 149 144 111 152 35 152 208 50 17 24 26 11 15 26 21 21 49 87 94 87 105 143 60 31 26 20 17 4 33 154 173 171 68 64 65 136 187 43 32 40 27 5 16 4 59 53 53 108 97 91 171 175 213 145 199 46 82 113 63 120 146 145 152 208 48 10 14 12 111 153 35 21 21 29 137 189 43 70 81 67 84 86 88 154 155 157 134 184 42 32 31 47 80 78 79 156 167 185 73 72 80 108 149 58 119 163 38 6 6 7 81 85 70 127 127 119 115 145 173 137 135 122 100 102 99 9 11 27 255 255 255 159 1 143 8 0 0 0 93 116 82 78 83 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 225 175 157 144 0 0 0 193 73 68 65 84 120 218 98 136 129 130 112 8 5 16 64 12 48 190 185 56 152 2 8 32 56 95 148 207 10 68 1 4 16 156 47 160 202 107 15 164 0 2 136 33 210 49 192 91 58 204 70 217 95 133 73 206 61 38 6 32 128 24 132 89 57 212 253 56 24 153 88 25 217 217 184 45 99 0 2 136 65 136 153 141 193 153 147 133 193 150 203 152 221 75 86 6 32 128 24 124 20 24 140 56 25 24 60 152 185 24 88 44 76 20 1 2 136 33 202 206 76 95 83 215 211 52 58 132 81 146 223 80 16 32 128 24 98 212 68 172 229 37 2 245 164 220 130 67 117 180 99 0 2 8 110 159 131 139 152 134 107 76 12 64 0 193 249 65 90 17 74 64 10 32 128 224 124 30 95 3 16 5 16 64 112 126 140 19 152 4 8 48 0 50 218 53 59 137 15 17 99 0 0 0 0 73 69 78 68 174 66 96 130 )
!

arrowOrangeDownGif
	"'imgs/dars-arrow-down.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 8 0 5 0 161 2 0 251 171 61 50 138 66 255 255 255 255 255 255 33 249 4 1 0 0 2 0 44 0 0 0 0 8 0 5 0 0 2 12 140 127 160 27 18 11 154 112 74 78 103 11 0 59 )
!

arrowOrangeLeftGif
	"'imgs/dars-arrow-left.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 5 0 8 0 161 2 0 251 171 61 50 138 66 255 255 255 255 255 255 33 249 4 1 0 0 2 0 44 0 0 0 0 5 0 8 0 0 2 13 148 19 7 25 176 237 144 91 2 166 74 79 40 0 59 )
!

arrowOrangeRightGif
	"'imgs/dars-arrow2.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 5 0 8 0 145 2 0 251 171 61 50 138 66 255 255 255 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 5 0 8 0 0 2 14 76 132 1 39 186 13 162 137 203 29 197 12 18 5 0 59 )
!

arrowOrangeUpGif
	"'imgs/dars-arrow-up.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 8 0 5 0 161 2 0 251 171 61 50 138 66 255 255 255 255 255 255 33 249 4 1 0 0 2 0 44 0 0 0 0 8 0 5 0 0 2 12 148 19 166 1 144 215 90 98 81 162 123 11 0 59 )
!

arrowPreviousBigGif
	"'imgs/nav_arrow_left.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 20 0 19 0 213 0 0 237 237 237 245 245 245 242 242 242 234 234 234 246 246 246 253 253 253 235 235 235 251 251 251 249 249 249 254 254 254 241 241 241 236 236 236 247 247 247 239 239 239 248 248 248 250 250 250 228 228 228 229 229 229 224 224 224 243 243 243 222 222 222 252 252 252 233 233 233 217 217 217 225 225 225 219 219 219 237 237 238 233 234 234 225 225 224 218 218 218 227 227 227 226 226 226 230 231 231 221 222 222 232 232 231 231 231 231 237 238 238 229 229 228 234 234 233 249 249 248 220 219 220 234 234 235 240 241 241 251 250 250 220 220 221 246 247 247 221 222 221 227 226 227 221 221 221 239 238 238 227 227 228 241 241 242 230 230 230 245 245 246 232 232 232 238 238 238 244 244 244 240 240 240 186 186 186 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 9 0 0 59 0 44 0 0 0 0 20 0 19 0 0 8 222 0 119 8 28 72 176 224 142 28 58 116 24 92 40 16 161 14 28 56 20 50 28 232 48 0 68 6 18 25 86 132 8 177 69 198 130 21 45 34 192 33 224 70 128 143 13 19 114 12 240 224 4 142 28 11 38 124 12 25 32 64 130 10 15 8 204 184 177 65 128 68 135 12 32 86 40 64 244 128 131 0 10 12 128 80 160 99 227 69 4 7 86 60 56 90 114 192 136 6 9 45 114 20 128 163 6 1 6 4 2 76 200 1 192 134 135 27 77 85 6 48 160 161 193 13 21 10 114 228 184 1 192 4 141 15 104 83 62 196 97 97 128 223 1 41 6 88 16 17 65 2 137 153 9 5 8 128 32 3 2 132 8 37 34 188 144 0 0 229 193 132 13 98 192 112 33 129 3 6 12 20 42 107 76 104 96 65 7 20 44 40 132 16 61 209 225 0 3 23 50 100 96 61 241 178 142 0 11 46 44 176 60 90 135 129 147 181 13 58 220 17 16 0 59 )
!

arrowPreviousRedPng
	"'imgs/suse/suse-arrow-prev.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 14 8 3 0 0 0 17 241 108 184 0 0 0 4 103 65 77 65 0 0 175 200 55 5 138 233 0 0 0 25 116 69 88 116 83 111 102 116 119 97 114 101 0 65 100 111 98 101 32 73 109 97 103 101 82 101 97 100 121 113 201 101 60 0 0 1 50 80 76 84 69 114 156 36 143 196 45 109 150 35 115 158 36 146 200 46 151 207 47 117 160 37 119 163 38 152 208 50 27 36 39 1 11 0 86 78 67 33 32 64 19 30 16 0 7 30 74 100 46 18 26 15 39 45 41 104 142 33 71 67 68 113 154 45 17 16 21 106 177 120 13 18 14 104 173 115 78 76 63 15 24 39 162 173 179 113 155 36 98 135 31 137 193 67 154 173 179 30 43 26 162 169 179 162 167 160 153 170 180 42 59 51 75 94 99 130 144 147 51 56 38 8 11 0 131 134 175 164 167 182 126 151 158 156 150 184 110 151 46 39 47 49 155 172 180 202 203 207 14 19 22 110 125 168 14 13 8 153 155 170 19 23 60 102 139 68 1 1 11 96 99 92 34 39 45 94 95 81 126 188 91 17 21 10 79 83 74 147 202 46 20 27 35 162 177 182 149 204 47 15 12 36 167 174 192 81 72 75 134 184 42 131 135 121 120 165 38 88 84 72 124 170 39 148 204 61 127 144 162 87 78 71 4 0 19 7 5 18 100 137 32 161 170 177 85 75 61 141 159 173 71 79 54 154 209 52 140 198 71 155 169 178 95 128 81 158 211 60 187 196 175 11 24 15 5 6 11 160 169 168 95 132 50 18 16 27 151 205 83 143 197 45 137 189 43 132 181 42 127 149 137 176 181 174 255 255 255 56 147 122 14 0 0 0 102 116 82 78 83 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 53 142 168 183 0 0 0 202 73 68 65 84 120 218 98 72 5 3 183 84 24 0 8 32 6 48 169 96 5 23 0 8 32 176 128 176 88 32 92 0 32 128 64 2 190 114 33 42 112 1 128 0 2 10 112 74 120 50 241 168 7 219 74 122 184 248 88 164 2 4 16 67 170 120 104 18 51 171 127 132 35 99 2 99 188 151 96 10 64 0 49 112 91 187 50 176 8 217 201 176 186 51 50 115 196 74 197 0 4 16 67 152 13 59 11 3 7 131 44 19 27 3 59 27 191 169 22 64 0 49 164 106 251 233 38 138 56 105 24 71 9 24 198 217 235 41 1 4 16 208 80 111 46 179 112 62 181 32 101 125 105 7 121 19 3 128 0 2 89 107 100 174 42 170 3 179 22 32 128 192 14 211 140 230 13 128 9 0 4 16 196 233 201 150 138 48 1 128 0 130 8 164 58 71 194 4 0 2 12 0 195 211 63 171 113 236 31 0 0 0 0 0 73 69 78 68 174 66 96 130 )
!

arrowSmallBlackGif
	"'imgs/ibm-arrow-right-black.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 7 0 7 0 128 1 0 0 0 0 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 7 0 7 0 0 2 11 140 143 1 105 11 15 23 146 135 178 2 0 59 )
!

arrowTriangleRedGif
	"'imgs/filo-redarr.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 14 0 13 0 128 0 0 255 255 255 255 0 0 33 249 4 1 0 0 0 0 44 0 0 0 0 14 0 13 0 0 2 23 132 143 169 123 193 25 226 51 177 190 138 23 222 112 59 197 49 214 244 77 230 121 20 0 59 )
!

arrowTriangleYellowGif
	"'imgs/dars-arrow2.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 5 0 8 0 145 2 0 251 171 61 50 138 66 255 255 255 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 5 0 8 0 0 2 14 76 132 1 39 186 13 162 137 203 29 197 12 18 5 0 59 )
!

bulletBookTranspWhiteGif
	"'imgs/fast/fast-book.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 153 204 102 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 29 68 142 25 166 141 0 95 148 17 206 99 77 78 123 83 109 113 161 135 141 225 183 156 138 230 180 143 139 21 0 59 13 10 )
!

bulletBubbleTranspWhiteGif
	"'imgs/fast/fast-soundoff.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 152 248 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 157 0 35 67 178 190 26 47 158 107 243 110 53 153 115 64 36 117 166 165 10 20 0 59 )
!

bulletCalendarTranspWhiteGif
	"'imgs/fast/fast-calendar.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 251 176 51 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 29 68 142 25 166 141 0 99 76 178 210 58 159 62 140 239 117 97 29 232 149 102 55 138 144 195 142 14 80 0 0 59 13 10 )
!

bulletCheckTranspWhiteGif
	"'imgs/fast/fast-register.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 22 68 142 25 166 237 15 89 148 135 2 90 217 125 119 79 8 134 34 130 53 64 1 0 59 13 10 )
!

bulletConnectTranspWhiteGif
	"'imgs/fast/fast-connect.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 23 68 142 25 166 237 15 29 91 114 130 121 174 222 234 34 223 88 209 72 70 152 84 0 0 59 13 10 )
!

bulletFindTranspWhiteGif
	"'imgs/fast/fast-find.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 24 68 142 25 166 157 0 89 139 209 209 101 171 124 114 243 234 40 94 56 90 161 121 46 5 0 59 13 10 )
!

bulletFolderTranspWhiteGif
	"'imgs/fast/fast-archives.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 153 204 102 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 24 68 142 25 166 237 127 128 132 178 218 100 51 206 117 115 22 125 224 34 66 38 117 2 5 0 59 13 10 )
!

bulletGraphTranspWhiteGif
	"'imgs/fast/fast-bargraph.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 27 68 142 25 166 221 192 220 129 18 209 186 204 125 58 42 186 77 93 246 141 33 9 122 216 180 2 5 0 59 13 10 )
!

bulletGuidesTranspWhiteGif
	"'imgs/fast/fast-guides.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 25 68 142 25 166 237 236 14 152 17 193 198 178 154 188 111 9 70 215 67 85 139 89 141 88 1 0 59 13 10 )
!

bulletIssueTranspWhiteGif
	"'imgs/fast/fast-issue.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 84 166 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 141 0 99 76 178 82 246 240 170 51 43 120 113 26 120 133 156 105 57 142 182 22 0 59 )
!

bulletLetterTranspWhiteGif
	"'imgs/fast/fast-newsletters.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 29 68 142 25 166 237 127 128 156 12 25 122 147 92 123 219 206 85 225 53 105 88 249 157 34 196 42 107 3 20 0 59 13 10 )
!

bulletManTranspWhiteGif
	"'imgs/fast/fast-cof.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 22 68 142 25 166 221 0 29 130 76 82 137 21 141 184 246 124 120 22 56 102 64 1 0 59 13 10 )
!

bulletNoteTranspWhiteGif
	"'imgs/fast/fast-riskfree.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 0 0 0 168 236 255 255 255 33 249 4 1 0 0 0 0 44 0 0 0 0 13 0 13 0 0 2 23 12 142 9 166 221 1 29 130 76 82 121 46 214 54 226 63 121 93 5 38 164 19 20 0 59 )
!

bulletPencilTranspWhiteGif
	"'imgs/fast/fast-pencil.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 153 102 102 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 173 236 142 129 13 210 135 110 178 113 229 62 1 90 54 117 139 104 98 38 80 0 0 59 13 10 )
!

bulletQuoteTranspWhiteGif
	"'imgs/fast/fast-first_imp.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 1 113 165 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 237 191 128 140 19 201 121 217 201 84 247 111 37 158 72 58 222 8 165 10 186 22 0 59 13 10 )
!

bulletRelatedTranspWhiteGif
	"'imgs/fast/fast-related.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 84 166 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 157 0 153 139 70 190 232 14 197 106 195 230 89 154 7 146 157 153 129 169 86 0 0 59 )
!

bulletSquareDownTranspWhiteGif
	"'imgs/fast/fast-down_arrow.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 84 166 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 23 68 142 25 166 237 159 128 132 107 66 201 30 214 120 183 158 125 214 69 145 20 80 0 0 59 )
!

bulletSquareLeftWhiteGif
	"'imgs/fast/fast-left_bull.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 11 0 11 0 162 2 0 242 242 236 166 165 165 245 245 236 232 232 222 196 196 181 255 255 255 0 0 0 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 11 0 11 0 0 3 38 40 50 220 163 171 200 89 72 164 148 12 26 242 158 65 39 105 82 104 142 95 41 2 36 56 177 41 5 176 2 33 207 150 66 236 124 158 0 0 59 13 10 )
!

bulletSquareRightTranspWhiteGif
	"'imgs/fast/fast-arrow.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 152 248 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 22 68 142 25 166 237 223 24 92 50 129 139 235 201 89 241 59 129 225 68 142 97 1 0 59 )
!

bulletStarTranspWhiteGif
	"'imgs/fast/fast-fast50.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 23 68 142 25 166 237 175 24 4 212 209 139 35 174 109 191 202 69 34 68 78 37 80 0 0 59 13 10 )
!

bulletToolsTranspWhiteGif
	"'imgs/fast/fast-tools_ico.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 24 68 142 25 166 157 0 87 108 176 58 52 111 190 146 119 255 105 140 55 130 74 233 0 5 0 59 13 10 )
!

bulletTriangleRightTranspWhiteGif
	"'imgs/fast/fast-interactive.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 24 68 142 25 166 173 236 16 128 113 210 102 111 202 250 228 184 76 96 56 46 229 216 109 5 0 59 13 10 )
!

docYellowPng
	"'imgs/suse/suse-doc.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 3 0 0 0 40 45 15 83 0 0 0 4 103 65 77 65 0 0 175 200 55 5 138 233 0 0 0 25 116 69 88 116 83 111 102 116 119 97 114 101 0 65 100 111 98 101 32 73 109 97 103 101 82 101 97 100 121 113 201 101 60 0 0 0 84 80 76 84 69 60 83 19 99 99 99 196 228 137 161 212 68 182 222 110 211 235 166 167 215 79 193 227 132 202 231 148 198 229 141 180 221 106 189 225 122 209 234 164 191 226 127 186 224 117 156 210 58 154 209 52 143 196 45 147 202 46 196 228 138 204 232 153 169 216 84 151 207 47 132 181 42 128 176 40 199 229 143 172 217 89 255 255 255 99 155 214 1 0 0 0 28 116 82 78 83 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 23 178 226 215 0 0 0 214 73 68 65 84 120 218 98 144 102 134 1 70 105 16 0 8 32 6 105 102 86 86 86 30 32 100 230 7 139 0 4 16 72 128 1 8 120 56 132 132 196 65 34 0 1 4 22 96 101 101 224 100 98 98 98 97 1 138 0 4 16 76 64 88 132 131 131 137 11 40 0 16 64 48 45 156 64 12 22 0 8 32 160 0 15 7 7 39 19 39 80 15 59 72 0 32 128 64 2 12 80 192 203 11 20 0 8 32 160 128 36 80 55 39 59 19 59 59 11 72 5 64 0 49 72 243 11 195 84 176 128 84 0 4 16 131 180 24 19 19 39 80 154 137 155 27 108 45 64 0 49 72 11 48 65 228 185 89 120 65 2 0 1 196 32 45 8 116 18 80 63 72 1 200 12 128 0 2 9 128 180 179 240 241 241 129 5 0 2 136 65 90 66 74 148 13 10 4 128 2 0 1 196 32 45 205 136 4 164 165 1 2 12 0 95 63 9 245 228 242 236 115 0 0 0 0 73 69 78 68 174 66 96 130 )
!

folderYellowClosedPng
	"'imgs/suse/suse-folder_closed.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 3 0 0 0 40 45 15 83 0 0 0 129 80 76 84 69 255 255 255 204 153 51 203 152 50 201 150 48 199 148 46 255 255 255 194 143 41 255 255 153 189 138 36 186 135 33 183 132 30 181 130 28 179 128 26 176 125 23 255 247 145 255 244 142 174 123 21 102 102 102 255 235 133 255 230 128 197 146 44 192 141 39 188 137 35 184 133 31 180 129 27 255 224 122 163 112 10 255 212 110 248 197 95 160 109 7 255 204 102 239 188 86 158 107 5 230 179 77 156 105 3 191 140 38 220 169 67 154 103 1 211 160 58 153 102 0 171 120 18 168 117 15 165 114 12 116 56 156 204 0 0 0 1 116 82 78 83 0 64 230 216 102 0 0 0 1 98 75 71 68 0 136 5 29 72 0 0 0 9 112 72 89 115 0 0 14 194 0 0 14 194 1 21 40 74 128 0 0 0 7 116 73 77 69 7 210 9 10 13 46 39 87 90 186 133 0 0 0 135 73 68 65 84 120 156 101 207 235 14 130 48 12 5 224 110 48 10 58 145 194 16 1 153 136 92 212 247 127 64 55 50 146 37 251 254 245 164 73 79 1 2 140 241 40 246 103 97 37 126 128 134 72 179 211 89 94 108 192 243 171 181 239 21 100 130 168 172 212 174 190 53 119 41 1 226 86 137 67 37 58 2 213 51 60 60 112 32 72 52 199 220 121 226 72 80 107 133 165 243 194 137 32 213 111 108 157 25 23 130 76 55 216 59 43 110 230 176 233 83 124 190 191 110 24 167 101 35 219 132 124 225 175 129 63 253 91 11 53 214 159 30 119 0 0 0 0 73 69 78 68 174 66 96 130 )
!

folderYellowOpenedPng
	"'imgs/suse/suse-folder_opened.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 3 0 0 0 40 45 15 83 0 0 0 117 80 76 84 69 255 255 255 204 153 51 203 152 50 201 150 48 199 148 46 255 255 255 194 143 41 255 255 153 189 138 36 186 135 33 183 132 30 181 130 28 179 128 26 176 125 23 255 247 145 255 244 142 255 224 122 102 102 102 255 235 133 255 230 128 197 146 44 174 123 21 192 141 39 184 133 31 180 129 27 220 169 67 158 107 5 255 204 102 248 197 95 156 105 3 154 103 1 255 212 110 211 160 58 153 102 0 171 120 18 168 117 15 165 114 12 163 112 10 160 109 7 41 224 143 149 0 0 0 1 116 82 78 83 0 64 230 216 102 0 0 0 1 98 75 71 68 0 136 5 29 72 0 0 0 9 112 72 89 115 0 0 14 194 0 0 14 194 1 21 40 74 128 0 0 0 7 116 73 77 69 7 210 9 10 13 46 54 61 234 154 119 0 0 0 135 73 68 65 84 120 156 101 143 235 18 130 32 16 70 215 11 162 133 193 162 80 136 90 118 123 255 71 140 221 154 198 25 206 191 239 204 94 1 50 138 162 172 234 125 22 68 179 23 50 33 218 238 112 84 61 137 242 164 181 209 154 235 122 76 162 178 131 37 134 4 139 218 252 243 87 140 134 112 222 251 241 124 81 10 160 225 204 35 68 144 19 130 143 49 186 217 74 234 11 114 65 104 57 91 110 12 114 69 232 102 23 175 63 110 114 75 99 211 61 238 254 120 190 222 211 178 110 72 123 112 79 254 107 198 7 32 212 11 87 225 11 89 100 0 0 0 0 73 69 78 68 174 66 96 130 )
!

keyGif
	"'imgs/fast/fast-key.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 18 0 8 0 145 2 0 209 173 75 221 185 87 245 245 236 245 216 100 33 249 4 1 0 0 2 0 44 0 0 0 0 18 0 8 0 0 2 32 148 134 99 203 156 217 226 155 20 29 4 64 157 33 229 20 116 67 216 5 23 103 132 139 153 62 108 212 144 47 108 20 0 59 13 10 )
! !

!WebStyle methodsFor:'imgs-buttons'!

buttonBackWhiteGif
	"'imgs/awful-button-back.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 30 0 22 0 230 0 0 229 229 229 232 232 232 239 239 239 207 207 207 143 143 143 223 223 223 64 64 64 252 252 252 226 226 226 228 228 228 159 159 159 140 140 140 212 212 212 221 221 221 254 254 254 214 214 214 216 216 216 199 199 199 0 0 0 16 16 16 189 189 189 175 175 175 253 253 253 225 225 225 128 128 128 222 222 222 201 201 201 148 148 148 172 172 172 209 209 209 191 191 191 244 244 244 240 240 240 151 151 151 48 48 48 235 235 235 179 179 179 177 177 177 180 180 180 186 186 186 205 205 205 163 163 163 142 142 142 247 247 247 218 218 218 156 156 156 80 80 80 174 174 174 194 194 194 224 224 224 155 155 155 166 166 166 150 150 150 145 145 145 202 202 202 96 96 96 220 220 220 203 203 203 242 242 242 211 211 211 195 195 195 165 165 165 137 137 137 215 215 215 249 249 249 141 141 141 164 164 164 250 250 250 130 130 130 231 231 231 204 204 204 112 112 112 32 32 32 208 208 208 152 152 152 248 248 248 135 135 135 134 134 134 178 178 178 146 146 146 246 246 246 219 219 219 173 173 173 176 176 176 251 251 251 132 132 132 138 138 138 217 217 217 236 236 236 241 241 241 181 181 181 147 147 147 133 133 133 153 153 153 158 158 158 245 245 245 183 183 183 136 136 136 210 210 210 144 144 144 230 230 230 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 30 0 22 0 0 7 255 128 100 130 131 132 133 134 135 136 25 17 21 10 27 99 143 144 99 53 74 51 20 12 8 136 130 23 17 33 27 48 5 101 161 162 162 31 12 10 11 47 16 0 135 13 36 11 8 163 177 178 101 38 79 3 9 133 49 78 33 84 179 190 162 81 4 3 171 130 0 60 11 191 201 161 12 93 44 131 16 42 32 202 161 30 179 22 50 39 196 20 41 202 2 24 19 6 178 7 75 35 99 13 100 9 45 176 190 3 55 18 72 24 160 177 7 31 89 11 54 100 13 4 190 21 6 18 6 10 126 29 0 49 66 8 24 50 15 246 201 114 49 225 136 60 129 2 0 76 225 128 80 97 44 12 18 68 40 16 144 108 8 150 11 37 40 234 19 229 96 148 183 9 19 110 60 140 5 133 12 14 25 90 208 169 11 85 82 150 2 17 255 42 204 19 144 225 7 23 13 130 182 89 24 90 83 150 7 23 225 72 126 72 240 32 71 16 28 130 32 44 16 176 98 5 144 162 178 56 138 250 2 224 65 135 48 217 138 193 176 162 67 0 8 29 211 66 93 96 128 66 10 13 103 131 80 98 148 80 81 132 12 128 0 120 243 234 13 0 160 0 132 36 57 76 248 24 86 168 85 19 13 5 174 60 216 33 166 177 99 49 29 6 160 48 162 97 139 48 92 134 54 209 96 50 195 3 227 199 141 59 216 224 80 133 72 42 98 137 22 121 113 20 233 81 141 16 61 44 97 202 68 187 118 161 64 0 59 )
!

buttonBeginWhiteGif
	"'imgs/awful-button-begin.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 22 0 22 0 230 0 0 239 239 239 143 143 143 207 207 207 159 159 159 223 223 223 128 128 128 221 221 221 254 254 254 212 212 212 228 228 228 214 214 214 191 191 191 226 226 226 32 32 32 140 140 140 216 216 216 225 225 225 252 252 252 253 253 253 199 199 199 189 189 189 64 64 64 222 222 222 201 201 201 16 16 16 232 232 232 172 172 172 96 96 96 209 209 209 151 151 151 240 240 240 175 175 175 244 244 244 156 156 156 141 141 141 242 242 242 247 247 247 235 235 235 174 174 174 163 163 163 155 155 155 194 194 194 220 220 220 180 180 180 142 142 142 166 166 166 224 224 224 202 202 202 150 150 150 218 218 218 205 205 205 177 177 177 179 179 179 186 186 186 203 203 203 145 145 145 219 219 219 138 138 138 144 144 144 173 173 173 135 135 135 134 134 134 0 0 0 248 248 248 246 246 246 195 195 195 217 217 217 80 80 80 165 165 165 236 236 236 133 133 133 215 215 215 181 181 181 250 250 250 176 176 176 146 146 146 158 158 158 152 152 152 153 153 153 249 249 249 245 245 245 251 251 251 164 164 164 231 231 231 183 183 183 132 132 132 130 130 130 208 208 208 204 204 204 147 147 147 241 241 241 137 137 137 178 178 178 136 136 136 148 148 148 229 229 229 255 255 255 230 230 230 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 22 0 22 0 0 7 255 128 97 130 131 132 133 134 135 22 19 31 3 55 77 45 20 8 12 135 131 16 19 29 94 41 4 96 32 8 3 14 38 15 95 135 6 52 14 12 96 168 169 168 43 75 2 9 133 46 92 29 81 170 181 96 56 1 2 162 130 95 65 14 182 192 8 78 49 131 15 44 30 192 182 18 40 53 187 20 39 181 11 182 11 17 63 37 58 6 97 9 33 167 168 11 21 24 170 3 13 67 17 32 90 14 47 97 6 1 168 4 27 13 3 0 222 21 21 31 96 17 30 37 82 84 97 10 237 2 48 12 80 21 160 129 128 84 17 0 124 81 162 193 95 59 48 227 54 104 2 3 160 64 131 2 243 146 20 129 48 163 33 187 84 7 10 96 168 144 10 192 6 31 5 128 132 81 129 2 137 54 110 168 14 80 44 80 139 128 8 0 22 142 24 185 32 232 153 132 159 50 109 29 0 145 64 129 13 17 42 4 61 112 0 128 4 137 39 65 85 65 249 162 128 67 151 102 188 82 228 24 1 192 195 8 91 16 16 200 216 1 131 216 32 23 51 88 76 9 243 37 131 219 47 4 52 30 92 177 177 98 139 174 66 164 122 92 32 32 164 170 0 25 88 46 100 201 245 202 80 37 24 60 90 44 224 240 66 67 21 43 160 118 77 74 244 129 201 141 14 68 32 73 154 196 185 115 32 0 59 )
!

buttonEditGif
	"'/home/mivsek/projekti/viart/edit.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 20 0 20 0 247 0 0 0 0 0 255 255 255 0 0 8 0 12 35 5 25 57 9 23 45 0 9 22 21 35 54 27 45 68 27 42 61 37 56 77 37 52 68 44 61 80 40 61 82 38 56 75 52 73 95 53 74 95 59 79 99 33 44 55 84 110 136 58 79 99 60 82 102 61 82 101 67 89 110 46 60 73 64 83 101 74 95 114 31 44 55 36 47 56 83 107 128 81 103 121 63 80 94 80 101 119 117 143 164 62 75 86 30 39 46 35 45 53 88 112 131 81 103 120 96 121 140 99 124 143 92 115 132 50 62 71 97 120 137 105 129 147 70 85 96 60 78 91 114 143 164 88 111 127 99 124 141 105 131 149 104 128 145 97 119 135 95 117 132 118 145 163 110 134 150 107 128 142 105 131 148 56 70 79 45 56 63 116 144 161 60 74 83 112 138 154 62 76 85 79 97 108 108 132 147 125 152 169 101 122 135 118 142 157 65 80 89 111 136 150 121 147 162 139 168 184 36 43 47 124 146 158 114 139 152 60 73 80 120 146 159 126 152 166 93 112 122 155 184 199 129 153 165 63 76 82 142 169 181 131 156 167 93 111 119 131 155 166 152 178 190 142 167 178 145 170 181 143 171 183 139 166 177 164 194 207 145 172 183 149 176 187 146 172 183 147 172 182 177 203 214 149 176 186 135 158 166 149 172 180 108 124 130 148 174 183 158 184 193 162 188 197 157 183 191 177 205 214 147 174 182 172 201 209 168 196 204 161 188 196 173 201 209 176 204 212 144 166 172 163 190 197 185 215 223 168 195 202 193 223 231 178 206 213 52 60 62 171 199 205 161 187 193 208 240 247 96 111 114 181 208 214 183 212 217 193 222 227 145 166 170 177 203 207 183 209 212 207 235 238 200 229 232 156 179 181 216 244 246 162 185 186 37 39 38 41 46 42 83 88 82 48 50 39 110 111 95 97 97 76 72 71 53 255 219 13 95 87 53 255 204 11 255 201 12 255 203 13 255 195 11 255 197 11 255 199 11 255 195 12 255 197 12 255 199 12 107 78 0 218 159 1 184 134 1 255 191 4 239 175 4 228 167 4 241 178 5 230 169 5 255 189 10 255 192 10 255 193 10 125 93 5 109 81 5 255 190 12 255 191 12 255 192 12 255 193 12 175 131 10 125 94 7 120 90 8 130 99 11 116 92 23 61 51 23 211 152 0 148 105 0 131 94 0 123 87 0 227 165 1 209 152 1 190 138 1 227 166 4 226 165 4 230 168 5 255 188 10 160 118 7 119 90 13 143 100 0 116 79 0 111 78 0 110 76 0 63 44 0 36 24 0 41 39 35 41 23 0 7 3 0 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 198 0 44 0 0 0 0 20 0 20 0 0 8 255 0 141 9 28 72 144 32 160 130 8 19 254 249 226 199 80 194 135 198 198 24 105 242 4 98 66 47 65 106 88 36 56 40 80 158 37 102 86 108 52 70 136 75 4 49 103 168 240 24 233 36 1 177 98 100 220 100 1 242 80 24 169 85 172 126 101 226 181 8 75 154 27 16 27 113 146 52 169 210 167 67 97 206 200 49 17 99 8 66 52 35 0 64 50 149 202 211 48 61 133 96 60 0 65 3 7 193 41 107 230 32 128 101 9 213 45 69 80 250 192 73 1 193 194 12 21 2 219 68 17 244 102 193 46 93 169 64 33 154 16 34 209 43 7 21 52 164 64 98 108 79 14 58 124 172 144 176 117 41 84 43 70 143 84 105 114 165 160 129 7 34 27 140 233 240 129 167 206 157 94 167 80 137 170 133 139 146 163 96 2 118 108 65 49 176 8 11 59 113 70 200 138 148 10 211 168 77 177 102 1 51 240 162 96 143 11 106 202 248 234 148 139 86 41 2 17 50 48 72 146 240 71 137 42 18 10 12 56 128 65 137 16 23 45 32 138 144 113 133 77 23 45 54 62 112 14 24 201 228 4 152 35 20 70 18 148 210 97 99 64 0 59 )
!

buttonEndWhiteGif
	"'imgs/awful-button-end.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 22 0 22 0 230 0 0 143 143 143 254 254 254 207 207 207 239 239 239 253 253 253 223 223 223 159 159 159 226 226 226 128 128 128 221 221 221 191 191 191 228 228 228 216 216 216 212 212 212 214 214 214 32 32 32 140 140 140 64 64 64 189 189 189 199 199 199 251 251 251 96 96 96 16 16 16 201 201 201 175 175 175 151 151 151 209 209 209 232 232 232 172 172 172 247 247 247 225 225 225 177 177 177 145 145 145 156 156 156 166 166 166 179 179 179 224 224 224 203 203 203 163 163 163 235 235 235 222 222 222 186 186 186 180 180 180 250 250 250 155 155 155 150 150 150 142 142 142 248 248 248 249 249 249 242 242 242 240 240 240 220 220 220 141 141 141 202 202 202 174 174 174 194 194 194 205 205 205 218 218 218 231 231 231 134 134 134 217 217 217 130 130 130 173 173 173 195 195 195 148 148 148 153 153 153 204 204 204 181 181 181 183 183 183 219 219 219 138 138 138 215 215 215 236 236 236 152 152 152 246 246 246 252 252 252 132 132 132 147 147 147 133 133 133 241 241 241 144 144 144 244 244 244 176 176 176 136 136 136 80 80 80 178 178 178 146 146 146 164 164 164 0 0 0 245 245 245 165 165 165 137 137 137 158 158 158 135 135 135 208 208 208 229 229 229 255 255 255 230 230 230 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 22 0 22 0 0 7 255 128 97 130 131 132 133 134 135 40 19 24 6 32 73 34 18 13 7 135 131 30 19 25 64 55 5 96 81 13 6 16 54 12 95 135 9 35 16 7 96 168 169 168 42 86 2 11 133 36 85 25 20 170 181 96 69 0 2 162 130 95 63 16 182 192 13 65 57 131 12 46 50 192 182 4 44 41 187 18 38 96 4 10 182 211 168 1 47 39 80 9 97 11 33 167 4 84 15 6 170 22 17 213 29 79 16 53 97 9 0 168 4 96 24 17 230 168 3 6 15 21 5 1 72 87 68 97 14 238 192 44 73 37 224 65 64 84 6 44 8 56 33 133 195 63 119 20 86 128 25 128 224 1 130 1 168 10 84 16 7 70 199 7 135 237 80 41 65 128 165 2 70 84 17 44 32 8 0 6 198 12 22 67 184 121 3 243 130 134 38 85 23 193 4 32 112 224 136 147 11 130 158 17 32 64 129 165 173 0 43 22 56 40 65 99 134 32 6 16 6 116 232 0 195 168 170 44 95 28 104 152 210 140 215 13 35 49 6 200 136 97 203 67 3 28 62 90 16 27 68 226 131 11 29 97 58 190 108 152 251 165 0 3 47 37 84 108 209 85 136 212 142 11 5 120 104 21 128 67 200 133 38 185 94 25 170 212 162 139 8 5 26 106 112 96 210 3 212 174 73 137 48 112 1 145 65 11 36 73 147 66 139 14 4 0 59 )
!

buttonNextWhiteGif
	"'imgs/awful-button-next.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 30 0 22 0 230 0 0 229 229 229 232 232 232 239 239 239 207 207 207 143 143 143 223 223 223 64 64 64 252 252 252 226 226 226 228 228 228 159 159 159 140 140 140 212 212 212 221 221 221 214 214 214 216 216 216 0 0 0 16 16 16 225 225 225 189 189 189 253 253 253 128 128 128 254 254 254 199 199 199 175 175 175 222 222 222 201 201 201 191 191 191 148 148 148 172 172 172 209 209 209 240 240 240 244 244 244 151 151 151 48 48 48 177 177 177 179 179 179 145 145 145 174 174 174 194 194 194 163 163 163 180 180 180 247 247 247 156 156 156 220 220 220 166 166 166 203 203 203 142 142 142 218 218 218 155 155 155 80 80 80 235 235 235 224 224 224 186 186 186 205 205 205 96 96 96 150 150 150 202 202 202 242 242 242 211 211 211 195 195 195 217 217 217 137 137 137 178 178 178 181 181 181 138 138 138 246 246 246 133 133 133 146 146 146 134 134 134 153 153 153 32 32 32 236 236 236 250 250 250 219 219 219 251 251 251 112 112 112 241 241 241 208 208 208 173 173 173 147 147 147 158 158 158 249 249 249 215 215 215 176 176 176 132 132 132 135 135 135 231 231 231 141 141 141 164 164 164 136 136 136 245 245 245 152 152 152 165 165 165 130 130 130 248 248 248 183 183 183 204 204 204 210 210 210 144 144 144 230 230 230 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 30 0 22 0 0 7 255 128 100 130 131 132 133 134 135 136 25 23 24 10 28 99 143 144 99 37 92 45 19 12 8 136 130 18 23 33 28 39 5 101 161 162 162 32 12 10 11 38 15 0 135 13 36 11 8 163 177 178 101 41 68 3 9 133 52 63 33 75 179 190 162 74 4 3 171 130 0 60 11 191 201 161 12 70 48 131 15 47 31 179 27 202 161 20 49 53 196 19 40 190 6 17 21 2 191 7 95 51 99 13 100 9 43 176 179 5 21 71 16 55 3 179 7 32 77 11 57 100 13 4 213 10 6 16 6 24 98 29 248 48 35 11 24 50 14 246 85 43 83 128 73 4 25 163 14 8 0 64 165 3 66 133 202 4 40 16 1 161 194 168 36 72 36 140 176 168 79 148 5 118 55 34 124 11 55 74 8 25 22 49 128 160 83 23 234 228 40 12 254 68 40 152 39 32 195 148 33 26 4 109 163 64 212 102 40 3 50 168 205 178 0 34 129 3 23 88 88 8 122 176 64 128 10 21 82 70 177 244 181 5 128 3 15 90 178 21 59 17 68 135 128 15 58 22 150 145 192 192 198 19 28 206 82 6 209 24 241 226 10 25 0 1 242 234 221 27 0 64 129 7 78 92 164 240 49 172 80 171 34 26 10 244 112 176 67 140 227 199 98 60 12 176 17 70 3 20 97 184 12 109 194 97 165 197 134 198 144 29 123 200 209 161 138 151 84 196 18 45 138 226 40 210 163 18 33 186 88 194 148 169 182 237 66 129 0 0 59 )
!

buttonUpWhiteGif
	"'imgs/awful-button-up.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 22 0 22 0 198 96 0 239 239 239 143 143 143 207 207 207 159 159 159 223 223 223 128 128 128 221 221 221 254 254 254 212 212 212 228 228 228 214 214 214 191 191 191 226 226 226 32 32 32 140 140 140 216 216 216 225 225 225 252 252 252 253 253 253 199 199 199 189 189 189 64 64 64 222 222 222 201 201 201 16 16 16 232 232 232 172 172 172 96 96 96 209 209 209 151 151 151 240 240 240 175 175 175 244 244 244 156 156 156 141 141 141 242 242 242 247 247 247 235 235 235 174 174 174 163 163 163 155 155 155 194 194 194 220 220 220 180 180 180 142 142 142 166 166 166 224 224 224 202 202 202 150 150 150 218 218 218 205 205 205 177 177 177 179 179 179 186 186 186 203 203 203 145 145 145 219 219 219 138 138 138 144 144 144 173 173 173 135 135 135 134 134 134 0 0 0 248 248 248 246 246 246 195 195 195 217 217 217 80 80 80 165 165 165 236 236 236 133 133 133 215 215 215 181 181 181 250 250 250 176 176 176 146 146 146 158 158 158 152 152 152 153 153 153 249 249 249 245 245 245 251 251 251 164 164 164 231 231 231 183 183 183 132 132 132 130 130 130 208 208 208 204 204 204 147 147 147 241 241 241 137 137 137 178 178 178 136 136 136 148 148 148 229 229 229 255 255 255 230 230 230 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 44 0 0 0 0 22 0 22 0 0 7 254 128 97 130 131 130 9 6 10 10 6 9 132 140 132 95 15 20 33 1 147 1 33 20 15 95 141 131 46 41 14 39 12 96 161 96 12 39 44 65 46 154 6 51 57 0 18 162 2 162 30 14 92 6 140 16 52 44 35 36 174 96 3 24 4 162 96 29 52 16 132 19 61 83 0 187 7 7 13 3 27 193 81 14 19 131 22 48 23 97 30 79 7 96 5 208 13 11 193 12 29 22 130 19 60 4 95 35 220 0 191 189 21 193 96 94 212 97 31 45 66 25 162 5 240 96 237 225 162 41 62 8 98 178 64 65 190 120 8 67 17 24 32 232 6 7 14 7 69 1 8 144 16 204 13 65 29 94 8 248 18 175 0 56 132 32 154 8 34 162 65 6 48 137 13 4 240 11 134 160 133 32 10 85 176 60 8 182 161 0 152 10 3 226 13 160 32 8 129 149 11 87 32 64 57 64 192 7 0 48 31 26 196 115 128 64 16 3 19 89 108 32 248 2 66 132 205 80 67 254 129 89 97 130 193 160 7 1 86 200 80 144 0 0 144 36 17 210 70 8 133 99 201 3 71 71 2 182 236 224 160 160 92 17 0 30 64 252 144 128 32 192 70 70 9 4 192 232 98 227 136 10 8 95 74 104 41 129 194 137 128 69 141 190 196 168 33 194 8 138 25 74 164 56 208 81 35 70 38 77 130 190 168 184 128 68 131 6 42 47 12 124 6 205 154 117 32 0 59 )
! !

!WebStyle methodsFor:'imgs-common symbols'!

calendar1Gif
	"'imgs/calendar1.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 19 0 20 0 179 0 0 0 0 0 255 255 255 2 100 199 2 97 194 4 120 237 57 153 251 121 188 253 204 229 254 225 240 255 70 162 251 252 2 2 250 250 250 255 255 255 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 12 0 44 0 0 0 0 19 0 20 0 0 4 93 144 201 73 107 77 56 235 141 89 26 96 40 142 32 54 20 104 170 174 3 38 144 112 136 25 72 109 223 248 49 35 4 193 251 189 223 79 151 160 17 22 60 228 49 153 36 210 112 80 155 83 24 84 40 168 132 233 114 169 80 122 167 209 168 22 72 198 106 189 204 237 2 28 206 237 130 240 114 239 156 70 31 217 109 105 194 195 233 103 44 128 128 17 0 59 )
!

calendar2Gif
	"'imgs/calendar2.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 20 0 20 0 230 0 0 0 0 0 255 255 255 73 72 73 58 57 59 62 62 63 58 58 59 84 84 85 78 78 79 72 72 73 98 98 99 91 91 92 16 49 249 92 135 223 137 178 244 116 184 250 145 198 250 57 58 59 115 184 249 115 185 249 116 184 249 116 185 249 121 187 249 128 191 249 136 195 249 137 195 249 145 199 250 154 203 250 154 204 250 164 208 249 174 213 250 174 213 249 183 218 250 192 222 250 201 226 250 201 227 250 208 230 250 215 233 249 208 231 250 215 234 250 222 237 250 221 236 249 226 239 250 208 220 223 66 67 67 105 106 106 98 99 98 32 117 2 47 167 5 207 207 205 197 197 195 182 182 180 182 182 181 178 178 177 197 196 195 63 62 62 85 84 84 114 113 113 146 145 145 164 164 164 145 145 145 129 129 129 127 127 127 121 121 121 106 106 106 91 91 91 67 67 67 58 58 58 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 67 0 44 0 0 0 0 20 0 20 0 0 7 189 128 67 130 131 132 133 134 48 136 137 138 139 137 67 49 41 144 145 146 147 145 53 50 40 46 47 154 155 156 156 46 39 51 58 36 157 164 157 38 58 57 37 42 171 172 173 174 42 35 59 60 34 61 181 182 183 184 61 33 60 62 32 61 52 1 191 193 192 194 197 32 62 56 31 61 1 193 204 203 205 208 61 31 56 44 30 185 182 11 217 11 182 29 63 45 28 197 196 192 11 12 13 11 196 28 9 10 26 207 237 204 11 13 230 206 27 64 55 15 215 181 218 219 181 25 6 7 23 225 134 9 44 134 225 128 0 11 238 162 57 115 102 1 193 138 10 248 240 85 8 98 35 66 4 10 23 39 104 140 224 64 227 4 139 31 37 16 24 82 160 100 1 33 5 6 160 52 201 18 66 1 67 48 99 202 156 57 36 16 0 59 )
!

calendar3Gif
	"'imgs/calendar3.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 20 0 20 0 179 0 0 0 0 0 255 255 255 4 111 231 57 148 251 178 178 177 255 0 0 253 125 125 252 215 215 127 127 127 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 9 0 44 0 0 0 0 20 0 20 0 0 4 97 48 137 73 171 165 50 232 205 251 158 193 32 142 100 57 4 160 169 142 168 224 189 29 136 204 116 109 35 109 128 16 58 191 247 64 156 76 131 211 17 143 70 217 109 86 104 22 104 185 159 148 87 48 28 10 190 40 178 88 56 92 143 202 165 243 57 139 250 206 193 236 208 200 46 186 163 203 184 57 77 23 186 222 237 45 60 126 203 193 254 2 18 23 131 21 9 17 0 59 )
!

calendar4Gif
	"'imgs/calendar4.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 20 0 20 0 230 0 0 0 0 0 255 255 255 116 184 250 145 198 250 9 134 252 9 135 252 14 137 252 20 141 252 27 143 252 27 144 252 34 147 252 34 148 252 39 149 252 39 150 252 40 149 252 40 150 252 42 151 252 50 154 252 50 155 252 59 159 252 67 163 252 68 163 252 76 167 252 76 168 252 84 171 252 86 172 252 86 173 252 87 172 252 87 173 252 92 175 252 99 178 252 99 179 252 106 182 252 112 185 252 117 187 252 115 184 249 115 185 249 116 184 249 116 185 249 121 189 252 121 187 249 128 191 249 136 195 249 137 195 249 145 199 250 154 203 250 154 204 250 164 208 249 174 213 250 174 213 249 183 218 250 192 222 250 201 226 250 201 227 250 208 230 250 215 233 249 208 231 250 215 234 250 222 237 250 221 236 249 226 239 250 208 220 223 252 132 14 251 172 95 251 226 201 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 65 0 44 0 0 0 0 20 0 20 0 0 7 202 128 65 130 131 132 133 134 39 136 137 138 139 137 65 34 60 144 145 146 147 145 34 33 59 25 28 28 25 153 27 25 26 28 27 158 27 154 58 33 32 55 15 14 13 170 15 13 175 15 12 177 178 12 57 32 31 56 61 186 187 188 189 61 54 30 29 53 6 196 197 198 199 6 52 29 24 51 6 49 1 206 208 207 209 212 51 24 23 50 6 1 208 219 218 220 223 6 50 22 20 49 200 197 62 232 62 197 48 21 19 47 212 211 207 62 63 64 62 211 47 19 18 45 222 252 219 62 64 245 186 185 136 0 97 128 57 98 233 212 17 99 1 97 129 10 120 210 34 82 91 161 0 65 138 126 224 186 117 75 145 224 0 138 131 7 81 28 48 48 98 132 9 147 37 82 142 16 144 178 68 73 151 36 12 4 41 64 179 38 77 2 54 115 26 218 201 179 167 207 32 129 0 0 59 )
!

calendar5Gif
	"'imgs/calendar5.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 19 0 20 0 179 0 0 0 0 0 255 255 255 1 130 248 1 104 199 2 76 145 5 128 241 107 183 253 164 209 251 206 207 207 252 1 1 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 10 0 44 0 0 0 0 19 0 20 0 0 4 100 80 169 51 43 189 85 202 114 184 239 160 167 21 195 81 158 102 122 22 219 224 190 112 92 32 10 25 223 239 92 227 188 94 24 192 160 112 232 11 24 143 200 100 17 41 8 52 159 1 66 96 153 172 26 139 9 167 22 218 148 82 173 74 90 33 144 229 110 163 83 49 216 138 61 155 189 234 117 184 70 118 107 145 95 121 122 83 232 251 255 127 52 26 8 132 133 134 134 26 17 0 59 )
!

calendarButtonGif
	^self calendar2Gif
!

commentsSmallGif
	"a small bubble"
	"'imgs/itp-comments.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 11 0 11 0 162 5 0 171 171 171 246 246 246 212 212 212 255 255 255 148 148 148 255 255 255 0 0 0 0 0 0 33 249 4 1 0 0 5 0 44 0 0 0 0 11 0 11 0 0 3 38 88 186 188 244 144 184 65 71 8 66 18 42 122 199 143 117 141 32 33 96 222 153 21 38 9 58 80 7 72 13 43 215 138 73 227 79 145 0 0 59 )
!

emailJpg
	"'imgs/toledo-email.jpg' asFilename contentsAsMethod"
^#(255 216 255 224 0 16 74 70 73 70 0 1 1 1 0 72 0 72 0 0 255 219 0 67 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 219 0 67 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 192 0 17 8 0 14 0 22 3 1 34 0 2 17 1 3 17 1 255 196 0 31 0 0 1 5 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 2 3 4 5 6 7 8 9 10 11 255 196 0 181 16 0 2 1 3 3 2 4 3 5 5 4 4 0 0 1 125 1 2 3 0 4 17 5 18 33 49 65 6 19 81 97 7 34 113 20 50 129 145 161 8 35 66 177 193 21 82 209 240 36 51 98 114 130 9 10 22 23 24 25 26 37 38 39 40 41 42 52 53 54 55 56 57 58 67 68 69 70 71 72 73 74 83 84 85 86 87 88 89 90 99 100 101 102 103 104 105 106 115 116 117 118 119 120 121 122 131 132 133 134 135 136 137 138 146 147 148 149 150 151 152 153 154 162 163 164 165 166 167 168 169 170 178 179 180 181 182 183 184 185 186 194 195 196 197 198 199 200 201 202 210 211 212 213 214 215 216 217 218 225 226 227 228 229 230 231 232 233 234 241 242 243 244 245 246 247 248 249 250 255 196 0 31 1 0 3 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 2 3 4 5 6 7 8 9 10 11 255 196 0 181 17 0 2 1 2 4 4 3 4 7 5 4 4 0 1 2 119 0 1 2 3 17 4 5 33 49 6 18 65 81 7 97 113 19 34 50 129 8 20 66 145 161 177 193 9 35 51 82 240 21 98 114 209 10 22 36 52 225 37 241 23 24 25 26 38 39 40 41 42 53 54 55 56 57 58 67 68 69 70 71 72 73 74 83 84 85 86 87 88 89 90 99 100 101 102 103 104 105 106 115 116 117 118 119 120 121 122 130 131 132 133 134 135 136 137 138 146 147 148 149 150 151 152 153 154 162 163 164 165 166 167 168 169 170 178 179 180 181 182 183 184 185 186 194 195 196 197 198 199 200 201 202 210 211 212 213 214 215 216 217 218 226 227 228 229 230 231 232 233 234 242 243 244 245 246 247 248 249 250 255 218 0 12 3 1 0 2 17 3 17 0 63 0 254 213 30 211 196 102 79 17 248 239 84 190 241 127 140 124 60 124 77 227 155 93 71 195 126 29 241 103 140 124 61 226 93 2 203 195 62 43 214 124 51 167 63 131 180 207 12 120 143 68 208 60 65 167 91 233 90 37 140 247 222 28 185 210 237 188 87 121 121 54 185 172 216 248 147 196 186 149 198 147 224 217 124 143 197 255 0 26 62 20 91 121 182 190 13 241 199 140 188 83 174 147 115 28 30 22 240 215 197 31 31 106 62 36 51 90 222 71 97 113 13 230 155 125 227 24 63 177 69 189 204 233 246 155 191 17 75 164 105 246 112 44 183 151 119 73 105 11 200 223 22 254 210 255 0 240 80 207 134 191 2 254 50 124 71 253 156 126 42 248 103 226 13 246 139 224 221 126 243 91 212 173 252 7 99 160 106 182 30 62 63 18 89 254 37 105 218 111 136 175 53 191 21 248 78 238 195 195 90 70 141 227 29 58 207 91 240 205 165 141 244 126 44 213 160 184 179 213 53 111 248 68 226 190 209 124 79 243 39 196 15 248 42 151 192 31 29 216 221 105 183 190 11 248 195 37 149 211 70 236 146 232 190 16 183 154 41 109 231 142 238 210 234 210 234 215 226 31 159 99 168 217 94 91 218 222 88 234 86 143 21 229 141 229 188 55 118 50 219 77 111 3 39 101 8 115 43 201 90 246 106 214 178 139 73 197 91 85 170 215 68 154 91 251 199 93 42 112 122 206 221 58 54 186 93 53 102 157 189 45 109 53 110 231 234 7 236 223 241 31 226 149 255 0 237 41 103 224 207 19 248 222 239 84 240 207 136 62 11 124 80 241 101 207 132 62 221 168 107 250 94 147 172 248 59 199 159 5 116 175 14 222 90 248 135 196 242 95 248 146 239 81 131 77 241 247 137 236 117 59 187 41 252 59 161 107 144 201 166 207 47 132 109 46 244 203 107 201 10 249 103 254 9 129 241 57 191 104 159 142 190 55 248 139 162 45 228 126 27 248 61 240 171 87 240 13 245 207 137 162 181 211 188 83 174 95 124 98 241 119 129 252 65 225 203 193 165 232 242 234 218 49 26 109 167 193 95 19 65 226 59 229 213 180 245 158 247 80 209 46 52 189 18 56 47 53 8 52 146 176 196 90 53 90 140 82 86 142 137 36 175 104 173 180 232 215 225 231 108 107 242 123 89 114 43 71 221 73 90 218 168 171 233 167 91 179 255 217 )
!

emailSmall1Gif
	"'imgs/intelicom-email.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 15 0 11 0 194 0 0 0 0 0 255 255 255 204 204 204 204 0 0 102 51 204 153 153 153 153 0 102 0 0 0 33 249 4 1 0 0 7 0 44 0 0 0 0 15 0 11 0 0 3 42 8 186 220 16 48 74 40 84 16 56 227 65 70 125 66 81 104 2 97 16 223 69 110 93 138 137 48 105 173 235 28 194 163 102 211 217 206 23 142 224 34 1 0 59 )
!

emailSmall2Gif
	"'imgs/jta-email.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 13 0 14 0 128 0 0 255 255 255 42 42 161 33 249 4 0 0 0 0 0 44 0 0 0 0 13 0 14 0 0 2 31 132 143 23 203 237 137 24 8 112 78 106 163 89 170 111 124 133 223 70 102 28 168 73 213 229 180 220 10 199 114 1 0 59 )
!

emailSmall3Gif
	"'imgs/las-email.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 15 0 11 0 162 255 0 255 255 255 204 204 204 192 192 192 51 102 153 0 51 102 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 15 0 11 0 64 3 45 40 186 220 66 36 200 57 161 138 97 128 189 49 185 26 39 2 214 35 69 90 228 93 80 235 182 236 43 95 217 216 5 159 41 133 100 69 99 184 10 142 70 41 14 19 0 59 )
!

eranovaHeaderGif
	"'imgs/head-en.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 88 2 100 0 179 0 0 255 255 255 231 231 237 223 223 223 204 204 204 180 180 180 161 159 183 153 153 153 116 131 158 153 102 102 111 111 111 100 108 144 57 93 121 69 69 92 24 83 125 51 51 51 15 15 15 33 249 4 4 20 0 255 0 44 0 0 0 0 88 2 100 0 0 4 255 16 200 73 171 189 56 235 205 187 255 96 40 142 100 105 158 104 170 174 108 235 190 112 44 207 116 109 223 120 174 239 124 239 255 192 160 112 72 44 26 143 200 164 114 201 108 58 159 208 168 116 74 173 90 175 216 172 118 203 237 122 191 224 176 120 76 46 155 207 232 52 53 192 86 187 217 112 183 124 78 199 193 219 117 242 61 144 239 251 255 35 123 120 128 92 130 124 91 123 132 138 139 37 134 140 90 142 136 119 143 148 149 26 137 150 87 130 146 152 153 158 148 157 159 82 161 88 145 162 52 164 167 71 131 170 163 172 144 169 173 45 177 178 181 182 97 180 183 39 166 186 189 190 89 113 191 43 188 194 197 198 199 104 155 200 203 204 205 156 175 206 209 99 135 94 208 210 36 193 215 218 107 212 23 214 77 223 18 225 219 228 229 184 2 2 214 227 74 232 232 221 19 233 230 242 243 231 2 3 247 239 235 73 1 3 246 248 20 1 4 208 27 72 16 146 191 127 19 222 69 65 119 175 31 181 128 5 35 74 28 213 112 192 67 133 11 43 82 139 55 177 163 199 125 1 255 57 2 208 183 36 164 187 67 34 63 170 92 249 35 17 73 38 108 210 181 121 201 178 166 205 89 0 49 114 131 167 243 166 207 159 47 122 106 18 8 180 168 209 97 185 166 40 59 202 180 105 135 152 73 161 152 156 228 180 170 51 126 21 179 54 60 132 85 171 69 161 226 218 45 189 84 145 40 133 131 102 19 10 32 80 160 45 129 148 0 14 14 176 208 181 95 5 172 39 169 90 221 43 44 128 1 4 128 3 11 14 76 64 2 129 4 136 19 43 78 96 96 46 6 67 196 42 8 88 64 121 129 130 180 0 14 84 62 208 77 128 230 6 160 67 31 112 44 225 64 232 5 239 10 132 110 112 0 160 88 200 96 249 202 206 20 96 176 109 194 134 23 235 70 76 218 53 236 92 3 42 83 46 156 80 51 229 214 19 10 44 88 205 188 65 129 228 171 49 43 88 77 154 159 204 188 119 224 206 222 158 76 175 135 1 183 111 59 54 176 123 119 190 56 144 219 105 55 44 124 1 231 132 10 42 63 151 160 124 121 115 234 244 241 195 91 173 128 43 58 9 215 169 199 144 255 69 220 21 216 157 119 28 128 23 222 96 115 249 165 152 1 16 146 183 88 111 1 113 5 155 88 24 212 39 92 117 241 13 39 65 112 149 53 96 217 1 159 133 214 31 0 3 232 151 95 104 196 133 36 78 118 1 182 3 12 130 6 214 24 153 6 10 2 70 128 87 255 212 150 24 1 217 73 136 24 113 97 241 81 225 111 21 94 96 156 112 243 197 181 225 72 37 54 160 0 129 252 76 199 98 92 171 53 25 128 149 160 25 105 143 151 175 201 100 210 122 81 68 85 163 108 99 113 64 128 96 96 129 247 99 5 3 40 70 100 146 80 33 233 206 93 75 86 118 34 138 194 9 4 98 101 189 161 184 90 107 1 216 231 220 126 161 205 151 151 128 98 198 164 158 38 105 158 89 160 153 21 172 25 88 155 138 5 42 128 156 240 8 132 36 28 7 229 211 97 123 196 17 32 28 31 26 46 208 36 124 38 178 193 37 114 0 168 22 154 167 118 141 217 232 29 26 89 113 163 164 219 101 227 129 95 130 17 32 236 176 194 146 118 88 98 152 29 203 91 145 159 134 148 85 255 103 194 45 137 156 134 253 5 144 103 160 165 157 198 135 105 160 41 32 206 171 0 198 248 26 168 247 236 216 16 164 52 242 170 46 7 192 46 8 152 1 19 40 155 128 185 229 62 232 165 145 144 221 195 208 107 4 78 240 231 148 29 94 22 235 102 35 141 186 103 5 220 138 136 106 171 130 134 214 96 60 160 138 41 151 190 237 244 203 141 175 235 78 113 207 46 216 214 81 155 187 58 78 32 100 121 137 57 150 100 66 112 52 116 171 163 105 153 74 89 127 26 62 183 228 115 147 17 172 164 182 0 16 128 179 172 82 242 145 87 88 3 58 180 199 190 232 102 92 69 112 12 36 141 25 8 5 48 64 72 142 238 182 56 114 121 64 162 60 18 156 66 27 242 104 114 155 241 211 245 204 78 218 108 65 194 168 53 12 90 58 92 62 231 98 55 120 29 153 93 69 70 203 64 41 21 229 198 102 129 2 222 2 160 0 114 118 249 235 88 58 4 218 67 159 211 29 203 1 53 177 136 155 76 178 189 47 98 132 157 32 234 81 35 45 148 149 17 48 106 97 53 31 231 13 255 151 39 10 16 93 138 179 142 100 141 67 39 137 37 87 220 49 204 45 69 185 16 18 233 65 211 7 84 173 55 222 222 22 26 159 183 241 49 112 0 237 168 193 30 159 31 150 2 6 150 0 8 36 102 192 176 83 183 168 206 111 114 113 5 118 206 155 61 185 165 158 10 129 14 26 114 133 58 156 176 162 235 29 41 113 197 91 161 238 194 174 86 12 32 172 144 34 20 160 64 210 194 50 192 6 3 64 206 117 128 211 191 19 224 126 0 64 54 141 34 3 133 167 17 60 2 152 122 83 188 30 84 36 12 172 140 92 42 251 150 124 0 52 170 62 149 134 122 120 202 210 183 18 197 165 191 117 239 43 48 146 203 91 196 55 139 72 97 97 0 16 74 64 210 18 16 130 141 101 134 1 77 163 221 91 104 71 63 111 233 47 57 132 227 95 30 218 133 0 3 128 69 94 20 18 18 188 70 242 21 111 64 78 61 230 219 17 3 43 55 129 60 189 236 16 169 90 85 172 86 179 0 179 36 236 85 40 113 200 5 196 165 193 182 44 141 131 187 80 29 20 14 147 52 248 255 133 32 62 247 192 219 0 100 8 36 188 157 112 118 251 235 199 2 6 160 191 49 246 239 12 52 68 0 226 136 229 24 121 189 67 135 70 218 81 56 134 86 46 2 64 200 49 127 90 163 191 218 227 158 67 4 82 85 112 80 206 160 40 192 51 21 9 160 0 82 244 97 72 248 33 172 2 144 232 0 87 196 98 35 210 5 9 33 138 192 51 73 19 152 114 24 224 45 151 205 15 141 3 211 93 172 98 248 70 51 64 45 106 18 24 217 29 141 119 136 97 97 80 33 123 48 95 132 12 64 20 151 81 198 44 211 139 86 113 8 25 31 230 8 12 58 198 124 72 91 32 217 168 156 128 138 45 187 179 140 221 52 249 1 140 81 147 6 255 115 87 131 240 88 1 110 162 200 143 199 203 74 163 26 114 190 16 242 146 61 71 100 100 123 86 37 128 6 222 71 144 20 176 94 162 224 180 187 216 245 145 116 12 25 150 37 59 244 158 107 250 115 10 217 92 80 131 138 135 152 29 82 192 155 248 139 80 226 178 130 60 115 10 139 15 6 232 90 60 73 5 167 81 53 103 255 74 22 240 28 115 48 19 0 229 236 173 45 7 112 11 57 161 185 187 128 21 64 118 255 76 105 19 192 185 203 150 70 200 72 187 116 93 110 10 250 16 63 26 239 120 115 100 41 121 254 40 147 2 36 0 111 6 21 71 73 197 152 81 245 25 202 50 5 184 98 48 41 163 68 0 25 81 1 110 97 11 72 73 52 170 216 145 73 165 88 29 66 179 6 145 10 82 240 67 135 173 67 92 76 139 101 33 107 230 162 46 22 147 164 53 197 97 84 17 141 136 68 203 28 234 37 33 57 205 172 218 117 26 186 116 169 66 201 138 144 37 60 114 159 150 193 219 37 225 186 35 127 212 245 174 204 48 97 92 50 249 33 147 245 237 24 108 8 98 177 40 118 145 39 164 108 153 244 138 228 90 17 187 141 245 177 47 86 207 105 203 5 62 59 191 188 113 246 180 242 192 74 9 154 182 173 5 44 86 0 186 51 18 105 72 249 28 218 1 168 95 115 73 43 106 119 235 11 252 33 175 149 24 24 163 2 54 56 187 20 182 111 125 115 65 161 183 148 27 43 188 201 48 148 94 255 84 69 95 211 170 219 167 20 14 127 140 29 129 76 193 1 92 222 50 129 88 17 34 193 0 60 219 26 51 162 80 111 173 81 31 0 248 199 63 168 150 114 36 231 85 165 102 78 49 128 7 56 192 1 15 32 33 0 28 224 186 4 0 119 83 20 32 128 3 48 112 223 160 150 96 192 251 141 193 188 94 32 96 239 94 193 166 34 100 128 126 67 176 150 193 141 119 185 207 33 165 109 219 11 85 245 170 111 126 25 14 173 211 62 17 128 7 236 48 0 14 128 23 127 31 235 183 179 84 173 193 241 66 112 92 136 244 128 22 195 227 111 165 50 11 66 106 12 16 148 206 152 46 62 238 241 33 248 43 14 31 111 12 127 92 9 242 89 238 33 227 34 99 132 184 14 214 42 98 238 43 195 244 193 111 0 243 219 18 134 209 184 49 254 41 135 141 83 226 31 108 51 140 59 211 102 194 0 35 254 80 141 239 139 95 18 18 57 1 108 150 64 2 236 251 0 1 60 32 191 49 6 0 156 241 235 52 252 174 249 206 8 190 115 126 239 59 104 252 22 134 205 15 64 177 255 125 1 80 99 2 208 185 48 123 126 64 154 81 244 104 196 72 128 1 141 169 244 157 41 109 232 253 18 58 210 252 120 244 5 230 28 231 120 137 26 30 116 158 112 148 133 16 68 19 104 134 148 133 49 227 252 86 248 89 254 141 177 185 122 211 48 153 127 41 10 75 83 96 205 36 44 49 138 219 119 105 32 37 90 207 194 106 114 131 225 60 18 30 55 26 193 41 102 180 64 152 93 226 185 32 6 192 251 45 140 179 179 157 179 26 83 155 199 114 38 225 91 236 220 236 0 88 122 131 68 118 64 110 7 236 0 113 31 155 191 231 94 154 176 245 220 100 34 59 154 2 150 46 113 118 87 237 135 243 170 194 215 226 88 51 113 248 11 111 65 231 23 198 134 81 246 128 125 189 109 95 91 154 199 12 15 55 0 208 220 233 109 131 219 219 250 5 119 92 238 156 0 129 240 23 205 27 207 175 199 181 109 112 110 195 152 191 118 22 185 5 96 140 112 70 79 64 227 68 230 54 191 41 225 239 83 216 153 26 32 143 185 186 63 174 95 63 33 120 45 45 95 118 198 37 255 80 99 242 72 28 226 67 215 51 99 86 76 100 139 27 9 227 68 207 201 24 157 102 0 7 120 49 178 73 227 246 177 227 98 114 104 3 137 31 89 135 19 130 91 126 236 18 83 32 186 49 159 185 218 49 0 103 97 205 217 227 240 102 247 91 76 236 232 67 207 171 221 2 54 139 208 163 238 114 59 67 168 206 46 87 58 223 11 90 112 109 207 197 219 240 147 176 224 3 47 103 248 49 28 226 142 119 51 188 68 120 24 185 231 204 235 148 183 116 90 241 126 223 197 234 57 241 36 252 79 213 15 83 99 126 172 253 244 221 28 33 81 24 35 97 62 216 251 179 113 129 115 176 21 255 33 18 66 72 2 208 54 12 236 17 124 251 4 79 220 134 178 95 176 8 19 108 238 118 67 116 135 77 46 126 2 14 225 107 229 67 212 1 233 144 61 31 252 139 34 253 250 215 249 200 6 136 8 141 126 123 236 247 190 234 29 175 126 128 115 74 254 242 155 255 252 232 79 191 250 215 207 254 246 187 255 253 240 143 191 252 231 79 255 250 219 255 254 248 71 156 17 210 254 133 255 18 111 87 5 141 129 122 2 184 3 139 22 6 118 166 106 45 240 127 3 184 128 12 216 128 14 248 128 16 24 129 18 152 7 44 214 65 255 113 1 21 56 129 26 88 52 106 178 0 161 244 58 77 101 1 88 86 26 23 118 1 41 180 129 40 168 43 35 37 20 1 160 74 147 193 55 164 145 91 62 19 91 113 97 49 181 130 55 2 225 90 102 52 23 255 161 101 68 145 129 41 24 132 72 96 46 224 164 128 186 7 15 5 99 91 194 133 92 198 165 62 200 53 25 183 227 50 73 85 102 235 229 92 39 197 84 193 17 31 176 34 132 92 104 4 231 131 24 180 151 33 147 150 25 121 179 55 110 180 94 33 150 51 240 181 79 63 102 70 4 80 94 91 102 70 114 216 26 176 101 132 93 120 135 59 0 66 123 230 62 26 96 63 72 84 130 179 115 134 241 21 90 123 163 92 102 38 107 177 22 135 84 232 111 53 135 135 142 232 3 248 179 96 28 96 25 108 132 66 202 129 14 170 34 136 33 230 70 99 166 28 57 211 31 114 200 7 230 85 91 84 232 134 85 246 250 136 168 200 4 237 148 52 243 49 63 231 165 137 39 164 62 186 118 66 94 100 63 102 132 70 231 37 135 222 178 138 209 149 138 190 248 139 192 24 140 194 56 140 196 88 140 198 120 140 200 152 140 202 184 140 204 88 11 52 33 25 68 97 122 205 56 141 68 128 21 195 34 2 183 248 66 218 192 73 212 248 19 59 242 133 118 120 1 217 56 98 252 128 18 145 245 33 55 102 11 30 212 141 62 241 133 34 132 128 28 128 55 109 177 62 57 67 74 94 196 59 188 147 25 150 81 54 173 64 62 236 200 18 122 216 69 135 165 55 129 181 62 45 88 24 126 104 70 172 53 70 246 19 107 91 40 10 254 248 143 43 225 23 16 50 144 168 212 52 103 232 70 10 25 67 41 36 143 178 176 142 18 121 38 227 8 0 238 161 143 104 212 70 236 245 28 80 166 10 90 20 146 123 49 146 227 69 74 2 177 145 105 100 57 50 121 11 22 233 146 58 185 147 60 217 147 62 249 147 64 25 148 66 57 148 68 89 148 70 121 148 72 153 148 74 185 148 230 16 1 0 59 )
!

eranovaLogoGif
	"'imgs/color-slo-small.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 161 0 40 0 135 0 0 35 38 39 39 42 44 39 44 46 42 44 45 41 45 48 41 48 51 45 50 53 46 53 57 48 52 54 49 54 57 49 57 61 54 60 63 54 61 65 56 63 67 57 65 69 61 68 71 56 67 72 60 68 73 61 71 76 61 72 78 62 76 84 65 70 73 64 74 78 66 76 81 65 78 85 68 77 82 66 80 87 70 80 85 67 81 88 69 82 89 74 83 87 72 83 89 73 85 90 74 86 92 76 86 92 74 88 95 77 88 93 75 92 101 76 90 97 78 92 99 77 93 101 77 95 105 80 92 99 81 94 101 80 96 104 82 101 110 85 98 105 85 100 107 86 101 109 88 100 107 89 103 110 93 104 110 85 103 113 86 104 114 87 106 116 88 104 112 88 107 117 91 109 117 94 105 112 92 108 116 89 109 120 93 111 120 93 113 122 93 114 125 95 117 127 96 110 117 101 112 118 96 112 120 97 115 124 97 116 126 100 115 122 101 118 126 105 117 124 118 118 118 119 119 120 118 120 122 121 122 123 98 119 129 100 118 128 100 120 130 101 121 132 102 124 134 106 121 129 106 123 132 104 124 134 104 126 138 108 127 136 119 126 129 123 126 128 103 128 141 106 128 139 105 129 141 108 130 141 106 132 145 109 133 145 109 135 149 111 137 151 119 128 132 124 129 131 124 133 137 126 136 142 113 134 145 113 137 149 113 138 152 114 140 154 114 142 156 117 141 153 116 142 156 125 140 147 126 142 152 118 144 157 122 145 156 126 144 153 125 146 157 117 146 161 119 149 164 120 146 160 121 148 162 121 150 165 124 147 160 126 148 160 124 150 164 124 152 166 122 153 169 124 154 169 125 156 171 126 157 173 126 159 176 127 160 176 190 157 92 163 157 127 182 155 101 182 156 106 188 158 97 186 158 104 181 159 112 174 160 118 173 162 125 187 162 109 189 161 105 191 163 108 189 164 110 179 161 117 179 163 123 186 164 116 186 168 125 218 155 54 216 156 59 223 160 60 236 153 26 254 152 0 252 155 11 245 155 19 242 156 25 251 157 17 226 153 39 228 156 44 238 158 38 229 158 49 241 158 32 255 161 23 253 162 27 236 160 43 229 160 52 226 161 59 232 161 50 232 164 58 243 161 38 242 162 41 250 163 34 240 164 48 212 159 70 206 160 79 198 160 91 204 161 86 202 163 91 201 163 93 204 163 89 206 164 90 205 165 94 214 160 71 212 161 76 219 161 68 217 162 73 218 164 75 217 164 77 211 164 84 208 164 89 217 166 81 217 168 86 216 169 92 195 162 98 194 165 108 198 168 109 203 168 102 192 166 114 194 168 115 205 175 118 210 172 105 225 164 67 130 132 133 128 134 137 129 137 140 136 139 141 129 140 147 132 144 150 130 147 155 138 146 150 136 147 152 142 159 155 146 159 153 159 159 146 129 150 161 129 153 165 133 152 162 132 154 165 129 154 168 129 156 170 129 158 173 132 156 169 132 158 172 138 155 164 136 157 168 128 159 176 143 160 158 147 161 156 152 160 147 153 162 152 155 164 154 157 165 153 130 160 174 133 160 170 132 161 174 141 162 165 138 162 171 129 160 176 132 162 177 137 163 176 138 166 180 142 168 178 146 164 164 162 156 132 163 160 133 164 162 138 171 161 129 169 163 132 172 163 128 170 166 139 172 168 142 163 165 146 169 168 144 178 165 129 178 169 138 180 176 151 166 175 166 171 175 161 33 249 4 3 0 0 128 0 44 0 0 0 0 161 0 40 0 0 8 255 0 1 9 28 56 80 93 34 93 158 64 89 90 200 16 148 167 88 195 126 117 98 72 177 34 67 95 2 195 237 58 37 239 15 193 116 144 106 113 74 5 42 212 169 81 186 18 169 251 227 81 224 31 107 212 98 202 140 185 141 229 53 102 98 144 137 73 102 141 160 79 64 127 252 80 35 147 19 25 178 43 202 218 112 107 57 144 221 204 153 126 6 254 121 42 147 219 207 106 108 146 93 49 122 148 12 28 109 76 127 226 163 116 201 162 89 75 154 92 69 18 117 182 98 32 64 138 202 90 18 212 18 222 173 182 11 47 197 58 55 80 91 146 191 128 1 179 201 150 44 48 224 49 97 93 102 35 163 196 176 225 100 217 8 110 115 252 183 218 64 107 148 149 44 21 232 167 25 22 202 129 201 104 251 73 206 20 222 182 154 130 193 58 109 169 81 35 138 130 4 218 195 196 122 97 39 112 2 241 128 78 194 134 201 110 103 62 255 56 107 188 27 48 147 56 3 117 83 222 12 136 25 101 49 30 95 126 46 14 248 74 228 129 246 228 214 54 139 139 216 105 99 218 231 254 255 217 23 158 117 39 190 206 65 251 222 141 88 42 25 234 134 153 100 99 25 39 115 84 64 235 166 27 118 198 18 14 124 195 100 12 132 200 118 167 173 242 11 94 154 84 36 136 58 9 18 184 208 47 127 136 241 31 101 203 248 17 93 27 19 6 198 140 71 221 80 134 133 57 2 93 147 25 136 212 100 24 152 64 249 56 120 218 48 164 16 40 200 107 102 221 178 72 37 103 117 98 14 113 148 53 3 7 142 134 93 49 16 54 60 26 7 7 27 234 173 3 136 51 148 49 193 18 32 68 58 166 204 31 218 172 103 24 22 113 140 177 27 32 230 124 82 91 38 149 148 103 209 37 247 120 121 150 32 45 126 233 13 32 143 180 133 25 104 108 176 132 12 104 1 10 84 24 101 112 0 226 87 102 124 48 73 89 50 45 233 23 152 53 127 96 72 89 77 122 92 9 12 107 164 132 195 206 31 240 224 114 218 46 181 108 39 72 38 102 129 194 14 32 227 180 53 205 110 212 252 193 206 110 205 176 164 77 144 127 41 49 218 100 160 245 241 71 147 134 133 193 18 55 73 70 255 229 39 96 88 120 84 205 149 90 226 149 73 58 4 161 51 17 106 250 72 74 155 69 161 24 25 78 91 241 20 9 8 54 187 225 33 144 127 207 121 132 100 146 139 66 67 25 51 2 77 11 224 31 204 82 70 134 71 245 101 150 226 105 178 252 116 32 94 251 228 122 218 62 13 86 84 73 70 109 209 3 26 98 83 237 86 19 32 111 122 203 18 171 83 122 148 158 97 109 254 49 167 97 150 105 107 88 157 128 52 3 154 24 231 226 133 200 79 145 156 230 10 43 8 170 34 73 62 98 190 11 72 57 109 61 2 218 134 205 129 134 197 55 128 124 10 26 127 128 72 168 47 32 86 58 86 231 141 142 213 10 200 123 131 10 164 178 99 100 148 137 23 45 133 244 236 115 46 167 149 226 200 89 154 60 130 142 71 239 180 75 145 198 13 91 116 8 104 157 254 145 175 99 99 132 184 219 53 118 146 250 87 27 2 181 108 24 30 47 81 198 6 80 55 7 166 132 71 37 130 6 71 42 42 110 135 201 60 103 221 179 164 64 224 68 99 247 221 209 128 51 207 40 120 17 255 2 218 82 235 104 157 4 215 128 8 234 152 18 70 162 74 89 53 30 45 67 217 29 33 59 86 211 31 124 84 110 185 229 212 36 35 120 18 213 136 217 246 151 255 152 133 201 162 63 125 180 8 42 172 13 146 164 71 138 59 6 232 31 94 27 6 29 32 208 58 38 31 217 148 157 243 205 172 73 136 81 58 80 217 176 193 187 99 230 124 190 157 56 102 169 242 59 126 243 216 226 185 69 134 236 217 223 110 163 253 33 165 97 27 254 65 179 99 208 177 116 61 96 218 220 234 24 127 76 65 9 71 217 197 213 106 124 109 200 91 68 74 98 2 221 195 150 131 209 59 70 248 246 253 2 2 43 212 2 13 159 68 156 127 88 130 237 180 161 48 195 104 70 42 216 32 195 247 168 243 164 231 173 111 33 237 171 136 36 230 38 144 117 244 162 45 182 104 75 253 8 198 18 244 1 70 25 2 73 27 101 34 99 142 223 8 132 29 188 99 194 58 6 6 152 100 88 8 63 205 16 92 1 41 195 181 80 176 166 18 155 200 161 14 119 200 67 29 114 34 83 22 153 196 79 255 134 118 22 71 28 235 44 134 32 149 57 254 176 142 221 32 236 95 241 49 146 8 29 195 184 63 124 99 129 88 200 6 169 128 3 148 218 25 144 26 226 163 12 214 60 193 154 123 44 239 140 227 170 136 16 125 194 55 179 204 2 16 71 52 203 34 98 102 171 221 88 6 118 11 203 22 104 148 0 34 64 244 129 50 202 240 226 95 150 0 22 44 45 48 9 74 216 70 225 246 120 52 93 176 38 17 247 57 227 79 236 97 150 53 18 100 88 22 129 7 32 164 209 150 57 110 107 145 160 49 146 245 64 19 42 60 70 75 32 127 164 26 254 254 242 36 129 24 14 96 44 89 37 96 102 71 201 211 252 2 98 163 200 165 46 119 57 10 96 180 162 146 62 113 135 210 24 162 137 149 196 209 34 158 12 12 194 100 249 151 217 181 206 48 212 232 223 199 90 114 39 195 196 208 49 209 148 19 104 176 129 59 111 69 165 29 14 180 132 40 22 197 20 157 157 101 17 156 0 38 65 146 102 150 80 92 234 152 21 73 38 96 176 246 7 255 197 105 138 134 137 76 53 169 56 255 144 118 80 102 106 198 153 219 33 149 4 8 116 8 142 139 128 184 203 105 130 49 55 72 176 134 31 103 177 164 64 216 105 145 84 188 179 147 60 66 92 65 77 120 36 145 69 5 159 128 81 66 36 195 104 54 199 100 15 16 207 60 12 218 118 195 205 140 132 211 18 157 168 69 45 126 133 151 99 200 34 162 62 161 104 69 64 129 142 77 182 133 17 178 11 225 110 174 195 175 192 204 174 168 45 156 219 29 38 100 25 129 132 203 164 30 153 97 20 9 242 203 7 82 228 18 236 194 41 65 132 121 22 120 252 33 141 22 1 106 104 252 165 44 150 129 6 26 29 4 13 227 146 243 31 153 9 4 138 202 236 38 247 194 130 14 50 90 117 33 192 56 70 91 38 145 24 76 86 228 24 136 144 196 79 247 211 181 133 45 9 174 180 122 3 98 255 210 158 129 116 8 62 32 19 72 24 22 166 216 221 124 43 44 233 72 167 85 93 33 12 188 72 84 32 243 107 155 88 1 19 153 122 126 108 32 6 155 80 22 41 40 72 208 220 75 178 38 10 76 54 125 162 142 85 255 172 239 18 195 232 172 103 205 101 188 209 38 129 160 251 163 140 179 4 18 37 19 97 161 169 4 65 170 99 194 224 147 216 153 232 58 165 171 199 41 84 116 9 91 232 131 18 172 249 44 32 224 225 215 138 152 130 109 102 241 237 24 62 106 47 169 164 182 56 98 152 79 98 94 121 178 176 156 55 164 82 13 12 65 151 135 142 121 228 162 187 95 18 5 48 248 193 139 151 90 66 187 128 200 135 186 40 82 10 117 128 55 172 129 9 152 114 147 128 133 66 186 4 15 135 12 12 22 156 97 164 210 89 171 56 74 128 110 5 153 137 5 107 176 55 169 146 60 33 57 232 177 136 87 244 34 23 189 136 69 33 30 161 15 127 244 163 24 39 230 133 140 103 76 99 26 15 131 130 5 121 196 49 50 161 9 76 144 2 18 32 130 196 34 134 76 228 33 231 195 25 72 118 198 117 174 145 228 38 59 99 182 4 17 10 51 146 129 133 37 88 121 39 109 184 6 201 150 199 100 39 59 249 117 63 185 6 81 150 192 132 49 56 227 27 127 240 134 151 145 124 13 248 133 248 255 205 112 14 177 59 220 28 231 58 19 132 37 120 182 179 158 93 146 231 61 251 249 207 128 14 180 160 7 77 232 66 27 250 208 62 241 66 9 126 16 20 40 12 196 209 3 73 131 27 232 44 201 52 156 225 140 118 240 194 239 206 224 134 42 32 250 211 160 254 201 19 50 96 7 22 216 192 11 35 168 176 28 74 6 20 12 184 65 32 62 216 67 5 103 61 144 42 156 129 137 2 49 129 26 8 82 225 10 211 0 10 158 106 9 57 231 208 7 57 80 58 212 200 254 243 31 14 16 149 46 80 64 3 27 200 192 23 124 144 5 24 196 192 3 127 88 64 20 76 80 134 0 148 97 2 72 120 128 30 118 224 2 11 176 196 13 3 152 194 13 92 176 129 111 32 96 7 14 232 195 5 140 80 129 62 160 224 5 25 248 67 4 248 176 129 25 188 128 223 51 80 128 30 56 112 6 20 80 97 5 18 152 67 178 23 30 232 60 64 64 32 44 120 66 3 252 224 132 30 56 192 11 5 72 65 2 212 48 128 19 252 193 12 29 224 131 2 254 96 129 50 8 32 5 5 255 200 19 31 34 176 6 2 164 192 0 102 184 0 32 22 64 7 9 0 66 2 92 0 193 31 46 128 135 8 156 192 11 127 96 0 10 170 176 142 4 112 161 4 37 224 2 0 82 160 0 48 48 252 233 123 214 195 200 211 112 128 53 48 128 228 111 112 0 13 136 112 13 42 152 32 10 13 248 195 9 182 240 132 26 248 33 2 78 24 2 54 166 224 145 31 180 160 8 68 168 134 21 80 224 133 60 76 160 5 79 176 131 4 122 80 132 62 52 160 7 57 216 183 23 58 96 129 57 60 129 5 27 64 195 3 186 16 130 118 72 1 234 144 183 51 15 46 16 130 57 112 65 6 36 0 66 19 108 160 7 16 132 160 14 65 248 6 17 220 0 5 25 28 65 15 117 120 2 31 68 16 2 52 8 228 11 36 176 131 8 64 128 134 33 248 65 13 92 216 65 31 206 16 133 61 124 128 4 104 56 2 31 204 240 129 21 236 65 11 42 48 0 29 132 96 247 63 140 0 4 91 136 188 244 253 108 134 7 240 225 216 160 238 195 3 116 96 130 63 204 193 1 95 88 94 2 64 0 0 59 )
!

ieBigGif
	"'imgs/ie_icon.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 35 0 34 0 135 0 0 27 67 106 45 70 89 45 74 94 55 77 92 56 78 95 44 75 98 32 79 115 42 80 115 44 86 126 46 90 126 52 81 101 59 85 97 48 85 114 48 90 125 59 90 114 60 94 122 61 98 122 66 92 102 69 96 106 72 101 111 68 98 114 80 111 126 89 115 121 29 85 136 29 97 155 36 90 141 37 91 145 37 98 143 35 104 153 54 102 143 63 105 138 55 106 150 56 117 154 39 120 170 34 120 177 49 111 163 48 114 163 57 120 167 50 124 190 43 126 197 71 106 131 66 110 143 76 113 135 68 114 146 73 122 145 74 122 154 82 113 128 90 119 128 91 124 131 84 123 144 66 127 183 37 129 182 49 132 188 57 129 180 58 132 189 38 138 205 45 133 198 45 133 201 37 134 210 37 137 212 37 142 220 42 134 213 45 134 219 42 138 212 42 143 221 39 148 219 51 132 195 53 137 204 56 130 198 58 134 202 49 134 216 54 157 219 46 139 225 37 147 225 38 153 226 43 148 229 46 150 232 41 155 229 45 154 232 54 142 225 49 143 232 51 148 228 50 148 234 50 159 224 51 155 236 56 145 229 59 155 234 57 157 241 57 167 220 44 166 233 38 164 243 37 171 249 40 172 247 45 177 238 51 164 233 57 166 242 57 179 237 55 182 245 59 193 245 95 132 138 87 131 157 91 132 153 93 136 144 92 136 155 69 134 180 67 130 185 69 139 189 78 133 177 79 139 183 73 146 179 84 131 162 87 142 167 86 142 170 91 142 161 87 143 180 93 147 171 83 151 178 101 132 139 108 138 142 98 133 145 99 139 144 108 141 147 107 146 150 117 147 148 115 155 157 122 150 148 126 155 149 124 155 153 102 152 165 104 157 187 114 159 179 115 162 172 123 165 166 120 163 175 117 166 191 64 134 193 66 138 196 69 151 198 66 152 223 93 159 198 64 149 224 72 161 200 69 162 219 91 170 201 82 175 213 90 184 216 70 164 234 78 171 233 64 162 245 68 172 247 67 171 248 73 175 248 73 186 231 66 177 246 64 191 247 72 180 246 73 182 248 74 185 247 88 177 233 83 180 243 81 190 248 95 184 243 97 158 196 102 168 197 105 181 202 106 186 216 112 172 195 113 181 202 112 191 204 120 178 207 126 188 195 120 185 203 119 184 211 98 179 227 68 197 245 75 211 247 83 201 235 88 195 249 85 214 245 89 227 249 116 194 206 122 197 212 96 197 225 98 198 250 105 215 245 118 205 238 120 214 249 100 233 252 105 241 251 120 237 254 118 247 254 129 156 151 132 163 156 137 167 157 140 171 159 130 164 163 133 168 162 130 168 171 137 171 164 141 173 169 142 178 172 140 186 185 144 171 161 150 180 165 149 182 173 150 184 175 153 180 167 152 182 169 156 186 171 158 189 176 161 190 173 161 191 176 140 189 194 154 198 189 164 194 175 164 195 178 165 203 188 169 198 178 172 202 181 171 204 185 175 209 190 177 207 184 180 209 186 185 214 189 188 217 190 137 198 203 135 198 212 141 211 217 146 194 195 149 202 207 157 205 201 148 206 217 146 210 209 133 204 243 134 213 231 128 216 250 152 215 230 149 216 243 141 224 232 137 226 253 135 240 254 149 226 232 157 233 253 152 240 254 165 204 193 166 208 198 172 209 194 162 214 213 177 212 193 182 216 195 184 215 192 189 219 192 165 231 252 166 248 254 180 254 255 192 220 192 33 249 4 3 0 0 255 0 44 0 0 0 0 35 0 34 0 0 8 255 0 255 9 28 72 176 160 193 131 8 19 42 36 136 143 156 169 81 163 200 45 156 56 240 91 181 71 144 34 141 162 211 6 75 155 102 221 192 81 60 8 238 98 36 90 128 198 224 225 195 7 80 34 61 215 190 237 155 104 207 92 57 113 226 106 209 34 133 201 150 25 24 122 140 117 19 152 141 212 27 102 67 19 238 171 119 174 221 188 121 240 122 237 154 245 234 21 172 70 115 136 73 155 249 239 27 74 100 221 184 26 196 119 142 159 191 126 80 125 241 218 245 202 149 24 49 154 192 36 34 164 109 32 171 65 200 184 33 180 199 206 159 191 121 239 220 185 227 69 85 76 152 46 136 195 132 57 2 8 90 183 124 166 134 53 243 38 118 32 190 190 254 222 169 187 119 15 87 97 196 89 186 100 201 242 5 204 148 51 207 178 37 51 150 77 95 229 127 250 250 246 91 167 46 95 57 92 175 192 96 81 162 100 116 150 38 77 72 127 57 146 7 218 181 107 220 94 255 35 215 175 159 174 113 251 106 201 122 133 101 6 7 14 34 130 40 1 222 196 137 151 47 153 74 252 255 186 230 77 100 65 110 234 250 229 66 183 15 149 44 89 88 72 192 248 229 39 15 139 27 220 153 120 255 98 69 133 51 202 6 81 243 78 46 225 252 227 158 44 96 132 96 65 54 3 45 243 70 16 77 44 225 4 19 84 124 81 201 7 125 100 99 30 65 226 228 82 14 56 170 192 34 139 43 93 24 208 71 82 2 5 131 131 19 75 48 65 225 21 150 216 240 130 52 223 20 4 78 43 225 148 4 75 91 135 113 0 194 27 115 4 57 7 28 57 48 209 226 139 150 56 66 193 127 5 97 115 202 55 250 68 210 22 24 162 41 17 68 16 60 4 1 196 150 75 28 41 197 21 87 84 242 137 3 202 132 68 16 54 216 252 115 138 43 36 138 198 93 119 78 196 233 162 139 95 130 121 201 45 14 248 81 151 65 213 96 162 73 24 163 53 161 196 14 58 232 176 67 15 63 244 160 104 15 62 24 129 196 19 85 72 18 202 3 123 104 104 16 36 127 186 105 37 6 23 100 144 129 6 26 124 234 233 167 160 114 240 193 7 14 236 161 205 134 2 37 3 134 38 154 42 255 145 4 0 126 36 165 220 72 143 252 249 197 111 178 46 145 129 48 222 16 116 204 26 105 200 144 134 26 137 136 146 138 33 198 88 35 211 153 175 134 225 69 22 113 46 145 68 15 119 64 19 236 63 221 8 226 3 20 95 126 17 203 59 242 4 114 135 179 5 153 162 88 24 187 82 193 98 151 39 144 193 140 54 219 8 210 3 184 95 124 1 202 58 253 180 243 0 12 232 14 164 143 35 97 76 225 68 190 94 76 104 36 20 72 16 113 72 17 223 86 168 175 46 253 240 227 198 0 170 178 74 143 23 97 100 176 193 119 95 92 49 161 20 224 66 1 174 20 21 110 18 139 46 243 240 147 74 0 46 48 73 16 57 91 76 81 0 5 53 88 145 239 21 84 80 33 197 207 40 231 219 201 45 235 180 204 74 1 18 4 179 106 65 171 108 65 131 2 118 252 129 70 20 148 80 2 230 213 148 124 193 73 44 184 144 219 78 32 10 68 208 71 192 4 157 178 5 9 20 108 5 141 27 38 60 97 69 213 148 84 194 9 40 183 232 178 78 58 169 180 16 192 4 126 56 150 203 170 64 102 143 80 193 182 208 228 177 194 8 68 48 162 136 36 147 120 210 74 43 139 164 80 192 2 47 8 147 205 55 127 11 68 141 22 52 184 176 237 63 210 0 211 66 7 8 28 128 64 2 13 48 160 192 0 18 192 0 12 52 218 212 136 16 62 63 104 81 67 49 250 216 67 142 33 139 200 17 3 12 99 212 33 188 29 121 0 179 140 52 218 148 183 80 33 57 240 192 195 15 67 32 194 70 25 121 28 19 141 52 211 92 99 205 53 217 36 143 57 69 222 28 67 70 10 30 160 240 66 29 192 100 227 141 55 223 180 143 185 72 183 142 36 255 66 1 1 0 59 )
!

infoBigGif
	"'imgs/info.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 35 0 34 0 135 0 0 1 1 61 1 1 73 9 27 70 13 30 74 1 18 80 3 30 88 1 1 100 1 8 101 1 11 110 1 12 125 1 25 127 14 35 81 19 38 77 20 41 83 25 45 84 27 49 87 28 50 88 20 52 110 27 54 100 31 56 112 33 52 90 37 56 93 35 59 98 33 60 106 40 63 103 35 64 110 43 67 102 45 66 101 38 68 115 41 76 124 51 69 100 50 71 105 55 73 102 57 77 109 50 75 117 54 81 127 62 83 121 68 86 111 67 90 121 76 99 126 82 100 122 1 28 131 1 28 139 1 33 141 5 45 129 1 39 146 1 43 151 1 43 154 3 49 143 1 48 156 25 63 137 1 48 163 11 63 166 29 68 141 27 74 170 27 79 189 28 81 190 44 74 132 32 72 147 50 80 133 62 95 135 61 100 149 63 98 155 41 94 204 44 96 204 64 99 142 75 101 135 66 99 155 89 108 129 82 110 149 95 112 131 93 117 141 78 109 162 87 125 167 99 119 137 103 123 138 105 124 138 97 118 150 96 127 163 87 128 172 93 138 185 109 128 142 110 132 147 113 133 147 124 142 150 100 136 172 106 129 167 97 138 180 104 140 177 102 145 190 109 146 185 113 138 180 114 144 179 112 149 190 123 155 188 79 134 223 82 133 227 100 135 201 106 141 193 117 150 201 116 154 192 123 149 192 120 151 200 124 154 201 111 161 214 121 160 198 113 161 212 115 170 223 125 168 215 128 146 154 136 154 159 137 155 160 128 153 177 128 159 191 136 156 189 143 161 164 132 162 191 145 162 165 150 168 170 155 173 171 150 174 180 170 175 189 165 182 178 174 191 183 173 190 184 133 157 199 131 157 200 130 163 196 129 165 206 132 169 202 139 170 196 139 172 203 129 168 218 138 175 212 140 178 211 148 173 194 146 174 204 153 174 194 153 174 212 147 177 205 154 176 195 154 178 203 146 180 212 147 182 216 150 184 219 152 182 211 158 185 213 155 187 216 146 188 227 162 183 204 166 185 202 171 187 195 169 187 201 163 189 212 178 191 205 177 195 188 178 196 188 180 197 188 158 193 229 156 196 236 157 193 241 173 195 195 167 192 214 172 197 219 180 195 205 185 195 205 187 204 194 177 196 213 176 198 222 180 201 223 184 198 211 188 201 214 163 196 229 164 198 232 170 198 226 170 199 232 172 201 231 163 203 244 165 207 249 167 209 253 172 210 250 180 204 227 180 207 235 184 206 228 188 210 229 178 212 245 176 212 248 182 216 241 180 217 252 185 215 246 185 216 245 187 221 253 189 226 255 195 205 215 193 209 197 198 216 206 201 218 203 197 210 210 192 210 218 202 211 221 210 214 220 210 216 221 220 222 222 198 217 235 203 220 238 196 218 243 194 222 250 220 222 224 207 224 208 208 224 207 208 225 208 212 228 209 215 231 212 214 233 223 219 235 214 223 239 217 196 226 254 202 228 254 205 232 255 212 227 228 221 227 235 223 236 229 219 234 236 210 226 242 209 230 253 211 234 254 218 230 243 221 233 244 219 237 254 211 243 255 220 241 255 223 249 255 224 240 217 226 242 220 227 244 221 230 246 221 231 248 223 228 228 226 225 229 233 230 232 235 232 231 231 236 237 237 227 235 243 225 239 255 230 246 226 227 242 254 227 250 255 234 245 254 236 250 255 240 240 238 245 245 243 241 246 251 243 251 254 249 248 246 253 254 254 0 0 0 33 249 4 3 0 0 236 0 44 0 0 0 0 35 0 34 0 0 8 255 0 217 9 28 72 176 160 193 131 8 19 178 163 183 205 93 188 135 249 30 202 243 54 44 154 66 133 197 144 233 219 232 175 163 199 126 253 252 241 187 100 241 34 193 110 238 64 246 227 231 177 84 30 125 30 249 133 28 105 82 224 54 120 249 96 122 244 71 2 0 128 2 33 61 238 219 231 111 149 169 139 219 218 189 35 186 243 88 128 20 42 12 108 217 41 82 30 63 102 124 18 38 93 26 147 165 188 3 49 190 204 80 36 242 30 75 127 251 228 221 27 181 231 96 53 101 238 152 242 219 199 175 174 191 62 54 192 132 41 123 175 47 203 123 227 238 193 57 90 240 216 51 121 29 231 210 197 119 86 36 223 123 245 34 179 28 55 110 217 148 130 213 144 113 187 135 246 30 62 207 68 207 242 235 107 47 242 188 211 230 248 225 251 102 174 201 29 130 198 146 113 171 219 183 54 62 43 19 114 236 136 64 64 14 191 122 243 204 145 27 94 15 31 184 111 163 148 148 100 87 234 216 184 207 145 33 123 238 195 34 129 138 21 8 202 240 19 62 156 92 184 112 246 192 45 255 195 21 34 171 192 82 193 196 65 54 61 79 50 63 29 45 98 164 240 195 207 187 247 239 225 204 125 195 133 139 194 156 129 165 172 242 205 61 168 205 67 142 57 230 212 195 15 18 41 200 119 6 62 247 129 19 14 56 18 102 115 11 46 16 184 49 16 41 2 34 216 221 112 249 225 51 68 131 41 60 24 142 54 218 128 131 162 54 225 56 115 203 45 15 104 40 144 37 170 48 195 221 125 223 145 99 207 136 242 153 97 207 137 217 100 163 77 144 218 52 83 139 43 49 14 148 137 38 198 128 131 227 132 223 157 195 99 10 62 14 153 13 54 87 94 105 11 42 143 100 56 80 40 152 156 210 204 119 43 170 24 206 57 62 144 56 198 57 87 98 227 166 155 189 184 50 74 17 14 212 49 16 52 162 96 146 74 54 42 90 41 164 57 105 202 55 134 57 111 2 99 232 47 175 100 226 200 5 32 152 39 208 33 150 88 82 11 54 67 186 41 164 148 41 184 160 128 24 246 96 3 204 47 191 96 195 203 43 146 76 146 196 0 75 72 67 144 53 116 36 82 73 45 206 96 255 233 166 54 190 200 16 3 13 46 212 176 139 167 191 0 51 106 36 139 144 177 128 7 119 168 83 80 40 130 28 210 136 43 190 184 89 14 32 7 188 112 3 16 63 224 0 3 33 162 234 194 138 35 139 164 145 129 3 83 44 71 16 30 94 48 210 136 36 172 228 2 140 46 160 240 34 75 44 177 0 51 139 44 186 180 2 201 34 139 116 193 1 3 70 152 178 206 65 235 216 81 69 178 136 68 50 73 186 188 248 98 232 186 158 56 130 200 32 129 60 209 64 3 68 108 98 44 66 233 232 113 4 22 116 8 34 72 32 129 12 98 136 39 180 196 2 201 195 127 92 193 193 2 21 68 209 201 197 9 173 35 12 21 66 240 224 132 23 94 196 17 199 32 159 124 82 136 22 65 116 32 0 5 40 212 65 76 77 2 89 211 9 21 68 152 128 129 8 92 240 28 11 32 18 48 224 1 17 111 8 99 13 210 171 90 99 141 41 37 140 80 8 37 179 176 81 1 19 124 16 131 14 215 9 17 227 65 22 148 196 162 198 6 175 177 125 17 31 26 64 17 11 26 22 216 30 97 183 73 166 156 160 198 26 22 252 247 183 73 82 244 176 129 157 135 155 164 71 27 156 52 46 185 65 1 1 0 59 )
!

javaBigGif
	"'imgs/sunjava-java_logo.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 38 0 66 0 196 31 0 254 35 13 52 71 158 255 145 134 154 163 207 205 210 231 254 49 28 255 228 226 254 76 59 254 115 101 103 117 182 255 173 165 255 242 241 255 201 195 230 233 243 255 214 210 243 244 249 254 90 74 254 63 43 128 140 195 192 198 225 116 129 188 77 94 170 254 132 119 255 187 180 167 175 213 179 186 219 90 106 176 255 159 150 218 221 237 141 152 201 65 83 164 255 255 255 33 249 4 1 0 0 31 0 44 0 0 0 0 38 0 66 0 0 5 255 224 39 142 100 105 138 203 169 174 236 136 180 112 252 33 151 108 159 136 112 239 227 161 243 55 3 96 3 188 65 0 142 162 108 3 128 40 99 10 0 242 217 18 72 21 212 213 2 33 125 161 20 8 98 214 113 144 90 68 6 75 1 145 202 50 10 87 145 160 80 168 101 63 81 64 33 185 40 31 12 119 31 14 112 123 31 125 0 7 109 119 17 82 118 22 122 138 89 66 136 40 93 129 34 14 82 63 12 150 151 31 112 155 82 5 128 151 86 94 159 157 129 11 116 109 86 82 98 129 153 94 11 140 122 158 120 0 118 131 82 183 120 5 109 143 17 189 120 94 86 118 74 13 25 3 20 24 36 12 34 7 167 35 29 9 21 1 20 15 43 15 25 26 1 18 28 42 2 88 43 18 1 26 42 13 30 1 222 224 42 15 4 4 202 20 9 18 13 36 214 4 42 3 214 235 253 254 255 21 40 12 104 71 162 91 62 22 240 148 13 88 184 48 3 60 123 43 26 172 203 214 162 193 0 32 15 186 93 108 49 193 27 139 6 4 6 80 20 145 49 192 198 22 24 250 255 85 72 192 178 101 183 126 30 154 125 152 224 33 1 65 24 19 36 240 251 183 142 30 134 118 29 58 64 4 2 18 30 129 155 119 8 72 24 70 130 67 0 15 29 6 24 77 56 32 1 133 131 200 118 242 244 183 244 198 131 9 11 39 136 200 64 65 235 186 128 24 134 146 24 89 130 0 5 111 19 216 142 40 42 247 68 7 172 35 50 172 235 144 133 67 135 10 106 69 188 237 151 96 0 134 135 238 140 98 88 150 192 28 134 108 19 240 126 8 41 33 129 186 173 152 3 172 28 48 193 222 182 4 231 90 188 131 183 152 225 66 163 67 27 128 109 236 225 228 138 9 212 36 152 142 172 112 225 188 151 53 165 238 0 9 214 180 239 195 146 153 10 47 162 0 130 147 225 174 134 127 72 142 156 23 10 6 208 73 25 128 78 194 1 3 82 11 160 95 255 96 192 1 41 57 188 12 148 145 98 6 215 20 17 154 196 147 239 114 1 192 15 240 0 12 173 17 32 224 72 174 73 103 184 55 250 148 163 126 156 18 204 145 176 138 123 31 248 33 66 123 0 124 55 2 159 40 38 4 72 194 17 58 48 145 224 114 0 8 99 2 132 13 58 103 0 2 112 144 167 67 38 67 20 8 128 23 27 214 162 73 134 241 237 18 129 5 2 48 242 3 35 16 44 176 159 1 112 172 216 34 129 0 242 194 197 113 31 96 248 193 35 0 68 81 128 8 92 28 48 130 143 36 36 119 68 126 34 134 162 199 136 34 28 113 74 25 239 141 144 28 23 5 40 160 192 120 239 117 8 192 51 51 92 177 229 137 57 166 232 101 1 84 186 32 133 133 130 156 153 102 9 101 28 103 192 6 226 44 48 221 119 211 109 55 194 156 117 222 89 66 30 85 222 34 161 145 194 57 16 65 160 183 132 0 0 59 )
!

noteSmallGif
	"small triangle with !! for notes/comments"
	"'imgs/simplebits-note_icon.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 12 0 12 0 162 0 0 227 203 118 250 226 142 51 51 51 204 153 102 255 255 255 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 12 0 12 0 0 3 42 72 170 51 251 44 194 24 220 116 33 219 231 132 168 16 230 105 28 17 140 32 117 126 1 96 97 89 236 18 86 134 182 13 1 236 60 239 52 192 160 35 1 0 59 )
!

outlookBigGif
	"'imgs/outlook_icon.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 30 0 30 0 135 0 0 128 128 0 153 153 51 204 204 153 192 220 192 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 3 0 0 3 0 44 0 0 0 0 30 0 30 0 0 8 206 0 7 8 28 72 176 160 193 131 3 1 40 92 200 176 161 195 135 2 31 74 156 200 48 34 197 139 14 45 2 32 192 177 163 199 143 32 9 44 212 232 81 64 128 133 1 4 132 244 56 114 192 194 142 39 29 6 88 201 177 229 75 2 49 85 114 20 160 112 230 74 155 10 9 240 220 40 146 104 81 157 32 129 110 60 169 51 232 78 0 62 147 42 36 233 180 40 75 163 31 149 90 173 201 112 171 84 0 84 141 54 44 250 144 44 73 166 33 135 150 213 58 52 164 66 164 92 205 186 116 154 179 227 80 159 47 131 106 229 24 179 97 212 188 27 247 114 69 9 23 176 220 155 113 105 118 212 59 117 46 86 198 14 175 30 174 106 85 162 100 193 94 21 67 38 185 24 99 87 204 158 63 55 70 172 152 38 230 210 110 71 135 246 172 113 53 197 214 174 37 34 156 77 155 96 64 0 59 )
!

printerJpg
	"'imgs/toledo-printer.jpg' asFilename contentsAsMethod"
^#(255 216 255 224 0 16 74 70 73 70 0 1 1 1 0 72 0 72 0 0 255 219 0 67 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 219 0 67 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 192 0 17 8 0 22 0 20 3 1 34 0 2 17 1 3 17 1 255 196 0 31 0 0 1 5 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 2 3 4 5 6 7 8 9 10 11 255 196 0 181 16 0 2 1 3 3 2 4 3 5 5 4 4 0 0 1 125 1 2 3 0 4 17 5 18 33 49 65 6 19 81 97 7 34 113 20 50 129 145 161 8 35 66 177 193 21 82 209 240 36 51 98 114 130 9 10 22 23 24 25 26 37 38 39 40 41 42 52 53 54 55 56 57 58 67 68 69 70 71 72 73 74 83 84 85 86 87 88 89 90 99 100 101 102 103 104 105 106 115 116 117 118 119 120 121 122 131 132 133 134 135 136 137 138 146 147 148 149 150 151 152 153 154 162 163 164 165 166 167 168 169 170 178 179 180 181 182 183 184 185 186 194 195 196 197 198 199 200 201 202 210 211 212 213 214 215 216 217 218 225 226 227 228 229 230 231 232 233 234 241 242 243 244 245 246 247 248 249 250 255 196 0 31 1 0 3 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 2 3 4 5 6 7 8 9 10 11 255 196 0 181 17 0 2 1 2 4 4 3 4 7 5 4 4 0 1 2 119 0 1 2 3 17 4 5 33 49 6 18 65 81 7 97 113 19 34 50 129 8 20 66 145 161 177 193 9 35 51 82 240 21 98 114 209 10 22 36 52 225 37 241 23 24 25 26 38 39 40 41 42 53 54 55 56 57 58 67 68 69 70 71 72 73 74 83 84 85 86 87 88 89 90 99 100 101 102 103 104 105 106 115 116 117 118 119 120 121 122 130 131 132 133 134 135 136 137 138 146 147 148 149 150 151 152 153 154 162 163 164 165 166 167 168 169 170 178 179 180 181 182 183 184 185 186 194 195 196 197 198 199 200 201 202 210 211 212 213 214 215 216 217 218 226 227 228 229 230 231 232 233 234 242 243 244 245 246 247 248 249 250 255 218 0 12 3 1 0 2 17 3 17 0 63 0 254 205 254 42 248 150 223 225 223 197 164 93 102 105 46 244 31 136 158 17 147 94 211 18 238 254 241 97 208 252 73 224 43 237 63 68 214 173 99 34 230 24 173 237 252 71 163 120 191 68 190 210 236 98 24 55 62 26 241 93 244 155 140 200 34 229 126 19 124 105 117 253 160 238 188 7 37 196 255 0 240 175 190 32 252 59 26 247 132 181 11 155 139 137 180 93 39 226 103 131 53 147 99 226 111 6 218 106 183 114 73 109 30 173 226 239 7 235 26 87 138 244 79 14 165 201 190 189 183 240 71 143 181 123 75 87 180 210 245 57 45 190 102 241 254 183 30 181 226 47 136 94 33 248 185 55 196 63 7 90 106 255 0 16 126 34 248 58 215 197 119 26 222 181 109 240 235 89 240 87 194 223 138 94 59 208 188 45 163 105 154 239 132 245 43 221 47 193 239 6 139 100 210 106 122 30 191 31 132 124 109 172 234 218 150 179 172 120 58 227 84 212 144 220 105 158 7 175 254 208 191 0 175 109 78 145 240 235 225 245 231 142 32 136 188 95 240 144 234 22 158 34 214 244 141 57 132 13 9 212 127 225 97 252 81 215 244 123 61 46 242 202 218 121 26 41 238 175 36 241 21 128 103 146 207 66 186 12 209 201 239 75 52 203 231 147 44 12 178 185 60 198 209 143 246 146 197 168 193 66 157 104 78 31 236 107 12 249 167 236 99 236 37 47 172 71 79 222 107 38 209 229 172 22 49 102 127 92 89 132 150 13 198 207 47 116 28 147 147 167 200 218 174 235 174 85 237 57 106 164 168 189 83 141 236 238 191 160 10 43 241 175 246 28 253 178 124 109 227 31 134 190 55 182 212 116 169 47 52 191 7 252 80 191 240 207 131 207 136 245 185 53 237 106 223 194 23 94 4 248 127 227 45 34 11 205 114 218 218 198 61 86 47 51 197 183 115 233 211 165 172 22 214 218 84 246 58 118 153 20 122 69 150 159 26 21 243 240 148 103 8 206 46 241 156 99 56 187 53 120 205 41 69 217 164 213 211 78 205 38 186 164 207 77 53 40 198 73 221 74 42 81 125 212 146 105 217 234 174 154 118 122 247 62 203 248 175 251 47 248 138 254 251 198 158 45 248 17 241 22 79 135 218 255 0 143 45 117 51 227 127 135 94 50 178 159 198 223 2 188 125 171 234 54 115 91 73 226 61 71 194 82 220 65 173 120 7 198 51 23 140 223 248 179 225 158 181 225 248 252 67 177 102 241 223 134 252 111 113 109 166 201 97 249 109 225 63 248 36 79 237 11 23 139 244 255 0 29 248 255 0 226 183 192 63 21 120 147 80 182 182 131 81 130 227 195 63 23 117 63 1 252 62 22 75 50 66 124 25 240 230 247 199 22 154 95 139 238 164 136 219 43 203 174 234 190 18 209 37 187 130 107 237 95 195 26 242 94 77 96 10 43 69 38 148 146 229 247 151 43 188 99 38 149 212 189 215 36 220 29 210 247 160 227 43 94 55 229 148 147 127 215 245 223 230 126 161 124 27 253 136 62 28 124 42 240 222 167 166 234 254 40 241 175 196 143 18 248 143 94 147 197 30 41 241 126 187 54 129 225 79 237 29 102 77 23 68 240 250 71 163 120 59 225 190 135 224 239 2 248 63 195 246 58 71 135 180 171 45 43 195 158 25 240 237 134 159 99 20 12 248 158 230 121 238 37 40 162 164 15 255 217 )
! !

!WebStyle methodsFor:'imgs-filetype icons'!

excelBigGif
	"'imgs/excel_icon.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 34 0 32 0 135 0 0 0 0 0 0 128 0 128 128 128 192 192 192 192 220 192 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 3 0 0 4 0 44 0 0 0 0 34 0 32 0 0 8 255 0 9 8 28 72 176 160 193 131 8 13 10 88 200 176 161 67 134 9 15 10 40 64 177 162 197 139 5 4 0 136 88 112 34 198 143 20 23 110 84 24 64 64 201 147 38 83 158 4 41 96 128 70 131 40 99 170 76 57 160 102 205 138 19 93 142 28 104 18 164 197 158 31 61 234 36 88 178 0 74 156 69 139 6 173 56 84 96 207 153 25 87 154 180 73 85 39 128 171 88 5 38 53 58 51 105 75 139 3 192 50 29 9 52 0 215 163 81 195 50 21 75 113 192 72 165 70 207 122 228 90 181 238 88 167 102 207 202 53 59 149 109 219 187 4 188 174 60 90 82 237 223 181 109 201 242 141 169 119 106 93 170 128 5 171 60 91 216 111 1 195 110 241 6 69 217 23 241 225 203 111 231 250 44 252 216 38 224 174 168 79 26 190 12 50 115 224 212 168 87 51 189 153 56 225 220 199 151 105 155 174 141 240 54 219 221 187 65 219 246 204 58 183 93 222 18 103 87 53 222 150 182 240 222 196 213 2 119 238 58 249 231 226 211 49 239 84 168 188 244 241 234 220 125 138 23 71 30 126 188 79 240 29 189 171 167 186 189 32 214 247 240 227 203 231 72 159 126 64 0 59 )
!

excelSmallPng
	"'imgs/ikone-dok/corendal-excel.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 130 73 68 65 84 120 156 98 248 15 3 155 14 221 216 120 240 250 134 3 215 214 237 187 178 118 239 165 213 187 46 174 218 121 126 197 182 179 203 182 157 94 186 229 212 191 127 80 101 0 1 196 144 187 33 61 115 109 82 234 242 232 248 133 193 81 179 60 131 39 59 248 246 152 185 183 234 58 53 168 218 85 203 125 254 254 239 237 151 191 115 86 31 48 247 78 253 7 214 4 16 64 32 13 255 113 0 227 2 222 47 223 255 189 255 242 119 234 146 157 187 142 94 129 232 1 8 32 144 134 201 135 250 82 86 36 4 77 247 0 42 58 115 235 116 220 140 80 32 154 179 97 182 113 46 223 151 31 127 223 127 253 59 121 209 118 160 106 8 2 8 32 134 244 85 241 79 223 60 157 124 164 55 107 77 170 83 167 105 201 210 130 196 5 17 238 29 214 215 30 93 51 206 228 159 176 238 26 4 45 221 115 103 201 238 187 64 13 0 1 196 144 184 40 4 104 240 249 187 231 103 29 155 22 189 40 194 170 86 221 40 67 227 192 197 3 64 65 147 100 193 207 63 64 78 2 106 120 248 230 207 194 93 119 205 188 82 0 2 136 33 98 134 59 80 110 194 222 238 136 121 65 211 142 76 4 234 177 46 84 42 152 157 123 255 229 125 147 56 17 184 13 247 95 253 158 187 227 30 80 3 64 0 49 248 247 89 2 85 219 148 203 91 229 203 153 37 75 3 217 30 147 236 173 51 228 22 110 158 111 18 33 10 52 254 213 71 144 13 119 95 254 158 185 237 1 80 3 64 0 49 184 181 232 32 135 76 251 202 86 203 2 57 211 56 169 132 186 24 147 32 113 184 13 183 158 253 158 186 249 17 80 3 64 0 49 216 215 42 226 10 86 83 95 137 23 239 255 60 122 243 231 206 139 223 215 158 252 234 223 248 24 168 1 32 128 24 172 202 37 129 225 109 146 203 7 12 19 147 20 33 147 56 97 160 75 76 130 197 77 124 37 77 61 165 128 170 239 190 248 13 180 225 210 195 95 93 235 158 0 53 0 4 16 3 220 188 153 43 246 189 248 240 247 229 135 191 64 242 249 251 63 79 223 254 121 248 26 164 244 250 211 95 64 242 220 189 159 173 107 158 1 53 0 4 16 66 195 180 101 187 31 189 249 13 119 52 200 221 207 127 193 217 167 110 255 104 92 254 28 168 1 32 128 16 26 128 241 15 244 217 173 231 191 111 62 251 125 227 233 175 107 79 126 95 126 244 251 194 131 159 103 238 254 56 121 251 231 241 91 63 106 150 188 4 106 0 8 32 132 6 96 252 95 122 244 107 222 142 251 192 224 155 186 229 209 196 141 143 122 214 63 233 88 251 180 101 245 179 134 229 207 171 151 190 168 88 252 26 168 1 32 128 16 26 128 28 98 16 64 128 1 0 75 134 252 209 86 255 47 249 0 0 0 0 73 69 78 68 174 66 96 130 )
!

imageSmallPng
	"'imgs/ikone-dok/corendal-jpeg.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 149 73 68 65 84 120 156 98 248 15 6 237 43 239 160 161 142 213 247 90 22 95 3 50 94 127 252 249 31 9 0 4 16 3 92 195 127 84 240 239 223 255 159 127 64 226 229 91 94 165 148 246 174 218 176 251 193 227 231 63 126 254 2 8 32 236 26 32 170 191 252 250 239 178 236 59 16 57 77 126 80 215 62 253 224 209 115 111 222 125 4 8 32 132 134 95 191 126 161 169 126 251 237 255 153 171 32 180 106 243 215 250 206 45 211 231 173 186 126 243 62 64 0 33 52 252 248 241 227 255 252 138 239 185 166 255 75 205 255 247 187 253 95 19 250 255 96 226 163 143 255 239 188 251 127 237 245 255 93 39 191 20 86 117 29 58 118 22 32 128 16 26 190 125 251 246 191 61 108 103 130 225 255 114 203 255 211 60 255 111 141 250 127 119 230 255 243 101 127 87 133 76 92 123 110 239 217 207 9 25 149 219 119 31 6 8 32 132 134 207 159 191 108 183 50 202 55 209 216 100 42 124 194 90 230 170 147 252 171 72 173 119 177 58 183 61 149 218 231 30 223 117 230 115 84 114 201 150 29 7 0 2 8 161 225 221 135 79 15 38 198 205 138 54 90 144 164 243 166 217 244 115 143 249 247 125 169 95 187 205 95 181 219 119 172 60 183 253 228 39 136 6 128 0 130 106 104 94 116 245 229 155 15 215 23 214 111 175 13 78 118 214 187 61 33 252 217 204 144 111 87 170 190 223 174 191 57 57 161 121 229 149 173 39 160 26 0 2 8 170 161 113 206 249 39 47 223 29 154 51 117 87 71 85 132 163 203 246 230 130 203 243 75 158 30 107 122 123 170 230 224 132 218 154 229 183 54 30 253 8 209 0 16 64 80 13 181 83 79 220 127 246 102 205 244 53 253 181 75 115 50 119 44 107 155 242 248 72 211 175 231 109 255 159 53 108 157 62 185 116 233 189 245 135 63 64 52 0 4 16 84 67 85 255 161 219 143 94 205 152 116 168 171 113 219 132 198 245 147 155 214 172 154 48 251 230 174 182 39 7 234 230 246 172 40 89 241 108 245 65 168 6 128 0 130 106 40 235 216 125 245 254 139 139 47 254 174 187 244 109 229 133 111 75 206 126 91 112 250 219 156 147 223 166 31 255 54 249 200 183 165 23 255 174 216 255 30 162 1 32 128 160 26 138 155 182 94 188 253 236 226 139 255 103 158 253 63 250 232 255 193 7 255 119 223 253 191 237 214 255 141 55 254 175 186 242 127 233 165 255 75 247 190 139 78 41 221 186 243 32 64 0 65 53 228 215 172 155 187 246 230 172 21 215 102 44 187 60 125 201 165 153 11 207 76 159 119 114 218 156 99 83 103 30 153 60 237 96 247 196 109 221 125 59 210 11 234 119 237 61 10 16 64 80 13 103 206 95 233 155 178 32 45 191 14 104 12 208 106 52 4 20 4 74 1 21 0 149 1 4 24 0 49 85 52 237 131 13 12 50 0 0 0 0 73 69 78 68 174 66 96 130 )
!

multimediaSmallPng
	"'imgs/ikone-dok/corendal-wave.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 143 73 68 65 84 120 156 98 248 15 3 237 43 239 160 161 142 213 247 90 22 95 43 105 216 116 247 238 221 175 95 191 66 148 1 4 16 3 92 195 212 67 95 255 254 251 143 9 128 26 10 23 159 56 122 244 40 68 15 64 0 33 52 76 218 251 1 168 1 19 101 101 207 222 119 234 191 211 212 39 16 61 0 1 132 208 208 191 245 5 80 250 231 159 255 63 254 128 72 56 3 168 1 130 106 27 87 3 245 0 4 16 66 195 132 29 175 222 205 153 0 68 83 118 39 47 221 183 98 201 201 55 39 159 254 255 252 243 255 231 31 32 18 104 73 85 221 242 206 206 78 128 0 130 106 248 182 116 210 207 16 157 255 110 74 64 84 124 128 49 101 33 99 65 191 209 244 157 231 151 93 253 255 250 219 255 55 95 255 239 61 245 191 164 98 113 97 97 33 64 0 129 52 124 95 53 253 79 144 250 255 134 248 175 179 59 239 110 234 88 117 43 170 110 47 95 204 36 198 168 114 217 174 237 119 55 220 250 255 228 211 255 93 167 254 231 23 205 3 106 0 8 0 49 0 206 255 0 248 235 231 247 88 47 255 125 91 244 175 155 144 146 146 214 220 226 240 235 248 211 225 189 125 173 37 81 120 1 102 123 97 119 192 254 219 237 255 183 204 255 104 106 151 113 113 113 2 136 225 203 250 57 127 60 197 255 79 46 251 246 249 109 94 94 30 80 104 222 188 121 239 95 127 219 113 126 114 116 179 136 109 132 66 214 238 255 151 95 254 223 114 230 127 98 242 4 160 44 64 0 49 108 158 181 74 189 246 126 252 214 159 16 13 106 106 106 140 140 140 201 201 153 64 61 47 15 171 28 95 46 149 177 231 223 153 167 255 55 156 253 31 29 211 13 212 0 16 64 12 109 171 111 179 86 125 128 104 48 51 53 145 145 145 169 171 175 191 126 235 241 255 191 47 63 157 182 4 106 72 217 245 239 200 163 255 107 207 254 15 11 107 7 106 0 8 32 134 163 103 238 200 38 156 6 90 178 254 236 91 160 99 174 93 189 4 10 181 191 47 95 95 74 1 218 48 165 221 56 117 215 191 253 247 255 175 62 251 63 40 168 25 168 1 32 128 24 126 252 248 30 152 187 69 208 247 152 81 225 229 238 245 111 79 92 121 244 253 217 194 215 23 18 94 157 48 59 177 136 189 112 230 198 190 99 255 79 221 248 191 242 28 84 3 64 0 129 130 245 254 253 135 22 126 11 197 172 182 200 187 29 1 162 87 199 244 95 31 81 60 182 144 179 36 55 54 45 99 74 124 226 132 152 152 158 136 200 206 208 176 54 160 6 128 0 130 70 220 253 251 247 138 203 103 169 27 76 80 55 232 235 169 214 238 169 210 206 206 72 40 42 42 42 68 5 83 167 78 5 8 32 68 210 0 38 44 96 50 190 136 23 0 21 0 4 24 0 34 93 26 208 218 204 108 191 0 0 0 0 73 69 78 68 174 66 96 130 )
!

pdfBigGif
	"'imgs/pdf_icon.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 35 0 35 0 135 0 0 48 49 51 56 55 58 59 59 60 62 62 65 59 67 59 60 69 60 77 1 1 66 65 67 66 66 68 69 69 69 71 71 73 73 73 76 79 79 83 79 91 79 82 82 86 84 84 86 84 84 88 90 90 93 93 93 94 95 95 97 96 96 99 98 98 101 101 101 102 103 103 104 104 104 109 108 108 110 110 110 114 114 114 117 121 121 122 122 122 126 121 121 129 185 79 82 179 88 89 201 1 4 206 3 6 208 2 6 215 3 6 214 5 8 217 4 7 221 6 9 225 5 8 230 7 10 227 8 11 234 6 9 236 7 10 236 8 12 242 8 11 241 10 13 245 9 12 247 12 15 255 7 10 248 10 13 255 10 14 247 13 16 250 14 17 254 14 17 254 18 21 249 23 26 254 22 25 254 25 29 255 28 31 255 30 33 228 63 63 234 50 50 255 33 37 255 37 41 255 40 43 255 41 45 255 46 49 255 48 50 255 53 55 255 53 57 255 56 58 255 57 60 255 61 63 255 62 64 214 109 112 222 123 124 226 78 78 232 76 76 231 87 88 230 88 88 231 91 92 230 93 94 234 87 87 233 89 89 236 89 89 255 71 74 255 81 83 255 91 93 254 93 96 232 96 97 234 100 100 232 105 106 233 108 108 230 112 112 230 115 116 231 124 125 236 117 118 233 121 122 233 123 124 254 98 101 251 109 111 252 110 112 254 114 116 255 119 122 255 122 124 222 127 129 227 127 129 254 126 128 129 129 130 133 133 137 141 141 141 143 143 145 143 143 148 137 156 137 145 145 148 150 150 154 151 151 156 153 153 154 154 154 157 159 159 159 159 159 163 159 159 168 145 166 145 156 178 156 163 163 164 165 165 168 166 166 174 167 169 175 170 167 175 169 169 173 169 169 177 173 172 178 174 174 181 176 176 178 177 176 181 181 181 182 180 180 185 181 182 189 185 185 189 188 188 191 187 187 194 189 188 194 190 190 197 173 199 173 178 204 178 182 208 182 186 213 186 189 217 189 214 140 143 217 135 138 211 157 160 221 176 179 225 129 131 230 129 130 228 131 132 232 134 135 233 135 136 235 136 137 235 139 140 238 141 142 226 145 146 231 144 146 232 153 155 232 156 157 252 132 133 253 135 136 253 138 139 253 143 144 252 146 148 252 150 152 231 158 160 230 160 162 230 165 167 231 167 170 236 162 163 233 171 172 234 173 174 234 175 176 225 181 181 232 177 178 235 182 183 236 179 180 239 182 182 234 182 184 194 194 194 193 192 198 197 197 198 194 194 201 196 195 202 197 197 202 198 198 204 196 201 196 200 199 206 200 200 200 200 201 205 202 202 208 203 204 209 205 205 210 205 206 212 192 220 192 196 218 196 201 209 201 200 218 200 209 209 213 210 212 214 214 214 214 212 212 217 215 215 220 209 216 209 216 216 219 217 217 221 219 220 223 220 220 222 222 221 225 223 224 227 229 197 200 238 193 194 235 198 200 228 221 223 236 209 210 237 215 216 235 216 217 235 218 220 236 220 221 254 219 220 228 222 224 238 223 225 224 224 225 226 226 229 228 228 230 230 230 233 229 229 236 231 232 234 233 225 228 232 231 234 238 230 232 232 232 234 234 234 236 235 236 238 239 232 233 236 235 237 236 236 238 238 238 240 234 241 246 240 228 228 255 224 224 240 240 241 243 243 244 245 245 246 247 247 248 251 251 251 251 251 252 254 254 254 0 0 0 33 249 4 3 0 0 201 0 44 0 0 0 0 35 0 35 0 0 8 255 0 147 9 28 72 176 160 193 131 8 17 82 146 36 41 18 195 135 12 41 81 74 72 81 96 165 57 132 2 17 26 100 232 16 162 142 27 7 37 26 20 172 226 193 139 128 2 5 18 84 168 144 161 150 131 98 14 186 195 107 24 179 132 168 84 165 66 117 202 84 155 54 106 210 164 65 67 244 140 209 163 102 62 216 73 84 110 152 180 74 7 87 149 209 130 229 202 18 36 68 132 104 13 194 21 72 15 30 59 116 228 192 97 192 207 32 127 214 120 45 139 90 53 73 145 123 226 218 220 16 71 55 11 13 186 226 102 184 88 177 194 192 32 63 254 252 53 93 91 80 213 21 37 69 132 136 219 33 110 174 140 187 56 196 217 168 241 162 133 10 20 6 14 229 9 140 86 23 225 129 169 150 24 17 2 132 174 154 185 58 24 71 22 103 170 69 138 19 36 12 32 250 195 89 240 48 101 4 83 29 33 18 164 199 189 29 59 122 136 227 161 163 177 184 24 47 86 156 40 49 194 64 163 68 112 162 231 209 245 140 23 65 84 137 135 12 185 199 187 52 93 45 54 196 237 255 69 97 66 68 8 3 137 70 198 252 147 231 142 174 73 3 79 25 65 130 196 72 226 32 64 194 234 184 97 67 239 10 20 36 132 112 222 49 198 16 227 203 35 140 48 226 135 31 125 12 4 130 1 16 70 40 225 132 20 94 19 141 51 199 0 179 139 35 139 252 49 7 69 23 21 115 12 52 212 88 131 205 57 230 112 227 4 45 231 160 120 13 53 208 32 35 204 46 144 64 242 97 66 23 65 51 141 53 215 84 131 141 57 41 174 216 162 57 47 198 56 163 47 192 220 136 208 69 214 80 115 77 57 39 170 243 206 60 83 212 242 206 59 234 156 131 13 140 25 10 67 140 146 39 205 81 14 143 230 156 227 206 60 244 116 227 195 24 104 206 227 206 57 22 58 83 76 49 200 128 105 208 69 112 70 41 15 62 248 132 178 137 23 218 208 67 207 60 234 152 83 77 140 199 52 99 103 65 23 169 83 142 57 232 184 67 15 62 237 84 225 141 45 92 8 74 207 59 112 78 211 12 50 138 130 56 135 163 144 190 35 40 46 83 12 10 198 39 242 204 51 15 58 229 80 255 227 76 51 161 226 56 135 60 144 186 35 15 61 246 80 113 203 160 237 120 97 69 41 179 200 226 74 38 206 24 227 204 162 4 93 132 206 179 238 192 67 79 40 80 144 163 77 41 160 108 210 197 22 63 64 193 70 19 151 16 179 172 168 238 68 122 229 55 79 192 18 139 44 219 128 227 234 59 217 136 162 201 26 150 0 83 235 146 115 96 201 142 59 235 116 66 70 59 248 12 250 46 58 68 70 131 9 19 189 220 27 38 60 238 176 83 11 43 82 128 83 15 29 135 160 147 142 4 4 255 146 1 58 197 248 2 201 49 204 14 116 209 166 164 180 242 197 43 229 30 96 1 58 190 44 144 14 48 199 56 208 12 52 139 44 242 72 200 22 205 129 79 46 97 120 194 137 59 234 92 99 193 27 138 8 48 65 28 3 216 177 0 2 127 68 0 129 33 56 39 115 81 62 180 136 49 138 58 207 242 66 129 27 23 236 66 1 5 139 40 240 134 30 1 96 128 0 212 162 238 147 15 61 242 148 139 14 30 21 88 224 0 36 17 76 96 72 2 29 212 1 128 6 132 32 90 18 245 69 253 232 147 207 60 239 148 235 198 49 135 112 48 193 6 114 48 80 135 3 16 236 241 128 7 104 219 234 15 63 106 211 3 15 167 216 196 10 77 178 51 114 168 136 33 132 56 242 55 31 13 16 80 192 234 172 183 238 58 235 4 52 192 71 69 145 240 49 199 237 184 231 174 187 238 124 68 98 210 239 192 7 47 188 64 1 1 0 59 )
!

pdfMediumGif
	"'imgs/sigov-pdf.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 16 0 16 0 247 0 0 0 0 0 128 0 0 0 128 0 128 128 0 0 0 128 128 0 128 0 128 128 192 192 192 192 220 192 166 202 240 0 0 0 16 16 16 255 0 0 231 41 41 231 49 49 239 57 57 231 57 66 231 66 66 231 74 74 239 66 74 231 82 90 231 90 90 239 82 82 239 90 90 231 99 99 231 107 107 231 115 115 231 123 123 231 132 132 231 140 140 231 156 156 231 173 173 231 181 181 231 181 189 231 189 189 222 206 206 222 214 214 222 222 222 222 231 231 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 251 240 160 160 164 128 128 128 255 0 0 0 255 0 255 255 0 0 0 255 255 0 255 0 255 255 255 255 255 33 249 4 1 0 0 39 0 44 0 0 0 0 16 0 16 0 0 8 130 0 79 8 4 64 176 96 193 5 11 4 42 4 80 162 161 195 134 11 24 36 52 72 145 96 137 136 18 1 48 216 200 145 35 195 131 26 59 118 100 232 112 65 69 138 15 19 14 124 40 225 195 195 139 11 31 66 240 240 82 229 9 146 13 27 104 112 104 2 230 202 134 30 70 116 200 144 50 102 9 18 23 62 128 112 240 32 2 133 16 54 73 114 136 208 97 3 136 15 29 48 76 136 90 162 66 132 151 71 69 68 205 32 97 4 216 18 38 162 90 56 91 82 33 194 183 112 225 6 4 0 59 )
!

pdfSmallGif
	"'imgs/ibm-pdf.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 11 0 12 0 162 0 0 0 0 0 204 204 204 153 153 153 204 0 0 255 255 255 254 1 2 0 0 0 0 0 0 33 249 4 5 20 0 5 0 44 0 0 0 0 11 0 12 0 0 3 39 72 176 204 42 48 6 48 169 157 181 181 192 129 226 193 48 128 30 197 137 228 119 142 157 138 162 101 40 206 67 137 130 45 192 226 147 162 53 9 0 59 )
!

pdfSmallPng
	"'imgs/ikone-dok/corendal-pdf.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 131 73 68 65 84 120 156 98 248 15 3 183 111 223 222 186 117 235 198 141 27 55 108 216 0 33 33 96 243 230 205 47 94 188 128 43 3 8 32 6 56 235 200 145 35 135 15 159 222 183 239 216 158 61 135 118 237 58 176 105 211 142 21 43 214 116 116 244 222 191 127 31 168 237 209 163 71 16 101 0 1 196 240 175 182 225 127 118 238 255 144 240 255 158 190 255 157 92 255 219 57 252 183 176 254 111 100 250 91 223 248 182 148 92 99 99 235 239 223 191 129 122 214 172 89 3 209 3 16 64 12 255 75 203 255 155 91 253 87 82 253 47 38 245 159 87 232 63 59 247 127 70 214 175 140 44 47 25 89 87 51 177 22 21 149 252 6 3 160 158 245 235 215 191 121 243 6 32 128 24 254 39 165 252 215 208 254 47 45 255 95 88 226 63 143 192 127 86 206 95 140 44 239 24 89 110 51 178 116 51 50 119 117 245 150 150 86 20 23 151 214 215 55 246 244 244 221 188 121 19 32 128 24 174 75 201 2 37 176 162 70 86 246 103 207 158 157 62 125 250 232 209 163 187 119 239 62 113 226 196 161 67 135 0 2 8 225 233 227 199 143 95 185 114 229 204 153 51 23 46 92 184 119 239 222 229 160 224 59 183 111 63 120 240 224 198 141 27 151 46 93 2 202 2 141 223 179 103 15 64 0 161 104 0 74 95 189 122 245 238 221 187 95 190 124 185 239 239 247 248 209 99 160 163 159 62 125 10 12 241 115 231 206 61 124 248 112 251 246 237 0 1 132 162 225 201 147 39 183 110 221 2 42 122 113 251 246 93 27 235 23 179 230 2 117 190 123 247 14 168 7 104 249 243 231 207 55 109 218 4 16 64 40 26 128 66 64 99 190 126 253 250 170 182 230 229 219 143 207 250 39 188 90 181 250 219 183 111 192 136 3 26 244 242 229 75 160 6 128 0 66 209 0 52 251 213 171 87 175 47 95 123 233 227 251 114 213 42 32 122 238 233 245 220 195 227 109 112 240 237 150 182 143 31 63 2 53 0 4 16 138 134 79 159 62 125 254 252 249 113 116 244 171 61 251 222 223 186 243 254 195 167 15 255 255 63 121 251 225 198 182 157 151 83 51 129 102 1 53 0 4 16 138 134 247 143 158 62 138 75 120 218 219 15 212 246 250 245 107 160 11 129 174 7 134 4 208 61 103 207 158 5 6 6 80 3 64 0 161 104 120 88 80 248 180 176 16 104 53 208 247 64 207 220 185 115 7 24 166 23 47 94 4 6 244 129 3 7 46 95 190 12 212 0 16 64 8 13 192 216 1 146 223 191 127 127 251 246 45 208 118 96 148 1 19 15 68 15 48 30 142 29 59 6 212 0 76 133 0 1 132 208 112 248 240 97 71 71 71 53 28 64 94 94 30 40 187 119 239 94 128 0 3 0 11 108 48 6 214 146 182 59 0 0 0 0 73 69 78 68 174 66 96 130 )
!

powerpointSmallPng
	"'imgs/ikone-dok/corendal-powerpoint.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 166 73 68 65 84 120 156 98 248 15 3 155 14 221 216 120 240 250 134 3 215 214 237 187 178 118 239 165 213 187 46 174 218 121 126 197 182 179 203 182 157 94 186 229 212 191 127 80 101 0 1 196 112 187 57 9 136 110 54 38 92 173 137 185 80 30 113 166 48 228 120 182 255 225 84 239 253 137 30 123 227 92 63 127 255 247 246 203 223 57 171 15 152 123 167 254 3 107 2 8 32 144 6 32 245 239 249 237 13 241 46 19 173 140 129 104 110 172 199 183 107 199 128 130 64 13 95 190 255 123 255 229 239 212 37 59 119 29 189 2 209 3 16 64 12 55 27 226 129 170 215 187 91 254 249 242 254 255 239 239 97 60 252 64 61 109 218 186 64 61 219 35 28 191 252 248 251 254 235 223 201 139 182 3 85 67 16 64 0 49 92 173 141 1 154 253 231 243 219 255 127 126 253 255 251 27 168 225 102 164 246 135 217 233 64 193 245 1 214 19 214 93 131 160 165 123 238 44 217 125 23 168 1 32 128 24 46 150 71 76 50 213 253 90 237 244 174 41 228 69 127 214 30 127 253 15 211 179 62 44 43 1 10 46 113 55 249 252 3 228 164 151 31 254 60 124 243 103 225 174 187 102 94 41 0 1 196 112 166 48 120 162 181 201 135 147 211 63 156 93 248 97 111 247 135 137 233 32 180 32 31 168 97 166 141 14 220 134 251 175 126 207 221 113 15 168 1 32 128 24 78 100 251 3 109 255 48 39 238 195 209 73 31 182 53 126 152 89 248 97 90 246 135 137 32 119 246 26 170 2 141 127 245 241 239 147 183 127 238 190 252 61 115 219 3 160 6 128 0 98 56 156 230 13 241 244 135 185 177 31 150 102 125 152 150 241 97 82 244 6 75 125 160 96 179 134 28 220 134 91 207 126 79 221 252 8 168 1 32 128 24 14 36 122 64 130 245 96 73 244 68 115 131 73 102 122 64 6 144 11 20 172 81 144 120 241 254 207 163 55 127 238 188 248 125 237 201 175 254 141 143 129 26 0 2 136 1 24 216 59 162 156 54 5 219 174 242 177 88 228 98 12 114 183 137 122 135 142 98 131 138 76 153 148 8 220 134 75 15 127 117 173 123 2 212 0 16 64 12 240 164 49 115 197 190 23 31 128 1 242 23 72 62 127 255 231 233 219 63 15 95 255 6 154 125 253 233 175 203 143 126 157 187 247 179 117 205 51 160 6 128 0 66 104 152 182 108 247 163 55 191 129 14 128 132 9 220 108 8 58 117 251 71 227 242 231 64 13 0 1 132 208 0 140 127 160 207 110 61 255 125 243 217 239 27 79 127 93 123 242 251 242 163 223 23 30 252 60 115 247 199 201 219 63 143 223 250 81 179 228 37 80 3 64 0 33 52 0 227 255 210 163 95 243 118 220 7 6 223 212 45 143 38 110 124 212 179 254 73 199 218 167 45 171 159 53 44 127 94 189 244 69 197 226 215 64 13 0 1 132 208 0 228 16 131 0 2 12 0 18 21 0 105 149 238 239 221 0 0 0 0 73 69 78 68 174 66 96 130 )
!

txtSmallPng
	"'imgs/ikone-dok/corendal-txt.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 1 95 73 68 65 84 120 156 98 248 143 23 252 252 254 9 77 4 32 128 24 224 172 51 27 75 238 156 206 155 90 104 181 126 74 8 144 177 109 217 20 32 185 105 201 226 157 75 187 145 53 0 4 16 84 195 175 95 127 55 111 190 83 81 113 112 66 182 225 158 85 19 123 43 243 119 110 187 188 114 66 254 190 45 187 128 26 158 61 123 6 215 0 16 64 80 13 64 213 71 142 61 106 203 116 122 249 229 19 144 124 243 237 11 144 252 254 251 23 144 4 202 174 92 185 18 174 1 32 128 16 26 118 159 189 0 84 13 65 64 13 31 127 124 7 106 248 243 247 47 154 6 128 0 66 104 56 120 254 26 49 26 0 2 8 161 97 255 185 171 64 165 117 245 245 16 180 123 239 94 172 26 0 2 8 73 195 217 171 196 216 0 16 64 8 13 251 46 92 68 182 1 98 9 68 22 89 3 64 0 33 105 56 123 133 24 27 0 2 8 201 73 167 110 16 99 3 64 0 33 133 210 185 155 196 216 0 16 64 8 13 123 206 92 129 216 0 52 24 143 6 128 0 66 104 248 240 229 43 196 248 215 95 63 191 249 250 229 200 169 147 123 15 30 92 188 108 233 164 201 147 111 220 184 1 215 0 16 64 136 196 247 245 219 247 187 247 239 55 180 180 228 21 20 228 228 228 148 149 149 29 58 116 232 210 165 75 143 30 61 250 249 243 39 92 25 64 0 33 52 0 193 135 15 31 94 190 124 249 233 211 39 160 138 191 96 199 96 2 128 0 3 0 49 229 159 98 54 52 32 115 0 0 0 0 73 69 78 68 174 66 96 130 )
!

unknownSmallPng
	"'imgs/ikone-dok/corendal-unk.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 1 250 73 68 65 84 120 156 98 248 255 255 255 133 11 231 175 92 185 120 249 50 20 93 189 122 5 130 128 130 231 207 159 123 248 240 225 127 36 0 16 64 12 64 12 84 244 31 7 248 248 241 195 129 3 251 144 245 0 4 16 1 13 47 95 190 2 146 103 207 158 122 244 232 17 68 4 32 128 8 104 248 250 245 211 221 187 183 15 29 218 63 101 202 20 136 8 64 0 129 52 92 185 114 9 72 222 188 245 240 194 133 199 151 47 223 7 162 75 151 238 159 63 255 16 136 46 92 120 112 254 252 213 75 151 206 246 246 246 64 52 0 4 16 92 195 191 240 208 94 57 169 76 14 238 137 28 28 19 132 4 38 105 106 214 105 106 86 201 201 85 7 4 128 204 62 115 230 4 68 3 64 0 65 53 252 249 243 123 254 130 5 123 54 175 222 186 100 253 198 77 187 150 173 223 188 103 207 150 109 91 118 172 88 190 170 171 171 15 168 230 226 197 75 16 13 0 1 4 213 240 227 199 247 131 39 143 126 220 178 234 82 150 223 147 175 95 53 250 230 3 197 211 139 174 102 231 175 95 182 108 246 191 127 255 46 92 184 0 209 0 16 64 72 26 14 238 59 118 124 255 180 185 61 47 95 127 40 173 219 250 243 231 159 105 11 23 207 89 188 104 222 220 57 200 26 0 2 8 161 97 215 190 237 191 31 126 253 191 247 253 15 80 200 204 253 241 235 235 199 45 155 111 174 93 49 109 14 138 13 0 1 132 208 112 228 212 193 43 43 207 31 204 221 253 234 237 141 186 6 247 31 223 190 44 136 138 88 221 92 55 127 201 98 100 13 0 1 4 213 240 243 231 143 89 51 167 207 95 50 187 111 70 215 198 13 235 59 58 186 118 237 218 214 57 169 119 202 204 201 109 173 173 255 65 201 7 170 1 32 128 16 161 52 121 242 100 96 96 79 156 56 1 72 78 158 60 169 167 167 123 210 164 137 221 221 93 171 87 175 6 170 57 127 254 60 68 3 64 0 17 136 105 56 56 119 238 28 132 1 16 64 32 13 87 175 94 38 168 225 226 69 168 161 0 1 4 210 112 228 200 33 160 19 207 225 6 64 247 236 218 181 11 162 1 32 192 0 104 150 135 8 60 245 67 255 0 0 0 0 73 69 78 68 174 66 96 130 )
!

wordBigGif
	"'imgs/word_icon.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 34 0 32 0 135 0 0 0 0 0 0 0 255 128 128 128 192 192 192 192 220 192 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 3 0 0 4 0 44 0 0 0 0 34 0 32 0 0 8 255 0 9 8 28 72 176 160 193 131 8 13 10 88 200 176 161 67 134 9 15 10 40 64 177 162 197 139 5 4 0 136 88 112 34 198 143 20 23 110 52 8 32 64 201 147 38 83 162 4 41 96 128 70 131 42 99 162 60 201 178 128 203 145 3 75 130 180 168 179 226 128 159 46 41 222 36 104 114 103 197 162 62 129 122 180 249 82 224 76 153 49 45 254 12 9 160 170 213 145 81 83 22 144 57 213 230 197 1 62 71 206 44 64 179 108 0 169 93 187 218 196 10 128 236 89 173 38 39 154 76 11 214 103 88 167 111 159 150 4 219 83 232 84 160 119 9 20 213 139 116 110 93 160 136 3 235 132 123 210 99 95 163 107 5 14 158 188 151 162 97 196 152 21 231 221 220 150 226 99 163 3 216 66 222 10 0 179 105 205 132 159 142 22 202 22 170 94 211 153 89 39 92 186 26 99 232 217 73 97 195 14 44 177 54 200 219 8 151 234 214 205 91 161 239 143 192 123 143 62 45 59 248 113 219 56 141 63 151 26 189 227 116 234 179 135 107 71 92 157 224 213 239 224 195 91 5 229 72 158 124 64 0 59 )
!

wordSmallPng
	"'imgs/ikone-dok/corendal-word.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 120 73 68 65 84 120 156 98 248 15 3 155 14 221 216 120 240 250 134 3 215 214 237 187 178 118 239 165 213 187 46 174 218 121 126 197 182 179 203 182 157 94 186 229 212 191 127 80 101 0 1 196 48 121 245 51 32 234 92 250 178 97 222 179 154 233 55 210 187 174 70 212 93 12 42 63 229 148 119 68 43 105 251 231 239 255 222 126 249 59 103 245 1 115 239 212 127 96 77 0 1 4 210 240 31 7 224 244 222 244 229 251 191 247 95 254 78 93 178 115 215 209 43 16 61 0 1 196 0 52 123 213 190 143 205 115 110 37 52 158 189 118 231 21 144 188 243 232 75 104 238 146 238 37 119 65 26 126 252 125 255 245 239 228 69 219 129 170 33 8 32 128 24 128 46 1 170 0 106 136 175 61 12 100 184 100 237 4 146 190 89 203 203 187 230 0 53 76 88 119 13 136 94 126 252 187 116 207 157 37 187 239 2 53 0 4 16 67 249 196 171 64 219 129 36 80 233 250 61 247 21 125 102 1 205 182 138 154 113 242 210 35 54 167 217 159 127 252 3 105 248 240 231 225 155 63 11 119 221 53 243 74 1 8 32 6 160 47 129 26 210 235 54 3 53 196 150 174 102 53 107 50 138 222 166 97 151 11 20 4 106 248 244 13 164 225 217 187 63 247 95 253 158 187 227 30 80 3 64 0 49 132 86 159 3 202 1 29 13 52 117 251 137 47 64 13 64 180 118 215 5 160 32 135 77 7 208 199 64 13 79 222 254 185 251 242 247 204 109 15 128 26 0 2 136 193 179 228 12 72 78 191 219 34 113 221 135 79 191 128 170 29 210 182 64 66 9 200 134 248 225 225 171 223 183 158 253 158 186 249 17 80 3 64 0 49 88 101 238 192 21 172 140 70 21 47 222 255 121 244 230 207 157 23 191 175 61 249 213 191 241 49 80 3 64 0 49 0 99 7 24 26 16 4 116 52 4 1 29 3 52 30 168 1 98 195 245 167 191 47 61 252 213 181 238 9 80 3 64 0 49 192 205 155 185 98 223 139 15 127 95 126 248 11 36 159 191 255 243 244 237 159 135 175 127 3 205 190 254 244 215 229 71 191 206 221 251 217 186 230 25 80 3 64 0 33 52 76 91 182 251 209 155 223 64 7 64 76 69 70 231 238 253 56 117 251 71 227 242 231 64 13 0 1 132 208 0 140 127 160 207 110 61 255 125 243 217 239 27 79 127 93 123 242 251 242 163 223 23 30 252 60 115 247 199 201 219 63 143 223 250 81 179 228 37 80 3 64 0 33 52 0 227 255 210 163 95 243 118 220 7 6 223 212 45 143 38 110 124 212 179 254 73 199 218 167 45 171 159 53 44 127 94 189 244 69 197 226 215 64 13 0 1 132 208 0 228 16 131 0 2 12 0 71 114 23 164 38 70 157 109 0 0 0 0 73 69 78 68 174 66 96 130 )
!

xmlBigGif
	"'imgs/xml.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 32 0 32 0 179 10 0 153 102 153 128 128 128 17 17 17 198 198 198 204 204 204 102 102 102 102 51 102 0 0 0 204 153 204 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 10 0 44 0 0 0 0 32 0 32 0 0 4 255 80 73 5 140 189 56 235 12 166 50 72 40 142 100 73 26 30 24 30 34 139 184 237 90 162 147 138 20 236 81 200 163 11 139 52 137 237 166 107 193 14 190 89 138 244 67 174 112 188 81 240 211 131 62 115 175 40 112 25 59 102 177 217 19 247 181 179 98 193 191 208 84 85 12 65 89 184 157 15 233 68 172 221 164 50 254 230 46 248 119 118 99 38 131 131 107 27 135 136 23 30 7 9 141 142 143 144 145 144 7 139 146 150 151 141 148 19 140 152 157 143 154 18 156 158 158 160 10 162 163 152 165 167 168 150 140 2 175 176 177 177 172 9 7 2 163 3 183 168 182 9 3 190 191 192 190 1 186 146 116 198 183 192 2 190 202 191 195 150 4 7 4 210 208 5 200 203 201 205 196 144 208 211 58 10 214 204 216 3 206 146 220 212 18 200 225 193 202 228 145 220 222 232 189 185 193 243 227 218 143 208 240 241 191 234 225 195 198 0 245 237 227 119 45 219 159 131 127 60 12 164 7 108 152 194 135 10 217 5 152 72 177 98 128 92 16 51 42 72 32 171 35 172 4 26 3 33 70 0 0 59 )
!

xmlSmallPng
	"'imgs/ikone-dok/corendal-xml.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 0 208 73 68 65 84 120 156 98 104 35 2 252 71 2 0 1 196 128 198 199 4 7 14 28 64 86 3 16 64 56 53 124 252 248 17 66 2 53 0 25 112 101 0 1 132 208 0 87 129 70 50 32 1 32 23 32 128 160 26 128 114 203 78 125 128 170 104 104 0 34 227 180 255 232 226 96 13 0 1 4 213 0 20 101 96 152 9 81 13 36 141 129 104 38 80 69 3 88 221 76 136 30 136 6 128 0 2 105 128 171 6 137 2 205 6 170 62 3 212 0 84 208 0 51 123 38 88 13 72 3 64 0 161 219 0 116 9 208 108 176 106 236 54 0 4 16 54 63 48 52 64 16 86 63 0 4 16 225 80 130 147 16 13 0 1 132 176 193 56 109 38 46 132 108 3 64 0 145 108 3 64 0 145 108 3 64 0 145 108 3 64 0 33 108 32 72 66 52 0 4 16 3 73 0 168 1 32 192 0 122 128 24 248 27 252 237 14 0 0 0 0 73 69 78 68 174 66 96 130 )
!

zipSmallPng
	"'imgs/ikone-dok/corendal-zip.png' asFilename contentsAsMethod"
^#(137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 37 73 68 65 84 120 156 98 248 143 1 90 14 127 110 60 240 169 122 207 199 210 237 31 242 54 190 75 91 243 54 113 197 107 184 44 64 0 49 188 184 216 126 126 33 31 4 1 217 64 185 47 255 255 31 127 243 119 207 211 223 107 111 255 156 125 254 107 199 225 207 101 219 63 120 182 95 132 104 0 8 32 6 160 186 143 146 140 16 4 100 171 103 30 71 67 86 13 23 98 86 127 139 158 121 157 197 123 3 80 3 64 0 1 53 8 220 218 162 117 115 187 230 205 253 90 55 247 235 220 220 163 127 115 187 225 237 157 198 183 118 153 222 219 103 189 165 134 31 168 168 105 227 253 210 141 79 32 26 0 2 136 225 234 106 165 127 127 103 254 255 127 228 255 255 157 255 255 175 255 255 119 201 255 223 179 254 255 154 240 255 71 219 231 39 185 155 106 249 128 138 38 108 187 15 244 24 68 3 64 0 49 92 93 37 255 235 219 228 159 223 158 254 120 119 234 215 203 181 191 30 247 255 190 87 242 231 102 196 191 203 22 247 182 50 66 52 76 219 121 191 251 212 79 136 6 128 0 98 184 2 212 240 117 226 239 207 231 126 189 222 252 251 249 244 63 143 106 127 223 77 249 123 211 253 207 21 67 172 26 0 2 136 40 13 83 182 35 52 0 4 16 208 73 138 191 190 78 248 253 97 239 175 23 11 255 60 105 253 115 47 247 239 173 192 191 87 45 191 157 213 129 107 152 177 243 126 231 201 239 16 13 0 1 196 112 105 153 200 247 247 77 55 214 105 92 89 46 125 117 153 216 213 101 2 87 151 114 95 89 204 113 105 1 59 92 195 132 205 247 138 54 62 131 104 0 8 32 134 157 173 154 155 170 149 87 231 242 174 202 229 93 83 34 139 25 15 133 115 46 23 172 127 23 187 244 53 68 3 64 0 49 160 165 11 72 76 103 108 255 159 184 249 127 209 238 255 21 251 64 8 168 218 186 234 8 68 1 64 0 161 107 128 232 209 201 218 173 145 186 77 57 126 3 16 41 70 175 133 152 13 1 0 1 132 69 3 154 102 228 148 7 4 0 1 132 93 67 240 172 71 37 75 30 228 46 124 16 53 229 134 95 255 13 231 174 235 150 173 215 133 252 87 2 165 0 2 8 151 134 39 39 110 124 219 114 254 219 140 67 95 203 183 124 9 91 246 197 98 230 103 177 128 229 64 41 128 0 3 0 79 174 47 198 171 105 151 124 0 0 0 0 73 69 78 68 174 66 96 130 )
! !

!WebStyle methodsFor:'imgs-other'!

adobeLeafGif
	"'imgs/adobe-leaf.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 50 0 50 0 247 0 0 202 44 13 255 230 0 175 117 98 255 175 74 173 171 166 114 35 9 213 205 201 215 54 41 171 68 11 69 84 18 207 184 182 254 218 1 247 181 170 137 45 11 203 25 9 255 200 89 109 135 58 168 152 82 231 89 70 231 53 38 252 244 231 47 13 9 150 140 140 242 161 148 255 181 1 220 59 51 194 148 78 69 22 12 255 243 243 254 171 1 108 114 46 251 218 215 43 54 14 230 227 227 252 153 0 251 156 152 59 74 14 250 167 135 255 72 6 244 229 150 250 169 163 255 197 0 254 139 0 220 64 54 18 4 3 205 111 3 137 141 78 178 184 159 223 26 11 249 150 137 253 101 6 142 5 6 167 155 155 149 72 65 217 221 208 234 68 67 255 88 19 253 246 188 253 236 234 142 162 89 234 220 218 248 199 197 113 11 2 255 117 39 252 198 136 226 60 46 226 65 59 79 96 20 235 67 59 252 136 87 255 135 57 244 119 120 255 108 37 254 191 133 228 34 26 255 229 166 134 102 101 247 162 113 181 48 7 149 156 124 216 43 35 254 250 249 251 76 16 217 100 41 166 3 7 230 43 36 255 204 166 185 6 5 248 176 126 247 120 107 245 210 128 254 137 134 91 35 15 255 107 80 234 165 1 230 74 60 255 241 0 104 114 81 229 65 52 200 200 114 255 217 136 235 102 88 90 109 34 229 73 68 255 255 241 255 129 39 195 85 3 246 104 58 243 58 40 246 136 118 252 195 188 229 217 204 182 80 39 251 215 178 255 248 215 246 80 51 145 116 51 255 102 31 251 199 152 255 255 0 243 105 98 235 230 221 255 151 39 252 156 117 194 88 18 242 137 23 253 38 1 255 83 11 250 230 221 204 84 67 252 112 5 236 68 52 181 19 7 212 89 20 238 234 149 238 89 83 234 62 59 245 233 230 232 121 43 231 52 49 161 22 4 255 220 27 255 57 0 245 187 149 213 68 47 113 88 87 238 238 235 230 180 3 253 224 225 255 153 60 236 75 59 252 253 251 213 172 91 245 157 167 226 48 45 233 226 137 229 59 17 232 58 52 240 113 92 235 73 73 240 71 70 85 82 73 226 69 63 255 101 66 225 128 57 27 36 2 244 150 20 220 69 5 236 102 74 242 87 64 251 209 207 247 121 78 231 76 51 157 72 27 233 79 71 236 84 63 255 251 251 249 248 247 255 255 255 234 64 64 255 255 251 221 96 93 223 185 167 249 231 205 242 166 109 234 149 94 255 255 254 221 123 114 237 94 75 255 194 60 255 253 253 214 210 132 230 68 48 232 129 1 255 255 207 248 189 196 188 100 0 232 171 161 222 187 180 127 52 21 236 86 2 60 50 51 237 94 20 192 147 130 246 247 247 231 120 57 219 37 18 254 247 247 234 191 128 241 142 136 255 145 146 255 230 94 255 248 125 191 188 184 68 74 42 255 172 52 225 104 0 237 116 12 250 122 95 255 127 21 255 224 181 214 199 192 249 193 175 238 80 80 225 175 104 177 64 53 225 177 112 243 186 105 230 199 182 248 208 167 244 228 134 156 181 115 234 116 100 239 127 115 240 63 61 239 64 51 210 69 29 255 93 28 239 128 75 238 48 30 230 153 78 202 151 136 253 150 64 251 160 81 232 55 55 203 166 153 229 63 56 231 208 200 223 84 0 254 254 254 252 239 239 255 254 254 99 96 90 206 78 43 198 76 49 132 132 125 33 249 4 0 0 0 0 0 44 0 0 0 0 50 0 50 0 0 8 255 0 101 9 28 72 144 224 135 130 8 19 42 92 200 144 32 186 50 28 26 74 156 216 208 147 24 49 187 18 81 220 184 241 25 176 47 98 28 80 9 167 145 35 65 85 176 76 10 188 16 228 75 16 40 34 103 24 51 169 131 193 23 86 42 101 121 252 226 74 76 144 9 0 24 205 80 48 241 67 52 151 65 196 72 200 137 2 152 43 87 103 190 88 178 20 132 145 15 73 12 245 149 233 212 201 158 168 51 103 36 68 81 89 230 213 183 79 55 210 126 2 5 10 10 164 133 31 22 117 181 39 228 107 212 131 38 81 73 56 132 22 209 172 27 108 213 41 81 149 240 67 149 185 116 235 70 189 160 18 21 175 67 103 111 204 154 60 11 81 149 67 8 159 113 37 98 239 34 93 187 101 84 122 122 28 89 50 87 122 139 148 232 40 136 103 2 17 34 98 236 101 88 161 88 212 82 147 109 94 185 74 75 25 17 106 77 48 24 15 164 84 133 136 165 65 178 103 215 21 101 59 179 62 125 148 122 48 184 192 224 195 88 89 12 94 89 234 180 104 17 189 239 191 149 16 255 33 88 102 2 200 32 25 210 43 103 126 155 32 172 76 240 51 141 24 113 161 190 183 103 170 214 173 155 80 5 10 20 77 0 2 88 133 18 215 69 81 69 16 43 168 167 224 10 162 172 144 78 66 195 28 33 97 22 20 182 209 134 39 68 172 193 134 18 206 56 224 161 3 255 1 152 26 94 110 40 129 222 1 40 46 184 194 1 12 36 164 195 28 169 12 210 225 135 14 112 146 134 20 87 16 162 35 33 87 92 1 5 43 171 236 81 2 32 2 225 161 4 138 72 30 144 222 10 76 30 176 26 66 186 224 224 135 3 61 246 72 5 33 70 24 81 7 33 51 48 66 5 21 0 144 34 79 150 15 76 147 131 64 118 88 2 69 146 74 50 185 98 32 11 213 225 7 12 85 126 73 197 40 163 32 193 201 12 124 78 49 64 37 117 252 33 5 18 215 44 33 11 45 194 228 80 4 36 254 165 184 164 19 247 44 132 132 35 130 82 209 194 29 147 180 96 74 35 24 72 193 39 41 149 164 129 68 29 237 180 131 3 18 73 200 130 198 18 75 144 49 14 41 253 196 255 10 9 36 254 180 226 1 67 69 248 97 194 31 48 76 114 71 0 119 4 123 71 7 84 176 147 198 15 63 212 129 67 59 127 8 90 132 44 113 0 97 133 21 64 96 162 193 181 116 208 225 65 2 88 45 228 134 174 126 168 0 198 2 1 4 176 192 2 96 96 42 131 20 117 140 186 172 9 82 152 240 236 60 243 120 195 192 35 208 88 235 130 7 102 144 240 66 67 251 56 98 130 184 96 20 108 238 2 41 164 123 135 32 127 200 240 7 188 142 212 145 6 16 178 40 114 138 54 49 148 240 136 56 17 64 208 239 19 19 49 32 131 193 96 4 128 65 7 1 164 80 238 175 56 152 32 240 15 3 60 208 11 55 178 156 2 0 20 120 100 140 69 4 31 83 228 203 54 232 142 43 130 10 29 96 128 65 201 11 220 161 130 9 105 60 64 205 3 3 204 67 129 44 0 120 72 68 27 37 148 160 65 2 255 110 36 7 6 228 98 32 66 10 24 168 192 137 23 11 120 49 110 35 15 84 162 135 30 3 96 145 18 12 14 56 163 4 30 123 52 161 129 13 42 45 255 209 129 8 34 4 0 70 10 34 32 19 140 23 99 167 112 71 47 70 8 34 67 26 123 200 2 139 18 48 216 157 10 46 229 12 20 75 53 255 240 19 202 63 6 52 148 195 208 41 32 124 114 7 168 171 160 248 2 219 200 128 143 50 37 232 196 139 51 149 187 51 181 44 54 132 65 2 8 165 244 222 187 53 221 42 68 65 31 130 0 174 130 8 106 183 224 68 194 41 100 163 6 2 78 160 32 139 14 233 40 82 72 46 2 161 241 203 16 32 144 224 61 8 224 243 94 10 223 12 249 125 188 8 193 4 227 131 15 24 16 222 192 251 140 20 35 139 42 71 228 114 139 64 57 152 51 70 191 9 244 191 123 248 189 235 26 67 228 240 0 21 96 195 42 196 40 155 26 142 81 128 247 197 67 22 40 136 134 47 100 65 129 77 108 194 16 251 235 159 255 254 7 190 82 176 128 0 20 1 132 45 200 208 11 83 16 131 11 92 40 64 1 124 80 15 89 140 96 31 208 130 134 33 102 56 6 15 12 225 134 67 72 0 7 65 240 193 156 8 36 22 33 48 192 50 255 26 32 0 29 60 3 22 40 192 130 29 78 96 136 19 128 99 95 56 204 225 255 88 0 50 31 22 36 22 112 144 134 27 164 49 2 44 36 65 11 90 24 199 60 52 176 47 51 152 225 134 58 44 69 24 84 18 133 68 240 224 13 6 48 64 55 186 177 12 1 48 128 18 148 144 198 22 246 176 135 85 172 33 21 107 128 71 4 92 64 72 143 37 0 4 46 216 72 30 108 161 1 62 60 175 1 5 216 64 5 42 208 64 125 124 32 34 81 64 65 23 230 192 134 78 178 97 13 26 216 129 40 119 0 1 8 8 144 33 177 176 64 5 184 208 0 4 168 225 149 8 56 6 23 54 176 129 6 144 195 133 41 17 8 7 80 48 136 9 188 227 29 108 104 70 4 68 121 14 27 92 98 34 247 168 0 11 88 192 5 56 240 161 16 133 224 67 44 103 89 0 56 8 100 11 9 209 71 15 80 16 3 111 188 33 15 177 216 136 49 26 192 5 101 110 160 21 173 64 128 58 143 33 201 10 108 160 36 120 176 162 66 120 224 131 6 28 67 153 21 56 134 62 245 201 153 133 101 178 32 18 3 169 133 60 19 162 66 89 46 115 3 42 84 97 57 253 201 140 129 192 105 160 4 81 192 42 103 201 130 137 162 112 161 203 4 225 64 194 241 12 136 10 36 31 180 68 33 45 71 74 75 101 46 147 31 5 169 1 15 60 42 11 38 176 96 164 147 140 105 76 151 25 10 132 8 128 6 30 13 129 73 101 42 83 127 226 20 33 10 0 40 75 37 161 74 127 26 149 5 22 8 103 66 36 81 1 150 18 36 4 213 160 1 13 170 97 128 16 72 132 5 74 117 106 78 146 65 62 173 170 132 31 26 245 170 73 254 241 15 177 170 132 6 22 144 103 64 0 0 59 )
!

bannerLeftGif
	"'imgs/fast/fast-banner_left.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 3 0 3 0 128 0 0 127 160 177 255 255 255 33 249 4 1 0 0 0 0 44 0 0 0 0 3 0 3 0 0 2 4 12 96 24 81 0 59 13 10 )
!

bucketTopGif
	"'imgs/fast/fast-bucket_top.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 80 1 5 0 128 1 0 255 255 255 229 236 243 33 249 4 1 0 0 1 0 44 0 0 0 0 80 1 5 0 0 2 50 132 17 169 203 237 15 163 156 180 218 139 179 222 188 251 15 42 199 17 150 230 137 166 234 202 182 37 233 198 242 76 215 246 141 25 248 206 247 254 15 100 32 130 196 162 241 136 172 20 0 0 59 13 10 )
!

buttonSquareYellowGif
	"'imgs/dars-kvadrat.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 9 0 9 0 128 0 0 50 138 66 251 171 61 33 249 4 0 0 0 0 0 44 0 0 0 0 9 0 9 0 0 2 15 132 143 161 27 198 235 94 3 114 214 248 48 67 28 20 0 59 )
!

copyIconGif
	"'imgs/jure-copy.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 11 0 12 0 196 0 0 0 0 0 255 255 255 255 0 0 255 16 16 255 32 32 255 48 48 255 64 64 255 80 80 255 96 96 255 112 112 255 128 128 255 143 143 255 159 159 255 175 175 255 191 191 255 207 207 255 223 223 255 239 239 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 18 0 44 0 0 0 0 11 0 12 0 64 5 61 96 32 142 164 152 8 2 226 44 40 34 66 104 17 5 144 161 60 163 130 238 133 136 160 142 210 232 113 32 8 108 179 18 100 161 80 52 72 58 1 65 97 20 48 2 44 171 48 96 0 138 20 135 43 109 176 139 37 183 163 16 0 59 )
!

cornerDashboardLeftGif
	"'imgs/fast/fast-dashboard_left.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 7 0 24 0 128 0 0 127 160 177 255 255 255 33 249 4 1 0 0 0 0 44 0 0 0 0 7 0 24 0 0 2 29 140 143 6 144 139 203 14 124 78 86 117 195 180 17 119 157 109 30 245 137 96 25 166 232 7 54 172 81 0 0 59 13 10 )
!

cornerDashboardRightGif
	"'imgs/fast/fast-dashboard_right.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 7 0 24 0 145 0 0 0 0 0 255 255 255 255 255 255 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 7 0 24 0 0 2 28 140 31 34 152 139 234 12 124 138 198 118 231 209 178 110 223 101 32 102 149 159 136 154 29 51 50 71 1 0 59 )
!

cutIconGif
	"'imgs/jure-cut.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 11 0 12 0 196 0 0 0 0 0 255 255 255 242 244 248 42 86 143 69 107 157 95 128 171 136 160 192 175 191 213 215 223 234 55 97 150 82 118 164 122 150 185 149 171 199 161 181 206 202 213 227 228 234 241 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 16 0 44 0 0 0 0 11 0 12 0 64 5 60 96 32 142 100 128 12 232 178 160 131 35 10 4 203 30 129 144 176 79 160 160 137 216 200 45 17 138 32 16 197 80 14 4 99 217 120 45 25 1 6 203 176 66 138 14 192 230 21 56 40 136 110 3 133 192 193 242 150 206 33 0 59 )
!

favicon
	"'imgs/favicon.ico' asFilename contentsAsMethod"
^#(0 0 1 0 2 0 16 16 0 0 0 0 0 0 104 5 0 0 38 0 0 0 16 16 0 0 0 0 0 0 104 3 0 0 142 5 0 0 40 0 0 0 16 0 0 0 32 0 0 0 1 0 8 0 0 0 0 0 64 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 0 0 0 0 0 153 204 255 0 102 153 204 0 191 191 191 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4 4 4 4 4 1 1 1 1 1 1 2 2 1 3 3 1 1 4 4 4 4 1 1 1 2 2 2 2 1 3 3 3 3 1 4 4 4 1 1 2 2 2 2 2 1 3 3 3 3 3 1 4 1 1 1 2 2 2 2 2 1 3 3 3 3 3 1 1 1 1 1 2 2 2 2 2 1 3 3 3 3 3 1 1 1 1 1 2 2 2 2 2 1 3 3 3 3 3 1 1 1 1 1 2 2 2 2 2 1 3 3 3 3 3 1 1 1 1 1 2 2 2 1 1 2 1 1 3 3 3 1 1 1 1 1 2 1 1 2 2 2 2 2 1 1 3 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 19 156 248 1 16 160 224 0 19 92 192 0 16 160 128 1 19 100 128 3 16 160 128 3 19 108 128 3 16 160 128 3 19 116 128 3 16 160 128 3 19 124 192 7 16 160 224 15 19 132 248 63 16 160 255 255 19 140 255 255 16 160 40 0 0 0 16 0 0 0 32 0 0 0 1 0 24 0 0 0 0 0 64 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 191 191 191 191 191 191 191 191 191 191 191 191 191 191 191 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 0 0 0 0 0 0 191 191 191 191 191 191 191 191 191 191 191 191 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 191 191 191 191 191 191 191 191 191 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 191 191 191 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 0 0 0 0 0 0 153 204 255 0 0 0 0 0 0 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 0 0 0 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 19 156 248 1 16 160 224 0 19 92 192 0 16 160 128 1 19 100 128 3 16 160 128 3 19 108 128 3 16 160 128 3 19 116 128 3 16 160 128 3 19 124 192 7 16 160 224 15 19 132 248 63 16 160 255 255 19 140 255 255 16 160 )
!

leftCornerGif
	"'imgs/fast/fast-left_corner.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 4 0 4 0 128 1 0 255 255 255 229 236 243 33 249 4 1 0 0 1 0 44 0 0 0 0 4 0 4 0 0 2 6 132 17 97 169 12 5 0 59 13 10 )
!

leftStripeGif
	"'imgs/fast/fast-left_stripe.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 8 0 1 0 128 0 0 170 167 153 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 8 0 1 0 0 2 3 132 111 5 0 59 13 10 )
!

navLeftGif
	"'imgs/fast/fast-nav_left.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 7 0 82 0 128 0 0 127 160 177 255 255 255 33 249 4 1 0 0 0 0 44 0 0 0 0 7 0 82 0 0 2 64 140 143 6 144 139 203 14 124 78 86 117 195 180 17 119 157 109 30 245 137 96 25 166 232 74 182 156 59 190 114 76 159 176 61 227 181 201 171 119 207 202 1 127 62 97 113 119 212 41 135 198 32 210 185 76 50 159 68 232 20 211 248 28 10 0 59 13 10 )
!

pasteIconGif
	"'imgs/jure-paste.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 11 0 12 0 196 0 0 0 0 0 255 255 255 242 244 240 139 158 117 152 169 132 177 190 162 203 212 193 216 222 209 49 82 9 62 93 24 88 115 55 101 125 71 114 136 86 127 147 102 165 179 147 229 233 224 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 16 0 44 0 0 0 0 11 0 12 0 64 5 59 96 32 142 164 120 32 8 83 142 4 90 4 45 98 136 15 106 35 137 32 42 55 126 136 133 197 226 183 18 17 142 4 135 65 39 50 160 22 4 158 76 196 64 53 6 9 220 8 165 48 120 73 5 20 161 72 22 133 0 0 59 )
!

redPixelGif
	"'imgs/redpix.gif' asFilename contentsAsMethod"
	 ^#(71 73 70 56 57 97 1 0 1 0 145 255 0 255 255 255 196 0 67
		0 0 0 0 0 0 44 0 0 0 0 1 0 1 0 0 2 2 76 1 0 59 )
!

tab1BgGif
	"'/home/mivsek/download/tab1bg.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 1 0 45 0 132 32 0 221 227 213 219 225 211 254 254 254 242 244 238 230 233 224 218 224 210 252 252 252 245 247 242 249 249 247 234 237 228 224 228 214 229 232 222 238 241 234 237 240 233 239 242 235 226 229 218 248 248 246 247 247 245 243 245 240 233 236 227 250 250 248 251 251 251 235 238 231 119 102 85 227 230 219 228 231 221 253 253 253 236 239 232 225 228 217 241 243 238 224 227 216 232 235 226 44 0 0 0 0 1 0 45 0 0 5 33 96 81 4 36 96 42 232 131 101 11 225 78 73 98 109 13 227 12 221 32 29 71 4 33 8 74 197 96 208 8 142 151 16 0 59 )
!

tab1LeftGif
	"'imgs/tab1left.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 9 0 150 0 196 31 0 183 174 136 239 237 229 224 220 204 236 234 224 241 239 233 231 228 216 215 210 189 219 214 196 214 209 187 244 243 237 251 251 250 246 245 242 232 229 218 223 219 203 248 247 244 217 213 194 225 222 208 241 239 232 240 238 231 197 190 160 235 232 222 237 235 226 238 236 227 249 248 246 220 216 198 188 180 144 211 207 183 216 211 191 238 236 228 229 226 212 199 192 163 226 229 218 33 249 4 1 0 0 31 0 44 0 0 0 0 9 0 150 0 0 5 240 224 39 66 136 151 1 128 120 76 199 224 40 202 247 104 4 108 67 83 4 95 206 178 104 15 5 111 145 40 78 24 195 4 33 34 201 36 122 202 8 199 2 232 17 9 1 75 165 234 75 72 44 3 10 160 139 173 80 196 100 51 131 49 86 6 40 133 14 4 80 148 12 10 16 65 131 46 165 116 26 24 15 0 4 18 21 12 16 129 27 131 1 3 135 7 27 8 139 119 2 7 6 145 88 147 149 151 140 5 148 150 146 157 154 160 158 155 153 159 152 161 167 156 164 163 162 168 172 175 174 171 178 166 165 169 182 176 179 170 181 173 187 183 189 184 180 191 177 190 185 188 196 193 197 194 198 195 186 201 207 192 209 200 210 206 212 199 213 211 217 216 219 215 221 205 222 204 225 203 227 202 229 208 218 224 228 231 220 223 237 226 230 214 238 234 241 239 235 233 240 232 242 248 236 245 244 243 249 253 0 254 227 55 240 158 61 125 7 3 18 220 103 208 31 67 132 14 19 22 132 40 240 161 194 134 21 37 90 10 1 0 59 )
!

tab1LeftOnGif
	"'imgs/tab1lefton.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 9 0 150 0 196 31 0 255 255 255 119 102 85 254 254 254 253 253 252 250 250 248 249 249 247 253 253 253 252 252 250 249 248 246 248 247 245 245 244 239 246 245 241 244 242 237 242 241 235 246 245 240 247 246 242 221 217 213 187 179 170 245 244 243 129 113 97 233 230 227 152 139 126 147 133 120 147 133 119 174 164 154 214 212 204 242 241 234 214 212 203 196 189 180 185 177 167 183 174 164 226 229 218 33 249 4 1 0 0 31 0 44 0 0 0 0 9 0 150 0 0 5 223 224 39 102 93 53 5 129 200 89 17 36 1 192 199 97 20 108 111 87 109 195 94 180 219 21 200 15 54 121 13 3 67 24 18 38 104 54 3 78 131 97 64 13 76 7 7 2 161 80 8 80 179 136 68 226 17 208 22 16 15 135 130 81 62 39 212 141 70 59 236 96 52 52 229 109 98 177 102 103 207 15 124 10 1 7 127 97 11 11 94 88 91 8 97 86 83 89 91 93 82 87 133 7 80 77 148 85 76 78 79 73 0 75 71 159 161 63 164 59 166 54 168 74 163 172 73 170 160 173 162 174 177 165 180 167 182 169 184 171 179 188 178 190 181 189 192 191 183 193 196 195 185 197 200 199 187 203 176 201 204 194 209 198 210 202 212 208 211 216 213 217 215 218 221 220 223 206 205 175 227 186 225 214 230 219 232 222 234 224 228 207 236 240 238 226 229 242 231 245 233 247 235 249 237 244 253 239 251 241 252 205 251 39 208 94 65 124 7 245 37 4 23 2 0 59 )
!

tab1RightGif
	"'imgs/tab1right.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 144 1 150 0 196 31 0 213 208 186 183 174 136 210 204 181 217 212 193 226 222 208 233 230 219 222 218 201 243 242 236 214 209 188 235 232 222 214 208 187 236 234 224 240 238 231 247 246 243 238 236 227 231 228 216 250 250 248 253 253 252 201 194 166 212 207 184 208 202 178 205 199 173 203 196 169 192 184 151 229 226 212 220 216 198 216 211 191 207 201 176 206 200 174 202 195 167 252 252 251 226 229 218 33 249 4 1 0 0 31 0 44 0 0 0 0 144 1 150 0 0 5 255 96 32 142 100 105 158 104 170 174 108 235 190 112 44 207 116 109 223 120 174 239 176 68 101 159 96 100 72 44 26 143 200 164 114 201 108 58 159 208 168 116 74 173 90 175 216 172 118 203 117 122 32 7 130 224 34 8 66 206 232 180 122 205 110 187 223 240 184 124 78 175 219 239 248 188 126 207 239 251 255 128 115 13 7 12 9 6 18 101 13 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 150 7 7 11 15 4 3 23 25 166 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 186 12 14 9 24 6 25 29 22 12 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 221 202 169 205 99 14 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 0 3 10 28 72 176 160 193 131 8 19 42 236 151 160 0 179 12 3 16 4 88 64 177 162 197 139 24 51 106 220 200 177 163 199 143 32 67 138 28 73 178 164 201 147 40 83 255 170 92 201 178 229 199 4 9 30 60 28 160 33 0 204 155 56 115 234 220 201 179 167 207 159 64 131 10 29 74 180 168 209 163 72 147 42 93 202 180 169 211 167 67 11 184 203 160 65 98 129 171 88 179 106 221 202 181 171 215 175 96 195 138 29 75 182 172 217 179 104 211 170 93 203 182 173 219 183 112 199 202 36 0 17 129 196 7 120 243 234 221 203 183 175 223 191 128 3 11 30 76 184 176 225 195 136 19 43 94 204 184 177 227 199 144 35 19 198 64 160 153 221 9 1 8 104 222 204 185 179 231 207 160 67 139 30 77 186 180 233 211 168 83 171 94 205 186 181 235 215 176 99 203 158 125 186 153 6 0 2 4 4 48 192 187 183 239 223 192 131 11 31 78 188 184 241 227 200 147 43 95 206 188 185 243 231 208 163 75 159 78 189 250 241 12 16 53 76 160 64 97 67 128 1 224 195 139 31 79 190 188 249 243 232 211 171 95 207 190 189 251 247 240 227 203 159 79 191 190 253 251 248 243 179 175 186 157 67 133 10 1 216 37 224 128 4 22 104 224 129 8 38 168 224 255 130 12 54 232 224 131 16 70 40 225 132 20 86 104 225 133 24 102 168 225 131 19 8 176 65 5 22 116 16 224 134 36 150 104 226 137 40 166 168 226 138 44 182 168 33 0 29 82 224 95 7 34 2 96 227 141 56 230 168 227 142 60 246 232 227 143 64 6 41 228 144 68 22 105 228 145 72 38 169 228 146 76 54 233 228 147 65 78 16 35 136 29 72 16 0 148 88 102 169 229 150 92 118 233 229 151 96 134 9 165 148 2 80 64 165 149 98 166 169 230 154 108 182 233 230 155 112 226 72 166 153 33 162 25 231 157 120 230 169 231 158 124 114 57 231 153 87 246 41 232 160 132 22 106 168 155 127 214 25 232 161 140 54 234 232 163 144 242 152 104 149 139 70 106 233 165 152 102 202 230 164 118 106 234 233 167 160 134 122 36 167 149 138 106 234 169 168 122 74 106 170 172 182 234 234 161 171 190 42 235 172 180 182 25 107 173 184 230 170 235 147 183 238 234 235 175 192 250 216 107 176 196 22 187 235 176 198 38 171 108 171 200 46 235 236 179 170 78 169 40 180 212 86 139 105 255 179 214 102 171 45 159 216 110 235 237 183 182 74 75 41 184 228 150 187 169 184 157 154 171 238 186 90 118 203 238 187 240 18 233 110 188 244 214 171 227 188 246 230 75 47 190 250 246 187 46 191 254 6 12 46 192 2 23 156 45 193 6 39 252 44 194 10 55 108 44 195 14 71 252 43 196 18 87 140 43 197 22 103 252 42 198 26 119 140 42 199 30 135 12 42 200 34 151 124 45 186 165 154 172 50 179 40 175 236 178 171 36 191 44 243 160 49 207 108 179 158 53 223 172 51 156 57 239 236 243 154 61 255 44 52 152 65 15 109 244 150 69 31 173 52 175 45 47 237 116 158 73 63 45 181 145 81 79 109 117 148 77 95 173 117 152 85 111 237 181 156 89 127 45 54 150 93 143 189 117 217 102 95 141 118 218 83 175 205 246 211 110 191 189 116 220 114 31 77 119 221 67 223 141 247 207 122 239 189 115 223 126 223 12 120 224 51 15 78 248 203 134 31 190 114 226 138 155 204 120 227 34 63 14 185 199 146 79 174 113 229 150 91 140 121 230 18 111 206 185 195 158 127 174 112 254 232 162 27 76 122 233 2 159 142 186 191 170 175 174 111 235 174 219 11 123 236 251 134 77 251 215 179 223 254 110 238 186 255 107 123 239 106 255 14 124 219 194 15 15 119 241 198 207 141 124 242 118 47 207 124 222 206 63 207 119 244 210 255 77 125 245 130 95 143 125 225 218 111 143 120 247 222 47 14 126 248 142 143 79 126 228 230 159 79 121 250 234 95 206 126 251 154 191 15 127 231 242 207 15 122 253 246 143 142 127 254 166 239 207 127 234 254 251 31 235 2 40 192 215 17 176 128 178 59 32 2 107 87 38 64 45 208 101 188 123 96 174 34 40 193 90 81 176 130 179 186 32 6 55 166 192 13 154 75 131 30 100 21 8 67 248 177 14 146 240 91 35 60 161 168 82 168 194 145 153 176 133 7 123 33 12 171 197 194 25 102 170 134 54 188 20 14 115 24 169 29 242 240 81 62 252 97 163 130 40 68 88 201 176 136 15 59 34 18 137 69 196 37 210 76 137 78 156 24 20 163 120 172 41 82 113 130 86 188 162 5 179 168 197 12 114 177 139 28 108 160 162 66 0 0 59 )
!

tab1RightOnGif
	"'imgs/tab1righton.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 144 1 150 0 196 31 0 255 255 255 253 253 252 254 254 254 244 242 237 249 249 247 242 241 234 119 102 85 242 241 235 250 250 248 247 246 242 246 245 241 248 247 245 209 205 193 145 131 116 229 225 213 232 230 218 239 237 230 174 164 150 249 248 246 234 232 222 237 234 226 231 227 216 245 244 239 246 245 240 253 253 253 241 240 233 252 252 250 240 238 231 189 181 169 235 233 223 128 112 95 226 229 218 33 249 4 1 0 0 31 0 44 0 0 0 0 144 1 150 0 0 5 255 160 33 142 100 105 158 104 170 174 108 235 190 112 44 207 116 109 223 120 174 239 175 215 68 140 143 16 64 44 26 143 200 164 114 201 108 58 159 208 168 116 74 173 90 175 216 172 118 203 237 58 5 1 9 133 17 105 112 134 222 180 122 205 110 187 223 240 184 156 11 150 88 54 227 200 121 206 239 251 255 128 129 130 131 69 117 22 16 29 15 12 13 12 132 142 143 144 145 146 147 109 134 136 15 14 17 17 148 156 157 158 159 160 129 150 137 21 139 161 167 168 169 170 171 75 163 152 14 30 172 178 179 180 181 162 97 135 164 14 6 2 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 199 24 26 18 3 151 14 187 1 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 234 26 4 9 220 19 175 12 16 24 72 176 160 193 131 8 19 42 92 200 176 161 195 135 16 35 74 156 72 177 162 197 139 24 51 106 220 200 209 225 130 11 5 40 60 168 224 205 64 130 147 40 83 255 170 92 201 178 165 203 151 48 99 202 156 73 179 166 205 155 56 115 234 220 201 179 167 207 159 64 99 42 184 112 96 67 34 111 187 6 40 93 202 180 169 211 167 80 163 74 157 74 181 170 213 171 88 179 106 221 202 181 171 215 175 96 195 138 29 75 245 64 81 10 0 145 26 40 192 182 173 219 183 112 227 202 157 75 183 174 221 187 120 243 234 221 203 183 175 223 191 128 3 11 30 76 184 240 221 12 16 208 190 218 101 184 177 227 199 144 35 75 158 76 185 178 229 194 25 54 36 38 85 161 130 1 179 160 67 139 30 77 186 180 233 211 168 83 171 94 205 186 181 235 215 176 99 203 158 77 187 182 237 219 184 87 23 64 76 33 209 131 7 6 200 10 31 78 188 184 241 227 200 147 43 95 46 252 0 111 10 189 13 40 152 78 189 186 245 235 216 179 107 223 206 189 187 247 239 224 195 139 31 79 190 188 249 243 232 211 171 95 207 190 251 133 11 22 6 236 214 12 193 192 130 251 248 243 235 223 207 191 191 255 255 0 6 40 224 128 4 22 104 224 129 8 38 168 224 255 130 12 54 232 224 131 16 10 120 18 124 3 128 38 80 71 24 102 168 225 134 28 118 232 225 135 32 134 216 145 4 11 36 48 221 123 6 32 160 226 138 44 182 232 226 139 48 198 40 227 140 52 214 104 227 141 56 230 168 227 142 60 246 232 227 143 64 6 41 228 144 55 14 36 193 145 18 24 160 207 146 76 54 233 228 147 80 70 41 229 148 84 50 169 193 149 43 242 114 205 150 92 118 233 229 151 96 134 41 230 152 100 110 137 193 153 104 26 96 203 154 108 182 233 102 26 106 190 41 231 156 116 214 89 68 156 118 230 169 231 158 168 224 201 231 159 128 6 42 136 159 130 22 106 232 161 112 34 170 232 162 140 78 65 104 163 144 70 202 232 163 146 86 106 233 159 148 94 170 233 166 111 102 202 233 167 160 178 226 105 168 164 150 218 201 168 166 166 170 234 32 168 174 234 234 171 113 180 10 235 172 180 118 33 107 173 184 230 234 168 174 188 246 122 197 173 190 6 235 43 176 194 22 139 43 177 198 38 251 42 178 202 54 107 42 179 206 70 251 41 180 210 86 107 41 255 181 214 102 219 40 182 218 118 123 40 183 222 134 11 40 184 226 150 155 39 185 230 166 43 39 186 234 182 187 38 187 238 198 43 11 188 242 214 219 167 189 248 242 73 111 190 252 78 178 111 191 0 59 242 111 192 4 3 50 112 193 8 207 113 112 194 12 187 177 112 195 16 39 26 241 196 167 82 108 177 191 23 103 252 200 195 26 119 236 4 199 30 135 156 4 200 34 151 76 4 201 38 139 140 114 202 30 175 204 178 198 46 191 124 113 204 50 83 76 115 205 17 223 140 115 195 58 239 156 112 207 62 23 12 116 208 1 15 77 116 191 70 31 157 111 210 74 219 203 116 211 242 62 13 181 187 82 79 173 110 213 86 155 139 117 214 226 110 205 181 183 94 127 173 109 216 98 91 75 118 217 210 158 141 182 179 106 175 173 108 219 110 27 11 119 220 194 206 77 247 176 119 251 108 119 222 186 238 205 247 177 127 215 236 119 224 179 14 78 248 178 135 179 108 120 226 170 46 206 248 179 143 151 236 120 228 161 78 78 249 180 151 183 156 121 199 150 111 126 105 231 158 87 10 122 140 232 145 142 78 250 182 167 219 156 250 196 166 175 142 104 235 174 27 10 123 236 130 206 78 251 184 183 255 156 59 194 182 239 174 103 239 190 219 9 124 240 116 14 79 252 186 199 35 157 60 191 198 47 207 102 243 206 219 2 125 244 180 76 79 253 188 215 71 157 125 188 214 111 159 74 247 222 159 2 126 248 160 140 79 190 39 230 159 207 73 250 234 99 220 126 184 236 191 15 73 252 242 11 92 127 183 244 223 63 168 254 217 230 207 255 31 254 251 95 31 2 40 64 133 21 48 90 4 60 32 28 18 168 64 135 53 240 109 33 0 0 59 )
!

tab2BottomGif
	"'imgs/tab2bottom.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 1 0 1 0 128 0 0 204 204 204 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 1 0 1 0 0 2 2 68 1 0 59 13 10 )
!

tab3BackGif
	"'imgs/jure-tabs-back.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 7 0 24 0 213 0 0 0 0 0 255 255 255 254 255 254 254 255 253 251 252 250 251 252 249 250 251 248 250 251 247 248 249 245 247 248 242 245 246 240 244 245 238 243 244 237 242 243 236 243 244 236 242 243 235 243 243 234 243 243 235 242 242 234 244 244 237 243 243 236 242 242 235 247 247 241 246 246 240 245 245 239 244 244 238 243 243 237 248 248 243 247 247 242 246 246 241 249 249 245 247 247 243 246 246 242 252 252 249 251 251 248 250 250 247 252 252 250 250 250 248 254 254 253 253 253 252 247 246 242 251 250 247 254 253 252 252 251 250 254 254 254 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 45 0 44 0 0 0 0 7 0 24 0 64 6 88 192 71 37 242 128 72 32 30 15 34 153 12 56 159 1 140 116 138 97 153 88 44 1 107 0 125 106 40 140 73 216 97 65 129 56 40 139 37 180 34 21 8 132 85 119 78 127 70 40 148 72 227 190 232 103 22 127 23 10 23 29 131 29 9 28 31 31 27 139 34 6 7 41 37 35 37 39 149 39 42 42 39 117 155 156 157 80 65 0 59 )
!

tab5BgGif
	"'imgs/jure-tab-bg.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 20 0 45 0 196 0 0 221 227 213 219 225 211 254 254 254 242 244 238 230 233 224 218 224 210 252 252 252 245 247 242 249 249 247 234 237 228 224 228 214 229 232 222 238 241 234 237 240 233 239 242 235 226 229 218 248 248 246 247 247 245 243 245 240 233 236 227 250 250 248 251 251 251 235 238 231 119 102 85 227 230 219 228 231 221 253 253 253 236 239 232 225 228 217 241 243 238 224 227 216 232 235 226 44 0 0 0 0 20 0 45 0 0 5 40 160 32 142 100 105 158 104 170 174 108 235 190 112 44 207 116 109 223 120 174 239 124 239 255 192 160 112 72 44 26 143 200 228 204 194 108 58 159 207 16 0 59 )
!

tab5LeftGif
	"'imgs/jure-tab-left.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 9 0 142 0 213 0 0 0 0 0 255 255 255 214 226 233 133 176 198 132 175 197 131 174 196 131 173 195 129 171 193 128 170 191 134 177 199 130 172 193 129 170 192 128 169 190 127 168 189 135 177 199 131 172 193 125 164 184 136 178 200 136 177 199 136 178 199 134 175 197 135 176 197 131 170 191 128 167 187 127 165 185 130 169 189 135 173 193 132 168 187 144 177 194 154 184 200 185 206 217 198 215 224 209 223 230 211 224 231 235 241 244 130 173 194 132 175 196 135 178 199 134 177 198 132 175 195 134 177 197 133 174 194 129 169 188 126 165 184 140 175 192 152 183 198 172 197 209 171 196 208 253 254 254 252 253 253 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 50 0 44 0 0 0 0 9 0 142 0 0 6 191 192 128 80 8 19 184 90 195 128 168 131 89 173 134 159 77 211 41 244 56 87 153 20 37 16 114 94 42 145 200 36 198 90 89 36 225 201 4 4 121 168 223 165 151 10 94 42 57 56 168 122 221 193 215 240 255 14 9 9 10 130 133 9 38 38 39 136 139 136 3 4 3 144 145 146 147 148 145 4 151 152 153 154 155 156 36 152 36 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 181 5 204 205 206 205 6 206 6 211 212 213 214 213 35 217 218 35 6 217 10 223 223 222 224 227 223 7 230 231 7 10 232 235 231 11 238 232 238 241 239 238 8 245 245 241 245 12 250 247 8 250 254 251 255 2 254 107 240 47 8 0 59 )
!

tab5LeftOnGif
	"'imgs/jure-tab-left-on.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 9 0 142 0 213 0 0 0 0 0 255 255 255 228 228 219 225 225 216 224 224 215 223 223 214 222 222 213 240 240 231 239 239 230 238 238 229 237 237 228 236 236 227 235 235 226 234 234 225 232 232 223 231 231 222 227 227 219 226 226 218 225 225 217 224 224 216 223 223 215 222 222 214 221 221 213 220 220 212 219 219 211 218 218 210 217 217 209 216 216 208 240 240 232 239 239 231 236 236 228 234 234 226 233 233 225 232 232 224 230 230 222 220 220 213 215 215 208 214 214 207 228 228 221 226 226 219 224 224 217 236 236 230 231 231 225 229 229 223 239 239 234 242 242 238 245 245 242 245 245 243 244 244 242 250 250 249 254 254 254 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 51 0 44 0 0 0 0 9 0 142 0 0 6 255 192 128 112 248 74 169 134 129 152 106 82 144 12 91 17 138 193 224 12 176 8 149 138 32 145 8 184 38 134 129 130 195 149 153 10 162 14 135 156 128 77 66 235 53 55 5 137 31 14 220 149 231 206 231 158 16 124 119 92 19 129 130 9 132 133 131 133 120 135 139 138 137 9 20 8 147 148 92 146 148 147 150 152 153 145 156 92 92 21 159 162 9 161 163 160 166 167 168 165 166 171 163 173 162 175 159 177 169 172 168 164 182 179 183 170 184 188 187 190 181 191 174 189 192 196 194 193 176 195 198 197 200 199 178 201 204 203 206 205 180 202 213 208 214 210 209 212 215 220 217 216 219 222 221 224 227 186 218 229 223 231 226 233 225 236 228 185 239 207 237 235 238 241 244 211 243 248 240 247 250 230 252 232 254 234 0 202 19 104 175 95 189 124 7 9 38 176 160 160 161 67 46 12 27 46 104 200 101 196 130 139 24 43 98 204 152 96 4 131 143 32 185 92 96 240 161 100 73 46 24 76 154 68 9 162 165 75 46 25 92 190 76 16 19 68 136 155 32 96 222 220 25 130 139 134 18 16 14 130 6 245 25 244 129 81 7 92 54 216 34 177 212 86 16 0 59 )
!

tab5RightGif
	"'imgs/jure-tab-right.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 236 0 142 0 213 0 0 0 0 0 255 255 255 133 176 198 132 175 197 131 174 196 131 173 195 129 171 193 128 170 191 126 167 188 124 164 185 134 177 199 130 172 193 129 170 192 128 169 190 127 168 189 126 166 187 125 165 186 124 164 184 123 163 183 135 177 199 129 169 190 125 164 184 123 162 182 136 178 200 136 178 199 135 176 198 134 175 197 137 178 200 137 179 200 133 173 194 127 165 185 138 179 200 139 180 201 139 179 200 133 172 192 131 169 189 130 168 187 129 167 186 128 166 185 141 181 202 140 180 201 139 178 199 138 178 198 130 167 186 142 182 202 134 172 191 132 169 188 131 168 187 134 170 189 130 173 194 132 175 196 125 166 186 135 178 199 134 177 198 131 173 193 127 166 185 126 165 184 130 170 189 140 181 201 137 177 196 131 169 187 132 169 187 133 170 188 255 255 255 33 249 4 1 0 0 63 0 44 0 0 0 0 236 0 142 0 0 6 255 64 83 169 180 34 189 120 61 151 111 185 132 57 159 208 168 116 74 173 90 175 216 172 118 203 237 122 191 93 230 210 213 235 253 206 232 223 77 72 52 34 147 226 184 124 78 175 219 239 248 188 126 207 239 251 255 128 118 46 100 60 47 47 105 63 30 38 108 69 134 111 73 131 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 131 101 60 133 36 43 105 28 31 31 32 32 40 58 58 39 179 44 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 185 41 59 45 43 67 38 103 27 171 173 174 176 178 179 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 231 182 218 177 42 35 37 207 63 23 209 172 211 175 213 214 232 249 250 251 252 253 254 255 249 98 233 64 129 2 68 8 17 38 110 252 192 32 143 131 180 122 246 8 74 156 72 177 162 197 139 24 51 106 220 200 177 163 199 143 32 67 138 252 40 112 160 68 87 174 88 117 240 240 131 6 195 134 15 33 162 156 73 179 166 205 155 56 115 234 220 201 179 167 207 255 159 64 131 10 29 106 147 222 7 14 57 112 76 112 201 112 67 180 152 70 163 74 157 74 181 170 213 171 88 179 106 221 202 181 171 215 175 96 89 205 164 234 112 67 134 10 10 150 50 189 32 207 169 67 168 97 227 202 157 75 183 174 221 187 88 223 58 101 139 129 66 141 180 106 49 8 102 219 214 169 225 195 136 19 43 94 204 184 177 227 199 144 35 75 158 76 185 178 229 201 111 57 36 38 44 152 134 141 26 127 21 0 166 65 90 240 96 194 168 83 171 94 205 186 181 235 215 176 99 203 158 77 187 182 237 219 184 83 155 238 76 99 130 6 1 2 64 135 6 60 65 45 233 227 200 147 43 95 206 188 185 243 231 208 163 75 159 78 189 186 245 235 212 119 51 47 62 65 52 240 239 193 65 139 30 207 189 188 249 243 232 211 171 95 207 190 189 251 247 240 227 203 159 79 191 126 250 241 162 65 15 24 0 190 191 240 255 0 6 40 224 128 4 22 104 224 129 8 38 168 224 130 12 54 232 224 131 195 229 71 32 112 251 85 184 95 127 24 102 168 225 134 28 118 232 255 225 135 32 134 40 226 136 36 150 104 226 137 26 90 168 226 133 40 182 232 226 139 48 198 40 227 140 38 174 184 34 141 56 230 168 227 142 60 186 104 227 143 44 246 40 228 144 68 22 137 34 144 72 86 104 228 146 76 54 201 100 146 80 58 41 229 148 84 194 8 101 148 85 102 169 229 150 27 94 153 36 151 96 134 153 165 151 72 138 105 230 153 70 146 9 36 154 108 182 153 163 154 63 186 41 231 156 45 194 105 35 157 120 230 9 162 157 55 234 233 231 159 224 241 169 34 160 132 250 41 168 133 133 38 74 231 161 74 42 234 40 155 140 6 249 232 164 96 70 202 31 165 152 110 105 105 166 156 86 185 105 167 160 54 249 105 168 164 18 57 106 169 168 238 120 106 170 172 206 184 106 171 176 250 24 105 172 180 190 248 106 173 184 134 120 107 174 188 114 184 107 175 192 246 247 107 176 196 14 75 44 176 198 30 203 107 178 202 226 202 108 179 180 62 11 45 172 210 78 203 106 181 214 162 138 109 182 164 110 203 45 168 222 126 203 105 184 226 98 74 110 185 147 158 139 255 174 163 234 174 155 104 187 238 18 10 111 188 127 206 75 175 158 246 222 139 103 190 250 206 201 111 191 110 254 11 48 164 179 14 172 109 193 6 119 139 112 194 224 46 204 240 184 14 63 108 110 196 18 167 75 113 197 236 94 140 241 187 26 111 44 111 199 30 215 11 114 200 248 142 76 242 190 38 159 236 111 202 42 7 204 114 203 4 51 10 51 199 50 207 252 113 205 54 139 140 115 206 37 239 204 51 202 62 255 188 114 208 66 187 76 116 209 49 31 138 52 208 74 47 61 116 211 78 27 13 117 212 73 11 74 181 212 86 95 93 53 159 90 111 109 103 215 104 10 12 118 140 98 143 109 235 203 102 23 89 118 218 71 162 205 182 144 107 191 93 98 220 114 143 72 119 221 186 186 141 247 155 122 239 77 227 221 126 119 8 120 224 93 246 77 184 149 134 31 46 235 209 138 247 56 120 227 129 38 14 121 141 146 79 78 226 227 150 99 62 185 230 144 115 222 184 231 138 131 126 184 232 132 147 30 184 233 126 163 190 183 234 120 91 42 169 229 124 67 41 195 236 50 184 110 255 251 237 184 231 174 251 238 188 211 46 3 1 192 7 79 128 239 196 23 111 252 241 200 39 175 252 242 204 55 239 252 243 208 71 47 253 244 209 11 47 124 1 216 103 175 253 246 214 119 239 253 247 224 135 47 254 248 228 151 111 254 249 232 167 175 254 250 215 111 239 126 246 4 188 95 64 12 244 211 47 255 253 248 231 175 255 254 252 247 239 255 255 0 12 160 0 7 248 190 250 217 79 126 6 92 128 2 23 200 192 6 58 240 129 16 140 160 4 39 72 193 10 90 240 130 24 204 160 6 55 200 65 12 26 112 126 11 52 128 8 71 72 194 18 154 240 132 40 76 161 10 87 200 194 22 186 240 133 48 140 161 12 103 72 67 25 46 48 6 11 40 33 3 118 200 128 3 248 240 135 64 12 162 16 135 72 196 34 26 241 136 72 76 162 18 151 200 196 38 58 241 137 80 20 34 15 25 80 194 28 138 112 135 63 108 128 22 183 200 197 46 122 241 139 96 12 163 24 199 72 198 50 154 241 140 104 76 163 26 215 200 70 49 254 112 135 36 196 98 23 29 64 199 58 218 255 241 142 120 204 163 30 247 200 199 62 250 241 143 128 12 164 32 7 73 200 66 26 82 143 93 60 0 28 123 120 128 45 222 17 1 144 140 164 36 39 73 201 74 90 242 146 152 204 164 38 55 201 201 78 122 242 147 160 12 165 40 37 121 199 45 250 176 135 142 164 227 36 31 192 202 86 186 242 149 176 140 165 44 103 73 203 90 218 242 150 184 204 165 46 119 201 203 94 250 146 149 147 172 163 41 27 217 0 85 66 146 149 51 72 166 50 151 201 204 102 58 243 153 208 140 166 52 167 73 205 106 90 243 154 216 204 166 54 183 217 76 96 66 146 142 90 36 166 3 34 249 128 100 66 224 156 232 76 167 58 215 201 206 118 186 243 157 240 140 167 60 231 73 207 122 218 243 158 248 204 103 59 147 249 128 72 58 192 145 199 156 1 58 19 64 208 8 24 244 160 8 77 168 66 23 202 208 134 58 244 161 16 141 168 68 39 74 209 138 90 244 162 24 53 40 65 19 128 206 25 244 19 1 255 84 101 57 207 89 80 9 152 244 164 40 77 169 74 87 202 210 150 186 244 165 65 48 141 169 76 103 74 211 154 218 244 166 56 85 105 4 8 122 78 143 130 212 152 2 133 64 2 34 128 82 11 24 245 168 72 77 170 82 151 202 212 166 58 245 169 80 141 170 84 167 74 213 170 90 245 170 88 53 42 74 119 218 211 111 6 1 0 59 )
!

tab5RightOnGif
	"'imgs/jure-tab-right-on.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 236 0 142 0 213 0 0 0 0 0 255 255 255 209 209 200 205 205 196 230 230 221 229 229 220 228 228 219 227 227 218 226 226 217 225 225 216 224 224 215 223 223 214 222 222 213 221 221 212 220 220 211 219 219 210 218 218 209 217 217 208 216 216 207 215 215 206 214 214 205 211 211 202 241 241 232 240 240 231 239 239 230 238 238 229 237 237 228 236 236 227 235 235 226 232 232 223 231 231 222 226 226 218 225 225 217 224 224 216 223 223 215 222 222 214 213 213 205 212 212 204 208 208 200 207 207 199 206 206 198 205 205 197 241 241 233 240 240 232 237 237 229 234 234 226 233 233 225 232 232 224 230 230 223 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 49 0 44 0 0 0 0 236 0 142 0 0 6 255 64 145 98 24 42 134 18 72 144 114 201 108 58 159 208 168 116 74 173 90 175 216 172 118 203 93 34 19 197 152 120 28 19 45 206 162 180 144 104 108 187 223 240 184 124 78 175 219 239 248 188 126 207 239 191 135 10 34 97 100 11 35 103 11 106 105 128 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 145 137 10 132 22 161 162 22 42 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 172 44 45 5 102 67 98 11 163 193 184 195 196 197 198 199 200 201 195 161 44 8 11 159 49 11 43 193 212 164 202 215 216 217 218 219 184 212 23 48 35 34 209 43 211 213 230 231 232 233 234 235 236 237 238 239 240 241 242 243 241 47 11 227 228 229 244 251 252 253 254 255 0 3 238 251 112 230 66 62 114 2 19 42 92 200 176 97 194 21 27 22 48 184 64 241 96 62 135 24 51 106 220 24 208 162 68 138 32 45 138 28 73 178 164 201 147 40 83 170 92 201 178 165 203 151 48 83 142 58 121 225 35 200 155 6 99 234 220 201 179 167 207 255 159 64 123 130 180 137 179 168 209 163 72 147 42 93 202 180 169 211 167 80 163 74 157 250 244 224 82 6 19 169 106 221 202 181 171 215 175 96 195 30 101 208 0 131 216 179 104 211 170 93 203 150 34 89 12 112 227 182 157 75 183 174 221 180 111 227 234 133 123 183 175 223 191 128 111 230 221 171 55 176 225 195 136 187 234 109 80 150 112 225 196 144 35 75 6 233 24 46 227 202 114 39 107 222 236 23 51 134 203 158 57 139 30 189 214 243 231 198 152 73 171 94 237 213 52 232 212 172 99 203 126 234 26 117 229 217 184 115 31 173 109 90 183 111 223 188 67 255 30 46 59 56 108 226 200 73 27 191 157 188 57 231 229 142 157 75 159 12 157 240 244 235 137 171 239 197 206 61 176 246 199 221 195 219 253 158 89 188 249 182 228 249 158 95 175 54 189 89 246 240 197 186 143 79 255 235 252 250 248 181 222 207 207 31 234 254 254 0 46 245 95 128 4 26 53 96 129 8 82 116 96 130 5 46 200 96 128 14 62 216 95 132 18 230 71 97 133 245 93 136 97 124 26 110 200 255 94 135 30 158 7 98 136 226 141 72 98 119 38 158 136 93 138 42 78 199 98 139 206 189 8 99 114 50 206 72 92 141 54 254 134 99 142 186 237 200 35 110 62 254 88 156 103 175 49 39 164 121 65 30 185 90 146 74 42 71 164 109 209 53 25 30 147 82 62 247 100 111 85 114 71 101 150 212 93 41 28 151 46 122 121 28 152 49 138 105 36 153 205 109 137 38 98 106 174 105 88 155 110 2 6 103 156 157 153 25 37 157 195 205 137 231 120 118 90 183 167 142 125 110 247 39 112 129 130 55 40 144 133 150 119 232 108 122 46 90 90 162 234 57 58 36 102 69 222 41 41 107 141 94 122 86 166 154 134 197 105 167 246 65 250 30 168 78 82 10 165 159 164 142 246 105 170 91 173 202 42 85 174 190 42 85 172 178 250 39 106 173 155 209 138 107 83 186 238 42 224 173 190 70 214 107 176 72 13 75 172 129 192 30 123 152 177 202 222 196 108 179 10 38 11 237 95 207 66 91 109 179 215 42 155 237 177 219 18 219 109 176 223 250 26 238 174 227 226 90 110 173 231 202 154 255 238 171 235 178 218 110 170 239 146 26 47 168 243 118 90 175 166 247 94 154 175 164 251 58 218 239 162 255 30 234 94 164 211 214 101 154 101 14 100 160 240 193 12 55 236 240 195 16 71 44 241 196 20 87 108 113 196 10 103 224 192 3 26 116 236 113 198 32 135 44 242 200 36 151 108 242 201 40 167 172 242 202 44 183 236 242 203 48 175 236 177 199 15 60 176 193 205 56 231 172 243 204 60 247 236 243 207 64 7 45 244 208 68 23 109 244 209 72 39 173 244 210 58 55 157 115 205 78 115 32 181 212 78 87 109 245 213 88 103 173 245 214 92 119 237 245 215 96 135 45 246 212 84 55 93 51 217 45 164 173 246 218 108 183 237 246 219 112 199 45 247 220 116 215 109 247 221 120 231 173 247 222 119 147 253 0 4 106 187 32 248 224 132 23 110 248 225 136 39 174 248 226 140 55 238 248 227 144 71 46 249 228 148 75 174 54 4 17 20 254 194 230 47 116 224 249 231 160 135 46 250 232 164 151 110 250 233 168 167 174 250 234 172 183 238 250 235 176 139 206 249 11 133 71 32 255 129 224 155 127 238 193 238 188 247 238 251 239 192 7 47 252 240 196 23 111 252 241 200 39 175 252 242 204 55 63 252 231 155 11 46 129 4 185 251 78 192 245 216 103 175 253 246 220 119 239 253 247 224 135 47 254 248 228 151 111 254 249 232 167 223 189 239 29 108 46 193 4 158 243 126 125 1 244 27 96 255 253 248 231 175 255 254 252 247 239 255 255 0 12 160 0 7 72 192 2 26 240 128 8 196 31 253 10 112 61 222 121 110 2 20 144 95 253 240 119 128 10 90 240 130 24 204 160 6 55 200 193 14 122 240 131 32 12 161 8 71 72 194 18 154 240 132 21 204 31 253 8 192 59 10 68 208 3 4 40 192 253 42 136 128 26 218 240 134 56 204 161 14 119 200 195 30 250 240 135 64 12 162 16 135 72 196 34 26 241 136 57 76 161 253 24 184 59 10 144 192 3 50 180 223 1 106 216 133 42 90 241 138 88 204 162 22 183 88 197 26 30 224 126 5 240 0 9 72 64 0 41 34 96 9 70 72 132 26 215 200 198 54 186 241 141 112 140 163 28 231 72 199 58 218 119 241 142 120 204 99 27 141 176 4 4 124 209 0 4 32 65 9 100 56 69 37 20 65 4 35 72 164 34 23 201 200 70 58 242 145 144 140 164 36 39 73 201 74 90 242 146 152 204 164 38 55 217 72 65 132 64 9 126 52 64 1 74 80 130 10 84 64 0 38 48 193 9 80 144 130 86 166 96 0 176 140 165 44 103 73 203 90 218 242 150 184 204 165 46 119 201 203 94 250 242 151 192 12 166 48 97 233 202 20 160 224 4 169 20 128 41 75 16 4 0 59 )
!

textFontSizeGif
	"'imgs/fast/fast-font_size.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 54 0 14 0 128 1 0 153 153 153 238 238 238 33 249 4 1 0 0 1 0 44 0 0 0 0 54 0 14 0 0 2 75 140 143 169 203 237 15 163 76 0 204 139 143 189 251 245 252 69 97 230 85 155 169 161 129 57 170 167 186 86 200 215 213 134 189 46 33 173 245 247 236 203 9 133 163 27 110 24 131 81 130 39 95 209 249 3 42 120 169 99 109 39 139 178 170 71 146 247 11 14 139 199 228 114 163 0 0 59 13 10 )
!

textSizeLargeGif
	"'imgs/fast/fast-t_lg.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 16 0 15 0 196 28 0 249 249 246 250 250 248 254 254 253 252 252 250 252 252 251 246 246 242 248 248 245 247 247 244 243 243 238 241 241 235 245 245 240 255 255 254 247 247 243 242 242 237 251 251 250 244 244 239 244 244 240 249 249 247 200 200 185 253 253 253 245 245 241 240 240 233 242 242 236 250 250 247 254 254 254 253 253 252 251 251 249 245 245 236 177 176 176 232 232 222 196 196 181 255 255 255 33 249 4 1 0 0 28 0 44 0 0 0 0 16 0 15 0 0 5 96 224 182 117 100 105 146 226 248 173 108 187 122 170 43 191 221 60 123 245 202 237 252 206 226 50 159 11 232 18 178 22 196 150 17 35 200 36 89 62 102 134 160 121 234 56 147 204 64 19 0 60 23 152 221 246 2 56 20 136 82 130 35 16 49 152 21 15 92 154 11 48 48 10 10 68 35 1 147 108 187 118 20 16 8 22 9 21 48 34 30 138 139 140 138 34 33 0 59 13 10 )
!

textSizeMediumGif
	"'imgs/fast/fast-t_med.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 16 0 15 0 196 28 0 249 249 246 252 252 251 250 250 248 254 254 253 252 252 250 248 248 245 246 246 242 243 243 238 247 247 243 245 245 240 241 241 235 255 255 254 253 253 253 247 247 244 200 200 185 250 250 247 242 242 237 245 245 241 240 240 233 242 242 236 251 251 250 244 244 240 249 249 247 244 244 239 254 254 254 253 253 252 251 251 249 245 245 236 177 176 176 232 232 222 196 196 181 255 255 255 33 249 4 1 0 0 28 0 44 0 0 0 0 16 0 15 0 0 5 96 224 182 117 100 105 146 226 248 173 108 187 122 170 43 191 221 60 123 181 237 226 45 231 255 45 158 203 231 90 8 123 28 22 102 144 57 178 136 203 76 64 227 92 249 24 25 130 70 0 112 46 48 140 128 246 1 104 24 132 209 0 69 96 41 152 19 23 92 122 11 40 32 12 137 3 68 1 115 104 185 118 17 21 7 19 10 18 48 34 30 138 139 140 138 34 33 0 59 13 10 )
!

textSizeSmallGif
	"'imgs/fast/fast-t_med.gif' asFilename contentsAsMethod"
^#(71 73 70 56 57 97 16 0 15 0 196 28 0 249 249 246 252 252 251 250 250 248 254 254 253 252 252 250 248 248 245 246 246 242 243 243 238 247 247 243 245 245 240 241 241 235 255 255 254 253 253 253 247 247 244 200 200 185 250 250 247 242 242 237 245 245 241 240 240 233 242 242 236 251 251 250 244 244 240 249 249 247 244 244 239 254 254 254 253 253 252 251 251 249 245 245 236 177 176 176 232 232 222 196 196 181 255 255 255 33 249 4 1 0 0 28 0 44 0 0 0 0 16 0 15 0 0 5 96 224 182 117 100 105 146 226 248 173 108 187 122 170 43 191 221 60 123 181 237 226 45 231 255 45 158 203 231 90 8 123 28 22 102 144 57 178 136 203 76 64 227 92 249 24 25 130 70 0 112 46 48 140 128 246 1 104 24 132 209 0 69 96 41 152 19 23 92 122 11 40 32 12 137 3 68 1 115 104 185 118 17 21 7 19 10 18 48 34 30 138 139 140 138 34 33 0 59 13 10 )
!

transparentPixelGif
	"transparent 1x1 gif"
	"'imgs/trapix.gif' asFilename contentsAsMethod"
^#(71 73 70 56 55 97 1 0 1 0 179 0 0 255 255 255 196 0 67 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 0 0 44 0 0 0 0 1 0 1 0 0 4 2 16 68 0 59 )
! !

!WebStyle methodsFor:'maintenance'!

adjustCSSLink: aString
	" '../images/arrow_left.gif' to '/img/arrowLeftGif.gif' "
	| in name extension |
	in := aString readStream.
	[in atEnd] whileFalse: [name := in upTo: $/]. "to find filename only"
	extension := name readStream upTo: $. ; upToEnd.
	name := self adjustImageName: name.
	^'/img/', name, '.', extension.
!

adjustImageName: aFilenameString
	"left_arrow.gif = leftArrowGif"
	| in out |
	in := aFilenameString readStream. out := WriteStream on: String new.
	in peek isDigit ifTrue: [out nextPut: $a]. "method cannot start with digit!!"
	[in atEnd] whileFalse:
		[(#($- $_ $. ) includes:  in peek)
			ifTrue: [in next "skip". out nextPut: in next asUppercase]
			ifFalse: [out nextPut: in next] ].
	^out contents
!

adjustLinksInCSSMethod: aMethodSymbol
	"external image links in CSS are changed to format, eg. for arrow.gif  '/img/arrowGif.gif' "
	"this method is then recompiled back in 'styles-screen' !! "
	"WebStyle new adjustLinksInCSSMethod: #css1Body"
	| method in out chunk link dd |
	method := self class compiledMethodAt: aMethodSymbol. method := method getSource asString.
	in := method readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[chunk := in upToAll: 'url('. in atEnd not ifTrue: [in skip: 4]. link := in upTo: $).
		dd := (link includes: $") ifTrue: [link := link copyWithout: $". '"'] ifFalse: [''].
		out nextPutAll: chunk.
		link notEmpty ifTrue:
			[link := self adjustCSSLink: link.  out nextPutAll: 'url(', dd, link, dd, ')'] ].
	out contents = method ifFalse:
		[self class compile: out contents classified: 'styles-screen'].
	^out contents
!

importImage: aName from: aFilenameString
        "reads an image, converts it to a method named aName and make that method in
       method protocol 'imgs'"
        "WebStyle new importImage: 'infoGif' from: 'imgs/info.gif' "
        | fname method |
        fname := (SpFilename named:aFilenameString).
        method := fname contentsAsMethod.
        method := aName, (String with: Character cr), method.
        self class compile: method classified: 'imgs'
!

importImageFrom: aFilenameString
        "reads an image, converts it to a method and make that method in method protocol 'imgs'"
        "name of a method is composed from a name of a file: arrow.gif = arrowGif"
        "WebStyle new importImageFrom: 'imgs/info.gif' "
        | iname |
        iname := self adjustImageName: (SpFilename named:aFilenameString) tail.
        self importImage: iname from: aFilenameString
!

importImagesFromDirectory: aDirectoryString
        "reads alss image, converts them to methods and put them in protocol 'imgs'"
        "name of a method is composed from a name of a file: arrow.gif = arrowGif"
        "WebStyle new importImagesFromDirectory: 'imgs/crystalsvg/64' "
        | fnames fname |
        fnames := (SpFilename named:aDirectoryString) directoryContents.
        fnames do: [:each |
                fname := aDirectoryString, (String with: (SpFilename named:aDirectoryString) separator), each.
                (SpFilename named:fname) isDirectory ifFalse: [self importImageFrom: fname] ]
! !

!WebStyle methodsFor:'private'!

helpText
	^'Help'
!

initResources
	resources := Dictionary new
!

resources
	resources isNil ifTrue: [self initResources].
	^resources
!

site: anAIDASite
	site := anAIDASite
! !

!WebStyle methodsFor:'private-css'!

allCssPrintMethods
	"WebStyle new allCssPrintMethods"
	| methods |
	methods := self class allSelectors select: [:each | 'cssPrint*' match:each asString].
	^SortedCollection withAll: methods sortBlock: [:a :b | a < b]
!

allCssScreenMethods
	"for screen styles, all css* except cssPrint* , sorted alphabeticaly"
	"WebStyle new allCssScreenMethods"
	| methods print |
	methods := self class allSelectors select: [:each | 'css*' match:each asString].
	print := self allCssPrintMethods asSet.
	^SortedCollection
		withAll: (methods reject: [:each | print includes: each])
		sortBlock: [:a :b | a < b]
!

printCssResource
	" /print.css , returns all cssPrint* methods (alphabetically sorted) concatenated "
	"WebStyle new printCssResource"
	^self resources at: #cssPrint ifAbsentPut:
		[WebMethodResource
			fromMethod: #printStyleSheet on: self
			contentType: 'text/css' preferedUrl: '/print.css' site: self site].
!

printStyleSheet
	"concatenate all cssPrint* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new printStyleSheet"
	| stream content |
	stream := WriteStream on: String new.
	self allCssPrintMethods do: [:method |
		content := self perform: method.
		content notEmpty ifTrue:
			[stream nextPut: Character cr.
			stream nextPutAll: ('/*', self class name, ' ', method asString, '*/').
			stream nextPut: Character cr.
			stream nextPutAll: content] ].
	^stream contents
!

screenCssResource
	" /screen.css , returns all css* methods (alphabetically sorted) concatenated "
	"WebStyle new screenCssResource"
	^self resources at: #cssScreen ifAbsentPut:
		[WebMethodResource
			fromMethod: #screenStyleSheet on: self
			contentType: 'text/css' preferedUrl: '/screen.css' site: self site].
!

screenStyleSheet
	"concatenate all css* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new screenStyleSheet"
	| stream content |
	stream := WriteStream on: String new.
	self allCssScreenMethods do: [:method |
		content := self perform: method.
		content notEmpty ifTrue:
			[stream nextPut: Character cr.
			stream nextPutAll: ('/*', self class name, ' ', method asString, '*/').
			stream nextPut: Character cr.
			stream nextPutAll: content] ].
	^stream contents
! !

!WebStyle methodsFor:'private-javascript'!

allJavascriptMethods
	"for javascript, all js* sorted alphabeticaly (sort is not realy needed, just for convenience)"
	"WebStyle new allJavascriptMethods"
	| methods |
	methods := self class allSelectors select: [:each | 'js*' match:each asString].
	^SortedCollection withAll: methods sortBlock: [:a :b | a < b]
!

javascript
	"concatenate all js* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new javascript"
	| stream |
	stream := WriteStream on: String new.
	self allJavascriptMethods do: [:method |
		stream nextPut: Character cr;   nextPut: Character lf.
		stream nextPutAll: ('/*', self class name, ' ', method asString, '*/').
		stream nextPut: Character cr;  nextPut: Character lf.
		stream nextPutAll: (self perform: method)].
		stream nextPut: Character cr;  nextPut: Character lf.
	^stream contents
!

javascriptResource
	" /scripts.js , returns all js* methods (alphabetically sorted) concatenated "
	"WebStyle new javascriptResource"
	^self resources at: #javascript ifAbsentPut:
		[WebMethodResource
			fromMethod: #javascript on: self
			contentType: 'text/javascript' preferedUrl: '/scripts.js' site: self site].
! !

!WebStyle methodsFor:'private-obsolete-colors'!

adminColor
	^#green
!

delimiterColor
	^#grey
!

headerColor
	^#ffff00
!

navigatorColor
	^#yellow
!

reportHeaderColor
	^#silver
!

tableHeaderColor
	^#thistle
!

tableRowColor
	^#fffbf0
!

tableSumaColor
	^#mediumgoldenrod
! !

!WebStyle methodsFor:'private-obsolete-printing-elements'!

addBreaksTo: aString
	"changes all cr with <br>"

	^aString copyReplaceAll: (String with: Character cr) with: '<br>'

"WebFrameApp new addBreaksTo: ('aaa', (String with: Character cr), 'bbb')"
!

addParagraphsTo: aString
	"changes all cr with <p>"

	^aString copyReplaceAll: (String with: Character cr) with: '<p>'

"WebFrameApp new addParagraphsTo: ('aaa', (String with: Character cr), 'bbb')"
!

printSeconds: aNumber

	^(aNumber // 3600) printString, ':',
	(self twoDigits: aNumber \\ 3600 // 60), ':',
	(self twoDigits: aNumber \\ 60)
!

printStamp: aTimestamp

	| stamp |
	stamp := (aTimestamp isKindOf: Integer)
		ifTrue: [Timestamp fromSeconds: aTimestamp]
		ifFalse: [aTimestamp isNil
			ifTrue: [Timestamp now] ifFalse: [aTimestamp]].
	^stamp asDate shortPrintSloString, ' ',
		stamp asTime hours printString, ':',
		(self twoDigits: stamp asTime minutes)
!

smallNumber: aNumber

	^self smallText: aNumber printDotString
!

smallNumber: aNumber attributes: aSymbol

	^self smallText: aNumber printDotString attributes: aSymbol
!

smallText: aText

	| text |
	text := aText isEmpty ifTrue: ['&nbsp;'] ifFalse: [aText].
	^(WebText text: text) size: -1; font: #helvetica
!

smallText: aText attributes: aSymbol

	| text |
	text := aText isEmpty ifTrue: ['&nbsp;'] ifFalse: [aText].
	^(WebText text: text attributes: aSymbol) size: -1; font: #helvetica
!

twoDigits: aNumber

	aNumber < 10
		ifTrue: [^'0',aNumber printString]
		ifFalse: [^aNumber printString]
! !

!WebStyle methodsFor:'scripts'!

jsCommon
	"common javaScript methods"
	^'
function nic()
	{}
function popUpPage(url, parameters, name)
{
}'
!

jsPrototypeFramework
	^'
/*  Prototype JavaScript framework, version 1.5.0
 *  (c) 2005-2007 Sam Stephenson
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *  For details, see the Prototype web site: http://prototype.conio.net/
 *
/*--------------------------------------------------------------------------*/

var Prototype = {
  Version: ''1.5.0'',
  BrowserFeatures: {
    XPath: !!!!document.evaluate
  },

  ScriptFragment: ''(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)'',
  emptyFunction: function() {},
  K: function(x) { return x }
}

var Class = {
  create: function() {
    return function() {
      this.initialize.apply(this, arguments);
    }
  }
}

var Abstract = new Object();

Object.extend = function(destination, source) {
  for (var property in source) {
    destination[property] = source[property];
  }
  return destination;
}

Object.extend(Object, {
  inspect: function(object) {
    try {
      if (object === undefined) return ''undefined'';
      if (object === null) return ''null'';
      return object.inspect ? object.inspect() : object.toString();
    } catch (e) {
      if (e instanceof RangeError) return ''...'';
      throw e;
    }
  },

  keys: function(object) {
    var keys = [];
    for (var property in object)
      keys.push(property);
    return keys;
  },

  values: function(object) {
    var values = [];
    for (var property in object)
      values.push(object[property]);
    return values;
  },

  clone: function(object) {
    return Object.extend({}, object);
  }
});

Function.prototype.bind = function() {
  var __method = this, args = $A(arguments), object = args.shift();
  return function() {
    return __method.apply(object, args.concat($A(arguments)));
  }
}

Function.prototype.bindAsEventListener = function(object) {
  var __method = this, args = $A(arguments), object = args.shift();
  return function(event) {
    return __method.apply(object, [( event || window.event)].concat(args).concat($A(arguments)));
  }
}

Object.extend(Number.prototype, {
  toColorPart: function() {
    var digits = this.toString(16);
    if (this < 16) return ''0'' + digits;
    return digits;
  },

  succ: function() {
    return this + 1;
  },

  times: function(iterator) {
    $R(0, this, true).each(iterator);
    return this;
  }
});

var Try = {
  these: function() {
    var returnValue;

    for (var i = 0, length = arguments.length; i < length; i++) {
      var lambda = arguments[i];
      try {
	returnValue = lambda();
	break;
      } catch (e) {}
    }

    return returnValue;
  }
}

/*--------------------------------------------------------------------------*/

var PeriodicalExecuter = Class.create();
PeriodicalExecuter.prototype = {
  initialize: function(callback, frequency) {
    this.callback = callback;
    this.frequency = frequency;
    this.currentlyExecuting = false;

    this.registerCallback();
  },

  registerCallback: function() {
    this.timer = setInterval(this.onTimerEvent.bind(this), this.frequency * 1000);
  },

  stop: function() {
    if (!!this.timer) return;
    clearInterval(this.timer);
    this.timer = null;
  },

  onTimerEvent: function() {
    if (!!this.currentlyExecuting) {
      try {
	this.currentlyExecuting = true;
	this.callback(this);
      } finally {
	this.currentlyExecuting = false;
      }
    }
  }
}
String.interpret = function(value){
  return value == null ? '''' : String(value);
}

Object.extend(String.prototype, {
  gsub: function(pattern, replacement) {
    var result = '''', source = this, match;
    replacement = arguments.callee.prepareReplacement(replacement);

    while (source.length > 0) {
      if (match = source.match(pattern)) {
	result += source.slice(0, match.index);
	result += String.interpret(replacement(match));
	source  = source.slice(match.index + match[0].length);
      } else {
	result += source, source = '''';
      }
    }
    return result;
  },

  sub: function(pattern, replacement, count) {
    replacement = this.gsub.prepareReplacement(replacement);
    count = count === undefined ? 1 : count;

    return this.gsub(pattern, function(match) {
      if (--count < 0) return match[0];
      return replacement(match);
    });
  },

  scan: function(pattern, iterator) {
    this.gsub(pattern, iterator);
    return this;
  },

  truncate: function(length, truncation) {
    length = length || 30;
    truncation = truncation === undefined ? ''...'' : truncation;
    return this.length > length ?
      this.slice(0, length - truncation.length) + truncation : this;
  },

  strip: function() {
    return this.replace(/^\s+/, '''').replace(/\s+$/, '''');
  },

  stripTags: function() {
    return this.replace(/<\/?[^>]+>/gi, '''');
  },

  stripScripts: function() {
    return this.replace(new RegExp(Prototype.ScriptFragment, ''img''), '''');
  },

  extractScripts: function() {
    var matchAll = new RegExp(Prototype.ScriptFragment, ''img'');
    var matchOne = new RegExp(Prototype.ScriptFragment, ''im'');
    return (this.match(matchAll) || []).map(function(scriptTag) {
      return (scriptTag.match(matchOne) || ['''', ''''])[1];
    });
  },

  evalScripts: function() {
    return this.extractScripts().map(function(script) { return eval(script) });
  },

  escapeHTML: function() {
    var div = document.createElement(''div'');
    var text = document.createTextNode(this);
    div.appendChild(text);
    return div.innerHTML;
  },

  unescapeHTML: function() {
    var div = document.createElement(''div'');
    div.innerHTML = this.stripTags();
    return div.childNodes[0] ? (div.childNodes.length > 1 ?
      $A(div.childNodes).inject('''',function(memo,node){ return memo+node.nodeValue }) :
      div.childNodes[0].nodeValue) : '''';
  },

  toQueryParams: function(separator) {
    var match = this.strip().match(/([^?#]*)(#.*)?$/);
    if (!!match) return {};

    return match[1].split(separator || ''&'').inject({}, function(hash, pair) {
      if ((pair = pair.split(''=''))[0]) {
	var name = decodeURIComponent(pair[0]);
	var value = pair[1] ? decodeURIComponent(pair[1]) : undefined;

	if (hash[name] !!== undefined) {
	  if (hash[name].constructor !!= Array)
	    hash[name] = [hash[name]];
	  if (value) hash[name].push(value);
	}
	else hash[name] = value;
      }
      return hash;
    });
  },

  toArray: function() {
    return this.split('''');
  },

  succ: function() {
    return this.slice(0, this.length - 1) +
      String.fromCharCode(this.charCodeAt(this.length - 1) + 1);
  },

  camelize: function() {
    var parts = this.split(''-''), len = parts.length;
    if (len == 1) return parts[0];

    var camelized = this.charAt(0) == ''-''
      ? parts[0].charAt(0).toUpperCase() + parts[0].substring(1)
      : parts[0];

    for (var i = 1; i < len; i++)
      camelized += parts[i].charAt(0).toUpperCase() + parts[i].substring(1);

    return camelized;
  },

  capitalize: function(){
    return this.charAt(0).toUpperCase() + this.substring(1).toLowerCase();
  },

  underscore: function() {
    return this.gsub(/::/, ''/'').gsub(/([A-Z]+)([A-Z][a-z])/,''#{1}_#{2}'').gsub(/([a-z\d])([A-Z])/,''#{1}_#{2}'').gsub(/-/,''_'').toLowerCase();
  },

  dasherize: function() {
    return this.gsub(/_/,''-'');
  },

  inspect: function(useDoubleQuotes) {
    var escapedString = this.replace(/\\/g, ''\\\\'');
    if (useDoubleQuotes)
      return ''"'' + escapedString.replace(/"/g, ''\\"'') + ''"'';
    else
      return "''" + escapedString.replace(/''/g, ''\\\'''') + "''";
  }
});

String.prototype.gsub.prepareReplacement = function(replacement) {
  if (typeof replacement == ''function'') return replacement;
  var template = new Template(replacement);
  return function(match) { return template.evaluate(match) };
}

String.prototype.parseQuery = String.prototype.toQueryParams;

var Template = Class.create();
Template.Pattern = /(^|.|\r|\n)(#\{(.*?)\})/;
Template.prototype = {
  initialize: function(template, pattern) {
    this.template = template.toString();
    this.pattern  = pattern || Template.Pattern;
  },

  evaluate: function(object) {
    return this.template.gsub(this.pattern, function(match) {
      var before = match[1];
      if (before == ''\\'') return match[2];
      return before + String.interpret(object[match[3]]);
    });
  }
}

var $break    = new Object();
var $continue = new Object();

var Enumerable = {
  each: function(iterator) {
    var index = 0;
    try {
      this._each(function(value) {
	try {
	  iterator(value, index++);
	} catch (e) {
	  if (e !!= $continue) throw e;
	}
      });
    } catch (e) {
      if (e !!= $break) throw e;
    }
    return this;
  },

  eachSlice: function(number, iterator) {
    var index = -number, slices = [], array = this.toArray();
    while ((index += number) < array.length)
      slices.push(array.slice(index, index+number));
    return slices.map(iterator);
  },

  all: function(iterator) {
    var result = true;
    this.each(function(value, index) {
      result = result && !!!!(iterator || Prototype.K)(value, index);
      if (!!result) throw $break;
    });
    return result;
  },

  any: function(iterator) {
    var result = false;
    this.each(function(value, index) {
      if (result = !!!!(iterator || Prototype.K)(value, index))
	throw $break;
    });
    return result;
  },

  collect: function(iterator) {
    var results = [];
    this.each(function(value, index) {
      results.push((iterator || Prototype.K)(value, index));
    });
    return results;
  },

  detect: function(iterator) {
    var result;
    this.each(function(value, index) {
      if (iterator(value, index)) {
	result = value;
	throw $break;
      }
    });
    return result;
  },

  findAll: function(iterator) {
    var results = [];
    this.each(function(value, index) {
      if (iterator(value, index))
	results.push(value);
    });
    return results;
  },

  grep: function(pattern, iterator) {
    var results = [];
    this.each(function(value, index) {
      var stringValue = value.toString();
      if (stringValue.match(pattern))
	results.push((iterator || Prototype.K)(value, index));
    })
    return results;
  },

  include: function(object) {
    var found = false;
    this.each(function(value) {
      if (value == object) {
	found = true;
	throw $break;
      }
    });
    return found;
  },

  inGroupsOf: function(number, fillWith) {
    fillWith = fillWith === undefined ? null : fillWith;
    return this.eachSlice(number, function(slice) {
      while(slice.length < number) slice.push(fillWith);
      return slice;
    });
  },

  inject: function(memo, iterator) {
    this.each(function(value, index) {
      memo = iterator(memo, value, index);
    });
    return memo;
  },

  invoke: function(method) {
    var args = $A(arguments).slice(1);
    return this.map(function(value) {
      return value[method].apply(value, args);
    });
  },

  max: function(iterator) {
    var result;
    this.each(function(value, index) {
      value = (iterator || Prototype.K)(value, index);
      if (result == undefined || value >= result)
	result = value;
    });
    return result;
  },

  min: function(iterator) {
    var result;
    this.each(function(value, index) {
      value = (iterator || Prototype.K)(value, index);
      if (result == undefined || value < result)
	result = value;
    });
    return result;
  },

  partition: function(iterator) {
    var trues = [], falses = [];
    this.each(function(value, index) {
      ((iterator || Prototype.K)(value, index) ?
	trues : falses).push(value);
    });
    return [trues, falses];
  },

  pluck: function(property) {
    var results = [];
    this.each(function(value, index) {
      results.push(value[property]);
    });
    return results;
  },

  reject: function(iterator) {
    var results = [];
    this.each(function(value, index) {
      if (!!iterator(value, index))
	results.push(value);
    });
    return results;
  },

  sortBy: function(iterator) {
    return this.map(function(value, index) {
      return {value: value, criteria: iterator(value, index)};
    }).sort(function(left, right) {
      var a = left.criteria, b = right.criteria;
      return a < b ? -1 : a > b ? 1 : 0;
    }).pluck(''value'');
  },

  toArray: function() {
    return this.map();
  },

  zip: function() {
    var iterator = Prototype.K, args = $A(arguments);
    if (typeof args.last() == ''function'')
      iterator = args.pop();

    var collections = [this].concat(args).map($A);
    return this.map(function(value, index) {
      return iterator(collections.pluck(index));
    });
  },

  size: function() {
    return this.toArray().length;
  },

  inspect: function() {
    return ''#<Enumerable:'' + this.toArray().inspect() + ''>'';
  }
}

Object.extend(Enumerable, {
  map:     Enumerable.collect,
  find:    Enumerable.detect,
  select:  Enumerable.findAll,
  member:  Enumerable.include,
  entries: Enumerable.toArray
});
var $A = Array.from = function(iterable) {
  if (!!iterable) return [];
  if (iterable.toArray) {
    return iterable.toArray();
  } else {
    var results = [];
    for (var i = 0, length = iterable.length; i < length; i++)
      results.push(iterable[i]);
    return results;
  }
}

Object.extend(Array.prototype, Enumerable);

if (!!Array.prototype._reverse)
  Array.prototype._reverse = Array.prototype.reverse;

Object.extend(Array.prototype, {
  _each: function(iterator) {
    for (var i = 0, length = this.length; i < length; i++)
      iterator(this[i]);
  },

  clear: function() {
    this.length = 0;
    return this;
  },

  first: function() {
    return this[0];
  },

  last: function() {
    return this[this.length - 1];
  },

  compact: function() {
    return this.select(function(value) {
      return value !!= null;
    });
  },

  flatten: function() {
    return this.inject([], function(array, value) {
      return array.concat(value && value.constructor == Array ?
	value.flatten() : [value]);
    });
  },

  without: function() {
    var values = $A(arguments);
    return this.select(function(value) {
      return !!values.include(value);
    });
  },

  indexOf: function(object) {
    for (var i = 0, length = this.length; i < length; i++)
      if (this[i] == object) return i;
    return -1;
  },

  reverse: function(inline) {
    return (inline !!== false ? this : this.toArray())._reverse();
  },

  reduce: function() {
    return this.length > 1 ? this : this[0];
  },

  uniq: function() {
    return this.inject([], function(array, value) {
      return array.include(value) ? array : array.concat([value]);
    });
  },

  clone: function() {
    return [].concat(this);
  },

  size: function() {
    return this.length;
  },

  inspect: function() {
    return ''['' + this.map(Object.inspect).join('', '') + '']'';
  }
});

Array.prototype.toArray = Array.prototype.clone;

function $w(string){
  string = string.strip();
  return string ? string.split(/\s+/) : [];
}

if(window.opera){
  Array.prototype.concat = function(){
    var array = [];
    for(var i = 0, length = this.length; i < length; i++) array.push(this[i]);
    for(var i = 0, length = arguments.length; i < length; i++) {
      if(arguments[i].constructor == Array) {
	for(var j = 0, arrayLength = arguments[i].length; j < arrayLength; j++)
	  array.push(arguments[i][j]);
      } else {
	array.push(arguments[i]);
      }
    }
    return array;
  }
}
var Hash = function(obj) {
  Object.extend(this, obj || {});
};

Object.extend(Hash, {
  toQueryString: function(obj) {
    var parts = [];

	  this.prototype._each.call(obj, function(pair) {
      if (!!pair.key) return;

      if (pair.value && pair.value.constructor == Array) {
	var values = pair.value.compact();
	if (values.length < 2) pair.value = values.reduce();
	else {
		key = encodeURIComponent(pair.key);
	  values.each(function(value) {
	    value = value !!= undefined ? encodeURIComponent(value) : '''';
	    parts.push(key + ''='' + encodeURIComponent(value));
	  });
	  return;
	}
      }
      if (pair.value == undefined) pair[1] = '''';
      parts.push(pair.map(encodeURIComponent).join(''=''));
	  });

    return parts.join(''&'');
  }
});

Object.extend(Hash.prototype, Enumerable);
Object.extend(Hash.prototype, {
  _each: function(iterator) {
    for (var key in this) {
      var value = this[key];
      if (value && value == Hash.prototype[key]) continue;

      var pair = [key, value];
      pair.key = key;
      pair.value = value;
      iterator(pair);
    }
  },

  keys: function() {
    return this.pluck(''key'');
  },

  values: function() {
    return this.pluck(''value'');
  },

  merge: function(hash) {
    return $H(hash).inject(this, function(mergedHash, pair) {
      mergedHash[pair.key] = pair.value;
      return mergedHash;
    });
  },

  remove: function() {
    var result;
    for(var i = 0, length = arguments.length; i < length; i++) {
      var value = this[arguments[i]];
      if (value !!== undefined){
	if (result === undefined) result = value;
	else {
	  if (result.constructor !!= Array) result = [result];
	  result.push(value)
	}
      }
      delete this[arguments[i]];
    }
    return result;
  },

  toQueryString: function() {
    return Hash.toQueryString(this);
  },

  inspect: function() {
    return ''#<Hash:{'' + this.map(function(pair) {
      return pair.map(Object.inspect).join('': '');
    }).join('', '') + ''}>'';
  }
});

function $H(object) {
  if (object && object.constructor == Hash) return object;
  return new Hash(object);
};
ObjectRange = Class.create();
Object.extend(ObjectRange.prototype, Enumerable);
Object.extend(ObjectRange.prototype, {
  initialize: function(start, end, exclusive) {
    this.start = start;
    this.end = end;
    this.exclusive = exclusive;
  },

  _each: function(iterator) {
    var value = this.start;
    while (this.include(value)) {
      iterator(value);
      value = value.succ();
    }
  },

  include: function(value) {
    if (value < this.start)
      return false;
    if (this.exclusive)
      return value < this.end;
    return value <= this.end;
  }
});

var $R = function(start, end, exclusive) {
  return new ObjectRange(start, end, exclusive);
}

var Ajax = {
  getTransport: function() {
    return Try.these(
      function() {return new XMLHttpRequest()},
      function() {return new ActiveXObject(''Msxml2.XMLHTTP'')},
      function() {return new ActiveXObject(''Microsoft.XMLHTTP'')}
    ) || false;
  },

  activeRequestCount: 0
}

Ajax.Responders = {
  responders: [],

  _each: function(iterator) {
    this.responders._each(iterator);
  },

  register: function(responder) {
    if (!!this.include(responder))
      this.responders.push(responder);
  },

  unregister: function(responder) {
    this.responders = this.responders.without(responder);
  },

  dispatch: function(callback, request, transport, json) {
    this.each(function(responder) {
      if (typeof responder[callback] == ''function'') {
	try {
	  responder[callback].apply(responder, [request, transport, json]);
	} catch (e) {}
      }
    });
  }
};

Object.extend(Ajax.Responders, Enumerable);

Ajax.Responders.register({
  onCreate: function() {
    Ajax.activeRequestCount++;
  },
  onComplete: function() {
    Ajax.activeRequestCount--;
  }
});

Ajax.Base = function() {};
Ajax.Base.prototype = {
  setOptions: function(options) {
    this.options = {
      method:       ''post'',
      asynchronous: true,
      contentType:  ''application/x-www-form-urlencoded'',
      encoding:     ''UTF-8'',
      parameters:   ''''
    }
    Object.extend(this.options, options || {});

    this.options.method = this.options.method.toLowerCase();
    if (typeof this.options.parameters == ''string'')
      this.options.parameters = this.options.parameters.toQueryParams();
  }
}

Ajax.Request = Class.create();
Ajax.Request.Events =
  [''Uninitialized'', ''Loading'', ''Loaded'', ''Interactive'', ''Complete''];

Ajax.Request.prototype = Object.extend(new Ajax.Base(), {
  _complete: false,

  initialize: function(url, options) {
    this.transport = Ajax.getTransport();
    this.setOptions(options);
    this.request(url);
  },

  request: function(url) {
    this.url = url;
    this.method = this.options.method;
    var params = this.options.parameters;

    if (!![''get'', ''post''].include(this.method)) {
      // simulate other verbs over post
      params[''_method''] = this.method;
      this.method = ''post'';
    }

    params = Hash.toQueryString(params);
    if (params && /Konqueror|Safari|KHTML/.test(navigator.userAgent)) params += ''&_=''

    // when GET, append parameters to URL
    if (this.method == ''get'' && params)
      this.url += (this.url.indexOf(''?'') > -1 ? ''&'' : ''?'') + params;

    try {
      Ajax.Responders.dispatch(''onCreate'', this, this.transport);

      this.transport.open(this.method.toUpperCase(), this.url,
	this.options.asynchronous);

      if (this.options.asynchronous)
	setTimeout(function() { this.respondToReadyState(1) }.bind(this), 10);

      this.transport.onreadystatechange = this.onStateChange.bind(this);
      this.setRequestHeaders();

      var body = this.method == ''post'' ? (this.options.postBody || params) : null;

      this.transport.send(body);

      /* Force Firefox to handle ready state 4 for synchronous requests */
      if (!!this.options.asynchronous && this.transport.overrideMimeType)
	this.onStateChange();

    }
    catch (e) {
      this.dispatchException(e);
    }
  },

  onStateChange: function() {
    var readyState = this.transport.readyState;
    if (readyState > 1 && !!((readyState == 4) && this._complete))
      this.respondToReadyState(this.transport.readyState);
  },

  setRequestHeaders: function() {
    var headers = {
      ''X-Requested-With'': ''XMLHttpRequest'',
      ''X-Prototype-Version'': Prototype.Version,
      ''Accept'': ''text/javascript, text/html, application/xml, text/xml, */*''
    };

    if (this.method == ''post'') {
      headers[''Content-type''] = this.options.contentType +
	(this.options.encoding ? ''; charset='' + this.options.encoding : '''');

      /* Force "Connection: close" for older Mozilla browsers to work
       * around a bug where XMLHttpRequest sends an incorrect
       * Content-length header. See Mozilla Bugzilla #246651.
       */
      if (this.transport.overrideMimeType &&
	  (navigator.userAgent.match(/Gecko\/(\d{4})/) || [0,2005])[1] < 2005)
	    headers[''Connection''] = ''close'';
    }

    // user-defined headers
    if (typeof this.options.requestHeaders == ''object'') {
      var extras = this.options.requestHeaders;

      if (typeof extras.push == ''function'')
	for (var i = 0, length = extras.length; i < length; i += 2)
	  headers[extras[i]] = extras[i+1];
      else
	$H(extras).each(function(pair) { headers[pair.key] = pair.value });
    }

    for (var name in headers)
      this.transport.setRequestHeader(name, headers[name]);
  },

  success: function() {
    return !!this.transport.status
	|| (this.transport.status >= 200 && this.transport.status < 300);
  },

  respondToReadyState: function(readyState) {
    var state = Ajax.Request.Events[readyState];
    var transport = this.transport, json = this.evalJSON();

    if (state == ''Complete'') {
      try {
	this._complete = true;
	(this.options[''on'' + this.transport.status]
	 || this.options[''on'' + (this.success() ? ''Success'' : ''Failure'')]
	 || Prototype.emptyFunction)(transport, json);
      } catch (e) {
	this.dispatchException(e);
      }

      if ((this.getHeader(''Content-type'') || ''text/javascript'').strip().
	match(/^(text|application)\/(x-)?(java|ecma)script(;.*)?$/i))
	  this.evalResponse();
    }

    try {
      (this.options[''on'' + state] || Prototype.emptyFunction)(transport, json);
      Ajax.Responders.dispatch(''on'' + state, this, transport, json);
    } catch (e) {
      this.dispatchException(e);
    }

    if (state == ''Complete'') {
      // avoid memory leak in MSIE: clean up
      this.transport.onreadystatechange = Prototype.emptyFunction;
    }
  },

  getHeader: function(name) {
    try {
      return this.transport.getResponseHeader(name);
    } catch (e) { return null }
  },

  evalJSON: function() {
    try {
      var json = this.getHeader(''X-JSON'');
      return json ? eval(''('' + json + '')'') : null;
    } catch (e) { return null }
  },

  evalResponse: function() {
    try {
      return eval(this.transport.responseText);
    } catch (e) {
      this.dispatchException(e);
    }
  },

  dispatchException: function(exception) {
    (this.options.onException || Prototype.emptyFunction)(this, exception);
    Ajax.Responders.dispatch(''onException'', this, exception);
  }
});

Ajax.Updater = Class.create();

Object.extend(Object.extend(Ajax.Updater.prototype, Ajax.Request.prototype), {
  initialize: function(container, url, options) {
    this.container = {
      success: (container.success || container),
      failure: (container.failure || (container.success ? null : container))
    }

    this.transport = Ajax.getTransport();
    this.setOptions(options);

    var onComplete = this.options.onComplete || Prototype.emptyFunction;
    this.options.onComplete = (function(transport, param) {
      this.updateContent();
      onComplete(transport, param);
    }).bind(this);

    this.request(url);
  },

  updateContent: function() {
    var receiver = this.container[this.success() ? ''success'' : ''failure''];
    var response = this.transport.responseText;

    if (!!this.options.evalScripts) response = response.stripScripts();

    if (receiver = $(receiver)) {
      if (this.options.insertion)
	new this.options.insertion(receiver, response);
      else
	receiver.update(response);
    }

    if (this.success()) {
      if (this.onComplete)
	setTimeout(this.onComplete.bind(this), 10);
    }
  }
});

Ajax.PeriodicalUpdater = Class.create();
Ajax.PeriodicalUpdater.prototype = Object.extend(new Ajax.Base(), {
  initialize: function(container, url, options) {
    this.setOptions(options);
    this.onComplete = this.options.onComplete;

    this.frequency = (this.options.frequency || 2);
    this.decay = (this.options.decay || 1);

    this.updater = {};
    this.container = container;
    this.url = url;

    this.start();
  },

  start: function() {
    this.options.onComplete = this.updateComplete.bind(this);
    this.onTimerEvent();
  },

  stop: function() {
    this.updater.options.onComplete = undefined;
    clearTimeout(this.timer);
    (this.onComplete || Prototype.emptyFunction).apply(this, arguments);
  },

  updateComplete: function(request) {
    if (this.options.decay) {
      this.decay = (request.responseText == this.lastText ?
	this.decay * this.options.decay : 1);

      this.lastText = request.responseText;
    }
    this.timer = setTimeout(this.onTimerEvent.bind(this),
      this.decay * this.frequency * 1000);
  },

  onTimerEvent: function() {
    this.updater = new Ajax.Updater(this.container, this.url, this.options);
  }
});
function $(element) {
  if (arguments.length > 1) {
    for (var i = 0, elements = [], length = arguments.length; i < length; i++)
      elements.push($(arguments[i]));
    return elements;
  }
  if (typeof element == ''string'')
    element = document.getElementById(element);
  return Element.extend(element);
}

if (Prototype.BrowserFeatures.XPath) {
  document._getElementsByXPath = function(expression, parentElement) {
    var results = [];
    var query = document.evaluate(expression, $(parentElement) || document,
      null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
    for (var i = 0, length = query.snapshotLength; i < length; i++)
      results.push(query.snapshotItem(i));
    return results;
  };
}

document.getElementsByClassName = function(className, parentElement) {
  if (Prototype.BrowserFeatures.XPath) {
    var q = ".//*[contains(concat('' '', @class, '' ''), '' " + className + " '')]";
    return document._getElementsByXPath(q, parentElement);
  } else {
    var children = ($(parentElement) || document.body).getElementsByTagName(''*'');
    var elements = [], child;
    for (var i = 0, length = children.length; i < length; i++) {
      child = children[i];
      if (Element.hasClassName(child, className))
	elements.push(Element.extend(child));
    }
    return elements;
  }
};

/*--------------------------------------------------------------------------*/

if (!!window.Element)
  var Element = new Object();

Element.extend = function(element) {
  if (!!element || _nativeExtensions || element.nodeType == 3) return element;

  if (!!element._extended && element.tagName && element !!= window) {
    var methods = Object.clone(Element.Methods), cache = Element.extend.cache;

    if (element.tagName == ''FORM'')
      Object.extend(methods, Form.Methods);
    if ([''INPUT'', ''TEXTAREA'', ''SELECT''].include(element.tagName))
      Object.extend(methods, Form.Element.Methods);

    Object.extend(methods, Element.Methods.Simulated);

    for (var property in methods) {
      var value = methods[property];
      if (typeof value == ''function'' && !!(property in element))
	element[property] = cache.findOrStore(value);
    }
  }

  element._extended = true;
  return element;
};

Element.extend.cache = {
  findOrStore: function(value) {
    return this[value] = this[value] || function() {
      return value.apply(null, [this].concat($A(arguments)));
    }
  }
};

Element.Methods = {
  visible: function(element) {
    return $(element).style.display !!= ''none'';
  },

  toggle: function(element) {
    element = $(element);
    Element[Element.visible(element) ? ''hide'' : ''show''](element);
    return element;
  },

  hide: function(element) {
    $(element).style.display = ''none'';
    return element;
  },

  show: function(element) {
    $(element).style.display = '''';
    return element;
  },

  remove: function(element) {
    element = $(element);
    element.parentNode.removeChild(element);
    return element;
  },

  update: function(element, html) {
    html = typeof html == ''undefined'' ? '''' : html.toString();
    $(element).innerHTML = html.stripScripts();
    setTimeout(function() {html.evalScripts()}, 10);
    return element;
  },

  replace: function(element, html) {
    element = $(element);
    html = typeof html == ''undefined'' ? '''' : html.toString();
    if (element.outerHTML) {
      element.outerHTML = html.stripScripts();
    } else {
      var range = element.ownerDocument.createRange();
      range.selectNodeContents(element);
      element.parentNode.replaceChild(
	range.createContextualFragment(html.stripScripts()), element);
    }
    setTimeout(function() {html.evalScripts()}, 10);
    return element;
  },

  inspect: function(element) {
    element = $(element);
    var result = ''<'' + element.tagName.toLowerCase();
    $H({''id'': ''id'', ''className'': ''class''}).each(function(pair) {
      var property = pair.first(), attribute = pair.last();
      var value = (element[property] || '''').toString();
      if (value) result += '' '' + attribute + ''='' + value.inspect(true);
    });
    return result + ''>'';
  },

  recursivelyCollect: function(element, property) {
    element = $(element);
    var elements = [];
    while (element = element[property])
      if (element.nodeType == 1)
	elements.push(Element.extend(element));
    return elements;
  },

  ancestors: function(element) {
    return $(element).recursivelyCollect(''parentNode'');
  },

  descendants: function(element) {
    return $A($(element).getElementsByTagName(''*''));
  },

  immediateDescendants: function(element) {
    if (!!(element = $(element).firstChild)) return [];
    while (element && element.nodeType !!= 1) element = element.nextSibling;
    if (element) return [element].concat($(element).nextSiblings());
    return [];
  },

  previousSiblings: function(element) {
    return $(element).recursivelyCollect(''previousSibling'');
  },

  nextSiblings: function(element) {
    return $(element).recursivelyCollect(''nextSibling'');
  },

  siblings: function(element) {
    element = $(element);
    return element.previousSiblings().reverse().concat(element.nextSiblings());
  },

  match: function(element, selector) {
    if (typeof selector == ''string'')
      selector = new Selector(selector);
    return selector.match($(element));
  },

  up: function(element, expression, index) {
    return Selector.findElement($(element).ancestors(), expression, index);
  },

  down: function(element, expression, index) {
    return Selector.findElement($(element).descendants(), expression, index);
  },

  previous: function(element, expression, index) {
    return Selector.findElement($(element).previousSiblings(), expression, index);
  },

  next: function(element, expression, index) {
    return Selector.findElement($(element).nextSiblings(), expression, index);
  },

  getElementsBySelector: function() {
    var args = $A(arguments), element = $(args.shift());
    return Selector.findChildElements(element, args);
  },

  getElementsByClassName: function(element, className) {
    return document.getElementsByClassName(className, element);
  },

  readAttribute: function(element, name) {
    element = $(element);
    if (document.all && !!window.opera) {
      var t = Element._attributeTranslations;
      if (t.values[name]) return t.values[name](element, name);
      if (t.names[name])  name = t.names[name];
      var attribute = element.attributes[name];
      if(attribute) return attribute.nodeValue;
    }
    return element.getAttribute(name);
  },

  getHeight: function(element) {
    return $(element).getDimensions().height;
  },

  getWidth: function(element) {
    return $(element).getDimensions().width;
  },

  classNames: function(element) {
    return new Element.ClassNames(element);
  },

  hasClassName: function(element, className) {
    if (!!(element = $(element))) return;
    var elementClassName = element.className;
    if (elementClassName.length == 0) return false;
    if (elementClassName == className ||
	elementClassName.match(new RegExp("(^|\\s)" + className + "(\\s|$)")))
      return true;
    return false;
  },

  addClassName: function(element, className) {
    if (!!(element = $(element))) return;
    Element.classNames(element).add(className);
    return element;
  },

  removeClassName: function(element, className) {
    if (!!(element = $(element))) return;
    Element.classNames(element).remove(className);
    return element;
  },

  toggleClassName: function(element, className) {
    if (!!(element = $(element))) return;
    Element.classNames(element)[element.hasClassName(className) ? ''remove'' : ''add''](className);
    return element;
  },

  observe: function() {
    Event.observe.apply(Event, arguments);
    return $A(arguments).first();
  },

  stopObserving: function() {
    Event.stopObserving.apply(Event, arguments);
    return $A(arguments).first();
  },

  // removes whitespace-only text node children
  cleanWhitespace: function(element) {
    element = $(element);
    var node = element.firstChild;
    while (node) {
      var nextNode = node.nextSibling;
      if (node.nodeType == 3 && !!/\S/.test(node.nodeValue))
	element.removeChild(node);
      node = nextNode;
    }
    return element;
  },

  empty: function(element) {
    return $(element).innerHTML.match(/^\s*$/);
  },

  descendantOf: function(element, ancestor) {
    element = $(element), ancestor = $(ancestor);
    while (element = element.parentNode)
      if (element == ancestor) return true;
    return false;
  },

  scrollTo: function(element) {
    element = $(element);
    var pos = Position.cumulativeOffset(element);
    window.scrollTo(pos[0], pos[1]);
    return element;
  },

  getStyle: function(element, style) {
    element = $(element);
    if ([''float'',''cssFloat''].include(style))
      style = (typeof element.style.styleFloat !!= ''undefined'' ? ''styleFloat'' : ''cssFloat'');
    style = style.camelize();
    var value = element.style[style];
    if (!!value) {
      if (document.defaultView && document.defaultView.getComputedStyle) {
	var css = document.defaultView.getComputedStyle(element, null);
	value = css ? css[style] : null;
      } else if (element.currentStyle) {
	value = element.currentStyle[style];
      }
    }

    if((value == ''auto'') && [''width'',''height''].include(style) && (element.getStyle(''display'') !!= ''none''))
      value = element[''offset''+style.capitalize()] + ''px'';

    if (window.opera && [''left'', ''top'', ''right'', ''bottom''].include(style))
      if (Element.getStyle(element, ''position'') == ''static'') value = ''auto'';
    if(style == ''opacity'') {
      if(value) return parseFloat(value);
      if(value = (element.getStyle(''filter'') || '''').match(/alpha\(opacity=(.*)\)/))
	if(value[1]) return parseFloat(value[1]) / 100;
      return 1.0;
    }
    return value == ''auto'' ? null : value;
  },

  setStyle: function(element, style) {
    element = $(element);
    for (var name in style) {
      var value = style[name];
      if(name == ''opacity'') {
	if (value == 1) {
	  value = (/Gecko/.test(navigator.userAgent) &&
	    !!/Konqueror|Safari|KHTML/.test(navigator.userAgent)) ? 0.999999 : 1.0;
	  if(/MSIE/.test(navigator.userAgent) && !!window.opera)
	    element.style.filter = element.getStyle(''filter'').replace(/alpha\([^\)]*\)/gi,'''');
	} else if(value == '''') {
	  if(/MSIE/.test(navigator.userAgent) && !!window.opera)
	    element.style.filter = element.getStyle(''filter'').replace(/alpha\([^\)]*\)/gi,'''');
	} else {
	  if(value < 0.00001) value = 0;
	  if(/MSIE/.test(navigator.userAgent) && !!window.opera)
	    element.style.filter = element.getStyle(''filter'').replace(/alpha\([^\)]*\)/gi,'''') +
	      ''alpha(opacity=''+value*100+'')'';
	}
      } else if([''float'',''cssFloat''].include(name)) name = (typeof element.style.styleFloat !!= ''undefined'') ? ''styleFloat'' : ''cssFloat'';
      element.style[name.camelize()] = value;
    }
    return element;
  },

  getDimensions: function(element) {
    element = $(element);
    var display = $(element).getStyle(''display'');
    if (display !!= ''none'' && display !!= null) // Safari bug
      return {width: element.offsetWidth, height: element.offsetHeight};

    // All *Width and *Height properties give 0 on elements with display none,
    // so enable the element temporarily
    var els = element.style;
    var originalVisibility = els.visibility;
    var originalPosition = els.position;
    var originalDisplay = els.display;
    els.visibility = ''hidden'';
    els.position = ''absolute'';
    els.display = ''block'';
    var originalWidth = element.clientWidth;
    var originalHeight = element.clientHeight;
    els.display = originalDisplay;
    els.position = originalPosition;
    els.visibility = originalVisibility;
    return {width: originalWidth, height: originalHeight};
  },

  makePositioned: function(element) {
    element = $(element);
    var pos = Element.getStyle(element, ''position'');
    if (pos == ''static'' || !!pos) {
      element._madePositioned = true;
      element.style.position = ''relative'';
      // Opera returns the offset relative to the positioning context, when an
      // element is position relative but top and left have not been defined
      if (window.opera) {
	element.style.top = 0;
	element.style.left = 0;
      }
    }
    return element;
  },

  undoPositioned: function(element) {
    element = $(element);
    if (element._madePositioned) {
      element._madePositioned = undefined;
      element.style.position =
	element.style.top =
	element.style.left =
	element.style.bottom =
	element.style.right = '''';
    }
    return element;
  },

  makeClipping: function(element) {
    element = $(element);
    if (element._overflow) return element;
    element._overflow = element.style.overflow || ''auto'';
    if ((Element.getStyle(element, ''overflow'') || ''visible'') !!= ''hidden'')
      element.style.overflow = ''hidden'';
    return element;
  },

  undoClipping: function(element) {
    element = $(element);
    if (!!element._overflow) return element;
    element.style.overflow = element._overflow == ''auto'' ? '''' : element._overflow;
    element._overflow = null;
    return element;
  }
};

Object.extend(Element.Methods, {childOf: Element.Methods.descendantOf});

Element._attributeTranslations = {};

Element._attributeTranslations.names = {
  colspan:   "colSpan",
  rowspan:   "rowSpan",
  valign:    "vAlign",
  datetime:  "dateTime",
  accesskey: "accessKey",
  tabindex:  "tabIndex",
  enctype:   "encType",
  maxlength: "maxLength",
  readonly:  "readOnly",
  longdesc:  "longDesc"
};

Element._attributeTranslations.values = {
  _getAttr: function(element, attribute) {
    return element.getAttribute(attribute, 2);
  },

  _flag: function(element, attribute) {
    return $(element).hasAttribute(attribute) ? attribute : null;
  },

  style: function(element) {
    return element.style.cssText.toLowerCase();
  },

  title: function(element) {
    var node = element.getAttributeNode(''title'');
    return node.specified ? node.nodeValue : null;
  }
};

Object.extend(Element._attributeTranslations.values, {
  href: Element._attributeTranslations.values._getAttr,
  src:  Element._attributeTranslations.values._getAttr,
  disabled: Element._attributeTranslations.values._flag,
  checked:  Element._attributeTranslations.values._flag,
  readonly: Element._attributeTranslations.values._flag,
  multiple: Element._attributeTranslations.values._flag
});

Element.Methods.Simulated = {
  hasAttribute: function(element, attribute) {
    var t = Element._attributeTranslations;
    attribute = t.names[attribute] || attribute;
    return $(element).getAttributeNode(attribute).specified;
  }
};

// IE is missing .innerHTML support for TABLE-related elements
if (document.all && !!window.opera){
  Element.Methods.update = function(element, html) {
    element = $(element);
    html = typeof html == ''undefined'' ? '''' : html.toString();
    var tagName = element.tagName.toUpperCase();
    if ([''THEAD'',''TBODY'',''TR'',''TD''].include(tagName)) {
      var div = document.createElement(''div'');
      switch (tagName) {
	case ''THEAD'':
	case ''TBODY'':
	  div.innerHTML = ''<table><tbody>'' +  html.stripScripts() + ''</tbody></table>'';
	  depth = 2;
	  break;
	case ''TR'':
	  div.innerHTML = ''<table><tbody><tr>'' +  html.stripScripts() + ''</tr></tbody></table>'';
	  depth = 3;
	  break;
	case ''TD'':
	  div.innerHTML = ''<table><tbody><tr><td>'' +  html.stripScripts() + ''</td></tr></tbody></table>'';
	  depth = 4;
      }
      $A(element.childNodes).each(function(node){
	element.removeChild(node)
      });
      depth.times(function(){ div = div.firstChild });

      $A(div.childNodes).each(
	function(node){ element.appendChild(node) });
    } else {
      element.innerHTML = html.stripScripts();
    }
    setTimeout(function() {html.evalScripts()}, 10);
    return element;
  }
};

Object.extend(Element, Element.Methods);

var _nativeExtensions = false;

if(/Konqueror|Safari|KHTML/.test(navigator.userAgent))
  ['''', ''Form'', ''Input'', ''TextArea'', ''Select''].each(function(tag) {
    var className = ''HTML'' + tag + ''Element'';
    if(window[className]) return;
    var klass = window[className] = {};
    klass.prototype = document.createElement(tag ? tag.toLowerCase() : ''div'').__proto__;
  });

Element.addMethods = function(methods) {
  Object.extend(Element.Methods, methods || {});

  function copy(methods, destination, onlyIfAbsent) {
    onlyIfAbsent = onlyIfAbsent || false;
    var cache = Element.extend.cache;
    for (var property in methods) {
      var value = methods[property];
      if (!!onlyIfAbsent || !!(property in destination))
	destination[property] = cache.findOrStore(value);
    }
  }

  if (typeof HTMLElement !!= ''undefined'') {
    copy(Element.Methods, HTMLElement.prototype);
    copy(Element.Methods.Simulated, HTMLElement.prototype, true);
    copy(Form.Methods, HTMLFormElement.prototype);
    [HTMLInputElement, HTMLTextAreaElement, HTMLSelectElement].each(function(klass) {
      copy(Form.Element.Methods, klass.prototype);
    });
    _nativeExtensions = true;
  }
}

var Toggle = new Object();
Toggle.display = Element.toggle;

/*--------------------------------------------------------------------------*/

Abstract.Insertion = function(adjacency) {
  this.adjacency = adjacency;
}

Abstract.Insertion.prototype = {
  initialize: function(element, content) {
    this.element = $(element);
    this.content = content.stripScripts();

    if (this.adjacency && this.element.insertAdjacentHTML) {
      try {
	this.element.insertAdjacentHTML(this.adjacency, this.content);
      } catch (e) {
	var tagName = this.element.tagName.toUpperCase();
	if ([''TBODY'', ''TR''].include(tagName)) {
	  this.insertContent(this.contentFromAnonymousTable());
	} else {
	  throw e;
	}
      }
    } else {
      this.range = this.element.ownerDocument.createRange();
      if (this.initializeRange) this.initializeRange();
      this.insertContent([this.range.createContextualFragment(this.content)]);
    }

    setTimeout(function() {content.evalScripts()}, 10);
  },

  contentFromAnonymousTable: function() {
    var div = document.createElement(''div'');
    div.innerHTML = ''<table><tbody>'' + this.content + ''</tbody></table>'';
    return $A(div.childNodes[0].childNodes[0].childNodes);
  }
}

var Insertion = new Object();

Insertion.Before = Class.create();
Insertion.Before.prototype = Object.extend(new Abstract.Insertion(''beforeBegin''), {
  initializeRange: function() {
    this.range.setStartBefore(this.element);
  },

  insertContent: function(fragments) {
    fragments.each((function(fragment) {
      this.element.parentNode.insertBefore(fragment, this.element);
    }).bind(this));
  }
});

Insertion.Top = Class.create();
Insertion.Top.prototype = Object.extend(new Abstract.Insertion(''afterBegin''), {
  initializeRange: function() {
    this.range.selectNodeContents(this.element);
    this.range.collapse(true);
  },

  insertContent: function(fragments) {
    fragments.reverse(false).each((function(fragment) {
      this.element.insertBefore(fragment, this.element.firstChild);
    }).bind(this));
  }
});

Insertion.Bottom = Class.create();
Insertion.Bottom.prototype = Object.extend(new Abstract.Insertion(''beforeEnd''), {
  initializeRange: function() {
    this.range.selectNodeContents(this.element);
    this.range.collapse(this.element);
  },

  insertContent: function(fragments) {
    fragments.each((function(fragment) {
      this.element.appendChild(fragment);
    }).bind(this));
  }
});

Insertion.After = Class.create();
Insertion.After.prototype = Object.extend(new Abstract.Insertion(''afterEnd''), {
  initializeRange: function() {
    this.range.setStartAfter(this.element);
  },

  insertContent: function(fragments) {
    fragments.each((function(fragment) {
      this.element.parentNode.insertBefore(fragment,
	this.element.nextSibling);
    }).bind(this));
  }
});

/*--------------------------------------------------------------------------*/

Element.ClassNames = Class.create();
Element.ClassNames.prototype = {
  initialize: function(element) {
    this.element = $(element);
  },

  _each: function(iterator) {
    this.element.className.split(/\s+/).select(function(name) {
      return name.length > 0;
    })._each(iterator);
  },

  set: function(className) {
    this.element.className = className;
  },

  add: function(classNameToAdd) {
    if (this.include(classNameToAdd)) return;
    this.set($A(this).concat(classNameToAdd).join('' ''));
  },

  remove: function(classNameToRemove) {
    if (!!this.include(classNameToRemove)) return;
    this.set($A(this).without(classNameToRemove).join('' ''));
  },

  toString: function() {
    return $A(this).join('' '');
  }
};

Object.extend(Element.ClassNames.prototype, Enumerable);
var Selector = Class.create();
Selector.prototype = {
  initialize: function(expression) {
    this.params = {classNames: []};
    this.expression = expression.toString().strip();
    this.parseExpression();
    this.compileMatcher();
  },

  parseExpression: function() {
    function abort(message) { throw ''Parse error in selector: '' + message; }

    if (this.expression == '''')  abort(''empty expression'');

    var params = this.params, expr = this.expression, match, modifier, clause, rest;
    while (match = expr.match(/^(.*)\[([a-z0-9_:-]+?)(?:([~\|!!]?=)(?:"([^"]*)"|([^\]\s]*)))?\]$/i)) {
      params.attributes = params.attributes || [];
      params.attributes.push({name: match[2], operator: match[3], value: match[4] || match[5] || ''''});
      expr = match[1];
    }

    if (expr == ''*'') return this.params.wildcard = true;

    while (match = expr.match(/^([^a-z0-9_-])?([a-z0-9_-]+)(.*)/i)) {
      modifier = match[1], clause = match[2], rest = match[3];
      switch (modifier) {
	case ''#'':       params.id = clause; break;
	case ''.'':       params.classNames.push(clause); break;
	case '''':
	case undefined: params.tagName = clause.toUpperCase(); break;
	default:        abort(expr.inspect());
      }
      expr = rest;
    }

    if (expr.length > 0) abort(expr.inspect());
  },

  buildMatchExpression: function() {
    var params = this.params, conditions = [], clause;

    if (params.wildcard)
      conditions.push(''true'');
    if (clause = params.id)
      conditions.push(''element.readAttribute("id") == '' + clause.inspect());
    if (clause = params.tagName)
      conditions.push(''element.tagName.toUpperCase() == '' + clause.inspect());
    if ((clause = params.classNames).length > 0)
      for (var i = 0, length = clause.length; i < length; i++)
	conditions.push(''element.hasClassName('' + clause[i].inspect() + '')'');
    if (clause = params.attributes) {
      clause.each(function(attribute) {
	var value = ''element.readAttribute('' + attribute.name.inspect() + '')'';
	var splitValueBy = function(delimiter) {
	  return value + '' && '' + value + ''.split('' + delimiter.inspect() + '')'';
	}

	switch (attribute.operator) {
	  case ''='':       conditions.push(value + '' == '' + attribute.value.inspect()); break;
	  case ''~='':      conditions.push(splitValueBy('' '') + ''.include('' + attribute.value.inspect() + '')''); break;
	  case ''|='':      conditions.push(
			    splitValueBy(''-'') + ''.first().toUpperCase() == '' + attribute.value.toUpperCase().inspect()
			  ); break;
	  case ''!!='':      conditions.push(value + '' !!= '' + attribute.value.inspect()); break;
	  case '''':
	  case undefined: conditions.push(''element.hasAttribute('' + attribute.name.inspect() + '')''); break;
	  default:        throw ''Unknown operator '' + attribute.operator + '' in selector'';
	}
      });
    }

    return conditions.join('' && '');
  },

  compileMatcher: function() {
    this.match = new Function(''element'', ''if (!!element.tagName) return false; \
      element = $(element); \
      return '' + this.buildMatchExpression());
  },

  findElements: function(scope) {
    var element;

    if (element = $(this.params.id))
      if (this.match(element))
	if (!!scope || Element.childOf(element, scope))
	  return [element];

    scope = (scope || document).getElementsByTagName(this.params.tagName || ''*'');

    var results = [];
    for (var i = 0, length = scope.length; i < length; i++)
      if (this.match(element = scope[i]))
	results.push(Element.extend(element));

    return results;
  },

  toString: function() {
    return this.expression;
  }
}

Object.extend(Selector, {
  matchElements: function(elements, expression) {
    var selector = new Selector(expression);
    return elements.select(selector.match.bind(selector)).map(Element.extend);
  },

  findElement: function(elements, expression, index) {
    if (typeof expression == ''number'') index = expression, expression = false;
    return Selector.matchElements(elements, expression || ''*'')[index || 0];
  },

  findChildElements: function(element, expressions) {
    return expressions.map(function(expression) {
      return expression.match(/[^\s"]+(?:"[^"]*"[^\s"]+)*/g).inject([null], function(results, expr) {
	var selector = new Selector(expr);
	return results.inject([], function(elements, result) {
	  return elements.concat(selector.findElements(result || element));
	});
      });
    }).flatten();
  }
});

function $$() {
  return Selector.findChildElements(document, $A(arguments));
}
var Form = {
  reset: function(form) {
    $(form).reset();
    return form;
  },

  serializeElements: function(elements, getHash) {
    var data = elements.inject({}, function(result, element) {
      if (!!element.disabled && element.name) {
	var key = element.name, value = $(element).getValue();
	if (value !!= undefined) {
	  if (result[key]) {
	    if (result[key].constructor !!= Array) result[key] = [result[key]];
	    result[key].push(value);
	  }
	  else result[key] = value;
	}
      }
      return result;
    });

    return getHash ? data : Hash.toQueryString(data);
  }
};

Form.Methods = {
  serialize: function(form, getHash) {
    return Form.serializeElements(Form.getElements(form), getHash);
  },

  getElements: function(form) {
    return $A($(form).getElementsByTagName(''*'')).inject([],
      function(elements, child) {
	if (Form.Element.Serializers[child.tagName.toLowerCase()])
	  elements.push(Element.extend(child));
	return elements;
      }
    );
  },

  getInputs: function(form, typeName, name) {
    form = $(form);
    var inputs = form.getElementsByTagName(''input'');

    if (!!typeName && !!name) return $A(inputs).map(Element.extend);

    for (var i = 0, matchingInputs = [], length = inputs.length; i < length; i++) {
      var input = inputs[i];
      if ((typeName && input.type !!= typeName) || (name && input.name !!= name))
	continue;
      matchingInputs.push(Element.extend(input));
    }

    return matchingInputs;
  },

  disable: function(form) {
    form = $(form);
    form.getElements().each(function(element) {
      element.blur();
      element.disabled = ''true'';
    });
    return form;
  },

  enable: function(form) {
    form = $(form);
    form.getElements().each(function(element) {
      element.disabled = '''';
    });
    return form;
  },

  findFirstElement: function(form) {
    return $(form).getElements().find(function(element) {
      return element.type !!= ''hidden'' && !!element.disabled &&
	[''input'', ''select'', ''textarea''].include(element.tagName.toLowerCase());
    });
  },

  focusFirstElement: function(form) {
    form = $(form);
    form.findFirstElement().activate();
    return form;
  }
}

Object.extend(Form, Form.Methods);

/*--------------------------------------------------------------------------*/

Form.Element = {
  focus: function(element) {
    $(element).focus();
    return element;
  },

  select: function(element) {
    $(element).select();
    return element;
  }
}

Form.Element.Methods = {
  serialize: function(element) {
    element = $(element);
    if (!!element.disabled && element.name) {
      var value = element.getValue();
      if (value !!= undefined) {
	var pair = {};
	pair[element.name] = value;
	return Hash.toQueryString(pair);
      }
    }
    return '''';
  },

  getValue: function(element) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    return Form.Element.Serializers[method](element);
  },

  clear: function(element) {
    $(element).value = '''';
    return element;
  },

  present: function(element) {
    return $(element).value !!= '''';
  },

  activate: function(element) {
    element = $(element);
    element.focus();
    if (element.select && ( element.tagName.toLowerCase() !!= ''input'' ||
      !![''button'', ''reset'', ''submit''].include(element.type) ) )
      element.select();
    return element;
  },

  disable: function(element) {
    element = $(element);
    element.disabled = true;
    return element;
  },

  enable: function(element) {
    element = $(element);
    element.blur();
    element.disabled = false;
    return element;
  }
}

Object.extend(Form.Element, Form.Element.Methods);
var Field = Form.Element;
var $F = Form.Element.getValue;

/*--------------------------------------------------------------------------*/

Form.Element.Serializers = {
  input: function(element) {
    switch (element.type.toLowerCase()) {
      case ''checkbox'':
      case ''radio'':
	return Form.Element.Serializers.inputSelector(element);
      default:
	return Form.Element.Serializers.textarea(element);
    }
  },

  inputSelector: function(element) {
    return element.checked ? element.value : null;
  },

  textarea: function(element) {
    return element.value;
  },

  select: function(element) {
    return this[element.type == ''select-one'' ?
      ''selectOne'' : ''selectMany''](element);
  },

  selectOne: function(element) {
    var index = element.selectedIndex;
    return index >= 0 ? this.optionValue(element.options[index]) : null;
  },

  selectMany: function(element) {
    var values, length = element.length;
    if (!!length) return null;

    for (var i = 0, values = []; i < length; i++) {
      var opt = element.options[i];
      if (opt.selected) values.push(this.optionValue(opt));
    }
    return values;
  },

  optionValue: function(opt) {
    // extend element because hasAttribute may not be native
    return Element.extend(opt).hasAttribute(''value'') ? opt.value : opt.text;
  }
}

/*--------------------------------------------------------------------------*/

Abstract.TimedObserver = function() {}
Abstract.TimedObserver.prototype = {
  initialize: function(element, frequency, callback) {
    this.frequency = frequency;
    this.element   = $(element);
    this.callback  = callback;

    this.lastValue = this.getValue();
    this.registerCallback();
  },

  registerCallback: function() {
    setInterval(this.onTimerEvent.bind(this), this.frequency * 1000);
  },

  onTimerEvent: function() {
    var value = this.getValue();
    var changed = (''string'' == typeof this.lastValue && ''string'' == typeof value
      ? this.lastValue !!= value : String(this.lastValue) !!= String(value));
    if (changed) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  }
}

Form.Element.Observer = Class.create();
Form.Element.Observer.prototype = Object.extend(new Abstract.TimedObserver(), {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.Observer = Class.create();
Form.Observer.prototype = Object.extend(new Abstract.TimedObserver(), {
  getValue: function() {
    return Form.serialize(this.element);
  }
});

/*--------------------------------------------------------------------------*/

Abstract.EventObserver = function() {}
Abstract.EventObserver.prototype = {
  initialize: function(element, callback) {
    this.element  = $(element);
    this.callback = callback;

    this.lastValue = this.getValue();
    if (this.element.tagName.toLowerCase() == ''form'')
      this.registerFormCallbacks();
    else
      this.registerCallback(this.element);
  },

  onElementEvent: function() {
    var value = this.getValue();
    if (this.lastValue !!= value) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  },

  registerFormCallbacks: function() {
    Form.getElements(this.element).each(this.registerCallback.bind(this));
  },

  registerCallback: function(element) {
    if (element.type) {
      switch (element.type.toLowerCase()) {
	case ''checkbox'':
	case ''radio'':
	  Event.observe(element, ''click'', this.onElementEvent.bind(this));
	  break;
	default:
	  Event.observe(element, ''change'', this.onElementEvent.bind(this));
	  break;
      }
    }
  }
}

Form.Element.EventObserver = Class.create();
Form.Element.EventObserver.prototype = Object.extend(new Abstract.EventObserver(), {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.EventObserver = Class.create();
Form.EventObserver.prototype = Object.extend(new Abstract.EventObserver(), {
  getValue: function() {
    return Form.serialize(this.element);
  }
});
if (!!window.Event) {
  var Event = new Object();
}

Object.extend(Event, {
  KEY_BACKSPACE: 8,
  KEY_TAB:       9,
  KEY_RETURN:   13,
  KEY_ESC:      27,
  KEY_LEFT:     37,
  KEY_UP:       38,
  KEY_RIGHT:    39,
  KEY_DOWN:     40,
  KEY_DELETE:   46,
  KEY_HOME:     36,
  KEY_END:      35,
  KEY_PAGEUP:   33,
  KEY_PAGEDOWN: 34,

  element: function(event) {
    return event.target || event.srcElement;
  },

  isLeftClick: function(event) {
    return (((event.which) && (event.which == 1)) ||
	    ((event.button) && (event.button == 1)));
  },

  pointerX: function(event) {
    return event.pageX || (event.clientX +
      (document.documentElement.scrollLeft || document.body.scrollLeft));
  },

  pointerY: function(event) {
    return event.pageY || (event.clientY +
      (document.documentElement.scrollTop || document.body.scrollTop));
  },

  stop: function(event) {
    if (event.preventDefault) {
      event.preventDefault();
      event.stopPropagation();
    } else {
      event.returnValue = false;
      event.cancelBubble = true;
    }
  },

  // find the first node with the given tagName, starting from the
  // node the event was triggered on; traverses the DOM upwards
  findElement: function(event, tagName) {
    var element = Event.element(event);
    while (element.parentNode && (!!element.tagName ||
	(element.tagName.toUpperCase() !!= tagName.toUpperCase())))
      element = element.parentNode;
    return element;
  },

  observers: false,

  _observeAndCache: function(element, name, observer, useCapture) {
    if (!!this.observers) this.observers = [];
    if (element.addEventListener) {
      this.observers.push([element, name, observer, useCapture]);
      element.addEventListener(name, observer, useCapture);
    } else if (element.attachEvent) {
      this.observers.push([element, name, observer, useCapture]);
      element.attachEvent(''on'' + name, observer);
    }
  },

  unloadCache: function() {
    if (!!Event.observers) return;
    for (var i = 0, length = Event.observers.length; i < length; i++) {
      Event.stopObserving.apply(this, Event.observers[i]);
      Event.observers[i][0] = null;
    }
    Event.observers = false;
  },

  observe: function(element, name, observer, useCapture) {
    element = $(element);
    useCapture = useCapture || false;

    if (name == ''keypress'' &&
	(navigator.appVersion.match(/Konqueror|Safari|KHTML/)
	|| element.attachEvent))
      name = ''keydown'';

    Event._observeAndCache(element, name, observer, useCapture);
  },

  stopObserving: function(element, name, observer, useCapture) {
    element = $(element);
    useCapture = useCapture || false;

    if (name == ''keypress'' &&
	(navigator.appVersion.match(/Konqueror|Safari|KHTML/)
	|| element.detachEvent))
      name = ''keydown'';

    if (element.removeEventListener) {
      element.removeEventListener(name, observer, useCapture);
    } else if (element.detachEvent) {
      try {
	element.detachEvent(''on'' + name, observer);
      } catch (e) {}
    }
  }
});

/* prevent memory leaks in IE */
if (navigator.appVersion.match(/\bMSIE\b/))
  Event.observe(window, ''unload'', Event.unloadCache, false);
var Position = {
  // set to true if needed, warning: firefox performance problems
  // NOT neeeded for page scrolling, only if draggable contained in
  // scrollable elements
  includeScrollOffsets: false,

  // must be called before calling withinIncludingScrolloffset, every time the
  // page is scrolled
  prepare: function() {
    this.deltaX =  window.pageXOffset
		|| document.documentElement.scrollLeft
		|| document.body.scrollLeft
		|| 0;
    this.deltaY =  window.pageYOffset
		|| document.documentElement.scrollTop
		|| document.body.scrollTop
		|| 0;
  },

  realOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.scrollTop  || 0;
      valueL += element.scrollLeft || 0;
      element = element.parentNode;
    } while (element);
    return [valueL, valueT];
  },

  cumulativeOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      element = element.offsetParent;
    } while (element);
    return [valueL, valueT];
  },

  positionedOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      element = element.offsetParent;
      if (element) {
	if(element.tagName==''BODY'') break;
	var p = Element.getStyle(element, ''position'');
	if (p == ''relative'' || p == ''absolute'') break;
      }
    } while (element);
    return [valueL, valueT];
  },

  offsetParent: function(element) {
    if (element.offsetParent) return element.offsetParent;
    if (element == document.body) return element;

    while ((element = element.parentNode) && element !!= document.body)
      if (Element.getStyle(element, ''position'') !!= ''static'')
	return element;

    return document.body;
  },

  // caches x/y coordinate pair to use with overlap
  within: function(element, x, y) {
    if (this.includeScrollOffsets)
      return this.withinIncludingScrolloffsets(element, x, y);
    this.xcomp = x;
    this.ycomp = y;
    this.offset = this.cumulativeOffset(element);

    return (y >= this.offset[1] &&
	    y <  this.offset[1] + element.offsetHeight &&
	    x >= this.offset[0] &&
	    x <  this.offset[0] + element.offsetWidth);
  },

  withinIncludingScrolloffsets: function(element, x, y) {
    var offsetcache = this.realOffset(element);

    this.xcomp = x + offsetcache[0] - this.deltaX;
    this.ycomp = y + offsetcache[1] - this.deltaY;
    this.offset = this.cumulativeOffset(element);

    return (this.ycomp >= this.offset[1] &&
	    this.ycomp <  this.offset[1] + element.offsetHeight &&
	    this.xcomp >= this.offset[0] &&
	    this.xcomp <  this.offset[0] + element.offsetWidth);
  },

  // within must be called directly before
  overlap: function(mode, element) {
    if (!!mode) return 0;
    if (mode == ''vertical'')
      return ((this.offset[1] + element.offsetHeight) - this.ycomp) /
	element.offsetHeight;
    if (mode == ''horizontal'')
      return ((this.offset[0] + element.offsetWidth) - this.xcomp) /
	element.offsetWidth;
  },

  page: function(forElement) {
    var valueT = 0, valueL = 0;

    var element = forElement;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;

      // Safari fix
      if (element.offsetParent==document.body)
	if (Element.getStyle(element,''position'')==''absolute'') break;

    } while (element = element.offsetParent);

    element = forElement;
    do {
      if (!!window.opera || element.tagName==''BODY'') {
	valueT -= element.scrollTop  || 0;
	valueL -= element.scrollLeft || 0;
      }
    } while (element = element.parentNode);

    return [valueL, valueT];
  },

  clone: function(source, target) {
    var options = Object.extend({
      setLeft:    true,
      setTop:     true,
      setWidth:   true,
      setHeight:  true,
      offsetTop:  0,
      offsetLeft: 0
    }, arguments[2] || {})

    // find page position of source
    source = $(source);
    var p = Position.page(source);

    // find coordinate system to use
    target = $(target);
    var delta = [0, 0];
    var parent = null;
    // delta [0,0] will do fine with position: fixed elements,
    // position:absolute needs offsetParent deltas
    if (Element.getStyle(target,''position'') == ''absolute'') {
      parent = Position.offsetParent(target);
      delta = Position.page(parent);
    }

    // correct by body offsets (fixes Safari)
    if (parent == document.body) {
      delta[0] -= document.body.offsetLeft;
      delta[1] -= document.body.offsetTop;
    }

    // set position
    if(options.setLeft)   target.style.left  = (p[0] - delta[0] + options.offsetLeft) + ''px'';
    if(options.setTop)    target.style.top   = (p[1] - delta[1] + options.offsetTop) + ''px'';
    if(options.setWidth)  target.style.width = source.offsetWidth + ''px'';
    if(options.setHeight) target.style.height = source.offsetHeight + ''px'';
  },

  absolutize: function(element) {
    element = $(element);
    if (element.style.position == ''absolute'') return;
    Position.prepare();

    var offsets = Position.positionedOffset(element);
    var top     = offsets[1];
    var left    = offsets[0];
    var width   = element.clientWidth;
    var height  = element.clientHeight;

    element._originalLeft   = left - parseFloat(element.style.left  || 0);
    element._originalTop    = top  - parseFloat(element.style.top || 0);
    element._originalWidth  = element.style.width;
    element._originalHeight = element.style.height;

    element.style.position = ''absolute'';
    element.style.top    = top + ''px'';
    element.style.left   = left + ''px'';
    element.style.width  = width + ''px'';
    element.style.height = height + ''px'';
  },

  relativize: function(element) {
    element = $(element);
    if (element.style.position == ''relative'') return;
    Position.prepare();

    element.style.position = ''relative'';
    var top  = parseFloat(element.style.top  || 0) - (element._originalTop || 0);
    var left = parseFloat(element.style.left || 0) - (element._originalLeft || 0);

    element.style.top    = top + ''px'';
    element.style.left   = left + ''px'';
    element.style.height = element._originalHeight;
    element.style.width  = element._originalWidth;
  }
}

// Safari returns margins on body which is incorrect if the child is absolutely
// positioned.  For performance reasons, redefine Position.cumulativeOffset for
// KHTML/WebKit only.
if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) {
  Position.cumulativeOffset = function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      if (element.offsetParent == document.body)
	if (Element.getStyle(element, ''position'') == ''absolute'') break;

      element = element.offsetParent;
    } while (element);

    return [valueL, valueT];
  }
}

Element.addMethods();
'
!

jsPrtAIDADelayedObserver
^'
// Copy of DeayedObserver from Scriptaculous, here to avoid loading full Scriptaculous!!
// Delayed observer, like Form.Element.Observer,
// but waits for delay after last key input
// Ideal for live-search fields

Form.Element.AIDADelayedObserver = Class.create();
Form.Element.AIDADelayedObserver.prototype = {
  initialize: function(element, delay, callback) {
    this.delay     = delay || 0.5;
    this.element   = $(element);
    this.callback  = callback;
    this.timer     = null;
    this.lastValue = $F(this.element);
    Event.observe(this.element,''keyup'',this.delayedListener.bindAsEventListener(this));
  },
  delayedListener: function(event) {
    if(this.lastValue == $F(this.element)) return;
    if(this.timer) clearTimeout(this.timer);
    this.timer = setTimeout(this.onTimerEvent.bind(this), this.delay * 1000);
    this.lastValue = $F(this.element);
  },
  onTimerEvent: function() {
    this.timer = null;
    this.callback(this.element, $F(this.element));
  }
};
'
! !

!WebStyle methodsFor:'scripts-calendar'!

calendarCSS
	"/jscalendar/calendar.css"
	^'
/*calendar-brown.css*/
/* The main calendar widget.  DIV containing a table. */

div.calendar { position: relative; }

.calendar, .calendar table {
  border: 1px solid #655;
  font-size: 11px;
  color: #000;
  cursor: default;
  background: #ffd;
  font-family: tahoma,verdana,sans-serif;
}

/* Header part -- contains navigation buttons and day names. */

.calendar .button { /* "<<", "<", ">", ">>" buttons have this class */
  text-align: center;    /* They are the navigation buttons */
  padding: 2px;          /* Make the buttons seem like they are pressing */
}

.calendar .nav {
  background: #edc url(menuarrow.gif) no-repeat 100% 100%;
}

.calendar thead .title { /* This holds the current "month, year" */
  font-weight: bold;      /* Pressing it will take you to the current date */
  text-align: center;
  background: #654;
  color: #fed;
  padding: 2px;
}

.calendar thead .headrow { /* Row <TR> containing navigation buttons */
  background: #edc;
  color: #000;
}

.calendar thead .name { /* Cells <TD> containing the day names */
  border-bottom: 1px solid #655;
  padding: 2px;
  text-align: center;
  color: #000;
}

.calendar thead .weekend { /* How a weekend day name shows in header */
  color: #f00;
}

.calendar thead .hilite { /* How do the buttons in header appear when hover */
  background-color: #faa;
  color: #000;
  border: 1px solid #f40;
  padding: 1px;
}

.calendar thead .active { /* Active (pressed) buttons in header */
  background-color: #c77;
  padding: 2px 0px 0px 2px;
}

.calendar thead .daynames { /* Row <TR> containing the day names */
  background: #fed;
}

/* The body part -- contains all the days in month. */

.calendar tbody .day { /* Cells <TD> containing month days dates */
  width: 2em;
  text-align: right;
  padding: 2px 4px 2px 2px;
}
.calendar tbody .day.othermonth {
  font-size: 80%;
  color: #bbb;
}
.calendar tbody .day.othermonth.oweekend {
  color: #fbb;
}

.calendar table .wn {
  padding: 2px 3px 2px 2px;
  border-right: 1px solid #000;
  background: #fed;
}

.calendar tbody .rowhilite td {
  background: #ddf;
}

.calendar tbody .rowhilite td.wn {
  background: #efe;
}

.calendar tbody td.hilite { /* Hovered cells <TD> */
  background: #ffe;
  padding: 1px 3px 1px 1px;
  border: 1px solid #bbb;
}

.calendar tbody td.active { /* Active (pressed) cells <TD> */
  background: #ddc;
  padding: 2px 2px 0px 2px;
}

.calendar tbody td.selected { /* Cell showing today date */
  font-weight: bold;
  border: 1px solid #000;
  padding: 1px 3px 1px 1px;
  background: #fea;
}

.calendar tbody td.weekend { /* Cells showing weekend days */
  color: #f00;
}

.calendar tbody td.today { font-weight: bold; }

.calendar tbody .disabled { color: #999; }

.calendar tbody .emptycell { /* Empty cells (the best is to hide them) */
  visibility: hidden;
}

.calendar tbody .emptyrow { /* Empty row (some months need less than 6 rows) */
  display: none;
}

/* The footer part -- status bar and "Close" button */

.calendar tfoot .footrow { /* The <TR> in footer (only one right now) */
  text-align: center;
  background: #988;
  color: #000;
}

.calendar tfoot .ttip { /* Tooltip (status bar) cell <TD> */
  border-top: 1px solid #655;
  background: #dcb;
  color: #840;
}

.calendar tfoot .hilite { /* Hover style for buttons in footer */
  background: #faa;
  border: 1px solid #f40;
  padding: 1px;
}

.calendar tfoot .active { /* Active (pressed) style for buttons in footer */
  background: #c77;
  padding: 2px 0px 0px 2px;
}

/* Combo boxes (menus that display months/years for direct selection) */

.calendar .combo {
  position: absolute;
  display: none;
  top: 0px;
  left: 0px;
  width: 4em;
  cursor: default;
  border: 1px solid #655;
  background: #ffe;
  color: #000;
  font-size: 90%;
  z-index: 100;
}

.calendar .combo .label,
.calendar .combo .label-IEfix {
  text-align: center;
  padding: 1px;
}

.calendar .combo .label-IEfix {
  width: 4em;
}

.calendar .combo .hilite {
  background: #fc8;
}

.calendar .combo .active {
  border-top: 1px solid #a64;
  border-bottom: 1px solid #a64;
  background: #fee;
  font-weight: bold;
}

.calendar td.time {
  border-top: 1px solid #a88;
  padding: 1px 0px;
  text-align: center;
  background-color: #fed;
}

.calendar td.time .hour,
.calendar td.time .minute,
.calendar td.time .ampm {
  padding: 0px 3px 0px 4px;
  border: 1px solid #988;
  font-weight: bold;
  background-color: #fff;
}

.calendar td.time .ampm {
  text-align: center;
}

.calendar td.time .colon {
  padding: 0px 2px 0px 3px;
  font-weight: bold;
}

.calendar td.time span.hilite {
  border-color: #000;
  background-color: #866;
  color: #fff;
}

.calendar td.time span.active {
  border-color: #f00;
  background-color: #000;
  color: #0f0;
}
'
!

calendarCSSResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarCSSResource"
	^self resources at: #jsCalendarCSS ifAbsentPut:
		[WebMethodResource
			fromMethod: #calendarCSS on: self
			contentType: 'text/css' preferedUrl: '/jscalendar/calendar.css' site: self site].
!

calendarJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarJavascript"
	^'
/*  Copyright Mihai Bazon, 2002-2005  |  www.bazon.net/mishoo
 * -----------------------------------------------------------
 *
 * The DHTML Calendar, version 1.0 "It is happening again"
 *
 * Details and latest version at:
 * www.dynarch.com/projects/calendar
 *
 * This script is developed by Dynarch.com.  Visit us at www.dynarch.com.
 *
 * This script is distributed under the GNU Lesser General Public License.
 * Read the entire license text here: http://www.gnu.org/licenses/lgpl.html
 */

// $Id: calendar.js,v 1.51 2005/03/07 16:44:31 mishoo Exp $

/** The Calendar object constructor. */
Calendar = function (firstDayOfWeek, dateStr, onSelected, onClose) {
	// member variables
	this.activeDiv = null;
	this.currentDateEl = null;
	this.getDateStatus = null;
	this.getDateToolTip = null;
	this.getDateText = null;
	this.timeout = null;
	this.onSelected = onSelected || null;
	this.onClose = onClose || null;
	this.dragging = false;
	this.hidden = false;
	this.minYear = 1970;
	this.maxYear = 2050;
	this.dateFormat = Calendar._TT["DEF_DATE_FORMAT"];
	this.ttDateFormat = Calendar._TT["TT_DATE_FORMAT"];
	this.isPopup = true;
	this.weekNumbers = true;
	this.firstDayOfWeek = typeof firstDayOfWeek == "number" ? firstDayOfWeek : Calendar._FD; // 0 for Sunday, 1 for Monday, etc.
	this.showsOtherMonths = false;
	this.dateStr = dateStr;
	this.ar_days = null;
	this.showsTime = false;
	this.time24 = true;
	this.yearStep = 2;
	this.hiliteToday = true;
	this.multiple = null;
	// HTML elements
	this.table = null;
	this.element = null;
	this.tbody = null;
	this.firstdayname = null;
	// Combo boxes
	this.monthsCombo = null;
	this.yearsCombo = null;
	this.hilitedMonth = null;
	this.activeMonth = null;
	this.hilitedYear = null;
	this.activeYear = null;
	// Information
	this.dateClicked = false;

	// one-time initializations
	if (typeof Calendar._SDN == "undefined") {
		// table of short day names
		if (typeof Calendar._SDN_len == "undefined")
			Calendar._SDN_len = 3;
		var ar = new Array();
		for (var i = 8; i > 0;) {
			ar[--i] = Calendar._DN[i].substr(0, Calendar._SDN_len);
		}
		Calendar._SDN = ar;
		// table of short month names
		if (typeof Calendar._SMN_len == "undefined")
			Calendar._SMN_len = 3;
		ar = new Array();
		for (var i = 12; i > 0;) {
			ar[--i] = Calendar._MN[i].substr(0, Calendar._SMN_len);
		}
		Calendar._SMN = ar;
	}
};

// ** constants

/// "static", needed for event handlers.
Calendar._C = null;

/// detect a special case of "web browser"
Calendar.is_ie = ( /msie/i.test(navigator.userAgent) &&
		   !!/opera/i.test(navigator.userAgent) );

Calendar.is_ie5 = ( Calendar.is_ie && /msie 5\.0/i.test(navigator.userAgent) );

/// detect Opera browser
Calendar.is_opera = /opera/i.test(navigator.userAgent);

/// detect KHTML-based browsers
Calendar.is_khtml = /Konqueror|Safari|KHTML/i.test(navigator.userAgent);

// BEGIN: UTILITY FUNCTIONS; beware that these might be moved into a separate
//        library, at some point.

Calendar.getAbsolutePos = function(el) {
	var SL = 0, ST = 0;
	var is_div = /^div$/i.test(el.tagName);
	if (is_div && el.scrollLeft)
		SL = el.scrollLeft;
	if (is_div && el.scrollTop)
		ST = el.scrollTop;
	var r = { x: el.offsetLeft - SL, y: el.offsetTop - ST };
	if (el.offsetParent) {
		var tmp = this.getAbsolutePos(el.offsetParent);
		r.x += tmp.x;
		r.y += tmp.y;
	}
	return r;
};

Calendar.isRelated = function (el, evt) {
	var related = evt.relatedTarget;
	if (!!related) {
		var type = evt.type;
		if (type == "mouseover") {
			related = evt.fromElement;
		} else if (type == "mouseout") {
			related = evt.toElement;
		}
	}
	while (related) {
		if (related == el) {
			return true;
		}
		related = related.parentNode;
	}
	return false;
};

Calendar.removeClass = function(el, className) {
	if (!!(el && el.className)) {
		return;
	}
	var cls = el.className.split(" ");
	var ar = new Array();
	for (var i = cls.length; i > 0;) {
		if (cls[--i] !!= className) {
			ar[ar.length] = cls[i];
		}
	}
	el.className = ar.join(" ");
};

Calendar.addClass = function(el, className) {
	Calendar.removeClass(el, className);
	el.className += " " + className;
};

// FIXME: the following 2 functions totally suck, are useless and should be replaced immediately.
Calendar.getElement = function(ev) {
	var f = Calendar.is_ie ? window.event.srcElement : ev.currentTarget;
	while (f.nodeType !!= 1 || /^div$/i.test(f.tagName))
		f = f.parentNode;
	return f;
};

Calendar.getTargetElement = function(ev) {
	var f = Calendar.is_ie ? window.event.srcElement : ev.target;
	while (f.nodeType !!= 1)
		f = f.parentNode;
	return f;
};

Calendar.stopEvent = function(ev) {
	ev || (ev = window.event);
	if (Calendar.is_ie) {
		ev.cancelBubble = true;
		ev.returnValue = false;
	} else {
		ev.preventDefault();
		ev.stopPropagation();
	}
	return false;
};

Calendar.addEvent = function(el, evname, func) {
	if (el.attachEvent) { // IE
		el.attachEvent("on" + evname, func);
	} else if (el.addEventListener) { // Gecko / W3C
		el.addEventListener(evname, func, true);
	} else {
		el["on" + evname] = func;
	}
};

Calendar.removeEvent = function(el, evname, func) {
	if (el.detachEvent) { // IE
		el.detachEvent("on" + evname, func);
	} else if (el.removeEventListener) { // Gecko / W3C
		el.removeEventListener(evname, func, true);
	} else {
		el["on" + evname] = null;
	}
};

Calendar.createElement = function(type, parent) {
	var el = null;
	if (document.createElementNS) {
		// use the XHTML namespace; IE won''t normally get here unless
		// _they_ "fix" the DOM2 implementation.
		el = document.createElementNS("http://www.w3.org/1999/xhtml", type);
	} else {
		el = document.createElement(type);
	}
	if (typeof parent !!= "undefined") {
		parent.appendChild(el);
	}
	return el;
};

// END: UTILITY FUNCTIONS

// BEGIN: CALENDAR STATIC FUNCTIONS

/** Internal -- adds a set of events to make some element behave like a button. */
Calendar._add_evs = function(el) {
	with (Calendar) {
		addEvent(el, "mouseover", dayMouseOver);
		addEvent(el, "mousedown", dayMouseDown);
		addEvent(el, "mouseout", dayMouseOut);
		if (is_ie) {
			addEvent(el, "dblclick", dayMouseDblClick);
			el.setAttribute("unselectable", true);
		}
	}
};

Calendar.findMonth = function(el) {
	if (typeof el.month !!= "undefined") {
		return el;
	} else if (typeof el.parentNode.month !!= "undefined") {
		return el.parentNode;
	}
	return null;
};

Calendar.findYear = function(el) {
	if (typeof el.year !!= "undefined") {
		return el;
	} else if (typeof el.parentNode.year !!= "undefined") {
		return el.parentNode;
	}
	return null;
};

Calendar.showMonthsCombo = function () {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	var cal = cal;
	var cd = cal.activeDiv;
	var mc = cal.monthsCombo;
	if (cal.hilitedMonth) {
		Calendar.removeClass(cal.hilitedMonth, "hilite");
	}
	if (cal.activeMonth) {
		Calendar.removeClass(cal.activeMonth, "active");
	}
	var mon = cal.monthsCombo.getElementsByTagName("div")[cal.date.getMonth()];
	Calendar.addClass(mon, "active");
	cal.activeMonth = mon;
	var s = mc.style;
	s.display = "block";
	if (cd.navtype < 0)
		s.left = cd.offsetLeft + "px";
	else {
		var mcw = mc.offsetWidth;
		if (typeof mcw == "undefined")
			// Konqueror brain-dead techniques
			mcw = 50;
		s.left = (cd.offsetLeft + cd.offsetWidth - mcw) + "px";
	}
	s.top = (cd.offsetTop + cd.offsetHeight) + "px";
};

Calendar.showYearsCombo = function (fwd) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	var cal = cal;
	var cd = cal.activeDiv;
	var yc = cal.yearsCombo;
	if (cal.hilitedYear) {
		Calendar.removeClass(cal.hilitedYear, "hilite");
	}
	if (cal.activeYear) {
		Calendar.removeClass(cal.activeYear, "active");
	}
	cal.activeYear = null;
	var Y = cal.date.getFullYear() + (fwd ? 1 : -1);
	var yr = yc.firstChild;
	var show = false;
	for (var i = 12; i > 0; --i) {
		if (Y >= cal.minYear && Y <= cal.maxYear) {
			yr.innerHTML = Y;
			yr.year = Y;
			yr.style.display = "block";
			show = true;
		} else {
			yr.style.display = "none";
		}
		yr = yr.nextSibling;
		Y += fwd ? cal.yearStep : -cal.yearStep;
	}
	if (show) {
		var s = yc.style;
		s.display = "block";
		if (cd.navtype < 0)
			s.left = cd.offsetLeft + "px";
		else {
			var ycw = yc.offsetWidth;
			if (typeof ycw == "undefined")
				// Konqueror brain-dead techniques
				ycw = 50;
			s.left = (cd.offsetLeft + cd.offsetWidth - ycw) + "px";
		}
		s.top = (cd.offsetTop + cd.offsetHeight) + "px";
	}
};

// event handlers

Calendar.tableMouseUp = function(ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	if (cal.timeout) {
		clearTimeout(cal.timeout);
	}
	var el = cal.activeDiv;
	if (!!el) {
		return false;
	}
	var target = Calendar.getTargetElement(ev);
	ev || (ev = window.event);
	Calendar.removeClass(el, "active");
	if (target == el || target.parentNode == el) {
		Calendar.cellClick(el, ev);
	}
	var mon = Calendar.findMonth(target);
	var date = null;
	if (mon) {
		date = new Date(cal.date);
		if (mon.month !!= date.getMonth()) {
			date.setMonth(mon.month);
			cal.setDate(date);
			cal.dateClicked = false;
			cal.callHandler();
		}
	} else {
		var year = Calendar.findYear(target);
		if (year) {
			date = new Date(cal.date);
			if (year.year !!= date.getFullYear()) {
				date.setFullYear(year.year);
				cal.setDate(date);
				cal.dateClicked = false;
				cal.callHandler();
			}
		}
	}
	with (Calendar) {
		removeEvent(document, "mouseup", tableMouseUp);
		removeEvent(document, "mouseover", tableMouseOver);
		removeEvent(document, "mousemove", tableMouseOver);
		cal._hideCombos();
		_C = null;
		return stopEvent(ev);
	}
};

Calendar.tableMouseOver = function (ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return;
	}
	var el = cal.activeDiv;
	var target = Calendar.getTargetElement(ev);
	if (target == el || target.parentNode == el) {
		Calendar.addClass(el, "hilite active");
		Calendar.addClass(el.parentNode, "rowhilite");
	} else {
		if (typeof el.navtype == "undefined" || (el.navtype !!= 50 && (el.navtype == 0 || Math.abs(el.navtype) > 2)))
			Calendar.removeClass(el, "active");
		Calendar.removeClass(el, "hilite");
		Calendar.removeClass(el.parentNode, "rowhilite");
	}
	ev || (ev = window.event);
	if (el.navtype == 50 && target !!= el) {
		var pos = Calendar.getAbsolutePos(el);
		var w = el.offsetWidth;
		var x = ev.clientX;
		var dx;
		var decrease = true;
		if (x > pos.x + w) {
			dx = x - pos.x - w;
			decrease = false;
		} else
			dx = pos.x - x;

		if (dx < 0) dx = 0;
		var range = el._range;
		var current = el._current;
		var count = Math.floor(dx / 10) % range.length;
		for (var i = range.length; --i >= 0;)
			if (range[i] == current)
				break;
		while (count-- > 0)
			if (decrease) {
				if (--i < 0)
					i = range.length - 1;
			} else if ( ++i >= range.length )
				i = 0;
		var newval = range[i];
		el.innerHTML = newval;

		cal.onUpdateTime();
	}
	var mon = Calendar.findMonth(target);
	if (mon) {
		if (mon.month !!= cal.date.getMonth()) {
			if (cal.hilitedMonth) {
				Calendar.removeClass(cal.hilitedMonth, "hilite");
			}
			Calendar.addClass(mon, "hilite");
			cal.hilitedMonth = mon;
		} else if (cal.hilitedMonth) {
			Calendar.removeClass(cal.hilitedMonth, "hilite");
		}
	} else {
		if (cal.hilitedMonth) {
			Calendar.removeClass(cal.hilitedMonth, "hilite");
		}
		var year = Calendar.findYear(target);
		if (year) {
			if (year.year !!= cal.date.getFullYear()) {
				if (cal.hilitedYear) {
					Calendar.removeClass(cal.hilitedYear, "hilite");
				}
				Calendar.addClass(year, "hilite");
				cal.hilitedYear = year;
			} else if (cal.hilitedYear) {
				Calendar.removeClass(cal.hilitedYear, "hilite");
			}
		} else if (cal.hilitedYear) {
			Calendar.removeClass(cal.hilitedYear, "hilite");
		}
	}
	return Calendar.stopEvent(ev);
};

Calendar.tableMouseDown = function (ev) {
	if (Calendar.getTargetElement(ev) == Calendar.getElement(ev)) {
		return Calendar.stopEvent(ev);
	}
};

Calendar.calDragIt = function (ev) {
	var cal = Calendar._C;
	if (!!(cal && cal.dragging)) {
		return false;
	}
	var posX;
	var posY;
	if (Calendar.is_ie) {
		posY = window.event.clientY + document.body.scrollTop;
		posX = window.event.clientX + document.body.scrollLeft;
	} else {
		posX = ev.pageX;
		posY = ev.pageY;
	}
	cal.hideShowCovered();
	var st = cal.element.style;
	st.left = (posX - cal.xOffs) + "px";
	st.top = (posY - cal.yOffs) + "px";
	return Calendar.stopEvent(ev);
};

Calendar.calDragEnd = function (ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	cal.dragging = false;
	with (Calendar) {
		removeEvent(document, "mousemove", calDragIt);
		removeEvent(document, "mouseup", calDragEnd);
		tableMouseUp(ev);
	}
	cal.hideShowCovered();
};

Calendar.dayMouseDown = function(ev) {
	var el = Calendar.getElement(ev);
	if (el.disabled) {
		return false;
	}
	var cal = el.calendar;
	cal.activeDiv = el;
	Calendar._C = cal;
	if (el.navtype !!= 300) with (Calendar) {
		if (el.navtype == 50) {
			el._current = el.innerHTML;
			addEvent(document, "mousemove", tableMouseOver);
		} else
			addEvent(document, Calendar.is_ie5 ? "mousemove" : "mouseover", tableMouseOver);
		addClass(el, "hilite active");
		addEvent(document, "mouseup", tableMouseUp);
	} else if (cal.isPopup) {
		cal._dragStart(ev);
	}
	if (el.navtype == -1 || el.navtype == 1) {
		if (cal.timeout) clearTimeout(cal.timeout);
		cal.timeout = setTimeout("Calendar.showMonthsCombo()", 250);
	} else if (el.navtype == -2 || el.navtype == 2) {
		if (cal.timeout) clearTimeout(cal.timeout);
		cal.timeout = setTimeout((el.navtype > 0) ? "Calendar.showYearsCombo(true)" : "Calendar.showYearsCombo(false)", 250);
	} else {
		cal.timeout = null;
	}
	return Calendar.stopEvent(ev);
};

Calendar.dayMouseDblClick = function(ev) {
	Calendar.cellClick(Calendar.getElement(ev), ev || window.event);
	if (Calendar.is_ie) {
		document.selection.empty();
	}
};

Calendar.dayMouseOver = function(ev) {
	var el = Calendar.getElement(ev);
	if (Calendar.isRelated(el, ev) || Calendar._C || el.disabled) {
		return false;
	}
	if (el.ttip) {
		if (el.ttip.substr(0, 1) == "_") {
			el.ttip = el.caldate.print(el.calendar.ttDateFormat) + el.ttip.substr(1);
		}
		el.calendar.tooltips.innerHTML = el.ttip;
	}
	if (el.navtype !!= 300) {
		Calendar.addClass(el, "hilite");
		if (el.caldate) {
			Calendar.addClass(el.parentNode, "rowhilite");
		}
	}
	return Calendar.stopEvent(ev);
};

Calendar.dayMouseOut = function(ev) {
	with (Calendar) {
		var el = getElement(ev);
		if (isRelated(el, ev) || _C || el.disabled)
			return false;
		removeClass(el, "hilite");
		if (el.caldate)
			removeClass(el.parentNode, "rowhilite");
		if (el.calendar)
			el.calendar.tooltips.innerHTML = _TT["SEL_DATE"];
		return stopEvent(ev);
	}
};

/**
 *  A generic "click" handler :) handles all types of buttons defined in this
 *  calendar.
 */
Calendar.cellClick = function(el, ev) {
	var cal = el.calendar;
	var closing = false;
	var newdate = false;
	var date = null;
	if (typeof el.navtype == "undefined") {
		if (cal.currentDateEl) {
			Calendar.removeClass(cal.currentDateEl, "selected");
			Calendar.addClass(el, "selected");
			closing = (cal.currentDateEl == el);
			if (!!closing) {
				cal.currentDateEl = el;
			}
		}
		cal.date.setDateOnly(el.caldate);
		date = cal.date;
		var other_month = !!(cal.dateClicked = !!el.otherMonth);
		if (!!other_month && !!cal.currentDateEl)
			cal._toggleMultipleDate(new Date(date));
		else
			newdate = !!el.disabled;
		// a date was clicked
		if (other_month)
			cal._init(cal.firstDayOfWeek, date);
	} else {
		if (el.navtype == 200) {
			Calendar.removeClass(el, "hilite");
			cal.callCloseHandler();
			return;
		}
		date = new Date(cal.date);
		if (el.navtype == 0)
			date.setDateOnly(new Date()); // TODAY
		// unless "today" was clicked, we assume no date was clicked so
		// the selected handler will know not to close the calenar when
		// in single-click mode.
		// cal.dateClicked = (el.navtype == 0);
		cal.dateClicked = false;
		var year = date.getFullYear();
		var mon = date.getMonth();
		function setMonth(m) {
			var day = date.getDate();
			var max = date.getMonthDays(m);
			if (day > max) {
				date.setDate(max);
			}
			date.setMonth(m);
		};
		switch (el.navtype) {
		    case 400:
			Calendar.removeClass(el, "hilite");
			var text = Calendar._TT["ABOUT"];
			if (typeof text !!= "undefined") {
				text += cal.showsTime ? Calendar._TT["ABOUT_TIME"] : "";
			} else {
				// FIXME: this should be removed as soon as lang files get updated!!
				text = "Help and about box text is not translated into this language.\n" +
					"If you know this language and you feel generous please update\n" +
					"the corresponding file in \"lang\" subdir to match calendar-en.js\n" +
					"and send it back to <mihai_bazon@yahoo.com> to get it into the distribution  ;-)\n\n" +
					"Thank you!!\n" +
					"http://dynarch.com/mishoo/calendar.epl\n";
			}
			alert(text);
			return;
		    case -2:
			if (year > cal.minYear) {
				date.setFullYear(year - 1);
			}
			break;
		    case -1:
			if (mon > 0) {
				setMonth(mon - 1);
			} else if (year-- > cal.minYear) {
				date.setFullYear(year);
				setMonth(11);
			}
			break;
		    case 1:
			if (mon < 11) {
				setMonth(mon + 1);
			} else if (year < cal.maxYear) {
				date.setFullYear(year + 1);
				setMonth(0);
			}
			break;
		    case 2:
			if (year < cal.maxYear) {
				date.setFullYear(year + 1);
			}
			break;
		    case 100:
			cal.setFirstDayOfWeek(el.fdow);
			return;
		    case 50:
			var range = el._range;
			var current = el.innerHTML;
			for (var i = range.length; --i >= 0;)
				if (range[i] == current)
					break;
			if (ev && ev.shiftKey) {
				if (--i < 0)
					i = range.length - 1;
			} else if ( ++i >= range.length )
				i = 0;
			var newval = range[i];
			el.innerHTML = newval;
			cal.onUpdateTime();
			return;
		    case 0:
			// TODAY will bring us here
			if ((typeof cal.getDateStatus == "function") &&
			    cal.getDateStatus(date, date.getFullYear(), date.getMonth(), date.getDate())) {
				return false;
			}
			break;
		}
		if (!!date.equalsTo(cal.date)) {
			cal.setDate(date);
			newdate = true;
		} else if (el.navtype == 0)
			newdate = closing = true;
	}
	if (newdate) {
		ev && cal.callHandler();
	}
	if (closing) {
		Calendar.removeClass(el, "hilite");
		ev && cal.callCloseHandler();
	}
};

// END: CALENDAR STATIC FUNCTIONS

// BEGIN: CALENDAR OBJECT FUNCTIONS

/**
 *  This function creates the calendar inside the given parent.  If _par is
 *  null than it creates a popup calendar inside the BODY element.  If _par is
 *  an element, be it BODY, then it creates a non-popup calendar (still
 *  hidden).  Some properties need to be set before calling this function.
 */
Calendar.prototype.create = function (_par) {
	var parent = null;
	if (!! _par) {
		// default parent is the document body, in which case we create
		// a popup calendar.
		parent = document.getElementsByTagName("body")[0];
		this.isPopup = true;
	} else {
		parent = _par;
		this.isPopup = false;
	}
	this.date = this.dateStr ? new Date(this.dateStr) : new Date();

	var table = Calendar.createElement("table");
	this.table = table;
	table.cellSpacing = 0;
	table.cellPadding = 0;
	table.calendar = this;
	Calendar.addEvent(table, "mousedown", Calendar.tableMouseDown);

	var div = Calendar.createElement("div");
	this.element = div;
	div.className = "calendar";
	if (this.isPopup) {
		div.style.position = "absolute";
		div.style.display = "none";
	}
	div.appendChild(table);

	var thead = Calendar.createElement("thead", table);
	var cell = null;
	var row = null;

	var cal = this;
	var hh = function (text, cs, navtype) {
		cell = Calendar.createElement("td", row);
		cell.colSpan = cs;
		cell.className = "button";
		if (navtype !!= 0 && Math.abs(navtype) <= 2)
			cell.className += " nav";
		Calendar._add_evs(cell);
		cell.calendar = cal;
		cell.navtype = navtype;
		cell.innerHTML = "<div unselectable=''on''>" + text + "</div>";
		return cell;
	};

	row = Calendar.createElement("tr", thead);
	var title_length = 6;
	(this.isPopup) && --title_length;
	(this.weekNumbers) && ++title_length;

	hh("?", 1, 400).ttip = Calendar._TT["INFO"];
	this.title = hh("", title_length, 300);
	this.title.className = "title";
	if (this.isPopup) {
		this.title.ttip = Calendar._TT["DRAG_TO_MOVE"];
		this.title.style.cursor = "move";
		hh("&#x00d7;", 1, 200).ttip = Calendar._TT["CLOSE"];
	}

	row = Calendar.createElement("tr", thead);
	row.className = "headrow";

	this._nav_py = hh("&#x00ab;", 1, -2);
	this._nav_py.ttip = Calendar._TT["PREV_YEAR"];

	this._nav_pm = hh("&#x2039;", 1, -1);
	this._nav_pm.ttip = Calendar._TT["PREV_MONTH"];

	this._nav_now = hh(Calendar._TT["TODAY"], this.weekNumbers ? 4 : 3, 0);
	this._nav_now.ttip = Calendar._TT["GO_TODAY"];

	this._nav_nm = hh("&#x203a;", 1, 1);
	this._nav_nm.ttip = Calendar._TT["NEXT_MONTH"];

	this._nav_ny = hh("&#x00bb;", 1, 2);
	this._nav_ny.ttip = Calendar._TT["NEXT_YEAR"];

	// day names
	row = Calendar.createElement("tr", thead);
	row.className = "daynames";
	if (this.weekNumbers) {
		cell = Calendar.createElement("td", row);
		cell.className = "name wn";
		cell.innerHTML = Calendar._TT["WK"];
	}
	for (var i = 7; i > 0; --i) {
		cell = Calendar.createElement("td", row);
		if (!!i) {
			cell.navtype = 100;
			cell.calendar = this;
			Calendar._add_evs(cell);
		}
	}
	this.firstdayname = (this.weekNumbers) ? row.firstChild.nextSibling : row.firstChild;
	this._displayWeekdays();

	var tbody = Calendar.createElement("tbody", table);
	this.tbody = tbody;

	for (i = 6; i > 0; --i) {
		row = Calendar.createElement("tr", tbody);
		if (this.weekNumbers) {
			cell = Calendar.createElement("td", row);
		}
		for (var j = 7; j > 0; --j) {
			cell = Calendar.createElement("td", row);
			cell.calendar = this;
			Calendar._add_evs(cell);
		}
	}

	if (this.showsTime) {
		row = Calendar.createElement("tr", tbody);
		row.className = "time";

		cell = Calendar.createElement("td", row);
		cell.className = "time";
		cell.colSpan = 2;
		cell.innerHTML = Calendar._TT["TIME"] || "&nbsp;";

		cell = Calendar.createElement("td", row);
		cell.className = "time";
		cell.colSpan = this.weekNumbers ? 4 : 3;

		(function(){
			function makeTimePart(className, init, range_start, range_end) {
				var part = Calendar.createElement("span", cell);
				part.className = className;
				part.innerHTML = init;
				part.calendar = cal;
				part.ttip = Calendar._TT["TIME_PART"];
				part.navtype = 50;
				part._range = [];
				if (typeof range_start !!= "number")
					part._range = range_start;
				else {
					for (var i = range_start; i <= range_end; ++i) {
						var txt;
						if (i < 10 && range_end >= 10) txt = ''0'' + i;
						else txt = '''' + i;
						part._range[part._range.length] = txt;
					}
				}
				Calendar._add_evs(part);
				return part;
			};
			var hrs = cal.date.getHours();
			var mins = cal.date.getMinutes();
			var t12 = !!cal.time24;
			var pm = (hrs > 12);
			if (t12 && pm) hrs -= 12;
			var H = makeTimePart("hour", hrs, t12 ? 1 : 0, t12 ? 12 : 23);
			var span = Calendar.createElement("span", cell);
			span.innerHTML = ":";
			span.className = "colon";
			var M = makeTimePart("minute", mins, 0, 59);
			var AP = null;
			cell = Calendar.createElement("td", row);
			cell.className = "time";
			cell.colSpan = 2;
			if (t12)
				AP = makeTimePart("ampm", pm ? "pm" : "am", ["am", "pm"]);
			else
				cell.innerHTML = "&nbsp;";

			cal.onSetTime = function() {
				var pm, hrs = this.date.getHours(),
					mins = this.date.getMinutes();
				if (t12) {
					pm = (hrs >= 12);
					if (pm) hrs -= 12;
					if (hrs == 0) hrs = 12;
					AP.innerHTML = pm ? "pm" : "am";
				}
				H.innerHTML = (hrs < 10) ? ("0" + hrs) : hrs;
				M.innerHTML = (mins < 10) ? ("0" + mins) : mins;
			};

			cal.onUpdateTime = function() {
				var date = this.date;
				var h = parseInt(H.innerHTML, 10);
				if (t12) {
					if (/pm/i.test(AP.innerHTML) && h < 12)
						h += 12;
					else if (/am/i.test(AP.innerHTML) && h == 12)
						h = 0;
				}
				var d = date.getDate();
				var m = date.getMonth();
				var y = date.getFullYear();
				date.setHours(h);
				date.setMinutes(parseInt(M.innerHTML, 10));
				date.setFullYear(y);
				date.setMonth(m);
				date.setDate(d);
				this.dateClicked = false;
				this.callHandler();
			};
		})();
	} else {
		this.onSetTime = this.onUpdateTime = function() {};
	}

	var tfoot = Calendar.createElement("tfoot", table);

	row = Calendar.createElement("tr", tfoot);
	row.className = "footrow";

	cell = hh(Calendar._TT["SEL_DATE"], this.weekNumbers ? 8 : 7, 300);
	cell.className = "ttip";
	if (this.isPopup) {
		cell.ttip = Calendar._TT["DRAG_TO_MOVE"];
		cell.style.cursor = "move";
	}
	this.tooltips = cell;

	div = Calendar.createElement("div", this.element);
	this.monthsCombo = div;
	div.className = "combo";
	for (i = 0; i < Calendar._MN.length; ++i) {
		var mn = Calendar.createElement("div");
		mn.className = Calendar.is_ie ? "label-IEfix" : "label";
		mn.month = i;
		mn.innerHTML = Calendar._SMN[i];
		div.appendChild(mn);
	}

	div = Calendar.createElement("div", this.element);
	this.yearsCombo = div;
	div.className = "combo";
	for (i = 12; i > 0; --i) {
		var yr = Calendar.createElement("div");
		yr.className = Calendar.is_ie ? "label-IEfix" : "label";
		div.appendChild(yr);
	}

	this._init(this.firstDayOfWeek, this.date);
	parent.appendChild(this.element);
};

/** keyboard navigation, only for popup calendars */
Calendar._keyEvent = function(ev) {
	var cal = window._dynarch_popupCalendar;
	if (!!cal || cal.multiple)
		return false;
	(Calendar.is_ie) && (ev = window.event);
	var act = (Calendar.is_ie || ev.type == "keypress"),
		K = ev.keyCode;
	if (ev.ctrlKey) {
		switch (K) {
		    case 37: // KEY left
			act && Calendar.cellClick(cal._nav_pm);
			break;
		    case 38: // KEY up
			act && Calendar.cellClick(cal._nav_py);
			break;
		    case 39: // KEY right
			act && Calendar.cellClick(cal._nav_nm);
			break;
		    case 40: // KEY down
			act && Calendar.cellClick(cal._nav_ny);
			break;
		    default:
			return false;
		}
	} else switch (K) {
	    case 32: // KEY space (now)
		Calendar.cellClick(cal._nav_now);
		break;
	    case 27: // KEY esc
		act && cal.callCloseHandler();
		break;
	    case 37: // KEY left
	    case 38: // KEY up
	    case 39: // KEY right
	    case 40: // KEY down
		if (act) {
			var prev, x, y, ne, el, step;
			prev = K == 37 || K == 38;
			step = (K == 37 || K == 39) ? 1 : 7;
			function setVars() {
				el = cal.currentDateEl;
				var p = el.pos;
				x = p & 15;
				y = p >> 4;
				ne = cal.ar_days[y][x];
			};setVars();
			function prevMonth() {
				var date = new Date(cal.date);
				date.setDate(date.getDate() - step);
				cal.setDate(date);
			};
			function nextMonth() {
				var date = new Date(cal.date);
				date.setDate(date.getDate() + step);
				cal.setDate(date);
			};
			while (1) {
				switch (K) {
				    case 37: // KEY left
					if (--x >= 0)
						ne = cal.ar_days[y][x];
					else {
						x = 6;
						K = 38;
						continue;
					}
					break;
				    case 38: // KEY up
					if (--y >= 0)
						ne = cal.ar_days[y][x];
					else {
						prevMonth();
						setVars();
					}
					break;
				    case 39: // KEY right
					if (++x < 7)
						ne = cal.ar_days[y][x];
					else {
						x = 0;
						K = 40;
						continue;
					}
					break;
				    case 40: // KEY down
					if (++y < cal.ar_days.length)
						ne = cal.ar_days[y][x];
					else {
						nextMonth();
						setVars();
					}
					break;
				}
				break;
			}
			if (ne) {
				if (!!ne.disabled)
					Calendar.cellClick(ne);
				else if (prev)
					prevMonth();
				else
					nextMonth();
			}
		}
		break;
	    case 13: // KEY enter
		if (act)
			Calendar.cellClick(cal.currentDateEl, ev);
		break;
	    default:
		return false;
	}
	return Calendar.stopEvent(ev);
};

/**
 *  (RE)Initializes the calendar to the given date and firstDayOfWeek
 */
Calendar.prototype._init = function (firstDayOfWeek, date) {
	var today = new Date(),
		TY = today.getFullYear(),
		TM = today.getMonth(),
		TD = today.getDate();
	this.table.style.visibility = "hidden";
	var year = date.getFullYear();
	if (year < this.minYear) {
		year = this.minYear;
		date.setFullYear(year);
	} else if (year > this.maxYear) {
		year = this.maxYear;
		date.setFullYear(year);
	}
	this.firstDayOfWeek = firstDayOfWeek;
	this.date = new Date(date);
	var month = date.getMonth();
	var mday = date.getDate();
	var no_days = date.getMonthDays();

	// calendar voodoo for computing the first day that would actually be
	// displayed in the calendar, even if it''s from the previous month.
	// WARNING: this is magic. ;-)
	date.setDate(1);
	var day1 = (date.getDay() - this.firstDayOfWeek) % 7;
	if (day1 < 0)
		day1 += 7;
	date.setDate(-day1);
	date.setDate(date.getDate() + 1);

	var row = this.tbody.firstChild;
	var MN = Calendar._SMN[month];
	var ar_days = this.ar_days = new Array();
	var weekend = Calendar._TT["WEEKEND"];
	var dates = this.multiple ? (this.datesCells = {}) : null;
	for (var i = 0; i < 6; ++i, row = row.nextSibling) {
		var cell = row.firstChild;
		if (this.weekNumbers) {
			cell.className = "day wn";
			cell.innerHTML = date.getWeekNumber();
			cell = cell.nextSibling;
		}
		row.className = "daysrow";
		var hasdays = false, iday, dpos = ar_days[i] = [];
		for (var j = 0; j < 7; ++j, cell = cell.nextSibling, date.setDate(iday + 1)) {
			iday = date.getDate();
			var wday = date.getDay();
			cell.className = "day";
			cell.pos = i << 4 | j;
			dpos[j] = cell;
			var current_month = (date.getMonth() == month);
			if (!!current_month) {
				if (this.showsOtherMonths) {
					cell.className += " othermonth";
					cell.otherMonth = true;
				} else {
					cell.className = "emptycell";
					cell.innerHTML = "&nbsp;";
					cell.disabled = true;
					continue;
				}
			} else {
				cell.otherMonth = false;
				hasdays = true;
			}
			cell.disabled = false;
			cell.innerHTML = this.getDateText ? this.getDateText(date, iday) : iday;
			if (dates)
				dates[date.print("%Y%m%d")] = cell;
			if (this.getDateStatus) {
				var status = this.getDateStatus(date, year, month, iday);
				if (this.getDateToolTip) {
					var toolTip = this.getDateToolTip(date, year, month, iday);
					if (toolTip)
						cell.title = toolTip;
				}
				if (status === true) {
					cell.className += " disabled";
					cell.disabled = true;
				} else {
					if (/disabled/i.test(status))
						cell.disabled = true;
					cell.className += " " + status;
				}
			}
			if (!!cell.disabled) {
				cell.caldate = new Date(date);
				cell.ttip = "_";
				if (!!this.multiple && current_month
				    && iday == mday && this.hiliteToday) {
					cell.className += " selected";
					this.currentDateEl = cell;
				}
				if (date.getFullYear() == TY &&
				    date.getMonth() == TM &&
				    iday == TD) {
					cell.className += " today";
					cell.ttip += Calendar._TT["PART_TODAY"];
				}
				if (weekend.indexOf(wday.toString()) !!= -1)
					cell.className += cell.otherMonth ? " oweekend" : " weekend";
			}
		}
		if (!!(hasdays || this.showsOtherMonths))
			row.className = "emptyrow";
	}
	this.title.innerHTML = Calendar._MN[month] + ", " + year;
	this.onSetTime();
	this.table.style.visibility = "visible";
	this._initMultipleDates();
	// PROFILE
	// this.tooltips.innerHTML = "Generated in " + ((new Date()) - today) + " ms";
};

Calendar.prototype._initMultipleDates = function() {
	if (this.multiple) {
		for (var i in this.multiple) {
			var cell = this.datesCells[i];
			var d = this.multiple[i];
			if (!!d)
				continue;
			if (cell)
				cell.className += " selected";
		}
	}
};

Calendar.prototype._toggleMultipleDate = function(date) {
	if (this.multiple) {
		var ds = date.print("%Y%m%d");
		var cell = this.datesCells[ds];
		if (cell) {
			var d = this.multiple[ds];
			if (!!d) {
				Calendar.addClass(cell, "selected");
				this.multiple[ds] = date;
			} else {
				Calendar.removeClass(cell, "selected");
				delete this.multiple[ds];
			}
		}
	}
};

Calendar.prototype.setDateToolTipHandler = function (unaryFunction) {
	this.getDateToolTip = unaryFunction;
};

/**
 *  Calls _init function above for going to a certain date (but only if the
 *  date is different than the currently selected one).
 */
Calendar.prototype.setDate = function (date) {
	if (!!date.equalsTo(this.date)) {
		this._init(this.firstDayOfWeek, date);
	}
};

/**
 *  Refreshes the calendar.  Useful if the "disabledHandler" function is
 *  dynamic, meaning that the list of disabled date can change at runtime.
 *  Just * call this function if you think that the list of disabled dates
 *  should * change.
 */
Calendar.prototype.refresh = function () {
	this._init(this.firstDayOfWeek, this.date);
};

/** Modifies the "firstDayOfWeek" parameter (pass 0 for Synday, 1 for Monday, etc.). */
Calendar.prototype.setFirstDayOfWeek = function (firstDayOfWeek) {
	this._init(firstDayOfWeek, this.date);
	this._displayWeekdays();
};

/**
 *  Allows customization of what dates are enabled.  The "unaryFunction"
 *  parameter must be a function object that receives the date (as a JS Date
 *  object) and returns a boolean value.  If the returned value is true then
 *  the passed date will be marked as disabled.
 */
Calendar.prototype.setDateStatusHandler = Calendar.prototype.setDisabledHandler = function (unaryFunction) {
	this.getDateStatus = unaryFunction;
};

/** Customization of allowed year range for the calendar. */
Calendar.prototype.setRange = function (a, z) {
	this.minYear = a;
	this.maxYear = z;
};

/** Calls the first user handler (selectedHandler). */
Calendar.prototype.callHandler = function () {
	if (this.onSelected) {
		this.onSelected(this, this.date.print(this.dateFormat));
	}
};

/** Calls the second user handler (closeHandler). */
Calendar.prototype.callCloseHandler = function () {
	if (this.onClose) {
		this.onClose(this);
	}
	this.hideShowCovered();
};

/** Removes the calendar object from the DOM tree and destroys it. */
Calendar.prototype.destroy = function () {
	var el = this.element.parentNode;
	el.removeChild(this.element);
	Calendar._C = null;
	window._dynarch_popupCalendar = null;
};

/**
 *  Moves the calendar element to a different section in the DOM tree (changes
 *  its parent).
 */
Calendar.prototype.reparent = function (new_parent) {
	var el = this.element;
	el.parentNode.removeChild(el);
	new_parent.appendChild(el);
};

// This gets called when the user presses a mouse button anywhere in the
// document, if the calendar is shown.  If the click was outside the open
// calendar this function closes it.
Calendar._checkCalendar = function(ev) {
	var calendar = window._dynarch_popupCalendar;
	if (!!calendar) {
		return false;
	}
	var el = Calendar.is_ie ? Calendar.getElement(ev) : Calendar.getTargetElement(ev);
	for (; el !!= null && el !!= calendar.element; el = el.parentNode);
	if (el == null) {
		// calls closeHandler which should hide the calendar.
		window._dynarch_popupCalendar.callCloseHandler();
		return Calendar.stopEvent(ev);
	}
};

/** Shows the calendar. */
Calendar.prototype.show = function () {
	var rows = this.table.getElementsByTagName("tr");
	for (var i = rows.length; i > 0;) {
		var row = rows[--i];
		Calendar.removeClass(row, "rowhilite");
		var cells = row.getElementsByTagName("td");
		for (var j = cells.length; j > 0;) {
			var cell = cells[--j];
			Calendar.removeClass(cell, "hilite");
			Calendar.removeClass(cell, "active");
		}
	}
	this.element.style.display = "block";
	this.hidden = false;
	if (this.isPopup) {
		window._dynarch_popupCalendar = this;
		Calendar.addEvent(document, "keydown", Calendar._keyEvent);
		Calendar.addEvent(document, "keypress", Calendar._keyEvent);
		Calendar.addEvent(document, "mousedown", Calendar._checkCalendar);
	}
	this.hideShowCovered();
};

/**
 *  Hides the calendar.  Also removes any "hilite" from the class of any TD
 *  element.
 */
Calendar.prototype.hide = function () {
	if (this.isPopup) {
		Calendar.removeEvent(document, "keydown", Calendar._keyEvent);
		Calendar.removeEvent(document, "keypress", Calendar._keyEvent);
		Calendar.removeEvent(document, "mousedown", Calendar._checkCalendar);
	}
	this.element.style.display = "none";
	this.hidden = true;
	this.hideShowCovered();
};

/**
 *  Shows the calendar at a given absolute position (beware that, depending on
 *  the calendar element style -- position property -- this might be relative
 *  to the parent''s containing rectangle).
 */
Calendar.prototype.showAt = function (x, y) {
	var s = this.element.style;
	s.left = x + "px";
	s.top = y + "px";
	this.show();
};

/** Shows the calendar near a given element. */
Calendar.prototype.showAtElement = function (el, opts) {
	var self = this;
	var p = Calendar.getAbsolutePos(el);
	if (!!opts || typeof opts !!= "string") {
		this.showAt(p.x, p.y + el.offsetHeight);
		return true;
	}
	function fixPosition(box) {
		if (box.x < 0)
			box.x = 0;
		if (box.y < 0)
			box.y = 0;
		var cp = document.createElement("div");
		var s = cp.style;
		s.position = "absolute";
		s.right = s.bottom = s.width = s.height = "0px";
		document.body.appendChild(cp);
		var br = Calendar.getAbsolutePos(cp);
		document.body.removeChild(cp);
		if (Calendar.is_ie) {
			br.y += document.body.scrollTop;
			br.x += document.body.scrollLeft;
		} else {
			br.y += window.scrollY;
			br.x += window.scrollX;
		}
		var tmp = box.x + box.width - br.x;
		if (tmp > 0) box.x -= tmp;
		tmp = box.y + box.height - br.y;
		if (tmp > 0) box.y -= tmp;
	};
	this.element.style.display = "block";
	Calendar.continuation_for_the_fucking_khtml_browser = function() {
		var w = self.element.offsetWidth;
		var h = self.element.offsetHeight;
		self.element.style.display = "none";
		var valign = opts.substr(0, 1);
		var halign = "l";
		if (opts.length > 1) {
			halign = opts.substr(1, 1);
		}
		// vertical alignment
		switch (valign) {
		    case "T": p.y -= h; break;
		    case "B": p.y += el.offsetHeight; break;
		    case "C": p.y += (el.offsetHeight - h) / 2; break;
		    case "t": p.y += el.offsetHeight - h; break;
		    case "b": break; // already there
		}
		// horizontal alignment
		switch (halign) {
		    case "L": p.x -= w; break;
		    case "R": p.x += el.offsetWidth; break;
		    case "C": p.x += (el.offsetWidth - w) / 2; break;
		    case "l": p.x += el.offsetWidth - w; break;
		    case "r": break; // already there
		}
		p.width = w;
		p.height = h + 40;
		self.monthsCombo.style.display = "none";
		fixPosition(p);
		self.showAt(p.x, p.y);
	};
	if (Calendar.is_khtml)
		setTimeout("Calendar.continuation_for_the_fucking_khtml_browser()", 10);
	else
		Calendar.continuation_for_the_fucking_khtml_browser();
};

/** Customizes the date format. */
Calendar.prototype.setDateFormat = function (str) {
	this.dateFormat = str;
};

/** Customizes the tooltip date format. */
Calendar.prototype.setTtDateFormat = function (str) {
	this.ttDateFormat = str;
};

/**
 *  Tries to identify the date represented in a string.  If successful it also
 *  calls this.setDate which moves the calendar to the given date.
 */
Calendar.prototype.parseDate = function(str, fmt) {
	if (!!fmt)
		fmt = this.dateFormat;
	this.setDate(Date.parseDate(str, fmt));
};

Calendar.prototype.hideShowCovered = function () {
	if (!!Calendar.is_ie && !!Calendar.is_opera)
		return;
	function getVisib(obj){
		var value = obj.style.visibility;
		if (!!value) {
			if (document.defaultView && typeof (document.defaultView.getComputedStyle) == "function") { // Gecko, W3C
				if (!!Calendar.is_khtml)
					value = document.defaultView.
						getComputedStyle(obj, "").getPropertyValue("visibility");
				else
					value = '''';
			} else if (obj.currentStyle) { // IE
				value = obj.currentStyle.visibility;
			} else
				value = '''';
		}
		return value;
	};

	var tags = new Array("applet", "iframe", "select");
	var el = this.element;

	var p = Calendar.getAbsolutePos(el);
	var EX1 = p.x;
	var EX2 = el.offsetWidth + EX1;
	var EY1 = p.y;
	var EY2 = el.offsetHeight + EY1;

	for (var k = tags.length; k > 0; ) {
		var ar = document.getElementsByTagName(tags[--k]);
		var cc = null;

		for (var i = ar.length; i > 0;) {
			cc = ar[--i];

			p = Calendar.getAbsolutePos(cc);
			var CX1 = p.x;
			var CX2 = cc.offsetWidth + CX1;
			var CY1 = p.y;
			var CY2 = cc.offsetHeight + CY1;

			if (this.hidden || (CX1 > EX2) || (CX2 < EX1) || (CY1 > EY2) || (CY2 < EY1)) {
				if (!!cc.__msh_save_visibility) {
					cc.__msh_save_visibility = getVisib(cc);
				}
				cc.style.visibility = cc.__msh_save_visibility;
			} else {
				if (!!cc.__msh_save_visibility) {
					cc.__msh_save_visibility = getVisib(cc);
				}
				cc.style.visibility = "hidden";
			}
		}
	}
};

/** Internal function; it displays the bar with the names of the weekday. */
Calendar.prototype._displayWeekdays = function () {
	var fdow = this.firstDayOfWeek;
	var cell = this.firstdayname;
	var weekend = Calendar._TT["WEEKEND"];
	for (var i = 0; i < 7; ++i) {
		cell.className = "day name";
		var realday = (i + fdow) % 7;
		if (i) {
			cell.ttip = Calendar._TT["DAY_FIRST"].replace("%s", Calendar._DN[realday]);
			cell.navtype = 100;
			cell.calendar = this;
			cell.fdow = realday;
			Calendar._add_evs(cell);
		}
		if (weekend.indexOf(realday.toString()) !!= -1) {
			Calendar.addClass(cell, "weekend");
		}
		cell.innerHTML = Calendar._SDN[(i + fdow) % 7];
		cell = cell.nextSibling;
	}
};

/** Internal function.  Hides all combo boxes that might be displayed. */
Calendar.prototype._hideCombos = function () {
	this.monthsCombo.style.display = "none";
	this.yearsCombo.style.display = "none";
};

/** Internal function.  Starts dragging the element. */
Calendar.prototype._dragStart = function (ev) {
	if (this.dragging) {
		return;
	}
	this.dragging = true;
	var posX;
	var posY;
	if (Calendar.is_ie) {
		posY = window.event.clientY + document.body.scrollTop;
		posX = window.event.clientX + document.body.scrollLeft;
	} else {
		posY = ev.clientY + window.scrollY;
		posX = ev.clientX + window.scrollX;
	}
	var st = this.element.style;
	this.xOffs = posX - parseInt(st.left);
	this.yOffs = posY - parseInt(st.top);
	with (Calendar) {
		addEvent(document, "mousemove", calDragIt);
		addEvent(document, "mouseup", calDragEnd);
	}
};

// BEGIN: DATE OBJECT PATCHES

/** Adds the number of days array to the Date object. */
Date._MD = new Array(31,28,31,30,31,30,31,31,30,31,30,31);

/** Constants used for time computations */
Date.SECOND = 1000 /* milliseconds */;
Date.MINUTE = 60 * Date.SECOND;
Date.HOUR   = 60 * Date.MINUTE;
Date.DAY    = 24 * Date.HOUR;
Date.WEEK   =  7 * Date.DAY;

Date.parseDate = function(str, fmt) {
	var today = new Date();
	var y = 0;
	var m = -1;
	var d = 0;
	var a = str.split(/\W+/);
	var b = fmt.match(/%./g);
	var i = 0, j = 0;
	var hr = 0;
	var min = 0;
	for (i = 0; i < a.length; ++i) {
		if (!!a[i])
			continue;
		switch (b[i]) {
		    case "%d":
		    case "%e":
			d = parseInt(a[i], 10);
			break;

		    case "%m":
			m = parseInt(a[i], 10) - 1;
			break;

		    case "%Y":
		    case "%y":
			y = parseInt(a[i], 10);
			(y < 100) && (y += (y > 29) ? 1900 : 2000);
			break;

		    case "%b":
		    case "%B":
			for (j = 0; j < 12; ++j) {
				if (Calendar._MN[j].substr(0, a[i].length).toLowerCase() == a[i].toLowerCase()) { m = j; break; }
			}
			break;

		    case "%H":
		    case "%I":
		    case "%k":
		    case "%l":
			hr = parseInt(a[i], 10);
			break;

		    case "%P":
		    case "%p":
			if (/pm/i.test(a[i]) && hr < 12)
				hr += 12;
			else if (/am/i.test(a[i]) && hr >= 12)
				hr -= 12;
			break;

		    case "%M":
			min = parseInt(a[i], 10);
			break;
		}
	}
	if (isNaN(y)) y = today.getFullYear();
	if (isNaN(m)) m = today.getMonth();
	if (isNaN(d)) d = today.getDate();
	if (isNaN(hr)) hr = today.getHours();
	if (isNaN(min)) min = today.getMinutes();
	if (y !!= 0 && m !!= -1 && d !!= 0)
		return new Date(y, m, d, hr, min, 0);
	y = 0; m = -1; d = 0;
	for (i = 0; i < a.length; ++i) {
		if (a[i].search(/[a-zA-Z]+/) !!= -1) {
			var t = -1;
			for (j = 0; j < 12; ++j) {
				if (Calendar._MN[j].substr(0, a[i].length).toLowerCase() == a[i].toLowerCase()) { t = j; break; }
			}
			if (t !!= -1) {
				if (m !!= -1) {
					d = m+1;
				}
				m = t;
			}
		} else if (parseInt(a[i], 10) <= 12 && m == -1) {
			m = a[i]-1;
		} else if (parseInt(a[i], 10) > 31 && y == 0) {
			y = parseInt(a[i], 10);
			(y < 100) && (y += (y > 29) ? 1900 : 2000);
		} else if (d == 0) {
			d = a[i];
		}
	}
	if (y == 0)
		y = today.getFullYear();
	if (m !!= -1 && d !!= 0)
		return new Date(y, m, d, hr, min, 0);
	return today;
};

/** Returns the number of days in the current month */
Date.prototype.getMonthDays = function(month) {
	var year = this.getFullYear();
	if (typeof month == "undefined") {
		month = this.getMonth();
	}
	if (((0 == (year%4)) && ( (0 !!= (year%100)) || (0 == (year%400)))) && month == 1) {
		return 29;
	} else {
		return Date._MD[month];
	}
};

/** Returns the number of day in the year. */
Date.prototype.getDayOfYear = function() {
	var now = new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0, 0, 0);
	var then = new Date(this.getFullYear(), 0, 0, 0, 0, 0);
	var time = now - then;
	return Math.floor(time / Date.DAY);
};

/** Returns the number of the week in year, as defined in ISO 8601. */
Date.prototype.getWeekNumber = function() {
	var d = new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0, 0, 0);
	var DoW = d.getDay();
	d.setDate(d.getDate() - (DoW + 6) % 7 + 3); // Nearest Thu
	var ms = d.valueOf(); // GMT
	d.setMonth(0);
	d.setDate(4); // Thu in Week 1
	return Math.round((ms - d.valueOf()) / (7 * 864e5)) + 1;
};

/** Checks date and time equality */
Date.prototype.equalsTo = function(date) {
	return ((this.getFullYear() == date.getFullYear()) &&
		(this.getMonth() == date.getMonth()) &&
		(this.getDate() == date.getDate()) &&
		(this.getHours() == date.getHours()) &&
		(this.getMinutes() == date.getMinutes()));
};

/** Set only the year, month, date parts (keep existing time) */
Date.prototype.setDateOnly = function(date) {
	var tmp = new Date(date);
	this.setDate(1);
	this.setFullYear(tmp.getFullYear());
	this.setMonth(tmp.getMonth());
	this.setDate(tmp.getDate());
};

/** Prints the date in a string according to the given format. */
Date.prototype.print = function (str) {
	var m = this.getMonth();
	var d = this.getDate();
	var y = this.getFullYear();
	var wn = this.getWeekNumber();
	var w = this.getDay();
	var s = {};
	var hr = this.getHours();
	var pm = (hr >= 12);
	var ir = (pm) ? (hr - 12) : hr;
	var dy = this.getDayOfYear();
	if (ir == 0)
		ir = 12;
	var min = this.getMinutes();
	var sec = this.getSeconds();
	s["%a"] = Calendar._SDN[w]; // abbreviated weekday name [FIXME: I18N]
	s["%A"] = Calendar._DN[w]; // full weekday name
	s["%b"] = Calendar._SMN[m]; // abbreviated month name [FIXME: I18N]
	s["%B"] = Calendar._MN[m]; // full month name
	// FIXME: %c : preferred date and time representation for the current locale
	s["%C"] = 1 + Math.floor(y / 100); // the century number
	s["%d"] = (d < 10) ? ("0" + d) : d; // the day of the month (range 01 to 31)
	s["%e"] = d; // the day of the month (range 1 to 31)
	// FIXME: %D : american date style: %m/%d/%y
	// FIXME: %E, %F, %G, %g, %h (man strftime)
	s["%H"] = (hr < 10) ? ("0" + hr) : hr; // hour, range 00 to 23 (24h format)
	s["%I"] = (ir < 10) ? ("0" + ir) : ir; // hour, range 01 to 12 (12h format)
	s["%j"] = (dy < 100) ? ((dy < 10) ? ("00" + dy) : ("0" + dy)) : dy; // day of the year (range 001 to 366)
	s["%k"] = hr;           // hour, range 0 to 23 (24h format)
	s["%l"] = ir;           // hour, range 1 to 12 (12h format)
	s["%m"] = (m < 9) ? ("0" + (1+m)) : (1+m); // month, range 01 to 12
	s["%M"] = (min < 10) ? ("0" + min) : min; // minute, range 00 to 59
	s["%n"] = "\n";         // a newline character
	s["%p"] = pm ? "PM" : "AM";
	s["%P"] = pm ? "pm" : "am";
	// FIXME: %r : the time in am/pm notation %I:%M:%S %p
	// FIXME: %R : the time in 24-hour notation %H:%M
	s["%s"] = Math.floor(this.getTime() / 1000);
	s["%S"] = (sec < 10) ? ("0" + sec) : sec; // seconds, range 00 to 59
	s["%t"] = "\t";         // a tab character
	// FIXME: %T : the time in 24-hour notation (%H:%M:%S)
	s["%U"] = s["%W"] = s["%V"] = (wn < 10) ? ("0" + wn) : wn;
	s["%u"] = w + 1;        // the day of the week (range 1 to 7, 1 = MON)
	s["%w"] = w;            // the day of the week (range 0 to 6, 0 = SUN)
	// FIXME: %x : preferred date representation for the current locale without the time
	// FIXME: %X : preferred time representation for the current locale without the date
	s["%y"] = ('''' + y).substr(2, 2); // year without the century (range 00 to 99)
	s["%Y"] = y;            // year with the century
	s["%%"] = "%";          // a literal ''%'' character

	var re = /%./g;
	if (!!Calendar.is_ie5 && !!Calendar.is_khtml)
		return str.replace(re, function (par) { return s[par] || par; });

	var a = str.match(re);
	for (var i = 0; i < a.length; i++) {
		var tmp = s[a[i]];
		if (tmp) {
			re = new RegExp(a[i], ''g'');
			str = str.replace(re, tmp);
		}
	}

	return str;
};

Date.prototype.__msh_oldSetFullYear = Date.prototype.setFullYear;
Date.prototype.setFullYear = function(y) {
	var d = new Date(this);
	d.__msh_oldSetFullYear(y);
	if (d.getMonth() !!= this.getMonth())
		this.setDate(28);
	this.__msh_oldSetFullYear(y);
};

// END: DATE OBJECT PATCHES


// global object that remembers the calendar
window._dynarch_popupCalendar = null;
'
!

calendarJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendar ifAbsentPut:
		[WebMethodResource
			fromMethod: #calendarJavascript on: self
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar.js' site: self site].
!

calendarLangEnglish
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangEnglish"
	^'
// ** I18N

// Calendar EN language
// Author: Mihai Bazon, <mihai_bazon@yahoo.com>
// Encoding: any
// Distributed under the same terms as the calendar itself.

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

// full day names
Calendar._DN = new Array
("Sunday",
 "Monday",
 "Tuesday",
 "Wednesday",
 "Thursday",
 "Friday",
 "Saturday",
 "Sunday");

// Please note that the following array of short day names (and the same goes
// for short month names, _SMN) isn''t absolutely necessary.  We give it here
// for exemplification on how one can customize the short day names, but if
// they are simply the first N letters of the full name you can simply say:
//
//   Calendar._SDN_len = N; // short day name length
//   Calendar._SMN_len = N; // short month name length
//
// If N = 3 then this is not needed either since we assume a value of 3 if not
// present, to be compatible with translation files that were written before
// this feature.

// short day names
Calendar._SDN = new Array
("Sun",
 "Mon",
 "Tue",
 "Wed",
 "Thu",
 "Fri",
 "Sat",
 "Sun");

// First day of the week. "0" means display Sunday first, "1" means display
// Monday first, etc.
Calendar._FD = 0;

// full month names
Calendar._MN = new Array
("January",
 "February",
 "March",
 "April",
 "May",
 "June",
 "July",
 "August",
 "September",
 "October",
 "November",
 "December");

// short month names
Calendar._SMN = new Array
("Jan",
 "Feb",
 "Mar",
 "Apr",
 "May",
 "Jun",
 "Jul",
 "Aug",
 "Sep",
 "Oct",
 "Nov",
 "Dec");

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "About the calendar";

Calendar._TT["ABOUT"] =
"DHTML Date/Time Selector\n" +
"(c) dynarch.com 2002-2005 / Author: Mihai Bazon\n" + // don''t translate this this ;-)
"For latest version visit: http://www.dynarch.com/projects/calendar/\n" +
"Distributed under GNU LGPL.  See http://gnu.org/licenses/lgpl.html for details." +
"\n\n" +
"Date selection:\n" +
"- Use the \xab, \xbb buttons to select year\n" +
"- Use the " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + " buttons to select month\n" +
"- Hold mouse button on any of the above buttons for faster selection.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Time selection:\n" +
"- Click on any of the time parts to increase it\n" +
"- or Shift-click to decrease it\n" +
"- or click and drag for faster selection.";

Calendar._TT["PREV_YEAR"] = "Prev. year (hold for menu)";
Calendar._TT["PREV_MONTH"] = "Prev. month (hold for menu)";
Calendar._TT["GO_TODAY"] = "Go Today";
Calendar._TT["NEXT_MONTH"] = "Next month (hold for menu)";
Calendar._TT["NEXT_YEAR"] = "Next year (hold for menu)";
Calendar._TT["SEL_DATE"] = "Select date";
Calendar._TT["DRAG_TO_MOVE"] = "Drag to move";
Calendar._TT["PART_TODAY"] = " (today)";

// the following is to inform that "%s" is to be the first day of week
// %s will be replaced with the day name.
Calendar._TT["DAY_FIRST"] = "Display %s first";

// This may be locale-dependent.  It specifies the week-end days, as an array
// of comma-separated numbers.  The numbers are from 0 to 6: 0 means Sunday, 1
// means Monday, etc.
Calendar._TT["WEEKEND"] = "0,6";

Calendar._TT["CLOSE"] = "Close";
Calendar._TT["TODAY"] = "Today";
Calendar._TT["TIME_PART"] = "(Shift-)Click or drag to change value";

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%Y-%m-%d";
Calendar._TT["TT_DATE_FORMAT"] = "%a, %b %e";

Calendar._TT["WK"] = "wk";
Calendar._TT["TIME"] = "Time:";
'
!

calendarLangJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangavascript"
	^self calendarLangSlovenian
!

calendarLangJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendarLang ifAbsentPut:
		[WebMethodResource
			fromMethod: #calendarLangJavascript on: self
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar-lang.js' site: self site].
!

calendarLangSlovenian
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangSlovenian"
	| text |
	text := '
/* Slovenian language file for the DHTML Calendar version 1.0
* Author David Milost <mercy@volja.net>, January 2004.
* Corrected by Janko Mivs^ek <janko.mivsek@eranova.si>, November 2005.
* Feel free to use this script under the terms of the GNU Lesser General
* Public License, as long as you do not remove or alter this notice.
*/
// ** I18N

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

 // full day names
Calendar._DN = new Array
("Nedelja",
 "Ponedeljek",
 "Torek",
 "Sreda",
 "C^etrtek",
 "Petek",
 "Sobota",
 "Nedelja");
 // short day names
 Calendar._SDN = new Array
("Ned",
 "Pon",
 "Tor",
 "Sre",
 "C^et",
 "Pet",
 "Sob",
 "Ned");
// First day of the week. "0" means display Sunday first, "1" means display
// Monday first, etc.
Calendar._FD = 1;

// short month names
Calendar._SMN = new Array
("Jan",
 "Feb",
 "Mar",
 "Apr",
 "Maj",
 "Jun",
 "Jul",
 "Avg",
 "Sep",
 "Okt",
 "Nov",
 "Dec");
  // full month names
Calendar._MN = new Array
("Januar",
 "Februar",
 "Marec",
 "April",
 "Maj",
 "Junij",
 "Julij",
 "Avgust",
 "September",
 "Oktober",
 "November",
 "December");

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "O koledarju";

Calendar._TT["ABOUT"] =
"DHTML izbira datuma in c^asa\n" +
"(c) dynarch.com 2002-2005 / Avtor: Mihai Bazon\n" + // don''t translate this this ;-)
"Zadnjo razlic^ico dobite na http://www.dynarch.com/projects/calendar/\n" +
"Licenca GNU LGPL.  Vec^ na http://gnu.org/licenses/lgpl.html." +
"\n\n" +
"Izbira datuma:\n" +
"- Za izbiro leta uporabite gumbe \xab, \xbb \n" +
"- Za izbiro meseca uporabite gumbe " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + "\n" +
"- Zadrz^ite klik mis^ke na katerem koli od zgornjih gumbov za hitrejs^o izbiro.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Izbira c^asa:\n" +
"- Kliknite na katerikoli del c^asa za povec^anje\n" +
"- ali Shift-klik za zmanjs^anje\n" +
"- ali klik in povlek za hitrejs^o izbiro.";

Calendar._TT["PREV_YEAR"] = "Predhodno leto (dolg klik za meni)";
Calendar._TT["PREV_MONTH"] = "Predhodni mesec (dolg klik za meni)";
Calendar._TT["GO_TODAY"] = "Na danes";
Calendar._TT["NEXT_MONTH"] = "Naslednji mesec (dolg klik za meni)";
Calendar._TT["NEXT_YEAR"] = "Naslednje leto (dolg klik za meni)";
Calendar._TT["SEL_DATE"] = "Izberite datum";
Calendar._TT["DRAG_TO_MOVE"] = "Povlecite za premik";
Calendar._TT["PART_TODAY"] = " (danes)";

// the following is to inform that "%s" is to be the first day of week
// %s will be replaced with the day name.
Calendar._TT["DAY_FIRST"] = "Prikaz^i %s kot prvi dan";

// This may be locale-dependent.  It specifies the week-end days, as an array
// of comma-separated numbers.  The numbers are from 0 to 6: 0 means Sunday, 1
// means Monday, etc.
Calendar._TT["WEEKEND"] = "0,6";

Calendar._TT["CLOSE"] = "Zapri";
Calendar._TT["TODAY"] = "Danes";
Calendar._TT["TIME_PART"] = "(Shift-)Klikni ali povleci za spremembo vrednosti";

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%d.%m.%Y";
Calendar._TT["TT_DATE_FORMAT"] = "%a, %e.%b";

Calendar._TT["WK"] = "ted";
Calendar._TT["TIME"] = "C^as:";
'.

	^AIDASite convert: text  convertToSloveneChars toCodepage: #'iso-8859-2'
!

calendarSetupJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJavascript"
	^'
/*  Copyright Mihai Bazon, 2002, 2003  |  http://dynarch.com/mishoo/
 * ---------------------------------------------------------------------------
 *
 * The DHTML Calendar
 *
 * Details and latest version at:
 * http://dynarch.com/mishoo/calendar.epl
 *
 * This script is distributed under the GNU Lesser General Public License.
 * Read the entire license text here: http://www.gnu.org/licenses/lgpl.html
 *
 * This file defines helper functions for setting up the calendar.  They are
 * intended to help non-programmers get a working calendar on their site
 * quickly.  This script should not be seen as part of the calendar.  It just
 * shows you what one can do with the calendar, while in the same time
 * providing a quick and simple method for setting it up.  If you need
 * exhaustive customization of the calendar creation process feel free to
 * modify this code to suit your needs (this is recommended and much better
 * than modifying calendar.js itself).
 */

// $Id: calendar-setup.js,v 1.25 2005/03/07 09:51:33 mishoo Exp $

/**
 *  This function "patches" an input field (or other element) to use a calendar
 *  widget for date selection.
 *
 *  The "params" is a single object that can have the following properties:
 *
 *    prop. name   | description
 *  -------------------------------------------------------------------------------------------------
 *   inputField    | the ID of an input field to store the date
 *   displayArea   | the ID of a DIV or other element to show the date
 *   button        | ID of a button or other element that will trigger the calendar
 *   eventName     | event that will trigger the calendar, without the "on" prefix (default: "click")
 *   ifFormat      | date format that will be stored in the input field
 *   daFormat      | the date format that will be used to display the date in displayArea
 *   singleClick   | (true/false) wether the calendar is in single click mode or not (default: true)
 *   firstDay      | numeric: 0 to 6.  "0" means display Sunday first, "1" means display Monday first, etc.
 *   align         | alignment (default: "Br"); if you don''t know what''s this see the calendar documentation
 *   range         | array with 2 elements.  Default: [1900, 2999] -- the range of years available
 *   weekNumbers   | (true/false) if it''s true (default) the calendar will display week numbers
 *   flat          | null or element ID; if not null the calendar will be a flat calendar having the parent with the given ID
 *   flatCallback  | function that receives a JS Date object and returns an URL to point the browser to (for flat calendar)
 *   disableFunc   | function that receives a JS Date object and should return true if that date has to be disabled in the calendar
 *   onSelect      | function that gets called when a date is selected.  You don''t _have_ to supply this (the default is generally okay)
 *   onClose       | function that gets called when the calendar is closed.  [default]
 *   onUpdate      | function that gets called after the date is updated in the input field.  Receives a reference to the calendar.
 *   date          | the date that the calendar will be initially displayed to
 *   showsTime     | default: false; if true the calendar will include a time selector
 *   timeFormat    | the time format; can be "12" or "24", default is "12"
 *   electric      | if true (default) then given fields/date areas are updated for each move; otherwise they''re updated only on close
 *   step          | configures the step of the years in drop-down boxes; default: 2
 *   position      | configures the calendar absolute position; default: null
 *   cache         | if "true" (but default: "false") it will reuse the same calendar object, where possible
 *   showOthers    | if "true" (but default: "false") it will show days from other months too
 *
 *  None of them is required, they all have default values.  However, if you
 *  pass none of "inputField", "displayArea" or "button" you''ll get a warning
 *  saying "nothing to setup".
 */
Calendar.setup = function (params) {
	function param_default(pname, def) { if (typeof params[pname] == "undefined") { params[pname] = def; } };

	param_default("inputField",     null);
	param_default("displayArea",    null);
	param_default("button",         null);
	param_default("eventName",      "click");
	param_default("ifFormat",       "%Y/%m/%d");
	param_default("daFormat",       "%Y/%m/%d");
	param_default("singleClick",    true);
	param_default("disableFunc",    null);
	param_default("dateStatusFunc", params["disableFunc"]); // takes precedence if both are defined
	param_default("dateText",       null);
	param_default("firstDay",       null);
	param_default("align",          "Br");
	param_default("range",          [1900, 2999]);
	param_default("weekNumbers",    true);
	param_default("flat",           null);
	param_default("flatCallback",   null);
	param_default("onSelect",       null);
	param_default("onClose",        null);
	param_default("onUpdate",       null);
	param_default("date",           null);
	param_default("showsTime",      false);
	param_default("timeFormat",     "24");
	param_default("electric",       true);
	param_default("step",           2);
	param_default("position",       null);
	param_default("cache",          false);
	param_default("showOthers",     false);
	param_default("multiple",       null);

	var tmp = ["inputField", "displayArea", "button"];
	for (var i in tmp) {
		if (typeof params[tmp[i]] == "string") {
			params[tmp[i]] = document.getElementById(params[tmp[i]]);
		}
	}
	if (!!(params.flat || params.multiple || params.inputField || params.displayArea || params.button)) {
		alert("Calendar.setup:\n  Nothing to setup (no fields found).  Please check your code");
		return false;
	}

	function onSelect(cal) {
		var p = cal.params;
		var update = (cal.dateClicked || p.electric);
		if (update && p.inputField) {
			p.inputField.value = cal.date.print(p.ifFormat);
			if (typeof p.inputField.onchange == "function")
				p.inputField.onchange();
		}
		if (update && p.displayArea)
			p.displayArea.innerHTML = cal.date.print(p.daFormat);
		if (update && typeof p.onUpdate == "function")
			p.onUpdate(cal);
		if (update && p.flat) {
			if (typeof p.flatCallback == "function")
				p.flatCallback(cal);
		}
		if (update && p.singleClick && cal.dateClicked)
			cal.callCloseHandler();
	};

	if (params.flat !!= null) {
		if (typeof params.flat == "string")
			params.flat = document.getElementById(params.flat);
		if (!!params.flat) {
			alert("Calendar.setup:\n  Flat specified but can''t find parent.");
			return false;
		}
		var cal = new Calendar(params.firstDay, params.date, params.onSelect || onSelect);
		cal.showsOtherMonths = params.showOthers;
		cal.showsTime = params.showsTime;
		cal.time24 = (params.timeFormat == "24");
		cal.params = params;
		cal.weekNumbers = params.weekNumbers;
		cal.setRange(params.range[0], params.range[1]);
		cal.setDateStatusHandler(params.dateStatusFunc);
		cal.getDateText = params.dateText;
		if (params.ifFormat) {
			cal.setDateFormat(params.ifFormat);
		}
		if (params.inputField && typeof params.inputField.value == "string") {
			cal.parseDate(params.inputField.value);
		}
		cal.create(params.flat);
		cal.show();
		return false;
	}

	var triggerEl = params.button || params.displayArea || params.inputField;
	triggerEl["on" + params.eventName] = function() {
		var dateEl = params.inputField || params.displayArea;
		var dateFmt = params.inputField ? params.ifFormat : params.daFormat;
		var mustCreate = false;
		var cal = window.calendar;
		if (dateEl)
			params.date = Date.parseDate(dateEl.value || dateEl.innerHTML, dateFmt);
		if (!!(cal && params.cache)) {
			window.calendar = cal = new Calendar(params.firstDay,
							     params.date,
							     params.onSelect || onSelect,
							     params.onClose || function(cal) { cal.hide(); });
			cal.showsTime = params.showsTime;
			cal.time24 = (params.timeFormat == "24");
			cal.weekNumbers = params.weekNumbers;
			mustCreate = true;
		} else {
			if (params.date)
				cal.setDate(params.date);
			cal.hide();
		}
		if (params.multiple) {
			cal.multiple = {};
			for (var i = params.multiple.length; --i >= 0;) {
				var d = params.multiple[i];
				var ds = d.print("%Y%m%d");
				cal.multiple[ds] = d;
			}
		}
		cal.showsOtherMonths = params.showOthers;
		cal.yearStep = params.step;
		cal.setRange(params.range[0], params.range[1]);
		cal.params = params;
		cal.setDateStatusHandler(params.dateStatusFunc);
		cal.getDateText = params.dateText;
		cal.setDateFormat(dateFmt);
		if (mustCreate)
			cal.create();
		cal.refresh();
		if (!!params.position)
			cal.showAtElement(params.button || params.displayArea || params.inputField, params.align);
		else
			cal.showAt(params.position[0], params.position[1]);
		return false;
	};

	return cal;
};
'
!

calendarSetupJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendarSetup ifAbsentPut:
		[WebMethodResource
			fromMethod: #calendarSetupJavascript on: self
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar-setup.js' site: self site].
!

ensureJavascriptAndCssForCalendarInHeader
	| page url headerValue |
	page := self app.
	url := '/jscalendar/calendar.js'.
	headerValue := ' src="', url, '" language="JavaScript" type="text/javascript"'.
	(page headers contains: [:each | each key = 'script' and: [each value = headerValue] ]) ifFalse:
		[page addLinkToScreenStyleSheet: '/jscalendar/calendar.css'.
		page addHeader: 'script' value: headerValue.
		page addLinkToJavascript: '/jscalendar/calendar-lang.js'.
		page addLinkToJavascript: '/jscalendar/calendar-setup.js'.
		].
!

ensureJsResourceForCalendarSetup
	self site urlResolver halfUrlFor: self calendarJsResource.
	self site urlResolver halfUrlFor: self calendarSetupJsResource.
	self site urlResolver halfUrlFor: self calendarLangJsResource.
	self site urlResolver halfUrlFor: self calendarCSSResource.
!

richEditorCssResource
	" for JavaScript rich text editor, see WebRichEditor"
	"WebStyle new richEditorCssResource"
	^self resources at: #cssRichEditor ifAbsentPut:
		[WebMethodResource
			fromMethod: #richEditorStyleSheet on: self
			contentType: 'text/css' preferedUrl: '/rich-editor.css' site: self site].
!

richEditorStyleSheet
	" for  text area in JavaScript rich text editor, see WebRichEditor"
	"WebStyle new richEditorStyleSheet"
	| stream |
	stream := WriteStream on: String new.
	stream nextPutAll: '
body {
	font-family: verdana, sans-serif;
	font-color: #666;
	font-size: 90%;
	background-color: #FFFFFF;
.mceVisualAid {
	border: 1px dashed #BBBBBB;
	}
'.
	#(css21Text css22Links) do: [:method |
		stream nextPut: Character cr.
		stream nextPutAll: ('/*', self class name, ' ', method asString, '*/').
		stream nextPut: Character cr.
		stream nextPutAll: (self perform: method)].
	^stream contents
! !

!WebStyle methodsFor:'scripts-scriptaculous'!

ensureJavascriptForScriptaculousInHeader
	| page url headerValue |
	page := self app.
	url := '/scriptaculous/scriptaculous.js'.
	headerValue := ' src="', url, '" language="JavaScript" type="text/javascript"'.
	(page headers contains: [:each | each key = 'script' and: [each value = headerValue] ]) ifFalse:
		[page addHeader: 'script' value: headerValue].
!

ensureJsResourceForScriptaculous
	self site urlResolver halfUrlFor: self scriptaculousJsResource.
	self site urlResolver halfUrlFor: self scriptaculousBuilderJsResource.
	self site urlResolver halfUrlFor: self scriptaculousEffectsJsResource.
	self site urlResolver halfUrlFor: self scriptaculousDragDropJsResource.
	self site urlResolver halfUrlFor: self scriptaculousControlsJsResource.
	self site urlResolver halfUrlFor: self scriptaculousSliderJsResource.
!

scriptaculousBuilderJs
	"builder.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us builder.js v1.7.0, Fri Jan 19 19:16:36 CET 2007

// Copyright (c) 2005, 2006 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

var Builder = {
  NODEMAP: {
    AREA: ''map'',
    CAPTION: ''table'',
    COL: ''table'',
    COLGROUP: ''table'',
    LEGEND: ''fieldset'',
    OPTGROUP: ''select'',
    OPTION: ''select'',
    PARAM: ''object'',
    TBODY: ''table'',
    TD: ''table'',
    TFOOT: ''table'',
    TH: ''table'',
    THEAD: ''table'',
    TR: ''table''
  },
  // note: For Firefox < 1.5, OPTION and OPTGROUP tags are currently broken,
  //       due to a Firefox bug
  node: function(elementName) {
    elementName = elementName.toUpperCase();

    // try innerHTML approach
    var parentTag = this.NODEMAP[elementName] || ''div'';
    var parentElement = document.createElement(parentTag);
    try { // prevent IE "feature": http://dev.rubyonrails.org/ticket/2707
      parentElement.innerHTML = "<" + elementName + "></" + elementName + ">";
    } catch(e) {}
    var element = parentElement.firstChild || null;

    // see if browser added wrapping tags
    if(element && (element.tagName.toUpperCase() !!= elementName))
      element = element.getElementsByTagName(elementName)[0];

    // fallback to createElement approach
    if(!!element) element = document.createElement(elementName);

    // abort if nothing could be created
    if(!!element) return;

    // attributes (or text)
    if(arguments[1])
      if(this._isStringOrNumber(arguments[1]) ||
	(arguments[1] instanceof Array)) {
	  this._children(element, arguments[1]);
	} else {
	  var attrs = this._attributes(arguments[1]);
	  if(attrs.length) {
	    try { // prevent IE "feature": http://dev.rubyonrails.org/ticket/2707
	      parentElement.innerHTML = "<" +elementName + " " +
		attrs + "></" + elementName + ">";
	    } catch(e) {}
	    element = parentElement.firstChild || null;
	    // workaround firefox 1.0.X bug
	    if(!!element) {
	      element = document.createElement(elementName);
	      for(attr in arguments[1])
		element[attr == ''class'' ? ''className'' : attr] = arguments[1][attr];
	    }
	    if(element.tagName.toUpperCase() !!= elementName)
	      element = parentElement.getElementsByTagName(elementName)[0];
	    }
	}

    // text, or array of children
    if(arguments[2])
      this._children(element, arguments[2]);

     return element;
  },
  _text: function(text) {
     return document.createTextNode(text);
  },

  ATTR_MAP: {
    ''className'': ''class'',
    ''htmlFor'': ''for''
  },

  _attributes: function(attributes) {
    var attrs = [];
    for(attribute in attributes)
      attrs.push((attribute in this.ATTR_MAP ? this.ATTR_MAP[attribute] : attribute) +
	  ''="'' + attributes[attribute].toString().escapeHTML() + ''"'');
    return attrs.join(" ");
  },
  _children: function(element, children) {
    if(typeof children==''object'') { // array can hold nodes and text
      children.flatten().each( function(e) {
	if(typeof e==''object'')
	  element.appendChild(e)
	else
	  if(Builder._isStringOrNumber(e))
	    element.appendChild(Builder._text(e));
      });
    } else
      if(Builder._isStringOrNumber(children))
	 element.appendChild(Builder._text(children));
  },
  _isStringOrNumber: function(param) {
    return(typeof param==''string'' || typeof param==''number'');
  },
  build: function(html) {
    var element = this.node(''div'');
    $(element).update(html.strip());
    return element.down();
  },
  dump: function(scope) {
    if(typeof scope !!= ''object'' && typeof scope !!= ''function'') scope = window; //global scope

    var tags = ("A ABBR ACRONYM ADDRESS APPLET AREA B BASE BASEFONT BDO BIG BLOCKQUOTE BODY " +
      "BR BUTTON CAPTION CENTER CITE CODE COL COLGROUP DD DEL DFN DIR DIV DL DT EM FIELDSET " +
      "FONT FORM FRAME FRAMESET H1 H2 H3 H4 H5 H6 HEAD HR HTML I IFRAME IMG INPUT INS ISINDEX "+
      "KBD LABEL LEGEND LI LINK MAP MENU META NOFRAMES NOSCRIPT OBJECT OL OPTGROUP OPTION P "+
      "PARAM PRE Q S SAMP SCRIPT SELECT SMALL SPAN STRIKE STRONG STYLE SUB SUP TABLE TBODY TD "+
      "TEXTAREA TFOOT TH THEAD TITLE TR TT U UL VAR").split(/\s+/);

    tags.each( function(tag){
      scope[tag] = function() {
	return Builder.node.apply(Builder, [tag].concat($A(arguments)));
      }
    });
  }
}
'
!

scriptaculousBuilderJsResource
	"WebStyle new scriptaculousBuilderJsResource"
	^self resources at: #jsScriptaculousBuilder ifAbsentPut:
		[WebMethodResource
			fromMethod: #scriptaculousBuilderJs on: self
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/builder.js' site: self site].
!

scriptaculousControlsJs
	"controls.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us controls.js v1.7.0, Fri Jan 19 19:16:36 CET 2007

// Copyright (c) 2005, 2006 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//           (c) 2005, 2006 Ivan Krstic (http://blogs.law.harvard.edu/ivan)
//           (c) 2005, 2006 Jon Tirsen (http://www.tirsen.com)
// Contributors:
//  Richard Livsey
//  Rahul Bhargava
//  Rob Wills
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

// Autocompleter.Base handles all the autocompletion functionality
// that''s independent of the data source for autocompletion. This
// includes drawing the autocompletion menu, observing keyboard
// and mouse events, and similar.
//
// Specific autocompleters need to provide, at the very least,
// a getUpdatedChoices function that will be invoked every time
// the text inside the monitored textbox changes. This method
// should get the text for which to provide autocompletion by
// invoking this.getToken(), NOT by directly accessing
// this.element.value. This is to allow incremental tokenized
// autocompletion. Specific auto-completion logic (AJAX, etc)
// belongs in getUpdatedChoices.
//
// Tokenized incremental autocompletion is enabled automatically
// when an autocompleter is instantiated with the ''tokens'' option
// in the options parameter, e.g.:
// new Ajax.Autocompleter(''id'',''upd'', ''/url/'', { tokens: '','' });
// will incrementally autocomplete with a comma as the token.
// Additionally, '','' in the above example can be replaced with
// a token array, e.g. { tokens: ['','', ''\n''] } which
// enables autocompletion on multiple tokens. This is most
// useful when one of the tokens is \n (a newline), as it
// allows smart autocompletion after linebreaks.

if(typeof Effect == ''undefined'')
  throw("controls.js requires including script.aculo.us'' effects.js library");

var Autocompleter = {}
Autocompleter.Base = function() {};
Autocompleter.Base.prototype = {
  baseInitialize: function(element, update, options) {
    this.element     = $(element);
    this.update      = $(update);
    this.hasFocus    = false;
    this.changed     = false;
    this.active      = false;
    this.index       = 0;
    this.entryCount  = 0;

    if(this.setOptions)
      this.setOptions(options);
    else
      this.options = options || {};

    this.options.paramName    = this.options.paramName || this.element.name;
    this.options.tokens       = this.options.tokens || [];
    this.options.frequency    = this.options.frequency || 0.4;
    this.options.minChars     = this.options.minChars || 1;
    this.options.onShow       = this.options.onShow ||
      function(element, update){
	if(!!update.style.position || update.style.position==''absolute'') {
	  update.style.position = ''absolute'';
	  Position.clone(element, update, {
	    setHeight: false,
	    offsetTop: element.offsetHeight
	  });
	}
	Effect.Appear(update,{duration:0.15});
      };
    this.options.onHide = this.options.onHide ||
      function(element, update){ new Effect.Fade(update,{duration:0.15}) };

    if(typeof(this.options.tokens) == ''string'')
      this.options.tokens = new Array(this.options.tokens);

    this.observer = null;

    this.element.setAttribute(''autocomplete'',''off'');

    Element.hide(this.update);

    Event.observe(this.element, "blur", this.onBlur.bindAsEventListener(this));
    Event.observe(this.element, "keypress", this.onKeyPress.bindAsEventListener(this));
  },

  show: function() {
    if(Element.getStyle(this.update, ''display'')==''none'') this.options.onShow(this.element, this.update);
    if(!!this.iefix &&
      (navigator.appVersion.indexOf(''MSIE'')>0) &&
      (navigator.userAgent.indexOf(''Opera'')<0) &&
      (Element.getStyle(this.update, ''position'')==''absolute'')) {
      new Insertion.After(this.update,
       ''<iframe id="'' + this.update.id + ''_iefix" ''+
       ''style="display:none;position:absolute;filter:progid:DXImageTransform.Microsoft.Alpha(opacity=0);" '' +
       ''src="javascript:false;" frameborder="0" scrolling="no"></iframe>'');
      this.iefix = $(this.update.id+''_iefix'');
    }
    if(this.iefix) setTimeout(this.fixIEOverlapping.bind(this), 50);
  },

  fixIEOverlapping: function() {
    Position.clone(this.update, this.iefix, {setTop:(!!this.update.style.height)});
    this.iefix.style.zIndex = 1;
    this.update.style.zIndex = 2;
    Element.show(this.iefix);
  },

  hide: function() {
    this.stopIndicator();
    if(Element.getStyle(this.update, ''display'')!!=''none'') this.options.onHide(this.element, this.update);
    if(this.iefix) Element.hide(this.iefix);
  },

  startIndicator: function() {
    if(this.options.indicator) Element.show(this.options.indicator);
  },

  stopIndicator: function() {
    if(this.options.indicator) Element.hide(this.options.indicator);
  },

  onKeyPress: function(event) {
    if(this.active)
      switch(event.keyCode) {
       case Event.KEY_TAB:
       case Event.KEY_RETURN:
	 this.selectEntry();
	 Event.stop(event);
       case Event.KEY_ESC:
	 this.hide();
	 this.active = false;
	 Event.stop(event);
	 return;
       case Event.KEY_LEFT:
       case Event.KEY_RIGHT:
	 return;
       case Event.KEY_UP:
	 this.markPrevious();
	 this.render();
	 if(navigator.appVersion.indexOf(''AppleWebKit'')>0) Event.stop(event);
	 return;
       case Event.KEY_DOWN:
	 this.markNext();
	 this.render();
	 if(navigator.appVersion.indexOf(''AppleWebKit'')>0) Event.stop(event);
	 return;
      }
     else
       if(event.keyCode==Event.KEY_TAB || event.keyCode==Event.KEY_RETURN ||
	 (navigator.appVersion.indexOf(''AppleWebKit'') > 0 && event.keyCode == 0)) return;

    this.changed = true;
    this.hasFocus = true;

    if(this.observer) clearTimeout(this.observer);
      this.observer =
	setTimeout(this.onObserverEvent.bind(this), this.options.frequency*1000);
  },

  activate: function() {
    this.changed = false;
    this.hasFocus = true;
    this.getUpdatedChoices();
  },

  onHover: function(event) {
    var element = Event.findElement(event, ''LI'');
    if(this.index !!= element.autocompleteIndex)
    {
	this.index = element.autocompleteIndex;
	this.render();
    }
    Event.stop(event);
  },

  onClick: function(event) {
    var element = Event.findElement(event, ''LI'');
    this.index = element.autocompleteIndex;
    this.selectEntry();
    this.hide();
  },

  onBlur: function(event) {
    // needed to make click events working
    setTimeout(this.hide.bind(this), 250);
    this.hasFocus = false;
    this.active = false;
  },

  render: function() {
    if(this.entryCount > 0) {
      for (var i = 0; i < this.entryCount; i++)
	this.index==i ?
	  Element.addClassName(this.getEntry(i),"selected") :
	  Element.removeClassName(this.getEntry(i),"selected");

      if(this.hasFocus) {
	this.show();
	this.active = true;
      }
    } else {
      this.active = false;
      this.hide();
    }
  },

  markPrevious: function() {
    if(this.index > 0) this.index--
      else this.index = this.entryCount-1;
    this.getEntry(this.index).scrollIntoView(true);
  },

  markNext: function() {
    if(this.index < this.entryCount-1) this.index++
      else this.index = 0;
    this.getEntry(this.index).scrollIntoView(false);
  },

  getEntry: function(index) {
    return this.update.firstChild.childNodes[index];
  },

  getCurrentEntry: function() {
    return this.getEntry(this.index);
  },

  selectEntry: function() {
    this.active = false;
    this.updateElement(this.getCurrentEntry());
  },

  updateElement: function(selectedElement) {
    if (this.options.updateElement) {
      this.options.updateElement(selectedElement);
      return;
    }
    var value = '''';
    if (this.options.select) {
      var nodes = document.getElementsByClassName(this.options.select, selectedElement) || [];
      if(nodes.length>0) value = Element.collectTextNodes(nodes[0], this.options.select);
    } else
      value = Element.collectTextNodesIgnoreClass(selectedElement, ''informal'');

    var lastTokenPos = this.findLastToken();
    if (lastTokenPos !!= -1) {
      var newValue = this.element.value.substr(0, lastTokenPos + 1);
      var whitespace = this.element.value.substr(lastTokenPos + 1).match(/^\s+/);
      if (whitespace)
	newValue += whitespace[0];
      this.element.value = newValue + value;
    } else {
      this.element.value = value;
    }
    this.element.focus();

    if (this.options.afterUpdateElement)
      this.options.afterUpdateElement(this.element, selectedElement);
  },

  updateChoices: function(choices) {
    if(!!this.changed && this.hasFocus) {
      this.update.innerHTML = choices;
      Element.cleanWhitespace(this.update);
      Element.cleanWhitespace(this.update.down());

      if(this.update.firstChild && this.update.down().childNodes) {
	this.entryCount =
	  this.update.down().childNodes.length;
	for (var i = 0; i < this.entryCount; i++) {
	  var entry = this.getEntry(i);
	  entry.autocompleteIndex = i;
	  this.addObservers(entry);
	}
      } else {
	this.entryCount = 0;
      }

      this.stopIndicator();
      this.index = 0;

      if(this.entryCount==1 && this.options.autoSelect) {
	this.selectEntry();
	this.hide();
      } else {
	this.render();
      }
    }
  },

  addObservers: function(element) {
    Event.observe(element, "mouseover", this.onHover.bindAsEventListener(this));
    Event.observe(element, "click", this.onClick.bindAsEventListener(this));
  },

  onObserverEvent: function() {
    this.changed = false;
    if(this.getToken().length>=this.options.minChars) {
      this.startIndicator();
      this.getUpdatedChoices();
    } else {
      this.active = false;
      this.hide();
    }
  },

  getToken: function() {
    var tokenPos = this.findLastToken();
    if (tokenPos !!= -1)
      var ret = this.element.value.substr(tokenPos + 1).replace(/^\s+/,'''').replace(/\s+$/,'''');
    else
      var ret = this.element.value;

    return /\n/.test(ret) ? '''' : ret;
  },

  findLastToken: function() {
    var lastTokenPos = -1;

    for (var i=0; i<this.options.tokens.length; i++) {
      var thisTokenPos = this.element.value.lastIndexOf(this.options.tokens[i]);
      if (thisTokenPos > lastTokenPos)
	lastTokenPos = thisTokenPos;
    }
    return lastTokenPos;
  }
}

Ajax.Autocompleter = Class.create();
Object.extend(Object.extend(Ajax.Autocompleter.prototype, Autocompleter.Base.prototype), {
  initialize: function(element, update, url, options) {
    this.baseInitialize(element, update, options);
    this.options.asynchronous  = true;
    this.options.onComplete    = this.onComplete.bind(this);
    this.options.defaultParams = this.options.parameters || null;
    this.url                   = url;
  },

  getUpdatedChoices: function() {
    entry = encodeURIComponent(this.options.paramName) + ''='' +
      encodeURIComponent(this.getToken());

    this.options.parameters = this.options.callback ?
      this.options.callback(this.element, entry) : entry;

    if(this.options.defaultParams)
      this.options.parameters += ''&'' + this.options.defaultParams;

    new Ajax.Request(this.url, this.options);
  },

  onComplete: function(request) {
    this.updateChoices(request.responseText);
  }

});

// The local array autocompleter. Used when you''d prefer to
// inject an array of autocompletion options into the page, rather
// than sending out Ajax queries, which can be quite slow sometimes.
//
// The constructor takes four parameters. The first two are, as usual,
// the id of the monitored textbox, and id of the autocompletion menu.
// The third is the array you want to autocomplete from, and the fourth
// is the options block.
//
// Extra local autocompletion options:
// - choices - How many autocompletion choices to offer
//
// - partialSearch - If false, the autocompleter will match entered
//                    text only at the beginning of strings in the
//                    autocomplete array. Defaults to true, which will
//                    match text at the beginning of any *word* in the
//                    strings in the autocomplete array. If you want to
//                    search anywhere in the string, additionally set
//                    the option fullSearch to true (default: off).
//
// - fullSsearch - Search anywhere in autocomplete array strings.
//
// - partialChars - How many characters to enter before triggering
//                   a partial match (unlike minChars, which defines
//                   how many characters are required to do any match
//                   at all). Defaults to 2.
//
// - ignoreCase - Whether to ignore case when autocompleting.
//                 Defaults to true.
//
// It''s possible to pass in a custom function as the ''selector''
// option, if you prefer to write your own autocompletion logic.
// In that case, the other options above will not apply unless
// you support them.

Autocompleter.Local = Class.create();
Autocompleter.Local.prototype = Object.extend(new Autocompleter.Base(), {
  initialize: function(element, update, array, options) {
    this.baseInitialize(element, update, options);
    this.options.array = array;
  },

  getUpdatedChoices: function() {
    this.updateChoices(this.options.selector(this));
  },

  setOptions: function(options) {
    this.options = Object.extend({
      choices: 10,
      partialSearch: true,
      partialChars: 2,
      ignoreCase: true,
      fullSearch: false,
      selector: function(instance) {
	var ret       = []; // Beginning matches
	var partial   = []; // Inside matches
	var entry     = instance.getToken();
	var count     = 0;

	for (var i = 0; i < instance.options.array.length &&
	  ret.length < instance.options.choices ; i++) {

	  var elem = instance.options.array[i];
	  var foundPos = instance.options.ignoreCase ?
	    elem.toLowerCase().indexOf(entry.toLowerCase()) :
	    elem.indexOf(entry);

	  while (foundPos !!= -1) {
	    if (foundPos == 0 && elem.length !!= entry.length) {
	      ret.push("<li><strong>" + elem.substr(0, entry.length) + "</strong>" +
		elem.substr(entry.length) + "</li>");
	      break;
	    } else if (entry.length >= instance.options.partialChars &&
	      instance.options.partialSearch && foundPos !!= -1) {
	      if (instance.options.fullSearch || /\s/.test(elem.substr(foundPos-1,1))) {
		partial.push("<li>" + elem.substr(0, foundPos) + "<strong>" +
		  elem.substr(foundPos, entry.length) + "</strong>" + elem.substr(
		  foundPos + entry.length) + "</li>");
		break;
	      }
	    }

	    foundPos = instance.options.ignoreCase ?
	      elem.toLowerCase().indexOf(entry.toLowerCase(), foundPos + 1) :
	      elem.indexOf(entry, foundPos + 1);

	  }
	}
	if (partial.length)
	  ret = ret.concat(partial.slice(0, instance.options.choices - ret.length))
	return "<ul>" + ret.join('''') + "</ul>";
      }
    }, options || {});
  }
});

// AJAX in-place editor
//
// see documentation on http://wiki.script.aculo.us/scriptaculous/show/Ajax.InPlaceEditor

// Use this if you notice weird scrolling problems on some browsers,
// the DOM might be a bit confused when this gets called so do this
// waits 1 ms (with setTimeout) until it does the activation
Field.scrollFreeActivate = function(field) {
  setTimeout(function() {
    Field.activate(field);
  }, 1);
}

Ajax.InPlaceEditor = Class.create();
Ajax.InPlaceEditor.defaultHighlightColor = "#FFFF99";
Ajax.InPlaceEditor.prototype = {
  initialize: function(element, url, options) {
    this.url = url;
    this.element = $(element);

    this.options = Object.extend({
      paramName: "value",
      okButton: true,
      okText: "ok",
      cancelLink: true,
      cancelText: "cancel",
      savingText: "Saving...",
      clickToEditText: "Click to edit",
      okText: "ok",
      rows: 1,
      onComplete: function(transport, element) {
	new Effect.Highlight(element, {startcolor: this.options.highlightcolor});
      },
      onFailure: function(transport) {
	alert("Error communicating with the server: " + transport.responseText.stripTags());
      },
      callback: function(form) {
	return Form.serialize(form);
      },
      handleLineBreaks: true,
      loadingText: ''Loading...'',
      savingClassName: ''inplaceeditor-saving'',
      loadingClassName: ''inplaceeditor-loading'',
      formClassName: ''inplaceeditor-form'',
      highlightcolor: Ajax.InPlaceEditor.defaultHighlightColor,
      highlightendcolor: "#FFFFFF",
      externalControl: null,
      submitOnBlur: false,
      ajaxOptions: {},
      evalScripts: false
    }, options || {});

    if(!!this.options.formId && this.element.id) {
      this.options.formId = this.element.id + "-inplaceeditor";
      if ($(this.options.formId)) {
	// there''s already a form with that name, don''t specify an id
	this.options.formId = null;
      }
    }

    if (this.options.externalControl) {
      this.options.externalControl = $(this.options.externalControl);
    }

    this.originalBackground = Element.getStyle(this.element, ''background-color'');
    if (!!this.originalBackground) {
      this.originalBackground = "transparent";
    }

    this.element.title = this.options.clickToEditText;

    this.onclickListener = this.enterEditMode.bindAsEventListener(this);
    this.mouseoverListener = this.enterHover.bindAsEventListener(this);
    this.mouseoutListener = this.leaveHover.bindAsEventListener(this);
    Event.observe(this.element, ''click'', this.onclickListener);
    Event.observe(this.element, ''mouseover'', this.mouseoverListener);
    Event.observe(this.element, ''mouseout'', this.mouseoutListener);
    if (this.options.externalControl) {
      Event.observe(this.options.externalControl, ''click'', this.onclickListener);
      Event.observe(this.options.externalControl, ''mouseover'', this.mouseoverListener);
      Event.observe(this.options.externalControl, ''mouseout'', this.mouseoutListener);
    }
  },
  enterEditMode: function(evt) {
    if (this.saving) return;
    if (this.editing) return;
    this.editing = true;
    this.onEnterEditMode();
    if (this.options.externalControl) {
      Element.hide(this.options.externalControl);
    }
    Element.hide(this.element);
    this.createForm();
    this.element.parentNode.insertBefore(this.form, this.element);
    if (!!this.options.loadTextURL) Field.scrollFreeActivate(this.editField);
    // stop the event to avoid a page refresh in Safari
    if (evt) {
      Event.stop(evt);
    }
    return false;
  },
  createForm: function() {
    this.form = document.createElement("form");
    this.form.id = this.options.formId;
    Element.addClassName(this.form, this.options.formClassName)
    this.form.onsubmit = this.onSubmit.bind(this);

    this.createEditField();

    if (this.options.textarea) {
      var br = document.createElement("br");
      this.form.appendChild(br);
    }

    if (this.options.okButton) {
      okButton = document.createElement("input");
      okButton.type = "submit";
      okButton.value = this.options.okText;
      okButton.className = ''editor_ok_button'';
      this.form.appendChild(okButton);
    }

    if (this.options.cancelLink) {
      cancelLink = document.createElement("a");
      cancelLink.href = "#";
      cancelLink.appendChild(document.createTextNode(this.options.cancelText));
      cancelLink.onclick = this.onclickCancel.bind(this);
      cancelLink.className = ''editor_cancel'';
      this.form.appendChild(cancelLink);
    }
  },
  hasHTMLLineBreaks: function(string) {
    if (!!this.options.handleLineBreaks) return false;
    return string.match(/<br/i) || string.match(/<p>/i);
  },
  convertHTMLLineBreaks: function(string) {
    return string.replace(/<br>/gi, "\n").replace(/<br\/>/gi, "\n").replace(/<\/p>/gi, "\n").replace(/<p>/gi, "");
  },
  createEditField: function() {
    var text;
    if(this.options.loadTextURL) {
      text = this.options.loadingText;
    } else {
      text = this.getText();
    }

    var obj = this;

    if (this.options.rows == 1 && !!this.hasHTMLLineBreaks(text)) {
      this.options.textarea = false;
      var textField = document.createElement("input");
      textField.obj = this;
      textField.type = "text";
      textField.name = this.options.paramName;
      textField.value = text;
      textField.style.backgroundColor = this.options.highlightcolor;
      textField.className = ''editor_field'';
      var size = this.options.size || this.options.cols || 0;
      if (size !!= 0) textField.size = size;
      if (this.options.submitOnBlur)
	textField.onblur = this.onSubmit.bind(this);
      this.editField = textField;
    } else {
      this.options.textarea = true;
      var textArea = document.createElement("textarea");
      textArea.obj = this;
      textArea.name = this.options.paramName;
      textArea.value = this.convertHTMLLineBreaks(text);
      textArea.rows = this.options.rows;
      textArea.cols = this.options.cols || 40;
      textArea.className = ''editor_field'';
      if (this.options.submitOnBlur)
	textArea.onblur = this.onSubmit.bind(this);
      this.editField = textArea;
    }

    if(this.options.loadTextURL) {
      this.loadExternalText();
    }
    this.form.appendChild(this.editField);
  },
  getText: function() {
    return this.element.innerHTML;
  },
  loadExternalText: function() {
    Element.addClassName(this.form, this.options.loadingClassName);
    this.editField.disabled = true;
    new Ajax.Request(
      this.options.loadTextURL,
      Object.extend({
	asynchronous: true,
	onComplete: this.onLoadedExternalText.bind(this)
      }, this.options.ajaxOptions)
    );
  },
  onLoadedExternalText: function(transport) {
    Element.removeClassName(this.form, this.options.loadingClassName);
    this.editField.disabled = false;
    this.editField.value = transport.responseText.stripTags();
    Field.scrollFreeActivate(this.editField);
  },
  onclickCancel: function() {
    this.onComplete();
    this.leaveEditMode();
    return false;
  },
  onFailure: function(transport) {
    this.options.onFailure(transport);
    if (this.oldInnerHTML) {
      this.element.innerHTML = this.oldInnerHTML;
      this.oldInnerHTML = null;
    }
    return false;
  },
  onSubmit: function() {
    // onLoading resets these so we need to save them away for the Ajax call
    var form = this.form;
    var value = this.editField.value;

    // do this first, sometimes the ajax call returns before we get a chance to switch on Saving...
    // which means this will actually switch on Saving... *after* we''ve left edit mode causing Saving...
    // to be displayed indefinitely
    this.onLoading();

    if (this.options.evalScripts) {
      new Ajax.Request(
	this.url, Object.extend({
	  parameters: this.options.callback(form, value),
	  onComplete: this.onComplete.bind(this),
	  onFailure: this.onFailure.bind(this),
	  asynchronous:true,
	  evalScripts:true
	}, this.options.ajaxOptions));
    } else  {
      new Ajax.Updater(
	{ success: this.element,
	  // don''t update on failure (this could be an option)
	  failure: null },
	this.url, Object.extend({
	  parameters: this.options.callback(form, value),
	  onComplete: this.onComplete.bind(this),
	  onFailure: this.onFailure.bind(this)
	}, this.options.ajaxOptions));
    }
    // stop the event to avoid a page refresh in Safari
    if (arguments.length > 1) {
      Event.stop(arguments[0]);
    }
    return false;
  },
  onLoading: function() {
    this.saving = true;
    this.removeForm();
    this.leaveHover();
    this.showSaving();
  },
  showSaving: function() {
    this.oldInnerHTML = this.element.innerHTML;
    this.element.innerHTML = this.options.savingText;
    Element.addClassName(this.element, this.options.savingClassName);
    this.element.style.backgroundColor = this.originalBackground;
    Element.show(this.element);
  },
  removeForm: function() {
    if(this.form) {
      if (this.form.parentNode) Element.remove(this.form);
      this.form = null;
    }
  },
  enterHover: function() {
    if (this.saving) return;
    this.element.style.backgroundColor = this.options.highlightcolor;
    if (this.effect) {
      this.effect.cancel();
    }
    Element.addClassName(this.element, this.options.hoverClassName)
  },
  leaveHover: function() {
    if (this.options.backgroundColor) {
      this.element.style.backgroundColor = this.oldBackground;
    }
    Element.removeClassName(this.element, this.options.hoverClassName)
    if (this.saving) return;
    this.effect = new Effect.Highlight(this.element, {
      startcolor: this.options.highlightcolor,
      endcolor: this.options.highlightendcolor,
      restorecolor: this.originalBackground
    });
  },
  leaveEditMode: function() {
    Element.removeClassName(this.element, this.options.savingClassName);
    this.removeForm();
    this.leaveHover();
    this.element.style.backgroundColor = this.originalBackground;
    Element.show(this.element);
    if (this.options.externalControl) {
      Element.show(this.options.externalControl);
    }
    this.editing = false;
    this.saving = false;
    this.oldInnerHTML = null;
    this.onLeaveEditMode();
  },
  onComplete: function(transport) {
    this.leaveEditMode();
    this.options.onComplete.bind(this)(transport, this.element);
  },
  onEnterEditMode: function() {},
  onLeaveEditMode: function() {},
  dispose: function() {
    if (this.oldInnerHTML) {
      this.element.innerHTML = this.oldInnerHTML;
    }
    this.leaveEditMode();
    Event.stopObserving(this.element, ''click'', this.onclickListener);
    Event.stopObserving(this.element, ''mouseover'', this.mouseoverListener);
    Event.stopObserving(this.element, ''mouseout'', this.mouseoutListener);
    if (this.options.externalControl) {
      Event.stopObserving(this.options.externalControl, ''click'', this.onclickListener);
      Event.stopObserving(this.options.externalControl, ''mouseover'', this.mouseoverListener);
      Event.stopObserving(this.options.externalControl, ''mouseout'', this.mouseoutListener);
    }
  }
};

Ajax.InPlaceCollectionEditor = Class.create();
Object.extend(Ajax.InPlaceCollectionEditor.prototype, Ajax.InPlaceEditor.prototype);
Object.extend(Ajax.InPlaceCollectionEditor.prototype, {
  createEditField: function() {
    if (!!this.cached_selectTag) {
      var selectTag = document.createElement("select");
      var collection = this.options.collection || [];
      var optionTag;
      collection.each(function(e,i) {
	optionTag = document.createElement("option");
	optionTag.value = (e instanceof Array) ? e[0] : e;
	if((typeof this.options.value == ''undefined'') &&
	  ((e instanceof Array) ? this.element.innerHTML == e[1] : e == optionTag.value)) optionTag.selected = true;
	if(this.options.value==optionTag.value) optionTag.selected = true;
	optionTag.appendChild(document.createTextNode((e instanceof Array) ? e[1] : e));
	selectTag.appendChild(optionTag);
      }.bind(this));
      this.cached_selectTag = selectTag;
    }

    this.editField = this.cached_selectTag;
    if(this.options.loadTextURL) this.loadExternalText();
    this.form.appendChild(this.editField);
    this.options.callback = function(form, value) {
      return "value=" + encodeURIComponent(value);
    }
  }
});

// Delayed observer, like Form.Element.Observer,
// but waits for delay after last key input
// Ideal for live-search fields

Form.Element.DelayedObserver = Class.create();
Form.Element.DelayedObserver.prototype = {
  initialize: function(element, delay, callback) {
    this.delay     = delay || 0.5;
    this.element   = $(element);
    this.callback  = callback;
    this.timer     = null;
    this.lastValue = $F(this.element);
    Event.observe(this.element,''keyup'',this.delayedListener.bindAsEventListener(this));
  },
  delayedListener: function(event) {
    if(this.lastValue == $F(this.element)) return;
    if(this.timer) clearTimeout(this.timer);
    this.timer = setTimeout(this.onTimerEvent.bind(this), this.delay * 1000);
    this.lastValue = $F(this.element);
  },
  onTimerEvent: function() {
    this.timer = null;
    this.callback(this.element, $F(this.element));
  }
};
'
!

scriptaculousControlsJsResource
	"WebStyle new scriptaculousControlsJsResource"
	^self resources at: #jsScriptaculousControls ifAbsentPut:
		[WebMethodResource
			fromMethod: #scriptaculousControlsJs on: self
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/controls.js' site: self site].
!

scriptaculousDragDropJs
	"dragdrop.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us dragdrop.js v1.7.0, Fri Jan 19 19:16:36 CET 2007

// Copyright (c) 2005, 2006 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//           (c) 2005, 2006 Sammi Williams (http://www.oriontransfer.co.nz, sammi@oriontransfer.co.nz)
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

if(typeof Effect == ''undefined'')
  throw("dragdrop.js requires including script.aculo.us'' effects.js library");

var Droppables = {
  drops: [],

  remove: function(element) {
    this.drops = this.drops.reject(function(d) { return d.element==$(element) });
  },

  add: function(element) {
    element = $(element);
    var options = Object.extend({
      greedy:     true,
      hoverclass: null,
      tree:       false
    }, arguments[1] || {});

    // cache containers
    if(options.containment) {
      options._containers = [];
      var containment = options.containment;
      if((typeof containment == ''object'') &&
	(containment.constructor == Array)) {
	containment.each( function(c) { options._containers.push($(c)) });
      } else {
	options._containers.push($(containment));
      }
    }

    if(options.accept) options.accept = [options.accept].flatten();

    Element.makePositioned(element); // fix IE
    options.element = element;

    this.drops.push(options);
  },

  findDeepestChild: function(drops) {
    deepest = drops[0];

    for (i = 1; i < drops.length; ++i)
      if (Element.isParent(drops[i].element, deepest.element))
	deepest = drops[i];

    return deepest;
  },

  isContained: function(element, drop) {
    var containmentNode;
    if(drop.tree) {
      containmentNode = element.treeNode;
    } else {
      containmentNode = element.parentNode;
    }
    return drop._containers.detect(function(c) { return containmentNode == c });
  },

  isAffected: function(point, element, drop) {
    return (
      (drop.element!!=element) &&
      ((!!drop._containers) ||
	this.isContained(element, drop)) &&
      ((!!drop.accept) ||
	(Element.classNames(element).detect(
	  function(v) { return drop.accept.include(v) } ) )) &&
      Position.within(drop.element, point[0], point[1]) );
  },

  deactivate: function(drop) {
    if(drop.hoverclass)
      Element.removeClassName(drop.element, drop.hoverclass);
    this.last_active = null;
  },

  activate: function(drop) {
    if(drop.hoverclass)
      Element.addClassName(drop.element, drop.hoverclass);
    this.last_active = drop;
  },

  show: function(point, element) {
    if(!!this.drops.length) return;
    var affected = [];

    if(this.last_active) this.deactivate(this.last_active);
    this.drops.each( function(drop) {
      if(Droppables.isAffected(point, element, drop))
	affected.push(drop);
    });

    if(affected.length>0) {
      drop = Droppables.findDeepestChild(affected);
      Position.within(drop.element, point[0], point[1]);
      if(drop.onHover)
	drop.onHover(element, drop.element, Position.overlap(drop.overlap, drop.element));

      Droppables.activate(drop);
    }
  },

  fire: function(event, element) {
    if(!!this.last_active) return;
    Position.prepare();

    if (this.isAffected([Event.pointerX(event), Event.pointerY(event)], element, this.last_active))
      if (this.last_active.onDrop)
	this.last_active.onDrop(element, this.last_active.element, event);
  },

  reset: function() {
    if(this.last_active)
      this.deactivate(this.last_active);
  }
}

var Draggables = {
  drags: [],
  observers: [],

  register: function(draggable) {
    if(this.drags.length == 0) {
      this.eventMouseUp   = this.endDrag.bindAsEventListener(this);
      this.eventMouseMove = this.updateDrag.bindAsEventListener(this);
      this.eventKeypress  = this.keyPress.bindAsEventListener(this);

      Event.observe(document, "mouseup", this.eventMouseUp);
      Event.observe(document, "mousemove", this.eventMouseMove);
      Event.observe(document, "keypress", this.eventKeypress);
    }
    this.drags.push(draggable);
  },

  unregister: function(draggable) {
    this.drags = this.drags.reject(function(d) { return d==draggable });
    if(this.drags.length == 0) {
      Event.stopObserving(document, "mouseup", this.eventMouseUp);
      Event.stopObserving(document, "mousemove", this.eventMouseMove);
      Event.stopObserving(document, "keypress", this.eventKeypress);
    }
  },

  activate: function(draggable) {
    if(draggable.options.delay) {
      this._timeout = setTimeout(function() {
	Draggables._timeout = null;
	window.focus();
	Draggables.activeDraggable = draggable;
      }.bind(this), draggable.options.delay);
    } else {
      window.focus(); // allows keypress events if window isn''t currently focused, fails for Safari
      this.activeDraggable = draggable;
    }
  },

  deactivate: function() {
    this.activeDraggable = null;
  },

  updateDrag: function(event) {
    if(!!this.activeDraggable) return;
    var pointer = [Event.pointerX(event), Event.pointerY(event)];
    // Mozilla-based browsers fire successive mousemove events with
    // the same coordinates, prevent needless redrawing (moz bug?)
    if(this._lastPointer && (this._lastPointer.inspect() == pointer.inspect())) return;
    this._lastPointer = pointer;

    this.activeDraggable.updateDrag(event, pointer);
  },

  endDrag: function(event) {
    if(this._timeout) {
      clearTimeout(this._timeout);
      this._timeout = null;
    }
    if(!!this.activeDraggable) return;
    this._lastPointer = null;
    this.activeDraggable.endDrag(event);
    this.activeDraggable = null;
  },

  keyPress: function(event) {
    if(this.activeDraggable)
      this.activeDraggable.keyPress(event);
  },

  addObserver: function(observer) {
    this.observers.push(observer);
    this._cacheObserverCallbacks();
  },

  removeObserver: function(element) {  // element instead of observer fixes mem leaks
    this.observers = this.observers.reject( function(o) { return o.element==element });
    this._cacheObserverCallbacks();
  },

  notify: function(eventName, draggable, event) {  // ''onStart'', ''onEnd'', ''onDrag''
    if(this[eventName+''Count''] > 0)
      this.observers.each( function(o) {
	if(o[eventName]) o[eventName](eventName, draggable, event);
      });
    if(draggable.options[eventName]) draggable.options[eventName](draggable, event);
  },

  _cacheObserverCallbacks: function() {
    [''onStart'',''onEnd'',''onDrag''].each( function(eventName) {
      Draggables[eventName+''Count''] = Draggables.observers.select(
	function(o) { return o[eventName]; }
      ).length;
    });
  }
}

/*--------------------------------------------------------------------------*/

var Draggable = Class.create();
Draggable._dragging    = {};

Draggable.prototype = {
  initialize: function(element) {
    var defaults = {
      handle: false,
      reverteffect: function(element, top_offset, left_offset) {
	var dur = Math.sqrt(Math.abs(top_offset^2)+Math.abs(left_offset^2))*0.02;
	new Effect.Move(element, { x: -left_offset, y: -top_offset, duration: dur,
	  queue: {scope:''_draggable'', position:''end''}
	});
      },
      endeffect: function(element) {
	var toOpacity = typeof element._opacity == ''number'' ? element._opacity : 1.0;
	new Effect.Opacity(element, {duration:0.2, from:0.7, to:toOpacity,
	  queue: {scope:''_draggable'', position:''end''},
	  afterFinish: function(){
	    Draggable._dragging[element] = false
	  }
	});
      },
      zindex: 1000,
      revert: false,
      scroll: false,
      scrollSensitivity: 20,
      scrollSpeed: 15,
      snap: false,  // false, or xy or [x,y] or function(x,y){ return [x,y] }
      delay: 0
    };

    if(!!arguments[1] || typeof arguments[1].endeffect == ''undefined'')
      Object.extend(defaults, {
	starteffect: function(element) {
	  element._opacity = Element.getOpacity(element);
	  Draggable._dragging[element] = true;
	  new Effect.Opacity(element, {duration:0.2, from:element._opacity, to:0.7});
	}
      });

    var options = Object.extend(defaults, arguments[1] || {});

    this.element = $(element);

    if(options.handle && (typeof options.handle == ''string''))
      this.handle = this.element.down(''.''+options.handle, 0);

    if(!!this.handle) this.handle = $(options.handle);
    if(!!this.handle) this.handle = this.element;

    if(options.scroll && !!options.scroll.scrollTo && !!options.scroll.outerHTML) {
      options.scroll = $(options.scroll);
      this._isScrollChild = Element.childOf(this.element, options.scroll);
    }

    Element.makePositioned(this.element); // fix IE

    this.delta    = this.currentDelta();
    this.options  = options;
    this.dragging = false;

    this.eventMouseDown = this.initDrag.bindAsEventListener(this);
    Event.observe(this.handle, "mousedown", this.eventMouseDown);

    Draggables.register(this);
  },

  destroy: function() {
    Event.stopObserving(this.handle, "mousedown", this.eventMouseDown);
    Draggables.unregister(this);
  },

  currentDelta: function() {
    return([
      parseInt(Element.getStyle(this.element,''left'') || ''0''),
      parseInt(Element.getStyle(this.element,''top'') || ''0'')]);
  },

  initDrag: function(event) {
    if(typeof Draggable._dragging[this.element] !!= ''undefined'' &&
      Draggable._dragging[this.element]) return;
    if(Event.isLeftClick(event)) {
      // abort on form elements, fixes a Firefox issue
      var src = Event.element(event);
      if((tag_name = src.tagName.toUpperCase()) && (
	tag_name==''INPUT'' ||
	tag_name==''SELECT'' ||
	tag_name==''OPTION'' ||
	tag_name==''BUTTON'' ||
	tag_name==''TEXTAREA'')) return;

      var pointer = [Event.pointerX(event), Event.pointerY(event)];
      var pos     = Position.cumulativeOffset(this.element);
      this.offset = [0,1].map( function(i) { return (pointer[i] - pos[i]) });

      Draggables.activate(this);
      Event.stop(event);
    }
  },

  startDrag: function(event) {
    this.dragging = true;

    if(this.options.zindex) {
      this.originalZ = parseInt(Element.getStyle(this.element,''z-index'') || 0);
      this.element.style.zIndex = this.options.zindex;
    }

    if(this.options.ghosting) {
      this._clone = this.element.cloneNode(true);
      Position.absolutize(this.element);
      this.element.parentNode.insertBefore(this._clone, this.element);
    }

    if(this.options.scroll) {
      if (this.options.scroll == window) {
	var where = this._getWindowScroll(this.options.scroll);
	this.originalScrollLeft = where.left;
	this.originalScrollTop = where.top;
      } else {
	this.originalScrollLeft = this.options.scroll.scrollLeft;
	this.originalScrollTop = this.options.scroll.scrollTop;
      }
    }

    Draggables.notify(''onStart'', this, event);

    if(this.options.starteffect) this.options.starteffect(this.element);
  },

  updateDrag: function(event, pointer) {
    if(!!this.dragging) this.startDrag(event);
    Position.prepare();
    Droppables.show(pointer, this.element);
    Draggables.notify(''onDrag'', this, event);

    this.draw(pointer);
    if(this.options.change) this.options.change(this);

    if(this.options.scroll) {
      this.stopScrolling();

      var p;
      if (this.options.scroll == window) {
	with(this._getWindowScroll(this.options.scroll)) { p = [ left, top, left+width, top+height ]; }
      } else {
	p = Position.page(this.options.scroll);
	p[0] += this.options.scroll.scrollLeft + Position.deltaX;
	p[1] += this.options.scroll.scrollTop + Position.deltaY;
	p.push(p[0]+this.options.scroll.offsetWidth);
	p.push(p[1]+this.options.scroll.offsetHeight);
      }
      var speed = [0,0];
      if(pointer[0] < (p[0]+this.options.scrollSensitivity)) speed[0] = pointer[0]-(p[0]+this.options.scrollSensitivity);
      if(pointer[1] < (p[1]+this.options.scrollSensitivity)) speed[1] = pointer[1]-(p[1]+this.options.scrollSensitivity);
      if(pointer[0] > (p[2]-this.options.scrollSensitivity)) speed[0] = pointer[0]-(p[2]-this.options.scrollSensitivity);
      if(pointer[1] > (p[3]-this.options.scrollSensitivity)) speed[1] = pointer[1]-(p[3]-this.options.scrollSensitivity);
      this.startScrolling(speed);
    }

    // fix AppleWebKit rendering
    if(navigator.appVersion.indexOf(''AppleWebKit'')>0) window.scrollBy(0,0);

    Event.stop(event);
  },

  finishDrag: function(event, success) {
    this.dragging = false;

    if(this.options.ghosting) {
      Position.relativize(this.element);
      Element.remove(this._clone);
      this._clone = null;
    }

    if(success) Droppables.fire(event, this.element);
    Draggables.notify(''onEnd'', this, event);

    var revert = this.options.revert;
    if(revert && typeof revert == ''function'') revert = revert(this.element);

    var d = this.currentDelta();
    if(revert && this.options.reverteffect) {
      this.options.reverteffect(this.element,
	d[1]-this.delta[1], d[0]-this.delta[0]);
    } else {
      this.delta = d;
    }

    if(this.options.zindex)
      this.element.style.zIndex = this.originalZ;

    if(this.options.endeffect)
      this.options.endeffect(this.element);

    Draggables.deactivate(this);
    Droppables.reset();
  },

  keyPress: function(event) {
    if(event.keyCode!!=Event.KEY_ESC) return;
    this.finishDrag(event, false);
    Event.stop(event);
  },

  endDrag: function(event) {
    if(!!this.dragging) return;
    this.stopScrolling();
    this.finishDrag(event, true);
    Event.stop(event);
  },

  draw: function(point) {
    var pos = Position.cumulativeOffset(this.element);
    if(this.options.ghosting) {
      var r   = Position.realOffset(this.element);
      pos[0] += r[0] - Position.deltaX; pos[1] += r[1] - Position.deltaY;
    }

    var d = this.currentDelta();
    pos[0] -= d[0]; pos[1] -= d[1];

    if(this.options.scroll && (this.options.scroll !!= window && this._isScrollChild)) {
      pos[0] -= this.options.scroll.scrollLeft-this.originalScrollLeft;
      pos[1] -= this.options.scroll.scrollTop-this.originalScrollTop;
    }

    var p = [0,1].map(function(i){
      return (point[i]-pos[i]-this.offset[i])
    }.bind(this));

    if(this.options.snap) {
      if(typeof this.options.snap == ''function'') {
	p = this.options.snap(p[0],p[1],this);
      } else {
      if(this.options.snap instanceof Array) {
	p = p.map( function(v, i) {
	  return Math.round(v/this.options.snap[i])*this.options.snap[i] }.bind(this))
      } else {
	p = p.map( function(v) {
	  return Math.round(v/this.options.snap)*this.options.snap }.bind(this))
      }
    }}

    var style = this.element.style;
    if((!!this.options.constraint) || (this.options.constraint==''horizontal''))
      style.left = p[0] + "px";
    if((!!this.options.constraint) || (this.options.constraint==''vertical''))
      style.top  = p[1] + "px";

    if(style.visibility=="hidden") style.visibility = ""; // fix gecko rendering
  },

  stopScrolling: function() {
    if(this.scrollInterval) {
      clearInterval(this.scrollInterval);
      this.scrollInterval = null;
      Draggables._lastScrollPointer = null;
    }
  },

  startScrolling: function(speed) {
    if(!!(speed[0] || speed[1])) return;
    this.scrollSpeed = [speed[0]*this.options.scrollSpeed,speed[1]*this.options.scrollSpeed];
    this.lastScrolled = new Date();
    this.scrollInterval = setInterval(this.scroll.bind(this), 10);
  },

  scroll: function() {
    var current = new Date();
    var delta = current - this.lastScrolled;
    this.lastScrolled = current;
    if(this.options.scroll == window) {
      with (this._getWindowScroll(this.options.scroll)) {
	if (this.scrollSpeed[0] || this.scrollSpeed[1]) {
	  var d = delta / 1000;
	  this.options.scroll.scrollTo( left + d*this.scrollSpeed[0], top + d*this.scrollSpeed[1] );
	}
      }
    } else {
      this.options.scroll.scrollLeft += this.scrollSpeed[0] * delta / 1000;
      this.options.scroll.scrollTop  += this.scrollSpeed[1] * delta / 1000;
    }

    Position.prepare();
    Droppables.show(Draggables._lastPointer, this.element);
    Draggables.notify(''onDrag'', this);
    if (this._isScrollChild) {
      Draggables._lastScrollPointer = Draggables._lastScrollPointer || $A(Draggables._lastPointer);
      Draggables._lastScrollPointer[0] += this.scrollSpeed[0] * delta / 1000;
      Draggables._lastScrollPointer[1] += this.scrollSpeed[1] * delta / 1000;
      if (Draggables._lastScrollPointer[0] < 0)
	Draggables._lastScrollPointer[0] = 0;
      if (Draggables._lastScrollPointer[1] < 0)
	Draggables._lastScrollPointer[1] = 0;
      this.draw(Draggables._lastScrollPointer);
    }

    if(this.options.change) this.options.change(this);
  },

  _getWindowScroll: function(w) {
    var T, L, W, H;
    with (w.document) {
      if (w.document.documentElement && documentElement.scrollTop) {
	T = documentElement.scrollTop;
	L = documentElement.scrollLeft;
      } else if (w.document.body) {
	T = body.scrollTop;
	L = body.scrollLeft;
      }
      if (w.innerWidth) {
	W = w.innerWidth;
	H = w.innerHeight;
      } else if (w.document.documentElement && documentElement.clientWidth) {
	W = documentElement.clientWidth;
	H = documentElement.clientHeight;
      } else {
	W = body.offsetWidth;
	H = body.offsetHeight
      }
    }
    return { top: T, left: L, width: W, height: H };
  }
}

/*--------------------------------------------------------------------------*/

var SortableObserver = Class.create();
SortableObserver.prototype = {
  initialize: function(element, observer) {
    this.element   = $(element);
    this.observer  = observer;
    this.lastValue = Sortable.serialize(this.element);
  },

  onStart: function() {
    this.lastValue = Sortable.serialize(this.element);
  },

  onEnd: function() {
    Sortable.unmark();
    if(this.lastValue !!= Sortable.serialize(this.element))
      this.observer(this.element)
  }
}

var Sortable = {
  SERIALIZE_RULE: /^[^_\-](?:[A-Za-z0-9\-\_]*)[_](.*)$/,

  sortables: {},

  _findRootElement: function(element) {
    while (element.tagName.toUpperCase() !!= "BODY") {
      if(element.id && Sortable.sortables[element.id]) return element;
      element = element.parentNode;
    }
  },

  options: function(element) {
    element = Sortable._findRootElement($(element));
    if(!!element) return;
    return Sortable.sortables[element.id];
  },

  destroy: function(element){
    var s = Sortable.options(element);

    if(s) {
      Draggables.removeObserver(s.element);
      s.droppables.each(function(d){ Droppables.remove(d) });
      s.draggables.invoke(''destroy'');

      delete Sortable.sortables[s.element.id];
    }
  },

  create: function(element) {
    element = $(element);
    var options = Object.extend({
      element:     element,
      tag:         ''li'',       // assumes li children, override with tag: ''tagname''
      dropOnEmpty: false,
      tree:        false,
      treeTag:     ''ul'',
      overlap:     ''vertical'', // one of ''vertical'', ''horizontal''
      constraint:  ''vertical'', // one of ''vertical'', ''horizontal'', false
      containment: element,    // also takes array of elements (or id''s); or false
      handle:      false,      // or a CSS class
      only:        false,
      delay:       0,
      hoverclass:  null,
      ghosting:    false,
      scroll:      false,
      scrollSensitivity: 20,
      scrollSpeed: 15,
      format:      this.SERIALIZE_RULE,
      onChange:    Prototype.emptyFunction,
      onUpdate:    Prototype.emptyFunction
    }, arguments[1] || {});

    // clear any old sortable with same element
    this.destroy(element);

    // build options for the draggables
    var options_for_draggable = {
      revert:      true,
      scroll:      options.scroll,
      scrollSpeed: options.scrollSpeed,
      scrollSensitivity: options.scrollSensitivity,
      delay:       options.delay,
      ghosting:    options.ghosting,
      constraint:  options.constraint,
      handle:      options.handle };

    if(options.starteffect)
      options_for_draggable.starteffect = options.starteffect;

    if(options.reverteffect)
      options_for_draggable.reverteffect = options.reverteffect;
    else
      if(options.ghosting) options_for_draggable.reverteffect = function(element) {
	element.style.top  = 0;
	element.style.left = 0;
      };

    if(options.endeffect)
      options_for_draggable.endeffect = options.endeffect;

    if(options.zindex)
      options_for_draggable.zindex = options.zindex;

    // build options for the droppables
    var options_for_droppable = {
      overlap:     options.overlap,
      containment: options.containment,
      tree:        options.tree,
      hoverclass:  options.hoverclass,
      onHover:     Sortable.onHover
    }

    var options_for_tree = {
      onHover:      Sortable.onEmptyHover,
      overlap:      options.overlap,
      containment:  options.containment,
      hoverclass:   options.hoverclass
    }

    // fix for gecko engine
    Element.cleanWhitespace(element);

    options.draggables = [];
    options.droppables = [];

    // drop on empty handling
    if(options.dropOnEmpty || options.tree) {
      Droppables.add(element, options_for_tree);
      options.droppables.push(element);
    }

    (this.findElements(element, options) || []).each( function(e) {
      // handles are per-draggable
      var handle = options.handle ?
	$(e).down(''.''+options.handle,0) : e;
      options.draggables.push(
	new Draggable(e, Object.extend(options_for_draggable, { handle: handle })));
      Droppables.add(e, options_for_droppable);
      if(options.tree) e.treeNode = element;
      options.droppables.push(e);
    });

    if(options.tree) {
      (Sortable.findTreeElements(element, options) || []).each( function(e) {
	Droppables.add(e, options_for_tree);
	e.treeNode = element;
	options.droppables.push(e);
      });
    }

    // keep reference
    this.sortables[element.id] = options;

    // for onupdate
    Draggables.addObserver(new SortableObserver(element, options.onUpdate));

  },

  // return all suitable-for-sortable elements in a guaranteed order
  findElements: function(element, options) {
    return Element.findChildren(
      element, options.only, options.tree ? true : false, options.tag);
  },

  findTreeElements: function(element, options) {
    return Element.findChildren(
      element, options.only, options.tree ? true : false, options.treeTag);
  },

  onHover: function(element, dropon, overlap) {
    if(Element.isParent(dropon, element)) return;

    if(overlap > .33 && overlap < .66 && Sortable.options(dropon).tree) {
      return;
    } else if(overlap>0.5) {
      Sortable.mark(dropon, ''before'');
      if(dropon.previousSibling !!= element) {
	var oldParentNode = element.parentNode;
	element.style.visibility = "hidden"; // fix gecko rendering
	dropon.parentNode.insertBefore(element, dropon);
	if(dropon.parentNode!!=oldParentNode)
	  Sortable.options(oldParentNode).onChange(element);
	Sortable.options(dropon.parentNode).onChange(element);
      }
    } else {
      Sortable.mark(dropon, ''after'');
      var nextElement = dropon.nextSibling || null;
      if(nextElement !!= element) {
	var oldParentNode = element.parentNode;
	element.style.visibility = "hidden"; // fix gecko rendering
	dropon.parentNode.insertBefore(element, nextElement);
	if(dropon.parentNode!!=oldParentNode)
	  Sortable.options(oldParentNode).onChange(element);
	Sortable.options(dropon.parentNode).onChange(element);
      }
    }
  },

  onEmptyHover: function(element, dropon, overlap) {
    var oldParentNode = element.parentNode;
    var droponOptions = Sortable.options(dropon);

    if(!!Element.isParent(dropon, element)) {
      var index;

      var children = Sortable.findElements(dropon, {tag: droponOptions.tag, only: droponOptions.only});
      var child = null;

      if(children) {
	var offset = Element.offsetSize(dropon, droponOptions.overlap) * (1.0 - overlap);

	for (index = 0; index < children.length; index += 1) {
	  if (offset - Element.offsetSize (children[index], droponOptions.overlap) >= 0) {
	    offset -= Element.offsetSize (children[index], droponOptions.overlap);
	  } else if (offset - (Element.offsetSize (children[index], droponOptions.overlap) / 2) >= 0) {
	    child = index + 1 < children.length ? children[index + 1] : null;
	    break;
	  } else {
	    child = children[index];
	    break;
	  }
	}
      }

      dropon.insertBefore(element, child);

      Sortable.options(oldParentNode).onChange(element);
      droponOptions.onChange(element);
    }
  },

  unmark: function() {
    if(Sortable._marker) Sortable._marker.hide();
  },

  mark: function(dropon, position) {
    // mark on ghosting only
    var sortable = Sortable.options(dropon.parentNode);
    if(sortable && !!sortable.ghosting) return;

    if(!!Sortable._marker) {
      Sortable._marker =
	($(''dropmarker'') || Element.extend(document.createElement(''DIV''))).
	  hide().addClassName(''dropmarker'').setStyle({position:''absolute''});
      document.getElementsByTagName("body").item(0).appendChild(Sortable._marker);
    }
    var offsets = Position.cumulativeOffset(dropon);
    Sortable._marker.setStyle({left: offsets[0]+''px'', top: offsets[1] + ''px''});

    if(position==''after'')
      if(sortable.overlap == ''horizontal'')
	Sortable._marker.setStyle({left: (offsets[0]+dropon.clientWidth) + ''px''});
      else
	Sortable._marker.setStyle({top: (offsets[1]+dropon.clientHeight) + ''px''});

    Sortable._marker.show();
  },

  _tree: function(element, options, parent) {
    var children = Sortable.findElements(element, options) || [];

    for (var i = 0; i < children.length; ++i) {
      var match = children[i].id.match(options.format);

      if (!!match) continue;

      var child = {
	id: encodeURIComponent(match ? match[1] : null),
	element: element,
	parent: parent,
	children: [],
	position: parent.children.length,
	container: $(children[i]).down(options.treeTag)
      }

      /* Get the element containing the children and recurse over it */
      if (child.container)
	this._tree(child.container, options, child)

      parent.children.push (child);
    }

    return parent;
  },

  tree: function(element) {
    element = $(element);
    var sortableOptions = this.options(element);
    var options = Object.extend({
      tag: sortableOptions.tag,
      treeTag: sortableOptions.treeTag,
      only: sortableOptions.only,
      name: element.id,
      format: sortableOptions.format
    }, arguments[1] || {});

    var root = {
      id: null,
      parent: null,
      children: [],
      container: element,
      position: 0
    }

    return Sortable._tree(element, options, root);
  },

  /* Construct a [i] index for a particular node */
  _constructIndex: function(node) {
    var index = '''';
    do {
      if (node.id) index = ''['' + node.position + '']'' + index;
    } while ((node = node.parent) !!= null);
    return index;
  },

  sequence: function(element) {
    element = $(element);
    var options = Object.extend(this.options(element), arguments[1] || {});

    return $(this.findElements(element, options) || []).map( function(item) {
      return item.id.match(options.format) ? item.id.match(options.format)[1] : '''';
    });
  },

  setSequence: function(element, new_sequence) {
    element = $(element);
    var options = Object.extend(this.options(element), arguments[2] || {});

    var nodeMap = {};
    this.findElements(element, options).each( function(n) {
	if (n.id.match(options.format))
	    nodeMap[n.id.match(options.format)[1]] = [n, n.parentNode];
	n.parentNode.removeChild(n);
    });

    new_sequence.each(function(ident) {
      var n = nodeMap[ident];
      if (n) {
	n[1].appendChild(n[0]);
	delete nodeMap[ident];
      }
    });
  },

  serialize: function(element) {
    element = $(element);
    var options = Object.extend(Sortable.options(element), arguments[1] || {});
    var name = encodeURIComponent(
      (arguments[1] && arguments[1].name) ? arguments[1].name : element.id);

    if (options.tree) {
      return Sortable.tree(element, arguments[1]).children.map( function (item) {
	return [name + Sortable._constructIndex(item) + "[id]=" +
		encodeURIComponent(item.id)].concat(item.children.map(arguments.callee));
      }).flatten().join(''&'');
    } else {
      return Sortable.sequence(element, arguments[1]).map( function(item) {
	return name + "[]=" + encodeURIComponent(item);
      }).join(''&'');
    }
  }
}

// Returns true if child is contained within element
Element.isParent = function(child, element) {
  if (!!child.parentNode || child == element) return false;
  if (child.parentNode == element) return true;
  return Element.isParent(child.parentNode, element);
}

Element.findChildren = function(element, only, recursive, tagName) {
  if(!!element.hasChildNodes()) return null;
  tagName = tagName.toUpperCase();
  if(only) only = [only].flatten();
  var elements = [];
  $A(element.childNodes).each( function(e) {
    if(e.tagName && e.tagName.toUpperCase()==tagName &&
      (!!only || (Element.classNames(e).detect(function(v) { return only.include(v) }))))
	elements.push(e);
    if(recursive) {
      var grandchildren = Element.findChildren(e, only, recursive, tagName);
      if(grandchildren) elements.push(grandchildren);
    }
  });

  return (elements.length>0 ? elements.flatten() : []);
}

Element.offsetSize = function (element, type) {
  return element[''offset'' + ((type==''vertical'' || type==''height'') ? ''Height'' : ''Width'')];
}
'
!

scriptaculousDragDropJsResource
	"WebStyle new scriptaculousDragDropJsResource"
	^self resources at: #jsScriptaculousDragDrop ifAbsentPut:
		[WebMethodResource
			fromMethod: #scriptaculousDragDropJs on: self
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/dragdrop.js' site: self site].
!

scriptaculousEffectsJs
	"effects.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us effects.js v1.7.0, Fri Jan 19 19:16:36 CET 2007

// Copyright (c) 2005, 2006 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
// Contributors:
//  Justin Palmer (http://encytemedia.com/)
//  Mark Pilgrim (http://diveintomark.org/)
//  Martin Bialasinki
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

// converts rgb() and #xxx to #xxxxxx format,
// returns self (or first argument) if not convertable
String.prototype.parseColor = function() {
  var color = ''#'';
  if(this.slice(0,4) == ''rgb('') {
    var cols = this.slice(4,this.length-1).split('','');
    var i=0; do { color += parseInt(cols[i]).toColorPart() } while (++i<3);
  } else {
    if(this.slice(0,1) == ''#'') {
      if(this.length==4) for(var i=1;i<4;i++) color += (this.charAt(i) + this.charAt(i)).toLowerCase();
      if(this.length==7) color = this.toLowerCase();
    }
  }
  return(color.length==7 ? color : (arguments[0] || this));
}

/*--------------------------------------------------------------------------*/

Element.collectTextNodes = function(element) {
  return $A($(element).childNodes).collect( function(node) {
    return (node.nodeType==3 ? node.nodeValue :
      (node.hasChildNodes() ? Element.collectTextNodes(node) : ''''));
  }).flatten().join('''');
}

Element.collectTextNodesIgnoreClass = function(element, className) {
  return $A($(element).childNodes).collect( function(node) {
    return (node.nodeType==3 ? node.nodeValue :
      ((node.hasChildNodes() && !!Element.hasClassName(node,className)) ?
	Element.collectTextNodesIgnoreClass(node, className) : ''''));
  }).flatten().join('''');
}

Element.setContentZoom = function(element, percent) {
  element = $(element);
  element.setStyle({fontSize: (percent/100) + ''em''});
  if(navigator.appVersion.indexOf(''AppleWebKit'')>0) window.scrollBy(0,0);
  return element;
}

Element.getOpacity = function(element){
  return $(element).getStyle(''opacity'');
}

Element.setOpacity = function(element, value){
  return $(element).setStyle({opacity:value});
}

Element.getInlineOpacity = function(element){
  return $(element).style.opacity || '''';
}

Element.forceRerendering = function(element) {
  try {
    element = $(element);
    var n = document.createTextNode('' '');
    element.appendChild(n);
    element.removeChild(n);
  } catch(e) { }
};

/*--------------------------------------------------------------------------*/

Array.prototype.call = function() {
  var args = arguments;
  this.each(function(f){ f.apply(this, args) });
}

/*--------------------------------------------------------------------------*/

var Effect = {
  _elementDoesNotExistError: {
    name: ''ElementDoesNotExistError'',
    message: ''The specified DOM element does not exist, but is required for this effect to operate''
  },
  tagifyText: function(element) {
    if(typeof Builder == ''undefined'')
      throw("Effect.tagifyText requires including script.aculo.us'' builder.js library");

    var tagifyStyle = ''position:relative'';
    if(/MSIE/.test(navigator.userAgent) && !!window.opera) tagifyStyle += '';zoom:1'';

    element = $(element);
    $A(element.childNodes).each( function(child) {
      if(child.nodeType==3) {
	child.nodeValue.toArray().each( function(character) {
	  element.insertBefore(
	    Builder.node(''span'',{style: tagifyStyle},
	      character == '' '' ? String.fromCharCode(160) : character),
	      child);
	});
	Element.remove(child);
      }
    });
  },
  multiple: function(element, effect) {
    var elements;
    if(((typeof element == ''object'') ||
	(typeof element == ''function'')) &&
       (element.length))
      elements = element;
    else
      elements = $(element).childNodes;

    var options = Object.extend({
      speed: 0.1,
      delay: 0.0
    }, arguments[2] || {});
    var masterDelay = options.delay;

    $A(elements).each( function(element, index) {
      new effect(element, Object.extend(options, { delay: index * options.speed + masterDelay }));
    });
  },
  PAIRS: {
    ''slide'':  [''SlideDown'',''SlideUp''],
    ''blind'':  [''BlindDown'',''BlindUp''],
    ''appear'': [''Appear'',''Fade'']
  },
  toggle: function(element, effect) {
    element = $(element);
    effect = (effect || ''appear'').toLowerCase();
    var options = Object.extend({
      queue: { position:''end'', scope:(element.id || ''global''), limit: 1 }
    }, arguments[2] || {});
    Effect[element.visible() ?
      Effect.PAIRS[effect][1] : Effect.PAIRS[effect][0]](element, options);
  }
};

var Effect2 = Effect; // deprecated

/* ------------- transitions ------------- */

Effect.Transitions = {
  linear: Prototype.K,
  sinoidal: function(pos) {
    return (-Math.cos(pos*Math.PI)/2) + 0.5;
  },
  reverse: function(pos) {
    return 1-pos;
  },
  flicker: function(pos) {
    return ((-Math.cos(pos*Math.PI)/4) + 0.75) + Math.random()/4;
  },
  wobble: function(pos) {
    return (-Math.cos(pos*Math.PI*(9*pos))/2) + 0.5;
  },
  pulse: function(pos, pulses) {
    pulses = pulses || 5;
    return (
      Math.round((pos % (1/pulses)) * pulses) == 0 ?
	    ((pos * pulses * 2) - Math.floor(pos * pulses * 2)) :
	1 - ((pos * pulses * 2) - Math.floor(pos * pulses * 2))
      );
  },
  none: function(pos) {
    return 0;
  },
  full: function(pos) {
    return 1;
  }
};

/* ------------- core effects ------------- */

Effect.ScopedQueue = Class.create();
Object.extend(Object.extend(Effect.ScopedQueue.prototype, Enumerable), {
  initialize: function() {
    this.effects  = [];
    this.interval = null;
  },
  _each: function(iterator) {
    this.effects._each(iterator);
  },
  add: function(effect) {
    var timestamp = new Date().getTime();

    var position = (typeof effect.options.queue == ''string'') ?
      effect.options.queue : effect.options.queue.position;

    switch(position) {
      case ''front'':
	// move unstarted effects after this effect
	this.effects.findAll(function(e){ return e.state==''idle'' }).each( function(e) {
	    e.startOn  += effect.finishOn;
	    e.finishOn += effect.finishOn;
	  });
	break;
      case ''with-last'':
	timestamp = this.effects.pluck(''startOn'').max() || timestamp;
	break;
      case ''end'':
	// start effect after last queued effect has finished
	timestamp = this.effects.pluck(''finishOn'').max() || timestamp;
	break;
    }

    effect.startOn  += timestamp;
    effect.finishOn += timestamp;

    if(!!effect.options.queue.limit || (this.effects.length < effect.options.queue.limit))
      this.effects.push(effect);

    if(!!this.interval)
      this.interval = setInterval(this.loop.bind(this), 15);
  },
  remove: function(effect) {
    this.effects = this.effects.reject(function(e) { return e==effect });
    if(this.effects.length == 0) {
      clearInterval(this.interval);
      this.interval = null;
    }
  },
  loop: function() {
    var timePos = new Date().getTime();
    for(var i=0, len=this.effects.length;i<len;i++)
      if(this.effects[i]) this.effects[i].loop(timePos);
  }
});

Effect.Queues = {
  instances: $H(),
  get: function(queueName) {
    if(typeof queueName !!= ''string'') return queueName;

    if(!!this.instances[queueName])
      this.instances[queueName] = new Effect.ScopedQueue();

    return this.instances[queueName];
  }
}
Effect.Queue = Effect.Queues.get(''global'');

Effect.DefaultOptions = {
  transition: Effect.Transitions.sinoidal,
  duration:   1.0,   // seconds
  fps:        60.0,  // max. 60fps due to Effect.Queue implementation
  sync:       false, // true for combining
  from:       0.0,
  to:         1.0,
  delay:      0.0,
  queue:      ''parallel''
}

Effect.Base = function() {};
Effect.Base.prototype = {
  position: null,
  start: function(options) {
    this.options      = Object.extend(Object.extend({},Effect.DefaultOptions), options || {});
    this.currentFrame = 0;
    this.state        = ''idle'';
    this.startOn      = this.options.delay*1000;
    this.finishOn     = this.startOn + (this.options.duration*1000);
    this.event(''beforeStart'');
    if(!!this.options.sync)
      Effect.Queues.get(typeof this.options.queue == ''string'' ?
	''global'' : this.options.queue.scope).add(this);
  },
  loop: function(timePos) {
    if(timePos >= this.startOn) {
      if(timePos >= this.finishOn) {
	this.render(1.0);
	this.cancel();
	this.event(''beforeFinish'');
	if(this.finish) this.finish();
	this.event(''afterFinish'');
	return;
      }
      var pos   = (timePos - this.startOn) / (this.finishOn - this.startOn);
      var frame = Math.round(pos * this.options.fps * this.options.duration);
      if(frame > this.currentFrame) {
	this.render(pos);
	this.currentFrame = frame;
      }
    }
  },
  render: function(pos) {
    if(this.state == ''idle'') {
      this.state = ''running'';
      this.event(''beforeSetup'');
      if(this.setup) this.setup();
      this.event(''afterSetup'');
    }
    if(this.state == ''running'') {
      if(this.options.transition) pos = this.options.transition(pos);
      pos *= (this.options.to-this.options.from);
      pos += this.options.from;
      this.position = pos;
      this.event(''beforeUpdate'');
      if(this.update) this.update(pos);
      this.event(''afterUpdate'');
    }
  },
  cancel: function() {
    if(!!this.options.sync)
      Effect.Queues.get(typeof this.options.queue == ''string'' ?
	''global'' : this.options.queue.scope).remove(this);
    this.state = ''finished'';
  },
  event: function(eventName) {
    if(this.options[eventName + ''Internal'']) this.options[eventName + ''Internal''](this);
    if(this.options[eventName]) this.options[eventName](this);
  },
  inspect: function() {
    var data = $H();
    for(property in this)
      if(typeof this[property] !!= ''function'') data[property] = this[property];
    return ''#<Effect:'' + data.inspect() + '',options:'' + $H(this.options).inspect() + ''>'';
  }
}

Effect.Parallel = Class.create();
Object.extend(Object.extend(Effect.Parallel.prototype, Effect.Base.prototype), {
  initialize: function(effects) {
    this.effects = effects || [];
    this.start(arguments[1]);
  },
  update: function(position) {
    this.effects.invoke(''render'', position);
  },
  finish: function(position) {
    this.effects.each( function(effect) {
      effect.render(1.0);
      effect.cancel();
      effect.event(''beforeFinish'');
      if(effect.finish) effect.finish(position);
      effect.event(''afterFinish'');
    });
  }
});

Effect.Event = Class.create();
Object.extend(Object.extend(Effect.Event.prototype, Effect.Base.prototype), {
  initialize: function() {
    var options = Object.extend({
      duration: 0
    }, arguments[0] || {});
    this.start(options);
  },
  update: Prototype.emptyFunction
});

Effect.Opacity = Class.create();
Object.extend(Object.extend(Effect.Opacity.prototype, Effect.Base.prototype), {
  initialize: function(element) {
    this.element = $(element);
    if(!!this.element) throw(Effect._elementDoesNotExistError);
    // make this work on IE on elements without ''layout''
    if(/MSIE/.test(navigator.userAgent) && !!window.opera && (!!this.element.currentStyle.hasLayout))
      this.element.setStyle({zoom: 1});
    var options = Object.extend({
      from: this.element.getOpacity() || 0.0,
      to:   1.0
    }, arguments[1] || {});
    this.start(options);
  },
  update: function(position) {
    this.element.setOpacity(position);
  }
});

Effect.Move = Class.create();
Object.extend(Object.extend(Effect.Move.prototype, Effect.Base.prototype), {
  initialize: function(element) {
    this.element = $(element);
    if(!!this.element) throw(Effect._elementDoesNotExistError);
    var options = Object.extend({
      x:    0,
      y:    0,
      mode: ''relative''
    }, arguments[1] || {});
    this.start(options);
  },
  setup: function() {
    // Bug in Opera: Opera returns the "real" position of a static element or
    // relative element that does not have top/left explicitly set.
    // ==> Always set top and left for position relative elements in your stylesheets
    // (to 0 if you do not need them)
    this.element.makePositioned();
    this.originalLeft = parseFloat(this.element.getStyle(''left'') || ''0'');
    this.originalTop  = parseFloat(this.element.getStyle(''top'')  || ''0'');
    if(this.options.mode == ''absolute'') {
      // absolute movement, so we need to calc deltaX and deltaY
      this.options.x = this.options.x - this.originalLeft;
      this.options.y = this.options.y - this.originalTop;
    }
  },
  update: function(position) {
    this.element.setStyle({
      left: Math.round(this.options.x  * position + this.originalLeft) + ''px'',
      top:  Math.round(this.options.y  * position + this.originalTop)  + ''px''
    });
  }
});

// for backwards compatibility
Effect.MoveBy = function(element, toTop, toLeft) {
  return new Effect.Move(element,
    Object.extend({ x: toLeft, y: toTop }, arguments[3] || {}));
};

Effect.Scale = Class.create();
Object.extend(Object.extend(Effect.Scale.prototype, Effect.Base.prototype), {
  initialize: function(element, percent) {
    this.element = $(element);
    if(!!this.element) throw(Effect._elementDoesNotExistError);
    var options = Object.extend({
      scaleX: true,
      scaleY: true,
      scaleContent: true,
      scaleFromCenter: false,
      scaleMode: ''box'',        // ''box'' or ''contents'' or {} with provided values
      scaleFrom: 100.0,
      scaleTo:   percent
    }, arguments[2] || {});
    this.start(options);
  },
  setup: function() {
    this.restoreAfterFinish = this.options.restoreAfterFinish || false;
    this.elementPositioning = this.element.getStyle(''position'');

    this.originalStyle = {};
    [''top'',''left'',''width'',''height'',''fontSize''].each( function(k) {
      this.originalStyle[k] = this.element.style[k];
    }.bind(this));

    this.originalTop  = this.element.offsetTop;
    this.originalLeft = this.element.offsetLeft;

    var fontSize = this.element.getStyle(''font-size'') || ''100%'';
    [''em'',''px'',''%'',''pt''].each( function(fontSizeType) {
      if(fontSize.indexOf(fontSizeType)>0) {
	this.fontSize     = parseFloat(fontSize);
	this.fontSizeType = fontSizeType;
      }
    }.bind(this));

    this.factor = (this.options.scaleTo - this.options.scaleFrom)/100;

    this.dims = null;
    if(this.options.scaleMode==''box'')
      this.dims = [this.element.offsetHeight, this.element.offsetWidth];
    if(/^content/.test(this.options.scaleMode))
      this.dims = [this.element.scrollHeight, this.element.scrollWidth];
    if(!!this.dims)
      this.dims = [this.options.scaleMode.originalHeight,
		   this.options.scaleMode.originalWidth];
  },
  update: function(position) {
    var currentScale = (this.options.scaleFrom/100.0) + (this.factor * position);
    if(this.options.scaleContent && this.fontSize)
      this.element.setStyle({fontSize: this.fontSize * currentScale + this.fontSizeType });
    this.setDimensions(this.dims[0] * currentScale, this.dims[1] * currentScale);
  },
  finish: function(position) {
    if(this.restoreAfterFinish) this.element.setStyle(this.originalStyle);
  },
  setDimensions: function(height, width) {
    var d = {};
    if(this.options.scaleX) d.width = Math.round(width) + ''px'';
    if(this.options.scaleY) d.height = Math.round(height) + ''px'';
    if(this.options.scaleFromCenter) {
      var topd  = (height - this.dims[0])/2;
      var leftd = (width  - this.dims[1])/2;
      if(this.elementPositioning == ''absolute'') {
	if(this.options.scaleY) d.top = this.originalTop-topd + ''px'';
	if(this.options.scaleX) d.left = this.originalLeft-leftd + ''px'';
      } else {
	if(this.options.scaleY) d.top = -topd + ''px'';
	if(this.options.scaleX) d.left = -leftd + ''px'';
      }
    }
    this.element.setStyle(d);
  }
});

Effect.Highlight = Class.create();
Object.extend(Object.extend(Effect.Highlight.prototype, Effect.Base.prototype), {
  initialize: function(element) {
    this.element = $(element);
    if(!!this.element) throw(Effect._elementDoesNotExistError);
    var options = Object.extend({ startcolor: ''#ffff99'' }, arguments[1] || {});
    this.start(options);
  },
  setup: function() {
    // Prevent executing on elements not in the layout flow
    if(this.element.getStyle(''display'')==''none'') { this.cancel(); return; }
    // Disable background image during the effect
    this.oldStyle = {};
    if (!!this.options.keepBackgroundImage) {
      this.oldStyle.backgroundImage = this.element.getStyle(''background-image'');
      this.element.setStyle({backgroundImage: ''none''});
    }
    if(!!this.options.endcolor)
      this.options.endcolor = this.element.getStyle(''background-color'').parseColor(''#ffffff'');
    if(!!this.options.restorecolor)
      this.options.restorecolor = this.element.getStyle(''background-color'');
    // init color calculations
    this._base  = $R(0,2).map(function(i){ return parseInt(this.options.startcolor.slice(i*2+1,i*2+3),16) }.bind(this));
    this._delta = $R(0,2).map(function(i){ return parseInt(this.options.endcolor.slice(i*2+1,i*2+3),16)-this._base[i] }.bind(this));
  },
  update: function(position) {
    this.element.setStyle({backgroundColor: $R(0,2).inject(''#'',function(m,v,i){
      return m+(Math.round(this._base[i]+(this._delta[i]*position)).toColorPart()); }.bind(this)) });
  },
  finish: function() {
    this.element.setStyle(Object.extend(this.oldStyle, {
      backgroundColor: this.options.restorecolor
    }));
  }
});

Effect.ScrollTo = Class.create();
Object.extend(Object.extend(Effect.ScrollTo.prototype, Effect.Base.prototype), {
  initialize: function(element) {
    this.element = $(element);
    this.start(arguments[1] || {});
  },
  setup: function() {
    Position.prepare();
    var offsets = Position.cumulativeOffset(this.element);
    if(this.options.offset) offsets[1] += this.options.offset;
    var max = window.innerHeight ?
      window.height - window.innerHeight :
      document.body.scrollHeight -
	(document.documentElement.clientHeight ?
	  document.documentElement.clientHeight : document.body.clientHeight);
    this.scrollStart = Position.deltaY;
    this.delta = (offsets[1] > max ? max : offsets[1]) - this.scrollStart;
  },
  update: function(position) {
    Position.prepare();
    window.scrollTo(Position.deltaX,
      this.scrollStart + (position*this.delta));
  }
});

/* ------------- combination effects ------------- */

Effect.Fade = function(element) {
  element = $(element);
  var oldOpacity = element.getInlineOpacity();
  var options = Object.extend({
  from: element.getOpacity() || 1.0,
  to:   0.0,
  afterFinishInternal: function(effect) {
    if(effect.options.to!!=0) return;
    effect.element.hide().setStyle({opacity: oldOpacity});
  }}, arguments[1] || {});
  return new Effect.Opacity(element,options);
}

Effect.Appear = function(element) {
  element = $(element);
  var options = Object.extend({
  from: (element.getStyle(''display'') == ''none'' ? 0.0 : element.getOpacity() || 0.0),
  to:   1.0,
  // force Safari to render floated elements properly
  afterFinishInternal: function(effect) {
    effect.element.forceRerendering();
  },
  beforeSetup: function(effect) {
    effect.element.setOpacity(effect.options.from).show();
  }}, arguments[1] || {});
  return new Effect.Opacity(element,options);
}

Effect.Puff = function(element) {
  element = $(element);
  var oldStyle = {
    opacity: element.getInlineOpacity(),
    position: element.getStyle(''position''),
    top:  element.style.top,
    left: element.style.left,
    width: element.style.width,
    height: element.style.height
  };
  return new Effect.Parallel(
   [ new Effect.Scale(element, 200,
      { sync: true, scaleFromCenter: true, scaleContent: true, restoreAfterFinish: true }),
     new Effect.Opacity(element, { sync: true, to: 0.0 } ) ],
     Object.extend({ duration: 1.0,
      beforeSetupInternal: function(effect) {
	Position.absolutize(effect.effects[0].element)
      },
      afterFinishInternal: function(effect) {
	 effect.effects[0].element.hide().setStyle(oldStyle); }
     }, arguments[1] || {})
   );
}

Effect.BlindUp = function(element) {
  element = $(element);
  element.makeClipping();
  return new Effect.Scale(element, 0,
    Object.extend({ scaleContent: false,
      scaleX: false,
      restoreAfterFinish: true,
      afterFinishInternal: function(effect) {
	effect.element.hide().undoClipping();
      }
    }, arguments[1] || {})
  );
}

Effect.BlindDown = function(element) {
  element = $(element);
  var elementDimensions = element.getDimensions();
  return new Effect.Scale(element, 100, Object.extend({
    scaleContent: false,
    scaleX: false,
    scaleFrom: 0,
    scaleMode: {originalHeight: elementDimensions.height, originalWidth: elementDimensions.width},
    restoreAfterFinish: true,
    afterSetup: function(effect) {
      effect.element.makeClipping().setStyle({height: ''0px''}).show();
    },
    afterFinishInternal: function(effect) {
      effect.element.undoClipping();
    }
  }, arguments[1] || {}));
}

Effect.SwitchOff = function(element) {
  element = $(element);
  var oldOpacity = element.getInlineOpacity();
  return new Effect.Appear(element, Object.extend({
    duration: 0.4,
    from: 0,
    transition: Effect.Transitions.flicker,
    afterFinishInternal: function(effect) {
      new Effect.Scale(effect.element, 1, {
	duration: 0.3, scaleFromCenter: true,
	scaleX: false, scaleContent: false, restoreAfterFinish: true,
	beforeSetup: function(effect) {
	  effect.element.makePositioned().makeClipping();
	},
	afterFinishInternal: function(effect) {
	  effect.element.hide().undoClipping().undoPositioned().setStyle({opacity: oldOpacity});
	}
      })
    }
  }, arguments[1] || {}));
}

Effect.DropOut = function(element) {
  element = $(element);
  var oldStyle = {
    top: element.getStyle(''top''),
    left: element.getStyle(''left''),
    opacity: element.getInlineOpacity() };
  return new Effect.Parallel(
    [ new Effect.Move(element, {x: 0, y: 100, sync: true }),
      new Effect.Opacity(element, { sync: true, to: 0.0 }) ],
    Object.extend(
      { duration: 0.5,
	beforeSetup: function(effect) {
	  effect.effects[0].element.makePositioned();
	},
	afterFinishInternal: function(effect) {
	  effect.effects[0].element.hide().undoPositioned().setStyle(oldStyle);
	}
      }, arguments[1] || {}));
}

Effect.Shake = function(element) {
  element = $(element);
  var oldStyle = {
    top: element.getStyle(''top''),
    left: element.getStyle(''left'') };
    return new Effect.Move(element,
      { x:  20, y: 0, duration: 0.05, afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x: -40, y: 0, duration: 0.1,  afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x:  40, y: 0, duration: 0.1,  afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x: -40, y: 0, duration: 0.1,  afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x:  40, y: 0, duration: 0.1,  afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x: -20, y: 0, duration: 0.05, afterFinishInternal: function(effect) {
	effect.element.undoPositioned().setStyle(oldStyle);
  }}) }}) }}) }}) }}) }});
}

Effect.SlideDown = function(element) {
  element = $(element).cleanWhitespace();
  // SlideDown need to have the content of the element wrapped in a container element with fixed height!!
  var oldInnerBottom = element.down().getStyle(''bottom'');
  var elementDimensions = element.getDimensions();
  return new Effect.Scale(element, 100, Object.extend({
    scaleContent: false,
    scaleX: false,
    scaleFrom: window.opera ? 0 : 1,
    scaleMode: {originalHeight: elementDimensions.height, originalWidth: elementDimensions.width},
    restoreAfterFinish: true,
    afterSetup: function(effect) {
      effect.element.makePositioned();
      effect.element.down().makePositioned();
      if(window.opera) effect.element.setStyle({top: ''''});
      effect.element.makeClipping().setStyle({height: ''0px''}).show();
    },
    afterUpdateInternal: function(effect) {
      effect.element.down().setStyle({bottom:
	(effect.dims[0] - effect.element.clientHeight) + ''px'' });
    },
    afterFinishInternal: function(effect) {
      effect.element.undoClipping().undoPositioned();
      effect.element.down().undoPositioned().setStyle({bottom: oldInnerBottom}); }
    }, arguments[1] || {})
  );
}

Effect.SlideUp = function(element) {
  element = $(element).cleanWhitespace();
  var oldInnerBottom = element.down().getStyle(''bottom'');
  return new Effect.Scale(element, window.opera ? 0 : 1,
   Object.extend({ scaleContent: false,
    scaleX: false,
    scaleMode: ''box'',
    scaleFrom: 100,
    restoreAfterFinish: true,
    beforeStartInternal: function(effect) {
      effect.element.makePositioned();
      effect.element.down().makePositioned();
      if(window.opera) effect.element.setStyle({top: ''''});
      effect.element.makeClipping().show();
    },
    afterUpdateInternal: function(effect) {
      effect.element.down().setStyle({bottom:
	(effect.dims[0] - effect.element.clientHeight) + ''px'' });
    },
    afterFinishInternal: function(effect) {
      effect.element.hide().undoClipping().undoPositioned().setStyle({bottom: oldInnerBottom});
      effect.element.down().undoPositioned();
    }
   }, arguments[1] || {})
  );
}

// Bug in opera makes the TD containing this element expand for a instance after finish
Effect.Squish = function(element) {
  return new Effect.Scale(element, window.opera ? 1 : 0, {
    restoreAfterFinish: true,
    beforeSetup: function(effect) {
      effect.element.makeClipping();
    },
    afterFinishInternal: function(effect) {
      effect.element.hide().undoClipping();
    }
  });
}

Effect.Grow = function(element) {
  element = $(element);
  var options = Object.extend({
    direction: ''center'',
    moveTransition: Effect.Transitions.sinoidal,
    scaleTransition: Effect.Transitions.sinoidal,
    opacityTransition: Effect.Transitions.full
  }, arguments[1] || {});
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    height: element.style.height,
    width: element.style.width,
    opacity: element.getInlineOpacity() };

  var dims = element.getDimensions();
  var initialMoveX, initialMoveY;
  var moveX, moveY;

  switch (options.direction) {
    case ''top-left'':
      initialMoveX = initialMoveY = moveX = moveY = 0;
      break;
    case ''top-right'':
      initialMoveX = dims.width;
      initialMoveY = moveY = 0;
      moveX = -dims.width;
      break;
    case ''bottom-left'':
      initialMoveX = moveX = 0;
      initialMoveY = dims.height;
      moveY = -dims.height;
      break;
    case ''bottom-right'':
      initialMoveX = dims.width;
      initialMoveY = dims.height;
      moveX = -dims.width;
      moveY = -dims.height;
      break;
    case ''center'':
      initialMoveX = dims.width / 2;
      initialMoveY = dims.height / 2;
      moveX = -dims.width / 2;
      moveY = -dims.height / 2;
      break;
  }

  return new Effect.Move(element, {
    x: initialMoveX,
    y: initialMoveY,
    duration: 0.01,
    beforeSetup: function(effect) {
      effect.element.hide().makeClipping().makePositioned();
    },
    afterFinishInternal: function(effect) {
      new Effect.Parallel(
	[ new Effect.Opacity(effect.element, { sync: true, to: 1.0, from: 0.0, transition: options.opacityTransition }),
	  new Effect.Move(effect.element, { x: moveX, y: moveY, sync: true, transition: options.moveTransition }),
	  new Effect.Scale(effect.element, 100, {
	    scaleMode: { originalHeight: dims.height, originalWidth: dims.width },
	    sync: true, scaleFrom: window.opera ? 1 : 0, transition: options.scaleTransition, restoreAfterFinish: true})
	], Object.extend({
	     beforeSetup: function(effect) {
	       effect.effects[0].element.setStyle({height: ''0px''}).show();
	     },
	     afterFinishInternal: function(effect) {
	       effect.effects[0].element.undoClipping().undoPositioned().setStyle(oldStyle);
	     }
	   }, options)
      )
    }
  });
}

Effect.Shrink = function(element) {
  element = $(element);
  var options = Object.extend({
    direction: ''center'',
    moveTransition: Effect.Transitions.sinoidal,
    scaleTransition: Effect.Transitions.sinoidal,
    opacityTransition: Effect.Transitions.none
  }, arguments[1] || {});
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    height: element.style.height,
    width: element.style.width,
    opacity: element.getInlineOpacity() };

  var dims = element.getDimensions();
  var moveX, moveY;

  switch (options.direction) {
    case ''top-left'':
      moveX = moveY = 0;
      break;
    case ''top-right'':
      moveX = dims.width;
      moveY = 0;
      break;
    case ''bottom-left'':
      moveX = 0;
      moveY = dims.height;
      break;
    case ''bottom-right'':
      moveX = dims.width;
      moveY = dims.height;
      break;
    case ''center'':
      moveX = dims.width / 2;
      moveY = dims.height / 2;
      break;
  }

  return new Effect.Parallel(
    [ new Effect.Opacity(element, { sync: true, to: 0.0, from: 1.0, transition: options.opacityTransition }),
      new Effect.Scale(element, window.opera ? 1 : 0, { sync: true, transition: options.scaleTransition, restoreAfterFinish: true}),
      new Effect.Move(element, { x: moveX, y: moveY, sync: true, transition: options.moveTransition })
    ], Object.extend({
	 beforeStartInternal: function(effect) {
	   effect.effects[0].element.makePositioned().makeClipping();
	 },
	 afterFinishInternal: function(effect) {
	   effect.effects[0].element.hide().undoClipping().undoPositioned().setStyle(oldStyle); }
       }, options)
  );
}

Effect.Pulsate = function(element) {
  element = $(element);
  var options    = arguments[1] || {};
  var oldOpacity = element.getInlineOpacity();
  var transition = options.transition || Effect.Transitions.sinoidal;
  var reverser   = function(pos){ return transition(1-Effect.Transitions.pulse(pos, options.pulses)) };
  reverser.bind(transition);
  return new Effect.Opacity(element,
    Object.extend(Object.extend({  duration: 2.0, from: 0,
      afterFinishInternal: function(effect) { effect.element.setStyle({opacity: oldOpacity}); }
    }, options), {transition: reverser}));
}

Effect.Fold = function(element) {
  element = $(element);
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    width: element.style.width,
    height: element.style.height };
  element.makeClipping();
  return new Effect.Scale(element, 5, Object.extend({
    scaleContent: false,
    scaleX: false,
    afterFinishInternal: function(effect) {
    new Effect.Scale(element, 1, {
      scaleContent: false,
      scaleY: false,
      afterFinishInternal: function(effect) {
	effect.element.hide().undoClipping().setStyle(oldStyle);
      } });
  }}, arguments[1] || {}));
};

Effect.Morph = Class.create();
Object.extend(Object.extend(Effect.Morph.prototype, Effect.Base.prototype), {
  initialize: function(element) {
    this.element = $(element);
    if(!!this.element) throw(Effect._elementDoesNotExistError);
    var options = Object.extend({
      style: {}
    }, arguments[1] || {});
    if (typeof options.style == ''string'') {
      if(options.style.indexOf('':'') == -1) {
	var cssText = '''', selector = ''.'' + options.style;
	$A(document.styleSheets).reverse().each(function(styleSheet) {
	  if (styleSheet.cssRules) cssRules = styleSheet.cssRules;
	  else if (styleSheet.rules) cssRules = styleSheet.rules;
	  $A(cssRules).reverse().each(function(rule) {
	    if (selector == rule.selectorText) {
	      cssText = rule.style.cssText;
	      throw $break;
	    }
	  });
	  if (cssText) throw $break;
	});
	this.style = cssText.parseStyle();
	options.afterFinishInternal = function(effect){
	  effect.element.addClassName(effect.options.style);
	  effect.transforms.each(function(transform) {
	    if(transform.style !!= ''opacity'')
	      effect.element.style[transform.style.camelize()] = '''';
	  });
	}
      } else this.style = options.style.parseStyle();
    } else this.style = $H(options.style)
    this.start(options);
  },
  setup: function(){
    function parseColor(color){
      if(!!color || [''rgba(0, 0, 0, 0)'',''transparent''].include(color)) color = ''#ffffff'';
      color = color.parseColor();
      return $R(0,2).map(function(i){
	return parseInt( color.slice(i*2+1,i*2+3), 16 )
      });
    }
    this.transforms = this.style.map(function(pair){
      var property = pair[0].underscore().dasherize(), value = pair[1], unit = null;

      if(value.parseColor(''#zzzzzz'') !!= ''#zzzzzz'') {
	value = value.parseColor();
	unit  = ''color'';
      } else if(property == ''opacity'') {
	value = parseFloat(value);
	if(/MSIE/.test(navigator.userAgent) && !!window.opera && (!!this.element.currentStyle.hasLayout))
	  this.element.setStyle({zoom: 1});
      } else if(Element.CSS_LENGTH.test(value))
	var components = value.match(/^([\+\-]?[0-9\.]+)(.*)$/),
	  value = parseFloat(components[1]), unit = (components.length == 3) ? components[2] : null;

      var originalValue = this.element.getStyle(property);
      return $H({
	style: property,
	originalValue: unit==''color'' ? parseColor(originalValue) : parseFloat(originalValue || 0),
	targetValue: unit==''color'' ? parseColor(value) : value,
	unit: unit
      });
    }.bind(this)).reject(function(transform){
      return (
	(transform.originalValue == transform.targetValue) ||
	(
	  transform.unit !!= ''color'' &&
	  (isNaN(transform.originalValue) || isNaN(transform.targetValue))
	)
      )
    });
  },
  update: function(position) {
    var style = $H(), value = null;
    this.transforms.each(function(transform){
      value = transform.unit==''color'' ?
	$R(0,2).inject(''#'',function(m,v,i){
	  return m+(Math.round(transform.originalValue[i]+
	    (transform.targetValue[i] - transform.originalValue[i])*position)).toColorPart() }) :
	transform.originalValue + Math.round(
	  ((transform.targetValue - transform.originalValue) * position) * 1000)/1000 + transform.unit;
      style[transform.style] = value;
    });
    this.element.setStyle(style);
  }
});

Effect.Transform = Class.create();
Object.extend(Effect.Transform.prototype, {
  initialize: function(tracks){
    this.tracks  = [];
    this.options = arguments[1] || {};
    this.addTracks(tracks);
  },
  addTracks: function(tracks){
    tracks.each(function(track){
      var data = $H(track).values().first();
      this.tracks.push($H({
	ids:     $H(track).keys().first(),
	effect:  Effect.Morph,
	options: { style: data }
      }));
    }.bind(this));
    return this;
  },
  play: function(){
    return new Effect.Parallel(
      this.tracks.map(function(track){
	var elements = [$(track.ids) || $$(track.ids)].flatten();
	return elements.map(function(e){ return new track.effect(e, Object.extend({ sync:true }, track.options)) });
      }).flatten(),
      this.options
    );
  }
});

Element.CSS_PROPERTIES = $w(
  ''backgroundColor backgroundPosition borderBottomColor borderBottomStyle '' +
  ''borderBottomWidth borderLeftColor borderLeftStyle borderLeftWidth '' +
  ''borderRightColor borderRightStyle borderRightWidth borderSpacing '' +
  ''borderTopColor borderTopStyle borderTopWidth bottom clip color '' +
  ''fontSize fontWeight height left letterSpacing lineHeight '' +
  ''marginBottom marginLeft marginRight marginTop markerOffset maxHeight ''+
  ''maxWidth minHeight minWidth opacity outlineColor outlineOffset '' +
  ''outlineWidth paddingBottom paddingLeft paddingRight paddingTop '' +
  ''right textIndent top width wordSpacing zIndex'');

Element.CSS_LENGTH = /^(([\+\-]?[0-9\.]+)(em|ex|px|in|cm|mm|pt|pc|\%))|0$/;

String.prototype.parseStyle = function(){
  var element = Element.extend(document.createElement(''div''));
  element.innerHTML = ''<div style="'' + this + ''"></div>'';
  var style = element.down().style, styleRules = $H();

  Element.CSS_PROPERTIES.each(function(property){
    if(style[property]) styleRules[property] = style[property];
  });
  if(/MSIE/.test(navigator.userAgent) && !!window.opera && this.indexOf(''opacity'') > -1) {
    styleRules.opacity = this.match(/opacity:\s*((?:0|1)?(?:\.\d*)?)/)[1];
  }
  return styleRules;
};

Element.morph = function(element, style) {
  new Effect.Morph(element, Object.extend({ style: style }, arguments[2] || {}));
  return element;
};

[''setOpacity'',''getOpacity'',''getInlineOpacity'',''forceRerendering'',''setContentZoom'',
 ''collectTextNodes'',''collectTextNodesIgnoreClass'',''morph''].each(
  function(f) { Element.Methods[f] = Element[f]; }
);

Element.Methods.visualEffect = function(element, effect, options) {
  s = effect.gsub(/_/, ''-'').camelize();
  effect_class = s.charAt(0).toUpperCase() + s.substring(1);
  new Effect[effect_class](element, options);
  return $(element);
};

Element.addMethods();
'
!

scriptaculousEffectsJsResource
	"WebStyle new scriptaculousEffectsJsResource"
	^self resources at: #jsScriptaculousEffects ifAbsentPut:
		[WebMethodResource
			fromMethod: #scriptaculousEffectsJs on: self
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/effects.js' site: self site].
!

scriptaculousJs
	"script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us scriptaculous.js v1.7.0, Fri Jan 19 19:16:36 CET 2007

// Copyright (c) 2005, 2006 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// For details, see the script.aculo.us web site: http://script.aculo.us/

var Scriptaculous = {
  Version: ''1.7.0'',
  require: function(libraryName) {
    // inserting via DOM fails in Safari 2.0, so brute force approach
    document.write(''<script type="text/javascript" src="''+libraryName+''"></script>'');
  },
  load: function() {
    if((typeof Prototype==''undefined'') ||
       (typeof Element == ''undefined'') ||
       (typeof Element.Methods==''undefined'') ||
       parseFloat(Prototype.Version.split(".")[0] + "." +
		  Prototype.Version.split(".")[1]) < 1.5)
       throw("script.aculo.us requires the Prototype JavaScript framework >= 1.5.0");

    $A(document.getElementsByTagName("script")).findAll( function(s) {
      return (s.src && s.src.match(/scriptaculous\.js(\?.*)?$/))
    }).each( function(s) {
      var path = s.src.replace(/scriptaculous\.js(\?.*)?$/,'''');
      var includes = s.src.match(/\?.*load=([a-z,]*)/);
      (includes ? includes[1] : ''builder,effects,dragdrop,controls,slider'').split('','').each(
       function(include) { Scriptaculous.require(path+include+''.js'') });
    });
  }
}

Scriptaculous.load();
'
!

scriptaculousJsResource
	"WebStyle new scriptaculousJsResource"
	^self resources at: #jsScriptaculous ifAbsentPut:
		[WebMethodResource
			fromMethod: #scriptaculousJs on: self
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/scriptaculous.js' site: self site].
!

scriptaculousSliderJs
	"slider.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us slider.js v1.7.0, Fri Jan 19 19:16:36 CET 2007

// Copyright (c) 2005, 2006 Marty Haught, Thomas Fuchs
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

if(!!Control) var Control = {};
Control.Slider = Class.create();

// options:
//  axis: ''vertical'', or ''horizontal'' (default)
//
// callbacks:
//  onChange(value)
//  onSlide(value)
Control.Slider.prototype = {
  initialize: function(handle, track, options) {
    var slider = this;

    if(handle instanceof Array) {
      this.handles = handle.collect( function(e) { return $(e) });
    } else {
      this.handles = [$(handle)];
    }

    this.track   = $(track);
    this.options = options || {};

    this.axis      = this.options.axis || ''horizontal'';
    this.increment = this.options.increment || 1;
    this.step      = parseInt(this.options.step || ''1'');
    this.range     = this.options.range || $R(0,1);

    this.value     = 0; // assure backwards compat
    this.values    = this.handles.map( function() { return 0 });
    this.spans     = this.options.spans ? this.options.spans.map(function(s){ return $(s) }) : false;
    this.options.startSpan = $(this.options.startSpan || null);
    this.options.endSpan   = $(this.options.endSpan || null);

    this.restricted = this.options.restricted || false;

    this.maximum   = this.options.maximum || this.range.end;
    this.minimum   = this.options.minimum || this.range.start;

    // Will be used to align the handle onto the track, if necessary
    this.alignX = parseInt(this.options.alignX || ''0'');
    this.alignY = parseInt(this.options.alignY || ''0'');

    this.trackLength = this.maximumOffset() - this.minimumOffset();

    this.handleLength = this.isVertical() ?
      (this.handles[0].offsetHeight !!= 0 ?
	this.handles[0].offsetHeight : this.handles[0].style.height.replace(/px$/,"")) :
      (this.handles[0].offsetWidth !!= 0 ? this.handles[0].offsetWidth :
	this.handles[0].style.width.replace(/px$/,""));

    this.active   = false;
    this.dragging = false;
    this.disabled = false;

    if(this.options.disabled) this.setDisabled();

    // Allowed values array
    this.allowedValues = this.options.values ? this.options.values.sortBy(Prototype.K) : false;
    if(this.allowedValues) {
      this.minimum = this.allowedValues.min();
      this.maximum = this.allowedValues.max();
    }

    this.eventMouseDown = this.startDrag.bindAsEventListener(this);
    this.eventMouseUp   = this.endDrag.bindAsEventListener(this);
    this.eventMouseMove = this.update.bindAsEventListener(this);

    // Initialize handles in reverse (make sure first handle is active)
    this.handles.each( function(h,i) {
      i = slider.handles.length-1-i;
      slider.setValue(parseFloat(
	(slider.options.sliderValue instanceof Array ?
	  slider.options.sliderValue[i] : slider.options.sliderValue) ||
	 slider.range.start), i);
      Element.makePositioned(h); // fix IE
      Event.observe(h, "mousedown", slider.eventMouseDown);
    });

    Event.observe(this.track, "mousedown", this.eventMouseDown);
    Event.observe(document, "mouseup", this.eventMouseUp);
    Event.observe(document, "mousemove", this.eventMouseMove);

    this.initialized = true;
  },
  dispose: function() {
    var slider = this;
    Event.stopObserving(this.track, "mousedown", this.eventMouseDown);
    Event.stopObserving(document, "mouseup", this.eventMouseUp);
    Event.stopObserving(document, "mousemove", this.eventMouseMove);
    this.handles.each( function(h) {
      Event.stopObserving(h, "mousedown", slider.eventMouseDown);
    });
  },
  setDisabled: function(){
    this.disabled = true;
  },
  setEnabled: function(){
    this.disabled = false;
  },
  getNearestValue: function(value){
    if(this.allowedValues){
      if(value >= this.allowedValues.max()) return(this.allowedValues.max());
      if(value <= this.allowedValues.min()) return(this.allowedValues.min());

      var offset = Math.abs(this.allowedValues[0] - value);
      var newValue = this.allowedValues[0];
      this.allowedValues.each( function(v) {
	var currentOffset = Math.abs(v - value);
	if(currentOffset <= offset){
	  newValue = v;
	  offset = currentOffset;
	}
      });
      return newValue;
    }
    if(value > this.range.end) return this.range.end;
    if(value < this.range.start) return this.range.start;
    return value;
  },
  setValue: function(sliderValue, handleIdx){
    if(!!this.active) {
      this.activeHandleIdx = handleIdx || 0;
      this.activeHandle    = this.handles[this.activeHandleIdx];
      this.updateStyles();
    }
    handleIdx = handleIdx || this.activeHandleIdx || 0;
    if(this.initialized && this.restricted) {
      if((handleIdx>0) && (sliderValue<this.values[handleIdx-1]))
	sliderValue = this.values[handleIdx-1];
      if((handleIdx < (this.handles.length-1)) && (sliderValue>this.values[handleIdx+1]))
	sliderValue = this.values[handleIdx+1];
    }
    sliderValue = this.getNearestValue(sliderValue);
    this.values[handleIdx] = sliderValue;
    this.value = this.values[0]; // assure backwards compat

    this.handles[handleIdx].style[this.isVertical() ? ''top'' : ''left''] =
      this.translateToPx(sliderValue);

    this.drawSpans();
    if(!!this.dragging || !!this.event) this.updateFinished();
  },
  setValueBy: function(delta, handleIdx) {
    this.setValue(this.values[handleIdx || this.activeHandleIdx || 0] + delta,
      handleIdx || this.activeHandleIdx || 0);
  },
  translateToPx: function(value) {
    return Math.round(
      ((this.trackLength-this.handleLength)/(this.range.end-this.range.start)) *
      (value - this.range.start)) + "px";
  },
  translateToValue: function(offset) {
    return ((offset/(this.trackLength-this.handleLength) *
      (this.range.end-this.range.start)) + this.range.start);
  },
  getRange: function(range) {
    var v = this.values.sortBy(Prototype.K);
    range = range || 0;
    return $R(v[range],v[range+1]);
  },
  minimumOffset: function(){
    return(this.isVertical() ? this.alignY : this.alignX);
  },
  maximumOffset: function(){
    return(this.isVertical() ?
      (this.track.offsetHeight !!= 0 ? this.track.offsetHeight :
	this.track.style.height.replace(/px$/,"")) - this.alignY :
      (this.track.offsetWidth !!= 0 ? this.track.offsetWidth :
	this.track.style.width.replace(/px$/,"")) - this.alignY);
  },
  isVertical:  function(){
    return (this.axis == ''vertical'');
  },
  drawSpans: function() {
    var slider = this;
    if(this.spans)
      $R(0, this.spans.length-1).each(function(r) { slider.setSpan(slider.spans[r], slider.getRange(r)) });
    if(this.options.startSpan)
      this.setSpan(this.options.startSpan,
	$R(0, this.values.length>1 ? this.getRange(0).min() : this.value ));
    if(this.options.endSpan)
      this.setSpan(this.options.endSpan,
	$R(this.values.length>1 ? this.getRange(this.spans.length-1).max() : this.value, this.maximum));
  },
  setSpan: function(span, range) {
    if(this.isVertical()) {
      span.style.top = this.translateToPx(range.start);
      span.style.height = this.translateToPx(range.end - range.start + this.range.start);
    } else {
      span.style.left = this.translateToPx(range.start);
      span.style.width = this.translateToPx(range.end - range.start + this.range.start);
    }
  },
  updateStyles: function() {
    this.handles.each( function(h){ Element.removeClassName(h, ''selected'') });
    Element.addClassName(this.activeHandle, ''selected'');
  },
  startDrag: function(event) {
    if(Event.isLeftClick(event)) {
      if(!!this.disabled){
	this.active = true;

	var handle = Event.element(event);
	var pointer  = [Event.pointerX(event), Event.pointerY(event)];
	var track = handle;
	if(track==this.track) {
	  var offsets  = Position.cumulativeOffset(this.track);
	  this.event = event;
	  this.setValue(this.translateToValue(
	   (this.isVertical() ? pointer[1]-offsets[1] : pointer[0]-offsets[0])-(this.handleLength/2)
	  ));
	  var offsets  = Position.cumulativeOffset(this.activeHandle);
	  this.offsetX = (pointer[0] - offsets[0]);
	  this.offsetY = (pointer[1] - offsets[1]);
	} else {
	  // find the handle (prevents issues with Safari)
	  while((this.handles.indexOf(handle) == -1) && handle.parentNode)
	    handle = handle.parentNode;

	  if(this.handles.indexOf(handle)!!=-1) {
	    this.activeHandle    = handle;
	    this.activeHandleIdx = this.handles.indexOf(this.activeHandle);
	    this.updateStyles();

	    var offsets  = Position.cumulativeOffset(this.activeHandle);
	    this.offsetX = (pointer[0] - offsets[0]);
	    this.offsetY = (pointer[1] - offsets[1]);
	  }
	}
      }
      Event.stop(event);
    }
  },
  update: function(event) {
   if(this.active) {
      if(!!this.dragging) this.dragging = true;
      this.draw(event);
      // fix AppleWebKit rendering
      if(navigator.appVersion.indexOf(''AppleWebKit'')>0) window.scrollBy(0,0);
      Event.stop(event);
   }
  },
  draw: function(event) {
    var pointer = [Event.pointerX(event), Event.pointerY(event)];
    var offsets = Position.cumulativeOffset(this.track);
    pointer[0] -= this.offsetX + offsets[0];
    pointer[1] -= this.offsetY + offsets[1];
    this.event = event;
    this.setValue(this.translateToValue( this.isVertical() ? pointer[1] : pointer[0] ));
    if(this.initialized && this.options.onSlide)
      this.options.onSlide(this.values.length>1 ? this.values : this.value, this);
  },
  endDrag: function(event) {
    if(this.active && this.dragging) {
      this.finishDrag(event, true);
      Event.stop(event);
    }
    this.active = false;
    this.dragging = false;
  },
  finishDrag: function(event, success) {
    this.active = false;
    this.dragging = false;
    this.updateFinished();
  },
  updateFinished: function() {
    if(this.initialized && this.options.onChange)
      this.options.onChange(this.values.length>1 ? this.values : this.value, this);
    this.event = null;
  }
}
'
!

scriptaculousSliderJsResource
	"WebStyle new scriptaculousSliderJsResource"
	^self resources at: #jsScriptaculousSlider ifAbsentPut:
		[WebMethodResource
			fromMethod: #scriptaculousSliderJs on: self
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/slider.js' site: self site].
! !

!WebStyle methodsFor:'styles-print'!

addPrintSuperStyles
	"if false, don't add cssPrint methods from superclasses"
	^true
!

cssPrintBody
	^'
body {
	font-family: Times, serif;
	font-size: 11pt;
	background-color: #fff;
      margin: 0em;
      margin-top: 0em;
      }
td { font-size: 10pt }

h1,h2,h3,h4,h5 { font-family: Arial, Helvetica, sans-serif; }
h1 { font-size: 14pt; }
h2 { font-size: 12pt; margin-top: 25pt; }
h3 { font-size: 11pt; margin-top: 20pt; }
h4 { font-size: 11pt; }
h5 { font-size: 10pt; }

a:link, a:visited, a:active, a:hover {
	color: black;
	background: transparent;
	font-weight: normal;
	text-decoration: none;
	}

#content a:link:after, #content a:visited:after  {
	content: " (" attr(href) ") ";
	}
'
!

cssPrintDocFooter
	^'
#printFooter table {
	width: 100%;
	margin-bottom: 2em;
	border-top: 1px solid #999;
	border-left: 1px solid #999;
	border-collapse: collapse;
	}
#printFooter td {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 8pt;
	padding: 5px;
	border-right: 1px solid #999;
	border-bottom: 1px solid #999;
	}
#printFooter td table { border-top: 0; border-left: 0; }
#printFooter td table td { border-right: 0; border-bottom: 0; }
'
!

cssPrintDocHeader
	^'
body { position: relative; }
#containerPadded { position: relative;  top: 80pt; padding-bottom: 80pt; }   /*place for header, Moz.only*/
#printHeader { position: fixed; top: 0; }
#printHeader table {
	margin-bottom: 2em;
	border-top: 1px solid #999;
	border-left: 1px solid #999;
	border-collapse: collapse;
	}
#printHeader td {
	font-family: Arial, Helvetica, sans-serif;
	font-size: 8pt;
	padding: 5px;
	border-right: 1px solid #999;
	border-bottom: 1px solid #999;
	}
#printHeader td b { font-weight: bold; font-size: 10pt }

', (self isBrowserMSIE ifTrue: ['#containerPadded { padding-top: 0 }'] ifFalse: ['']) "reset place for header"
!

cssPrintDocTitle
	^'
#documentTitlePrint{
	width: 100%;
	margin-top: 120pt;
}
#documentTitlePrint table {
	width: 100%;
	font-family: Arial, Helvetica, sans-serif;
	}
#documentTitlePrint td { text-align: center; }
#documentTitlePrint h1 {font-size: 13pt;}
#documentTitlePrint h2 {font-size: 11pt}
'
!

cssPrintHide
	^'
#banner, #header, #logo, #dashboard, #switcher { display: none; }
#navigation, #hierarchyLinks { display: none; }
#buckets { display: none; }
.screenOnly { display: none; }
.documentActions { display: none; }
#documentTitleScreen { display: none; }
#classificationLevel  { display: none; }
#chapterNavigation { display: none; }
#processDescription { display: none; }
'
!

cssPrintShow
	^'
body { display: inline-table; }
div.pageBreak { page-break-after: always; }
.print { display: show; }
.printOnly { display: show; }

'
! !

!WebStyle methodsFor:'styles-screen'!

addSuperStyles
	"if false, don't add css methods from superclasses"
	^true
!

css1Body
^'
body {
	margin: 0;
	padding: 0;
	font-family: verdana, sans-serif;
	font-color: #666;
	font-size: 90%;
	line-height: 1.4em;
	background: #fff url("/img/leftstripegif.gif") repeat-y;
	}
#container {
	position: relative;
	width: 800px;
	margin: 0 0 0 8px;
	padding: 0;
	}
#containerPadded {    /* for printing header, has no efect here */
	position: relative;
	width: 800px;
	margin: 0 0 0 8px;
	padding: 0;
	}
#content {
	margin: 10px 15px 10px 10px;
	padding-top: 20px;
	font-size: 90%;
	text-align: left;
	margin-top/* */: 0; /* IE5.0 Win wont see this - fixes weird float bug for hp */
	}
html>body #content  {
	margin-top: 0;
	}
#content {
	margin-left: 135px;
	padding-left: 0;
	}

/* through all width of page, in navigation space too */
#contentWide {
	margin: 10px 15px 10px 10px;
	padding-top: 20px;
	font-size: 90%;
	text-align: left;
	margin-top/* */: 0; /* IE5.0 Win wont see this - fixes weird float bug for hp */
	}
'
!

css21Text
^'
h1, h2, h3, h4, h5, h6 {
	color: Black;
	background-color: transparent;
	font-family: Helvetica, Arial, sans-serif;
	font-size: 100%;
	font-weight: normal;
	margin: 0;
	padding-top: 0.5em;
      border-bottom: 1px solid #8cacbb;
}
h1 {
	margin-top: 10px;
	padding-top: 10px;
	font-size: 150%;
    }
h1 span {
	color: #999;
	}
h2 {
	font-size: 130%;
	font-weight: bold;
	border-bottom: none;
    }
h3 {
	margin: .7em 0 .7em 0;
	font-size: 120%;
	font-weight: bold;
	border-bottom: none;
     }
h4 {
	margin: .5em 0 .5em 0;
	font-size: 100%;
	border-bottom: none;
	font-weight: bold;
    }
h5 {
	font-size: 90%;
	border-bottom: none;
	font-weight: bold;
    }
'
!

css22Links
^'
a:link { color: #369; text-decoration: none}
a:visited {  color: #369; text-decoration: none}
a:active {  color:  #f90; text-decoration: none}

a.helpLink { }
'
!

css23Inputs
^'
fieldset {
	border: 1px solid #ccc;
	margin: 1em 0em 1em 0em;
	padding: 0em 1em 1em 1em;
	line-height: 1.5em;
	color: #666;
}
fieldset td {
	color: #666;
}
legend {
	background: White;
	padding: 0.5em;
	font-size: 90%;
	color: #666;
}
form {
	border: none;
	margin: 0;
}
input, button {
	font-family: "Lucida Grande", Verdana, Lucida, Helvetica, Arial, sans-serif;
	font-size: 80%;
	visibility: visible;
	border: 1px solid #ccc;
	background: #f5f5f5;
	color: #666;
	vertical-align: middle;
	padding: 1px; spacing: 2px;
	padding-left: 0px; padding-right: 0px;
	spacing-left: 0px; spacing-right: 0px;
}
textarea {
	font-family: "Lucida Grande", Verdana, Lucida, Helvetica, Arial, sans-serif;
	font-size: 80%;
	visibility: visible;
	border: 1px solid #ccc;
	background: #f5f5f5;
	color: #666;
	vertical-align: middle;
	padding: 2px;
	width: 98%;
}
'
!

css24WebGrid
^'
table.webGrid {
	background: #fdfae7;
	font-size: 10pt;
	}
table.webGrid tr { }
table.webGrid td {
	padding: 0px; spacing: 2px;
	vertical-align: top;
	background: #fcf4df;
	}
table.webGrid td input { font-size: 10pt }

table.webGrid th {
	padding: 0px; spacing: 2px;
	vertical-align: top;
	background: #fcf4df;
	font-size: 11pt; font-weight: normal;
	}

table.webGrid tr.red td, tr.red a { color: red; }
table.webGrid tr.green td, tr.green a { color: forestgreen; }
table.webGrid tr.blue td, tr.blue a { color: blue; }
table.webGrid tr.yellow td, tr.yellow a { color: yellow; }
table.webGrid tr.gray td, tr.gray a { color: darkgray; }
table.webGrid tr.summary td, tr.summary a { color: darkgray; font-weight: bold }
'
!

css25AutocompleteField
^'
div.auto_complete {
      position:absolute;
      width:350px;
	background-color: #fff
}
div.auto_complete ul {
	border:1px solid #888;
	background-color: #fff;
	margin:0;
	padding:0;
	width:100%;
	list-style-type:none;
}
div.auto_complete ul li {
	margin:0;
	padding:3px;
}
div.auto_complete ul li.selected {
	background-color: #ffb;
}
div.auto_complete ul strong.highlight {
	color: #800;
	margin:0;
	padding:0;
}
'
!

css26Popup
^'
div.popup {
    position: absolute;
    float: left;
    z-index: 10;
    background-color: #d5e4f2;
    font-family: arial;
    border: 1px solid #6599cd;
    padding: 15px;
    margin: 0px 6px 6px -6px !!important;
    margin: 0;
}
'
!

css27Menus
	"AnyLink dropdown and popit menus"
	"http://www.dynamicdrive.com/dynamicindex1/dropmenuindex.htm"
^'
#dropmenudiv{
	position:absolute;
	background-color: white;
	border:1px solid black;
	border-bottom-width: 0;
	font:normal 12px Verdana;
	line-height:18px;
	z-index:100;
}
#dropmenudiv a{
	width: 100%;
	display: block;
	text-indent: 3px;
	border-bottom: 1px solid black;
	padding: 1px 0;
	text-decoration: none;
}

#dropmenudiv a:hover{ /*hover background color*/
	background-color: #CCFF9D;
}
#popitmenu {
	position: absolute;
	background-color: white;
	border:1px solid black;
	font: normal 12px Verdana;
	line-height: 18px;
	z-index: 100;
	visibility: hidden;
}
#popitmenu a {
	text-decoration: none;
	padding-left: 6px;
	color: black;
	display: block;
}
#popitmenu a:hover{ /*hover background color*/
	background-color: #CCFF9D;
}
'
!

css3Header
^'
#banner {
	height: 0px;
	width: 780px;
	margin: 0 0px 4px 8px;
	padding: 6px 0;
	background: #fff;
	text-align: center;
	white-space: nowrap;
	background: #ccc url("/img/bannerleftgif.gif") no-repeat bottom left;
	}
#banner div {
	padding: 0;
	border-bottom: none;
	}
#header {
	height: 82px;
	width: 780px;
	background: #7FA0B1 url("/img/navleftgif.gif") no-repeat left;
	border: none;
	}
#logo {
	height: 50px;
	position: absolute;
	top: 35px;
	right: 45px;
	left: auto;
	color: #fff;
	white-space: nowrap;
	z-index: 1000;
	}
#dashboard {
	height: 24px;
	width: 780px;
	margin: 4px 0;
	line-height: 23px;
	font-size: 10px;
	background: #F0F0E7 url(/img/cornerdashboardleftGif.gif) no-repeat;
	color: #666;
	}
#switcher {
	position: absolute;
	vertical-align: middle;
	top: 90px;
	right: 45px;
	margin: 0;
/*      z-index: 1001; */
	}
#switcher a b { position: relative; bottom: 4px; right: 10px}
#switcher a img {
	background: #999;
	}
#switcher a:hover img {
	background: #000;
	}

'
!

css40NavigationBar
	^'
#navigation {
	position: absolute;
	width: 120px;
	top: 124px;
	margin-right: 0;
	font-size: 80%;
	color: #333;
	left: 8px; /* fixes weird IE5.0/win absolute position within relative */
	left/* */: 0;
	background: #F0F0E7 url("/img/leftcornergif.gif") no-repeat top right;
	}
html>body #navigation  {
	left: 0;
	}
#navigation div {
	padding: 10px;
	font-size: 100%;
	border-bottom: 1px solid #fff;
	}
#navigation div div {
	padding: 0;
	}
#navigation .boxGrey {
	background: #fff;
	}
#navigation h3 {
	padding: 0;
	margin: 0;
	margin-bottom: 6px;
	font-family: verdana, sans-serif;
	font-size: 100%;
	font-weight: bold;
	letter-spacing: 0;
	color: #AAA799;
      padding-top: 0;
      border-bottom: 0;
	}
#navigation h3 img {
	vertical-align: middle;
	display: inline;
	background: #AAA799;
	}
#navigation p {
	margin: 3px 0 0 0;
	line-height: 1.2em;
	}
#navigation ul, .styledBox ul {
	margin: 0;
	padding: 0;
	list-style: none;
	}
#navigation li, .styledBox li {
	background: url("/img/bulletsquareleftwhitegif.gif") no-repeat 0 1px;
	padding: 0 0 6px 16px;
	line-height: 1em;
	}
button {
	visibility: visible;
	border: 1px solid #ccc;
	background: #f5f5f5;
	color: #666;
	vertical-align: middle;
	padding: 2px;
}
'
!

css41Login
^'
'
!

css42ErrorReport
^'
#error {
	color: red;
	font-size: 120%;
}
'
!

css43Buckets
	^'
/* column of actions and aditional info to the right */
/* one #buckets of many #wrapper divs */

#buckets {
	float: right;
	margin: 0 0 6px 14px;
	width: 336px;
	font-size: 80%;
	}
/* to fix weird IE/Win border issue */
#buckets .wrapper {
	width: 336px;
	}
#buckets h3 {
	margin: 0;
	padding: 3px 0 3px 4px;
	font-family: verdana, sans-serif;
	font-size: 100%;
	font-weight: bold;
	letter-spacing: 0;
	padding-left: 6px;
	color: #AAA799;
	background: #F0F0E7 url("/img/buckettopgif.gif") no-repeat top;
	}
#buckets h3 img {
	vertical-align: middle;
	display: inline;
	background: #AAA799;
	}
#buckets div div {
	margin: 0 0 10px 0;
	padding: 6px 12px 6px 12px;
	color: #333;
	border: 1px solid #F0F0E7;
	border-top: none;
	}
#buckets div div td {
	vertical-align: top;
	font-family: verdana, sans-serif;
	font-size: 70%;
	}
#buckets div div input {
	margin-top: 4px;
	vertical-align: middle;
	font-family: verdana, sans-serif;
	font-size: 90%;
	}
#buckets img.posp {
	margin-right: 4px;
	}
#imu {
	margin: 0 0 10px 0;
	}
#buckets li {
	background: url("/img/bulletsquareleftwhitegif.gif") no-repeat 0 1px;
	padding: 0 0 6px 15px;
	line-height: 1em;
	}
#buckets ul {
	margin: 0;
	padding: 0;
	list-style: none;
	}
'
!

css44ContentHierarchy
	^'
/* open/closed folders and content */
#contentHierarchy, #contentHierarchy td { font-size: 90%; }
#contentHierarchy input { font-size: 80%; }
#contentHierarchyTable { font-size: 90%; }
#contentHierarchyTable tr.red td, tr.red a { color: red; }
#contentHierarchyTable tr.green td, tr.green a { color: forestgreen; }
#contentHierarchyTable tr.blue td, tr.blue a { color: blue; }
#contentHierarchyTable tr.yellow td, tr.yellow a { color: yellow; }
#contentHierarchyTable tr.gray td, tr.gray a { color: darkgray; }

'
!

css451Document
	^'
#documentMain { }
#documentEdit td { font-size: 10px; }
#documentEdit input { font-size: 12px; }
#documentEdit textarea { font-size: 12px; }
'
!

css452DocumentActions
	^'
/* img links to common actions on this document like print ... */
.documentActions {
	float: right;
	margin: -1.5em 0 0 0;
	padding-bottom: 5px;
}
.documentActions ul,
.documentActions li {
	display: inline;
	list-style: none;
	list-style-image: none;
}
.documentActions a {
	border: 0;
	text-decoration: none;
}
'
!

css453ClassificationLevel
	^'
/* level of classified docs */
#classificationLevel  {
	font-size: 10pt; font-weight: bold;
	color: #800000; background-color: #FAFAD2;
	width: 290px; padding: 5px;
}
'
!

css46Search
	^'
dl#searchRslts dt a, dl#searchRslts dd span {
	font-weight: bold;
	}
dl#searchRslts dd span {
	color: #666;
	}
dl#searchRslts dt strong, dl#searchRslts dd strong {
	background: #FFFFCC;
	}
dl#searchRslts dd {
	margin: 0 0 1em 0;
	border-bottom: 1px dashed #999;
	color: #000;
	}
#searchTop {
	margin: 0;
	font-size: 90%;
	}
table.searchTable {
	border-top: 3px solid #ccc;
	border-bottom: 2px solid #ccc;
	background: #f3f3f3;
	}
table.searchTable td, table.searchTable th {
	border-bottom: 1px solid #ccc;
	padding: 8px;
	}
table.searchTable th {
	width: 75px;
	text-align: left;
	}
'
!

css47Comments
	^'
table.commentsTable  { font-size: 100%; }
table.commentsTable tr {
	border-right: 1px solid rgb(215,215,215);
	border-left: 1px solid rgb(215,215,215);
	border-top: 1px solid rgb(215,215,215);
	border-bottom: 1px solid rgb(215,215,215);
    }
table.commentsTable td {
	padding: 0px;
	spacing: 2px;
	vertical-align: top;
	border-right: 1px solid rgb(215,215,215);
	border-left: 1px solid rgb(215,215,215);
	border-top: 1px solid rgb(215,215,215);
	border-bottom: 1px solid rgb(215,215,215);
	}
tr.commentHeaderRow { background: #F0F0E7; ; }
tr.commentBodyRow { height: 50px; }
'
!

css51Wiki
	^'
#wikiPage {
	margin: 10px 15px 10px 10px;
	padding-top: 20px;
	font-size: 90%;
	text-align: left;
	margin-top/* */: 0; /* IE5.0 Win wont see this - fixes weird float bug for hp */
	}
html>body #wikiPage  { margin-top: 0;   }
#wikiPage { margin-left: 15px; padding-left: 0; }
#wikiPage td { font-size: 80% }
#wikiPage input, textarea { font-size: 100% }
#wikiPage table.webGrid { font-size: 120% }
table.wikiTable td { border: thin solid black; padding: 1px; margin: 0px }
'
!

css9Hide
 ^'
.print { display: none; }
#printHeader { display: none; }
#documentTitlePrint { display: none; }
#printFooter { display: none; }
.printOnly { display: none; }
.screenOnly { display: show; }


'
!

cssTabs1
	^'
/*from A List Apart article: http://www.alistapart.com/articles/slidingdoors/ */
/*WebTabs newClass: #tabs1 but dont forget to define class tabs1selected too !! */

ul.tabs1 {
  float:left;
  width:100%;
  background:#DAE0D2 url("/img/tab1bggif.gif") repeat-x bottom;
  font-size:10px;
  line-height:normal;
  margin:0;
  padding:10px 0 0 0;
  list-style:none;
  }
ul.tabs1 li {
  float:left;
  background:url("/img/tab1leftgif.gif") no-repeat left top;
  margin:0;
  padding:0 0 0 9px;
  }
ul.tabs1 a, ul.tabs1 b {
  float:left;
  display:block;
  background:url("/img/tab1rightgif.gif") no-repeat right top;
  padding:5px 15px 4px 6px;
  text-decoration:none;
  font-weight:bold;
  color:#765;
  }
/* Commented Backslash Hack
   hides rule from IE5-Mac \*/
ul.tabs1 a {float:none;}
/* End IE5-Mac hack */
ul.tabs1 a:hover {
  color:#333;
  }
ul.tabs1 li.tabs1selected {
  background-image:url("/img/tab1leftongif.gif");
  }
ul.tabs1 li.tabs1selected b {
  background-image:url("/img/tab1rightongif.gif");
  color:#333;
  padding-bottom:5px;
  }
'
!

cssTabs2
	^'
/*WebTabs newClass: #tabs2 but dont forget to define here class tabs2selected too !! */

ul.tabs2 {
	height: 20px;
	margin: 0;
	padding-left: 10px;
	background: url("/img/tab2bottomgif.gif") repeat-x bottom;
	}
ul.tabs2, ul.tabs2 li {
	margin: 0;
	padding: 0;
	display: inline;
	list-style-type: none;
	}
ul.tabs2 a:link, ul.tabs2 a:visited, ul.tabs2 b {
	float: left;
	background: #f3f3f3;
	font-size: 10px;
	line-height: 14px;
	font-weight: bold;
	padding: 2px 10px 2px 10px;
	margin-right: 4px;
	border: 1px solid #ccc;
	text-decoration: none;
	color: #666;
	}
ul.tabs2 a:hover {
	background: #fff;
	}
ul.tabs2 li.tabs2selected b {
	border-bottom: 1px solid #fff;
	background: #fff;
	color: #000;
	}
'
!

cssTabs3
	^'
/*WebTabs newClass: #tabs3 but dont forget to define here class tabs3selected too !! */

ul.tabs3 {
	border-top-width: 2px;
	border-right-width: 2px;
	border-bottom-width: 2px;
	border-left-width: 2px;
	border-bottom-style: solid;
	border-top-color: #CCCCCC;
	border-right-color: #CCCCCC;
	border-bottom-color: #CCCCCC;
	border-left-color: #CCCCCC;
}
ul.tabs3 li {
	background-color: #f0f0e7;
	background-repeat: repeat-x;
	padding: 0px;
	border-top: 2px solid #CCCCCC;
	border-right: 2px none #FFFFFF;
	border-bottom: 0px none #CCCCCC;
	border-left: 2px none #FFFFFF;
	background-position: left center;
	color: #000000;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: 60px;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
	vertical-align: baseline;
	}
ul.tabs3 a:link {
	background-color: #f0f0e7;
	background-repeat: repeat-x;
	padding: 4px;
	border-top: 0px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 0px none #FFFFFF;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #336699;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
}
ul.tabs3 a:visited {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 2px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 0px none #CCCCCC;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #336699;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 60px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
	vertical-align: baseline;
	list-style-image: url(back1.gif);
}
ul.tabs3 a:hover {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 2px solid #999999;
	border-right: 1px solid #CCCCCC;
	border-bottom: 2px none #FFFFFF;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #FF9900;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
}
ul.tabs3 li.tabs3selected {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 0px solid #CCCCCC;
	border-right: 0px none #FFFFFF;
	border-bottom: 2px solid #CCCCCC;
	border-left: 0px none #FFFFFF;
	background-position: left center;
	color: #FF9900;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
}
'
!

cssTabs4
	^'
/*WebTabs newClass: #tabs4 but dont forget to define here class tabs4selected too !! */

ul.tabs4 {
	border-top-width: 1px;
	border-right-width: 1px;
	border-bottom-width: 1px;
	border-left-width: 1px;
	border-bottom-style: solid;
	border-top-color: #CCCCCC;
	border-right-color: #CCCCCC;
	border-bottom-color: #CCCCCC;
	border-left-color: #CCCCCC;
}
ul.tabs4 li {
	background-color: #f0f0e7;
	background-repeat: repeat-x;
	padding: 0px;
	border-top: 2px solid #CCCCCC;
	border-right: 2px none #FFFFFF;
	border-bottom: 0px none #CCCCCC;
	border-left: 2px none #FFFFFF;
	background-position: left center;
	color: #000000;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: 60px;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
	vertical-align: baseline;
}
ul.tabs4 a:link {
	background-color: #f0f0e7;
	background-repeat: repeat-x;
	padding: 4px;
	border-top: 0px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 0px none #FFFFFF;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #336699;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
}
ul.tabs4 a:visited {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 2px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 2px solid #CCCCCC;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #336699;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 60px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
	vertical-align: baseline;
	list-style-image: url(back1.gif);
}
ul.tabs4 a:hover {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 2px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 2px none #FFFFFF;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #FF9900;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
}
ul.tabs4 li.tabs4selected {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 0px solid #CCCCCC;
	border-right: 0px none #FFFFFF;
	border-bottom: 2px solid #CCCCCC;
	border-left: 0px none #FFFFFF;
	background-position: left center;
	color: #FF9900;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
}
'
!

cssTabs5
	^'
ul.tabs5 {
    float:left;
    width:600px;
    background:#DAE0D2 url("/img/tab5bggif.gif") repeat-x bottom;
    font-size:93%;
    line-height:normal;
    text-decoration: none;
    color: #333333;
    margin:0;
    padding:10px 10px 0;
    list-style:none;
    }
ul.tabs5 li {
    float:left;
    background:url("/img/tab5rightgif.gif") no-repeat right top;
    margin:0;
    padding:0 0 0 ;
    }
ul.tabs5 a, ul.tabs5 b {
   display:block;
   background:url("/img/tab5leftgif.gif") no-repeat left top;
   padding:5px 15px 4px 6px;
   text-decoration: none;
   color: #006699;
   font-family: Arial, Helvetica, sans-serif;
   font-weight: bold;
   font-size: 12px;
   }

/* Commented Backslash Hack
   hides rule from IE5-Mac \*/
ul.tabs5 a {float:none;}
/* End IE5-Mac hack */
ul.tabs5 a:hover {
  color:#333;
  }
ul.tabs5 li.tabs5selected {
  background-image:url("/img/tab5rightongif.gif");
  }
ul.tabs5 li.tabs5selected b {
  background-image:url("/img/tab5leftongif.gif");
  padding-bottom:5px;
  color: #666666;
  font-family: Arial, Helvetica, sans-serif;
  }
ul.tabs5 a:hover {
  color: #EFEFE6;
  }
'
!

pageContentWideWidth
	"for things in extensionElement, which is full page wide"
	^800
!

pageContentWidth
	^660
!

pageWidth
	^800
! !

!WebStyle methodsFor:'testing'!

isBrowserMSIE
	^self session isFromMSIE
!

isBrowserNetscape
	^self session isFromNetscape
! !

!WebStyle methodsFor:'texts'!

addHelpText
	^'Add help page'
!

fontSizeText
	^'font size:'
!

guestUserText
	^'Guest'
!

loginBelowMessage
	^''
!

loginButton
	^'Login'
!

loginErrorText
	^'<b style={color:red}>Login failed!! Please check your entry and try again!!</b>'
!

loginText
	^'Login'
!

loginTitle
	^'AIDA/Web Login'
!

loginWelcomeMessage
	^'<h1>Welcome to AIDA/Web Smalltalk Web Application Server!!</h1>
      <br><br>
      Please login to enter a site: '
!

logoutText
	^'Logout'
!

passwordText
	^'Password: '
!

usernameText
	^'Username: '
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SpWeakArray
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Environmental'
!

!SpWeakArray class methodsFor:'instance creation'!

new: anInteger
	"^a WeakArray
	I don't return an instance of myself, I return a real WeakArray."
	^WeakArray new: anInteger
!

withAll: aCollection
	"^a WeakArray
	I don't return an instance of myself at all. I return a real Weak array."
	^ WeakArray withAll: aCollection asArray
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

CompositeResource subclass:#ServerRootComposite
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-HTTP'
!

!ServerRootComposite methodsFor:'accessing'!

helpResolve: aResolution
	^aResolution resolveServerRoot: self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

HTTPMatchField subclass:#HTTPIfMatchField
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

HTTPIfMatchField comment:'From RFC 2616

14.24 If-Match

   The If-Match request-header field is used with a method to make it
   conditional. A client that has one or more entities previously
   obtained from the resource can verify that one of those entities is
   current by including a list of their associated entity tags in the
   If-Match header field. Entity tags are defined in section 3.11. The
   purpose of this feature is to allow efficient updates of cached
   information with a minimum amount of transaction overhead. It is also
   used, on updating requests, to prevent inadvertent modification of
   the wrong version of a resource. As a special case, the value "*"
   matches any current entity of the resource.

       If-Match = "If-Match" ":" ( "*" | 1#entity-tag )

   If any of the entity tags match the entity tag of the entity that
   would have been returned in the response to a similar GET request
   (without the If-Match header) on that resource, or if "*" is given

   and any current entity exists for that resource, then the server MAY
   perform the requested method as if the If-Match header field did not
   exist.

   A server MUST use the strong comparison function (see section 13.3.3)
   to compare the entity tags in If-Match.

   If none of the entity tags match, or if "*" is given and no current
   entity exists, the server MUST NOT perform the requested method, and
   MUST return a 412 (Precondition Failed) response. This behavior is
   most useful when the client wants to prevent an updating method, such
   as PUT, from modifying a resource that has changed since the client
   last retrieved it.

   If the request would, without the If-Match header field, result in
   anything other than a 2xx or 412 status, then the If-Match header
   MUST be ignored.

   The meaning of "If-Match: *" is that the method SHOULD be performed
   if the representation selected by the origin server (or by a cache,
   possibly using the Vary mechanism, see section 14.44) exists, and
   MUST NOT be performed if the representation does not exist.

   A request intended to update a resource (e.g., a PUT) MAY include an
   If-Match header field to signal that the request method MUST NOT be
   applied if the entity corresponding to the If-Match value (a single
   entity tag) is no longer a representation of that resource. This
   allows the user to indicate that they do not wish the request to be
   successful if the resource has been changed without their knowledge.
   Examples:

       If-Match: "xyzzy"
       If-Match: "xyzzy", "r2d2xxxx", "c3piozzzz"
       If-Match: *

   The result of a request having both an If-Match header field and
   either an If-None-Match or an If-Modified-Since header fields is
   undefined by this specification.

'
!

!HTTPIfMatchField class methodsFor:'accessing'!

fieldName
	^'If-Match'
! !

!HTTPIfMatchField methodsFor:'testing'!

isCacheHitFor: anEntity
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent.
anEntity *must* respond to >>entutyTag"

	1 halt.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPAcceptField
	instanceVariableNames:'mediaTypes'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPAcceptField class methodsFor:'accessing'!

fieldName
	^'Accept'
! !

!HTTPAcceptField methodsFor:'accessing'!

mediaTypes
	mediaTypes isNil ifTrue: [mediaTypes := OrderedCollection new].
	^mediaTypes
! !

!HTTPAcceptField methodsFor:'printing'!

valuesAsStringOn: targetStream
	self mediaTypes isEmpty
		ifFalse:
			[targetStream nextPutAll: self mediaTypes first.
			2 to: self mediaTypes size
				do:
					[:methodIndex |
					targetStream
						nextPut: $,;
						nextPutAll: (self mediaTypes at: methodIndex)]].
	^self
! !

!HTTPAcceptField methodsFor:'private'!

parseValueFrom: aString
	mediaTypes := HTTPString subCollectionsFrom: aString delimitedBy: $,.
	^self
! !

!HTTPAcceptField methodsFor:'services'!

combineWith: aHeaderField
	"^self
I simply take my values and concatenate the values of aHeaderField."

	self mediaTypes addAll: aHeaderField mediaTypes.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebFormElement subclass:#WebMenu
	instanceVariableNames:'multiple collection selected aspectToStore objectToStore sort'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Elements'
!

WebMenu comment:'WebMenu is a dropdown menu, which can select single or multiple options. Options are read from a collection, selected options are put in selected. You can set aspect of each option if options are not plain text.

Example:

	WebMenu aspect: #name collection: self persons selected: self selectedPersons

will show dropdown menu of all persons, shown by name. Selected person will be stored in selectedPersons collection. Above menu is  single selection, it can be multiple selection too if you do:

	aWebMenu setMultiple.'
!

!WebMenu class methodsFor:'instance creation'!

aspect: aSymbol collection: aCollection selected: aSelectedCollection
	"Multiple selection menu. Aspect of every element in aColection will be shown in menu.
	Multiple selections will be put in aSelectedCollection. Here also initial selections can be set"
	^self new aspect: aSymbol collection: aCollection selected: aSelectedCollection
!

aspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject
	"Single selection menu.. Aspect of every element in aColection will be shown in menu.
	Single selection will be put in an seelcted aspect of object. Here also initial selection can be set"
	^self new aspect: aSymbol collection: aCollection  selectedToAspect: aSymbol2 of: anObject
!

collection: aCollection selected: aSelectedCollection
	"Multiple selection menu.Every element (text!!) in aColection will be shown in menu.
	Multiple selection will be put in aSelectedCollection. Here also initial selections can be set"
	^self new collection: aCollection selected: aSelectedCollection
!

collection: aCollection selectedToAspect: aSymbol2 of: anObject
	"Single selection menu.. Every element (text!!) in aColection will be shown in menu.
	Single selection will be put in an seelcted aspect of object. Here also initial selection can be set"
	^self new collection: aCollection selectedToAspect: aSymbol2 of: anObject
! !

!WebMenu methodsFor:'accessing'!

aspect: aSymbol collection: aCollection selected: aSelectedCollection
	self aspect: aSymbol.
	self collection: aCollection.
	self selected: aSelectedCollection.
	self setMultiple.
	self size: 4.
!

aspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject
	self multiple: false.
	self aspect: aSymbol.
	self collection: aCollection.
	self aspectToStore: aSymbol2.
	self objectToStore: anObject
!

collection: aCollection selected: aSelectedCollection
	self collection: aCollection.
	self selected: aSelectedCollection.
	self setMultiple.
	self size: 4.
!

collection: aCollection selectedToAspect: aSymbol of: anObject
	self multiple: false.
	self collection: aCollection.
	self aspectToStore: aSymbol.
	self objectToStore: anObject
!

resetMultiple
	self multiple: false
!

setMultiple
	self multiple: true
!

size: aRowNumber
	"number of rows visible in multiple selection menu"
	self attributesAt: #size put: aRowNumber printString
! !

!WebMenu methodsFor:'initialize-release'!

initialize
	super initialize.
	self resetMultiple.
! !

!WebMenu methodsFor:'printing'!

prepareSelected
	"add aspect of objectToStore selected result. There a preselection can reside"
	self aspectToStore isNil ifTrue: [^nil]. "multiple selections used, selected already set"
	self selected: (Set with: (self objectToStore perform: self aspectToStore))
!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self ident, '<select'.
	self printAttributesOn: aStream for: aSession.
	self isMultiple ifTrue: [aStream nextPutAll: ' multiple'].
	aStream nextPutAll: '>'.
	self printOptionsOn: aStream.
	aStream nextPutAll: '</select>'.
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].
!

printOptionsOn: aStream
	| option preselected |
	self collection isEmpty ifTrue: [^nil].
	self prepareSelected.
	preselected := self selected notNil ifTrue: [self selected asSet] ifFalse: [#()].
	aStream nextPutAll: '<option></option>'. "empty choice"
	self collection do: [:each |
		option := self aspect isNil ifTrue: [each] ifFalse: [each perform: self aspect].
		option := AIDASite convertToWeb: option on: self app session.
		aStream nextPutAll: '<option'.
		aStream nextPutAll: ((preselected includes: each) ifTrue: [' selected>'] ifFalse: ['>']).
		aStream nextPutAll: option; nextPutAll: '</option> ' ]
! !

!WebMenu methodsFor:'private'!

acceptFormInputFrom: aPostDataArray
	| option result values |
	self selected isNil ifTrue: [self selected: OrderedCollection new]. "we need a collection!! "
	self selected copy do: [:each | self selected remove: each].
	values := aPostDataArray class == Dictionary
		ifTrue:  [Set new add: (aPostDataArray at: self name); yourself]
		ifFalse: [(aPostDataArray allAt: self name) asSet].
	self selected addAll:
		(self collection select:  [:each |
			option := self aspect isNil ifTrue: [each] ifFalse: [each perform: self aspect].
			option := AIDASite convertToWeb: option on: self app session.
			values includes: option trimBlanks]).
	self aspectToStore notNil ifTrue:
		[result := self selected notEmpty ifTrue: [self selected asOrderedCollection first] ifFalse: [nil].
		self objectToStore perform: (self aspectToStore asString, ':') asSymbol with: result]
!

aspectToStore
	^aspectToStore
!

aspectToStore: aSymbol
	"a name of a method to call on objectToStore, to write down a result from selection"
	aspectToStore := aSymbol
!

collection
	^collection
!

collection: aCollection
	collection := aCollection
!

joinToForm: aWebForm
	aWebForm fields keysAndValuesDo: [:fname :element |
		element == self ifTrue: [self name: fname]. ^self]
!

multiple
	^multiple
!

multiple: aBoolean
	multiple := aBoolean
!

objectToStore
	^objectToStore
!

objectToStore: anObject
	"an object in which to write down a result from selection"
	objectToStore := anObject
!

selected
	"selected options wiil be stored here"
	^selected
!

selected: aCollection
	selected := aCollection
!

shouldIdent
	^false
! !

!WebMenu methodsFor:'testing'!

isEmpty
	"input field is empty or nil"
	| vlue |
	self objectToStore notNil ifTrue: [vlue := self objectToStore perform: self aspectToStore].
	^vlue isNil
		or: [((vlue isKindOf: String) and: [vlue isEmpty])
			or: [(vlue isKindOf: Number) and: [vlue = 0] ]]
!

isMenu
	^true
!

isMultiple
	"multiple selection?"
	^self multiple
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#HTTPReadStreamTest
	instanceVariableNames:'stream'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!HTTPReadStreamTest methodsFor:'private'!

crlfOn: ws 
	ws
		nextPut: Character cr;
		nextPut: Character lf
! !

!HTTPReadStreamTest methodsFor:'testing'!

testLinesWithDoubleCRLF
	| ws comparisonString |
	comparisonString := 'abcd'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	self crlfOn: ws.
	self crlfOn: ws.
	stream := HTTPReadStream onStream: (ReadStream on: ws contents).
	self assert: stream nextLine = comparisonString.
	self assert: stream nextLine = ''
!

testSingleLineWithCR
	| ws comparisonString errored |
	comparisonString := 'abcd' , (String with: Character cr) , 'efg'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	ws nextPut: Character cr.
	stream := HTTPReadStream onStream: (ReadStream on: ws contents).
	errored := false.
	SpExceptionContext 
		for: [stream nextLine]
		on: SpError
		do: [:ex | errored := true].
	self assert: errored
!

testSingleLineWithCRLF
	| ws comparisonString |
	comparisonString := 'abcd'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	self crlfOn: ws.
	stream := HTTPReadStream onStream: (ReadStream on: ws contents).
	self assert: stream nextLine = comparisonString
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

HTTPMatchField subclass:#HTTPIfNoneMatchField
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

HTTPIfNoneMatchField comment:'This is a confitional header field.  The HTTP client is asking for a resource on the basis of this condition.  So, we need to have first found the resource, and then we can considder the condition, as follows ...

From RFC 2616:

14.26 If-None-Match

   The If-None-Match request-header field is used with a method to make
   it conditional. A client that has one or more entities previously
   obtained from the resource can verify that none of those entities is
   current by including a list of their associated entity tags in the
   If-None-Match header field. The purpose of this feature is to allow
   efficient updates of cached information with a minimum amount of
   transaction overhead. It is also used to prevent a method (e.g. PUT)
   from inadvertently modifying an existing resource when the client
   believes that the resource does not exist.

   As a special case, the value "*" matches any current entity of the
   resource.

       If-None-Match = "If-None-Match" ":" ( "*" | 1#entity-tag )

   If any of the entity tags match the entity tag of the entity that
   would have been returned in the response to a similar GET request
   (without the If-None-Match header) on that resource, or if "*" is
   given and any current entity exists for that resource, then the
   server MUST NOT perform the requested method, unless required to do
   so because the resource''s modification date fails to match that
   supplied in an If-Modified-Since header field in the request.
   Instead, if the request method was GET or HEAD, the server SHOULD
   respond with a 304 (Not Modified) response, including the cache-
   related header fields (particularly ETag) of one of the entities that
   matched. For all other request methods, the server MUST respond with
   a status of 412 (Precondition Failed).

   See section 13.3.3 for rules on how to determine if two entities tags
   match. The weak comparison function can only be used with GET or HEAD
   requests.

   If none of the entity tags match, then the server MAY perform the
   requested method as if the If-None-Match header field did not exist,
   but MUST also ignore any If-Modified-Since header field(s) in the
   request. That is, if no entity tags match, then the server MUST NOT
   return a 304 (Not Modified) response.

   If the request would, without the If-None-Match header field, result
   in anything other than a 2xx or 304 status, then the If-None-Match
   header MUST be ignored. (See section 13.3.4 for a discussion of
   server behavior when both If-Modified-Since and If-None-Match appear
   in the same request.)

   The meaning of "If-None-Match: *" is that the method MUST NOT be
   performed if the representation selected by the origin server (or by
   a cache, possibly using the Vary mechanism, see section 14.44)
   exists, and SHOULD be performed if the representation does not exist.
   This feature is intended to be useful in preventing races between PUT
   operations.

   Examples:

       If-None-Match: "xyzzy"
       If-None-Match: W/"xyzzy"
       If-None-Match: "xyzzy", "r2d2xxxx", "c3piozzzz"
       If-None-Match: W/"xyzzy", W/"r2d2xxxx", W/"c3piozzzz"
       If-None-Match: *

   The result of a request having both an If-None-Match header field and
   either an If-Match or an If-Unmodified-Since header fields is
   undefined by this specification.'
!

!HTTPIfNoneMatchField class methodsFor:'accessing'!

fieldName
	^'If-None-Match'
! !

!HTTPIfNoneMatchField methodsFor:'testing'!

isCacheHitFor: anEntity
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent.  So in my case, I'm looking to see that the entity has a tag which is in my collection of entityTags.
anEntity *must* respond to >>entityTag"

	^self entityTags includes: anEntity entityTag
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

ImageStream subclass:#BosImageStream
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Imaging'
!

BosImageStream comment:'BosImageStream

Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.

'
!

!BosImageStream class methodsFor:'copyright'!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'
!

system
	^'Goodies'
!

version
	^'003'
! !

!BosImageStream class methodsFor:'examples'!

example1
        "BosImageStream example1."

        | image filename stream |
        image := Image fromUser.
        filename := SpFilename named:'zzz.bos'.
        stream := BosImageStream on: filename writeStream.
        [Cursor write showWhile: [stream nextPutImage: image]]
                valueNowOrOnUnwindDo: [stream close].
        ^image
!

example2
        "BosImageStream example2."

        | filename stream image |
        filename := SpFilename named:'zzz.bos'.
        stream := BosImageStream on: filename readStream.
        [Cursor read showWhile: [image := stream nextImage]]
                valueNowOrOnUnwindDo: [stream close].
        stream show: image.
        ^image
!

example3
        "BosImageStream example3."

        | image filename stream |
        image := Image fromUser.
        filename := SpFilename named:'zzz.bos'.
        stream := BosImageStream on: filename writeStream.
        [Cursor write
                showWhile:
                        [stream compute: [:value | Transcript cr; show: value printString].
                        stream nextPutImage: image]]
                valueNowOrOnUnwindDo: [stream close].
        ^image
!

example4
        "BosImageStream example4."

        | filename stream image |
        filename := SpFilename named:'zzz.bos'.
        stream := BosImageStream on: filename readStream.
        [Cursor read
                showWhile:
                        [stream compute: [:value | Transcript cr; show: value printString].
                        image := stream nextImage]]
                valueNowOrOnUnwindDo: [stream close].
        stream show: image.
        ^image
!

example5
        "BosImageStream example5."

        | image filename stream progress |
#fixme.
        image := Image fromUser.
        filename := SpFilename named:'zzz.bos'.
        stream := BosImageStream on: filename writeStream.
        [Cursor write
                showWhile:
                        [progress := Progress new.
                        stream compute: [:value | progress value: value].
                        progress message: 'writing bos...'.
                        progress do: [stream nextPutImage: image]]]
                valueNowOrOnUnwindDo: [stream close].
        ^image
!

example6
        "BosImageStream example6."

        | filename stream image progress |
#fixme.
        filename := SpFilename named:'zzz.bos'.
        stream := BosImageStream on: filename readStream.
        [Cursor read
                showWhile:
                        [progress := Progress new.
                        stream compute: [:value | progress value: value].
                        progress message: 'reading bos...'.
                        progress do: [image := stream nextImage]]]
                valueNowOrOnUnwindDo: [stream close].
        stream show: image.
        ^image
! !

!BosImageStream methodsFor:'accessing'!

nextImage
	| size process bos image |
	self readHeader isNil ifTrue: [^nil].
	size := imageStream size max: 1.0e-6.
	process := [[imageStream position < size]
				whileTrue:
					[self progress: imageStream position / size.
					(Delay forMilliseconds: 3) wait]] newProcess.
	process priority: Processor activeProcess priority + 5.
	process resume.

	[bos := BinaryObjectStorage onOldNoScan: imageStream.
	self progress: 0.
	image := bos next.
	self progress: 1]
		valueNowOrOnUnwindDo:
			[process terminate.
			process := nil].
	^image
!

nextPutImage: anImage
	| size process bos bytes |
	(anImage isKindOf: Image) not ifTrue: [^self errorCanNotWrite].
	self writeHeader.
	bytes := WriteStream on: (bytes := ByteArray new: 1024).
	self size timesRepeat: [bytes nextPut: 0].
	bos := BinaryObjectStorage onNew: bytes.
	bos nextPut: anImage asImage.
	size := bytes contents size max: 1.0e-6.
	process := [[imageStream position < size]
				whileTrue:
					[self progress: imageStream position / size.
					(Delay forMilliseconds: 3) wait]] newProcess.
	process priority: Processor activeProcess priority + 5.
	process resume.

	[bos := BinaryObjectStorage onNew: imageStream.
	self progress: 0.
	bos nextPut: anImage asImage.
	self progress: 1]
		valueNowOrOnUnwindDo:
			[process terminate.
			process := nil].
	^anImage
! !

!BosImageStream methodsFor:'decoding'!

readHeader
	(self hasMagicNumber: 'BosImage' asByteArray)
		ifFalse: [^self errorCanNotRead]
! !

!BosImageStream methodsFor:'encoding'!

writeHeader
	self nextPutAll: 'BosImage' asByteArray.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#History
	instanceVariableNames:'dates values changedDates authors comments historyCollection'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Support'
!

!History class methodsFor:'instance creation'!

new
	^super new initialize
! !

!History class methodsFor:'examples'!

tests
	"some test of histories. Use it directly from code with doIt/printIt/inspectIt "

	| history |
	history := History new.
	history value: 0 dated: (Date today ) author: '' comment: ''.
	history value: -2000 dated: (Date today - (365*100) -2) author: '' comment: ''.
	history value: -3 dated: (Date today -3) author: '' comment: ''.
	history value: -1 dated: (Date today -1) author: '' comment: ''.
	history value: 2 dated: (Date today +2) author: '' comment: ''.
	history value: 1 dated: (Date today +1) author: '' comment: ''.
! !

!History class methodsFor:'odb specific'!

instancesAreForwarders
	"Gemstone"

	^false
! !

!History methodsFor:'accessing'!

historyOfChanges

	"return a history of all changes of value. It is returned as ordered collection of collections, each with:
	valid from date
	valid to date (for last change: nil)
	new value
	date of change
	author of change
	comment of change

Returned collection has the oldest change (by valied from date) as first, the newest as last. "
!

value
	"get the curently valid value"

	^self valueDated: Date today

"History new value"
!

value: aValue author: aString comment: aCommentString
	"change a value of time series, which will be valid immediately - today. You should state author and a short comment about changes. see other methods for detailed explanation"

	self value: aValue
		dated: Date today
		author: aString
		comment: aCommentString
!

value: aValue dated: aDate author: aString comment: aCommentString
	""

	| index |

	index := self indexForDate: aDate.
	index isNil   "older than any existing or first"
		ifTrue:
			[self
				insertValue: aValue
				dated: aDate
				author: aString
				comment: aCommentString
				beforeIndex: 1.
			^self].

"Sprememba 18.11.1998 Sivec, prej 'index >= self dates  size'."
	index > self dates  size  "newer than any existing"
		ifTrue:
			[self addValue: aValue dated: aDate author: aString comment: aCommentString. ^self].


	(index ~= 0 and: [(self dates at: index) = aDate asDays]) "already exists"
		ifTrue:
			[self
				changeValue: aValue
				author: aString
				comment: aCommentString
				onIndex: index.
			^self].

		self    "insert new somewhere in the middle"
			insertValue: aValue
			dated: aDate
			author: aString
			comment: aCommentString
			beforeIndex: index+1.



"History new value: 1234 dated: Date today author: 'Janko' comment: 'test'"
!

valueDated: aDate
	"get the value from history, which was valid on specified date. Returns nil if aDate is older from
	oldest entry in history"


	| index |
	index := self indexForDate: aDate.
	index = 0 ifTrue: [^nil].
	index = nil ifTrue: [^nil].
	^self values at: index.
! !

!History methodsFor:'initialize - release'!

initAuthors
	authors := OrderedCollection new.
!

initChangedDates
	changedDates := OrderedCollection new.
!

initComments
	comments := OrderedCollection new.
!

initDates
	"adds default entry: 1.1.1901"
	dates := OrderedCollection new.
!

initValues
	values := OrderedCollection new.
!

initialize
	"2.11.1998 all inits do not add default values anymore"

	self initDates.
	self initValues.
	self initChangedDates.
	self initAuthors.
	self initComments.
! !

!History methodsFor:'printing'!

printString

	^('aHistory: ', self value printString)
! !

!History methodsFor:'private - accessing'!

authors
	" a collection of authors, which made changes, (as a String or reference to a WebUser)"
	^authors
!

changedDates
	" a collection of dates, when value was changed in asDays format"
	^changedDates
!

comments
	" a collection of comments about changes"
	^comments
!

dates
	" a collection of dates of changes in asDays format"
	^dates
!

historyCollection
	"this is an ordered collection of array with year, day in year, time, value, active flag.
	Collection is ordered from oldest to newest version of value. Active flag is used to
	'delete' some version from history, but you can still have a trace, who/when some
	change occured.

	3.11.98 NOT USED anymore. Here just for migration!!"


	historyCollection isNil ifTrue: [self initHistoryCollection].
	^historyCollection
!

indexForDate: aDate

	"return index of entry in dates collection, which fits most to the specified date. If no direct
	entry on a specified date exist, then entry for previous date is used. If aDate is older than
	any date in collection, nil is returned!!"


	| first last days mdays index |

	first := 1. last := self dates size.
	last = 0 ifTrue: [^nil].
	days := aDate asDays.
	days >= self dates last ifTrue: [^last].
	days < self dates first ifTrue: [^nil].
	[last >= first] whileTrue:
		[ "(first = last and: [days = (self dates at: first)]) ifTrue: [^first].  " " not needed!! "
		index := (first + last) // 2.
		mdays := self dates at: index.
		days = mdays ifTrue: [^index].
		days < mdays
			ifTrue: [last := index - 1.]
			ifFalse: [first := index + 1.]].
"2.11.98 Sivec prej :
		^1 max: index - 1.
"
	index := (first + last) // 2.
	^1 max: index.




"
| h |
h := History new.
h dates
	add: (Date today) asDays;
	add: (Date today + 1) asDays;
	add: (Date today + 3) asDays;
	add: (Date today + 4) asDays.
Transcript cr;show: (h indexForDate: Date today - 1) printString.
Transcript cr;show: (h indexForDate: Date today + 1) printString.
Transcript cr;show: (h indexForDate: Date today + 2) printString.
Transcript cr;show: (h indexForDate: Date today + 3) printString.
h inspect.
"





"
	self historyCollection keysAndValuesDo: [:index :array |
		(self activeFromArray: array)
			ifTrue:
				[(self dateFromArray: array) < (aDate + 1)
					ifTrue: [prevIndex := index]
					ifFalse: [^prevIndex]   ] ].
	^prevIndex
"
!

initHistoryCollection
	historyCollection := OrderedCollection new.
!

newestDate

	"return a date of newest version of value"

	self dates isEmpty
		ifTrue: [^nil]
		ifFalse:        [^Date fromDays: self dates last]

"History new newestDate"
!

newestValue

	"return a newest version of value in historyCollection."

	self values isEmpty
		ifTrue: [^nil]
		ifFalse:        [^self values last]


"History new newestValue"
!

oldestDate

	"return a date of oldest version of value"

	self dates isEmpty
		ifTrue: [^nil]
		ifFalse:        [^self dates first]


"History new oldestDate"
!

oldestValue

	"return a oldest version of value"

	self values isEmpty
		ifTrue: [^nil]
		ifFalse:        [^self values last]


"History new oldestValue"
!

values
	" a collection of values, each valid from date in dates at the same index"
	^values
! !

!History methodsFor:'private - adding-removing'!

addValue: aValue dated: aDate author: aString comment: aCommentString
	"adds data, which is newer than any existing one"
	self dates add: aDate asDays.
	self values add: aValue.
	self changedDates add: Date today asDays.
	self authors add: aString.
	self comments add: aString.
!

changeValue: aValue author: aString comment: aCommentString onIndex: anIndexNumber
	"change data in a specificied index"
	self values at: anIndexNumber put: aValue.
	self changedDates at: anIndexNumber put: Date today asDays.
	self authors at: anIndexNumber put: aString.
	self comments at: anIndexNumber put: aString.
!

hasDuplicateDates

	"maintenance - check if more than one entry with the same date exist"

	| unique |
	unique := Set new.
	self dates do: [: date | (unique includes: date)
		ifTrue: [^true]
		ifFalse: [unique add: date] ].
	^false
!

insertValue: aValue dated: aDate author: aString comment: aCommentString beforeIndex: anIndex
	"adds data in position before specified index"
	self dates add: aDate asDays beforeIndex: anIndex.
	self values add: aValue beforeIndex: anIndex.
	self changedDates add: Date today asDays beforeIndex: anIndex.
	self authors add: aString beforeIndex: anIndex.
	self comments add: aString beforeIndex: anIndex.
!

removeAllNils
	"REPARING BAD HISTORIES - remove all nil entries. Initialize if no more entries"

	2 to: self values size do: [:index |
		(self values at: index) isNil ifTrue:
			[self removeIndex: index. ^self removeAllNils] ]
!

removeDuplicateDates

	"maintenance - remove all duplicate entries with same dates. Live last one"

	| date index |
	self hasDuplicateDates ifTrue:
		[date := 0. index := nil.
		1 to: self dates size do:
			[:inx |
				(self dates at: inx) = date ifTrue: [index := inx].
				date := self dates at: inx].
		index notNil
			ifTrue:
				[self removeIndex: index-1.
				self removeDuplicateDates].
		 ].
!

removeIndex: aNumber
	"remove all entries on specified index"
	self dates removeIndex: aNumber.
	self values removeIndex: aNumber.
	self changedDates removeIndex: aNumber.
	self authors removeIndex: aNumber.
	self comments removeIndex: aNumber.
!

removeLastNil
	"REPARING BAD HISTORIES - remove last entry if value nil. Initialize if no more entries"
	self values isEmpty
		ifTrue:
			[self initialize. self values removeLast; addLast: true.
			Transcript cr; show: 'init, true']
		ifFalse: [self values last isNil ifTrue:
			[self removeIndex: (self dates size).
			self removeLastNil] ]
! !

!History methodsFor:'private - history arrays'!

activeFromArray: anArray

	"return a active flag from entries in history array"

	^anArray at: 5
!

arrayWithDate: aDate time: aTime value: aValue active: aBoolean

	"return a array with argument vaules for entry to history collection"

	| array |
	array := Array new: 5.
	array
		at: 1 put: aDate year;
		at: 2 put: aDate day;
		at: 3 put: (aTime notNil ifTrue: [aTime asSeconds] ifFalse: [0]);
		at: 4 put: aValue;
		at: 5 put: aBoolean.
	^array
!

dateFromArray: anArray

	"return a date from entries in history array"

	^Date
		newDay: (anArray at: 2)
		year: (anArray at: 1)
!

migrateHistoryCollection

	"migrate from historyCollection to bunch of collections. Remove duplicates"

	| date |
	date := nil.
	self initialize.
	self historyCollection reverseDo: [:array |
		date = (self dateFromArray: array)
			ifFalse:
				[self
					value: (self valueFromArray: array)
					dated: (self dateFromArray: array)
					author: ('')
					comment: ('').
				date := self dateFromArray: array] ].


"
Janko := History selectFromOdb select: [:h | h historyCollection size > 10].
(Janko at: 3) migrateHistoryCollection
Janko do: [:each | each migrateHistoryCollection].
Janko  select: [:h | h dates size > 3].
"
!

timeFromArray: anArray

	"return a time from entries in history array"

	^Time fromSeconds: (anArray at: 3)
!

valueFromArray: anArray

	"return a value from entries in history array"

	^anArray at: 4
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SwazooCacheControlTest
	instanceVariableNames:'resource cacheTarget request cacheControl'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!SwazooCacheControlTest methodsFor:'running'!

setUp
        | directory firstFile ws |      
        directory := SpFilename named:'fResTest'.
        directory exists ifFalse: [directory makeDirectory].
        firstFile := directory construct: 'abc.html'.
        ws := firstFile writeStream.
        [ws nextPutAll: 'hello'] ensure: [ws close].
        resource := FileResource uriPattern: 'foo' filePath: 'fResTest'.
        request := HTTPGet request: 'foo/abc.html'.
        URIResolution resolveRequest: request startingAt: resource.
        cacheControl := SwazooCacheControl new request: request
                                cacheTarget: (cacheTarget := resource fileFor: request)
!

tearDown
        ((SpFilename named:'fResTest')  construct: 'abc.html') delete.
        (SpFilename named:'fResTest') delete
! !

!SwazooCacheControlTest methodsFor:'testing'!

testIfModifiedSinceModified
	| response timestampInThePast |
	request := HTTPGet request: 'foo/abc.html'.
	timestampInThePast := SpTimestamp fromDate: (Date today subtractDays: 1)
				andTime: Time now.
	request headers addField: (HTTPIfModifiedSinceField new 
				valueFrom: timestampInThePast asRFC1123String).
	cacheControl := SwazooCacheControl new request: request
				cacheTarget: cacheTarget.
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfModifiedSince.
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self 
		assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified') timestamp 
				= cacheTarget lastModified
!

testIfModifiedSinceNot
	| response |
	request headers addField: (HTTPIfModifiedSinceField new 
				valueFrom: cacheTarget lastModified asRFC1123String).
	self assert: cacheControl isNotModified.
	self assert: cacheControl isIfModifiedSince not.
	response := HTTPResponse notModified.
	cacheControl addResponseHeaders: response.
	self 
		assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified') timestamp 
				= cacheTarget lastModified
!

testIfNoneMatchHeaderMatch
	"same etag"

	| response |
	request headers addField: (HTTPIfNoneMatchField new addEntityTag: cacheTarget etag).
	self assert: cacheControl isNotModified.
	self deny: cacheControl isIfNoneMatch.

	"do NOT include last-modified"
	response := HTTPResponse notModified.
	cacheControl addResponseHeaders: response.
	self assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified' ifNone: [nil])  isNil
!

testIfNoneMatchHeaderNone
	"same etag"

	| response |
	request := HTTPGet request: 'foo/abc.html'.
	request headers addField: (HTTPIfNoneMatchField new valueFrom: 'blah').
	cacheControl := SwazooCacheControl new request: request
				cacheTarget: cacheTarget.
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfNoneMatch.
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self 
		assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified') timestamp 
				= cacheTarget lastModified
!

testNoHeaders
	| response |
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfNoneMatch.
	self assert: cacheControl isIfModifiedSince.

	"add both"
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self 
		assert: (response headers fieldNamed: 'ETag') entityTag = cacheTarget etag.
	self assert: (response headers fieldNamed: 'Last-Modified') timestamp 
				= cacheTarget lastModified
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SpTranscript
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'SPort-Environmental'
!

!SpTranscript class methodsFor:'logging'!

cr
	^ SpEnvironment isHeadless
		ifTrue: [self]
		ifFalse: [Transcript cr]
!

nextPut: anObject
	^self show: (String with: anObject)
!

nextPutAll: aCollection
	^self show: aCollection
!

show: aString
	^ SpEnvironment isHeadless
		ifTrue: [self]
		ifFalse: [Transcript show: aString]
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebInputField subclass:#WebAutocompleteField
	instanceVariableNames:'choicesAspect choicesObject choiceAspect elementToUpdate'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

!WebAutocompleteField class methodsFor:'instance creation'!

aspect: aSymbol for: anObject choicesAspect: aChoicesSymbol for: aChoicesObject
	"choicesAspect method is called with our field as argument on aChoicesObject.
	It must return a collection of strings"
	"example: myObject searchFor: aString (choicesAspect is #searchFor: )"
	^self new
		aspect: aSymbol for: anObject;
		choicesAspect: aChoicesSymbol for: aChoicesObject
!

aspect: aSymbol for: anObject choicesAspect: aChoicesSymbol for: aChoicesObject
	afterPostAndUpdate: aWebElementOrId
	"immediately post and update element, after user has selected one of choices"
	^(self aspect: aSymbol for: anObject choicesAspect: aChoicesSymbol for: aChoicesObject)
		elementToUpdate: aWebElementOrId
!

aspect: aSymbol for: anObject choicesAspect: aChoicesSymbol for: aChoicesObject choiceAspect: aTextSymbol
	"choicesAspect method is called with our field as argument on aChoicesObject.
	It returs a collection of objects, an choice's text
	is retrieved with a call of choiceAspect method on each"
	^self new
		aspect: aSymbol for: anObject;
		choicesAspect: aChoicesSymbol for: aChoicesObject;
		choiceAspect: aTextSymbol
!

aspect: aSymbol for: anObject choicesAspect: aChoicesSymbol for: aChoicesObject choiceAspect: aTextSymbol afterPostAndUpdate: aWebElementOrId
	"choicesAspect method is called with our field as argument on aChoicesObject.
	It returs a collection of objects, an choice's text
	is retrieved with a call of choiceAspect method on each"
	^self new
		aspect: aSymbol for: anObject;
		choicesAspect: aChoicesSymbol for: aChoicesObject;
		choiceAspect: aTextSymbol;
		elementToUpdate: aWebElementOrId
! !

!WebAutocompleteField methodsFor:'Aida-Components'!

printHTMLPageOn: aStream forSession: aSession
	| choicesElement |
	choicesElement := (WebElement newClass: #'auto_complete') parent: self.
	self registerId. choicesElement registerId.
	super printHTMLPageOn: aStream forSession: aSession.
	choicesElement printHTMLPageOn: aStream forSession: aSession.
	self addSetupScriptOn: aStream choicesElement: choicesElement.
! !

!WebAutocompleteField methodsFor:'accessing'!

choiceAspect
	"this method is called on each choice to display choice's text"
	^choiceAspect
!

choiceAspect: aSymbol
	choiceAspect := aSymbol
! !

!WebAutocompleteField methodsFor:'initialize-release'!

initialize
	super initialize.
	self app style ensureJavascriptForScriptaculousInHeader.
	self app style ensureJsResourceForScriptaculous.
! !

!WebAutocompleteField methodsFor:'printing'!

addSetupScriptOn: aStream choicesElement: aChoicesElement
	| url afterUpdateElement idSymbol updateUrl parms |
	url := self ajaxCallUrlExtended, '&ajaxAutocompleteField'.
	afterUpdateElement := self elementToUpdate isNil ifTrue: [''] ifFalse:
		[idSymbol := self elementToUpdate isSymbol
			ifTrue: [self elementToUpdate] ifFalse: [self elementToUpdate registerId. self elementToUpdate id].
		updateUrl := self ajaxCallUrl. parms := self ajaxCallUrlParametersFor: self elementToUpdate.
		'afterUpdateElement: function(element, selectedElement){var field = Form.Element.serialize(''',
			self id asString, '''); new Ajax.Updater(''', idSymbol asString, ''', ''', updateUrl,
			''', {method: ''post'', postBody: field + ''', ('&', parms), ''', evalScripts: true})} '].

	aStream nextPutAll: '<script type="text/javascript">new Ajax.Autocompleter(''',
		self id asString, ''', ''', aChoicesElement id asString, ''', ''', url,
		''', {', afterUpdateElement, '});</script>', self eol.
!

prepareAttributesToPrintOn: aSession
	"if choiceAspect is set, use it!! "
	self choiceAspect isNil ifTrue: [^super prepareAttributesToPrintOn: aSession].
	self value isNil ifTrue: [^nil].
	(self value class canUnderstand: self choiceAspect) ifFalse: [^nil].
	self attributesAt: #value put:
		(WebFormElement autoConvertToString: (self value perform: self choiceAspect) )
! !

!WebAutocompleteField methodsFor:'private'!

choicesAspect
	^choicesAspect
!

choicesAspect: aSymbol
	choicesAspect := aSymbol
!

choicesAspect: aSymbol for: anObject
	"this method is called with our field as argument on that object. It must return a collection of strings"
	"example: myObject searchFor: aString (choicesAspect is #searchFor: )"
	self choicesAspect: aSymbol.
	self choicesObject: anObject
!

choicesObject
	^choicesObject
!

choicesObject: anObject
	choicesObject := anObject
!

elementToUpdate
	^elementToUpdate
!

elementToUpdate: aWebElementOrId
	(aWebElementOrId isKindOf: WebElement) ifTrue: [aWebElementOrId registerId].
	elementToUpdate := aWebElementOrId
!

getChoicesForEntry: aString
	"return list of choices, selected already entered characters in  aString. "
	"always return text strings, not choice objects!!"
	| choices matchString |
	self choiceAspect isNil "one possiblity, direct question to choicesObject"
		ifTrue: [^self choicesObject perform: self choicesAspect with: aString].
	"other possibility, we select internaly from all choices"
	choices := self choicesObject perform: self choicesAspect.
	matchString := aString, '*'.
	choices := choices select: [:each | matchString match: (each perform: self choiceAspect)].
	^choices collect: [:each | each perform: self choiceAspect].
!

saveThroughAdapterValue: aValueString
	| vlue choices |
	vlue :=  AIDASite convertFromWeb: aValueString on: self session. "ensure unicode!!"
	vlue := (WebFormElement autoConvertString:  vlue toObject: self value).
	self choiceAspect notNil ifTrue: "save a real object, not only text!! "
		[choices := self choicesObject perform: self choicesAspect.
		vlue := choices detect: [:each | (each perform: self choiceAspect) = vlue] ifNone: [nil] ].
	self value: vlue.
! !

!WebAutocompleteField methodsFor:'testing'!

isAutocompleteField
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebFrameApp subclass:#WebAdminApp
	instanceVariableNames:'username password newUser newSite'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Admin'
!

!WebAdminApp methodsFor:'accessing'!

newSite
	^newSite
!

newSite: anObject
	newSite := anObject
!

newUser
	^newUser
!

newUser: anUser
	newUser := anUser
!

password
	password isNil ifTrue: [self password: ''].
	^password
!

password: aString
	password := aString.
!

username
	username isNil ifTrue: [self username: ''].
	^username
!

username: aString
	username := aString.
! !

!WebAdminApp methodsFor:'actions'!

actionAddSite
	SwazooServer singleton addSite: self newSite.
	self newSite start.
	self redirectToView: #sites.
!

actionForgoten
	self redirectTo: self site admin view: #passwordSent.
!

actionLogin
	| user |
	user := self site securityManager userNamed: self username withPassword: self password.
	self password: ''.
	user notNil
		ifTrue: [self session user: user. self reportLogin]
		ifFalse: [self error: 'error message from WebStyle!!'. self session logout. ^self].
	self site afterLogin = #lastPage ifFalse: [^self redirectTo: self site afterLogin].
	(user logoutFromUrl notNil and: [self site urlResolver existURL: user logoutFromUrl])
		ifTrue: [self redirectTo: user logoutFromUrl] "back from where we were logout"
		ifFalse: [self redirectTo: (user asPerson notNil ifTrue: [user asPerson] ifFalse: ['/']) ]
!

actionRegistration
	self isRegistrationValid
		ifTrue:
			[self site securityManager addActivatingUser: self newUser.
			self newView: #waitingConfirmation]
		ifFalse: ["just reload registration form again"]
!

actionSites
	self newSite: AIDASite new.
	self newSite uriPattern first
		ip: self observee ip;
		port: self observee port.
	self redirectToView: #addSite.
!

actionUpdateSettings
	[(Delay forMilliseconds: 500) wait.
	self site stop.
	self updateSettings.
	self site start] fork.
	self redirectToView: #redirect
!

prepareSettings
	self observee host: self site host.
	self observee ip: self site ip.
	self observee port: self site port.
!

updateSettings
	self site host: self observee host.
	self site ip: self observee ip.
	self site port: self observee port.
! !

!WebAdminApp methodsFor:'printing'!

viewActivation
	| e id user |
	(self session lastRequest includesQuery: 'userid') ifTrue:
		[id := (self session lastRequest queryAt: 'userid') asInteger.
		(self site securityManager existUserWithId: id) ifTrue:
			[user := self site securityManager userWithId: id.
			 self site securityManager addRegisteredUser: user.
			self session loginUser: user.
			self clear. self title: 'Activation successfull!!'.
			e := WebElement new.
			e addTextH1: 'Activation successfull!!'.
			e addText: 'Congratulations!! You are now a registered user of our portal. You are
			already logged in and your name is shown on the page'.
			^self pageFrameWith: e title: self title] ].

	self clear. self title: 'Activation failed!!'.
	e := WebElement new.
	e addTextH1: 'Activation failed!!'.
	e addText: ' You tried to activate an user account but activation failed. Please send an email to '.
	e addLinkTo: 'info@eranova.si' text: 'Portal Administrator'.
	^self pageFrameWith: e title: self title .
!

viewAddSite
	| e |
	self    title: 'Web sites'.
	e := WebElement new.
	e addTextH1: 'Adding a new web site'. e addBreak.
	e add: self addSiteElement.
	^self pageFrameWith: e title: self title .
!

viewForgoten
	| e f |
	self clear. self title: 'Lost Password'.
	e := WebElement new.
	e addTextH1: 'Lost Password'.
	e addText: ' Enter your username below, click Send me my password, and your password
	will be mailed to you if you gave a valid email address when you registered. If this will not
	work for you (for example, if you forgot your member name or didn''t enter your email address)
	send an email to '.
	e addLinkTo: 'info@eranova.si' text: 'Portal Administrator'.
	f := WebFieldSet newLegend: 'User details'.
	f cell addText: 'My username is: '.
	f newCell add: (WebInputField new aspect: #username for: self).
	f newRow. f newCell addButtonText: 'Send me my password'.
	e add: f.
	^self pageFrameWith: e title: self title .
!

viewLogin
	| e l |
	self clear. self title: self style loginTitle.
	e := WebElement new.
	e scriptBefore: 'Element.hide(''', self searchButton id, ''')'. "remove search button on navbar!!"
	e addText: self style loginWelcomeMessage.
	l := (WebFieldSet newId: #login) legend: self style loginText.
	self inError ifTrue:
		[l cell colspan: 2; addText: self style loginErrorText. self error: nil.
		l newRow. l cell addNbSp. l newRow].
	l cell addText: self style usernameText.
	l newCell add: (WebInputField new aspect: #username for: self;
		focus). "let text cursor be there at the start!! "
	l newRow. l cell addText: self style passwordText.
	l newCell add: (WebInputField new type: #password; aspect: #password for: self).
	l newRow. l newCell addButtonText: self style loginButton.
	e add: l.
	e addText: self style loginBelowMessage.
"
	e newRow. e newCell addGif: #bulletSquareLeftWhiteGif ;
		addLinkTo: self observee text: ' Forgot your password ?' view: 'forgoten'.
	e newRow. e newCell addGif: #bulletSquareLeftWhiteGif ;
		addLinkTo: self observee text: ' New user ?' view: 'registration'.
"
	^self pageFrameWith: e title: self title .
!

viewLogout
	self reportLogout.
	self session logout.
	self username: ''. self password: ''.
	self site securityManager hasFormAuthenticationScheme ifTrue: [^self redirectToView: #login].
	self site securityManager hasHttpAuthenticationScheme ifTrue: [^self redirectTo: '/'].
!

viewMain
	| element |
	self clear.
	self    title: 'Admin'.
	element := WebElement new.
	^self pageFrameWith: element title: self title .
!

viewPasswordSent
	| e |
	self clear. self title: 'Lost Password sent'.
	e := WebElement new.
	e addTextH1: 'Password sent'.
	e addText: ' Your password was sent to email address from your user profile. If you have
      any more troble, please send an email to '.
	e addLinkTo: 'info@eranova.si' text: 'Portal Administrator'.
	^self pageFrameWith: e title: self title .
!

viewRedirect
	| e url |
	self title: 'Restarting a site'.
	e := WebElement new.
	e addText: 'Restarting a site with new settings ...'.
	url := 'http://', self observee host, ':', self observee port printString, '/admin.html?view=settings'.
" this don't work on mozilla!!
	self redirectAfter: 2 toUrl: url.
"
self script: ('<SCRIPT LANGUAGE="JavaScript">
<!!-- Begin
redirTime = "2000";
redirURL = "', url, '";
function redirTimer() { self.setTimeout("self.location.href = redirURL;",redirTime); }
//  End -->
</script>').

	self attributesAt: #onLoad put: 'redirTimer()'.
	^self pageFrameWith: e title: self title .
!

viewRegistration
	| e f |
	self inError ifFalse: [self newUser: WebUser new. self password: ''].
	self clear. self title: 'Registration Form'.
	e := WebElement new.
	e addTextH1: 'Registration Form'.
	e addErrorReport.
	f := WebFieldSet newLegend: 'Personal details'.
	f cell addText: 'Name: '. f newCell addInputFieldAspect: #name for: self newUser. f newRow.
	f cell addText: 'Surname: '. f newCell addInputFieldAspect: #surname for: self newUser. f newRow.
	f cell addText: 'E-mail: '. f newCell addInputFieldAspect: #email for: self newUser. f newRow.
	f cell addText: 'Username: '. f newCell addInputFieldAspect: #username for: self newUser.
	f newRow.
	f cell addText: 'Password: '. f newCell addPasswordFieldAspect: #password for: self. f newRow.
	f cell addText: 'Confirm Password: '. f newCell addPasswordFieldAspect: #password for: self newUser.
	f newRow. f newCell addButtonText: 'Register'.
	e add: f.
	^self pageFrameWith: e title: self title .
!

viewServerRuns
	| element inx runs |
	self clear.
	self site setLastTimeAliveTimestamp.
	self    title: 'Runs for site: ', self site name.
	element := WebElement new.
	element table width: self pageContentWidth.
      element cell color: (self navigatorColor).
	element cell colspan: 6; addText: self title header: 3.
	element newRow color: self tableHeaderColor.
	element cell align: #center; addText: 'nr '.
	element newCell align: #center; addText: 'started '.
	element newCell align: #center; addText: 'last time alive '.
	element newCell align: #center; addText: 'uptime'.
	element newCell align: #center; addText: 'downtime'.
	element newCell align: #center; addText: 'termination'.
	element newRow.
	inx := 1.
	runs := self site runningHistory.
	runs do: [:array |
		inx even ifTrue: [element row color: self reportHeaderColor].
		element cell align: #center; addText: inx printString.
		element newCell align: #right; addText: (self printStamp: (array at: 1)).
		element newCell align: #right; addText: (self printStamp: (array at: 2)).
		element newCell align: #right; addText: (self printSeconds: (array at: 3)).
		element newCell align: #right; addText: (self printSeconds: (array at: 4)).
		element newCell align: #center; addText:
			(array == runs last
				ifTrue: ['running']
				ifFalse: [(array at: 5) ifTrue: ['crashed'] ifFalse: ['normal']]).
		inx := inx + 1.
		element newRow].
	element cell colspan: 6; addRulerSize: 1.
	^self pageFrameWith: element title: self title .
!

viewServerStatistics
	| element |
	self clear.
	self site setLastTimeAliveTimestamp.
	self    title: 'Statistics for site: ', self site name.
	element := WebElement new.
	element table width: self pageContentWidth.
      element cell color: (self navigatorColor).
	element cell colspan: 3; addText: self title header: 3.
	element newRow.
	element cell addText: 'created: '.
	element newCell align: #right; addText: (self printStamp: self session site createdTimestamp).
	element newRow.
	element cell addText: 'started: '.
	element newCell align: #right; addText: (self printStamp: self session site startedTimestamp).
	element newCell align: #right; addLinkTo: self observee text: 'History of runs' view: 'serverRuns'.
	element newRow.
"
	element cell addText: 'last request: '.
	element newCell align: #right; addText: (self printStamp: self session site lastRequestTimestamp).
	element newRow.
	element cell addText: 'last db commit: '.
	element newCell align: #right; addText: (self printStamp: self session site lastCommitTimestamp).
	element newCell align: #right; addLinkTo: self observee text: 'History of runs' view: 'serverRuns'.
	element newRow.
"
	element cell colspan: 3; addRulerSize: 1.
	element newRow.
	element cell addText: 'uptime: '.
	element newCell align: #right; addText: (self printSeconds: self session site uptime).
	element newRow.
	element cell addText: 'total uptime: '.
	element newCell align: #right; addText: (self printSeconds: self session site totalUptime ).
	element newRow.
	element cell addText: 'total downtime: '.
	element newCell align: #right; addText: (self printSeconds: self session site totalDowntime ).
	element newRow.
	element cell addText: 'availability [%]: '.
	element newCell align: #right; addText: (self session site availability printDotString).
	element newRow.
	element cell colspan: 3; addRulerSize: 1.
	element newRow.
	element cell addText: 'today requests: '.
	element newCell align: #right; addText: ((self session site requestsOnDate: Date today) printDotString).
	element newRow.
	element cell addText: 'yesterday requests: '.
	element newCell align: #right;
		addText: ((self session site requestsOnDate: Date today - 1) printDotString).
	element newRow.
	element cell addText: 'all requests: '.
	element newCell align: #right; addText: ((self session site totalRequests) printDotString).
	element newRow.
	element cell colspan: 3; addRulerSize: 1.
	^self pageFrameWith: element title: self title .
!

viewSettings
	| element |
	self clear.
	self    title: 'Settings for site: ', self site name.
	element := WebElement new.
	element table width: 500.
      element cell color: (self navigatorColor).
	element cell addText: self title header: 3.
	element newRow.
	element cell add: (self settingsElementForm: false).
	element newRow.
	element cell addLinkTo: self observee text: '<b>Update settings</b>' view: #updateSettings.
	^self pageFrameWith: element title: self title .
!

viewSites
	| e |
	self    title: 'Web sites'.
	e := WebElement new.
	e addTextH1: 'Virtual web sites on Swazoo web server'. e addBreak.
	e addButtonText: 'Add new web site'. e addBreak.
	e add: self sitesElement.
	^self pageFrameWith: e title: self title .
!

viewTests
	| e inx bundle testClasses versionId |
	self title: 'Test results'.
	e := WebElement new. inx := 1.
	bundle := Store.BundleModel allInstances detect: [:each | each name = 'BiArt'].
	testClasses := bundle definedClasses
		 select: [:each | each inheritsFrom: XProgramming.SUnit.TestCase].
	testClasses := SortedCollection withAll: testClasses sortBlock: [:a :b | a name < b name].
	e addTextH2: 'Unit testing report'.
	e table width: 1. e cell colspan: 3; addRulerSize: 1. e newRow.
	e cell addText: 'Bundle: '. e newCell addTextBold: bundle name. e newCell width: 0.7.
	e newRow.
	e cell addText: 'Version:'. e newCell addText: bundle traceVersionString. e newRow.
	e cell addText: 'Testing date: '. e newCell addText: Date today shortPrintSloString.  e newRow.
	e cell addText: 'Time: '. e newCell addText: Time now printSloString.  e newRow.
	e cell colspan: 3; addText: 'Testing environment: ', 'Cincom VisualWorks Smalltalk v'.
	versionId := ObjectMemory versionId at: 5.
	e cell addText: (versionId // 10) printString, '.', (versionId \\ 10) printString. e newRow.
	e cell colspan: 3; addRulerSize: 1. e newRow.
	e newTable width: 1.
	e newCell width: 0.05; addText: 'Test class/method'. e newCell width: 0.4; align: #right; addText: 'Result'.
	e newCell width: 0.3. e newRow.
	e cell colspan: 4; addRulerSize: 1. e newRow.
	testClasses do: [:cls || suite result |
		e cell addText: inx printString, '.'.  e newCell addText: cls name.
		suite := TestSuite new.
		cls allTestSelectors do: [:each | suite addTest: (cls selector: each)].
		result := [suite run] ifCurtailed: [].
		e newCell align: #right; addTextSmall: result runCount printString, ' tests '.
		result hasPassed
			ifTrue: [e cell addText: 'Passed' color: #green]
			ifFalse: [e cell addText: '<b>Failed</b>' color: #red].
		cls allTestSelectors asSortedCollection do: [:each |
			e newRow. e newCell addNbSp: 4; addTextSmall: each asString.
			e newCell align: #right; addText: '<small>Passed</small>' color: #green].
		e newCell.
		e newRow. inx := inx + 1].
	e cell colspan: 4; addRulerSize: 1. e newRow.
	^self pageFrameWith: e title: self title .
!

viewUpdateSettings
	| element |
	self clear.
	self    title: 'Update Settings for site: ', self site name.
	element := WebElement new.
	element table width: 500.
      element cell color: (self navigatorColor).
	element cell addText: self title header: 3.
	element newRow.
	element cell add: (self settingsElementForm: true).
	element newRow.
	element cell addButtonText: 'Update'.
	^self pageFrameWith: element title: self title .
!

viewWaitingConfirmation
	| e |
	self clear. self title: 'Waiting Confirmation'.
	e := WebElement new.
	e addTextH1: 'Waiting Confirmation'.
	e addText: 'And e-mail was sent to address you entered in a registration form. Please read it
	and click to the activation link to confirm that your e-mail is valid.
	If you have any problems send an email to '.
	e addLinkTo: 'info@eranova.si' text: 'Portal Administrator'.
	^self pageFrameWith: e title: self title .
! !

!WebAdminApp methodsFor:'printing-elements'!

addSiteElement
	| e |
	e := WebElement new.
	e cell addText: 'Site name: '.
	e newCell addInputFieldAspect: #name for: self newSite. e newRow.
	e cell colspan: 2; addRulerSize: 1. e newRow.
	e cell addText: 'Hostname: '.
	e newCell addInputFieldAspect: #host for: self newSite uriPattern first. e newRow.
	e cell addText: 'IP: '.
	e newCell addInputFieldAspect: #ip for: self newSite uriPattern first. e newRow.
	e cell addText: 'Port: '.
	e newCell addInputFieldAspect: #port for: self newSite uriPattern first. e newRow.
	e cell colspan: 2; addRulerSize: 1. e newRow.
	e cell addText: 'Style class: '.
	e newCell addInputFieldAspect: #styleClass for: self newSite. e newRow.
	e cell colspan: 2; addRulerSize: 1. e newRow.
	e cell addButtonText: 'Add and start a new site'.
	e cell colspan: 2; addRulerSize: 1. e newRow.
	^e.
!

settingsElementForm: aBoolean
	| element |
	self prepareSettings.
	element := WebElement new.
	element table width: 500.
	element newRow.
	element cell addText: 'hostname: '.
	element newCell addAspect: #host for: self observee input: aBoolean size: 30.
	element newRow.
	element cell addText: 'ip: '.
	element newCell addAspect: #ip for: self observee input: aBoolean size: 30.
	element newRow.
	element cell addText: 'port: '.
	element newCell addAspect: #port for: self observee input: aBoolean size: 5.
	element newRow.
	element cell addText: 'home directory: '.
	element newCell addAspect: #homeDirectory for: self site input: aBoolean size: 30.
	element newRow.
"
	element cell addText: 'web server e-mail address: '.
	element newCell addAspect: #webServerEMail for: self site input: aBoolean size: 30.
	element newRow.
	element cell addText: 'e-mail SMTP server: '.
	element newCell addAspect: #smtpServer for: self site input: aBoolean size: 30.
	element newRow.
	element cell addText: 'urgent notification e-mail to: '.
	element newCell addAspect: #urgentNotificationEMail for: self site input: aBoolean size: 30.
	element newRow.
"
	element cell colspan: 2; addRulerSize: 1.

	^element.
!

sitesElement
	| e |
	e := (WebGrid new
		columnFilters: #(nil 5 );
		columnWidth: #(0.03 0.15);
		columnNames: #(nil 'name' 'created' 'started' 'status');
		column: 2 addBlock: [:site | WebLink text: site name linkTo: 'http://', site host, '/admin.html'];
		collection: SwazooServer singleton sites;
		setNumbering;
		yourself).
	^e.
! !

!WebAdminApp methodsFor:'private'!

aidaDontCache
	^true
!

reportLogin
	Transcript cr; show: 'login: ', self session user nameSurname asSloveneWithoutCircumflexes,
	' on ', self site name,
	' at ',
	Date today dayOfMonth printString, '.',
	Date today monthIndex printString, ' ',
	Time now hours printString, ':',
	Time now minutes printString,
	' from ', self session lastRequest peer
!

reportLogout
	Transcript cr; show: 'logout: ', self session user nameSurname asSloveneWithoutCircumflexes,
	' on ', self site name,
	' at ',
	Date today dayOfMonth printString, '.',
	Date today monthIndex printString, ' ',
	Time now hours printString, ':',
	Time now minutes printString,
	' from ', self session lastRequest peer
! !

!WebAdminApp methodsFor:'testing'!

isRegistrationValid
	"check entry fields and set error report if not"
	| text |
	text := ''.
	(self site securityManager
		existUserNamed: self newUser username withPassword: self newUser username)
			ifTrue: [text := text, ' User with that username and password already exist!! ' ].
	text isEmpty ifTrue:
		[self newUser username isEmpty ifTrue: [text := text, ' Username missing, '].
		self password isEmpty ifTrue: [text := text, ' Password missing, '].
		self newUser password isEmpty ifTrue: [text := text, ' Confirm password missing, '].
		self password = self newUser password ifFalse: [text := text, ' Passwords not equal!! '] ].
	text notEmpty ifTrue:
		[self error: 'Registration failed!! ', text, ' Please correct errors and try again!!'. ^false].
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#SwazooStream
	instanceVariableNames:'socket readBuffer writeStream'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Compatibility'
!

!SwazooStream class methodsFor:'instance creation'!

connectedPair
	^SwazooSocket connectedPair collect: [:each | self socket: each]
!

socket: aSwazooSocket
	^self new setSocket: aSwazooSocket
! !

!SwazooStream methodsFor:'accessing'!

atEnd
	^false
!

close
	self socket close
!

cr
	self nextPut: Character cr
!

flush
	"actually write to the tcp socket"
	| contents remaining |
	contents := self writeStream contents.
	remaining := contents size.
	[remaining > 0] whileTrue: [| written |
		written := self socket
			write: (contents copyFrom: contents size - remaining + 1 to: contents size).
		remaining := remaining - written].
	self initWriteStream.
!

next
	^(self next: 1) first
!

next: anInteger
	"^aString
	We use a Stream to convert the ByteArray to a String because in GemStone
	ByteArray>>asString always returns the string 'aByteArray' :-/
	... but of course, this does not handle character encoding properly."

	| targetStream |
	targetStream := WriteStream on: String new.
	(self nextBytes: anInteger)
		do: [:aByte | targetStream nextPut: aByte asCharacter].
	^targetStream contents
!

nextPut: aCharacter
	self nextPutAll: (String with: aCharacter).
	^aCharacter
!

nextPutAll: aString
	self nextPutBytes: aString asByteArray.
	^aString
!

peek
	^self peekByte asCharacter
!

print: anObject
	anObject printOn: self
!

socket
	^socket
!

space
	self nextPut: Character space
!

upTo: aCharacter
	| ws char |
	ws := String new writeStream.
	[char := self next.
	char = aCharacter] whileFalse: [ws nextPut: char].
	^ws contents
! !

!SwazooStream methodsFor:'accessing-bytes'!

nextByte
	^(self nextBytes: 1) first
!

nextBytes: requestedNumberOfBytes
	"^a ByteArray
I read the requestedNumberOfBytes from my underlying ReadStream.  This is expexted to be the raw HTTP byte stream."

	| nextBytes |
	nextBytes := ByteArray new: requestedNumberOfBytes.
	1 to: requestedNumberOfBytes
		do:
			[:index |
			self syncBuffer.
			nextBytes at: index put: self readBuffer next].
	^nextBytes
!

nextPutByte: aByte
	self nextPutBytes: (ByteArray with: aByte).
	^aByte
!

nextPutBytes: aByteArray
	self writeStream nextPutAll: aByteArray.
	^aByteArray
!

peekByte
	self syncBuffer.
	^self readBuffer peek
! !

!SwazooStream methodsFor:'private'!

fillBuffer
	self readBuffer: (ReadStream on: (self socket read: 1024) ).
	self readBuffer atEnd
		ifTrue: [SpError raiseSignal: 'No data available.  Socket probably closed']
!

readBuffer
	"^a ReadStream
I return a ReadStream on the current read buffer.  See >>fillBuffer to understand how the buffer is filled."
	^readBuffer
!

readBuffer: aStream
	readBuffer := aStream
!

socket: aSocket
	socket := aSocket
!

syncBuffer
	self readBuffer atEnd ifTrue: [self fillBuffer]
!

writeStream
	writeStream isNil ifTrue: [self initWriteStream].
	^writeStream
! !

!SwazooStream methodsFor:'private-initialize'!

initWriteStream
	"temporary stream. flush it to socket ocassionaly!!"
	writeStream := WriteStream on: (ByteArray new: 1000)
!

setSocket: aSwazooSocket
	self socket: aSwazooSocket.
	self readBuffer: (ReadStream on: ByteArray new)
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebInputField subclass:#WebDelayedField
	instanceVariableNames:'update parameter delay'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Components'
!

WebDelayedField comment:'WebDelayedField is used to delayed Ajax posting to server. It waits for delay after last key input, before it posts its contents. Ideal for live-search fields.

Use it as a normal input field, sending it #onClickPost, #onClickPostAndUdate: etc.
'
!

!WebDelayedField methodsFor:'accessing'!

defaultDelay
	"delay before posting, in seconds"
	^1
!

delay
	"delay before posting, in seconds"
	delay isNil ifTrue: [self delay: self defaultDelay].
	^delay
!

delay: aNumber
	"delay before posting, in seconds"
	delay := aNumber
! !

!WebDelayedField methodsFor:'events-ajax'!

afterPostUpdate: anElementOrId
	"update that element after delayed post"
	self update: anElementOrId
!

afterPostUpdate: anElementOrId with: aParmString
	"update that element after delayed post with a parameter"
	self update: anElementOrId.
	self parameter: aParmString.
! !

!WebDelayedField methodsFor:'printing'!

addSetupScript
	self scriptAfter: (self scriptForPostAndUpdate: self update with: self parameter)
!

printHTMLPageOn: aStream forSession: aSession
	self registerId.
	self addSetupScript.
	super printHTMLPageOn: aStream forSession: aSession.
!

scriptForPostAndUpdate: anElementOrId with: aParmString
	| url idSymbol parms |
	idSymbol := anElementOrId isSymbol
		ifTrue: [anElementOrId]
		ifFalse: [anElementOrId isNil   ifTrue: [#nil] ifFalse: [anElementOrId registerId. anElementOrId id] ].
	self registerId.
      url := self ajaxCallUrl. parms := self ajaxCallUrlParametersFor: anElementOrId.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	^'
new Form.Element.AIDADelayedObserver ("', self id asString, '", ', self delay printString, ', function ()
	{new Ajax.Updater(''', idSymbol asString, ''', ''', url, ''', {method: ''post'',
		postBody: ''', self name, '=''+$F (''', self id asString, ''') + ''', ('&', parms), ''', evalScripts: true});
      });
'
! !

!WebDelayedField methodsFor:'private'!

onChangePost
	"that's done by default!! "
!

onChangePostAndUpdate: anElementOrId
	self error: 'use afterPostUpdate: instead!!'
!

onChangePostAndUpdate: anElementOrId with: aParmString
	self error: 'use afterPostUpdate:with: instead!!'
!

onChangePostAndUpdateSelf
	self error: 'use afterPostUpdate: instead!!'
!

onKeyPressPostAndUpdate: anElementOrId
	self error: 'use afterPostUpdate: instead!!'
!

onKeyUpPostAndUpdate: anElementOrId
	self error: 'use afterPostUpdate: instead!!'
!

parameter
	^parameter
!

parameter: anObject
	parameter := anObject
!

update
	^update
!

update: anElementOrId
	update := anElementOrId
! !

!WebDelayedField methodsFor:'testing'!

isDelayedField
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebSecurityManager
	instanceVariableNames:'site users groups authenticationScheme accessByObject'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!WebSecurityManager class methodsFor:'instance creation'!

newOn: anAIDASite
	^super basicNew
		site: anAIDASite;
		initialize
! !

!WebSecurityManager class methodsFor:'accessing'!

default
	^AIDASite default securityManager
! !

!WebSecurityManager methodsFor:'access control'!

accessRightsFor: aWebUserOrGroup on: anObject
	"get the access rights for specified user or group on object  as literal array of
	rights (e.g. #(#read #write). "
	^(self accessByObject at: anObject
		ifAbsent: [^self defaultAccessRights])
			at: aWebUserOrGroup ifAbsent:  [^self defaultAccessRights]
!

hasUser: aWebUser rightInAnyGroupTo: anAccessSymbol on: anObject
	"test the access right for that object and in groups for that user"
	aWebUser groups do: [:group |
		(self has: group rightTo: anAccessSymbol on: anObject) ifTrue: [^true] ].
	^(self has: self allUsersGroup rightTo: anAccessSymbol on: anObject)
!

isUser: aWebUser allowedTo: anAccessSymbol on: anObject
	"test the access right for that object and that user or groups for that user"
	(self has: aWebUser rightTo: anAccessSymbol on: anObject) ifTrue: [^true].
	^(self hasUser: aWebUser rightInAnyGroupTo: anAccessSymbol on: anObject)
!

removeAccessRights: anAccessSymbol for: aWebUserOrGroup on: anObject
	"remove all specified access rigths for specified user or group on specified object"
	| access |
	(anAccessSymbol isKindOf: Array)
		ifTrue: [access := anAccessSymbol ]
		ifFalse: [access := Array with: anAccessSymbol].
	self removeAccessRightArray: access for: aWebUserOrGroup on: anObject
!

removeAllAccessRightsFor: aWebUserOrGroup
	self accessByObject keys do: [:object |
		self
			removeAllAccessRightsFor: aWebUserOrGroup
			on: object]
!

removeAllAccessRightsFor: aWebUserOrGroup on: anObject
	self site critical:
		[(self accessByObject at: anObject ifAbsent: [^self])
			removeKey: aWebUserOrGroup ifAbsent: [^self] ].
!

removeAllAccessRightsForObject: anObject
	self site critical:
		[self accessByObject removeKey: anObject ifAbsent: []   ].
!

setAccessRights: anAccessSymbols for: aWebUserOrGroup on: anObject
	"set the access rights for specified user or group on object. it can be only one right
	or an literal array of rights (e.g.#(#read #write) ) "
	| access |
	aWebUserOrGroup isNil ifTrue: [^self error: 'User is nil'].
	access := (anAccessSymbols isKindOf: Array)
		ifTrue: [anAccessSymbols ]
		ifFalse: [Array with: anAccessSymbols].
	self accessRightsArray: access for: aWebUserOrGroup on: anObject.
! !

!WebSecurityManager methodsFor:'accessing'!

allGroups
	^self groups copy
!

allUsers
	^self users copy
!

site
	"a parent site using that security manager"
	^site
! !

!WebSecurityManager methodsFor:'authentication'!

authenticationScheme
	"#Form - with WebAdminApp login form - default!!
	#HttpBasic - rfc2617 Basic authentication - passwords NOT encrypted!!
	#HttpDigest - rfc2617 Digest authentication - encrypted passwords
	#SSLClientCertificate - most secure, user needs a valid PKI certificate"
	authenticationScheme isNil ifTrue: [self setFormAuthenticationScheme].
	^authenticationScheme
!

hasFormAuthenticationScheme
	^self authenticationScheme = #Form
!

hasHttpAuthenticationScheme
	^self hasHttpBasicAuthenticationScheme | self hasHttpDigestAuthenticationScheme
!

hasHttpBasicAuthenticationScheme
	^self authenticationScheme = #HttpBasic
!

hasHttpDigestAuthenticationScheme
	^self authenticationScheme = #HttpDigest
!

hasSSLClientCertificateAuthenticationScheme
	^self authenticationScheme = #SSLClientCertificate
!

setFormAuthenticationScheme
	"AIDASite default securityManager setFormAuthenticationScheme"
	self authenticationScheme: #Form
!

setHttpBasicAuthenticationScheme
	"AIDASite default securityManager setHttpBasicAuthenticationScheme"
	self authenticationScheme: #HttpBasic
!

setHttpDigestAuthenticationScheme
	"AIDASite default securityManager setHttpDigestAuthenticationScheme"
	self authenticationScheme: #HttpDigest
!

setSSLClientCertificateAuthenticationScheme
	"AIDASite default securityManager setSSLClientCertificateAuthenticationScheme"
	self authenticationScheme: #SSLClientCertificate
! !

!WebSecurityManager methodsFor:'group management'!

activatingGroup
	"group for users to confirm registration"
	^self groups detect: [:each | each isActivatingGroup] ifNone: [nil].
!

addGroup: aWebUserGroup
	self addGroup: aWebUserGroup ifExist: [^nil].
!

addGroupNamed: aString
	"add new group with a specified name. If already exist, error"
	self addGroup: (WebUserGroup new name: aString).
!

adminGroup
	"group for admins, those who have all acess rights !! "
	^self groups detect: [:each | each isAdminGroup] ifNone: [nil].
!

allUsersGroup
	"group for all users in system"
	^self groups detect: [:each | each isAllUsersGroup] ifNone: [nil].
!

existGroupNamed: aString
	^(self groupNamed: aString) notNil
!

groupNamed: aString
	aString isEmpty ifTrue: [^nil].
	^self groups detect: [:group | group name =  aString] ifNone: [nil]
!

groupWithUuid: aString
	" find and return a group with specified uuid. Return nil if not found"
	^self groups detect: [:each | each uuid = aString] ifNone: [nil]
!

registeredGroup
	"group for registered users"
	^self groups detect: [:each | each isRegisteredGroup] ifNone: [nil].
!

removeGroup: aWebUserGroup
	"remove group, if exist. If not exist do nothing"
	self removeGroup: aWebUserGroup ifAbsent: [].
!

removeGroupNamed:  aString
	| group |
	group := self groupNamed: aString.
	group notNil ifTrue: [self removeGroup: group]
! !

!WebSecurityManager methodsFor:'initialize-release'!

initAccessByObject
	accessByObject := Dictionary new.
!

initAdminAccess
	"admin group has rights to all views and updates in all Apps!! "
	WebApplication allowAllViewsFor: self adminGroup on: self site.
	WebApplication allowAllUpdatesFor: self adminGroup  on: self site.
!

initAdminUser
	"add default admin user"
	| user |
	(self users contains: [:each | each isAdmin and: [each name = WebUser adminName]]) ifTrue: [^nil].
	user := WebUser newAdmin.
	self addUser: user.
	self adminGroup addUser: user.
!

initDefaultAccessRights
	"to allow login, registering new user etc"
	| views updates |
	views := #(login logout forgoten registration passwordSent waitingConfirmation activation)
		collect: [:each | WebAdminApp viewRightSymbolFor: each].
	self    setAccessRights: views for: self allUsersGroup on: WebAdminApp name.
	updates := #(login registration passwordSent)
		collect: [:each | WebAdminApp updateRightSymbolFor: each].
	self    setAccessRights: updates for: self allUsersGroup on: WebAdminApp name.

"WebSecurityManager default initDefaultAccessRights"
!

initDefaultGroups
	self addGroup: WebUserGroup newAllUsers.
	self users do: [:user |         self allUsersGroup addUser: user].
	self addGroup: WebUserGroup newAdmin.
	self addGroup: WebUserGroup newRegistered.
	self addGroup: WebUserGroup newActivating.
	self postInitDefaultGroups.  "override this method for your own default groups"
!

initGroups
	groups := Set new.
!

initGuestUser
	"add new user,with name 'Guest'"
	| user |
	(self users contains: [:each | each isGuest]) ifTrue: [^nil].
	user := WebUser newGuest.
	self addUser: user.
	self allUsersGroup addUser: user.
!

initUsers
	users := Set new.
	self groups do: [:each | each initUsers].
!

initialize
	self initUsers.
	self initGroups.
	self initAccessByObject.
	self initDefaultGroups.
	self initAdminUser.
	self initGuestUser.
	self initDefaultAccessRights.
!

postInitDefaultGroups
	"override this method for your own default groups"
! !

!WebSecurityManager methodsFor:'private'!

accessByObject
	"this is a dictionary of user - access level pairs for access to the object,
	which reference is a key in dictionary"
	accessByObject isNil ifTrue: [self initAccessByObject].
	^accessByObject
!

accessRightsArray: anAccessSymbols for: aWebUserOrGroup on: anObject
	| objectRights rigthsArray |
	self site critical:
		[objectRights := self accessByObject at: anObject
			ifAbsent:
				[self accessByObject at: anObject put: (Dictionary new).
				self accessByObject at: anObject].
		rigthsArray := objectRights at: aWebUserOrGroup
			ifAbsent:
				[objectRights at: aWebUserOrGroup put: IdentitySet new.
				objectRights at: aWebUserOrGroup].
		rigthsArray addAll: anAccessSymbols].
!

addGroup: aWebUserGroup ifExist: aBlock
	"add new group. If already exist ( as object or as group with the same name) do aBlock"
	(aWebUserGroup isKindOf: WebUserGroup) ifFalse: [^self error: 'This is not aWebUserGroup'].
	(self existGroupNamed: aWebUserGroup name) ifTrue: [aBlock value].
	self groups add: aWebUserGroup
!

authenticationScheme: aSymbol
	authenticationScheme := aSymbol
!

copyAccessByObject

|dict|
Janko := Dictionary new.
WebSecurityManager default accessByObject
keysAndValuesDo:
	[:key :value |
		dict := Dictionary new.
		value keysAndValuesDo: [:key1 :value1 |
			dict at: key1 put: (IdentitySet withAll: (value1 collect: [:el | el asString asSymbol] )) ].
		Janko at: key put: dict].
!

defaultAccessRights

	^#()
!

groups
	groups isNil ifTrue: [self initGroups].
	^groups
!

has: aWebUserOrGroup rightTo: anAccessSymbol on: anObject
	"test the access right for that object and that user or group "
	| usersAndGroups |
	usersAndGroups := self accessByObject at: anObject ifAbsent: [^false].
	(usersAndGroups includesKey: aWebUserOrGroup)   ifTrue:
		[((usersAndGroups at: aWebUserOrGroup) includes: anAccessSymbol) ifTrue: [^true] ].
	^false
!

isDefaultAllowedTo: anAccessSymbol
	"default access right for all objects and all users"
	^self defaultAccessRights includes: anAccessSymbol
!

migrateAppClassessToSymbols
	"do not use app classes but their names as symbols"

	self accessByObject keys do: [:obj |
		((obj isKindOf: Behavior) and: [obj includesBehavior: WebApplication]) ifTrue: [
			self accessByObject
				at: obj name
				put: (self accessByObject at: obj).
			self accessByObject removeKey: obj] ].

"WebSecurityManager default migrateAppClassessToSymbols"
!

reconnectUsersToGroups
	"if user groups don't match group users"
	"(AIDASite named: 'biart') securityManager reconnectUsersToGroups"
	self users do: [:user |
		user groups do: [:group | (group includes: user) ifFalse: [group addUser: user] ] ].
	self groups do: [:group |
		group users do: [:user | (user groups includes: group) ifFalse: [user addToGroup: group] ] ]
!

removeAccessRightArray: anAccessSymbols for: aWebUserOrGroup and: anObject
	"remove all specified access rigths for specified user or group on specified object"
	self site critical:
		[((self accessByObject at: anObject ifAbsent: [^self])
			at: aWebUserOrGroup ifAbsent: [^self])  removeAll: anAccessSymbols].
!

removeAccessRightArray: anAccessSymbols for: aWebUserOrGroup on: anObject
	"remove all specified access rigths for specified user or group on specified object"
	| usrGrps rights |
	self site critical:
		[usrGrps := self accessByObject at: anObject ifAbsent: [^self].
		rights := usrGrps at: aWebUserOrGroup ifAbsent: [^self].
		anAccessSymbols do: [:each | rights remove: each ifAbsent: [] ] ].
!

removeGroup: aWebUserGroup ifAbsent: aBlock
	"remove group, if exist. If not exist do aBlock. You cannot remove group AllUsers!!"
	aWebUserGroup isAllUsersGroup ifTrue: [^self error: 'group AllUsers cannot be removed!!'].
	(self groups includes: aWebUserGroup) ifFalse: [^aBlock value].
	self groups remove: aWebUserGroup.
	aWebUserGroup allUsers do: [:each | aWebUserGroup removeUser: each].
	self removeAllAccessRightsFor: aWebUserGroup
!

site: anAIDASite
	site := anAIDASite.
!

users
	users isNil ifTrue: [self initUsers].
	^users
! !

!WebSecurityManager methodsFor:'user management'!

addActivatingUser: aWebUser
	"add this user also to group waiting for confirmation"
	self addUser: aWebUser.
	self activatingGroup addUser: aWebUser.
!

addPerson: aPerson
	"make parallel WebUser, cross-connect both and put into Registered group"
	"by default username and password are aPerson surname!!"
	| user |
	aPerson asWebUser notNil ifTrue: [^self error: 'already added!!'].
	user := WebUser new.
	user username: aPerson surname.
	user password: aPerson surname.
	(self addRegisteredUser: user) notNil "no duplicates in username"
		ifTrue: [ aPerson webUser: user. user person: aPerson]
		ifFalse: [^nil]
!

addRegisteredUser: aWebUser
	"add this user also to registered users group. Remove him from activating group"
	self addUser: aWebUser.
	self registeredGroup addUser: aWebUser.
	self activatingGroup removeUser: aWebUser.
!

addUser: aWebUser
	"add new user also in All Users group"
	(aWebUser isKindOf: WebUser) ifFalse: [^self error: 'This is not aWebUser'].
	(self users includes: aWebUser) ifTrue: [^nil].
	(self existUserNamed: aWebUser username withPassword: aWebUser password) ifTrue: [^nil].
	self users add: aWebUser.
	self allUsersGroup addUser: aWebUser.
	aWebUser parent: self.
!

adminUser
	"first admin user, initialy it is with username 'admin'"
	^self users detect: [:each | each isAdmin] ifNone: [nil]
!

existUserNamed: anUsernameString withPassword: aPasswordString
	^(self userNamed: anUsernameString withPassword: aPasswordString) notNil
!

existUserWithId: aNumber
	^self users contains: [:each | each id = aNumber].
!

guestUser
	"actually only one is guest user"
	^self users detect: [:each | each isGuest] ifNone: [nil]
!

isUser: aWebUser inGroup: aWebGroup
	"test if user is member of this group"
	^aWebGroup includes: aWebUser
!

isUser: aWebUser inGroupNamed: aString
	| group |
	group := self groupNamed: aString.
	group isNil ifTrue: [^false].
	^group includes: aWebUser
!

removeUser: aWebUser
	"remove user, if exist"
	(self users includes: aWebUser) ifFalse: [^nil].
	self users remove: aWebUser.
	self allGroups do: [:group | group removeUser: aWebUser].
	self removeAllAccessRightsFor: aWebUser
!

removeUserNamed:  anUsername withPassword: aPassword
	| user |
	user := self userNamed: anUsername withPassword: aPassword.
	self removeUser: user
!

userNamed: anUsernameString
	" find and return a WebUser with username . Return nil if not found"
	"WebSecurityManager default userNamed: 'mivsek'"
	(anUsernameString ~= '') ifFalse: [^nil].
	^self users
		detect: [:user | (user username asLowercase = anUsernameString asLowercase)] ifNone: [nil]
!

userNamed: anUsernameString withPassword: aPasswordString
	" find and return a WebUser with username and password. Return nil if not found"
	(anUsernameString ~= '') | (aPasswordString ~= '') ifFalse: [^nil].
	^self users detect: [:user |
		(user username asLowercase = anUsernameString asLowercase) and:
			[user password asLowercase = aPasswordString asLowercase]] ifNone: [nil]
!

userWithEMail: aString
	" find and return a WebUser with specified email. Return nil if not found"
	(aString ~= '') ifFalse: [^nil].
	^self users detect: [:user | user email asLowercase = aString asLowercase ] ifNone: [^nil]
!

userWithId: aNumber
	^self users detect: [:each | each id = aNumber] ifNone: [nil]
!

userWithUuid: aString
	" find and return a WebUser with specified uuid. Return nil if not found"
	^self users detect: [:each | each uuid = aString] ifNone: [nil]
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SwazooBaseExtensionsTest
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Tests'
!

!SwazooBaseExtensionsTest methodsFor:'testing'!

testCharacterArrayTrimBlanks
	self 
		assert: (HTTPString trimBlanksFrom: '   a b c d e f g') = 'a b c d e f g'.
	self assert: (HTTPString trimBlanksFrom: 'no blanks') = 'no blanks'.
	self assert: (HTTPString trimBlanksFrom: ' leading') = 'leading'.
	self assert: (HTTPString trimBlanksFrom: 'trailing ') = 'trailing'.
	self assert: (HTTPString trimBlanksFrom: '') = ''.
	self 
		assert: (HTTPString 
				trimBlanksFrom: (String with: Character cr with: Character lf)) isEmpty
!

testFilenameEtag
        "The filename etag is a simple string and does not contain double quotes.  Header fields apply double quotes as necessary when writing themselves."

        | fn etag1 etag2 |
        fn := SpFilename named:'etagTest'.
        fn writeStream close.
        etag1 := fn etag.
        (Delay forSeconds: 1) wait.
        fn appendStream close.
        
        [etag2 := fn etag.
        self assert: (etag1 isKindOf: String).
        self assert: (etag2 isKindOf: String).
        self deny: etag1 = etag2] 
                        ensure: [fn delete]
!

testStringNewRandom
	| sizes strings |
	sizes := #(5 20 6127 2 100).
	strings := sizes collect: [:each |  HTTPString newRandomString: each].
	strings with: sizes do: [:string :size | self assert: string size = size]
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#ScheduledEvent
	instanceVariableNames:'parent timestamp period method object block'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!ScheduledEvent class methodsFor:'instance creation'!

newOn: aScheduler
	^super new parent: aScheduler
! !

!ScheduledEvent methodsFor:'accessing'!

block
	"a block to be run at event"
	^block
!

method
	"a method to be called on an object at a scheduled time"
	^method
!

object
	"object on which a method wil be called at scheduled time"
	^object
!

parent
	^parent
!

timestamp
	"when this event must occur"
	^timestamp
! !

!ScheduledEvent methodsFor:'private'!

block: anObject
	block := anObject
!

deepCopyNotIn: aDictionary
	^nil
!

method: aSymbol
	"a method to be called on an object at a scheduled time"
	method := aSymbol
!

object: anObject
	object := anObject
!

parent: anObject
	parent := anObject
!

printString
	^'aScheduledEvent
	timestamp: ', self timestamp printSloString, ':', self timestamp second printString, '
	period: ', self period key printString, ' ', self period value printString, '
	method: ', self method printString, '
	object: ', self object printString, '
	block: ', self block printString
!

representBinaryOn: binWriter
	"for BOSS out. Blocks are not BOSSed out correctly, therefore we cannot export evens that way!!"
	"TEMPORARY, find a better solution!!"
	^0
!

reschedule
	"calculate and set a new time to run, according to a period"
	self isDayPeriod ifTrue:
		[self timestamp: (Timestamp fromSeconds: (self timestamp asSeconds + (60*60*24)))].
	self isHourPeriod ifTrue:
		[self timestamp: (Timestamp fromSeconds: (self timestamp asSeconds + (60*60)))].
	self isMinutePeriod ifTrue:
		[self timestamp: (Timestamp fromSeconds: (self timestamp asSeconds + 60))].
	self parent scheduleEvent: self.
!

timestamp: aTimestamp
	timestamp := aTimestamp
! !

!ScheduledEvent methodsFor:'private-periods'!

period
	"asociation with type and parameter: #single>nil #day>aTime, ... "
	^period
!

periodType: aSymbol value: anObject
	period := Association key: aSymbol value: anObject
!

setPeriodSingle
	self periodType: #single value: nil
! !

!ScheduledEvent methodsFor:'running'!

run
	"run this event"
	self block notNil
		ifTrue: [ [self block value] forkAt: self runPriority]
		ifFalse: [ [self object perform: self method] forkAt: self runPriority].
	self isPeriodic ifTrue: [self reschedule]
!

runPriority
	^Processor userBackgroundPriority
! !

!ScheduledEvent methodsFor:'setup'!

at: aTimestamp runBlock: aBlockClosure
	self timestamp: aTimestamp.
	self block: aBlockClosure.
	self setPeriodSingle
!

everyDayAt: aTimeOrHour  runBlock: aBlock
	| time |
	time := aTimeOrHour class == Time
		ifTrue: [aTimeOrHour] ifFalse: [Time fromSeconds: aTimeOrHour*60*60].
	self timestamp: (Timestamp fromDate: Date today andTime: time).
	self block: aBlock.
	self periodType: #day value: time
!

everyHourAt: aMinuteNumber runBlock: aBlock
	self timestamp: (Timestamp fromDate: Date today andTime:
		(Time fromSeconds: (Time now hours * 3600) + (aMinuteNumber * 60))).
	self block: aBlock.
	self periodType: #hour value: aMinuteNumber
!

everyMinuteAt: aSecondNumber runBlock: aBlock
	self timestamp: (Timestamp fromDate: Date today andTime:
		(Time fromSeconds: (Time now hours * 3600) + (Time now minutes * 60) + aSecondNumber)).
	self block: aBlock.
	self periodType: #minute value: aSecondNumber
! !

!ScheduledEvent methodsFor:'testing'!

isDayPeriod
	^self period notNil and: [self period key = #day]
!

isHourPeriod
	^self period notNil and: [self period key = #hour]
!

isMinutePeriod
	^self period notNil and: [self period key = #minute]
!

isPeriodic
	^(self period isNil or: [self period key = #single]) not
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebFrameApp subclass:#WebSecurityManagerApp
	instanceVariableNames:'usr group aclObject aclUserOrGroup aclForWho'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Admin'
!

!WebSecurityManagerApp methodsFor:'accessing'!

aclForWho
	^aclForWho
!

aclForWho: anObject
	aclForWho := anObject
!

aclObject
	^aclObject
!

aclObject: anObject
	aclObject := anObject
!

aclUserOrGroup
	^aclUserOrGroup
!

aclUserOrGroup: anObject
	aclUserOrGroup := anObject
!

group
	^group
!

group: anObject
	group := anObject
!

user
	^self session user
!

usr
	"temporary user"
	^usr
!

usr: aWebUser
	usr := aWebUser
! !

!WebSecurityManagerApp methodsFor:'actions'!

actionAddGroup
	self group ~= '' ifTrue: [self observee addGroup: self group].
	self newView: #groups.
!

actionAddUser
	self group ~= '' ifTrue: [self observee addGroup: self group].
	self newView: #groups.
!

actionUpdateUser
	self newView: #user.
! !

!WebSecurityManagerApp methodsFor:'printing'!

viewMain
	| e |
	self title: ('Security management for site: ', self site name).
	e := WebElement new.
	e
		addText: ('Security management for site: ', self site name) header: 3;
		addParagraph;
		addLinkTo: self observee text: ' Users ' view: 'users';
		addText: (' (',self observee allUsers size printDotString,') ');
		addBreak;
		addLinkTo: self observee text: ' Groups ' view: 'groups';
		addText: (' (',self observee allGroups size printDotString,') ');
		addBreak.
	self pageFrameWith: e title: self title
! !

!WebSecurityManagerApp methodsFor:'printing - access control'!

allYesNoLinks
	| element |
	element := WebElement new.
	element
		addText: 'all views: ';
		addLinkTo: self observee text: ' YES ' view: #aclObject parameter: 'allViews' value: 'YES';
		add: ((WebLink text: ' NO ' linkTo: self observee)
			view: #aclObject;
			parameter: 'allViews' value: 'NO');
		addText: 'all updates: ';
		add: ((WebLink text: ' YES ' linkTo: self observee)
			view: #aclObject;
			parameter: 'allUpdates' value: 'YES');
		add: ((WebLink text: ' NO ' linkTo: self observee)
			view: #aclObject;
			parameter: 'allUpdates' value: 'NO');
		addText: 'all encrypted: ';
		add: ((WebLink text: ' YES ' linkTo: self observee)
			view: #aclObject;
			parameter: 'allEncrypted' value: 'YES');
		add: ((WebLink text: ' NO ' linkTo: self observee)
			view:  #aclObject;
			parameter: 'allEncrypted' value: 'NO').
	^element
!

checkAccessRight: aSymbol

	"if YES or NO is pressed for a #view or #update method in aclObjectPage, then set or reset a view
	access rights for current user or group, web app and view symbol"

	| right userOrGroup command |
	(self session lastRequest includesQuery: 'right')
		ifTrue:
			[right := (self session lastRequest queryAt: 'right')].
	(self aclForWho = 'user')
		ifTrue: [userOrGroup := self usr]
		ifFalse: [userOrGroup := self group].
	aSymbol = #view
		ifTrue:
			[(self session lastRequest includesQuery: 'viewRight')
				ifTrue:
					[command := (self session lastRequest queryAt: 'viewRight')] ]
		ifFalse:
			[(self session lastRequest includesQuery: 'updateRight')
				ifTrue:
					[command := (self session lastRequest queryAt: 'updateRight')] ].

	command = 'YES'
		ifTrue:
			[self observee
				setAccessRights:
					(aSymbol = #view
						ifTrue: [aclObject viewRightSymbolFor: right]
						ifFalse:  [aclObject updateRightSymbolFor: right])
				for: userOrGroup
				on: self aclObject name].
	command = 'NO'
		ifTrue:
			[self observee
				removeAccessRights:
					(aSymbol = #view
						ifTrue: [aclObject viewRightSymbolFor: right]
						ifFalse:  [aclObject updateRightSymbolFor: right])
				for: userOrGroup
				on: self aclObject name].
!

checkAllYesNo
	"if YES or NO is pressed for a #view or #update method in aclObjectPage, then set or reset a view
	access rights for current user or group, web app and view symbol"
	| userOrGroup yesNo |
	(self aclForWho = 'user')
		ifTrue: [userOrGroup := self usr]
		ifFalse: [userOrGroup := self group].
	(self session lastRequest includesQuery: 'allViews')
		ifTrue:
			[yesNo := (self session lastRequest queryAt: 'allViews').
			self aclObject allViews do: [:each |
				yesNo = 'YES'
					ifTrue:
						[self observee
							setAccessRights: (aclObject viewRightSymbolFor: each)
							for: userOrGroup
							on: self aclObject name]
					ifFalse:
						[self observee
							removeAccessRights: (aclObject viewRightSymbolFor: each)
							for: userOrGroup
							on: self aclObject name] ] ].
	(self session lastRequest includesQuery: 'allUpdates')
		ifTrue:
			[yesNo := (self session lastRequest queryAt: 'allUpdates').
			self aclObject allViews do: [:each |
				(aclObject actionMethodForView: each) notNil ifTrue:
					[yesNo = 'YES'
						ifTrue:
							[self observee
								setAccessRights: (aclObject updateRightSymbolFor: each)
								for: userOrGroup
								on: self aclObject name]
						ifFalse:
							[self observee
								removeAccessRights: (aclObject updateRightSymbolFor: each)
								for: userOrGroup
								on: self aclObject name] ] ] ].
	(self session lastRequest includesQuery: 'allEncrypted')
		ifTrue:
			[yesNo := (self session lastRequest queryAt: 'allEncrypted').
			self aclObject allViews do: [:each |
				yesNo = 'YES'
					ifTrue: [self observee
						setAccessRights: (aclObject encryptSymbolFor: each)
						for: userOrGroup
						on: self aclObject name]
					ifFalse:        [self observee
						removeAccessRights: (aclObject encryptSymbolFor: each)
						for: userOrGroup
						on: self aclObject name]  ] ].
!

checkIfEncrypted
	| right userOrGroup command |
	(self session lastRequest includesQuery: 'right')
		ifTrue: [right := (self session lastRequest queryAt: 'right')].
	(self aclForWho = 'user')
		ifTrue: [userOrGroup := self usr]
		ifFalse: [userOrGroup := self group].
	(self session lastRequest includesQuery: 'encrypt')
		ifTrue: [command := (self session lastRequest queryAt: 'encrypt')].
	command = 'YES' ifTrue:
		[self observee
			setAccessRights: (aclObject encryptSymbolFor: right)
			for: userOrGroup
			on: self aclObject name].
	command = 'NO' ifTrue:
		[self observee
			removeAccessRights: (aclObject encryptSymbolFor: right)
			for: userOrGroup
			on: self aclObject name].
!

needsEncryption: aViewSymbol
	^self observee
		has: self aclUserOrGroup
		rightTo: (aclObject encryptSymbolFor: aViewSymbol)
		on: self aclObject name
!

negate: yesNoString

		yesNoString = 'YES' ifTrue: [^'NO'] ifFalse: [^'YES'].
!

updateAllowedFor: aViewSymbol
	^self observee
		has: self aclUserOrGroup
		rightTo: (aclObject updateRightSymbolFor: aViewSymbol)
		on: self aclObject name
!

updateInOneGroupAllowedFor: aViewSymbol

	^self observee
		hasUser: self aclUserOrGroup
		rightInAnyGroupTo: (aclObject class updateRightSymbolFor: aViewSymbol)
		on: self aclObject name
!

viewAclObject
	| e index aclRights actionMethod yesNo |
	(self session lastRequest includesQuery: 'index')
		ifTrue:
			[index := (self session lastRequest queryAt: 'index').
			self aclObject: (WebApplication allWebAppClasses at: index asInteger)].
	self checkAccessRight: #view.
	self checkAccessRight: #update.
	self checkIfEncrypted.
	self checkAllYesNo.
	self    title: ('Access Rigths for: ', self aclObject name, ' on site: ', self site name).

	e := WebElement new.
	e addText: self title header: 3; addParagraph.
	self aclForWho = 'user'
		ifTrue:
			[e addText: ('User: ', self usr someId) header: 5.
			self aclUserOrGroup: self usr]
		ifFalse:
			[e addText: ('Group: ', self group name) header: 5.
			self aclUserOrGroup: self group].

	e add: self allYesNoLinks.
	aclRights := SortedCollection withAll: self aclObject allViews sortBlock: [:a : b | a < b].
	e table border: 1.
	e cell addText: 'view'.
	e newCell colspan: 2; addText: 'view right'.
	e newCell colspan: 2; addText: 'update right'.
	e newCell addText: 'encrypt'. e newRow.
	aclRights do: [:right |
		e cell addText: right asString attributes: #bold.
		e newCell addText: (self aclObject viewMethodForView: right asSymbol) asString.
		(self viewAllowedFor: right) ifTrue: [yesNo := 'YES'] ifFalse: [yesNo := 'NO'].
		e newCell
			add: ((WebLink  text: ('<b>', yesNo) linkTo: self observee)
				view: #aclObject;
				parameter: 'right' value: right asString;
				parameter: 'viewRight' value: (self negate: yesNo)).
		(self aclForWho = 'user') ifTrue:
			[(self viewInOneGroupAllowedFor: right) ifTrue: [yesNo := 'YES'] ifFalse: [yesNo := 'NO'].
			e newCell addText: ('<font size=-1>', yesNo)].

		actionMethod := (self aclObject actionMethodForView: right asSymbol).
		e newCell
			addText: (actionMethod notNil ifTrue: [actionMethod asString] ifFalse: ['<br>']).
		(self updateAllowedFor: right) ifTrue: [yesNo := 'YES'] ifFalse: [yesNo := 'NO'].
		actionMethod notNil
			ifTrue:
				[e newCell
					add: ((WebLink  text: ('<b>', yesNo) linkTo: self observee)
						view:  #aclObject;
						parameter: 'right' value: right asString;
						parameter: 'updateRight' value: (self negate: yesNo)).
				(self aclForWho = 'user') ifTrue:
					[(self viewInOneGroupAllowedFor: right)
						ifTrue: [yesNo := 'YES'] ifFalse: [yesNo := 'NO'].
					e newCell addText: ('<font size=-1>', yesNo)] ]
			ifFalse:
				[e newCell addText: '<br>'].
			(self needsEncryption: right) ifTrue: [yesNo := 'YES'] ifFalse: [yesNo := 'NO'].
		e newCell align: #center;
			add: ((WebLink  text: ('<b>', yesNo) linkTo: self observee)
				view: #aclObject;
				parameter: 'right' value: right asString;
				parameter: 'encrypt' value: (self negate: yesNo)).
		e newRow].
	e addParagraph; add: self usersGroupsLink.

	self pageFrameWith: e title: self title
!

viewAclObjects
	| e aclObjects ident |
	(self session lastRequest includesQuery: 'who')
		ifTrue: [self aclForWho: (self session lastRequest queryAt: 'who')].
	self    title: ('Access Rigths on site: ', self site name).
	e := WebElement new.
	e addText: self title header: 3; addParagraph.
	self aclForWho = 'user'
		ifTrue:
			[e addText: ('User: ', self usr someId) header: 5.
			self aclUserOrGroup: self usr]
		ifFalse:
			[e addText: ('Group: ', self group name) header: 5.
			self aclUserOrGroup: self group].
	aclObjects := WebApplication allWebAppClasses.
	aclObjects do: [:app |
		ident := '<dd>'.
		app appClassLevel timesRepeat: [ident := ident, '&nbsp;&nbsp;&nbsp;&nbsp;'].
		e addText: ident.
		app allViews isEmpty
			ifFalse:
				[e add: ((WebLink  text: app name asString linkTo: self observee)
					view: #aclObject; parameter: 'index' value: (aclObjects indexOf: app) printString)]
			ifTrue: [e addText: app name asString].
		e addBreak].
	e addParagraph; add: self usersGroupsLink.
	self pageFrameWith: e title: self title
!

viewAllowedFor: aViewSymbol
	^self observee
		has: self aclUserOrGroup
		rightTo: (aclObject viewRightSymbolFor: aViewSymbol)
		on: self aclObject name
!

viewInOneGroupAllowedFor: aViewSymbol
	^self observee
		hasUser: self aclUserOrGroup
		rightInAnyGroupTo: (aclObject viewRightSymbolFor: aViewSymbol)
		on: self aclObject name
! !

!WebSecurityManagerApp methodsFor:'printing - groups'!

viewAddGroup
	| e |
	self group: WebUserGroup new.
	self title: ('Adding a new group on site: ', self site name).
	e := WebElement new.
	e
		addText: self title header: 3;
		addText: 'New group name: ';
		add: (WebInputField new aspect: #name for: self group);
		addParagraph;
		add: (WebButton new text: 'Add');
		add: self usersGroupsLink.
	self pageFrameWith: e title: self title
!

viewGroup
	| e users command |
	(self session lastRequest includesQuery: 'guuid')
		ifTrue: [group := self observee groupWithUuid: (self session lastRequest queryAt: 'guuid')].
	(self session lastRequest includesQuery: 'uuid')
		ifTrue: [self usr: (self observee userWithUuid: (self session lastRequest queryAt: 'uuid'))].
	(self session lastRequest includesQuery: 'command')
		ifTrue:
			[command := (self session lastRequest queryAt: 'command').
			command = 'add'  ifTrue: [self group addUser: self usr].
			command = 'remove' ifTrue: [self group removeUser: self usr] ].
	self    title: ('Group ', self group name, ' on site: ', self site name).

	e := WebElement new.
	e
		addText: ('Group ', self group name, ' on site: ', self site name) header: 3;
		addParagraph.
	users := SortedCollection
		withAll: self group allUsers
		sortBlock: [:a :b | a surname < b surname].
	users do: [:each |
		e cell addLinkTo: self observee text: each someId
			view: 'user' parameter: 'uuid' value: each uuid; addBreak]. e newCell.
	e
		addParagraph;
		addLinkTo: self observee text: ' Add user ' view: 'addUserToGroup';
		addLinkTo: self observee text: ' Remove user ' view: 'removeUserFromGroup';
		add: ((WebLink text: ' Access rights ' linkTo: self observee)
			view: #aclObjects;
			parameter: 'who' value: 'group');
		add: self usersGroupsLink.

	self pageFrameWith: e title: self title
!

viewGroups
	| e groups |
	self title: ('Groups of users on site: ', self site name).
	e := WebElement new.
	e addText: ('Groups of users on site: ', self site name) header: 3; addParagraph.
	groups := SortedCollection
		withAll: self observee allGroups sortBlock: [:a :b | a name < b name].
	groups do: [:grp |
		e
			addLinkTo: self observee  text: grp name view: #group
				parameter: 'guuid' value: grp uuid;
			addText: (' (',grp allUsers size printDotString,') '); addBreak].
	e
		addParagraph;
		addLinkTo: self observee text: ' Add group ' view: 'addGroup';
		addLinkTo: self observee text: ' Remove group ' view: 'removeGroup';
		add: self usersGroupsLink.
	self pageFrameWith: e title: self title
! !

!WebSecurityManagerApp methodsFor:'printing - users'!

userElementForm: aBoolean

	| element   |
	element := WebElement new.
	element cell addText: 'Name:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr name attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #name for: self usr)].
	element newRow.

	element cell addText: 'Surname:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr surname attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #surname for: self usr)].
	element newRow.

	element cell addText: 'Company:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr company attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #company for: self usr)].
	element newRow.

	element cell addText: 'Address:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr address attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #address for: self usr)].
	element newRow.

	element cell addText: 'City:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr city attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #city for: self usr)].
	element newRow.

	element cell addText: 'Zip:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr zip attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #zip for: self usr)].
	element newRow.

	element cell addText: 'Phone:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr phone attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #phone for: self usr)].
	element newRow.

	element cell addText: 'Fax:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr fax attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #fax for: self usr)].
	element newRow.

	element cell addText: 'E-mail:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr email attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #email for: self usr)].
	element newRow.

	element newRow.
	element cell addText: 'Username:'.
	aBoolean
		ifFalse:
			[element newCell addText: self usr username attributes: #bold]
		ifTrue:
			[element newCell add: (WebInputField new aspect: #username for: self usr).
			element newRow.
			element cell addText: 'Password:'.
			element newCell add:
				(WebInputField new type: #password; aspect: #password for: self usr)].
	element newRow.
	aBoolean
		ifTrue:
			[element cell add: (WebButton new text: 'Save').
			element cell add: self usersGroupsLink].

	element addParagraph.
	^element
!

userGroupElement

	| element  groups |
	element := WebElement new.
	groups := SortedCollection
		withAll: self usr allGroups
		sortBlock: [:a :b | a name < b name].
	element addText: 'Member of groups:' header: 5.
	groups do: [:grp |
		element
			add: ((WebLink  text: ('<dd>',grp  name) linkTo: self observee)
				view: #group;
				parameter: 'group' value: grp name);
			addBreak].
	^element
!

usersElementUsers: aUserCollection command: aCommandString newView: aViewString
	| element users |
	element := WebElement new.
	users := SortedCollection withAll: aUserCollection sortBlock: [:a :b | a surname < b surname].
	users do: [:each |
		element cell addLinkTo: self observee text: each someId view: aViewString
				parameter: 'uuid' value: each uuid parameter: 'command' value: aCommandString;
			addBreak]. element newCell.
	^element
!

usersGroupsLink
	| element  |
	element := WebElement new.
	element
		addLinkTo: self observee  text: (' Users ') view: 'users';
		addLinkTo: self observee  text: (' Groups ') view: 'groups'.
	^element
!

viewAddUser
	| e |
	self usr: WebUser new.
	self title: ('Adding a new user on site: ', self site name).
	e := WebElement new.
	e addText: self title header: 3; add: (self userElementForm: true).
	self pageFrameWith: e title: self title
!

viewAddUserToGroup
	| e |
	self title: ('Adding a user to group: ', self group name, ' on site: ', self site name).
	e := WebElement new.
	e
		addText: self title header: 3;
		addText: 'Select an user to add:' attributes: #bold;
		addParagraph;
		add: (self usersElementUsers: self observee allUsers  command: #add newView: 'group');
		addParagraph;
		add: self usersGroupsLink.
	self pageFrameWith: e title: self title
!

viewRemoveUser
	| e |
	self title: ('Removing a user on site: ', self site name).
	e := WebElement new.
	e
		addText: self title header: 3;
		addText: 'Select an user to remove:' attributes: #bold;
		addParagraph;
		add: (self usersElementUsers: self observee allUsers  command: #remove newView: 'users');
		addParagraph;
		add: self usersGroupsLink.
	self pageFrameWith: e title: self title
!

viewRemoveUserFromGroup
	| e |
	self title: ('Removing a user from group: ', self group name, ' on site: ', self site name).
	e := WebElement new.
	e
		addText: self title header: 3;
		addText: 'Select an user to remove:' attributes: #bold;
		addParagraph;
		add: (self usersElementUsers: self group allUsers  command: #remove newView: 'group');
		addParagraph;
		add: self usersGroupsLink.
	self pageFrameWith: e title: self title
!

viewUpdateUser
	| e |
	self title: ('Updating user: ', self usr email, ' on site: ', self site name).
	e := WebElement new.
	e addText: self title header: 3; add: (self userElementForm: true).
	self pageFrameWith: e title: self title
!

viewUser
	| e |
	(self session lastRequest includesQuery: 'uuid')
		ifTrue: [self usr: (self observee userWithUuid: (self session  lastRequest queryAt: 'uuid'))].
	(self session  lastRequest includesQuery: 'uuid') ifTrue:
		[self usr: (self observee userWithUuid: (self session  lastRequest queryAt: 'uuid'))].
	self clear. self title: ('User ', self usr someId, ' on server: ', self session  site name).
	e := WebElement new.
	self usr isNil ifTrue:
		[e addText: 'User with that e-mail address does not exist!!' header: 5. ^self].
	e
		addText: self title header: 3;
		add: (self userElementForm: false);
		add: (self userGroupElement);
		addParagraph;
		addLinkTo: self observee text: ' Update information ' view: 'updateUser';
		add: ((WebLink text: ' Access rights ' linkTo: self observee)
			view: #aclObjects;
			parameter: 'who' value: 'user');
		add: self usersGroupsLink.
	self pageFrameWith: e title: self title
!

viewUsers
	| e users command |
	(self session lastRequest includesQuery: 'command') ifTrue:
		[command := (self session lastRequest queryAt: 'command').
		command = 'remove' ifTrue: [self observee removeUser: self usr] ].
	self title: ('Users on server: ', self site name).
	e := WebElement new.
	e addText: ('Users on server: ', self site name) header: 3; addParagraph.
	users := SortedCollection
		withAll: self observee allUsers sortBlock: [:a :b | a surname < b surname].
	users do: [:each | e cell addLinkTo: self observee text: each someId
		view: 'user' parameter: 'uuid' value: each uuid; addBreak]. e newCell.
	e addParagraph;
		addLinkTo: self observee text: ' Add user ' view: 'addUser';
		addLinkTo: self observee text: ' Remove user ' view: 'removeUser';
		add: self usersGroupsLink.
	self pageFrameWith: e title: self title
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#HTTPLocationField
	instanceVariableNames:'uri'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!HTTPLocationField class methodsFor:'accessing'!

fieldName
	^'Location'
! !

!HTTPLocationField methodsFor:'accessing'!

uri
	^uri
!

uri: aSwazooURI
	uri := aSwazooURI.
	^self
!

uriString: aString
	uri := SwazooURI fromString: aString.
	^self
! !

!HTTPLocationField methodsFor:'printing'!

valuesAsStringOn: aStream
	self uri printOn: aStream.
	^self
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#SchedulerTest
	instanceVariableNames:'scheduler'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Tests'
!

!SchedulerTest methodsFor:'private'!

transcript
	Transcript cr; show: 'scheduled event'
!

transcript1
	Transcript cr; show: 'scheduled event 1'
!

transcript2
	Transcript cr; show: 'scheduled event 2'
!

transcript3
	Transcript cr; show: 'scheduled event 3'
!

transcript4
	Transcript cr; show: 'scheduled event 4'
!

transcript5
	Transcript cr; show: 'scheduled event 5'
! !

!SchedulerTest methodsFor:'running'!

setUp
	scheduler := Scheduler newOn: nil.
	scheduler start.
!

tearDown
	scheduler stop.
! !

!SchedulerTest methodsFor:'testing'!

testAddingSingleEvent
	scheduler at: Timestamp now callMethod: #transcript of: self.
!

testAddingSingleEvent2
	"look at Transcript!! "
	| time |
	time := Timestamp fromSeconds: (Timestamp now asSeconds + 1).
	scheduler at: time runBlock: [self transcript].
	(Delay forSeconds: 2) wait.
!

testMinutePeriodicEvent
	"it should write twice to transcript in 2 minutes!! "
	scheduler everyMinuteAt: 30 runBlock: [self transcript].
"       (Delay forSeconds: 120) wait "
!

testMoreMinutePeriodicEvents
	"it should write to transcript in 2 minutes!! "
	scheduler everyMinuteAt: 30 runBlock: [self transcript1].
	scheduler everyMinuteAt: 15 runBlock: [self transcript2].
	scheduler everyMinuteAt: 45 runBlock: [self transcript3].
	scheduler everyMinuteAt: 20 runBlock: [self transcript4].
"       (Delay forSeconds: 120) wait"
!

testSetup
! !

!SchedulerTest methodsFor:'testing-queue order'!

testOrderOf2AscEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 15 runBlock: [self transcript1].
	scheduler everyMinuteAt: 30 runBlock: [self transcript2].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.
!

testOrderOf2DescEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 30 runBlock: [self transcript1].
	scheduler everyMinuteAt: 15 runBlock: [self transcript2].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.
!

testOrderOf3AscEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 15 runBlock: [self transcript1].
	scheduler everyMinuteAt: 30 runBlock: [self transcript2].
	scheduler everyMinuteAt: 45 runBlock: [self transcript3].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.
	self assert: (scheduler queue at: 3) period value = 45.
!

testOrderOf3DescEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 45 runBlock: [self transcript1].
	scheduler everyMinuteAt: 30 runBlock: [self transcript2].
	scheduler everyMinuteAt: 15 runBlock: [self transcript3].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.
	self assert: (scheduler queue at: 3) period value = 45.
!

testOrderOf3MixedEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 15 runBlock: [self transcript1].
	scheduler everyMinuteAt: 45 runBlock: [self transcript2].
	scheduler everyMinuteAt: 30 runBlock: [self transcript3].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.
	self assert: (scheduler queue at: 3) period value = 45.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

WebElement subclass:#WebText
	instanceVariableNames:'text size textAttributes header paragraph font'
	classVariableNames:'AttributeMarkup'
	poolDictionaries:''
	category:'Aida-Elements'
!

!WebText class methodsFor:'initialization'!

initialize
	"set the AttributeMarkup dictionary with the allowed atributes and their HTML markup symbols"
	AttributeMarkup := IdentityDictionary new.
	AttributeMarkup
		at: #bold               put: 'b';
		at: #italic             put: 'I';
		at: #teletype   put: 'tt';
		at: #address    put: 'address';
		at: #cite                       put: 'cite';
		at: #code               put: 'code';
		at: #sequence   put: 'samp';
		at: #blockquote         put: 'blockquote';
		at: #definition         put: 'dfn';
		at: #emphasized put: 'em';
		at: #keyboard   put: 'kbd';
		at: #strong             put: 'strong';
		at: #variable   put: 'var'.

"WebText initialize"
! !

!WebText class methodsFor:'instance creation'!

header: aNumber

	"create an empty header. You can add elements such as images and text later"

	^(self new) header: aNumber.

"| a |
a := (WebText header: 1).
a add: (WebImage urlReference: 'http://pu/stefan.gif').
a inspect"
!

header: aNumber text: aString

	"create a header text"

	^(self new) header: aNumber; text: aString.

"WebText header: 1 text: 'test'"
!

new
	^super new initialize
!

newParagraph

	"To open a new paragraph. Use addText: for adding a paragraph text."

	^self new paragraph: true.
!

text: aString
	^self new text: aString

"WebText text: 'test'"
!

text: aString attributes: anArray

	^self new text: aString attributes: anArray

"WebText text: 'test' attributes: #bold"
! !

!WebText class methodsFor:'examples'!

example1
	"examples of use a WebText."

	| text stream |
	text := WebText header: 1 text: 'Hello' .
	text addText: 'String Hello' attributes: #bold.
	text addText: 'String and Italic Hello' attributes: #(#bold #italic).
"       text addText: 'Strong Hello again' prevAttributes."

	stream := WriteStream on: String new.
	text printHTMLPageOn: stream.
	^stream contents.
! !

!WebText methodsFor:'accessing'!

addText: aString
	"make a new element with aString. Attributes are same as previous text."

	self add: (WebText text: aString attributes: self attributes)
!

addText: aString attributes: anArray
	"make a new element with aString. Attributes are same as previous text."

	self add: (WebText text: aString attributes: anArray)
!

color: aString
	self style: '{color: ', aString asString, '}'.
!

font
	^font
!

font: aString
	font := aString
!

header
	^header
!

header: aNumber

	"Assigns this WebText as a header text. Parameter can be 1 .. 5. If this parameter is nil then WebText is not a header"

	aNumber < 1
		ifTrue: [header:= 1.   ]
		ifFalse:
			[aNumber > 5 ifTrue: [header := 5.] ifFalse: [header := aNumber.]].
	^self
!

paragraph
	^paragraph
!

paragraph: aBoolean

	"call this method if you want this text in a new paragraph"

	paragraph := aBoolean.
!

size
	^size
!

size: aNumber

	"larger or smaller text for aNumber factor. Range -7..+7"

	aNumber < -7
		ifTrue: [size := -7.  ]
		ifFalse:
			[aNumber > 7 ifTrue: [size := 7.  ] ifFalse: [size := aNumber.]].
	^self
!

text
	^text
!

text: aString
	text := WebFormElement autoConvertToString: aString.
	"slovene csz are converted if char ^ is after such a char"
	(text includes: $^ ) ifTrue: [text := text convertToSloveneChars].
!

text: aString attributes: anArray
	self text: aString.
	self textAttributes: anArray.
! !

!WebText methodsFor:'initialize-release'!

initialize
	text := ''.
	paragraph := false.
! !

!WebText methodsFor:'printing'!

printHTMLPageOn: aStream forSession: aSession
	"make a header"
	self prepareToHTMLPrintOn: aSession.
	aStream nextPutAll: self ident.
	self insideSpanTag ifTrue:
		[aStream nextPutAll: '<span'. self printAttributesOn: aStream for: aSession. aStream nextPutAll: '>'].
	header notNil ifTrue: [aStream nextPutAll: '<h', header printString, '>'].
	"font size, color, face"
	(size notNil | font notNil ) ifTrue:
		[aStream nextPutAll: '<font '.
		size notNil ifTrue:
			[aStream nextPutAll: 'size=', (size > 0 ifTrue: ['+'] ifFalse: ['']),   size printString, ' '].
		font notNil ifTrue:     [aStream nextPutAll: 'face=', font, ' '].
		aStream nextPutAll: '> ' ].
	"set text attributes, if any"
	textAttributes notNil ifTrue:
		[textAttributes do: [:attribute |  aStream nextPutAll: '<', (AttributeMarkup at: attribute), '>']].
	"print a text"
	text notNil ifTrue: [aStream nextPutAll: (AIDASite convertToWeb: text on: aSession)].
	"print composite elements"
	super printHTMLPageOn: aStream forSession: aSession.
	"reset text attributes"
	textAttributes notNil ifTrue:
		[textAttributes do: [:attribute |  aStream nextPutAll: '</', (AttributeMarkup at: attribute), '>']].
	"end of font adjustment"
	(size notNil | font notNil ) ifTrue: [aStream nextPutAll: '</font>'].
	header notNil ifTrue: [aStream nextPutAll: '</h', header printString, '>', self eol].
	self insideSpanTag ifTrue: [aStream nextPutAll: '</span>', self eol].
!

printString

	^'''', [self text isNil ifTrue: [''] ifFalse: [self text] ] value,''''
! !

!WebText methodsFor:'private'!

insideSpanTag
	"to enclose or not in span tag. Only if element have any attribute!!"
	^self attributes notNil and: [self isLink not]
!

shouldIdent
	^false
!

textAttributes
	"get the attributes of a text"
	^textAttributes
!

textAttributes: anArray
	"check and set the attributes of a text. Atribute can be one or a set of them. Attribute is ignored if not correct. See class variable AttributeMarkup or method WebText initialize for list of allowed attributes"

	(anArray isKindOf: Symbol)              "if only one attribute, convert to an Array"
		ifTrue: [textAttributes := Array with: anArray.       ]
		ifFalse: [(anArray isKindOf: Array)
			ifTrue: [textAttributes := anArray.      ]
			ifFalse: [anArray isNil
				ifTrue: [textAttributes := nil.     ]
				ifFalse:
					[Smalltalk error: 'Text attributes should be Array of Symbols']]].

	"attribute correctness check. Ignore if attribute not correct"
	textAttributes isNil ifFalse:
		[textAttributes := textAttributes select:
			[:attribute | (AttributeMarkup  at: attribute ifAbsent: [false])  ~~ false ].    ]

"WebText text: 'test' attributes: #bold"
"WebText text: 'test' attributes: #( #bold #italic)"
"WebText text: 'test' attributes: nil"
! !

!WebText methodsFor:'testing'!

isLink
	^false
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

SpecificHeaderField subclass:#ContentTypeField
	instanceVariableNames:'mediaType transferCodings'
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-Headers'
!

!ContentTypeField class methodsFor:'accessing'!

fieldName
	^'Content-Type'
! !

!ContentTypeField methodsFor:'accessing'!

defaultMediaType
	"^a String
See RFC 2616 '7.2.1 Type'.  If no media type is specified, application/octet-stream is the default."

	^'application/octet-stream'
!

mediaType
	^mediaType isNil ifTrue: [self defaultMediaType] ifFalse: [mediaType]
!

mediaType: aString
	mediaType := aString.
	^self
!

transferCodings
	transferCodings isNil ifTrue: [transferCodings := String new].
	^transferCodings
! !

!ContentTypeField methodsFor:'printing'!

valuesAsStringOn: aStream
	aStream nextPutAll: self mediaType.
	self transferCodings isEmpty
		ifFalse:
			[aStream
				nextPut: Character space;
				nextPutAll: self transferCodings].
	^self
! !

!ContentTypeField methodsFor:'private'!

parseValueFrom: aString
	| sourceStream |
	sourceStream := aString readStream.
	mediaType := (HTTPString trimBlanksFrom: (sourceStream upTo: $;)).
	transferCodings := self readParametersFrom: sourceStream.
	^self
! !

!ContentTypeField methodsFor:'testing'!

isContentType
	^true
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#WebSessionMgmtTest
	instanceVariableNames:'server site session'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Tests'
!

!WebSessionMgmtTest methodsFor:'running'!

setUp
	server := Swazoo.SwazooServer singleton.
	server initialize.  "to remove all stuff and stop it"
	site := AIDASite newNamed: 'test'.
	session := WebSession newOn: site sessionManager.
!

tearDown
	site := server siteNamed: 'test'.
	site stop.
	server removeSite: site.
	server := nil. site := nil. session := nil.
! !

!WebSessionMgmtTest methodsFor:'testing'!

testSetUp
	self assert: session notNil
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

TestCase subclass:#AIDASystemChangesTest
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Tests'
!

!AIDASystemChangesTest methodsFor:'testing fixed point'!

testFixedPointFromString
	self assert: ('1,00' asFixedPoint: 2) = 1.00s.
	self assert: ('1,24' asFixedPoint: 2) = 1.24s.
	self assert: ('-1,24' asFixedPoint: 2) = -1.24s.
	self assert: ('441,34' asFixedPoint: 2) = 441.34s.
	self assert: ('1.441,34' asFixedPoint: 2) = 1441.34s.
	"integers"
	self assert: ('123' asFixedPoint: 2) = 123.00s.
	"specialities"
	self assert: (',45' asFixedPoint: 2) = 0.45s.
	self assert: ('  ,45   ' asFixedPoint: 2) = 0.45s.
	self assert: ('dfdf' asFixedPoint: 2) = 0.00s.
	self assert: ('' asFixedPoint: 2) = 0.00s.
	self assert: ('  ' asFixedPoint: 2) = 0.00s.
	self assert: (' - , ' asFixedPoint: 2) = 0.00s.
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#URIIdentifier
	instanceVariableNames:''
	classVariableNames:''
	poolDictionaries:''
	category:'Swazoo-HTTP'
!

!URIIdentifier methodsFor:'comparing'!

= anIdentifier
	^self match: anIdentifier
!

hash
	^1
! !

!URIIdentifier methodsFor:'private'!

typeMatch: anotherIdentifier
	^self class == anotherIdentifier class
!

valueMatch: anotherIdentifier
	^self subclassResponsibility
! !

!URIIdentifier methodsFor:'testing'!

match: anotherIdentifier
	^(self typeMatch: anotherIdentifier)
		and: [self valueMatch: anotherIdentifier]
! !


'From Smalltalk/X, Version:5.3.4 on 13-07-2007 at 14:34:38'                     !

"{ Package: 'stx:goodies/aida' }"

"{ NameSpace: Aida }"

Object subclass:#WebSession
	instanceVariableNames:'ids created cookies parent user parms requests lastRequest
		language country appsForObjects lastApp lastView clipboard
		redirectLink redirectOrigin userValues'
	classVariableNames:''
	poolDictionaries:''
	category:'Aida-Core'
!

!WebSession class methodsFor:'instance creation'!

newOn: aWebSessionManager
	"new web session on a specified session manager"
	| session |
	session := super basicNew.
	session parent: aWebSessionManager.
	session initialize.
	^session
! !

!WebSession methodsFor:'Aida-Core'!

browserString

	"return the string, whick browser sends as identification in a web request"

	self lastRequest isNil ifTrue: [^''].
	^self lastRequest envVariables at: #'http_user_agent'.
! !

!WebSession methodsFor:'accessing'!

browser

	"try to find out, which browser a web request originator is using. It can be #Netscape, #IBM, #Microsoft, #lynx, #Mosaic.  Returns #Unknown if not possible to find out the browser type"

	| partOfString |
	self browserString = '' ifTrue: [^#Unknown].
	partOfString := self browserString copyFrom: 1 to: 6.
	partOfString = 'Mozill' ifTrue: [^#Netscape].
	partOfString = '' ifTrue: [^#Microsoft].
	partOfString = 'IBM-We' ifTrue: [^#IBM].
	partOfString = '' ifTrue: [^#Lynx].
	partOfString = '' ifTrue: [^#Mosaic].
!

clipboard
	"for cut/copy/paste references to web pages to easier hyperlink them"
	clipboard isNil ifTrue: [self initClipboard].
	^clipboard
!

cookie
	"true if web request in this nonsecure session uses cookies, false otherwise"
	^self cookies at: 1.
!

cookie: aBoolean
	self cookies    at: 1 put: aBoolean
!

created

	"return the timestamp of a session creation."

	^created
!

fullUrlForCurrentPage
	"composes and returns a full url for a curent requested page. If parms dictionary is changed,
	then a query string with changed parameters is generated. Usefull for presenting the same
	page in a different way by parameteres in query string"
	^self lastRequest urlString
!

fullUrlForPreviousPage
	""
	(self requests isEmpty or: [self requests last isNil]) ifTrue: [^nil].
	^self requests last urlString
!

id

	"return the unique identification of a nonsecure session to browser. This is a random generated number at session generation. It can be used for session tracking in URLs, forms, etc."

	^self ids at: 1
!

id: aNumber
	"return the unique identification of a nonsecure session. This is a random generated number
	at session generation. It can be used for session tracking in URLs, forms, etc."
	self ids at: 1 put: aNumber.
!

lastRequest
	^lastRequest
!

lastRequest: aRequest
	"remember the last, actualy current request pending. also add request to the history in a request
	if logging is on. If first request then also try to find country, language and codePage
	of the originator"
	self lastRequest isNil ifTrue:   "first request on a session"
		[lastRequest := aRequest.
		self country: (self originatorCountryFrom: aRequest).
		self language: (self originatorLanguageFrom: aRequest)].
	self requests isEmpty
		ifTrue: [self requests add: self lastRequest] ifFalse: [self requests at: 1 put: self lastRequest].
	lastRequest := aRequest.
"       self site logging ifTrue: [self requests add: aRequest]. "
	parms := Dictionary new.       "clear old paramters"
	self newView: self viewFromLastRequest.   "default new view should be view from last request"
!

lastView
	"return a view of WebApllication, which is created in response to last request"
	^lastView
!

lastView: aSymbol

	lastView := aSymbol
!

lastViewOld

	"return a value of a 'view' parameter in query part of last request's URL. If no such a parameter, then returns '' "

	^self lastRequest queryAt: 'view' ifAbsent: [^''].
!

newView

	"return a value of a 'view' parameter in query part of a URL to be generated. Also used for changing views in a state machine for web applications (in method actionFormForm (here is set) and method printWebPage (here is used to genererate appropriate page))"

	^self parms at: 'view' ifAbsent: [^''].
!

newView: aString
	"set a value of a 'view' parameter in query part of a URL to be generated. Also used for changing
	views in a state machine for web applications (in method actionFormForm (here is set) and method        printWebPage (here is used to genererate appropriate page))"
	((aString = '') or: [aString isNil]) ifFalse: [self parms at: 'view' put: aString ].
!

parent
	"a session manager !! "
	^parent
!

parms
	"This is a dictionary of parameters in query part of url. When web request arrives, paramteres from query string are written here. When any url is dynamically generated, those parms are appended to it as a query string. You can add, change or delete any parameter to better suit your needs (eg. view=brief to instruct brief view of an object) "


	^parms
!

removeYourself
	" .. from session manager"
	self parent notNil ifTrue: [self parent removeSession: self].
	self initAppsForObjects.
	self parent: nil.
!

requestNum

	"return number of all requests up to now on this session"

	^requests size
!

requests
	"return the history of all requests on this session as ordered collection with the oldest as
	first and newest as last"
	requests isNil ifTrue: [requests := OrderedCollection new].
	^requests
!

secureCookie
	"true if web request in this secure session uses cookies, false otherwise"
	^self cookies at: 2
!

secureCookie: aBoolean
	self cookies at: 2 put: aBoolean
!

secureId

	"return the unique identification of a secure session to browser. This is a random generated number at session generation. It can be used for session tracking in URLs, forms, etc."

	^self ids at: 2
!

secureId: aNumber
	"return the unique identification of a secure session. This is a random generated number
	at session generation. It can be used for session tracking in URLs, forms, etc."
	self ids at: 2 put: aNumber.
!

site
	"a session manager !! "
	^self parent site
!

user
	user isNil ifTrue: [self initUser].
	^user
!

user: aWebUser
	"set a reference to aWebUser, who is logged into this session"
	user := aWebUser.
!

viewFromLastRequest

	"return a value of a 'view' parameter in query part of last request's URL. If no such a parameter, then returns '' "

	^self lastRequest queryAt: 'view' ifAbsent: [''].
! !

!WebSession methodsFor:'initialize-release'!

initAppsForObjects
	appsForObjects := IdentityDictionary new.
!

initClipboard
	clipboard := WebClipboard new
!

initCookies
	cookies := Array with: false with: false.
!

initIds
	ids := Array new: 2.
!

initParms
	parms := Dictionary new.
!

initRequests
	requests := OrderedCollection new.
!

initUser
	self user: self site securityManager guestUser
!

initialize
	self setRandomIds.
	self setCreatedTimestamp.
	self initCookies.
	self initParms.
	self initRequests.
	self initUser.
	self initAppsForObjects.
!

nilLastApp
	lastApp := nil
!

nilLastRequest
	lastRequest := nil
!

setCreatedTimestamp
	created := SpTimestamp now.
!

setRandomIds
	self id: (Random new next * 1000000000) asInteger.
	self secureId: (Random new next * 1000000000) asInteger.
! !

!WebSession methodsFor:'locale support'!

codePage
	^#'UTF_8' "always!!"
!

country
	^country
!

country: aSymbol
	"set the country of a web request originator in ISO 2letter format"
	country := aSymbol.
!

language
	^language
!

language: aSymbol
	"set the language of a web request originator"
	language := aSymbol.
! !

!WebSession methodsFor:'private'!

addApp: anApplication for: anObject type: aSymbol
	"web or wap apps, type can be #web or #wap "
	| objDict |
	objDict := self appsForObjects at: anObject ifAbsentPut: [Dictionary new].
	objDict at: aSymbol put: anApplication
!

addSessionID
	"add session id to  parms dictionary. Url with session id looks like:   http://www.tris-a.si/welcome.html?id=523453. This should be done for every automaticaly
	generated url (WebLink printHTMLPage) to distinguish sesions among themselves."
	self parms at: 'id' put: self id printString.
!

appFor: anObject type: aSymbol
	^(self appsForObjects at: anObject ifAbsent: [^nil])
		at: aSymbol ifAbsent: [^nil]
!

appsForObjects

	appsForObjects isNil ifTrue: [self initAppsForObjects].
	^appsForObjects
!

cookies
	cookies isNil ifTrue: [self initCookies].
	^cookies
!

ids
	ids isNil ifTrue: [self initIds].
	^ids
!

originatorCountryFrom: aRequest
	"find an ISO country code from a web request"
	"not yet implemented!!"
!

originatorLanguageFrom: aRequest
	"find a language from a web request"
	"not yet implemented!!"
!

parent: aWebSessionManager
	parent := aWebSessionManager.
!

printString
^'aWebSession
	ip: ', (self lastRequest notNil ifTrue: [self lastRequest ip] ifFalse: ['']), '
	user: ', self user username, ' (', self user nameSurname, ')
	created: ', self created printSloString, '
	last:      ', (self lastRequest notNil ifTrue: [self lastRequest timestamp printSloString] ifFalse: ['']), ''
!

removeApp: anApplication for: anObject type: aSymbol
	(self appsForObjects at: anObject ifAbsent: [^nil])
		removeKey: aSymbol ifAbsent: [^nil]
!

userValues
	"return a dictionary with user defined values, which scope is this session. Used for such things
	as global navigation, remembering views etc."

	userValues isNil ifTrue: [userValues := Dictionary new].
	^userValues
! !

!WebSession methodsFor:'redirection'!

redirectLink
	"if this aWebLink is set, then web browser will recreate another request with url from that link. Used, if you like, after form action in one page to show page for some other object, e.g. if you have search field in page in one object, and search result is exactly one, then you want to show result page immediately. You can do this with this method.
Atribute redirectLink is reset to nil immediately after printWebPage and before printHTMLPage in WebMediator method dicpatchClient (see WebMediator sendResponseHeaderOn:)"


	^redirectLink
!

redirectLink: aWebLink
	(aWebLink isKindOf: WebLink) | aWebLink isNil ifTrue: [redirectLink:= aWebLink].
!

redirectOrigin

	"this is an URL from where the redirection request originates. Used for returning back from
	exception page, for example when you want to see page wit