| package |
package := Package name: 'Swazoo'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: 'Swazoo 1.09'.


package classNames
	add: #CompositeResource;
	add: #ContentDispositionField;
	add: #ContentTypeField;
	add: #FileMappingResource;
	add: #FileResource;
	add: #FileResponse;
	add: #GenericHeaderField;
	add: #HeaderField;
	add: #HelloWorldResource;
	add: #HomeResource;
	add: #HTTPAcceptField;
	add: #HTTPAllowField;
	add: #HTTPAuthorizationBasicField;
	add: #HTTPAuthorizationDigestField;
	add: #HTTPAuthorizationField;
	add: #HTTPCacheControlField;
	add: #HTTPConnection;
	add: #HTTPConnectionField;
	add: #HTTPContentLengthField;
	add: #HTTPCookieField;
	add: #HTTPDateField;
	add: #HTTPDelete;
	add: #HTTPETagField;
	add: #HTTPException;
	add: #HTTPExpiresField;
	add: #HTTPGet;
	add: #HTTPHead;
	add: #HTTPHeaders;
	add: #HTTPHostField;
	add: #HTTPIfMatchField;
	add: #HTTPIfModifiedSinceField;
	add: #HTTPIfNoneMatchField;
	add: #HTTPIfRangeField;
	add: #HTTPIfUnmodifiedSinceField;
	add: #HTTPLastModifiedField;
	add: #HTTPLocationField;
	add: #HTTPMatchField;
	add: #HTTPMessage;
	add: #HTTPOptions;
	add: #HTTPPost;
	add: #HTTPPostDataArray;
	add: #HTTPPostDatum;
	add: #HTTPPut;
	add: #HTTPRefererField;
	add: #HTTPRequest;
	add: #HTTPRequestLine;
	add: #HTTPResponse;
	add: #HTTPServer;
	add: #HTTPServerField;
	add: #HTTPSetCookieField;
	add: #HTTPStreamedResponse;
	add: #HTTPString;
	add: #HTTPTrace;
	add: #HTTPUserAgentField;
	add: #HTTPWWWAuthenticateBasicField;
	add: #HTTPWWWAuthenticateDigestField;
	add: #HTTPWWWAuthenticateField;
	add: #MimeObject;
	add: #RedirectionResource;
	add: #ServerRootComposite;
	add: #SiteIdentifier;
	add: #SpecificHeaderField;
	add: #SwazooBenchmarks;
	add: #SwazooBuffer;
	add: #SwazooCacheControl;
	add: #SwazooCompiler;
	add: #SwazooHeaderFieldParseError;
	add: #SwazooHTTPParseError;
	add: #SwazooHTTPPostError;
	add: #SwazooHTTPPutError;
	add: #SwazooHTTPRequestError;
	add: #SwazooResource;
	add: #SwazooServer;
	add: #SwazooSite;
	add: #SwazooSiteError;
	add: #SwazooSocket;
	add: #SwazooStream;
	add: #SwazooStreamNoDataError;
	add: #SwazooTask;
	add: #SwazooURI;
	add: #TestPseudoSocket;
	add: #URIIdentifier;
	add: #URIResolution;
	yourself.

package methodNames
	add: #Collection -> #contains:;
	add: #SequenceableCollection -> #copyUpTo:;
	add: #SpFilename -> #etag;
	add: #SpFilename -> #lastModified;
	add: #String -> #asByteString;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'Object Arts\Dolphin\Base\Dolphin';
	add: 'Sport';
	yourself).

package!

"Class Definitions"!

Object subclass: #HeaderField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: 'httpFieldNameToClassDictionary'!
Object subclass: #HTTPConnection
	instanceVariableNames: 'stream loop server task'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPHeaders
	instanceVariableNames: 'fields'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPMessage
	instanceVariableNames: 'task headers'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPPostDataArray
	instanceVariableNames: 'underlyingCollection stream parsed'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPRequestLine
	instanceVariableNames: 'method requestURI httpVersion'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPServer
	instanceVariableNames: 'ip port connections sites socket loop isMultiThreading'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPString
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #MimeObject
	instanceVariableNames: 'contentType value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooBenchmarks
	instanceVariableNames: 'server content'
	classVariableNames: 'Singleton'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooCacheControl
	instanceVariableNames: 'request cacheTarget etag lastModified'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooCompiler
	instanceVariableNames: 'accessor'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooResource
	instanceVariableNames: 'enabled uriPattern parent'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooServer
	instanceVariableNames: 'sites servers watchdog'
	classVariableNames: 'Singleton'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooSocket
	instanceVariableNames: 'accessor'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooStream
	instanceVariableNames: 'socket readBuffer writeBuffer chunked'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooTask
	instanceVariableNames: 'connection request response'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooURI
	instanceVariableNames: 'protocol hostname port identifier queries'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #TestPseudoSocket
	instanceVariableNames: 'byteStreamToServer byteStreamFromServer clientWaitSemaphore serverWaitSemaphore ipAddress'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #URIIdentifier
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #URIResolution
	instanceVariableNames: 'position request'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Error subclass: #HTTPException
	instanceVariableNames: 'response'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpError subclass: #SwazooHeaderFieldParseError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpError subclass: #SwazooHTTPParseError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpError subclass: #SwazooHTTPRequestError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpError subclass: #SwazooSiteError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpError subclass: #SwazooStreamNoDataError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooHTTPRequestError subclass: #SwazooHTTPPostError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooHTTPRequestError subclass: #SwazooHTTPPutError
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HeaderField subclass: #GenericHeaderField
	instanceVariableNames: 'name value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HeaderField subclass: #SpecificHeaderField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #ContentDispositionField
	instanceVariableNames: 'type parameters'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #ContentTypeField
	instanceVariableNames: 'mediaType transferCodings'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPAcceptField
	instanceVariableNames: 'mediaTypes'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPAllowField
	instanceVariableNames: 'methods'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPAuthorizationField
	instanceVariableNames: 'credentials'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPCacheControlField
	instanceVariableNames: 'directives private maxAge noStore noCache mustRevalidate'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPConnectionField
	instanceVariableNames: 'connectionToken'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPContentLengthField
	instanceVariableNames: 'contentLength'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPCookieField
	instanceVariableNames: 'values'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPDateField
	instanceVariableNames: 'date'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPETagField
	instanceVariableNames: 'entityTag'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPExpiresField
	instanceVariableNames: 'timestamp'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPHostField
	instanceVariableNames: 'hostName portNumber'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPIfModifiedSinceField
	instanceVariableNames: 'date'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPIfRangeField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPIfUnmodifiedSinceField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPLastModifiedField
	instanceVariableNames: 'timestamp'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPLocationField
	instanceVariableNames: 'uri'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPMatchField
	instanceVariableNames: 'entityTags'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPRefererField
	instanceVariableNames: 'uri'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPServerField
	instanceVariableNames: 'productTokens'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPSetCookieField
	instanceVariableNames: 'cookies'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPUserAgentField
	instanceVariableNames: 'productTokens'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #HTTPWWWAuthenticateField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPAuthorizationField subclass: #HTTPAuthorizationBasicField
	instanceVariableNames: 'userid password'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPAuthorizationField subclass: #HTTPAuthorizationDigestField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPMatchField subclass: #HTTPIfMatchField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPMatchField subclass: #HTTPIfNoneMatchField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPWWWAuthenticateField subclass: #HTTPWWWAuthenticateBasicField
	instanceVariableNames: 'realm'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPWWWAuthenticateField subclass: #HTTPWWWAuthenticateDigestField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPMessage subclass: #HTTPRequest
	instanceVariableNames: 'requestLine peer timestamp ip environmentData resolution encrypted authenticated'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPMessage subclass: #HTTPResponse
	instanceVariableNames: 'code entity'
	classVariableNames: 'StatusCodes'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPDelete
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPGet
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPHead
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPOptions
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPPost
	instanceVariableNames: 'postData entityBody readPosition'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPPut
	instanceVariableNames: 'putData'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPTrace
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPResponse subclass: #FileResponse
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPResponse subclass: #HTTPStreamedResponse
	instanceVariableNames: 'stream count length state semaphore'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
MimeObject subclass: #HTTPPostDatum
	instanceVariableNames: 'filename writeStream writeBlock'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ReadWriteStream subclass: #SwazooBuffer
	instanceVariableNames: 'type resize'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #CompositeResource
	instanceVariableNames: 'children'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #FileMappingResource
	instanceVariableNames: 'directoryIndex filePath'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #HelloWorldResource
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #RedirectionResource
	instanceVariableNames: 'targetUri'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
CompositeResource subclass: #ServerRootComposite
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
CompositeResource subclass: #SwazooSite
	instanceVariableNames: 'name serving'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
FileMappingResource subclass: #FileResource
	instanceVariableNames: ''
	classVariableNames: 'ContentTypes'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
FileResource subclass: #HomeResource
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
URIIdentifier subclass: #SiteIdentifier
	instanceVariableNames: 'ip port host'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

!Collection methodsFor!

contains: aBlock
        "VW compatibility"

        ^self anySatisfy: aBlock ! !
!Collection categoriesFor: #contains:!public! !

!SequenceableCollection methodsFor!

copyUpTo: target
	^ self upTo: target! !
!SequenceableCollection categoriesFor: #copyUpTo:!copying!public! !

!SpFilename methodsFor!

etag
	"^a String
	The etag of a file entity is taken to be the date last modified as a String. 
	We use the SpTimestamp in "

	^self lastModified asRFC1123String!

lastModified

	^self modifiedTimestamp! !
!SpFilename categoriesFor: #etag!*Swazoo-accessing!public! !
!SpFilename categoriesFor: #lastModified!*Swazoo-accessing!public! !

!String methodsFor!

asByteString
	"Swazoo compatibility"

	^self copy! !
!String categoriesFor: #asByteString!converting!public! !

"End of package definition"!

"Source Globals"!

"Classes"!

HeaderField guid: (GUID fromString: '{BF3665F4-AA28-4FFB-AFD4-87DBEF50CF4D}')!
HeaderField comment: ''!
!HeaderField categoriesForClass!Unclassified! !
!HeaderField methodsFor!

combineWith: aHeaderField 
	SwazooHeaderFieldParseError raiseSignal: 'Not supported'!

fieldName
	^self subclassResponsibility!

isConditional
	^false!

isContentDisposition
	^false!

isContentType
	^false!

name
	^self subclassResponsibility!

printOn: aStream 
	aStream
		nextPutAll: self name;
		nextPutAll: ': '.
	self valuesAsStringOn: aStream.
	^self!

values
	^self subclassResponsibility!

valuesAsString
	| targetStream |
	targetStream := WriteStream on: String new.
	self valuesAsStringOn: targetStream.
	^targetStream contents!

valuesAsStringOn: aStream
	^self subclassResponsibility! !
!HeaderField categoriesFor: #combineWith:!public!services! !
!HeaderField categoriesFor: #fieldName!accessing!public! !
!HeaderField categoriesFor: #isConditional!public!testing! !
!HeaderField categoriesFor: #isContentDisposition!public!testing! !
!HeaderField categoriesFor: #isContentType!public!testing! !
!HeaderField categoriesFor: #name!accessing!public! !
!HeaderField categoriesFor: #printOn:!printing!public! !
!HeaderField categoriesFor: #values!accessing!public! !
!HeaderField categoriesFor: #valuesAsString!printing!public! !
!HeaderField categoriesFor: #valuesAsStringOn:!printing!public! !

!HeaderField class methodsFor!

classForFieldName: aString 
	"^a Class
If I can find a specific header field with a name matching aString I return that.  Otherwise I return the GenericHeaderField class."

	^self httpFieldNameToClassDictionary at: aString
		ifAbsent: [GenericHeaderField]!

fromLine: aString 
	| sourceStream fieldName fieldValue fieldClass |
	sourceStream := ReadStream on: aString.
	fieldName := (HTTPString trimBlanksFrom: (sourceStream upTo: $:)) 
				asUppercase.
	fieldClass := self classForFieldName: fieldName.
	fieldValue := HTTPString trimBlanksFrom: sourceStream upToEnd.
	^fieldClass newForFieldName: fieldName withValueFrom: fieldValue!

httpFieldNameToClassDictionary
	"^a Class
I return the dictionarry of my subclasses keyed on the name of the field they represent.
Note that we only need *Request* headers listed in here because they are the only thing we will be parsing for."

	"After a change here, remeber to do 'HeaderField resetHttpFieldNameToClassDictionary' "

	httpFieldNameToClassDictionary isNil 
		ifTrue: 
			[| headerClasses |
			headerClasses := OrderedCollection new.
			headerClasses
				add: ContentDispositionField;
				add: HTTPContentLengthField;
				add: ContentTypeField;
				add: HTTPAcceptField;
				add: HTTPAuthorizationField;
				add: HTTPConnectionField;
				add: HTTPHostField;
				add: HTTPIfMatchField;
				add: HTTPIfModifiedSinceField;
				add: HTTPIfNoneMatchField;
				add: HTTPIfRangeField;
				add: HTTPIfUnmodifiedSinceField;
				add: HTTPRefererField;
				add: HTTPUserAgentField.
			httpFieldNameToClassDictionary := Dictionary new.
			headerClasses do: 
					[:aClass | 
					httpFieldNameToClassDictionary at: aClass fieldName asUppercase put: aClass]].
	^httpFieldNameToClassDictionary!

newForFieldName: fieldNameString withValueFrom: fieldValueString 
	^self subclassResponsibility!

resetHttpFieldNameToClassDictionary
	
	httpFieldNameToClassDictionary := nil .
	^self! !
!HeaderField class categoriesFor: #classForFieldName:!private! !
!HeaderField class categoriesFor: #fromLine:!instance creation!public! !
!HeaderField class categoriesFor: #httpFieldNameToClassDictionary!private! !
!HeaderField class categoriesFor: #newForFieldName:withValueFrom:!private! !
!HeaderField class categoriesFor: #resetHttpFieldNameToClassDictionary!private! !

HTTPConnection guid: (GUID fromString: '{0A699BEA-64AD-46A0-8A53-62F10E5C7A50}')!
HTTPConnection comment: ''!
!HTTPConnection categoriesForClass!Unclassified! !
!HTTPConnection methodsFor!

close
	self stream notNil ifTrue: [self stream close. stream := nil].
	self server notNil ifTrue: [self server removeConnection: self].
	self loop notNil ifTrue: [self loop terminate. self loop: nil]!

getAndDispatchMessages
	"^self
	The HTTPRequest is read from my socket stream.  I then pass this request to my server
	to get a response. "
	self stream anyDataReady  "wait for data and if anything read, proceed"
		ifTrue:
			[self task: (SwazooTask newOn: self).
			self readRequestFor: self task.
			self produceResponseFor: self task.
			self task request wantsConnectionClose ifTrue: [self close].
			self task request isHttp10 ifTrue: [self close] ] "well, we won't complicate here"
		ifFalse: 
			[self keepAliveTimeout ifTrue: [^self close].
			(Delay forMilliseconds: 100) wait. "to finish sending, if any"
			self close].!

interact
	"longer description is below method"
	| interactionBlock |
	interactionBlock := 
		[[	[ [true] whileTrue: 
				[self getAndDispatchMessages.
				Processor yield] 
			]
			on: Error
			do: [:ex | Transcript cr. Transcript show: ex description "just ignore"] ]
		ifCurtailed: [ 
			(Delay forMilliseconds: 50) wait. "to finish sending, if any"
			self close] ].
	self server isMultiThreading 
		ifTrue: [self loop: (interactionBlock forkAt: Processor userBackgroundPriority)]
		ifFalse: [interactionBlock value].
	^self

"I represent a specifc connection with an HTTP client (a browser, probably) over which will come an HTTP request.  Here, I fork the handling of the request so that the current thread (which is most likely the HTTP server main loop) can carry on with the next request.  This means that more than one request may being handled in the image at a time, and that means that the application developer must worry about thread safety - e.g the problem of a given business object being updated by more than one HTTP request thread.
For a GemStone implementation of Swazoo, one may want only one request is handled at a time, multi-threadedness being handled by having multiple gems.  This is a nice option because the application developer does not have to worry about thread safety in this case - GemStone handles the hard stuff.
*And* the thing called a loop that was in this method was no such thing.  In all circumstances, >>getAndDispatchMessages handles exactly one requst and then closes the socket!! (very non-HTTP1.1).  Anyway, for now I'm just going to make that explicit.  This needs to be re-visited to support HTTP 1.1."!

isOpen
	"not yet closed"
	^self stream notNil!

keepAliveTimeout
	| seconds |
	self task isNil ifTrue: [^false].
	self task request isKeepAlive ifFalse: [^false].
	seconds := self task request keepAlive notNil
		ifTrue: [self task request keepAlive asInteger - 10 "to be sure"]
		ifFalse: [20]. "probably enough?"
	^(SpTimestamp now asSeconds - self task request timestamp asSeconds) >= seconds!

loop
	^loop!

loop: aProcess
	loop := aProcess!

nextPutError: aResponse 
	aResponse informConnectionClose.
	aResponse writeTo: self stream.
	self stream closeResponse.!

nextPutResponse: aMessage toRequest: aRequest 

	aRequest isHead 
		ifTrue: [aMessage writeHeaderTo: self stream]
		ifFalse: [aMessage writeTo: self stream ].
	self stream closeResponse.!

produceResponseFor: aSwazooTask 
	"Given the request in aTask I try to make a response.  If there are any unhandled 
	exceptions, respond with an internal server error."
	aSwazooTask request isNil ifTrue: [^nil].
	"SpExceptionContext for: "
		[aSwazooTask response: (self server answerTo: aSwazooTask request).
		aSwazooTask request ensureFullRead. "in case if defered parsing not done in HTTPost"
		aSwazooTask request wantsConnectionClose 
			ifTrue: [aSwazooTask response informConnectionClose]
			ifFalse: [aSwazooTask request isKeepAlive 
				ifTrue: [aSwazooTask response informConnectionKeepAlive] ].
		aSwazooTask response isStreamed 
			ifFalse: "streamed ones did that by themselves"
				[self nextPutResponse: aSwazooTask response toRequest: aSwazooTask request]
			ifTrue: [aSwazooTask response waitClose]. "to be sure all is sent"
		aSwazooTask request isGet ifFalse: [self close] ] "to avoid strange 200 bad requests 
			after two consecutive POSTs, but it is really a hack and original reason 
			must be found!!"
	on: Error do: [:ex | 
			self nextPutError: (HTTPResponse internalServerError: ex description).
			Transcript cr. Transcript show: ex description. Transcript cr.
			ex defaultAction."usually raise an UHE window"
			self close]
!

readRequestFor: aSwazooTask 
	"I read the next request from my socket and add it to aSwazooTask.  If I have any 
	problems and need to force a bad request (400) response, I add this response to aSwazooTask."
	| request |
	SpExceptionContext for: 
		[request := HTTPRequest readFrom: self stream.
		request uri port: self server port.
		(request httpVersion last = 1 
			and: [(request headers includesFieldOfClass: HTTPHostField) not]) 
				ifTrue: [aSwazooTask response: HTTPResponse badRequest].
		[request peer: self stream socket remoteAddress]
			on: Error do: [:ex | "do nothing for now"].
		request
			ip: self stream socket localAddress;
			setTimestamp.
		aSwazooTask request: request]
	on: SpError, HTTPException
	do: [:ex | 
		aSwazooTask response: HTTPResponse badRequest.
		self nextPutError: aSwazooTask response.
		self close].!

server
	^server!

server: aServer 
	server := aServer!

socket
	^self stream socket!

stream
	^stream!

stream: aSwazooStream 
	stream := aSwazooStream!

task
	"request/response pair, current or last one (until next request)"
	^task!

task: aSwazooTask
	"request/response pair, current or last one (until next request)"

	task := aSwazooTask! !
!HTTPConnection categoriesFor: #close!public!serving! !
!HTTPConnection categoriesFor: #getAndDispatchMessages!public!serving! !
!HTTPConnection categoriesFor: #interact!public!serving! !
!HTTPConnection categoriesFor: #isOpen!public!testing! !
!HTTPConnection categoriesFor: #keepAliveTimeout!public!testing! !
!HTTPConnection categoriesFor: #loop!private! !
!HTTPConnection categoriesFor: #loop:!private! !
!HTTPConnection categoriesFor: #nextPutError:!public!serving-responses! !
!HTTPConnection categoriesFor: #nextPutResponse:toRequest:!public!serving-responses! !
!HTTPConnection categoriesFor: #produceResponseFor:!public!serving! !
!HTTPConnection categoriesFor: #readRequestFor:!public!serving! !
!HTTPConnection categoriesFor: #server!private! !
!HTTPConnection categoriesFor: #server:!private! !
!HTTPConnection categoriesFor: #socket!private! !
!HTTPConnection categoriesFor: #stream!private! !
!HTTPConnection categoriesFor: #stream:!private! !
!HTTPConnection categoriesFor: #task!private! !
!HTTPConnection categoriesFor: #task:!private! !

!HTTPConnection class methodsFor!

socket: aSocket 
	^self new stream: aSocket stream! !
!HTTPConnection class categoriesFor: #socket:!instance creation!public! !

HTTPHeaders guid: (GUID fromString: '{71EA1B8D-34C2-4B30-9C91-6556CF4BD600}')!
HTTPHeaders comment: ''!
!HTTPHeaders categoriesForClass!Unclassified! !
!HTTPHeaders methodsFor!

addField: aField 
	"HTTPSpec1.1 Sec4.2
Multiple message-header fields with the same field-name MAY be present in a message if and only if the entire field-value for that header field is defined as a comma-separated list [i.e., #(values)]. It MUST be possible to combine the multiple header fields into one 'field-name: field-value' pair, without changing the semantics of the message, by appending each subsequent field-value to the first, each separated by a comma. The order in which header fields with the same field-name are received is therefore significant to the interpretation of the combined field value, and thus a proxy MUST NOT change the order of these field values when a message is forwarded.
Note that we have to use the field name here as we may be adding a field for which there is no class, i.e. it's a GenericHeaderField."

	(self includesFieldNamed: aField name) 
		ifTrue: [(self fieldNamed: aField name) combineWith: aField]
		ifFalse: [self fields at: aField name asUppercase put: aField].
	^self!

crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf!

fieldNamed: aString 
	"^aString
If I contain a field named aString, I return it.  Otherwise an exception is thrown.
This is a bad way of getting a field.  Use >> fieldOfClass: instead."

	| targetString |
	targetString := aString asUppercase.
	^self fields detect: [:aField | aField name asUppercase = targetString]!

fieldNamed: aString ifNone: aBlock 
	"^aString
If I contain a field named aString, I return it.  Otherwise I evaluate aBlock."

	^self fields at: aString asUppercase ifAbsent: aBlock!

fieldNamed: aFieldName ifPresent: presentBlock ifAbsent: absentBlock 
	"^an Object
I look for a field named aFieldName among my fields.  If I find it, I return the result of evaluating presentBlock with the found field as an argument, otherwise I return the result of evaluate the absentBlock"

	| foundField |
	foundField := self fieldNamed: aFieldName ifNone: [nil].
	^foundField isNil 
		ifTrue: [absentBlock value]
		ifFalse: [presentBlock value: foundField]!

fieldOfClass: aClass 
	"^aString
If I contain a field of class aClass, I return it.   Otherwise an exception is thrown."

	^self fields detect: [:aField | aField class == aClass] ifNone: [^nil]!

fieldOfClass: aClass ifNone: aBlock 
	"^aString
If I contain a field of class aClass, I return it.   Otherwise I evaluate aBlock."

	^self fields detect: [:aField | aField class == aClass] ifNone: aBlock!

fieldOfClass: fieldClass ifPresent: presentBlock ifAbsent: absentBlock 
	"^an Object
I look for a field of class fieldClass among my fields.  If I find it, I return the result of evaluating presentBlock with the found field as an argument, otherwise I return the result of evaluate the absentBlock"

	| foundField |
	foundField := self fieldOfClass: fieldClass ifNone: [nil].
	^foundField isNil 
		ifTrue: [absentBlock value]
		ifFalse: [presentBlock value: foundField]!

fields
	fields isNil ifTrue: [fields := Dictionary new].
	^fields!

getOrMakeFieldOfClass: aClass 
	"^a HeaderField
If I contain a field of class aClass, I return it.   Otherwise I create a new instance if the field class and add it to my collection of headers."

	^self fieldOfClass: aClass
		ifNone: 
			[| newField |
			newField := aClass new.
			self addField: newField.
			newField]!

includesFieldNamed: aString 
	"^a Boolean
I return true if one of my fields has the name aString."

	| targetField |
	targetField := self fieldNamed: aString ifNone: [nil].
	^targetField notNil!

includesFieldOfClass: aClass 
	"^a Boolean
I return true if one of my fields is of class aClass."

	^self 
		fieldOfClass: aClass
		ifPresent: [:aField | true]
		ifAbsent: [false]!

printOn: aStream
	aStream nextPutAll: 'a HTTPHeaders'; cr.
	self fields values do: [:each | aStream nextPutAll: '   ', each printString; cr]!

readFieldFromString: aString 
	"^self
First I get the field parsed from aString, then I add the new field to my collection of fields.  Adding the new field may involve merging field values if I already have a field of that class."

	self addField: (HeaderField fromLine: aString).
	^self!

readFrom: aSwazooStream 
	"^an HTTPHeaders
I return a new instance of myself which contains fields parsed from aStream.  Everything upto the next blank line is a header field."
	
	| nextLine |
	[nextLine := aSwazooStream nextUnfoldedLine.
	nextLine isEmpty]
		whileFalse: [self readFieldFromString: nextLine].
	^self!

writeOn: aStream 
	"^self
I write all my fields to aStream."

	self fields do: 
			[:aField | 
			aField printOn: aStream.
			self crlfOn: aStream]! !
!HTTPHeaders categoriesFor: #addField:!public!services! !
!HTTPHeaders categoriesFor: #crlfOn:!emitting!public! !
!HTTPHeaders categoriesFor: #fieldNamed:!public!services! !
!HTTPHeaders categoriesFor: #fieldNamed:ifNone:!public!services! !
!HTTPHeaders categoriesFor: #fieldNamed:ifPresent:ifAbsent:!public!services! !
!HTTPHeaders categoriesFor: #fieldOfClass:!public!services! !
!HTTPHeaders categoriesFor: #fieldOfClass:ifNone:!public!services! !
!HTTPHeaders categoriesFor: #fieldOfClass:ifPresent:ifAbsent:!public!services! !
!HTTPHeaders categoriesFor: #fields!private! !
!HTTPHeaders categoriesFor: #getOrMakeFieldOfClass:!public!services! !
!HTTPHeaders categoriesFor: #includesFieldNamed:!public!testing! !
!HTTPHeaders categoriesFor: #includesFieldOfClass:!public!testing! !
!HTTPHeaders categoriesFor: #printOn:!private! !
!HTTPHeaders categoriesFor: #readFieldFromString:!initialize-release!public! !
!HTTPHeaders categoriesFor: #readFrom:!initialize-release!public! !
!HTTPHeaders categoriesFor: #writeOn:!emitting!public! !

!HTTPHeaders class methodsFor!

readFrom: aSwazooStream 
	"^an HTTPHeaders
I return a new instance of myself which contains fields parsed from aStream."

	^self new readFrom: aSwazooStream! !
!HTTPHeaders class categoriesFor: #readFrom:!instance creation!public! !

HTTPMessage guid: (GUID fromString: '{2FFFC139-C6D0-4264-BB79-AA45AA1C75E0}')!
HTTPMessage comment: ''!
!HTTPMessage categoriesForClass!Unclassified! !
!HTTPMessage methodsFor!

addInitialHeaders
	"^self 
This is a no-op.  My subclasses may wish to add some initial headers."

	^self!

headers

	headers isNil ifTrue: [self initHeaders].
	^headers!

initHeaders
	headers := HTTPHeaders new.
	self addInitialHeaders.!

task
	"on which task (request/response pair) this message belongs"
	"to get a connection on which this task belongs, use task connection"
	^task!

task: aSwazooTask

	task := aSwazooTask! !
!HTTPMessage categoriesFor: #addInitialHeaders!initialize-release!public! !
!HTTPMessage categoriesFor: #headers!accessing!public! !
!HTTPMessage categoriesFor: #initHeaders!initialize-release!public! !
!HTTPMessage categoriesFor: #task!accessing!public! !
!HTTPMessage categoriesFor: #task:!accessing!public! !

HTTPPostDataArray guid: (GUID fromString: '{22ED603D-51A6-45C2-97E4-343B9EE82A19}')!
HTTPPostDataArray comment: '
Introduced the HTTPPostDataArray to hold post data in an HTTPRequest in place of a Dictionary.  This is because it is legal for there to be more than one entry with the same name (key) and using a Dictionary  looses data (!!!!).

Instance Variables:
	underlyingCollection	<>	

'!
!HTTPPostDataArray categoriesForClass!Unclassified! !
!HTTPPostDataArray methodsFor!

allAt: aKey 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates collect: [:anAssociation| anAssociation value]!

allNamesForValue: aString 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation value value = aString].
	^candidates collect: [:anAssociation| anAssociation key]!

associations
	^self underlyingCollection!

at: aKey 
	^(self allAt: aKey) last!

at: aKey ifAbsent: aBlock 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates isEmpty ifTrue: [aBlock value] ifFalse: [candidates last value]!

at: key put: anObject 

	self underlyingCollection add: (Association key: key value: anObject).
	^anObject!

clearParsed
	parsed := false!

includesKey: aKey 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates notEmpty!

includesValue: aString 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation value value = aString].
	^candidates notEmpty!

initialize
	self clearParsed!

isEmpty
	^self underlyingCollection isEmpty!

isParsed
	"postdata is already read and parsed from a request"
	^parsed!

keys
"^a Set
I mimick the behavior of a Dictionay which I replace.  I return a set of the keys in my underlying collection of associations."

	^(self underlyingCollection collect: [:anAssociation| anAssociation key]) asSet!

keysAndValuesDo: aTwoArgumentBlock 
	self underlyingCollection do: 
		[:anAssociation | aTwoArgumentBlock value: anAssociation key value: anAssociation value]!

nameForValue: aString
	^(self allNamesForValue: aString) last!

printOn: aStream
	aStream nextPutAll: 'HTTPPostDataArray 
	'.
	self underlyingCollection do: [:each | aStream nextPutAll: each key printString , '->', 
		each value value printString, '
	'].!

select: aBlock 
"^an Object
I run the select on the values of the associations in my underlying collection.  This mimicks the behavior when a Dictionary was used in my place."
	^self underlyingCollection select:  [:anAssociation| aBlock value: anAssociation value]!

setParsed
	parsed := true!

stream
	^stream!

stream: aSwazooStream
	"needed for defered postData parsing"
	stream := aSwazooStream!

underlyingCollection
	underlyingCollection isNil 
		ifTrue: [underlyingCollection := OrderedCollection new].
	^underlyingCollection! !
!HTTPPostDataArray categoriesFor: #allAt:!accessing!public! !
!HTTPPostDataArray categoriesFor: #allNamesForValue:!accessing!public! !
!HTTPPostDataArray categoriesFor: #associations!accessing!public! !
!HTTPPostDataArray categoriesFor: #at:!accessing!public! !
!HTTPPostDataArray categoriesFor: #at:ifAbsent:!accessing!public! !
!HTTPPostDataArray categoriesFor: #at:put:!accessing!public! !
!HTTPPostDataArray categoriesFor: #clearParsed!accessing!public! !
!HTTPPostDataArray categoriesFor: #includesKey:!accessing!public! !
!HTTPPostDataArray categoriesFor: #includesValue:!accessing!public! !
!HTTPPostDataArray categoriesFor: #initialize!initialize-release!public! !
!HTTPPostDataArray categoriesFor: #isEmpty!public!testing! !
!HTTPPostDataArray categoriesFor: #isParsed!public!testing! !
!HTTPPostDataArray categoriesFor: #keys!accessing!public! !
!HTTPPostDataArray categoriesFor: #keysAndValuesDo:!enumerating!public! !
!HTTPPostDataArray categoriesFor: #nameForValue:!accessing!public! !
!HTTPPostDataArray categoriesFor: #printOn:!private! !
!HTTPPostDataArray categoriesFor: #select:!enumerating!public! !
!HTTPPostDataArray categoriesFor: #setParsed!accessing!public! !
!HTTPPostDataArray categoriesFor: #stream!private! !
!HTTPPostDataArray categoriesFor: #stream:!private! !
!HTTPPostDataArray categoriesFor: #underlyingCollection!private! !

!HTTPPostDataArray class methodsFor!

newOn: aSwazooStream

	^super new 
		initialize;
		stream: aSwazooStream! !
!HTTPPostDataArray class categoriesFor: #newOn:!instance creation!public! !

HTTPRequestLine guid: (GUID fromString: '{E1D2148D-995D-4AB3-A4EC-3BAB9E93DD1B}')!
HTTPRequestLine comment: ''!
!HTTPRequestLine categoriesForClass!Unclassified! !
!HTTPRequestLine methodsFor!

httpVersion
	^httpVersion!

httpVersion: anArray 
	httpVersion := anArray.
	^self!

isHttp10
	^self httpVersion last = 0!

isHttp11
	^self httpVersion last = 1!

method
	^method!

method: aString
"For development testing only"
	method := aString.
	^self!

parseHTTPVersionFrom: aSwazooStream 
	| major minor |
	self skipSpacesIn: aSwazooStream.
	aSwazooStream upTo: $/ asInteger.
	major := (aSwazooStream upTo: $. asInteger) asString asNumber.
	minor := (aSwazooStream upTo: Character cr asInteger) asString asNumber.
	self httpVersion: (Array with: major with: minor).
	aSwazooStream next.
	^self!

parseURIFrom: aSwazooStream 
	"^self
	Really, we should parse the URI directly out of the stream."

	self skipSpacesIn: aSwazooStream.
	requestURI := SwazooURI fromString: 
		(aSwazooStream upTo: Character space asInteger) asString.
	^self!

readFrom: aSwazooStream 
	"^self
I initialize myself to represents a request line read from aStream.  If no valid request line can be found, I throw an exception."

	self skipLeadingBlankLinesIn: aSwazooStream.
	method := (aSwazooStream upTo: Character space asInteger) asString.
	self parseURIFrom: aSwazooStream.
	self parseHTTPVersionFrom: aSwazooStream.
	^self!

requestURI
	^requestURI!

requestURI: aString 
	"Development testing only!!"

	requestURI := aString.
	^self!

skipLeadingBlankLinesIn: aSwazooStream 
	"^self
RFC 2616:
In the interest of robustness, servers SHOULD ignore any empty
line(s) received where a Request-Line is expected. In other words, if
the server is reading the protocol stream at the beginning of a
message and receives a CRLF first, it should ignore the CRLF."

	[aSwazooStream peek == Character cr asInteger] whileTrue: 
			[(((aSwazooStream next: 2) at: 2) == Character lf asInteger) 
				ifFalse: [SwazooHTTPParseError raiseSignal: 'CR without LF']].
	^self!

skipSpacesIn: aSwazooStream 
	[aSwazooStream peek = Character space] 
		whileTrue: [aSwazooStream next].
	^self! !
!HTTPRequestLine categoriesFor: #httpVersion!accessing!public! !
!HTTPRequestLine categoriesFor: #httpVersion:!private! !
!HTTPRequestLine categoriesFor: #isHttp10!public!testing! !
!HTTPRequestLine categoriesFor: #isHttp11!public!testing! !
!HTTPRequestLine categoriesFor: #method!accessing!public! !
!HTTPRequestLine categoriesFor: #method:!private! !
!HTTPRequestLine categoriesFor: #parseHTTPVersionFrom:!parsing!public! !
!HTTPRequestLine categoriesFor: #parseURIFrom:!parsing!public! !
!HTTPRequestLine categoriesFor: #readFrom:!parsing!public! !
!HTTPRequestLine categoriesFor: #requestURI!accessing!public! !
!HTTPRequestLine categoriesFor: #requestURI:!private! !
!HTTPRequestLine categoriesFor: #skipLeadingBlankLinesIn:!private! !
!HTTPRequestLine categoriesFor: #skipSpacesIn:!private! !

!HTTPRequestLine class methodsFor!

readFrom: aSwazooStream 
	^self new readFrom: aSwazooStream! !
!HTTPRequestLine class categoriesFor: #readFrom:!instance creation!public! !

HTTPServer guid: (GUID fromString: '{37521F86-CA4A-43B1-B6AE-623F2B1DC844}')!
HTTPServer comment: ''!
!HTTPServer categoriesForClass!Unclassified! !
!HTTPServer methodsFor!

acceptConnection
	"^self
I accept the next inbound TCP/IP connection.  The operating system libraries queue these up for me, so I can just handle one at a time.  I create an HTTPConnection instance to actually handle the interaction with the client - if I am in single threaded mode, the connection will completely handle the request before returning control to me, but in multi-threaded mode the connection forks the work into a sepparate thread in this image and control is immediately returned to me (the application programmer must worry about thread safety in this case."

	| clientConnection |
	clientConnection := SpExceptionContext 
				for: [HTTPConnection socket: self socket accept]
				on: SpError
				do: [:ex | Transcript show: 'Socket accept error: ' , ex errorString; cr. ^self].
	self addConnection: clientConnection.
	clientConnection interact.
	^self!

addConnection: aConnection 
	self connections add: aConnection.
	aConnection server: self!

addSite: aSite
	(self sites includesResource: aSite) ifFalse: [^self sites addResource: aSite]!

answerTo: aRequest 
	| response |

	response := URIResolution resolveRequest: aRequest startingAt: self sites.
	^response isNil
		ifTrue: [HTTPResponse notFound]
		ifFalse: [response]!

connections
	connections isNil ifTrue: [self initConnections].
	^connections!

hasNoSites
	^self sites hasNoResources!

initConnections
	connections := OrderedCollection new.!

initialize
	self initConnections.
	self initSites!

initSites
	sites := ServerRootComposite new!

ip
	^ip!

ip: anIPString 
	ip := anIPString!

ipCorrected
	"in case of '*' always return '0.0.0.0'"
	^self ip = '*' 
		ifTrue: ['0.0.0.0'] 
		ifFalse: [self ip]!

isMultiThreading
	"^a Boolean
I return true if each inbound HTTP connection will be handled in its own thread.  See the senders of this message to see where that is important.  Note that the default mode is mult-threaded because this is how Swazoo has worked so far.  This is tricky for the application programmer, though, as they must ensure that they work in a thread safe way (e.g. avoid the many threads updating the same object).  For those deploying to GemStone, you wil find things much easier if you do *not* run multithreaded, but rather run many gems each with a single-threaded Swazoo instance (and your app logic) in each.  Also in GemStone, run the main loop in the foreground, c.f. >>mainLoopInForeground"

	isMultiThreading isNil ifTrue: [self setMultiThreading].
	^isMultiThreading!

isServing
	^self loop notNil!

loop
	^loop!

loop: aProcess
	loop := aProcess!

port
	^port!

port: aNumber
	port := aNumber!

removeConnection: aConnection 
	self connections remove: aConnection ifAbsent: [nil]!

removeSite: aSite 
	^self sites removeResource: aSite!

restart
	"usefull after image startup, when socket is probably not valid anymore"
	self stop.
	self start.!

setMultiThreading
	"^self
I record that this HTTP server is to operate in a multi-threaded mode.  c.f. isMultiThreading"

	isMultiThreading := true.
	^self!

setSingleThreading
	"^self
I record that this HTTP server is to operate in a single-threaded mode.  c.f. isMultiThreading"

	isMultiThreading := false.
	^self!

sites
	sites isNil ifTrue: [self initSites].
	^sites!

socket
	^socket!

socket: aSocket
	socket := aSocket!

socketClass
	"^a Class
I use SwazooSocket to wrap the actual socket.  SwazooSocket does some of the byte translation work for me."

	^SwazooSocket!

start
	self loop isNil 
		ifTrue: 
			[self socket: (self socketClass serverOnIP: self ipCorrected port: self port).
			self socket listenFor: 50.
			self loop: ([[self acceptConnection] repeat] 
						forkAt: Processor userBackgroundPriority)]!

stop
	self loop isNil 
		ifFalse: 
			[self connections copy do: [:each | each close].
			self loop terminate.
			self loop: nil.
			self socket close.
			self socket: nil]! !
!HTTPServer categoriesFor: #acceptConnection!private! !
!HTTPServer categoriesFor: #addConnection:!private! !
!HTTPServer categoriesFor: #addSite:!public!sites! !
!HTTPServer categoriesFor: #answerTo:!public!serving! !
!HTTPServer categoriesFor: #connections!private! !
!HTTPServer categoriesFor: #hasNoSites!public!sites! !
!HTTPServer categoriesFor: #initConnections!private-initialize!public! !
!HTTPServer categoriesFor: #initialize!private-initialize!public! !
!HTTPServer categoriesFor: #initSites!private-initialize!public! !
!HTTPServer categoriesFor: #ip!private-initialize!public! !
!HTTPServer categoriesFor: #ip:!private-initialize!public! !
!HTTPServer categoriesFor: #ipCorrected!private-initialize!public! !
!HTTPServer categoriesFor: #isMultiThreading!multithreading!public! !
!HTTPServer categoriesFor: #isServing!public!testing! !
!HTTPServer categoriesFor: #loop!private! !
!HTTPServer categoriesFor: #loop:!private! !
!HTTPServer categoriesFor: #port!private-initialize!public! !
!HTTPServer categoriesFor: #port:!private-initialize!public! !
!HTTPServer categoriesFor: #removeConnection:!private! !
!HTTPServer categoriesFor: #removeSite:!public!sites! !
!HTTPServer categoriesFor: #restart!public!start/stop! !
!HTTPServer categoriesFor: #setMultiThreading!multithreading!public! !
!HTTPServer categoriesFor: #setSingleThreading!multithreading!public! !
!HTTPServer categoriesFor: #sites!private! !
!HTTPServer categoriesFor: #socket!private! !
!HTTPServer categoriesFor: #socket:!private! !
!HTTPServer categoriesFor: #socketClass!private! !
!HTTPServer categoriesFor: #start!public!start/stop! !
!HTTPServer categoriesFor: #stop!public!start/stop! !

!HTTPServer class methodsFor!

initialize
	SpEnvironment addImageShutdownTask: [self shutDown] for: self!

new
	^super new initialize!

shutDown 
	"HTTPServer shutDown"
	self allInstances do: [:each | each stop].
	SpEnvironment removeShutdownActionFor: self.! !
!HTTPServer class categoriesFor: #initialize!intialize-release!public! !
!HTTPServer class categoriesFor: #new!instance creation!public! !
!HTTPServer class categoriesFor: #shutDown!intialize-release!public! !

HTTPString guid: (GUID fromString: '{5FFE866F-2A42-4584-BBB2-A6976D8D86E0}')!
HTTPString comment: '
This class contains some utility methods that were previously implemented as extentions to system classes.  This is really a stop-gap until, perhaps, the SwazooStream yeilds HTTPStrings.

'!
!HTTPString categoriesForClass!Unclassified! !
!HTTPString class methodsFor!

decodedHTTPFrom: aCharacterArray 
	"Code taken from the swazoo specific extention to the CharacterArray class"

	| targetStream sourceStream |
	targetStream := WriteStream on: aCharacterArray class new.
	sourceStream := ReadStream on: aCharacterArray.
	[sourceStream atEnd] whileFalse: 
			[| char |
			char := sourceStream next.
			char = $% 
				ifTrue: 
					[targetStream 
						nextPut: (SpEnvironment integerFromString: '16r' , (sourceStream next: 2)) 
								asCharacter]
				ifFalse: 
					[char == $+ 
						ifTrue: [targetStream nextPut: Character space]
						ifFalse: [targetStream nextPut: char]]].
	^targetStream contents!

encodedHTTPFrom: aCharacterArray 
	"Code taken from the swazoo specific extention to the CharacterArray class"

	| targetStream |
	targetStream := WriteStream on: aCharacterArray class new.
	aCharacterArray do: 
			[:char | 
			(self isHTTPReservedCharacter: char) 
				ifTrue: 
					[targetStream nextPut: $%.
					targetStream nextPutAll:
						(char asInteger printPaddedWith: $0 to: 2 base: 16)
"					char asInteger 
						printOn: targetStream
						paddedWith: $0
						to: 2
						base: 16" ]
				ifFalse: [targetStream nextPut: char]].
	^targetStream contents!

isHTTPReservedCharacter: aCharacter 
	"Code taken from the swazoo specific extention to the Character class"

	^(aCharacter isAlphaNumeric or: ['-_.!!~*''()' includes: aCharacter]) not!

newRandomString: anInteger 
	| numbersThroughAlphas targetStream char random |
	numbersThroughAlphas := (48 to: 122) collect: [:each | each asCharacter].
	targetStream := WriteStream on: (String new: anInteger).
	random := Random new.
	[targetStream contents size < anInteger] whileTrue: 
			[char := numbersThroughAlphas 
						at: (random next * (numbersThroughAlphas size - 1)) rounded + 1.
			char isAlphaNumeric ifTrue: [targetStream nextPut: char]].
	^targetStream contents!

stringFromBytes: aByteArray 
	"^a String
In GemStone ['Hello, World' asByteArray asString] returns the string 'aByteArray' !!
This is the boring long way of getting a string from a ByteArray - but it does work
in GemStone."

	"HTTPString stringFromBytes: ('Hello, World' asByteArray)"

	| targetStream |
	targetStream := WriteStream on: String new.
	aByteArray do: [:aByte | targetStream nextPut: aByte asCharacter].
	^targetStream contents!

subCollectionsFrom: aCollection delimitedBy: anObject 
	"^an OrderedCollection
I return the ordered collection of sub-collections from aCollection, delimited
by anObject."

	"HTTPString subCollectionsFrom: 'aaa/bbb/' delimitedBy: $/"

	| subCollections sourceStream |
	subCollections := OrderedCollection new.
	sourceStream := ReadStream on: aCollection.
	[sourceStream atEnd] 
		whileFalse: [subCollections add: (sourceStream upTo: anObject)].
	(aCollection isEmpty 
		or: [(sourceStream
				skip: -1;
				next) == anObject]) 
			ifTrue: [subCollections add: aCollection class new].
	^subCollections!

trimBlanksFrom: aString 
	"^a String
I return a copy of aString with all leading and trailing blanks removed."

	| first last |
	first := 1.
	last := aString size.
	[last > 0 and: [(aString at: last) isSeparator]] 
		whileTrue: [last := last - 1].
	^last == 0 
		ifTrue: [String new]
		ifFalse: 
			[[first < last and: [(aString at: first) isSeparator]] 
				whileTrue: [first := first + 1].
			aString copyFrom: first to: last]! !
!HTTPString class categoriesFor: #decodedHTTPFrom:!decoding!public! !
!HTTPString class categoriesFor: #encodedHTTPFrom:!decoding!public! !
!HTTPString class categoriesFor: #isHTTPReservedCharacter:!decoding!public! !
!HTTPString class categoriesFor: #newRandomString:!instance creation!public! !
!HTTPString class categoriesFor: #stringFromBytes:!decoding!public! !
!HTTPString class categoriesFor: #subCollectionsFrom:delimitedBy:!public!tokens! !
!HTTPString class categoriesFor: #trimBlanksFrom:!decoding!public! !

MimeObject guid: (GUID fromString: '{D43F5EE3-B909-4FD7-90E3-EBA4DF25AB0D}')!
MimeObject comment: ''!
!MimeObject categoriesForClass!Unclassified! !
!MimeObject methodsFor!

contentType
	^contentType isNil ifTrue: [self defaultContentType] ifFalse: [contentType]!

contentType: anObject
	contentType := anObject!

defaultContentType
	^'application/octet-stream'!

value
	^value!

value: anObject
	value := anObject! !
!MimeObject categoriesFor: #contentType!accessing!public! !
!MimeObject categoriesFor: #contentType:!accessing!public! !
!MimeObject categoriesFor: #defaultContentType!private-accessing!public! !
!MimeObject categoriesFor: #value!accessing!public! !
!MimeObject categoriesFor: #value:!accessing!public! !

SwazooBenchmarks guid: (GUID fromString: '{5ED85CE5-628F-4CCD-BDC8-F94E03455EDF}')!
SwazooBenchmarks comment: '
SwazooBenchmarks stores several benchmarks and performance routines

'!
!SwazooBenchmarks categoriesForClass!Unclassified! !
!SwazooBenchmarks methodsFor!

content
	"test content to be writen to the socket"
	content isNil ifTrue: [self initContent].
	^content!

content: aByteArray
	content := aByteArray!

contentSize
	^4!

initContent
	| response ws |
	response := HTTPResponse ok.
	response entity: (ByteArray new: self contentSize withAll: 16r55).
	ws := SwazooStream on: String new.
	response writeTo: ws.
	content := ws writeBuffer contents.!

server
	"TCP server loop"
	^server!

server: aProcess
	"TCP server loop"
	server := aProcess!

serverLoop
	| socket clientSocket |
	socket := SpSocket newTCPSocket.
	socket
		setAddressReuse: true;
		bindSocketAddress: (SpIPAddress hostName: 'localhost' port: 9999).
	[	socket listenBackloggingUpTo: 50.
		[true] whileTrue: 
			[ 	clientSocket := socket accept.
				[ [true] whileTrue: 
					[clientSocket underlyingSocket waitForData.
					clientSocket read: 60. "HTTP request"
					clientSocket write: self content] ]
				on: Error "probably connection close by peer"
				do: [:ex | "nothing"]
			]
	] ensure: [clientSocket notNil ifTrue: [clientSocket close]. socket close]!

startSocketServer
	"SwazooBenchmarks singleton startSocketServer"
	"SwazooBenchmarks singleton stopSocketServer"
	"testing raw socket performance.
	it will start a server on localhost:9999 to receive a request 
      and respond with 10K response as drirectly as possible."

	self stopSocketServer. 
	self server: [self serverLoop] fork.!

stopSocketServer
	"SwazooBenchmarks singleton stopSocketServer"
	self server notNil ifTrue: [self server terminate. self server: nil].
	self content: nil.
	(Delay forMilliseconds: 1000) wait.
! !
!SwazooBenchmarks categoriesFor: #content!accessing!public! !
!SwazooBenchmarks categoriesFor: #content:!accessing!public! !
!SwazooBenchmarks categoriesFor: #contentSize!initialize-release!public! !
!SwazooBenchmarks categoriesFor: #initContent!initialize-release!public! !
!SwazooBenchmarks categoriesFor: #server!accessing!public! !
!SwazooBenchmarks categoriesFor: #server:!accessing!public! !
!SwazooBenchmarks categoriesFor: #serverLoop!public!socket performance! !
!SwazooBenchmarks categoriesFor: #startSocketServer!public!socket performance! !
!SwazooBenchmarks categoriesFor: #stopSocketServer!public!socket performance! !

!SwazooBenchmarks class methodsFor!

singleton
	Singleton isNil ifTrue: [Singleton := self new].
	^Singleton! !
!SwazooBenchmarks class categoriesFor: #singleton!accessing!public! !

SwazooCacheControl guid: (GUID fromString: '{78E318A6-655C-4915-B02A-D2F97A344AA0}')!
SwazooCacheControl comment: ''!
!SwazooCacheControl categoriesForClass!Unclassified! !
!SwazooCacheControl methodsFor!

addNotModifedHeaders: aResponse 
	"RFC2616 10.3.5
	If the conditional GET used a strong cache validator (see section 13.3.3), the response SHOULD NOT include other entity-headers. ... this prevents inconsistencies between cached entity-bodies and updated headers. "

	self isRequestStrongValidator 
		ifTrue: [aResponse headers addField: (HTTPETagField new entityTag: self etag)]
		ifFalse: [self basicAddResponseHeaders: aResponse].
	^aResponse!

addResponseHeaders: aResponse 
	"Add response headers to the response.
	We MUST differentiate between 200/302 responses"

	^aResponse isNotModified 
		ifTrue: [self addNotModifedHeaders: aResponse]
		ifFalse: [self basicAddResponseHeaders: aResponse]!

basicAddResponseHeaders: aResponse 
	"RFC 2616 13.3.4
	HTTP/1.1 origin servers: 
      	- SHOULD send an entity tag validator unless it is not feasible to generate one.
		- SHOULD send a Last-Modified value "

	aResponse headers addField: (HTTPETagField new entityTag: self etag).
	aResponse headers addField: (HTTPLastModifiedField new timestamp: self lastModified).
	^aResponse!

cacheTarget
	^cacheTarget!

etag
	etag isNil ifTrue: [etag := self generateETag].
	^etag!

etag: aString 
	etag := aString!

generateETag
	^self cacheTarget etag!

generateLastModified
	^self cacheTarget lastModified!

isIfModifiedSince
	"Answers true if either 
		- the request does not included the header
		-or there is not a match"

	| ifModifiedSince |
	ifModifiedSince := request headers fieldOfClass: HTTPIfModifiedSinceField
				ifNone: [nil].
	^ifModifiedSince isNil or: [self lastModified > ifModifiedSince date]!

isIfNoneMatch
	"Answers true if either 
		- the request does not included the header
		-or there is not a match"

	| field |
	field := request headers fieldOfClass: HTTPIfNoneMatchField ifNone: [nil].
	^field isNil or: [(field entityTags includes: self etag) not]!

isNotModified
	"Compare the cacheTarget with the request headers and answer if the client's version is not modified.
	Takes into account http version, and uses best practices defined by HTTP spec"

	^self isIfNoneMatch not or: [self isIfModifiedSince not]!

isRequestStrongValidator
	| field |
	field := request headers fieldOfClass: HTTPIfNoneMatchField ifNone: [nil].
	^field notNil and: [field entityTags isEmpty not]!

lastModified
	lastModified isNil ifTrue: [lastModified := self generateLastModified].
	^lastModified!

lastModified: aRFC1123TimeStampString 
	lastModified := aRFC1123TimeStampString!

request: aHTTPGet cacheTarget: anObject 
	request := aHTTPGet.
	cacheTarget := anObject! !
!SwazooCacheControl categoriesFor: #addNotModifedHeaders:!operations!public! !
!SwazooCacheControl categoriesFor: #addResponseHeaders:!operations!public! !
!SwazooCacheControl categoriesFor: #basicAddResponseHeaders:!operations!public! !
!SwazooCacheControl categoriesFor: #cacheTarget!accessing!public! !
!SwazooCacheControl categoriesFor: #etag!accessing!public! !
!SwazooCacheControl categoriesFor: #etag:!accessing!public! !
!SwazooCacheControl categoriesFor: #generateETag!operations!public! !
!SwazooCacheControl categoriesFor: #generateLastModified!operations!public! !
!SwazooCacheControl categoriesFor: #isIfModifiedSince!public!testing! !
!SwazooCacheControl categoriesFor: #isIfNoneMatch!public!testing! !
!SwazooCacheControl categoriesFor: #isNotModified!public!testing! !
!SwazooCacheControl categoriesFor: #isRequestStrongValidator!public!testing! !
!SwazooCacheControl categoriesFor: #lastModified!public!testing! !
!SwazooCacheControl categoriesFor: #lastModified:!public!testing! !
!SwazooCacheControl categoriesFor: #request:cacheTarget:!accessing!public! !

SwazooCompiler guid: (GUID fromString: '{B00DB831-6F06-479F-AC25-EA317BB47303}')!
SwazooCompiler comment: ''!
!SwazooCompiler categoriesForClass!Unclassified! !
!SwazooCompiler class methodsFor!

evaluate: aString 
        ^SpEnvironment
            evaluate: aString
            receiver: SwazooCompiler
            in: self class environment!

evaluate: aString receiver: anObject 
	^SpEnvironment 
		evaluate: aString
		receiver: anObject
		in: self class environment! !
!SwazooCompiler class categoriesFor: #evaluate:!evaluation!public! !
!SwazooCompiler class categoriesFor: #evaluate:receiver:!evaluation!public! !

SwazooResource guid: (GUID fromString: '{A7C04396-E1BA-44FE-9B77-F80D65AB379A}')!
SwazooResource comment: 'Resource is an abstract class for all so called web resources. Such resource has its url address and can serve with responding to web requests. Every resource need to #answerTo: aHTTPRequest with aHTTPResponse. Site is a subclass of a Resource. You can subclass it with your own implementation. There is also a CompositeResource, which can hold many subresources. Site is also aCopmpositeResource and therefore you can add your own resources to your site.'!
!SwazooResource categoriesForClass!Unclassified! !
!SwazooResource methodsFor!

answerTo: aRequest
	"override in your Resource and return a HTTPResponse"
	^nil!

authenticationRealm
	"rfc2617 3.2.1: A string to be displayed to users so they know which username and
     password to use. This string should contain at least the name of
     the host performing the authentication and might additionally
     indicate the collection of users who might have access. An example
     might be 'registered_users@gotham.news.com' "
	^'Swazoo server'!

authenticationScheme
	"#Basic or #Digest, see rfc2617. Digest is recomended because password
	goes encrypted to server"
	^#Digest!

canAnswer
	^self isEnabled and: [self isValidlyConfigured]!

currentUrl
	| stream |
	stream := WriteStream on: String new.
	self printUrlOn: stream.
	^stream contents!

disable
	enabled := false!

enable
	enabled := true!

helpResolve: aResolution 
	^aResolution resolveLeafResource: self!

initialize
	self enable.
	self initUriPattern!

initUriPattern
	self uriPattern: ''!

isEnabled
	^enabled!

isValidlyConfigured
	^self uriPattern ~= ''!

match: anIdentifier 
	^self uriPattern match: anIdentifier!

onResourceCreated
	"Received after the resource has been added to its parent resource. Opportunity to perform initialization that depends on knowledge of the resource tree structure"!

parent
	^parent!

parent: aResource
	parent := aResource!

printUrlOn: aWriteStream 
	self parent printUrlOn: aWriteStream.
	aWriteStream nextPutAll: self uriPattern!

root
	^self parent isNil
		ifTrue: [self]
		ifFalse: [self parent root]!

start!

stop!

unauthorizedResponse
	"Resource should call this method and return its result immediately, if request is not authorized 
	to access that resource and a HTTP authorization is needed"
"	^HTTPAuthenticationChallenge newForResource: self " !

unauthorizedResponsePage
	"Resource should override this method with it's own html message"
	^'<HTML>
  <HEAD>
    <TITLE>Authentication error</TITLE>
  </HEAD>
  <BODY>
    <H1>401 Authentication error</H1>
    <P>Bad username or password</P>
  </BODY>
</HTML>'!

uriPattern
	^uriPattern!

uriPattern: anIdentifier 
	anIdentifier notNil ifTrue: [uriPattern := anIdentifier]! !
!SwazooResource categoriesFor: #answerTo:!public!serving! !
!SwazooResource categoriesFor: #authenticationRealm!authentication!public! !
!SwazooResource categoriesFor: #authenticationScheme!authentication!public! !
!SwazooResource categoriesFor: #canAnswer!public!testing! !
!SwazooResource categoriesFor: #currentUrl!accessing!public! !
!SwazooResource categoriesFor: #disable!public!start/stop! !
!SwazooResource categoriesFor: #enable!public!start/stop! !
!SwazooResource categoriesFor: #helpResolve:!accessing!public! !
!SwazooResource categoriesFor: #initialize!private-initialize!public! !
!SwazooResource categoriesFor: #initUriPattern!private-initialize!public! !
!SwazooResource categoriesFor: #isEnabled!public!testing! !
!SwazooResource categoriesFor: #isValidlyConfigured!public!testing! !
!SwazooResource categoriesFor: #match:!private! !
!SwazooResource categoriesFor: #onResourceCreated!private-initialize!public! !
!SwazooResource categoriesFor: #parent!accessing!public! !
!SwazooResource categoriesFor: #parent:!private! !
!SwazooResource categoriesFor: #printUrlOn:!accessing!public! !
!SwazooResource categoriesFor: #root!accessing!public! !
!SwazooResource categoriesFor: #start!public!start/stop! !
!SwazooResource categoriesFor: #stop!public!start/stop! !
!SwazooResource categoriesFor: #unauthorizedResponse!authentication!public! !
!SwazooResource categoriesFor: #unauthorizedResponsePage!authentication!public! !
!SwazooResource categoriesFor: #uriPattern!accessing!public! !
!SwazooResource categoriesFor: #uriPattern:!accessing!public! !

!SwazooResource class methodsFor!

new
	^super new initialize!

uriPattern: aString 
	^self new uriPattern: aString! !
!SwazooResource class categoriesFor: #new!instance creation!public! !
!SwazooResource class categoriesFor: #uriPattern:!instance creation!public! !

SwazooServer guid: (GUID fromString: '{F4E27E4B-5C38-4390-B694-8755DACCECF8}')!
SwazooServer comment: '
SwazooServer is where all begins in Swazoo!!!!
SwazooServer singleton : return one and only one server which holds the Sites. Also used to start and stop all sites ato once, to add new sited etc. When running, a collection of HTTPServers is also stored in SwazooServer singleton.

SwazooServer demoStart  will create and run a demo site on http://localhost:8888 which 
                              returns a web page with ''Hello World!!!!'''!
!SwazooServer categoriesForClass!Unclassified! !
!SwazooServer methodsFor!

addServer: aHTTPServer
	^self servers add: aHTTPServer!

addSite: aSite
	(self siteNamed: aSite name) notNil 
		ifTrue: [^SwazooSiteError error: 'Site with that name already exist!!'].
	(self siteHostnamed: aSite host) notNil 
		ifTrue: [^SwazooSiteError error: 'Site host name must be unique!!'].
	(self hasSiteHostnamed: aSite host ip: aSite ip port: aSite port) 
		ifTrue: [^SwazooSiteError error: 'Site with that host:ip:port combination already exist!!'].
	(self allowedHostIPPortFor: aSite) 
		ifFalse: [^SwazooSiteError error: 'Site with such host:ip:port combination not allowed!!'].
	self sites add: aSite!

allowedHostIPPortFor: aSite
	"is host:ip:port combination of aSite allowed regarding to existing sites?"
	"rules:
		1. host name must be unique, except if it is * (anyHost)  
		2. only one site per port can run on any host and all IP interfaces (ip = * or 0.0.0.0)
		3. if there is a site runing on all IPs, then no one can run on specific ip, per port
		4. 3 vice versa
		5. there is no site with the same host ip port combination
	"
	(self siteHostnamed: aSite host) notNil ifTrue: [^false]. 
	(aSite onAllInterfaces and: [self hasSiteOnPort: aSite port]) ifTrue: [^false].
	(aSite onAllInterfaces not and: [self hasSiteOnAllInterfacesOnPort: aSite port]) 
		ifTrue: [^false]. 
	(self hasSiteHostnamed: aSite host ip: aSite ip port: aSite port) ifTrue: [^false].
	^true!

allSites
	^self sites copy!

hasSiteHostnamed: aHostname ip: ipString port: aNumber
	^self sites contains: [:each | 
		each host = aHostname and: [each ip = ipString and: [each port = aNumber ] ] ]!

hasSiteOnAllInterfacesOnPort: aNumber
	"only one site per port is allowed when listening to all interfaces"
	^self sites contains: [:each | each onAllInterfaces and: [each port = aNumber] ]!

hasSiteOnPort: aNumber
	^self sites contains: [:each | each port = aNumber ]!

initialize
	self initSites.
	self initServers.!

initServers
	servers := Set new.!

initSites
	sites := OrderedCollection new.!

isServing
	"any site running currently?"
	^self servers notEmpty!

newServerFor: aSiteIdentifier
	^ aSiteIdentifier newServer.!

prepareDemoSite
	"on http://localhost:8888 to return 'Hello Word' "
	| site |
	site := SwazooSite newNamed: 'swazoodemo'. "which is now also added to SwazoServer"
	site host: '*' ip: '*' port: 8888.
	site addResource: (HelloWorldResource uriPattern: '/').
	^site!

prepareDemoSiteOnPort: aNumber
	"this site will run on all IP interfaces on that port, returning 'Hello World' "
	| name site |
	name := 'port', aNumber printString.
	site := SwazooSite newNamed: name. "which is now also added to SwazoServer"
	site host: '*' ip: '*' port: aNumber.
	site addResource: (HelloWorldResource uriPattern: '/').
	^site!

removeAllSites
	self sites copy do: [:each | self removeSite: each]!

removeServer: aHTTPServer
	 ^self servers remove: aHTTPServer!

removeSite: aSite 
	aSite stop.
	self sites remove: aSite!

restart
	self stop; start.!

restartServers
	"do that after image restart, because TCP sockets are probably not valid anymore"
	self servers do: [:each | each restart].!

serverFor: aSiteIdentifier
	| httpServer |
	aSiteIdentifier isEmpty ifTrue: [^nil]. "in case of new one  initializing"
	^self servers 
		detect: [:each | (each ip = aSiteIdentifier ip) & (each port = aSiteIdentifier port)]
		ifNone: [
			httpServer := self newServerFor: aSiteIdentifier.
			self addServer: httpServer.
			httpServer start.
			^httpServer]!

servers
	servers isNil ifTrue: [self initServers].
	^servers!

siteAnyHostAllInterfacesOnPort: aNumber
	"for host: * ip: * sites"
	^self sites 
		detect: [:each | each onAnyHost and: [each onAllInterfaces and: [each port = aNumber]]]
		ifNone: [nil]!

siteHostnamed: aString
	"find a site with that host name"
	| string |
	aString = '*' ifTrue: [^nil]. "what else should we return?"
	string := aString isNil ifTrue: [''] ifFalse: [aString asLowercase].
	^self sites detect: [:each | 
		each host notNil and: [each host asLowercase = string]] ifNone: [nil].!

siteNamed: aString
	"find a site with that short name"
	| string |
	string := aString isNil ifTrue: [''] ifFalse: [aString asLowercase].
	^self sites detect: [:each | each name asLowercase = string] ifNone: [nil].!

sites
	sites isNil ifTrue: [self initSites].
	^sites!

start
	self sites do: [:site | site start].
	self startWatchdog.!

startOn: aPortNumber
	"start a site on that port, on all ip interfaces and accepting all hosts.
	It also created a site if there is any site on that port yet"
	"opening http://localhost:portNumber will return a simple 'Hello world' "
	| site |
	site := self siteAnyHostAllInterfacesOnPort: aPortNumber.
	site isNil ifTrue: [site := self prepareDemoSiteOnPort: aPortNumber].
	site start.
	^site!

startSite: aString
	"start site with that name"
	| site |
	site := self siteNamed: aString.
	^site notNil 
		ifTrue: [site start. self isWatchdogRunning ifFalse: [self startWatchdog]. site] 
		ifFalse: [nil]!

startWatchdog
	"SwazooServer singleton startWatchdog"
	self isWatchdogRunning ifTrue: [self stopWatchdog].
	self watchdog: ([ [true] whileTrue:
		[(self respondsTo: #watchdogSites) ifTrue: [self watchdogSites].
		(self respondsTo: #watchdogOther) ifTrue: [self watchdogOther]. "if any"
		(Delay forSeconds: self watchdogPeriod) wait. ]
	] forkAt: Processor lowIOPriority)!

stop
	self sites do: [:site | site stop].
	self servers do: [:server | server stop].
	self initServers.
	self stopWatchdog.!

stopOn: aPortNumber
	"stop a site on that port, if any running on all ip interfaces and accepting all hosts"
	| site |
	site := self siteAnyHostAllInterfacesOnPort: aPortNumber.
	^site notNil ifTrue: [site stop. site] ifFalse: [nil].!

stopSite: aString
	"stop site with that name"
	| site |
	site := self siteNamed: aString.
	^site notNil ifTrue: [site stop. site] ifFalse: [nil].!

stopWatchdog
	self watchdog notNil ifTrue: 
		[self watchdog terminate.
		self watchdog: nil].!

watchdog
	^watchdog!

watchdog: aProcess
	watchdog := aProcess!

watchdogPeriod
	^10  "seconds"! !
!SwazooServer categoriesFor: #addServer:!private-servers!public! !
!SwazooServer categoriesFor: #addSite:!adding/removing!public! !
!SwazooServer categoriesFor: #allowedHostIPPortFor:!private! !
!SwazooServer categoriesFor: #allSites!accessing!public! !
!SwazooServer categoriesFor: #hasSiteHostnamed:ip:port:!private! !
!SwazooServer categoriesFor: #hasSiteOnAllInterfacesOnPort:!private! !
!SwazooServer categoriesFor: #hasSiteOnPort:!private! !
!SwazooServer categoriesFor: #initialize!initialize-release!public! !
!SwazooServer categoriesFor: #initServers!initialize-release!public! !
!SwazooServer categoriesFor: #initSites!initialize-release!public! !
!SwazooServer categoriesFor: #isServing!public!testing! !
!SwazooServer categoriesFor: #newServerFor:!private-servers!public! !
!SwazooServer categoriesFor: #prepareDemoSite!private! !
!SwazooServer categoriesFor: #prepareDemoSiteOnPort:!private! !
!SwazooServer categoriesFor: #removeAllSites!private! !
!SwazooServer categoriesFor: #removeServer:!private-servers!public! !
!SwazooServer categoriesFor: #removeSite:!adding/removing!public! !
!SwazooServer categoriesFor: #restart!public!start/stop! !
!SwazooServer categoriesFor: #restartServers!private-servers!public! !
!SwazooServer categoriesFor: #serverFor:!private-servers!public! !
!SwazooServer categoriesFor: #servers!private! !
!SwazooServer categoriesFor: #siteAnyHostAllInterfacesOnPort:!private! !
!SwazooServer categoriesFor: #siteHostnamed:!accessing!public! !
!SwazooServer categoriesFor: #siteNamed:!accessing!public! !
!SwazooServer categoriesFor: #sites!private! !
!SwazooServer categoriesFor: #start!public!start/stop! !
!SwazooServer categoriesFor: #startOn:!public!start/stop! !
!SwazooServer categoriesFor: #startSite:!public!start/stop! !
!SwazooServer categoriesFor: #startWatchdog!private-watchdog!public! !
!SwazooServer categoriesFor: #stop!public!start/stop! !
!SwazooServer categoriesFor: #stopOn:!public!start/stop! !
!SwazooServer categoriesFor: #stopSite:!public!start/stop! !
!SwazooServer categoriesFor: #stopWatchdog!private-watchdog!public! !
!SwazooServer categoriesFor: #watchdog!private-watchdog!public! !
!SwazooServer categoriesFor: #watchdog:!private-watchdog!public! !
!SwazooServer categoriesFor: #watchdogPeriod!private-watchdog!public! !

!SwazooServer class methodsFor!

configureFrom: aFilenameString 
	| sites stream |
	self singleton removeAllSites.
	stream := aFilenameString asFilename readStream.
	[sites := self readSitesFrom: stream] ensure: [stream close].
	sites do: [:each | 
		self singleton addSite: each.
		each start]!

demoStart
	"on http://localhost:8888/ will return simple 'Hello World'"
	| site |
	site := self singleton siteNamed: 'swazoodemo'.
	site isNil ifTrue: [site := self singleton prepareDemoSite].
	site start!

demoStop
	self stopSite: 'swazoodemo'!

exampleConfigurationFile
	"example sites.cnf, which will serve static files from current directory and respond with
	'Hello Worlrd' from url http://localhost:8888/foo/Howdy"

"<Site>
 	<SiteIdentifier ip: '127.0.0.1' port: 8888 host: 'localhost' >
 	<CompositeResource uriPattern: '/'>
  		<CompositeResource uriPattern: 'foo'>
   			<HelloWorldResource uriPattern: 'Howdy'>
  		</CompositeResource>
 	</CompositeResource>
 	<FileResource uriPattern: '/' filePath: '.'>
</Site>
"!

initialize
	"self initialize"
	SpEnvironment addImageStartupTask: [self singleton restartServers] for: self singleton.!

initSingleton
	Singleton := super new!

new
	^self shouldNotImplement!

readSitesFrom: aStream 
	| sites instance |
	sites := OrderedCollection new.
	[instance := SwazooSite new readFrom: aStream.
	instance notNil] whileTrue: [sites add: instance].
	^sites!

restart
	self stop; start!

singleton
	Singleton isNil ifTrue: [self initSingleton].
	^Singleton!

siteHostnamed: aString
	^self singleton siteHostnamed: aString!

siteNamed: aString
	^self singleton siteNamed: aString!

start
	"start all sites"
	self singleton start!

startOn: aPortNumber
	"start a site on that port, on all ip interfaces and accepting all hosts.
	It also created a site if there is any site on that port yet"
	^self singleton startOn: aPortNumber!

startSite: aString
	"start site with that name"
	self singleton startSite: aString!

stop
	"stop all sites"
	self singleton stop!

stopOn: aPortNumber
	"stop a site on that port, if any runingon all ip interfaces and accepting all hosts."
	^self singleton stopOn: aPortNumber!

stopSite: aString
	"stop site with that name"
	self singleton stopSite: aString!

swazooVersion
	^'Swazoo 2.2 Smalltalk Web Server'! !
!SwazooServer class categoriesFor: #configureFrom:!config-from-file!public! !
!SwazooServer class categoriesFor: #demoStart!public!start/stop! !
!SwazooServer class categoriesFor: #demoStop!public!start/stop! !
!SwazooServer class categoriesFor: #exampleConfigurationFile!config-from-file!public! !
!SwazooServer class categoriesFor: #initialize!initialize!public! !
!SwazooServer class categoriesFor: #initSingleton!private! !
!SwazooServer class categoriesFor: #new!private! !
!SwazooServer class categoriesFor: #readSitesFrom:!private! !
!SwazooServer class categoriesFor: #restart!public!start/stop! !
!SwazooServer class categoriesFor: #singleton!accessing!public! !
!SwazooServer class categoriesFor: #siteHostnamed:!accessing!public! !
!SwazooServer class categoriesFor: #siteNamed:!accessing!public! !
!SwazooServer class categoriesFor: #start!public!start/stop! !
!SwazooServer class categoriesFor: #startOn:!public!start/stop! !
!SwazooServer class categoriesFor: #startSite:!public!start/stop! !
!SwazooServer class categoriesFor: #stop!public!start/stop! !
!SwazooServer class categoriesFor: #stopOn:!public!start/stop! !
!SwazooServer class categoriesFor: #stopSite:!public!start/stop! !
!SwazooServer class categoriesFor: #swazooVersion!accessing!public! !

SwazooSocket guid: (GUID fromString: '{2B0D33CD-FB29-4CB1-ABC7-2B170C41CC42}')!
SwazooSocket comment: ''!
!SwazooSocket categoriesForClass!Unclassified! !
!SwazooSocket methodsFor!

accept
	^self class accessor: self accessor acceptRetryingIfTransientErrors!

accessor
	^accessor!

accessor: aSocketAccessor 
	accessor := aSocketAccessor.!

close
	self accessor close!

isActive
	^self accessor isActive!

listenFor: anInteger 
	self accessor listenBackloggingUpTo: anInteger!

localAddress
	^self accessor getSocketName hostAddressString!

read: anInteger 
	^self accessor read: anInteger.!

read: anInteger timeout: aNumberOfMilliseconds 
	^(self accessor waitForReadDataUpToMs: aNumberOfMilliseconds) 
		ifTrue: [self read: anInteger]
		ifFalse: [ByteArray new]!

readInto: aByteArray startingAt: start for: length
	^self accessor readInto: aByteArray startingAt: start for: length!

remoteAddress
	^self accessor getPeerName hostAddressString!

stream
	^SwazooStream socket: self!

write: aByteArray 
	^self accessor write: aByteArray!

writeFrom: aByteArray startingAt: start for: length
	^self accessor writeFrom: aByteArray startingAt: start for: length! !
!SwazooSocket categoriesFor: #accept!public!server accessing! !
!SwazooSocket categoriesFor: #accessor!private! !
!SwazooSocket categoriesFor: #accessor:!private! !
!SwazooSocket categoriesFor: #close!accessing!public! !
!SwazooSocket categoriesFor: #isActive!public!testing! !
!SwazooSocket categoriesFor: #listenFor:!public!server accessing! !
!SwazooSocket categoriesFor: #localAddress!accessing!public! !
!SwazooSocket categoriesFor: #read:!accessing!public! !
!SwazooSocket categoriesFor: #read:timeout:!accessing!public! !
!SwazooSocket categoriesFor: #readInto:startingAt:for:!accessing!public! !
!SwazooSocket categoriesFor: #remoteAddress!accessing!public! !
!SwazooSocket categoriesFor: #stream!private! !
!SwazooSocket categoriesFor: #write:!accessing!public! !
!SwazooSocket categoriesFor: #writeFrom:startingAt:for:!accessing!public! !

!SwazooSocket class methodsFor!

accessor: aSocketAccessor 
	^self new accessor: aSocketAccessor!

connectedPair
	^SpSocket newSocketPair collect: [:each | self accessor: each]!

connectTo: aHostString port: anInteger 
	| newSocket |
	newSocket := SpSocket newTCPSocket.
	newSocket 
		connectTo: (SpIPAddress hostName: aHostString port: anInteger).
	^self accessor: newSocket!

serverOnIP: anIPString port: anInteger 
	| newSocket |
	newSocket := SpSocket newTCPServerSocket.
	newSocket
		setAddressReuse: true;
		bindSocketAddress: (SpIPAddress hostName: anIPString port: anInteger).
	^self accessor: newSocket! !
!SwazooSocket class categoriesFor: #accessor:!private! !
!SwazooSocket class categoriesFor: #connectedPair!instance creation!public! !
!SwazooSocket class categoriesFor: #connectTo:port:!instance creation!public! !
!SwazooSocket class categoriesFor: #serverOnIP:port:!instance creation!public! !

SwazooStream guid: (GUID fromString: '{D137F686-9087-473F-BD0E-2D298D30F293}')!
SwazooStream comment: ''!
!SwazooStream categoriesForClass!Unclassified! !
!SwazooStream methodsFor!

anyDataReady
	"wait for data and return true if any data ready. On VW somethimes happen that data 
      receipt is signaled but no data is actually received"
	self readBuffer atEnd ifFalse: [^true]. "data is there from before"
	self fillBuffer.
	^self readBuffer atEnd not!

atEnd
	"TCP socket data never ends!!"
	^false!

close
	"close TCP socket and relase buffers"
	self socket close.
	self nilWriteBuffer.
	self nilReadBuffer.  "to GC buffers"!

closeResponse
	"for chunked response: close it by sending null chunk"
	"do a bit cleanup after response is sent"
	self flush.
	self isChunked ifTrue: 
		[self writeBuffer closeChunkTo: self socket.
		self resetChunked].
	self socket notNil "not simulation" ifTrue: [self nilWriteBuffer]. "to release memory"!

cr
	self nextPut: Character cr asInteger!

crlf
	self cr; lf.!

fillBuffer
	self socket isNil ifTrue: [^self]. "if SwazooStream is used for tests only"
	self readBuffer refillFrom: self socket.!

flush
	"actually write to the tcp socket and clear write buffer"
	self socket isNil ifTrue: [^nil]. "for simulations and tests"
	self isChunked
		ifTrue: [self writeBuffer flushChunkTo: self socket]
		ifFalse: [	self writeBuffer flushTo: self socket].!

initReadBuffer
	"temporary read buffer"
	readBuffer := SwazooBuffer newRead!

initWriteBuffer
	"temporary write buffer. flush it to socket ocassionaly!!"
	writeBuffer := SwazooBuffer newWrite!

isChunked
	"sending in chunks (transfer encoding: chunked)"
	^chunked notNil and: [chunked]!

lf
	self nextPut: Character lf asInteger!

next
	^self nextByte asCharacter!

next: anInteger 
	^(self nextBytes: anInteger) asString!

next: size putAll: aSequenceableCollection startingAt: start
	"Dolphin Smalltalk compatibility."

	^writeBuffer
		next: size
		putAll: aSequenceableCollection
		startingAt: start!

nextByte
	self syncBuffer.
	^self readBuffer next.
!

nextBytes: aNumber 
	| array |
	array := ByteArray new: aNumber.
	1 to: aNumber do: [:index |  array at: index put: self nextByte].
	^array!

nextLine
	| stream |
	stream := WriteStream on: (String new: 50).
	self writeNextLineTo: stream.
	^stream contents!

nextPut: aCharacterOrInteger
	self nextPutByte: aCharacterOrInteger asInteger.
	^aCharacterOrInteger!

nextPutAll: aByteStringOrArray
	self nextPutBytes: aByteStringOrArray asByteArray.
	^aByteStringOrArray!

nextPutByte: aByte 
	self writeBuffer nextPut: aByte.
	self writeBuffer isFull ifTrue: [self flush].
	^aByte!

nextPutBytes: aByteArray 
	self writeBuffer nextPutAll: aByteArray.
	self writeBuffer isFull ifTrue: [self flush]. 
	^aByteArray!

nextPutLine: aByteStringOrArray 
	self nextPutAll: aByteStringOrArray.
	self crlf.!

nextUnfoldedLine
	| stream ch |
	stream := WriteStream on: (String new: 50).
	self writeNextLineTo: stream.
	stream contents isEmpty ifFalse: [
		[ch := self peek.
		ch notNil and: [ch == Character space or: [ch == Character tab]]] 
			whileTrue: [self writeNextLineTo: stream]
		].
	^stream contents!

nilReadBuffer
	"to release memory"
	readBuffer := nil!

nilWriteBuffer
	"to release memory"
	writeBuffer := nil!

peek
	| byte |
	byte := self peekByte.
	^byte notNil 
		ifTrue: [byte asCharacter] 
		ifFalse: [nil]!

peekByte
	self syncBuffer.
	^self readBuffer peek!

print: anObject 
	anObject printOn: self!

readBuffer
	readBuffer isNil ifTrue: [self initReadBuffer].
	^readBuffer!

readBuffer: aSwazooBuffer
	readBuffer := aSwazooBuffer!

resetChunked
	"sending in chunks (transfer encoding: chunked)"
	chunked := false!

setChunked
	"sending in chunks (transfer encoding: chunked)"
	chunked := true!

setSocket: aSwazooSocket 
	self socket: aSwazooSocket.!

skip: anInteger
	anInteger timesRepeat: [self nextByte].!

socket
	^socket!

socket: aSocket
	socket := aSocket!

space
	self nextPut: Character space!

syncBuffer
	self readBuffer atEnd ifTrue: [self fillBuffer]!

upTo: aCharacterOrByte
	| targetByte ws byte |
	targetByte := aCharacterOrByte asInteger.
	ws := ByteArray new writeStream.
	[byte := self nextByte.
	byte = targetByte] whileFalse: [ws nextPut: byte].
	^ws contents!

writeBuffer
	writeBuffer isNil ifTrue: [self initWriteBuffer].
	^writeBuffer!

writeNextLineTo: aStream 
	aStream nextPutAll: (self upTo: Character cr asInteger) asString.
	^self peekByte = Character lf asInteger 
		ifTrue: [self nextByte]  "skip remaining linefeed"
		ifFalse: [SwazooHTTPParseError raiseSignal: 'CR without LF']! !
!SwazooStream categoriesFor: #anyDataReady!accessing-reading!public! !
!SwazooStream categoriesFor: #atEnd!accessing-reading!public! !
!SwazooStream categoriesFor: #close!initialize-release!public! !
!SwazooStream categoriesFor: #closeResponse!initialize-release!public! !
!SwazooStream categoriesFor: #cr!accessing-writing!public! !
!SwazooStream categoriesFor: #crlf!accessing-writing!public! !
!SwazooStream categoriesFor: #fillBuffer!private! !
!SwazooStream categoriesFor: #flush!initialize-release!public! !
!SwazooStream categoriesFor: #initReadBuffer!initialize-release!public! !
!SwazooStream categoriesFor: #initWriteBuffer!initialize-release!public! !
!SwazooStream categoriesFor: #isChunked!chunking!public! !
!SwazooStream categoriesFor: #lf!accessing-writing!public! !
!SwazooStream categoriesFor: #next!accessing-reading!public! !
!SwazooStream categoriesFor: #next:!accessing-reading!public! !
!SwazooStream categoriesFor: #next:putAll:startingAt:!public! !
!SwazooStream categoriesFor: #nextByte!private-stream!public! !
!SwazooStream categoriesFor: #nextBytes:!private-stream!public! !
!SwazooStream categoriesFor: #nextLine!accessing-reading!public! !
!SwazooStream categoriesFor: #nextPut:!accessing-writing!public! !
!SwazooStream categoriesFor: #nextPutAll:!accessing-writing!public! !
!SwazooStream categoriesFor: #nextPutByte:!private-stream!public! !
!SwazooStream categoriesFor: #nextPutBytes:!private-stream!public! !
!SwazooStream categoriesFor: #nextPutLine:!accessing-writing!public! !
!SwazooStream categoriesFor: #nextUnfoldedLine!accessing-reading!public! !
!SwazooStream categoriesFor: #nilReadBuffer!initialize-release!public! !
!SwazooStream categoriesFor: #nilWriteBuffer!initialize-release!public! !
!SwazooStream categoriesFor: #peek!accessing-reading!public! !
!SwazooStream categoriesFor: #peekByte!private-stream!public! !
!SwazooStream categoriesFor: #print:!private! !
!SwazooStream categoriesFor: #readBuffer!private! !
!SwazooStream categoriesFor: #readBuffer:!private! !
!SwazooStream categoriesFor: #resetChunked!chunking!public! !
!SwazooStream categoriesFor: #setChunked!chunking!public! !
!SwazooStream categoriesFor: #setSocket:!private! !
!SwazooStream categoriesFor: #skip:!accessing-reading!public! !
!SwazooStream categoriesFor: #socket!private! !
!SwazooStream categoriesFor: #socket:!private! !
!SwazooStream categoriesFor: #space!accessing-writing!public! !
!SwazooStream categoriesFor: #syncBuffer!private! !
!SwazooStream categoriesFor: #upTo:!accessing-reading!public! !
!SwazooStream categoriesFor: #writeBuffer!private! !
!SwazooStream categoriesFor: #writeNextLineTo:!accessing-reading!public! !

!SwazooStream class methodsFor!

connectedPair
	^SwazooSocket connectedPair collect: [:each | self socket: each]!

on: aString 
	"use only for testing!!"
	^self new readBuffer: (SwazooBuffer on: aString)!

socket: aSwazooSocket 
	^self new setSocket: aSwazooSocket! !
!SwazooStream class categoriesFor: #connectedPair!instance creation!public! !
!SwazooStream class categoriesFor: #on:!instance creation!public! !
!SwazooStream class categoriesFor: #socket:!instance creation!public! !

SwazooTask guid: (GUID fromString: '{D576EBA6-63D3-46D6-9F7F-18EB78D9E78F}')!
SwazooTask comment: 'A SwazooTask is simply a request-response pair.  This class just makes the task (ha!!!!) of dealing with requests and responses a bit easier.'!
!SwazooTask categoriesForClass!Unclassified! !
!SwazooTask methodsFor!

connection
	^connection!

connection: aHTTPConnection
	connection := aHTTPConnection!

request
	^request!

request: aHTTPRequest
	request := aHTTPRequest.
	aHTTPRequest task: self.!

response
	^response!

response: aHTTPResponse
	response := aHTTPResponse.
	aHTTPResponse notNil ifTrue: [aHTTPResponse task: self].! !
!SwazooTask categoriesFor: #connection!accessing!public! !
!SwazooTask categoriesFor: #connection:!accessing!public! !
!SwazooTask categoriesFor: #request!accessing!public! !
!SwazooTask categoriesFor: #request:!accessing!public! !
!SwazooTask categoriesFor: #response!accessing!public! !
!SwazooTask categoriesFor: #response:!accessing!public! !

!SwazooTask class methodsFor!

newOn: aHTTPConnection
	^super new connection: aHTTPConnection! !
!SwazooTask class categoriesFor: #newOn:!instance creation!public! !

SwazooURI guid: (GUID fromString: '{34F371FB-7696-4CD3-BBCB-2F50AFD8BA61}')!
SwazooURI comment: ''!
!SwazooURI categoriesForClass!Unclassified! !
!SwazooURI methodsFor!

asString
	| targetStream |
	targetStream := WriteStream on: String new.
	self printOn: targetStream.
	^targetStream contents!

defaultPort
	^80!

fromStream: sourceStream 
	self readProtocolFrom: sourceStream.
	self readHostFrom: sourceStream.
	self readPortFrom: sourceStream.
	self readIdentifierFrom: sourceStream.
	self readQueryFrom: sourceStream.
	^self!

fromString: aString 
	| sourceStream |
	sourceStream := ReadStream on: (HTTPString decodedHTTPFrom: aString).
	self fromStream: sourceStream.
	^self!

host
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: self hostname.
	self port = self defaultPort 
		ifFalse: 
			[ws nextPut: $:.
			self port printOn: ws].
	^ws contents!

host: aString 
	| rs |
	rs := ReadStream on: aString.
	self hostname: (rs upTo: $: ).
	rs atEnd ifFalse: [self port: rs upToEnd asNumber]!

hostname
	^hostname!

hostname: aHostname 
	hostname := aHostname!

identifier
	^identifier!

identifier: anObject
	identifier := anObject!

identifierPath
	| parts |
	parts := (HTTPString subCollectionsFrom: self identifier delimitedBy: $/) 
				collect: [:each | HTTPString decodedHTTPFrom: each].
	self identifier first = $/ ifTrue: [parts addFirst: '/'].
	^parts reject: [:each | each isEmpty]!

identifierPathString
	"^aString
I return the 'directory' part of the path name."

	| sourceStream targetStream |
	targetStream := WriteStream on: String new.
	sourceStream := ReadStream on: self identifier.
	[sourceStream atEnd] whileFalse: 
			[| fragment |
			fragment := sourceStream throughAll: '/'.
			fragment last = $/ ifTrue: [targetStream nextPutAll: fragment]].
	^targetStream contents!

includesQuery: aString 
	| result |
	result := self queries detect: [:aQuery | aQuery key = aString]
				ifNone: [nil].
	^result notNil!

isDirectory
	^self identifier last = $/!

port
	"^an Integer
The port number defaults to 80 for HTTP."

	^port isNil ifTrue: [80] ifFalse: [port]!

port: anInteger 
	port := anInteger!

printOn: targetStream 
	(self hostname notNil and: [self protocol notNil]) 
		ifTrue: 
			[targetStream
				nextPutAll: self protocol;
				nextPutAll: '://'].
	self hostname notNil ifTrue: [targetStream nextPutAll: self hostname].
	(self hostname notNil and: [self port notNil and: [self port ~= 80]]) 
		ifTrue: 
			[targetStream
				nextPut: $:;
				nextPutAll: self port printString].
	self identifier notNil ifTrue: [targetStream nextPutAll: self identifier].
	self printQueriesOn: targetStream.
	^self!

printQueriesOn: targetStream 
	| firstQuery |
	self queries isEmpty 
		ifFalse: 
			[firstQuery := self queries at: 1.
			targetStream
				nextPut: $?;
				nextPutAll: firstQuery key;
				nextPut: $=;
				nextPutAll: firstQuery value.
			2 to: self queries size
				do: 
					[:queryIndex | 
					| aQuery |
					aQuery := self queries at: queryIndex.
					targetStream
						nextPut: $&;
						nextPutAll: aQuery key;
						nextPut: $=;
						nextPutAll: aQuery value]].
	^self!

protocol
	protocol isNil ifTrue: [self protocol: 'http'].
	^protocol!

protocol: aString
	protocol := aString.!

queries
	"^an OrderedCollection
This is an ordered colleciton of associations.  It can't be a dictionary, because it is legal to have many entries with the same key value."

	queries isNil ifTrue: [queries := OrderedCollection new].
	^queries!

queries: anOrderedCollection 
	"^self
The queries must be an OrderedCollection of Associations c.f. >>queries"

	queries := anOrderedCollection.
	^self!

queriesNamed: aString 
	^self queries select: [:aQuery | aQuery key = aString]!

queryAt: aString 
	^self queryAt: aString ifAbsent: [nil]!

queryAt: aString ifAbsent: aBlock 
	"^aString
I return the value of the first query I find with the key aString.  If there are none I execute aBlock."
	| result |

	result := self queries detect: [:aQuery | aQuery key = aString] ifNone: [aBlock].

	^(result == aBlock) 
	ifTrue: [aBlock value] 
	ifFalse: [result value]!

readHostFrom: aStream 
	"^self
I read the host name from the URI presumed to be in aStream.  The stream should be positioned right at the start, or just after the '//' of the protocol.  The host name is terminated by one of $:, $/, $? or the end of the stream depending on wether there is a port, path, query or nothing following the host.  If the host name is of zero length, I record a nil host name.  The stream is left positioned at the terminating character."

	| hostnameStream |
	hostnameStream := WriteStream on: String new.
	[|nextCharacter| 
	nextCharacter := aStream peek.
	#($: $/ $? nil) includes: nextCharacter]
		whileFalse: [hostnameStream nextPut: aStream next].
	 hostnameStream contents isEmpty ifFalse: [hostname := hostnameStream contents].
	^self!

readIdentifierFrom: sourceStream 

	self identifier: (sourceStream upTo: $?).
	^self!

readPortFrom: aStream 
	"^self
I read the port nnumber from the URI presumed to be in aStream.  If a port number has been specified, the stream should be positioned right at before a $: charcter.  So, if the next chacter is a :, we have a port number.  I read up to one of $/, $? or the end of the stream depending on wether there is a path, query or nothing following the host.  The stream is left positioned at the terminating character."

	| targetStream |
	targetStream := WriteStream on: String new.
	aStream peek == $: 
		ifTrue: 
			[| terminators |
			terminators := Array 
						with: $/
						with: $?
						with: nil.
			aStream next.
			
			[| nextCharacter |
			nextCharacter := aStream peek.
			terminators includes: nextCharacter] 
					whileFalse: 
						[| nextDigit |
						nextDigit := aStream next.
						nextDigit isDigit ifTrue: [targetStream nextPut: nextDigit]].
			targetStream contents isEmpty 
				ifFalse: [port := targetStream contents asNumber]].
	^self!

readProtocolFrom: aStream 
	"^self
I read the protocol from the URI presumed to be in aStream.  The protocol preceeds '://' in the URI.  I leave the stream position either right after the '//' if there is a protocol, otherwise I reset the position to the start of the stream."

	| candidateProtocol |
	candidateProtocol := aStream upTo: $:.
	(aStream size - aStream position >= 2 
		and: [aStream next == $/ and: [aStream next == $/]]) 
			ifTrue: [self protocol: candidateProtocol]
			ifFalse: [aStream reset].
	^self!

readQueryFrom: sourceStream 
	[sourceStream atEnd] whileFalse: 
		[| nameValue name value |
		nameValue := sourceStream upTo: $& .
		name := nameValue copyUpTo: $= .
		value := nameValue readStream upTo: $= "if any"; upToEnd.
		self queries add: name -> (HTTPString decodedHTTPFrom: value)].
	^self!

value
	"1 halt: 'Use >>asString or >>printOn: instead'. "
	^self asString! !
!SwazooURI categoriesFor: #asString!printing!public! !
!SwazooURI categoriesFor: #defaultPort!private! !
!SwazooURI categoriesFor: #fromStream:!initialize-release!public! !
!SwazooURI categoriesFor: #fromString:!initialize-release!public! !
!SwazooURI categoriesFor: #host!accessing!public! !
!SwazooURI categoriesFor: #host:!accessing!public! !
!SwazooURI categoriesFor: #hostname!accessing!public! !
!SwazooURI categoriesFor: #hostname:!accessing!public! !
!SwazooURI categoriesFor: #identifier!accessing!public! !
!SwazooURI categoriesFor: #identifier:!accessing!public! !
!SwazooURI categoriesFor: #identifierPath!accessing!public! !
!SwazooURI categoriesFor: #identifierPathString!accessing!public! !
!SwazooURI categoriesFor: #includesQuery:!accessing-queries!public! !
!SwazooURI categoriesFor: #isDirectory!public!testing! !
!SwazooURI categoriesFor: #port!accessing!public! !
!SwazooURI categoriesFor: #port:!accessing!public! !
!SwazooURI categoriesFor: #printOn:!printing!public! !
!SwazooURI categoriesFor: #printQueriesOn:!printing!public! !
!SwazooURI categoriesFor: #protocol!accessing!public! !
!SwazooURI categoriesFor: #protocol:!accessing!public! !
!SwazooURI categoriesFor: #queries!accessing-queries!public! !
!SwazooURI categoriesFor: #queries:!accessing-queries!public! !
!SwazooURI categoriesFor: #queriesNamed:!accessing-queries!public! !
!SwazooURI categoriesFor: #queryAt:!accessing-queries!public! !
!SwazooURI categoriesFor: #queryAt:ifAbsent:!accessing-queries!public! !
!SwazooURI categoriesFor: #readHostFrom:!private! !
!SwazooURI categoriesFor: #readIdentifierFrom:!private! !
!SwazooURI categoriesFor: #readPortFrom:!private! !
!SwazooURI categoriesFor: #readProtocolFrom:!private! !
!SwazooURI categoriesFor: #readQueryFrom:!private! !
!SwazooURI categoriesFor: #value!accessing!public! !

!SwazooURI class methodsFor!

fromString: aString
	^self new fromString: aString!

value: aString
	^self new value: aString! !
!SwazooURI class categoriesFor: #fromString:!instance creation!public! !
!SwazooURI class categoriesFor: #value:!instance creation!public! !

TestPseudoSocket guid: (GUID fromString: '{6ED4AE73-7303-445C-AD59-62C3A9E55791}')!
TestPseudoSocket comment: '
TestPseudoSocket is a drop in replacement for a SwazooSocket that can be used during testing to feed bytes into a running SwazooHTTPServer and grab the responses without having to start a real socket pair.

So, to the HTTP server it must look like a server socket.  To the tester it must look like a write stream (to send bytes to the HTTP server) and a read stream (to read the HTTP responses).'!
!TestPseudoSocket categoriesForClass!Unclassified! !
!TestPseudoSocket methodsFor!

acceptRetryingIfTransientErrors
	"^another TestSocketThing
	The sender expects me to block until a request comes in 'over the socket'.  What I really do is wait for someone to ask me to 'send in' a Byte array and then I return myself.  Note that I will only handle one request at a time!!"

	self serverWaitSemaphore wait.
	^self!

bindSocketAddress: anOSkIPAddress 
	"^self
This is a no-op for me."

	ipAddress := anOSkIPAddress.
	^self!

byteStreamFromServer
	^byteStreamFromServer!

byteStreamFromServer: aByteStream 
	byteStreamFromServer := aByteStream.
	^self!

byteStreamToServer
	^byteStreamToServer!

byteStreamToServer: aByteStream 
	byteStreamToServer := aByteStream.
	^self!

clientWaitSemaphore
	"^a Semaphore
I return the semaphore I use to control 'client' activity."

	clientWaitSemaphore isNil ifTrue: [clientWaitSemaphore := Semaphore new].
	^clientWaitSemaphore!

close
	"^self
The server has finished with us at this point, so we signal the semaphore to give the client end chance to grab the response."

	self clientWaitSemaphore signal.
	^self!

flush
	^self!

getPeerName
	^ipAddress!

getSocketName
	^ipAddress!

isActive
	"^self
I am pretending to be a socket, and the sender wants to know if I am active.  Of course I am!!."

	^true!

listenBackloggingUpTo: anInteger 
	"^self
This is a no-op for me."

	^self!

listenFor: anInteger 
	"^self
This is a no-op for now."

	^self!

next
	^self byteStreamToServer next!

nextPut: aCharacter 
	self byteStreamFromServer nextPut: aCharacter asInteger!

nextPutAll: aCollection 
	"^self
At present it seems that aCollection will always be a string of chacters."

	^self byteStreamFromServer nextPutAll: aCollection asByteArray!

nextPutBytes: aByteArray 
	self byteStreamFromServer nextPutAll: aByteArray!

peek
	"^a Character
It seems that the HTTP server is expecting Characters not Bytes - this will have to change."

	^byteStreamToServer isNil 
		ifTrue: [nil]
		ifFalse: [self byteStreamToServer peek asCharacter]!

print: anObject 
	self nextPutAll: anObject printString asByteArray.
	^self!

read: integerNumberOfBytes 
	"^a ByteArray
I read the next numberOfBytes from my underlying stream."

	^byteStreamToServer isNil 
		ifTrue: [ByteArray new]
		ifFalse: [self byteStreamToServer nextAvailable: integerNumberOfBytes]!

serverWaitSemaphore
	"^a Semaphore
I return the semaphore I use to control 'server' activity."

	serverWaitSemaphore isNil ifTrue: [serverWaitSemaphore := Semaphore new].
	^serverWaitSemaphore!

setAddressReuse: aBoolean 
	"^self
This is a no-op for me."

	^self!

socket
	"^self
I am being asked this as if I am a socket stream.  I return myself because I'm pretending to be both the socket and the socket stream."

	^self!

space
	self nextPut: Character space.
	^self!

stream
	"^self
I have to pretend to be a socket stream too."

	^self!

upTo: aCharacter 
	"a ByteString
For some reason, we have to look for a character in a ByteStream - this is a Swazoo thing."

	^(self byteStreamToServer upTo: aCharacter asInteger) asByteString!

write: aByteArray 
	"^an Integer
	I write the contents of the sourceByteArray to my underlying Socket.
	I return the number of bytes written."

	self byteStreamFromServer nextPutAll: aByteArray.
	^aByteArray size!

writeBytesToServer: aByteArray 
	"^self
This is where we make the bytes available over the pseudo socket.  Unlike a socket this is a one off thing (at least in this implementation of the pseudo socket).  Once the bytes are written, control passes to the server and stays there until the server sends a close to what it thinks is the client socket, but is really me."

	| results |
	self byteStreamToServer: (ReadStream on: aByteArray).
	self byteStreamFromServer: (WriteStream on: (ByteArray new: 1000)).
	self serverWaitSemaphore signal.
	self clientWaitSemaphore wait.
	results := self byteStreamFromServer contents.
	self byteStreamToServer: nil.
	self byteStreamFromServer: nil.
	^results! !
!TestPseudoSocket categoriesFor: #acceptRetryingIfTransientErrors!public!socket stuff! !
!TestPseudoSocket categoriesFor: #bindSocketAddress:!public!socket stuff! !
!TestPseudoSocket categoriesFor: #byteStreamFromServer!accessing!public! !
!TestPseudoSocket categoriesFor: #byteStreamFromServer:!accessing!public! !
!TestPseudoSocket categoriesFor: #byteStreamToServer!accessing!public! !
!TestPseudoSocket categoriesFor: #byteStreamToServer:!accessing!public! !
!TestPseudoSocket categoriesFor: #clientWaitSemaphore!accessing!public! !
!TestPseudoSocket categoriesFor: #close!public!socket stuff! !
!TestPseudoSocket categoriesFor: #flush!public!socket stuff! !
!TestPseudoSocket categoriesFor: #getPeerName!public!socket stuff! !
!TestPseudoSocket categoriesFor: #getSocketName!public!socket stuff! !
!TestPseudoSocket categoriesFor: #isActive!public!socket stuff! !
!TestPseudoSocket categoriesFor: #listenBackloggingUpTo:!public!socket stuff! !
!TestPseudoSocket categoriesFor: #listenFor:!public!socket stuff! !
!TestPseudoSocket categoriesFor: #next!public!stream-toServer! !
!TestPseudoSocket categoriesFor: #nextPut:!public!stream-fromServer! !
!TestPseudoSocket categoriesFor: #nextPutAll:!public!stream-fromServer! !
!TestPseudoSocket categoriesFor: #nextPutBytes:!public!stream-fromServer! !
!TestPseudoSocket categoriesFor: #peek!public!stream-toServer! !
!TestPseudoSocket categoriesFor: #print:!public!stream-fromServer! !
!TestPseudoSocket categoriesFor: #read:!public!stream-toServer! !
!TestPseudoSocket categoriesFor: #serverWaitSemaphore!accessing!public! !
!TestPseudoSocket categoriesFor: #setAddressReuse:!public!socket stuff! !
!TestPseudoSocket categoriesFor: #socket!public!stream-toServer! !
!TestPseudoSocket categoriesFor: #space!public!stream-fromServer! !
!TestPseudoSocket categoriesFor: #stream!public!socket stuff! !
!TestPseudoSocket categoriesFor: #upTo:!public!stream-toServer! !
!TestPseudoSocket categoriesFor: #write:!public!stream-fromServer! !
!TestPseudoSocket categoriesFor: #writeBytesToServer:!actions-client!public! !

!TestPseudoSocket class methodsFor!

newTCPSocket
	"^a TestPseudoSocket
I simply return a new instance of myself."

	^self new!

serverOnIP: host port: port 
	"^self
I'm only pretending to be a socket class, so I ignore the host and port."

	^self new! !
!TestPseudoSocket class categoriesFor: #newTCPSocket!instance creation!public! !
!TestPseudoSocket class categoriesFor: #serverOnIP:port:!instance creation!public! !

URIIdentifier guid: (GUID fromString: '{50169B7F-E49D-4DE9-AC8F-82353B1BD81D}')!
URIIdentifier comment: ''!
!URIIdentifier categoriesForClass!Unclassified! !
!URIIdentifier methodsFor!

= anIdentifier 
	^self match: anIdentifier!

hash
	^1!

match: anotherIdentifier 
	^(self typeMatch: anotherIdentifier) 
		and: [self valueMatch: anotherIdentifier]!

typeMatch: anotherIdentifier 
	^self class == anotherIdentifier class!

valueMatch: anotherIdentifier 
	^self subclassResponsibility! !
!URIIdentifier categoriesFor: #=!comparing!public! !
!URIIdentifier categoriesFor: #hash!comparing!public! !
!URIIdentifier categoriesFor: #match:!public!testing! !
!URIIdentifier categoriesFor: #typeMatch:!private! !
!URIIdentifier categoriesFor: #valueMatch:!private! !

URIResolution guid: (GUID fromString: '{227BD4C1-E1B7-44DE-8432-9DD1C8B8ECEA}')!
URIResolution comment: ''!
!URIResolution categoriesForClass!Unclassified! !
!URIResolution methodsFor!

advance
	self position: self position + 1!

atEnd
	^self position = self request uri identifierPath size!

currentIdentifier
	^self currentPath last!

currentPath
	^self request uri identifierPath copyFrom: 1 to: self position!

fullPath
	^self request uri identifierPath!

getAnswerFrom: aResource
	^aResource answerTo: self request!

initializeRequest: aRequest 
	self request: aRequest.
	self request resolution: self.
	self position: 1!

position
	^position!

position: anInteger
	position := anInteger!

request
	^request!

request: aRequest
	request := aRequest!

resolveCompositeResource: aResource 
	(aResource canAnswer and: [aResource match: self currentIdentifier]) 
		ifFalse: [^nil].
	^self visitChildrenOf: aResource advancing: true!

resolveLeafResource: aResource 
	(aResource canAnswer and: [self stringMatch: aResource]) ifFalse: [^nil].
	^self getAnswerFrom: aResource!

resolveServerRoot: aServerRoot 
	^self resolveTransparentComposite: aServerRoot!

resolveSite: aSite 
	(aSite canAnswer and: [self siteMatch: aSite]) ifFalse: [^nil].
	^self visitChildrenOf: aSite advancing: false!

resolveTransparentComposite: aCompositeResource 
	^self visitChildrenOf: aCompositeResource advancing: false!

resourcePath
	^self request uri identifierPath copyFrom: 1 to: self position!

retreat
	self position: self position - 1.
	^nil!

siteMatch: aSite 
	| siteIdentifier hostName |
	hostName := self request headers 
				fieldOfClass: HTTPHostField
				ifPresent: [:field | field hostName]
				ifAbsent: [self request requestLine requestURI hostname].
	siteIdentifier := SiteIdentifier 
				host: (hostName notNil ifTrue: [hostName] ifFalse: [''])
				ip: self request ip
				port: self request port.
	^aSite match: siteIdentifier!

stringMatch: aResource 
	^aResource uriPattern = self currentIdentifier!

tailPath
	| fullPath |
	fullPath := self fullPath.
	^fullPath copyFrom: self position + 1 to: fullPath size!

tailStream
	^ReadStream on: self tailPath!

visitChildrenOf: aResource advancing: aBoolean 
	| response |
	self atEnd & aBoolean ifTrue: [^self getAnswerFrom: aResource].
	aBoolean ifTrue: [self advance].
	aResource children do: 
			[:each | 
			response := self visitResource: each.
			response isNil ifFalse: [^response]].
	^aBoolean ifTrue: [self retreat] ifFalse: [nil]!

visitResource: aResource 
	^aResource helpResolve: self! !
!URIResolution categoriesFor: #advance!private! !
!URIResolution categoriesFor: #atEnd!accessing!public! !
!URIResolution categoriesFor: #currentIdentifier!private! !
!URIResolution categoriesFor: #currentPath!private! !
!URIResolution categoriesFor: #fullPath!accessing!public! !
!URIResolution categoriesFor: #getAnswerFrom:!private! !
!URIResolution categoriesFor: #initializeRequest:!private-initialize!public! !
!URIResolution categoriesFor: #position!accessing!public! !
!URIResolution categoriesFor: #position:!private! !
!URIResolution categoriesFor: #request!accessing!public! !
!URIResolution categoriesFor: #request:!private! !
!URIResolution categoriesFor: #resolveCompositeResource:!public!resolving! !
!URIResolution categoriesFor: #resolveLeafResource:!public!resolving! !
!URIResolution categoriesFor: #resolveServerRoot:!public!resolving! !
!URIResolution categoriesFor: #resolveSite:!public!resolving! !
!URIResolution categoriesFor: #resolveTransparentComposite:!public!resolving! !
!URIResolution categoriesFor: #resourcePath!accessing!public! !
!URIResolution categoriesFor: #retreat!private! !
!URIResolution categoriesFor: #siteMatch:!private! !
!URIResolution categoriesFor: #stringMatch:!private! !
!URIResolution categoriesFor: #tailPath!accessing!public! !
!URIResolution categoriesFor: #tailStream!private! !
!URIResolution categoriesFor: #visitChildrenOf:advancing:!public!resolving! !
!URIResolution categoriesFor: #visitResource:!public!resolving! !

!URIResolution class methodsFor!

resolveRequest: aRequest startingAt: aResource 
	^(self new initializeRequest: aRequest) visitResource: aResource! !
!URIResolution class categoriesFor: #resolveRequest:startingAt:!instance creation!public! !

HTTPException guid: (GUID fromString: '{1F804F70-1FBB-4B13-A4A5-87FF117539DB}')!
HTTPException comment: '
HTTPException immediatelly returns attached HTTP response to client. That way it is easier to respond with different status codes (like 201 Created). Not only error ones!!!! You can respond somewhere deeply in code of your resource with raising that exception and adding a prepared HTTPResponse. 
This exception is non-resumable!!!!

Example of ways to raise http response (200 Ok):

	HTTPException raiseResponse: (HTTPResponse new code: 200).
	HTTPException raiseResponseCode: 200.
	HTTPException ok.

Instance Variables:
	response	<HTTPResponse>	a response to be sent to client

'!
!HTTPException categoriesForClass!Unclassified! !
!HTTPException methodsFor!

response
	^response!

response: aHTTPResponse
	response := aHTTPResponse! !
!HTTPException categoriesFor: #response!accessing!public! !
!HTTPException categoriesFor: #response:!accessing!public! !

!HTTPException class methodsFor!

accepted
	^self raiseResponse: (HTTPResponse new code: 202)!

badGateway
	^self raiseResponse: (HTTPResponse new code: 502)!

badRequest
	^self raiseResponse: (HTTPResponse new code: 400)!

conflict
	^self raiseResponse: (HTTPResponse new code: 409)!

continue
	^self raiseResponse: (HTTPResponse new code: 100)!

created
	^self raiseResponse: (HTTPResponse new code: 201)!

expectationFailed
	^self raiseResponse: (HTTPResponse new code: 416)!

forbidden
	^self raiseResponse: (HTTPResponse new code: 403)!

found
	^self raiseResponse: (HTTPResponse new code: 302)!

gatewayTimeout
	^self raiseResponse: (HTTPResponse new code: 504)!

gone
	^self raiseResponse: (HTTPResponse new code: 410)!

httpVersionNotSupported
	^self raiseResponse: (HTTPResponse new code: 505)!

internalServerError
	^self raiseResponse: (HTTPResponse new code: 500)!

lengthRequired
	^self raiseResponse: (HTTPResponse new code: 411)!

methodNotAllowed
	^self raiseResponse: (HTTPResponse new code: 405)!

movedPermanently
	^self raiseResponse: (HTTPResponse new code: 301)!

multipleChoices
	^self raiseResponse: (HTTPResponse new code: 300)!

noContent
	^self raiseResponse: (HTTPResponse new code: 204)!

nonAuthorativeInformation
	^self raiseResponse: (HTTPResponse new code: 203)!

notAcceptable
	^self raiseResponse: (HTTPResponse new code: 406)!

notFound
	^self raiseResponse: (HTTPResponse new code: 404)!

notImplemented
	^self raiseResponse: (HTTPResponse new code: 501)!

notModified
	^self raiseResponse: (HTTPResponse new code: 304)!

ok
	^self raiseResponse: HTTPResponse ok!

partialContent
	^self raiseResponse: (HTTPResponse new code: 206)!

paymentRequired
	^self raiseResponse: (HTTPResponse new code: 402)!

preconditionFailed
	^self raiseResponse: (HTTPResponse new code: 412)!

proxyAuthenticationRequired
	^self raiseResponse: (HTTPResponse new code: 407)!

raiseResponseCode: aNumber
	"Raise an exception to immediatelly return http response with that code"
	^self raiseResponse: (HTTPResponse new code: aNumber)!

requestedRangeNotSatisfiable
	^self raiseResponse: (HTTPResponse new code: 416)!

requestEntityTooLarge
	^self raiseResponse: (HTTPResponse new code: 413)!

requestTimeout
	^self raiseResponse: (HTTPResponse new code: 408)!

requestURITooLong
	^self raiseResponse: (HTTPResponse new code: 414)!

resetContent
	^self raiseResponse: (HTTPResponse new code: 205)!

seeOther
	^self raiseResponse: (HTTPResponse new code: 303)!

serviceUnavailable
	^self raiseResponse: (HTTPResponse new code: 503)!

switchingProtocols
	^self raiseResponse: (HTTPResponse new code: 101)!

temporaryRedirect
	^self raiseResponse: (HTTPResponse new code: 307)!

unathorized
	^self raiseResponse: (HTTPResponse new code: 401)!

unsupportedMediaType
	^self raiseResponse: (HTTPResponse new code: 415)!

useProxy
	^self raiseResponse: (HTTPResponse new code: 305)! !
!HTTPException class categoriesFor: #accepted!public!responses-succesfull! !
!HTTPException class categoriesFor: #badGateway!public!responses-server error! !
!HTTPException class categoriesFor: #badRequest!public!responses-client error! !
!HTTPException class categoriesFor: #conflict!public!responses-client error! !
!HTTPException class categoriesFor: #continue!public!responses-informational! !
!HTTPException class categoriesFor: #created!public!responses-succesfull! !
!HTTPException class categoriesFor: #expectationFailed!public!responses-client error! !
!HTTPException class categoriesFor: #forbidden!public!responses-client error! !
!HTTPException class categoriesFor: #found!public!responses-redirection! !
!HTTPException class categoriesFor: #gatewayTimeout!public!responses-server error! !
!HTTPException class categoriesFor: #gone!public!responses-client error! !
!HTTPException class categoriesFor: #httpVersionNotSupported!public!responses-server error! !
!HTTPException class categoriesFor: #internalServerError!public!responses-server error! !
!HTTPException class categoriesFor: #lengthRequired!public!responses-client error! !
!HTTPException class categoriesFor: #methodNotAllowed!public!responses-client error! !
!HTTPException class categoriesFor: #movedPermanently!public!responses-redirection! !
!HTTPException class categoriesFor: #multipleChoices!public!responses-redirection! !
!HTTPException class categoriesFor: #noContent!public!responses-succesfull! !
!HTTPException class categoriesFor: #nonAuthorativeInformation!public!responses-succesfull! !
!HTTPException class categoriesFor: #notAcceptable!public!responses-client error! !
!HTTPException class categoriesFor: #notFound!public!responses-client error! !
!HTTPException class categoriesFor: #notImplemented!public!responses-server error! !
!HTTPException class categoriesFor: #notModified!public!responses-redirection! !
!HTTPException class categoriesFor: #ok!public!responses-succesfull! !
!HTTPException class categoriesFor: #partialContent!public!responses-succesfull! !
!HTTPException class categoriesFor: #paymentRequired!public!responses-client error! !
!HTTPException class categoriesFor: #preconditionFailed!public!responses-client error! !
!HTTPException class categoriesFor: #proxyAuthenticationRequired!public!responses-client error! !
!HTTPException class categoriesFor: #raiseResponseCode:!public!signalling! !
!HTTPException class categoriesFor: #requestedRangeNotSatisfiable!public!responses-client error! !
!HTTPException class categoriesFor: #requestEntityTooLarge!public!responses-client error! !
!HTTPException class categoriesFor: #requestTimeout!public!responses-client error! !
!HTTPException class categoriesFor: #requestURITooLong!public!responses-client error! !
!HTTPException class categoriesFor: #resetContent!public!responses-succesfull! !
!HTTPException class categoriesFor: #seeOther!public!responses-redirection! !
!HTTPException class categoriesFor: #serviceUnavailable!public!responses-server error! !
!HTTPException class categoriesFor: #switchingProtocols!public!responses-informational! !
!HTTPException class categoriesFor: #temporaryRedirect!public!responses-redirection! !
!HTTPException class categoriesFor: #unathorized!public!responses-client error! !
!HTTPException class categoriesFor: #unsupportedMediaType!public!responses-client error! !
!HTTPException class categoriesFor: #useProxy!public!responses-redirection! !

SwazooHeaderFieldParseError guid: (GUID fromString: '{51129963-ABC5-4D57-9C1E-BC40429A5483}')!
SwazooHeaderFieldParseError comment: ''!
!SwazooHeaderFieldParseError categoriesForClass!Unclassified! !
SwazooHTTPParseError guid: (GUID fromString: '{45E54D84-156F-423C-94B2-C91561EA3B51}')!
SwazooHTTPParseError comment: ''!
!SwazooHTTPParseError categoriesForClass!Unclassified! !
SwazooHTTPRequestError guid: (GUID fromString: '{3DA6573B-EB92-4878-8BF8-C367E6216F09}')!
SwazooHTTPRequestError comment: ''!
!SwazooHTTPRequestError categoriesForClass!Unclassified! !
SwazooSiteError guid: (GUID fromString: '{F7610042-B58C-456A-9354-C35347900502}')!
SwazooSiteError comment: ''!
!SwazooSiteError categoriesForClass!Unclassified! !
SwazooStreamNoDataError guid: (GUID fromString: '{5D85347C-82BA-4D16-9232-EA5896F57C40}')!
SwazooStreamNoDataError comment: ''!
!SwazooStreamNoDataError categoriesForClass!Unclassified! !
SwazooHTTPPostError guid: (GUID fromString: '{A6AAE61F-C29A-49ED-8DEA-4790D3CD95A9}')!
SwazooHTTPPostError comment: ''!
!SwazooHTTPPostError categoriesForClass!Unclassified! !
SwazooHTTPPutError guid: (GUID fromString: '{C54E2F6B-7C2D-4661-B6DC-B3667E63C836}')!
SwazooHTTPPutError comment: ''!
!SwazooHTTPPutError categoriesForClass!Unclassified! !
GenericHeaderField guid: (GUID fromString: '{8D8744CE-C2C8-4088-991D-5B5056664E73}')!
GenericHeaderField comment: ''!
!GenericHeaderField categoriesForClass!Unclassified! !
!GenericHeaderField methodsFor!

combineWith: aHeaderField 
	"^self
I simply take my values and concatenate the values of aHeaderField."

	value := self value , ', ' , aHeaderField value.
	^self!

fieldName
1 halt: 'use >>name instead'.
	^self name!

forFieldName: fieldNameString andValue: fieldValueString 
	name := fieldNameString.
	value := fieldValueString.
	^self!

name
	^name!

value
	^value!

values
	^(HTTPString subCollectionsFrom: self value delimitedBy: $,) 
		collect: [:each | HTTPString trimBlanksFrom: each]!

valuesAsStringOn: aStream 
	aStream nextPutAll: value.
	^self! !
!GenericHeaderField categoriesFor: #combineWith:!public!services! !
!GenericHeaderField categoriesFor: #fieldName!accessing!public! !
!GenericHeaderField categoriesFor: #forFieldName:andValue:!initialize-release!public! !
!GenericHeaderField categoriesFor: #name!accessing!public! !
!GenericHeaderField categoriesFor: #value!accessing!public! !
!GenericHeaderField categoriesFor: #values!accessing!public! !
!GenericHeaderField categoriesFor: #valuesAsStringOn:!printing!public! !

!GenericHeaderField class methodsFor!

newForFieldName: fieldNameString withValueFrom: fieldValueString 
	^self new forFieldName: fieldNameString andValue: fieldValueString! !
!GenericHeaderField class categoriesFor: #newForFieldName:withValueFrom:!instance creation!public! !

SpecificHeaderField guid: (GUID fromString: '{24EF33D8-5C18-4F94-B171-FD3066102ED2}')!
SpecificHeaderField comment: ''!
!SpecificHeaderField categoriesForClass!Unclassified! !
!SpecificHeaderField methodsFor!

name
	^self class fieldName!

parameterAt: aString ifAbsent: aBlock 
1 halt: 'use the transfer encodings of the field, not this'.
	^self parameters at: aString ifAbsent: aBlock!

parseValueFrom: aString
	^self subclassResponsibility!

readParametersFrom: sourceStream 
	"^a Dictionary
c.f. RFC 2616 3.6 Transfer Codings"

	| parameters |
	parameters := Dictionary new.
	[sourceStream atEnd] whileFalse: 
			[| attribute value |
			attribute := HTTPString trimBlanksFrom: (sourceStream upTo: $=).
			value := HTTPString trimBlanksFrom: (sourceStream upTo: $;).
			parameters at: attribute put: value].
	^parameters!

valueFrom: fieldValueString 
	self parseValueFrom: fieldValueString.
	^self!

values
	^Array with: self value! !
!SpecificHeaderField categoriesFor: #name!accessing!public! !
!SpecificHeaderField categoriesFor: #parameterAt:ifAbsent:!accessing!public! !
!SpecificHeaderField categoriesFor: #parseValueFrom:!private! !
!SpecificHeaderField categoriesFor: #readParametersFrom:!private! !
!SpecificHeaderField categoriesFor: #valueFrom:!initialize-release!public! !
!SpecificHeaderField categoriesFor: #values!accessing!public! !

!SpecificHeaderField class methodsFor!

fieldName
	^self subclassResponsibility!

newForFieldName: fieldNameString withValueFrom: fieldValueString 
	^self newWithValueFrom: fieldValueString!

newWithValueFrom: fieldValueString 
	^self new valueFrom: fieldValueString! !
!SpecificHeaderField class categoriesFor: #fieldName!accessing!public! !
!SpecificHeaderField class categoriesFor: #newForFieldName:withValueFrom:!private! !
!SpecificHeaderField class categoriesFor: #newWithValueFrom:!private! !

ContentDispositionField guid: (GUID fromString: '{20C73C70-1AED-49C9-A5B2-8845073D7619}')!
ContentDispositionField comment: ''!
!ContentDispositionField categoriesForClass!Unclassified! !
!ContentDispositionField methodsFor!

isContentDisposition
	^true!

parameterAt: aString 
	^parameters at: aString ifAbsent: [nil]!

parseValueFrom: aString 
	| sourceStream |
	sourceStream := aString readStream.
	type := HTTPString trimBlanksFrom: (sourceStream upTo: $;).
	parameters := self readParametersFrom: sourceStream.
	^self! !
!ContentDispositionField categoriesFor: #isContentDisposition!public!testing! !
!ContentDispositionField categoriesFor: #parameterAt:!public!services! !
!ContentDispositionField categoriesFor: #parseValueFrom:!private! !

!ContentDispositionField class methodsFor!

fieldName
	^'Content-Disposition'! !
!ContentDispositionField class categoriesFor: #fieldName!accessing!public! !

ContentTypeField guid: (GUID fromString: '{0EFAA04E-0451-4A2C-AE2E-E930527F9DC9}')!
ContentTypeField comment: ''!
!ContentTypeField categoriesForClass!Unclassified! !
!ContentTypeField methodsFor!

defaultMediaType
	"^a String
See RFC 2616 '7.2.1 Type'.  If no media type is specified, application/octet-stream is the default."

	^'application/octet-stream'!

isContentType
	^true!

mediaType
	^mediaType isNil ifTrue: [self defaultMediaType] ifFalse: [mediaType]!

mediaType: aString 
	mediaType := aString.
	^self!

parseValueFrom: aString 
	| sourceStream |
	sourceStream := aString readStream.
	mediaType := (HTTPString trimBlanksFrom: (sourceStream upTo: $;)).
	transferCodings := self readParametersFrom: sourceStream.
	^self!

transferCodings
	transferCodings isNil ifTrue: [transferCodings := String new].
	^transferCodings!

valuesAsStringOn: aStream 
	aStream nextPutAll: self mediaType.
	self transferCodings isEmpty ifFalse: 
		[self transferCodings keysAndValuesDo: 
			[:name :value | 
			aStream
				nextPutAll: ' ';
				nextPutAll: name;
				nextPut: $=;
				nextPutAll: value]].
	^self! !
!ContentTypeField categoriesFor: #defaultMediaType!accessing!public! !
!ContentTypeField categoriesFor: #isContentType!public!testing! !
!ContentTypeField categoriesFor: #mediaType!accessing!public! !
!ContentTypeField categoriesFor: #mediaType:!accessing!public! !
!ContentTypeField categoriesFor: #parseValueFrom:!private! !
!ContentTypeField categoriesFor: #transferCodings!accessing!public! !
!ContentTypeField categoriesFor: #valuesAsStringOn:!printing!public! !

!ContentTypeField class methodsFor!

fieldName
	^'Content-Type'! !
!ContentTypeField class categoriesFor: #fieldName!accessing!public! !

HTTPAcceptField guid: (GUID fromString: '{1A405775-F4CF-49F1-9C25-544D48E9A133}')!
HTTPAcceptField comment: ''!
!HTTPAcceptField categoriesForClass!Unclassified! !
!HTTPAcceptField methodsFor!

combineWith: aHeaderField 
	"^self
I simply take my values and concatenate the values of aHeaderField."

	self mediaTypes addAll: aHeaderField mediaTypes.
	^self!

mediaTypes
	mediaTypes isNil ifTrue: [mediaTypes := OrderedCollection new].
	^mediaTypes!

parseValueFrom: aString 
	mediaTypes := HTTPString subCollectionsFrom: aString delimitedBy: $,.
	^self!

valuesAsStringOn: targetStream 
	self mediaTypes isEmpty 
		ifFalse: 
			[targetStream nextPutAll: self mediaTypes first.
			2 to: self mediaTypes size
				do: 
					[:methodIndex | 
					targetStream
						nextPut: $,;
						nextPutAll: (self mediaTypes at: methodIndex)]].
	^self! !
!HTTPAcceptField categoriesFor: #combineWith:!public!services! !
!HTTPAcceptField categoriesFor: #mediaTypes!accessing!public! !
!HTTPAcceptField categoriesFor: #parseValueFrom:!private! !
!HTTPAcceptField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPAcceptField class methodsFor!

fieldName
	^'Accept'! !
!HTTPAcceptField class categoriesFor: #fieldName!accessing!public! !

HTTPAllowField guid: (GUID fromString: '{8506E016-899A-4AE0-AF2E-5C9EC2EF306D}')!
HTTPAllowField comment: ''!
!HTTPAllowField categoriesForClass!Unclassified! !
!HTTPAllowField methodsFor!

methods
	methods isNil ifTrue: [methods := OrderedCollection new].
	^methods!

valuesAsStringOn: targetStream 
	self methods isEmpty 
		ifFalse: 
			[targetStream nextPutAll: self methods first.
			2 to: self methods size
				do: 
					[:methodIndex | 
					targetStream
						nextPut: $,;
						nextPutAll: (self methods at: methodIndex)]].
	^self! !
!HTTPAllowField categoriesFor: #methods!accessing!public! !
!HTTPAllowField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPAllowField class methodsFor!

fieldName
	^'Allow'! !
!HTTPAllowField class categoriesFor: #fieldName!accessing!public! !

HTTPAuthorizationField guid: (GUID fromString: '{92886B02-E962-4C7D-9915-D31CD058E06F}')!
HTTPAuthorizationField comment: ''!
!HTTPAuthorizationField categoriesForClass!Unclassified! !
!HTTPAuthorizationField methodsFor!

credentials
	^credentials!

parseValueFrom: aString 
	credentials := HTTPString trimBlanksFrom: aString.
	^self!

valuesAsStringOn: aStream 
	aStream nextPutAll: self credentials.
	^self! !
!HTTPAuthorizationField categoriesFor: #credentials!accessing!public! !
!HTTPAuthorizationField categoriesFor: #parseValueFrom:!private! !
!HTTPAuthorizationField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPAuthorizationField class methodsFor!

fieldName
	^'Authorization'!

newForFieldName: fieldNameString withValueFrom: fieldValueString 
	"^an HTTPAuthorizationField
I return an instance of one of my concrete subclasses.  To get to this point, the field name *must* be 'AUTHORIZATION'."

	| sourceStream schemeName |
	sourceStream := ReadStream on: fieldValueString.
	schemeName := sourceStream upTo: Character space.
	^schemeName = 'Basic' 
		ifTrue: [HTTPAuthorizationBasicField newWithValueFrom: sourceStream upToEnd]
		ifFalse: [HTTPAuthorizationDigestField newWithValueFrom: sourceStream upToEnd]! !
!HTTPAuthorizationField class categoriesFor: #fieldName!accessing!public! !
!HTTPAuthorizationField class categoriesFor: #newForFieldName:withValueFrom:!private! !

HTTPCacheControlField guid: (GUID fromString: '{97E8B246-7AFD-4EEC-9024-A2753F5C9A0E}')!
HTTPCacheControlField comment: ''!
!HTTPCacheControlField categoriesForClass!Unclassified! !
!HTTPCacheControlField methodsFor!

directives
	"for easy setting directives in one string"
	^directives!

directives: aString 
	"for easy setting directives in one string"
	"example: 'no-store, no-cache, must-revalidate'"
	directives := aString!

maxAge
	"^an Integer or nil
I return my max age which is either an integer number of seconds for which the entity can be considdered fresh, or nil, in which case other headers such as Expires can be used by a cache to determine the expiration time of the entity."

	^maxAge!

maxAge: anIntegerOrNil 
	"^self
I record the number of seconds for which the resource is 'fresh' and after which will expire and become 'stale' for caching purposes.  Setting this to nil means the max age is unspecified, and this is the default.  This directive takes presidence over any Expires header when a cache or client is handling an HTTP message."

	maxAge := anIntegerOrNil.
	^self!

private
	"^a Boolean or nil
There are three possible values for private.  Explicity true (the entity can only be cached in private caches), explicity false (this is a public entity and can be held in a shared/public cache perhaps even when stale) or nil (the default which means that the entity may be held in a public shared cache, but only until it goes stale)."

	^private!

setNotPublicOrPrivate
	"^self
I am being told that the entity in my message is not explicity public or private.  This is the default and means that public caches may retain copies of the resource, but should not be as relaxed about the rules as with an explicitly public resource. c.f >>setPublic & >>setPrivate."

	private := nil.
	^self!

setPrivate
	"^self
I am being told that the entity in my message is a private one that can only be cached on private caches, i.e. caches that can be drawn upon a single clients.  An example of a private cache is the one *inside* your web browser.   This is probably what you want if the entity contains personal information."

	private := true.
	^self!

setPublic
	"^self
I am being told that the entity in my message is a public one that can be cached on public caches, i.e. caches that can be drawn upon by many clients.  This is probably not what you want if the entity contains personal information!!  c.f. >>setPrivate  Note that expicitly setting cache-control public actually loosens some other rules and means resources can be used by cached beyond their normal life."

	private := false.
	^self!

valuesAsStringOn: aStream 
	aStream nextPut: Character space.
	self directives notNil ifTrue: [aStream nextPutAll: self directives].
	self private notNil 
		ifTrue: 
			[self writePublicOrPrivateTo: aStream.
			self maxAge notNil ifTrue: [aStream nextPutAll: ', ']].
	self maxAge notNil ifTrue: [self writeMaxAgeTo: aStream].
	^self!

writeMaxAgeTo: aStream 
	"^self
I write the maxAge directive to aStream"

	aStream nextPutAll: 'max-age='.
	self maxAge printOn: aStream.
	^self!

writePublicOrPrivateTo: aStream 
	"^self
I write the either the public or the private directive to aStream"

	self private 
		ifTrue: [aStream nextPutAll: 'private']
		ifFalse: [aStream nextPutAll: 'public'].
	^self! !
!HTTPCacheControlField categoriesFor: #directives!accessing!public! !
!HTTPCacheControlField categoriesFor: #directives:!accessing!public! !
!HTTPCacheControlField categoriesFor: #maxAge!accessing!public! !
!HTTPCacheControlField categoriesFor: #maxAge:!public!services! !
!HTTPCacheControlField categoriesFor: #private!accessing!public! !
!HTTPCacheControlField categoriesFor: #setNotPublicOrPrivate!public!services! !
!HTTPCacheControlField categoriesFor: #setPrivate!public!services! !
!HTTPCacheControlField categoriesFor: #setPublic!public!services! !
!HTTPCacheControlField categoriesFor: #valuesAsStringOn:!printing!public! !
!HTTPCacheControlField categoriesFor: #writeMaxAgeTo:!printing!public! !
!HTTPCacheControlField categoriesFor: #writePublicOrPrivateTo:!printing!public! !

!HTTPCacheControlField class methodsFor!

fieldName
	^'Cache-Control'! !
!HTTPCacheControlField class categoriesFor: #fieldName!accessing!public! !

HTTPConnectionField guid: (GUID fromString: '{130133FB-9EC2-4E42-A485-48A443E7845F}')!
HTTPConnectionField comment: '
c.f. RFC 2616 14.10

   The Connection header has the following grammar:

       Connection = "Connection" ":" 1#(connection-token)
       connection-token  = token

'!
!HTTPConnectionField categoriesForClass!Unclassified! !
!HTTPConnectionField methodsFor!

connectionToken
	"^a String
Common values are 'close' and 'keep-alive'."

	^connectionToken!

connectionToken: aString 
	"^self"

	connectionToken := aString.
	^self!

connectionTokenIsClose
	^self connectionToken = 'close'!

parseValueFrom: aString 
	connectionToken := HTTPString trimBlanksFrom: aString.
	^self!

setToClose
	self connectionToken: 'close'.
	^self!

setToKeepAlive
	self connectionToken: 'keep-alive'.
	^self!

valuesAsStringOn: aStream 
	aStream nextPutAll: connectionToken.
	^self! !
!HTTPConnectionField categoriesFor: #connectionToken!accessing!public! !
!HTTPConnectionField categoriesFor: #connectionToken:!accessing!public! !
!HTTPConnectionField categoriesFor: #connectionTokenIsClose!public!testing! !
!HTTPConnectionField categoriesFor: #parseValueFrom:!private! !
!HTTPConnectionField categoriesFor: #setToClose!public!services! !
!HTTPConnectionField categoriesFor: #setToKeepAlive!public!services! !
!HTTPConnectionField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPConnectionField class methodsFor!

fieldName
	^'Connection'! !
!HTTPConnectionField class categoriesFor: #fieldName!accessing!public! !

HTTPContentLengthField guid: (GUID fromString: '{9ADE932C-1382-48B4-831C-E95154A31351}')!
HTTPContentLengthField comment: ''!
!HTTPContentLengthField categoriesForClass!Unclassified! !
!HTTPContentLengthField methodsFor!

contentLength
	^contentLength!

contentLength: anInteger
	contentLength := anInteger!

parseValueFrom: aString
	contentLength := aString asNumber.
	^self!

valuesAsStringOn: aStream 
	self contentLength printOn: aStream.
	^self! !
!HTTPContentLengthField categoriesFor: #contentLength!accessing!public! !
!HTTPContentLengthField categoriesFor: #contentLength:!accessing!public! !
!HTTPContentLengthField categoriesFor: #parseValueFrom:!private! !
!HTTPContentLengthField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPContentLengthField class methodsFor!

fieldName
	^'Content-Length'! !
!HTTPContentLengthField class categoriesFor: #fieldName!accessing!public! !

HTTPCookieField guid: (GUID fromString: '{EC195A24-31AF-4FE1-B93F-9128EC9B2D75}')!
HTTPCookieField comment: ''!
!HTTPCookieField categoriesForClass!Unclassified! !
!HTTPCookieField class methodsFor!

fieldName
	^'Cookie'! !
!HTTPCookieField class categoriesFor: #fieldName!accessing!public! !

HTTPDateField guid: (GUID fromString: '{2406914A-0B02-4500-A155-3A9281378F04}')!
HTTPDateField comment: ''!
!HTTPDateField categoriesForClass!Unclassified! !
!HTTPDateField methodsFor!

date
	^date!

date: aDate 
	"^self
Note that this is an HTTP Date, and so is really a timestamp :-/ "

	date := aDate.
	^self!

valuesAsStringOn: aStream 
	self date asRFC1123StringOn: aStream.
	^self! !
!HTTPDateField categoriesFor: #date!accessing!public! !
!HTTPDateField categoriesFor: #date:!accessing!public! !
!HTTPDateField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPDateField class methodsFor!

fieldName
	^'Date'! !
!HTTPDateField class categoriesFor: #fieldName!accessing!public! !

HTTPETagField guid: (GUID fromString: '{D32A1577-4410-4CF2-8DF9-20B99B62DB16}')!
HTTPETagField comment: '
RFC 2626 14.19 ETag

   The ETag response-header field provides the current value of the
   entity tag for the requested variant. The headers used with entity
   tags are described in sections 14.24, 14.26 and 14.44. The entity tag
   MAY be used for comparison with other entities from the same resource
   (see section 13.3.3).

      ETag = "ETag" ":" entity-tag

   Examples:

      ETag: "xyzzy"
      ETag: W/"xyzzy"
      ETag: ""

'!
!HTTPETagField categoriesForClass!Unclassified! !
!HTTPETagField methodsFor!

entityTag
	^entityTag!

entityTag: aString 
	entityTag := aString.
	^self!

valuesAsStringOn: aStream 
	aStream
		nextPut: $";
		nextPutAll: self entityTag;
		nextPut: $".
	^self! !
!HTTPETagField categoriesFor: #entityTag!accessing!public! !
!HTTPETagField categoriesFor: #entityTag:!accessing!public! !
!HTTPETagField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPETagField class methodsFor!

fieldName
	^'ETag'! !
!HTTPETagField class categoriesFor: #fieldName!accessing!public! !

HTTPExpiresField guid: (GUID fromString: '{B7BB9948-84C9-4896-A986-A56848FF60C7}')!
HTTPExpiresField comment: ''!
!HTTPExpiresField categoriesForClass!Unclassified! !
!HTTPExpiresField methodsFor!

timestamp
	^timestamp!

timestamp: aTimestamp
	timestamp := aTimestamp.!

valuesAsStringOn: aStream 
	self timestamp asRFC1123StringOn: aStream.
	^self! !
!HTTPExpiresField categoriesFor: #timestamp!accessing!public! !
!HTTPExpiresField categoriesFor: #timestamp:!accessing!public! !
!HTTPExpiresField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPExpiresField class methodsFor!

fieldName
	^'Expires'! !
!HTTPExpiresField class categoriesFor: #fieldName!accessing!public! !

HTTPHostField guid: (GUID fromString: '{28058F35-2922-4BB3-868D-3E7D366D2584}')!
HTTPHostField comment: ''!
!HTTPHostField categoriesForClass!Unclassified! !
!HTTPHostField methodsFor!

hostName
	^hostName!

parseValueFrom: aString 
	| sourceStream portNumberString |
	sourceStream := ReadStream on: aString.
	hostName := sourceStream upTo: $:.
	portNumberString := sourceStream atEnd 
				ifTrue: [String new]
				ifFalse: [sourceStream upToEnd].
	portNumberString notEmpty 
		ifTrue: [portNumber := portNumberString asNumber].
	^self!

portNumber
	^portNumber isNil ifTrue: [80] ifFalse: [portNumber]!

valuesAsStringOn: aStream 
	aStream nextPutAll: self hostName.
	portNumber notNil 
		ifTrue: 
			[aStream nextPut: $:.
			self portNumber printOn: aStream].
	^self! !
!HTTPHostField categoriesFor: #hostName!accessing!public! !
!HTTPHostField categoriesFor: #parseValueFrom:!private! !
!HTTPHostField categoriesFor: #portNumber!accessing!public! !
!HTTPHostField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPHostField class methodsFor!

fieldName
	^'Host'! !
!HTTPHostField class categoriesFor: #fieldName!accessing!public! !

HTTPIfModifiedSinceField guid: (GUID fromString: '{6C6F9921-A9C6-47D5-97DE-A6700BF04491}')!
HTTPIfModifiedSinceField comment: ''!
!HTTPIfModifiedSinceField categoriesForClass!Unclassified! !
!HTTPIfModifiedSinceField methodsFor!

date
	^date!

isCacheHitFor: anEntity 
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent.  So in my case, I'm looking to see that the entity has not changed since my date.
anEntity *must* respond to >>lastModified"

	^anEntity lastModified <= self date!

isConditional
	^true!

parseValueFrom: aString 
	date := SpTimestamp fromRFC1123String: aString.
	^self!

valuesAsStringOn: aStream 
	self date notNil ifTrue: [self date asRFC1123StringOn: aStream].
	^self! !
!HTTPIfModifiedSinceField categoriesFor: #date!accessing!public! !
!HTTPIfModifiedSinceField categoriesFor: #isCacheHitFor:!public!testing! !
!HTTPIfModifiedSinceField categoriesFor: #isConditional!public!testing! !
!HTTPIfModifiedSinceField categoriesFor: #parseValueFrom:!private! !
!HTTPIfModifiedSinceField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPIfModifiedSinceField class methodsFor!

fieldName
	^'If-Modified-Since'! !
!HTTPIfModifiedSinceField class categoriesFor: #fieldName!accessing!public! !

HTTPIfRangeField guid: (GUID fromString: '{96AB0811-0138-4FFE-9EA3-D9C9EC6478BD}')!
HTTPIfRangeField comment: ''!
!HTTPIfRangeField categoriesForClass!Unclassified! !
!HTTPIfRangeField class methodsFor!

fieldName
	^'If-Range'! !
!HTTPIfRangeField class categoriesFor: #fieldName!accessing!public! !

HTTPIfUnmodifiedSinceField guid: (GUID fromString: '{6ACA7F82-49F5-4669-9BDE-56EC330E37E1}')!
HTTPIfUnmodifiedSinceField comment: ''!
!HTTPIfUnmodifiedSinceField categoriesForClass!Unclassified! !
!HTTPIfUnmodifiedSinceField methodsFor!

isCacheHitFor: anEntity 
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent. 
anEntity *must* respond to >>entutyTag"

	1 halt.
	^self!

isConditional
	^true! !
!HTTPIfUnmodifiedSinceField categoriesFor: #isCacheHitFor:!public!testing! !
!HTTPIfUnmodifiedSinceField categoriesFor: #isConditional!public!testing! !

!HTTPIfUnmodifiedSinceField class methodsFor!

fieldName
	^'If-Unmodified-Since'! !
!HTTPIfUnmodifiedSinceField class categoriesFor: #fieldName!accessing!public! !

HTTPLastModifiedField guid: (GUID fromString: '{5AFA5476-5BAB-4981-95DF-193BE6F9A503}')!
HTTPLastModifiedField comment: ''!
!HTTPLastModifiedField categoriesForClass!Unclassified! !
!HTTPLastModifiedField methodsFor!

timestamp
	^timestamp!

timestamp: aTimestamp
	timestamp := aTimestamp.!

valuesAsStringOn: aStream 
	self timestamp asRFC1123StringOn: aStream.
	^self! !
!HTTPLastModifiedField categoriesFor: #timestamp!accessing!public! !
!HTTPLastModifiedField categoriesFor: #timestamp:!accessing!public! !
!HTTPLastModifiedField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPLastModifiedField class methodsFor!

fieldName
	^'Last-Modified'! !
!HTTPLastModifiedField class categoriesFor: #fieldName!accessing!public! !

HTTPLocationField guid: (GUID fromString: '{A5AB4986-1547-4730-BB77-727629B78864}')!
HTTPLocationField comment: ''!
!HTTPLocationField categoriesForClass!Unclassified! !
!HTTPLocationField methodsFor!

uri
	^uri!

uri: aSwazooURI 
	uri := aSwazooURI.
	^self!

uriString: aString 
	uri := SwazooURI fromString: aString.
	^self!

valuesAsStringOn: aStream 
	self uri printOn: aStream.
	^self! !
!HTTPLocationField categoriesFor: #uri!accessing!public! !
!HTTPLocationField categoriesFor: #uri:!accessing!public! !
!HTTPLocationField categoriesFor: #uriString:!accessing!public! !
!HTTPLocationField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPLocationField class methodsFor!

fieldName
	^'Location'! !
!HTTPLocationField class categoriesFor: #fieldName!accessing!public! !

HTTPMatchField guid: (GUID fromString: '{2B8311C1-97A4-40F2-8AA1-30188CADB30B}')!
HTTPMatchField comment: ''!
!HTTPMatchField categoriesForClass!Unclassified! !
!HTTPMatchField methodsFor!

addEntityTag: aString 
	self entityTags add: aString.
	^self!

combineWith: aHeaderField 
	"^self
I add the entity tags of aHeaderField to my own collection of entity tags."

	self entityTags addAll: aHeaderField entityTags.
	^self!

entityTags
	^self matchesAnyCurrentEntity 
		ifTrue: [nil]
		ifFalse: 
			[entityTags isNil ifTrue: [entityTags := OrderedCollection new].
			entityTags]!

isConditional
	^true!

matchesAnyCurrentEntity
	^entityTags = '*'!

parseValueFrom: aString 
	aString = '*' 
		ifTrue: [entityTags := aString]
		ifFalse: 
			[| sourceStream |
			entityTags := OrderedCollection new.
			sourceStream := ReadStream on: aString.
			[sourceStream atEnd] whileFalse: 
					[| entityTag |
					sourceStream upTo: $".
					entityTag := sourceStream upTo: $".
					entityTags add: entityTag.
					sourceStream upTo: $,]].
	^self!

valuesAsStringOn: targetStream 
	self write: self entityTags first asQuotedStringTo: targetStream.
	2 to: self entityTags size
		do: 
			[:tagIndex | 
			targetStream nextPut: $,.
			self write: (self entityTags at: tagIndex) asQuotedStringTo: targetStream].
	^self!

write: aString asQuotedStringTo: targetStream 
	"^self
See RFC 2616 2.2"

	targetStream nextPut: $".
	aString do: 
			[:character | 
			character == $" 
				ifTrue: [targetStream nextPutAll: '\"']
				ifFalse: [targetStream nextPut: character]].
	targetStream nextPut: $".
	^self! !
!HTTPMatchField categoriesFor: #addEntityTag:!public!services! !
!HTTPMatchField categoriesFor: #combineWith:!public!services! !
!HTTPMatchField categoriesFor: #entityTags!accessing!public! !
!HTTPMatchField categoriesFor: #isConditional!public!testing! !
!HTTPMatchField categoriesFor: #matchesAnyCurrentEntity!public!testing! !
!HTTPMatchField categoriesFor: #parseValueFrom:!private! !
!HTTPMatchField categoriesFor: #valuesAsStringOn:!printing!public! !
!HTTPMatchField categoriesFor: #write:asQuotedStringTo:!printing!public! !

HTTPRefererField guid: (GUID fromString: '{E14F0A8A-A5C6-4049-AD82-FB03ECEA6575}')!
HTTPRefererField comment: '
RFC 2616: 14.36 Referer

   The Referer[sic] request-header field allows the client to specify,
   for the server''s benefit, the address (URI) of the resource from
   which the Request-URI was obtained (the "referrer", although the
   header field is misspelled.) The Referer request-header allows a
   server to generate lists of back-links to resources for interest,
   logging, optimized caching, etc. It also allows obsolete or mistyped
   links to be traced for maintenance. The Referer field MUST NOT be
   sent if the Request-URI was obtained from a source that does not have
   its own URI, such as input from the user keyboard.

       Referer        = "Referer" ":" ( absoluteURI | relativeURI )

   Example:

       Referer: http://www.w3.org/hypertext/DataSources/Overview.html

   If the field value is a relative URI, it SHOULD be interpreted
   relative to the Request-URI. The URI MUST NOT include a fragment. See
   section 15.1.3 for security considerations.

'!
!HTTPRefererField categoriesForClass!Unclassified! !
!HTTPRefererField methodsFor!

parseValueFrom: aString 
	uri := SwazooURI fromString: aString.
	^self!

uri
	^uri!

valuesAsStringOn: aStream 
	self uri printOn: aStream.
	^self! !
!HTTPRefererField categoriesFor: #parseValueFrom:!private! !
!HTTPRefererField categoriesFor: #uri!accessing!public! !
!HTTPRefererField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPRefererField class methodsFor!

fieldName
	^'Referer'! !
!HTTPRefererField class categoriesFor: #fieldName!accessing!public! !

HTTPServerField guid: (GUID fromString: '{67FDE19A-B650-4702-A8E2-0ABD9BDFD493}')!
HTTPServerField comment: ''!
!HTTPServerField categoriesForClass!Unclassified! !
!HTTPServerField methodsFor!

productTokens
	^productTokens!

productTokens: aString 
	productTokens := aString.
	^self!

valuesAsStringOn: aStream 
	aStream nextPutAll: self productTokens.
	^self! !
!HTTPServerField categoriesFor: #productTokens!accessing!public! !
!HTTPServerField categoriesFor: #productTokens:!accessing!public! !
!HTTPServerField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPServerField class methodsFor!

fieldName
	^'Server'! !
!HTTPServerField class categoriesFor: #fieldName!accessing!public! !

HTTPSetCookieField guid: (GUID fromString: '{FBBC781B-0830-47AE-BABC-E6B6FDFFBB53}')!
HTTPSetCookieField comment: ''!
!HTTPSetCookieField categoriesForClass!Unclassified! !
!HTTPSetCookieField methodsFor!

addCookie: aCookieString
	^self cookies add: aCookieString!

combineWith: aSetCookieField 
	"^self
I add the cookies of aSetCookieField to my own collection of cookies."

	self cookies addAll: aSetCookieField cookies.
	^self!

cookies
	cookies isNil ifTrue: [cookies := OrderedCollection new].
	^cookies!

valuesAsStringOn: aStream 
	aStream nextPutAll: (self cookies at: 1).
	2 to: self cookies size
		do: 
			[:cookieIndex | 
			aStream
				nextPutAll: ', ';
				nextPutAll: (self cookies at: cookieIndex)].
	^self! !
!HTTPSetCookieField categoriesFor: #addCookie:!public!services! !
!HTTPSetCookieField categoriesFor: #combineWith:!public!services! !
!HTTPSetCookieField categoriesFor: #cookies!accessing!public! !
!HTTPSetCookieField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPSetCookieField class methodsFor!

fieldName
	^'Set-Cookie'! !
!HTTPSetCookieField class categoriesFor: #fieldName!accessing!public! !

HTTPUserAgentField guid: (GUID fromString: '{CE98B0C5-A0D1-4FC0-9AB4-B22ED53C54BA}')!
HTTPUserAgentField comment: '
RFC 2616: 14.43 User-Agent

   The User-Agent request-header field contains information about the
   user agent originating the request. This is for statistical purposes,
   the tracing of protocol violations, and automated recognition of user
   agents for the sake of tailoring responses to avoid particular user
   agent limitations. User agents SHOULD include this field with
   requests. The field can contain multiple product tokens (section 3.8)
   and comments identifying the agent and any subproducts which form a
   significant part of the user agent. By convention, the product tokens
   are listed in order of their significance for identifying the
   application.

       User-Agent     = "User-Agent" ":" 1*( product | comment )

   Example:

       User-Agent: CERN-LineMode/2.15 libwww/2.17b3'!
!HTTPUserAgentField categoriesForClass!Unclassified! !
!HTTPUserAgentField methodsFor!

parseValueFrom: aString 
	"^self
I could try and parse out the product name and version numbers, but there is no need to worry about this at the moment, so I just record the string."

	productTokens := HTTPString trimBlanksFrom: aString.
	^self!

productTokens
	^productTokens!

valuesAsStringOn: aStream 
	aStream nextPutAll: productTokens.
	^self! !
!HTTPUserAgentField categoriesFor: #parseValueFrom:!private! !
!HTTPUserAgentField categoriesFor: #productTokens!accessing!public! !
!HTTPUserAgentField categoriesFor: #valuesAsStringOn:!printing!public! !

!HTTPUserAgentField class methodsFor!

fieldName
	^'User-Agent'! !
!HTTPUserAgentField class categoriesFor: #fieldName!accessing!public! !

HTTPWWWAuthenticateField guid: (GUID fromString: '{4624187C-34A5-4D58-B821-ED15781A6C54}')!
HTTPWWWAuthenticateField comment: ''!
!HTTPWWWAuthenticateField categoriesForClass!Unclassified! !
!HTTPWWWAuthenticateField methodsFor!

isBasic
	"^a Boolean
I return true if I represent a header for basic authentication. c.f. RFC 2617 sec 2."

	^false!

isDigest
	"^a Boolean
I return true if I represent a header for digest authentication. c.f. RFC 2617 sec 3."

	^false! !
!HTTPWWWAuthenticateField categoriesFor: #isBasic!public!testing! !
!HTTPWWWAuthenticateField categoriesFor: #isDigest!public!testing! !

!HTTPWWWAuthenticateField class methodsFor!

fieldName
	^'WWW-Authenticate'! !
!HTTPWWWAuthenticateField class categoriesFor: #fieldName!accessing!public! !

HTTPAuthorizationBasicField guid: (GUID fromString: '{974885A1-C41C-4B1E-9161-B177AC9016BB}')!
HTTPAuthorizationBasicField comment: ''!
!HTTPAuthorizationBasicField categoriesForClass!Unclassified! !
!HTTPAuthorizationBasicField methodsFor!

password
	"^a String
I return the password string (as defined in RFC 2617 pp.2) part of the user-pass value in my credentials."

	password isNil ifTrue: [self resolveUserPass].
	^password!

resolveUserPass
	"^self
I look at my credentials string and pull out the userid and password.  Note that having to check for atEnd before the upToEnd is for GemStone which crashes if upToEnd is used when already atEnd."

	"(Base64EncodingReadStream on: 'YnJ1Y2U6c3F1aWRzdXBwbGllZHBhc3N3b3Jk' ) upToEnd asString "

	| userPassString sourceStream |
	userPassString := userPassString := (ByteArray fromBase64String: self credentials) asString.
	sourceStream := ReadStream on: userPassString.
	userid := sourceStream upTo: $:.
	password := sourceStream atEnd 
				ifTrue: [String new]
				ifFalse: [sourceStream upToEnd].
	^self!

userid
	"^a String
I return the userid string (as defined in RFC 2617 pp.2) part of the user-pass value in my credentials."

	userid isNil ifTrue: [self resolveUserPass].
	^userid!

valuesAsStringOn: aStream 
	aStream nextPutAll: 'Basic '.
	super valuesAsStringOn: aStream.
	^self! !
!HTTPAuthorizationBasicField categoriesFor: #password!public!services! !
!HTTPAuthorizationBasicField categoriesFor: #resolveUserPass!private! !
!HTTPAuthorizationBasicField categoriesFor: #userid!public!services! !
!HTTPAuthorizationBasicField categoriesFor: #valuesAsStringOn:!printing!public! !

HTTPAuthorizationDigestField guid: (GUID fromString: '{B2ED4C38-434A-4876-9197-7B9EDC0902CB}')!
HTTPAuthorizationDigestField comment: ''!
!HTTPAuthorizationDigestField categoriesForClass!Unclassified! !
!HTTPAuthorizationDigestField methodsFor!

valuesAsStringOn: aStream 
	aStream nextPutAll: 'Digest '.
	super valuesAsStringOn: aStream.
	^self! !
!HTTPAuthorizationDigestField categoriesFor: #valuesAsStringOn:!printing!public! !

HTTPIfMatchField guid: (GUID fromString: '{4DB43C4D-4E8C-47B4-A3C0-0CC01F88421B}')!
HTTPIfMatchField comment: '
>From RFC 2616

14.24 If-Match

   The If-Match request-header field is used with a method to make it
   conditional. A client that has one or more entities previously
   obtained from the resource can verify that one of those entities is
   current by including a list of their associated entity tags in the
   If-Match header field. Entity tags are defined in section 3.11. The
   purpose of this feature is to allow efficient updates of cached
   information with a minimum amount of transaction overhead. It is also
   used, on updating requests, to prevent inadvertent modification of
   the wrong version of a resource. As a special case, the value "*"
   matches any current entity of the resource.

       If-Match = "If-Match" ":" ( "*" | 1#entity-tag )

   If any of the entity tags match the entity tag of the entity that
   would have been returned in the response to a similar GET request
   (without the If-Match header) on that resource, or if "*" is given

   and any current entity exists for that resource, then the server MAY
   perform the requested method as if the If-Match header field did not
   exist.

   A server MUST use the strong comparison function (see section 13.3.3)
   to compare the entity tags in If-Match.

   If none of the entity tags match, or if "*" is given and no current
   entity exists, the server MUST NOT perform the requested method, and
   MUST return a 412 (Precondition Failed) response. This behavior is
   most useful when the client wants to prevent an updating method, such
   as PUT, from modifying a resource that has changed since the client
   last retrieved it.

   If the request would, without the If-Match header field, result in
   anything other than a 2xx or 412 status, then the If-Match header
   MUST be ignored.

   The meaning of "If-Match: *" is that the method SHOULD be performed
   if the representation selected by the origin server (or by a cache,
   possibly using the Vary mechanism, see section 14.44) exists, and
   MUST NOT be performed if the representation does not exist.

   A request intended to update a resource (e.g., a PUT) MAY include an
   If-Match header field to signal that the request method MUST NOT be
   applied if the entity corresponding to the If-Match value (a single
   entity tag) is no longer a representation of that resource. This
   allows the user to indicate that they do not wish the request to be
   successful if the resource has been changed without their knowledge.
   Examples:

       If-Match: "xyzzy"
       If-Match: "xyzzy", "r2d2xxxx", "c3piozzzz"
       If-Match: *

   The result of a request having both an If-Match header field and
   either an If-None-Match or an If-Modified-Since header fields is
   undefined by this specification.

'!
!HTTPIfMatchField categoriesForClass!Unclassified! !
!HTTPIfMatchField methodsFor!

isCacheHitFor: anEntity 
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent. 
anEntity *must* respond to >>entutyTag"

	1 halt.
	^self! !
!HTTPIfMatchField categoriesFor: #isCacheHitFor:!public!testing! !

!HTTPIfMatchField class methodsFor!

fieldName
	^'If-Match'! !
!HTTPIfMatchField class categoriesFor: #fieldName!accessing!public! !

HTTPIfNoneMatchField guid: (GUID fromString: '{88C1284D-4C6A-4EBF-B79C-FFC373C888FF}')!
HTTPIfNoneMatchField comment: '
This is a confitional header field.  The HTTP client is asking for a resource on the basis of this condition.  So, we need to have first found the resource, and then we can considder the condition, as follows ...

>From RFC 2616:

14.26 If-None-Match

   The If-None-Match request-header field is used with a method to make
   it conditional. A client that has one or more entities previously
   obtained from the resource can verify that none of those entities is
   current by including a list of their associated entity tags in the
   If-None-Match header field. The purpose of this feature is to allow
   efficient updates of cached information with a minimum amount of
   transaction overhead. It is also used to prevent a method (e.g. PUT)
   from inadvertently modifying an existing resource when the client
   believes that the resource does not exist.

   As a special case, the value "*" matches any current entity of the
   resource.

       If-None-Match = "If-None-Match" ":" ( "*" | 1#entity-tag )

   If any of the entity tags match the entity tag of the entity that
   would have been returned in the response to a similar GET request
   (without the If-None-Match header) on that resource, or if "*" is
   given and any current entity exists for that resource, then the
   server MUST NOT perform the requested method, unless required to do
   so because the resource''s modification date fails to match that
   supplied in an If-Modified-Since header field in the request.
   Instead, if the request method was GET or HEAD, the server SHOULD
   respond with a 304 (Not Modified) response, including the cache-
   related header fields (particularly ETag) of one of the entities that
   matched. For all other request methods, the server MUST respond with
   a status of 412 (Precondition Failed).

   See section 13.3.3 for rules on how to determine if two entities tags
   match. The weak comparison function can only be used with GET or HEAD
   requests.

   If none of the entity tags match, then the server MAY perform the
   requested method as if the If-None-Match header field did not exist,
   but MUST also ignore any If-Modified-Since header field(s) in the
   request. That is, if no entity tags match, then the server MUST NOT
   return a 304 (Not Modified) response.

   If the request would, without the If-None-Match header field, result
   in anything other than a 2xx or 304 status, then the If-None-Match
   header MUST be ignored. (See section 13.3.4 for a discussion of
   server behavior when both If-Modified-Since and If-None-Match appear
   in the same request.)

   The meaning of "If-None-Match: *" is that the method MUST NOT be
   performed if the representation selected by the origin server (or by
   a cache, possibly using the Vary mechanism, see section 14.44)
   exists, and SHOULD be performed if the representation does not exist.
   This feature is intended to be useful in preventing races between PUT
   operations.

   Examples:

       If-None-Match: "xyzzy"
       If-None-Match: W/"xyzzy"
       If-None-Match: "xyzzy", "r2d2xxxx", "c3piozzzz"
       If-None-Match: W/"xyzzy", W/"r2d2xxxx", W/"c3piozzzz"
       If-None-Match: *

   The result of a request having both an If-None-Match header field and
   either an If-Match or an If-Unmodified-Since header fields is
   undefined by this specification.'!
!HTTPIfNoneMatchField categoriesForClass!Unclassified! !
!HTTPIfNoneMatchField methodsFor!

isCacheHitFor: anEntity 
	"^a Boolean
I return true if an anEntity is a cache hit given the conditional I represent.  So in my case, I'm looking to see that the entity has a tag which is in my collection of entityTags.
anEntity *must* respond to >>entityTag"

	^self entityTags includes: anEntity entityTag! !
!HTTPIfNoneMatchField categoriesFor: #isCacheHitFor:!public!testing! !

!HTTPIfNoneMatchField class methodsFor!

fieldName
	^'If-None-Match'! !
!HTTPIfNoneMatchField class categoriesFor: #fieldName!accessing!public! !

HTTPWWWAuthenticateBasicField guid: (GUID fromString: '{EFB55006-5EBE-4209-87D4-74D0DEF44378}')!
HTTPWWWAuthenticateBasicField comment: ''!
!HTTPWWWAuthenticateBasicField categoriesForClass!Unclassified! !
!HTTPWWWAuthenticateBasicField methodsFor!

isBasic
	"^a Boolean
I return true if I represent a header for basic authentication. c.f. RFC 2617 sec 2."

	^true!

realm
	"^a String
I return the realm for which I represent an autentication challenge.  This string will be presented to the browser user in the login dialog."

	^realm!

realm: anObject
	realm := anObject!

valuesAsStringOn: aStream 
	aStream
		nextPutAll: 'Basic realm="';
		nextPutAll: self realm;
		nextPut: $".
	^self! !
!HTTPWWWAuthenticateBasicField categoriesFor: #isBasic!public!testing! !
!HTTPWWWAuthenticateBasicField categoriesFor: #realm!accessing!public! !
!HTTPWWWAuthenticateBasicField categoriesFor: #realm:!accessing!public! !
!HTTPWWWAuthenticateBasicField categoriesFor: #valuesAsStringOn:!printing!public! !

HTTPWWWAuthenticateDigestField guid: (GUID fromString: '{F46881D5-81DF-4BC1-9214-141E47D584BA}')!
HTTPWWWAuthenticateDigestField comment: ''!
!HTTPWWWAuthenticateDigestField categoriesForClass!Unclassified! !
!HTTPWWWAuthenticateDigestField methodsFor!

isDigest
	"^a Boolean
I return true if I represent a header for digest authentication. c.f. RFC 2617 sec 3."

	^true! !
!HTTPWWWAuthenticateDigestField categoriesFor: #isDigest!public!testing! !

HTTPRequest guid: (GUID fromString: '{9C097209-B80A-42A6-8ACF-011A593DC162}')!
HTTPRequest comment: ''!
!HTTPRequest categoriesForClass!Unclassified! !
!HTTPRequest methodsFor!

authenticated
	^authenticated!

conditionalHeaderFields
	"^an OrderedCollection
I return my collection of conditional header fields.  A conditional GET requires that each of these is checked against the current state of the target resource."

	^self headers fields select: [:aField | aField isConditional]!

connection
	^(self headers fieldOfClass: HTTPConnectionField ifNone: [^nil]) 
		connectionToken!

contentLength
	^(self headers fieldOfClass: HTTPContentLengthField) contentLength!

cookie
	| field |
	field := self headers fields at: 'COOKIE' ifAbsent: [^nil].
	^field value

"	field := self headers fieldOfClass: HTTPCookieField ifNone: [nil].
	^field isNil ifTrue: [nil] ifFalse: [field valuesAsString]
"!

encrypted
	^encrypted!

ensureFullRead
	"that is, that everything is read from a socket stream. Importanf for HTTPost 
	and defered parsing of postData"!

environmentAt: aKey 
	^self environmentAt: aKey ifAbsent: [nil]!

environmentAt: aKey ifAbsent: aBlock 
	^self environmentData at: aKey ifAbsent: aBlock!

environmentAt: aKey put: aValue 
	self environmentData at: aKey put: aValue!

environmentData
	environmentData isNil ifTrue: [self initEnvironmentData].
	^environmentData!

for: aRequestLine readFrom: aSwazooStream 
	"^self
I parse my headers from aStream and update my URI and HTTP version information from aRequest line.  I need to parse the headers first because, for some reason, the URI insists on knowing the host, and this is taken from the Host: header field."

	requestLine := aRequestLine.
	headers := HTTPHeaders readFrom: aSwazooStream.
	self setTimestamp.
	^self!

hasCookie
	"check if  Cookie:  was in request header"

	"it is GenericHeaderField!!"
	^self headers fields includesKey: 'COOKIE'

"	^self headers includesFieldOfClass: HTTPCookieField"!

headerAt: aKey ifAbsent: aBlock
	^self headers fieldNamed: aKey  ifNone: aBlock!

host
	^(self headers fieldOfClass: HTTPHostField ifNone: [^String new]) 
		hostName!

httpVersion
	^self requestLine httpVersion!

includesQuery: aString 
	^self uri includesQuery: aString!

initEnvironmentData
	environmentData := Dictionary new!

initRequestLine
	requestLine := HTTPRequestLine new!

ip
	^ip!

ip: anObject
	ip := anObject!

isAuthenticated
	^self authenticated isNil not!

isClose
	| connectionField |
	connectionField := self headers fieldOfClass: HTTPConnectionField
				ifNone: [nil].
	^connectionField notNil and: [connectionField connectionTokenIsClose]!

isDelete
	^false!

isEncrypted
	^self encrypted isNil not!

isFromLinux
	^self userAgent notNil and: ['*Linux*' match: self userAgent]!

isFromMSIE
	^self userAgent notNil and: ['*MSIE*' match: self userAgent]!

isFromNetscape
	"NS>7.0 or Mozilla or Firefox"
	^self userAgent notNil and: ['*Gecko*' match: self userAgent]!

isFromWindows
	^self userAgent notNil and: ['*Windows*' match: self userAgent]!

isGet
	^false!

isHead
	^false!

isHttp10
	"Version of requests's HTTP protocol is 1.0"
	^self requestLine isHttp10!

isHttp11
	"Version of requests's HTTP protocol is 1.0"
	^self requestLine isHttp11!

isKeepAlive
	| header |
	header := self connection.
	header isNil ifTrue: [^false].
	^'*Keep-Alive*' match: header!

isOptions
	^false!

isPost
	^false!

isPut
	^false!

isTrace
	^false!

keepAlive
	"how many seconds a connection must be kept alive"
	^(self headers fieldNamed: 'KeepAlive' ifNone: [^nil]) value!

methodName
	"HTTP method used for a request"
	^self class methodName!

peer
	^peer!

peer: anObject
	peer := anObject!

port
	"^an Integer
I return the port number to which the request was directed."
	| host |
	host := self headers fieldOfClass: HTTPHostField.
	^(host notNil and: [(self httpVersion at: 2) = 1])
		ifTrue: [host portNumber]
		ifFalse: [self requestLine requestURI port]!

printOn: aStream 
	aStream nextPutAll: 'a HTTPRequest ', self methodName.
	self isHttp10 ifTrue: [aStream nextPut: ' HTTP/1.0'].
	self peer notNil ifTrue: [aStream cr; tab; nextPutAll: ' from: '; nextPutAll: self peer].
	aStream cr; tab; nextPutAll: ' at: '. aStream nextPutAll: self timestamp printString.
	aStream cr; tab; nextPutAll: ' host: '; nextPutAll: (self headerAt: 'Host' ifAbsent: ['']) hostName.
	aStream cr; tab; nextPutAll: ' url: '. self uri printOn: aStream.
	self userAgent notNil ifTrue: 
		[aStream cr; tab; nextPutAll: ' browser: '; nextPutAll: self userAgent].
	self connection notNil ifTrue: 
		[aStream cr; tab; nextPutAll: ' connection: '; nextPutAll: self connection].
	self keepAlive notNil ifTrue: 
		[aStream cr; tab; nextPutAll: ' keep-alive: '; nextPutAll: self keepAlive].
	^self!

queries
	^self uri queries!

queryAt: aKey 
	^self uri queryAt: aKey!

queryAt: aKey ifAbsent: aBlock 
	^self uri queryAt: aKey ifAbsent: aBlock!

queryData
	^self uri queryData!

referer
	| field |
	field := self headers fieldOfClass: HTTPRefererField ifNone: [nil].
	^field isNil ifTrue: [nil] ifFalse: [field uri asString]!

request: aUriString from: aHostString at: anIPString 
	"For testing only (I'm guessing / hoping!!).
A request is manufactured that has a request line method of >>methodName and a request line URI with an identifier of aUriString.  A Host header is added to the headers and the ip address is set to anIP string.  I also set the HTTP version to #(1 1).
This may result in a corrupt or invalid request, but that's the natutre of testing, I guess."

	requestLine := (HTTPRequestLine new)
				method: self class methodName;
				requestURI: ((SwazooURI new)
							identifier: aUriString;
							yourself);
				httpVersion: #(1 1);
				yourself.
	self headers addField: (HTTPHostField newWithValueFrom: aHostString).
	self ip: anIPString.
	^self!

requestLine
	"^an HTTPRequestLine"

	requestLine isNil ifTrue: [self initRequestLine].
	^requestLine!

resolution
	^resolution!

resolution: anObject
	resolution := anObject!

resourcePath
	^self resolution resourcePath!

respondUsing: responseBlock 
	"^an HTTPResponse
By default, I let aBlock handle creating the response by passing myself as the agrument to the block.  My subclasses may override this method and directly respond.  This is most likely for Unsupported requests and for things like OPTIONS requsts.  c.f. HTTPServer>>answerTo: "

	^responseBlock value: self!

session
	^self environmentAt: #session!

session: aSession 
	self environmentAt: #session put: aSession!

setAuthenticated 	
	authenticated := true!

setEncrypted
	encrypted := true!

setTimestamp
	timestamp := SpTimestamp now!

streamedResponse
	"prepares (if not already) and return a streamed response"
	"necessary because we need an output stream to stream into"

	self task response isNil ifTrue: 
		[self task response: 
			(HTTPStreamedResponse on: self task stream: self task connection stream)].
	self task response class == HTTPStreamedResponse 
		ifFalse: [self halt. self error: 'not streamed response?'].  "this can happen if resp. is from before"
	^self task response!

tailPath
	^self resolution tailPath!

timestamp
	^timestamp!

uri
	^self requestLine requestURI!

uriString
	^self uri identifier!

urlString
	^self uri value!

userAgent
	| userAgentField |
	userAgentField := self headers fieldOfClass: HTTPUserAgentField
				ifNone: [nil].
	^userAgentField isNil ifTrue: [nil] ifFalse: [userAgentField productTokens]!

wantsConnectionClose
	self isClose ifTrue: [^true].
	^self isHttp10 and: [self isKeepAlive not]! !
!HTTPRequest categoriesFor: #authenticated!private! !
!HTTPRequest categoriesFor: #conditionalHeaderFields!public!services! !
!HTTPRequest categoriesFor: #connection!accessing-headers!public! !
!HTTPRequest categoriesFor: #contentLength!accessing-headers!public! !
!HTTPRequest categoriesFor: #cookie!accessing-headers!public! !
!HTTPRequest categoriesFor: #encrypted!private! !
!HTTPRequest categoriesFor: #ensureFullRead!private! !
!HTTPRequest categoriesFor: #environmentAt:!accessing!public! !
!HTTPRequest categoriesFor: #environmentAt:ifAbsent:!accessing!public! !
!HTTPRequest categoriesFor: #environmentAt:put:!accessing!public! !
!HTTPRequest categoriesFor: #environmentData!private! !
!HTTPRequest categoriesFor: #for:readFrom:!initialize-release!public! !
!HTTPRequest categoriesFor: #hasCookie!public!testing! !
!HTTPRequest categoriesFor: #headerAt:ifAbsent:!accessing-headers!public! !
!HTTPRequest categoriesFor: #host!accessing-headers!public! !
!HTTPRequest categoriesFor: #httpVersion!accessing!public! !
!HTTPRequest categoriesFor: #includesQuery:!accessing-queries!public! !
!HTTPRequest categoriesFor: #initEnvironmentData!initialize-release!public! !
!HTTPRequest categoriesFor: #initRequestLine!initialize-release!public! !
!HTTPRequest categoriesFor: #ip!accessing!public! !
!HTTPRequest categoriesFor: #ip:!private! !
!HTTPRequest categoriesFor: #isAuthenticated!public!testing! !
!HTTPRequest categoriesFor: #isClose!public!testing! !
!HTTPRequest categoriesFor: #isDelete!public!testing! !
!HTTPRequest categoriesFor: #isEncrypted!public!testing! !
!HTTPRequest categoriesFor: #isFromLinux!public!testing! !
!HTTPRequest categoriesFor: #isFromMSIE!public!testing! !
!HTTPRequest categoriesFor: #isFromNetscape!public!testing! !
!HTTPRequest categoriesFor: #isFromWindows!public!testing! !
!HTTPRequest categoriesFor: #isGet!public!testing! !
!HTTPRequest categoriesFor: #isHead!public!testing! !
!HTTPRequest categoriesFor: #isHttp10!public!testing! !
!HTTPRequest categoriesFor: #isHttp11!public!testing! !
!HTTPRequest categoriesFor: #isKeepAlive!public!testing! !
!HTTPRequest categoriesFor: #isOptions!public!testing! !
!HTTPRequest categoriesFor: #isPost!public!testing! !
!HTTPRequest categoriesFor: #isPut!public!testing! !
!HTTPRequest categoriesFor: #isTrace!public!testing! !
!HTTPRequest categoriesFor: #keepAlive!accessing-headers!public! !
!HTTPRequest categoriesFor: #methodName!accessing!public! !
!HTTPRequest categoriesFor: #peer!accessing!public! !
!HTTPRequest categoriesFor: #peer:!private! !
!HTTPRequest categoriesFor: #port!accessing-headers!public! !
!HTTPRequest categoriesFor: #printOn:!private! !
!HTTPRequest categoriesFor: #queries!private! !
!HTTPRequest categoriesFor: #queryAt:!accessing-queries!public! !
!HTTPRequest categoriesFor: #queryAt:ifAbsent:!accessing-queries!public! !
!HTTPRequest categoriesFor: #queryData!accessing-queries!public! !
!HTTPRequest categoriesFor: #referer!accessing-headers!public! !
!HTTPRequest categoriesFor: #request:from:at:!private! !
!HTTPRequest categoriesFor: #requestLine!accessing!public! !
!HTTPRequest categoriesFor: #resolution!accessing!public! !
!HTTPRequest categoriesFor: #resolution:!accessing!public! !
!HTTPRequest categoriesFor: #resourcePath!accessing!public! !
!HTTPRequest categoriesFor: #respondUsing:!public!services! !
!HTTPRequest categoriesFor: #session!accessing!public! !
!HTTPRequest categoriesFor: #session:!accessing!public! !
!HTTPRequest categoriesFor: #setAuthenticated!private! !
!HTTPRequest categoriesFor: #setEncrypted!private! !
!HTTPRequest categoriesFor: #setTimestamp!initialize-release!public! !
!HTTPRequest categoriesFor: #streamedResponse!accessing-response!public! !
!HTTPRequest categoriesFor: #tailPath!accessing!public! !
!HTTPRequest categoriesFor: #timestamp!accessing!public! !
!HTTPRequest categoriesFor: #uri!accessing!public! !
!HTTPRequest categoriesFor: #uriString!accessing!public! !
!HTTPRequest categoriesFor: #urlString!accessing!public! !
!HTTPRequest categoriesFor: #userAgent!accessing-headers!public! !
!HTTPRequest categoriesFor: #wantsConnectionClose!public!testing! !

!HTTPRequest class methodsFor!

allMethodNames
	"...of all request methods we support there"
	self subclasses collect: [:each | each methodName].!

methodName
	"HTTP method used for a request"
	^self subclassResponsibility!

newFor: aRequestLine readFrom: aSwazooStream 
	"to support an additional http method, simply subclass a HTTPRequest!!"
	| targetClass |
	targetClass := aRequestLine method = 'GET' 
		ifTrue: [HTTPGet] "most used anyway"
		ifFalse: [aRequestLine method = 'POST'  
			ifTrue: [HTTPPost]  "second most used"
			ifFalse: [self subclasses detect: [:each | 
				each methodName = aRequestLine method] ifNone: [nil] ] ].
	targetClass isNil ifTrue: [^HTTPException notImplemented].
	^targetClass new for: aRequestLine readFrom: aSwazooStream!

readFrom: aSwazooStream 
	"^an HTTPRequest
I create and return a new instance of one of my subclasses which will represent the HTTP request presumed to be the contents of aStream.
The first step is to work out which of my subclasses to create.  I do this by parsing the 'request-line' from the stream.  The request-line contains the 'method', and I look for the subclass that handles this method and delegate the rest of the message parsing to a new instance of that class."

	| requestLine |
	requestLine := HTTPRequestLine readFrom: aSwazooStream.
	^self newFor: requestLine readFrom: aSwazooStream!

request: aUriString 
	"For testing only (I'm guessing / hoping!!).  The idea to to create a request for a resource with the URI 'someHost/aUriString'."

	^self 
		request: aUriString
		from: 'someHost'
		at: 'someIP'!

request: aUriString from: aHostString at: anIPString 
	"For testing only (I'm guessing / hoping!!).
A request is manufactured that has a request line method of >>methodName and a request line URI with an identifier of aUriString.  A Host header is added to the headers and the ip address is set to anIP string.
This may result in a corrupt or invalid request, but that's the natutre of testing, I guess."

	^self new 
		request: aUriString
		from: aHostString
		at: anIPString! !
!HTTPRequest class categoriesFor: #allMethodNames!accessing!public! !
!HTTPRequest class categoriesFor: #methodName!accessing!public! !
!HTTPRequest class categoriesFor: #newFor:readFrom:!instance creation!public! !
!HTTPRequest class categoriesFor: #readFrom:!instance creation!public! !
!HTTPRequest class categoriesFor: #request:!public!tests support! !
!HTTPRequest class categoriesFor: #request:from:at:!public!tests support! !

HTTPResponse guid: (GUID fromString: '{A2949024-80E5-4328-9905-D86E906ACBB5}')!
HTTPResponse comment: ''!
!HTTPResponse categoriesForClass!Unclassified! !
!HTTPResponse methodsFor!

addDateHeader
	"^self
Note that the server must have it's clock set to GMT"

	self headers addField: (HTTPDateField new date: SpTimestamp now).
	^self!

addDefaultBody
	self entity: '<HTML>
<HEAD><TITLE>', (StatusCodes at: self code ifAbsent: [self code printString]), '</TITLE></HEAD>
  <BODY>
   <H2>', self code printString, ' ', (StatusCodes at: self code ifAbsent: [self code printString]), '</H2>
   <P>The server experienced an error while processing this request. <BR>
   If this problem persists, please contact the webmaster.</P>
  <P>Swazoo Smalltalk Web Server</P>
  </BODY>
</HTML>'!

addHeaderName: aNameString value: aValueString
	^self headers 
		addField: (GenericHeaderField newForFieldName: aNameString withValueFrom: aValueString)!

addInitialHeaders
	self addServerHeader.
	self addDateHeader!

addServerHeader
	^self headers 
		addField: (HTTPServerField new productTokens: SwazooServer swazooVersion)!

cacheControl: aString
	"example: 'no-store, no-cache, must-revalidate'"
	self headers addField: (HTTPCacheControlField new directives: aString).!

code
	^code!

code: anInteger 
	code := anInteger.
	(#(200) includes: code) ifFalse: [self addDefaultBody].!

codeText
	^self class statusTextForCode: self code!

contentLength: anInteger
	self headers addField: (HTTPContentLengthField new contentLength: anInteger).
	^self!

contentSize
	^self entity notNil 
		ifTrue: [self entity size] 
		ifFalse: [0]!

contentType
	"^a String
Return the media type from my Content-Type header field."

	^self headers 
		fieldOfClass: ContentTypeField
		ifPresent: [:field | field mediaType]
		ifAbsent: ['application/octet-stream']!

contentType: aString 
	self headers addField: (ContentTypeField new mediaType: aString).
	^self!

cookie: aString 
	| newField |
	newField := HTTPSetCookieField new.
	newField addCookie: aString.
	self headers addField: newField.
	^self!

crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf!

endHeaderOn: aStream 
	self crlfOn: aStream!

entity
	^entity!

entity: anEntity 
	entity := anEntity asByteArray "if not already"!

expires: aSpTimestamp  "from SPort "
	self headers addField: (HTTPExpiresField new timestamp: aSpTimestamp ).
	^self!

informConnectionClose
	self headers 
		fieldOfClass: HTTPConnectionField
		ifPresent: [:field | field setToClose]
		ifAbsent: [self headers addField: HTTPConnectionField new setToClose].
	^self!

informConnectionKeepAlive
	self headers 
		fieldOfClass: HTTPConnectionField
		ifPresent: [:field | field setToKeepAlive]
		ifAbsent: [self headers addField: HTTPConnectionField new setToKeepAlive].
	^self!

isBadRequest
	^self code = 400!

isFound
	^self code = 302!

isHttp10
	"we are responding by old HTTP/1.0 protocol"
	^self task request isHttp10!

isHttp11
	"we are responding by HTTP/1.1 protocol"
	^self task request isHttp11!

isInternalServerError
	^self code = 500!

isMovedPermanently
	^self code = 301!

isNotFound
	^self code = 404!

isNotImplemented
	^self code = 501!

isNotModified
	^self code = 304!

isOk
	^self code = 200!

isRedirectLink
	^self code = 302!

isSeeOther
	^self code = 303!

isStreamed
	^false!

isUnauthorized
	^self code = 401!

lastModified: aSpTimestamp "from SPort "
	self headers addField: (HTTPLastModifiedField new timestamp: aSpTimestamp).
	^self!

location: aString 
	self headers addField: (HTTPLocationField new uriString: aString).
	^self!

printChunkedTransferEncodingOn: aStream 
	aStream nextPutAll: 'Transfer-Encoding: chunked'.
	self crlfOn: aStream!

printContentLengthOn: aSwazooStream 
	"it is also added to headers. It is added so late because to be printed last, 
	just before body starts"
	self contentLength: self contentSize.
	(self headers fieldNamed: 'Content-length') printOn: aSwazooStream.
	self crlfOn: aSwazooStream!

printEntityOn: aStream 

	self entity isNil ifFalse: [aStream nextPutBytes: self entity]!

printHeadersOn: aSwazooStream 
	"^self
Write the headers (key-value pairs) to aStream.  The key
must be a String."

	self headers fields do: 
			[:aField | 
			aField printOn: aSwazooStream.
			self crlfOn: aSwazooStream]!

printStatusOn: aSwazooStream 
	| version |
	StatusCodes at: self code ifAbsent: [self class initialize]. "if some new status codes was added           													with #postInitialize method later"
	version := (self task isNil or: [self task request isNil or: [self task request isHttp11]]) 
		ifTrue: ['HTTP/1.1 '] ifFalse: ['HTTP/1.0 '].
	aSwazooStream
		nextPutAll: version;
		print: self code;
		space;
		nextPutAll: (self class statusTextForCode: self code).
	self crlfOn: aSwazooStream!

writeHeaderTo: aSwazooStream 
	self printStatusOn: aSwazooStream.
	self printHeadersOn: aSwazooStream.
	(self isStreamed and: [self shouldBeChunked])
		ifTrue: [self printChunkedTransferEncodingOn: aSwazooStream]
		ifFalse: [self printContentLengthOn: aSwazooStream].
	self endHeaderOn: aSwazooStream!

writeTo: aSwazooStream 
	self writeTo: aSwazooStream inResponseTo: nil!

writeTo: aSwazooStream inResponseTo: aRequest
	aSwazooStream isNil ifTrue: [ ^self ].
	self writeHeaderTo: aSwazooStream.
	(aRequest isNil or: [ aRequest isHead not ])
		ifTrue: [ self printEntityOn: aSwazooStream].
	aSwazooStream closeResponse! !
!HTTPResponse categoriesFor: #addDateHeader!initialize-release!public! !
!HTTPResponse categoriesFor: #addDefaultBody!initialize-release!public! !
!HTTPResponse categoriesFor: #addHeaderName:value:!accessing-headers!public! !
!HTTPResponse categoriesFor: #addInitialHeaders!initialize-release!public! !
!HTTPResponse categoriesFor: #addServerHeader!initialize-release!public! !
!HTTPResponse categoriesFor: #cacheControl:!accessing-headers!public! !
!HTTPResponse categoriesFor: #code!accessing!public! !
!HTTPResponse categoriesFor: #code:!initialize-release!public! !
!HTTPResponse categoriesFor: #codeText!accessing!public! !
!HTTPResponse categoriesFor: #contentLength:!accessing-headers!public! !
!HTTPResponse categoriesFor: #contentSize!accessing!public! !
!HTTPResponse categoriesFor: #contentType!accessing-headers!public! !
!HTTPResponse categoriesFor: #contentType:!accessing-headers!public! !
!HTTPResponse categoriesFor: #cookie:!accessing-headers!public! !
!HTTPResponse categoriesFor: #crlfOn:!private-sending!public! !
!HTTPResponse categoriesFor: #endHeaderOn:!private-sending!public! !
!HTTPResponse categoriesFor: #entity!accessing!public! !
!HTTPResponse categoriesFor: #entity:!accessing!public! !
!HTTPResponse categoriesFor: #expires:!accessing-headers!public! !
!HTTPResponse categoriesFor: #informConnectionClose!private! !
!HTTPResponse categoriesFor: #informConnectionKeepAlive!private! !
!HTTPResponse categoriesFor: #isBadRequest!public!testing! !
!HTTPResponse categoriesFor: #isFound!public!testing! !
!HTTPResponse categoriesFor: #isHttp10!public!testing! !
!HTTPResponse categoriesFor: #isHttp11!public!testing! !
!HTTPResponse categoriesFor: #isInternalServerError!public!testing! !
!HTTPResponse categoriesFor: #isMovedPermanently!public!testing! !
!HTTPResponse categoriesFor: #isNotFound!public!testing! !
!HTTPResponse categoriesFor: #isNotImplemented!public!testing! !
!HTTPResponse categoriesFor: #isNotModified!public!testing! !
!HTTPResponse categoriesFor: #isOk!public!testing! !
!HTTPResponse categoriesFor: #isRedirectLink!public!testing! !
!HTTPResponse categoriesFor: #isSeeOther!public!testing! !
!HTTPResponse categoriesFor: #isStreamed!public!testing! !
!HTTPResponse categoriesFor: #isUnauthorized!public!testing! !
!HTTPResponse categoriesFor: #lastModified:!accessing-headers!public! !
!HTTPResponse categoriesFor: #location:!accessing-headers!public! !
!HTTPResponse categoriesFor: #printChunkedTransferEncodingOn:!private-sending!public! !
!HTTPResponse categoriesFor: #printContentLengthOn:!private-sending!public! !
!HTTPResponse categoriesFor: #printEntityOn:!private-sending!public! !
!HTTPResponse categoriesFor: #printHeadersOn:!private-sending!public! !
!HTTPResponse categoriesFor: #printStatusOn:!private-sending!public! !
!HTTPResponse categoriesFor: #writeHeaderTo:!private-sending!public! !
!HTTPResponse categoriesFor: #writeTo:!public!sending! !
!HTTPResponse categoriesFor: #writeTo:inResponseTo:!public!sending! !

!HTTPResponse class methodsFor!

badRequest
	^super new code: 400!

forbidden
	^super new
		code: 403;
		entity: '<HTML>
<HEAD><TITLE>Forbidden</TITLE></HEAD>
<BODY>
<H1>403 Forbidden</H1>
<P>Access to the requested resource is forbidden.</P>
</BODY></HTML>'!

found
	^super new code: 302!

initialize
	"self initialize"

	StatusCodes := (Dictionary new)
				add: 100 -> 'Continue';
				add: 101 -> 'Switching Protocols';
				add: 200 -> 'OK';
				add: 201 -> 'Created';
				add: 202 -> 'Accepted';
				add: 203 -> 'Non-Authoritative Information';
				add: 204 -> 'No Content';
				add: 205 -> 'Reset Content';
				add: 206 -> 'Partial Content';
				add: 300 -> 'Multiple Choices';
				add: 301 -> 'Moved Permanently';
				add: 302 -> 'Found';
				add: 303 -> 'See Other';
				add: 304 -> 'Not Modified';
				add: 305 -> 'Use Proxy';
				add: 307 -> 'Temporary Redirect';
				add: 400 -> 'Bad Request';
				add: 401 -> 'Unauthorized';
				add: 402 -> 'Payment Required';
				add: 403 -> 'Forbidden';
				add: 404 -> 'Not Found';
				add: 405 -> 'Method Not Allowed';
				add: 406 -> 'Not Acceptable';
				add: 407 -> 'Proxy Authentication Required';
				add: 408 -> 'Request Time-out';
				add: 409 -> 'Conflict';
				add: 410 -> 'Gone';
				add: 411 -> 'Length Required';
				add: 412 -> 'Precondition Failed';
				add: 413 -> 'Request Entity Too Large';
				add: 414 -> 'Request-URI Too Large';
				add: 415 -> 'Unsupported Media Type';
				add: 416 -> 'Requested range not satisfiable';
				add: 417 -> 'Expectation Failed';
				add: 500 -> 'Internal Server Error';
				add: 501 -> 'Not Implemented';
				add: 502 -> 'Bad Gateway';
				add: 503 -> 'Service Unavailable';
				add: 504 -> 'Gateway Time-out';
				add: 505 -> 'HTTP Version not supported';
				yourself.
	self postInitialize.!

internalServerError
	^super new
		code: 500;
		entity: '<HTML>
<HEAD><TITLE>Not Found</TITLE></HEAD>
<BODY>
<H1>500 Internal Server Error</H1>
<P>The server experienced an error while processing this request.  If this problem persists, please contact the webmaster.</P>
</BODY></HTML>'!

internalServerError: debugErrorString
	^super new
		code: 500;
		entity: '<HTML>
<HEAD><TITLE>Not Found</TITLE></HEAD>
<BODY>
<H1>500 Internal Server Error</H1>
<P>', debugErrorString , '</P>
</BODY></HTML>'!

methodNotAllowed
"c.f. RFC 2616  10.4.6
   The method specified in the Request-Line is not allowed for the
   resource identified by the Request-URI. The response MUST include an
   Allow header containing a list of valid methods for the requested
   resource. "
	^super new code: 405!

movedPermanently
	^super new code: 301!

notFound
	^super new
		code: 404;
		entity: '<HTML>
<HEAD><TITLE>Not Found</TITLE></HEAD>
<BODY>
<H1>404 Not Found</H1>
<P>The requested resource was not found on this server.</P>
</BODY></HTML>'!

notImplemented
	^super new code: 501!

notModified
	^super new code: 304!

ok
	^super new code: 200!

postInitialize
	"WebDAV Status Code Extensions, rfc2518 sec10"
	StatusCodes
		add: 102 -> 'Processing';
		add: 207 -> 'Multi-Status';
		add: 422 -> 'Unprocessable Entity';
		add: 423 -> 'Locked';
		add: 424 -> 'Failed Dependency';
		add: 507 -> 'Insufficient Storage'!

redirectLink
	"^an HTTPResponse
Note that 302 is really the 'found' response.  This code should really be 303 (>>seeOther).  However, because many clients take 302 & 303 to be the same and because older clients don't understand 303, 302 is commonly used in this case.  See RFC 2616 10.3.4."

	^super new code: 302!

seeOther
	"^an HTTPResponse
The response to the request can be found under a different URI and SHOULD be retrieved using a GET method on that resource. This method exists primarily to allow the output of a POST-activated script to redirect the user agent to a selected resource.
See RFC 2616 10.3.4."

	^super new code: 303!

statusTextForCode: aNumber
	^StatusCodes at: aNumber ifAbsent: ['']!

unauthorized
	^super new code: 401! !
!HTTPResponse class categoriesFor: #badRequest!public!response types! !
!HTTPResponse class categoriesFor: #forbidden!public!response types! !
!HTTPResponse class categoriesFor: #found!public!response types! !
!HTTPResponse class categoriesFor: #initialize!class initialization!public! !
!HTTPResponse class categoriesFor: #internalServerError!public!response types! !
!HTTPResponse class categoriesFor: #internalServerError:!public! !
!HTTPResponse class categoriesFor: #methodNotAllowed!public!response types! !
!HTTPResponse class categoriesFor: #movedPermanently!public!response types! !
!HTTPResponse class categoriesFor: #notFound!public!response types! !
!HTTPResponse class categoriesFor: #notImplemented!public!response types! !
!HTTPResponse class categoriesFor: #notModified!public!response types! !
!HTTPResponse class categoriesFor: #ok!public!response types! !
!HTTPResponse class categoriesFor: #postInitialize!class initialization!public! !
!HTTPResponse class categoriesFor: #redirectLink!public!response types! !
!HTTPResponse class categoriesFor: #seeOther!public!response types! !
!HTTPResponse class categoriesFor: #statusTextForCode:!accessing!public! !
!HTTPResponse class categoriesFor: #unauthorized!public!response types! !

HTTPDelete guid: (GUID fromString: '{5578E550-D9F8-48D2-A749-797613457548}')!
HTTPDelete comment: '
HTTPDelete 

rfc26216 section 9.7

The DELETE method requests that the origin server delete the resource
   identified by the Request-URI. This method MAY be overridden by human
   intervention (or other means) on the origin server. The client cannot
   be guaranteed that the operation has been carried out, even if the
   status code returned from the origin server indicates that the action
   has been completed successfully. However, the server SHOULD NOT
   indicate success unless, at the time the response is given, it
   intends to delete the resource or move it to an inaccessible
   location.
 ...
'!
!HTTPDelete categoriesForClass!Unclassified! !
!HTTPDelete methodsFor!

isDelete
	^true! !
!HTTPDelete categoriesFor: #isDelete!public!testing! !

!HTTPDelete class methodsFor!

methodName
	"HTTP method used for a request"
	^'DELETE'! !
!HTTPDelete class categoriesFor: #methodName!accessing!public! !

HTTPGet guid: (GUID fromString: '{2E164811-A312-48BC-A133-8C4C9EDB84EC}')!
HTTPGet comment: '
HTTPGet 

rfc26216 section 9.3

   The GET method means retrieve whatever information (in the form of an
   entity) is identified by the Request-URI. If the Request-URI refers
   to a data-producing process, it is the produced data which shall be
   returned as the entity in the response and not the source text of the
   process, unless that text happens to be the output of the process.
'!
!HTTPGet categoriesForClass!Unclassified! !
!HTTPGet methodsFor!

isGet
	^true! !
!HTTPGet categoriesFor: #isGet!public!testing! !

!HTTPGet class methodsFor!

methodName
	^'GET'! !
!HTTPGet class categoriesFor: #methodName!accessing!public! !

HTTPHead guid: (GUID fromString: '{5E16E011-61B5-4777-920A-26FC9D43B40C}')!
HTTPHead comment: '
HTTPHead

rfc26216 section 9.4

   The HEAD method is identical to GET except that the server MUST NOT
   return a message-body in the response. The metainformation contained
   in the HTTP headers in response to a HEAD request SHOULD be identical
   to the information sent in response to a GET request. This method can
   be used for obtaining metainformation about the entity implied by the
   request without transferring the entity-body itself. This method is
   often used for testing hypertext links for validity, accessibility,
   and recent modification.

'!
!HTTPHead categoriesForClass!Unclassified! !
!HTTPHead methodsFor!

isHead
	^true! !
!HTTPHead categoriesFor: #isHead!public!testing! !

!HTTPHead class methodsFor!

methodName
	^'HEAD'! !
!HTTPHead class categoriesFor: #methodName!accessing!public! !

HTTPOptions guid: (GUID fromString: '{90E03BAD-33CC-4C99-902F-1F1F4BF2550E}')!
HTTPOptions comment: '
HTTPOptions

rfc26216 section 9.2

   The OPTIONS method represents a request for information about the
   communication options available on the request/response chain
   identified by the Request-URI. This method allows the client to
   determine the options and/or requirements associated with a resource,
   or the capabilities of a server, without implying a resource action
   or initiating a resource retrieval.

'!
!HTTPOptions categoriesForClass!Unclassified! !
!HTTPOptions methodsFor!

isOptions
	^true!

respondUsing: responseBlock 
	"^an HTTPResponse
I represent a request for the options supported by this server.  I respond with a 200 (OK) and a list of my supported methods in an Allow: header.  I ignore the responseBlock."

	| response allowField |
	response := HTTPResponse ok.
	allowField := HTTPAllowField new.
	allowField methods addAll: self class allMethodNames.
	response headers addField: allowField.
	^response! !
!HTTPOptions categoriesFor: #isOptions!public!testing! !
!HTTPOptions categoriesFor: #respondUsing:!public!services! !

!HTTPOptions class methodsFor!

methodName
	^'OPTIONS'! !
!HTTPOptions class categoriesFor: #methodName!accessing!public! !

HTTPPost guid: (GUID fromString: '{3176E735-CBF7-4D2E-9B53-F782DC700C6A}')!
HTTPPost comment: '
HTTPPost 

rfc26216 section 9.5

   The POST method is used to request that the origin server accept the
   entity enclosed in the request as a new subordinate of the resource
   identified by the Request-URI in the Request-Line.

Instance Variables:
	entityBody	<>	
	postData	<HTTPPostDataArray>	

'!
!HTTPPost categoriesForClass!Unclassified! !
!HTTPPost methodsFor!

applicationOctetStreamFrom: aStream 
	"^self 
rfc 2046 says:
The recommended action for an implementation that receives an 'application/octet-stream' entity is to simply offer to put the data in a file, with any Content-Transfer-Encoding undone, or perhaps to use it as input to a user-specified process.
This method used to do a crlf -> cr conversion on the octet-stream, but was not clear why."

	self entityBody: (HTTPString 
				stringFromBytes: (aStream nextBytes: self contentLength)).
	^self!

blockStreamingFrom: aSwazooStream to: outStream until: aBoundaryBytes "detected"
	"copy by 8k blocks for optimal performance until a boundary of MIME part is detected"
	"Finish appropriatelly streaming at the end (skip crlf etc.)"
	| boundary start nrOfBoundary contents inPrevious remainingBoundary boundaryIndex |
	boundary := aSwazooStream readBuffer isBinary 
		ifTrue: [aBoundaryBytes asByteArray] ifFalse: [aBoundaryBytes asByteString].
	start := self readPosition.
	[true] whileTrue:
		[nrOfBoundary := 0.
		[nrOfBoundary = 0] whileTrue:
			[nrOfBoundary := aSwazooStream readBuffer signsOfBoundary: boundary.
			nrOfBoundary = 0 ifTrue: "no boundary in current buffer content"
				[contents := aSwazooStream readBuffer readContents.
				outStream nextPutAll: contents. 
				self incReadPosition: contents size.
				self checkToEnlargeBufferIn: aSwazooStream from: start. "for effective streaming"
				aSwazooStream fillBuffer] ].
		"copy and stream out content up to potential boundary"
		boundaryIndex := aSwazooStream readBuffer indexOfBoundary: boundary.
		inPrevious := aSwazooStream readBuffer copyBufferTo: boundaryIndex-1.
		outStream nextPutAll: 
			(inPrevious copyFrom: 1 to: (inPrevious size-2 max: 0) "without potential crlf"). 
		self incReadPosition: inPrevious size. "potential crlf included!!"

		nrOfBoundary = boundary size ifTrue: "full boundary detected, lets finish here"
			[aSwazooStream skip: boundary size. "skip boundary"
			self incReadPosition: boundary size.
			^true].  "streaming complete"

		self incReadPosition: nrOfBoundary.
		aSwazooStream fillBuffer. "let's get next buffer"
		remainingBoundary := boundary copyFrom: nrOfBoundary+1 to: boundary size.
		(aSwazooStream readBuffer startsWith:  remainingBoundary) ifTrue: "bound. ends in next buff?"
			[aSwazooStream skip: remainingBoundary size + 2.  "skip remaining bound. and crlf"
			self incReadPosition: remainingBoundary size + 2.
			^true]. "streaming complete"

		outStream 
			nextPutAll: (inPrevious copyFrom: inPrevious size-2 to: inPrevious size);  "potential crlf"
			nextPutAll: (boundary copyFrom: 1 to: nrOfBoundary).  "boundary part in prev.buff."
		] "continue from the start"!

checkToEnlargeBufferIn: aSwazooStream from: startPosition
	"enlarge buffer to 1MB (if not already) if more than 100KB already read"
	aSwazooStream readBuffer isEnlarged ifTrue: [^nil].
	(self readPosition - startPosition) > 100000 "about 100KB" 
		ifTrue: [aSwazooStream readBuffer resizeEnlarge].!

containsHeaderNecessaryFields
	"content type and (content length or chunked transfer encoding)"
	(self headers includesFieldOfClass: ContentTypeField) ifFalse: [^false].
	(self headers includesFieldOfClass: HTTPContentLengthField) ifTrue: [^true].
	^(self headers fieldNamed: 'Transfer-encoding' ifNone: [^false]) value = 'chunked'!

emptyData
	self ensureFullRead.
	^self postData select: [:each | each value isEmpty]!

ensureFullRead
	"that is, everything is read from a socket stream. Important because of defered parsing
	of postData"
	self postData isParsed ifFalse: 
		[self parsePostDataFrom: self postData stream.
		self postData setParsed]!

entityBody
	^entityBody!

entityBody: aString
	entityBody := aString!

for: aRequestLine readFrom: aSwazooStream 
	super for: aRequestLine readFrom: aSwazooStream.
	self initPostDataFor: aSwazooStream.
"	self parsePostDataFrom: aSwazooStream." "defered until first access of postData!! "!

incReadPosition
	self readPosition: self readPosition + 1!

incReadPosition: anInteger
	self readPosition: self readPosition + anInteger!

initPostDataFor: aSwazooStream
	postData := HTTPPostDataArray newOn: aSwazooStream!

isPost
	^true!

isPostDataEmpty
	self ensureFullRead.
	^self postData isEmpty!

isPostDataStreamedAt: aKey
	^(self postData at: aKey ifAbsent: [^false]) isStreamed!

multipartDataFrom: aSwazooStream
	"read all mime parts and put them in postData" 
	"read directly from stream, without intermediate buffers"
	| contentTypeField boundary part |
	contentTypeField := self headers fieldOfClass: ContentTypeField
				ifNone: [^aSwazooStream nextBytes: self contentLength]. "just skip"
	boundary := contentTypeField transferCodings at: 'boundary'
				ifAbsent: [^aSwazooStream nextBytes: self contentLength]. "just skip"
	self skipMimePreambleAndBoundary: boundary from: aSwazooStream. 
	part := #something. 
	[part notNil] whileTrue: 
		[part := self partFromStream: aSwazooStream boundary: boundary.
		part notNil ifTrue: [self postDataAt: part key put: part value]].
	self skipMimeEpilogueFrom: aSwazooStream. "all to the end  as defined by contentLegth"
	aSwazooStream readBuffer isEnlarged  "if MIME part larger that 100KB was read"
		ifTrue: [aSwazooStream readBuffer resizeShrink]. "that is, release memory"!

parsePostDataFrom: aSwazooStream 
	| mediaType |
	self containsHeaderNecessaryFields ifFalse: 
		[^SwazooHTTPPostError raiseSignal: 'Content-Type and Content-Length or chunked needed'].
	mediaType := (self headers fieldOfClass: ContentTypeField) mediaType.
	mediaType = 'application/x-www-form-urlencoded' 
		ifTrue: [^self urlencodedDataFrom: aSwazooStream].
	mediaType = 'multipart/form-data' 
		ifTrue: [^self multipartDataFrom: aSwazooStream].
	^self applicationOctetStreamFrom: aSwazooStream.!

partFromStream: aSwazooStream boundary: aBoundaryBytes
	"one mime part from a stream. Nil if no more multipart data"
	"Squeak specific"
	| bytes name filename datum contentType |
	bytes := aSwazooStream nextBytes: 2. self incReadPosition: 2.
	bytes = '--' asByteArray  ifTrue: [^nil].    "end of multipart data"
		
	name := nil. datum := nil. contentType := nil. "just to avoid compilation warning"
	[true] whileTrue: [| line |  "read all lines and at the end a body of that part"
		line := [(aSwazooStream upTo: Character cr asInteger) asString] "Squeak specific"
			on: Error do: [:ex | ''].  "usually nothing to read anymore), why happen this anyway?"
		self readPosition: self readPosition + line size + 1 "cr".
		line := bytes asString, line. bytes := ''.
		aSwazooStream peekByte = Character lf asInteger ifTrue: [| field | "this is a name line"
			aSwazooStream nextByte.  self incReadPosition. "skip linefeed"
			line isEmpty 	ifTrue: [| | "empty line indicates start of entity"
				name isNil ifTrue: [^nil].  "name must be read in previous circle"
				datum contentType: contentType. "completes datum's contentType read in a prev step"
 				^name -> (self readEntityFrom: aSwazooStream 
					datum: datum boundary: aBoundaryBytes)].
			field := HeaderField fromLine: line.
			field isContentDisposition ifTrue: 
					[name := (field parameterAt: 'name') copyWithout: $". 
					datum := (self isPostDataStreamedAt: name)
						ifTrue: [self postData at: name]  "streamed datum must exist before"
						ifFalse: [HTTPPostDatum new].
					contentType notNil ifTrue: [datum contentType: contentType]. "if read in prev.circle"
					filename := field parameterAt: 'filename' .   "only for file uploads"
					filename notNil ifTrue: [datum filename: (filename copyWithout: $")] ].
			field isContentType ifTrue: [contentType := field mediaType ] ] ]!

postData
	^postData!

postDataAt: aKey 
	^self postDataAt: aKey ifAbsent: [nil]!

postDataAt: aKey beforeStreamingDo: aBlockClosure
	"announce that you want to receive post data directly to a binary stream, which will be set
	by aBlockClosure. That block must receive and argument, which is a HTTPostDatum and 
	here it can set a writeStream"
	"Fails if post data is already read"
	self postData isParsed 
		ifTrue: [^self error: 'HTTPost already parsed, streaming not possible anymore!!'].
	^self postDataAt: aKey put: (HTTPPostDatum new writeBlock: aBlockClosure)!

postDataAt: aKey do: aBlock 
	| val |
	self ensureFullRead. "defered parsing of postData"
	val := self postData at: aKey ifAbsent: [nil].
	val isNil ifFalse: [aBlock value: val]!

postDataAt: aKey ifAbsent: aBlock 
	self ensureFullRead. "defered parsing of postData"
	^self postData at: aKey ifAbsent: aBlock!

postDataAt: aKey put: aPostDatum 
	"for testing purposes"

	self postData at: aKey put: aPostDatum!

postDataAt: aKey putString: aString 
	"for testing purposes"

	self postDataAt: aKey put: (HTTPPostDatum new value: aString)!

postDataAt: aKey streamTo: aWriteStream
	"announce that you want to receive post data directly to aWriteStream, 
	which must be binary. Fails if post data is already read"
	self postData isParsed 
		ifTrue: [^self error: 'HTTPost already parsed, streaming not possible anymore!!'].
	^self postDataAt: aKey put: (HTTPPostDatum new writeStream: aWriteStream)!

postDataKeys
	self ensureFullRead. "defered parsing of postData"
	^self postData keys!

postDataStringAt: aKey 
	^(self postDataAt: aKey ifAbsent: [^nil]) value!

postKeysAndValuesDo: aTwoArgBlock 
	self ensureFullRead. "defered parsing of postData"
	self postData 
		keysAndValuesDo: [:key :each | aTwoArgBlock value: key value: each value]!

readEntityFrom: aSwazooStream datum: aDatum boundary: aBoundaryBytes
	"read one entity from a stream and put into datum. Stream it if streamed. Also call a block 
	(if any) just before start of streaming, with a datum as parameter. This block can then set 
	a write stream in datum (for instance open a output file and stream on it)"
	| outStream |
	aDatum writeBlock notNil 
		ifTrue: [aDatum writeBlock value: aDatum]. "this should set writeStream if not already!!" 
	outStream := (aDatum isStreamed and: [aDatum writeStream notNil])
		ifTrue: [aDatum writeStream] ifFalse: [WriteStream on: ByteArray new].
	self blockStreamingFrom: aSwazooStream to: outStream until: ('--', aBoundaryBytes). "efficient streaming"
	aDatum isStreamed not ifTrue: "otherwise entity is already streamed to the output"
		[aDatum value: outStream contents asString].
	^aDatum!

readPosition
	"position in a read stream. just temporary"
	readPosition isNil ifTrue: [^1].
	^readPosition!

readPosition: aNumber
	readPosition := aNumber!

skipMimeEpilogueFrom: aSwazooStream
	"skip a mime epilogue until end of post data defined by contentLength"
	"example:
		--boundary--
		This is the epilogue.  It is also to be ignored
	"
	[self readPosition < self contentLength] whileTrue: 
		[aSwazooStream next. "just skip"
		self incReadPosition].!

skipMimePreambleAndBoundary: aBoundaryBytes from: aSwazooStream
	"skip a mime preamble until first boundary starts then skip that boundary too"
	"example:
		Content-type: multipart/mixed; boundary=''boundary''

		This is the preamble.  It is to be ignored, though it is
		a handy place to include an explanatory note to non-MIME compliant readers.
		--boundary
		..."
	| dummy |
	dummy := WriteStream on: ByteArray new.
	self blockStreamingFrom: aSwazooStream to: dummy until: ('--', aBoundaryBytes)!

urlencodedDataFrom: aStream 
	| entity tokens |
	(self headers includesFieldOfClass: HTTPContentLengthField) ifFalse: [^self].
	entity := aStream nextBytes: self contentLength.
	tokens := HTTPString subCollectionsFrom: (HTTPString stringFromBytes: entity) delimitedBy: $&.
	(tokens collect: [:each | HTTPString subCollectionsFrom: each delimitedBy: $=]) 
		do: 	[:keyVal | | datum key |
			datum := HTTPPostDatum new.
			datum value: (HTTPString decodedHTTPFrom: 
 				(keyVal last collect: [:char | 
					char = $+ ifTrue: [Character space] ifFalse: [char]])).
			key := (HTTPString decodedHTTPFrom: 
 				(keyVal first collect: [:char | 
					char = $+ ifTrue: [Character space] ifFalse: [char]])).
			self postDataAt: key put: datum]! !
!HTTPPost categoriesFor: #applicationOctetStreamFrom:!private! !
!HTTPPost categoriesFor: #blockStreamingFrom:to:until:!private-parsing support!public! !
!HTTPPost categoriesFor: #checkToEnlargeBufferIn:from:!private-parsing support!public! !
!HTTPPost categoriesFor: #containsHeaderNecessaryFields!private-parsing support!public! !
!HTTPPost categoriesFor: #emptyData!accessing!public! !
!HTTPPost categoriesFor: #ensureFullRead!parsing!public! !
!HTTPPost categoriesFor: #entityBody!accessing!public! !
!HTTPPost categoriesFor: #entityBody:!private! !
!HTTPPost categoriesFor: #for:readFrom:!parsing!public! !
!HTTPPost categoriesFor: #incReadPosition!private! !
!HTTPPost categoriesFor: #incReadPosition:!private! !
!HTTPPost categoriesFor: #initPostDataFor:!initialize-release!public! !
!HTTPPost categoriesFor: #isPost!public!testing! !
!HTTPPost categoriesFor: #isPostDataEmpty!public!testing! !
!HTTPPost categoriesFor: #isPostDataStreamedAt:!public!testing! !
!HTTPPost categoriesFor: #multipartDataFrom:!private-parsing!public! !
!HTTPPost categoriesFor: #parsePostDataFrom:!parsing!public! !
!HTTPPost categoriesFor: #partFromStream:boundary:!private-parsing!public! !
!HTTPPost categoriesFor: #postData!private! !
!HTTPPost categoriesFor: #postDataAt:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:beforeStreamingDo:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:do:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:ifAbsent:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:put:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:putString:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:streamTo:!accessing!public! !
!HTTPPost categoriesFor: #postDataKeys!accessing!public! !
!HTTPPost categoriesFor: #postDataStringAt:!accessing!public! !
!HTTPPost categoriesFor: #postKeysAndValuesDo:!accessing!public! !
!HTTPPost categoriesFor: #readEntityFrom:datum:boundary:!private-parsing!public! !
!HTTPPost categoriesFor: #readPosition!private! !
!HTTPPost categoriesFor: #readPosition:!private! !
!HTTPPost categoriesFor: #skipMimeEpilogueFrom:!private-parsing support!public! !
!HTTPPost categoriesFor: #skipMimePreambleAndBoundary:from:!private-parsing support!public! !
!HTTPPost categoriesFor: #urlencodedDataFrom:!private-parsing!public! !

!HTTPPost class methodsFor!

methodName
	^'POST'! !
!HTTPPost class categoriesFor: #methodName!accessing!public! !

HTTPPut guid: (GUID fromString: '{1A5378BB-5DE7-43A3-B1F0-37B24DE14E40}')!
HTTPPut comment: '
HTTPPut 

rfc26216 section 9.6

   The PUT method requests that the enclosed entity be stored under the
   supplied Request-URI. If the Request-URI refers to an already
   existing resource, the enclosed entity SHOULD be considered as a
   modified version of the one residing on the origin server. If the
   Request-URI does not point to an existing resource, and that URI is
   capable of being defined as a new resource by the requesting user
   agent, the origin server can create the resource with that URI. If a
   new resource is created, the origin server MUST inform the user agent
   via the 201 (Created) response. If an existing resource is modified,
   either the 200 (OK) or 204 (No Content) response codes SHOULD be sent
   to indicate successful completion of the request. If the resource
   could not be created or modified with the Request-URI, an appropriate
   error response SHOULD be given that reflects the nature of the
   problem. The recipient of the entity MUST NOT ignore any Content-*
   (e.g. Content-Range) headers that it does not understand or implement
   and MUST return a 501 (Not Implemented) response in such cases.

Instance Variables:
	putData	<>	

'!
!HTTPPut categoriesForClass!Unclassified! !
!HTTPPut methodsFor!

isPut
	^true!

octetDataFrom: aStream 
	self headers fieldOfClass: HTTPContentLengthField
		ifNone: [^SwazooHTTPPutError raiseSignal: 'Missing Content-Length'].
	self putData: (aStream nextBytes: self contentLength)!

putData
	^putData!

putData: aString
	putData := aString!

readFrom: aStream 
	| contentTypeField |
	super readFrom: aStream.
	contentTypeField := self headers fieldOfClass: ContentTypeField
				ifNone: [SwazooHTTPPutError raiseSignal: 'Missing Content-Type'].
	contentTypeField mediaType = 'application/octet-stream' 
		ifTrue: [self octetDataFrom: aStream]
		ifFalse: [self urlencodedDataFrom: aStream].
	^self! !
!HTTPPut categoriesFor: #isPut!public!testing! !
!HTTPPut categoriesFor: #octetDataFrom:!public!reading! !
!HTTPPut categoriesFor: #putData!accessing!public! !
!HTTPPut categoriesFor: #putData:!private! !
!HTTPPut categoriesFor: #readFrom:!public!reading! !

!HTTPPut class methodsFor!

methodName
	^'PUT'! !
!HTTPPut class categoriesFor: #methodName!accessing!public! !

HTTPTrace guid: (GUID fromString: '{40E1FB48-EC2D-4D5A-B264-1CFECF1D5FFA}')!
HTTPTrace comment: '
HTTPTrace 

rfc26216 section 9.8

   The TRACE method is used to invoke a remote, application-layer loop-
   back of the request message. The final recipient of the request
   SHOULD reflect the message received back to the client as the
   entity-body of a 200 (OK) response
'!
!HTTPTrace categoriesForClass!Unclassified! !
!HTTPTrace methodsFor!

isTrace
	^true! !
!HTTPTrace categoriesFor: #isTrace!public!testing! !

!HTTPTrace class methodsFor!

methodName
	^'TRACE'! !
!HTTPTrace class categoriesFor: #methodName!accessing!public! !

FileResponse guid: (GUID fromString: '{3710579F-6786-4EC1-A81B-63D9E0BFE34D}')!
FileResponse comment: ''!
!FileResponse categoriesForClass!Unclassified! !
!FileResponse methodsFor!

contentType
	^self entity contentType!

entity: aMimeObject 
	entity := aMimeObject!

printContentLengthOn: aStream 
	self entity isNil 
		ifFalse: 
			[aStream
				nextPutAll: 'Content-Length: ';
				print: self entity value fileSize.
			self crlfOn: aStream]!

printEntityOn: aStream 
	| rs |
	self entity isNil 
		ifFalse: 
			[rs := self entity value readStream.
			rs lineEndTransparent.
			SpExceptionContext 
				for: 
					[[[rs atEnd] whileFalse: [aStream nextPutAll: (rs nextAvailable: 2000)]] 
						ensure: [rs close]]
				on: SpError
				do: [:ex | ex return]]!

printHeadersOn: aStream 
	self contentType: self entity contentType.
	super printHeadersOn: aStream! !
!FileResponse categoriesFor: #contentType!accessing-headers!public! !
!FileResponse categoriesFor: #entity:!accessing!public! !
!FileResponse categoriesFor: #printContentLengthOn:!private-printing!public! !
!FileResponse categoriesFor: #printEntityOn:!private-printing!public! !
!FileResponse categoriesFor: #printHeadersOn:!private-printing!public! !

HTTPStreamedResponse guid: (GUID fromString: '{C1683582-B619-4465-AC95-178B39628A1C}')!
HTTPStreamedResponse comment: '
HTTPStreamedResponse 

HTTP/1.1 	no length   	chunked
HTTP/1.1	length		streamed directly, with contentLength
HTTP/1.0	no length   	simulated streaming: into entity first, then sent as normal response (not yet impl.)
HTTP/1.0  	length 		streamed directly, with content length

Instance Variables:
	stream		<SwazooStream> where to stream a response
	count		<Integer> 		how many bytes already streamed
	length		<Integer>		announced length of response, optional
	state		<Symbol>		#header #streaming #closed			
	semaphore	<Semaphore>	to signal end of response

'!
!HTTPStreamedResponse categoriesForClass!Unclassified! !
!HTTPStreamedResponse methodsFor!

close
	"mandatory!! It signals that streaming is finished and response can end"
	self testForUnderflow. "if streamed but not chunked: all data sent?"
	self stream closeResponse.
	self setClosed.
	self stream: nil. "to avoid unintential writing"
	self semaphore signal. "to signal close to all waiting processes"!

contentSize
	self length notNil ifTrue: [^self length].
	self entity notNil ifTrue: [self entity size].
	^nil!

count
	"how many bytes already streamed"
	count isNil ifTrue: [self count: 0].
	^count!

count: aNumber
	count := aNumber!

flush
	"force sending to a TCP socket"
	self stream flush!

initialize
	self setHeader!

initSemaphore
	semaphore := Semaphore new!

isClosed
	"is response closed?. No streaming or anything else possible anymore"
	^state = #closed!

isHeader
	"is response in header state?. this is initial one"
	^state = #header!

isStreamed
	^true!

isStreaming
	"is response in streaming state? All nextPut to stream is sent in chunked format to browser"
	^state = #streaming!

length
	"how many bytes response is expected to have. 
	This is optional, if set before streaming begin, then we stream without chunking (and 
	therefore we can stream on HTTP 1.0 !!)"
	^length!

length: aNumber
	length := aNumber!

nextPut: aCharacterOrByte
	self isHeader ifTrue: [self sendHeaderAndStartStreaming].
	self count: self count + 1.
	self testForOverflow.
	^self stream nextPut: aCharacterOrByte!

nextPutAll: aByteStringOrArray
	self isHeader ifTrue: [self sendHeaderAndStartStreaming].
	self count: self count + aByteStringOrArray size.
	self testForOverflow.
	^self stream nextPutAll: aByteStringOrArray!

semaphore
	"semahore to signal end of streaming = all data sent"
	semaphore isNil ifTrue: [self initSemaphore].
	^semaphore!

sendHeaderAndStartStreaming
	self shouldSimulateStreaming 
		ifTrue: [self error: 'simulated streaming not yet implemented!!'].
	self writeHeaderTo: self stream.
	self stream flush. "to push sending of header immediately"
	self shouldBeChunked ifTrue: [self stream setChunked]. 
	self setStreaming.!

setClosed
	"response is closed. No streaming or anything else possible anymore"
	state := #closed!

setHeader
	"response in header state. this is initial one"
	state := #header!

setStreaming
	"response in streaming state. All nextPut to stream is sent in chunked format to browser"
	state := #streaming!

shouldBeChunked
	^self isHttp11 and: [self length isNil]!

shouldSimulateStreaming
	"stream to entity first then send all at once (because only now we 
	know the length of response)"
	^self isHttp10 and: [self length isNil]!

stream
	^stream!

stream: aSwazooStream
	stream := aSwazooStream!

testForOverflow
	"if streaming but not chunking, then count must never be larger than announced length"
	(self length notNil and: [self count > self length]) 
		ifTrue: [self error: 'streaming overflow']!

testForUnderflow
	"if streaming but not chunking, then count must be exactly the announced 
	length at the end"
	(self length notNil and: [self count ~= self length]) 
		ifTrue: [self error: 'not enough data streamed ']!

waitClose
	"wait until all data is sent-streamed out and response is closed"
	^self semaphore wait! !
!HTTPStreamedResponse categoriesFor: #close!initialize-release!public! !
!HTTPStreamedResponse categoriesFor: #contentSize!accessing!public! !
!HTTPStreamedResponse categoriesFor: #count!accessing!public! !
!HTTPStreamedResponse categoriesFor: #count:!private! !
!HTTPStreamedResponse categoriesFor: #flush!accessing-stream!public! !
!HTTPStreamedResponse categoriesFor: #initialize!initialize-release!public! !
!HTTPStreamedResponse categoriesFor: #initSemaphore!initialize-release!public! !
!HTTPStreamedResponse categoriesFor: #isClosed!private-state!public! !
!HTTPStreamedResponse categoriesFor: #isHeader!private-state!public! !
!HTTPStreamedResponse categoriesFor: #isStreamed!public!testing! !
!HTTPStreamedResponse categoriesFor: #isStreaming!private-state!public! !
!HTTPStreamedResponse categoriesFor: #length!accessing!public! !
!HTTPStreamedResponse categoriesFor: #length:!accessing!public! !
!HTTPStreamedResponse categoriesFor: #nextPut:!accessing-stream!public! !
!HTTPStreamedResponse categoriesFor: #nextPutAll:!accessing-stream!public! !
!HTTPStreamedResponse categoriesFor: #semaphore!private! !
!HTTPStreamedResponse categoriesFor: #sendHeaderAndStartStreaming!private! !
!HTTPStreamedResponse categoriesFor: #setClosed!private-state!public! !
!HTTPStreamedResponse categoriesFor: #setHeader!private-state!public! !
!HTTPStreamedResponse categoriesFor: #setStreaming!private-state!public! !
!HTTPStreamedResponse categoriesFor: #shouldBeChunked!public!testing! !
!HTTPStreamedResponse categoriesFor: #shouldSimulateStreaming!public!testing! !
!HTTPStreamedResponse categoriesFor: #stream!private! !
!HTTPStreamedResponse categoriesFor: #stream:!private! !
!HTTPStreamedResponse categoriesFor: #testForOverflow!private! !
!HTTPStreamedResponse categoriesFor: #testForUnderflow!private! !
!HTTPStreamedResponse categoriesFor: #waitClose!public!waiting! !

!HTTPStreamedResponse class methodsFor!

on: aSwazooTask stream: aSwazooStream
	^super ok
		task: aSwazooTask;
		stream: aSwazooStream;
		initialize! !
!HTTPStreamedResponse class categoriesFor: #on:stream:!instance creation!public! !

HTTPPostDatum guid: (GUID fromString: '{96DF92C7-D314-4C06-BC67-B0ABAEA9182D}')!
HTTPPostDatum comment: ''!
!HTTPPostDatum categoriesForClass!Unclassified! !
!HTTPPostDatum methodsFor!

defaultContentType
	^'text/plain'!

filename
	^filename!

filename: aString
	filename := aString!

filenameWithoutPath
	"M$ Internet Explorer includes full path in filename of uploaded file!! "
	self filename isNil ifTrue: [^nil].
	^(self filename includes: $\ ) 
		ifTrue: [self filename copyFrom: (self filename lastIndexOf: $\ )+1 to: self filename size]
		ifFalse: [self filename]!

isStreamed
	"this postDatum is streamed - it has an output stream to receive data into or a block 
	which will set it"
	^self writeStream notNil or: [self writeBlock notNil]!

writeBlock
	^writeBlock!

writeBlock: aBlockClosure
	"this block will be called just before start of streaming to writeStream. It can be used to 
	open the writeStream, because on that time we already know the filename of uploaded file. 
	As a parameter this postDatum is sent"
	writeBlock := aBlockClosure!

writeStream
	^writeStream!

writeStream: aWriteStream
	"a binary stream where to put directly a post data"
	writeStream := aWriteStream! !
!HTTPPostDatum categoriesFor: #defaultContentType!private-accessing!public! !
!HTTPPostDatum categoriesFor: #filename!accessing!public! !
!HTTPPostDatum categoriesFor: #filename:!accessing!public! !
!HTTPPostDatum categoriesFor: #filenameWithoutPath!accessing!public! !
!HTTPPostDatum categoriesFor: #isStreamed!public!testing! !
!HTTPPostDatum categoriesFor: #writeBlock!accessing!public! !
!HTTPPostDatum categoriesFor: #writeBlock:!accessing!public! !
!HTTPPostDatum categoriesFor: #writeStream!accessing!public! !
!HTTPPostDatum categoriesFor: #writeStream:!accessing!public! !

SwazooBuffer guid: (GUID fromString: '{3AA46E7C-00B7-4223-B26D-B065BD581AB9}')!
SwazooBuffer comment: '
SwazooBuffer is used for efficient buffering of receiving or sending data to TCP socket. Efficiency is achieved with reusing of stream content array instead of initializing it everytime buffer is emptied, as was in previous Swazoo versions. 

SwazooBuffer is a subclass of ReadWriteStream, with additional #clear to empty buffer.

'!
!SwazooBuffer categoriesForClass!Unclassified! !
!SwazooBuffer methodsFor!

atEnd
	^super atEnd "for now"!

closeChunkTo: aSocket
	"a zero sized chunk determine and end of chunked data and also response"
	"pack all together to send one TCP packet ony"
	| chunk written |
	chunk := String new: 5.
	chunk at: 1 put: $0 .
	chunk at: 2 put: Character cr. "first crlf ends 0 length line "
	chunk at: 3 put: Character lf.
	chunk at: 4 put: Character cr. "second crlf ends whole response"
	chunk at: 5 put: Character lf.
	written := aSocket writeFrom: chunk asByteArray startingAt: 1 for: chunk size.
	written = chunk size ifFalse: [self error: 'socket write error'].!

contents
	"Answer a copy of the receiver's collection, skipping preamble."
	readLimit := readLimit max: position.
	^collection copyFrom: self class preambleSize+1 to: readLimit!

copyBufferTo: anIndex
	"from current position to desired index"
	| start |
	start := position+1.
	position := anIndex.
	^collection copyFrom: start to: anIndex.!

flushChunkTo: aSocket
	"a buffer will be sent as a chunk, with hex size in first line then crlf, buffer, then crlf"
	"send a complete chunk in one piece, don't partition TCP sending in too many packets!!"
	| length |
	 self size > 16rFFFF ifTrue: [self error: 'chunk too long!!']. "preamble has no room for bigger"
	length := self size printStringRadix: 16.
	SpEnvironment isSqueak ifTrue: [length := length copyFrom: 4 to: length size]. "trim 16r"
	1 to: length size do: [:inx | collection at: inx put: (length at: inx) asInteger].
	 (length size+1) to: 4 do: [:inx | collection at: inx put: $ asInteger]. "add spaces"
	collection at: 5 put: Character cr asInteger.
	collection at: 6 put: Character lf asInteger.
	"add finishing crlf to buffer"
	self nextPut: Character cr asInteger.
	self nextPut: Character lf asInteger.
	self flushTo: aSocket chunked: true. "flush all at once"!

flushTo: aSocket
	"actually write to the tcp socket as direclty as possible"
	self flushTo: aSocket chunked: false.
!

flushTo: aSocket chunked: chunkedBoolean
	"actually write to the tcp socket as direclty as possible 
	(directly from stream's instvar collection)"
	| remaining start written |
	remaining := chunkedBoolean 
		ifTrue: [position]  "ensure to send preamble too"
		ifFalse: [position - self class preambleSize]. "skip preamble"
	[remaining > 0] whileTrue: 
		[start := position - remaining + 1.
		written := aSocket 
			writeFrom: collection startingAt: start for: (position - start + 1).
		remaining := remaining - written].
	self writeClear.
	self shouldResize ifTrue: [self resizeBuffer; resizeNil]. "enlarge or shrink buffer if requested"!

indexOfBoundary: aBoundaryBytes
	"index of boundary start, beeing full boundary or part at the end of buffer. 0 if not found"
	| inx innerInx firstInx |
	inx := position+1.
	[inx <= readLimit] whileTrue:
		[innerInx := 1. firstInx := inx.
		[(aBoundaryBytes at: innerInx) = (collection at: inx)] whileTrue:
			[innerInx = aBoundaryBytes size ifTrue: [^firstInx]. "full boundary found"
			inx = readLimit ifTrue: [^firstInx].  "partial boundary at the edge of buffer found"
			inx := inx + 1. innerInx := innerInx + 1].
		inx := inx + 1].
	^0!

initDefaultBuffer
	"Squeak specific - writeLimit"
	| size |
	size := self isWrite
		ifTrue: [self class defaultBufferSize + self class preambleSize + 2] "possible chunk crlf"
		ifFalse: [self class defaultBufferSize].
	collection := ByteArray new: size.
	writeLimit := size. "Squeak specific"
	self reset.
	self isWrite ifTrue: [self initPreamble].!

initLargeBuffer
	"Squeak specific - writeLimit"
	| size |
	size := self isWrite
		ifTrue: [self class largeBufferSize + self class preambleSize + 2] "possible chunk crlf"
		ifFalse: [self class largeBufferSize].
	collection := ByteArray new: size.
	writeLimit := size. "Squeak specific"
	self reset.
	self isWrite ifTrue: [self initPreamble].!

initPreamble
	"make room for possible chunk 'preamble' = length line"
	position := self class preambleSize.
!

isBinary
	^collection class == ByteArray!

isEnlarged
	^collection size > self class defaultBufferSize!

isFull
	"buffer full or even more"
	^position >= self class defaultBufferSize!

isRead
	^type = #read!

isWrite
	^type = #write!

readClear
	"reset as you'd make another one, just don't replace content array"
	position := 0.
	readLimit := self class defaultBufferSize.!

readContents
	^(position = 0 and: [readLimit = self class defaultBufferSize]) "whole buffer?"
		ifTrue: [collection] "avoid copying for performance"
		ifFalse: [collection copyFrom: position+1 to: readLimit]!

refillFrom: aSocket
	"reset and read from to the tcp socket as direclty as possible 
	(directly from stream's instvar collection)"
	aSocket isNil ifTrue: [^self]. "if SwazooStream is used for tests only"
	self readClear. "just reset pointers, not a collection!! "
	self shouldResize ifTrue: [self resizeBuffer; resizeNil]. "enlarge or shrink buffer if requested"
	readLimit "nr. of actuall bytes read ":= aSocket
		readInto: collection startingAt: 1 for: collection size.
	self atEnd ifTrue: 
		[SwazooStreamNoDataError raiseSignal: 'No data available.  Socket probably closed']!

resizeBuffer
	"actually do a buffer resize"
	self shouldEnlarge ifTrue: [^self initLargeBuffer].
	self shouldShrink ifTrue: [^self initDefaultBuffer].!

resizeEnlarge
	"request resizing buffer to larger size at the next fill or flush"
	resize := #enlarge!

resizeNil
	"nil resizing command"
	resize := nil!

resizeShrink
	"request shrinking buffer to default size at the next fill or flush"
	resize := #shrink!

setRead
	type := #read!

setWrite
	type := #write!

shouldEnlarge
	"should be resized buffer to larger size?"
	^resize = #enlarge!

shouldResize
	^resize notNil!

shouldShrink
	"should be resized buffer to default size?"
	^resize = #shrink!

signsOfBoundary: aBoundaryBytes
	"detect as fast as possible if any if not all MIME part boundary is present in buffer contents"
	"return number of bundary bytes detected, 0 = no boundary"
	| first index |
	first := aBoundaryBytes first.
	"fast test"
	((self position+1 to: readLimit) contains: [:inx | (collection at: inx) = first]) ifFalse: [^0].
	"full or partial boundary on the edge of buffer test"
	index := self indexOfBoundary: aBoundaryBytes. "index of full, or partial boundary at the edge"
	index = 0 ifTrue: [^0]. "no boundary found"
	readLimit-index >= aBoundaryBytes size ifTrue: [^aBoundaryBytes size]. "full boundary detected"
	^readLimit-index+1  "partial boundary at the end of buffer"!

size
	^position - self class preambleSize!

startsWith: aPartialBoundaryBytes
	"is remaining part of MIME part boundary at the start of buffer?"
	"VW specific!! "
	1 to: aPartialBoundaryBytes size do: [:inx |
		(collection at: position + inx) = (aPartialBoundaryBytes at: inx) ifFalse: [^false] ].
	^true!

writeClear
	"reset as you'd make another one, just don't replace content array"
	self reset.
	readLimit := 0.
	self initPreamble.! !
!SwazooBuffer categoriesFor: #atEnd!public!testing! !
!SwazooBuffer categoriesFor: #closeChunkTo:!public!writing-chunked! !
!SwazooBuffer categoriesFor: #contents!accessing!public! !
!SwazooBuffer categoriesFor: #copyBufferTo:!mime boundary!public! !
!SwazooBuffer categoriesFor: #flushChunkTo:!public!writing-chunked! !
!SwazooBuffer categoriesFor: #flushTo:!public!writing! !
!SwazooBuffer categoriesFor: #flushTo:chunked:!private-sending!public! !
!SwazooBuffer categoriesFor: #indexOfBoundary:!mime boundary!public! !
!SwazooBuffer categoriesFor: #initDefaultBuffer!initialize-release!public! !
!SwazooBuffer categoriesFor: #initLargeBuffer!initialize-release!public! !
!SwazooBuffer categoriesFor: #initPreamble!initialize-release!public! !
!SwazooBuffer categoriesFor: #isBinary!public!testing! !
!SwazooBuffer categoriesFor: #isEnlarged!private-resizing!public! !
!SwazooBuffer categoriesFor: #isFull!public!testing! !
!SwazooBuffer categoriesFor: #isRead!public!testing! !
!SwazooBuffer categoriesFor: #isWrite!public!testing! !
!SwazooBuffer categoriesFor: #readClear!initialize-release!public! !
!SwazooBuffer categoriesFor: #readContents!accessing!public! !
!SwazooBuffer categoriesFor: #refillFrom:!public!reading! !
!SwazooBuffer categoriesFor: #resizeBuffer!private-resizing!public! !
!SwazooBuffer categoriesFor: #resizeEnlarge!private-resizing!public! !
!SwazooBuffer categoriesFor: #resizeNil!private-resizing!public! !
!SwazooBuffer categoriesFor: #resizeShrink!private-resizing!public! !
!SwazooBuffer categoriesFor: #setRead!initialize-release!public! !
!SwazooBuffer categoriesFor: #setWrite!initialize-release!public! !
!SwazooBuffer categoriesFor: #shouldEnlarge!private-resizing!public! !
!SwazooBuffer categoriesFor: #shouldResize!private-resizing!public! !
!SwazooBuffer categoriesFor: #shouldShrink!private-resizing!public! !
!SwazooBuffer categoriesFor: #signsOfBoundary:!mime boundary!public! !
!SwazooBuffer categoriesFor: #size!accessing!public! !
!SwazooBuffer categoriesFor: #startsWith:!mime boundary!public! !
!SwazooBuffer categoriesFor: #writeClear!initialize-release!public! !

!SwazooBuffer class methodsFor!

defaultBufferSize
	"length of buffer at creation. Later not nessesary exactly this number!! "
	^8000 "about 8KB-preamble"
!

largeBufferSize
	"size of buffer for large uploads/downloads"
	^1000000	"about 1MB"!

newRead
	^(super on: Array new) setRead; initDefaultBuffer!

newWrite
	^(super on: Array new) setWrite;  initDefaultBuffer!

on: aByteStringOrArray
        ^(super on: aByteStringOrArray)
                moveToEnd;
                position: 0 !

preambleSize
	"chunk size line (fixed to 4 hex characters) + crlf"
	^6! !
!SwazooBuffer class categoriesFor: #defaultBufferSize!defaults!public! !
!SwazooBuffer class categoriesFor: #largeBufferSize!defaults!public! !
!SwazooBuffer class categoriesFor: #newRead!instance creation!public! !
!SwazooBuffer class categoriesFor: #newWrite!instance creation!public! !
!SwazooBuffer class categoriesFor: #on:!instance creation!public! !
!SwazooBuffer class categoriesFor: #preambleSize!defaults!public! !

CompositeResource guid: (GUID fromString: '{C86F3EE4-318C-4B58-A43C-3F78F11B4916}')!
CompositeResource comment: ''!
!CompositeResource categoriesForClass!Unclassified! !
!CompositeResource methodsFor!

addResource: aResource
	self children add: aResource.
	aResource parent: self.
	aResource onResourceCreated.
	^aResource!

addResources: anOrderedCollection
	anOrderedCollection do: [ :each |
		self addResource: each].
	^anOrderedCollection!

children
	children isNil ifTrue: [self initChildren].
	^children!

currentUrl
	| string |
	string := super currentUrl.
	^string last = $/
		ifTrue: [string]
		ifFalse: [string , '/']!

hasNoResources
	^self children isEmpty!

helpResolve: aResolution 
	^aResolution resolveCompositeResource: self!

includesResource: aResource
	^self children includes: aResource.!

initChildren
	children := OrderedCollection new.!

initialize
	super initialize.
	self initChildren!

isRootPath
	^self uriPattern = '/'!

printUrlOn: aWriteStream 
	super printUrlOn: aWriteStream.
	self isRootPath ifFalse: [aWriteStream nextPut: $/]!

removeResource: aResource
	self children remove: aResource ifAbsent: [nil]! !
!CompositeResource categoriesFor: #addResource:!adding/removing!public! !
!CompositeResource categoriesFor: #addResources:!adding/removing!public! !
!CompositeResource categoriesFor: #children!accessing!public! !
!CompositeResource categoriesFor: #currentUrl!accessing!public! !
!CompositeResource categoriesFor: #hasNoResources!public!testing! !
!CompositeResource categoriesFor: #helpResolve:!accessing!public! !
!CompositeResource categoriesFor: #includesResource:!public!testing! !
!CompositeResource categoriesFor: #initChildren!initialize-release!public! !
!CompositeResource categoriesFor: #initialize!initialize-release!public! !
!CompositeResource categoriesFor: #isRootPath!public!testing! !
!CompositeResource categoriesFor: #printUrlOn:!accessing!public! !
!CompositeResource categoriesFor: #removeResource:!adding/removing!public! !

FileMappingResource guid: (GUID fromString: '{549FF9C1-5403-4046-964A-AE80AAFF3C3B}')!
FileMappingResource comment: ''!
!FileMappingResource categoriesForClass!Unclassified! !
!FileMappingResource methodsFor!

answerTo: aRequest 
	(self checkExistence: aRequest) ifFalse: [^nil].
	(self checkURI: aRequest) 
		ifFalse: 
			[| response |
			response := HTTPResponse movedPermanently.
			response headers 
				addField: (HTTPLocationField new uriString: aRequest uri identifier , '/').
			^response].
	^self file: (self fileFor: aRequest) answerTo: aRequest!

checkExistence: aRequest 
	(self rootFileFor: aRequest) exists ifFalse: [^false].
	^(self fileFor: aRequest) exists!

checkURI: aRequest 
	| needsFinalSlash |
	needsFinalSlash := (self rootFileFor: aRequest) isDirectory 
				and: [aRequest uri isDirectory not].
	^needsFinalSlash not!

directoryIndex
	^directoryIndex!

directoryIndex: aString 
	directoryIndex := aString!

file: aFilename answerTo: aRequest 
	^self subclassResponsibility!

fileDirectory
	^SpFilename named: self filePath!

fileFor: aRequest 
	| fn |
	fn := self rootFileFor: aRequest.
	fn isDirectory ifTrue: [fn := fn construct: self directoryIndex].
	^fn!

filePath
	^filePath!

filePath: aString 
	filePath := aString!

initialize
	super initialize.
	self directoryIndex: 'index.html'!

rootFileFor: aRequest 
	^aRequest tailPath inject: self fileDirectory
		into: 
			[:subPath :each | 
			(#('.' '..') includes: (HTTPString trimBlanksFrom: each)) 
				ifTrue: [subPath]
				ifFalse: [subPath construct: each]]! !
!FileMappingResource categoriesFor: #answerTo:!public!serving! !
!FileMappingResource categoriesFor: #checkExistence:!private! !
!FileMappingResource categoriesFor: #checkURI:!private! !
!FileMappingResource categoriesFor: #directoryIndex!accessing!public! !
!FileMappingResource categoriesFor: #directoryIndex:!accessing!public! !
!FileMappingResource categoriesFor: #file:answerTo:!private! !
!FileMappingResource categoriesFor: #fileDirectory!private! !
!FileMappingResource categoriesFor: #fileFor:!private! !
!FileMappingResource categoriesFor: #filePath!accessing!public! !
!FileMappingResource categoriesFor: #filePath:!accessing!public! !
!FileMappingResource categoriesFor: #initialize!private-initialize!public! !
!FileMappingResource categoriesFor: #rootFileFor:!private! !

!FileMappingResource class methodsFor!

uriPattern: aString filePath: aFilePath 
	^(self uriPattern: aString) filePath: aFilePath!

uriPattern: aString filePath: aFilePath directoryIndex: anotherString 
	^(self uriPattern: aString)
		filePath: aFilePath;
		directoryIndex: anotherString! !
!FileMappingResource class categoriesFor: #uriPattern:filePath:!instance creation!public! !
!FileMappingResource class categoriesFor: #uriPattern:filePath:directoryIndex:!instance creation!public! !

HelloWorldResource guid: (GUID fromString: '{358F7DC3-72D5-45F8-9F29-F29277992E03}')!
HelloWorldResource comment: ''!
!HelloWorldResource categoriesForClass!Unclassified! !
!HelloWorldResource methodsFor!

answerTo: aRequest 
	| response |
	response := HTTPResponse ok.
	response
		contentType: 'text/html';
		entity: '<html><head><title>Hello World</title></head><body>Hello World!!</body></html>'.
	^response! !
!HelloWorldResource categoriesFor: #answerTo:!public!serving! !

RedirectionResource guid: (GUID fromString: '{1568296D-0C07-4F0A-80B6-14CEB5E45863}')!
RedirectionResource comment: ''!
!RedirectionResource categoriesForClass!Unclassified! !
!RedirectionResource methodsFor!

answerTo: aRequest 
	| answer |
	answer := HTTPResponse movedPermanently.
	answer headers addField: (HTTPLocationField new uriString: self targetUri).
	^answer!

targetUri
	^targetUri!

targetUri: aString 
	targetUri := aString! !
!RedirectionResource categoriesFor: #answerTo:!public!serving! !
!RedirectionResource categoriesFor: #targetUri!private-initialize!public! !
!RedirectionResource categoriesFor: #targetUri:!private-initialize!public! !

!RedirectionResource class methodsFor!

uriPattern: aString targetUri: bString 
	^(self uriPattern: aString) targetUri: bString! !
!RedirectionResource class categoriesFor: #uriPattern:targetUri:!instance creation!public! !

ServerRootComposite guid: (GUID fromString: '{360B629D-6F72-4402-8775-44F8017B33C4}')!
ServerRootComposite comment: ''!
!ServerRootComposite categoriesForClass!Unclassified! !
!ServerRootComposite methodsFor!

helpResolve: aResolution 
	^aResolution resolveServerRoot: self! !
!ServerRootComposite categoriesFor: #helpResolve:!accessing!public! !

SwazooSite guid: (GUID fromString: '{CFADAE2D-9CFB-4B24-A3B2-604EA491A355}')!
SwazooSite comment: 'Site : Swazoo can serve many sites at once (virtual sites). Class Site is therefore a main class to start configuring your server. It holds an IP, port and hostname of your site.'!
!SwazooSite categoriesForClass!Unclassified! !
!SwazooSite methodsFor!

addAlias: anAlias 
	self ip isNil "initial uriPattern not yet setup"
		ifTrue: [self host: anAlias host ip: anAlias ip port: anAlias port]
		ifFalse: [self uriPattern add: anAlias]!

aliases
	^self uriPattern!

compile: tag 
	^SwazooCompiler evaluate: tag!

helpResolve: aResolution 
	^aResolution resolveSite: self!

host
	"hostname of this site. Example: www.ibm.com. 
	hostname must be unique on that server.
	Don't mix with ip, which also can be something like www.ibm.com. 
	There can be many sites with different hostnames on the same ip !! "
	self uriPattern isEmpty ifTrue: [^''].
	^self uriPattern first host!

host: aString
	self uriPattern first host: aString!

host: aHostString ip: anIPString port: aNumber 
	"see comments in methods host and ip !! "
	"hostname must be unique!! "
	| site |
	site := SwazooServer singleton siteHostnamed: aHostString.
	(site notNil and: [site ~= self])
		ifTrue: [^SwazooSiteError error: 'Site with that hostname already exist!!'].
	self uriPattern isEmpty ifTrue: [self uriPattern add: SiteIdentifier new].
	self uriPattern first 
		setIp: anIPString
		port: aNumber
		host: aHostString!

host: aHostString port: aNumber 
	"run on all ip interfaces on specified port"
	"hostname must be unique!! "
	self host: aHostString ip: '*' port: aNumber!

initialize
	super initialize.
	self stop. "in case you initialize working site"
	self initUriPattern!

initUriPattern
	self uriPattern: OrderedCollection new.
	self uriPattern add: SiteIdentifier new.!

ip
	"IP address of this site. Swazoo can have virtual sites, that is, more than one 
	site can share the same ip and port!!
	IP can be a number or full DNS name. For example: server.ibm.com or 234.12.45.66"
	^self uriPattern first ip!

ip: aString
	self uriPattern first  ip: aString!

isRootPath
	^false!

isServing
	"is this site on-line?"
	^serving notNil and: [serving]!

match: aSiteIdentifier 
	self uriPattern detect: [:each | each match: aSiteIdentifier]
		ifNone: [^false].
	^true!

name
	"a short name of that site. Example: for host www.ibm.com, name it ibm"
	name isNil ifTrue: [^''].
	^name!

name: aString
	"a short name of that site. Example: for host www.ibm.com, name it ibm"
	"name must be unique"
	(SwazooServer singleton siteNamed: aString) notNil 
		ifTrue: [^SwazooSiteError error: 'Site with that name already exist!!'].
	name := aString!

nextTagFrom: aStream 
	aStream upTo: $<.
	^aStream atEnd ifTrue: [nil] ifFalse: [aStream upTo: $>]!

onAllInterfaces
	"site is running on all machine's IP interfaces"
	^self ip = '*' or: [self ip = '0.0.0.0']!

onAnyHost
	"site don't care about host name during url resolution"
	^self host = '*'!

port
	^self uriPattern first port!

port: aNumber
	self uriPattern first port: aNumber!

printUrlOn: aWriteStream 
	self uriPattern first printUrlOn: aWriteStream!

readCompositeFrom: aStream storingInto: aComposite 
	| tag |
	
	[tag := self nextTagFrom: aStream.
	tag = '/CompositeResource']
		whileFalse: 
			[| thingy |
			thingy := self compile: tag.
			aComposite addResource: thingy.
			(thingy isKindOf: CompositeResource)
				ifTrue: [self readCompositeFrom: aStream storingInto: thingy]]!

readFrom: aStream 
	"read configuration from an XML file, see sites.cnf"
	| tag |
	tag := self nextTagFrom: aStream.
	tag isNil ifTrue: [^nil].
	tag = 'Site' ifFalse: [^SwazooSiteError error: 'invalid site specification!!'].
	[tag := self nextTagFrom: aStream.
	tag = '/Site'] 	whileFalse: 
			[| thingy |
			thingy := self compile: tag.
			(thingy isKindOf: SiteIdentifier)
				ifTrue: [self addAlias: thingy]
				ifFalse: 
					[self addResource: thingy.
					(thingy isKindOf: CompositeResource) 
						ifTrue: [self readCompositeFrom: aStream storingInto: thingy]]]!

serving: aBoolean
	serving := aBoolean!

start
	| swazoo |
	swazoo := SwazooServer singleton.
	[self aliases do: [:each | | httpServer |
		httpServer := swazoo serverFor: each. "it will also create and start it if needed"
		httpServer addSite: self]
	] ifCurtailed: [self stop].
	self serving: true.!

stop
	| swazoo |
	swazoo := SwazooServer singleton.
	self aliases do: [:each | | httpServer |
		httpServer := swazoo serverFor: each.
		(swazoo servers includes: httpServer) 
			ifTrue: 
				[httpServer removeSite: self.
				httpServer hasNoSites ifTrue: 
					[swazoo removeServer: httpServer.
					httpServer stop]]].
		self serving: false.!

uriPattern
	uriPattern isNil ifTrue: [self initUriPattern].
	^uriPattern!

watchdogAction
	"override in your subclass"! !
!SwazooSite categoriesFor: #addAlias:!accessing!public! !
!SwazooSite categoriesFor: #aliases!accessing!public! !
!SwazooSite categoriesFor: #compile:!config-from-file!public! !
!SwazooSite categoriesFor: #helpResolve:!private! !
!SwazooSite categoriesFor: #host!accessing!public! !
!SwazooSite categoriesFor: #host:!private! !
!SwazooSite categoriesFor: #host:ip:port:!accessing!public! !
!SwazooSite categoriesFor: #host:port:!accessing!public! !
!SwazooSite categoriesFor: #initialize!initialize-release!public! !
!SwazooSite categoriesFor: #initUriPattern!initialize-release!public! !
!SwazooSite categoriesFor: #ip!accessing!public! !
!SwazooSite categoriesFor: #ip:!private! !
!SwazooSite categoriesFor: #isRootPath!public!testing! !
!SwazooSite categoriesFor: #isServing!public!testing! !
!SwazooSite categoriesFor: #match:!private! !
!SwazooSite categoriesFor: #name!accessing!public! !
!SwazooSite categoriesFor: #name:!accessing!public! !
!SwazooSite categoriesFor: #nextTagFrom:!config-from-file!public! !
!SwazooSite categoriesFor: #onAllInterfaces!public!testing! !
!SwazooSite categoriesFor: #onAnyHost!public!testing! !
!SwazooSite categoriesFor: #port!accessing!public! !
!SwazooSite categoriesFor: #port:!private! !
!SwazooSite categoriesFor: #printUrlOn:!private! !
!SwazooSite categoriesFor: #readCompositeFrom:storingInto:!config-from-file!public! !
!SwazooSite categoriesFor: #readFrom:!config-from-file!public! !
!SwazooSite categoriesFor: #serving:!private! !
!SwazooSite categoriesFor: #start!public!start/stop! !
!SwazooSite categoriesFor: #stop!public!start/stop! !
!SwazooSite categoriesFor: #uriPattern!private! !
!SwazooSite categoriesFor: #watchdogAction!private! !

!SwazooSite class methodsFor!

named: aString
	"return a website with that name"
	^SwazooServer singleton siteNamed: aString!

newNamed: aString
	| site |
	site := self new name: aString.
	SwazooServer singleton addSite: site.
	site initialize.
	^site! !
!SwazooSite class categoriesFor: #named:!accessing!public! !
!SwazooSite class categoriesFor: #newNamed:!instance creation!public! !

FileResource guid: (GUID fromString: '{654B7AF3-D77D-42BB-999C-B2D8D586DFF0}')!
FileResource comment: ''!
!FileResource categoriesForClass!Unclassified! !
!FileResource methodsFor!

contentTypeFor: aString 
	^ContentTypes at: aString ifAbsent: ['application/octet-stream']!

file: aFilename answerTo: aRequest 
	| cacheControl response |
	cacheControl := SwazooCacheControl new request: aRequest
				cacheTarget: aFilename.
	response := cacheControl isNotModified 
				ifTrue: [HTTPResponse notModified]
				ifFalse: 
					[FileResponse ok entity: ((MimeObject new)
								value: aFilename;
								contentType: (self contentTypeFor: aFilename extension))].
	cacheControl addResponseHeaders: response.
	^response! !
!FileResource categoriesFor: #contentTypeFor:!private! !
!FileResource categoriesFor: #file:answerTo:!private! !

!FileResource class methodsFor!

initialize
	"self initialize"

	ContentTypes := (Dictionary new)
				add: '.txt' -> 'text/plain';
				add: '.html' -> 'text/html';
				add: '.htm' -> 'text/html';
				add: '.css' -> 'text/css';
				add: '.png' -> 'image/png';
				add: '.gif' -> 'image/gif';
				add: '.jpg' -> 'image/jpeg';
				add: '.m3u' -> 'audio/mpegurl';
				add: '.ico' -> 'image/x-icon';
				add: '.pdf' -> 'application/pdf';
				yourself! !
!FileResource class categoriesFor: #initialize!class initialization!public! !

HomeResource guid: (GUID fromString: '{D92F6F14-AA90-44B9-9000-9CD2F49DD7A9}')!
HomeResource comment: ''!
!HomeResource categoriesForClass!Unclassified! !
!HomeResource methodsFor!

answerTo: aRequest 
	aRequest tailPath isEmpty ifTrue: [^nil].
	(self validateHomePath: aRequest tailPath first) ifFalse: [^nil].
	^super answerTo: aRequest!

rootFileFor: aRequest 
	| homeKey file |
	homeKey := aRequest tailPath first copyFrom: 2
				to: aRequest tailPath first size.
	file := (self fileDirectory construct: homeKey) construct: 'html'.
	(aRequest tailPath copyFrom: 2 to: aRequest tailPath size) 
		do: [:each | each = '..' ifFalse: [file := file construct: each]].
	^file!

validateHomePath: aString 
	^aString first = $~! !
!HomeResource categoriesFor: #answerTo:!accessing!public! !
!HomeResource categoriesFor: #rootFileFor:!private! !
!HomeResource categoriesFor: #validateHomePath:!private! !

SiteIdentifier guid: (GUID fromString: '{3E58856A-9E8B-46E5-A062-BD08D81C6A9C}')!
SiteIdentifier comment: ''!
!SiteIdentifier categoriesForClass!Unclassified! !
!SiteIdentifier methodsFor!

currentUrl
	| stream |
	stream := WriteStream on: String new.
	self printUrlOn: stream.
	^stream contents!

host
	^host!

host: aString
	host := aString!

hostMatch: aSiteIdentifier
	(self host asLowercase = aSiteIdentifier host asLowercase) ifTrue: [^true].
	(self host = '*' or: [aSiteIdentifier host = '*']) ifTrue: [^true]. "is this always good?"
 	^false!

ip
	^ip!

ip: aString
	ip := aString!

ipMatch: aSiteIdentifier
	"ip can be in numbers or named!!"
	| myIP otherIP |
	self ip = aSiteIdentifier ip ifTrue: [^true].
	(self ip = '*' or: [self ip = '0.0.0.0']) ifTrue: [^true].
	(aSiteIdentifier ip = '*' or: [aSiteIdentifier ip = '0.0.0.0']) ifTrue: [^true]. 
																"is this always good?"
	myIP := SpIPAddress hostName: self ip port: self port.
	otherIP := SpIPAddress hostName: aSiteIdentifier ip port: aSiteIdentifier port.
	^myIP hostAddress = otherIP hostAddress!

isEmpty
	"host ip port empty or nil"
	(host isNil or: [host isEmpty]) ifTrue: [^true].
	(ip isNil or: [ip isEmpty]) ifTrue: [^true].
	port isNil ifTrue: [^true].
	^false!

newServer
	^ HTTPServer new ip: self ip;  port: self port!

port
	^port!

port: aNumber
	port := aNumber!

portMatch: aSiteIdentifier
	"ih host can be anything then same goes for the port of request too"
	self port = aSiteIdentifier port ifTrue: [^true].
	(self host = '*' or: [aSiteIdentifier host = '*']) ifTrue: [^true].
 	^false!

printHostPortStringOn: stream 
	stream nextPutAll: (self host notNil ifTrue: [self host] ifFalse: ['']).
	self port = 80 ifFalse: [stream nextPut: $:; nextPutAll: self port printString]!

printString
	^'a Swazoo.SiteIndentifier
	host: ', (self host isNil ifTrue: [''] ifFalse: [self host]), '
	ip: ', (self ip isNil ifTrue: [''] ifFalse: [self ip]), '
	port: ', self port printString!

printUrlOn: aWriteStream 
	aWriteStream nextPutAll: 'http://'.
	self printHostPortStringOn: aWriteStream!

setIp: anIP port: aPort host: hostName 
	self ip: anIP.
	self port: aPort.
	self host: hostName!

valueMatch: aSiteIdentifier
	^(self portMatch: aSiteIdentifier)
		and: [(self ipMatch: aSiteIdentifier)
			and: [self hostMatch: aSiteIdentifier] ]! !
!SiteIdentifier categoriesFor: #currentUrl!accessing!public! !
!SiteIdentifier categoriesFor: #host!accessing!public! !
!SiteIdentifier categoriesFor: #host:!private! !
!SiteIdentifier categoriesFor: #hostMatch:!private-comparing!public! !
!SiteIdentifier categoriesFor: #ip!accessing!public! !
!SiteIdentifier categoriesFor: #ip:!private! !
!SiteIdentifier categoriesFor: #ipMatch:!private-comparing!public! !
!SiteIdentifier categoriesFor: #isEmpty!public!testing! !
!SiteIdentifier categoriesFor: #newServer!initialize-release!public! !
!SiteIdentifier categoriesFor: #port!accessing!public! !
!SiteIdentifier categoriesFor: #port:!private! !
!SiteIdentifier categoriesFor: #portMatch:!private-comparing!public! !
!SiteIdentifier categoriesFor: #printHostPortStringOn:!private! !
!SiteIdentifier categoriesFor: #printString!private! !
!SiteIdentifier categoriesFor: #printUrlOn:!private! !
!SiteIdentifier categoriesFor: #setIp:port:host:!initialize-release!public! !
!SiteIdentifier categoriesFor: #valueMatch:!private-comparing!public! !

!SiteIdentifier class methodsFor!

host: hostName ip: anIP port: aPort 
	^self new 
		setIp: anIP
		port: aPort
		host: hostName!

ip: anIP port: aPort host: hostName 
	^self new 
		setIp: anIP
		port: aPort
		host: hostName! !
!SiteIdentifier class categoriesFor: #host:ip:port:!instance creation!public! !
!SiteIdentifier class categoriesFor: #ip:port:host:!obsolete!public! !

"Binary Globals"!

