| package |
package := Package name: 'AIDAWeb'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: 'AIDA 6.0 - 0.027'.


package classNames
	add: #Address;
	add: #AIDAAspectAdaptor;
	add: #AIDAIndexedAdaptor;
	add: #AidaProfiling;
	add: #AIDAProtocolAdaptor;
	add: #AIDASite;
	add: #BmpImageStream;
	add: #BosImageStream;
	add: #Company;
	add: #DailyCollection;
	add: #DailyValues;
	add: #DefaultWebStyle;
	add: #DelimitedFile;
	add: #DirectoryProxy;
	add: #DocLink;
	add: #FileProxy;
	add: #GifImageStream;
	add: #History;
	add: #HTTPCopy;
	add: #HTTPLock;
	add: #HTTPLockResponse;
	add: #HTTPMkCol;
	add: #HTTPMove;
	add: #HTTPPropFind;
	add: #HTTPPropFindResponse;
	add: #HTTPPropPatch;
	add: #HTTPUnlock;
	add: #HTTPWebDAVResponse;
	add: #ImageStream;
	add: #JoomlaMenu;
	add: #JoomlaModule;
	add: #JoomlaStyle;
	add: #MemberRole;
	add: #MIMEMap;
	add: #Numberer;
	add: #OrganizationUnit;
	add: #Party;
	add: #PartyCollection;
	add: #PersistentDictionary;
	add: #PersistentIdentityDictionary;
	add: #Person;
	add: #RDBTable;
	add: #Role;
	add: #RoleGroup;
	add: #SwazooAida;
	add: #UMLWebDialogListSelect;
	add: #URLResolver;
	add: #VersionedExample;
	add: #VersionedExampleApp;
	add: #VersionedObject;
	add: #VersionSpec;
	add: #ViewTabs;
	add: #WebAdmin;
	add: #WebAdminApp;
	add: #WebAnchor;
	add: #WebApplication;
	add: #WebAutocompleteField;
	add: #WebButton;
	add: #WebCache;
	add: #WebCacheEntry;
	add: #WebCaptcha;
	add: #WebCheckBox;
	add: #WebClipboard;
	add: #WebComment;
	add: #WebContext;
	add: #WebContextFirst;
	add: #WebCounter;
	add: #WebCountry;
	add: #WebDateInputField;
	add: #WebDelayedField;
	add: #WebDemo;
	add: #WebDemoApp;
	add: #WebDialog;
	add: #WebElement;
	add: #WebFieldSet;
	add: #WebFileInputField;
	add: #WebForm;
	add: #WebFormElement;
	add: #WebGraph;
	add: #WebGrid;
	add: #WebGridColumn;
	add: #WebHelp;
	add: #WebHelpApp;
	add: #WebHelpPage;
	add: #WebHelpPageApp;
	add: #WebIFrame;
	add: #WebImage;
	add: #WebImageMap;
	add: #WebIndex;
	add: #WebIndexApp;
	add: #WebInPlaceEditableText;
	add: #WebInputField;
	add: #WebLanguage;
	add: #WebLightbox;
	add: #WebLink;
	add: #WebList;
	add: #WebListItem;
	add: #WebLiveImage;
	add: #WebLivePDFCreator;
	add: #WebMenu;
	add: #WebMethodImage;
	add: #WebMethodResource;
	add: #WebMsgs;
	add: #WebMsgsApp;
	add: #WebNonHTMLResource;
	add: #WebPage;
	add: #WebRadioButton;
	add: #WebRawText;
	add: #WebRichEditor;
	add: #WebRichEditorWakeup;
	add: #WebScheduledEvent;
	add: #WebScheduler;
	add: #WebScript;
	add: #WebSecurityManager;
	add: #WebSecurityManagerApp;
	add: #WebSeparator;
	add: #WebSession;
	add: #WebSessionManager;
	add: #WebSiteOwnerRole;
	add: #WebStatistics;
	add: #WebStatisticsApp;
	add: #WebStubElement;
	add: #WebStyle;
	add: #WebTable;
	add: #WebTableCell;
	add: #WebTableHeader;
	add: #WebTableRow;
	add: #WebTabs;
	add: #WebText;
	add: #WebTextArea;
	add: #WebTransactionMonitor;
	add: #WebTranslator;
	add: #WebTranslDict;
	add: #WebUser;
	add: #WebUserApp;
	add: #WebUserGroup;
	add: #WebUserGroupApp;
	add: #WebUserRole;
	add: #WebWidget;
	add: #WebWindow;
	yourself.

package methodNames
	add: #Association -> #aidaIsAssociation;
	add: #BlockClosure -> #aidaDeepCopyNotIn:;
	add: #Class -> #aidaDeepCopyNotIn:;
	add: #Collection -> #allDailyCollectionDated:;
	add: #Collection -> #allDailyCollectionDates;
	add: #Collection -> #allDailyCollectionDays;
	add: #Collection -> #allDailyCollectionEntries;
	add: #Collection -> #allDailyCollectionFromDate:to:;
	add: #Collection -> #allDailyCollectionYear:;
	add: #Collection -> #allDailyCollectionYears;
	add: #Collection -> #allDailyCollectionYearsForKindOf:;
	add: #Collection -> #isRespondingStreamed;
	add: #Collection -> #isWebElement;
	add: #Collection -> #isWebPage;
	add: #Collection -> #printHTMLPageOn:for:on:;
	add: #Date -> #-;
	add: #Date -> #+;
	add: #Date -> #monthAndDayString;
	add: #Date -> #printISOString;
	add: #Date -> #shorterPrintSloString;
	add: #Date -> #shortPrintSloString;
	add: #HTTPConnection -> #representBinaryOn:;
	add: #HTTPPost -> #ajaxSingleInputName;
	add: #HTTPPost -> #postDataKeysNotStreamed;
	add: #HTTPRequest -> #ajaxContentElementId;
	add: #HTTPRequest -> #ajaxElementId;
	add: #HTTPRequest -> #context;
	add: #HTTPRequest -> #context:;
	add: #HTTPRequest -> #contextId;
	add: #HTTPRequest -> #idFromCookie;
	add: #HTTPRequest -> #isAjaxAutocompleteRequest;
	add: #HTTPRequest -> #isAjaxCloseWindowRequest;
	add: #HTTPRequest -> #isAjaxInPlaceEditingRequest;
	add: #HTTPRequest -> #isAjaxPopupWindowRequest;
	add: #HTTPRequest -> #isAjaxPostRequest;
	add: #HTTPRequest -> #isAjaxPostWithInput;
	add: #HTTPRequest -> #isAjaxPostWithSingleInput;
	add: #HTTPRequest -> #isAjaxRequest;
	add: #HTTPRequest -> #isAjaxWikiFormatedRequest;
	add: #HTTPRequest -> #isCopy;
	add: #HTTPRequest -> #isLock;
	add: #HTTPRequest -> #isMkCol;
	add: #HTTPRequest -> #isMove;
	add: #HTTPRequest -> #isPing;
	add: #HTTPRequest -> #isPropFind;
	add: #HTTPRequest -> #isPropPatch;
	add: #HTTPRequest -> #isUnlock;
	add: #HTTPRequest -> #view;
	add: #HTTPServer -> #representBinaryOn:;
	add: #Magnitude -> #asString;
	add: #Number -> #printDotString;
	add: #Number -> #withZeros;
	add: #Object -> #aidaCacheTimeout;
	add: #Object -> #aidaCacheView:on:;
	add: #Object -> #aidaCanBeLocked;
	add: #Object -> #aidaDeepCopy;
	add: #Object -> #aidaDeepCopyNotIn:;
	add: #Object -> #aidaDontCache;
	add: #Object -> #aidaIsAssociation;
	add: #Object -> #aidaIsLocked;
	add: #Object -> #aidaLock;
	add: #Object -> #aidaUnlock;
	add: #Object -> #app;
	add: #Object -> #contentType;
	add: #Object -> #deepSearchOfClass:;
	add: #Object -> #deepSearchOfObsoleteClasses;
	add: #Object -> #expiresTimestamp;
	add: #Object -> #firstAppFromStack;
	add: #Object -> #firstContextFromStack;
	add: #Object -> #firstRequestFromStack;
	add: #Object -> #firstSessionFromStack;
	add: #Object -> #forLanguage:;
	add: #Object -> #isMultilingual;
	add: #Object -> #isVersionedObject;
	add: #Object -> #isWebApplication;
	add: #Object -> #isWebStyle;
	add: #Object -> #modifiedTimestamp;
	add: #Object -> #notEmpty;
	add: #Object -> #preferedUrl;
	add: #Object -> #printWebAppNotFoundFor:;
	add: #Object -> #printWebPageFor:on:;
	add: #Object -> #sendOver:;
	add: #OrderedCollection -> #moveDown:;
	add: #OrderedCollection -> #moveUp:;
	add: #PositionableStream -> #bcrlf;
	add: #PositionableStream -> #insensitivePeekForAll:;
	add: #PositionableStream -> #insensitiveSkipThroughAll:;
	add: #PositionableStream -> #insensitiveUpToAll:;
	add: #PositionableStream -> #peekForAll:;
	add: #PositionableStream -> #readLimit;
	add: #SpDate -> #currentMonth;
	add: #SpDate -> #currentYear;
	add: #SpDate -> #firstDayInMonth;
	add: #SpDate -> #firstDayInNextMonth;
	add: #SpDate -> #firstDayInNextYear;
	add: #SpDate -> #firstDayInPreviousMonth;
	add: #SpDate -> #firstDayInPreviousYear;
	add: #SpDate -> #lastDayInMonth;
	add: #SpDate -> #shortPrintSloString;
	add: #SpTimestamp -> #printSloString;
	add: #Stream -> #lf;
	add: #Stream -> #upTo:escaper:;
	add: #String -> #aidaIsAssociation;
	add: #String -> #asCollectionOfHtmlHeadings;
	add: #String -> #asDouble;
	add: #String -> #asFloat;
	add: #String -> #asHttpFriendly;
	add: #String -> #asInteger;
	add: #String -> #asSloveneWithoutCircumflexes;
	add: #String -> #containsSubstring:;
	add: #String -> #contentsAsMethod;
	add: #String -> #convertToSloveneChars;
	add: #String -> #ensureUnicodeSloveneChars;
	add: #String -> #isValidEMailAddress;
	add: #String -> #lineCount;
	add: #String -> #lineCount:;
	add: #String -> #plainEMailAddress;
	add: #String -> #sendOver:;
	add: #String -> #shortPrintSloString;
	add: #String -> #shrinkTo:;
	add: #String -> #trimNewlines;
	add: #String -> #upToNumber;
	add: #String -> #withHeadingAnchors;
	add: #String -> #withHtmlBreaks;
	add: #String -> #withoutHtmlTags;
	add: #SwazooServer -> #aidaDemoSite;
	add: #SwazooServer -> #aidaDemoStart;
	add: #SwazooServer -> #aidaDemoStop;
	add: #SwazooServer -> #aidaSites;
	add: #SwazooServer -> #aidaStartOn:;
	add: #SwazooServer -> #isNightlyBackupTime;
	add: #SwazooServer -> #isWatchdogRunning;
	add: #SwazooServer -> #prepareAidaDemoSiteOnPort:;
	add: #SwazooServer -> #representBinaryOn:;
	add: #SwazooServer -> #watchdogOther;
	add: #SwazooServer -> #watchdogSites;
	add: #Time -> #printSloString;
	add: 'Date class' -> #nameOfSloDay:;
	add: 'Date class' -> #nameOfSloMonth:;
	add: 'Date class' -> #readSloFrom:;
	add: 'HTTPException class' -> #failedDependency;
	add: 'HTTPException class' -> #insufficientStorage;
	add: 'HTTPException class' -> #locked;
	add: 'HTTPException class' -> #multiStatus;
	add: 'HTTPException class' -> #processing;
	add: 'HTTPException class' -> #unprocessableEntity;
	add: 'HTTPResponse class' -> #failedDependency;
	add: 'HTTPResponse class' -> #insufficientStorage;
	add: 'HTTPResponse class' -> #locked;
	add: 'HTTPResponse class' -> #multiStatus;
	add: 'HTTPResponse class' -> #noContent;
	add: 'HTTPResponse class' -> #processing;
	add: 'HTTPResponse class' -> #unprocessableEntity;
	add: 'SwazooServer class' -> #aidaDemoStart;
	add: 'SwazooServer class' -> #aidaDemoStop;
	add: 'SwazooServer class' -> #aidaStartOn:;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'Object Arts\Dolphin\Base\Dolphin';
	add: 'Object Arts\Dolphin\MVP\Base\Dolphin MVP Base';
	add: 'Object Arts\Dolphin\MVP\Models\Value\Dolphin Value Models';
	add: 'Sport';
	add: 'Swazoo';
	yourself).

package!

"Class Definitions"!

Object subclass: #Address
	instanceVariableNames: 'title firstName middleName lastName company street city stateProvince postalCode country phones fax emails'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #AidaProfiling
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #AIDAProtocolAdaptor
	instanceVariableNames: 'subject'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DailyCollection
	instanceVariableNames: 'days'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DailyValues
	instanceVariableNames: 'days'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DelimitedFile
	instanceVariableNames: 'filename delimiter codepage records'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DirectoryProxy
	instanceVariableNames: 'server filename fileDates origContent origCodepage contentType elements bodyTagIndex imgTagIndexes linkTagIndexes servletTagIndexes'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DocLink
	instanceVariableNames: 'title url object'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #FileProxy
	instanceVariableNames: 'site filename timestamps content contentType size caching codepage elements bodyTagIndex imgTagIndexes linkTagIndexes servletTagIndexes'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #History
	instanceVariableNames: 'dates values changedDates authors comments historyCollection'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #ImageStream
	instanceVariableNames: 'imageStream progressValue'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #MIMEMap
	instanceVariableNames: 'mimeTypes fileExtensions'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #Numberer
	instanceVariableNames: 'counters'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #Party
	instanceVariableNames: 'id name description addresses roles relatedPartyRoles events relatedObjects otherValues'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #PartyCollection
	instanceVariableNames: 'parent parties'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #RDBTable
	instanceVariableNames: 'environment username password codepage table columns records'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #Role
	instanceVariableNames: 'name party relatedParty'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #RoleGroup
	instanceVariableNames: 'name subroles'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooAida
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #URLResolver
	instanceVariableNames: 'site allWebPages allURLLinks counters totalCounter'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #VersionedObject
	instanceVariableNames: 'version'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #VersionSpec
	instanceVariableNames: 'object number current parent next'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebAdmin
	instanceVariableNames: 'host ip port'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebApplication
	instanceVariableNames: 'session observee contexts other'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebCache
	instanceVariableNames: 'parent objects settings other'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebCacheEntry
	instanceVariableNames: 'content created timeout'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebClipboard
	instanceVariableNames: 'title url object'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebContext
	instanceVariableNames: 'id parent child state window ids process semaphore request answer result'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebCounter
	instanceVariableNames: 'started day year dailyCounts hourlyCounts todayHourlyCounts total yearlyHistory'
	classVariableNames: 'Janko'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebCountry
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebDemo
	instanceVariableNames: 'introduction date input delayedInput field1 field2 editField content submitValue deleted'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebElement
	instanceVariableNames: 'parent elements attributes other'
	classVariableNames: 'Colors'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebGridColumn
	instanceVariableNames: 'parent id name width align aspect linkAspect linkView viewBlock addBlock sorted filter filterWidth summaryType summary'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebHelp
	instanceVariableNames: 'pages'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebHelpPage
	instanceVariableNames: 'parent app view title body'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebIndex
	instanceVariableNames: 'index indexedObjects popularWords workQueue indexer'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebLanguage
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebMethodResource
	instanceVariableNames: 'site object method contentType preferedUrl'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebMsgs
	instanceVariableNames: 'messagesByLanguage language'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebScheduledEvent
	instanceVariableNames: 'parent timestamp period method object block'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebScheduler
	instanceVariableNames: 'site queue loop lock'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebSecurityManager
	instanceVariableNames: 'site users groups authenticationScheme accessByObject'
	classVariableNames: 'Janko'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebSession
	instanceVariableNames: 'ids created cookies parent user language country appsForObjects userValues other'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebSessionManager
	instanceVariableNames: 'site sessions'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebStatistics
	instanceVariableNames: 'site referers refererStopList'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebStyle
	instanceVariableNames: 'site style resources searchButton'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebTransactionMonitor
	instanceVariableNames: ''
	classVariableNames: 'BusySessions LocalServers NotificationSent Transactions'
	poolDictionaries: ''
	classInstanceVariableNames: 'Lock'!
Object subclass: #WebTranslator
	instanceVariableNames: 'parent cache other'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebUser
	instanceVariableNames: 'parent id username password name surname company address city zip country website email phone fax otherValues'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebUserGroup
	instanceVariableNames: 'name users'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
AIDAProtocolAdaptor subclass: #AIDAAspectAdaptor
	instanceVariableNames: 'aspect'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
AIDAProtocolAdaptor subclass: #AIDAIndexedAdaptor
	instanceVariableNames: 'index'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Dictionary variableSubclass: #PersistentDictionary
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Dictionary variableSubclass: #WebTranslDict
	instanceVariableNames: 'changes'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
IdentityDictionary variableSubclass: #PersistentIdentityDictionary
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
FileProxy subclass: #WebCaptcha
	instanceVariableNames: 'text random'
	classVariableNames: 'Cache'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPCopy
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPLock
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPMkCol
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPMove
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPPropFind
	instanceVariableNames: 'properties'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPPropPatch
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPUnlock
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPResponse subclass: #HTTPWebDAVResponse
	instanceVariableNames: 'xmlResponse'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPWebDAVResponse subclass: #HTTPLockResponse
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPWebDAVResponse subclass: #HTTPPropFindResponse
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ImageStream subclass: #BmpImageStream
	instanceVariableNames: 'bfType bfSize bfReserved1 bfReserved2 bfOffBits biSize biWidth biHeight biPlanes biBitCount biCompression biSizeImage biXPelsPerMeter biYPelsPerMeter biClrUsed biClrImportant imagePalette imageObject'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ImageStream subclass: #BosImageStream
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ImageStream subclass: #GifImageStream
	instanceVariableNames: 'width height bitsPerPixel colorPalette rowByteSize xpos ypos pass interlace codeSize clearCode eoiCode freeCode maxCode prefixTable suffixTable remainBitCount bufByte bufStream transparentPixel'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Party subclass: #OrganizationUnit
	instanceVariableNames: 'type parent units specialRoles'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Party subclass: #Person
	instanceVariableNames: 'surname'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
OrganizationUnit subclass: #Company
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Role subclass: #MemberRole
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Role subclass: #WebSiteOwnerRole
	instanceVariableNames: 'webSite'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Role subclass: #WebUserRole
	instanceVariableNames: 'username password'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooSite subclass: #AIDASite
	instanceVariableNames: 'style settings systemServices userServices timestamps counters'
	classVariableNames: 'Default SloveneCharacters'
	poolDictionaries: ''
	classInstanceVariableNames: 'Random'!
VersionedObject subclass: #VersionedExample
	instanceVariableNames: 'title body'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #VersionedExampleApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebAdminApp
	instanceVariableNames: 'username password newUser newSite umlModel'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebDemoApp
	instanceVariableNames: 'liveImage selectedClasses filename fileContentType fileStream startStamp'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebHelpApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebHelpPageApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebIndexApp
	instanceVariableNames: 'searchString results page'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebMsgsApp
	instanceVariableNames: 'webMsgs assocs texts'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebSecurityManagerApp
	instanceVariableNames: 'selectedUsers selectedGroups usr group aclObject aclForWho'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebStatisticsApp
	instanceVariableNames: 'date domainObject'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebUserApp
	instanceVariableNames: 'newPassword newPasswordConfirmation'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebUserGroupApp
	instanceVariableNames: 'usersInGroup'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebContext subclass: #WebContextFirst
	instanceVariableNames: 'view mainSemaphore'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #JoomlaModule
	instanceVariableNames: 'header body'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebComment
	instanceVariableNames: 'text'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebFieldSet
	instanceVariableNames: 'legend'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebForm
	instanceVariableNames: 'fields action tabOrder'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebFormElement
	instanceVariableNames: 'aspect object adaptor value enterTab'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebIFrame
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebImage
	instanceVariableNames: 'image imageMap'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebImageMap
	instanceVariableNames: 'areas'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebList
	instanceVariableNames: 'name kind type'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebListItem
	instanceVariableNames: 'tag'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebLiveImage
	instanceVariableNames: 'gif refreshed width height painter lastUsed resolver'
	classVariableNames: 'Cache'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebScript
	instanceVariableNames: 'script source'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebSeparator
	instanceVariableNames: 'type size length'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebStubElement
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebTable
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebTableCell
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebTableRow
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebText
	instanceVariableNames: 'text size textAttributes header paragraph font'
	classVariableNames: 'AttributeMarkup'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebWidget
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
JoomlaModule subclass: #JoomlaMenu
	instanceVariableNames: 'pages'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebButton
	instanceVariableNames: 'type image size'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebCheckBox
	instanceVariableNames: 'checked selected'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebInPlaceEditableText
	instanceVariableNames: 'size attribute formated allow triggerElement'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebInputField
	instanceVariableNames: 'size maxLength type'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebMenu
	instanceVariableNames: 'multiple collection selected aspectToStore objectToStore sort'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebRadioButton
	instanceVariableNames: 'checked'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebTextArea
	instanceVariableNames: 'rows columns'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebInputField subclass: #WebAutocompleteField
	instanceVariableNames: 'choicesAspect choicesObject choiceAspect elementToUpdate'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebInputField subclass: #WebDateInputField
	instanceVariableNames: 'button'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebInputField subclass: #WebDelayedField
	instanceVariableNames: 'update parameter delay'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebInputField subclass: #WebFileInputField
	instanceVariableNames: 'filenameAspect contentTypeAspect writeStream writeBlock'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebTextArea subclass: #WebRichEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebList subclass: #WebTabs
	instanceVariableNames: 'selected'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebTabs subclass: #ViewTabs
	instanceVariableNames: 'views'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebLiveImage subclass: #WebGraph
	instanceVariableNames: 'data margin title graphics'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebTableCell subclass: #WebTableHeader
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebText subclass: #WebAnchor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebText subclass: #WebLink
	instanceVariableNames: 'ooReference urlReference parms anchor security'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebText subclass: #WebRawText
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebWidget subclass: #WebDialog
	instanceVariableNames: 'type text'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebWidget subclass: #WebGrid
	instanceVariableNames: 'collection filtered columns page settings'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebWidget subclass: #WebLightbox
	instanceVariableNames: 'component'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebWidget subclass: #WebNonHTMLResource
	instanceVariableNames: 'contentType content filename'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebWidget subclass: #WebRichEditorWakeup
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebWidget subclass: #WebWindow
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebDialog subclass: #UMLWebDialogListSelect
	instanceVariableNames: 'component'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebWindow subclass: #WebPage
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebMethodResource subclass: #WebLivePDFCreator
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebMethodResource subclass: #WebMethodImage
	instanceVariableNames: 'lastUsed'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: 'Cache'!
WebStyle subclass: #DefaultWebStyle
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
DefaultWebStyle subclass: #JoomlaStyle
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

!Association methodsFor!

aidaIsAssociation
	"used for Aida/Web translation support, multilingual strings are namelly assocs: #fr->'Bonjour'"
	^true! !
!Association categoriesFor: #aidaIsAssociation!public!testing! !

!BlockClosure methodsFor!

aidaDeepCopyNotIn: aDict
	^nil! !
!BlockClosure categoriesFor: #aidaDeepCopyNotIn:!private! !

!Class methodsFor!

aidaDeepCopyNotIn: aDict
	^nil! !
!Class categoriesFor: #aidaDeepCopyNotIn:!fileIn/Out!public! !

!Collection methodsFor!

allDailyCollectionDated: aDate
	"all on that date in any of daily collections"
	^self inject: OrderedCollection new into: [:col :each | col addAll: (each allDated: aDate). col]

"DailyCollection allInstances allDailyCollectionDated: 
		DailyCollection allInstances allDailyCollectionDates asOrderedCollection last."!

allDailyCollectionDates
	"all dates which occur of any of daily collections"
	^self allDailyCollectionDays collect: [:each | Date fromDays: each].

"DailyCollection allInstances allDailyCollectionDates"!

allDailyCollectionDays
	"all day numbers which occur of any of daily collections"
	^self inject: Set new into: [:set :each | set addAll: each allDays. set].

"DailyCollection allInstances allDailyCollectionDays"!

allDailyCollectionEntries
	"sorted by date"
	| days |
	days := self allDailyCollectionDays.
	days := days asSortedCollection. 
	^days inject: OrderedCollection new into: [:col :day | 
		self do: [:daily | (daily days includesKey: day) ifTrue: [col addAll: (daily days at: day)] ].
		col].

"DailyCollection allInstances allDailyCollectionEntries"!

allDailyCollectionFromDate: aStartDate to: anEndDate
	"sorted by date"
	| startDay endDay daysInRange |
	startDay := aStartDate asDays. endDay := anEndDate asDays.
	daysInRange := self allDailyCollectionDays select: [:each | each >= startDay and: [each <= endDay] ].
	daysInRange := daysInRange asSortedCollection. 
	^daysInRange inject: OrderedCollection new into: [:col :day | 
		self do: [:daily | (daily days includesKey: day) ifTrue: [col addAll: (daily days at: day)] ].
		col].

"DailyCollection allInstances allDailyCollectionFromDate: (Date readSloFrom: '1.1.2004' readStream) 
  	to: (Date readSloFrom: '31.12.2006' readStream)"!

allDailyCollectionYear: aNumber
	^self 
		allDailyCollectionFromDate: (Date newDay: 1 monthNumber: 1 year: aNumber)
		to: (Date newDay: 31 monthNumber: 12 year: aNumber)

"DailyCollection allInstances allDailyCollectionYear: 2004 "!

allDailyCollectionYears
	"all years on which occur of anything of daily collections. Sorted!!"
	^SortedCollection 
		withAll: (self allDailyCollectionDates inject: Set new into: [:set :each | set add: each year. set])
		sortBlock: [:a :b | a < b].

"DailyCollection allInstances allDailyCollectionYears"!

allDailyCollectionYearsForKindOf: aClass
	"all years on which occur of anything of that class. Sorted!!"
	"optimize that!!"
	^(self inject: Set new into: [:set :each | set addAll: (each allYearsForKindOf: aClass). set])
		asSortedCollection

"DailyCollection allInstances allDailyCollectionYearsForKindOf: AIDA.Invoice"!

isRespondingStreamed
	^false!

isWebElement
	^true "more or less"!

isWebPage
	^false!

printHTMLPageOn: aStream for: aRequest on: aSession
	"only inner html, for ajax element updates"
	self do: [:element | 
		element notNil ifTrue: [element printHTMLPageOn: aStream for: aRequest on: aSession] ].! !
!Collection categoriesFor: #allDailyCollectionDated:!daily collections!public! !
!Collection categoriesFor: #allDailyCollectionDates!daily collections!public! !
!Collection categoriesFor: #allDailyCollectionDays!daily collections!public! !
!Collection categoriesFor: #allDailyCollectionEntries!daily collections!public! !
!Collection categoriesFor: #allDailyCollectionFromDate:to:!daily collections!public! !
!Collection categoriesFor: #allDailyCollectionYear:!daily collections!public! !
!Collection categoriesFor: #allDailyCollectionYears!daily collections!public! !
!Collection categoriesFor: #allDailyCollectionYearsForKindOf:!daily collections!public! !
!Collection categoriesFor: #isRespondingStreamed!AIDA web!public! !
!Collection categoriesFor: #isWebElement!AIDA web!public! !
!Collection categoriesFor: #isWebPage!AIDA web!public! !
!Collection categoriesFor: #printHTMLPageOn:for:on:!AIDA web!public! !

!Date methodsFor!

- aNumber 

	"Janko Mivsek, dec97"
	"subtract number of days from a date."

	^self subtractDays: aNumber!

+ aNumber 

	"Janko Mivsek, dec97"
	"add one day to a date."

	^self addDays: aNumber!

monthAndDayString
	"with leading zeros, example: 05-16 for 16may"
	^(self monthIndex < 10 ifTrue: ['0'] ifFalse: ['']), self monthIndex printString, '-',
	 	(self dayOfMonth < 10 ifTrue: ['0'] ifFalse: ['']), self dayOfMonth printString

"Date today monthAndDayString"!

printISOString
	^self year printString, 
		(self monthIndex < 10 ifTrue: ['0'] ifFalse: ['']), self monthIndex printString,
		(self dayOfMonth < 10 ifTrue: ['0'] ifFalse: ['']), self dayOfMonth printString

"Date today printISOString   "!

shorterPrintSloString
	"year in two digits only"
	| yeart |
	yeart := (self year \\ 100) printString. yeart size = 1 ifTrue: [yeart := '0', yeart].
	^self dayOfMonth printString, '.', self monthIndex printString, '.', yeart.

"Date today shorterPrintSloString"!

shortPrintSloString
	^self dayOfMonth printString, '.', self monthIndex printString, '.', self year printString.

"Date today shortPrintSloString   "! !
!Date categoriesFor: #-!arithmetic!public! !
!Date categoriesFor: #+!arithmetic!public! !
!Date categoriesFor: #monthAndDayString!accessing!public! !
!Date categoriesFor: #printISOString!printing!public! !
!Date categoriesFor: #shorterPrintSloString!printing!public! !
!Date categoriesFor: #shortPrintSloString!printing!public! !

!Date class methodsFor!

nameOfSloDay: dayIndex 
	"Answer a symbol representing the slovenian name of the day indexed by 
	dayIndex, 1 - 7."
	^#('Ponedeljek' 'Torek' 'Sreda' 'C^etrtek' 'Petek' 'Sobota' 'Nedelja') at: dayIndex

"Date nameOfSloDay: 4"!

nameOfSloMonth: monthIndex 
	"Answer a symbol representing the slovenian name of the month indexed by 
	monthIndex, 1 - 12."
	^#(Januar Februar Marec April Maj Junij 
		Julij Avgust September Oktober November December)
		at: monthIndex!

readSloFrom: aStream
	"Answer a Date read from the argument aStream in any of
	 the forms:
		<day> <monthName> <year>		(5.April 198  5.april 1982 5.apr 82 5.apr 1982)
		<day><monthNumber> <year>	(5.4.82 5.4.1982 050482 05041992)
	If year missing, then current year is used!!
"

	"Date readSloFrom: '12.12' readStream"

	| string withDots alphaMonth day month year |
	string := aStream contents.
	(string size < 4) ifTrue: [^nil].
	withDots := string includes: $. .
	alphaMonth := true. string detect: [:ch | ch isAlphabetic] ifNone: [alphaMonth := false].
	withDots
		ifTrue: [alphaMonth 
			ifTrue: 
				[day := (aStream upTo: $. ) asInteger.
				[aStream peek = $ ] whileTrue: [aStream skip: 1].
				month := (aStream upTo: $ ).
				year := (aStream upToEnd) asInteger.
				(year = 0) ifTrue: [year := Date today year].

				]
			ifFalse: 	
				[day := (aStream upTo: $. ) asInteger.
				month := (aStream upTo: $. ) asInteger.
				year := (aStream upTo: $. ) asInteger.
				(year = 0) ifTrue: [year := Date today year].
				] ]
		ifFalse: [alphaMonth 
			ifTrue: []
			ifFalse: [
				day := (string copyFrom: 1 to: 2) asInteger.
				month := (string copyFrom: 3 to: 4) asInteger.
				(string size > 4)	
					ifTrue: [year := (string copyFrom: 5 to: string size) asInteger]
					ifFalse: [year := Date today year].
				] ].

	(year isKindOf: Integer) ifTrue:
		[(year < 100) ifTrue: 
			[(year < 20) ifTrue: [year := year + 2000] ifFalse: [year := year + 1900]].
		].
	(month isKindOf: String) ifTrue:
		[month := month select: [:ch | ch isAlphaNumeric].
		(month  isEmpty not & (month at: 1) isAlphabetic) ifTrue:
			[month := (month copyFrom: 1 to: 3) asLowercase.
			(month = 'jan') ifTrue: [month := 1]
				ifFalse: [(month = 'jan') ifTrue: [month := 1]
				ifFalse: [(month = 'feb') ifTrue: [month := 2]
				ifFalse: [(month = 'mar') ifTrue: [month := 3]
				ifFalse: [(month = 'apr') ifTrue: [month := 4]
				ifFalse: [(month = 'maj') ifTrue: [month := 5]
				ifFalse: [(month = 'jun') ifTrue: [month := 6]
				ifFalse: [(month = 'jul') ifTrue: [month := 7]
				ifFalse: [(month = 'avg') ifTrue: [month := 8]
				ifFalse: [(month = 'sep') ifTrue: [month := 9]
				ifFalse: [(month = 'okt') ifTrue: [month := 10]
				ifFalse: [(month = 'nov') ifTrue: [month := 11]
				ifFalse: [(month = 'dec') ifTrue: [month := 12]]]]]]]]]]]]].
			]
		].
	((day isKindOf: Integer) and:
		[(day between: 1 and: 31) and: 
			[(month isKindOf: Integer) and:
				[(month between: 1 and: 12) ]]]) ifFalse: [^nil].

	^Date newDay: day monthNumber: month year: year.! !
!Date class categoriesFor: #nameOfSloDay:!general inquiries!public! !
!Date class categoriesFor: #nameOfSloMonth:!general inquiries!public! !
!Date class categoriesFor: #readSloFrom:!instance creation!public! !

!HTTPConnection methodsFor!

representBinaryOn: aBossWriter
	^0 "don't boss-out it !! "! !
!HTTPConnection categoriesFor: #representBinaryOn:!private! !

!HTTPException class methodsFor!

failedDependency
	^self raiseResponse: (HTTPResponse new code: 424)!

insufficientStorage
	^self raiseResponse: (HTTPResponse new code: 507)!

locked
	^self raiseResponse: (HTTPResponse new code: 423)!

multiStatus
	^self raiseResponse: (HTTPResponse new code: 207)!

processing
	^self raiseResponse: (HTTPResponse new code: 102)!

unprocessableEntity
	^self raiseResponse: (HTTPResponse new code: 422)! !
!HTTPException class categoriesFor: #failedDependency!public!responses-client error! !
!HTTPException class categoriesFor: #insufficientStorage!public!responses-server error! !
!HTTPException class categoriesFor: #locked!public!responses-client error! !
!HTTPException class categoriesFor: #multiStatus!public!responses-succesfull! !
!HTTPException class categoriesFor: #processing!public!responses-informational! !
!HTTPException class categoriesFor: #unprocessableEntity!public!responses-client error! !

!HTTPPost methodsFor!

ajaxSingleInputName
	"Single form field Ajax posts have additional parameter carying the name of that field"
	^(self postDataAt: 'ajaxSingleField' ifAbsent: [^nil]) value!

postDataKeysNotStreamed
	"keys for a postData which is not streamed"
	self ensureFullRead. "defered parsing of postData"
	^(self postData underlyingCollection select: [:assoc | assoc value isStreamed not])
		collect: [:assoc | assoc key]! !
!HTTPPost categoriesFor: #ajaxSingleInputName!accessing!public! !
!HTTPPost categoriesFor: #postDataKeysNotStreamed!accessing!public! !

!HTTPRequest methodsFor!

ajaxContentElementId
	"for Ajax updates from contents of another element "
	"see WebElement>>onClickPopup:, WebApplication>>ajaxUpdate:with: etc."
	| id |
	id := self queryAt: 'ajaxContentElementId' ifAbsent: [nil].
	id notNil ifTrue: [^id asSymbol].
	^self isPost 
		ifTrue: [(self postDataAt: 'ajaxContentElementId' ifAbsent: [^nil]) value asSymbol]
		ifFalse: [nil]!

ajaxElementId
	"Asynchronous JavaScript (AJAX) request, it has additional parameter ajaxGetElementId"
	| id |
	id := self queryAt: 'ajaxGetElementId' ifAbsent: [nil].
	id notNil ifTrue: [^id asSymbol].
	^self isPost 
		ifTrue: [(self postDataAt: 'ajaxGetElementId' ifAbsent: [^nil]) value asSymbol]
		ifFalse: [nil]!

context
	"an execution context for that request"
	^self environmentAt: #context ifAbsent: [nil]!

context: aWebContext
	"an execution context for that request"
	self environmentAt: #context put: aWebContext!

contextId
	"unique id of the web context this request is executing. May be in query part or post data"
	| id |
	id := self queryAt: WebContext contextIdName "aidaCtx" ifAbsent: [nil].
	id notNil ifTrue: [^id asInteger].
	^self isPost 
		ifTrue: [(self postDataAt: WebContext contextIdName ifAbsent: [^nil]) value asInteger]
		ifFalse: [nil]!

idFromCookie
	"return session id from our cookie. nil if not aida field present in cookie"
	| stream part |
	stream := self cookie readStream.
	[stream atEnd] whileFalse:
		[part := stream upTo: $; .
		('*aida9357*' match: part) ifTrue:
			[^part readStream upTo: $=; upToEnd] ].
	^nil!

isAjaxAutocompleteRequest
	"AJAX autocomplete input field request, see WebAutocompleteField"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'ajaxAutocompleteField'!

isAjaxCloseWindowRequest
	"to Ajax close the window and its context (by WebElement>>addCloseWindowText: )"
	| parm2 |
	(self isPost and: [self isAjaxRequest]) ifFalse: [^false].
	parm2 := (self postDataAt: 'parm2').
	^parm2 notNil and: [parm2 value = 'aidaCloseWindow']!

isAjaxInPlaceEditingRequest
	"AJAX in place editor request, see WebInPlaceEditingText"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'ajaxInPlaceEditing'!

isAjaxPopupWindowRequest
	"to Ajax open some element in a popup window, (WebElement>>onClickPopup: )"
	| parm2 |
	(self isPost and: [self isAjaxRequest]) ifFalse: [^false].
	parm2 := (self postDataAt: 'parm2').
	^parm2 notNil and: [parm2 value = 'aidaPopupWindow']!

isAjaxPostRequest
	"Asynchronous JavaScript (AJAX) request, with posting an input field in a query"
	^self isAjaxRequest and: [self isPost]!

isAjaxPostWithInput
	"Asynchronous JavaScript (AJAX) request, with posting an input field in a post data"
	(self isPost and: [self isAjaxRequest]) ifFalse: [^false].
	^(self postDataKeys contains: [:each | 'field*' match: each]) 
		or: [self isAjaxPostWithSingleInput "uncheck a single checkbox doesn't have any additional field !! "
			or: [self postDataKeys includes: 'ajaxPressedButton'] ]!

isAjaxPostWithSingleInput
	"Ajax post with of one form element only"
	(self isPost and: [self isAjaxRequest]) ifFalse: [^false].
	^(self postDataKeys includes: 'ajaxSingleField')
		or: [self isAjaxAutocompleteRequest | self isAjaxInPlaceEditingRequest]!

isAjaxRequest
	"Asynchronous JavaScript (AJAX) request, it has additional parameter ajaxRequest"
	^(self headerAt: 'X-Requested-With' ifAbsent: [^false]) value = 'XMLHttpRequest'!

isAjaxWikiFormatedRequest
	"AJAX in place editor request, see WebInPlaceEditingText"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'wikiFormated'!

isCopy
	^false!

isLock
	^false!

isMkCol
	^false!

isMove
	^false!

isPing
	"/ping.html, for monitoring the site etc."
	^self requestLine requestURI identifier = '/ping.html'!

isPropFind
	^false!

isPropPatch
	^false!

isUnlock
	^false!

view
	| view |
	view := self queryAt: 'view' ifAbsent: [nil].
	view notNil ifTrue: [^(view readStream upTo: $# )  asSymbol]. "skip #anchor if any"
	^self isPost 
		ifTrue: [(self postDataAt: 'view' ifAbsent: [^nil]) value asSymbol]
		ifFalse: [nil]! !
!HTTPRequest categoriesFor: #ajaxContentElementId!accessing-queries!public! !
!HTTPRequest categoriesFor: #ajaxElementId!accessing-queries!public! !
!HTTPRequest categoriesFor: #context!accessing!public! !
!HTTPRequest categoriesFor: #context:!accessing!public! !
!HTTPRequest categoriesFor: #contextId!accessing-queries!public! !
!HTTPRequest categoriesFor: #idFromCookie!accessing!public! !
!HTTPRequest categoriesFor: #isAjaxAutocompleteRequest!public!testing! !
!HTTPRequest categoriesFor: #isAjaxCloseWindowRequest!public!testing! !
!HTTPRequest categoriesFor: #isAjaxInPlaceEditingRequest!public!testing! !
!HTTPRequest categoriesFor: #isAjaxPopupWindowRequest!public!testing! !
!HTTPRequest categoriesFor: #isAjaxPostRequest!public!testing! !
!HTTPRequest categoriesFor: #isAjaxPostWithInput!public!testing! !
!HTTPRequest categoriesFor: #isAjaxPostWithSingleInput!public!testing! !
!HTTPRequest categoriesFor: #isAjaxRequest!public!testing! !
!HTTPRequest categoriesFor: #isAjaxWikiFormatedRequest!public!testing! !
!HTTPRequest categoriesFor: #isCopy!public!testing! !
!HTTPRequest categoriesFor: #isLock!public!testing! !
!HTTPRequest categoriesFor: #isMkCol!public!testing! !
!HTTPRequest categoriesFor: #isMove!public!testing! !
!HTTPRequest categoriesFor: #isPing!public!testing! !
!HTTPRequest categoriesFor: #isPropFind!public!testing! !
!HTTPRequest categoriesFor: #isPropPatch!public!testing! !
!HTTPRequest categoriesFor: #isUnlock!public!testing! !
!HTTPRequest categoriesFor: #view!accessing-queries!public! !

!HTTPResponse class methodsFor!

failedDependency
	^super new code: 424!

insufficientStorage
	^super new code: 507!

locked
	^super new code: 423!

multiStatus
	^super new code: 207!

noContent
	^super new code: 204; entity: ''!

processing
	^super new code: 102!

unprocessableEntity
	^super new code: 422! !
!HTTPResponse class categoriesFor: #failedDependency!public!response types! !
!HTTPResponse class categoriesFor: #insufficientStorage!public!response types! !
!HTTPResponse class categoriesFor: #locked!public!response types! !
!HTTPResponse class categoriesFor: #multiStatus!public!response types! !
!HTTPResponse class categoriesFor: #noContent!public!response types! !
!HTTPResponse class categoriesFor: #processing!public!response types! !
!HTTPResponse class categoriesFor: #unprocessableEntity!public!response types! !

!HTTPServer methodsFor!

representBinaryOn: aBossWriter
	"don't boss-out http server "
	^0! !
!HTTPServer categoriesFor: #representBinaryOn:!private! !

!Magnitude methodsFor!

asString
	^self printString! !
!Magnitude categoriesFor: #asString!public!squeak-converting! !

!Number methodsFor!

printDotString

	"Janko Mivsek, 1997"
	"format and return the number with dots between thousandths:  '3.120.123' "

	| mrds millions thousanths rest text number |
	number := self abs.
	mrds := number // 1000000000.
	millions := (number \\ 1000000000)  // 1000000.
	thousanths := (number \\ 1000000) // 1000.
	rest := (number \\ 1000).
	text := ''.
	mrds > 0 ifTrue: 
		[text := mrds printString, '.', (millions withZeros), '.', 
		(thousanths withZeros), '.', (rest withZeros).
		^text].
	millions > 0 	ifTrue: 
		[text := millions printString, '.', 
		(thousanths withZeros), '.', (rest withZeros).
		^text].
	thousanths > 0 
		ifTrue: 
			[text := thousanths printString, '.', 
			(rest withZeros)]
		ifFalse: [text := rest printString].
	^(self < 0 ifTrue: ['- '] ifFalse: ['']), text

"
-123 printDotString  '- 123'
"!

withZeros

	"return three digit number with leading zeros"

	^(self < 100 ifTrue: ['0'] ifFalse: ['']), 
	(self < 10 ifTrue: ['0'] ifFalse: ['']), 
	self printString.! !
!Number categoriesFor: #printDotString!printing!public! !
!Number categoriesFor: #withZeros!printing!public! !

!Object methodsFor!

aidaCacheTimeout
	"how many seconds this object is globally cached in site's global cache"
	"nil = global default, set in site's global cache settings"
	^nil!

aidaCacheView: aSymbol on: aWebSession
	"if true, then this object's view will be globally cached in site's cache"
	^false!

aidaCanBeLocked
	"can we get an exclusive lock on that object (not already locked)?"
	^false!

aidaDeepCopy
	"Answer a copy of the receiver and copy down all its objects reachable from him"

	| objectDictionary |
	objectDictionary := IdentityDictionary new.
	^self aidaDeepCopyNotIn: objectDictionary.!

aidaDeepCopyNotIn: aDictionary

	"Answer a copy of the receiver and copy down all its objects reachable from him. If altready in aDictionary, then not copy, return reference to already copied object"

	| class newObject index |

	self isNil ifTrue: [^self].
	(aDictionary includesKey: self) ifTrue:
		[^aDictionary at: self].

	class := self class.
	newObject := self copy.
	aDictionary at: self put: newObject.
	class isVariable
		ifTrue: 
			[class isPointers 
				ifTrue: 
					[index := self basicSize.
					1 to: index do:
						[ :i |  newObject basicAt: i put: 
							((self basicAt: i) aidaDeepCopyNotIn: aDictionary)  ]]
				ifFalse: ["already copied by self copy"] ]

		ifFalse: ["already copied by self copy"].
		
	1 to: class instSize do:
		[ :inx |  newObject 
				instVarAt: inx
				put: ((self instVarAt: inx) aidaDeepCopyNotIn: aDictionary)  
		].
	^newObject!

aidaDontCache
	"don't cache web content in a browser. Appropriate header is added to http response"
	^false!

aidaIsAssociation
	"used for Aida/Web translation support, multilingual strings are namelly assocs: #fr->'Bonjour'"
	^false!

aidaIsLocked
	"is object locked exclusively?"
	^false!

aidaLock
	"get an exclusive lock on that object. Until unlocked, noone else can get that lock. Return false if already locked, true if successfull"
	^false!

aidaUnlock
	"release an exclusive lock if any"
	^true!

app
	"fastest and most convinient way to find a web app for that object"
	^self webAppFor: self firstSessionFromStack!

contentType

	"Janko Mivsek, apr98"
	"return 'text/html' as content type for web pages"

	^'text/html'!

deepSearchOfClass: aClassName
	"finf all objects of that class down in object hierarchy"
	| objectDictionary class |
	objectDictionary := IdentityDictionary new.
	self aidaDeepCopyNotIn: objectDictionary.
	class := aClassName asSymbol.
	^objectDictionary keys select: [:each | each class name = class].!

deepSearchOfObsoleteClasses
	"finf all objects of obsolete classes down in object hierarchy"
	| objectDictionary |
	objectDictionary := IdentityDictionary new.
	self aidaDeepCopyNotIn: objectDictionary.
	^objectDictionary keys select: [:each | each class isObsolete].!

expiresTimestamp
	"until when content of this object wont be changed"
	"used in http response, override if you like to be included"
	^self modifiedTimestamp  "to reload pages immediately"!

firstAppFromStack
	"try to find a first sender up in calling stack, who is  WebApplication"
	"FROM AIDA 5 for Dolphin"

	| stackFrame |

	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: WebApplication) ifTrue: [^stackFrame receiver].
		stackFrame := stackFrame sender].
	^self firstContextFromStack app

"	| stContext |
	stContext := thisContext.
	[stContext notNil] whileTrue: [
		(stContext receiver isKindOf: WebApplication) ifTrue: [^stContext receiver].
		stContext := stContext sender].
	^self firstContextFromStack app"!

firstContextFromStack
	"try to find a first web execution context"
	"have we something faster?"
	| request |
	request := self firstRequestFromStack.
	^request notNil 
		ifTrue: [request context] 
		ifFalse: [nil]!

firstRequestFromStack
	"try to find a first sender up in calling stack, which is AIDASite or WebContext and get request of that call"
	"VW specific!! "
	| stackFrame |

	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: AIDASite) ifTrue: [^stackFrame at: 2].
		stackFrame := stackFrame sender].

	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: WebContext) ifTrue: [^stackFrame receiver request].
		stackFrame := stackFrame sender].

	^nil

	"| stContext |

	stContext := thisContext.
	[stContext notNil] whileTrue: [
		(stContext receiver isKindOf: AIDASite) ifTrue: [^(stContext localAt: 2) ].
		stContext := stContext sender].
	stContext := thisContext.         
	[stContext notNil] whileTrue: [
		(stContext receiver isKindOf: WebContext) ifTrue: [^stContext receiver request].
		stContext := stContext sender].
	^nil"!

firstSessionFromStack
	"try to find a first sender up in calling stack, which is App, AIDASite or WebContext and get session if that call"
	"	FROM AIDA 5 for Dolphin"
	| stackFrame |

	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: WebApplication) ifTrue: [^stackFrame receiver session].
		stackFrame := stackFrame sender].

	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: WebContext) ifTrue: [^stackFrame receiver app session].
		stackFrame := stackFrame sender].

	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: AIDASite) ifTrue: [^stackFrame at: 3].
		stackFrame := stackFrame sender].
	^nil

"	| stContext |
	stContext := thisContext.
	[stContext notNil] whileTrue: [
		(stContext receiver isKindOf: WebApplication) ifTrue: [^stContext receiver session].
		stContext := stContext sender].
	stContext := thisContext.
	[stContext notNil] whileTrue: [
		(stContext receiver isKindOf: WebContext) ifTrue: [^stContext receiver app session].
		stContext := stContext sender].
	stContext := thisContext.
	[stContext notNil] whileTrue: [
		(stContext receiver isKindOf: AIDASite) ifTrue: [^(stContext localAt: 3)].
		stContext := stContext sender].
	^nil"!

forLanguage: aLanguageCodeSymbol
	"for multilingual support: returns an apropriate instance of itself for that language. Langage is defined 
	by ISO 639 2-letter language code, see http://en.wikipedia.org/wiki/List_of_ISO_639-1_codes"
	^false!

isMultilingual
	"for multilingual support: override this if your domain object responds to #forLanguage: and returns an        apropriate instance of itself for that language"
	^false!

isVersionedObject
	^false!

isWebApplication
	^false!

isWebStyle
	^false!

modifiedTimestamp
	"when this object was last modified"
	"used in http response, override if you like to be included"
	^nil!

notEmpty
	" Private.  GBS.  Answer true if the receiver contains at least one element.
	   NOTE:  This really belongs in class Collection, but it conflicts with the ENVY method of the same name. "

	^ self isEmpty not!

preferedUrl
	"override with a suggestion for url of this method!! If not already used, 
	it will be considered by URLResolver during automatic url generation"
	^nil!

printWebAppNotFoundFor: aSession 
	| page |
	page := WebPage new.
	page addText: 'Cannot find aWebApplication for object a', self class name.
	^page!

printWebPageFor: aRequest on: aSession 
	"find appropriate web application to represent self as web page"

	| webApp |
	webApp := self webAppFor: aSession.
	^webApp notNil 
		ifTrue: [webApp printWebPageFor: aRequest]
		ifFalse: [self printWebAppNotFoundFor: aSession]!

sendOver: aStream 
	"from Wiki rendering"
	self printOn: aStream! !
!Object categoriesFor: #aidaCacheTimeout!AIDA web!public! !
!Object categoriesFor: #aidaCacheView:on:!AIDA web!public! !
!Object categoriesFor: #aidaCanBeLocked!AIDA web-locks!public! !
!Object categoriesFor: #aidaDeepCopy!copying!public! !
!Object categoriesFor: #aidaDeepCopyNotIn:!copying!public! !
!Object categoriesFor: #aidaDontCache!AIDA web!public! !
!Object categoriesFor: #aidaIsAssociation!AIDA web!public! !
!Object categoriesFor: #aidaIsLocked!AIDA web-locks!public! !
!Object categoriesFor: #aidaLock!AIDA web-locks!public! !
!Object categoriesFor: #aidaUnlock!AIDA web-locks!public! !
!Object categoriesFor: #app!AIDA web!public! !
!Object categoriesFor: #contentType!AIDA web!public! !
!Object categoriesFor: #deepSearchOfClass:!copying!public! !
!Object categoriesFor: #deepSearchOfObsoleteClasses!copying!public! !
!Object categoriesFor: #expiresTimestamp!AIDA web!public! !
!Object categoriesFor: #firstAppFromStack!aida port error!AIDA web-stack climbing!public! !
!Object categoriesFor: #firstContextFromStack!aida port error!AIDA web-stack climbing!public! !
!Object categoriesFor: #firstRequestFromStack!aida port error!AIDA web-stack climbing!public! !
!Object categoriesFor: #firstSessionFromStack!aida port error!AIDA web-stack climbing!public! !
!Object categoriesFor: #forLanguage:!AIDA web!public! !
!Object categoriesFor: #isMultilingual!AIDA web!public! !
!Object categoriesFor: #isVersionedObject!AIDA web!public! !
!Object categoriesFor: #isWebApplication!AIDA web!public! !
!Object categoriesFor: #isWebStyle!AIDA web!public! !
!Object categoriesFor: #modifiedTimestamp!AIDA web!public! !
!Object categoriesFor: #notEmpty!public!testing! !
!Object categoriesFor: #preferedUrl!AIDA web!public! !
!Object categoriesFor: #printWebAppNotFoundFor:!AIDA web!public! !
!Object categoriesFor: #printWebPageFor:on:!AIDA web!public! !
!Object categoriesFor: #sendOver:!printing!public! !

!OrderedCollection methodsFor!

moveDown: anElement
	"move that element down (after current position) in a collection"
	| inx |
	(self notEmpty and: [self last = anElement]) ifTrue: [^self].
	inx := self indexOf: anElement.
	self add: anElement beforeIndex: inx+2.
	self removeAtIndex: inx

"#(1 2 3) asOrderedCollection moveDown: 1"!

moveUp: anElement
	"move that element up (before current position) in a collection"
	| inx |
	(self notEmpty and: [self first = anElement]) ifTrue: [^self].
	inx := self indexOf: anElement.
	self add: anElement beforeIndex: inx-1.
	self removeAtIndex: inx+1

"#(1 2 3) asOrderedCollection moveUp: 3"! !
!OrderedCollection categoriesFor: #moveDown:!adding!public! !
!OrderedCollection categoriesFor: #moveUp:!adding!public! !

!PositionableStream methodsFor!

bcrlf

	"Janko Mivsek, Oct1996"
	"write to a stream binary codes for CR and LF"

	self nextPut: (Character cr) asInteger.
	self nextPut: (Character lf) asInteger.!

insensitivePeekForAll: aCollection 
	| orig |
	self atEnd ifTrue: [^false].
	orig := self position.
	((self nextAvailable: aCollection size) sameAs: aCollection) 
		ifTrue: [^true].
	self position: orig.
	^false!

insensitiveSkipThroughAll: aCollection 
	| first length |
	(length := aCollection size) = 0 ifTrue: [^self].
	first := aCollection at: 1.
	[self atEnd] whileFalse: 
			[(self next sameAs: first) 
				ifTrue: 
					[| nonMatch |
					nonMatch := 2.
					
					[nonMatch > length ifTrue: [^self	"Success."].
					self atEnd ifTrue: [^nil].	"Not found."
					self next sameAs: (aCollection at: nonMatch)] 
							whileTrue: [nonMatch := nonMatch + 1].
					self skip: 1 - nonMatch	"Didn't match, back up."]].
	^nil	"Not found."!

insensitiveUpToAll: aCollection 
	| first length newStream |
	(length := aCollection size) = 0 ifTrue: [^self].
	first := aCollection at: 1.
	newStream := (self contentsSpecies new: 64) writeStream.
	[self atEnd] whileFalse: 
			[| element |
			element := self next.
			(element sameAs: first) 
				ifTrue: 
					[| nonMatch |
					nonMatch := 2.
					
					[nonMatch > length ifTrue: [^newStream contents	"Success."].
					self atEnd 
						ifTrue: 
							[1 to: nonMatch - 1 do: [:i | newStream nextPut: (aCollection at: i)].
							^newStream contents	"Not found."].
					self next sameAs: (aCollection at: nonMatch)] 
							whileTrue: [nonMatch := nonMatch + 1].
					self skip: 1 - nonMatch	"Didn't match, back up."].
			newStream nextPut: element].
	^newStream contents	"Not found."!

peekForAll: aCollection 
	| orig |
	self atEnd ifTrue: [^false].
	orig := self position.
	(self nextAvailable: aCollection size) = aCollection ifTrue: [^true].
	self position: orig.
	^false!

readLimit
	^readLimit! !
!PositionableStream categoriesFor: #bcrlf!constants!public! !
!PositionableStream categoriesFor: #insensitivePeekForAll:!positioning!public! !
!PositionableStream categoriesFor: #insensitiveSkipThroughAll:!positioning!public! !
!PositionableStream categoriesFor: #insensitiveUpToAll:!positioning!public! !
!PositionableStream categoriesFor: #peekForAll:!positioning!public! !
!PositionableStream categoriesFor: #readLimit!accessing!public! !

!SpDate methodsFor!

currentMonth
	^self currentYear and: [self monthIndex = SpDate today monthIndex]!

currentYear
	^self year = SpDate today year!

firstDayInMonth
	^SpDate newDay: 1 month: self monthIndex year: self year!

firstDayInNextMonth
	^SpDate 
		newDay: 1 
		month: (self lastDayInMonth addDays: 1) monthIndex
		year: (self lastDayInMonth addDays: 1) year!

firstDayInNextYear
	^SpDate 
		newDay: 1
		month: self firstDayInMonth monthIndex
		year: self firstDayInMonth year + 1!

firstDayInPreviousMonth
	^SpDate 
		newDay: 1
		month: (self firstDayInMonth subtractDays: 1) monthIndex
		year: (self firstDayInMonth subtractDays: 1) year!

firstDayInPreviousYear
	^SpDate 
		newDay: 1
		month: self firstDayInMonth monthIndex
		year: self firstDayInMonth year + 1!

lastDayInMonth
	^SpDate newDay: self daysInMonth month: self monthIndex year: self year!

shortPrintSloString
	^self dayOfMonth printString, '.', self monthIndex printString, '.', self year printString.

"SpDate today shortPrintSloString   "! !
!SpDate categoriesFor: #currentMonth!accessing!public! !
!SpDate categoriesFor: #currentYear!accessing!public! !
!SpDate categoriesFor: #firstDayInMonth!accessing!public! !
!SpDate categoriesFor: #firstDayInNextMonth!accessing!public! !
!SpDate categoriesFor: #firstDayInNextYear!accessing!public! !
!SpDate categoriesFor: #firstDayInPreviousMonth!accessing!public! !
!SpDate categoriesFor: #firstDayInPreviousYear!accessing!public! !
!SpDate categoriesFor: #lastDayInMonth!accessing!public! !
!SpDate categoriesFor: #shortPrintSloString!printing!public! !

!SpTimestamp methodsFor!

printSloString
	^self underlyingTimestamp printSloString! !
!SpTimestamp categoriesFor: #printSloString!private! !

!Stream methodsFor!

lf
	"Janko Mivsek"
	"Append a linefeed character to the receiver."

	self nextPut: Character lf!

upTo: anObject escaper: anotherObject 
	"from WikiWorks"
	| newStream |
	newStream := (self contentsSpecies new: 64) writeStream.
	[self atEnd] whileFalse: 
			[| element |
			(element := self next) = anotherObject 
				ifTrue: 
					[newStream nextPut: ((self peekFor: anObject) 
								ifTrue: [anObject]
								ifFalse: [anotherObject])]
				ifFalse: 
					[element = anObject ifTrue: [^newStream contents].
					newStream nextPut: element]].
	^newStream contents! !
!Stream categoriesFor: #lf!character writing!public! !
!Stream categoriesFor: #upTo:escaper:!accessing!public! !

!String methodsFor!

aidaIsAssociation
	"used for Aida/Web translation support, multilingual strings are namelly assocs: #fr->'Bonjour'"
	^false!

asCollectionOfHtmlHeadings
	"find all headings H1-5 and return a collection of headings, complete with tags"
	| in tag collection line |
	in := self readStream. collection := OrderedCollection new.
	[in atEnd] whileFalse:
		[in upTo: $<. in atEnd ifFalse: [tag := in upTo: $>].
		(tag size >= 2 and: [tag first asLowercase = $h and: [(tag at: 2) isDigit]] ) ifTrue:
			[tag := String with: $h with: (tag at: 2). "cleaned, without any parms!!"
			line := '<', tag, '>', (in upToAll: '</', tag, '>'), '</', tag, '>'. 
			collection add: line] ].
	^collection

" '<h1>Heading1</h1><h2>Heading2</h2>' asCollectionOfHtmlHeadings"
" '<h1><b>Heading1</b></h1>' asCollectionOfHtmlHeadings"!

asDouble

	"Janko Mivsek, TRIS A d.o.o. dec97"
	"convert a string to a double precision floating point number"

	| clean pos exponent result sign |
	sign := self detect: [:ch | ch = $- | ch isDigit].
	sign = $- ifTrue: [sign := -1] ifFalse: [sign := 1].
	clean := self select: [:ch | ch isDigit | (ch = $,)].
	pos := clean indexOf: $,.
	pos = 0 
		ifTrue: [result := clean asInteger asFloat]
		ifFalse: 
			[exponent := pos - 2.
			clean := clean select: [:ch | ch isDigit].
			result := 0.0d.
			clean do: [:digit | 
				result := result + ((digit asInteger - $0 asInteger) * (10**exponent)).
				exponent := exponent - 1]].
	^result * sign
"
'-2.445.444,988899987' asDouble 
"!

asFloat

	"Janko Mivsek, TRIS A d.o.o. dec97"
	"convert a string to a floating point number"

	| clean pos exponent result sign |
	sign := self detect: [:ch | ch = $- | ch isDigit].
	sign = $- ifTrue: [sign := -1] ifFalse: [sign := 1].
	clean := self select: [:ch | ch isDigit | (ch = $,)].
	pos := clean indexOf: $,.
	pos = 0 
		ifTrue: [result := clean asInteger asFloat]
		ifFalse: 
			[exponent := pos - 2.
			clean := clean select: [:ch | ch isDigit].
			result := 0.0.
			clean do: [:digit | 
				result := result + ((digit asInteger - $0 asInteger) * (10**exponent)).
				exponent := exponent - 1]].
	^result * sign
"
'-24,9' asFloat
"!

asHttpFriendly
	"Usefull specially for Url composition (like in preferedUrl). Converts all non Url friendly 
	characters to '-'. 	Caution, / is also converted!! Unicode is allowed "
	| nonallowed |
	nonallowed := #($ $+ $: $> $< $= $/ #\ $~).
	^self collect: 
		[:ch | (nonallowed includes: ch)
			ifTrue: [$-]
			ifFalse: [ch] ]

" '1+1=3/4' asHttpFriendlyUrl"!

asInteger

	"Janko Mivsek, TRIS A d.o.o. sep96"
	"convert a string to an integer number"

	| number sign |
	self isEmpty ifTrue: [^0].
	sign := self detect: [:ch | ch = $- | ch isDigit] ifNone: [$+].
	sign = $- ifTrue: [sign := -1] ifFalse: [sign := 1].
	number := 0.
	self do: [:char | char isDigit ifTrue: 
		[number := number * 10.
		number := number + (char asInteger - $0 asInteger)]].
	^number * sign

"
' ' asInteger
"!

asSloveneWithoutCircumflexes
	"convert Unicode csz string with ^ (sumniki) to plain ascii csz"
	"'c^s^z^C^S^Z^' convertToSloveneChars asSloveneWithoutCircumflexes"
	^self collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch = AIDASite charc ifTrue: [$c]
					ifFalse: [ ch  = AIDASite charC ifTrue: [$C]
					ifFalse: [ ch  = AIDASite chars ifTrue: [$s]
					ifFalse: [ ch  = AIDASite charS ifTrue: [$S]
					ifFalse: [ ch  = AIDASite charz ifTrue: [$z] 
					ifFalse: [ ch  = AIDASite charZ ifTrue: [$Z]
					ifFalse: [$- ] ]]]]]
				]
			ifFalse: [ch] ]!

containsSubstring: aString
	^(self 
		indexOfSubCollection: aString 
		startingAt: 1) > 0!

contentsAsMethod
	"return a body of method with a literal array with contents of that string"
	| input output |
	input := self readStream.
	output := WriteStream with: String new.
	output nextPutAll: '^#['.
	[input atEnd] whileFalse: [output nextPutAll: input next asInteger asString; nextPut: $ ].
	output nextPutAll: ']'.
	^output contents

" 'visual.cha' contentsAsMethod "!

convertToSloveneChars
	"convert csz string with ^ as 'sumnik' to proper unicode string. 
	Only pure ASCII strings are converted!!"
	"'Mivs^ek' convertToSloveneChars"
	| in out ch |
"	self class == ByteString ifFalse: [^self]. " "what if there is a mixed string, some unicode already?"
	in := self readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse: 
		[ch := in next.
		(in peek = $^ ) ifTrue: [(#($c $C $s $S $z $Z) includes: ch) ifTrue: 
			[in next. 
			ch = $c ifTrue: [ch := AIDASite charc]. ch = $C ifTrue: [ch := AIDASite charC].
			ch = $s ifTrue: [ch := AIDASite chars]. 	ch = $S ifTrue: [ch := AIDASite charS].
			ch = $z ifTrue: [ch := AIDASite charz]. ch = $Z ifTrue: [ch := AIDASite charZ] ] ].
		out nextPut: ch].
	^out contents!

ensureUnicodeSloveneChars
	"if string has other that unicode slovene chars, try to correct them!!"
	"'Mivek' ensureUnicodeSloveneChars"
	| in out ch uniSet |
	in := self readStream. out := WriteStream on: String new. uniSet := AIDASite charCszSet. 
	[in atEnd] whileFalse: 
		[ch := in next.
		(ch asInteger < 128 or: [uniSet includes: ch])
			ifTrue: [out nextPut: ch]
			ifFalse: [out nextPut: 
				([(AIDASite convert: (String with: ch) fromCodepage: #'iso-8859-2') first]
					on: Error do: [:ex | ch]) ] ].
	^out contents!

isValidEMailAddress
	(self includes: $@) ifFalse: [^false].
	^(self trimBlanks contains: [:char | 
		char isAlphaNumeric not and: [(#($. $- $_  $@) includes: char) not] ]) not

" 'janko.mivsek@eranova.si' isValidEMailAddress"!

lineCount
	^(self occurrencesOf: Character cr) + 1!

lineCount: aNumber
	"count lines, consider breaks too if line is longer than aNumber chars"
	^self asArrayOfLines inject: 0 into: [:sum :each | sum + (each size // aNumber + 1) ]

"'12345 789 12345' lineCount: 10"
"'12345 789' lineCount: 10"!

plainEMailAddress
	"only plain email address, see example below"
	^(self includes: $<) 
		ifTrue: [self readStream upTo: $<; upTo: $>]
		ifFalse: [self].
	
" 'Janko Mivsek <janko.mivsek@eranova.si>' cleanEMailAddress"!

sendOver: aStream 
	"from Wiki rendering"
	aStream nextPutAll: self!

shortPrintSloString
	^self!

shrinkTo: aNumber
	"shrink to such characters and add ..."
	^((self contractTo: aNumber) readStream upToAll: '...'), 
		((self size > aNumber) ifTrue: ['...'] ifFalse: [''])

" 'sdwsfaaa  fdfaf adfddf' shrinkTo: 10 "!

trimNewlines
	"replace new lines with space"
	| in out |
	in := self readStream.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[out nextPutAll: (in upTo: Character cr).
		in atEnd ifFalse: [in peek = Character cr ifTrue: [in upTo: Character cr] ].
		out nextPut: $  ].
	^out contents

" 'y Michael A. <br>Prospero</span>' withoutHtmlTags trimNewlines "!

upToNumber
	"up to first number or separator"
	| out |
	out := String new writeStream.
	self do: [:ch | ch isDigit | ch isSeparator ifTrue: [^out contents]. out nextPut: ch].
	^out contents

" 'NAV-00-23' upToNumber "!

withHeadingAnchors
	"add anchors before all H1-5 tags, each with sequence number of that tag, eg: <a name=h-15>"
	| in out tag number |
	in := self readStream. number := 1.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[out nextPutAll: (in upTo: $<).
		in atEnd ifFalse: [tag := in upTo: $>] ifTrue: [^out contents].
		(tag size = 2 and: [tag first asLowercase = $h and: [tag last isDigit]] ) ifTrue:
			[out nextPutAll: '<a name="h-', number printString, '"></a>'. 
			number := number +1].
		out nextPutAll: '<', tag, '>'].
	^out contents

"'<h1>Heading1</h1><h2>Heading2</h2>' withHeadingAnchors"!

withHtmlBreaks
	"changes all cr with <br>"
	^self copyReplaceAll: (String with: Character cr) with: '<br>'

"('aaa', (String with: Character cr), 'bbb') withHtmlBreaks"!

withoutHtmlTags
	"strip all tags, replace <br> and <p> with cr"
	| in out tag |
	in := self readStream.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[out nextPutAll: (in upTo: $<).
		in atEnd ifFalse: [tag := in upTo: $>].
		(tag = 'br') | (tag = 'p') ifTrue: [out nextPut: Character cr ] ].
	^out contents

"'<span>by Michael A. <br>Prospero</span>' withoutHtmlTags"! !
!String categoriesFor: #aidaIsAssociation!public!testing! !
!String categoriesFor: #asCollectionOfHtmlHeadings!converting!public! !
!String categoriesFor: #asDouble!converting!public! !
!String categoriesFor: #asFloat!converting!public! !
!String categoriesFor: #asHttpFriendly!converting!public! !
!String categoriesFor: #asInteger!converting!public! !
!String categoriesFor: #asSloveneWithoutCircumflexes!converting!public! !
!String categoriesFor: #containsSubstring:!public!testing! !
!String categoriesFor: #contentsAsMethod!converting!public! !
!String categoriesFor: #convertToSloveneChars!converting!public! !
!String categoriesFor: #ensureUnicodeSloveneChars!converting!public! !
!String categoriesFor: #isValidEMailAddress!public!testing! !
!String categoriesFor: #lineCount!accessing!public! !
!String categoriesFor: #lineCount:!accessing!public! !
!String categoriesFor: #plainEMailAddress!converting!public! !
!String categoriesFor: #sendOver:!printing!public! !
!String categoriesFor: #shortPrintSloString!converting!public! !
!String categoriesFor: #shrinkTo:!converting!public! !
!String categoriesFor: #trimNewlines!converting!public! !
!String categoriesFor: #upToNumber!converting!public! !
!String categoriesFor: #withHeadingAnchors!converting!public! !
!String categoriesFor: #withHtmlBreaks!converting!public! !
!String categoriesFor: #withoutHtmlTags!converting!public! !

!SwazooServer methodsFor!

aidaDemoSite
	"return aidademo site. Create and make it default, if it not yet there"
	| siteName |
	siteName := 'aidademo'.
	(self siteNamed: siteName) isNil ifTrue:
		[AIDASite newNamed: siteName.
		AIDASite default: siteName.
		(AIDASite named: siteName) host: '*' ip: '*'  port: 8888].
	^self siteNamed: siteName!

aidaDemoStart
	self aidaDemoSite start.!

aidaDemoStop
	self aidaDemoSite stop.!

aidaSites
	^self sites select: [:each | each isKindOf: AIDASite]!

aidaStartOn: aPortNumber
	| site |
	site := self siteAnyHostAllInterfacesOnPort: aPortNumber.
	site isNil ifTrue: [site := self prepareAidaDemoSiteOnPort: aPortNumber].
	site start.
	^site!

isNightlyBackupTime
	"backup should be done at 4:30:00"
	"SwazooServer singleton isNightlyBackupTime"
	| backupTime |
	backupTime := SpTimestamp fromDate: Date today andTime: (Time readFrom: '4:30:00' readStream).
	^(SpTimestamp now asSeconds > backupTime asSeconds) & 
		(SpTimestamp now asSeconds < (backupTime asSeconds + self watchdogPeriod))!

isWatchdogRunning
	^self watchdog notNil "and: [self watchdog is not].  ?!!?"!

prepareAidaDemoSiteOnPort: aNumber
	"this site will run on all IP interfaces on that port"
	| name site |
	name := 'aidaOn', aNumber printString.
	site := AIDASite newNamed: name. "which is now also added to SwazoServer"
	site host: '*' ip: '*' port: aNumber.
	^site!

representBinaryOn: aBossWriter
	^0 "don't boss-out SwazoServer singleton!! "!

watchdogOther
	"override this if you like some other periodic activity"!

watchdogSites
	self sites do: [:each | each isServing ifTrue: 
		[(each isKindOf: AIDASite) ifTrue: [each setLastTimeAliveTimestamp]] ]! !
!SwazooServer categoriesFor: #aidaDemoSite!public!start/stop! !
!SwazooServer categoriesFor: #aidaDemoStart!public!start/stop! !
!SwazooServer categoriesFor: #aidaDemoStop!public!start/stop! !
!SwazooServer categoriesFor: #aidaSites!accessing!public! !
!SwazooServer categoriesFor: #aidaStartOn:!public!start/stop! !
!SwazooServer categoriesFor: #isNightlyBackupTime!private! !
!SwazooServer categoriesFor: #isWatchdogRunning!private! !
!SwazooServer categoriesFor: #prepareAidaDemoSiteOnPort:!private! !
!SwazooServer categoriesFor: #representBinaryOn:!private! !
!SwazooServer categoriesFor: #watchdogOther!private! !
!SwazooServer categoriesFor: #watchdogSites!private! !

!SwazooServer class methodsFor!

aidaDemoStart
	"SwazooServer aidaStart"
	"will start an Aida demo site on http://localhost:8888 "
	self singleton aidaDemoStart!

aidaDemoStop
	"SwazooServer aidaStop"
	self singleton aidaDemoStop!

aidaStartOn: aPortNumber
	"will start an Aida site on all ip interfaces, ignoring host"
	"if there is no Aida site yet, it created one named 'aidademo''"
	"be sure that it is only site!!"
	"SwazooServer aidaStartOn: 8765"
	self singleton aidaStartOn: aPortNumber! !
!SwazooServer class categoriesFor: #aidaDemoStart!public!start/stop! !
!SwazooServer class categoriesFor: #aidaDemoStop!public!start/stop! !
!SwazooServer class categoriesFor: #aidaStartOn:!public!start/stop! !

!Time methodsFor!

printSloString
	^"(self hours < 10 ifTrue: ['0'] ifFalse: [''])," self hours printString, ':',
		(self minutes < 10 ifTrue: ['0'] ifFalse: ['']), self minutes printString

"Time now printSloString"! !
!Time categoriesFor: #printSloString!printing!public! !

"End of package definition"!

"Source Globals"!

"Classes"!

Address guid: (GUID fromString: '{32C6403E-7D55-44A3-BD55-8A3C06055226}')!
Address comment: '"ECML v1.1 definition of address (www.ecml.org)"

Instance Variables:
	city	<Object>	description of city
	company	<Object>	description of company
	country	<Object>	description of country
	emails	<Object>	description of emails
	firstName	<Object>	description of firstName
	lastName	<Object>	description of lastName
	middleName	<Object>	description of middleName
	phones	<Object>	description of phones
	postalCode	<Object>	description of postalCode
	stateProvince	<Object>	description of stateProvince
	street	<Object>	description of street
	title	<Object>	description of title'!
!Address categoriesForClass!Unclassified! !
!Address methodsFor!

city
	city isNil ifTrue: [^''].
	^city!

city: aString
	city := aString.!

company
	company isNil ifTrue: [^''].
	^company!

company: aString
	company := aString.!

country
	country isNil ifTrue: [^''].
	^country!

country: aString
	country := aString.!

email
	self emails size > 0 ifTrue: [^self emails at: 1].
	^' '!

email: aString 
	self emails size > 0 ifTrue: [^self emails at: 1 put: aString].
	^self emails add: aString!

emails
	emails isNil ifTrue: [self initEMails].
	^emails!

fax
	fax isNil ifTrue: [^''].
	^fax!

fax: aString
	fax := aString.!

firstName
	firstName isNil ifTrue: [^''].
	^firstName!

firstName: aString
	firstName := aString.!

initEMails
	emails := OrderedCollection new.!

initPhones
	phones := OrderedCollection new.
	phones add: ''.!

lastName
	lastName isNil ifTrue: [^''].
	^lastName!

lastName: aString
	lastName := aString.!

middleName
	middleName isNil ifTrue: [^''].
	^middleName!

middleName: aString
	middleName := aString.!

migrateToUnicode
	"from iso8859-2"
	"Address allInstances do: [:each | each migrateToUnicode]"
	title notNil ifTrue: [title := title ensureUnicodeSloveneChars].
	firstName notNil ifTrue: [firstName := firstName ensureUnicodeSloveneChars].
	middleName notNil ifTrue: [middleName := middleName ensureUnicodeSloveneChars].
	lastName notNil ifTrue: [lastName := lastName ensureUnicodeSloveneChars].
	company notNil ifTrue: [company := company ensureUnicodeSloveneChars].
	street notNil ifTrue: [street := street ensureUnicodeSloveneChars].
	city notNil ifTrue: [city := city ensureUnicodeSloveneChars].
	country notNil ifTrue: [country := country ensureUnicodeSloveneChars].!

phone
	self phones size > 0 ifTrue: [^self phones first].
	^' '!

phone: aString
	self phones size > 0 ifTrue: [^self phones at: 1 put: aString].
	^self phones add: aString!

phones
	phones isNil ifTrue: [self initPhones].
	^phones!

post
	^self city!

post: anObject
	self city: anObject!

postalCode
	postalCode isNil ifTrue: [^''].
	^postalCode!

postalCode: aString
	postalCode := aString.!

stateProvince
	stateProvince isNil ifTrue: [^''].
	^stateProvince!

stateProvince: aString
	stateProvince := aString.!

street
	street isNil ifTrue: [^''].
	^street!

street: aString
	street := aString.!

title
	title isNil ifTrue: [^''].
	^title!

title: aString
	title := aString.! !
!Address categoriesFor: #city!accessing!public! !
!Address categoriesFor: #city:!accessing!public! !
!Address categoriesFor: #company!accessing!public! !
!Address categoriesFor: #company:!accessing!public! !
!Address categoriesFor: #country!accessing!public! !
!Address categoriesFor: #country:!accessing!public! !
!Address categoriesFor: #email!accessing!public! !
!Address categoriesFor: #email:!accessing!public! !
!Address categoriesFor: #emails!accessing!public! !
!Address categoriesFor: #fax!accessing!public! !
!Address categoriesFor: #fax:!accessing!public! !
!Address categoriesFor: #firstName!accessing!public! !
!Address categoriesFor: #firstName:!accessing!public! !
!Address categoriesFor: #initEMails!initialize - release!public! !
!Address categoriesFor: #initPhones!initialize - release!public! !
!Address categoriesFor: #lastName!accessing!public! !
!Address categoriesFor: #lastName:!accessing!public! !
!Address categoriesFor: #middleName!accessing!public! !
!Address categoriesFor: #middleName:!accessing!public! !
!Address categoriesFor: #migrateToUnicode!private! !
!Address categoriesFor: #phone!accessing!public! !
!Address categoriesFor: #phone:!accessing!public! !
!Address categoriesFor: #phones!accessing!public! !
!Address categoriesFor: #post!accessing!public! !
!Address categoriesFor: #post:!accessing!public! !
!Address categoriesFor: #postalCode!accessing!public! !
!Address categoriesFor: #postalCode:!accessing!public! !
!Address categoriesFor: #stateProvince!accessing!public! !
!Address categoriesFor: #stateProvince:!accessing!public! !
!Address categoriesFor: #street!accessing!public! !
!Address categoriesFor: #street:!accessing!public! !
!Address categoriesFor: #title!accessing!public! !
!Address categoriesFor: #title:!accessing!public! !

!Address class methodsFor!

replicationSpec
	"Gemstone"

	^super replicationSpec, 
		#(	(firstName replicate)
			(lastName replicate)
			(company replicate)
			(street replicate)
			(city replicate)
			(postalCode replicate)
			(country replicate)
			(phones max 4)
			(emails max 4)
		 )! !
!Address class categoriesFor: #replicationSpec!odb specific!public! !

AidaProfiling guid: (GUID fromString: '{633DB587-D625-4CDF-908F-3FDF2D5EC3F4}')!
AidaProfiling comment: ''!
!AidaProfiling categoriesForClass!Unclassified! !
!AidaProfiling methodsFor!

areadmeGemstone
	"a short description of how to profile, interpret results, why to profile etc."!

areadmeResultsGS
	"results, history of, short explanations"

"Gemstone64 2.2.5 Profiling of Aida/Web 5.6, 11.2.08, Janko Mivsek
[1000 timesRepeat: [site answerTo: req]]

elapsed CPU time:    23662 ms,  monitoring interval: 10 ms
24ms/req, 40 req/s"!

areadmeResultsVW
	"results, history of, short explanations"

"VW 7.6 Profiling of Aida/Web 5.6, 11.2.08, Janko Mivsek
[1000 timesRepeat: [site answerTo: req]]

707 samples, 20.03 average ms/sample, 1780 scavenges, 28 incGCs,
11.75s active, 2.35s other processes,
14.16s real time, 0.06s profiling overhead
12ms/req, 83 req/s"!

areadmeSqueak
	"a short description of how to profile, interpret results, why to profile etc."!

areadmeVW
	"a short description of how to profile, interpret results, why to profile etc."!

ensure100KBFile
	"dummy .jpg file"
	| fname stream |
	fname := SpFilename named: 'test100K.jpg'.
	fname exists ifFalse:
		[[stream := fname writeStream binary.
		100000 timesRepeat: [stream nextPut: 16rCE] "just something"]
			ensure: [stream close] ].! !
!AidaProfiling categoriesFor: #areadmeGemstone!profiling-gs!public! !
!AidaProfiling categoriesFor: #areadmeResultsGS!profiling-gs!public! !
!AidaProfiling categoriesFor: #areadmeResultsVW!profiling-vw!public! !
!AidaProfiling categoriesFor: #areadmeSqueak!profiling-squeak!public! !
!AidaProfiling categoriesFor: #areadmeVW!profiling-vw!public! !
!AidaProfiling categoriesFor: #ensure100KBFile!public!support! !

AIDAProtocolAdaptor guid: (GUID fromString: '{72B0F7BD-395E-4671-9F31-0BFAA86392D1}')!
AIDAProtocolAdaptor comment: ''!
!AIDAProtocolAdaptor categoriesForClass!Unclassified! !
!AIDAProtocolAdaptor methodsFor!

subject

	^subject!

subject: anObject

	subject := anObject!

value!

value: aValue! !
!AIDAProtocolAdaptor categoriesFor: #subject!accessing!public! !
!AIDAProtocolAdaptor categoriesFor: #subject:!accessing!public! !
!AIDAProtocolAdaptor categoriesFor: #value!accessing!public! !
!AIDAProtocolAdaptor categoriesFor: #value:!accessing!public! !

DailyCollection guid: (GUID fromString: '{60E0FA07-5AC0-4A2F-94E8-C1ABE1A7EE90}')!
DailyCollection comment: ''!
!DailyCollection categoriesForClass!Unclassified! !
!DailyCollection methodsFor!

add: newObject

	self add: newObject onDate: newObject date!

add: newObject onDate: aDate
	(self includes: newObject onDate: aDate) ifTrue: [^nil].
	self existCheckDate: aDate.
	(self days at: aDate asDays) add: newObject.
	^newObject!

addAll: aCollection 

	aCollection do: [:each | self add: each].
	^aCollection!

addAll: aCollection onDate: aDate

	self existCheckDate: aDate.
	^aCollection do: [:each | 	self add: each onDate: aDate].!

addFirst: newObject inYear: aYear
	"put in first place at 1st jan of this year"
	| date |
	date := Date newDay: 1 monthNumber: 1 year: aYear.
	(self includes: newObject onDate: date) ifTrue: [^nil].
	self existCheckDate: date.
	(self days at: date asDays) addFirst: newObject.
	^newObject!

addLast: newObject inYear: aYear
	"put in first place at 1st jan of this year"
	| date |
	date := Date newDay: 31 monthNumber: 12 year: aYear.
	(self includes: newObject onDate: date) ifTrue: [^nil].
	self existCheckDate: date.
	(self days at: date asDays) addLast: newObject.
	^newObject!

all
	| dayCol |
	dayCol := SortedCollection
		withAll: self days keys
		sortBlock: [:a :b | a > b].
	^dayCol inject: OrderedCollection new into: [:col :each | col addAll: (self days at: each); yourself ].!

allDated: aDate

	^(self days at: aDate asDays ifAbsent: [^#()] ) copy!

allDates
	"all dates on which something exist"
	^self allDays collect: [:each | Date fromDays: each]!

allDays
	"all day numbers on which something exist"
	^self days keys!

allDaysForKindOf: aClass
	"all day numbers on which something of that class exist"
	^self days keys select: [:day | 
		(self days at: day) contains: [:each | each isKindOf: aClass] ].!

allFromDate: aStartDate to: anEndDate
	| startDay endDay daysInRange |
	startDay := aStartDate asDays. endDay := anEndDate asDays.
	daysInRange := self allDays select: [:each | each >= startDay and: [each <= endDay] ].
	daysInRange := daysInRange asSortedCollection. 
	^daysInRange inject: OrderedCollection new into: [:col :each | col addAll: (self days at: each). col]

"DailyCollection allInstances last allFromDate: (Date readSloFrom: '1.1.2004' readStream) 
  	to: (Date readSloFrom: '31.12.2006' readStream)"!

allLastMonth
	^self allMonthly: Date today - Date today day!

allLastWeek
	^self allWeekly: Date today - 7!

allLastYear
	^self allYear: Date today year - 1!

allMonthly: aDate
	^self 
		allFromDate: aDate firstDayOfMonth
		to: aDate firstDayInMonth + aDate daysInMonth - 1!

allSinceDate: aDate
	^self allFromDate: aDate to: Date today!

allThisMonth
	^self allMonthly: Date today!

allThisWeek
	^self allWeekly: Date today!

allThisYear
	^self allYear: Date today year!

allToday
	^self allDated: Date today!

allWeekly: aDate
	^self 
		allFromDate: aDate - aDate weekdayIndex + 1
		to: aDate - aDate weekdayIndex + 1 + 7!

allYear: aNumber
	^self 
		allFromDate: (Date newDay: 1 monthNumber: 1 year: aNumber)
		to: (Date newDay: 31 monthNumber: 12 year: aNumber)!

allYears
	"all years on which something exist"
	^SortedCollection 
		withAll: (self allDates inject: Set new into: [:set :each | set add: each year. set])
		sortBlock: [:a :b | a < b]

"DailyCollection allInstances last allYears"!

allYearsForKindOf: aClass
	"all years on which something of that class exist"
	| allDays currentYear years skipToDay |
	allDays := self days keys asSortedCollection. allDays isEmpty ifTrue: [^#()].
	currentYear := (Date fromDays: allDays first) year.
	years := Set new. skipToDay := 0.
	allDays do: [:day |
		day >= skipToDay ifTrue:
			[((self days at: day) contains: [:entry | entry isKindOf: aClass]) ifTrue:
				[years add: currentYear. currentYear := currentYear + 1.
				skipToDay := (Date newDay: 1 monthNumber: 1 year: currentYear) asDays] ] ].
	^years asSortedCollection

"DailyCollection allInstances last allYearsForKindOf: AIDA.Invoice "!

allYesterday
	^self allDated: Date today - 1!

contains: aBlock 
	"Evaluate aBlock with each of the receiver's elements as the argument. 
	Answer true if aBlock ever evaluates to true, otherwise answer false."

	self detect: aBlock ifNone: [^false].
	^true!

days
	days isNil ifTrue: [self initDays].
	^days!

existCheckDate: aDate

	(self days includesKey: aDate asDays) ifFalse:
		[self days at: aDate asDays put: OrderedCollection new].!

firstDayInYear: aYear
	"on 1 januar of that year"
	^self allDated: (Date newDay: 1 monthNumber: 1 year: aYear).!

firstInYear: aYear
	"on 1st january of that year"
	| col |
	col := self firstDayInYear: aYear.
	col isEmpty ifTrue: [^nil].
	^col first!

includes: anObject
	"Answer whether anObject is one of the receiver's elements."

	self days values do: [:each | (each includes: anObject) ifTrue: [^true]].
	^false!

includes: anObject onDate: aDate
	| values |
	values := self days at: aDate asDays ifAbsent: [^false].
	^values includes: anObject!

initDays
	days := Dictionary new.!

isEmpty
	"Answer whether the receiver contains any elements."

	^self size = 0!

last: aNumber
	"find last number of values, starting from today and back in past. Most recent first!!"
	| collection dayColl |
	collection := OrderedCollection new.
	dayColl := SortedCollection withAll: self days keys sortBlock: [:a :b | a > b].
	dayColl do: [:day || coll |
		coll := (self days at: day) copy reverse.
		collection addAll: (coll copyFrom: 1 to: ((aNumber - collection size) min: coll size) ).
		collection size = aNumber ifTrue: [^collection] ].
	^collection

"LogisticSystem default owner events size last: 1000"!

lastDayInYear: aYear
	"on 31 december of that year"
	^self allDated: (Date newDay: 31 monthNumber: 12 year: aYear).!

move: anObject fromDate: aDate toDate: aNewDate
	| collection |
	collection := self days at: aDate asDays.
	collection remove: anObject.
	self add: anObject onDate: aNewDate!

remove: oldObject 
	^self remove: oldObject ifAbsent: [self notFoundError]!

remove: oldObject ifAbsent: anExceptionBlock
	| collection |
	collection := self days at: oldObject date asDays ifAbsent: [^anExceptionBlock value].
	collection remove: oldObject ifAbsent: [^anExceptionBlock value].!

removeAll: aCollection 
	"Remove each element of aCollection from the receiver.  If successful for each,
	answer aCollection."
	aCollection do: [:each | self remove: each].
	^aCollection!

size
	days isNil ifTrue: [^0].
	^self days values inject: 0 into: [:sum :each | sum + each size].! !
!DailyCollection categoriesFor: #add:!adding - removing!public! !
!DailyCollection categoriesFor: #add:onDate:!adding - removing!public! !
!DailyCollection categoriesFor: #addAll:!adding - removing!public! !
!DailyCollection categoriesFor: #addAll:onDate:!adding - removing!public! !
!DailyCollection categoriesFor: #addFirst:inYear:!adding - removing!public! !
!DailyCollection categoriesFor: #addLast:inYear:!adding - removing!public! !
!DailyCollection categoriesFor: #all!private-accessing!public! !
!DailyCollection categoriesFor: #allDated:!accessing!public! !
!DailyCollection categoriesFor: #allDates!accessing!public! !
!DailyCollection categoriesFor: #allDays!private-accessing!public! !
!DailyCollection categoriesFor: #allDaysForKindOf:!private-accessing!public! !
!DailyCollection categoriesFor: #allFromDate:to:!accessing!public! !
!DailyCollection categoriesFor: #allLastMonth!accessing!public! !
!DailyCollection categoriesFor: #allLastWeek!accessing!public! !
!DailyCollection categoriesFor: #allLastYear!accessing!public! !
!DailyCollection categoriesFor: #allMonthly:!accessing!public! !
!DailyCollection categoriesFor: #allSinceDate:!accessing!public! !
!DailyCollection categoriesFor: #allThisMonth!accessing!public! !
!DailyCollection categoriesFor: #allThisWeek!accessing!public! !
!DailyCollection categoriesFor: #allThisYear!accessing!public! !
!DailyCollection categoriesFor: #allToday!accessing!public! !
!DailyCollection categoriesFor: #allWeekly:!accessing!public! !
!DailyCollection categoriesFor: #allYear:!accessing!public! !
!DailyCollection categoriesFor: #allYears!accessing!public! !
!DailyCollection categoriesFor: #allYearsForKindOf:!private-accessing!public! !
!DailyCollection categoriesFor: #allYesterday!accessing!public! !
!DailyCollection categoriesFor: #contains:!public!testing! !
!DailyCollection categoriesFor: #days!private! !
!DailyCollection categoriesFor: #existCheckDate:!private! !
!DailyCollection categoriesFor: #firstDayInYear:!accessing!public! !
!DailyCollection categoriesFor: #firstInYear:!accessing!public! !
!DailyCollection categoriesFor: #includes:!public!testing! !
!DailyCollection categoriesFor: #includes:onDate:!public!testing! !
!DailyCollection categoriesFor: #initDays!private! !
!DailyCollection categoriesFor: #isEmpty!public!testing! !
!DailyCollection categoriesFor: #last:!accessing!public! !
!DailyCollection categoriesFor: #lastDayInYear:!accessing!public! !
!DailyCollection categoriesFor: #move:fromDate:toDate:!adding - removing!public! !
!DailyCollection categoriesFor: #remove:!adding - removing!public! !
!DailyCollection categoriesFor: #remove:ifAbsent:!adding - removing!public! !
!DailyCollection categoriesFor: #removeAll:!adding - removing!public! !
!DailyCollection categoriesFor: #size!accessing!public! !

DailyValues guid: (GUID fromString: '{3E04BFA9-B522-4404-AEFF-C5DEA209650E}')!
DailyValues comment: ''!
!DailyValues categoriesForClass!Unclassified! !
!DailyValues methodsFor!

allDates
	"all dates on which something exist"
	^self days keys collect: [:each | Date fromDays: each]!

allFromDate: aStartDate to: anEndDate

	| collection |
	collection := OrderedCollection new: 100.
	aStartDate to: anEndDate do: [:date |
		collection add: (self at: date) ].
	^collection!

allLastMonth
	^self allMonthly: Date today - Date today day!

allLastWeek
	^self allWeekly: Date today - 7!

allMonthly: aDate
	^self 
		allFromDate: aDate firstDayOfMonth
		to: aDate firstDayInMonth + aDate daysInMonth - 1!

allThisMonth
	^self allMonthly: Date today!

allThisWeek
	^self allWeekly: Date today!

allWeekly: aDate
	^self 
		allFromDate: aDate - aDate weekdayIndex + 1
		to: aDate - aDate weekdayIndex + 1 + 7!

at: aDate
	^self at: aDate ifAbsent: [self defaultValue]!

at: aDate add: aValue 
	self existCheckDate: aDate.
	^self days at: aDate asDays put: (self at: aDate) + aValue!

at: aDate ifAbsent: aBlock
	^self days at: aDate asDays ifAbsent: [aBlock value]!

at: aDate put: aValue
	self existCheckDate: aDate.
	^self days at: aDate asDays put: aValue!

at: aDate subtract: aValue
	self existCheckDate: aDate.
	^self days at: aDate asDays put: (self at: aDate) - aValue!

atOrLastFrom: aDate
	"return value on that date or last date when some value exist"
	^self at: aDate ifAbsent: [self lastFrom: aDate]!

days
	days isNil ifTrue: [self initDays].
	^days!

defaultValue
	^0!

existCheckDate: aDate

	(self days includesKey: aDate asDays) ifFalse:
		[self days at: aDate asDays put: self defaultValue].!

initDays
	days := IdentityDictionary new.!

isEmpty
	"Answer whether the receiver contains any elements."

	^self size = 0!

last
	"return value on last (most future) date entered"
	| coll |
	coll := self days keys asSortedCollection.  "not very optimized way for big colections!! "
	coll isNil ifTrue: [^nil].
	^self at: (Date fromDays: coll last)!

last: aNumber
	"find last number of values, starting from today and back in past. Most recent first!!"
	| collection |
	collection := OrderedCollection new.
	1 to: aNumber do: [:inx | collection add: (self at: Date today - inx + 1)].
	^collection!

lastDateFrom: aDate
	"search back in time for some date on which a value exist and return that date"
	| start |
	start := aDate asDays.
	self days keys asSortedCollection reverse do:  "not very optimized way for big colections!! "
		[:day | day <= start ifTrue: [^Date fromDays: day] ].
	^nil!

lastFrom: aDate
	"search back in time for some date on which a value exist and return it"
	| start |
	start := aDate asDays.
	self days keys asSortedCollection reverse do:  "not very optimized way for big colections!! "
		[:day | day <= start ifTrue: [^self days at: day] ].
	^nil!

resetAt: aDate
	"put default value at this date"
	^self at: aDate put: self defaultValue!

size
	^self days values size!

sumFromDate: aStartDate to: anEndDate

	^(self allFromDate: aStartDate to: anEndDate)
		inject: 0
		into: [:sum :each | sum + each]!

sumLast: aNumber
	"sum values of aNumber of days, starting from today and back"

	^(self last: aNumber)
		inject: 0
		into: [:sum :each | sum + each]!

sumMonthly: aDate

	^(self allMonthly: aDate)
		inject: 0
		into: [:sum :each | sum + each]!

sumWeekly: aDate

	^(self allWeekly: aDate)
		inject: 0
		into: [:sum :each | sum + each]! !
!DailyValues categoriesFor: #allDates!accessing!public! !
!DailyValues categoriesFor: #allFromDate:to:!accessing!public! !
!DailyValues categoriesFor: #allLastMonth!accessing!public! !
!DailyValues categoriesFor: #allLastWeek!accessing!public! !
!DailyValues categoriesFor: #allMonthly:!accessing!public! !
!DailyValues categoriesFor: #allThisMonth!accessing!public! !
!DailyValues categoriesFor: #allThisWeek!accessing!public! !
!DailyValues categoriesFor: #allWeekly:!accessing!public! !
!DailyValues categoriesFor: #at:!adding - removing!public! !
!DailyValues categoriesFor: #at:add:!adding - removing!public! !
!DailyValues categoriesFor: #at:ifAbsent:!adding - removing!public! !
!DailyValues categoriesFor: #at:put:!adding - removing!public! !
!DailyValues categoriesFor: #at:subtract:!adding - removing!public! !
!DailyValues categoriesFor: #atOrLastFrom:!adding - removing!public! !
!DailyValues categoriesFor: #days!private! !
!DailyValues categoriesFor: #defaultValue!private! !
!DailyValues categoriesFor: #existCheckDate:!private! !
!DailyValues categoriesFor: #initDays!private! !
!DailyValues categoriesFor: #isEmpty!public!testing! !
!DailyValues categoriesFor: #last!accessing!public! !
!DailyValues categoriesFor: #last:!accessing!public! !
!DailyValues categoriesFor: #lastDateFrom:!private! !
!DailyValues categoriesFor: #lastFrom:!private! !
!DailyValues categoriesFor: #resetAt:!adding - removing!public! !
!DailyValues categoriesFor: #size!accessing!public! !
!DailyValues categoriesFor: #sumFromDate:to:!accessing!public! !
!DailyValues categoriesFor: #sumLast:!accessing!public! !
!DailyValues categoriesFor: #sumMonthly:!accessing!public! !
!DailyValues categoriesFor: #sumWeekly:!accessing!public! !

DelimitedFile guid: (GUID fromString: '{088FF7BA-6812-482F-BE53-0362B858A59F}')!
DelimitedFile comment: ''!
!DelimitedFile categoriesForClass!Unclassified! !
!DelimitedFile methodsFor!

codepage
	codepage isNil ifTrue: [self codepage: self defaultCodepage].
	^codepage!

codepage: aSymbol
	" #utf8 #cp1250  #iso2 #'7bit'"
	codepage := aSymbol.!

crlf
	"return an cr-lf combination"

	^(Character cr) asSymbol ", (Character lf) asSymbol".!

defaultCodepage
	^#cp1250 "Windows"!

defaultDelimiter
	"default delimiter is ; "

	^$;!

delimiter
	"delimiter is a character, which separate fields in a delimited file"
	delimiter isNil ifTrue: [self delimiter: self defaultDelimiter].
	^delimiter!

delimiter: aCharacter
	"delimiter is a character, which separate fields in a delimited file"
	delimiter := aCharacter.!

endOfLine: aStream
	"return true if we are at the end of line (on cr or lf characters)"
	aStream peek isNil ifTrue: [^true].
	^(aStream peek = Character cr or: [aStream peek = Character lf]).!

filename
	^filename!

filename: aFilename
	filename := aFilename.!

initialize!

newRecordFrom: aStream

	"read one line from delimited file, detect and separate fields and convert to
	appropriate objects into an ordered collection. return that collection"

	| collection field |
	collection := OrderedCollection new.
	[self endOfLine: aStream] whileFalse:
		[field := self readFieldFrom: aStream.
		collection add: field].
	self skipEndOfLine: aStream.
	^collection!

readFieldFrom: aStream
	"read one field from delimited file, and convert to appropriate object. Return that object"
	| object stream |
	aStream peek = $" ifTrue:  "start of a text field"
		[object := aStream upTo: $"; upTo: $".
		(self endOfLine: aStream) ifFalse: [aStream upTo: self delimiter].
		^self codepage = #'7bit' 
			ifTrue: [AIDASite oldConvertToUnicode: (AIDASite returnCP852From7BitString: object)]
			ifFalse: [AIDASite convert: object fromCodepage: self codepage] ].
	stream := WriteStream on: String new.
	[aStream peek = self delimiter or: [self endOfLine: aStream]] 
		whileFalse: [aStream peek isNil ifTrue: [^stream contents]. stream nextPut: aStream next].
	aStream peek = self delimiter ifTrue: [aStream skip: 1].
	object := stream contents. stream close.
	^object
"
	(object includes: $. ) false
		ifTrue:
			[(Date readSloFrom: object readStream) notNil 
				ifTrue: [^Date readSloFrom: object readStream]
				ifFalse: [^object asInteger]]
		ifFalse: [^object asInteger].
"!

readFrom: aFilenameString
	"read a delimited file and convert content to object representation in 'records' collection"
	| stream | 
	self filename: aFilenameString asFilename.
	[stream :=  self filename readStream.
	self readFromStream: stream] 
		ensure: [stream close].

"DelimitedFile readFrom: 'm:\geoplin\tarifni\exports\ddnevnik.txt' "!

readFromStream: aStream
	"read a delimited file and convert content to object representation in 'records' collection"
	[aStream atEnd] whileFalse: [self records add: (self newRecordFrom: aStream)]!

records
	"when aDelimitedFile is created on a existing file, all records (lines in a file) are 
	converted and stored in this ordered collection. Fields in each record are stored in 
	another ordered collection as objects of appropriate class (texts as Strings, 
	numbers as Integers or Floats, dates as Dates)"

	records isNil ifTrue: [self records:OrderedCollection new].
	^records!

records: aCollection
	records := aCollection.!

skipEndOfLine: aStream

	"skip all cr and lf characters)"

	[aStream atEnd] whileFalse: 
		[(aStream peek = Character cr or: [aStream peek = Character lf]) 
			ifTrue:	[aStream skip: 1]
			ifFalse: [^self]
		].!

writeToFile
	self writeToFile: self filename.
"
|dmFile|
dmFile := DelimitedFile fileToWrite: 'test.dat'.
dmFile records 
	add: (Array with: 123 with: 'abcd' with: 345);
	add: (Array with: 234 with: 'CDE' with: 567).
dmFile writeToFile
"!

writeToFile: aFilenameString
	"export all records to delimited file"
	| stream | 
	self filename: aFilenameString asFilename.
	[stream :=  self filename writeStream.
	records do: [:record | self writeRecord: record to: stream] ]
		ensure: [stream close].
"
|dmFile|
dmFile := DelimitedFile new.
dmFile records 
	add: (Array with: 123 with: 'abcd' with: 345);
	add: (Array with: 234 with: 'CDE' with: 567).
dmFile writeToFile: 'test.dat'
"! !
!DelimitedFile categoriesFor: #codepage!accessing!public! !
!DelimitedFile categoriesFor: #codepage:!accessing!public! !
!DelimitedFile categoriesFor: #crlf!private! !
!DelimitedFile categoriesFor: #defaultCodepage!accessing!public! !
!DelimitedFile categoriesFor: #defaultDelimiter!accessing!public! !
!DelimitedFile categoriesFor: #delimiter!accessing!public! !
!DelimitedFile categoriesFor: #delimiter:!accessing!public! !
!DelimitedFile categoriesFor: #endOfLine:!private! !
!DelimitedFile categoriesFor: #filename!accessing!public! !
!DelimitedFile categoriesFor: #filename:!accessing!public! !
!DelimitedFile categoriesFor: #initialize!initialize - release!public! !
!DelimitedFile categoriesFor: #newRecordFrom:!private! !
!DelimitedFile categoriesFor: #readFieldFrom:!private! !
!DelimitedFile categoriesFor: #readFrom:!file reading!public! !
!DelimitedFile categoriesFor: #readFromStream:!file reading!public! !
!DelimitedFile categoriesFor: #records!accessing!public! !
!DelimitedFile categoriesFor: #records:!accessing!public! !
!DelimitedFile categoriesFor: #skipEndOfLine:!private! !
!DelimitedFile categoriesFor: #writeToFile!file writing!public! !
!DelimitedFile categoriesFor: #writeToFile:!file writing!public! !

!DelimitedFile class methodsFor!

fileToWrite: aFilenameString

	"create a new instance on a specified (empty) file to write. After you fill records attribute with all
	data, call writeToFile method to do actual exporting to this file"

	| instance |
	instance := self new.
	instance filename: aFilenameString asFilename.
	^instance.!

new
	^super new initialize!

readFrom: aFilenameString

	"read a specified delimited file and store records in a records attribute. Use default delimiter
	for field separator (character ; )"

	| instance |
	instance := self new.
	instance readFrom: aFilenameString.
	^instance.

"DelimitedFile readFrom: 'i:\projekti\dare\proizvod.txt' "! !
!DelimitedFile class categoriesFor: #fileToWrite:!instance creation!public! !
!DelimitedFile class categoriesFor: #new!instance creation!public! !
!DelimitedFile class categoriesFor: #readFrom:!instance creation!public! !

DirectoryProxy guid: (GUID fromString: '{146704DB-CC91-405A-8262-8DA6CD209520}')!
DirectoryProxy comment: ''!
!DirectoryProxy categoriesForClass!Unclassified! !
DocLink guid: (GUID fromString: '{15E77BEC-C862-49C5-ACCB-17F522E7FA4D}')!
DocLink comment: ''!
!DocLink categoriesForClass!Unclassified! !
!DocLink methodsFor!

asWebLink
	^WebLink text: self title linkTo: self url!

initialize
	^self!

migrateToUnicode
	"DocLink allInstances do: [:each | each migrateToUnicode]"
	title notNil ifTrue: [title := title ensureUnicodeSloveneChars]!

object
	^object!

object: anObject
	object := anObject!

printString
	^'a Doclink
		title:  ', (self title notNil ifTrue: [self title] ifFalse: ['']), '
		url: ', (self url notNil ifTrue: [self url] ifFalse: ['']), '
		object: ', self object printString!

title
	^title!

title: aString
	title := aString!

url
	^url!

url: aString
	url := aString!

uuid
	^self hash printString! !
!DocLink categoriesFor: #asWebLink!converting!public! !
!DocLink categoriesFor: #initialize!initialize-release!public! !
!DocLink categoriesFor: #migrateToUnicode!private! !
!DocLink categoriesFor: #object!accessing!public! !
!DocLink categoriesFor: #object:!accessing!public! !
!DocLink categoriesFor: #printString!private! !
!DocLink categoriesFor: #title!accessing!public! !
!DocLink categoriesFor: #title:!accessing!public! !
!DocLink categoriesFor: #url!accessing!public! !
!DocLink categoriesFor: #url:!accessing!public! !
!DocLink categoriesFor: #uuid!accessing!public! !

!DocLink class methodsFor!

new
	"Answer a newly created and initialized instance."

	^super new initialize! !
!DocLink class categoriesFor: #new!instance creation!public! !

FileProxy guid: (GUID fromString: '{366AAB75-0ED0-454D-B1B6-C2940BD2B3B7}')!
FileProxy comment: 'FileProxy is a proxy object for files on a disk. It is responsible for serving a file to browser. Smaller files (below #sizeAboveMark) are cached.

HTML files can be parsed for special AIDA tags (templating). When such file is served, that tag is expanded with dynamicall created content.

example : <AIDA WebStatisticsApp pageCounter>  returns a number of hits of current page


Instance Variables:
	site 
	filename 
	timestamps 
	content  
	contentType 
	size 
	codepage 
	elements  "parsed elements of a HTML page"
	bodyTagIndex imgTagIndexes linkTagIndexes servletTagIndexes'!
!FileProxy categoriesForClass!Unclassified! !
!FileProxy methodsFor!

absoluteTagFrom: aTagString urlStart: anURLString

	""

	| tag url |
	tag := (aTagString copyReplaceAll: '\' with: '/').
	((tag copyFrom: 1 to: 3) = '../')
		ifFalse:  "not relative to parent directory"
			[^((tag copyUpTo: $"), '"', anURLString, 
				(tag copyFrom: ((tag indexOf: $") + 1) to: tag size))]
		ifTrue:
			[tag := tag readStream upTo: $/; upToEnd.
			url := anURLString copyFrom: 1 to: (anURLString lastIndexOf: $/).
			^self absoluteTagFrom: tag urlStart: url].!

accessedTimestamp
	^self timestamps at: #accessed ifAbsent: [nil]!

argumentsFrom: aMessageString

	^Array new: 0 "for now!! "!

bodyTagIndex
	"index of element, which represent body tag in original html file"
	^bodyTagIndex!

bodyTagIndex: anInteger
	"set the index of element, which represent body tag in original html file"
	bodyTagIndex := anInteger.!

clearElements
	elements := OrderedCollection new.!

clearImgTagIndexes
	imgTagIndexes := OrderedCollection new.!

clearLinkTagIndexes
	linkTagIndexes := OrderedCollection new.!

clearServletTagIndexes
	servletTagIndexes := OrderedCollection new.!

codepage
	" #iso2 by default"
	codepage isNil ifTrue: [self codepage: #'iso-8859-2'].
	^codepage.!

codepage: aSymbol
	codepage := aSymbol.!

content
	^content!

content: aString
	content := aString.!

contentType
	"MIME type of original content. 'unknown' if not known"
	contentType isNil ifTrue: [self contentType: 'unknown'].
	^contentType.!

contentType: aMIMEString
	"MIME type of original content"
	contentType := aMIMEString.!

createdTimestamp
	^self timestamps at: #created ifAbsent: [nil]!

detectCodepage: aString
	" "
	| win1250 iso2 sevenBit above127 |
	win1250 := 0.
	aString do: [:ch | (#(200 154 138 158 142) includes: ch asInteger) ifTrue: [win1250 := win1250+1] ].
	iso2 := 0.
	aString do: [:ch | (#(200 185 169 190 174) includes: ch asInteger) ifTrue: [iso2 := iso2+1] ].
	sevenBit := 0.
"	aString do: [:ch | (#(94 123 91 96 64) includes: ch asInteger) ifTrue: [sevenBit := sevenBit+1] ]."
	above127 := 0.
	aString do: [:ch | ch asInteger > 127 ifTrue: [above127 := above127+1] ].
	above127 = 0 
		ifTrue: [sevenBit ~= 0 ifTrue: [^#'7bit'] ifFalse: [^#csz] ]
		ifFalse: [iso2 > win1250 ifTrue: [^#'iso-8859-2'] ifFalse: [^#'win-1250'] ].!

elements

	"all elements (texts and tags) of a gtml page"

	elements isNil ifTrue: 
		[self clearElements.
"		(self contentType = 'text/html') ifTrue: [self refreshContent] "].
	^elements!

expiresTimestamp
	"for broswer: after 6 hours by default. It is good to reload from time to time 
	if changes were made "
	^SpTimestamp fromSeconds: (SpTimestamp now asSeconds + (6 * 3600))!

filename: aFilename
	filename := aFilename asString.
	self site notNil ifTrue: 
		[filename := filename copyReplaceAll: self site homeDirectory with: ''].!

fileStillExist
	^self filename exists!

hasFileChanged
	"check if original file changed since last visit"
	^self modifiedTimestamp ~= self filename modifiedTimestamp.!

imgTagIndexes
	"indexes of elements, which represent image tags in original html file"
	imgTagIndexes isNil ifTrue: [self clearImgTagIndexes].
	^imgTagIndexes!

indexContent
	"index text in server global index"
	self contentType = 'text/html' ifTrue: [self site index indexObject: self]!

indexText
	"pure text, without tags, for indexer"
	| stream bodyStart element text |
	bodyStart := (1 to: self elements size) 
		detect: [:index | '<BODY*' match: (self elements at: index)] ifNone: [1].
	stream := WriteStream on: String new.
	bodyStart + 1 to: self elements size do:  [:index | 
		element := self elements at: index.
		(element notEmpty and: [element first ~= $<]) ifTrue: [stream nextPutAll: element] ].
	text := stream contents "copyReplaceAll: WebElement new eol with: ' '". 
	text := text copyReplaceAll: '&nbsp;' with: ' '.
	^text!

indexTitle
	"find title, if noone, then return url"
	1 to: self elements size do: [:index |
		('<TITLE*' match: (self elements at: index)) ifTrue: [^self elements at: index+1] ].
	^self site urlResolver halfUrlFor: self!

isCaching
	"should this file be always cached?"
	caching isNil ifTrue: [self resetCaching].
	^caching!

isRespondingStreamed
	"we always stream (put possibly not chunk) static content, being cached or not"
	^true


"	""should we stream that file directly to TCP socket or not?""
	self content notNil ifTrue: [^false].  ""cached content is sent faster without streaming""
	self contentType = 'text/html' ifTrue: [^false]. ""pure HTML files also not""
	^true
"!

isToBeCached
	"cache this file or not?"
	^self isCaching or: [self size < self sizeToCache]!

isWebElement
	^false!

isWebPage
	^true "not actually, but let pretend it is"!

linkTagIndexes
	"indexes of elements, which represent link tags in original html file"
	linkTagIndexes isNil ifTrue: [self clearLinkTagIndexes].
	^linkTagIndexes!

makeAbsoluteImgTags
	"if image url's are relative, make them absolute. Also do it for a body tag (background image). 
	Url is constructed from a imageServer address from WebServer settings, and from filename with 	homeDirectory substracted. "
	| fname urlStart index tag bodyTag |
	fname := (self filename asString) copyReplaceAll: (self site homeDirectory) with: ''.
	fname := fname copyFrom: 1 to: (fname lastIndexOf: (AIDASite slash at: 1)).
	urlStart := 'http://', self site host, (fname copyReplaceAll: '\' with: '/').
	self imgTagIndexes do: [:inx  | tag := self elements at: inx.
		('*http://*' match: tag) ifFalse:    "not an absolute source url"
			[self elements at: inx put: (self absoluteTagFrom: tag urlStart: urlStart)] ].
	self bodyTagIndex notNil ifTrue:
		[bodyTag := self elements at: bodyTagIndex.
		(('*background*' match:  bodyTag) and: [('*http://*' match:  bodyTag) not]) 
			ifTrue: 
				[index := bodyTag asLowercase findString: 'background' startingAt: 1.
				index := bodyTag findString: '"' startingAt: index.
				(( bodyTag at: index+1) = $#) ifTrue: [^self]. "only colored background"
				self elements at: bodyTagIndex put:
					((bodyTag copyFrom: 1 to: index), urlStart, 
						(bodyTag copyFrom: index + 1 to: bodyTag size)) ] ].!

methodFrom: aMessageString

	^aMessageString asSymbol "for now!! "!

modifiedTimestamp
	^self timestamps at: #modified ifAbsent: [nil]!

prepareHTMLPage
	"decompose content into elements (texts and tags)"
	| stream tag index |
	self clearElements. self clearImgTagIndexes. 
	self clearLinkTagIndexes. self clearServletTagIndexes.
	stream := ReadStream on: self content.
	index := 1.
	[stream atEnd] whileFalse:
		[self elements add: (stream upTo: $<). index := index + 1.
		tag := ('<', (stream upTo: $>), '>').
		('<aida*' match: tag) ifTrue: [self servletTagIndexes add: index].
		('*img*' match: tag) ifTrue: [self imgTagIndexes add: index].
		('*href*' match: tag) 
			ifTrue: [self linkTagIndexes add: index]
			ifFalse: 
				[(('*body*' match: tag) and: [('*/body*' match: tag) not])
					ifTrue: [self bodyTagIndex: index]].
		self elements add: tag. index := index + 1.
		].!

printServlet: index on: aStream for: aRequest on: aSession

	| tag appClass message app element |
	tag := (self elements at: index) copy readStream.
	appClass := (tag upTo: $ ; upTo: $ ) asSymbol.
	message := tag upTo: $>.
	app := aSession servletAppFor: appClass.
	app isNil ifTrue: [^self ].
	element := self servletPerform: message on: app.
	element notNil ifTrue: 
		[element printHTMLPageOn: aStream for: aRequest on: aSession].!

printString
	^('aFileProxy for: ', self filename asString)!

printWebPageFor: aRequest on: aSession 
	self fileStillExist ifFalse: [self removeYourself. ^WebPage new].
	(self content isNil and: [self contentType = 'text/html' or: [self isToBeCached] ]) 
		ifTrue: [^self refreshContent]. 
	self hasFileChanged ifTrue: 
		[self refreshContent.
		self indexContent].
	^self!

put: aString
	"replace self with contents in aString from PUT request"
	self content: aString.
	self writeToFile.
	self releaseContent.
	self size: aString size!

refreshContent
	self releaseContent. "in case we switch from cached to non cached because of size change"
	self from: self filename asString.!

refreshTimestamps
"	self timestamps at: #created put: self filename createdTimestamp. "
	self timestamps at: #modified put: self filename modifiedTimestamp.!

releaseContent
	"release origContent and elements to save memory"
	content := nil.
	elements := nil.!

removeYourself
	"remove from url resolver and elsewhere"
	self releaseContent.
	self site urlResolver removeObject: self.!

resetCaching
	"don't cahce this file,except if it is smallter than "
	caching := false!

servletPerform: aMessageString on: aWebApp

	| method |
	method := (self methodFrom: aMessageString).
	(aWebApp class canUnderstand: method) ifFalse: [^nil].
	^aWebApp
		perform: method
		withArguments: (self argumentsFrom: aMessageString).!

servletTagIndexes
	"indexes of elements, which represent servlet in original html file"
	servletTagIndexes isNil ifTrue: [self clearServletTagIndexes].
	^servletTagIndexes!

setCaching
	"this file should always be cached, regardless of size"
	caching := true!

setSize
	"size of content in bytes"
	(self elements notEmpty)
		ifTrue: [self size: (self elements inject: 0 into: [:sum : e | sum + e size]) ]
		ifFalse: [self size: self content size]!

site
	^site!

site: anAIDASite
	site := anAIDASite.!

size
	"size of content"
	size isNil ifTrue: [self setSize].
	^size!

size: anInteger
	size := anInteger!

sizeToCache
	"file size below which files are always cached"
	^(5 * 1024) "bytes" "5KB"!

timestamps
	timestamps isNil ifTrue: [self timestamps: Dictionary new.].
	^timestamps!

timestamps: aDictionary
	" a dictionary with a DateAndTime at: 
	#accessed #modified  #created"
	timestamps := aDictionary.!

writeToFile
	| stream |
	[stream := self filename writeStream. stream binary.
	stream nextPutAll: self content]
		ensure: [stream close].
	self refreshTimestamps.! !
!FileProxy categoriesFor: #absoluteTagFrom:urlStart:!parsing!public! !
!FileProxy categoriesFor: #accessedTimestamp!accessing-timestamps!public! !
!FileProxy categoriesFor: #argumentsFrom:!printing-servlets!public! !
!FileProxy categoriesFor: #bodyTagIndex!accessing-tags!public! !
!FileProxy categoriesFor: #bodyTagIndex:!accessing-tags!public! !
!FileProxy categoriesFor: #clearElements!initialize-release!public! !
!FileProxy categoriesFor: #clearImgTagIndexes!accessing-tags!public! !
!FileProxy categoriesFor: #clearLinkTagIndexes!accessing-tags!public! !
!FileProxy categoriesFor: #clearServletTagIndexes!accessing-tags!public! !
!FileProxy categoriesFor: #codepage!accessing!public! !
!FileProxy categoriesFor: #codepage:!private! !
!FileProxy categoriesFor: #content!accessing!public! !
!FileProxy categoriesFor: #content:!private! !
!FileProxy categoriesFor: #contentType!accessing!public! !
!FileProxy categoriesFor: #contentType:!private! !
!FileProxy categoriesFor: #createdTimestamp!accessing-timestamps!public! !
!FileProxy categoriesFor: #detectCodepage:!private! !
!FileProxy categoriesFor: #elements!private! !
!FileProxy categoriesFor: #expiresTimestamp!accessing-timestamps!public! !
!FileProxy categoriesFor: #filename:!private! !
!FileProxy categoriesFor: #fileStillExist!public!testing! !
!FileProxy categoriesFor: #hasFileChanged!public!testing! !
!FileProxy categoriesFor: #imgTagIndexes!accessing-tags!public! !
!FileProxy categoriesFor: #indexContent!indexing!public! !
!FileProxy categoriesFor: #indexText!indexing!public! !
!FileProxy categoriesFor: #indexTitle!indexing!public! !
!FileProxy categoriesFor: #isCaching!public!testing! !
!FileProxy categoriesFor: #isRespondingStreamed!public!testing! !
!FileProxy categoriesFor: #isToBeCached!public!testing! !
!FileProxy categoriesFor: #isWebElement!public!testing! !
!FileProxy categoriesFor: #isWebPage!public!testing! !
!FileProxy categoriesFor: #linkTagIndexes!accessing-tags!public! !
!FileProxy categoriesFor: #makeAbsoluteImgTags!parsing!public! !
!FileProxy categoriesFor: #methodFrom:!printing-servlets!public! !
!FileProxy categoriesFor: #modifiedTimestamp!accessing-timestamps!public! !
!FileProxy categoriesFor: #prepareHTMLPage!parsing!public! !
!FileProxy categoriesFor: #printServlet:on:for:on:!printing-servlets!public! !
!FileProxy categoriesFor: #printString!printing!public! !
!FileProxy categoriesFor: #printWebPageFor:on:!printing!public! !
!FileProxy categoriesFor: #put:!accessing!public! !
!FileProxy categoriesFor: #refreshContent!initialize-release!public! !
!FileProxy categoriesFor: #refreshTimestamps!private! !
!FileProxy categoriesFor: #releaseContent!initialize-release!public! !
!FileProxy categoriesFor: #removeYourself!private! !
!FileProxy categoriesFor: #resetCaching!accessing!public! !
!FileProxy categoriesFor: #servletPerform:on:!printing-servlets!public! !
!FileProxy categoriesFor: #servletTagIndexes!accessing-tags!public! !
!FileProxy categoriesFor: #setCaching!accessing!public! !
!FileProxy categoriesFor: #setSize!private! !
!FileProxy categoriesFor: #site!accessing!public! !
!FileProxy categoriesFor: #site:!private! !
!FileProxy categoriesFor: #size!accessing!public! !
!FileProxy categoriesFor: #size:!private! !
!FileProxy categoriesFor: #sizeToCache!accessing!public! !
!FileProxy categoriesFor: #timestamps!private! !
!FileProxy categoriesFor: #timestamps:!private! !
!FileProxy categoriesFor: #writeToFile!private! !

!FileProxy class methodsFor!

from: aFilenameString onSite: aSite
	"read a file and make a HTML proxy of it. Return nil, if file does not exist or cannot be opened. 
	Also record a server for which you make a proxy"
	| proxy |
	proxy := self new site: aSite; from: aFilenameString.
	proxy indexContent.
	^proxy! !
!FileProxy class categoriesFor: #from:onSite:!instance creation!public! !

History guid: (GUID fromString: '{CCF41412-C2FB-4740-B17C-FAF92C8C79E9}')!
History comment: ''!
!History categoriesForClass!Unclassified! !
!History methodsFor!

activeFromArray: anArray

	"return a active flag from entries in history array"

	^anArray at: 5!

addValue: aValue dated: aDate author: aString comment: aCommentString
	"adds data, which is newer than any existing one"
	self dates add: aDate asDays.
	self values add: aValue.
	self changedDates add: Date today asDays.
	self authors add: aString.
	self comments add: aString.!

arrayWithDate: aDate time: aTime value: aValue active: aBoolean

	"return a array with argument vaules for entry to history collection"

	| array |
	array := Array new: 5.
	array 
		at: 1 put: aDate year;
		at: 2 put: aDate day;
		at: 3 put: (aTime notNil ifTrue: [aTime asSeconds] ifFalse: [0]);
		at: 4 put: aValue;
		at: 5 put: aBoolean.
	^array!

authors
	" a collection of authors, which made changes, (as a String or reference to a WebUser)"
	^authors!

changedDates
	" a collection of dates, when value was changed in asDays format"
	^changedDates!

changeValue: aValue author: aString comment: aCommentString onIndex: anIndexNumber
	"change data in a specificied index"
	self values at: anIndexNumber put: aValue.
	self changedDates at: anIndexNumber put: Date today asDays.
	self authors at: anIndexNumber put: aString.
	self comments at: anIndexNumber put: aString.!

comments
	" a collection of comments about changes"
	^comments!

dateFromArray: anArray

	"return a date from entries in history array"

	^Date
		newDay: (anArray at: 2)
		year: (anArray at: 1)!

dates
	" a collection of dates of changes in asDays format"
	^dates!

hasDuplicateDates

	"maintenance - check if more than one entry with the same date exist"

	| unique |
	unique := Set new.
	self dates do: [: date | (unique includes: date)
		ifTrue: [^true]
		ifFalse: [unique add: date] ].
	^false!

historyCollection
	"this is an ordered collection of array with year, day in year, time, value, active flag. 
	Collection is ordered from oldest to newest version of value. Active flag is used to 
	'delete' some version from history, but you can still have a trace, who/when some 
	change occured.

	3.11.98 NOT USED anymore. Here just for migration!!"


	historyCollection isNil ifTrue: [self initHistoryCollection].
	^historyCollection!

historyOfChanges

	"return a history of all changes of value. It is returned as ordered collection of collections, each with:
	valid from date
	valid to date (for last change: nil)
	new value
	date of change
	author of change
	comment of change	

Returned collection has the oldest change (by valied from date) as first, the newest as last. "!

indexForDate: aDate

	"return index of entry in dates collection, which fits most to the specified date. If no direct 
	entry on a specified date exist, then entry for previous date is used. If aDate is older than
	any date in collection, nil is returned!!"


	| first last days mdays index |

	first := 1. last := self dates size.
	last = 0 ifTrue: [^nil].
	days := aDate asDays.
	days >= self dates last ifTrue: [^last].
	days < self dates first ifTrue: [^nil].
	[last >= first] whileTrue: 	
		[ "(first = last and: [days = (self dates at: first)]) ifTrue: [^first].  " " not needed!! "
		index := (first + last) // 2.
		mdays := self dates at: index.
		days = mdays ifTrue: [^index].
		days < mdays
			ifTrue: [last := index - 1.]
			ifFalse: [first := index + 1.]].
"2.11.98 Sivec prej :
		^1 max: index - 1.
"
	index := (first + last) // 2.
	^1 max: index.




"
| h |
h := History new.
h dates
	add: (Date today) asDays;
	add: (Date today + 1) asDays;
	add: (Date today + 3) asDays;
	add: (Date today + 4) asDays.
Transcript cr;show: (h indexForDate: Date today - 1) printString.
Transcript cr;show: (h indexForDate: Date today + 1) printString.
Transcript cr;show: (h indexForDate: Date today + 2) printString.
Transcript cr;show: (h indexForDate: Date today + 3) printString.
h inspect.
"





"
	self historyCollection keysAndValuesDo: [:index :array |
		(self activeFromArray: array) 
			ifTrue:
				[(self dateFromArray: array) < (aDate + 1)
					ifTrue: [prevIndex := index]
					ifFalse: [^prevIndex]	] ].
	^prevIndex
"!

initAuthors
	authors := OrderedCollection new.!

initChangedDates
	changedDates := OrderedCollection new.!

initComments
	comments := OrderedCollection new.!

initDates
	"adds default entry: 1.1.1901"
	dates := OrderedCollection new.!

initHistoryCollection
	historyCollection := OrderedCollection new.!

initialize
	"2.11.1998 all inits do not add default values anymore"

	self initDates.
	self initValues.
	self initChangedDates.
	self initAuthors.
	self initComments.!

initValues
	values := OrderedCollection new.!

insertValue: aValue dated: aDate author: aString comment: aCommentString beforeIndex: anIndex
	"adds data in position before specified index"
	self dates add: aDate asDays beforeIndex: anIndex.
	self values add: aValue beforeIndex: anIndex.
	self changedDates add: Date today asDays beforeIndex: anIndex.
	self authors add: aString beforeIndex: anIndex.
	self comments add: aString beforeIndex: anIndex.!

migrateHistoryCollection

	"migrate from historyCollection to bunch of collections. Remove duplicates"

	| date |
	date := nil.
	self initialize.
	self historyCollection reverseDo: [:array |
		date = (self dateFromArray: array)
			ifFalse: 
				[self 
					value: (self valueFromArray: array)
					dated: (self dateFromArray: array)
					author: ('')
					comment: ('').
				date := self dateFromArray: array] ].


"
Janko := History selectFromOdb select: [:h | h historyCollection size > 10].
(Janko at: 3) migrateHistoryCollection
Janko do: [:each | each migrateHistoryCollection].
Janko  select: [:h | h dates size > 3].
"!

newestDate

	"return a date of newest version of value"

	self dates isEmpty
		ifTrue: [^nil]
		ifFalse: 	[^Date fromDays: self dates last]

"History new newestDate"!

newestValue

	"return a newest version of value in historyCollection."

	self values isEmpty
		ifTrue: [^nil]
		ifFalse: 	[^self values last]
	

"History new newestValue"!

oldestDate

	"return a date of oldest version of value"

	self dates isEmpty
		ifTrue: [^nil]
		ifFalse: 	[^self dates first]
	

"History new oldestDate"!

oldestValue

	"return a oldest version of value"

	self values isEmpty
		ifTrue: [^nil]
		ifFalse: 	[^self values last]
	

"History new oldestValue"!

printString

	^('aHistory: ', self value printString)!

removeAllNils
	"REPARING BAD HISTORIES - remove all nil entries. Initialize if no more entries"

	2 to: self values size do: [:index |
		(self values at: index) isNil ifTrue: 
			[self removeIndex: index. ^self removeAllNils] ]!

removeDuplicateDates

	"maintenance - remove all duplicate entries with same dates. Live last one"

	| date index |
	self hasDuplicateDates ifTrue: 
		[date := 0. index := nil.
		1 to: self dates size do: 
			[:inx | 
				(self dates at: inx) = date ifTrue: [index := inx].
				date := self dates at: inx].
		index notNil 
			ifTrue: 
				[self removeIndex: index-1.
				self removeDuplicateDates].
		 ].!

removeIndex: aNumber
	"remove all entries on specified index"
	self dates removeIndex: aNumber.
	self values removeIndex: aNumber.
	self changedDates removeIndex: aNumber.
	self authors removeIndex: aNumber.
	self comments removeIndex: aNumber.!

removeLastNil
	"REPARING BAD HISTORIES - remove last entry if value nil. Initialize if no more entries"
	self values isEmpty 
		ifTrue: 
			[self initialize. self values removeLast; addLast: true.
			Transcript cr; show: 'init, true']
		ifFalse: [self values last isNil ifTrue: 
			[self removeIndex: (self dates size).
			self removeLastNil] ]!

timeFromArray: anArray

	"return a time from entries in history array"

	^Time fromSeconds: (anArray at: 3)!

value
	"get the curently valid value"

	^self valueDated: Date today

"History new value"!

value: aValue author: aString comment: aCommentString 
	"change a value of time series, which will be valid immediately - today. You should state author and a short comment about changes. see other methods for detailed explanation"

	self value: aValue
		dated: Date today
		author: aString
		comment: aCommentString!

value: aValue dated: aDate author: aString comment: aCommentString 
	""

	| index |

	index := self indexForDate: aDate. 
	index isNil   "older than any existing or first" 
		ifTrue: 
			[self 
				insertValue: aValue 
				dated: aDate
				author: aString 
				comment: aCommentString
				beforeIndex: 1.
			^self].

"Sprememba 18.11.1998 Sivec, prej 'index >= self dates  size'."
	index > self dates  size  "newer than any existing"
		ifTrue: 
			[self addValue: aValue dated: aDate author: aString comment: aCommentString. ^self].


	(index ~= 0 and: [(self dates at: index) = aDate asDays]) "already exists"
		ifTrue: 
			[self 
				changeValue: aValue 
				author: aString 
				comment: aCommentString 
				onIndex: index.
			^self].

		self    "insert new somewhere in the middle"
			insertValue: aValue 
			dated: aDate
			author: aString 
			comment: aCommentString
			beforeIndex: index+1.



"History new value: 1234 dated: Date today author: 'Janko' comment: 'test'"!

valueDated: aDate 
	"get the value from history, which was valid on specified date. Returns nil if aDate is older from 
	oldest entry in history"

	
	| index |
	index := self indexForDate: aDate.
	index = 0 ifTrue: [^nil].
	index = nil ifTrue: [^nil].
	^self values at: index.!

valueFromArray: anArray

	"return a value from entries in history array"

	^anArray at: 4!

values
	" a collection of values, each valid from date in dates at the same index"
	^values! !
!History categoriesFor: #activeFromArray:!private - history arrays!public! !
!History categoriesFor: #addValue:dated:author:comment:!private - adding-removing!public! !
!History categoriesFor: #arrayWithDate:time:value:active:!private - history arrays!public! !
!History categoriesFor: #authors!private - accessing!public! !
!History categoriesFor: #changedDates!private - accessing!public! !
!History categoriesFor: #changeValue:author:comment:onIndex:!private - adding-removing!public! !
!History categoriesFor: #comments!private - accessing!public! !
!History categoriesFor: #dateFromArray:!private - history arrays!public! !
!History categoriesFor: #dates!private - accessing!public! !
!History categoriesFor: #hasDuplicateDates!private - adding-removing!public! !
!History categoriesFor: #historyCollection!private - accessing!public! !
!History categoriesFor: #historyOfChanges!accessing!public! !
!History categoriesFor: #indexForDate:!private - accessing!public! !
!History categoriesFor: #initAuthors!initialize - release!public! !
!History categoriesFor: #initChangedDates!initialize - release!public! !
!History categoriesFor: #initComments!initialize - release!public! !
!History categoriesFor: #initDates!initialize - release!public! !
!History categoriesFor: #initHistoryCollection!private - accessing!public! !
!History categoriesFor: #initialize!initialize - release!public! !
!History categoriesFor: #initValues!initialize - release!public! !
!History categoriesFor: #insertValue:dated:author:comment:beforeIndex:!private - adding-removing!public! !
!History categoriesFor: #migrateHistoryCollection!private - history arrays!public! !
!History categoriesFor: #newestDate!private - accessing!public! !
!History categoriesFor: #newestValue!private - accessing!public! !
!History categoriesFor: #oldestDate!private - accessing!public! !
!History categoriesFor: #oldestValue!private - accessing!public! !
!History categoriesFor: #printString!printing!public! !
!History categoriesFor: #removeAllNils!private - adding-removing!public! !
!History categoriesFor: #removeDuplicateDates!private - adding-removing!public! !
!History categoriesFor: #removeIndex:!private - adding-removing!public! !
!History categoriesFor: #removeLastNil!private - adding-removing!public! !
!History categoriesFor: #timeFromArray:!private - history arrays!public! !
!History categoriesFor: #value!accessing!public! !
!History categoriesFor: #value:author:comment:!accessing!public! !
!History categoriesFor: #value:dated:author:comment:!accessing!public! !
!History categoriesFor: #valueDated:!accessing!public! !
!History categoriesFor: #valueFromArray:!private - history arrays!public! !
!History categoriesFor: #values!private - accessing!public! !

!History class methodsFor!

instancesAreForwarders
	"Gemstone"

	^false!

new
	^super new initialize!

tests
	"some test of histories. Use it directly from code with doIt/printIt/inspectIt "

	| history |
	history := History new.
	history value: 0 dated: (Date today ) author: '' comment: ''.
	history value: -2000 dated: (Date today - (365*100) -2) author: '' comment: ''.
	history value: -3 dated: (Date today -3) author: '' comment: ''.
	history value: -1 dated: (Date today -1) author: '' comment: ''.
	history value: 2 dated: (Date today +2) author: '' comment: ''.
	history value: 1 dated: (Date today +1) author: '' comment: ''.! !
!History class categoriesFor: #instancesAreForwarders!odb specific!public! !
!History class categoriesFor: #new!instance creation!public! !
!History class categoriesFor: #tests!examples!public! !

ImageStream guid: (GUID fromString: '{44E765C0-3111-499A-AEB3-88E5747B0815}')!
ImageStream comment: 'ImageStream 

Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!
!ImageStream categoriesForClass!Unclassified! !
!ImageStream methodsFor!

atEnd
	^imageStream atEnd!

close
	imageStream close!

compute: aBlock 
	(self progressValue isKindOf: ValueHolder)
		ifTrue: [self progressValue compute: aBlock]!

contents
	^imageStream contents!

convertValue: value from: fromScale to: toScale 
	^value = 0
		ifTrue: [0]
		ifFalse: [value = fromScale
				ifTrue: [toScale]
				ifFalse: [(value + 1 * (toScale + 1) / (fromScale + 1)) rounded - 1 max: 0]]!

cr
	^imageStream nextPut: Character cr asInteger!

errorCanNotRead
	self error: 'can''t read the image'.
	^nil!

errorCanNotWrite
	self error: 'can''t write the image'.
	^nil!

hasMagicNumber: aByteArray 
	| position array |
	position := imageStream position.
	imageStream size - position >= aByteArray size
		ifTrue: 
			[array := (imageStream next: aByteArray size) asByteArray.
			array = aByteArray ifTrue: [^true]].
	imageStream position: position.
	^false!

lf
	^imageStream nextPut: Character lf asInteger!

next
	^imageStream next!

next: size 
	^imageStream next: size!

nextImage
	^self subclassResponsibility!

nextLong
	^(imageStream next bitShift: 24)
		+ (imageStream next bitShift: 16) + (imageStream next bitShift: 8) + imageStream next!

nextLongPut: a32BitW 
	imageStream nextPut: ((a32BitW bitShift: -24)
			bitAnd: 255).
	imageStream nextPut: ((a32BitW bitShift: -16)
			bitAnd: 255).
	imageStream nextPut: ((a32BitW bitShift: -8)
			bitAnd: 255).
	imageStream nextPut: (a32BitW bitAnd: 255).
	^a32BitW!

nextPut: aByte 
	^imageStream nextPut: aByte!

nextPutAll: aByteArray 
	^imageStream nextPutAll: aByteArray!

nextPutImage: anImage 
	^self subclassResponsibility!

nextWord
	^(imageStream next bitShift: 8)
		+ imageStream next!

nextWordPut: a16BitW 
	imageStream nextPut: ((a16BitW bitShift: -8)
			bitAnd: 255).
	imageStream nextPut: (a16BitW bitAnd: 255).
	^a16BitW!

on: aStream 
	imageStream := aStream.
	(imageStream respondsTo: #binary)
		ifTrue: [imageStream binary].
	self progressValue: (ValueHolder with: nil)!

position
	^imageStream position!

position: anInteger 
	^imageStream position: anInteger!

progress
	^self progressValue value!

progress: normalizedNumber 
	(0 <= normalizedNumber and: [normalizedNumber <= 1])
		ifTrue: 
			[| truncatedValue |
			truncatedValue := normalizedNumber roundTo: 0.005.
			self progressValue value = truncatedValue ifFalse: [self progressValue value: truncatedValue]]!

progressValue
	^progressValue!

progressValue: aValueHolder 
	progressValue := aValueHolder!

show: anImage 
	^self class show: anImage!

size
	^imageStream size!

skip: anInteger 
	^imageStream skip: anInteger!

space
	^imageStream nextPut: Character space asInteger!

tab
	^imageStream nextPut: Character tab asInteger! !
!ImageStream categoriesFor: #atEnd!public!stream access! !
!ImageStream categoriesFor: #close!public!stream access! !
!ImageStream categoriesFor: #compute:!progress!public! !
!ImageStream categoriesFor: #contents!public!stream access! !
!ImageStream categoriesFor: #convertValue:from:to:!private! !
!ImageStream categoriesFor: #cr!public!stream access! !
!ImageStream categoriesFor: #errorCanNotRead!private! !
!ImageStream categoriesFor: #errorCanNotWrite!private! !
!ImageStream categoriesFor: #hasMagicNumber:!private! !
!ImageStream categoriesFor: #lf!public!stream access! !
!ImageStream categoriesFor: #next!public!stream access! !
!ImageStream categoriesFor: #next:!public!stream access! !
!ImageStream categoriesFor: #nextImage!accessing!public! !
!ImageStream categoriesFor: #nextLong!public!stream access! !
!ImageStream categoriesFor: #nextLongPut:!public!stream access! !
!ImageStream categoriesFor: #nextPut:!public!stream access! !
!ImageStream categoriesFor: #nextPutAll:!public!stream access! !
!ImageStream categoriesFor: #nextPutImage:!accessing!public! !
!ImageStream categoriesFor: #nextWord!public!stream access! !
!ImageStream categoriesFor: #nextWordPut:!public!stream access! !
!ImageStream categoriesFor: #on:!initialize-release!public! !
!ImageStream categoriesFor: #position!public!stream access! !
!ImageStream categoriesFor: #position:!public!stream access! !
!ImageStream categoriesFor: #progress!progress!public! !
!ImageStream categoriesFor: #progress:!progress!public! !
!ImageStream categoriesFor: #progressValue!progress!public! !
!ImageStream categoriesFor: #progressValue:!progress!public! !
!ImageStream categoriesFor: #show:!public!viewing! !
!ImageStream categoriesFor: #size!public!stream access! !
!ImageStream categoriesFor: #skip:!public!stream access! !
!ImageStream categoriesFor: #space!public!stream access! !
!ImageStream categoriesFor: #tab!public!stream access! !

!ImageStream class methodsFor!

assert: assertBlock do: doBlock ensure: ensureBlock 
	assertBlock value.
	[doBlock value]
		valueNowOrOnUnwindDo: [ensureBlock value]!

colorPalette256Array
	"ImageStream colorPalette256Array."
	^#(	#(8191 8191 8191)
		#(8191 8191 6553)
		#(8191 8191 4915)
		#(8191 8191 3276)
		#(8191 8191 1638)
		#(8191 8191 0)
		#(8191 6553 8191)
		#(8191 6553 6553)
		#(8191 6553 4915)
		#(8191 6553 3276)
		#(8191 6553 1638)
		#(8191 6553 0)
		#(8191 4915 8191)
		#(8191 4915 6553)
		#(8191 4915 4915)
		#(8191 4915 3276)
		#(8191 4915 1638)
		#(8191 4915 0)
		#(8191 3276 8191)
		#(8191 3276 6553)
		#(8191 3276 4915)
		#(8191 3276 3276)
		#(8191 3276 1638)
		#(8191 3276 0)
		#(8191 1638 8191)
		#(8191 1638 6553)
		#(8191 1638 4915)
		#(8191 1638 3276)
		#(8191 1638 1638)
		#(8191 1638 0)
		#(8191 0 8191)
		#(8191 0 6553)
		#(8191 0 4915)
		#(8191 0 3276)
		#(8191 0 1638)
		#(8191 0 0)
		#(6553 8191 8191)
		#(6553 8191 6553)
		#(6553 8191 4915)
		#(6553 8191 3276)
		#(6553 8191 1638)
		#(6553 8191 0)
		#(6553 6553 8191)
		#(6553 6553 6553)
		#(6553 6553 4915)
		#(6553 6553 3276)
		#(6553 6553 1638)
		#(6553 6553 0)
		#(6553 4915 8191)
		#(6553 4915 6553)
		#(6553 4915 4915)
		#(6553 4915 3276)
		#(6553 4915 1638)
		#(6553 4915 0)
		#(6553 3276 8191)
		#(6553 3276 6553)
		#(6553 3276 4915)
		#(6553 3276 3276)
		#(6553 3276 1638)
		#(6553 3276 0)
		#(6553 1638 8191)
		#(6553 1638 6553)
		#(6553 1638 4915)
		#(6553 1638 3276)
		#(6553 1638 1638)
		#(6553 1638 0)
		#(6553 0 8191)
		#(6553 0 6553)
		#(6553 0 4915)
		#(6553 0 3276)
		#(6553 0 1638)
		#(6553 0 0)
		#(4915 8191 8191)
		#(4915 8191 6553)
		#(4915 8191 4915)
		#(4915 8191 3276)
		#(4915 8191 1638)
		#(4915 8191 0)
		#(4915 6553 8191)
		#(4915 6553 6553)
		#(4915 6553 4915)
		#(4915 6553 3276)
		#(4915 6553 1638)
		#(4915 6553 0)
		#(4915 4915 8191)
		#(4915 4915 6553)
		#(4915 4915 4915)
		#(4915 4915 3276)
		#(4915 4915 1638)
		#(4915 4915 0)
		#(4915 3276 8191)
		#(4915 3276 6553)
		#(4915 3276 4915)
		#(4915 3276 3276)
		#(4915 3276 1638)
		#(4915 3276 0)
		#(4915 1638 8191)
		#(4915 1638 6553)
		#(4915 1638 4915)
		#(4915 1638 3276)
		#(4915 1638 1638)
		#(4915 1638 0)
		#(4915 0 8191)
		#(4915 0 6553)
		#(4915 0 4915)
		#(4915 0 3276)
		#(4915 0 1638)
		#(4915 0 0)
		#(3276 8191 8191)
		#(3276 8191 6553)
		#(3276 8191 4915)
		#(3276 8191 3276)
		#(3276 8191 1638)
		#(3276 8191 0)
		#(3276 6553 8191)
		#(3276 6553 6553)
		#(3276 6553 4915)
		#(3276 6553 3276)
		#(3276 6553 1638)
		#(3276 6553 0)
		#(3276 4915 8191)
		#(3276 4915 6553)
		#(3276 4915 4915)
		#(3276 4915 3276)
		#(3276 4915 1638)
		#(3276 4915 0)
		#(3276 3276 8191)
		#(3276 3276 6553)
		#(3276 3276 4915)
		#(3276 3276 3276)
		#(3276 3276 1638)
		#(3276 3276 0)
		#(3276 1638 8191)
		#(3276 1638 6553)
		#(3276 1638 4915)
		#(3276 1638 3276)
		#(3276 1638 1638)
		#(3276 1638 0)
		#(3276 0 8191)
		#(3276 0 6553)
		#(3276 0 4915)
		#(3276 0 3276)
		#(3276 0 1638)
		#(3276 0 0)
		#(1638 8191 8191)
		#(1638 8191 6553)
		#(1638 8191 4915)
		#(1638 8191 3276)
		#(1638 8191 1638)
		#(1638 8191 0)
		#(1638 6553 8191)
		#(1638 6553 6553)
		#(1638 6553 4915)
		#(1638 6553 3276)
		#(1638 6553 1638)
		#(1638 6553 0)
		#(1638 4915 8191)
		#(1638 4915 6553)
		#(1638 4915 4915)
		#(1638 4915 3276)
		#(1638 4915 1638)
		#(1638 4915 0)
		#(1638 3276 8191)
		#(1638 3276 6553)
		#(1638 3276 4915)
		#(1638 3276 3276)
		#(1638 3276 1638)
		#(1638 3276 0)
		#(1638 1638 8191)
		#(1638 1638 6553)
		#(1638 1638 4915)
		#(1638 1638 3276)
		#(1638 1638 1638)
		#(1638 1638 0)
		#(1638 0 8191)
		#(1638 0 6553)
		#(1638 0 4915)
		#(1638 0 3276)
		#(1638 0 1638)
		#(1638 0 0)
		#(0 8191 8191)
		#(0 8191 6553)
		#(0 8191 4915)
		#(0 8191 3276)
		#(0 8191 1638)
		#(0 8191 0)
		#(0 6553 8191)
		#(0 6553 6553)
		#(0 6553 4915)
		#(0 6553 3276)
		#(0 6553 1638)
		#(0 6553 0)
		#(0 4915 8191)
		#(0 4915 6553)
		#(0 4915 4915)
		#(0 4915 3276)
		#(0 4915 1638)
		#(0 4915 0)
		#(0 3276 8191)
		#(0 3276 6553)
		#(0 3276 4915)
		#(0 3276 3276)
		#(0 3276 1638)
		#(0 3276 0)
		#(0 1638 8191)
		#(0 1638 6553)
		#(0 1638 4915)
		#(0 1638 3276)
		#(0 1638 1638)
		#(0 1638 0)
		#(0 0 8191)
		#(0 0 6553)
		#(0 0 4915)
		#(0 0 3276)
		#(0 0 1638)
		#(7645 0 0)
		#(7099 0 0)
		#(6007 0 0)
		#(5461 0 0)
		#(4369 0 0)
		#(3822 0 0)
		#(2730 0 0)
		#(2184 0 0)
		#(1092 0 0)
		#(546 0 0)
		#(0 7645 0)
		#(0 7099 0)
		#(0 6007 0)
		#(0 5461 0)
		#(0 4369 0)
		#(0 3822 0)
		#(0 2730 0)
		#(0 2184 0)
		#(0 1092 0)
		#(0 546 0)
		#(0 0 7645)
		#(0 0 7099)
		#(0 0 6007)
		#(0 0 5461)
		#(0 0 4369)
		#(0 0 3822)
		#(0 0 2730)
		#(0 0 2184)
		#(0 0 1092)
		#(0 0 546)
		#(7645 7645 7645)
		#(7099 7099 7099)
		#(6007 6007 6007)
		#(5461 5461 5461)
		#(4369 4369 4369)
		#(3822 3822 3822)
		#(2730 2730 2730)
		#(2184 2184 2184)
		#(1092 1092 1092)
		#(546 546 546)
		#(0 0 0)
	)!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!

fromUser
	"ImageStream show: ImageStream fromUser."

	^self fromDisplay: Rectangle fromUser!

imageStreamClassForFileName: aFilename 
	"ImageStream imageStreamClassForFileName: 'zzz.gif' asFilename."

	| aString aSymbol aClass |
	aString := (aFilename asString reverse copyUpTo: $.) reverse.
	aString := aString asLowercase.
	aSymbol := self imageKindTable at: aString ifAbsent: [nil].
	aSymbol isNil ifTrue: [^nil].
	aClass := Smalltalk at: aSymbol ifAbsent: [nil].
	^aClass!

install
	"ImageStream install."

	self colorPalette256.
	self grayPalette256!

on: aStream 
	^self new on: aStream!

system
	^'Goodies'!

toClipboard: anImage 
	"ImageStream toClipboard: Image fromUser."

	| pixmap |
	pixmap := anImage asRetainedMedium.
	pixmap toClipboard.
	^anImage!

version
	^'003'! !
!ImageStream class categoriesFor: #assert:do:ensure:!controls!public! !
!ImageStream class categoriesFor: #colorPalette256Array!constants of palette!public! !
!ImageStream class categoriesFor: #copyright!copyright!public! !
!ImageStream class categoriesFor: #fromUser!accessing!public! !
!ImageStream class categoriesFor: #imageStreamClassForFileName:!accessing!public! !
!ImageStream class categoriesFor: #install!class initialization!public! !
!ImageStream class categoriesFor: #on:!instance creation!public! !
!ImageStream class categoriesFor: #system!copyright!public! !
!ImageStream class categoriesFor: #toClipboard:!accessing!public! !
!ImageStream class categoriesFor: #version!copyright!public! !

MIMEMap guid: (GUID fromString: '{DF797D88-6CF5-4C83-8412-E999438D6BB9}')!
MIMEMap comment: ''!
!MIMEMap categoriesForClass!Unclassified! !
!MIMEMap methodsFor!

addType: aTypeString andExtension: anExtensionString
	| exts |
	exts := self mimeTypes at: aTypeString ifAbsentPut: [OrderedCollection new].
	(exts includes: anExtensionString) ifFalse: [exts add: anExtensionString].
	self fileExtensions at: anExtensionString ifAbsentPut: [aTypeString].!

extensionForType: aString
	"only first one if more than one ext exist for this mime type"
	| exts string |
	string := aString = 'image/pjpeg' ifTrue: ['image/jpeg'] ifFalse: [aString]. "wierd IE problem"
	string := aString = 'image/x-png' ifTrue: ['image/png'] ifFalse: [string]. "wierd IE problem"
	exts := self mimeTypes at: string asLowercase ifAbsent: [#()].
	^exts notEmpty ifTrue: [exts first] ifFalse: [nil]

"MIMEMap new extensionForType: 'image/jpeg'"!

extensionsForType: aString
	^self mimeTypes at: aString asLowercase ifAbsent: [#()].

"MIMEMap new extensionsForType: 'image/jpeg'"!

fileExtensions
	fileExtensions isNil ifTrue: [self initFileExtensions].
	^fileExtensions!

iconForType: aString
	"a name of icon to represent this content type, from WebStyle imgs-filetype icons"
	aString isNil ifTrue: [^#unknownSmallPng].
	'text/plain' = aString ifTrue: [^#txtSmallPng].
	'text/xml' = aString ifTrue: [^#xmlSmallPng].
	'application/pdf' = aString ifTrue: [^#pdfSmallPng].
	'application/msword' = aString ifTrue: [^#wordSmallPng].
	'application/rtf' = aString ifTrue: [^#wordSmallPng].
	'application/excel' = aString ifTrue: [^#excelSmallPng].
	'application/powerpoint' = aString ifTrue: [^#powerpointSmallPng].
	'application/zip' = aString ifTrue: [^#zipSmallPng].
	('image/*' match: aString) ifTrue: [^#imageSmallPng].
	('audio/*' match: aString) ifTrue: [^#multimediaSmallPng].
	('video/*' match: aString) ifTrue: [^#multimediaSmallPng].
	^#unknownSmallPng

"MIMEMap new iconForType: 'image/jpeg'"!

initFileExtensions
	fileExtensions := Dictionary new.!

initFromApacheMimeTypes
	"see class method. Only mime types, which have some extension defined, are set!! "
	| collection |
	collection := self class arrayFromApacheMimeTypes.
	collection do: [:col | 
		2 to: col size do: [:inx | self addType: col first andExtension: (col at: inx)] ]

"MIMEMap new"!

initialize
	self initFromApacheMimeTypes!

initMimeTypes
	mimeTypes := Dictionary new.!

mimeTypes
	mimeTypes isNil ifTrue: [self initMimeTypes].
	^mimeTypes!

removeType: aTypeString andExtension: anExtensionString
	| exts |
	exts := self mimeTypes at: aTypeString ifAbsent: [OrderedCollection new].
	(exts includes: anExtensionString) ifTrue: [exts remove: anExtensionString].
	exts isEmpty ifTrue: [self mimeTypes removeKey: aTypeString ifAbsent: [] ].
	self fileExtensions removeKey: anExtensionString ifAbsent: [].!

typeForExtension: aString
	| ext |
	aString isNil ifTrue: [^nil].
	ext := aString asLowercase copyWithout: $. .
	^self fileExtensions at: ext ifAbsent: [nil].

"MIMEMap new typeForExtension: 'jpg'"! !
!MIMEMap categoriesFor: #addType:andExtension:!adding-removing!public! !
!MIMEMap categoriesFor: #extensionForType:!accessing!public! !
!MIMEMap categoriesFor: #extensionsForType:!accessing!public! !
!MIMEMap categoriesFor: #fileExtensions!private! !
!MIMEMap categoriesFor: #iconForType:!accessing!public! !
!MIMEMap categoriesFor: #initFileExtensions!initialize-release!public! !
!MIMEMap categoriesFor: #initFromApacheMimeTypes!initialize-release!public! !
!MIMEMap categoriesFor: #initialize!initialize-release!public! !
!MIMEMap categoriesFor: #initMimeTypes!initialize-release!public! !
!MIMEMap categoriesFor: #mimeTypes!private! !
!MIMEMap categoriesFor: #removeType:andExtension:!adding-removing!public! !
!MIMEMap categoriesFor: #typeForExtension:!accessing!public! !

!MIMEMap class methodsFor!

apacheMimeTypes
	"from /etc/httpd/mime.types after Apache v1.3 is installed"

^'application/EDI-Consent
application/EDI-X12
application/EDIFACT
application/activemessage
application/andrew-inset	ez
application/applefile
application/atomicmail
application/cals-1840
application/commonground
application/cybercash
application/cu-seeme		csm cu
application/dca-rft
application/dec-dx
application/eshop
application/excel		xls
application/ghostview
application/hyperstudio
application/iges
application/mac-binhex40	hqx
application/mac-compactpro	cpt
application/macwriteii
application/marc
application/mathematica
application/msword		doc dot wrd
application/news-message-id
application/news-transmission
application/octet-stream	bin dms lha lzh exe class
application/oda			oda
application/pdf			pdf
application/pgp			pgp
application/pgp-encrypted
application/pgp-keys
application/pgp-signature	pgp
application/postscript		ai eps ps
application/powerpoint		ppt
application/remote-printing
application/rtf			rtf
application/slate
application/wita
application/wordperfect5.1	wp5
application/x-123		wk
application/x-Wingz		wz
application/x-bcpio		bcpio
application/x-bzip2		bz2
application/x-cdlink		vcd
application/x-chess-pgn		pgn
application/x-compress		z Z
application/x-cpio		cpio
application/x-csh		csh
application/x-debian-package	deb
application/x-director		dcr dir dxr
application/x-dvi		dvi
application/x-gtar		gtar tgz
application/x-gunzip		gz
application/x-gzip		gz
application/x-hdf		hdf
application/x-httpd-php		phtml pht php
application/x-javascript	js
application/x-kword		kwd kwt
application/x-kspread		ksp
application/x-kpresenter	kpr kpt
application/x-kchart		chrt
application/x-koan		skp skd skt skm
application/x-latex		latex
application/x-maker		frm maker frame fm fb book fbdoc
application/x-mif		mif
application/x-msdos-program	com exe bat
application/x-netcdf		nc cdf
application/x-ns-proxy-autoconfig	pac
application/x-perl		pl pm
application/x-rad		rad
application/x-rpm		rpm spm
application/x-sh		sh
application/x-shar		shar
application/x-shockwave-flash	swf
application/x-stuffit		sit
application/x-sv4cpio		sv4cpio
application/x-sv4crc		sv4crc
application/x-tar		tar
application/x-tcl		tcl
application/x-tex		tex
application/x-texinfo		texinfo texi
application/x-troff		t tr roff
application/x-troff-man		man
application/x-troff-me		me
application/x-troff-ms		ms
application/x-ustar		ustar
application/x-wais-source	src
application/zip			zip
audio/basic			au snd
audio/midi			mid midi kar
audio/mpeg			mpga mp2 mp3
audio/x-aiff			aif aifc aiff
audio/x-realaudio		ra
audio/x-wav			wav
chemical/x-pdb			pdb xyz
image/gif			gif
image/ief			ief
image/jpeg			jpeg jpg jpe
image/png			png
image/tiff			tiff tif
image/x-cmu-raster		ras
image/x-portable-anymap		pnm
image/x-portable-bitmap		pbm
image/x-portable-graymap	pgm
image/x-portable-pixmap		ppm
image/x-rgb			rgb
image/x-xbitmap			xbm
image/x-xpixmap			xpm
image/x-xwindowdump		xwd
message/external-body
message/news
message/partial
message/rfc822
model/iges			igs iges
model/mesh			msh mesh silo
model/vrml			wrl vrml
multipart/alternative
multipart/appledouble
multipart/digest
multipart/mixed
multipart/parallel
text/css			css
text/html			html htm
text/plain			asc txt c cc h hh cpp hpp
text/richtext			rtx
text/rtf			rtf
text/sgml			sgml sgm
text/tab-separated-values	tsv
text/x-setext			etx
text/x-vCalendar		vcs
text/x-vCard			vcf
text/xml			xml dtd
video/dl			dl
video/fli			fli
video/gl			gl
video/mpeg			mp2 mpe mpeg mpg
video/quicktime			qt mov
video/x-msvideo			avi
video/x-sgi-movie		movie
x-conference/x-cooltalk		ice
x-world/x-vrml			wrl vrml
audio/x-pn-realaudio rmm ram
audio/vnd.rn-realaudio ra
application/smil smi smil
text/vnd.rn-realtext rt
video/vnd.rn-realvideo rv
image/vnd.rn-realflash rf swf
application/x-shockwave-flash2-preview rf swf
application/sdp sdp
application/x-sdp sdp
application/vnd.rn-realmedia rm
image/vnd.rn-realpix rp
'!

arrayFromApacheMimeTypes
	| collection stream |
	collection:= OrderedCollection new.
	stream := ReadStream on: self apacheMimeTypes.
	[stream atEnd] whileFalse:
		[ | col line word |
		col := OrderedCollection new.
		line := (stream upTo: Character cr) readStream.
		[line atEnd] whileFalse: [word := line upToSeparator. word notEmpty ifTrue: [col add: word] ].
		collection add: col].
	^collection

"MIMEMap arrayFromApacheMimeTypes"!

default
	^AIDASite default mimeMap!

new
	^super new initialize! !
!MIMEMap class categoriesFor: #apacheMimeTypes!accessing!public! !
!MIMEMap class categoriesFor: #arrayFromApacheMimeTypes!accessing!public! !
!MIMEMap class categoriesFor: #default!accessing!public! !
!MIMEMap class categoriesFor: #new!instance creation!public! !

Numberer guid: (GUID fromString: '{9E9F3086-037E-4BF8-BFA1-D45B5DC4BE9F}')!
Numberer comment: 'Numberer is used to provide counters for things like invoice numbers

Instance Variables:
	counters	<Dictionary>	 counters for different purposes'!
!Numberer categoriesForClass!Unclassified! !
!Numberer methodsFor!

counters
	counters isNil ifTrue: [self initCounters].
	^counters!

currentCounter: aSymbol
	"get curent (last nextCounter) number"
	(self counters includesKey: aSymbol) ifFalse: [self resetCounter: aSymbol].
	^self counters at: aSymbol!

decrementCounter: aSymbol
	"get next number and increment this counter"
	^self counters at: aSymbol put: (((self currentCounter: aSymbol) - 1) max: 0)!

initCounters
	counters := Dictionary new!

nextCounter: aSymbol
	"get next number and increment this counter"
	^self counters at: aSymbol put: (self peekCounter: aSymbol)!

peekCounter: aSymbol
	"get next number but not increment it"
	(self counters includesKey: aSymbol) ifFalse: [self resetCounter: aSymbol].
	^(self counters at: aSymbol) + 1!

resetCounter: aSymbol
	"put counter to 0, peekCounter will then return 1"
	self counters at: aSymbol put: 0!

setCounter: aSymbol to: aNumber
	"use it sparingly!!"
	^self counters at: aSymbol put: aNumber! !
!Numberer categoriesFor: #counters!private! !
!Numberer categoriesFor: #currentCounter:!accessing!public! !
!Numberer categoriesFor: #decrementCounter:!private! !
!Numberer categoriesFor: #initCounters!initialize-release!public! !
!Numberer categoriesFor: #nextCounter:!accessing!public! !
!Numberer categoriesFor: #peekCounter:!accessing!public! !
!Numberer categoriesFor: #resetCounter:!accessing!public! !
!Numberer categoriesFor: #setCounter:to:!private! !

Party guid: (GUID fromString: '{1981774E-FC24-4596-8452-21DE1B67A6A1}')!
Party comment: ''!
!Party categoriesForClass!Unclassified! !
!Party methodsFor!

addRelatedObject: anObject
	(self relatedObjects includes: anObject) ifFalse:
		[self relatedObjects add: anObject].!

addRelatedPartyRole: aRole
	(self relatedPartyRoles includes: aRole) ifTrue: [^nil].
	self relatedPartyRoles add: aRole.!

addresses
	addresses isNil ifTrue: [self initAddresses].
	^addresses!

addRole: aRole
	(self roles includes: aRole) ifTrue: [^nil].
	self roles add: aRole.!

addRoleGroup: aRoleGroup
	(self roleGroups includes: aRoleGroup) ifFalse: [self roleGroups add: aRoleGroup]!

allCustomers
	"return all parties which are my customers, therefore I am a supplier to them"
	| parties |
	parties :=  (self roles select: [:role | role isSupplierRole]) 
		collect: [:each | each relatedParty].
	parties := parties addAll:
		((self relatedPartyRoles select: [:role | role isCustomerRole]) 
			collect: [:each | each party]);
		yourself.
	^parties asSet asOrderedCollection!

allEmployees
	"all employees of that party"
	| parties |
	parties :=  (self roles select: [:role | role isEmployeeRole]) 
		collect: [:each | each relatedParty].
	parties := parties addAll:
		((self relatedPartyRoles select: [:role | role isEmployeeRole]) 
			collect: [:each | each party]);
		yourself.
	^parties asSet asOrderedCollection!

allRelatedRolesFrom: aParty
	"return all roles this party has to me"
	^self relatedPartyRoles select: [:each | each party == aParty]!

allRoleGroups
	^self roleGroups copy!

allRoles
	^self roles copy!

allRolesTo: aParty
	"return all roles I have to this party"
	^self roles select: [:each | each relatedParty == aParty]!

allSuppliers
	"return all parties which supply goods to me, therefore I am a customer of them"
	| parties |
	parties :=  (self roles select: [:role | role isCustomerRole]) 
		collect: [:each | each relatedParty].
	parties := parties addAll:
		((self relatedPartyRoles select: [:role | role isSupplierRole]) 
			collect: [:each | each party]); 
		yourself.
	^parties asSet asOrderedCollection!

bankAccount
	^self bankAccounts notEmpty ifTrue: [self bankAccounts first] ifFalse: [''].!

bankAccount: aString
	self bankAccounts isEmpty ifTrue: 
		[self otherValuesAt: #BankAccounts put: (OrderedCollection new add: ''; yourself) ].
	self bankAccounts at: 1 put: aString.!

bankAccounts
	^self otherValuesAt: #BankAccounts ifAbsent: [OrderedCollection new].!

becomeSiteOwner
	"usual for Companies, SiteOwnerRole has a reference to his WebSite"!

becomeWebUserTo: aWebSiteOwnerPary!

city
	^self mainAddress city!

city: aString
	self mainAddress city: aString!

country
	^self mainAddress country!

country: aString
	self mainAddress country: aString!

description
	description isNil ifTrue: [self description: ''].
	^description!

description: aString
	description := aString!

discontinueAllRoles
	self roles copy do: [:each | self discontinueRole: each].
	self relatedPartyRoles copy do: [:each | self discontinueRole: each]!

discontinueAllRolesTo: aParty
	(self roles select: [:role | role relatedParty == aParty])
		do: [:each | self discontinueRole: each].!

discontinueRole: aRole
	self roles remove: aRole ifAbsent: [].
	aRole relatedParty relatedPartyRoles remove: aRole ifAbsent: [].!

discontinueRoleNamed: aString
	| r |
	r := self roleNamed: aString.
	r notNil ifTrue: [self discontinueRole: r]!

email
	^self mainAddress email!

email: aString
	self mainAddress email: aString!

events
	events isNil ifTrue: [self initEvents].
	^events!

fax
	^self mainAddress fax!

fax: aString
	self mainAddress fax: aString!

id
	id isNil ifTrue: [self id: ''].
	^id!

id: aString
	id := aString.!

initAddresses
	addresses := Dictionary new.!

initEvents
	events := DailyCollection new.!

initOtherValues
	otherValues := Dictionary new.!

initRelatedObjects
	relatedObjects := OrderedCollection new.!

initRelatedPartyRoles
	relatedPartyRoles := OrderedCollection new.!

initRoles
	roles := OrderedCollection new.!

isCompany
	^false!

isCustomerOf: aParty

	| isCustomer |
	isCustomer := self roles contains: [:role | role relatedParty == aParty and: [role isCustomerRole] ].
	isCustomer ifTrue: [^true].
	"check also a complementary role"
	^self relatedPartyRoles contains: [:role | role party == aParty and: [role isSupplierRole] ].!

isOrganizationUnit
	^false!

isPerson
	^false!

isSupplierTo: aParty

	| isSupplier |
	isSupplier := self roles contains: [:role | role relatedParty == aParty and: [role isSupplierRole] ].
	isSupplier ifTrue: [^true].
	"check also a complementary role"
	^self relatedPartyRoles contains: [:role | role party == aParty and: [role isCustomerRole] ].!

mainAddress
	
	^self addresses 
		at: #MainAddress 
		ifAbsent: [self addresses at: #MainAddress put: Address new. self mainAddress].!

migrateToUnicode
	"from iso8859-2"
	id notNil ifTrue: [id := id ensureUnicodeSloveneChars].
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].!

name
	name isNil ifTrue: [self name: ''].
	^name!

name: aString
	name := aString trimBlanks.!

nameNonEmpty
	^self name trimBlanks notEmpty 
		ifTrue: [self name] 
		ifFalse: ['-- no name --'].!

nameToDisplay
	"on web pages for instance"
	^self name!

newRole: aRole
	"new role, but not in relationship with anyone"!

newRole: aRole relatedTo: aParty
	"new role in relationship with other party"
	aRole party: self.
	aRole relatedParty: aParty.
	self addRole: aRole.
	aParty addRelatedPartyRole: aRole.!

newRoleNamed: aString
	"new role, but not in relationship with anyone"
	| new |
	(self roleNames includes: aString) ifTrue: [^self error: 'role with that name already exist'].
	new := Role new name: aString.
	self newRole: new!

newRoleNamed: aString relatedTo: aParty
	"new role in relationship with other party"
	| new |
	(self roleNames includes: aString) ifTrue: [^self error: 'role with that name already exist'].
	new := Role new name: aString.
	self newRole: new relatedTo: aParty!

noMoreCustomerOf: aParty 
	"no more a customer of related party"
	(self isCustomerOf: aParty) ifFalse: [^nil].
	self discontinueRole:
		(self roles detect: [:role | role relatedParty == aParty and: [role isCustomerRole] ] ifNone: [^nil])!

noMoreSupplierTo: aParty 
	"no more a supplier to related party"
	(self isSupplierTo: aParty) ifFalse: [^nil].
	self discontinueRole:
		(self roles detect: [:role | role relatedParty == aParty and: [role isSupplierRole] ] ifNone: [^nil])!

otherValues
	^otherValues!

otherValuesAt: aString
	^self otherValuesAt: aString ifAbsent: [nil]!

otherValuesAt: aString ifAbsent: aBlock
	self otherValues isNil ifTrue: [^aBlock value].
	^self otherValues at: aString ifAbsent: [aBlock value]!

otherValuesAt: aSymbol ifAbsentPut: aBlock
	self otherValues isNil ifTrue: [self initOtherValues].
	^self otherValues at: aSymbol ifAbsent: [self otherValues at: aSymbol put: aBlock value]!

otherValuesAt: aString put: anObject
	self otherValues isNil ifTrue: [self initOtherValues].
	^self otherValues at: aString put: anObject!

partialyConnectedRoles
	"roles, which are not correctly connected to related party and back"
	"not working well yet !!!!!! "
	| col |
	col := self roles reject: [:each | each relatedParty roles contains: [:role | role relatedParty == self] ].
	col addAll: (self relatedPartyRoles 
		reject: [:each | each relatedParty roles contains: [:role | role party == self] ]).
	^col

"Company allInstances select: [:each | each partialyConnectedRoles notEmpty]"!

phone
	^self mainAddress phone!

phone: aString
	self mainAddress phone: aString!

post
	^self mainAddress post!

post: anObject
	^self mainAddress post: anObject!

postalCode
	^self mainAddress postalCode!

postalCode: aString
	self mainAddress postalCode: aString!

printString
	^'party: ', self name!

reconnectEmployees
	"for debugging"
	self allEmployees do: [:each | self removeEmployee: each; addEmployee: each]!

relatedObjects
	relatedObjects isNil ifTrue: [self initRelatedObjects].
	^relatedObjects!

relatedPartyRoles
	relatedPartyRoles isNil ifTrue: [self initRelatedPartyRoles].
	^relatedPartyRoles!

removeRelatedObject: anObject
	self relatedObjects remove: anObject ifAbsent: []!

removeRoleGroup: aRoleGroup
	(self roleGroups includes: aRoleGroup) ifTrue: [self roleGroups remove: aRoleGroup]!

roleGroupNamed: aString
	^self roleGroups detect: [:each | each name = aString] ifNone: [nil]!

roleGroups
	(self otherValuesAt: #roleGroups) isNil ifTrue: 
		[self otherValuesAt: #roleGroups put: OrderedCollection new].
	^self otherValuesAt: #roleGroups!

roleGroupsIncludeRole: aRole
	^self roleGroups select: [:each | each includes: aRole]!

roleGroupWithUuid: aString
	^self roleGroups detect: [:each | each uuid = aString] ifNone: [nil]!

roleNamed: aString
	"find a role with that name"
	^self roles detect: [:each | each name = aString] ifNone: [nil]!

roleNames
	"names of roles this party plays"
	^self roles collect: [:each | each name].!

roles
	roles isNil ifTrue: [self initRoles].
	^roles!

rolesText
	"names of roles this party plays, in one string separated with commas"
	| text |
	text := ''.
	1 to: self roleNames size do: [:inx |
		text := text, (self roleNames at: inx).
		inx = self roleNames size ifFalse: [text := text, ', '] ].
	^text!

searchEmployeesWithSurname: aSurname name: aName
	| surname nme |
	surname := aSurname asLowercase, '*'. nme := aName asLowercase, '*'.
	^self allEmployees select: [:each | 
		(surname match: each surname asLowercase) and: [nme match: each name asLowercase] ]!

searchEmployeesWithSurnameName: aString
	| string nm |
	string := aString asLowercase, '*'. 
	^self allEmployees select: [:each | 
		nm := each surnameName asLowercase.
		(string match: nm)].!

street
	^self mainAddress street!

street: aString
	self mainAddress street: aString!

updateFrom: aParty
	self name: aParty name.
	self description: aParty description.
	self city: aParty city.
	self street: aParty street.
	self postalCode: aParty postalCode.!

uuid
	"unique identifier "
	^self otherValuesAt: #uuid ifAbsentPut: [(AIDASite random next * 1000000000) rounded printString]! !
!Party categoriesFor: #addRelatedObject:!public!related objects! !
!Party categoriesFor: #addRelatedPartyRole:!private! !
!Party categoriesFor: #addresses!accessing!public! !
!Party categoriesFor: #addRole:!private! !
!Party categoriesFor: #addRoleGroup:!public!role groups! !
!Party categoriesFor: #allCustomers!public!roles-specific! !
!Party categoriesFor: #allEmployees!public!roles-specific! !
!Party categoriesFor: #allRelatedRolesFrom:!public!roles-basic! !
!Party categoriesFor: #allRoleGroups!public!role groups! !
!Party categoriesFor: #allRoles!public!roles-basic! !
!Party categoriesFor: #allRolesTo:!public!roles-basic! !
!Party categoriesFor: #allSuppliers!public!roles-specific! !
!Party categoriesFor: #bankAccount!accessing-other!public! !
!Party categoriesFor: #bankAccount:!accessing-other!public! !
!Party categoriesFor: #bankAccounts!accessing-other!public! !
!Party categoriesFor: #becomeSiteOwner!public!roles-specific! !
!Party categoriesFor: #becomeWebUserTo:!public!roles-specific! !
!Party categoriesFor: #city!addresses!public! !
!Party categoriesFor: #city:!addresses!public! !
!Party categoriesFor: #country!addresses!public! !
!Party categoriesFor: #country:!addresses!public! !
!Party categoriesFor: #description!accessing!public! !
!Party categoriesFor: #description:!accessing!public! !
!Party categoriesFor: #discontinueAllRoles!public!roles-basic! !
!Party categoriesFor: #discontinueAllRolesTo:!public!roles-basic! !
!Party categoriesFor: #discontinueRole:!public!roles-basic! !
!Party categoriesFor: #discontinueRoleNamed:!public!roles-basic! !
!Party categoriesFor: #email!addresses!public! !
!Party categoriesFor: #email:!addresses!public! !
!Party categoriesFor: #events!accessing!public! !
!Party categoriesFor: #fax!addresses!public! !
!Party categoriesFor: #fax:!addresses!public! !
!Party categoriesFor: #id!accessing!public! !
!Party categoriesFor: #id:!accessing!public! !
!Party categoriesFor: #initAddresses!initialize - release!public! !
!Party categoriesFor: #initEvents!initialize - release!public! !
!Party categoriesFor: #initOtherValues!initialize - release!public! !
!Party categoriesFor: #initRelatedObjects!initialize - release!public! !
!Party categoriesFor: #initRelatedPartyRoles!initialize - release!public! !
!Party categoriesFor: #initRoles!initialize - release!public! !
!Party categoriesFor: #isCompany!public!testing! !
!Party categoriesFor: #isCustomerOf:!public!roles-specific! !
!Party categoriesFor: #isOrganizationUnit!public!testing! !
!Party categoriesFor: #isPerson!public!testing! !
!Party categoriesFor: #isSupplierTo:!public!roles-specific! !
!Party categoriesFor: #mainAddress!addresses!public! !
!Party categoriesFor: #migrateToUnicode!private! !
!Party categoriesFor: #name!accessing!public! !
!Party categoriesFor: #name:!accessing!public! !
!Party categoriesFor: #nameNonEmpty!accessing!public! !
!Party categoriesFor: #nameToDisplay!accessing!public! !
!Party categoriesFor: #newRole:!public!roles-basic! !
!Party categoriesFor: #newRole:relatedTo:!public!roles-basic! !
!Party categoriesFor: #newRoleNamed:!public!roles-basic! !
!Party categoriesFor: #newRoleNamed:relatedTo:!public!roles-basic! !
!Party categoriesFor: #noMoreCustomerOf:!public!roles-specific! !
!Party categoriesFor: #noMoreSupplierTo:!public!roles-specific! !
!Party categoriesFor: #otherValues!private! !
!Party categoriesFor: #otherValuesAt:!private! !
!Party categoriesFor: #otherValuesAt:ifAbsent:!private! !
!Party categoriesFor: #otherValuesAt:ifAbsentPut:!private! !
!Party categoriesFor: #otherValuesAt:put:!private! !
!Party categoriesFor: #partialyConnectedRoles!private! !
!Party categoriesFor: #phone!addresses!public! !
!Party categoriesFor: #phone:!addresses!public! !
!Party categoriesFor: #post!addresses!public! !
!Party categoriesFor: #post:!addresses!public! !
!Party categoriesFor: #postalCode!addresses!public! !
!Party categoriesFor: #postalCode:!addresses!public! !
!Party categoriesFor: #printString!printing!public! !
!Party categoriesFor: #reconnectEmployees!private! !
!Party categoriesFor: #relatedObjects!accessing!public! !
!Party categoriesFor: #relatedPartyRoles!accessing!public! !
!Party categoriesFor: #removeRelatedObject:!public!related objects! !
!Party categoriesFor: #removeRoleGroup:!public!role groups! !
!Party categoriesFor: #roleGroupNamed:!public!role groups! !
!Party categoriesFor: #roleGroups!public!role groups! !
!Party categoriesFor: #roleGroupsIncludeRole:!public!role groups! !
!Party categoriesFor: #roleGroupWithUuid:!public!role groups! !
!Party categoriesFor: #roleNamed:!public!roles-basic! !
!Party categoriesFor: #roleNames!accessing!public! !
!Party categoriesFor: #roles!accessing!public! !
!Party categoriesFor: #rolesText!accessing!public! !
!Party categoriesFor: #searchEmployeesWithSurname:name:!public!roles-specific! !
!Party categoriesFor: #searchEmployeesWithSurnameName:!public!roles-specific! !
!Party categoriesFor: #street!addresses!public! !
!Party categoriesFor: #street:!addresses!public! !
!Party categoriesFor: #updateFrom:!changing!public! !
!Party categoriesFor: #uuid!accessing!public! !

!Party class methodsFor!

newCustomerOf: aParty

	^super new
		becomeCustomerOf: aParty!

newSupplierTo: aParty

	^super new
		becomeSupplierTo: aParty!

replicationSpec
	"Gemstone"
	^super replicationSpec , 
		#( 	(id 	replicate)
			(name replicate)
			(description replicate)
			(addresses max 4)
			(roles max 2)
			(relatedPartyRoles max 2)
			(events forwarder)
			(relatedObjects max 1) )! !
!Party class categoriesFor: #newCustomerOf:!instance creation!public! !
!Party class categoriesFor: #newSupplierTo:!instance creation!public! !
!Party class categoriesFor: #replicationSpec!odb specific!public! !

PartyCollection guid: (GUID fromString: '{73318498-8873-4B00-AFD7-2FAEB098C7C8}')!
PartyCollection comment: 'PartyCollection is used for doing many thing on mix of org.units, roles, rolegroups and persons. For instance, geting out all persons from above mix ...

Instance Variables:
	parent	<aParty>	a root party, conatining that mix of parties (eg. a company)
	parties	<anOrderedCollection>	mix of parties (orgUniits, roles, roleGroups, persons)'!
!PartyCollection categoriesForClass!Unclassified! !
!PartyCollection methodsFor!

add: aPartyOrRole
	"anOrganizationalUnit, aRole, aRoleGroup or aPerson"
	self parties add: aPartyOrRole!

addAll: aPartyCollection
	aPartyCollection do: [:each | self add: each]!

all
	^self parties copy!

allOrgUnits
	^self parties select: [:each | each isKindOf: OrganizationUnit].!

allParentJobRoles
	^self parent allOrgUnits
		inject: OrderedCollection new into: [:col :each | col addAll: each allJobRoles; yourself]!

allParentOrgUnits
	^self parent allOrgUnits!

allParentOrgUnitsRolesPersons
	"sorted in that order.."
	| all |
	all := (SortedCollection withAll: self allParentOrgUnits sortBlock: [:a :b | a name < b name]) 
		asOrderedCollection.
	all addAll: (SortedCollection withAll: self allParentRoleGroups sortBlock: [:a :b | a name < b name]).
	all addAll: (SortedCollection withAll: self allParentJobRoles sortBlock: [:a :b | a name < b name]).
	all addAll: (SortedCollection withAll: self allParentPersons 
		sortBlock: [:a :b | a surnameName < b surnameName]).
	^all!

allParentPersons
	^self parent allEmployees!

allParentRoleGroups
	^self parent allRoleGroups!

allPersons
	"both individual, from job roles and from org.units"
	| persons |
	persons := self onlyPersons asSet.
	persons := self allOrgUnits inject: persons into: [:set :each | set addAll: each allMembers; yourself].
	persons addAll: self allPersonsFromJobRoles.
	persons addAll: self allPersonsFromRoleGroups.
	^persons asOrderedCollection!

allPersonsFromJobRoles
	| jobRoles  |
	jobRoles := self allJobRoles asSet.
	^self allParentPersons select: [:each |
		each jobRole notNil and: [jobRoles includes: each jobRole parentRole] ].

"	^self allJobRoles inject: Set new into: [:set :each | set addAll: each allPersons; yourself]."!

allPersonsFromOrgUnit: anOrgUnit
	| members |
	members := anOrgUnit allMembers asSet.
	^self allPersons select: [:each | members includes: each]!

allPersonsFromRoleGroups
	| jobRoles |
	jobRoles := self allRoleGroups inject: Set new into: [:set :each | set addAll: each allRoles; yourself].
	^self allParentPersons select: [:each |
		each jobRole notNil and: [jobRoles includes: each jobRole parentRole] ]!

allRoleGroups
	^self parties select: [:each | each isKindOf: RoleGroup].!

allSorted
	"org.unitss first, then role groups, roles, persons"
	| all |
	all := (SortedCollection withAll: self allOrgUnits sortBlock: [:a :b | a name < b name]) 
		asOrderedCollection.
	all addAll: (SortedCollection withAll: self allRoleGroups sortBlock: [:a :b | a name < b name]).
	all addAll: (SortedCollection withAll: self allJobRoles sortBlock: [:a :b | a name < b name]).
	all addAll: (SortedCollection withAll: self onlyPersons 
		sortBlock: [:a :b | a surnameName < b surnameName]).
	^all!

from: aPartyCollection
	self initParties.
	self addAll: aPartyCollection!

includes: aPartyOrRole
	^self parties includes: aPartyOrRole!

initParties
	parties := OrderedCollection new.!

notEmpty
	^self parties notEmpty!

onlyPersons
	"just individual persons"
	^self parties select: [:each | each isKindOf: Person]!

parent
	^parent!

parent: aCompany
	"a root company, containing those mix of parties"
	parent := aCompany!

parentPartyOrRoleNamed: aString
	(aString isNil or: [aString isEmpty]) ifTrue: [^nil].
	^self allParentOrgUnitsRolesPersons detect: [:each | each nameToDisplay = aString] ifNone: [nil].!

parties
	parties isNil ifTrue: [self initParties].
	^parties!

partyOrRoleNamed: aString
	^self parties detect: [:each | each nameToDisplay = aString] ifNone: [nil].!

remove: aPartyOrRole
	"anOrganizationalUnit, aRole, aRoleGroup or aPerson"
	self parties remove: aPartyOrRole!

size
	^self parties size!

sort
	"permanently sort a parties collection"
	self from: self allSorted! !
!PartyCollection categoriesFor: #add:!adding-removing!public! !
!PartyCollection categoriesFor: #addAll:!adding-removing!public! !
!PartyCollection categoriesFor: #all!accessing!public! !
!PartyCollection categoriesFor: #allOrgUnits!accessing!public! !
!PartyCollection categoriesFor: #allParentJobRoles!accessing-parent!public! !
!PartyCollection categoriesFor: #allParentOrgUnits!accessing-parent!public! !
!PartyCollection categoriesFor: #allParentOrgUnitsRolesPersons!accessing-parent!public! !
!PartyCollection categoriesFor: #allParentPersons!accessing-parent!public! !
!PartyCollection categoriesFor: #allParentRoleGroups!accessing-parent!public! !
!PartyCollection categoriesFor: #allPersons!accessing!public! !
!PartyCollection categoriesFor: #allPersonsFromJobRoles!accessing!public! !
!PartyCollection categoriesFor: #allPersonsFromOrgUnit:!accessing!public! !
!PartyCollection categoriesFor: #allPersonsFromRoleGroups!accessing!public! !
!PartyCollection categoriesFor: #allRoleGroups!accessing!public! !
!PartyCollection categoriesFor: #allSorted!accessing!public! !
!PartyCollection categoriesFor: #from:!adding-removing!public! !
!PartyCollection categoriesFor: #includes:!public!testing! !
!PartyCollection categoriesFor: #initParties!initialize-release!public! !
!PartyCollection categoriesFor: #notEmpty!public!testing! !
!PartyCollection categoriesFor: #onlyPersons!accessing!public! !
!PartyCollection categoriesFor: #parent!accessing!public! !
!PartyCollection categoriesFor: #parent:!accessing!public! !
!PartyCollection categoriesFor: #parentPartyOrRoleNamed:!accessing-parent!public! !
!PartyCollection categoriesFor: #parties!private! !
!PartyCollection categoriesFor: #partyOrRoleNamed:!accessing!public! !
!PartyCollection categoriesFor: #remove:!adding-removing!public! !
!PartyCollection categoriesFor: #size!accessing!public! !
!PartyCollection categoriesFor: #sort!accessing!public! !

!PartyCollection class methodsFor!

newOn: aCompany
	^super new parent: aCompany!

newOn: aCompany from: aPartyCollection
	^(self newOn: aCompany) from: aPartyCollection! !
!PartyCollection class categoriesFor: #newOn:!instance creation!public! !
!PartyCollection class categoriesFor: #newOn:from:!instance creation!public! !

RDBTable guid: (GUID fromString: '{36EA16EE-EE28-453C-81A3-E15BF2A51CE6}')!
RDBTable comment: ''!
!RDBTable categoriesForClass!Unclassified! !
!RDBTable methodsFor!

codepage
	"return a codepage of a external RDB source"
	codepage isNil ifTrue: [self codepage: self defaultCodepage].
	^codepage!

codepage: aSymbol
	" #cp1250 #cp852 #'7bit' #iso2 #czs    (slovenian codepages) "
	codepage := aSymbol.!

columns
	columns isNil ifTrue: [self initColumns].
	^columns!

columns: anObject
	columns := anObject!

convertRecords
	"convert db records to appropriate smalltalk format"
	| colType |
	1 to: columns size do: [:inx |
		colType := (self columns at: inx) at: 2.
		self records do: [:record |
			record 
				at: inx
				put: (self readFieldFrom: (record at: inx) odbcType: colType) ]
		].!

defaultCodepage
	"default codepage is #7bit "

	^#'7bit'!

environment
	environment isNil ifTrue: [self environment: ''].
	^environment!

environment: aString
	environment := aString!

getTableColumnsFrom: anODBCSession
	| answerStream |
	self initColumns.
	anODBCSession 
		getSQLColumns: nil
		tableOwner: nil
		tableName: self table 
		columnName: nil.
	answerStream := anODBCSession answer.
	self columns: (answerStream upToEnd
		collect: [:each | Array with: (each at: 4) with: (each at: 6)]).!

indexOfColumn: aString

	1 to: self columns size do: [:inx | 
		(self columns at: inx) first asLowercase = aString asLowercase ifTrue: [^inx] ].
	^0!

initColumns
	columns := OrderedCollection new.!

joinWithTable: aTableName myKey: aMyKey itsKey: anItsKey
	"return an outer join of both tables, columns combined"
	| secondTable myKeyInx myKeyPos newRecords itsKeyPos mergedRecord |
	secondTable := 	RDBTable newFromTable: aTableName
		environment: self environment
		username: self username
		password: self password
		codepage: self codepage.
	myKeyPos := self indexOfColumn: aMyKey.
	myKeyInx := Dictionary new.
	newRecords := OrderedCollection new.
	self records do: [:record |
		myKeyInx at: (record at: myKeyPos) put: record ].
	itsKeyPos := secondTable indexOfColumn: anItsKey.
	secondTable records do: [:record |
		(myKeyInx includesKey: (record at: itsKeyPos)) ifTrue:
			[mergedRecord := (myKeyInx at: (record at: itsKeyPos)).
			mergedRecord := mergedRecord, record.
			newRecords add: mergedRecord].
		].
	self records: newRecords.
	self columns: self columns, secondTable columns.!

password
	password isNil ifTrue: [self password: ''].
	^password!

password: aString
	password := aString!

recordNr: aNumber column: aString 
	^(self records at: aNumber) at: (self indexOfColumn: aString)!

records
	"when aRDBTable is created from existing table, all records (rows in a table) are 
	converted and stored in this ordered collection. Fields in each record are stored in 
	another ordered collection as objects of appropriate class (texts as Strings, 
	numbers as Integers or Floats, dates as Dates)"

	records isNil ifTrue: [self records:OrderedCollection new].
	^records!

records: aCollection
	records := aCollection.!

table
	table isNil ifTrue: [self table: ''].
	^table!

table: aString
	table := aString!

typeOfColumn: aString

	1 to: self columns size do: [:inx | 
		(self columns at: inx) first asLowercase = aString asLowercase 
			ifTrue: [^(self columns at: inx) at: 2] ].
	^nil!

username
	username isNil ifTrue: [self username: ''].
	^username!

username: aString
	username := aString! !
!RDBTable categoriesFor: #codepage!accessing!public! !
!RDBTable categoriesFor: #codepage:!accessing!public! !
!RDBTable categoriesFor: #columns!accessing!public! !
!RDBTable categoriesFor: #columns:!private! !
!RDBTable categoriesFor: #convertRecords!private! !
!RDBTable categoriesFor: #defaultCodepage!accessing!public! !
!RDBTable categoriesFor: #environment!accessing!public! !
!RDBTable categoriesFor: #environment:!accessing!public! !
!RDBTable categoriesFor: #getTableColumnsFrom:!public!table reading! !
!RDBTable categoriesFor: #indexOfColumn:!private! !
!RDBTable categoriesFor: #initColumns!initialize - release!public! !
!RDBTable categoriesFor: #joinWithTable:myKey:itsKey:!public!table join! !
!RDBTable categoriesFor: #password!accessing!public! !
!RDBTable categoriesFor: #password:!accessing!public! !
!RDBTable categoriesFor: #recordNr:column:!public!table accessing! !
!RDBTable categoriesFor: #records!accessing!public! !
!RDBTable categoriesFor: #records:!private! !
!RDBTable categoriesFor: #table!accessing!public! !
!RDBTable categoriesFor: #table:!accessing!public! !
!RDBTable categoriesFor: #typeOfColumn:!private! !
!RDBTable categoriesFor: #username!accessing!public! !
!RDBTable categoriesFor: #username:!accessing!public! !

!RDBTable class methodsFor!

fromDemoTable
	"RDBTable fromDemoTable"
	^self newFromTable: 'ks801art'
		environment: 'skladisca'
		username:''
		password: ''
		codepage: #'7bit'.!

joinTwoTables
	"RDBTable joinTwoTables"
	| first merged |
	first := self newFromTable: 'ks801art'
		environment: 'skladisca'
		username:''
		password: ''
		codepage: #'7bit'.
	merged := first joinWithTable: 'ks810kar' myKey: 'SIFRA801' itsKey: 'SIFRA801'.
	^merged.!

newFromTable: aTableString environment: anEnvString username: anUserString password: aPswString

	^super new
		table: aTableString;
		environment: anEnvString;
		username: anUserString;
		password: aPswString;
		readRecords.!

newFromTable: aTableString environment: anEnvString username: anUserString password: aPswString codepage: aSymbol

	^super new
		table: aTableString;
		environment: anEnvString;
		username: anUserString;
		password: aPswString;
		codepage: aSymbol;
		readRecords.! !
!RDBTable class categoriesFor: #fromDemoTable!examples!public! !
!RDBTable class categoriesFor: #joinTwoTables!examples!public! !
!RDBTable class categoriesFor: #newFromTable:environment:username:password:!instance creation!public! !
!RDBTable class categoriesFor: #newFromTable:environment:username:password:codepage:!instance creation!public! !

Role guid: (GUID fromString: '{40671BC2-46F0-4B24-AC38-85ECE27DCFB0}')!
Role comment: ''!
!Role categoriesForClass!Unclassified! !
!Role methodsFor!

isAdminRole
	^self name = 'Skrbnik'!

isCheckerRole
	^self name = 'Kontrolor'!

isCustomerRole
	^false!

isDeputyRole
	^false!

isEmployeeRole
	^false!

isFormerEmployeeRole
	^false!

isJobRole
	^false!

isMeasurerRole
	^self name = 'Merilec'!

isMemberRole
	^false!

isPerson
	^false!

isRole
	^true!

isRoleGroup
	^false!

isStamperRole
	^self name = 'Overovitelj'!

isSupplierRole
	^false!

migrateToUnicode
	"from iso8859-2"
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].!

name
	^name!

name: aString
	name := aString.!

nameToDisplay
	^self name!

party
	^party!

party: aParty
	party := aParty.!

printString
	^'aRole ', self name!

relatedParty
	^relatedParty!

relatedParty: aParty
	relatedParty := aParty.!

uuid
	"some unique identifier. Hash for now, probably unique enough!! "
	^self hash printString! !
!Role categoriesFor: #isAdminRole!public!testing! !
!Role categoriesFor: #isCheckerRole!public!testing! !
!Role categoriesFor: #isCustomerRole!public!testing! !
!Role categoriesFor: #isDeputyRole!public!testing! !
!Role categoriesFor: #isEmployeeRole!public!testing! !
!Role categoriesFor: #isFormerEmployeeRole!public!testing! !
!Role categoriesFor: #isJobRole!public!testing! !
!Role categoriesFor: #isMeasurerRole!public!testing! !
!Role categoriesFor: #isMemberRole!public!testing! !
!Role categoriesFor: #isPerson!public!testing! !
!Role categoriesFor: #isRole!public!testing! !
!Role categoriesFor: #isRoleGroup!public!testing! !
!Role categoriesFor: #isStamperRole!public!testing! !
!Role categoriesFor: #isSupplierRole!public!testing! !
!Role categoriesFor: #migrateToUnicode!private! !
!Role categoriesFor: #name!accessing!public! !
!Role categoriesFor: #name:!accessing!public! !
!Role categoriesFor: #nameToDisplay!accessing!public! !
!Role categoriesFor: #party!accessing!public! !
!Role categoriesFor: #party:!accessing!public! !
!Role categoriesFor: #printString!private! !
!Role categoriesFor: #relatedParty!accessing!public! !
!Role categoriesFor: #relatedParty:!accessing!public! !
!Role categoriesFor: #uuid!accessing!public! !

RoleGroup guid: (GUID fromString: '{2A2EE930-8466-4896-AD84-1C2CF76E9563}')!
RoleGroup comment: 'To group more roles or other groups together. to build a hierarchy of roles. If you use somewhere RoleGroup instead of Role, then you access all Roles together.

Instance Variables:
	name	<String> name of role group
	subroles	<Role | RoleGroup>	group of roles or other role groups'!
!RoleGroup categoriesForClass!Unclassified! !
!RoleGroup methodsFor!

add: aRoleOrGroup
	(self subroles includes: aRoleOrGroup) ifFalse: [self subroles add: aRoleOrGroup]!

allPersonsWithJobRoles
	"collect all persons holding job roles as part of that role group"
	^self allRoles inject: Set new into: [:set :role | set addAll: role allPersons; yourself].!

allRoleGroups
	^self subroles select: [:each | each isRoleGroup]!

allRoles
	^self subroles select: [:each | each isRole]!

includes: aRoleOrGroup
	^self subroles includes: aRoleOrGroup!

initSubroles
	subroles := OrderedCollection new.!

isPerson
	^false!

isRole
	^false!

isRoleGroup
	^true!

migrateToUnicode
	"from iso8859-2"
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].!

name
	^name!

name: aString
	name := aString.!

nameToDisplay
	^name!

printString
	^'aRoleGroup ', self name!

remove: aRoleOrGroup
	(self subroles includes: aRoleOrGroup) ifTrue: [self subroles remove: aRoleOrGroup]!

subroles
	subroles isNil ifTrue: [self initSubroles].
	^subroles!

uuid
	"some unique identifier. Hash for now, probably unique enough!! "
	^self hash printString! !
!RoleGroup categoriesFor: #add:!adding-removing!public! !
!RoleGroup categoriesFor: #allPersonsWithJobRoles!accessing!public! !
!RoleGroup categoriesFor: #allRoleGroups!accessing!public! !
!RoleGroup categoriesFor: #allRoles!accessing!public! !
!RoleGroup categoriesFor: #includes:!adding-removing!public! !
!RoleGroup categoriesFor: #initSubroles!private! !
!RoleGroup categoriesFor: #isPerson!public!testing! !
!RoleGroup categoriesFor: #isRole!public!testing! !
!RoleGroup categoriesFor: #isRoleGroup!public!testing! !
!RoleGroup categoriesFor: #migrateToUnicode!private! !
!RoleGroup categoriesFor: #name!accessing!public! !
!RoleGroup categoriesFor: #name:!accessing!public! !
!RoleGroup categoriesFor: #nameToDisplay!accessing!public! !
!RoleGroup categoriesFor: #printString!private! !
!RoleGroup categoriesFor: #remove:!adding-removing!public! !
!RoleGroup categoriesFor: #subroles!private! !
!RoleGroup categoriesFor: #uuid!accessing!public! !

SwazooAida guid: (GUID fromString: '{4402E8C2-8655-447D-AF47-F66200C284DC}')!
SwazooAida comment: 'SwazooAida is here just for easier start and stop your Aida/Web application server

	- SwazooAida demoStart             "will create and start a demo site http://localhost:8888"
	- SwazooAida startOn: portNum   "will start a site on that port on all IP interfaces, any host"
								      "sie will be created if doesn''t exist yet"
	- SwazooAida start    "will start all existing sites"
	- SwazooAida stop     "will stop all running sites"'!
!SwazooAida categoriesForClass!Unclassified! !
!SwazooAida class methodsFor!

demoStart             
	"will create (if not yet) and start a demo site on http://localhost:8888"
	SwazooServer aidaDemoStart!

demoStop             
	"will stop a demo site on http://localhost:8888"
	SwazooServer aidaDemoStop!

start    
	"will start all existing sites, both Aida ones and others on  Swazoo web server"
	SwazooServer start!

startOn: portNum   
	"will start a site on that port on all IP interfaces, any host"
      "site will be created if doesn't exist yet"
	SwazooServer aidaStartOn: portNum!

stop    
	"will stop all running sites, both Aida ones and other on Swazoo web server"
	SwazooServer stop! !
!SwazooAida class categoriesFor: #demoStart!public!start/stop! !
!SwazooAida class categoriesFor: #demoStop!public!start/stop! !
!SwazooAida class categoriesFor: #start!public!start/stop! !
!SwazooAida class categoriesFor: #startOn:!public!start/stop! !
!SwazooAida class categoriesFor: #stop!public!start/stop! !

URLResolver guid: (GUID fromString: '{2B893DE1-02DD-4581-8FDB-F97E60E5A92D}')!
URLResolver comment: ''!
!URLResolver categoriesForClass!Unclassified! !
!URLResolver methodsFor!

addObject: anObject withURL: aString
	"add an object if not already exist and add url to the collection of urls for that object.
	If aString url point to some other object already, then remove url from that other object"
	"warning, if web elements (such as web apps) will be registered"
	self isWebElement: anObject.
	anObject isNil ifTrue: [^nil]. "do not add nil objects!!"
	self site critical: 
		[(self allWebPages at: anObject ifAbsentPut: [OrderedCollection new])
				add: aString asLowercase.
		(self allURLLinks includesKey: aString asLowercase) ifTrue:
			[(self allWebPages at: (self allURLLinks at: aString asLowercase)	
				ifAbsentPut: [OrderedCollection new])
					remove: aString asLowercase ifAbsent: [] ].
		self allURLLinks at: aString asLowercase put: anObject ].!

allHTMLPagesSize
	"sums sizes of all static pages"

	| fname sum |
	sum := 0.
	self allHTMLPageUrls do: [:url | 
		fname := self site homeDirectory, url.
		fname := fname copyReplaceAll: '/' with: '\'.
		fname asFilename exists 
			ifTrue: [sum := sum + fname asFilename fileSize] ].
	^sum

"URLResolver default allHTMLPagesSize"!

allHTMLPageUrls
	"find all .htm and .html pages in directory hierarchy starting at aWebServer homeDirectory.
	return as collection of relative url links"

	^self allHTMLPageUrlsIn: self site homeDirectory.

"URLResolver default allHTMLPageUrls"!

allHTMLPageUrlsIn: aDirectoryString
	"find all .htm and .html pages in directory hierarchy starting at a specified directory and all 	subdirectories.	Return as collection of relative url links"

	| collection dir |
	dir := aDirectoryString.
	dir last ~= $\ ifTrue: [dir := dir, '\'].
	dir asFilename exists ifFalse: [^#()].
	collection := OrderedCollection new.
	aDirectoryString asFilename directoryContents do: [:each | 
		(dir, each) asFilename isDirectory
			ifTrue: [collection addAll: (self allHTMLPageUrlsIn: (dir, each))]
			ifFalse: 
				[('.htm' match: each asFilename extension) ifTrue:
					[collection add: (self urlForFile: each asString directory: aDirectoryString)] ]
		].
	^collection.

"URLResolver default allHTMLPageUrlsIn: 'h:\wwwroot\planid' "!

allPagesAndCounts

	"return total counts for all objects that have counters, most counted first"

	| collection |
	collection := OrderedCollection new.
	self counters keysAndValuesDo: [:object :counter |
		collection add: (Array
			with: object
			with: counter total)].
	^SortedCollection
		withAll: collection
		sortBlock: [:a :b | (a at: 2) > (b at: 2)]

"URLResolver default allPagesAndCounts"!

allURLLinks
	"return a dictionary with url as key and reference to an object with that url as value"
	^allURLLinks!

allUrlsAndCounters
	"return copies of all counters as dictionary with url as key"
	| dictionary |
	dictionary := Dictionary new.
	self counters keysAndValuesDo: [:object :counter |
		dictionary 
			at: (self halfUrlFor: object)
			put: counter aidaDeepCopy].
	^dictionary

"URLResolver default allUrlsAndCounters"
"
(BinaryObjectStorage onNew: 'counters.boss' asFilename writeStream)
	nextPut: URLResolver default allUrlsAndCounters;
	close
"!

allWebPages
	" return a dictionary with object reference as key and one on more urls for that object as value.
	first  is default one, when urls are dinamicaly generated"
	^allWebPages!

autoUrlFor: anObject
	"use prefered url if possible. If that url already exist, add -a, -b, ... to url and repeat"
	| url extension lastPoint |
	url := anObject preferedUrl. url isNil ifTrue: [^self randomUrlFor: anObject].
	[(self ooRefFromURL: url) notNil] whileTrue: "already exist"
		[lastPoint := url lastIndexOf: $. . lastPoint = 0 ifTrue: [lastPoint := url size+1].
		extension := url copyFrom: lastPoint to: url size.
		url := url copyReplaceAll: extension with: ''. 
		url isEmpty ifTrue:  [^self randomUrlFor: anObject].
		(url size > 1 and: [(url at: url size-1) = $-]) "already have an extension char!!"
			ifTrue: 
				[url last = $z ifTrue: [^self randomUrlFor: anObject]. "only to $z, then back to random!!"
				url := (url copyFrom: 1 to: url size-1), (String with: (url last asInteger + 1) asCharacter)]
			ifFalse: [url := url, '-a'].
		url := url, extension].
	^url

"URLResolver default halfUrlFor: (Document new id: 'SOP-0111-02').
URLResolver default autoUrlFor: (Document new id: 'SOP-0111-02')"!

changeToPreferedURL: anObject
 	"remove all existing urls and make this as only one"
	"BEWARE, all ols urls will be erased, url references can be breaked!! "
	anObject preferedUrl isNil ifTrue: [^nil].
	self removeObject: anObject.
	self defaultURL: anObject preferedUrl forObject: anObject.!

changeToURL: aString forObject: anObject
 	"remove all existing urls and make this as only one"
	"BEWARE, all ols urls will be erased, url references can be breaked!! "
	self removeObject: anObject.
	self defaultURL: aString forObject: anObject.!

correctUrlEncoding
	"make sure all urls are decodedHTTP, without %20 etc"
	self allURLLinks keys do: [:key | (key decodedHTTP ~= key) 
		ifTrue: [self allURLLinks at: key decodedHTTP put: (self allURLLinks at: key). 
			self allURLLinks removeKey: key] ].
	self allWebPages values do: [:coll |
	coll copy do: [:each | (each decodedHTTP ~= each) 
		ifTrue: [coll at: (coll indexOf: each) put: each decodedHTTP] ] ].

"
self allURLLinks keys select: [:key | (key decodedHTTP ~= key)].
self allWebPages associations select: [:assoc |
	assoc value contains: [:each | (each decodedHTTP ~= each)] ].
"!

counterFor: anObject
	anObject isNil ifTrue: [^nil].
	(self counters includesKey: anObject)
		ifFalse: [self resetCounterFor: anObject].
	^self counters at: anObject!

counterForUrl: anUrlString

	"return a counter for object with specified url. Nil if not exist"

	| object  |
	object := self ooRefFromURL: anUrlString.
	object isNil ifTrue: [^nil].
	^self counterFor: object.

"URLResolver default counterForUrl: '/osn/g_l-vse.htm'"
"WebServer default totalCounter"
"WebServer default pagesCounter"!

counters

	"dictionary of web counters for every object, registered in URLResolver"

	counters isNil ifTrue: [self initCounters].
	^counters.!

defaultURL: aString forObject: anObject
	"set url as default url for that object. This url is then used in dynamic url creation. If an object 
	does not already exist, then create a new entry first"
	| urls first defInx |
	self addObject: anObject withURL: aString.  "just in case object is new one"
	"swap old default with new default url on a first place in collection"
	self site critical: 
		[urls := allWebPages at: anObject.
		first := urls first.
		defInx := urls indexOf: aString asLowercase.
		urls at: 1 put: (urls at: defInx).
		urls at: defInx put: first].!

existURL: aString
	"return true if URL has connection to some object"
	^self allURLLinks includesKey: aString asLowercase!

fileProxyForURL: aString
	" Try to find a html file for a specified URL and make aHTMLFileProxy. 
	Returns nil if such a file does not exist. Index content in default WebIndex"
	| add home fname proxy |
	aString isEmpty ifTrue: [^nil].
	(aString last = $/) ifTrue: [add := 'index.htm'] ifFalse: [add := ''].
	home := self site homeDirectory.
	(home last = $/ ) | (home last = $\ ) ifTrue: [home := home copyFrom: 1 to: home size-1].
	fname := home, aString, add.
	SpEnvironment onWindows ifTrue: [fname := fname copyReplaceAll: '/' with: '\'].
	(SpFilename named: fname) exists ifFalse:
		[fname := fname, 'l'.
		(SpFilename named: fname) exists ifFalse: [^nil] ].
	proxy := FileProxy from: fname onSite: self site.
	proxy indexContent.
	^proxy!

fullUrlEncodedSpacesFor: anObject on: aSession
	"change spaces to %20"
	^(self fullUrlFor: anObject on: aSession) copyReplaceAll: ' ' with: '%20'!

fullUrlFor: anObject on: aSession
	"find or make a path for anObject and compose full url together with server address and 
	query string, eg: http://www.eranova.si/welcome.html?view=brief"
	^self 
		fullUrlFromPath: (self halfUrlFor: anObject)
		andParms: (aSession notNil ifTrue: [aSession parms] ifFalse: [#()])
		on: aSession!

fullUrlFromPath: aPathString andParms: aParmsDictionary on: aSession
	"compose full url: server address, document path and additional parameters in query string, 
	for instance: http://www.eranova.si/welcome.html?view=brief"
	| url |
	url := self urlFromHalfUrl: aPathString on: aSession.
	^self halfUrlFromPath: url andParms: aParmsDictionary on: aSession. "not very nice, i know ..."
	
"
| parms |
parms := Dictionary new.
parms at: 'view' put: 'brief'. parms at: 'id' put: '12345'. 
URLResolver default fullUrlFromPath: '/dzs/panorama.html' andParms: parms on: WebSession new
"!

halfUrlFor: anObject
	"finds or composes an URL reference to that object . If the URL is new one, then it is written to both dictionaries for later lookup. If resolution is unsuccessfull then returns nil. If anObject dont have an url yet, url part for them is automatically generated, for example:  /objecto1638948.html"
	| newUrl urls |
	urls := (self allWebPages at: anObject ifAbsent: [
	      newUrl := ((anObject isKindOf: WebPage)  and: [anObject title notNil] )
			ifTrue: ['/', anObject title asLowercase,'.html']			
			ifFalse: [self autoUrlFor: anObject].
		self addObject: anObject withURL: newUrl.
		OrderedCollection with: newUrl]).
	"just in case object has an empty collection of urls"
	(urls isNil or: [urls isEmpty]) ifTrue: 
		[self removeObject: anObject. ^self halfUrlFor: anObject].
	^urls at: 1.!

halfUrlFromPath: aPathString andParms: aParmsDictionary on: aSession
	"compose half url: /document path and additional parameters in query string, for instance: 	/welcome.html?view=brief"
	| url parmsString newValue |
	url := aPathString.
	aParmsDictionary size > 0 ifTrue:
		[parmsString := ''.
		aParmsDictionary keysAndValuesDo: [:name :value |
			(value isKindOf: Set) ifTrue:[newValue := value asArray at: 1]ifFalse:[newValue := value].
			parmsString := parmsString, 
				(AIDASite convertToWebString: name asString), '=', 
				(AIDASite convertToWebString: newValue asString), '&'].  "value"
		url := url, '?', (parmsString copyFrom: 1 to: (parmsString size - 1))].
	^url

"
| parms |
parms := Dictionary new.
parms at: 'view' put: 'brief'. parms at: 'id' put: '12345'. 
URLResolver default halfUrlFromPath: '/dzs/panorama.html' andParms: parms on: WebSession new
"!

incCounterFor: anObject
	"increment a web counter for that object. Only text/html object are counted
	Don't count temporary objects"
	(anObject contentType = 'text/html') ifFalse: [^nil].
	self site critical: 
		[(self counters includesKey: anObject) ifFalse: [self resetCounterFor: anObject].
		(self counters at: anObject) incCounter.
		"self totalCounter incCounter   **aWebServer already counts!! "]!

initCounters
	"init a counters dictionary and open a new counter for each already registered object"
	counters := Dictionary new. 
	self allWebPages keys do: [:object | self resetCounterFor: object].!

initialize
	self initWebPages.
	self initURLLinks.
	self initCounters.!

initURLLinks
	allURLLinks := Dictionary new.!

initWebPages
	allWebPages := IdentityDictionary new.!

isRootURL: aString

	^aString = '/'!

isWebElement: anObject


	" test if anObject is a web element, such as web app and write warning to the transcript"
	
	(anObject isKindOf: WebElement) ifTrue:
		[Transcript cr; show: '*** WARNING: URLResolver detected a ', 
		anObject class printString, '  will be registered ***'; cr.

		"to detect from where this request comes"
		"self halt"
		].!

methodImageForURL: aString 
	"maybe a method image can be done from current WebStyle?"
	|  name selector |
	('/img/*' match: aString) ifFalse: [^nil].
	name := (aString readStream upTo: $/ ; upTo: $/; upTo: $. ) asLowercase.
	selector := self site style class allSelectors 
		detect: [:each | each asString asLowercase = name] ifNone: [^nil].
	^WebMethodImage fromMethod: selector on: self site style contentType: 'image/gif' site: self site

"URLResolver default methodImageForURL: '/img/eranovaLogoGif.gif' "!

objectsOfClass: aClass
	^self allWebPages keys select: [:object | object class = aClass ]

"URLResolver default objectsOfClass: WebMethodImage"!

ooRefFromURL: aString
	" finds a reference to WebPage, specified in a URL string. If not yet known, try to 
	find it as a html file. if not found, search methods in current WebStyle too.."
	| object |
	^self allURLLinks at: aString asLowercase ifAbsent: 
		[(self isRootURL: aString) ifTrue: [^self site defaultUserService].
		object := self fileProxyForURL: aString.
		object isNil ifTrue: [object := self methodImageForURL: aString].
		object notNil ifTrue: [self addObject: object withURL: aString].
		^object].
	

"URLResolver default ooRefFromURL: '/osn/g_l-vse.htm' "!

randomUrlFor: anObject
	| number ext url |
	number := (self site class random next * 10000000) asInteger.
	ext := self site mimeMap extensionForType: anObject contentType.
	ext isNil ifTrue: [ext := 'html'].
	url := '/object/o', number printString, '.', ext.
	^(self ooRefFromURL: url) isNil  "avoid duplicates!!"
		ifTrue: [url]
		ifFalse: [self randomUrlFor: anObject]!

refreshAllHTMLPages
	""

	| count |
	count := 1.
	self allWebPages keys do: [:object |
		(object isKindOf: FileProxy) ifTrue:	 
			[count \\ 10 = 0 ifTrue: [Transcript cr; show: count printString].
			object refreshContent.
			count := count + 1] ].

"URLResolver default refreshAllHTMLPages"!

registerAllHTMLPages
	"if not already, then register all static html pages in directory hierarchy starting
	at aWebServer homeDirectory. Opan also counters for them"

	| count proxy |
	count := 1.
	self allHTMLPageUrls do: [:url | 
		count \\ 10 = 0 ifTrue: [Transcript cr; show: count printString].
		proxy := self ooRefFromURL: url.
		self counterFor: proxy.
		count := count + 1].

"URLResolver default registerAllHTMLPages"!

reindexAllObjects

	"all text/html objects are reindexed"
	self allWebPages keysDo: [:object |
		(object contentType = 'text/html') ifTrue:
			[self site index indexObject: object] ]

"URLResolver default reindexAllObjects"!

reindexNonIndexedObjects
	"all text/html objects are reindexed"
	self allWebPages keysDo: [:object |
		(object contentType = 'text/html') ifTrue:
			[(self site index indexedObjects includesKey: object) ifFalse:
				[self site index indexObject: object] ] ]

"URLResolver default reindexNonIndexedObjects"!

releaseAllHTMLPages

	self allWebPages keys do: [:obj |
		(obj isKindOf: FileProxy) ifTrue:
	 		[obj releaseContent] ]

"URLResolver default releaseAllHTMLPages"!

releaseAllImages

	self allWebPages keys do: [:obj |
		((obj isKindOf: FileProxy) and: ['*image*' match: obj contentType])
			ifTrue: [obj releaseContent] ]

"URLResolver default releaseAllImages"!

releaseAllStaticPages

	self allWebPages keysDo: [:object | 
		(object isKindOf: FileProxy) ifTrue: [object releaseContent] ]

"URLResolver default releaseAllStaticPages"!

removeCounterFor: anObject


	(self counters includesKey: anObject)
		ifTrue: [self counters removeKey: anObject]!

removeNonHTMLCounters

	self counters keys do: [:object |
		object contentType ~= 'text/html' ifTrue:
			[self removeCounterFor: object] ]

"URLResolver default removeNonHTMLCounters"!

removeObject: anObject
	"remove object and all its URLs. Returns true if object existed and false if not. 
	Remove also its web counter"
	| urls |
	self site critical:
		[urls := (self allWebPages at: anObject ifAbsent: [^nil]).
		self allWebPages removeKey: anObject.
		urls notNil ifTrue: [urls do: [: each | self allURLLinks removeKey: each ifAbsent: [] ] ].
		self counters removeKey: anObject ifAbsent: [] ].
	^true!

removeObjectsOfClass: aClass
	self site critical:
		[(self objectsOfClass: aClass) do: [:object | self removeObject: object] ].

"URLResolver default removeObjectsOfClass: WebMethodImage"
"URLResolver default allWebPages size 10934"!

removeObjectsOfClassNamed: aString
	"good for removing Obsolete classes!!"
	self site critical:
		[self allWebPages keys do: [:object | 
			object class name= aString ifTrue: [self removeObject: object]] ].

"URLResolver default removeObjectsOfClassNamed: WebMethodImage"
"URLResolver default allWebPages size 10934"!

removeObjectWithURL: aString

"remove object and all its URLs. Returns true if object existed and false if not"

	| object |
	object := allURLLinks at: aString asLowercase ifAbsent: [^false].
	^self removeObject: object.!

removeURL: aString
	"remove this URL and also object, if this url was the last one pointed to object Returns 
	true if url existed and false if not. Also remove web counter"
	| object |
	self site critical:
		[object := (self allURLLinks at: aString asLowercase ifAbsent: [^nil]).
		(self allWebPages at: object) remove: aString asLowercase ifAbsent: [].
		(self allWebPages at: object) isEmpty ifTrue: [self allWebPages removeKey: object]. 
		self allURLLinks removeKey: aString asLowercase.
		self counters removeKey: object ifAbsent: [] ].
	^true!

resetAllCounters

	self counters values do: [:each | each reset].

"URLResolver default resetAllCounters"!

resetCounterFor: anObject
	"reset counters for specified object. If not yet exist, initialize it first"
	anObject isNil ifTrue: [^nil].
	self site critical:
		[(self counters includesKey: anObject) ifFalse: 
			[self counters at: anObject put: WebCounter new].
		(self counters at: anObject) reset]!

scanForURLsFrom: aWebPage

"start looking for all WebLinks in pages starting from aWebPage and converting them to the URL links in instance variables allWebPages and allURLLinks."!

site
	"a parent site with this url resolver"
	^site!

site: anAIDASite
	site := anAIDASite.!

urlFor: anObject on: aSession

	"finds or composes an URL reference to the given WebPage or any object capable to represent itself as a WebPage. If the URL is new one, then it is written to both dictionaries for later lookup. If resolution is unsuccessfull then returns nil. The second argument is a WebPage where an OO link to resolve exist. If this argument is nil, then an URL must already exist, eg. automatic composition is not possible.
If anObject is not WebPge or has no name, then the url part for them is automatically generated, for example: http://pu.tris-a.si/cgi-bin/stweb?/demo/overview/o1638948.htm"

	^self urlFromHalfUrl: (self halfUrlFor: anObject on: aSession) on: aSession!

urlForFile: aFilenameString directory: aDirectoryString

	| path dir |
	dir := aDirectoryString.
	dir last ~= $\ ifTrue: [dir := dir, '\'].
	path := dir, aFilenameString.
	path := path copyReplaceAll: self site homeDirectory with: ''.
	^path copyReplaceAll: '\' with: '/'

"URLResolver default urlForFile: 'index.htm' directory: 'h:\wwwroot\planid\osn' "!

urlFromHalfUrl: aString on: aSession
	| host port portString protocolString session |
	(self site host ~= '*') 
		ifTrue: [host := self site host. port := self site port]
		ifFalse: [session := aSession notNil ifTrue: [aSession] ifFalse: [self firstSessionFromStack].
			host := (session lastRequest headerAt: 'x-forwarded-host'
				ifAbsent: [[session lastRequest host ]]) value. port := 80].  "find host from request"
	portString := (aSession notNil and: [aSession isEncrypted]) 
		ifFalse: [(port = 80) ifTrue: [''] ifFalse: [':', port printString] ]
		ifTrue: [(self site sslPort = 443) ifTrue: [''] ifFalse: [':', self site sslPort printString] ].
	protocolString := (aSession notNil and: [aSession isEncrypted])  
		ifFalse: ['http://'] ifTrue: ['https://'].
	^protocolString, host asLowercase, portString, aString.! !
!URLResolver categoriesFor: #addObject:withURL:!adding-removing!public! !
!URLResolver categoriesFor: #allHTMLPagesSize!public!static pages! !
!URLResolver categoriesFor: #allHTMLPageUrls!public!static pages! !
!URLResolver categoriesFor: #allHTMLPageUrlsIn:!public!static pages! !
!URLResolver categoriesFor: #allPagesAndCounts!public!request counting! !
!URLResolver categoriesFor: #allURLLinks!private! !
!URLResolver categoriesFor: #allUrlsAndCounters!public!request counting! !
!URLResolver categoriesFor: #allWebPages!private! !
!URLResolver categoriesFor: #autoUrlFor:!private! !
!URLResolver categoriesFor: #changeToPreferedURL:!adding-removing!public! !
!URLResolver categoriesFor: #changeToURL:forObject:!adding-removing!public! !
!URLResolver categoriesFor: #correctUrlEncoding!private! !
!URLResolver categoriesFor: #counterFor:!public!request counting! !
!URLResolver categoriesFor: #counterForUrl:!public!request counting! !
!URLResolver categoriesFor: #counters!private! !
!URLResolver categoriesFor: #defaultURL:forObject:!adding-removing!public! !
!URLResolver categoriesFor: #existURL:!public!testing! !
!URLResolver categoriesFor: #fileProxyForURL:!accessing!public! !
!URLResolver categoriesFor: #fullUrlEncodedSpacesFor:on:!accessing!public! !
!URLResolver categoriesFor: #fullUrlFor:on:!accessing!public! !
!URLResolver categoriesFor: #fullUrlFromPath:andParms:on:!accessing!public! !
!URLResolver categoriesFor: #halfUrlFor:!accessing!public! !
!URLResolver categoriesFor: #halfUrlFromPath:andParms:on:!accessing!public! !
!URLResolver categoriesFor: #incCounterFor:!public!request counting! !
!URLResolver categoriesFor: #initCounters!initialize-release!public! !
!URLResolver categoriesFor: #initialize!initialize-release!public! !
!URLResolver categoriesFor: #initURLLinks!initialize-release!public! !
!URLResolver categoriesFor: #initWebPages!initialize-release!public! !
!URLResolver categoriesFor: #isRootURL:!public!testing! !
!URLResolver categoriesFor: #isWebElement:!private! !
!URLResolver categoriesFor: #methodImageForURL:!accessing!public! !
!URLResolver categoriesFor: #objectsOfClass:!accessing!public! !
!URLResolver categoriesFor: #ooRefFromURL:!accessing!public! !
!URLResolver categoriesFor: #randomUrlFor:!private! !
!URLResolver categoriesFor: #refreshAllHTMLPages!public!static pages! !
!URLResolver categoriesFor: #registerAllHTMLPages!public!static pages! !
!URLResolver categoriesFor: #reindexAllObjects!indexing!public! !
!URLResolver categoriesFor: #reindexNonIndexedObjects!indexing!public! !
!URLResolver categoriesFor: #releaseAllHTMLPages!public!static pages! !
!URLResolver categoriesFor: #releaseAllImages!public!static pages! !
!URLResolver categoriesFor: #releaseAllStaticPages!public!static pages! !
!URLResolver categoriesFor: #removeCounterFor:!public!request counting! !
!URLResolver categoriesFor: #removeNonHTMLCounters!public!request counting! !
!URLResolver categoriesFor: #removeObject:!adding-removing!public! !
!URLResolver categoriesFor: #removeObjectsOfClass:!adding-removing!public! !
!URLResolver categoriesFor: #removeObjectsOfClassNamed:!adding-removing!public! !
!URLResolver categoriesFor: #removeObjectWithURL:!adding-removing!public! !
!URLResolver categoriesFor: #removeURL:!adding-removing!public! !
!URLResolver categoriesFor: #resetAllCounters!public!request counting! !
!URLResolver categoriesFor: #resetCounterFor:!public!request counting! !
!URLResolver categoriesFor: #scanForURLsFrom:!accessing!public! !
!URLResolver categoriesFor: #site!private! !
!URLResolver categoriesFor: #site:!private! !
!URLResolver categoriesFor: #urlFor:on:!accessing!public! !
!URLResolver categoriesFor: #urlForFile:directory:!public!static pages! !
!URLResolver categoriesFor: #urlFromHalfUrl:on:!accessing!public! !

!URLResolver class methodsFor!

default
	^AIDASite default urlResolver!

newOn: anAIDASite
	^super new 
		initialize; 
		site: anAIDASite! !
!URLResolver class categoriesFor: #default!accessing!public! !
!URLResolver class categoriesFor: #newOn:!instance creation!public! !

VersionedObject guid: (GUID fromString: '{3A94E686-9FE8-4258-980C-36D25E805B52}')!
VersionedObject comment: ''!
!VersionedObject categoriesForClass!Unclassified! !
!VersionedObject methodsFor!

allVersions
	^self version allVersionSpecs collect: [:each | each object]!

asNewVersion
	"return a new version of that object with all its current contents"
	| new |
	new := self class new.
	new version: (VersionSpec newFromParent: self for: new).
	self copyContentsTo: new.
	^new!

copyContentsTo: anObject
	"override in subclases to copy contents to a new object"!

currentVersion
	"find a current version of object in a version chain"
	^self version currentVersionSpec object!

initVersion
	self version: (VersionSpec firstFor: self)!

isCurrentVersion
	^self version isCurrent!

isNewestVersion
	^self version isNewest!

isOldestVersion
	^self version isOldest!

isOnlyVersion
	^self version isOldest & self version isNewest!

isVersionedObject
	^true!

newerVersions
	^self version newerVersionSpecs collect: [:each | each object]!

newestVersion
	self isNewestVersion ifTrue: [^self].
	^self newerVersions last!

nextVersion
	"next version of an object in version chain, if any"
	^self version next!

olderVersions
	^self version olderVersionSpecs collect: [:each | each object]!

oldestVersion
	self isOldestVersion ifTrue: [^self].
	^self olderVersions first!

parentVersion
	"older version of an object in version chain, if any. It is a parent of that object, 
	because it is derived from it"
	^self version parent!

setCurrentVersion
	"set this object as current version, which has always the same identity "
	| other |
	self isCurrentVersion ifTrue: [^nil].
	other := self currentVersion.
	self swapIdentityWith: other.
	^other version setCurrent "because other is now me!! "!

swapIdentityWith: anObject
	"carefully adjust object references (object, parent, next) in version specs too!!"
	|  o1 o2 s1Spec s2Spec |
	o1 := self. o2 := anObject.  s1Spec := o1 version. s2Spec := o2 version.
	o1 become: o2.
	s1Spec object: o2. s2Spec object: o1.
	s1Spec isNewest ifFalse:
		[s1Spec next == o2 ifTrue: [s1Spec next: o1] ifFalse: [s1Spec next version parent: o2] ].
	s1Spec isOldest ifFalse:
		[s1Spec parent == o2 ifTrue: [s1Spec parent: o1] ifFalse: [s1Spec parent version next: o2]].
	s2Spec isNewest ifFalse:
		[s2Spec next == o1 ifTrue: [s2Spec next: o2] ifFalse: [s2Spec next version parent: o1] ].
	s2Spec isOldest ifFalse:
		[s2Spec parent == o1 ifTrue: [s2Spec parent: o2] ifFalse: [s2Spec parent version next: o1]].!

version
	version isNil ifTrue: [self initVersion].
	^version!

version: aVersionSpec
	version := aVersionSpec!

versionNumber
	"version number, integer by default, but it can be any string"
	^self version number!

versionNumber: aString
	"set version number other than default"
	^self version number: aString!

versionWithNumber: aString
	"find version with that number"
	| spec |
	spec := self version versionSpecWithNumber: aString.
	^spec notNil ifTrue: [spec object] ifFalse: [nil]! !
!VersionedObject categoriesFor: #allVersions!accessing-versions!public! !
!VersionedObject categoriesFor: #asNewVersion!copying!public! !
!VersionedObject categoriesFor: #copyContentsTo:!copying!public! !
!VersionedObject categoriesFor: #currentVersion!accessing-current!public! !
!VersionedObject categoriesFor: #initVersion!initialize-release!public! !
!VersionedObject categoriesFor: #isCurrentVersion!public!testing! !
!VersionedObject categoriesFor: #isNewestVersion!public!testing! !
!VersionedObject categoriesFor: #isOldestVersion!public!testing! !
!VersionedObject categoriesFor: #isOnlyVersion!public!testing! !
!VersionedObject categoriesFor: #isVersionedObject!public!testing! !
!VersionedObject categoriesFor: #newerVersions!accessing-versions!public! !
!VersionedObject categoriesFor: #newestVersion!accessing-versions!public! !
!VersionedObject categoriesFor: #nextVersion!accessing-versions!public! !
!VersionedObject categoriesFor: #olderVersions!accessing-versions!public! !
!VersionedObject categoriesFor: #oldestVersion!accessing-versions!public! !
!VersionedObject categoriesFor: #parentVersion!accessing-versions!public! !
!VersionedObject categoriesFor: #setCurrentVersion!accessing-current!public! !
!VersionedObject categoriesFor: #swapIdentityWith:!private! !
!VersionedObject categoriesFor: #version!private! !
!VersionedObject categoriesFor: #version:!private! !
!VersionedObject categoriesFor: #versionNumber!accessing!public! !
!VersionedObject categoriesFor: #versionNumber:!accessing!public! !
!VersionedObject categoriesFor: #versionWithNumber:!accessing!public! !

VersionSpec guid: (GUID fromString: '{CE5F7F2F-AF93-43A9-9620-41B115561624}')!
VersionSpec comment: 'VersionSpec defines a versioned object by its number and position in version chain.

Instance Variables:
	number	<String>	 number of that version. Integer by default, but it can be any string
	current	<Boolean> true, if this version is current, that is, most important, released, etc.
	parent	<Object> parent, that is, previous version of that object, nil if noone
	next		<Object> next version of that object, nil if noone'!
!VersionSpec categoriesForClass!Unclassified! !
!VersionSpec methodsFor!

allVersionSpecs
	^self olderVersionSpecs, (Array with: self), self newerVersionSpecs!

clearCurrent
	current := false!

current
	"this version current one? Current version object have a direct url, without 'version=' in query part"
	^current!

current: aBoolean
	current := aBoolean!

currentVersionSpec
	"find a version spec of current object in a chain"
	self isCurrent ifTrue: [^self].
	^self olderVersionSpecs detect: [:each | each isCurrent] ifNone: 
		[^self newerVersionSpecs detect: [:each | each isCurrent] 
			ifNone: [self error: 'no current version!!'] ].!

isCurrent
	^self current!

isNewest
	^self next isNil!

isOldest
	^self parent isNil!

newerVersionSpecs
	"return all version specs of that object, newer than this one"
	self isNewest ifTrue: [^#()].
	^OrderedCollection new 
		add: self next version; addAll: self next version newerVersionSpecs;
		yourself!

next
	"next version of an object in version chain, if any"
	^next!

next: anObject
	next := anObject!

number
	"version number, integer by default, but it can be any string"
	^number!

number: aString
	number := aString!

object
	"object for which is this version spec"
	^object!

object: anObject
	object := anObject!

olderVersionSpecs
	"return all version specs of that object, older than this one"
	self isOldest ifTrue: [^#()].
	^OrderedCollection new 
		addAll: self parent version olderVersionSpecs; add: self parent version;
		yourself!

otherVersionSpecs
	"older and newer versions, if any"
	^self olderVersionSpecs, self newerVersionSpecs!

parent
	"older version of an object in version chain, if any. It is a parent of that object, 
	because it is derived from it"
	^parent!

parent: anObject
	parent := anObject!

printString
	^'aVersionSpec version: ', self number!

setCurrent
	self current: true.
	self otherVersionSpecs do: [:each | each clearCurrent].!

setDefaultNumber
	self isOldest 
		ifTrue: [self number: '1'] 
		ifFalse: [self setIncrementedNumberFromParent]!

setIncrementedNumberFromParent
	"for now, later it should increment last number in string"
	self number: (self parent version number asInteger + 1) printString!

versionSpecWithNumber: aString
	"find spec  with that version number"
	self number = aString ifTrue: [^self].
	^self olderVersionSpecs detect: [:each | each number = aString] ifNone: 
		[^self newerVersionSpecs detect: [:each | each number = aString] ifNone: [nil] ].! !
!VersionSpec categoriesFor: #allVersionSpecs!accessing!public! !
!VersionSpec categoriesFor: #clearCurrent!private! !
!VersionSpec categoriesFor: #current!private! !
!VersionSpec categoriesFor: #current:!private! !
!VersionSpec categoriesFor: #currentVersionSpec!accessing!public! !
!VersionSpec categoriesFor: #isCurrent!public!testing! !
!VersionSpec categoriesFor: #isNewest!public!testing! !
!VersionSpec categoriesFor: #isOldest!public!testing! !
!VersionSpec categoriesFor: #newerVersionSpecs!accessing!public! !
!VersionSpec categoriesFor: #next!accessing!public! !
!VersionSpec categoriesFor: #next:!private! !
!VersionSpec categoriesFor: #number!accessing!public! !
!VersionSpec categoriesFor: #number:!accessing!public! !
!VersionSpec categoriesFor: #object!accessing!public! !
!VersionSpec categoriesFor: #object:!private! !
!VersionSpec categoriesFor: #olderVersionSpecs!accessing!public! !
!VersionSpec categoriesFor: #otherVersionSpecs!accessing!public! !
!VersionSpec categoriesFor: #parent!accessing!public! !
!VersionSpec categoriesFor: #parent:!private! !
!VersionSpec categoriesFor: #printString!private! !
!VersionSpec categoriesFor: #setCurrent!accessing!public! !
!VersionSpec categoriesFor: #setDefaultNumber!initalize-release!public! !
!VersionSpec categoriesFor: #setIncrementedNumberFromParent!initalize-release!public! !
!VersionSpec categoriesFor: #versionSpecWithNumber:!accessing!public! !

!VersionSpec class methodsFor!

firstFor: anObject
	"for a first version of an object"
	^super new
		object: anObject;
		setDefaultNumber;
		setCurrent!

new
	^self shouldNotImplement!

newFromParent: anOldObject for: aNewObject
	| newSpec |
	newSpec := super new
		object: aNewObject;
		parent: anOldObject;
		setIncrementedNumberFromParent;
		clearCurrent.
	aNewObject version: newSpec.
	anOldObject version next: aNewObject.
	^newSpec! !
!VersionSpec class categoriesFor: #firstFor:!instance creation!public! !
!VersionSpec class categoriesFor: #new!private! !
!VersionSpec class categoriesFor: #newFromParent:for:!instance creation!public! !

WebAdmin guid: (GUID fromString: '{9C78883F-F70A-4879-8CB5-0AC67379DD3A}')!
WebAdmin comment: ''!
!WebAdmin categoriesForClass!Unclassified! !
!WebAdmin methodsFor!

aidaCacheView: aSymbol on: aWebSession
	^false
	"^aSymbol = #login"  "use only for standard throughput benchmark!!"!

host
	^host!

host: aString
	host := aString!

ip
	^ip!

ip: aString
	ip := aString!

port
	^port!

port: aNumber
	port := aNumber! !
!WebAdmin categoriesFor: #aidaCacheView:on:!accessing!public! !
!WebAdmin categoriesFor: #host!accessing!public! !
!WebAdmin categoriesFor: #host:!accessing!public! !
!WebAdmin categoriesFor: #ip!accessing!public! !
!WebAdmin categoriesFor: #ip:!accessing!public! !
!WebAdmin categoriesFor: #port!accessing!public! !
!WebAdmin categoriesFor: #port:!accessing!public! !

WebApplication guid: (GUID fromString: '{71F6265A-87CD-4612-ACA3-67F945BBCF9A}')!
WebApplication comment: ''!
!WebApplication categoriesForClass!Unclassified! !
!WebApplication methodsFor!

acceptInputsAndActionFrom: aRequest
	"this method read form inputs (if any) and write them to the appropriate aspects of model 
	objects. Then calls an action method if any"
	aRequest context form acceptFormInputFrom: aRequest.
	aRequest isAjaxPostWithSingleInput ifFalse:     "ajax posts of single form elements doesn't trigger actions!!"
		[self callActionMethodForButton: (self buttonNameFrom: aRequest) on: aRequest context].
	(aRequest session shouldRedirect not and: [aRequest isAjaxRequest not]) ifTrue:
		[self redirectToView: aRequest view]   "always redirect after post to avoid aidaCtx in Urls!! "!

actionMainSearch
	self actionSearch!

actionSearch
	"a generic action when search button is pressed. It can be in almost every page."
	self indexApp searchString: self search. self search: ''.
	self indexApp actionMain.
	self redirectTo: self site index view: #results!

add: aWebElement
	"add to a form of currently executing context"
	^self context form add: aWebElement!

addContext: aContext
	self contexts at: aContext id put: aContext!

ajaxUpdate: anOldElement from: aRequest
	"update (recreate or refresh) that element"
	| contentElement |
	anOldElement isNil ifTrue:  [^WebElement new].
	anOldElement method isNil ifTrue: [^anOldElement]. "in case of form elements it will return new value!!"
	(aRequest isAjaxPostWithInput and: [anOldElement isStubElement]) "WebButton ajaxSubmit" 
		ifTrue: [^anOldElement]. "otherwise you spoil popupStub, see WebButton prepareScriptForAjaxSubmit"
	contentElement := aRequest context elementId: aRequest ajaxContentElementId.   "will provide a new content"
	(contentElement isNil and: [aRequest context isFirst not]) ifTrue:  "did parent context register that element id?"
		[contentElement := aRequest context parent elementId: aRequest ajaxContentElementId]. 
	contentElement isNil ifTrue: [contentElement := anOldElement]. "most usual situation"
	^contentElement isWebWidget 
		ifTrue: [self ajaxUpdateWidget: anOldElement from: contentElement on: aRequest]    "for App elements"
		ifFalse: [self ajaxUpdateAppElement: anOldElement from: contentElement on: aRequest]!

ajaxUpdateAppElement: anOldElement from: aContentElement on: aRequest
	"update (recreate or refresh) that element created by a method in current App"
	| argument different new |

	argument := aRequest postDataStringAt: 'parm'.   "element creation method with an argument (parm) "
	different := (anOldElement == aContentElement) not.     "content will be from element different that old one"
	different not ifTrue: [aRequest context announceReplacementWith: anOldElement].  "only when content will be from the old element"
		"For new element.. It will be used and reset at first call of WebElement class>>new, 
		which is just in the next line below"
	new := (self class canUnderstand: aContentElement method) 
		ifTrue: [(aContentElement method asString last ~= $: ) 
			ifTrue: [self perform: aContentElement method] "this really recreate an element"
			ifFalse: [self perform: aContentElement method with: argument ] ] "object method: parm"
		ifFalse: [WebElement new method: nil].
	aRequest context cancelReplacement. "if any"
	^new!

ajaxUpdateWidget: aElement from: aContentElement "widget" on: aRequest
	"update (recreate or refresh) that widget"
	| argument |
	argument := aRequest postDataStringAt: 'parm'.   "element creation method with an argument (parm) "
	^(aContentElement method asString last = $: )
		ifTrue: [aContentElement perform: aContentElement method with: argument ]
		ifFalse: [aContentElement perform: aContentElement method].!

app
	^self!

ask: aWebElement
	"ask for something, like delete confirmation dialog. Stop execution here until the result is returned. Return 
	that result. See WebDemoApp control flow for examples"
	self show: aWebElement.
	^self context answer!

buttonNameFrom: aRequest
	"return a name of button pressed. Name defines an action to be called"
	"note that image buttons send values in coordinates, like search.x search.y"
	| btname buttonNames postKeys |

	btname := aRequest postDataAt: 'ajaxPressedButton'.  "in case of Ajax form submit"
	btname notNil ifTrue: [^btname value].
	buttonNames := (aRequest context form fieldSet select: [:each | each isButton]) 
		collect: [:each | each name].
	postKeys := aRequest postDataKeys collect: [:key | key copyUpTo: $. ]. "remove .x .y"
	^buttonNames detect: [:each | postKeys includes: each] ifNone: ['']!

cell
	"delegate to the form of currently executing context"
	^self context form cell!

changeObserveeToVersionFor: aRequest
	| object |
	object := self observee versionWithNumber: (self versionFromRequest: aRequest).
	object notNil ifTrue: [self observee: object]!

checkObserveeLanguageFor: aRequest
	"change observee to point to domain object in right language if necessary 
	(from session language or explicit language request in query part of Url)"
	| language new |
	(self isLanguageRequest: aRequest) "language= in query part of url"
		ifTrue: [self session language: (aRequest queryAt: 'language') asSymbol].
	language := self session language.
	new := self observee forLanguage: language.
	new notNil ifTrue: [self observee: new]!

checkObserveeVersionFor: aRequest
	"change observee to point to correct version if necessary"
	(self isVersionRequest: aRequest) ifTrue: [^self changeObserveeToVersionFor: aRequest].
	self observee isCurrentVersion ifFalse: [self observee: self observee currentVersion].!

clear
	"delegate to the window of currently executing context"
	^self context page clear!

clipboard
	^self session clipboard!

context
	"a context of currently executing web request"
	"use sparingly, slow!! "
	^self firstContextFromStack!

contexts
	"a dictionary of context by context id (a unique number)"
	contexts isNil ifTrue: [self initContexts].
	^contexts!

defaultView
	" #main "
	^self class defaultView!

ensureContextForView: aViewSymbol for: aRequest
	aRequest context isNil ifTrue:
		[aRequest context: (self contexts values detect: [:ctx | 
			ctx isFirst and: [ctx view = aViewSymbol] ] ifNone: [nil]).
		aRequest context isNil ifTrue:
			[aRequest context: ((WebContextFirst newOn: self) view: aViewSymbol).
			self addContext: self context] ]!

error
	^self otherAt: #Error!

error: aString
	"error message to be written on web page. "
	self otherAt: #Error put: aString!

errorReport
	"element with report of errors, if any"
	| e |
	e := WebElement newId: #error.  "see WebStyle css42ErrorReport for style definition!! "
	self error notNil ifTrue: [e addText: self error style: '{color: red}'].
	self error: nil.
	^e!

findContextFor: aRequest
	"POSTs and Ajax requests must always have context ids!!. Also set the current context"
	| id |
	id := aRequest contextId.
	(id isNil or: [(self contexts includesKey: id) not]) ifTrue: [^nil].
	^self contexts at: id!

findContextSameViewFor: aRequest
	"if a context for the requested view already exist, use it"
	| requestedView |
	requestedView := aRequest view. 
	requestedView isNil ifTrue: [requestedView := #main].
	^self contexts values 
		detect: [:ctx | ctx isFirst and: [ctx view = requestedView] ] 
		ifNone: [nil]!

helpLink
	"link to help page for current view and App. If not exist, then nothing, exept for 
	admin - link to creation of new help page"
	| link viewName |
	self class == WebHelpPageApp ifTrue: [^WebElement new].
	viewName := self inDefaultView ifTrue: ['main'] ifFalse: [self view asString].
	link := WebLink newClass: #helpLink.
	(self site help existApp: self view: viewName)
		ifTrue: [link text: ('<b>', self style helpText, '</b>') 
			linkTo: (self site help forApp: self view: viewName)]
		ifFalse: [self user inAdminGroup
			ifTrue: [link text: '<b>', self style addHelpText, '</b>' linkTo: self site help; view: 'newPage'; 
				parameter: 'app' value: self class name asString;
				parameter: 'hview' value: viewName]
			ifFalse: [^WebElement new] ].
	^link!

inDefaultView
	"#main or not defined"
	^(self view = self defaultView) | (self view = #'')!

indexApp
	^self site index webAppFor: self session!

indexObservee
	"index or reindex observee of that app"
	^self site index indexObject: self observee!

inEditMode
	^self mode = #edit!

inError
	^self error notNil and: [self error notEmpty]!

initAdminAccess
	"admin group has rights to all views and updates in all Apps!! "
	self site securityManager initAdminAccess.!

initContexts
	contexts := Dictionary new.!

initOther
	other := Dictionary new.!

inViewMode
	^self mode = #view!

isControledByBPMProcess
	"by a BPM process instance, which control a workflow of this app too"
	^self process notNil!

isEncryptionSatisfied
	^(self mustBeEncrypted: self session newView) and: [self session lastRequest isEncrypted not]!

isLanguageRequest: aRequest
	^(aRequest queryAt: 'language') notNil!

isObserveeVersioned
	^self observee isVersionedObject!

isRespondingStreamed
	^self context page isRespondingStreamed!

isVersionRequest: aRequest
	^(self versionFromRequest: aRequest) notNil!

isWebApplication
	^true!

isWebWidget
	^false!

mode
	| mode |
	mode := self otherAt: #Mode.
	^mode isNil 
		ifTrue: [self setViewMode. self mode] 
		ifFalse: [mode]!

mode: aSymbol
	"portlet modes #view #edit "
	self otherAt: #Mode put: aSymbol!

mustBeEncrypted: aViewSymbol
	"check  if this view must be sent encrypted"
	| right |
"	(self observee = self site admin) & (aViewSymbol = #login) ifTrue: [^true]." "!!!!!!"
	 right := self site securityManager 
		isUser: self user
		allowedTo: (self class encryptSymbolFor: aViewSymbol)
		on: self class name.
	^right!

newCell
	"delegate to the form of currently executing context"
	^self context form newCell!

newRow
	"delegate to the form of currently executing context"
	^self context form newRow!

newTable
	"delegate to the form of currently executing context"
	^self context form newTable!

newView: aSymbol
	"in action methods, to direct to a specified view after button pressed"
	self session newView: aSymbol!

observee
	"return reference to an object, for which this app acts as an observer - to make an user interface
	of them"
	^observee!

observee: anObject
	"set the reference to an object, for which this app acts as an observer - to make an user interface
	of them"
	observee := anObject!

other
	^other!

otherAt: aSymbol
	^self otherAt: aSymbol ifAbsent: [nil]!

otherAt: aSymbol ifAbsent: aBlock
	self other isNil ifTrue: [^aBlock value].
	^self other at: aSymbol ifAbsent: aBlock!

otherAt: aSymbol ifAbsentPut: aBlock
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol ifAbsent: [self other at: aSymbol put: aBlock value]!

otherAt: aSymbol put: anObject
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol put: anObject!

pageContentWidth
	"obsolete, rather use direct: self  style... !! "
	^self style pageContentWidth!

pasteFromClipboard
	"get a DocLink with title and url. Nil if clipboard empty"
	self clipboard isEmpty ifTrue: [^nil].
	^self clipboard asDocLink!

printHTMLPageOn: aStream for: aRequest on: aSession
	"For apps we print a window of currently executing context"
	^aRequest context page printHTMLPageOn: aStream for: aRequest on: aSession.!

printWebPageFor: aRequest 
	| ctx |

	ctx := self findCreateOrSerializeContextFor: aRequest. "for posts and ajax just find, never create. Req's context is also set"
	ctx  isNil ifTrue: 
		[^WebPage new addText: 'request for unknown or nonexistent context!!'; yourself].
	(aRequest isPost and: [aRequest isAjaxRequest not]) "be sure to call that before any post data is accessed!! "
		ifTrue: [ctx form registerStreamedFieldsInto: aRequest]. 
	aRequest isPost ifTrue: [ctx startProcess]. "if not already. Always for posts and Ajax"
	ctx isExecutingInOwnProcess 
		ifTrue: 
			[ctx executeRequest: aRequest. "in ctx's process, will actually call our #printWebPageStepTwoFor:"
			ctx first mainSemaphore wait. "Dolphin fix" "until context's process signal end of executing"
			ctx first initMainSemaphore.
			aRequest context isFirst ifTrue: [ctx stopProcess].
			^aRequest context result] "resulted page of context execution"
		ifFalse: [^self printWebPageStepTwoFor: aRequest].!

printWebPageStepTwoFor: aRequest 
	| toLogin |

	self observee isMultilingual 
		ifTrue: [self checkObserveeLanguageFor: aRequest ].  "and change observee if needed"
	self isObserveeVersioned 
		ifTrue: [self checkObserveeVersionFor: aRequest ]. "and change observee if needed"
	toLogin := false. "self isEncryptionSatisfied ifTrue: [toLogin := true]."
	(aRequest  isPost and: [aRequest  isAjaxRequest not]) ifTrue: 
		[(self updateAllowed: aRequest context view) 
			ifTrue: [self acceptInputsAndActionFrom: aRequest] ifFalse: [toLogin := true] ].
	toLogin ifTrue:
		[(self observee == self site admin and: [self session newView = 'login']) 
			ifFalse: [self redirectTo: self site admin view: #login].
		^WebPage new].
	self session lastApp: self. "!!!!!!"
 	aRequest isAjaxRequest ifTrue: [^self respondToAjaxRequest: aRequest].
	self session shouldRedirect ifTrue: [^WebPage new].
	self setProcessFromTaskId. "for BPM engine, if present"
	^self printWebView: aRequest context view for: aRequest.!

process
	"a BPM.Process instance, on which this app is activated by some task"
	^self otherAt: #Process!

process: aBPMProcess
	self other at: #Process put: aBPMProcess!

redirectTo: anObjectOrUrlString
	"redirect browser to a default view for specified object or url link"
	anObjectOrUrlString isNil ifTrue: [^self error: 'redirection target is nil!!'].
	self session redirectLink: (WebLink text:'' linkTo: anObjectOrUrlString).!

redirectTo: anObjectOrUrlString view: aSymbol
	"redirect browser to a specified view for specified object or url link"
	anObjectOrUrlString isNil ifTrue: [^self error: 'redirection target is nil!!'].
	self session redirectLink: (WebLink text:'' linkTo: anObjectOrUrlString view: aSymbol).!

redirectTo: anObjectOrUrlString view: aSymbol parameter: aParmString value: aValueString
	"redirect browser to a specified view for specified object or url link"
	anObjectOrUrlString isNil ifTrue: [^self error: 'redirection target is nil!!'].
	self session redirectLink: ((WebLink text:'' linkTo: anObjectOrUrlString view: aSymbol)
		 parameter: aParmString value: aValueString).!

redirectToView: aSymbol
	"redirect browser to a different view for same observee"
	self session redirectLink: (WebLink text:'' linkTo: self observee view: aSymbol).!

removeContext: aContext
	self contexts removeKey: aContext id ifAbsent: []!

respondToAjaxAutocomplete: aRequest
	| fieldName fieldValue field choices e |
	fieldName := aRequest context request postDataKeys detect: [:each | 'field*' match: each] ifNone: nil.
	fieldValue := (aRequest context request postDataAt: fieldName) value.
	fieldValue := AIDASite convert: fieldValue fromCodepage: #utf8.
	field := aRequest context form fields at: fieldName. 
	choices := field getChoicesForEntry: fieldValue.
	e := WebList newUnordered.
	choices do: [:each || string |
		string := each convertToSloveneChars.
		e add: (WebRawText text: (AIDASite convert: string toCodepage: #utf8))].
	^e!

respondToAjaxCloseWindow: aRequest
	| ctx |
	ctx := aRequest context.
	ctx result: WebElement basicNew.
	ctx parent result: ctx result. "just in case"
	ctx first mainSemaphore signal. " to ensure continuing main thread"
	ctx parent isFirst ifTrue: [ctx parent stopProcess].  "we don't need it anymore"
	ctx close. "finaly the time to safely close our context"!

respondToAjaxInPlaceEditing: aRequest
	| fieldValue field response |
	field := aRequest context elementId: aRequest ajaxElementId.
	field isFormated & aRequest isAjaxWikiFormatedRequest not  ifFalse:
		[fieldValue := (aRequest postDataAt: 'value') value.
		fieldValue := AIDASite convert: fieldValue fromCodepage: #utf8.
		field adaptor value: fieldValue].
"		field allow ifTrue: [(field object isKindOf: Collection)
			ifTrue: [field object at: field aspect put: fieldValue]
			ifFalse: [	field object perform: (field aspect asString, ':') asSymbol with: fieldValue]] ].
"	response := field adaptor value.
	aRequest isAjaxWikiFormatedRequest ifTrue: [response := response asWikiHtml].
	response := AIDASite convert: response toCodepage: #utf8.
	^WebElement new add: (WebRawText text: response); yourself!

respondToAjaxRequest: aRequest
	| oldElement e result ctx |

	oldElement := aRequest context elementId: aRequest ajaxElementId.
	aRequest isAjaxInPlaceEditingRequest ifTrue: [^self respondToAjaxInPlaceEditing: aRequest].
	aRequest isAjaxPostWithInput ifTrue: [self acceptInputsAndActionFrom: aRequest].
	aRequest isAjaxAutocompleteRequest ifTrue: [^self respondToAjaxAutocomplete: aRequest].
	aRequest isAjaxCloseWindowRequest ifTrue: [^self respondToAjaxCloseWindow: aRequest].
	aRequest isAjaxPopupWindowRequest 
		ifTrue: 
			[ctx := aRequest context createNewContext. "is also added to context chain and also to this app"
			ctx request: aRequest.
			aRequest context: ctx. "switch to a new context during th rest of execution"
			e := self ajaxUpdate: oldElement from: aRequest. "recreate the element"
			e := self wrap: e intoPopupWindow: ctx window] "e is now window with wrapped element"
		ifFalse: 
			[e := self ajaxUpdate: oldElement from: aRequest]. "update (recreate or refresh) that element"
	e adaptFormElements.
	aRequest context form registerFormElementsIn: e.
	e prepareToHTMLPrintOn: self session. "to prepare again"
	result := e copy.
	result nilAttributes. "to be just plain element, no div,  to send inner html of original element only"
	aRequest context result: result.
	^result!

row
	"delegate to the form of currently executing context"
	^self context form row!

search
	^self otherAt: #Search!

search: aString
	"search input field"
	self otherAt: #Search put: aString!

session
	"on which this App represent the observed domain object"
	^session!

session: aWebSession
	"on which this App represent the observed domain object"

	session := aWebSession!

setEditMode
	self mode: #edit!

setProcessFromTaskId
	"set a reference to a BPM process instance, which control a workflow of this app too"
	| uuid workitem |
	uuid := self session lastRequest queryAt: 'taskId' ifAbsent: [^nil].
	workitem := self site repository bpm worklist itemWithTaskUuid: uuid for: self user.
	workitem isNil ifTrue: [^nil].
	self process: workitem task process.
	workitem subscribeToApp: self.!

setViewMode
	self mode: #view!

show: aWebElement
	"show something like info dialog. Stop execution here until the dialog is closed. 
	See WebDemoApp control flow for examples"
	| ourCtx popupCtx |

	ourCtx := self context.
	popupCtx := ourCtx request context createNewContext. "is also added to context chain and also to this app"
	popupCtx request: ourCtx request.
	ourCtx request context: popupCtx. "switch to a new context during the rest of execution"
	popupCtx result:
		(self wrap: aWebElement intoPopupWindow: popupCtx window). "e is now window with wrapped element"
	popupCtx result changeContextFrom: ourCtx to: popupCtx. "scan for all references to contexts and change them"
	popupCtx form registerFormElementsIn: aWebElement.  "probably already, but just to be sure"
	ourCtx first mainSemaphore signal. "to return that popup"
	ourCtx wait.
	"now the execution of our process is interrupted until the popup window and therefore its context is closed"!

site
	"reference to a site on which this app shows some object. "
	^self session site!

statisticsPageLink
	"returns a link to a page with day/hour statistic graphs of visits"
	| url link |
	url := self site urlResolver halfUrlFor: self observee.
	link := WebLink linkTo: self site statistics.
	link 
		view: 'page';
		parameter: 'url' value: url.
	^link!

storeThisUrl
	"to a User. It is helpull for return after logon, for instance"
	self user lastAppUrl: self session lastRequest uriString!

style
	^self site style!

table
	"delegate to the form of currently executing context"
	^self context form table!

title
	"delegate to the window of currently executing context"
	^self context page title!

updateAllowed: aViewSymbol
	"check if update is allowed to this observee object with specified view"
	"update for admin login page is always allowed"
	"reregister rights for admin if denial is encountered "
	| right |
	(self observee = self site admin) & (aViewSymbol = #login) ifTrue: [^true].
	 right := self site securityManager 
		isUser: self user allowedTo: (self class updateRightSymbolFor:aViewSymbol)
		on: self class name.
	(right not and: [self session adminAllowed]) ifTrue: 
		[self initAdminAccess. 
		^self updateAllowed: aViewSymbol].
	^right!

user
	"reference to a user of current session "
	^self session user!

versionFromRequest: aRequest
	"for Ajax requests too!!"
	| version |
	version := aRequest queryAt: 'version'.
	version isNil ifTrue:
		[aRequest isAjaxRequest ifFalse: [^nil].
		version := aRequest isPost
			ifTrue: [(aRequest postDataAt: 'version') value]
			ifFalse: [aRequest queryAt: 'version'] ].
	^version!

view
	"view of currently executing web context"
	"use sparingly, slow!! "
	^self context view!

viewAllowed: aViewSymbol
	"check if page view is allowed to this observee object with specified view"
	"admin logon page always allowed"
	"reregister rights for admin if denial is encountered "
	| right |
	(self observee = self site admin) & (aViewSymbol = #login) ifTrue: [^true].
	 right := self site securityManager 
		isUser: self user allowedTo: (self class viewRightSymbolFor: aViewSymbol)
		on: self class name.
	(right not and: [self session adminAllowed]) ifTrue: 
		[self initAdminAccess. ^true].
	^right!

visitsCount
	"returns number of visits of this page"
	^self webCounter total!

webCounter
	"returns a counter which counts visits to this page"
	^self site urlResolver
		counterFor: self observee!

window
	"window in of currently executing web context"
	"use sparingly, slow!! "
	^self context window!

wrap: anElement intoPopupWindow: aWebWindow
	"put the element into a WebWindow and prepare it for popup"
	| ctx o l |

	ctx := aWebWindow context.
	aWebWindow addText: '<style>', aWebWindow popupStyle, '</style>'.
	o := WebElement newId: 'overlay', ctx level printString.
	l := (WebElement newId: 'lightbox', ctx level printString) style: 'display: none;'.
	l add: anElement.
	aWebWindow add: o; add: l.
	aWebWindow scriptAfter: 'updateLightboxLevel(', ctx level printString,')'. "from WebStyle>>lightboxJs"
	^aWebWindow! !
!WebApplication categoriesFor: #acceptInputsAndActionFrom:!private-form inputs!public! !
!WebApplication categoriesFor: #actionMainSearch!public!searching! !
!WebApplication categoriesFor: #actionSearch!public!searching! !
!WebApplication categoriesFor: #add:!private-window delegation!public! !
!WebApplication categoriesFor: #addContext:!private-contexts!public! !
!WebApplication categoriesFor: #ajaxUpdate:from:!private-ajax!public! !
!WebApplication categoriesFor: #ajaxUpdateAppElement:from:on:!aida port error!private-ajax!public! !
!WebApplication categoriesFor: #ajaxUpdateWidget:from:on:!private-ajax!public! !
!WebApplication categoriesFor: #app!accessing!public! !
!WebApplication categoriesFor: #ask:!control flow!public! !
!WebApplication categoriesFor: #buttonNameFrom:!private-form inputs!public! !
!WebApplication categoriesFor: #cell!private-window delegation!public! !
!WebApplication categoriesFor: #changeObserveeToVersionFor:!private-versions!public! !
!WebApplication categoriesFor: #checkObserveeLanguageFor:!private-multilingual!public! !
!WebApplication categoriesFor: #checkObserveeVersionFor:!private-versions!public! !
!WebApplication categoriesFor: #clear!private-window delegation!public! !
!WebApplication categoriesFor: #clipboard!clipboard!public! !
!WebApplication categoriesFor: #context!accessing!public! !
!WebApplication categoriesFor: #contexts!private-contexts!public! !
!WebApplication categoriesFor: #defaultView!accessing!public! !
!WebApplication categoriesFor: #ensureContextForView:for:!private-contexts!public! !
!WebApplication categoriesFor: #error!error reporting!public! !
!WebApplication categoriesFor: #error:!error reporting!public! !
!WebApplication categoriesFor: #errorReport!error reporting!public! !
!WebApplication categoriesFor: #findContextFor:!private-contexts!public! !
!WebApplication categoriesFor: #findContextSameViewFor:!private-contexts!public! !
!WebApplication categoriesFor: #helpLink!private-printing!public! !
!WebApplication categoriesFor: #inDefaultView!accessing!public! !
!WebApplication categoriesFor: #indexApp!public!searching! !
!WebApplication categoriesFor: #indexObservee!public!searching! !
!WebApplication categoriesFor: #inEditMode!accessing-modes!public! !
!WebApplication categoriesFor: #inError!error reporting!public! !
!WebApplication categoriesFor: #initAdminAccess!public!security! !
!WebApplication categoriesFor: #initContexts!initialize-release!public! !
!WebApplication categoriesFor: #initOther!initialize-release!public! !
!WebApplication categoriesFor: #inViewMode!accessing-modes!public! !
!WebApplication categoriesFor: #isControledByBPMProcess!private-bpm!public! !
!WebApplication categoriesFor: #isEncryptionSatisfied!public!security! !
!WebApplication categoriesFor: #isLanguageRequest:!private-multilingual!public! !
!WebApplication categoriesFor: #isObserveeVersioned!private-versions!public! !
!WebApplication categoriesFor: #isRespondingStreamed!private-window delegation!public! !
!WebApplication categoriesFor: #isVersionRequest:!private-versions!public! !
!WebApplication categoriesFor: #isWebApplication!private! !
!WebApplication categoriesFor: #isWebWidget!private! !
!WebApplication categoriesFor: #mode!accessing-modes!public! !
!WebApplication categoriesFor: #mode:!private! !
!WebApplication categoriesFor: #mustBeEncrypted:!public!security! !
!WebApplication categoriesFor: #newCell!private-window delegation!public! !
!WebApplication categoriesFor: #newRow!private-window delegation!public! !
!WebApplication categoriesFor: #newTable!private-window delegation!public! !
!WebApplication categoriesFor: #newView:!public!redirection! !
!WebApplication categoriesFor: #observee!accessing!public! !
!WebApplication categoriesFor: #observee:!private! !
!WebApplication categoriesFor: #other!private-other!public! !
!WebApplication categoriesFor: #otherAt:!private-other!public! !
!WebApplication categoriesFor: #otherAt:ifAbsent:!private-other!public! !
!WebApplication categoriesFor: #otherAt:ifAbsentPut:!private-other!public! !
!WebApplication categoriesFor: #otherAt:put:!private-other!public! !
!WebApplication categoriesFor: #pageContentWidth!private! !
!WebApplication categoriesFor: #pasteFromClipboard!clipboard!public! !
!WebApplication categoriesFor: #printHTMLPageOn:for:on:!private-printing!public! !
!WebApplication categoriesFor: #printWebPageFor:!private-printing!public! !
!WebApplication categoriesFor: #printWebPageStepTwoFor:!private-printing!public! !
!WebApplication categoriesFor: #process!accessing-other!public! !
!WebApplication categoriesFor: #process:!accessing-other!public! !
!WebApplication categoriesFor: #redirectTo:!public!redirection! !
!WebApplication categoriesFor: #redirectTo:view:!public!redirection! !
!WebApplication categoriesFor: #redirectTo:view:parameter:value:!public!redirection! !
!WebApplication categoriesFor: #redirectToView:!public!redirection! !
!WebApplication categoriesFor: #removeContext:!private-contexts!public! !
!WebApplication categoriesFor: #respondToAjaxAutocomplete:!private-ajax!public! !
!WebApplication categoriesFor: #respondToAjaxCloseWindow:!private-ajax!public! !
!WebApplication categoriesFor: #respondToAjaxInPlaceEditing:!private-ajax!public! !
!WebApplication categoriesFor: #respondToAjaxRequest:!private-ajax!public! !
!WebApplication categoriesFor: #row!private-window delegation!public! !
!WebApplication categoriesFor: #search!accessing-other!public! !
!WebApplication categoriesFor: #search:!accessing-other!public! !
!WebApplication categoriesFor: #session!accessing!public! !
!WebApplication categoriesFor: #session:!private! !
!WebApplication categoriesFor: #setEditMode!accessing-modes!public! !
!WebApplication categoriesFor: #setProcessFromTaskId!private-bpm!public! !
!WebApplication categoriesFor: #setViewMode!accessing-modes!public! !
!WebApplication categoriesFor: #show:!control flow!public! !
!WebApplication categoriesFor: #site!accessing!public! !
!WebApplication categoriesFor: #statisticsPageLink!public!statistics! !
!WebApplication categoriesFor: #storeThisUrl!private-printing!public! !
!WebApplication categoriesFor: #style!accessing!public! !
!WebApplication categoriesFor: #table!private-window delegation!public! !
!WebApplication categoriesFor: #title!private-window delegation!public! !
!WebApplication categoriesFor: #updateAllowed:!public!security! !
!WebApplication categoriesFor: #user!accessing!public! !
!WebApplication categoriesFor: #versionFromRequest:!private-versions!public! !
!WebApplication categoriesFor: #view!accessing!public! !
!WebApplication categoriesFor: #viewAllowed:!public!security! !
!WebApplication categoriesFor: #visitsCount!public!statistics! !
!WebApplication categoriesFor: #webCounter!public!statistics! !
!WebApplication categoriesFor: #window!accessing!public! !
!WebApplication categoriesFor: #wrap:intoPopupWindow:!private-ajax!public! !

!WebApplication class methodsFor!

actionMethodForView: aViewSymbol
	"obsolete, only for WebSecurityManagerApp !!"
	| method viewSymbol |
	viewSymbol := aViewSymbol isEmpty 
		ifTrue: [self defaultView] ifFalse: [aViewSymbol asSymbol].
	method := self composedActionMethodNameForView: viewSymbol.
	(self canUnderstand: method) ifFalse: [^nil].
	^method!

actionMethodForView: aViewSymbol buttonName: aString
	"if no method for that button name, try to call action method without button name"
	| method viewSymbol |
	viewSymbol := aViewSymbol asString isEmpty 
		ifTrue: [self defaultView] ifFalse: [aViewSymbol asSymbol].
	method := self composedActionMethodNameForView: viewSymbol buttonName: aString.
	(self canUnderstand: method) ifTrue: [^method].
	'search' = aString ifTrue: [^#actionSearch].
	method := self composedActionMethodNameForView: viewSymbol.
	(self canUnderstand: method) ifTrue: [^method].
	^nil!

allComposedViewMethods
	| methods |
	methods := self selectors select: [:each | 'view*' match:each asString].
	methods := methods reject: [:each | 
		#(view viewAllowed: viewMethodForView: ) includes: each].
	^self superclass isWebApplication 
		ifTrue: [methods addAll: self superclass allComposedViewMethods; yourself]
		ifFalse: [methods]

"WebDemoApp new class allComposedViewMethods"!

allComposedViews
	"remove 'view' and lowercase start of remining part of method to get a view name from method"
	^self allComposedViewMethods collect: [:each | 
		((String with: (each at: 5) asLowercase), 
			(each copyReplaceFrom: 1 to: 5 with: String new)) asSymbol].

"WebDemoApp new class allComposedViews"!

allowAllUpdatesFor: aWebUserOrGroup on: anAIDASite
	"set access rigths to allow all updates on that web app for specified user or group 
	on specified server"
	self allWebAppClasses do: [:appClass |
		appClass allViews do: [:appView |
			anAIDASite securityManager
				setAccessRights: (appClass updateRightSymbolFor: appView)
				for: aWebUserOrGroup
				on: appClass name] ].

"
WebSecurityManagerApp allowAllUpdatesFor: 
	(WebSecurityManager default adminUser)
		on: AIDASite default
"!

allowAllViewsFor: aWebUserOrGroup on: anAIDASite
	"set access rigths to allow all views on all web apps for specified user or group on specified site"
	self allWebAppClasses do: [:appClass |
		appClass allViews do: [:appView |
			anAIDASite securityManager
				setAccessRights: (appClass viewRightSymbolFor: appView)
				for: aWebUserOrGroup
				on: appClass name] ].
"
WebApplication allowAllViewsFor: 
	(WebSecurityManager default adminUser)
	on: AIDASite default
"!

allViews
	^self allComposedViews!

allWebAppClasses
	"return an ordered collection with a WebApplication class all their subclasses ordered
	by levels of inheritance and by class name on the same level"
	| classes |
	classes := OrderedCollection new.
	self allWebAppClassesTo: classes.
	^classes

"WebApplication allWebAppClasses"!

allWebAppClassesTo: aCollection 
	"return an ordered collection with a WebApplication class all their subclasses ordered
	by levels of inheritance and by class name on the same level"
	| subcls |
	aCollection add: self.
	subcls := SortedCollection withAll: self subclasses
				sortBlock: [:a :b | a name < b name].
	subcls do: [:subclass | subclass allWebAppClassesTo: aCollection]!

appClassLevel
	"return the level of inheritance of a class, relative to a WebApplication class"
	| level cls |
	level := 1.
	cls := self.
	[cls == WebApplication] whileFalse: 
			[level := level + 1.
			cls := cls superclass].
	^level!

capitalizeName: aString
	"make first char uppercase"
	aString isEmpty ifTrue: [^''].
	^(String with: aString first asUppercase), (aString copyFrom: 2 to: aString size)

"WebApplication capitalizeName: 'main' "!

composedActionMethodNameForView: aViewName
	^('action', (self capitalizeName: aViewName asString)) asSymbol

"WebApplication composedActionMethodNameForView: 'main'"!

composedActionMethodNameForView: aViewName buttonName: aString
	^((self composedActionMethodNameForView: aViewName) asString,
		(self capitalizeName: aString)) asSymbol.

"WebApplication composedActionMethodNameForView: 'main' buttonName: 'addFolder'"!

composedMethodNameForView: aViewName
	^('view', (self capitalizeName: aViewName asString)) asSymbol

"WebApplication new class composedMethodNameForView: 'main'"!

defaultView
	^#main!

encryptSymbolFor: aViewSymbol
	"if view does not exist, then use a default (first) view. Be sure to use a
	sublclass of WebApplication when calling that method to find the right default view"
	| view allViews|
	allViews := self allViews.
	allViews isEmpty ifTrue: [^nil].
	view := (allViews includes: aViewSymbol)
		ifTrue: [aViewSymbol]
		ifFalse: [self defaultView].
	view := (String with: view asString first asUppercase), 
		(view asString copyFrom: 2 to: view asString size).
	^('encrypt', view asString) asSymbol!

isWebApplication
	^true!

newFor: anObject on: aSession
	"guess a class from anObject class name (class name + 'App') and create instance of it"
	| instance |
	instance := self newFromNameFor: anObject on: aSession.
	instance isNil ifTrue: [^nil].
	^instance session: aSession!

updateRightSymbolFor: aViewSymbol
	"return a right symbol, used for setting/testing rights to update a page with specified view.
	A symbol is composed as follows: '#upd',<aViewSymbol> for expample for view #brief
	result is #updbrief"
	"if view does not exist, then use a default (first) view. Be sure to use a
	sublclass of WebApplication when calling that method to find the right defult view"
	| view allViews|
	allViews := self allViews.
	allViews isEmpty ifTrue: [^nil].
	view := (allViews includes: aViewSymbol)
		ifTrue: [aViewSymbol]
		ifFalse: [self defaultView].
	view := (String with: view asString first asUppercase), 
		(view asString copyFrom: 2 to: view asString size).
	^('upd', view) asSymbol!

viewMethodForView: aViewSymbol
	| method viewSymbol |
	viewSymbol := aViewSymbol isEmpty 
		ifTrue: [self defaultView] ifFalse: [aViewSymbol].
	method := self composedMethodNameForView: viewSymbol.
	(self canUnderstand: method) ifFalse: [^nil].
	^method

"WebDemoApp new class viewMethodForView: #imageGallery"!

viewRightSymbolFor: aViewSymbol
	"return a right symbol, used for setting/testing rights to view a page with specified view.
	a symbol is composed as follows: '#view',<aViewSymbol> for expample for view #brief
	result is #viewbrief"
	"if view does not exist, then use a default (first) view. Be sure to use a
	sublclass of WebApplication when calling that method to find the right defult view"
	| view allViews|
	allViews := self allViews. allViews isEmpty ifTrue: [^nil].
	view := (allViews includes: aViewSymbol)
		ifTrue: [aViewSymbol]
		ifFalse: [self defaultView].
	view := (String with: view asString first asUppercase), 
		(view asString copyFrom: 2 to: view asString size).
	^('view', view) asSymbol! !
!WebApplication class categoriesFor: #actionMethodForView:!public!view, action methods! !
!WebApplication class categoriesFor: #actionMethodForView:buttonName:!public!view, action methods! !
!WebApplication class categoriesFor: #allComposedViewMethods!private! !
!WebApplication class categoriesFor: #allComposedViews!private! !
!WebApplication class categoriesFor: #allowAllUpdatesFor:on:!public!security! !
!WebApplication class categoriesFor: #allowAllViewsFor:on:!public!security! !
!WebApplication class categoriesFor: #allViews!accessing!public! !
!WebApplication class categoriesFor: #allWebAppClasses!accessing!public! !
!WebApplication class categoriesFor: #allWebAppClassesTo:!private! !
!WebApplication class categoriesFor: #appClassLevel!private! !
!WebApplication class categoriesFor: #capitalizeName:!private! !
!WebApplication class categoriesFor: #composedActionMethodNameForView:!private! !
!WebApplication class categoriesFor: #composedActionMethodNameForView:buttonName:!private! !
!WebApplication class categoriesFor: #composedMethodNameForView:!private! !
!WebApplication class categoriesFor: #defaultView!accessing!public! !
!WebApplication class categoriesFor: #encryptSymbolFor:!public!security! !
!WebApplication class categoriesFor: #isWebApplication!private! !
!WebApplication class categoriesFor: #newFor:on:!instance creation!public! !
!WebApplication class categoriesFor: #updateRightSymbolFor:!public!security! !
!WebApplication class categoriesFor: #viewMethodForView:!public!view, action methods! !
!WebApplication class categoriesFor: #viewRightSymbolFor:!public!security! !

WebCache guid: (GUID fromString: '{18254B4A-EEA7-4DEC-BBC9-C8660ABF1897}')!
WebCache comment: ''!
!WebCache categoriesForClass!Unclassified! !
!WebCache methodsFor!

addObject: anObject view: aViewSymbol content: aByteStringOrArray timeout: aSeconds
	| views |
	views := self objects at: anObject ifAbsentPut: [Dictionary new].
	views at: aViewSymbol put: 
		(WebCacheEntry new content: aByteStringOrArray; timeout: aSeconds)!

cacheTimeout
	"in seconds, how long cache entry lives until is invalidated"
	"default is one day"
	^self settingsAt: #CacheDuration ifAbsentPut: [24*3600]!

cacheTimeout: aSeconds
	"in seconds, how long cache entry lives until is invalidated"
	^self settingsAt: #CacheDuration put: aSeconds!

entryForObject: anObject view: aViewSymbol
	^(self objects at: anObject ifAbsent: [^nil])
		at: aViewSymbol ifAbsent: [nil]!

initObjects
	objects := Dictionary new!

initOther
	other := Dictionary new!

initSettings
	settings := Dictionary new!

invalidateObject: anObject
	"if exist then cache entries for that object are not valid anymore and shall be refreshed"
	self removeObject: anObject!

isCached: anObject to: aRequest on: aWebSession
	| entry |
	entry := ((self objects at: anObject ifAbsent: [^false])
		at: aRequest view ifAbsent: [^false]).
	entry isTimedOut 
		ifTrue: [self removeObject: anObject view: aRequest view. ^false].
	^true!

objects
	"a dictionary of cache entries per domain object per view"
	objects isNil ifTrue: [self initObjects].
	^objects!

other
	^other!

otherAt: aSymbol
	"other values"
	^self otherAt: aSymbol ifAbsent: [nil]!

otherAt: aSymbol ifAbsent: aBlock
	"other values"
	self other isNil ifTrue: [^aBlock value].
	^self other at: aSymbol ifAbsent: aBlock!

otherAt: aSymbol ifAbsentPut: aBlock
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol ifAbsent: [self other at: aSymbol put: aBlock value]!

otherAt: aSymbol put: anObject
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol put: anObject!

parent
	^parent!

parent: anObject
	parent := anObject!

purgeCache
	"invalidate all timed-out cache entries"
	"run it from time to time, like every day from SwazooServer>>watchogOther"
	self objects associations do: [:assoc |
		assoc value associations do: [:vassoc | vassoc value isTimedOut 
			ifTrue: [self removeObject: assoc key view: vassoc key] ] ]!

removeObject: anObject
	self objects removeKey: anObject ifAbsent: [nil]!

removeObject: anObject view: aViewSymbol
	| views |
	views := self objects at: anObject ifAbsent: [^nil].
	views removeKey: aViewSymbol ifAbsent: [^nil].
	views isEmpty ifTrue: [self removeObject: anObject].!

settings
	settings isNil ifTrue: [self initSettings].
	^settings!

settingsAt: aSymbol
	^self settingsAt: aSymbol ifAbsent: [nil]!

settingsAt: aSymbol ifAbsent: aBlock
	^self settings at: aSymbol ifAbsent: aBlock!

settingsAt: aSymbol ifAbsentPut: aValue
	^self settings at: aSymbol ifAbsentPut: aValue!

settingsAt: aSymbol put: aValue
	^self settings at: aSymbol put: aValue!

shouldCache: anObject to: aRequest on: aWebSession
	^anObject aidaCacheView: aRequest view on: aWebSession!

site	
	^self parent!

store: aByteStringOrArray for: anObject to: aRequest on: aWebSession
	| timeout |
	timeout := anObject aidaCacheTimeout notNil
		ifTrue: [anObject aidaCacheTimeout notNil] "per domain object cache timeout"
		ifFalse: [self cacheTimeout]. 		"global cache timeout"
	self addObject: anObject view: aRequest view 
		content: aByteStringOrArray timeout: timeout! !
!WebCache categoriesFor: #addObject:view:content:timeout:!private-cache!public! !
!WebCache categoriesFor: #cacheTimeout!public!settings! !
!WebCache categoriesFor: #cacheTimeout:!public!settings! !
!WebCache categoriesFor: #entryForObject:view:!private-cache!public! !
!WebCache categoriesFor: #initObjects!initialize-release!public! !
!WebCache categoriesFor: #initOther!initialize-release!public! !
!WebCache categoriesFor: #initSettings!initialize-release!public! !
!WebCache categoriesFor: #invalidateObject:!caching!public! !
!WebCache categoriesFor: #isCached:to:on:!caching!public! !
!WebCache categoriesFor: #objects!private! !
!WebCache categoriesFor: #other!private! !
!WebCache categoriesFor: #otherAt:!private! !
!WebCache categoriesFor: #otherAt:ifAbsent:!private! !
!WebCache categoriesFor: #otherAt:ifAbsentPut:!private! !
!WebCache categoriesFor: #otherAt:put:!private! !
!WebCache categoriesFor: #parent!accessing!public! !
!WebCache categoriesFor: #parent:!private! !
!WebCache categoriesFor: #purgeCache!caching!public! !
!WebCache categoriesFor: #removeObject:!private-cache!public! !
!WebCache categoriesFor: #removeObject:view:!private-cache!public! !
!WebCache categoriesFor: #settings!private! !
!WebCache categoriesFor: #settingsAt:!private! !
!WebCache categoriesFor: #settingsAt:ifAbsent:!private! !
!WebCache categoriesFor: #settingsAt:ifAbsentPut:!private! !
!WebCache categoriesFor: #settingsAt:put:!private! !
!WebCache categoriesFor: #shouldCache:to:on:!caching!public! !
!WebCache categoriesFor: #site!accessing!public! !
!WebCache categoriesFor: #store:for:to:on:!caching!public! !

!WebCache class methodsFor!

newOn: anAIDASite
	^super new
		parent: anAIDASite! !
!WebCache class categoriesFor: #newOn:!instance creation!public! !

WebCacheEntry guid: (GUID fromString: '{24301F32-B0D0-458B-A683-029A6DE1DE1D}')!
WebCacheEntry comment: ''!
!WebCacheEntry categoriesForClass!Unclassified! !
!WebCacheEntry methodsFor!

content
	"cached content"
	^content!

content: aByteStringOrArray
	"cached content"
	content := aByteStringOrArray!

created
	"when the cahce entry was created"
	^SpTimestamp fromSeconds: self createdAsSeconds!

createdAsSeconds
	"when the cahce entry was created"
	^created!

isTimedOut
	^(SpTimestamp now asSeconds - self createdAsSeconds) > self timeout!

setCreated
	created := SpTimestamp now asSeconds!

timeout
	"how many seconds this cached content is valid"
	^timeout!

timeout: aSeconds
	"how many seconds this cached content is valid"
	timeout := aSeconds! !
!WebCacheEntry categoriesFor: #content!accessing!public! !
!WebCacheEntry categoriesFor: #content:!accessing!public! !
!WebCacheEntry categoriesFor: #created!accessing!public! !
!WebCacheEntry categoriesFor: #createdAsSeconds!private! !
!WebCacheEntry categoriesFor: #isTimedOut!public!testing! !
!WebCacheEntry categoriesFor: #setCreated!private! !
!WebCacheEntry categoriesFor: #timeout!accessing!public! !
!WebCacheEntry categoriesFor: #timeout:!accessing!public! !

!WebCacheEntry class methodsFor!

new
	^super new setCreated! !
!WebCacheEntry class categoriesFor: #new!instance creation!public! !

WebClipboard guid: (GUID fromString: '{974E41F8-40C0-4470-A7AE-DC873D187BC3}')!
WebClipboard comment: 'Used for cut/copy/paste page references (not page contents!!) for easier hyperlinking of pages. Every page should have copy action. Then you can paste url to related links section in some other page.

Instance Variables:
	title	<String> title of a page
	url	<String>	url link to a page'!
!WebClipboard categoriesForClass!Unclassified! !
!WebClipboard methodsFor!

asDocLink
	"return clipboard contents as a new DocLink"
	^DocLink new
		title: self title;
		url: self url;
		object: self object!

copyFromDocLink: aDocLink
	self title: aDocLink title.
	self url: aDocLink url.
	self object: aDocLink object!

isEmpty
	^(self url isNil or: [self url isEmpty]) and: [self object isNil].!

object
	^object!

object: anObject
	object := anObject!

title
	^title!

title: anObject
	title := anObject!

url
	^url!

url: anObject
	url := anObject! !
!WebClipboard categoriesFor: #asDocLink!converting!public! !
!WebClipboard categoriesFor: #copyFromDocLink:!converting!public! !
!WebClipboard categoriesFor: #isEmpty!public!testing! !
!WebClipboard categoriesFor: #object!accessing!public! !
!WebClipboard categoriesFor: #object:!accessing!public! !
!WebClipboard categoriesFor: #title!accessing!public! !
!WebClipboard categoriesFor: #title:!accessing!public! !
!WebClipboard categoriesFor: #url!accessing!public! !
!WebClipboard categoriesFor: #url:!accessing!public! !

WebContext guid: (GUID fromString: '{47FCEDF5-E232-419C-8C21-80A499DA9D86}')!
WebContext comment: 'WebContext holds an execution context for a web request. Contexts can be linked in a stack like structure for tree-like control flow (like a confirmation dialog as popup of some delete action)

Instance Variables:
	id		<Integer>	unique id of the context inside one App instance
	parent	<WebContext or WebApplication>	parent in context chain
	child	<WebContext> chils in context chain, if any
	form		<WebForm>	a web form with input fields of this context
	ids		<Dictionary>	 the elements which have id defined, for fast access to them from AJAX requests"'!
!WebContext categoriesForClass!Unclassified! !
!WebContext methodsFor!

activeContext
	"active is always the last context in the chain"
	^self isLast
		ifTrue: [self]
		ifFalse: [self child activeContext]!

announceReplacementWith: anOldElement
	"next #registerId should replace the next element with old one in ids"
	"for robustness svae also the process it announced that!! "
	self replacementAnnouncements at: Processor activeProcess put: anOldElement!

answer
	"answer by the widget called in #ask: or similar methods"
	^answer!

answer: anObject
	"answer by the widget called in #ask: or similar methods"
	answer := anObject!

app
	"the instance of WebApplication on which this context is executing"
	^self parent app!

cancelReplacement
	"cancel next #registerId to replace the next element with old one in ids"

	self replacementAnnouncements removeKey: Processor activeProcess ifAbsent: []!

checkProcessState
	"this is temporary, it must be improved!! "
	"called from #executeRequest: to check if process is in a state to be closed and initialized instead"
	self isInterrupted ifTrue: 
		[self isLast not ifTrue: [self child close].
		self stopProcess; startProcess].!

child
	"another context in the chain, if any"
	^child!

child: aContext
	"add another context in the chain"
	(child notNil and: [aContext notNil]) ifTrue: [child close]. "and remove from app contexts etc."
	child := aContext.
	aContext notNil ifTrue: [aContext parent: self]!

close
	"close process if any and pass control to parent context, which will continue executing itrs process if any" 
	"It also removes itself from context chain"
	self app removeContext: self.
	self isFirst not ifTrue: 
		[self parent child: nil.
		self request notNil ifTrue: 	  " parent context will now continue executing our req (and its old req if different)"
			[self request context: self parent.    "just to be sure" 
			self parent request notNil ifTrue: [self parent request context: self parent]]. 
		self parent isInterrupted 
			ifTrue: [self parent signal] ]. "to continue executing there"
	self request: nil; answer: nil.
	self stopProcess. "can accidentally terminate process on which we are right now executing?"
	self setClosed.!

createNewContext
	"create and add as a child to receiver, also to the app"
	| ctx |
	ctx := WebContext newOn: self.
	self child: ctx.
	self app addContext: ctx.
	^ctx!

currentReplacement
	"an old element to be replaced with a new one"
	^self replacementAnnouncements at:  Processor activeProcess ifAbsent: [nil]!

elementForMethod: aSymbol
	^self registeredSet detect: [:each | each method = aSymbol] ifNone: [nil]!

elementId: aSymbol
	^self ids at: aSymbol ifAbsent: [nil].!

executeRequest: aRequest
	self checkProcessState. "and init processes if deadlocked or something. TEMPORARY!! "
	aRequest context: self. self request: aRequest. "to be sure!!"
	self signal "to wakeup the process which will execute it, see #processLoop"!

finalizeExecutionOf: aRequest
	"do all necessary cleanup after request was composed and HTML streamed to response"
	self request: nil.
	aRequest context: nil.
	self answer: nil; result: nil.!

first
	"first context up in the chain"
	^self parent first!

form
	"a web form with input fields of this context"
	^self window form!

id
	"unique identifier of the context inside the app instance"
	id isNil ifTrue: [self setId].
	^id!

ids
	"dictionary of elements which have id defined, for fast access to them from AJAX requests"
	ids isNil ifTrue: [self initIds].
	^ids!

idt
	"id text, with f at start if first/top context. For debugging"
	^(self isFirst ifTrue: ['f'] ifFalse: ['']), self id printString!

initIds
	ids := Dictionary new.!

initRegisteredSet
	^self ids at: #setOfRegisteredElements put: Set new.!

initReplacementAnnouncements
	^self ids at: #replacementAnnouncements put: Dictionary new.!

initSemaphore
	self semaphore: Semaphore new.!

initWindow
	self window: (WebWindow new parent: self)!

isBusy
	^self isExecuting | self isInterrupted!

isClosed
	"a context is already closed"
	^self state = #closed!

isExecuting
	"a context's process is executing the request"
	^self state = #executing!

isExecutingInOwnProcess
	"context's process will execute the request only if needed, that is, if we have two (or more)
	contexts because first is waiting for second to return some value (like in confirmation dialog)"
	^self process notNil!

isFirst
	"is this first/upper context in the chain?"
	^false!

isIdle
	"a context's process is in idle state, waiting to get a signal to execute next request"
	^self state = #idle!

isInterrupted
	"a context's process is in an interrupted state, waiting for subcontext to finish and close"
	^self state = #interrupted!

isLast
	"is this last/lower context in the chain?"
	^self child isNil!

isNoProcess
	"a context doesn't haveits own process to execute a request"
	^self state = #noprocess!

isRegistered: anElement
	^self registeredSet includes: anElement!

isRegisteredMethod: aSymbol
	aSymbol = #'doesNotUnderstand:' ifTrue: [^false]. "WebStyle methods are somehow such"
	^self registeredSet contains: [:each | each method = aSymbol].!

isWebElement
	"because some elements (like WebWindow, WebPage)  have a context as the parent"
	^false!

level
	"on which level this context is in context chain. First one has level 0"
	^self parent level + 1!

nextId
	" example: #id9. 
	Consider also already registered ids in contexts above in chain if any "
	^'id', (self nextIdNumber printString) asSymbol!

nextIdNumber
	"considering also already registered ids on above contexts"
	| nr |
	nr := self isFirst not ifTrue: [self parent nextIdNumber - 1] ifFalse: [0].
	^nr + self ids size + 1!

page
	"a web page on which we are executing. This is always a window of first context in hte chain"
	^self first window!

parent
	"parent context up in the chain, but an app on the first context"
	^parent!

parent: aContext
	parent := aContext!

printString
	^'aWebContext id ', self id printString!

process
	"a process which executes the request in this context. It can be interrupted and handled to a process from 
	child context. In such case this process is waiting on semaphore for child process to finish and return 
	some value"
	^process!

process: aProcess
	process := aProcess!

processLoop
	[true] whileTrue:
		[self setIdleState.
		self semaphore wait.
		self setExecutingState.
		self request context: self. "to be sure"
		self result: (self app printWebPageStepTwoFor: self request).
		self isFirst
			ifTrue: [self first mainSemaphore signal] "for main connection's process to proceed"
			ifFalse: [self parent answer notNil "if any answer, close me and signal parent"
				ifTrue: [self close] "which will also signal interrupted parent context to continue"		
				ifFalse: [self first mainSemaphore signal]] ] "for main connection's process to proceed"!

processPriority
	^Processor userSchedulingPriority!

registeredSet
	^self ids at: #setOfRegisteredElements ifAbsent: [self initRegisteredSet]!

registerIdFor: anElement
	anElement id isNil ifTrue: [anElement id: self nextId]. "auto id if not manually defined!! "
	(self isRegistered: anElement) ifTrue: [^nil].
	(self ids includesKey: anElement id) ifTrue: 
		[self registeredSet remove: (self ids at: anElement id)]. "to replace with a new one"
	self ids at: anElement id put: anElement.
	self registeredSet add: anElement.!

removeId: aSymbol
	| element |
	element := self ids at: aSymbol ifAbsent: [^nil].
	self ids removeKey: aSymbol.
	self registeredSet remove: element ifAbsent: [].!

replaceIdIn: anElement with: anOldElement
	"new anElement should have same id as an old one"
	anOldElement isNil ifTrue: [^nil].
	self registeredSet 
		remove: anOldElement ifAbsent: []; 
		add: anElement.
	self ids removeKey: anOldElement id ifAbsent: [].
	anElement attributesAt: #id put: anOldElement id. "anElement id: would deadlock!! "
	self ids at: anElement id put: anElement.!

replacementAnnouncements
	"current elememnt id replacement announcements"
	^self ids at: #replacementAnnouncements ifAbsent: [self initReplacementAnnouncements]!

request
	"current, later last request executed on that context"
	^request!

request: aRequest
	"current, later last request executed on that context"
	request := aRequest!

result
	"resulted web element of executing the context"
	^result!

result: aWebElement
	result := aWebElement!

semaphore
	"on this semaphore the context process is waiting for child process to signal finishing its execution and 
	returning a result value"
	semaphore isNil ifTrue: [self initSemaphore].
	^semaphore!

semaphore: aSemaphore
	semaphore := aSemaphore!

serialize: aRequest
	"Serialize execution if some other request is already executing"
	"for now just wait until previous request finish execution"
	[self isBusy ] 
		whileTrue: [(Delay forMilliseconds: 200) wait].!

session
	^self app session!

setClosed
	"a context is already closed"
	self state:  #closed!

setExecutingState
	"a context's process is executing the request"
	self state: #executing!

setId
	"set a random number and check it for uniquines"
	id := (AIDASite random next * 100000) truncated.
	(self app contexts includesKey: self id) ifTrue: [^self setId]  "repeat until unique"!

setIdleState
	"a context's process is in idle state, waiting to get a signal to execute next request"
	self state: #idle!

setInterruptedState
	"a context's process is in an interrupted state, waiting for subcontext to finish and close"
	self state: #interrupted!

setNoProcessState
	"a context doesn't haveits own process to execute a request"
	self state: #noprocess!

signal
	"signal a process to continue"
	self semaphore signal!

startProcess
	self process notNil ifTrue: [^nil].
	self process: ([self processLoop] forkAt: self processPriority)!

state
	" #noprocess #idle #executing #interrupted "
	state isNil ifTrue: [self setNoProcessState].
	^state!

state: aSymbol
	" #noprocess #idle #interrupted "
	state := aSymbol!

stopProcess

	self process isNil ifTrue: [^nil].
	self process terminate.
	self process: nil; semaphore: nil.
	self setNoProcessState!

view
	"view on which context is executed"
	^self first view!

wait
	"a process will be interrupted here until the next signal come"
	self setInterruptedState.
	self initSemaphore. "otherwise it doesn't wait, why?"
	self semaphore wait.
	self setExecutingState.!

window
	"a window (or web page) in which this context execute the request"
	window isNil ifTrue: [self initWindow].
	^window!

window: aWebWindow
	"a window (or web page) in which this context execute the request"
	window := aWebWindow! !
!WebContext categoriesFor: #activeContext!accessing!public! !
!WebContext categoriesFor: #announceReplacementWith:!private-ids!public! !
!WebContext categoriesFor: #answer!accessing!public! !
!WebContext categoriesFor: #answer:!private! !
!WebContext categoriesFor: #app!accessing!public! !
!WebContext categoriesFor: #cancelReplacement!private-ids!public! !
!WebContext categoriesFor: #checkProcessState!private-process!public! !
!WebContext categoriesFor: #child!accessing!public! !
!WebContext categoriesFor: #child:!private! !
!WebContext categoriesFor: #close!executing!public! !
!WebContext categoriesFor: #createNewContext!executing!public! !
!WebContext categoriesFor: #currentReplacement!private-ids!public! !
!WebContext categoriesFor: #elementForMethod:!private-ids!public! !
!WebContext categoriesFor: #elementId:!private-ids!public! !
!WebContext categoriesFor: #executeRequest:!executing!public! !
!WebContext categoriesFor: #finalizeExecutionOf:!executing!public! !
!WebContext categoriesFor: #first!accessing!public! !
!WebContext categoriesFor: #form!accessing!public! !
!WebContext categoriesFor: #id!accessing!public! !
!WebContext categoriesFor: #ids!private-ids!public! !
!WebContext categoriesFor: #idt!private! !
!WebContext categoriesFor: #initIds!initialize-release!public! !
!WebContext categoriesFor: #initRegisteredSet!initialize-release!public! !
!WebContext categoriesFor: #initReplacementAnnouncements!initialize-release!public! !
!WebContext categoriesFor: #initSemaphore!initialize-release!public! !
!WebContext categoriesFor: #initWindow!initialize-release!public! !
!WebContext categoriesFor: #isBusy!public!testing! !
!WebContext categoriesFor: #isClosed!public!testing-states! !
!WebContext categoriesFor: #isExecuting!public!testing-states! !
!WebContext categoriesFor: #isExecutingInOwnProcess!public!testing! !
!WebContext categoriesFor: #isFirst!public!testing! !
!WebContext categoriesFor: #isIdle!public!testing-states! !
!WebContext categoriesFor: #isInterrupted!public!testing-states! !
!WebContext categoriesFor: #isLast!public!testing! !
!WebContext categoriesFor: #isNoProcess!public!testing-states! !
!WebContext categoriesFor: #isRegistered:!private-ids!public! !
!WebContext categoriesFor: #isRegisteredMethod:!private-ids!public! !
!WebContext categoriesFor: #isWebElement!public!testing! !
!WebContext categoriesFor: #level!accessing!public! !
!WebContext categoriesFor: #nextId!private-ids!public! !
!WebContext categoriesFor: #nextIdNumber!private-ids!public! !
!WebContext categoriesFor: #page!accessing!public! !
!WebContext categoriesFor: #parent!accessing!public! !
!WebContext categoriesFor: #parent:!private! !
!WebContext categoriesFor: #printString!printing!public! !
!WebContext categoriesFor: #process!private-process!public! !
!WebContext categoriesFor: #process:!private-process!public! !
!WebContext categoriesFor: #processLoop!private-process!public! !
!WebContext categoriesFor: #processPriority!private-process!public! !
!WebContext categoriesFor: #registeredSet!private-ids!public! !
!WebContext categoriesFor: #registerIdFor:!private-ids!public! !
!WebContext categoriesFor: #removeId:!private-ids!public! !
!WebContext categoriesFor: #replaceIdIn:with:!private-ids!public! !
!WebContext categoriesFor: #replacementAnnouncements!private-ids!public! !
!WebContext categoriesFor: #request!accessing!public! !
!WebContext categoriesFor: #request:!accessing!public! !
!WebContext categoriesFor: #result!accessing!public! !
!WebContext categoriesFor: #result:!private! !
!WebContext categoriesFor: #semaphore!private-process!public! !
!WebContext categoriesFor: #semaphore:!private-process!public! !
!WebContext categoriesFor: #serialize:!executing!public! !
!WebContext categoriesFor: #session!accessing!public! !
!WebContext categoriesFor: #setClosed!private-states!public! !
!WebContext categoriesFor: #setExecutingState!private-states!public! !
!WebContext categoriesFor: #setId!initialize-release!public! !
!WebContext categoriesFor: #setIdleState!private-states!public! !
!WebContext categoriesFor: #setInterruptedState!private-states!public! !
!WebContext categoriesFor: #setNoProcessState!private-states!public! !
!WebContext categoriesFor: #signal!private-process!public! !
!WebContext categoriesFor: #startProcess!private-process!public! !
!WebContext categoriesFor: #state!private-states!public! !
!WebContext categoriesFor: #state:!private-states!public! !
!WebContext categoriesFor: #stopProcess!private-process!public! !
!WebContext categoriesFor: #view!accessing!public! !
!WebContext categoriesFor: #wait!private-process!public! !
!WebContext categoriesFor: #window!accessing!public! !
!WebContext categoriesFor: #window:!private! !

!WebContext class methodsFor!

contextIdName
	"query name for contexts in in URLs: 'aidaCtx=1456' "
	^'aidaCtx'!

newOn: aContext
	^super new 
		parent: aContext;
		setNoProcessState "an initial state"! !
!WebContext class categoriesFor: #contextIdName!accessing!public! !
!WebContext class categoriesFor: #newOn:!instance creation!public! !

WebCounter guid: (GUID fromString: '{5924E5BB-F360-4D23-9363-C3672A90252E}')!
WebCounter comment: ''!
!WebCounter categoriesForClass!Unclassified! !
!WebCounter methodsFor!

addArray: aFirstArray to: aSecondArray

	1 to: aFirstArray size do: [:index |
		aSecondArray
			at: index
			put: (aFirstArray at: index) + (aSecondArray at: index)]!

addCounter: aWebCounter
	"add counts from specified counter"
	aWebCounter year = self year ifTrue: 
		[self addArray: aWebCounter dailyCounts to: self dailyCounts].
	self addArray: aWebCounter hourlyCounts to: self hourlyCounts.
	self total: self total + aWebCounter total.
	aWebCounter yearlyHistory keysAndValuesDo: [:yr :array |
		self addArray: array to: (self yearlyHistory at: yr ifAbsentPut: [Array new: 366 withAll: 0]) ].

"WebCounter new addCounter: WebCounter new"!

allCountsInYear: aYearNumber

	aYearNumber = self year 
		ifTrue: [^self dailyCounts copy]
		ifFalse: 
			[^(self yearlyHistory 
				at: aYearNumber 
				ifAbsent: [^Array new: 366 withAll: 0]) copy]!

allCountsThatYear
	
	"return array of counts for each day in current year"

	^self allCountsInYear: Date today year!

allHourlyCounts

	^self hourlyCounts copy!

allTodayHourlyCounts

	^self todayHourlyCounts copy!

checkIfNewYear

	(Date today year = (self year + 1)) ifTrue:
		[self yearlyHistory
			at: self year
			put: self dailyCounts.
		self initDailyCounts.
		self year: Date today year].!

countRequest: aWebRequest

	"register a request by incrementing daily, hourly and total counter."

	self incCounterOnTimestamp: aWebRequest timestamp!

countsFrom: aStartDate to: anEndDate

	| collection |
	collection := OrderedCollection new.
	aStartDate asDays to: anEndDate asDays do: [:days | 
		collection add: (self countsOnDate: (SpDate fromDays: days))].
	^collection!

countsMonthlyFromDate: aDate
	| date collection |
	date := Date newDay: 1
		monthNumber: aDate monthIndex
		year: aDate year.
	collection := OrderedCollection new.
	[date < Date today] whileTrue:
		[collection add: (self countsOnMonth: date monthIndex year: date year).
		date := Date newDay: 1
			monthNumber: (date + 31) monthIndex
			year: (date + 31) year].
	^collection

"AIDASite default totalCounter countsMonthlyFromDate: Date today - 6"!

countsMonthlyOnYear: aYear

	^(1 to: 12) collect: [:month | self countsOnMonth: month year: aYear]

"WebServer default totalCounter countsMonthlyOnYear: 1999"!

countsOnDate: aDate

	| counts |
	counts := self allCountsInYear: aDate year.
	^counts at: aDate day!

countsOnHour: aNumber

	^self hourlyCounts at: aNumber!

countsOnMonth: aMonth year: aYear

	| counts date |
	date := Date newDay: 1 monthNumber: aMonth year: aYear.
	counts := self allCountsInYear: date year.
	^(date day to: date day + date daysInMonth - 1)
		inject: 0 into: [:sum :dy | sum + (counts at: dy)]

"WebServer default totalCounter countsOnMonth: 10 year: 1999"!

countsTodayOnHour: aNumber

	^self todayHourlyCounts at: aNumber!

currentWeekCounts
	| firstDay collection |
	firstDay := SpDate today subtractDays: SpDate today weekdayIndex + 1.
	collection := OrderedCollection new.
	firstDay asDays to: firstDay asDays + 6 do: [:days |
		collection add: (self countsOnDate: (SpDate fromDays: days))].
	^collection!

dailyCounts
	"array of counters for each day in current year. When new year arrives, counters are 
	copied in a yearlyHistory"

	dailyCounts isNil ifTrue: [self initDailyCounts].
	^dailyCounts!

day
	day isNil ifTrue: [self day: Date today dayOfYear].
	^day!

day: aNumber
	day := aNumber!

hourlyCounts
	"array of counters for each hour in a day."

	hourlyCounts isNil ifTrue: [self initHourlyCounts].
	^hourlyCounts!

incCounterOnTimestamp: aTimestamp

	"increment daily, hourly and total counter with date and time defined"

	
	self incDailyCounterOnDate: aTimestamp asDate.
	self incHourlyCounterOnTimestamp: aTimestamp.
	self incTotal.!

incDailyCounterOnDate: aDate
	aDate year = self year 
		ifTrue: 
			[self dailyCounts at: aDate day put: (self  dailyCounts at: aDate day) + 1]
		ifFalse:
			[self checkIfNewYear.
			self incHistoryCounterOnDate: aDate].!

incHistoryCounterOnDate: aDate
	| array |
	aDate year < self year ifTrue: [^self error: 'future years not allowed'].
	array := (self yearlyHistory at: aDate year ifAbsentPut: [Array new: 366 withAll: 0] ).
	array at: aDate day put: (array at: aDate day)+1!

incHourlyCounterOnTime: aTime
	| hours |
	hours := aTime hours.
	self hourlyCounts at: hours+1 	put: (self  hourlyCounts at: hours+1) + 1.!

incHourlyCounterOnTimestamp: aTimestamp
	| hours |
	hours := aTimestamp asTime hours.
	self hourlyCounts at: hours+1 put: (self  hourlyCounts at: hours+1) + 1.
	self incTodayHourlyCounterOnTimestamp: aTimestamp!

incTodayHourlyCounterOnTimestamp: aTimestamp

	| hours dayOfYear |
	dayOfYear := aTimestamp asDate day.
	self day ~= dayOfYear 	ifTrue: 
		[self initTodayHourlyCounts.
		self day: dayOfYear].
	hours := aTimestamp asTime hours.
	self todayHourlyCounts 
		at: hours+1
		put: (self  todayHourlyCounts at: hours+1) + 1.!

incTotal

	self total: self total + 1.!

initDailyCounts
	dailyCounts := Array new: 366 withAll: 0.
	self year: Date today year.!

initHourlyCounts
	hourlyCounts := Array new: 24 withAll: 0.!

initTodayHourlyCounts

	todayHourlyCounts := Array new: 24 withAll: 0.
	self day: Date today day.!

initTotal

	self total: 0.!

initYearlyHistory
	yearlyHistory := Dictionary new.!

isFirstOnDate: aDate sinceDays: nrOfDays
	"a first/new count since specified nr of days, when there were no counts"
	| since current |
	current := aDate day.
	since := (day - nrOfDays) max: 1. "well what about first 7 days in new year?"
	(self dailyCounts at: current) = 0 ifTrue: [^false].
	since to: current-1 do: [:d | (self dailyCounts at: d) > 0 ifTrue: [^false] ].
	^true!

printString

	^'aWebCounter total: ', self total printDotString!

reset

	"set all counters to zero and set started timestamp to now. YOU WILL LOOSE ALL HISTORY
	OF COUNTS !! "

	self initDailyCounts.
	self initHourlyCounts.
	self initTotal.
	self initStarted.!

started
	"return a timestamp, from when web visits are counted"
	started isNil ifTrue: [self initStarted].
	^SpTimestamp fromSeconds: started!

today
	
	"return number of requests today"

	^self countsOnDate: Date today!

todayHourlyCounts
	"array of counters for each hour today."

	todayHourlyCounts isNil ifTrue: [self initTodayHourlyCounts].
	^todayHourlyCounts!

todayHourlyCounts: anObject
	todayHourlyCounts := anObject!

total
	"total number of visits, registered by this counter"

	total isNil ifTrue: [self initTotal].
	^total.!

total: aNumber
	total := aNumber.!

weekly
	"total count in current week"
	^self currentWeekCounts inject: 0 into: [:sum :each | sum + each]!

year
	year isNil ifTrue: [self year: Date today year].
	^year!

year: aNumber
	year := aNumber.!

yearlyHistory
	yearlyHistory isNil ifTrue: [self initYearlyHistory].
	^yearlyHistory!

yesterday
	"return number of requests yesterday"
	^self countsOnDate: (SpDate today subtractDays: 1)! !
!WebCounter categoriesFor: #addArray:to:!private! !
!WebCounter categoriesFor: #addCounter:!adding!public! !
!WebCounter categoriesFor: #allCountsInYear:!accessing!public! !
!WebCounter categoriesFor: #allCountsThatYear!accessing!public! !
!WebCounter categoriesFor: #allHourlyCounts!accessing!public! !
!WebCounter categoriesFor: #allTodayHourlyCounts!accessing!public! !
!WebCounter categoriesFor: #checkIfNewYear!private! !
!WebCounter categoriesFor: #countRequest:!counting!public! !
!WebCounter categoriesFor: #countsFrom:to:!accessing!public! !
!WebCounter categoriesFor: #countsMonthlyFromDate:!accessing!public! !
!WebCounter categoriesFor: #countsMonthlyOnYear:!accessing!public! !
!WebCounter categoriesFor: #countsOnDate:!accessing!public! !
!WebCounter categoriesFor: #countsOnHour:!accessing!public! !
!WebCounter categoriesFor: #countsOnMonth:year:!accessing!public! !
!WebCounter categoriesFor: #countsTodayOnHour:!accessing!public! !
!WebCounter categoriesFor: #currentWeekCounts!accessing!public! !
!WebCounter categoriesFor: #dailyCounts!private! !
!WebCounter categoriesFor: #day!private! !
!WebCounter categoriesFor: #day:!private! !
!WebCounter categoriesFor: #hourlyCounts!private! !
!WebCounter categoriesFor: #incCounterOnTimestamp:!counting!public! !
!WebCounter categoriesFor: #incDailyCounterOnDate:!private! !
!WebCounter categoriesFor: #incHistoryCounterOnDate:!private! !
!WebCounter categoriesFor: #incHourlyCounterOnTime:!private! !
!WebCounter categoriesFor: #incHourlyCounterOnTimestamp:!private! !
!WebCounter categoriesFor: #incTodayHourlyCounterOnTimestamp:!private! !
!WebCounter categoriesFor: #incTotal!private! !
!WebCounter categoriesFor: #initDailyCounts!initialize-release!public! !
!WebCounter categoriesFor: #initHourlyCounts!initialize-release!public! !
!WebCounter categoriesFor: #initTodayHourlyCounts!initialize-release!public! !
!WebCounter categoriesFor: #initTotal!initialize-release!public! !
!WebCounter categoriesFor: #initYearlyHistory!initialize-release!public! !
!WebCounter categoriesFor: #isFirstOnDate:sinceDays:!public!testing! !
!WebCounter categoriesFor: #printString!printing!public! !
!WebCounter categoriesFor: #reset!initialize-release!public! !
!WebCounter categoriesFor: #started!accessing!public! !
!WebCounter categoriesFor: #today!accessing!public! !
!WebCounter categoriesFor: #todayHourlyCounts!private! !
!WebCounter categoriesFor: #todayHourlyCounts:!accessing!public! !
!WebCounter categoriesFor: #total!accessing!public! !
!WebCounter categoriesFor: #total:!private! !
!WebCounter categoriesFor: #weekly!accessing!public! !
!WebCounter categoriesFor: #year!private! !
!WebCounter categoriesFor: #year:!private! !
!WebCounter categoriesFor: #yearlyHistory!private! !
!WebCounter categoriesFor: #yesterday!accessing!public! !

!WebCounter class methodsFor!

instVarMap
	"Gemstone odb"

	^super instVarMap,
		#( 	(todayHourlyCounts nil)	)!

new
	^super new reset!

replicationSpec
	"Gemstone"
	^super replicationSpec, 
	 	#( 	(started max 2)
			(day replicate)
			(year replicate)
			(dailyCounts max 2)
			(hourlyCounts max 2)
			(total replicate)
			(yearlyHistory stub)	)!

setupOdbStorage
	"Versant"

	self 
		store: #(started dailyCounts hourlyCounts total )
		as: #(Integer IntegerArray IntegerArray Integer).!

sumCounters: aCounterCollection

	"return a new counter with sum of all specified counters"
	| sumCounter |
	sumCounter := WebCounter new.
	aCounterCollection do: [:counter |
		sumCounter addCounter: counter].
	^sumCounter! !
!WebCounter class categoriesFor: #instVarMap!odb specific!public! !
!WebCounter class categoriesFor: #new!instance creation!public! !
!WebCounter class categoriesFor: #replicationSpec!odb specific!public! !
!WebCounter class categoriesFor: #setupOdbStorage!odb specific!public! !
!WebCounter class categoriesFor: #sumCounters:!public!summing! !

WebCountry guid: (GUID fromString: '{B28D3193-1869-4F00-8417-C8315BDBA195}')!
WebCountry comment: 'WebCountry on class side holds a table of country names and their ISO codes'!
!WebCountry categoriesForClass!Unclassified! !
WebDemo guid: (GUID fromString: '{5B98EA3E-4DDA-4E76-8EA6-2A9B4F792CCB}')!
WebDemo comment: ''!
!WebDemo categoriesForClass!Unclassified! !
!WebDemo methodsFor!

content
	"for Rich Editor demo"
	content isNil ifTrue: [^''].
	^content!

content: aString
	"for Rich Editor demo"
	^content := aString!

date
	date isNil ifTrue: [^''].
	^date!

date: aString
	date := aString!

defaultIntroductionText

^'<b>Congratulations!!</b><br><br>
You just started your AIDA/Web Smalltalk Web Application Server. Here you can look at few simple <a href=/demo.html?view=grid><b>demos</b></a> (see navigation bar at the left) and on top left there are links to main website, where you can find more information. <br>
<br>
You are encougared to:
<ul>
<li>look at <a href=http://www.aidaweb.si/screenshots.html><b>Screenshots</b></a> to see, what kind of complex web applications you can build with AIDA/Web,</li>
<li>see <a href=http://www.aidaweb.si/tutorial.html><b>Tutorial</b></a> to build your first web application,</li>
<li>read other <a href=http://www.aidaweb.si/documentation.html><b>Documentation</b></a> to learn more (Architecture, Administrator''s guide, Programer''s guide, Ajax, Advanced features, Articles and presentations and more),</li> 
<li>join the <a href=http://www.aidaweb.si/community.html><b>Community</b></a>.</li>
</ul>
You can also <a href=/admin.html?view=login><b>login</b></a> with username: <b>admin</b> and password: <b>password</b>. <br><br>

Development team wish you a lot of great moments with Aida/Web !!
'.!

delayedInput
	delayedInput isNil ifTrue: [^''].
	^delayedInput!

delayedInput: aString
	delayedInput := aString!

delete
	"for a control flow example"
	deleted := true.!

deleted
	"for a control flow example"
	deleted isNil ifTrue: [self resetDelete].
	^deleted!

editField
	"for in-place editor demo"
	editField isNil ifTrue: [^'Click me to edit!!'].
	^editField!

editField: anObject
	editField := anObject!

field1
	^field1!

field1: anObject
	field1 := anObject!

field2
	^field2!

field2: anObject
	field2 := anObject!

input
	input isNil ifTrue: [^''].
	^input!

input: aString
	input := aString!

introduction
	"introduction text, In instvar to allow changing it by Scribo and other packages at installation"
	introduction isNil ifTrue: [self introduction: self defaultIntroductionText].
	^introduction!

introduction: aString
	"introduction text, In instvar to allow changing it by Scribo and other packages at installation"
	introduction := aString.!

preferedUrl
	^'/demos.html'!

resetDelete
	"for a control flow example"
	deleted := false.!

submitValue
	submitValue isNil ifTrue: [^''].
	^submitValue!

submitValue: aString
	submitValue := aString! !
!WebDemo categoriesFor: #content!accessing!public! !
!WebDemo categoriesFor: #content:!accessing!public! !
!WebDemo categoriesFor: #date!accessing!public! !
!WebDemo categoriesFor: #date:!accessing!public! !
!WebDemo categoriesFor: #defaultIntroductionText!introduction!public! !
!WebDemo categoriesFor: #delayedInput!accessing!public! !
!WebDemo categoriesFor: #delayedInput:!accessing!public! !
!WebDemo categoriesFor: #delete!accessing!public! !
!WebDemo categoriesFor: #deleted!accessing!public! !
!WebDemo categoriesFor: #editField!accessing!public! !
!WebDemo categoriesFor: #editField:!accessing!public! !
!WebDemo categoriesFor: #field1!accessing!public! !
!WebDemo categoriesFor: #field1:!accessing!public! !
!WebDemo categoriesFor: #field2!accessing!public! !
!WebDemo categoriesFor: #field2:!accessing!public! !
!WebDemo categoriesFor: #input!accessing!public! !
!WebDemo categoriesFor: #input:!accessing!public! !
!WebDemo categoriesFor: #introduction!introduction!public! !
!WebDemo categoriesFor: #introduction:!introduction!public! !
!WebDemo categoriesFor: #preferedUrl!accessing!public! !
!WebDemo categoriesFor: #resetDelete!accessing!public! !
!WebDemo categoriesFor: #submitValue!accessing!public! !
!WebDemo categoriesFor: #submitValue:!accessing!public! !

!WebDemo class methodsFor!

default
	^AIDASite default demo! !
!WebDemo class categoriesFor: #default!accessing!public! !

WebElement guid: (GUID fromString: '{28299493-4072-4B70-A48A-068A41162CE5}')!
WebElement comment: ''!
!WebElement categoriesForClass!Unclassified! !
!WebElement methodsFor!

acceptDropsTo: aCollectionOfElements
	| script |
	"Scriptaculous specific"
	self registerId.
	self app style ensureJsResourceForScriptaculous.
	self app style ensureJavascriptForScriptaculousInHeader.
	script := '// <!![CDATA[ 
		Sortable.create("', self id asString,'"'.
	(self isKindOf: WebList) ifFalse: [
		self setDiv.
		script := script,  'tag: "div", '].
	script := script, ',{dropOnEmpty: true,constraint: false, containment: ['.
	aCollectionOfElements do: [:each |
		each registerId.
		script := script, each id, ','].
	script := script,']});
	// ]]>'.
	self parent scriptAfter: script!

adaptFormElements
	"in case of AJAX request, otherwise WebForm should do that!! "
	self isFormElement ifTrue: [self adapt].
	self elements do: [:each | each adaptFormElements]!

add: aWebElement
	"Include new element as one of the receiver's elements.  Answer aWebElement.
	If you nest a web page into another web page, then add only elements of it"
	self checkAndInitElements.  "if not composite element, then error"
	"if nested web pages then add elements without header"
	(aWebElement isKindOf: WebApplication) ifTrue: [^nil].
	((aWebElement isKindOf: WebPage) and: [self isKindOf: WebPage])
		ifTrue: [^elements add: aWebElement elements].
	aWebElement parent: self.
	^elements add: aWebElement.!

addAnchorName: aString
	^self add: (WebAnchor name: aString)!

addAspect: aSymbol for: anObject input: aBoolean size: aSizeNumberOrPoint
	"adds an auto converted text of aspect for that object. If imput argument is true, then add 
	an input field or text area, depending in size (eg. size: 5 or size: 5@5)"
	aBoolean
		ifFalse: 
			[^self addText: (WebFormElement autoConvertToString: (anObject perform: aSymbol))]
		ifTrue:
			[(aSizeNumberOrPoint isKindOf: Number) 	ifTrue: 
				[^self add: (WebInputField new
							size: aSizeNumberOrPoint;
							aspect: aSymbol for: anObject)].
			(aSizeNumberOrPoint isKindOf: Point) ifTrue: 
				[^self add: (WebTextArea new
							size: aSizeNumberOrPoint;
							aspect: aSymbol for: anObject)] 
			].!

addBreak
	^self add: (WebSeparator break).!

addButtonGif: anImageSymbol
	"add a button as an image"
	^self add: (WebButton image: (WebImage gif: anImageSymbol))!

addButtonGif: anImageSymbol action: aSymbol
	"add a button as an image"
	^self add: (WebButton image: (WebImage gif: anImageSymbol) action: aSymbol)!

addButtonJpeg: anImageSymbol
	"add a button as an image"
	^self add: (WebButton image: (WebImage jpeg: anImageSymbol))!

addButtonJpeg: anImageSymbol action: aSymbol
	"add a button as an image"
	^self add: (WebButton image: (WebImage jpeg: anImageSymbol) action: aSymbol)!

addButtonPng: anImageSymbol
	"add a button as an image"
	^self add: (WebButton image: (WebImage jpeg: anImageSymbol))!

addButtonPng: anImageSymbol action: aSymbol
	"add a button as an image"
	^self add: (WebButton image: (WebImage png: anImageSymbol) action: aSymbol)!

addButtonText: aString
	^self add: (WebButton text: aString)!

addButtonText: aString action: aSymbol
	"for more than one buttons. Action method is a composed name from 'action', aView, Symbol.
	example: for view #main, action #addFolder is action method #actionMainAddFolder"
	^self add: (WebButton text: aString action: aSymbol)!

addCheckboxAspect: aSymbol for: anObject
	"aspect method will be called and true/false will be set/clear on an object"
	^self add: (WebCheckBox aspect:  aSymbol for: anObject)!

addCheckboxObject: anObject from: aCollection
	"if checked, this object will be put in collection. If object is initially in collection, 
	checkbox will be checked. Usefull for easy selection among many objects"
	^self add: (WebCheckBox newForObject: anObject from: aCollection)!

addCloseWindowText: aString
	"a link to that popup window properly (it also closes by Ajax its execution context!!)"
	(self addNilLinkText: aString)
		onClick: 'closeLightboxLevel(', self context level printString,')'; "from WebStyle>>lightboxJs"
		onClickUpdate: nil with: nil additional: 'aidaCloseWindow' contentFrom: nil!

addComment: aString
	^self add: (WebComment text: aString).!

addDateInputFieldAspect: aSymbol for: anObject
	"with popup calendar"
	^self add: (WebDateInputField new aspect:  aSymbol for: anObject)!

addDelayedFieldAspect: aSymbol for: anObject
	"for Ajax instant posting, posting is done with a delay. Usefull for live-search fields"
	^self add: (WebDelayedField new aspect:  aSymbol for: anObject)!

addDelayedFieldAspect: aSymbol for: anObject size: aNumber
	"for Ajax instant posting, posting is done with a delay. Usefull for live-search fields"
	^self add: ((WebDelayedField new aspect:  aSymbol for: anObject) size: aNumber)!

addErrorReport
	^self add: self app errorReport!

addGif: aSymbol
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	^self add: (WebImage gif: aSymbol)!

addGif: aSymbol size: aPoint
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	^self add: (WebImage gif: aSymbol size: aPoint)!

addHelpLink
	"link to help page for current view and App. If not exist, then nothing, exept for 
	admin - link to creation of new help page"
	^self add: self helpLink!

addImage: anImageOrURL
	^self add: (WebImage image: anImageOrURL)!

addImage: anImageOrURL imageMap: aWebImageMap
	^self add: 
		((WebImage image: anImageOrURL)
			imageMap: aWebImageMap)!

addImage: anImageOrURL size: aPoint
	^self add: (WebImage image: anImageOrURL size: aPoint)!

addImage: anImageOrURL size: aPoint align: aSymbol
	^self add: ((WebImage image: anImageOrURL size: aPoint) align: aSymbol)!

addImage: anImageOrURL size: aPoint valign: aSymbol
	^self add: ((WebImage image: anImageOrURL size: aPoint) valign: aSymbol)!

addInPlaceEditableTextAspect: aSymbol for: anObject
	^self add: (WebInPlaceEditableText aspect:  aSymbol for: anObject)!

addInPlaceEditableTextAspect: aSymbol for: anObject size: aNumberOrPoint
	^self add: (WebInPlaceEditableText aspect:  aSymbol for: anObject size: aNumberOrPoint)!

addInPlaceEditableTextAspect: aSymbol for: anObject size: aNumberOrPoint allow: aBoolean
	^self add: 
		(WebInPlaceEditableText aspect:  aSymbol for: anObject size: aNumberOrPoint allow: aBoolean)!

addInputFieldAspect: aSymbol for: anObject
	^self add: (WebInputField new aspect:  aSymbol for: anObject)!

addInputFieldAspect: aSymbol for: anObject size: aNumber
	^self add: ((WebInputField new aspect:  aSymbol for: anObject) size: aNumber)!

addJpeg: aSymbol
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	^self add: (WebImage jpeg: aSymbol)!

addJpeg: aSymbol size: aPoint
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	^self add: (WebImage jpeg: aSymbol size: aPoint)!

addLinkTo: anObject gif: aGifSymbol title: aString
	^self add: ((WebLink linkTo: anObject) title: aString; addGif: aGifSymbol; yourself)!

addLinkTo: anObject gif: aGifSymbol title: aString size: aPoint
	^self add: ((WebLink linkTo: anObject) title: aString; addGif: aGifSymbol size: aPoint; yourself)!

addLinkTo: anObject gif: aGifSymbol title: aString view: aViewSymbol
	^self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) 
		addGif: aGifSymbol; yourself)!

addLinkTo: anObject gif: aGifSymbol title: aString view: aViewSymbol
	 parameter: aParmString value: aValueString

	^self add: (((WebLink linkTo: anObject) 
		title: aString; view: aViewSymbol;
		parameter: aParmString value: aValueString) 
			addGif: aGifSymbol; yourself)!

addLinkTo: anObject image: anImageOrURL
	^self add: ((WebLink linkTo: anObject) addImage: anImageOrURL; yourself)!

addLinkTo: anObject image: anImageOrURL parameter: aParmString value: aValueString
	^self add: (((WebLink linkTo: anObject)
		parameter: aParmString value: aValueString) addImage: anImageOrURL; yourself)!

addLinkTo: anObject image: anImageOrURL size: aPoint
	^self add: ((WebLink linkTo: anObject) addImage: anImageOrURL size: aPoint; yourself)!

addLinkTo: anObject image: anImageOrURL view: aViewSymbol
	^self add: (((WebLink linkTo: anObject) view: aViewSymbol) 
		addImage: anImageOrURL; yourself)!

addLinkTo: anObject jpeg: aSymbol title: aString
	^self add: ((WebLink linkTo: anObject) title: aString; addJpeg: aSymbol; yourself)!

addLinkTo: anObject jpeg: aSymbol title: aString view: aViewSymbol
	^self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) 
		addJpeg: aSymbol; yourself)!

addLinkTo: anObject message: aSymbol
	^self add: (WebLink message: aSymbol  linkTo: anObject)!

addLinkTo: anObject png: aPngSymbol title: aString
	^self add: ((WebLink linkTo: anObject) title: aString; addPng: aPngSymbol; yourself)!

addLinkTo: anObject png: aPngSymbol title: aString view: aViewSymbol
	^self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) 
		addPng: aPngSymbol; yourself)!

addLinkTo: anObject png: aPngSymbol title: aString view: aViewSymbol
	 parameter: aParmString value: aValueString

	^self add: (((WebLink linkTo: anObject) 
		title: aString; view: aViewSymbol;
		parameter: aParmString value: aValueString) 
			addPng: aPngSymbol; yourself)!

addLinkTo: anObject text: aString
	^self add: (WebLink text: aString  linkTo: anObject)!

addLinkTo: anObject text: aString attributes: anArray
	^self add: (WebLink text: aString  attributes: anArray linkTo: anObject)!

addLinkTo: anObject text: aString header: aNumber
	^self add: (WebLink text: aString  header: aNumber linkTo: anObject)!

addLinkTo: anObject text: aString parameter: aParmString value: aValueString
	^self add: (WebLink text: aString  linkTo: anObject 
		parameter: aParmString value: aValueString)!

addLinkTo: anObject text: aString 
	parameter: a1ParmString value: a1ValueString
	parameter: a2ParmString value: a2ValueString

	^self add: (WebLink text: aString  linkTo: anObject 
		parameter: a1ParmString value: a1ValueString
		parameter: a2ParmString value: a2ValueString)!

addLinkTo: anObject text: aString view: aViewString
	^self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString; yourself)!

addLinkTo: anObject text: aString view: aViewString  parameter: aParmString value: aValueString
	^self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString;
		parameter: aParmString value: aValueString; yourself)!

addLinkTo: anObject text: aString view: aViewString  
		parameter: aParm1String value: aValue1String 
		parameter: aParm2String value: aValue2String

	^self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString;
		parameter: aParm1String value: aValue1String;
		parameter: aParm2String value: aValue2String; yourself)!

addLiveImage: aWebLiveImage
	^self add: 
		((WebImage image: aWebLiveImage)
			size: (aWebLiveImage width)@(aWebLiveImage height))!

addLiveImage: aWebLiveImage imageMap: aWebImageMap
	^self add: 
		((WebImage image: aWebLiveImage)
			size: (aWebLiveImage width)@(aWebLiveImage height);
			imageMap: aWebImageMap)!

addMenuAspect: aSymbol collection: aCollection selected: aSelectedCollection
	"Multiple selection menu.. Aspect of every element in aColection will be shown in menu. 
	Selection will be put in aSelectedCollection. Here also an initial selection can be set"
	^self add: (WebMenu aspect: aSymbol collection: aCollection selected: aSelectedCollection)!

addMenuAspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject
	"Single selection menu.. Aspect of every element in aColection will be shown in menu. 
	Single selection will be put in an seelcted aspect of object. Here also initial selection can be set"
	^self add: 
		(WebMenu aspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject)!

addMenuCollection: aCollection selected: aSelectedCollection
	"Multiple selection menu..Every element (text!!) in aColection will be shown in menu. 
	Selection will be put 	in aSelectedCollection. Here also an initial selection can be set"
	^self add: (WebMenu collection: aCollection selected: aSelectedCollection)!

addMenuCollection: aCollection selectedToAspect: aSymbol2 of: anObject
	"Single selection menu. Every element (text!!) in aColection will be shown in menu. 
	Single selection will be put in an seelcted aspect of object. Here also initial selection can be set"
	^self add: (WebMenu collection: aCollection selectedToAspect: aSymbol2 of: anObject)!

addMethodImage: aWebMethodImage
	^self add: 
		(WebImage image: aWebMethodImage)!

addMethodImage: aWebMethodImage size: aPoint
	^self add: 
		((WebImage image: aWebMethodImage) size: aPoint)!

addNbSp
	^self addText: '&nbsp;'.!

addNbSp: aNumber
	aNumber timesRepeat: [self addNbSp].!

addNilLinkText: aString
	^self addLinkTo: 'javascript:nic()' text: aString!

addPageBreak
	"for printing to printer, to break into a new page!!"
	^self addBreak
		class: #printOnly;
		style: 'page-break-after: always';
		yourself.!

addParagraph
	^self add: (WebSeparator paragraph).!

addPasswordFieldAspect: aSymbol for: anObject
	^self add: (WebInputField new type: #password; aspect:  aSymbol for: anObject)!

addPasswordFieldAspect: aSymbol for: anObject size: aNumber
	^self add: ((WebInputField new type: #password; aspect:  aSymbol for: anObject) size: aNumber)!

addPDFLinkTo: anObject
	^self add: ((WebLink linkTo: anObject) addGif: #pdfBigGif)!

addPng: aSymbol
	"this method will be called in your webStyle and this method 
	should return a png in byte array format"
	^self add: (WebImage png: aSymbol)!

addPng: aSymbol size: aPoint
	"this method will be called in your webStyle and this method 
	should return a png in byte array format"
	^self add: (WebImage png: aSymbol size: aPoint)!

addRedStar
	"red * for mandatory fields in a form"
	^self addText: '<sup>*</sup>'!

addRichEditorAspect: aSymbol for: anObject
	"JavaScript HTML WYSIWYG editor instead of textarea"
	^self add: (WebRichEditor new aspect:  aSymbol for: anObject)!

addRichEditorAspect: aSymbol for: anObject size: aPoint
	"JavaScript HTML WYSIWYG editor instead of textarea"
	^self add: ((WebRichEditor new aspect:  aSymbol for: anObject) size: aPoint)!

addRulerSize: aNumber
	^self add: (WebSeparator rulerSize: aNumber).!

addSecureLinkTo: anObject text: aString
	^self add: ((WebLink text: aString  linkTo: anObject) security: #grayed)!

addSecureLinkTo: anObject 
	text: aString parameter: aParmString value: aValueString

	^self add: ((WebLink text: aString  linkTo: anObject 
		parameter: aParmString value: aValueString) security: #grayed)!

addSecureLinkTo: anObject text: aString view: aViewString
	^self add: ((WebLink text: aString  linkTo: anObject 
		view: aViewString) security: #grayed)!

addSpace
	"just a simple space, nothing more"
	^self addText: ' '!

addStubFor: anElementMethodSymbol
	"add an empty stub element to be Ajax replaced with result element of method #anElementMethodSymbol"
	self add: (WebStubElement newFor: anElementMethodSymbol)!

addText: aString
	^self add: (WebText text: aString)!

addText: aString attributes:  aSymbolArray
	^self add: ((WebText text: aString) textAttributes: aSymbolArray)!

addText: aString attributes:  aSymbolArray color: aColorSymbol
	^self add: ((WebText text: aString) attributes: aSymbolArray; color: aColorSymbol)!

addText: aString attributes:  aSymbolArray font: aFontString
	^self add: ((WebText text: aString) attributes: aSymbolArray; font: aFontString)!

addText: aString attributes:  aSymbolArray font: aFontString color: aColorSymbol
	^self add: ((WebText text: aString) 
		textAttributes: aSymbolArray; font: aFontString; color: aColorSymbol)!

addText: aString  color: aColorSymbol
	^self add: ((WebText text: aString)  color: aColorSymbol)!

addText: aString font: aFontString
	^self add: ((WebText text: aString) font: aFontString)!

addText: aString  font: aFontString color: aColorSymbol
	^self add: ((WebText text: aString)  font: aFontString; color: aColorSymbol)!

addText: aString header: aNumber
	^self add: ((WebText text: aString) header: aNumber)!

addText: aString header: aNumber color:  aColorSymbol
	^self add: ((WebText text: aString) header: aNumber; color:  aColorSymbol)!

addText: aString header: aNumber font: aFontString
	^self add: ((WebText text: aString) header: aNumber; font: aFontString)!

addText: aString header: aNumber font: aFontString color: aColorSymbol
	^self add: ((WebText text: aString) 
		header: aNumber; font: aFontString; color: aColorSymbol)!

addText: aString style: aStyleString
	^self add: ((WebText text: aString) style: aStyleString)!

addTextAreaAspect: aSymbol for: anObject
	^self add: (WebTextArea new aspect:  aSymbol for: anObject)!

addTextAreaAspect: aSymbol for: anObject size: aPoint
	^self add: ((WebTextArea new aspect:  aSymbol for: anObject) size: aPoint)!

addTextAspect: aSymbol for: anObject
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	^self app inEditMode
		ifTrue: [self addInputFieldAspect: aSymbol for: anObject]
		ifFalse: [self addText: (anObject perform: aSymbol)]!

addTextAspect: aSymbol for: anObject attributes: aSymbolOrArray
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	^self app inEditMode
		ifTrue: [self addInputFieldAspect: aSymbol for: anObject]
		ifFalse: [self addText: (anObject perform: aSymbol) attributes: aSymbolOrArray]!

addTextBig: aString
	^self addText: '<big>', aString, '</big>'!

addTextBold: aString
	^self addText: aString attributes: #bold!

addTextBoldAspect: aSymbol for: anObject
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	^self addTextAspect: aSymbol for: anObject attributes: #bold!

addTextCode: aString
	^self addText: '<code>', aString, '</code>'.!

addTextH1: aString
	^self addText: aString header: 1!

addTextH2: aString
	^self addText: aString header: 2!

addTextH3: aString
	^self addText: aString header: 3!

addTextH4: aString
	^self addText: aString header: 4!

addTextH5: aString
	^self addText: aString header: 5!

addTextItalic: aString
	^self addText: aString attributes: #italic!

addTextPreformated: aString
	^self addText: '<pre>', aString, '</pre>'.!

addTextSmall: aString
	aString isNil ifTrue: [^self].
	^self addText: '<small>', aString, '</small>'!

ajaxCallUrl
	"relative url of an app observee object. This url is used for AJAX calls back to the server"
	| app object |

	app := self app.
	object := app observee isVersionedObject 
		ifTrue: [app observee currentVersion] ifFalse: [app observee].
	^AIDASite 
		convert: ( app site urlResolver halfUrlFor: object) 
		toCodepage: #utf8!

ajaxCallUrlExtended
	"relative url of an app observee object. This url is used for AJAX calls back to the server"
	"also includes 'ajaxRequest' in query part, to distinguish ajax request from others"
	"Prototype specific"
	| viewParm versionParm |
	viewParm := 'view=', self form view asString.
	versionParm := ''.
	self app observee isVersionedObject ifTrue:
		[self app observee isCurrentVersion ifFalse: 
			[versionParm := 'version=' self app observee versionNumber, '&'] ].
	^self ajaxCallUrl, '?', viewParm, '&', versionParm, 'ajaxRequest'!

ajaxCallUrlParametersFor: anElementOrId
	"ajax url must have 'ajaxRequest' parm in query part!! Deal also with versioned objects"
	"Prototype specific"
	| idSymbol ajaxForm viewParm versionParm contextParm |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [ajaxForm := self form. anElementOrId] 
		ifFalse: [anElementOrId isNil
			ifTrue: [ajaxForm := self context form. #nil] 
			ifFalse: [ajaxForm := anElementOrId form. 
				anElementOrId registerId. anElementOrId id] ].
	viewParm := 'view=', ajaxForm view asString.
	versionParm := ''.
	self app observee isVersionedObject ifTrue:
		[self app observee isCurrentVersion 
			ifFalse: [versionParm := 'version=', self app observee versionNumber] ].
	contextParm := WebContext contextIdName "aidaCtx", '=', ajaxForm app context id printString.
	^viewParm, '&', 
		versionParm, 
		'&ajaxRequest&ajaxGetElementId=', idSymbol asString,
		'&', contextParm!

align: aSymbol
	"element alignment #left #center #right"
	self attributesAt: #align put: aSymbol asString!

allElements
	"get a collection of all subelements of elements down in a hierarcy of this element"
	| collection |
	collection := OrderedCollection new.
	self elements notNil ifTrue:
		[collection addAll: self elements.
		self elements do: [:each | collection addAll: each allElements] ].
	^collection

"
| el |
el := WebElement new.
el add: (WebLink image: nil  linkTo: nil).
el add: (WebText text: 'aaa').
el allElements.
"!

app
	"return anApplication on which we are composing a web page"
	| object |
	self parent isNil ifTrue: 
		[object := self firstAppFromStack.
		^object isNil ifTrue: [nil] ifFalse: [object ] ].
	^parent app!

attributes
	^attributes!

attributesAt: aSymbol
	self attributes isNil ifTrue: [^nil].
	^self attributes at: aSymbol ifAbsent: [nil]!

attributesAt: aSymbol add: aString
	"some attributes can have more than one value (like javascript for events)"
	| coll |
	self attributes isNil ifTrue: [self initAttributes].
	coll := self attributes at: aSymbol ifAbsentPut: [OrderedCollection new].
	(coll isKindOf: OrderedCollection) ifFalse:
		[coll := (self attributes at: aSymbol put: 
			(OrderedCollection new add: (self attributes at: aSymbol); yourself)) ].
	coll add: aString!

attributesAt: aSymbol put: aString
	self attributes isNil ifTrue: [self initAttributes].
	self attributes at: aSymbol put: aString!

beDraggable
	self beDraggableAndRevert: false!

beDraggableAndRevert: aBoolean
	"Scriptaculous specific"
	self registerId.
	self app style ensureJsResourceForScriptaculous.
	self app style ensureJavascriptForScriptaculousInHeader.
	self scriptAfter: '// <!![CDATA[ 
	new Draggable("', self id asString,'",{revert:', aBoolean asString, '});
	// ]]> 
	'!

beSortable
	"Scriptaculous specific"
	| script |
	self registerId.
	self app style ensureJsResourceForScriptaculous.
	self app style ensureJavascriptForScriptaculousInHeader.
	script := '// <!![CDATA[ 
		Sortable.create("', self id asString,'",{'.
	(self isKindOf: WebList) ifFalse: [
		self setDiv.
		script := script,  'tag: "div", '].
	script := script, 'dropOnEmpty: true, constraint: false});
		// ]]>'.
	self scriptAfter: script!

cell
	"return a current table cell"
	self initTableIfNessesary.
	^self otherAt: #currentCell!

cell: aWebTableCell
	self initTableIfNessesary.
	self otherAt: #currentCell put: aWebTableCell.!

changeContextFrom: oldCtx to: newCtx
	"scan for all references to contexts and change them. Also in subelements"
	self changeContextInAttributesFrom: oldCtx to: newCtx.
	self elements do: [:each | each changeContextFrom: oldCtx to: newCtx]!

changeContextInAttribute: aString from: oldCtx to: newCtx
	| in out aidaCtx |
	aidaCtx := WebContext contextIdName.
	(('*', aidaCtx, '*') match: aString) ifFalse: [^nil].
	in := aString readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse: 
		[out nextPutAll: (in upToAll: aidaCtx). 
		in atEnd not ifTrue: 
			[in next "=". in upTo: $&.               "& not always? "
			out nextPutAll: aidaCtx, '=', newCtx id printString, '&' ] ].   
	^out contents!

changeContextInAttributesFrom: oldCtx to: newCtx
	"scan for all references to contexts and change them"
	| attrToChange |
	self attributes isNil ifTrue: [^nil].
	attrToChange := #( #onClick #onDblClick #onKeyDown #onKeyPress #onKeyUp 
		#onMouseDown #onMouseMove #onMouseOut #onMouseOver #onMouseUp 
		#onSelect #onFocus #onChange #onSubmit #onReset).
	(self attributes associations select: [:each | attrToChange includes: each key]) do: [:assoc |
		assoc value class = OrderedCollection
			ifTrue: [self attributesAt: assoc key put: 
					(assoc value collect: [:each | self changeContextInAttribute: each from: oldCtx to: newCtx]) ]
			ifFalse: [self attributesAt: assoc key put: (self changeContextInAttribute: assoc value from: oldCtx to: newCtx)] ].!

checkAndInitElements
	"lazy initialization od elements, when needed. Only for composite elements, else error"
	self isComposite 
		ifTrue:[(elements = nil) ifTrue: [elements := OrderedCollection new.       ]]
		ifFalse: [Smalltalk error: 'This is not a composite WebElement'].!

class: aSymbol
	"style class of that element. Used for Cascaded Style Sheets"
	self attributesAt: #class put: aSymbol!

clear
	"remove all subelements including tables"
	self initElements.
	self clearTableInfo.
	self initScripts.!

clearTableInfo
	"clear all table information"
	self initTable!

colorValue: aColorSymbol
	"Hex number format is: #rrbbgg if not in that format, then it can be a color name as defined in 
	class variable Colors (class method initColorDictionary). If unknown color, then attribute is set to nil"
	| attribute |
	attribute := aColorSymbol asString asLowercase asSymbol.
	attribute := WebElement colorDictionary at: attribute ifAbsent:
		[attribute asString do: [:chr | 
			(chr isDigit or: [chr asInteger between: $a asInteger and: $f asInteger]) ifFalse: [^self] ] ].
	^'#', (attribute asString copyWithout: $# )

"WebElement new colorValue: #red"!

context
	"return a web execution context on which we are composing a web page"
	^self parent notNil 
		ifTrue: [self parent context] "web window/page knows the best"
		ifFalse: [self firstContextFromStack] "slow!! "!

creationMethod
	"in which method this element was created. see also method"
	^self method notNil
		ifTrue: [self method]
		ifFalse: [self parent method]!

div
	^self otherAt: #divElement ifAbsent: [false]!

div: aBoolean
	"if an element is DIV tag"
	self otherAt: #divElement put: aBoolean!

elements
	elements isNil ifTrue: [self initElements].
	^elements!

eol
	self setNewline.
	^String with: Character cr with: Character lf.!

first
	"Answer the first element.  If the receiver is empty, provide an error 
	notification."

	self checkAndInitElements.  "if not composite element, then error"
	^elements first!

form
	"aWebForm on which that element was created. Used for form element model adapting. 
	Usually a context window form for view, on which this element was created.
	Use it in conjunction with #method for Ajax"
	^self otherAt: #form ifAbsent: 
		[self parent notNil 
			ifTrue: [self parent form]
			ifFalse: [nil]  ] "maybe app form?"!

form: aSymbol
	"form on which that element was created. Used for form element model adapting"
	"Usually a context window form for view, on which this element was created."
	self otherAt: #form put: aSymbol!

helpLink
	^self app helpLink!

hide
	"hide me from web page"
	self registerId.
	self addText: '<script>Element.hide(''', self id, ''')</script>'!

id
	^self attributesAt: #id!

id: aSymbol
	"set a unique id of that element on a page. Used in javascript, urls, style sheets"
	| ctx |
	ctx := self context.
	self id notNil ifTrue: "unregister old id"
		[(ctx isRegistered: self) ifTrue: [ctx removeId: self id]].
	self attributesAt: #id put: aSymbol asSymbol.
	ctx registerIdFor: self.!

ident
	"ident this tag to its level"
	| depth eol|
	eol := ''.
	self shouldIdent & self isNewline not ifTrue: [eol := self eol]. 
	depth := (self identationLevel - self identDepth) max: 0.
	self identDepth: self identationLevel.
	^eol, (String new: depth withAll: Character tab )!

identationLevel	
	"How much we need to ident. Top element (web page) has level 0"
	| page |
	self isWebPage ifTrue: [^0].
	^self parent notNil
		ifTrue: 
			[page := self webPage. page isNil ifTrue: [^0].
			self shouldIdent 
				ifTrue: [page identationLevel + 1] 
				ifFalse: [page identationLevel]]
		ifFalse: [0]!

identDepth
	"how idented we are"
	| page |
	page := self webPage.
	^page notNil ifTrue: [page identDepth] ifFalse: [0].!

identDepth: aNumber
	"how idented we are"
	| page |
	page := self webPage.
	^page isNil ifTrue: [0] ifFalse: [page identDepth: aNumber]!

initAttributes
	attributes := Dictionary new.!

initElements
	elements := OrderedCollection new.!

initOther
	other := Dictionary new.!

initScripts
	self other isNil ifTrue: [^nil].
	self other removeKey: #scriptBefore ifAbsent: [].
	self other removeKey: #scriptAfter ifAbsent: [].!

initTable
	"just remove from other, later will be initalized lazily"
	self other isNil ifTrue: [^nil].
	self other 
		removeKey: #currentTable ifAbsent: [];
		removeKey: #currentRow ifAbsent: [];
		removeKey: #currentCell ifAbsent: [].!

initTableIfNessesary
	"if not already exist"
	self otherAt: #currentTable ifAbsent: [self newTable]!

insideDivTag
	"to enclose or not in div tag. Only if element have any attribute!!"
	^self div | (self class == WebElement and: [self attributes notNil]).!

isComposite
	"true, if this element is allowed to be composed by subelements.
	This method should be overriden by subclasess if a new element is not a 	composite."
	^true!

isFormElement
	^false!

isNewline
	"are we at start of new line?"
	| page |
	page := self webPage.
	^page notNil ifTrue: [page isNewline] ifFalse: [false]!

isRespondingStreamed
	^false!

isStubElement
	^false!

isWebApplication
	^false!

isWebElement
	^true!

isWebPage
	^false!

isWebWidget
	^false!

last
	"Answer the last element.  If the receiver is empty, create an error notification."

	self checkAndInitElements.  "if not composite element, then error"
	^elements last!

level	
	"How deep we are in element hierarchy. Top element has level 0"
	^self parent notNil
		ifTrue: [self parent level + 1]
		ifFalse: [0]!

method
	"a method which created this element, always from some App. 
	Valid only for aWebElement, never for its subclasses!!"
	^self otherAt: #method ifAbsent: [nil]!

method: aSymbol
	"a method which created this element, always from some App. 
	Valid only for aWebElement, never for its subclasses!!"
	| ctx |
	self otherAt: #method put: aSymbol.
	ctx := self context.
	ctx notNil ifTrue: [self form: self context form]!

newCell
	"add a new cell to current table row. Return a new WebTableCell so that you can send messages
	to it immediatelly - color, width, addText etc."
	self cell: WebTableCell new.
	self row add: self cell.
	^self cell!

newRow
	"add a new row to current table. Return a new WebTableRow so that you can send messages
	to it immediatelly - color, width etc. Also reset current row and current cell to a new ones. "
	self row: WebTableRow new.
	self table add: self row.
	self newCell.
	^self row!

newTable
	"add a new table to this element. Return a new WebTable so that you can send messages
	to it immediatelly - color, width etc. Also reset current row and current cell to a new ones. "
	self table: WebTable new.
	self add: self table.
	self newRow.
	^self table!

nilAttributes
	attributes := nil.!

onClick: aJavascriptCode
	self attributesAt: #onClick add: aJavascriptCode!

onClickDoEffect: aSymbol
	self onClickDoEffect: aSymbol for: self!

onClickDoEffect: aSymbol duration: aNumber
	self onClickDoEffect: aSymbol for: self duration: aNumber!

onClickDoEffect: aSymbol for: anElementOrId
	^self onClickDoEffect: aSymbol for: anElementOrId duration: 1.0!

onClickDoEffect: aSymbol for: anElementOrId duration: aNumber
	"Scriptaculous specific"
	| idSymbol |
	self app style ensureJsResourceForScriptaculous.
	self app style ensureJavascriptForScriptaculousInHeader.
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'new Effect.', aSymbol asString, '(''', idSymbol asString, ''', {duration:', aNumber asString,'})'.!

onClickDoToggleEffect: aSymbol for: anElementOrId
	^self onClickDoToggleEffect: aSymbol for: anElementOrId duration: 1.0!

onClickDoToggleEffect: aSymbol for: anElementOrId duration: aNumber
	"Scriptaculous specific"
	| idSymbol |
	self app style ensureJsResourceForScriptaculous.
	self app style ensureJavascriptForScriptaculousInHeader.
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'new Effect.toggle(''', idSymbol asString, ''', ''', aSymbol asString, ''', {duration:', aNumber asString,'})'.!

onClickHide: anElementOrId
	"hide specified element on mouse click on me"
	"Prototype specific"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.hide(''', idSymbol asString, ''')'.!

onClickPopup: anElement
	"popup a specified element (can be also a WebWidget) with fresh content from server (AJAX) in a 
       new window on the same page"
	| ctx popup |
	ctx := self context.
	popup := ctx window popupStub.
	self onClickUpdate: popup with: nil additional: 'aidaPopupWindow' contentFrom: anElement
		"popup stub will be filled with contents of anElement calling its creation method"
		"for more see WebApplication>>respondToAjaxReqest: and ajaxUpdate:with:"!

onClickReload
	"reload current page on click off that element"
	self onClick: 'window.location.reload()'.!

onClickShow: anElementOrId
	"show specified element on mouse click on me"
	"Prototype specific"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.show(''', idSymbol asString, ''')'.!

onClickToggle: anElementOrId
	"toggle visibility of specified element on mouse click on me"
	"Prototype specific"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.toggle(''', idSymbol asString, ''')'.!

onClickUpdate: anElement
	"update (and show if not yet) a specified element from server (AJAX)"
	self onClickUpdate: anElement with: nil additional: nil contentFrom: nil!

onClickUpdate: anElement with: anArgString
	"update a specified element from server (AJAX) with calling the element's method with an argument"
	" a method must be able to receive a parameter. For instance: #propertiesElementShow: aBooleanString "
	"Note that an argument will be sent at the time of building the element and not at the  click!!" 
	self onClickUpdate: anElement with: anArgString additional: nil contentFrom: nil!

onClickUpdate: anElement with: anArgString additional: anArg2String contentFrom: anotherElement
	"first argument will be send as an argument of the method while second is additional"
	"If anotherElement is not nil then contents of that element will be put in original element, not original itself!! "
	"Not that parameters will be sent at the time of building the element and not at the  click!!" 
	"See WebApplication>>respondToAjaxRequest: and specially #ajaxUpdateOfOld:from: for more"
	self onClick: 
		(self scriptForUpdate: anElement 
			with: anArgString 
			additional: anArg2String 
			contentFrom: anotherElement)!

onDblClick: aJavascriptCode
	self attributesAt: #onDblClick add: aJavascriptCode!

onKeyDown: aJavascriptCode
	self attributesAt: #onKeyDown add: aJavascriptCode!

onKeyPress: aJavascriptCode
	self attributesAt: #onKeyPress add: aJavascriptCode!

onKeyUp: aJavascriptCode
	self attributesAt: #onKeyUp add: aJavascriptCode!

onMouseDown: aJavascriptCode
	self attributesAt: #onMouseDown add: aJavascriptCode!

onMouseMove: aJavascriptCode
	self attributesAt: #onMouseMove add: aJavascriptCode!

onMouseOut: aJavascriptCode
	self attributesAt: #onMouseOut add: aJavascriptCode!

onMouseOutDoEffect: aSymbol
	self onMouseOutDoEffect: aSymbol for: self!

onMouseOutDoEffect: aSymbol duration: aNumber
	self onMouseOutDoEffect: aSymbol for: self duration: aNumber!

onMouseOutDoEffect: aSymbol for: anElementOrId
	^self onMouseOutDoEffect: aSymbol for: anElementOrId duration: 1.0!

onMouseOutDoEffect: aSymbol for: anElementOrId duration: aNumber
	"Scriptaculous specific"
	| idSymbol |
	self app style ensureJsResourceForScriptaculous.
	self app style ensureJavascriptForScriptaculousInHeader.
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOut: 'new Effect.', aSymbol asString, '(''', idSymbol asString, ''', {duration: ', aNumber asString, '});'.!

onMouseOutHide: anElementOrId
	"hide specified element when mouse get out of me"
	"Prototype specific"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOut: 'Element.hide(''', idSymbol asString, ''')'.!

onMouseOutShow: anElementOrId
	"show specified element when mouse get out of me"
	"Prototype specific"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOut: 'Element.show(''', idSymbol asString, ''')'.!

onMouseOutUpdate: anElement
	"update (and show if not yet) a specified element from server (AJAX)"
	self onMouseOutUpdate: anElement with: nil!

onMouseOutUpdate: anElement with: anArgString
	"update a specified element from server (AJAX) wtih calling an element method with an argument"
	self onMouseOut: 
		(self scriptForUpdate: anElement 
			with: anArgString 
			additional: nil 
			contentFrom: nil)!

onMouseOver: aJavascriptCode
	self attributesAt: #onMouseOver add: aJavascriptCode!

onMouseOverDoEffect: aSymbol
	self onMouseOverDoEffect: aSymbol for: self!

onMouseOverDoEffect: aSymbol duration: aNumber
	self onMouseOverDoEffect: aSymbol for: self duration: aNumber!

onMouseOverDoEffect: aSymbol for: anElementOrId
	^self onMouseOverDoEffect: aSymbol for: anElementOrId duration: 1.0!

onMouseOverDoEffect: aSymbol for: anElementOrId duration: aNumber
	"Scriptaculous specific"
	| idSymbol |
	self app style ensureJsResourceForScriptaculous.
	self app style ensureJavascriptForScriptaculousInHeader.
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOver: 'new Effect.', aSymbol asString, '(''', idSymbol asString, ''', {duration: ', aNumber asString,'});'.!

onMouseOverHide: anElementOrId
	"hide specified element when mouse come over me"
	"Prototype specific"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOver: 'Element.hide(''', idSymbol asString, ''')'.!

onMouseOverShow: anElementOrId
	"show specified element when mouse come over me"
	"Prototype specific"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOver: 'Element.show(''', idSymbol asString, ''')'.!

onMouseOverSyncUpdate: anElement
	"update (and show if not yet) a specified element from server (AJAX)"
	"wait until AJAX response returns (synchronous update)"
	self onMouseOverSyncUpdate: anElement with: nil!

onMouseOverSyncUpdate: anElement with: anArgString
	"update a specified element from server (AJAX) wtih calling an element method with an argument"
	"wait until AJAX response returns (synchronous update)"
	"Prototype specific"
	| id url parms  |
	anElement registerId. id := anElement id.
	url := self ajaxCallUrl. 
	parms:= self ajaxCallUrlParametersFor: anElement.
	anArgString notNil ifTrue: [parms := parms, '&parm=', anArgString].
	self onMouseOver: 'new Ajax.Updater(''', id asString, ''', ''', url, 
		''', {method: ''post'', postBody: ''', parms, ''', evalScripts: true, asynchronous: false})'!

onMouseOverUpdate: anElement
	"update (and show if not yet) a specified element from server (AJAX)"
	self onMouseOverUpdate: anElement with: nil!

onMouseOverUpdate: anElement with: anArgString
	"update a specified element from server (AJAX) wtih calling an element method with an argument"
	self onMouseOver: 
		(self scriptForUpdate: anElement 
			with: anArgString 
			additional: nil 
			contentFrom: nil)!

onMouseUp: aJavascriptCode
	self attributesAt: #onMouseUp add: aJavascriptCode!

other
	^other!

otherAt: aSymbol
	^self otherAt: aSymbol ifAbsent: [nil]!

otherAt: aSymbol ifAbsent: aBlock
	self other isNil ifTrue: [^aBlock value].
	^self other at: aSymbol ifAbsent: aBlock!

otherAt: aSymbol ifAbsentPut: aBlock
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol ifAbsent: [self other at: aSymbol put: aBlock value]!

otherAt: aSymbol put: anObject
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol put: anObject!

parent
	^parent!

parent: aWebElement
	parent := aWebElement!

prepareAttributesToPrintOn: aSession
	"override if you like to change or otherwise prepare attribute values"!

prepareForTranslation
	"if element has multilingual text, make it in-line editable for translation"
	"Sublcasses should implement editing accordingly"
	self elements do: [:each | each prepareForTranslation]!

prepareToHTMLPrintOn: aSession
	"all preparations just before html rendering"
	self prepareAttributesToPrintOn: aSession.  "some pre-html preparation of values"!

printAttributesOn: aStream for: aSession
	"start and end of tag is not my responsibility!!"
	self attributes isNil ifTrue: [^self].
	self attributes keysAndValuesDo: [:name :value |
		self printAttribute: name value: value on: aStream for: aSession]!

printHTMLPageOn: aStream for: aRequest on: aSession
	"WebElement with some attributes is enclosed inside <div> tag, for tricks with CSS"
	self prepareToHTMLPrintOn: aSession.
	self scriptBefore notNil ifTrue: 
		[self scriptBefore printHTMLPageOn: aStream for: aRequest on: aSession].
	self insideDivTag ifTrue: 
		[aStream nextPutAll: self ident, '<div'. self printAttributesOn: aStream for: aSession. 
		aStream nextPutAll: '>', self eol].
	elements notNil ifTrue: [elements do: [:element | 
		element notNil ifTrue: [element printHTMLPageOn: aStream for: aRequest on: aSession] ] ].
	self insideDivTag ifTrue: [aStream nextPutAll: self ident, '</div>', self eol].
	self scriptAfter notNil ifTrue: 
		[self scriptAfter printHTMLPageOn: aStream for: aRequest on: aSession].!

registerId
	"put into current context ids dictionary for faster search from AJAX requests"
	| ctx |
	self id notNil ifTrue: [^nil]. "is probably already registered!! "
	ctx := self context.
	ctx notNil ifTrue: 	[ctx registerIdFor: self]!

replace: aSubelement with: anElement
	| index |
	index := self elements indexOf: aSubelement.
	self elements at: index put: anElement.
	anElement parent: self.
	aSubelement parent: nil.!

row
	"return a current table row"
	self initTableIfNessesary.
	^self otherAt: #currentRow!

row: aWebTableRow
	self initTableIfNessesary.
	self otherAt: #currentRow put: aWebTableRow.!

script: aString
	"add this JavaScript  to scripts executed after this element"
	self scriptAfter: aString!

scriptAfter
	^self otherAt: #scriptAfter ifAbsent: [nil]!

scriptAfter: aString
	"add this JavaScript  to scripts executed after this element"
	(self otherAt: #scriptAfter ifAbsentPut: [WebScript new]) script: aString!

scriptAfterExternal: anUrlOrObject
	"add this externalJavaScript  to scripts executed after this element"
	| url |
	url := anUrlOrObject isString
		ifTrue: [anUrlOrObject]
		ifFalse: [self site urlResolver halfUrlFor: anUrlOrObject].
	(self otherAt: #scriptAfter ifAbsentPut: [WebScript new]) source: url!

scriptBefore
	^self otherAt: #scriptBefore ifAbsent: [nil]!

scriptBefore: aString
	"add this JavaScript  to scripts executed before this element"
	(self otherAt: #scriptBefore ifAbsentPut: [WebScript new]) script: aString!

scriptBeforeExternal: anUrlOrObject
	"add this external JavaScript  to scripts executed before this element"
	| url |
	url := anUrlOrObject isString
		ifTrue: [anUrlOrObject]
		ifFalse: [self site urlResolver halfUrlFor: anUrlOrObject].
	(self otherAt: #scriptBefore ifAbsentPut: [WebScript new]) source: url!

scriptForUpdate: anElement with: anArgString additional: anArg2String contentFrom: anotherElement
	"first argument will be send as an argument of the method while second is additional"
	"If anotherElement is not nil then contents of that element will be put in original element, not original itself!! "
	"Not that parameters will be sent at the time of building the element and not at the event!!" 
	"See WebApplication>>respondToAjaxRequest: and specially #ajaxUpdate:from: for more"
	"Prototype specific"
	| id url parms  |
	id := anElement notNil 
		ifTrue: [anElement registerId "if not yet". anElement id]
		ifFalse: [#nothingToUpdate].  "just send arguments, if any"
	url := self ajaxCallUrl. 
	parms:= self ajaxCallUrlParametersFor: anElement.
	anArgString notNil ifTrue: [parms := parms, '&parm=', anArgString].
	anArg2String notNil ifTrue: [parms := parms, '&parm2=', anArg2String].
	anotherElement notNil ifTrue: 
		[parms := parms, '&ajaxContentElementId=', [anotherElement registerId. anotherElement id asString] value ].
	^'new Ajax.Updater(''', id asString, ''', ''', url, 
		''', {method: ''post'', postBody: ''', parms, ''', evalScripts: true})'!

session
	"return a Session for which we are composing a web page"
	^self app session!

setDiv
	self div: true!

setNewline
	"we are no longer at start of line"
	| page |
	page := self webPage.
	page notNil ifTrue: [page setNewline].!

shouldIdent
	"true, if this element should be idented in html page"
	^self insideDivTag!

show
	"show me (if not already) on web page"
	"Prototype specific"
	self registerId.
	self addText: '<script>Element.show(''', self id, ''')</script>'!

site
	"return a Site on which we are composing a web page"
	^self app site!

style
	"return a WebStyle on which we are composing a web page"
	^self site style!

style: aString
	"redefine a style of that element with CSS syntax, example:
	style: '{color: blue; font-style: italic}'   "
	self attributesAt: #style put: aString!

table
	"return a current web table. If not yet exist, create it"
	self initTableIfNessesary.
	^self otherAt: #currentTable!

table: aWebTable
	self otherAt: #currentTable put: aWebTable.!

tagClosing
	" /> for XHTML, > otherwise"
	| page |
	page := self webPage.
	page isNil ifTrue: [page := self app context page]. "as a last resort"
	^(page notNil and: [page isXHTML])
		ifTrue: ['/>']
		ifFalse: ['>']!

title: aString
	"title of an element. it will be shown when mouse pause over it"
	self attributesAt: #title put: 
		"slovene csz are converted if char ^ is after such a char"
		((aString includes: $^ ) ifTrue: [aString convertToSloveneChars] ifFalse: [aString])!

toogle
	"toogle element visibility on  web page"
	"Prototype specific"
	self registerId.
	self addText: '<script>Element.toggle(''', self id, ''')</script>'!

updateEverySeconds: aNumber
	"periodically update itself from server (AJAX) with calling an element method with a parameter"
	self updateEverySeconds: aNumber with: nil!

updateEverySeconds: aNumber with: anArgString
	"periodically update itself from server (AJAX) with calling an element method with an argument"
	"Prototype specific"
	| url parms  |
	self registerId. self id.
	url := self ajaxCallUrl. 
	parms:= self ajaxCallUrlParametersFor: self id.
	anArgString notNil ifTrue: [parms := parms, '&parm=', anArgString].
	self scriptAfter: '
		function createRequest() {
			new Ajax.Request(''', url, ''', { method: ''post'', postBody: ''', parms, ''',
				onSuccess: function(transport) {
					document.getElementById(''', self id, ''').innerHTML=transport.responseText;
				}
			});
		}
		var intervalID= window.setInterval(createRequest, ', (aNumber*1000) printString, ');'.

"	this original Prototype one caues memory leak!! "
"	self scriptAfter: 'new Ajax.PeriodicalUpdater(''', self id asString, ''', ''', url, 
		''', {method: ''post'', postBody: ''', parms, 
		''', evalScripts: true, frequency: ', aNumber printString, '})'
"!

webPage
	"find a WebPage up in the hierarchy on which this element belongs"
	^(self parent notNil and: [self parent isWebElement])
		ifTrue: [self parent webPage]
		ifFalse: [nil]! !
!WebElement categoriesFor: #acceptDropsTo:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #adaptFormElements!private! !
!WebElement categoriesFor: #add:!public!subelements! !
!WebElement categoriesFor: #addAnchorName:!adding links!public! !
!WebElement categoriesFor: #addAspect:for:input:size:!adding form elements!public! !
!WebElement categoriesFor: #addBreak!adding other elements!public! !
!WebElement categoriesFor: #addButtonGif:!adding form buttons!public! !
!WebElement categoriesFor: #addButtonGif:action:!adding form buttons!public! !
!WebElement categoriesFor: #addButtonJpeg:!adding form buttons!public! !
!WebElement categoriesFor: #addButtonJpeg:action:!adding form buttons!public! !
!WebElement categoriesFor: #addButtonPng:!adding form buttons!public! !
!WebElement categoriesFor: #addButtonPng:action:!adding form buttons!public! !
!WebElement categoriesFor: #addButtonText:!adding form buttons!public! !
!WebElement categoriesFor: #addButtonText:action:!adding form buttons!public! !
!WebElement categoriesFor: #addCheckboxAspect:for:!adding form elements!public! !
!WebElement categoriesFor: #addCheckboxObject:from:!adding form elements!public! !
!WebElement categoriesFor: #addCloseWindowText:!adding links!public! !
!WebElement categoriesFor: #addComment:!adding other elements!public! !
!WebElement categoriesFor: #addDateInputFieldAspect:for:!adding ajax components!public! !
!WebElement categoriesFor: #addDelayedFieldAspect:for:!adding ajax components!public! !
!WebElement categoriesFor: #addDelayedFieldAspect:for:size:!adding ajax components!public! !
!WebElement categoriesFor: #addErrorReport!adding other elements!public! !
!WebElement categoriesFor: #addGif:!adding images!public! !
!WebElement categoriesFor: #addGif:size:!adding images!public! !
!WebElement categoriesFor: #addHelpLink!adding other elements!public! !
!WebElement categoriesFor: #addImage:!adding images!public! !
!WebElement categoriesFor: #addImage:imageMap:!adding images!public! !
!WebElement categoriesFor: #addImage:size:!adding images!public! !
!WebElement categoriesFor: #addImage:size:align:!adding images!public! !
!WebElement categoriesFor: #addImage:size:valign:!adding images!public! !
!WebElement categoriesFor: #addInPlaceEditableTextAspect:for:!adding ajax components!public! !
!WebElement categoriesFor: #addInPlaceEditableTextAspect:for:size:!adding ajax components!public! !
!WebElement categoriesFor: #addInPlaceEditableTextAspect:for:size:allow:!adding ajax components!public! !
!WebElement categoriesFor: #addInputFieldAspect:for:!adding form elements!public! !
!WebElement categoriesFor: #addInputFieldAspect:for:size:!adding form elements!public! !
!WebElement categoriesFor: #addJpeg:!adding images!public! !
!WebElement categoriesFor: #addJpeg:size:!adding images!public! !
!WebElement categoriesFor: #addLinkTo:gif:title:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:gif:title:size:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:gif:title:view:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:gif:title:view:parameter:value:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:image:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:image:parameter:value:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:image:size:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:image:view:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:jpeg:title:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:jpeg:title:view:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:message:!adding links!public! !
!WebElement categoriesFor: #addLinkTo:png:title:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:png:title:view:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:png:title:view:parameter:value:!adding links (image)!public! !
!WebElement categoriesFor: #addLinkTo:text:!adding links!public! !
!WebElement categoriesFor: #addLinkTo:text:attributes:!adding links!public! !
!WebElement categoriesFor: #addLinkTo:text:header:!adding links!public! !
!WebElement categoriesFor: #addLinkTo:text:parameter:value:!adding links!public! !
!WebElement categoriesFor: #addLinkTo:text:parameter:value:parameter:value:!adding links!public! !
!WebElement categoriesFor: #addLinkTo:text:view:!adding links!public! !
!WebElement categoriesFor: #addLinkTo:text:view:parameter:value:!adding links!public! !
!WebElement categoriesFor: #addLinkTo:text:view:parameter:value:parameter:value:!adding links!public! !
!WebElement categoriesFor: #addLiveImage:!adding images!public! !
!WebElement categoriesFor: #addLiveImage:imageMap:!adding images!public! !
!WebElement categoriesFor: #addMenuAspect:collection:selected:!adding form elements!public! !
!WebElement categoriesFor: #addMenuAspect:collection:selectedToAspect:of:!adding form elements!public! !
!WebElement categoriesFor: #addMenuCollection:selected:!adding form elements!public! !
!WebElement categoriesFor: #addMenuCollection:selectedToAspect:of:!adding form elements!public! !
!WebElement categoriesFor: #addMethodImage:!adding images!public! !
!WebElement categoriesFor: #addMethodImage:size:!adding images!public! !
!WebElement categoriesFor: #addNbSp!adding other elements!public! !
!WebElement categoriesFor: #addNbSp:!adding other elements!public! !
!WebElement categoriesFor: #addNilLinkText:!adding links!public! !
!WebElement categoriesFor: #addPageBreak!adding other elements!public! !
!WebElement categoriesFor: #addParagraph!adding other elements!public! !
!WebElement categoriesFor: #addPasswordFieldAspect:for:!adding form elements!public! !
!WebElement categoriesFor: #addPasswordFieldAspect:for:size:!adding form elements!public! !
!WebElement categoriesFor: #addPDFLinkTo:!adding links!public! !
!WebElement categoriesFor: #addPng:!adding images!public! !
!WebElement categoriesFor: #addPng:size:!adding images!public! !
!WebElement categoriesFor: #addRedStar!adding text!public! !
!WebElement categoriesFor: #addRichEditorAspect:for:!adding ajax components!public! !
!WebElement categoriesFor: #addRichEditorAspect:for:size:!adding ajax components!public! !
!WebElement categoriesFor: #addRulerSize:!adding other elements!public! !
!WebElement categoriesFor: #addSecureLinkTo:text:!adding links!public! !
!WebElement categoriesFor: #addSecureLinkTo:text:parameter:value:!adding links!public! !
!WebElement categoriesFor: #addSecureLinkTo:text:view:!adding links!public! !
!WebElement categoriesFor: #addSpace!adding text!public! !
!WebElement categoriesFor: #addStubFor:!adding other elements!public! !
!WebElement categoriesFor: #addText:!adding text!public! !
!WebElement categoriesFor: #addText:attributes:!adding text!public! !
!WebElement categoriesFor: #addText:attributes:color:!adding text!public! !
!WebElement categoriesFor: #addText:attributes:font:!adding text!public! !
!WebElement categoriesFor: #addText:attributes:font:color:!adding text!public! !
!WebElement categoriesFor: #addText:color:!adding text!public! !
!WebElement categoriesFor: #addText:font:!adding text!public! !
!WebElement categoriesFor: #addText:font:color:!adding text!public! !
!WebElement categoriesFor: #addText:header:!adding text!public! !
!WebElement categoriesFor: #addText:header:color:!adding text!public! !
!WebElement categoriesFor: #addText:header:font:!adding text!public! !
!WebElement categoriesFor: #addText:header:font:color:!adding text!public! !
!WebElement categoriesFor: #addText:style:!adding text!public! !
!WebElement categoriesFor: #addTextAreaAspect:for:!adding form elements!public! !
!WebElement categoriesFor: #addTextAreaAspect:for:size:!adding form elements!public! !
!WebElement categoriesFor: #addTextAspect:for:!adding text!public! !
!WebElement categoriesFor: #addTextAspect:for:attributes:!adding text!public! !
!WebElement categoriesFor: #addTextBig:!adding text!public! !
!WebElement categoriesFor: #addTextBold:!adding text!public! !
!WebElement categoriesFor: #addTextBoldAspect:for:!adding text!public! !
!WebElement categoriesFor: #addTextCode:!adding text!public! !
!WebElement categoriesFor: #addTextH1:!adding text!public! !
!WebElement categoriesFor: #addTextH2:!adding text!public! !
!WebElement categoriesFor: #addTextH3:!adding text!public! !
!WebElement categoriesFor: #addTextH4:!adding text!public! !
!WebElement categoriesFor: #addTextH5:!adding text!public! !
!WebElement categoriesFor: #addTextItalic:!adding text!public! !
!WebElement categoriesFor: #addTextPreformated:!adding text!public! !
!WebElement categoriesFor: #addTextSmall:!adding text!public! !
!WebElement categoriesFor: #ajaxCallUrl!private-ajax!public! !
!WebElement categoriesFor: #ajaxCallUrlExtended!private-ajax!public! !
!WebElement categoriesFor: #ajaxCallUrlParametersFor:!private-ajax!public! !
!WebElement categoriesFor: #align:!attributes!public! !
!WebElement categoriesFor: #allElements!public!subelements! !
!WebElement categoriesFor: #app!accessing!public! !
!WebElement categoriesFor: #attributes!private-attributes!public! !
!WebElement categoriesFor: #attributesAt:!private-attributes!public! !
!WebElement categoriesFor: #attributesAt:add:!private-attributes!public! !
!WebElement categoriesFor: #attributesAt:put:!private-attributes!public! !
!WebElement categoriesFor: #beDraggable!events-effects&dragdrop!public! !
!WebElement categoriesFor: #beDraggableAndRevert:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #beSortable!events-effects&dragdrop!public! !
!WebElement categoriesFor: #cell!public!tables! !
!WebElement categoriesFor: #cell:!private! !
!WebElement categoriesFor: #changeContextFrom:to:!private-ajax!public! !
!WebElement categoriesFor: #changeContextInAttribute:from:to:!private-ajax!public! !
!WebElement categoriesFor: #changeContextInAttributesFrom:to:!private-ajax!public! !
!WebElement categoriesFor: #checkAndInitElements!public!testing! !
!WebElement categoriesFor: #class:!attributes!public! !
!WebElement categoriesFor: #clear!initialize-release!public! !
!WebElement categoriesFor: #clearTableInfo!public!tables! !
!WebElement categoriesFor: #colorValue:!private! !
!WebElement categoriesFor: #context!accessing!public! !
!WebElement categoriesFor: #creationMethod!private! !
!WebElement categoriesFor: #div!private! !
!WebElement categoriesFor: #div:!private! !
!WebElement categoriesFor: #elements!private! !
!WebElement categoriesFor: #eol!private-identation!public! !
!WebElement categoriesFor: #first!public!subelements! !
!WebElement categoriesFor: #form!private! !
!WebElement categoriesFor: #form:!private! !
!WebElement categoriesFor: #helpLink!accessing!public! !
!WebElement categoriesFor: #hide!events!public! !
!WebElement categoriesFor: #id!attributes!public! !
!WebElement categoriesFor: #id:!attributes!public! !
!WebElement categoriesFor: #ident!private-identation!public! !
!WebElement categoriesFor: #identationLevel!private-identation!public! !
!WebElement categoriesFor: #identDepth!private-identation!public! !
!WebElement categoriesFor: #identDepth:!private-identation!public! !
!WebElement categoriesFor: #initAttributes!initialize-release!public! !
!WebElement categoriesFor: #initElements!initialize-release!public! !
!WebElement categoriesFor: #initOther!initialize-release!public! !
!WebElement categoriesFor: #initScripts!initialize-release!public! !
!WebElement categoriesFor: #initTable!initialize-release!public! !
!WebElement categoriesFor: #initTableIfNessesary!initialize-release!public! !
!WebElement categoriesFor: #insideDivTag!private! !
!WebElement categoriesFor: #isComposite!public!testing! !
!WebElement categoriesFor: #isFormElement!public!testing! !
!WebElement categoriesFor: #isNewline!private-identation!public! !
!WebElement categoriesFor: #isRespondingStreamed!public!testing! !
!WebElement categoriesFor: #isStubElement!public!testing! !
!WebElement categoriesFor: #isWebApplication!public!testing! !
!WebElement categoriesFor: #isWebElement!public!testing! !
!WebElement categoriesFor: #isWebPage!public!testing! !
!WebElement categoriesFor: #isWebWidget!public!testing! !
!WebElement categoriesFor: #last!public!subelements! !
!WebElement categoriesFor: #level!private-identation!public! !
!WebElement categoriesFor: #method!private! !
!WebElement categoriesFor: #method:!private! !
!WebElement categoriesFor: #newCell!public!tables! !
!WebElement categoriesFor: #newRow!public!tables! !
!WebElement categoriesFor: #newTable!public!tables! !
!WebElement categoriesFor: #nilAttributes!initialize-release!public! !
!WebElement categoriesFor: #onClick:!events!public! !
!WebElement categoriesFor: #onClickDoEffect:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onClickDoEffect:duration:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onClickDoEffect:for:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onClickDoEffect:for:duration:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onClickDoToggleEffect:for:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onClickDoToggleEffect:for:duration:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onClickHide:!events!public! !
!WebElement categoriesFor: #onClickPopup:!events-ajax!public! !
!WebElement categoriesFor: #onClickReload!events!public! !
!WebElement categoriesFor: #onClickShow:!events!public! !
!WebElement categoriesFor: #onClickToggle:!events!public! !
!WebElement categoriesFor: #onClickUpdate:!events-ajax!public! !
!WebElement categoriesFor: #onClickUpdate:with:!events-ajax!public! !
!WebElement categoriesFor: #onClickUpdate:with:additional:contentFrom:!events-ajax!public! !
!WebElement categoriesFor: #onDblClick:!events!public! !
!WebElement categoriesFor: #onKeyDown:!events!public! !
!WebElement categoriesFor: #onKeyPress:!events!public! !
!WebElement categoriesFor: #onKeyUp:!events!public! !
!WebElement categoriesFor: #onMouseDown:!events!public! !
!WebElement categoriesFor: #onMouseMove:!events!public! !
!WebElement categoriesFor: #onMouseOut:!events!public! !
!WebElement categoriesFor: #onMouseOutDoEffect:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onMouseOutDoEffect:duration:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onMouseOutDoEffect:for:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onMouseOutDoEffect:for:duration:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onMouseOutHide:!events!public! !
!WebElement categoriesFor: #onMouseOutShow:!events!public! !
!WebElement categoriesFor: #onMouseOutUpdate:!events-ajax!public! !
!WebElement categoriesFor: #onMouseOutUpdate:with:!events-ajax!public! !
!WebElement categoriesFor: #onMouseOver:!events!public! !
!WebElement categoriesFor: #onMouseOverDoEffect:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onMouseOverDoEffect:duration:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onMouseOverDoEffect:for:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onMouseOverDoEffect:for:duration:!events-effects&dragdrop!public! !
!WebElement categoriesFor: #onMouseOverHide:!events!public! !
!WebElement categoriesFor: #onMouseOverShow:!events!public! !
!WebElement categoriesFor: #onMouseOverSyncUpdate:!events-ajax!public! !
!WebElement categoriesFor: #onMouseOverSyncUpdate:with:!events-ajax!public! !
!WebElement categoriesFor: #onMouseOverUpdate:!events-ajax!public! !
!WebElement categoriesFor: #onMouseOverUpdate:with:!events-ajax!public! !
!WebElement categoriesFor: #onMouseUp:!events!public! !
!WebElement categoriesFor: #other!private-other!public! !
!WebElement categoriesFor: #otherAt:!private-other!public! !
!WebElement categoriesFor: #otherAt:ifAbsent:!private-other!public! !
!WebElement categoriesFor: #otherAt:ifAbsentPut:!private-other!public! !
!WebElement categoriesFor: #otherAt:put:!private-other!public! !
!WebElement categoriesFor: #parent!accessing!public! !
!WebElement categoriesFor: #parent:!private! !
!WebElement categoriesFor: #prepareAttributesToPrintOn:!printing!public! !
!WebElement categoriesFor: #prepareForTranslation!private! !
!WebElement categoriesFor: #prepareToHTMLPrintOn:!printing!public! !
!WebElement categoriesFor: #printAttributesOn:for:!printing!public! !
!WebElement categoriesFor: #printHTMLPageOn:for:on:!printing!public! !
!WebElement categoriesFor: #registerId!attributes!public! !
!WebElement categoriesFor: #replace:with:!public!subelements! !
!WebElement categoriesFor: #row!public!tables! !
!WebElement categoriesFor: #row:!private! !
!WebElement categoriesFor: #script:!public!scripts! !
!WebElement categoriesFor: #scriptAfter!private! !
!WebElement categoriesFor: #scriptAfter:!public!scripts! !
!WebElement categoriesFor: #scriptAfterExternal:!public!scripts! !
!WebElement categoriesFor: #scriptBefore!private! !
!WebElement categoriesFor: #scriptBefore:!public!scripts! !
!WebElement categoriesFor: #scriptBeforeExternal:!public!scripts! !
!WebElement categoriesFor: #scriptForUpdate:with:additional:contentFrom:!private-ajax!public! !
!WebElement categoriesFor: #session!accessing!public! !
!WebElement categoriesFor: #setDiv!attributes!public! !
!WebElement categoriesFor: #setNewline!private-identation!public! !
!WebElement categoriesFor: #shouldIdent!private-identation!public! !
!WebElement categoriesFor: #show!events!public! !
!WebElement categoriesFor: #site!accessing!public! !
!WebElement categoriesFor: #style!accessing!public! !
!WebElement categoriesFor: #style:!attributes!public! !
!WebElement categoriesFor: #table!public!tables! !
!WebElement categoriesFor: #table:!private! !
!WebElement categoriesFor: #tagClosing!printing!public! !
!WebElement categoriesFor: #title:!attributes!public! !
!WebElement categoriesFor: #toogle!events!public! !
!WebElement categoriesFor: #updateEverySeconds:!events-ajax!public! !
!WebElement categoriesFor: #updateEverySeconds:with:!events-ajax!public! !
!WebElement categoriesFor: #webPage!accessing!public! !

!WebElement class methodsFor!

newClass: aSymbol
	"new with CSS class as specified"
	^self new class: aSymbol!

newDiv
	"element enclosed in div tag"
	^self new setDiv!

newId: aSymbol
	"new with id as specified"

	^self new id: aSymbol!

printWebPageFor: aRequest on: aSession 

	"do a page of all colors in a color dicionary"

	| colors page table col |
	colors := self colorDictionary keys.
	page := WebPage new.
	page title: 'Web Color Table'.
	table := WebTable new.
	col := 0. 
	table add: WebTableRow new.
	colors do: [:color |
		(col \\ 5 = 0) ifTrue: [table add: WebTableRow new]. col := col + 1.
		table add: (WebTableCell new bgColor: (self valueForColor: color); 
			addBreak; 
			addText: '<font face=helvetica size=-1>';
			addText: (color printString); addBreak;
			addText: ((self valueForColor: color) printString); addBreak;
			addText: (color printString) color: #white; addBreak;
			addText: ((self valueForColor: color) printString) color: #white; addBreak;
			addText: '</font>').
		].
	page add: table.
	^page

"WebElement printWebPageFor: (WebSession new)"!

valueForColor: aColorSymbolOrString
	"return a hex value for specified color. Case of color string is not important. 
	return red if color is unknown"
	| color |
	color := aColorSymbolOrString asString asLowercase asSymbol.
	^self colorDictionary at: color ifAbsent: [^self colorDictionary at: #red].

"
WebElement valueForColor: 'blue' 
"! !
!WebElement class categoriesFor: #newClass:!instance creation!public! !
!WebElement class categoriesFor: #newDiv!instance creation!public! !
!WebElement class categoriesFor: #newId:!instance creation!public! !
!WebElement class categoriesFor: #printWebPageFor:on:!printing!public! !
!WebElement class categoriesFor: #valueForColor:!color values!public! !

WebGridColumn guid: (GUID fromString: '{02F5F23D-F92C-4E71-842D-DB6DC7C4E413}')!
WebGridColumn comment: ''!
!WebGridColumn categoriesForClass!Unclassified! !
!WebGridColumn methodsFor!

addBlock
	^addBlock!

addBlock: aBlock
	"result must be kind of WebElement which will be added to table cell"
	"block needs a row object as an argument"
	addBlock := aBlock!

addToSummary: anObject
	self summaryType = #count ifTrue: [^self summary: self summary + 1].
	self summaryType = #sum ifTrue:
		[^self summary: self summary + (anObject perform: self aspect)]!

aidaDeepCopyNotIn: aDict
	^nil!

align
	^align!

align: aSymbol
	align := aSymbol!

aspect
	^aspect!

aspect: aSymbol
	"a method to be called for this column on objects of current row in a collection"
	aspect := aSymbol!

autoConvert: anObject
	(anObject class == Date and: [self parent hasShortDates]) ifTrue: [^anObject shorterPrintSloString].
	(anObject = 0 and: [self parent hasNoZeros]) ifTrue: [^''].
	^WebFormElement autoConvertToString: anObject!

defaultViewBlock
	^[:object | 
		self aspect isNil ifTrue: [''] ifFalse: [self autoConvert: (object perform: self aspect) ] ]!

filter
	^filter!

filter: aString
	"show only rows with value starting with aString"
	filter := aString.
	self parent page: 1 "always to the first page after filter change!!"!

filterWidth
	"filter input field width"
	^filterWidth!

filterWidth: aNumber
	"filter input field width"
	filterWidth := aNumber!

hasAddBlock
	^self addBlock notNil!

hasLink
	^self linkAspect notNil | self linkView notNil!

id
	^id!

id: aSymbolOrNumber
	"by default it is a position (1st, 2nd etc.)"
	id := aSymbolOrNumber!

initialize!

isCheckboxed
	self parent checkboxes isNil ifTrue: [^false].
	^self parent checkboxes = self id!

isNumbered
	self parent numbering isNil ifTrue: [^false].
	^self parent numbering = self id!

isSortedAscending
	^(self parent sortColumn = self id) and: [self parent sortOrder = #ascending]!

isSortedDescending
	^(self parent sortColumn = self id) and: [self parent sortOrder = #descending]!

linkAspect
	^linkAspect!

linkAspect: aSymbol
	"if set, a link to aspect of  row object will be made"
	linkAspect := aSymbol.!

linkView
	^linkView!

linkView: aSymbol
	"if set, a link to aspect of  row object (spesified with linkAspect:) with that view will be shown"
	linkView := aSymbol.!

name
	^name!

name: aString
	"header name for that column"
	name := aString!

needsSummary
	"summary row is needed"
	^self summaryType notNil!

needsSummaryCount
	^self summaryType notNil and: [self summaryType = #count]!

needsSummarySum
	^self summaryType notNil and: [self summaryType = #sum]!

parent
	^parent!

parent: anObject
	parent := anObject!

printString
	^'aWebGridColumn id: ', self id printString!

representBinaryOn: writer
	^0!

resetSummary
	(self summary notNil and: [self summary isKindOf: Number]) 
		ifTrue: [self summary: 0].!

setFilter
	"this column will have a filter input field in a row below header"
	self filter: ''!

sort
	self parent sortColumn == self id
		ifTrue: [self toggleSortOrder]
		ifFalse: [self sortAscending]!

sortAscending
	self parent sortAscendingOn: self id!

sortDescending
	self parent sortDescendingOn: self id!

sorted
	^sorted!

sorted: aSymbol
	"nil #ascending #descending"
	sorted := aSymbol!

summary
	"here summary of all rows is acumulated, depending on summaryType"
	^summary!

summary: aNumber
	"see comment in method #summary"
	summary := aNumber!

summaryType
	"summary row is added with appropriate value, which can be:
	- #sum : sum of all cels in that column
	- #count : number of all rows, without heading and summary
	- 'some text' to be shown in this summary cell"
	^summaryType!

summaryType: aSymbolOrString
	"see comment in method #summary"
	summaryType := aSymbolOrString.
	(aSymbolOrString = #count) | (aSymbolOrString = #sum)
		ifTrue: [self summary: 0]
		ifFalse: [self summary: aSymbolOrString].!

summaryValue
	"for adding to a table"
	self summary isNil ifTrue: [^''].
	(self summary isKindOf: Number) ifTrue: [^self summary printDotString].
	^self summary "as text"!

toggleSortOrder
	self parent sortColumn == self id
		ifTrue: [self parent sortOrder == #descending
			ifTrue: [self sortAscending]
			ifFalse: [self sortDescending]]
		ifFalse: [self sortAscending]!

viewBlock
	viewBlock isNil ifTrue: [self viewBlock: self defaultViewBlock].
	^viewBlock!

viewBlock: aBlock
	"how to show this column from collection. There is a default"
	"block needs a row object as an argument"
	viewBlock := aBlock!

width
	^width!

width: aNumber
	width := aNumber! !
!WebGridColumn categoriesFor: #addBlock!private-accessing!public! !
!WebGridColumn categoriesFor: #addBlock:!public!settings! !
!WebGridColumn categoriesFor: #addToSummary:!private! !
!WebGridColumn categoriesFor: #aidaDeepCopyNotIn:!private! !
!WebGridColumn categoriesFor: #align!private-accessing!public! !
!WebGridColumn categoriesFor: #align:!public!settings! !
!WebGridColumn categoriesFor: #aspect!private-accessing!public! !
!WebGridColumn categoriesFor: #aspect:!public!settings! !
!WebGridColumn categoriesFor: #autoConvert:!private! !
!WebGridColumn categoriesFor: #defaultViewBlock!private! !
!WebGridColumn categoriesFor: #filter!private-accessing!public! !
!WebGridColumn categoriesFor: #filter:!private-accessing!public! !
!WebGridColumn categoriesFor: #filterWidth!public!settings! !
!WebGridColumn categoriesFor: #filterWidth:!public!settings! !
!WebGridColumn categoriesFor: #hasAddBlock!public!testing! !
!WebGridColumn categoriesFor: #hasLink!public!testing! !
!WebGridColumn categoriesFor: #id!private-accessing!public! !
!WebGridColumn categoriesFor: #id:!public!settings! !
!WebGridColumn categoriesFor: #initialize!initialize-release!public! !
!WebGridColumn categoriesFor: #isCheckboxed!public!testing! !
!WebGridColumn categoriesFor: #isNumbered!public!testing! !
!WebGridColumn categoriesFor: #isSortedAscending!public!testing! !
!WebGridColumn categoriesFor: #isSortedDescending!public!testing! !
!WebGridColumn categoriesFor: #linkAspect!private-accessing!public! !
!WebGridColumn categoriesFor: #linkAspect:!public!settings! !
!WebGridColumn categoriesFor: #linkView!private-accessing!public! !
!WebGridColumn categoriesFor: #linkView:!public!settings! !
!WebGridColumn categoriesFor: #name!private-accessing!public! !
!WebGridColumn categoriesFor: #name:!public!settings! !
!WebGridColumn categoriesFor: #needsSummary!public!testing! !
!WebGridColumn categoriesFor: #needsSummaryCount!public!testing! !
!WebGridColumn categoriesFor: #needsSummarySum!public!testing! !
!WebGridColumn categoriesFor: #parent!private-accessing!public! !
!WebGridColumn categoriesFor: #parent:!private! !
!WebGridColumn categoriesFor: #printString!private! !
!WebGridColumn categoriesFor: #representBinaryOn:!private! !
!WebGridColumn categoriesFor: #resetSummary!private! !
!WebGridColumn categoriesFor: #setFilter!public!settings! !
!WebGridColumn categoriesFor: #sort!public!settings! !
!WebGridColumn categoriesFor: #sortAscending!public!settings! !
!WebGridColumn categoriesFor: #sortDescending!public!settings! !
!WebGridColumn categoriesFor: #sorted!private-accessing!public! !
!WebGridColumn categoriesFor: #sorted:!private-accessing!public! !
!WebGridColumn categoriesFor: #summary!private-accessing!public! !
!WebGridColumn categoriesFor: #summary:!private-accessing!public! !
!WebGridColumn categoriesFor: #summaryType!public!settings! !
!WebGridColumn categoriesFor: #summaryType:!public!settings! !
!WebGridColumn categoriesFor: #summaryValue!private-accessing!public! !
!WebGridColumn categoriesFor: #toggleSortOrder!public!settings! !
!WebGridColumn categoriesFor: #viewBlock!private-accessing!public! !
!WebGridColumn categoriesFor: #viewBlock:!public!settings! !
!WebGridColumn categoriesFor: #width!private-accessing!public! !
!WebGridColumn categoriesFor: #width:!public!settings! !

!WebGridColumn class methodsFor!

newOn: aWebGrid
	^super new initialize parent: aWebGrid! !
!WebGridColumn class categoriesFor: #newOn:!instance creation!public! !

WebHelp guid: (GUID fromString: '{BADA217E-4199-44E6-BB63-0E50F9D99817}')!
WebHelp comment: 'WebHelp for easy made of help system. each view of each App can have its own help page. Each aWebHelpPage has url like http://www.server.com/help/AdminApp/main.html for view #main in AdminApp.


Instance Variables:
	pages	<Dictionary of Dictionary> key=App class name, 
											value=dictionary key: view, value aWebHelpPage'!
!WebHelp categoriesForClass!Unclassified! !
!WebHelp methodsFor!

add: aWebHelpPage
	self forApp: aWebHelpPage app view: aWebHelpPage view put: aWebHelpPage!

existApp: anApp view: aSymbol
	^(self forApp:anApp view: aSymbol) notNil!

forApp: anApp view: aSymbol
	| appName |
	appName := (anApp isKindOf: WebApplication) ifTrue: [anApp class name] ifFalse: [anApp].
	^(self pages at: appName ifAbsent: [^nil]) at: aSymbol asSymbol ifAbsent: [nil]!

forApp: anApp view: aSymbol put: aWebHelpPage
	| appName |
	appName := (anApp isKindOf: WebApplication) ifTrue: [anApp class name] ifFalse: [anApp].
	(self pages at: appName ifAbsentPut: [Dictionary new]) at: aSymbol asSymbol put: aWebHelpPage!

initPages
	pages := Dictionary new.!

pages
	pages isNil ifTrue: [self initPages].
	^pages! !
!WebHelp categoriesFor: #add:!accessing!public! !
!WebHelp categoriesFor: #existApp:view:!accessing!public! !
!WebHelp categoriesFor: #forApp:view:!accessing!public! !
!WebHelp categoriesFor: #forApp:view:put:!accessing!public! !
!WebHelp categoriesFor: #initPages!initialize-release!public! !
!WebHelp categoriesFor: #pages!private! !

WebHelpPage guid: (GUID fromString: '{595A3579-277E-447D-9938-BF93577A5EB0}')!
WebHelpPage comment: 'WebHelpPage contains help for particulal view on particular WebApp

Instance Variables:
	parent	<WebHelp>	back link to WebHelp
	app		<Symbol>	a name of WebApplication subclass
	view	<Symbol>	view of app for which is this help page
	title		<String>	 	title of that help page
	body	<String>	   	help content for that App and view in Wiki format'!
!WebHelpPage categoriesForClass!Unclassified! !
!WebHelpPage methodsFor!

app
	^app!

app: aSymbol
	app := aSymbol!

body
	body isNil ifTrue: [^''].
	^body!

body: aString
	body := aString!

parent
	^parent!

parent: aWebHelp
	parent := aWebHelp!

preferedUrl
	^'/help/',  self app asString, '/', self view asString, '.html'!

title
	title isNil ifTrue: [^''].
	^title!

title: anObject
	title := anObject!

view
	^view!

view: aSymbol
	view := aSymbol! !
!WebHelpPage categoriesFor: #app!accessing!public! !
!WebHelpPage categoriesFor: #app:!accessing!public! !
!WebHelpPage categoriesFor: #body!accessing!public! !
!WebHelpPage categoriesFor: #body:!accessing!public! !
!WebHelpPage categoriesFor: #parent!accessing!public! !
!WebHelpPage categoriesFor: #parent:!accessing!public! !
!WebHelpPage categoriesFor: #preferedUrl!accessing!public! !
!WebHelpPage categoriesFor: #title!accessing!public! !
!WebHelpPage categoriesFor: #title:!accessing!public! !
!WebHelpPage categoriesFor: #view!accessing!public! !
!WebHelpPage categoriesFor: #view:!accessing!public! !

!WebHelpPage class methodsFor!

newForApp: anAppNameSymbol view: aSymbol parent: aWebHelp
	^super new
		app: anAppNameSymbol;
		view: aSymbol;
		parent: aWebHelp! !
!WebHelpPage class categoriesFor: #newForApp:view:parent:!instance creation!public! !

WebIndex guid: (GUID fromString: '{C872DAC0-E2FB-4A45-A019-AEFEF7B711F3}')!
WebIndex comment: ''!
!WebIndex categoriesForClass!Unclassified! !
!WebIndex methodsFor!

addFreshnessRelevance: aDictionary
	"objects with newer modified date are more relevant"
	| weight |
	aDictionary keysDo: [:object |
		(object class selectors includes: #modified) ifTrue:
			[weight := 1000 - (Date today subtractDate: object modified) max: 0.
			aDictionary at: object put:  (aDictionary at: object) + weight] ]!

addVisitsRelevance: aDictionary
	"objects with more visits are more relevant"
	| weight |
	aDictionary keysDo: [:object |
		(object class selectors includes: #modified) ifTrue:
			[weight := 1000 - (Date today subtractDate: object modified) max: 0.
			aDictionary at: object put:  (aDictionary at: object) + weight] ]!

allPopularWordsAndCounts
	"return a collection of words and their total counts, most popular first"
	| collection |
	collection := OrderedCollection new.
	self popularWords keysAndValuesDo: [:word :counter |  
		collection add: (Array with: word with: counter total)].
	^SortedCollection
		withAll: collection
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].!

allWordsAndWeights
	"return sorted collection of all words and sum of weights, biggeest weight first"
	| collection weight |
	collection := OrderedCollection new.
	self index keysDo: [:halfWord |
		(self index at: halfWord) keysDo: [:restWord |
			weight := ((self index at: halfWord) at: restWord) inject: 0 into: 
				[:sum :thirdDictWeight | sum + (thirdDictWeight)].
			collection add: (Array with: halfWord, restWord with: weight) ] ].
	^SortedCollection 
		withAll: collection
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].

" WebIndex default allWordsAndWeights "!

countPopularWords: anArray
	anArray do: [:word |
		(self popularWords includesKey: word) ifFalse: [self openPopularWord: word].
		(self popularWords at: word) incCounter].!

halfWordFrom: aString
	"prepare first three letters, lowercase (also slovene chars)"
	^AIDASite sloveneLowercase: (aString copyFrom: 1 to: 3).!

index
	"index is a dictionary with first three lowercase letters of each indexed world as key and
	another dictionary for remaining letters as value. The second dictionary has remaining letters for key
      and dictionary with objects, where this word occured, as key and number of occurences as value"
	index isNil ifTrue: [self initIndex].
	^index!

indexedObjects
	"return a dictionary with objects which worlds are in index as keys and a set of pointers to third 
       level dictionary in index as values"
	indexedObjects isNil ifTrue: [self initIndexedObjects].
	^indexedObjects!

indexer
	"indexing process"
	^indexer!

indexerProcess
	"this background process wait for objects to be indexed in workQueue and
	index them without disturbing others."
	| object |
	[true] whileTrue: 
		[object := self workQueue next.
		self privIndexObject: object.
		self reportIndexingOf: object].!

indexObject: anObject
	"if anObject responds to a message indexText, then index all its world in index.
	 However, first 	remove indexing for that object if already exist (so, for reindexing  
	objects, use this method also). For performance reasons indexing is done in background"
	self workQueue nextPut: anObject.

"WebIndex default indexObject: WebIndex default"!

indexObjects: aCollection
	aCollection do: [:each | self indexObject: each].!

indexText
	^'Search engine iskanje rezultati iskanja iskalnik'!

indexTitle
	^'Iskalnik'!

indexWord: aString inObject: anObject
	"put a word in that object in index if word is valid one for indexing"
	self indexWord: aString occurences: 1 inObject: anObject!

indexWord: aString occurences: aNumber inObject: anObject
	"put a aNumber occurences of a word in that object in index if word is valid one for indexing"
	| halfWord restWord secDic thirdDic num |
	(self isValidWord: aString) ifFalse: [^self].
	"put an object in indexed object, if not already exist"
	(self indexedObjects includesKey: anObject) ifFalse:
		[self indexedObjects at: anObject put: IdentitySet new].
	"prepare two parts of a words, first three letters and rest"
	halfWord := self halfWordFrom: aString.
	restWord := self restWordFrom: aString.
	"find or create a second level dictionary from first level one"
	secDic := self index at: halfWord 
		ifAbsent: [self index at: halfWord put: Dictionary new].
	"find or create last level dictionary from second level one"
	thirdDic := secDic at: restWord 
		ifAbsent: [secDic at: restWord put: Dictionary new].
	"put an object to third level dictionary and increment nr of worlds if not already exist"
	num := thirdDic at: anObject ifAbsent: [thirdDic at: anObject put: 0].
	thirdDic at: anObject put: num + aNumber.
	"make reference to the third level dictionary for a indexed word"
	(self indexedObjects at: anObject) add: thirdDic.!

indexWords: aWordDictionary inObject: anObject
	self removeObject: anObject.  "if exist"
	aWordDictionary keysAndValuesDo: [:key :value | 
		self indexWord: key occurences: value inObject: anObject].!

initialize
	self initIndex.
	self initIndexedObjects.
	self initPopularWords.
	workQueue := nil.
	self start.

"WebIndex default initialize"!

initIndex
	index := Dictionary new.!

initIndexedObjects
	indexedObjects := IdentityDictionary new.!

initPopularWords
	popularWords := Dictionary new.!

isValidWord: aString
	"a valid word for indexing has more than three letters, without numbers, "
	(aString size > 3) ifFalse: [^false].
	aString do:[:chr | chr isDigit ifTrue: [^false] ].
	^true!

objectsForWord: aString
	"find all objects, which include this word. Return more important objects 
	first (more occurences of worlds etc.)"
	^self privObjectsForWord: aString.

"(WebIndex default objectsForWord: 'knjiga') keys "!

objectsForWords: aString
	"find all objects, which include one or more specified words. return a sorted collection 
	of associations with found objects as keys an relevance of them as values. Most relevant 
	objects are first. Relevance means: 
		nr. of words found * 1000 + occurences of each word"
	| words hits newHits foundWords |
	Transcript show: ' search.'.
	words := (self wordsInText: aString) keys.
	words := words select: [:word | self isValidWord: word].
	hits := IdentityDictionary new.
	foundWords := OrderedCollection new. 
	words do: [:word | 
		newHits := self objectsForWord: word.
		newHits notEmpty ifTrue: [foundWords add: word].
		newHits keysAndValuesDo: [:key :value |
			(hits includesKey: key)
				ifTrue: [hits at: key put: (hits at: key)+1000]
				ifFalse: [hits at: key put: 1000+value] ] ].
	self countPopularWords: foundWords.  "count as popular only words, which exist in objects"
	self addFreshnessRelevance: hits.
	Transcript show: '.ok '.
	^SortedCollection withAll: hits associations sortBlock: [:first : second | first value > second value].

"
WebIndex instance objectsForWords: 'ljub'
"!

openPopularWord: aString
	self popularWords at: aString put: WebCounter new.!

popularWords
	"return a dictionary of words as keys and aWebCounters as values"
	popularWords isNil ifTrue: [self initPopularWords].
	^popularWords!

prepareWord: aString
	"cut last char if vowel. Used for simple declension of slovene words"
	aString last isVowel 
		ifTrue: [aString size > 3
			ifTrue: [^aString copyFrom: 1 to: (aString size - 1)] ].
	^aString.

"
WebIndex new prepareWord: 'knjiga'
"!

privIndexObject: anObject
	"if anObject responds to a message indexText, then index all its world in index. However, 
	first remove indexing for that object if already exist (so, for reindexing  objects, 
	use this method also)"
	| words |
"	WebTransactionMonitor critical:  " "this will in case of error block all!! "
		(anObject class canUnderstand: #indexText) ifTrue:
			[words := self wordsInText: anObject indexText.
"			(anObject class canUnderstand: #indexTitle) ifTrue:
				[words addAll: (self wordsInText: anObject indexTitle)].
"			self indexWords: words inObject: anObject]!

privObjectsForWord: aString
	"find all objects, which include this word. Return more important objects first (more 
	occurences of worlds etc.)"
	| hits secDic searchWord keys word |
	(self isValidWord: aString) ifTrue:
		[hits := IdentityDictionary new.
		word := self prepareWord: aString.
		searchWord := (self restWordFrom: word), '*'.
		secDic := self index at: (self halfWordFrom: word) ifAbsent: [^hits].
		keys := secDic keys select: [:fkey | searchWord match: fkey].
		keys do: [:skey | 
       		(secDic at: skey) keysAndValuesDo: [:tkey :tvalue | 
				(hits includesKey: tkey) ifFalse: [hits at: tkey put: 0].
				hits at: tkey put: (hits at: tkey)+tvalue] ].
		^hits.
		] ifFalse: [^nil].

"(WebIndex default objectsForWord: 'knjiga') keys "!

removeObject: anObject
	"remove object from all word pointers in index"
	(self indexedObjects at: anObject ifAbsent: [^nil]) do:
		[:each | each removeKey: anObject ifAbsent: [] ].
	self indexedObjects removeKey: anObject.!

restWordFrom: aString
	"preparerest of the word, lowercase (also slovene chars)"
	^AIDASite sloveneLowercase: (aString copyFrom: 4 to: aString size)!

start
	self stop.
	indexer := [self indexerProcess] forkAt: Processor userBackgroundPriority.!

stop
	self indexer notNil ifTrue: [self indexer terminate. indexer := nil].!

wordsInText: aString
	"return a dictionary with all words as keys and number of occurences as values"
	| lastInx currInx word words |
	lastInx := 1. currInx := 1. words := Dictionary new. 
	aString do: [:chr | 
		(chr isAlphaNumeric or: [AIDASite isSloveneCharacter: chr]) ifFalse: 
			[word := aString copyFrom: lastInx to: currInx-1.
			lastInx := currInx+1.
			word := AIDASite sloveneLowercase: word.
			(word = '') ifFalse: 
				[(words includesKey: word) ifFalse: [words at: word put: 0].
				words at: word put: (words at: word) + 1] ].
		currInx := currInx + 1].
		word := aString copyFrom: lastInx to: currInx-1.
		word := AIDASite sloveneLowercase: word.
		(word = '') ifFalse: 
			[(words includesKey: word) ifFalse: [words at: word put: 0].
			words at: word put: (words at: word) + 1].
	^words

"
WebIndex instance wordsInText: 'erot ljub'
"!

workQueue
	"all object to be indexed goes in this queue. An indexer process (which is started first time
	someone requests indexing) then index an object in background"
	workQueue isNil ifTrue: 
		[workQueue := SharedQueue new.
		self indexer isNil ifTrue: [self start] ].
	^workQueue.! !
!WebIndex categoriesFor: #addFreshnessRelevance:!public!searching! !
!WebIndex categoriesFor: #addVisitsRelevance:!public!searching! !
!WebIndex categoriesFor: #allPopularWordsAndCounts!popular words!public! !
!WebIndex categoriesFor: #allWordsAndWeights!accessing!public! !
!WebIndex categoriesFor: #countPopularWords:!popular words!public! !
!WebIndex categoriesFor: #halfWordFrom:!private! !
!WebIndex categoriesFor: #index!accessing!public! !
!WebIndex categoriesFor: #indexedObjects!accessing!public! !
!WebIndex categoriesFor: #indexer!private! !
!WebIndex categoriesFor: #indexerProcess!private! !
!WebIndex categoriesFor: #indexObject:!indexing!public! !
!WebIndex categoriesFor: #indexObjects:!indexing!public! !
!WebIndex categoriesFor: #indexText!accessing!public! !
!WebIndex categoriesFor: #indexTitle!accessing!public! !
!WebIndex categoriesFor: #indexWord:inObject:!indexing!public! !
!WebIndex categoriesFor: #indexWord:occurences:inObject:!private! !
!WebIndex categoriesFor: #indexWords:inObject:!private! !
!WebIndex categoriesFor: #initialize!initialize-release!public! !
!WebIndex categoriesFor: #initIndex!initialize-release!public! !
!WebIndex categoriesFor: #initIndexedObjects!initialize-release!public! !
!WebIndex categoriesFor: #initPopularWords!initialize-release!public! !
!WebIndex categoriesFor: #isValidWord:!public!testing! !
!WebIndex categoriesFor: #objectsForWord:!public!searching! !
!WebIndex categoriesFor: #objectsForWords:!public!searching! !
!WebIndex categoriesFor: #openPopularWord:!popular words!public! !
!WebIndex categoriesFor: #popularWords!accessing!public! !
!WebIndex categoriesFor: #prepareWord:!private! !
!WebIndex categoriesFor: #privIndexObject:!private! !
!WebIndex categoriesFor: #privObjectsForWord:!private! !
!WebIndex categoriesFor: #removeObject:!indexing!public! !
!WebIndex categoriesFor: #restWordFrom:!private! !
!WebIndex categoriesFor: #start!initialize-release!public! !
!WebIndex categoriesFor: #stop!initialize-release!public! !
!WebIndex categoriesFor: #wordsInText:!indexing!public! !
!WebIndex categoriesFor: #workQueue!private! !

!WebIndex class methodsFor!

default
	^AIDASite default index!

instVarMap
	"Gemstone"

	^super instVarMap,
		#( 	(workQueue nil) )!

new
	^super new initialize.

"WebIndex new"!

replicationSpec

	^super replicationSpec, 
		#(  	(index forwarder)
			(indexedObjects forwarder) 
			(popularWords forwarder)  	)! !
!WebIndex class categoriesFor: #default!accessing!public! !
!WebIndex class categoriesFor: #instVarMap!odb specific!public! !
!WebIndex class categoriesFor: #new!instance creation!public! !
!WebIndex class categoriesFor: #replicationSpec!odb specific!public! !

WebLanguage guid: (GUID fromString: '{BB38EFCF-7E76-4CEB-BADD-9C501C6D0DFF}')!
WebLanguage comment: 'WebLanguage on class side holds a table of language names and their ISO codes'!
!WebLanguage categoriesForClass!Unclassified! !
WebMethodResource guid: (GUID fromString: '{FCEE4A15-D737-4A64-AB0E-A3E36E2959B0}')!
WebMethodResource comment: ''!
!WebMethodResource categoriesForClass!Unclassified! !
!WebMethodResource methodsFor!

contentType
	"MIME type for our resource"	
	contentType isNil ifTrue: [self contentType: 'image/gif'].
	^contentType!

contentType: aString
	contentType := aString!

expiresTimestamp
	"24 hours from now, to avoid reloading of images" 
	^SpTimestamp fromSeconds: SpTimestamp now asSeconds + (24*3600)!

isRespondingStreamed
	"always stream method resources"
	^true!

isWebElement
	^false!

isWebPage
	^true!

method
	^method!

method: aSymbol
	method := aSymbol!

object
	^object!

object: anObject
	object := anObject!

preferedUrl
	^preferedUrl!

preferedUrl: aString
	preferedUrl := aString!

printWebPageFor: aRequest on: aSession 
	^self!

site
	"a Site on which this resource will be shown"
	^site!

site: anAIDASite
	site := anAIDASite! !
!WebMethodResource categoriesFor: #contentType!accessing!public! !
!WebMethodResource categoriesFor: #contentType:!accessing!public! !
!WebMethodResource categoriesFor: #expiresTimestamp!accessing!public! !
!WebMethodResource categoriesFor: #isRespondingStreamed!public!testing! !
!WebMethodResource categoriesFor: #isWebElement!public!testing! !
!WebMethodResource categoriesFor: #isWebPage!public!testing! !
!WebMethodResource categoriesFor: #method!accessing!public! !
!WebMethodResource categoriesFor: #method:!accessing!public! !
!WebMethodResource categoriesFor: #object!accessing!public! !
!WebMethodResource categoriesFor: #object:!accessing!public! !
!WebMethodResource categoriesFor: #preferedUrl!accessing!public! !
!WebMethodResource categoriesFor: #preferedUrl:!accessing!public! !
!WebMethodResource categoriesFor: #printWebPageFor:on:!printing!public! !
!WebMethodResource categoriesFor: #site!accessing!public! !
!WebMethodResource categoriesFor: #site:!accessing!public! !

!WebMethodResource class methodsFor!

fromMethod: aSymbol on: anObject contentType: aString preferedUrl: aString2 site: anAIDASite
	^super new
		object: anObject;
		method: aSymbol;
		contentType: aString;
		preferedUrl: aString2;
		site: anAIDASite!

fromMethod: aSymbol on: anObject contentType: aString site: anAIDASite
	^super new
		object: anObject;
		method: aSymbol;
		contentType: aString;
		site: anAIDASite! !
!WebMethodResource class categoriesFor: #fromMethod:on:contentType:preferedUrl:site:!instance creation!public! !
!WebMethodResource class categoriesFor: #fromMethod:on:contentType:site:!instance creation!public! !

WebMsgs guid: (GUID fromString: '{B3A4F8E0-5510-4BF9-87E5-0F9CD187F54A}')!
WebMsgs comment: ''!
!WebMsgs categoriesForClass!Unclassified! !
!WebMsgs methodsFor!

at: aSymbol
	"return a message text at specificied symbol in a language, which is previosly set 
	by language: method. If not set, then default language is used"
	^(self messagesByLanguage at: self language) 
		at: aSymbol asSymbol 
			ifAbsent: 
				[self at: aSymbol put: aSymbol asString. 
				^self at: aSymbol]!

at: aSymbol put: aString
	"store  a message text at specificied symbol in a language, which is previosly set by language: 	method. If not set, then default language is used. Also opens new associations in all other
	languages, if not yet exist"
	(self messagesByLanguage at: self language) at: aSymbol put: aString.
	((self messagesByLanguage at: self language) associationAt: aSymbol).
	self messagesByLanguage keysAndValuesDo: [:key :value |
		(value includesKey: aSymbol asSymbol) 
			ifFalse: [value at: aSymbol asSymbol put: ''] ].!

initialize

	self initNewLanguage: #en.


"
WebMsgs  at: #test put: 'This is my first test'.
WebMsgs language: #hr
WebMsgs at: #test
WebMsgs instance
"!

initNewLanguage: aSymbol
	"in a messagesByLanguage dictionary open a new key and make an empty message dictionary 
	as value, but all symbol keys, which already exist in other languages"
	(self messagesByLanguage includesKey: aSymbol) ifFalse:
		[self messagesByLanguage at: aSymbol put: Dictionary new].
	(self messagesByLanguage at: #en) keysDo: [:key | 
		(self messagesByLanguage at: aSymbol) at: key put: ''].!

language

	"return a current language, for which messages are retrieved"
	
	language isNil ifTrue: [self language: #en].
	^language!

language: aSymbol
	"set a current language, for which messages are retrieved"
	language := aSymbol asSymbol.
	(self messagesByLanguage includesKey: aSymbol asSymbol) 
		ifFalse: [self initNewLanguage: aSymbol asSymbol].!

messagesByLanguage
	"return a dictionary which language symbol as key and value asanother dictionary 
	with message symbol as key and message text as value"
	messagesByLanguage isNil ifTrue:
		[messagesByLanguage := Dictionary new. 
		self initNewLanguage: #en].
	^messagesByLanguage.!

messagesForCurrentLanguage

	"return a dictionary of all messages for a current language"

	^(self messagesByLanguage at: self language)! !
!WebMsgs categoriesFor: #at:!accessing!public! !
!WebMsgs categoriesFor: #at:put:!accessing!public! !
!WebMsgs categoriesFor: #initialize!initialize-release!public! !
!WebMsgs categoriesFor: #initNewLanguage:!initialize-release!public! !
!WebMsgs categoriesFor: #language!accessing!public! !
!WebMsgs categoriesFor: #language:!accessing!public! !
!WebMsgs categoriesFor: #messagesByLanguage!accessing!public! !
!WebMsgs categoriesFor: #messagesForCurrentLanguage!accessing!public! !

!WebMsgs class methodsFor!

at: aSymbol

	"return a message text at specificied symbol in a language, which is previosly set by language: method. If not set, then default language is used"

	^self default at: aSymbol!

at: aSymbol put: aString

	"store  a message text at specificied symbol in a language, which is previosly set by language: method. If not set, then default language is used"

	self default at: aSymbol put: aString!

default

	"find or create an instance of WebMsgs."

	^AIDASite default webMsgs!

language

	"return a current language, for which messages are retrieved"
	
	^self default language.!

language: aSymbol

	"set a current language, for which messages are retrieved"

	self default language: aSymbol!

new

	^super new initialize! !
!WebMsgs class categoriesFor: #at:!accessing!public! !
!WebMsgs class categoriesFor: #at:put:!accessing!public! !
!WebMsgs class categoriesFor: #default!accessing!public! !
!WebMsgs class categoriesFor: #language!accessing!public! !
!WebMsgs class categoriesFor: #language:!accessing!public! !
!WebMsgs class categoriesFor: #new!instance creation!public! !

WebScheduledEvent guid: (GUID fromString: '{19AEA3EE-A814-44D4-A79D-B0739577CB41}')!
WebScheduledEvent comment: ''!
!WebScheduledEvent categoriesForClass!Unclassified! !
!WebScheduledEvent methodsFor!

aidaDeepCopyNotIn: aDictionary
	^nil!

at: aTimestamp runBlock: aBlockClosure
	self timestamp: aTimestamp.
	self block: aBlockClosure.
	self setPeriodSingle!

block
	"a block to be run at event"
	^block!

block: anObject
	block := anObject!

isDayPeriod
	^self period notNil and: [self period key = #day]!

isHourPeriod
	^self period notNil and: [self period key = #hour]!

isMinutePeriod
	^self period notNil and: [self period key = #minute]!

isPeriodic
	^(self period isNil or: [self period key = #single]) not!

method
	"a method to be called on an object at a scheduled time"
	^method!

method: aSymbol
	"a method to be called on an object at a scheduled time"
	method := aSymbol!

object
	"object on which a method wil be called at scheduled time"
	^object!

object: anObject
	object := anObject!

parent
	^parent!

parent: anObject
	parent := anObject!

period
	"asociation with type and parameter: #single>nil #day>aTime, ... "
	^period!

periodType: aSymbol value: anObject
	period := Association key: aSymbol value: anObject!

printString
	^'aScheduledEvent 
	timestamp: ', self timestamp printSloString, ':', self timestamp second printString, '
	period: ', self period key printString, ' ', self period value printString, '
	method: ', self method printString, '
	object: ', self object printString, '
	block: ', self block printString!

representBinaryOn: binWriter
	"for BOSS out. Blocks are not BOSSed out correctly, therefore we cannot export evens that way!!"
	"TEMPORARY, find a better solution!!"
	^0!

run
	"run this event"
	self block notNil 
		ifTrue: [ [self block value] forkAt: self runPriority]
		ifFalse: [ [self object perform: self method] forkAt: self runPriority].
	self isPeriodic ifTrue: [self reschedule]!

runPriority
	^Processor userBackgroundPriority!

setPeriodSingle
	self periodType: #single value: nil!

timestamp
	"when this event must occur"
	^timestamp!

timestamp: aTimestamp
	timestamp := aTimestamp! !
!WebScheduledEvent categoriesFor: #aidaDeepCopyNotIn:!private! !
!WebScheduledEvent categoriesFor: #at:runBlock:!public!setup! !
!WebScheduledEvent categoriesFor: #block!accessing!public! !
!WebScheduledEvent categoriesFor: #block:!private! !
!WebScheduledEvent categoriesFor: #isDayPeriod!public!testing! !
!WebScheduledEvent categoriesFor: #isHourPeriod!public!testing! !
!WebScheduledEvent categoriesFor: #isMinutePeriod!public!testing! !
!WebScheduledEvent categoriesFor: #isPeriodic!public!testing! !
!WebScheduledEvent categoriesFor: #method!accessing!public! !
!WebScheduledEvent categoriesFor: #method:!private! !
!WebScheduledEvent categoriesFor: #object!accessing!public! !
!WebScheduledEvent categoriesFor: #object:!private! !
!WebScheduledEvent categoriesFor: #parent!accessing!public! !
!WebScheduledEvent categoriesFor: #parent:!private! !
!WebScheduledEvent categoriesFor: #period!private-periods!public! !
!WebScheduledEvent categoriesFor: #periodType:value:!private-periods!public! !
!WebScheduledEvent categoriesFor: #printString!private! !
!WebScheduledEvent categoriesFor: #representBinaryOn:!private! !
!WebScheduledEvent categoriesFor: #run!public!running! !
!WebScheduledEvent categoriesFor: #runPriority!public!running! !
!WebScheduledEvent categoriesFor: #setPeriodSingle!private-periods!public! !
!WebScheduledEvent categoriesFor: #timestamp!accessing!public! !
!WebScheduledEvent categoriesFor: #timestamp:!private! !

!WebScheduledEvent class methodsFor!

newOn: aScheduler
	^super new parent: aScheduler! !
!WebScheduledEvent class categoriesFor: #newOn:!instance creation!public! !

WebScheduler guid: (GUID fromString: '{E4412A3A-11B0-431C-B179-010E11F39A8D}')!
WebScheduler comment: 'WebScheduler is a service for running scheduled events. Events can be single or periodic (daily, hourly, ...).
When event is triggered, its block is executed in a separate low priority process. WebScheduler time resolution is 1 second. 

Example of periodic event:
	self site scheduler everyHourAt: 30 "minutes" runBlock: [Trascript show: ''half a hour!!].

Instance Variables:
	site		<anAIDASite>	
	queue	<OrderedCollection>	queue of events, waiting for execution
	loop	<Process>		loop process, every second looks into queue to run an event
	lock		<RecursionLock> to protect queue operations'!
!WebScheduler categoriesForClass!Unclassified! !
!WebScheduler methodsFor!

at: aTimestamp callMethod: aSymbol of: anObject
	| event |
	event := WebScheduledEvent newOn: self.
	event at: aTimestamp callMethod: aSymbol of: anObject.
	self scheduleEvent: event.
	^event!

at: aTimestamp runBlock: aBlock
	| event |
	event := WebScheduledEvent newOn: self.
	event at: aTimestamp runBlock: aBlock.
	self scheduleEvent: event.
	^event!

considerMissedEvents
	"events which we miss to run, eg. if scheduler didn't run for a while"
	self removeMissedEvents "and nothing more, for now"!

everyDayAt: aTimeOrHour runBlock: aBlock
	| event |
	event := WebScheduledEvent newOn: self.
	event everyDayAt: aTimeOrHour runBlock: aBlock.
	self scheduleEvent: event.
	^event!

everyHourAt: aMinuteNumber  runBlock: aBlock
	| event |
	event := WebScheduledEvent newOn: self.
	event everyHourAt: aMinuteNumber  runBlock: aBlock.
	self scheduleEvent: event.
	^event!

everyMinuteAt: aSecondNumber callMethod: aSymbol of: anObject
	| event |
	event := WebScheduledEvent newOn: self.
	event everyMinuteAt: aSecondNumber callMethod: aSymbol of: anObject.
	self scheduleEvent: event.
	^event!

everyMinuteAt: aSecondNumber  runBlock: aBlock
	| event |
	event := WebScheduledEvent newOn: self.
	event everyMinuteAt: aSecondNumber  runBlock: aBlock.
	self scheduleEvent: event.
	^event!

everyMonthday: aDayNumber at: aTime  runBlock: aBlock!

everyWeekday: aDaySymbol at: aTime  runBlock: aBlock!

initialize!

initQueue
	queue := OrderedCollection new.!

insertToQueueEvent: aScheduledEvent
	self lock critical:
		[self queue isEmpty ifTrue: [^self queue add: aScheduledEvent].
		aScheduledEvent timestamp >= self queue last timestamp 
			ifTrue: [^self queue add: aScheduledEvent].
		aScheduledEvent timestamp < self queue first timestamp 
			ifTrue: [^self queue addFirst: aScheduledEvent].
		self queue size to: 1 by: -1 do: [:inx |
			aScheduledEvent timestamp >= (queue at: inx) timestamp ifTrue: 
				[^self queue add: aScheduledEvent beforeIndex: inx+1] ]
		]!

isLoopRunning
	^self loop notNil!

loop
	^loop!

loop: aProcess
	loop := aProcess!

printString
	^'aScheduler on site: ', (self site notNil ifTrue: [self site name] ifFalse: [''])!

queue
	"queue of events next one to run on first place"
	queue isNil ifTrue: [self initQueue].
	^queue!

scheduleEvent: aScheduledEvent
	self insertToQueueEvent: aScheduledEvent.!

schedulerPriority
	^Processor userInterruptPriority!

site
	^site!

site: anAIDASite
	site := anAIDASite!

start
	self considerMissedEvents.
	self startLoop!

stop
	self stopLoop!

stopLoop
	self loop notNil ifTrue: [self loop terminate. self loop: nil].! !
!WebScheduler categoriesFor: #at:callMethod:of:!events-single!public! !
!WebScheduler categoriesFor: #at:runBlock:!events-single!public! !
!WebScheduler categoriesFor: #considerMissedEvents!private! !
!WebScheduler categoriesFor: #everyDayAt:runBlock:!events-periodic!public! !
!WebScheduler categoriesFor: #everyHourAt:runBlock:!events-periodic!public! !
!WebScheduler categoriesFor: #everyMinuteAt:callMethod:of:!events-periodic!public! !
!WebScheduler categoriesFor: #everyMinuteAt:runBlock:!events-periodic!public! !
!WebScheduler categoriesFor: #everyMonthday:at:runBlock:!events-periodic!public! !
!WebScheduler categoriesFor: #everyWeekday:at:runBlock:!events-periodic!public! !
!WebScheduler categoriesFor: #initialize!initialize-release!public! !
!WebScheduler categoriesFor: #initQueue!initialize-release!public! !
!WebScheduler categoriesFor: #insertToQueueEvent:!private! !
!WebScheduler categoriesFor: #isLoopRunning!private! !
!WebScheduler categoriesFor: #loop!private! !
!WebScheduler categoriesFor: #loop:!private! !
!WebScheduler categoriesFor: #printString!private! !
!WebScheduler categoriesFor: #queue!private! !
!WebScheduler categoriesFor: #scheduleEvent:!private! !
!WebScheduler categoriesFor: #schedulerPriority!private! !
!WebScheduler categoriesFor: #site!private! !
!WebScheduler categoriesFor: #site:!private! !
!WebScheduler categoriesFor: #start!public!start/stop! !
!WebScheduler categoriesFor: #stop!public!start/stop! !
!WebScheduler categoriesFor: #stopLoop!private! !

!WebScheduler class methodsFor!

newOn: anAIDASite
	^super new initialize; site: anAIDASite! !
!WebScheduler class categoriesFor: #newOn:!instance creation!public! !

WebSecurityManager guid: (GUID fromString: '{51AB7A8B-C8B7-4664-9C62-805CCBE2F5F5}')!
WebSecurityManager comment: ''!
!WebSecurityManager categoriesForClass!Unclassified! !
!WebSecurityManager methodsFor!

accessByObject 
	"this is a dictionary of user - access level pairs for access to the object, 
	which reference is a key in dictionary"
	accessByObject isNil ifTrue: [self initAccessByObject].
	^accessByObject!

accessRightsArray: anAccessSymbols for: aWebUserOrGroup on: anObject
	| objectRights rigthsArray |
	self site critical:
		[objectRights := self accessByObject at: anObject 
			ifAbsent: 
				[self accessByObject at: anObject put: (Dictionary new).
				self accessByObject at: anObject].
		rigthsArray := objectRights at: aWebUserOrGroup 
			ifAbsent:
				[objectRights at: aWebUserOrGroup put: IdentitySet new.
				objectRights at: aWebUserOrGroup].
		rigthsArray addAll: anAccessSymbols].!

accessRightsFor: aWebUserOrGroup on: anObject
	"get the access rights for specified user or group on object  as literal array of 
	rights (e.g. #(#read #write). " 
	^(self accessByObject at: anObject 
		ifAbsent: [^self defaultAccessRights])
			at: aWebUserOrGroup ifAbsent:  [^self defaultAccessRights]!

activatingGroup
	"group for users to confirm registration"
	^self groups detect: [:each | each isActivatingGroup] ifNone: [nil].!

addActivatingUser: aWebUser
	"add this user also to group waiting for confirmation"
	self addUser: aWebUser.
	self activatingGroup addUser: aWebUser.!

addGroup: aWebUserGroup
	self addGroup: aWebUserGroup ifExist: [^nil].!

addGroup: aWebUserGroup ifExist: aBlock
	"add new group. If already exist ( as object or as group with the same name) do aBlock"
 	(aWebUserGroup isKindOf: WebUserGroup) ifFalse: [^self error: 'This is not aWebUserGroup'].
	(self existGroupNamed: aWebUserGroup name) ifTrue: [aBlock value].
	self groups add: aWebUserGroup!

addGroupNamed: aString
 	"add new group with a specified name. If already exist, error"
	self addGroup: (WebUserGroup new name: aString).!

addPerson: aPerson
	"make parallel WebUser, cross-connect both and put into Registered group"
	"by default username and password are aPerson surname!!"
	| user |
	aPerson asWebUser notNil ifTrue: [^self error: 'already added!!'].
	user := WebUser new.
	user username: aPerson surname.
	user password: aPerson surname.
	(self addRegisteredUser: user) notNil "no duplicates in username"
		ifTrue: [ aPerson webUser: user. user person: aPerson]
		ifFalse: [^nil]!

addRegisteredUser: aWebUser
	"add this user also to registered users group. Remove him from activating group"
	self addUser: aWebUser.
	self registeredGroup addUser: aWebUser.
	self activatingGroup removeUser: aWebUser.!

addUser: aWebUser
	"add new user also in All Users group"
	(aWebUser isKindOf: WebUser) ifFalse: [^self error: 'This is not aWebUser'].
	(self users includes: aWebUser) ifTrue: [^nil].
	(self existUserNamed: aWebUser username withPassword: aWebUser password) ifTrue: [^nil]. 
	self users add: aWebUser.
	self allUsersGroup addUser: aWebUser.
	aWebUser parent: self.!

adminGroup
	"group for admins, those who have all acess rights !! "
	^self groups detect: [:each | each isAdminGroup] ifNone: [nil].!

adminUser
	"first admin user, initialy it is with username 'admin'"
	^self users detect: [:each | each isAdminUser] ifNone: [nil]!

allGroups
	^self groups copy!

allUsers
	^self users copy!

allUsersGroup
	"group for all users in system"
	^self groups detect: [:each | each isAllUsersGroup] ifNone: [nil].!

authenticationScheme
	"#Form - with WebAdminApp login form - default!!
	#HttpBasic - rfc2617 Basic authentication - passwords NOT encrypted!!
	#HttpDigest - rfc2617 Digest authentication - encrypted passwords
	#SSLClientCertificate - most secure, user needs a valid PKI certificate"
	authenticationScheme isNil ifTrue: [self setFormAuthenticationScheme].
	^authenticationScheme!

authenticationScheme: aSymbol
	authenticationScheme := aSymbol!

defaultAccessRights
	
	^#()!

existGroupNamed: aString
	^(self groupNamed: aString) notNil!

existUserNamed: anUsernameString withPassword: aPasswordString
	^(self userNamed: anUsernameString withPassword: aPasswordString) notNil!

existUserWithId: aNumber
	^self users contains: [:each | each id = aNumber].!

extranetUser
	"a common extranet user, for easier setup of access rights"
	^self users detect: [:each | each isExtranetUser] ifNone: [nil]!

groupNamed: aString
	aString isEmpty ifTrue: [^nil].
	^self groups detect: [:group | group name =  aString] ifNone: [nil]!

groups 
	groups isNil ifTrue: [self initGroups].
	^groups!

groupWithUuid: aString
	" find and return a group with specified uuid. Return nil if not found" 
	^self groups detect: [:each | each uuid = aString] ifNone: [nil]!

guestUser
	"actually only one is guest user"
	^self users detect: [:each | each isGuest] ifNone: [nil]!

has: aWebUserOrGroup rightTo: anAccessSymbol on: anObject 
	"test the access right for that object and that user or group "
	| usersAndGroups |
	usersAndGroups := self accessByObject at: anObject ifAbsent: [^false].
	(usersAndGroups includesKey: aWebUserOrGroup)	ifTrue:
		[((usersAndGroups at: aWebUserOrGroup) includes: anAccessSymbol) ifTrue: [^true] ].
	^false!

hasFormAuthenticationScheme
	^self authenticationScheme = #Form!

hasHttpAuthenticationScheme
	^self hasHttpBasicAuthenticationScheme | self hasHttpDigestAuthenticationScheme!

hasHttpBasicAuthenticationScheme
	^self authenticationScheme = #HttpBasic!

hasHttpDigestAuthenticationScheme
	^self authenticationScheme = #HttpDigest!

hasSSLClientCertificateAuthenticationScheme
	^self authenticationScheme = #SSLClientCertificate!

hasUser: aWebUser rightInAnyGroupTo: anAccessSymbol on: anObject 
	"test the access right for that object and in groups for that user"
	aWebUser groups do: [:group |
		(self has: group rightTo: anAccessSymbol on: anObject) ifTrue: [^true] ].
	^(self has: self allUsersGroup rightTo: anAccessSymbol on: anObject)!

initAccessByObject
	accessByObject := Dictionary new.!

initAdminAccess
	"admin group has rights to all views and updates in all Apps!! "
	WebApplication allowAllViewsFor: self adminGroup on: self site.
	WebApplication allowAllUpdatesFor: self adminGroup  on: self site.!

initAdminUser
	"add default admin user"
	| user |
	(self users detect: [:each | each isAdminUser] ifNone: [nil] )
		notNil ifTrue: [^nil].
	user := WebUser newAdmin.
	user setLocked. "to avoid name/username changes"
	self addUser: user.
	self adminGroup addUser: user.!

initDefaultAccessRights
	"to allow login, registering new user etc"
	| views updates |
	views := #(login logout forgoten registration passwordSent waitingConfirmation activation 
		wakeupScriptaculous wakeupRichEditor) 
			collect: [:each | WebAdminApp viewRightSymbolFor: each].
	self setAccessRights: views for: self allUsersGroup on: WebAdminApp name.
	updates := #(login registration passwordSent) 
		collect: [:each | WebAdminApp updateRightSymbolFor: each].
	self setAccessRights: updates for: self allUsersGroup on: WebAdminApp name.

"WebSecurityManager allInstances do: [:each | each initDefaultAccessRights]"!

initDefaultGroups
	self addGroup: WebUserGroup newAllUsers.
	self users do: [:user | 	self allUsersGroup addUser: user].
	self addGroup: WebUserGroup newAdmin.
	self addGroup: WebUserGroup newRegistered.
	self addGroup: WebUserGroup newActivating.
	self postInitDefaultGroups.  "override this method for your own default groups"!

initDemoAccessRights
	"access to all for demos in WebDemoApp"
	"(AIDASite named: 'aidademo') securityManager initDemoAccessRights"
	| views updates |
	views := WebDemoApp allViews asArray
		collect: [:each | WebDemoApp viewRightSymbolFor: each].
	self setAccessRights: views for: self allUsersGroup on: WebDemoApp name.
	updates := #(editMembers fileUpload gridSelected webdav controlFlow) 
		collect: [:each | WebDemoApp updateRightSymbolFor: each].
	self setAccessRights: updates for: self allUsersGroup on: WebDemoApp name.!

initExtranetAccessRights
	"for extranet user"!

initExtranetUser
	"add default extranet user"
	| user |
	(self users detect: [:each | each isExtranetUser and: [each name = WebUser extranetName]] 
		ifNone: [nil] )
			notNil ifTrue: [^nil].
	user := WebUser newExtranet.
	user setLocked. "to avoid name/username changes"
	self addUser: user.
	self registeredGroup addUser: user.!

initGroups
	groups := Set new.!

initGuestAccessRights
	"for guest user"!

initGuestUser
	"add new user,with name 'Guest'"
	| user |
	(self users detect: [:each | each isGuest] ifNone: [nil] ) notNil ifTrue: [^nil].
	user := WebUser newGuest.
	user setLocked. "to avoid name/username changes"
	self addUser: user.
	self allUsersGroup addUser: user.!

initialize
	self initUsers.
	self initGroups.
	self initAccessByObject.
	self initDefaultGroups.
	self initAdminUser. self initGuestUser. self initExtranetUser.
	self initDefaultAccessRights. self initDemoAccessRights.
	self initAdminAccess. self initGuestAccessRights. self initExtranetAccessRights.!

initUsers
	users := Set new. 
	self groups do: [:each | each initUsers].!

isDefaultAllowedTo: anAccessSymbol 
	"default access right for all objects and all users"
	^self defaultAccessRights includes: anAccessSymbol!

isUser: aWebUser allowedTo: anAccessSymbol on: anObject 
	"test the access right for that object and that user or groups for that user"
	(self has: aWebUser rightTo: anAccessSymbol on: anObject) ifTrue: [^true].
	^(self hasUser: aWebUser rightInAnyGroupTo: anAccessSymbol on: anObject)!

isUser: aWebUser inGroup: aWebGroup
	"test if user is member of this group"
	^aWebGroup includes: aWebUser!

isUser: aWebUser inGroupNamed: aString
	| group |
	group := self groupNamed: aString.
	group isNil ifTrue: [^false].
	^group includes: aWebUser!

migrateAppClassessToSymbols
	"do not use app classes but their names as symbols"

	self accessByObject keys do: [:obj |
		((obj isKindOf: Behavior) and: [obj includesBehavior: WebApplication]) ifTrue: [
			self accessByObject 
				at: obj name 
				put: (self accessByObject at: obj).
			self accessByObject removeKey: obj] ].

"WebSecurityManager default migrateAppClassessToSymbols"!

migrateToEncryptedPasswords
	"if not already"
	self allUsers do: [:each | each password size ~= 20 ifTrue: [each password: each password] ]

"WebSecurityManager allInstances do: [:each | each migrateToEncryptedPasswords] "
"WebSecurityManager hashPassword: 'aaa' "!

migrateToLockedReservedUsers
	"to preserve them by not allowing changes"
	"WebSecurityManager allInstances do: [:each | each migrateToLockedReservedUsers] "	
	| user |
	user := self adminUser.
	user isNil ifTrue: [self initAdminUser. user := self adminUser].
	user setLocked.
	user := self guestUser.
	user isNil ifTrue: [self initGuestUser. user := self guestUser].
	user setLocked.
	user := self extranetUser.
	user isNil ifTrue: [self initExtranetUser. user := self extranetUser].
	user setLocked.!

migrateUrlsForUsersAndGroups
	"WebSecurityManager allInstances do: [:each | each migrateUrlsForUsersAndGroups] "
	self site isNil ifTrue: [^nil].	
	self users do: [:each | self site urlResolver changeToPreferedURL: each].
	self groups do: [:each | self site urlResolver changeToPreferedURL: each].!

postInitDefaultGroups
	"override this method for your own default groups"!

printString
	^'WebSecurityManager on: ', self site name!

reconnectUsersToGroups
	"if user groups don't match group users"
	"AIDASite default securityManager reconnectUsersToGroups"
	self users do: [:user |
		user groups do: [:group | (group includes: user) ifFalse: [group addUser: user] ] ].
	self groups do: [:group |
		group users do: [:user | (self users includes: user) ifFalse: [self addUser: user] ] ]!

registeredGroup
	"group for registered users"
	^self groups detect: [:each | each isRegisteredGroup] ifNone: [nil].!

removeAccessRightArray: anAccessSymbols for: aWebUserOrGroup and: anObject 
	"remove all specified access rigths for specified user or group on specified object"
	self site critical:
		[((self accessByObject at: anObject ifAbsent: [^self])
			at: aWebUserOrGroup ifAbsent: [^self])	removeAll: anAccessSymbols].!

removeAccessRightArray: anAccessSymbols for: aWebUserOrGroup on: anObject 
	"remove all specified access rigths for specified user or group on specified object"
	| usrGrps rights |
	self site critical:
		[usrGrps := self accessByObject at: anObject ifAbsent: [^self].
		rights := usrGrps at: aWebUserOrGroup ifAbsent: [^self].
		anAccessSymbols do: [:each | rights remove: each ifAbsent: [] ] ].!

removeAccessRights: anAccessSymbol for: aWebUserOrGroup on: anObject 
	"remove all specified access rigths for specified user or group on specified object"
	| access |
	(anAccessSymbol isKindOf: Array)
		ifTrue: [access := anAccessSymbol ]
		ifFalse: [access := Array with: anAccessSymbol].
	self removeAccessRightArray: access for: aWebUserOrGroup on: anObject!

removeAllAccessRightsFor: aWebUserOrGroup 
	self accessByObject keys do: [:object |
		self 
			removeAllAccessRightsFor: aWebUserOrGroup 
			on: object]!

removeAllAccessRightsFor: aWebUserOrGroup on: anObject 
	self site critical:
		[(self accessByObject at: anObject ifAbsent: [^self])
			removeKey: aWebUserOrGroup ifAbsent: [^self] ].!

removeAllAccessRightsForObject: anObject 
	self site critical:
		[self accessByObject removeKey: anObject ifAbsent: []	].!

removeGroup: aWebUserGroup
	"remove group, if exist. If not exist do nothing" 
	self removeGroup: aWebUserGroup ifAbsent: [].!

removeGroup: aWebUserGroup ifAbsent: aBlock
	"remove group, if exist. If not exist do aBlock. You cannot remove group AllUsers!!" 
	aWebUserGroup isAllUsersGroup ifTrue: [^self error: 'group AllUsers cannot be removed!!'].
	(self groups includes: aWebUserGroup) ifFalse: [^aBlock value].
	self groups remove: aWebUserGroup.
	aWebUserGroup allUsers do: [:each | aWebUserGroup removeUser: each].
	self removeAllAccessRightsFor: aWebUserGroup!

removeGroupNamed:  aString 
	| group |
	group := self groupNamed: aString.
	group notNil ifTrue: [self removeGroup: group]!

removeUser: aWebUser
	"remove user, if exist" 
	(self users includes: aWebUser) ifFalse: [^nil].
	self users remove: aWebUser.
	self allGroups do: [:group | group removeUser: aWebUser].
	self removeAllAccessRightsFor: aWebUser!

removeUserNamed:  anUsername withPassword: aPassword
	| user |
	user := self userNamed: anUsername withPassword: aPassword.
	self removeUser: user!

setAccessRights: anAccessSymbols for: aWebUserOrGroup on: anObject
	"set the access rights for specified user or group on object. it can be only one right 
	or an literal array of rights (e.g.#(#read #write) ) " 
	| access |
	aWebUserOrGroup isNil ifTrue: [^self error: 'User is nil'].
	access := (anAccessSymbols isKindOf: Array) 
		ifTrue: [anAccessSymbols ] 
		ifFalse: [Array with: anAccessSymbols].
	self accessRightsArray: access for: aWebUserOrGroup on: anObject.!

setFormAuthenticationScheme
	"AIDASite default securityManager setFormAuthenticationScheme"
	self authenticationScheme: #Form!

setHttpBasicAuthenticationScheme
	"AIDASite default securityManager setHttpBasicAuthenticationScheme"
	self authenticationScheme: #HttpBasic!

setHttpDigestAuthenticationScheme
	"AIDASite default securityManager setHttpDigestAuthenticationScheme"
	self authenticationScheme: #HttpDigest!

setSSLClientCertificateAuthenticationScheme
	"AIDASite default securityManager setSSLClientCertificateAuthenticationScheme"
	self authenticationScheme: #SSLClientCertificate!

site
	"a parent site using that security manager"
	^site!

site: anAIDASite
	site := anAIDASite.!

userNamed: anUsernameString
	" find and return a WebUser with username . Return nil if not found"
	"WebSecurityManager default userNamed: 'mivsek'"
 	(anUsernameString ~= '') ifFalse: [^nil].
	^self users 
		detect: [:user | (user username asLowercase = anUsernameString asLowercase)] ifNone: [nil]!

userNamed: anUsernameString withPassword: aPasswordString
	" find and return a WebUser with username and password. Return nil if not found"

 	((anUsernameString = '') | (aPasswordString = '')) ifTrue: [^nil].
	^self users detect: [:user | 
		(user username asLowercase = anUsernameString asLowercase) and: 
			[user password = (WebSecurityManager hashPassword: aPasswordString)]] 
				ifNone: [nil]!

users 
	users isNil ifTrue: [self initUsers].
	^users!

userWithEMail: aString
	" find and return a WebUser with specified email. Return nil if not found" 
	(aString ~= '') ifFalse: [^nil]. 
	^self users detect: [:user | user email asLowercase = aString asLowercase ] ifNone: [^nil]!

userWithId: aNumber
	^self users detect: [:each | each id = aNumber] ifNone: [nil]!

userWithName: aNameString surname: aSurnameString
	" find and return a WebUser with name and surname. Return nil if not found"
 	(aNameString ~= '') | (aNameString ~= '') ifFalse: [^nil].
	^self users detect: [:user | 
		(user name asLowercase = aNameString asLowercase) and: 
			[user surname asLowercase = aSurnameString asLowercase]] 
				ifNone: [nil]!

userWithUuid: aString
	" find and return a WebUser with specified uuid. Return nil if not found" 
	^self users detect: [:each | each uuid = aString] ifNone: [nil]! !
!WebSecurityManager categoriesFor: #accessByObject!private! !
!WebSecurityManager categoriesFor: #accessRightsArray:for:on:!private! !
!WebSecurityManager categoriesFor: #accessRightsFor:on:!access control!public! !
!WebSecurityManager categoriesFor: #activatingGroup!group management!public! !
!WebSecurityManager categoriesFor: #addActivatingUser:!public!user management! !
!WebSecurityManager categoriesFor: #addGroup:!group management!public! !
!WebSecurityManager categoriesFor: #addGroup:ifExist:!private! !
!WebSecurityManager categoriesFor: #addGroupNamed:!group management!public! !
!WebSecurityManager categoriesFor: #addPerson:!public!user management! !
!WebSecurityManager categoriesFor: #addRegisteredUser:!public!user management! !
!WebSecurityManager categoriesFor: #addUser:!public!user management! !
!WebSecurityManager categoriesFor: #adminGroup!group management!public! !
!WebSecurityManager categoriesFor: #adminUser!public!user management! !
!WebSecurityManager categoriesFor: #allGroups!accessing!public! !
!WebSecurityManager categoriesFor: #allUsers!accessing!public! !
!WebSecurityManager categoriesFor: #allUsersGroup!group management!public! !
!WebSecurityManager categoriesFor: #authenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #authenticationScheme:!private! !
!WebSecurityManager categoriesFor: #defaultAccessRights!private! !
!WebSecurityManager categoriesFor: #existGroupNamed:!group management!public! !
!WebSecurityManager categoriesFor: #existUserNamed:withPassword:!public!user management! !
!WebSecurityManager categoriesFor: #existUserWithId:!public!user management! !
!WebSecurityManager categoriesFor: #extranetUser!public!user management! !
!WebSecurityManager categoriesFor: #groupNamed:!group management!public! !
!WebSecurityManager categoriesFor: #groups!private! !
!WebSecurityManager categoriesFor: #groupWithUuid:!group management!public! !
!WebSecurityManager categoriesFor: #guestUser!public!user management! !
!WebSecurityManager categoriesFor: #has:rightTo:on:!private! !
!WebSecurityManager categoriesFor: #hasFormAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #hasHttpAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #hasHttpBasicAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #hasHttpDigestAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #hasSSLClientCertificateAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #hasUser:rightInAnyGroupTo:on:!access control!public! !
!WebSecurityManager categoriesFor: #initAccessByObject!initialize-release!public! !
!WebSecurityManager categoriesFor: #initAdminAccess!initialize-release!public! !
!WebSecurityManager categoriesFor: #initAdminUser!initialize-release!public! !
!WebSecurityManager categoriesFor: #initDefaultAccessRights!initialize-release!public! !
!WebSecurityManager categoriesFor: #initDefaultGroups!initialize-release!public! !
!WebSecurityManager categoriesFor: #initDemoAccessRights!initialize-release!public! !
!WebSecurityManager categoriesFor: #initExtranetAccessRights!initialize-release!public! !
!WebSecurityManager categoriesFor: #initExtranetUser!initialize-release!public! !
!WebSecurityManager categoriesFor: #initGroups!initialize-release!public! !
!WebSecurityManager categoriesFor: #initGuestAccessRights!initialize-release!public! !
!WebSecurityManager categoriesFor: #initGuestUser!initialize-release!public! !
!WebSecurityManager categoriesFor: #initialize!initialize-release!public! !
!WebSecurityManager categoriesFor: #initUsers!initialize-release!public! !
!WebSecurityManager categoriesFor: #isDefaultAllowedTo:!private! !
!WebSecurityManager categoriesFor: #isUser:allowedTo:on:!access control!public! !
!WebSecurityManager categoriesFor: #isUser:inGroup:!public!user management! !
!WebSecurityManager categoriesFor: #isUser:inGroupNamed:!public!user management! !
!WebSecurityManager categoriesFor: #migrateAppClassessToSymbols!private! !
!WebSecurityManager categoriesFor: #migrateToEncryptedPasswords!private! !
!WebSecurityManager categoriesFor: #migrateToLockedReservedUsers!private! !
!WebSecurityManager categoriesFor: #migrateUrlsForUsersAndGroups!private! !
!WebSecurityManager categoriesFor: #postInitDefaultGroups!initialize-release!public! !
!WebSecurityManager categoriesFor: #printString!private! !
!WebSecurityManager categoriesFor: #reconnectUsersToGroups!private! !
!WebSecurityManager categoriesFor: #registeredGroup!group management!public! !
!WebSecurityManager categoriesFor: #removeAccessRightArray:for:and:!private! !
!WebSecurityManager categoriesFor: #removeAccessRightArray:for:on:!private! !
!WebSecurityManager categoriesFor: #removeAccessRights:for:on:!access control!public! !
!WebSecurityManager categoriesFor: #removeAllAccessRightsFor:!access control!public! !
!WebSecurityManager categoriesFor: #removeAllAccessRightsFor:on:!access control!public! !
!WebSecurityManager categoriesFor: #removeAllAccessRightsForObject:!access control!public! !
!WebSecurityManager categoriesFor: #removeGroup:!group management!public! !
!WebSecurityManager categoriesFor: #removeGroup:ifAbsent:!private! !
!WebSecurityManager categoriesFor: #removeGroupNamed:!group management!public! !
!WebSecurityManager categoriesFor: #removeUser:!public!user management! !
!WebSecurityManager categoriesFor: #removeUserNamed:withPassword:!public!user management! !
!WebSecurityManager categoriesFor: #setAccessRights:for:on:!access control!public! !
!WebSecurityManager categoriesFor: #setFormAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #setHttpBasicAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #setHttpDigestAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #setSSLClientCertificateAuthenticationScheme!authentication!public! !
!WebSecurityManager categoriesFor: #site!accessing!public! !
!WebSecurityManager categoriesFor: #site:!private! !
!WebSecurityManager categoriesFor: #userNamed:!public!user management! !
!WebSecurityManager categoriesFor: #userNamed:withPassword:!public!user management! !
!WebSecurityManager categoriesFor: #users!private! !
!WebSecurityManager categoriesFor: #userWithEMail:!public!user management! !
!WebSecurityManager categoriesFor: #userWithId:!public!user management! !
!WebSecurityManager categoriesFor: #userWithName:surname:!public!user management! !
!WebSecurityManager categoriesFor: #userWithUuid:!public!user management! !

!WebSecurityManager class methodsFor!

default 
	^AIDASite default securityManager!

newOn: anAIDASite
	^super new 
		site: anAIDASite
		"initialize"  "do that separately, otherwise it drops in indefinitive recursion"! !
!WebSecurityManager class categoriesFor: #default!accessing!public! !
!WebSecurityManager class categoriesFor: #newOn:!instance creation!public! !

WebSession guid: (GUID fromString: '{0BEDAF05-DCD1-413A-927F-2DCF29CD1664}')!
WebSession comment: ''!
!WebSession categoriesForClass!Unclassified! !
!WebSession methodsFor!

addApp: anApplication for: anObject type: aSymbol
	"web or wap apps, type can be #web or #wap "
	| objDict |
	objDict := self appsForObjects at: anObject ifAbsentPut: [Dictionary new].
	objDict at: aSymbol put: anApplication!

addSessionID
	"add session id to  parms dictionary. Url with session id looks like: 	http://www.tris-a.si/welcome.html?id=523453. This should be done for every automaticaly 
	generated url (WebLink printHTMLPage) to distinguish sesions among themselves."
	self parms at: 'id' put: self id printString.!

addWebApp: aWebApplication for: anObject
	^self addApp: aWebApplication for: anObject type: #web!

adminAllowed
	"check if general administration is allowed for user on our session"
	^self site securityManager
		isUser: self user
		inGroupNamed: self site securityManager adminGroup name!

appFor: anObject type: aSymbol 
	^(self appsForObjects at: anObject ifAbsent: [^nil]) 
		at: aSymbol ifAbsent: [^nil]!

appsForObjects
	
	appsForObjects isNil ifTrue: [self initAppsForObjects].
	^appsForObjects!

authenticateFrom: aRequest
	"try to login with username and password from request (rfc2617)"
	| usr |
	aRequest username isNil ifTrue: [^nil].
	usr := self site securityManager userNamed: aRequest username.
	usr isNil ifTrue: [^nil].
	(aRequest matchUserWithPassword: usr password) 
		ifTrue: [self loginUser: usr] ifFalse: [self logout].!

browser
	
	"try to find out, which browser a web request originator is using. It can be #Netscape, #IBM, #Microsoft, #lynx, #Mosaic.  Returns #Unknown if not possible to find out the browser type"

	| partOfString |
	self browserString = '' ifTrue: [^#Unknown].
	partOfString := self browserString copyFrom: 1 to: 6.
	partOfString = 'Mozill' ifTrue: [^#Netscape].
	partOfString = '' ifTrue: [^#Microsoft].
	partOfString = 'IBM-We' ifTrue: [^#IBM].
	partOfString = '' ifTrue: [^#Lynx].
	partOfString = '' ifTrue: [^#Mosaic].!

browserString
	
	"return the string, whick browser sends as identification in a web request"

	self lastRequest isNil ifTrue: [^''].
	^self lastRequest envVariables at: #http_user_agent.!

checkExpirationAndPossiblyLogoutFor: aRequest
	"don't logout if request is POST on the same object (eg. after long editing)"
	self isLoggedIn ifFalse: [^self].
	(self site autoLogout or: [self user autoLogout]) ifFalse: [^self].
	(self isExpired and: [aRequest isPost not]) ifTrue: 
		[self logout.
		(self site admin webAppFor: self) error: self site style sessionTimeoutText].!

clipboard
	"for cut/copy/paste references to web pages to easier hyperlink them"
	^self otherAt: #clipboard ifAbsent: [self initClipboard].!

codePage
	^#'UTF_8' "always!!"!

cookie
	"true if web request in this nonsecure session uses cookies, false otherwise"
	^self cookies at: 1.!

cookie: aBoolean
	self cookies 	at: 1 put: aBoolean!

cookies
	cookies isNil ifTrue: [self initCookies].
	^cookies!

country
	^country!

country: aSymbol
	"set the country of a web request originator in ISO 2letter format"
	country := aSymbol.!

created

	"return the timestamp of a session creation."

	^created!

fullUrlForCurrentPage
	"composes and returns a full url for a curent requested page. If parms dictionary is changed, 
	then a query string with changed parameters is generated. Usefull for presenting the same 
	page in a different way by parameteres in query string"
	^self lastRequest urlString!

fullUrlForPreviousPage
	""
	(self requests isEmpty or: [self requests last isNil]) ifTrue: [^nil].
	^self requests last urlString!

hasSecureCookie
	"check if secure cookie is already set on secure part of session"
	^self secureCookie!

id

	"return the unique identification of a nonsecure session to browser. This is a random generated number at session generation. It can be used for session tracking in URLs, forms, etc."

	^self ids at: 1!

id: aNumber
	"return the unique identification of a nonsecure session. This is a random generated number 
	at session generation. It can be used for session tracking in URLs, forms, etc."
	self ids at: 1 put: aNumber.!

ids
	ids isNil ifTrue: [self initIds].
	^ids!

inAdminMode
	"is session in admin mode?"
	^(self otherAt: #sessionMode) = #admin!

inDevMode
	"is session in developers mode?"
	^(self otherAt: #sessionMode) = #dev!

initAppsForObjects
	appsForObjects := IdentityDictionary new.!

initClipboard
	^self otherAt: #clipboard put: WebClipboard new!

initCookies
	cookies := Array with: false with: false.!

initialize
	self setRandomIds.
	self setCreatedTimestamp.
	self initCookies.
	self initParms.
	self initRequests.
	self initUser.
	self setNormalMode. 
	self initAppsForObjects.!

initIds
	ids := Array new: 2.!

initOther
	other := Dictionary new!

initParms
	^self otherAt: #parms put: Dictionary new.!

initRequests
	^self otherAt: #requests put: [OrderedCollection new].!

initUser
	self user: self site securityManager guestUser!

initUserValues
	userValues := Dictionary new!

inNormalMode
	"is session in normal users mode?"
	^(self otherAt: #sessionMode) = #normal!

inTranslationMode
	"should text in your Apps be in-place edited for translation?"
	^self inAdminMode or: [self inDevMode]!

isActive
	"active if at least one request received last hour"
	self lastRequest isNil ifTrue: [^false].
	^(SpTimestamp now asSeconds - self lastRequest timestamp asSeconds) < 3600!

isEncrypted
	^self lastRequest isEncrypted "for now!! "!

isExpired
	"more than 15min of inactivity"
	self lastRequest isNil ifTrue: [^false].
	^(SpTimestamp now asSeconds - self lastRequest timestamp asSeconds) > (15*60)!

isFromLinux
	^self lastRequest isFromLinux!

isFromMSIE
	^self lastRequest isFromMSIE!

isFromNetscape
	".. or Moziila or Firefox"
	^self lastRequest isFromNetscape!

isFromWindows
	^self lastRequest isFromWindows!

isHttpAuthenticationNeeded
	"Usually we authenticate by WebAdminApp logon form. But if site is configured for HTTP 	authentication (to open a separate username/password dialog window to user), and 
	a session is not yet logged in, this method will return true"
	^self isLoggedIn not and: [self site securityManager hasHttpAuthenticationScheme]!

isLoggedIn
	^self user notNil and: [self user isGuest not]!

language
	"preferred language of a web user. Initialy set from the last request (lazily, when first needed)"
	(language isNil and: [self lastRequest notNil]) ifTrue:
		[self language: (self originatorLanguageFrom: self lastRequest)].
	^language!

language: aLanguageCodeSymbol
	"preferred language of a web user. Initialy set from the last request (lazily, when first needed)"
	language := aLanguageCodeSymbol.!

lastApp
	"return WebApplication subclass which was called with last request"
	^self otherAt: #lastApp!

lastApp: anApplication
	self otherAt: #lastApp put: anApplication!

lastRequest
	"the last, actualy current request pending. also add request to the history in a request 
	if logging is on."
	"BE CAREFULL!! more than one request can be processed concurrently, so don't count 
	that last reques is actually a current one too!! It mostly is, but not always!!"
	^self otherAt: #lastRequest!

lastRequest: aRequest
	"remember the last, actualy current request pending. also add request to the history in a request 
	if logging is on. If first request then also try to find country, language and codePage 
	of the originator"
	self otherAt: #lastRequest put: aRequest.  
	self initParms.				      "clear old parameters"
	self newView: (aRequest queryAt: #view ifAbsent: ['']).  "default new view is view from last request"!

lastView
	"return a view of WebApllication, which is created in response to last request"
	^self otherAt: #lastView!

lastView: aSymbol
	self otherAt: #lastView put: aSymbol!

loginUser: aWebUser
	self user: aWebUser.!

loginUserWithName: aNameString surname: aSurnameString 
	| usr |
	usr := self site securityManager userWithName: aNameString surname: aSurnameString.
	usr notNil ifTrue: [self loginUser: usr]!

logout
	"Replace logged user with Guest. Remember last page to return after login again"
	| origin usr |
	self redirectLink: nil. 	self redirectOrigin: nil.
	self isLoggedIn ifTrue: [usr := self user. self initUser] ifFalse: [^nil].
	origin := usr lastAppUrl. 
	(origin isNil or: [origin = self lastRequest uriString])  ifFalse: 
		[usr logoutFromUrl: origin]. "to jump back after login"!

newView

	"return a value of a 'view' parameter in query part of a URL to be generated. Also used for changing views in a state machine for web applications (in method actionFormForm (here is set) and method printWebPage (here is used to genererate appropriate page))"

	^self parms at: 'view' ifAbsent: [^''].!

newView: aString
	"set a value of a 'view' parameter in query part of a URL to be generated. Also used for changing 
	views in a state machine for web applications (in method actionFormForm (here is set) and method 	printWebPage (here is used to genererate appropriate page))"
	((aString = '') or: [aString isNil]) ifFalse: [self parms at: 'view' put: aString ].!

nilLastApp
	self other notNil ifTrue: [self other removeKey: #lastApp ifAbsent: [nil] ]!

nilLastRequest
	self other notNil ifTrue: [self other removeKey: #lastRequest ifAbsent: [nil] ]!

originatorCountryFrom: aRequest
	"find an ISO country code from a web request"
	"not yet implemented!!"!

originatorLanguageFrom: aRequest
	"find a language from a web request"
	| defaultLang header |
	defaultLang := self site defaultLanguage.
	header := aRequest headerAt: 'Accept-Language' ifAbsent:[^defaultLang].
	header values isEmpty ifFalse: [^(header values at: 1) asSymbol].
	^defaultLang!

other
	^other!

otherAt: aSymbol
	"other values"
	^self otherAt: aSymbol ifAbsent: [nil]!

otherAt: aSymbol ifAbsent: aBlock
	"other values"
	self other isNil ifTrue: [^aBlock value].
	^self other at: aSymbol ifAbsent: aBlock!

otherAt: aSymbol ifAbsentPut: aBlock
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol ifAbsent: [self other at: aSymbol put: aBlock value]!

otherAt: aSymbol put: anObject
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol put: anObject!

parent
	"a session manager !! "
	^parent!

parent: aWebSessionManager
	parent := aWebSessionManager.!

parms
	"This is a dictionary of parameters in query part of url. When web request arrives, parameters 
 	from query string are written here. When any url is dynamically generated, those parms are 
	appended to it as a query string. You can add, change or delete any parameter to better 
	suit your needs (eg. view=brief to instruct brief view of an object) "
	^self otherAt: #parms!

printString
^'aWebSession
	ip: ', (self lastRequest notNil ifTrue: [self lastRequest ip] ifFalse: ['']), '
	user: ', self user username, ' (', self user nameSurname, ')
	created: ', self created printSloString, '
	last:      ', (self lastRequest notNil ifTrue: [self lastRequest timestamp printSloString] ifFalse: ['']), ''!

redirectLink
	"if this aWebLink is set, then web browser will recreate another request with url from that link. Used, if you like, after form action in one page to show page for some other object, e.g. if you have search field in page in one object, and search result is exactly one, then you want to show result page immediately. You can do this with this method.
Atribute redirectLink is reset to nil immediately after printWebPage and before printHTMLPage in WebMediator method dicpatchClient (see WebMediator sendResponseHeaderOn:)"
	^self otherAt: #redirectLink!

redirectLink: aWebLink
	(aWebLink isKindOf: WebLink) | aWebLink isNil ifFalse: [^nil].
	self otherAt: #redirectLink put: aWebLink.!

redirectOrigin
	"this is an URL from where the redirection request originates. Used for returning back from
	exception page, for example when you want to see page without access rights, then you are
	redirected to login page. after successfull login, you are redirected back to intended page.
	Redirect origin is set up automatically by redirectLink: request."
	^self otherAt: #redirectOrigin!

redirectOrigin: anUrlString
	self otherAt: #redirectOrigin put: anUrlString.!

redirectToOrigin
	"Used for returning back from
	exception page, for example when you want to see page without access rights, then you are
      redirected to login page. after successfull login, you are redirected back to intended page.
	Redirect origin is set up automatically by redirectLink: request."
	self redirectOrigin notNil ifTrue:
		[self redirectLink: (WebLink text: '' linkTo: self redirectOrigin).
		self redirectOrigin: nil].!

releaseApplicationState
	self initAppsForObjects.
	self nilLastRequest.
	self nilLastApp.
	self initRequests.
	self initClipboard.
	self redirectLink: nil; redirectOrigin: nil.!

removeApp: anApplication for: anObject type: aSymbol
	(self appsForObjects at: anObject ifAbsent: [^nil])
		removeKey: aSymbol ifAbsent: [^nil]!

removeYourself
	" .. from session manager"
	self parent notNil ifTrue: [self parent removeSession: self].
	self releaseApplicationState.
	self parent: nil.!

requestNum
	"return number of all requests up to now on this session"
	^self requests size!

requests
	"return the history of all requests on this session as ordered collection with the oldest as 
	first and newest as last"
	^self otherAt: #requests ifAbsent: [self initRequests].!

secureCookie
	"true if web request in this secure session uses cookies, false otherwise"
	^self cookies at: 2!

secureCookie: aBoolean
	self cookies at: 2 put: aBoolean!

secureId

	"return the unique identification of a secure session to browser. This is a random generated number at session generation. It can be used for session tracking in URLs, forms, etc."

	^self ids at: 2!

secureId: aNumber
	"return the unique identification of a secure session. This is a random generated number 
	at session generation. It can be used for session tracking in URLs, forms, etc."
	self ids at: 2 put: aNumber.!

servletAppFor: aWebAppSymbol
	"for template based Aida code"
	| app class |
	(self servlets includesKey: aWebAppSymbol) ifFalse:
		[class := WebApplication allSubclasses detect:  
			[:each | each name = aWebAppSymbol] ifNone: [^nil].
		app := class new.
		app session: self.
		self servlets at: aWebAppSymbol put: app].
	^self servlets at: aWebAppSymbol.!

servlets
	^self otherAt: #ServletApps ifAbsentPut: [Dictionary new]!

setAdminMode
	"set session to admin mode"
	self user inAdminGroup ifFalse: [^self error: 'user not in Admininistrators group'].
	self otherAt: #sessionMode put: #admin!

setDevMode
	"set session to developers mode"
	self user isAdminUser ifFalse: [^self error: 'user not Admin!!'].
	self otherAt: #sessionMode put: #dev!

setNormalMode
	"set session to normal users mode"
	self otherAt: #sessionMode put: #normal!

setRandomIds
	self id: (AIDASite random next * 1000000000) asInteger.
	self secureId: (AIDASite random next * 1000000000) asInteger.!

shouldCountRequests
	| policy |
	policy := self site countingPolicy.
	policy = #all ifTrue: [^true].
	policy = #none ifTrue: [^false].
	policy = #onlyGuests ifTrue: [^self user isGuest].
	policy = #excludeAdmins ifTrue: [^self user inAdminGroup not].
	^true!

shouldLogRequests
	| policy |
	policy := self site loggingPolicy.
	policy = #all ifTrue: [^true].
	policy = #none ifTrue: [^false].
	policy = #onlyGuests ifTrue: [^self user isGuest].
	policy = #excludeAdmins ifTrue: [^self user inAdminGroup not].
	^true!

shouldRedirect
	^self redirectLink notNil!

site
	"a session manager !! "
	^self parent site!

user
	user isNil ifTrue: [self initUser].
	^user!

user: aWebUser
	"set a reference to aWebUser, who is logged into this session"
	user := aWebUser.!

userValueAt: aSymbol
	"anything you need to share among Apps in that seesion, like last selected stuff, etc."
	^self userValueAt: aSymbol ifAbsent: [nil]!

userValueAt: aSymbol ifAbsent: aBlock
	^self userValues at: aSymbol ifAbsent: aBlock!

userValueAt: aSymbol put: anObject
	^self userValues at: aSymbol put: anObject!

userValues
	"return a dictionary with user defined values, which scope is this session. Usr can use it for such 
	things as global navigation, remembering views etc."
	userValues isNil ifTrue: [self initUserValues].
	^userValues!

webAppFor: anObject
	^self appFor: anObject type: #web! !
!WebSession categoriesFor: #addApp:for:type:!private-app state!public! !
!WebSession categoriesFor: #addSessionID!private! !
!WebSession categoriesFor: #addWebApp:for:!private-app state!public! !
!WebSession categoriesFor: #adminAllowed!public!security! !
!WebSession categoriesFor: #appFor:type:!private-app state!public! !
!WebSession categoriesFor: #appsForObjects!private-app state!public! !
!WebSession categoriesFor: #authenticateFrom:!public!security! !
!WebSession categoriesFor: #browser!accessing!public! !
!WebSession categoriesFor: #browserString!accessing!public! !
!WebSession categoriesFor: #checkExpirationAndPossiblyLogoutFor:!public!security! !
!WebSession categoriesFor: #clipboard!accessing-other!public! !
!WebSession categoriesFor: #codePage!locale support!public! !
!WebSession categoriesFor: #cookie!accessing!public! !
!WebSession categoriesFor: #cookie:!accessing!public! !
!WebSession categoriesFor: #cookies!private! !
!WebSession categoriesFor: #country!locale support!public! !
!WebSession categoriesFor: #country:!locale support!public! !
!WebSession categoriesFor: #created!accessing!public! !
!WebSession categoriesFor: #fullUrlForCurrentPage!accessing!public! !
!WebSession categoriesFor: #fullUrlForPreviousPage!accessing!public! !
!WebSession categoriesFor: #hasSecureCookie!public!testing! !
!WebSession categoriesFor: #id!accessing!public! !
!WebSession categoriesFor: #id:!accessing!public! !
!WebSession categoriesFor: #ids!private! !
!WebSession categoriesFor: #inAdminMode!public!session modes! !
!WebSession categoriesFor: #inDevMode!public!session modes! !
!WebSession categoriesFor: #initAppsForObjects!initialize-release!public! !
!WebSession categoriesFor: #initClipboard!initialize-release!public! !
!WebSession categoriesFor: #initCookies!initialize-release!public! !
!WebSession categoriesFor: #initialize!initialize-release!public! !
!WebSession categoriesFor: #initIds!initialize-release!public! !
!WebSession categoriesFor: #initOther!initialize-release!public! !
!WebSession categoriesFor: #initParms!initialize-release!public! !
!WebSession categoriesFor: #initRequests!initialize-release!public! !
!WebSession categoriesFor: #initUser!initialize-release!public! !
!WebSession categoriesFor: #initUserValues!initialize-release!public! !
!WebSession categoriesFor: #inNormalMode!public!session modes! !
!WebSession categoriesFor: #inTranslationMode!public!session modes! !
!WebSession categoriesFor: #isActive!public!testing! !
!WebSession categoriesFor: #isEncrypted!public!testing! !
!WebSession categoriesFor: #isExpired!public!testing! !
!WebSession categoriesFor: #isFromLinux!public!testing! !
!WebSession categoriesFor: #isFromMSIE!public!testing! !
!WebSession categoriesFor: #isFromNetscape!public!testing! !
!WebSession categoriesFor: #isFromWindows!public!testing! !
!WebSession categoriesFor: #isHttpAuthenticationNeeded!public!testing! !
!WebSession categoriesFor: #isLoggedIn!public!testing! !
!WebSession categoriesFor: #language!locale support!public! !
!WebSession categoriesFor: #language:!locale support!public! !
!WebSession categoriesFor: #lastApp!accessing-other!public! !
!WebSession categoriesFor: #lastApp:!accessing-other!public! !
!WebSession categoriesFor: #lastRequest!accessing-other!public! !
!WebSession categoriesFor: #lastRequest:!accessing-other!public! !
!WebSession categoriesFor: #lastView!accessing-other!public! !
!WebSession categoriesFor: #lastView:!accessing-other!public! !
!WebSession categoriesFor: #loginUser:!public!security! !
!WebSession categoriesFor: #loginUserWithName:surname:!public!security! !
!WebSession categoriesFor: #logout!public!security! !
!WebSession categoriesFor: #newView!accessing!public! !
!WebSession categoriesFor: #newView:!accessing!public! !
!WebSession categoriesFor: #nilLastApp!initialize-release!public! !
!WebSession categoriesFor: #nilLastRequest!initialize-release!public! !
!WebSession categoriesFor: #originatorCountryFrom:!locale support!public! !
!WebSession categoriesFor: #originatorLanguageFrom:!locale support!public! !
!WebSession categoriesFor: #other!private! !
!WebSession categoriesFor: #otherAt:!private! !
!WebSession categoriesFor: #otherAt:ifAbsent:!private! !
!WebSession categoriesFor: #otherAt:ifAbsentPut:!private! !
!WebSession categoriesFor: #otherAt:put:!private! !
!WebSession categoriesFor: #parent!private! !
!WebSession categoriesFor: #parent:!private! !
!WebSession categoriesFor: #parms!accessing-other!public! !
!WebSession categoriesFor: #printString!private! !
!WebSession categoriesFor: #redirectLink!public!redirection! !
!WebSession categoriesFor: #redirectLink:!public!redirection! !
!WebSession categoriesFor: #redirectOrigin!public!redirection! !
!WebSession categoriesFor: #redirectOrigin:!public!redirection! !
!WebSession categoriesFor: #redirectToOrigin!public!redirection! !
!WebSession categoriesFor: #releaseApplicationState!public!releasing state! !
!WebSession categoriesFor: #removeApp:for:type:!private-app state!public! !
!WebSession categoriesFor: #removeYourself!public!releasing state! !
!WebSession categoriesFor: #requestNum!accessing-other!public! !
!WebSession categoriesFor: #requests!accessing-other!public! !
!WebSession categoriesFor: #secureCookie!accessing!public! !
!WebSession categoriesFor: #secureCookie:!accessing!public! !
!WebSession categoriesFor: #secureId!accessing!public! !
!WebSession categoriesFor: #secureId:!accessing!public! !
!WebSession categoriesFor: #servletAppFor:!private! !
!WebSession categoriesFor: #servlets!private! !
!WebSession categoriesFor: #setAdminMode!public!session modes! !
!WebSession categoriesFor: #setDevMode!public!session modes! !
!WebSession categoriesFor: #setNormalMode!public!session modes! !
!WebSession categoriesFor: #setRandomIds!initialize-release!public! !
!WebSession categoriesFor: #shouldCountRequests!public!testing! !
!WebSession categoriesFor: #shouldLogRequests!public!testing! !
!WebSession categoriesFor: #shouldRedirect!public!redirection! !
!WebSession categoriesFor: #site!accessing!public! !
!WebSession categoriesFor: #user!accessing!public! !
!WebSession categoriesFor: #user:!accessing!public! !
!WebSession categoriesFor: #userValueAt:!public!user values! !
!WebSession categoriesFor: #userValueAt:ifAbsent:!public!user values! !
!WebSession categoriesFor: #userValueAt:put:!public!user values! !
!WebSession categoriesFor: #userValues!private! !
!WebSession categoriesFor: #webAppFor:!private-app state!public! !

!WebSession class methodsFor!

newOn: aWebSessionManager
	"new web session on a specified session manager"
	| session |
	session := super new.
	session parent: aWebSessionManager.
	session initialize.
	^session! !
!WebSession class categoriesFor: #newOn:!instance creation!public! !

WebSessionManager guid: (GUID fromString: '{D917BF0A-6C46-4AF0-872E-39802020627B}')!
WebSessionManager comment: ''!
!WebSessionManager categoriesForClass!Unclassified! !
!WebSessionManager methodsFor!

addSession: aWebSession
	self site critical:
		[self sessions 
			at: aWebSession id put: aWebSession;
			at: aWebSession secureId put: aWebSession]!

allActiveSessions
	^self allSessions select: [:each | each isActive].!

allGuestSessions
	^self allSessions select: [:each | each user isNil or: [each user isGuest] ].!

allNonactiveGuestSessions
	"guest sessions nonactive more that one hour"
	^self allGuestSessions select: [:each | each isActive not].!

allSessions
	^self sessions values asSet  "to remove duplicates because the session id can be double, 
							     one for ssl too!!"!

bindSSLSessionFor: aRequest
	"Try to find a session among currently live sessions. It helps with a session id in a query 
	part of url. If not found, or id not in query string, then make a new session"
	| session id |
	id := aRequest queryAt: 'sessionId' ifAbsent: [self error: 'no session id!!'].
	session := (self existSessionWithID: id asInteger)
		ifTrue: [self findSessionWithID: id asInteger]
		ifFalse: [self error: 'no session with that id'].
	session requests size = 1
		ifTrue: [self countNewVisitor]
		ifFalse: 	[self checkAndCountReturningVisitor: session].
	session lastRequest: aRequest.
	(aRequest includesQuery:  'setLanguage') ifTrue:
		[session language: (aRequest queryAt: 'setLanguage') asSymbol].
	^session.!

checkAndCountReturningVisitor: aSession
	"returning visitor is those who is not active more than 1h"
	(aSession isActive not and: [aSession requests size > 1]) ifTrue:
		[self site critical: [self site returningVisitorsCounter incCounter] ]!

countNewVisitor
	self site critical:
		[self site newVisitorsCounter incCounter]!

existSessionWithID: anIDNumber
	^self sessions includesKey: anIDNumber.!

findAllSessionsWithUsername: aString
	^self sessions values select: [:each | each user username = aString]!

findOrCreateSessionFor: aRequest
	"Try to find a session among currently live sessions. It helps with a session id in a query 
	part of url. If not found, or id not in query string, then make a new session"
	| session id cookie |
	(self hasSSLBinding: aRequest) ifTrue: [^self bindSSLSessionFor: aRequest].
	(aRequest hasCookie and: [aRequest idFromCookie notNil])
		ifTrue: [id := aRequest idFromCookie. cookie := true. self site log: ' cookie ' ]
		ifFalse: 
			[cookie := false. id := aRequest queryAt: 'id' ifAbsent: [(self newSessionCookie: cookie) id] ].
	session := (self existSessionWithID: id asInteger)
		ifTrue: [self findSessionWithID: id asInteger] 
		ifFalse: [self newSessionCookie: cookie id: id asInteger].
	session requests size = 1 
		ifTrue: [self countNewVisitor] ifFalse: 	[self checkAndCountReturningVisitor: session].
	session checkExpirationAndPossiblyLogoutFor: aRequest.
	session lastRequest: aRequest.
	session cookie: cookie. 
	(cookie not and: [self site urlsWithSessionId]) ifTrue: [session addSessionID].

	(aRequest includesQuery:  'setLanguage') ifTrue:
		[session language: (aRequest queryAt: 'setLanguage') asSymbol].
	^session.!

findSessionWithID: anIDNumber
	^self sessions at: anIDNumber ifAbsent: [nil].!

findSessionWithUsername: aString
	^self sessions detect: [:each | each user username = aString] ifNone: [nil].!

hasSSLBinding: aRequest
	"if sessionId=456546464 exist in query part of request. This means that this is 
	a SSL session with its own cookie and must be bind to a normal session with sessionId"

	^aRequest isEncrypted and: [aRequest includesQuery: 'sessionId']!

initialize
	self initSessions.

"WebSessionManager default initialize"!

initSessions
	sessions := Dictionary new.!

newSessionCookie: aBoolean
	"open and return a fresh new session"
	^self newSessionCookie: aBoolean id: nil!

newSessionCookie: aBoolean id: aSessionID
	"open and return a fresh new session"
	| session |
	session := WebSession newOn: self.
	aSessionID notNil ifTrue: [session id: aSessionID].
	self site log: ' new session '.
	self addSession: session.
	session cookie: aBoolean.
	^session!

printString
	^'WebSessionManager on: ', self site name!

releaseApplicationState
	"release all application state of sessions"
	^self allSessions do: [:each | each releaseApplicationState].!

removeGuestSessions
	^self allGuestSessions do: [:each | 
		each parent == self 
			ifTrue: [each removeYourself] 
			ifFalse: [self removeSession: each] ]. "in which case?"!

removeNonactiveGuestSessions
	"all guest sessions inactive more than one hour"
	^self allNonactiveGuestSessions do: [:each | 
		each parent == self 
			ifTrue: [each removeYourself] 
			ifFalse: [self removeSession: each] ]. "in which case?"!

removeSession: aWebSession
	"remove from sessions"
	self site critical:
		[self sessions 
			removeKey: aWebSession id ifAbsent: [];
			removeKey: aWebSession secureId ifAbsent: [] ].!

sessions
	"dictionary of sessions by session id as the key. Not that session can have two ids, for ssl too!!"
	sessions isNil ifTrue: [self initSessions].
	^sessions!

site
	^site!

site: anAIDASite
	site := anAIDASite.! !
!WebSessionManager categoriesFor: #addSession:!adding-removing!public! !
!WebSessionManager categoriesFor: #allActiveSessions!accessing!public! !
!WebSessionManager categoriesFor: #allGuestSessions!accessing!public! !
!WebSessionManager categoriesFor: #allNonactiveGuestSessions!accessing!public! !
!WebSessionManager categoriesFor: #allSessions!accessing!public! !
!WebSessionManager categoriesFor: #bindSSLSessionFor:!private! !
!WebSessionManager categoriesFor: #checkAndCountReturningVisitor:!private! !
!WebSessionManager categoriesFor: #countNewVisitor!private! !
!WebSessionManager categoriesFor: #existSessionWithID:!public!testing! !
!WebSessionManager categoriesFor: #findAllSessionsWithUsername:!accessing!public! !
!WebSessionManager categoriesFor: #findOrCreateSessionFor:!adding-removing!public! !
!WebSessionManager categoriesFor: #findSessionWithID:!accessing!public! !
!WebSessionManager categoriesFor: #findSessionWithUsername:!accessing!public! !
!WebSessionManager categoriesFor: #hasSSLBinding:!private! !
!WebSessionManager categoriesFor: #initialize!initialize-release!public! !
!WebSessionManager categoriesFor: #initSessions!initialize-release!public! !
!WebSessionManager categoriesFor: #newSessionCookie:!private! !
!WebSessionManager categoriesFor: #newSessionCookie:id:!private! !
!WebSessionManager categoriesFor: #printString!private! !
!WebSessionManager categoriesFor: #releaseApplicationState!adding-removing!public! !
!WebSessionManager categoriesFor: #removeGuestSessions!adding-removing!public! !
!WebSessionManager categoriesFor: #removeNonactiveGuestSessions!adding-removing!public! !
!WebSessionManager categoriesFor: #removeSession:!adding-removing!public! !
!WebSessionManager categoriesFor: #sessions!private! !
!WebSessionManager categoriesFor: #site!accessing!public! !
!WebSessionManager categoriesFor: #site:!private! !

!WebSessionManager class methodsFor!

default
	^AIDASite default sessionManager!

newOn: aSite
	^super new 
		initialize; 
		site: aSite! !
!WebSessionManager class categoriesFor: #default!accessing!public! !
!WebSessionManager class categoriesFor: #newOn:!instance creation!public! !

WebStatistics guid: (GUID fromString: '{8702F3C3-D453-43B0-A828-F6AEB755AFE9}')!
WebStatistics comment: ''!
!WebStatistics categoriesForClass!Unclassified! !
!WebStatistics methodsFor!

addNewReferer: anUrlString

	"add new counter to referers dictionary"

	self referers 
		at: anUrlString
		put: WebCounter new.!

allRefererCounts
	"return a collection of all referers and their total counts, most counted first"
	| collection |
	collection := OrderedCollection new.
	self referers keysAndValuesDo: [:referer :counter |  
		collection add: (Array 
			with: referer
			with: counter total)].
	^SortedCollection
		withAll: collection
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].

"WebStatistics default allRefererCounts size"!

allRefererCountsToday
	"return a collection of today referers and their total counts, most counted first"
	| collection |
	collection := OrderedCollection new.
	self referers keysAndValuesDo: [:referer :counter |  
		collection add: (Array 
			with: referer
			with: counter today)].
	^SortedCollection
		withAll: (collection select: [:each | each value last > 0])
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].

"WebStatistics default allReferersAndCounts"!

allRefererCountsWeekly
	"return a collection of current week referers and their total counts, most counted first"
	| collection |
	collection := OrderedCollection new.
	self referers keysAndValuesDo: [:referer :counter |  
		collection add: (Array 
			with: referer
			with: counter weekly)].
	^SortedCollection
		withAll: (collection select: [:each | each value last > 0])
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].

"WebStatistics default allReferersAndCounts"!

allRefererCountsYesterday
	"return a collection of yesterday referers and their total counts, most counted first"
	| collection |
	collection := OrderedCollection new.
	self referers keysAndValuesDo: [:referer :counter |  
		collection add: (Array 
			with: referer
			with: counter yesterday)].
	^SortedCollection
		withAll: (collection select: [:each | each value last > 0])
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].

"WebStatistics default allReferersAndCounts"!

allReferersJustOneHit
	"return a collection of all referers with just one hit and older that one week"
	| collection secBefore7days |
	secBefore7days := SpTimestamp now asSeconds - (7 * 3600 * 24).
	collection := OrderedCollection new.
	self referers keysAndValuesDo: [:referer :counter |
		(counter total = 1 and: [secBefore7days >= counter started asSeconds ]) ifTrue:
			[collection add: referer] ].
	^collection

"WebStatistics default allReferersJustOneHit size"!

collectStatsFrom: aWebRequest
	| referer |
	referer := AIDASite convert: aWebRequest referer fromCodepage: #UTF8.
	(referer notNil and: [(self isLocalUrl: referer) not]) 
		ifTrue: [self countReferer: referer]!

countReferer: anUrlString
	| url |
	url := self prepareReferer: anUrlString.
	url isEmpty ifTrue: [^self].
	(self refererOnStopList: url) ifTrue: [^self].
	(self referers includesKey: url)
		ifFalse: [self addNewReferer: url].
	(self referers at: url) incCounter!

initReferers
	referers := Dictionary new.

"AIDASite default statistics initReferers"!

initRefererStopList
	refererStopList := Set new.
	refererStopList
		add: '[unknown origin]';
		add: 'bookmarks';
		add: 'http://lw2fd.hotmail.msn.com/cgi-bin/getmsg';
		add: 'http://mobitel.sux.nu/cgi-bin/tabla/showpost.pl'.
"AIDASite default statistics initRefererStopList"!

isLocalUrl: anUrlString
	"true, if this url points to page from this server"
	^self site uriPattern contains: [:siteIdentifier | 
		('http://', siteIdentifier host, '*') match: anUrlString].!

isNewReferer: anUrlString onDate: aDate
	"this referer is new if it occurs for a first time in last 7 days"
	| counter |
	counter := self refererCounterFor: anUrlString.
	^counter isFirstOnDate: aDate sinceDays: 7!

prepareReferer: anUrlString

	"ingnore all parameters in url"

	^(anUrlString copyUpTo: $?)!

refererCounterFor: anUrlString

	^self referers at: anUrlString ifAbsent: [^nil]!

refererOnStopList: anUrlString

	| |
	^self refererStopList includes: anUrlString!

referers
	referers isNil ifTrue: [self initReferers].
	^referers!

refererStopList
	refererStopList isNil ifTrue: [self initRefererStopList].
	^refererStopList!

removeReferer: anUrlString

	self referers removeKey: anUrlString ifAbsent: [^self].!

removeReferersJustOneHit
	"..and older that 7 days"
	self allReferersJustOneHit do: [:each | self referers removeKey: each]
	
"WebStatistics default removeReferersJustOneHit"!

removeReferersOnStopList

	self refererStopList do: [:referer |
		self removeReferer: referer]

"WebStatistics default  removeReferersOnStopList"!

site
	^site!

site: anAIDASite
	site := anAIDASite.! !
!WebStatistics categoriesFor: #addNewReferer:!private-referers!public! !
!WebStatistics categoriesFor: #allRefererCounts!public!referers! !
!WebStatistics categoriesFor: #allRefererCountsToday!public!referers! !
!WebStatistics categoriesFor: #allRefererCountsWeekly!public!referers! !
!WebStatistics categoriesFor: #allRefererCountsYesterday!public!referers! !
!WebStatistics categoriesFor: #allReferersJustOneHit!public!referers! !
!WebStatistics categoriesFor: #collectStatsFrom:!collecting!public! !
!WebStatistics categoriesFor: #countReferer:!private-referers!public! !
!WebStatistics categoriesFor: #initReferers!initialize-release!public! !
!WebStatistics categoriesFor: #initRefererStopList!initialize-release!public! !
!WebStatistics categoriesFor: #isLocalUrl:!private! !
!WebStatistics categoriesFor: #isNewReferer:onDate:!private-referers!public! !
!WebStatistics categoriesFor: #prepareReferer:!private-referers!public! !
!WebStatistics categoriesFor: #refererCounterFor:!private-referers!public! !
!WebStatistics categoriesFor: #refererOnStopList:!private-referers!public! !
!WebStatistics categoriesFor: #referers!public!referers! !
!WebStatistics categoriesFor: #refererStopList!public!referers! !
!WebStatistics categoriesFor: #removeReferer:!private-referers!public! !
!WebStatistics categoriesFor: #removeReferersJustOneHit!public!referers! !
!WebStatistics categoriesFor: #removeReferersOnStopList!private-referers!public! !
!WebStatistics categoriesFor: #site!accessing!public! !
!WebStatistics categoriesFor: #site:!private! !

!WebStatistics class methodsFor!

countersFromIISLogsIn: aDirectoryString

	"return a dictionary (url as key) of counters for urls in all IIS log files in specified directory"
	" WebStatistics countersFromIISLogsIn: 'h:\winnt\system32\logfiles\w3svc8'  "

	| logFiles urlCounters |
	logFiles := aDirectoryString asFilename directoryContents.
	logFiles := SortedCollection
		withAll: logFiles 	sortBlock: [:a :b | a < b].
	urlCounters := Dictionary new.
	logFiles do: [:logFile | 
		" self halt. "
		self countUrlsIn: (aDirectoryString, '\', logFile) to: urlCounters].
	^urlCounters!

countUrlsIn: aFileString to: anUrlDictionary

self parseFile: aFileString into: anUrlDictionary.!

dateFromFilename: aFilename

	^Date 
		newDay: (aFilename tail copyFrom: 7 to: 8) asInteger
		monthNumber:(aFilename tail copyFrom: 5 to: 6) asInteger
		year: ((aFilename tail copyFrom: 3 to: 4) asInteger + 2000)!

default

	^AIDASite default statistics!

newOn: anAIDASite
	^super new site: anAIDASite!

parseDatum: stringDatum 
	"pretvorimo datum iz formata LLLL-MM-DD v date format
	| tmp | 
	 tmp := DelimitedFile new. 
	Transcript show: (tmp parseDatum: '1999-12-11') printString ; cr  
	"

	| datumStream leto mesec dan |
	datumStream := (stringDatum copyReplaceAll: '-' with: ' ') readStream.
	leto := (self  parseWords: datumStream) asNumber.
	mesec := (self  parseWords: datumStream) asNumber.
	dan := (self  parseWords: datumStream) asNumber.
	^Date newDay: dan
		monthNumber: mesec
		year: leto!

parseFile: aFile 
	"
 	Trenutno opusceno, osnova za parseFile: into:
	WebStatistics parseFile: 'h:\winnt\system32\logfiles\w3svc8\ex990506.log' 
	"

	| logFile stream cr besedeVrstice vrstica stevecBesed |
	cr := Character cr.	" self halt. "
	logFile := aFile asFilename.
	stream := logFile readStream.
	[stream atEnd] whileFalse: 
			[besedeVrstice := Array new: 15.
			stevecBesed := 1.
			vrstica := (stream throughAll: (String with: cr)) readStream.
			[vrstica atEnd] whileFalse: 
					[besedeVrstice at: stevecBesed put: vrstica parseWordsIntoArray.
					stevecBesed := stevecBesed + 1].
			vrstica close].
	stream close!

parseFile: aFile into: URLCountDictionary 
	| stream besedeVrstice vrstica stevecBesed datum |
	datum := Date today.
	stream := aFile asFilename readStream.
	[stream atEnd] whileFalse: 
		[besedeVrstice := Array new: 15.
		stevecBesed := 2.
		vrstica := (stream throughAll: (String with: Character cr)) readStream.
		[vrstica atEnd] whileFalse: 
			[besedeVrstice at: stevecBesed put: (self parseWords: vrstica) .
			stevecBesed := stevecBesed + 1].
 		datum:= self analyzeAndStoreLine: besedeVrstice 
			into: URLCountDictionary forDate:datum.
		vrstica close.].
	stream close

	" test lines : 
	Xx := Dictionary new.
	WebStatistics parseFile: 'h:\winnt\system32\logfiles\w3svc8\ex990506.log' into: Xx.
	Transcript show: Xx printString
	"!

parseWords: inputStream 
	"Answer the contents of the receiver, up to the next separator  character."

	| aStream |
	aStream := (String new: 200) writeStream.
	inputStream skipSeparators.
	inputStream class endOfStreamSignal handle: [:ex | ex return]
		do: 
			[
			[| char |
			char := inputStream next.
			char isSeparator ifTrue: [^aStream contents] ifFalse: [aStream nextPut: char]]
					repeat].
	^aStream contents! !
!WebStatistics class categoriesFor: #countersFromIISLogsIn:!log analysis!public! !
!WebStatistics class categoriesFor: #countUrlsIn:to:!log analysis!public! !
!WebStatistics class categoriesFor: #dateFromFilename:!log analysis!public! !
!WebStatistics class categoriesFor: #default!accessing!public! !
!WebStatistics class categoriesFor: #newOn:!instance creation!public! !
!WebStatistics class categoriesFor: #parseDatum:!log analysis!public! !
!WebStatistics class categoriesFor: #parseFile:!log analysis!public! !
!WebStatistics class categoriesFor: #parseFile:into:!log analysis!public! !
!WebStatistics class categoriesFor: #parseWords:!log analysis!public! !

WebStyle guid: (GUID fromString: '{991F42AF-7AA1-46A2-A06B-0D797A03E0DE}')!
WebStyle comment: ''!
!WebStyle categoriesForClass!Unclassified! !
!WebStyle methodsFor!

addHelpText
	^'Add help page'!

addPrintSuperStyles
	"if false, don't add cssPrint methods from superclasses"
	^true!

addSuperStyles
	"if false, don't add css methods from superclasses"
	^true!

adjustCSSLink: aString
	" '../images/arrow_left.gif' to '/img/arrowLeftGif.gif' "
	| in name extension |
	in := aString readStream.
	[in atEnd] whileFalse: [name := in upTo: $/]. "to find filename only"
	extension := name readStream upTo: $. ; upToEnd.
	name := self adjustImageName: name.
	^'/img/', name, '.', extension.!

adjustImageName: aFilenameString
	"left_arrow.gif = leftArrowGif"
	| in out |
	in := aFilenameString readStream. out := WriteStream on: String new.
	in peek isDigit ifTrue: [out nextPut: $a]. "method cannot start with digit!!"
	[in atEnd] whileFalse: 
		[(#($- $_ $. ) includes:  in peek) 
			ifTrue: [in next "skip". out nextPut: in next asUppercase] 
			ifFalse: [out nextPut: in next] ].
	^out contents!

adjustLinksInCSSMethod: aMethodSymbol
	"external image links in CSS are changed to format, eg. for arrow.gif  '/img/arrowGif.gif' "
	"this method is then recompiled back in 'styles-screen' !! "
	"WebStyle new adjustLinksInCSSMethod: #css1Body"
	| method in out chunk link dd |
	method := self class compiledMethodAt: aMethodSymbol. method := method getSource asString.
	in := method readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[chunk := in upToAll: 'url('. in atEnd not ifTrue: [in skip: 4]. link := in upTo: $). 
		dd := (link includes: $") ifTrue: [link := link copyWithout: $". '"'] ifFalse: [''].
		out nextPutAll: chunk. 
		link notEmpty ifTrue: 
			[link := self adjustCSSLink: link.  out nextPutAll: 'url(', dd, link, dd, ')'] ].
	out contents = method ifFalse:
		[self class compile: out contents classified: 'styles-screen'].
	^out contents!

allCssPrintMethods
	"WebStyle new allCssPrintMethods"
	| selectors methods |
	self addPrintSuperStyles 
		ifTrue: [selectors := self class allSelectors] "From superclasses too"
		ifFalse: [selectors := self class selectors].
	methods := selectors select: [:each | 'cssPrint*' match:each asString].
	^SortedCollection withAll: methods sortBlock: [:a :b | a < b]!

allCssScreenMethods
	"for screen styles, all css* except cssPrint* , sorted alphabeticaly"
	"WebStyle new allCssScreenMethods"
	| selectors methods print |
	self addSuperStyles 
		ifTrue: [selectors := self class allSelectors] "From superclasses too"
		ifFalse: [selectors := self class selectors].
	methods := selectors select: [:each | 'css*' match:each asString].
	print := self allCssPrintMethods asSet.
	^SortedCollection 
		withAll: (methods reject: [:each | print includes: each])
		sortBlock: [:a :b | a < b]!

allJavascriptMethods
	"for javascript, all js* sorted alphabeticaly (sort is not realy needed, just for convenience)"
	"WebStyle new allJavascriptMethods"
	| methods |
	methods := self class allSelectors select: [:each | 'js*' match:each asString].
	^SortedCollection withAll: methods sortBlock: [:a :b | a < b]!

app
	"try to find a first sender up in calling stack, who is  WebApplication"
	^self firstAppFromStack!

calendarCSS
	"/jscalendar/calendar.css"
	^'
/*calendar-brown.css*/
/* The main calendar widget.  DIV containing a table. */

div.calendar { position: relative; }

.calendar, .calendar table {
  border: 1px solid #655;
  font-size: 11px;
  color: #000;
  cursor: default;
  background: #ffd;
  font-family: tahoma,verdana,sans-serif;
}

/* Header part -- contains navigation buttons and day names. */

.calendar .button { /* "<<", "<", ">", ">>" buttons have this class */
  text-align: center;    /* They are the navigation buttons */
  padding: 2px;          /* Make the buttons seem like they are pressing */
}

.calendar .nav {
/*  background: #edc url(menuarrow.gif) no-repeat 100% 100%; */
  background: #edc no-repeat 100% 100%;
}

.calendar thead .title { /* This holds the current "month, year" */
  font-weight: bold;      /* Pressing it will take you to the current date */
  text-align: center;
  background: #654;
  color: #fed;
  padding: 2px;
}

.calendar thead .headrow { /* Row <TR> containing navigation buttons */
  background: #edc;
  color: #000;
}

.calendar thead .name { /* Cells <TD> containing the day names */
  border-bottom: 1px solid #655;
  padding: 2px;
  text-align: center;
  color: #000;
}

.calendar thead .weekend { /* How a weekend day name shows in header */
  color: #f00;
}

.calendar thead .hilite { /* How do the buttons in header appear when hover */
  background-color: #faa;
  color: #000;
  border: 1px solid #f40;
  padding: 1px;
}

.calendar thead .active { /* Active (pressed) buttons in header */
  background-color: #c77;
  padding: 2px 0px 0px 2px;
}

.calendar thead .daynames { /* Row <TR> containing the day names */
  background: #fed;
}

/* The body part -- contains all the days in month. */

.calendar tbody .day { /* Cells <TD> containing month days dates */
  width: 2em;
  text-align: right;
  padding: 2px 4px 2px 2px;
}
.calendar tbody .day.othermonth {
  font-size: 80%;
  color: #bbb;
}
.calendar tbody .day.othermonth.oweekend {
  color: #fbb;
}

.calendar table .wn {
  padding: 2px 3px 2px 2px;
  border-right: 1px solid #000;
  background: #fed;
}

.calendar tbody .rowhilite td {
  background: #ddf;
}

.calendar tbody .rowhilite td.wn {
  background: #efe;
}

.calendar tbody td.hilite { /* Hovered cells <TD> */
  background: #ffe;
  padding: 1px 3px 1px 1px;
  border: 1px solid #bbb;
}

.calendar tbody td.active { /* Active (pressed) cells <TD> */
  background: #ddc;
  padding: 2px 2px 0px 2px;
}

.calendar tbody td.selected { /* Cell showing today date */
  font-weight: bold;
  border: 1px solid #000;
  padding: 1px 3px 1px 1px;
  background: #fea;
}

.calendar tbody td.weekend { /* Cells showing weekend days */
  color: #f00;
}

.calendar tbody td.today { font-weight: bold; }

.calendar tbody .disabled { color: #999; }

.calendar tbody .emptycell { /* Empty cells (the best is to hide them) */
  visibility: hidden;
}

.calendar tbody .emptyrow { /* Empty row (some months need less than 6 rows) */
  display: none;
}

/* The footer part -- status bar and "Close" button */

.calendar tfoot .footrow { /* The <TR> in footer (only one right now) */
  text-align: center;
  background: #988;
  color: #000;
}

.calendar tfoot .ttip { /* Tooltip (status bar) cell <TD> */
  border-top: 1px solid #655;
  background: #dcb;
  color: #840;
}

.calendar tfoot .hilite { /* Hover style for buttons in footer */
  background: #faa;
  border: 1px solid #f40;
  padding: 1px;
}

.calendar tfoot .active { /* Active (pressed) style for buttons in footer */
  background: #c77;
  padding: 2px 0px 0px 2px;
}

/* Combo boxes (menus that display months/years for direct selection) */

.calendar .combo {
  position: absolute;
  display: none;
  top: 0px;
  left: 0px;
  width: 4em;
  cursor: default;
  border: 1px solid #655;
  background: #ffe;
  color: #000;
  font-size: 90%;
  z-index: 100;
}

.calendar .combo .label,
.calendar .combo .label-IEfix {
  text-align: center;
  padding: 1px;
}

.calendar .combo .label-IEfix {
  width: 4em;
}

.calendar .combo .hilite {
  background: #fc8;
}

.calendar .combo .active {
  border-top: 1px solid #a64;
  border-bottom: 1px solid #a64;
  background: #fee;
  font-weight: bold;
}

.calendar td.time {
  border-top: 1px solid #a88;
  padding: 1px 0px;
  text-align: center;
  background-color: #fed;
}

.calendar td.time .hour,
.calendar td.time .minute,
.calendar td.time .ampm {
  padding: 0px 3px 0px 4px;
  border: 1px solid #988;
  font-weight: bold;
  background-color: #fff;
}

.calendar td.time .ampm {
  text-align: center;
}

.calendar td.time .colon {
  padding: 0px 2px 0px 3px;
  font-weight: bold;
}

.calendar td.time span.hilite {
  border-color: #000;
  background-color: #866;
  color: #fff;
}

.calendar td.time span.active {
  border-color: #f00;
  background-color: #000;
  color: #0f0;
}
'!

calendarCSSResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarCSSResource"
	^self resources at: #jsCalendarCSS ifAbsentPut:
		[WebMethodResource 
			fromMethod: #calendarCSS on: self 
			contentType: 'text/css' preferedUrl: '/jscalendar/calendar.css' site: self site].!

calendarJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarJavascript"
	^'
/*  Copyright Mihai Bazon, 2002-2005  |  www.bazon.net/mishoo
 * -----------------------------------------------------------
 *
 * The DHTML Calendar, version 1.0 "It is happening again"
 *
 * Details and latest version at:
 * www.dynarch.com/projects/calendar
 *
 * This script is developed by Dynarch.com.  Visit us at www.dynarch.com.
 *
 * This script is distributed under the GNU Lesser General Public License.
 * Read the entire license text here: http://www.gnu.org/licenses/lgpl.html
 */

// $Id: calendar.js,v 1.51 2005/03/07 16:44:31 mishoo Exp $

/** The Calendar object constructor. */
Calendar = function (firstDayOfWeek, dateStr, onSelected, onClose) {
	// member variables
	this.activeDiv = null;
	this.currentDateEl = null;
	this.getDateStatus = null;
	this.getDateToolTip = null;
	this.getDateText = null;
	this.timeout = null;
	this.onSelected = onSelected || null;
	this.onClose = onClose || null;
	this.dragging = false;
	this.hidden = false;
	this.minYear = 1970;
	this.maxYear = 2050;
	this.dateFormat = Calendar._TT["DEF_DATE_FORMAT"];
	this.ttDateFormat = Calendar._TT["TT_DATE_FORMAT"];
	this.isPopup = true;
	this.weekNumbers = true;
	this.firstDayOfWeek = typeof firstDayOfWeek == "number" ? firstDayOfWeek : Calendar._FD; // 0 for Sunday, 1 for Monday, etc.
	this.showsOtherMonths = false;
	this.dateStr = dateStr;
	this.ar_days = null;
	this.showsTime = false;
	this.time24 = true;
	this.yearStep = 2;
	this.hiliteToday = true;
	this.multiple = null;
	// HTML elements
	this.table = null;
	this.element = null;
	this.tbody = null;
	this.firstdayname = null;
	// Combo boxes
	this.monthsCombo = null;
	this.yearsCombo = null;
	this.hilitedMonth = null;
	this.activeMonth = null;
	this.hilitedYear = null;
	this.activeYear = null;
	// Information
	this.dateClicked = false;

	// one-time initializations
	if (typeof Calendar._SDN == "undefined") {
		// table of short day names
		if (typeof Calendar._SDN_len == "undefined")
			Calendar._SDN_len = 3;
		var ar = new Array();
		for (var i = 8; i > 0;) {
			ar[--i] = Calendar._DN[i].substr(0, Calendar._SDN_len);
		}
		Calendar._SDN = ar;
		// table of short month names
		if (typeof Calendar._SMN_len == "undefined")
			Calendar._SMN_len = 3;
		ar = new Array();
		for (var i = 12; i > 0;) {
			ar[--i] = Calendar._MN[i].substr(0, Calendar._SMN_len);
		}
		Calendar._SMN = ar;
	}
};

// ** constants

/// "static", needed for event handlers.
Calendar._C = null;

/// detect a special case of "web browser"
Calendar.is_ie = ( /msie/i.test(navigator.userAgent) &&
		   !!/opera/i.test(navigator.userAgent) );

Calendar.is_ie5 = ( Calendar.is_ie && /msie 5\.0/i.test(navigator.userAgent) );

/// detect Opera browser
Calendar.is_opera = /opera/i.test(navigator.userAgent);

/// detect KHTML-based browsers
Calendar.is_khtml = /Konqueror|Safari|KHTML/i.test(navigator.userAgent);

// BEGIN: UTILITY FUNCTIONS; beware that these might be moved into a separate
//        library, at some point.

Calendar.getAbsolutePos = function(el) {
	var SL = 0, ST = 0;
	var is_div = /^div$/i.test(el.tagName);
	if (is_div && el.scrollLeft)
		SL = el.scrollLeft;
	if (is_div && el.scrollTop)
		ST = el.scrollTop;
	var r = { x: el.offsetLeft - SL, y: el.offsetTop - ST };
	if (el.offsetParent) {
		var tmp = this.getAbsolutePos(el.offsetParent);
		r.x += tmp.x;
		r.y += tmp.y;
	}
	return r;
};

Calendar.isRelated = function (el, evt) {
	var related = evt.relatedTarget;
	if (!!related) {
		var type = evt.type;
		if (type == "mouseover") {
			related = evt.fromElement;
		} else if (type == "mouseout") {
			related = evt.toElement;
		}
	}
	while (related) {
		if (related == el) {
			return true;
		}
		related = related.parentNode;
	}
	return false;
};

Calendar.removeClass = function(el, className) {
	if (!!(el && el.className)) {
		return;
	}
	var cls = el.className.split(" ");
	var ar = new Array();
	for (var i = cls.length; i > 0;) {
		if (cls[--i] !!= className) {
			ar[ar.length] = cls[i];
		}
	}
	el.className = ar.join(" ");
};

Calendar.addClass = function(el, className) {
	Calendar.removeClass(el, className);
	el.className += " " + className;
};

// FIXME: the following 2 functions totally suck, are useless and should be replaced immediately.
Calendar.getElement = function(ev) {
	var f = Calendar.is_ie ? window.event.srcElement : ev.currentTarget;
	while (f.nodeType !!= 1 || /^div$/i.test(f.tagName))
		f = f.parentNode;
	return f;
};

Calendar.getTargetElement = function(ev) {
	var f = Calendar.is_ie ? window.event.srcElement : ev.target;
	while (f.nodeType !!= 1)
		f = f.parentNode;
	return f;
};

Calendar.stopEvent = function(ev) {
	ev || (ev = window.event);
	if (Calendar.is_ie) {
		ev.cancelBubble = true;
		ev.returnValue = false;
	} else {
		ev.preventDefault();
		ev.stopPropagation();
	}
	return false;
};

Calendar.addEvent = function(el, evname, func) {
	if (el.attachEvent) { // IE
		el.attachEvent("on" + evname, func);
	} else if (el.addEventListener) { // Gecko / W3C
		el.addEventListener(evname, func, true);
	} else {
		el["on" + evname] = func;
	}
};

Calendar.removeEvent = function(el, evname, func) {
	if (el.detachEvent) { // IE
		el.detachEvent("on" + evname, func);
	} else if (el.removeEventListener) { // Gecko / W3C
		el.removeEventListener(evname, func, true);
	} else {
		el["on" + evname] = null;
	}
};

Calendar.createElement = function(type, parent) {
	var el = null;
	if (document.createElementNS) {
		// use the XHTML namespace; IE won''t normally get here unless
		// _they_ "fix" the DOM2 implementation.
		el = document.createElementNS("http://www.w3.org/1999/xhtml", type);
	} else {
		el = document.createElement(type);
	}
	if (typeof parent !!= "undefined") {
		parent.appendChild(el);
	}
	return el;
};

// END: UTILITY FUNCTIONS

// BEGIN: CALENDAR STATIC FUNCTIONS

/** Internal -- adds a set of events to make some element behave like a button. */
Calendar._add_evs = function(el) {
	with (Calendar) {
		addEvent(el, "mouseover", dayMouseOver);
		addEvent(el, "mousedown", dayMouseDown);
		addEvent(el, "mouseout", dayMouseOut);
		if (is_ie) {
			addEvent(el, "dblclick", dayMouseDblClick);
			el.setAttribute("unselectable", true);
		}
	}
};

Calendar.findMonth = function(el) {
	if (typeof el.month !!= "undefined") {
		return el;
	} else if (typeof el.parentNode.month !!= "undefined") {
		return el.parentNode;
	}
	return null;
};

Calendar.findYear = function(el) {
	if (typeof el.year !!= "undefined") {
		return el;
	} else if (typeof el.parentNode.year !!= "undefined") {
		return el.parentNode;
	}
	return null;
};

Calendar.showMonthsCombo = function () {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	var cal = cal;
	var cd = cal.activeDiv;
	var mc = cal.monthsCombo;
	if (cal.hilitedMonth) {
		Calendar.removeClass(cal.hilitedMonth, "hilite");
	}
	if (cal.activeMonth) {
		Calendar.removeClass(cal.activeMonth, "active");
	}
	var mon = cal.monthsCombo.getElementsByTagName("div")[cal.date.getMonth()];
	Calendar.addClass(mon, "active");
	cal.activeMonth = mon;
	var s = mc.style;
	s.display = "block";
	if (cd.navtype < 0)
		s.left = cd.offsetLeft + "px";
	else {
		var mcw = mc.offsetWidth;
		if (typeof mcw == "undefined")
			// Konqueror brain-dead techniques
			mcw = 50;
		s.left = (cd.offsetLeft + cd.offsetWidth - mcw) + "px";
	}
	s.top = (cd.offsetTop + cd.offsetHeight) + "px";
};

Calendar.showYearsCombo = function (fwd) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	var cal = cal;
	var cd = cal.activeDiv;
	var yc = cal.yearsCombo;
	if (cal.hilitedYear) {
		Calendar.removeClass(cal.hilitedYear, "hilite");
	}
	if (cal.activeYear) {
		Calendar.removeClass(cal.activeYear, "active");
	}
	cal.activeYear = null;
	var Y = cal.date.getFullYear() + (fwd ? 1 : -1);
	var yr = yc.firstChild;
	var show = false;
	for (var i = 12; i > 0; --i) {
		if (Y >= cal.minYear && Y <= cal.maxYear) {
			yr.innerHTML = Y;
			yr.year = Y;
			yr.style.display = "block";
			show = true;
		} else {
			yr.style.display = "none";
		}
		yr = yr.nextSibling;
		Y += fwd ? cal.yearStep : -cal.yearStep;
	}
	if (show) {
		var s = yc.style;
		s.display = "block";
		if (cd.navtype < 0)
			s.left = cd.offsetLeft + "px";
		else {
			var ycw = yc.offsetWidth;
			if (typeof ycw == "undefined")
				// Konqueror brain-dead techniques
				ycw = 50;
			s.left = (cd.offsetLeft + cd.offsetWidth - ycw) + "px";
		}
		s.top = (cd.offsetTop + cd.offsetHeight) + "px";
	}
};

// event handlers

Calendar.tableMouseUp = function(ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	if (cal.timeout) {
		clearTimeout(cal.timeout);
	}
	var el = cal.activeDiv;
	if (!!el) {
		return false;
	}
	var target = Calendar.getTargetElement(ev);
	ev || (ev = window.event);
	Calendar.removeClass(el, "active");
	if (target == el || target.parentNode == el) {
		Calendar.cellClick(el, ev);
	}
	var mon = Calendar.findMonth(target);
	var date = null;
	if (mon) {
		date = new Date(cal.date);
		if (mon.month !!= date.getMonth()) {
			date.setMonth(mon.month);
			cal.setDate(date);
			cal.dateClicked = false;
			cal.callHandler();
		}
	} else {
		var year = Calendar.findYear(target);
		if (year) {
			date = new Date(cal.date);
			if (year.year !!= date.getFullYear()) {
				date.setFullYear(year.year);
				cal.setDate(date);
				cal.dateClicked = false;
				cal.callHandler();
			}
		}
	}
	with (Calendar) {
		removeEvent(document, "mouseup", tableMouseUp);
		removeEvent(document, "mouseover", tableMouseOver);
		removeEvent(document, "mousemove", tableMouseOver);
		cal._hideCombos();
		_C = null;
		return stopEvent(ev);
	}
};

Calendar.tableMouseOver = function (ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return;
	}
	var el = cal.activeDiv;
	var target = Calendar.getTargetElement(ev);
	if (target == el || target.parentNode == el) {
		Calendar.addClass(el, "hilite active");
		Calendar.addClass(el.parentNode, "rowhilite");
	} else {
		if (typeof el.navtype == "undefined" || (el.navtype !!= 50 && (el.navtype == 0 || Math.abs(el.navtype) > 2)))
			Calendar.removeClass(el, "active");
		Calendar.removeClass(el, "hilite");
		Calendar.removeClass(el.parentNode, "rowhilite");
	}
	ev || (ev = window.event);
	if (el.navtype == 50 && target !!= el) {
		var pos = Calendar.getAbsolutePos(el);
		var w = el.offsetWidth;
		var x = ev.clientX;
		var dx;
		var decrease = true;
		if (x > pos.x + w) {
			dx = x - pos.x - w;
			decrease = false;
		} else
			dx = pos.x - x;

		if (dx < 0) dx = 0;
		var range = el._range;
		var current = el._current;
		var count = Math.floor(dx / 10) % range.length;
		for (var i = range.length; --i >= 0;)
			if (range[i] == current)
				break;
		while (count-- > 0)
			if (decrease) {
				if (--i < 0)
					i = range.length - 1;
			} else if ( ++i >= range.length )
				i = 0;
		var newval = range[i];
		el.innerHTML = newval;

		cal.onUpdateTime();
	}
	var mon = Calendar.findMonth(target);
	if (mon) {
		if (mon.month !!= cal.date.getMonth()) {
			if (cal.hilitedMonth) {
				Calendar.removeClass(cal.hilitedMonth, "hilite");
			}
			Calendar.addClass(mon, "hilite");
			cal.hilitedMonth = mon;
		} else if (cal.hilitedMonth) {
			Calendar.removeClass(cal.hilitedMonth, "hilite");
		}
	} else {
		if (cal.hilitedMonth) {
			Calendar.removeClass(cal.hilitedMonth, "hilite");
		}
		var year = Calendar.findYear(target);
		if (year) {
			if (year.year !!= cal.date.getFullYear()) {
				if (cal.hilitedYear) {
					Calendar.removeClass(cal.hilitedYear, "hilite");
				}
				Calendar.addClass(year, "hilite");
				cal.hilitedYear = year;
			} else if (cal.hilitedYear) {
				Calendar.removeClass(cal.hilitedYear, "hilite");
			}
		} else if (cal.hilitedYear) {
			Calendar.removeClass(cal.hilitedYear, "hilite");
		}
	}
	return Calendar.stopEvent(ev);
};

Calendar.tableMouseDown = function (ev) {
	if (Calendar.getTargetElement(ev) == Calendar.getElement(ev)) {
		return Calendar.stopEvent(ev);
	}
};

Calendar.calDragIt = function (ev) {
	var cal = Calendar._C;
	if (!!(cal && cal.dragging)) {
		return false;
	}
	var posX;
	var posY;
	if (Calendar.is_ie) {
		posY = window.event.clientY + document.body.scrollTop;
		posX = window.event.clientX + document.body.scrollLeft;
	} else {
		posX = ev.pageX;
		posY = ev.pageY;
	}
	cal.hideShowCovered();
	var st = cal.element.style;
	st.left = (posX - cal.xOffs) + "px";
	st.top = (posY - cal.yOffs) + "px";
	return Calendar.stopEvent(ev);
};

Calendar.calDragEnd = function (ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	cal.dragging = false;
	with (Calendar) {
		removeEvent(document, "mousemove", calDragIt);
		removeEvent(document, "mouseup", calDragEnd);
		tableMouseUp(ev);
	}
	cal.hideShowCovered();
};

Calendar.dayMouseDown = function(ev) {
	var el = Calendar.getElement(ev);
	if (el.disabled) {
		return false;
	}
	var cal = el.calendar;
	cal.activeDiv = el;
	Calendar._C = cal;
	if (el.navtype !!= 300) with (Calendar) {
		if (el.navtype == 50) {
			el._current = el.innerHTML;
			addEvent(document, "mousemove", tableMouseOver);
		} else
			addEvent(document, Calendar.is_ie5 ? "mousemove" : "mouseover", tableMouseOver);
		addClass(el, "hilite active");
		addEvent(document, "mouseup", tableMouseUp);
	} else if (cal.isPopup) {
		cal._dragStart(ev);
	}
	if (el.navtype == -1 || el.navtype == 1) {
		if (cal.timeout) clearTimeout(cal.timeout);
		cal.timeout = setTimeout("Calendar.showMonthsCombo()", 250);
	} else if (el.navtype == -2 || el.navtype == 2) {
		if (cal.timeout) clearTimeout(cal.timeout);
		cal.timeout = setTimeout((el.navtype > 0) ? "Calendar.showYearsCombo(true)" : "Calendar.showYearsCombo(false)", 250);
	} else {
		cal.timeout = null;
	}
	return Calendar.stopEvent(ev);
};

Calendar.dayMouseDblClick = function(ev) {
	Calendar.cellClick(Calendar.getElement(ev), ev || window.event);
	if (Calendar.is_ie) {
		document.selection.empty();
	}
};

Calendar.dayMouseOver = function(ev) {
	var el = Calendar.getElement(ev);
	if (Calendar.isRelated(el, ev) || Calendar._C || el.disabled) {
		return false;
	}
	if (el.ttip) {
		if (el.ttip.substr(0, 1) == "_") {
			el.ttip = el.caldate.print(el.calendar.ttDateFormat) + el.ttip.substr(1);
		}
		el.calendar.tooltips.innerHTML = el.ttip;
	}
	if (el.navtype !!= 300) {
		Calendar.addClass(el, "hilite");
		if (el.caldate) {
			Calendar.addClass(el.parentNode, "rowhilite");
		}
	}
	return Calendar.stopEvent(ev);
};

Calendar.dayMouseOut = function(ev) {
	with (Calendar) {
		var el = getElement(ev);
		if (isRelated(el, ev) || _C || el.disabled)
			return false;
		removeClass(el, "hilite");
		if (el.caldate)
			removeClass(el.parentNode, "rowhilite");
		if (el.calendar)
			el.calendar.tooltips.innerHTML = _TT["SEL_DATE"];
		return stopEvent(ev);
	}
};

/**
 *  A generic "click" handler :) handles all types of buttons defined in this
 *  calendar.
 */
Calendar.cellClick = function(el, ev) {
	var cal = el.calendar;
	var closing = false;
	var newdate = false;
	var date = null;
	if (typeof el.navtype == "undefined") {
		if (cal.currentDateEl) {
			Calendar.removeClass(cal.currentDateEl, "selected");
			Calendar.addClass(el, "selected");
			closing = (cal.currentDateEl == el);
			if (!!closing) {
				cal.currentDateEl = el;
			}
		}
		cal.date.setDateOnly(el.caldate);
		date = cal.date;
		var other_month = !!(cal.dateClicked = !!el.otherMonth);
		if (!!other_month && !!cal.currentDateEl)
			cal._toggleMultipleDate(new Date(date));
		else
			newdate = !!el.disabled;
		// a date was clicked
		if (other_month)
			cal._init(cal.firstDayOfWeek, date);
	} else {
		if (el.navtype == 200) {
			Calendar.removeClass(el, "hilite");
			cal.callCloseHandler();
			return;
		}
		date = new Date(cal.date);
		if (el.navtype == 0)
			date.setDateOnly(new Date()); // TODAY
		// unless "today" was clicked, we assume no date was clicked so
		// the selected handler will know not to close the calenar when
		// in single-click mode.
		// cal.dateClicked = (el.navtype == 0);
		cal.dateClicked = false;
		var year = date.getFullYear();
		var mon = date.getMonth();
		function setMonth(m) {
			var day = date.getDate();
			var max = date.getMonthDays(m);
			if (day > max) {
				date.setDate(max);
			}
			date.setMonth(m);
		};
		switch (el.navtype) {
		    case 400:
			Calendar.removeClass(el, "hilite");
			var text = Calendar._TT["ABOUT"];
			if (typeof text !!= "undefined") {
				text += cal.showsTime ? Calendar._TT["ABOUT_TIME"] : "";
			} else {
				// FIXME: this should be removed as soon as lang files get updated!!
				text = "Help and about box text is not translated into this language.\n" +
					"If you know this language and you feel generous please update\n" +
					"the corresponding file in \"lang\" subdir to match calendar-en.js\n" +
					"and send it back to <mihai_bazon@yahoo.com> to get it into the distribution  ;-)\n\n" +
					"Thank you!!\n" +
					"http://dynarch.com/mishoo/calendar.epl\n";
			}
			alert(text);
			return;
		    case -2:
			if (year > cal.minYear) {
				date.setFullYear(year - 1);
			}
			break;
		    case -1:
			if (mon > 0) {
				setMonth(mon - 1);
			} else if (year-- > cal.minYear) {
				date.setFullYear(year);
				setMonth(11);
			}
			break;
		    case 1:
			if (mon < 11) {
				setMonth(mon + 1);
			} else if (year < cal.maxYear) {
				date.setFullYear(year + 1);
				setMonth(0);
			}
			break;
		    case 2:
			if (year < cal.maxYear) {
				date.setFullYear(year + 1);
			}
			break;
		    case 100:
			cal.setFirstDayOfWeek(el.fdow);
			return;
		    case 50:
			var range = el._range;
			var current = el.innerHTML;
			for (var i = range.length; --i >= 0;)
				if (range[i] == current)
					break;
			if (ev && ev.shiftKey) {
				if (--i < 0)
					i = range.length - 1;
			} else if ( ++i >= range.length )
				i = 0;
			var newval = range[i];
			el.innerHTML = newval;
			cal.onUpdateTime();
			return;
		    case 0:
			// TODAY will bring us here
			if ((typeof cal.getDateStatus == "function") &&
			    cal.getDateStatus(date, date.getFullYear(), date.getMonth(), date.getDate())) {
				return false;
			}
			break;
		}
		if (!!date.equalsTo(cal.date)) {
			cal.setDate(date);
			newdate = true;
		} else if (el.navtype == 0)
			newdate = closing = true;
	}
	if (newdate) {
		ev && cal.callHandler();
	}
	if (closing) {
		Calendar.removeClass(el, "hilite");
		ev && cal.callCloseHandler();
	}
};

// END: CALENDAR STATIC FUNCTIONS

// BEGIN: CALENDAR OBJECT FUNCTIONS

/**
 *  This function creates the calendar inside the given parent.  If _par is
 *  null than it creates a popup calendar inside the BODY element.  If _par is
 *  an element, be it BODY, then it creates a non-popup calendar (still
 *  hidden).  Some properties need to be set before calling this function.
 */
Calendar.prototype.create = function (_par) {
	var parent = null;
	if (!! _par) {
		// default parent is the document body, in which case we create
		// a popup calendar.
		parent = document.getElementsByTagName("body")[0];
		this.isPopup = true;
	} else {
		parent = _par;
		this.isPopup = false;
	}
	this.date = this.dateStr ? new Date(this.dateStr) : new Date();

	var table = Calendar.createElement("table");
	this.table = table;
	table.cellSpacing = 0;
	table.cellPadding = 0;
	table.calendar = this;
	Calendar.addEvent(table, "mousedown", Calendar.tableMouseDown);

	var div = Calendar.createElement("div");
	this.element = div;
	div.className = "calendar";
	if (this.isPopup) {
		div.style.position = "absolute";
		div.style.display = "none";
	}
	div.appendChild(table);

	var thead = Calendar.createElement("thead", table);
	var cell = null;
	var row = null;

	var cal = this;
	var hh = function (text, cs, navtype) {
		cell = Calendar.createElement("td", row);
		cell.colSpan = cs;
		cell.className = "button";
		if (navtype !!= 0 && Math.abs(navtype) <= 2)
			cell.className += " nav";
		Calendar._add_evs(cell);
		cell.calendar = cal;
		cell.navtype = navtype;
		cell.innerHTML = "<div unselectable=''on''>" + text + "</div>";
		return cell;
	};

	row = Calendar.createElement("tr", thead);
	var title_length = 6;
	(this.isPopup) && --title_length;
	(this.weekNumbers) && ++title_length;

	hh("?", 1, 400).ttip = Calendar._TT["INFO"];
	this.title = hh("", title_length, 300);
	this.title.className = "title";
	if (this.isPopup) {
		this.title.ttip = Calendar._TT["DRAG_TO_MOVE"];
		this.title.style.cursor = "move";
		hh("&#x00d7;", 1, 200).ttip = Calendar._TT["CLOSE"];
	}

	row = Calendar.createElement("tr", thead);
	row.className = "headrow";

	this._nav_py = hh("&#x00ab;", 1, -2);
	this._nav_py.ttip = Calendar._TT["PREV_YEAR"];

	this._nav_pm = hh("&#x2039;", 1, -1);
	this._nav_pm.ttip = Calendar._TT["PREV_MONTH"];

	this._nav_now = hh(Calendar._TT["TODAY"], this.weekNumbers ? 4 : 3, 0);
	this._nav_now.ttip = Calendar._TT["GO_TODAY"];

	this._nav_nm = hh("&#x203a;", 1, 1);
	this._nav_nm.ttip = Calendar._TT["NEXT_MONTH"];

	this._nav_ny = hh("&#x00bb;", 1, 2);
	this._nav_ny.ttip = Calendar._TT["NEXT_YEAR"];

	// day names
	row = Calendar.createElement("tr", thead);
	row.className = "daynames";
	if (this.weekNumbers) {
		cell = Calendar.createElement("td", row);
		cell.className = "name wn";
		cell.innerHTML = Calendar._TT["WK"];
	}
	for (var i = 7; i > 0; --i) {
		cell = Calendar.createElement("td", row);
		if (!!i) {
			cell.navtype = 100;
			cell.calendar = this;
			Calendar._add_evs(cell);
		}
	}
	this.firstdayname = (this.weekNumbers) ? row.firstChild.nextSibling : row.firstChild;
	this._displayWeekdays();

	var tbody = Calendar.createElement("tbody", table);
	this.tbody = tbody;

	for (i = 6; i > 0; --i) {
		row = Calendar.createElement("tr", tbody);
		if (this.weekNumbers) {
			cell = Calendar.createElement("td", row);
		}
		for (var j = 7; j > 0; --j) {
			cell = Calendar.createElement("td", row);
			cell.calendar = this;
			Calendar._add_evs(cell);
		}
	}

	if (this.showsTime) {
		row = Calendar.createElement("tr", tbody);
		row.className = "time";

		cell = Calendar.createElement("td", row);
		cell.className = "time";
		cell.colSpan = 2;
		cell.innerHTML = Calendar._TT["TIME"] || "&nbsp;";

		cell = Calendar.createElement("td", row);
		cell.className = "time";
		cell.colSpan = this.weekNumbers ? 4 : 3;

		(function(){
			function makeTimePart(className, init, range_start, range_end) {
				var part = Calendar.createElement("span", cell);
				part.className = className;
				part.innerHTML = init;
				part.calendar = cal;
				part.ttip = Calendar._TT["TIME_PART"];
				part.navtype = 50;
				part._range = [];
				if (typeof range_start !!= "number")
					part._range = range_start;
				else {
					for (var i = range_start; i <= range_end; ++i) {
						var txt;
						if (i < 10 && range_end >= 10) txt = ''0'' + i;
						else txt = '''' + i;
						part._range[part._range.length] = txt;
					}
				}
				Calendar._add_evs(part);
				return part;
			};
			var hrs = cal.date.getHours();
			var mins = cal.date.getMinutes();
			var t12 = !!cal.time24;
			var pm = (hrs > 12);
			if (t12 && pm) hrs -= 12;
			var H = makeTimePart("hour", hrs, t12 ? 1 : 0, t12 ? 12 : 23);
			var span = Calendar.createElement("span", cell);
			span.innerHTML = ":";
			span.className = "colon";
			var M = makeTimePart("minute", mins, 0, 59);
			var AP = null;
			cell = Calendar.createElement("td", row);
			cell.className = "time";
			cell.colSpan = 2;
			if (t12)
				AP = makeTimePart("ampm", pm ? "pm" : "am", ["am", "pm"]);
			else
				cell.innerHTML = "&nbsp;";

			cal.onSetTime = function() {
				var pm, hrs = this.date.getHours(),
					mins = this.date.getMinutes();
				if (t12) {
					pm = (hrs >= 12);
					if (pm) hrs -= 12;
					if (hrs == 0) hrs = 12;
					AP.innerHTML = pm ? "pm" : "am";
				}
				H.innerHTML = (hrs < 10) ? ("0" + hrs) : hrs;
				M.innerHTML = (mins < 10) ? ("0" + mins) : mins;
			};

			cal.onUpdateTime = function() {
				var date = this.date;
				var h = parseInt(H.innerHTML, 10);
				if (t12) {
					if (/pm/i.test(AP.innerHTML) && h < 12)
						h += 12;
					else if (/am/i.test(AP.innerHTML) && h == 12)
						h = 0;
				}
				var d = date.getDate();
				var m = date.getMonth();
				var y = date.getFullYear();
				date.setHours(h);
				date.setMinutes(parseInt(M.innerHTML, 10));
				date.setFullYear(y);
				date.setMonth(m);
				date.setDate(d);
				this.dateClicked = false;
				this.callHandler();
			};
		})();
	} else {
		this.onSetTime = this.onUpdateTime = function() {};
	}

	var tfoot = Calendar.createElement("tfoot", table);

	row = Calendar.createElement("tr", tfoot);
	row.className = "footrow";

	cell = hh(Calendar._TT["SEL_DATE"], this.weekNumbers ? 8 : 7, 300);
	cell.className = "ttip";
	if (this.isPopup) {
		cell.ttip = Calendar._TT["DRAG_TO_MOVE"];
		cell.style.cursor = "move";
	}
	this.tooltips = cell;

	div = Calendar.createElement("div", this.element);
	this.monthsCombo = div;
	div.className = "combo";
	for (i = 0; i < Calendar._MN.length; ++i) {
		var mn = Calendar.createElement("div");
		mn.className = Calendar.is_ie ? "label-IEfix" : "label";
		mn.month = i;
		mn.innerHTML = Calendar._SMN[i];
		div.appendChild(mn);
	}

	div = Calendar.createElement("div", this.element);
	this.yearsCombo = div;
	div.className = "combo";
	for (i = 12; i > 0; --i) {
		var yr = Calendar.createElement("div");
		yr.className = Calendar.is_ie ? "label-IEfix" : "label";
		div.appendChild(yr);
	}

	this._init(this.firstDayOfWeek, this.date);
	parent.appendChild(this.element);
};

/** keyboard navigation, only for popup calendars */
Calendar._keyEvent = function(ev) {
	var cal = window._dynarch_popupCalendar;
	if (!!cal || cal.multiple)
		return false;
	(Calendar.is_ie) && (ev = window.event);
	var act = (Calendar.is_ie || ev.type == "keypress"),
		K = ev.keyCode;
	if (ev.ctrlKey) {
		switch (K) {
		    case 37: // KEY left
			act && Calendar.cellClick(cal._nav_pm);
			break;
		    case 38: // KEY up
			act && Calendar.cellClick(cal._nav_py);
			break;
		    case 39: // KEY right
			act && Calendar.cellClick(cal._nav_nm);
			break;
		    case 40: // KEY down
			act && Calendar.cellClick(cal._nav_ny);
			break;
		    default:
			return false;
		}
	} else switch (K) {
	    case 32: // KEY space (now)
		Calendar.cellClick(cal._nav_now);
		break;
	    case 27: // KEY esc
		act && cal.callCloseHandler();
		break;
	    case 37: // KEY left
	    case 38: // KEY up
	    case 39: // KEY right
	    case 40: // KEY down
		if (act) {
			var prev, x, y, ne, el, step;
			prev = K == 37 || K == 38;
			step = (K == 37 || K == 39) ? 1 : 7;
			function setVars() {
				el = cal.currentDateEl;
				var p = el.pos;
				x = p & 15;
				y = p >> 4;
				ne = cal.ar_days[y][x];
			};setVars();
			function prevMonth() {
				var date = new Date(cal.date);
				date.setDate(date.getDate() - step);
				cal.setDate(date);
			};
			function nextMonth() {
				var date = new Date(cal.date);
				date.setDate(date.getDate() + step);
				cal.setDate(date);
			};
			while (1) {
				switch (K) {
				    case 37: // KEY left
					if (--x >= 0)
						ne = cal.ar_days[y][x];
					else {
						x = 6;
						K = 38;
						continue;
					}
					break;
				    case 38: // KEY up
					if (--y >= 0)
						ne = cal.ar_days[y][x];
					else {
						prevMonth();
						setVars();
					}
					break;
				    case 39: // KEY right
					if (++x < 7)
						ne = cal.ar_days[y][x];
					else {
						x = 0;
						K = 40;
						continue;
					}
					break;
				    case 40: // KEY down
					if (++y < cal.ar_days.length)
						ne = cal.ar_days[y][x];
					else {
						nextMonth();
						setVars();
					}
					break;
				}
				break;
			}
			if (ne) {
				if (!!ne.disabled)
					Calendar.cellClick(ne);
				else if (prev)
					prevMonth();
				else
					nextMonth();
			}
		}
		break;
	    case 13: // KEY enter
		if (act)
			Calendar.cellClick(cal.currentDateEl, ev);
		break;
	    default:
		return false;
	}
	return Calendar.stopEvent(ev);
};

/**
 *  (RE)Initializes the calendar to the given date and firstDayOfWeek
 */
Calendar.prototype._init = function (firstDayOfWeek, date) {
	var today = new Date(),
		TY = today.getFullYear(),
		TM = today.getMonth(),
		TD = today.getDate();
	this.table.style.visibility = "hidden";
	var year = date.getFullYear();
	if (year < this.minYear) {
		year = this.minYear;
		date.setFullYear(year);
	} else if (year > this.maxYear) {
		year = this.maxYear;
		date.setFullYear(year);
	}
	this.firstDayOfWeek = firstDayOfWeek;
	this.date = new Date(date);
	var month = date.getMonth();
	var mday = date.getDate();
	var no_days = date.getMonthDays();

	// calendar voodoo for computing the first day that would actually be
	// displayed in the calendar, even if it''s from the previous month.
	// WARNING: this is magic. ;-)
	date.setDate(1);
	var day1 = (date.getDay() - this.firstDayOfWeek) % 7;
	if (day1 < 0)
		day1 += 7;
	date.setDate(-day1);
	date.setDate(date.getDate() + 1);

	var row = this.tbody.firstChild;
	var MN = Calendar._SMN[month];
	var ar_days = this.ar_days = new Array();
	var weekend = Calendar._TT["WEEKEND"];
	var dates = this.multiple ? (this.datesCells = {}) : null;
	for (var i = 0; i < 6; ++i, row = row.nextSibling) {
		var cell = row.firstChild;
		if (this.weekNumbers) {
			cell.className = "day wn";
			cell.innerHTML = date.getWeekNumber();
			cell = cell.nextSibling;
		}
		row.className = "daysrow";
		var hasdays = false, iday, dpos = ar_days[i] = [];
		for (var j = 0; j < 7; ++j, cell = cell.nextSibling, date.setDate(iday + 1)) {
			iday = date.getDate();
			var wday = date.getDay();
			cell.className = "day";
			cell.pos = i << 4 | j;
			dpos[j] = cell;
			var current_month = (date.getMonth() == month);
			if (!!current_month) {
				if (this.showsOtherMonths) {
					cell.className += " othermonth";
					cell.otherMonth = true;
				} else {
					cell.className = "emptycell";
					cell.innerHTML = "&nbsp;";
					cell.disabled = true;
					continue;
				}
			} else {
				cell.otherMonth = false;
				hasdays = true;
			}
			cell.disabled = false;
			cell.innerHTML = this.getDateText ? this.getDateText(date, iday) : iday;
			if (dates)
				dates[date.print("%Y%m%d")] = cell;
			if (this.getDateStatus) {
				var status = this.getDateStatus(date, year, month, iday);
				if (this.getDateToolTip) {
					var toolTip = this.getDateToolTip(date, year, month, iday);
					if (toolTip)
						cell.title = toolTip;
				}
				if (status === true) {
					cell.className += " disabled";
					cell.disabled = true;
				} else {
					if (/disabled/i.test(status))
						cell.disabled = true;
					cell.className += " " + status;
				}
			}
			if (!!cell.disabled) {
				cell.caldate = new Date(date);
				cell.ttip = "_";
				if (!!this.multiple && current_month
				    && iday == mday && this.hiliteToday) {
					cell.className += " selected";
					this.currentDateEl = cell;
				}
				if (date.getFullYear() == TY &&
				    date.getMonth() == TM &&
				    iday == TD) {
					cell.className += " today";
					cell.ttip += Calendar._TT["PART_TODAY"];
				}
				if (weekend.indexOf(wday.toString()) !!= -1)
					cell.className += cell.otherMonth ? " oweekend" : " weekend";
			}
		}
		if (!!(hasdays || this.showsOtherMonths))
			row.className = "emptyrow";
	}
	this.title.innerHTML = Calendar._MN[month] + ", " + year;
	this.onSetTime();
	this.table.style.visibility = "visible";
	this._initMultipleDates();
	// PROFILE
	// this.tooltips.innerHTML = "Generated in " + ((new Date()) - today) + " ms";
};

Calendar.prototype._initMultipleDates = function() {
	if (this.multiple) {
		for (var i in this.multiple) {
			var cell = this.datesCells[i];
			var d = this.multiple[i];
			if (!!d)
				continue;
			if (cell)
				cell.className += " selected";
		}
	}
};

Calendar.prototype._toggleMultipleDate = function(date) {
	if (this.multiple) {
		var ds = date.print("%Y%m%d");
		var cell = this.datesCells[ds];
		if (cell) {
			var d = this.multiple[ds];
			if (!!d) {
				Calendar.addClass(cell, "selected");
				this.multiple[ds] = date;
			} else {
				Calendar.removeClass(cell, "selected");
				delete this.multiple[ds];
			}
		}
	}
};

Calendar.prototype.setDateToolTipHandler = function (unaryFunction) {
	this.getDateToolTip = unaryFunction;
};

/**
 *  Calls _init function above for going to a certain date (but only if the
 *  date is different than the currently selected one).
 */
Calendar.prototype.setDate = function (date) {
	if (!!date.equalsTo(this.date)) {
		this._init(this.firstDayOfWeek, date);
	}
};

/**
 *  Refreshes the calendar.  Useful if the "disabledHandler" function is
 *  dynamic, meaning that the list of disabled date can change at runtime.
 *  Just * call this function if you think that the list of disabled dates
 *  should * change.
 */
Calendar.prototype.refresh = function () {
	this._init(this.firstDayOfWeek, this.date);
};

/** Modifies the "firstDayOfWeek" parameter (pass 0 for Synday, 1 for Monday, etc.). */
Calendar.prototype.setFirstDayOfWeek = function (firstDayOfWeek) {
	this._init(firstDayOfWeek, this.date);
	this._displayWeekdays();
};

/**
 *  Allows customization of what dates are enabled.  The "unaryFunction"
 *  parameter must be a function object that receives the date (as a JS Date
 *  object) and returns a boolean value.  If the returned value is true then
 *  the passed date will be marked as disabled.
 */
Calendar.prototype.setDateStatusHandler = Calendar.prototype.setDisabledHandler = function (unaryFunction) {
	this.getDateStatus = unaryFunction;
};

/** Customization of allowed year range for the calendar. */
Calendar.prototype.setRange = function (a, z) {
	this.minYear = a;
	this.maxYear = z;
};

/** Calls the first user handler (selectedHandler). */
Calendar.prototype.callHandler = function () {
	if (this.onSelected) {
		this.onSelected(this, this.date.print(this.dateFormat));
	}
};

/** Calls the second user handler (closeHandler). */
Calendar.prototype.callCloseHandler = function () {
	if (this.onClose) {
		this.onClose(this);
	}
	this.hideShowCovered();
};

/** Removes the calendar object from the DOM tree and destroys it. */
Calendar.prototype.destroy = function () {
	var el = this.element.parentNode;
	el.removeChild(this.element);
	Calendar._C = null;
	window._dynarch_popupCalendar = null;
};

/**
 *  Moves the calendar element to a different section in the DOM tree (changes
 *  its parent).
 */
Calendar.prototype.reparent = function (new_parent) {
	var el = this.element;
	el.parentNode.removeChild(el);
	new_parent.appendChild(el);
};

// This gets called when the user presses a mouse button anywhere in the
// document, if the calendar is shown.  If the click was outside the open
// calendar this function closes it.
Calendar._checkCalendar = function(ev) {
	var calendar = window._dynarch_popupCalendar;
	if (!!calendar) {
		return false;
	}
	var el = Calendar.is_ie ? Calendar.getElement(ev) : Calendar.getTargetElement(ev);
	for (; el !!= null && el !!= calendar.element; el = el.parentNode);
	if (el == null) {
		// calls closeHandler which should hide the calendar.
		window._dynarch_popupCalendar.callCloseHandler();
		return Calendar.stopEvent(ev);
	}
};

/** Shows the calendar. */
Calendar.prototype.show = function () {
	var rows = this.table.getElementsByTagName("tr");
	for (var i = rows.length; i > 0;) {
		var row = rows[--i];
		Calendar.removeClass(row, "rowhilite");
		var cells = row.getElementsByTagName("td");
		for (var j = cells.length; j > 0;) {
			var cell = cells[--j];
			Calendar.removeClass(cell, "hilite");
			Calendar.removeClass(cell, "active");
		}
	}
	this.element.style.display = "block";
	this.hidden = false;
	if (this.isPopup) {
		window._dynarch_popupCalendar = this;
		Calendar.addEvent(document, "keydown", Calendar._keyEvent);
		Calendar.addEvent(document, "keypress", Calendar._keyEvent);
		Calendar.addEvent(document, "mousedown", Calendar._checkCalendar);
	}
	this.hideShowCovered();
};

/**
 *  Hides the calendar.  Also removes any "hilite" from the class of any TD
 *  element.
 */
Calendar.prototype.hide = function () {
	if (this.isPopup) {
		Calendar.removeEvent(document, "keydown", Calendar._keyEvent);
		Calendar.removeEvent(document, "keypress", Calendar._keyEvent);
		Calendar.removeEvent(document, "mousedown", Calendar._checkCalendar);
	}
	this.element.style.display = "none";
	this.hidden = true;
	this.hideShowCovered();
};

/**
 *  Shows the calendar at a given absolute position (beware that, depending on
 *  the calendar element style -- position property -- this might be relative
 *  to the parent''s containing rectangle).
 */
Calendar.prototype.showAt = function (x, y) {
	var s = this.element.style;
	s.left = x + "px";
	s.top = y + "px";
	this.show();
};

/** Shows the calendar near a given element. */
Calendar.prototype.showAtElement = function (el, opts) {
	var self = this;
	var p = Calendar.getAbsolutePos(el);
	if (!!opts || typeof opts !!= "string") {
		this.showAt(p.x, p.y + el.offsetHeight);
		return true;
	}
	function fixPosition(box) {
		if (box.x < 0)
			box.x = 0;
		if (box.y < 0)
			box.y = 0;
		var cp = document.createElement("div");
		var s = cp.style;
		s.position = "absolute";
		s.right = s.bottom = s.width = s.height = "0px";
		document.body.appendChild(cp);
		var br = Calendar.getAbsolutePos(cp);
		document.body.removeChild(cp);
		if (Calendar.is_ie) {
			br.y += document.body.scrollTop;
			br.x += document.body.scrollLeft;
		} else {
			br.y += window.scrollY;
			br.x += window.scrollX;
		}
		var tmp = box.x + box.width - br.x;
		if (tmp > 0) box.x -= tmp;
		tmp = box.y + box.height - br.y;
		if (tmp > 0) box.y -= tmp;
	};
	this.element.style.display = "block";
	Calendar.continuation_for_the_fucking_khtml_browser = function() {
		var w = self.element.offsetWidth;
		var h = self.element.offsetHeight;
		self.element.style.display = "none";
		var valign = opts.substr(0, 1);
		var halign = "l";
		if (opts.length > 1) {
			halign = opts.substr(1, 1);
		}
		// vertical alignment
		switch (valign) {
		    case "T": p.y -= h; break;
		    case "B": p.y += el.offsetHeight; break;
		    case "C": p.y += (el.offsetHeight - h) / 2; break;
		    case "t": p.y += el.offsetHeight - h; break;
		    case "b": break; // already there
		}
		// horizontal alignment
		switch (halign) {
		    case "L": p.x -= w; break;
		    case "R": p.x += el.offsetWidth; break;
		    case "C": p.x += (el.offsetWidth - w) / 2; break;
		    case "l": p.x += el.offsetWidth - w; break;
		    case "r": break; // already there
		}
		p.width = w;
		p.height = h + 40;
		self.monthsCombo.style.display = "none";
		fixPosition(p);
		self.showAt(p.x, p.y);
	};
	if (Calendar.is_khtml)
		setTimeout("Calendar.continuation_for_the_fucking_khtml_browser()", 10);
	else
		Calendar.continuation_for_the_fucking_khtml_browser();
};

/** Customizes the date format. */
Calendar.prototype.setDateFormat = function (str) {
	this.dateFormat = str;
};

/** Customizes the tooltip date format. */
Calendar.prototype.setTtDateFormat = function (str) {
	this.ttDateFormat = str;
};

/**
 *  Tries to identify the date represented in a string.  If successful it also
 *  calls this.setDate which moves the calendar to the given date.
 */
Calendar.prototype.parseDate = function(str, fmt) {
	if (!!fmt)
		fmt = this.dateFormat;
	this.setDate(Date.parseDate(str, fmt));
};

Calendar.prototype.hideShowCovered = function () {
	if (!!Calendar.is_ie && !!Calendar.is_opera)
		return;
	function getVisib(obj){
		var value = obj.style.visibility;
		if (!!value) {
			if (document.defaultView && typeof (document.defaultView.getComputedStyle) == "function") { // Gecko, W3C
				if (!!Calendar.is_khtml)
					value = document.defaultView.
						getComputedStyle(obj, "").getPropertyValue("visibility");
				else
					value = '''';
			} else if (obj.currentStyle) { // IE
				value = obj.currentStyle.visibility;
			} else
				value = '''';
		}
		return value;
	};

	var tags = new Array("applet", "iframe", "select");
	var el = this.element;

	var p = Calendar.getAbsolutePos(el);
	var EX1 = p.x;
	var EX2 = el.offsetWidth + EX1;
	var EY1 = p.y;
	var EY2 = el.offsetHeight + EY1;

	for (var k = tags.length; k > 0; ) {
		var ar = document.getElementsByTagName(tags[--k]);
		var cc = null;

		for (var i = ar.length; i > 0;) {
			cc = ar[--i];

			p = Calendar.getAbsolutePos(cc);
			var CX1 = p.x;
			var CX2 = cc.offsetWidth + CX1;
			var CY1 = p.y;
			var CY2 = cc.offsetHeight + CY1;

			if (this.hidden || (CX1 > EX2) || (CX2 < EX1) || (CY1 > EY2) || (CY2 < EY1)) {
				if (!!cc.__msh_save_visibility) {
					cc.__msh_save_visibility = getVisib(cc);
				}
				cc.style.visibility = cc.__msh_save_visibility;
			} else {
				if (!!cc.__msh_save_visibility) {
					cc.__msh_save_visibility = getVisib(cc);
				}
				cc.style.visibility = "hidden";
			}
		}
	}
};

/** Internal function; it displays the bar with the names of the weekday. */
Calendar.prototype._displayWeekdays = function () {
	var fdow = this.firstDayOfWeek;
	var cell = this.firstdayname;
	var weekend = Calendar._TT["WEEKEND"];
	for (var i = 0; i < 7; ++i) {
		cell.className = "day name";
		var realday = (i + fdow) % 7;
		if (i) {
			cell.ttip = Calendar._TT["DAY_FIRST"].replace("%s", Calendar._DN[realday]);
			cell.navtype = 100;
			cell.calendar = this;
			cell.fdow = realday;
			Calendar._add_evs(cell);
		}
		if (weekend.indexOf(realday.toString()) !!= -1) {
			Calendar.addClass(cell, "weekend");
		}
		cell.innerHTML = Calendar._SDN[(i + fdow) % 7];
		cell = cell.nextSibling;
	}
};

/** Internal function.  Hides all combo boxes that might be displayed. */
Calendar.prototype._hideCombos = function () {
	this.monthsCombo.style.display = "none";
	this.yearsCombo.style.display = "none";
};

/** Internal function.  Starts dragging the element. */
Calendar.prototype._dragStart = function (ev) {
	if (this.dragging) {
		return;
	}
	this.dragging = true;
	var posX;
	var posY;
	if (Calendar.is_ie) {
		posY = window.event.clientY + document.body.scrollTop;
		posX = window.event.clientX + document.body.scrollLeft;
	} else {
		posY = ev.clientY + window.scrollY;
		posX = ev.clientX + window.scrollX;
	}
	var st = this.element.style;
	this.xOffs = posX - parseInt(st.left);
	this.yOffs = posY - parseInt(st.top);
	with (Calendar) {
		addEvent(document, "mousemove", calDragIt);
		addEvent(document, "mouseup", calDragEnd);
	}
};

// BEGIN: DATE OBJECT PATCHES

/** Adds the number of days array to the Date object. */
Date._MD = new Array(31,28,31,30,31,30,31,31,30,31,30,31);

/** Constants used for time computations */
Date.SECOND = 1000 /* milliseconds */;
Date.MINUTE = 60 * Date.SECOND;
Date.HOUR   = 60 * Date.MINUTE;
Date.DAY    = 24 * Date.HOUR;
Date.WEEK   =  7 * Date.DAY;

Date.parseDate = function(str, fmt) {
	var today = new Date();
	var y = 0;
	var m = -1;
	var d = 0;
	var a = str.split(/\W+/);
	var b = fmt.match(/%./g);
	var i = 0, j = 0;
	var hr = 0;
	var min = 0;
	for (i = 0; i < a.length; ++i) {
		if (!!a[i])
			continue;
		switch (b[i]) {
		    case "%d":
		    case "%e":
			d = parseInt(a[i], 10);
			break;

		    case "%m":
			m = parseInt(a[i], 10) - 1;
			break;

		    case "%Y":
		    case "%y":
			y = parseInt(a[i], 10);
			(y < 100) && (y += (y > 29) ? 1900 : 2000);
			break;

		    case "%b":
		    case "%B":
			for (j = 0; j < 12; ++j) {
				if (Calendar._MN[j].substr(0, a[i].length).toLowerCase() == a[i].toLowerCase()) { m = j; break; }
			}
			break;

		    case "%H":
		    case "%I":
		    case "%k":
		    case "%l":
			hr = parseInt(a[i], 10);
			break;

		    case "%P":
		    case "%p":
			if (/pm/i.test(a[i]) && hr < 12)
				hr += 12;
			else if (/am/i.test(a[i]) && hr >= 12)
				hr -= 12;
			break;

		    case "%M":
			min = parseInt(a[i], 10);
			break;
		}
	}
	if (isNaN(y)) y = today.getFullYear();
	if (isNaN(m)) m = today.getMonth();
	if (isNaN(d)) d = today.getDate();
	if (isNaN(hr)) hr = today.getHours();
	if (isNaN(min)) min = today.getMinutes();
	if (y !!= 0 && m !!= -1 && d !!= 0)
		return new Date(y, m, d, hr, min, 0);
	y = 0; m = -1; d = 0;
	for (i = 0; i < a.length; ++i) {
		if (a[i].search(/[a-zA-Z]+/) !!= -1) {
			var t = -1;
			for (j = 0; j < 12; ++j) {
				if (Calendar._MN[j].substr(0, a[i].length).toLowerCase() == a[i].toLowerCase()) { t = j; break; }
			}
			if (t !!= -1) {
				if (m !!= -1) {
					d = m+1;
				}
				m = t;
			}
		} else if (parseInt(a[i], 10) <= 12 && m == -1) {
			m = a[i]-1;
		} else if (parseInt(a[i], 10) > 31 && y == 0) {
			y = parseInt(a[i], 10);
			(y < 100) && (y += (y > 29) ? 1900 : 2000);
		} else if (d == 0) {
			d = a[i];
		}
	}
	if (y == 0)
		y = today.getFullYear();
	if (m !!= -1 && d !!= 0)
		return new Date(y, m, d, hr, min, 0);
	return today;
};

/** Returns the number of days in the current month */
Date.prototype.getMonthDays = function(month) {
	var year = this.getFullYear();
	if (typeof month == "undefined") {
		month = this.getMonth();
	}
	if (((0 == (year%4)) && ( (0 !!= (year%100)) || (0 == (year%400)))) && month == 1) {
		return 29;
	} else {
		return Date._MD[month];
	}
};

/** Returns the number of day in the year. */
Date.prototype.getDayOfYear = function() {
	var now = new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0, 0, 0);
	var then = new Date(this.getFullYear(), 0, 0, 0, 0, 0);
	var time = now - then;
	return Math.floor(time / Date.DAY);
};

/** Returns the number of the week in year, as defined in ISO 8601. */
Date.prototype.getWeekNumber = function() {
	var d = new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0, 0, 0);
	var DoW = d.getDay();
	d.setDate(d.getDate() - (DoW + 6) % 7 + 3); // Nearest Thu
	var ms = d.valueOf(); // GMT
	d.setMonth(0);
	d.setDate(4); // Thu in Week 1
	return Math.round((ms - d.valueOf()) / (7 * 864e5)) + 1;
};

/** Checks date and time equality */
Date.prototype.equalsTo = function(date) {
	return ((this.getFullYear() == date.getFullYear()) &&
		(this.getMonth() == date.getMonth()) &&
		(this.getDate() == date.getDate()) &&
		(this.getHours() == date.getHours()) &&
		(this.getMinutes() == date.getMinutes()));
};

/** Set only the year, month, date parts (keep existing time) */
Date.prototype.setDateOnly = function(date) {
	var tmp = new Date(date);
	this.setDate(1);
	this.setFullYear(tmp.getFullYear());
	this.setMonth(tmp.getMonth());
	this.setDate(tmp.getDate());
};

/** Prints the date in a string according to the given format. */
Date.prototype.print = function (str) {
	var m = this.getMonth();
	var d = this.getDate();
	var y = this.getFullYear();
	var wn = this.getWeekNumber();
	var w = this.getDay();
	var s = {};
	var hr = this.getHours();
	var pm = (hr >= 12);
	var ir = (pm) ? (hr - 12) : hr;
	var dy = this.getDayOfYear();
	if (ir == 0)
		ir = 12;
	var min = this.getMinutes();
	var sec = this.getSeconds();
	s["%a"] = Calendar._SDN[w]; // abbreviated weekday name [FIXME: I18N]
	s["%A"] = Calendar._DN[w]; // full weekday name
	s["%b"] = Calendar._SMN[m]; // abbreviated month name [FIXME: I18N]
	s["%B"] = Calendar._MN[m]; // full month name
	// FIXME: %c : preferred date and time representation for the current locale
	s["%C"] = 1 + Math.floor(y / 100); // the century number
	s["%d"] = (d < 10) ? ("0" + d) : d; // the day of the month (range 01 to 31)
	s["%e"] = d; // the day of the month (range 1 to 31)
	// FIXME: %D : american date style: %m/%d/%y
	// FIXME: %E, %F, %G, %g, %h (man strftime)
	s["%H"] = (hr < 10) ? ("0" + hr) : hr; // hour, range 00 to 23 (24h format)
	s["%I"] = (ir < 10) ? ("0" + ir) : ir; // hour, range 01 to 12 (12h format)
	s["%j"] = (dy < 100) ? ((dy < 10) ? ("00" + dy) : ("0" + dy)) : dy; // day of the year (range 001 to 366)
	s["%k"] = hr;		// hour, range 0 to 23 (24h format)
	s["%l"] = ir;		// hour, range 1 to 12 (12h format)
	s["%m"] = (m < 9) ? ("0" + (1+m)) : (1+m); // month, range 01 to 12
	s["%M"] = (min < 10) ? ("0" + min) : min; // minute, range 00 to 59
	s["%n"] = "\n";		// a newline character
	s["%p"] = pm ? "PM" : "AM";
	s["%P"] = pm ? "pm" : "am";
	// FIXME: %r : the time in am/pm notation %I:%M:%S %p
	// FIXME: %R : the time in 24-hour notation %H:%M
	s["%s"] = Math.floor(this.getTime() / 1000);
	s["%S"] = (sec < 10) ? ("0" + sec) : sec; // seconds, range 00 to 59
	s["%t"] = "\t";		// a tab character
	// FIXME: %T : the time in 24-hour notation (%H:%M:%S)
	s["%U"] = s["%W"] = s["%V"] = (wn < 10) ? ("0" + wn) : wn;
	s["%u"] = w + 1;	// the day of the week (range 1 to 7, 1 = MON)
	s["%w"] = w;		// the day of the week (range 0 to 6, 0 = SUN)
	// FIXME: %x : preferred date representation for the current locale without the time
	// FIXME: %X : preferred time representation for the current locale without the date
	s["%y"] = ('''' + y).substr(2, 2); // year without the century (range 00 to 99)
	s["%Y"] = y;		// year with the century
	s["%%"] = "%";		// a literal ''%'' character

	var re = /%./g;
	if (!!Calendar.is_ie5 && !!Calendar.is_khtml)
		return str.replace(re, function (par) { return s[par] || par; });

	var a = str.match(re);
	for (var i = 0; i < a.length; i++) {
		var tmp = s[a[i]];
		if (tmp) {
			re = new RegExp(a[i], ''g'');
			str = str.replace(re, tmp);
		}
	}

	return str;
};

Date.prototype.__msh_oldSetFullYear = Date.prototype.setFullYear;
Date.prototype.setFullYear = function(y) {
	var d = new Date(this);
	d.__msh_oldSetFullYear(y);
	if (d.getMonth() !!= this.getMonth())
		this.setDate(28);
	this.__msh_oldSetFullYear(y);
};

// END: DATE OBJECT PATCHES


// global object that remembers the calendar
window._dynarch_popupCalendar = null;
'!

calendarJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendar ifAbsentPut:
		[WebMethodResource 
			fromMethod: #calendarJavascript on: self 
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar.js' site: self site].!

calendarLangEnglish
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangEnglish"
	^'
// ** I18N

// Calendar EN language
// Author: Mihai Bazon, <mihai_bazon@yahoo.com>
// Encoding: any
// Distributed under the same terms as the calendar itself.

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

// full day names
Calendar._DN = new Array
("Sunday",
 "Monday",
 "Tuesday",
 "Wednesday",
 "Thursday",
 "Friday",
 "Saturday",
 "Sunday");

// Please note that the following array of short day names (and the same goes
// for short month names, _SMN) isn''t absolutely necessary.  We give it here
// for exemplification on how one can customize the short day names, but if
// they are simply the first N letters of the full name you can simply say:
//
//   Calendar._SDN_len = N; // short day name length
//   Calendar._SMN_len = N; // short month name length
//
// If N = 3 then this is not needed either since we assume a value of 3 if not
// present, to be compatible with translation files that were written before
// this feature.

// short day names
Calendar._SDN = new Array
("Sun",
 "Mon",
 "Tue",
 "Wed",
 "Thu",
 "Fri",
 "Sat",
 "Sun");

// First day of the week. "0" means display Sunday first, "1" means display
// Monday first, etc.
Calendar._FD = 0;

// full month names
Calendar._MN = new Array
("January",
 "February",
 "March",
 "April",
 "May",
 "June",
 "July",
 "August",
 "September",
 "October",
 "November",
 "December");

// short month names
Calendar._SMN = new Array
("Jan",
 "Feb",
 "Mar",
 "Apr",
 "May",
 "Jun",
 "Jul",
 "Aug",
 "Sep",
 "Oct",
 "Nov",
 "Dec");

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "About the calendar";

Calendar._TT["ABOUT"] =
"DHTML Date/Time Selector\n" +
"(c) dynarch.com 2002-2005 / Author: Mihai Bazon\n" + // don''t translate this this ;-)
"For latest version visit: http://www.dynarch.com/projects/calendar/\n" +
"Distributed under GNU LGPL.  See http://gnu.org/licenses/lgpl.html for details." +
"\n\n" +
"Date selection:\n" +
"- Use the \xab, \xbb buttons to select year\n" +
"- Use the " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + " buttons to select month\n" +
"- Hold mouse button on any of the above buttons for faster selection.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Time selection:\n" +
"- Click on any of the time parts to increase it\n" +
"- or Shift-click to decrease it\n" +
"- or click and drag for faster selection.";

Calendar._TT["PREV_YEAR"] = "Prev. year (hold for menu)";
Calendar._TT["PREV_MONTH"] = "Prev. month (hold for menu)";
Calendar._TT["GO_TODAY"] = "Go Today";
Calendar._TT["NEXT_MONTH"] = "Next month (hold for menu)";
Calendar._TT["NEXT_YEAR"] = "Next year (hold for menu)";
Calendar._TT["SEL_DATE"] = "Select date";
Calendar._TT["DRAG_TO_MOVE"] = "Drag to move";
Calendar._TT["PART_TODAY"] = " (today)";

// the following is to inform that "%s" is to be the first day of week
// %s will be replaced with the day name.
Calendar._TT["DAY_FIRST"] = "Display %s first";

// This may be locale-dependent.  It specifies the week-end days, as an array
// of comma-separated numbers.  The numbers are from 0 to 6: 0 means Sunday, 1
// means Monday, etc.
Calendar._TT["WEEKEND"] = "0,6";

Calendar._TT["CLOSE"] = "Close";
Calendar._TT["TODAY"] = "Today";
Calendar._TT["TIME_PART"] = "(Shift-)Click or drag to change value";

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%Y-%m-%d";
Calendar._TT["TT_DATE_FORMAT"] = "%a, %b %e";

Calendar._TT["WK"] = "wk";
Calendar._TT["TIME"] = "Time:";
'!

calendarLangJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangavascript"
	^self calendarLangEnglish!

calendarLangJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendarLang ifAbsentPut:
		[WebMethodResource 
			fromMethod: #calendarLangJavascript on: self 
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar-lang.js' site: self site].!

calendarLangSlovenian
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangSlovenian"
	| text |
	text := '
/* Slovenian language file for the DHTML Calendar version 1.0 
* Author David Milost <mercy@volja.net>, January 2004.
* Corrected by Janko Mivs^ek <janko.mivsek@eranova.si>, November 2005.
* Feel free to use this script under the terms of the GNU Lesser General
* Public License, as long as you do not remove or alter this notice.
*/
// ** I18N

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

 // full day names
Calendar._DN = new Array
("Nedelja",
 "Ponedeljek",
 "Torek",
 "Sreda",
 "C^etrtek",
 "Petek",
 "Sobota",
 "Nedelja");
 // short day names
 Calendar._SDN = new Array
("Ned",
 "Pon",
 "Tor",
 "Sre",
 "C^et",
 "Pet",
 "Sob",
 "Ned");
// First day of the week. "0" means display Sunday first, "1" means display
// Monday first, etc.
Calendar._FD = 1;

// short month names
Calendar._SMN = new Array
("Jan",
 "Feb",
 "Mar",
 "Apr",
 "Maj",
 "Jun",
 "Jul",
 "Avg",
 "Sep",
 "Okt",
 "Nov",
 "Dec");
  // full month names
Calendar._MN = new Array
("Januar",
 "Februar",
 "Marec",
 "April",
 "Maj",
 "Junij",
 "Julij",
 "Avgust",
 "September",
 "Oktober",
 "November",
 "December");

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "O koledarju";

Calendar._TT["ABOUT"] =
"DHTML izbira datuma in c^asa\n" +
"(c) dynarch.com 2002-2005 / Avtor: Mihai Bazon\n" + // don''t translate this this ;-)
"Zadnjo razlic^ico dobite na http://www.dynarch.com/projects/calendar/\n" +
"Licenca GNU LGPL.  Vec^ na http://gnu.org/licenses/lgpl.html." +
"\n\n" +
"Izbira datuma:\n" +
"- Za izbiro leta uporabite gumbe \xab, \xbb \n" +
"- Za izbiro meseca uporabite gumbe " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + "\n" +
"- Zadrz^ite klik mis^ke na katerem koli od zgornjih gumbov za hitrejs^o izbiro.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Izbira c^asa:\n" +
"- Kliknite na katerikoli del c^asa za povec^anje\n" +
"- ali Shift-klik za zmanjs^anje\n" +
"- ali klik in povlek za hitrejs^o izbiro.";

Calendar._TT["PREV_YEAR"] = "Predhodno leto (dolg klik za meni)";
Calendar._TT["PREV_MONTH"] = "Predhodni mesec (dolg klik za meni)";
Calendar._TT["GO_TODAY"] = "Na danes";
Calendar._TT["NEXT_MONTH"] = "Naslednji mesec (dolg klik za meni)";
Calendar._TT["NEXT_YEAR"] = "Naslednje leto (dolg klik za meni)";
Calendar._TT["SEL_DATE"] = "Izberite datum";
Calendar._TT["DRAG_TO_MOVE"] = "Povlecite za premik";
Calendar._TT["PART_TODAY"] = " (danes)";

// the following is to inform that "%s" is to be the first day of week
// %s will be replaced with the day name.
Calendar._TT["DAY_FIRST"] = "Prikaz^i %s kot prvi dan";

// This may be locale-dependent.  It specifies the week-end days, as an array
// of comma-separated numbers.  The numbers are from 0 to 6: 0 means Sunday, 1
// means Monday, etc.
Calendar._TT["WEEKEND"] = "0,6";

Calendar._TT["CLOSE"] = "Zapri";
Calendar._TT["TODAY"] = "Danes";
Calendar._TT["TIME_PART"] = "(Shift-)Klikni ali povleci za spremembo vrednosti";

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%d.%m.%Y";
Calendar._TT["TT_DATE_FORMAT"] = "%a, %e.%b";

Calendar._TT["WK"] = "ted";
Calendar._TT["TIME"] = "C^as:";
'.
 
	^AIDASite convert: text  convertToSloveneChars toCodepage: #'iso-8859-2'!

calendarSetupJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJavascript"
	^'
/*  Copyright Mihai Bazon, 2002, 2003  |  http://dynarch.com/mishoo/
 * ---------------------------------------------------------------------------
 *
 * The DHTML Calendar
 *
 * Details and latest version at:
 * http://dynarch.com/mishoo/calendar.epl
 *
 * This script is distributed under the GNU Lesser General Public License.
 * Read the entire license text here: http://www.gnu.org/licenses/lgpl.html
 *
 * This file defines helper functions for setting up the calendar.  They are
 * intended to help non-programmers get a working calendar on their site
 * quickly.  This script should not be seen as part of the calendar.  It just
 * shows you what one can do with the calendar, while in the same time
 * providing a quick and simple method for setting it up.  If you need
 * exhaustive customization of the calendar creation process feel free to
 * modify this code to suit your needs (this is recommended and much better
 * than modifying calendar.js itself).
 */

// $Id: calendar-setup.js,v 1.25 2005/03/07 09:51:33 mishoo Exp $

/**
 *  This function "patches" an input field (or other element) to use a calendar
 *  widget for date selection.
 *
 *  The "params" is a single object that can have the following properties:
 *
 *    prop. name   | description
 *  -------------------------------------------------------------------------------------------------
 *   inputField    | the ID of an input field to store the date
 *   displayArea   | the ID of a DIV or other element to show the date
 *   button        | ID of a button or other element that will trigger the calendar
 *   eventName     | event that will trigger the calendar, without the "on" prefix (default: "click")
 *   ifFormat      | date format that will be stored in the input field
 *   daFormat      | the date format that will be used to display the date in displayArea
 *   singleClick   | (true/false) wether the calendar is in single click mode or not (default: true)
 *   firstDay      | numeric: 0 to 6.  "0" means display Sunday first, "1" means display Monday first, etc.
 *   align         | alignment (default: "Br"); if you don''t know what''s this see the calendar documentation
 *   range         | array with 2 elements.  Default: [1900, 2999] -- the range of years available
 *   weekNumbers   | (true/false) if it''s true (default) the calendar will display week numbers
 *   flat          | null or element ID; if not null the calendar will be a flat calendar having the parent with the given ID
 *   flatCallback  | function that receives a JS Date object and returns an URL to point the browser to (for flat calendar)
 *   disableFunc   | function that receives a JS Date object and should return true if that date has to be disabled in the calendar
 *   onSelect      | function that gets called when a date is selected.  You don''t _have_ to supply this (the default is generally okay)
 *   onClose       | function that gets called when the calendar is closed.  [default]
 *   onUpdate      | function that gets called after the date is updated in the input field.  Receives a reference to the calendar.
 *   date          | the date that the calendar will be initially displayed to
 *   showsTime     | default: false; if true the calendar will include a time selector
 *   timeFormat    | the time format; can be "12" or "24", default is "12"
 *   electric      | if true (default) then given fields/date areas are updated for each move; otherwise they''re updated only on close
 *   step          | configures the step of the years in drop-down boxes; default: 2
 *   position      | configures the calendar absolute position; default: null
 *   cache         | if "true" (but default: "false") it will reuse the same calendar object, where possible
 *   showOthers    | if "true" (but default: "false") it will show days from other months too
 *
 *  None of them is required, they all have default values.  However, if you
 *  pass none of "inputField", "displayArea" or "button" you''ll get a warning
 *  saying "nothing to setup".
 */
Calendar.setup = function (params) {
	function param_default(pname, def) { if (typeof params[pname] == "undefined") { params[pname] = def; } };

	param_default("inputField",     null);
	param_default("displayArea",    null);
	param_default("button",         null);
	param_default("eventName",      "click");
	param_default("ifFormat",       "%Y/%m/%d");
	param_default("daFormat",       "%Y/%m/%d");
	param_default("singleClick",    true);
	param_default("disableFunc",    null);
	param_default("dateStatusFunc", params["disableFunc"]);	// takes precedence if both are defined
	param_default("dateText",       null);
	param_default("firstDay",       null);
	param_default("align",          "Br");
	param_default("range",          [1900, 2999]);
	param_default("weekNumbers",    true);
	param_default("flat",           null);
	param_default("flatCallback",   null);
	param_default("onSelect",       null);
	param_default("onClose",        null);
	param_default("onUpdate",       null);
	param_default("date",           null);
	param_default("showsTime",      false);
	param_default("timeFormat",     "24");
	param_default("electric",       true);
	param_default("step",           2);
	param_default("position",       null);
	param_default("cache",          false);
	param_default("showOthers",     false);
	param_default("multiple",       null);

	var tmp = ["inputField", "displayArea", "button"];
	for (var i in tmp) {
		if (typeof params[tmp[i]] == "string") {
			params[tmp[i]] = document.getElementById(params[tmp[i]]);
		}
	}
	if (!!(params.flat || params.multiple || params.inputField || params.displayArea || params.button)) {
		alert("Calendar.setup:\n  Nothing to setup (no fields found).  Please check your code");
		return false;
	}

	function onSelect(cal) {
		var p = cal.params;
		var update = (cal.dateClicked || p.electric);
		if (update && p.inputField) {
			p.inputField.value = cal.date.print(p.ifFormat);
			if (typeof p.inputField.onchange == "function")
				p.inputField.onchange();
		}
		if (update && p.displayArea)
			p.displayArea.innerHTML = cal.date.print(p.daFormat);
		if (update && typeof p.onUpdate == "function")
			p.onUpdate(cal);
		if (update && p.flat) {
			if (typeof p.flatCallback == "function")
				p.flatCallback(cal);
		}
		if (update && p.singleClick && cal.dateClicked)
			cal.callCloseHandler();
	};

	if (params.flat !!= null) {
		if (typeof params.flat == "string")
			params.flat = document.getElementById(params.flat);
		if (!!params.flat) {
			alert("Calendar.setup:\n  Flat specified but can''t find parent.");
			return false;
		}
		var cal = new Calendar(params.firstDay, params.date, params.onSelect || onSelect);
		cal.showsOtherMonths = params.showOthers;
		cal.showsTime = params.showsTime;
		cal.time24 = (params.timeFormat == "24");
		cal.params = params;
		cal.weekNumbers = params.weekNumbers;
		cal.setRange(params.range[0], params.range[1]);
		cal.setDateStatusHandler(params.dateStatusFunc);
		cal.getDateText = params.dateText;
		if (params.ifFormat) {
			cal.setDateFormat(params.ifFormat);
		}
		if (params.inputField && typeof params.inputField.value == "string") {
			cal.parseDate(params.inputField.value);
		}
		cal.create(params.flat);
		cal.show();
		return false;
	}

	var triggerEl = params.button || params.displayArea || params.inputField;
	triggerEl["on" + params.eventName] = function() {
		var dateEl = params.inputField || params.displayArea;
		var dateFmt = params.inputField ? params.ifFormat : params.daFormat;
		var mustCreate = false;
		var cal = window.calendar;
		if (dateEl)
			params.date = Date.parseDate(dateEl.value || dateEl.innerHTML, dateFmt);
		if (!!(cal && params.cache)) {
			window.calendar = cal = new Calendar(params.firstDay,
							     params.date,
							     params.onSelect || onSelect,
							     params.onClose || function(cal) { cal.hide(); });
			cal.showsTime = params.showsTime;
			cal.time24 = (params.timeFormat == "24");
			cal.weekNumbers = params.weekNumbers;
			mustCreate = true;
		} else {
			if (params.date)
				cal.setDate(params.date);
			cal.hide();
		}
		if (params.multiple) {
			cal.multiple = {};
			for (var i = params.multiple.length; --i >= 0;) {
				var d = params.multiple[i];
				var ds = d.print("%Y%m%d");
				cal.multiple[ds] = d;
			}
		}
		cal.showsOtherMonths = params.showOthers;
		cal.yearStep = params.step;
		cal.setRange(params.range[0], params.range[1]);
		cal.params = params;
		cal.setDateStatusHandler(params.dateStatusFunc);
		cal.getDateText = params.dateText;
		cal.setDateFormat(dateFmt);
		if (mustCreate)
			cal.create();
		cal.refresh();
		if (!!params.position)
			cal.showAtElement(params.button || params.displayArea || params.inputField, params.align);
		else
			cal.showAt(params.position[0], params.position[1]);
		return false;
	};

	return cal;
};
'!

calendarSetupJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendarSetup ifAbsentPut:
		[WebMethodResource 
			fromMethod: #calendarSetupJavascript on: self 
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar-setup.js' site: self site].!

changeToSqueakArraysIn: aFileoutName
	"change method images to sqeak syntax, example: #[12 34 56] to  #(12 34 56)"
	"WebStyle new changeToSqueakArraysIn: 'WebStyle.st' "
	| in out chunk fstream |
	[in := aFileoutName asFilename readStream.
	out := WriteStream on: String new.
	[in atEnd] whileFalse:
		[chunk := in upToAll: '#['. 
		out nextPutAll: chunk. in atEnd not ifTrue: [out nextPutAll: '#(' . in next: 2. ].
		chunk := in upTo: $] . 
		out nextPutAll: chunk. out nextPutAll: ')' ].
	] ensure: [in close].
	aFileoutName asFilename delete.
	[fstream := aFileoutName asFilename writeStream.
	fstream nextPutAll: out contents] 
		ensure: [fstream close].
	^out contents!

ensureJavascriptAndCssForCalendarInHeader
	| page url headerValue |

	page := self app context page.
	url := '/jscalendar/calendar.js'.
	headerValue := ' src="', url, '" language="JavaScript" type="text/javascript"'.
	(page headers contains: [:each | each key = 'script' and: [each value = headerValue] ]) ifFalse: 
		[page addLinkToScreenStyleSheet: '/jscalendar/calendar.css'.
		page addHeader: 'script' value: headerValue.
		page addLinkToJavascript: '/jscalendar/calendar-lang.js'.
		page addLinkToJavascript: '/jscalendar/calendar-setup.js'.
		].!

ensureJavascriptForScriptaculousInHeader
	| page url headerValue |
	page := self app context page.
	url := '/scriptaculous/scriptaculous.js'.
	headerValue := ' src="', url, '" language="JavaScript" type="text/javascript"'.
	(page headers contains: [:each | each key = 'script' and: [each value = headerValue] ]) ifFalse: 
		[page addHeader: 'script' value: headerValue].!

ensureJsResourceForCalendarSetup
	self site urlResolver halfUrlFor: self calendarJsResource.
	self site urlResolver halfUrlFor: self calendarSetupJsResource. 
	self site urlResolver halfUrlFor: self calendarLangJsResource.
	self site urlResolver halfUrlFor: self calendarCSSResource.!

ensureJsResourceForLightbox
	self site urlResolver halfUrlFor: self lightboxJsResource.!

ensureJsResourceForScriptaculous
	self site urlResolver halfUrlFor: self scriptaculousJsResource.
	self site urlResolver halfUrlFor: self scriptaculousBuilderJsResource.
	self site urlResolver halfUrlFor: self scriptaculousEffectsJsResource.
	self site urlResolver halfUrlFor: self scriptaculousDragDropJsResource.
	self site urlResolver halfUrlFor: self scriptaculousControlsJsResource.
	self site urlResolver halfUrlFor: self scriptaculousSliderJsResource.
	self site urlResolver halfUrlFor: self scriptaculousSoundJsResource.!

fontSizeText
	^'font size:'!

galleryNextText
	^'Next'!

galleryPrevText
	^'Previous'!

guestUserText
	^'Guest'!

headerElement
	^WebElement new "subclasses should be more specific"!

helpText
	^'Help'!

importImage: aName from: aFilenameString
	"reads an image, converts it to a method named aName and make that method in 
       method protocol 'imgs'"
	"WebStyle new importImage: 'infoGif' from: 'imgs/info.gif' "
	| fname method |
	fname := aFilenameString asFilename.
	method := fname contentsAsMethod.
	method := aName, (String with: Character cr), method.
	self class compile: method classified: 'imgs'!

importImageFrom: aFilenameString
	"reads an image, converts it to a method and make that method in method protocol 'imgs'"
	"name of a method is composed from a name of a file: arrow.gif = arrowGif"
	"WebStyle new importImageFrom: 'imgs/info.gif' "
	| iname |
	iname := self adjustImageName: aFilenameString asFilename tail. 
	self importImage: iname from: aFilenameString!

importImagesFromDirectory: aDirectoryString
	"reads alss image, converts them to methods and put them in protocol 'imgs'"
	"name of a method is composed from a name of a file: arrow.gif = arrowGif"
	"WebStyle new importImagesFromDirectory: 'imgs/crystalsvg/64' "
	| fnames fname |
	fnames := (SpFilename named: aDirectoryString) directoryContents.
	fnames do: [:each |
		fname := aDirectoryString, (String with: (SpFilename named: aDirectoryString) separator), each.
		(SpFilename named: fname) isDirectory ifFalse: [self importImageFrom: fname] ]!

initResources
	resources := Dictionary new!

inPlaceCancelText
	^'Cancel'!

inPlaceOkText
	^'Ok'!

isBrowserMSIE
	^self session isFromMSIE!

isBrowserNetscape
	^self session isFromNetscape!

javascript
	"concatenate all js* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new javascript"
	| stream |
	stream := WriteStream on: String new. 
	self allJavascriptMethods do: [:method | 
		stream nextPut: Character cr;   nextPut: Character lf.
		stream nextPutAll: ('/*', self class name, ' ', method asString, '*/'). 
		stream nextPut: Character cr;  nextPut: Character lf.
		stream nextPutAll: (self perform: method)].
		stream nextPut: Character cr;  nextPut: Character lf.
	^stream contents!

javascriptResource
	" /scripts.js , returns all js* methods (alphabetically sorted) concatenated "
	"WebStyle new javascriptResource"
	^self resources at: #javascript ifAbsentPut:
		[WebMethodResource 
			fromMethod: #javascript on: self 
			contentType: 'text/javascript' preferedUrl: '/scripts.js' site: self site].!

jsCommon
	"common javaScript methods"
	^'
function nic() 
	{}
function popUpPage(url, parameters, name)
{
}'!

jsPrototypeFramework
	"from two parts, this and #prototypeFrameworkPart2, otherwise is too long for GS"
	^'
/*  Prototype JavaScript framework, version 1.6.0.3
 *  (c) 2005-2008 Sam Stephenson
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *  For details, see the Prototype web site: http://www.prototypejs.org/
 *
 *--------------------------------------------------------------------------*/

var Prototype = {
  Version: ''1.6.0.3'',

  Browser: {
    IE:     !!!!(window.attachEvent &&
      navigator.userAgent.indexOf(''Opera'') === -1),
    Opera:  navigator.userAgent.indexOf(''Opera'') > -1,
    WebKit: navigator.userAgent.indexOf(''AppleWebKit/'') > -1,
    Gecko:  navigator.userAgent.indexOf(''Gecko'') > -1 &&
      navigator.userAgent.indexOf(''KHTML'') === -1,
    MobileSafari: !!!!navigator.userAgent.match(/Apple.*Mobile.*Safari/)
  },

  BrowserFeatures: {
    XPath: !!!!document.evaluate,
    SelectorsAPI: !!!!document.querySelector,
    ElementExtensions: !!!!window.HTMLElement,
    SpecificElementExtensions:
      document.createElement(''div'')[''__proto__''] &&
      document.createElement(''div'')[''__proto__''] !!==
        document.createElement(''form'')[''__proto__'']
  },

  ScriptFragment: ''<script[^>]*>([\\S\\s]*?)<\/script>'',
  JSONFilter: /^\/\*-secure-([\s\S]*)\*\/\s*$/,

  emptyFunction: function() { },
  K: function(x) { return x }
};

if (Prototype.Browser.MobileSafari)
  Prototype.BrowserFeatures.SpecificElementExtensions = false;


/* Based on Alex Arnell''s inheritance implementation. */
var Class = {
  create: function() {
    var parent = null, properties = $A(arguments);
    if (Object.isFunction(properties[0]))
      parent = properties.shift();

    function klass() {
      this.initialize.apply(this, arguments);
    }

    Object.extend(klass, Class.Methods);
    klass.superclass = parent;
    klass.subclasses = [];

    if (parent) {
      var subclass = function() { };
      subclass.prototype = parent.prototype;
      klass.prototype = new subclass;
      parent.subclasses.push(klass);
    }

    for (var i = 0; i < properties.length; i++)
      klass.addMethods(properties[i]);

    if (!!klass.prototype.initialize)
      klass.prototype.initialize = Prototype.emptyFunction;

    klass.prototype.constructor = klass;

    return klass;
  }
};

Class.Methods = {
  addMethods: function(source) {
    var ancestor   = this.superclass && this.superclass.prototype;
    var properties = Object.keys(source);

    if (!!Object.keys({ toString: true }).length)
      properties.push("toString", "valueOf");

    for (var i = 0, length = properties.length; i < length; i++) {
      var property = properties[i], value = source[property];
      if (ancestor && Object.isFunction(value) &&
          value.argumentNames().first() == "$super") {
        var method = value;
        value = (function(m) {
          return function() { return ancestor[m].apply(this, arguments) };
        })(property).wrap(method);

        value.valueOf = method.valueOf.bind(method);
        value.toString = method.toString.bind(method);
      }
      this.prototype[property] = value;
    }

    return this;
  }
};

var Abstract = { };

Object.extend = function(destination, source) {
  for (var property in source)
    destination[property] = source[property];
  return destination;
};

Object.extend(Object, {
  inspect: function(object) {
    try {
      if (Object.isUndefined(object)) return ''undefined'';
      if (object === null) return ''null'';
      return object.inspect ? object.inspect() : String(object);
    } catch (e) {
      if (e instanceof RangeError) return ''...'';
      throw e;
    }
  },

  toJSON: function(object) {
    var type = typeof object;
    switch (type) {
      case ''undefined'':
      case ''function'':
      case ''unknown'': return;
      case ''boolean'': return object.toString();
    }

    if (object === null) return ''null'';
    if (object.toJSON) return object.toJSON();
    if (Object.isElement(object)) return;

    var results = [];
    for (var property in object) {
      var value = Object.toJSON(object[property]);
      if (!!Object.isUndefined(value))
        results.push(property.toJSON() + '': '' + value);
    }

    return ''{'' + results.join('', '') + ''}'';
  },

  toQueryString: function(object) {
    return $H(object).toQueryString();
  },

  toHTML: function(object) {
    return object && object.toHTML ? object.toHTML() : String.interpret(object);
  },

  keys: function(object) {
    var keys = [];
    for (var property in object)
      keys.push(property);
    return keys;
  },

  values: function(object) {
    var values = [];
    for (var property in object)
      values.push(object[property]);
    return values;
  },

  clone: function(object) {
    return Object.extend({ }, object);
  },

  isElement: function(object) {
    return !!!!(object && object.nodeType == 1);
  },

  isArray: function(object) {
    return object !!= null && typeof object == "object" &&
      ''splice'' in object && ''join'' in object;
  },

  isHash: function(object) {
    return object instanceof Hash;
  },

  isFunction: function(object) {
    return typeof object == "function";
  },

  isString: function(object) {
    return typeof object == "string";
  },

  isNumber: function(object) {
    return typeof object == "number";
  },

  isUndefined: function(object) {
    return typeof object == "undefined";
  }
});

Object.extend(Function.prototype, {
  argumentNames: function() {
    var names = this.toString().match(/^[\s\(]*function[^(]*\(([^\)]*)\)/)[1]
      .replace(/\s+/g, '''').split('','');
    return names.length == 1 && !!names[0] ? [] : names;
  },

  bind: function() {
    if (arguments.length < 2 && Object.isUndefined(arguments[0])) return this;
    var __method = this, args = $A(arguments), object = args.shift();
    return function() {
      return __method.apply(object, args.concat($A(arguments)));
    }
  },

  bindAsEventListener: function() {
    var __method = this, args = $A(arguments), object = args.shift();
    return function(event) {
      return __method.apply(object, [event || window.event].concat(args));
    }
  },

  curry: function() {
    if (!!arguments.length) return this;
    var __method = this, args = $A(arguments);
    return function() {
      return __method.apply(this, args.concat($A(arguments)));
    }
  },

  delay: function() {
    var __method = this, args = $A(arguments), timeout = args.shift() * 1000;
    return window.setTimeout(function() {
      return __method.apply(__method, args);
    }, timeout);
  },

  defer: function() {
    var args = [0.01].concat($A(arguments));
    return this.delay.apply(this, args);
  },

  wrap: function(wrapper) {
    var __method = this;
    return function() {
      return wrapper.apply(this, [__method.bind(this)].concat($A(arguments)));
    }
  },

  methodize: function() {
    if (this._methodized) return this._methodized;
    var __method = this;
    return this._methodized = function() {
      return __method.apply(null, [this].concat($A(arguments)));
    };
  }
});

Date.prototype.toJSON = function() {
  return ''"'' + this.getUTCFullYear() + ''-'' +
    (this.getUTCMonth() + 1).toPaddedString(2) + ''-'' +
    this.getUTCDate().toPaddedString(2) + ''T'' +
    this.getUTCHours().toPaddedString(2) + '':'' +
    this.getUTCMinutes().toPaddedString(2) + '':'' +
    this.getUTCSeconds().toPaddedString(2) + ''Z"'';
};

var Try = {
  these: function() {
    var returnValue;

    for (var i = 0, length = arguments.length; i < length; i++) {
      var lambda = arguments[i];
      try {
        returnValue = lambda();
        break;
      } catch (e) { }
    }

    return returnValue;
  }
};

RegExp.prototype.match = RegExp.prototype.test;

RegExp.escape = function(str) {
  return String(str).replace(/([.*+?^=!!:${}()|[\]\/\\])/g, ''\\$1'');
};

/*--------------------------------------------------------------------------*/

var PeriodicalExecuter = Class.create({
  initialize: function(callback, frequency) {
    this.callback = callback;
    this.frequency = frequency;
    this.currentlyExecuting = false;

    this.registerCallback();
  },

  registerCallback: function() {
    this.timer = setInterval(this.onTimerEvent.bind(this), this.frequency * 1000);
  },

  execute: function() {
    this.callback(this);
  },

  stop: function() {
    if (!!this.timer) return;
    clearInterval(this.timer);
    this.timer = null;
  },

  onTimerEvent: function() {
    if (!!this.currentlyExecuting) {
      try {
        this.currentlyExecuting = true;
        this.execute();
      } finally {
        this.currentlyExecuting = false;
      }
    }
  }
});
Object.extend(String, {
  interpret: function(value) {
    return value == null ? '''' : String(value);
  },
  specialChar: {
    ''\b'': ''\\b'',
    ''\t'': ''\\t'',
    ''\n'': ''\\n'',
    ''\f'': ''\\f'',
    ''\r'': ''\\r'',
    ''\\'': ''\\\\''
  }
});

Object.extend(String.prototype, {
  gsub: function(pattern, replacement) {
    var result = '''', source = this, match;
    replacement = arguments.callee.prepareReplacement(replacement);

    while (source.length > 0) {
      if (match = source.match(pattern)) {
        result += source.slice(0, match.index);
        result += String.interpret(replacement(match));
        source  = source.slice(match.index + match[0].length);
      } else {
        result += source, source = '''';
      }
    }
    return result;
  },

  sub: function(pattern, replacement, count) {
    replacement = this.gsub.prepareReplacement(replacement);
    count = Object.isUndefined(count) ? 1 : count;

    return this.gsub(pattern, function(match) {
      if (--count < 0) return match[0];
      return replacement(match);
    });
  },

  scan: function(pattern, iterator) {
    this.gsub(pattern, iterator);
    return String(this);
  },

  truncate: function(length, truncation) {
    length = length || 30;
    truncation = Object.isUndefined(truncation) ? ''...'' : truncation;
    return this.length > length ?
      this.slice(0, length - truncation.length) + truncation : String(this);
  },

  strip: function() {
    return this.replace(/^\s+/, '''').replace(/\s+$/, '''');
  },

  stripTags: function() {
    return this.replace(/<\/?[^>]+>/gi, '''');
  },

  stripScripts: function() {
    return this.replace(new RegExp(Prototype.ScriptFragment, ''img''), '''');
  },

  extractScripts: function() {
    var matchAll = new RegExp(Prototype.ScriptFragment, ''img'');
    var matchOne = new RegExp(Prototype.ScriptFragment, ''im'');
    return (this.match(matchAll) || []).map(function(scriptTag) {
      return (scriptTag.match(matchOne) || ['''', ''''])[1];
    });
  },

  evalScripts: function() {
    return this.extractScripts().map(function(script) { return eval(script) });
  },

  escapeHTML: function() {
    var self = arguments.callee;
    self.text.data = this;
    return self.div.innerHTML;
  },

  unescapeHTML: function() {
    var div = new Element(''div'');
    div.innerHTML = this.stripTags();
    return div.childNodes[0] ? (div.childNodes.length > 1 ?
      $A(div.childNodes).inject('''', function(memo, node) { return memo+node.nodeValue }) :
      div.childNodes[0].nodeValue) : '''';
  },

  toQueryParams: function(separator) {
    var match = this.strip().match(/([^?#]*)(#.*)?$/);
    if (!!match) return { };

    return match[1].split(separator || ''&'').inject({ }, function(hash, pair) {
      if ((pair = pair.split(''=''))[0]) {
        var key = decodeURIComponent(pair.shift());
        var value = pair.length > 1 ? pair.join(''='') : pair[0];
        if (value !!= undefined) value = decodeURIComponent(value);

        if (key in hash) {
          if (!!Object.isArray(hash[key])) hash[key] = [hash[key]];
          hash[key].push(value);
        }
        else hash[key] = value;
      }
      return hash;
    });
  },

  toArray: function() {
    return this.split('''');
  },

  succ: function() {
    return this.slice(0, this.length - 1) +
      String.fromCharCode(this.charCodeAt(this.length - 1) + 1);
  },

  times: function(count) {
    return count < 1 ? '''' : new Array(count + 1).join(this);
  },

  camelize: function() {
    var parts = this.split(''-''), len = parts.length;
    if (len == 1) return parts[0];

    var camelized = this.charAt(0) == ''-''
      ? parts[0].charAt(0).toUpperCase() + parts[0].substring(1)
      : parts[0];

    for (var i = 1; i < len; i++)
      camelized += parts[i].charAt(0).toUpperCase() + parts[i].substring(1);

    return camelized;
  },

  capitalize: function() {
    return this.charAt(0).toUpperCase() + this.substring(1).toLowerCase();
  },

  underscore: function() {
    return this.gsub(/::/, ''/'').gsub(/([A-Z]+)([A-Z][a-z])/,''#{1}_#{2}'').gsub(/([a-z\d])([A-Z])/,''#{1}_#{2}'').gsub(/-/,''_'').toLowerCase();
  },

  dasherize: function() {
    return this.gsub(/_/,''-'');
  },

  inspect: function(useDoubleQuotes) {
    var escapedString = this.gsub(/[\x00-\x1f\\]/, function(match) {
      var character = String.specialChar[match[0]];
      return character ? character : ''\\u00'' + match[0].charCodeAt().toPaddedString(2, 16);
    });
    if (useDoubleQuotes) return ''"'' + escapedString.replace(/"/g, ''\\"'') + ''"'';
    return "''" + escapedString.replace(/''/g, ''\\\'''') + "''";
  },

  toJSON: function() {
    return this.inspect(true);
  },

  unfilterJSON: function(filter) {
    return this.sub(filter || Prototype.JSONFilter, ''#{1}'');
  },

  isJSON: function() {
    var str = this;
    if (str.blank()) return false;
    str = this.replace(/\\./g, ''@'').replace(/"[^"\\\n\r]*"/g, '''');
    return (/^[,:{}\[\]0-9.\-+Eaeflnr-u \n\r\t]*$/).test(str);
  },

  evalJSON: function(sanitize) {
    var json = this.unfilterJSON();
    try {
      if (!!sanitize || json.isJSON()) return eval(''('' + json + '')'');
    } catch (e) { }
    throw new SyntaxError(''Badly formed JSON string: '' + this.inspect());
  },

  include: function(pattern) {
    return this.indexOf(pattern) > -1;
  },

  startsWith: function(pattern) {
    return this.indexOf(pattern) === 0;
  },

  endsWith: function(pattern) {
    var d = this.length - pattern.length;
    return d >= 0 && this.lastIndexOf(pattern) === d;
  },

  empty: function() {
    return this == '''';
  },

  blank: function() {
    return /^\s*$/.test(this);
  },

  interpolate: function(object, pattern) {
    return new Template(this, pattern).evaluate(object);
  }
});

if (Prototype.Browser.WebKit || Prototype.Browser.IE) Object.extend(String.prototype, {
  escapeHTML: function() {
    return this.replace(/&/g,''&amp;'').replace(/</g,''&lt;'').replace(/>/g,''&gt;'');
  },
  unescapeHTML: function() {
    return this.stripTags().replace(/&amp;/g,''&'').replace(/&lt;/g,''<'').replace(/&gt;/g,''>'');
  }
});

String.prototype.gsub.prepareReplacement = function(replacement) {
  if (Object.isFunction(replacement)) return replacement;
  var template = new Template(replacement);
  return function(match) { return template.evaluate(match) };
};

String.prototype.parseQuery = String.prototype.toQueryParams;

Object.extend(String.prototype.escapeHTML, {
  div:  document.createElement(''div''),
  text: document.createTextNode('''')
});

String.prototype.escapeHTML.div.appendChild(String.prototype.escapeHTML.text);

var Template = Class.create({
  initialize: function(template, pattern) {
    this.template = template.toString();
    this.pattern = pattern || Template.Pattern;
  },

  evaluate: function(object) {
    if (Object.isFunction(object.toTemplateReplacements))
      object = object.toTemplateReplacements();

    return this.template.gsub(this.pattern, function(match) {
      if (object == null) return '''';

      var before = match[1] || '''';
      if (before == ''\\'') return match[2];

      var ctx = object, expr = match[3];
      var pattern = /^([^.[]+|\[((?:.*?[^\\])?)\])(\.|\[|$)/;
      match = pattern.exec(expr);
      if (match == null) return before;

      while (match !!= null) {
        var comp = match[1].startsWith(''['') ? match[2].gsub(''\\\\]'', '']'') : match[1];
        ctx = ctx[comp];
        if (null == ctx || '''' == match[3]) break;
        expr = expr.substring(''['' == match[3] ? match[1].length : match[0].length);
        match = pattern.exec(expr);
      }

      return before + String.interpret(ctx);
    });
  }
});
Template.Pattern = /(^|.|\r|\n)(#\{(.*?)\})/;

var $break = { };

var Enumerable = {
  each: function(iterator, context) {
    var index = 0;
    try {
      this._each(function(value) {
        iterator.call(context, value, index++);
      });
    } catch (e) {
      if (e !!= $break) throw e;
    }
    return this;
  },

  eachSlice: function(number, iterator, context) {
    var index = -number, slices = [], array = this.toArray();
    if (number < 1) return array;
    while ((index += number) < array.length)
      slices.push(array.slice(index, index+number));
    return slices.collect(iterator, context);
  },

  all: function(iterator, context) {
    iterator = iterator || Prototype.K;
    var result = true;
    this.each(function(value, index) {
      result = result && !!!!iterator.call(context, value, index);
      if (!!result) throw $break;
    });
    return result;
  },

  any: function(iterator, context) {
    iterator = iterator || Prototype.K;
    var result = false;
    this.each(function(value, index) {
      if (result = !!!!iterator.call(context, value, index))
        throw $break;
    });
    return result;
  },

  collect: function(iterator, context) {
    iterator = iterator || Prototype.K;
    var results = [];
    this.each(function(value, index) {
      results.push(iterator.call(context, value, index));
    });
    return results;
  },

  detect: function(iterator, context) {
    var result;
    this.each(function(value, index) {
      if (iterator.call(context, value, index)) {
        result = value;
        throw $break;
      }
    });
    return result;
  },

  findAll: function(iterator, context) {
    var results = [];
    this.each(function(value, index) {
      if (iterator.call(context, value, index))
        results.push(value);
    });
    return results;
  },

  grep: function(filter, iterator, context) {
    iterator = iterator || Prototype.K;
    var results = [];

    if (Object.isString(filter))
      filter = new RegExp(filter);

    this.each(function(value, index) {
      if (filter.match(value))
        results.push(iterator.call(context, value, index));
    });
    return results;
  },

  include: function(object) {
    if (Object.isFunction(this.indexOf))
      if (this.indexOf(object) !!= -1) return true;

    var found = false;
    this.each(function(value) {
      if (value == object) {
        found = true;
        throw $break;
      }
    });
    return found;
  },

  inGroupsOf: function(number, fillWith) {
    fillWith = Object.isUndefined(fillWith) ? null : fillWith;
    return this.eachSlice(number, function(slice) {
      while(slice.length < number) slice.push(fillWith);
      return slice;
    });
  },

  inject: function(memo, iterator, context) {
    this.each(function(value, index) {
      memo = iterator.call(context, memo, value, index);
    });
    return memo;
  },

  invoke: function(method) {
    var args = $A(arguments).slice(1);
    return this.map(function(value) {
      return value[method].apply(value, args);
    });
  },

  max: function(iterator, context) {
    iterator = iterator || Prototype.K;
    var result;
    this.each(function(value, index) {
      value = iterator.call(context, value, index);
      if (result == null || value >= result)
        result = value;
    });
    return result;
  },

  min: function(iterator, context) {
    iterator = iterator || Prototype.K;
    var result;
    this.each(function(value, index) {
      value = iterator.call(context, value, index);
      if (result == null || value < result)
        result = value;
    });
    return result;
  },

  partition: function(iterator, context) {
    iterator = iterator || Prototype.K;
    var trues = [], falses = [];
    this.each(function(value, index) {
      (iterator.call(context, value, index) ?
        trues : falses).push(value);
    });
    return [trues, falses];
  },

  pluck: function(property) {
    var results = [];
    this.each(function(value) {
      results.push(value[property]);
    });
    return results;
  },

  reject: function(iterator, context) {
    var results = [];
    this.each(function(value, index) {
      if (!!iterator.call(context, value, index))
        results.push(value);
    });
    return results;
  },

  sortBy: function(iterator, context) {
    return this.map(function(value, index) {
      return {
        value: value,
        criteria: iterator.call(context, value, index)
      };
    }).sort(function(left, right) {
      var a = left.criteria, b = right.criteria;
      return a < b ? -1 : a > b ? 1 : 0;
    }).pluck(''value'');
  },

  toArray: function() {
    return this.map();
  },

  zip: function() {
    var iterator = Prototype.K, args = $A(arguments);
    if (Object.isFunction(args.last()))
      iterator = args.pop();

    var collections = [this].concat(args).map($A);
    return this.map(function(value, index) {
      return iterator(collections.pluck(index));
    });
  },

  size: function() {
    return this.toArray().length;
  },

  inspect: function() {
    return ''#<Enumerable:'' + this.toArray().inspect() + ''>'';
  }
};

Object.extend(Enumerable, {
  map:     Enumerable.collect,
  find:    Enumerable.detect,
  select:  Enumerable.findAll,
  filter:  Enumerable.findAll,
  member:  Enumerable.include,
  entries: Enumerable.toArray,
  every:   Enumerable.all,
  some:    Enumerable.any
});
function $A(iterable) {
  if (!!iterable) return [];
  if (iterable.toArray) return iterable.toArray();
  var length = iterable.length || 0, results = new Array(length);
  while (length--) results[length] = iterable[length];
  return results;
}

if (Prototype.Browser.WebKit) {
  $A = function(iterable) {
    if (!!iterable) return [];
    // In Safari, only use the `toArray` method if it''s not a NodeList.
    // A NodeList is a function, has an function `item` property, and a numeric
    // `length` property. Adapted from Google Doctype.
    if (!!(typeof iterable === ''function'' && typeof iterable.length ===
        ''number'' && typeof iterable.item === ''function'') && iterable.toArray)
      return iterable.toArray();
    var length = iterable.length || 0, results = new Array(length);
    while (length--) results[length] = iterable[length];
    return results;
  };
}

Array.from = $A;

Object.extend(Array.prototype, Enumerable);

if (!!Array.prototype._reverse) Array.prototype._reverse = Array.prototype.reverse;

Object.extend(Array.prototype, {
  _each: function(iterator) {
    for (var i = 0, length = this.length; i < length; i++)
      iterator(this[i]);
  },

  clear: function() {
    this.length = 0;
    return this;
  },

  first: function() {
    return this[0];
  },

  last: function() {
    return this[this.length - 1];
  },

  compact: function() {
    return this.select(function(value) {
      return value !!= null;
    });
  },

  flatten: function() {
    return this.inject([], function(array, value) {
      return array.concat(Object.isArray(value) ?
        value.flatten() : [value]);
    });
  },

  without: function() {
    var values = $A(arguments);
    return this.select(function(value) {
      return !!values.include(value);
    });
  },

  reverse: function(inline) {
    return (inline !!== false ? this : this.toArray())._reverse();
  },

  reduce: function() {
    return this.length > 1 ? this : this[0];
  },

  uniq: function(sorted) {
    return this.inject([], function(array, value, index) {
      if (0 == index || (sorted ? array.last() !!= value : !!array.include(value)))
        array.push(value);
      return array;
    });
  },

  intersect: function(array) {
    return this.uniq().findAll(function(item) {
      return array.detect(function(value) { return item === value });
    });
  },

  clone: function() {
    return [].concat(this);
  },

  size: function() {
    return this.length;
  },

  inspect: function() {
    return ''['' + this.map(Object.inspect).join('', '') + '']'';
  },

  toJSON: function() {
    var results = [];
    this.each(function(object) {
      var value = Object.toJSON(object);
      if (!!Object.isUndefined(value)) results.push(value);
    });
    return ''['' + results.join('', '') + '']'';
  }
});

// use native browser JS 1.6 implementation if available
if (Object.isFunction(Array.prototype.forEach))
  Array.prototype._each = Array.prototype.forEach;

if (!!Array.prototype.indexOf) Array.prototype.indexOf = function(item, i) {
  i || (i = 0);
  var length = this.length;
  if (i < 0) i = length + i;
  for (; i < length; i++)
    if (this[i] === item) return i;
  return -1;
};

if (!!Array.prototype.lastIndexOf) Array.prototype.lastIndexOf = function(item, i) {
  i = isNaN(i) ? this.length : (i < 0 ? this.length + i : i) + 1;
  var n = this.slice(0, i).reverse().indexOf(item);
  return (n < 0) ? n : i - n - 1;
};

Array.prototype.toArray = Array.prototype.clone;

function $w(string) {
  if (!!Object.isString(string)) return [];
  string = string.strip();
  return string ? string.split(/\s+/) : [];
}

if (Prototype.Browser.Opera){
  Array.prototype.concat = function() {
    var array = [];
    for (var i = 0, length = this.length; i < length; i++) array.push(this[i]);
    for (var i = 0, length = arguments.length; i < length; i++) {
      if (Object.isArray(arguments[i])) {
        for (var j = 0, arrayLength = arguments[i].length; j < arrayLength; j++)
          array.push(arguments[i][j]);
      } else {
        array.push(arguments[i]);
      }
    }
    return array;
  };
}
Object.extend(Number.prototype, {
  toColorPart: function() {
    return this.toPaddedString(2, 16);
  },

  succ: function() {
    return this + 1;
  },

  times: function(iterator, context) {
    $R(0, this, true).each(iterator, context);
    return this;
  },

  toPaddedString: function(length, radix) {
    var string = this.toString(radix || 10);
    return ''0''.times(length - string.length) + string;
  },

  toJSON: function() {
    return isFinite(this) ? this.toString() : ''null'';
  }
});

$w(''abs round ceil floor'').each(function(method){
  Number.prototype[method] = Math[method].methodize();
});
function $H(object) {
  return new Hash(object);
};

var Hash = Class.create(Enumerable, (function() {

  function toQueryPair(key, value) {
    if (Object.isUndefined(value)) return key;
    return key + ''='' + encodeURIComponent(String.interpret(value));
  }

  return {
    initialize: function(object) {
      this._object = Object.isHash(object) ? object.toObject() : Object.clone(object);
    },

    _each: function(iterator) {
      for (var key in this._object) {
        var value = this._object[key], pair = [key, value];
        pair.key = key;
        pair.value = value;
        iterator(pair);
      }
    },

    set: function(key, value) {
      return this._object[key] = value;
    },

    get: function(key) {
      // simulating poorly supported hasOwnProperty
      if (this._object[key] !!== Object.prototype[key])
        return this._object[key];
    },

    unset: function(key) {
      var value = this._object[key];
      delete this._object[key];
      return value;
    },

    toObject: function() {
      return Object.clone(this._object);
    },

    keys: function() {
      return this.pluck(''key'');
    },

    values: function() {
      return this.pluck(''value'');
    },

    index: function(value) {
      var match = this.detect(function(pair) {
        return pair.value === value;
      });
      return match && match.key;
    },

    merge: function(object) {
      return this.clone().update(object);
    },

    update: function(object) {
      return new Hash(object).inject(this, function(result, pair) {
        result.set(pair.key, pair.value);
        return result;
      });
    },

    toQueryString: function() {
      return this.inject([], function(results, pair) {
        var key = encodeURIComponent(pair.key), values = pair.value;

        if (values && typeof values == ''object'') {
          if (Object.isArray(values))
            return results.concat(values.map(toQueryPair.curry(key)));
        } else results.push(toQueryPair(key, values));
        return results;
      }).join(''&'');
    },

    inspect: function() {
      return ''#<Hash:{'' + this.map(function(pair) {
        return pair.map(Object.inspect).join('': '');
      }).join('', '') + ''}>'';
    },

    toJSON: function() {
      return Object.toJSON(this.toObject());
    },

    clone: function() {
      return new Hash(this);
    }
  }
})());

Hash.prototype.toTemplateReplacements = Hash.prototype.toObject;
Hash.from = $H;
var ObjectRange = Class.create(Enumerable, {
  initialize: function(start, end, exclusive) {
    this.start = start;
    this.end = end;
    this.exclusive = exclusive;
  },

  _each: function(iterator) {
    var value = this.start;
    while (this.include(value)) {
      iterator(value);
      value = value.succ();
    }
  },

  include: function(value) {
    if (value < this.start)
      return false;
    if (this.exclusive)
      return value < this.end;
    return value <= this.end;
  }
});

var $R = function(start, end, exclusive) {
  return new ObjectRange(start, end, exclusive);
};

var Ajax = {
  getTransport: function() {
    return Try.these(
      function() {return new XMLHttpRequest()},
      function() {return new ActiveXObject(''Msxml2.XMLHTTP'')},
      function() {return new ActiveXObject(''Microsoft.XMLHTTP'')}
    ) || false;
  },

  activeRequestCount: 0
};

Ajax.Responders = {
  responders: [],

  _each: function(iterator) {
    this.responders._each(iterator);
  },

  register: function(responder) {
    if (!!this.include(responder))
      this.responders.push(responder);
  },

  unregister: function(responder) {
    this.responders = this.responders.without(responder);
  },

  dispatch: function(callback, request, transport, json) {
    this.each(function(responder) {
      if (Object.isFunction(responder[callback])) {
        try {
          responder[callback].apply(responder, [request, transport, json]);
        } catch (e) { }
      }
    });
  }
};

Object.extend(Ajax.Responders, Enumerable);

Ajax.Responders.register({
  onCreate:   function() { Ajax.activeRequestCount++ },
  onComplete: function() { Ajax.activeRequestCount-- }
});

Ajax.Base = Class.create({
  initialize: function(options) {
    this.options = {
      method:       ''post'',
      asynchronous: true,
      contentType:  ''application/x-www-form-urlencoded'',
      encoding:     ''UTF-8'',
      parameters:   '''',
      evalJSON:     true,
      evalJS:       true
    };
    Object.extend(this.options, options || { });

    this.options.method = this.options.method.toLowerCase();

    if (Object.isString(this.options.parameters))
      this.options.parameters = this.options.parameters.toQueryParams();
    else if (Object.isHash(this.options.parameters))
      this.options.parameters = this.options.parameters.toObject();
  }
});

Ajax.Request = Class.create(Ajax.Base, {
  _complete: false,

  initialize: function($super, url, options) {
    $super(options);
    this.transport = Ajax.getTransport();
    this.request(url);
  },

  request: function(url) {
    this.url = url;
    this.method = this.options.method;
    var params = Object.clone(this.options.parameters);

    if (!![''get'', ''post''].include(this.method)) {
      // simulate other verbs over post
      params[''_method''] = this.method;
      this.method = ''post'';
    }

    this.parameters = params;

    if (params = Object.toQueryString(params)) {
      // when GET, append parameters to URL
      if (this.method == ''get'')
        this.url += (this.url.include(''?'') ? ''&'' : ''?'') + params;
      else if (/Konqueror|Safari|KHTML/.test(navigator.userAgent))
        params += ''&_='';
    }

    try {
      var response = new Ajax.Response(this);
      if (this.options.onCreate) this.options.onCreate(response);
      Ajax.Responders.dispatch(''onCreate'', this, response);

      this.transport.open(this.method.toUpperCase(), this.url,
        this.options.asynchronous);

      if (this.options.asynchronous) this.respondToReadyState.bind(this).defer(1);

      this.transport.onreadystatechange = this.onStateChange.bind(this);
      this.setRequestHeaders();

      this.body = this.method == ''post'' ? (this.options.postBody || params) : null;
      this.transport.send(this.body);

      /* Force Firefox to handle ready state 4 for synchronous requests */
      if (!!this.options.asynchronous && this.transport.overrideMimeType)
        this.onStateChange();

    }
    catch (e) {
      this.dispatchException(e);
    }
  },

  onStateChange: function() {
    var readyState = this.transport.readyState;
    if (readyState > 1 && !!((readyState == 4) && this._complete))
      this.respondToReadyState(this.transport.readyState);
  },

  setRequestHeaders: function() {
    var headers = {
      ''X-Requested-With'': ''XMLHttpRequest'',
      ''X-Prototype-Version'': Prototype.Version,
      ''Accept'': ''text/javascript, text/html, application/xml, text/xml, */*''
    };

    if (this.method == ''post'') {
      headers[''Content-type''] = this.options.contentType +
        (this.options.encoding ? ''; charset='' + this.options.encoding : '''');

      /* Force "Connection: close" for older Mozilla browsers to work
       * around a bug where XMLHttpRequest sends an incorrect
       * Content-length header. See Mozilla Bugzilla #246651.
       */
      if (this.transport.overrideMimeType &&
          (navigator.userAgent.match(/Gecko\/(\d{4})/) || [0,2005])[1] < 2005)
            headers[''Connection''] = ''close'';
    }

    // user-defined headers
    if (typeof this.options.requestHeaders == ''object'') {
      var extras = this.options.requestHeaders;

      if (Object.isFunction(extras.push))
        for (var i = 0, length = extras.length; i < length; i += 2)
          headers[extras[i]] = extras[i+1];
      else
        $H(extras).each(function(pair) { headers[pair.key] = pair.value });
    }

    for (var name in headers)
      this.transport.setRequestHeader(name, headers[name]);
  },

  success: function() {
    var status = this.getStatus();
    return !!status || (status >= 200 && status < 300);
  },

  getStatus: function() {
    try {
      return this.transport.status || 0;
    } catch (e) { return 0 }
  },

  respondToReadyState: function(readyState) {
    var state = Ajax.Request.Events[readyState], response = new Ajax.Response(this);

    if (state == ''Complete'') {
      try {
        this._complete = true;
        (this.options[''on'' + response.status]
         || this.options[''on'' + (this.success() ? ''Success'' : ''Failure'')]
         || Prototype.emptyFunction)(response, response.headerJSON);
      } catch (e) {
        this.dispatchException(e);
      }

      var contentType = response.getHeader(''Content-type'');
      if (this.options.evalJS == ''force''
          || (this.options.evalJS && this.isSameOrigin() && contentType
          && contentType.match(/^\s*(text|application)\/(x-)?(java|ecma)script(;.*)?\s*$/i)))
        this.evalResponse();
    }

    try {
      (this.options[''on'' + state] || Prototype.emptyFunction)(response, response.headerJSON);
      Ajax.Responders.dispatch(''on'' + state, this, response, response.headerJSON);
    } catch (e) {
      this.dispatchException(e);
    }

    if (state == ''Complete'') {
      // avoid memory leak in MSIE: clean up
      this.transport.onreadystatechange = Prototype.emptyFunction;
    }
  },

  isSameOrigin: function() {
    var m = this.url.match(/^\s*https?:\/\/[^\/]*/);
    return !!m || (m[0] == ''#{protocol}//#{domain}#{port}''.interpolate({
      protocol: location.protocol,
      domain: document.domain,
      port: location.port ? '':'' + location.port : ''''
    }));
  },

  getHeader: function(name) {
    try {
      return this.transport.getResponseHeader(name) || null;
    } catch (e) { return null }
  },

  evalResponse: function() {
    try {
      return eval((this.transport.responseText || '''').unfilterJSON());
    } catch (e) {
      this.dispatchException(e);
    }
  },

  dispatchException: function(exception) {
    (this.options.onException || Prototype.emptyFunction)(this, exception);
    Ajax.Responders.dispatch(''onException'', this, exception);
  }
});

Ajax.Request.Events =
  [''Uninitialized'', ''Loading'', ''Loaded'', ''Interactive'', ''Complete''];

Ajax.Response = Class.create({
  initialize: function(request){
    this.request = request;
    var transport  = this.transport  = request.transport,
        readyState = this.readyState = transport.readyState;

    if((readyState > 2 && !!Prototype.Browser.IE) || readyState == 4) {
      this.status       = this.getStatus();
      this.statusText   = this.getStatusText();
      this.responseText = String.interpret(transport.responseText);
      this.headerJSON   = this._getHeaderJSON();
    }

    if(readyState == 4) {
      var xml = transport.responseXML;
      this.responseXML  = Object.isUndefined(xml) ? null : xml;
      this.responseJSON = this._getResponseJSON();
    }
  },

  status:      0,
  statusText: '''',

  getStatus: Ajax.Request.prototype.getStatus,

  getStatusText: function() {
    try {
      return this.transport.statusText || '''';
    } catch (e) { return '''' }
  },

  getHeader: Ajax.Request.prototype.getHeader,

  getAllHeaders: function() {
    try {
      return this.getAllResponseHeaders();
    } catch (e) { return null }
  },

  getResponseHeader: function(name) {
    return this.transport.getResponseHeader(name);
  },

  getAllResponseHeaders: function() {
    return this.transport.getAllResponseHeaders();
  },

  _getHeaderJSON: function() {
    var json = this.getHeader(''X-JSON'');
    if (!!json) return null;
    json = decodeURIComponent(escape(json));
    try {
      return json.evalJSON(this.request.options.sanitizeJSON ||
        !!this.request.isSameOrigin());
    } catch (e) {
      this.request.dispatchException(e);
    }
  },

  _getResponseJSON: function() {
    var options = this.request.options;
    if (!!options.evalJSON || (options.evalJSON !!= ''force'' &&
      !!(this.getHeader(''Content-type'') || '''').include(''application/json'')) ||
        this.responseText.blank())
          return null;
    try {
      return this.responseText.evalJSON(options.sanitizeJSON ||
        !!this.request.isSameOrigin());
    } catch (e) {
      this.request.dispatchException(e);
    }
  }
});

Ajax.Updater = Class.create(Ajax.Request, {
  initialize: function($super, container, url, options) {
    this.container = {
      success: (container.success || container),
      failure: (container.failure || (container.success ? null : container))
    };

    options = Object.clone(options);
    var onComplete = options.onComplete;
    options.onComplete = (function(response, json) {
      this.updateContent(response.responseText);
      if (Object.isFunction(onComplete)) onComplete(response, json);
    }).bind(this);

    $super(url, options);
  },

  updateContent: function(responseText) {
    var receiver = this.container[this.success() ? ''success'' : ''failure''],
        options = this.options;

    if (!!options.evalScripts) responseText = responseText.stripScripts();

    if (receiver = $(receiver)) {
      if (options.insertion) {
        if (Object.isString(options.insertion)) {
          var insertion = { }; insertion[options.insertion] = responseText;
          receiver.insert(insertion);
        }
        else options.insertion(receiver, responseText);
      }
      else receiver.update(responseText);
    }
  }
});

Ajax.PeriodicalUpdater = Class.create(Ajax.Base, {
  initialize: function($super, container, url, options) {
    $super(options);
    this.onComplete = this.options.onComplete;

    this.frequency = (this.options.frequency || 2);
    this.decay = (this.options.decay || 1);

    this.updater = { };
    this.container = container;
    this.url = url;

    this.start();
  },

  start: function() {
    this.options.onComplete = this.updateComplete.bind(this);
    this.onTimerEvent();
  },

  stop: function() {
    this.updater.options.onComplete = undefined;
    clearTimeout(this.timer);
    (this.onComplete || Prototype.emptyFunction).apply(this, arguments);
  },

  updateComplete: function(response) {
    if (this.options.decay) {
      this.decay = (response.responseText == this.lastText ?
        this.decay * this.options.decay : 1);

      this.lastText = response.responseText;
    }
    this.timer = this.onTimerEvent.bind(this).delay(this.decay * this.frequency);
  },

  onTimerEvent: function() {
    this.updater = new Ajax.Updater(this.container, this.url, this.options);
  }
});
function $(element) {
  if (arguments.length > 1) {
    for (var i = 0, elements = [], length = arguments.length; i < length; i++)
      elements.push($(arguments[i]));
    return elements;
  }
  if (Object.isString(element))
    element = document.getElementById(element);
  return Element.extend(element);
}

if (Prototype.BrowserFeatures.XPath) {
  document._getElementsByXPath = function(expression, parentElement) {
    var results = [];
    var query = document.evaluate(expression, $(parentElement) || document,
      null, XPathResult.ORDERED_NODE_SNAPSHOT_TYPE, null);
    for (var i = 0, length = query.snapshotLength; i < length; i++)
      results.push(Element.extend(query.snapshotItem(i)));
    return results;
  };
}
', self prototypeFrameworkPart2!

jsPrtAIDADelayedObserver
^'
// Copy of DeayedObserver from Scriptaculous, here to avoid loading full Scriptaculous!!
// Delayed observer, like Form.Element.Observer, 
// but waits for delay after last key input
// Ideal for live-search fields

Form.Element.AIDADelayedObserver = Class.create();
Form.Element.AIDADelayedObserver.prototype = {
  initialize: function(element, delay, callback) {
    this.delay     = delay || 0.5;
    this.element   = $(element);
    this.callback  = callback;
    this.timer     = null;
    this.lastValue = $F(this.element); 
    Event.observe(this.element,''keyup'',this.delayedListener.bindAsEventListener(this));
  },
  delayedListener: function(event) {
    if(this.lastValue == $F(this.element)) return;
    if(this.timer) clearTimeout(this.timer);
    this.timer = setTimeout(this.onTimerEvent.bind(this), this.delay * 1000);
    this.lastValue = $F(this.element);
  },
  onTimerEvent: function() {
    this.timer = null;
    this.callback(this.element, $F(this.element));
  }
};
'!

lightboxJs
	"Author: Lukas Renggli, modified by Janko Mivsek,
	Original script from Seaside-Scriptaculous package, SULightbox class"
	^ 'Object.extend(Position, {
	windowBounds: function() {
		var x = window.innerWidth
			|| document.documentElement.clientWidth
			|| document.body.clientWidth
			|| 0;
		var y = window.innerHeight
			|| document.documentElement.clientHeight
			|| document.body.clientHeight
			|| 0;
		return [x, y];
	}
});
Object.extend(Element, {
	fullscreen: function(element, zindex) {
		element = $(element);
		var bounds = Position.windowBounds();
		element.style.position = "absolute";
		element.style.left = element.style.top = 0;
		element.style.width = bounds[0] + "px";
		element.style.height = bounds[1] + "px";
		element.style.zIndex = zindex;
	},
	center: function(element, zindex) {
		element = $(element);
		var extent = Element.getDimensions(element);
		var bounds = Position.windowBounds();
		var x = (bounds[0] - extent.width) / 2;
		var y = (bounds[1] - extent.height) / 2;
		x = x < 0 ? 0 : x; y = y < 0 ? 0 : y;
		element.style.position = "absolute";
		element.style.left = x + "px";
		element.style.top = y + "px";
		element.style.zIndex = zindex;
	}
});
function updateLightboxLevel(level) {
	Element.fullscreen("overlay"+level, 9000+level*2);
	Element.center("lightbox"+level, 9001+level*2);
	Element.show("lightbox"+level);
};
function closeLightboxLevel(level) {
	$("overlay"+level).replace("");
	$("lightbox"+level).replace("");
};
function updateLightbox() {
	updateLightboxLevel(0);
};
function closeLightbox() {
	closeLightboxLevel(0);
};
'!

lightboxJsResource
	^self resources at: #jsLightbox ifAbsentPut:
		[WebMethodResource 
			fromMethod: #lightboxJs on: self 
			contentType: 'text/javascript' preferedUrl: '/lightbox.js' site: self site].!

loginBelowMessage
	^''!

loginButton
	^'Login'!

loginErrorText
	^'<b style={color:red}>Login failed!! Please check your entry and try again!!</b>'!

loginErrorTextSecondary
	"for WebAdminApp viewLoginSecondary, Override this for your needs"
	^'Secondary error'!

loginText
	^'Login'!

loginTitle
	^'AIDA/Web Login'!

loginWelcomeMessage
	^'<h1>Welcome to AIDA/Web Smalltalk Web Application Server!!</h1>
      <br><br>
      Please login to enter a site: '!

logoutText
	^'Logout'!

navigationBarElement
	^WebElement new "subclasses should be more specific"!

observee

	^self app observee!

pageContentWidth
	^660!

pageFrameWith: aWebElement title: aTitleString
	"set a web page with standard  page look (navigation bar, header) "
	^self pageFrameWith: aWebElement wide: WebElement new title: aTitleString!

pageFrameWith: aWebElement wide: aWideElement title: aTitleString
	"set a web page with standard  page look (navigation bar, header) "
	"Wide element comes below content besides navigation and it have full page width"
	| e |
	self app clear; title: aTitleString.
	e := WebElement new
		add: self headerElement; 	
		add: (WebElement new add: self navigationBarElement; add: aWebElement;  yourself); 
		add: (WebElement new add: aWideElement; yourself);
		yourself.
	^self app add: e; yourself!

pageWidth
	^800!

passwordText
	^'Password: '!

printCssResource
	" /print.css , returns all cssPrint* methods (alphabetically sorted) concatenated "
	"WebStyle new printCssResource"
	^self resources at: #cssPrint ifAbsentPut:
		[WebMethodResource 
			fromMethod: #printStyleSheet on: self 
			contentType: 'text/css' preferedUrl: '/print.css' site: self site].!

printStyleSheet
	"concatenate all cssPrint* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new printStyleSheet"
	| stream content |
	stream := WriteStream on: String new.
	self allCssPrintMethods do: [:method | 
		content := self perform: method.
		content notEmpty ifTrue: 
			[stream nextPut: Character cr.
			stream nextPutAll: ('/*', (self class classNameFor: method), ' ', method asString, '*/').
			stream nextPut: Character cr.
			stream nextPutAll: content] ].
	^stream contents!

prototypeFrameworkPart2
"because on Gemstone it is too long"
	^'
/*--------------------------------------------------------------------------*/

if (!!window.Node) var Node = { };

if (!!Node.ELEMENT_NODE) {
  // DOM level 2 ECMAScript Language Binding
  Object.extend(Node, {
    ELEMENT_NODE: 1,
    ATTRIBUTE_NODE: 2,
    TEXT_NODE: 3,
    CDATA_SECTION_NODE: 4,
    ENTITY_REFERENCE_NODE: 5,
    ENTITY_NODE: 6,
    PROCESSING_INSTRUCTION_NODE: 7,
    COMMENT_NODE: 8,
    DOCUMENT_NODE: 9,
    DOCUMENT_TYPE_NODE: 10,
    DOCUMENT_FRAGMENT_NODE: 11,
    NOTATION_NODE: 12
  });
}

(function() {
  var element = this.Element;
  this.Element = function(tagName, attributes) {
    attributes = attributes || { };
    tagName = tagName.toLowerCase();
    var cache = Element.cache;
    if (Prototype.Browser.IE && attributes.name) {
      tagName = ''<'' + tagName + '' name="'' + attributes.name + ''">'';
      delete attributes.name;
      return Element.writeAttribute(document.createElement(tagName), attributes);
    }
    if (!!cache[tagName]) cache[tagName] = Element.extend(document.createElement(tagName));
    return Element.writeAttribute(cache[tagName].cloneNode(false), attributes);
  };
  Object.extend(this.Element, element || { });
  if (element) this.Element.prototype = element.prototype;
}).call(window);

Element.cache = { };

Element.Methods = {
  visible: function(element) {
    return $(element).style.display !!= ''none'';
  },

  toggle: function(element) {
    element = $(element);
    Element[Element.visible(element) ? ''hide'' : ''show''](element);
    return element;
  },

  hide: function(element) {
    element = $(element);
    element.style.display = ''none'';
    return element;
  },

  show: function(element) {
    element = $(element);
    element.style.display = '''';
    return element;
  },

  remove: function(element) {
    element = $(element);
    element.parentNode.removeChild(element);
    return element;
  },

  update: function(element, content) {
    element = $(element);
    if (content && content.toElement) content = content.toElement();
    if (Object.isElement(content)) return element.update().insert(content);
    content = Object.toHTML(content);
    element.innerHTML = content.stripScripts();
    content.evalScripts.bind(content).defer();
    return element;
  },

  replace: function(element, content) {
    element = $(element);
    if (content && content.toElement) content = content.toElement();
    else if (!!Object.isElement(content)) {
      content = Object.toHTML(content);
      var range = element.ownerDocument.createRange();
      range.selectNode(element);
      content.evalScripts.bind(content).defer();
      content = range.createContextualFragment(content.stripScripts());
    }
    element.parentNode.replaceChild(content, element);
    return element;
  },

  insert: function(element, insertions) {
    element = $(element);

    if (Object.isString(insertions) || Object.isNumber(insertions) ||
        Object.isElement(insertions) || (insertions && (insertions.toElement || insertions.toHTML)))
          insertions = {bottom:insertions};

    var content, insert, tagName, childNodes;

    for (var position in insertions) {
      content  = insertions[position];
      position = position.toLowerCase();
      insert = Element._insertionTranslations[position];

      if (content && content.toElement) content = content.toElement();
      if (Object.isElement(content)) {
        insert(element, content);
        continue;
      }

      content = Object.toHTML(content);

      tagName = ((position == ''before'' || position == ''after'')
        ? element.parentNode : element).tagName.toUpperCase();

      childNodes = Element._getContentFromAnonymousElement(tagName, content.stripScripts());

      if (position == ''top'' || position == ''after'') childNodes.reverse();
      childNodes.each(insert.curry(element));

      content.evalScripts.bind(content).defer();
    }

    return element;
  },

  wrap: function(element, wrapper, attributes) {
    element = $(element);
    if (Object.isElement(wrapper))
      $(wrapper).writeAttribute(attributes || { });
    else if (Object.isString(wrapper)) wrapper = new Element(wrapper, attributes);
    else wrapper = new Element(''div'', wrapper);
    if (element.parentNode)
      element.parentNode.replaceChild(wrapper, element);
    wrapper.appendChild(element);
    return wrapper;
  },

  inspect: function(element) {
    element = $(element);
    var result = ''<'' + element.tagName.toLowerCase();
    $H({''id'': ''id'', ''className'': ''class''}).each(function(pair) {
      var property = pair.first(), attribute = pair.last();
      var value = (element[property] || '''').toString();
      if (value) result += '' '' + attribute + ''='' + value.inspect(true);
    });
    return result + ''>'';
  },

  recursivelyCollect: function(element, property) {
    element = $(element);
    var elements = [];
    while (element = element[property])
      if (element.nodeType == 1)
        elements.push(Element.extend(element));
    return elements;
  },

  ancestors: function(element) {
    return $(element).recursivelyCollect(''parentNode'');
  },

  descendants: function(element) {
    return $(element).select("*");
  },

  firstDescendant: function(element) {
    element = $(element).firstChild;
    while (element && element.nodeType !!= 1) element = element.nextSibling;
    return $(element);
  },

  immediateDescendants: function(element) {
    if (!!(element = $(element).firstChild)) return [];
    while (element && element.nodeType !!= 1) element = element.nextSibling;
    if (element) return [element].concat($(element).nextSiblings());
    return [];
  },

  previousSiblings: function(element) {
    return $(element).recursivelyCollect(''previousSibling'');
  },

  nextSiblings: function(element) {
    return $(element).recursivelyCollect(''nextSibling'');
  },

  siblings: function(element) {
    element = $(element);
    return element.previousSiblings().reverse().concat(element.nextSiblings());
  },

  match: function(element, selector) {
    if (Object.isString(selector))
      selector = new Selector(selector);
    return selector.match($(element));
  },

  up: function(element, expression, index) {
    element = $(element);
    if (arguments.length == 1) return $(element.parentNode);
    var ancestors = element.ancestors();
    return Object.isNumber(expression) ? ancestors[expression] :
      Selector.findElement(ancestors, expression, index);
  },

  down: function(element, expression, index) {
    element = $(element);
    if (arguments.length == 1) return element.firstDescendant();
    return Object.isNumber(expression) ? element.descendants()[expression] :
      Element.select(element, expression)[index || 0];
  },

  previous: function(element, expression, index) {
    element = $(element);
    if (arguments.length == 1) return $(Selector.handlers.previousElementSibling(element));
    var previousSiblings = element.previousSiblings();
    return Object.isNumber(expression) ? previousSiblings[expression] :
      Selector.findElement(previousSiblings, expression, index);
  },

  next: function(element, expression, index) {
    element = $(element);
    if (arguments.length == 1) return $(Selector.handlers.nextElementSibling(element));
    var nextSiblings = element.nextSiblings();
    return Object.isNumber(expression) ? nextSiblings[expression] :
      Selector.findElement(nextSiblings, expression, index);
  },

  select: function() {
    var args = $A(arguments), element = $(args.shift());
    return Selector.findChildElements(element, args);
  },

  adjacent: function() {
    var args = $A(arguments), element = $(args.shift());
    return Selector.findChildElements(element.parentNode, args).without(element);
  },

  identify: function(element) {
    element = $(element);
    var id = element.readAttribute(''id''), self = arguments.callee;
    if (id) return id;
    do { id = ''anonymous_element_'' + self.counter++ } while ($(id));
    element.writeAttribute(''id'', id);
    return id;
  },

  readAttribute: function(element, name) {
    element = $(element);
    if (Prototype.Browser.IE) {
      var t = Element._attributeTranslations.read;
      if (t.values[name]) return t.values[name](element, name);
      if (t.names[name]) name = t.names[name];
      if (name.include('':'')) {
        return (!!element.attributes || !!element.attributes[name]) ? null :
         element.attributes[name].value;
      }
    }
    return element.getAttribute(name);
  },

  writeAttribute: function(element, name, value) {
    element = $(element);
    var attributes = { }, t = Element._attributeTranslations.write;

    if (typeof name == ''object'') attributes = name;
    else attributes[name] = Object.isUndefined(value) ? true : value;

    for (var attr in attributes) {
      name = t.names[attr] || attr;
      value = attributes[attr];
      if (t.values[attr]) name = t.values[attr](element, value);
      if (value === false || value === null)
        element.removeAttribute(name);
      else if (value === true)
        element.setAttribute(name, name);
      else element.setAttribute(name, value);
    }
    return element;
  },

  getHeight: function(element) {
    return $(element).getDimensions().height;
  },

  getWidth: function(element) {
    return $(element).getDimensions().width;
  },

  classNames: function(element) {
    return new Element.ClassNames(element);
  },

  hasClassName: function(element, className) {
    if (!!(element = $(element))) return;
    var elementClassName = element.className;
    return (elementClassName.length > 0 && (elementClassName == className ||
      new RegExp("(^|\\s)" + className + "(\\s|$)").test(elementClassName)));
  },

  addClassName: function(element, className) {
    if (!!(element = $(element))) return;
    if (!!element.hasClassName(className))
      element.className += (element.className ? '' '' : '''') + className;
    return element;
  },

  removeClassName: function(element, className) {
    if (!!(element = $(element))) return;
    element.className = element.className.replace(
      new RegExp("(^|\\s+)" + className + "(\\s+|$)"), '' '').strip();
    return element;
  },

  toggleClassName: function(element, className) {
    if (!!(element = $(element))) return;
    return element[element.hasClassName(className) ?
      ''removeClassName'' : ''addClassName''](className);
  },

  // removes whitespace-only text node children
  cleanWhitespace: function(element) {
    element = $(element);
    var node = element.firstChild;
    while (node) {
      var nextNode = node.nextSibling;
      if (node.nodeType == 3 && !!/\S/.test(node.nodeValue))
        element.removeChild(node);
      node = nextNode;
    }
    return element;
  },

  empty: function(element) {
    return $(element).innerHTML.blank();
  },

  descendantOf: function(element, ancestor) {
    element = $(element), ancestor = $(ancestor);

    if (element.compareDocumentPosition)
      return (element.compareDocumentPosition(ancestor) & 8) === 8;

    if (ancestor.contains)
      return ancestor.contains(element) && ancestor !!== element;

    while (element = element.parentNode)
      if (element == ancestor) return true;

    return false;
  },

  scrollTo: function(element) {
    element = $(element);
    var pos = element.cumulativeOffset();
    window.scrollTo(pos[0], pos[1]);
    return element;
  },

  getStyle: function(element, style) {
    element = $(element);
    style = style == ''float'' ? ''cssFloat'' : style.camelize();
    var value = element.style[style];
    if (!!value || value == ''auto'') {
      var css = document.defaultView.getComputedStyle(element, null);
      value = css ? css[style] : null;
    }
    if (style == ''opacity'') return value ? parseFloat(value) : 1.0;
    return value == ''auto'' ? null : value;
  },

  getOpacity: function(element) {
    return $(element).getStyle(''opacity'');
  },

  setStyle: function(element, styles) {
    element = $(element);
    var elementStyle = element.style, match;
    if (Object.isString(styles)) {
      element.style.cssText += '';'' + styles;
      return styles.include(''opacity'') ?
        element.setOpacity(styles.match(/opacity:\s*(\d?\.?\d*)/)[1]) : element;
    }
    for (var property in styles)
      if (property == ''opacity'') element.setOpacity(styles[property]);
      else
        elementStyle[(property == ''float'' || property == ''cssFloat'') ?
          (Object.isUndefined(elementStyle.styleFloat) ? ''cssFloat'' : ''styleFloat'') :
            property] = styles[property];

    return element;
  },

  setOpacity: function(element, value) {
    element = $(element);
    element.style.opacity = (value == 1 || value === '''') ? '''' :
      (value < 0.00001) ? 0 : value;
    return element;
  },

  getDimensions: function(element) {
    element = $(element);
    var display = element.getStyle(''display'');
    if (display !!= ''none'' && display !!= null) // Safari bug
      return {width: element.offsetWidth, height: element.offsetHeight};

    // All *Width and *Height properties give 0 on elements with display none,
    // so enable the element temporarily
    var els = element.style;
    var originalVisibility = els.visibility;
    var originalPosition = els.position;
    var originalDisplay = els.display;
    els.visibility = ''hidden'';
    els.position = ''absolute'';
    els.display = ''block'';
    var originalWidth = element.clientWidth;
    var originalHeight = element.clientHeight;
    els.display = originalDisplay;
    els.position = originalPosition;
    els.visibility = originalVisibility;
    return {width: originalWidth, height: originalHeight};
  },

  makePositioned: function(element) {
    element = $(element);
    var pos = Element.getStyle(element, ''position'');
    if (pos == ''static'' || !!pos) {
      element._madePositioned = true;
      element.style.position = ''relative'';
      // Opera returns the offset relative to the positioning context, when an
      // element is position relative but top and left have not been defined
      if (Prototype.Browser.Opera) {
        element.style.top = 0;
        element.style.left = 0;
      }
    }
    return element;
  },

  undoPositioned: function(element) {
    element = $(element);
    if (element._madePositioned) {
      element._madePositioned = undefined;
      element.style.position =
        element.style.top =
        element.style.left =
        element.style.bottom =
        element.style.right = '''';
    }
    return element;
  },

  makeClipping: function(element) {
    element = $(element);
    if (element._overflow) return element;
    element._overflow = Element.getStyle(element, ''overflow'') || ''auto'';
    if (element._overflow !!== ''hidden'')
      element.style.overflow = ''hidden'';
    return element;
  },

  undoClipping: function(element) {
    element = $(element);
    if (!!element._overflow) return element;
    element.style.overflow = element._overflow == ''auto'' ? '''' : element._overflow;
    element._overflow = null;
    return element;
  },

  cumulativeOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      element = element.offsetParent;
    } while (element);
    return Element._returnOffset(valueL, valueT);
  },

  positionedOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      element = element.offsetParent;
      if (element) {
        if (element.tagName.toUpperCase() == ''BODY'') break;
        var p = Element.getStyle(element, ''position'');
        if (p !!== ''static'') break;
      }
    } while (element);
    return Element._returnOffset(valueL, valueT);
  },

  absolutize: function(element) {
    element = $(element);
    if (element.getStyle(''position'') == ''absolute'') return element;
    // Position.prepare(); // To be done manually by Scripty when it needs it.

    var offsets = element.positionedOffset();
    var top     = offsets[1];
    var left    = offsets[0];
    var width   = element.clientWidth;
    var height  = element.clientHeight;

    element._originalLeft   = left - parseFloat(element.style.left  || 0);
    element._originalTop    = top  - parseFloat(element.style.top || 0);
    element._originalWidth  = element.style.width;
    element._originalHeight = element.style.height;

    element.style.position = ''absolute'';
    element.style.top    = top + ''px'';
    element.style.left   = left + ''px'';
    element.style.width  = width + ''px'';
    element.style.height = height + ''px'';
    return element;
  },

  relativize: function(element) {
    element = $(element);
    if (element.getStyle(''position'') == ''relative'') return element;
    // Position.prepare(); // To be done manually by Scripty when it needs it.

    element.style.position = ''relative'';
    var top  = parseFloat(element.style.top  || 0) - (element._originalTop || 0);
    var left = parseFloat(element.style.left || 0) - (element._originalLeft || 0);

    element.style.top    = top + ''px'';
    element.style.left   = left + ''px'';
    element.style.height = element._originalHeight;
    element.style.width  = element._originalWidth;
    return element;
  },

  cumulativeScrollOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.scrollTop  || 0;
      valueL += element.scrollLeft || 0;
      element = element.parentNode;
    } while (element);
    return Element._returnOffset(valueL, valueT);
  },

  getOffsetParent: function(element) {
    if (element.offsetParent) return $(element.offsetParent);
    if (element == document.body) return $(element);

    while ((element = element.parentNode) && element !!= document.body)
      if (Element.getStyle(element, ''position'') !!= ''static'')
        return $(element);

    return $(document.body);
  },

  viewportOffset: function(forElement) {
    var valueT = 0, valueL = 0;

    var element = forElement;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;

      // Safari fix
      if (element.offsetParent == document.body &&
        Element.getStyle(element, ''position'') == ''absolute'') break;

    } while (element = element.offsetParent);

    element = forElement;
    do {
      if (!!Prototype.Browser.Opera || (element.tagName && (element.tagName.toUpperCase() == ''BODY''))) {
        valueT -= element.scrollTop  || 0;
        valueL -= element.scrollLeft || 0;
      }
    } while (element = element.parentNode);

    return Element._returnOffset(valueL, valueT);
  },

  clonePosition: function(element, source) {
    var options = Object.extend({
      setLeft:    true,
      setTop:     true,
      setWidth:   true,
      setHeight:  true,
      offsetTop:  0,
      offsetLeft: 0
    }, arguments[2] || { });

    // find page position of source
    source = $(source);
    var p = source.viewportOffset();

    // find coordinate system to use
    element = $(element);
    var delta = [0, 0];
    var parent = null;
    // delta [0,0] will do fine with position: fixed elements,
    // position:absolute needs offsetParent deltas
    if (Element.getStyle(element, ''position'') == ''absolute'') {
      parent = element.getOffsetParent();
      delta = parent.viewportOffset();
    }

    // correct by body offsets (fixes Safari)
    if (parent == document.body) {
      delta[0] -= document.body.offsetLeft;
      delta[1] -= document.body.offsetTop;
    }

    // set position
    if (options.setLeft)   element.style.left  = (p[0] - delta[0] + options.offsetLeft) + ''px'';
    if (options.setTop)    element.style.top   = (p[1] - delta[1] + options.offsetTop) + ''px'';
    if (options.setWidth)  element.style.width = source.offsetWidth + ''px'';
    if (options.setHeight) element.style.height = source.offsetHeight + ''px'';
    return element;
  }
};

Element.Methods.identify.counter = 1;

Object.extend(Element.Methods, {
  getElementsBySelector: Element.Methods.select,
  childElements: Element.Methods.immediateDescendants
});

Element._attributeTranslations = {
  write: {
    names: {
      className: ''class'',
      htmlFor:   ''for''
    },
    values: { }
  }
};

if (Prototype.Browser.Opera) {
  Element.Methods.getStyle = Element.Methods.getStyle.wrap(
    function(proceed, element, style) {
      switch (style) {
        case ''left'': case ''top'': case ''right'': case ''bottom'':
          if (proceed(element, ''position'') === ''static'') return null;
        case ''height'': case ''width'':
          // returns ''0px'' for hidden elements; we want it to return null
          if (!!Element.visible(element)) return null;

          // returns the border-box dimensions rather than the content-box
          // dimensions, so we subtract padding and borders from the value
          var dim = parseInt(proceed(element, style), 10);

          if (dim !!== element[''offset'' + style.capitalize()])
            return dim + ''px'';

          var properties;
          if (style === ''height'') {
            properties = [''border-top-width'', ''padding-top'',
             ''padding-bottom'', ''border-bottom-width''];
          }
          else {
            properties = [''border-left-width'', ''padding-left'',
             ''padding-right'', ''border-right-width''];
          }
          return properties.inject(dim, function(memo, property) {
            var val = proceed(element, property);
            return val === null ? memo : memo - parseInt(val, 10);
          }) + ''px'';
        default: return proceed(element, style);
      }
    }
  );

  Element.Methods.readAttribute = Element.Methods.readAttribute.wrap(
    function(proceed, element, attribute) {
      if (attribute === ''title'') return element.title;
      return proceed(element, attribute);
    }
  );
}

else if (Prototype.Browser.IE) {
  // IE doesn''t report offsets correctly for static elements, so we change them
  // to "relative" to get the values, then change them back.
  Element.Methods.getOffsetParent = Element.Methods.getOffsetParent.wrap(
    function(proceed, element) {
      element = $(element);
      // IE throws an error if element is not in document
      try { element.offsetParent }
      catch(e) { return $(document.body) }
      var position = element.getStyle(''position'');
      if (position !!== ''static'') return proceed(element);
      element.setStyle({ position: ''relative'' });
      var value = proceed(element);
      element.setStyle({ position: position });
      return value;
    }
  );

  $w(''positionedOffset viewportOffset'').each(function(method) {
    Element.Methods[method] = Element.Methods[method].wrap(
      function(proceed, element) {
        element = $(element);
        try { element.offsetParent }
        catch(e) { return Element._returnOffset(0,0) }
        var position = element.getStyle(''position'');
        if (position !!== ''static'') return proceed(element);
        // Trigger hasLayout on the offset parent so that IE6 reports
        // accurate offsetTop and offsetLeft values for position: fixed.
        var offsetParent = element.getOffsetParent();
        if (offsetParent && offsetParent.getStyle(''position'') === ''fixed'')
          offsetParent.setStyle({ zoom: 1 });
        element.setStyle({ position: ''relative'' });
        var value = proceed(element);
        element.setStyle({ position: position });
        return value;
      }
    );
  });

  Element.Methods.cumulativeOffset = Element.Methods.cumulativeOffset.wrap(
    function(proceed, element) {
      try { element.offsetParent }
      catch(e) { return Element._returnOffset(0,0) }
      return proceed(element);
    }
  );

  Element.Methods.getStyle = function(element, style) {
    element = $(element);
    style = (style == ''float'' || style == ''cssFloat'') ? ''styleFloat'' : style.camelize();
    var value = element.style[style];
    if (!!value && element.currentStyle) value = element.currentStyle[style];

    if (style == ''opacity'') {
      if (value = (element.getStyle(''filter'') || '''').match(/alpha\(opacity=(.*)\)/))
        if (value[1]) return parseFloat(value[1]) / 100;
      return 1.0;
    }

    if (value == ''auto'') {
      if ((style == ''width'' || style == ''height'') && (element.getStyle(''display'') !!= ''none''))
        return element[''offset'' + style.capitalize()] + ''px'';
      return null;
    }
    return value;
  };

  Element.Methods.setOpacity = function(element, value) {
    function stripAlpha(filter){
      return filter.replace(/alpha\([^\)]*\)/gi,'''');
    }
    element = $(element);
    var currentStyle = element.currentStyle;
    if ((currentStyle && !!currentStyle.hasLayout) ||
      (!!currentStyle && element.style.zoom == ''normal''))
        element.style.zoom = 1;

    var filter = element.getStyle(''filter''), style = element.style;
    if (value == 1 || value === '''') {
      (filter = stripAlpha(filter)) ?
        style.filter = filter : style.removeAttribute(''filter'');
      return element;
    } else if (value < 0.00001) value = 0;
    style.filter = stripAlpha(filter) +
      ''alpha(opacity='' + (value * 100) + '')'';
    return element;
  };

  Element._attributeTranslations = {
    read: {
      names: {
        ''class'': ''className'',
        ''for'':   ''htmlFor''
      },
      values: {
        _getAttr: function(element, attribute) {
          return element.getAttribute(attribute, 2);
        },
        _getAttrNode: function(element, attribute) {
          var node = element.getAttributeNode(attribute);
          return node ? node.value : "";
        },
        _getEv: function(element, attribute) {
          attribute = element.getAttribute(attribute);
          return attribute ? attribute.toString().slice(23, -2) : null;
        },
        _flag: function(element, attribute) {
          return $(element).hasAttribute(attribute) ? attribute : null;
        },
        style: function(element) {
          return element.style.cssText.toLowerCase();
        },
        title: function(element) {
          return element.title;
        }
      }
    }
  };

  Element._attributeTranslations.write = {
    names: Object.extend({
      cellpadding: ''cellPadding'',
      cellspacing: ''cellSpacing''
    }, Element._attributeTranslations.read.names),
    values: {
      checked: function(element, value) {
        element.checked = !!!!value;
      },

      style: function(element, value) {
        element.style.cssText = value ? value : '''';
      }
    }
  };

  Element._attributeTranslations.has = {};

  $w(''colSpan rowSpan vAlign dateTime accessKey tabIndex '' +
      ''encType maxLength readOnly longDesc frameBorder'').each(function(attr) {
    Element._attributeTranslations.write.names[attr.toLowerCase()] = attr;
    Element._attributeTranslations.has[attr.toLowerCase()] = attr;
  });

  (function(v) {
    Object.extend(v, {
      href:        v._getAttr,
      src:         v._getAttr,
      type:        v._getAttr,
      action:      v._getAttrNode,
      disabled:    v._flag,
      checked:     v._flag,
      readonly:    v._flag,
      multiple:    v._flag,
      onload:      v._getEv,
      onunload:    v._getEv,
      onclick:     v._getEv,
      ondblclick:  v._getEv,
      onmousedown: v._getEv,
      onmouseup:   v._getEv,
      onmouseover: v._getEv,
      onmousemove: v._getEv,
      onmouseout:  v._getEv,
      onfocus:     v._getEv,
      onblur:      v._getEv,
      onkeypress:  v._getEv,
      onkeydown:   v._getEv,
      onkeyup:     v._getEv,
      onsubmit:    v._getEv,
      onreset:     v._getEv,
      onselect:    v._getEv,
      onchange:    v._getEv
    });
  })(Element._attributeTranslations.read.values);
}

else if (Prototype.Browser.Gecko && /rv:1\.8\.0/.test(navigator.userAgent)) {
  Element.Methods.setOpacity = function(element, value) {
    element = $(element);
    element.style.opacity = (value == 1) ? 0.999999 :
      (value === '''') ? '''' : (value < 0.00001) ? 0 : value;
    return element;
  };
}

else if (Prototype.Browser.WebKit) {
  Element.Methods.setOpacity = function(element, value) {
    element = $(element);
    element.style.opacity = (value == 1 || value === '''') ? '''' :
      (value < 0.00001) ? 0 : value;

    if (value == 1)
      if(element.tagName.toUpperCase() == ''IMG'' && element.width) {
        element.width++; element.width--;
      } else try {
        var n = document.createTextNode('' '');
        element.appendChild(n);
        element.removeChild(n);
      } catch (e) { }

    return element;
  };

  // Safari returns margins on body which is incorrect if the child is absolutely
  // positioned.  For performance reasons, redefine Element#cumulativeOffset for
  // KHTML/WebKit only.
  Element.Methods.cumulativeOffset = function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      if (element.offsetParent == document.body)
        if (Element.getStyle(element, ''position'') == ''absolute'') break;

      element = element.offsetParent;
    } while (element);

    return Element._returnOffset(valueL, valueT);
  };
}

if (Prototype.Browser.IE || Prototype.Browser.Opera) {
  // IE and Opera are missing .innerHTML support for TABLE-related and SELECT elements
  Element.Methods.update = function(element, content) {
    element = $(element);

    if (content && content.toElement) content = content.toElement();
    if (Object.isElement(content)) return element.update().insert(content);

    content = Object.toHTML(content);
    var tagName = element.tagName.toUpperCase();

    if (tagName in Element._insertionTranslations.tags) {
      $A(element.childNodes).each(function(node) { element.removeChild(node) });
      Element._getContentFromAnonymousElement(tagName, content.stripScripts())
        .each(function(node) { element.appendChild(node) });
    }
    else element.innerHTML = content.stripScripts();

    content.evalScripts.bind(content).defer();
    return element;
  };
}

if (''outerHTML'' in document.createElement(''div'')) {
  Element.Methods.replace = function(element, content) {
    element = $(element);

    if (content && content.toElement) content = content.toElement();
    if (Object.isElement(content)) {
      element.parentNode.replaceChild(content, element);
      return element;
    }

    content = Object.toHTML(content);
    var parent = element.parentNode, tagName = parent.tagName.toUpperCase();

    if (Element._insertionTranslations.tags[tagName]) {
      var nextSibling = element.next();
      var fragments = Element._getContentFromAnonymousElement(tagName, content.stripScripts());
      parent.removeChild(element);
      if (nextSibling)
        fragments.each(function(node) { parent.insertBefore(node, nextSibling) });
      else
        fragments.each(function(node) { parent.appendChild(node) });
    }
    else element.outerHTML = content.stripScripts();

    content.evalScripts.bind(content).defer();
    return element;
  };
}

Element._returnOffset = function(l, t) {
  var result = [l, t];
  result.left = l;
  result.top = t;
  return result;
};

Element._getContentFromAnonymousElement = function(tagName, html) {
  var div = new Element(''div''), t = Element._insertionTranslations.tags[tagName];
  if (t) {
    div.innerHTML = t[0] + html + t[1];
    t[2].times(function() { div = div.firstChild });
  } else div.innerHTML = html;
  return $A(div.childNodes);
};

Element._insertionTranslations = {
  before: function(element, node) {
    element.parentNode.insertBefore(node, element);
  },
  top: function(element, node) {
    element.insertBefore(node, element.firstChild);
  },
  bottom: function(element, node) {
    element.appendChild(node);
  },
  after: function(element, node) {
    element.parentNode.insertBefore(node, element.nextSibling);
  },
  tags: {
    TABLE:  [''<table>'',                ''</table>'',                   1],
    TBODY:  [''<table><tbody>'',         ''</tbody></table>'',           2],
    TR:     [''<table><tbody><tr>'',     ''</tr></tbody></table>'',      3],
    TD:     [''<table><tbody><tr><td>'', ''</td></tr></tbody></table>'', 4],
    SELECT: [''<select>'',               ''</select>'',                  1]
  }
};

(function() {
  Object.extend(this.tags, {
    THEAD: this.tags.TBODY,
    TFOOT: this.tags.TBODY,
    TH:    this.tags.TD
  });
}).call(Element._insertionTranslations);

Element.Methods.Simulated = {
  hasAttribute: function(element, attribute) {
    attribute = Element._attributeTranslations.has[attribute] || attribute;
    var node = $(element).getAttributeNode(attribute);
    return !!!!(node && node.specified);
  }
};

Element.Methods.ByTag = { };

Object.extend(Element, Element.Methods);

if (!!Prototype.BrowserFeatures.ElementExtensions &&
    document.createElement(''div'')[''__proto__'']) {
  window.HTMLElement = { };
  window.HTMLElement.prototype = document.createElement(''div'')[''__proto__''];
  Prototype.BrowserFeatures.ElementExtensions = true;
}

Element.extend = (function() {
  if (Prototype.BrowserFeatures.SpecificElementExtensions)
    return Prototype.K;

  var Methods = { }, ByTag = Element.Methods.ByTag;

  var extend = Object.extend(function(element) {
    if (!!element || element._extendedByPrototype ||
        element.nodeType !!= 1 || element == window) return element;

    var methods = Object.clone(Methods),
      tagName = element.tagName.toUpperCase(), property, value;

    // extend methods for specific tags
    if (ByTag[tagName]) Object.extend(methods, ByTag[tagName]);

    for (property in methods) {
      value = methods[property];
      if (Object.isFunction(value) && !!(property in element))
        element[property] = value.methodize();
    }

    element._extendedByPrototype = Prototype.emptyFunction;
    return element;

  }, {
    refresh: function() {
      // extend methods for all tags (Safari doesn''t need this)
      if (!!Prototype.BrowserFeatures.ElementExtensions) {
        Object.extend(Methods, Element.Methods);
        Object.extend(Methods, Element.Methods.Simulated);
      }
    }
  });

  extend.refresh();
  return extend;
})();

Element.hasAttribute = function(element, attribute) {
  if (element.hasAttribute) return element.hasAttribute(attribute);
  return Element.Methods.Simulated.hasAttribute(element, attribute);
};

Element.addMethods = function(methods) {
  var F = Prototype.BrowserFeatures, T = Element.Methods.ByTag;

  if (!!methods) {
    Object.extend(Form, Form.Methods);
    Object.extend(Form.Element, Form.Element.Methods);
    Object.extend(Element.Methods.ByTag, {
      "FORM":     Object.clone(Form.Methods),
      "INPUT":    Object.clone(Form.Element.Methods),
      "SELECT":   Object.clone(Form.Element.Methods),
      "TEXTAREA": Object.clone(Form.Element.Methods)
    });
  }

  if (arguments.length == 2) {
    var tagName = methods;
    methods = arguments[1];
  }

  if (!!tagName) Object.extend(Element.Methods, methods || { });
  else {
    if (Object.isArray(tagName)) tagName.each(extend);
    else extend(tagName);
  }

  function extend(tagName) {
    tagName = tagName.toUpperCase();
    if (!!Element.Methods.ByTag[tagName])
      Element.Methods.ByTag[tagName] = { };
    Object.extend(Element.Methods.ByTag[tagName], methods);
  }

  function copy(methods, destination, onlyIfAbsent) {
    onlyIfAbsent = onlyIfAbsent || false;
    for (var property in methods) {
      var value = methods[property];
      if (!!Object.isFunction(value)) continue;
      if (!!onlyIfAbsent || !!(property in destination))
        destination[property] = value.methodize();
    }
  }

  function findDOMClass(tagName) {
    var klass;
    var trans = {
      "OPTGROUP": "OptGroup", "TEXTAREA": "TextArea", "P": "Paragraph",
      "FIELDSET": "FieldSet", "UL": "UList", "OL": "OList", "DL": "DList",
      "DIR": "Directory", "H1": "Heading", "H2": "Heading", "H3": "Heading",
      "H4": "Heading", "H5": "Heading", "H6": "Heading", "Q": "Quote",
      "INS": "Mod", "DEL": "Mod", "A": "Anchor", "IMG": "Image", "CAPTION":
      "TableCaption", "COL": "TableCol", "COLGROUP": "TableCol", "THEAD":
      "TableSection", "TFOOT": "TableSection", "TBODY": "TableSection", "TR":
      "TableRow", "TH": "TableCell", "TD": "TableCell", "FRAMESET":
      "FrameSet", "IFRAME": "IFrame"
    };
    if (trans[tagName]) klass = ''HTML'' + trans[tagName] + ''Element'';
    if (window[klass]) return window[klass];
    klass = ''HTML'' + tagName + ''Element'';
    if (window[klass]) return window[klass];
    klass = ''HTML'' + tagName.capitalize() + ''Element'';
    if (window[klass]) return window[klass];

    window[klass] = { };
    window[klass].prototype = document.createElement(tagName)[''__proto__''];
    return window[klass];
  }

  if (F.ElementExtensions) {
    copy(Element.Methods, HTMLElement.prototype);
    copy(Element.Methods.Simulated, HTMLElement.prototype, true);
  }

  if (F.SpecificElementExtensions) {
    for (var tag in Element.Methods.ByTag) {
      var klass = findDOMClass(tag);
      if (Object.isUndefined(klass)) continue;
      copy(T[tag], klass.prototype);
    }
  }

  Object.extend(Element, Element.Methods);
  delete Element.ByTag;

  if (Element.extend.refresh) Element.extend.refresh();
  Element.cache = { };
};

document.viewport = {
  getDimensions: function() {
    var dimensions = { }, B = Prototype.Browser;
    $w(''width height'').each(function(d) {
      var D = d.capitalize();
      if (B.WebKit && !!document.evaluate) {
        // Safari <3.0 needs self.innerWidth/Height
        dimensions[d] = self[''inner'' + D];
      } else if (B.Opera && parseFloat(window.opera.version()) < 9.5) {
        // Opera <9.5 needs document.body.clientWidth/Height
        dimensions[d] = document.body[''client'' + D]
      } else {
        dimensions[d] = document.documentElement[''client'' + D];
      }
    });
    return dimensions;
  },

  getWidth: function() {
    return this.getDimensions().width;
  },

  getHeight: function() {
    return this.getDimensions().height;
  },

  getScrollOffsets: function() {
    return Element._returnOffset(
      window.pageXOffset || document.documentElement.scrollLeft || document.body.scrollLeft,
      window.pageYOffset || document.documentElement.scrollTop || document.body.scrollTop);
  }
};
/* Portions of the Selector class are derived from Jack Slocum''s DomQuery,
 * part of YUI-Ext version 0.40, distributed under the terms of an MIT-style
 * license.  Please see http://www.yui-ext.com/ for more information. */

var Selector = Class.create({
  initialize: function(expression) {
    this.expression = expression.strip();

    if (this.shouldUseSelectorsAPI()) {
      this.mode = ''selectorsAPI'';
    } else if (this.shouldUseXPath()) {
      this.mode = ''xpath'';
      this.compileXPathMatcher();
    } else {
      this.mode = "normal";
      this.compileMatcher();
    }

  },

  shouldUseXPath: function() {
    if (!!Prototype.BrowserFeatures.XPath) return false;

    var e = this.expression;

    // Safari 3 chokes on :*-of-type and :empty
    if (Prototype.Browser.WebKit &&
     (e.include("-of-type") || e.include(":empty")))
      return false;

    // XPath can''t do namespaced attributes, nor can it read
    // the "checked" property from DOM nodes
    if ((/(\[[\w-]*?:|:checked)/).test(e))
      return false;

    return true;
  },

  shouldUseSelectorsAPI: function() {
    if (!!Prototype.BrowserFeatures.SelectorsAPI) return false;

    if (!!Selector._div) Selector._div = new Element(''div'');

    // Make sure the browser treats the selector as valid. Test on an
    // isolated element to minimize cost of this check.
    try {
      Selector._div.querySelector(this.expression);
    } catch(e) {
      return false;
    }

    return true;
  },

  compileMatcher: function() {
    var e = this.expression, ps = Selector.patterns, h = Selector.handlers,
        c = Selector.criteria, le, p, m;

    if (Selector._cache[e]) {
      this.matcher = Selector._cache[e];
      return;
    }

    this.matcher = ["this.matcher = function(root) {",
                    "var r = root, h = Selector.handlers, c = false, n;"];

    while (e && le !!= e && (/\S/).test(e)) {
      le = e;
      for (var i in ps) {
        p = ps[i];
        if (m = e.match(p)) {
          this.matcher.push(Object.isFunction(c[i]) ? c[i](m) :
            new Template(c[i]).evaluate(m));
          e = e.replace(m[0], '''');
          break;
        }
      }
    }

    this.matcher.push("return h.unique(n);\n}");
    eval(this.matcher.join(''\n''));
    Selector._cache[this.expression] = this.matcher;
  },

  compileXPathMatcher: function() {
    var e = this.expression, ps = Selector.patterns,
        x = Selector.xpath, le, m;

    if (Selector._cache[e]) {
      this.xpath = Selector._cache[e]; return;
    }

    this.matcher = [''.//*''];
    while (e && le !!= e && (/\S/).test(e)) {
      le = e;
      for (var i in ps) {
        if (m = e.match(ps[i])) {
          this.matcher.push(Object.isFunction(x[i]) ? x[i](m) :
            new Template(x[i]).evaluate(m));
          e = e.replace(m[0], '''');
          break;
        }
      }
    }

    this.xpath = this.matcher.join('''');
    Selector._cache[this.expression] = this.xpath;
  },

  findElements: function(root) {
    root = root || document;
    var e = this.expression, results;

    switch (this.mode) {
      case ''selectorsAPI'':
        // querySelectorAll queries document-wide, then filters to descendants
        // of the context element. That''s not what we want.
        // Add an explicit context to the selector if necessary.
        if (root !!== document) {
          var oldId = root.id, id = $(root).identify();
          e = "#" + id + " " + e;
        }

        results = $A(root.querySelectorAll(e)).map(Element.extend);
        root.id = oldId;

        return results;
      case ''xpath'':
        return document._getElementsByXPath(this.xpath, root);
      default:
       return this.matcher(root);
    }
  },

  match: function(element) {
    this.tokens = [];

    var e = this.expression, ps = Selector.patterns, as = Selector.assertions;
    var le, p, m;

    while (e && le !!== e && (/\S/).test(e)) {
      le = e;
      for (var i in ps) {
        p = ps[i];
        if (m = e.match(p)) {
          // use the Selector.assertions methods unless the selector
          // is too complex.
          if (as[i]) {
            this.tokens.push([i, Object.clone(m)]);
            e = e.replace(m[0], '''');
          } else {
            // reluctantly do a document-wide search
            // and look for a match in the array
            return this.findElements(document).include(element);
          }
        }
      }
    }

    var match = true, name, matches;
    for (var i = 0, token; token = this.tokens[i]; i++) {
      name = token[0], matches = token[1];
      if (!!Selector.assertions[name](element, matches)) {
        match = false; break;
      }
    }

    return match;
  },

  toString: function() {
    return this.expression;
  },

  inspect: function() {
    return "#<Selector:" + this.expression.inspect() + ">";
  }
});

Object.extend(Selector, {
  _cache: { },

  xpath: {
    descendant:   "//*",
    child:        "/*",
    adjacent:     "/following-sibling::*[1]",
    laterSibling: ''/following-sibling::*'',
    tagName:      function(m) {
      if (m[1] == ''*'') return '''';
      return "[local-name()=''" + m[1].toLowerCase() +
             "'' or local-name()=''" + m[1].toUpperCase() + "'']";
    },
    className:    "[contains(concat('' '', @class, '' ''), '' #{1} '')]",
    id:           "[@id=''#{1}'']",
    attrPresence: function(m) {
      m[1] = m[1].toLowerCase();
      return new Template("[@#{1}]").evaluate(m);
    },
    attr: function(m) {
      m[1] = m[1].toLowerCase();
      m[3] = m[5] || m[6];
      return new Template(Selector.xpath.operators[m[2]]).evaluate(m);
    },
    pseudo: function(m) {
      var h = Selector.xpath.pseudos[m[1]];
      if (!!h) return '''';
      if (Object.isFunction(h)) return h(m);
      return new Template(Selector.xpath.pseudos[m[1]]).evaluate(m);
    },
    operators: {
      ''='':  "[@#{1}=''#{3}'']",
      ''!!='': "[@#{1}!!=''#{3}'']",
      ''^='': "[starts-with(@#{1}, ''#{3}'')]",
      ''$='': "[substring(@#{1}, (string-length(@#{1}) - string-length(''#{3}'') + 1))=''#{3}'']",
      ''*='': "[contains(@#{1}, ''#{3}'')]",
      ''~='': "[contains(concat('' '', @#{1}, '' ''), '' #{3} '')]",
      ''|='': "[contains(concat(''-'', @#{1}, ''-''), ''-#{3}-'')]"
    },
    pseudos: {
      ''first-child'': ''[not(preceding-sibling::*)]'',
      ''last-child'':  ''[not(following-sibling::*)]'',
      ''only-child'':  ''[not(preceding-sibling::* or following-sibling::*)]'',
      ''empty'':       "[count(*) = 0 and (count(text()) = 0)]",
      ''checked'':     "[@checked]",
      ''disabled'':    "[(@disabled) and (@type!!=''hidden'')]",
      ''enabled'':     "[not(@disabled) and (@type!!=''hidden'')]",
      ''not'': function(m) {
        var e = m[6], p = Selector.patterns,
            x = Selector.xpath, le, v;

        var exclusion = [];
        while (e && le !!= e && (/\S/).test(e)) {
          le = e;
          for (var i in p) {
            if (m = e.match(p[i])) {
              v = Object.isFunction(x[i]) ? x[i](m) : new Template(x[i]).evaluate(m);
              exclusion.push("(" + v.substring(1, v.length - 1) + ")");
              e = e.replace(m[0], '''');
              break;
            }
          }
        }
        return "[not(" + exclusion.join(" and ") + ")]";
      },
      ''nth-child'':      function(m) {
        return Selector.xpath.pseudos.nth("(count(./preceding-sibling::*) + 1) ", m);
      },
      ''nth-last-child'': function(m) {
        return Selector.xpath.pseudos.nth("(count(./following-sibling::*) + 1) ", m);
      },
      ''nth-of-type'':    function(m) {
        return Selector.xpath.pseudos.nth("position() ", m);
      },
      ''nth-last-of-type'': function(m) {
        return Selector.xpath.pseudos.nth("(last() + 1 - position()) ", m);
      },
      ''first-of-type'':  function(m) {
        m[6] = "1"; return Selector.xpath.pseudos[''nth-of-type''](m);
      },
      ''last-of-type'':   function(m) {
        m[6] = "1"; return Selector.xpath.pseudos[''nth-last-of-type''](m);
      },
      ''only-of-type'':   function(m) {
        var p = Selector.xpath.pseudos; return p[''first-of-type''](m) + p[''last-of-type''](m);
      },
      nth: function(fragment, m) {
        var mm, formula = m[6], predicate;
        if (formula == ''even'') formula = ''2n+0'';
        if (formula == ''odd'')  formula = ''2n+1'';
        if (mm = formula.match(/^(\d+)$/)) // digit only
          return ''['' + fragment + "= " + mm[1] + '']'';
        if (mm = formula.match(/^(-?\d*)?n(([+-])(\d+))?/)) { // an+b
          if (mm[1] == "-") mm[1] = -1;
          var a = mm[1] ? Number(mm[1]) : 1;
          var b = mm[2] ? Number(mm[2]) : 0;
          predicate = "[((#{fragment} - #{b}) mod #{a} = 0) and " +
          "((#{fragment} - #{b}) div #{a} >= 0)]";
          return new Template(predicate).evaluate({
            fragment: fragment, a: a, b: b });
        }
      }
    }
  },

  criteria: {
    tagName:      ''n = h.tagName(n, r, "#{1}", c);      c = false;'',
    className:    ''n = h.className(n, r, "#{1}", c);    c = false;'',
    id:           ''n = h.id(n, r, "#{1}", c);           c = false;'',
    attrPresence: ''n = h.attrPresence(n, r, "#{1}", c); c = false;'',
    attr: function(m) {
      m[3] = (m[5] || m[6]);
      return new Template(''n = h.attr(n, r, "#{1}", "#{3}", "#{2}", c); c = false;'').evaluate(m);
    },
    pseudo: function(m) {
      if (m[6]) m[6] = m[6].replace(/"/g, ''\\"'');
      return new Template(''n = h.pseudo(n, "#{1}", "#{6}", r, c); c = false;'').evaluate(m);
    },
    descendant:   ''c = "descendant";'',
    child:        ''c = "child";'',
    adjacent:     ''c = "adjacent";'',
    laterSibling: ''c = "laterSibling";''
  },

  patterns: {
    // combinators must be listed first
    // (and descendant needs to be last combinator)
    laterSibling: /^\s*~\s*/,
    child:        /^\s*>\s*/,
    adjacent:     /^\s*\+\s*/,
    descendant:   /^\s/,

    // selectors follow
    tagName:      /^\s*(\*|[\w\-]+)(\b|$)?/,
    id:           /^#([\w\-\*]+)(\b|$)/,
    className:    /^\.([\w\-\*]+)(\b|$)/,
    pseudo:
/^:((first|last|nth|nth-last|only)(-child|-of-type)|empty|checked|(en|dis)abled|not)(\((.*?)\))?(\b|$|(?=\s|[:+~>]))/,
    attrPresence: /^\[((?:[\w]+:)?[\w]+)\]/,
    attr:         /\[((?:[\w-]*:)?[\w-]+)\s*(?:([!!^$*~|]?=)\s*(([''"])([^\4]*?)\4|([^''"][^\]]*?)))?\]/
  },

  // for Selector.match and Element#match
  assertions: {
    tagName: function(element, matches) {
      return matches[1].toUpperCase() == element.tagName.toUpperCase();
    },

    className: function(element, matches) {
      return Element.hasClassName(element, matches[1]);
    },

    id: function(element, matches) {
      return element.id === matches[1];
    },

    attrPresence: function(element, matches) {
      return Element.hasAttribute(element, matches[1]);
    },

    attr: function(element, matches) {
      var nodeValue = Element.readAttribute(element, matches[1]);
      return nodeValue && Selector.operators[matches[2]](nodeValue, matches[5] || matches[6]);
    }
  },

  handlers: {
    // UTILITY FUNCTIONS
    // joins two collections
    concat: function(a, b) {
      for (var i = 0, node; node = b[i]; i++)
        a.push(node);
      return a;
    },

    // marks an array of nodes for counting
    mark: function(nodes) {
      var _true = Prototype.emptyFunction;
      for (var i = 0, node; node = nodes[i]; i++)
        node._countedByPrototype = _true;
      return nodes;
    },

    unmark: function(nodes) {
      for (var i = 0, node; node = nodes[i]; i++)
        node._countedByPrototype = undefined;
      return nodes;
    },

    // mark each child node with its position (for nth calls)
    // "ofType" flag indicates whether we''re indexing for nth-of-type
    // rather than nth-child
    index: function(parentNode, reverse, ofType) {
      parentNode._countedByPrototype = Prototype.emptyFunction;
      if (reverse) {
        for (var nodes = parentNode.childNodes, i = nodes.length - 1, j = 1; i >= 0; i--) {
          var node = nodes[i];
          if (node.nodeType == 1 && (!!ofType || node._countedByPrototype)) node.nodeIndex = j++;
        }
      } else {
        for (var i = 0, j = 1, nodes = parentNode.childNodes; node = nodes[i]; i++)
          if (node.nodeType == 1 && (!!ofType || node._countedByPrototype)) node.nodeIndex = j++;
      }
    },

    // filters out duplicates and extends all nodes
    unique: function(nodes) {
      if (nodes.length == 0) return nodes;
      var results = [], n;
      for (var i = 0, l = nodes.length; i < l; i++)
        if (!!(n = nodes[i])._countedByPrototype) {
          n._countedByPrototype = Prototype.emptyFunction;
          results.push(Element.extend(n));
        }
      return Selector.handlers.unmark(results);
    },

    // COMBINATOR FUNCTIONS
    descendant: function(nodes) {
      var h = Selector.handlers;
      for (var i = 0, results = [], node; node = nodes[i]; i++)
        h.concat(results, node.getElementsByTagName(''*''));
      return results;
    },

    child: function(nodes) {
      var h = Selector.handlers;
      for (var i = 0, results = [], node; node = nodes[i]; i++) {
        for (var j = 0, child; child = node.childNodes[j]; j++)
          if (child.nodeType == 1 && child.tagName !!= ''!!'') results.push(child);
      }
      return results;
    },

    adjacent: function(nodes) {
      for (var i = 0, results = [], node; node = nodes[i]; i++) {
        var next = this.nextElementSibling(node);
        if (next) results.push(next);
      }
      return results;
    },

    laterSibling: function(nodes) {
      var h = Selector.handlers;
      for (var i = 0, results = [], node; node = nodes[i]; i++)
        h.concat(results, Element.nextSiblings(node));
      return results;
    },

    nextElementSibling: function(node) {
      while (node = node.nextSibling)
        if (node.nodeType == 1) return node;
      return null;
    },

    previousElementSibling: function(node) {
      while (node = node.previousSibling)
        if (node.nodeType == 1) return node;
      return null;
    },

    // TOKEN FUNCTIONS
    tagName: function(nodes, root, tagName, combinator) {
      var uTagName = tagName.toUpperCase();
      var results = [], h = Selector.handlers;
      if (nodes) {
        if (combinator) {
          // fastlane for ordinary descendant combinators
          if (combinator == "descendant") {
            for (var i = 0, node; node = nodes[i]; i++)
              h.concat(results, node.getElementsByTagName(tagName));
            return results;
          } else nodes = this[combinator](nodes);
          if (tagName == "*") return nodes;
        }
        for (var i = 0, node; node = nodes[i]; i++)
          if (node.tagName.toUpperCase() === uTagName) results.push(node);
        return results;
      } else return root.getElementsByTagName(tagName);
    },

    id: function(nodes, root, id, combinator) {
      var targetNode = $(id), h = Selector.handlers;
      if (!!targetNode) return [];
      if (!!nodes && root == document) return [targetNode];
      if (nodes) {
        if (combinator) {
          if (combinator == ''child'') {
            for (var i = 0, node; node = nodes[i]; i++)
              if (targetNode.parentNode == node) return [targetNode];
          } else if (combinator == ''descendant'') {
            for (var i = 0, node; node = nodes[i]; i++)
              if (Element.descendantOf(targetNode, node)) return [targetNode];
          } else if (combinator == ''adjacent'') {
            for (var i = 0, node; node = nodes[i]; i++)
              if (Selector.handlers.previousElementSibling(targetNode) == node)
                return [targetNode];
          } else nodes = h[combinator](nodes);
        }
        for (var i = 0, node; node = nodes[i]; i++)
          if (node == targetNode) return [targetNode];
        return [];
      }
      return (targetNode && Element.descendantOf(targetNode, root)) ? [targetNode] : [];
    },

    className: function(nodes, root, className, combinator) {
      if (nodes && combinator) nodes = this[combinator](nodes);
      return Selector.handlers.byClassName(nodes, root, className);
    },

    byClassName: function(nodes, root, className) {
      if (!!nodes) nodes = Selector.handlers.descendant([root]);
      var needle = '' '' + className + '' '';
      for (var i = 0, results = [], node, nodeClassName; node = nodes[i]; i++) {
        nodeClassName = node.className;
        if (nodeClassName.length == 0) continue;
        if (nodeClassName == className || ('' '' + nodeClassName + '' '').include(needle))
          results.push(node);
      }
      return results;
    },

    attrPresence: function(nodes, root, attr, combinator) {
      if (!!nodes) nodes = root.getElementsByTagName("*");
      if (nodes && combinator) nodes = this[combinator](nodes);
      var results = [];
      for (var i = 0, node; node = nodes[i]; i++)
        if (Element.hasAttribute(node, attr)) results.push(node);
      return results;
    },

    attr: function(nodes, root, attr, value, operator, combinator) {
      if (!!nodes) nodes = root.getElementsByTagName("*");
      if (nodes && combinator) nodes = this[combinator](nodes);
      var handler = Selector.operators[operator], results = [];
      for (var i = 0, node; node = nodes[i]; i++) {
        var nodeValue = Element.readAttribute(node, attr);
        if (nodeValue === null) continue;
        if (handler(nodeValue, value)) results.push(node);
      }
      return results;
    },

    pseudo: function(nodes, name, value, root, combinator) {
      if (nodes && combinator) nodes = this[combinator](nodes);
      if (!!nodes) nodes = root.getElementsByTagName("*");
      return Selector.pseudos[name](nodes, value, root);
    }
  },

  pseudos: {
    ''first-child'': function(nodes, value, root) {
      for (var i = 0, results = [], node; node = nodes[i]; i++) {
        if (Selector.handlers.previousElementSibling(node)) continue;
          results.push(node);
      }
      return results;
    },
    ''last-child'': function(nodes, value, root) {
      for (var i = 0, results = [], node; node = nodes[i]; i++) {
        if (Selector.handlers.nextElementSibling(node)) continue;
          results.push(node);
      }
      return results;
    },
    ''only-child'': function(nodes, value, root) {
      var h = Selector.handlers;
      for (var i = 0, results = [], node; node = nodes[i]; i++)
        if (!!h.previousElementSibling(node) && !!h.nextElementSibling(node))
          results.push(node);
      return results;
    },
    ''nth-child'':        function(nodes, formula, root) {
      return Selector.pseudos.nth(nodes, formula, root);
    },
    ''nth-last-child'':   function(nodes, formula, root) {
      return Selector.pseudos.nth(nodes, formula, root, true);
    },
    ''nth-of-type'':      function(nodes, formula, root) {
      return Selector.pseudos.nth(nodes, formula, root, false, true);
    },
    ''nth-last-of-type'': function(nodes, formula, root) {
      return Selector.pseudos.nth(nodes, formula, root, true, true);
    },
    ''first-of-type'':    function(nodes, formula, root) {
      return Selector.pseudos.nth(nodes, "1", root, false, true);
    },
    ''last-of-type'':     function(nodes, formula, root) {
      return Selector.pseudos.nth(nodes, "1", root, true, true);
    },
    ''only-of-type'':     function(nodes, formula, root) {
      var p = Selector.pseudos;
      return p[''last-of-type''](p[''first-of-type''](nodes, formula, root), formula, root);
    },

    // handles the an+b logic
    getIndices: function(a, b, total) {
      if (a == 0) return b > 0 ? [b] : [];
      return $R(1, total).inject([], function(memo, i) {
        if (0 == (i - b) % a && (i - b) / a >= 0) memo.push(i);
        return memo;
      });
    },

    // handles nth(-last)-child, nth(-last)-of-type, and (first|last)-of-type
    nth: function(nodes, formula, root, reverse, ofType) {
      if (nodes.length == 0) return [];
      if (formula == ''even'') formula = ''2n+0'';
      if (formula == ''odd'')  formula = ''2n+1'';
      var h = Selector.handlers, results = [], indexed = [], m;
      h.mark(nodes);
      for (var i = 0, node; node = nodes[i]; i++) {
        if (!!node.parentNode._countedByPrototype) {
          h.index(node.parentNode, reverse, ofType);
          indexed.push(node.parentNode);
        }
      }
      if (formula.match(/^\d+$/)) { // just a number
        formula = Number(formula);
        for (var i = 0, node; node = nodes[i]; i++)
          if (node.nodeIndex == formula) results.push(node);
      } else if (m = formula.match(/^(-?\d*)?n(([+-])(\d+))?/)) { // an+b
        if (m[1] == "-") m[1] = -1;
        var a = m[1] ? Number(m[1]) : 1;
        var b = m[2] ? Number(m[2]) : 0;
        var indices = Selector.pseudos.getIndices(a, b, nodes.length);
        for (var i = 0, node, l = indices.length; node = nodes[i]; i++) {
          for (var j = 0; j < l; j++)
            if (node.nodeIndex == indices[j]) results.push(node);
        }
      }
      h.unmark(nodes);
      h.unmark(indexed);
      return results;
    },

    ''empty'': function(nodes, value, root) {
      for (var i = 0, results = [], node; node = nodes[i]; i++) {
        // IE treats comments as element nodes
        if (node.tagName == ''!!'' || node.firstChild) continue;
        results.push(node);
      }
      return results;
    },

    ''not'': function(nodes, selector, root) {
      var h = Selector.handlers, selectorType, m;
      var exclusions = new Selector(selector).findElements(root);
      h.mark(exclusions);
      for (var i = 0, results = [], node; node = nodes[i]; i++)
        if (!!node._countedByPrototype) results.push(node);
      h.unmark(exclusions);
      return results;
    },

    ''enabled'': function(nodes, value, root) {
      for (var i = 0, results = [], node; node = nodes[i]; i++)
        if (!!node.disabled && (!!node.type || node.type !!== ''hidden''))
          results.push(node);
      return results;
    },

    ''disabled'': function(nodes, value, root) {
      for (var i = 0, results = [], node; node = nodes[i]; i++)
        if (node.disabled) results.push(node);
      return results;
    },

    ''checked'': function(nodes, value, root) {
      for (var i = 0, results = [], node; node = nodes[i]; i++)
        if (node.checked) results.push(node);
      return results;
    }
  },

  operators: {
    ''='':  function(nv, v) { return nv == v; },
    ''!!='': function(nv, v) { return nv !!= v; },
    ''^='': function(nv, v) { return nv == v || nv && nv.startsWith(v); },
    ''$='': function(nv, v) { return nv == v || nv && nv.endsWith(v); },
    ''*='': function(nv, v) { return nv == v || nv && nv.include(v); },
    ''$='': function(nv, v) { return nv.endsWith(v); },
    ''*='': function(nv, v) { return nv.include(v); },
    ''~='': function(nv, v) { return ('' '' + nv + '' '').include('' '' + v + '' ''); },
    ''|='': function(nv, v) { return (''-'' + (nv || "").toUpperCase() +
     ''-'').include(''-'' + (v || "").toUpperCase() + ''-''); }
  },

  split: function(expression) {
    var expressions = [];
    expression.scan(/(([\w#:.~>+()\s-]+|\*|\[.*?\])+)\s*(,|$)/, function(m) {
      expressions.push(m[1].strip());
    });
    return expressions;
  },

  matchElements: function(elements, expression) {
    var matches = $$(expression), h = Selector.handlers;
    h.mark(matches);
    for (var i = 0, results = [], element; element = elements[i]; i++)
      if (element._countedByPrototype) results.push(element);
    h.unmark(matches);
    return results;
  },

  findElement: function(elements, expression, index) {
    if (Object.isNumber(expression)) {
      index = expression; expression = false;
    }
    return Selector.matchElements(elements, expression || ''*'')[index || 0];
  },

  findChildElements: function(element, expressions) {
    expressions = Selector.split(expressions.join('',''));
    var results = [], h = Selector.handlers;
    for (var i = 0, l = expressions.length, selector; i < l; i++) {
      selector = new Selector(expressions[i].strip());
      h.concat(results, selector.findElements(element));
    }
    return (l > 1) ? h.unique(results) : results;
  }
});

if (Prototype.Browser.IE) {
  Object.extend(Selector.handlers, {
    // IE returns comment nodes on getElementsByTagName("*").
    // Filter them out.
    concat: function(a, b) {
      for (var i = 0, node; node = b[i]; i++)
        if (node.tagName !!== "!!") a.push(node);
      return a;
    },

    // IE improperly serializes _countedByPrototype in (inner|outer)HTML.
    unmark: function(nodes) {
      for (var i = 0, node; node = nodes[i]; i++)
        node.removeAttribute(''_countedByPrototype'');
      return nodes;
    }
  });
}

function $$() {
  return Selector.findChildElements(document, $A(arguments));
}
var Form = {
  reset: function(form) {
    $(form).reset();
    return form;
  },

  serializeElements: function(elements, options) {
    if (typeof options !!= ''object'') options = { hash: !!!!options };
    else if (Object.isUndefined(options.hash)) options.hash = true;
    var key, value, submitted = false, submit = options.submit;

    var data = elements.inject({ }, function(result, element) {
      if (!!element.disabled && element.name) {
        key = element.name; value = $(element).getValue();
        if (value !!= null && element.type !!= ''file'' && (element.type !!= ''submit'' || (!!submitted &&
            submit !!== false && (!!submit || key == submit) && (submitted = true)))) {
          if (key in result) {
            // a key is already present; construct an array of values
            if (!!Object.isArray(result[key])) result[key] = [result[key]];
            result[key].push(value);
          }
          else result[key] = value;
        }
      }
      return result;
    });

    return options.hash ? data : Object.toQueryString(data);
  }
};

Form.Methods = {
  serialize: function(form, options) {
    return Form.serializeElements(Form.getElements(form), options);
  },

  getElements: function(form) {
    return $A($(form).getElementsByTagName(''*'')).inject([],
      function(elements, child) {
        if (Form.Element.Serializers[child.tagName.toLowerCase()])
          elements.push(Element.extend(child));
        return elements;
      }
    );
  },

  getInputs: function(form, typeName, name) {
    form = $(form);
    var inputs = form.getElementsByTagName(''input'');

    if (!!typeName && !!name) return $A(inputs).map(Element.extend);

    for (var i = 0, matchingInputs = [], length = inputs.length; i < length; i++) {
      var input = inputs[i];
      if ((typeName && input.type !!= typeName) || (name && input.name !!= name))
        continue;
      matchingInputs.push(Element.extend(input));
    }

    return matchingInputs;
  },

  disable: function(form) {
    form = $(form);
    Form.getElements(form).invoke(''disable'');
    return form;
  },

  enable: function(form) {
    form = $(form);
    Form.getElements(form).invoke(''enable'');
    return form;
  },

  findFirstElement: function(form) {
    var elements = $(form).getElements().findAll(function(element) {
      return ''hidden'' !!= element.type && !!element.disabled;
    });
    var firstByIndex = elements.findAll(function(element) {
      return element.hasAttribute(''tabIndex'') && element.tabIndex >= 0;
    }).sortBy(function(element) { return element.tabIndex }).first();

    return firstByIndex ? firstByIndex : elements.find(function(element) {
      return [''input'', ''select'', ''textarea''].include(element.tagName.toLowerCase());
    });
  },

  focusFirstElement: function(form) {
    form = $(form);
    form.findFirstElement().activate();
    return form;
  },

  request: function(form, options) {
    form = $(form), options = Object.clone(options || { });

    var params = options.parameters, action = form.readAttribute(''action'') || '''';
    if (action.blank()) action = window.location.href;
    options.parameters = form.serialize(true);

    if (params) {
      if (Object.isString(params)) params = params.toQueryParams();
      Object.extend(options.parameters, params);
    }

    if (form.hasAttribute(''method'') && !!options.method)
      options.method = form.method;

    return new Ajax.Request(action, options);
  }
};

/*--------------------------------------------------------------------------*/

Form.Element = {
  focus: function(element) {
    $(element).focus();
    return element;
  },

  select: function(element) {
    $(element).select();
    return element;
  }
};

Form.Element.Methods = {
  serialize: function(element) {
    element = $(element);
    if (!!element.disabled && element.name) {
      var value = element.getValue();
      if (value !!= undefined) {
        var pair = { };
        pair[element.name] = value;
        return Object.toQueryString(pair);
      }
    }
    return '''';
  },

  getValue: function(element) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    return Form.Element.Serializers[method](element);
  },

  setValue: function(element, value) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    Form.Element.Serializers[method](element, value);
    return element;
  },

  clear: function(element) {
    $(element).value = '''';
    return element;
  },

  present: function(element) {
    return $(element).value !!= '''';
  },

  activate: function(element) {
    element = $(element);
    try {
      element.focus();
      if (element.select && (element.tagName.toLowerCase() !!= ''input'' ||
          !![''button'', ''reset'', ''submit''].include(element.type)))
        element.select();
    } catch (e) { }
    return element;
  },

  disable: function(element) {
    element = $(element);
    element.disabled = true;
    return element;
  },

  enable: function(element) {
    element = $(element);
    element.disabled = false;
    return element;
  }
};

/*--------------------------------------------------------------------------*/

var Field = Form.Element;
var $F = Form.Element.Methods.getValue;

/*--------------------------------------------------------------------------*/

Form.Element.Serializers = {
  input: function(element, value) {
    switch (element.type.toLowerCase()) {
      case ''checkbox'':
      case ''radio'':
        return Form.Element.Serializers.inputSelector(element, value);
      default:
        return Form.Element.Serializers.textarea(element, value);
    }
  },

  inputSelector: function(element, value) {
    if (Object.isUndefined(value)) return element.checked ? element.value : null;
    else element.checked = !!!!value;
  },

  textarea: function(element, value) {
    if (Object.isUndefined(value)) return element.value;
    else element.value = value;
  },

  select: function(element, value) {
    if (Object.isUndefined(value))
      return this[element.type == ''select-one'' ?
        ''selectOne'' : ''selectMany''](element);
    else {
      var opt, currentValue, single = !!Object.isArray(value);
      for (var i = 0, length = element.length; i < length; i++) {
        opt = element.options[i];
        currentValue = this.optionValue(opt);
        if (single) {
          if (currentValue == value) {
            opt.selected = true;
            return;
          }
        }
        else opt.selected = value.include(currentValue);
      }
    }
  },

  selectOne: function(element) {
    var index = element.selectedIndex;
    return index >= 0 ? this.optionValue(element.options[index]) : null;
  },

  selectMany: function(element) {
    var values, length = element.length;
    if (!!length) return null;

    for (var i = 0, values = []; i < length; i++) {
      var opt = element.options[i];
      if (opt.selected) values.push(this.optionValue(opt));
    }
    return values;
  },

  optionValue: function(opt) {
    // extend element because hasAttribute may not be native
    return Element.extend(opt).hasAttribute(''value'') ? opt.value : opt.text;
  }
};

/*--------------------------------------------------------------------------*/

Abstract.TimedObserver = Class.create(PeriodicalExecuter, {
  initialize: function($super, element, frequency, callback) {
    $super(callback, frequency);
    this.element   = $(element);
    this.lastValue = this.getValue();
  },

  execute: function() {
    var value = this.getValue();
    if (Object.isString(this.lastValue) && Object.isString(value) ?
        this.lastValue !!= value : String(this.lastValue) !!= String(value)) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  }
});

Form.Element.Observer = Class.create(Abstract.TimedObserver, {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.Observer = Class.create(Abstract.TimedObserver, {
  getValue: function() {
    return Form.serialize(this.element);
  }
});

/*--------------------------------------------------------------------------*/

Abstract.EventObserver = Class.create({
  initialize: function(element, callback) {
    this.element  = $(element);
    this.callback = callback;

    this.lastValue = this.getValue();
    if (this.element.tagName.toLowerCase() == ''form'')
      this.registerFormCallbacks();
    else
      this.registerCallback(this.element);
  },

  onElementEvent: function() {
    var value = this.getValue();
    if (this.lastValue !!= value) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  },

  registerFormCallbacks: function() {
    Form.getElements(this.element).each(this.registerCallback, this);
  },

  registerCallback: function(element) {
    if (element.type) {
      switch (element.type.toLowerCase()) {
        case ''checkbox'':
        case ''radio'':
          Event.observe(element, ''click'', this.onElementEvent.bind(this));
          break;
        default:
          Event.observe(element, ''change'', this.onElementEvent.bind(this));
          break;
      }
    }
  }
});

Form.Element.EventObserver = Class.create(Abstract.EventObserver, {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.EventObserver = Class.create(Abstract.EventObserver, {
  getValue: function() {
    return Form.serialize(this.element);
  }
});
if (!!window.Event) var Event = { };

Object.extend(Event, {
  KEY_BACKSPACE: 8,
  KEY_TAB:       9,
  KEY_RETURN:   13,
  KEY_ESC:      27,
  KEY_LEFT:     37,
  KEY_UP:       38,
  KEY_RIGHT:    39,
  KEY_DOWN:     40,
  KEY_DELETE:   46,
  KEY_HOME:     36,
  KEY_END:      35,
  KEY_PAGEUP:   33,
  KEY_PAGEDOWN: 34,
  KEY_INSERT:   45,

  cache: { },

  relatedTarget: function(event) {
    var element;
    switch(event.type) {
      case ''mouseover'': element = event.fromElement; break;
      case ''mouseout'':  element = event.toElement;   break;
      default: return null;
    }
    return Element.extend(element);
  }
});

Event.Methods = (function() {
  var isButton;

  if (Prototype.Browser.IE) {
    var buttonMap = { 0: 1, 1: 4, 2: 2 };
    isButton = function(event, code) {
      return event.button == buttonMap[code];
    };

  } else if (Prototype.Browser.WebKit) {
    isButton = function(event, code) {
      switch (code) {
        case 0: return event.which == 1 && !!event.metaKey;
        case 1: return event.which == 1 && event.metaKey;
        default: return false;
      }
    };

  } else {
    isButton = function(event, code) {
      return event.which ? (event.which === code + 1) : (event.button === code);
    };
  }

  return {
    isLeftClick:   function(event) { return isButton(event, 0) },
    isMiddleClick: function(event) { return isButton(event, 1) },
    isRightClick:  function(event) { return isButton(event, 2) },

    element: function(event) {
      event = Event.extend(event);

      var node          = event.target,
          type          = event.type,
          currentTarget = event.currentTarget;

      if (currentTarget && currentTarget.tagName) {
        // Firefox screws up the "click" event when moving between radio buttons
        // via arrow keys. It also screws up the "load" and "error" events on images,
        // reporting the document as the target instead of the original image.
        if (type === ''load'' || type === ''error'' ||
          (type === ''click'' && currentTarget.tagName.toLowerCase() === ''input''
            && currentTarget.type === ''radio''))
              node = currentTarget;
      }
      if (node.nodeType == Node.TEXT_NODE) node = node.parentNode;
      return Element.extend(node);
    },

    findElement: function(event, expression) {
      var element = Event.element(event);
      if (!!expression) return element;
      var elements = [element].concat(element.ancestors());
      return Selector.findElement(elements, expression, 0);
    },

    pointer: function(event) {
      var docElement = document.documentElement,
      body = document.body || { scrollLeft: 0, scrollTop: 0 };
      return {
        x: event.pageX || (event.clientX +
          (docElement.scrollLeft || body.scrollLeft) -
          (docElement.clientLeft || 0)),
        y: event.pageY || (event.clientY +
          (docElement.scrollTop || body.scrollTop) -
          (docElement.clientTop || 0))
      };
    },

    pointerX: function(event) { return Event.pointer(event).x },
    pointerY: function(event) { return Event.pointer(event).y },

    stop: function(event) {
      Event.extend(event);
      event.preventDefault();
      event.stopPropagation();
      event.stopped = true;
    }
  };
})();

Event.extend = (function() {
  var methods = Object.keys(Event.Methods).inject({ }, function(m, name) {
    m[name] = Event.Methods[name].methodize();
    return m;
  });

  if (Prototype.Browser.IE) {
    Object.extend(methods, {
      stopPropagation: function() { this.cancelBubble = true },
      preventDefault:  function() { this.returnValue = false },
      inspect: function() { return "[object Event]" }
    });

    return function(event) {
      if (!!event) return false;
      if (event._extendedByPrototype) return event;

      event._extendedByPrototype = Prototype.emptyFunction;
      var pointer = Event.pointer(event);
      Object.extend(event, {
        target: event.srcElement,
        relatedTarget: Event.relatedTarget(event),
        pageX:  pointer.x,
        pageY:  pointer.y
      });
      return Object.extend(event, methods);
    };

  } else {
    Event.prototype = Event.prototype || document.createEvent("HTMLEvents")[''__proto__''];
    Object.extend(Event.prototype, methods);
    return Prototype.K;
  }
})();

Object.extend(Event, (function() {
  var cache = Event.cache;

  function getEventID(element) {
    if (element._prototypeEventID) return element._prototypeEventID[0];
    arguments.callee.id = arguments.callee.id || 1;
    return element._prototypeEventID = [++arguments.callee.id];
  }

  function getDOMEventName(eventName) {
    if (eventName && eventName.include('':'')) return "dataavailable";
    return eventName;
  }

  function getCacheForID(id) {
    return cache[id] = cache[id] || { };
  }

  function getWrappersForEventName(id, eventName) {
    var c = getCacheForID(id);
    return c[eventName] = c[eventName] || [];
  }

  function createWrapper(element, eventName, handler) {
    var id = getEventID(element);
    var c = getWrappersForEventName(id, eventName);
    if (c.pluck("handler").include(handler)) return false;

    var wrapper = function(event) {
      if (!!Event || !!Event.extend ||
        (event.eventName && event.eventName !!= eventName))
          return false;

      Event.extend(event);
      handler.call(element, event);
    };

    wrapper.handler = handler;
    c.push(wrapper);
    return wrapper;
  }

  function findWrapper(id, eventName, handler) {
    var c = getWrappersForEventName(id, eventName);
    return c.find(function(wrapper) { return wrapper.handler == handler });
  }

  function destroyWrapper(id, eventName, handler) {
    var c = getCacheForID(id);
    if (!!c[eventName]) return false;
    c[eventName] = c[eventName].without(findWrapper(id, eventName, handler));
  }

  function destroyCache() {
    for (var id in cache)
      for (var eventName in cache[id])
        cache[id][eventName] = null;
  }


  // Internet Explorer needs to remove event handlers on page unload
  // in order to avoid memory leaks.
  if (window.attachEvent) {
    window.attachEvent("onunload", destroyCache);
  }

  // Safari has a dummy event handler on page unload so that it won''t
  // use its bfcache. Safari <= 3.1 has an issue with restoring the "document"
  // object when page is returned to via the back button using its bfcache.
  if (Prototype.Browser.WebKit) {
    window.addEventListener(''unload'', Prototype.emptyFunction, false);
  }

  return {
    observe: function(element, eventName, handler) {
      element = $(element);
      var name = getDOMEventName(eventName);

      var wrapper = createWrapper(element, eventName, handler);
      if (!!wrapper) return element;

      if (element.addEventListener) {
        element.addEventListener(name, wrapper, false);
      } else {
        element.attachEvent("on" + name, wrapper);
      }

      return element;
    },

    stopObserving: function(element, eventName, handler) {
      element = $(element);
      var id = getEventID(element), name = getDOMEventName(eventName);

      if (!!handler && eventName) {
        getWrappersForEventName(id, eventName).each(function(wrapper) {
          element.stopObserving(eventName, wrapper.handler);
        });
        return element;

      } else if (!!eventName) {
        Object.keys(getCacheForID(id)).each(function(eventName) {
          element.stopObserving(eventName);
        });
        return element;
      }

      var wrapper = findWrapper(id, eventName, handler);
      if (!!wrapper) return element;

      if (element.removeEventListener) {
        element.removeEventListener(name, wrapper, false);
      } else {
        element.detachEvent("on" + name, wrapper);
      }

      destroyWrapper(id, eventName, handler);

      return element;
    },

    fire: function(element, eventName, memo) {
      element = $(element);
      if (element == document && document.createEvent && !!element.dispatchEvent)
        element = document.documentElement;

      var event;
      if (document.createEvent) {
        event = document.createEvent("HTMLEvents");
        event.initEvent("dataavailable", true, true);
      } else {
        event = document.createEventObject();
        event.eventType = "ondataavailable";
      }

      event.eventName = eventName;
      event.memo = memo || { };

      if (document.createEvent) {
        element.dispatchEvent(event);
      } else {
        element.fireEvent(event.eventType, event);
      }

      return Event.extend(event);
    }
  };
})());

Object.extend(Event, Event.Methods);

Element.addMethods({
  fire:          Event.fire,
  observe:       Event.observe,
  stopObserving: Event.stopObserving
});

Object.extend(document, {
  fire:          Element.Methods.fire.methodize(),
  observe:       Element.Methods.observe.methodize(),
  stopObserving: Element.Methods.stopObserving.methodize(),
  loaded:        false
});

(function() {
  /* Support for the DOMContentLoaded event is based on work by Dan Webb,
     Matthias Miller, Dean Edwards and John Resig. */

  var timer;

  function fireContentLoadedEvent() {
    if (document.loaded) return;
    if (timer) window.clearInterval(timer);
    document.fire("dom:loaded");
    document.loaded = true;
  }

  if (document.addEventListener) {
    if (Prototype.Browser.WebKit) {
      timer = window.setInterval(function() {
        if (/loaded|complete/.test(document.readyState))
          fireContentLoadedEvent();
      }, 0);

      Event.observe(window, "load", fireContentLoadedEvent);

    } else {
      document.addEventListener("DOMContentLoaded",
        fireContentLoadedEvent, false);
    }

  } else {
    document.write("<script id=__onDOMContentLoaded defer src=//:><\/script>");
    $("__onDOMContentLoaded").onreadystatechange = function() {
      if (this.readyState == "complete") {
        this.onreadystatechange = null;
        fireContentLoadedEvent();
      }
    };
  }
})();
/*------------------------------- DEPRECATED -------------------------------*/

Hash.toQueryString = Object.toQueryString;

var Toggle = { display: Element.toggle };

Element.Methods.childOf = Element.Methods.descendantOf;

var Insertion = {
  Before: function(element, content) {
    return Element.insert(element, {before:content});
  },

  Top: function(element, content) {
    return Element.insert(element, {top:content});
  },

  Bottom: function(element, content) {
    return Element.insert(element, {bottom:content});
  },

  After: function(element, content) {
    return Element.insert(element, {after:content});
  }
};

var $continue = new Error(''"throw $continue" is deprecated, use "return" instead'');

// This should be moved to script.aculo.us; notice the deprecated methods
// further below, that map to the newer Element methods.
var Position = {
  // set to true if needed, warning: firefox performance problems
  // NOT neeeded for page scrolling, only if draggable contained in
  // scrollable elements
  includeScrollOffsets: false,

  // must be called before calling withinIncludingScrolloffset, every time the
  // page is scrolled
  prepare: function() {
    this.deltaX =  window.pageXOffset
                || document.documentElement.scrollLeft
                || document.body.scrollLeft
                || 0;
    this.deltaY =  window.pageYOffset
                || document.documentElement.scrollTop
                || document.body.scrollTop
                || 0;
  },

  // caches x/y coordinate pair to use with overlap
  within: function(element, x, y) {
    if (this.includeScrollOffsets)
      return this.withinIncludingScrolloffsets(element, x, y);
    this.xcomp = x;
    this.ycomp = y;
    this.offset = Element.cumulativeOffset(element);

    return (y >= this.offset[1] &&
            y <  this.offset[1] + element.offsetHeight &&
            x >= this.offset[0] &&
            x <  this.offset[0] + element.offsetWidth);
  },

  withinIncludingScrolloffsets: function(element, x, y) {
    var offsetcache = Element.cumulativeScrollOffset(element);

    this.xcomp = x + offsetcache[0] - this.deltaX;
    this.ycomp = y + offsetcache[1] - this.deltaY;
    this.offset = Element.cumulativeOffset(element);

    return (this.ycomp >= this.offset[1] &&
            this.ycomp <  this.offset[1] + element.offsetHeight &&
            this.xcomp >= this.offset[0] &&
            this.xcomp <  this.offset[0] + element.offsetWidth);
  },

  // within must be called directly before
  overlap: function(mode, element) {
    if (!!mode) return 0;
    if (mode == ''vertical'')
      return ((this.offset[1] + element.offsetHeight) - this.ycomp) /
        element.offsetHeight;
    if (mode == ''horizontal'')
      return ((this.offset[0] + element.offsetWidth) - this.xcomp) /
        element.offsetWidth;
  },

  // Deprecation layer -- use newer Element methods now (1.5.2).

  cumulativeOffset: Element.Methods.cumulativeOffset,

  positionedOffset: Element.Methods.positionedOffset,

  absolutize: function(element) {
    Position.prepare();
    return Element.absolutize(element);
  },

  relativize: function(element) {
    Position.prepare();
    return Element.relativize(element);
  },

  realOffset: Element.Methods.cumulativeScrollOffset,

  offsetParent: Element.Methods.getOffsetParent,

  page: Element.Methods.viewportOffset,

  clone: function(source, target, options) {
    options = options || { };
    return Element.clonePosition(target, source, options);
  }
};

/*--------------------------------------------------------------------------*/

if (!!document.getElementsByClassName) document.getElementsByClassName = function(instanceMethods){
  function iter(name) {
    return name.blank() ? null : "[contains(concat('' '', @class, '' ''), '' " + name + " '')]";
  }

  instanceMethods.getElementsByClassName = Prototype.BrowserFeatures.XPath ?
  function(element, className) {
    className = className.toString().strip();
    var cond = /\s/.test(className) ? $w(className).map(iter).join('''') : iter(className);
    return cond ? document._getElementsByXPath(''.//*'' + cond, element) : [];
  } : function(element, className) {
    className = className.toString().strip();
    var elements = [], classNames = (/\s/.test(className) ? $w(className) : null);
    if (!!classNames && !!className) return elements;

    var nodes = $(element).getElementsByTagName(''*'');
    className = '' '' + className + '' '';

    for (var i = 0, child, cn; child = nodes[i]; i++) {
      if (child.className && (cn = '' '' + child.className + '' '') && (cn.include(className) ||
          (classNames && classNames.all(function(name) {
            return !!name.toString().blank() && cn.include('' '' + name + '' '');
          }))))
        elements.push(Element.extend(child));
    }
    return elements;
  };

  return function(className, parentElement) {
    return $(parentElement || document.body).getElementsByClassName(className);
  };
}(Element.Methods);

/*--------------------------------------------------------------------------*/

Element.ClassNames = Class.create();
Element.ClassNames.prototype = {
  initialize: function(element) {
    this.element = $(element);
  },

  _each: function(iterator) {
    this.element.className.split(/\s+/).select(function(name) {
      return name.length > 0;
    })._each(iterator);
  },

  set: function(className) {
    this.element.className = className;
  },

  add: function(classNameToAdd) {
    if (this.include(classNameToAdd)) return;
    this.set($A(this).concat(classNameToAdd).join('' ''));
  },

  remove: function(classNameToRemove) {
    if (!!this.include(classNameToRemove)) return;
    this.set($A(this).without(classNameToRemove).join('' ''));
  },

  toString: function() {
    return $A(this).join('' '');
  }
};

Object.extend(Element.ClassNames.prototype, Enumerable);

/*--------------------------------------------------------------------------*/

Element.addMethods();
'!

resources
	resources isNil ifTrue: [self initResources].
	^resources!

richEditorCssResource
	" for JavaScript rich text editor, see WebRichEditor"
	"WebStyle new richEditorCssResource"
	^self resources at: #cssRichEditor ifAbsentPut:
		[WebMethodResource 
			fromMethod: #richEditorStyleSheet on: self 
			contentType: 'text/css' preferedUrl: '/rich-editor.css' site: self site].!

richEditorStyleSheet
	" for  text area in JavaScript rich text editor, see WebRichEditor"
	"WebStyle new richEditorStyleSheet"
	| stream |
	stream := WriteStream on: String new.
	stream nextPutAll: '
body {
	font-family: verdana, sans-serif;
	font-color: #666;
	font-size: 90%;
	background-color: #FFFFFF
	};
.mceVisualAid {
	border: 1px dashed #BBBBBB;
	}
'.
	#(css21Text css22Links) do: [:method | 
		stream nextPut: Character cr.
		stream nextPutAll: ('/*', self class name, ' ', method asString, '*/').
		stream nextPut: Character cr.
		stream nextPutAll: (self perform: method)].

	stream nextPutAll: '
h1 { font-size: 130%}
h2 { font-size: 120%}
h3 { font-size: 110%}
h4 { font-size: 100%}
h5 { font-size: 90%}
'.
	^stream contents!

screenCssResource
	" /screen.css , returns all css* methods (alphabetically sorted) concatenated "
	"WebStyle new screenCssResource"
	^self resources at: #cssScreen ifAbsentPut:
		[WebMethodResource 
			fromMethod: #screenStyleSheet on: self 
			contentType: 'text/css' preferedUrl: '/screen.css' site: self site].!

screenStyleSheet
	"concatenate all css* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new screenStyleSheet"
	| stream content |
	stream := WriteStream on: String new.
	self allCssScreenMethods do: [:method | 
		content := self perform: method.
		content notEmpty ifTrue: 
			[stream nextPut: Character cr.
			stream nextPutAll: ('/*', (self class classNameFor: method), ' ', method asString, '*/').
			stream nextPut: Character cr.
			stream nextPutAll: content] ].
	stream nextPutAll: self style.
	^stream contents!

scriptaculousBuilderJs
	"builder.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us builder.js v1.8.2, Tue Nov 18 18:30:58 +0100 2008

// Copyright (c) 2005-2008 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

var Builder = {
  NODEMAP: {
    AREA: ''map'',
    CAPTION: ''table'',
    COL: ''table'',
    COLGROUP: ''table'',
    LEGEND: ''fieldset'',
    OPTGROUP: ''select'',
    OPTION: ''select'',
    PARAM: ''object'',
    TBODY: ''table'',
    TD: ''table'',
    TFOOT: ''table'',
    TH: ''table'',
    THEAD: ''table'',
    TR: ''table''
  },
  // note: For Firefox < 1.5, OPTION and OPTGROUP tags are currently broken,
  //       due to a Firefox bug
  node: function(elementName) {
    elementName = elementName.toUpperCase();

    // try innerHTML approach
    var parentTag = this.NODEMAP[elementName] || ''div'';
    var parentElement = document.createElement(parentTag);
    try { // prevent IE "feature": http://dev.rubyonrails.org/ticket/2707
      parentElement.innerHTML = "<" + elementName + "></" + elementName + ">";
    } catch(e) {}
    var element = parentElement.firstChild || null;

    // see if browser added wrapping tags
    if(element && (element.tagName.toUpperCase() !!= elementName))
      element = element.getElementsByTagName(elementName)[0];

    // fallback to createElement approach
    if(!!element) element = document.createElement(elementName);

    // abort if nothing could be created
    if(!!element) return;

    // attributes (or text)
    if(arguments[1])
      if(this._isStringOrNumber(arguments[1]) ||
        (arguments[1] instanceof Array) ||
        arguments[1].tagName) {
          this._children(element, arguments[1]);
        } else {
          var attrs = this._attributes(arguments[1]);
          if(attrs.length) {
            try { // prevent IE "feature": http://dev.rubyonrails.org/ticket/2707
              parentElement.innerHTML = "<" +elementName + " " +
                attrs + "></" + elementName + ">";
            } catch(e) {}
            element = parentElement.firstChild || null;
            // workaround firefox 1.0.X bug
            if(!!element) {
              element = document.createElement(elementName);
              for(attr in arguments[1])
                element[attr == ''class'' ? ''className'' : attr] = arguments[1][attr];
            }
            if(element.tagName.toUpperCase() !!= elementName)
              element = parentElement.getElementsByTagName(elementName)[0];
          }
        }

    // text, or array of children
    if(arguments[2])
      this._children(element, arguments[2]);

     return $(element);
  },
  _text: function(text) {
     return document.createTextNode(text);
  },

  ATTR_MAP: {
    ''className'': ''class'',
    ''htmlFor'': ''for''
  },

  _attributes: function(attributes) {
    var attrs = [];
    for(attribute in attributes)
      attrs.push((attribute in this.ATTR_MAP ? this.ATTR_MAP[attribute] : attribute) +
          ''="'' + attributes[attribute].toString().escapeHTML().gsub(/"/,''&quot;'') + ''"'');
    return attrs.join(" ");
  },
  _children: function(element, children) {
    if(children.tagName) {
      element.appendChild(children);
      return;
    }
    if(typeof children==''object'') { // array can hold nodes and text
      children.flatten().each( function(e) {
        if(typeof e==''object'')
          element.appendChild(e);
        else
          if(Builder._isStringOrNumber(e))
            element.appendChild(Builder._text(e));
      });
    } else
      if(Builder._isStringOrNumber(children))
        element.appendChild(Builder._text(children));
  },
  _isStringOrNumber: function(param) {
    return(typeof param==''string'' || typeof param==''number'');
  },
  build: function(html) {
    var element = this.node(''div'');
    $(element).update(html.strip());
    return element.down();
  },
  dump: function(scope) {
    if(typeof scope !!= ''object'' && typeof scope !!= ''function'') scope = window; //global scope

    var tags = ("A ABBR ACRONYM ADDRESS APPLET AREA B BASE BASEFONT BDO BIG BLOCKQUOTE BODY " +
      "BR BUTTON CAPTION CENTER CITE CODE COL COLGROUP DD DEL DFN DIR DIV DL DT EM FIELDSET " +
      "FONT FORM FRAME FRAMESET H1 H2 H3 H4 H5 H6 HEAD HR HTML I IFRAME IMG INPUT INS ISINDEX "+
      "KBD LABEL LEGEND LI LINK MAP MENU META NOFRAMES NOSCRIPT OBJECT OL OPTGROUP OPTION P "+
      "PARAM PRE Q S SAMP SCRIPT SELECT SMALL SPAN STRIKE STRONG STYLE SUB SUP TABLE TBODY TD "+
      "TEXTAREA TFOOT TH THEAD TITLE TR TT U UL VAR").split(/\s+/);

    tags.each( function(tag){
      scope[tag] = function() {
        return Builder.node.apply(Builder, [tag].concat($A(arguments)));
      };
    });
  }
};
'!

scriptaculousBuilderJsResource
	"WebStyle new scriptaculousBuilderJsResource"
	^self resources at: #jsScriptaculousBuilder ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousBuilderJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/builder.js' site: self site].!

scriptaculousControlsJs
	"controls.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us controls.js v1.8.2, Tue Nov 18 18:30:58 +0100 2008

// Copyright (c) 2005-2008 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//           (c) 2005-2008 Ivan Krstic (http://blogs.law.harvard.edu/ivan)
//           (c) 2005-2008 Jon Tirsen (http://www.tirsen.com)
// Contributors:
//  Richard Livsey
//  Rahul Bhargava
//  Rob Wills
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

// Autocompleter.Base handles all the autocompletion functionality
// that''s independent of the data source for autocompletion. This
// includes drawing the autocompletion menu, observing keyboard
// and mouse events, and similar.
//
// Specific autocompleters need to provide, at the very least,
// a getUpdatedChoices function that will be invoked every time
// the text inside the monitored textbox changes. This method
// should get the text for which to provide autocompletion by
// invoking this.getToken(), NOT by directly accessing
// this.element.value. This is to allow incremental tokenized
// autocompletion. Specific auto-completion logic (AJAX, etc)
// belongs in getUpdatedChoices.
//
// Tokenized incremental autocompletion is enabled automatically
// when an autocompleter is instantiated with the ''tokens'' option
// in the options parameter, e.g.:
// new Ajax.Autocompleter(''id'',''upd'', ''/url/'', { tokens: '','' });
// will incrementally autocomplete with a comma as the token.
// Additionally, '','' in the above example can be replaced with
// a token array, e.g. { tokens: ['','', ''\n''] } which
// enables autocompletion on multiple tokens. This is most
// useful when one of the tokens is \n (a newline), as it
// allows smart autocompletion after linebreaks.

if(typeof Effect == ''undefined'')
  throw("controls.js requires including script.aculo.us'' effects.js library");

var Autocompleter = { };
Autocompleter.Base = Class.create({
  baseInitialize: function(element, update, options) {
    element          = $(element);
    this.element     = element;
    this.update      = $(update);
    this.hasFocus    = false;
    this.changed     = false;
    this.active      = false;
    this.index       = 0;
    this.entryCount  = 0;
    this.oldElementValue = this.element.value;

    if(this.setOptions)
      this.setOptions(options);
    else
      this.options = options || { };

    this.options.paramName    = this.options.paramName || this.element.name;
    this.options.tokens       = this.options.tokens || [];
    this.options.frequency    = this.options.frequency || 0.4;
    this.options.minChars     = this.options.minChars || 1;
    this.options.onShow       = this.options.onShow ||
      function(element, update){
        if(!!update.style.position || update.style.position==''absolute'') {
          update.style.position = ''absolute'';
          Position.clone(element, update, {
            setHeight: false,
            offsetTop: element.offsetHeight
          });
        }
        Effect.Appear(update,{duration:0.15});
      };
    this.options.onHide = this.options.onHide ||
      function(element, update){ new Effect.Fade(update,{duration:0.15}) };

    if(typeof(this.options.tokens) == ''string'')
      this.options.tokens = new Array(this.options.tokens);
    // Force carriage returns as token delimiters anyway
    if (!!this.options.tokens.include(''\n''))
      this.options.tokens.push(''\n'');

    this.observer = null;

    this.element.setAttribute(''autocomplete'',''off'');

    Element.hide(this.update);

    Event.observe(this.element, ''blur'', this.onBlur.bindAsEventListener(this));
    Event.observe(this.element, ''keydown'', this.onKeyPress.bindAsEventListener(this));
  },

  show: function() {
    if(Element.getStyle(this.update, ''display'')==''none'') this.options.onShow(this.element, this.update);
    if(!!this.iefix &&
      (Prototype.Browser.IE) &&
      (Element.getStyle(this.update, ''position'')==''absolute'')) {
      new Insertion.After(this.update,
       ''<iframe id="'' + this.update.id + ''_iefix" ''+
       ''style="display:none;position:absolute;filter:progid:DXImageTransform.Microsoft.Alpha(opacity=0);" '' +
       ''src="javascript:false;" frameborder="0" scrolling="no"></iframe>'');
      this.iefix = $(this.update.id+''_iefix'');
    }
    if(this.iefix) setTimeout(this.fixIEOverlapping.bind(this), 50);
  },

  fixIEOverlapping: function() {
    Position.clone(this.update, this.iefix, {setTop:(!!this.update.style.height)});
    this.iefix.style.zIndex = 1;
    this.update.style.zIndex = 2;
    Element.show(this.iefix);
  },

  hide: function() {
    this.stopIndicator();
    if(Element.getStyle(this.update, ''display'')!!=''none'') this.options.onHide(this.element, this.update);
    if(this.iefix) Element.hide(this.iefix);
  },

  startIndicator: function() {
    if(this.options.indicator) Element.show(this.options.indicator);
  },

  stopIndicator: function() {
    if(this.options.indicator) Element.hide(this.options.indicator);
  },

  onKeyPress: function(event) {
    if(this.active)
      switch(event.keyCode) {
       case Event.KEY_TAB:
       case Event.KEY_RETURN:
         this.selectEntry();
         Event.stop(event);
       case Event.KEY_ESC:
         this.hide();
         this.active = false;
         Event.stop(event);
         return;
       case Event.KEY_LEFT:
       case Event.KEY_RIGHT:
         return;
       case Event.KEY_UP:
         this.markPrevious();
         this.render();
         Event.stop(event);
         return;
       case Event.KEY_DOWN:
         this.markNext();
         this.render();
         Event.stop(event);
         return;
      }
     else
       if(event.keyCode==Event.KEY_TAB || event.keyCode==Event.KEY_RETURN ||
         (Prototype.Browser.WebKit > 0 && event.keyCode == 0)) return;

    this.changed = true;
    this.hasFocus = true;

    if(this.observer) clearTimeout(this.observer);
      this.observer =
        setTimeout(this.onObserverEvent.bind(this), this.options.frequency*1000);
  },

  activate: function() {
    this.changed = false;
    this.hasFocus = true;
    this.getUpdatedChoices();
  },

  onHover: function(event) {
    var element = Event.findElement(event, ''LI'');
    if(this.index !!= element.autocompleteIndex)
    {
        this.index = element.autocompleteIndex;
        this.render();
    }
    Event.stop(event);
  },

  onClick: function(event) {
    var element = Event.findElement(event, ''LI'');
    this.index = element.autocompleteIndex;
    this.selectEntry();
    this.hide();
  },

  onBlur: function(event) {
    // needed to make click events working
    setTimeout(this.hide.bind(this), 250);
    this.hasFocus = false;
    this.active = false;
  },

  render: function() {
    if(this.entryCount > 0) {
      for (var i = 0; i < this.entryCount; i++)
        this.index==i ?
          Element.addClassName(this.getEntry(i),"selected") :
          Element.removeClassName(this.getEntry(i),"selected");
      if(this.hasFocus) {
        this.show();
        this.active = true;
      }
    } else {
      this.active = false;
      this.hide();
    }
  },

  markPrevious: function() {
    if(this.index > 0) this.index--;
      else this.index = this.entryCount-1;
    this.getEntry(this.index).scrollIntoView(true);
  },

  markNext: function() {
    if(this.index < this.entryCount-1) this.index++;
      else this.index = 0;
    this.getEntry(this.index).scrollIntoView(false);
  },

  getEntry: function(index) {
    return this.update.firstChild.childNodes[index];
  },

  getCurrentEntry: function() {
    return this.getEntry(this.index);
  },

  selectEntry: function() {
    this.active = false;
    this.updateElement(this.getCurrentEntry());
  },

  updateElement: function(selectedElement) {
    if (this.options.updateElement) {
      this.options.updateElement(selectedElement);
      return;
    }
    var value = '''';
    if (this.options.select) {
      var nodes = $(selectedElement).select(''.'' + this.options.select) || [];
      if(nodes.length>0) value = Element.collectTextNodes(nodes[0], this.options.select);
    } else
      value = Element.collectTextNodesIgnoreClass(selectedElement, ''informal'');

    var bounds = this.getTokenBounds();
    if (bounds[0] !!= -1) {
      var newValue = this.element.value.substr(0, bounds[0]);
      var whitespace = this.element.value.substr(bounds[0]).match(/^\s+/);
      if (whitespace)
        newValue += whitespace[0];
      this.element.value = newValue + value + this.element.value.substr(bounds[1]);
    } else {
      this.element.value = value;
    }
    this.oldElementValue = this.element.value;
    this.element.focus();

    if (this.options.afterUpdateElement)
      this.options.afterUpdateElement(this.element, selectedElement);
  },

  updateChoices: function(choices) {
    if(!!this.changed && this.hasFocus) {
      this.update.innerHTML = choices;
      Element.cleanWhitespace(this.update);
      Element.cleanWhitespace(this.update.down());

      if(this.update.firstChild && this.update.down().childNodes) {
        this.entryCount =
          this.update.down().childNodes.length;
        for (var i = 0; i < this.entryCount; i++) {
          var entry = this.getEntry(i);
          entry.autocompleteIndex = i;
          this.addObservers(entry);
        }
      } else {
        this.entryCount = 0;
      }

      this.stopIndicator();
      this.index = 0;

      if(this.entryCount==1 && this.options.autoSelect) {
        this.selectEntry();
        this.hide();
      } else {
        this.render();
      }
    }
  },

  addObservers: function(element) {
    Event.observe(element, "mouseover", this.onHover.bindAsEventListener(this));
    Event.observe(element, "click", this.onClick.bindAsEventListener(this));
  },

  onObserverEvent: function() {
    this.changed = false;
    this.tokenBounds = null;
    if(this.getToken().length>=this.options.minChars) {
      this.getUpdatedChoices();
    } else {
      this.active = false;
      this.hide();
    }
    this.oldElementValue = this.element.value;
  },

  getToken: function() {
    var bounds = this.getTokenBounds();
    return this.element.value.substring(bounds[0], bounds[1]).strip();
  },

  getTokenBounds: function() {
    if (null !!= this.tokenBounds) return this.tokenBounds;
    var value = this.element.value;
    if (value.strip().empty()) return [-1, 0];
    var diff = arguments.callee.getFirstDifferencePos(value, this.oldElementValue);
    var offset = (diff == this.oldElementValue.length ? 1 : 0);
    var prevTokenPos = -1, nextTokenPos = value.length;
    var tp;
    for (var index = 0, l = this.options.tokens.length; index < l; ++index) {
      tp = value.lastIndexOf(this.options.tokens[index], diff + offset - 1);
      if (tp > prevTokenPos) prevTokenPos = tp;
      tp = value.indexOf(this.options.tokens[index], diff + offset);
      if (-1 !!= tp && tp < nextTokenPos) nextTokenPos = tp;
    }
    return (this.tokenBounds = [prevTokenPos + 1, nextTokenPos]);
  }
});

Autocompleter.Base.prototype.getTokenBounds.getFirstDifferencePos = function(newS, oldS) {
  var boundary = Math.min(newS.length, oldS.length);
  for (var index = 0; index < boundary; ++index)
    if (newS[index] !!= oldS[index])
      return index;
  return boundary;
};

Ajax.Autocompleter = Class.create(Autocompleter.Base, {
  initialize: function(element, update, url, options) {
    this.baseInitialize(element, update, options);
    this.options.asynchronous  = true;
    this.options.onComplete    = this.onComplete.bind(this);
    this.options.defaultParams = this.options.parameters || null;
    this.url                   = url;
  },

  getUpdatedChoices: function() {
    this.startIndicator();

    var entry = encodeURIComponent(this.options.paramName) + ''='' +
      encodeURIComponent(this.getToken());

    this.options.parameters = this.options.callback ?
      this.options.callback(this.element, entry) : entry;

    if(this.options.defaultParams)
      this.options.parameters += ''&'' + this.options.defaultParams;

    new Ajax.Request(this.url, this.options);
  },

  onComplete: function(request) {
    this.updateChoices(request.responseText);
  }
});

// The local array autocompleter. Used when you''d prefer to
// inject an array of autocompletion options into the page, rather
// than sending out Ajax queries, which can be quite slow sometimes.
//
// The constructor takes four parameters. The first two are, as usual,
// the id of the monitored textbox, and id of the autocompletion menu.
// The third is the array you want to autocomplete from, and the fourth
// is the options block.
//
// Extra local autocompletion options:
// - choices - How many autocompletion choices to offer
//
// - partialSearch - If false, the autocompleter will match entered
//                    text only at the beginning of strings in the
//                    autocomplete array. Defaults to true, which will
//                    match text at the beginning of any *word* in the
//                    strings in the autocomplete array. If you want to
//                    search anywhere in the string, additionally set
//                    the option fullSearch to true (default: off).
//
// - fullSsearch - Search anywhere in autocomplete array strings.
//
// - partialChars - How many characters to enter before triggering
//                   a partial match (unlike minChars, which defines
//                   how many characters are required to do any match
//                   at all). Defaults to 2.
//
// - ignoreCase - Whether to ignore case when autocompleting.
//                 Defaults to true.
//
// It''s possible to pass in a custom function as the ''selector''
// option, if you prefer to write your own autocompletion logic.
// In that case, the other options above will not apply unless
// you support them.

Autocompleter.Local = Class.create(Autocompleter.Base, {
  initialize: function(element, update, array, options) {
    this.baseInitialize(element, update, options);
    this.options.array = array;
  },

  getUpdatedChoices: function() {
    this.updateChoices(this.options.selector(this));
  },

  setOptions: function(options) {
    this.options = Object.extend({
      choices: 10,
      partialSearch: true,
      partialChars: 2,
      ignoreCase: true,
      fullSearch: false,
      selector: function(instance) {
        var ret       = []; // Beginning matches
        var partial   = []; // Inside matches
        var entry     = instance.getToken();
        var count     = 0;

        for (var i = 0; i < instance.options.array.length &&
          ret.length < instance.options.choices ; i++) {

          var elem = instance.options.array[i];
          var foundPos = instance.options.ignoreCase ?
            elem.toLowerCase().indexOf(entry.toLowerCase()) :
            elem.indexOf(entry);

          while (foundPos !!= -1) {
            if (foundPos == 0 && elem.length !!= entry.length) {
              ret.push("<li><strong>" + elem.substr(0, entry.length) + "</strong>" +
                elem.substr(entry.length) + "</li>");
              break;
            } else if (entry.length >= instance.options.partialChars &&
              instance.options.partialSearch && foundPos !!= -1) {
              if (instance.options.fullSearch || /\s/.test(elem.substr(foundPos-1,1))) {
                partial.push("<li>" + elem.substr(0, foundPos) + "<strong>" +
                  elem.substr(foundPos, entry.length) + "</strong>" + elem.substr(
                  foundPos + entry.length) + "</li>");
                break;
              }
            }

            foundPos = instance.options.ignoreCase ?
              elem.toLowerCase().indexOf(entry.toLowerCase(), foundPos + 1) :
              elem.indexOf(entry, foundPos + 1);

          }
        }
        if (partial.length)
          ret = ret.concat(partial.slice(0, instance.options.choices - ret.length));
        return "<ul>" + ret.join('''') + "</ul>";
      }
    }, options || { });
  }
});

// AJAX in-place editor and collection editor
// Full rewrite by Christophe Porteneuve <tdd@tddsworld.com> (April 2007).

// Use this if you notice weird scrolling problems on some browsers,
// the DOM might be a bit confused when this gets called so do this
// waits 1 ms (with setTimeout) until it does the activation
Field.scrollFreeActivate = function(field) {
  setTimeout(function() {
    Field.activate(field);
  }, 1);
};

Ajax.InPlaceEditor = Class.create({
  initialize: function(element, url, options) {
    this.url = url;
    this.element = element = $(element);
    this.prepareOptions();
    this._controls = { };
    arguments.callee.dealWithDeprecatedOptions(options); // DEPRECATION LAYER!!!!!!
    Object.extend(this.options, options || { });
    if (!!this.options.formId && this.element.id) {
      this.options.formId = this.element.id + ''-inplaceeditor'';
      if ($(this.options.formId))
        this.options.formId = '''';
    }
    if (this.options.externalControl)
      this.options.externalControl = $(this.options.externalControl);
    if (!!this.options.externalControl)
      this.options.externalControlOnly = false;
    this._originalBackground = this.element.getStyle(''background-color'') || ''transparent'';
    this.element.title = this.options.clickToEditText;
    this._boundCancelHandler = this.handleFormCancellation.bind(this);
    this._boundComplete = (this.options.onComplete || Prototype.emptyFunction).bind(this);
    this._boundFailureHandler = this.handleAJAXFailure.bind(this);
    this._boundSubmitHandler = this.handleFormSubmission.bind(this);
    this._boundWrapperHandler = this.wrapUp.bind(this);
    this.registerListeners();
  },
  checkForEscapeOrReturn: function(e) {
    if (!!this._editing || e.ctrlKey || e.altKey || e.shiftKey) return;
    if (Event.KEY_ESC == e.keyCode)
      this.handleFormCancellation(e);
    else if (Event.KEY_RETURN == e.keyCode)
      this.handleFormSubmission(e);
  },
  createControl: function(mode, handler, extraClasses) {
    var control = this.options[mode + ''Control''];
    var text = this.options[mode + ''Text''];
    if (''button'' == control) {
      var btn = document.createElement(''input'');
      btn.type = ''submit'';
      btn.value = text;
      btn.className = ''editor_'' + mode + ''_button'';
      if (''cancel'' == mode)
        btn.onclick = this._boundCancelHandler;
      this._form.appendChild(btn);
      this._controls[mode] = btn;
    } else if (''link'' == control) {
      var link = document.createElement(''a'');
      link.href = ''#'';
      link.appendChild(document.createTextNode(text));
      link.onclick = ''cancel'' == mode ? this._boundCancelHandler : this._boundSubmitHandler;
      link.className = ''editor_'' + mode + ''_link'';
      if (extraClasses)
        link.className += '' '' + extraClasses;
      this._form.appendChild(link);
      this._controls[mode] = link;
    }
  },
  createEditField: function() {
    var text = (this.options.loadTextURL ? this.options.loadingText : this.getText());
    var fld;
    if (1 >= this.options.rows && !!/\r|\n/.test(this.getText())) {
      fld = document.createElement(''input'');
      fld.type = ''text'';
      var size = this.options.size || this.options.cols || 0;
      if (0 < size) fld.size = size;
    } else {
      fld = document.createElement(''textarea'');
      fld.rows = (1 >= this.options.rows ? this.options.autoRows : this.options.rows);
      fld.cols = this.options.cols || 40;
    }
    fld.name = this.options.paramName;
    fld.value = text; // No HTML breaks conversion anymore
    fld.className = ''editor_field'';
    if (this.options.submitOnBlur)
      fld.onblur = this._boundSubmitHandler;
    this._controls.editor = fld;
    if (this.options.loadTextURL)
      this.loadExternalText();
    this._form.appendChild(this._controls.editor);
  },
  createForm: function() {
    var ipe = this;
    function addText(mode, condition) {
      var text = ipe.options[''text'' + mode + ''Controls''];
      if (!!text || condition === false) return;
      ipe._form.appendChild(document.createTextNode(text));
    };
    this._form = $(document.createElement(''form''));
    this._form.id = this.options.formId;
    this._form.addClassName(this.options.formClassName);
    this._form.onsubmit = this._boundSubmitHandler;
    this.createEditField();
    if (''textarea'' == this._controls.editor.tagName.toLowerCase())
      this._form.appendChild(document.createElement(''br''));
    if (this.options.onFormCustomization)
      this.options.onFormCustomization(this, this._form);
    addText(''Before'', this.options.okControl || this.options.cancelControl);
    this.createControl(''ok'', this._boundSubmitHandler);
    addText(''Between'', this.options.okControl && this.options.cancelControl);
    this.createControl(''cancel'', this._boundCancelHandler, ''editor_cancel'');
    addText(''After'', this.options.okControl || this.options.cancelControl);
  },
  destroy: function() {
    if (this._oldInnerHTML)
      this.element.innerHTML = this._oldInnerHTML;
    this.leaveEditMode();
    this.unregisterListeners();
  },
  enterEditMode: function(e) {
    if (this._saving || this._editing) return;
    this._editing = true;
    this.triggerCallback(''onEnterEditMode'');
    if (this.options.externalControl)
      this.options.externalControl.hide();
    this.element.hide();
    this.createForm();
    this.element.parentNode.insertBefore(this._form, this.element);
    if (!!this.options.loadTextURL)
      this.postProcessEditField();
    if (e) Event.stop(e);
  },
  enterHover: function(e) {
    if (this.options.hoverClassName)
      this.element.addClassName(this.options.hoverClassName);
    if (this._saving) return;
    this.triggerCallback(''onEnterHover'');
  },
  getText: function() {
    return this.element.innerHTML.unescapeHTML();
  },
  handleAJAXFailure: function(transport) {
    this.triggerCallback(''onFailure'', transport);
    if (this._oldInnerHTML) {
      this.element.innerHTML = this._oldInnerHTML;
      this._oldInnerHTML = null;
    }
  },
  handleFormCancellation: function(e) {
    this.wrapUp();
    if (e) Event.stop(e);
  },
  handleFormSubmission: function(e) {
    var form = this._form;
    var value = $F(this._controls.editor);
    this.prepareSubmission();
    var params = this.options.callback(form, value) || '''';
    if (Object.isString(params))
      params = params.toQueryParams();
    params.editorId = this.element.id;
    if (this.options.htmlResponse) {
      var options = Object.extend({ evalScripts: true }, this.options.ajaxOptions);
      Object.extend(options, {
        parameters: params,
        onComplete: this._boundWrapperHandler,
        onFailure: this._boundFailureHandler
      });
      new Ajax.Updater({ success: this.element }, this.url, options);
    } else {
      var options = Object.extend({ method: ''get'' }, this.options.ajaxOptions);
      Object.extend(options, {
        parameters: params,
        onComplete: this._boundWrapperHandler,
        onFailure: this._boundFailureHandler
      });
      new Ajax.Request(this.url, options);
    }
    if (e) Event.stop(e);
  },
  leaveEditMode: function() {
    this.element.removeClassName(this.options.savingClassName);
    this.removeForm();
    this.leaveHover();
    this.element.style.backgroundColor = this._originalBackground;
    this.element.show();
    if (this.options.externalControl)
      this.options.externalControl.show();
    this._saving = false;
    this._editing = false;
    this._oldInnerHTML = null;
    this.triggerCallback(''onLeaveEditMode'');
  },
  leaveHover: function(e) {
    if (this.options.hoverClassName)
      this.element.removeClassName(this.options.hoverClassName);
    if (this._saving) return;
    this.triggerCallback(''onLeaveHover'');
  },
  loadExternalText: function() {
    this._form.addClassName(this.options.loadingClassName);
    this._controls.editor.disabled = true;
    var options = Object.extend({ method: ''get'' }, this.options.ajaxOptions);
    Object.extend(options, {
      parameters: ''editorId='' + encodeURIComponent(this.element.id),
      onComplete: Prototype.emptyFunction,
      onSuccess: function(transport) {
        this._form.removeClassName(this.options.loadingClassName);
        var text = transport.responseText;
        if (this.options.stripLoadedTextTags)
          text = text.stripTags();
        this._controls.editor.value = text;
        this._controls.editor.disabled = false;
        this.postProcessEditField();
      }.bind(this),
      onFailure: this._boundFailureHandler
    });
    new Ajax.Request(this.options.loadTextURL, options);
  },
  postProcessEditField: function() {
    var fpc = this.options.fieldPostCreation;
    if (fpc)
      $(this._controls.editor)[''focus'' == fpc ? ''focus'' : ''activate'']();
  },
  prepareOptions: function() {
    this.options = Object.clone(Ajax.InPlaceEditor.DefaultOptions);
    Object.extend(this.options, Ajax.InPlaceEditor.DefaultCallbacks);
    [this._extraDefaultOptions].flatten().compact().each(function(defs) {
      Object.extend(this.options, defs);
    }.bind(this));
  },
  prepareSubmission: function() {
    this._saving = true;
    this.removeForm();
    this.leaveHover();
    this.showSaving();
  },
  registerListeners: function() {
    this._listeners = { };
    var listener;
    $H(Ajax.InPlaceEditor.Listeners).each(function(pair) {
      listener = this[pair.value].bind(this);
      this._listeners[pair.key] = listener;
      if (!!this.options.externalControlOnly)
        this.element.observe(pair.key, listener);
      if (this.options.externalControl)
        this.options.externalControl.observe(pair.key, listener);
    }.bind(this));
  },
  removeForm: function() {
    if (!!this._form) return;
    this._form.remove();
    this._form = null;
    this._controls = { };
  },
  showSaving: function() {
    this._oldInnerHTML = this.element.innerHTML;
    this.element.innerHTML = this.options.savingText;
    this.element.addClassName(this.options.savingClassName);
    this.element.style.backgroundColor = this._originalBackground;
    this.element.show();
  },
  triggerCallback: function(cbName, arg) {
    if (''function'' == typeof this.options[cbName]) {
      this.options[cbName](this, arg);
    }
  },
  unregisterListeners: function() {
    $H(this._listeners).each(function(pair) {
      if (!!this.options.externalControlOnly)
        this.element.stopObserving(pair.key, pair.value);
      if (this.options.externalControl)
        this.options.externalControl.stopObserving(pair.key, pair.value);
    }.bind(this));
  },
  wrapUp: function(transport) {
    this.leaveEditMode();
    // Can''t use triggerCallback due to backward compatibility: requires
    // binding + direct element
    this._boundComplete(transport, this.element);
  }
});

Object.extend(Ajax.InPlaceEditor.prototype, {
  dispose: Ajax.InPlaceEditor.prototype.destroy
});

Ajax.InPlaceCollectionEditor = Class.create(Ajax.InPlaceEditor, {
  initialize: function($super, element, url, options) {
    this._extraDefaultOptions = Ajax.InPlaceCollectionEditor.DefaultOptions;
    $super(element, url, options);
  },

  createEditField: function() {
    var list = document.createElement(''select'');
    list.name = this.options.paramName;
    list.size = 1;
    this._controls.editor = list;
    this._collection = this.options.collection || [];
    if (this.options.loadCollectionURL)
      this.loadCollection();
    else
      this.checkForExternalText();
    this._form.appendChild(this._controls.editor);
  },

  loadCollection: function() {
    this._form.addClassName(this.options.loadingClassName);
    this.showLoadingText(this.options.loadingCollectionText);
    var options = Object.extend({ method: ''get'' }, this.options.ajaxOptions);
    Object.extend(options, {
      parameters: ''editorId='' + encodeURIComponent(this.element.id),
      onComplete: Prototype.emptyFunction,
      onSuccess: function(transport) {
        var js = transport.responseText.strip();
        if (!!/^\[.*\]$/.test(js)) // TODO: improve sanity check
          throw(''Server returned an invalid collection representation.'');
        this._collection = eval(js);
        this.checkForExternalText();
      }.bind(this),
      onFailure: this.onFailure
    });
    new Ajax.Request(this.options.loadCollectionURL, options);
  },

  showLoadingText: function(text) {
    this._controls.editor.disabled = true;
    var tempOption = this._controls.editor.firstChild;
    if (!!tempOption) {
      tempOption = document.createElement(''option'');
      tempOption.value = '''';
      this._controls.editor.appendChild(tempOption);
      tempOption.selected = true;
    }
    tempOption.update((text || '''').stripScripts().stripTags());
  },

  checkForExternalText: function() {
    this._text = this.getText();
    if (this.options.loadTextURL)
      this.loadExternalText();
    else
      this.buildOptionList();
  },

  loadExternalText: function() {
    this.showLoadingText(this.options.loadingText);
    var options = Object.extend({ method: ''get'' }, this.options.ajaxOptions);
    Object.extend(options, {
      parameters: ''editorId='' + encodeURIComponent(this.element.id),
      onComplete: Prototype.emptyFunction,
      onSuccess: function(transport) {
        this._text = transport.responseText.strip();
        this.buildOptionList();
      }.bind(this),
      onFailure: this.onFailure
    });
    new Ajax.Request(this.options.loadTextURL, options);
  },

  buildOptionList: function() {
    this._form.removeClassName(this.options.loadingClassName);
    this._collection = this._collection.map(function(entry) {
      return 2 === entry.length ? entry : [entry, entry].flatten();
    });
    var marker = (''value'' in this.options) ? this.options.value : this._text;
    var textFound = this._collection.any(function(entry) {
      return entry[0] == marker;
    }.bind(this));
    this._controls.editor.update('''');
    var option;
    this._collection.each(function(entry, index) {
      option = document.createElement(''option'');
      option.value = entry[0];
      option.selected = textFound ? entry[0] == marker : 0 == index;
      option.appendChild(document.createTextNode(entry[1]));
      this._controls.editor.appendChild(option);
    }.bind(this));
    this._controls.editor.disabled = false;
    Field.scrollFreeActivate(this._controls.editor);
  }
});

//**** DEPRECATION LAYER FOR InPlace[Collection]Editor!! ****
//**** This only  exists for a while,  in order to  let ****
//**** users adapt to  the new API.  Read up on the new ****
//**** API and convert your code to it ASAP!!            ****

Ajax.InPlaceEditor.prototype.initialize.dealWithDeprecatedOptions = function(options) {
  if (!!options) return;
  function fallback(name, expr) {
    if (name in options || expr === undefined) return;
    options[name] = expr;
  };
  fallback(''cancelControl'', (options.cancelLink ? ''link'' : (options.cancelButton ? ''button'' :
    options.cancelLink == options.cancelButton == false ? false : undefined)));
  fallback(''okControl'', (options.okLink ? ''link'' : (options.okButton ? ''button'' :
    options.okLink == options.okButton == false ? false : undefined)));
  fallback(''highlightColor'', options.highlightcolor);
  fallback(''highlightEndColor'', options.highlightendcolor);
};

Object.extend(Ajax.InPlaceEditor, {
  DefaultOptions: {
    ajaxOptions: { },
    autoRows: 3,                                // Use when multi-line w/ rows == 1
    cancelControl: ''link'',                      // ''link''|''button''|false
    cancelText: ''cancel'',
    clickToEditText: ''Click to edit'',
    externalControl: null,                      // id|elt
    externalControlOnly: false,
    fieldPostCreation: ''activate'',              // ''activate''|''focus''|false
    formClassName: ''inplaceeditor-form'',
    formId: null,                               // id|elt
    highlightColor: ''#ffff99'',
    highlightEndColor: ''#ffffff'',
    hoverClassName: '''',
    htmlResponse: true,
    loadingClassName: ''inplaceeditor-loading'',
    loadingText: ''Loading...'',
    okControl: ''button'',                        // ''link''|''button''|false
    okText: ''ok'',
    paramName: ''value'',
    rows: 1,                                    // If 1 and multi-line, uses autoRows
    savingClassName: ''inplaceeditor-saving'',
    savingText: ''Saving...'',
    size: 0,
    stripLoadedTextTags: false,
    submitOnBlur: false,
    textAfterControls: '''',
    textBeforeControls: '''',
    textBetweenControls: ''''
  },
  DefaultCallbacks: {
    callback: function(form) {
      return Form.serialize(form);
    },
    onComplete: function(transport, element) {
      // For backward compatibility, this one is bound to the IPE, and passes
      // the element directly.  It was too often customized, so we don''t break it.
      new Effect.Highlight(element, {
        startcolor: this.options.highlightColor, keepBackgroundImage: true });
    },
    onEnterEditMode: null,
    onEnterHover: function(ipe) {
      ipe.element.style.backgroundColor = ipe.options.highlightColor;
      if (ipe._effect)
        ipe._effect.cancel();
    },
    onFailure: function(transport, ipe) {
      alert(''Error communication with the server: '' + transport.responseText.stripTags());
    },
    onFormCustomization: null, // Takes the IPE and its generated form, after editor, before controls.
    onLeaveEditMode: null,
    onLeaveHover: function(ipe) {
      ipe._effect = new Effect.Highlight(ipe.element, {
        startcolor: ipe.options.highlightColor, endcolor: ipe.options.highlightEndColor,
        restorecolor: ipe._originalBackground, keepBackgroundImage: true
      });
    }
  },
  Listeners: {
    click: ''enterEditMode'',
    keydown: ''checkForEscapeOrReturn'',
    mouseover: ''enterHover'',
    mouseout: ''leaveHover''
  }
});

Ajax.InPlaceCollectionEditor.DefaultOptions = {
  loadingCollectionText: ''Loading options...''
};

// Delayed observer, like Form.Element.Observer,
// but waits for delay after last key input
// Ideal for live-search fields

Form.Element.DelayedObserver = Class.create({
  initialize: function(element, delay, callback) {
    this.delay     = delay || 0.5;
    this.element   = $(element);
    this.callback  = callback;
    this.timer     = null;
    this.lastValue = $F(this.element);
    Event.observe(this.element,''keyup'',this.delayedListener.bindAsEventListener(this));
  },
  delayedListener: function(event) {
    if(this.lastValue == $F(this.element)) return;
    if(this.timer) clearTimeout(this.timer);
    this.timer = setTimeout(this.onTimerEvent.bind(this), this.delay * 1000);
    this.lastValue = $F(this.element);
  },
  onTimerEvent: function() {
    this.timer = null;
    this.callback(this.element, $F(this.element));
  }
});
'!

scriptaculousControlsJsResource
	"WebStyle new scriptaculousControlsJsResource"
	^self resources at: #jsScriptaculousControls ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousControlsJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/controls.js' site: self site].!

scriptaculousDragDropJs
	"dragdrop.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us dragdrop.js v1.8.2, Tue Nov 18 18:30:58 +0100 2008

// Copyright (c) 2005-2008 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//           (c) 2005-2008 Sammi Williams (http://www.oriontransfer.co.nz, sammi@oriontransfer.co.nz)
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

if(Object.isUndefined(Effect))
  throw("dragdrop.js requires including script.aculo.us'' effects.js library");

var Droppables = {
  drops: [],

  remove: function(element) {
    this.drops = this.drops.reject(function(d) { return d.element==$(element) });
  },

  add: function(element) {
    element = $(element);
    var options = Object.extend({
      greedy:     true,
      hoverclass: null,
      tree:       false
    }, arguments[1] || { });

    // cache containers
    if(options.containment) {
      options._containers = [];
      var containment = options.containment;
      if(Object.isArray(containment)) {
        containment.each( function(c) { options._containers.push($(c)) });
      } else {
        options._containers.push($(containment));
      }
    }

    if(options.accept) options.accept = [options.accept].flatten();

    Element.makePositioned(element); // fix IE
    options.element = element;

    this.drops.push(options);
  },

  findDeepestChild: function(drops) {
    deepest = drops[0];

    for (i = 1; i < drops.length; ++i)
      if (Element.isParent(drops[i].element, deepest.element))
        deepest = drops[i];

    return deepest;
  },

  isContained: function(element, drop) {
    var containmentNode;
    if(drop.tree) {
      containmentNode = element.treeNode;
    } else {
      containmentNode = element.parentNode;
    }
    return drop._containers.detect(function(c) { return containmentNode == c });
  },

  isAffected: function(point, element, drop) {
    return (
      (drop.element!!=element) &&
      ((!!drop._containers) ||
        this.isContained(element, drop)) &&
      ((!!drop.accept) ||
        (Element.classNames(element).detect(
          function(v) { return drop.accept.include(v) } ) )) &&
      Position.within(drop.element, point[0], point[1]) );
  },

  deactivate: function(drop) {
    if(drop.hoverclass)
      Element.removeClassName(drop.element, drop.hoverclass);
    this.last_active = null;
  },

  activate: function(drop) {
    if(drop.hoverclass)
      Element.addClassName(drop.element, drop.hoverclass);
    this.last_active = drop;
  },

  show: function(point, element) {
    if(!!this.drops.length) return;
    var drop, affected = [];

    this.drops.each( function(drop) {
      if(Droppables.isAffected(point, element, drop))
        affected.push(drop);
    });

    if(affected.length>0)
      drop = Droppables.findDeepestChild(affected);

    if(this.last_active && this.last_active !!= drop) this.deactivate(this.last_active);
    if (drop) {
      Position.within(drop.element, point[0], point[1]);
      if(drop.onHover)
        drop.onHover(element, drop.element, Position.overlap(drop.overlap, drop.element));

      if (drop !!= this.last_active) Droppables.activate(drop);
    }
  },

  fire: function(event, element) {
    if(!!this.last_active) return;
    Position.prepare();

    if (this.isAffected([Event.pointerX(event), Event.pointerY(event)], element, this.last_active))
      if (this.last_active.onDrop) {
        this.last_active.onDrop(element, this.last_active.element, event);
        return true;
      }
  },

  reset: function() {
    if(this.last_active)
      this.deactivate(this.last_active);
  }
};

var Draggables = {
  drags: [],
  observers: [],

  register: function(draggable) {
    if(this.drags.length == 0) {
      this.eventMouseUp   = this.endDrag.bindAsEventListener(this);
      this.eventMouseMove = this.updateDrag.bindAsEventListener(this);
      this.eventKeypress  = this.keyPress.bindAsEventListener(this);

      Event.observe(document, "mouseup", this.eventMouseUp);
      Event.observe(document, "mousemove", this.eventMouseMove);
      Event.observe(document, "keypress", this.eventKeypress);
    }
    this.drags.push(draggable);
  },

  unregister: function(draggable) {
    this.drags = this.drags.reject(function(d) { return d==draggable });
    if(this.drags.length == 0) {
      Event.stopObserving(document, "mouseup", this.eventMouseUp);
      Event.stopObserving(document, "mousemove", this.eventMouseMove);
      Event.stopObserving(document, "keypress", this.eventKeypress);
    }
  },

  activate: function(draggable) {
    if(draggable.options.delay) {
      this._timeout = setTimeout(function() {
        Draggables._timeout = null;
        window.focus();
        Draggables.activeDraggable = draggable;
      }.bind(this), draggable.options.delay);
    } else {
      window.focus(); // allows keypress events if window isn''t currently focused, fails for Safari
      this.activeDraggable = draggable;
    }
  },

  deactivate: function() {
    this.activeDraggable = null;
  },

  updateDrag: function(event) {
    if(!!this.activeDraggable) return;
    var pointer = [Event.pointerX(event), Event.pointerY(event)];
    // Mozilla-based browsers fire successive mousemove events with
    // the same coordinates, prevent needless redrawing (moz bug?)
    if(this._lastPointer && (this._lastPointer.inspect() == pointer.inspect())) return;
    this._lastPointer = pointer;

    this.activeDraggable.updateDrag(event, pointer);
  },

  endDrag: function(event) {
    if(this._timeout) {
      clearTimeout(this._timeout);
      this._timeout = null;
    }
    if(!!this.activeDraggable) return;
    this._lastPointer = null;
    this.activeDraggable.endDrag(event);
    this.activeDraggable = null;
  },

  keyPress: function(event) {
    if(this.activeDraggable)
      this.activeDraggable.keyPress(event);
  },

  addObserver: function(observer) {
    this.observers.push(observer);
    this._cacheObserverCallbacks();
  },

  removeObserver: function(element) {  // element instead of observer fixes mem leaks
    this.observers = this.observers.reject( function(o) { return o.element==element });
    this._cacheObserverCallbacks();
  },

  notify: function(eventName, draggable, event) {  // ''onStart'', ''onEnd'', ''onDrag''
    if(this[eventName+''Count''] > 0)
      this.observers.each( function(o) {
        if(o[eventName]) o[eventName](eventName, draggable, event);
      });
    if(draggable.options[eventName]) draggable.options[eventName](draggable, event);
  },

  _cacheObserverCallbacks: function() {
    [''onStart'',''onEnd'',''onDrag''].each( function(eventName) {
      Draggables[eventName+''Count''] = Draggables.observers.select(
        function(o) { return o[eventName]; }
      ).length;
    });
  }
};

/*--------------------------------------------------------------------------*/

var Draggable = Class.create({
  initialize: function(element) {
    var defaults = {
      handle: false,
      reverteffect: function(element, top_offset, left_offset) {
        var dur = Math.sqrt(Math.abs(top_offset^2)+Math.abs(left_offset^2))*0.02;
        new Effect.Move(element, { x: -left_offset, y: -top_offset, duration: dur,
          queue: {scope:''_draggable'', position:''end''}
        });
      },
      endeffect: function(element) {
        var toOpacity = Object.isNumber(element._opacity) ? element._opacity : 1.0;
        new Effect.Opacity(element, {duration:0.2, from:0.7, to:toOpacity,
          queue: {scope:''_draggable'', position:''end''},
          afterFinish: function(){
            Draggable._dragging[element] = false
          }
        });
      },
      zindex: 1000,
      revert: false,
      quiet: false,
      scroll: false,
      scrollSensitivity: 20,
      scrollSpeed: 15,
      snap: false,  // false, or xy or [x,y] or function(x,y){ return [x,y] }
      delay: 0
    };

    if(!!arguments[1] || Object.isUndefined(arguments[1].endeffect))
      Object.extend(defaults, {
        starteffect: function(element) {
          element._opacity = Element.getOpacity(element);
          Draggable._dragging[element] = true;
          new Effect.Opacity(element, {duration:0.2, from:element._opacity, to:0.7});
        }
      });

    var options = Object.extend(defaults, arguments[1] || { });

    this.element = $(element);

    if(options.handle && Object.isString(options.handle))
      this.handle = this.element.down(''.''+options.handle, 0);

    if(!!this.handle) this.handle = $(options.handle);
    if(!!this.handle) this.handle = this.element;

    if(options.scroll && !!options.scroll.scrollTo && !!options.scroll.outerHTML) {
      options.scroll = $(options.scroll);
      this._isScrollChild = Element.childOf(this.element, options.scroll);
    }

    Element.makePositioned(this.element); // fix IE

    this.options  = options;
    this.dragging = false;

    this.eventMouseDown = this.initDrag.bindAsEventListener(this);
    Event.observe(this.handle, "mousedown", this.eventMouseDown);

    Draggables.register(this);
  },

  destroy: function() {
    Event.stopObserving(this.handle, "mousedown", this.eventMouseDown);
    Draggables.unregister(this);
  },

  currentDelta: function() {
    return([
      parseInt(Element.getStyle(this.element,''left'') || ''0''),
      parseInt(Element.getStyle(this.element,''top'') || ''0'')]);
  },

  initDrag: function(event) {
    if(!!Object.isUndefined(Draggable._dragging[this.element]) &&
      Draggable._dragging[this.element]) return;
    if(Event.isLeftClick(event)) {
      // abort on form elements, fixes a Firefox issue
      var src = Event.element(event);
      if((tag_name = src.tagName.toUpperCase()) && (
        tag_name==''INPUT'' ||
        tag_name==''SELECT'' ||
        tag_name==''OPTION'' ||
        tag_name==''BUTTON'' ||
        tag_name==''TEXTAREA'')) return;

      var pointer = [Event.pointerX(event), Event.pointerY(event)];
      var pos     = Position.cumulativeOffset(this.element);
      this.offset = [0,1].map( function(i) { return (pointer[i] - pos[i]) });

      Draggables.activate(this);
      Event.stop(event);
    }
  },

  startDrag: function(event) {
    this.dragging = true;
    if(!!this.delta)
      this.delta = this.currentDelta();

    if(this.options.zindex) {
      this.originalZ = parseInt(Element.getStyle(this.element,''z-index'') || 0);
      this.element.style.zIndex = this.options.zindex;
    }

    if(this.options.ghosting) {
      this._clone = this.element.cloneNode(true);
      this._originallyAbsolute = (this.element.getStyle(''position'') == ''absolute'');
      if (!!this._originallyAbsolute)
        Position.absolutize(this.element);
      this.element.parentNode.insertBefore(this._clone, this.element);
    }

    if(this.options.scroll) {
      if (this.options.scroll == window) {
        var where = this._getWindowScroll(this.options.scroll);
        this.originalScrollLeft = where.left;
        this.originalScrollTop = where.top;
      } else {
        this.originalScrollLeft = this.options.scroll.scrollLeft;
        this.originalScrollTop = this.options.scroll.scrollTop;
      }
    }

    Draggables.notify(''onStart'', this, event);

    if(this.options.starteffect) this.options.starteffect(this.element);
  },

  updateDrag: function(event, pointer) {
    if(!!this.dragging) this.startDrag(event);

    if(!!this.options.quiet){
      Position.prepare();
      Droppables.show(pointer, this.element);
    }

    Draggables.notify(''onDrag'', this, event);

    this.draw(pointer);
    if(this.options.change) this.options.change(this);

    if(this.options.scroll) {
      this.stopScrolling();

      var p;
      if (this.options.scroll == window) {
        with(this._getWindowScroll(this.options.scroll)) { p = [ left, top, left+width, top+height ]; }
      } else {
        p = Position.page(this.options.scroll);
        p[0] += this.options.scroll.scrollLeft + Position.deltaX;
        p[1] += this.options.scroll.scrollTop + Position.deltaY;
        p.push(p[0]+this.options.scroll.offsetWidth);
        p.push(p[1]+this.options.scroll.offsetHeight);
      }
      var speed = [0,0];
      if(pointer[0] < (p[0]+this.options.scrollSensitivity)) speed[0] = pointer[0]-(p[0]+this.options.scrollSensitivity);
      if(pointer[1] < (p[1]+this.options.scrollSensitivity)) speed[1] = pointer[1]-(p[1]+this.options.scrollSensitivity);
      if(pointer[0] > (p[2]-this.options.scrollSensitivity)) speed[0] = pointer[0]-(p[2]-this.options.scrollSensitivity);
      if(pointer[1] > (p[3]-this.options.scrollSensitivity)) speed[1] = pointer[1]-(p[3]-this.options.scrollSensitivity);
      this.startScrolling(speed);
    }

    // fix AppleWebKit rendering
    if(Prototype.Browser.WebKit) window.scrollBy(0,0);

    Event.stop(event);
  },

  finishDrag: function(event, success) {
    this.dragging = false;

    if(this.options.quiet){
      Position.prepare();
      var pointer = [Event.pointerX(event), Event.pointerY(event)];
      Droppables.show(pointer, this.element);
    }

    if(this.options.ghosting) {
      if (!!this._originallyAbsolute)
        Position.relativize(this.element);
      delete this._originallyAbsolute;
      Element.remove(this._clone);
      this._clone = null;
    }

    var dropped = false;
    if(success) {
      dropped = Droppables.fire(event, this.element);
      if (!!dropped) dropped = false;
    }
    if(dropped && this.options.onDropped) this.options.onDropped(this.element);
    Draggables.notify(''onEnd'', this, event);

    var revert = this.options.revert;
    if(revert && Object.isFunction(revert)) revert = revert(this.element);

    var d = this.currentDelta();
    if(revert && this.options.reverteffect) {
      if (dropped == 0 || revert !!= ''failure'')
        this.options.reverteffect(this.element,
          d[1]-this.delta[1], d[0]-this.delta[0]);
    } else {
      this.delta = d;
    }

    if(this.options.zindex)
      this.element.style.zIndex = this.originalZ;

    if(this.options.endeffect)
      this.options.endeffect(this.element);

    Draggables.deactivate(this);
    Droppables.reset();
  },

  keyPress: function(event) {
    if(event.keyCode!!=Event.KEY_ESC) return;
    this.finishDrag(event, false);
    Event.stop(event);
  },

  endDrag: function(event) {
    if(!!this.dragging) return;
    this.stopScrolling();
    this.finishDrag(event, true);
    Event.stop(event);
  },

  draw: function(point) {
    var pos = Position.cumulativeOffset(this.element);
    if(this.options.ghosting) {
      var r   = Position.realOffset(this.element);
      pos[0] += r[0] - Position.deltaX; pos[1] += r[1] - Position.deltaY;
    }

    var d = this.currentDelta();
    pos[0] -= d[0]; pos[1] -= d[1];

    if(this.options.scroll && (this.options.scroll !!= window && this._isScrollChild)) {
      pos[0] -= this.options.scroll.scrollLeft-this.originalScrollLeft;
      pos[1] -= this.options.scroll.scrollTop-this.originalScrollTop;
    }

    var p = [0,1].map(function(i){
      return (point[i]-pos[i]-this.offset[i])
    }.bind(this));

    if(this.options.snap) {
      if(Object.isFunction(this.options.snap)) {
        p = this.options.snap(p[0],p[1],this);
      } else {
      if(Object.isArray(this.options.snap)) {
        p = p.map( function(v, i) {
          return (v/this.options.snap[i]).round()*this.options.snap[i] }.bind(this));
      } else {
        p = p.map( function(v) {
          return (v/this.options.snap).round()*this.options.snap }.bind(this));
      }
    }}

    var style = this.element.style;
    if((!!this.options.constraint) || (this.options.constraint==''horizontal''))
      style.left = p[0] + "px";
    if((!!this.options.constraint) || (this.options.constraint==''vertical''))
      style.top  = p[1] + "px";

    if(style.visibility=="hidden") style.visibility = ""; // fix gecko rendering
  },

  stopScrolling: function() {
    if(this.scrollInterval) {
      clearInterval(this.scrollInterval);
      this.scrollInterval = null;
      Draggables._lastScrollPointer = null;
    }
  },

  startScrolling: function(speed) {
    if(!!(speed[0] || speed[1])) return;
    this.scrollSpeed = [speed[0]*this.options.scrollSpeed,speed[1]*this.options.scrollSpeed];
    this.lastScrolled = new Date();
    this.scrollInterval = setInterval(this.scroll.bind(this), 10);
  },

  scroll: function() {
    var current = new Date();
    var delta = current - this.lastScrolled;
    this.lastScrolled = current;
    if(this.options.scroll == window) {
      with (this._getWindowScroll(this.options.scroll)) {
        if (this.scrollSpeed[0] || this.scrollSpeed[1]) {
          var d = delta / 1000;
          this.options.scroll.scrollTo( left + d*this.scrollSpeed[0], top + d*this.scrollSpeed[1] );
        }
      }
    } else {
      this.options.scroll.scrollLeft += this.scrollSpeed[0] * delta / 1000;
      this.options.scroll.scrollTop  += this.scrollSpeed[1] * delta / 1000;
    }

    Position.prepare();
    Droppables.show(Draggables._lastPointer, this.element);
    Draggables.notify(''onDrag'', this);
    if (this._isScrollChild) {
      Draggables._lastScrollPointer = Draggables._lastScrollPointer || $A(Draggables._lastPointer);
      Draggables._lastScrollPointer[0] += this.scrollSpeed[0] * delta / 1000;
      Draggables._lastScrollPointer[1] += this.scrollSpeed[1] * delta / 1000;
      if (Draggables._lastScrollPointer[0] < 0)
        Draggables._lastScrollPointer[0] = 0;
      if (Draggables._lastScrollPointer[1] < 0)
        Draggables._lastScrollPointer[1] = 0;
      this.draw(Draggables._lastScrollPointer);
    }

    if(this.options.change) this.options.change(this);
  },

  _getWindowScroll: function(w) {
    var T, L, W, H;
    with (w.document) {
      if (w.document.documentElement && documentElement.scrollTop) {
        T = documentElement.scrollTop;
        L = documentElement.scrollLeft;
      } else if (w.document.body) {
        T = body.scrollTop;
        L = body.scrollLeft;
      }
      if (w.innerWidth) {
        W = w.innerWidth;
        H = w.innerHeight;
      } else if (w.document.documentElement && documentElement.clientWidth) {
        W = documentElement.clientWidth;
        H = documentElement.clientHeight;
      } else {
        W = body.offsetWidth;
        H = body.offsetHeight;
      }
    }
    return { top: T, left: L, width: W, height: H };
  }
});

Draggable._dragging = { };

/*--------------------------------------------------------------------------*/

var SortableObserver = Class.create({
  initialize: function(element, observer) {
    this.element   = $(element);
    this.observer  = observer;
    this.lastValue = Sortable.serialize(this.element);
  },

  onStart: function() {
    this.lastValue = Sortable.serialize(this.element);
  },

  onEnd: function() {
    Sortable.unmark();
    if(this.lastValue !!= Sortable.serialize(this.element))
      this.observer(this.element)
  }
});

var Sortable = {
  SERIALIZE_RULE: /^[^_\-](?:[A-Za-z0-9\-\_]*)[_](.*)$/,

  sortables: { },

  _findRootElement: function(element) {
    while (element.tagName.toUpperCase() !!= "BODY") {
      if(element.id && Sortable.sortables[element.id]) return element;
      element = element.parentNode;
    }
  },

  options: function(element) {
    element = Sortable._findRootElement($(element));
    if(!!element) return;
    return Sortable.sortables[element.id];
  },

  destroy: function(element){
    element = $(element);
    var s = Sortable.sortables[element.id];

    if(s) {
      Draggables.removeObserver(s.element);
      s.droppables.each(function(d){ Droppables.remove(d) });
      s.draggables.invoke(''destroy'');

      delete Sortable.sortables[s.element.id];
    }
  },

  create: function(element) {
    element = $(element);
    var options = Object.extend({
      element:     element,
      tag:         ''li'',       // assumes li children, override with tag: ''tagname''
      dropOnEmpty: false,
      tree:        false,
      treeTag:     ''ul'',
      overlap:     ''vertical'', // one of ''vertical'', ''horizontal''
      constraint:  ''vertical'', // one of ''vertical'', ''horizontal'', false
      containment: element,    // also takes array of elements (or id''s); or false
      handle:      false,      // or a CSS class
      only:        false,
      delay:       0,
      hoverclass:  null,
      ghosting:    false,
      quiet:       false,
      scroll:      false,
      scrollSensitivity: 20,
      scrollSpeed: 15,
      format:      this.SERIALIZE_RULE,

      // these take arrays of elements or ids and can be
      // used for better initialization performance
      elements:    false,
      handles:     false,

      onChange:    Prototype.emptyFunction,
      onUpdate:    Prototype.emptyFunction
    }, arguments[1] || { });

    // clear any old sortable with same element
    this.destroy(element);

    // build options for the draggables
    var options_for_draggable = {
      revert:      true,
      quiet:       options.quiet,
      scroll:      options.scroll,
      scrollSpeed: options.scrollSpeed,
      scrollSensitivity: options.scrollSensitivity,
      delay:       options.delay,
      ghosting:    options.ghosting,
      constraint:  options.constraint,
      handle:      options.handle };

    if(options.starteffect)
      options_for_draggable.starteffect = options.starteffect;

    if(options.reverteffect)
      options_for_draggable.reverteffect = options.reverteffect;
    else
      if(options.ghosting) options_for_draggable.reverteffect = function(element) {
        element.style.top  = 0;
        element.style.left = 0;
      };

    if(options.endeffect)
      options_for_draggable.endeffect = options.endeffect;

    if(options.zindex)
      options_for_draggable.zindex = options.zindex;

    // build options for the droppables
    var options_for_droppable = {
      overlap:     options.overlap,
      containment: options.containment,
      tree:        options.tree,
      hoverclass:  options.hoverclass,
      onHover:     Sortable.onHover
    };

    var options_for_tree = {
      onHover:      Sortable.onEmptyHover,
      overlap:      options.overlap,
      containment:  options.containment,
      hoverclass:   options.hoverclass
    };

    // fix for gecko engine
    Element.cleanWhitespace(element);

    options.draggables = [];
    options.droppables = [];

    // drop on empty handling
    if(options.dropOnEmpty || options.tree) {
      Droppables.add(element, options_for_tree);
      options.droppables.push(element);
    }

    (options.elements || this.findElements(element, options) || []).each( function(e,i) {
      var handle = options.handles ? $(options.handles[i]) :
        (options.handle ? $(e).select(''.'' + options.handle)[0] : e);
      options.draggables.push(
        new Draggable(e, Object.extend(options_for_draggable, { handle: handle })));
      Droppables.add(e, options_for_droppable);
      if(options.tree) e.treeNode = element;
      options.droppables.push(e);
    });

    if(options.tree) {
      (Sortable.findTreeElements(element, options) || []).each( function(e) {
        Droppables.add(e, options_for_tree);
        e.treeNode = element;
        options.droppables.push(e);
      });
    }

    // keep reference
    this.sortables[element.id] = options;

    // for onupdate
    Draggables.addObserver(new SortableObserver(element, options.onUpdate));

  },

  // return all suitable-for-sortable elements in a guaranteed order
  findElements: function(element, options) {
    return Element.findChildren(
      element, options.only, options.tree ? true : false, options.tag);
  },

  findTreeElements: function(element, options) {
    return Element.findChildren(
      element, options.only, options.tree ? true : false, options.treeTag);
  },

  onHover: function(element, dropon, overlap) {
    if(Element.isParent(dropon, element)) return;

    if(overlap > .33 && overlap < .66 && Sortable.options(dropon).tree) {
      return;
    } else if(overlap>0.5) {
      Sortable.mark(dropon, ''before'');
      if(dropon.previousSibling !!= element) {
        var oldParentNode = element.parentNode;
        element.style.visibility = "hidden"; // fix gecko rendering
        dropon.parentNode.insertBefore(element, dropon);
        if(dropon.parentNode!!=oldParentNode)
          Sortable.options(oldParentNode).onChange(element);
        Sortable.options(dropon.parentNode).onChange(element);
      }
    } else {
      Sortable.mark(dropon, ''after'');
      var nextElement = dropon.nextSibling || null;
      if(nextElement !!= element) {
        var oldParentNode = element.parentNode;
        element.style.visibility = "hidden"; // fix gecko rendering
        dropon.parentNode.insertBefore(element, nextElement);
        if(dropon.parentNode!!=oldParentNode)
          Sortable.options(oldParentNode).onChange(element);
        Sortable.options(dropon.parentNode).onChange(element);
      }
    }
  },

  onEmptyHover: function(element, dropon, overlap) {
    var oldParentNode = element.parentNode;
    var droponOptions = Sortable.options(dropon);

    if(!!Element.isParent(dropon, element)) {
      var index;

      var children = Sortable.findElements(dropon, {tag: droponOptions.tag, only: droponOptions.only});
      var child = null;

      if(children) {
        var offset = Element.offsetSize(dropon, droponOptions.overlap) * (1.0 - overlap);

        for (index = 0; index < children.length; index += 1) {
          if (offset - Element.offsetSize (children[index], droponOptions.overlap) >= 0) {
            offset -= Element.offsetSize (children[index], droponOptions.overlap);
          } else if (offset - (Element.offsetSize (children[index], droponOptions.overlap) / 2) >= 0) {
            child = index + 1 < children.length ? children[index + 1] : null;
            break;
          } else {
            child = children[index];
            break;
          }
        }
      }

      dropon.insertBefore(element, child);

      Sortable.options(oldParentNode).onChange(element);
      droponOptions.onChange(element);
    }
  },

  unmark: function() {
    if(Sortable._marker) Sortable._marker.hide();
  },

  mark: function(dropon, position) {
    // mark on ghosting only
    var sortable = Sortable.options(dropon.parentNode);
    if(sortable && !!sortable.ghosting) return;

    if(!!Sortable._marker) {
      Sortable._marker =
        ($(''dropmarker'') || Element.extend(document.createElement(''DIV''))).
          hide().addClassName(''dropmarker'').setStyle({position:''absolute''});
      document.getElementsByTagName("body").item(0).appendChild(Sortable._marker);
    }
    var offsets = Position.cumulativeOffset(dropon);
    Sortable._marker.setStyle({left: offsets[0]+''px'', top: offsets[1] + ''px''});

    if(position==''after'')
      if(sortable.overlap == ''horizontal'')
        Sortable._marker.setStyle({left: (offsets[0]+dropon.clientWidth) + ''px''});
      else
        Sortable._marker.setStyle({top: (offsets[1]+dropon.clientHeight) + ''px''});

    Sortable._marker.show();
  },

  _tree: function(element, options, parent) {
    var children = Sortable.findElements(element, options) || [];

    for (var i = 0; i < children.length; ++i) {
      var match = children[i].id.match(options.format);

      if (!!match) continue;

      var child = {
        id: encodeURIComponent(match ? match[1] : null),
        element: element,
        parent: parent,
        children: [],
        position: parent.children.length,
        container: $(children[i]).down(options.treeTag)
      };

      /* Get the element containing the children and recurse over it */
      if (child.container)
        this._tree(child.container, options, child);

      parent.children.push (child);
    }

    return parent;
  },

  tree: function(element) {
    element = $(element);
    var sortableOptions = this.options(element);
    var options = Object.extend({
      tag: sortableOptions.tag,
      treeTag: sortableOptions.treeTag,
      only: sortableOptions.only,
      name: element.id,
      format: sortableOptions.format
    }, arguments[1] || { });

    var root = {
      id: null,
      parent: null,
      children: [],
      container: element,
      position: 0
    };

    return Sortable._tree(element, options, root);
  },

  /* Construct a [i] index for a particular node */
  _constructIndex: function(node) {
    var index = '''';
    do {
      if (node.id) index = ''['' + node.position + '']'' + index;
    } while ((node = node.parent) !!= null);
    return index;
  },

  sequence: function(element) {
    element = $(element);
    var options = Object.extend(this.options(element), arguments[1] || { });

    return $(this.findElements(element, options) || []).map( function(item) {
      return item.id.match(options.format) ? item.id.match(options.format)[1] : '''';
    });
  },

  setSequence: function(element, new_sequence) {
    element = $(element);
    var options = Object.extend(this.options(element), arguments[2] || { });

    var nodeMap = { };
    this.findElements(element, options).each( function(n) {
        if (n.id.match(options.format))
            nodeMap[n.id.match(options.format)[1]] = [n, n.parentNode];
        n.parentNode.removeChild(n);
    });

    new_sequence.each(function(ident) {
      var n = nodeMap[ident];
      if (n) {
        n[1].appendChild(n[0]);
        delete nodeMap[ident];
      }
    });
  },

  serialize: function(element) {
    element = $(element);
    var options = Object.extend(Sortable.options(element), arguments[1] || { });
    var name = encodeURIComponent(
      (arguments[1] && arguments[1].name) ? arguments[1].name : element.id);

    if (options.tree) {
      return Sortable.tree(element, arguments[1]).children.map( function (item) {
        return [name + Sortable._constructIndex(item) + "[id]=" +
                encodeURIComponent(item.id)].concat(item.children.map(arguments.callee));
      }).flatten().join(''&'');
    } else {
      return Sortable.sequence(element, arguments[1]).map( function(item) {
        return name + "[]=" + encodeURIComponent(item);
      }).join(''&'');
    }
  }
};

// Returns true if child is contained within element
Element.isParent = function(child, element) {
  if (!!child.parentNode || child == element) return false;
  if (child.parentNode == element) return true;
  return Element.isParent(child.parentNode, element);
};

Element.findChildren = function(element, only, recursive, tagName) {
  if(!!element.hasChildNodes()) return null;
  tagName = tagName.toUpperCase();
  if(only) only = [only].flatten();
  var elements = [];
  $A(element.childNodes).each( function(e) {
    if(e.tagName && e.tagName.toUpperCase()==tagName &&
      (!!only || (Element.classNames(e).detect(function(v) { return only.include(v) }))))
        elements.push(e);
    if(recursive) {
      var grandchildren = Element.findChildren(e, only, recursive, tagName);
      if(grandchildren) elements.push(grandchildren);
    }
  });

  return (elements.length>0 ? elements.flatten() : []);
};

Element.offsetSize = function (element, type) {
  return element[''offset'' + ((type==''vertical'' || type==''height'') ? ''Height'' : ''Width'')];
};
'!

scriptaculousDragDropJsResource
	"WebStyle new scriptaculousDragDropJsResource"
	^self resources at: #jsScriptaculousDragDrop ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousDragDropJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/dragdrop.js' site: self site].!

scriptaculousEffectsJs
	"effects.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us effects.js v1.8.2, Tue Nov 18 18:30:58 +0100 2008

// Copyright (c) 2005-2008 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
// Contributors:
//  Justin Palmer (http://encytemedia.com/)
//  Mark Pilgrim (http://diveintomark.org/)
//  Martin Bialasinki
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

// converts rgb() and #xxx to #xxxxxx format,
// returns self (or first argument) if not convertable
String.prototype.parseColor = function() {
  var color = ''#'';
  if (this.slice(0,4) == ''rgb('') {
    var cols = this.slice(4,this.length-1).split('','');
    var i=0; do { color += parseInt(cols[i]).toColorPart() } while (++i<3);
  } else {
    if (this.slice(0,1) == ''#'') {
      if (this.length==4) for(var i=1;i<4;i++) color += (this.charAt(i) + this.charAt(i)).toLowerCase();
      if (this.length==7) color = this.toLowerCase();
    }
  }
  return (color.length==7 ? color : (arguments[0] || this));
};

/*--------------------------------------------------------------------------*/

Element.collectTextNodes = function(element) {
  return $A($(element).childNodes).collect( function(node) {
    return (node.nodeType==3 ? node.nodeValue :
      (node.hasChildNodes() ? Element.collectTextNodes(node) : ''''));
  }).flatten().join('''');
};

Element.collectTextNodesIgnoreClass = function(element, className) {
  return $A($(element).childNodes).collect( function(node) {
    return (node.nodeType==3 ? node.nodeValue :
      ((node.hasChildNodes() && !!Element.hasClassName(node,className)) ?
        Element.collectTextNodesIgnoreClass(node, className) : ''''));
  }).flatten().join('''');
};

Element.setContentZoom = function(element, percent) {
  element = $(element);
  element.setStyle({fontSize: (percent/100) + ''em''});
  if (Prototype.Browser.WebKit) window.scrollBy(0,0);
  return element;
};

Element.getInlineOpacity = function(element){
  return $(element).style.opacity || '''';
};

Element.forceRerendering = function(element) {
  try {
    element = $(element);
    var n = document.createTextNode('' '');
    element.appendChild(n);
    element.removeChild(n);
  } catch(e) { }
};

/*--------------------------------------------------------------------------*/

var Effect = {
  _elementDoesNotExistError: {
    name: ''ElementDoesNotExistError'',
    message: ''The specified DOM element does not exist, but is required for this effect to operate''
  },
  Transitions: {
    linear: Prototype.K,
    sinoidal: function(pos) {
      return (-Math.cos(pos*Math.PI)/2) + .5;
    },
    reverse: function(pos) {
      return 1-pos;
    },
    flicker: function(pos) {
      var pos = ((-Math.cos(pos*Math.PI)/4) + .75) + Math.random()/4;
      return pos > 1 ? 1 : pos;
    },
    wobble: function(pos) {
      return (-Math.cos(pos*Math.PI*(9*pos))/2) + .5;
    },
    pulse: function(pos, pulses) {
      return (-Math.cos((pos*((pulses||5)-.5)*2)*Math.PI)/2) + .5;
    },
    spring: function(pos) {
      return 1 - (Math.cos(pos * 4.5 * Math.PI) * Math.exp(-pos * 6));
    },
    none: function(pos) {
      return 0;
    },
    full: function(pos) {
      return 1;
    }
  },
  DefaultOptions: {
    duration:   1.0,   // seconds
    fps:        100,   // 100= assume 66fps max.
    sync:       false, // true for combining
    from:       0.0,
    to:         1.0,
    delay:      0.0,
    queue:      ''parallel''
  },
  tagifyText: function(element) {
    var tagifyStyle = ''position:relative'';
    if (Prototype.Browser.IE) tagifyStyle += '';zoom:1'';

    element = $(element);
    $A(element.childNodes).each( function(child) {
      if (child.nodeType==3) {
        child.nodeValue.toArray().each( function(character) {
          element.insertBefore(
            new Element(''span'', {style: tagifyStyle}).update(
              character == '' '' ? String.fromCharCode(160) : character),
              child);
        });
        Element.remove(child);
      }
    });
  },
  multiple: function(element, effect) {
    var elements;
    if (((typeof element == ''object'') ||
        Object.isFunction(element)) &&
       (element.length))
      elements = element;
    else
      elements = $(element).childNodes;

    var options = Object.extend({
      speed: 0.1,
      delay: 0.0
    }, arguments[2] || { });
    var masterDelay = options.delay;

    $A(elements).each( function(element, index) {
      new effect(element, Object.extend(options, { delay: index * options.speed + masterDelay }));
    });
  },
  PAIRS: {
    ''slide'':  [''SlideDown'',''SlideUp''],
    ''blind'':  [''BlindDown'',''BlindUp''],
    ''appear'': [''Appear'',''Fade'']
  },
  toggle: function(element, effect) {
    element = $(element);
    effect = (effect || ''appear'').toLowerCase();
    var options = Object.extend({
      queue: { position:''end'', scope:(element.id || ''global''), limit: 1 }
    }, arguments[2] || { });
    Effect[element.visible() ?
      Effect.PAIRS[effect][1] : Effect.PAIRS[effect][0]](element, options);
  }
};

Effect.DefaultOptions.transition = Effect.Transitions.sinoidal;

/* ------------- core effects ------------- */

Effect.ScopedQueue = Class.create(Enumerable, {
  initialize: function() {
    this.effects  = [];
    this.interval = null;
  },
  _each: function(iterator) {
    this.effects._each(iterator);
  },
  add: function(effect) {
    var timestamp = new Date().getTime();

    var position = Object.isString(effect.options.queue) ?
      effect.options.queue : effect.options.queue.position;

    switch(position) {
      case ''front'':
        // move unstarted effects after this effect
        this.effects.findAll(function(e){ return e.state==''idle'' }).each( function(e) {
            e.startOn  += effect.finishOn;
            e.finishOn += effect.finishOn;
          });
        break;
      case ''with-last'':
        timestamp = this.effects.pluck(''startOn'').max() || timestamp;
        break;
      case ''end'':
        // start effect after last queued effect has finished
        timestamp = this.effects.pluck(''finishOn'').max() || timestamp;
        break;
    }

    effect.startOn  += timestamp;
    effect.finishOn += timestamp;

    if (!!effect.options.queue.limit || (this.effects.length < effect.options.queue.limit))
      this.effects.push(effect);

    if (!!this.interval)
      this.interval = setInterval(this.loop.bind(this), 15);
  },
  remove: function(effect) {
    this.effects = this.effects.reject(function(e) { return e==effect });
    if (this.effects.length == 0) {
      clearInterval(this.interval);
      this.interval = null;
    }
  },
  loop: function() {
    var timePos = new Date().getTime();
    for(var i=0, len=this.effects.length;i<len;i++)
      this.effects[i] && this.effects[i].loop(timePos);
  }
});

Effect.Queues = {
  instances: $H(),
  get: function(queueName) {
    if (!!Object.isString(queueName)) return queueName;

    return this.instances.get(queueName) ||
      this.instances.set(queueName, new Effect.ScopedQueue());
  }
};
Effect.Queue = Effect.Queues.get(''global'');

Effect.Base = Class.create({
  position: null,
  start: function(options) {
    function codeForEvent(options,eventName){
      return (
        (options[eventName+''Internal''] ? ''this.options.''+eventName+''Internal(this);'' : '''') +
        (options[eventName] ? ''this.options.''+eventName+''(this);'' : '''')
      );
    }
    if (options && options.transition === false) options.transition = Effect.Transitions.linear;
    this.options      = Object.extend(Object.extend({ },Effect.DefaultOptions), options || { });
    this.currentFrame = 0;
    this.state        = ''idle'';
    this.startOn      = this.options.delay*1000;
    this.finishOn     = this.startOn+(this.options.duration*1000);
    this.fromToDelta  = this.options.to-this.options.from;
    this.totalTime    = this.finishOn-this.startOn;
    this.totalFrames  = this.options.fps*this.options.duration;

    this.render = (function() {
      function dispatch(effect, eventName) {
        if (effect.options[eventName + ''Internal''])
          effect.options[eventName + ''Internal''](effect);
        if (effect.options[eventName])
          effect.options[eventName](effect);
      }

      return function(pos) {
        if (this.state === "idle") {
          this.state = "running";
          dispatch(this, ''beforeSetup'');
          if (this.setup) this.setup();
          dispatch(this, ''afterSetup'');
        }
        if (this.state === "running") {
          pos = (this.options.transition(pos) * this.fromToDelta) + this.options.from;
          this.position = pos;
          dispatch(this, ''beforeUpdate'');
          if (this.update) this.update(pos);
          dispatch(this, ''afterUpdate'');
        }
      };
    })();

    this.event(''beforeStart'');
    if (!!this.options.sync)
      Effect.Queues.get(Object.isString(this.options.queue) ?
        ''global'' : this.options.queue.scope).add(this);
  },
  loop: function(timePos) {
    if (timePos >= this.startOn) {
      if (timePos >= this.finishOn) {
        this.render(1.0);
        this.cancel();
        this.event(''beforeFinish'');
        if (this.finish) this.finish();
        this.event(''afterFinish'');
        return;
      }
      var pos   = (timePos - this.startOn) / this.totalTime,
          frame = (pos * this.totalFrames).round();
      if (frame > this.currentFrame) {
        this.render(pos);
        this.currentFrame = frame;
      }
    }
  },
  cancel: function() {
    if (!!this.options.sync)
      Effect.Queues.get(Object.isString(this.options.queue) ?
        ''global'' : this.options.queue.scope).remove(this);
    this.state = ''finished'';
  },
  event: function(eventName) {
    if (this.options[eventName + ''Internal'']) this.options[eventName + ''Internal''](this);
    if (this.options[eventName]) this.options[eventName](this);
  },
  inspect: function() {
    var data = $H();
    for(property in this)
      if (!!Object.isFunction(this[property])) data.set(property, this[property]);
    return ''#<Effect:'' + data.inspect() + '',options:'' + $H(this.options).inspect() + ''>'';
  }
});

Effect.Parallel = Class.create(Effect.Base, {
  initialize: function(effects) {
    this.effects = effects || [];
    this.start(arguments[1]);
  },
  update: function(position) {
    this.effects.invoke(''render'', position);
  },
  finish: function(position) {
    this.effects.each( function(effect) {
      effect.render(1.0);
      effect.cancel();
      effect.event(''beforeFinish'');
      if (effect.finish) effect.finish(position);
      effect.event(''afterFinish'');
    });
  }
});

Effect.Tween = Class.create(Effect.Base, {
  initialize: function(object, from, to) {
    object = Object.isString(object) ? $(object) : object;
    var args = $A(arguments), method = args.last(),
      options = args.length == 5 ? args[3] : null;
    this.method = Object.isFunction(method) ? method.bind(object) :
      Object.isFunction(object[method]) ? object[method].bind(object) :
      function(value) { object[method] = value };
    this.start(Object.extend({ from: from, to: to }, options || { }));
  },
  update: function(position) {
    this.method(position);
  }
});

Effect.Event = Class.create(Effect.Base, {
  initialize: function() {
    this.start(Object.extend({ duration: 0 }, arguments[0] || { }));
  },
  update: Prototype.emptyFunction
});

Effect.Opacity = Class.create(Effect.Base, {
  initialize: function(element) {
    this.element = $(element);
    if (!!this.element) throw(Effect._elementDoesNotExistError);
    // make this work on IE on elements without ''layout''
    if (Prototype.Browser.IE && (!!this.element.currentStyle.hasLayout))
      this.element.setStyle({zoom: 1});
    var options = Object.extend({
      from: this.element.getOpacity() || 0.0,
      to:   1.0
    }, arguments[1] || { });
    this.start(options);
  },
  update: function(position) {
    this.element.setOpacity(position);
  }
});

Effect.Move = Class.create(Effect.Base, {
  initialize: function(element) {
    this.element = $(element);
    if (!!this.element) throw(Effect._elementDoesNotExistError);
    var options = Object.extend({
      x:    0,
      y:    0,
      mode: ''relative''
    }, arguments[1] || { });
    this.start(options);
  },
  setup: function() {
    this.element.makePositioned();
    this.originalLeft = parseFloat(this.element.getStyle(''left'') || ''0'');
    this.originalTop  = parseFloat(this.element.getStyle(''top'')  || ''0'');
    if (this.options.mode == ''absolute'') {
      this.options.x = this.options.x - this.originalLeft;
      this.options.y = this.options.y - this.originalTop;
    }
  },
  update: function(position) {
    this.element.setStyle({
      left: (this.options.x  * position + this.originalLeft).round() + ''px'',
      top:  (this.options.y  * position + this.originalTop).round()  + ''px''
    });
  }
});

// for backwards compatibility
Effect.MoveBy = function(element, toTop, toLeft) {
  return new Effect.Move(element,
    Object.extend({ x: toLeft, y: toTop }, arguments[3] || { }));
};

Effect.Scale = Class.create(Effect.Base, {
  initialize: function(element, percent) {
    this.element = $(element);
    if (!!this.element) throw(Effect._elementDoesNotExistError);
    var options = Object.extend({
      scaleX: true,
      scaleY: true,
      scaleContent: true,
      scaleFromCenter: false,
      scaleMode: ''box'',        // ''box'' or ''contents'' or { } with provided values
      scaleFrom: 100.0,
      scaleTo:   percent
    }, arguments[2] || { });
    this.start(options);
  },
  setup: function() {
    this.restoreAfterFinish = this.options.restoreAfterFinish || false;
    this.elementPositioning = this.element.getStyle(''position'');

    this.originalStyle = { };
    [''top'',''left'',''width'',''height'',''fontSize''].each( function(k) {
      this.originalStyle[k] = this.element.style[k];
    }.bind(this));

    this.originalTop  = this.element.offsetTop;
    this.originalLeft = this.element.offsetLeft;

    var fontSize = this.element.getStyle(''font-size'') || ''100%'';
    [''em'',''px'',''%'',''pt''].each( function(fontSizeType) {
      if (fontSize.indexOf(fontSizeType)>0) {
        this.fontSize     = parseFloat(fontSize);
        this.fontSizeType = fontSizeType;
      }
    }.bind(this));

    this.factor = (this.options.scaleTo - this.options.scaleFrom)/100;

    this.dims = null;
    if (this.options.scaleMode==''box'')
      this.dims = [this.element.offsetHeight, this.element.offsetWidth];
    if (/^content/.test(this.options.scaleMode))
      this.dims = [this.element.scrollHeight, this.element.scrollWidth];
    if (!!this.dims)
      this.dims = [this.options.scaleMode.originalHeight,
                   this.options.scaleMode.originalWidth];
  },
  update: function(position) {
    var currentScale = (this.options.scaleFrom/100.0) + (this.factor * position);
    if (this.options.scaleContent && this.fontSize)
      this.element.setStyle({fontSize: this.fontSize * currentScale + this.fontSizeType });
    this.setDimensions(this.dims[0] * currentScale, this.dims[1] * currentScale);
  },
  finish: function(position) {
    if (this.restoreAfterFinish) this.element.setStyle(this.originalStyle);
  },
  setDimensions: function(height, width) {
    var d = { };
    if (this.options.scaleX) d.width = width.round() + ''px'';
    if (this.options.scaleY) d.height = height.round() + ''px'';
    if (this.options.scaleFromCenter) {
      var topd  = (height - this.dims[0])/2;
      var leftd = (width  - this.dims[1])/2;
      if (this.elementPositioning == ''absolute'') {
        if (this.options.scaleY) d.top = this.originalTop-topd + ''px'';
        if (this.options.scaleX) d.left = this.originalLeft-leftd + ''px'';
      } else {
        if (this.options.scaleY) d.top = -topd + ''px'';
        if (this.options.scaleX) d.left = -leftd + ''px'';
      }
    }
    this.element.setStyle(d);
  }
});

Effect.Highlight = Class.create(Effect.Base, {
  initialize: function(element) {
    this.element = $(element);
    if (!!this.element) throw(Effect._elementDoesNotExistError);
    var options = Object.extend({ startcolor: ''#ffff99'' }, arguments[1] || { });
    this.start(options);
  },
  setup: function() {
    // Prevent executing on elements not in the layout flow
    if (this.element.getStyle(''display'')==''none'') { this.cancel(); return; }
    // Disable background image during the effect
    this.oldStyle = { };
    if (!!this.options.keepBackgroundImage) {
      this.oldStyle.backgroundImage = this.element.getStyle(''background-image'');
      this.element.setStyle({backgroundImage: ''none''});
    }
    if (!!this.options.endcolor)
      this.options.endcolor = this.element.getStyle(''background-color'').parseColor(''#ffffff'');
    if (!!this.options.restorecolor)
      this.options.restorecolor = this.element.getStyle(''background-color'');
    // init color calculations
    this._base  = $R(0,2).map(function(i){ return parseInt(this.options.startcolor.slice(i*2+1,i*2+3),16) }.bind(this));
    this._delta = $R(0,2).map(function(i){ return parseInt(this.options.endcolor.slice(i*2+1,i*2+3),16)-this._base[i] }.bind(this));
  },
  update: function(position) {
    this.element.setStyle({backgroundColor: $R(0,2).inject(''#'',function(m,v,i){
      return m+((this._base[i]+(this._delta[i]*position)).round().toColorPart()); }.bind(this)) });
  },
  finish: function() {
    this.element.setStyle(Object.extend(this.oldStyle, {
      backgroundColor: this.options.restorecolor
    }));
  }
});

Effect.ScrollTo = function(element) {
  var options = arguments[1] || { },
  scrollOffsets = document.viewport.getScrollOffsets(),
  elementOffsets = $(element).cumulativeOffset();

  if (options.offset) elementOffsets[1] += options.offset;

  return new Effect.Tween(null,
    scrollOffsets.top,
    elementOffsets[1],
    options,
    function(p){ scrollTo(scrollOffsets.left, p.round()); }
  );
};

/* ------------- combination effects ------------- */

Effect.Fade = function(element) {
  element = $(element);
  var oldOpacity = element.getInlineOpacity();
  var options = Object.extend({
    from: element.getOpacity() || 1.0,
    to:   0.0,
    afterFinishInternal: function(effect) {
      if (effect.options.to!!=0) return;
      effect.element.hide().setStyle({opacity: oldOpacity});
    }
  }, arguments[1] || { });
  return new Effect.Opacity(element,options);
};

Effect.Appear = function(element) {
  element = $(element);
  var options = Object.extend({
  from: (element.getStyle(''display'') == ''none'' ? 0.0 : element.getOpacity() || 0.0),
  to:   1.0,
  // force Safari to render floated elements properly
  afterFinishInternal: function(effect) {
    effect.element.forceRerendering();
  },
  beforeSetup: function(effect) {
    effect.element.setOpacity(effect.options.from).show();
  }}, arguments[1] || { });
  return new Effect.Opacity(element,options);
};

Effect.Puff = function(element) {
  element = $(element);
  var oldStyle = {
    opacity: element.getInlineOpacity(),
    position: element.getStyle(''position''),
    top:  element.style.top,
    left: element.style.left,
    width: element.style.width,
    height: element.style.height
  };
  return new Effect.Parallel(
   [ new Effect.Scale(element, 200,
      { sync: true, scaleFromCenter: true, scaleContent: true, restoreAfterFinish: true }),
     new Effect.Opacity(element, { sync: true, to: 0.0 } ) ],
     Object.extend({ duration: 1.0,
      beforeSetupInternal: function(effect) {
        Position.absolutize(effect.effects[0].element);
      },
      afterFinishInternal: function(effect) {
         effect.effects[0].element.hide().setStyle(oldStyle); }
     }, arguments[1] || { })
   );
};

Effect.BlindUp = function(element) {
  element = $(element);
  element.makeClipping();
  return new Effect.Scale(element, 0,
    Object.extend({ scaleContent: false,
      scaleX: false,
      restoreAfterFinish: true,
      afterFinishInternal: function(effect) {
        effect.element.hide().undoClipping();
      }
    }, arguments[1] || { })
  );
};

Effect.BlindDown = function(element) {
  element = $(element);
  var elementDimensions = element.getDimensions();
  return new Effect.Scale(element, 100, Object.extend({
    scaleContent: false,
    scaleX: false,
    scaleFrom: 0,
    scaleMode: {originalHeight: elementDimensions.height, originalWidth: elementDimensions.width},
    restoreAfterFinish: true,
    afterSetup: function(effect) {
      effect.element.makeClipping().setStyle({height: ''0px''}).show();
    },
    afterFinishInternal: function(effect) {
      effect.element.undoClipping();
    }
  }, arguments[1] || { }));
};

Effect.SwitchOff = function(element) {
  element = $(element);
  var oldOpacity = element.getInlineOpacity();
  return new Effect.Appear(element, Object.extend({
    duration: 0.4,
    from: 0,
    transition: Effect.Transitions.flicker,
    afterFinishInternal: function(effect) {
      new Effect.Scale(effect.element, 1, {
        duration: 0.3, scaleFromCenter: true,
        scaleX: false, scaleContent: false, restoreAfterFinish: true,
        beforeSetup: function(effect) {
          effect.element.makePositioned().makeClipping();
        },
        afterFinishInternal: function(effect) {
          effect.element.hide().undoClipping().undoPositioned().setStyle({opacity: oldOpacity});
        }
      });
    }
  }, arguments[1] || { }));
};

Effect.DropOut = function(element) {
  element = $(element);
  var oldStyle = {
    top: element.getStyle(''top''),
    left: element.getStyle(''left''),
    opacity: element.getInlineOpacity() };
  return new Effect.Parallel(
    [ new Effect.Move(element, {x: 0, y: 100, sync: true }),
      new Effect.Opacity(element, { sync: true, to: 0.0 }) ],
    Object.extend(
      { duration: 0.5,
        beforeSetup: function(effect) {
          effect.effects[0].element.makePositioned();
        },
        afterFinishInternal: function(effect) {
          effect.effects[0].element.hide().undoPositioned().setStyle(oldStyle);
        }
      }, arguments[1] || { }));
};

Effect.Shake = function(element) {
  element = $(element);
  var options = Object.extend({
    distance: 20,
    duration: 0.5
  }, arguments[1] || {});
  var distance = parseFloat(options.distance);
  var split = parseFloat(options.duration) / 10.0;
  var oldStyle = {
    top: element.getStyle(''top''),
    left: element.getStyle(''left'') };
    return new Effect.Move(element,
      { x:  distance, y: 0, duration: split, afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x: -distance*2, y: 0, duration: split*2,  afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x:  distance*2, y: 0, duration: split*2,  afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x: -distance*2, y: 0, duration: split*2,  afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x:  distance*2, y: 0, duration: split*2,  afterFinishInternal: function(effect) {
    new Effect.Move(effect.element,
      { x: -distance, y: 0, duration: split, afterFinishInternal: function(effect) {
        effect.element.undoPositioned().setStyle(oldStyle);
  }}); }}); }}); }}); }}); }});
};

Effect.SlideDown = function(element) {
  element = $(element).cleanWhitespace();
  // SlideDown need to have the content of the element wrapped in a container element with fixed height!!
  var oldInnerBottom = element.down().getStyle(''bottom'');
  var elementDimensions = element.getDimensions();
  return new Effect.Scale(element, 100, Object.extend({
    scaleContent: false,
    scaleX: false,
    scaleFrom: window.opera ? 0 : 1,
    scaleMode: {originalHeight: elementDimensions.height, originalWidth: elementDimensions.width},
    restoreAfterFinish: true,
    afterSetup: function(effect) {
      effect.element.makePositioned();
      effect.element.down().makePositioned();
      if (window.opera) effect.element.setStyle({top: ''''});
      effect.element.makeClipping().setStyle({height: ''0px''}).show();
    },
    afterUpdateInternal: function(effect) {
      effect.element.down().setStyle({bottom:
        (effect.dims[0] - effect.element.clientHeight) + ''px'' });
    },
    afterFinishInternal: function(effect) {
      effect.element.undoClipping().undoPositioned();
      effect.element.down().undoPositioned().setStyle({bottom: oldInnerBottom}); }
    }, arguments[1] || { })
  );
};

Effect.SlideUp = function(element) {
  element = $(element).cleanWhitespace();
  var oldInnerBottom = element.down().getStyle(''bottom'');
  var elementDimensions = element.getDimensions();
  return new Effect.Scale(element, window.opera ? 0 : 1,
   Object.extend({ scaleContent: false,
    scaleX: false,
    scaleMode: ''box'',
    scaleFrom: 100,
    scaleMode: {originalHeight: elementDimensions.height, originalWidth: elementDimensions.width},
    restoreAfterFinish: true,
    afterSetup: function(effect) {
      effect.element.makePositioned();
      effect.element.down().makePositioned();
      if (window.opera) effect.element.setStyle({top: ''''});
      effect.element.makeClipping().show();
    },
    afterUpdateInternal: function(effect) {
      effect.element.down().setStyle({bottom:
        (effect.dims[0] - effect.element.clientHeight) + ''px'' });
    },
    afterFinishInternal: function(effect) {
      effect.element.hide().undoClipping().undoPositioned();
      effect.element.down().undoPositioned().setStyle({bottom: oldInnerBottom});
    }
   }, arguments[1] || { })
  );
};

// Bug in opera makes the TD containing this element expand for a instance after finish
Effect.Squish = function(element) {
  return new Effect.Scale(element, window.opera ? 1 : 0, {
    restoreAfterFinish: true,
    beforeSetup: function(effect) {
      effect.element.makeClipping();
    },
    afterFinishInternal: function(effect) {
      effect.element.hide().undoClipping();
    }
  });
};

Effect.Grow = function(element) {
  element = $(element);
  var options = Object.extend({
    direction: ''center'',
    moveTransition: Effect.Transitions.sinoidal,
    scaleTransition: Effect.Transitions.sinoidal,
    opacityTransition: Effect.Transitions.full
  }, arguments[1] || { });
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    height: element.style.height,
    width: element.style.width,
    opacity: element.getInlineOpacity() };

  var dims = element.getDimensions();
  var initialMoveX, initialMoveY;
  var moveX, moveY;

  switch (options.direction) {
    case ''top-left'':
      initialMoveX = initialMoveY = moveX = moveY = 0;
      break;
    case ''top-right'':
      initialMoveX = dims.width;
      initialMoveY = moveY = 0;
      moveX = -dims.width;
      break;
    case ''bottom-left'':
      initialMoveX = moveX = 0;
      initialMoveY = dims.height;
      moveY = -dims.height;
      break;
    case ''bottom-right'':
      initialMoveX = dims.width;
      initialMoveY = dims.height;
      moveX = -dims.width;
      moveY = -dims.height;
      break;
    case ''center'':
      initialMoveX = dims.width / 2;
      initialMoveY = dims.height / 2;
      moveX = -dims.width / 2;
      moveY = -dims.height / 2;
      break;
  }

  return new Effect.Move(element, {
    x: initialMoveX,
    y: initialMoveY,
    duration: 0.01,
    beforeSetup: function(effect) {
      effect.element.hide().makeClipping().makePositioned();
    },
    afterFinishInternal: function(effect) {
      new Effect.Parallel(
        [ new Effect.Opacity(effect.element, { sync: true, to: 1.0, from: 0.0, transition: options.opacityTransition }),
          new Effect.Move(effect.element, { x: moveX, y: moveY, sync: true, transition: options.moveTransition }),
          new Effect.Scale(effect.element, 100, {
            scaleMode: { originalHeight: dims.height, originalWidth: dims.width },
            sync: true, scaleFrom: window.opera ? 1 : 0, transition: options.scaleTransition, restoreAfterFinish: true})
        ], Object.extend({
             beforeSetup: function(effect) {
               effect.effects[0].element.setStyle({height: ''0px''}).show();
             },
             afterFinishInternal: function(effect) {
               effect.effects[0].element.undoClipping().undoPositioned().setStyle(oldStyle);
             }
           }, options)
      );
    }
  });
};

Effect.Shrink = function(element) {
  element = $(element);
  var options = Object.extend({
    direction: ''center'',
    moveTransition: Effect.Transitions.sinoidal,
    scaleTransition: Effect.Transitions.sinoidal,
    opacityTransition: Effect.Transitions.none
  }, arguments[1] || { });
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    height: element.style.height,
    width: element.style.width,
    opacity: element.getInlineOpacity() };

  var dims = element.getDimensions();
  var moveX, moveY;

  switch (options.direction) {
    case ''top-left'':
      moveX = moveY = 0;
      break;
    case ''top-right'':
      moveX = dims.width;
      moveY = 0;
      break;
    case ''bottom-left'':
      moveX = 0;
      moveY = dims.height;
      break;
    case ''bottom-right'':
      moveX = dims.width;
      moveY = dims.height;
      break;
    case ''center'':
      moveX = dims.width / 2;
      moveY = dims.height / 2;
      break;
  }

  return new Effect.Parallel(
    [ new Effect.Opacity(element, { sync: true, to: 0.0, from: 1.0, transition: options.opacityTransition }),
      new Effect.Scale(element, window.opera ? 1 : 0, { sync: true, transition: options.scaleTransition, restoreAfterFinish: true}),
      new Effect.Move(element, { x: moveX, y: moveY, sync: true, transition: options.moveTransition })
    ], Object.extend({
         beforeStartInternal: function(effect) {
           effect.effects[0].element.makePositioned().makeClipping();
         },
         afterFinishInternal: function(effect) {
           effect.effects[0].element.hide().undoClipping().undoPositioned().setStyle(oldStyle); }
       }, options)
  );
};

Effect.Pulsate = function(element) {
  element = $(element);
  var options    = arguments[1] || { },
    oldOpacity = element.getInlineOpacity(),
    transition = options.transition || Effect.Transitions.linear,
    reverser   = function(pos){
      return 1 - transition((-Math.cos((pos*(options.pulses||5)*2)*Math.PI)/2) + .5);
    };

  return new Effect.Opacity(element,
    Object.extend(Object.extend({  duration: 2.0, from: 0,
      afterFinishInternal: function(effect) { effect.element.setStyle({opacity: oldOpacity}); }
    }, options), {transition: reverser}));
};

Effect.Fold = function(element) {
  element = $(element);
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    width: element.style.width,
    height: element.style.height };
  element.makeClipping();
  return new Effect.Scale(element, 5, Object.extend({
    scaleContent: false,
    scaleX: false,
    afterFinishInternal: function(effect) {
    new Effect.Scale(element, 1, {
      scaleContent: false,
      scaleY: false,
      afterFinishInternal: function(effect) {
        effect.element.hide().undoClipping().setStyle(oldStyle);
      } });
  }}, arguments[1] || { }));
};

Effect.Morph = Class.create(Effect.Base, {
  initialize: function(element) {
    this.element = $(element);
    if (!!this.element) throw(Effect._elementDoesNotExistError);
    var options = Object.extend({
      style: { }
    }, arguments[1] || { });

    if (!!Object.isString(options.style)) this.style = $H(options.style);
    else {
      if (options.style.include('':''))
        this.style = options.style.parseStyle();
      else {
        this.element.addClassName(options.style);
        this.style = $H(this.element.getStyles());
        this.element.removeClassName(options.style);
        var css = this.element.getStyles();
        this.style = this.style.reject(function(style) {
          return style.value == css[style.key];
        });
        options.afterFinishInternal = function(effect) {
          effect.element.addClassName(effect.options.style);
          effect.transforms.each(function(transform) {
            effect.element.style[transform.style] = '''';
          });
        };
      }
    }
    this.start(options);
  },

  setup: function(){
    function parseColor(color){
      if (!!color || [''rgba(0, 0, 0, 0)'',''transparent''].include(color)) color = ''#ffffff'';
      color = color.parseColor();
      return $R(0,2).map(function(i){
        return parseInt( color.slice(i*2+1,i*2+3), 16 );
      });
    }
    this.transforms = this.style.map(function(pair){
      var property = pair[0], value = pair[1], unit = null;

      if (value.parseColor(''#zzzzzz'') !!= ''#zzzzzz'') {
        value = value.parseColor();
        unit  = ''color'';
      } else if (property == ''opacity'') {
        value = parseFloat(value);
        if (Prototype.Browser.IE && (!!this.element.currentStyle.hasLayout))
          this.element.setStyle({zoom: 1});
      } else if (Element.CSS_LENGTH.test(value)) {
          var components = value.match(/^([\+\-]?[0-9\.]+)(.*)$/);
          value = parseFloat(components[1]);
          unit = (components.length == 3) ? components[2] : null;
      }

      var originalValue = this.element.getStyle(property);
      return {
        style: property.camelize(),
        originalValue: unit==''color'' ? parseColor(originalValue) : parseFloat(originalValue || 0),
        targetValue: unit==''color'' ? parseColor(value) : value,
        unit: unit
      };
    }.bind(this)).reject(function(transform){
      return (
        (transform.originalValue == transform.targetValue) ||
        (
          transform.unit !!= ''color'' &&
          (isNaN(transform.originalValue) || isNaN(transform.targetValue))
        )
      );
    });
  },
  update: function(position) {
    var style = { }, transform, i = this.transforms.length;
    while(i--)
      style[(transform = this.transforms[i]).style] =
        transform.unit==''color'' ? ''#''+
          (Math.round(transform.originalValue[0]+
            (transform.targetValue[0]-transform.originalValue[0])*position)).toColorPart() +
          (Math.round(transform.originalValue[1]+
            (transform.targetValue[1]-transform.originalValue[1])*position)).toColorPart() +
          (Math.round(transform.originalValue[2]+
            (transform.targetValue[2]-transform.originalValue[2])*position)).toColorPart() :
        (transform.originalValue +
          (transform.targetValue - transform.originalValue) * position).toFixed(3) +
            (transform.unit === null ? '''' : transform.unit);
    this.element.setStyle(style, true);
  }
});

Effect.Transform = Class.create({
  initialize: function(tracks){
    this.tracks  = [];
    this.options = arguments[1] || { };
    this.addTracks(tracks);
  },
  addTracks: function(tracks){
    tracks.each(function(track){
      track = $H(track);
      var data = track.values().first();
      this.tracks.push($H({
        ids:     track.keys().first(),
        effect:  Effect.Morph,
        options: { style: data }
      }));
    }.bind(this));
    return this;
  },
  play: function(){
    return new Effect.Parallel(
      this.tracks.map(function(track){
        var ids = track.get(''ids''), effect = track.get(''effect''), options = track.get(''options'');
        var elements = [$(ids) || $$(ids)].flatten();
        return elements.map(function(e){ return new effect(e, Object.extend({ sync:true }, options)) });
      }).flatten(),
      this.options
    );
  }
});

Element.CSS_PROPERTIES = $w(
  ''backgroundColor backgroundPosition borderBottomColor borderBottomStyle '' +
  ''borderBottomWidth borderLeftColor borderLeftStyle borderLeftWidth '' +
  ''borderRightColor borderRightStyle borderRightWidth borderSpacing '' +
  ''borderTopColor borderTopStyle borderTopWidth bottom clip color '' +
  ''fontSize fontWeight height left letterSpacing lineHeight '' +
  ''marginBottom marginLeft marginRight marginTop markerOffset maxHeight ''+
  ''maxWidth minHeight minWidth opacity outlineColor outlineOffset '' +
  ''outlineWidth paddingBottom paddingLeft paddingRight paddingTop '' +
  ''right textIndent top width wordSpacing zIndex'');

Element.CSS_LENGTH = /^(([\+\-]?[0-9\.]+)(em|ex|px|in|cm|mm|pt|pc|\%))|0$/;

String.__parseStyleElement = document.createElement(''div'');
String.prototype.parseStyle = function(){
  var style, styleRules = $H();
  if (Prototype.Browser.WebKit)
    style = new Element(''div'',{style:this}).style;
  else {
    String.__parseStyleElement.innerHTML = ''<div style="'' + this + ''"></div>'';
    style = String.__parseStyleElement.childNodes[0].style;
  }

  Element.CSS_PROPERTIES.each(function(property){
    if (style[property]) styleRules.set(property, style[property]);
  });

  if (Prototype.Browser.IE && this.include(''opacity''))
    styleRules.set(''opacity'', this.match(/opacity:\s*((?:0|1)?(?:\.\d*)?)/)[1]);

  return styleRules;
};

if (document.defaultView && document.defaultView.getComputedStyle) {
  Element.getStyles = function(element) {
    var css = document.defaultView.getComputedStyle($(element), null);
    return Element.CSS_PROPERTIES.inject({ }, function(styles, property) {
      styles[property] = css[property];
      return styles;
    });
  };
} else {
  Element.getStyles = function(element) {
    element = $(element);
    var css = element.currentStyle, styles;
    styles = Element.CSS_PROPERTIES.inject({ }, function(results, property) {
      results[property] = css[property];
      return results;
    });
    if (!!styles.opacity) styles.opacity = element.getOpacity();
    return styles;
  };
}

Effect.Methods = {
  morph: function(element, style) {
    element = $(element);
    new Effect.Morph(element, Object.extend({ style: style }, arguments[2] || { }));
    return element;
  },
  visualEffect: function(element, effect, options) {
    element = $(element);
    var s = effect.dasherize().camelize(), klass = s.charAt(0).toUpperCase() + s.substring(1);
    new Effect[klass](element, options);
    return element;
  },
  highlight: function(element, options) {
    element = $(element);
    new Effect.Highlight(element, options);
    return element;
  }
};

$w(''fade appear grow shrink fold blindUp blindDown slideUp slideDown ''+
  ''pulsate shake puff squish switchOff dropOut'').each(
  function(effect) {
    Effect.Methods[effect] = function(element, options){
      element = $(element);
      Effect[effect.charAt(0).toUpperCase() + effect.substring(1)](element, options);
      return element;
    };
  }
);

$w(''getInlineOpacity forceRerendering setContentZoom collectTextNodes collectTextNodesIgnoreClass getStyles'').each(
  function(f) { Effect.Methods[f] = Element[f]; }
);

Element.addMethods(Effect.Methods);
'!

scriptaculousEffectsJsResource
	"WebStyle new scriptaculousEffectsJsResource"
	^self resources at: #jsScriptaculousEffects ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousEffectsJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/effects.js' site: self site].!

scriptaculousJs
	"script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us scriptaculous.js v1.8.2, Tue Nov 18 18:30:58 +0100 2008

// Copyright (c) 2005-2008 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
//
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
//
// For details, see the script.aculo.us web site: http://script.aculo.us/

var Scriptaculous = {
  Version: ''1.8.2'',
  require: function(libraryName) {
    // inserting via DOM fails in Safari 2.0, so brute force approach
    document.write(''<script type="text/javascript" src="''+libraryName+''"><\/script>'');
  },
  REQUIRED_PROTOTYPE: ''1.6.0.3'',
  load: function() {
    function convertVersionString(versionString) {
      var v = versionString.replace(/_.*|\./g, '''');
      v = parseInt(v + ''0''.times(4-v.length));
      return versionString.indexOf(''_'') > -1 ? v-1 : v;
    }

    if((typeof Prototype==''undefined'') ||
       (typeof Element == ''undefined'') ||
       (typeof Element.Methods==''undefined'') ||
       (convertVersionString(Prototype.Version) <
        convertVersionString(Scriptaculous.REQUIRED_PROTOTYPE)))
       throw("script.aculo.us requires the Prototype JavaScript framework >= " +
        Scriptaculous.REQUIRED_PROTOTYPE);

    var js = /scriptaculous\.js(\?.*)?$/;
    $$(''head script[src]'').findAll(function(s) {
      return s.src.match(js);
    }).each(function(s) {
      var path = s.src.replace(js, ''''),
      includes = s.src.match(/\?.*load=([a-z,]*)/);
      (includes ? includes[1] : ''builder,effects,dragdrop,controls,slider,sound'').split('','').each(
       function(include) { Scriptaculous.require(path+include+''.js'') });
    });
  }
};

Scriptaculous.load();
'!

scriptaculousJsResource
	"WebStyle new scriptaculousJsResource"
	^self resources at: #jsScriptaculous ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/scriptaculous.js' site: self site].!

scriptaculousSliderJs
	"slider.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us slider.js v1.8.2, Tue Nov 18 18:30:58 +0100 2008

// Copyright (c) 2005-2008 Marty Haught, Thomas Fuchs
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

if (!!Control) var Control = { };

// options:
//  axis: ''vertical'', or ''horizontal'' (default)
//
// callbacks:
//  onChange(value)
//  onSlide(value)
Control.Slider = Class.create({
  initialize: function(handle, track, options) {
    var slider = this;

    if (Object.isArray(handle)) {
      this.handles = handle.collect( function(e) { return $(e) });
    } else {
      this.handles = [$(handle)];
    }

    this.track   = $(track);
    this.options = options || { };

    this.axis      = this.options.axis || ''horizontal'';
    this.increment = this.options.increment || 1;
    this.step      = parseInt(this.options.step || ''1'');
    this.range     = this.options.range || $R(0,1);

    this.value     = 0; // assure backwards compat
    this.values    = this.handles.map( function() { return 0 });
    this.spans     = this.options.spans ? this.options.spans.map(function(s){ return $(s) }) : false;
    this.options.startSpan = $(this.options.startSpan || null);
    this.options.endSpan   = $(this.options.endSpan || null);

    this.restricted = this.options.restricted || false;

    this.maximum   = this.options.maximum || this.range.end;
    this.minimum   = this.options.minimum || this.range.start;

    // Will be used to align the handle onto the track, if necessary
    this.alignX = parseInt(this.options.alignX || ''0'');
    this.alignY = parseInt(this.options.alignY || ''0'');

    this.trackLength = this.maximumOffset() - this.minimumOffset();

    this.handleLength = this.isVertical() ?
      (this.handles[0].offsetHeight !!= 0 ?
        this.handles[0].offsetHeight : this.handles[0].style.height.replace(/px$/,"")) :
      (this.handles[0].offsetWidth !!= 0 ? this.handles[0].offsetWidth :
        this.handles[0].style.width.replace(/px$/,""));

    this.active   = false;
    this.dragging = false;
    this.disabled = false;

    if (this.options.disabled) this.setDisabled();

    // Allowed values array
    this.allowedValues = this.options.values ? this.options.values.sortBy(Prototype.K) : false;
    if (this.allowedValues) {
      this.minimum = this.allowedValues.min();
      this.maximum = this.allowedValues.max();
    }

    this.eventMouseDown = this.startDrag.bindAsEventListener(this);
    this.eventMouseUp   = this.endDrag.bindAsEventListener(this);
    this.eventMouseMove = this.update.bindAsEventListener(this);

    // Initialize handles in reverse (make sure first handle is active)
    this.handles.each( function(h,i) {
      i = slider.handles.length-1-i;
      slider.setValue(parseFloat(
        (Object.isArray(slider.options.sliderValue) ?
          slider.options.sliderValue[i] : slider.options.sliderValue) ||
         slider.range.start), i);
      h.makePositioned().observe("mousedown", slider.eventMouseDown);
    });

    this.track.observe("mousedown", this.eventMouseDown);
    document.observe("mouseup", this.eventMouseUp);
    document.observe("mousemove", this.eventMouseMove);

    this.initialized = true;
  },
  dispose: function() {
    var slider = this;
    Event.stopObserving(this.track, "mousedown", this.eventMouseDown);
    Event.stopObserving(document, "mouseup", this.eventMouseUp);
    Event.stopObserving(document, "mousemove", this.eventMouseMove);
    this.handles.each( function(h) {
      Event.stopObserving(h, "mousedown", slider.eventMouseDown);
    });
  },
  setDisabled: function(){
    this.disabled = true;
  },
  setEnabled: function(){
    this.disabled = false;
  },
  getNearestValue: function(value){
    if (this.allowedValues){
      if (value >= this.allowedValues.max()) return(this.allowedValues.max());
      if (value <= this.allowedValues.min()) return(this.allowedValues.min());

      var offset = Math.abs(this.allowedValues[0] - value);
      var newValue = this.allowedValues[0];
      this.allowedValues.each( function(v) {
        var currentOffset = Math.abs(v - value);
        if (currentOffset <= offset){
          newValue = v;
          offset = currentOffset;
        }
      });
      return newValue;
    }
    if (value > this.range.end) return this.range.end;
    if (value < this.range.start) return this.range.start;
    return value;
  },
  setValue: function(sliderValue, handleIdx){
    if (!!this.active) {
      this.activeHandleIdx = handleIdx || 0;
      this.activeHandle    = this.handles[this.activeHandleIdx];
      this.updateStyles();
    }
    handleIdx = handleIdx || this.activeHandleIdx || 0;
    if (this.initialized && this.restricted) {
      if ((handleIdx>0) && (sliderValue<this.values[handleIdx-1]))
        sliderValue = this.values[handleIdx-1];
      if ((handleIdx < (this.handles.length-1)) && (sliderValue>this.values[handleIdx+1]))
        sliderValue = this.values[handleIdx+1];
    }
    sliderValue = this.getNearestValue(sliderValue);
    this.values[handleIdx] = sliderValue;
    this.value = this.values[0]; // assure backwards compat

    this.handles[handleIdx].style[this.isVertical() ? ''top'' : ''left''] =
      this.translateToPx(sliderValue);

    this.drawSpans();
    if (!!this.dragging || !!this.event) this.updateFinished();
  },
  setValueBy: function(delta, handleIdx) {
    this.setValue(this.values[handleIdx || this.activeHandleIdx || 0] + delta,
      handleIdx || this.activeHandleIdx || 0);
  },
  translateToPx: function(value) {
    return Math.round(
      ((this.trackLength-this.handleLength)/(this.range.end-this.range.start)) *
      (value - this.range.start)) + "px";
  },
  translateToValue: function(offset) {
    return ((offset/(this.trackLength-this.handleLength) *
      (this.range.end-this.range.start)) + this.range.start);
  },
  getRange: function(range) {
    var v = this.values.sortBy(Prototype.K);
    range = range || 0;
    return $R(v[range],v[range+1]);
  },
  minimumOffset: function(){
    return(this.isVertical() ? this.alignY : this.alignX);
  },
  maximumOffset: function(){
    return(this.isVertical() ?
      (this.track.offsetHeight !!= 0 ? this.track.offsetHeight :
        this.track.style.height.replace(/px$/,"")) - this.alignY :
      (this.track.offsetWidth !!= 0 ? this.track.offsetWidth :
        this.track.style.width.replace(/px$/,"")) - this.alignX);
  },
  isVertical:  function(){
    return (this.axis == ''vertical'');
  },
  drawSpans: function() {
    var slider = this;
    if (this.spans)
      $R(0, this.spans.length-1).each(function(r) { slider.setSpan(slider.spans[r], slider.getRange(r)) });
    if (this.options.startSpan)
      this.setSpan(this.options.startSpan,
        $R(0, this.values.length>1 ? this.getRange(0).min() : this.value ));
    if (this.options.endSpan)
      this.setSpan(this.options.endSpan,
        $R(this.values.length>1 ? this.getRange(this.spans.length-1).max() : this.value, this.maximum));
  },
  setSpan: function(span, range) {
    if (this.isVertical()) {
      span.style.top = this.translateToPx(range.start);
      span.style.height = this.translateToPx(range.end - range.start + this.range.start);
    } else {
      span.style.left = this.translateToPx(range.start);
      span.style.width = this.translateToPx(range.end - range.start + this.range.start);
    }
  },
  updateStyles: function() {
    this.handles.each( function(h){ Element.removeClassName(h, ''selected'') });
    Element.addClassName(this.activeHandle, ''selected'');
  },
  startDrag: function(event) {
    if (Event.isLeftClick(event)) {
      if (!!this.disabled){
        this.active = true;

        var handle = Event.element(event);
        var pointer  = [Event.pointerX(event), Event.pointerY(event)];
        var track = handle;
        if (track==this.track) {
          var offsets  = Position.cumulativeOffset(this.track);
          this.event = event;
          this.setValue(this.translateToValue(
           (this.isVertical() ? pointer[1]-offsets[1] : pointer[0]-offsets[0])-(this.handleLength/2)
          ));
          var offsets  = Position.cumulativeOffset(this.activeHandle);
          this.offsetX = (pointer[0] - offsets[0]);
          this.offsetY = (pointer[1] - offsets[1]);
        } else {
          // find the handle (prevents issues with Safari)
          while((this.handles.indexOf(handle) == -1) && handle.parentNode)
            handle = handle.parentNode;

          if (this.handles.indexOf(handle)!!=-1) {
            this.activeHandle    = handle;
            this.activeHandleIdx = this.handles.indexOf(this.activeHandle);
            this.updateStyles();

            var offsets  = Position.cumulativeOffset(this.activeHandle);
            this.offsetX = (pointer[0] - offsets[0]);
            this.offsetY = (pointer[1] - offsets[1]);
          }
        }
      }
      Event.stop(event);
    }
  },
  update: function(event) {
   if (this.active) {
      if (!!this.dragging) this.dragging = true;
      this.draw(event);
      if (Prototype.Browser.WebKit) window.scrollBy(0,0);
      Event.stop(event);
   }
  },
  draw: function(event) {
    var pointer = [Event.pointerX(event), Event.pointerY(event)];
    var offsets = Position.cumulativeOffset(this.track);
    pointer[0] -= this.offsetX + offsets[0];
    pointer[1] -= this.offsetY + offsets[1];
    this.event = event;
    this.setValue(this.translateToValue( this.isVertical() ? pointer[1] : pointer[0] ));
    if (this.initialized && this.options.onSlide)
      this.options.onSlide(this.values.length>1 ? this.values : this.value, this);
  },
  endDrag: function(event) {
    if (this.active && this.dragging) {
      this.finishDrag(event, true);
      Event.stop(event);
    }
    this.active = false;
    this.dragging = false;
  },
  finishDrag: function(event, success) {
    this.active = false;
    this.dragging = false;
    this.updateFinished();
  },
  updateFinished: function() {
    if (this.initialized && this.options.onChange)
      this.options.onChange(this.values.length>1 ? this.values : this.value, this);
    this.event = null;
  }
});
'!

scriptaculousSliderJsResource
	"WebStyle new scriptaculousSliderJsResource"
	^self resources at: #jsScriptaculousSlider ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousSliderJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/slider.js' site: self site].!

scriptaculousSoundJs
	"sound.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// script.aculo.us sound.js v1.8.2, Tue Nov 18 18:30:58 +0100 2008

// Copyright (c) 2005-2008 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//
// Based on code created by Jules Gravinese (http://www.webveteran.com/)
//
// script.aculo.us is freely distributable under the terms of an MIT-style license.
// For details, see the script.aculo.us web site: http://script.aculo.us/

Sound = {
  tracks: {},
  _enabled: true,
  template:
    new Template(''<embed style="height:0" id="sound_#{track}_#{id}" src="#{url}" loop="false" autostart="true" hidden="true"/>''),
  enable: function(){
    Sound._enabled = true;
  },
  disable: function(){
    Sound._enabled = false;
  },
  play: function(url){
    if(!!Sound._enabled) return;
    var options = Object.extend({
      track: ''global'', url: url, replace: false
    }, arguments[1] || {});

    if(options.replace && this.tracks[options.track]) {
      $R(0, this.tracks[options.track].id).each(function(id){
        var sound = $(''sound_''+options.track+''_''+id);
        sound.Stop && sound.Stop();
        sound.remove();
      });
      this.tracks[options.track] = null;
    }

    if(!!this.tracks[options.track])
      this.tracks[options.track] = { id: 0 };
    else
      this.tracks[options.track].id++;

    options.id = this.tracks[options.track].id;
    $$(''body'')[0].insert(
      Prototype.Browser.IE ? new Element(''bgsound'',{
        id: ''sound_''+options.track+''_''+options.id,
        src: options.url, loop: 1, autostart: true
      }) : Sound.template.evaluate(options));
  }
};

if(Prototype.Browser.Gecko && navigator.userAgent.indexOf("Win") > 0){
  if(navigator.plugins && $A(navigator.plugins).detect(function(p){ return p.name.indexOf(''QuickTime'') !!= -1 }))
    Sound.template = new Template(''<object id="sound_#{track}_#{id}" width="0" height="0" type="audio/mpeg" data="#{url}"/>'');
  else
    Sound.play = function(){};
}
'!

scriptaculousSoundJsResource
	"WebStyle new scriptaculousSoundJsResource"
	^self resources at: #jsScriptaculousSound ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousSoundJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/sound.js' site: self site].!

session
	"try to find a first sender up in calling stack, who is AIDASite and find a session in 
	its local variable stack"
	^self firstSessionFromStack
"
	| context |
	context := thisContext.
	[context notNil] whileTrue: [
		(context receiver class == AIDASite) ifTrue: 
			[1 to: context localSize do: [:inx || local |
				local := context localAt: inx. 
				local class == WebSession ifTrue: [^local] ].
			^nil ].
		context := context sender].
	^nil
"!

sessionTimeoutText
	^'Session timed-out after 15min of inactivity!! '!

site
	^site!

site: anAIDASite
	site := anAIDASite!

style
	"the result of this method will be added at the end of static css methods.
	See WebStyle>>screenStyleSheet"
	style isNil ifTrue: [style := ''].
	^style!

style: aString
	style := aString!

usernameText
	^'Username: '! !
!WebStyle categoriesFor: #addHelpText!public!texts! !
!WebStyle categoriesFor: #addPrintSuperStyles!public!styles-print! !
!WebStyle categoriesFor: #addSuperStyles!public!styles-screen! !
!WebStyle categoriesFor: #adjustCSSLink:!maintenance!public! !
!WebStyle categoriesFor: #adjustImageName:!maintenance!public! !
!WebStyle categoriesFor: #adjustLinksInCSSMethod:!maintenance!public! !
!WebStyle categoriesFor: #allCssPrintMethods!private-css!public! !
!WebStyle categoriesFor: #allCssScreenMethods!private-css!public! !
!WebStyle categoriesFor: #allJavascriptMethods!private-javascript!public! !
!WebStyle categoriesFor: #app!accessing!public! !
!WebStyle categoriesFor: #calendarCSS!public!scripts-components! !
!WebStyle categoriesFor: #calendarCSSResource!public!scripts-components! !
!WebStyle categoriesFor: #calendarJavascript!public!scripts-components! !
!WebStyle categoriesFor: #calendarJsResource!public!scripts-components! !
!WebStyle categoriesFor: #calendarLangEnglish!public!scripts-components! !
!WebStyle categoriesFor: #calendarLangJavascript!public!scripts-components! !
!WebStyle categoriesFor: #calendarLangJsResource!public!scripts-components! !
!WebStyle categoriesFor: #calendarLangSlovenian!public!scripts-components! !
!WebStyle categoriesFor: #calendarSetupJavascript!public!scripts-components! !
!WebStyle categoriesFor: #calendarSetupJsResource!public!scripts-components! !
!WebStyle categoriesFor: #changeToSqueakArraysIn:!private! !
!WebStyle categoriesFor: #ensureJavascriptAndCssForCalendarInHeader!public!scripts-components! !
!WebStyle categoriesFor: #ensureJavascriptForScriptaculousInHeader!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #ensureJsResourceForCalendarSetup!public!scripts-components! !
!WebStyle categoriesFor: #ensureJsResourceForLightbox!public!scripts-components! !
!WebStyle categoriesFor: #ensureJsResourceForScriptaculous!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #fontSizeText!public!texts! !
!WebStyle categoriesFor: #galleryNextText!public!texts! !
!WebStyle categoriesFor: #galleryPrevText!public!texts! !
!WebStyle categoriesFor: #guestUserText!public!texts! !
!WebStyle categoriesFor: #headerElement!frame printing!public! !
!WebStyle categoriesFor: #helpText!public!texts! !
!WebStyle categoriesFor: #importImage:from:!maintenance!public! !
!WebStyle categoriesFor: #importImageFrom:!maintenance!public! !
!WebStyle categoriesFor: #importImagesFromDirectory:!maintenance!public! !
!WebStyle categoriesFor: #initResources!private! !
!WebStyle categoriesFor: #inPlaceCancelText!public!texts! !
!WebStyle categoriesFor: #inPlaceOkText!public!texts! !
!WebStyle categoriesFor: #isBrowserMSIE!public!testing! !
!WebStyle categoriesFor: #isBrowserNetscape!public!testing! !
!WebStyle categoriesFor: #javascript!private-javascript!public! !
!WebStyle categoriesFor: #javascriptResource!private-javascript!public! !
!WebStyle categoriesFor: #jsCommon!public!scripts! !
!WebStyle categoriesFor: #jsPrototypeFramework!public!scripts! !
!WebStyle categoriesFor: #jsPrtAIDADelayedObserver!public!scripts! !
!WebStyle categoriesFor: #lightboxJs!public!scripts-components! !
!WebStyle categoriesFor: #lightboxJsResource!public!scripts-components! !
!WebStyle categoriesFor: #loginBelowMessage!public!texts! !
!WebStyle categoriesFor: #loginButton!public!texts! !
!WebStyle categoriesFor: #loginErrorText!public!texts! !
!WebStyle categoriesFor: #loginErrorTextSecondary!public!texts! !
!WebStyle categoriesFor: #loginText!public!texts! !
!WebStyle categoriesFor: #loginTitle!public!texts! !
!WebStyle categoriesFor: #loginWelcomeMessage!public!texts! !
!WebStyle categoriesFor: #logoutText!public!texts! !
!WebStyle categoriesFor: #navigationBarElement!frame printing!public! !
!WebStyle categoriesFor: #observee!accessing!public! !
!WebStyle categoriesFor: #pageContentWidth!public!styles-screen! !
!WebStyle categoriesFor: #pageFrameWith:title:!frame printing!public! !
!WebStyle categoriesFor: #pageFrameWith:wide:title:!frame printing!public! !
!WebStyle categoriesFor: #pageWidth!public!styles-screen! !
!WebStyle categoriesFor: #passwordText!public!texts! !
!WebStyle categoriesFor: #printCssResource!private-css!public! !
!WebStyle categoriesFor: #printStyleSheet!private-css!public! !
!WebStyle categoriesFor: #prototypeFrameworkPart2!public!scripts! !
!WebStyle categoriesFor: #resources!private! !
!WebStyle categoriesFor: #richEditorCssResource!public!scripts-components! !
!WebStyle categoriesFor: #richEditorStyleSheet!public!scripts-components! !
!WebStyle categoriesFor: #screenCssResource!private-css!public! !
!WebStyle categoriesFor: #screenStyleSheet!private-css!public! !
!WebStyle categoriesFor: #scriptaculousBuilderJs!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousBuilderJsResource!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousControlsJs!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousControlsJsResource!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousDragDropJs!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousDragDropJsResource!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousEffectsJs!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousEffectsJsResource!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousJs!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousJsResource!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousSliderJs!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousSliderJsResource!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousSoundJs!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousSoundJsResource!public!scripts-scriptaculous! !
!WebStyle categoriesFor: #session!accessing!public! !
!WebStyle categoriesFor: #sessionTimeoutText!public!texts! !
!WebStyle categoriesFor: #site!accessing!public! !
!WebStyle categoriesFor: #site:!private! !
!WebStyle categoriesFor: #style!accessing!public! !
!WebStyle categoriesFor: #style:!accessing!public! !
!WebStyle categoriesFor: #usernameText!public!texts! !

!WebStyle class methodsFor!

classNameFor: aMethodSymbol
	"name of a class in a superclass chain which first implement that method"
	(self selectors includes: aMethodSymbol) ifTrue: [^self name asString].
	^self superclass classNameFor: aMethodSymbol!

default
	^AIDASite default style!

newOnSite: anAIDASite

	^super new site: anAIDASite! !
!WebStyle class categoriesFor: #classNameFor:!accessing!public! !
!WebStyle class categoriesFor: #default!accessing!public! !
!WebStyle class categoriesFor: #newOnSite:!instance creation!public! !

WebTransactionMonitor guid: (GUID fromString: '{452DB1DA-DE1B-404B-896A-A014A0D9AC3B}')!
WebTransactionMonitor comment: ''!
!WebTransactionMonitor categoriesForClass!Unclassified! !
!WebTransactionMonitor class methodsFor!

addServer: aWebServer

	self localServers add: aWebServer!

beginTransaction

	"Mark the beginning of transaction on current process. 
	Mark the end with commit or cancelTransaction"

	self beginTransactionOn: Processor activeProcess.!

beginTransactionOn: aProcess

	"Mark the beginning of transaction. Mark the end with commit or cancelTransaction"

	self critical: 
		[self transactions add: aProcess]!

busySessions

	"a collection of database sessions, which are busy on that moment"

	BusySessions isNil ifTrue: [self initBusySessions].
	^BusySessions!

cancelTransaction

	"cancel the transaction without commiting on current process. 
	Used in exception handling routines"

	self cancelTransactionOn: Processor activeProcess!

cancelTransactionOn: aProcess

	"cancel the transaction without commiting. Used in exception handling routines"

	self critical: 
		[self transactions remove: aProcess ifAbsent: []].!

clearHangedProcesses

	"remove all processes with hanged  suspended context from set of transactions. "
	"WebTransactionMonitor clearHangedProcesses"
" TEMORARY, vw5i4 sender unknown !! "
	self transactions copy do: 
		[:each | (each suspendedContext notNil and:
""
			[(each suspendedContext sender selector = #readWait) | 
			(each suspendedContext sender selector = #writeWait)] )
""
				ifTrue:
					[each terminate.
					self transactions remove: each] ].
""!

clearNilProcesses

	"remove all processes with nil  suspended context from set of transactions. Such processes
	died somewhere and were not removed with method cancelTransaction"

	self transactions copy do: 
		[:each | each suspendedContext isNil 
			ifTrue:
				[self transactions remove: each] ].!

commit

	"commit the transaction if there is no more pending transactions, otherwise defer commit to
	the next call of this method."
	"WebTransactionMonitor commit"
	self critical: 
		[self clearNilProcesses.
		"self transactions isEmpty" true
			ifTrue: 
				["WebServer default diagnostics ifTrue: [Transcript show: ' comm.']."
"				Swazoo.SwazooServer isPersistent ifTrue: [self gemstoneCommit].  "
				"WebServer default diagnostics ifTrue: [Transcript show: '.ited ']."
				self setLastCommit. ]
			ifFalse: 
				[self clearHangedProcesses.
				self transactions notEmpty ifTrue: 
					[self noCommitFor10min ifTrue: 
						[self notifyNoCommiting.
"						Swazoo.SwazooServer isPersistent ifTrue: [self gemstoneCommit] "]
					]
				]
		].

"WebTransactionMonitor commit"!

commitTransaction

	"commit the transaction on current process if there is no more pending transactions, 
	otherwise defer commit to the next call of this method."

	self commitTransactionOn: Processor activeProcess!

commitTransactionOn: aProcess

	"commit the transaction if there is no more pending transactions, otherwise defer commit to
	the next call of this method."

	self critical: 
		[self cancelTransactionOn: aProcess.
		self commit].!

critical: aBlock
	"For protecting critical sections in parallel execution of web requests. Use it always
	when you do things, which cannot be disturbed by another request. Example:
		WebTransactionMonitor critical: [<a block with critical section>]. "

	^self lock critical: aBlock.!

initBusySessions

	BusySessions := Set new.!

initialize
	self initTransactions.
	self initBusySessions.

"WebTransactionMonitor initialize"!

initTransactions

	Transactions := Set new.!

isNotificationSent

	NotificationSent isNil ifTrue: [self resetNotificationSent].
	^NotificationSent!

lastCommit

	"return the time of last real odb commit"

	^AIDASite default lastCommitTimestamp.!

localServers
	"all active web servers, whose are running on local image"
	LocalServers isNil ifTrue: [LocalServers := Set new].
	self removeNonactiveServers.
	^LocalServers!

notifyNoCommiting

	"if there is no odb commit for more than 10min then an e-mail message is sent to a 
	specified address (from settings in WebServer)"
	"WebTransactionMonitor notifyNoCommiting"



	| subject body |

	self isNotificationSent ifTrue: [^self].
"
	subject := 'AIDAWeb Urgent: No odb commit!!'.
	body := 'No commit for more than 10 minutes!!'.
	WebServer default urgentEMailSubject: subject body: body.
"
	self setNotificationSent.!

onFreeSessionFor: anObject remotePerform: aSelector

	^self onFreeSessionFor: anObject remotePerform: aSelector withArgs: #()


"WebTransactionMonitor onFreeSessionFor: AIDARoot remotePerform: #copy"!

onFreeSessionFor: anObject remotePerform: aSelector with: anArgument

	^self onFreeSessionFor: anObject remotePerform: aSelector withArgs: (Array with: anArgument)

"WebTransactionMonitor onFreeSessionFor: AIDARoot remotePerform: #at: with: 'planid' "!

onFreeSessionFor: anObject remotePerform: aSelector withArgs: argsArray

	| session gsObject result |
	session := self freeSession.
	[	
		self busySessions add: session.
		gsObject := anObject asGSObjectInSession: session .
		result := gsObject remotePerform: aSelector withArgs: argsArray.
		result := gsObject remotePerform: aSelector withArgs: argsArray.
		result := result asLocalObject.
		session commitTransaction
	] valueNowOrOnUnwindDo: 
		[self busySessions remove: session ifAbsent: [].
		 session disconnectST: anObject fromGS: gsObject].
	^result

"WebTransactionMonitor onFreeSessionFor: WebServer default remotePerform: #settings withArgs: #()"!

removeNonactiveServers
	LocalServers copy do: [:srv | 
		srv isServing ifFalse: [LocalServers remove: srv ifAbsent: []] ]!

removeServer: aWebServer

	self localServers remove: aWebServer ifAbsent: []!

resetNotificationSent

	NotificationSent := false.!

setLastCommit

	"set the time of last real odb commit to time now"
	
	self localServers do: [:each | each setLastCommitTimestamp].
	self resetNotificationSent!

setNotificationSent

	NotificationSent := true.!

transactions

	"a collection of all processes with open transactions . Such a process is 
	addded with method beginTransaction and removed with commit or cancelTransaction"
	"WebTransactionMonitor transactions"
	Transactions isNil ifTrue: [self initTransactions].
	^Transactions!

versantCommit

"	ODBInterface checkpointCommit "! !
!WebTransactionMonitor class categoriesFor: #addServer:!local servers!public! !
!WebTransactionMonitor class categoriesFor: #beginTransaction!public!transactions! !
!WebTransactionMonitor class categoriesFor: #beginTransactionOn:!public!transactions! !
!WebTransactionMonitor class categoriesFor: #busySessions!accessing!public! !
!WebTransactionMonitor class categoriesFor: #cancelTransaction!public!transactions! !
!WebTransactionMonitor class categoriesFor: #cancelTransactionOn:!public!transactions! !
!WebTransactionMonitor class categoriesFor: #clearHangedProcesses!public!transactions! !
!WebTransactionMonitor class categoriesFor: #clearNilProcesses!public!transactions! !
!WebTransactionMonitor class categoriesFor: #commit!public!transactions! !
!WebTransactionMonitor class categoriesFor: #commitTransaction!public!transactions! !
!WebTransactionMonitor class categoriesFor: #commitTransactionOn:!public!transactions! !
!WebTransactionMonitor class categoriesFor: #critical:!critical sections!public! !
!WebTransactionMonitor class categoriesFor: #initBusySessions!initialize!public! !
!WebTransactionMonitor class categoriesFor: #initialize!initialize!public! !
!WebTransactionMonitor class categoriesFor: #initTransactions!initialize!public! !
!WebTransactionMonitor class categoriesFor: #isNotificationSent!accessing!public! !
!WebTransactionMonitor class categoriesFor: #lastCommit!accessing!public! !
!WebTransactionMonitor class categoriesFor: #localServers!private! !
!WebTransactionMonitor class categoriesFor: #notifyNoCommiting!error notifying!public! !
!WebTransactionMonitor class categoriesFor: #onFreeSessionFor:remotePerform:!odb specific!public! !
!WebTransactionMonitor class categoriesFor: #onFreeSessionFor:remotePerform:with:!odb specific!public! !
!WebTransactionMonitor class categoriesFor: #onFreeSessionFor:remotePerform:withArgs:!odb specific!public! !
!WebTransactionMonitor class categoriesFor: #removeNonactiveServers!private! !
!WebTransactionMonitor class categoriesFor: #removeServer:!local servers!public! !
!WebTransactionMonitor class categoriesFor: #resetNotificationSent!accessing!public! !
!WebTransactionMonitor class categoriesFor: #setLastCommit!accessing!public! !
!WebTransactionMonitor class categoriesFor: #setNotificationSent!accessing!public! !
!WebTransactionMonitor class categoriesFor: #transactions!private! !
!WebTransactionMonitor class categoriesFor: #versantCommit!odb specific!public! !

WebTranslator guid: (GUID fromString: '{C60C5894-C8DF-4503-A9EB-0BB2EE2ABA89}')!
WebTranslator comment: 'WebTranslator offers a translation support to web apps. Apps on class side hold translations of the text. WebTranslator is then called by executing app to find a proper translation for each text, if it is used as in this example:

	e addText: #fr->''Bonjour''

Instance Variables:
	parent	<AIDASite>
	cache   <Dictionary>	 cached translations,  a multilevel dictionary 							class->(method->(langCode->(key->translation)))))
	other	<Dictionary>	 dynamic variable for all other values'!
!WebTranslator categoriesForClass!Unclassified! !
!WebTranslator methodsFor!

cache
	"cached translations. A multilevel dictionary"
	"class->(method->(langCode->(key->translation))))) "
	cache isNil ifTrue: [self initCache].
	^cache!

cachedTranslate: aString toLanguage: aLanguageCode class: aClassWithTransl method: aMethodSymbol
	"cache hierarchy: class->(method->(langCode->(key->translation))))) "
	"last dictionary is WebTranslDict!! "
	^(((self cache at: aClassWithTransl ifAbsent: [self refreshClass: aClassWithTransl])
		at: aMethodSymbol ifAbsentPut: [Dictionary new])
			at: aLanguageCode ifAbsentPut: [WebTranslDict new])
				at: aString ifAbsentPut: [nil]!

dictToTranslate: aMultilangAssociation to: aLanguageCode for: anElement on: aSession
	"returns WebTranslDict, for setting an aspect to edit by translation tools"
	| appClass method |
	appClass := aSession lastApp class. "app class where translations reside"
	method := anElement creationMethod. "method which created an element with multilang text"
	^((self cache at: appClass ifAbsent: [self refreshClass: appClass])
		at: method ifAbsent: [^nil])
			at: aLanguageCode ifAbsent: [nil]!

initCache
	"cached translations"
	cache := Dictionary new.!

initOther
	other := Dictionary new!

langFromTranslMethod: aMethodSymbol
	"extract language code from transl.method:  #fr from #frViewCalendar"
	^(aMethodSymbol asString copyFrom: 1 to: 2) asSymbol!

langsForMethod: aMethodSymbol on: aClassWithTransl
	"get all languages for which we have a translation for that creation method"
	^((self translMethodsOn: aClassWithTransl)
		 select: [:each | (self methodFromTranslMethod: each) = aMethodSymbol]) 
			collect: [:each | self langFromTranslMethod: each]!

methodFromTranslMethod: aMethodSymbol
	"extract creation method name from transl.method:  #viewCalendar from #frViewCalendar"
	| method |
	method := String with: (aMethodSymbol asString at: 3) asLowercase.
	^(method, (aMethodSymbol asString copyFrom: 4 to: aMethodSymbol size)) asSymbol.!

methodsOn: aClassWithTransl
	"get all creation methods for elements holding multilang text"
	^((self translMethodsOn: aClassWithTransl) collect: [:each | self methodFromTranslMethod: each]) 
		asSet "to find a unique set of those methods"!

other
	^other!

otherAt: aSymbol
	"other values"
	^self otherAt: aSymbol ifAbsent: [nil]!

otherAt: aSymbol ifAbsent: aBlock
	"other values"
	self other isNil ifTrue: [^aBlock value].
	^self other at: aSymbol ifAbsent: aBlock!

otherAt: aSymbol ifAbsentPut: aBlock
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol ifAbsent: [self other at: aSymbol put: aBlock value]!

otherAt: aSymbol put: anObject
	self other isNil ifTrue: [self initOther].
	^self other at: aSymbol put: anObject!

pairsForLang: aLanguageCode method: aMethodSymbol on: aClassWithTransl
	| translMethod |
	translMethod := self translMethodForLang: aLanguageCode method: aMethodSymbol.
	^(aClassWithTransl perform: translMethod) 
		collect: [:triple | Association key: triple first value: triple last] "triple midlle is just ->"!

parent
	^parent!

parent: anObject
	parent := anObject!

refreshClass: aClassWithTransl
	"refresh a cache from translations stored in class methods of specified class"
	| classDict methodDict langDict |
	classDict := self cache at: aClassWithTransl put: Dictionary new. "just remove old stuff"
	(self methodsOn: aClassWithTransl) do: [:method |
		methodDict := classDict at: method put: Dictionary new.
		(self langsForMethod: method on: aClassWithTransl) do: [:lang |
			langDict := methodDict at: lang put: WebTranslDict new.
			(self pairsForLang: lang method: method on: aClassWithTransl) do: [:assoc |
				langDict initialAt: assoc key put: assoc value ]]]. "initalAt:put: to avoid signaling change!!"
	^classDict!

site	
	^self parent!

translate: aMultilangAssociation to: aLanguageCode for: anElement on: aSession
	| appClass method translation |
	appClass := aSession lastApp class. "app class where translations reside"
	method := anElement creationMethod. "method which created an element with multilang text"
	translation := self 
		cachedTranslate: aMultilangAssociation value
		toLanguage: aLanguageCode
		class: appClass
		method: method.
	^translation notNil 
		ifTrue: [translation] 
		ifFalse: [aMultilangAssociation value] "original text"!

translationsCategory
	"name of category holding translations on class side of App classes"
	^#translations!

translLanguagesOn: aClassWithTransl
	"get all languages (codes) in which we have trnaslations"
	^(self translMethodsOn: aClassWithTransl) 
		inject: Set new 
		into: [:each :set | set add: (self langFromTranslMethod: each); yourself]!

translMethodForLang: aLanguageCode method: aMethodSymbol
	"compose that method name. For #fr and #viewCalendar = #frViewCalendar"
	^(aLanguageCode asString, (String with: aMethodSymbol asString first) asUppercase,
		(aMethodSymbol asString copyFrom: 2 to: aMethodSymbol size))
			asSymbol! !
!WebTranslator categoriesFor: #cache!private-cache!public! !
!WebTranslator categoriesFor: #cachedTranslate:toLanguage:class:method:!private-cache!public! !
!WebTranslator categoriesFor: #dictToTranslate:to:for:on:!public!translating! !
!WebTranslator categoriesFor: #initCache!initialize-release!public! !
!WebTranslator categoriesFor: #initOther!initialize-release!public! !
!WebTranslator categoriesFor: #langFromTranslMethod:!private-classes!public! !
!WebTranslator categoriesFor: #langsForMethod:on:!private-classes!public! !
!WebTranslator categoriesFor: #methodFromTranslMethod:!private-classes!public! !
!WebTranslator categoriesFor: #methodsOn:!private-classes!public! !
!WebTranslator categoriesFor: #other!private! !
!WebTranslator categoriesFor: #otherAt:!private! !
!WebTranslator categoriesFor: #otherAt:ifAbsent:!private! !
!WebTranslator categoriesFor: #otherAt:ifAbsentPut:!private! !
!WebTranslator categoriesFor: #otherAt:put:!private! !
!WebTranslator categoriesFor: #pairsForLang:method:on:!private-classes!public! !
!WebTranslator categoriesFor: #parent!accessing!public! !
!WebTranslator categoriesFor: #parent:!private! !
!WebTranslator categoriesFor: #refreshClass:!private-cache!public! !
!WebTranslator categoriesFor: #site!accessing!public! !
!WebTranslator categoriesFor: #translate:to:for:on:!public!translating! !
!WebTranslator categoriesFor: #translationsCategory!accessing!public! !
!WebTranslator categoriesFor: #translLanguagesOn:!private-classes!public! !
!WebTranslator categoriesFor: #translMethodForLang:method:!private-classes!public! !

!WebTranslator class methodsFor!

newOn: anAIDASite
	^super new
		parent: anAIDASite! !
!WebTranslator class categoriesFor: #newOn:!instance creation!public! !

WebUser guid: (GUID fromString: '{7AFC5E7C-1ABF-423E-8115-8F1DBDBB9200}')!
WebUser comment: ''!
!WebUser categoriesForClass!Unclassified! !
!WebUser methodsFor!

address
	address isNil ifTrue: [^'']. 
	^address!

address: aString
	address := aString.!

addToActivatingGroup
	self parent addActivatingUser: self!

addToRegisteredGroup
	self parent addRegisteredUser: self!

asPerson
	"parallel Person object (from Party framework if present, otherwise nil)"
	^self otherValuesAt: #Person ifAbsent: [^self initPerson]!

asWebUser
	^self!

autoLogout
	"logout after 15min of inactivity. default is NO!! "
	^self otherValuesAt: #AutoLogout ifAbsent: [false]!

autoLogout: aBoolean
	"logout after 15min of inactivity"
	^self otherValuesAt: #AutoLogout put: aBoolean!

becomeAdmin
	self parent adminGroup addUser: self!

city
	city isNil ifTrue: [^'']. 
	^city!

city: aString
	city := aString.!

company
	company isNil ifTrue: [^'']. 
	^company!

company: aString 
	company := aString.!

country
	country isNil ifTrue: [^'']. 
	^country!

country: aString
	country := aString.!

email 
	email isNil ifTrue: [^''].
	^email!

email: aString
	email := aString.!

fax
	fax isNil ifTrue: [^''].
	^fax!

fax: aString 
	fax := aString.!

groups 
	"where this user is a member"
	^self parent groups select: [:group | group users includes: self]!

hasEMail 

	"at least email must be entered to accept a new user"
	
	^self email ~= ''!

id
	"unique id of that user"
	^id!

id: aNumber
	id := aNumber.!

inActivatingGroup
	"user needs to confirm registration"
	^self groups contains: [:each | each isActivatingGroup]!

inAdminGroup
	"all from Administrators group are admins, also default Admin user"
	^self groups contains: [:each | each isAdminGroup]!

initialize
	self initId!

initId
	self id: (AIDASite random next * 1000000000) asInteger.!

initOtherValues
	otherValues := Dictionary new.!

initPerson
	^self otherValuesAt: #Person put: (Person new webUser: self)!

inRegisteredGroup
	^self groups contains: [:each | each isRegisteredGroup]!

isAdmin
	"all from Administrators group are admins, also default Admin user"
	"DEPRECIATED!!, use #inAdminGroup or #isAdminUser instead!! "
	^self inAdminGroup!

isAdminUser
	"special user with name Admin"
	^self username = 'admin' and: [self name= 'Admin'].!

isExtranetUser
	"a general user for extranets"
	^self name = 'Extranet' or: [(self username = 'extranet') & (self password = 'password')]!

isGuest
	"all non registered visitors have the same user: a Guest"
	^self name = 'Guest' and: 
		[(self username = 'guest') "& (self password = (WebSecurityManager hashPassword: 'guest'))"]!

isLocked
	"changes of user data not allowed"
	^self otherValuesAt: #Locked ifAbsent: [false]!

isPerson
	^false!

isWebUser
	^true!

isWebUserGroup
	^false!

lastAppUrl
	"an url which last WebApplication was called. "
	^self otherValuesAt: #LastAppUrl ifAbsent: [nil].!

lastAppUrl: aString
	"an url which last WebApplication was called. It is set AFTER the app view is generated!!"
	^self otherValuesAt: #LastAppUrl put: aString!

logoutFromUrl
	"From which page user logout. To be redirected back after login"
	^self otherValuesAt: #LogoutFromUrl ifAbsent: [nil].!

logoutFromUrl: aString
	"From which page user logout. To be redirected back after login"
	^self otherValuesAt: #LogoutFromUrl put: aString!

menuName
	"in dropdown menus"
	^self surnameName!

migrateToUnicode
	"from iso8859-2"
	"WebUser allInstances do: [:each | each migrateToUnicode]"
	username notNil ifTrue: [username := username ensureUnicodeSloveneChars].
	password notNil ifTrue: [password := password ensureUnicodeSloveneChars].
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].
	surname notNil ifTrue: [surname := surname ensureUnicodeSloveneChars].
	company notNil ifTrue: [company := company ensureUnicodeSloveneChars].
	city notNil ifTrue: [city := city ensureUnicodeSloveneChars].
	country notNil ifTrue: [country := country ensureUnicodeSloveneChars].!

name
	name isNil ifTrue: [self asPerson notNil ifTrue: [^self asPerson name] ifFalse: [^''] ].
	^name!

name: aString 
	self isLocked ifTrue: [^self error: 'user locked, changes not allowed!! '].
	self asPerson notNil ifTrue: [^self asPerson name: aString].
	name := aString trimBlanks.!

nameSurname 
	^self name, ' ', self surname!

otherValues
	^otherValues!

otherValuesAt: aString
	^self otherValuesAt: aString ifAbsent: [nil]!

otherValuesAt: aString ifAbsent: aBlock
	self otherValues isNil ifTrue: [^aBlock value].
	^self otherValues at: aString ifAbsent: [aBlock value]!

otherValuesAt: aSymbol ifAbsentPut: aBlock
	self otherValues isNil ifTrue: [self initOtherValues].
	^self otherValues at: aSymbol ifAbsent: [self otherValues at: aSymbol put: aBlock value]!

otherValuesAt: aString put: anObject
	self otherValues isNil ifTrue: [self initOtherValues].
	^self otherValues at: aString put: anObject!

parent
	^parent!

parent: aWebSecurityManager
	parent := aWebSecurityManager!

password
	"returns SHA1 encrypted password!! "		 
	password isNil ifTrue: [^''].
	^password!

password: aString	
	"Store hashed string"
	aString notEmpty ifTrue: [
		password := WebSecurityManager hashPassword: aString]!

passwordAsHex
	"leading zero in each byte ommited!! 0F = just F !!"
	"VW specific!!"		 
	^(self password 
		inject: (WriteStream on: String new)
		into: [:stream :byte | 
			stream nextPutAll: (byte printStringRadix: 16).  "VW specific!!"
			stream])
				contents!

passwordText
	"password is encripted/invisible anway, so return just empty string"
	^''!

passwordText: aString
	aString = self passwordText "all *****, this means that password was not changed"
		ifTrue: [^nil]. 
	aString trimBlanks isEmpty ifTrue: [^nil].
	^self password: aString!

person: aPerson
	"connect to parrallel Person from Party framework"
	self otherValuesAt: #Person put: aPerson.
	aPerson asWebUser ~= self ifTrue: [aPerson webUser: self].!

phone 
	phone isNil ifTrue: [^''].
	^phone!

phone: aString 
	phone := aString.!

preferedUrl
	| nme |
	nme := self nameSurname trimBlanks asHttpFriendly.
	^'/user/', nme, '.html'!

printString 
	^'aWebUser named ', self surname, ', ', self name, ' (', self username, ') '!

resetLocked
	"changes of user data allowed again"
	^self otherValuesAt: #Locked put: false!

setLocked
	"changes of user data not allowed"
	^self otherValuesAt: #Locked put: true!

someId
	"just return some text, possibly surnameName"
	self surnameName trimBlanks notEmpty ifTrue: [^self surnameName].
	self email notEmpty ifTrue: [^self email].
	^'----'!

surname
	surname isNil ifTrue: [self asPerson notNil ifTrue: [^self asPerson surname] ifFalse: [^''] ].
	^surname!

surname: aString 
	self isLocked ifTrue: [^self error: 'user locked, changes not allowed!! '].
	self asPerson notNil ifTrue: [^self asPerson surname: aString].
	surname := aString trimBlanks.!

surnameName
	^self surname, ' ', self name!

username
 
	username isNil ifTrue: [^''].
	^username.!

username: aString 
	self isLocked ifTrue: [^self error: 'user locked, changes not allowed!! '].
	username := aString asLowercase trimBlanks.!

uuid
	"unique identifier "
	^self otherValuesAt: #uuid ifAbsentPut: [(AIDASite random next * 1000000000) rounded printString]!

website
	website isNil ifTrue: [^''].
	^website!

website: aString
	website := aString!

zip
	zip isNil ifTrue: [^'']. 
	^zip!

zip: aString
	zip := aString.! !
!WebUser categoriesFor: #address!accessing!public! !
!WebUser categoriesFor: #address:!accessing!public! !
!WebUser categoriesFor: #addToActivatingGroup!groups!public! !
!WebUser categoriesFor: #addToRegisteredGroup!groups!public! !
!WebUser categoriesFor: #asPerson!accessing!public! !
!WebUser categoriesFor: #asWebUser!accessing!public! !
!WebUser categoriesFor: #autoLogout!accessing-other!public! !
!WebUser categoriesFor: #autoLogout:!accessing-other!public! !
!WebUser categoriesFor: #becomeAdmin!accessing!public! !
!WebUser categoriesFor: #city!accessing!public! !
!WebUser categoriesFor: #city:!accessing!public! !
!WebUser categoriesFor: #company!accessing!public! !
!WebUser categoriesFor: #company:!accessing!public! !
!WebUser categoriesFor: #country!accessing!public! !
!WebUser categoriesFor: #country:!accessing!public! !
!WebUser categoriesFor: #email!accessing!public! !
!WebUser categoriesFor: #email:!accessing!public! !
!WebUser categoriesFor: #fax!accessing!public! !
!WebUser categoriesFor: #fax:!accessing!public! !
!WebUser categoriesFor: #groups!groups!public! !
!WebUser categoriesFor: #hasEMail!public!testing! !
!WebUser categoriesFor: #id!accessing!public! !
!WebUser categoriesFor: #id:!accessing!public! !
!WebUser categoriesFor: #inActivatingGroup!public!testing! !
!WebUser categoriesFor: #inAdminGroup!public!testing! !
!WebUser categoriesFor: #initialize!initialize-release!public! !
!WebUser categoriesFor: #initId!initialize-release!public! !
!WebUser categoriesFor: #initOtherValues!initialize-release!public! !
!WebUser categoriesFor: #initPerson!initialize-release!public! !
!WebUser categoriesFor: #inRegisteredGroup!public!testing! !
!WebUser categoriesFor: #isAdmin!public!testing! !
!WebUser categoriesFor: #isAdminUser!public!testing! !
!WebUser categoriesFor: #isExtranetUser!public!testing! !
!WebUser categoriesFor: #isGuest!public!testing! !
!WebUser categoriesFor: #isLocked!public!testing! !
!WebUser categoriesFor: #isPerson!public!testing! !
!WebUser categoriesFor: #isWebUser!public!testing! !
!WebUser categoriesFor: #isWebUserGroup!public!testing! !
!WebUser categoriesFor: #lastAppUrl!accessing-other!public! !
!WebUser categoriesFor: #lastAppUrl:!accessing-other!public! !
!WebUser categoriesFor: #logoutFromUrl!accessing-other!public! !
!WebUser categoriesFor: #logoutFromUrl:!accessing-other!public! !
!WebUser categoriesFor: #menuName!accessing!public! !
!WebUser categoriesFor: #migrateToUnicode!private! !
!WebUser categoriesFor: #name!accessing!public! !
!WebUser categoriesFor: #name:!accessing!public! !
!WebUser categoriesFor: #nameSurname!accessing!public! !
!WebUser categoriesFor: #otherValues!private! !
!WebUser categoriesFor: #otherValuesAt:!private! !
!WebUser categoriesFor: #otherValuesAt:ifAbsent:!private! !
!WebUser categoriesFor: #otherValuesAt:ifAbsentPut:!private! !
!WebUser categoriesFor: #otherValuesAt:put:!private! !
!WebUser categoriesFor: #parent!private! !
!WebUser categoriesFor: #parent:!private! !
!WebUser categoriesFor: #password!accessing!public! !
!WebUser categoriesFor: #password:!accessing!public! !
!WebUser categoriesFor: #passwordAsHex!accessing!public! !
!WebUser categoriesFor: #passwordText!accessing!public! !
!WebUser categoriesFor: #passwordText:!accessing!public! !
!WebUser categoriesFor: #person:!private! !
!WebUser categoriesFor: #phone!accessing!public! !
!WebUser categoriesFor: #phone:!accessing!public! !
!WebUser categoriesFor: #preferedUrl!private! !
!WebUser categoriesFor: #printString!private! !
!WebUser categoriesFor: #resetLocked!accessing-other!public! !
!WebUser categoriesFor: #setLocked!accessing-other!public! !
!WebUser categoriesFor: #someId!accessing!public! !
!WebUser categoriesFor: #surname!accessing!public! !
!WebUser categoriesFor: #surname:!accessing!public! !
!WebUser categoriesFor: #surnameName!accessing!public! !
!WebUser categoriesFor: #username!accessing!public! !
!WebUser categoriesFor: #username:!accessing!public! !
!WebUser categoriesFor: #uuid!accessing!public! !
!WebUser categoriesFor: #website!accessing!public! !
!WebUser categoriesFor: #website:!accessing!public! !
!WebUser categoriesFor: #zip!accessing!public! !
!WebUser categoriesFor: #zip:!accessing!public! !

!WebUser class methodsFor!

adminEMail
	^'admin'!

adminName
	^'Admin'!

adminPassword
	^'password'!

adminSurname
	^''!

adminUsername
	^'admin'!

extranetEMail
	^'extranet'!

extranetName
	^'Extranet'!

extranetPassword
	^'password'!

extranetSurname
	^''!

extranetUsername
	^'extranet'!

guestEMail
	^'guest'!

guestName
	^'Guest'!

guestPassword
	^'guest'!

guestSurname
	^''!

guestUsername
	^'guest'!

new
	^super new initialize!

newAdmin
	^self new
		name: self adminName;
		surname: self adminSurname;
		email: self adminEMail;
		username: self adminUsername;
		password: self adminPassword!

newExtranet
	"a common extranet user, for easier setup of access rights"
	^self new
		name: self extranetName;
		surname: self extranetSurname;
		email: self extranetEMail;
		username: self extranetUsername;
		password: self extranetPassword!

newGuest
	^self new
		name: self guestName;
		surname: self guestSurname;
		email: self guestEMail;
		username: self guestUsername;
		password: self guestPassword! !
!WebUser class categoriesFor: #adminEMail!defaults!public! !
!WebUser class categoriesFor: #adminName!defaults!public! !
!WebUser class categoriesFor: #adminPassword!defaults!public! !
!WebUser class categoriesFor: #adminSurname!defaults!public! !
!WebUser class categoriesFor: #adminUsername!defaults!public! !
!WebUser class categoriesFor: #extranetEMail!defaults!public! !
!WebUser class categoriesFor: #extranetName!defaults!public! !
!WebUser class categoriesFor: #extranetPassword!defaults!public! !
!WebUser class categoriesFor: #extranetSurname!defaults!public! !
!WebUser class categoriesFor: #extranetUsername!defaults!public! !
!WebUser class categoriesFor: #guestEMail!defaults!public! !
!WebUser class categoriesFor: #guestName!defaults!public! !
!WebUser class categoriesFor: #guestPassword!defaults!public! !
!WebUser class categoriesFor: #guestSurname!defaults!public! !
!WebUser class categoriesFor: #guestUsername!defaults!public! !
!WebUser class categoriesFor: #new!instance creation!public! !
!WebUser class categoriesFor: #newAdmin!instance creation!public! !
!WebUser class categoriesFor: #newExtranet!instance creation!public! !
!WebUser class categoriesFor: #newGuest!instance creation!public! !

WebUserGroup guid: (GUID fromString: '{5A66EEEC-53E5-4D54-8156-96E94C920042}')!
WebUserGroup comment: ''!
!WebUserGroup categoriesForClass!Unclassified! !
!WebUserGroup methodsFor!

addUser: aWebUser
 	self users add: aWebUser.!

allUsers
	^self users copy!

includes: aWebUser
	^self users includes: aWebUser!

initUsers 
	users  := Set new.!

isActivatingGroup
	"group of users waiting to confirm registration"
	^self name = self class activatingGroupName!

isAdminGroup
	^self name = self class adminGroupName!

isAllUsersGroup
	^self name = self class allUsersGroupName!

isGuestGroup
	^self name = self class guestGroupName!

isPerson
	^false!

isRegisteredGroup
	^self name = self class registeredGroupName!

isWebUser
	^false!

isWebUserGroup
	^true!

menuName
	"in dropdown menus"
	^name!

migrateToUnicode
	"from iso8859-2"
	"WebUserGroup allInstances do: [:each | each migrateToUnicode]"
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].!

name
	name isNil ifTrue: [self name: '']. 
	^name!

name: aString
	name := aString.!

preferedUrl
	| nme |
	nme := self name trimBlanks asHttpFriendly.
	^'/group/', nme, '.html'!

printString
	^'aWebUserGroup: ', self name!

removeUser: aWebUser
 	self users remove: aWebUser ifAbsent: [].!

users
	users isNil ifTrue: [self initUsers]. 
	^users!

uuid
	"some unique identifier. Hash for now, probably unique enough!! "
	^self hash printString! !
!WebUserGroup categoriesFor: #addUser:!adding-removing!public! !
!WebUserGroup categoriesFor: #allUsers!accessing!public! !
!WebUserGroup categoriesFor: #includes:!public!testing! !
!WebUserGroup categoriesFor: #initUsers!initialize-release!public! !
!WebUserGroup categoriesFor: #isActivatingGroup!public!testing! !
!WebUserGroup categoriesFor: #isAdminGroup!public!testing! !
!WebUserGroup categoriesFor: #isAllUsersGroup!public!testing! !
!WebUserGroup categoriesFor: #isGuestGroup!public!testing! !
!WebUserGroup categoriesFor: #isPerson!public!testing! !
!WebUserGroup categoriesFor: #isRegisteredGroup!public!testing! !
!WebUserGroup categoriesFor: #isWebUser!public!testing! !
!WebUserGroup categoriesFor: #isWebUserGroup!public!testing! !
!WebUserGroup categoriesFor: #menuName!accessing!public! !
!WebUserGroup categoriesFor: #migrateToUnicode!private! !
!WebUserGroup categoriesFor: #name!accessing!public! !
!WebUserGroup categoriesFor: #name:!accessing!public! !
!WebUserGroup categoriesFor: #preferedUrl!private! !
!WebUserGroup categoriesFor: #printString!private! !
!WebUserGroup categoriesFor: #removeUser:!adding-removing!public! !
!WebUserGroup categoriesFor: #users!private! !
!WebUserGroup categoriesFor: #uuid!accessing!public! !

!WebUserGroup class methodsFor!

activatingGroupName
	"group of users waiting to confirm registration"
	^'Users waiting activation'!

adminGroupName
	"return a name of group for administrators" 
	^'Administrators'!

allUsersGroupName
	"return a name of group, where all users are there by default" 
	^'AllUsers'!

guestGroupName
	"return a name of group for guests" 
	^self allUsersGroupName!

newActivating
	^super new name: self activatingGroupName!

newAdmin
	^super new name: self adminGroupName!

newAllUsers
	^super new name: self allUsersGroupName!

newRegistered
	^super new name: self registeredGroupName!

registeredGroupName
	"return a name of group of registered users" 
	^'Registered Users'! !
!WebUserGroup class categoriesFor: #activatingGroupName!defaults!public! !
!WebUserGroup class categoriesFor: #adminGroupName!defaults!public! !
!WebUserGroup class categoriesFor: #allUsersGroupName!defaults!public! !
!WebUserGroup class categoriesFor: #guestGroupName!defaults!public! !
!WebUserGroup class categoriesFor: #newActivating!instance creation!public! !
!WebUserGroup class categoriesFor: #newAdmin!instance creation!public! !
!WebUserGroup class categoriesFor: #newAllUsers!instance creation!public! !
!WebUserGroup class categoriesFor: #newRegistered!instance creation!public! !
!WebUserGroup class categoriesFor: #registeredGroupName!defaults!public! !

AIDAAspectAdaptor guid: (GUID fromString: '{9CC6DB5E-12AC-4C0B-9242-0DC7E1B23421}')!
AIDAAspectAdaptor comment: ''!
!AIDAAspectAdaptor categoriesForClass!Unclassified! !
!AIDAAspectAdaptor methodsFor!

aspect

	^aspect!

aspect: aSymbol

	aspect := aSymbol!

value

	^self subject perform: self aspect!

value: aValue

	self subject perform: (self aspect asString, ':') asSymbol with: aValue! !
!AIDAAspectAdaptor categoriesFor: #aspect!accessing!public! !
!AIDAAspectAdaptor categoriesFor: #aspect:!accessing!public! !
!AIDAAspectAdaptor categoriesFor: #value!accessing!public! !
!AIDAAspectAdaptor categoriesFor: #value:!accessing!public! !

!AIDAAspectAdaptor class methodsFor!

forAspect: aSymbol

	^super new aspect: aSymbol! !
!AIDAAspectAdaptor class categoriesFor: #forAspect:!instance creation!public! !

AIDAIndexedAdaptor guid: (GUID fromString: '{0110FDFD-0C87-4654-87F6-937C7F60412D}')!
AIDAIndexedAdaptor comment: ''!
!AIDAIndexedAdaptor categoriesForClass!Unclassified! !
!AIDAIndexedAdaptor methodsFor!

index

	^index!

index: aNumber

	index := aNumber!

value

	^self subject at: self index!

value: aValue

	self subject at: self index put: aValue! !
!AIDAIndexedAdaptor categoriesFor: #index!accessing!public! !
!AIDAIndexedAdaptor categoriesFor: #index:!accessing!public! !
!AIDAIndexedAdaptor categoriesFor: #value!accessing!public! !
!AIDAIndexedAdaptor categoriesFor: #value:!accessing!public! !

!AIDAIndexedAdaptor class methodsFor!

forIndex: aNumber

	^super new index: aNumber! !
!AIDAIndexedAdaptor class categoriesFor: #forIndex:!instance creation!public! !

PersistentDictionary guid: (GUID fromString: '{D4B2C17B-DE7C-46B6-A064-0732A538E7F7}')!
PersistentDictionary comment: 'PersistentDictionary was used for older Gemstone GemBuilders, before immutability was introduced in VW. Now is OBSOLETE!! but somewhere instances still exist'!
!PersistentDictionary categoriesForClass!Unclassified! !
!PersistentDictionary class methodsFor!

autoMarkDirty
	"self autoMarkDirty"
	self markDirtyOnAtPut!

unautoMarkDirty
	"self unautoMarkDirty"
	self removeMarkDirtyOnAtPut! !
!PersistentDictionary class categoriesFor: #autoMarkDirty!odb specific!public! !
!PersistentDictionary class categoriesFor: #unautoMarkDirty!odb specific!public! !

WebTranslDict guid: (GUID fromString: '{78A936BD-C348-404C-9062-E9F2B0EC7CFF}')!
WebTranslDict comment: 'WebTrDictionary is a dictionary holding the last level in WebTranslator cache. Special dictinoary is needed to catch the changes when doing translations by translation tools and storing them back to appropriate class translation methods.

Instance Variables:
	changes	<Set>	keys of changed texts'!
!WebTranslDict categoriesForClass!Unclassified! !
!WebTranslDict methodsFor!

at: key ifAbsentPut: aBlock
	^self at: key ifAbsent: [self initialAt: key put: aBlock value]!

at: key put: value
	"this one should be used by translation tools!!"
	self changes add: key.
	^super at: key put: value!

changes
	changes isNil ifTrue: [changes := Set new].
	^changes!

initialAt: key put: value
	"this one does not register the change, use it for initial dict setup!!"
	^super at: key put: value! !
!WebTranslDict categoriesFor: #at:ifAbsentPut:!accessing!public! !
!WebTranslDict categoriesFor: #at:put:!accessing!public! !
!WebTranslDict categoriesFor: #changes!private! !
!WebTranslDict categoriesFor: #initialAt:put:!accessing!public! !

PersistentIdentityDictionary guid: (GUID fromString: '{2013A79F-4850-4570-A426-90B0B8BDCC84}')!
PersistentIdentityDictionary comment: 'PersistentIdentityDictionary was used for older Gemstone GemBuilders, before immutability was introduced in VW. Now is OBSOLETE!! but somewhere instances still exist'!
!PersistentIdentityDictionary categoriesForClass!Unclassified! !
!PersistentIdentityDictionary class methodsFor!

autoMarkDirty
	"self autoMarkDirty"
	self markDirtyOnAtPut!

unautoMarkDirty
	"self unautoMarkDirty"
	self removeMarkDirtyOnAtPut! !
!PersistentIdentityDictionary class categoriesFor: #autoMarkDirty!odb specific!public! !
!PersistentIdentityDictionary class categoriesFor: #unautoMarkDirty!odb specific!public! !

WebCaptcha guid: (GUID fromString: '{D08AE52F-8192-4434-8575-DDB2919C922A}')!
WebCaptcha comment: 'A WebCaptcha provides a CAPTCHA image from input text, to be used for separating humans from bots, for instance when submiting blog comments (http://en.wikipedia.org/wiki/Captcha)

Our capthca is using ImageMagick (http://www.imagemagick.org) which must be installed first. It combines a background image (by default captcha-background.png, must be on current directory) with generated one from provided text in default font (see method fontName, currently Andy), which also must be installed and known to ImageMagick. 

To collect all installed fonts in your system for IMagics, run script
	imagick_type_gen > ~/.magics/type.xml

See http://www.imagemagick.org/Usage/scripts/imagick_type_gen

To see and change parameters of building captcha, look into method #prepareCaptchaImage'!
!WebCaptcha categoriesForClass!Unclassified! !
!WebCaptcha methodsFor!

backgroundImageFilename
	^'captcha-background.png'!

contentsOfCaptcha
	^self filename contentsOfEntireFileBinary asString!

contentType
	^'image/png'.!

fontName
	^'Andy'!

imageSize
	^150@30!

isExpired
	"it exists more than few hours"
	^(SpTimestamp now asSeconds - self preparedTimestamp asSeconds) > (10*3600)!

isRespondingStreamed
	^false!

preparedTimestamp
	^self timestamps at: #prepared ifAbsent: [nil]!

printHTMLPageOn: aStream for: aRequest on: aSession 
	self prepareCaptchaImage.
	aStream nextPutAll: self contentsOfCaptcha.
	self filename delete.
	self class
		addToCache: self ;
		releaseExpiredCaptchas!

printWebPageFor: aRequest on: aSession 
	^self!

random
	random isNil ifTrue: 
		[random := (AIDASite random next * 1000) truncated printString].
	^random!

setPreparedTimestamp
	^self timestamps at: #prepared put: SpTimestamp now.!

size
	^self filename fileSize!

text
	"string to be converted into captcha image"
	text isNil ifTrue: [^''].
	^text!

text: aString
	"string to be converted into captcha image"
	text := aString! !
!WebCaptcha categoriesFor: #backgroundImageFilename!defaults!public! !
!WebCaptcha categoriesFor: #contentsOfCaptcha!printing!public! !
!WebCaptcha categoriesFor: #contentType!private! !
!WebCaptcha categoriesFor: #fontName!defaults!public! !
!WebCaptcha categoriesFor: #imageSize!defaults!public! !
!WebCaptcha categoriesFor: #isExpired!private! !
!WebCaptcha categoriesFor: #isRespondingStreamed!private! !
!WebCaptcha categoriesFor: #preparedTimestamp!private! !
!WebCaptcha categoriesFor: #printHTMLPageOn:for:on:!printing!public! !
!WebCaptcha categoriesFor: #printWebPageFor:on:!printing!public! !
!WebCaptcha categoriesFor: #random!converting!public! !
!WebCaptcha categoriesFor: #setPreparedTimestamp!private! !
!WebCaptcha categoriesFor: #size!private! !
!WebCaptcha categoriesFor: #text!accessing!public! !
!WebCaptcha categoriesFor: #text:!accessing!public! !

!WebCaptcha class methodsFor!

addToCache: aCaptcha
	self cache add: aCaptcha!

new
	"prepare a CAPTCHA with random string"
	| session |
	session := self firstSessionFromStack. "on which we are building this captcha"
	^super new 
		site: (session notNil ifTrue: [session site] ifFalse: [nil]);
		setRandomText!

newFor: aString
	"prepare a CAPTCHA image for that string"
	^self new 
		text: aString!

releaseExpiredCaptchas
	self cache do: [:each | 
		each isExpired ifTrue: [each removeYourself "from url resolver"]]! !
!WebCaptcha class categoriesFor: #addToCache:!private-cache!public! !
!WebCaptcha class categoriesFor: #new!instance creation!public! !
!WebCaptcha class categoriesFor: #newFor:!instance creation!public! !
!WebCaptcha class categoriesFor: #releaseExpiredCaptchas!private-cache!public! !

HTTPCopy guid: (GUID fromString: '{46F7395D-17D3-4179-B97B-79217F8D7F98}')!
HTTPCopy comment: 'HTTPCopy  

WebDAV HTTP method for copy resources or collections'!
!HTTPCopy categoriesForClass!Unclassified! !
!HTTPCopy methodsFor!

isCopy
	^true! !
!HTTPCopy categoriesFor: #isCopy!public!testing! !

!HTTPCopy class methodsFor!

methodName
	"HTTP method used for a request"
	^'COPY'! !
!HTTPCopy class categoriesFor: #methodName!accessing!public! !

HTTPLock guid: (GUID fromString: '{251DF646-B7CA-4364-BBD0-B3691B96681D}')!
HTTPLock comment: 'HTTPLock  

WebDAV HTTP method for lock resources  or collections'!
!HTTPLock categoriesForClass!Unclassified! !
!HTTPLock methodsFor!

isLock
	^true! !
!HTTPLock categoriesFor: #isLock!public!testing! !

!HTTPLock class methodsFor!

methodName
	"HTTP method used for a request"
	^'LOCK'! !
!HTTPLock class categoriesFor: #methodName!accessing!public! !

HTTPMkCol guid: (GUID fromString: '{7EBFC49B-1686-461E-945C-D313219417AB}')!
HTTPMkCol comment: 'HTTPMkCol 

WebDAV HTTP method for making new collection (directories, folders)'!
!HTTPMkCol categoriesForClass!Unclassified! !
!HTTPMkCol methodsFor!

isMkCol
	^true! !
!HTTPMkCol categoriesFor: #isMkCol!public!testing! !

!HTTPMkCol class methodsFor!

methodName
	"HTTP method used for a request"
	^'MKCOL'! !
!HTTPMkCol class categoriesFor: #methodName!accessing!public! !

HTTPMove guid: (GUID fromString: '{035BDA9E-E2BC-46E6-B243-D30336A2E593}')!
HTTPMove comment: 'HTTPMove

WebDAV HTTP method for move resources or collections'!
!HTTPMove categoriesForClass!Unclassified! !
!HTTPMove methodsFor!

isMove
	^true! !
!HTTPMove categoriesFor: #isMove!public!testing! !

!HTTPMove class methodsFor!

methodName
	"HTTP method used for a request"
	^'MOVE'! !
!HTTPMove class categoriesFor: #methodName!accessing!public! !

HTTPPropFind guid: (GUID fromString: '{03764838-403C-4847-932D-1C72820AED20}')!
HTTPPropFind comment: 'HTTPPropFind 

WebDAV HTTP method for retrieving properties'!
!HTTPPropFind categoriesForClass!Unclassified! !
!HTTPPropFind methodsFor!

areAllPropertiesRequested
	^self properties isNil or: [self properties isEmpty or: [self properties includes: 'allprop']]!

isDepthChildrenToo
	"if this request deals with that resource an its immediate children"
	^(self headerAt: 'Depth' ifAbsent: [^false]) = '1'!

isDepthInfinite
	"if this request deals with that resource an all its progeny"
	^(self headerAt: 'Depth' ifAbsent: [^true]) = 'infinity'!

isDepthOnlyToResource
	"if this request deals with that resource only"
	^(self headerAt: 'Depth' ifAbsent: [^false]) = '0'!

isPropFind
	^true!

properties
	"names of requested properties"
	^properties!

properties: aCollectionOfStrings
	properties := aCollectionOfStrings!

readFrom: aStream 
	super readFrom: aStream.
	self contents notEmpty ifTrue: [self parseXMLContent]! !
!HTTPPropFind categoriesFor: #areAllPropertiesRequested!public!testing! !
!HTTPPropFind categoriesFor: #isDepthChildrenToo!public!testing! !
!HTTPPropFind categoriesFor: #isDepthInfinite!public!testing! !
!HTTPPropFind categoriesFor: #isDepthOnlyToResource!public!testing! !
!HTTPPropFind categoriesFor: #isPropFind!public!testing! !
!HTTPPropFind categoriesFor: #properties!accessing!public! !
!HTTPPropFind categoriesFor: #properties:!private! !
!HTTPPropFind categoriesFor: #readFrom:!public!reading! !

!HTTPPropFind class methodsFor!

methodName
	"HTTP method used for a request"
	^'PROPFIND'! !
!HTTPPropFind class categoriesFor: #methodName!accessing!public! !

HTTPPropPatch guid: (GUID fromString: '{1B47ED01-A25A-46E4-9A6D-EA68B52A36C4}')!
HTTPPropPatch comment: 'HTTPPropPatch 

WebDAV HTTP method for updating properties'!
!HTTPPropPatch categoriesForClass!Unclassified! !
!HTTPPropPatch methodsFor!

isPropPatch
	^true! !
!HTTPPropPatch categoriesFor: #isPropPatch!public!testing! !

!HTTPPropPatch class methodsFor!

methodName
	"HTTP method used for a request"
	^'PROPPATCH'! !
!HTTPPropPatch class categoriesFor: #methodName!accessing!public! !

HTTPUnlock guid: (GUID fromString: '{5BB5D713-5074-488D-8919-9B83595A26A9}')!
HTTPUnlock comment: 'HTTPUnlock 

WebDAV HTTP method for unlock resources or collections'!
!HTTPUnlock categoriesForClass!Unclassified! !
!HTTPUnlock methodsFor!

isPropPatch
	^true!

isUnlock
	^true! !
!HTTPUnlock categoriesFor: #isPropPatch!public!testing! !
!HTTPUnlock categoriesFor: #isUnlock!public!testing! !

!HTTPUnlock class methodsFor!

methodName
	"HTTP method used for a request"
	^'UNLOCK'! !
!HTTPUnlock class categoriesFor: #methodName!accessing!public! !

HTTPWebDAVResponse guid: (GUID fromString: '{8370DBBD-134B-4FEB-8548-8A2CE8FAD905}')!
HTTPWebDAVResponse comment: ''!
!HTTPWebDAVResponse categoriesForClass!Unclassified! !
!HTTPWebDAVResponse methodsFor!

code: anInteger 
	code := anInteger.
	(#(200 207) includes: code) ifFalse: [self addDefaultBody].!

writeTo: aSwazooStream inResponseTo: aRequest
	self prepareXMLEntity.
	super writeTo: aSwazooStream inResponseTo: aRequest!

xmlResponse
	xmlResponse isNil ifTrue: [self initXMLResponse].
	^xmlResponse! !
!HTTPWebDAVResponse categoriesFor: #code:!accessing!public! !
!HTTPWebDAVResponse categoriesFor: #writeTo:inResponseTo:!private-printing!public! !
!HTTPWebDAVResponse categoriesFor: #xmlResponse!private! !

HTTPLockResponse guid: (GUID fromString: '{1C7A38B2-BC32-495F-97E6-920305D182B3}')!
HTTPLockResponse comment: ''!
!HTTPLockResponse categoriesForClass!Unclassified! !
!HTTPLockResponse class methodsFor!

new
	| response |
	response := super ok.
	response contentType: 'application/xml; charset="utf-8"'.
	^response! !
!HTTPLockResponse class categoriesFor: #new!instance creation!public! !

HTTPPropFindResponse guid: (GUID fromString: '{6BBF00B6-D884-4E19-94FB-4ACF6A349DD8}')!
HTTPPropFindResponse comment: ''!
!HTTPPropFindResponse categoriesForClass!Unclassified! !
!HTTPPropFindResponse methodsFor!

multiEnd
	"add closing tags for that multiresponse"
	"actualy nothing to do?"! !
!HTTPPropFindResponse categoriesFor: #multiEnd!building responses!public! !

!HTTPPropFindResponse class methodsFor!

new
	| response |
	response := super multiStatus.
	response contentType: 'application/xml; charset="utf-8"'.
	^response! !
!HTTPPropFindResponse class categoriesFor: #new!instance creation!public! !

BmpImageStream guid: (GUID fromString: '{34CC045E-C1B8-4B5A-BAC2-3ED12D9284E1}')!
BmpImageStream comment: 'BmpImageStream 

Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!
!BmpImageStream categoriesForClass!Unclassified! !
!BmpImageStream methodsFor!

nextImage
	self readBitmapFileHeader.
	self readBitmapInfoHeader.
	self readImagePalette.
	self readImageData.
	^imageObject!

nextLSBLong
	^self next + (self next bitShift: 8) + (self next bitShift: 16) + (self next bitShift: 24)!

nextLSBLongPut: a32BitW 
	self nextPut: (a32BitW bitAnd: 255).
	self nextPut: ((a32BitW bitShift: -8)
			bitAnd: 255).
	self nextPut: ((a32BitW bitShift: -16)
			bitAnd: 255).
	self nextPut: ((a32BitW bitShift: -24)
			bitAnd: 255)!

nextLSBWord
	^self next + (self next bitShift: 8)!

nextLSBWordPut: a16BitW 
	self nextPut: (a16BitW bitAnd: 255).
	self nextPut: ((a16BitW bitShift: -8)
			bitAnd: 255)!

readBitmapFileHeader
	| position |
	position := self position.
	(self hasMagicNumber: 'BM' asByteArray)
		ifFalse: [^self errorCanNotRead].
	self position: position.
	bfType := self nextWord.
	bfSize := self nextLSBLong.
	bfReserved1 := self nextLSBWord.
	bfReserved2 := self nextLSBWord.
	bfOffBits := self nextLSBLong!

readBitmapInfoHeader
	biSize := self nextLSBLong.
	biWidth := self nextLSBLong.
	biHeight := self nextLSBLong.
	biPlanes := self nextLSBWord.
	biBitCount := self nextLSBWord.
	biCompression := self nextLSBLong.
	biSizeImage := self nextLSBLong.
	biXPelsPerMeter := self nextLSBLong.
	biYPelsPerMeter := self nextLSBLong.
	biClrUsed := self nextLSBLong.
	biClrImportant := self nextLSBLong!

readDepth1Data
	| image total progress count index |
	self position: bfOffBits.
	image := Image
				extent: biWidth @ biHeight
				depth: biBitCount
				palette: imagePalette.
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total.
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 128.
			0 to: biWidth - 1
				do: 
					[:x | 
					count = 128 ifTrue: [index := self next].
					image
						atX: x
						y: y
						put: (index bitAnd: count).
					count := count / 2.
					count < 1 ifTrue: [count := 128].
					progress := progress + 1.
					self progress: progress / total]].
	^image!

readDepth24Data
	| image total progress count rgb color index |
	self position: bfOffBits.
	image := Image
				extent: biWidth @ biHeight
				depth: biBitCount
				palette: imagePalette.
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total.
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 0.
			0 to: biWidth - 1
				do: 
					[:x | 
					rgb := self next + (self next bitShift: 8) + (self next bitShift: 16).
					color := self colorValueFrom: rgb.
					index := image palette indexOfPaintNearest: color.
					image
						atX: x
						y: y
						put: index.
					count := count + 3.
					progress := progress + 1.
					self progress: progress / total].
			[count \\ 4 = 0]
				whileFalse: 
					[self next.
					count := count + 1]].
	^image!

readDepth8Data
	| image total progress count index |
	self position: bfOffBits.
	image := Image
				extent: biWidth @ biHeight
				depth: biBitCount
				palette: imagePalette.
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total.
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 0.
			0 to: biWidth - 1
				do: 
					[:x | 
					index := self next.
					image
						atX: x
						y: y
						put: index.
					count := count + 1.
					progress := progress + 1.
					self progress: progress / total].
			[count \\ 4 = 0]
				whileFalse: 
					[self next.
					count := count + 1]].
	^image!

readImageData
	biCompression = 0 ifFalse: [^self errorCanNotRead].
	imageObject := nil.
	biBitCount = 24 ifTrue: [imageObject := self readDepth24Data].
	biBitCount = 8 ifTrue: [imageObject := self readDepth8Data].
	biBitCount = 1 ifTrue: [imageObject := self readDepth1Data].
	imageObject isNil ifTrue: [^self errorCanNotRead].
	^imageObject!

readImagePalette
	imagePalette := nil.
	biBitCount = 24 ifTrue: [imagePalette := self readDepth24Palette].
	biBitCount = 8 ifTrue: [imagePalette := self readDepth8Palette].
	biBitCount = 1 ifTrue: [imagePalette := self readDepth1Palette].
	imagePalette isNil ifTrue: [^self errorCanNotRead]!

writeBitmapFileHeader
	bfType := ($B asInteger bitShift: 8)
				+ $M asInteger.
	bfSize := 0.
	bfReserved1 := 0.
	bfReserved2 := 0.
	bfOffBits := nil.
	imageObject bitsPerPixel = 8 ifTrue: [bfOffBits := 54 + (imageObject palette size * 4)].
	imageObject bitsPerPixel = 24 ifTrue: [bfOffBits := 54].
	bfOffBits isNil ifTrue: [^self errorCanNotWrite].
	self nextWordPut: bfType.
	self nextLSBLongPut: bfSize.
	self nextLSBWordPut: bfReserved1.
	self nextLSBWordPut: bfReserved2.
	self nextLSBLongPut: bfOffBits!

writeBitmapInfoHeader
	biSize := 40.
	biWidth := imageObject width.
	biHeight := imageObject height.
	biPlanes := 1.
	biBitCount := imageObject bitsPerPixel.
	biCompression := 0.
	biSizeImage := 0.
	biXPelsPerMeter := 0.
	biYPelsPerMeter := 0.
	biClrUsed := 0.
	imageObject bitsPerPixel = 8 ifTrue: [biClrUsed := (imageObject palette size)].
	biClrImportant := 0.
	self nextLSBLongPut: biSize.
	self nextLSBLongPut: biWidth.
	self nextLSBLongPut: biHeight.
	self nextLSBWordPut: biPlanes.
	self nextLSBWordPut: biBitCount.
	self nextLSBLongPut: biCompression.
	self nextLSBLongPut: biSizeImage.
	self nextLSBLongPut: biXPelsPerMeter.
	self nextLSBLongPut: biYPelsPerMeter.
	self nextLSBLongPut: biClrUsed.
	self nextLSBLongPut: biClrImportant!

writeDepth24Data
	| total progress count index color rgb |
	self position = bfOffBits ifFalse: [^self errorCanNotWrite].
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total.
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 0.
			0 to: biWidth - 1
				do: 
					[:x | 
					index := imageObject atX: x y: y.
					color := imageObject palette at: index.
					rgb := self rgbIntegerFrom: color.
					self nextPut: (rgb bitAnd: 255).
					self nextPut: ((rgb bitShift: -8)
							bitAnd: 255).
					self nextPut: ((rgb bitShift: -16)
							bitAnd: 255).
					count := count + 3.
					progress := progress + 1.
					self progress: progress / total].
			[count \\ 4 = 0]
				whileFalse: 
					[self nextPut: 0.
					count := count + 1]].
	^imageObject!

writeDepth24Palette
	^imageObject palette!

writeDepth8Data
	| count index |
	self position = bfOffBits ifFalse: [^self errorCanNotWrite].
"
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total. 
"
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 0.
			0 to: biWidth - 1
				do: 
					[:x | 
					index := imageObject atX: x y: y.
					self nextPut: index.
					count := count + 1.
"					progress := progress + 1.
					self progress: progress / total
"
					].
			[count \\ 4 = 0]
				whileFalse: 
					[self nextPut: 0.
					count := count + 1]].
	^imageObject!

writeDepth8Palette
	| size palette array |
	size := 1 bitShift: biBitCount.
	palette := imageObject palette.
	palette size = size ifFalse: [self errorCanNotWrite].
	array := self rgbIntegerArrayFor: palette.
	array
		do: 
			[:rgb | 
			self nextPut: (rgb bitAnd: 255).
			self nextPut: ((rgb bitShift: -8)
					bitAnd: 255).
			self nextPut: ((rgb bitShift: -16)
					bitAnd: 255).
			self nextPut: 0].
	^imageObject palette!

writeImageData
	biCompression = 0 ifFalse: [^self errorCanNotWrite].
	biBitCount = 24 ifTrue: [^self writeDepth24Data].
	biBitCount = 8 ifTrue: [^self writeDepth8Data].
	^self errorCanNotWrite!

writeImagePalette
	imagePalette := nil.
	biBitCount = 24 ifTrue: [imagePalette := self writeDepth24Palette].
	biBitCount = 8 ifTrue: [imagePalette := self writeDepth8Palette].
	imagePalette isNil ifTrue: [^self errorCanNotWrite]! !
!BmpImageStream categoriesFor: #nextImage!accessing!public! !
!BmpImageStream categoriesFor: #nextLSBLong!public!stream access! !
!BmpImageStream categoriesFor: #nextLSBLongPut:!public!stream access! !
!BmpImageStream categoriesFor: #nextLSBWord!public!stream access! !
!BmpImageStream categoriesFor: #nextLSBWordPut:!public!stream access! !
!BmpImageStream categoriesFor: #readBitmapFileHeader!decoding!public! !
!BmpImageStream categoriesFor: #readBitmapInfoHeader!decoding!public! !
!BmpImageStream categoriesFor: #readDepth1Data!decoding!public! !
!BmpImageStream categoriesFor: #readDepth24Data!decoding!public! !
!BmpImageStream categoriesFor: #readDepth8Data!decoding!public! !
!BmpImageStream categoriesFor: #readImageData!decoding!public! !
!BmpImageStream categoriesFor: #readImagePalette!decoding!public! !
!BmpImageStream categoriesFor: #writeBitmapFileHeader!encoding!public! !
!BmpImageStream categoriesFor: #writeBitmapInfoHeader!encoding!public! !
!BmpImageStream categoriesFor: #writeDepth24Data!encoding!public! !
!BmpImageStream categoriesFor: #writeDepth24Palette!encoding!public! !
!BmpImageStream categoriesFor: #writeDepth8Data!encoding!public! !
!BmpImageStream categoriesFor: #writeDepth8Palette!encoding!public! !
!BmpImageStream categoriesFor: #writeImageData!encoding!public! !
!BmpImageStream categoriesFor: #writeImagePalette!encoding!public! !

!BmpImageStream class methodsFor!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!

example1
	"BmpImageStream example1."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename writeStream.
	[Cursor write showWhile: [stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example2
	"BmpImageStream example2."

	| filename stream image |
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename readStream.
	[Cursor read showWhile: [image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example3
	"BmpImageStream example3."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example4
	"BmpImageStream example4."

	| filename stream image |
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

system
	^'Goodies'!

version
	^'003'! !
!BmpImageStream class categoriesFor: #copyright!copyright!public! !
!BmpImageStream class categoriesFor: #example1!examples!public! !
!BmpImageStream class categoriesFor: #example2!examples!public! !
!BmpImageStream class categoriesFor: #example3!examples!public! !
!BmpImageStream class categoriesFor: #example4!examples!public! !
!BmpImageStream class categoriesFor: #system!copyright!public! !
!BmpImageStream class categoriesFor: #version!copyright!public! !

BosImageStream guid: (GUID fromString: '{511AD13C-04CA-45E9-92AC-0AEA739EAB83}')!
BosImageStream comment: 'BosImageStream 

Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!
!BosImageStream categoriesForClass!Unclassified! !
!BosImageStream methodsFor!

readHeader
	(self hasMagicNumber: 'BosImage' asByteArray)
		ifFalse: [^self errorCanNotRead]!

writeHeader
	self nextPutAll: 'BosImage' asByteArray.! !
!BosImageStream categoriesFor: #readHeader!decoding!public! !
!BosImageStream categoriesFor: #writeHeader!encoding!public! !

!BosImageStream class methodsFor!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!

example1
	"BosImageStream example1."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename writeStream.
	[Cursor write showWhile: [stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example2
	"BosImageStream example2."

	| filename stream image |
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename readStream.
	[Cursor read showWhile: [image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example3
	"BosImageStream example3."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example4
	"BosImageStream example4."

	| filename stream image |
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

system
	^'Goodies'!

version
	^'003'! !
!BosImageStream class categoriesFor: #copyright!copyright!public! !
!BosImageStream class categoriesFor: #example1!examples!public! !
!BosImageStream class categoriesFor: #example2!examples!public! !
!BosImageStream class categoriesFor: #example3!examples!public! !
!BosImageStream class categoriesFor: #example4!examples!public! !
!BosImageStream class categoriesFor: #system!copyright!public! !
!BosImageStream class categoriesFor: #version!copyright!public! !

GifImageStream guid: (GUID fromString: '{FA2BAFE4-5E78-4BED-A4BD-4AB3EB34DA17}')!
GifImageStream comment: 'GifImageStream 

Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!
!GifImageStream categoriesForClass!Unclassified! !
!GifImageStream methodsFor!

checkCodeSize
	(freeCode > maxCode and: [codeSize < 12])
		ifTrue:
			[codeSize := codeSize + 1.
			maxCode := (1 bitShift: codeSize) - 1]!

fillBuffer
	| packSize |
	packSize := self next.
	bufStream := ReadStream on: (self next: packSize)!

flushBits
	remainBitCount = 0
		ifFalse: 
			[self nextBytePut: bufByte.
			remainBitCount := 0].
	self flushBuffer!

flushBuffer
	bufStream isEmpty ifTrue: [^self].
	self nextPut: bufStream size.
	self nextPutAll: bufStream contents.
	bufStream := WriteStream on: (ByteArray new: 256)!

flushCode
	self flushBits!

nextBits
	| integer readBitCount shiftCount |
	integer := 0.
	remainBitCount = 0
		ifTrue: 
			[readBitCount := 8.
			shiftCount := 0]
		ifFalse: 
			[readBitCount := remainBitCount.
			shiftCount := remainBitCount - 8].
	[readBitCount < codeSize]
		whileTrue: 
			[self peekByte isNil ifTrue: [^eoiCode].
			integer := integer + (self nextByte bitShift: shiftCount).
			shiftCount := shiftCount + 8.
			readBitCount := readBitCount + 8].
	self peekByte isNil ifTrue: [^eoiCode].
	(remainBitCount := readBitCount - codeSize) = 0
		ifTrue: [integer := integer + (self nextByte bitShift: shiftCount)]
		ifFalse: [integer := integer + (self peekByte bitShift: shiftCount)].
	^integer bitAnd: maxCode!

nextBitsPut: anInteger 
	| integer writeBitCount shiftCount |
	shiftCount := 0.
	remainBitCount = 0
		ifTrue: 
			[writeBitCount := 8.
			integer := anInteger]
		ifFalse: 
			[writeBitCount := remainBitCount.
			integer := bufByte + (anInteger bitShift: 8 - remainBitCount)].
	[writeBitCount < codeSize]
		whileTrue: 
			[self nextBytePut: ((integer bitShift: shiftCount)
					bitAnd: 255).
			shiftCount := shiftCount - 8.
			writeBitCount := writeBitCount + 8].
	(remainBitCount := writeBitCount - codeSize) = 0
		ifTrue: [self nextBytePut: (integer bitShift: shiftCount)]
		ifFalse: [bufByte := integer bitShift: shiftCount].
	^anInteger!

nextByte
	bufStream atEnd
		ifTrue:
			[self atEnd ifTrue: [^nil].
			self fillBuffer].
	^bufStream next!

nextBytePut: aByte
	bufStream nextPut: aByte.
	bufStream size >= 254 ifTrue: [self flushBuffer]!

packBits: bits depthFrom8To: depth width: xSize height: ySize pad: pad 
	| maxPixelVal pixelInByte bitsWidth pBitsWidth pBits |
	(#(1 2 4) includes: depth)
		ifFalse: [^self error: 'depth must be 1, 2, or 4'].
	(#(8 16 32) includes: pad)
		ifFalse: [^self error: 'pad must be 8, 16, or 32'].
	maxPixelVal := (1 bitShift: depth)
				- 1.
	pixelInByte := 8 / depth.
	bitsWidth := xSize * 8 + pad - 1 // pad * (pad / 8).
	pBitsWidth := xSize * depth + pad - 1 // pad * (pad / 8).
	pBits := ByteArray new: pBitsWidth * ySize.
	1 to: ySize
		do: 
			[:i | 
			| bitIndex pBitIndex pixelVal count |
			bitIndex := i - 1 * bitsWidth.
			pBitIndex := i - 1 * pBitsWidth.
			pixelVal := 0.
			count := 0.
			1 to: xSize
				do: 
					[:j | 
					| val |
					val := bits at: (bitIndex := bitIndex + 1).
					val > maxPixelVal ifTrue: [^self error: 'can''t pack bits'].
					pixelVal := (pixelVal bitShift: depth)
								+ val.
					(count := count + 1) >= pixelInByte
						ifTrue: 
							[pBits at: (pBitIndex := pBitIndex + 1) put: pixelVal.
							pixelVal := 0.
							count := 0]].
			count > 0 ifTrue: [pBits at: (pBitIndex := pBitIndex + 1) put: (pixelVal bitShift: depth * (pixelInByte - count))]].
	^pBits!

peekByte
	bufStream atEnd
		ifTrue:
			[self atEnd ifTrue: [^nil].
			self fillBuffer].
	^bufStream peek!

readBitData
	| bits outCodes outCount bitMask initCodeSize code curCode oldCode inCode finChar set |
	pass := 0.
	xpos := 0.
	ypos := 0.
	rowByteSize := width * 8 + 7 // 8.
	remainBitCount := 0.
	bufByte := 0.
	bufStream := ReadStream on: ByteArray new.
	bits := ByteArray new: width * height.
	outCodes := ByteArray new: 1025.
	outCount := 0.
	bitMask := (1 bitShift: bitsPerPixel)
				- 1.
	prefixTable := Array new: 4096.
	suffixTable := Array new: 4096.
	initCodeSize := self next.
	self setParameters: initCodeSize.
	set := Set new: height.
	self progress: set size / height.
	[(code := self readCode) = eoiCode]
		whileFalse: [code = clearCode
				ifTrue: 
					[self setParameters: initCodeSize.
					curCode := oldCode := code := self readCode.
					finChar := curCode bitAnd: bitMask.
					set add: ypos.
					self progress: set size / height.
					self writePixel: finChar to: bits]
				ifFalse: 
					[curCode := inCode := code.
					curCode >= freeCode
						ifTrue: 
							[curCode := oldCode.
							outCodes at: (outCount := outCount + 1) put: finChar].
					[curCode > bitMask]
						whileTrue: 
							[outCount > 1024 ifTrue: [^self error: 'corrupt GIF file (OutCount)'].
							outCodes at: (outCount := outCount + 1) put: (suffixTable at: curCode + 1).
							curCode := prefixTable at: curCode + 1].
					finChar := curCode bitAnd: bitMask.
					outCodes at: (outCount := outCount + 1) put: finChar.
					outCount
						to: 1
						by: -1
						do: 
							[:i | 
							set add: ypos.
							self progress: set size / height.
							self writePixel: (outCodes at: i)
								to: bits].
					outCount := 0.
					prefixTable at: freeCode + 1 put: oldCode.
					suffixTable at: freeCode + 1 put: finChar.
					oldCode := inCode.
					freeCode := freeCode + 1.
					self checkCodeSize]].
	prefixTable := suffixTable := nil.
	^bits!

readCode
	^self nextBits!

readGraphicControlExtensionBlock
	| isTransparent |
	self next.
	isTransparent := (self next bitAnd: 1)
				= 1.
	self next: 2.
	isTransparent
		ifTrue: [transparentPixel := self next]
		ifFalse: [self next].
	self next!

readPixelFrom: bits
	| pixel |
	ypos >= height ifTrue: [^nil].
	pixel := bits at: (ypos * rowByteSize + xpos + 1).
	self updatePixelPosition.
	^pixel!

readWord
	^self next + (self next bitShift: 8)!

setParameters: initCodeSize
	clearCode := 1 bitShift: initCodeSize.
	eoiCode := clearCode + 1.
	freeCode := clearCode + 2.
	codeSize := initCodeSize + 1.
	maxCode := (1 bitShift: codeSize) - 1!

transparentPixel: aPixelValueOrNil 
	transparentPixel := aPixelValueOrNil!

unpackBits: bits depthTo8From: depth width: xSize height: ySize pad: pad 
	| bitMask pixelInByte bitsWidth upBitsWidth stopWidth trailingSize upBits |
	(#(1 2 4) includes: depth)
		ifFalse: [^self error: 'depth must be 1, 2, or 4'].
	(#(8 16 32) includes: pad)
		ifFalse: [^self error: 'pad must be 8, 16, or 32'].
	bitMask := (1 bitShift: depth)
				- 1.
	pixelInByte := 8 / depth.
	bitsWidth := xSize * depth + pad - 1 // pad * (pad / 8).
	upBitsWidth := xSize * 8 + pad - 1 // pad * (pad / 8).
	stopWidth := xSize * depth + 7 // 8.
	trailingSize := xSize - (stopWidth - 1 * pixelInByte).
	upBits := ByteArray new: upBitsWidth * ySize.
	1 to: ySize
		do: 
			[:i | 
			| bitIndex upBitIndex val |
			bitIndex := i - 1 * bitsWidth.
			upBitIndex := i - 1 * upBitsWidth.
			1 to: stopWidth - 1
				do: 
					[:j | 
					val := bits at: (bitIndex := bitIndex + 1).
					upBitIndex := upBitIndex + pixelInByte.
					1 to: pixelInByte
						do: 
							[:k | 
							upBits at: upBitIndex - k + 1 put: (val bitAnd: bitMask).
							val := val bitShift: depth negated]].
			val := (bits at: (bitIndex := bitIndex + 1))
						bitShift: depth negated * (pixelInByte - trailingSize).
			upBitIndex := upBitIndex + trailingSize.
			1 to: trailingSize
				do: 
					[:k | 
					upBits at: upBitIndex - k + 1 put: (val bitAnd: bitMask).
					val := val bitShift: depth negated]].
	^upBits!

updatePixelPosition
	(xpos := xpos + 1) >= width ifFalse: [^self].
	xpos := 0.
	interlace
		ifFalse: 
			[ypos := ypos + 1.
			^self].
	pass = 0
		ifTrue: 
			[(ypos := ypos + 8) >= height
				ifTrue: 
					[pass := pass + 1.
					ypos := 4].
			^self].
	pass = 1
		ifTrue: 
			[(ypos := ypos + 8) >= height
				ifTrue: 
					[pass := pass + 1.
					ypos := 2].
			^self].
	pass = 2
		ifTrue: 
			[(ypos := ypos + 4) >= height
				ifTrue: 
					[pass := pass + 1.
					ypos := 1].
			^self].
	pass = 3
		ifTrue: 
			[ypos := ypos + 2.
			^self].
	^self error: 'can''t happen'!

writeCode: aCode
	self nextBitsPut: aCode!

writeCodeAndCheckCodeSize: aCode
	self writeCode: aCode.
	self checkCodeSize!

writePixel: pixel to: bits 
	bits at: ypos * rowByteSize + xpos + 1 put: pixel.
	self updatePixelPosition!

writeWord: aWord 
	self nextPut: (aWord bitAnd: 255).
	self nextPut: ((aWord bitShift: -8)
			bitAnd: 255).
	^aWord! !
!GifImageStream categoriesFor: #checkCodeSize!private! !
!GifImageStream categoriesFor: #fillBuffer!packing!public! !
!GifImageStream categoriesFor: #flushBits!bits access!public! !
!GifImageStream categoriesFor: #flushBuffer!packing!public! !
!GifImageStream categoriesFor: #flushCode!encoding!public! !
!GifImageStream categoriesFor: #nextBits!bits access!public! !
!GifImageStream categoriesFor: #nextBitsPut:!bits access!public! !
!GifImageStream categoriesFor: #nextByte!packing!public! !
!GifImageStream categoriesFor: #nextBytePut:!packing!public! !
!GifImageStream categoriesFor: #packBits:depthFrom8To:width:height:pad:!private! !
!GifImageStream categoriesFor: #peekByte!packing!public! !
!GifImageStream categoriesFor: #readBitData!decoding!public! !
!GifImageStream categoriesFor: #readCode!decoding!public! !
!GifImageStream categoriesFor: #readGraphicControlExtensionBlock!GIF89a!public! !
!GifImageStream categoriesFor: #readPixelFrom:!encoding!public! !
!GifImageStream categoriesFor: #readWord!decoding!public! !
!GifImageStream categoriesFor: #setParameters:!private! !
!GifImageStream categoriesFor: #transparentPixel:!GIF89a!public! !
!GifImageStream categoriesFor: #unpackBits:depthTo8From:width:height:pad:!private! !
!GifImageStream categoriesFor: #updatePixelPosition!private! !
!GifImageStream categoriesFor: #writeCode:!encoding!public! !
!GifImageStream categoriesFor: #writeCodeAndCheckCodeSize:!encoding!public! !
!GifImageStream categoriesFor: #writePixel:to:!decoding!public! !
!GifImageStream categoriesFor: #writeWord:!encoding!public! !

!GifImageStream class methodsFor!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!

example1
	"GifImageStream example1."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename writeStream.
	[Cursor write showWhile: [stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example2
	"GifImageStream example2."

	| filename stream image |
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename readStream.
	[Cursor read showWhile: [image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example3
	"GifImageStream example3."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example4
	"GifImageStream example4."

	| filename stream image |
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

system
	^'Goodies'!

version
	^'003'! !
!GifImageStream class categoriesFor: #copyright!copyright!public! !
!GifImageStream class categoriesFor: #example1!examples!public! !
!GifImageStream class categoriesFor: #example2!examples!public! !
!GifImageStream class categoriesFor: #example3!examples!public! !
!GifImageStream class categoriesFor: #example4!examples!public! !
!GifImageStream class categoriesFor: #system!copyright!public! !
!GifImageStream class categoriesFor: #version!copyright!public! !

OrganizationUnit guid: (GUID fromString: '{24DE54D7-C7D5-4F4C-89C5-5617EBCD3111}')!
OrganizationUnit comment: ''!
!OrganizationUnit categoriesForClass!Unclassified! !
!OrganizationUnit methodsFor!

addMember: aPerson
	aPerson becomeMemberOf: self!

addOrganizationUnit: anOrganizationUnit
	units isNil ifTrue: [self initUnits].
	(self units includes: anOrganizationUnit) ifFalse:
		[self units add: anOrganizationUnit. anOrganizationUnit parent: self]!

addOrganizationUnitNamed: aString
	self addOrganizationUnit: (OrganizationUnit newNamed: aString)!

addSpecialRoleNamed: aName
	(self existSpecialRoleNamed: aName) ifFalse:
		[self specialRoles add: (Role new name: aName)]!

allJobRoles
	^self otherValuesAt: #jobRoles ifAbsent: [^#()]!

allJobRolesDownHierarchy
	"incudes me"
	^self allOrgUnits "down hierarchy"
		inject: Set new
		into: [:set :each | set addAll: each allJobRoles; yourself]!

allMembers
	"all members of that org.unit"
	| parties |
	parties :=  (self roles select: [:role | role isMemberRole]) 
		collect: [:each | each relatedParty].
	parties := parties addAll:
		((self relatedPartyRoles select: [:role | role isMemberRole]) 
			collect: [:each | each party]);
		yourself.
	^parties asSet asOrderedCollection!

allOrgUnits
	"all units down in hierarchy, together with self"
	| collection |
	collection := OrderedCollection new.
	collection add: self.
	self units do: [:each | collection addAll: each allOrgUnits].
	^collection!

allPersonsWithJobRoles
	"collect all persons holding job roles in this org unit"
	^self allJobRoles inject: Set new into: [:set :role | set addAll: role allPersons; yourself].!

company
	"return a company whom belongs that org.unit"
	^self parent company!

existJobRoleNamed: aString
	^(self otherValuesAt: #jobRoles ifAbsent: [^false])
		contains: [:each | each name = aString]!

existSpecialRoleNamed: aName
	^(self specialRoleNamed: aName) notNil!

initSpecialRoles
	specialRoles := OrderedCollection new!

initUnits
	units := OrderedCollection new!

isOrganizationUnit
	^true!

jobRoleNamed: aString
	^(self otherValuesAt: #jobRoles ifAbsent: [^nil])
		detect: [:each | each name = aString] ifNone: [nil]!

jobRoleWithUuid: aString
	"search for this job role through hierarchy starting from self"
	| found |
	^self allJobRoles detect: [:each | each uuid = aString] ifNone:
		[self units do: [:each | found := each jobRoleWithUuid: aString. found notNil ifTrue: [^found] ].
		nil]!

migrateToUnicode
	"from iso8859-2"
	"OrganizationUnit allInstances do: [:each | each migrateToUnicode]"
	super migrateToUnicode.!

orgUnitWithName: aString
	"search for this org.unit through hierarchy starting from self"
	| found |
	self name = aString ifTrue: [^self].
	self units do: [:each | each name = aString ifTrue: [^each] ].
	self units do: [:each | 
		found := each orgUnitWithName: aString. found notNil ifTrue: [^found] ].
	^nil!

orgUnitWithUuid: aString
	"search for this org.unit through hierarchy starting from self"
	| found |
	self uuid = aString ifTrue: [^self].
	self units do: [:each | each uuid = aString ifTrue: [^each] ].
	self units do: [:each | found := each orgUnitWithUuid: aString. found notNil ifTrue: [^found] ].
	^nil!

parent
	^parent!

parent: anOrganizationUnit
	parent := anOrganizationUnit!

preferedUrl
	| nme |
	nme := self name trimBlanks asSloveneWithoutCircumflexes.
	^'/org-enota/', nme asHttpFriendly, '.html'.

"OrganizationUnit allInstances do: [:each | 
	each repository notNil ifTrue: [each repository site urlResolver changeToPreferedURL: each] ]"!

removeJobRole: aJobRole
	self otherValuesAt: #jobRoles ifAbsent: [^nil].
	(self otherValuesAt: #jobRoles) remove: aJobRole ifAbsent: [^nil]!

removeJobRoleNamed: aString
	(self existJobRoleNamed: aString) ifFalse: [^nil].
	(self otherValuesAt: #jobRoles) remove: (self jobRoleNamed: aString)!

removeMember: aPerson
	aPerson noMoreMemberOf: self!

removeOrganizationUnit: anOrganizationUnit
	units isNil ifTrue: [^nil].
	(self units includes: anOrganizationUnit) ifTrue:
		[self units remove: anOrganizationUnit. anOrganizationUnit parent: nil]!

specialRoleCollection
	"all specail roles for that and parent org.units up in to the top of hierarchy.
	sorted by the top first!!"
	^(self parent notNil and: [self parent isKindOf: Party])
		ifTrue: [self parent specialRoleCollection addAll: self specialRoles; yourself]
		ifFalse: [self specialRoles]!

specialRoleNamed: aName
	^self specialRoles detect: [:each | each name = aName] ifNone: [nil]!

specialRoles
	"a set of roles, specific for member of that org.unit, like aprover, tester etc"
	specialRoles isNil ifTrue: [self initSpecialRoles].
	^specialRoles!

type
	^type!

type: aSymbol
	"kind of org.unit like #division #sector #group etc."
	type := aSymbol!

units
	units isNil ifTrue: [^#()].
	^units! !
!OrganizationUnit categoriesFor: #addMember:!adding-removing!public! !
!OrganizationUnit categoriesFor: #addOrganizationUnit:!adding-removing!public! !
!OrganizationUnit categoriesFor: #addOrganizationUnitNamed:!adding-removing!public! !
!OrganizationUnit categoriesFor: #addSpecialRoleNamed:!public!roles - special! !
!OrganizationUnit categoriesFor: #allJobRoles!job roles!public! !
!OrganizationUnit categoriesFor: #allJobRolesDownHierarchy!job roles!public! !
!OrganizationUnit categoriesFor: #allMembers!public!roles - specific! !
!OrganizationUnit categoriesFor: #allOrgUnits!accessing!public! !
!OrganizationUnit categoriesFor: #allPersonsWithJobRoles!job roles!public! !
!OrganizationUnit categoriesFor: #company!accessing!public! !
!OrganizationUnit categoriesFor: #existJobRoleNamed:!job roles!public! !
!OrganizationUnit categoriesFor: #existSpecialRoleNamed:!public!roles - special! !
!OrganizationUnit categoriesFor: #initSpecialRoles!initialize-release!public! !
!OrganizationUnit categoriesFor: #initUnits!initialize-release!public! !
!OrganizationUnit categoriesFor: #isOrganizationUnit!public!testing! !
!OrganizationUnit categoriesFor: #jobRoleNamed:!job roles!public! !
!OrganizationUnit categoriesFor: #jobRoleWithUuid:!accessing!public! !
!OrganizationUnit categoriesFor: #migrateToUnicode!private! !
!OrganizationUnit categoriesFor: #orgUnitWithName:!accessing!public! !
!OrganizationUnit categoriesFor: #orgUnitWithUuid:!accessing!public! !
!OrganizationUnit categoriesFor: #parent!accessing!public! !
!OrganizationUnit categoriesFor: #parent:!private! !
!OrganizationUnit categoriesFor: #preferedUrl!private! !
!OrganizationUnit categoriesFor: #removeJobRole:!job roles!public! !
!OrganizationUnit categoriesFor: #removeJobRoleNamed:!job roles!public! !
!OrganizationUnit categoriesFor: #removeMember:!adding-removing!public! !
!OrganizationUnit categoriesFor: #removeOrganizationUnit:!adding-removing!public! !
!OrganizationUnit categoriesFor: #specialRoleCollection!public!roles - special! !
!OrganizationUnit categoriesFor: #specialRoleNamed:!public!roles - special! !
!OrganizationUnit categoriesFor: #specialRoles!public!roles - special! !
!OrganizationUnit categoriesFor: #type!accessing!public! !
!OrganizationUnit categoriesFor: #type:!accessing!public! !
!OrganizationUnit categoriesFor: #units!accessing!public! !

!OrganizationUnit class methodsFor!

newNamed: aString
	^self new name: aString!

replicationSpecaa
	"Gemstone"
	^super replicationSpec! !
!OrganizationUnit class categoriesFor: #newNamed:!instance creation!public! !
!OrganizationUnit class categoriesFor: #replicationSpecaa!odb specific!public! !

Person guid: (GUID fromString: '{7A0FC29F-F3FD-4CFB-9CCC-C75D79C02162}')!
Person comment: ''!
!Person categoriesForClass!Unclassified! !
!Person methodsFor!

activitiesNotified
	"all process activities on which this person is notified"
	| activities set |
	activities := self allRecordFlows collect: [:each | each activity].
	set := Set new: activities size. "remove duplicates, preserve order"
	^activities select: [:each || exist | exist := set includes: each. set add: each. exist not]!

activitiesResponsible
	"all process activities where this person have some kind of responsibility"
	| activities set |
	activities := (self allResponsibilities select: [:each | each isTaskResponsibility])
		collect: [:each | each task activity].
	set := Set new: activities size. "remove duplicates, preserve order"
	^activities select: [:each || exist | exist := set includes: each. set add: each. exist not]!

allDeputies
	"all deputies of that person"
	^(self relatedPartyRoles select: [:role | role isDeputyRole]) collect: [:each | each party]!

allDeputyOf
	"all persons to whom that person is deputy"
	^(self roles select: [:role | role isDeputyRole]) collect: [:each | each relatedParty]!

allOrgUnits
	"all org.units where person is member"
	^((self roles select: [:role | role isMemberRole]) collect: [:role | role relatedParty]) asSet.!

allRecordFlows
	"all record flows, concerned to that person"
	| flows set |
	flows := OrderedCollection new.
	self repository root allProcesses do: [:process | 
		process allTasks do: [:task | flows addAll: task allRecordFlows] ].
	set := Set new. self jobRole isNil ifTrue: [^#()].
	set add: self jobRole parentRole.
	set addAll: (self repository company roleGroupsIncludeRole: self jobRole parentRole).
	^flows select: [:flow | set includes: flow destination]!

allResponsibilities
	"search for all responsibilities through document repository, specially processes"
	| resps set |
	resps := OrderedCollection new. self repository isNil ifTrue: [^resps].
	self repository root allProcesses do: [:process |
		process allTasks do: [:task | resps addAll: task responsible] ].
	set := Set new. self jobRole isNil ifTrue: [^#()].
	set add: self jobRole parentRole.
	set addAll: (self repository company roleGroupsIncludeRole: self jobRole parentRole).
	^resps select: [:resp | set includes: resp role]!

allTaskResponsibilities
	^self allResponsibilities select: [:each | each isTaskResponsibility]!

asPerson
	^self!

asWebUser
	"return related WebUser object, for logon, security etc"
	^self otherValuesAt: #WebUser ifAbsent: [nil]!

becomeMemberOf: anOrgUnit 
	"I become a member  of that org.unit"
	| role |
	(self isMemberOf: anOrgUnit) ifTrue: [^false].
	role := MemberRole new.
	role name: 'member role'.
	self newRole: role relatedTo: anOrgUnit!

company
	"in which he is employeed"
	| parties |
	parties :=  (self roles select: [:role | role isEmployeeRole]) 
		collect: [:each | each relatedParty].
	parties := parties addAll:
		((self relatedPartyRoles select: [:role | role isEmployeeRole]) 
			collect: [:each | each party]);
		yourself.
	^parties isEmpty ifTrue: [nil] ifFalse: [parties first]!

documentsToKnow
	"all documents with which this person should know about (be notified)"
	self repository isNil ifTrue: [^#()].
	^self repository root allDocuments select: [:each | each isReleased and: [each shouldKnow: self]].!

email
	^self asWebUser notNil 
		ifTrue: [self asWebUser email]
		ifFalse: [super email].!

email: aString 
	self asWebUser notNil 
		ifTrue: [self asWebUser email: aString]
		ifFalse: [super email: aString].!

haveDeputies
	^self relatedPartyRoles contains: [:role | role isDeputyRole].!

integratedWithOffice
	"WebDAV integration on MS IE"
	^self otherValuesAt: #integratedWithOffice ifAbsent: [false]!

integratedWithOffice: aBoolean
	"WebDAV integration on MS IE"
	self otherValuesAt: #integratedWithOffice put: aBoolean.!

isChecker
	^self roles contains: [:role | role isCheckerRole].!

isDeputy
	^self roles contains: [:role | role isDeputyRole].!

isDeputyOf: aPerson
	^self roles contains: [:role | role relatedParty == aPerson and: [role isDeputyRole] ].!

isEmployeeOf: aParty
	| employee |
	employee := self roles contains: [:role | role relatedParty == aParty and: [role isEmployeeRole] ].
	employee ifTrue: [^true].
	"check also a complementary role"
	^self relatedPartyRoles contains: [:role | role party == aParty and: [role isEmployeeRole] ].!

isFormerEmployeeOf: aParty
	| formerEmployee |
	formerEmployee := self roles contains: [:role | 
		role relatedParty == aParty and: [role isFormerEmployeeRole]].
	formerEmployee ifTrue: [^true].
	"check also a complementary role"
	^self relatedPartyRoles contains: [:role | role party == aParty and: [role isFormerEmployeeRole] ].!

isGeomerAdmin
	^self roles contains: [:role | role isAdminRole].!

isMeasurer
	^self roles contains: [:role | role isMeasurerRole].!

isMemberOf: anOrgUnit
	| isMember |
	isMember := self roles contains: [:role | role relatedParty == anOrgUnit and: [role isMemberRole] ].
	isMember ifTrue: [^true].
	"check also a complementary role"
	^self relatedPartyRoles contains: [:role | role party == anOrgUnit and: [role isMemberRole] ].!

isPerson
	^true!

isStamper
	^self roles contains: [:role | role isStamperRole].!

isWebUser
	^false!

isWebUserGroup
	^false!

jobParentRole
	self jobRole isNil ifTrue: [^nil].
	^self jobRole parentRole.!

jobRole
	^self roles detect: [:role | role isJobRole] ifNone: [^nil].!

jobRoleName
	^self jobRole notNil ifTrue: [self jobRole name] ifFalse: [''].!

jobRoleNamed: aString
	"org.unit should have this job role already defined!!"
	| parentRole |
	self organizationUnit isNil ifTrue: [^nil].
	parentRole := self organizationUnit jobRoleNamed: aString. parentRole isNil ifTrue: [^nil].
	self jobRole notNil ifTrue: [self removeJobRole].
	self newRole: parentRole newChildRole relatedTo: self company!

menuName
	"in dropdown menus"
	^self surnameName!

migrateToUnicode
	"from iso8859-2"
	"Person allInstances do: [:each | each migrateToUnicode]"
	super migrateToUnicode.
	surname notNil ifTrue: [surname := surname ensureUnicodeSloveneChars].!

nameSurname
	^self name, ' ', self surname!

nameToDisplay
	"on web pages for instance"
	^self surnameName!

noMoreDeputyOf: aPerson
	| role |
	role := self roles 
		detect: [:each | each relatedParty == aPerson and: [each isDeputyRole] ] ifNone: [nil].
	role notNil ifTrue: [self discontinueRole: role].
	role := aPerson relatedPartyRoles 
		detect: [:each | each relatedParty == self and: [each isDeputyRole] ] ifNone: [nil].
	role notNil ifTrue: [aPerson discontinueRole: role].!

noMoreEmployeeOf: aParty 
	"no more an employee of related party"
	| role |
	role := self roles 
		detect: [:each | each relatedParty == aParty and: [each isEmployeeRole] ] ifNone: [nil].
	role notNil ifTrue: [self discontinueRole: role].
	role := aParty relatedPartyRoles 
		detect: [:each | each relatedParty == self and: [each isEmployeeRole] ] ifNone: [nil].
	role notNil ifTrue: [aParty discontinueRole: role].

	self becomeFormerEmployeeOf: aParty.!

noMoreFormerEmployeeOf: aParty 
	| role |
	role := self roles 
		detect: [:each | each relatedParty == aParty and: [each isFormerEmployeeRole] ] ifNone: [nil].
	role notNil ifTrue: [self discontinueRole: role].
	role := aParty relatedPartyRoles 
		detect: [:each | each relatedParty == self and: [each isFormerEmployeeRole] ] ifNone: [nil].
	role notNil ifTrue: [aParty discontinueRole: role].!

noMoreMemberOf: anOrgUnit 
	"no more a memebr of related party"
	(self isMemberOf: anOrgUnit) ifFalse: [^nil].
	self discontinueRole:
		(self roles detect: [:role | role relatedParty == anOrgUnit and: [role isMemberRole] ] ifNone: [^nil])!

organizationUnit
	"in which he is a member"
	| parties |
	parties :=  (self roles select: [:role | role isMemberRole]) 
		collect: [:each | each relatedParty].
	parties := parties addAll:
		((self relatedPartyRoles select: [:role | role isMemberRole]) 
			collect: [:each | each party]);
		yourself.
	^parties isEmpty ifTrue: [nil] ifFalse: [parties first]!

organizationUnit: anOrganizationUnit
	self allOrgUnits do: [:each | self noMoreMemberOf: each].
	anOrganizationUnit notNil ifTrue: [self becomeMemberOf: anOrganizationUnit]!

organizationUnitName
	^self organizationUnit notNil ifTrue: [self organizationUnit name] ifFalse: ['']!

password
	self asWebUser notNil ifTrue: [^self asWebUser password].
	^nil!

password: aString 
	self asWebUser notNil ifTrue: [^self asWebUser password: aString trimBlanks].!

passwordText
	"password is encripted/invisible anway, so return just empty "
	^''!

passwordText: aString
	aString = self passwordText "all *****, this means that password was not changed"
		ifTrue: [^nil]. 
	aString trimBlanks isEmpty ifTrue: [^nil].
	^self password: aString!

preferedUrl
	| nme |
	nme := self surnameName trimBlanks asSloveneWithoutCircumflexes.
	^'/oseba/', nme asHttpFriendly, '.html'.

"Person allInstances do: [:each | 
	each repository notNil ifTrue: [each repository site urlResolver changeToPreferedURL: each] ]"!

printString
	^'Person: ', self name, ' ', self surname!

processesNotified
	"all processes where on which this person is notified"
	| processes set |
	processes := self allRecordFlows collect: [:each | each process].
	set := Set new: processes size. "remove duplicates, preserve order"
	^processes select: [:each || exist | exist := set includes: each. set add: each. exist not]!

processesResponsible
	"all processes where this person have some kind of responsibility"
	| processes set |
	processes := self allResponsibilities collect: [:each | each process].
	set := Set new: processes size. "remove duplicates, preserve order"
	^processes select: [:each || exist | exist := set includes: each. set add: each. exist not]!

removeJobRole
	self jobRole notNil ifTrue: [self discontinueRole: self jobRole].!

repository
	self organizationUnit notNil ifTrue: [^self organizationUnit repository].
	self company notNil ifTrue: [^self company repository].
	^self app site repository!

specialRoleCollection
	"a set of additional roles by person's org.unit and org.hierarch up to the top"
	^self organizationUnit notNil
		ifTrue: [self organizationUnit specialRoleCollection]
		ifFalse: [self company notNil
			ifTrue: [self company specialRoleCollection]
			ifFalse: [OrderedCollection new] ].!

surname
	surname isNil ifTrue: [self surname: ''].
	^surname!

surname: aString
	surname := aString trimBlanks!

surnameName
	^self surname, ' ', self name!

surnameName2
	^self surnameName trimBlanks notEmpty 
		ifTrue: [self surnameName]
		ifFalse: ['--brez priimka in imena---']!

tasksNotified
	"all process tasks  on which this person is notified"
	| tasks set |
	tasks := self allRecordFlows collect: [:each | each task].
	set := Set new: tasks size. "remove duplicates, preserve order"
	^tasks select: [:each || exist | exist := set includes: each. set add: each. exist not]!

tasksResponsible
	"all process tasks where this person have some kind of responsibility"
	| tasks set |
	tasks := (self allResponsibilities select: [:each | each isTaskResponsibility]) 
		collect: [:each | each task].
	set := Set new: tasks size. "remove duplicates, preserve order"
	^tasks select: [:each || exist | exist := set includes: each. set add: each. exist not]!

username
	self asWebUser notNil ifTrue: [^self asWebUser username].
	^nil!

username: aString 
	self asWebUser notNil ifTrue: [^self asWebUser username: aString trimBlanks].!

webUser: aWebUser
	"a parallel WebUser for web server security etc."
	self otherValuesAt: #WebUser put: aWebUser.
	(aWebUser otherValuesAt: #Person) ~= self ifTrue: [aWebUser person: self].! !
!Person categoriesFor: #activitiesNotified!public!record flows! !
!Person categoriesFor: #activitiesResponsible!public!responsibilities! !
!Person categoriesFor: #allDeputies!public!roles - specific! !
!Person categoriesFor: #allDeputyOf!public!roles - specific! !
!Person categoriesFor: #allOrgUnits!public!roles - specific! !
!Person categoriesFor: #allRecordFlows!public!record flows! !
!Person categoriesFor: #allResponsibilities!public!responsibilities! !
!Person categoriesFor: #allTaskResponsibilities!public!responsibilities! !
!Person categoriesFor: #asPerson!accessing!public! !
!Person categoriesFor: #asWebUser!accessing!public! !
!Person categoriesFor: #becomeMemberOf:!public!roles - specific! !
!Person categoriesFor: #company!public!roles - specific! !
!Person categoriesFor: #documentsToKnow!documents!public! !
!Person categoriesFor: #email!accessing!public! !
!Person categoriesFor: #email:!accessing!public! !
!Person categoriesFor: #haveDeputies!public!roles - testing! !
!Person categoriesFor: #integratedWithOffice!accessing-other!public! !
!Person categoriesFor: #integratedWithOffice:!accessing-other!public! !
!Person categoriesFor: #isChecker!public!roles - testing! !
!Person categoriesFor: #isDeputy!public!roles - testing! !
!Person categoriesFor: #isDeputyOf:!public!roles - testing! !
!Person categoriesFor: #isEmployeeOf:!public!roles - testing! !
!Person categoriesFor: #isFormerEmployeeOf:!public!roles - testing! !
!Person categoriesFor: #isGeomerAdmin!public!roles - testing! !
!Person categoriesFor: #isMeasurer!public!roles - testing! !
!Person categoriesFor: #isMemberOf:!public!roles - testing! !
!Person categoriesFor: #isPerson!public!testing! !
!Person categoriesFor: #isStamper!public!roles - testing! !
!Person categoriesFor: #isWebUser!public!testing! !
!Person categoriesFor: #isWebUserGroup!public!testing! !
!Person categoriesFor: #jobParentRole!public!roles - specific! !
!Person categoriesFor: #jobRole!public!roles - specific! !
!Person categoriesFor: #jobRoleName!public!roles - specific! !
!Person categoriesFor: #jobRoleNamed:!public!roles - specific! !
!Person categoriesFor: #menuName!accessing!public! !
!Person categoriesFor: #migrateToUnicode!private! !
!Person categoriesFor: #nameSurname!accessing!public! !
!Person categoriesFor: #nameToDisplay!accessing!public! !
!Person categoriesFor: #noMoreDeputyOf:!public!roles - specific! !
!Person categoriesFor: #noMoreEmployeeOf:!public!roles - specific! !
!Person categoriesFor: #noMoreFormerEmployeeOf:!public!roles - specific! !
!Person categoriesFor: #noMoreMemberOf:!public!roles - specific! !
!Person categoriesFor: #organizationUnit!public!roles - specific! !
!Person categoriesFor: #organizationUnit:!public!roles - specific! !
!Person categoriesFor: #organizationUnitName!public!roles - specific! !
!Person categoriesFor: #password!accessing!public! !
!Person categoriesFor: #password:!accessing!public! !
!Person categoriesFor: #passwordText!accessing!public! !
!Person categoriesFor: #passwordText:!accessing!public! !
!Person categoriesFor: #preferedUrl!private! !
!Person categoriesFor: #printString!private! !
!Person categoriesFor: #processesNotified!public!record flows! !
!Person categoriesFor: #processesResponsible!public!responsibilities! !
!Person categoriesFor: #removeJobRole!public!roles - specific! !
!Person categoriesFor: #repository!accessing!public! !
!Person categoriesFor: #specialRoleCollection!public!roles - specific! !
!Person categoriesFor: #surname!accessing!public! !
!Person categoriesFor: #surname:!accessing!public! !
!Person categoriesFor: #surnameName!accessing!public! !
!Person categoriesFor: #surnameName2!accessing!public! !
!Person categoriesFor: #tasksNotified!public!record flows! !
!Person categoriesFor: #tasksResponsible!public!responsibilities! !
!Person categoriesFor: #username!accessing!public! !
!Person categoriesFor: #username:!accessing!public! !
!Person categoriesFor: #webUser:!accessing!public! !

Company guid: (GUID fromString: '{B55B3F3A-DD3A-4E1F-AFAB-D24FF2CA2AB0}')!
Company comment: ''!
!Company categoriesForClass!Unclassified! !
!Company methodsFor!

addEmployee: aPerson
	aPerson becomeEmployeeOf: self!

allEvents
	^self events all!

autoEMailAddressesForPersons
	"Repository default company autoEMailAddressesForPersons"
	self allEmployees do: [:person |
		person email isValidEMailAddress ifFalse:  	
			[person email: (person name asSloveneWithoutCircumflexes asLowercase , '.',
			person surname asSloveneWithoutCircumflexes asLowercase, 
			'@salus.si')] ]!

cleanupEmployeeToOrgUnitsConnections
	"(AIDASite named: 'biart') repository company cleanupEmployeeToOrgUnitsConnections"
	| set employees |
	set := self allEmployees asSet.
	employees := self allOrgUnits "collect them through orgunits hierarchy"
		inject: Set new into: [:sett :each | sett addAll: each allMembers; yourself].
	(employees reject: [:each | set includes: each]) "those dangling"
		do: [:each | each becomeFormerEmployeeOf: self. each removeJobRole.
			self allOrgUnits do: [:unit | unit removeMember: each] ].
	employees := self allOrgUnits inject: Set new into: [:sett :each | 
		sett addAll: each allPersonsWithJobRoles; yourself].
	(employees reject: [:each | set includes: each])
		do: [: each | each removeJobRole].!

company
	^self!

connectEmployeesToOrgUnits
	"salus"	
	"preimenuj zacasno org.enote brez sumnikov!! "
	"Repository default company connectEmployeesToOrgUnits"
	| orgUnit |
	self allEmployees do: [:each |
		orgUnit := self salusOrgUnitFor: each.
		orgUnit notNil ifTrue: [each allOrgUnits isEmpty ifTrue: [each becomeMemberOf: orgUnit] ]]!

connectPersonsToWebUsers
	"Repository default company connectPersonsToWebUsers"
	self allEmployees do: [:each | 	AIDASite default securityManager addPerson: each]!

employeeNamed: aString
	^self allEmployees detect: [:each | aString = each name] ifNone: [nil]!

employeeNamedSurnamed: aString
	^self allEmployees detect: [:each | aString = each nameSurname] ifNone: [nil]!

employeeSurnamedNamed: aString
	^self allEmployees detect: [:each | aString = each surnameName] ifNone: [nil]!

existEmployeeWithId: aString
	^self allEmployees contains: [:each | each id = aString].!

existEmployeeWithName: aNameString surname: aSurnameString
	^self allEmployees contains: [:each | 
		(each name = aNameString) and: [each surname = aSurnameString]].!

isCompany
	^true!

preferedUrl
	| nme |
	nme := (self name copyUpTo: $ ) trimBlanks asSloveneWithoutCircumflexes asHttpFriendly.
	^'/podjetje/', nme, '.html'.!

removeEmployee: aPerson
	aPerson noMoreEmployeeOf: self.
	self allOrgUnits do: [:each | each removeMember: aPerson].
	aPerson removeJobRole! !
!Company categoriesFor: #addEmployee:!adding-removing!public! !
!Company categoriesFor: #allEvents!accessing-events!public! !
!Company categoriesFor: #autoEMailAddressesForPersons!import-export!public! !
!Company categoriesFor: #cleanupEmployeeToOrgUnitsConnections!private! !
!Company categoriesFor: #company!accessing!public! !
!Company categoriesFor: #connectEmployeesToOrgUnits!import-export!public! !
!Company categoriesFor: #connectPersonsToWebUsers!import-export!public! !
!Company categoriesFor: #employeeNamed:!accessing!public! !
!Company categoriesFor: #employeeNamedSurnamed:!accessing!public! !
!Company categoriesFor: #employeeSurnamedNamed:!accessing!public! !
!Company categoriesFor: #existEmployeeWithId:!public!testing! !
!Company categoriesFor: #existEmployeeWithName:surname:!public!testing! !
!Company categoriesFor: #isCompany!public!testing! !
!Company categoriesFor: #preferedUrl!private! !
!Company categoriesFor: #removeEmployee:!adding-removing!public! !

!Company class methodsFor!

replicationSpecaa
	"Gemstone"
	^#( 	(id 	replicate)
			(name replicate)
			(description replicate)
			(addresses max 4)
			(roles max 2)
			(relatedPartyRoles max 2)
			(events forwarder)
			(relatedObjects max 1) )! !
!Company class categoriesFor: #replicationSpecaa!odb specific!public! !

MemberRole guid: (GUID fromString: '{28EA47E1-6A2B-4665-A08F-E77B8FBC5164}')!
MemberRole comment: ''!
!MemberRole categoriesForClass!Unclassified! !
!MemberRole methodsFor!

isEmployeeRole
	^true!

isMemberRole
	^true!

printString
	^'aMemberRole ', self name! !
!MemberRole categoriesFor: #isEmployeeRole!public!testing! !
!MemberRole categoriesFor: #isMemberRole!public!testing! !
!MemberRole categoriesFor: #printString!private! !

WebSiteOwnerRole guid: (GUID fromString: '{9BCC23F9-3000-4479-92B6-0C9D45D89B94}')!
WebSiteOwnerRole comment: ''!
!WebSiteOwnerRole categoriesForClass!Unclassified! !
WebUserRole guid: (GUID fromString: '{28B5E0F2-01EE-4D8F-9E64-262522ABDA3F}')!
WebUserRole comment: ''!
!WebUserRole categoriesForClass!Unclassified! !
!WebUserRole methodsFor!

printString
	^'aWebUserRole ', self name! !
!WebUserRole categoriesFor: #printString!private! !

AIDASite guid: (GUID fromString: '{55622FB9-4270-4359-8B37-A1D16299964A}')!
AIDASite comment: ''!
!AIDASite categoriesForClass!Unclassified! !
!AIDASite methodsFor!

addAllowHeaderTo: aHTTPResponse
	| methods |
	methods := 'OPTIONS,GET,HEAD,POST,DELETE,TRACE,'.
	methods := methods, 'PROPFIND,PROPPATCH,MKCOL,PUT,COPY,MOVE,LOCK,UNLOCK'.
	aHTTPResponse addHeaderName: 'Allow' value: methods!

addDontCacheHeaderTo: aHTTPResponse forPage: aWebPage
	| object value |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	value := object aidaDontCache.
	value ifFalse: [value := aWebPage aidaDontCache]. "WebApp subclass can set it too!! "
	value ifTrue: [aHTTPResponse cacheControl: 'no-store, no-cache, must-revalidate'].!

addExpiresHeaderTo: aHTTPResponse forPage: aWebPage
	| object value |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	value := object expiresTimestamp.
	value isNil ifTrue: [value := aWebPage expiresTimestamp]. "WebApp subclass can set it too!! "
	value notNil ifTrue: [aHTTPResponse expires: value asSpTimestamp].!

addModifiedHeaderTo: aHTTPResponse forPage: aWebPage
	| object value |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	value := object modifiedTimestamp.
	value isNil ifTrue: [value := aWebPage modifiedTimestamp]. "WebApp subclass can set it too!! "
	value notNil ifTrue: [aHTTPResponse lastModified: value asSpTimestamp].!

addResponseHeadersTo: aHTTPResponse forPage: aWebPage
	"use observee in app to find timestamps, because observee points 
	to right version of an object!! "
	| object |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	aHTTPResponse contentType: object contentType.
	self addModifiedHeaderTo: aHTTPResponse forPage: aWebPage.
	self addExpiresHeaderTo: aHTTPResponse forPage: aWebPage.
	self addDontCacheHeaderTo: aHTTPResponse forPage: aWebPage.!

addResponseHeadersTo: aHTTPResponse forPage: aWebPage on: aWebSession
	"use observee in app to find timestamps, because observee points 
	to right version of an object!! "
	| object |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	aHTTPResponse contentType: object contentType.
	self addModifiedHeaderTo: aHTTPResponse forPage: aWebPage.
	self addExpiresHeaderTo: aHTTPResponse forPage: aWebPage.
	self addDontCacheHeaderTo: aHTTPResponse forPage: aWebPage.
	aWebSession cookie ifFalse: [aHTTPResponse cookie: (self cookieHeaderFor: aWebSession)].!

addressTextFor: anIPAddress

	^((anIPAddress hostAddress at: 1) printString, '.',
	(anIPAddress hostAddress at: 2) printString, '.',
	(anIPAddress hostAddress at: 3) printString, '.',
	(anIPAddress hostAddress at: 4) printString)!

addSystemService: aServiceObject named: aSymbol 
	"add a new system service (e.g URLResolver) to the dictionary of services"
	^self systemServices
		at: aSymbol asSymbol put: aServiceObject!

addToRunningHistoryCrashed: aBoolean
	"Call it at server startup (in setStartedTimestamp). It reads old timestamps (started and
	last alive) and add it to the history" 
	| array |
	array := Array new: 3.
	array
		at: 1 put: self startedTimestamp asSeconds;
		at: 2 put: self lastTimeAliveTimestamp asSeconds;
		at: 3 put: aBoolean.  "true if server crashed"
	self runningHistoryCollection add: array.!

addUserService: aServiceObject named: aSymbol 
	"add a new user service (e.g WebIndex) to the dictionary of services"
	self userServices
		at: aSymbol asSymbol put: aServiceObject

"
WebServer default 
	addUserService: (URLResolver default ooRefFromURL: '/koledar.html')
	named: #Koledar
"!

admin
	^self systemServices 
		at: #Admin
		ifAbsent: 
			[self addSystemService: (WebAdmin new) named: #Admin.
			self urlResolver defaultURL: '/admin.html' forObject: self admin.
			^self admin].!

afterLogin
	"url of a page to jump after ogin or #lastPage to back to last page before logout"
	^self settings at: #afterLogin ifAbsentPut: [#lastPage].!

afterLogin: aStringOrSymbol
	"1. url of page to jump"
	"2. #lastPage - back to a page before logout"
	"3. #myPage - to user's personal page, if exists"
	((aStringOrSymbol isKindOf: String) not and: 
		[(#(#lastPage #myPage) includes: aStringOrSymbol) not])
			ifTrue: [self error: 'wrong login argument'].
	self settings  at: #afterLogin put: aStringOrSymbol!

answer: anObject to: aRequest on: aWebSession

	aRequest isGet | aRequest isPost | aRequest isHead
		ifTrue: [^self answer: anObject toGetOrPost: aRequest on: aWebSession].
	aRequest isOptions ifTrue: [^self answer: anObject toOptions: aRequest on: aWebSession].
	aRequest isPropFind ifTrue: [^self answer: anObject toPropFind: aRequest on: aWebSession].
	aRequest isLock ifTrue: [^self answer: anObject toLock: aRequest on: aWebSession].
	aRequest isUnlock ifTrue: [^self answer: anObject toUnlock: aRequest on: aWebSession].
	aRequest isPut ifTrue: [^self answer: anObject toPut: aRequest on: aWebSession].
	^HTTPException notImplemented!

answer: anObject toPut: aRequest on: aWebSession
	"WebDAV: try to PUT content into that object"
	(anObject isKindOf: FileProxy) ifFalse: [^HTTPException forbidden].
	anObject put: aRequest putData.
	^HTTPResponse ok!

authenticationScheme
	"#Basic or #Digest, see rfc2617. Digest is recomended because password
	goes encrypted to server"
	self securityManager hasHttpBasicAuthenticationScheme ifTrue: [^#Basic].
	self securityManager hasHttpDigestAuthenticationScheme ifTrue: [^#Digest].
	^#None!

autoLogout
	"logout after 15min of inactivity. default is NO!! "
	^self settings at: #AutoLogout ifAbsent: [false]!

autoLogout: aBoolean
	"logout after 15min of inactivity"
	(aBoolean isKindOf: Boolean) ifFalse: [self error: 'wrong argument'].
	^self settings at: #AutoLogout put: aBoolean!

cache
	"a global cache of presentations of domain objects, if they are cached"
	^self systemServices 
		at: #Cache
		ifAbsent: [self addSystemService: (WebCache newOn: self) named: #Cache].!

cookieHeaderFor: aSession 
	"set a permanent cookie on client (up to year 2020, enough?) "
	"for secure sessions different id as for usual !! "
	| id |
	id := (aSession lastRequest notNil and: [aSession lastRequest isEncrypted])
		ifTrue: [aSession secureId] ifFalse: [aSession id].
	^(WriteStream on: String new)
		nextPutAll: self cookieName;
		nextPutAll: '=';
		nextPutAll: id printString;
		nextPutAll: '; path=/; expires=Friday, 01-Jan-2020 01:00:00 GMT';
		contents!

cookieName
	"this is the name for our cookie. It shold be unique, so it is a bit strange"
	^'aida9357'!

counters

	counters isNil ifTrue: [self initCounters].
	^counters

"WebServer default counters"!

countingPolicy
	^self settings at: #countingPolicy ifAbsentPut: [#all].!

countingPolicy: aSymbol
	"from who to count requests with WebCounters: #all, #excludeAdmins, #onlyGuests, #none"
	(#(#all, #excludeAdmins, #onlyGuests, #none) includes: aSymbol) 
		ifFalse: [self error: 'unknown policy'].
	self settings  at: #countingPolicy put: aSymbol!

cr
	^String with: Character cr!

critical: aBlock

	"For protecting critical sections in parallel execution of web requests. Use it always
	when you do things, which cannot be disturbed by another request. Exmaple:
		aServer critical: [<a block with critical section>]. "

	^WebTransactionMonitor critical: aBlock!

defaultLanguage
	"ISO 639 2-letter language code symbol for default language of that site"
	^self settings at: #defaultLanguage ifAbsentPut: [#en].!

defaultLanguage: aLanguageCodeSymbol
	"ISO 639 2-letter language code symbol for default language of that site"
	^self settings at: #defaultLanguage put: aLanguageCodeSymbol!

defaultUserService
	"which will be accessible with url: http:/hostname/ "
	^self demo!

demo
	^self userServices at: #WebDemo
		ifAbsent: 
			[self addUserService: WebDemo new named: #WebDemo.
			self urlResolver defaultURL: '/demo.html' forObject: self demo.
			^self demo]!

diagnostics

	"if true, diagnostic messages are written on transcript for every web request"
	^self settings  at: #diagnostics ifAbsentPut: [true].!

diagnostics: aBoolean
	"if true, diagnostic messages are written on transcript for every web request"
	(aBoolean isKindOf: Boolean) ifFalse: [self error: 'wrong argument'].
	self settings  at: #diagnostics put: aBoolean.!

disableWebDAVSupport
	"Web Distributed Authoring and Versioning (WebDAV, www.webdav.org) is disabled on this site"
	"AIDASite default disableWebDAVSupport"
	self settings at: #WebDAVEnabled put: false!

enableWebDAVSupport
	"Web Distributed Authoring and Versioning (WebDAV, www.webdav.org) is enabled on this site"
	"AIDASite default enableWebDAVSupport"
	self settings at: #WebDAVEnabled put: true!

help
	^self systemServices 
		at: #Help
		ifAbsent: 
			[self addSystemService: (WebHelp new) named: #Help.
			self urlResolver defaultURL: '/help.html' forObject: self help.
			^self help].!

helpDirectory

	^self settings  at: #helpDirectory ifAbsent: [^'']!

helpDirectory: aString
	" a directory, where help html dokuments are stored. See WebApplication help pages category for 
 	details"
	self settings  at: #helpDirectory put: aString.!

helpResolve: aResolution 
	(self canAnswer and: [aResolution siteMatch: self]) ifFalse: [^nil].
	^self answerTo: aResolution request!

helpURL

	^self settings  at: #helpURL ifAbsent: [^'']!

helpURL: aString
	self settings at: #helpURL put: aString.!

homeDirectory

	^self settings  at: #homeDirectory ifAbsent: [^'']!

homeDirectory: aString
	" a directory, which is the root for static html dokuments. Used for anAIDASite, when it searches 
	for usual html files. "
	self settings  at: #homeDirectory put: aString.!

hourlyStatsProcess

	"hourly report to transcript"
	"WebServer default hourlyStatsProcess"
	| hits pages new returning afterHits afterPages afterNew afterReturning |
	[
		hits := self totalCounter total.
		pages := self pagesCounter total.
		new :=	self newVisitorsCounter total.
		returning := self returningVisitorsCounter total.
		(Delay forSeconds: self secondsToHour) wait.
		[self isServing] whileTrue: 
			[afterHits := self totalCounter total.
			afterPages := self pagesCounter total.
			afterNew := self newVisitorsCounter total.
			afterReturning := self returningVisitorsCounter total.
			Transcript cr; show: '***'; cr; show:
				'***  ',  self name, ' ', 
				Time now hours printString, ':', Time now minutes printString, ' ',
				'    last hour hits: ', (afterHits - hits) printDotString, 
				'    pages: ', (afterPages - pages) printDotString, 
				'    visitors new: ', (afterNew - new) printDotString, 
				'    returning: ', (afterReturning - returning) printDotString;
				cr; show: '***'.
			self registerTopHourHits: (afterHits - hits) pages: (afterPages - pages).
			hits := afterHits. pages := afterPages.
			new := afterNew. returning := afterReturning.
			(Delay forSeconds: self secondsToHour) wait].
	] fork.!

incNotFoundCounter

	"call this after each request is processed"


	self critical:
		[self notFoundCounter incCounter].!

incRequestCounterFor: anObject

	"call this after each request is processed"


	self critical:
		[self totalCounter incCounter.
		(anObject contentType = 'text/html') 
			ifTrue: [self pagesCounter incCounter] ].!

index
	^self userServices 
		at: #WebIndex
		ifAbsent: 
			[self addUserService: WebIndex new named: #WebIndex.
			self urlResolver defaultURL: '/search.html' forObject: self index.
			^self index].!

initCounters
	"counters of web requests: total and by year/day of year"
	self critical: 
		[counters := IdentityDictionary new.
		self pagesCounter.
		self totalCounter.
		self newVisitorsCounter.
		self returningVisitorsCounter.
		self notFoundCounter].

"WebServer default initCounters"!

initFavicon
	"/favicon.ico, a small icon shown in browser near url address"
	"(AIDASite named: 'biart') initFavicon."
	| icon |
	icon := WebMethodImage
		initCache; 
		fromMethod: #favicon on: self style contentType: 'image/x-icon' site: self.
	self urlResolver defaultURL: '/favicon.ico' forObject: icon.!

initialize
	super initialize.
	WebTransactionMonitor addServer: self.
	self initializeDefaultSettings.
	self initUrlsForSystemServices.
	self initFavicon.
	WebTransactionMonitor commit.!

initializeDefaultSettings

	self host: 'newsite' ip: '127.0.0.1'  port: 8888.  "this is usable for tests only"
	self homeDirectory: (SpEnvironment onWindows ifTrue: ['.\'] ifFalse: ['./']).
	self helpDirectory: '.', (SpEnvironment onWindows ifTrue: ['\'] ifFalse: ['/']), 'help'.
	self helpURL: '/help'.
	self styleClass: 'DefaultWebStyle'.
	self diagnostics: false.
	self loggingPolicy: #none.
	self countingPolicy: #all.
	self smtpServer: self ip.
	self urgentNotificationEMail: 'info@eranova.si'.!

initTimestamps
	timestamps := IdentityDictionary new.
	self setLastTimeAliveTimestamp.
	self setCreatedTimestamp.

"WebServer default initTimestamps"!

initUrlsForSystemServices
	"register urls for access to system services if not already done"
	"AIDASite default initUrlsForSystemServices"
	self admin.
	self securityManager.
	self webMsgs.
	self statistics!

isWebDAVEnabled
	"Is Web Distributed Authoring and Versioning (WebDAV, www.webdav.org) ienabled on this site"
		^(self settings includesKey: #WebDAVEnabled)
			 and: [self settings includesKey: #WebDAVEnabled]!

keywords
	"global keywords, added to all webpages generated on this site"
	^self settings at: #keywords ifAbsent: ['']!

keywords: aString
	"global keywords, added to all webpages generated on this site"
	self settings  at: #keywords put: aString.!

log: aString
	self diagnostics ifTrue: [Transcript show: aString].!

logging

	"if true, all requests are logged into a database"
	^self settings  at: #logging ifAbsentPut: [false].!

loggingPolicy
	^self settings at: #loggingPolicy ifAbsentPut: [#none].!

loggingPolicy: aSymbol
	"from who to log requests with WebCounters: #all, #excludeAdmins, #onlyGuests, #none"
	(#(#all, #excludeAdmins, #onlyGuests, #none) includes: aSymbol) 
		ifFalse: [self error: 'unknown policy'].
	self settings  at: #loggingPolicy put: aSymbol!

logStringFor: aRequest
	^self name, ' ',
 		Date today dayOfMonth printString, '.',
		Date today monthIndex printString, ' ',
		Time now hours printString, ':', 
		Time now minutes printString,
		' from ', (aRequest peer notNil ifTrue: [aRequest peer] ifFalse: ['']), ' ',
		aRequest methodName, ' ',
		aRequest urlString!

mimeMap
	^self systemServices 
		at: #MimeMap
		ifAbsent: 
			[self addSystemService: MIMEMap new named: #MimeMap.
			^self mimeMap].!

minuteStatsProcess

	"every minute report to transcript"
	"WebServer default minuteStatsProcess"
	| hits pages new returning afterHits afterPages afterNew afterReturning |
	[
		hits := self totalCounter total.
		pages := self pagesCounter total.
		new :=	self newVisitorsCounter total.
		returning := self returningVisitorsCounter total.
		(Delay forSeconds: self secondsToMinute) wait.
		[self isServing] whileTrue: 
			[afterHits := self totalCounter total.
			afterPages := self pagesCounter total.
			afterNew := self newVisitorsCounter total.
			afterReturning := self returningVisitorsCounter total.
			Transcript cr; show: 
				self name, ' ', 
				Time now hours printString, ':', Time now minutes printString, ' ',
				'    last minute hits: ', (afterHits - hits) printDotString, 
				'    pages: ', (afterPages - pages) printDotString, 
				'    visitors new: ', (afterNew - new) printDotString, 
				'    returning: ', (afterReturning - returning) printDotString.
			self registerTopMinuteHits: (afterHits - hits) pages: (afterPages - pages).
			hits := afterHits. pages := afterPages.
			new := afterNew. returning := afterReturning.
			(Delay forSeconds: self secondsToMinute) wait].
	] fork.!

newVisitorsCounter
	"counter of new sessions"
	(self counters includesKey: #NewVisitors) ifFalse: 
 		["self error: 'newVisitorsCounter ??'."
		self counters at: #NewVisitors put: WebCounter new].
	^self counters at: #NewVisitors

"WebServer default newVisitorsCounter"!

notFoundCounter
	"counter of not found errors"
	(self counters includesKey: #NotFound) ifFalse: 
 		[self counters at: #NotFound put: WebCounter new].
	^self counters at: #NotFound

"WebServer default notFoundCounter"!

objectTo: aRequest  forSession: aSession
	| object  | 
	object := self urlResolver  ooRefFromURL: 
		(AIDASite convertFromWeb: aRequest uriString on: aSession). "for international Urls"
	aSession shouldCountRequests ifFalse: [^object].    "to skip admin requests etc."
	object notNil 
		ifTrue: 
			[self urlResolver incCounterFor: object.
			self incRequestCounterFor: object]
		ifFalse: 
			[self incNotFoundCounter.
			self log: ' not found: ', aRequest uriString, ' '.
			^nil ].
	self statistics collectStatsFrom: aRequest.
	^object!

pagesCounter
	"counter of only text/html pages"
	(self counters includesKey: #Pages) ifFalse: 
 		["self error: 'pagesCounter ??'."
		self counters 	at: #Pages put: WebCounter new].
	^self counters at: #Pages

"WebServer default pagesCounter"!

printString

	^'anAIDASite named: ', self name!

redirectToHost
	"if set, all requests are redirected to that hostname!!"
	| host |
	host := self settings  at: #redirectToHost ifAbsent: [^nil].
	(host isNil or: [host isEmpty]) ifTrue: [^nil].
	^host!

redirectToHost: aHostnameString
	"if set, all requests are redirected to that hostname!!"
	self settings  at: #redirectToHost put: aHostnameString!

releaseApplicationState
	"release application state (appsForObjects) of all sessions"
	^self sessionManager releaseApplicationState!

reportSocketError: anException request: aRequest
	"some hard to find error while streaming, i'm trying to debug it with that report"
"	Transcript cr; show: '**SpSocketError on ', self name, ': ', anException parameter messageText; cr.
	Transcript show:  aRequest printString; cr. "!

requestsInYear: aYearNumber
	"return a number of requests on specified year"

	| count |
	count := 0.
	((self counters at: #Daily) at: aYearNumber ifAbsent: [^0]) do: [:dayCount |
		count := count + dayCount].
	^count!

requestsOnDate: aDate
	"return a number of requests on specified date"

	^self totalCounter countsOnDate: aDate!

restart
	self stop.
	self start.!

returningVisitorsCounter
	"counter of returning sessions"
	(self counters includesKey: #ReturningVisitors) ifFalse: 
 		["self error: 'returningVisitorsCounter ??'."
		self counters
			at: #ReturningVisitors put: WebCounter new].
	^self counters at: #ReturningVisitors

"WebServer default returningVisitorsCounter"!

runningHistoryCollection
	^self timestamps at: #RunningHistory ifAbsentPut: [OrderedCollection new].!

secondsToHour

	| now | 
	now := Time now asSeconds.
	^(3600 - (now - (now // 3600 * 3600))) max: 0

"WebServer default secondsToHour"!

secondsToMinute

	| now | 
	now := Time now asSeconds.
	^(60 - (now - (now // 60 * 60))) max: 0

"WebServer default secondsToMinute"!

securityManager
	^self systemServices 
		at: #SecurityManager
		ifAbsent: 
			[self 
				addSystemService: (WebSecurityManager newOn: self)
				named: #SecurityManager.
			self urlResolver defaultURL: '/security.html' forObject: self securityManager.
			self securityManager initialize.
			^self securityManager].!

sessionManager
	^self systemServices 
		at: #SessionManager
		ifAbsent: 
			[self 
				addSystemService: (WebSessionManager newOn: self)
				named: #SessionManager.
			^self sessionManager].!

settings
	settings isNil ifTrue: 
		[settings := Dictionary new. 
		self initializeDefaultSettings].
	^settings

"WebServer default settings"!

settingsReport
	"a brief report of current settings to transcript, used at site startup"
	Transcript cr; show: 'server diagnostics: '.
	self diagnostics
		ifTrue: [Transcript show: 'ON']
		ifFalse: [Transcript show: 'OFF'].
	Transcript cr.!

shouldRedirect
	^self redirectToHost notNil!

smtpServer

	"an address of email server for outgoing mails (notifications, mailing lists etc.)"

	^self settings  at: #smtpServer ifAbsentPut: [self host].

"WebServer default smtpServer"!

smtpServer: anAddressString
	"an address of email server for outgoing mails (notifications, mailing lists etc.)"
	self settings  at: #smtpServer put: anAddressString.!

start
	self setStartedTimestampCrashed: self isServing.
	self setLastTimeAliveTimestamp.
	super start.
	self startServices.!

startServices
	self systemServices values do: [:service | (service class canUnderstand: #start) ifTrue: [service start] ].
	self userServices values do: [:service | (service class canUnderstand: #start) ifTrue: [service start] ].!

statistics
	^self systemServices 
		at: #Statistics
		ifAbsent: 
			[self 
				addSystemService: (WebStatistics newOn: self)
				named: #Statistics.
			self urlResolver defaultURL: '/stats.html' forObject: self statistics.
			^self statistics].!

stop
	super stop.
	self stopServices.
	self setLastTimeAliveTimestamp.!

stopServices
	self systemServices values do: [:service | (service class canUnderstand: #stop) ifTrue: [service stop] ].
	self userServices values do: [:service | (service class canUnderstand: #stop) ifTrue: [service stop] ].!

stopWatchdog
	self watchdog notNil ifTrue: 
		[self watchdog terminate.
		self watchdog: nil].!

style: aWebStyle
	style := aWebStyle.!

styleClass
	(self settings includesKey: #styleClass) ifFalse: 
		[self styleClass: 'DefaultWebStyle' ].
	^(self settings  at: #styleClass) asString!

styleClass: aClassOrString
	"name of a class to provide a style support for this site. Default is WebStyle"
	| nme |
	nme := (aClassOrString isKindOf: String)
		ifTrue: [aClassOrString] ifFalse: [aClassOrString name asString].
	self settings  at: #styleClass put: nme.
	self style: nil. "to initialize new style automatically"!

supportedLanguages
	"Which languages are supported on this site. Content may be in all those languages. 
	Default language is always among supported."
	^(self settings at: #supportedLanguages ifAbsent: [Set new])
		add: self defaultLanguage; yourself!

supportedLanguages: aSetOfLangCodes
	"Which languages are supported on this site. Content may be in all those languages. 
	Default language is always among supported."
	^self settings at: #supportedLanguages put: aSetOfLangCodes asSet!

systemServiceNamed: aSymbol

	"return a system service object with a specified name"

	^self systemServices at: aSymbol asSymbol ifAbsent: [^nil]!

systemServices
	"return a dictionary of system services (e.g. URLResolver, ImageManager etc.)"
	systemServices isNil 
		ifTrue: [systemServices := Dictionary new].
	^systemServices!

task: anObject

	self halt.!

tempDirectory
	" a directory for temporary files, usually ./temp. This directory is also created if not exist yet "
	^self settings  at: #tempDirectory ifAbsent: 
		[^self tempDirectory: self homeDirectory, 'temp']!

tempDirectory: aString
	" a directory for temporary files, usually ./temp. This directory is also created if not exist yet "
	| dir |
	self settings at: #tempDirectory put: aString.
	dir := SpFilename named: self tempDirectory.
	dir exists ifFalse: [dir makeDirectory].
	^self tempDirectory!

timestamps
	timestamps isNil ifTrue: [self initTimestamps].
	^timestamps!

totalCounter
	"counter of all web requests"
	(self counters includesKey: #Total) ifFalse: 
 		["self error: 'totalCounter ??'."
		self counters at: #Total put: WebCounter new].
	^self counters at: #Total

"WebServer default totalCounter"!

totalDowntime
	"return downtime between all server runs in seconds"
	"AIDASite default totalDowntime"
	| history downtime |
	history := self runningHistory.
	downtime := 0.
	history do: [:array | downtime := downtime + (array at: 4)].
	^downtime!

totalRequests
	"return a number of requests from server creation"

	^self totalCounter total.!

totalUptime
	"return uptime of all server runs in seconds"
	"AIDASite default totalUptime"
	| history uptime |
	history := self runningHistory.
	uptime := 0.
	history do: [:array | uptime := uptime + (array at: 3)].
	^uptime!

translator
	"translation support for Apps"
	^self systemServices 
		at: #Translator
		ifAbsent: [self addSystemService: (WebTranslator newOn: self) named: #Translator].!

uptime
	"return uptime of current server run in seconds (with 60s precision)"
	"AIDASite default uptime"
	^self lastTimeAliveTimestamp asSeconds - self startedTimestamp asSeconds!

urgentNotificationEMail

	"an email address or addresses (separated by comma) of all recipients of urgent server notifications "

	^self settings  at: #urgentNotificationEMail ifAbsentPut: ['janko.mivsek@eranova.si'].!

urgentNotificationEMail: anEMailAddressString
	"an email address or addresses (separated by comma) of all recipients of urgent server notifications "
	self settings  at: #urgentNotificationEMail put: anEMailAddressString.!

urlResolver
	^self systemServices 
		at: #URLResolver
		ifAbsent: 
			[self 
				addSystemService: (URLResolver newOn: self) 
				named: #URLResolver.
			^self urlResolver].!

urlsWithSessionId: aBoolean
	"is session id added to urls when browser cookie support is disabled?"
	(aBoolean isKindOf: Boolean) ifFalse: [self error: 'wrong argument'].
	^self settings at: #urlsWithSessionId put: aBoolean!

userServiceNamed: aSymbol

	"return a user service object with a specified name"

	^self userServices at: aSymbol asSymbol ifAbsent: [^nil]!

userServices
	"return a dictionary of user services (e.g. WebIndex, WebNews etc.)"
	userServices isNil ifTrue: [userServices := Dictionary new. ].
	^userServices!

watchdogAction
	self setLastTimeAliveTimestamp!

webMsgs
	^self systemServices 
		at: #WebMsgs
		ifAbsent: 
			[self addSystemService: (WebMsgs new)	named: #WebMsgs.
			^self webMsgs].!

webServerEMail

	"an email address of this web server "

	^self settings  at: #webServerEMail ifAbsentPut: ['aida-web@eranova.si'].!

webServerEMail: anEMailString
	"an email address of this web server "
	self settings  at: #webServerEMail put: anEMailString.! !
!AIDASite categoriesFor: #addAllowHeaderTo:!private-serving!public! !
!AIDASite categoriesFor: #addDontCacheHeaderTo:forPage:!private-serving!public! !
!AIDASite categoriesFor: #addExpiresHeaderTo:forPage:!private-serving!public! !
!AIDASite categoriesFor: #addModifiedHeaderTo:forPage:!private-serving!public! !
!AIDASite categoriesFor: #addResponseHeadersTo:forPage:!private-serving!public! !
!AIDASite categoriesFor: #addResponseHeadersTo:forPage:on:!private-serving!public! !
!AIDASite categoriesFor: #addressTextFor:!private-serving!public! !
!AIDASite categoriesFor: #addSystemService:named:!public!system services! !
!AIDASite categoriesFor: #addToRunningHistoryCrashed:!private! !
!AIDASite categoriesFor: #addUserService:named:!public!user services! !
!AIDASite categoriesFor: #admin!public!system services! !
!AIDASite categoriesFor: #afterLogin!public!settings! !
!AIDASite categoriesFor: #afterLogin:!public!settings! !
!AIDASite categoriesFor: #answer:to:on:!public!serving! !
!AIDASite categoriesFor: #answer:toPut:on:!public!serving! !
!AIDASite categoriesFor: #authenticationScheme!private! !
!AIDASite categoriesFor: #autoLogout!public!settings! !
!AIDASite categoriesFor: #autoLogout:!public!settings! !
!AIDASite categoriesFor: #cache!public!system services! !
!AIDASite categoriesFor: #cookieHeaderFor:!private-serving!public! !
!AIDASite categoriesFor: #cookieName!private-serving!public! !
!AIDASite categoriesFor: #counters!private-counters!public! !
!AIDASite categoriesFor: #countingPolicy!public!settings! !
!AIDASite categoriesFor: #countingPolicy:!public!settings! !
!AIDASite categoriesFor: #cr!private! !
!AIDASite categoriesFor: #critical:!accessing!public! !
!AIDASite categoriesFor: #defaultLanguage!public!settings! !
!AIDASite categoriesFor: #defaultLanguage:!public!settings! !
!AIDASite categoriesFor: #defaultUserService!public!user services! !
!AIDASite categoriesFor: #demo!public!user services! !
!AIDASite categoriesFor: #diagnostics!public!settings! !
!AIDASite categoriesFor: #diagnostics:!public!settings! !
!AIDASite categoriesFor: #disableWebDAVSupport!public!settings! !
!AIDASite categoriesFor: #enableWebDAVSupport!public!settings! !
!AIDASite categoriesFor: #help!public!system services! !
!AIDASite categoriesFor: #helpDirectory!public!settings-directories! !
!AIDASite categoriesFor: #helpDirectory:!public!settings-directories! !
!AIDASite categoriesFor: #helpResolve:!private-serving!public! !
!AIDASite categoriesFor: #helpURL!public!settings! !
!AIDASite categoriesFor: #helpURL:!public!settings! !
!AIDASite categoriesFor: #homeDirectory!public!settings-directories! !
!AIDASite categoriesFor: #homeDirectory:!public!settings-directories! !
!AIDASite categoriesFor: #hourlyStatsProcess!public!statistics-counters! !
!AIDASite categoriesFor: #incNotFoundCounter!private-counters!public! !
!AIDASite categoriesFor: #incRequestCounterFor:!private-counters!public! !
!AIDASite categoriesFor: #index!public!user services! !
!AIDASite categoriesFor: #initCounters!private-counters!public! !
!AIDASite categoriesFor: #initFavicon!initialize-release!public! !
!AIDASite categoriesFor: #initialize!initialize-release!public! !
!AIDASite categoriesFor: #initializeDefaultSettings!initialize-release!public! !
!AIDASite categoriesFor: #initTimestamps!initialize-release!public! !
!AIDASite categoriesFor: #initUrlsForSystemServices!initialize-release!public! !
!AIDASite categoriesFor: #isWebDAVEnabled!public!settings! !
!AIDASite categoriesFor: #keywords!public!settings! !
!AIDASite categoriesFor: #keywords:!public!settings! !
!AIDASite categoriesFor: #log:!printing!public! !
!AIDASite categoriesFor: #logging!public!settings! !
!AIDASite categoriesFor: #loggingPolicy!public!settings! !
!AIDASite categoriesFor: #loggingPolicy:!public!settings! !
!AIDASite categoriesFor: #logStringFor:!private-serving!public! !
!AIDASite categoriesFor: #mimeMap!public!system services! !
!AIDASite categoriesFor: #minuteStatsProcess!public!statistics-counters! !
!AIDASite categoriesFor: #newVisitorsCounter!private-counters!public! !
!AIDASite categoriesFor: #notFoundCounter!private-counters!public! !
!AIDASite categoriesFor: #objectTo:forSession:!private-serving!public! !
!AIDASite categoriesFor: #pagesCounter!private-counters!public! !
!AIDASite categoriesFor: #printString!printing!public! !
!AIDASite categoriesFor: #redirectToHost!public!settings! !
!AIDASite categoriesFor: #redirectToHost:!public!settings! !
!AIDASite categoriesFor: #releaseApplicationState!public!start/stop! !
!AIDASite categoriesFor: #reportSocketError:request:!public!serving! !
!AIDASite categoriesFor: #requestsInYear:!public!statistics-counters! !
!AIDASite categoriesFor: #requestsOnDate:!public!statistics-counters! !
!AIDASite categoriesFor: #restart!public!start/stop! !
!AIDASite categoriesFor: #returningVisitorsCounter!private-counters!public! !
!AIDASite categoriesFor: #runningHistoryCollection!private! !
!AIDASite categoriesFor: #secondsToHour!public!statistics-counters! !
!AIDASite categoriesFor: #secondsToMinute!public!statistics-counters! !
!AIDASite categoriesFor: #securityManager!public!system services! !
!AIDASite categoriesFor: #sessionManager!public!system services! !
!AIDASite categoriesFor: #settings!private! !
!AIDASite categoriesFor: #settingsReport!public!settings! !
!AIDASite categoriesFor: #shouldRedirect!private-serving!public! !
!AIDASite categoriesFor: #smtpServer!public!settings! !
!AIDASite categoriesFor: #smtpServer:!public!settings! !
!AIDASite categoriesFor: #start!public!start/stop! !
!AIDASite categoriesFor: #startServices!private! !
!AIDASite categoriesFor: #statistics!public!system services! !
!AIDASite categoriesFor: #stop!public!start/stop! !
!AIDASite categoriesFor: #stopServices!private! !
!AIDASite categoriesFor: #stopWatchdog!private! !
!AIDASite categoriesFor: #style:!private! !
!AIDASite categoriesFor: #styleClass!public!settings! !
!AIDASite categoriesFor: #styleClass:!public!settings! !
!AIDASite categoriesFor: #supportedLanguages!public!settings! !
!AIDASite categoriesFor: #supportedLanguages:!public!settings! !
!AIDASite categoriesFor: #systemServiceNamed:!public!system services! !
!AIDASite categoriesFor: #systemServices!private! !
!AIDASite categoriesFor: #task:!public! !
!AIDASite categoriesFor: #tempDirectory!public!settings-directories! !
!AIDASite categoriesFor: #tempDirectory:!public!settings-directories! !
!AIDASite categoriesFor: #timestamps!private! !
!AIDASite categoriesFor: #totalCounter!private-counters!public! !
!AIDASite categoriesFor: #totalDowntime!public!statistics! !
!AIDASite categoriesFor: #totalRequests!public!statistics-counters! !
!AIDASite categoriesFor: #totalUptime!public!statistics! !
!AIDASite categoriesFor: #translator!public!system services! !
!AIDASite categoriesFor: #uptime!public!statistics! !
!AIDASite categoriesFor: #urgentNotificationEMail!public!settings! !
!AIDASite categoriesFor: #urgentNotificationEMail:!public!settings! !
!AIDASite categoriesFor: #urlResolver!public!system services! !
!AIDASite categoriesFor: #urlsWithSessionId:!public!settings! !
!AIDASite categoriesFor: #userServiceNamed:!public!user services! !
!AIDASite categoriesFor: #userServices!private! !
!AIDASite categoriesFor: #watchdogAction!private! !
!AIDASite categoriesFor: #webMsgs!public!system services! !
!AIDASite categoriesFor: #webServerEMail!public!settings! !
!AIDASite categoriesFor: #webServerEMail:!public!settings! !

!AIDASite class methodsFor!

charC
	"return internal  unicode code for slovene character: uppercase c"
	^$C!

charCszSet
	^Set new
		add: self charc; add: self charC;
		add: self chars; add: self charS;
		add: self charz; add: self charZ;
		yourself!

charS
	"return internal  unicode code for slovene character: uppercase s"
	^$S!

charz
	"return internal unicode code for slovene character: lowercase z"
	^$z!

charZ
	"return internal unicode code for slovene character: uppercase z"
	^$Z!

convertFromWeb: aString on: aSession
	"convert aString, which is in code page, defined in aSession to an internal unicode "
	^self convert: aString fromCodepage: aSession codePage!

convertFromWebString: aString
	"converts special chars in http stream: 
		'+' as ' '
		%xx as appropriate ASCII char
	"
	| newString |
	newString := HTTPString decodedHTTPFrom: aString.
	newString := AIDASite convert:newString fromCodepage: #'utf-8'.
	^newString

"AIDASite convertFromWebString: (AIDASite convertToWebString: '+-% test one') "!

convertIRItoURL: aString
	"VW specific!!"
	| stream aByteString |
	stream := WriteStream on: ''.
	aByteString := self convert: aString toCodepage: #utf8.
	aByteString do: [ :char |
	('abcdefghijklmnopqrstuvwxyz0123456789./-+:~?#@=' includes: char asLowercase)
		ifTrue: [ stream nextPut: char. ]
		ifFalse: [ stream nextPut: $%; nextPutAll: (char asInteger printStringRadix: 16). ]. ]. "VW specific!! "
	^ stream contents.!

convertToWeb: aString on: aSession
	"rconver internal unicode aString to a proper code page, defined in aSession"
	^self convert: aString toCodepage: aSession codePage!

convertToWebString: aString
	"converts some special chars in http stream: 
		' ' as '+'
		%xx as appropriate ASCII char
	"
	^HTTPString encodedHTTPFrom: aString 

"AIDASite convertToWebString: '+-% test one' "!

decodeCharEntitiesIn: aString
	"  '&lt;tag&gt; = '<tag>'  "
	"Character entitty references, see http://www.w3.org/TR/html401/charset.html#h-5.3.2"
	| charDict in out |
	charDict := Dictionary new
		at: 'lt' put: $<; at: 'gt' put: $>;
		at: 'amp' put: $&; at: 'quot' put: $"; yourself.
	in := aString readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse: 
		[| ch entity | 
		ch := in next.
		ch = $& 
			ifTrue: 
				[entity := in upTo: $; .
				out nextPut: (charDict at: entity)]
			ifFalse: [out nextPut: ch]  ].
	^out contents!

encodeCharEntitiesIn: aString
	"  '<tag>' = '&lt;tag&gt;' "
	"Character entitty references,  see http://www.w3.org/TR/html401/charset.html#h-5.3.2"
	| charEntities charDict in out |
	charEntities := #($< $> $& $").
	(aString contains: [:ch | charEntities includes: ch ]) ifFalse: [^aString]. "quick test"
	charDict := Dictionary new
		at: $< put: '&lt;'; at: $> put: '&gt;';
		at: $& put: '&amp;'; at: $" put: '&quot;'; yourself.
	in := aString readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse: 
		[| ch | ch := in next.
		(charEntities includes: ch)
			ifTrue: [out nextPutAll: (charDict at: ch)]
			ifFalse: [out nextPut: ch]  ].
	^out contents!

encodeQuoteEntitiesIn: aString
	" Just double quotes '' to &quot;  "
	"Character entitty references,  see http://www.w3.org/TR/html401/charset.html#h-5.3.2"
	| in out |
	(aString contains: [:ch | ch = $" ]) ifFalse: [^aString]. "quick test"
	in := aString readStream. out := WriteStream on: String new.
	[in atEnd] whileFalse: 
		[| ch | ch := in next.
		ch = $"
			ifTrue: [out nextPutAll: '&quot;']
			ifFalse: [out nextPut: ch]  ].
	^out contents!

fromHexValue: aCharacter
	aCharacter isDigit 
		ifTrue: [^aCharacter asInteger - $0 asInteger]
		ifFalse: [
			(aCharacter asLowercase between: $a and: $f)
				ifTrue: [^aCharacter asLowercase asInteger - $a asInteger+10]
				ifFalse: [^nil]].!

hexCharFrom: aNumber
	^aNumber < 10 
		ifTrue: [($0 asInteger + aNumber) asCharacter]
		ifFalse: [($A asInteger + aNumber - 10) asCharacter]!

initializeDemoSite
	"prepare a demo site, if not already"
	"put that in Aida/Web bundle postLoad action!!"
	SwazooServer singleton aidaSites isEmpty ifTrue:
		[SwazooServer singleton aidaDemoSite].!

markedAsSubjectClass!

oldConvertToUnicode: aString
	^aString collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch asInteger = 61346 ifTrue: ["$~" 16r010D asCharacter]
					ifFalse: [ ch asInteger = 61552 ifTrue: ["$^" 16r010C asCharacter]
					ifFalse: [ ch asInteger = 252 ifTrue: ["${" 16r0151 asCharacter]
					ifFalse: [ ch asInteger = 9839 ifTrue: ["$[" 16r0160 asCharacter]
					ifFalse: [ ch asInteger = 235 ifTrue: ["$` " 16r017E asCharacter] 
					ifFalse: [ ch asInteger = 227 ifTrue: ["$@" 16r017D asCharacter]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		].!

return7BitFromCP852String: aString


	^aString collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch asInteger = 61346 ifTrue: [$~]
					ifFalse: [ ch asInteger = 61552 ifTrue: [$^]
					ifFalse: [ ch asInteger = 252 ifTrue: [${]
					ifFalse: [ ch asInteger = 9839 ifTrue: [$[]
					ifFalse: [ ch asInteger = 235 ifTrue: [$`] 
					ifFalse: [ ch asInteger = 227 ifTrue: [$@]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		].

"WebServer returnCZSFromCP852String: 'Miv'"!

returnCP1250FromCP852String: aString


	^(aString asWordArray collect: 
		[:ch | ch > 127 
			ifTrue:
				[ch  = 61346 ifTrue: [232 ]
					ifFalse: [ ch  = 61552 ifTrue: [200 ]
					ifFalse: [ ch  = 252 ifTrue: [154 ]
					ifFalse: [ ch  = 9839 ifTrue: [138 ]
					ifFalse: [ ch  = 235 ifTrue: [158 ]
					ifFalse: [ ch  = 227 ifTrue: [142 ]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		]) asString.

"WebServer returnCZSFromCP852String: 'Miv'"!

returnCP852From7BitString: aString


	^(aString asWordArray collect: 
		[:ch | 
			ch  = $~ asInteger ifTrue: [61346 ]
				ifFalse: [ ch  =   $^ asInteger 	ifTrue: [61552 ]
				ifFalse: [ ch  = ${ asInteger 	ifTrue: [252 ]
				ifFalse: [ ch  =   $[ asInteger 	ifTrue: [9839 ]
				ifFalse: [ ch  =   $` asInteger 	ifTrue: [235 ]
				ifFalse: [ ch  =    $@ asInteger	ifTrue: [227 ]
				ifFalse: [ch]]]]]]
		]) asString.

"WebServer returnCP852From7BitString: 'Miv{ek'"!

returnCP852FromCP1250String: aString


	^(aString asWordArray collect: 
		[:ch | ch > 127 
			ifTrue:
				[ch  = 232 ifTrue: [61346 ]
					ifFalse: [ ch  = 200 ifTrue: [61552 ]
					ifFalse: [ ch  = 154 ifTrue: [252 ]
					ifFalse: [ ch  = 138 ifTrue: [9839 ]
					ifFalse: [ ch  = 158 ifTrue: [235 ]
					ifFalse: [ ch  = 142 ifTrue: [227 ]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		]) asString.

"WebServer returnCP852FromCP1250String: 'Miv'"!

returnCP852FromISO2String: aString


	^(aString asWordArray collect: 
		[:ch | ch  > 127 
			ifTrue:
				[ch  = 232 ifTrue: [61346 ]
					ifFalse: [ ch  = 200 ifTrue: [61552 ]
					ifFalse: [ ch  = 185 ifTrue: [252 ]
					ifFalse: [ ch  = 169 ifTrue: [9839 ]
					ifFalse: [ ch  = 190 ifTrue: [235 ]
					ifFalse: [ ch  = 174 ifTrue: [227 ]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		]) asString.

"WebServer returnCP852FromISO2String: 'Mivsek'"!

returnCSZFromCP852String: aString


	^aString collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch asInteger = 61346 ifTrue: [$c]
					ifFalse: [ ch asInteger = 61552 ifTrue: [$C]
					ifFalse: [ ch asInteger = 252 ifTrue: [$s]
					ifFalse: [ ch asInteger = 9839 ifTrue: [$S]
					ifFalse: [ ch asInteger = 235 ifTrue: [$z]
					ifFalse: [ ch asInteger = 227 ifTrue: [$Z]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		].

"WebServer returnCZSFromCP852String: 'Miv'"!

returnCZSFromCP852String: aString


	^aString collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch asInteger = 61346 ifTrue: [$c]
					ifFalse: [ ch asInteger = 61552 ifTrue: [$C]
					ifFalse: [ ch asInteger = 252 ifTrue: [$s]
					ifFalse: [ ch asInteger = 9839 ifTrue: [$S]
					ifFalse: [ ch asInteger = 235 ifTrue: [$z]
					ifFalse: [ ch asInteger = 227 ifTrue: [$Z]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		].

"WebServer returnCZSFromCP852String: 'Miv'"!

returnISO2FromCP852String: aString


	^(aString asWordArray collect: 
		[:ch | ch  > 127 
			ifTrue:
				[ch  = 61346 ifTrue: [232 ]
					ifFalse: [ ch  = 61552 ifTrue: [200 ]
					ifFalse: [ ch  = 252 ifTrue: [185 ]
					ifFalse: [ ch  = 9839 ifTrue: [169 ]
					ifFalse: [ ch  = 235 ifTrue: [190 ]
					ifFalse: [ ch  = 227 ifTrue: [174 ]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		]) asString.

"WebServer returnCZSFromCP852String: 'Miv'"!

sloveneLowercase: aString
	^aString collect: [:chr | 
		(AIDASite isSloveneCharacter: chr)
			ifTrue: 	[(chr = AIDASite charC) ifTrue: [AIDASite charc]
				ifFalse: [(chr = AIDASite charS) ifTrue: [AIDASite chars]
					ifFalse: [(chr = AIDASite charZ) ifTrue: [AIDASite charz]
						ifFalse: [chr] ]]]
			ifFalse: [chr asLowercase]
		].!

sloveneUppercase: aString
	^aString collect: [:chr | 
		(AIDASite isSloveneCharacter: chr)
			ifTrue: 	[(chr = AIDASite charc) ifTrue: [AIDASite charC]
				ifFalse: [(chr = AIDASite chars) ifTrue: [AIDASite charS]
					ifFalse: [(chr = AIDASite charz) ifTrue: [AIDASite charZ]
						ifFalse: [chr] ]]]
			ifFalse: [chr asUppercase]
		].! !
!AIDASite class categoriesFor: #charC!aida unicode error!public!slovenian characters! !
!AIDASite class categoriesFor: #charCszSet!public!slovenian characters! !
!AIDASite class categoriesFor: #charS!aida unicode error!public!slovenian characters! !
!AIDASite class categoriesFor: #charz!aida unicode error!public!slovenian characters! !
!AIDASite class categoriesFor: #charZ!aida unicode error!public!slovenian characters! !
!AIDASite class categoriesFor: #convertFromWeb:on:!codepage converting!public! !
!AIDASite class categoriesFor: #convertFromWebString:!http encoding!public! !
!AIDASite class categoriesFor: #convertIRItoURL:!http encoding!public! !
!AIDASite class categoriesFor: #convertToWeb:on:!codepage converting!public! !
!AIDASite class categoriesFor: #convertToWebString:!http encoding!public! !
!AIDASite class categoriesFor: #decodeCharEntitiesIn:!http encoding!public! !
!AIDASite class categoriesFor: #encodeCharEntitiesIn:!http encoding!public! !
!AIDASite class categoriesFor: #encodeQuoteEntitiesIn:!http encoding!public! !
!AIDASite class categoriesFor: #fromHexValue:!http encoding!public! !
!AIDASite class categoriesFor: #hexCharFrom:!http encoding!public! !
!AIDASite class categoriesFor: #initializeDemoSite!initialize!public! !
!AIDASite class categoriesFor: #markedAsSubjectClass!ADvance!public! !
!AIDASite class categoriesFor: #oldConvertToUnicode:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #return7BitFromCP852String:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #returnCP1250FromCP852String:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #returnCP852From7BitString:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #returnCP852FromCP1250String:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #returnCP852FromISO2String:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #returnCSZFromCP852String:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #returnCZSFromCP852String:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #returnISO2FromCP852String:!codepages-obsolete!public! !
!AIDASite class categoriesFor: #sloveneLowercase:!public!slovenian characters! !
!AIDASite class categoriesFor: #sloveneUppercase:!public!slovenian characters! !

VersionedExample guid: (GUID fromString: '{7A136E58-5234-43D3-A320-464143377792}')!
VersionedExample comment: ''!
!VersionedExample categoriesForClass!Unclassified! !
!VersionedExample methodsFor!

body
	^body!

body: anObject
	body := anObject!

copyContentsTo: anObject
	anObject title: self title copy.
	anObject body: self body copy.!

printString
	^'aVersionedExample ', 
		(self title notNil ifTrue: [self title] ifFalse: ['']), ' ', 
		(self body notNil ifTrue: [self body] ifFalse: [''])!

title
	^title!

title: anObject
	title := anObject! !
!VersionedExample categoriesFor: #body!accessing!public! !
!VersionedExample categoriesFor: #body:!accessing!public! !
!VersionedExample categoriesFor: #copyContentsTo:!copying!public! !
!VersionedExample categoriesFor: #printString!printing!public! !
!VersionedExample categoriesFor: #title!accessing!public! !
!VersionedExample categoriesFor: #title:!accessing!public! !

VersionedExampleApp guid: (GUID fromString: '{A4AB1CEE-B733-4665-B99E-7631340F11E6}')!
VersionedExampleApp comment: ''!
!VersionedExampleApp categoriesForClass!Unclassified! !
WebAdminApp guid: (GUID fromString: '{EF5A98B4-7DB2-4378-8622-DE56246CE906}')!
WebAdminApp comment: ''!
!WebAdminApp categoriesForClass!Unclassified! !
!WebAdminApp methodsFor!

actionAddSite
	SwazooServer singleton addSite: self newSite.
	self newSite start.
	self redirectToView: #sites.!

actionForgoten
	self redirectTo: self site admin view: #passwordSent.!

actionLogin
	| user |
	user := self findLoggingUser.
	self password: ''.
	user notNil 
		ifTrue: [self session user: user. self reportLogin] 	
		ifFalse: [self error: 'error message from WebStyle!!'. self session logout. ^self].
	(self site afterLogin = #myPage and: [self site autoLogout not])
		ifTrue: [^self redirectTo: self user asPerson].
	self site afterLogin = #lastPage ifFalse: [^self redirectTo: self site afterLogin]. 
	(user logoutFromUrl notNil and: [self site urlResolver existURL: user logoutFromUrl])
		ifTrue: [self redirectTo: user logoutFromUrl] "back from where we were logout"
		ifFalse: [self redirectTo: '/']
"		ifFalse: [self redirectTo: (user asPerson notNil ifTrue: [user asPerson] ifFalse: ['/']) ] "!

actionLoginLogin
	| user |
	user := self site securityManager userNamed: self username withPassword: self password.
	self password: ''.
	user notNil 
		ifTrue: [self session user: user. self reportLogin] 	
		ifFalse: [self error: 'error message from WebStyle!!'. self session logout. ^self].
	self site afterLogin = #lastPage
		ifTrue: [self redirectTo: (user logoutFromUrl notNil "back from where we were logout"
			ifTrue: [user logoutFromUrl]
			ifFalse: [user asPerson notNil ifTrue: [user asPerson] ifFalse: ['/'] ])]
		ifFalse: [self redirectTo: '/'] "afterLogin = #defaultPage"!

actionRegistration
	self isRegistrationValid 
		ifTrue: 
			[self site securityManager addActivatingUser: self newUser.
			self newView: #waitingConfirmation]
		ifFalse: ["just reload registration form again"]!

actionSites
	self newSite: AIDASite new.
	self newSite uriPattern first 
		ip: self observee ip;
		port: self observee port.
	self redirectToView: #addSite.!

actionUpdateSettings
	[(Delay forMilliseconds: 500) wait.
	self site stop.
	self updateSettings.
	self site start] fork.
	self redirectToView: #redirect!

addSiteElement
	| e |
	e := WebElement new.
	e cell addText: 'Site name: '. 
	e newCell addInputFieldAspect: #name for: self newSite. e newRow.
	e cell colspan: 2; addRulerSize: 1. e newRow.
	e cell addText: 'Hostname: '. 
	e newCell addInputFieldAspect: #host for: self newSite uriPattern first. e newRow.
	e cell addText: 'IP: '. 
	e newCell addInputFieldAspect: #ip for: self newSite uriPattern first. e newRow.
	e cell addText: 'Port: '. 
	e newCell addInputFieldAspect: #port for: self newSite uriPattern first. e newRow.
	e cell colspan: 2; addRulerSize: 1. e newRow.
	e cell addText: 'Style class: '. 
	e newCell addInputFieldAspect: #styleClass for: self newSite. e newRow.
	e cell colspan: 2; addRulerSize: 1. e newRow.
	e cell addButtonText: 'Add and start a new site'.
	e cell colspan: 2; addRulerSize: 1. e newRow.
	^e.!

aidaDontCache
	^true!

dummy
	"aspect, just for nothing"
	^''!

dummy: aString
	"aspect, just for nothing"!

findLoggingUser
	^self site securityManager userNamed: self username withPassword: self password.!

isRegistrationValid
	"check entry fields and set error report if not"
	| text |
	text := ''.
	(self site securityManager 
		existUserNamed: self newUser username withPassword: self newUser username)
			ifTrue: [text := text, ' User with that username and password already exist!! ' ].
	text isEmpty ifTrue: 
		[self newUser username isEmpty ifTrue: [text := text, ' Username missing, '].
		self password isEmpty ifTrue: [text := text, ' Password missing, '].
		self newUser password isEmpty ifTrue: [text := text, ' Confirm password missing, '].
		((WebSecurityManager hashPassword: self password) = self newUser password)
			ifFalse: [text := text, ' Passwords not equal!! '] ].
	text notEmpty ifTrue: 
		[self error: 'Registration failed!! ', text, ' Please correct errors and try again!!'. ^false].
	^true!

newSite
	^newSite!

newSite: anObject
	newSite := anObject!

newUser
	^newUser!

newUser: anUser
	newUser := anUser!

password
	password isNil ifTrue: [self password: ''].
	^password!

password: aString
	password := aString.!

preloginCheck
	"this is called at the start of login page. Override if you want to redirect for some reason
	to another login page (#viewLoginSecondary)"
	^true!

prepareSettings
	self observee host: self site host.
	self observee ip: self site ip.
	self observee port: self site port.!

printSeconds: aNumber
	^(aNumber // 3600) printString, ':',
	(self twoDigits: aNumber \\ 3600 // 60), ':',
	(self twoDigits: aNumber \\ 60)!

reportLogin
	Transcript cr; show: 'login: ', self session user nameSurname asSloveneWithoutCircumflexes, 
	' on ', self site name,
	' at ', 
 	Date today dayOfMonth printString, '.',
	Date today monthIndex printString, ' ',
	Time now hours printString, ':', 
	Time now minutes printString,
	' from ', (self session lastRequest peer notNil ifTrue: [self session lastRequest peer] ifFalse: [''])!

reportLogout
	Transcript cr; show: 'logout: ', self session user nameSurname asSloveneWithoutCircumflexes, 
	' on ', self site name,
	' at ', 
 	Date today dayOfMonth printString, '.',
	Date today monthIndex printString, ' ',
	Time now hours printString, ':', 
	Time now minutes printString,
	' from ', (self session lastRequest peer notNil ifTrue: [self session lastRequest peer] ifFalse: [''])!

settingsElementForm: aBoolean
	| e |
	self prepareSettings.
	e := WebElement new. e table width: 500. e newRow.
	e cell addText: 'hostname: '. 
	e newCell addAspect: #host for: self observee input: aBoolean size: 30. e newRow.
	e cell addText: 'ip: '.
	e newCell addAspect: #ip for: self observee input: aBoolean size: 30. e newRow.
	e cell addText: 'port: '.
	e newCell addAspect: #port for: self observee input: aBoolean size: 5. e newRow.
	e cell addText: 'home directory: '.
	e newCell addAspect: #homeDirectory for: self site input: aBoolean size: 30. e newRow.
	e cell colspan: 2; addRulerSize: 1.
	^e.!

sitesElement
	| e sites |
	sites := SortedCollection 
		withAll: SwazooServer singleton sites
		sortBlock: [:a :b | a name < b name].
	e := (WebGrid new
		columnFilters: #(nil 5 nil );
		columnWidth: #(0.03 0.15 0.03);
		columnNames: #(nil 'name' '' 'created' 'started' 'status');
		columnAspects: #(nil name nil nil nil nil);
		column: 3 addBlock: [:site | WebLink text: 'link' linkTo: 'http://', site host, '/admin.html'];
		collection: sites;
		setNumbering; 
		yourself).
	^e.!

twoDigits: aNumber
	aNumber < 10
		ifTrue: [^'0',aNumber printString]
		ifFalse: [^aNumber printString]!

updateSettings
	self site host: self observee host.
	self site ip: self observee ip.
	self site port: self observee port.!

username
	username isNil ifTrue: [self username: ''].
	^username!

username: aString
	username := aString.!

viewActivation
	| e id user |
	(self session lastRequest includesQuery: 'userid') ifTrue:
		[id := (self session lastRequest queryAt: 'userid') asInteger.
		(self site securityManager existUserWithId: id) ifTrue:
			[user := self site securityManager userWithId: id.
			 self site securityManager addRegisteredUser: user.
			self session loginUser: user.
			self title: 'Activation successfull!!'.
			e := WebElement new.
			e addTextH1: 'Activation successfull!!'.
			e addText: 'Congratulations!! You are now a registered user of our portal. You are 
			already logged in and your name is shown on the page'. 
 			^self style pageFrameWith: e title: self title] ].

	self title: 'Activation failed!!'.
	e := WebElement new.
	e addTextH1: 'Activation failed!!'.
	e addText: ' You tried to activate an user account but activation failed. Please send an email to '. 
	e addLinkTo: 'info@eranova.si' text: 'Portal Administrator'.
 	^self style pageFrameWith: e title: self title .!

viewAddSite
	| e |
	self	title: 'Web sites'.
	e := WebElement new.
	e addTextH1: 'Adding a new web site'. e addBreak. 
	e add: self addSiteElement.
	^self style pageFrameWith: e title: self title .!

viewForgoten
	| e f |
	self title: 'Lost Password'.
	e := WebElement new.
	e addTextH1: 'Lost Password'.
	e addText: ' Enter your username below, click Send me my password, and your password 
	will be mailed to you if you gave a valid email address when you registered. If this will not 
	work for you (for example, if you forgot your member name or didn''t enter your email address) 
	send an email to '. 
	e addLinkTo: 'info@eranova.si' text: 'Portal Administrator'.
	f := WebFieldSet newLegend: 'User details'.
	f cell addText: 'My username is: '.
	f newCell add: (WebInputField new aspect: #username for: self).
	f newRow. f newCell addButtonText: 'Send me my password'. 
	e add: f.
 	^self style pageFrameWith: e title: self title .!

viewLogin
	| e l |

	self preloginCheck ifFalse: [^self viewLoginSecondary].  "if some error etc."
	self title: self style loginTitle.
	e := WebElement new.
"	e scriptBefore: 'Element.hide(''', self searchButton id, ''')'." "remove search button on navbar!!"
	e addText: self style loginWelcomeMessage. 
	l := (WebFieldSet newId: #login) legend: self style loginText.
	self inError ifTrue: 
		[l cell colspan: 2; addText: self style loginErrorText. self error: nil.
		l newRow. l cell addNbSp. l newRow].
	l cell addText: self style usernameText. 
	l newCell add: (WebInputField new aspect: #username for: self;
		focus). "let text cursor be there at the start!! "
	l newRow. l cell addText: self style passwordText. 
	l newCell add: (WebInputField new type: #password; aspect: #password for: self).
	l newRow. l newCell addButtonText: self style loginButton.
	e add: l.
	e addText: self style loginBelowMessage.
" 
	e newRow. e newCell addGif: #bulletSquareLeftWhiteGif ; 
		addLinkTo: self observee text: ' Forgot your password ?' view: 'forgoten'.
	e newRow. e newCell addGif: #bulletSquareLeftWhiteGif ; 
		addLinkTo: self observee text: ' New user ?' view: 'registration'.
"
 	^self style pageFrameWith: e title: self title .!

viewLoginSecondary
	"this one is called if preloginCheck returns false. Usefull for prelogin error reporting etc.
	Byy thefault it returns error report in red. Override that by your wishes"
	| e |
	self title: self style loginTitle.
	e := WebElement new.
	self error: self style loginErrorTextSecondary.
	e add: self errorReport.
 	^self style pageFrameWith: e title: self title .!

viewLogout
	self reportLogout.
	self session logout.
	self username: ''. self password: ''.
	self site securityManager hasFormAuthenticationScheme ifTrue: [^self redirectToView: #login].
	self site securityManager hasHttpAuthenticationScheme ifTrue: [^self redirectTo: '/'].!

viewMain
	| element |
	self	title: 'Admin'.
	element := WebElement new.
	^self style pageFrameWith: element title: self title .!

viewPasswordSent
	| e |
	self title: 'Lost Password sent'.
	e := WebElement new.
	e addTextH1: 'Password sent'.
	e addText: ' Your password was sent to email address from your user profile. If you have 
      any more troble, please send an email to '. 
	e addLinkTo: 'info@eranova.si' text: 'Portal Administrator'.
 	^self style pageFrameWith: e title: self title .!

viewRedirect
	| e url |
	self title: 'Restarting a site'.
	e := WebElement new.
	e addText: 'Restarting a site with new settings ...'.
	url := 'http://', self observee host, ':', self observee port printString, '/admin.html?view=settings'.
" this don't work on mozilla!!
	self redirectAfter: 2 toUrl: url.
"
self script: ('<SCRIPT LANGUAGE="JavaScript">
<!!-- Begin
redirTime = "2000";
redirURL = "', url, '";
function redirTimer() { self.setTimeout("self.location.href = redirURL;",redirTime); }
//  End -->
</script>').

	self attributesAt: #onLoad put: 'redirTimer()'.
	^self style pageFrameWith: e title: self title .!

viewRegistration
	| e f |
	self inError ifFalse: [self newUser: WebUser new. self password: ''].
	self title: 'Registration Form'.
	e := WebElement new.
	e addTextH1: 'Registration Form'.
	e addErrorReport.
	f := WebFieldSet newLegend: 'Personal details'.
	f cell addText: 'Name: '. f newCell addInputFieldAspect: #name for: self newUser. f newRow.
	f cell addText: 'Surname: '. f newCell addInputFieldAspect: #surname for: self newUser. f newRow.
	f cell addText: 'E-mail: '. f newCell addInputFieldAspect: #email for: self newUser. f newRow.
	f cell addText: 'Username: '. f newCell addInputFieldAspect: #username for: self newUser.
	f newRow.
	f cell addText: 'Password: '. f newCell addPasswordFieldAspect: #password for: self. f newRow.
	f cell addText: 'Confirm Password: '. f newCell addPasswordFieldAspect: #password for: self newUser.
	f newRow. f newCell addButtonText: 'Register'. 
	e add: f.
 	^self style pageFrameWith: e title: self title .!

viewServerRuns
	| e inx runs |
	self site setLastTimeAliveTimestamp.
	self	title: 'Runs for site: ', self site name.
	e := WebElement new.
	e table width: self style pageContentWidth. e cell color: #yellow.
	e cell colspan: 6; addText: self title header: 3. e newRow color: #thistle.
	e cell align: #center; addText: 'nr '.
	e newCell align: #center; addText: 'started '. e newCell align: #center; addText: 'last time alive '.
	e newCell align: #center; addText: 'uptime'. e newCell align: #center; addText: 'downtime'.
	e newCell align: #center; addText: 'termination'. e newRow.
	inx := 1. runs := self site runningHistory.
	runs do: [:array |
		inx even ifTrue: [e row color: #silver].
		e cell align: #center; addText: inx printString.
		e newCell align: #right; addText: (array at: 1) printSloString.
		e newCell align: #right; addText: (array at: 2) printSloString.
		e newCell align: #right; addText: (self printSeconds: (array at: 3) ).
		e newCell align: #right; addText: (self printSeconds: (array at: 4) ).
		e newCell align: #center; addText: 
			(array == runs last ifTrue: ['running'] ifFalse: [(array at: 5) ifTrue: ['crashed'] ifFalse: ['normal']]).
		inx := inx + 1. e newRow].
	e cell colspan: 6; addRulerSize: 1.
	^self style pageFrameWith: e title: self title .!

viewServerStatistics
	| e |

	self site setLastTimeAliveTimestamp.
	self title: 'Statistics for site: ' , self site name.
	e := WebElement new.
	e table width: self style pageContentWidth.
	e cell color: #yellow.
	e cell colspan: 3; addText: self title header: 3. e newRow.
	e cell addText: 'created: '.
	e newCell align: #right; addText: self session site createdTimestamp printSloString. e newRow.
	e cell addText: 'started: '.
	e newCell align: #right; addText: self session site startedTimestamp printSloString.
	e newCell align: #right; addLinkTo: self observee text: 'History of runs' view: 'serverRuns'. e newRow.
	e cell colspan: 3; addRulerSize: 1. e newRow.
	e cell addText: 'uptime: '.
	e newCell align: #right; addText: (self printSeconds: self session site uptime) , ' h:m:s'. e newRow.
	e cell addText: 'total uptime: '.
	e newCell align: #right; addText: (self printSeconds: self session site totalUptime) , ' h:m:s'. 	e newRow.
	e cell addText: 'total downtime: '.
	e newCell align: #right; addText: (self printSeconds: self session site totalDowntime), ' h:m:s'. e newRow.
	e cell addText: 'availability [%]: '.
	e newCell align: #right; addText: self session site availability printDotString. e newRow.
	e cell colspan: 3; addRulerSize: 1. e newRow.
	e cell addText: 'today requests: '.
	e newCell align: #right; addText: (self session site requestsOnDate: SpDate today) printDotString. e newRow.
	e cell addText: 'yesterday requests: '.
	e newCell align: #right; addText: (self session site requestsOnDate: (SpDate today subtractDays: 1)) printDotString.
	e newRow. e cell addText: 'all requests: '.
	e newCell align: #right; addText: self session site totalRequests printDotString. e newRow.
	e cell colspan: 3; addRulerSize: 1.
	^self style pageFrameWith: e title: self title!

viewSettings
	| e |
	self	title: 'Settings for site: ', self site name.
	e := WebElement new.
	e table width: 500.
      e cell color: #yellow; addText: self title header: 3. e newRow.
	e cell add: (self settingsElementForm: false). e newRow.
	e cell addLinkTo: self observee text: '<b>Update settings</b>' view: #updateSettings.
	^self style pageFrameWith: e title: self title .!

viewSites
	| e |
	self	title: 'Web sites'.
	e := WebElement new.
	e addTextH1: 'Virtual web sites on Swazoo web server'. e addBreak. 
	e addButtonText: 'Add new web site'. e addBreak.
	e add: self sitesElement.
	^self style pageFrameWith: e title: self title .!

viewUpdateSettings
	| e |

	self	title: 'Update Settings for site: ', self site name.
	e := WebElement new.
	e table width: 500.
      e cell color: #yellow;  addText: self title header: 3. e newRow.
	e cell add: (self settingsElementForm: true). e newRow.
	e cell addButtonText: 'Update'.
	^self style pageFrameWith: e title: self title .!

viewWaitingConfirmation
	| e |
	self title: 'Waiting Confirmation'.
	e := WebElement new.
	e addTextH1: 'Waiting Confirmation'.
	e addText: 'And e-mail was sent to address you entered in a registration form. Please read it
	and click to the activation link to confirm that your e-mail is valid.
	If you have any problems send an email to '. 
	e addLinkTo: 'info@eranova.si' text: 'Portal Administrator'.
 	^self style pageFrameWith: e title: self title .!

viewWakeupRichEditor
	"to prefetch all JS libraries"
	"call that from background Ajax call"
	self context page addText: 'Just to prefetch all TinyMCE JavaScript libraries'; addBreak.
	self context page addRichEditorAspect: #dummy for: self!

viewWakeupScriptaculous
	"to prefetch all JS libraries"
	"call that from background Ajax call"
	self addText: 'Just to prefetch all Scriptaculous JavaScript libraries'; addBreak.
	self add: (WebAutocompleteField new)! !
!WebAdminApp categoriesFor: #actionAddSite!actions!public! !
!WebAdminApp categoriesFor: #actionForgoten!actions!public! !
!WebAdminApp categoriesFor: #actionLogin!actions!public! !
!WebAdminApp categoriesFor: #actionLoginLogin!actions!private! !
!WebAdminApp categoriesFor: #actionRegistration!actions!public! !
!WebAdminApp categoriesFor: #actionSites!actions!public! !
!WebAdminApp categoriesFor: #actionUpdateSettings!actions!public! !
!WebAdminApp categoriesFor: #addSiteElement!printing-elements!public! !
!WebAdminApp categoriesFor: #aidaDontCache!private! !
!WebAdminApp categoriesFor: #dummy!private! !
!WebAdminApp categoriesFor: #dummy:!private! !
!WebAdminApp categoriesFor: #findLoggingUser!actions!public! !
!WebAdminApp categoriesFor: #isRegistrationValid!public!testing! !
!WebAdminApp categoriesFor: #newSite!accessing!public! !
!WebAdminApp categoriesFor: #newSite:!accessing!public! !
!WebAdminApp categoriesFor: #newUser!accessing!public! !
!WebAdminApp categoriesFor: #newUser:!accessing!public! !
!WebAdminApp categoriesFor: #password!accessing!public! !
!WebAdminApp categoriesFor: #password:!accessing!public! !
!WebAdminApp categoriesFor: #preloginCheck!public!testing! !
!WebAdminApp categoriesFor: #prepareSettings!actions!public! !
!WebAdminApp categoriesFor: #printSeconds:!private! !
!WebAdminApp categoriesFor: #reportLogin!private! !
!WebAdminApp categoriesFor: #reportLogout!private! !
!WebAdminApp categoriesFor: #settingsElementForm:!printing-elements!public! !
!WebAdminApp categoriesFor: #sitesElement!printing-elements!public