| package |
package := Package name: 'Swazoo'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: 'D.9.116'.


package classNames
	add: #AuthenticationNonce;
	add: #AuthorizationField;
	add: #CompositeResource;
	add: #ContentDispositionField;
	add: #ContentLengthHeader;
	add: #ContentTypeField;
	add: #FileResponse;
	add: #GenericHeaderField;
	add: #HeaderField;
	add: #HTTPAuthenticationBasicChallenge;
	add: #HTTPAuthenticationChallenge;
	add: #HTTPAuthenticationDigestChallenge;
	add: #HTTPConnection;
	add: #HTTPDelete;
	add: #HTTPException;
	add: #HTTPGet;
	add: #HTTPHead;
	add: #HTTPMessage;
	add: #HTTPOptions;
	add: #HTTPPost;
	add: #HTTPPostDataArray;
	add: #HTTPPostDatum;
	add: #HTTPPut;
	add: #HTTPRequest;
	add: #HTTPResponse;
	add: #HTTPServer;
	add: #HTTPTrace;
	add: #LineStream;
	add: #MD5Digest;
	add: #MimeObject;
	add: #ServerRootComposite;
	add: #Site;
	add: #SiteIdentifier;
	add: #SpecificHeaderField;
	add: #SwazooResource;
	add: #SwazooServer;
	add: #SwazooSession;
	add: #SwazooStream;
	add: #SwazooURI;
	add: #URIIdentifier;
	add: #URIResolution;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: 'Swazoo-Platform';
	add: 'Swazoo-Platform-Dolphin';
	yourself).

package!

"Class Definitions"!

Object subclass: #AuthenticationNonce
	instanceVariableNames: 'timestamp secret'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HeaderField
	instanceVariableNames: 'value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPConnection
	instanceVariableNames: 'stream loop server socket lastResponse'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPMessage
	instanceVariableNames: 'parent headers'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPPostDataArray
	instanceVariableNames: 'underlyingCollection'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #HTTPServer
	instanceVariableNames: 'loop ip port connections sites socket'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #LineStream
	instanceVariableNames: 'stream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #MD5Digest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #MimeObject
	instanceVariableNames: 'contentType value'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooResource
	instanceVariableNames: 'enabled uriPattern parent'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooServer
	instanceVariableNames: 'sites servers'
	classVariableNames: 'Singleton'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooSession
	instanceVariableNames: 'timestamp id values'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooStream
	instanceVariableNames: 'socket readBuffer writeStream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooURI
	instanceVariableNames: 'protocol hostname port identifier queries'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #URIIdentifier
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #URIResolution
	instanceVariableNames: 'position request'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Error subclass: #HTTPException
	instanceVariableNames: 'response'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HeaderField subclass: #GenericHeaderField
	instanceVariableNames: 'name'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HeaderField subclass: #SpecificHeaderField
	instanceVariableNames: 'parameters'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #AuthorizationField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #ContentDispositionField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #ContentLengthHeader
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SpecificHeaderField subclass: #ContentTypeField
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPMessage subclass: #HTTPRequest
	instanceVariableNames: 'httpVersion peer timestamp ip environmentData uri resolution encrypted authenticated contents'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPMessage subclass: #HTTPResponse
	instanceVariableNames: 'code entity'
	classVariableNames: 'StatusCodes'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPDelete
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPGet
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPHead
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPOptions
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPPost
	instanceVariableNames: 'postData'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPPut
	instanceVariableNames: 'putData'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPRequest subclass: #HTTPTrace
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPResponse subclass: #FileResponse
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPResponse subclass: #HTTPAuthenticationChallenge
	instanceVariableNames: 'resource'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPAuthenticationChallenge subclass: #HTTPAuthenticationBasicChallenge
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPAuthenticationChallenge subclass: #HTTPAuthenticationDigestChallenge
	instanceVariableNames: 'nonce opaque'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
MimeObject subclass: #HTTPPostDatum
	instanceVariableNames: 'filename'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #CompositeResource
	instanceVariableNames: 'children'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
CompositeResource subclass: #ServerRootComposite
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
CompositeResource subclass: #Site
	instanceVariableNames: 'name serving'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
URIIdentifier subclass: #SiteIdentifier
	instanceVariableNames: 'ip port host'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

AuthenticationNonce guid: (GUID fromString: '{938E2BA1-2B69-4969-AF4D-6CE85F981DAD}')!
AuthenticationNonce comment: 'AuthenticationNonce is used for HTTP Digest Authentication, see rfc2617 3.2.1:

   nonce
     A server-specified data string which should be uniquely generated
     each time a 401 response is made. It is recommended that this
     string be base64 or hexadecimal data. Specifically, since the
     string is passed in the header lines as a quoted string, the
     double-quote character is not allowed.

     The contents of the nonce are implementation dependent. The quality
     of the implementation depends on a good choice. A nonce might, for
     example, be constructed as the base 64 encoding of

         time-stamp H(time-stamp ":" ETag ":" private-key)



Instance Variables:
	secret	<String>	 secret, just simple ''self hash''
	timestamp	<Timestamp>	timestamp used for generating that nounce'!
!AuthenticationNonce categoriesForClass!Unclassified! !
!AuthenticationNonce methodsFor!

hashed
	"md5 hashed nonce, see rfc2617 3.2.1"
	"AuthenticationNonce new hashed"
	^MD5Digest hash: (self timestamp printString, ':', self secret)!

initialize
	self setTimestamp.
	self setSecret!

sameAs: aHashedNonce
	"check if this nonce has same values as other one"
	^self hashed = aHashedNonce!

secret
	^secret!

setSecret
	secret := self hash printString!

setTimestamp
	timestamp := Timestamp now!

timestamp
	^timestamp! !
!AuthenticationNonce categoriesFor: #hashed!accessing!public! !
!AuthenticationNonce categoriesFor: #initialize!initialize-release!public! !
!AuthenticationNonce categoriesFor: #sameAs:!public!testing! !
!AuthenticationNonce categoriesFor: #secret!accessing!public! !
!AuthenticationNonce categoriesFor: #setSecret!private! !
!AuthenticationNonce categoriesFor: #setTimestamp!accessing!public! !
!AuthenticationNonce categoriesFor: #timestamp!accessing!public! !

!AuthenticationNonce class methodsFor!

new
	^super new initialize! !
!AuthenticationNonce class categoriesFor: #new!instance creation!public! !

HeaderField guid: (GUID fromString: '{7330BD1A-D381-4C83-930F-459E6B20ED7F}')!
HeaderField comment: ''!
!HeaderField categoriesForClass!Unclassified! !
!HeaderField methodsFor!

combine: aHeaderField 
	^self subclassResponsibility!

initialize!

isAuthorization
	^false!

isContentDisposition
	^false!

isContentType
	^false!

name
	^self subclassResponsibility!

value
	^value!

value: aString
	value := aString!

valueFrom: aString
	self value: aString!

values
	^self subclassResponsibility! !
!HeaderField categoriesFor: #combine:!accessing!public! !
!HeaderField categoriesFor: #initialize!private-initialize!public! !
!HeaderField categoriesFor: #isAuthorization!public!testing! !
!HeaderField categoriesFor: #isContentDisposition!public!testing! !
!HeaderField categoriesFor: #isContentType!public!testing! !
!HeaderField categoriesFor: #name!accessing!public! !
!HeaderField categoriesFor: #value!accessing!public! !
!HeaderField categoriesFor: #value:!accessing!public! !
!HeaderField categoriesFor: #valueFrom:!private-initialize!public! !
!HeaderField categoriesFor: #values!accessing!public! !

!HeaderField class methodsFor!

fromLine: aString 
	| rs headerName headerValue inst fieldClass nameUppercased |
	rs := aString readStream.
	headerName := (rs upTo: $:) trimBlanks. nameUppercased := headerName asUppercase.
	headerValue := rs upToEnd trimBlanks.
	fieldClass := SpecificHeaderField allSubclasses 
				detect: [:each | each fieldName = nameUppercased]
				ifNone: [nil].
	inst := fieldClass isNil 
				ifTrue: [GenericHeaderField new name: headerName]
				ifFalse: [fieldClass new].
	inst valueFrom: headerValue.
	^inst!

new
	^super new initialize! !
!HeaderField class categoriesFor: #fromLine:!instance creation!public! !
!HeaderField class categoriesFor: #new!instance creation!public! !

HTTPConnection guid: (GUID fromString: '{A4D107C5-0448-43AA-BAF5-78D4F3195176}')!
HTTPConnection comment: ''!
!HTTPConnection categoriesForClass!Unclassified! !
!HTTPConnection methodsFor!

close
	self stream close.
	self server removeConnection: self.
	self loop notNil ifTrue: [self loop terminate]!

getAndDispatchMessages
	| request response |
	request := self nextMessage.
	request
		peer: self stream socket remoteAddress; ip: self stream socket localAddress;
		parent: self; setTimestamp.
	response := [[self server answerTo: request] 
		on: HTTPException
		do: [:ex | ex response] ] "return exception response, see HTTPException comment"
			on: Error
			do: [:ex | 
				ex notify.
"				Transcript show: ex errorString; cr. 
				self nextPutError: HTTPResponse internalServerError.
				ex defaultAction. " "raise a notifier window"
				self close].
	self lastResponse: response. response parent: self.
	self nextPutResponse: response toRequest: request.
	"self close."!

handleError: anError 
	anError getSignal == HTTPException 
		ifTrue: [^self nextPutError: HTTPResponse notImplemented].
	anError originator == self stream ifTrue: [^self close].
	self nextPutError: HTTPResponse badRequest!

interact
	self loop: 
			([[[self getAndDispatchMessages] repeat] on: Error do: [:ex | self close]] 
					forkAt: Processor userBackgroundPriority)!

lastResponse
	"to pair with new request, for http digest authentication etc."
	^lastResponse!

lastResponse: aHTTPResponse
	lastResponse := aHTTPResponse!

loop
	^loop!

loop: aProcess
	loop := aProcess!

nextMessage
	| m |
	[m := HTTPRequest readFrom: self stream] 
		on: Error
		do: [:ex | ^self handleError: ex].
	(m httpVersion last = 1 and: [(m includesHeader: 'Host') not]) 
		ifTrue: [^self nextPutError: HTTPResponse badRequest].
	^m!

nextPutError: aResponse 
	aResponse informConnectionClose.
	aResponse writeTo: self stream.
	self stream flush.!

nextPutResponse: aMessage toRequest: aRequest 
	| shouldClose |
	shouldClose := aRequest wantsConnectionClose.
	shouldClose ifTrue: [aMessage informConnectionClose].
	aRequest isHead 
		ifTrue: [aMessage writeHeaderTo: self stream]
		ifFalse: [aMessage writeTo: self stream].
	self stream flush.
	shouldClose ifTrue: [self close].
	aMessage isRedirectLink ifTrue: [self close]. "otherwise browser does not redirect?!! "!

server
	^server!

server: aServer 
	server := aServer!

socket
	^socket!

socket: aSocket
	socket := aSocket!

stream
	^stream!

stream: aSwazooStream 
	stream := aSwazooStream! !
!HTTPConnection categoriesFor: #close!accessing!public! !
!HTTPConnection categoriesFor: #getAndDispatchMessages!private! !
!HTTPConnection categoriesFor: #handleError:!private! !
!HTTPConnection categoriesFor: #interact!accessing!public! !
!HTTPConnection categoriesFor: #lastResponse!private-accessing!public! !
!HTTPConnection categoriesFor: #lastResponse:!private-accessing!public! !
!HTTPConnection categoriesFor: #loop!private-accessing!public! !
!HTTPConnection categoriesFor: #loop:!private-accessing!public! !
!HTTPConnection categoriesFor: #nextMessage!private! !
!HTTPConnection categoriesFor: #nextPutError:!private! !
!HTTPConnection categoriesFor: #nextPutResponse:toRequest:!private! !
!HTTPConnection categoriesFor: #server!private-accessing!public! !
!HTTPConnection categoriesFor: #server:!private-accessing!public! !
!HTTPConnection categoriesFor: #socket!private-accessing!public! !
!HTTPConnection categoriesFor: #socket:!private-accessing!public! !
!HTTPConnection categoriesFor: #stream!private-accessing!public! !
!HTTPConnection categoriesFor: #stream:!private-accessing!public! !

!HTTPConnection class methodsFor!

socket: aSocket 
	^self new stream: (SwazooStream socket: aSocket)! !
!HTTPConnection class categoriesFor: #socket:!instance creation!public! !

HTTPMessage guid: (GUID fromString: '{D1A6F6EB-7E6F-4BDA-AC86-7AE7A0206DB3}')!
HTTPMessage comment: ''!
!HTTPMessage categoriesForClass!Unclassified! !
!HTTPMessage methodsFor!

addHeader: aHeader 
	"HTTPSpec1.1 Sec4.2
Multiple message-header fields with the same field-name MAY be present in a message if and only if the entire field-value for that header field is defined as a comma-separated list [i.e., #(values)]. It MUST be possible to combine the multiple header fields into one 'field-name: field-value' pair, without changing the semantics of the message, by appending each subsequent field-value to the first, each separated by a comma. The order in which header fields with the same field-name are received is therefore significant to the interpretation of the combined field value, and thus a proxy MUST NOT change the order of these field values when a message is forwarded. "

	(self includesHeader: aHeader name) 
		ifTrue: [(self headerAt: aHeader name) combine: aHeader]
		ifFalse: [self headerAt: aHeader name put: aHeader].
	^aHeader!

addHeaderName: aName value: aValue 
	^self addHeader: (GenericHeaderField name: aName value: aValue)!

headerAt: aKey 
	^self headerAt: aKey ifAbsent: [nil]!

headerAt: aKey ifAbsent: aBlock
	^self headers at: aKey asUppercase ifAbsent: aBlock!

headerAt: aKey ifPresent: aBlock 
	| header |
	header := self headers at: aKey ifAbsent: [^nil].
	^aBlock value: header!

headerAt: aKey put: anObject 
	self headers at: aKey asUppercase put: anObject!

headers
	^headers!

headerValueOrNil: aFieldName 
	^(self headerAt: aFieldName ifAbsent: [^nil]) value!

headerValuesAt: aString 
	^(self headerAt: aString ifAbsent: [^#()]) values!

includesHeader: aKey 
	^self headers includesKey: aKey asUppercase!

initHeaders
	headers := Dictionary new!

initialize
	self initHeaders!

parent
	^parent!

parent: aConnection
	parent := aConnection!

printHeaders
	| stream |
	stream := WriteStream on: String new.
	self headers keysAndValuesDo: [:key :header |
                    stream
                        nextPutAll: header name;
                        nextPutAll: ': ';
                        display: header value;
                        cr].
	^stream contents! !
!HTTPMessage categoriesFor: #addHeader:!accessing-headers!public! !
!HTTPMessage categoriesFor: #addHeaderName:value:!accessing-headers!public! !
!HTTPMessage categoriesFor: #headerAt:!accessing-headers!public! !
!HTTPMessage categoriesFor: #headerAt:ifAbsent:!accessing-headers!public! !
!HTTPMessage categoriesFor: #headerAt:ifPresent:!accessing-headers!public! !
!HTTPMessage categoriesFor: #headerAt:put:!accessing-headers!public! !
!HTTPMessage categoriesFor: #headers!private-initialize!public! !
!HTTPMessage categoriesFor: #headerValueOrNil:!accessing-headers!public! !
!HTTPMessage categoriesFor: #headerValuesAt:!accessing-headers!public! !
!HTTPMessage categoriesFor: #includesHeader:!accessing-headers!public! !
!HTTPMessage categoriesFor: #initHeaders!private-initialize!public! !
!HTTPMessage categoriesFor: #initialize!private-initialize!public! !
!HTTPMessage categoriesFor: #parent!accessing!public! !
!HTTPMessage categoriesFor: #parent:!accessing!public! !
!HTTPMessage categoriesFor: #printHeaders!printing!public! !

!HTTPMessage class methodsFor!

new
	^super new initialize! !
!HTTPMessage class categoriesFor: #new!instance creation!public! !

HTTPPostDataArray guid: (GUID fromString: '{8EA5B317-D834-4553-BA26-A645887C3918}')!
HTTPPostDataArray comment: 'Introduced the HTTPPostDataArray to hold post data in an HTTPRequest in place of a Dictionary.  This is because it is legal for there to be more than one entry with the same name (key) and using a Dictionary  looses data (!!).

Instance Variables:
	underlyingCollection	<>'!
!HTTPPostDataArray categoriesForClass!Unclassified! !
!HTTPPostDataArray methodsFor!

allAt: aKey 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates collect: [:anAssociation| anAssociation value]!

allNamesForValue: aString 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation value value = aString].
	^candidates collect: [:anAssociation| anAssociation key]!

associations
	^self underlyingCollection!

at: aKey 
	^(self allAt: aKey) last!

at: aKey ifAbsent: aBlock 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates isEmpty ifTrue: [aBlock value] ifFalse: [candidates last value]!

at: key put: anObject 
	self underlyingCollection add: (Association key: key value: anObject).
	^anObject!

includesKey: aKey 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation key = aKey].
	^candidates notEmpty!

includesValue: aString 
	| candidates |
	candidates := self underlyingCollection 
				select: [:anAssociation | anAssociation value value = aString].
	^candidates notEmpty!

isEmpty
	^self underlyingCollection isEmpty!

keys
"^a Set
I mimick the behavior of a Dictionay which I replace.  I return a set of the keys in my underlying collection of associations."

	^(self underlyingCollection collect: [:anAssociation| anAssociation key]) asSet!

keysAndValuesDo: aTwoArgumentBlock 
	self underlyingCollection do: 
		[:anAssociation | aTwoArgumentBlock value: anAssociation key value: anAssociation value]!

nameForValue: aString
	^(self allNamesForValue: aString) last!

select: aBlock 
"^an Object
I run the select on the values of the associations in my underlying collection.  This mimicks the behavior when a Dictionary was used in my place."
	^self underlyingCollection select:  [:anAssociation| aBlock value: anAssociation value]!

underlyingCollection
	underlyingCollection isNil 
		ifTrue: [underlyingCollection := OrderedCollection new].
	^underlyingCollection! !
!HTTPPostDataArray categoriesFor: #allAt:!accessing!public! !
!HTTPPostDataArray categoriesFor: #allNamesForValue:!accessing!public! !
!HTTPPostDataArray categoriesFor: #associations!accessing!public! !
!HTTPPostDataArray categoriesFor: #at:!accessing!public! !
!HTTPPostDataArray categoriesFor: #at:ifAbsent:!accessing!public! !
!HTTPPostDataArray categoriesFor: #at:put:!accessing!public! !
!HTTPPostDataArray categoriesFor: #includesKey:!accessing!public! !
!HTTPPostDataArray categoriesFor: #includesValue:!accessing!public! !
!HTTPPostDataArray categoriesFor: #isEmpty!public!testing! !
!HTTPPostDataArray categoriesFor: #keys!accessing!public! !
!HTTPPostDataArray categoriesFor: #keysAndValuesDo:!enumerating!public! !
!HTTPPostDataArray categoriesFor: #nameForValue:!accessing!public! !
!HTTPPostDataArray categoriesFor: #select:!enumerating!public! !
!HTTPPostDataArray categoriesFor: #underlyingCollection!private! !

HTTPServer guid: (GUID fromString: '{168D42A9-4AF0-45B2-A07B-5EDEF07D73B5}')!
HTTPServer comment: ''!
!HTTPServer categoriesForClass!Unclassified! !
!HTTPServer methodsFor!

acceptConnection
	| conn |
	conn := [HTTPConnection socket: self socket accept] on: Error
				do: 
					[:ex | 
					Transcript
						show: 'Socket accept error: ';
						show: ex errorString;
						cr.
					^self].
	self addConnection: conn.
	conn interact!

addConnection: aConnection 
	self connections add: aConnection.
	aConnection server: self!

addSite: aSite
	(self sites includesResource: aSite) ifFalse: [^self sites addResource: aSite]!

answerTo: aRequest 
	| response |
	response := URIResolution resolveRequest: aRequest startingAt: self sites.
	^response isNil
		ifTrue: [HTTPResponse notFound]
		ifFalse: [response]!

connections
	^connections!

hasNoSites
	^self sites hasNoResources!

initConnections
	connections := OrderedCollection new.!

initialize
	self initConnections.
	self initSites!

initSites
	sites := ServerRootComposite new!

ip
	^ip!

ip: anIPString 
	ip := anIPString!

isServing
	^self loop notNil!

loop
	^loop!

loop: aProcess
	loop := aProcess!

port
	^port!

port: aNumber
	port := aNumber!

removeConnection: aConnection 
	self connections remove: aConnection ifAbsent: [nil]!

removeSite: aSite 
	^self sites removeResource: aSite!

sites
	^sites!

socket
	^socket!

socket: aSocket
	socket := aSocket!

start
	self loop isNil 
		ifTrue: 
			[self socket: (SwazooSocket serverOnIP: self ip port: self port).
			self socket listenFor: 50.
			self loop: ([[self acceptConnection] repeat] 
						forkAt: Processor userBackgroundPriority)]!

stop
	self loop isNil 
		ifFalse: 
			[self connections copy do: [:each | each close].
			self loop terminate.
			self loop: nil.
			self socket close.
			self socket: nil]! !
!HTTPServer categoriesFor: #acceptConnection!private! !
!HTTPServer categoriesFor: #addConnection:!private! !
!HTTPServer categoriesFor: #addSite:!public!resources! !
!HTTPServer categoriesFor: #answerTo:!public!serving! !
!HTTPServer categoriesFor: #connections!private! !
!HTTPServer categoriesFor: #hasNoSites!public!resources! !
!HTTPServer categoriesFor: #initConnections!private-initialize!public! !
!HTTPServer categoriesFor: #initialize!private-initialize!public! !
!HTTPServer categoriesFor: #initSites!private-initialize!public! !
!HTTPServer categoriesFor: #ip!private-initialize!public! !
!HTTPServer categoriesFor: #ip:!private-initialize!public! !
!HTTPServer categoriesFor: #isServing!public!testing! !
!HTTPServer categoriesFor: #loop!private! !
!HTTPServer categoriesFor: #loop:!private! !
!HTTPServer categoriesFor: #port!private-initialize!public! !
!HTTPServer categoriesFor: #port:!private-initialize!public! !
!HTTPServer categoriesFor: #removeConnection:!private! !
!HTTPServer categoriesFor: #removeSite:!public!resources! !
!HTTPServer categoriesFor: #sites!private! !
!HTTPServer categoriesFor: #socket!private! !
!HTTPServer categoriesFor: #socket:!private! !
!HTTPServer categoriesFor: #start!public! !
!HTTPServer categoriesFor: #stop!public!start/stop! !

!HTTPServer class methodsFor!

connectToObjectMemory
	#spmTodo.
	"ObjectMemory addDependent: self."!

disconnectFromObjectMemory
	#spmTodo.
	"ObjectMemory removeDependent: self."!

initialize
	self connectToObjectMemory!

new
	^super new initialize!

shutDown 
	self allInstances do: [:each | each stop].
	self disconnectFromObjectMemory.!

update: aspect with: aParameter from: sender 	
	#spmTodo. "Fix"
	"((sender == ObjectMemory) and: [aspect == #aboutToSnapshot]) 
		ifTrue: [self shutDown]"!

version
	^'Swazoo 0.9 (Columbus)'! !
!HTTPServer class categoriesFor: #connectToObjectMemory!public! !
!HTTPServer class categoriesFor: #disconnectFromObjectMemory!public! !
!HTTPServer class categoriesFor: #initialize!intialize-release!public! !
!HTTPServer class categoriesFor: #new!instance creation!public! !
!HTTPServer class categoriesFor: #shutDown!intialize-release!public! !
!HTTPServer class categoriesFor: #update:with:from:!intialize-release!public! !
!HTTPServer class categoriesFor: #version!accessing!public! !

LineStream guid: (GUID fromString: '{9E58D0F2-8EC9-4B3F-B1AE-ECB4E094C8FA}')!
LineStream comment: ''!
!LineStream categoriesForClass!Unclassified! !
!LineStream methodsFor!

nextLine
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: (self stream upTo: Character cr).
	^self stream peek = Character lf 
		ifTrue: 
			[self stream next.
			ws contents]
		ifFalse: [self error: 'CR without LF']!

stream
	^stream!

stream: aStream
	stream := aStream! !
!LineStream categoriesFor: #nextLine!accessing!public! !
!LineStream categoriesFor: #stream!private-initialize!public! !
!LineStream categoriesFor: #stream:!private-initialize!public! !

!LineStream class methodsFor!

on: aStream 
	^self new stream: aStream! !
!LineStream class categoriesFor: #on:!instance creation!public! !

MD5Digest guid: (GUID fromString: '{C95F5741-9AAE-4D9E-963B-D035E130A866}')!
MD5Digest comment: 'MD5Digest is used for MD5 hashing and preparing digests for HTTP Digest Authentication according to rfc2617.'!
!MD5Digest categoriesForClass!Unclassified! !
!MD5Digest class methodsFor!

a1FromUsername: aUsername realm: aRealm password: aPassword
	"rfc2617 3.2.2.2 , algorithm directive unspecified	
	A1= unq(username-value) : unq(realm-value) : passwd"
	^aUsername trimBlanks, ':', aRealm trimBlanks, ':', aPassword trimBlanks!

a2FromMethod: aMethod digestUri: anUri
	"rfc2617 3.2.2.3 , qop directive unspecified	
	A2  = Method : digest-uri-value"
	^aMethod trimBlanks, ':', anUri trimBlanks!

hash: aString
	"return a 128bit digest as 32 char hex string, see rfc2617 3.1.3 "
	"MD5Digest hash: '1234' "
	^SwazooPlatform current md5Hash: aString asByteArray!

requestDigestFromMethod: aMethod uri: anUri nonce: aNonce username: aUsername realm: aRealm password: aPassword
	"rfc2617 3.2.2.1 , qop directive not present	
	request-digest  =  KD ( H(A1), unq(nonce-value) : H(A2) )"
	| a1 a2 |
	a1 := self a1FromUsername: aUsername realm: aRealm password: aPassword.
	a2 := self a2FromMethod: aMethod digestUri: anUri.
 	^self hash: ((self hash: a1), ':', aNonce trimBlanks, ':', (self hash: a2))

"MD5Digest requestDigestFromMethod: 'Digest'
	uri: 'http://www.nowhere.org/dir/index.html' nonce: 'dcd98b7102dd2f0e8b11d0f600bfb0c093'
	username: 'Musafa' realm: 'testrealm@host.com' password: 'Circle Of Life'
"! !
!MD5Digest class categoriesFor: #a1FromUsername:realm:password:!hashing for rfc2617!public! !
!MD5Digest class categoriesFor: #a2FromMethod:digestUri:!hashing for rfc2617!public! !
!MD5Digest class categoriesFor: #hash:!public! !
!MD5Digest class categoriesFor: #requestDigestFromMethod:uri:nonce:username:realm:password:!hashing for rfc2617!public! !

MimeObject guid: (GUID fromString: '{162E95B7-B492-4291-9DA4-7CCAF3F18F5B}')!
MimeObject comment: ''!
!MimeObject categoriesForClass!Unclassified! !
!MimeObject methodsFor!

contentType
	^contentType isNil ifTrue: [self defaultContentType] ifFalse: [contentType]!

contentType: anObject
	contentType := anObject!

defaultContentType
	^'application/octet-stream'!

value
	^value!

value: anObject
	value := anObject! !
!MimeObject categoriesFor: #contentType!accessing!public! !
!MimeObject categoriesFor: #contentType:!accessing!public! !
!MimeObject categoriesFor: #defaultContentType!private-accessing!public! !
!MimeObject categoriesFor: #value!accessing!public! !
!MimeObject categoriesFor: #value:!accessing!public! !

SwazooResource guid: (GUID fromString: '{5D2C359D-D9AF-4740-8548-AC91B317E5CD}')!
SwazooResource comment: ''!
!SwazooResource categoriesForClass!Unclassified! !
!SwazooResource methodsFor!

answerTo: aRequest
	"override in your Resource and return a HTTPResponse"
	^nil!

authenticationRealm
	"rfc2617 3.2.1: A string to be displayed to users so they know which username and
     password to use. This string should contain at least the name of
     the host performing the authentication and might additionally
     indicate the collection of users who might have access. An example
     might be 'registered_users@gotham.news.com' "
	^'Swazoo server'!

authenticationScheme
	"#Basic or #Digest, see rfc2617. Digest is recomended because password
	goes encrypted to server"
	^#Digest!

canAnswer
	^self isEnabled and: [self isValidlyConfigured]!

currentUrl
	| stream |
	stream := WriteStream on: String new.
	self printUrlOn: stream.
	^stream contents!

disable
	enabled := false!

enable
	enabled := true!

helpResolve: aResolution 
	^aResolution resolveLeafResource: self!

initialize
	self enable.
	self initUriPattern!

initUriPattern
	self uriPattern: ''!

isEnabled
	^enabled!

isValidlyConfigured
	^self uriPattern ~= ''!

match: anIdentifier 
	^self uriPattern match: anIdentifier!

onResourceCreated
	"Received after the resource has been added to its parent resource. Opportunity to perform initialization that depends on knowledge of the resource tree structure"!

parent
	^parent!

parent: aResource
	parent := aResource!

printUrlOn: aWriteStream 
	self parent printUrlOn: aWriteStream.
	aWriteStream nextPutAll: self uriPattern!

root
	^self parent isNil
		ifTrue: [self]
		ifFalse: [self parent root]!

start!

stop!

unauthorizedResponse
	"Resource should call this method and return its result immediately, if request is not authorized 
	to access that resource and a HTTP authorization is needed"
	^HTTPAuthenticationChallenge newForResource: self!

unauthorizedResponsePage
	"Resource should override this method with it's own html message"
	^'<HTML>
  <HEAD>
    <TITLE>Authentication error</TITLE>
  </HEAD>
  <BODY>
    <H1>401 Authentication error</H1>
    <P>Bad username or password</P>
  </BODY>
</HTML>'!

uriPattern
	^uriPattern!

uriPattern: anIdentifier 
	anIdentifier notNil ifTrue: [uriPattern := anIdentifier]! !
!SwazooResource categoriesFor: #answerTo:!public!serving! !
!SwazooResource categoriesFor: #authenticationRealm!authentication!public! !
!SwazooResource categoriesFor: #authenticationScheme!authentication!public! !
!SwazooResource categoriesFor: #canAnswer!public!testing! !
!SwazooResource categoriesFor: #currentUrl!accessing!public! !
!SwazooResource categoriesFor: #disable!public!start/stop! !
!SwazooResource categoriesFor: #enable!public!start/stop! !
!SwazooResource categoriesFor: #helpResolve:!accessing!public! !
!SwazooResource categoriesFor: #initialize!private-initialize!public! !
!SwazooResource categoriesFor: #initUriPattern!private-initialize!public! !
!SwazooResource categoriesFor: #isEnabled!public!testing! !
!SwazooResource categoriesFor: #isValidlyConfigured!public!testing! !
!SwazooResource categoriesFor: #match:!private! !
!SwazooResource categoriesFor: #onResourceCreated!event handling!public! !
!SwazooResource categoriesFor: #parent!accessing!public! !
!SwazooResource categoriesFor: #parent:!private! !
!SwazooResource categoriesFor: #printUrlOn:!accessing!public! !
!SwazooResource categoriesFor: #root!accessing!public! !
!SwazooResource categoriesFor: #start!public!start/stop! !
!SwazooResource categoriesFor: #stop!public!start/stop! !
!SwazooResource categoriesFor: #unauthorizedResponse!public! !
!SwazooResource categoriesFor: #unauthorizedResponsePage!authentication!public! !
!SwazooResource categoriesFor: #uriPattern!accessing!public! !
!SwazooResource categoriesFor: #uriPattern:!accessing!public! !

!SwazooResource class methodsFor!

new
	^super new initialize!

uriPattern: aString 
	^self new uriPattern: aString! !
!SwazooResource class categoriesFor: #new!instance creation!public! !
!SwazooResource class categoriesFor: #uriPattern:!instance creation!public! !

SwazooServer guid: (GUID fromString: '{8C99591E-3AA7-4E1C-806D-0A8C13EB3909}')!
SwazooServer comment: ''!
!SwazooServer categoriesForClass!Unclassified! !
!SwazooServer methodsFor!

addServer: aHTTPServer
	self servers add: aHTTPServer!

addSite: aSite
	(self siteNamed: aSite name) notNil 
		ifTrue: [^self error: 'Site with that name already exist!!'].
	(self siteHostnamed: aSite host) notNil 
		ifTrue: [^self error: 'Site with that hostname already exist!!'].
	self sites add: aSite!

allSites
	^self sites copy!

initialize
	self removeAllSites.!

initServers
	servers := Set new.!

initSites
	sites := OrderedCollection new.!

newServerFor: aSiteIdentifier
	^ aSiteIdentifier newServer.!

removeAllSites
	self sites copy do: [:each | self removeSite: each]!

removeServer: aHTTPServer
	self servers remove: aHTTPServer!

removeSite: aSite 
	aSite stop.
	self sites remove: aSite!

serverFor: aSiteIdentifier 
	^self servers detect: [:each | (each ip = aSiteIdentifier ip) & (each port = aSiteIdentifier port)]
		ifNone: [self newServerFor: aSiteIdentifier]!

servers
	servers isNil ifTrue: [self initServers].
	^servers!

siteHostnamed: aString
	"find a site with that hostname"
	| string |
	string := aString isNil ifTrue: [''] ifFalse: [aString asLowercase].
	^self sites detect: [:each | each host asLowercase = string] ifNone: [nil].!

siteNamed: aString
	"find a site with that short name"
	| string |
	string := aString isNil ifTrue: [''] ifFalse: [aString asLowercase].
	^self sites detect: [:each | each name asLowercase = string] ifNone: [nil].!

sites
	sites isNil ifTrue: [self initSites].
	^sites!

start
	self sites do: [:site | site start]!

startSite: aString
	"start site with that name"
	| site |
	site := self siteNamed: aString.
	site notNil ifTrue: [site start].!

stop
	self sites do: [:site | site stop]!

stopSite: aString
	"start site with that name"
	| site |
	site := self siteNamed: aString.
	site notNil ifTrue: [site stop].! !
!SwazooServer categoriesFor: #addServer:!private-servers!public! !
!SwazooServer categoriesFor: #addSite:!public!sites! !
!SwazooServer categoriesFor: #allSites!public!sites! !
!SwazooServer categoriesFor: #initialize!private-initialize!public! !
!SwazooServer categoriesFor: #initServers!private-initialize!public! !
!SwazooServer categoriesFor: #initSites!private-initialize!public! !
!SwazooServer categoriesFor: #newServerFor:!private-servers!public! !
!SwazooServer categoriesFor: #removeAllSites!public!sites! !
!SwazooServer categoriesFor: #removeServer:!private-servers!public! !
!SwazooServer categoriesFor: #removeSite:!public!sites! !
!SwazooServer categoriesFor: #serverFor:!private-servers!public! !
!SwazooServer categoriesFor: #servers!private! !
!SwazooServer categoriesFor: #siteHostnamed:!public!sites! !
!SwazooServer categoriesFor: #siteNamed:!public!sites! !
!SwazooServer categoriesFor: #sites!private! !
!SwazooServer categoriesFor: #start!public!start/stop! !
!SwazooServer categoriesFor: #startSite:!public!start/stop! !
!SwazooServer categoriesFor: #stop!public!start/stop! !
!SwazooServer categoriesFor: #stopSite:!public!start/stop! !

!SwazooServer class methodsFor!

configureFrom: aFilename 
	self configureFromStream: aFilename asFilename readStream.!

configureFromStream: aStream 
	| sites |
	self singleton removeAllSites.
	[sites := self readSitesFrom: aStream] ensure: [aStream close].
	sites do: [:each | 
		self singleton addSite: each.
		each start]!

flush
	"self flush"

	Singleton isNil 
		ifFalse: 
			[Singleton removeAllSites.
			Singleton := nil]!

initialize!

initSingleton
	Singleton := super new initialize.!

isPersistent
	^false!

new
	^self shouldNotImplement!

readSitesFrom: aStream 
	| sites inst |
	sites := OrderedCollection new.
	
	[inst := Site new readFrom: aStream.
	inst notNil] 
			whileTrue: [sites add: inst].
	^sites!

singleton
	Singleton isNil ifTrue: [self initSingleton].
	^Singleton!

siteHostnamed: aString
	^self singleton siteHostnamed: aString!

siteNamed: aString
	^self singleton siteNamed: aString!

start
	"start all sites"
	self singleton start!

startSite: aString
	"start site with that name"
	self singleton startSite: aString!

stop
	"stop all sites"
	self singleton stop!

stopSite: aString
	"stop site with that name"
	self singleton stopSite: aString! !
!SwazooServer class categoriesFor: #configureFrom:!configuration!public! !
!SwazooServer class categoriesFor: #configureFromStream:!configuration!public! !
!SwazooServer class categoriesFor: #flush!public! !
!SwazooServer class categoriesFor: #initialize!initialize!public! !
!SwazooServer class categoriesFor: #initSingleton!public! !
!SwazooServer class categoriesFor: #isPersistent!odb testing!public! !
!SwazooServer class categoriesFor: #new!private! !
!SwazooServer class categoriesFor: #readSitesFrom:!private! !
!SwazooServer class categoriesFor: #singleton!public! !
!SwazooServer class categoriesFor: #siteHostnamed:!accessing!public! !
!SwazooServer class categoriesFor: #siteNamed:!accessing!public! !
!SwazooServer class categoriesFor: #start!public!start/stop! !
!SwazooServer class categoriesFor: #startSite:!public!start/stop! !
!SwazooServer class categoriesFor: #stop!public!start/stop! !
!SwazooServer class categoriesFor: #stopSite:!public!start/stop! !

SwazooSession guid: (GUID fromString: '{981ED1CB-6A08-4FD7-8BCB-7B1C9EE875AD}')!
SwazooSession comment: ''!
!SwazooSession categoriesForClass!Unclassified! !
!SwazooSession methodsFor!

at: anObject 
	^self at: anObject ifAbsent: [nil]!

at: anObject ifAbsent: aBlock 
	^self values at: anObject ifAbsent: aBlock!

at: anObject ifAbsentPut: aBlock 
	(self values includesKey: anObject) 
		ifFalse: [self values at: anObject put: aBlock value].
	^self values at: anObject!

at: aKey put: anObject 
	self values at: aKey put: anObject!

id
	^id!

id: anObject
	id := anObject!

includesKey: aKey 
	^self values includesKey: aKey!

initialize
	self initValues.
	self touch!

initValues
	values := Dictionary new!

removeKey: aKey 
	self values removeKey: aKey ifAbsent: []!

setTimestamp
	timestamp := Timestamp now!

timestamp
	^timestamp!

touch
	self setTimestamp!

values
	^values! !
!SwazooSession categoriesFor: #at:!accessing!public! !
!SwazooSession categoriesFor: #at:ifAbsent:!accessing!public! !
!SwazooSession categoriesFor: #at:ifAbsentPut:!accessing!public! !
!SwazooSession categoriesFor: #at:put:!accessing!public! !
!SwazooSession categoriesFor: #id!accessing!public! !
!SwazooSession categoriesFor: #id:!accessing!public! !
!SwazooSession categoriesFor: #includesKey:!accessing!public! !
!SwazooSession categoriesFor: #initialize!private-initialize!public! !
!SwazooSession categoriesFor: #initValues!private-initialize!public! !
!SwazooSession categoriesFor: #removeKey:!accessing!public! !
!SwazooSession categoriesFor: #setTimestamp!public! !
!SwazooSession categoriesFor: #timestamp!accessing!public! !
!SwazooSession categoriesFor: #touch!accessing!public! !
!SwazooSession categoriesFor: #values!private-initialize!public! !

!SwazooSession class methodsFor!

new
	^super new initialize! !
!SwazooSession class categoriesFor: #new!instance creation!public! !

SwazooStream guid: (GUID fromString: '{8281B147-EFE0-44D0-8816-6D9268EDA1DC}')!
SwazooStream comment: ''!
!SwazooStream categoriesForClass!Unclassified! !
!SwazooStream methodsFor!

atEnd
	^false!

close
	self socket close!

cr
	self nextPut: Character cr!

fillBuffer
	self readBuffer: (ReadStream on: (self socket read: 1024) ).
	self readBuffer atEnd 
		ifTrue: [self error: 'No data available.  Socket probably closed']!

flush
	"actually write to the tcp socket"
	| contents remaining |
	contents := self writeStream contents.
	remaining := contents size.
	[remaining > 0] whileTrue: [| written |
		written := self socket 
			write: (contents copyFrom: contents size - remaining + 1 to: contents size).
		remaining := remaining - written].
	self initWriteStream.!

initWriteStream
	"temporary stream. flush it to socket ocassionaly!!"
	writeStream := WriteStream on: (ByteArray new: 1000)!

next
	^(self next: 1) first!

next: anInteger 
	^(self nextBytes: anInteger) asString!

nextByte
	^(self nextBytes: 1) first!

nextBytes: anInteger 
	| ws count |
	ws := WriteStream on: ByteArray new.
	count := 0.
	[count < anInteger] whileTrue: 
			[self syncBuffer.
			ws nextPut: self readBuffer next.
			count := count + 1].
	^ws contents!

nextPut: aCharacter 
	self nextPutAll: (String with: aCharacter).
	^aCharacter!

nextPutAll: aString 
	self nextPutBytes: aString asByteArray.
	^aString!

nextPutByte: aByte 
	self nextPutBytes: (ByteArray with: aByte).
	^aByte!

nextPutBytes: aByteArray 
	self writeStream nextPutAll: aByteArray.
	^aByteArray!

peek
	^self peekByte asCharacter!

peekByte
	self syncBuffer.
	^self readBuffer peek!

print: anObject 
	self nextPutAll: anObject printString!

readBuffer
	^readBuffer!

readBuffer: aStream
	readBuffer := aStream!

setSocket: aSwazooSocket 
	self socket: aSwazooSocket.
	self readBuffer: (ReadStream on: ByteArray new)!

socket
	^socket!

socket: aSocket
	socket := aSocket!

space
	self nextPut: Character space!

syncBuffer
	self readBuffer atEnd ifTrue: [self fillBuffer]!

upTo: aCharacter 
	| ws char |
	ws := String new writeStream.
	
	[char := self next.
	char = aCharacter] whileFalse: [ws nextPut: char].
	^ws contents!

writeStream
	writeStream isNil ifTrue: [self initWriteStream].
	^writeStream! !
!SwazooStream categoriesFor: #atEnd!accessing!public! !
!SwazooStream categoriesFor: #close!accessing!public! !
!SwazooStream categoriesFor: #cr!accessing!public! !
!SwazooStream categoriesFor: #fillBuffer!private! !
!SwazooStream categoriesFor: #flush!accessing!public! !
!SwazooStream categoriesFor: #initWriteStream!private-initialize!public! !
!SwazooStream categoriesFor: #next!accessing!public! !
!SwazooStream categoriesFor: #next:!accessing!public! !
!SwazooStream categoriesFor: #nextByte!accessing-bytes!public! !
!SwazooStream categoriesFor: #nextBytes:!accessing-bytes!public! !
!SwazooStream categoriesFor: #nextPut:!accessing!public! !
!SwazooStream categoriesFor: #nextPutAll:!accessing!public! !
!SwazooStream categoriesFor: #nextPutByte:!accessing-bytes!public! !
!SwazooStream categoriesFor: #nextPutBytes:!accessing-bytes!public! !
!SwazooStream categoriesFor: #peek!accessing!public! !
!SwazooStream categoriesFor: #peekByte!accessing-bytes!public! !
!SwazooStream categoriesFor: #print:!accessing!public! !
!SwazooStream categoriesFor: #readBuffer!private! !
!SwazooStream categoriesFor: #readBuffer:!private! !
!SwazooStream categoriesFor: #setSocket:!private-initialize!public! !
!SwazooStream categoriesFor: #socket!accessing!public! !
!SwazooStream categoriesFor: #socket:!private! !
!SwazooStream categoriesFor: #space!accessing!public! !
!SwazooStream categoriesFor: #syncBuffer!private! !
!SwazooStream categoriesFor: #upTo:!accessing!public! !
!SwazooStream categoriesFor: #writeStream!private! !

!SwazooStream class methodsFor!

connectedPair
	^SwazooSocket connectedPair collect: [:each | self socket: each]!

socket: aSwazooSocket 
	^self new setSocket: aSwazooSocket! !
!SwazooStream class categoriesFor: #connectedPair!public! !
!SwazooStream class categoriesFor: #socket:!instance creation!public! !

SwazooURI guid: (GUID fromString: '{662D5798-FB90-4879-83E3-8CA6A55E4EE8}')!
SwazooURI comment: ''!
!SwazooURI categoriesForClass!Unclassified! !
!SwazooURI methodsFor!

defaultPort
	^80!

host
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: self hostname.
	self port = self defaultPort 
		ifFalse: 
			[ws
				nextPut: $:;
				print: self port].
	^ws contents!

host: aString 
	| rs |
	rs := ReadStream on: aString.
	self hostname: (rs upTo: $: ).
	rs atEnd ifFalse: [self port: rs upToEnd asNumber]!

hostname
	^hostname!

hostname: aHostname 
	hostname := aHostname!

identifier
	^identifier!

identifier: anObject
	identifier := anObject!

identifierPath
	| parts |
	parts := (SwazooPlatform current string: self identifier tokensBasedOn: $/)
		collect: [ :each | each httpDecoded ].
	(self identifier notEmpty and: [ self identifier first = $/ ]) ifTrue: [ parts addFirst: '/' ].
	^parts reject: [ :each | each isEmpty ]!

includesQuery: aString 
	^self queryData includesKey: aString!

initialize
	self port: self defaultPort!

isDirectory
	^self identifier last = $/!

port
	^port!

port: anInteger 
	port := anInteger!

protocol
	protocol isNil ifTrue: [self protocol: 'http'].
	^protocol!

protocol: aString
	protocol := aString.!

queries
	^queries!

queries: anObject
	queries := anObject!

queryAt: aString 
	^self queryAt: aString ifAbsent: [nil]!

queryAt: aString ifAbsent: aBlock 
	^self queryData at: aString ifAbsent: aBlock!

queryData
	| dict |
	" #sw. This was parsing ?ABC the same as ?ABC=ABC"
	dict := Dictionary new.
	(SwazooPlatform current string: self queries tokensBasedOn: $&)
		do:
			[ :keyVal | 
			| tok |
			tok := SwazooPlatform current string: keyVal tokensBasedOn: $=.
			dict at: tok first put: (tok size = 1 ifTrue: [ nil ] ifFalse: [ tok last httpDecoded ]) ].
	^dict!

value
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: self protocol, '://'.
	ws nextPutAll: self host.
	ws nextPutAll: self identifier.
	(self queries isNil or: [self queries isEmpty]) 
		ifFalse: 
			[ws
				nextPut: $?;
				nextPutAll: self queries].
	^ws contents! !
!SwazooURI categoriesFor: #defaultPort!private-accessing!public! !
!SwazooURI categoriesFor: #host!accessing!public! !
!SwazooURI categoriesFor: #host:!accessing!public! !
!SwazooURI categoriesFor: #hostname!accessing!public! !
!SwazooURI categoriesFor: #hostname:!accessing!public! !
!SwazooURI categoriesFor: #identifier!accessing!public! !
!SwazooURI categoriesFor: #identifier:!accessing!public! !
!SwazooURI categoriesFor: #identifierPath!accessing!public! !
!SwazooURI categoriesFor: #includesQuery:!accessing-queries!public! !
!SwazooURI categoriesFor: #initialize!private-initialize!public! !
!SwazooURI categoriesFor: #isDirectory!public!testing! !
!SwazooURI categoriesFor: #port!accessing!public! !
!SwazooURI categoriesFor: #port:!accessing!public! !
!SwazooURI categoriesFor: #protocol!accessing!public! !
!SwazooURI categoriesFor: #protocol:!accessing!public! !
!SwazooURI categoriesFor: #queries!accessing-queries!public! !
!SwazooURI categoriesFor: #queries:!accessing-queries!public! !
!SwazooURI categoriesFor: #queryAt:!accessing-queries!public! !
!SwazooURI categoriesFor: #queryAt:ifAbsent:!accessing-queries!public! !
!SwazooURI categoriesFor: #queryData!accessing-queries!public! !
!SwazooURI categoriesFor: #value!accessing!public! !

!SwazooURI class methodsFor!

new
	^super new initialize!

value: aString
	^self new value: aString! !
!SwazooURI class categoriesFor: #new!instance creation!public! !
!SwazooURI class categoriesFor: #value:!instance creation!public! !

URIIdentifier guid: (GUID fromString: '{34BACD0A-C4AB-486C-A5C7-2A640EB50669}')!
URIIdentifier comment: ''!
!URIIdentifier categoriesForClass!Unclassified! !
!URIIdentifier methodsFor!

= anIdentifier 
	^self match: anIdentifier!

hash
	^1!

match: anotherIdentifier 
	^(self typeMatch: anotherIdentifier) 
		and: [self valueMatch: anotherIdentifier]!

typeMatch: anotherIdentifier 
	^self class == anotherIdentifier class!

valueMatch: anotherIdentifier 
	^self subclassResponsibility! !
!URIIdentifier categoriesFor: #=!comparing!public! !
!URIIdentifier categoriesFor: #hash!comparing!public! !
!URIIdentifier categoriesFor: #match:!public!testing! !
!URIIdentifier categoriesFor: #typeMatch:!private! !
!URIIdentifier categoriesFor: #valueMatch:!private! !

URIResolution guid: (GUID fromString: '{7A30E4A0-77B7-421B-908D-9ED34BD3E79D}')!
URIResolution comment: ''!
!URIResolution categoriesForClass!Unclassified! !
!URIResolution methodsFor!

advance
	self position: self position + 1!

atEnd
	^self position = self request uri identifierPath size!

currentIdentifier
	^self currentPath last!

currentPath
	^self request uri identifierPath copyFrom: 1 to: self position!

fullPath
	^self request uri identifierPath!

getAnswerFrom: aResource
	^aResource answerTo: self request!

initializeRequest: aRequest 
	self request: aRequest.
	self request resolution: self.
	self position: 1!

position
	^position!

position: anInteger
	position := anInteger!

request
	^request!

request: aRequest
	request := aRequest!

resolveCompositeResource: aResource 
	(aResource canAnswer and: [aResource match: self currentIdentifier]) 
		ifFalse: [^nil].
	^self visitChildrenOf: aResource advancing: true!

resolveLeafResource: aResource 
	(aResource canAnswer and: [self stringMatch: aResource]) ifFalse: [^nil].
	^self getAnswerFrom: aResource!

resolveServerRoot: aServerRoot 
	^self resolveTransparentComposite: aServerRoot!

resolveSite: aSite 
	(aSite canAnswer and: [self siteMatch: aSite]) ifFalse: [^nil].
	^aSite answerTo: self request!

resolveTransparentComposite: aCompositeResource 
	^self visitChildrenOf: aCompositeResource advancing: false!

resourcePath
	^self request uri identifierPath copyFrom: 1 to: self position!

retreat
	self position: self position - 1.
	^nil!

siteMatch: aSite 
	^aSite match: self request siteIdentifier!

stringMatch: aResource 
	^aResource uriPattern = self currentIdentifier!

tailPath
	| fullPath |
	fullPath := self fullPath.
	^fullPath copyFrom: self position + 1 to: fullPath size!

tailStream
	^ReadStream on: self tailPath!

visitChildrenOf: aResource advancing: aBoolean 
	| response |
	self atEnd & aBoolean ifTrue: [^self getAnswerFrom: aResource].
	aBoolean ifTrue: [self advance].
	aResource children do: 
			[:each | 
			response := self visitResource: each.
			response isNil ifFalse: [^response]].
	^aBoolean ifTrue: [self retreat] ifFalse: [nil]!

visitResource: aResource 
	^aResource helpResolve: self! !
!URIResolution categoriesFor: #advance!private! !
!URIResolution categoriesFor: #atEnd!accessing!public! !
!URIResolution categoriesFor: #currentIdentifier!private! !
!URIResolution categoriesFor: #currentPath!private! !
!URIResolution categoriesFor: #fullPath!accessing!public! !
!URIResolution categoriesFor: #getAnswerFrom:!private! !
!URIResolution categoriesFor: #initializeRequest:!private-initialize!public! !
!URIResolution categoriesFor: #position!accessing!public! !
!URIResolution categoriesFor: #position:!private! !
!URIResolution categoriesFor: #request!accessing!public! !
!URIResolution categoriesFor: #request:!private! !
!URIResolution categoriesFor: #resolveCompositeResource:!public!visiting! !
!URIResolution categoriesFor: #resolveLeafResource:!public!visiting! !
!URIResolution categoriesFor: #resolveServerRoot:!public!visiting! !
!URIResolution categoriesFor: #resolveSite:!private!visiting! !
!URIResolution categoriesFor: #resolveTransparentComposite:!public!visiting! !
!URIResolution categoriesFor: #resourcePath!accessing!public! !
!URIResolution categoriesFor: #retreat!private! !
!URIResolution categoriesFor: #siteMatch:!private! !
!URIResolution categoriesFor: #stringMatch:!private! !
!URIResolution categoriesFor: #tailPath!accessing!public! !
!URIResolution categoriesFor: #tailStream!private! !
!URIResolution categoriesFor: #visitChildrenOf:advancing:!public!visiting! !
!URIResolution categoriesFor: #visitResource:!public!visiting! !

!URIResolution class methodsFor!

resolveRequest: aRequest startingAt: aResource 
	^(self new initializeRequest: aRequest) visitResource: aResource! !
!URIResolution class categoriesFor: #resolveRequest:startingAt:!instance creation!public! !

HTTPException guid: (GUID fromString: '{83423874-E30F-406D-9652-18C7A6A2E733}')!
HTTPException comment: 'HTTPException immediatelly returns attached HTTP response to client. That way it is easier to respond with different status codes (like 201 Created). Not only error ones!! You can respond somewhere deeply in code of your resource with raising that exception and adding a prepared HTTPResponse. 
This exception is non-resumable!!

Example of ways to raise http response (200 Ok):

	HTTPException raiseResponse: (HTTPResponse new code: 200).
	HTTPException raiseResponseCode: 200.
	HTTPException ok.

Instance Variables:
	response	<HTTPResponse>	a response to be sent to client'!
!HTTPException categoriesForClass!Unclassified! !
!HTTPException methodsFor!

response
	^response!

response: aHTTPResponse
	response := aHTTPResponse! !
!HTTPException categoriesFor: #response!accessing!public! !
!HTTPException categoriesFor: #response:!accessing!public! !

!HTTPException class methodsFor!

accepted
	^self raiseResponse: (HTTPResponse new code: 202)!

badGateway
	^self raiseResponse: (HTTPResponse new code: 502)!

badRequest
	^self raiseResponse: (HTTPResponse new code: 400)!

conflict
	^self raiseResponse: (HTTPResponse new code: 409)!

continue
	^self raiseResponse: (HTTPResponse new code: 100)!

created
	^self raiseResponse: (HTTPResponse new code: 201)!

expectationFailed
	^self raiseResponse: (HTTPResponse new code: 416)!

forbidden
	^self raiseResponse: (HTTPResponse new code: 403)!

found
	^self raiseResponse: (HTTPResponse new code: 302)!

gatewayTimeout
	^self raiseResponse: (HTTPResponse new code: 504)!

gone
	^self raiseResponse: (HTTPResponse new code: 410)!

httpVersionNotSupported
	^self raiseResponse: (HTTPResponse new code: 505)!

internalServerError
	^self raiseResponse: (HTTPResponse new code: 500)!

lengthRequired
	^self raiseResponse: (HTTPResponse new code: 411)!

methodNotAllowed
	^self raiseResponse: (HTTPResponse new code: 405)!

movedPermanently
	^self raiseResponse: (HTTPResponse new code: 301)!

multipleChoices
	^self raiseResponse: (HTTPResponse new code: 300)!

noContent
	^self raiseResponse: (HTTPResponse new code: 204)!

nonAuthorativeInformation
	^self raiseResponse: (HTTPResponse new code: 203)!

notAcceptable
	^self raiseResponse: (HTTPResponse new code: 406)!

notFound
	^self raiseResponse: (HTTPResponse new code: 404)!

notImplemented
	^self raiseResponse: (HTTPResponse new code: 501)!

notModified
	^self raiseResponse: (HTTPResponse new code: 304)!

ok
	^self raiseResponse: HTTPResponse ok!

partialContent
	^self raiseResponse: (HTTPResponse new code: 206)!

paymentRequired
	^self raiseResponse: (HTTPResponse new code: 402)!

preconditionFailed
	^self raiseResponse: (HTTPResponse new code: 412)!

proxyAuthenticationRequired
	^self raiseResponse: (HTTPResponse new code: 407)!

raiseResponse: aHTTPResponse
	"Raise an exception to immediatelly return that response."
	^self new 
		response: aHTTPResponse;
		raiseSignal.!

raiseResponseCode: aNumber
	"Raise an exception to immediatelly return http response with that code"
	^self raiseResponse: (HTTPResponse new code: aNumber)!

requestedRangeNotSatisfiable
	^self raiseResponse: (HTTPResponse new code: 416)!

requestEntityTooLarge
	^self raiseResponse: (HTTPResponse new code: 413)!

requestTimeout
	^self raiseResponse: (HTTPResponse new code: 408)!

requestURITooLong
	^self raiseResponse: (HTTPResponse new code: 414)!

resetContent
	^self raiseResponse: (HTTPResponse new code: 205)!

seeOther
	^self raiseResponse: (HTTPResponse new code: 303)!

serviceUnavailable
	^self raiseResponse: (HTTPResponse new code: 503)!

switchingProtocols
	^self raiseResponse: (HTTPResponse new code: 101)!

temporaryRedirect
	^self raiseResponse: (HTTPResponse new code: 307)!

unathorized
	^self raiseResponse: (HTTPResponse new code: 401)!

unsupportedMediaType
	^self raiseResponse: (HTTPResponse new code: 415)!

useProxy
	^self raiseResponse: (HTTPResponse new code: 305)! !
!HTTPException class categoriesFor: #accepted!public!responses-succesfull! !
!HTTPException class categoriesFor: #badGateway!public!responses-server error! !
!HTTPException class categoriesFor: #badRequest!public!responses-client error! !
!HTTPException class categoriesFor: #conflict!public!responses-client error! !
!HTTPException class categoriesFor: #continue!public!responses-informational! !
!HTTPException class categoriesFor: #created!public!responses-succesfull! !
!HTTPException class categoriesFor: #expectationFailed!public!responses-client error! !
!HTTPException class categoriesFor: #forbidden!public!responses-client error! !
!HTTPException class categoriesFor: #found!public!responses-redirection! !
!HTTPException class categoriesFor: #gatewayTimeout!public!responses-server error! !
!HTTPException class categoriesFor: #gone!public!responses-client error! !
!HTTPException class categoriesFor: #httpVersionNotSupported!public!responses-server error! !
!HTTPException class categoriesFor: #internalServerError!public!responses-server error! !
!HTTPException class categoriesFor: #lengthRequired!public!responses-client error! !
!HTTPException class categoriesFor: #methodNotAllowed!public!responses-client error! !
!HTTPException class categoriesFor: #movedPermanently!public!responses-redirection! !
!HTTPException class categoriesFor: #multipleChoices!public!responses-redirection! !
!HTTPException class categoriesFor: #noContent!public!responses-succesfull! !
!HTTPException class categoriesFor: #nonAuthorativeInformation!public!responses-succesfull! !
!HTTPException class categoriesFor: #notAcceptable!public!responses-client error! !
!HTTPException class categoriesFor: #notFound!public!responses-client error! !
!HTTPException class categoriesFor: #notImplemented!public!responses-server error! !
!HTTPException class categoriesFor: #notModified!public!responses-redirection! !
!HTTPException class categoriesFor: #ok!public!responses-succesfull! !
!HTTPException class categoriesFor: #partialContent!public!responses-succesfull! !
!HTTPException class categoriesFor: #paymentRequired!public!responses-client error! !
!HTTPException class categoriesFor: #preconditionFailed!public!responses-client error! !
!HTTPException class categoriesFor: #proxyAuthenticationRequired!public!responses-client error! !
!HTTPException class categoriesFor: #raiseResponse:!public!signalling! !
!HTTPException class categoriesFor: #raiseResponseCode:!public!signalling! !
!HTTPException class categoriesFor: #requestedRangeNotSatisfiable!public!responses-client error! !
!HTTPException class categoriesFor: #requestEntityTooLarge!public!responses-client error! !
!HTTPException class categoriesFor: #requestTimeout!public!responses-client error! !
!HTTPException class categoriesFor: #requestURITooLong!public!responses-client error! !
!HTTPException class categoriesFor: #resetContent!public!responses-succesfull! !
!HTTPException class categoriesFor: #seeOther!public!responses-redirection! !
!HTTPException class categoriesFor: #serviceUnavailable!public!responses-server error! !
!HTTPException class categoriesFor: #switchingProtocols!public!responses-informational! !
!HTTPException class categoriesFor: #temporaryRedirect!public!responses-redirection! !
!HTTPException class categoriesFor: #unathorized!public!responses-client error! !
!HTTPException class categoriesFor: #unsupportedMediaType!public!responses-client error! !
!HTTPException class categoriesFor: #useProxy!public!responses-redirection! !

GenericHeaderField guid: (GUID fromString: '{C29F3500-5E57-4974-BDB7-9AA948CAA88F}')!
GenericHeaderField comment: ''!
!GenericHeaderField categoriesForClass!Unclassified! !
!GenericHeaderField methodsFor!

combine: aGenericHeaderField 
	self value: self value , ',' , aGenericHeaderField value!

name
	^name!

name: aString 
	name := aString!

printString
	^'a Svazoo.GenericHeaderField
	', self name, ': ', self value!

values
	^(SwazooPlatform current string: self value tokensBasedOn: $,) collect: [:each | each trimBlanks]! !
!GenericHeaderField categoriesFor: #combine:!accessing!public! !
!GenericHeaderField categoriesFor: #name!accessing!public! !
!GenericHeaderField categoriesFor: #name:!private-initialize!public! !
!GenericHeaderField categoriesFor: #printString!private! !
!GenericHeaderField categoriesFor: #values!accessing!public! !

!GenericHeaderField class methodsFor!

name: aFieldString value: aValueString 
	^(self new)
		name: aFieldString;
		value: aValueString! !
!GenericHeaderField class categoriesFor: #name:value:!instance creation!public! !

SpecificHeaderField guid: (GUID fromString: '{94683D33-6EC6-4106-A430-3B8211390313}')!
SpecificHeaderField comment: ''!
!SpecificHeaderField categoriesForClass!Unclassified! !
!SpecificHeaderField methodsFor!

combine: aGenericHeaderField 
	self error: 'Not supported'!

initialize
	super initialize.
	self initParameters!

initParameters
	parameters := Dictionary new!

name
	^self class fieldName!

parameterAt: aString 
	^self parameterAt: aString ifAbsent: [nil]!

parameterAt: aString ifAbsent: aBlock 
	^self parameters at: aString ifAbsent: aBlock!

parameters
	parameters isNil ifTrue: [self initParameters].
	^parameters!

readParametersFrom: rs 
	[rs atEnd] whileFalse: 
			[| paramString tok |
			paramString := rs upTo: $;.
			tok := (SwazooPlatform current string: paramString tokensBasedOn: $=) collect: [:each | each trimBlanks].
			self parameters at: tok first put: tok last]!

values
	^Array with: self value! !
!SpecificHeaderField categoriesFor: #combine:!accessing!public! !
!SpecificHeaderField categoriesFor: #initialize!private-initialize!public! !
!SpecificHeaderField categoriesFor: #initParameters!private-initialize!public! !
!SpecificHeaderField categoriesFor: #name!accessing!public! !
!SpecificHeaderField categoriesFor: #parameterAt:!accessing!public! !
!SpecificHeaderField categoriesFor: #parameterAt:ifAbsent:!accessing!public! !
!SpecificHeaderField categoriesFor: #parameters!private-utility!public! !
!SpecificHeaderField categoriesFor: #readParametersFrom:!private-utility!public! !
!SpecificHeaderField categoriesFor: #values!accessing!public! !

!SpecificHeaderField class methodsFor!

fieldName
	^self subclassResponsibility! !
!SpecificHeaderField class categoriesFor: #fieldName!accessing!public! !

AuthorizationField guid: (GUID fromString: '{B486E55D-4A08-4E42-9A46-89DC43B9056D}')!
AuthorizationField comment: ''!
!AuthorizationField categoriesForClass!Unclassified! !
!AuthorizationField methodsFor!

basicUsernameAndPassword
	"association with username and password from Authorization header, 
	if Basic authentication scheme is used (rfc2617)"
	| stream |
	self isBasicScheme ifFalse: [^nil].
	stream := self decodedBasicCredentials readStream.
	^Association key: (stream upTo: $: ) value: stream upToEnd!

credentials
	"only for Basic authentication"
	^self parameterAt: 'credentials'!

decodedBasicCredentials
	"from header like: Authorization: Basic QWxhZGRpbjpvcGVuIHNlc2FtZQ=="
	^SwazooPlatform current base64DecodeAsString: self credentials
!

isAuthorization
	^true!

isBasicScheme
	"HTTP Authentication scheme is Basic"
	^self scheme = 'Basic'!

isDigestScheme
	"HTTP Authentication scheme is Digest"
	^self scheme = 'Digest'!

matchUserWithPassword: aString
	"check, if this password match username in authorization response"
	self isBasicScheme ifTrue: [^self password = aString].!

nonce
	^self parameterAt: 'nonce'!

opaque
	^self parameterAt: 'opaque'!

password
	"only for Basic authentication"
	^self parameterAt: 'password'!

printString
	^'a Svazoo.AuthorizationField
	', self name, ': ', self value!

readParametersFrom: rs
	| assoc |
	self parameters at: 'scheme' put: (rs upTo: $ ).
	self isBasicScheme ifTrue: 
		[self parameters at: 'credentials' put: rs upToEnd.
		assoc := self basicUsernameAndPassword.
		self parameters at: 'username' put: assoc key. ^self parameters at: 'password' put: assoc value].
	[rs atEnd] whileFalse: 
		[| paramString tok |
		paramString := rs upTo: $,.
		tok := (SwazooPlatform string: paramString tokensBasedOn: $=) collect: [:each | each trimBlanks].
		self parameters at: tok first put: (tok last copyWithout: $")]!

realm
	^self parameterAt: 'realm'!

response
	^self parameterAt: 'response'!

scheme
	^self parameterAt: 'scheme'!

uri
	^self parameterAt: 'uri'!

username
	^self parameterAt: 'username'!

valueFrom: aString 
	super valueFrom: aString.
	self readParametersFrom: aString readStream.! !
!AuthorizationField categoriesFor: #basicUsernameAndPassword!private! !
!AuthorizationField categoriesFor: #credentials!accessing-parameters!public! !
!AuthorizationField categoriesFor: #decodedBasicCredentials!public! !
!AuthorizationField categoriesFor: #isAuthorization!public!testing! !
!AuthorizationField categoriesFor: #isBasicScheme!public!testing! !
!AuthorizationField categoriesFor: #isDigestScheme!public!testing! !
!AuthorizationField categoriesFor: #matchUserWithPassword:!public!testing! !
!AuthorizationField categoriesFor: #nonce!accessing-parameters!public! !
!AuthorizationField categoriesFor: #opaque!accessing-parameters!public! !
!AuthorizationField categoriesFor: #password!accessing-parameters!public! !
!AuthorizationField categoriesFor: #printString!printing!public! !
!AuthorizationField categoriesFor: #readParametersFrom:!private! !
!AuthorizationField categoriesFor: #realm!accessing-parameters!public! !
!AuthorizationField categoriesFor: #response!accessing-parameters!public! !
!AuthorizationField categoriesFor: #scheme!accessing-parameters!public! !
!AuthorizationField categoriesFor: #uri!accessing-parameters!public! !
!AuthorizationField categoriesFor: #username!accessing-parameters!public! !
!AuthorizationField categoriesFor: #valueFrom:!private! !

!AuthorizationField class methodsFor!

fieldName
	^'AUTHORIZATION'! !
!AuthorizationField class categoriesFor: #fieldName!accessing!public! !

ContentDispositionField guid: (GUID fromString: '{41CDE634-8AF2-45BB-85BB-BCFD697BE212}')!
ContentDispositionField comment: ''!
!ContentDispositionField categoriesForClass!Unclassified! !
!ContentDispositionField methodsFor!

isContentDisposition
	^true!

valueFrom: aString 
	| rs |
	rs := aString readStream.
	self value: (rs upTo: $;) trimBlanks.
	self readParametersFrom: rs! !
!ContentDispositionField categoriesFor: #isContentDisposition!public!testing! !
!ContentDispositionField categoriesFor: #valueFrom:!private-initialize!public! !

!ContentDispositionField class methodsFor!

fieldName
	^'CONTENT-DISPOSITION'! !
!ContentDispositionField class categoriesFor: #fieldName!accessing!public! !

ContentLengthHeader guid: (GUID fromString: '{2060904C-9464-46B8-BC3F-041F8C3C5519}')!
ContentLengthHeader comment: ''!
!ContentLengthHeader categoriesForClass!Unclassified! !
!ContentLengthHeader methodsFor!

valueFrom: aString 
	self value: aString asNumber! !
!ContentLengthHeader categoriesFor: #valueFrom:!private-initialize!public! !

!ContentLengthHeader class methodsFor!

fieldName
	^'CONTENT-LENGTH'! !
!ContentLengthHeader class categoriesFor: #fieldName!accessing!public! !

ContentTypeField guid: (GUID fromString: '{2F3EBB55-5305-40A6-8D6A-E20E0AF3953C}')!
ContentTypeField comment: ''!
!ContentTypeField categoriesForClass!Unclassified! !
!ContentTypeField methodsFor!

isContentType
	^true!

valueFrom: aString 
	| rs |
	rs := aString readStream.
	self value: (rs upTo: $;) trimBlanks.
	self readParametersFrom: rs! !
!ContentTypeField categoriesFor: #isContentType!public!testing! !
!ContentTypeField categoriesFor: #valueFrom:!private-initialize!public! !

!ContentTypeField class methodsFor!

fieldName
	^'CONTENT-TYPE'! !
!ContentTypeField class categoriesFor: #fieldName!accessing!public! !

HTTPRequest guid: (GUID fromString: '{03B53426-F883-4835-988C-F6B073C99E2A}')!
HTTPRequest comment: ''!
!HTTPRequest categoriesForClass!Unclassified! !
!HTTPRequest methodsFor!

authenticated
	^authenticated!

authorizationHeader
	^self headerAt: 'Authorization' ifAbsent: [^nil]!

connection
	^(self headerAt: 'Connection' ifAbsent: [^nil]) value!

contentLength
	^self headerValueOrNil: 'Content-Length'!

contents
	"if request has content after headers and it is not postData, then it is stored in this instvar"
	^contents!

contents: aByteArray
	contents := aByteArray!

cookie
	^self headerValueOrNil: 'COOKIE'!

encrypted
	^encrypted!

environmentAt: aKey 
	^self environmentAt: aKey ifAbsent: [nil]!

environmentAt: aKey ifAbsent: aBlock 
	^self environmentData at: aKey ifAbsent: aBlock!

environmentAt: aKey put: aValue 
	self environmentData at: aKey put: aValue!

environmentData
	^environmentData!

hasAuthorizationHeader
	^self includesHeader: 'Authorization'!

hasCookie
	"check if  Cookie:  was in request header"

	^self includesHeader: 'Cookie'!

headerAt: aKey ifAbsent: aBlock
	^self headers at: aKey asUppercase ifAbsent: aBlock!

host
	^(self headerAt: 'Host' ifAbsent: [^String new]) value!

httpVersion
	^httpVersion!

httpVersion: anArray
	httpVersion := anArray!

httpVersionString
	^'HTTP/', (self httpVersion at: 1) printString, '.', (self httpVersion at: 2) printString!

includesQuery: aString 
	^self uri includesQuery: aString!

initEnvironmentData
	environmentData := Dictionary new!

initialize
	super initialize.
	self setTimestamp.
	self initQueries.
	self initEnvironmentData!

initQueries
	#spmTodo. "queries variable missing?"!

ip
	^ip!

ip: anObject
	ip := anObject!

isAuthenticated
	^self authenticated isNil not!

isClose
	| header |
	header := self connection.
	header isNil ifTrue: [^false].
	^'*close*' match: header!

isDelete
	^false!

isEncrypted
	^self encrypted isNil not!

isFromLinux
	^'*Linux*' match: self userAgent!

isFromMSIE
	^'*MSIE*' match: self userAgent!

isFromNetscape
	"NS>7.0 or Mozilla or Firefox"
	^'*Gecko*' match: self userAgent!

isFromWindows
	^'*Windows*' match: self userAgent!

isGet
	^false!

isHead
	^false!

isKeepAlive
	| header |
	header := self connection.
	header isNil ifTrue: [^false].
	^'*Keep-Alive*' match: self connection!

isOptions
	^false!

isPost
	^false!

isPut
	^false!

isTrace
	^false!

linesFrom: aStream 
	| lines lineStream line |
	lines := OrderedCollection new.
	lineStream := LineStream on: aStream.
	[line := lineStream nextLine. line isEmpty] whileFalse: [lines add: line].
	^lines!

matchUserWithPassword: aString
	"HTTP authentication challenge (rfc2617)"
	self hasAuthorizationHeader ifFalse: [^nil].
	^self authorizationHeader matchUserWithPassword: aString!

method
	"HTTP method used for a request"
	^self class method!

multipartDataFrom: aStream
	self subclassResponsibility "HTTPPost"!

parseHTTPVersion: aString 
	| rs major minor |
	rs := aString readStream.
	rs skipThrough: $/.
	major := (rs upTo: $.) asNumber.
	minor := rs upToEnd asNumber.
	self httpVersion: (Array with: major with: minor)!

parseURI: aString
	| rs |
	self uri: SwazooURI new.
	rs := ReadStream on: aString.	"self uri protocol is for SSL set later !! "
	self uri identifier: (rs upTo: $?) httpDecoded.
	self uri queries: (rs upTo: $#) httpDecoded.	"to anchor name, if any"
	self uri host: self host!

peer
	^peer!

peer: anObject
	peer := anObject!

port
	^self uri port!

printOn: aStream 
	aStream nextPutAll: 'a HTTPRequest'.
	self peer isNil ifFalse: [aStream cr; tab; nextPutAll: ' from: '; nextPutAll: self peer.].
	aStream 
		cr; tab; nextPutAll: ' at: '; nextPutAll: self timestamp day printString;
			nextPut: $.; print: self timestamp month; nextPut: $.; print: self timestamp year;
			space; print: self timestamp hour; nextPut: $:; print: self timestamp minute;
		cr; tab; nextPutAll: self method, ' ', self uri value, ' ', self httpVersionString; cr.
	aStream nextPutAll: self printHeaders!

queries
	^self uri queries!

queryAt: aKey 
	^self uri queryAt: aKey!

queryAt: aKey ifAbsent: aBlock 
	^self uri queryAt: aKey ifAbsent: aBlock!

queryData
	^self uri queryData!

rawContentsFrom: aStream 
	self contents: (aStream nextBytes: self contentLength).
"
	| crlfBody |
	crlfBody := (aStream nextBytes: self contentLength) asString.
	self contents: (self toCr: crlfBody).
"!

readFrom: aStream 
	| lines contentType |
	lines := self linesFrom: aStream.
	lines do: [:each || field |
		field := HeaderField fromLine: each.
		self headers at: field name asUppercase put: field].
	(self includesHeader: 'Content-Length') ifTrue:
		[contentType := (self headerAt: 'Content-Type') value.
		contentType = 'application/x-www-form-urlencoded' ifTrue: [^self urlencodedDataFrom: aStream].
		contentType = 'multipart/form-data' ifTrue: [^self multipartDataFrom: aStream].
		self rawContentsFrom: aStream]!

referer
	^(self headerAt: 'Referer' ifAbsent: [^String new]) value!

resolution
	^resolution!

resolution: anObject
	resolution := anObject!

resourcePath
	^self resolution resourcePath!

rootConstruct: aString 
	| ws path |
	ws := WriteStream on: String new.
	path := self resourcePath.
	path first = '/' ifTrue: [ws nextPutAll: path removeFirst].
	path do: 
			[:each | 
			ws
				nextPutAll: each;
				nextPut: $/].
	ws nextPutAll: aString.
	^ws contents!

session
	^self environmentAt: #session!

session: aSession 
	self environmentAt: #session put: aSession!

setAuthenticated 	
	authenticated := true!

setEncrypted
	encrypted := true!

setTimestamp
	timestamp := Timestamp now!

siteIdentifier
	^SiteIdentifier 
		ip: self ip
		port: self port
		host: self uri hostname!

tailPath
	^self resolution tailPath!

timestamp
	^timestamp!

toCr: aString 
	^SwazooPlatform current stringWithUnixLineEndings: aString!

toCrLf: aString 
	^SwazooPlatform current stringWithInternetLineEndings: aString!

uri
	^uri!

uri: aSwazooURI
	uri := aSwazooURI!

uriString
	^self uri identifier!

urlencodedDataFrom: aStream
	self subclassResponsibility "HTTPPost"!

urlString
	^self uri value!

userAgent
	^self headerValueOrNil: 'User-Agent'!

username
	"if this request responds to HTTP authentication challenge (rfc2617), you can get a username"
	self hasAuthorizationHeader ifFalse: [^nil].
	^self authorizationHeader username!

wantsConnectionClose
	self isClose ifTrue: [^true].
	^self httpVersion last = 0 and: [self isKeepAlive not]! !
!HTTPRequest categoriesFor: #authenticated!private-accessing!public! !
!HTTPRequest categoriesFor: #authorizationHeader!accessing-headers!public! !
!HTTPRequest categoriesFor: #connection!accessing-headers!public! !
!HTTPRequest categoriesFor: #contentLength!accessing-headers!public! !
!HTTPRequest categoriesFor: #contents!accessing!public! !
!HTTPRequest categoriesFor: #contents:!accessing!public! !
!HTTPRequest categoriesFor: #cookie!accessing-headers!public! !
!HTTPRequest categoriesFor: #encrypted!private-accessing!public! !
!HTTPRequest categoriesFor: #environmentAt:!accessing!public! !
!HTTPRequest categoriesFor: #environmentAt:ifAbsent:!accessing!public! !
!HTTPRequest categoriesFor: #environmentAt:put:!accessing!public! !
!HTTPRequest categoriesFor: #environmentData!private-accessing!public! !
!HTTPRequest categoriesFor: #hasAuthorizationHeader!public!testing! !
!HTTPRequest categoriesFor: #hasCookie!public!testing! !
!HTTPRequest categoriesFor: #headerAt:ifAbsent:!accessing-headers!public! !
!HTTPRequest categoriesFor: #host!accessing-headers!public! !
!HTTPRequest categoriesFor: #httpVersion!accessing!public! !
!HTTPRequest categoriesFor: #httpVersion:!private-accessing!public! !
!HTTPRequest categoriesFor: #httpVersionString!printing!public! !
!HTTPRequest categoriesFor: #includesQuery:!accessing-queries!public! !
!HTTPRequest categoriesFor: #initEnvironmentData!private-initialize!public! !
!HTTPRequest categoriesFor: #initialize!private-initialize!public! !
!HTTPRequest categoriesFor: #initQueries!public! !
!HTTPRequest categoriesFor: #ip!accessing!public! !
!HTTPRequest categoriesFor: #ip:!private-accessing!public! !
!HTTPRequest categoriesFor: #isAuthenticated!public!testing! !
!HTTPRequest categoriesFor: #isClose!public!testing! !
!HTTPRequest categoriesFor: #isDelete!public!testing! !
!HTTPRequest categoriesFor: #isEncrypted!public!testing! !
!HTTPRequest categoriesFor: #isFromLinux!public!testing! !
!HTTPRequest categoriesFor: #isFromMSIE!public!testing! !
!HTTPRequest categoriesFor: #isFromNetscape!public!testing! !
!HTTPRequest categoriesFor: #isFromWindows!public!testing! !
!HTTPRequest categoriesFor: #isGet!public!testing! !
!HTTPRequest categoriesFor: #isHead!public!testing! !
!HTTPRequest categoriesFor: #isKeepAlive!public!testing! !
!HTTPRequest categoriesFor: #isOptions!public!testing! !
!HTTPRequest categoriesFor: #isPost!public!testing! !
!HTTPRequest categoriesFor: #isPut!public!testing! !
!HTTPRequest categoriesFor: #isTrace!public!testing! !
!HTTPRequest categoriesFor: #linesFrom:!private! !
!HTTPRequest categoriesFor: #matchUserWithPassword:!authentication!public! !
!HTTPRequest categoriesFor: #method!accessing!public! !
!HTTPRequest categoriesFor: #multipartDataFrom:!private! !
!HTTPRequest categoriesFor: #parseHTTPVersion:!private-initialize!public! !
!HTTPRequest categoriesFor: #parseURI:!private-initialize!public! !
!HTTPRequest categoriesFor: #peer!accessing!public! !
!HTTPRequest categoriesFor: #peer:!private-accessing!public! !
!HTTPRequest categoriesFor: #port!accessing-headers!public! !
!HTTPRequest categoriesFor: #printOn:!printing!public! !
!HTTPRequest categoriesFor: #queries!private-accessing!public! !
!HTTPRequest categoriesFor: #queryAt:!accessing-queries!public! !
!HTTPRequest categoriesFor: #queryAt:ifAbsent:!accessing-queries!public! !
!HTTPRequest categoriesFor: #queryData!accessing-queries!public! !
!HTTPRequest categoriesFor: #rawContentsFrom:!private! !
!HTTPRequest categoriesFor: #readFrom:!private-initialize!public! !
!HTTPRequest categoriesFor: #referer!accessing-headers!public! !
!HTTPRequest categoriesFor: #resolution!accessing!public! !
!HTTPRequest categoriesFor: #resolution:!accessing!public! !
!HTTPRequest categoriesFor: #resourcePath!accessing!public! !
!HTTPRequest categoriesFor: #rootConstruct:!accessing!public! !
!HTTPRequest categoriesFor: #session!accessing!public! !
!HTTPRequest categoriesFor: #session:!accessing!public! !
!HTTPRequest categoriesFor: #setAuthenticated!private-accessing!public! !
!HTTPRequest categoriesFor: #setEncrypted!private-accessing!public! !
!HTTPRequest categoriesFor: #setTimestamp!public! !
!HTTPRequest categoriesFor: #siteIdentifier!accessing!public! !
!HTTPRequest categoriesFor: #tailPath!accessing!public! !
!HTTPRequest categoriesFor: #timestamp!accessing!public! !
!HTTPRequest categoriesFor: #toCr:!public! !
!HTTPRequest categoriesFor: #toCrLf:!public! !
!HTTPRequest categoriesFor: #uri!accessing!public! !
!HTTPRequest categoriesFor: #uri:!private-accessing!public! !
!HTTPRequest categoriesFor: #uriString!accessing!public! !
!HTTPRequest categoriesFor: #urlencodedDataFrom:!private! !
!HTTPRequest categoriesFor: #urlString!accessing!public! !
!HTTPRequest categoriesFor: #userAgent!accessing-headers!public! !
!HTTPRequest categoriesFor: #username!authentication!public! !
!HTTPRequest categoriesFor: #wantsConnectionClose!public!testing! !

!HTTPRequest class methodsFor!

method
	"HTTP method used for a request"
	^self subclassResponsibility!

newFor: aMethod 
	"to support an additional http method, simply subclass a HTTPRequest!!"
	| class |
	aMethod = 'GET' ifTrue: [^HTTPGet new]. "most used anyway"
	class := self subclasses detect: [:each | each method = aMethod] ifNone: [nil].
	class isNil ifTrue: [^HTTPException notImplemented].
	^class new!

readFrom: aStream 
	| requestLine rs method inst ls |
	ls := LineStream on: aStream.
	requestLine := ls nextLine.
	[requestLine isEmpty]
		whileTrue: [requestLine := ls nextLine].
	rs := requestLine readStream.
	method := rs upTo: Character space.
	inst := self newFor: method.
	inst readFrom: aStream.
	inst parseURI: (rs upTo: Character space).
	inst parseHTTPVersion: (rs upTo: Character space).
	^inst!

request: aUriString 
	^self 
		request: aUriString
		from: 'someHost'
		at: 'someIP'!

request: aUriString from: aHostString at: anIPString 
	| request |
	request := self new.
	request addHeader: (GenericHeaderField name: 'Host' value: aHostString).
	request parseURI: aUriString.
	request ip: anIPString.
	^request! !
!HTTPRequest class categoriesFor: #method!accessing!public! !
!HTTPRequest class categoriesFor: #newFor:!instance creation!public! !
!HTTPRequest class categoriesFor: #readFrom:!instance creation!public! !
!HTTPRequest class categoriesFor: #request:!instance creation!public! !
!HTTPRequest class categoriesFor: #request:from:at:!instance creation!public! !

HTTPResponse guid: (GUID fromString: '{9ED5A687-2C04-4685-8ACC-F31D02A8480F}')!
HTTPResponse comment: ''!
!HTTPResponse categoriesForClass!Unclassified! !
!HTTPResponse methodsFor!

addDateHeader
	self addHeaderName: 'Date' value: Timestamp now rfc1123String!

addDefaultBody
	self entity: '<HTML>
<HEAD><TITLE>', (StatusCodes at: self code), '</TITLE></HEAD>
  <BODY>
   <H2>', self code printString, ' ', (StatusCodes at: self code), '</H2>
   <P>The server experienced an error while processing this request. <BR>
   If this problem persists, please contact the webmaster.</P>
  <P>Swazoo Smalltalk Web Server</P>
  </BODY>
</HTML>'!

addServerHeader
	^self 
		addHeader: (GenericHeaderField name: 'Server' value: HTTPServer version)!

code
	^code!

code: anInteger 
	code := anInteger.
	(#(200) includes: code) ifFalse: [self addDefaultBody].!

codeText
	^self class statusTextForCode: self code!

contentType
	^(self headerAt: 'Content-Type' ifAbsent: [^'application/octet-stream']) 
		value!

contentType: aString 
	self addHeaderName: 'Content-Type' value: aString!

cookie: aString 
	self addHeaderName: 'Set-Cookie' value: aString!

crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf!

endHeaderOn: aStream 
	self crlfOn: aStream!

entity
	^entity!

entity: anEntity 
	entity := anEntity asByteArray!

informConnectionClose
	self addHeaderName: 'Connection' value: 'close'!

initialize
	super initialize.
	self addServerHeader.
	self addDateHeader.!

isBadRequest
	^self code = 400!

isFound
	^self code = 302!

isInternalServerError
	^self code = 500!

isMovedPermanently
	^self code = 301!

isNotFound
	^self code = 404!

isNotImplemented
	^self code = 501!

isNotModified
	^self code = 304!

isOk
	^self code = 200!

isRedirectLink
	^self code = 302!

isSeeOther
	^self code = 303!

isUnauthorized
	^self code = 401!

location: aString 
	self addHeaderName: 'Location' value: aString!

printContentLengthOn: aStream 
	aStream
		nextPutAll: 'Content-Length: ';
		print: (self entity notNil ifTrue: [self entity size] ifFalse: [0]).
	self crlfOn: aStream!

printEntityOn: aStream 
	self entity isNil ifFalse: [aStream nextPutBytes: self entity]!

printHeadersOn: aStream 
	self headers keysAndValuesDo: 
			[:key :val | 
			aStream
				nextPutAll: val name;
				nextPutAll: ': ';
				nextPutAll: val value.
			self crlfOn: aStream]!

printStatusOn: aStream 
	aStream
		nextPutAll: 'HTTP/1.1 ';
		print: self code;
		space;
		nextPutAll: (StatusCodes at: self code).
	self crlfOn: aStream!

writeHeaderTo: aStream 
	self printStatusOn: aStream.
	self printHeadersOn: aStream.
	self printContentLengthOn: aStream.
	self endHeaderOn: aStream!

writeTo: aStream 
	self writeHeaderTo: aStream.
	self printEntityOn: aStream! !
!HTTPResponse categoriesFor: #addDateHeader!public! !
!HTTPResponse categoriesFor: #addDefaultBody!public! !
!HTTPResponse categoriesFor: #addServerHeader!private-initialize!public! !
!HTTPResponse categoriesFor: #code!accessing!public! !
!HTTPResponse categoriesFor: #code:!private-initialize!public! !
!HTTPResponse categoriesFor: #codeText!accessing!public! !
!HTTPResponse categoriesFor: #contentType!accessing-headers!public! !
!HTTPResponse categoriesFor: #contentType:!accessing-headers!public! !
!HTTPResponse categoriesFor: #cookie:!accessing-headers!public! !
!HTTPResponse categoriesFor: #crlfOn:!private-printing!public! !
!HTTPResponse categoriesFor: #endHeaderOn:!private-printing!public! !
!HTTPResponse categoriesFor: #entity!accessing!public! !
!HTTPResponse categoriesFor: #entity:!accessing!public! !
!HTTPResponse categoriesFor: #informConnectionClose!private! !
!HTTPResponse categoriesFor: #initialize!private-initialize!public! !
!HTTPResponse categoriesFor: #isBadRequest!public!testing! !
!HTTPResponse categoriesFor: #isFound!public!testing! !
!HTTPResponse categoriesFor: #isInternalServerError!public!testing! !
!HTTPResponse categoriesFor: #isMovedPermanently!public!testing! !
!HTTPResponse categoriesFor: #isNotFound!public!testing! !
!HTTPResponse categoriesFor: #isNotImplemented!public!testing! !
!HTTPResponse categoriesFor: #isNotModified!public!testing! !
!HTTPResponse categoriesFor: #isOk!public!testing! !
!HTTPResponse categoriesFor: #isRedirectLink!public!testing! !
!HTTPResponse categoriesFor: #isSeeOther!public!testing! !
!HTTPResponse categoriesFor: #isUnauthorized!public!testing! !
!HTTPResponse categoriesFor: #location:!accessing-headers!public! !
!HTTPResponse categoriesFor: #printContentLengthOn:!private-printing!public! !
!HTTPResponse categoriesFor: #printEntityOn:!private-printing!public! !
!HTTPResponse categoriesFor: #printHeadersOn:!private-printing!public! !
!HTTPResponse categoriesFor: #printStatusOn:!public! !
!HTTPResponse categoriesFor: #writeHeaderTo:!accessing!public! !
!HTTPResponse categoriesFor: #writeTo:!accessing!public! !

!HTTPResponse class methodsFor!

badRequest
	^super new code: 400!

found
	^super new code: 302!

initialize
	"self initialize"

	StatusCodes := (Dictionary new)
				add: 100 -> 'Continue';
				add: 101 -> 'Switching Protocols';
				add: 200 -> 'OK';
				add: 201 -> 'Created';
				add: 202 -> 'Accepted';
				add: 203 -> 'Non-Authoritative Information';
				add: 204 -> 'No Content';
				add: 205 -> 'Reset Content';
				add: 206 -> 'Partial Content';
				add: 300 -> 'Multiple Choices';
				add: 301 -> 'Moved Permanently';
				add: 302 -> 'Found';
				add: 303 -> 'See Other';
				add: 304 -> 'Not Modified';
				add: 305 -> 'Use Proxy';
				add: 307 -> 'Temporary Redirect';
				add: 400 -> 'Bad Request';
				add: 401 -> 'Unauthorized';
				add: 402 -> 'Payment Required';
				add: 403 -> 'Forbidden';
				add: 404 -> 'Not Found';
				add: 405 -> 'Method Not Allowed';
				add: 406 -> 'Not Acceptable';
				add: 407 -> 'Proxy Authentication Required';
				add: 408 -> 'Request Time-out';
				add: 409 -> 'Conflict';
				add: 410 -> 'Gone';
				add: 411 -> 'Length Required';
				add: 412 -> 'Precondition Failed';
				add: 413 -> 'Request Entity Too Large';
				add: 414 -> 'Request-URI Too Large';
				add: 415 -> 'Unsupported Media Type';
				add: 416 -> 'Requested range not satisfiable';
				add: 417 -> 'Expectation Failed';
				add: 500 -> 'Internal Server Error';
				add: 501 -> 'Not Implemented';
				add: 502 -> 'Bad Gateway';
				add: 503 -> 'Service Unavailable';
				add: 504 -> 'Gateway Time-out';
				add: 505 -> 'HTTP Version not supported';
				yourself.
	self postInitialize.!

internalServerError
	^super new code: 500!

movedPermanently
	^super new code: 301!

notFound
	^super new code: 404!

notImplemented
	^super new code: 501!

notModified
	^super new code: 304!

ok
	^super new code: 200!

postInitialize
	"WebDAV Status Code Extensions, rfc2518 sec10"
	StatusCodes
		add: 102 -> 'Processing';
		add: 207 -> 'Multi-Status';
		add: 422 -> 'Unprocessable Entity';
		add: 423 -> 'Locked';
		add: 424 -> 'Failed Dependency';
		add: 507 -> 'Insufficient Storage'!

redirectLink
	^super new code: 302!

seeOther
	^super new code: 303!

statusTextForCode: aNumber
	^StatusCodes at: aNumber ifAbsent: ['']!

unauthorized
	^super new code: 401! !
!HTTPResponse class categoriesFor: #badRequest!public!response types! !
!HTTPResponse class categoriesFor: #found!public!response types! !
!HTTPResponse class categoriesFor: #initialize!public! !
!HTTPResponse class categoriesFor: #internalServerError!public!response types! !
!HTTPResponse class categoriesFor: #movedPermanently!public!response types! !
!HTTPResponse class categoriesFor: #notFound!public!response types! !
!HTTPResponse class categoriesFor: #notImplemented!public!response types! !
!HTTPResponse class categoriesFor: #notModified!public!response types! !
!HTTPResponse class categoriesFor: #ok!public!response types! !
!HTTPResponse class categoriesFor: #postInitialize!public! !
!HTTPResponse class categoriesFor: #redirectLink!public!response types! !
!HTTPResponse class categoriesFor: #seeOther!public!response types! !
!HTTPResponse class categoriesFor: #statusTextForCode:!public! !
!HTTPResponse class categoriesFor: #unauthorized!public!response types! !

HTTPDelete guid: (GUID fromString: '{14F08AA8-C9C9-4AF1-A241-7B29B5C2315E}')!
HTTPDelete comment: 'HTTPDelete 

rfc26216 section 9.7

The DELETE method requests that the origin server delete the resource
   identified by the Request-URI. This method MAY be overridden by human
   intervention (or other means) on the origin server. The client cannot
   be guaranteed that the operation has been carried out, even if the
   status code returned from the origin server indicates that the action
   has been completed successfully. However, the server SHOULD NOT
   indicate success unless, at the time the response is given, it
   intends to delete the resource or move it to an inaccessible
   location.
 ...'!
!HTTPDelete categoriesForClass!Unclassified! !
!HTTPDelete methodsFor!

isDelete
	^true! !
!HTTPDelete categoriesFor: #isDelete!public!testing! !

!HTTPDelete class methodsFor!

method
	"HTTP method used for a request"
	^'DELETE'! !
!HTTPDelete class categoriesFor: #method!accessing!public! !

HTTPGet guid: (GUID fromString: '{050D72EF-8691-4917-9CC0-0AB4C3AB1B6D}')!
HTTPGet comment: 'HTTPGet 

rfc26216 section 9.3

   The GET method means retrieve whatever information (in the form of an
   entity) is identified by the Request-URI. If the Request-URI refers
   to a data-producing process, it is the produced data which shall be
   returned as the entity in the response and not the source text of the
   process, unless that text happens to be the output of the process.'!
!HTTPGet categoriesForClass!Unclassified! !
!HTTPGet methodsFor!

isGet
	^true! !
!HTTPGet categoriesFor: #isGet!public!testing! !

!HTTPGet class methodsFor!

method
	"HTTP method used for a request"
	^'GET'! !
!HTTPGet class categoriesFor: #method!accessing!public! !

HTTPHead guid: (GUID fromString: '{F90F9CEF-7876-4E66-97B1-356A06AA4FD6}')!
HTTPHead comment: 'HTTPHead

rfc26216 section 9.4

   The HEAD method is identical to GET except that the server MUST NOT
   return a message-body in the response. The metainformation contained
   in the HTTP headers in response to a HEAD request SHOULD be identical
   to the information sent in response to a GET request. This method can
   be used for obtaining metainformation about the entity implied by the
   request without transferring the entity-body itself. This method is
   often used for testing hypertext links for validity, accessibility,
   and recent modification.'!
!HTTPHead categoriesForClass!Unclassified! !
!HTTPHead methodsFor!

isHead
	^true! !
!HTTPHead categoriesFor: #isHead!public!testing! !

!HTTPHead class methodsFor!

method
	"HTTP method used for a request"
	^'HEAD'! !
!HTTPHead class categoriesFor: #method!accessing!public! !

HTTPOptions guid: (GUID fromString: '{DCF2432A-1267-4ADC-A238-7753D3DE6496}')!
HTTPOptions comment: 'HTTPOptions

rfc26216 section 9.2

   The OPTIONS method represents a request for information about the
   communication options available on the request/response chain
   identified by the Request-URI. This method allows the client to
   determine the options and/or requirements associated with a resource,
   or the capabilities of a server, without implying a resource action
   or initiating a resource retrieval.'!
!HTTPOptions categoriesForClass!Unclassified! !
!HTTPOptions methodsFor!

isOptions
	^true! !
!HTTPOptions categoriesFor: #isOptions!public!testing! !

!HTTPOptions class methodsFor!

method
	"HTTP method used for a request"
	^'OPTIONS'! !
!HTTPOptions class categoriesFor: #method!accessing!public! !

HTTPPost guid: (GUID fromString: '{85B3E7F9-DC43-47B4-9C71-2B05D50A803D}')!
HTTPPost comment: 'HTTPPost 

rfc26216 section 9.5

   The POST method is used to request that the origin server accept the
   entity enclosed in the request as a new subordinate of the resource
   identified by the Request-URI in the Request-Line.

Instance Variables:
	entityBody	<>	
	postData	<HTTPPostDataArray>'!
!HTTPPost categoriesForClass!Unclassified! !
!HTTPPost methodsFor!

emptyData
	^self postData select: [:each | each value isEmpty]!

initialize
	super initialize.
	self initPostData!

initPostData
	postData := HTTPPostDataArray new!

isPost
	^true!

multipartDataFrom: aStream 
	| e tokens boundary |
	(self includesHeader: 'Content-Length') 
		ifFalse: [^self error: 'Bad POST header'].
	e := aStream nextBytes: self contentLength.
	boundary := (self headerAt: 'Content-Type') parameterAt: 'boundary'
				ifAbsent: [^self].
	tokens := SwazooPlatform current collection: e tokensBasedOnAll: boundary asByteArray.
	tokens do: 
			[:bytes | 
			| part |
			part := self partFromBytes: bytes.
			part isNil ifFalse: [self postData at: part key put: part value]]!

partFromBytes: bytes 
	| str rs name filename datum |
	str := bytes asString trimBlanks.
	str = '--' ifTrue: [^nil].
	rs := str readStream.
	name := nil. filename := nil.
	datum := HTTPPostDatum new.
	[rs atEnd] whileFalse: 
			[| line |
			line := rs upTo: Character cr.
			rs peek = Character lf 
				ifTrue: 
					[| field |
					rs next.
					line isEmpty 
						ifTrue: 
							[| entity |
							name isNil ifTrue: [^nil].
							entity := rs upToEnd.
							entity size < 4 ifTrue: [^self].
							datum value: (entity copyFrom: 1 to: entity size - 4).
							filename notNil ifTrue: [datum filename: filename].
							^name -> datum].
					field := HeaderField fromLine: line.
					field isContentDisposition 
						ifTrue: 
							[name := (field parameterAt: 'name') copyWithout: $".
							filename := (field parameterAt: 'filename').
							filename notNil ifTrue: [filename := filename copyWithout: $"]].
					field isContentType ifTrue: [datum contentType: field value]]]!

postData
	^postData!

postDataAt: aKey 
	^self postDataAt: aKey ifAbsent: [nil]!

postDataAt: aKey do: aBlock 
	| val |
	val := self postData at: aKey ifAbsent: [nil].
	val isNil ifFalse: [aBlock value: val]!

postDataAt: aKey ifAbsent: aBlock 
	^self postData at: aKey ifAbsent: aBlock!

postDataAt: aKey put: aPostDatum 
	"for testing purposes"

	self postData at: aKey put: aPostDatum!

postDataAt: aKey putString: aString 
	"for testing purposes"

	self postDataAt: aKey put: (HTTPPostDatum new value: aString)!

postDataKeys
	^self postData keys!

postDataStringAt: aKey 
	^(self postDataAt: aKey ifAbsent: [^nil]) value!

postKeysAndValuesDo: aTwoArgBlock 
	self postData 
		keysAndValuesDo: [:key :each | aTwoArgBlock value: key value: each value]!

readFrom: aStream 
	super readFrom: aStream.
	((self includesHeader: 'Content-Type') and: [self includesHeader: 'Content-Length'])
		ifFalse: [^self error: 'Bad POST header'].!

urlencodedDataFrom: aStream
	| e tokens |
	(self includesHeader: 'Content-Length') ifFalse: [ ^self ].
	e := aStream nextBytes: self contentLength.
	tokens := SwazooPlatform current string: e asString tokensBasedOn: $&.
	(tokens collect: [ :each | SwazooPlatform current string: each tokensBasedOn: $= ])
		do:
			[ :keyVal | 
			| datum |
			datum := HTTPPostDatum new.
			datum
				value:
					(keyVal last collect: [ :char | char = $+ ifTrue: [ Character space ] ifFalse: [ char ] ])
						httpDecoded.
			self postDataAt: keyVal first put: datum ]! !
!HTTPPost categoriesFor: #emptyData!accessing!public! !
!HTTPPost categoriesFor: #initialize!private-initialize!public! !
!HTTPPost categoriesFor: #initPostData!private-initialize!public! !
!HTTPPost categoriesFor: #isPost!public!testing! !
!HTTPPost categoriesFor: #multipartDataFrom:!private! !
!HTTPPost categoriesFor: #partFromBytes:!private! !
!HTTPPost categoriesFor: #postData!private! !
!HTTPPost categoriesFor: #postDataAt:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:do:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:ifAbsent:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:put:!accessing!public! !
!HTTPPost categoriesFor: #postDataAt:putString:!accessing!public! !
!HTTPPost categoriesFor: #postDataKeys!accessing!public! !
!HTTPPost categoriesFor: #postDataStringAt:!accessing!public! !
!HTTPPost categoriesFor: #postKeysAndValuesDo:!accessing!public! !
!HTTPPost categoriesFor: #readFrom:!public!reading! !
!HTTPPost categoriesFor: #urlencodedDataFrom:!private! !

!HTTPPost class methodsFor!

method
	"HTTP method used for a request"
	^'POST'! !
!HTTPPost class categoriesFor: #method!accessing!public! !

HTTPPut guid: (GUID fromString: '{BE3D104E-7FFF-4E75-A294-6E4B07B3CE74}')!
HTTPPut comment: 'HTTPPut 

rfc26216 section 9.6

   The PUT method requests that the enclosed entity be stored under the
   supplied Request-URI. If the Request-URI refers to an already
   existing resource, the enclosed entity SHOULD be considered as a
   modified version of the one residing on the origin server. If the
   Request-URI does not point to an existing resource, and that URI is
   capable of being defined as a new resource by the requesting user
   agent, the origin server can create the resource with that URI. If a
   new resource is created, the origin server MUST inform the user agent
   via the 201 (Created) response. If an existing resource is modified,
   either the 200 (OK) or 204 (No Content) response codes SHOULD be sent
   to indicate successful completion of the request. If the resource
   could not be created or modified with the Request-URI, an appropriate
   error response SHOULD be given that reflects the nature of the
   problem. The recipient of the entity MUST NOT ignore any Content-*
   (e.g. Content-Range) headers that it does not understand or implement
   and MUST return a 501 (Not Implemented) response in such cases.

Instance Variables:
	putData	<>'!
!HTTPPut categoriesForClass!Unclassified! !
!HTTPPut methodsFor!

isPut
	^true!

putData
	^self contents!

readFrom: aStream 
	super readFrom: aStream.! !
!HTTPPut categoriesFor: #isPut!public!testing! !
!HTTPPut categoriesFor: #putData!accessing!public! !
!HTTPPut categoriesFor: #readFrom:!public!reading! !

!HTTPPut class methodsFor!

method
	"HTTP method used for a request"
	^'PUT'! !
!HTTPPut class categoriesFor: #method!accessing!public! !

HTTPTrace guid: (GUID fromString: '{C395F6EA-C946-4DFB-B87D-3F5CB541FD95}')!
HTTPTrace comment: 'HTTPTrace 

rfc26216 section 9.8

   The TRACE method is used to invoke a remote, application-layer loop-
   back of the request message. The final recipient of the request
   SHOULD reflect the message received back to the client as the
   entity-body of a 200 (OK) response'!
!HTTPTrace categoriesForClass!Unclassified! !
!HTTPTrace methodsFor!

isTrace
	^true! !
!HTTPTrace categoriesFor: #isTrace!public!testing! !

!HTTPTrace class methodsFor!

method
	"HTTP method used for a request"
	^'TRACE'! !
!HTTPTrace class categoriesFor: #method!accessing!public! !

FileResponse guid: (GUID fromString: '{80F62B16-71CC-4D10-8FDA-8DFC16D72966}')!
FileResponse comment: ''!
!FileResponse categoriesForClass!Unclassified! !
!FileResponse methodsFor!

contentType
	^self entity contentType!

entity: aMimeObject 
	entity := aMimeObject!

printContentLengthOn: aStream 
	self entity isNil 
		ifFalse: 
			[aStream
				nextPutAll: 'Content-Length: ';
				print: self entity value fileSize.
			self crlfOn: aStream]!

printEntityOn: aStream 
	| rs |
	self entity isNil 
		ifFalse: 
			[rs := self entity value readStream.
			"rs lineEndTransparent. #spmTodo. Resolve this"
			#spmTodo.
			
			[[[rs atEnd] whileFalse: [aStream nextPutAll: (rs nextAvailable: 2000)]] 
				ensure: [rs close]] 
					on: Error
					do: [:ex | ex return]]!

printHeadersOn: aStream 
	self contentType: self entity contentType.
	super printHeadersOn: aStream! !
!FileResponse categoriesFor: #contentType!accessing-headers!public! !
!FileResponse categoriesFor: #entity:!accessing!public! !
!FileResponse categoriesFor: #printContentLengthOn:!private-printing!public! !
!FileResponse categoriesFor: #printEntityOn:!public! !
!FileResponse categoriesFor: #printHeadersOn:!private-printing!public! !

HTTPAuthenticationChallenge guid: (GUID fromString: '{BE1791E2-0C4E-4672-B483-5E3E13D103C4}')!
HTTPAuthenticationChallenge comment: ''!
!HTTPAuthenticationChallenge categoriesForClass!Unclassified! !
!HTTPAuthenticationChallenge methodsFor!

prepareAuthenticationChallenge
	self subclassResponsibility!

resource
	^resource!

resource: aResource
	resource := aResource! !
!HTTPAuthenticationChallenge categoriesFor: #prepareAuthenticationChallenge!challenging!public! !
!HTTPAuthenticationChallenge categoriesFor: #resource!accessing!public! !
!HTTPAuthenticationChallenge categoriesFor: #resource:!accessing!public! !

!HTTPAuthenticationChallenge class methodsFor!

newForResource: aResource
	^aResource authenticationScheme = #Basic 
		ifTrue: [HTTPAuthenticationBasicChallenge newForResource: aResource]
		ifFalse: [aResource authenticationScheme = #Digest
			ifTrue: [HTTPAuthenticationDigestChallenge newForResource: aResource]
			ifFalse: [HTTPResponse unauthorized] ]! !
!HTTPAuthenticationChallenge class categoriesFor: #newForResource:!instance creation!public! !

HTTPAuthenticationBasicChallenge guid: (GUID fromString: '{ADB2C856-73CE-4A3A-ABCC-94BCBC71DA66}')!
HTTPAuthenticationBasicChallenge comment: ''!
!HTTPAuthenticationBasicChallenge categoriesForClass!Unclassified! !
!HTTPAuthenticationBasicChallenge methodsFor!

prepareAuthenticationChallenge
	self addHeaderName: 'WWW-Authenticate' 
		value: 'Basic realm="', self resource authenticationRealm, '"'! !
!HTTPAuthenticationBasicChallenge categoriesFor: #prepareAuthenticationChallenge!challenging!public! !

!HTTPAuthenticationBasicChallenge class methodsFor!

newForResource: aResource
	^self unauthorized 
		resource: aResource;
		entity: aResource unauthorizedResponsePage;
		prepareAuthenticationChallenge! !
!HTTPAuthenticationBasicChallenge class categoriesFor: #newForResource:!instance creation!public! !

HTTPAuthenticationDigestChallenge guid: (GUID fromString: '{9B21EAC9-0184-41BB-A77D-C61E86E0E67D}')!
HTTPAuthenticationDigestChallenge comment: ''!
!HTTPAuthenticationDigestChallenge categoriesForClass!Unclassified! !
!HTTPAuthenticationDigestChallenge methodsFor!

initialize
	super initialize.
	self setNonce.
	self setOpaque.!

nonce
	^nonce!

nonce: anAuthenticationNonce
	nonce := anAuthenticationNonce!

opaque
	^opaque!

opaque: aString
	opaque := aString!

prepareAuthenticationChallenge
	self addHeaderName: 'WWW-Authenticate' 
		value: 'Digest realm="', self resource authenticationRealm, '", ',
			'nonce="', self nonce hashed, '", ',
			'opaque="', self opaque, '"'!

setNonce
	self nonce: AuthenticationNonce new.!

setOpaque
	self opaque: (MD5Digest hash: self hash printString)! !
!HTTPAuthenticationDigestChallenge categoriesFor: #initialize!initialize-release!public! !
!HTTPAuthenticationDigestChallenge categoriesFor: #nonce!accessing!public! !
!HTTPAuthenticationDigestChallenge categoriesFor: #nonce:!private! !
!HTTPAuthenticationDigestChallenge categoriesFor: #opaque!accessing!public! !
!HTTPAuthenticationDigestChallenge categoriesFor: #opaque:!private! !
!HTTPAuthenticationDigestChallenge categoriesFor: #prepareAuthenticationChallenge!challenging!public! !
!HTTPAuthenticationDigestChallenge categoriesFor: #setNonce!private! !
!HTTPAuthenticationDigestChallenge categoriesFor: #setOpaque!private! !

!HTTPAuthenticationDigestChallenge class methodsFor!

newForResource: aResource
	^self unauthorized 
		resource: aResource;
		entity: aResource unauthorizedResponsePage;
		prepareAuthenticationChallenge! !
!HTTPAuthenticationDigestChallenge class categoriesFor: #newForResource:!instance creation!public! !

HTTPPostDatum guid: (GUID fromString: '{9C7D3D62-0E0E-4C98-9CE0-0A1D6E189D2A}')!
HTTPPostDatum comment: ''!
!HTTPPostDatum categoriesForClass!Unclassified! !
!HTTPPostDatum methodsFor!

defaultContentType
	^'text/plain'!

filename
	^filename!

filename: aString
	filename := aString! !
!HTTPPostDatum categoriesFor: #defaultContentType!private-accessing!public! !
!HTTPPostDatum categoriesFor: #filename!accessing!public! !
!HTTPPostDatum categoriesFor: #filename:!accessing!public! !

CompositeResource guid: (GUID fromString: '{6ECFE8AB-7249-4CD1-96FF-616D0694FF3C}')!
CompositeResource comment: ''!
!CompositeResource categoriesForClass!Unclassified! !
!CompositeResource methodsFor!

addResource: aResource
	self children add: aResource.
	aResource parent: self.
	aResource onResourceCreated.
	^aResource!

addResources: anOrderedCollection
	anOrderedCollection do: [ :each |
		self addResource: each].
	^anOrderedCollection!

children
	children isNil ifTrue: [self initChildren].
	^children!

currentUrl
	| string |
	string := super currentUrl.
	^string last = $/
		ifTrue: [string]
		ifFalse: [string , '/']!

hasNoResources
	^self children isEmpty!

helpResolve: aResolution 
	^aResolution resolveCompositeResource: self!

includesResource: aResource
	^self children includes: aResource.!

initChildren
	children := OrderedCollection new.!

initialize
	super initialize.
	self initChildren!

isRootPath
	^self uriPattern = '/'!

printUrlOn: aWriteStream 
	super printUrlOn: aWriteStream.
	self isRootPath ifFalse: [aWriteStream nextPut: $/]!

removeResource: aResource
	self children remove: aResource ifAbsent: [nil]! !
!CompositeResource categoriesFor: #addResource:!adding/removing!public! !
!CompositeResource categoriesFor: #addResources:!adding/removing!public! !
!CompositeResource categoriesFor: #children!accessing!public! !
!CompositeResource categoriesFor: #currentUrl!accessing!public! !
!CompositeResource categoriesFor: #hasNoResources!public!testing! !
!CompositeResource categoriesFor: #helpResolve:!accessing!public! !
!CompositeResource categoriesFor: #includesResource:!public!testing! !
!CompositeResource categoriesFor: #initChildren!initialize-release!public! !
!CompositeResource categoriesFor: #initialize!initialize-release!public! !
!CompositeResource categoriesFor: #isRootPath!public!testing! !
!CompositeResource categoriesFor: #printUrlOn:!accessing!public! !
!CompositeResource categoriesFor: #removeResource:!adding/removing!public! !

ServerRootComposite guid: (GUID fromString: '{9820943D-C706-4A06-A1AE-E45B9868F1FF}')!
ServerRootComposite comment: ''!
!ServerRootComposite categoriesForClass!Unclassified! !
!ServerRootComposite methodsFor!

helpResolve: aResolution 
	^aResolution resolveServerRoot: self! !
!ServerRootComposite categoriesFor: #helpResolve:!accessing!public! !

Site guid: (GUID fromString: '{912800DC-E68D-41DA-96B4-CF2965A39577}')!
Site comment: ''!
!Site categoriesForClass!Unclassified! !
!Site methodsFor!

addAlias: anAlias 
	self uriPattern add: anAlias!

address
	^self host!

aliases
	^self uriPattern!

compile: tag 
	^SwazooCompiler evaluate: tag!

helpResolve: aResolution 
	^aResolution resolveSite: self!

host
	"hostname of this site. Example: www.ibm.com. 
	hostname must be unique on that server.
	Don't mix with ip, which also can be something like www.ibm.com. 
	There can be many sites with different hostnames on the same ip !! "
	self uriPattern isEmpty ifTrue: [^''].
	^self uriPattern first host!

host: aString
	(SwazooServer singleton siteHostnamed: aString) notNil 
		ifTrue: [^self error: 'Site with that hostname already exist!!'].
	self uriPattern first host: aString!

host: aHostString ip: anIPString port: aNumber 
	"see comments in methods host and ip !! "
	"hostname must be unique!! "
	(SwazooServer singleton siteHostnamed: aHostString) notNil 
		ifTrue: [^self error: 'Site with that hostname already exist!!'].
	self uriPattern isEmpty ifTrue: [self uriPattern add: SiteIdentifier new].
	self uriPattern first 
		setIp: anIPString
		port: aNumber
		host: aHostString!

host: aHostString ip: anIPString port: aNumber sslPort: aSSLNumber
	"see comments in methods host and ip !! "
	"hostname must be unique!! "
	#spmTodo. "No SSL in Dolphin right now"
"
	self host: aHostString ip: anIPString port: aNumber.
	self uriPattern size < 2 ifTrue: [self uriPattern add: SSLSiteIdentifier new].
	(self uriPattern at: 2)
		setIp: anIPString
		port: aSSLNumber
		host: aHostString
"!

initialize
	super initialize.
	self stop. "in case you initialize working site"
	self initUriPattern!

initUriPattern
	self uriPattern: OrderedCollection new!

ip
	"IP address of this site. Swazoo can have virtual sites, that is, more than one 
	site can share the same ip and port!!
	IP can be a number or full DNS name. For example: server.ibm.com or 234.12.45.66"
	^self uriPattern first ip!

ip: aString
	self uriPattern first  ip: aString!

isRootPath
	^false!

isServing
	"is this site on-line?"
	^serving notNil and: [serving]!

match: aSiteIdentifier 
	self uriPattern detect: [:each | each match: aSiteIdentifier]
		ifNone: [^false].
	^true!

name
	"a short name of that site. Example: for host www.ibm.com, name it ibm"
	name isNil ifTrue: [^''].
	^name!

name: aString
	"a short name of that site. Example: for host www.ibm.com, name it ibm"
	"name must be unique"
	(SwazooServer singleton siteNamed: aString) notNil 
		ifTrue: [^self error: 'Site with that name already exist!!'].
	name := aString!

nextTagFrom: aStream 
	aStream upTo: $<.
	^aStream atEnd ifTrue: [nil] ifFalse: [aStream upTo: $>]!

port
	^self uriPattern first port!

port: aNumber
	self uriPattern first port: aNumber!

printUrlOn: aWriteStream 
	self uriPattern first printUrlOn: aWriteStream!

readCompositeFrom: aStream storingInto: aComposite 
	| tag |
	
	[tag := self nextTagFrom: aStream.
	tag = '/CompositeResource']
		whileFalse: 
			[| thingy |
			thingy := self compile: tag.
			aComposite addResource: thingy.
			(thingy isKindOf: CompositeResource)
				ifTrue: [self readCompositeFrom: aStream storingInto: thingy]]!

readFrom: aStream 
	| tag |
	tag := self nextTagFrom: aStream.
	tag isNil ifTrue: [^nil].
	tag = 'Site' ifFalse: [^self error: 'invalid site specification!!'].
	
	[tag := self nextTagFrom: aStream.
	tag = '/Site']
		whileFalse: 
			[| thingy |
			thingy := self compile: tag.
			(thingy isKindOf: SiteIdentifier)
				ifTrue: [self addAlias: thingy]
				ifFalse: 
					[self addResource: thingy.
					(thingy isKindOf: CompositeResource)
						ifTrue: [self readCompositeFrom: aStream storingInto: thingy]]]!

serving: aBoolean
	serving := aBoolean!

sslPort
	^self uriPattern size = 2 ifTrue: [(self uriPattern at: 2) port] ifFalse: [nil].!

sslPort: aNumber
	#spmTodo. "Fix SSL"
	self uriPattern size < 2 ifTrue: [self uriPattern add: (Smalltalk at: #SSLSiteIdentifier) new].
	(self uriPattern at: 2)
		setIp: self ip
		port: aNumber
		host: self host!

start
	| registry |
	registry := SwazooServer singleton.
	[self aliases do: [:each | | server |
		server := registry serverFor: each.
		server addSite: self.
		(registry servers includes: server) 
			ifFalse: 
				[registry addServer: server.
				server isServing ifFalse: [server start] ] ].
	] ifCurtailed: [self stop].
	self serving: true.!

stop
	| registry |
	registry := SwazooServer singleton.
	self aliases do: [:each | | server |
		server := registry serverFor: each.
		(registry servers includes: server) 
			ifTrue: 
				[server removeSite: self.
				server hasNoSites ifTrue: 
					[registry removeServer: server.
					server stop]]].
		self serving: false.!

uriPattern
	uriPattern isNil ifTrue: [self initUriPattern].
	^uriPattern! !
!Site categoriesFor: #addAlias:!accessing!public! !
!Site categoriesFor: #address!accessing!public! !
!Site categoriesFor: #aliases!accessing!public! !
!Site categoriesFor: #compile:!public! !
!Site categoriesFor: #helpResolve:!accessing!public! !
!Site categoriesFor: #host!accessing!public! !
!Site categoriesFor: #host:!accessing!public! !
!Site categoriesFor: #host:ip:port:!accessing!public! !
!Site categoriesFor: #host:ip:port:sslPort:!public! !
!Site categoriesFor: #initialize!private-initialize!public! !
!Site categoriesFor: #initUriPattern!private-initialize!public! !
!Site categoriesFor: #ip!accessing!public! !
!Site categoriesFor: #ip:!accessing!public! !
!Site categoriesFor: #isRootPath!public!testing! !
!Site categoriesFor: #isServing!public!testing! !
!Site categoriesFor: #match:!public!testing! !
!Site categoriesFor: #name!accessing!public! !
!Site categoriesFor: #name:!accessing!public! !
!Site categoriesFor: #nextTagFrom:!configuration!public! !
!Site categoriesFor: #port!accessing!public! !
!Site categoriesFor: #port:!accessing!public! !
!Site categoriesFor: #printUrlOn:!accessing!public! !
!Site categoriesFor: #readCompositeFrom:storingInto:!configuration!public! !
!Site categoriesFor: #readFrom:!configuration!public! !
!Site categoriesFor: #serving:!private! !
!Site categoriesFor: #sslPort!accessing!public! !
!Site categoriesFor: #sslPort:!public! !
!Site categoriesFor: #start!public!start/stop! !
!Site categoriesFor: #stop!public!start/stop! !
!Site categoriesFor: #uriPattern!accessing!public! !

SiteIdentifier guid: (GUID fromString: '{4C8054E3-7ABE-4075-89BC-898A68CF8A75}')!
SiteIdentifier comment: ''!
!SiteIdentifier categoriesForClass!Unclassified! !
!SiteIdentifier methodsFor!

currentUrl
	| stream |
	stream := WriteStream on: String new.
	self printUrlOn: stream.
	^stream contents!

host
	^host!

host: aString
	host := aString!

ip
	^ip!

ip: aString
	ip := aString!

newServer
	^ HTTPServer new ip: self ip;  port: self port!

port
	^port!

port: aNumber
	port := aNumber!

printHostPortStringOn: stream 
	stream nextPutAll: self host.
	self port = 80 ifFalse: [stream nextPut: $:; nextPutAll: self port printString]!

printString
	^'a Swazoo.SiteIndentifier
	host: ', self host, '
	ip: ', self ip, '
	port: ', self port printString!

printUrlOn: aWriteStream 
	aWriteStream nextPutAll: 'http://'.
	self printHostPortStringOn: aWriteStream!

setIp: anIP port: aPort host: hostName 
	self ip: anIP.
	self port: aPort.
	self host: hostName!

valueMatch: aSiteIdentifier
	"ip can be in numbers or named!!"
	^self ip = aSiteIdentifier ip 
		and: [self port = aSiteIdentifier port and: [self host match: aSiteIdentifier host]]! !
!SiteIdentifier categoriesFor: #currentUrl!accessing!public! !
!SiteIdentifier categoriesFor: #host!accessing!public! !
!SiteIdentifier categoriesFor: #host:!private! !
!SiteIdentifier categoriesFor: #ip!accessing!public! !
!SiteIdentifier categoriesFor: #ip:!private! !
!SiteIdentifier categoriesFor: #newServer!initialize-release!public! !
!SiteIdentifier categoriesFor: #port!accessing!public! !
!SiteIdentifier categoriesFor: #port:!private! !
!SiteIdentifier categoriesFor: #printHostPortStringOn:!accessing!public! !
!SiteIdentifier categoriesFor: #printString!private! !
!SiteIdentifier categoriesFor: #printUrlOn:!accessing!public! !
!SiteIdentifier categoriesFor: #setIp:port:host:!initialize-release!public! !
!SiteIdentifier categoriesFor: #valueMatch:!public! !

!SiteIdentifier class methodsFor!

ip: anIP port: aPort host: hostName 
	^self new 
		setIp: anIP
		port: aPort
		host: hostName! !
!SiteIdentifier class categoriesFor: #ip:port:host:!instance creation!public! !

"Binary Globals"!

