| package |
package := Package name: 'Swazoo-Tests'.
package paxVersion: 1;
	basicComment: ' 
Name: Swazoo-Tests
Comment: SUnit tests for Swazoo
DbIdentifier: psql_public_cst
DbTrace: 32232
DevelopmentPrerequisites: #(#(#any ''SUnit'' ''''))
PackageName: Swazoo-Tests
Parcel: #(''Swazoo-Tests'')
ParcelName: Swazoo-Tests
PrerequisiteParcels: #(#(''SUnit'' ''''))
PrintStringCache: (0.9.101,mivsek)
Version: 0.9.60
Date: 1:36:25 pm October 20, 2005
 '.

package basicPackageVersion: 'D.9.108'.


package classNames
	add: #ACLResourceTest;
	add: #CompositeResourceTest;
	add: #FileResourceTest;
	add: #GoodbyeTest;
	add: #HeaderFieldTest;
	add: #HelloWorldResourceTest;
	add: #HomeResourceTest;
	add: #HTTPRequestTest;
	add: #HTTPResponseTest;
	add: #HTTPServerTest;
	add: #LineStreamTest;
	add: #RedirectionResourceTest;
	add: #SiteIdentifierTest;
	add: #SiteTest;
	add: #SwazooActivePageResourceTest;
	add: #SwazooActivePageTest;
	add: #SwazooCacheControlTest;
	add: #SwazooConfigurationTest;
	add: #SwazooResourceTest;
	add: #SwazooServerTest;
	add: #SwazooSessionTest;
	add: #SwazooStreamTest;
	add: #SwazooTestStream;
	add: #SwazooURITest;
	add: #URIResolutionTest;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\..\Camp Smalltalk\SUnit\SUnit';
	add: 'Swazoo';
	add: 'Swazoo-Platform';
	add: 'Swazoo-Resources';
	yourself).

package!

"Class Definitions"!

ReadStream subclass: #SwazooTestStream
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #ACLResourceTest
	instanceVariableNames: 'resource'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #CompositeResourceTest
	instanceVariableNames: 'composite'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #FileResourceTest
	instanceVariableNames: 'resource'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #GoodbyeTest
	instanceVariableNames: 'goodbye'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #HeaderFieldTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #HelloWorldResourceTest
	instanceVariableNames: 'hello'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #HomeResourceTest
	instanceVariableNames: 'resource'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #HTTPRequestTest
	instanceVariableNames: 'request'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #HTTPResponseTest
	instanceVariableNames: 'response'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #HTTPServerTest
	instanceVariableNames: 'server stream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #LineStreamTest
	instanceVariableNames: 'stream'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #RedirectionResourceTest
	instanceVariableNames: 'resource'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SiteIdentifierTest
	instanceVariableNames: 'identifier'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SiteTest
	instanceVariableNames: 'site'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooActivePageResourceTest
	instanceVariableNames: 'resource'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooActivePageTest
	instanceVariableNames: 'page'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooCacheControlTest
	instanceVariableNames: 'resource cacheTarget request cacheControl'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooConfigurationTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooResourceTest
	instanceVariableNames: 'resource'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooServerTest
	instanceVariableNames: 'server'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooSessionTest
	instanceVariableNames: 'session'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooStreamTest
	instanceVariableNames: 'input output'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooURITest
	instanceVariableNames: 'fooURI barURI queryURI'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #URIResolutionTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

SwazooTestStream guid: (GUID fromString: '{1CE59AD8-0A03-4159-BE15-690DE794076B}')!
SwazooTestStream comment: ''!
!SwazooTestStream categoriesForClass!Unclassified! !
!SwazooTestStream methodsFor!

nextBytes: anInteger
	^(self next: anInteger) asByteArray! !
!SwazooTestStream categoriesFor: #nextBytes:!accessing!public! !

ACLResourceTest guid: (GUID fromString: '{3E85CE23-5301-4E3E-99BB-55912746B6E7}')!
ACLResourceTest comment: ''!
!ACLResourceTest categoriesForClass!Unclassified! !
!ACLResourceTest methodsFor!

setUp
	| users |
	users := Dictionary new.
	users at: 'peter' put: 'gabriel'.
	users at: 'alan' put: 'kay'.
	resource := ACLResource new.
	resource setUsers: users!

testAuthorizedLogins
	self
		assert: resource authorizedLogins size = 2;
		assert: (resource authorizedLogins includes: 'peter');
		assert: (resource authorizedLogins includes: 'alan');
		deny: (resource authorizedLogins includes: 'gosling');
		deny: (resource authorizedLogins includes: 'gabriel')!

testPasswords
	self
		assert: (resource passwordForLogin: 'peter') = 'gabriel';
		assert: (resource passwordForLogin: 'alan') = 'kay'!

testReadUsers
	| ws |
	ws := WriteStream on: String new.
	ws
		nextPutAll: 'peter,gabriel';
		cr.
	ws
		nextPutAll: 'alan,kay';
		cr.
	resource
		setUsers: nil;
		readUsersFrom: (ReadStream on: ws contents).
	self
		testAuthorizedLogins;
		testPasswords!

testSessionAuthorization
	| session |
	session := SwazooSession new.
	session at: #authorizedLogin put: 'peter'.
	self assert: (resource authorizeSession: session).
	session at: #authorizedLogin put: 'alan'.
	self assert: (resource authorizeSession: session).
	session at: #authorizedLogin put: 'gosling'.
	self deny: (resource authorizeSession: session)! !
!ACLResourceTest categoriesFor: #setUp!public!running! !
!ACLResourceTest categoriesFor: #testAuthorizedLogins!public!testing! !
!ACLResourceTest categoriesFor: #testPasswords!public!testing! !
!ACLResourceTest categoriesFor: #testReadUsers!public!testing! !
!ACLResourceTest categoriesFor: #testSessionAuthorization!public!testing! !

CompositeResourceTest guid: (GUID fromString: '{65DE649C-351F-4553-8E60-17A441A885DF}')!
CompositeResourceTest comment: ''!
!CompositeResourceTest categoriesForClass!Unclassified! !
!CompositeResourceTest methodsFor!

sampleInSite
	| site |
	site := Site new.
	site addAlias: (SiteIdentifier
			ip: '127.0.0.1'
			port: 8200
			host: 'swazoo.org').
	site addResource: composite!

setUp
	composite := CompositeResource uriPattern: '/'!

testAddResource
	| child |
	composite addResource: (child := HelloWorldResource uriPattern: 'hello.html').
	self assert: composite children size = 1.
	self assert: composite children first == child.
	self assert: child parent == composite!

testAddResources
	| child1 child2 |
	child1 := HelloWorldResource uriPattern: 'hello1.html'.
	child2 := HelloWorldResource uriPattern: 'hello2.html'.
	composite addResources: (Array with: child1 with: child2).
	self assert: composite children size = 2.
	composite children
		do: 
			[:each | 
			self assert: (composite children includes: each).
			self assert: each parent == composite]!

testCurrentUrl
	| child leaf |	
	self sampleInSite.
	self assert: composite currentUrl = 'http://swazoo.org:8200/'.
	composite addResource: (child := CompositeResource uriPattern: 'foo').
	self assert: child currentUrl = 'http://swazoo.org:8200/foo/'.
	child addResource: (leaf := HelloWorldResource uriPattern: 'hi.html').
	self assert: leaf currentUrl = 'http://swazoo.org:8200/foo/hi.html'.!

testEmptyURIPatternInvalid
	composite uriPattern: ''.
	self deny: composite isValidlyConfigured!

testNilURIPatternDoesNothing
	| pattern |
	pattern := composite uriPattern.
	composite uriPattern: nil.
	self assert: composite uriPattern = pattern!

testValidlyConfigured
	self assert: composite isValidlyConfigured! !
!CompositeResourceTest categoriesFor: #sampleInSite!public!testing! !
!CompositeResourceTest categoriesFor: #setUp!public!running! !
!CompositeResourceTest categoriesFor: #testAddResource!public!testing! !
!CompositeResourceTest categoriesFor: #testAddResources!public!testing! !
!CompositeResourceTest categoriesFor: #testCurrentUrl!public!testing! !
!CompositeResourceTest categoriesFor: #testEmptyURIPatternInvalid!public!testing! !
!CompositeResourceTest categoriesFor: #testNilURIPatternDoesNothing!public!testing! !
!CompositeResourceTest categoriesFor: #testValidlyConfigured!public!testing! !

FileResourceTest guid: (GUID fromString: '{56230CF3-9883-4F26-B884-7E205D378C14}')!
FileResourceTest comment: ''!
!FileResourceTest categoriesForClass!Unclassified! !
!FileResourceTest methodsFor!

setUp
	| directory firstFile ws |
	directory := 'fResTest' asFilename.
	directory exists ifFalse: [directory makeDirectory].
	firstFile := directory construct: 'abc.html'.
	ws := firstFile writeStream.
	[ws nextPutAll: 'hello'] ensure: [ws close].
	resource := FileResource uriPattern: 'foo' filePath: 'fResTest'!

tearDown
	('fResTest' asFilename construct: 'abc.html') delete.
	'fResTest' asFilename delete!

testContentType
	self assert: (resource contentTypeFor: '.txt') = 'text/plain'.
	self assert: (resource contentTypeFor: '.html') = 'text/html'!

testDirectoryIndex
	| request response |
	request := HTTPGet request: 'foo/'.
	resource directoryIndex: 'abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'foo'!

testETag
	| request response etag |
	request := HTTPGet request: 'foo/abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: (etag := response headerValueOrNil: 'ETag') notNil.
	self assert: etag first = $".
	self assert: etag last = $".
	request := HTTPGet request: 'foo/abc.html'.
	request addHeaderName: 'If-None-Match' value: etag.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 304.
	self assert: (response headerValueOrNil: 'ETag') = etag.
	request := HTTPGet request: 'foo/abc.html'.
	request addHeaderName: 'If-None-Match' value: '"wrong"'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: (response headerValueOrNil: 'ETag') = etag!

testExistantFile
	| request response |
	request := HTTPGet request: 'foo/abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'foo'!

testNonexistantFile
	| request response |
	request := HTTPGet request: 'foo/notThere.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil!

testRedirection
	| request response |
	request := HTTPGet request: 'foo'.
	resource directoryIndex: 'abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 301.
	self assert: (response headerValueOrNil: 'Location') = 'foo/'!

testRelativeFile
	| request response |
	request := HTTPGet request: 'foo/../', resource fileDirectory tail, '/abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil!

testSafeConstruct
	| request response |
	request := HTTPGet request: 'foo/../abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	request := HTTPGet request: 'foo/.. /./abc.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200! !
!FileResourceTest categoriesFor: #setUp!public!running! !
!FileResourceTest categoriesFor: #tearDown!public!running! !
!FileResourceTest categoriesFor: #testContentType!public!testing! !
!FileResourceTest categoriesFor: #testDirectoryIndex!public!testing! !
!FileResourceTest categoriesFor: #testETag!public!testing! !
!FileResourceTest categoriesFor: #testExistantFile!public!testing! !
!FileResourceTest categoriesFor: #testNonexistantFile!public!testing! !
!FileResourceTest categoriesFor: #testRedirection!public!testing! !
!FileResourceTest categoriesFor: #testRelativeFile!public!testing! !
!FileResourceTest categoriesFor: #testSafeConstruct!public!testing! !

GoodbyeTest guid: (GUID fromString: '{EA74327D-B554-4112-9693-67083FA7E4A4}')!
GoodbyeTest comment: ''!
!GoodbyeTest categoriesForClass!Unclassified! !
!GoodbyeTest methodsFor!

setUp
	goodbye := GoodbyeCruelWorld uriPattern: 'goodbye.html'!

siteCompositeRootWith: aResource 
	| tSite tComposite |
	tSite := Site new.
	tSite addAlias: (SiteIdentifier
			ip: '127.0.0.1'
			port: 8200
			host: 'swazoo.org').
	tSite addResource: (tComposite := CompositeResource uriPattern: '/').
	tComposite addResource: aResource.
	^tSite!

testCurrentUrl
	self siteCompositeRootWith: goodbye.
	self assert: goodbye currentUrl = 'http://swazoo.org:8200/goodbye.html'!

testResponse
	| request response |
	request := HTTPGet request: 'goodbye.html'.
	response := URIResolution resolveRequest: request startingAt: goodbye.
	self assert: response code = 404.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'goodbye.html'! !
!GoodbyeTest categoriesFor: #setUp!public!running! !
!GoodbyeTest categoriesFor: #siteCompositeRootWith:!public!running! !
!GoodbyeTest categoriesFor: #testCurrentUrl!public!testing! !
!GoodbyeTest categoriesFor: #testResponse!public!testing! !

HeaderFieldTest guid: (GUID fromString: '{FAC56872-44AB-4EE8-AE13-757D950282BB}')!
HeaderFieldTest comment: ''!
!HeaderFieldTest categoriesForClass!Unclassified! !
!HeaderFieldTest methodsFor!

testCombine
	| header1 header2 header3 |
	header1 := HeaderField fromLine: 'If-Match: a'.
	header2 := HeaderField fromLine: 'If-Match: b,c'.
	header3 := HeaderField fromLine: 'If-Match: d'.
	header1 combine: header2.
	self assert: header1 value = 'a,b,c'.
	header1 combine: header3.
	self assert: header1 value = 'a,b,c,d'!

testContentTypeMultiple
	| header |
	header := HeaderField 
				fromLine: 'Content-Type: text/html; charset=iso-8859-1'.
	self assert: header name = 'CONTENT-TYPE'.
	self assert: header value = 'text/html'.
	self assert: (header parameterAt: 'charset') = 'iso-8859-1'!

testValues
	| header |
	header := HeaderField fromLine: 'If-Match: "xyzzy" '.
	self assert: header name = 'If-Match'.
	self assert: header values first = '"xyzzy"'.
	header := HeaderField 
				fromLine: 'If-Match: "xyzzy", "r2d2xxxx", "c3piozzzz" '.
	self assert: header name = 'If-Match'.
	self assert: header values first = '"xyzzy"'.
	self assert: (header values at: 2) = '"r2d2xxxx"'.
	self assert: header values last = '"c3piozzzz"'! !
!HeaderFieldTest categoriesFor: #testCombine!public!testing! !
!HeaderFieldTest categoriesFor: #testContentTypeMultiple!public!testing! !
!HeaderFieldTest categoriesFor: #testValues!public!testing! !

HelloWorldResourceTest guid: (GUID fromString: '{35AF5D14-1DF6-45A6-82F2-0FAD80FC9B8A}')!
HelloWorldResourceTest comment: ''!
!HelloWorldResourceTest categoriesForClass!Unclassified! !
!HelloWorldResourceTest methodsFor!

setUp
	hello := HelloWorldResource uriPattern: 'hello.html'!

testResponse
	| request response |
	request := HTTPGet request: 'hello.html'.
	response := URIResolution resolveRequest: request startingAt: hello.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'hello.html'! !
!HelloWorldResourceTest categoriesFor: #setUp!public!running! !
!HelloWorldResourceTest categoriesFor: #testResponse!public!testing! !

HomeResourceTest guid: (GUID fromString: '{D8BFB0CD-6200-4EE7-BA33-0FA6CA10183C}')!
HomeResourceTest comment: ''!
!HomeResourceTest categoriesForClass!Unclassified! !
!HomeResourceTest methodsFor!

setUp
	resource := HomeResource uriPattern: '/' filePath: 'home'!

testRootFileFor
	| request |
	request := HTTPGet request: '/~someUser'.
	URIResolution new initializeRequest: request.
	self assert: (resource rootFileFor: request) 
				= (('home' asFilename construct: 'someUser') construct: 'html')!

testValidateHomePath
	self assert: (resource validateHomePath: '~somebody').
	self assert: (resource validateHomePath: '~somebodyElse').
	self deny: (resource validateHomePath: 'someplace').
	self deny: (resource validateHomePath: 'some~body')! !
!HomeResourceTest categoriesFor: #setUp!public!running! !
!HomeResourceTest categoriesFor: #testRootFileFor!public!running! !
!HomeResourceTest categoriesFor: #testValidateHomePath!public!running! !

HTTPRequestTest guid: (GUID fromString: '{1D90F296-53E5-4BA8-A65C-63CEE5549113}')!
HTTPRequestTest comment: ''!
!HTTPRequestTest categoriesForClass!Unclassified! !
!HTTPRequestTest methodsFor!

basicGet
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET / HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: foo.com'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

basicGetHTTP10
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET / HTTP/1.0'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

basicGetHTTP10Keepalive
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET / HTTP/1.0'.
	self crlfOn: ws.
	ws nextPutAll: 'Connection: Keep-Alive'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

basicHead
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'HEAD / HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: foo.com'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf!

fullGet
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET /aaa/bbb/ccc.html?foo=bar&baz=quux HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Connection: Keep-Alive'.
	self crlfOn: ws.
	ws nextPutAll: 'User-Agent: Mozilla/4.72 [en] (X11; I; Linux 2.3.51 i686)'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: foo.com:8888'.
	self crlfOn: ws.
	ws nextPutAll: 'Referer: http://www.bar.com/takeMeThere.html'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

portedGet
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET / HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: foo.com:8888'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

test10ConnectionClose
	request := self basicGetHTTP10.
	self assert: request wantsConnectionClose!

test10KeepAliveConnectionClose
	request := self basicGetHTTP10Keepalive.
	self deny: request wantsConnectionClose!

testBasicGet
	request := self basicGet.
	self assert: request isGet.
	self deny: request isHead.
	self deny: request isPost.
	self deny: request isPut!

testBasicGetHost
	request := self basicGet.
	self assert: request uri hostname = 'foo.com'!

testBasicGetPort
	request := self basicGet.
	self assert: request port = 80!

testBasicHead
	request := self basicHead.
	self assert: request isHead.
	self deny: request isGet.
	self deny: request isPost.
	self deny: request isPut!

testConnection
	request := self fullGet.
	self assert: request connection = 'Keep-Alive'!

testHeaderAtIfPresent
	| result |
	request := self basicGet.
	result := request headerAt: 'NO-SUCH-HEADER'
				ifPresent: [:header | self signalFailure: 'Should not be executed!!'].
	self assert: result isNil.
	result := request headerAt: 'HOST'
				ifPresent: 
					[:header | 
					self assert: header == (request headerAt: 'HOST').
					true].
	self assert: result!

testNo11ConnectionClose
	request := self basicGet.
	self deny: request wantsConnectionClose!

testNoEqualsQueries
	| ws |

	ws := WriteStream on: String new.
	ws nextPutAll: 'GET /test/typed.asmx?WSDL HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: foo.com:8888'.
	self crlfOn: ws.
	self crlfOn: ws.
	request := HTTPRequest readFrom: (ReadStream on: ws contents).

	self assert: (request includesQuery: 'WSDL').
	self assert: (request queryAt: 'WSDL') isNil.
	"self assert: (request uri queryString = 'WSDL')."!

testPortedGetPort
	request := self portedGet.
	self assert: request port = 8888!

testPostRawEntity
	| ws post|
	ws := WriteStream on: String new.
	ws nextPutAll: 'POST /foobar HTTP/1.0'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: foo.com'.
	self crlfOn: ws.
	ws nextPutAll: 'Content-Type: text/plain'.
	self crlfOn: ws.
	ws nextPutAll: 'Content-Length: 12'.
	self crlfOn: ws.
	self crlfOn: ws.
	ws nextPutAll:  'Hello, World'.
	post := HTTPRequest readFrom: (SwazooTestStream on: ws contents).
	self assert: post postData isEmpty.
	self assert: post contents = 'Hello, World' asByteArray.!

testPostUrlEncodedData
	| ws post|
	ws := WriteStream on: String new.
	ws nextPutAll: 'POST / HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: foo.com'.
	self crlfOn: ws.
	ws nextPutAll: 'Content-Type: application/x-www-form-urlencoded'.
	self crlfOn: ws.
	ws nextPutAll: 'Content-Length: 31'.
	self crlfOn: ws.
	self crlfOn: ws.
	ws nextPutAll: 'address=+fs&product=&quantity=1'.
	post := HTTPRequest readFrom: (SwazooTestStream on: ws contents).
	self assert: (post postDataAt: 'address') value = ' fs'.
	self assert: (post postDataAt: 'product') value = ''.
	self assert: (post postDataAt: 'quantity') value = '1'.!

testReferer
	request := self fullGet.
	self assert: request referer = 'http://www.bar.com/takeMeThere.html'!

testUserAgent
	request := self fullGet.
	self 
		assert: request userAgent = 'Mozilla/4.72 [en] (X11; I; Linux 2.3.51 i686)'! !
!HTTPRequestTest categoriesFor: #basicGet!private! !
!HTTPRequestTest categoriesFor: #basicGetHTTP10!private! !
!HTTPRequestTest categoriesFor: #basicGetHTTP10Keepalive!private! !
!HTTPRequestTest categoriesFor: #basicHead!private! !
!HTTPRequestTest categoriesFor: #crlfOn:!private! !
!HTTPRequestTest categoriesFor: #fullGet!private! !
!HTTPRequestTest categoriesFor: #portedGet!private! !
!HTTPRequestTest categoriesFor: #test10ConnectionClose!public!testing! !
!HTTPRequestTest categoriesFor: #test10KeepAliveConnectionClose!public!testing! !
!HTTPRequestTest categoriesFor: #testBasicGet!public!testing! !
!HTTPRequestTest categoriesFor: #testBasicGetHost!public!testing! !
!HTTPRequestTest categoriesFor: #testBasicGetPort!public!testing! !
!HTTPRequestTest categoriesFor: #testBasicHead!public!testing! !
!HTTPRequestTest categoriesFor: #testConnection!public!testing! !
!HTTPRequestTest categoriesFor: #testHeaderAtIfPresent!public!testing! !
!HTTPRequestTest categoriesFor: #testNo11ConnectionClose!public!testing! !
!HTTPRequestTest categoriesFor: #testNoEqualsQueries!public!testing! !
!HTTPRequestTest categoriesFor: #testPortedGetPort!public!testing! !
!HTTPRequestTest categoriesFor: #testPostRawEntity!public!testing! !
!HTTPRequestTest categoriesFor: #testPostUrlEncodedData!public!testing! !
!HTTPRequestTest categoriesFor: #testReferer!public!testing! !
!HTTPRequestTest categoriesFor: #testUserAgent!public!testing! !

HTTPResponseTest guid: (GUID fromString: '{D799D698-56D9-4323-8E59-BCC05F460057}')!
HTTPResponseTest comment: ''!
!HTTPResponseTest categoriesForClass!Unclassified! !
!HTTPResponseTest methodsFor!

crlf
	^String with: Character cr with: Character lf!

testInternalServerError
	| ws ls |
	response := HTTPResponse internalServerError.
	ws := WriteStream on: String new.
	response printStatusOn: ws.
	ls := LineStream on: (ReadStream on: ws contents).
	self assert: ls nextLine = 'HTTP/1.1 500 Internal Server Error'!

testOK
	| ws ls |
	response := HTTPResponse ok.
	ws := WriteStream on: String new.
	response printStatusOn: ws.
	ls := LineStream on: (ReadStream on: ws contents).
	self assert: ls nextLine = 'HTTP/1.1 200 OK'!

testResponseTypes
	self assert: (HTTPResponse badRequest) isBadRequest.
	self assert: (HTTPResponse found) isFound.
	self assert: (HTTPResponse internalServerError) isInternalServerError.
	self assert: (HTTPResponse movedPermanently) isMovedPermanently.
	self assert: (HTTPResponse notFound) isNotFound.
	self assert: (HTTPResponse notImplemented) isNotImplemented.
	self assert: (HTTPResponse notModified) isNotModified.
	self assert: (HTTPResponse ok) isOk.
	self assert: (HTTPResponse redirectLink) isRedirectLink.
	self assert: (HTTPResponse seeOther) isSeeOther.! !
!HTTPResponseTest categoriesFor: #crlf!private! !
!HTTPResponseTest categoriesFor: #testInternalServerError!public!testing! !
!HTTPResponseTest categoriesFor: #testOK!public!testing! !
!HTTPResponseTest categoriesFor: #testResponseTypes!public!testing! !

HTTPServerTest guid: (GUID fromString: '{AE3B7220-4FAE-417A-90BD-4B60AF114AC7}')!
HTTPServerTest comment: ''!
!HTTPServerTest categoriesForClass!Unclassified! !
!HTTPServerTest methodsFor!

setUp
	(Delay forMilliseconds: 100) wait.
	SwazooPlatform current compactingGC.
	server := HTTPServer new.
	server
		ip: 'localhost';
		port: 8123.
	server start.
	stream := SwazooSocket connectTo: 'localhost' port: 8123.!

tearDown
	server stop.
	stream close.
	stream := nil.
	Delay forMilliseconds: 500.
	SwazooPlatform current compactingGC!

testServing
	self assert: server isServing!

testStopServing
	server stop.
	self deny: server isServing! !
!HTTPServerTest categoriesFor: #setUp!public! !
!HTTPServerTest categoriesFor: #tearDown!public! !
!HTTPServerTest categoriesFor: #testServing!public!tests! !
!HTTPServerTest categoriesFor: #testStopServing!public!tests! !

LineStreamTest guid: (GUID fromString: '{36DCD7A6-6E83-4216-8AAA-9655C159C3C3}')!
LineStreamTest comment: ''!
!LineStreamTest categoriesForClass!Unclassified! !
!LineStreamTest methodsFor!

crlfOn: ws 
	ws
		nextPut: Character cr;
		nextPut: Character lf!

testLinesWithDoubleCRLF
	| ws comparisonString |
	comparisonString := 'abcd'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	self crlfOn: ws.
	self crlfOn: ws.
	stream := LineStream on: (ReadStream on: ws contents).
	self assert: stream nextLine = comparisonString.
	self assert: stream nextLine = ''!

testSingleLineWithCR
	| ws comparisonString errored |
	comparisonString := 'abcd' , (String with: Character cr) , 'efg'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	ws nextPut: Character cr.
	stream := LineStream on: (ReadStream on: ws contents).
	errored := false.
	[stream nextLine] on: Error do: [:ex | errored := true].
	self assert: errored!

testSingleLineWithCRLF
	| ws comparisonString |
	comparisonString := 'abcd'.
	ws := WriteStream on: String new.
	ws nextPutAll: comparisonString.
	self crlfOn: ws.
	stream := LineStream on: (ReadStream on: ws contents).
	self assert: stream nextLine = comparisonString! !
!LineStreamTest categoriesFor: #crlfOn:!private! !
!LineStreamTest categoriesFor: #testLinesWithDoubleCRLF!public!testing! !
!LineStreamTest categoriesFor: #testSingleLineWithCR!public!testing! !
!LineStreamTest categoriesFor: #testSingleLineWithCRLF!public!testing! !

RedirectionResourceTest guid: (GUID fromString: '{ACD6F20B-0DD4-47E2-A729-953DB8F2AC38}')!
RedirectionResourceTest comment: ''!
!RedirectionResourceTest categoriesForClass!Unclassified! !
!RedirectionResourceTest methodsFor!

setUp
	resource := RedirectionResource uriPattern: 'foo'
				targetUri: 'http://abc.def.com'!

testGetResource
	| request response |
	request := HTTPGet request: 'foo'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 301.
	self 
		assert: (response headerValueOrNil: 'Location') = 'http://abc.def.com'.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'foo'! !
!RedirectionResourceTest categoriesFor: #setUp!public!running! !
!RedirectionResourceTest categoriesFor: #testGetResource!public!testing! !

SiteIdentifierTest guid: (GUID fromString: '{D926FB10-2A5F-4801-B2D0-B96D84BA9B3C}')!
SiteIdentifierTest comment: ''!
!SiteIdentifierTest categoriesForClass!Unclassified! !
!SiteIdentifierTest methodsFor!

setUp
	identifier := SiteIdentifier 
				ip: '127.0.0.1'
				port: 80
				host: 'localhost'!

testCaseInsensitiveMatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.1'
				port: 80
				host: 'lOCaLhOST'.
	self assert: (identifier match: another)!

testCurrentUrl
	self assert: identifier currentUrl = 'http://localhost'.
		identifier := SiteIdentifier 
				ip: '127.0.0.1'
				port: 81
				host: 'localhost'.
	self assert: identifier currentUrl = 'http://localhost:81'!

testHostMismatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.1'
				port: 80
				host: 'thisIsMyMachine'.
	self deny: (identifier match: another)!

testIPMismatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.2'
				port: 80
				host: 'localhost'.
	self deny: (identifier match: another)!

testMatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.1'
				port: 80
				host: 'localhost'.
	self assert: (identifier match: another)!

testPortMismatch
	| another |
	another := SiteIdentifier 
				ip: '127.0.0.1'
				port: 81
				host: 'localhost'.
	self deny: (identifier match: another)! !
!SiteIdentifierTest categoriesFor: #setUp!public!running! !
!SiteIdentifierTest categoriesFor: #testCaseInsensitiveMatch!public!testing! !
!SiteIdentifierTest categoriesFor: #testCurrentUrl!public!testing! !
!SiteIdentifierTest categoriesFor: #testHostMismatch!public!testing! !
!SiteIdentifierTest categoriesFor: #testIPMismatch!public!testing! !
!SiteIdentifierTest categoriesFor: #testMatch!public!testing! !
!SiteIdentifierTest categoriesFor: #testPortMismatch!public!testing! !

SiteTest guid: (GUID fromString: '{CA0F9353-B640-4835-8563-0F94DF2594F2}')!
SiteTest comment: ''!
!SiteTest categoriesForClass!Unclassified! !
!SiteTest methodsFor!

addSecondAlias
	site addAlias: (SiteIdentifier 
				ip: '127.0.0.2'
				port: 8202
				host: 'swazoo2.org')!

setUp
	super setUp.
	site := Site new.
	site addAlias: (SiteIdentifier
			ip: '127.0.0.1'
			port: 8200
			host: 'swazoo.org')!

testCurrentUrl
	site currentUrl = 'http://swazoo.org:8200'.
	self addSecondAlias.
	site currentUrl = 'http://swazoo.org:8200'.!

testCurrentUrl80
	| aSite |
	aSite := Site new.
	aSite addAlias: (SiteIdentifier
			ip: '127.0.0.1'
			port: 80
			host: 'swazoo.org').
	aSite currentUrl = 'http://swazoo.org'.
	aSite currentUrl = 'http://swazoo.org'! !
!SiteTest categoriesFor: #addSecondAlias!public!running! !
!SiteTest categoriesFor: #setUp!public!running! !
!SiteTest categoriesFor: #testCurrentUrl!public!testing! !
!SiteTest categoriesFor: #testCurrentUrl80!public!testing! !

SwazooActivePageResourceTest guid: (GUID fromString: '{6DB99909-8FD8-446E-BF51-2E96698082EB}')!
SwazooActivePageResourceTest comment: ''!
!SwazooActivePageResourceTest categoriesForClass!Unclassified! !
!SwazooActivePageResourceTest methodsFor!

setUp
	| fn |
	fn := 'sapTestDir' asFilename.
	fn makeDirectory.
	(fn construct: 'file.sap') writeStream close.
	(fn construct: 'file.html') writeStream close.
	resource := SwazooActivePageResource uriPattern: 'saps'
				filePath: 'sapTestDir'!

tearDown
	| fn |
	fn := 'sapTestDir' asFilename.
	(fn construct: 'file.sap') delete.
	(fn construct: 'file.html') delete.
	fn delete!

testInterpretedFile
	| request response |
	request := HTTPGet request: 'saps/file.sap'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200!

testUninterpretedFile
	| request response |
	request := HTTPGet request: 'saps/file.html'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil! !
!SwazooActivePageResourceTest categoriesFor: #setUp!public!running! !
!SwazooActivePageResourceTest categoriesFor: #tearDown!public!running! !
!SwazooActivePageResourceTest categoriesFor: #testInterpretedFile!public!running! !
!SwazooActivePageResourceTest categoriesFor: #testUninterpretedFile!public!running! !

SwazooActivePageTest guid: (GUID fromString: '{5534EBBF-34E8-45AC-9F3C-11B7BEFB94C5}')!
SwazooActivePageTest comment: ''!
!SwazooActivePageTest categoriesForClass!Unclassified! !
!SwazooActivePageTest methodsFor!

setUp
	page := SwazooActivePage new!

testMethodInvocation
	| rs |
	rs := ReadStream 
				on: '<HTML><? 1 to: 5 do: [:i | ?><H1>Paragraph <? ws print: i. ?></H1><? ]. ?></HTML>'.
	self assert: (page invokeMethodFrom: rs) 
				= '<HTML><H1>Paragraph 1</H1><H1>Paragraph 2</H1><H1>Paragraph 3</H1><H1>Paragraph 4</H1><H1>Paragraph 5</H1></HTML>'! !
!SwazooActivePageTest categoriesFor: #setUp!public!running! !
!SwazooActivePageTest categoriesFor: #testMethodInvocation!public!running! !

SwazooCacheControlTest guid: (GUID fromString: '{D7DE70B9-A896-434E-B6D8-F425EA26E2B4}')!
SwazooCacheControlTest comment: ''!
!SwazooCacheControlTest categoriesForClass!Unclassified! !
!SwazooCacheControlTest methodsFor!

setUp
	| directory firstFile ws |
	directory := 'fResTest' asFilename.
	directory exists ifFalse: [directory makeDirectory].
	firstFile := directory construct: 'abc.html'.
	ws := firstFile writeStream.
	[ws nextPutAll: 'hello'] ensure: [ws close].
	resource := FileResource uriPattern: 'foo' filePath: 'fResTest'.
	request := HTTPGet request: 'foo/abc.html'.
	URIResolution resolveRequest: request startingAt: resource.
	cacheControl := SwazooCacheControl new request: request
				cacheTarget: (cacheTarget := resource fileFor: request)!

tearDown
	('fResTest' asFilename construct: 'abc.html') delete.
	'fResTest' asFilename delete!

testIfModifiedSinceModified
	| response |
	request := HTTPGet request: 'foo/abc.html'.
	request addHeaderName: 'If-Modified-Since' value: 'blah'.
	cacheControl := SwazooCacheControl new request: request
				cacheTarget: cacheTarget.
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfModifiedSince.
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self assert: (response headerValueOrNil: 'ETag') = cacheTarget etag.
	self assert: (response headerValueOrNil: 'Last-Modified') 
				= cacheTarget lastModified!

testIfModifiedSinceNot
	| response |
	request addHeaderName: 'If-Modified-Since' value: cacheTarget lastModified.
	self assert: cacheControl isNotModified.
	self assert: cacheControl isIfModifiedSince not.
	response := HTTPResponse notModified.
	cacheControl addResponseHeaders: response.
	self assert: (response headerValueOrNil: 'ETag') = cacheTarget etag.
	self assert: (response headerValueOrNil: 'Last-Modified') 
				= cacheTarget lastModified!

testIfNoneMatchHeaderMatch
	"same etag"

	| response |
	request addHeaderName: 'If-None-Match' value: cacheTarget etag.
	self assert: cacheControl isNotModified.
	self deny: cacheControl isIfNoneMatch.

	"do NOT include last-modified"
	response := HTTPResponse notModified.
	cacheControl addResponseHeaders: response.
	self assert: (response headerValueOrNil: 'ETag') = cacheTarget etag.
	self assert: (response headerValueOrNil: 'Last-Modified') isNil!

testIfNoneMatchHeaderNone
	"same etag"

	| response |
	request := HTTPGet request: 'foo/abc.html'.
	request addHeaderName: 'If-None-Match' value: 'blah'.
	cacheControl := SwazooCacheControl new request: request
				cacheTarget: cacheTarget.
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfNoneMatch.
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self assert: (response headerValueOrNil: 'ETag') = cacheTarget etag.
	self assert: (response headerValueOrNil: 'Last-Modified') 
				= cacheTarget lastModified!

testNoHeaders
	| response |
	self assert: cacheControl isNotModified not.
	self assert: cacheControl isIfNoneMatch.
	self assert: cacheControl isIfModifiedSince.

	"add both"
	response := HTTPResponse ok.
	cacheControl addResponseHeaders: response.
	self assert: (response headerValueOrNil: 'ETag') = cacheTarget etag.
	self assert: (response headerValueOrNil: 'Last-Modified') 
				= cacheTarget lastModified! !
!SwazooCacheControlTest categoriesFor: #setUp!public!running! !
!SwazooCacheControlTest categoriesFor: #tearDown!public!running! !
!SwazooCacheControlTest categoriesFor: #testIfModifiedSinceModified!public!running! !
!SwazooCacheControlTest categoriesFor: #testIfModifiedSinceNot!public!running! !
!SwazooCacheControlTest categoriesFor: #testIfNoneMatchHeaderMatch!public!running! !
!SwazooCacheControlTest categoriesFor: #testIfNoneMatchHeaderNone!public!running! !
!SwazooCacheControlTest categoriesFor: #testNoHeaders!public!running! !

SwazooConfigurationTest guid: (GUID fromString: '{B68752E1-E378-4189-B35C-D5C417F2BD6A}')!
SwazooConfigurationTest comment: ''!
!SwazooConfigurationTest categoriesForClass!Unclassified! !
!SwazooConfigurationTest methodsFor!

testCompositeResourceSite
	| rs site composite howdy duh hithere |
	rs := ReadStream 
				on: '<Site>
 <CompositeResource uriPattern: ''/''>
  <HelloWorldResource uriPattern: ''howdy''>
  <CompositeResource uriPattern: ''duh''>
   <HelloWorldResource uriPattern: ''hithere''>
  </CompositeResource>
 </CompositeResource>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	composite := site children first.
	self assert: composite class == CompositeResource.
	self assert: composite uriPattern = '/'.
	self assert: composite children size = 2.
	self assert: composite parent == site.
	howdy := composite children first.
	self assert: howdy class == HelloWorldResource.
	self assert: howdy uriPattern = 'howdy'.
	self assert: howdy parent == composite.
	duh := composite children last.
	self assert: duh children size = 1.
	self assert: duh class == CompositeResource.
	self assert: duh uriPattern = 'duh'.
	self assert: duh parent == composite.
	hithere := duh children first.
	self assert: hithere class == HelloWorldResource.
	self assert: hithere uriPattern = 'hithere'.
	self assert: hithere parent == duh.!

testEmptySite
	| rs site alias |
	rs := ReadStream 
				on: '<Site>
 <SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site aliases size = 1.
	self assert: site currentUrl = 'http://swazoo.org/'.
	alias := site aliases first.
	self assert: alias host = 'swazoo.org'.
	self assert: alias ip = '192.168.1.66'.
	self assert: alias port = 80!

testFileResourceSite
	| rs site resource |
	rs := ReadStream 
				on: '<Site>
<SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''>
 <FileResource uriPattern: ''/'' filePath: ''files''>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	resource := site children first.
	self assert: resource class == FileResource.
	self assert: resource uriPattern = '/'.
	self assert: resource filePath = 'files'.
	self assert: resource parent == site.
	self assert: resource currentUrl = 'http://swazoo.org/'.!

testMultipleResourcesSite
	| rs site resource1 resource2 |
	rs := ReadStream 
				on: '<Site>
 <HelloWorldResource uriPattern: ''/''>
 <HelloWorldResource uriPattern: ''/''>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site children size = 2.
	resource1 := site children first.
	self assert: resource1 class == HelloWorldResource.
	self assert: resource1 uriPattern = '/'.
	resource2 := site children last.
	self assert: resource2 class == HelloWorldResource.
	self assert: resource2 uriPattern = '/'!

testMultipleSites
	| rs sites site alias1 alias2 |
	rs := ReadStream 
				on: '<Site>
 <SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''>
 <SiteIdentifier ip: ''192.168.1.66'' port: 81 host: ''swazoo.org''>
</Site>
<Site>
</Site>'.
	sites := SwazooServer readSitesFrom: rs.
	self assert: sites size = 2.
	site := sites first.
	self assert: site aliases size = 2.
	alias1 := site aliases first.
	self assert: alias1 host = 'swazoo.org'.
	self assert: alias1 ip = '192.168.1.66'.
	self assert: alias1 port = 80.
	alias2 := site aliases last.
	self assert: alias2 host = 'swazoo.org'.
	self assert: alias2 ip = '192.168.1.66'.
	self assert: alias2 port = 81!

testSingleResourceSite
	| rs site resource |
	rs := ReadStream on: '<Site>
<SiteIdentifier ip: ''192.168.1.66'' port: 80 host: ''swazoo.org''>
 <HelloWorldResource uriPattern: ''/''>
</Site>'.
	site := Site new readFrom: rs.
	self assert: site children size = 1.
	resource := site children first.
	self assert: resource class == HelloWorldResource.
	self assert: resource uriPattern = '/'.
	self assert: resource parent == site.
	self assert: resource currentUrl = 'http://swazoo.org/'.!

testSiteTag
	| rs config tag |
	rs := ReadStream on: '  <Site>  

</Site>   '.
	config := Site new.
	tag := config nextTagFrom: rs.
	self assert: tag = 'Site'.
	tag := config nextTagFrom: rs.
	self assert: tag = '/Site'.
	self assert: (config nextTagFrom: rs) isNil! !
!SwazooConfigurationTest categoriesFor: #testCompositeResourceSite!public!testing! !
!SwazooConfigurationTest categoriesFor: #testEmptySite!public!testing! !
!SwazooConfigurationTest categoriesFor: #testFileResourceSite!public!testing! !
!SwazooConfigurationTest categoriesFor: #testMultipleResourcesSite!public!testing! !
!SwazooConfigurationTest categoriesFor: #testMultipleSites!public!testing! !
!SwazooConfigurationTest categoriesFor: #testSingleResourceSite!public!testing! !
!SwazooConfigurationTest categoriesFor: #testSiteTag!public!testing! !

SwazooResourceTest guid: (GUID fromString: '{B54FF3E6-84CC-4E08-9ED9-713CD0BB5B7A}')!
SwazooResourceTest comment: ''!
!SwazooResourceTest categoriesForClass!Unclassified! !
!SwazooResourceTest methodsFor!

basicGet: uri
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET ', uri, ' HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: swazoo.org'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

basicGetUri: uriString
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET ' , uriString , ' HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: swazoo.org'.
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

basicGetUri: uriString host: hostname port: port 
	| ws |
	ws := WriteStream on: String new.
	ws nextPutAll: 'GET ' , uriString , ' HTTP/1.1'.
	self crlfOn: ws.
	ws nextPutAll: 'Host: ' , hostname.
	port notNil 
		ifTrue: 
			[ws
				nextPut: $:;
				print: port].
	self crlfOn: ws.
	self crlfOn: ws.
	^HTTPRequest readFrom: (ReadStream on: ws contents)!

crlfOn: aStream 
	aStream
		nextPut: Character cr;
		nextPut: Character lf!

setUp
	resource := SwazooResource uriPattern: 'foo'!

testEmptyURIPatternInvalid
	resource uriPattern: ''.
	self deny: resource isValidlyConfigured!

testEnabledByDefault
	self assert: resource isEnabled!

testNilURIPatternDoesNothing
	| pattern |
	pattern := resource uriPattern.
	resource uriPattern: nil.
	self assert: resource uriPattern = pattern!

testValidlyConfigured
	self assert: resource isValidlyConfigured! !
!SwazooResourceTest categoriesFor: #basicGet:!private! !
!SwazooResourceTest categoriesFor: #basicGetUri:!private! !
!SwazooResourceTest categoriesFor: #basicGetUri:host:port:!private! !
!SwazooResourceTest categoriesFor: #crlfOn:!private! !
!SwazooResourceTest categoriesFor: #setUp!public!running! !
!SwazooResourceTest categoriesFor: #testEmptyURIPatternInvalid!public!testing! !
!SwazooResourceTest categoriesFor: #testEnabledByDefault!public!testing! !
!SwazooResourceTest categoriesFor: #testNilURIPatternDoesNothing!public!testing! !
!SwazooResourceTest categoriesFor: #testValidlyConfigured!public!testing! !

SwazooServerTest guid: (GUID fromString: '{49BCA9E0-6427-4F25-ABE7-45C17EDD3245}')!
SwazooServerTest comment: ''!
!SwazooServerTest categoriesForClass!Unclassified! !
!SwazooServerTest methodsFor!

setUp
	super setUp.
	server := SwazooServer singleton.
	server initialize!

tearDown
	super tearDown.
	server 
		stop;
		initialize.!

testAccessingSite
	| site |
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self assert: (SwazooServer siteNamed: 'test') notNil.
	site := SwazooServer siteNamed: 'test'.
	self assert: (site name = 'test').
	self assert: (SwazooServer siteHostnamed: 'test.org') notNil.
	site := SwazooServer siteHostnamed: 'test.org'.
	self assert: (site host = 'test.org').!

testAddingSite
	| site |
	self assert: server sites size = 0.
	self assert: (server siteNamed: 'test') isNil.
	self assert: (server siteHostnamed: 'test.org') isNil.
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self assert: (server siteNamed: 'test') notNil.
	self assert: (server siteHostnamed: 'test.org') notNil.
	server removeSite: site.
	self assert: server sites size = 0.!

testDuplicateNames
	| site |
	site := Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80.
	server addSite: site.
	self should: [site name: 'test'] raise: Error.
	self should: [site host: 'test.org'] raise: Error.
	self should: [Site new name: 'test';
		host: 'test.org' ip: 'localhost' port: 80] raise: Error.!

testStartingSite
	| site |
	site := Site new name: 'test'; host: 'test.org' ip: 'localhost' port: 8765.
	server addSite: site.
	self assert: site isServing not.
	SwazooServer startSite: 'test'.
	self assert: server servers size = 1.
	self assert: site isServing.
	SwazooServer stopSite: 'test'.
	self assert: site isServing not.
	self assert: server servers size = 0.! !
!SwazooServerTest categoriesFor: #setUp!public!running! !
!SwazooServerTest categoriesFor: #tearDown!public!running! !
!SwazooServerTest categoriesFor: #testAccessingSite!public!testing! !
!SwazooServerTest categoriesFor: #testAddingSite!public!testing! !
!SwazooServerTest categoriesFor: #testDuplicateNames!public!testing! !
!SwazooServerTest categoriesFor: #testStartingSite!public!testing! !

SwazooSessionTest guid: (GUID fromString: '{0BE7A523-D6E3-431B-908F-62CFB77CF8C7}')!
SwazooSessionTest comment: ''!
!SwazooSessionTest categoriesForClass!Unclassified! !
!SwazooSessionTest methodsFor!

setUp
	session := SwazooSession new.
	session at: #testKey put: #testValue!

testAtIfAbsent
	self assert: (session at: #testKey ifAbsent: [#foo]) == #testValue.
	self assert: (session at: #foo ifAbsent: [#bar]) == #bar!

testAtIfAbsentPut
	self assert: (session at: #testKey ifAbsentPut: [#foo]) == #testValue.
	self assert: (session at: #foo ifAbsentPut: [#bar]) == #bar.
	self assert: (session at: #foo) == #bar!

testIncludesKey
	self assert: (session includesKey: #testKey).
	self deny: (session includesKey: #bar)!

testRemoveKey
	session removeKey: #testKey.
	self deny: (session includesKey: #testKey).
	session removeKey: #bar! !
!SwazooSessionTest categoriesFor: #setUp!public!running! !
!SwazooSessionTest categoriesFor: #testAtIfAbsent!public!running! !
!SwazooSessionTest categoriesFor: #testAtIfAbsentPut!public!running! !
!SwazooSessionTest categoriesFor: #testIncludesKey!As yet unclassified!public! !
!SwazooSessionTest categoriesFor: #testRemoveKey!As yet unclassified!public! !

SwazooStreamTest guid: (GUID fromString: '{7AA22C10-552D-4E09-829D-EF3A7FB1BCC5}')!
SwazooStreamTest comment: ''!
!SwazooStreamTest categoriesForClass!Unclassified! !
!SwazooStreamTest methodsFor!

setUp
	| pair |
	pair := SwazooStream connectedPair.
	input := pair first.
	output := pair last!

tearDown
	input close.
	output close!

testConnectedPair
	(Array with: input with: output) 
		do: [:each | self assert: (each isKindOf: SwazooStream)]!

testErrorOnInputClose
	self should: 
			[input close.
			output next]
		raise: Error!

testNextPut
	#($A $M $Y $b $r $z) do: 
			[:each | 
			self assert: (input nextPut: each) = each.
			input flush.
			self assert: output next = each]!

testNextPutAll
	#('123' 'abc' 'swazoo') do: 
			[:each | 
			self assert: (input nextPutAll: each) = each.
			input flush.
			self assert: (output next: each size) = each]!

testNextPutByte
	| bytes |
	bytes := ByteArray 
				with: 6
				with: 5
				with: 0
				with: 2.
	bytes do: 
			[:each | 
			self assert: (input nextPutByte: each) = each.
			input flush.
			self assert: output nextByte = each]!

testNextPutBytes
	| bytes1 bytes2 bytes3 |
	bytes1 := ByteArray withAll: #(1 2 3 4).
	bytes2 := ByteArray withAll: #(5 4 3 2 1).
	bytes3 := ByteArray withAll: #(1 1 2 3 5).
	(Array 
		with: bytes1
		with: bytes2
		with: bytes3) do: 
				[:each | 
				self assert: (input nextPutBytes: each) = each.
				input flush.
				self assert: (output nextBytes: each size) = each]!

testPeek
	#($K $J $D $j $m $z) do: 
			[:each | 
			input nextPut: each.
			input flush.
			self assert: output peek = each.
			output next]!

testPeekByte
	| bytes |
	bytes := ByteArray withAll: #(5 2 8 4 11 231).
	bytes do: 
			[:each | 
			input nextPutByte: each.
			input flush.
			self assert: output peekByte = each.
			output nextByte]! !
!SwazooStreamTest categoriesFor: #setUp!public!testing! !
!SwazooStreamTest categoriesFor: #tearDown!public!testing! !
!SwazooStreamTest categoriesFor: #testConnectedPair!public!testing! !
!SwazooStreamTest categoriesFor: #testErrorOnInputClose!public!testing! !
!SwazooStreamTest categoriesFor: #testNextPut!public!testing! !
!SwazooStreamTest categoriesFor: #testNextPutAll!public!testing! !
!SwazooStreamTest categoriesFor: #testNextPutByte!public!testing! !
!SwazooStreamTest categoriesFor: #testNextPutBytes!public!testing! !
!SwazooStreamTest categoriesFor: #testPeek!public!testing! !
!SwazooStreamTest categoriesFor: #testPeekByte!public!testing! !

SwazooURITest guid: (GUID fromString: '{FAB23D50-E854-4B54-B40A-058136B49E85}')!
SwazooURITest comment: ''!
!SwazooURITest categoriesForClass!Unclassified! !
!SwazooURITest methodsFor!

setUp
	fooURI := (SwazooURI new)
				hostname: 'www.foo.com';
				identifier: '/index.html'.
	queryURI := (SwazooURI new)
				hostname: 'www.foo.com';
				identifier: '/index.html';
				queries: 'foo=1&bar=hi'.
	barURI := (SwazooURI new)
				hostname: 'www.bar.com';
				identifier: '/files/';
				port: 8080!

testHostname
	self assert: fooURI hostname = 'www.foo.com'.
	self assert: queryURI hostname = 'www.foo.com'.
	self assert: barURI hostname = 'www.bar.com'!

testIdentifier
	self assert: fooURI identifier = '/index.html'.
	self assert: queryURI identifier = '/index.html'.
	self assert: barURI identifier = '/files/'!

testIdentifierPath
	self assert: fooURI identifierPath 
				= (OrderedCollection with: '/' with: 'index.html').
	self assert: queryURI identifierPath 
				= (OrderedCollection with: '/' with: 'index.html').
	self 
		assert: barURI identifierPath = (OrderedCollection with: '/' with: 'files')!

testIsDirectory
	self deny: fooURI isDirectory.
	self deny: queryURI isDirectory.
	self assert: barURI isDirectory!

testPort
	self assert: fooURI port = 80.
	self assert: queryURI port = 80.
	self assert: barURI port = 8080!

testQueries
	self deny: (queryURI includesQuery: 'hi').
	self assert: (queryURI includesQuery: 'foo').
	self assert: (queryURI includesQuery: 'bar').
	self assert: (queryURI queryAt: 'foo') = '1'.
	self assert: (queryURI queryAt: 'bar') = 'hi'!

testValue
	self assert: fooURI value = 'http://www.foo.com/index.html'.
	self assert: queryURI value = 'http://www.foo.com/index.html?foo=1&bar=hi'.
	self assert: barURI value = 'http://www.bar.com:8080/files/'! !
!SwazooURITest categoriesFor: #setUp!public!running! !
!SwazooURITest categoriesFor: #testHostname!public!running! !
!SwazooURITest categoriesFor: #testIdentifier!public!running! !
!SwazooURITest categoriesFor: #testIdentifierPath!public!running! !
!SwazooURITest categoriesFor: #testIsDirectory!public!running! !
!SwazooURITest categoriesFor: #testPort!public!running! !
!SwazooURITest categoriesFor: #testQueries!public!running! !
!SwazooURITest categoriesFor: #testValue!public!running! !

URIResolutionTest guid: (GUID fromString: '{35A52A56-8D20-4BF1-A8BB-560C8FAEE3D6}')!
URIResolutionTest comment: ''!
!URIResolutionTest categoriesForClass!Unclassified! !
!URIResolutionTest methodsFor!

testCompositeAnswer
	| resource request response |
	resource := CompositeResource uriPattern: 'base'.
	resource addResource: (HelloWorldResource uriPattern: 'hi').
	request := HTTPGet request: 'base/hi'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 2.
	self assert: request resourcePath first = 'base'.
	self assert: request resourcePath last = 'hi'!

testCompositeItselfCannotAnswer
	| resource request response |
	resource := CompositeResource uriPattern: 'base'.
	request := HTTPGet request: 'base'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil!

testCompositeNoAnswer
	| resource request response |
	resource := CompositeResource uriPattern: 'base'.
	resource addResource: (HelloWorldResource uriPattern: 'hi').
	request := HTTPGet request: 'tail/hi'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil!

testFirstCompositeChildWins
	| request hello goodbye response composite |
	composite := CompositeResource uriPattern: 'foo'.
	hello := HelloWorldResource new uriPattern: 'something.html'.
	goodbye := GoodbyeCruelWorld new uriPattern: 'something.html'.
	composite addResource: hello.
	composite addResource: goodbye.
	request := HTTPGet request: 'foo/something.html'.
	response := URIResolution resolveRequest: request startingAt: composite.
	self assert: response code = 200.
	self assert: request resourcePath size = 2.
	self assert: request resourcePath first = 'foo'.
	self assert: request resourcePath last = 'something.html'!

testLeafAnswer
	| resource request response |
	resource := HelloWorldResource uriPattern: 'hi'.
	request := HTTPGet request: 'hi'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = 'hi'!

testNoAnswerWhenDisabled
	| resource request response |
	resource := HelloWorldResource uriPattern: 'hi'.
	resource disable.
	request := HTTPGet request: 'hi'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response isNil!

testResourcePath
	| request resolution |
	request := HTTPGet 
				request: 'foo/bar/baz/quux'
				from: 'localhost:1234'
				at: '1.2.3.4'.
	resolution := URIResolution new initializeRequest: request.
	self assert: resolution resourcePath = #('foo') asOrderedCollection.
	resolution advance.
	self assert: resolution resourcePath = #('foo' 'bar') asOrderedCollection.
	resolution advance.
	self 
		assert: resolution resourcePath = #('foo' 'bar' 'baz') asOrderedCollection.
	resolution advance.
	self assert: resolution resourcePath = #('foo' 'bar' 'baz' 'quux') asOrderedCollection!

testSiteAnswer
	| resource request response |
	resource := Site new addAlias: (SiteIdentifier
					ip: '1.2.3.4'
					port: 80
					host: 'foo.com').
	resource addResource: (HelloWorldResource uriPattern: '/').
	request := HTTPGet
				request: '/'
				from: 'foo.com'
				at: '1.2.3.4'.
	response := URIResolution resolveRequest: request startingAt: resource.
	self assert: response code = 200.
	self assert: request resourcePath size = 1.
	self assert: request resourcePath first = '/'!

testSiteMatch
	| request site visitor |
	request := HTTPGet 
				request: 'foo'
				from: 'localhost:1234'
				at: '1.2.3.4'.
	visitor := URIResolution new initializeRequest: request.
	site := Site new addAlias: (SiteIdentifier 
						ip: '1.2.3.4'
						port: 1234
						host: 'localhost').
	self assert: (visitor siteMatch: site)!

testSiteMismatch
	| request site visitor |
	request := HTTPGet 
				request: 'foo'
				from: 'localhost:1234'
				at: '1.2.3.4'.
	visitor := URIResolution new initializeRequest: request.
	site := Site new addAlias: (SiteIdentifier 
						ip: '1.2.3.4'
						port: 1234
						host: 'remotehost').
	self deny: (visitor siteMatch: site)!

testStringMatch
	| request visitor resource |
	request := HTTPGet request: 'foo'.
	visitor := URIResolution new initializeRequest: request.
	resource := HelloWorldResource uriPattern: 'foo'.
	self assert: (visitor stringMatch: resource)!

testStringMismatch
	| request visitor resource |
	request := HTTPGet request: 'foo'.
	visitor := URIResolution new initializeRequest: request.
	resource := HelloWorldResource uriPattern: 'Foo'.
	self deny: (visitor stringMatch: resource)!

testTailPath
	| request resolution |
	request := HTTPGet 
				request: 'foo/bar/baz/quux'
				from: 'localhost:1234'
				at: '1.2.3.4'.
	resolution := URIResolution new initializeRequest: request.
	self 
		assert: resolution tailPath = #('bar' 'baz' 'quux') asOrderedCollection.
	resolution advance.
	self assert: resolution tailPath = #('baz' 'quux') asOrderedCollection.
	resolution advance.
	self assert: resolution tailPath = #('quux') asOrderedCollection.
	resolution advance.
	self assert: resolution tailPath isEmpty! !
!URIResolutionTest categoriesFor: #testCompositeAnswer!public!testing! !
!URIResolutionTest categoriesFor: #testCompositeItselfCannotAnswer!public!testing! !
!URIResolutionTest categoriesFor: #testCompositeNoAnswer!public!testing! !
!URIResolutionTest categoriesFor: #testFirstCompositeChildWins!public!testing! !
!URIResolutionTest categoriesFor: #testLeafAnswer!public!testing! !
!URIResolutionTest categoriesFor: #testNoAnswerWhenDisabled!public!testing! !
!URIResolutionTest categoriesFor: #testResourcePath!public!testing! !
!URIResolutionTest categoriesFor: #testSiteAnswer!public!testing! !
!URIResolutionTest categoriesFor: #testSiteMatch!public!testing! !
!URIResolutionTest categoriesFor: #testSiteMismatch!public!testing! !
!URIResolutionTest categoriesFor: #testStringMatch!public!testing! !
!URIResolutionTest categoriesFor: #testStringMismatch!public!testing! !
!URIResolutionTest categoriesFor: #testTailPath!public!testing! !

"Binary Globals"!

