| package |
package := Package name: 'Swazoo-Platform'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: '0.027'.


package classNames
	add: #HtmlEncodingPolicy;
	add: #HTTPEncodingPolicy;
	add: #SwazooCompiler;
	add: #SwazooPlatform;
	add: #SwazooSocket;
	add: #UrlEncodingPolicy;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\..\Object Arts\Dolphin\Base\Dolphin';
	add: 'Smalltalk-Dialect';
	yourself).

package!

"Class Definitions"!

Object subclass: #HTTPEncodingPolicy
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooCompiler
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooPlatform
	instanceVariableNames: ''
	classVariableNames: 'Current'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooSocket
	instanceVariableNames: 'socket platform'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPEncodingPolicy subclass: #HtmlEncodingPolicy
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
HTTPEncodingPolicy subclass: #UrlEncodingPolicy
	instanceVariableNames: ''
	classVariableNames: 'UrlEncodingTable'
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

HTTPEncodingPolicy guid: (GUID fromString: '{D4913860-31A4-4098-83BA-81D194E7F8FC}')!
HTTPEncodingPolicy comment: ''!
!HTTPEncodingPolicy categoriesForClass!Unclassified! !
!HTTPEncodingPolicy methodsFor!

decode: aString
	| readStream writeStream |
	readStream := aString readStream.
	writeStream := aString class writeStream: aString size.
	[ readStream atEnd ] whileFalse: [ self decodeFrom: readStream onto: writeStream ].
	^writeStream contents!

decodeFrom: readStream onto: writeStream 
	^self subclassResponsibility!

encode: aString
	| stream |
	stream := aString class writeStream: aString size.
	aString do: [ :ea | self encodeCharacter: ea onto: stream ].
	^stream contents!

encodeCharacter: aCharacter onto: stream 
	^self subclassResponsibility! !
!HTTPEncodingPolicy categoriesFor: #decode:!public! !
!HTTPEncodingPolicy categoriesFor: #decodeFrom:onto:!private! !
!HTTPEncodingPolicy categoriesFor: #encode:!public! !
!HTTPEncodingPolicy categoriesFor: #encodeCharacter:onto:!private! !

SwazooCompiler guid: (GUID fromString: '{9EBF9086-397E-48AE-B24F-74EBA4637A98}')!
SwazooCompiler comment: ''!
!SwazooCompiler categoriesForClass!Unclassified! !
!SwazooCompiler class methodsFor!

evaluate: aString
	^SwazooPlatform current compilerEvaluate: aString!

evaluate: aString receiver: anObject
	^SwazooPlatform current compilerEvaluate: aString receiver: anObject! !
!SwazooCompiler class categoriesFor: #evaluate:!public! !
!SwazooCompiler class categoriesFor: #evaluate:receiver:!public! !

SwazooPlatform guid: (GUID fromString: '{BE0CA9D6-EB83-4FE1-98A1-5C68BC12624A}')!
SwazooPlatform comment: ''!
!SwazooPlatform categoriesForClass!Unclassified! !
!SwazooPlatform methodsFor!

base64DecodeAsString: aString 
	!

collection: aCollection tokensBasedOnAll: anArray
!

compactingGC
	!

compilerEvaluate: aString
	^Compiler evaluate: aString for: nil logged: false!

compilerEvaluate: aString receiver: anObject
	^Compiler evaluate: aString for: anObject logged: false!

isCharacterHTTPReserved: aCharacter
	^(aCharacter isAlphaNumeric or: ['-_.!!~*''()' includes: aCharacter]) not!

md5Hash: aStringOrByteArray
!

newRandomString: anIntegerSize
	| numbersThroughAlphas ws char random |
	numbersThroughAlphas := (48 to: 122) collect: [:each | each asCharacter].
	ws := WriteStream on: (String new: anIntegerSize).
	random := Random new.
	[ws contents size < anIntegerSize] whileTrue: 
			[char := numbersThroughAlphas 
						at: (random next * (numbersThroughAlphas size - 1)) rounded + 1.
			char isAlphaNumeric ifTrue: [ws nextPut: char]].
	^ws contents!

newTCPServer
	"On some platforms (Dolphin) there are separate classes for Sockets and Server Sockets"!

newTCPSocket!

numberAsString: aNumber
	| s |
	s := WriteStream on: String new.
	aNumber printOn: s.
	^s contents!

quickGC
	!

socket: aSocket connectToHostNamed: aStringHost port: anIntegerPort!

socket: aSocket listenFor: anIntegerBacklog!

socket: aSocket listenOn: anIntegerPort backlogSize: anIntegerBacklog!

socket: aSocket read: anIntegerSize!

socket: aSocket read: anIntegerSize timeout: anIntegerTimeout!

socket: aSocket write: aByteArray!

socketAccept: aSocket
	!

socketClose: aSocket
	!

socketLocalAddress: aSocket!

socketPeerAddress: aSocket!

stream: aGettableStream upToAll: aCollection
	"Needs to be implemented differently for Dolphin and Squeak. VW has different behaviour."
	^aGettableStream upToAll: aCollection!

streamNextLine: aGettableStream
	^aGettableStream nextLine!

string: aString tokensBasedOn: anObject
	^aString tokensBasedOn: anObject!

stringWithInternetLineEndings: aString!

stringWithUnixLineEndings: aString!

timestampNow
!

trimBlanks: aString
	^aString trimBlanks!

urlDecode: aString
	^UrlEncodingPolicy new decode: aString!

urlEncode: aString
	^UrlEncodingPolicy new encode: aString! !
!SwazooPlatform categoriesFor: #base64DecodeAsString:!public! !
!SwazooPlatform categoriesFor: #collection:tokensBasedOnAll:!public! !
!SwazooPlatform categoriesFor: #compactingGC!public! !
!SwazooPlatform categoriesFor: #compilerEvaluate:!public! !
!SwazooPlatform categoriesFor: #compilerEvaluate:receiver:!public! !
!SwazooPlatform categoriesFor: #isCharacterHTTPReserved:!public! !
!SwazooPlatform categoriesFor: #md5Hash:!public! !
!SwazooPlatform categoriesFor: #newRandomString:!public! !
!SwazooPlatform categoriesFor: #newTCPServer!public! !
!SwazooPlatform categoriesFor: #newTCPSocket!public! !
!SwazooPlatform categoriesFor: #numberAsString:!public! !
!SwazooPlatform categoriesFor: #quickGC!public! !
!SwazooPlatform categoriesFor: #socket:connectToHostNamed:port:!public! !
!SwazooPlatform categoriesFor: #socket:listenFor:!public! !
!SwazooPlatform categoriesFor: #socket:listenOn:backlogSize:!public! !
!SwazooPlatform categoriesFor: #socket:read:!public! !
!SwazooPlatform categoriesFor: #socket:read:timeout:!public! !
!SwazooPlatform categoriesFor: #socket:write:!public! !
!SwazooPlatform categoriesFor: #socketAccept:!public! !
!SwazooPlatform categoriesFor: #socketClose:!public! !
!SwazooPlatform categoriesFor: #socketLocalAddress:!public! !
!SwazooPlatform categoriesFor: #socketPeerAddress:!public! !
!SwazooPlatform categoriesFor: #stream:upToAll:!public! !
!SwazooPlatform categoriesFor: #streamNextLine:!public! !
!SwazooPlatform categoriesFor: #string:tokensBasedOn:!public! !
!SwazooPlatform categoriesFor: #stringWithInternetLineEndings:!public! !
!SwazooPlatform categoriesFor: #stringWithUnixLineEndings:!public! !
!SwazooPlatform categoriesFor: #timestampNow!public! !
!SwazooPlatform categoriesFor: #trimBlanks:!public! !
!SwazooPlatform categoriesFor: #urlDecode:!public! !
!SwazooPlatform categoriesFor: #urlEncode:!public! !

!SwazooPlatform class methodsFor!

current
	^Current ifNil: [ Current := self discoverPlatform new ].
!

current: aPlatform
	Current := aPlatform!

discoverPlatform
	^self allSubclasses detect: [ :ea | ea platformFor: SmalltalkDialect current ] ifNone: [ self ]
!

platformFor: aDialect
	^false
! !
!SwazooPlatform class categoriesFor: #current!accessing!public! !
!SwazooPlatform class categoriesFor: #current:!accessing!private! !
!SwazooPlatform class categoriesFor: #discoverPlatform!accessing!private! !
!SwazooPlatform class categoriesFor: #platformFor:!accessing!private! !

SwazooSocket guid: (GUID fromString: '{718EEAC7-665F-4F5C-8CB7-243EB40E8416}')!
SwazooSocket comment: ''!
!SwazooSocket categoriesForClass!Unclassified! !
!SwazooSocket methodsFor!

accept
	^self class on: (platform socketAccept: socket)!

close
	platform socketClose: socket!

initializeWithSocket: aSocket 
	socket := aSocket.
	platform := self class platform.!

listenFor: anIntegerBacklog
	platform socket: socket listenFor: anIntegerBacklog!

localAddress
	^platform socketLocalAddress: socket !

read: anInteger
	^platform socket: socket read: anInteger!

read: anInteger timeout: aTimeout
	^platform socket: socket read: anInteger timeout: aTimeout!

remoteAddress
	^platform socketPeerAddress: socket!

write: aByteArray
	^platform socket: socket write: aByteArray! !
!SwazooSocket categoriesFor: #accept!public! !
!SwazooSocket categoriesFor: #close!public! !
!SwazooSocket categoriesFor: #initializeWithSocket:!private! !
!SwazooSocket categoriesFor: #listenFor:!public! !
!SwazooSocket categoriesFor: #localAddress!public! !
!SwazooSocket categoriesFor: #read:!public! !
!SwazooSocket categoriesFor: #read:timeout:!public! !
!SwazooSocket categoriesFor: #remoteAddress!public! !
!SwazooSocket categoriesFor: #write:!public! !

!SwazooSocket class methodsFor!

connectedPair
	| listener server client port |
	port := (((Random new next: 100) detect: [ :ea | ea > 0.11 ] ifNone: [ 0.21 ]) * 10000) asInteger.
	[ listener := self platform newTCPServer.
	self platform socket: listener listenOn: port backlogSize: 4.
	server := listener accept.
	listener close ] fork.
	(Delay forMilliseconds: 100) wait.
	client := self platform newTCPSocket.
	self platform socket: client connectToHostNamed: 'localhost' port: port.
	(Delay forMilliseconds: 100) wait.
	server ifNil: [self error: 'No server'].
	^Array with: (self on: server) with: (self on: client)!

connectTo: hostString port: portNumber
	| socket |
	socket := self platform newTCPSocket.
	self platform socket: socket connectToHostNamed: hostString port: portNumber.
	^self on: socket!

on: aSocket
	^self new initializeWithSocket: aSocket!

platform
	^SwazooPlatform current!

serverOnIP: aByteArray port: portNumber
	| socket |
	socket := self platform newTCPServer.
	self platform socket: socket listenOn: portNumber backlogSize: 5.
	^self on: socket! !
!SwazooSocket class categoriesFor: #connectedPair!public! !
!SwazooSocket class categoriesFor: #connectTo:port:!public! !
!SwazooSocket class categoriesFor: #on:!public! !
!SwazooSocket class categoriesFor: #platform!private! !
!SwazooSocket class categoriesFor: #serverOnIP:port:!public! !

HtmlEncodingPolicy guid: (GUID fromString: '{7E521255-99A0-47F6-893C-F5B24B83D7BB}')!
HtmlEncodingPolicy comment: ''!
!HtmlEncodingPolicy categoriesForClass!Unclassified! !
!HtmlEncodingPolicy methodsFor!

decodeFrom: readStream onto: writeStream
	| character |
	character := readStream next.
	character = $& ifTrue: [ 
		| buffer |
		readStream peek = $# ifTrue: [ 
			readStream skip: 1. 
			buffer := readStream upTo: $;.
			^writeStream nextPut: (buffer asNumber + 1) asCharacter ].
		buffer := readStream upTo: $;.
		buffer = 'amp' ifTrue: [ ^writeStream nextPut: $& ].
		buffer = 'quot' ifTrue: [ ^writeStream nextPut: $" ]. 
		buffer = 'lt' ifTrue: [ ^writeStream nextPut: $< ]. 
		buffer = 'gt' ifTrue: [ ^writeStream nextPut: $> ]. ].
	^writeStream nextPut: character!

encodeCharacter: aCharacter onto: stream
	aCharacter > $~
		ifTrue:
			[ ^stream
				nextPutAll: '&#';
				display: aCharacter asInteger - 1;
				nextPut: $; ].
	aCharacter = $" ifTrue: [ ^stream nextPutAll: '&quot;' ].
	aCharacter = $< ifTrue: [ ^stream nextPutAll: '&lt;' ].
	aCharacter = $> ifTrue: [ ^stream nextPutAll: '&gt;' ].
	aCharacter = $& ifTrue: [ ^stream nextPutAll: '&amp;' ].
	^stream nextPut: aCharacter! !
!HtmlEncodingPolicy categoriesFor: #decodeFrom:onto:!private! !
!HtmlEncodingPolicy categoriesFor: #encodeCharacter:onto:!private! !

UrlEncodingPolicy guid: (GUID fromString: '{D5466264-0CC4-43FA-B802-A3BB4325FD94}')!
UrlEncodingPolicy comment: ''!
!UrlEncodingPolicy categoriesForClass!Unclassified! !
!UrlEncodingPolicy methodsFor!

decodeFrom: readStream onto: writeStream
	| character |
	character := readStream next.
	character = $+ ifTrue: [ ^writeStream nextPut: $  ].
	character = $%
		ifTrue:
			[ ^writeStream nextPut: (Integer readFrom: (readStream next: 2) readStream radix: 16) asCharacter ].
	^writeStream nextPut: character!

encodeCharacter: aCharacter onto: stream
	(aCharacter between: $0 and: $9) ifTrue: [ ^stream nextPut: aCharacter ].
	(aCharacter between: $a and: $z) ifTrue: [ ^stream nextPut: aCharacter ].
	(aCharacter between: $A and: $Z) ifTrue: [ ^stream nextPut: aCharacter ].
	aCharacter = $  ifTrue: [ ^stream nextPut: $+ ].
	(#($- $_ $. $!! $~ $* $\ $( $)) identityIncludes: aCharacter)
		ifTrue: [ ^stream nextPut: aCharacter ].
	^stream nextPutAll: (UrlEncodingTable at: aCharacter asInteger + 1)! !
!UrlEncodingPolicy categoriesFor: #decodeFrom:onto:!private! !
!UrlEncodingPolicy categoriesFor: #encodeCharacter:onto:!private! !

!UrlEncodingPolicy class methodsFor!

initialize
	"self initialize"

	UrlEncodingTable := #('%00' '%01' '%02' '%03' '%04' '%05' '%06' '%07' '%08' '%09' '%0A' '%0B' '%0C' '%0D' '%0E' '%0F' '%10' '%11' '%12' '%13' '%14' '%15' '%16' '%17' '%18' '%19' '%1A' '%1B' '%1C' '%1D' '%1E' '%1F' '%20' '%21' '%22' '%23' '%24' '%25' '%26' '%27' '%28' '%29' '%2A' '%2B' '%2C' '%2D' '%2E' '%2F' '%30' '%31' '%32' '%33' '%34' '%35' '%36' '%37' '%38' '%39' '%3A' '%3B' '%3C' '%3D' '%3E' '%3F' '%40' '%41' '%42' '%43' '%44' '%45' '%46' '%47' '%48' '%49' '%4A' '%4B' '%4C' '%4D' '%4E' '%4F' '%50' '%51' '%52' '%53' '%54' '%55' '%56' '%57' '%58' '%59' '%5A' '%5B' '%5C' '%5D' '%5E' '%5F' '%60' '%61' '%62' '%63' '%64' '%65' '%66' '%67' '%68' '%69' '%6A' '%6B' '%6C' '%6D' '%6E' '%6F' '%70' '%71' '%72' '%73' '%74' '%75' '%76' '%77' '%78' '%79' '%7A' '%7B' '%7C' '%7D' '%7E' '%7F' '%80' '%81' '%82' '%83' '%84' '%85' '%86' '%87' '%88' '%89' '%8A' '%8B' '%8C' '%8D' '%8E' '%8F' '%90' '%91' '%92' '%93' '%94' '%95' '%96' '%97' '%98' '%99' '%9A' '%9B' '%9C' '%9D' '%9E' '%9F' '%A0' '%A1' '%A2' '%A3' '%A4' '%A5' '%A6' '%A7' '%A8' '%A9' '%AA' '%AB' '%AC' '%AD' '%AE' '%AF' '%B0' '%B1' '%B2' '%B3' '%B4' '%B5' '%B6' '%B7' '%B8' '%B9' '%BA' '%BB' '%BC' '%BD' '%BE' '%BF' '%C0' '%C1' '%C2' '%C3' '%C4' '%C5' '%C6' '%C7' '%C8' '%C9' '%CA' '%CB' '%CC' '%CD' '%CE' '%CF' '%D0' '%D1' '%D2' '%D3' '%D4' '%D5' '%D6' '%D7' '%D8' '%D9' '%DA' '%DB' '%DC' '%DD' '%DE' '%DF' '%E0' '%E1' '%E2' '%E3' '%E4' '%E5' '%E6' '%E7' '%E8' '%E9' '%EA' '%EB' '%EC' '%ED' '%EE' '%EF' '%F0' '%F1' '%F2' '%F3' '%F4' '%F5' '%F6' '%F7' '%F8' '%F9' '%FA' '%FB' '%FC' '%FD' '%FE' '%FF')! !
!UrlEncodingPolicy class categoriesFor: #initialize!public! !

"Binary Globals"!

