| package |
package := Package name: 'Swazoo-Platform-Tests'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: '0.012'.


package classNames
	add: #SwazooCompilerTest;
	add: #SwazooPlatformTest;
	add: #SwazooSocketTest;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\..\Camp Smalltalk\SUnit\SUnit';
	add: 'Swazoo';
	add: 'Swazoo-Platform';
	yourself).

package!

"Class Definitions"!

TestCase subclass: #SwazooCompilerTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooPlatformTest
	instanceVariableNames: 'platform'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooSocketTest
	instanceVariableNames: 'input output'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

SwazooCompilerTest guid: (GUID fromString: '{2C53E312-65E2-49EF-B68C-E642EE898397}')!
SwazooCompilerTest comment: ''!
!SwazooCompilerTest categoriesForClass!Unclassified! !
!SwazooCompilerTest methodsFor!

testEvaluate
	self assert: (SwazooCompiler evaluate: '1 + 2 * 3') = 9!

testEvaluateReceiver
	self assert: (SwazooCompiler evaluate: 'self + 2 * 3' receiver: 1) = 9! !
!SwazooCompilerTest categoriesFor: #testEvaluate!public! !
!SwazooCompilerTest categoriesFor: #testEvaluateReceiver!public! !

SwazooPlatformTest guid: (GUID fromString: '{76E9A43A-6085-4C5E-8125-D01B08801FE6}')!
SwazooPlatformTest comment: ''!
!SwazooPlatformTest categoriesForClass!Unclassified! !
!SwazooPlatformTest methodsFor!

createInternetString
	^(String writeStream)
		nextPutAll: 'Line One';
		nextPut: Character cr;
		nextPut: Character lf;
		nextPutAll: 'Line Two';
		nextPut: Character cr;
		nextPut: Character lf;
		contents!

createUnixString
	^(String writeStream)
		nextPutAll: 'Line One';
		nextPut: Character cr;
		nextPutAll: 'Line Two';
		nextPut: Character cr;
		contents!

setUp
	platform := SwazooPlatform current.!

tearDown
	platform := nil.
	SwazooPlatform current: nil.!

testBase64Decode
	self assert: (SwazooPlatform current base64DecodeAsString: 'QWxhZGRpbjpvcGVuIHNlc2FtZQ==') = 'Aladdin:open sesame'!

testCharacterArrayTrimBlanks
	self assert: '   a b c d e f g' trimBlanks = 'a b c d e f g'.
	self assert: 'no blanks' trimBlanks = 'no blanks'.
	self assert: ' leading' trimBlanks = 'leading'.
	self assert: 'trailing ' trimBlanks = 'trailing'.
	self assert: '' trimBlanks = ''.
	self 
		assert: (String with: Character cr with: Character lf) trimBlanks isEmpty!

testFilenameEtag
	| fn etag1 etag2 |
	fn := 'etagTest' asFilename.
	fn writeStream close.
	etag1 := fn etag.
	(Delay forSeconds: 1) wait. 
	fn writeStream close.
	etag2 := fn etag.
	
	[self
		assert: (etag1 isKindOf: String);
		assert: ('"*"' match: etag1).
	self
		assert: (etag2 isKindOf: String);
		assert: ('"*"' match: etag2).
	self deny: etag1 = etag2] 
			ensure: [fn delete]!

testMD5Hash
	self assert: (MD5Digest hash: 'a') = 'cc175b9c0f1b6a831c399e269772661'.!

testStreamUpToAll
	| stream |
	stream := 'Expected Behaviour' readStream.
	self assert: (platform stream: stream upToAll: ' ') = 'Expected'.
	self assert: stream next = $ !

testStringNewRandom
	| sizes strings |
	sizes := #(5 20 6127 2 100).
	strings := sizes collect: [:each | SwazooPlatform current newRandomString: each].
	strings with: sizes do: [:string :size | self assert: string size = size]!

testStringTokensBasedOn
	self assert: (platform string: 'Hello World' tokensBasedOn: $ ) size = 2.
	self assert: (platform string: 'Hello World ' tokensBasedOn: $ ) size = 3.
!

testStringWithInternetLineEndings
	
	self assert: (SwazooPlatform current stringWithInternetLineEndings: self createUnixString) = self createInternetString.
	
!

testStringWithUnixLineEndings
	
	self assert: (SwazooPlatform current stringWithUnixLineEndings: self createInternetString) = self createUnixString.
	
! !
!SwazooPlatformTest categoriesFor: #createInternetString!public! !
!SwazooPlatformTest categoriesFor: #createUnixString!public! !
!SwazooPlatformTest categoriesFor: #setUp!public! !
!SwazooPlatformTest categoriesFor: #tearDown!public! !
!SwazooPlatformTest categoriesFor: #testBase64Decode!public! !
!SwazooPlatformTest categoriesFor: #testCharacterArrayTrimBlanks!public!testing! !
!SwazooPlatformTest categoriesFor: #testFilenameEtag!public!testing! !
!SwazooPlatformTest categoriesFor: #testMD5Hash!public! !
!SwazooPlatformTest categoriesFor: #testStreamUpToAll!public! !
!SwazooPlatformTest categoriesFor: #testStringNewRandom!public!testing! !
!SwazooPlatformTest categoriesFor: #testStringTokensBasedOn!public! !
!SwazooPlatformTest categoriesFor: #testStringWithInternetLineEndings!public! !
!SwazooPlatformTest categoriesFor: #testStringWithUnixLineEndings!public! !

SwazooSocketTest guid: (GUID fromString: '{C5B0DFDD-A5DA-4859-AF93-A9B4A0A48118}')!
SwazooSocketTest comment: ''!
!SwazooSocketTest categoriesForClass!Unclassified! !
!SwazooSocketTest methodsFor!

setUp
	| pair |
	pair := SwazooSocket connectedPair.
	input := pair first.
	output := pair last!

tearDown
	input close.
	output close!

testConnectedPair
	(Array with: input with: output) 
		do: [:each | self assert: (each isKindOf: SwazooSocket)]!

testNetworkConnection
	| server sem |
	input close.
	output close.
	sem := Semaphore new.
	
	[server := SwazooSocket serverOnIP: '127.0.0.1' port: 65421.
	server listenFor: 50.
	
	[input := server accept.
	sem signal] fork.
	output := SwazooSocket connectTo: 'localhost' port: 65421.
	sem wait.
	self testReadWrite] 
			ensure: [server close]!

testPartialRead
	| bytes |
	bytes := ByteArray withAll: #(5 4 3).
	self assert: (input write: bytes) = 3.
	self assert: (output read: 5) = bytes!

testReadTimeout
	input write: #[1 2 3].
	self assert: (output read: 3 timeout: 40) = #[1 2 3].
	input write: #[4 5 6].
	self assert: (output read: 3 timeout: 40) = #[4 5 6].
	input write: #[7 8 9].
	self assert: (output read: 3 timeout: 40) = #[7 8 9].
	self assert: (output read: 3 timeout: 40) = ByteArray new.
	input write: #[1 2 3].
	self assert: (output read: 3 timeout: 40) = #[1 2 3].


!

testReadWrite
	| bytes |
	bytes := ByteArray withAll: #(1 2 3 4 5).
	self assert: (input write: bytes) = 5.
	self assert: (output read: 5) = bytes.
	bytes := ByteArray with: 4.
	self assert: (input write: bytes) = 1.
	self assert: (output read: 1) = bytes! !
!SwazooSocketTest categoriesFor: #setUp!public! !
!SwazooSocketTest categoriesFor: #tearDown!public!running! !
!SwazooSocketTest categoriesFor: #testConnectedPair!public! !
!SwazooSocketTest categoriesFor: #testNetworkConnection!public! !
!SwazooSocketTest categoriesFor: #testPartialRead!public!testing! !
!SwazooSocketTest categoriesFor: #testReadTimeout!public!testing! !
!SwazooSocketTest categoriesFor: #testReadWrite!public!testing! !

"Binary Globals"!

