| package |
package := Package name: 'WEB-Tests'.
package paxVersion: 1;
	basicComment: ''.


package classNames
	add: #SchedulerTest;
	add: #SwazooIntegrationTest;
	add: #URLResolverTest;
	add: #VersionedExample;
	add: #VersionedExampleApp;
	add: #VersionedObjectTest;
	add: #VersionSpecTest;
	add: #WebApplicationTest;
	add: #WebSecurityTest;
	add: #WebSessionMgmtTest;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'AIDAWeb';
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\Camp Smalltalk\SUnit\SUnit';
	add: '..\Swazoo\Swazoo';
	add: '..\Swazoo-Platform-Dolphin';
	yourself).

package!

"Class Definitions"!

TestCase subclass: #SchedulerTest
	instanceVariableNames: 'scheduler'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #SwazooIntegrationTest
	instanceVariableNames: 'server site'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #URLResolverTest
	instanceVariableNames: 'server site'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #VersionedObjectTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #VersionSpecTest
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #WebApplicationTest
	instanceVariableNames: 'server site session app request'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #WebSecurityTest
	instanceVariableNames: 'server site mgr'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
TestCase subclass: #WebSessionMgmtTest
	instanceVariableNames: 'server site session'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
VersionedObject subclass: #VersionedExample
	instanceVariableNames: 'title body'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #VersionedExampleApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

SchedulerTest guid: (GUID fromString: '{F78D97CA-B388-40C8-92DF-6257123B3948}')!
SchedulerTest comment: ''!
!SchedulerTest categoriesForClass!Unclassified! !
!SchedulerTest methodsFor!

setUp
	scheduler := Scheduler newOn: nil.
	scheduler start.!

tearDown
	scheduler stop.!

testAddingSingleEvent
	scheduler at: Timestamp now callMethod: #transcript of: self.!

testAddingSingleEvent2
	"look at Transcript!! "
	| time |
	time := Timestamp fromSeconds: (Timestamp now asSeconds + 1).
	scheduler at: time runBlock: [self transcript].
	(Delay forSeconds: 2) wait.!

testMinutePeriodicEvent
	"it should write twice to transcript in 2 minutes!! "
	scheduler everyMinuteAt: 30 runBlock: [self transcript].
"	(Delay forSeconds: 120) wait "!

testMoreMinutePeriodicEvents
	"it should write to transcript in 2 minutes!! "
	scheduler everyMinuteAt: 30 runBlock: [self transcript1].
	scheduler everyMinuteAt: 15 runBlock: [self transcript2].
	scheduler everyMinuteAt: 45 runBlock: [self transcript3].
	scheduler everyMinuteAt: 20 runBlock: [self transcript4].
"	(Delay forSeconds: 120) wait"!

testOrderOf2AscEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 15 runBlock: [self transcript1].
	scheduler everyMinuteAt: 30 runBlock: [self transcript2].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.!

testOrderOf2DescEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 30 runBlock: [self transcript1].
	scheduler everyMinuteAt: 15 runBlock: [self transcript2].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.!

testOrderOf3AscEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 15 runBlock: [self transcript1].
	scheduler everyMinuteAt: 30 runBlock: [self transcript2].
	scheduler everyMinuteAt: 45 runBlock: [self transcript3].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.
	self assert: (scheduler queue at: 3) period value = 45.!

testOrderOf3DescEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 45 runBlock: [self transcript1].
	scheduler everyMinuteAt: 30 runBlock: [self transcript2].
	scheduler everyMinuteAt: 15 runBlock: [self transcript3].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.
	self assert: (scheduler queue at: 3) period value = 45.!

testOrderOf3MixedEvents
	scheduler stop. "just testing order in queue!!"
	scheduler everyMinuteAt: 15 runBlock: [self transcript1].
	scheduler everyMinuteAt: 45 runBlock: [self transcript2].
	scheduler everyMinuteAt: 30 runBlock: [self transcript3].
	self assert: (scheduler queue at: 1) period value = 15.
	self assert: (scheduler queue at: 2) period value = 30.
	self assert: (scheduler queue at: 3) period value = 45.!

testSetup!

transcript
	Transcript cr; show: 'scheduled event'!

transcript1
	Transcript cr; show: 'scheduled event 1'!

transcript2
	Transcript cr; show: 'scheduled event 2'!

transcript3
	Transcript cr; show: 'scheduled event 3'!

transcript4
	Transcript cr; show: 'scheduled event 4'!

transcript5
	Transcript cr; show: 'scheduled event 5'! !
!SchedulerTest categoriesFor: #setUp!private!running! !
!SchedulerTest categoriesFor: #tearDown!private!running! !
!SchedulerTest categoriesFor: #testAddingSingleEvent!private!testing! !
!SchedulerTest categoriesFor: #testAddingSingleEvent2!private!testing! !
!SchedulerTest categoriesFor: #testMinutePeriodicEvent!private!testing! !
!SchedulerTest categoriesFor: #testMoreMinutePeriodicEvents!private!testing! !
!SchedulerTest categoriesFor: #testOrderOf2AscEvents!private!testing-queue order! !
!SchedulerTest categoriesFor: #testOrderOf2DescEvents!private!testing-queue order! !
!SchedulerTest categoriesFor: #testOrderOf3AscEvents!private!testing-queue order! !
!SchedulerTest categoriesFor: #testOrderOf3DescEvents!private!testing-queue order! !
!SchedulerTest categoriesFor: #testOrderOf3MixedEvents!private!testing-queue order! !
!SchedulerTest categoriesFor: #testSetup!private!testing! !
!SchedulerTest categoriesFor: #transcript!private! !
!SchedulerTest categoriesFor: #transcript1!private! !
!SchedulerTest categoriesFor: #transcript2!private! !
!SchedulerTest categoriesFor: #transcript3!private! !
!SchedulerTest categoriesFor: #transcript4!private! !
!SchedulerTest categoriesFor: #transcript5!private! !

SwazooIntegrationTest guid: (GUID fromString: '{8E3911C9-28E7-4C46-88A2-670FD5BDEEBC}')!
SwazooIntegrationTest comment: 'All tests are commented out because they are DANGEROUS to live Swazoo systems!!

Instance Variables:
	server	<SwazooServer>	description of server
	site	<Object | Proxy>	description of site

'!
!SwazooIntegrationTest categoriesForClass!Unclassified! !
!SwazooIntegrationTest methodsFor!

localSendUrl: aString
	"sends request with that RELATIVE url to the site localy - it simulates a real network request. "
	| request httpServer |
	request := Swazoo.HTTPRequest request: aString from: self siteHost at: self siteIP.
	request uri port: self sitePort.
	httpServer := server servers asOrderedCollection first.
	^httpServer answerTo: request!

sendUrl: aString
	"sends a real network request with that RELATIVE url to the site with parameters from defaults. 
	Returns a Net.HttpResponse"
	| client request |
	client := Net.HttpClient new.
	request := Net.HttpRequest get: 'http://', self siteHost, ':', self sitePort printString, aString.
	^client executeRequest: request.!

setUp
	server := Swazoo.SwazooServer singleton.
	"server initialize." "DANGEROUS!! "  "to remove all stuff and stop it"
	"site := AIDASite newNamed: self siteName.
	site 
		host: self siteHost;
		ip: self siteIP;
		port: self sitePort;
		sslPort: self siteSSLPort. "!

siteHost
	^'localhost'!

siteIP
	^'localhost'!

siteName
	^'test'!

sitePort
	^8765!

siteRootUri
	^'/'!

siteSSLPort
	^8766!

tearDown
	"site := server siteNamed: self siteName.
	site stop.
	server removeSite: site.
	server := nil.
	site := nil."!

testAccessingByName
"
	self assert: (Swazoo.SwazooServer siteNamed: self siteName) notNil.
	self assert: (Swazoo.SwazooServer siteHostnamed: self siteHost) notNil
"!

testAdminPage
"
	| |
	server startSite: self siteName.
	self shouldnt: [self sendUrl: '/admin.html'] raise: Error.
	self shouldnt: [self sendUrl: '/admin.html?view=login'] raise: Error.
	server stopSite: self siteName.
"!

testDummyRequest
"
	server startSite: self siteName.
	self should: [self sendUrl: '/dummycompletelydummy.html'] raise: Net.HttpObjectNotFound.
	server stopSite: self siteName.
"!

testLocalAdminPage
"
	| response |
	server startSite: self siteName.
	response := self localSendUrl: '/admin.html'.
	self assert: response isRedirectLink.
	response := self localSendUrl: '/admin.html?view=login'.
	self assert: response isOk.
	server stopSite: self siteName.
"!

testLocalDummyRequest
"
	| response |
	server startSite: self siteName.
	response := self localSendUrl: '/dummycompletelydummy.html'.
	self assert: response isNotFound.
	server stopSite: self siteName.
"!

testSetUp
"
	self assert: (server sites size = 1).
	self assert: (site ip = self siteIP).
	self assert: (site host = self siteHost).
	self assert: (site port = self sitePort).
	self assert: site isServing not.
"!

testStarting
	server startSite: self siteName.
	self assert: (server siteNamed: self siteName) isServing.
	self assert: (server servers asOrderedCollection first isServing).
	server stopSite: self siteName.
	self deny: (server siteNamed: self siteName) isServing.! !
!SwazooIntegrationTest categoriesFor: #localSendUrl:!private! !
!SwazooIntegrationTest categoriesFor: #sendUrl:!private! !
!SwazooIntegrationTest categoriesFor: #setUp!private!running! !
!SwazooIntegrationTest categoriesFor: #siteHost!defaults!private! !
!SwazooIntegrationTest categoriesFor: #siteIP!defaults!private! !
!SwazooIntegrationTest categoriesFor: #siteName!defaults!private! !
!SwazooIntegrationTest categoriesFor: #sitePort!defaults!private! !
!SwazooIntegrationTest categoriesFor: #siteRootUri!defaults!private! !
!SwazooIntegrationTest categoriesFor: #siteSSLPort!defaults!private! !
!SwazooIntegrationTest categoriesFor: #tearDown!private!running! !
!SwazooIntegrationTest categoriesFor: #testAccessingByName!private!testing! !
!SwazooIntegrationTest categoriesFor: #testAdminPage!private!testing! !
!SwazooIntegrationTest categoriesFor: #testDummyRequest!private!testing! !
!SwazooIntegrationTest categoriesFor: #testLocalAdminPage!private!testing! !
!SwazooIntegrationTest categoriesFor: #testLocalDummyRequest!private!testing! !
!SwazooIntegrationTest categoriesFor: #testSetUp!private!testing! !
!SwazooIntegrationTest categoriesFor: #testStarting!private!testing! !

URLResolverTest guid: (GUID fromString: '{CA43F5ED-15CA-4721-9C30-7B524FF9364E}')!
URLResolverTest comment: ''!
!URLResolverTest categoriesForClass!Unclassified! !
!URLResolverTest methodsFor!

setUp
	server := Swazoo.SwazooServer singleton.
	server initialize.  "to remove all stuff and stop it"
	site := AIDASite newNamed: 'test'.!

tearDown
	site := server siteNamed: 'test'.
	site stop.
	server removeSite: site.
	server := nil. site := nil.!

testSetUp! !
!URLResolverTest categoriesFor: #setUp!private!running! !
!URLResolverTest categoriesFor: #tearDown!private!running! !
!URLResolverTest categoriesFor: #testSetUp!private!testing! !

VersionedObjectTest guid: (GUID fromString: '{CF2ED91D-C6F3-43B8-9248-0C54EE576B23}')!
VersionedObjectTest comment: ''!
!VersionedObjectTest categoriesForClass!Unclassified! !
!VersionedObjectTest methodsFor!

testFirstCreation
	| o |
	o := VersionedObject new.
	self assert: o versionNumber = '1'.
	self assert:  o isCurrentVersion.
	self assert:  o isOldestVersion.
	self assert:  o isNewestVersion.
	self assert:  o parentVersion isNil.
	self assert:  o nextVersion isNil.!

testIdentityPreservation
	| o1 o2 c |
	o1 := VersionedExample new. o1 title: 'test'.
	o2 := o1 asNewVersion.  o2 title: 'sectest'.
	c := o1 currentVersion.
	self assert: c == o1.
	o2 setCurrentVersion.
	self assert: c == o1 currentVersion. "identity must be preserved!! "!

testNewVersion
	| o o2 |
	o := VersionedObject new.
	o2 := o asNewVersion.
	self assert: o2 versionNumber = '2'.
	self deny:  o2 isCurrentVersion.
	self deny:  o2 isOldestVersion.
	self assert:  o2 isNewestVersion.
	self assert: o2 parentVersion == o.!

testNewVersionOfExample
	| o o2 |
	o := VersionedExample new. o title: 'test'; body: 'this is test'.
	o2 := o asNewVersion.
	self assert: o2 title = o title.
	self assert: o2 body = o body.!

testSearchByNumber
	| o1 o2 o3 |
	o1 := VersionedExample new. o1 title: 'first'. o2 := o1 asNewVersion. o2 title: 'second'. 
	o3 := o2 asNewVersion. o3 title: 'third'. 
	self assert: ((o2 versionWithNumber: '1') versionNumber = '1').
	self assert: ((o2 versionWithNumber: '2') versionNumber = '2').
	self assert: ((o2 versionWithNumber: '3') versionNumber = '3').
	self assert: ((o2 versionWithNumber: '4') isNil).!

testSetCurrent
	| o1 o2 |
	o1 := VersionedObject new. o2 := o1 asNewVersion.
	self assert:  o1 isCurrentVersion.
	self deny:  o2 isCurrentVersion.
	o2 setCurrentVersion.
	self assert:  o1 isCurrentVersion. "o1 and o2 identities are swapped!! "
	self deny:  o2 isCurrentVersion.!

testSwap3Objects
	| o1 o2 o3 |
	o1 := VersionedExample new. o1 title: 'first'. o2 := o1 asNewVersion. o2 title: 'second'. 
	o3 := o2 asNewVersion. o3 title: 'third'. o3 version setCurrent. "to debug more easily"
	self assert: o1 version next == o2. 
	self assert: o2 version parent == o1. self assert: o2 version next == o3.
	self assert: o3 version parent == o2.
	o1 setCurrentVersion.
	self assert: o3 version next == o2. "test chain integrity"
	self assert: o2 version parent == o3. self assert: o2 version next == o1.
	self assert: o1 version parent == o2.
	self assert: o1 title = 'third'. self assert: o2 title = 'second'. self assert: o3 title = 'first'.!

testSwap3Objects2
	| o1 o2 o3 |
	o1 := VersionedExample new. o1 title: 'first'. o2 := o1 asNewVersion. o2 title: 'second'. 
	o3 := o2 asNewVersion. o3 title: 'third'. 
	self assert: o1 version next == o2. 
	self assert: o2 version parent == o1. self assert: o2 version next == o3.
	self assert: o3 version parent == o2.
	o3 setCurrentVersion.
	self assert: o3 version next == o2. "test chain integrity"
	self assert: o2 version parent == o3. self assert: o2 version next == o1.
	self assert: o1 version parent == o2.
	self assert: o1 title = 'third'. self assert: o2 title = 'second'. self assert: o3 title = 'first'.!

testSwapIdentity
	| o1 o2 |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'.
	self assert: o1 isCurrentVersion.
	self assert: o1 title = 'first'. self assert: o2 title = 'second'.
	o2 setCurrentVersion.
	self assert: o1 isCurrentVersion. "because of identity swap!! "
	self assert: o1 title = 'second'. self assert: o2 title = 'first'.!

testSwapIdentity2
	| o1 o2 s1 s2 |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'.
	s1 := o1 version. s2 := o2 version.
	self assert: s1 object title = 'first'. self assert: s2 object title = 'second'.
	o2 setCurrentVersion.
	"version chain order must be preserved!!"
	self assert: s1 object title = 'first'. self assert: s2 object title = 'second'.!

testSwapIdentity3
	| o1 o2 |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'. o2 version setCurrent. "to debug more easily"
	o1 setCurrentVersion. 
	self assert: o1 version object == o1. "check references to spec and back"
	self assert: o2 version object == o2.
	self assert: o1 version parent == o2. "test chain integrity"
	self assert: o2 version next == o1.!

testSwapIdentity4
	| o1 o2 |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'. 
	o2 setCurrentVersion.  "to test other part of VersionedObject swapIdentity"
	self assert: o1 version object == o1. "check references to spec and back"
	self assert: o2 version object == o2.
	self assert: o1 version parent == o2. "test chain integrity"
	self assert: o2 version next == o1.!

testVersionIncrement
	| o o2 |
	o := VersionedObject new. o versionNumber: '1234'.
	o2 := o asNewVersion.
	self assert: o2 versionNumber = '1235'.!

testWebLink
	| o1 o2 link |
	o1 := VersionedExample new. o1 title: 'first'.
	o2 := o1 asNewVersion. o2 title: 'second'.
	link := WebLink linkTo: o1.
	self assert: link ooReference == o1.
	self deny: (link parms includesKey: 'version').
	link := WebLink linkTo: o2.
	self assert: link ooReference == o1.  "o1 is current version!! "
	self assert: (link parms at: 'version') = '2'.! !
!VersionedObjectTest categoriesFor: #testFirstCreation!private!testing! !
!VersionedObjectTest categoriesFor: #testIdentityPreservation!private!testing-identity swap! !
!VersionedObjectTest categoriesFor: #testNewVersion!private!testing! !
!VersionedObjectTest categoriesFor: #testNewVersionOfExample!private!testing! !
!VersionedObjectTest categoriesFor: #testSearchByNumber!private!testing! !
!VersionedObjectTest categoriesFor: #testSetCurrent!private!testing-identity swap! !
!VersionedObjectTest categoriesFor: #testSwap3Objects!private!testing-identity swap! !
!VersionedObjectTest categoriesFor: #testSwap3Objects2!private!testing-identity swap! !
!VersionedObjectTest categoriesFor: #testSwapIdentity!private!testing-identity swap! !
!VersionedObjectTest categoriesFor: #testSwapIdentity2!private!testing-identity swap! !
!VersionedObjectTest categoriesFor: #testSwapIdentity3!private!testing-identity swap! !
!VersionedObjectTest categoriesFor: #testSwapIdentity4!private!testing-identity swap! !
!VersionedObjectTest categoriesFor: #testVersionIncrement!private!testing! !
!VersionedObjectTest categoriesFor: #testWebLink!private!testing-url links! !

VersionSpecTest guid: (GUID fromString: '{E9E22BD2-4566-4E99-9236-8D1023A96C24}')!
VersionSpecTest comment: ''!
!VersionSpecTest categoriesForClass!Unclassified! !
!VersionSpecTest methodsFor!

testFirstCreation
	| spec |
	spec := VersionSpec firstFor: ''.
	self assert: spec number = '1'.
	self assert:  spec isCurrent.
	self assert:  spec isOldest.
	self assert:  spec isNewest.!

testSearchByNumber
	| o spec |
	o := VersionedObject new.
	spec := VersionSpec newFromParent: o for: VersionedObject new.
	self assert: ((spec versionSpecWithNumber: '2') number = '2').
	self assert: ((spec versionSpecWithNumber: '1') number = '1').
	self assert: (spec versionSpecWithNumber: '3') isNil.!

testSecondCreation
	| o spec |
	o := VersionedObject new.
	spec := VersionSpec newFromParent: o for: VersionedObject new.
	self assert: spec number = '2'.
	self deny:  spec isCurrent.
	self deny:  spec isOldest.
	self assert:  spec isNewest.
	self assert: spec parent == o.
	spec setCurrent.
	self assert:  spec isCurrent.
	self deny: spec parent version isCurrent.!

testSetCurrent
	| o spec |
	o := VersionedObject new.
	spec := VersionSpec newFromParent: o for: VersionedObject new.
	self assert:  o isCurrentVersion.
	self deny:  spec isCurrent.
	spec setCurrent.
	self assert:  spec isCurrent.
	self deny: o isCurrentVersion.! !
!VersionSpecTest categoriesFor: #testFirstCreation!private!testing! !
!VersionSpecTest categoriesFor: #testSearchByNumber!private!testing! !
!VersionSpecTest categoriesFor: #testSecondCreation!private!testing! !
!VersionSpecTest categoriesFor: #testSetCurrent!private!testing! !

WebApplicationTest guid: (GUID fromString: '{A9999C7E-C503-4FFA-8712-9DF492FA6CBE}')!
WebApplicationTest comment: ''!
!WebApplicationTest categoriesForClass!Unclassified! !
!WebApplicationTest methodsFor!

setRequest
	request := HTTPGet new.
	request parseURI: 'http://www.eranova.si/demo.html'.
	session lastRequest: request!

setUp
	server := Swazoo.SwazooServer singleton.
	server initialize.  "to remove all stuff and stop it"
	site := AIDASite newNamed: 'test'.
	session := WebSession newOn: site sessionManager.
	app := site admin webAppFor: session.
	self setRequest.!

tearDown
	site := server siteNamed: 'test'.
	site stop.
	server removeSite: site.
	server := nil. site := nil. session := nil. app := nil.!

testChangeObserveeVersion
	| o1 |
	o1 := VersionedExample new. o1 asNewVersion.
	app := o1 webAppFor: session.
	self assert: app observee versionNumber = '1'.
	request uri queries: (request uri queries, '&version=2').
	app checkObserveeVersion.
	self assert: app observee versionNumber = '2'.
	self deny: app observee isCurrentVersion!

testChangeObserveeVersionBack
	| o1 |
	o1 := VersionedExample new. o1 asNewVersion.  app := o1 webAppFor: session.
	request uri queries: (request uri queries, '&version=2').
	app checkObserveeVersion.
	self assert: app observee versionNumber = '2'.
	self setRequest. "to be without version again"
	app checkObserveeVersion.
	self assert: app observee versionNumber = '1'.
	self assert: app observee isCurrentVersion!

testCurrentVersionChange
	| o1 o2 |
	o1 := VersionedExample new. o2 := o1 asNewVersion.
	app := o1 webAppFor: session.
	self assert: app observee isCurrentVersion.
	self assert: app observee versionNumber = '1'.
	o2 setCurrentVersion.
	self assert: app observee isCurrentVersion. "because of identity change!! "
	self assert: app observee versionNumber = '2'.!

testSecurity!

testSetUp
	self assert: app notNil.
	self assert: app observee == site admin.
	self assert: app session == session.
	self assert: (session webAppFor: site admin) == app!

testVersionedObject
	| o1 o2 |
	o1 := VersionedExample new. o2 := o1 asNewVersion.
	app := o1 webAppFor: session.
	self assert: app observee isVersionedObject.
	self assert: app observee isCurrentVersion.!

testVersionRequest
	| o1 |
	o1 := VersionedExample new. 
	app := o1 webAppFor: session.
	self deny: app isVersionRequest.
	self assert: app versionFromRequest isNil.
	request uri queries: (request uri queries, '&version=2').
	self assert: app isVersionRequest.
	self assert: app versionFromRequest = '2'.! !
!WebApplicationTest categoriesFor: #setRequest!private!running! !
!WebApplicationTest categoriesFor: #setUp!private!running! !
!WebApplicationTest categoriesFor: #tearDown!private!running! !
!WebApplicationTest categoriesFor: #testChangeObserveeVersion!private!testing-versions! !
!WebApplicationTest categoriesFor: #testChangeObserveeVersionBack!private!testing-versions! !
!WebApplicationTest categoriesFor: #testCurrentVersionChange!private!testing-versions! !
!WebApplicationTest categoriesFor: #testSecurity!private!testing! !
!WebApplicationTest categoriesFor: #testSetUp!private!testing! !
!WebApplicationTest categoriesFor: #testVersionedObject!private!testing-versions! !
!WebApplicationTest categoriesFor: #testVersionRequest!private!testing-versions! !

WebSecurityTest guid: (GUID fromString: '{9E6CAA58-9D09-436E-84D5-0BFE36311173}')!
WebSecurityTest comment: ''!
!WebSecurityTest categoriesForClass!Unclassified! !
!WebSecurityTest methodsFor!

setUp
	server := Swazoo.SwazooServer singleton.
	server initialize.  "to remove all stuff and stop it"
	site := AIDASite newNamed: 'test'.
	mgr := site securityManager.!

tearDown
	site := server siteNamed: 'test'.
	site stop.
	server removeSite: site.
	server := nil. site := nil. mgr := nil.!

testGroups
	| group |
	self assert: (mgr groups size = 2). "AllUsers and Admins"
	group := WebUserGroup new name: 'test'.
	self deny: (mgr existGroupNamed: 'test').
	mgr addGroup: group.
	self assert: (mgr existGroupNamed: 'test').
	self assert: (mgr groups size = 3). 
	mgr addGroupNamed: 'test'. "duplicate test"
	self assert: (mgr groups size = 3).
	mgr removeGroupNamed: 'test'.
	self assert: (mgr groups size = 2).!

testInitialize
	self assert: mgr users size = 1.
	self assert: mgr groups size = 2.  "Admininstrators and AllUsers"
	self assert: (mgr existUserNamed: 'admin' withPassword: 'password').
	self assert: (mgr existGroupNamed: 'Administrators').
	self assert: (mgr existGroupNamed: 'AllUsers').!

testMultipleAccessRights
	| object right1 right2 user |
	right1 := #AllowThat. right2 := #AllowThatToo.
	object := #JustSomething.
	user := mgr adminUser.
	self deny: (mgr has: user rightTo: right1 on: object).
	self deny: (mgr has: user rightTo: right2 on: object).
	mgr setAccessRights: (Array with: right1 with: right2) for: mgr adminUser on: object.
	self assert: (mgr has:user rightTo: right1 on: object).
	self assert: (mgr has: user rightTo: right2 on: object).
	mgr removeAccessRights: (Array with: right1 with: right2) for: mgr adminUser on: object.
	self deny: (mgr has: user rightTo: right1 on: object).
	self deny: (mgr has: user rightTo: right2 on: object).!

testSimpleAccessRight
	| right object user |
	right := #AllowThat.
	object := #JustSomething.
	user := mgr adminUser.
	self deny: (mgr has: user rightTo: right on: object).
	mgr setAccessRights: right for: mgr adminUser on: object.
	self assert: (mgr has:user rightTo: right on: object).
	mgr removeAccessRights: right for: mgr adminUser on: object.
	self deny: (mgr has: user rightTo: right on: object).!

testUsers
	| user |
	self assert: (mgr users size = 1). "only admin user"
	user := WebUser new username: 'test'; password: 'test'; email: 'a@a.si'.
	self deny: (mgr existUserNamed: 'test' withPassword: 'test').
	mgr addUser: user.
	self assert: (mgr existUserNamed: 'test' withPassword: 'test').
	self assert: (mgr users size = 2). 
	mgr addUser: user. "duplicate test"
	self assert: (mgr users size = 2).
	mgr removeUserNamed: 'test' withPassword: 'test'.
	self assert: (mgr users size = 1).! !
!WebSecurityTest categoriesFor: #setUp!private!running! !
!WebSecurityTest categoriesFor: #tearDown!private!running! !
!WebSecurityTest categoriesFor: #testGroups!private!testing! !
!WebSecurityTest categoriesFor: #testInitialize!private!testing! !
!WebSecurityTest categoriesFor: #testMultipleAccessRights!private!testing! !
!WebSecurityTest categoriesFor: #testSimpleAccessRight!private!testing! !
!WebSecurityTest categoriesFor: #testUsers!private!testing! !

WebSessionMgmtTest guid: (GUID fromString: '{8C330A58-5759-4121-8721-300835469006}')!
WebSessionMgmtTest comment: ''!
!WebSessionMgmtTest categoriesForClass!Unclassified! !
!WebSessionMgmtTest methodsFor!

setUp
	server := Swazoo.SwazooServer singleton.
	server initialize.  "to remove all stuff and stop it"
	site := AIDASite newNamed: 'test'.
	session := WebSession newOn: site sessionManager.!

tearDown
	site := server siteNamed: 'test'.
	site stop.
	server removeSite: site.
	server := nil. site := nil. session := nil.!

testSetUp
	self assert: session notNil! !
!WebSessionMgmtTest categoriesFor: #setUp!private!running! !
!WebSessionMgmtTest categoriesFor: #tearDown!private!running! !
!WebSessionMgmtTest categoriesFor: #testSetUp!private!testing! !

VersionedExample guid: (GUID fromString: '{BA01C17B-DD4A-46E4-8E52-5CA228A3D08F}')!
VersionedExample comment: ''!
!VersionedExample categoriesForClass!Unclassified! !
!VersionedExample methodsFor!

body
	^body!

body: anObject
	body := anObject!

copyContentsTo: anObject
	anObject title: self title copy.
	anObject body: self body copy.!

printString
	^'aVersionedExample ', 
		(self title notNil ifTrue: [self title] ifFalse: ['']), ' ', 
		(self body notNil ifTrue: [self body] ifFalse: [''])!

title
	^title!

title: anObject
	title := anObject! !
!VersionedExample categoriesFor: #body!accessing!private! !
!VersionedExample categoriesFor: #body:!accessing!private! !
!VersionedExample categoriesFor: #copyContentsTo:!copying!private! !
!VersionedExample categoriesFor: #printString!printing!private! !
!VersionedExample categoriesFor: #title!accessing!private! !
!VersionedExample categoriesFor: #title:!accessing!private! !

VersionedExampleApp guid: (GUID fromString: '{1BC8A8C2-9E46-4001-A110-E9298844C90F}')!
VersionedExampleApp comment: ''!
!VersionedExampleApp categoriesForClass!Unclassified! !
"Binary Globals"!

