| package |
package := Package name: 'Swazoo-Resources'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: '0.001'.


package classNames
	add: #ACLResource;
	add: #AuthorizationResource;
	add: #CookieSessionResource;
	add: #ExampleSidebarResource;
	add: #FileMappingResource;
	add: #FileResource;
	add: #GoodbyeCruelWorld;
	add: #HelloWorldResource;
	add: #HomeResource;
	add: #MozillaSidebarResource;
	add: #RedirectionResource;
	add: #SessionTestResource;
	add: #SwazooActivePage;
	add: #SwazooActivePageResource;
	add: #SwazooCacheControl;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\..\Object Arts\Dolphin\Base\Dolphin';
	add: 'Swazoo';
	add: 'Swazoo-Platform';
	yourself).

package!

"Class Definitions"!

Object subclass: #SwazooActivePage
	instanceVariableNames: 'file request ws'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #SwazooCacheControl
	instanceVariableNames: 'request cacheTarget etag lastModified'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #FileMappingResource
	instanceVariableNames: 'directoryIndex filePath'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #GoodbyeCruelWorld
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #HelloWorldResource
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #MozillaSidebarResource
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #RedirectionResource
	instanceVariableNames: 'targetUri'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
SwazooResource subclass: #SessionTestResource
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
CompositeResource subclass: #AuthorizationResource
	instanceVariableNames: 'targetUri'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
CompositeResource subclass: #CookieSessionResource
	instanceVariableNames: 'sessions expirationProcess lock'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
AuthorizationResource subclass: #ACLResource
	instanceVariableNames: 'users'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
FileMappingResource subclass: #FileResource
	instanceVariableNames: ''
	classVariableNames: 'ContentTypes'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
FileMappingResource subclass: #SwazooActivePageResource
	instanceVariableNames: 'file request ws'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
FileResource subclass: #HomeResource
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
MozillaSidebarResource subclass: #ExampleSidebarResource
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

SwazooActivePage guid: (GUID fromString: '{DD848B71-CA81-4060-8648-E72222C98970}')!
SwazooActivePage comment: ''!
!SwazooActivePage categoriesForClass!Unclassified! !
!SwazooActivePage methodsFor!

asHTML
	| rs |
	rs := self file readStream.
	^[self invokeMethodFrom: rs] ensure: [rs close]!

file
	^file!

file: anObject
	file := anObject!

initialize
	ws := WriteStream on: String new!

invokeMethodFrom: aStream 
	^SwazooCompiler evaluate: (self methodBodyFrom: aStream) receiver: self
!

methodBodyFrom: aStream 
	| bodyStream platform |
	platform := SwazooPlatform current.
	bodyStream := WriteStream on: String new.
	[aStream atEnd] whileFalse: 
			[(aStream peekFor: $<) 
				ifTrue: 
					[(aStream peekFor: $?) 
						ifTrue: 
							[bodyStream nextPutAll: (platform stream: aStream upToAll: '?>') trimBlanks.
							aStream atEnd ifFalse: [aStream skip: 2]]
						ifFalse: 
							[bodyStream
								space;
								nextPutAll: 'ws nextPut: $<; nextPutAll: ';
								print: (platform stream: aStream upToAll: '<?');
								nextPutAll: '. ']]
				ifFalse: 
					[bodyStream
						space;
						nextPutAll: 'ws nextPutAll: ';
						print: (platform stream: aStream upToAll: '<?');
						nextPutAll: '. ']].
	bodyStream
		cr;
		nextPutAll: '^ws contents'.
	^bodyStream contents!

request
	^request!

request: anObject
	request := anObject! !
!SwazooActivePage categoriesFor: #asHTML!converting!public! !
!SwazooActivePage categoriesFor: #file!accessing!public! !
!SwazooActivePage categoriesFor: #file:!accessing!public! !
!SwazooActivePage categoriesFor: #initialize!private-initialize!public! !
!SwazooActivePage categoriesFor: #invokeMethodFrom:!public! !
!SwazooActivePage categoriesFor: #methodBodyFrom:!private! !
!SwazooActivePage categoriesFor: #request!accessing!public! !
!SwazooActivePage categoriesFor: #request:!accessing!public! !

!SwazooActivePage class methodsFor!

file: aFilename request: aRequest 
	^(self new)
		file: aFilename;
		request: aRequest!

new
	^super new initialize! !
!SwazooActivePage class categoriesFor: #file:request:!instance creation!public! !
!SwazooActivePage class categoriesFor: #new!instance creation!public! !

SwazooCacheControl guid: (GUID fromString: '{2C690317-BD1A-43DC-947A-068A8026C8D3}')!
SwazooCacheControl comment: ''!
!SwazooCacheControl categoriesForClass!Unclassified! !
!SwazooCacheControl methodsFor!

addNotModifedHeaders: aResponse 
	"RFC2616 10.3.5
	If the conditional GET used a strong cache validator (see section 13.3.3), the response SHOULD NOT include other entity-headers. ... this prevents inconsistencies between cached entity-bodies and updated headers. "

	self isRequestStrongValidator 
		ifTrue: [aResponse addHeaderName: 'ETag' value: self etag]
		ifFalse: [self basicAddResponseHeaders: aResponse].
	^aResponse!

addResponseHeaders: aResponse 
	"Add response headers to the response.
	We MUST differentiate between 200/302 responses"

	^aResponse isNotModified 
		ifTrue: [self addNotModifedHeaders: aResponse]
		ifFalse: [self basicAddResponseHeaders: aResponse]!

basicAddResponseHeaders: aResponse 
	"RFC 2616 13.3.4
	HTTP/1.1 origin servers: 
      	- SHOULD send an entity tag validator unless it is not feasible to generate one.
		- SHOULD send a Last-Modified value "

	aResponse addHeaderName: 'ETag' value: self etag.
	aResponse addHeaderName: 'Last-Modified' value: self lastModified.
	^aResponse!

cacheTarget
	^cacheTarget!

etag
	etag isNil ifTrue: [etag := self generateETag].
	^etag!

etag: aString 
	etag := aString!

generateETag
	^self cacheTarget etag!

generateLastModified
	^self cacheTarget lastModified!

isIfModifiedSince
	"Answers true if either 
		- the request does not included the header
		-or there is not a match"

	| dateString |
	^(dateString := request headerValueOrNil: 'If-Modified-Since') isNil 
		or: [dateString ~= self lastModified]!

isIfNoneMatch
	"Answers true if either 
		- the request does not included the header
		-or there is not a match"

	| etags |
	^(etags := request headerValuesAt: 'If-None-Match') isEmpty 
		or: [(etags includes: self etag) not]!

isNotModified
	"Compare the cacheTarget with the request headers and answer if the client's version is not modified.
	Takes into account http version, and uses best practices defined by HTTP spec"

	^self isIfNoneMatch not or: [self isIfModifiedSince not]!

isRequestStrongValidator
	^(request headerValuesAt: 'If-None-Match') isEmpty not!

lastModified
	lastModified isNil ifTrue: [lastModified := self generateLastModified].
	^lastModified!

lastModified: aRFC1123TimeStampString 
	lastModified := aRFC1123TimeStampString!

request: aHTTPGet cacheTarget: anObject 
	request := aHTTPGet.
	cacheTarget := anObject! !
!SwazooCacheControl categoriesFor: #addNotModifedHeaders:!operations!public! !
!SwazooCacheControl categoriesFor: #addResponseHeaders:!operations!public! !
!SwazooCacheControl categoriesFor: #basicAddResponseHeaders:!operations!public! !
!SwazooCacheControl categoriesFor: #cacheTarget!accessing!public! !
!SwazooCacheControl categoriesFor: #etag!accessing!public! !
!SwazooCacheControl categoriesFor: #etag:!accessing!public! !
!SwazooCacheControl categoriesFor: #generateETag!operations!public! !
!SwazooCacheControl categoriesFor: #generateLastModified!operations!public! !
!SwazooCacheControl categoriesFor: #isIfModifiedSince!public!testing! !
!SwazooCacheControl categoriesFor: #isIfNoneMatch!public!testing! !
!SwazooCacheControl categoriesFor: #isNotModified!public!testing! !
!SwazooCacheControl categoriesFor: #isRequestStrongValidator!public!testing! !
!SwazooCacheControl categoriesFor: #lastModified!public!testing! !
!SwazooCacheControl categoriesFor: #lastModified:!public!testing! !
!SwazooCacheControl categoriesFor: #request:cacheTarget:!accessing!public! !

FileMappingResource guid: (GUID fromString: '{7EE4158F-A8C8-4A17-B303-3738499746E7}')!
FileMappingResource comment: ''!
!FileMappingResource categoriesForClass!Unclassified! !
!FileMappingResource methodsFor!

answerTo: aRequest 
	(self checkExistence: aRequest) ifFalse: [^nil].
	(self checkURI: aRequest) 
		ifFalse: 
			[^(HTTPResponse movedPermanently)
				addHeaderName: 'Location' value: aRequest uri identifier , '/';
				yourself].
	^self file: (self fileFor: aRequest) answerTo: aRequest!

checkExistence: aRequest 
	(self rootFileFor: aRequest) exists ifFalse: [^false].
	^(self fileFor: aRequest) exists!

checkURI: aRequest 
	| needsFinalSlash |
	needsFinalSlash := (self rootFileFor: aRequest) isDirectory 
				and: [aRequest uri isDirectory not].
	^needsFinalSlash not!

directoryIndex
	^directoryIndex!

directoryIndex: aString 
	directoryIndex := aString!

file: aFilename answerTo: aRequest 
	^self subclassResponsibility!

fileDirectory
	^self filePath asFilename!

fileFor: aRequest 
	| fn |
	fn := self rootFileFor: aRequest.
	fn isDirectory ifTrue: [fn := fn construct: self directoryIndex].
	^fn!

filePath
	^filePath!

filePath: aString 
	filePath := aString!

initialize
	super initialize.
	self directoryIndex: 'index.html'!

rootFileFor: aRequest 
	^aRequest tailPath inject: self fileDirectory
		into: 
			[:subPath :each | 
			(#('.' '..') includes: each trimBlanks) 
				ifTrue: [subPath]
				ifFalse: [subPath construct: each]]! !
!FileMappingResource categoriesFor: #answerTo:!public!serving! !
!FileMappingResource categoriesFor: #checkExistence:!private! !
!FileMappingResource categoriesFor: #checkURI:!private! !
!FileMappingResource categoriesFor: #directoryIndex!accessing!public! !
!FileMappingResource categoriesFor: #directoryIndex:!accessing!public! !
!FileMappingResource categoriesFor: #file:answerTo:!private! !
!FileMappingResource categoriesFor: #fileDirectory!private! !
!FileMappingResource categoriesFor: #fileFor:!private! !
!FileMappingResource categoriesFor: #filePath!accessing!public! !
!FileMappingResource categoriesFor: #filePath:!accessing!public! !
!FileMappingResource categoriesFor: #initialize!private-initialize!public! !
!FileMappingResource categoriesFor: #rootFileFor:!private! !

!FileMappingResource class methodsFor!

uriPattern: aString filePath: aFilePath 
	^(self uriPattern: aString) filePath: aFilePath!

uriPattern: aString filePath: aFilePath directoryIndex: anotherString 
	^(self uriPattern: aString)
		filePath: aFilePath;
		directoryIndex: anotherString! !
!FileMappingResource class categoriesFor: #uriPattern:filePath:!instance creation!public! !
!FileMappingResource class categoriesFor: #uriPattern:filePath:directoryIndex:!instance creation!public! !

GoodbyeCruelWorld guid: (GUID fromString: '{06ABAAD3-2D83-47F1-940B-52A58509BB79}')!
GoodbyeCruelWorld comment: ''!
!GoodbyeCruelWorld categoriesForClass!Unclassified! !
!GoodbyeCruelWorld methodsFor!

answerTo: aRequest
	| response |
	response := HTTPResponse notFound.
	response 
		entity: '<html><head><title>Goodbye</title></head><body>I am not really here.</body></html>'.
	^response! !
!GoodbyeCruelWorld categoriesFor: #answerTo:!public!serving! !

HelloWorldResource guid: (GUID fromString: '{925A9D3C-BB4C-45C6-A3C1-56E16F6084FC}')!
HelloWorldResource comment: ''!
!HelloWorldResource categoriesForClass!Unclassified! !
!HelloWorldResource methodsFor!

answerTo: aRequest 
	| response |
	response := HTTPResponse ok.
	response
		contentType: 'text/html';
		entity: '<html><head><title>Hello World</title></head><body>Hello World!!</body></html>'.
	^response! !
!HelloWorldResource categoriesFor: #answerTo:!public!serving! !

MozillaSidebarResource guid: (GUID fromString: '{5D8218F1-793B-41E6-A99E-C8A8AFFD6C2E}')!
MozillaSidebarResource comment: ''!
!MozillaSidebarResource categoriesForClass!Unclassified! !
!MozillaSidebarResource methodsFor!

answerTo: aRequest 
	aRequest tailPath isEmpty ifFalse: [^nil].
	^(aRequest includesQuery: 'contents') 
		ifTrue: [self sidebarResponseTo: aRequest]
		ifFalse: [self installationResponseTo: aRequest]!

installationResponseTo: aRequest 
	| ws |
	ws := WriteStream on: String new.
	ws
		nextPutAll: '<HTML>
<SCRIPT LANGUAGE="JavaScript">
<!!--
   function focus() {
   document.forms[0].school_code.focus()
   }

   function addNetscapePanel() {
      if ((typeof window.sidebar == "object") && (typeof window.sidebar.addPanel == "function"))
      {
         window.sidebar.addPanel ("';
		nextPutAll: self title;
		nextPutAll: '", "';
		nextPutAll: aRequest urlString;
		nextPutAll: '?contents","");
         window.history.back();
      }
      else
      {
         var rv = window.confirm ("This page is only meaningful for users of Netscape 6." + "Would you like to learn more?");
         if (rv)
            document.location.href = "http://home.netscape.com";
      }
   }
//-->
</SCRIPT>
<BODY onLoad=''addNetscapePanel()''>
</HTML>'.
	^HTTPResponse ok entity: ws contents!

sidebarResponseTo: aRequest 
	^self subclassResponsibility!

title
	^self subclassResponsibility! !
!MozillaSidebarResource categoriesFor: #answerTo:!public!serving! !
!MozillaSidebarResource categoriesFor: #installationResponseTo:!private! !
!MozillaSidebarResource categoriesFor: #sidebarResponseTo:!private! !
!MozillaSidebarResource categoriesFor: #title!private-accessing!public! !

RedirectionResource guid: (GUID fromString: '{7933D25C-D484-4543-A111-CFF9CA70839D}')!
RedirectionResource comment: ''!
!RedirectionResource categoriesForClass!Unclassified! !
!RedirectionResource methodsFor!

answerTo: aRequest 
	| answer |
	answer := HTTPResponse movedPermanently.
	answer addHeaderName: 'Location' value: self targetUri.
	^answer!

targetUri
	^targetUri!

targetUri: aString 
	targetUri := aString! !
!RedirectionResource categoriesFor: #answerTo:!public!serving! !
!RedirectionResource categoriesFor: #targetUri!private-initialize!public! !
!RedirectionResource categoriesFor: #targetUri:!private-initialize!public! !

!RedirectionResource class methodsFor!

uriPattern: aString targetUri: bString 
	^(self uriPattern: aString) targetUri: bString! !
!RedirectionResource class categoriesFor: #uriPattern:targetUri:!instance creation!public! !

SessionTestResource guid: (GUID fromString: '{2497DC76-5803-448A-A32C-EC5112EF763C}')!
SessionTestResource comment: ''!
!SessionTestResource categoriesForClass!Unclassified! !
!SessionTestResource methodsFor!

answerTo: aRequest
	^HTTPResponse ok entity: (aRequest isGet 
				ifTrue: [self responseToGet: aRequest]
				ifFalse: [self responseToPost: aRequest])!

responseToGet: aRequest 
	| ws name |
	ws := WriteStream on: String new.
	ws
		nextPutAll: '<HTML><HEAD><TITLE>Test Of Sessions</TITLE></HEAD><BODY>';
		cr.
	name := aRequest session at: #name.
	name isNil 
		ifFalse: 
			[ws
				nextPutAll: '<P>Welcome back, ';
				nextPutAll: name;
				nextPutAll: '.</P>';
				cr].
	ws
		nextPutAll: '<P>What is your name?</P>';
		nextPutAll: '<FORM method="POST"><INPUT name="name" type="text"><INPUT type="submit"></FORM>';
		cr.
	ws nextPutAll: '</BODY></HTML>'.
	^ws contents!

responseToPost: aRequest 
	aRequest postDataAt: 'name'
		do: [:datum | aRequest session at: #name put: datum value].
	^self responseToGet: aRequest! !
!SessionTestResource categoriesFor: #answerTo:!public!serving! !
!SessionTestResource categoriesFor: #responseToGet:!private! !
!SessionTestResource categoriesFor: #responseToPost:!private! !

AuthorizationResource guid: (GUID fromString: '{C11178BC-B336-4FDE-B29E-8CDD6A7F63B7}')!
AuthorizationResource comment: ''!
!AuthorizationResource categoriesForClass!Unclassified! !
!AuthorizationResource methodsFor!

answerTo: aRequest 
	aRequest tailPath isEmpty ifFalse: [^nil].
	^(self requestIsLogin: aRequest) 
		ifTrue: 
			[(self authorizeLogin: aRequest) 
				ifTrue: [self redirectionResponse]
				ifFalse: [self loginIncorrectResponse]]
		ifFalse: [self loginResponse]!

authorizedLogins
	^self subclassResponsibility!

authorizeLogin: aRequest 
	| login password authorized |
	login := (aRequest postDataAt: 'login' ifAbsent: [^false]) value.
	password := (aRequest postDataAt: 'password' ifAbsent: [^false]) value.
	authorized := (self authorizedLogins includes: login) 
				and: [(self passwordForLogin: login) = password].
	authorized ifTrue: [aRequest session at: #authorizedLogin put: login].
	^authorized!

authorizeSession: aSession 
	| login |
	login := aSession at: #authorizedLogin.
	^login isNil not and: [self authorizedLogins includes: login]!

helpResolve: aResolution 
	(aResolution atEnd 
		or: [self authorizeSession: aResolution request session]) ifFalse: [^nil].
	^super helpResolve: aResolution!

loginIncorrectResponse
	| response ws |
	response := HTTPResponse ok.
	ws := WriteStream on: String new.
	ws
		nextPutAll: '<HTML>';
		cr;
		nextPutAll: '<HEAD><TITLE>Login Incorrect</TITLE></HEAD>';
		cr;
		nextPutAll: '<BODY bgcolor="#ffffff">';
		cr;
		nextPutAll: '<H2>Login Incorrect</H2>';
		cr;
		nextPutAll: '<P>Login incorrect.  Please go back and try again.</P>';
		cr;
		nextPutAll: '</BODY>';
		cr;
		nextPutAll: '</HTML>'.
	response entity: ws contents.
	^response!

loginResponse
	| response ws |
	response := HTTPResponse ok.
	ws := WriteStream on: String new.
	ws
		nextPutAll: '<HTML>';
		cr;
		nextPutAll: '<HEAD><TITLE>Login Required</TITLE></HEAD>';
		cr;
		nextPutAll: '<BODY bgcolor="#ffffff">';
		cr;
		nextPutAll: '<H2>Login Required</H2>';
		cr;
		nextPutAll: '<P>You must enter a valid login and password before accessing resources beyond this point.</P>';
		cr;
		nextPutAll: '<FORM method="POST">';
		cr;
		nextPutAll: '<INPUT type="hidden" name="swazooCommand" value="login">';
		cr;
		nextPutAll: '<TABLE>';
		cr;
		nextPutAll: '<TR><TD>Login: </TD><TD><INPUT type="text" name="login"></TD></TR>';
		cr;
		nextPutAll: '<TR><TD>Password: </TD><TD><INPUT type="password" name="password"></TD></TR>';
		cr;
		nextPutAll: '</TABLE>';
		cr;
		nextPutAll: '<INPUT type="submit" value="Login">';
		cr;
		nextPutAll: '</FORM>';
		cr;
		nextPutAll: '</BODY>';
		cr;
		nextPutAll: '</HTML>'.
	response entity: ws contents.
	^response!

passwordForLogin: aString 
	^self subclassResponsibility!

redirectionResponse
	^(HTTPResponse found)
		addHeaderName: 'Location' value: self targetUri;
		yourself!

requestIsLogin: aRequest 
	aRequest isPost ifFalse: [^false].
	aRequest postDataAt: 'swazooCommand'
		do: [:datum | datum value = 'login' ifTrue: [^true]].
	^false!

setTargetUri: aString 
	self targetUri: aString!

targetUri
	^targetUri!

targetUri: aString
	targetUri := aString! !
!AuthorizationResource categoriesFor: #answerTo:!public!serving! !
!AuthorizationResource categoriesFor: #authorizedLogins!private-accessing!public! !
!AuthorizationResource categoriesFor: #authorizeLogin:!private! !
!AuthorizationResource categoriesFor: #authorizeSession:!private! !
!AuthorizationResource categoriesFor: #helpResolve:!accessing!public! !
!AuthorizationResource categoriesFor: #loginIncorrectResponse!private! !
!AuthorizationResource categoriesFor: #loginResponse!private! !
!AuthorizationResource categoriesFor: #passwordForLogin:!private-accessing!public! !
!AuthorizationResource categoriesFor: #redirectionResponse!private! !
!AuthorizationResource categoriesFor: #requestIsLogin:!private! !
!AuthorizationResource categoriesFor: #setTargetUri:!private-initialize!public! !
!AuthorizationResource categoriesFor: #targetUri!private-accessing!public! !
!AuthorizationResource categoriesFor: #targetUri:!private-accessing!public! !

!AuthorizationResource class methodsFor!

uriPattern: aString targetUri: anotherString 
	^(self uriPattern: aString) setTargetUri: anotherString! !
!AuthorizationResource class categoriesFor: #uriPattern:targetUri:!instance creation!public! !

CookieSessionResource guid: (GUID fromString: '{1B8A3FC1-9402-4CFC-B098-576EB23D098F}')!
CookieSessionResource comment: ''!
!CookieSessionResource categoriesForClass!Unclassified! !
!CookieSessionResource methodsFor!

existingSessionResolutionTo: aResolution 
	| session response request |
	request := aResolution request.
	session := self lookupSessionIn: request.
	^session isNil 
		ifTrue: [self newSessionResolutionTo: aResolution]
		ifFalse: 
			[request session: session.
			response := super helpResolve: aResolution.
			response isNil ifTrue: [request session: nil] ifFalse: [session touch].
			response]!

expirationProcess
	^expirationProcess!

expirationProcess: aProcess
	expirationProcess := aProcess!

forget: session 
	self lock critical: 
			[self sessions removeKey: session id.
			self sessions isEmpty ifTrue: [self stopExpirationProcess]]!

helpResolve: aResolution 
	^aResolution request hasCookie 
		ifTrue: [self existingSessionResolutionTo: aResolution]
		ifFalse: [self newSessionResolutionTo: aResolution]!

initialize
	super initialize.
	self initSessions.
	self initLock!

initLock
	#spmTodo. "Verify that Mutex is replacable for a RecursionLock in VW - add to platform Platform current newRecursionLock"
	lock := Mutex new!

initSessions
	sessions := Dictionary new!

lock
	lock isNil ifTrue: [self initLock].
	^lock!

lookupSessionIn: aRequest 
	| rs |
	rs := ReadStream on: aRequest cookie.
	rs upTo: $=.
	^self lock critical: [self sessions at: (rs upTo: $;) ifAbsent: [nil]]!

newSession
	| session id |
	session := SwazooSession new.
	self lock critical: 
			[
			[id := SwazooPlatform current newRandomString: 25.
			self sessions includesKey: id] whileTrue.
			session id: id.
			self remember: session].
	^session!

newSessionResolutionTo: aResolution 
	| session response request myPath |
	session := self newSession.
	request := aResolution request.
	request session: session.
	myPath := aResolution currentPath.
	response := super helpResolve: aResolution.
	response isNil 
		ifTrue: 
			[request session: nil.
			self forget: session]
		ifFalse: 
			[self 
				setCookieFor: session
				in: response
				path: myPath].
	^response!

nudgeExpirationProcess
	self expirationProcess isNil ifTrue: [self startExpirationProcess]!

remember: aSession 
	self lock critical: 
			[self sessions at: aSession id put: aSession.
			self nudgeExpirationProcess]!

secondsBeforeExpiration
	^1800	"30 minutes"!

sessions
	sessions isNil ifTrue: [self initSessions].
	^sessions!

setCookieFor: aSession in: aResponse path: aResourcePath 
	| ws |
	ws := WriteStream on: String new.
	ws
		nextPutAll: 'session=';
		nextPutAll: aSession id;
		nextPutAll: '; path=/'.
	aResourcePath size > 1 
		ifTrue: 
			[(aResourcePath copyFrom: 2 to: aResourcePath size) do: 
					[:each | 
					ws
						nextPutAll: each;
						nextPut: $/]].
	aResponse addHeaderName: 'Set-Cookie' value: ws contents!

startExpirationProcess
	| expired nowTime |
	self expirationProcess: 
			[
			[(Delay forSeconds: 60) wait.
			expired := OrderedCollection new.
			self lock critical: 
					[nowTime := TimeStamp current asSeconds.
					self sessions do: 
							[:each | 
							each timestamp asSeconds + self secondsBeforeExpiration < nowTime 
								ifTrue: [expired add: each]].
					expired do: [:each | self forget: each]]] 
					repeat] 
					fork!

stopExpirationProcess
	| mightBeMe |
	self expirationProcess isNil ifTrue: [^self].
	mightBeMe := self expirationProcess.
	self expirationProcess: nil.
	mightBeMe terminate! !
!CookieSessionResource categoriesFor: #existingSessionResolutionTo:!private! !
!CookieSessionResource categoriesFor: #expirationProcess!private! !
!CookieSessionResource categoriesFor: #expirationProcess:!private! !
!CookieSessionResource categoriesFor: #forget:!private! !
!CookieSessionResource categoriesFor: #helpResolve:!accessing!public! !
!CookieSessionResource categoriesFor: #initialize!private-initialize!public! !
!CookieSessionResource categoriesFor: #initLock!public! !
!CookieSessionResource categoriesFor: #initSessions!private-initialize!public! !
!CookieSessionResource categoriesFor: #lock!private! !
!CookieSessionResource categoriesFor: #lookupSessionIn:!private! !
!CookieSessionResource categoriesFor: #newSession!private! !
!CookieSessionResource categoriesFor: #newSessionResolutionTo:!private! !
!CookieSessionResource categoriesFor: #nudgeExpirationProcess!private-expiration!public! !
!CookieSessionResource categoriesFor: #remember:!private! !
!CookieSessionResource categoriesFor: #secondsBeforeExpiration!private-expiration!public! !
!CookieSessionResource categoriesFor: #sessions!private! !
!CookieSessionResource categoriesFor: #setCookieFor:in:path:!private! !
!CookieSessionResource categoriesFor: #startExpirationProcess!public! !
!CookieSessionResource categoriesFor: #stopExpirationProcess!private-expiration!public! !

ACLResource guid: (GUID fromString: '{BE1062D4-BCF8-4988-B75D-8A238AA6C162}')!
ACLResource comment: ''!
!ACLResource categoriesForClass!Unclassified! !
!ACLResource methodsFor!

authorizedLogins
	^self users keys!

initUsers
	self users: Dictionary new!

passwordForLogin: aString 
	^self users at: aString!

readUsersFrom: aStream 
	| pair |
	self initUsers.
	[aStream atEnd] whileFalse: 
			[pair := SwazooPlatform current string: (SwazooPlatform current streamNextLine: aStream) tokensBasedOn: $,.
			self users at: pair first put: pair last]!

setUsers: aDictionary 
	self users: aDictionary!

users
	users isNil ifTrue: [self initUsers].
	^users!

users: aDictionary
	users := aDictionary! !
!ACLResource categoriesFor: #authorizedLogins!private-accessing!public! !
!ACLResource categoriesFor: #initUsers!private-initialize!public! !
!ACLResource categoriesFor: #passwordForLogin:!private-accessing!public! !
!ACLResource categoriesFor: #readUsersFrom:!private-initialize!public! !
!ACLResource categoriesFor: #setUsers:!private-initialize!public! !
!ACLResource categoriesFor: #users!private-accessing!public! !
!ACLResource categoriesFor: #users:!accessing!public! !

!ACLResource class methodsFor!

uriPattern: aString targetUri: anotherString listFile: aFilePath 
	| rs inst |
	rs := aFilePath asFilename readStream.
	inst := self uriPattern: aString targetUri: anotherString.
	[inst readUsersFrom: rs] ensure: [rs close].
	^inst! !
!ACLResource class categoriesFor: #uriPattern:targetUri:listFile:!instance creation!public! !

FileResource guid: (GUID fromString: '{B71F7826-5BA7-4D01-8B0B-10108F2DC3EA}')!
FileResource comment: ''!
!FileResource categoriesForClass!Unclassified! !
!FileResource methodsFor!

contentTypeFor: aString 
	^ContentTypes at: aString ifAbsent: ['application/octet-stream']!

file: aFilename answerTo: aRequest 
	| cacheControl response |
	cacheControl := SwazooCacheControl new request: aRequest
				cacheTarget: aFilename.
	response := cacheControl isNotModified 
				ifTrue: [HTTPResponse notModified]
				ifFalse: 
					[FileResponse ok entity: ((MimeObject new)
								value: aFilename;
								contentType: (self contentTypeFor: aFilename extension))].
	cacheControl addResponseHeaders: response.
	^response! !
!FileResource categoriesFor: #contentTypeFor:!public! !
!FileResource categoriesFor: #file:answerTo:!private! !

!FileResource class methodsFor!

initialize
	"self initialize"

	ContentTypes := (Dictionary new)
				add: '.txt' -> 'text/plain';
				add: '.html' -> 'text/html';
				add: '.htm' -> 'text/html';
				add: '.css' -> 'text/css';
				add: '.png' -> 'image/png';
				add: '.gif' -> 'image/gif';
				add: '.jpg' -> 'image/jpeg';
				add: '.m3u' -> 'audio/mpegurl';
				add: '.ico' -> 'image/x-icon';
				add: '.pdf' -> 'application/pdf';
				yourself! !
!FileResource class categoriesFor: #initialize!public! !

SwazooActivePageResource guid: (GUID fromString: '{8F5D42B0-5EAA-40D3-8AA4-117D0CD8B7DC}')!
SwazooActivePageResource comment: ''!
!SwazooActivePageResource categoriesForClass!Unclassified! !
!SwazooActivePageResource methodsFor!

file: aFilename answerTo: aRequest 
	| page |
	(self shouldInterpret: aFilename) ifFalse: [^nil].
	page := SwazooActivePage file: aFilename request: aRequest.
	^(HTTPResponse ok)
		contentType: 'text/html';
		entity: page asHTML!

shouldInterpret: aFilename 
	^aFilename extension = '.sap'! !
!SwazooActivePageResource categoriesFor: #file:answerTo:!accessing!public! !
!SwazooActivePageResource categoriesFor: #shouldInterpret:!private! !

HomeResource guid: (GUID fromString: '{7DA6CB37-FB1F-45F4-A1EE-262A887F549E}')!
HomeResource comment: ''!
!HomeResource categoriesForClass!Unclassified! !
!HomeResource methodsFor!

answerTo: aRequest 
	aRequest tailPath isEmpty ifTrue: [^nil].
	(self validateHomePath: aRequest tailPath first) ifFalse: [^nil].
	^super answerTo: aRequest!

rootFileFor: aRequest 
	| homeKey file |
	homeKey := aRequest tailPath first copyFrom: 2
				to: aRequest tailPath first size.
	file := (self fileDirectory construct: homeKey) construct: 'html'.
	(aRequest tailPath copyFrom: 2 to: aRequest tailPath size) 
		do: [:each | each = '..' ifFalse: [file := file construct: each]].
	^file!

validateHomePath: aString 
	^aString first = $~! !
!HomeResource categoriesFor: #answerTo:!accessing!public! !
!HomeResource categoriesFor: #rootFileFor:!private! !
!HomeResource categoriesFor: #validateHomePath:!private! !

ExampleSidebarResource guid: (GUID fromString: '{1EC0EDF7-24A7-4DD5-B290-E3A2AC607688}')!
ExampleSidebarResource comment: ''!
!ExampleSidebarResource categoriesForClass!Unclassified! !
!ExampleSidebarResource methodsFor!

sidebarResponseTo: aRequest 
	^HTTPResponse ok 
		entity: '
<HTML>
<HEAD>
 <TITLE>Swazoo Sites</TITLE>
</HEAD>
<BODY bgcolor="#ffffff">
<B>The following sites are running on Swazoo:</B>
<UL>
 <LI><A target=''_content'' href="http://www.eranova.si">Eranova</A></LI>
 <LI><A target=''_content'' href="http://www.reasonability.net">Reasonability</A></LI>
 <LI><A target=''_content'' href="http://www.signalground.com">Signal Ground</A></LI>
 <LI><A target=''_content'' href="http://www.swazoo.org">swazoo.org</A> (soon!!)</LI>
</UL>
</BODY>
</HTML>'!

title
	^'Swazoo Sites'! !
!ExampleSidebarResource categoriesFor: #sidebarResponseTo:!private! !
!ExampleSidebarResource categoriesFor: #title!private-accessing!public! !

"Binary Globals"!

