| package |
package := Package name: 'Swazoo-Platform-VisualWorks'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: '0.006'.


package classNames
	add: #VisualWorksSwazooPlatform;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: 'Swazoo-Platform';
	add: 'Swazoo-Platform-VisualWorks-PlaceHolders';
	yourself).

package!

"Class Definitions"!

SwazooPlatform subclass: #VisualWorksSwazooPlatform
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

VisualWorksSwazooPlatform guid: (GUID fromString: '{EF57A8BC-9CEA-41D1-9D27-B96D9E64EC18}')!
VisualWorksSwazooPlatform comment: ''!
!VisualWorksSwazooPlatform categoriesForClass!Unclassified! !
!VisualWorksSwazooPlatform methodsFor!

base64DecodeAsString: aString 
	^(Base64EncodingReadStream on: aString) upToEnd asByteString!

newTCPServer
	^SocketAccessor newTCP!

newTCPSocket
	^SocketAccessor newTCP!

socket: aSocket connectToHostNamed: aStringHost port: anIntegerPort
	| fa |
	fa := IPSocketAddress hostName: aStringHost port: anIntegerPort.
	[ aSocket connectTo: fa] ifCurtailed: [aSocket close ].!

socket: aSocket listenFor: anIntegerBacklog
	aSocket listenFor: anIntegerBacklog!

socket: aSocket listenOn: anIntegerPort backlogSize: anIntegerBacklog
	| address |
	address := IPSocketAddress hostAddress: IPSocketAddress thisHost port: anIntegerPort.
	[ aSocket bindTo: address.
		aSocket listenFor: anIntegerBacklog ] ifCurtailed: [ aSocket close].!

socket: aSocket read: anIntegerSize
	| buffer bytesRead |
	buffer := ByteArray new: anIntegerSize.
	bytesRead := aSocket readInto: buffer.
	^buffer copyFrom: 1 to: bytesRead!

socket: aSocket read: anIntegerSize timeout: anIntegerTimeout
	^(aSocket readWaitWithTimeoutMs: anIntegerTimeout) 
		ifTrue: [ByteArray new]
		ifFalse: [self read: anIntegerSize]!

socketAccept: aSocket
	^aSocket accept!

socketClose: aSocket
	aSocket close.!

socketLocalAddress: aSocket
	^aSocket getName ipString!

socketPeerAddress: aSocket
	^aSocket getPeer ipString!

streamNextLine: aGettableStream
	^aGettableStream upTo: Character cr!

stringWithInternetLineEndings: aString
	| stream |
	stream := EncodedStream on: ByteArray new readWriteStream
				encodedBy: (ByteStreamEncoder new: #default).
	stream lineEndCRLF.
	stream nextPutAll: aString.
	stream lineEndTransparent.
	stream reset.
	^stream contents asString!

stringWithUnixLineEndings: aString
	| stream |
	stream := EncodedStream on: ByteArray new readWriteStream
				encodedBy: (ByteStreamEncoder new: #default).
	stream lineEndTransparent.
	stream nextPutAll: aString.
	stream lineEndCRLF.
	stream reset.
	^stream contents asString! !
!VisualWorksSwazooPlatform categoriesFor: #base64DecodeAsString:!public! !
!VisualWorksSwazooPlatform categoriesFor: #newTCPServer!public! !
!VisualWorksSwazooPlatform categoriesFor: #newTCPSocket!public! !
!VisualWorksSwazooPlatform categoriesFor: #socket:connectToHostNamed:port:!public! !
!VisualWorksSwazooPlatform categoriesFor: #socket:listenFor:!public! !
!VisualWorksSwazooPlatform categoriesFor: #socket:listenOn:backlogSize:!public! !
!VisualWorksSwazooPlatform categoriesFor: #socket:read:!public! !
!VisualWorksSwazooPlatform categoriesFor: #socket:read:timeout:!public! !
!VisualWorksSwazooPlatform categoriesFor: #socketAccept:!public! !
!VisualWorksSwazooPlatform categoriesFor: #socketClose:!public! !
!VisualWorksSwazooPlatform categoriesFor: #socketLocalAddress:!public! !
!VisualWorksSwazooPlatform categoriesFor: #socketPeerAddress:!public! !
!VisualWorksSwazooPlatform categoriesFor: #streamNextLine:!public! !
!VisualWorksSwazooPlatform categoriesFor: #stringWithInternetLineEndings:!public! !
!VisualWorksSwazooPlatform categoriesFor: #stringWithUnixLineEndings:!public! !

"Binary Globals"!

