| package |
package := Package name: 'Swazoo-AIDA'.
package paxVersion: 1;
	basicComment: ''.


package classNames
	add: #AIDAInstallSwazooAIDA;
	yourself.

package methodNames
	add: #HTTPPostDatum -> #filenameWithoutPath;
	add: #HTTPRequest -> #ajaxElementId;
	add: #HTTPRequest -> #idFromCookie;
	add: #HTTPRequest -> #isAjaxAutocompleteRequest;
	add: #HTTPRequest -> #isAjaxInPlaceEditingRequest;
	add: #HTTPRequest -> #isAjaxPostRequest;
	add: #HTTPRequest -> #isAjaxRequest;
	add: #HTTPRequest -> #isAjaxWikiFormatedRequest;
	add: #HTTPRequest -> #isWapRequest;
	add: #HTTPRequest -> #isWebRequest;
	add: #SwazooServer -> #demoStart;
	add: #SwazooServer -> #demoStop;
	add: 'SwazooServer class' -> #demoStart;
	add: 'SwazooServer class' -> #demoStop;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'AIDA core';
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\Swazoo\Swazoo';
	yourself).

package!

"Class Definitions"!

Object subclass: #AIDAInstallSwazooAIDA
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

!HTTPPostDatum methodsFor!

filenameWithoutPath
	"M$ Internet Explorer includes full path in filename of uploaded file!! "
	^(self filename includes: $\ ) 
		ifTrue: [self filename copyFrom: (self filename lastIndexOf: $\ )+1 to: self filename size]
		ifFalse: [self filename]! !
!HTTPPostDatum categoriesFor: #filenameWithoutPath!accessing!private! !

!HTTPRequest methodsFor!

ajaxElementId
	"Asynchronous JavaScript (AJAX) request, it has additional parameter ajaxGetElementId"
	| id |
	id := self queryAt: 'ajaxGetElementId' ifAbsent: [nil].
	id notNil ifTrue: [^id asSymbol].
	^self isPost 
		ifTrue: [(self postDataAt: 'ajaxGetElementId' ifAbsent: [^nil]) value asSymbol]
		ifFalse: [nil]!

idFromCookie
	"return session id from our cookie. nil if not aida field present in cookie"
	| stream part |
	stream := self cookie readStream.
	[stream atEnd] whileFalse:
		[part := stream upTo: $; .
		('aida9357*' match: part) ifTrue:
			[^part readStream upTo: $=; upToEnd] ].
	^nil!

isAjaxAutocompleteRequest
	"AJAX autocomplete input field request, see WebAutocompleteField"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'ajaxAutocompleteField'!

isAjaxInPlaceEditingRequest
	"AJAX in place editor request, see WebInPlaceEditingText"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'ajaxInPlaceEditing'!

isAjaxPostRequest
	"Asynchronous JavaScript (AJAX) request, with posting an input field in a query"
	self isAjaxRequest ifFalse: [^false].
	self isPost ifTrue: [^true].
	^self queryData keys contains: [:each | 'field*' match: each].!

isAjaxRequest
	"Asynchronous JavaScript (AJAX) request, it has additional parameter ajaxRequest"
	^(self headerAt: 'X-Requested-With' ifAbsent: [^false]) value = 'XMLHttpRequest'!

isAjaxWikiFormatedRequest
	"AJAX in place editor request, see WebInPlaceEditingText"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'wikiFormated'!

isWapRequest
	"true, if this is a request for a WAP page, eg. .wml on the end of url"
	^'*.wml*' match: self urlString!

isWebRequest
	^self isWapRequest not! !
!HTTPRequest categoriesFor: #ajaxElementId!accessing-queries!private! !
!HTTPRequest categoriesFor: #idFromCookie!accessing!private! !
!HTTPRequest categoriesFor: #isAjaxAutocompleteRequest!private!testing! !
!HTTPRequest categoriesFor: #isAjaxInPlaceEditingRequest!private!testing! !
!HTTPRequest categoriesFor: #isAjaxPostRequest!private!testing! !
!HTTPRequest categoriesFor: #isAjaxRequest!private!testing! !
!HTTPRequest categoriesFor: #isAjaxWikiFormatedRequest!private!testing! !
!HTTPRequest categoriesFor: #isWapRequest!private!testing! !
!HTTPRequest categoriesFor: #isWebRequest!private!testing! !

!SwazooServer methodsFor!

demoStart
	(self siteNamed: 'test') isNil ifTrue:
		[AIDASite newNamed: 'test'].
	self startSite: 'test'!

demoStop
	self stopSite: 'test'! !
!SwazooServer categoriesFor: #demoStart!private!start/stop! !
!SwazooServer categoriesFor: #demoStop!private!start/stop! !

!SwazooServer class methodsFor!

demoStart
	self singleton demoStart!

demoStop
	self singleton demoStop! !
!SwazooServer class categoriesFor: #demoStart!public!start/stop! !
!SwazooServer class categoriesFor: #demoStop!public!start/stop! !

"End of package definition"!

"Source Globals"!

"Classes"!

AIDAInstallSwazooAIDA guid: (GUID fromString: '{52CB88B5-C7F3-43E0-9955-F32CD78C8B2C}')!
AIDAInstallSwazooAIDA comment: ''!
!AIDAInstallSwazooAIDA categoriesForClass!Unclassified! !
"Binary Globals"!

