| package |
package := Package name: 'Swazoo-Platform-Dolphin'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: '0.020'.


package classNames
	add: #DolphinSwazooPlatform;
	add: #MD5;
	add: #ThirtyTwoBitRegister;
	add: #Timestamp;
	add: #VWFilename;
	yourself.

package methodNames
	add: #Character -> #isHTTPReserved;
	add: #KernelLibrary -> #getSystemTime:;
	add: #ShlwapiLibrary -> #pathGetCharType:;
	add: #ShlwapiLibrary -> #pathIsDirectory:;
	add: #String -> #asFilename;
	add: #String -> #httpDecoded;
	add: #String -> #httpEncoded;
	add: #TimeStamp -> #day;
	add: #TimeStamp -> #hour;
	add: #TimeStamp -> #minute;
	add: #TimeStamp -> #month;
	add: #TimeStamp -> #rfc1123String;
	add: #TimeStamp -> #year;
	add: 'SYSTEMTIME class' -> #nowUTC;
	add: 'TimeStamp class' -> #currentUTC;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\..\Object Arts\Dolphin\System\Base64\Dolphin Base64';
	add: '..\..\Object Arts\Dolphin\Sockets\Dolphin Sockets';
	add: 'Swazoo-Platform';
	yourself).

package!

"Class Definitions"!

Object subclass: #MD5
	instanceVariableNames: 'state'
	classVariableNames: 'ABCDTable IndexTable ShiftTable SinTable'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #ThirtyTwoBitRegister
	instanceVariableNames: 'hi low'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #Timestamp
	instanceVariableNames: 'date time'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #VWFilename
	instanceVariableNames: 'name locator'
	classVariableNames: ''
	poolDictionaries: 'Win32Constants'
	classInstanceVariableNames: ''!
SwazooPlatform subclass: #DolphinSwazooPlatform
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

!Character methodsFor!

isHTTPReserved
	^(self isAlphaNumeric or: ['-_.!!~*''()' includes: self]) not! !
!Character categoriesFor: #isHTTPReserved!public! !

!KernelLibrary methodsFor!

getSystemTime: aWinSYSTEMTIME
	"Retrieve the current local date and time.
		VOID GetSystemTime(
  			LPSYSTEMTIME  lpSystemTime 	// address of system time structure  
		);"

	<stdcall: void GetSystemTime SYSTEMTIME* >
	^self invalidCall! !
!KernelLibrary categoriesFor: #getSystemTime:!public!win32 functions-date and time! !

!ShlwapiLibrary methodsFor!

pathGetCharType: aChar
	"UINT PathGetCharType(
    TUCHAR ch
    );
Determines the type of character with respect to a path. 
"

	<stdcall: dword PathGetCharTypeA char>
	^self invalidCall
"GCT_INVALID The character is not valid in a path. 0x0000
GCT_LFNCHAR The character is valid in a long file name. 0x0001
GCT_SEPARATOR The character is a path separator. 
GCT_SHORTCHAR The character is valid in a short (8.3) file name. 
GCT_WILD The character is a wildcard character. 
"!

pathIsDirectory: pszPath
	"Verifies that a path is a valid directory."

	<stdcall: bool PathIsDirectoryA lpstr>
	^self invalidCall! !
!ShlwapiLibrary categoriesFor: #pathGetCharType:!public!win32 functions-path! !
!ShlwapiLibrary categoriesFor: #pathIsDirectory:!public!win32 functions-path! !

!String methodsFor!

asFilename
	^VWFilename named: self!

httpDecoded
	^UrlEncodingPolicy new decode: self!

httpEncoded
	^UrlEncodingPolicy new encode: self! !
!String categoriesFor: #asFilename!converting!public!sw! !
!String categoriesFor: #httpDecoded!public! !
!String categoriesFor: #httpEncoded!public! !

!SYSTEMTIME class methodsFor!

nowUTC
	"Private - Answer the current Windows local time"
	
	| answer |
	answer := self new.
	KernelLibrary default getSystemTime: answer.
	^answer! !
!SYSTEMTIME class categoriesFor: #nowUTC!private! !

!TimeStamp methodsFor!

day
	^self date day!

hour
	^self time hours!

minute
	^self time minutes!

month
	^self date monthIndex!

rfc1123String
	"Tue, 11 Oct 2005 12:02:22 GMT"
	| stream |
	stream := String writeStream.
	self date printOn: stream format: 'ddd, dd MMM yyyy'.
	stream nextPutAll: ' '.
	self time printOn: stream format: 'HH:mm:ss'.
	stream nextPutAll: ' GMT'.
	^stream contents!

year
	^self date year! !
!TimeStamp categoriesFor: #day!public! !
!TimeStamp categoriesFor: #hour!public! !
!TimeStamp categoriesFor: #minute!public! !
!TimeStamp categoriesFor: #month!public! !
!TimeStamp categoriesFor: #rfc1123String!public! !
!TimeStamp categoriesFor: #year!public! !

!TimeStamp class methodsFor!

currentUTC
	"Answer a new instance of the receiver representing the current
	date and time"

	^self fromSYSTEMTIME: SYSTEMTIME nowUTC! !
!TimeStamp class categoriesFor: #currentUTC!public! !

"End of package definition"!

"Source Globals"!

"Classes"!

MD5 guid: (GUID fromString: '{FA0C31D4-0F14-4D7E-99E4-7CDA284CC053}')!
MD5 comment: '''From Squeak3.1alpha of 20 February 2001 [latest update: #3679] on 23 February 2001 at 10:54:55 pm''!!
"Change Set:		MD5
Date:			20 January 2000
Author:			Duane Maxwell/EntryPoint

This changeset implements the MD5 128-bit one-way hash function.  It relies
on the ThirtyTwoBitRegister class supplied as part of the Digital
Signatures functionality included in Squeak 2.7.  As of this date
(1/20/2000), the U.S. Government has lifted many of the previous
restrictions on the export of encryption software, but you should check
before exporting anything including this code.  MD5 is commonly used for
some secure Internet protocols, including authentication in HTTP, which is
why I wrote it.

Submitted by Duane Maxwell.
Minor reformating to correct mail-wrapped lines by mdr
=====================
This class implements the MD5 128-bit one-way hash function.  It relies on
the ThirtyTwoBitRegister class supplied as part of the "Digital Signatures"
functionality included in Squeak 2.7.  As of this date (1/20/2000), the
U.S. Government has lifted many of the previous restrictions on the export
of encryption software, but you should check before exporting anything
including this code.  MD5 is commonly used for some secure Internet
protocols, including authentication in HTTP, which is why I wrote it.

Submitted by Duane Maxwell


'!
!MD5 categoriesForClass!Unclassified! !
!MD5 methodsFor!

ffA: a B: b C: c D: d M: m S: s T: t
	"compute a = b + ((a + f(b,c,d) + m + t) <<< s)
	'DSM 1/20/2000 13:38'"
	^ a += (self fX: b Y: c Z: d); += m; += t; leftRotateBy: s; += b.
!

finalValue
	"Concatenate the state values to produce the 128-bite result
	'DSM 1/20/2000 17:56'"
	^ (( state at: 1) asReverseInteger bitShift: 96) +
	  (( state at: 2) asReverseInteger bitShift: 64) +
	  (( state at: 3) asReverseInteger bitShift: 32) +
	  (( state at: 4) asReverseInteger)!

fX: x Y: y Z: z
	" compute 'xy or (not x)z'
	'DSM 1/20/2000 01:47'"
	^ x copy bitAnd: y; bitOr: (x copy bitInvert; bitAnd: z)
!

ggA: a B: b C: c D: d M: m S: s T: t
	"compute a = b + ((a + g(b,c,d) + m + t) <<< s)
	'DSM 1/20/2000 13:38'"
	^ a += (self gX: b Y: c Z: d); += m; += t; leftRotateBy: s; += b.
!

gX: x Y: y Z: z
	" compute 'xz or y(not z)'
	'DSM 1/20/2000 01:48'"
	^ x copy bitAnd: z; bitOr: (z copy bitInvert; bitAnd: y)

	!

hashMessage: aStringOrByteArray
	"MD5 new hashMessage: 'foo'
	'DSM 1/20/2000 15:29'"
	^ self hashStream: (ReadStream on: aStringOrByteArray asByteArray)
!

hashStream: aPositionableStream
	"MD5 new hashStream: (ReadStream on: 'foo')
	'mdr 2/23/2001 22:49'"
	| startPosition buf bitLength |
	self initialize.

	"aPositionableStream atEnd ifTrue: [self error: 'empty stream']."

	startPosition := aPositionableStream position.
	[aPositionableStream atEnd] whileFalse: [
		"swChanged; modified from #next: "
		buf := aPositionableStream nextAvailable: 64.
		(aPositionableStream atEnd not and: [buf size = 64])
			ifTrue: [self processBuffer: buf]
			ifFalse: [
				bitLength := (aPositionableStream position - startPosition) * 8.
				self processFinalBuffer: buf bitLength: bitLength]].

	^ self finalValue
!

hhA: a B: b C: c D: d M: m S: s T: t
	"compute a = b + ((a + h(b,c,d) + m + t) <<< s)
	'DSM 1/20/2000 13:38'"
	^ a += (self hX: b Y: c Z: d); += m; += t; leftRotateBy: s; += b.
!

hX: x Y: y Z: z
	" compute 'x xor y xor z'
	'DSM 1/20/2000 01:48'"
	^ x copy bitXor: y; bitXor: z

	!

iiA: a B: b C: c D: d M: m S: s T: t
	"compute a = b + ((a + i(b,c,d) + m + t) <<< s)
	'DSM 1/20/2000 13:39'"
	^ a += (self iX: b Y: c Z: d); += m; += t; leftRotateBy: s; += b.
!

initialize
	"Some magic numbers to get the process started
	 'DSM 1/20/2000 17:56'"
	
	"swChanged; modified from squeak's {}"
	state := OrderedCollection 
		with: 	(ThirtyTwoBitRegister new load: 16r67452301)
		with: (ThirtyTwoBitRegister new load: 16rEFCDAB89)
		with: (ThirtyTwoBitRegister new load: 16r98BADCFE)
		with: (ThirtyTwoBitRegister new load: 16r10325476)
!

iX: x Y: y Z: z
	" compute 'y xor (x or (not z))'
	'DSM 1/20/2000 01:48'!!"
	^ y copy bitXor: (z copy bitInvert; bitOr: x)
!

processBuffer: aByteArray
	"Process a 64-byte buffer
	'mdr 2/23/2001 22:50'"

	| saveState data |
	saveState := state collect: [ :item | item copy ].
	data := Array new: 16.
	1 to: 16 do: [ :index |
		data at: index put:
			(ThirtyTwoBitRegister new reverseLoadFrom: aByteArray at: (index * 4) - 3)].
	self rounds: data.
	1 to: 4 do: [ :index | (state at: index) += (saveState at: index) ].
!

processFinalBuffer: aByteArray bitLength: bitLength
	"Pad the buffer until we have an even 64 bytes, then transform
	'DSM 1/20/2000 17:55'"

	| out |
	out := ByteArray new: 64.
	out replaceFrom: 1 to: aByteArray size with: aByteArray startingAt: 1.
	aByteArray size < 56 ifTrue: [
		out at: aByteArray size + 1 put: 128. "trailing bit"
		self storeLength: bitLength in: out.
		self processBuffer: out.
		^ self].

	"not enough room for the length, so just pad this one, then..."
	aByteArray size < 64 ifTrue: [ out at: aByteArray size + 1 put: 128 ].
	self processBuffer: out.

	"process one additional block of padding ending with the length"
	out := ByteArray new: 64.  "filled with zeros"
	aByteArray size = 64 ifTrue: [ out at: 1 put: 128].
	self storeLength: bitLength in: out.
	self processBuffer: out.
!

round: data selector: selector round: round
	"Do one round with the given function
	'DSM 1/20/2000 17:57'"

	| shiftIndex template abcd |
	1 to: 16 do: [ :i |
		shiftIndex := (i - 1) \\ 4 + 1.
		abcd := ABCDTable at: shiftIndex.
		"swChanged; modified from squeak's {}"
		template := Array new: 7.
		template
			at: 1 put: (abcd at: 1);
			at: 2 put: (abcd at: 2);
			at: 3 put: (abcd at: 3);
			at: 4 put: (abcd at: 4);
			at: 5 put: ((IndexTable at: round) at: i);
			at: 6 put: ((ShiftTable at: round) at: shiftIndex);
			at: 7 put: (	SinTable at: round - 1 * 16 + i ).
		self step: data template: template selector: selector ].
!

rounds: data
	"Perform the four rounds with different functions
	'DSM 1/20/2000 17:58'"
	"swChanged: modified from doWithIndex:"
	#(
	ffA:B:C:D:M:S:T:
	ggA:B:C:D:M:S:T:
	hhA:B:C:D:M:S:T:
	iiA:B:C:D:M:S:T:
	) keysAndValuesDo: [  :index :selector |
		self round: data selector: selector round: index.]
!

step: data template: item selector: selector
	"Perform one step in the round
	 'DSM 1/20/2000 17:58'"

	| args |
	"swChanged; modified from squeak's {}"
	args :=  Array new: 7.
	args
		at: 1 put: (state at: (item at: 1));
		at: 2 put: (state at: (item at: 2));
		at: 3 put: (state at: (item at: 3));
		at: 4 put: (state at: (item at: 4));
		at: 5 put: (data at: (item at: 5));
		at: 6 put: (item at: 6);
		at: 7 put: (item at: 7).

	(self perform: selector withArguments: args).
!

storeLength: bitLength in: aByteArray
	"Fill in the final 8 bytes of the given ByteArray with a 64-bit
	little-endian representation of the original message length in bits.
	'DSM 1/20/2000 17:19'"

	| n i |
	n := bitLength.
	i := aByteArray size - 8 + 1.
	[n > 0] whileTrue: [
		aByteArray at: i put: (n bitAnd: 16rFF).
		n := n bitShift: -8.
		i := i + 1].
! !
!MD5 categoriesFor: #ffA:B:C:D:M:S:T:!functions!private! !
!MD5 categoriesFor: #finalValue!buffers!private! !
!MD5 categoriesFor: #fX:Y:Z:!functions!private! !
!MD5 categoriesFor: #ggA:B:C:D:M:S:T:!functions!private! !
!MD5 categoriesFor: #gX:Y:Z:!functions!private! !
!MD5 categoriesFor: #hashMessage:!operations!public! !
!MD5 categoriesFor: #hashStream:!operations!public! !
!MD5 categoriesFor: #hhA:B:C:D:M:S:T:!functions!private! !
!MD5 categoriesFor: #hX:Y:Z:!functions!private! !
!MD5 categoriesFor: #iiA:B:C:D:M:S:T:!functions!private! !
!MD5 categoriesFor: #initialize!initialization!public! !
!MD5 categoriesFor: #iX:Y:Z:!functions!private! !
!MD5 categoriesFor: #processBuffer:!buffers!private! !
!MD5 categoriesFor: #processFinalBuffer:bitLength:!buffers!private! !
!MD5 categoriesFor: #round:selector:round:!private!rounds! !
!MD5 categoriesFor: #rounds:!private!rounds! !
!MD5 categoriesFor: #step:template:selector:!functions!private! !
!MD5 categoriesFor: #storeLength:in:!buffers!private! !

!MD5 class methodsFor!

clear
	#swAdded.
	ABCDTable := IndexTable := ShiftTable := SinTable := nil!

hashMessage: aStringOrByteArray
	"'DSM 1/20/2000 18:03'"
	^ self new hashMessage: aStringOrByteArray!

hashStream: aPositionableStream
	"'DSM 1/20/2000 18:03'"
	^ self new hashStream: aPositionableStream!

initialize
	"
	MD5 initialize
	'mdr 2/23/2001 22:50'"

	"Obscure fact: those magic hex numbers that are hard to type in correctly are
	actually the result of a simple trigonometric function and are therefore
	easier to compute than proofread.  Laziness is sometimes a virtue."

	| c |
	c := 2 raisedTo: 32.
	SinTable := Array new: 64.
	1 to: 64
		do: [:i | SinTable at: i put: (ThirtyTwoBitRegister new load: (c * i sin abs) truncated)].
	"swChanged; modified from squeak's {}"
	ShiftTable := Array 
				with: #(7 12 17 22)
				with: #(5 9 14 20)
				with: #(4 11 16 23)
				with: #(6 10 15 21).
	IndexTable := Array 
				with: #(1 2 3 4 5 6 7 8 9 10 11 12 13 14 15 16)
				with: #(2 7 12 1 6 11 16 5 10 15 4 9 14 3 8 13)
				with: #(6 9 12 15 2 5 8 11 14 1 4 7 10 13 16 3)
				with: #(1 8 15 6 13 4 11 2 9 16 7 14 5 12 3 10).
	ABCDTable := Array 
				with: #(1 2 3 4)
				with: #(4 1 2 3)
				with: #(3 4 1 2)
				with: #(2 3 4 1)!

test
	"MD5 test
	'mdr 2/23/2001 22:48'"

	(MD5 hashMessage: 'a') = 16r0CC175B9C0F1B6A831C399E269772661
		ifFalse: [ self error: 'failed'].
	(MD5 hashMessage: 'abc') = 16r900150983CD24FB0D6963F7D28E17F72
		ifFalse: [ self error: 'failed'].
	(MD5 hashMessage: 'message digest') = 16rF96B697D7CB7938D525A2F31AAF161D0
		ifFalse: [ self error: 'failed'].
	(MD5 hashMessage:
		'abcdefghijklmnopqrstuvwxyz') = 16rC3FCD3D76192E4007DFB496CCA67E13B
		ifFalse: [ self error: 'failed'].
	(MD5 hashMessage:

	'ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789') =
		16rD174AB98D277D9F5A5611C2C9F419D9F
		ifFalse: [ self error: 'failed'].
	(MD5 hashMessage:
	'12345678901234567890123456789012345678901234567890123456789012345678901234567890') = 		16r57EDF4A22BE3C955AC49DA2E2107B67A
		ifFalse: [ self error: 'failed'].
!

uninitialize
	#swAdded.
	self clear! !
!MD5 class categoriesFor: #clear!class initialization!public! !
!MD5 class categoriesFor: #hashMessage:!public!utilities! !
!MD5 class categoriesFor: #hashStream:!public!utilities! !
!MD5 class categoriesFor: #initialize!class initialization!public! !
!MD5 class categoriesFor: #test!public!testing! !
!MD5 class categoriesFor: #uninitialize!class initialization!private! !

ThirtyTwoBitRegister guid: (GUID fromString: '{74D0064F-5479-4424-B71C-DAD95909AFFF}')!
ThirtyTwoBitRegister comment: '''From Squeak3.0 of 4 February 2001 [latest update: #3545] on 23 September 2001 at 7:54:45 am

I represent a 32-bit register. An instance of me can hold any non-negative integer in the range [0..(2^32 - 1)]. Operations are performed on my contents in place, like a hardware register, and results are always modulo 2^32.

This class is primarily meant for use by the SecureHashAlgorithm class.
'!
!ThirtyTwoBitRegister categoriesForClass!Unclassified! !
!ThirtyTwoBitRegister methodsFor!

+= aThirtTwoBitRegister
	"Replace my contents with the sum of the given register and my current contents.
	'jm 12/7/1999 15:36'"

	| lowSum |
	lowSum := low + aThirtTwoBitRegister low.
	hi := (hi + aThirtTwoBitRegister hi + (lowSum bitShift: -16)) bitAnd: 16rFFFF.
	low := lowSum bitAnd: 16rFFFF.
!

asInteger
	"Answer the integer value of my current contents. 
	'jm 12/14/1999 16:03'"

	^ (hi bitShift: 16) + low
!

asReverseInteger
	"Answer the byte-swapped integer value of my current contents.
	'DSM 1/20/2000 17:17'"

	^ ((low bitAnd: 16rFF) bitShift: 24) +
       ((low bitAnd: 16rFF00) bitShift: 8) +
	  ((hi bitAnd: 16rFF) bitShift: 8) +
       (hi bitShift: -8)
!

bitAnd: aThirtTwoBitRegister
	"Replace my contents with the bitwise AND of the given register and my current contents.
	'jm 12/7/1999 15:41'"

	hi := hi bitAnd: aThirtTwoBitRegister hi.
	low := low bitAnd: aThirtTwoBitRegister low.
!

bitInvert
	"Replace my contents with the bitwise inverse my current contents.
	'jm 12/7/1999 15:40'"

	hi := hi bitXor: 16rFFFF.
	low := low bitXor: 16rFFFF.
!

bitOr: aThirtTwoBitRegister
	"Replace my contents with the bitwise OR of the given register and my current contents.
	'jm 12/7/1999 15:40'"

	hi := hi bitOr: aThirtTwoBitRegister hi.
	low := low bitOr: aThirtTwoBitRegister low.
!

bitXor: aThirtTwoBitRegister
	"Replace my contents with the bitwise exclusive OR of the given register and my current contents.
	'jm 12/7/1999 15:38'"

	hi := hi bitXor: aThirtTwoBitRegister hi.
	low := low bitXor: aThirtTwoBitRegister low.
!

copy
	"Use the clone primitive for speed.
	'jm 12/7/1999 15:26'"

	"swChanged"
	"<primitive: 148>"
	^ super copy
!

hi
	"'jm 12/7/1999 15:26'"

	^ hi
!

leftRotateBy: bits
	"Rotate my contents left by the given number of bits, retaining exactly 32 bits."
	"Details: Perform this operation with as little LargeInteger arithmetic as possible.
	'jm 12/7/1999 23:09'"

	| bitCount s1 s2 newHi |
	"ensure bitCount is in range [0..32]"
	bitCount := bits \\ 32.
	bitCount < 0 ifTrue: [bitCount := bitCount + 32].

	bitCount > 16
		ifTrue: [
			s1 := bitCount - 16.
			s2 := s1 - 16.
			newHi := ((low bitShift: s1) bitAnd: 16rFFFF) bitOr: (hi bitShift: s2).
			low := ((hi bitShift: s1) bitAnd: 16rFFFF) bitOr: (low bitShift: s2).
			hi := newHi]
		ifFalse: [
			s1 := bitCount.
			s2 := s1 - 16.
			newHi := ((hi bitShift: s1) bitAnd: 16rFFFF) bitOr: (low bitShift: s2).
			low := ((low bitShift: s1) bitAnd: 16rFFFF) bitOr: (hi bitShift: s2).
			hi := newHi]
!

load: anInteger
	"Set my contents to the value of given integer.
	'jm 12/14/1999 16:07'"

	low := anInteger bitAnd: 16rFFFF.
	hi := (anInteger bitShift: -16) bitAnd: 16rFFFF.
	self asInteger = anInteger
		ifFalse: [self error: 'out of range: ', anInteger printString].
!

loadFrom: aByteArray at: index
	"Load my 32-bit value from the four bytes of the given ByteArray starting at the given index. Consider the first byte to contain the most significant bits of the word (i.e., use big-endian byte ordering).
	'jm 12/14/1999 16:07'"

	hi := ((aByteArray at: index) bitShift: 8) + ( aByteArray at: index + 1).
	low := ((aByteArray at: index + 2) bitShift: 8) + ( aByteArray at: index + 3).
!

low
	"'jm 12/7/1999 15:26'"

	^ low!

printOn: aStream
	"Print my contents in hex with a leading 'R' to show that it is a register object being printed.
	'jm 12/14/1999 16:05'"

	aStream nextPutAll: 'R:'.
	self asInteger printOn: aStream base: 16.
!

reverseLoadFrom: aByteArray at: index
	"Load my 32-bit value from the four bytes of the given ByteArray
starting at the given index. Consider the first byte to contain the most
significant bits of the word (i.e., use big-endian byte ordering).
'mdr 2/23/2001 22:51'"

	hi := ((aByteArray at: index + 3) bitShift: 8) + ( aByteArray at: index + 2).
	low := ((aByteArray at: index + 1) bitShift: 8) + ( aByteArray at: index).
! !
!ThirtyTwoBitRegister categoriesFor: #+=!accumulator ops!public! !
!ThirtyTwoBitRegister categoriesFor: #asInteger!accessing!public! !
!ThirtyTwoBitRegister categoriesFor: #asReverseInteger!accessing!public! !
!ThirtyTwoBitRegister categoriesFor: #bitAnd:!accumulator ops!public! !
!ThirtyTwoBitRegister categoriesFor: #bitInvert!accumulator ops!public! !
!ThirtyTwoBitRegister categoriesFor: #bitOr:!accumulator ops!public! !
!ThirtyTwoBitRegister categoriesFor: #bitXor:!accumulator ops!public! !
!ThirtyTwoBitRegister categoriesFor: #copy!copying!public! !
!ThirtyTwoBitRegister categoriesFor: #hi!accessing!public! !
!ThirtyTwoBitRegister categoriesFor: #leftRotateBy:!accumulator ops!public! !
!ThirtyTwoBitRegister categoriesFor: #load:!accessing!public! !
!ThirtyTwoBitRegister categoriesFor: #loadFrom:at:!accessing!public! !
!ThirtyTwoBitRegister categoriesFor: #low!accessing!public! !
!ThirtyTwoBitRegister categoriesFor: #printOn:!printing!public! !
!ThirtyTwoBitRegister categoriesFor: #reverseLoadFrom:at:!accessing!public! !

!ThirtyTwoBitRegister class methodsFor!

new
	"Answer a new instance whose initial contents is zero.
	'jm 12/14/1999 16:05'"

	^ super new load: 0
! !
!ThirtyTwoBitRegister class categoriesFor: #new!instance creation!public! !

Timestamp guid: (GUID fromString: '{54A26D5E-E929-4CB8-AD59-DB6353DA28DA}')!
Timestamp comment: ''!
!Timestamp categoriesForClass!Unclassified! !
!Timestamp methodsFor!

date
	^date!

day
	^self date day!

hour
	^self time hours!

initializeWithDate: aDate time: aTime
	date := aDate.
	time := aTime.!

minute
	^self time minutes!

month
	^self date monthIndex!

rfc1123String
	"Tue, 11 Oct 2005 12:02:22 GMT"
	| stream |
	stream := String writeStream.
	self date printOn: stream format: 'ddd, dd MMM yyyy'.
	stream nextPutAll: ' '.
	self time printOn: stream format: 'HH:mm:ss'.
	stream nextPutAll: ' GMT'.
	^stream contents!

time
	^time!

year
	^self date year! !
!Timestamp categoriesFor: #date!public! !
!Timestamp categoriesFor: #day!public! !
!Timestamp categoriesFor: #hour!public! !
!Timestamp categoriesFor: #initializeWithDate:time:!private! !
!Timestamp categoriesFor: #minute!public! !
!Timestamp categoriesFor: #month!public! !
!Timestamp categoriesFor: #rfc1123String!public! !
!Timestamp categoriesFor: #time!public! !
!Timestamp categoriesFor: #year!public! !

!Timestamp class methodsFor!

now
	| ts |
	ts := TimeStamp currentUTC.
	^self new initializeWithDate: ts date time: ts time! !
!Timestamp class categoriesFor: #now!public! !

VWFilename guid: (GUID fromString: '{63115CD9-B4BD-467D-9DF0-1FEA7F2667C1}')!
VWFilename comment: 'From Steve Warings Filename package. www.dolphinharbor.org'!
!VWFilename categoriesForClass!Unclassified! !
!VWFilename methodsFor!

= aFilename 
	"Answer whether the receiver is equal to the argument"

	^self species = aFilename species
		ifTrue: [self asString = aFilename asString]!

asFilename
	^self!

assertIsExistingDirectory
	self isDirectory ifFalse: [KernelLibrary default systemError].
	self exists ifFalse: [KernelLibrary default systemError]!

assertNotExist: aVWFilename
	aVWFilename exists ifTrue: [ self class errorAlreadyExists ]!

asString
	^name!

backslashRemovedString
	"Private - SW: modify strings of the form \abc\ to \abc
	However, does *not* modify strings of the form c:\
	This allows some methods that use Win Shell functions to act like VW."

	| fn |
	fn := self localFileSpec.
	^self isLastPathDelimiter ifTrue: [fn copyFrom: 1 to: (fn size - 1 max: 3)] ifFalse: [fn]!

construct: aString
	"Answer a new instance, treating the receiver as a directory, and
	the string argument as the name of a file"

	^self class named: (self constructString: aString)!

constructString: aString
	"Answer a new instance, treating the receiver as a directory, and
	the string argument as the name of a file"

	| newName |
	newName := File composePath: self localFileSpec subPath: aString.
	(newName isNil or: [newName isEmpty]) ifTrue: [self class errorInvalidName ].
	^newName!

copyTo: destString
	"Copy the receiver's file to a file named destName."

	| newFilename |
	#jdb.
	"Problem here.  The File>>copy doesn't care if the file already exists.  I'm going to be cautious for now and check.  Will provide another method to copy over an existing file.  May change later!!"
	self assertNotExist: (newFilename := self class named: destString).
	^self copyWithOverwriteTo: destString!

copyWithOverwriteTo: destString
	"Copy the receiver's file to a file named destName."

	#jdb.
	^File copy: self localFileSpec to: (self class named: destString) localFileSpec!

currentDirectoryString
	#jdb. "Not very pretty, is it?"
	^'.'


!

delete
	self exists ifFalse: [ self class errorFileNotFound ].
	self isDirectory
		ifTrue: [File removeDirectory: self localFileSpec]
		ifFalse: [File delete: self localFileSpec]

!

directory
	"Answer the filename of the directory for this Filename."	

	^self class named: self head!

directoryContentArrays
	"Receiver is a directory name.  Answer an array of 4 element arrays
	containing information from the WIN32_FIND_DATA structure"

	| allFiles |
	#jdb.
	self assertIsExistingDirectory.
	allFiles := OrderedCollection new.
	File for: self localFileSpec , '\*.*'
		do: 
			[:each | 
			(self isDirectoryString: each) 
				ifFalse: 
					[allFiles add: (Array 
								with: each fileName
								with: each ftLastWriteTime asSYSTEMTIME asTimeStamp
								with: each fileSize
								with: each dwFileAttributes)]].
	^allFiles asArray!

directoryContents
	"Receiver is a directory name.  Answer an array of strings
	naming files contained in this directory."
	"We answer in absolute path names"
	
	^self directoryContentArrays collect: [ :each |
		each first]
!

etag
	"Answer a quoted string that can be compared to determine if the file has changed"

	| stream |
	stream := String writeStream.
	stream nextPut: $".
	self lastWriteByteArray printHexOn: stream.
	stream nextPut: $".
	^stream contents!

exists
	"Answer if the named file exists."

	^File exists: self localFileSpec!

extension
	"From VW: Answer the receiver's extension if any.  This is the characters from the
	 last occurrence of a period to the end, inclusive. E.g. the extension of
	 'visual.sou' is '.sou'. Answer nil if none.  Note that e.g. .login has no
	 extension."

	| ext |
	ext := File splitExtensionFrom: self localFileSpec.
	^ext isEmpty
		ifTrue: []
		ifFalse: ['.' , ext]!

fileSize
	^self winAttributes fileSize!

hash 
	^self asString asUppercase hash!

head
	"Answer the directory prefix as a String."

	^File splitPathFrom: self backslashRemovedString!

isAbsolute
	^locator == FileLocator absolute!

isDirectory 
	"Answer true if the receiver corresponds to a directory, false if an ordinary file.
	An error signal will be raised for special files (e.g., /dev/rmt on most Unix systems)."
	"SW VW signals exception for 'c:\doesntexist' asFilename isDirectory"

	self exists ifFalse: [ self class errorFileNotFound ].
	^ShlwapiLibrary default pathIsDirectory: self localFileSpec!

isDirectoryString: aString
	^#('.' '..') includes: aString fileName!

isFile
	^self shouldNotImplement. "Not in VW"

	!

isLastPathDelimiter
	^self localFileSpec notEmpty and: [self localFileSpec last = File pathDelimiter]!

isRelative
	^self isAbsolute not!

lastModified
	^(TimeStamp fromSYSTEMTIME: self winAttributes ftLastWriteTime basicAsSYSTEMTIME) rfc1123String
!

lastWriteByteArray
	^self winAttributes ftLastWriteTime asByteArray

	!

localFileSpec
	^locator localFileSpecFor: name!

locator
	^locator!

makeDirectory
	"Create the named directory."

	self exists ifTrue: [self error: self localFileSpec , ' Already exists'].
	File createDirectory: self localFileSpec!

moveTo: destString
	"Move the file whose name is the receiver to a file named destName."

	#jdb.
	^self renameTo: destString!

named: aString 
	Notification deprecated.
	name := aString!

named: aString locator: aFileLocator
	name := aString.
	locator := aFileLocator!

parentDirectoryString
	^'..'

!

readStream
	^FileStream read: self localFileSpec text: true
!

readWriteStream
	^self readStream
!

relativeFileSpec
	^locator relativePathTo: self localFileSpec!

renameTo: destString
	"Substitute the new name for the old one (a.k.a. 'rename the file')."

	#jdb.
	self assertNotExist: (self class named: destString).
	^File rename: self localFileSpec to: destString!

safeConstruct: aString
	"Ignore attempts to construct a path that can access a parent directory"

	^aString trimBlanks = self parentDirectoryString 
		ifTrue: [self class named: name]
		ifFalse: [self construct: aString]!

stbLoad
	| stream instance |
	stream := FileStream read: self localFileSpec text: false.
	[instance := (STBInFiler on: stream) next] ensure: [stream close].
	^instance
!

stbSave: anObject
	| stream |
	stream := FileStream write: self localFileSpec text: false.
	[(STBOutFiler on: stream) nextPut: anObject] ensure: [stream close].
	
!

tail
	"Answer the filename suffix as a String."
	"SW: modified Win API to pass;
	self assert: (Filename named: 'c:\abc\') tail = 'abc'.	 VW passes this test but should it?"

	^File splitFilenameFrom: self backslashRemovedString!

winAttributes
	| coll |
	coll := OrderedCollection new.
	File for: self localFileSpec do: [ :each | coll add: each ].
	coll isEmpty ifTrue: [ self class errorFileNotFound ].
	coll size > 1 ifTrue: [ self class errorInvalidName ].
	^coll first

!

writeStream
	^FileStream write: self localFileSpec text: true


! !
!VWFilename categoriesFor: #=!public! !
!VWFilename categoriesFor: #asFilename!converting!public! !
!VWFilename categoriesFor: #assertIsExistingDirectory!asserting!private! !
!VWFilename categoriesFor: #assertNotExist:!asserting!private! !
!VWFilename categoriesFor: #asString!public! !
!VWFilename categoriesFor: #backslashRemovedString!accessing!private! !
!VWFilename categoriesFor: #construct:!operations!public! !
!VWFilename categoriesFor: #constructString:!operations!private! !
!VWFilename categoriesFor: #copyTo:!operations!public! !
!VWFilename categoriesFor: #copyWithOverwriteTo:!operations!public! !
!VWFilename categoriesFor: #currentDirectoryString!constants!private! !
!VWFilename categoriesFor: #delete!operations!public! !
!VWFilename categoriesFor: #directory!accessing!public! !
!VWFilename categoriesFor: #directoryContentArrays!accessing!public! !
!VWFilename categoriesFor: #directoryContents!accessing!public! !
!VWFilename categoriesFor: #etag!accessing!public! !
!VWFilename categoriesFor: #exists!public!testing! !
!VWFilename categoriesFor: #extension!accessing!public! !
!VWFilename categoriesFor: #fileSize!accessing!public! !
!VWFilename categoriesFor: #hash!public! !
!VWFilename categoriesFor: #head!accessing!public! !
!VWFilename categoriesFor: #isAbsolute!public!testing! !
!VWFilename categoriesFor: #isDirectory!public!testing! !
!VWFilename categoriesFor: #isDirectoryString:!accessing!public! !
!VWFilename categoriesFor: #isFile!public!testing! !
!VWFilename categoriesFor: #isLastPathDelimiter!accessing!public!testing! !
!VWFilename categoriesFor: #isRelative!public!testing! !
!VWFilename categoriesFor: #lastModified!accessing!public! !
!VWFilename categoriesFor: #lastWriteByteArray!accessing!private! !
!VWFilename categoriesFor: #localFileSpec!accessing!private! !
!VWFilename categoriesFor: #locator!accessing!private! !
!VWFilename categoriesFor: #makeDirectory!operations!public! !
!VWFilename categoriesFor: #moveTo:!operations!public! !
!VWFilename categoriesFor: #named:!accessing!public! !
!VWFilename categoriesFor: #named:locator:!accessing!private! !
!VWFilename categoriesFor: #parentDirectoryString!constants!private! !
!VWFilename categoriesFor: #readStream!public!streaming! !
!VWFilename categoriesFor: #readWriteStream!public!streaming! !
!VWFilename categoriesFor: #relativeFileSpec!accessing!public! !
!VWFilename categoriesFor: #renameTo:!operations!public! !
!VWFilename categoriesFor: #safeConstruct:!operations!public! !
!VWFilename categoriesFor: #stbLoad!public!streaming! !
!VWFilename categoriesFor: #stbSave:!public!streaming! !
!VWFilename categoriesFor: #tail!accessing!public! !
!VWFilename categoriesFor: #winAttributes!accessing!private! !
!VWFilename categoriesFor: #writeStream!public!streaming! !

!VWFilename class methodsFor!

anyBadCharacters: aString
	^aString anySatisfy: [ :each | self isBadCharacter: each]!

errorAlreadyExists
	^self errorWin32: 183!

errorFileNotFound
	^self errorWin32: 2!

errorInvalidName
	^self errorWin32: 123!

errorWin32: anErrorCode
	^Win32Error signalWith: anErrorCode!

examples
	| filename |
	filename := 'test.txt' asFilename.
	"Image relative (all names that are detected to be relative are assumed to be imageRelative)"
	filename localFileSpec.
	filename := 'c:\test.txt' asFilename.
	"Absolute"
	filename localFileSpec!

filterFilename: aString
	^aString collect: [ :each |
		(self isBadCharacter: each)
			ifTrue: [$_]
			ifFalse: [each]]!

isBadCharacter: char
	"Private - GCT_INVALID The character is not valid in a path. 0x0000"

	^(ShlwapiLibrary default pathGetCharType: char) = 0 !

locatorFor: aString
	^(File isRelativePath: aString) 
		ifTrue: [FileLocator imageRelative]
		ifFalse: [FileLocator absolute]!

named: aString
	| filtered |
	filtered := (self anyBadCharacters: aString) 
				ifTrue: [self filterFilename: aString]
				ifFalse: [aString].
	filtered isEmpty ifTrue: [ self errorInvalidName ].
	^self named: filtered locator: (self locatorFor: aString)!

named: aString locator: aFileLocator
	^self new named: aString locator: aFileLocator! !
!VWFilename class categoriesFor: #anyBadCharacters:!private!testing! !
!VWFilename class categoriesFor: #errorAlreadyExists!instance creation!public! !
!VWFilename class categoriesFor: #errorFileNotFound!public! !
!VWFilename class categoriesFor: #errorInvalidName!instance creation!public! !
!VWFilename class categoriesFor: #errorWin32:!instance creation!private! !
!VWFilename class categoriesFor: #examples!must strip!public!spray examples! !
!VWFilename class categoriesFor: #filterFilename:!helpers!private! !
!VWFilename class categoriesFor: #isBadCharacter:!private!testing! !
!VWFilename class categoriesFor: #locatorFor:!helpers!private! !
!VWFilename class categoriesFor: #named:!instance creation!public! !
!VWFilename class categoriesFor: #named:locator:!instance creation!private! !

DolphinSwazooPlatform guid: (GUID fromString: '{63746FCD-F781-402B-BD2B-690B09146984}')!
DolphinSwazooPlatform comment: ''!
!DolphinSwazooPlatform categoriesForClass!Unclassified! !
!DolphinSwazooPlatform methodsFor!

base64DecodeAsString: aString 
	| output |
	output := ByteArray writeStream: aString size.
	Base64Codec decodeFrom: aString readStream onto: output.
	^output contents asString!

collection: aCollection tokensBasedOnAll: anArray
	"Answer an OrderedCollection of the sub-sequences
	 of the receiver that are separated by aSequenceableCollection."

	| i selfPos oc |
	selfPos := 1.
	oc := OrderedCollection new.
	
	[i := aCollection indexOfSubCollection: anArray startingAt: selfPos.
	i = 0] 
			whileFalse: 
				[oc add: (aCollection copyFrom: selfPos to: i - 1).
				selfPos := i + anArray size].
	oc add: (aCollection copyFrom: selfPos to: self size).
	^oc!

compactingGC
	MemoryManager current compact!

md5Hash: aStringOrByteArray
	^((MD5 hashMessage: aStringOrByteArray asByteArray) printStringRadix: 16 showRadix: false) asLowercase!

newTCPServer
	^ServerSocket2 new!

newTCPSocket
	^Socket2 basicNew initialize; yourself!

quickGC
	MemoryManager current collectGarbage!

socket: aSocket connectToHostNamed: aStringHost port: anIntegerPort
	aSocket 
		port: anIntegerPort address: (InternetAddress host: aStringHost);
		connect.!

socket: aSocket listenFor: anIntegerBacklog
	aSocket listen: anIntegerBacklog!

socket: aSocket listenOn: anIntegerPort backlogSize: anIntegerBacklog
	aSocket 
		createOnPort: anIntegerPort;
		bind;
		listen: anIntegerBacklog.!

socket: aSocket read: anIntegerSize
	| buffer count |
	buffer := ByteArray new: anIntegerSize.
	count := aSocket receiveSome: buffer count: buffer size startingAt: 1.
	^buffer copy: ByteArray from: 1 to: count!

socket: aSocket read: anIntegerSize timeout: anIntegerTimeout
	"this is dodgy"
	| buffer deadline |
	deadline := TimeStamp current asMilliseconds + anIntegerTimeout.
	buffer := ByteArray new.
	[ TimeStamp current asMilliseconds > deadline ifTrue: [ ^buffer ].
		aSocket hasInput ] whileFalse.
	buffer := self socket: aSocket read: anIntegerSize.
	^buffer
!

socket: aSocket write: aByteArray
	aSocket send: aByteArray.
	^aByteArray size!

socketAccept: aSocket
	^aSocket accept!

socketClose: aSocket
	aSocket close.!

socketLocalAddress: aSocket
	^aSocket address ipString!

socketPeerAddress: aSocket
	^aSocket peerAddress ipString!

stream: aGettableStream upToAll: aCollection
	"Expected behaviour is to return up to the collection, and the 
	next character in the stream should be the first element in the collection"
	| contents |
	contents := aGettableStream upToAll: aCollection.
	aGettableStream atEnd ifFalse: [ aGettableStream skip: aCollection size negated ].
	^contents!

string: aString tokensBasedOn: anObject
	"Answer an OrderedCollection of the sub-sequences
	 of the receiver that are separated by anObject."

	"'brave new world' tokensBasedOn: Character space"

	| str tokens |
	(aString includes: anObject) ifFalse: [ ^OrderedCollection with: aString ].
	str := aString readStream.
	tokens := OrderedCollection new.
	[ str atEnd ] whileFalse: [ tokens addLast: (str upTo: anObject) ].
	(str skip: -1; next) = anObject ifTrue: [ tokens addLast: (aString copyEmpty: 0) ].
	^tokens!

stringWithInternetLineEndings: aString
	^aString withNormalizedLineDelimiters!

stringWithUnixLineEndings: aString
	"assume the string is textual, and that CR, LF, and CRLF are all 
	valid line endings.  Replace each occurence with a single CR"
	| target cr lf stm |
	target := String writeStream: aString size.
	stm := aString readStream.
	cr := Character cr.
	lf := Character lf.
	stm do: [:each | 
		each == lf 
			ifTrue: [target nextPutAll: cr ]
			ifFalse: [
				each == cr 
					ifTrue: [
						stm peekFor: lf.
						target nextPutAll: cr ]
					ifFalse: [ target nextPut: each ] ] ].
	^target contents
	!

timestampNow
	^TimeStamp current!

urlDecode: aString
	^UrlEncodingPolicy new decode: aString!

urlEncode: aString
	^UrlEncodingPolicy new encode: aString! !
!DolphinSwazooPlatform categoriesFor: #base64DecodeAsString:!public! !
!DolphinSwazooPlatform categoriesFor: #collection:tokensBasedOnAll:!public! !
!DolphinSwazooPlatform categoriesFor: #compactingGC!public! !
!DolphinSwazooPlatform categoriesFor: #md5Hash:!public! !
!DolphinSwazooPlatform categoriesFor: #newTCPServer!public! !
!DolphinSwazooPlatform categoriesFor: #newTCPSocket!public! !
!DolphinSwazooPlatform categoriesFor: #quickGC!public! !
!DolphinSwazooPlatform categoriesFor: #socket:connectToHostNamed:port:!public! !
!DolphinSwazooPlatform categoriesFor: #socket:listenFor:!public! !
!DolphinSwazooPlatform categoriesFor: #socket:listenOn:backlogSize:!public! !
!DolphinSwazooPlatform categoriesFor: #socket:read:!public! !
!DolphinSwazooPlatform categoriesFor: #socket:read:timeout:!public! !
!DolphinSwazooPlatform categoriesFor: #socket:write:!public! !
!DolphinSwazooPlatform categoriesFor: #socketAccept:!public! !
!DolphinSwazooPlatform categoriesFor: #socketClose:!public! !
!DolphinSwazooPlatform categoriesFor: #socketLocalAddress:!public! !
!DolphinSwazooPlatform categoriesFor: #socketPeerAddress:!public! !
!DolphinSwazooPlatform categoriesFor: #stream:upToAll:!public! !
!DolphinSwazooPlatform categoriesFor: #string:tokensBasedOn:!public! !
!DolphinSwazooPlatform categoriesFor: #stringWithInternetLineEndings:!public! !
!DolphinSwazooPlatform categoriesFor: #stringWithUnixLineEndings:!public! !
!DolphinSwazooPlatform categoriesFor: #timestampNow!public! !
!DolphinSwazooPlatform categoriesFor: #urlDecode:!public! !
!DolphinSwazooPlatform categoriesFor: #urlEncode:!public! !

!DolphinSwazooPlatform class methodsFor!

platformFor: aDialect
	^aDialect isDolphin! !
!DolphinSwazooPlatform class categoriesFor: #platformFor:!public! !

"Binary Globals"!

