| package |
package := Package name: 'Smalltalk-Dialect'.
package paxVersion: 1;
	basicComment: ''.

package basicPackageVersion: '0.007'.


package classNames
	add: #SmalltalkDialect;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: '..\..\Object Arts\Dolphin\Base\Dolphin';
	yourself).

package!

"Class Definitions"!

Object subclass: #SmalltalkDialect
	instanceVariableNames: 'dialect version'
	classVariableNames: 'Singleton'
	poolDictionaries: ''
	classInstanceVariableNames: ''!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

SmalltalkDialect guid: (GUID fromString: '{0AE00B66-FDE2-427D-8CBA-21FF38989ADF}')!
SmalltalkDialect comment: 'A Dialect object for cross dialect development '!
!SmalltalkDialect categoriesForClass!Unclassified! !
!SmalltalkDialect methodsFor!

ifDolphin: aBlock
	^self isDolphin ifTrue: [ aBlock value ]!

ifObjectStudio: aBlock
	^self isObjectStudio ifTrue: [ aBlock value ]!

ifSmalltalkX: aBlock
	^self isSmalltalkX ifTrue: [ aBlock value ]!

ifSqueak: aBlock
	^self isSqueak ifTrue: [ aBlock value ]!

ifVisualAge: aBlock
	^self isVisualAge ifTrue: [ aBlock value ]!

ifVisualSmalltalk: aBlock
	^self isVisualSmalltalk ifTrue: [ aBlock value ]!

ifVisualWorks: aBlock
	^self isVisualWorks ifTrue: [ aBlock value ]!

initializeWithDialect: aSymbol
	self initializeWithDialect: aSymbol version: 'Unknown'!

initializeWithDialect: aSymbol version: aVersion
	dialect := aSymbol.
	version := aVersion.!

isDolphin
	^dialect == #Dolphin!

isObjectStudio
	^dialect == #ObjectStudio!

isSmalltalkX
	^dialect == #SmalltalkX!

isSqueak
	^dialect == #Squeak!

isVisualAge
	^dialect == #VisualAge!

isVisualSmalltalk
	^dialect == #VisualSmalltalk!

isVisualWorks
	^dialect == #VisualWorks | dialect == #VisualWorksNS!

name
	^dialect asString!

supportsNameSpaces
	^dialect == #VisualWorksNS!

version
	^version! !
!SmalltalkDialect categoriesFor: #ifDolphin:!public!testing! !
!SmalltalkDialect categoriesFor: #ifObjectStudio:!public!testing! !
!SmalltalkDialect categoriesFor: #ifSmalltalkX:!public!testing! !
!SmalltalkDialect categoriesFor: #ifSqueak:!public!testing! !
!SmalltalkDialect categoriesFor: #ifVisualAge:!public!testing! !
!SmalltalkDialect categoriesFor: #ifVisualSmalltalk:!public!testing! !
!SmalltalkDialect categoriesFor: #ifVisualWorks:!public!testing! !
!SmalltalkDialect categoriesFor: #initializeWithDialect:!initialization!private! !
!SmalltalkDialect categoriesFor: #initializeWithDialect:version:!initialization!private! !
!SmalltalkDialect categoriesFor: #isDolphin!public!testing! !
!SmalltalkDialect categoriesFor: #isObjectStudio!public!testing! !
!SmalltalkDialect categoriesFor: #isSmalltalkX!public!testing! !
!SmalltalkDialect categoriesFor: #isSqueak!public!testing! !
!SmalltalkDialect categoriesFor: #isVisualAge!public!testing! !
!SmalltalkDialect categoriesFor: #isVisualSmalltalk!public!testing! !
!SmalltalkDialect categoriesFor: #isVisualWorks!public!testing! !
!SmalltalkDialect categoriesFor: #name!accessing!public! !
!SmalltalkDialect categoriesFor: #supportsNameSpaces!accessing!public! !
!SmalltalkDialect categoriesFor: #version!accessing!public! !

!SmalltalkDialect class methodsFor!

current
	^self singleton!

discoverDialect
	self testDolphin ifTrue: [ ^#Dolphin ].
	self testSqueak ifTrue: [ ^#Squeak ].
	self testVisualWorksWithNameSpaces ifTrue: [ ^#VisualWorksNS ].
	self testVisualWorks ifTrue: [ ^#VisualWorks ].
	self testObjectStudio ifTrue: [ ^#ObjectStudio ].
	self testVisualAge ifTrue: [ ^#VisualAge ].
	self testSmalltalkX ifTrue: [ ^#SmalltalkX ].
	self testVisualSmalltalk ifTrue: [ ^#VisualSmalltalk ].
	^#Unknown

	!

initializeSingleton
	^self basicNew initializeWithDialect: self discoverDialect!

new
	^self singleton!

singleton
	^Singleton ifNil: [ Singleton := self initializeSingleton ]!

testDolphin
	Smalltalk isNil ifTrue: [^false].
	(Smalltalk respondsTo: #at:ifAbsent:) ifFalse: [ ^false ].
	Smalltalk at: #STBFiler ifAbsent: [^false].
	^true
!

testObjectStudio
	| sys |
	(Object respondsTo: #environment) ifFalse: [^false].
	(Object environment respondsTo: #at:ifAbsent:) ifFalse: [^false].
	sys := Object environment at: #System ifAbsent: [^false].
	(sys name isKindOf: String) ifFalse: [^false].
	^sys name = 'ObjectStudio'!

testSmalltalkX
	^(Smalltalk respondsTo: #isSmalltalkX)
		and: [Smalltalk isSmalltalkX]!

testSqueak
	"This test works for Squeak"

	^(Smalltalk respondsTo: #systemInformationString) 
		and: ['Squeak*' match: Smalltalk systemInformationString]!

testVisualAge
	| sys |
	Smalltalk isNil ifTrue: [^false].
	sys := Smalltalk at: #System ifAbsent: [^false].
	^sys vmType = 'ES'
!

testVisualSmalltalk
	^(Smalltalk respondsTo: #product)
		and: [Smalltalk product = 'Visual Smalltalk']!

testVisualWorks
	(Smalltalk respondsTo: #versionName) ifFalse: [^false].
	((Smalltalk versionName isKindOf: String)
		and: ['VisualWorks*' match: Smalltalk versionName]) ifFalse: [^false].
	^(Class respondsTo: #fullyQualifiedReference) not!

testVisualWorksWithNameSpaces
	(Smalltalk respondsTo: #versionName) ifFalse: [^false].
	(Class respondsTo: #fullyQualifiedReference) ifFalse: [^false].
	((Smalltalk versionName isKindOf: String) 
		and: ['VisualWorks*' match: Smalltalk versionName]) ifTrue: [^true].
	"Noticed in VW 7.3"
	^(Smalltalk versionName respondsTo: #defaultString)
		and: ['VisualWorks*' match: Smalltalk versionName defaultString]
! !
!SmalltalkDialect class categoriesFor: #current!instance creation!public! !
!SmalltalkDialect class categoriesFor: #discoverDialect!private!testing! !
!SmalltalkDialect class categoriesFor: #initializeSingleton!instance creation!private! !
!SmalltalkDialect class categoriesFor: #new!instance creation!public! !
!SmalltalkDialect class categoriesFor: #singleton!instance creation!public! !
!SmalltalkDialect class categoriesFor: #testDolphin!private!testing! !
!SmalltalkDialect class categoriesFor: #testObjectStudio!private!testing! !
!SmalltalkDialect class categoriesFor: #testSmalltalkX!private!testing! !
!SmalltalkDialect class categoriesFor: #testSqueak!private!testing! !
!SmalltalkDialect class categoriesFor: #testVisualAge!private!testing! !
!SmalltalkDialect class categoriesFor: #testVisualSmalltalk!private!testing! !
!SmalltalkDialect class categoriesFor: #testVisualWorks!private!testing! !
!SmalltalkDialect class categoriesFor: #testVisualWorksWithNameSpaces!private!testing! !

"Binary Globals"!

