| package |
package := Package name: 'Swazoo-AIDA'.
package paxVersion: 1;
	basicComment: ''.


package methodNames
	add: #HTTPConnection -> #representBinaryOn:;
	add: #HTTPPostDatum -> #filenameWithoutPath;
	add: #HTTPRequest -> #ajaxElementId;
	add: #HTTPRequest -> #idFromCookie;
	add: #HTTPRequest -> #isAjaxAutocompleteRequest;
	add: #HTTPRequest -> #isAjaxInPlaceEditingRequest;
	add: #HTTPRequest -> #isAjaxPostRequest;
	add: #HTTPRequest -> #isAjaxRequest;
	add: #HTTPRequest -> #isAjaxWikiFormatedRequest;
	add: #HTTPRequest -> #isWapRequest;
	add: #HTTPRequest -> #isWebRequest;
	add: #HTTPServer -> #representBinaryOn:;
	add: #SwazooServer -> #allAidaInstancesReport;
	add: #SwazooServer -> #backupToFile;
	add: #SwazooServer -> #demoStart;
	add: #SwazooServer -> #demoStop;
	add: #SwazooServer -> #isNewHour;
	add: #SwazooServer -> #isNightlyBackupTime;
	add: #SwazooServer -> #isWatchdogRunning;
	add: #SwazooServer -> #representBinaryOn:;
	add: #SwazooServer -> #restoreFromFile;
	add: #SwazooServer -> #startWatchdog;
	add: #SwazooServer -> #stopWatchdog;
	add: #SwazooServer -> #watchdog;
	add: #SwazooServer -> #watchdog:;
	add: #SwazooServer -> #watchdogOther;
	add: #SwazooServer -> #watchdogPeriod;
	add: #SwazooServer -> #watchdogSites;
	add: #URIResolution -> #resolveSite:;
	add: 'SwazooServer class' -> #demoStart;
	add: 'SwazooServer class' -> #demoStop;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'AIDAWeb';
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\Swazoo\Swazoo';
	add: '..\Swazoo-Platform-Dolphin';
	yourself).

package!

"Class Definitions"!


"Global Aliases"!


"Loose Methods"!

!HTTPConnection methodsFor!

representBinaryOn: aBossWriter
	^0 "don't boss-out it !! "! !
!HTTPConnection categoriesFor: #representBinaryOn:!private! !

!HTTPPostDatum methodsFor!

filenameWithoutPath
	"M$ Internet Explorer includes full path in filename of uploaded file!! "
	^(self filename includes: $\ ) 
		ifTrue: [self filename copyFrom: (self filename lastIndexOf: $\ )+1 to: self filename size]
		ifFalse: [self filename]! !
!HTTPPostDatum categoriesFor: #filenameWithoutPath!accessing!private! !

!HTTPRequest methodsFor!

ajaxElementId
	"Asynchronous JavaScript (AJAX) request, it has additional parameter ajaxGetElementId"
	| id |
	id := self queryAt: 'ajaxGetElementId' ifAbsent: [nil].
	id notNil ifTrue: [^id asSymbol].
	^self isPost 
		ifTrue: [(self postDataAt: 'ajaxGetElementId' ifAbsent: [^nil]) value asSymbol]
		ifFalse: [nil]!

idFromCookie
	"return session id from our cookie. nil if not aida field present in cookie"
	| stream part |
	stream := self cookie readStream.
	[stream atEnd] whileFalse:
		[part := stream upTo: $; .
		('aida9357*' match: part) ifTrue:
			[^part readStream upTo: $=; upToEnd] ].
	^nil!

isAjaxAutocompleteRequest
	"AJAX autocomplete input field request, see WebAutocompleteField"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'ajaxAutocompleteField'!

isAjaxInPlaceEditingRequest
	"AJAX in place editor request, see WebInPlaceEditingText"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'ajaxInPlaceEditing'!

isAjaxPostRequest
	"Asynchronous JavaScript (AJAX) request, with posting an input field in a query"
	self isAjaxRequest ifFalse: [^false].
	self isPost ifTrue: [^true].
	^self queryData keys contains: [:each | 'field*' match: each].!

isAjaxRequest
	"Asynchronous JavaScript (AJAX) request, it has additional parameter ajaxRequest"
	^(self headerAt: 'X-Requested-With' ifAbsent: [^false]) value = 'XMLHttpRequest'!

isAjaxWikiFormatedRequest
	"AJAX in place editor request, see WebInPlaceEditingText"
	self isAjaxRequest ifFalse: [^false].
	^self includesQuery: 'wikiFormated'!

isWapRequest
	"true, if this is a request for a WAP page, eg. .wml on the end of url"
	^'*.wml*' match: self urlString!

isWebRequest
	^self isWapRequest not! !
!HTTPRequest categoriesFor: #ajaxElementId!accessing-queries!private! !
!HTTPRequest categoriesFor: #idFromCookie!accessing!private! !
!HTTPRequest categoriesFor: #isAjaxAutocompleteRequest!private!testing! !
!HTTPRequest categoriesFor: #isAjaxInPlaceEditingRequest!private!testing! !
!HTTPRequest categoriesFor: #isAjaxPostRequest!private!testing! !
!HTTPRequest categoriesFor: #isAjaxRequest!private!testing! !
!HTTPRequest categoriesFor: #isAjaxWikiFormatedRequest!private!testing! !
!HTTPRequest categoriesFor: #isWapRequest!private!testing! !
!HTTPRequest categoriesFor: #isWebRequest!private!testing! !

!HTTPServer methodsFor!

representBinaryOn: aBossWriter
	"don't boss-out http server "
	^0! !
!HTTPServer categoriesFor: #representBinaryOn:!private! !

!SwazooServer methodsFor!

allAidaInstancesReport
	"report numbers of instances of all Aida namespace classes"
	"SwazooServer singleton allAidaInstancesReport"
	| namespace |
	namespace := WebSession environment.
	^SortedCollection
		withAll: (namespace allClasses collect: [:each | each -> each allInstances size])
		sortBlock: [:a :b | a value > b value]!

backupToFile
	"boss out all Sites to file swazooserver.boss"
	"SwazooServer singleton backupToFile"
	| filename boss |
	filename := ('swazooserver.boss') asFilename.
	filename exists ifTrue: [filename copyTo: 'swazooserver-old.boss'].
	boss := BinaryObjectStorage onNew: filename writeStream.
	[boss nextPut: self sites copy] ensure: [boss close].!

demoStart
	(self siteNamed: 'test') isNil ifTrue:
		[AIDASite newNamed: 'test'].
	self startSite: 'test'!

demoStop
	self stopSite: 'test'!

isNewHour
	" a new hour since last watchdog check"
	"SwazooServer singleton isNewHour"
	^Timestamp now hour ~= 
		(Timestamp fromSeconds: Timestamp now asSeconds - self watchdogPeriod) hour!

isNightlyBackupTime
	"backup should be done at 4:30:00"
	"SwazooServer singleton isNightlyBackupTime"
	| backupTime |
	backupTime := Timestamp fromDate: Date today andTime: (Time readFrom: '4:30:00' readStream).
	^(Timestamp now asSeconds > backupTime asSeconds) & 
		(Timestamp now asSeconds < (backupTime asSeconds + self watchdogPeriod))!

isWatchdogRunning
	^self watchdog notNil "and: [self watchdog is not].  ?!!?"!

representBinaryOn: aBossWriter
	^0 "don't boss-out SwazoServer singleton!! "!

restoreFromFile
	"boss in a coolection of Sites from file swazooserver.boss"
	"SwazooServer singleton restoreFromFile"
	| filename boss allSites |
	filename := ('swazooserver.boss') asFilename.
	boss := BinaryObjectStorage onOld: filename readStream.
	[allSites := boss next] ensure: [boss close].
	^allSites!

startWatchdog
	self isWatchdogRunning ifTrue: [self stopWatchdog].
	self watchdog: ([ [true] whileTrue:
		[self watchdogSites.
		self watchdogOther. "if any"
		(Delay forSeconds: self watchdogPeriod) wait. ]
	] forkAt: Processor lowIOPriority)!

stopWatchdog
	self watchdog notNil ifTrue: 
		[self watchdog terminate.
		self watchdog: nil].!

watchdog
	^watchdog!

watchdog: aProcess
	watchdog := aProcess!

watchdogOther
	"override this if you like some other periodic activity"!

watchdogPeriod
	^10  "seconds"!

watchdogSites
	self sites do: [:each | each isServing ifTrue: 
		[(each isKindOf: AIDASite) ifTrue: [each setLastTimeAliveTimestamp]] ]! !
!SwazooServer categoriesFor: #allAidaInstancesReport!private! !
!SwazooServer categoriesFor: #backupToFile!private!private-backup/restore! !
!SwazooServer categoriesFor: #demoStart!private!start/stop! !
!SwazooServer categoriesFor: #demoStop!private!start/stop! !
!SwazooServer categoriesFor: #isNewHour!private! !
!SwazooServer categoriesFor: #isNightlyBackupTime!private! !
!SwazooServer categoriesFor: #isWatchdogRunning!private! !
!SwazooServer categoriesFor: #representBinaryOn:!private! !
!SwazooServer categoriesFor: #restoreFromFile!private!private-backup/restore! !
!SwazooServer categoriesFor: #startWatchdog!private! !
!SwazooServer categoriesFor: #stopWatchdog!private! !
!SwazooServer categoriesFor: #watchdog!private! !
!SwazooServer categoriesFor: #watchdog:!private! !
!SwazooServer categoriesFor: #watchdogOther!private! !
!SwazooServer categoriesFor: #watchdogPeriod!private! !
!SwazooServer categoriesFor: #watchdogSites!private! !

!SwazooServer class methodsFor!

demoStart
	self singleton demoStart!

demoStop
	self singleton demoStop! !
!SwazooServer class categoriesFor: #demoStart!public!start/stop! !
!SwazooServer class categoriesFor: #demoStop!public!start/stop! !

!URIResolution methodsFor!

resolveSite: aSite 
	(aSite canAnswer and: [self siteMatch: aSite]) ifFalse: [^nil].
	^aSite answerTo: self request! !
!URIResolution categoriesFor: #resolveSite:!private!visiting! !

"End of package definition"!

"Source Globals"!

"Classes"!

"Binary Globals"!

