| package |
package := Package name: 'AIDAWeb'.
package paxVersion: 1;
	basicComment: ''.


package classNames
	add: #AIDASite;
	add: #AspectAdaptor;
	add: #BmpImageStream;
	add: #BosImageStream;
	add: #DelimitedFile;
	add: #DirectoryProxy;
	add: #DocLink;
	add: #FileProxy;
	add: #FixedPoint;
	add: #GifImageStream;
	add: #ImageStream;
	add: #IndexedAdaptor;
	add: #MIMEMap;
	add: #ProtocolAdaptor;
	add: #ScheduledEvent;
	add: #Scheduler;
	add: #URLResolver;
	add: #ViewTabs;
	add: #WebAdmin;
	add: #WebAdminApp;
	add: #WebAnchor;
	add: #WebApplication;
	add: #WebAutocompleteField;
	add: #WebButton;
	add: #WebCheckBox;
	add: #WebClipboard;
	add: #WebComment;
	add: #WebCounter;
	add: #WebDateInputField;
	add: #WebDemo;
	add: #WebDemoApp;
	add: #WebDiscussions;
	add: #WebDiscussionsApp;
	add: #WebDiscussionsResponse;
	add: #WebDiscussionsResponseApp;
	add: #WebElement;
	add: #WebFieldSet;
	add: #WebFileInputField;
	add: #WebForm;
	add: #WebFormElement;
	add: #WebFrameApp;
	add: #WebGrid;
	add: #WebGridColumn;
	add: #WebHelp;
	add: #WebHelpApp;
	add: #WebHelpPage;
	add: #WebHelpPageApp;
	add: #WebIFrame;
	add: #WebImage;
	add: #WebImageMap;
	add: #WebIndex;
	add: #WebIndexApp;
	add: #WebInPlaceEditableText;
	add: #WebInputField;
	add: #WebLink;
	add: #WebList;
	add: #WebListItem;
	add: #WebLiveImage;
	add: #WebLivePDFCreator;
	add: #WebMenu;
	add: #WebMethodImage;
	add: #WebMethodResource;
	add: #WebMsgs;
	add: #WebMsgsApp;
	add: #WebNews;
	add: #WebNewsApp;
	add: #WebNewsArticle;
	add: #WebNewsArticleApp;
	add: #WebPage;
	add: #WebRadioButton;
	add: #WebRawText;
	add: #WebRichEditor;
	add: #WebScript;
	add: #WebSecurityManager;
	add: #WebSecurityManagerApp;
	add: #WebSeparator;
	add: #WebSession;
	add: #WebSessionManager;
	add: #WebStatistics;
	add: #WebStatisticsApp;
	add: #WebStyle;
	add: #WebTable;
	add: #WebTableCell;
	add: #WebTableHeader;
	add: #WebTableRow;
	add: #WebTabs;
	add: #WebText;
	add: #WebTextArea;
	add: #WebTransactionMonitor;
	add: #WebUser;
	add: #WebUserGroup;
	yourself.

package binaryGlobalNames: (Set new
	yourself).

package globalAliases: (Set new
	yourself).

package setPrerequisites: (IdentitySet new
	add: 'AIDA support';
	add: '..\Object Arts\Dolphin\Base\Dolphin';
	add: '..\Object Arts\Dolphin\MVP\Base\Dolphin MVP Base';
	add: '..\Object Arts\Dolphin\MVP\Models\Value\Dolphin Value Models';
	add: '..\Swazoo\Swazoo';
	add: '..\Swazoo-Platform-Dolphin';
	yourself).

package!

"Class Definitions"!

Object subclass: #DelimitedFile
	instanceVariableNames: 'filename delimiter codepage records'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DirectoryProxy
	instanceVariableNames: 'server filename fileDates origContent origCodepage contentType elements bodyTagIndex imgTagIndexes linkTagIndexes servletTagIndexes'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #DocLink
	instanceVariableNames: 'title url object'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #FileProxy
	instanceVariableNames: 'site filename timestamps content contentType codepage elements bodyTagIndex imgTagIndexes linkTagIndexes servletTagIndexes'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #ImageStream
	instanceVariableNames: 'imageStream progressValue'
	classVariableNames: 'ColorPalette256 GrayPalette256 ImageKindTable'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #MIMEMap
	instanceVariableNames: 'mimeTypes fileExtensions'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #ProtocolAdaptor
	instanceVariableNames: 'subject'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #ScheduledEvent
	instanceVariableNames: 'parent timestamp period method object block'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #Scheduler
	instanceVariableNames: 'site queue loop lock'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #URLResolver
	instanceVariableNames: 'site allWebPages allURLLinks counters totalCounter randomGen'
	classVariableNames: 'Instance TimeStamp'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebAdmin
	instanceVariableNames: 'host ip port'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebClipboard
	instanceVariableNames: 'title url object'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebCounter
	instanceVariableNames: 'started day year dailyCounts hourlyCounts todayHourlyCounts total yearlyHistory'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebDemo
	instanceVariableNames: 'file filename fileContentType content date input field editField'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebDiscussions
	instanceVariableNames: 'introduction discussions newest'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebDiscussionsResponse
	instanceVariableNames: 'timestamp title author authorsEmail user body responses parent'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebElement
	instanceVariableNames: 'parent elements attributes scripts div table method'
	classVariableNames: 'Colors'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebGridColumn
	instanceVariableNames: 'parent id name width align aspect linkAspect linkView viewBlock addBlock sorted filter summaryType summary'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebHelp
	instanceVariableNames: 'pages'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebHelpPage
	instanceVariableNames: 'parent app view title body'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebIndex
	instanceVariableNames: 'index indexedObjects popularWords workQueue'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebLiveImage
	instanceVariableNames: 'gif refreshed width height painter'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebMethodResource
	instanceVariableNames: 'site object method contentType preferedUrl'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebMsgs
	instanceVariableNames: 'messagesByLanguage language'
	classVariableNames: 'Instance'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebNews
	instanceVariableNames: 'news hotNews actualNews archiveNews'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebNewsArticle
	instanceVariableNames: 'date actualToDate author title picture abstract body hot categories'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebSecurityManager
	instanceVariableNames: 'site users groups authenticationScheme accessByObject'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebSession
	instanceVariableNames: 'ids created cookies parent user parms requests lastRequest language country codePage appsForObjects lastApp lastView clipboard redirectLink redirectOrigin userValues'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebSessionManager
	instanceVariableNames: 'site sessionsByID sessionsByAddress activeSessions'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebStatistics
	instanceVariableNames: 'site referers refererStopList'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebStyle
	instanceVariableNames: 'site resources searchButton'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebTransactionMonitor
	instanceVariableNames: ''
	classVariableNames: 'BusySessions LastCommit LocalServers Lock NotificationSent Transactions'
	poolDictionaries: ''
	classInstanceVariableNames: 'Lock'!
Object subclass: #WebUser
	instanceVariableNames: 'parent id username password name surname company address city zip country email phone fax groups otherValues'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Object subclass: #WebUserGroup
	instanceVariableNames: 'name users'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ImageStream subclass: #BmpImageStream
	instanceVariableNames: 'bfType bfSize bfReserved1 bfReserved2 bfOffBits biSize biWidth biHeight biPlanes biBitCount biCompression biSizeImage biXPelsPerMeter biYPelsPerMeter biClrUsed biClrImportant imagePalette imageObject'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ImageStream subclass: #BosImageStream
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ImageStream subclass: #GifImageStream
	instanceVariableNames: 'width height bitsPerPixel colorPalette rowByteSize xpos ypos pass interlace codeSize clearCode eoiCode freeCode maxCode prefixTable suffixTable remainBitCount bufByte bufStream transparentPixel'
	classVariableNames: 'Extension GraphicControlLabel ImageSeparator Terminator'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ScaledDecimal subclass: #FixedPoint
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ProtocolAdaptor subclass: #AspectAdaptor
	instanceVariableNames: 'aspect'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
ProtocolAdaptor subclass: #IndexedAdaptor
	instanceVariableNames: 'index'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
Site subclass: #AIDASite
	instanceVariableNames: 'style settings systemServices userServices timestamps counters'
	classVariableNames: 'Default Instance SloveneCharacters'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebComment
	instanceVariableNames: 'text'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebFieldSet
	instanceVariableNames: 'legend'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebForm
	instanceVariableNames: 'name fields'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebFormElement
	instanceVariableNames: 'valueModel aspect object'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebGrid
	instanceVariableNames: 'collection filtered columns settings'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebIFrame
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebImage
	instanceVariableNames: 'image imageMap'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebImageMap
	instanceVariableNames: 'name areas'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebList
	instanceVariableNames: 'name kind type'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebListItem
	instanceVariableNames: 'tag'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebPage
	instanceVariableNames: 'name title headers session script identDepth'
	classVariableNames: 'WellKnownPages'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebScript
	instanceVariableNames: 'script'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebSeparator
	instanceVariableNames: 'type size length'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebTable
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebTableCell
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebTableRow
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebElement subclass: #WebText
	instanceVariableNames: 'text size textAttributes header paragraph font'
	classVariableNames: 'AttributeMarkup'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebButton
	instanceVariableNames: 'text type size'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebCheckBox
	instanceVariableNames: 'checked selected'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebInPlaceEditableText
	instanceVariableNames: 'size attribute formated allow triggerElement'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebInputField
	instanceVariableNames: 'size maxLength type'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebMenu
	instanceVariableNames: 'multiple collection selected aspectToStore objectToStore sort'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebRadioButton
	instanceVariableNames: 'checked'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFormElement subclass: #WebTextArea
	instanceVariableNames: 'rows columns'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebInputField subclass: #WebAutocompleteField
	instanceVariableNames: 'choicesAspect choicesObject choiceAspect elementToUpdate'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebInputField subclass: #WebDateInputField
	instanceVariableNames: 'button'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebInputField subclass: #WebFileInputField
	instanceVariableNames: 'filenameAspect contentTypeAspect'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebTextArea subclass: #WebRichEditor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebList subclass: #WebTabs
	instanceVariableNames: 'selected'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebTabs subclass: #ViewTabs
	instanceVariableNames: 'views'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebPage subclass: #WebApplication
	instanceVariableNames: 'observee view mode form ids error search'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebFrameApp
	instanceVariableNames: 'date'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebHelpApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebHelpPageApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebApplication subclass: #WebMsgsApp
	instanceVariableNames: 'webMsgs assocs texts'
	classVariableNames: 'Instance'
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebAdminApp
	instanceVariableNames: 'username password newUser'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebDemoApp
	instanceVariableNames: 'selectedClasses'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebDiscussionsApp
	instanceVariableNames: 'newResponse lastResponse'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebDiscussionsResponseApp
	instanceVariableNames: 'newResponse'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebIndexApp
	instanceVariableNames: 'searchString results page'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebNewsApp
	instanceVariableNames: 'newArticle'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebNewsArticleApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebSecurityManagerApp
	instanceVariableNames: 'usr group aclObject aclUserOrGroup aclForWho'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebFrameApp subclass: #WebStatisticsApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebTableCell subclass: #WebTableHeader
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebText subclass: #WebAnchor
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebText subclass: #WebLink
	instanceVariableNames: 'ooReference urlReference parms anchor security'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebText subclass: #WebRawText
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebMethodResource subclass: #WebLivePDFCreator
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: ''!
WebMethodResource subclass: #WebMethodImage
	instanceVariableNames: 'lastUsed'
	classVariableNames: ''
	poolDictionaries: ''
	classInstanceVariableNames: 'Cache'!

"Global Aliases"!


"Loose Methods"!

"End of package definition"!

"Source Globals"!

"Classes"!

DelimitedFile guid: (GUID fromString: '{B248DE18-8915-4D57-9649-EC040572EA79}')!
DelimitedFile comment: ''!
!DelimitedFile categoriesForClass!Unclassified! !
!DelimitedFile methodsFor!

codepage
	codepage isNil ifTrue: [self codepage: self defaultCodepage].
	^codepage!

codepage: aSymbol
	" #cp1250  #iso2 "
	codepage := aSymbol.!

crlf
	"return an cr-lf combination"

	^(Character cr) asSymbol ", (Character lf) asSymbol".!

defaultCodepage
	^#cp1250 "Windows"!

defaultDelimiter
	"default delimiter is ; "

	^$;!

delimiter
	"delimiter is a character, which separate fields in a delimited file"
	delimiter isNil ifTrue: [self delimiter: self defaultDelimiter].
	^delimiter!

delimiter: aCharacter
	"delimiter is a character, which separate fields in a delimited file"
	delimiter := aCharacter.!

endOfLine: aStream
	"return true if we are at the end of line (on cr or lf characters)"
	aStream peek isNil ifTrue: [^true].
	^(aStream peek = Character cr or: [aStream peek = Character lf]).!

filename
	^filename!

filename: aFilename
	filename := aFilename.!

initialize!

newRecordFrom: aStream

	"read one line from delimited file, detect and separate fields and convert to
	appropriate objects into an ordered collection. return that collection"

	| collection field |
	collection := OrderedCollection new.
	[self endOfLine: aStream] whileFalse:
		[field := self readFieldFrom: aStream.
		collection add: field].
	self skipEndOfLine: aStream.
	^collection!

readFieldFrom: aStream
	"read one field from delimited file, and convert to appropriate object. Return that object"
	| object stream |
	aStream peek = $" ifTrue:  "start of a text field"
		[object := aStream upTo: $"; upTo: $".
		(self endOfLine: aStream) ifFalse: [aStream upTo: self delimiter].
		^AIDASite convert: object fromCodepage: self codepage].
	stream := WriteStream on: String new.
	[aStream peek = self delimiter or: [self endOfLine: aStream]] 
		whileFalse: [aStream peek isNil ifTrue: [^stream contents]. stream nextPut: aStream next].
	aStream peek = self delimiter ifTrue: [aStream skip: 1].
	object := stream contents. stream close.
	^object
"
	(object includes: $. ) false
		ifTrue:
			[(Date readSloFrom: object readStream) notNil 
				ifTrue: [^Date readSloFrom: object readStream]
				ifFalse: [^object asInteger]]
		ifFalse: [^object asInteger].
"!

readFrom: aFilenameString
	"read a delimited file and convert content to object representation in 'records' collection"
	| stream | 
	self filename: aFilenameString asFilename.
	[stream :=  self filename readStream.
	self readFromStream: stream] 
		ensure: [stream close].

"DelimitedFile readFrom: 'm:\geoplin\tarifni\exports\ddnevnik.txt' "!

readFromStream: aStream
	"read a delimited file and convert content to object representation in 'records' collection"
	[aStream atEnd] whileFalse: [self records add: (self newRecordFrom: aStream)]!

records
	"when aDelimitedFile is created on a existing file, all records (lines in a file) are 
	converted and stored in this ordered collection. Fields in each record are stored in 
	another ordered collection as objects of appropriate class (texts as Strings, 
	numbers as Integers or Floats, dates as Dates)"

	records isNil ifTrue: [self records:OrderedCollection new].
	^records!

records: aCollection
	records := aCollection.!

skipEndOfLine: aStream

	"skip all cr and lf characters)"

	[aStream atEnd] whileFalse: 
		[(aStream peek = Character cr or: [aStream peek = Character lf]) 
			ifTrue:	[aStream skip: 1]
			ifFalse: [^self]
		].!

writeRecord: anArray to: aStream

	| dm data1 |
	dm := false.
	anArray do: [:data |
		dm ifTrue: [aStream nextPut: self delimiter].
		(data isKindOf: Integer) ifTrue: [aStream nextPutAll: data printString].
		(data isKindOf: String) ifTrue: 
			[data1 := AIDASite returnCSZFromCP852String:  data.
			data1 := data1 select: [:ch | ch asInteger <=255].
			aStream nextPutAll: '"',data1,'"'].
		(data isKindOf: FixedPoint) ifTrue: 
			[data1 := data printDotString select: [:ch | ch ~= $. ].
			aStream nextPutAll: data1].
		dm := true].
	aStream nextPutAll: self crlf.!

writeToFile
	self writeToFile: self filename.
"
|dmFile|
dmFile := DelimitedFile fileToWrite: 'test.dat'.
dmFile records 
	add: (Array with: 123 with: 'abcd' with: 345);
	add: (Array with: 234 with: 'CDE' with: 567).
dmFile writeToFile
"!

writeToFile: aFilenameString
	"export all records to delimited file"
	| stream | 
	self filename: aFilenameString asFilename.
	[stream :=  self filename writeStream.
	records do: [:record | self writeRecord: record to: stream] ]
		ensure: [stream close].
"
|dmFile|
dmFile := DelimitedFile new.
dmFile records 
	add: (Array with: 123 with: 'abcd' with: 345);
	add: (Array with: 234 with: 'CDE' with: 567).
dmFile writeToFile: 'test.dat'
"! !
!DelimitedFile categoriesFor: #codepage!accessing!private! !
!DelimitedFile categoriesFor: #codepage:!accessing!private! !
!DelimitedFile categoriesFor: #crlf!private! !
!DelimitedFile categoriesFor: #defaultCodepage!accessing!private! !
!DelimitedFile categoriesFor: #defaultDelimiter!accessing!private! !
!DelimitedFile categoriesFor: #delimiter!accessing!private! !
!DelimitedFile categoriesFor: #delimiter:!accessing!private! !
!DelimitedFile categoriesFor: #endOfLine:!private! !
!DelimitedFile categoriesFor: #filename!accessing!private! !
!DelimitedFile categoriesFor: #filename:!accessing!private! !
!DelimitedFile categoriesFor: #initialize!initialize - release!private! !
!DelimitedFile categoriesFor: #newRecordFrom:!private! !
!DelimitedFile categoriesFor: #readFieldFrom:!private! !
!DelimitedFile categoriesFor: #readFrom:!file reading!private! !
!DelimitedFile categoriesFor: #readFromStream:!file reading!private! !
!DelimitedFile categoriesFor: #records!accessing!private! !
!DelimitedFile categoriesFor: #records:!accessing!private! !
!DelimitedFile categoriesFor: #skipEndOfLine:!private! !
!DelimitedFile categoriesFor: #writeRecord:to:!file writing!private! !
!DelimitedFile categoriesFor: #writeToFile!file writing!private! !
!DelimitedFile categoriesFor: #writeToFile:!file writing!private! !

!DelimitedFile class methodsFor!

fileToWrite: aFilenameString

	"create a new instance on a specified (empty) file to write. After you fill records attribute with all
	data, call writeToFile method to do actual exporting to this file"

	| instance |
	instance := self new.
	instance filename: aFilenameString asFilename.
	^instance.!

new
	^super new initialize!

readFrom: aFilenameString

	"read a specified delimited file and store records in a records attribute. Use default delimiter
	for field separator (character ; )"

	| instance |
	instance := self new.
	instance readFrom: aFilenameString.
	^instance.

"DelimitedFile readFrom: 'i:\projekti\dare\proizvod.txt' "! !
!DelimitedFile class categoriesFor: #fileToWrite:!instance creation!private! !
!DelimitedFile class categoriesFor: #new!instance creation!private! !
!DelimitedFile class categoriesFor: #readFrom:!instance creation!private! !

DirectoryProxy guid: (GUID fromString: '{83F46590-3014-40B7-A75D-ABB4FE481CC0}')!
DirectoryProxy comment: ''!
!DirectoryProxy categoriesForClass!Unclassified! !
DocLink guid: (GUID fromString: '{40CA31DB-8D65-465A-9D39-A3859E9B15F3}')!
DocLink comment: ''!
!DocLink categoriesForClass!Unclassified! !
!DocLink methodsFor!

asWebLink
	^WebLink text: self title linkTo: self url!

initialize
	^self!

migrateToUnicode
	"DocLink allInstances do: [:each | each migrateToUnicode]"
	title notNil ifTrue: [title := title ensureUnicodeSloveneChars]!

object
	^object!

object: anObject
	object := anObject!

printString
	^'a Doclink
		title:  ', (self title notNil ifTrue: [self title] ifFalse: ['']), '
		url: ', (self url notNil ifTrue: [self url] ifFalse: ['']), '
		object: ', self object printString!

title
	^title!

title: aString
	title := aString!

url
	^url!

url: aString
	url := aString!

uuid
	^self hash printString! !
!DocLink categoriesFor: #asWebLink!converting!private! !
!DocLink categoriesFor: #initialize!initialize-release!private! !
!DocLink categoriesFor: #migrateToUnicode!private! !
!DocLink categoriesFor: #object!accessing!private! !
!DocLink categoriesFor: #object:!accessing!private! !
!DocLink categoriesFor: #printString!private! !
!DocLink categoriesFor: #title!accessing!private! !
!DocLink categoriesFor: #title:!accessing!private! !
!DocLink categoriesFor: #url!accessing!private! !
!DocLink categoriesFor: #url:!accessing!private! !
!DocLink categoriesFor: #uuid!accessing!private! !

!DocLink class methodsFor!

new
	"Answer a newly created and initialized instance."

	^super new initialize! !
!DocLink class categoriesFor: #new!instance creation!private! !

FileProxy guid: (GUID fromString: '{8C82A5D0-F9C9-4592-B262-9CF7B2B5B1F6}')!
FileProxy comment: ''!
!FileProxy categoriesForClass!Unclassified! !
!FileProxy methodsFor!

absoluteTagFrom: aTagString urlStart: anURLString

	""

	| tag url |
	tag := (aTagString copyReplaceAll: '\' with: '/').
	((tag copyFrom: 1 to: 3) = '../')
		ifFalse:  "not relative to parent directory"
			[^((tag copyUpTo: $"), '"', anURLString, 
				(tag copyFrom: ((tag indexOf: $") + 1) to: tag size))]
		ifTrue:
			[tag := tag readStream upTo: $/; upToEnd.
			url := anURLString copyFrom: 1 to: (anURLString lastIndexOf: $/).
			^self absoluteTagFrom: tag urlStart: url].!

accessedTimestamp
	^Timestamp
		fromDate: ((self timestamps at: #accessed ifAbsent: [^nil]) at: 1)
		andTime: ((self timestamps at: #accessed ifAbsent: [^nil]) at: 2)!

argumentsFrom: aMessageString

	^Array new: 0 "for now!! "!

bodyTagIndex
	"index of element, which represent body tag in original html file"
	^bodyTagIndex!

bodyTagIndex: anInteger
	"set the index of element, which represent body tag in original html file"
	bodyTagIndex := anInteger.!

clearElements
	elements := OrderedCollection new.!

clearImgTagIndexes
	imgTagIndexes := OrderedCollection new.!

clearLinkTagIndexes
	linkTagIndexes := OrderedCollection new.!

clearServletTagIndexes
	servletTagIndexes := OrderedCollection new.!

codepage
	" #iso2 by default"
	codepage isNil ifTrue: [self codepage: #'iso-8859-2'].
	^codepage.!

codepage: aSymbol
	codepage := aSymbol.!

content
	content isNil ifTrue: 
		[(self contentType ~= 'text/html') 
			ifTrue: [self refreshContent] 
			ifFalse: [self content: ''] ].
	^content!

content: aString
	content := aString.!

contentType
	"MIME type of original content. 'unknown' if not known"
	contentType isNil ifTrue: [self contentType: 'unknown'].
	^contentType.!

contentType: aMIMEString
	"MIME type of original content"
	contentType := aMIMEString.!

contentTypeOfFile: aFilename
	"return a MIME type of aFilename. 'unknown' if filename extension is not known"
	|  fileExtension fileString |
	fileString := aFilename asString.
	(fileString includes: $.) ifFalse: [^'unknown'].
	fileExtension := (fileString copyFrom: (fileString indexOf: $.) to: fileString size) asLowercase.
	(fileExtension = '.htm' or: [fileExtension = '.html']) ifTrue: [^'text/html'].
	(fileExtension = '.gif') ifTrue: [^'image/gif'].
	(fileExtension = '.jpg' or: [fileExtension = '.jpeg']) ifTrue: [^'image/jpeg'].
	^'unknown'!

createdTimestamp
	^Timestamp
		fromDate: ((self timestamps at: #created ifAbsent: [^nil]) at: 1)
		andTime: ((self timestamps at: #created ifAbsent: [^nil]) at: 2)!

detectCodepage: aString
	" "
	| win1250 iso2 sevenBit above127 |
	win1250 := 0.
	aString do: [:ch | (#(200 154 138 158 142) includes: ch asInteger) ifTrue: [win1250 := win1250+1] ].
	iso2 := 0.
	aString do: [:ch | (#(200 185 169 190 174) includes: ch asInteger) ifTrue: [iso2 := iso2+1] ].
	sevenBit := 0.
"	aString do: [:ch | (#(94 123 91 96 64) includes: ch asInteger) ifTrue: [sevenBit := sevenBit+1] ]."
	above127 := 0.
	aString do: [:ch | ch asInteger > 127 ifTrue: [above127 := above127+1] ].
	above127 = 0 
		ifTrue: [sevenBit ~= 0 ifTrue: [^#'7bit'] ifFalse: [^#csz] ]
		ifFalse: [iso2 > win1250 ifTrue: [^#'iso-8859-2'] ifFalse: [^#'win-1250'] ].!

elements

	"all elements (texts and tags) of a gtml page"

	elements isNil ifTrue: 
		[self clearElements.
		(self contentType = 'text/html') ifTrue: [self refreshContent] ].
	^elements!

expiresTimestamp
	"for broswer: after 6 hours by default. It is good to reload from time to time 
	if changes were made "
	^Timestamp fromSeconds: (Timestamp now asSeconds + (6 * 3600))!

filename
	| homeDir |
	(filename isKindOf: Filename) ifTrue: [self filename: filename].
	filename isNil ifTrue: [^''].
	(filename includes: $: ) ifTrue:   " TEMPORARY !!!!!!"
		[filename := filename copyReplaceAll: (filename copyUpTo: ':') with: ''.
		homeDir := self site homeDirectory copyReplaceAll: (filename copyUpTo: ':') with: ''.
		filename := filename copyReplaceAll: homeDir with: ''].
	^(self site homeDirectory, 
		(filename copyReplaceAll: self site homeDirectory with: '')) asFilename.!

filename: aFilename
	filename := aFilename asString copyReplaceAll: self site homeDirectory with: ''.!

fileStillExist
	^self filename exists!

from: aString
	| file relFilename |
	file := aString asFilename. file exists ifFalse: [^nil].
	relFilename := (file asString copyReplaceAll: self site homeDirectory with: '').
	self filename: (relFilename isEmpty ifTrue: ['\'] ifFalse: [relFilename]).
	self refreshTimestamps.
	self contentType: (self contentTypeOfFile: file).
	self contentType = 'text/html' 
		ifTrue:
			[self content: file contentsOfEntireFile.
			self codepage: (self detectCodepage: self content).
			self content: (AIDASite convert: self content fromCodepage: self codepage).
			"self prepareHTMLPage. self makeAbsoluteImgTags. self content: nil"]
		ifFalse: [ | stream | 
			[stream := file readStream binary. self content: stream contents] ensure: [stream close] ]!

hasFileChanged
	"check if original file changed since last visit"
	^self modifiedTimestamp ~= (self filename dates at: #modified).!

imgTagIndexes
	"indexes of elements, which represent image tags in original html file"
	imgTagIndexes isNil ifTrue: [self clearImgTagIndexes].
	^imgTagIndexes!

indexContent
	"index text in server global index"
	self contentType = 'text/html' ifTrue: [self site index indexObject: self]!

indexText
	"pure text, without tags, for indexer"
	| stream bodyStart element text |
	bodyStart := (1 to: self elements size) 
		detect: [:index | '<BODY*' match: (self elements at: index)] ifNone: [1].
	stream := WriteStream on: String new.
	bodyStart + 1 to: self elements size do:  [:index | 
		element := self elements at: index.
		(element notEmpty and: [element first ~= $<]) ifTrue: [stream nextPutAll: element] ].
	text := stream contents "copyReplaceAll: WebElement new eol with: ' '". 
	text := text copyReplaceAll: '&nbsp;' with: ' '.
	^text!

indexTitle
	"find title, if noone, then return url"
	1 to: self elements size do: [:index |
		('<TITLE*' match: (self elements at: index)) ifTrue: [^self elements at: index+1] ].
	^self site urlResolver halfUrlFor: self!

isWebElement
	^false!

isWebPage
	^true!

linkTagIndexes
	"indexes of elements, which represent link tags in original html file"
	linkTagIndexes isNil ifTrue: [self clearLinkTagIndexes].
	^linkTagIndexes!

makeAbsoluteImgTags
	"if image url's are relative, make them absolute. Also do it for a body tag (background image). 
	Url is constructed from a imageServer address from WebServer settings, and from filename with 	homeDirectory substracted. "
	| fname urlStart index tag bodyTag |
	fname := (self filename asString) copyReplaceAll: (self site homeDirectory) with: ''.
	fname := fname copyFrom: 1 to: (fname lastIndexOf: (AIDASite slash at: 1)).
	urlStart := 'http://', self site address, (fname copyReplaceAll: '\' with: '/').
	self imgTagIndexes do: [:inx  | tag := self elements at: inx.
		('*http://*' match: tag) ifFalse:    "not an absolute source url"
			[self elements at: inx put: (self absoluteTagFrom: tag urlStart: urlStart)] ].
	self bodyTagIndex notNil ifTrue:
		[bodyTag := self elements at: bodyTagIndex.
		(('*background*' match:  bodyTag) and: [('*http://*' match:  bodyTag) not]) 
			ifTrue: 
				[index := bodyTag asLowercase findString: 'background' startingAt: 1.
				index := bodyTag findString: '"' startingAt: index.
				(( bodyTag at: index+1) = $#) ifTrue: [^self]. "only colored background"
				self elements at: bodyTagIndex put:
					((bodyTag copyFrom: 1 to: index), urlStart, 
						(bodyTag copyFrom: index + 1 to: bodyTag size)) ] ].!

methodFrom: aMessageString

	^aMessageString asSymbol "for now!! "!

modifiedTimestamp
	^Timestamp
		fromDate: ((self timestamps at: #modified ifAbsent: [^nil]) at: 1)
		andTime: ((self timestamps at: #modified ifAbsent: [^nil]) at: 2)!

prepareHTMLPage
	"decompose content into elements (texts and tags)"
	| stream tag index |
	self clearElements. self clearImgTagIndexes. 
	self clearLinkTagIndexes. self clearServletTagIndexes.
	stream := ReadStream on: self content.
	index := 1.
	[stream atEnd] whileFalse:
		[self elements add: (stream upTo: $<). index := index + 1.
		tag := ('<', (stream upTo: $>), '>').
		('<aida*' match: tag) ifTrue: [self servletTagIndexes add: index].
		('*img*' match: tag) ifTrue: [self imgTagIndexes add: index].
		('*href*' match: tag) 
			ifTrue: [self linkTagIndexes add: index]
			ifFalse: 
				[(('*body*' match: tag) and: [('*/body*' match: tag) not])
					ifTrue: [self bodyTagIndex: index]].
		self elements add: tag. index := index + 1.
		].
"
	self elements markDirty.
	self imgTagIndexes markDirty.
	self linkTagIndexes markDirty.
"!

printHTMLPageOn: aStream forSession: aSession
	"convert elements into a HTML stream"
	| |
" 
	self contentType = 'text/html'
		ifTrue:
			[index := 1.
			self elements do: [:each | 
				each == self elements last ifTrue: [^self]. 
				(self servletTagIndexes includes: index) 
					ifTrue: [self printServlet: index on: aStream forSession: aSession]
					ifFalse: [aStream nextPutAll: 
						(AIDASite convertToWeb: each on: aSession)].
				index := index + 1 ] ]
		ifFalse: 
			[aStream nextPutAll: self content asByteString].
"
	aStream nextPutAll: self content asByteString. "temporary text/html too!! "
	self sizeAboveMark ifTrue: [self releaseContent].  "for large files"!

printServlet: index on: aStream forSession: aSession

	| tag appClass message app element |
	tag := (self elements at: index) copy readStream.
	appClass := (tag upTo: $ ; upTo: $ ) asSymbol.
	message := tag upTo: $>.
	app := aSession servletAppFor: appClass.
	app isNil ifTrue: [^self ].
	element := self servletPerform: message on: app.
	element notNil ifTrue: 
		[element printHTMLPageOn: aStream forSession: aSession].!

printString
	^('aFileProxy for: ', self filename asString)!

printWebPageFor: aSession
	self fileStillExist ifFalse: [self removeYourself. ^WebPage new].
	self hasFileChanged ifTrue: 
		[self refreshContent.
		self indexContent].
	^self!

put: aString
	"replace self with contents in aString from PUT request"
	self content: aString.
	self writeToFile!

refreshContent
	self from: self filename asString.!

refreshTimestamps
	self timestamps: self filename asFilename dates.!

releaseContent
	"release origContent and elements to save memory"
	content := nil.
	elements := nil.!

removeYourself
	"remove from url resolver and elsewhere"
	self site urlResolver removeObject: self.!

servletPerform: aMessageString on: aWebApp

	| method |
	method := (self methodFrom: aMessageString).
	(aWebApp class canUnderstand: method) ifFalse: [^nil].
	^aWebApp
		perform: method
		withArguments: (self argumentsFrom: aMessageString).!

servletTagIndexes
	"indexes of elements, which represent servlet in original html file"
	servletTagIndexes isNil ifTrue: [self clearServletTagIndexes].
	^servletTagIndexes!

site
	^site!

site: anAIDASite
	site := anAIDASite.!

size
	"size of content in bytes"
	(self contentType = 'text/html')
		ifTrue: [^self elements inject: 0 into: [:sum : e | sum + e size] ]
		ifFalse: [^self content size]!

sizeAboveMark

	"test if content is above specified size"
	^self size > (50 * 1024) "bytes"!

timestamps
	timestamps isNil ifTrue: [self timestamps: Dictionary new.].
	^timestamps!

timestamps: aDictionary
	" a dictionary with a DateAndTime at: 
	#accessed #modified #statusChanged #created"
	timestamps := aDictionary.!

writeToFile
	| stream |
	[stream := self filename writeStream. stream binary.
	stream nextPutAll: self content]
		ensure: [stream close].
	self refreshTimestamps.! !
!FileProxy categoriesFor: #absoluteTagFrom:urlStart:!parsing!private! !
!FileProxy categoriesFor: #accessedTimestamp!accessing-timestamps!private! !
!FileProxy categoriesFor: #argumentsFrom:!printing - servlets!private! !
!FileProxy categoriesFor: #bodyTagIndex!accessing-tags!private! !
!FileProxy categoriesFor: #bodyTagIndex:!accessing-tags!private! !
!FileProxy categoriesFor: #clearElements!initialize - release!private! !
!FileProxy categoriesFor: #clearImgTagIndexes!accessing-tags!private! !
!FileProxy categoriesFor: #clearLinkTagIndexes!accessing-tags!private! !
!FileProxy categoriesFor: #clearServletTagIndexes!accessing-tags!private! !
!FileProxy categoriesFor: #codepage!accessing!private! !
!FileProxy categoriesFor: #codepage:!private! !
!FileProxy categoriesFor: #content!accessing!private! !
!FileProxy categoriesFor: #content:!private! !
!FileProxy categoriesFor: #contentType!accessing!private! !
!FileProxy categoriesFor: #contentType:!private! !
!FileProxy categoriesFor: #contentTypeOfFile:!private! !
!FileProxy categoriesFor: #createdTimestamp!accessing-timestamps!private! !
!FileProxy categoriesFor: #detectCodepage:!private! !
!FileProxy categoriesFor: #elements!private! !
!FileProxy categoriesFor: #expiresTimestamp!accessing-timestamps!private! !
!FileProxy categoriesFor: #filename!accessing!private! !
!FileProxy categoriesFor: #filename:!private! !
!FileProxy categoriesFor: #fileStillExist!private!testing! !
!FileProxy categoriesFor: #from:!parsing!private! !
!FileProxy categoriesFor: #hasFileChanged!private!testing! !
!FileProxy categoriesFor: #imgTagIndexes!accessing-tags!private! !
!FileProxy categoriesFor: #indexContent!indexing!private! !
!FileProxy categoriesFor: #indexText!indexing!private! !
!FileProxy categoriesFor: #indexTitle!indexing!private! !
!FileProxy categoriesFor: #isWebElement!private!testing! !
!FileProxy categoriesFor: #isWebPage!private!testing! !
!FileProxy categoriesFor: #linkTagIndexes!accessing-tags!private! !
!FileProxy categoriesFor: #makeAbsoluteImgTags!parsing!private! !
!FileProxy categoriesFor: #methodFrom:!printing - servlets!private! !
!FileProxy categoriesFor: #modifiedTimestamp!accessing-timestamps!private! !
!FileProxy categoriesFor: #prepareHTMLPage!parsing!private! !
!FileProxy categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!FileProxy categoriesFor: #printServlet:on:forSession:!printing - servlets!private! !
!FileProxy categoriesFor: #printString!printing!private! !
!FileProxy categoriesFor: #printWebPageFor:!printing!private! !
!FileProxy categoriesFor: #put:!accessing!private! !
!FileProxy categoriesFor: #refreshContent!initialize - release!private! !
!FileProxy categoriesFor: #refreshTimestamps!private! !
!FileProxy categoriesFor: #releaseContent!initialize - release!private! !
!FileProxy categoriesFor: #removeYourself!private! !
!FileProxy categoriesFor: #servletPerform:on:!printing - servlets!private! !
!FileProxy categoriesFor: #servletTagIndexes!accessing-tags!private! !
!FileProxy categoriesFor: #site!accessing!private! !
!FileProxy categoriesFor: #site:!private! !
!FileProxy categoriesFor: #size!accessing!private! !
!FileProxy categoriesFor: #sizeAboveMark!private!testing! !
!FileProxy categoriesFor: #timestamps!private! !
!FileProxy categoriesFor: #timestamps:!private! !
!FileProxy categoriesFor: #writeToFile!private! !

!FileProxy class methodsFor!

from: aFilenameString onSite: aSite
	"read a file and make a HTML proxy of it. Return nil, if file does not exist or cannot be opened. 
	Also record a server for which you make a proxy"
	| proxy |
	proxy := self new site: aSite; from: aFilenameString.
	proxy indexContent.
	^proxy! !
!FileProxy class categoriesFor: #from:onSite:!instance creation!private! !

ImageStream guid: (GUID fromString: '{B5989C34-8484-4431-A890-1867529CF767}')!
ImageStream comment: ''!
!ImageStream categoriesForClass!Unclassified! !
!ImageStream methodsFor!

atEnd
	^imageStream atEnd!

close
	imageStream close!

compute: aBlock 
	(self progressValue isKindOf: ValueHolder)
		ifTrue: [self progressValue compute: aBlock]!

contents
	^imageStream contents!

convertValue: value from: fromScale to: toScale 
	^value = 0
		ifTrue: [0]
		ifFalse: [value = fromScale
				ifTrue: [toScale]
				ifFalse: [(value + 1 * (toScale + 1) / (fromScale + 1)) rounded - 1 max: 0]]!

cr
	^imageStream nextPut: Character cr asInteger!

errorCanNotRead
	self error: 'can''t read the image'.
	^nil!

errorCanNotWrite
	self error: 'can''t write the image'.
	^nil!

hasMagicNumber: aByteArray 
	| position array |
	position := imageStream position.
	imageStream size - position >= aByteArray size
		ifTrue: 
			[array := (imageStream next: aByteArray size) asByteArray.
			array = aByteArray ifTrue: [^true]].
	imageStream position: position.
	^false!

lf
	^imageStream nextPut: Character lf asInteger!

next
	^imageStream next!

next: size 
	^imageStream next: size!

nextImage
	^self subclassResponsibility!

nextLong
	^(imageStream next bitShift: 24)
		+ (imageStream next bitShift: 16) + (imageStream next bitShift: 8) + imageStream next!

nextLongPut: a32BitW 
	imageStream nextPut: ((a32BitW bitShift: -24)
			bitAnd: 255).
	imageStream nextPut: ((a32BitW bitShift: -16)
			bitAnd: 255).
	imageStream nextPut: ((a32BitW bitShift: -8)
			bitAnd: 255).
	imageStream nextPut: (a32BitW bitAnd: 255).
	^a32BitW!

nextPut: aByte 
	^imageStream nextPut: aByte!

nextPutAll: aByteArray 
	^imageStream nextPutAll: aByteArray!

nextPutImage: anImage 
	^self subclassResponsibility!

nextWord
	^(imageStream next bitShift: 8)
		+ imageStream next!

nextWordPut: a16BitW 
	imageStream nextPut: ((a16BitW bitShift: -8)
			bitAnd: 255).
	imageStream nextPut: (a16BitW bitAnd: 255).
	^a16BitW!

on: aStream 
	imageStream := aStream.
	(imageStream respondsTo: #binary)
		ifTrue: [imageStream binary].
	self progressValue: (ValueHolder with: nil)!

position
	^imageStream position!

position: anInteger 
	^imageStream position: anInteger!

progress
	^self progressValue value!

progress: normalizedNumber 
	(0 <= normalizedNumber and: [normalizedNumber <= 1])
		ifTrue: 
			[| truncatedValue |
			truncatedValue := normalizedNumber roundTo: 0.005.
			self progressValue value = truncatedValue ifFalse: [self progressValue value: truncatedValue]]!

progressValue
	^progressValue!

progressValue: aValueHolder 
	progressValue := aValueHolder!

show: anImage 
	^self class show: anImage!

size
	^imageStream size!

skip: anInteger 
	^imageStream skip: anInteger!

space
	^imageStream nextPut: Character space asInteger!

tab
	^imageStream nextPut: Character tab asInteger! !
!ImageStream categoriesFor: #atEnd!private!stream access! !
!ImageStream categoriesFor: #close!private!stream access! !
!ImageStream categoriesFor: #compute:!private!progress! !
!ImageStream categoriesFor: #contents!private!stream access! !
!ImageStream categoriesFor: #convertValue:from:to:!private! !
!ImageStream categoriesFor: #cr!private!stream access! !
!ImageStream categoriesFor: #errorCanNotRead!private! !
!ImageStream categoriesFor: #errorCanNotWrite!private! !
!ImageStream categoriesFor: #hasMagicNumber:!private! !
!ImageStream categoriesFor: #lf!private!stream access! !
!ImageStream categoriesFor: #next!private!stream access! !
!ImageStream categoriesFor: #next:!private!stream access! !
!ImageStream categoriesFor: #nextImage!accessing!private! !
!ImageStream categoriesFor: #nextLong!private!stream access! !
!ImageStream categoriesFor: #nextLongPut:!private!stream access! !
!ImageStream categoriesFor: #nextPut:!private!stream access! !
!ImageStream categoriesFor: #nextPutAll:!private!stream access! !
!ImageStream categoriesFor: #nextPutImage:!accessing!private! !
!ImageStream categoriesFor: #nextWord!private!stream access! !
!ImageStream categoriesFor: #nextWordPut:!private!stream access! !
!ImageStream categoriesFor: #on:!initialize-release!private! !
!ImageStream categoriesFor: #position!private!stream access! !
!ImageStream categoriesFor: #position:!private!stream access! !
!ImageStream categoriesFor: #progress!private!progress! !
!ImageStream categoriesFor: #progress:!private!progress! !
!ImageStream categoriesFor: #progressValue!private!progress! !
!ImageStream categoriesFor: #progressValue:!private!progress! !
!ImageStream categoriesFor: #show:!private!viewing! !
!ImageStream categoriesFor: #size!private!stream access! !
!ImageStream categoriesFor: #skip:!private!stream access! !
!ImageStream categoriesFor: #space!private!stream access! !
!ImageStream categoriesFor: #tab!private!stream access! !

!ImageStream class methodsFor!

assert: assertBlock do: doBlock ensure: ensureBlock 
	assertBlock value.
	[doBlock value]
		valueNowOrOnUnwindDo: [ensureBlock value]!

colorPalette256
	"ImageStream colorPalette256."

	| anArray |
	ColorPalette256 notNil ifTrue: [^ColorPalette256].
	anArray := Compiler evaluate: '#(
		#(8191 8191 8191)
		#(8191 8191 6553)
		#(8191 8191 4915)
		#(8191 8191 3276)
		#(8191 8191 1638)
		#(8191 8191 0)
		#(8191 6553 8191)
		#(8191 6553 6553)
		#(8191 6553 4915)
		#(8191 6553 3276)
		#(8191 6553 1638)
		#(8191 6553 0)
		#(8191 4915 8191)
		#(8191 4915 6553)
		#(8191 4915 4915)
		#(8191 4915 3276)
		#(8191 4915 1638)
		#(8191 4915 0)
		#(8191 3276 8191)
		#(8191 3276 6553)
		#(8191 3276 4915)
		#(8191 3276 3276)
		#(8191 3276 1638)
		#(8191 3276 0)
		#(8191 1638 8191)
		#(8191 1638 6553)
		#(8191 1638 4915)
		#(8191 1638 3276)
		#(8191 1638 1638)
		#(8191 1638 0)
		#(8191 0 8191)
		#(8191 0 6553)
		#(8191 0 4915)
		#(8191 0 3276)
		#(8191 0 1638)
		#(8191 0 0)
		#(6553 8191 8191)
		#(6553 8191 6553)
		#(6553 8191 4915)
		#(6553 8191 3276)
		#(6553 8191 1638)
		#(6553 8191 0)
		#(6553 6553 8191)
		#(6553 6553 6553)
		#(6553 6553 4915)
		#(6553 6553 3276)
		#(6553 6553 1638)
		#(6553 6553 0)
		#(6553 4915 8191)
		#(6553 4915 6553)
		#(6553 4915 4915)
		#(6553 4915 3276)
		#(6553 4915 1638)
		#(6553 4915 0)
		#(6553 3276 8191)
		#(6553 3276 6553)
		#(6553 3276 4915)
		#(6553 3276 3276)
		#(6553 3276 1638)
		#(6553 3276 0)
		#(6553 1638 8191)
		#(6553 1638 6553)
		#(6553 1638 4915)
		#(6553 1638 3276)
		#(6553 1638 1638)
		#(6553 1638 0)
		#(6553 0 8191)
		#(6553 0 6553)
		#(6553 0 4915)
		#(6553 0 3276)
		#(6553 0 1638)
		#(6553 0 0)
		#(4915 8191 8191)
		#(4915 8191 6553)
		#(4915 8191 4915)
		#(4915 8191 3276)
		#(4915 8191 1638)
		#(4915 8191 0)
		#(4915 6553 8191)
		#(4915 6553 6553)
		#(4915 6553 4915)
		#(4915 6553 3276)
		#(4915 6553 1638)
		#(4915 6553 0)
		#(4915 4915 8191)
		#(4915 4915 6553)
		#(4915 4915 4915)
		#(4915 4915 3276)
		#(4915 4915 1638)
		#(4915 4915 0)
		#(4915 3276 8191)
		#(4915 3276 6553)
		#(4915 3276 4915)
		#(4915 3276 3276)
		#(4915 3276 1638)
		#(4915 3276 0)
		#(4915 1638 8191)
		#(4915 1638 6553)
		#(4915 1638 4915)
		#(4915 1638 3276)
		#(4915 1638 1638)
		#(4915 1638 0)
		#(4915 0 8191)
		#(4915 0 6553)
		#(4915 0 4915)
		#(4915 0 3276)
		#(4915 0 1638)
		#(4915 0 0)
		#(3276 8191 8191)
		#(3276 8191 6553)
		#(3276 8191 4915)
		#(3276 8191 3276)
		#(3276 8191 1638)
		#(3276 8191 0)
		#(3276 6553 8191)
		#(3276 6553 6553)
		#(3276 6553 4915)
		#(3276 6553 3276)
		#(3276 6553 1638)
		#(3276 6553 0)
		#(3276 4915 8191)
		#(3276 4915 6553)
		#(3276 4915 4915)
		#(3276 4915 3276)
		#(3276 4915 1638)
		#(3276 4915 0)
		#(3276 3276 8191)
		#(3276 3276 6553)
		#(3276 3276 4915)
		#(3276 3276 3276)
		#(3276 3276 1638)
		#(3276 3276 0)
		#(3276 1638 8191)
		#(3276 1638 6553)
		#(3276 1638 4915)
		#(3276 1638 3276)
		#(3276 1638 1638)
		#(3276 1638 0)
		#(3276 0 8191)
		#(3276 0 6553)
		#(3276 0 4915)
		#(3276 0 3276)
		#(3276 0 1638)
		#(3276 0 0)
		#(1638 8191 8191)
		#(1638 8191 6553)
		#(1638 8191 4915)
		#(1638 8191 3276)
		#(1638 8191 1638)
		#(1638 8191 0)
		#(1638 6553 8191)
		#(1638 6553 6553)
		#(1638 6553 4915)
		#(1638 6553 3276)
		#(1638 6553 1638)
		#(1638 6553 0)
		#(1638 4915 8191)
		#(1638 4915 6553)
		#(1638 4915 4915)
		#(1638 4915 3276)
		#(1638 4915 1638)
		#(1638 4915 0)
		#(1638 3276 8191)
		#(1638 3276 6553)
		#(1638 3276 4915)
		#(1638 3276 3276)
		#(1638 3276 1638)
		#(1638 3276 0)
		#(1638 1638 8191)
		#(1638 1638 6553)
		#(1638 1638 4915)
		#(1638 1638 3276)
		#(1638 1638 1638)
		#(1638 1638 0)
		#(1638 0 8191)
		#(1638 0 6553)
		#(1638 0 4915)
		#(1638 0 3276)
		#(1638 0 1638)
		#(1638 0 0)
		#(0 8191 8191)
		#(0 8191 6553)
		#(0 8191 4915)
		#(0 8191 3276)
		#(0 8191 1638)
		#(0 8191 0)
		#(0 6553 8191)
		#(0 6553 6553)
		#(0 6553 4915)
		#(0 6553 3276)
		#(0 6553 1638)
		#(0 6553 0)
		#(0 4915 8191)
		#(0 4915 6553)
		#(0 4915 4915)
		#(0 4915 3276)
		#(0 4915 1638)
		#(0 4915 0)
		#(0 3276 8191)
		#(0 3276 6553)
		#(0 3276 4915)
		#(0 3276 3276)
		#(0 3276 1638)
		#(0 3276 0)
		#(0 1638 8191)
		#(0 1638 6553)
		#(0 1638 4915)
		#(0 1638 3276)
		#(0 1638 1638)
		#(0 1638 0)
		#(0 0 8191)
		#(0 0 6553)
		#(0 0 4915)
		#(0 0 3276)
		#(0 0 1638)
		#(7645 0 0)
		#(7099 0 0)
		#(6007 0 0)
		#(5461 0 0)
		#(4369 0 0)
		#(3822 0 0)
		#(2730 0 0)
		#(2184 0 0)
		#(1092 0 0)
		#(546 0 0)
		#(0 7645 0)
		#(0 7099 0)
		#(0 6007 0)
		#(0 5461 0)
		#(0 4369 0)
		#(0 3822 0)
		#(0 2730 0)
		#(0 2184 0)
		#(0 1092 0)
		#(0 546 0)
		#(0 0 7645)
		#(0 0 7099)
		#(0 0 6007)
		#(0 0 5461)
		#(0 0 4369)
		#(0 0 3822)
		#(0 0 2730)
		#(0 0 2184)
		#(0 0 1092)
		#(0 0 546)
		#(7645 7645 7645)
		#(7099 7099 7099)
		#(6007 6007 6007)
		#(5461 5461 5461)
		#(4369 4369 4369)
		#(3822 3822 3822)
		#(2730 2730 2730)
		#(2184 2184 2184)
		#(1092 1092 1092)
		#(546 546 546)
		#(0 0 0)
	)' logged: false.
	anArray := anArray
				collect: 
					[:array | 
					| r g b color |
					r := array at: 1.
					g := array at: 2.
					b := array at: 3.
					ColorValue scalingValue = 8191
						ifTrue: [color := ColorValue
										scaledRed: r
										scaledGreen: g
										scaledBlue: b]
						ifFalse: 
							[r := r / 8191.
							g := g / 8191.
							b := b / 8191.
							color := ColorValue
										red: r
										green: g
										blue: b].
					color yourself].
	ColorPalette256 := MappedPalette withColors: anArray reverse.
	^ColorPalette256!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!

flushPalettes
	"ImageStream flushPalettes."

	ColorPalette256 := nil.
	GrayPalette256 := nil!

fromClipboard
	"ImageStream show: ImageStream fromClipboard."

	| pixmap image |
	pixmap := Pixmap fromClipboard.
	image := pixmap asImage.
	^image!

fromDisplay
	"ImageStream show: ImageStream fromDisplay."

	^self fromDisplay: Screen default bounds!

fromDisplay: aRectangle 
	"ImageStream show: (ImageStream fromDisplay: (0 @ 0 extent: 100 @ 100))."

	^Screen default completeContentsOfArea: aRectangle!

fromUser
	"ImageStream show: ImageStream fromUser."

	^self fromDisplay: Rectangle fromUser!

grayPalette256
	"ImageStream grayPalette256."

	| paletteSize anArray |
	GrayPalette256 notNil ifTrue: [^GrayPalette256].
	paletteSize := 256.
	anArray := Array new: paletteSize.
	1 to: paletteSize
		do: 
			[:index | 
			| color |
			color := ColorValue brightness: 1 - (index - 1 / (paletteSize - 1)).
			anArray at: index put: color].
	GrayPalette256 := MappedPalette withColors: anArray reverse.
	^GrayPalette256!

imageKindTable
	"ImageStream imageKindTable."

	ImageKindTable isNil
		ifTrue: 
			[| aDictionary |
			aDictionary := Dictionary new.
			aDictionary at: 'bos' put: #BosImageStream.
			aDictionary at: 'boss' put: #BosImageStream.
			aDictionary at: 'bmp' put: #BmpImageStream.
			aDictionary at: 'bmpf' put: #BmpImageStream.
			aDictionary at: 'gif' put: #GifImageStream.
			aDictionary at: 'giff' put: #GifImageStream.
			aDictionary at: 'jpg' put: #JpegImageStream.
			aDictionary at: 'jpeg' put: #JpegImageStream.
			aDictionary at: 'pic' put: #PictImageStream.
			aDictionary at: 'pict' put: #PictImageStream.
			ImageKindTable := aDictionary].
	^ImageKindTable!

imageStreamClassForFileName: aFilename 
	"ImageStream imageStreamClassForFileName: 'zzz.gif' asFilename."

	| aString aSymbol aClass |
	aString := (aFilename asString reverse copyUpTo: $.) reverse.
	aString := aString asLowercase.
	aSymbol := self imageKindTable at: aString ifAbsent: [nil].
	aSymbol isNil ifTrue: [^nil].
	aClass := Smalltalk at: aSymbol ifAbsent: [nil].
	^aClass!

initialize
	"ImageStream initialize."

	ImageKindTable := nil.
	self flushPalettes!

install
	"ImageStream install."

	self colorPalette256.
	self grayPalette256!

on: aStream 
	^self new on: aStream!

save
	"ImageStream save."

	| encodingName fileName classCollection aStream |
	encodingName := #default.
	fileName := 'ImgStrm.st'.
	classCollection := self saveClasses.
	aStream := (fileName asFilename withEncoding: encodingName) writeStream.
	[Cursor write
		showWhile: 
			[| timeStamp |
			timeStamp := Date today shortPrintString , ' ' , Time now shortPrintString.
			aStream cr.
			aStream nextChunkPut: timeStamp printString.
			aStream cr; cr.
			(self comment isNil or: [self comment isEmpty])
				ifFalse: 
					[aStream nextChunkPut: self comment printString.
					aStream cr; cr].
			classCollection
				do: 
					[:aClass | 
					aStream nextChunkPut: aClass definition.
					aStream cr; cr].
			classCollection
				do: 
					[:aClass | 
					| sourceCodeStream |
					aStream nextPut: Character newPage.
					aStream cr.
					sourceCodeStream := SourceCodeStream on: aStream.
					aClass fileOutSourceOn: sourceCodeStream.
					aStream cr]]]
		valueNowOrOnUnwindDo: [aStream close].
	^classCollection!

saveClasses
	"ImageStream saveClasses."

	| patternCollection classCollection |
	patternCollection := #('*ImageStream*' '*Progress*').
	classCollection := Smalltalk organization superclassOrder: self category.
	classCollection := classCollection
				select: 
					[:aClass | 
					| string something |
					string := aClass name asString.
					something := patternCollection detect: [:it | it match: string]
								ifNone: [nil].
					something notNil].
	^classCollection , Progress saveClasses!

show: anImage 
	"ImageStream show: Image fromUser."

	| image extent window |
	(anImage isKindOf: OpaqueImage)
		ifTrue: [image := anImage]
		ifFalse: [image := CachedImage on: anImage].
	extent := 64 @ 64 max: (image extent min: Screen default bounds extent - 60 asPoint).
	window := ScheduledWindow new.
	window label: 'Image'.
	window minimumSize: extent.
	window component: image.
	window open.
	^anImage!

system
	^'Goodies'!

toClipboard: anImage 
	"ImageStream toClipboard: Image fromUser."

	| pixmap |
	pixmap := anImage asRetainedMedium.
	pixmap toClipboard.
	^anImage!

version
	^'003'! !
!ImageStream class categoriesFor: #assert:do:ensure:!controls!private! !
!ImageStream class categoriesFor: #colorPalette256!constants of palette!private! !
!ImageStream class categoriesFor: #copyright!copyright!private! !
!ImageStream class categoriesFor: #flushPalettes!constants of palette!private! !
!ImageStream class categoriesFor: #fromClipboard!accessing!private! !
!ImageStream class categoriesFor: #fromDisplay!accessing!private! !
!ImageStream class categoriesFor: #fromDisplay:!accessing!private! !
!ImageStream class categoriesFor: #fromUser!accessing!private! !
!ImageStream class categoriesFor: #grayPalette256!constants of palette!private! !
!ImageStream class categoriesFor: #imageKindTable!accessing!private! !
!ImageStream class categoriesFor: #imageStreamClassForFileName:!accessing!private! !
!ImageStream class categoriesFor: #initialize!class initialization!private! !
!ImageStream class categoriesFor: #install!class initialization!private! !
!ImageStream class categoriesFor: #on:!instance creation!private! !
!ImageStream class categoriesFor: #save!private!saving! !
!ImageStream class categoriesFor: #saveClasses!private!saving! !
!ImageStream class categoriesFor: #show:!private!viewing! !
!ImageStream class categoriesFor: #system!copyright!private! !
!ImageStream class categoriesFor: #toClipboard:!accessing!private! !
!ImageStream class categoriesFor: #version!copyright!private! !

MIMEMap guid: (GUID fromString: '{01619CA9-5B4F-48CB-852F-774E98DB12C3}')!
MIMEMap comment: ''!
!MIMEMap categoriesForClass!Unclassified! !
!MIMEMap methodsFor!

addType: aTypeString andExtension: anExtensionString
	| exts |
	exts := self mimeTypes at: aTypeString ifAbsentPut: [OrderedCollection new].
	(exts includes: anExtensionString) ifFalse: [exts add: anExtensionString].
	self fileExtensions at: anExtensionString ifAbsentPut: [aTypeString].!

extensionForType: aString
	"only first one if more than one ext exist for this mime type"
	| exts string |
	string := aString = 'image/pjpeg' ifTrue: ['image/jpeg'] ifFalse: [aString]. "wierd IE problem"
	string := aString = 'image/x-png' ifTrue: ['image/png'] ifFalse: [string]. "wierd IE problem"
	exts := self mimeTypes at: string asLowercase ifAbsent: [#()].
	^exts notEmpty ifTrue: [exts first] ifFalse: [nil]

"MIMEMap new extensionForType: 'image/jpeg'"!

extensionsForType: aString
	^self mimeTypes at: aString asLowercase ifAbsent: [#()].

"MIMEMap new extensionsForType: 'image/jpeg'"!

fileExtensions
	fileExtensions isNil ifTrue: [self initFileExtensions].
	^fileExtensions!

iconForType: aString
	"a name of icon to represent this content type, from WebStyle imgs-filetype icons"
	aString isNil ifTrue: [^#unknownSmallPng].
	'text/plain' = aString ifTrue: [^#txtSmallPng].
	'text/xml' = aString ifTrue: [^#xmlSmallPng].
	'application/pdf' = aString ifTrue: [^#pdfSmallPng].
	'application/msword' = aString ifTrue: [^#wordSmallPng].
	'application/rtf' = aString ifTrue: [^#wordSmallPng].
	'application/excel' = aString ifTrue: [^#excelSmallPng].
	'application/powerpoint' = aString ifTrue: [^#powerpointSmallPng].
	'application/zip' = aString ifTrue: [^#zipSmallPng].
	('image/*' match: aString) ifTrue: [^#imageSmallPng].
	('audio/*' match: aString) ifTrue: [^#multimediaSmallPng].
	('video/*' match: aString) ifTrue: [^#multimediaSmallPng].
	^#unknownSmallPng

"MIMEMap new iconForType: 'image/jpeg'"!

initFileExtensions
	fileExtensions := Dictionary new.!

initFromApacheMimeTypes
	"see class method. Only mime types, which have some extension defined, are set!! "
	| collection |
	collection := self class arrayFromApacheMimeTypes.
	collection do: [:col | 
		2 to: col size do: [:inx | self addType: col first andExtension: (col at: inx)] ]

"MIMEMap new"!

initialize
	self initFromApacheMimeTypes!

initMimeTypes
	mimeTypes := Dictionary new.!

mimeTypes
	mimeTypes isNil ifTrue: [self initMimeTypes].
	^mimeTypes!

removeType: aTypeString andExtension: anExtensionString
	| exts |
	exts := self mimeTypes at: aTypeString ifAbsent: [OrderedCollection new].
	(exts includes: anExtensionString) ifTrue: [exts remove: anExtensionString].
	exts isEmpty ifTrue: [self mimeTypes removeKey: aTypeString ifAbsent: [] ].
	self fileExtensions removeKey: anExtensionString ifAbsent: [].!

typeForExtension: aString
	| ext |
	ext := aString asLowercase copyWithout: $. .
	^self fileExtensions at: ext ifAbsent: [nil].

"MIMEMap new typeForExtension: 'jpg'"! !
!MIMEMap categoriesFor: #addType:andExtension:!adding-removing!private! !
!MIMEMap categoriesFor: #extensionForType:!accessing!private! !
!MIMEMap categoriesFor: #extensionsForType:!accessing!private! !
!MIMEMap categoriesFor: #fileExtensions!private! !
!MIMEMap categoriesFor: #iconForType:!accessing!private! !
!MIMEMap categoriesFor: #initFileExtensions!initialize-release!private! !
!MIMEMap categoriesFor: #initFromApacheMimeTypes!initialize-release!private! !
!MIMEMap categoriesFor: #initialize!initialize-release!private! !
!MIMEMap categoriesFor: #initMimeTypes!initialize-release!private! !
!MIMEMap categoriesFor: #mimeTypes!private! !
!MIMEMap categoriesFor: #removeType:andExtension:!adding-removing!private! !
!MIMEMap categoriesFor: #typeForExtension:!accessing!private! !

!MIMEMap class methodsFor!

apacheMimeTypes
	"from /etc/httpd/mime.types after Apache v1.3 is installed"

^'application/EDI-Consent
application/EDI-X12
application/EDIFACT
application/activemessage
application/andrew-inset	ez
application/applefile
application/atomicmail
application/cals-1840
application/commonground
application/cybercash
application/cu-seeme		csm cu
application/dca-rft
application/dec-dx
application/eshop
application/excel		xls
application/ghostview
application/hyperstudio
application/iges
application/mac-binhex40	hqx
application/mac-compactpro	cpt
application/macwriteii
application/marc
application/mathematica
application/msword		doc dot wrd
application/news-message-id
application/news-transmission
application/octet-stream	bin dms lha lzh exe class
application/oda			oda
application/pdf			pdf
application/pgp			pgp
application/pgp-encrypted
application/pgp-keys
application/pgp-signature	pgp
application/postscript		ai eps ps
application/powerpoint		ppt
application/remote-printing
application/rtf			rtf
application/slate
application/wita
application/wordperfect5.1	wp5
application/x-123		wk
application/x-Wingz		wz
application/x-bcpio		bcpio
application/x-bzip2		bz2
application/x-cdlink		vcd
application/x-chess-pgn		pgn
application/x-compress		z Z
application/x-cpio		cpio
application/x-csh		csh
application/x-debian-package	deb
application/x-director		dcr dir dxr
application/x-dvi		dvi
application/x-gtar		gtar tgz
application/x-gunzip		gz
application/x-gzip		gz
application/x-hdf		hdf
application/x-httpd-php		phtml pht php
application/x-javascript	js
application/x-kword		kwd kwt
application/x-kspread		ksp
application/x-kpresenter	kpr kpt
application/x-kchart		chrt
application/x-koan		skp skd skt skm
application/x-latex		latex
application/x-maker		frm maker frame fm fb book fbdoc
application/x-mif		mif
application/x-msdos-program	com exe bat
application/x-netcdf		nc cdf
application/x-ns-proxy-autoconfig	pac
application/x-perl		pl pm
application/x-rad		rad
application/x-rpm		rpm spm
application/x-sh		sh
application/x-shar		shar
application/x-shockwave-flash	swf
application/x-stuffit		sit
application/x-sv4cpio		sv4cpio
application/x-sv4crc		sv4crc
application/x-tar		tar
application/x-tcl		tcl
application/x-tex		tex
application/x-texinfo		texinfo texi
application/x-troff		t tr roff
application/x-troff-man		man
application/x-troff-me		me
application/x-troff-ms		ms
application/x-ustar		ustar
application/x-wais-source	src
application/zip			zip
audio/basic			au snd
audio/midi			mid midi kar
audio/mpeg			mpga mp2 mp3
audio/x-aiff			aif aifc aiff
audio/x-realaudio		ra
audio/x-wav			wav
chemical/x-pdb			pdb xyz
image/gif			gif
image/ief			ief
image/jpeg			jpeg jpg jpe
image/png			png
image/tiff			tiff tif
image/x-cmu-raster		ras
image/x-portable-anymap		pnm
image/x-portable-bitmap		pbm
image/x-portable-graymap	pgm
image/x-portable-pixmap		ppm
image/x-rgb			rgb
image/x-xbitmap			xbm
image/x-xpixmap			xpm
image/x-xwindowdump		xwd
message/external-body
message/news
message/partial
message/rfc822
model/iges			igs iges
model/mesh			msh mesh silo
model/vrml			wrl vrml
multipart/alternative
multipart/appledouble
multipart/digest
multipart/mixed
multipart/parallel
text/css			css
text/html			html htm
text/plain			asc txt c cc h hh cpp hpp
text/richtext			rtx
text/rtf			rtf
text/sgml			sgml sgm
text/tab-separated-values	tsv
text/x-setext			etx
text/x-vCalendar		vcs
text/x-vCard			vcf
text/xml			xml dtd
video/dl			dl
video/fli			fli
video/gl			gl
video/mpeg			mp2 mpe mpeg mpg
video/quicktime			qt mov
video/x-msvideo			avi
video/x-sgi-movie		movie
x-conference/x-cooltalk		ice
x-world/x-vrml			wrl vrml
audio/x-pn-realaudio rmm ram
audio/vnd.rn-realaudio ra
application/smil smi smil
text/vnd.rn-realtext rt
video/vnd.rn-realvideo rv
image/vnd.rn-realflash rf swf
application/x-shockwave-flash2-preview rf swf
application/sdp sdp
application/x-sdp sdp
application/vnd.rn-realmedia rm
image/vnd.rn-realpix rp
'!

arrayFromApacheMimeTypes
	| collection stream |
	collection:= OrderedCollection new.
	stream := ReadStream on: self apacheMimeTypes.
	[stream atEnd] whileFalse:
		[ | col line word |
		col := OrderedCollection new.
		line := (stream upTo: Character cr) readStream.
		[line atEnd] whileFalse: [word := line upToSeparator. word notEmpty ifTrue: [col add: word] ].
		collection add: col].
	^collection

"MIMEMap arrayFromApacheMimeTypes"!

default
	^AIDASite default mimeMap!

new
	^super new initialize! !
!MIMEMap class categoriesFor: #apacheMimeTypes!accessing!private! !
!MIMEMap class categoriesFor: #arrayFromApacheMimeTypes!accessing!private! !
!MIMEMap class categoriesFor: #default!accessing!private! !
!MIMEMap class categoriesFor: #new!instance creation!private! !

ProtocolAdaptor guid: (GUID fromString: '{9499A8E9-6A9F-4237-80F3-F7FF32EEBA43}')!
ProtocolAdaptor comment: ''!
!ProtocolAdaptor categoriesForClass!Unclassified! !
!ProtocolAdaptor methodsFor!

subject
	^subject!

subject: anObject
	subject := anObject!

value
!

value: aValue
! !
!ProtocolAdaptor categoriesFor: #subject!accessing!public! !
!ProtocolAdaptor categoriesFor: #subject:!accessing!public! !
!ProtocolAdaptor categoriesFor: #value!accessing!public! !
!ProtocolAdaptor categoriesFor: #value:!accessing!public! !

ScheduledEvent guid: (GUID fromString: '{84CAF9B2-4B59-4460-8049-C473E12DF7BE}')!
ScheduledEvent comment: ''!
!ScheduledEvent categoriesForClass!Unclassified! !
!ScheduledEvent methodsFor!

at: aTimestamp runBlock: aBlockClosure
	self timestamp: aTimestamp.
	self block: aBlockClosure.
	self setPeriodSingle!

block
	"a block to be run at event"
	^block!

block: anObject
	block := anObject!

everyDayAt: aTimeOrHour  runBlock: aBlock
	| time |
	time := aTimeOrHour class == Time 
		ifTrue: [aTimeOrHour] ifFalse: [Time fromSeconds: aTimeOrHour*60*60].
	self timestamp: (Timestamp fromDate: Date today andTime: time).
	self block: aBlock.
	self periodType: #day value: time!

everyHourAt: aMinuteNumber runBlock: aBlock
	self timestamp: (Timestamp fromDate: Date today andTime: 
		(Time fromSeconds: (Time now hours * 3600) + (aMinuteNumber * 60))).
	self block: aBlock.
	self periodType: #hour value: aMinuteNumber!

everyMinuteAt: aSecondNumber runBlock: aBlock
	self timestamp: (Timestamp fromDate: Date today andTime: 
		(Time fromSeconds: (Time now hours * 3600) + (Time now minutes * 60) + aSecondNumber)).
	self block: aBlock.
	self periodType: #minute value: aSecondNumber!

isDayPeriod
	^self period notNil and: [self period key = #day]!

isHourPeriod
	^self period notNil and: [self period key = #hour]!

isMinutePeriod
	^self period notNil and: [self period key = #minute]!

isPeriodic
	^(self period isNil or: [self period key = #single]) not!

method
	"a method to be called on an object at a scheduled time"
	^method!

method: aSymbol
	"a method to be called on an object at a scheduled time"
	method := aSymbol!

object
	"object on which a method wil be called at scheduled time"
	^object!

object: anObject
	object := anObject!

parent
	^parent!

parent: anObject
	parent := anObject!

period
	"asociation with type and parameter: #single>nil #day>aTime, ... "
	^period!

periodType: aSymbol value: anObject
	period := Association key: aSymbol value: anObject!

printString
	^'aScheduledEvent 
	timestamp: ', self timestamp printSloString, ':', self timestamp second printString, '
	period: ', self period key printString, ' ', self period value printString, '
	method: ', self method printString, '
	object: ', self object printString, '
	block: ', self block printString!

reschedule
	"calculate and set a new time to run, according to a period"
	self isDayPeriod ifTrue: 
		[self timestamp: (Timestamp fromSeconds: (self timestamp asSeconds + (60*60*24)))].
	self isHourPeriod ifTrue: 
		[self timestamp: (Timestamp fromSeconds: (self timestamp asSeconds + (60*60)))].
	self isMinutePeriod ifTrue: 
		[self timestamp: (Timestamp fromSeconds: (self timestamp asSeconds + 60))].
	self parent scheduleEvent: self.!

run
	"run this event"
	self block notNil 
		ifTrue: [ [self block value] forkAt: self runPriority]
		ifFalse: [ [self object perform: self method] forkAt: self runPriority].
	self isPeriodic ifTrue: [self reschedule]!

runPriority
	^Processor userBackgroundPriority!

setPeriodSingle
	self periodType: #single value: nil!

timestamp
	"when this event must occur"
	^timestamp!

timestamp: aTimestamp
	timestamp := aTimestamp! !
!ScheduledEvent categoriesFor: #at:runBlock:!private!setup! !
!ScheduledEvent categoriesFor: #block!accessing!private! !
!ScheduledEvent categoriesFor: #block:!private! !
!ScheduledEvent categoriesFor: #everyDayAt:runBlock:!private!setup! !
!ScheduledEvent categoriesFor: #everyHourAt:runBlock:!private!setup! !
!ScheduledEvent categoriesFor: #everyMinuteAt:runBlock:!private!setup! !
!ScheduledEvent categoriesFor: #isDayPeriod!private!testing! !
!ScheduledEvent categoriesFor: #isHourPeriod!private!testing! !
!ScheduledEvent categoriesFor: #isMinutePeriod!private!testing! !
!ScheduledEvent categoriesFor: #isPeriodic!private!testing! !
!ScheduledEvent categoriesFor: #method!accessing!private! !
!ScheduledEvent categoriesFor: #method:!private! !
!ScheduledEvent categoriesFor: #object!accessing!private! !
!ScheduledEvent categoriesFor: #object:!private! !
!ScheduledEvent categoriesFor: #parent!accessing!private! !
!ScheduledEvent categoriesFor: #parent:!private! !
!ScheduledEvent categoriesFor: #period!private!private-periods! !
!ScheduledEvent categoriesFor: #periodType:value:!private!private-periods! !
!ScheduledEvent categoriesFor: #printString!private! !
!ScheduledEvent categoriesFor: #reschedule!private! !
!ScheduledEvent categoriesFor: #run!private!running! !
!ScheduledEvent categoriesFor: #runPriority!private!running! !
!ScheduledEvent categoriesFor: #setPeriodSingle!private!private-periods! !
!ScheduledEvent categoriesFor: #timestamp!accessing!private! !
!ScheduledEvent categoriesFor: #timestamp:!private! !

!ScheduledEvent class methodsFor!

newOn: aScheduler
	^super new parent: aScheduler! !
!ScheduledEvent class categoriesFor: #newOn:!instance creation!private! !

Scheduler guid: (GUID fromString: '{1DF82A96-F1B3-4F80-A6A9-D0BB841857A3}')!
Scheduler comment: 'Scheduler is a service for running scheduled events. Events can be single or periodic (daily, hourly, ...).
When event is triggered, its block is executed in a separate low priority process. Scheduler time resolution is 1 second. 

Example of periodic event:
	self site scheduler everyHourAt: 30 "minutes" runBlock: [Trascript show: ''half a hour!!].

Instance Variables:
	site		<anAIDASite>	
	queue	<OrderedCollection>	queue of events, waiting for execution
	loop	<Process>		loop process, every second looks into queue to run an event
	lock		<RecursionLock> to protect queue operations

'!
!Scheduler categoriesForClass!Unclassified! !
!Scheduler methodsFor!

at: aTimestamp callMethod: aSymbol of: anObject
	| event |
	event := ScheduledEvent newOn: self.
	event at: aTimestamp callMethod: aSymbol of: anObject.
	self scheduleEvent: event.
	^event!

at: aTimestamp runBlock: aBlock
	| event |
	event := ScheduledEvent newOn: self.
	event at: aTimestamp runBlock: aBlock.
	self scheduleEvent: event.
	^event!

considerMissedEvents
	"events which we miss to run, eg. if scheduler didn't run for a while"
	self removeMissedEvents "and nothing more, for now"!

everyDayAt: aTimeOrHour runBlock: aBlock
	| event |
	event := ScheduledEvent newOn: self.
	event everyDayAt: aTimeOrHour runBlock: aBlock.
	self scheduleEvent: event.
	^event!

everyHourAt: aMinuteNumber  runBlock: aBlock
	| event |
	event := ScheduledEvent newOn: self.
	event everyHourAt: aMinuteNumber  runBlock: aBlock.
	self scheduleEvent: event.
	^event!

everyMinuteAt: aSecondNumber callMethod: aSymbol of: anObject
	| event |
	event := ScheduledEvent newOn: self.
	event everyMinuteAt: aSecondNumber callMethod: aSymbol of: anObject.
	self scheduleEvent: event.
	^event!

everyMinuteAt: aSecondNumber  runBlock: aBlock
	| event |
	event := ScheduledEvent newOn: self.
	event everyMinuteAt: aSecondNumber  runBlock: aBlock.
	self scheduleEvent: event.
	^event!

everyMonthday: aDayNumber at: aTime  runBlock: aBlock!

everyWeekday: aDaySymbol at: aTime  runBlock: aBlock!

initialize!

initQueue
	queue := OrderedCollection new.!

insertToQueueEvent: aScheduledEvent
	self lock critical:
		[self queue isEmpty ifTrue: [^self queue add: aScheduledEvent].
		aScheduledEvent timestamp >= self queue last timestamp 
			ifTrue: [^self queue add: aScheduledEvent].
		aScheduledEvent timestamp < self queue first timestamp 
			ifTrue: [^self queue addFirst: aScheduledEvent].
		self queue size to: 1 by: -1 do: [:inx |
			aScheduledEvent timestamp >= (queue at: inx) timestamp ifTrue: 
				[^self queue add: aScheduledEvent beforeIndex: inx+1] ]
		]!

isLoopRunning
	^self loop notNil!

lock
	lock isNil ifTrue: [lock := RecursionLock new].
	^lock!

loop
	^loop!

loop: aProcess
	loop := aProcess!

printString
	^'aScheduler on site: ', (self site notNil ifTrue: [self site name] ifFalse: [''])!

queue
	"queue of events next one to run on first place"
	queue isNil ifTrue: [self initQueue].
	^queue!

removeMissedEvents
	| now event |
	self lock critical:
		[self queue isEmpty ifTrue: [^nil].
		now := Timestamp now asSeconds.
		[now > self queue first timestamp asSeconds] whileTrue:
			[event := self queue first.
			self queue removeFirst.
			event isPeriodic ifTrue: [event reschedule].
			self queue isEmpty ifTrue: [^nil] ]
		]!

scheduleEvent: aScheduledEvent
	self insertToQueueEvent: aScheduledEvent.!

schedulerPriority
	^Processor userInterruptPriority!

site
	^site!

site: anAIDASite
	site := anAIDASite!

start
	self considerMissedEvents.
	self startLoop!

startLoop
	self isLoopRunning ifTrue: [self stopLoop].
	self loop: 
		([ [true] whileTrue: 
			[| event now |
			self lock critical: 
				[self queue notEmpty ifTrue:
					[event := self queue first. now := Timestamp now asSeconds.
				 	now = event timestamp asSeconds
						ifTrue:  [event run. self queue removeFirst]
						ifFalse: [now > event timestamp asSeconds  ifTrue: [self removeMissedEvents]] ]].
			(Delay forSeconds: 1) wait]
		] forkAt: self schedulerPriority)!

stop
	self stopLoop!

stopLoop
	self loop notNil ifTrue: [self loop terminate. self loop: nil].! !
!Scheduler categoriesFor: #at:callMethod:of:!events-single!private! !
!Scheduler categoriesFor: #at:runBlock:!events-single!private! !
!Scheduler categoriesFor: #considerMissedEvents!private! !
!Scheduler categoriesFor: #everyDayAt:runBlock:!events-periodic!private! !
!Scheduler categoriesFor: #everyHourAt:runBlock:!events-periodic!private! !
!Scheduler categoriesFor: #everyMinuteAt:callMethod:of:!events-periodic!private! !
!Scheduler categoriesFor: #everyMinuteAt:runBlock:!events-periodic!private! !
!Scheduler categoriesFor: #everyMonthday:at:runBlock:!events-periodic!private! !
!Scheduler categoriesFor: #everyWeekday:at:runBlock:!events-periodic!private! !
!Scheduler categoriesFor: #initialize!initialize-release!private! !
!Scheduler categoriesFor: #initQueue!initialize-release!private! !
!Scheduler categoriesFor: #insertToQueueEvent:!private! !
!Scheduler categoriesFor: #isLoopRunning!private! !
!Scheduler categoriesFor: #lock!private! !
!Scheduler categoriesFor: #loop!private! !
!Scheduler categoriesFor: #loop:!private! !
!Scheduler categoriesFor: #printString!private! !
!Scheduler categoriesFor: #queue!private! !
!Scheduler categoriesFor: #removeMissedEvents!private! !
!Scheduler categoriesFor: #scheduleEvent:!private! !
!Scheduler categoriesFor: #schedulerPriority!private! !
!Scheduler categoriesFor: #site!private! !
!Scheduler categoriesFor: #site:!private! !
!Scheduler categoriesFor: #start!private!start/stop! !
!Scheduler categoriesFor: #startLoop!private! !
!Scheduler categoriesFor: #stop!private!start/stop! !
!Scheduler categoriesFor: #stopLoop!private! !

!Scheduler class methodsFor!

newOn: anAIDASite
	^super new initialize; site: anAIDASite! !
!Scheduler class categoriesFor: #newOn:!instance creation!private! !

URLResolver guid: (GUID fromString: '{0B4D55A5-6D47-4A81-9B17-C014D1A3C6B4}')!
URLResolver comment: ''!
!URLResolver categoriesForClass!Unclassified! !
!URLResolver methodsFor!

addObject: anObject withURL: aString
	"add an object if not already exist and add url to the collection of urls for that object.
	If aString url point to some other object already, then remove url from that other object"
	"warning, if web elements (such as web apps) will be registered"
	self isWebElement: anObject.
	anObject isNil ifTrue: [^nil]. "do not add nil objects!!"
	self site critical: 
		[(self allWebPages at: anObject ifAbsentPut: [OrderedCollection new])
				add: aString asLowercase.
		(self allURLLinks includesKey: aString asLowercase) ifTrue:
			[(self allWebPages at: (self allURLLinks at: aString asLowercase)	
				ifAbsentPut: [OrderedCollection new])
					remove: aString asLowercase ifAbsent: [] ].
		self allURLLinks at: aString asLowercase put: anObject ].!

allHTMLPagesSize
	"sums sizes of all static pages"

	| fname sum |
	sum := 0.
	self allHTMLPageUrls do: [:url | 
		fname := self site homeDirectory, url.
		fname := fname copyReplaceAll: '/' with: '\'.
		fname asFilename exists 
			ifTrue: [sum := sum + fname asFilename fileSize] ].
	^sum

"URLResolver default allHTMLPagesSize"!

allHTMLPageUrls
	"find all .htm and .html pages in directory hierarchy starting at aWebServer homeDirectory.
	return as collection of relative url links"

	^self allHTMLPageUrlsIn: self site homeDirectory.

"URLResolver default allHTMLPageUrls"!

allHTMLPageUrlsIn: aDirectoryString
	"find all .htm and .html pages in directory hierarchy starting at a specified directory and all 	subdirectories.	Return as collection of relative url links"

	| collection dir |
	dir := aDirectoryString.
	dir last ~= $\ ifTrue: [dir := dir, '\'].
	dir asFilename exists ifFalse: [^#()].
	collection := OrderedCollection new.
	aDirectoryString asFilename directoryContents do: [:each | 
		(dir, each) asFilename isDirectory
			ifTrue: [collection addAll: (self allHTMLPageUrlsIn: (dir, each))]
			ifFalse: 
				[('.htm' match: each asFilename extension) ifTrue:
					[collection add: (self urlForFile: each asString directory: aDirectoryString)] ]
		].
	^collection.

"URLResolver default allHTMLPageUrlsIn: 'h:\wwwroot\planid' "!

allPagesAndCounts

	"return total counts for all objects that have counters, most counted first"

	| collection |
	collection := OrderedCollection new.
	self counters keysAndValuesDo: [:object :counter |
		collection add: (Array
			with: object
			with: counter total)].
	^SortedCollection
		withAll: collection
		sortBlock: [:a :b | (a at: 2) > (b at: 2)]

"URLResolver default allPagesAndCounts"!

allURLLinks
	"return a dictionary with url as key and reference to an object with that url as value"
	^allURLLinks!

allUrlsAndCounters
	"return copies of all counters as dictionary with url as key"
	| dictionary |
	dictionary := Dictionary new.
	self counters keysAndValuesDo: [:object :counter |
		dictionary 
			at: (self halfUrlFor: object)
			put: counter deepCopy].
	^dictionary

"URLResolver default allUrlsAndCounters"
"
(BinaryObjectStorage onNew: 'counters.boss' asFilename writeStream)
	nextPut: URLResolver default allUrlsAndCounters;
	close
"!

allWebPages
	" return a dictionary with object reference as key and one on more urls for that object as value.
	first  is default one, when urls are dinamicaly generated"
	^allWebPages!

autoUrlFor: anObject
	"use prefered url if possible. If that url already exist, add -a, -b, ... to url and repeat"
	| url extension lastPoint |
	url := anObject preferedUrl. url isNil ifTrue: [^self randomUrlFor: anObject].
	[(self ooRefFromURL: url) notNil] whileTrue: "already exist"
		[lastPoint := url lastIndexOf: $. . lastPoint = 0 ifTrue: [lastPoint := url size+1].
		extension := url copyFrom: lastPoint to: url size.
		url := url copyReplaceAll: extension with: ''. 
		url isEmpty ifTrue:  [^self randomUrlFor: anObject].
		(url size > 1 and: [(url at: url size-1) = $-]) "already have an extension char!!"
			ifTrue: 
				[url last = $z ifTrue: [^self randomUrlFor: anObject]. "only to $z, then back to random!!"
				url := (url copyFrom: 1 to: url size-1), (String with: (url last asInteger + 1) asCharacter)]
			ifFalse: [url := url, '-a'].
		url := url, extension].
	^url

"URLResolver default halfUrlFor: (Document new id: 'SOP-0111-02').
URLResolver default autoUrlFor: (Document new id: 'SOP-0111-02')"!

changeToPreferedURL: anObject
 	"remove all existing urls and make this as only one"
	"BEWARE, all ols urls will be erased, url references can be breaked!! "
	anObject preferedUrl isNil ifTrue: [^nil].
	self removeObject: anObject.
	self defaultURL: anObject preferedUrl forObject: anObject.!

changeToURL: aString forObject: anObject
 	"remove all existing urls and make this as only one"
	"BEWARE, all ols urls will be erased, url references can be breaked!! "
	self removeObject: anObject.
	self defaultURL: aString forObject: anObject.!

correctUrlEncoding
	"make sure all urls are decodedHTTP, without %20 etc"
	self allURLLinks keys do: [:key | (key decodedHTTP ~= key) 
		ifTrue: [self allURLLinks at: key decodedHTTP put: (self allURLLinks at: key). 
			self allURLLinks removeKey: key] ].
	self allWebPages values do: [:coll |
	coll copy do: [:each | (each decodedHTTP ~= each) 
		ifTrue: [coll at: (coll indexOf: each) put: each decodedHTTP] ] ].

"
self allURLLinks keys select: [:key | (key decodedHTTP ~= key)].
self allWebPages associations select: [:assoc |
	assoc value contains: [:each | (each decodedHTTP ~= each)] ].
"!

counterFor: anObject
	anObject isNil ifTrue: [^nil].
	(self counters includesKey: anObject)
		ifFalse: [self resetCounterFor: anObject].
	^self counters at: anObject!

counterForUrl: anUrlString

	"return a counter for object with specified url. Nil if not exist"

	| object  |
	object := self ooRefFromURL: anUrlString.
	object isNil ifTrue: [^nil].
	^self counterFor: object.

"URLResolver default counterForUrl: '/osn/g_l-vse.htm'"
"WebServer default totalCounter"
"WebServer default pagesCounter"!

counters

	"dictionary of web counters for every object, registered in URLResolver"

	counters isNil ifTrue: [self initCounters].
	^counters.!

defaultURL: aString forObject: anObject
	"set url as default url for that object. This url is then used in dynamic url creation. If an object 
	does not already exist, then create a new entry first"
	| urls first defInx |
	self addObject: anObject withURL: aString.  "just in case object is new one"
	"swap old default with new default url on a first place in collection"
	self site critical: 
		[urls := allWebPages at: anObject.
		first := urls first.
		defInx := urls indexOf: aString asLowercase.
		urls at: 1 put: (urls at: defInx).
		urls at: defInx put: first].!

existURL: aString
	"return true if URL has connection to some object"
	^self allURLLinks includesKey: aString asLowercase!

fileProxyForURL: aString
	" Try to find a html file for a specified URL and make aHTMLFileProxy. 
	Returns nil if such a file does not exist. Index content in default WebIndex"
	| pcFileSystem add fname proxy |
	pcFileSystem := true. "Win" "(IOAccessor defaultClass = PCIOAccessor)."
	aString isEmpty ifTrue: [^nil].
	(aString last = $/) ifTrue: [add := 'index.htm'] ifFalse: [add := ''].
	fname := self site homeDirectory, aString, add.
	pcFileSystem ifTrue: [fname := fname copyReplaceAll: '/' with: '\'].
	fname asFilename exists ifFalse:
		[fname := fname, 'l'.
		fname asFilename exists ifFalse: [^nil] ].
	proxy := FileProxy from: fname onSite: self site.
	proxy indexContent.
	^proxy!

fullUrlFor: anObject on: aSession
	"find or make a path for anObject and compose full url together with server address and 
	query string, eg: http://www.eranova.si/welcome.html?view=brief"
	^self 
		fullUrlFromPath: (self halfUrlFor: anObject)
		andParms: (aSession notNil ifTrue: [aSession parms] ifFalse: [#()])
		on: aSession!

fullUrlFromPath: aPathString andParms: aParmsDictionary on: aSession
	"compose full url: server address, document path and additional parameters in query string, 
	for instance: http://www.eranova.si/welcome.html?view=brief"
	| url |
	url := self urlFromHalfUrl: aPathString on: aSession.
	^self halfUrlFromPath: url andParms: aParmsDictionary on: aSession. "not very nice, i know ..."
	
"
| parms |
parms := Dictionary new.
parms at: 'view' put: 'brief'. parms at: 'id' put: '12345'. 
URLResolver default fullUrlFromPath: '/dzs/panorama.html' andParms: parms on: WebSession new
"!

halfUrlFor: anObject
	"finds or composes an URL reference to that object . If the URL is new one, then it is written to both dictionaries for later lookup. If resolution is unsuccessfull then returns nil. If anObject dont have an url yet, url part for them is automatically generated, for example:  /objecto1638948.html"
	| newUrl urls |
	urls := (self allWebPages at: anObject ifAbsent: [
	      newUrl := ((anObject isKindOf: WebPage)  and: [anObject name notNil] )
			ifTrue: ['/', anObject name asLowercase,'.html']			
			ifFalse: [self autoUrlFor: anObject].
		self addObject: anObject withURL: newUrl.
		OrderedCollection with: newUrl]).
	"just in case object has an empty collection of urls"
	(urls isNil or: [urls isEmpty]) ifTrue: 
		[self removeObject: anObject. ^self halfUrlFor: anObject].
	^urls at: 1.!

halfUrlFromPath: aPathString andParms: aParmsDictionary on: aSession
	"compose half url: /document path and additional parameters in query string, for instance: 	/welcome.html?view=brief"
	| url parmsString newValue |
	url := aPathString.
	aParmsDictionary size > 0 ifTrue:
		[parmsString := ''.
		aParmsDictionary keysAndValuesDo: [:name :value |
			(value isKindOf: Set) ifTrue:[newValue := value asArray at: 1]ifFalse:[newValue := value].
			parmsString := parmsString, 
				(AIDASite convertToWebString: name asString), '=', 
				(AIDASite convertToWebString: newValue asString), '&'].  "value"
		url := url, '?', (parmsString copyFrom: 1 to: (parmsString size - 1))].
	^url

"
| parms |
parms := Dictionary new.
parms at: 'view' put: 'brief'. parms at: 'id' put: '12345'. 
URLResolver default halfUrlFromPath: '/dzs/panorama.html' andParms: parms on: WebSession new
"!

incCounterFor: anObject
	"increment a web counter for that object. Only text/html object are counted
	Don't count temporary objects"
	(anObject contentType = 'text/html') ifFalse: [^nil].
	self site critical: 
		[(self counters includesKey: anObject) ifFalse: [self resetCounterFor: anObject].
		(self counters at: anObject) incCounter.
		"self totalCounter incCounter   **aWebServer already counts!! "]!

initCounters
	"init a counters dictionary and open a new counter for each already registered object"
	counters := Dictionary new. 
	self allWebPages keys do: [:object | self resetCounterFor: object].!

initialize
	self initWebPages.
	self initURLLinks.
	self initCounters.!

initURLLinks
	allURLLinks := Dictionary new.!

initWebPages
	allWebPages := IdentityDictionary new.!

isRootURL: aString

	^aString = '/'!

isWebElement: anObject


	" test if anObject is a web element, such as web app and write warning to the transcript"
	
	(anObject isKindOf: WebElement) ifTrue:
		[Transcript cr; show: '*** WARNING: URLResolver detected a ', 
		anObject class printString, '  will be registered ***'; cr.

		"to detect from where this request comes"
		"self halt"
		].!

methodImageForURL: aString 
	"maybe a method image can be done from current WebStyle?"
	|  name selector |
	('/img/*' match: aString) ifFalse: [^nil].
	name := aString readStream upTo: $/ ; upTo: $/; upTo: $. .
	selector := self site style class allSelectors 
		detect: [:each | each asString asLowercase = name] ifNone: [^nil].
	^WebMethodImage fromMethod: selector on: self site style contentType: 'image/gif' site: self site

"URLResolver default methodImageForURL: '/img/eranovalogogif.gif' "!

ooRefFromURL: aString
	" finds a reference to WebPage, specified in a URL string. If not yet known, try to 
	find it as a html file. if not found, search methods in current WebStyle too.."
	| object |
	^self allURLLinks at: aString asLowercase ifAbsent: 
		[(self isRootURL: aString) ifTrue: [^self site defaultUserService].
		object := self fileProxyForURL: aString.
		object isNil ifTrue: [object := self methodImageForURL: aString].
		object notNil ifTrue: [self addObject: object withURL: aString].
		^object].
	

"URLResolver default ooRefFromURL: '/osn/g_l-vse.htm' "!

randomGen
	randomGen isNil ifTrue: [self randomGen: Random new].
	^randomGen!

randomGen: anObject
	randomGen := anObject!

randomUrlFor: anObject
	| number ext url |
	number := (self randomGen next * 10000000) asInteger.
	ext := self site mimeMap extensionForType: anObject contentType.
	ext isNil ifTrue: [ext := 'html'].
	url := '/object/o', number printString, '.', ext.
	^(self ooRefFromURL: url) isNil  "avoid duplicates!!"
		ifTrue: [url]
		ifFalse: [self randomUrlFor: anObject]!

refreshAllHTMLPages
	""

	| count |
	count := 1.
	self allWebPages keys do: [:object |
		(object isKindOf: FileProxy) ifTrue:	 
			[count \\ 10 = 0 ifTrue: [Transcript cr; show: count printString].
			object refreshContent.
			count := count + 1] ].

"URLResolver default refreshAllHTMLPages"!

registerAllHTMLPages
	"if not already, then register all static html pages in directory hierarchy starting
	at aWebServer homeDirectory. Opan also counters for them"

	| count proxy |
	count := 1.
	self allHTMLPageUrls do: [:url | 
		count \\ 10 = 0 ifTrue: [Transcript cr; show: count printString].
		proxy := self ooRefFromURL: url.
		self counterFor: proxy.
		count := count + 1].

"URLResolver default registerAllHTMLPages"!

reindexAllObjects

	"all text/html objects are reindexed"
	self allWebPages keysDo: [:object |
		(object contentType = 'text/html') ifTrue:
			[self site index indexObject: object] ]

"URLResolver default reindexAllObjects"!

reindexNonIndexedObjects
	"all text/html objects are reindexed"
	self allWebPages keysDo: [:object |
		(object contentType = 'text/html') ifTrue:
			[(self site index indexedObjects includesKey: object) ifFalse:
				[self site index indexObject: object] ] ]

"URLResolver default reindexNonIndexedObjects"!

releaseAllHTMLPages

	self allWebPages keys do: [:obj |
		(obj isKindOf: FileProxy) ifTrue:
	 		[obj releaseContent] ]

"URLResolver default releaseAllHTMLPages"!

releaseAllImages

	self allWebPages keys do: [:obj |
		((obj isKindOf: FileProxy) and: ['*image*' match: obj contentType])
			ifTrue: [obj releaseContent] ]

"URLResolver default releaseAllImages"!

releaseAllStaticPages

	self allWebPages keysDo: [:object | 
		(object isKindOf: FileProxy) ifTrue: [object releaseContent] ]

"URLResolver default releaseAllStaticPages"!

removeCounterFor: anObject


	(self counters includesKey: anObject)
		ifTrue: [self counters removeKey: anObject]!

removeNonHTMLCounters

	self counters keys do: [:object |
		object contentType ~= 'text/html' ifTrue:
			[self removeCounterFor: object] ]

"URLResolver default removeNonHTMLCounters"!

removeObject: anObject
	"remove object and all its URLs. Returns true if object existed and false if not. 
	Remove also its web counter"
	| urls |
	self site critical:
		[urls := (self allWebPages at: anObject ifAbsent: [^nil]).
		self allWebPages removeKey: anObject.
		urls notNil ifTrue: [urls do: [: each | self allURLLinks removeKey: each ifAbsent: [] ] ].
		self counters removeKey: anObject ifAbsent: [] ].
	^true!

removeObjectsOfClass: aClass
	AIDARoot critical:
		[self allWebPages keys do: [:object | object class = aClass ifTrue: [self removeObject: object]] ].

"URLResolver default removeObjectsOfClass: WebMethodImage"
"URLResolver default allWebPages size 10934"!

removeObjectsOfClassNamed: aString
	"good for removing Obsolete classes!!"
	AIDARoot critical:
		[self allWebPages keys do: [:object | 
			object class name= aString ifTrue: [self removeObject: object]] ].

"URLResolver default removeObjectsOfClassNamed: WebMethodImage"
"URLResolver default allWebPages size 10934"!

removeObjectWithURL: aString

"remove object and all its URLs. Returns true if object existed and false if not"

	| object |
	object := allURLLinks at: aString asLowercase ifAbsent: [^false].
	^self removeObject: object.!

removeURL: aString
	"remove this URL and also object, if this url was the last one pointed to object Returns 
	true if url existed and false if not. Also remove web counter"
	| object |
	self site critical:
		[object := (self allURLLinks at: aString asLowercase ifAbsent: [^nil]).
		(self allWebPages at: object) remove: aString asLowercase ifAbsent: [].
		(self allWebPages at: object) isEmpty ifTrue: [self allWebPages removeKey: object]. 
		self allURLLinks removeKey: aString asLowercase.
		self counters removeKey: object ifAbsent: [] ].
	^true!

resetAllCounters

	self counters values do: [:each | each reset].

"URLResolver default resetAllCounters"!

resetCounterFor: anObject
	"reset counters for specified object. If not yet exist, initialize it first"
	anObject isNil ifTrue: [^nil].
	self site critical:
		[(self counters includesKey: anObject) ifFalse: 
			[self counters at: anObject put: WebCounter new].
		(self counters at: anObject) reset]!

scanForURLsFrom: aWebPage

"start looking for all WebLinks in pages starting from aWebPage and converting them to the URL links in instance variables allWebPages and allURLLinks."!

site
	"a parent site with this url resolver"
	^site!

site: anAIDASite
	site := anAIDASite.!

urlFor: anObject on: aSession

	"finds or composes an URL reference to the given WebPage or any object capable to represent itself as a WebPage. If the URL is new one, then it is written to both dictionaries for later lookup. If resolution is unsuccessfull then returns nil. The second argument is a WebPage where an OO link to resolve exist. If this argument is nil, then an URL must already exist, eg. automatic composition is not possible.
If anObject is not WebPge or has no name, then the url part for them is automatically generated, for example: http://pu.tris-a.si/cgi-bin/stweb?/demo/overview/o1638948.htm"

	^self urlFromHalfUrl: (self halfUrlFor: anObject on: aSession) on: aSession!

urlForFile: aFilenameString directory: aDirectoryString

	| path dir |
	dir := aDirectoryString.
	dir last ~= $\ ifTrue: [dir := dir, '\'].
	path := dir, aFilenameString.
	path := path copyReplaceAll: self site homeDirectory with: ''.
	^path copyReplaceAll: '\' with: '/'

"URLResolver default urlForFile: 'index.htm' directory: 'h:\wwwroot\planid\osn' "!

urlFromHalfUrl: aString on: aSession
	| portString protocolString |
	portString := (aSession notNil and: [aSession isEncrypted]) 
		ifFalse: [(self site port = 80) ifTrue: [''] ifFalse: [':', self site port printString] ]
		ifTrue: [(self site sslPort = 443) ifTrue: [''] ifFalse: [':', self site sslPort printString] ].
	protocolString := (aSession notNil and: [aSession isEncrypted])  
		ifFalse: ['http://'] ifTrue: ['https://'].
	^protocolString, self site address asLowercase, portString, aString.! !
!URLResolver categoriesFor: #addObject:withURL:!adding - removing!private! !
!URLResolver categoriesFor: #allHTMLPagesSize!private!static pages! !
!URLResolver categoriesFor: #allHTMLPageUrls!private!static pages! !
!URLResolver categoriesFor: #allHTMLPageUrlsIn:!private!static pages! !
!URLResolver categoriesFor: #allPagesAndCounts!private!request counting! !
!URLResolver categoriesFor: #allURLLinks!private! !
!URLResolver categoriesFor: #allUrlsAndCounters!private!request counting! !
!URLResolver categoriesFor: #allWebPages!private! !
!URLResolver categoriesFor: #autoUrlFor:!private! !
!URLResolver categoriesFor: #changeToPreferedURL:!adding - removing!private! !
!URLResolver categoriesFor: #changeToURL:forObject:!adding - removing!private! !
!URLResolver categoriesFor: #correctUrlEncoding!private! !
!URLResolver categoriesFor: #counterFor:!private!request counting! !
!URLResolver categoriesFor: #counterForUrl:!private!request counting! !
!URLResolver categoriesFor: #counters!private! !
!URLResolver categoriesFor: #defaultURL:forObject:!adding - removing!private! !
!URLResolver categoriesFor: #existURL:!private!testing! !
!URLResolver categoriesFor: #fileProxyForURL:!converting!private! !
!URLResolver categoriesFor: #fullUrlFor:on:!converting!private! !
!URLResolver categoriesFor: #fullUrlFromPath:andParms:on:!converting!private! !
!URLResolver categoriesFor: #halfUrlFor:!converting!private! !
!URLResolver categoriesFor: #halfUrlFromPath:andParms:on:!converting!private! !
!URLResolver categoriesFor: #incCounterFor:!private!request counting! !
!URLResolver categoriesFor: #initCounters!initialize - release!private! !
!URLResolver categoriesFor: #initialize!initialize - release!private! !
!URLResolver categoriesFor: #initURLLinks!initialize - release!private! !
!URLResolver categoriesFor: #initWebPages!initialize - release!private! !
!URLResolver categoriesFor: #isRootURL:!private!testing! !
!URLResolver categoriesFor: #isWebElement:!private! !
!URLResolver categoriesFor: #methodImageForURL:!converting!private! !
!URLResolver categoriesFor: #ooRefFromURL:!converting!private! !
!URLResolver categoriesFor: #randomGen!private! !
!URLResolver categoriesFor: #randomGen:!private! !
!URLResolver categoriesFor: #randomUrlFor:!private! !
!URLResolver categoriesFor: #refreshAllHTMLPages!private!static pages! !
!URLResolver categoriesFor: #registerAllHTMLPages!private!static pages! !
!URLResolver categoriesFor: #reindexAllObjects!indexing!private! !
!URLResolver categoriesFor: #reindexNonIndexedObjects!indexing!private! !
!URLResolver categoriesFor: #releaseAllHTMLPages!private!static pages! !
!URLResolver categoriesFor: #releaseAllImages!private!static pages! !
!URLResolver categoriesFor: #releaseAllStaticPages!private!static pages! !
!URLResolver categoriesFor: #removeCounterFor:!private!request counting! !
!URLResolver categoriesFor: #removeNonHTMLCounters!private!request counting! !
!URLResolver categoriesFor: #removeObject:!adding - removing!private! !
!URLResolver categoriesFor: #removeObjectsOfClass:!adding - removing!private! !
!URLResolver categoriesFor: #removeObjectsOfClassNamed:!adding - removing!private! !
!URLResolver categoriesFor: #removeObjectWithURL:!adding - removing!private! !
!URLResolver categoriesFor: #removeURL:!adding - removing!private! !
!URLResolver categoriesFor: #resetAllCounters!private!request counting! !
!URLResolver categoriesFor: #resetCounterFor:!private!request counting! !
!URLResolver categoriesFor: #scanForURLsFrom:!converting!private! !
!URLResolver categoriesFor: #site!private! !
!URLResolver categoriesFor: #site:!private! !
!URLResolver categoriesFor: #urlFor:on:!converting!private! !
!URLResolver categoriesFor: #urlForFile:directory:!private!static pages! !
!URLResolver categoriesFor: #urlFromHalfUrl:on:!converting!private! !

!URLResolver class methodsFor!

default
	^AIDASite default urlResolver!

newOn: anAIDASite
	^super new 
		initialize; 
		site: anAIDASite! !
!URLResolver class categoriesFor: #default!accessing!private! !
!URLResolver class categoriesFor: #newOn:!instance creation!private! !

WebAdmin guid: (GUID fromString: '{281338DD-77BD-4848-B4AD-71BD3BD55711}')!
WebAdmin comment: ''!
!WebAdmin categoriesForClass!Unclassified! !
!WebAdmin methodsFor!

host
	^host!

host: aString
	host := aString!

ip
	^ip!

ip: aString
	ip := aString!

port
	^port!

port: aNumber
	port := aNumber! !
!WebAdmin categoriesFor: #host!accessing!private! !
!WebAdmin categoriesFor: #host:!accessing!private! !
!WebAdmin categoriesFor: #ip!accessing!private! !
!WebAdmin categoriesFor: #ip:!accessing!private! !
!WebAdmin categoriesFor: #port!accessing!private! !
!WebAdmin categoriesFor: #port:!accessing!private! !

WebClipboard guid: (GUID fromString: '{89D75CE2-BFB8-4737-980E-F0507EA51406}')!
WebClipboard comment: 'Used for cut/copy/paste page references (not page contents!!) for easier hyperlinking of pages. Every page should have copy action. Then you can paste url to related links section in some other page.

Instance Variables:
	title	<String> title of a page
	url	<String>	url link to a page

'!
!WebClipboard categoriesForClass!Unclassified! !
!WebClipboard methodsFor!

asDocLink
	"return clipboard contents as a new DocLink"
	^DocLink new
		title: self title;
		url: self url;
		object: self object!

copyFromDocLink: aDocLink
	self title: aDocLink title.
	self url: aDocLink url.
	self object: aDocLink object!

isEmpty
	^(self url isNil or: [self url isEmpty]) and: [self object isNil].!

object
	^object!

object: anObject
	object := anObject!

title
	^title!

title: anObject
	title := anObject!

url
	^url!

url: anObject
	url := anObject! !
!WebClipboard categoriesFor: #asDocLink!converting!private! !
!WebClipboard categoriesFor: #copyFromDocLink:!converting!private! !
!WebClipboard categoriesFor: #isEmpty!private!testing! !
!WebClipboard categoriesFor: #object!accessing!private! !
!WebClipboard categoriesFor: #object:!accessing!private! !
!WebClipboard categoriesFor: #title!accessing!private! !
!WebClipboard categoriesFor: #title:!accessing!private! !
!WebClipboard categoriesFor: #url!accessing!private! !
!WebClipboard categoriesFor: #url:!accessing!private! !

WebCounter guid: (GUID fromString: '{7CB0AF21-768E-4B84-83F5-105DA122161E}')!
WebCounter comment: ''!
!WebCounter categoriesForClass!Unclassified! !
!WebCounter methodsFor!

addArray: aFirstArray to: aSecondArray

	1 to: aFirstArray size do: [:index |
		aSecondArray
			at: index
			put: (aFirstArray at: index) + (aSecondArray at: index)]!

addCounter: aWebCounter
	"add counts from specified counter"
	aWebCounter year = self year ifTrue: 
		[self addArray: aWebCounter dailyCounts to: self dailyCounts].
	self addArray: aWebCounter hourlyCounts to: self hourlyCounts.
	self total: self total + aWebCounter total.
	aWebCounter yearlyHistory keysAndValuesDo: [:yr :array |
		self addArray: array to: (self yearlyHistory at: yr ifAbsentPut: [Array new: 366 withAll: 0]) ].

"WebCounter new addCounter: WebCounter new"!

allCountsInYear: aYearNumber

	aYearNumber = self year 
		ifTrue: [^self dailyCounts copy]
		ifFalse: 
			[^(self yearlyHistory 
				at: aYearNumber 
				ifAbsent: [^Array new: 366 withAll: 0]) copy]!

allCountsThatYear
	
	"return array of counts for each day in current year"

	^self allCountsInYear: Date today year!

allHourlyCounts

	^self hourlyCounts copy!

allTodayHourlyCounts

	^self todayHourlyCounts copy!

checkIfNewYear

	(Date today year = (self year + 1)) ifTrue:
		[self yearlyHistory
			at: self year
			put: self dailyCounts.
		self initDailyCounts.
		self year: Date today year].!

countRequest: aWebRequest

	"register a request by incrementing daily, hourly and total counter."

	self incCounterOnTimestamp: aWebRequest timestamp!

countsFrom: aStartDate to: anEndDate

	| collection |
	collection := OrderedCollection new.
	aStartDate to: anEndDate do: [:date | collection add: (self countsOnDate: date)].
	^collection!

countsMonthlyFromDate: aDate
	| date collection |
	date := Date newDay: 1
		monthNumber: aDate monthIndex
		year: aDate year.
	collection := OrderedCollection new.
	[date < Date today] whileTrue:
		[collection add: (self countsOnMonth: date monthIndex year: date year).
		date := Date newDay: 1
			monthNumber: (date + 31) monthIndex
			year: (date + 31) year].
	^collection

"AIDASite default totalCounter countsMonthlyFromDate: Date today - 6"!

countsMonthlyOnYear: aYear

	^(1 to: 12) collect: [:month | self countsOnMonth: month year: aYear]

"WebServer default totalCounter countsMonthlyOnYear: 1999"!

countsOnDate: aDate

	| counts |
	counts := self allCountsInYear: aDate year.
	^counts at: aDate day!

countsOnHour: aNumber

	^self hourlyCounts at: aNumber!

countsOnMonth: aMonth year: aYear

	| counts date |
	date := Date newDay: 1 monthNumber: aMonth year: aYear.
	counts := self allCountsInYear: date year.
	^(date day to: date day + date daysInMonth - 1)
		inject: 0 into: [:sum :dy | sum + (counts at: dy)]

"WebServer default totalCounter countsOnMonth: 10 year: 1999"!

countsTodayOnHour: aNumber

	^self todayHourlyCounts at: aNumber!

currentWeekCounts

	| firstDay collection |
	firstDay := Date today - Date today weekdayIndex + 1.
	collection := OrderedCollection new.
	firstDay to: firstDay + 6 do: [:date |
		collection add: (self countsOnDate: date)].
	^collection!

dailyCounts
	"array of counters for each day in current year. When new year arrives, counters are 
	copied in a yearlyHistory"

	dailyCounts isNil ifTrue: [self initDailyCounts].
	^dailyCounts!

day
	day isNil ifTrue: [self day: Date today dayOfYear].
	^day!

day: aNumber
	day := aNumber!

hourlyCounts
	"array of counters for each hour in a day."

	hourlyCounts isNil ifTrue: [self initHourlyCounts].
	^hourlyCounts!

incCounter

	"increment daily, hourly and total counter with date and time now"

	self incCounterOnTimestamp: Timestamp now!

incCounterOnTimestamp: aTimestamp

	"increment daily, hourly and total counter with date and time defined"

	
	self incDailyCounterOnDate: aTimestamp asDate.
	self incHourlyCounterOnTimestamp: aTimestamp.
	self incTotal.!

incDailyCounterOnDate: aDate
	aDate year = self year 
		ifTrue: 
			[self dailyCounts at: aDate day put: (self  dailyCounts at: aDate day) + 1]
		ifFalse:
			[self checkIfNewYear.
			self incHistoryCounterOnDate: aDate].!

incHistoryCounterOnDate: aDate
	| array |
	aDate year < self year ifTrue: [^self error: 'future years not allowed'].
	array := (self yearlyHistory at: aDate year ifAbsentPut: [Array new: 366 withAll: 0] ).
	array at: aDate day put: (array at: aDate day)+1!

incHourlyCounterOnTime: aTime
	| hours |
	hours := aTime hours.
	self hourlyCounts at: hours+1 	put: (self  hourlyCounts at: hours+1) + 1.!

incHourlyCounterOnTimestamp: aTimestamp
	| hours |
	hours := aTimestamp asTime hours.
	self hourlyCounts at: hours+1 put: (self  hourlyCounts at: hours+1) + 1.
	self incTodayHourlyCounterOnTimestamp: aTimestamp!

incTodayHourlyCounterOnTimestamp: aTimestamp

	| hours dayOfYear |
	dayOfYear := aTimestamp asDate day.
	self day ~= dayOfYear 	ifTrue: 
		[self initTodayHourlyCounts.
		self day: dayOfYear].
	hours := aTimestamp asTime hours.
	self todayHourlyCounts 
		at: hours+1
		put: (self  todayHourlyCounts at: hours+1) + 1.!

incTotal

	self total: self total + 1.!

initDailyCounts
	dailyCounts := Array new: 366 withAll: 0.
	self year: Date today year.!

initHourlyCounts
	hourlyCounts := Array new: 24 withAll: 0.!

initStarted
	"set a timestamp to a current time"
	started := Timestamp now asSeconds.!

initTodayHourlyCounts

	todayHourlyCounts := Array new: 24 withAll: 0.
	self day: Date today day.!

initTotal

	self total: 0.!

initYearlyHistory
	yearlyHistory := Dictionary new.!

printString

	^'aWebCounter total: ', self total printDotString!

reset

	"set all counters to zero and set started timestamp to now. YOU WILL LOOSE ALL HISTORY
	OF COUNTS !! "

	self initDailyCounts.
	self initHourlyCounts.
	self initTotal.
	self initStarted.!

started
	"return a timestamp, from when web visits are counted"

	started isNil ifTrue: [self initStarted].
	^Timestamp fromSeconds: started!

today
	
	"return number of requests today"

	^self countsOnDate: Date today!

todayHourlyCounts
	"array of counters for each hour today."

	todayHourlyCounts isNil ifTrue: [self initTodayHourlyCounts].
	^todayHourlyCounts!

todayHourlyCounts: anObject
	todayHourlyCounts := anObject!

total
	"total number of visits, registered by this counter"

	total isNil ifTrue: [self initTotal].
	^total.!

total: aNumber
	total := aNumber.!

year
	year isNil ifTrue: [self year: Date today year].
	^year!

year: aNumber
	year := aNumber.!

yearlyHistory
	yearlyHistory isNil ifTrue: [self initYearlyHistory].
	^yearlyHistory!

yesterday
	
	"return number of requests yesterday"

	^self countsOnDate: Date today - 1! !
!WebCounter categoriesFor: #addArray:to:!private! !
!WebCounter categoriesFor: #addCounter:!adding!private! !
!WebCounter categoriesFor: #allCountsInYear:!accessing!private! !
!WebCounter categoriesFor: #allCountsThatYear!accessing!private! !
!WebCounter categoriesFor: #allHourlyCounts!accessing!private! !
!WebCounter categoriesFor: #allTodayHourlyCounts!accessing!private! !
!WebCounter categoriesFor: #checkIfNewYear!private! !
!WebCounter categoriesFor: #countRequest:!counting!private! !
!WebCounter categoriesFor: #countsFrom:to:!accessing!private! !
!WebCounter categoriesFor: #countsMonthlyFromDate:!accessing!private! !
!WebCounter categoriesFor: #countsMonthlyOnYear:!accessing!private! !
!WebCounter categoriesFor: #countsOnDate:!accessing!private! !
!WebCounter categoriesFor: #countsOnHour:!accessing!private! !
!WebCounter categoriesFor: #countsOnMonth:year:!accessing!private! !
!WebCounter categoriesFor: #countsTodayOnHour:!accessing!private! !
!WebCounter categoriesFor: #currentWeekCounts!accessing!private! !
!WebCounter categoriesFor: #dailyCounts!private! !
!WebCounter categoriesFor: #day!private! !
!WebCounter categoriesFor: #day:!private! !
!WebCounter categoriesFor: #hourlyCounts!private! !
!WebCounter categoriesFor: #incCounter!counting!private! !
!WebCounter categoriesFor: #incCounterOnTimestamp:!counting!private! !
!WebCounter categoriesFor: #incDailyCounterOnDate:!private! !
!WebCounter categoriesFor: #incHistoryCounterOnDate:!private! !
!WebCounter categoriesFor: #incHourlyCounterOnTime:!private! !
!WebCounter categoriesFor: #incHourlyCounterOnTimestamp:!private! !
!WebCounter categoriesFor: #incTodayHourlyCounterOnTimestamp:!private! !
!WebCounter categoriesFor: #incTotal!private! !
!WebCounter categoriesFor: #initDailyCounts!initialize - release!private! !
!WebCounter categoriesFor: #initHourlyCounts!initialize - release!private! !
!WebCounter categoriesFor: #initStarted!initialize - release!private! !
!WebCounter categoriesFor: #initTodayHourlyCounts!initialize - release!private! !
!WebCounter categoriesFor: #initTotal!initialize - release!private! !
!WebCounter categoriesFor: #initYearlyHistory!initialize - release!private! !
!WebCounter categoriesFor: #printString!printing!private! !
!WebCounter categoriesFor: #reset!initialize - release!private! !
!WebCounter categoriesFor: #started!accessing!private! !
!WebCounter categoriesFor: #today!accessing!private! !
!WebCounter categoriesFor: #todayHourlyCounts!private! !
!WebCounter categoriesFor: #todayHourlyCounts:!accessing!private! !
!WebCounter categoriesFor: #total!accessing!private! !
!WebCounter categoriesFor: #total:!private! !
!WebCounter categoriesFor: #year!private! !
!WebCounter categoriesFor: #year:!private! !
!WebCounter categoriesFor: #yearlyHistory!private! !
!WebCounter categoriesFor: #yesterday!accessing!private! !

!WebCounter class methodsFor!

instVarMap
	"Gemstone odb"

	^super instVarMap,
		#( 	(todayHourlyCounts nil)	)!

new
	^super new reset!

replicationSpec
	"Gemstone"
	^super replicationSpec, 
	 	#( 	(started max 2)
			(day replicate)
			(year replicate)
			(dailyCounts max 2)
			(hourlyCounts max 2)
			(total replicate)
			(yearlyHistory stub)	)!

setupOdbStorage
	"Versant"

	self 
		store: #(started dailyCounts hourlyCounts total )
		as: #(Integer IntegerArray IntegerArray Integer).!

sumCounters: aCounterCollection

	"return a new counter with sum of all specified counters"
	| sumCounter |
	sumCounter := WebCounter new.
	aCounterCollection do: [:counter |
		sumCounter addCounter: counter].
	^sumCounter!

throughMidnightTest

	Janko := WebCounter new.
	[100 timesRepeat: 
		[Janko incCounter.
		(Delay forSeconds: 1) wait]
	] fork.
	^Janko inspect

"WebCounter throughMidnightTest"!

throughNewYearTest

	Janko := WebCounter new.
	[100 timesRepeat: 
		[Janko incCounter.
		(Delay forSeconds: 1) wait]
	] fork.
	^Janko inspect

"WebCounter throughNewYearTest"! !
!WebCounter class categoriesFor: #instVarMap!odb specific!private! !
!WebCounter class categoriesFor: #new!instance creation!private! !
!WebCounter class categoriesFor: #replicationSpec!odb specific!private! !
!WebCounter class categoriesFor: #setupOdbStorage!odb specific!private! !
!WebCounter class categoriesFor: #sumCounters:!private!summing! !
!WebCounter class categoriesFor: #throughMidnightTest!private!testing! !
!WebCounter class categoriesFor: #throughNewYearTest!private!testing! !

WebDemo guid: (GUID fromString: '{6DE2AB0C-3059-44B4-821E-1F18A1C9AC71}')!
WebDemo comment: ''!
!WebDemo categoriesForClass!Unclassified! !
!WebDemo methodsFor!

content
	content isNil ifTrue: [^''].
	^content!

content: aString
	content := aString!

date
	date isNil ifTrue: [^''].
	^date!

date: aString
	date := aString!

editField
	"for in-place editor demo"
	editField isNil ifTrue: [^'Click me to edit!!'].
	^editField!

editField: anObject
	editField := anObject!

field
	^field!

field: anObject
	field := anObject!

file
	file isNil ifTrue: [^''].
	^file!

file: anObject
	file := anObject!

fileContentType
	^fileContentType!

fileContentType: aString
	fileContentType := aString!

filename
	^filename!

filename: aString
	filename := aString!

input
	input isNil ifTrue: [^''].
	^input!

input: aString
	input := aString! !
!WebDemo categoriesFor: #content!accessing!private! !
!WebDemo categoriesFor: #content:!accessing!private! !
!WebDemo categoriesFor: #date!accessing!private! !
!WebDemo categoriesFor: #date:!accessing!private! !
!WebDemo categoriesFor: #editField!accessing!private! !
!WebDemo categoriesFor: #editField:!accessing!private! !
!WebDemo categoriesFor: #field!accessing!private! !
!WebDemo categoriesFor: #field:!accessing!private! !
!WebDemo categoriesFor: #file!accessing!private! !
!WebDemo categoriesFor: #file:!accessing!private! !
!WebDemo categoriesFor: #fileContentType!accessing!private! !
!WebDemo categoriesFor: #fileContentType:!accessing!private! !
!WebDemo categoriesFor: #filename!accessing!private! !
!WebDemo categoriesFor: #filename:!accessing!private! !
!WebDemo categoriesFor: #input!accessing!private! !
!WebDemo categoriesFor: #input:!accessing!private! !

!WebDemo class methodsFor!

default
	^AIDASite default demo! !
!WebDemo class categoriesFor: #default!accessing!private! !

WebDiscussions guid: (GUID fromString: '{3FC3F495-15C8-4837-9E3E-443E4AD8B824}')!
WebDiscussions comment: ''!
!WebDiscussions categoriesForClass!Unclassified! !
!WebDiscussions methodsFor!

addDiscussionsResponse: aWebDiscussionsMessage user: aWebUser
	"add a new action event to the actions, if not already exist"
	(self discussions includes: aWebDiscussionsMessage)
		ifFalse: 
			[self discussions	add: aWebDiscussionsMessage.
			aWebDiscussionsMessage 
				parent: self;
				timestamp: Timestamp now;
				user: aWebUser.
			self addToNewest: aWebDiscussionsMessage]
		ifTrue: [self error: 'this event already exists in the list of events'].!

addToNewest: aWebDiscussionResponse
	(self newest includes: aWebDiscussionResponse) ifFalse:
		[self newest addFirst: aWebDiscussionResponse.
		self newest size > 10 ifTrue: [self newest removeLast] ].!

allParents
	
	^#()!

deleteDiscussionsResponse: aWebDiscussionsMessage
	"delete this  response"
	aWebDiscussionsMessage responses notEmpty ifTrue: [^nil].
	self discussions remove: aWebDiscussionsMessage ifAbsent: [^nil].
	aWebDiscussionsMessage parent: nil.
	self removeFromNewest: aWebDiscussionsMessage.!

discussions
	discussions isNil ifTrue: [self initDiscussions].
	^discussions.!

fileOutTo: aFilenameString

	| stream boss |
	stream := aFilenameString asFilename writeStream.
	boss := BinaryObjectStorage onNew: stream.
	boss nextPut: self.
	boss close.

"WebDiscussions default fileOutTo: 'discussions.boss' "!

initDiscussions
	discussions := OrderedCollection new.!

initialize!

initNewest
	newest := OrderedCollection new.!

introduction
	introduction isNil ifTrue: [self introduction: ''].
	^introduction!

introduction: aString
	introduction := aString.!

newest
	"list of newest reponses in all discusions"
	newest isNil ifTrue: [self initNewest].
	^newest

"WebServer default webDiscussions newest"!

removeFromNewest: aWebDiscussionResponse
	self newest remove: aWebDiscussionResponse ifAbsent: []! !
!WebDiscussions categoriesFor: #addDiscussionsResponse:user:!adding-removing!private! !
!WebDiscussions categoriesFor: #addToNewest:!adding-removing!private! !
!WebDiscussions categoriesFor: #allParents!accessing!private! !
!WebDiscussions categoriesFor: #deleteDiscussionsResponse:!adding-removing!private! !
!WebDiscussions categoriesFor: #discussions!accessing!private! !
!WebDiscussions categoriesFor: #fileOutTo:!import - export!private! !
!WebDiscussions categoriesFor: #initDiscussions!initialize-release!private! !
!WebDiscussions categoriesFor: #initialize!initialize-release!private! !
!WebDiscussions categoriesFor: #initNewest!initialize-release!private! !
!WebDiscussions categoriesFor: #introduction!accessing!private! !
!WebDiscussions categoriesFor: #introduction:!accessing!private! !
!WebDiscussions categoriesFor: #newest!accessing!private! !
!WebDiscussions categoriesFor: #removeFromNewest:!adding-removing!private! !

!WebDiscussions class methodsFor!

default
	^AIDASite default userServiceNamed: #WebDiscussions!

fileInFrom: aFilenameString

	| stream boss new |
	stream := aFilenameString asFilename readStream.
	boss := BinaryObjectStorage onOld: stream.
	new := boss next.
	boss close.
	^new.

"WebDiscussions fileInFrom: 'discussions.boss' "!

needsDataVerification
	"Do not alter. Added automatically."
	^true!

new
	^super new initialize! !
!WebDiscussions class categoriesFor: #default!accessing!private! !
!WebDiscussions class categoriesFor: #fileInFrom:!instance creation!private! !
!WebDiscussions class categoriesFor: #needsDataVerification!odb private!private! !
!WebDiscussions class categoriesFor: #new!instance creation!private! !

WebDiscussionsResponse guid: (GUID fromString: '{5AC100AB-F749-4505-8AC3-0C0818BEAB73}')!
WebDiscussionsResponse comment: ''!
!WebDiscussionsResponse categoriesForClass!Unclassified! !
!WebDiscussionsResponse methodsFor!

addDiscussionsResponse: aWebDiscussionsMessage user: aWebUser
	"add an empty dicussions response"
	 WebTransactionMonitor critical:
		[(self responses includes: aWebDiscussionsMessage) ifFalse:
			[self responses add: aWebDiscussionsMessage.
			aWebDiscussionsMessage
				parent: self;
				timestamp: Timestamp now;
				user: aWebUser.
			self top addToNewest: aWebDiscussionsMessage.
		"aWebDiscussionsMessage notifyNewResponse"] ].!

allParents
	
	| collection |
	collection := OrderedCollection new.
	self parent notNil ifTrue: 
		[collection add: self parent.
		collection addAllFirst: self parent allParents].
	^collection!

author
	author isNil ifTrue: [self author: ''].
	^author!

author: aString
	author := aString.!

authorsEmail
	authorsEmail isNil ifTrue: [self authorsEmail: ''].
	^authorsEmail!

authorsEmail: aString
	authorsEmail := aString.!

body
	body isNil ifTrue: [self body: ''].
	^body!

body: aString
	body := aString.!

date
	^self timestamp asDate!

deleteDiscussionsResponse: aWebDiscussionsMessage
	"delete this  response, if don't have subresponses"
	aWebDiscussionsMessage responses notEmpty ifTrue: [^nil].
	WebTransactionMonitor critical:
		[self responses remove: aWebDiscussionsMessage ifAbsent: [^nil].
		aWebDiscussionsMessage parent: nil.
		self top removeFromNewest: aWebDiscussionsMessage].!

discussion
	"original discussion, where this response belongs"
	self allParents size > 1
		ifTrue: [^self allParents at: 2]
		ifFalse: [^self]

"WebServer default webDiscussions"!

htmlBody
	| htmlBody |
	(self body isNil) ifTrue: [htmlBody := '']
		ifFalse: 
		[htmlBody := self body 
		 	copyReplaceAll: (String with: Character cr)
			with: '<br>'].

	^htmlBody!

initialize!

initResponses
	responses := OrderedCollection new.!

notifyNewResponse

	"send by e-mail notification of new response"
	|  msgSubject msgBody |
	msgSubject := 'New response in discussion: ', self discussion title.
	msgBody := 'New response: ', self title, ' from author: ', self author.
	[AIDASite default urgentEMailSubject: msgSubject body: msgBody] fork.!

parent
	^parent.!

parent: aWebDiscussionsResponse
	parent := aWebDiscussionsResponse.!

printString
 ^'WebDiscussionsResponse titled: ', self title.!

responseCount

	"return a number of all responses down in hierarchy"

	| count |
	count := self responses size.
	self responses do: [:each | count := count + each responseCount].
	^count!

responses
	responses isNil ifTrue: [self initResponses].
	^responses!

time
	^self timestamp asTime!

timestamp
	"date and time of response"
	timestamp isNil ifTrue: [self timestamp: Timestamp now].
	^timestamp!

timestamp: aTimestamp
	timestamp := aTimestamp.!

title
	title isNil ifTrue: [self title: ''].
	^title!

title: aString
	title := aString.!

top
	"reference to aWebDiscussions as parent of all responses"
	^self allParents first

"WebServer default webDiscussions"!

user
	"a web user, which created a response"
	^user!

user: aWebUser
	user := aWebUser.! !
!WebDiscussionsResponse categoriesFor: #addDiscussionsResponse:user:!adding-removing!private! !
!WebDiscussionsResponse categoriesFor: #allParents!accessing!private! !
!WebDiscussionsResponse categoriesFor: #author!accessing!private! !
!WebDiscussionsResponse categoriesFor: #author:!accessing!private! !
!WebDiscussionsResponse categoriesFor: #authorsEmail!accessing!private! !
!WebDiscussionsResponse categoriesFor: #authorsEmail:!accessing!private! !
!WebDiscussionsResponse categoriesFor: #body!accessing!private! !
!WebDiscussionsResponse categoriesFor: #body:!accessing!private! !
!WebDiscussionsResponse categoriesFor: #date!accessing!private! !
!WebDiscussionsResponse categoriesFor: #deleteDiscussionsResponse:!adding-removing!private! !
!WebDiscussionsResponse categoriesFor: #discussion!accessing!private! !
!WebDiscussionsResponse categoriesFor: #htmlBody!accessing!private! !
!WebDiscussionsResponse categoriesFor: #initialize!initialize-release!private! !
!WebDiscussionsResponse categoriesFor: #initResponses!initialize-release!private! !
!WebDiscussionsResponse categoriesFor: #notifyNewResponse!adding-removing!private! !
!WebDiscussionsResponse categoriesFor: #parent!accessing!private! !
!WebDiscussionsResponse categoriesFor: #parent:!accessing!private! !
!WebDiscussionsResponse categoriesFor: #printString!printing!private! !
!WebDiscussionsResponse categoriesFor: #responseCount!accessing!private! !
!WebDiscussionsResponse categoriesFor: #responses!accessing!private! !
!WebDiscussionsResponse categoriesFor: #time!accessing!private! !
!WebDiscussionsResponse categoriesFor: #timestamp!accessing!private! !
!WebDiscussionsResponse categoriesFor: #timestamp:!accessing!private! !
!WebDiscussionsResponse categoriesFor: #title!accessing!private! !
!WebDiscussionsResponse categoriesFor: #title:!accessing!private! !
!WebDiscussionsResponse categoriesFor: #top!accessing!private! !
!WebDiscussionsResponse categoriesFor: #user!accessing!private! !
!WebDiscussionsResponse categoriesFor: #user:!accessing!private! !

!WebDiscussionsResponse class methodsFor!

needsDataVerification
	"Do not alter. Added automatically."
	^true!

new
	^super new initialize.! !
!WebDiscussionsResponse class categoriesFor: #needsDataVerification!odb private!private! !
!WebDiscussionsResponse class categoriesFor: #new!instance creation!private! !

WebElement guid: (GUID fromString: '{96BBFD23-2BC5-429B-8F83-8BC313EB2521}')!
WebElement comment: ''!
!WebElement categoriesForClass!Unclassified! !
!WebElement methodsFor!

adaptFormElements
	"in case of AJAX request, otherwise WebForm should do that!! "
	self isFormElement ifTrue: [self adapt].
	self elements do: [:each | each adaptFormElements]!

add: aWebElement
	"Include new element as one of the receiver's elements.  Answer aWebElement.
	If you nest a web page into another web page, then add only elements of it"
	self checkAndInitElements.  "if not composite element, then error"
	"if nested web pages then add elements without header"
	(aWebElement isKindOf: WebApplication) ifTrue: [^self halt].
	((aWebElement isKindOf: WebPage) and: [self isKindOf: WebPage])
		ifTrue: [^elements add: aWebElement elements].
	aWebElement parent: self.
	^elements add: aWebElement.!

addAnchorName: aString
	self add: (WebAnchor name: aString)!

addAspect: aSymbol for: anObject input: aBoolean size: aSizeNumberOrPoint

	"adds an auto converted text of aspect for that object. If imput argument is true, then add 
	an input field or text area, depending in size (eg. size: 5 or size: 5@5)"

	aBoolean
		ifFalse: 
			[self addText: (WebFormElement autoConvertToString: (anObject perform: aSymbol))]
		ifTrue:
			[(aSizeNumberOrPoint isKindOf: Number)
				ifTrue: 
					[self add: 
						(WebInputField new
							size: aSizeNumberOrPoint;
							aspect: aSymbol for: anObject)].
			(aSizeNumberOrPoint isKindOf: Point)
				ifTrue: 
					[self add: 
						(WebTextArea new
							size: aSizeNumberOrPoint;
							aspect: aSymbol for: anObject)] 
			].!

addAspectForListbox: aSymbol for: anObject  size: aSizeNumberOrPoint list: aList

	"adds an auto converted text of aspect for that object. If imput argument is true, then add 
	an input field or text area, depending in size (eg. size: 5 or size: 5@5)"



self add: (WebListbox new	size: aSizeNumberOrPoint;
							aspect: aSymbol for: anObject;
							lista: aList).!

addAspectForListbox: aSymbol for: anObject  size: aSizeNumberOrPoint list: aList selection: aSelection

	"adds an auto converted text of aspect for that object. If imput argument is true, then add 
	an input field or text area, depending in size (eg. size: 5 or size: 5@5)"


self add: (WebListbox new	size: aSizeNumberOrPoint;
							aspect: aSymbol for: anObject;
							lista: aList;
							value: aSelection).!

addBreak

	self add: (WebSeparator break).!

addButtonText: aString

	self add: (WebButton text: aString)!

addButtonText: aString action: aSymbol
	"for more than one buttons. Action method is a composed name from 'action', aView, Symbol.
	example: for view #main, action #addFolder is action method #actionMainAddFolder"
	self add: (WebButton text: aString action: aSymbol)!

addCheckboxAspect: aSymbol for: anObject
	"aspect method will be called and true/false will be set/clear on an object"
	self add: (WebCheckBox aspect:  aSymbol for: anObject)!

addCheckboxObject: anObject from: aCollection
	"if checked, this object will be put in collection. If object is initially in collection, 
	checkbox will be checked. Usefull for easy selection among many objects"
	self add: (WebCheckBox object: anObject from: aCollection)!

addComment: aString
	self add: (WebComment text: aString).!

addDateInputFieldAspect: aSymbol for: anObject
	"with popup calendar"
	self add: (WebDateInputField new aspect:  aSymbol for: anObject)!

addErrorReport
	self add: self app errorReport!

addGif: aSymbol
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	self add: (WebImage gif: aSymbol)!

addGif: aSymbol size: aPoint
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	self add: (WebImage gif: aSymbol size: aPoint)!

addHelpLink
	"link to help page for current view and App. If not exist, then nothing, exept for 
	admin - link to creation of new help page"
	self add: self helpLink!

addImage: anImageOrURL

	self add: (WebImage image: anImageOrURL)!

addImage: anImageOrURL imageMap: aWebImageMap

	self add: 
		((WebImage image: anImageOrURL)
			imageMap: aWebImageMap)!

addImage: anImageOrURL size: aPoint

	self add: (WebImage image: anImageOrURL size: aPoint)!

addImage: anImageOrURL size: aPoint align: aSymbol

	self add: ((WebImage image: anImageOrURL size: aPoint) align: aSymbol)!

addImage: anImageOrURL size: aPoint valign: aSymbol

	self add: ((WebImage image: anImageOrURL size: aPoint) valign: aSymbol)!

addInPlaceEditableTextAspect: aSymbol for: anObject
	self add: (WebInPlaceEditableText aspect:  aSymbol for: anObject)!

addInPlaceEditableTextAspect: aSymbol for: anObject size: aNumberOrPoint
	self add: (WebInPlaceEditableText aspect:  aSymbol for: anObject size: aNumberOrPoint)!

addInPlaceEditableTextAspect: aSymbol for: anObject size: aNumberOrPoint allow: aBoolean
	self add: 
		(WebInPlaceEditableText aspect:  aSymbol for: anObject size: aNumberOrPoint allow: aBoolean)!

addInputFieldAspect: aSymbol for: anObject
	self add: (WebInputField new aspect:  aSymbol for: anObject)!

addInputFieldAspect: aSymbol for: anObject size: aNumber
	self add: ((WebInputField new aspect:  aSymbol for: anObject) size: aNumber)!

addJpeg: aSymbol
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	self add: (WebImage jpeg: aSymbol)!

addJpeg: aSymbol size: aPoint
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	self add: (WebImage jpeg: aSymbol size: aPoint)!

addLinkTo: anObject gif: aGifSymbol title: aString
	self add: ((WebLink linkTo: anObject) title: aString; addGif: aGifSymbol)!

addLinkTo: anObject gif: aGifSymbol title: aString size: aPoint
	self add: ((WebLink linkTo: anObject) title: aString; addGif: aGifSymbol size: aPoint)!

addLinkTo: anObject gif: aGifSymbol title: aString view: aViewSymbol
	self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) addGif: aGifSymbol)!

addLinkTo: anObject gif: aGifSymbol title: aString view: aViewSymbol
	 parameter: aParmString value: aValueString

	self add: (((WebLink linkTo: anObject) 
		title: aString; view: aViewSymbol;
		parameter: aParmString value: aValueString) 
			addGif: aGifSymbol)!

addLinkTo: anObject image: anImageOrURL
	self add: ((WebLink linkTo: anObject) addImage: anImageOrURL)!

addLinkTo: anObject image: anImageOrURL parameter: aParmString value: aValueString
	self add: (((WebLink linkTo: anObject)
		parameter: aParmString value: aValueString) addImage: anImageOrURL)!

addLinkTo: anObject image: anImageOrURL size: aPoint
	self add: ((WebLink linkTo: anObject) addImage: anImageOrURL size: aPoint)!

addLinkTo: anObject image: anImageOrURL view: aViewSymbol
	self add: (((WebLink linkTo: anObject) view: aViewSymbol) addImage: anImageOrURL)!

addLinkTo: anObject jpeg: aSymbol title: aString
	self add: ((WebLink linkTo: anObject) title: aString; addJpeg: aSymbol)!

addLinkTo: anObject jpeg: aSymbol title: aString view: aViewSymbol
	self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) addJpeg: aSymbol)!

addLinkTo: anObject message: aSymbol

	self add: (WebLink message: aSymbol  linkTo: anObject)!

addLinkTo: anObject png: aPngSymbol title: aString
	self add: ((WebLink linkTo: anObject) title: aString; addPng: aPngSymbol)!

addLinkTo: anObject png: aPngSymbol title: aString view: aViewSymbol
	self add: (((WebLink linkTo: anObject) title: aString; view: aViewSymbol) addPng: aPngSymbol)!

addLinkTo: anObject png: aPngSymbol title: aString view: aViewSymbol
	 parameter: aParmString value: aValueString

	self add: (((WebLink linkTo: anObject) 
		title: aString; view: aViewSymbol;
		parameter: aParmString value: aValueString) 
			addPng: aPngSymbol)!

addLinkTo: anObject text: aString

	self add: (WebLink text: aString  linkTo: anObject)!

addLinkTo: anObject text: aString attributes: anArray

	self add: (WebLink text: aString  attributes: anArray linkTo: anObject)!

addLinkTo: anObject text: aString header: aNumber
	self add: (WebLink text: aString  header: aNumber linkTo: anObject)!

addLinkTo: anObject text: aString parameter: aParmString value: aValueString
	self add: (WebLink text: aString  linkTo: anObject 
		parameter: aParmString value: aValueString)!

addLinkTo: anObject text: aString 
	parameter: a1ParmString value: a1ValueString
	parameter: a2ParmString value: a2ValueString

	self add: (WebLink text: aString  linkTo: anObject 
		parameter: a1ParmString value: a1ValueString
		parameter: a2ParmString value: a2ValueString)!

addLinkTo: anObject text: aString view: aViewString
	self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString; yourself)!

addLinkTo: anObject text: aString view: aViewString  parameter: aParmString value: aValueString
	self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString;
		parameter: aParmString value: aValueString; yourself)!

addLinkTo: anObject text: aString view: aViewString  
		parameter: aParm1String value: aValue1String 
		parameter: aParm2String value: aValue2String

	self add: ((WebLink text: aString  linkTo: anObject)
		view: aViewString;
		parameter: aParm1String value: aValue1String;
		parameter: aParm2String value: aValue2String; yourself)!

addListboxWithList: aList size: aSizeNumberOrPoint

	"adds an auto converted text of aspect for that object. If imput argument is true, then add 
	an input field or text area, depending in size (eg. size: 5 or size: 5@5)"



self add: (WebListbox new	size: aSizeNumberOrPoint;
							"aspect: aSymbol forObject: anObject;"
							lista: aList).!

addLiveImage: aWebLiveImage

	self add: 
		((WebImage image: aWebLiveImage)
			size: (aWebLiveImage width)@(aWebLiveImage height))!

addLiveImage: aWebLiveImage imageMap: aWebImageMap

	self add: 
		((WebImage image: aWebLiveImage)
			size: (aWebLiveImage width)@(aWebLiveImage height);
			imageMap: aWebImageMap)!

addMenuAspect: aSymbol collection: aCollection selected: aSelectedCollection
	"Multiple selection menu.. Aspect of every element in aColection will be shown in menu. 
	Selection will be put in aSelectedCollection. Here also an initial selection can be set"
	self add: (WebMenu aspect: aSymbol collection: aCollection selected: aSelectedCollection)!

addMenuAspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject
	"Single selection menu.. Aspect of every element in aColection will be shown in menu. 
	Single selection will be put in an seelcted aspect of object. Here also initial selection can be set"
	self add: 
		(WebMenu aspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject)!

addMenuCollection: aCollection selected: aSelectedCollection
	"Multiple selection menu..Every element (text!!) in aColection will be shown in menu. 
	Selection will be put 	in aSelectedCollection. Here also an initial selection can be set"
	self add: (WebMenu collection: aCollection selected: aSelectedCollection)!

addMenuCollection: aCollection selectedToAspect: aSymbol2 of: anObject
	"Single selection menu. Every element (text!!) in aColection will be shown in menu. 
	Single selection will be put in an seelcted aspect of object. Here also initial selection can be set"
	self add: (WebMenu collection: aCollection selectedToAspect: aSymbol2 of: anObject)!

addMethodImage: aWebMethodImage

	self add: 
		(WebImage image: aWebMethodImage)!

addMethodImage: aWebMethodImage size: aPoint

	self add: 
		((WebImage image: aWebMethodImage) size: aPoint)!

addNbSp

	self addText: '&nbsp;'.!

addNbSp: aNumber

	aNumber timesRepeat: [self addNbSp].!

addPageBreak
	"for printing to printer, to break into a new page!!"
	self add: ((WebElement newClass: #pageBreak) 
		addComment: 'Page break'; yourself).!

addParagraph

	self add: (WebSeparator paragraph).!

addPasswordFieldAspect: aSymbol for: anObject
	self add: (WebInputField new type: #password; aspect:  aSymbol for: anObject)!

addPasswordFieldAspect: aSymbol for: anObject size: aNumber
	self add: ((WebInputField new type: #password; aspect:  aSymbol for: anObject) size: aNumber)!

addPDFLinkTo: anObject

	self add: ((WebLink linkTo: anObject) addGif: #pdfBigGif)!

addPng: aSymbol
	"this method will be called in your webStyle and this method 
	should return a png in byte array format"
	self add: (WebImage png: aSymbol)!

addPng: aSymbol size: aPoint
	"this method will be called in your webStyle and this method 
	should return a png in byte array format"
	self add: (WebImage png: aSymbol size: aPoint)!

addRichEditorAspect: aSymbol for: anObject
	"JavaScript HTML WYSIWYG editor instead of textarea"
	self add: (WebRichEditor new aspect:  aSymbol for: anObject)!

addRichEditorAspect: aSymbol for: anObject size: aPoint
	"JavaScript HTML WYSIWYG editor instead of textarea"
	self add: ((WebRichEditor new aspect:  aSymbol for: anObject) size: aPoint)!

addRulerSize: aNumber

	self add: (WebSeparator rulerSize: aNumber).!

addSecureLinkTo: anObject text: aString

	self add: ((WebLink text: aString  linkTo: anObject) security: #grayed)!

addSecureLinkTo: anObject 
	text: aString parameter: aParmString value: aValueString

	self add: ((WebLink text: aString  linkTo: anObject 
		parameter: aParmString value: aValueString) security: #grayed)!

addSecureLinkTo: anObject text: aString view: aViewString
	self add: ((WebLink text: aString  linkTo: anObject 
		view: aViewString) security: #grayed)!

addSpace
	"just a simple space, nothing more"
	self addText: ' '!

addText: aString

	self add: (WebText text: aString)!

addText: aString attributes:  aSymbolArray

	self add: ((WebText text: aString) textAttributes: aSymbolArray)!

addText: aString attributes:  aSymbolArray color: aColorSymbol

	self add: ((WebText text: aString) attributes: aSymbolArray; color: aColorSymbol)!

addText: aString attributes:  aSymbolArray font: aFontString

	self add: ((WebText text: aString) attributes: aSymbolArray; font: aFontString)!

addText: aString attributes:  aSymbolArray font: aFontString color: aColorSymbol

	self add: ((WebText text: aString) 
		textAttributes: aSymbolArray; font: aFontString; color: aColorSymbol)!

addText: aString  color: aColorSymbol

	self add: ((WebText text: aString)  color: aColorSymbol)!

addText: aString font: aFontString

	self add: ((WebText text: aString) font: aFontString)!

addText: aString  font: aFontString color: aColorSymbol

	self add: ((WebText text: aString)  font: aFontString; color: aColorSymbol)!

addText: aString header: aNumber

	self add: ((WebText text: aString) header: aNumber)!

addText: aString header: aNumber color:  aColorSymbol

	self add: ((WebText text: aString) header: aNumber; color:  aColorSymbol)!

addText: aString header: aNumber font: aFontString

	self add: ((WebText text: aString) header: aNumber; font: aFontString)!

addText: aString header: aNumber font: aFontString color: aColorSymbol

	self add: ((WebText text: aString) 
		header: aNumber; font: aFontString; color: aColorSymbol)!

addText: aString style: aStyleString

	self add: ((WebText text: aString) style: aStyleString)!

addTextAreaAspect: aSymbol for: anObject
	self add: (WebTextArea new aspect:  aSymbol for: anObject)!

addTextAreaAspect: aSymbol for: anObject size: aPoint
	self add: ((WebTextArea new aspect:  aSymbol for: anObject) size: aPoint)!

addTextAspect: aSymbol for: anObject
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	self app inEditMode
		ifTrue: [self addInputFieldAspect: aSymbol for: anObject]
		ifFalse: [self addText: (anObject perform: aSymbol)]!

addTextAspect: aSymbol for: anObject attributes: aSymbolOrArray
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	self app inEditMode
		ifTrue: [self addInputFieldAspect: aSymbol for: anObject]
		ifFalse: [self addText: (anObject perform: aSymbol) attributes: aSymbolOrArray]!

addTextBig: aString
	self addText: '<big>', aString, '</big>'!

addTextBold: aString
	self addText: aString attributes: #bold!

addTextBoldAspect: aSymbol for: anObject
	"depening on portlet mode (#view or #edit) return only text or make an input field"
	self addTextAspect: aSymbol for: anObject attributes: #bold!

addTextCode: aString
	self addText: '<code>', aString, '</code>'.!

addTextH1: aString
	self addText: aString header: 1!

addTextH2: aString
	self addText: aString header: 2!

addTextH3: aString
	self addText: aString header: 3!

addTextH4: aString
	self addText: aString header: 4!

addTextH5: aString
	self addText: aString header: 5!

addTextItalic: aString
	self addText: aString attributes: #italic!

addTextPreformated: aString
	self addText: '<pre>', aString, '</pre>'.!

addTextSmall: aString
	self addText: '<small>', aString, '</small>'!

ajaxCallUrl
	"relative url of an app observee object. This url is used for AJAX calls back to the server"
	| app object |
	app := self app.
	object := app observee isVersionedObject ifTrue: [app observee currentVersion] ifFalse: [app observee].
	^app site urlResolver halfUrlFor: object!

ajaxCallUrlExtended
	"relative url of an app observee object. This url is used for AJAX calls back to the server"
	"also includes 'ajaxRequest' in query part, to distinguish ajax request from others"
	| versionParm |
	versionParm := ''.
	self app observee isVersionedObject ifTrue:
		[self app observee isCurrentVersion ifFalse: 
			[versionParm := 'version=' self app observee versionNumber, '&'] ].
	^self ajaxCallUrl, '?', versionParm, 'ajaxRequest'!

ajaxCallUrlParametersFor: anElementOrId
	"ajax url must have 'ajaxRequest' parm in query part!! Deal also with versioned objects"
	| idSymbol versionParm |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] 
		ifFalse: [anElementOrId isNil
			ifTrue: [#nil] ifFalse: [anElementOrId registerId. anElementOrId id] ].
	versionParm := ''.
	self app observee isVersionedObject ifTrue:
		[self app observee isCurrentVersion ifFalse: 
			[versionParm := 'version=', self app observee versionNumber, '&'] ].
	^versionParm, 'ajaxRequest&ajaxGetElementId=', idSymbol asString!

allElements
	"get a collection of all subelements of elements down in a hierarcy of this element"
	| collection |
	collection := OrderedCollection new.
	self elements notNil ifTrue:
		[collection addAll: self elements.
		self elements do: [:each | collection addAll: each allElements] ].
	^collection

"
| el |
el := WebElement new.
el add: (WebLink image: nil  linkTo: nil).
el add: (WebText text: 'aaa').
el allElements.
"!

allElementsOfClass: aClass

"returns a collection of subelements of given class, actualy type of an element. Broswe entire hierarchy of that element"

	| found |
	found := OrderedCollection new.
	(self class = aClass) ifTrue: [found add: self].
      (self elements isKindOf: Collection) 
		ifTrue: [self elements do: 
			[:element | found addAll: (element allElementsOfClass: aClass)]]
		ifFalse: 
			[(self elements isKindOf: WebElement)   "nil or other excluded"
				ifTrue: [found addAll:       "only one element"
					(self elements allElementsOfClass: aClass)]].
	^found!

allOOLinks
	"return collection of all objects to which this page has a link"
	| ooLinks |
	ooLinks := self allElements select: [:element | 
		(element isKindOf: WebLink) and: [element ooReference notNil] ].
	^ooLinks collect: [:each | each ooReference].

"
| el |
el := WebElement new.
el add: (WebLink linkTo: Date today); addText: 'aaaa'.
el allOOLinks
"!

app
	"return anApplication on which we are composing a web page"
	| object |
	self parent isNil ifTrue: 
		[object := self firstAppFromStack.
		^object isNil ifTrue: [nil] ifFalse: [object ] ].
	^parent app!

attributes
	^attributes!

attributesAt: aSymbol
	self attributes isNil ifTrue: [^nil].
	^self attributes at: aSymbol ifAbsent: [nil]!

attributesAt: aSymbol add: aString
	"some attributes can have more than one value (like javascript for events)"
	self attributes isNil ifTrue: [self initAttributes].
	(self attributes at: aSymbol ifAbsentPut: [OrderedCollection new]) add: aString!

attributesAt: aSymbol put: aString
	self attributes isNil ifTrue: [self initAttributes].
	self attributes at: aSymbol put: aString!

cell
	"return a current table cell"
	(table isNil or: [(table at: 3) isNil]) ifTrue: [self newTable].
	^table at: 3!

cell: aWebTableCell
	table isNil ifTrue: [self initTable].
	table at: 3 put: aWebTableCell.!

checkAndInitElements

	"lazy initialization od elements, when needed. Only for composite elements, else error"
	
	self isComposite 
		ifTrue:[(elements = nil) ifTrue: [elements := OrderedCollection new.       ]]
		ifFalse: [Smalltalk error: 'This is not a composite WebElement'].!

class: aSymbol
	"style class of that element. Used for Cascaded Style Sheets"
	self attributesAt: #class put: aSymbol!

clear
	"remove all subelements"
	self initElements.!

clearTableInfo
	"clear all table information: sets table array to nil"
	self initTable!

colorValue: aColorSymbol
	"Hex number format is: #rrbbgg if not in that format, then it can be a color name as defined in 
	class variable Colors (class method initColorDictionary). If unknown color, then attribute is set to nil"
	| attribute |
	attribute := aColorSymbol asString asLowercase asSymbol.
	attribute := WebElement colorDictionary at: attribute ifAbsent:
		[attribute asString do: [:chr | 
			(chr isDigit or: [chr asInteger between: $a asInteger and: $f asInteger]) ifFalse: [^self] ] ].
	^'#', (attribute asString copyWithout: $# )

"WebElement new colorValue: #red"!

div
	div isNil ifTrue: [^false].
	^div!

div: aBoolean
	"if an element is DIV tag"
	div := aBoolean!

elements
	elements isNil ifTrue: [self initElements].
	^elements!

eol
	self setNewline.
	^String with: Character cr with: Character lf.!

first
	"Answer the first element.  If the receiver is empty, provide an error 
	notification."

	self checkAndInitElements.  "if not composite element, then error"
	^elements first!

firstAppFromStack
	"try to find a first sender up in calling stack, who is  WebApplication"
	| stackFrame session |
	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: WebApplication) ifTrue: [^stackFrame receiver].
		stackFrame receiver class == AIDASite ifTrue:
			[session := stackFrame arguments detect: [:each | each class == WebSession] ifNone: [nil].
			session notNil ifTrue: [^session lastApp ] ].
		stackFrame := stackFrame sender].
	^nil!

firstSessionFromStack
	"try to find a first sender up in calling stack, who is  AIDASite and get session if that call"
	| stackFrame |
	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: WebApplication) ifTrue: [^stackFrame receiver session].
		stackFrame := stackFrame sender].
	^nil!

helpLink
	^self app helpLink!

hide
	"hide me from web page"
	self registerId.
	self addText: '<script>Element.hide(''', self id, ''')</script>'!

id
	^self attributesAt: #id!

id: aSymbol
	"set a unique id of that element on a page. Used in javascript, urls, style sheets"
	| app |
	app := self app.
	self id notNil ifTrue: [(app isRegistered: self) ifTrue: [app removeId: self id]].
	self attributesAt: #id put: aSymbol asSymbol.
	app registerIdFor: self.!

ident
	"ident this tag to its level"
	| depth eol|
	eol := ''.
	self shouldIdent & self isNewline not ifTrue: [eol := self eol]. 
	depth := (self identationLevel - self identDepth) max: 0.
	self identDepth: self identationLevel.
	^eol, (String new: depth withAll: Character tab )!

identationLevel	
	"How much we need to ident. Top element has level 0"
	^self parent notNil
		ifTrue: [self shouldIdent ifTrue: [self parent identationLevel + 1] ifFalse: [self parent identationLevel]]
		ifFalse: [0]!

identDepth
	"how idented we are"
	| app |
	app := self app.
	^app notNil ifTrue: [app identDepth] ifFalse: [0].!

identDepth: aNumber
	"how idented we are"
	| app |
	app := self app.
	^app isNil ifTrue: [0] ifFalse: [app identDepth: aNumber]!

identMore
	"ident inside tag content to its level and one deepier"
	self isNewline ifFalse: [self eol]. 
	self identDepth: self identationLevel+1.
	^String new: self identationLevel+1 withAll: $ !

initAttributes
	attributes := Dictionary new.!

initElements
	elements := OrderedCollection new.!

initScripts
	scripts := Dictionary new.!

initTable
	table := Array new: 3.!

insideDivTag
	"to enclose or not in div tag. Only if element have any attribute!!"
	^self div | (self class == WebElement and: [self attributes notNil]).!

isComposite

	"true, if this element is allowed to be composed by subelements.
	This method should be overriden by subclasess if a new element is not a 	composite."

	^true!

isFormElement
	^false!

isNewline
	"are we at start of new line?"
	| app |
	app := self app.
	^app notNil ifTrue: [app isNewline] ifFalse: [false]!

isWebElement
	^true!

isWebPage
	^false!

last
	"Answer the last element.  If the receiver is empty, create an error notification."

	self checkAndInitElements.  "if not composite element, then error"
	^elements last!

level	
	"How deep we are in element hierarchy. Top element has level 0"
	^self parent notNil
		ifTrue: [self parent level + 1]
		ifFalse: [0]!

method
	"a method which created this element, always from some App. 
	Valid only for aWebElement, never for its subclasses!!"
	^method!

method: aSymbol
	"a method which created this element, always from some App. 
	Valid only for aWebElement, never for its subclasses!!"
	method := aSymbol!

newCell
	"add a new cell to current table row. Return a new WebTableCell so that you can send messages
	to it immediatelly - color, width, addText etc."
	self cell: WebTableCell new.
	self row add: self cell.
	^self cell!

newRow
	"add a new row to current table. Return a new WebTableRow so that you can send messages
	to it immediatelly - color, width etc. Also reset current row and current cell to a new ones. "
	self row: WebTableRow new.
	self table add: self row.
	self newCell.
	^self row!

newTable
	"add a new table to this element. Return a new WebTable so that you can send messages
	to it immediatelly - color, wdth etc. Also reset current row and current cell to a new ones. "
	self table: WebTable new.
	self add: self table.
	self newRow.
	^self table

"
|el|
el := WebElement new.
el newTable; newRow; newCell.
el
"!

onClick: aJavascriptCode
	self attributesAt: #onClick add: aJavascriptCode!

onClickHide: anElementOrId
	"hide specified element on mouse click on me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.hide(''', idSymbol asString, ''')'.!

onClickShow: anElementOrId
	"show specified element on mouse click on me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.show(''', idSymbol asString, ''')'.!

onClickToggle: anElementOrId
	"toggle visibility of specified element on mouse click on me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onClick: 'Element.toggle(''', idSymbol asString, ''')'.!

onClickUpdate: anElementOrId
	"update (and show if not yet) a specified element from server (AJAX)"
	self onClickUpdate: anElementOrId with: nil!

onClickUpdate: anElementOrId with: aParmString
	"update a specified element from server (AJAX) wtih calling an element method with a parameter"
	| idSymbol url parms  |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	url := self ajaxCallUrl. 
	parms:= self ajaxCallUrlParametersFor: anElementOrId.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	self onClick: 'new Ajax.Updater(''', idSymbol asString, ''', ''', url, 
		''', {method: ''get'', parameters: ''', parms, ''', evalScripts: true})'!

onDblClick: aJavascriptCode
	self attributesAt: #onDblClick add: aJavascriptCode!

onKeyDown: aJavascriptCode
	self attributesAt: #onKeyDown add: aJavascriptCode!

onKeyPress: aJavascriptCode
	self attributesAt: #onKeyPress add: aJavascriptCode!

onKeyUp: aJavascriptCode
	self attributesAt: #onKeyUp add: aJavascriptCode!

onMouseDown: aJavascriptCode
	self attributesAt: #onMouseDown add: aJavascriptCode!

onMouseMove: aJavascriptCode
	self attributesAt: #onMouseMove add: aJavascriptCode!

onMouseOut: aJavascriptCode
	self attributesAt: #onMouseOut add: aJavascriptCode!

onMouseOutHide: anElementOrId
	"hide specified element when mouse get out of me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOut: 'Element.hide(''', idSymbol asString, ''')'.!

onMouseOutShow: anElementOrId
	"show specified element when mouse get out of me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOut: 'Element.show(''', idSymbol asString, ''')'.!

onMouseOver: aJavascriptCode
	self attributesAt: #onMouseOver add: aJavascriptCode!

onMouseOverHide: anElementOrId
	"hide specified element when mouse come over me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOver: 'Element.hide(''', idSymbol asString, ''')'.!

onMouseOverShow: anElementOrId
	"show specified element when mouse come over me"
	| idSymbol |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] ifFalse: [anElementOrId registerId. anElementOrId id].
	self onMouseOver: 'Element.show(''', idSymbol asString, ''')'.!

onMouseUp: aJavascriptCode
	self attributesAt: #onMouseUp add: aJavascriptCode!

parent
	^parent!

parent: aWebElement
	parent := aWebElement!

prepareAttributesToPrintOn: aSession
	"override if you like to change or otherwise prepare attribute values"!

prepareToHTMLPrintOn: aSession
	"all preparations just before html rendering"
	self prepareAttributesToPrintOn: aSession.  "some pre-html preparation of values"!

printAttribute: aNameSymbol value: aValue on: aStream for: aSession
	"if value is true/false, then if true, just print an atribute name, otherwise ommit both"
	"multivalue attributes are supposed to be javascript only!! "
	| multiValue |
	aStream nextPut:  $ . 
	((aValue ~= false) | (aValue == true)) ifTrue: [aStream nextPutAll: aNameSymbol asString].
	(aValue isKindOf: Boolean) ifTrue: [^self].
	multiValue := aValue class == OrderedCollection.    aStream nextPutAll: '="'.
	multiValue not ifTrue: [aStream 
		nextPutAll: (AIDASite convertToWeb: aValue asString on: aSession); nextPutAll: '"'. ^self].
	aValue do: [:value | 
		aStream nextPutAll:  (AIDASite convertToWeb: value asString on: aSession). 
		aStream nextPutAll: '; ']. "javascript sentence separator"
	aStream nextPutAll: '"'.!

printAttributesOn: aStream for: aSession
	"start and end of tag is not my responsibility!!"
	self attributes isNil ifTrue: [^self].
	self attributes keysAndValuesDo: [:name :value |
		self printAttribute: name value: value on: aStream for: aSession]!

printHTMLPageOn: aStream forSession: aSession
	"WebElement with some attributes is enclosed inside <div> tag, for tricks with CSS"
	self prepareToHTMLPrintOn: aSession.
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	self insideDivTag ifTrue: 
		[aStream nextPutAll: self ident, '<div'. self printAttributesOn: aStream for: aSession. 
		aStream nextPutAll: '>', self eol].
	elements notNil ifTrue: [elements do: [:element | 
		element notNil ifTrue: [element printHTMLPageOn: aStream forSession: aSession] ] ].
	self insideDivTag ifTrue: [aStream nextPutAll: self ident, '</div>', self eol].
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].!

registerId
	"put into App ids dictionary for faster search from AJAX requests"
	self id notNil ifTrue: [^nil]. "must be already registered!! "
	self app notNil ifTrue: [self app registerIdFor: self]!

row
	"return a current table row"
	(table isNil or: [(table at: 2) isNil]) isNil ifTrue: [self newTable].
	(table at: 2) isNil ifTrue: [self row: WebTableRow new].
	^table at: 2!

row: aWebTableRow
	table isNil ifTrue: [self initTable].
	table at: 2 put: aWebTableRow.!

script: aString
	"add this JavaScript  to scripts executed after this element"
	self scriptAfter: aString!

scriptAfter
	scripts isNil ifTrue: [^nil].
	^scripts at: #after ifAbsent: [nil]!

scriptAfter: aString
	"add this JavaScript  to scripts executed after this element"
	scripts isNil ifTrue: [self initScripts].
	(scripts at: #after ifAbsentPut: [WebScript new]) script: aString!

scriptBefore
	scripts isNil ifTrue: [^nil].
	^scripts at: #before ifAbsent: [nil]!

scriptBefore: aString
	"add this JavaScript  to scripts executed before this element"
	scripts isNil ifTrue: [self initScripts].
	(scripts at: #before ifAbsentPut: [WebScript new]) script: aString!

session
	"return a Session for which we are composing a web page"
	self parent isNil ifTrue: [^self app session].
	^parent session!

setCreationMethod
	"find a name of a method which created me"
	| stackFrame |
	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame] whileTrue: [
		(stackFrame receiver isKindOf: WebApplication) ifTrue: [^self method: stackFrame method selector].
		stackFrame := stackFrame sender].
!

setNewline
	"we are no longer at start of line"
	| app |
	app := self app.
	app notNil ifTrue: [app setNewline].!

shouldIdent
	"true, if this element should be idented in html page"
	^self insideDivTag!

show
	"show me (if not already) on web page"
	self registerId.
	self addText: '<script>Element.show(''', self id, ''')</script>'!

site
	"return a Site on which we are composing a web page"
	| app |
	self parent isNil ifTrue: 
		[app := self firstAppFromStack.
		^app isNil ifTrue: [nil] ifFalse: [app site] ].
	^parent site!

style
	"return a WebStyle on which we are composing a web page"
	self parent isNil ifTrue: [^self firstSessionFromStack site style].
	^parent style!

style: aString
	"redefine a style of that element with CSS syntax, example:
	style: '{color: blue; font-style: italic}'   "
	self attributesAt: #style put: aString!

table
	"return a current web table. If not yet exist, create it"
	(table isNil or: [(table at: 1) isNil]) ifTrue: [self newTable].
	^table at: 1!

table: aWebTable
	table isNil ifTrue: [self initTable].
	table at: 1 put: aWebTable!

title: aString
	"title of an element. it will be shown when mouse pause over it"
	self attributesAt: #title put: 
		"slovene csz are converted if char ^ is after such a char"
		((aString includes: $^ ) ifTrue: [aString convertToSloveneChars] ifFalse: [aString])!

toogle
	"toogle element visibility on  web page"
	self registerId.
	self addText: '<script>Element.toggle(''', self id, ''')</script>'! !
!WebElement categoriesFor: #adaptFormElements!accessing!private! !
!WebElement categoriesFor: #add:!private!subelements! !
!WebElement categoriesFor: #addAnchorName:!adding links!private! !
!WebElement categoriesFor: #addAspect:for:input:size:!adding form elements!private! !
!WebElement categoriesFor: #addAspectForListbox:for:size:list:!adding form elements!private! !
!WebElement categoriesFor: #addAspectForListbox:for:size:list:selection:!adding form elements!private! !
!WebElement categoriesFor: #addBreak!adding other elements!private! !
!WebElement categoriesFor: #addButtonText:!adding form elements!private! !
!WebElement categoriesFor: #addButtonText:action:!adding form elements!private! !
!WebElement categoriesFor: #addCheckboxAspect:for:!adding form elements!private! !
!WebElement categoriesFor: #addCheckboxObject:from:!adding form elements!private! !
!WebElement categoriesFor: #addComment:!adding other elements!private! !
!WebElement categoriesFor: #addDateInputFieldAspect:for:!adding ajax components!private! !
!WebElement categoriesFor: #addErrorReport!adding other elements!private! !
!WebElement categoriesFor: #addGif:!adding images!private! !
!WebElement categoriesFor: #addGif:size:!adding images!private! !
!WebElement categoriesFor: #addHelpLink!adding other elements!private! !
!WebElement categoriesFor: #addImage:!adding images!private! !
!WebElement categoriesFor: #addImage:imageMap:!adding images!private! !
!WebElement categoriesFor: #addImage:size:!adding images!private! !
!WebElement categoriesFor: #addImage:size:align:!adding images!private! !
!WebElement categoriesFor: #addImage:size:valign:!adding images!private! !
!WebElement categoriesFor: #addInPlaceEditableTextAspect:for:!adding ajax components!private! !
!WebElement categoriesFor: #addInPlaceEditableTextAspect:for:size:!adding ajax components!private! !
!WebElement categoriesFor: #addInPlaceEditableTextAspect:for:size:allow:!adding ajax components!private! !
!WebElement categoriesFor: #addInputFieldAspect:for:!adding form elements!private! !
!WebElement categoriesFor: #addInputFieldAspect:for:size:!adding form elements!private! !
!WebElement categoriesFor: #addJpeg:!adding images!private! !
!WebElement categoriesFor: #addJpeg:size:!adding images!private! !
!WebElement categoriesFor: #addLinkTo:gif:title:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:gif:title:size:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:gif:title:view:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:gif:title:view:parameter:value:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:image:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:image:parameter:value:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:image:size:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:image:view:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:jpeg:title:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:jpeg:title:view:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:message:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:png:title:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:png:title:view:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:png:title:view:parameter:value:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:text:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:text:attributes:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:text:header:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:text:parameter:value:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:text:parameter:value:parameter:value:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:text:view:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:text:view:parameter:value:!adding links!private! !
!WebElement categoriesFor: #addLinkTo:text:view:parameter:value:parameter:value:!adding links!private! !
!WebElement categoriesFor: #addListboxWithList:size:!adding form elements!private! !
!WebElement categoriesFor: #addLiveImage:!adding images!private! !
!WebElement categoriesFor: #addLiveImage:imageMap:!adding images!private! !
!WebElement categoriesFor: #addMenuAspect:collection:selected:!adding form elements!private! !
!WebElement categoriesFor: #addMenuAspect:collection:selectedToAspect:of:!adding form elements!private! !
!WebElement categoriesFor: #addMenuCollection:selected:!adding form elements!private! !
!WebElement categoriesFor: #addMenuCollection:selectedToAspect:of:!adding form elements!private! !
!WebElement categoriesFor: #addMethodImage:!adding images!private! !
!WebElement categoriesFor: #addMethodImage:size:!adding images!private! !
!WebElement categoriesFor: #addNbSp!adding other elements!private! !
!WebElement categoriesFor: #addNbSp:!adding other elements!private! !
!WebElement categoriesFor: #addPageBreak!adding other elements!private! !
!WebElement categoriesFor: #addParagraph!adding other elements!private! !
!WebElement categoriesFor: #addPasswordFieldAspect:for:!adding form elements!private! !
!WebElement categoriesFor: #addPasswordFieldAspect:for:size:!adding form elements!private! !
!WebElement categoriesFor: #addPDFLinkTo:!adding links!private! !
!WebElement categoriesFor: #addPng:!adding images!private! !
!WebElement categoriesFor: #addPng:size:!adding images!private! !
!WebElement categoriesFor: #addRichEditorAspect:for:!adding ajax components!private! !
!WebElement categoriesFor: #addRichEditorAspect:for:size:!adding ajax components!private! !
!WebElement categoriesFor: #addRulerSize:!adding other elements!private! !
!WebElement categoriesFor: #addSecureLinkTo:text:!adding links!private! !
!WebElement categoriesFor: #addSecureLinkTo:text:parameter:value:!adding links!private! !
!WebElement categoriesFor: #addSecureLinkTo:text:view:!adding links!private! !
!WebElement categoriesFor: #addSpace!adding text!private! !
!WebElement categoriesFor: #addText:!adding text!private! !
!WebElement categoriesFor: #addText:attributes:!adding text!private! !
!WebElement categoriesFor: #addText:attributes:color:!adding text!private! !
!WebElement categoriesFor: #addText:attributes:font:!adding text!private! !
!WebElement categoriesFor: #addText:attributes:font:color:!adding text!private! !
!WebElement categoriesFor: #addText:color:!adding text!private! !
!WebElement categoriesFor: #addText:font:!adding text!private! !
!WebElement categoriesFor: #addText:font:color:!adding text!private! !
!WebElement categoriesFor: #addText:header:!adding text!private! !
!WebElement categoriesFor: #addText:header:color:!adding text!private! !
!WebElement categoriesFor: #addText:header:font:!adding text!private! !
!WebElement categoriesFor: #addText:header:font:color:!adding text!private! !
!WebElement categoriesFor: #addText:style:!adding text!private! !
!WebElement categoriesFor: #addTextAreaAspect:for:!adding form elements!private! !
!WebElement categoriesFor: #addTextAreaAspect:for:size:!adding form elements!private! !
!WebElement categoriesFor: #addTextAspect:for:!adding text!private! !
!WebElement categoriesFor: #addTextAspect:for:attributes:!adding text!private! !
!WebElement categoriesFor: #addTextBig:!adding text!private! !
!WebElement categoriesFor: #addTextBold:!adding text!private! !
!WebElement categoriesFor: #addTextBoldAspect:for:!adding text!private! !
!WebElement categoriesFor: #addTextCode:!adding text!private! !
!WebElement categoriesFor: #addTextH1:!adding text!private! !
!WebElement categoriesFor: #addTextH2:!adding text!private! !
!WebElement categoriesFor: #addTextH3:!adding text!private! !
!WebElement categoriesFor: #addTextH4:!adding text!private! !
!WebElement categoriesFor: #addTextH5:!adding text!private! !
!WebElement categoriesFor: #addTextItalic:!adding text!private! !
!WebElement categoriesFor: #addTextPreformated:!adding text!private! !
!WebElement categoriesFor: #addTextSmall:!adding text!private! !
!WebElement categoriesFor: #ajaxCallUrl!private!private-ajax! !
!WebElement categoriesFor: #ajaxCallUrlExtended!private!private-ajax! !
!WebElement categoriesFor: #ajaxCallUrlParametersFor:!private!private-ajax! !
!WebElement categoriesFor: #allElements!accessing!private! !
!WebElement categoriesFor: #allElementsOfClass:!private!subelements! !
!WebElement categoriesFor: #allOOLinks!accessing!private! !
!WebElement categoriesFor: #app!accessing!private! !
!WebElement categoriesFor: #attributes!private!private-attributes! !
!WebElement categoriesFor: #attributesAt:!private!private-attributes! !
!WebElement categoriesFor: #attributesAt:add:!private!private-attributes! !
!WebElement categoriesFor: #attributesAt:put:!private!private-attributes! !
!WebElement categoriesFor: #cell!private!tables! !
!WebElement categoriesFor: #cell:!private! !
!WebElement categoriesFor: #checkAndInitElements!private!testing! !
!WebElement categoriesFor: #class:!attributes!private! !
!WebElement categoriesFor: #clear!private!subelements! !
!WebElement categoriesFor: #clearTableInfo!private!tables! !
!WebElement categoriesFor: #colorValue:!private! !
!WebElement categoriesFor: #div!private! !
!WebElement categoriesFor: #div:!private! !
!WebElement categoriesFor: #elements!private! !
!WebElement categoriesFor: #eol!private!private-identation! !
!WebElement categoriesFor: #first!private!subelements! !
!WebElement categoriesFor: #firstAppFromStack!private! !
!WebElement categoriesFor: #firstSessionFromStack!private! !
!WebElement categoriesFor: #helpLink!accessing!private! !
!WebElement categoriesFor: #hide!events-ajax!private! !
!WebElement categoriesFor: #id!attributes!private! !
!WebElement categoriesFor: #id:!attributes!private! !
!WebElement categoriesFor: #ident!private!private-identation! !
!WebElement categoriesFor: #identationLevel!private!private-identation! !
!WebElement categoriesFor: #identDepth!private!private-identation! !
!WebElement categoriesFor: #identDepth:!private!private-identation! !
!WebElement categoriesFor: #identMore!private!private-identation! !
!WebElement categoriesFor: #initAttributes!initialize-release!private! !
!WebElement categoriesFor: #initElements!initialize-release!private! !
!WebElement categoriesFor: #initScripts!initialize-release!private! !
!WebElement categoriesFor: #initTable!initialize-release!private! !
!WebElement categoriesFor: #insideDivTag!private! !
!WebElement categoriesFor: #isComposite!private!testing! !
!WebElement categoriesFor: #isFormElement!private!testing! !
!WebElement categoriesFor: #isNewline!private!private-identation! !
!WebElement categoriesFor: #isWebElement!private!testing! !
!WebElement categoriesFor: #isWebPage!private!testing! !
!WebElement categoriesFor: #last!private!subelements! !
!WebElement categoriesFor: #level!private!private-identation! !
!WebElement categoriesFor: #method!private! !
!WebElement categoriesFor: #method:!private! !
!WebElement categoriesFor: #newCell!private!tables! !
!WebElement categoriesFor: #newRow!private!tables! !
!WebElement categoriesFor: #newTable!private!tables! !
!WebElement categoriesFor: #onClick:!events!private! !
!WebElement categoriesFor: #onClickHide:!events-ajax!private! !
!WebElement categoriesFor: #onClickShow:!events-ajax!private! !
!WebElement categoriesFor: #onClickToggle:!events-ajax!private! !
!WebElement categoriesFor: #onClickUpdate:!events-ajax!private! !
!WebElement categoriesFor: #onClickUpdate:with:!events-ajax!private! !
!WebElement categoriesFor: #onDblClick:!events!private! !
!WebElement categoriesFor: #onKeyDown:!events!private! !
!WebElement categoriesFor: #onKeyPress:!events!private! !
!WebElement categoriesFor: #onKeyUp:!events!private! !
!WebElement categoriesFor: #onMouseDown:!events!private! !
!WebElement categoriesFor: #onMouseMove:!events!private! !
!WebElement categoriesFor: #onMouseOut:!events!private! !
!WebElement categoriesFor: #onMouseOutHide:!events-ajax!private! !
!WebElement categoriesFor: #onMouseOutShow:!events-ajax!private! !
!WebElement categoriesFor: #onMouseOver:!events!private! !
!WebElement categoriesFor: #onMouseOverHide:!events-ajax!private! !
!WebElement categoriesFor: #onMouseOverShow:!events-ajax!private! !
!WebElement categoriesFor: #onMouseUp:!events!private! !
!WebElement categoriesFor: #parent!accessing!private! !
!WebElement categoriesFor: #parent:!private! !
!WebElement categoriesFor: #prepareAttributesToPrintOn:!printing!private! !
!WebElement categoriesFor: #prepareToHTMLPrintOn:!printing!private! !
!WebElement categoriesFor: #printAttribute:value:on:for:!printing!private! !
!WebElement categoriesFor: #printAttributesOn:for:!printing!private! !
!WebElement categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebElement categoriesFor: #registerId!attributes!private! !
!WebElement categoriesFor: #row!private!tables! !
!WebElement categoriesFor: #row:!private! !
!WebElement categoriesFor: #script:!private!scripts! !
!WebElement categoriesFor: #scriptAfter!private! !
!WebElement categoriesFor: #scriptAfter:!private!scripts! !
!WebElement categoriesFor: #scriptBefore!private! !
!WebElement categoriesFor: #scriptBefore:!private!scripts! !
!WebElement categoriesFor: #session!accessing!private! !
!WebElement categoriesFor: #setCreationMethod!private! !
!WebElement categoriesFor: #setNewline!private!private-identation! !
!WebElement categoriesFor: #shouldIdent!private!private-identation! !
!WebElement categoriesFor: #show!events-ajax!private! !
!WebElement categoriesFor: #site!accessing!private! !
!WebElement categoriesFor: #style!accessing!private! !
!WebElement categoriesFor: #style:!attributes!private! !
!WebElement categoriesFor: #table!private!tables! !
!WebElement categoriesFor: #table:!private! !
!WebElement categoriesFor: #title:!attributes!private! !
!WebElement categoriesFor: #toogle!events-ajax!private! !

!WebElement class methodsFor!

colorDictionary
	"return a dictionary of color names as keys and hex values for colors in 
	some web elements such as page and table background, text, links etc."
	Colors isNil ifTrue: [self initColorDictionary].
	^Colors!

initColorDictionary
	"WebElement initColorDictionary"
	"WebElement colorDictionary"
	Colors := IdentityDictionary new.
	Colors 
		at: #white				put: #'ffffff';
		at: #red					put: #'ff0000' ;
		at: #green				put: #'00ff00' ;
		at: #blue				put: #'0000ff' ;
		at: #magenda			put: #'ff00ff';
		at: #cyan				put: #'00ffff' ;
		at: #yellow				put: #'ffff00' ;
		at: #black				put: #'000000';

		at: #aquamarine			put: #'70db93';

		at: #bakerschocolade	put: #'5c3317';
		at: #blueviolet	put: #'9f5f9f';
		at: #brass		put: #'b5a642';
		at: #brightgold	put: #'d9d919';
		at: #brown		put: #'a62a2a';
		at: #bronze		put: #'8c7853';
		at: #bronzeii		put: #'a67d3d';

		at: #cadetblue		put: #'5f9f9f';
		at: #coolcooper		put: #'d98719';
		at: #cooper			put: #'b87333';
		at: #coral			put: #'ff7f00';
		at: #cornflowerblue	put: #'42426f';

		at: #darkbrown		put: #'5c4033';
		at: #darkgreen		put: #'2f4f2f';
		at: #darkgreencooper put: #'4a766e';
		at: #darkolivegreen	put: #'4f4f2f';
		at: #darkorchid		put: #'9932cd';
		at: #darkpurple		put: #'871f78';
		at: #darkslateblue	put: #'6b238e';
		at: #darkslategrey	put: #'2f4f4f';
		at: #darktan			put: #'97694f';
		at: #darkturquoise	put: #'7093db';
		at: #darkwood		put: #'855e42';
		at: #dimgrey		put: #'545454';
		at: #dustyrose		put: #'856363';

		at: #feldspar			put: #'d19275';
		at: #firebrick			put: #'8e2323';
		at: #forestgreen		put: #'238e23';

		at: #gold			put: #'cd7f32';
		at: #goldenrod		put: #'dbdb70';
		at: #grey			put: #'c0c0c0';
		at: #greencooper	put: #'527f76';
		at: #greenyellow		put: #'93db70';

		at: #huntergreen		put: #'215e21';

		at: #indianred		put: #'4e2f2f';

		at: #khaki		 	put: #'9f9f5f';

		at: #lightblue		put: #'c0d9d9';
		at: #lightgrey		put: #'a8a8a8';
		at: #lightsteelblue	put: #'8f8fbd';
		at: #lightwood		put: #'e9c2a6';
		at: #limegreen		put: #'32cd32';

		at: #mandarianorange	put: #'e47833';
		at: #maroon			put: #'8e236b';
		at: #mediumaquamarine	put: #'32cd99';
		at: #mediumblue	put: #'3232cd';
		at: #mediumforestgreen	put: #'6b8e23';
		at: #mediumgoldenrod	put: #'eaeaae';
		at: #mediumorchid	put: #'9370db';
		at: #mediumseagreen	put: #'426f42';
		at: #mediumslateblue	put: #'7f00ff';
		at: #mediumspringgreen	put: #'7fff00';
		at: #mediumturquoise	put: #'70dbdb';
		at: #mediumvioletred		put: #'db7093';
		at: #mediumwood	put: #'a68064';
		at: #midnightblue	put: #'2f2f4f';
		
		at: #navyblue		put: #'23238e ';
		at: #neonblue		put: #'4d4dff';
		at: #neonpink		put: #'ff6ec7';
		at: #newmidnightblue	put: #'00009c';
		at: #newtan			put: #'ebc79e ';
		
		at: #oldgold			put: #'cfb53b ';
		at: #orange			put: #'ff7f00';
		at: #orangered		put: #'ff2400';
		at: #orchid			put: #'db70db';

		at: #palegreen		put: #'8fbc8f';
		at: #pink			put: #'bc8f8f';
		at: #plum			put: #'eaadea';

		at: #quartz			put: #'d9d9f3';

		at: #richblue			put: #'5959ab';

		at: #salmon			put: #'6f4242';
		at: #scarlet			put: #'8c1717';
		at: #seagreen		put: #'238e68';
		at: #semiswetchocolate		put: #'6b4226';
		at: #sienna			put: #'8e6b23';
		at: #silver			put: #'e6e8fa';
		at: #skyblue			put: #'3299cc';
		at: #slateblue		put: #'007fff';
		at: #spicypink		put: #'ff1cae';
		at: #springgreen		put: #'00ff7f';
		at: #steelblue		put: #'236b8e';
		at: #summersky		put: #'38b0de';

		at: #tan				put: #'db9370';
		at: #thistle			put: #'d8bfd8';
		at: #turquoise		put: #'adeaea';

		at: #verydarkbrown	put: #'5c4033';
		at: #verylightgrey	put: #'cdcdcd';
		at: #violet			put: #'4f2f4f';
		at: #violetred		put: #'cc3299';

		at: #wheat			put: #'d8d8bf';
		at: #yellowgreen		put: #'99cc32'.!

new
	| instance |
	instance := super new.
	self == WebElement ifTrue: [instance setCreationMethod].
	^instance!

newClass: aSymbol
	"new with CSS class as specified"
	^self new class: aSymbol!

newDiv
	"element enclosed in div tag"
	^self new div: true!

newId: aSymbol
	"new with id as specified"
	^self new id: aSymbol!

printWebPageFor: aSession

	"do a page of all colors in a color dicionary"

	| colors page table col |
	colors := self colorDictionary keys.
	page := WebPage new.
	page title: 'Web Color Table'.
	table := WebTable new.
	col := 0. 
	table add: WebTableRow new.
	colors do: [:color |
		(col \\ 5 = 0) ifTrue: [table add: WebTableRow new]. col := col + 1.
		table add: (WebTableCell new bgColor: (self valueForColor: color); 
			addBreak; 
			addText: '<font face=helvetica size=-1>';
			addText: (color printString); addBreak;
			addText: ((self valueForColor: color) printString); addBreak;
			addText: (color printString) color: #white; addBreak;
			addText: ((self valueForColor: color) printString) color: #white; addBreak;
			addText: '</font>').
		].
	page add: table.
	^page

"WebElement printWebPageFor: (WebSession new)"!

valueForColor: aColorSymbolOrString
	"return a hex value for specified color. Case of color string is not important. 
	return red if color is unknown"
	| color |
	color := aColorSymbolOrString asString asLowercase asSymbol.
	^self colorDictionary at: color ifAbsent: [^self colorDictionary at: #red].

"
WebElement valueForColor: 'blue' 
"! !
!WebElement class categoriesFor: #colorDictionary!color values!private! !
!WebElement class categoriesFor: #initColorDictionary!color values!private! !
!WebElement class categoriesFor: #new!instance creation!private! !
!WebElement class categoriesFor: #newClass:!instance creation!private! !
!WebElement class categoriesFor: #newDiv!instance creation!private! !
!WebElement class categoriesFor: #newId:!instance creation!private! !
!WebElement class categoriesFor: #printWebPageFor:!printing!private! !
!WebElement class categoriesFor: #valueForColor:!color values!private! !

WebGridColumn guid: (GUID fromString: '{DB587F7B-5565-46E1-85FE-182480A257D7}')!
WebGridColumn comment: ''!
!WebGridColumn categoriesForClass!Unclassified! !
!WebGridColumn methodsFor!

addBlock
	^addBlock!

addBlock: aBlock
	"result must be kind of WebElement which will be added to table cell"
	"block needs a row object as an argument"
	addBlock := aBlock!

addToSummary: anObject
	self summaryType = #count ifTrue: [^self summary: self summary + 1].
	self summaryType = #sum ifTrue:
		[^self summary: self summary + (anObject perform: self aspect)]!

align
	^align!

align: aSymbol
	align := aSymbol!

aspect
	^aspect!

aspect: aSymbol
	"a method to be called for this column on objects of current row in a collection"
	aspect := aSymbol!

autoConvert: anObject
	(anObject class == Date and: [self parent hasShortDates]) ifTrue: [^anObject shorterPrintSloString].
	(anObject = 0 and: [self parent hasNoZeros]) ifTrue: [^''].
	^WebFormElement autoConvertToString: anObject!

defaultViewBlock
	^[:object | 
		self aspect isNil ifTrue: [''] ifFalse: [self autoConvert: (object perform: self aspect) ] ]!

filter
	^filter!

filter: aString
	"show only rows with value starting with aString"
	filter := aString!

hasAddBlock
	^self addBlock notNil!

hasLink
	^self linkAspect notNil | self linkView notNil!

id
	^id!

id: aSymbolOrNumber
	"by default it is a position (1st, 2nd etc.)"
	id := aSymbolOrNumber!

initialize!

isCheckboxed
	self parent checkboxes isNil ifTrue: [^false].
	^self parent checkboxes = self id!

isNumbered
	self parent numbering isNil ifTrue: [^false].
	^self parent numbering = self id!

isSortedAscending
	^(self parent sortColumn = self id) and: [self parent sortOrder = #ascending]!

isSortedDescending
	^(self parent sortColumn = self id) and: [self parent sortOrder = #descending]!

linkAspect
	^linkAspect!

linkAspect: aSymbol
	"if set, a link to aspect of  row object will be made"
	linkAspect := aSymbol.!

linkView
	^linkView!

linkView: aSymbol
	"if set, a link to aspect of  row object (spesified with linkAspect:) with that view will be shown"
	linkView := aSymbol.!

name
	^name!

name: aString
	"header name for that column"
	name := aString!

needsSummary
	"summary row is needed"
	^self summaryType notNil!

needsSummaryCount
	^self summaryType notNil and: [self summaryType = #count]!

needsSummarySum
	^self summaryType notNil and: [self summaryType = #sum]!

parent
	^parent!

parent: anObject
	parent := anObject!

printString
	^'aWebGridColumn id: ', self id printString!

resetSummary
	(self summary notNil and: [self summary isKindOf: Number]) 
		ifTrue: [self summary: 0].!

setFilter
	"this column will have a filter input field in a row below header"
	self filter: ''!

sort
	self parent sortColumn == self id
		ifTrue: [self toggleSortOrder]
		ifFalse: [self sortAscending]!

sortAscending
	self parent sortAscendingOn: self id!

sortDescending
	self parent sortDescendingOn: self id!

sorted
	^sorted!

sorted: aSymbol
	"nil #ascending #descending"
	sorted := aSymbol!

summary
	"here summary of all rows is acumulated, depending on summaryType"
	^summary!

summary: aNumber
	"see comment in method #summary"
	summary := aNumber!

summaryType
	"summary row is added with appropriate value, which can be:
	- #sum : sum of all cels in that column
	- #count : number of all rows, without heading and summary
	- 'some text' to be shown in this summary cell"
	^summaryType!

summaryType: aSymbolOrString
	"see comment in method #summary"
	summaryType := aSymbolOrString.
	(aSymbolOrString = #count) | (aSymbolOrString = #sum)
		ifTrue: [self summary: 0]
		ifFalse: [self summary: aSymbolOrString].!

summaryValue
	"for adding to a table"
	self summary isNil ifTrue: [^''].
	(self summary isKindOf: Number) ifTrue: [^self summary printDotString].
	^self summary "as text"!

toggleSortOrder
	self parent sortColumn == self id
		ifTrue: [self parent sortOrder == #descending
			ifTrue: [self sortAscending]
			ifFalse: [self sortDescending]]
		ifFalse: [self sortAscending]!

viewBlock
	viewBlock isNil ifTrue: [self viewBlock: self defaultViewBlock].
	^viewBlock!

viewBlock: aBlock
	"how to show this column from collection. There is a default"
	"block needs a row object as an argument"
	viewBlock := aBlock!

width
	^width!

width: aNumber
	width := aNumber! !
!WebGridColumn categoriesFor: #addBlock!private!private-accessing! !
!WebGridColumn categoriesFor: #addBlock:!private!settings! !
!WebGridColumn categoriesFor: #addToSummary:!private! !
!WebGridColumn categoriesFor: #align!private!private-accessing! !
!WebGridColumn categoriesFor: #align:!private!settings! !
!WebGridColumn categoriesFor: #aspect!private!private-accessing! !
!WebGridColumn categoriesFor: #aspect:!private!settings! !
!WebGridColumn categoriesFor: #autoConvert:!private! !
!WebGridColumn categoriesFor: #defaultViewBlock!private! !
!WebGridColumn categoriesFor: #filter!private!private-accessing! !
!WebGridColumn categoriesFor: #filter:!private!private-accessing! !
!WebGridColumn categoriesFor: #hasAddBlock!private!testing! !
!WebGridColumn categoriesFor: #hasLink!private!testing! !
!WebGridColumn categoriesFor: #id!private!private-accessing! !
!WebGridColumn categoriesFor: #id:!private!settings! !
!WebGridColumn categoriesFor: #initialize!initialize-release!private! !
!WebGridColumn categoriesFor: #isCheckboxed!private!testing! !
!WebGridColumn categoriesFor: #isNumbered!private!testing! !
!WebGridColumn categoriesFor: #isSortedAscending!private!testing! !
!WebGridColumn categoriesFor: #isSortedDescending!private!testing! !
!WebGridColumn categoriesFor: #linkAspect!private!private-accessing! !
!WebGridColumn categoriesFor: #linkAspect:!private!settings! !
!WebGridColumn categoriesFor: #linkView!private!private-accessing! !
!WebGridColumn categoriesFor: #linkView:!private!settings! !
!WebGridColumn categoriesFor: #name!private!private-accessing! !
!WebGridColumn categoriesFor: #name:!private!settings! !
!WebGridColumn categoriesFor: #needsSummary!private!testing! !
!WebGridColumn categoriesFor: #needsSummaryCount!private!testing! !
!WebGridColumn categoriesFor: #needsSummarySum!private!testing! !
!WebGridColumn categoriesFor: #parent!private!private-accessing! !
!WebGridColumn categoriesFor: #parent:!private! !
!WebGridColumn categoriesFor: #printString!private! !
!WebGridColumn categoriesFor: #resetSummary!private! !
!WebGridColumn categoriesFor: #setFilter!private!settings! !
!WebGridColumn categoriesFor: #sort!private!settings! !
!WebGridColumn categoriesFor: #sortAscending!private!settings! !
!WebGridColumn categoriesFor: #sortDescending!private!settings! !
!WebGridColumn categoriesFor: #sorted!private!private-accessing! !
!WebGridColumn categoriesFor: #sorted:!private!private-accessing! !
!WebGridColumn categoriesFor: #summary!private!private-accessing! !
!WebGridColumn categoriesFor: #summary:!private!private-accessing! !
!WebGridColumn categoriesFor: #summaryType!private!settings! !
!WebGridColumn categoriesFor: #summaryType:!private!settings! !
!WebGridColumn categoriesFor: #summaryValue!private!private-accessing! !
!WebGridColumn categoriesFor: #toggleSortOrder!private!settings! !
!WebGridColumn categoriesFor: #viewBlock!private!private-accessing! !
!WebGridColumn categoriesFor: #viewBlock:!private!settings! !
!WebGridColumn categoriesFor: #width!private!private-accessing! !
!WebGridColumn categoriesFor: #width:!private!settings! !

!WebGridColumn class methodsFor!

newOn: aWebGrid
	^super new initialize parent: aWebGrid! !
!WebGridColumn class categoriesFor: #newOn:!instance creation!private! !

WebHelp guid: (GUID fromString: '{E649274A-316C-48F5-AC68-921C16107B2A}')!
WebHelp comment: 'WebHelp for easy made of help system. each view of each App can have its own help page. Each aWebHelpPage has url like http://www.server.com/help/AdminApp/main.html for view #main in AdminApp.


Instance Variables:
	pages	<Dictionary of Dictionary> key=App class name, 
											value=dictionary key: view, value aWebHelpPage

'!
!WebHelp categoriesForClass!Unclassified! !
!WebHelp methodsFor!

add: aWebHelpPage
	self forApp: aWebHelpPage app view: aWebHelpPage view put: aWebHelpPage!

existApp: anApp view: aSymbol
	^(self forApp:anApp view: aSymbol) notNil!

forApp: anApp view: aSymbol
	| appName |
	appName := (anApp isKindOf: WebApplication) ifTrue: [anApp class name] ifFalse: [anApp].
	^(self pages at: appName ifAbsent: [^nil]) at: aSymbol asSymbol ifAbsent: [nil]!

forApp: anApp view: aSymbol put: aWebHelpPage
	| appName |
	appName := (anApp isKindOf: WebApplication) ifTrue: [anApp class name] ifFalse: [anApp].
	(self pages at: appName ifAbsentPut: [Dictionary new]) at: aSymbol asSymbol put: aWebHelpPage!

initPages
	pages := Dictionary new.!

pages
	pages isNil ifTrue: [self initPages].
	^pages! !
!WebHelp categoriesFor: #add:!accessing!private! !
!WebHelp categoriesFor: #existApp:view:!accessing!private! !
!WebHelp categoriesFor: #forApp:view:!accessing!private! !
!WebHelp categoriesFor: #forApp:view:put:!accessing!private! !
!WebHelp categoriesFor: #initPages!initialize-release!private! !
!WebHelp categoriesFor: #pages!private! !

WebHelpPage guid: (GUID fromString: '{7B737672-4DC1-440F-99BE-B87045AD9C9D}')!
WebHelpPage comment: 'WebHelpPage contains help for particulal view on particular WebApp

Instance Variables:
	parent	<WebHelp>	back link to WebHelp
	app		<Symbol>	a name of WebApplication subclass
	view	<Symbol>	view of app for which is this help page
	title		<String>	 	title of that help page
	body	<String>	   	help content for that App and view in Wiki format

'!
!WebHelpPage categoriesForClass!Unclassified! !
!WebHelpPage methodsFor!

app
	^app!

app: aSymbol
	app := aSymbol!

body
	body isNil ifTrue: [^''].
	^body!

body: aString
	body := aString!

parent
	^parent!

parent: aWebHelp
	parent := aWebHelp!

preferedUrl
	^'/help/',  self app asString, '/', self view asString, '.html'!

title
	title isNil ifTrue: [^''].
	^title!

title: anObject
	title := anObject!

view
	^view!

view: aSymbol
	view := aSymbol! !
!WebHelpPage categoriesFor: #app!accessing!private! !
!WebHelpPage categoriesFor: #app:!accessing!private! !
!WebHelpPage categoriesFor: #body!accessing!private! !
!WebHelpPage categoriesFor: #body:!accessing!private! !
!WebHelpPage categoriesFor: #parent!accessing!private! !
!WebHelpPage categoriesFor: #parent:!accessing!private! !
!WebHelpPage categoriesFor: #preferedUrl!accessing!private! !
!WebHelpPage categoriesFor: #title!accessing!private! !
!WebHelpPage categoriesFor: #title:!accessing!private! !
!WebHelpPage categoriesFor: #view!accessing!private! !
!WebHelpPage categoriesFor: #view:!accessing!private! !

!WebHelpPage class methodsFor!

newForApp: anAppNameSymbol view: aSymbol parent: aWebHelp
	^super new
		app: anAppNameSymbol;
		view: aSymbol;
		parent: aWebHelp! !
!WebHelpPage class categoriesFor: #newForApp:view:parent:!instance creation!private! !

WebIndex guid: (GUID fromString: '{EA4362CF-C337-4FCF-A03C-BD0CC8701367}')!
WebIndex comment: ''!
!WebIndex categoriesForClass!Unclassified! !
!WebIndex methodsFor!

addFreshnessRelevance: aDictionary
	"objects with newer modified date are more relevant"

	| weight |
	aDictionary keysDo: [:object |
		(object class selectors includes: #modified) ifTrue:
			[weight := 1000 - (Date today subtractDate: object modified) max: 0.
			aDictionary 
				at: object
				put:  (aDictionary at: object) + weight] ]!

addVisitsRelevance: aDictionary
	"objects with more visits are more relevant"

	| weight |
	aDictionary keysDo: [:object |
		(object class selectors includes: #modified) ifTrue:
			[weight := 1000 - (Date today subtractDate: object modified) max: 0.
			aDictionary 
				at: object
				put:  (aDictionary at: object) + weight] ]!

allPopularWordsAndCounts
	"return a collection of words and their total counts, most popular first"

	| collection |
	collection := OrderedCollection new.
	self popularWords keysAndValuesDo: [:word :counter |  
		collection add: (Array 
			with: word
			with: counter total)].
	^SortedCollection
		withAll: collection
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].!

allWordsAndWeights

	"return sorted collection of all words and sum of weights, biggeest weight first"

	| collection weight |
	collection := OrderedCollection new.
	self index keysDo: [:halfWord |
		(self index at: halfWord) keysDo: [:restWord |
			weight := ((self index at: halfWord) at: restWord) inject: 0 into: 
				[:sum :thirdDictWeight | sum + (thirdDictWeight)].
			collection add: (Array
				with: halfWord, restWord
				with: weight) ] ].
	^SortedCollection 
		withAll: collection
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].

" WebIndex default allWordsAndWeights "!

countPopularWords: anArray
	
	anArray do: [:word |
		(self popularWords includesKey: word) 
			ifFalse: [self openPopularWord: word].
		(self popularWords at: word) incCounter].!

gemIndexObject: anObject

	"forward call to privIndexObject to Gemstone"

	| words |
"	WebTransactionMonitor critical: "
		(anObject class selectors includes: #indexText) ifTrue:
			[words := self wordsInText: anObject indexText.
			self cachedProxy
				gsindexWords: words inObject: anObject]!

gemObjectsForWord: aString

	"find all objects, which include this word. Return more important objects first (more occurences of worlds etc.)"

	| hits secDic searchWord keys word |
	(self isValidWord: aString) ifTrue:
		[hits := IdentityDictionary new.
		word := self prepareWord: aString.
		searchWord := (self restWordFrom: word), '*'.
		secDic := self index at: (self halfWordFrom: word) ifAbsent: [^hits].
		keys := secDic keys select: [:fkey | searchWord match: fkey].
		keys do: 
			[:skey | (secDic at: skey) keysAndValuesDo:
				[:tkey :tvalue | 
					(hits includesKey: tkey) ifFalse: [hits at: tkey put: 0].
					hits at: tkey put: (hits at: tkey)+tvalue.
				]
			].
		^hits.
		]
		ifFalse: [^nil].

"(WebIndex default objectsForWord: 'knjiga') keys "!

halfWordFrom: aString

		"prepare first three letters, lowercase (also slovene chars)"
		^AIDASite sloveneLowercase: (aString copyFrom: 1 to: 3).!

index
	"index is a dictionary with first three lowercase letters of each indexed world as key and
	another dictionary for remaining letters as value. The second dictionary has remaining letters for key and dictionary with objects, where this word occured, as key and number of occurences as value"

	index isNil ifTrue: [self initIndex].
	^index!

indexedObjects
	"return a dictionary with objects which worlds are in index as keys and a set of pointers to third level dictionary in index as values"

	indexedObjects isNil ifTrue: [self initIndexedObjects].
	^indexedObjects!

indexerProcess

	"this background process wait for objects to be indexed in workQueue and
	index them without disturbing others."


	[true] whileTrue: 
		[self privIndexObject: self workQueue next.
		Transcript show: 'i'.
		].!

indexObject: anObject
	"if anObject responds to a message indexText, then index all its world in index.
	 However, first 	remove indexing for that object if already exist (so, for reindexing  
	objects, use this method also). For performance reasons indexing is done in background"

	self workQueue nextPut: anObject.

"WebIndex default indexObject: WebIndex default"!

indexObjects: aCollection
	aCollection do: [:each | self indexObject: each].!

indexText
	^'Search engine iskanje rezultati iskanja iskalnik'!

indexTitle
	^'Iskalnik'!

indexWord: aString inObject: anObject

	"put a word in that object in index if word is valid one for indexing"

	self indexWord: aString occurences: 1 inObject: anObject!

indexWord: aString occurences: aNumber inObject: anObject
	"put a aNumber occurences of a word in that object in index if word is valid one for indexing"
	| halfWord restWord secDic thirdDic num |
	(self isValidWord: aString) ifTrue:
		"put an object in indexed object, if not already exist"
		[(self indexedObjects includesKey: anObject) ifFalse:
			[self indexedObjects at: anObject put: IdentitySet new].
		"prepare two parts of a words, first three letters and rest"
		halfWord := self halfWordFrom: aString.
		restWord := self restWordFrom: aString.
		"find or create a second level dictionary from first level one"
		secDic := self index at: halfWord 
			ifAbsent: 
				[self index at: halfWord put: Dictionary new].
		"find or create last level dictionary from second level one"
		thirdDic := secDic at: restWord 
			ifAbsent: 
				[secDic at: restWord put: Dictionary new].
		"put an object to third level dictionary and increment nr of worlds 
		if not already exist"
		num := thirdDic at: anObject ifAbsent: [thirdDic at: anObject put: 0].
		thirdDic at: anObject put: num + aNumber.
		"make reference to the third level dictionary for a indexed word"
		(self indexedObjects at: anObject) add: thirdDic.
		].!

indexWords: aWordDictionary inObject: anObject

	self removeObject: anObject.  "if exist"
	aWordDictionary keysAndValuesDo: [:key :value | 
		self indexWord: key occurences: value inObject: anObject].!

initialize
	self initIndex.
	self initIndexedObjects.
	self initPopularWords.
	workQueue := nil.

"WebIndex default initialize"!

initIndex

	index := Dictionary new.!

initIndexedObjects

	indexedObjects := IdentityDictionary new.!

initPopularWords

	popularWords := Dictionary new.!

isValidWord: aString

	"a valid word for indexing has more than three letters, without numbers, "

	(aString size > 3) ifFalse: [^false].
	aString do:[:chr | chr isDigit ifTrue: [^false] ].
	^true!

objectsForWord: aString
	"find all objects, which include this word. Return more important objects 
	first (more occurences of worlds etc.)"
	| fwHits hits |
	SwazooServer isPersistent
		ifTrue: 
			[fwHits := (self cachedProxy gsgemObjectsForWord: aString asTwoByteString) asLocalObject.	
			hits := Dictionary new.
			fwHits keys do: [:key  | hits at: key put: (fwHits at: key)].
			^hits  ]
		ifFalse: [^self privObjectsForWord: aString].

"(WebIndex default objectsForWord: 'knjiga') keys "!

objectsForWords: aString

	"find all objects, which include one or more specified words. return a sorted collection of associations with found objects as keys an relevance of them as values. Most relevant objects are first.. 
Relevance means: 
	nr. of words found * 1000 + occurences of each word"

	| words hits newHits foundWords |
	Transcript show: ' search.'.
	words := (self wordsInText: aString) keys.
	words := words select: [:word | self isValidWord: word].

	hits := IdentityDictionary new.
	foundWords := OrderedCollection new. 
	words do: [:word | 
		newHits := self objectsForWord: word.
		newHits notEmpty ifTrue: [foundWords add: word].
		newHits keysAndValuesDo: [:key :value |
			(hits includesKey: key)
				ifTrue: [hits at: key put: (hits at: key)+1000]
				ifFalse: [hits at: key put: 1000+value]
			]
		].
	self countPopularWords: foundWords.  "count as popular only words, which exist in objects"
	self addFreshnessRelevance: hits.
	Transcript show: '.ok '.
	^SortedCollection 
		withAll: hits associations
		sortBlock: [:first : second | first value > second value].

"
WebIndex instance objectsForWords: 'ljub'
"!

openPopularWord: aString
	self popularWords at: aString put: WebCounter new.!

popularWords

	"return a dictionary of words as keys and aWebCounters as values"

	popularWords isNil ifTrue: [self initPopularWords].
	^popularWords!

prepareWord: aString

	"cut last char if vowel. Used for simple declension of slovene words"

	aString last isVowel 
		ifTrue:
			[aString size > 3
				ifTrue: [^aString copyFrom: 1 to: (aString size - 1)] ].

	^aString.

"
WebIndex new prepareWord: 'knjiga'
"!

privIndexObject: anObject

	"if anObject responds to a message indexText, then index all its world in index. However, first remove indexing for that object if already exist (so, for reindexing  objects, use this method also)"

	| words |

	SwazooServer isPersistent ifTrue: [^self gemIndexObject: anObject].
	
	WebTransactionMonitor critical: 
		[(anObject class canUnderstand: #indexText) ifTrue:
			[words := self wordsInText: anObject indexText.
			self indexWords: words inObject: anObject ]
		]!

privObjectsForWord: aString

	"find all objects, which include this word. Return more important objects first (more occurences of worlds etc.)"

	| hits secDic searchWord keys word |
	(self isValidWord: aString) ifTrue:
		[hits := IdentityDictionary new.
		word := self prepareWord: aString.
		searchWord := (self restWordFrom: word), '*'.
		secDic := self index at: (self halfWordFrom: word) ifAbsent: [^hits].
		keys := secDic keys select: [:fkey | searchWord match: fkey].
		keys do: 
			[:skey | (secDic at: skey) keysAndValuesDo:
				[:tkey :tvalue | 
					(hits includesKey: tkey) ifFalse: [hits at: tkey put: 0].
					hits at: tkey put: (hits at: tkey)+tvalue.
				]
			].
		^hits.
		]
		ifFalse: [^nil].

"(WebIndex default objectsForWord: 'knjiga') keys "!

removeObject: anObject

	"remove object from all word pointers in index"


	(self indexedObjects at: anObject ifAbsent: [^nil]) do:
		[:each | each removeKey: anObject ifAbsent: [] ].
	self indexedObjects removeKey: anObject.!

restWordFrom: aString

		"preparerest of the word, lowercase (also slovene chars)"
		^AIDASite sloveneLowercase: (aString copyFrom: 4 to: aString size)!

wordsInText: aString

	"return a dictionary with all words as keys and number of occurences as values"

	| lastInx currInx word words |
	lastInx := 1.
	currInx := 1.
	words := Dictionary new. 
	aString do: [:chr | 
		(chr isAlphaNumeric or: [AIDASite isSloveneCharacter: chr])
			ifTrue: []
			ifFalse: 
				[word := aString copyFrom: lastInx to: currInx-1.
				lastInx := currInx+1.
				word := AIDASite sloveneLowercase: word.
				(word = '') ifFalse: 
					[(words includesKey: word) ifFalse: [words at: word put: 0].
					words at: word put: (words at: word) + 1.
					].			
				].
		currInx := currInx + 1.
		].
		word := aString copyFrom: lastInx to: currInx-1.
		word := AIDASite sloveneLowercase: word.
		(word = '') ifFalse: 
			[(words includesKey: word) ifFalse: [words at: word put: 0].
			words at: word put: (words at: word) + 1].
	^words

"
WebIndex instance wordsInText: 'erot ljub'
"!

workQueue

	"all object to be indexed goes in this queue. An indexer process (which is started first time
	someone requests indexing) then index an object in background"

	workQueue isNil 
		ifTrue: 
			[workQueue := SharedQueue new.
			[self indexerProcess] forkAt: Processor userBackgroundPriority.
			Transcript show: 'i'].
	^workQueue.! !
!WebIndex categoriesFor: #addFreshnessRelevance:!private!searching! !
!WebIndex categoriesFor: #addVisitsRelevance:!private!searching! !
!WebIndex categoriesFor: #allPopularWordsAndCounts!popular words!private! !
!WebIndex categoriesFor: #allWordsAndWeights!accessing!private! !
!WebIndex categoriesFor: #countPopularWords:!popular words!private! !
!WebIndex categoriesFor: #gemIndexObject:!private! !
!WebIndex categoriesFor: #gemObjectsForWord:!private! !
!WebIndex categoriesFor: #halfWordFrom:!private! !
!WebIndex categoriesFor: #index!accessing!private! !
!WebIndex categoriesFor: #indexedObjects!accessing!private! !
!WebIndex categoriesFor: #indexerProcess!private! !
!WebIndex categoriesFor: #indexObject:!indexing!private! !
!WebIndex categoriesFor: #indexObjects:!indexing!private! !
!WebIndex categoriesFor: #indexText!accessing!private! !
!WebIndex categoriesFor: #indexTitle!accessing!private! !
!WebIndex categoriesFor: #indexWord:inObject:!indexing!private! !
!WebIndex categoriesFor: #indexWord:occurences:inObject:!private! !
!WebIndex categoriesFor: #indexWords:inObject:!private! !
!WebIndex categoriesFor: #initialize!initialize-release!private! !
!WebIndex categoriesFor: #initIndex!initialize-release!private! !
!WebIndex categoriesFor: #initIndexedObjects!initialize-release!private! !
!WebIndex categoriesFor: #initPopularWords!initialize-release!private! !
!WebIndex categoriesFor: #isValidWord:!private!testing! !
!WebIndex categoriesFor: #objectsForWord:!private!searching! !
!WebIndex categoriesFor: #objectsForWords:!private!searching! !
!WebIndex categoriesFor: #openPopularWord:!popular words!private! !
!WebIndex categoriesFor: #popularWords!accessing!private! !
!WebIndex categoriesFor: #prepareWord:!private! !
!WebIndex categoriesFor: #privIndexObject:!private! !
!WebIndex categoriesFor: #privObjectsForWord:!private! !
!WebIndex categoriesFor: #removeObject:!indexing!private! !
!WebIndex categoriesFor: #restWordFrom:!private! !
!WebIndex categoriesFor: #wordsInText:!indexing!private! !
!WebIndex categoriesFor: #workQueue!private! !

!WebIndex class methodsFor!

default
	^AIDASite default index!

instVarMap
	"Gemstone"

	^super instVarMap,
		#( 	(workQueue nil) )!

new
	^super new initialize.

"WebIndex new"!

replicationSpec

	^super replicationSpec, 
		#(  	(index forwarder)
			(indexedObjects forwarder) 
			(popularWords forwarder)  	)! !
!WebIndex class categoriesFor: #default!accessing!private! !
!WebIndex class categoriesFor: #instVarMap!odb specific!private! !
!WebIndex class categoriesFor: #new!instance creation!private! !
!WebIndex class categoriesFor: #replicationSpec!odb specific!private! !

WebLiveImage guid: (GUID fromString: '{8ABC96F2-812B-4AD5-B40E-75602B71EBF5}')!
WebLiveImage comment: 'WebLiveImage is used for live, dynamic GIF image construction.

Instance Variables:
	gif			<ByteArray>	content of image in GIF format
	refreshed	<Timestamp>	timestamp of last gif creation, used for caching algoritms

'!
!WebLiveImage categoriesForClass!Unclassified! !
!WebLiveImage methodsFor!

addToCache
	self makeRoomInCache.
	self class cache add: self.!

cacheHysteresis
	"when removing from cache, make room for that number of entries"
	^10!

contentType

	"MIME type for our image"
	
	^'image/gif'!

displayOn: aGraphicsContext

	"default painting - some hello message. Subclasses should override for some more paintings"

	| composite text |
	composite := CompositePart new.
	text := 'This is a live GIF image' asText.
	text emphasizeAllWith: (Array with: #bold with: #color -> ColorValue blue).
	text := text asComposedText.
	composite add: text at: 100 @ (height/2).
	composite displayOn: aGraphicsContext.!

drawImage

	"it paints a drawing with a painter and convert it to GIF"

	| pixmap graphicsContext image stream |
	pixmap := Pixmap extent: self width @ self height.
	graphicsContext := pixmap graphicsContext.
	
	self painter displayOn: graphicsContext.

	image := pixmap asImage.
	stream := GifImageStream on: ByteArray new writeStream.
	[stream nextPutImage: image. self gif: stream contents] 
		valueNowOrOnUnwindDo: [stream close].!

elements

	"just to simulate a WebElement"

	^nil!

gif
	"returns a representation of a image in GIF format"
	^gif!

gif: aByteArray

	"also set a refreshed timestamp"

	gif := aByteArray.
	self refreshed: Timestamp now.!

height
	"height of image, default is 300 pixels"
	height isNil ifTrue: [self height: 300].
	^height!

height: anInteger
	height := anInteger.!

isWebElement
	^false!

isWebPage
	^true!

lastUsed
	"timestamp of last usage. Used for caching algorithms. Set at HTML generation"

	lastUsed isNil ifTrue: [self lastUsed: Timestamp now].
	^lastUsed!

lastUsed: aTimestamp
	"timestamp of last usage. Used for caching algorithms"

	lastUsed := aTimestamp!

makeRoomInCache
	"if cache is full, remove least used images"
	| cached  toRemove |
	self class cache size < self maxCacheSize ifTrue: [^self].
	cached := (SortedCollection 
		withAll: self class cache
		sortBlock: [:a :b | a lastUsed < b lastUsed]) asOrderedCollection.
	self cacheHysteresis timesRepeat:
		[toRemove := cached first.
		toRemove removeFromCache.
		cached removeFirst]!

maxCacheSize
	^50!

odbPreWrite
	"Versant"
	gif := nil.
	refreshed := nil.!

painter
	"painter is an object, which actually paints an image. It must respond to message displayOn: anGraphicsContect. By default, painter is self and paints some hello message. Subclasses should override displayOn: appropriately"

	painter isNil ifTrue: [self painter: self].
	^painter!

painter: anObject
	painter := anObject.!

printHTMLPageOn: aStream forSession: aSession

	"refresh gif if nesessary and put it into a HTML stream"
	Processor activeProcess priority: (Processor activeProcess priority - 3).
	self refreshNeeded ifTrue: 
		[self drawImage.
		self addToCache].
	aStream nextPutAll: self gif asByteString.
	Processor activeProcess priority: (Processor activeProcess priority + 3).
	self lastUsed: Timestamp now.

"	aSession server urlResolver removeObject: self "!

printWebPageFor: aSession


	^self!

refreshed
	"timestamp of last gif creation. Used for caching algorithms. Set,when calling gif: method"

	refreshed isNil ifTrue: [self refreshed: Timestamp now].
	^refreshed!

refreshed: aTimestamp
	"timestamp of last gif creation. Used for caching algorithms"

	refreshed := aTimestamp!

refreshNeeded
	^self gif isNil!

removeFromCache
	self class cache remove: self ifAbsent: [].
	self removeFromURLResolver.
	self gif: nil.!

removeFromURLResolver
	self resolver notNil
		ifTrue: [self resolver removeObject: self]!

resolver
	^resolver!

resolver: anObject
	resolver := anObject!

width
	"width of image, default is 500 pixels"
	width isNil ifTrue: [self width: 500].
	^width!

width: anInteger
	width := anInteger.! !
!WebLiveImage categoriesFor: #addToCache!caching!private! !
!WebLiveImage categoriesFor: #cacheHysteresis!caching!private! !
!WebLiveImage categoriesFor: #contentType!accessing!private! !
!WebLiveImage categoriesFor: #displayOn:!drawing!private! !
!WebLiveImage categoriesFor: #drawImage!drawing!private! !
!WebLiveImage categoriesFor: #elements!accessing!private! !
!WebLiveImage categoriesFor: #gif!accessing!private! !
!WebLiveImage categoriesFor: #gif:!accessing!private! !
!WebLiveImage categoriesFor: #height!accessing!private! !
!WebLiveImage categoriesFor: #height:!accessing!private! !
!WebLiveImage categoriesFor: #isWebElement!private!testing! !
!WebLiveImage categoriesFor: #isWebPage!private!testing! !
!WebLiveImage categoriesFor: #lastUsed!accessing!private! !
!WebLiveImage categoriesFor: #lastUsed:!accessing!private! !
!WebLiveImage categoriesFor: #makeRoomInCache!caching!private! !
!WebLiveImage categoriesFor: #maxCacheSize!caching!private! !
!WebLiveImage categoriesFor: #odbPreWrite!odb specific!private! !
!WebLiveImage categoriesFor: #painter!accessing!private! !
!WebLiveImage categoriesFor: #painter:!accessing!private! !
!WebLiveImage categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebLiveImage categoriesFor: #printWebPageFor:!printing!private! !
!WebLiveImage categoriesFor: #refreshed!accessing!private! !
!WebLiveImage categoriesFor: #refreshed:!accessing!private! !
!WebLiveImage categoriesFor: #refreshNeeded!private!testing! !
!WebLiveImage categoriesFor: #removeFromCache!caching!private! !
!WebLiveImage categoriesFor: #removeFromURLResolver!caching!private! !
!WebLiveImage categoriesFor: #resolver!accessing!private! !
!WebLiveImage categoriesFor: #resolver:!accessing!private! !
!WebLiveImage categoriesFor: #width!accessing!private! !
!WebLiveImage categoriesFor: #width:!accessing!private! !

!WebLiveImage class methodsFor!

cache
	Cache isNil ifTrue: [self initCache].
	^Cache!

initCache
	Cache := Set new.!

instVarMap
	"Gemstone"

	^super instVarMap,
		#( 	(gif  nil)
			(refreshed nil)
			(lastUsed nil)  )! !
!WebLiveImage class categoriesFor: #cache!accessing!private! !
!WebLiveImage class categoriesFor: #initCache!accessing!private! !
!WebLiveImage class categoriesFor: #instVarMap!odb specific!private! !

WebMethodResource guid: (GUID fromString: '{F82B180E-652E-41E0-BA84-F271E39E6994}')!
WebMethodResource comment: ''!
!WebMethodResource categoriesForClass!Unclassified! !
!WebMethodResource methodsFor!

contentType
	"MIME type for our resource"	
	contentType isNil ifTrue: [self contentType: 'image/gif'].
	^contentType!

contentType: aString
	contentType := aString!

expiresTimestamp
	"one hour from now, to avoid reloading of images" 
	^Timestamp fromSeconds: Timestamp now asSeconds + 3600!

isWebElement
	^false!

isWebPage
	^true!

method
	^method!

method: aSymbol
	method := aSymbol!

object
	^object!

object: anObject
	object := anObject!

preferedUrl
	^preferedUrl!

preferedUrl: aString
	preferedUrl := aString!

printHTMLPageOn: aStream forSession: aSession
	aStream nextPutAll: (self object perform: self method) asString.!

printWebPageFor: aSession
	^self!

site
	"a Site on which this resource will be shown"
	^site!

site: anAIDASite
	site := anAIDASite! !
!WebMethodResource categoriesFor: #contentType!accessing!private! !
!WebMethodResource categoriesFor: #contentType:!accessing!private! !
!WebMethodResource categoriesFor: #expiresTimestamp!accessing!private! !
!WebMethodResource categoriesFor: #isWebElement!private!testing! !
!WebMethodResource categoriesFor: #isWebPage!private!testing! !
!WebMethodResource categoriesFor: #method!accessing!private! !
!WebMethodResource categoriesFor: #method:!accessing!private! !
!WebMethodResource categoriesFor: #object!accessing!private! !
!WebMethodResource categoriesFor: #object:!accessing!private! !
!WebMethodResource categoriesFor: #preferedUrl!accessing!private! !
!WebMethodResource categoriesFor: #preferedUrl:!accessing!private! !
!WebMethodResource categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebMethodResource categoriesFor: #printWebPageFor:!printing!private! !
!WebMethodResource categoriesFor: #site!accessing!private! !
!WebMethodResource categoriesFor: #site:!accessing!private! !

!WebMethodResource class methodsFor!

fromMethod: aSymbol on: anObject contentType: aString preferedUrl: aString2 site: anAIDASite
	^super new
		object: anObject;
		method: aSymbol;
		contentType: aString;
		preferedUrl: aString2;
		site: anAIDASite!

fromMethod: aSymbol on: anObject contentType: aString site: anAIDASite
	^super new
		object: anObject;
		method: aSymbol;
		contentType: aString;
		site: anAIDASite! !
!WebMethodResource class categoriesFor: #fromMethod:on:contentType:preferedUrl:site:!instance creation!private! !
!WebMethodResource class categoriesFor: #fromMethod:on:contentType:site:!instance creation!private! !

WebMsgs guid: (GUID fromString: '{E7658BE1-5E4B-4BFD-8CEE-AC76E7404AD4}')!
WebMsgs comment: ''!
!WebMsgs categoriesForClass!Unclassified! !
!WebMsgs methodsFor!

at: aSymbol
	"return a message text at specificied symbol in a language, which is previosly set 
	by language: method. If not set, then default language is used"
	^(self messagesByLanguage at: self language) 
		at: aSymbol asSymbol 
			ifAbsent: 
				[self at: aSymbol put: aSymbol asString. 
				^self at: aSymbol]!

at: aSymbol put: aString
	"store  a message text at specificied symbol in a language, which is previosly set by language: 	method. If not set, then default language is used. Also opens new associations in all other
	languages, if not yet exist"
	(self messagesByLanguage at: self language) at: aSymbol put: aString.
	((self messagesByLanguage at: self language) associationAt: aSymbol).
	self messagesByLanguage keysAndValuesDo: [:key :value |
		(value includesKey: aSymbol asSymbol) 
			ifFalse: [value at: aSymbol asSymbol put: ''] ].!

initialize

	self initNewLanguage: #en.


"
WebMsgs  at: #test put: 'This is my first test'.
WebMsgs language: #hr
WebMsgs at: #test
WebMsgs instance
"!

initNewLanguage: aSymbol
	"in a messagesByLanguage dictionary open a new key and make an empty message dictionary 
	as value, but all symbol keys, which already exist in other languages"
	(self messagesByLanguage includesKey: aSymbol) ifFalse:
		[self messagesByLanguage at: aSymbol put: Dictionary new].
	(self messagesByLanguage at: #en) keysDo: [:key | 
		(self messagesByLanguage at: aSymbol) at: key put: ''].!

language

	"return a current language, for which messages are retrieved"
	
	language isNil ifTrue: [self language: #en].
	^language!

language: aSymbol
	"set a current language, for which messages are retrieved"
	language := aSymbol asSymbol.
	(self messagesByLanguage includesKey: aSymbol asSymbol) 
		ifFalse: [self initNewLanguage: aSymbol asSymbol].!

messagesByLanguage
	"return a dictionary which language symbol as key and value asanother dictionary 
	with message symbol as key and message text as value"
	messagesByLanguage isNil ifTrue:
		[messagesByLanguage := Dictionary new. 
		self initNewLanguage: #en].
	^messagesByLanguage.!

messagesForCurrentLanguage

	"return a dictionary of all messages for a current language"

	^(self messagesByLanguage at: self language)! !
!WebMsgs categoriesFor: #at:!accessing!private! !
!WebMsgs categoriesFor: #at:put:!accessing!private! !
!WebMsgs categoriesFor: #initialize!initialize-release!private! !
!WebMsgs categoriesFor: #initNewLanguage:!initialize-release!private! !
!WebMsgs categoriesFor: #language!accessing!private! !
!WebMsgs categoriesFor: #language:!accessing!private! !
!WebMsgs categoriesFor: #messagesByLanguage!accessing!private! !
!WebMsgs categoriesFor: #messagesForCurrentLanguage!accessing!private! !

!WebMsgs class methodsFor!

at: aSymbol

	"return a message text at specificied symbol in a language, which is previosly set by language: method. If not set, then default language is used"

	^self default at: aSymbol!

at: aSymbol put: aString

	"store  a message text at specificied symbol in a language, which is previosly set by language: method. If not set, then default language is used"

	self default at: aSymbol put: aString!

default

	"find or create an instance of WebMsgs."

	^AIDASite default webMsgs!

language

	"return a current language, for which messages are retrieved"
	
	^self default language.!

language: aSymbol

	"set a current language, for which messages are retrieved"

	self default language: aSymbol!

new

	^super new initialize! !
!WebMsgs class categoriesFor: #at:!accessing!private! !
!WebMsgs class categoriesFor: #at:put:!accessing!private! !
!WebMsgs class categoriesFor: #default!accessing!private! !
!WebMsgs class categoriesFor: #language!accessing!private! !
!WebMsgs class categoriesFor: #language:!accessing!private! !
!WebMsgs class categoriesFor: #new!instance creation!private! !

WebNews guid: (GUID fromString: '{51ED36A3-4A58-4752-8490-E37AE37B3054}')!
WebNews comment: ''!
!WebNews categoriesForClass!Unclassified! !
!WebNews methodsFor!

actualNews
	actualNews isNil ifTrue: [self initActualNews].
	^actualNews.!

addArticle: aWebNewsArticle

	"add a new article to the news, if not already exist"

	(self news includes: aWebNewsArticle)
		ifFalse: [ aWebNewsArticle initDefaultWeight.
			self news add: aWebNewsArticle.
		"	self synchronizeCategoriesFor: aWebNewsArticle. "
			self categorizeArticle: aWebNewsArticle.
			aWebNewsArticle addDependent: self.]
		ifTrue: [self error: 'this article already exists in news'].


"WebNews instance news do: [:each | each addDependent: WebNews instance]."!

addCategory: aString
	(self actualNews includesKey: aString)
		ifFalse:
			[self actualNews at: aString put: OrderedCollection new.
			self archiveNews at: aString put: OrderedCollection new.

			self news do:
				[ :article |  (article categories includesKey: aString)
						ifFalse: [article categories at: aString put: false]]
			].!

archiveNews
	archiveNews isNil ifTrue: [self initArchiveNews].
	^archiveNews.!

articleChanged: aWebNewsArticle 

	"detect changes and correct collections accordingly"

	aWebNewsArticle initDefaultWeight.
	self uncategorizeArticle: aWebNewsArticle.
	self categorizeArticle: aWebNewsArticle.!

categorizeArticle: aWebNewsArticle

	"add a new article to the news, if not already exist"

	aWebNewsArticle categories keysAndValuesDo: [ :key :value | 
		value 
			ifTrue: 
				[ ((self archiveNews at: key) includes: aWebNewsArticle)
					ifFalse: [(self archiveNews at: key) add: aWebNewsArticle].
				 ((self actualNews at: key) includes: aWebNewsArticle)
					 ifFalse: [(self actualNews at: key) add: aWebNewsArticle] ]
			ifFalse: 
				[(self archiveNews at: key) remove: aWebNewsArticle ifAbsent: [] ].
	
		].
	
	(aWebNewsArticle hot at: 'hot')
		ifTrue: [(self hotNews includes: aWebNewsArticle) 
			ifFalse: [self hotNews add: aWebNewsArticle] ]
		ifFalse: [self hotNews remove: aWebNewsArticle ifAbsent: []].!

fileOutTo: aFilenameString

	| stream boss |
	stream := aFilenameString asFilename writeStream.
	boss := BinaryObjectStorage onNew: stream.
	boss nextPut: self.
	boss close.

"WebNews default fileOutTo: 'news.boss' "!

hotNews
	hotNews isNil ifTrue: [self initHotNews].
	^hotNews.!

hotNewsElement


	| sorted list table row cell |
	table := WebTable new width: 480. row := WebTableRow new. cell := WebTableCell new.
	cell addText: '<font face=helvetica>Novice</font>' attributes: #bold.

	list := WebList new.
	sorted := SortedCollection
		withAll: self hotNews
		sortBlock: [:first :second | first date > second date].

	sorted do: [:article |
		list addLinkTo: article text: 
			('<font size=-1 face=Helvetica><b>', article title, '</b></font>').
		list addText: ('<font size=-1>', article abstract, '</font>').
		list addText: 
			('<font size=-1><i>', article author, ', ', article date printSloString, '</i></font>')].
		list addParagraph.
	cell add: list.
	
	cell addLinkTo: self  text: 
			'<font face = helvetica size=-1><b>Prispevajte vaso novico</b></font>' 
			parameter: 'view' value: 'addUserArticle'.
	cell addLinkTo: self  
		text: '<font face = helvetica size=-1><b>Oglejte si vse ostale novice</b></font>' 
		parameter: 'view' value: 'archive'.
	cell addBreak; 
		addLinkTo:  (WebIndex default) text: '<font face = helvetica size=-1>
			<b>Iskanje po novicah</b></font>'; addBreak.

	cell addRulerSize: 2;  addParagraph.
	row add: cell. table add: row.
	^table.!

hotNewsElementOn: aWebSession


	| sorted list table row cell |
	table := WebTable new  cellPadding: 0; cellSpacing: 10; width: 480. 
	row := WebTableRow new. cell := WebTableCell new.
	cell add: (self hotNewsHeaderOn: aWebSession).

	list := WebList new.
	sorted := SortedCollection
		withAll: self hotNews
		sortBlock: [:first :second | first date > second date].
	aWebSession userValues at: #News put: sorted.

	sorted do: [:article |
		list addLinkTo: article text: 
			('<font size=-1 face=Helvetica><b>', article title, '</b></font>').
		list addText: ('<font size=-1>', article abstract, '</font>').
		list addText: 
			('<font size=-1><i>', article author, ', ', article date printSloString, '</i></font>')].
		list addParagraph.
	cell add: list.
	cell addRulerSize: 1.
	row add: cell. table add: row.
	^table.!

hotNewsHeaderOn: aSession

	| element |
	element := WebElement new.
	element table cellPadding: 0; cellSpacing: 0; width: 460.
	element cell width: 300; valign: #bottom;
		addText: 
			'<font face = helvetica size=+1><b>Novice</b></font>';
		addRulerSize: 1.
	element newCell addText: '&nbsp'.
	element newCell width: 150; color: #mediumgoldenrod;
		addLinkTo: aSession site news  
			text: 
				'<font face = verdana, helvetica size=-2><b>Prispevajte vaso novico</b></font>' 
			parameter: 'view' value: 'addUserArticle';
		addBreak;
		addLinkTo: aSession site news
			text: '<font face = verdana,helvetica size=-2><b>Arhiv novic</b></font>' 
			parameter: 'view' value: 'archive';
		addBreak;
		addLinkTo:  (aSession site index) 
			text: '<font face = verdana,helvetica size=-2><b>Iskanje po novicah</b></font>'.
	^element!

indexNewsArticles
	"reindex all articles in news to a default WebIndex"
	self news do: [:each | WebIndex default indexObject: each].

"WebNews default indexNewsArticles"!

indexNewsArticlesFromDate: aDate
	"reindex all articles in news to a default WebIndex, only news newer than aDate"
	self news do: [:each | 
		each date > (aDate subtractDays: 1)  ifTrue: [WebIndex default indexObject: each] ].

"WebNews instance indexNewsArticlesFromDate: Date today"!

indexNewsArticlesLast30Days
	self indexNewsArticlesFromDate: (Date today subtractDays: 30).

"WebNews default indexNewsArticlesLast30Days"!

initActualNews
	actualNews := Dictionary new. 

"WebNews default initActualNews"!

initArchiveNews
	archiveNews := Dictionary new. 

"WebNews default initArchiveNews"!

initHotNews
	hotNews := OrderedCollection new.!

initialize!

initNews
	news := OrderedCollection new. 

"WebNews default"!

news
	news isNil ifTrue: [self initNews].
	^news.!

removeArticle: aWebNewsArticle

	"remove an articel from news, if  exist"

	self news remove: aWebNewsArticle ifAbsent: 
		[^nil].
		"[^self error: 'this article does not exist in a news']."

	self uncategorizeArticle: aWebNewsArticle.
	aWebNewsArticle removeDependent: self.!

removeCategory: aString
	(self actualNews includesKey: aString)
		ifTrue:
			[self actualNews removeKey: aString.
			self archiveNews removeKey: aString.

			self news do:
				[ :article |  (article categories includesKey: aString)
						ifTrue: [article categories removeKey: aString]]
			].!

synchronizeCategoriesFor: aWebNewsArticle
	
	self archiveNews keysDo: [ :key | 
		(aWebNewsArticle categories includes: key) ifFalse:
			[aWebNewsArticle categories at: key put: false]
		].

	aWebNewsArticle categories keys do: [ :key | 
		(self archiveNews includesKey: key) ifFalse:
			[aWebNewsArticle categories removeKey: key]
		].

"WebNews default news do: [:article | WebNews default synchronizeCategoriesFor: article]."!

uncategorizeArticle: aWebNewsArticle

	"add a new article to the news, if not already exist"

	self archiveNews keysAndValuesDo: [ :key :value | 
		value remove: aWebNewsArticle	ifAbsent: []].

	self actualNews keysAndValuesDo: [ :key :value | 
		value remove: aWebNewsArticle	ifAbsent: []].

	self hotNews remove: aWebNewsArticle	ifAbsent: [].!

update: anAspect with: anObject


	self categorizeArticle: anObject! !
!WebNews categoriesFor: #actualNews!accessing!private! !
!WebNews categoriesFor: #addArticle:!adding-removing!private! !
!WebNews categoriesFor: #addCategory:!categorization!private! !
!WebNews categoriesFor: #archiveNews!accessing!private! !
!WebNews categoriesFor: #articleChanged:!adding-removing!private! !
!WebNews categoriesFor: #categorizeArticle:!categorization!private! !
!WebNews categoriesFor: #fileOutTo:!import - export!private! !
!WebNews categoriesFor: #hotNews!accessing!private! !
!WebNews categoriesFor: #hotNewsElement!printing!private! !
!WebNews categoriesFor: #hotNewsElementOn:!printing!private! !
!WebNews categoriesFor: #hotNewsHeaderOn:!printing!private! !
!WebNews categoriesFor: #indexNewsArticles!indexing!private! !
!WebNews categoriesFor: #indexNewsArticlesFromDate:!indexing!private! !
!WebNews categoriesFor: #indexNewsArticlesLast30Days!indexing!private! !
!WebNews categoriesFor: #initActualNews!initialize-release!private! !
!WebNews categoriesFor: #initArchiveNews!initialize-release!private! !
!WebNews categoriesFor: #initHotNews!initialize-release!private! !
!WebNews categoriesFor: #initialize!initialize-release!private! !
!WebNews categoriesFor: #initNews!initialize-release!private! !
!WebNews categoriesFor: #news!accessing!private! !
!WebNews categoriesFor: #removeArticle:!adding-removing!private! !
!WebNews categoriesFor: #removeCategory:!categorization!private! !
!WebNews categoriesFor: #synchronizeCategoriesFor:!categorization!private! !
!WebNews categoriesFor: #uncategorizeArticle:!categorization!private! !
!WebNews categoriesFor: #update:with:!categorization!private! !

!WebNews class methodsFor!

default
	^AIDASite default news!

new
	^super new initialize! !
!WebNews class categoriesFor: #default!accessing!private! !
!WebNews class categoriesFor: #new!instance creation!private! !

WebNewsArticle guid: (GUID fromString: '{736D0175-47A8-478F-8077-153EFE6C8EA8}')!
WebNewsArticle comment: ''!
!WebNewsArticle categoriesForClass!Unclassified! !
!WebNewsArticle methodsFor!

abstract
	abstract isNil ifTrue: [self abstract: ''].
	^abstract!

abstract: aString
	abstract := aString.!

actualToDate
	actualToDate isNil ifTrue: [self actualToDate: ((Date today) addDays: 14)].
	^actualToDate!

actualToDate: aDate
	actualToDate := aDate.!

actualToDateText
	(self actualToDate isKindOf: Date)
		ifTrue: [^self actualToDate shortPrintSloString]
		ifFalse: [self actualToDate: nil. ^self actualToDateText]!

actualToDateText: aString

	self date: (Date readSloFrom: aString readStream)!

author
	author isNil ifTrue: [self author: ''].
	^author!

author: aString
	author := aString.!

body
	body isNil ifTrue: [self body: ''].
	^body!

body: aString
	body := aString.!

categories
	categories isNil ifTrue: [self initCategories].
	^categories!

categoriesElement

	| element |
	element := WebElement new.
	
	self categories keysAndValuesDo: [:key :value |
		element add: (WebRadioButton new 
			name: 'Categories'; value: key; object: self categories); 
			addText: key].

	^element!

date
	date isNil ifTrue: [self date: Date today].
	^date!

date: aDate
	date := aDate.!

dateText
	^self date shortPrintSloString!

dateText: aString

	self date: (Date readSloFrom: aString readStream)!

hot
	hot isNil ifTrue: [self hot: (Dictionary withKeysAndValues: #('hot' false))].
	^hot


"WebNewsArticle allInstances do: [:each | each hot: nil]."!

hot: aBoolean
	hot := aBoolean.!

indexAbstract

	| t1 |
	^((t1 := self abstract) copyFrom: 1 to: (200 min: t1 size))!

indexText

	^self author , ' ' , self title , ' ' , self abstract , ' ' , self body!

indexTitle

	^self title , ' (' , self author , ')' , ' '!

initCategories
	categories := Dictionary new.!

initDefaultWeight

" init default weight for anArticle. Decide wheather it contains picture (5) or abstract (3) or only body (1).
  Used for defining the order of articles, when there is more then one article per day. "
	
	(self picture = '') 
		ifTrue: [ 
			(self abstract = '')
				ifTrue: [self weight: 1 ]
				ifFalse: [self weight: 3]]
		ifFalse: [ self weight: 5 ].

" WebNews instance news do: [ :each | each initDefaultWeight] "!

initialize!

picture
	picture isNil ifTrue: [self picture: ''].
	^picture!

picture: aString
	picture := aString.!

printString

	^('a WebNewsArticle named: ''', self title, '''')!

title
	title isNil ifTrue: [self title: ''].
	^title!

title: aString
	title := aString.!

updated

	self changed: #all with: self!

weight

	weight isNil ifTrue: [self weight: 0].
	^weight!

weightText

	self weight printString!

weightText: aString

	self weight: (aString asNumber)! !
!WebNewsArticle categoriesFor: #abstract!accessing!private! !
!WebNewsArticle categoriesFor: #abstract:!accessing!private! !
!WebNewsArticle categoriesFor: #actualToDate!accessing!private! !
!WebNewsArticle categoriesFor: #actualToDate:!accessing!private! !
!WebNewsArticle categoriesFor: #actualToDateText!aspect addapting!private! !
!WebNewsArticle categoriesFor: #actualToDateText:!aspect addapting!private! !
!WebNewsArticle categoriesFor: #author!accessing!private! !
!WebNewsArticle categoriesFor: #author:!accessing!private! !
!WebNewsArticle categoriesFor: #body!accessing!private! !
!WebNewsArticle categoriesFor: #body:!accessing!private! !
!WebNewsArticle categoriesFor: #categories!accessing!private! !
!WebNewsArticle categoriesFor: #categoriesElement!printing!private! !
!WebNewsArticle categoriesFor: #date!accessing!private! !
!WebNewsArticle categoriesFor: #date:!accessing!private! !
!WebNewsArticle categoriesFor: #dateText!aspect addapting!private! !
!WebNewsArticle categoriesFor: #dateText:!aspect addapting!private! !
!WebNewsArticle categoriesFor: #hot!accessing!private! !
!WebNewsArticle categoriesFor: #hot:!accessing!private! !
!WebNewsArticle categoriesFor: #indexAbstract!indexing!private! !
!WebNewsArticle categoriesFor: #indexText!indexing!private! !
!WebNewsArticle categoriesFor: #indexTitle!indexing!private! !
!WebNewsArticle categoriesFor: #initCategories!initialize-release!private! !
!WebNewsArticle categoriesFor: #initDefaultWeight!initialize-release!private! !
!WebNewsArticle categoriesFor: #initialize!initialize-release!private! !
!WebNewsArticle categoriesFor: #picture!accessing!private! !
!WebNewsArticle categoriesFor: #picture:!accessing!private! !
!WebNewsArticle categoriesFor: #printString!printing!private! !
!WebNewsArticle categoriesFor: #title!accessing!private! !
!WebNewsArticle categoriesFor: #title:!accessing!private! !
!WebNewsArticle categoriesFor: #updated!accessing!private! !
!WebNewsArticle categoriesFor: #weight!accessing!private! !
!WebNewsArticle categoriesFor: #weightText!aspect addapting!private! !
!WebNewsArticle categoriesFor: #weightText:!aspect addapting!private! !

!WebNewsArticle class methodsFor!

needsDataVerification
	"Do not alter. Added automatically."
	^true!

new
	^super new initialize.! !
!WebNewsArticle class categoriesFor: #needsDataVerification!odb private!private! !
!WebNewsArticle class categoriesFor: #new!instance creation!private! !

WebSecurityManager guid: (GUID fromString: '{7777C792-B095-4B24-8B74-A7B564939599}')!
WebSecurityManager comment: ''!
!WebSecurityManager categoriesForClass!Unclassified! !
!WebSecurityManager methodsFor!

accessByObject 
	"this is a dictionary of user - access level pairs for access to the object, 
	which reference is a key in dictionary"
	accessByObject isNil ifTrue: [self initAccessByObject].
	^accessByObject!

accessRightsArray: anAccessSymbols for: aWebUserOrGroup on: anObject
	| objectRights rigthsArray |
	self site critical:
		[objectRights := self accessByObject at: anObject 
			ifAbsent: 
				[self accessByObject at: anObject put: (Dictionary new).
				self accessByObject at: anObject].
		rigthsArray := objectRights at: aWebUserOrGroup 
			ifAbsent:
				[objectRights at: aWebUserOrGroup put: IdentitySet new.
				objectRights at: aWebUserOrGroup].
		rigthsArray addAll: anAccessSymbols].!

accessRightsFor: aWebUserOrGroup on: anObject
	"get the access rights for specified user or group on object  as literal array of 
	rights (e.g. #(#read #write). " 
	^(self accessByObject at: anObject 
		ifAbsent: [^self defaultAccessRights])
			at: aWebUserOrGroup ifAbsent:  [^self defaultAccessRights]!

activatingGroup
	"group for users to confirm registration"
	^self groups detect: [:each | each isActivatingGroup] ifNone: [nil].!

addActivatingUser: aWebUser
	"add this user also to group waiting for confirmation"
	self addUser: aWebUser.
	self activatingGroup addUser: aWebUser.!

addGroup: aWebUserGroup
	self addGroup: aWebUserGroup ifExist: [^nil].!

addGroup: aWebUserGroup ifExist: aBlock
	"add new group. If already exist ( as object or as group with the same name) do aBlock"
 	(aWebUserGroup isKindOf: WebUserGroup) ifFalse: [^self error: 'This is not aWebUserGroup'].
	(self existGroupNamed: aWebUserGroup name) ifTrue: [aBlock value].
	self groups add: aWebUserGroup!

addGroupNamed: aString
 	"add new group with a specified name. If already exist, error"
	self addGroup: (WebUserGroup new name: aString).!

addPerson: aPerson
	"make parallel WebUser, cross-connect both and put into Registered group"
	"by default username and password are aPerson surname!!"
	| user |
	aPerson asWebUser notNil ifTrue: [^self error: 'already added!!'].
	user := WebUser new.
	user username: aPerson surname.
	user password: aPerson surname.
	(self addRegisteredUser: user) notNil "no duplicates in username"
		ifTrue: [ aPerson webUser: user. user person: aPerson]
		ifFalse: [^nil]!

addRegisteredUser: aWebUser
	"add this user also to registered users group. Remove him from activating group"
	self addUser: aWebUser.
	self registeredGroup addUser: aWebUser.
	self activatingGroup removeUser: aWebUser.!

addUser: aWebUser
	"add new user also in All Users group"
	(aWebUser isKindOf: WebUser) ifFalse: [^self error: 'This is not aWebUser'].
	(self users includes: aWebUser) ifTrue: [^nil].
	(self existUserNamed: aWebUser username withPassword: aWebUser password) ifTrue: [^nil]. 
	self users add: aWebUser.
	self allUsersGroup addUser: aWebUser.
	aWebUser parent: self.!

adminGroup
	"group for admins, those who have all acess rights !! "
	^self groups detect: [:each | each isAdminGroup] ifNone: [nil].!

adminUser
	"first admin user, initialy it is with username 'admin'"
	^self users detect: [:each | each isAdmin] ifNone: [nil]!

allGroups
	^self groups copy!

allUsers
	^self users copy!

allUsersGroup
	"group for all users in system"
	^self groups detect: [:each | each isAllUsersGroup] ifNone: [nil].!

authenticationScheme
	"#Form - with WebAdminApp login form - default!!
	#HttpBasic - rfc2617 Basic authentication - passwords NOT encrypted!!
	#HttpDigest - rfc2617 Digest authentication - encrypted passwords
	#SSLClientCertificate - most secure, user needs a valid PKI certificate"
	authenticationScheme isNil ifTrue: [self setFormAuthenticationScheme].
	^authenticationScheme!

authenticationScheme: aSymbol
	authenticationScheme := aSymbol!

copyAccessByObject
 
|dict|
Janko := Dictionary new.
WebSecurityManager default accessByObject 
keysAndValuesDo:
	[:key :value | 
		dict := Dictionary new.
		value keysAndValuesDo: [:key1 :value1 |
			dict at: key1 put: (IdentitySet withAll: (value1 collect: [:el | el asString asSymbol] )) ].
		Janko at: key put: dict].!

defaultAccessRights
	
	^#()!

existGroupNamed: aString
	^(self groupNamed: aString) notNil!

existUserNamed: anUsernameString withPassword: aPasswordString
	^(self userNamed: anUsernameString withPassword: aPasswordString) notNil!

existUserWithId: aNumber
	^self users contains: [:each | each id = aNumber].!

groupNamed: aString
	aString isEmpty ifTrue: [^nil].
	^self groups detect: [:group | group name =  aString] ifNone: [nil]!

groups 
	groups isNil ifTrue: [self initGroups].
	^groups!

groupWithUuid: aString
	" find and return a group with specified uuid. Return nil if not found" 
	^self groups detect: [:each | each uuid = aString] ifNone: [nil]!

guestUser
	"actually only one is guest user"
	^self users detect: [:each | each isGuest] ifNone: [nil]!

has: aWebUserOrGroup rightTo: anAccessSymbol on: anObject 
	"test the access right for that object and that user or group "
	| usersAndGroups |
	usersAndGroups := self accessByObject at: anObject ifAbsent: [^false].
	(usersAndGroups includesKey: aWebUserOrGroup)	ifTrue:
		[((usersAndGroups at: aWebUserOrGroup) includes: anAccessSymbol) ifTrue: [^true] ].
	^false!

hasFormAuthenticationScheme
	^self authenticationScheme = #Form!

hasHttpAuthenticationScheme
	^self hasHttpBasicAuthenticationScheme | self hasHttpDigestAuthenticationScheme!

hasHttpBasicAuthenticationScheme
	^self authenticationScheme = #HttpBasic!

hasHttpDigestAuthenticationScheme
	^self authenticationScheme = #HttpDigest!

hasSSLClientCertificateAuthenticationScheme
	^self authenticationScheme = #SSLClientCertificate!

hasUser: aWebUser rightInAnyGroupTo: anAccessSymbol on: anObject 
	"test the access right for that object and in groups for that user"
	aWebUser groups do: [:group |
		(self has: group rightTo: anAccessSymbol on: anObject) ifTrue: [^true] ].
	^(self has: self allUsersGroup rightTo: anAccessSymbol on: anObject)!

initAccessByObject
	accessByObject := Dictionary new.!

initAdminUser
	"add default admin user"
	| user |
	(self users contains: [:each | each isAdmin and: [each name = WebUser adminName]]) ifTrue: [^nil].
	user := WebUser newAdmin.
	self addUser: user.
	self adminGroup addUser: user.!

initDefaultAccessRights
	"to allow login, registering new user etc"
	| views updates |
	views := #(login logout forgoten registration passwordSent waitingConfirmation activation) 
		collect: [:each | WebAdminApp viewRightSymbolFor: each].
	self 	setAccessRights: views for: self allUsersGroup on: WebAdminApp name.
	updates := #(login registration passwordSent) 
		collect: [:each | WebAdminApp updateRightSymbolFor: each].
	self 	setAccessRights: updates for: self allUsersGroup on: WebAdminApp name.

"WebSecurityManager default initDefaultAccessRights"!

initDefaultGroups
	self addGroup: WebUserGroup newAllUsers.
	self users do: [:user | 	self allUsersGroup addUser: user].
	self addGroup: WebUserGroup newAdmin.
	self addGroup: WebUserGroup newRegistered.
	self addGroup: WebUserGroup newActivating.
	self postInitDefaultGroups.  "override this method for your own default groups"!

initGroups
	groups := Set new.!

initGuestUser
	"add new user,with name 'Guest'"
	| user |
	(self users contains: [:each | each isGuest]) ifTrue: [^nil].
	user := WebUser newGuest.
	self addUser: user.
	self allUsersGroup addUser: user.!

initialize
	self initUsers.
	self initGroups.
	self initAccessByObject.
	self initDefaultGroups.
	self initAdminUser.
	self initGuestUser.
	self initDefaultAccessRights.!

initUsers
	users := Set new. 
	self groups do: [:each | each initUsers].!

isDefaultAllowedTo: anAccessSymbol 
	"default access right for all objects and all users"
	^self defaultAccessRights includes: anAccessSymbol!

isUser: aWebUser allowedTo: anAccessSymbol on: anObject 
	"test the access right for that object and that user or groups for that user"
	(self has: aWebUser rightTo: anAccessSymbol on: anObject) ifTrue: [^true].
	^(self hasUser: aWebUser rightInAnyGroupTo: anAccessSymbol on: anObject)!

isUser: aWebUser inGroup: aWebGroup
	"test if user is member of this group"
	^aWebGroup includes: aWebUser!

isUser: aWebUser inGroupNamed: aString
	| group |
	group := self groupNamed: aString.
	group isNil ifTrue: [^false].
	^group includes: aWebUser!

migrateAppClassessToSymbols
	"do not use app classes but their names as symbols"

	self accessByObject keys do: [:obj |
		((obj isKindOf: Behavior) and: [obj includesBehavior: WebApplication]) ifTrue: [
			self accessByObject 
				at: obj name 
				put: (self accessByObject at: obj).
			self accessByObject removeKey: obj] ].

"WebSecurityManager default migrateAppClassessToSymbols"!

postInitDefaultGroups
	"override this method for your own default groups"!

registeredGroup
	"group for registered users"
	^self groups detect: [:each | each isRegisteredGroup] ifNone: [nil].!

removeAccessRightArray: anAccessSymbols for: aWebUserOrGroup and: anObject 
	"remove all specified access rigths for specified user or group on specified object"
	self site critical:
		[((self accessByObject at: anObject ifAbsent: [^self])
			at: aWebUserOrGroup ifAbsent: [^self])	removeAll: anAccessSymbols].!

removeAccessRightArray: anAccessSymbols for: aWebUserOrGroup on: anObject 
	"remove all specified access rigths for specified user or group on specified object"
	| usrGrps rights |
	self site critical:
		[usrGrps := self accessByObject at: anObject ifAbsent: [^self].
		rights := usrGrps at: aWebUserOrGroup ifAbsent: [^self].
		anAccessSymbols do: [:each | rights remove: each ifAbsent: [] ] ].!

removeAccessRights: anAccessSymbol for: aWebUserOrGroup on: anObject 
	"remove all specified access rigths for specified user or group on specified object"
	| access |
	(anAccessSymbol isKindOf: Array)
		ifTrue: [access := anAccessSymbol ]
		ifFalse: [access := Array with: anAccessSymbol].
	self removeAccessRightArray: access for: aWebUserOrGroup on: anObject!

removeAllAccessRightsFor: aWebUserOrGroup 
	self accessByObject keys do: [:object |
		self 
			removeAllAccessRightsFor: aWebUserOrGroup 
			on: object]!

removeAllAccessRightsFor: aWebUserOrGroup on: anObject 
	self site critical:
		[(self accessByObject at: anObject ifAbsent: [^self])
			removeKey: aWebUserOrGroup ifAbsent: [^self] ].!

removeAllAccessRightsForObject: anObject 
	self site critical:
		[self accessByObject removeKey: anObject ifAbsent: []	].!

removeGroup: aWebUserGroup
	"remove group, if exist. If not exist do nothing" 
	self removeGroup: aWebUserGroup ifAbsent: [].!

removeGroup: aWebUserGroup ifAbsent: aBlock
	"remove group, if exist. If not exist do aBlock. You cannot remove group AllUsers!!" 
	aWebUserGroup isAllUsersGroup ifTrue: [^self error: 'group AllUsers cannot be removed!!'].
	(self groups includes: aWebUserGroup) ifFalse: [^aBlock value].
	self groups remove: aWebUserGroup.
	aWebUserGroup allUsers do: [:each | aWebUserGroup removeUser: each].
	self removeAllAccessRightsFor: aWebUserGroup!

removeGroupNamed:  aString 
	| group |
	group := self groupNamed: aString.
	group notNil ifTrue: [self removeGroup: group]!

removeUser: aWebUser
	"remove user, if exist" 
	(self users includes: aWebUser) ifFalse: [^nil].
	self users remove: aWebUser.
	self allGroups do: [:group | group removeUser: aWebUser].
	self removeAllAccessRightsFor: aWebUser!

removeUserNamed:  anUsername withPassword: aPassword
	| user |
	user := self userNamed: anUsername withPassword: aPassword.
	self removeUser: user!

setAccessRights: anAccessSymbols for: aWebUserOrGroup on: anObject
	"set the access rights for specified user or group on object. it can be only one right 
	or an literal array of rights (e.g.#(#read #write) ) " 
	| access |
	aWebUserOrGroup isNil ifTrue: [^self error: 'User is nil'].
	access := (anAccessSymbols isKindOf: Array) 
		ifTrue: [anAccessSymbols ] 
		ifFalse: [Array with: anAccessSymbols].
	self accessRightsArray: access for: aWebUserOrGroup on: anObject.!

setFormAuthenticationScheme
	"AIDASite default securityManager setFormAuthenticationScheme"
	self authenticationScheme: #Form!

setHttpBasicAuthenticationScheme
	"AIDASite default securityManager setHttpBasicAuthenticationScheme"
	self authenticationScheme: #HttpBasic!

setHttpDigestAuthenticationScheme
	"AIDASite default securityManager setHttpDigestAuthenticationScheme"
	self authenticationScheme: #HttpDigest!

setSSLClientCertificateAuthenticationScheme
	"AIDASite default securityManager setSSLClientCertificateAuthenticationScheme"
	self authenticationScheme: #SSLClientCertificate!

site
	"a parent site using that security manager"
	^site!

site: anAIDASite
	site := anAIDASite.!

userNamed: anUsernameString
	" find and return a WebUser with username . Return nil if not found"
	"WebSecurityManager default userNamed: 'mivsek'"
 	(anUsernameString ~= '') ifFalse: [^nil].
	^self users 
		detect: [:user | (user username asLowercase = anUsernameString asLowercase)] ifNone: [nil]!

userNamed: anUsernameString withPassword: aPasswordString
	" find and return a WebUser with username and password. Return nil if not found"
 	(anUsernameString ~= '') | (aPasswordString ~= '') ifFalse: [^nil].
	^self users detect: [:user | 
		(user username asLowercase = anUsernameString asLowercase) and: 
			[user password asLowercase = aPasswordString asLowercase]] ifNone: [nil]!

users 
	users isNil ifTrue: [self initUsers].
	^users!

userWithEMail: aString
	" find and return a WebUser with specified email. Return nil if not found" 
	(aString ~= '') ifFalse: [^nil]. 
	^self users detect: [:user | user email asLowercase = aString asLowercase ] ifNone: [^nil]!

userWithId: aNumber
	^self users detect: [:each | each id = aNumber] ifNone: [nil]!

userWithUuid: aString
	" find and return a WebUser with specified uuid. Return nil if not found" 
	^self users detect: [:each | each uuid = aString] ifNone: [nil]! !
!WebSecurityManager categoriesFor: #accessByObject!private! !
!WebSecurityManager categoriesFor: #accessRightsArray:for:on:!private! !
!WebSecurityManager categoriesFor: #accessRightsFor:on:!access control!private! !
!WebSecurityManager categoriesFor: #activatingGroup!group management!private! !
!WebSecurityManager categoriesFor: #addActivatingUser:!private!user management! !
!WebSecurityManager categoriesFor: #addGroup:!group management!private! !
!WebSecurityManager categoriesFor: #addGroup:ifExist:!private! !
!WebSecurityManager categoriesFor: #addGroupNamed:!group management!private! !
!WebSecurityManager categoriesFor: #addPerson:!private!user management! !
!WebSecurityManager categoriesFor: #addRegisteredUser:!private!user management! !
!WebSecurityManager categoriesFor: #addUser:!private!user management! !
!WebSecurityManager categoriesFor: #adminGroup!group management!private! !
!WebSecurityManager categoriesFor: #adminUser!private!user management! !
!WebSecurityManager categoriesFor: #allGroups!accessing!private! !
!WebSecurityManager categoriesFor: #allUsers!accessing!private! !
!WebSecurityManager categoriesFor: #allUsersGroup!group management!private! !
!WebSecurityManager categoriesFor: #authenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #authenticationScheme:!private! !
!WebSecurityManager categoriesFor: #copyAccessByObject!private! !
!WebSecurityManager categoriesFor: #defaultAccessRights!private! !
!WebSecurityManager categoriesFor: #existGroupNamed:!group management!private! !
!WebSecurityManager categoriesFor: #existUserNamed:withPassword:!private!user management! !
!WebSecurityManager categoriesFor: #existUserWithId:!private!user management! !
!WebSecurityManager categoriesFor: #groupNamed:!group management!private! !
!WebSecurityManager categoriesFor: #groups!private! !
!WebSecurityManager categoriesFor: #groupWithUuid:!group management!private! !
!WebSecurityManager categoriesFor: #guestUser!private!user management! !
!WebSecurityManager categoriesFor: #has:rightTo:on:!private! !
!WebSecurityManager categoriesFor: #hasFormAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #hasHttpAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #hasHttpBasicAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #hasHttpDigestAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #hasSSLClientCertificateAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #hasUser:rightInAnyGroupTo:on:!access control!private! !
!WebSecurityManager categoriesFor: #initAccessByObject!initialize-release!private! !
!WebSecurityManager categoriesFor: #initAdminUser!initialize-release!private! !
!WebSecurityManager categoriesFor: #initDefaultAccessRights!initialize-release!private! !
!WebSecurityManager categoriesFor: #initDefaultGroups!initialize-release!private! !
!WebSecurityManager categoriesFor: #initGroups!initialize-release!private! !
!WebSecurityManager categoriesFor: #initGuestUser!initialize-release!private! !
!WebSecurityManager categoriesFor: #initialize!initialize-release!private! !
!WebSecurityManager categoriesFor: #initUsers!initialize-release!private! !
!WebSecurityManager categoriesFor: #isDefaultAllowedTo:!private! !
!WebSecurityManager categoriesFor: #isUser:allowedTo:on:!access control!private! !
!WebSecurityManager categoriesFor: #isUser:inGroup:!private!user management! !
!WebSecurityManager categoriesFor: #isUser:inGroupNamed:!private!user management! !
!WebSecurityManager categoriesFor: #migrateAppClassessToSymbols!private! !
!WebSecurityManager categoriesFor: #postInitDefaultGroups!initialize-release!private! !
!WebSecurityManager categoriesFor: #registeredGroup!group management!private! !
!WebSecurityManager categoriesFor: #removeAccessRightArray:for:and:!private! !
!WebSecurityManager categoriesFor: #removeAccessRightArray:for:on:!private! !
!WebSecurityManager categoriesFor: #removeAccessRights:for:on:!access control!private! !
!WebSecurityManager categoriesFor: #removeAllAccessRightsFor:!access control!private! !
!WebSecurityManager categoriesFor: #removeAllAccessRightsFor:on:!access control!private! !
!WebSecurityManager categoriesFor: #removeAllAccessRightsForObject:!access control!private! !
!WebSecurityManager categoriesFor: #removeGroup:!group management!private! !
!WebSecurityManager categoriesFor: #removeGroup:ifAbsent:!private! !
!WebSecurityManager categoriesFor: #removeGroupNamed:!group management!private! !
!WebSecurityManager categoriesFor: #removeUser:!private!user management! !
!WebSecurityManager categoriesFor: #removeUserNamed:withPassword:!private!user management! !
!WebSecurityManager categoriesFor: #setAccessRights:for:on:!access control!private! !
!WebSecurityManager categoriesFor: #setFormAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #setHttpBasicAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #setHttpDigestAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #setSSLClientCertificateAuthenticationScheme!authentication!private! !
!WebSecurityManager categoriesFor: #site!accessing!private! !
!WebSecurityManager categoriesFor: #site:!private! !
!WebSecurityManager categoriesFor: #userNamed:!private!user management! !
!WebSecurityManager categoriesFor: #userNamed:withPassword:!private!user management! !
!WebSecurityManager categoriesFor: #users!private! !
!WebSecurityManager categoriesFor: #userWithEMail:!private!user management! !
!WebSecurityManager categoriesFor: #userWithId:!private!user management! !
!WebSecurityManager categoriesFor: #userWithUuid:!private!user management! !

!WebSecurityManager class methodsFor!

default 
	^AIDASite default securityManager!

newOn: anAIDASite
	^super new 
		site: anAIDASite;
		initialize! !
!WebSecurityManager class categoriesFor: #default!accessing!private! !
!WebSecurityManager class categoriesFor: #newOn:!instance creation!private! !

WebSession guid: (GUID fromString: '{8F401232-EFCA-47A4-AF2C-0310E5456870}')!
WebSession comment: ''!
!WebSession categoriesForClass!Unclassified! !
!WebSession methodsFor!

addApp: anApplication for: anObject type: aSymbol
	"web or wap apps, type can be #web or #wap "
	| objDict |
	objDict := self appsForObjects at: anObject ifAbsentPut: [Dictionary new].
	objDict at: aSymbol put: anApplication!

addSessionID
	"add session id to  parms dictionary. Url with session id looks like: 	http://www.tris-a.si/welcome.html?id=523453. This should be done for every automaticaly 
	generated url (WebLink printHTMLPage) to distinguish sesions among themselves."
	self parms at: 'id' put: self id printString.!

addWapApp: aWapApplication for: anObject
	^self addApp: aWapApplication for: anObject type: #wap!

addWebApp: aWebApplication for: anObject
	^self addApp: aWebApplication for: anObject type: #web!

adminAllowed
	"check if general administration is allowed for user on our session"
	^self site securityManager
		isUser: self user
		inGroupNamed: self site securityManager adminGroup name!

appFor: anObject type: aSymbol 
	^(self appsForObjects at: anObject ifAbsent: [^nil]) 
		at: aSymbol ifAbsent: [^nil]!

appsForObjects
	
	appsForObjects isNil ifTrue: [self initAppsForObjects].
	^appsForObjects!

authenticateFrom: aRequest
	"try to login with username and password from request (rfc2617)"
	| usr |
	aRequest username isNil ifTrue: [^nil].
	usr := self site securityManager userNamed: aRequest username.
	usr isNil ifTrue: [^nil].
	(aRequest matchUserWithPassword: usr password) 
		ifTrue: [self loginUser: usr] ifFalse: [self logout].!

browser
	
	"try to find out, which browser a web request originator is using. It can be #Netscape, #IBM, #Microsoft, #lynx, #Mosaic.  Returns #Unknown if not possible to find out the browser type"

	| partOfString |
	self browserString = '' ifTrue: [^#Unknown].
	partOfString := self browserString copyFrom: 1 to: 6.
	partOfString = 'Mozill' ifTrue: [^#Netscape].
	partOfString = '' ifTrue: [^#Microsoft].
	partOfString = 'IBM-We' ifTrue: [^#IBM].
	partOfString = '' ifTrue: [^#Lynx].
	partOfString = '' ifTrue: [^#Mosaic].!

browserString
	
	"return the string, whick browser sends as identification in a web request"

	self lastRequest isNil ifTrue: [^''].
	^self lastRequest envVariables at: #http_user_agent.!

checkExpirationAndPossiblyLogoutFor: aRequest
	"don't logout if request is POST on the same object (eg. after long editing)"
	self isLoggedIn ifFalse: [^self].
	self user autoLogout ifFalse: [^self].
	(self isExpired and: [aRequest isPost not]) ifTrue: [self logout].!

clipboard
	"for cut/copy/paste references to web pages to easier hyperlink them"
	clipboard isNil ifTrue: [self initClipboard].
	^clipboard!

codePage
	^codePage!

codePage: aSymbol
	"set the code page of a data stream for this session. IT is used for transformation of inputs 
	and output to the Unicode codepage, in which information is strored in system. 
	Possible codepages: #utf_8 #cp850 #cp852 #cp1250 #iso1 #iso2 #csz #7bit "
	codePage := aSymbol.!

cookie
	"true if web request in this nonsecure session uses cookies, false otherwise"
	^self cookies at: 1.!

cookie: aBoolean
	self cookies 	at: 1 put: aBoolean!

cookies
	cookies isNil ifTrue: [self initCookies].
	^cookies!

country
	^country!

country: aSymbol
	"set the country of a web request originator in ISO 2letter format. 
	Default is #si (slovenia) if country cannot be determined"
	country := aSymbol.!

created

	"return the timestamp of a session creation."

	^created!

fullUrlForCurrentPage
	"composes and returns a full url for a curent requested page. If parms dictionary is changed, 
	then a query string with changed parameters is generated. Usefull for presenting the same 
	page in a different way by parameteres in query string"
	^self lastRequest urlString!

fullUrlForPreviousPage
	""
	(self requests isEmpty or: [self requests last isNil]) ifTrue: [^nil].
	^self requests last urlString!

hasSecureCookie
	"check if secure cookie is already set on secure part of session"
	^self secureCookie!

id

	"return the unique identification of a nonsecure session to browser. This is a random generated number at session generation. It can be used for session tracking in URLs, forms, etc."

	^self ids at: 1!

id: aNumber
	"return the unique identification of a nonsecure session. This is a random generated number 
	at session generation. It can be used for session tracking in URLs, forms, etc."
	self ids at: 1 put: aNumber.!

ids
	ids isNil ifTrue: [self initIds].
	^ids!

initAppsForObjects
	appsForObjects := IdentityDictionary new.!

initClipboard
	clipboard := WebClipboard new!

initCookies
	cookies := Array with: false with: false.!

initialize
	self setRandomIds.
	self setCreatedTimestamp.
	self initCookies.
	self initParms.
	self initRequests.
	self initLocales.
	self initUser.
	self initAppsForObjects.!

initIds
	ids := Array new: 2.!

initLocales
	self language: #english.
	self country: #si. 
	self codePage: #'utf-8'.!

initParms
	parms := Dictionary new.!

initRequests
	requests := OrderedCollection new.!

initUser
	self user: self site securityManager guestUser!

isActive

	"active if at least one request received last hour"

	self lastRequest isNil ifTrue: [^false].
	^(Timestamp now asSeconds - self lastRequest timestamp asSeconds) < 3600!

isEncrypted
	^self lastRequest isEncrypted "for now!! "!

isExpired
	"more than 15min of inactivity"
	self lastRequest isNil ifTrue: [^false].
	^(Timestamp now asSeconds - self lastRequest timestamp asSeconds) > (15*60)!

isFromLinux
	^self lastRequest isFromLinux!

isFromMSIE
	^self lastRequest isFromMSIE!

isFromNetscape
	".. or Moziila or Firefox"
	^self lastRequest isFromNetscape!

isFromWindows
	^self lastRequest isFromWindows!

isHttpAuthenticationNeeded
	"Usually we authenticate by WebAdminApp logon form. But if site is configured for HTTP 	authentication (to open a separate username/password dialog window to user), and 
	a session is not yet logged in, this method will return true"
	^self isLoggedIn not and: [self site securityManager hasHttpAuthenticationScheme]!

isLoggedIn
	^self user notNil and: [self user isGuest not]!

language
	^language!

language: aSymbol
	"set the language of a web request originator. Default is #english if language cannot be determined"
	language := aSymbol.!

lastApp
	"return WebApplication subclass which was called with last request"
	^lastApp!

lastApp: anObject
	lastApp := anObject!

lastRequest
	^lastRequest!

lastRequest: aRequest
	"remember the last, actualy current request pending. also add request to the history in a request 
	if logging is on. If first request then also try to find country, language and codePage 
	of the originator"
	self lastRequest isNil ifTrue:   "first request on a session"
		[lastRequest := aRequest.  
		self country: (self originatorCountryFrom: aRequest).
		self language: (self originatorLanguage).
		self codePage: (self originatorCodePage)].
	self requests isEmpty 
		ifTrue: [self requests add: self lastRequest] ifFalse: [self requests at: 1 put: self lastRequest]. 
	lastRequest := aRequest.  
"	self site logging ifTrue: [self requests add: aRequest]. "
	parms := Dictionary new.       "clear old paramters"
	self newView: self viewFromLastRequest.   "default new view should be view from last request"!

lastView
	"return a view of WebApllication, which is created in response to last request"
	^lastView!

lastView: aSymbol

	lastView := aSymbol!

lastViewOld

	"return a value of a 'view' parameter in query part of last request's URL. If no such a parameter, then returns '' "

	^self lastRequest queryAt: 'view' ifAbsent: [^''].!

loginUser: aWebUser
	self user: aWebUser.!

logout
	"Replace logged user with Guest. Remember last page to return after login again"
	| origin usr |
	self redirectLink: nil. 	self redirectOrigin: nil.
	self isLoggedIn ifTrue: [usr := self user. self initUser] ifFalse: [^nil].
	origin := usr lastAppUrl. 
	(origin isNil or: [origin = self lastRequest uriString])  ifFalse: 
		[usr logoutFromUrl: origin]. "to jump back after login"!

newView

	"return a value of a 'view' parameter in query part of a URL to be generated. Also used for changing views in a state machine for web applications (in method actionFormForm (here is set) and method printWebPage (here is used to genererate appropriate page))"

	^self parms at: 'view' ifAbsent: [^''].!

newView: aString
	"set a value of a 'view' parameter in query part of a URL to be generated. Also used for changing 
	views in a state machine for web applications (in method actionFormForm (here is set) and method 	printWebPage (here is used to genererate appropriate page))"
	((aString = '') or: [aString isNil]) ifFalse: [self parms at: 'view' put: aString ].!

originatorCodePage
	"try to gues codePage from country"
	"^#iso2." 
	^#'UTF_8'.!

originatorCountryFrom: aRequest
	"find an ISO country code from a web request"
	^#si "for now"!

originatorLanguage
	"find a language from a web request"
	self country = #si ifTrue: [^#slovene] ifFalse: [^#english].!

parent
	"a session manager !! "
	^parent!

parent: aWebSessionManager
	parent := aWebSessionManager.!

parms
	"This is a dictionary of parameters in query part of url. When web request arrives, paramteres from query string are written here. When any url is dynamically generated, those parms are appended to it as a query string. You can add, change or delete any parameter to better suit your needs (eg. view=brief to instruct brief view of an object) "


	^parms!

redirectLink
	"if this aWebLink is set, then web browser will recreate another request with url from that link. Used, if you like, after form action in one page to show page for some other object, e.g. if you have search field in page in one object, and search result is exactly one, then you want to show result page immediately. You can do this with this method.
Atribute redirectLink is reset to nil immediately after printWebPage and before printHTMLPage in WebMediator method dicpatchClient (see WebMediator sendResponseHeaderOn:)"


	^redirectLink!

redirectLink: aWebLink
	(aWebLink isKindOf: WebLink) | aWebLink isNil ifTrue: [redirectLink:= aWebLink].!

redirectOrigin

	"this is an URL from where the redirection request originates. Used for returning back from
	exception page, for example when you want to see page without access rights, then you are 	redirected to login page. after successfull login, you are redirected back to intended page.
	Redirect origin is set up automatically by redirectLink: request."

	^redirectOrigin!

redirectOrigin: anUrlString
	redirectOrigin := anUrlString.!

redirectToOrigin

	"Used for returning back from
	exception page, for example when you want to see page without access rights, then you are 	redirected to login page. after successfull login, you are redirected back to intended page.
	Redirect origin is set up automatically by redirectLink: request."

	self redirectOrigin notNil
		ifTrue:
			[self redirectLink: (WebLink text: '' linkTo: self redirectOrigin).
			self redirectOrigin: nil].!

removeApp: anApplication for: anObject type: aSymbol
	(self appsForObjects at: anObject ifAbsent: [^nil])
		removeKey: aSymbol ifAbsent: [^nil]!

removeObject: anObject
	self appsForObjects 	removeKey: anObject ifAbsent: [].!

removeWapApp: aWapApplication for: anObject
	^self removeApp: aWapApplication for: anObject type: #wap!

removeWebApp: aWebApplication for: anObject
	^self removeApp: aWebApplication for: anObject type: #web!

removeYourself
	" .. from session manager"
	self parent notNil ifTrue: [self parent removeSession: self].
	self initAppsForObjects.
	self parent: nil.!

requestNum

	"return number of all requests up to now on this session"

	^requests size!

requests
	"return the history of all requests on this session as ordered collection with the oldest as 
	first and newest as last"
	requests isNil ifTrue: [requests := OrderedCollection new].
	^requests!

secureCookie
	"true if web request in this secure session uses cookies, false otherwise"
	^self cookies at: 2!

secureCookie: aBoolean
	self cookies at: 2 put: aBoolean!

secureId

	"return the unique identification of a secure session to browser. This is a random generated number at session generation. It can be used for session tracking in URLs, forms, etc."

	^self ids at: 2!

secureId: aNumber
	"return the unique identification of a secure session. This is a random generated number 
	at session generation. It can be used for session tracking in URLs, forms, etc."
	self ids at: 2 put: aNumber.!

servletAppFor: aWebAppSymbol
	| app class |
	(self servlets includesKey: aWebAppSymbol) ifFalse:
		[class := WebApplication allSubclasses detect:  
			[:each | each name = aWebAppSymbol] ifNone: [^nil].
		app := class new.
		app session: self.
		self servlets at: aWebAppSymbol put: app].
	^self servlets at: aWebAppSymbol.!

servlets
	(self userValues includesKey: #ServletApps) ifFalse:
		[self userValues at: #ServletApps put: IdentityDictionary new].
	^self userValues at: #ServletApps!

setCreatedTimestamp
	created := Timestamp now.!

setRandomIds
	self id: (Random new next * 1000000000) asInteger.
	self secureId: (Random new next * 1000000000) asInteger.!

shouldCountRequests
	| policy |
	policy := self site countingPolicy.
	policy = #all ifTrue: [^true].
	policy = #none ifTrue: [^false].
	policy = #onlyGuests ifTrue: [^self user isGuest].
	policy = #exludeAdmins ifTrue: [^self user isAdmin not].
	^true!

shouldLogRequests
	| policy |
	policy := self site loggingPolicy.
	policy = #all ifTrue: [^true].
	policy = #none ifTrue: [^false].
	policy = #onlyGuests ifTrue: [^self user isGuest].
	policy = #exludeAdmins ifTrue: [^self user isAdmin not].
	^true!

site
	"a session manager !! "
	^self parent site!

user
	^user!

user: aWebUser
	"set a reference to aWebUser, who is logged into this session"
	user := aWebUser.!

userValueAt: aSymbol
	"anything you need to share among Apps in that seesion, like last selected stuff, etc."
	^self userValueAt: aSymbol ifAbsent: [nil]!

userValueAt: aSymbol ifAbsent: aBlock
	^self userValues at: aSymbol ifAbsent: aBlock!

userValueAt: aSymbol put: anObject
	^self userValues at: aSymbol put: anObject!

userValues
	"return a dictionary with user defined values, which scope is this session. Used for such things
	as global navigation, remembering views etc."

	userValues isNil ifTrue: [userValues := Dictionary new].
	^userValues!

viewFromLastRequest

	"return a value of a 'view' parameter in query part of last request's URL. If no such a parameter, then returns '' "

	^self lastRequest queryAt: 'view' ifAbsent: [''].!

wapAppFor: anObject
	^self appFor: anObject type: #wap!

webAppFor: anObject
	^self appFor: anObject type: #web! !
!WebSession categoriesFor: #addApp:for:type:!private! !
!WebSession categoriesFor: #addSessionID!private! !
!WebSession categoriesFor: #addWapApp:for:!private!web/wap apps! !
!WebSession categoriesFor: #addWebApp:for:!private!web/wap apps! !
!WebSession categoriesFor: #adminAllowed!private!security! !
!WebSession categoriesFor: #appFor:type:!private! !
!WebSession categoriesFor: #appsForObjects!private! !
!WebSession categoriesFor: #authenticateFrom:!private!security! !
!WebSession categoriesFor: #browser!accessing!private! !
!WebSession categoriesFor: #browserString!accessing!private! !
!WebSession categoriesFor: #checkExpirationAndPossiblyLogoutFor:!private!security! !
!WebSession categoriesFor: #clipboard!accessing!private! !
!WebSession categoriesFor: #codePage!locale support!private! !
!WebSession categoriesFor: #codePage:!locale support!private! !
!WebSession categoriesFor: #cookie!accessing!private! !
!WebSession categoriesFor: #cookie:!accessing!private! !
!WebSession categoriesFor: #cookies!private! !
!WebSession categoriesFor: #country!locale support!private! !
!WebSession categoriesFor: #country:!locale support!private! !
!WebSession categoriesFor: #created!accessing!private! !
!WebSession categoriesFor: #fullUrlForCurrentPage!accessing!private! !
!WebSession categoriesFor: #fullUrlForPreviousPage!accessing!private! !
!WebSession categoriesFor: #hasSecureCookie!private!testing! !
!WebSession categoriesFor: #id!accessing!private! !
!WebSession categoriesFor: #id:!accessing!private! !
!WebSession categoriesFor: #ids!private! !
!WebSession categoriesFor: #initAppsForObjects!initialize-release!private! !
!WebSession categoriesFor: #initClipboard!initialize-release!private! !
!WebSession categoriesFor: #initCookies!initialize-release!private! !
!WebSession categoriesFor: #initialize!initialize-release!private! !
!WebSession categoriesFor: #initIds!initialize-release!private! !
!WebSession categoriesFor: #initLocales!initialize-release!private! !
!WebSession categoriesFor: #initParms!initialize-release!private! !
!WebSession categoriesFor: #initRequests!initialize-release!private! !
!WebSession categoriesFor: #initUser!initialize-release!private! !
!WebSession categoriesFor: #isActive!private!testing! !
!WebSession categoriesFor: #isEncrypted!private!testing! !
!WebSession categoriesFor: #isExpired!private!testing! !
!WebSession categoriesFor: #isFromLinux!private!testing! !
!WebSession categoriesFor: #isFromMSIE!private!testing! !
!WebSession categoriesFor: #isFromNetscape!private!testing! !
!WebSession categoriesFor: #isFromWindows!private!testing! !
!WebSession categoriesFor: #isHttpAuthenticationNeeded!private!testing! !
!WebSession categoriesFor: #isLoggedIn!private!testing! !
!WebSession categoriesFor: #language!locale support!private! !
!WebSession categoriesFor: #language:!locale support!private! !
!WebSession categoriesFor: #lastApp!private!web/wap apps! !
!WebSession categoriesFor: #lastApp:!private!web/wap apps! !
!WebSession categoriesFor: #lastRequest!accessing!private! !
!WebSession categoriesFor: #lastRequest:!accessing!private! !
!WebSession categoriesFor: #lastView!accessing!private! !
!WebSession categoriesFor: #lastView:!accessing!private! !
!WebSession categoriesFor: #lastViewOld!accessing!private! !
!WebSession categoriesFor: #loginUser:!private!security! !
!WebSession categoriesFor: #logout!private!security! !
!WebSession categoriesFor: #newView!accessing!private! !
!WebSession categoriesFor: #newView:!accessing!private! !
!WebSession categoriesFor: #originatorCodePage!locale support!private! !
!WebSession categoriesFor: #originatorCountryFrom:!locale support!private! !
!WebSession categoriesFor: #originatorLanguage!locale support!private! !
!WebSession categoriesFor: #parent!accessing!private! !
!WebSession categoriesFor: #parent:!private! !
!WebSession categoriesFor: #parms!accessing!private! !
!WebSession categoriesFor: #redirectLink!private!redirection! !
!WebSession categoriesFor: #redirectLink:!private!redirection! !
!WebSession categoriesFor: #redirectOrigin!private!redirection! !
!WebSession categoriesFor: #redirectOrigin:!private!redirection! !
!WebSession categoriesFor: #redirectToOrigin!private!redirection! !
!WebSession categoriesFor: #removeApp:for:type:!private! !
!WebSession categoriesFor: #removeObject:!private!web/wap apps! !
!WebSession categoriesFor: #removeWapApp:for:!private!web/wap apps! !
!WebSession categoriesFor: #removeWebApp:for:!private!web/wap apps! !
!WebSession categoriesFor: #removeYourself!accessing!private! !
!WebSession categoriesFor: #requestNum!accessing!private! !
!WebSession categoriesFor: #requests!accessing!private! !
!WebSession categoriesFor: #secureCookie!accessing!private! !
!WebSession categoriesFor: #secureCookie:!accessing!private! !
!WebSession categoriesFor: #secureId!accessing!private! !
!WebSession categoriesFor: #secureId:!accessing!private! !
!WebSession categoriesFor: #servletAppFor:!private!servlets! !
!WebSession categoriesFor: #servlets!private!servlets! !
!WebSession categoriesFor: #setCreatedTimestamp!initialize-release!private! !
!WebSession categoriesFor: #setRandomIds!initialize-release!private! !
!WebSession categoriesFor: #shouldCountRequests!private!testing! !
!WebSession categoriesFor: #shouldLogRequests!private!testing! !
!WebSession categoriesFor: #site!accessing!private! !
!WebSession categoriesFor: #user!accessing!private! !
!WebSession categoriesFor: #user:!accessing!private! !
!WebSession categoriesFor: #userValueAt:!private!user values! !
!WebSession categoriesFor: #userValueAt:ifAbsent:!private!user values! !
!WebSession categoriesFor: #userValueAt:put:!private!user values! !
!WebSession categoriesFor: #userValues!private! !
!WebSession categoriesFor: #viewFromLastRequest!accessing!private! !
!WebSession categoriesFor: #wapAppFor:!private!web/wap apps! !
!WebSession categoriesFor: #webAppFor:!private!web/wap apps! !

!WebSession class methodsFor!

newOn: aWebSessionManager
	"new web session on a specified session manager"
	| session |
	session := super new.
	session parent: aWebSessionManager.
	session initialize.
	^session! !
!WebSession class categoriesFor: #newOn:!instance creation!private! !

WebSessionManager guid: (GUID fromString: '{ED681E49-13A1-4BB1-9435-FFD551DEA278}')!
WebSessionManager comment: ''!
!WebSessionManager categoriesForClass!Unclassified! !
!WebSessionManager methodsFor!

activeSessions
	activeSessions isNil ifTrue: [self initActiveSessions].
	^activeSessions!

addToActiveSessions: aWebSession
	self site critical:
		[self activeSessions 
			at: aWebSession id put: aWebSession;
			at: aWebSession secureId put: aWebSession]!

allGuestSessions
	^self allSessions select: [:each | each user isGuest].!

allHostAddresses

	"return a collection of all different host IP addresses"

	| allRequests allHosts addr |
	allRequests := self allRequestsByTime.
	allHosts := OrderedCollection new.
	allRequests do: [:request | 
		addr := request envVariables at: #remote_addr.
		(allHosts includes: addr) ifFalse: [allHosts add: addr].
	].
	^allHosts.!

allRequestsByTime

	"return a collection of all requests for all sessions, ordered by time (the newest request first). "

	| allRequests  |
	allRequests := OrderedCollection new.
	self sessionsByID do: [:session |
		session requests notNil ifTrue:
			[allRequests addAll: session requests]].
	^allRequests asSortedCollection:  
		[:requestA :requestB | requestA timestamp > requestB timestamp]

"WebSessionManager instance allRequestsByTime"!

allSessions
	^self sessionsByID values asSet addAll: self activeSessions values; yourself!

allTodayRequestsByTime

	"return a collection of all requests for all sessions, ordered by time (the newest request first). "

	| allRequests |
	allRequests := self allRequestsByTime.
	^allRequests select: [:request | request timestamp asDate = Date today]

"WebSessionManager default allTodayRequestsByTime"!

allTodayRequestsNotOurs

	""

	| allRequests |
	allRequests := self allTodayRequestsByTime.
	^allRequests select: [:request | ('194.165.99*' match: request address) not and:
		[(('*.gif*' match: request path asLowercase) | ('*.jpg*' match: request path asLowercase)) not]]

"WebSessionManager default allTodayRequestsNotOurs"!

allYesterdayRequestsByTime

	"return a collection of all requests for all sessions, ordered by time (the newest request first). "

	| allRequests |
	allRequests := self allRequestsByTime.
	^allRequests select: [:request | request timestamp asDate = (Date today - 1)]

"WebSessionManager default allYesterdayRequestsByTime"!

allYesterdayRequestsNotOurs

	""

	| allRequests |
	allRequests := self allYesterdayRequestsByTime.
	^allRequests select: [:request | ('194.165.99*' match: request address) not and:
		[(('*.gif*' match: request path asLowercase) | ('*.jpg*' match: request path asLowercase)) not]]

"WebSessionManager default allYesterdayRequestsNotOurs"!

bindSSLSessionFor: aRequest
	"Try to find a session among currently live sessions. It helps with a session id in a query 
	part of url. If not found, or id not in query string, then make a new session"
	| session id |
	id := aRequest queryAt: 'sessionId' ifAbsent: [self error: 'no session id!!'].
	session := (self existSessionWithID: id asInteger)
		ifTrue: [self findSessionWithID: id asInteger]
		ifFalse: [self error: 'no session with that id'].
	session requests size = 1
		ifTrue: [self countNewVisitor]
		ifFalse: 	[self checkAndCountReturningVisitor: session].
	session lastRequest: aRequest.

	(aRequest includesQuery: 'codepage') ifTrue:
		[session codePage: (aRequest queryAt: 'codepage') asSymbol].
	(aRequest includesQuery:  'language') ifTrue:
		[session language: (aRequest queryAt: 'language') asSymbol].

	^session.!

checkAndCountReturningVisitor: aSession
	"returning visitor is those who is not active more than 1h"
	(aSession isActive not and: [aSession requests size > 1]) ifTrue:
		[self site critical: [self site returningVisitorsCounter incCounter] ]!

countNewVisitor
	self site critical:
		[self site newVisitorsCounter incCounter]!

existSessionWithID: anIDNumber
	| exist |
	exist := self activeSessions includesKey: anIDNumber.
	exist ifTrue: [^true].
	^self sessionsByID includesKey: anIDNumber!

findOrMakeSessionFor: aRequest
	"Try to find a session among currently live sessions. It helps with a session id in a query 
	part of url. If not found, or id not in query string, then make a new session"
	| session id cookie |
	(self hasSSLBinding: aRequest) ifTrue: [^self bindSSLSessionFor: aRequest].
	(aRequest hasCookie and: [aRequest idFromCookie notNil])
		ifTrue: [id := aRequest idFromCookie. cookie := true. self site log: ' cookie ' ]
		ifFalse: 
			[cookie := false. id := aRequest queryAt: 'id' ifAbsent: [(self newSessionCookie: cookie) id] ].
	session := (self existSessionWithID: id asInteger)
		ifTrue: [self findSessionWithID: id asInteger] 
		ifFalse: [self newSessionCookie: cookie id: id asInteger].
	session requests size = 1 
		ifTrue: [self countNewVisitor] ifFalse: 	[self checkAndCountReturningVisitor: session].
	session checkExpirationAndPossiblyLogoutFor: aRequest.
	session lastRequest: aRequest.
	session cookie: cookie. cookie ifFalse: [session addSessionID].

	(aRequest includesQuery: 'codepage') ifTrue: 
		[session codePage: (aRequest queryAt: 'codepage') asSymbol].
	(aRequest includesQuery:  'language') ifTrue:
		[session language: (aRequest queryAt: 'language') asSymbol].
	^session.!

findSessionWithID: anIDNumber
	| session |
	session := self activeSessions at: anIDNumber ifAbsent: [nil].
	session notNil ifTrue: [^session].
	session := self sessionsByID at: anIDNumber ifAbsent: [nil].
	self addToActiveSessions: session.
	^session!

hasSSLBinding: aRequest
	"if sessionId=456546464 exist in query part of request. This means that this is 
	a SSL session with its own cookie and must be bind to a normal session with sessionId"

	^aRequest isEncrypted and: [aRequest includesQuery: 'sessionId']!

initActiveSessions
	activeSessions := Dictionary new.!

initAppsForObjects
	"WebSessionManager default initAppsForObjects"
	self activeSessions values do: [:each | each initAppsForObjects]!

initialize
	sessionsByID := Dictionary new.
	sessionsByAddress := Dictionary new. 
	self initActiveSessions.

"WebSessionManager default initialize"!

newSessionCookie: aBoolean
	"open and return a fresh new session"
	| session |
	session := WebSession newOn: self.
	self site log: ' new session '.
	self addToActiveSessions: session.
	session cookie: aBoolean.
	^session!

newSessionCookie: aBoolean id: aSessionID
	"open and return a fresh new session"
	| session |
	session := WebSession newOn: self.
	aSessionID notNil ifTrue: [session id: aSessionID].
	self site log: ' new session '.
	self addToActiveSessions: session.
	session cookie: aBoolean.
	^session!

releaseNonactiveSessions
	"release from memory all nonactive sessions"
	self activeSessions values do: [:each | 
		each isActive ifFalse: 
			[self site critical: [self removeFromActiveSessions: each] ] ].!

removeAllSessions

	| allKeys |
	allKeys := 	self sessionsByAddress keys.
	allKeys do: [:key | self sessionsByAddress removeKey: key].
	allKeys := 	self sessionsByID keys.
	allKeys do: [:key | self sessionsByID removeKey: key].!

removeFromActiveSessions: aWebSession
	"remove from active sessions and archive it in main dictionary, if not already"
	self site critical:
		[self activeSessions 
			removeKey: aWebSession id ifAbsent: [];
			removeKey: aWebSession secureId ifAbsent: [].
		(self sessionsByID includesKey: aWebSession id) ifFalse:
			[self sessionsByID
				at: aWebSession id put: aWebSession;
				at: aWebSession secureId put: aWebSession] ].!

removeGuestSessions
	^self allGuestSessions do: [:each | 
		each parent == self ifTrue: [each removeYourself] ifFalse: [self removeSession: each] ].!

removeSession: aWebSession
	self activeSessions removeKey: aWebSession id ifAbsent: [].
	self activeSessions removeKey: aWebSession secureId ifAbsent: [].
	self sessionsByID removeKey: aWebSession id ifAbsent: [].	
	self sessionsByID removeKey: aWebSession secureId ifAbsent: [].	
	self	sessionsByAddress removeKey: aWebSession ifAbsent: [].!

sessionsByAddress
	^sessionsByAddress!

sessionsByID
	^sessionsByID!

site
	^site!

site: anAIDASite
	site := anAIDASite.! !
!WebSessionManager categoriesFor: #activeSessions!accessing!private! !
!WebSessionManager categoriesFor: #addToActiveSessions:!private!private - active sessions! !
!WebSessionManager categoriesFor: #allGuestSessions!accessing!private! !
!WebSessionManager categoriesFor: #allHostAddresses!accessing!private! !
!WebSessionManager categoriesFor: #allRequestsByTime!accessing-requests!private! !
!WebSessionManager categoriesFor: #allSessions!accessing!private! !
!WebSessionManager categoriesFor: #allTodayRequestsByTime!accessing-requests!private! !
!WebSessionManager categoriesFor: #allTodayRequestsNotOurs!accessing-requests!private! !
!WebSessionManager categoriesFor: #allYesterdayRequestsByTime!accessing-requests!private! !
!WebSessionManager categoriesFor: #allYesterdayRequestsNotOurs!accessing-requests!private! !
!WebSessionManager categoriesFor: #bindSSLSessionFor:!private! !
!WebSessionManager categoriesFor: #checkAndCountReturningVisitor:!private! !
!WebSessionManager categoriesFor: #countNewVisitor!private! !
!WebSessionManager categoriesFor: #existSessionWithID:!private! !
!WebSessionManager categoriesFor: #findOrMakeSessionFor:!adding-removing!private! !
!WebSessionManager categoriesFor: #findSessionWithID:!private! !
!WebSessionManager categoriesFor: #hasSSLBinding:!private! !
!WebSessionManager categoriesFor: #initActiveSessions!initialize-release!private! !
!WebSessionManager categoriesFor: #initAppsForObjects!initialize-release!private! !
!WebSessionManager categoriesFor: #initialize!initialize-release!private! !
!WebSessionManager categoriesFor: #newSessionCookie:!private! !
!WebSessionManager categoriesFor: #newSessionCookie:id:!private! !
!WebSessionManager categoriesFor: #releaseNonactiveSessions!adding-removing!private! !
!WebSessionManager categoriesFor: #removeAllSessions!adding-removing!private! !
!WebSessionManager categoriesFor: #removeFromActiveSessions:!private!private - active sessions! !
!WebSessionManager categoriesFor: #removeGuestSessions!adding-removing!private! !
!WebSessionManager categoriesFor: #removeSession:!adding-removing!private! !
!WebSessionManager categoriesFor: #sessionsByAddress!accessing!private! !
!WebSessionManager categoriesFor: #sessionsByID!accessing!private! !
!WebSessionManager categoriesFor: #site!accessing!private! !
!WebSessionManager categoriesFor: #site:!private! !

!WebSessionManager class methodsFor!

default
	^AIDASite default sessionManager!

newOn: aSite
	^super new 
		initialize; 
		site: aSite! !
!WebSessionManager class categoriesFor: #default!accessing!private! !
!WebSessionManager class categoriesFor: #newOn:!instance creation!private! !

WebStatistics guid: (GUID fromString: '{E5F8C876-76C1-4968-A7CD-E05078B45CB1}')!
WebStatistics comment: ''!
!WebStatistics categoriesForClass!Unclassified! !
!WebStatistics methodsFor!

addNewReferer: anUrlString

	"add new counter to referers dictionary"

	self referers 
		at: anUrlString
		put: WebCounter new.!

allReferersAndCounts
	"return a collection of all referers and their total counts, most counted first"

	| collection |
	collection := OrderedCollection new.
	self referers keysAndValuesDo: [:referer :counter |  
		collection add: (Array 
			with: referer
			with: counter total)].
	^SortedCollection
		withAll: collection
		sortBlock: [:a :b | (a at: 2) > (b at: 2)].

"WebStatistics default allReferersAndCounts"!

collectStatsFrom: aWebRequest

	self countReferer: aWebRequest referer.!

countReferer: anUrlString

	| url |
	url := self prepareReferer: anUrlString.
	url isEmpty ifTrue: [^self].
	(self isLocalUrl: url) ifTrue: [^self]. 
	(self refererOnStopList: url) ifTrue: [^self].
	(self referers includesKey: url)
		ifFalse: [self addNewReferer: url].
	(self referers at: url) incCounter!

initReferers
	referers := Dictionary new.

"WebServer default statistics initReferers"!

initRefererStopList
	refererStopList := Set new.
	refererStopList
		add: '[unknown origin]';
		add: 'bookmarks';
		add: 'http://lw2fd.hotmail.msn.com/cgi-bin/getmsg';
		add: 'http://mobitel.sux.nu/cgi-bin/tabla/showpost.pl'.
"WebServer default statistics initRefererStopList"!

isLocalUrl: anUrlString

	"true, if this url points to page from this server"

	^('*', self site name, '*') match: anUrlString asLowercase
"	^('*', self site address, '*') match: anUrlString"!

prepareReferer: anUrlString

	"ingnore all parameters in url"

	^(anUrlString copyUpTo: $?)!

refererCounterFor: anUrlString

	^self referers at: anUrlString ifAbsent: [^nil]!

refererOnStopList: anUrlString

	| |
	^self refererStopList includes: anUrlString!

referers
	referers isNil ifTrue: [self initReferers].
	^referers!

refererStopList
	refererStopList isNil ifTrue: [self initRefererStopList].
	^refererStopList!

removeReferer: anUrlString

	self referers removeKey: anUrlString ifAbsent: [^self].!

removeReferersOnStopList

	self refererStopList do: [:referer |
		self removeReferer: referer]

"WebStatistics default  removeReferersOnStopList"!

site
	^site!

site: anAIDASite
	site := anAIDASite.! !
!WebStatistics categoriesFor: #addNewReferer:!private!referers! !
!WebStatistics categoriesFor: #allReferersAndCounts!private!referers! !
!WebStatistics categoriesFor: #collectStatsFrom:!collecting!private! !
!WebStatistics categoriesFor: #countReferer:!private!referers! !
!WebStatistics categoriesFor: #initReferers!accessing!private! !
!WebStatistics categoriesFor: #initRefererStopList!accessing!private! !
!WebStatistics categoriesFor: #isLocalUrl:!private!referers! !
!WebStatistics categoriesFor: #prepareReferer:!private!referers! !
!WebStatistics categoriesFor: #refererCounterFor:!private!referers! !
!WebStatistics categoriesFor: #refererOnStopList:!private!referers! !
!WebStatistics categoriesFor: #referers!accessing!private! !
!WebStatistics categoriesFor: #refererStopList!accessing!private! !
!WebStatistics categoriesFor: #removeReferer:!private!referers! !
!WebStatistics categoriesFor: #removeReferersOnStopList!private!referers! !
!WebStatistics categoriesFor: #site!accessing!private! !
!WebStatistics categoriesFor: #site:!accessing!private! !

!WebStatistics class methodsFor!

analyzeAndStoreLine: aLineAsArray into: aDictionary forDate:aDate

	| datum |
	((aLineAsArray at: 2) > ' ' ) ifTrue:
		[(aLineAsArray at: 2) = '#Date:'
			ifTrue: [datum := self parseDatum: (aLineAsArray at: 3).]
			ifFalse: [datum:=aDate.].
		((aLineAsArray at: 2) copyFrom: 1 to: 1) = '#' ifFalse: 
			[aLineAsArray at: 2 put: 
				(Time readFrom: (ReadStream on: (aLineAsArray at: 2))).
			aLineAsArray at: 1 put: 
				(Timestamp new fromDate: datum andTime: (aLineAsArray at: 2)).
			(aDictionary at:  (aLineAsArray at: 3) ifAbsentPut: [WebCounter new  ] )
				 incCounterOnTimestamp: (aLineAsArray at: 1).
			].
		].
	^datum!

bossCountersFromIISLogsIn: aDirectoryString

	" WebStatistics bossCountersFromIISLogsIn: 'h:\winnt\system32\logfiles\w3svc3\temp'  "
	| file boss |
	file := 'LogDict.boss'.
	boss := BinaryObjectStorage onNew: file asFilename writeStream.
	boss nextPut: 
		(self countersFromIISLogsIn: aDirectoryString).
	boss close.!

convertFromGMT: aTimestamp

	"IIS logs have time in GMT timezone. Return local time"
	TimeZone reference
		convertGMT: aTimestamp asSeconds
		do: [:date :sec | 	^Timestamp fromDate: date andTime: (Time fromSeconds: sec)]!

countersFromIISLogsIn: aDirectoryString

	"return a dictionary (url as key) of counters for urls in all IIS log files in specified directory"
	" WebStatistics countersFromIISLogsIn: 'h:\winnt\system32\logfiles\w3svc8'  "

	| logFiles urlCounters |
	logFiles := aDirectoryString asFilename directoryContents.
	logFiles := SortedCollection
		withAll: logFiles 	sortBlock: [:a :b | a < b].
	urlCounters := Dictionary new.
	logFiles do: [:logFile | 
		" self halt. "
		self countUrlsIn: (aDirectoryString, '\', logFile) to: urlCounters].
	^urlCounters!

countUrlsIn: aFileString to: anUrlDictionary

self parseFile: aFileString into: anUrlDictionary.!

dateFromFilename: aFilename

	^Date 
		newDay: (aFilename tail copyFrom: 7 to: 8) asInteger
		monthNumber:(aFilename tail copyFrom: 5 to: 6) asInteger
		year: ((aFilename tail copyFrom: 3 to: 4) asInteger + 2000)!

default

	^AIDASite default statistics!

newOn: anAIDASite
	^super new site: anAIDASite!

parseDatum: stringDatum 
	"pretvorimo datum iz formata LLLL-MM-DD v date format
	| tmp | 
	 tmp := DelimitedFile new. 
	Transcript show: (tmp parseDatum: '1999-12-11') printString ; cr  
	"

	| datumStream leto mesec dan |
	datumStream := (stringDatum copyReplaceAll: '-' with: ' ') readStream.
	leto := (self  parseWords: datumStream) asNumber.
	mesec := (self  parseWords: datumStream) asNumber.
	dan := (self  parseWords: datumStream) asNumber.
	^Date newDay: dan
		monthNumber: mesec
		year: leto!

parseFile: aFile 
	"
 	Trenutno opusceno, osnova za parseFile: into:
	WebStatistics parseFile: 'h:\winnt\system32\logfiles\w3svc8\ex990506.log' 
	"

	| logFile stream cr besedeVrstice vrstica stevecBesed |
	cr := Character cr.	" self halt. "
	logFile := aFile asFilename.
	stream := logFile readStream.
	[stream atEnd] whileFalse: 
			[besedeVrstice := Array new: 15.
			stevecBesed := 1.
			vrstica := (stream throughAll: (String with: cr)) readStream.
			[vrstica atEnd] whileFalse: 
					[besedeVrstice at: stevecBesed put: vrstica parseWordsIntoArray.
					stevecBesed := stevecBesed + 1].
			vrstica close].
	stream close!

parseFile: aFile into: URLCountDictionary 
	| stream besedeVrstice vrstica stevecBesed datum |
	datum := Date today.
	stream := aFile asFilename readStream.
	[stream atEnd] whileFalse: 
		[besedeVrstice := Array new: 15.
		stevecBesed := 2.
		vrstica := (stream throughAll: (String with: Character cr)) readStream.
		[vrstica atEnd] whileFalse: 
			[besedeVrstice at: stevecBesed put: (self parseWords: vrstica) .
			stevecBesed := stevecBesed + 1].
 		datum:= self analyzeAndStoreLine: besedeVrstice 
			into: URLCountDictionary forDate:datum.
		vrstica close.].
	stream close

	" test lines : 
	Xx := Dictionary new.
	WebStatistics parseFile: 'h:\winnt\system32\logfiles\w3svc8\ex990506.log' into: Xx.
	Transcript show: Xx printString
	"!

parseWords: inputStream 
	"Answer the contents of the receiver, up to the next separator  character."

	| aStream |
	aStream := (String new: 200) writeStream.
	inputStream skipSeparators.
	inputStream class endOfStreamSignal handle: [:ex | ex return]
		do: 
			[
			[| char |
			char := inputStream next.
			char isSeparator ifTrue: [^aStream contents] ifFalse: [aStream nextPut: char]]
					repeat].
	^aStream contents! !
!WebStatistics class categoriesFor: #analyzeAndStoreLine:into:forDate:!log analysis!private! !
!WebStatistics class categoriesFor: #bossCountersFromIISLogsIn:!log analysis!private! !
!WebStatistics class categoriesFor: #convertFromGMT:!log analysis!private! !
!WebStatistics class categoriesFor: #countersFromIISLogsIn:!log analysis!private! !
!WebStatistics class categoriesFor: #countUrlsIn:to:!log analysis!private! !
!WebStatistics class categoriesFor: #dateFromFilename:!log analysis!private! !
!WebStatistics class categoriesFor: #default!accessing!private! !
!WebStatistics class categoriesFor: #newOn:!instance creation!private! !
!WebStatistics class categoriesFor: #parseDatum:!log analysis!private! !
!WebStatistics class categoriesFor: #parseFile:!log analysis!private! !
!WebStatistics class categoriesFor: #parseFile:into:!log analysis!private! !
!WebStatistics class categoriesFor: #parseWords:!log analysis!private! !

WebStyle guid: (GUID fromString: '{219CD516-F4A1-4CBF-B830-A6954AD59867}')!
WebStyle comment: ''!
!WebStyle categoriesForClass!Unclassified! !
!WebStyle methodsFor!

addBreaksTo: aString
	"changes all cr with <br>"

	^aString copyReplaceAll: (String with: Character cr) with: '<br>'

"WebFrameApp new addBreaksTo: ('aaa', (String with: Character cr), 'bbb')"!

addHelpText
	^'Add help page'!

addParagraphsTo: aString
	"changes all cr with <p>"

	^aString copyReplaceAll: (String with: Character cr) with: '<p>'

"WebFrameApp new addParagraphsTo: ('aaa', (String with: Character cr), 'bbb')"!

adminColor
	^#green!

adobeLeafGif
	"'imgs/adobe-leaf.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 50 0 50 0 247 0 0 202 44 13 255 230 0 175 117 98 255 175 74 173 171 166 114 35 9 213 205 201 215 54 41 171 68 11 69 84 18 207 184 182 254 218 1 247 181 170 137 45 11 203 25 9 255 200 89 109 135 58 168 152 82 231 89 70 231 53 38 252 244 231 47 13 9 150 140 140 242 161 148 255 181 1 220 59 51 194 148 78 69 22 12 255 243 243 254 171 1 108 114 46 251 218 215 43 54 14 230 227 227 252 153 0 251 156 152 59 74 14 250 167 135 255 72 6 244 229 150 250 169 163 255 197 0 254 139 0 220 64 54 18 4 3 205 111 3 137 141 78 178 184 159 223 26 11 249 150 137 253 101 6 142 5 6 167 155 155 149 72 65 217 221 208 234 68 67 255 88 19 253 246 188 253 236 234 142 162 89 234 220 218 248 199 197 113 11 2 255 117 39 252 198 136 226 60 46 226 65 59 79 96 20 235 67 59 252 136 87 255 135 57 244 119 120 255 108 37 254 191 133 228 34 26 255 229 166 134 102 101 247 162 113 181 48 7 149 156 124 216 43 35 254 250 249 251 76 16 217 100 41 166 3 7 230 43 36 255 204 166 185 6 5 248 176 126 247 120 107 245 210 128 254 137 134 91 35 15 255 107 80 234 165 1 230 74 60 255 241 0 104 114 81 229 65 52 200 200 114 255 217 136 235 102 88 90 109 34 229 73 68 255 255 241 255 129 39 195 85 3 246 104 58 243 58 40 246 136 118 252 195 188 229 217 204 182 80 39 251 215 178 255 248 215 246 80 51 145 116 51 255 102 31 251 199 152 255 255 0 243 105 98 235 230 221 255 151 39 252 156 117 194 88 18 242 137 23 253 38 1 255 83 11 250 230 221 204 84 67 252 112 5 236 68 52 181 19 7 212 89 20 238 234 149 238 89 83 234 62 59 245 233 230 232 121 43 231 52 49 161 22 4 255 220 27 255 57 0 245 187 149 213 68 47 113 88 87 238 238 235 230 180 3 253 224 225 255 153 60 236 75 59 252 253 251 213 172 91 245 157 167 226 48 45 233 226 137 229 59 17 232 58 52 240 113 92 235 73 73 240 71 70 85 82 73 226 69 63 255 101 66 225 128 57 27 36 2 244 150 20 220 69 5 236 102 74 242 87 64 251 209 207 247 121 78 231 76 51 157 72 27 233 79 71 236 84 63 255 251 251 249 248 247 255 255 255 234 64 64 255 255 251 221 96 93 223 185 167 249 231 205 242 166 109 234 149 94 255 255 254 221 123 114 237 94 75 255 194 60 255 253 253 214 210 132 230 68 48 232 129 1 255 255 207 248 189 196 188 100 0 232 171 161 222 187 180 127 52 21 236 86 2 60 50 51 237 94 20 192 147 130 246 247 247 231 120 57 219 37 18 254 247 247 234 191 128 241 142 136 255 145 146 255 230 94 255 248 125 191 188 184 68 74 42 255 172 52 225 104 0 237 116 12 250 122 95 255 127 21 255 224 181 214 199 192 249 193 175 238 80 80 225 175 104 177 64 53 225 177 112 243 186 105 230 199 182 248 208 167 244 228 134 156 181 115 234 116 100 239 127 115 240 63 61 239 64 51 210 69 29 255 93 28 239 128 75 238 48 30 230 153 78 202 151 136 253 150 64 251 160 81 232 55 55 203 166 153 229 63 56 231 208 200 223 84 0 254 254 254 252 239 239 255 254 254 99 96 90 206 78 43 198 76 49 132 132 125 33 249 4 0 0 0 0 0 44 0 0 0 0 50 0 50 0 0 8 255 0 101 9 28 72 144 224 135 130 8 19 42 92 200 144 32 186 50 28 26 74 156 216 208 147 24 49 187 18 81 220 184 241 25 176 47 98 28 80 9 167 145 35 65 85 176 76 10 188 16 228 75 16 40 34 103 24 51 169 131 193 23 86 42 101 121 252 226 74 76 144 9 0 24 205 80 48 241 67 52 151 65 196 72 200 137 2 152 43 87 103 190 88 178 20 132 145 15 73 12 245 149 233 212 201 158 168 51 103 36 68 81 89 230 213 183 79 55 210 126 2 5 10 10 164 133 31 22 117 181 39 228 107 212 131 38 81 73 56 132 22 209 172 27 108 213 41 81 149 240 67 149 185 116 235 70 189 160 18 21 175 67 103 111 204 154 60 11 81 149 67 8 159 113 37 98 239 34 93 187 101 84 122 122 28 89 50 87 122 139 148 232 40 136 103 2 17 34 98 236 101 88 161 88 212 82 147 109 94 185 74 75 25 17 106 77 48 24 15 164 84 133 136 165 65 178 103 215 21 101 59 179 62 125 148 122 48 184 192 224 195 88 89 12 94 89 234 180 104 17 189 239 191 149 16 255 33 88 102 2 200 32 25 210 43 103 126 155 32 172 76 240 51 141 24 113 161 190 183 103 170 214 173 155 80 5 10 20 77 0 2 88 133 18 215 69 81 69 16 43 168 167 224 10 162 172 144 78 66 195 28 33 97 22 20 182 209 134 39 68 172 193 134 18 206 56 224 161 3 255 1 152 26 94 110 40 129 222 1 40 46 184 194 1 12 36 164 195 28 169 12 210 225 135 14 112 146 134 20 87 16 162 35 33 87 92 1 5 43 171 236 81 2 32 2 225 161 4 138 72 30 144 222 10 76 30 176 26 66 186 224 224 135 3 61 246 72 5 33 70 24 81 7 33 51 48 66 5 21 0 144 34 79 150 15 76 147 131 64 118 88 2 69 146 74 50 185 98 32 11 213 225 7 12 85 126 73 197 40 163 32 193 201 12 124 78 49 64 37 117 252 33 5 18 215 44 33 11 45 194 228 80 4 36 254 165 184 164 19 247 44 132 132 35 130 82 209 194 29 147 180 96 74 35 24 72 193 39 41 149 164 129 68 29 237 180 131 3 18 73 200 130 198 18 75 144 49 14 41 253 196 255 10 9 36 254 180 226 1 67 69 248 97 194 31 48 76 114 71 0 119 4 123 71 7 84 176 147 198 15 63 212 129 67 59 127 8 90 132 44 113 0 97 133 21 64 96 162 193 181 116 208 225 65 2 88 45 228 134 174 126 168 0 198 2 1 4 176 192 2 96 96 42 131 20 117 140 186 172 9 82 152 240 236 60 243 120 195 192 35 208 88 235 130 7 102 144 240 66 67 251 56 98 130 184 96 20 108 238 2 41 164 123 135 32 127 200 240 7 188 142 212 145 6 16 178 40 114 138 54 49 148 240 136 56 17 64 208 239 19 19 49 32 131 193 96 4 128 65 7 1 164 80 238 175 56 152 32 240 15 3 60 208 11 55 178 156 2 0 20 120 100 140 69 4 31 83 228 203 54 232 142 43 130 10 29 96 128 65 201 11 220 161 130 9 105 60 64 205 3 3 204 67 129 44 0 120 72 68 27 37 148 160 65 2 255 110 36 7 6 228 98 32 66 10 24 168 192 137 23 11 120 49 110 35 15 84 162 135 30 3 96 145 18 12 14 56 163 4 30 123 52 161 129 13 42 45 255 209 129 8 34 4 0 70 10 34 32 19 140 23 99 167 112 71 47 70 8 34 67 26 123 200 2 139 18 48 216 157 10 46 229 12 20 75 53 255 240 19 202 63 6 52 148 195 208 41 32 124 114 7 168 171 160 248 2 219 200 128 143 50 37 232 196 139 51 149 187 51 181 44 54 132 65 2 8 165 244 222 187 53 221 42 68 65 31 130 0 174 130 8 106 183 224 68 194 41 100 163 6 2 78 160 32 139 14 233 40 82 72 46 2 161 241 203 16 32 144 224 61 8 224 243 94 10 223 12 249 125 188 8 193 4 227 131 15 24 16 222 192 251 140 20 35 139 42 71 228 114 139 64 57 152 51 70 191 9 244 191 123 248 189 235 26 67 228 240 0 21 96 195 42 196 40 155 26 142 81 128 247 197 67 22 40 136 134 47 100 65 129 77 108 194 16 251 235 159 255 254 7 190 82 176 128 0 20 1 132 45 200 208 11 83 16 131 11 92 40 64 1 124 80 15 89 140 96 31 208 130 134 33 102 56 6 15 12 225 134 67 72 0 7 65 240 193 156 8 36 22 33 48 192 50 255 26 32 0 29 60 3 22 40 192 130 29 78 96 136 19 128 99 95 56 204 225 255 88 0 50 31 22 36 22 112 144 134 27 164 49 2 44 36 65 11 90 24 199 60 52 176 47 51 152 225 134 58 44 69 24 84 18 133 68 240 224 13 6 48 64 55 186 177 12 1 48 128 18 148 144 198 22 246 176 135 85 172 33 21 107 128 71 4 92 64 72 143 37 0 4 46 216 72 30 108 161 1 62 60 175 1 5 216 64 5 42 208 64 125 124 32 34 81 64 65 23 230 192 134 78 178 97 13 26 216 129 40 119 0 1 8 8 144 33 177 176 64 5 184 208 0 4 168 225 149 8 56 6 23 54 176 129 6 144 195 133 41 17 8 7 80 48 136 9 188 227 29 108 104 70 4 68 121 14 27 92 98 34 247 168 0 11 88 192 5 56 240 161 16 133 224 67 44 103 89 0 56 8 100 11 9 209 71 15 80 16 3 111 188 33 15 177 216 136 49 26 192 5 101 110 160 21 173 64 128 58 143 33 201 10 108 160 36 120 176 162 66 120 224 131 6 28 67 153 21 56 134 62 245 201 153 133 101 178 32 18 3 169 133 60 19 162 66 89 46 115 3 42 84 97 57 253 201 140 129 192 105 160 4 81 192 42 103 201 130 137 162 112 161 203 4 225 64 194 241 12 136 10 36 31 180 68 33 45 71 74 75 101 46 147 31 5 169 1 15 60 42 11 38 176 96 164 147 140 105 76 151 25 10 132 8 128 6 30 13 129 73 101 42 83 127 226 20 33 10 0 40 75 37 161 74 127 26 149 5 22 8 103 66 36 81 1 150 18 36 4 213 160 1 13 170 97 128 16 72 132 5 74 117 106 78 146 65 62 173 170 132 31 26 245 170 73 254 241 15 177 170 132 6 22 144 103 64 0 0 59 ]!

allCssPrintMethods
	"WebStyle new allCssPrintMethods"
	| methods |
	methods := self class allSelectors select: [:each | 'cssPrint*' match:each asString].
	^SortedCollection withAll: methods sortBlock: [:a :b | a < b]!

allCssScreenMethods
	"for screen styles, all css* except cssPrint* , sorted alphabeticaly"
	"WebStyle new allCssScreenMethods"
	| methods print |
	methods := self class allSelectors select: [:each | 'css*' match:each asString].
	print := self allCssPrintMethods asSet.
	^SortedCollection 
		withAll: (methods reject: [:each | print includes: each])
		sortBlock: [:a :b | a < b]!

allJavascriptMethods
	"for javascript, all js* sorted alphabeticaly (sort is not realy needed, just for convenience)"
	"WebStyle new allJavascriptMethods"
	| methods |
	methods := self class allSelectors select: [:each | 'js*' match:each asString].
	^SortedCollection withAll: methods sortBlock: [:a :b | a < b]!

app
	"try to find a first sender up in calling stack, who is  WebApplication"
	| stackFrame |
	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver isKindOf: WebApplication) ifTrue: [^stackFrame receiver].
		stackFrame := stackFrame sender].
	^nil!

arrowBigBlueGif
	"'imgs/sun-ar_lg_blue_r.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 15 0 13 0 128 1 0 89 79 191 255 255 255 33 249 4 1 0 0 1 0 44 0 0 0 0 15 0 13 0 0 2 26 140 143 169 0 234 220 92 130 114 50 4 179 62 186 223 224 109 21 248 85 212 120 162 209 56 22 0 59 ]!

arrowBigRedGif
	"'imgs/sun-ar_lg_red_r.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 15 0 13 0 128 1 0 205 43 64 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 15 0 13 0 64 2 27 140 143 169 6 189 217 192 155 47 170 136 179 92 150 6 231 49 224 161 105 100 137 81 221 52 34 5 0 59 ]!

arrowBigYellowGif
	"'imgs/sun-ar_lg_yell_r_pad.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 24 0 21 0 128 1 0 251 226 73 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 24 0 21 0 64 2 37 140 143 169 123 224 15 29 155 180 34 105 233 203 188 251 186 101 209 8 124 1 102 166 234 202 133 171 171 145 81 10 119 53 139 231 74 1 0 59 ]!

arrowCircledGreyGif
	"'imgs/adobe-grey_arrow.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 10 0 10 0 145 0 0 102 102 102 255 255 255 153 153 153 204 204 204 33 249 4 0 0 0 0 0 44 0 0 0 0 10 0 10 0 0 2 29 76 38 0 50 22 169 162 56 241 69 84 237 138 192 65 238 41 159 1 49 213 215 124 146 131 45 77 80 0 0 59 ]!

arrowCircledRedGif
	"'imgs/adobe-red_arrow.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 10 0 10 0 162 0 0 255 0 0 255 255 255 255 153 155 255 204 204 254 242 243 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 10 0 10 0 0 3 33 24 49 2 32 131 168 230 170 32 163 6 10 152 222 14 7 40 96 229 144 20 55 133 217 201 13 165 41 144 222 3 7 9 0 59 ]!

arrowDownBigRedGif
	"'imgs/sun-ar_lg_red_d_pad.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 24 0 21 0 128 1 0 204 51 51 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 24 0 21 0 64 2 39 140 143 169 203 224 12 163 92 14 76 90 235 221 188 67 221 105 226 19 146 222 137 94 32 186 158 173 106 5 160 41 101 182 119 167 113 202 115 5 0 59 ]!

arrowNextRedPng
	"'imgs/suse/suse-arrow-next.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 15 0 0 0 14 8 3 0 0 0 199 84 182 221 0 0 0 4 103 65 77 65 0 0 175 200 55 5 138 233 0 0 0 25 116 69 88 116 83 111 102 116 119 97 114 101 0 65 100 111 98 101 32 73 109 97 103 101 82 101 97 100 121 113 201 101 60 0 0 1 23 80 76 84 69 117 160 37 139 191 44 143 197 45 114 156 36 146 200 46 147 202 46 154 209 53 115 158 36 143 196 45 120 165 38 105 145 33 103 141 47 101 91 89 77 108 90 137 192 75 7 9 5 50 53 62 195 184 201 77 83 74 100 105 78 152 165 184 73 75 74 2 10 0 30 50 39 154 184 174 104 143 56 20 27 35 73 81 92 94 87 78 116 158 53 102 140 43 159 165 165 96 127 54 157 163 179 132 149 165 56 53 46 138 195 89 134 193 101 166 189 205 151 207 47 105 135 187 24 19 13 17 13 27 131 159 144 107 130 148 9 20 24 140 156 171 26 28 40 112 146 113 110 149 144 111 152 35 152 208 50 17 24 26 11 15 26 21 21 49 87 94 87 105 143 60 31 26 20 17 4 33 154 173 171 68 64 65 136 187 43 32 40 27 5 16 4 59 53 53 108 97 91 171 175 213 145 199 46 82 113 63 120 146 145 152 208 48 10 14 12 111 153 35 21 21 29 137 189 43 70 81 67 84 86 88 154 155 157 134 184 42 32 31 47 80 78 79 156 167 185 73 72 80 108 149 58 119 163 38 6 6 7 81 85 70 127 127 119 115 145 173 137 135 122 100 102 99 9 11 27 255 255 255 159 1 143 8 0 0 0 93 116 82 78 83 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 225 175 157 144 0 0 0 193 73 68 65 84 120 218 98 136 129 130 112 8 5 16 64 12 48 190 185 56 152 2 8 32 56 95 148 207 10 68 1 4 16 156 47 160 202 107 15 164 0 2 136 33 210 49 192 91 58 204 70 217 95 133 73 206 61 38 6 32 128 24 132 89 57 212 253 56 24 153 88 25 217 217 184 45 99 0 2 136 65 136 153 141 193 153 147 133 193 150 203 152 221 75 86 6 32 128 24 124 20 24 140 56 25 24 60 152 185 24 88 44 76 20 1 2 136 33 202 206 76 95 83 215 211 52 58 132 81 146 223 80 16 32 128 24 98 212 68 172 229 37 2 245 164 220 130 67 117 180 99 0 2 8 110 159 131 139 152 134 107 76 12 64 0 193 249 65 90 17 74 64 10 32 128 224 124 30 95 3 16 5 16 64 112 126 140 19 152 4 8 48 0 50 218 53 59 137 15 17 99 0 0 0 0 73 69 78 68 174 66 96 130 ]!

arrowOrangeDownGif
	"'imgs/dars-arrow-down.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 8 0 5 0 161 2 0 251 171 61 50 138 66 255 255 255 255 255 255 33 249 4 1 0 0 2 0 44 0 0 0 0 8 0 5 0 0 2 12 140 127 160 27 18 11 154 112 74 78 103 11 0 59 ]!

arrowOrangeLeftGif
	"'imgs/dars-arrow-left.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 5 0 8 0 161 2 0 251 171 61 50 138 66 255 255 255 255 255 255 33 249 4 1 0 0 2 0 44 0 0 0 0 5 0 8 0 0 2 13 148 19 7 25 176 237 144 91 2 166 74 79 40 0 59 ]!

arrowOrangeRightGif
	"'imgs/dars-arrow2.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 5 0 8 0 145 2 0 251 171 61 50 138 66 255 255 255 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 5 0 8 0 0 2 14 76 132 1 39 186 13 162 137 203 29 197 12 18 5 0 59 ]!

arrowOrangeUpGif
	"'imgs/dars-arrow-up.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 8 0 5 0 161 2 0 251 171 61 50 138 66 255 255 255 255 255 255 33 249 4 1 0 0 2 0 44 0 0 0 0 8 0 5 0 0 2 12 148 19 166 1 144 215 90 98 81 162 123 11 0 59 ]!

arrowPreviousRedPng
	"'imgs/suse/suse-arrow-prev.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 14 8 3 0 0 0 17 241 108 184 0 0 0 4 103 65 77 65 0 0 175 200 55 5 138 233 0 0 0 25 116 69 88 116 83 111 102 116 119 97 114 101 0 65 100 111 98 101 32 73 109 97 103 101 82 101 97 100 121 113 201 101 60 0 0 1 50 80 76 84 69 114 156 36 143 196 45 109 150 35 115 158 36 146 200 46 151 207 47 117 160 37 119 163 38 152 208 50 27 36 39 1 11 0 86 78 67 33 32 64 19 30 16 0 7 30 74 100 46 18 26 15 39 45 41 104 142 33 71 67 68 113 154 45 17 16 21 106 177 120 13 18 14 104 173 115 78 76 63 15 24 39 162 173 179 113 155 36 98 135 31 137 193 67 154 173 179 30 43 26 162 169 179 162 167 160 153 170 180 42 59 51 75 94 99 130 144 147 51 56 38 8 11 0 131 134 175 164 167 182 126 151 158 156 150 184 110 151 46 39 47 49 155 172 180 202 203 207 14 19 22 110 125 168 14 13 8 153 155 170 19 23 60 102 139 68 1 1 11 96 99 92 34 39 45 94 95 81 126 188 91 17 21 10 79 83 74 147 202 46 20 27 35 162 177 182 149 204 47 15 12 36 167 174 192 81 72 75 134 184 42 131 135 121 120 165 38 88 84 72 124 170 39 148 204 61 127 144 162 87 78 71 4 0 19 7 5 18 100 137 32 161 170 177 85 75 61 141 159 173 71 79 54 154 209 52 140 198 71 155 169 178 95 128 81 158 211 60 187 196 175 11 24 15 5 6 11 160 169 168 95 132 50 18 16 27 151 205 83 143 197 45 137 189 43 132 181 42 127 149 137 176 181 174 255 255 255 56 147 122 14 0 0 0 102 116 82 78 83 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 53 142 168 183 0 0 0 202 73 68 65 84 120 218 98 72 5 3 183 84 24 0 8 32 6 48 169 96 5 23 0 8 32 176 128 176 88 32 92 0 32 128 64 2 190 114 33 42 112 1 128 0 2 10 112 74 120 50 241 168 7 219 74 122 184 248 88 164 2 4 16 67 170 120 104 18 51 171 127 132 35 99 2 99 188 151 96 10 64 0 49 112 91 187 50 176 8 217 201 176 186 51 50 115 196 74 197 0 4 16 67 152 13 59 11 3 7 131 44 19 27 3 59 27 191 169 22 64 0 49 164 106 251 233 38 138 56 105 24 71 9 24 198 217 235 41 1 4 16 208 80 111 46 179 112 62 181 32 101 125 105 7 121 19 3 128 0 2 89 107 100 174 42 170 3 179 22 32 128 192 14 211 140 230 13 128 9 0 4 16 196 233 201 150 138 48 1 128 0 130 8 164 58 71 194 4 0 2 12 0 195 211 63 171 113 236 31 0 0 0 0 0 73 69 78 68 174 66 96 130 ]!

arrowSmallBlackGif
	"'imgs/ibm-arrow-right-black.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 7 0 7 0 128 1 0 0 0 0 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 7 0 7 0 0 2 11 140 143 1 105 11 15 23 146 135 178 2 0 59 ]!

arrowTriangleRedGif
	"'imgs/filo-redarr.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 14 0 13 0 128 0 0 255 255 255 255 0 0 33 249 4 1 0 0 0 0 44 0 0 0 0 14 0 13 0 0 2 23 132 143 169 123 193 25 226 51 177 190 138 23 222 112 59 197 49 214 244 77 230 121 20 0 59 ]!

arrowTriangleYellowGif
	"'imgs/dars-arrow2.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 5 0 8 0 145 2 0 251 171 61 50 138 66 255 255 255 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 5 0 8 0 0 2 14 76 132 1 39 186 13 162 137 203 29 197 12 18 5 0 59 ]!

bannerLeftGif
	"'imgs/fast/fast-banner_left.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 3 0 3 0 128 0 0 127 160 177 255 255 255 33 249 4 1 0 0 0 0 44 0 0 0 0 3 0 3 0 0 2 4 12 96 24 81 0 59 13 10 ]!

bucketTopGif
	"'imgs/fast/fast-bucket_top.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 80 1 5 0 128 1 0 255 255 255 229 236 243 33 249 4 1 0 0 1 0 44 0 0 0 0 80 1 5 0 0 2 50 132 17 169 203 237 15 163 156 180 218 139 179 222 188 251 15 42 199 17 150 230 137 166 234 202 182 37 233 198 242 76 215 246 141 25 248 206 247 254 15 100 32 130 196 162 241 136 172 20 0 0 59 13 10 ]!

bulletBookTranspWhiteGif
	"'imgs/fast/fast-book.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 153 204 102 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 29 68 142 25 166 141 0 95 148 17 206 99 77 78 123 83 109 113 161 135 141 225 183 156 138 230 180 143 139 21 0 59 13 10 ]!

bulletBubbleTranspWhiteGif
	"'imgs/fast/fast-soundoff.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 152 248 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 157 0 35 67 178 190 26 47 158 107 243 110 53 153 115 64 36 117 166 165 10 20 0 59 ]!

bulletCalendarTranspWhiteGif
	"'imgs/fast/fast-calendar.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 251 176 51 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 29 68 142 25 166 141 0 99 76 178 210 58 159 62 140 239 117 97 29 232 149 102 55 138 144 195 142 14 80 0 0 59 13 10 ]!

bulletCheckTranspWhiteGif
	"'imgs/fast/fast-register.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 22 68 142 25 166 237 15 89 148 135 2 90 217 125 119 79 8 134 34 130 53 64 1 0 59 13 10 ]!

bulletConnectTranspWhiteGif
	"'imgs/fast/fast-connect.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 23 68 142 25 166 237 15 29 91 114 130 121 174 222 234 34 223 88 209 72 70 152 84 0 0 59 13 10 ]!

bulletFindTranspWhiteGif
	"'imgs/fast/fast-find.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 24 68 142 25 166 157 0 89 139 209 209 101 171 124 114 243 234 40 94 56 90 161 121 46 5 0 59 13 10 ]!

bulletFolderTranspWhiteGif
	"'imgs/fast/fast-archives.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 153 204 102 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 24 68 142 25 166 237 127 128 132 178 218 100 51 206 117 115 22 125 224 34 66 38 117 2 5 0 59 13 10 ]!

bulletGraphTranspWhiteGif
	"'imgs/fast/fast-bargraph.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 27 68 142 25 166 221 192 220 129 18 209 186 204 125 58 42 186 77 93 246 141 33 9 122 216 180 2 5 0 59 13 10 ]!

bulletGuidesTranspWhiteGif
	"'imgs/fast/fast-guides.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 25 68 142 25 166 237 236 14 152 17 193 198 178 154 188 111 9 70 215 67 85 139 89 141 88 1 0 59 13 10 ]!

bulletIssueTranspWhiteGif
	"'imgs/fast/fast-issue.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 84 166 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 141 0 99 76 178 82 246 240 170 51 43 120 113 26 120 133 156 105 57 142 182 22 0 59 ]!

bulletLetterTranspWhiteGif
	"'imgs/fast/fast-newsletters.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 29 68 142 25 166 237 127 128 156 12 25 122 147 92 123 219 206 85 225 53 105 88 249 157 34 196 42 107 3 20 0 59 13 10 ]!

bulletManTranspWhiteGif
	"'imgs/fast/fast-cof.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 22 68 142 25 166 221 0 29 130 76 82 137 21 141 184 246 124 120 22 56 102 64 1 0 59 13 10 ]!

bulletNoteTranspWhiteGif
	"'imgs/fast/fast-riskfree.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 0 0 0 168 236 255 255 255 33 249 4 1 0 0 0 0 44 0 0 0 0 13 0 13 0 0 2 23 12 142 9 166 221 1 29 130 76 82 121 46 214 54 226 63 121 93 5 38 164 19 20 0 59 ]!

bulletPencilTranspWhiteGif
	"'imgs/fast/fast-pencil.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 153 102 102 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 173 236 142 129 13 210 135 110 178 113 229 62 1 90 54 117 139 104 98 38 80 0 0 59 13 10 ]!

bulletQuoteTranspWhiteGif
	"'imgs/fast/fast-first_imp.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 1 113 165 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 237 191 128 140 19 201 121 217 201 84 247 111 37 158 72 58 222 8 165 10 186 22 0 59 13 10 ]!

bulletRelatedTranspWhiteGif
	"'imgs/fast/fast-related.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 84 166 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 26 68 142 25 166 157 0 153 139 70 190 232 14 197 106 195 230 89 154 7 146 157 153 129 169 86 0 0 59 ]!

bulletSquareDownTranspWhiteGif
	"'imgs/fast/fast-down_arrow.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 84 166 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 23 68 142 25 166 237 159 128 132 107 66 201 30 214 120 183 158 125 214 69 145 20 80 0 0 59 ]!

bulletSquareLeftWhiteGif
	"'imgs/fast/fast-left_bull.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 11 0 11 0 162 2 0 242 242 236 166 165 165 245 245 236 232 232 222 196 196 181 255 255 255 0 0 0 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 11 0 11 0 0 3 38 40 50 220 163 171 200 89 72 164 148 12 26 242 158 65 39 105 82 104 142 95 41 2 36 56 177 41 5 176 2 33 207 150 66 236 124 158 0 0 59 13 10 ]!

bulletSquareRightTranspWhiteGif
	"'imgs/fast/fast-arrow.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 152 248 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 22 68 142 25 166 237 223 24 92 50 129 139 235 201 89 241 59 129 225 68 142 97 1 0 59 ]!

bulletStarTranspWhiteGif
	"'imgs/fast/fast-fast50.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 23 68 142 25 166 237 175 24 4 212 209 139 35 174 109 191 202 69 34 68 78 37 80 0 0 59 13 10 ]!

bulletToolsTranspWhiteGif
	"'imgs/fast/fast-tools_ico.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 24 68 142 25 166 157 0 87 108 176 58 52 111 190 146 119 255 105 140 55 130 74 233 0 5 0 59 13 10 ]!

bulletTriangleRightTranspWhiteGif
	"'imgs/fast/fast-interactive.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 13 0 128 1 0 255 255 255 0 0 0 33 249 4 1 0 0 1 0 44 0 0 0 0 13 0 13 0 0 2 24 68 142 25 166 173 236 16 128 113 210 102 111 202 250 228 184 76 96 56 46 229 216 109 5 0 59 13 10 ]!

buttonBackWhiteGif
	"'imgs/awful-button-back.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 30 0 22 0 230 0 0 229 229 229 232 232 232 239 239 239 207 207 207 143 143 143 223 223 223 64 64 64 252 252 252 226 226 226 228 228 228 159 159 159 140 140 140 212 212 212 221 221 221 254 254 254 214 214 214 216 216 216 199 199 199 0 0 0 16 16 16 189 189 189 175 175 175 253 253 253 225 225 225 128 128 128 222 222 222 201 201 201 148 148 148 172 172 172 209 209 209 191 191 191 244 244 244 240 240 240 151 151 151 48 48 48 235 235 235 179 179 179 177 177 177 180 180 180 186 186 186 205 205 205 163 163 163 142 142 142 247 247 247 218 218 218 156 156 156 80 80 80 174 174 174 194 194 194 224 224 224 155 155 155 166 166 166 150 150 150 145 145 145 202 202 202 96 96 96 220 220 220 203 203 203 242 242 242 211 211 211 195 195 195 165 165 165 137 137 137 215 215 215 249 249 249 141 141 141 164 164 164 250 250 250 130 130 130 231 231 231 204 204 204 112 112 112 32 32 32 208 208 208 152 152 152 248 248 248 135 135 135 134 134 134 178 178 178 146 146 146 246 246 246 219 219 219 173 173 173 176 176 176 251 251 251 132 132 132 138 138 138 217 217 217 236 236 236 241 241 241 181 181 181 147 147 147 133 133 133 153 153 153 158 158 158 245 245 245 183 183 183 136 136 136 210 210 210 144 144 144 230 230 230 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 30 0 22 0 0 7 255 128 100 130 131 132 133 134 135 136 25 17 21 10 27 99 143 144 99 53 74 51 20 12 8 136 130 23 17 33 27 48 5 101 161 162 162 31 12 10 11 47 16 0 135 13 36 11 8 163 177 178 101 38 79 3 9 133 49 78 33 84 179 190 162 81 4 3 171 130 0 60 11 191 201 161 12 93 44 131 16 42 32 202 161 30 179 22 50 39 196 20 41 202 2 24 19 6 178 7 75 35 99 13 100 9 45 176 190 3 55 18 72 24 160 177 7 31 89 11 54 100 13 4 190 21 6 18 6 10 126 29 0 49 66 8 24 50 15 246 201 114 49 225 136 60 129 2 0 76 225 128 80 97 44 12 18 68 40 16 144 108 8 150 11 37 40 234 19 229 96 148 183 9 19 110 60 140 5 133 12 14 25 90 208 169 11 85 82 150 2 17 255 42 204 19 144 225 7 23 13 130 182 89 24 90 83 150 7 23 225 72 126 72 240 32 71 16 28 130 32 44 16 176 98 5 144 162 178 56 138 250 2 224 65 135 48 217 138 193 176 162 67 0 8 29 211 66 93 96 128 66 10 13 103 131 80 98 148 80 81 132 12 128 0 120 243 234 13 0 160 0 132 36 57 76 248 24 86 168 85 19 13 5 174 60 216 33 166 177 99 49 29 6 160 48 162 97 139 48 92 134 54 209 96 50 195 3 227 199 141 59 216 224 80 133 72 42 98 137 22 121 113 20 233 81 141 16 61 44 97 202 68 187 118 161 64 0 59 ]!

buttonBeginWhiteGif
	"'imgs/awful-button-begin.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 22 0 22 0 230 0 0 239 239 239 143 143 143 207 207 207 159 159 159 223 223 223 128 128 128 221 221 221 254 254 254 212 212 212 228 228 228 214 214 214 191 191 191 226 226 226 32 32 32 140 140 140 216 216 216 225 225 225 252 252 252 253 253 253 199 199 199 189 189 189 64 64 64 222 222 222 201 201 201 16 16 16 232 232 232 172 172 172 96 96 96 209 209 209 151 151 151 240 240 240 175 175 175 244 244 244 156 156 156 141 141 141 242 242 242 247 247 247 235 235 235 174 174 174 163 163 163 155 155 155 194 194 194 220 220 220 180 180 180 142 142 142 166 166 166 224 224 224 202 202 202 150 150 150 218 218 218 205 205 205 177 177 177 179 179 179 186 186 186 203 203 203 145 145 145 219 219 219 138 138 138 144 144 144 173 173 173 135 135 135 134 134 134 0 0 0 248 248 248 246 246 246 195 195 195 217 217 217 80 80 80 165 165 165 236 236 236 133 133 133 215 215 215 181 181 181 250 250 250 176 176 176 146 146 146 158 158 158 152 152 152 153 153 153 249 249 249 245 245 245 251 251 251 164 164 164 231 231 231 183 183 183 132 132 132 130 130 130 208 208 208 204 204 204 147 147 147 241 241 241 137 137 137 178 178 178 136 136 136 148 148 148 229 229 229 255 255 255 230 230 230 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 22 0 22 0 0 7 255 128 97 130 131 132 133 134 135 22 19 31 3 55 77 45 20 8 12 135 131 16 19 29 94 41 4 96 32 8 3 14 38 15 95 135 6 52 14 12 96 168 169 168 43 75 2 9 133 46 92 29 81 170 181 96 56 1 2 162 130 95 65 14 182 192 8 78 49 131 15 44 30 192 182 18 40 53 187 20 39 181 11 182 11 17 63 37 58 6 97 9 33 167 168 11 21 24 170 3 13 67 17 32 90 14 47 97 6 1 168 4 27 13 3 0 222 21 21 31 96 17 30 37 82 84 97 10 237 2 48 12 80 21 160 129 128 84 17 0 124 81 162 193 95 59 48 227 54 104 2 3 160 64 131 2 243 146 20 129 48 163 33 187 84 7 10 96 168 144 10 192 6 31 5 128 132 81 129 2 137 54 110 168 14 80 44 80 139 128 8 0 22 142 24 185 32 232 153 132 159 50 109 29 0 145 64 129 13 17 42 4 61 112 0 128 4 137 39 65 85 65 249 162 128 67 151 102 188 82 228 24 1 192 195 8 91 16 16 200 216 1 131 216 32 23 51 88 76 9 243 37 131 219 47 4 52 30 92 177 177 98 139 174 66 164 122 92 32 32 164 170 0 25 88 46 100 201 245 202 80 37 24 60 90 44 224 240 66 67 21 43 160 118 77 74 244 129 201 141 14 68 32 73 154 196 185 115 32 0 59 ]!

buttonEditGif
	"'/home/mivsek/projekti/viart/edit.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 20 0 20 0 247 0 0 0 0 0 255 255 255 0 0 8 0 12 35 5 25 57 9 23 45 0 9 22 21 35 54 27 45 68 27 42 61 37 56 77 37 52 68 44 61 80 40 61 82 38 56 75 52 73 95 53 74 95 59 79 99 33 44 55 84 110 136 58 79 99 60 82 102 61 82 101 67 89 110 46 60 73 64 83 101 74 95 114 31 44 55 36 47 56 83 107 128 81 103 121 63 80 94 80 101 119 117 143 164 62 75 86 30 39 46 35 45 53 88 112 131 81 103 120 96 121 140 99 124 143 92 115 132 50 62 71 97 120 137 105 129 147 70 85 96 60 78 91 114 143 164 88 111 127 99 124 141 105 131 149 104 128 145 97 119 135 95 117 132 118 145 163 110 134 150 107 128 142 105 131 148 56 70 79 45 56 63 116 144 161 60 74 83 112 138 154 62 76 85 79 97 108 108 132 147 125 152 169 101 122 135 118 142 157 65 80 89 111 136 150 121 147 162 139 168 184 36 43 47 124 146 158 114 139 152 60 73 80 120 146 159 126 152 166 93 112 122 155 184 199 129 153 165 63 76 82 142 169 181 131 156 167 93 111 119 131 155 166 152 178 190 142 167 178 145 170 181 143 171 183 139 166 177 164 194 207 145 172 183 149 176 187 146 172 183 147 172 182 177 203 214 149 176 186 135 158 166 149 172 180 108 124 130 148 174 183 158 184 193 162 188 197 157 183 191 177 205 214 147 174 182 172 201 209 168 196 204 161 188 196 173 201 209 176 204 212 144 166 172 163 190 197 185 215 223 168 195 202 193 223 231 178 206 213 52 60 62 171 199 205 161 187 193 208 240 247 96 111 114 181 208 214 183 212 217 193 222 227 145 166 170 177 203 207 183 209 212 207 235 238 200 229 232 156 179 181 216 244 246 162 185 186 37 39 38 41 46 42 83 88 82 48 50 39 110 111 95 97 97 76 72 71 53 255 219 13 95 87 53 255 204 11 255 201 12 255 203 13 255 195 11 255 197 11 255 199 11 255 195 12 255 197 12 255 199 12 107 78 0 218 159 1 184 134 1 255 191 4 239 175 4 228 167 4 241 178 5 230 169 5 255 189 10 255 192 10 255 193 10 125 93 5 109 81 5 255 190 12 255 191 12 255 192 12 255 193 12 175 131 10 125 94 7 120 90 8 130 99 11 116 92 23 61 51 23 211 152 0 148 105 0 131 94 0 123 87 0 227 165 1 209 152 1 190 138 1 227 166 4 226 165 4 230 168 5 255 188 10 160 118 7 119 90 13 143 100 0 116 79 0 111 78 0 110 76 0 63 44 0 36 24 0 41 39 35 41 23 0 7 3 0 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 198 0 44 0 0 0 0 20 0 20 0 0 8 255 0 141 9 28 72 144 32 160 130 8 19 254 249 226 199 80 194 135 198 198 24 105 242 4 98 66 47 65 106 88 36 56 40 80 158 37 102 86 108 52 70 136 75 4 49 103 168 240 24 233 36 1 177 98 100 220 100 1 242 80 24 169 85 172 126 101 226 181 8 75 154 27 16 27 113 146 52 169 210 167 67 97 206 200 49 17 99 8 66 52 35 0 64 50 149 202 211 48 61 133 96 60 0 65 3 7 193 41 107 230 32 128 101 9 213 45 69 80 250 192 73 1 193 194 12 21 2 219 68 17 244 102 193 46 93 169 64 33 154 16 34 209 43 7 21 52 164 64 98 108 79 14 58 124 172 144 176 117 41 84 43 70 143 84 105 114 165 160 129 7 34 27 140 233 240 129 167 206 157 94 167 80 137 170 133 139 146 163 96 2 118 108 65 49 176 8 11 59 113 70 200 138 148 10 211 168 77 177 102 1 51 240 162 96 143 11 106 202 248 234 148 139 86 41 2 17 50 48 72 146 240 71 137 42 18 10 12 56 128 65 137 16 23 45 32 138 144 113 133 77 23 45 54 62 112 14 24 201 228 4 152 35 20 70 18 148 210 97 99 64 0 59 ]!

buttonEndWhiteGif
	"'imgs/awful-button-end.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 22 0 22 0 230 0 0 143 143 143 254 254 254 207 207 207 239 239 239 253 253 253 223 223 223 159 159 159 226 226 226 128 128 128 221 221 221 191 191 191 228 228 228 216 216 216 212 212 212 214 214 214 32 32 32 140 140 140 64 64 64 189 189 189 199 199 199 251 251 251 96 96 96 16 16 16 201 201 201 175 175 175 151 151 151 209 209 209 232 232 232 172 172 172 247 247 247 225 225 225 177 177 177 145 145 145 156 156 156 166 166 166 179 179 179 224 224 224 203 203 203 163 163 163 235 235 235 222 222 222 186 186 186 180 180 180 250 250 250 155 155 155 150 150 150 142 142 142 248 248 248 249 249 249 242 242 242 240 240 240 220 220 220 141 141 141 202 202 202 174 174 174 194 194 194 205 205 205 218 218 218 231 231 231 134 134 134 217 217 217 130 130 130 173 173 173 195 195 195 148 148 148 153 153 153 204 204 204 181 181 181 183 183 183 219 219 219 138 138 138 215 215 215 236 236 236 152 152 152 246 246 246 252 252 252 132 132 132 147 147 147 133 133 133 241 241 241 144 144 144 244 244 244 176 176 176 136 136 136 80 80 80 178 178 178 146 146 146 164 164 164 0 0 0 245 245 245 165 165 165 137 137 137 158 158 158 135 135 135 208 208 208 229 229 229 255 255 255 230 230 230 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 22 0 22 0 0 7 255 128 97 130 131 132 133 134 135 40 19 24 6 32 73 34 18 13 7 135 131 30 19 25 64 55 5 96 81 13 6 16 54 12 95 135 9 35 16 7 96 168 169 168 42 86 2 11 133 36 85 25 20 170 181 96 69 0 2 162 130 95 63 16 182 192 13 65 57 131 12 46 50 192 182 4 44 41 187 18 38 96 4 10 182 211 168 1 47 39 80 9 97 11 33 167 4 84 15 6 170 22 17 213 29 79 16 53 97 9 0 168 4 96 24 17 230 168 3 6 15 21 5 1 72 87 68 97 14 238 192 44 73 37 224 65 64 84 6 44 8 56 33 133 195 63 119 20 86 128 25 128 224 1 130 1 168 10 84 16 7 70 199 7 135 237 80 41 65 128 165 2 70 84 17 44 32 8 0 6 198 12 22 67 184 121 3 243 130 134 38 85 23 193 4 32 112 224 136 147 11 130 158 17 32 64 129 165 173 0 43 22 56 40 65 99 134 32 6 16 6 116 232 0 195 168 170 44 95 28 104 152 210 140 215 13 35 49 6 200 136 97 203 67 3 28 62 90 16 27 68 226 131 11 29 97 58 190 108 152 251 165 0 3 47 37 84 108 209 85 136 212 142 11 5 120 104 21 128 67 200 133 38 185 94 25 170 212 162 139 8 5 26 106 112 96 210 3 212 174 73 137 48 112 1 145 65 11 36 73 147 66 139 14 4 0 59 ]!

buttonNextWhiteGif
	"'imgs/awful-button-next.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 30 0 22 0 230 0 0 229 229 229 232 232 232 239 239 239 207 207 207 143 143 143 223 223 223 64 64 64 252 252 252 226 226 226 228 228 228 159 159 159 140 140 140 212 212 212 221 221 221 214 214 214 216 216 216 0 0 0 16 16 16 225 225 225 189 189 189 253 253 253 128 128 128 254 254 254 199 199 199 175 175 175 222 222 222 201 201 201 191 191 191 148 148 148 172 172 172 209 209 209 240 240 240 244 244 244 151 151 151 48 48 48 177 177 177 179 179 179 145 145 145 174 174 174 194 194 194 163 163 163 180 180 180 247 247 247 156 156 156 220 220 220 166 166 166 203 203 203 142 142 142 218 218 218 155 155 155 80 80 80 235 235 235 224 224 224 186 186 186 205 205 205 96 96 96 150 150 150 202 202 202 242 242 242 211 211 211 195 195 195 217 217 217 137 137 137 178 178 178 181 181 181 138 138 138 246 246 246 133 133 133 146 146 146 134 134 134 153 153 153 32 32 32 236 236 236 250 250 250 219 219 219 251 251 251 112 112 112 241 241 241 208 208 208 173 173 173 147 147 147 158 158 158 249 249 249 215 215 215 176 176 176 132 132 132 135 135 135 231 231 231 141 141 141 164 164 164 136 136 136 245 245 245 152 152 152 165 165 165 130 130 130 248 248 248 183 183 183 204 204 204 210 210 210 144 144 144 230 230 230 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 30 0 22 0 0 7 255 128 100 130 131 132 133 134 135 136 25 23 24 10 28 99 143 144 99 37 92 45 19 12 8 136 130 18 23 33 28 39 5 101 161 162 162 32 12 10 11 38 15 0 135 13 36 11 8 163 177 178 101 41 68 3 9 133 52 63 33 75 179 190 162 74 4 3 171 130 0 60 11 191 201 161 12 70 48 131 15 47 31 179 27 202 161 20 49 53 196 19 40 190 6 17 21 2 191 7 95 51 99 13 100 9 43 176 179 5 21 71 16 55 3 179 7 32 77 11 57 100 13 4 213 10 6 16 6 24 98 29 248 48 35 11 24 50 14 246 85 43 83 128 73 4 25 163 14 8 0 64 165 3 66 133 202 4 40 16 1 161 194 168 36 72 36 140 176 168 79 148 5 118 55 34 124 11 55 74 8 25 22 49 128 160 83 23 234 228 40 12 254 68 40 152 39 32 195 148 33 26 4 109 163 64 212 102 40 3 50 168 205 178 0 34 129 3 23 88 88 8 122 176 64 128 10 21 82 70 177 244 181 5 128 3 15 90 178 21 59 17 68 135 128 15 58 22 150 145 192 192 198 19 28 206 82 6 209 24 241 226 10 25 0 1 242 234 221 27 0 64 129 7 78 92 164 240 49 172 80 171 34 26 10 244 112 176 67 140 227 199 98 60 12 176 17 70 3 20 97 184 12 109 194 97 165 197 134 198 144 29 123 200 209 161 138 151 84 196 18 45 138 226 40 210 163 18 33 186 88 194 148 169 182 237 66 129 0 0 59 ]!

buttonUpWhiteGif
	"'imgs/awful-button-up.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 22 0 22 0 198 96 0 239 239 239 143 143 143 207 207 207 159 159 159 223 223 223 128 128 128 221 221 221 254 254 254 212 212 212 228 228 228 214 214 214 191 191 191 226 226 226 32 32 32 140 140 140 216 216 216 225 225 225 252 252 252 253 253 253 199 199 199 189 189 189 64 64 64 222 222 222 201 201 201 16 16 16 232 232 232 172 172 172 96 96 96 209 209 209 151 151 151 240 240 240 175 175 175 244 244 244 156 156 156 141 141 141 242 242 242 247 247 247 235 235 235 174 174 174 163 163 163 155 155 155 194 194 194 220 220 220 180 180 180 142 142 142 166 166 166 224 224 224 202 202 202 150 150 150 218 218 218 205 205 205 177 177 177 179 179 179 186 186 186 203 203 203 145 145 145 219 219 219 138 138 138 144 144 144 173 173 173 135 135 135 134 134 134 0 0 0 248 248 248 246 246 246 195 195 195 217 217 217 80 80 80 165 165 165 236 236 236 133 133 133 215 215 215 181 181 181 250 250 250 176 176 176 146 146 146 158 158 158 152 152 152 153 153 153 249 249 249 245 245 245 251 251 251 164 164 164 231 231 231 183 183 183 132 132 132 130 130 130 208 208 208 204 204 204 147 147 147 241 241 241 137 137 137 178 178 178 136 136 136 148 148 148 229 229 229 255 255 255 230 230 230 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 44 0 0 0 0 22 0 22 0 0 7 254 128 97 130 131 130 9 6 10 10 6 9 132 140 132 95 15 20 33 1 147 1 33 20 15 95 141 131 46 41 14 39 12 96 161 96 12 39 44 65 46 154 6 51 57 0 18 162 2 162 30 14 92 6 140 16 52 44 35 36 174 96 3 24 4 162 96 29 52 16 132 19 61 83 0 187 7 7 13 3 27 193 81 14 19 131 22 48 23 97 30 79 7 96 5 208 13 11 193 12 29 22 130 19 60 4 95 35 220 0 191 189 21 193 96 94 212 97 31 45 66 25 162 5 240 96 237 225 162 41 62 8 98 178 64 65 190 120 8 67 17 24 32 232 6 7 14 7 69 1 8 144 16 204 13 65 29 94 8 248 18 175 0 56 132 32 154 8 34 162 65 6 48 137 13 4 240 11 134 160 133 32 10 85 176 60 8 182 161 0 152 10 3 226 13 160 32 8 129 149 11 87 32 64 57 64 192 7 0 48 31 26 196 115 128 64 16 3 19 89 108 32 248 2 66 132 205 80 67 254 129 89 97 130 193 160 7 1 86 200 80 144 0 0 144 36 17 210 70 8 133 99 201 3 71 71 2 182 236 224 160 160 92 17 0 30 64 252 144 128 32 192 70 70 9 4 192 232 98 227 136 10 8 95 74 104 41 129 194 137 128 69 141 190 196 168 33 194 8 138 25 74 164 56 208 81 35 70 38 77 130 190 168 184 128 68 131 6 42 47 12 124 6 205 154 117 32 0 59 ]!

calendar1Gif
	"'imgs/calendar1.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 19 0 20 0 179 0 0 0 0 0 255 255 255 2 100 199 2 97 194 4 120 237 57 153 251 121 188 253 204 229 254 225 240 255 70 162 251 252 2 2 250 250 250 255 255 255 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 12 0 44 0 0 0 0 19 0 20 0 0 4 93 144 201 73 107 77 56 235 141 89 26 96 40 142 32 54 20 104 170 174 3 38 144 112 136 25 72 109 223 248 49 35 4 193 251 189 223 79 151 160 17 22 60 228 49 153 36 210 112 80 155 83 24 84 40 168 132 233 114 169 80 122 167 209 168 22 72 198 106 189 204 237 2 28 206 237 130 240 114 239 156 70 31 217 109 105 194 195 233 103 44 128 128 17 0 59 ]!

calendar2Gif
	"'imgs/calendar2.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 20 0 20 0 230 0 0 0 0 0 255 255 255 73 72 73 58 57 59 62 62 63 58 58 59 84 84 85 78 78 79 72 72 73 98 98 99 91 91 92 16 49 249 92 135 223 137 178 244 116 184 250 145 198 250 57 58 59 115 184 249 115 185 249 116 184 249 116 185 249 121 187 249 128 191 249 136 195 249 137 195 249 145 199 250 154 203 250 154 204 250 164 208 249 174 213 250 174 213 249 183 218 250 192 222 250 201 226 250 201 227 250 208 230 250 215 233 249 208 231 250 215 234 250 222 237 250 221 236 249 226 239 250 208 220 223 66 67 67 105 106 106 98 99 98 32 117 2 47 167 5 207 207 205 197 197 195 182 182 180 182 182 181 178 178 177 197 196 195 63 62 62 85 84 84 114 113 113 146 145 145 164 164 164 145 145 145 129 129 129 127 127 127 121 121 121 106 106 106 91 91 91 67 67 67 58 58 58 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 67 0 44 0 0 0 0 20 0 20 0 0 7 189 128 67 130 131 132 133 134 48 136 137 138 139 137 67 49 41 144 145 146 147 145 53 50 40 46 47 154 155 156 156 46 39 51 58 36 157 164 157 38 58 57 37 42 171 172 173 174 42 35 59 60 34 61 181 182 183 184 61 33 60 62 32 61 52 1 191 193 192 194 197 32 62 56 31 61 1 193 204 203 205 208 61 31 56 44 30 185 182 11 217 11 182 29 63 45 28 197 196 192 11 12 13 11 196 28 9 10 26 207 237 204 11 13 230 206 27 64 55 15 215 181 218 219 181 25 6 7 23 225 134 9 44 134 225 128 0 11 238 162 57 115 102 1 193 138 10 248 240 85 8 98 35 66 4 10 23 39 104 140 224 64 227 4 139 31 37 16 24 82 160 100 1 33 5 6 160 52 201 18 66 1 67 48 99 202 156 57 36 16 0 59 ]!

calendar3Gif
	"'imgs/calendar3.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 20 0 20 0 179 0 0 0 0 0 255 255 255 4 111 231 57 148 251 178 178 177 255 0 0 253 125 125 252 215 215 127 127 127 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 9 0 44 0 0 0 0 20 0 20 0 0 4 97 48 137 73 171 165 50 232 205 251 158 193 32 142 100 57 4 160 169 142 168 224 189 29 136 204 116 109 35 109 128 16 58 191 247 64 156 76 131 211 17 143 70 217 109 86 104 22 104 185 159 148 87 48 28 10 190 40 178 88 56 92 143 202 165 243 57 139 250 206 193 236 208 200 46 186 163 203 184 57 77 23 186 222 237 45 60 126 203 193 254 2 18 23 131 21 9 17 0 59 ]!

calendar4Gif
	"'imgs/calendar4.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 20 0 20 0 230 0 0 0 0 0 255 255 255 116 184 250 145 198 250 9 134 252 9 135 252 14 137 252 20 141 252 27 143 252 27 144 252 34 147 252 34 148 252 39 149 252 39 150 252 40 149 252 40 150 252 42 151 252 50 154 252 50 155 252 59 159 252 67 163 252 68 163 252 76 167 252 76 168 252 84 171 252 86 172 252 86 173 252 87 172 252 87 173 252 92 175 252 99 178 252 99 179 252 106 182 252 112 185 252 117 187 252 115 184 249 115 185 249 116 184 249 116 185 249 121 189 252 121 187 249 128 191 249 136 195 249 137 195 249 145 199 250 154 203 250 154 204 250 164 208 249 174 213 250 174 213 249 183 218 250 192 222 250 201 226 250 201 227 250 208 230 250 215 233 249 208 231 250 215 234 250 222 237 250 221 236 249 226 239 250 208 220 223 252 132 14 251 172 95 251 226 201 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 65 0 44 0 0 0 0 20 0 20 0 0 7 202 128 65 130 131 132 133 134 39 136 137 138 139 137 65 34 60 144 145 146 147 145 34 33 59 25 28 28 25 153 27 25 26 28 27 158 27 154 58 33 32 55 15 14 13 170 15 13 175 15 12 177 178 12 57 32 31 56 61 186 187 188 189 61 54 30 29 53 6 196 197 198 199 6 52 29 24 51 6 49 1 206 208 207 209 212 51 24 23 50 6 1 208 219 218 220 223 6 50 22 20 49 200 197 62 232 62 197 48 21 19 47 212 211 207 62 63 64 62 211 47 19 18 45 222 252 219 62 64 245 186 185 136 0 97 128 57 98 233 212 17 99 1 97 129 10 120 210 34 82 91 161 0 65 138 126 224 186 117 75 145 224 0 138 131 7 81 28 48 48 98 132 9 147 37 82 142 16 144 178 68 73 151 36 12 4 41 64 179 38 77 2 54 115 26 218 201 179 167 207 32 129 0 0 59 ]!

calendar5Gif
	"'imgs/calendar5.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 19 0 20 0 179 0 0 0 0 0 255 255 255 1 130 248 1 104 199 2 76 145 5 128 241 107 183 253 164 209 251 206 207 207 252 1 1 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 10 0 44 0 0 0 0 19 0 20 0 0 4 100 80 169 51 43 189 85 202 114 184 239 160 167 21 195 81 158 102 122 22 219 224 190 112 92 32 10 25 223 239 92 227 188 94 24 192 160 112 232 11 24 143 200 100 17 41 8 52 159 1 66 96 153 172 26 139 9 167 22 218 148 82 173 74 90 33 144 229 110 163 83 49 216 138 61 155 189 234 117 184 70 118 107 145 95 121 122 83 232 251 255 127 52 26 8 132 133 134 134 26 17 0 59 ]!

calendarButtonGif
	^self calendar2Gif!

calendarCSS
	"/jscalendar/calendar.css"
	^'
/*calendar-brown.css*/
/* The main calendar widget.  DIV containing a table. */

div.calendar { position: relative; }

.calendar, .calendar table {
  border: 1px solid #655;
  font-size: 11px;
  color: #000;
  cursor: default;
  background: #ffd;
  font-family: tahoma,verdana,sans-serif;
}

/* Header part -- contains navigation buttons and day names. */

.calendar .button { /* "<<", "<", ">", ">>" buttons have this class */
  text-align: center;    /* They are the navigation buttons */
  padding: 2px;          /* Make the buttons seem like they are pressing */
}

.calendar .nav {
  background: #edc url(menuarrow.gif) no-repeat 100% 100%;
}

.calendar thead .title { /* This holds the current "month, year" */
  font-weight: bold;      /* Pressing it will take you to the current date */
  text-align: center;
  background: #654;
  color: #fed;
  padding: 2px;
}

.calendar thead .headrow { /* Row <TR> containing navigation buttons */
  background: #edc;
  color: #000;
}

.calendar thead .name { /* Cells <TD> containing the day names */
  border-bottom: 1px solid #655;
  padding: 2px;
  text-align: center;
  color: #000;
}

.calendar thead .weekend { /* How a weekend day name shows in header */
  color: #f00;
}

.calendar thead .hilite { /* How do the buttons in header appear when hover */
  background-color: #faa;
  color: #000;
  border: 1px solid #f40;
  padding: 1px;
}

.calendar thead .active { /* Active (pressed) buttons in header */
  background-color: #c77;
  padding: 2px 0px 0px 2px;
}

.calendar thead .daynames { /* Row <TR> containing the day names */
  background: #fed;
}

/* The body part -- contains all the days in month. */

.calendar tbody .day { /* Cells <TD> containing month days dates */
  width: 2em;
  text-align: right;
  padding: 2px 4px 2px 2px;
}
.calendar tbody .day.othermonth {
  font-size: 80%;
  color: #bbb;
}
.calendar tbody .day.othermonth.oweekend {
  color: #fbb;
}

.calendar table .wn {
  padding: 2px 3px 2px 2px;
  border-right: 1px solid #000;
  background: #fed;
}

.calendar tbody .rowhilite td {
  background: #ddf;
}

.calendar tbody .rowhilite td.wn {
  background: #efe;
}

.calendar tbody td.hilite { /* Hovered cells <TD> */
  background: #ffe;
  padding: 1px 3px 1px 1px;
  border: 1px solid #bbb;
}

.calendar tbody td.active { /* Active (pressed) cells <TD> */
  background: #ddc;
  padding: 2px 2px 0px 2px;
}

.calendar tbody td.selected { /* Cell showing today date */
  font-weight: bold;
  border: 1px solid #000;
  padding: 1px 3px 1px 1px;
  background: #fea;
}

.calendar tbody td.weekend { /* Cells showing weekend days */
  color: #f00;
}

.calendar tbody td.today { font-weight: bold; }

.calendar tbody .disabled { color: #999; }

.calendar tbody .emptycell { /* Empty cells (the best is to hide them) */
  visibility: hidden;
}

.calendar tbody .emptyrow { /* Empty row (some months need less than 6 rows) */
  display: none;
}

/* The footer part -- status bar and "Close" button */

.calendar tfoot .footrow { /* The <TR> in footer (only one right now) */
  text-align: center;
  background: #988;
  color: #000;
}

.calendar tfoot .ttip { /* Tooltip (status bar) cell <TD> */
  border-top: 1px solid #655;
  background: #dcb;
  color: #840;
}

.calendar tfoot .hilite { /* Hover style for buttons in footer */
  background: #faa;
  border: 1px solid #f40;
  padding: 1px;
}

.calendar tfoot .active { /* Active (pressed) style for buttons in footer */
  background: #c77;
  padding: 2px 0px 0px 2px;
}

/* Combo boxes (menus that display months/years for direct selection) */

.calendar .combo {
  position: absolute;
  display: none;
  top: 0px;
  left: 0px;
  width: 4em;
  cursor: default;
  border: 1px solid #655;
  background: #ffe;
  color: #000;
  font-size: 90%;
  z-index: 100;
}

.calendar .combo .label,
.calendar .combo .label-IEfix {
  text-align: center;
  padding: 1px;
}

.calendar .combo .label-IEfix {
  width: 4em;
}

.calendar .combo .hilite {
  background: #fc8;
}

.calendar .combo .active {
  border-top: 1px solid #a64;
  border-bottom: 1px solid #a64;
  background: #fee;
  font-weight: bold;
}

.calendar td.time {
  border-top: 1px solid #a88;
  padding: 1px 0px;
  text-align: center;
  background-color: #fed;
}

.calendar td.time .hour,
.calendar td.time .minute,
.calendar td.time .ampm {
  padding: 0px 3px 0px 4px;
  border: 1px solid #988;
  font-weight: bold;
  background-color: #fff;
}

.calendar td.time .ampm {
  text-align: center;
}

.calendar td.time .colon {
  padding: 0px 2px 0px 3px;
  font-weight: bold;
}

.calendar td.time span.hilite {
  border-color: #000;
  background-color: #866;
  color: #fff;
}

.calendar td.time span.active {
  border-color: #f00;
  background-color: #000;
  color: #0f0;
}
'!

calendarCSSResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarCSSResource"
	^self resources at: #jsCalendarCSS ifAbsentPut:
		[WebMethodResource 
			fromMethod: #calendarCSS on: self 
			contentType: 'text/css' preferedUrl: '/jscalendar/calendar.css' site: self site].!

calendarJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarJavascript"
	^'
/*  Copyright Mihai Bazon, 2002-2005  |  www.bazon.net/mishoo
 * -----------------------------------------------------------
 *
 * The DHTML Calendar, version 1.0 "It is happening again"
 *
 * Details and latest version at:
 * www.dynarch.com/projects/calendar
 *
 * This script is developed by Dynarch.com.  Visit us at www.dynarch.com.
 *
 * This script is distributed under the GNU Lesser General Public License.
 * Read the entire license text here: http://www.gnu.org/licenses/lgpl.html
 */

// $Id: calendar.js,v 1.51 2005/03/07 16:44:31 mishoo Exp $

/** The Calendar object constructor. */
Calendar = function (firstDayOfWeek, dateStr, onSelected, onClose) {
	// member variables
	this.activeDiv = null;
	this.currentDateEl = null;
	this.getDateStatus = null;
	this.getDateToolTip = null;
	this.getDateText = null;
	this.timeout = null;
	this.onSelected = onSelected || null;
	this.onClose = onClose || null;
	this.dragging = false;
	this.hidden = false;
	this.minYear = 1970;
	this.maxYear = 2050;
	this.dateFormat = Calendar._TT["DEF_DATE_FORMAT"];
	this.ttDateFormat = Calendar._TT["TT_DATE_FORMAT"];
	this.isPopup = true;
	this.weekNumbers = true;
	this.firstDayOfWeek = typeof firstDayOfWeek == "number" ? firstDayOfWeek : Calendar._FD; // 0 for Sunday, 1 for Monday, etc.
	this.showsOtherMonths = false;
	this.dateStr = dateStr;
	this.ar_days = null;
	this.showsTime = false;
	this.time24 = true;
	this.yearStep = 2;
	this.hiliteToday = true;
	this.multiple = null;
	// HTML elements
	this.table = null;
	this.element = null;
	this.tbody = null;
	this.firstdayname = null;
	// Combo boxes
	this.monthsCombo = null;
	this.yearsCombo = null;
	this.hilitedMonth = null;
	this.activeMonth = null;
	this.hilitedYear = null;
	this.activeYear = null;
	// Information
	this.dateClicked = false;

	// one-time initializations
	if (typeof Calendar._SDN == "undefined") {
		// table of short day names
		if (typeof Calendar._SDN_len == "undefined")
			Calendar._SDN_len = 3;
		var ar = new Array();
		for (var i = 8; i > 0;) {
			ar[--i] = Calendar._DN[i].substr(0, Calendar._SDN_len);
		}
		Calendar._SDN = ar;
		// table of short month names
		if (typeof Calendar._SMN_len == "undefined")
			Calendar._SMN_len = 3;
		ar = new Array();
		for (var i = 12; i > 0;) {
			ar[--i] = Calendar._MN[i].substr(0, Calendar._SMN_len);
		}
		Calendar._SMN = ar;
	}
};

// ** constants

/// "static", needed for event handlers.
Calendar._C = null;

/// detect a special case of "web browser"
Calendar.is_ie = ( /msie/i.test(navigator.userAgent) &&
		   !!/opera/i.test(navigator.userAgent) );

Calendar.is_ie5 = ( Calendar.is_ie && /msie 5\.0/i.test(navigator.userAgent) );

/// detect Opera browser
Calendar.is_opera = /opera/i.test(navigator.userAgent);

/// detect KHTML-based browsers
Calendar.is_khtml = /Konqueror|Safari|KHTML/i.test(navigator.userAgent);

// BEGIN: UTILITY FUNCTIONS; beware that these might be moved into a separate
//        library, at some point.

Calendar.getAbsolutePos = function(el) {
	var SL = 0, ST = 0;
	var is_div = /^div$/i.test(el.tagName);
	if (is_div && el.scrollLeft)
		SL = el.scrollLeft;
	if (is_div && el.scrollTop)
		ST = el.scrollTop;
	var r = { x: el.offsetLeft - SL, y: el.offsetTop - ST };
	if (el.offsetParent) {
		var tmp = this.getAbsolutePos(el.offsetParent);
		r.x += tmp.x;
		r.y += tmp.y;
	}
	return r;
};

Calendar.isRelated = function (el, evt) {
	var related = evt.relatedTarget;
	if (!!related) {
		var type = evt.type;
		if (type == "mouseover") {
			related = evt.fromElement;
		} else if (type == "mouseout") {
			related = evt.toElement;
		}
	}
	while (related) {
		if (related == el) {
			return true;
		}
		related = related.parentNode;
	}
	return false;
};

Calendar.removeClass = function(el, className) {
	if (!!(el && el.className)) {
		return;
	}
	var cls = el.className.split(" ");
	var ar = new Array();
	for (var i = cls.length; i > 0;) {
		if (cls[--i] !!= className) {
			ar[ar.length] = cls[i];
		}
	}
	el.className = ar.join(" ");
};

Calendar.addClass = function(el, className) {
	Calendar.removeClass(el, className);
	el.className += " " + className;
};

// FIXME: the following 2 functions totally suck, are useless and should be replaced immediately.
Calendar.getElement = function(ev) {
	var f = Calendar.is_ie ? window.event.srcElement : ev.currentTarget;
	while (f.nodeType !!= 1 || /^div$/i.test(f.tagName))
		f = f.parentNode;
	return f;
};

Calendar.getTargetElement = function(ev) {
	var f = Calendar.is_ie ? window.event.srcElement : ev.target;
	while (f.nodeType !!= 1)
		f = f.parentNode;
	return f;
};

Calendar.stopEvent = function(ev) {
	ev || (ev = window.event);
	if (Calendar.is_ie) {
		ev.cancelBubble = true;
		ev.returnValue = false;
	} else {
		ev.preventDefault();
		ev.stopPropagation();
	}
	return false;
};

Calendar.addEvent = function(el, evname, func) {
	if (el.attachEvent) { // IE
		el.attachEvent("on" + evname, func);
	} else if (el.addEventListener) { // Gecko / W3C
		el.addEventListener(evname, func, true);
	} else {
		el["on" + evname] = func;
	}
};

Calendar.removeEvent = function(el, evname, func) {
	if (el.detachEvent) { // IE
		el.detachEvent("on" + evname, func);
	} else if (el.removeEventListener) { // Gecko / W3C
		el.removeEventListener(evname, func, true);
	} else {
		el["on" + evname] = null;
	}
};

Calendar.createElement = function(type, parent) {
	var el = null;
	if (document.createElementNS) {
		// use the XHTML namespace; IE won''t normally get here unless
		// _they_ "fix" the DOM2 implementation.
		el = document.createElementNS("http://www.w3.org/1999/xhtml", type);
	} else {
		el = document.createElement(type);
	}
	if (typeof parent !!= "undefined") {
		parent.appendChild(el);
	}
	return el;
};

// END: UTILITY FUNCTIONS

// BEGIN: CALENDAR STATIC FUNCTIONS

/** Internal -- adds a set of events to make some element behave like a button. */
Calendar._add_evs = function(el) {
	with (Calendar) {
		addEvent(el, "mouseover", dayMouseOver);
		addEvent(el, "mousedown", dayMouseDown);
		addEvent(el, "mouseout", dayMouseOut);
		if (is_ie) {
			addEvent(el, "dblclick", dayMouseDblClick);
			el.setAttribute("unselectable", true);
		}
	}
};

Calendar.findMonth = function(el) {
	if (typeof el.month !!= "undefined") {
		return el;
	} else if (typeof el.parentNode.month !!= "undefined") {
		return el.parentNode;
	}
	return null;
};

Calendar.findYear = function(el) {
	if (typeof el.year !!= "undefined") {
		return el;
	} else if (typeof el.parentNode.year !!= "undefined") {
		return el.parentNode;
	}
	return null;
};

Calendar.showMonthsCombo = function () {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	var cal = cal;
	var cd = cal.activeDiv;
	var mc = cal.monthsCombo;
	if (cal.hilitedMonth) {
		Calendar.removeClass(cal.hilitedMonth, "hilite");
	}
	if (cal.activeMonth) {
		Calendar.removeClass(cal.activeMonth, "active");
	}
	var mon = cal.monthsCombo.getElementsByTagName("div")[cal.date.getMonth()];
	Calendar.addClass(mon, "active");
	cal.activeMonth = mon;
	var s = mc.style;
	s.display = "block";
	if (cd.navtype < 0)
		s.left = cd.offsetLeft + "px";
	else {
		var mcw = mc.offsetWidth;
		if (typeof mcw == "undefined")
			// Konqueror brain-dead techniques
			mcw = 50;
		s.left = (cd.offsetLeft + cd.offsetWidth - mcw) + "px";
	}
	s.top = (cd.offsetTop + cd.offsetHeight) + "px";
};

Calendar.showYearsCombo = function (fwd) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	var cal = cal;
	var cd = cal.activeDiv;
	var yc = cal.yearsCombo;
	if (cal.hilitedYear) {
		Calendar.removeClass(cal.hilitedYear, "hilite");
	}
	if (cal.activeYear) {
		Calendar.removeClass(cal.activeYear, "active");
	}
	cal.activeYear = null;
	var Y = cal.date.getFullYear() + (fwd ? 1 : -1);
	var yr = yc.firstChild;
	var show = false;
	for (var i = 12; i > 0; --i) {
		if (Y >= cal.minYear && Y <= cal.maxYear) {
			yr.innerHTML = Y;
			yr.year = Y;
			yr.style.display = "block";
			show = true;
		} else {
			yr.style.display = "none";
		}
		yr = yr.nextSibling;
		Y += fwd ? cal.yearStep : -cal.yearStep;
	}
	if (show) {
		var s = yc.style;
		s.display = "block";
		if (cd.navtype < 0)
			s.left = cd.offsetLeft + "px";
		else {
			var ycw = yc.offsetWidth;
			if (typeof ycw == "undefined")
				// Konqueror brain-dead techniques
				ycw = 50;
			s.left = (cd.offsetLeft + cd.offsetWidth - ycw) + "px";
		}
		s.top = (cd.offsetTop + cd.offsetHeight) + "px";
	}
};

// event handlers

Calendar.tableMouseUp = function(ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	if (cal.timeout) {
		clearTimeout(cal.timeout);
	}
	var el = cal.activeDiv;
	if (!!el) {
		return false;
	}
	var target = Calendar.getTargetElement(ev);
	ev || (ev = window.event);
	Calendar.removeClass(el, "active");
	if (target == el || target.parentNode == el) {
		Calendar.cellClick(el, ev);
	}
	var mon = Calendar.findMonth(target);
	var date = null;
	if (mon) {
		date = new Date(cal.date);
		if (mon.month !!= date.getMonth()) {
			date.setMonth(mon.month);
			cal.setDate(date);
			cal.dateClicked = false;
			cal.callHandler();
		}
	} else {
		var year = Calendar.findYear(target);
		if (year) {
			date = new Date(cal.date);
			if (year.year !!= date.getFullYear()) {
				date.setFullYear(year.year);
				cal.setDate(date);
				cal.dateClicked = false;
				cal.callHandler();
			}
		}
	}
	with (Calendar) {
		removeEvent(document, "mouseup", tableMouseUp);
		removeEvent(document, "mouseover", tableMouseOver);
		removeEvent(document, "mousemove", tableMouseOver);
		cal._hideCombos();
		_C = null;
		return stopEvent(ev);
	}
};

Calendar.tableMouseOver = function (ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return;
	}
	var el = cal.activeDiv;
	var target = Calendar.getTargetElement(ev);
	if (target == el || target.parentNode == el) {
		Calendar.addClass(el, "hilite active");
		Calendar.addClass(el.parentNode, "rowhilite");
	} else {
		if (typeof el.navtype == "undefined" || (el.navtype !!= 50 && (el.navtype == 0 || Math.abs(el.navtype) > 2)))
			Calendar.removeClass(el, "active");
		Calendar.removeClass(el, "hilite");
		Calendar.removeClass(el.parentNode, "rowhilite");
	}
	ev || (ev = window.event);
	if (el.navtype == 50 && target !!= el) {
		var pos = Calendar.getAbsolutePos(el);
		var w = el.offsetWidth;
		var x = ev.clientX;
		var dx;
		var decrease = true;
		if (x > pos.x + w) {
			dx = x - pos.x - w;
			decrease = false;
		} else
			dx = pos.x - x;

		if (dx < 0) dx = 0;
		var range = el._range;
		var current = el._current;
		var count = Math.floor(dx / 10) % range.length;
		for (var i = range.length; --i >= 0;)
			if (range[i] == current)
				break;
		while (count-- > 0)
			if (decrease) {
				if (--i < 0)
					i = range.length - 1;
			} else if ( ++i >= range.length )
				i = 0;
		var newval = range[i];
		el.innerHTML = newval;

		cal.onUpdateTime();
	}
	var mon = Calendar.findMonth(target);
	if (mon) {
		if (mon.month !!= cal.date.getMonth()) {
			if (cal.hilitedMonth) {
				Calendar.removeClass(cal.hilitedMonth, "hilite");
			}
			Calendar.addClass(mon, "hilite");
			cal.hilitedMonth = mon;
		} else if (cal.hilitedMonth) {
			Calendar.removeClass(cal.hilitedMonth, "hilite");
		}
	} else {
		if (cal.hilitedMonth) {
			Calendar.removeClass(cal.hilitedMonth, "hilite");
		}
		var year = Calendar.findYear(target);
		if (year) {
			if (year.year !!= cal.date.getFullYear()) {
				if (cal.hilitedYear) {
					Calendar.removeClass(cal.hilitedYear, "hilite");
				}
				Calendar.addClass(year, "hilite");
				cal.hilitedYear = year;
			} else if (cal.hilitedYear) {
				Calendar.removeClass(cal.hilitedYear, "hilite");
			}
		} else if (cal.hilitedYear) {
			Calendar.removeClass(cal.hilitedYear, "hilite");
		}
	}
	return Calendar.stopEvent(ev);
};

Calendar.tableMouseDown = function (ev) {
	if (Calendar.getTargetElement(ev) == Calendar.getElement(ev)) {
		return Calendar.stopEvent(ev);
	}
};

Calendar.calDragIt = function (ev) {
	var cal = Calendar._C;
	if (!!(cal && cal.dragging)) {
		return false;
	}
	var posX;
	var posY;
	if (Calendar.is_ie) {
		posY = window.event.clientY + document.body.scrollTop;
		posX = window.event.clientX + document.body.scrollLeft;
	} else {
		posX = ev.pageX;
		posY = ev.pageY;
	}
	cal.hideShowCovered();
	var st = cal.element.style;
	st.left = (posX - cal.xOffs) + "px";
	st.top = (posY - cal.yOffs) + "px";
	return Calendar.stopEvent(ev);
};

Calendar.calDragEnd = function (ev) {
	var cal = Calendar._C;
	if (!!cal) {
		return false;
	}
	cal.dragging = false;
	with (Calendar) {
		removeEvent(document, "mousemove", calDragIt);
		removeEvent(document, "mouseup", calDragEnd);
		tableMouseUp(ev);
	}
	cal.hideShowCovered();
};

Calendar.dayMouseDown = function(ev) {
	var el = Calendar.getElement(ev);
	if (el.disabled) {
		return false;
	}
	var cal = el.calendar;
	cal.activeDiv = el;
	Calendar._C = cal;
	if (el.navtype !!= 300) with (Calendar) {
		if (el.navtype == 50) {
			el._current = el.innerHTML;
			addEvent(document, "mousemove", tableMouseOver);
		} else
			addEvent(document, Calendar.is_ie5 ? "mousemove" : "mouseover", tableMouseOver);
		addClass(el, "hilite active");
		addEvent(document, "mouseup", tableMouseUp);
	} else if (cal.isPopup) {
		cal._dragStart(ev);
	}
	if (el.navtype == -1 || el.navtype == 1) {
		if (cal.timeout) clearTimeout(cal.timeout);
		cal.timeout = setTimeout("Calendar.showMonthsCombo()", 250);
	} else if (el.navtype == -2 || el.navtype == 2) {
		if (cal.timeout) clearTimeout(cal.timeout);
		cal.timeout = setTimeout((el.navtype > 0) ? "Calendar.showYearsCombo(true)" : "Calendar.showYearsCombo(false)", 250);
	} else {
		cal.timeout = null;
	}
	return Calendar.stopEvent(ev);
};

Calendar.dayMouseDblClick = function(ev) {
	Calendar.cellClick(Calendar.getElement(ev), ev || window.event);
	if (Calendar.is_ie) {
		document.selection.empty();
	}
};

Calendar.dayMouseOver = function(ev) {
	var el = Calendar.getElement(ev);
	if (Calendar.isRelated(el, ev) || Calendar._C || el.disabled) {
		return false;
	}
	if (el.ttip) {
		if (el.ttip.substr(0, 1) == "_") {
			el.ttip = el.caldate.print(el.calendar.ttDateFormat) + el.ttip.substr(1);
		}
		el.calendar.tooltips.innerHTML = el.ttip;
	}
	if (el.navtype !!= 300) {
		Calendar.addClass(el, "hilite");
		if (el.caldate) {
			Calendar.addClass(el.parentNode, "rowhilite");
		}
	}
	return Calendar.stopEvent(ev);
};

Calendar.dayMouseOut = function(ev) {
	with (Calendar) {
		var el = getElement(ev);
		if (isRelated(el, ev) || _C || el.disabled)
			return false;
		removeClass(el, "hilite");
		if (el.caldate)
			removeClass(el.parentNode, "rowhilite");
		if (el.calendar)
			el.calendar.tooltips.innerHTML = _TT["SEL_DATE"];
		return stopEvent(ev);
	}
};

/**
 *  A generic "click" handler :) handles all types of buttons defined in this
 *  calendar.
 */
Calendar.cellClick = function(el, ev) {
	var cal = el.calendar;
	var closing = false;
	var newdate = false;
	var date = null;
	if (typeof el.navtype == "undefined") {
		if (cal.currentDateEl) {
			Calendar.removeClass(cal.currentDateEl, "selected");
			Calendar.addClass(el, "selected");
			closing = (cal.currentDateEl == el);
			if (!!closing) {
				cal.currentDateEl = el;
			}
		}
		cal.date.setDateOnly(el.caldate);
		date = cal.date;
		var other_month = !!(cal.dateClicked = !!el.otherMonth);
		if (!!other_month && !!cal.currentDateEl)
			cal._toggleMultipleDate(new Date(date));
		else
			newdate = !!el.disabled;
		// a date was clicked
		if (other_month)
			cal._init(cal.firstDayOfWeek, date);
	} else {
		if (el.navtype == 200) {
			Calendar.removeClass(el, "hilite");
			cal.callCloseHandler();
			return;
		}
		date = new Date(cal.date);
		if (el.navtype == 0)
			date.setDateOnly(new Date()); // TODAY
		// unless "today" was clicked, we assume no date was clicked so
		// the selected handler will know not to close the calenar when
		// in single-click mode.
		// cal.dateClicked = (el.navtype == 0);
		cal.dateClicked = false;
		var year = date.getFullYear();
		var mon = date.getMonth();
		function setMonth(m) {
			var day = date.getDate();
			var max = date.getMonthDays(m);
			if (day > max) {
				date.setDate(max);
			}
			date.setMonth(m);
		};
		switch (el.navtype) {
		    case 400:
			Calendar.removeClass(el, "hilite");
			var text = Calendar._TT["ABOUT"];
			if (typeof text !!= "undefined") {
				text += cal.showsTime ? Calendar._TT["ABOUT_TIME"] : "";
			} else {
				// FIXME: this should be removed as soon as lang files get updated!!
				text = "Help and about box text is not translated into this language.\n" +
					"If you know this language and you feel generous please update\n" +
					"the corresponding file in \"lang\" subdir to match calendar-en.js\n" +
					"and send it back to <mihai_bazon@yahoo.com> to get it into the distribution  ;-)\n\n" +
					"Thank you!!\n" +
					"http://dynarch.com/mishoo/calendar.epl\n";
			}
			alert(text);
			return;
		    case -2:
			if (year > cal.minYear) {
				date.setFullYear(year - 1);
			}
			break;
		    case -1:
			if (mon > 0) {
				setMonth(mon - 1);
			} else if (year-- > cal.minYear) {
				date.setFullYear(year);
				setMonth(11);
			}
			break;
		    case 1:
			if (mon < 11) {
				setMonth(mon + 1);
			} else if (year < cal.maxYear) {
				date.setFullYear(year + 1);
				setMonth(0);
			}
			break;
		    case 2:
			if (year < cal.maxYear) {
				date.setFullYear(year + 1);
			}
			break;
		    case 100:
			cal.setFirstDayOfWeek(el.fdow);
			return;
		    case 50:
			var range = el._range;
			var current = el.innerHTML;
			for (var i = range.length; --i >= 0;)
				if (range[i] == current)
					break;
			if (ev && ev.shiftKey) {
				if (--i < 0)
					i = range.length - 1;
			} else if ( ++i >= range.length )
				i = 0;
			var newval = range[i];
			el.innerHTML = newval;
			cal.onUpdateTime();
			return;
		    case 0:
			// TODAY will bring us here
			if ((typeof cal.getDateStatus == "function") &&
			    cal.getDateStatus(date, date.getFullYear(), date.getMonth(), date.getDate())) {
				return false;
			}
			break;
		}
		if (!!date.equalsTo(cal.date)) {
			cal.setDate(date);
			newdate = true;
		} else if (el.navtype == 0)
			newdate = closing = true;
	}
	if (newdate) {
		ev && cal.callHandler();
	}
	if (closing) {
		Calendar.removeClass(el, "hilite");
		ev && cal.callCloseHandler();
	}
};

// END: CALENDAR STATIC FUNCTIONS

// BEGIN: CALENDAR OBJECT FUNCTIONS

/**
 *  This function creates the calendar inside the given parent.  If _par is
 *  null than it creates a popup calendar inside the BODY element.  If _par is
 *  an element, be it BODY, then it creates a non-popup calendar (still
 *  hidden).  Some properties need to be set before calling this function.
 */
Calendar.prototype.create = function (_par) {
	var parent = null;
	if (!! _par) {
		// default parent is the document body, in which case we create
		// a popup calendar.
		parent = document.getElementsByTagName("body")[0];
		this.isPopup = true;
	} else {
		parent = _par;
		this.isPopup = false;
	}
	this.date = this.dateStr ? new Date(this.dateStr) : new Date();

	var table = Calendar.createElement("table");
	this.table = table;
	table.cellSpacing = 0;
	table.cellPadding = 0;
	table.calendar = this;
	Calendar.addEvent(table, "mousedown", Calendar.tableMouseDown);

	var div = Calendar.createElement("div");
	this.element = div;
	div.className = "calendar";
	if (this.isPopup) {
		div.style.position = "absolute";
		div.style.display = "none";
	}
	div.appendChild(table);

	var thead = Calendar.createElement("thead", table);
	var cell = null;
	var row = null;

	var cal = this;
	var hh = function (text, cs, navtype) {
		cell = Calendar.createElement("td", row);
		cell.colSpan = cs;
		cell.className = "button";
		if (navtype !!= 0 && Math.abs(navtype) <= 2)
			cell.className += " nav";
		Calendar._add_evs(cell);
		cell.calendar = cal;
		cell.navtype = navtype;
		cell.innerHTML = "<div unselectable=''on''>" + text + "</div>";
		return cell;
	};

	row = Calendar.createElement("tr", thead);
	var title_length = 6;
	(this.isPopup) && --title_length;
	(this.weekNumbers) && ++title_length;

	hh("?", 1, 400).ttip = Calendar._TT["INFO"];
	this.title = hh("", title_length, 300);
	this.title.className = "title";
	if (this.isPopup) {
		this.title.ttip = Calendar._TT["DRAG_TO_MOVE"];
		this.title.style.cursor = "move";
		hh("&#x00d7;", 1, 200).ttip = Calendar._TT["CLOSE"];
	}

	row = Calendar.createElement("tr", thead);
	row.className = "headrow";

	this._nav_py = hh("&#x00ab;", 1, -2);
	this._nav_py.ttip = Calendar._TT["PREV_YEAR"];

	this._nav_pm = hh("&#x2039;", 1, -1);
	this._nav_pm.ttip = Calendar._TT["PREV_MONTH"];

	this._nav_now = hh(Calendar._TT["TODAY"], this.weekNumbers ? 4 : 3, 0);
	this._nav_now.ttip = Calendar._TT["GO_TODAY"];

	this._nav_nm = hh("&#x203a;", 1, 1);
	this._nav_nm.ttip = Calendar._TT["NEXT_MONTH"];

	this._nav_ny = hh("&#x00bb;", 1, 2);
	this._nav_ny.ttip = Calendar._TT["NEXT_YEAR"];

	// day names
	row = Calendar.createElement("tr", thead);
	row.className = "daynames";
	if (this.weekNumbers) {
		cell = Calendar.createElement("td", row);
		cell.className = "name wn";
		cell.innerHTML = Calendar._TT["WK"];
	}
	for (var i = 7; i > 0; --i) {
		cell = Calendar.createElement("td", row);
		if (!!i) {
			cell.navtype = 100;
			cell.calendar = this;
			Calendar._add_evs(cell);
		}
	}
	this.firstdayname = (this.weekNumbers) ? row.firstChild.nextSibling : row.firstChild;
	this._displayWeekdays();

	var tbody = Calendar.createElement("tbody", table);
	this.tbody = tbody;

	for (i = 6; i > 0; --i) {
		row = Calendar.createElement("tr", tbody);
		if (this.weekNumbers) {
			cell = Calendar.createElement("td", row);
		}
		for (var j = 7; j > 0; --j) {
			cell = Calendar.createElement("td", row);
			cell.calendar = this;
			Calendar._add_evs(cell);
		}
	}

	if (this.showsTime) {
		row = Calendar.createElement("tr", tbody);
		row.className = "time";

		cell = Calendar.createElement("td", row);
		cell.className = "time";
		cell.colSpan = 2;
		cell.innerHTML = Calendar._TT["TIME"] || "&nbsp;";

		cell = Calendar.createElement("td", row);
		cell.className = "time";
		cell.colSpan = this.weekNumbers ? 4 : 3;

		(function(){
			function makeTimePart(className, init, range_start, range_end) {
				var part = Calendar.createElement("span", cell);
				part.className = className;
				part.innerHTML = init;
				part.calendar = cal;
				part.ttip = Calendar._TT["TIME_PART"];
				part.navtype = 50;
				part._range = [];
				if (typeof range_start !!= "number")
					part._range = range_start;
				else {
					for (var i = range_start; i <= range_end; ++i) {
						var txt;
						if (i < 10 && range_end >= 10) txt = ''0'' + i;
						else txt = '''' + i;
						part._range[part._range.length] = txt;
					}
				}
				Calendar._add_evs(part);
				return part;
			};
			var hrs = cal.date.getHours();
			var mins = cal.date.getMinutes();
			var t12 = !!cal.time24;
			var pm = (hrs > 12);
			if (t12 && pm) hrs -= 12;
			var H = makeTimePart("hour", hrs, t12 ? 1 : 0, t12 ? 12 : 23);
			var span = Calendar.createElement("span", cell);
			span.innerHTML = ":";
			span.className = "colon";
			var M = makeTimePart("minute", mins, 0, 59);
			var AP = null;
			cell = Calendar.createElement("td", row);
			cell.className = "time";
			cell.colSpan = 2;
			if (t12)
				AP = makeTimePart("ampm", pm ? "pm" : "am", ["am", "pm"]);
			else
				cell.innerHTML = "&nbsp;";

			cal.onSetTime = function() {
				var pm, hrs = this.date.getHours(),
					mins = this.date.getMinutes();
				if (t12) {
					pm = (hrs >= 12);
					if (pm) hrs -= 12;
					if (hrs == 0) hrs = 12;
					AP.innerHTML = pm ? "pm" : "am";
				}
				H.innerHTML = (hrs < 10) ? ("0" + hrs) : hrs;
				M.innerHTML = (mins < 10) ? ("0" + mins) : mins;
			};

			cal.onUpdateTime = function() {
				var date = this.date;
				var h = parseInt(H.innerHTML, 10);
				if (t12) {
					if (/pm/i.test(AP.innerHTML) && h < 12)
						h += 12;
					else if (/am/i.test(AP.innerHTML) && h == 12)
						h = 0;
				}
				var d = date.getDate();
				var m = date.getMonth();
				var y = date.getFullYear();
				date.setHours(h);
				date.setMinutes(parseInt(M.innerHTML, 10));
				date.setFullYear(y);
				date.setMonth(m);
				date.setDate(d);
				this.dateClicked = false;
				this.callHandler();
			};
		})();
	} else {
		this.onSetTime = this.onUpdateTime = function() {};
	}

	var tfoot = Calendar.createElement("tfoot", table);

	row = Calendar.createElement("tr", tfoot);
	row.className = "footrow";

	cell = hh(Calendar._TT["SEL_DATE"], this.weekNumbers ? 8 : 7, 300);
	cell.className = "ttip";
	if (this.isPopup) {
		cell.ttip = Calendar._TT["DRAG_TO_MOVE"];
		cell.style.cursor = "move";
	}
	this.tooltips = cell;

	div = Calendar.createElement("div", this.element);
	this.monthsCombo = div;
	div.className = "combo";
	for (i = 0; i < Calendar._MN.length; ++i) {
		var mn = Calendar.createElement("div");
		mn.className = Calendar.is_ie ? "label-IEfix" : "label";
		mn.month = i;
		mn.innerHTML = Calendar._SMN[i];
		div.appendChild(mn);
	}

	div = Calendar.createElement("div", this.element);
	this.yearsCombo = div;
	div.className = "combo";
	for (i = 12; i > 0; --i) {
		var yr = Calendar.createElement("div");
		yr.className = Calendar.is_ie ? "label-IEfix" : "label";
		div.appendChild(yr);
	}

	this._init(this.firstDayOfWeek, this.date);
	parent.appendChild(this.element);
};

/** keyboard navigation, only for popup calendars */
Calendar._keyEvent = function(ev) {
	var cal = window._dynarch_popupCalendar;
	if (!!cal || cal.multiple)
		return false;
	(Calendar.is_ie) && (ev = window.event);
	var act = (Calendar.is_ie || ev.type == "keypress"),
		K = ev.keyCode;
	if (ev.ctrlKey) {
		switch (K) {
		    case 37: // KEY left
			act && Calendar.cellClick(cal._nav_pm);
			break;
		    case 38: // KEY up
			act && Calendar.cellClick(cal._nav_py);
			break;
		    case 39: // KEY right
			act && Calendar.cellClick(cal._nav_nm);
			break;
		    case 40: // KEY down
			act && Calendar.cellClick(cal._nav_ny);
			break;
		    default:
			return false;
		}
	} else switch (K) {
	    case 32: // KEY space (now)
		Calendar.cellClick(cal._nav_now);
		break;
	    case 27: // KEY esc
		act && cal.callCloseHandler();
		break;
	    case 37: // KEY left
	    case 38: // KEY up
	    case 39: // KEY right
	    case 40: // KEY down
		if (act) {
			var prev, x, y, ne, el, step;
			prev = K == 37 || K == 38;
			step = (K == 37 || K == 39) ? 1 : 7;
			function setVars() {
				el = cal.currentDateEl;
				var p = el.pos;
				x = p & 15;
				y = p >> 4;
				ne = cal.ar_days[y][x];
			};setVars();
			function prevMonth() {
				var date = new Date(cal.date);
				date.setDate(date.getDate() - step);
				cal.setDate(date);
			};
			function nextMonth() {
				var date = new Date(cal.date);
				date.setDate(date.getDate() + step);
				cal.setDate(date);
			};
			while (1) {
				switch (K) {
				    case 37: // KEY left
					if (--x >= 0)
						ne = cal.ar_days[y][x];
					else {
						x = 6;
						K = 38;
						continue;
					}
					break;
				    case 38: // KEY up
					if (--y >= 0)
						ne = cal.ar_days[y][x];
					else {
						prevMonth();
						setVars();
					}
					break;
				    case 39: // KEY right
					if (++x < 7)
						ne = cal.ar_days[y][x];
					else {
						x = 0;
						K = 40;
						continue;
					}
					break;
				    case 40: // KEY down
					if (++y < cal.ar_days.length)
						ne = cal.ar_days[y][x];
					else {
						nextMonth();
						setVars();
					}
					break;
				}
				break;
			}
			if (ne) {
				if (!!ne.disabled)
					Calendar.cellClick(ne);
				else if (prev)
					prevMonth();
				else
					nextMonth();
			}
		}
		break;
	    case 13: // KEY enter
		if (act)
			Calendar.cellClick(cal.currentDateEl, ev);
		break;
	    default:
		return false;
	}
	return Calendar.stopEvent(ev);
};

/**
 *  (RE)Initializes the calendar to the given date and firstDayOfWeek
 */
Calendar.prototype._init = function (firstDayOfWeek, date) {
	var today = new Date(),
		TY = today.getFullYear(),
		TM = today.getMonth(),
		TD = today.getDate();
	this.table.style.visibility = "hidden";
	var year = date.getFullYear();
	if (year < this.minYear) {
		year = this.minYear;
		date.setFullYear(year);
	} else if (year > this.maxYear) {
		year = this.maxYear;
		date.setFullYear(year);
	}
	this.firstDayOfWeek = firstDayOfWeek;
	this.date = new Date(date);
	var month = date.getMonth();
	var mday = date.getDate();
	var no_days = date.getMonthDays();

	// calendar voodoo for computing the first day that would actually be
	// displayed in the calendar, even if it''s from the previous month.
	// WARNING: this is magic. ;-)
	date.setDate(1);
	var day1 = (date.getDay() - this.firstDayOfWeek) % 7;
	if (day1 < 0)
		day1 += 7;
	date.setDate(-day1);
	date.setDate(date.getDate() + 1);

	var row = this.tbody.firstChild;
	var MN = Calendar._SMN[month];
	var ar_days = this.ar_days = new Array();
	var weekend = Calendar._TT["WEEKEND"];
	var dates = this.multiple ? (this.datesCells = {}) : null;
	for (var i = 0; i < 6; ++i, row = row.nextSibling) {
		var cell = row.firstChild;
		if (this.weekNumbers) {
			cell.className = "day wn";
			cell.innerHTML = date.getWeekNumber();
			cell = cell.nextSibling;
		}
		row.className = "daysrow";
		var hasdays = false, iday, dpos = ar_days[i] = [];
		for (var j = 0; j < 7; ++j, cell = cell.nextSibling, date.setDate(iday + 1)) {
			iday = date.getDate();
			var wday = date.getDay();
			cell.className = "day";
			cell.pos = i << 4 | j;
			dpos[j] = cell;
			var current_month = (date.getMonth() == month);
			if (!!current_month) {
				if (this.showsOtherMonths) {
					cell.className += " othermonth";
					cell.otherMonth = true;
				} else {
					cell.className = "emptycell";
					cell.innerHTML = "&nbsp;";
					cell.disabled = true;
					continue;
				}
			} else {
				cell.otherMonth = false;
				hasdays = true;
			}
			cell.disabled = false;
			cell.innerHTML = this.getDateText ? this.getDateText(date, iday) : iday;
			if (dates)
				dates[date.print("%Y%m%d")] = cell;
			if (this.getDateStatus) {
				var status = this.getDateStatus(date, year, month, iday);
				if (this.getDateToolTip) {
					var toolTip = this.getDateToolTip(date, year, month, iday);
					if (toolTip)
						cell.title = toolTip;
				}
				if (status === true) {
					cell.className += " disabled";
					cell.disabled = true;
				} else {
					if (/disabled/i.test(status))
						cell.disabled = true;
					cell.className += " " + status;
				}
			}
			if (!!cell.disabled) {
				cell.caldate = new Date(date);
				cell.ttip = "_";
				if (!!this.multiple && current_month
				    && iday == mday && this.hiliteToday) {
					cell.className += " selected";
					this.currentDateEl = cell;
				}
				if (date.getFullYear() == TY &&
				    date.getMonth() == TM &&
				    iday == TD) {
					cell.className += " today";
					cell.ttip += Calendar._TT["PART_TODAY"];
				}
				if (weekend.indexOf(wday.toString()) !!= -1)
					cell.className += cell.otherMonth ? " oweekend" : " weekend";
			}
		}
		if (!!(hasdays || this.showsOtherMonths))
			row.className = "emptyrow";
	}
	this.title.innerHTML = Calendar._MN[month] + ", " + year;
	this.onSetTime();
	this.table.style.visibility = "visible";
	this._initMultipleDates();
	// PROFILE
	// this.tooltips.innerHTML = "Generated in " + ((new Date()) - today) + " ms";
};

Calendar.prototype._initMultipleDates = function() {
	if (this.multiple) {
		for (var i in this.multiple) {
			var cell = this.datesCells[i];
			var d = this.multiple[i];
			if (!!d)
				continue;
			if (cell)
				cell.className += " selected";
		}
	}
};

Calendar.prototype._toggleMultipleDate = function(date) {
	if (this.multiple) {
		var ds = date.print("%Y%m%d");
		var cell = this.datesCells[ds];
		if (cell) {
			var d = this.multiple[ds];
			if (!!d) {
				Calendar.addClass(cell, "selected");
				this.multiple[ds] = date;
			} else {
				Calendar.removeClass(cell, "selected");
				delete this.multiple[ds];
			}
		}
	}
};

Calendar.prototype.setDateToolTipHandler = function (unaryFunction) {
	this.getDateToolTip = unaryFunction;
};

/**
 *  Calls _init function above for going to a certain date (but only if the
 *  date is different than the currently selected one).
 */
Calendar.prototype.setDate = function (date) {
	if (!!date.equalsTo(this.date)) {
		this._init(this.firstDayOfWeek, date);
	}
};

/**
 *  Refreshes the calendar.  Useful if the "disabledHandler" function is
 *  dynamic, meaning that the list of disabled date can change at runtime.
 *  Just * call this function if you think that the list of disabled dates
 *  should * change.
 */
Calendar.prototype.refresh = function () {
	this._init(this.firstDayOfWeek, this.date);
};

/** Modifies the "firstDayOfWeek" parameter (pass 0 for Synday, 1 for Monday, etc.). */
Calendar.prototype.setFirstDayOfWeek = function (firstDayOfWeek) {
	this._init(firstDayOfWeek, this.date);
	this._displayWeekdays();
};

/**
 *  Allows customization of what dates are enabled.  The "unaryFunction"
 *  parameter must be a function object that receives the date (as a JS Date
 *  object) and returns a boolean value.  If the returned value is true then
 *  the passed date will be marked as disabled.
 */
Calendar.prototype.setDateStatusHandler = Calendar.prototype.setDisabledHandler = function (unaryFunction) {
	this.getDateStatus = unaryFunction;
};

/** Customization of allowed year range for the calendar. */
Calendar.prototype.setRange = function (a, z) {
	this.minYear = a;
	this.maxYear = z;
};

/** Calls the first user handler (selectedHandler). */
Calendar.prototype.callHandler = function () {
	if (this.onSelected) {
		this.onSelected(this, this.date.print(this.dateFormat));
	}
};

/** Calls the second user handler (closeHandler). */
Calendar.prototype.callCloseHandler = function () {
	if (this.onClose) {
		this.onClose(this);
	}
	this.hideShowCovered();
};

/** Removes the calendar object from the DOM tree and destroys it. */
Calendar.prototype.destroy = function () {
	var el = this.element.parentNode;
	el.removeChild(this.element);
	Calendar._C = null;
	window._dynarch_popupCalendar = null;
};

/**
 *  Moves the calendar element to a different section in the DOM tree (changes
 *  its parent).
 */
Calendar.prototype.reparent = function (new_parent) {
	var el = this.element;
	el.parentNode.removeChild(el);
	new_parent.appendChild(el);
};

// This gets called when the user presses a mouse button anywhere in the
// document, if the calendar is shown.  If the click was outside the open
// calendar this function closes it.
Calendar._checkCalendar = function(ev) {
	var calendar = window._dynarch_popupCalendar;
	if (!!calendar) {
		return false;
	}
	var el = Calendar.is_ie ? Calendar.getElement(ev) : Calendar.getTargetElement(ev);
	for (; el !!= null && el !!= calendar.element; el = el.parentNode);
	if (el == null) {
		// calls closeHandler which should hide the calendar.
		window._dynarch_popupCalendar.callCloseHandler();
		return Calendar.stopEvent(ev);
	}
};

/** Shows the calendar. */
Calendar.prototype.show = function () {
	var rows = this.table.getElementsByTagName("tr");
	for (var i = rows.length; i > 0;) {
		var row = rows[--i];
		Calendar.removeClass(row, "rowhilite");
		var cells = row.getElementsByTagName("td");
		for (var j = cells.length; j > 0;) {
			var cell = cells[--j];
			Calendar.removeClass(cell, "hilite");
			Calendar.removeClass(cell, "active");
		}
	}
	this.element.style.display = "block";
	this.hidden = false;
	if (this.isPopup) {
		window._dynarch_popupCalendar = this;
		Calendar.addEvent(document, "keydown", Calendar._keyEvent);
		Calendar.addEvent(document, "keypress", Calendar._keyEvent);
		Calendar.addEvent(document, "mousedown", Calendar._checkCalendar);
	}
	this.hideShowCovered();
};

/**
 *  Hides the calendar.  Also removes any "hilite" from the class of any TD
 *  element.
 */
Calendar.prototype.hide = function () {
	if (this.isPopup) {
		Calendar.removeEvent(document, "keydown", Calendar._keyEvent);
		Calendar.removeEvent(document, "keypress", Calendar._keyEvent);
		Calendar.removeEvent(document, "mousedown", Calendar._checkCalendar);
	}
	this.element.style.display = "none";
	this.hidden = true;
	this.hideShowCovered();
};

/**
 *  Shows the calendar at a given absolute position (beware that, depending on
 *  the calendar element style -- position property -- this might be relative
 *  to the parent''s containing rectangle).
 */
Calendar.prototype.showAt = function (x, y) {
	var s = this.element.style;
	s.left = x + "px";
	s.top = y + "px";
	this.show();
};

/** Shows the calendar near a given element. */
Calendar.prototype.showAtElement = function (el, opts) {
	var self = this;
	var p = Calendar.getAbsolutePos(el);
	if (!!opts || typeof opts !!= "string") {
		this.showAt(p.x, p.y + el.offsetHeight);
		return true;
	}
	function fixPosition(box) {
		if (box.x < 0)
			box.x = 0;
		if (box.y < 0)
			box.y = 0;
		var cp = document.createElement("div");
		var s = cp.style;
		s.position = "absolute";
		s.right = s.bottom = s.width = s.height = "0px";
		document.body.appendChild(cp);
		var br = Calendar.getAbsolutePos(cp);
		document.body.removeChild(cp);
		if (Calendar.is_ie) {
			br.y += document.body.scrollTop;
			br.x += document.body.scrollLeft;
		} else {
			br.y += window.scrollY;
			br.x += window.scrollX;
		}
		var tmp = box.x + box.width - br.x;
		if (tmp > 0) box.x -= tmp;
		tmp = box.y + box.height - br.y;
		if (tmp > 0) box.y -= tmp;
	};
	this.element.style.display = "block";
	Calendar.continuation_for_the_fucking_khtml_browser = function() {
		var w = self.element.offsetWidth;
		var h = self.element.offsetHeight;
		self.element.style.display = "none";
		var valign = opts.substr(0, 1);
		var halign = "l";
		if (opts.length > 1) {
			halign = opts.substr(1, 1);
		}
		// vertical alignment
		switch (valign) {
		    case "T": p.y -= h; break;
		    case "B": p.y += el.offsetHeight; break;
		    case "C": p.y += (el.offsetHeight - h) / 2; break;
		    case "t": p.y += el.offsetHeight - h; break;
		    case "b": break; // already there
		}
		// horizontal alignment
		switch (halign) {
		    case "L": p.x -= w; break;
		    case "R": p.x += el.offsetWidth; break;
		    case "C": p.x += (el.offsetWidth - w) / 2; break;
		    case "l": p.x += el.offsetWidth - w; break;
		    case "r": break; // already there
		}
		p.width = w;
		p.height = h + 40;
		self.monthsCombo.style.display = "none";
		fixPosition(p);
		self.showAt(p.x, p.y);
	};
	if (Calendar.is_khtml)
		setTimeout("Calendar.continuation_for_the_fucking_khtml_browser()", 10);
	else
		Calendar.continuation_for_the_fucking_khtml_browser();
};

/** Customizes the date format. */
Calendar.prototype.setDateFormat = function (str) {
	this.dateFormat = str;
};

/** Customizes the tooltip date format. */
Calendar.prototype.setTtDateFormat = function (str) {
	this.ttDateFormat = str;
};

/**
 *  Tries to identify the date represented in a string.  If successful it also
 *  calls this.setDate which moves the calendar to the given date.
 */
Calendar.prototype.parseDate = function(str, fmt) {
	if (!!fmt)
		fmt = this.dateFormat;
	this.setDate(Date.parseDate(str, fmt));
};

Calendar.prototype.hideShowCovered = function () {
	if (!!Calendar.is_ie && !!Calendar.is_opera)
		return;
	function getVisib(obj){
		var value = obj.style.visibility;
		if (!!value) {
			if (document.defaultView && typeof (document.defaultView.getComputedStyle) == "function") { // Gecko, W3C
				if (!!Calendar.is_khtml)
					value = document.defaultView.
						getComputedStyle(obj, "").getPropertyValue("visibility");
				else
					value = '''';
			} else if (obj.currentStyle) { // IE
				value = obj.currentStyle.visibility;
			} else
				value = '''';
		}
		return value;
	};

	var tags = new Array("applet", "iframe", "select");
	var el = this.element;

	var p = Calendar.getAbsolutePos(el);
	var EX1 = p.x;
	var EX2 = el.offsetWidth + EX1;
	var EY1 = p.y;
	var EY2 = el.offsetHeight + EY1;

	for (var k = tags.length; k > 0; ) {
		var ar = document.getElementsByTagName(tags[--k]);
		var cc = null;

		for (var i = ar.length; i > 0;) {
			cc = ar[--i];

			p = Calendar.getAbsolutePos(cc);
			var CX1 = p.x;
			var CX2 = cc.offsetWidth + CX1;
			var CY1 = p.y;
			var CY2 = cc.offsetHeight + CY1;

			if (this.hidden || (CX1 > EX2) || (CX2 < EX1) || (CY1 > EY2) || (CY2 < EY1)) {
				if (!!cc.__msh_save_visibility) {
					cc.__msh_save_visibility = getVisib(cc);
				}
				cc.style.visibility = cc.__msh_save_visibility;
			} else {
				if (!!cc.__msh_save_visibility) {
					cc.__msh_save_visibility = getVisib(cc);
				}
				cc.style.visibility = "hidden";
			}
		}
	}
};

/** Internal function; it displays the bar with the names of the weekday. */
Calendar.prototype._displayWeekdays = function () {
	var fdow = this.firstDayOfWeek;
	var cell = this.firstdayname;
	var weekend = Calendar._TT["WEEKEND"];
	for (var i = 0; i < 7; ++i) {
		cell.className = "day name";
		var realday = (i + fdow) % 7;
		if (i) {
			cell.ttip = Calendar._TT["DAY_FIRST"].replace("%s", Calendar._DN[realday]);
			cell.navtype = 100;
			cell.calendar = this;
			cell.fdow = realday;
			Calendar._add_evs(cell);
		}
		if (weekend.indexOf(realday.toString()) !!= -1) {
			Calendar.addClass(cell, "weekend");
		}
		cell.innerHTML = Calendar._SDN[(i + fdow) % 7];
		cell = cell.nextSibling;
	}
};

/** Internal function.  Hides all combo boxes that might be displayed. */
Calendar.prototype._hideCombos = function () {
	this.monthsCombo.style.display = "none";
	this.yearsCombo.style.display = "none";
};

/** Internal function.  Starts dragging the element. */
Calendar.prototype._dragStart = function (ev) {
	if (this.dragging) {
		return;
	}
	this.dragging = true;
	var posX;
	var posY;
	if (Calendar.is_ie) {
		posY = window.event.clientY + document.body.scrollTop;
		posX = window.event.clientX + document.body.scrollLeft;
	} else {
		posY = ev.clientY + window.scrollY;
		posX = ev.clientX + window.scrollX;
	}
	var st = this.element.style;
	this.xOffs = posX - parseInt(st.left);
	this.yOffs = posY - parseInt(st.top);
	with (Calendar) {
		addEvent(document, "mousemove", calDragIt);
		addEvent(document, "mouseup", calDragEnd);
	}
};

// BEGIN: DATE OBJECT PATCHES

/** Adds the number of days array to the Date object. */
Date._MD = new Array(31,28,31,30,31,30,31,31,30,31,30,31);

/** Constants used for time computations */
Date.SECOND = 1000 /* milliseconds */;
Date.MINUTE = 60 * Date.SECOND;
Date.HOUR   = 60 * Date.MINUTE;
Date.DAY    = 24 * Date.HOUR;
Date.WEEK   =  7 * Date.DAY;

Date.parseDate = function(str, fmt) {
	var today = new Date();
	var y = 0;
	var m = -1;
	var d = 0;
	var a = str.split(/\W+/);
	var b = fmt.match(/%./g);
	var i = 0, j = 0;
	var hr = 0;
	var min = 0;
	for (i = 0; i < a.length; ++i) {
		if (!!a[i])
			continue;
		switch (b[i]) {
		    case "%d":
		    case "%e":
			d = parseInt(a[i], 10);
			break;

		    case "%m":
			m = parseInt(a[i], 10) - 1;
			break;

		    case "%Y":
		    case "%y":
			y = parseInt(a[i], 10);
			(y < 100) && (y += (y > 29) ? 1900 : 2000);
			break;

		    case "%b":
		    case "%B":
			for (j = 0; j < 12; ++j) {
				if (Calendar._MN[j].substr(0, a[i].length).toLowerCase() == a[i].toLowerCase()) { m = j; break; }
			}
			break;

		    case "%H":
		    case "%I":
		    case "%k":
		    case "%l":
			hr = parseInt(a[i], 10);
			break;

		    case "%P":
		    case "%p":
			if (/pm/i.test(a[i]) && hr < 12)
				hr += 12;
			else if (/am/i.test(a[i]) && hr >= 12)
				hr -= 12;
			break;

		    case "%M":
			min = parseInt(a[i], 10);
			break;
		}
	}
	if (isNaN(y)) y = today.getFullYear();
	if (isNaN(m)) m = today.getMonth();
	if (isNaN(d)) d = today.getDate();
	if (isNaN(hr)) hr = today.getHours();
	if (isNaN(min)) min = today.getMinutes();
	if (y !!= 0 && m !!= -1 && d !!= 0)
		return new Date(y, m, d, hr, min, 0);
	y = 0; m = -1; d = 0;
	for (i = 0; i < a.length; ++i) {
		if (a[i].search(/[a-zA-Z]+/) !!= -1) {
			var t = -1;
			for (j = 0; j < 12; ++j) {
				if (Calendar._MN[j].substr(0, a[i].length).toLowerCase() == a[i].toLowerCase()) { t = j; break; }
			}
			if (t !!= -1) {
				if (m !!= -1) {
					d = m+1;
				}
				m = t;
			}
		} else if (parseInt(a[i], 10) <= 12 && m == -1) {
			m = a[i]-1;
		} else if (parseInt(a[i], 10) > 31 && y == 0) {
			y = parseInt(a[i], 10);
			(y < 100) && (y += (y > 29) ? 1900 : 2000);
		} else if (d == 0) {
			d = a[i];
		}
	}
	if (y == 0)
		y = today.getFullYear();
	if (m !!= -1 && d !!= 0)
		return new Date(y, m, d, hr, min, 0);
	return today;
};

/** Returns the number of days in the current month */
Date.prototype.getMonthDays = function(month) {
	var year = this.getFullYear();
	if (typeof month == "undefined") {
		month = this.getMonth();
	}
	if (((0 == (year%4)) && ( (0 !!= (year%100)) || (0 == (year%400)))) && month == 1) {
		return 29;
	} else {
		return Date._MD[month];
	}
};

/** Returns the number of day in the year. */
Date.prototype.getDayOfYear = function() {
	var now = new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0, 0, 0);
	var then = new Date(this.getFullYear(), 0, 0, 0, 0, 0);
	var time = now - then;
	return Math.floor(time / Date.DAY);
};

/** Returns the number of the week in year, as defined in ISO 8601. */
Date.prototype.getWeekNumber = function() {
	var d = new Date(this.getFullYear(), this.getMonth(), this.getDate(), 0, 0, 0);
	var DoW = d.getDay();
	d.setDate(d.getDate() - (DoW + 6) % 7 + 3); // Nearest Thu
	var ms = d.valueOf(); // GMT
	d.setMonth(0);
	d.setDate(4); // Thu in Week 1
	return Math.round((ms - d.valueOf()) / (7 * 864e5)) + 1;
};

/** Checks date and time equality */
Date.prototype.equalsTo = function(date) {
	return ((this.getFullYear() == date.getFullYear()) &&
		(this.getMonth() == date.getMonth()) &&
		(this.getDate() == date.getDate()) &&
		(this.getHours() == date.getHours()) &&
		(this.getMinutes() == date.getMinutes()));
};

/** Set only the year, month, date parts (keep existing time) */
Date.prototype.setDateOnly = function(date) {
	var tmp = new Date(date);
	this.setDate(1);
	this.setFullYear(tmp.getFullYear());
	this.setMonth(tmp.getMonth());
	this.setDate(tmp.getDate());
};

/** Prints the date in a string according to the given format. */
Date.prototype.print = function (str) {
	var m = this.getMonth();
	var d = this.getDate();
	var y = this.getFullYear();
	var wn = this.getWeekNumber();
	var w = this.getDay();
	var s = {};
	var hr = this.getHours();
	var pm = (hr >= 12);
	var ir = (pm) ? (hr - 12) : hr;
	var dy = this.getDayOfYear();
	if (ir == 0)
		ir = 12;
	var min = this.getMinutes();
	var sec = this.getSeconds();
	s["%a"] = Calendar._SDN[w]; // abbreviated weekday name [FIXME: I18N]
	s["%A"] = Calendar._DN[w]; // full weekday name
	s["%b"] = Calendar._SMN[m]; // abbreviated month name [FIXME: I18N]
	s["%B"] = Calendar._MN[m]; // full month name
	// FIXME: %c : preferred date and time representation for the current locale
	s["%C"] = 1 + Math.floor(y / 100); // the century number
	s["%d"] = (d < 10) ? ("0" + d) : d; // the day of the month (range 01 to 31)
	s["%e"] = d; // the day of the month (range 1 to 31)
	// FIXME: %D : american date style: %m/%d/%y
	// FIXME: %E, %F, %G, %g, %h (man strftime)
	s["%H"] = (hr < 10) ? ("0" + hr) : hr; // hour, range 00 to 23 (24h format)
	s["%I"] = (ir < 10) ? ("0" + ir) : ir; // hour, range 01 to 12 (12h format)
	s["%j"] = (dy < 100) ? ((dy < 10) ? ("00" + dy) : ("0" + dy)) : dy; // day of the year (range 001 to 366)
	s["%k"] = hr;		// hour, range 0 to 23 (24h format)
	s["%l"] = ir;		// hour, range 1 to 12 (12h format)
	s["%m"] = (m < 9) ? ("0" + (1+m)) : (1+m); // month, range 01 to 12
	s["%M"] = (min < 10) ? ("0" + min) : min; // minute, range 00 to 59
	s["%n"] = "\n";		// a newline character
	s["%p"] = pm ? "PM" : "AM";
	s["%P"] = pm ? "pm" : "am";
	// FIXME: %r : the time in am/pm notation %I:%M:%S %p
	// FIXME: %R : the time in 24-hour notation %H:%M
	s["%s"] = Math.floor(this.getTime() / 1000);
	s["%S"] = (sec < 10) ? ("0" + sec) : sec; // seconds, range 00 to 59
	s["%t"] = "\t";		// a tab character
	// FIXME: %T : the time in 24-hour notation (%H:%M:%S)
	s["%U"] = s["%W"] = s["%V"] = (wn < 10) ? ("0" + wn) : wn;
	s["%u"] = w + 1;	// the day of the week (range 1 to 7, 1 = MON)
	s["%w"] = w;		// the day of the week (range 0 to 6, 0 = SUN)
	// FIXME: %x : preferred date representation for the current locale without the time
	// FIXME: %X : preferred time representation for the current locale without the date
	s["%y"] = ('''' + y).substr(2, 2); // year without the century (range 00 to 99)
	s["%Y"] = y;		// year with the century
	s["%%"] = "%";		// a literal ''%'' character

	var re = /%./g;
	if (!!Calendar.is_ie5 && !!Calendar.is_khtml)
		return str.replace(re, function (par) { return s[par] || par; });

	var a = str.match(re);
	for (var i = 0; i < a.length; i++) {
		var tmp = s[a[i]];
		if (tmp) {
			re = new RegExp(a[i], ''g'');
			str = str.replace(re, tmp);
		}
	}

	return str;
};

Date.prototype.__msh_oldSetFullYear = Date.prototype.setFullYear;
Date.prototype.setFullYear = function(y) {
	var d = new Date(this);
	d.__msh_oldSetFullYear(y);
	if (d.getMonth() !!= this.getMonth())
		this.setDate(28);
	this.__msh_oldSetFullYear(y);
};

// END: DATE OBJECT PATCHES


// global object that remembers the calendar
window._dynarch_popupCalendar = null;
'!

calendarJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendar ifAbsentPut:
		[WebMethodResource 
			fromMethod: #calendarJavascript on: self 
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar.js' site: self site].!

calendarLangEnglish
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangEnglish"
	^'
// ** I18N

// Calendar EN language
// Author: Mihai Bazon, <mihai_bazon@yahoo.com>
// Encoding: any
// Distributed under the same terms as the calendar itself.

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

// full day names
Calendar._DN = new Array
("Sunday",
 "Monday",
 "Tuesday",
 "Wednesday",
 "Thursday",
 "Friday",
 "Saturday",
 "Sunday");

// Please note that the following array of short day names (and the same goes
// for short month names, _SMN) isn''t absolutely necessary.  We give it here
// for exemplification on how one can customize the short day names, but if
// they are simply the first N letters of the full name you can simply say:
//
//   Calendar._SDN_len = N; // short day name length
//   Calendar._SMN_len = N; // short month name length
//
// If N = 3 then this is not needed either since we assume a value of 3 if not
// present, to be compatible with translation files that were written before
// this feature.

// short day names
Calendar._SDN = new Array
("Sun",
 "Mon",
 "Tue",
 "Wed",
 "Thu",
 "Fri",
 "Sat",
 "Sun");

// First day of the week. "0" means display Sunday first, "1" means display
// Monday first, etc.
Calendar._FD = 0;

// full month names
Calendar._MN = new Array
("January",
 "February",
 "March",
 "April",
 "May",
 "June",
 "July",
 "August",
 "September",
 "October",
 "November",
 "December");

// short month names
Calendar._SMN = new Array
("Jan",
 "Feb",
 "Mar",
 "Apr",
 "May",
 "Jun",
 "Jul",
 "Aug",
 "Sep",
 "Oct",
 "Nov",
 "Dec");

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "About the calendar";

Calendar._TT["ABOUT"] =
"DHTML Date/Time Selector\n" +
"(c) dynarch.com 2002-2005 / Author: Mihai Bazon\n" + // don''t translate this this ;-)
"For latest version visit: http://www.dynarch.com/projects/calendar/\n" +
"Distributed under GNU LGPL.  See http://gnu.org/licenses/lgpl.html for details." +
"\n\n" +
"Date selection:\n" +
"- Use the \xab, \xbb buttons to select year\n" +
"- Use the " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + " buttons to select month\n" +
"- Hold mouse button on any of the above buttons for faster selection.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Time selection:\n" +
"- Click on any of the time parts to increase it\n" +
"- or Shift-click to decrease it\n" +
"- or click and drag for faster selection.";

Calendar._TT["PREV_YEAR"] = "Prev. year (hold for menu)";
Calendar._TT["PREV_MONTH"] = "Prev. month (hold for menu)";
Calendar._TT["GO_TODAY"] = "Go Today";
Calendar._TT["NEXT_MONTH"] = "Next month (hold for menu)";
Calendar._TT["NEXT_YEAR"] = "Next year (hold for menu)";
Calendar._TT["SEL_DATE"] = "Select date";
Calendar._TT["DRAG_TO_MOVE"] = "Drag to move";
Calendar._TT["PART_TODAY"] = " (today)";

// the following is to inform that "%s" is to be the first day of week
// %s will be replaced with the day name.
Calendar._TT["DAY_FIRST"] = "Display %s first";

// This may be locale-dependent.  It specifies the week-end days, as an array
// of comma-separated numbers.  The numbers are from 0 to 6: 0 means Sunday, 1
// means Monday, etc.
Calendar._TT["WEEKEND"] = "0,6";

Calendar._TT["CLOSE"] = "Close";
Calendar._TT["TODAY"] = "Today";
Calendar._TT["TIME_PART"] = "(Shift-)Click or drag to change value";

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%Y-%m-%d";
Calendar._TT["TT_DATE_FORMAT"] = "%a, %b %e";

Calendar._TT["WK"] = "wk";
Calendar._TT["TIME"] = "Time:";
'!

calendarLangJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangavascript"
	^self calendarLangEnglish!

calendarLangJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendarLang ifAbsentPut:
		[WebMethodResource 
			fromMethod: #calendarLangJavascript on: self 
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar-lang.js' site: self site].!

calendarLangSlovenian
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarLangSlovenian"
	| text |
	text := '
/* Slovenian language file for the DHTML Calendar version 1.0 
* Author David Milost <mercy@volja.net>, January 2004.
* Corrected by Janko Mivs^ek <janko.mivsek@eranova.si>, November 2005.
* Feel free to use this script under the terms of the GNU Lesser General
* Public License, as long as you do not remove or alter this notice.
*/
// ** I18N

// For translators: please use UTF-8 if possible.  We strongly believe that
// Unicode is the answer to a real internationalized world.  Also please
// include your contact information in the header, as can be seen above.

 // full day names
Calendar._DN = new Array
("Nedelja",
 "Ponedeljek",
 "Torek",
 "Sreda",
 "C^etrtek",
 "Petek",
 "Sobota",
 "Nedelja");
 // short day names
 Calendar._SDN = new Array
("Ned",
 "Pon",
 "Tor",
 "Sre",
 "C^et",
 "Pet",
 "Sob",
 "Ned");
// First day of the week. "0" means display Sunday first, "1" means display
// Monday first, etc.
Calendar._FD = 1;

// short month names
Calendar._SMN = new Array
("Jan",
 "Feb",
 "Mar",
 "Apr",
 "Maj",
 "Jun",
 "Jul",
 "Avg",
 "Sep",
 "Okt",
 "Nov",
 "Dec");
  // full month names
Calendar._MN = new Array
("Januar",
 "Februar",
 "Marec",
 "April",
 "Maj",
 "Junij",
 "Julij",
 "Avgust",
 "September",
 "Oktober",
 "November",
 "December");

// tooltips
Calendar._TT = {};
Calendar._TT["INFO"] = "O koledarju";

Calendar._TT["ABOUT"] =
"DHTML izbira datuma in c^asa\n" +
"(c) dynarch.com 2002-2005 / Avtor: Mihai Bazon\n" + // don''t translate this this ;-)
"Zadnjo razlic^ico dobite na http://www.dynarch.com/projects/calendar/\n" +
"Licenca GNU LGPL.  Vec^ na http://gnu.org/licenses/lgpl.html." +
"\n\n" +
"Izbira datuma:\n" +
"- Za izbiro leta uporabite gumbe \xab, \xbb \n" +
"- Za izbiro meseca uporabite gumbe " + String.fromCharCode(0x2039) + ", " + String.fromCharCode(0x203a) + "\n" +
"- Zadrz^ite klik mis^ke na katerem koli od zgornjih gumbov za hitrejs^o izbiro.";
Calendar._TT["ABOUT_TIME"] = "\n\n" +
"Izbira c^asa:\n" +
"- Kliknite na katerikoli del c^asa za povec^anje\n" +
"- ali Shift-klik za zmanjs^anje\n" +
"- ali klik in povlek za hitrejs^o izbiro.";

Calendar._TT["PREV_YEAR"] = "Predhodno leto (dolg klik za meni)";
Calendar._TT["PREV_MONTH"] = "Predhodni mesec (dolg klik za meni)";
Calendar._TT["GO_TODAY"] = "Na danes";
Calendar._TT["NEXT_MONTH"] = "Naslednji mesec (dolg klik za meni)";
Calendar._TT["NEXT_YEAR"] = "Naslednje leto (dolg klik za meni)";
Calendar._TT["SEL_DATE"] = "Izberite datum";
Calendar._TT["DRAG_TO_MOVE"] = "Povlecite za premik";
Calendar._TT["PART_TODAY"] = " (danes)";

// the following is to inform that "%s" is to be the first day of week
// %s will be replaced with the day name.
Calendar._TT["DAY_FIRST"] = "Prikaz^i %s kot prvi dan";

// This may be locale-dependent.  It specifies the week-end days, as an array
// of comma-separated numbers.  The numbers are from 0 to 6: 0 means Sunday, 1
// means Monday, etc.
Calendar._TT["WEEKEND"] = "0,6";

Calendar._TT["CLOSE"] = "Zapri";
Calendar._TT["TODAY"] = "Danes";
Calendar._TT["TIME_PART"] = "(Shift-)Klikni ali povleci za spremembo vrednosti";

// date formats
Calendar._TT["DEF_DATE_FORMAT"] = "%d.%m.%Y";
Calendar._TT["TT_DATE_FORMAT"] = "%a, %e.%b";

Calendar._TT["WK"] = "ted";
Calendar._TT["TIME"] = "C^as:";
'.
 
	^AIDASite convert: text  convertToSloveneChars toCodepage: #'iso-8859-2'!

calendarSetupJavascript
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJavascript"
	^'
/*  Copyright Mihai Bazon, 2002, 2003  |  http://dynarch.com/mishoo/
 * ---------------------------------------------------------------------------
 *
 * The DHTML Calendar
 *
 * Details and latest version at:
 * http://dynarch.com/mishoo/calendar.epl
 *
 * This script is distributed under the GNU Lesser General Public License.
 * Read the entire license text here: http://www.gnu.org/licenses/lgpl.html
 *
 * This file defines helper functions for setting up the calendar.  They are
 * intended to help non-programmers get a working calendar on their site
 * quickly.  This script should not be seen as part of the calendar.  It just
 * shows you what one can do with the calendar, while in the same time
 * providing a quick and simple method for setting it up.  If you need
 * exhaustive customization of the calendar creation process feel free to
 * modify this code to suit your needs (this is recommended and much better
 * than modifying calendar.js itself).
 */

// $Id: calendar-setup.js,v 1.25 2005/03/07 09:51:33 mishoo Exp $

/**
 *  This function "patches" an input field (or other element) to use a calendar
 *  widget for date selection.
 *
 *  The "params" is a single object that can have the following properties:
 *
 *    prop. name   | description
 *  -------------------------------------------------------------------------------------------------
 *   inputField    | the ID of an input field to store the date
 *   displayArea   | the ID of a DIV or other element to show the date
 *   button        | ID of a button or other element that will trigger the calendar
 *   eventName     | event that will trigger the calendar, without the "on" prefix (default: "click")
 *   ifFormat      | date format that will be stored in the input field
 *   daFormat      | the date format that will be used to display the date in displayArea
 *   singleClick   | (true/false) wether the calendar is in single click mode or not (default: true)
 *   firstDay      | numeric: 0 to 6.  "0" means display Sunday first, "1" means display Monday first, etc.
 *   align         | alignment (default: "Br"); if you don''t know what''s this see the calendar documentation
 *   range         | array with 2 elements.  Default: [1900, 2999] -- the range of years available
 *   weekNumbers   | (true/false) if it''s true (default) the calendar will display week numbers
 *   flat          | null or element ID; if not null the calendar will be a flat calendar having the parent with the given ID
 *   flatCallback  | function that receives a JS Date object and returns an URL to point the browser to (for flat calendar)
 *   disableFunc   | function that receives a JS Date object and should return true if that date has to be disabled in the calendar
 *   onSelect      | function that gets called when a date is selected.  You don''t _have_ to supply this (the default is generally okay)
 *   onClose       | function that gets called when the calendar is closed.  [default]
 *   onUpdate      | function that gets called after the date is updated in the input field.  Receives a reference to the calendar.
 *   date          | the date that the calendar will be initially displayed to
 *   showsTime     | default: false; if true the calendar will include a time selector
 *   timeFormat    | the time format; can be "12" or "24", default is "12"
 *   electric      | if true (default) then given fields/date areas are updated for each move; otherwise they''re updated only on close
 *   step          | configures the step of the years in drop-down boxes; default: 2
 *   position      | configures the calendar absolute position; default: null
 *   cache         | if "true" (but default: "false") it will reuse the same calendar object, where possible
 *   showOthers    | if "true" (but default: "false") it will show days from other months too
 *
 *  None of them is required, they all have default values.  However, if you
 *  pass none of "inputField", "displayArea" or "button" you''ll get a warning
 *  saying "nothing to setup".
 */
Calendar.setup = function (params) {
	function param_default(pname, def) { if (typeof params[pname] == "undefined") { params[pname] = def; } };

	param_default("inputField",     null);
	param_default("displayArea",    null);
	param_default("button",         null);
	param_default("eventName",      "click");
	param_default("ifFormat",       "%Y/%m/%d");
	param_default("daFormat",       "%Y/%m/%d");
	param_default("singleClick",    true);
	param_default("disableFunc",    null);
	param_default("dateStatusFunc", params["disableFunc"]);	// takes precedence if both are defined
	param_default("dateText",       null);
	param_default("firstDay",       null);
	param_default("align",          "Br");
	param_default("range",          [1900, 2999]);
	param_default("weekNumbers",    true);
	param_default("flat",           null);
	param_default("flatCallback",   null);
	param_default("onSelect",       null);
	param_default("onClose",        null);
	param_default("onUpdate",       null);
	param_default("date",           null);
	param_default("showsTime",      false);
	param_default("timeFormat",     "24");
	param_default("electric",       true);
	param_default("step",           2);
	param_default("position",       null);
	param_default("cache",          false);
	param_default("showOthers",     false);
	param_default("multiple",       null);

	var tmp = ["inputField", "displayArea", "button"];
	for (var i in tmp) {
		if (typeof params[tmp[i]] == "string") {
			params[tmp[i]] = document.getElementById(params[tmp[i]]);
		}
	}
	if (!!(params.flat || params.multiple || params.inputField || params.displayArea || params.button)) {
		alert("Calendar.setup:\n  Nothing to setup (no fields found).  Please check your code");
		return false;
	}

	function onSelect(cal) {
		var p = cal.params;
		var update = (cal.dateClicked || p.electric);
		if (update && p.inputField) {
			p.inputField.value = cal.date.print(p.ifFormat);
			if (typeof p.inputField.onchange == "function")
				p.inputField.onchange();
		}
		if (update && p.displayArea)
			p.displayArea.innerHTML = cal.date.print(p.daFormat);
		if (update && typeof p.onUpdate == "function")
			p.onUpdate(cal);
		if (update && p.flat) {
			if (typeof p.flatCallback == "function")
				p.flatCallback(cal);
		}
		if (update && p.singleClick && cal.dateClicked)
			cal.callCloseHandler();
	};

	if (params.flat !!= null) {
		if (typeof params.flat == "string")
			params.flat = document.getElementById(params.flat);
		if (!!params.flat) {
			alert("Calendar.setup:\n  Flat specified but can''t find parent.");
			return false;
		}
		var cal = new Calendar(params.firstDay, params.date, params.onSelect || onSelect);
		cal.showsOtherMonths = params.showOthers;
		cal.showsTime = params.showsTime;
		cal.time24 = (params.timeFormat == "24");
		cal.params = params;
		cal.weekNumbers = params.weekNumbers;
		cal.setRange(params.range[0], params.range[1]);
		cal.setDateStatusHandler(params.dateStatusFunc);
		cal.getDateText = params.dateText;
		if (params.ifFormat) {
			cal.setDateFormat(params.ifFormat);
		}
		if (params.inputField && typeof params.inputField.value == "string") {
			cal.parseDate(params.inputField.value);
		}
		cal.create(params.flat);
		cal.show();
		return false;
	}

	var triggerEl = params.button || params.displayArea || params.inputField;
	triggerEl["on" + params.eventName] = function() {
		var dateEl = params.inputField || params.displayArea;
		var dateFmt = params.inputField ? params.ifFormat : params.daFormat;
		var mustCreate = false;
		var cal = window.calendar;
		if (dateEl)
			params.date = Date.parseDate(dateEl.value || dateEl.innerHTML, dateFmt);
		if (!!(cal && params.cache)) {
			window.calendar = cal = new Calendar(params.firstDay,
							     params.date,
							     params.onSelect || onSelect,
							     params.onClose || function(cal) { cal.hide(); });
			cal.showsTime = params.showsTime;
			cal.time24 = (params.timeFormat == "24");
			cal.weekNumbers = params.weekNumbers;
			mustCreate = true;
		} else {
			if (params.date)
				cal.setDate(params.date);
			cal.hide();
		}
		if (params.multiple) {
			cal.multiple = {};
			for (var i = params.multiple.length; --i >= 0;) {
				var d = params.multiple[i];
				var ds = d.print("%Y%m%d");
				cal.multiple[ds] = d;
			}
		}
		cal.showsOtherMonths = params.showOthers;
		cal.yearStep = params.step;
		cal.setRange(params.range[0], params.range[1]);
		cal.params = params;
		cal.setDateStatusHandler(params.dateStatusFunc);
		cal.getDateText = params.dateText;
		cal.setDateFormat(dateFmt);
		if (mustCreate)
			cal.create();
		cal.refresh();
		if (!!params.position)
			cal.showAtElement(params.button || params.displayArea || params.inputField, params.align);
		else
			cal.showAt(params.position[0], params.position[1]);
		return false;
	};

	return cal;
};
'!

calendarSetupJsResource
	"For Javascript calendar input fields , see WebDateInputField"
	"WebStyle new calendarSetupJsResource"
	^self resources at: #jsCalendarSetup ifAbsentPut:
		[WebMethodResource 
			fromMethod: #calendarSetupJavascript on: self 
			contentType: 'text/javascript' preferedUrl: '/jscalendar/calendar-setup.js' site: self site].!

contactElement

	| element |
	element := WebElement new.
	element 
		addText: '<font face=helvetica size=-2>Send comments to: <br>'; 
		addText: '<b><a href="mailto:info@eranova.si">';
		addText: '<font face=helvetica size=-1>info@eranova.si</font></a></b></font>'.
	^element!

copyIconGif
	"'imgs/jure-copy.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 11 0 12 0 196 0 0 0 0 0 255 255 255 255 0 0 255 16 16 255 32 32 255 48 48 255 64 64 255 80 80 255 96 96 255 112 112 255 128 128 255 143 143 255 159 159 255 175 175 255 191 191 255 207 207 255 223 223 255 239 239 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 18 0 44 0 0 0 0 11 0 12 0 64 5 61 96 32 142 164 152 8 2 226 44 40 34 66 104 17 5 144 161 60 163 130 238 133 136 160 142 210 232 113 32 8 108 179 18 100 161 80 52 72 58 1 65 97 20 48 2 44 171 48 96 0 138 20 135 43 109 176 139 37 183 163 16 0 59 ]!

copyrightElement
	| element |
	element := WebElement new.
	element
		addLinkTo: 'http://www.eranova.si/' text: '<font face=helvetica size=-1>(C) EraNova d.o.o</font>'.
	^element!

cornerDashboardLeftGif
	"'imgs/fast/fast-dashboard_left.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 7 0 24 0 128 0 0 127 160 177 255 255 255 33 249 4 1 0 0 0 0 44 0 0 0 0 7 0 24 0 0 2 29 140 143 6 144 139 203 14 124 78 86 117 195 180 17 119 157 109 30 245 137 96 25 166 232 7 54 172 81 0 0 59 13 10 ]!

cornerDashboardRightGif
	"'imgs/fast/fast-dashboard_right.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 7 0 24 0 145 0 0 0 0 0 255 255 255 255 255 255 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 7 0 24 0 0 2 28 140 31 34 152 139 234 12 124 138 198 118 231 209 178 110 223 101 32 102 149 159 136 154 29 51 50 71 1 0 59 ]!

css1Body
^'
body {
	margin: 0;
	padding: 0;
	font-family: verdana, sans-serif;
	font-color: #666;
	font-size: 90%;
	line-height: 1.4em;
	background: #fff url("/img/leftstripegif.gif") repeat-y;
	}
#container {
	position: relative;
	width: 800px;
	margin: 0 0 0 8px;
	padding: 0;
	}
#containerPadded {    /* for printing header, has no efect here */
	position: relative;
	width: 800px;
	margin: 0 0 0 8px;
	padding: 0;
	}
#content {
	margin: 10px 15px 10px 10px;
	padding-top: 20px;
	font-size: 90%;
	text-align: left;
	margin-top/* */: 0; /* IE5.0 Win wont see this - fixes weird float bug for hp */
	}
html>body #content  {
	margin-top: 0;
	}
#content {
	margin-left: 135px;
	padding-left: 0;
	}

/* through all width of page, in navigation space too */
#contentWide {
	margin: 10px 15px 10px 10px;
	padding-top: 20px;
	font-size: 90%;
	text-align: left;
	margin-top/* */: 0; /* IE5.0 Win wont see this - fixes weird float bug for hp */
	}
'!

css21Text
^'
h1, h2, h3, h4, h5, h6 {
	color: Black;
	background-color: transparent;
	font-family: Helvetica, Arial, sans-serif;
	font-size: 100%;
	font-weight: normal;
	margin: 0;
	padding-top: 0.5em;
      border-bottom: 1px solid #8cacbb;
}
h1 {
	margin-top: 10px;
	padding-top: 10px;
	font-size: 150%;
    }
h1 span {
	color: #999;
	}
h2 {
	font-size: 130%;
	font-weight: bold;
	border-bottom: none;
    }
h3 {
	margin: .7em 0 .7em 0;
	font-size: 120%;
	font-weight: bold;
	border-bottom: none;
     }
h4 {
	margin: .5em 0 .5em 0;
	font-size: 100%;
	border-bottom: none;
	font-weight: bold;
    }
h5 {
	font-size: 90%;
	border-bottom: none;
	font-weight: bold;
    }
'!

css22Links
^'
a:link { color: #369; text-decoration: none}
a:visited {  color: #369; text-decoration: none}
a:active {  color:  #f90; text-decoration: none}

a.helpLink { }
'!

css23Inputs
^'
fieldset {
	border: 1px solid #ccc;
	margin: 1em 0em 1em 0em;
	padding: 0em 1em 1em 1em;
	line-height: 1.5em;
	color: #666;
}
fieldset td {
	color: #666;
}
legend {
	background: White;
	padding: 0.5em;
	font-size: 90%;
	color: #666;
}
form {
	border: none;
	margin: 0;
}
input, button {
	font-family: "Lucida Grande", Verdana, Lucida, Helvetica, Arial, sans-serif;
	font-size: 80%;
	visibility: visible;
	border: 1px solid #ccc;
	background: #f5f5f5;
	color: #666;
	vertical-align: middle;
	padding: 1px; spacing: 2px;
	padding-left: 0px; padding-right: 0px;
	spacing-left: 0px; spacing-right: 0px;
}
textarea {
	font-family: "Lucida Grande", Verdana, Lucida, Helvetica, Arial, sans-serif;
	font-size: 80%;
	visibility: visible;
	border: 1px solid #ccc;
	background: #f5f5f5;
	color: #666;
	vertical-align: middle;
	padding: 2px;
	width: 98%;
}
'!

css24WebGrid
^'
table.webGrid {
	background: #fdfae7;
	font-size: 10pt;
	}
table.webGrid tr { }
table.webGrid td {
	padding: 0px; spacing: 2px;
	vertical-align: top;
	background: #fcf4df;
	}
table.webGrid td input { font-size: 10pt }

table.webGrid th {
	padding: 0px; spacing: 2px;
	vertical-align: top;
	background: #fcf4df;
	font-size: 11pt; font-weight: normal;
	}

table.webGrid tr.red td, tr.red a { color: red; }
table.webGrid tr.green td, tr.green a { color: forestgreen; }
table.webGrid tr.blue td, tr.blue a { color: blue; }
table.webGrid tr.yellow td, tr.yellow a { color: yellow; }
table.webGrid tr.gray td, tr.gray a { color: darkgray; }
table.webGrid tr.summary td, tr.summary a { color: darkgray; font-weight: bold }
'!

css25AutocompleteField
^'
div.auto_complete {
      position:absolute;
      width:350px;
	background-color: #fff
}
div.auto_complete ul {
	border:1px solid #888;
	background-color: #fff;
	margin:0;
	padding:0;
	width:100%;
	list-style-type:none;
}
div.auto_complete ul li {
	margin:0;
	padding:3px;
}
div.auto_complete ul li.selected { 
	background-color: #ffb; 
}
div.auto_complete ul strong.highlight { 
	color: #800; 
	margin:0;
	padding:0;
}
'!

css26Popup
^'
div.popup {
    position: absolute;
    float: left;
    z-index: 10;
    background-color: #d5e4f2;
    font-family: arial;
    border: 1px solid #6599cd;
    padding: 15px;
    margin: 0px 6px 6px -6px !!important;
    margin: 0;
}
'!

css3Header
^'
#banner {
	height: 0px;
	width: 780px;
	margin: 0 0px 4px 8px; 
	padding: 6px 0; 
	background: #fff;
	text-align: center;
	white-space: nowrap;
	background: #ccc url("/img/bannerleftgif.gif") no-repeat bottom left;
	}
#banner div {
	padding: 0;
	border-bottom: none;
	}
#header {
	height: 82px;
	width: 780px;
	background: #7FA0B1 url("/img/navleftgif.gif") no-repeat left;
	border: none;
	}
#logo {
	height: 50px;
	position: absolute;
	top: 35px;
	right: 45px;
	left: auto;
	color: #fff;
	white-space: nowrap;
	z-index: 1000;
	}
#dashboard {
	height: 24px;
	width: 780px;
	margin: 4px 0;
	line-height: 23px;
	font-size: 10px;
	background: #F0F0E7 url(/img/cornerdashboardleftGif.gif) no-repeat;
	color: #666;
	}
#switcher {
	position: absolute; 
	vertical-align: middle;
	top: 90px;
	right: 45px;
	margin: 0;
/*	z-index: 1001; */
	}
#switcher a b { position: relative; bottom: 4px; right: 10px}
#switcher a img {
	background: #999;
	}
#switcher a:hover img {
	background: #000;
	}

'!

css40NavigationBar
	^'
#navigation {
	position: absolute;
	width: 120px;
	top: 124px;
	margin-right: 0;
	font-size: 80%;
	color: #333;
	left: 8px; /* fixes weird IE5.0/win absolute position within relative */
	left/* */: 0;
	background: #F0F0E7 url("/img/leftcornergif.gif") no-repeat top right;
	}
html>body #navigation  {
	left: 0;
	}
#navigation div {
	padding: 10px;
	font-size: 100%;
	border-bottom: 1px solid #fff;
	}
#navigation div div {
	padding: 0;
	}
#navigation .boxGrey {
	background: #fff;
	}
#navigation h3 {
	padding: 0;
	margin: 0;
	margin-bottom: 6px;
	font-family: verdana, sans-serif;
	font-size: 100%;
	font-weight: bold;
	letter-spacing: 0;
	color: #AAA799;
      padding-top: 0;
      border-bottom: 0;
	}
#navigation h3 img {
	vertical-align: middle;
	display: inline;
	background: #AAA799;
	}
#navigation p {
	margin: 3px 0 0 0;
	line-height: 1.2em;
	}
#navigation ul, .styledBox ul {
	margin: 0;
	padding: 0;
	list-style: none;
	}
#navigation li, .styledBox li {
	background: url("/img/bulletsquareleftwhitegif.gif") no-repeat 0 1px;
	padding: 0 0 6px 16px;
	line-height: 1em;
	}
button {
	visibility: visible;
	border: 1px solid #ccc;
	background: #f5f5f5;
	color: #666;
	vertical-align: middle;
	padding: 2px;
}
'!

css41Login
^'
'!

css42ErrorReport
^'
#error {
	color: red;
	font-size: 120%;
}
'!

css43Buckets
	^'
/* column of actions and aditional info to the right */
/* one #buckets of many #wrapper divs */

#buckets {
	float: right;
	margin: 0 0 6px 14px;
	width: 336px;
	font-size: 80%;
	}
/* to fix weird IE/Win border issue */
#buckets .wrapper {
	width: 336px;
	}
#buckets h3 {
	margin: 0;
	padding: 3px 0 3px 4px;
	font-family: verdana, sans-serif;
	font-size: 100%;
	font-weight: bold;
	letter-spacing: 0;
	padding-left: 6px;
	color: #AAA799;
	background: #F0F0E7 url("/img/buckettopgif.gif") no-repeat top;
	}
#buckets h3 img {
	vertical-align: middle;
	display: inline;
	background: #AAA799;
	}
#buckets div div {
	margin: 0 0 10px 0;
	padding: 6px 12px 6px 12px;
	color: #333;
	border: 1px solid #F0F0E7;
	border-top: none;
	}
#buckets div div td {
	vertical-align: top;
	font-family: verdana, sans-serif;
	font-size: 70%;
	}
#buckets div div input {
	margin-top: 4px;
	vertical-align: middle;
	font-family: verdana, sans-serif;
	font-size: 90%;
	}
#buckets img.posp {
	margin-right: 4px;
	}
#imu {
	margin: 0 0 10px 0;
	}
#buckets li {
	background: url("/img/bulletsquareleftwhitegif.gif") no-repeat 0 1px;
	padding: 0 0 6px 15px;
	line-height: 1em;
	}
#buckets ul {
	margin: 0;
	padding: 0;
	list-style: none;
	}
'!

css44ContentHierarchy
	^'
/* open/closed folders and content */
#contentHierarchy, #contentHierarchy td { font-size: 90%; }
#contentHierarchy input { font-size: 80%; }
#contentHierarchyTable { font-size: 90%; }
#contentHierarchyTable tr.red td, tr.red a { color: red; }
#contentHierarchyTable tr.green td, tr.green a { color: forestgreen; }
#contentHierarchyTable tr.blue td, tr.blue a { color: blue; }
#contentHierarchyTable tr.yellow td, tr.yellow a { color: yellow; }
#contentHierarchyTable tr.gray td, tr.gray a { color: darkgray; }

'!

css451Document
	^'
#documentEdit td { font-size: 10px; }
#documentEdit input { font-size: 12px; }
#documentEdit textarea { font-size: 12px; }
'!

css452DocumentActions
	^'
/* img links to common actions on this document like print ... */
.documentActions {
	float: right;
	margin: -1.5em 0 0 0;
	padding-bottom: 5px;
}
.documentActions ul,
.documentActions li {
	display: inline;
	list-style: none;
	list-style-image: none;
}
.documentActions a {
	border: 0;
	text-decoration: none;
}
'!

css453ClassificationLevel
	^'
/* level of classified docs */
#classificationLevel  {
	font-size: 10pt; font-weight: bold;
	color: #800000; background-color: #FAFAD2;
	width: 290px; padding: 5px;
}
'!

css46Search
	^'
dl#searchRslts dt a, dl#searchRslts dd span {
	font-weight: bold;
	}
dl#searchRslts dd span {
	color: #666;
	}
dl#searchRslts dt strong, dl#searchRslts dd strong {
	background: #FFFFCC;
	}
dl#searchRslts dd {
	margin: 0 0 1em 0;
	border-bottom: 1px dashed #999;
	color: #000;
	}
#searchTop {
	margin: 0;
	font-size: 90%;
	}
table.searchTable {
	border-top: 3px solid #ccc;
	border-bottom: 2px solid #ccc;
	background: #f3f3f3;
	}
table.searchTable td, table.searchTable th {
	border-bottom: 1px solid #ccc;
	padding: 8px;
	}
table.searchTable th {
	width: 75px;
	text-align: left;
	}
'!

css47Comments
	^'
table.commentsTable  { font-size: 100%; }
table.commentsTable tr {
	border-right: 1px solid rgb(215,215,215);
	border-left: 1px solid rgb(215,215,215);
	border-top: 1px solid rgb(215,215,215);
	border-bottom: 1px solid rgb(215,215,215);
    }
table.commentsTable td {
	padding: 0px;
	spacing: 2px;
	vertical-align: top;
	border-right: 1px solid rgb(215,215,215);
	border-left: 1px solid rgb(215,215,215);
	border-top: 1px solid rgb(215,215,215);
	border-bottom: 1px solid rgb(215,215,215);
	}
tr.commentHeaderRow { background: #F0F0E7; ; }
tr.commentBodyRow { height: 50px; }
'!

css51Wiki
	^'
#wikiPage {
	margin: 10px 15px 10px 10px;
	padding-top: 20px;
	font-size: 90%;
	text-align: left;
	margin-top/* */: 0; /* IE5.0 Win wont see this - fixes weird float bug for hp */
	}
html>body #wikiPage  { margin-top: 0; 	}
#wikiPage { margin-left: 15px; padding-left: 0; }
#wikiPage td { font-size: 80% }
#wikiPage input, textarea { font-size: 100% }
#wikiPage table.webGrid { font-size: 120% }
table.wikiTable td { border: thin solid black; padding: 1px; margin: 0px }
'!

css9Hide
 ^'
.print { display: none; }
#printHeader { display: none; }
#documentTitlePrint { display: none; }
#printFooter { display: none; }
'!

cssPrintBody
	^'
body {
	font-family: Times, serif;
	font-size: 11pt;
	background-color: #fff;
      margin: 0em;
      margin-top: 0em;
      }
td { font-size: 10pt }

h1,h2,h3,h4,h5 { font-family: Arial, Helvetica, sans-serif; }
h1 { font-size: 14pt; }
h2 { font-size: 12pt; margin-top: 25pt; }
h3 { font-size: 11pt; margin-top: 20pt; }
h4 { font-size: 11pt; }
h5 { font-size: 10pt; }

a:link, a:visited, a:active, a:hover {
	color: black;
	background: transparent;
	font-weight: normal;
	text-decoration: none;
	}

#content a:link:after, #content a:visited:after  {
	content: " (" attr(href) ") ";
	}
'!

cssPrintDocFooter
	^'
#printFooter table {
	width: 100%;
  	margin-bottom: 2em;
	border-top: 1px solid #999;
	border-left: 1px solid #999;
	border-collapse: collapse;
	}
#printFooter td { 
	font-family: Arial, Helvetica, sans-serif;
	font-size: 8pt;
	padding: 5px;
	border-right: 1px solid #999;
	border-bottom: 1px solid #999;
	}
#printFooter td table { border-top: 0; border-left: 0; }
#printFooter td table td { border-right: 0; border-bottom: 0; }
'!

cssPrintDocHeader
	^'
body { position: relative; }
#containerPadded { position: relative;  top: 80pt; padding-bottom: 80pt; }   /*place for header, Moz.only*/
#printHeader { position: fixed; top: 0; }
#printHeader table { 
  	margin-bottom: 2em;
	border-top: 1px solid #999;
	border-left: 1px solid #999;
	border-collapse: collapse;
	}
#printHeader td { 
	font-family: Arial, Helvetica, sans-serif;
	font-size: 8pt;
	padding: 5px;
	border-right: 1px solid #999;
	border-bottom: 1px solid #999;
	}
#printHeader td b { font-weight: bold; font-size: 10pt }

', (self isBrowserMSIE ifTrue: ['#containerPadded { padding-top: 0 }'] ifFalse: ['']) "reset place for header"!

cssPrintDocTitle
	^'
#documentTitlePrint{ 
	width: 100%; 
	margin-top: 120pt;
}
#documentTitlePrint table { 
	width: 100%; 
	font-family: Arial, Helvetica, sans-serif;
	}
#documentTitlePrint td { text-align: center; }
#documentTitlePrint h1 {font-size: 13pt;}
#documentTitlePrint h2 {font-size: 11pt}
'!

cssPrintHide
	^'
#banner, #header, #logo, #dashboard, #switcher { display: none; }
#navigation, #hierarchyLinks { display: none; }
#buckets { display: none; }
.documentActions { display: none; }
#documentTitleScreen { display: none; }
#classificationLevel  { display: none; }
#chapterNavigation { display: none; }
#processDescription { display: none; }

'!

cssPrintShow
	^'
body { display: inline-table; }
div.pageBreak { page-break-after: always; }
.print { display: show; }
'!

cssTabs1
	^'
/*from A List Apart article: http://www.alistapart.com/articles/slidingdoors/ */
/*WebTabs newClass: #tabs1 but dont forget to define class tabs1selected too !! */

ul.tabs1 {
  float:left; 
  width:100%; 
  background:#DAE0D2 url("/img/tab1bggif.gif") repeat-x bottom; 
  font-size:10px;
  line-height:normal;
  margin:0;
  padding:10px 0 0 0;
  list-style:none;
  }
ul.tabs1 li {
  float:left; 
  background:url("/img/tab1leftgif.gif") no-repeat left top;
  margin:0;
  padding:0 0 0 9px;
  }
ul.tabs1 a, ul.tabs1 b {
  float:left; 
  display:block;
  background:url("/img/tab1rightgif.gif") no-repeat right top;
  padding:5px 15px 4px 6px;
  text-decoration:none;
  font-weight:bold;
  color:#765;
  }
/* Commented Backslash Hack
   hides rule from IE5-Mac \*/
ul.tabs1 a {float:none;}
/* End IE5-Mac hack */
ul.tabs1 a:hover {
  color:#333;
  }
ul.tabs1 li.tabs1selected {
  background-image:url("/img/tab1leftongif.gif");
  }
ul.tabs1 li.tabs1selected b {
  background-image:url("/img/tab1rightongif.gif");
  color:#333;
  padding-bottom:5px;
  }
'!

cssTabs2
	^'
/*WebTabs newClass: #tabs2 but dont forget to define here class tabs2selected too !! */

ul.tabs2 {
	height: 20px;
	margin: 0;
	padding-left: 10px;
	background: url("/img/tab2bottomgif.gif") repeat-x bottom;
	}
ul.tabs2, ul.tabs2 li {
	margin: 0;
	padding: 0;
	display: inline;
	list-style-type: none;
	}
ul.tabs2 a:link, ul.tabs2 a:visited, ul.tabs2 b {
	float: left;
	background: #f3f3f3;
	font-size: 10px;
	line-height: 14px;
	font-weight: bold;
	padding: 2px 10px 2px 10px;
	margin-right: 4px;
	border: 1px solid #ccc;
	text-decoration: none;
	color: #666;
	}
ul.tabs2 a:hover {
	background: #fff;
	}
ul.tabs2 li.tabs2selected b {
	border-bottom: 1px solid #fff;
	background: #fff;
	color: #000;
	}
'!

cssTabs3
	^'
/*WebTabs newClass: #tabs3 but dont forget to define here class tabs3selected too !! */

ul.tabs3 {
	border-top-width: 2px;
	border-right-width: 2px;
	border-bottom-width: 2px;
	border-left-width: 2px;
	border-bottom-style: solid;
	border-top-color: #CCCCCC;
	border-right-color: #CCCCCC;
	border-bottom-color: #CCCCCC;
	border-left-color: #CCCCCC;
}
ul.tabs3 li {
	background-color: #f0f0e7;
	background-repeat: repeat-x;
	padding: 0px;
	border-top: 2px solid #CCCCCC;
	border-right: 2px none #FFFFFF;
	border-bottom: 0px none #CCCCCC;
	border-left: 2px none #FFFFFF;
	background-position: left center;
	color: #000000;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: 60px;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
	vertical-align: baseline;
	}
ul.tabs3 a:link {
	background-color: #f0f0e7;
	background-repeat: repeat-x;
	padding: 4px;
	border-top: 0px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 0px none #FFFFFF;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #336699;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
}
ul.tabs3 a:visited {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 2px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 0px none #CCCCCC;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #336699;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 60px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
	vertical-align: baseline;
	list-style-image: url(back1.gif);
}
ul.tabs3 a:hover {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 2px solid #999999;
	border-right: 1px solid #CCCCCC;
	border-bottom: 2px none #FFFFFF;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #FF9900;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
}
ul.tabs3 li.tabs3selected {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 0px solid #CCCCCC;
	border-right: 0px none #FFFFFF;
	border-bottom: 2px solid #CCCCCC;
	border-left: 0px none #FFFFFF;
	background-position: left center;
	color: #FF9900;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
}
'!

cssTabs4
	^'
/*WebTabs newClass: #tabs4 but dont forget to define here class tabs4selected too !! */

ul.tabs4 {
	border-top-width: 1px;
	border-right-width: 1px;
	border-bottom-width: 1px;
	border-left-width: 1px;
	border-bottom-style: solid;
	border-top-color: #CCCCCC;
	border-right-color: #CCCCCC;
	border-bottom-color: #CCCCCC;
	border-left-color: #CCCCCC;
}
ul.tabs4 li {
	background-color: #f0f0e7;
	background-repeat: repeat-x;
	padding: 0px;
	border-top: 2px solid #CCCCCC;
	border-right: 2px none #FFFFFF;
	border-bottom: 0px none #CCCCCC;
	border-left: 2px none #FFFFFF;
	background-position: left center;
	color: #000000;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: 60px;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
	vertical-align: baseline;
}
ul.tabs4 a:link {
	background-color: #f0f0e7;
	background-repeat: repeat-x;
	padding: 4px;
	border-top: 0px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 0px none #FFFFFF;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #336699;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
}
ul.tabs4 a:visited {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 2px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 2px solid #CCCCCC;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #336699;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 60px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
	vertical-align: baseline;
	list-style-image: url(back1.gif);
}
ul.tabs4 a:hover {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 2px solid #CCCCCC;
	border-right: 1px solid #CCCCCC;
	border-bottom: 2px none #FFFFFF;
	border-left: 1px solid #CCCCCC;
	background-position: left center;
	color: #FF9900;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
	background-image: url(/img/tab3backgif.gif);
}
ul.tabs4 li.tabs4selected {
	background-color: #F0F0E7;
	background-repeat: repeat;
	padding: 4px;
	border-top: 0px solid #CCCCCC;
	border-right: 0px none #FFFFFF;
	border-bottom: 2px solid #CCCCCC;
	border-left: 0px none #FFFFFF;
	background-position: left center;
	color: #FF9900;
	display: inline;
	white-space: pre;
	text-align: center;
	font-family: Arial, Helvetica, sans-serif;
	font-size: 12px;
	letter-spacing: normal;
	word-spacing: normal;
	margin: 0px;
	clear: none;
	float: none;
	height: 70px;
	width: auto;
	text-decoration: none;
}
'!

cssTabs5
	^'
ul.tabs5 {
    float:left;
    width:600px;
    background:#DAE0D2 url("/img/tab5bggif.gif") repeat-x bottom;
    font-size:93%;
    line-height:normal;
    text-decoration: none;
    color: #333333;
    margin:0;
    padding:10px 10px 0;
    list-style:none;
    }
ul.tabs5 li {
    float:left;
    background:url("/img/tab5rightgif.gif") no-repeat right top;
    margin:0;
    padding:0 0 0 ;
    }
ul.tabs5 a, ul.tabs5 b {
   display:block;
   background:url("/img/tab5leftgif.gif") no-repeat left top;
   padding:5px 15px 4px 6px;
   text-decoration: none;
   color: #006699;
   font-family: Arial, Helvetica, sans-serif;
   font-weight: bold;
   font-size: 12px;
   }

/* Commented Backslash Hack
   hides rule from IE5-Mac \*/
ul.tabs5 a {float:none;}
/* End IE5-Mac hack */
ul.tabs5 a:hover {
  color:#333;
  }
ul.tabs5 li.tabs5selected {
  background-image:url("/img/tab5rightongif.gif");
  }
ul.tabs5 li.tabs5selected b {
  background-image:url("/img/tab5leftongif.gif");
  padding-bottom:5px;
  color: #666666;
  font-family: Arial, Helvetica, sans-serif;
  }
ul.tabs5 a:hover {
  color: #EFEFE6;
  }
'!

cutIconGif
	"'imgs/jure-cut.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 11 0 12 0 196 0 0 0 0 0 255 255 255 242 244 248 42 86 143 69 107 157 95 128 171 136 160 192 175 191 213 215 223 234 55 97 150 82 118 164 122 150 185 149 171 199 161 181 206 202 213 227 228 234 241 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 16 0 44 0 0 0 0 11 0 12 0 64 5 60 96 32 142 100 128 12 232 178 160 131 35 10 4 203 30 129 144 176 79 160 160 137 216 200 45 17 138 32 16 197 80 14 4 99 217 120 45 25 1 6 203 176 66 138 14 192 230 21 56 40 136 110 3 133 192 193 242 150 206 33 0 59 ]!

defaultPageTitle
	^'First page'!

delimiterColor
	^#grey!

docYellowPng
	"'imgs/suse/suse-doc.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 3 0 0 0 40 45 15 83 0 0 0 4 103 65 77 65 0 0 175 200 55 5 138 233 0 0 0 25 116 69 88 116 83 111 102 116 119 97 114 101 0 65 100 111 98 101 32 73 109 97 103 101 82 101 97 100 121 113 201 101 60 0 0 0 84 80 76 84 69 60 83 19 99 99 99 196 228 137 161 212 68 182 222 110 211 235 166 167 215 79 193 227 132 202 231 148 198 229 141 180 221 106 189 225 122 209 234 164 191 226 127 186 224 117 156 210 58 154 209 52 143 196 45 147 202 46 196 228 138 204 232 153 169 216 84 151 207 47 132 181 42 128 176 40 199 229 143 172 217 89 255 255 255 99 155 214 1 0 0 0 28 116 82 78 83 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 255 0 23 178 226 215 0 0 0 214 73 68 65 84 120 218 98 144 102 134 1 70 105 16 0 8 32 6 105 102 86 86 86 30 32 100 230 7 139 0 4 16 72 128 1 8 120 56 132 132 196 65 34 0 1 4 22 96 101 101 224 100 98 98 98 97 1 138 0 4 16 76 64 88 132 131 131 137 11 40 0 16 64 48 45 156 64 12 22 0 8 32 160 0 15 7 7 39 19 39 80 15 59 72 0 32 128 64 2 12 80 192 203 11 20 0 8 32 160 128 36 80 55 39 59 19 59 59 11 72 5 64 0 49 72 243 11 195 84 176 128 84 0 4 16 131 180 24 19 19 39 80 154 137 155 27 108 45 64 0 49 72 11 48 65 228 185 89 120 65 2 0 1 196 32 45 8 116 18 80 63 72 1 200 12 128 0 2 9 128 180 179 240 241 241 129 5 0 2 136 65 90 66 74 148 13 10 4 128 2 0 1 196 32 45 205 136 4 164 165 1 2 12 0 95 63 9 245 228 242 236 115 0 0 0 0 73 69 78 68 174 66 96 130 ]!

emailJpg
	"'imgs/toledo-email.jpg' asFilename contentsAsMethod"
^#[255 216 255 224 0 16 74 70 73 70 0 1 1 1 0 72 0 72 0 0 255 219 0 67 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 219 0 67 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 192 0 17 8 0 14 0 22 3 1 34 0 2 17 1 3 17 1 255 196 0 31 0 0 1 5 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 2 3 4 5 6 7 8 9 10 11 255 196 0 181 16 0 2 1 3 3 2 4 3 5 5 4 4 0 0 1 125 1 2 3 0 4 17 5 18 33 49 65 6 19 81 97 7 34 113 20 50 129 145 161 8 35 66 177 193 21 82 209 240 36 51 98 114 130 9 10 22 23 24 25 26 37 38 39 40 41 42 52 53 54 55 56 57 58 67 68 69 70 71 72 73 74 83 84 85 86 87 88 89 90 99 100 101 102 103 104 105 106 115 116 117 118 119 120 121 122 131 132 133 134 135 136 137 138 146 147 148 149 150 151 152 153 154 162 163 164 165 166 167 168 169 170 178 179 180 181 182 183 184 185 186 194 195 196 197 198 199 200 201 202 210 211 212 213 214 215 216 217 218 225 226 227 228 229 230 231 232 233 234 241 242 243 244 245 246 247 248 249 250 255 196 0 31 1 0 3 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 2 3 4 5 6 7 8 9 10 11 255 196 0 181 17 0 2 1 2 4 4 3 4 7 5 4 4 0 1 2 119 0 1 2 3 17 4 5 33 49 6 18 65 81 7 97 113 19 34 50 129 8 20 66 145 161 177 193 9 35 51 82 240 21 98 114 209 10 22 36 52 225 37 241 23 24 25 26 38 39 40 41 42 53 54 55 56 57 58 67 68 69 70 71 72 73 74 83 84 85 86 87 88 89 90 99 100 101 102 103 104 105 106 115 116 117 118 119 120 121 122 130 131 132 133 134 135 136 137 138 146 147 148 149 150 151 152 153 154 162 163 164 165 166 167 168 169 170 178 179 180 181 182 183 184 185 186 194 195 196 197 198 199 200 201 202 210 211 212 213 214 215 216 217 218 226 227 228 229 230 231 232 233 234 242 243 244 245 246 247 248 249 250 255 218 0 12 3 1 0 2 17 3 17 0 63 0 254 213 30 211 196 102 79 17 248 239 84 190 241 127 140 124 60 124 77 227 155 93 71 195 126 29 241 103 140 124 61 226 93 2 203 195 62 43 214 124 51 167 63 131 180 207 12 120 143 68 208 60 65 167 91 233 90 37 140 247 222 28 185 210 237 188 87 121 121 54 185 172 216 248 147 196 186 149 198 147 224 217 124 143 197 255 0 26 62 20 91 121 182 190 13 241 199 140 188 83 174 147 115 28 30 22 240 215 197 31 31 106 62 36 51 90 222 71 97 113 13 230 155 125 227 24 63 177 69 189 204 233 246 155 191 17 75 164 105 246 112 44 183 151 119 73 105 11 200 223 22 254 210 255 0 240 80 207 134 191 2 254 50 124 71 253 156 126 42 248 103 226 13 246 139 224 221 126 243 91 212 173 252 7 99 160 106 182 30 62 63 18 89 254 37 105 218 111 136 175 53 191 21 248 78 238 195 195 90 70 141 227 29 58 207 91 240 205 165 141 244 126 44 213 160 184 179 213 53 111 248 68 226 190 209 124 79 243 39 196 15 248 42 151 192 31 29 216 221 105 183 190 11 248 195 37 149 211 70 236 146 232 190 16 183 154 41 109 231 142 238 210 234 210 234 215 226 31 159 99 168 217 94 91 218 222 88 234 86 143 21 229 141 229 188 55 118 50 219 77 111 3 39 101 8 115 43 201 90 246 106 214 178 139 73 197 91 85 170 215 68 154 91 251 199 93 42 112 122 206 221 58 54 186 93 53 102 157 189 45 109 53 110 231 234 7 236 223 241 31 226 149 255 0 237 41 103 224 207 19 248 222 239 84 240 207 136 62 11 124 80 241 101 207 132 62 221 168 107 250 94 147 172 248 59 199 159 5 116 175 14 222 90 248 135 196 242 95 248 146 239 81 131 77 241 247 137 236 117 59 187 41 252 59 161 107 144 201 166 207 47 132 109 46 244 203 107 201 10 249 103 254 9 129 241 57 191 104 159 142 190 55 248 139 162 45 228 126 27 248 61 240 171 87 240 13 245 207 137 162 181 211 188 83 174 95 124 98 241 119 129 252 65 225 203 193 165 232 242 234 218 49 26 109 167 193 95 19 65 226 59 229 213 180 245 158 247 80 209 46 52 189 18 56 47 53 8 52 146 176 196 90 53 90 140 82 86 142 137 36 175 104 173 180 232 215 225 231 108 107 242 123 89 114 43 71 221 73 90 218 168 171 233 167 91 179 255 217 ]!

emailSmall1Gif
	"'imgs/intelicom-email.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 15 0 11 0 194 0 0 0 0 0 255 255 255 204 204 204 204 0 0 102 51 204 153 153 153 153 0 102 0 0 0 33 249 4 1 0 0 7 0 44 0 0 0 0 15 0 11 0 0 3 42 8 186 220 16 48 74 40 84 16 56 227 65 70 125 66 81 104 2 97 16 223 69 110 93 138 137 48 105 173 235 28 194 163 102 211 217 206 23 142 224 34 1 0 59 ]!

emailSmall2Gif
	"'imgs/jta-email.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 13 0 14 0 128 0 0 255 255 255 42 42 161 33 249 4 0 0 0 0 0 44 0 0 0 0 13 0 14 0 0 2 31 132 143 23 203 237 137 24 8 112 78 106 163 89 170 111 124 133 223 70 102 28 168 73 213 229 180 220 10 199 114 1 0 59 ]!

emailSmall3Gif
	"'imgs/las-email.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 15 0 11 0 162 255 0 255 255 255 204 204 204 192 192 192 51 102 153 0 51 102 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 2 0 44 0 0 0 0 15 0 11 0 64 3 45 40 186 220 66 36 200 57 161 138 97 128 189 49 185 26 39 2 214 35 69 90 228 93 80 235 182 236 43 95 217 216 5 159 41 133 100 69 99 184 10 142 70 41 14 19 0 59 ]!

ensureJavascriptAndCssForCalendarInHeader
	| page url headerValue |
	page := self app.
	url := '/jscalendar/calendar.js'.
	headerValue := ' src="', url, '" language="JavaScript" type="text/javascript"'.
	(page headers contains: [:each | each key = 'script' and: [each value = headerValue] ]) ifFalse: 
		[page addLinkToScreenStyleSheet: '/jscalendar/calendar.css'.
		page addHeader: 'script' value: headerValue.
		page addLinkToJavascript: '/jscalendar/calendar-lang.js'.
		page addLinkToJavascript: '/jscalendar/calendar-setup.js'.
		].!

ensureJavascriptForScriptaculousInHeader
	| page url headerValue |
	page := self app.
	url := '/scriptaculous/scriptaculous.js'.
	headerValue := ' src="', url, '" language="JavaScript" type="text/javascript"'.
	(page headers contains: [:each | each key = 'script' and: [each value = headerValue] ]) ifFalse: 
		[page addHeader: 'script' value: headerValue].!

ensureJsResourceForCalendarSetup
	self site urlResolver halfUrlFor: self calendarJsResource.
	self site urlResolver halfUrlFor: self calendarSetupJsResource. 
	self site urlResolver halfUrlFor: self calendarLangJsResource.
	self site urlResolver halfUrlFor: self calendarCSSResource.!

ensureJsResourceForScriptaculous
	self site urlResolver halfUrlFor: self scriptaculousJsResource.
	self site urlResolver halfUrlFor: self scriptaculousBuilderJsResource.
	self site urlResolver halfUrlFor: self scriptaculousEffectsJsResource.
	self site urlResolver halfUrlFor: self scriptaculousDragDropJsResource.
	self site urlResolver halfUrlFor: self scriptaculousControlsJsResource.
	self site urlResolver halfUrlFor: self scriptaculousSliderJsResource.!

eranovaHeaderGif
	"'imgs/head-en.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 88 2 100 0 179 0 0 255 255 255 231 231 237 223 223 223 204 204 204 180 180 180 161 159 183 153 153 153 116 131 158 153 102 102 111 111 111 100 108 144 57 93 121 69 69 92 24 83 125 51 51 51 15 15 15 33 249 4 4 20 0 255 0 44 0 0 0 0 88 2 100 0 0 4 255 16 200 73 171 189 56 235 205 187 255 96 40 142 100 105 158 104 170 174 108 235 190 112 44 207 116 109 223 120 174 239 124 239 255 192 160 112 72 44 26 143 200 164 114 201 108 58 159 208 168 116 74 173 90 175 216 172 118 203 237 122 191 224 176 120 76 46 155 207 232 52 53 192 86 187 217 112 183 124 78 199 193 219 117 242 61 144 239 251 255 35 123 120 128 92 130 124 91 123 132 138 139 37 134 140 90 142 136 119 143 148 149 26 137 150 87 130 146 152 153 158 148 157 159 82 161 88 145 162 52 164 167 71 131 170 163 172 144 169 173 45 177 178 181 182 97 180 183 39 166 186 189 190 89 113 191 43 188 194 197 198 199 104 155 200 203 204 205 156 175 206 209 99 135 94 208 210 36 193 215 218 107 212 23 214 77 223 18 225 219 228 229 184 2 2 214 227 74 232 232 221 19 233 230 242 243 231 2 3 247 239 235 73 1 3 246 248 20 1 4 208 27 72 16 146 191 127 19 222 69 65 119 175 31 181 128 5 35 74 28 213 112 192 67 133 11 43 82 139 55 177 163 199 125 1 255 57 2 208 183 36 164 187 67 34 63 170 92 249 35 17 73 38 108 210 181 121 201 178 166 205 89 0 49 114 131 167 243 166 207 159 47 122 106 18 8 180 168 209 97 185 166 40 59 202 180 105 135 152 73 161 152 156 228 180 170 51 126 21 179 54 60 132 85 171 69 161 226 218 45 189 84 145 40 133 131 102 19 10 32 80 160 45 129 148 0 14 14 176 208 181 95 5 172 39 169 90 221 43 44 128 1 4 128 3 11 14 76 64 2 129 4 136 19 43 78 96 96 46 6 67 196 42 8 88 64 121 129 130 180 0 14 84 62 208 77 128 230 6 160 67 31 112 44 225 64 232 5 239 10 132 110 112 0 160 88 200 96 249 202 206 20 96 176 109 194 134 23 235 70 76 218 53 236 92 3 42 83 46 156 80 51 229 214 19 10 44 88 205 188 65 129 228 171 49 43 88 77 154 159 204 188 119 224 206 222 158 76 175 135 1 183 111 59 54 176 123 119 190 56 144 219 105 55 44 124 1 231 132 10 42 63 151 160 124 121 115 234 244 241 195 91 173 128 43 58 9 215 169 199 144 255 69 220 21 216 157 119 28 128 23 222 96 115 249 165 152 1 16 146 183 88 111 1 113 5 155 88 24 212 39 92 117 241 13 39 65 112 149 53 96 217 1 159 133 214 31 0 3 232 151 95 104 196 133 36 78 118 1 182 3 12 130 6 214 24 153 6 10 2 70 128 87 255 212 150 24 1 217 73 136 24 113 97 241 81 225 111 21 94 96 156 112 243 197 181 225 72 37 54 160 0 129 252 76 199 98 92 171 53 25 128 149 160 25 105 143 151 175 201 100 210 122 81 68 85 163 108 99 113 64 128 96 96 129 247 99 5 3 40 70 100 146 80 33 233 206 93 75 86 118 34 138 194 9 4 98 101 189 161 184 90 107 1 216 231 220 126 161 205 151 151 128 98 198 164 158 38 105 158 89 160 153 21 172 25 88 155 138 5 42 128 156 240 8 132 36 28 7 229 211 97 123 196 17 32 28 31 26 46 208 36 124 38 178 193 37 114 0 168 22 154 167 118 141 217 232 29 26 89 113 163 164 219 101 227 129 95 130 17 32 236 176 194 146 118 88 98 152 29 203 91 145 159 134 148 85 255 103 194 45 137 156 134 253 5 144 103 160 165 157 198 135 105 160 41 32 206 171 0 198 248 26 168 247 236 216 16 164 52 242 170 46 7 192 46 8 152 1 19 40 155 128 185 229 62 232 165 145 144 221 195 208 107 4 78 240 231 148 29 94 22 235 102 35 141 186 103 5 220 138 136 106 171 130 134 214 96 60 160 138 41 151 190 237 244 203 141 175 235 78 113 207 46 216 214 81 155 187 58 78 32 100 121 137 57 150 100 66 112 52 116 171 163 105 153 74 89 127 26 62 183 228 115 147 17 172 164 182 0 16 128 179 172 82 242 145 87 88 3 58 180 199 190 232 102 92 69 112 12 36 141 25 8 5 48 64 72 142 238 182 56 114 121 64 162 60 18 156 66 27 242 104 114 155 241 211 245 204 78 218 108 65 194 168 53 12 90 58 92 62 231 98 55 120 29 153 93 69 70 203 64 41 21 229 198 102 129 2 222 2 160 0 114 118 249 235 88 58 4 218 67 159 211 29 203 1 53 177 136 155 76 178 189 47 98 132 157 32 234 81 35 45 148 149 17 48 106 97 53 31 231 13 255 151 39 10 16 93 138 179 142 100 141 67 39 137 37 87 220 49 204 45 69 185 16 18 233 65 211 7 84 173 55 222 222 22 26 159 183 241 49 112 0 237 168 193 30 159 31 150 2 6 150 0 8 36 102 192 176 83 183 168 206 111 114 113 5 118 206 155 61 185 165 158 10 129 14 26 114 133 58 156 176 162 235 29 41 113 197 91 161 238 194 174 86 12 32 172 144 34 20 160 64 210 194 50 192 6 3 64 206 117 128 211 191 19 224 126 0 64 54 141 34 3 133 167 17 60 2 152 122 83 188 30 84 36 12 172 140 92 42 251 150 124 0 52 170 62 149 134 122 120 202 210 183 18 197 165 191 117 239 43 48 146 203 91 196 55 139 72 97 97 0 16 74 64 210 18 16 130 141 101 134 1 77 163 221 91 104 71 63 111 233 47 57 132 227 95 30 218 133 0 3 128 69 94 20 18 18 188 70 242 21 111 64 78 61 230 219 17 3 43 55 129 60 189 236 16 169 90 85 172 86 179 0 179 36 236 85 40 113 200 5 196 165 193 182 44 141 131 187 80 29 20 14 147 52 248 255 133 32 62 247 192 219 0 100 8 36 188 157 112 118 251 235 199 2 6 160 191 49 246 239 12 52 68 0 226 136 229 24 121 189 67 135 70 218 81 56 134 86 46 2 64 200 49 127 90 163 191 218 227 158 67 4 82 85 112 80 206 160 40 192 51 21 9 160 0 82 244 97 72 248 33 172 2 144 232 0 87 196 98 35 210 5 9 33 138 192 51 73 19 152 114 24 224 45 151 205 15 141 3 211 93 172 98 248 70 51 64 45 106 18 24 217 29 141 119 136 97 97 80 33 123 48 95 132 12 64 20 151 81 198 44 211 139 86 113 8 25 31 230 8 12 58 198 124 72 91 32 217 168 156 128 138 45 187 179 140 221 52 249 1 140 81 147 6 255 115 87 131 240 88 1 110 162 200 143 199 203 74 163 26 114 190 16 242 146 61 71 100 100 123 86 37 128 6 222 71 144 20 176 94 162 224 180 187 216 245 145 116 12 25 150 37 59 244 158 107 250 115 10 217 92 80 131 138 135 152 29 82 192 155 248 139 80 226 178 130 60 115 10 139 15 6 232 90 60 73 5 167 81 53 103 255 74 22 240 28 115 48 19 0 229 236 173 45 7 112 11 57 161 185 187 128 21 64 118 255 76 105 19 192 185 203 150 70 200 72 187 116 93 110 10 250 16 63 26 239 120 115 100 41 121 254 40 147 2 36 0 111 6 21 71 73 197 152 81 245 25 202 50 5 184 98 48 41 163 68 0 25 81 1 110 97 11 72 73 52 170 216 145 73 165 88 29 66 179 6 145 10 82 240 67 135 173 67 92 76 139 101 33 107 230 162 46 22 147 164 53 197 97 84 17 141 136 68 203 28 234 37 33 57 205 172 218 117 26 186 116 169 66 201 138 144 37 60 114 159 150 193 219 37 225 186 35 127 212 245 174 204 48 97 92 50 249 33 147 245 237 24 108 8 98 177 40 118 145 39 164 108 153 244 138 228 90 17 187 141 245 177 47 86 207 105 203 5 62 59 191 188 113 246 180 242 192 74 9 154 182 173 5 44 86 0 186 51 18 105 72 249 28 218 1 168 95 115 73 43 106 119 235 11 252 33 175 149 24 24 163 2 54 56 187 20 182 111 125 115 65 161 183 148 27 43 188 201 48 148 94 255 84 69 95 211 170 219 167 20 14 127 140 29 129 76 193 1 92 222 50 129 88 17 34 193 0 60 219 26 51 162 80 111 173 81 31 0 248 199 63 168 150 114 36 231 85 165 102 78 49 128 7 56 192 1 15 32 33 0 28 224 186 4 0 119 83 20 32 128 3 48 112 223 160 150 96 192 251 141 193 188 94 32 96 239 94 193 166 34 100 128 126 67 176 150 193 141 119 185 207 33 165 109 219 11 85 245 170 111 126 25 14 173 211 62 17 128 7 236 48 0 14 128 23 127 31 235 183 179 84 173 193 241 66 112 92 136 244 128 22 195 227 111 165 50 11 66 106 12 16 148 206 152 46 62 238 241 33 248 43 14 31 111 12 127 92 9 242 89 238 33 227 34 99 132 184 14 214 42 98 238 43 195 244 193 111 0 243 219 18 134 209 184 49 254 41 135 141 83 226 31 108 51 140 59 211 102 194 0 35 254 80 141 239 139 95 18 18 57 1 108 150 64 2 236 251 0 1 60 32 191 49 6 0 156 241 235 52 252 174 249 206 8 190 115 126 239 59 104 252 22 134 205 15 64 177 255 125 1 80 99 2 208 185 48 123 126 64 154 81 244 104 196 72 128 1 141 169 244 157 41 109 232 253 18 58 210 252 120 244 5 230 28 231 120 137 26 30 116 158 112 148 133 16 68 19 104 134 148 133 49 227 252 86 248 89 254 141 177 185 122 211 48 153 127 41 10 75 83 96 205 36 44 49 138 219 119 105 32 37 90 207 194 106 114 131 225 60 18 30 55 26 193 41 102 180 64 152 93 226 185 32 6 192 251 45 140 179 179 157 179 26 83 155 199 114 38 225 91 236 220 236 0 88 122 131 68 118 64 110 7 236 0 113 31 155 191 231 94 154 176 245 220 100 34 59 154 2 150 46 113 118 87 237 135 243 170 194 215 226 88 51 113 248 11 111 65 231 23 198 134 81 246 128 125 189 109 95 91 154 199 12 15 55 0 208 220 233 109 131 219 219 250 5 119 92 238 156 0 129 240 23 205 27 207 175 199 181 109 112 110 195 152 191 118 22 185 5 96 140 112 70 79 64 227 68 230 54 191 41 225 239 83 216 153 26 32 143 185 186 63 174 95 63 33 120 45 45 95 118 198 37 255 80 99 242 72 28 226 67 215 51 99 86 76 100 139 27 9 227 68 207 201 24 157 102 0 7 120 49 178 73 227 246 177 227 98 114 104 3 137 31 89 135 19 130 91 126 236 18 83 32 186 49 159 185 218 49 0 103 97 205 217 227 240 102 247 91 76 236 232 67 207 171 221 2 54 139 208 163 238 114 59 67 168 206 46 87 58 223 11 90 112 109 207 197 219 240 147 176 224 3 47 103 248 49 28 226 142 119 51 188 68 120 24 185 231 204 235 148 183 116 90 241 126 223 197 234 57 241 36 252 79 213 15 83 99 126 172 253 244 221 28 33 81 24 35 97 62 216 251 179 113 129 115 176 21 255 33 18 66 72 2 208 54 12 236 17 124 251 4 79 220 134 178 95 176 8 19 108 238 118 67 116 135 77 46 126 2 14 225 107 229 67 212 1 233 144 61 31 252 139 34 253 250 215 249 200 6 136 8 141 126 123 236 247 190 234 29 175 126 128 115 74 254 242 155 255 252 232 79 191 250 215 207 254 246 187 255 253 240 143 191 252 231 79 255 250 219 255 254 248 71 156 17 210 254 133 255 18 111 87 5 141 129 122 2 184 3 139 22 6 118 166 106 45 240 127 3 184 128 12 216 128 14 248 128 16 24 129 18 152 7 44 214 65 255 113 1 21 56 129 26 88 52 106 178 0 161 244 58 77 101 1 88 86 26 23 118 1 41 180 129 40 168 43 35 37 20 1 160 74 147 193 55 164 145 91 62 19 91 113 97 49 181 130 55 2 225 90 102 52 23 255 161 101 68 145 129 41 24 132 72 96 46 224 164 128 186 7 15 5 99 91 194 133 92 198 165 62 200 53 25 183 227 50 73 85 102 235 229 92 39 197 84 193 17 31 176 34 132 92 104 4 231 131 24 180 151 33 147 150 25 121 179 55 110 180 94 33 150 51 240 181 79 63 102 70 4 80 94 91 102 70 114 216 26 176 101 132 93 120 135 59 0 66 123 230 62 26 96 63 72 84 130 179 115 134 241 21 90 123 163 92 102 38 107 177 22 135 84 232 111 53 135 135 142 232 3 248 179 96 28 96 25 108 132 66 202 129 14 170 34 136 33 230 70 99 166 28 57 211 31 114 200 7 230 85 91 84 232 134 85 246 250 136 168 200 4 237 148 52 243 49 63 231 165 137 39 164 62 186 118 66 94 100 63 102 132 70 231 37 135 222 178 138 209 149 138 190 248 139 192 24 140 194 56 140 196 88 140 198 120 140 200 152 140 202 184 140 204 88 11 52 33 25 68 97 122 205 56 141 68 128 21 195 34 2 183 248 66 218 192 73 212 248 19 59 242 133 118 120 1 217 56 98 252 128 18 145 245 33 55 102 11 30 212 141 62 241 133 34 132 128 28 128 55 109 177 62 57 67 74 94 196 59 188 147 25 150 81 54 173 64 62 236 200 18 122 216 69 135 165 55 129 181 62 45 88 24 126 104 70 172 53 70 246 19 107 91 40 10 254 248 143 43 225 23 16 50 144 168 212 52 103 232 70 10 25 67 41 36 143 178 176 142 18 121 38 227 8 0 238 161 143 104 212 70 236 245 28 80 166 10 90 20 146 123 49 146 227 69 74 2 177 145 105 100 57 50 121 11 22 233 146 58 185 147 60 217 147 62 249 147 64 25 148 66 57 148 68 89 148 70 121 148 72 153 148 74 185 148 230 16 1 0 59 ]!

eranovaLogoGif
	"'imgs/color-slo-small.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 161 0 40 0 135 0 0 35 38 39 39 42 44 39 44 46 42 44 45 41 45 48 41 48 51 45 50 53 46 53 57 48 52 54 49 54 57 49 57 61 54 60 63 54 61 65 56 63 67 57 65 69 61 68 71 56 67 72 60 68 73 61 71 76 61 72 78 62 76 84 65 70 73 64 74 78 66 76 81 65 78 85 68 77 82 66 80 87 70 80 85 67 81 88 69 82 89 74 83 87 72 83 89 73 85 90 74 86 92 76 86 92 74 88 95 77 88 93 75 92 101 76 90 97 78 92 99 77 93 101 77 95 105 80 92 99 81 94 101 80 96 104 82 101 110 85 98 105 85 100 107 86 101 109 88 100 107 89 103 110 93 104 110 85 103 113 86 104 114 87 106 116 88 104 112 88 107 117 91 109 117 94 105 112 92 108 116 89 109 120 93 111 120 93 113 122 93 114 125 95 117 127 96 110 117 101 112 118 96 112 120 97 115 124 97 116 126 100 115 122 101 118 126 105 117 124 118 118 118 119 119 120 118 120 122 121 122 123 98 119 129 100 118 128 100 120 130 101 121 132 102 124 134 106 121 129 106 123 132 104 124 134 104 126 138 108 127 136 119 126 129 123 126 128 103 128 141 106 128 139 105 129 141 108 130 141 106 132 145 109 133 145 109 135 149 111 137 151 119 128 132 124 129 131 124 133 137 126 136 142 113 134 145 113 137 149 113 138 152 114 140 154 114 142 156 117 141 153 116 142 156 125 140 147 126 142 152 118 144 157 122 145 156 126 144 153 125 146 157 117 146 161 119 149 164 120 146 160 121 148 162 121 150 165 124 147 160 126 148 160 124 150 164 124 152 166 122 153 169 124 154 169 125 156 171 126 157 173 126 159 176 127 160 176 190 157 92 163 157 127 182 155 101 182 156 106 188 158 97 186 158 104 181 159 112 174 160 118 173 162 125 187 162 109 189 161 105 191 163 108 189 164 110 179 161 117 179 163 123 186 164 116 186 168 125 218 155 54 216 156 59 223 160 60 236 153 26 254 152 0 252 155 11 245 155 19 242 156 25 251 157 17 226 153 39 228 156 44 238 158 38 229 158 49 241 158 32 255 161 23 253 162 27 236 160 43 229 160 52 226 161 59 232 161 50 232 164 58 243 161 38 242 162 41 250 163 34 240 164 48 212 159 70 206 160 79 198 160 91 204 161 86 202 163 91 201 163 93 204 163 89 206 164 90 205 165 94 214 160 71 212 161 76 219 161 68 217 162 73 218 164 75 217 164 77 211 164 84 208 164 89 217 166 81 217 168 86 216 169 92 195 162 98 194 165 108 198 168 109 203 168 102 192 166 114 194 168 115 205 175 118 210 172 105 225 164 67 130 132 133 128 134 137 129 137 140 136 139 141 129 140 147 132 144 150 130 147 155 138 146 150 136 147 152 142 159 155 146 159 153 159 159 146 129 150 161 129 153 165 133 152 162 132 154 165 129 154 168 129 156 170 129 158 173 132 156 169 132 158 172 138 155 164 136 157 168 128 159 176 143 160 158 147 161 156 152 160 147 153 162 152 155 164 154 157 165 153 130 160 174 133 160 170 132 161 174 141 162 165 138 162 171 129 160 176 132 162 177 137 163 176 138 166 180 142 168 178 146 164 164 162 156 132 163 160 133 164 162 138 171 161 129 169 163 132 172 163 128 170 166 139 172 168 142 163 165 146 169 168 144 178 165 129 178 169 138 180 176 151 166 175 166 171 175 161 33 249 4 3 0 0 128 0 44 0 0 0 0 161 0 40 0 0 8 255 0 1 9 28 56 80 93 34 93 158 64 89 90 200 16 148 167 88 195 126 117 98 72 177 34 67 95 2 195 237 58 37 239 15 193 116 144 106 113 74 5 42 212 169 81 186 18 169 251 227 81 224 31 107 212 98 202 140 185 141 229 53 102 98 144 137 73 102 141 160 79 64 127 252 80 35 147 19 25 178 43 202 218 112 107 57 144 221 204 153 126 6 254 121 42 147 219 207 106 108 146 93 49 122 148 12 28 109 76 127 226 163 116 201 162 89 75 154 92 69 18 117 182 98 32 64 138 202 90 18 212 18 222 173 182 11 47 197 58 55 80 91 146 191 128 1 179 201 150 44 48 224 49 97 93 102 35 163 196 176 225 100 217 8 110 115 252 183 218 64 107 148 149 44 21 232 167 25 22 202 129 201 104 251 73 206 20 222 182 154 130 193 58 109 169 81 35 138 130 4 218 195 196 122 97 39 112 2 241 128 78 194 134 201 110 103 62 255 56 107 188 27 48 147 56 3 117 83 222 12 136 25 101 49 30 95 126 46 14 248 74 228 129 246 228 214 54 139 139 216 105 99 218 231 254 255 217 23 158 117 39 190 206 65 251 222 141 88 42 25 234 134 153 100 99 25 39 115 84 64 235 166 27 118 198 18 14 124 195 100 12 132 200 118 167 173 242 11 94 154 84 36 136 58 9 18 184 208 47 127 136 241 31 101 203 248 17 93 27 19 6 198 140 71 221 80 134 133 57 2 93 147 25 136 212 100 24 152 64 249 56 120 218 48 164 16 40 200 107 102 221 178 72 37 103 117 98 14 113 148 53 3 7 142 134 93 49 16 54 60 26 7 7 27 234 173 3 136 51 148 49 193 18 32 68 58 166 204 31 218 172 103 24 22 113 140 177 27 32 230 124 82 91 38 149 148 103 209 37 247 120 121 150 32 45 126 233 13 32 143 180 133 25 104 108 176 132 12 104 1 10 84 24 101 112 0 226 87 102 124 48 73 89 50 45 233 23 152 53 127 96 72 89 77 122 92 9 12 107 164 132 195 206 31 240 224 114 218 46 181 108 39 72 38 102 129 194 14 32 227 180 53 205 110 212 252 193 206 110 205 176 164 77 144 127 41 49 218 100 160 245 241 71 147 134 133 193 18 55 73 70 255 229 39 96 88 120 84 205 149 90 226 149 73 58 4 161 51 17 106 250 72 74 155 69 161 24 25 78 91 241 20 9 8 54 187 225 33 144 127 207 121 132 100 146 139 66 67 25 51 2 77 11 224 31 204 82 70 134 71 245 101 150 226 105 178 252 116 32 94 251 228 122 218 62 13 86 84 73 70 109 209 3 26 98 83 237 86 19 32 111 122 203 18 171 83 122 148 158 97 109 254 49 167 97 150 105 107 88 157 128 52 3 154 24 231 226 133 200 79 145 156 230 10 43 8 170 34 73 62 98 190 11 72 57 109 61 2 218 134 205 129 134 197 55 128 124 10 26 127 128 72 168 47 32 86 58 86 231 141 142 213 10 200 123 131 10 164 178 99 100 148 137 23 45 133 244 236 115 46 167 149 226 200 89 154 60 130 142 71 239 180 75 145 198 13 91 116 8 104 157 254 145 175 99 99 132 184 219 53 118 146 250 87 27 2 181 108 24 30 47 81 198 6 80 55 7 166 132 71 37 130 6 71 42 42 110 135 201 60 103 221 179 164 64 224 68 99 247 221 209 128 51 207 40 120 17 255 2 218 82 235 104 157 4 215 128 8 234 152 18 70 162 74 89 53 30 45 67 217 29 33 59 86 211 31 124 84 110 185 229 212 36 35 120 18 213 136 217 246 151 255 152 133 201 162 63 125 180 8 42 172 13 146 164 71 138 59 6 232 31 94 27 6 29 32 208 58 38 31 217 148 157 243 205 172 73 136 81 58 80 217 176 193 187 99 230 124 190 157 56 102 169 242 59 126 243 216 226 185 69 134 236 217 223 110 163 253 33 165 97 27 254 65 179 99 208 177 116 61 96 218 220 234 24 127 76 65 9 71 217 197 213 106 124 109 200 91 68 74 98 2 221 195 150 131 209 59 70 248 246 253 2 2 43 212 2 13 159 68 156 127 88 130 237 180 161 48 195 104 70 42 216 32 195 247 168 243 164 231 173 111 33 237 171 136 36 230 38 144 117 244 162 45 182 104 75 253 8 198 18 244 1 70 25 2 73 27 101 34 99 142 223 8 132 29 188 99 194 58 6 6 152 100 88 8 63 205 16 92 1 41 195 181 80 176 166 18 155 200 161 14 119 200 67 29 114 34 83 22 153 196 79 255 134 118 22 71 28 235 44 134 32 149 57 254 176 142 221 32 236 95 241 49 146 8 29 195 184 63 124 99 129 88 200 6 169 128 3 148 218 25 144 26 226 163 12 214 60 193 154 123 44 239 140 227 170 136 16 125 194 55 179 204 2 16 71 52 203 34 98 102 171 221 88 6 118 11 203 22 104 148 0 34 64 244 129 50 202 240 226 95 150 0 22 44 45 48 9 74 216 70 225 246 120 52 93 176 38 17 247 57 227 79 236 97 150 53 18 100 88 22 129 7 32 164 209 150 57 110 107 145 160 49 146 245 64 19 42 60 70 75 32 127 164 26 254 254 242 36 129 24 14 96 44 89 37 96 102 71 201 211 252 2 98 163 200 165 46 119 57 10 96 180 162 146 62 113 135 210 24 162 137 149 196 209 34 158 12 12 194 100 249 151 217 181 206 48 212 232 223 199 90 114 39 195 196 208 49 209 148 19 104 176 129 59 111 69 165 29 14 180 132 40 22 197 20 157 157 101 17 156 0 38 65 146 102 150 80 92 234 152 21 73 38 96 176 246 7 255 197 105 138 134 137 76 53 169 56 255 144 118 80 102 106 198 153 219 33 149 4 8 116 8 142 139 128 184 203 105 130 49 55 72 176 134 31 103 177 164 64 216 105 145 84 188 179 147 60 66 92 65 77 120 36 145 69 5 159 128 81 66 36 195 104 54 199 100 15 16 207 60 12 218 118 195 205 140 132 211 18 157 168 69 45 126 133 151 99 200 34 162 62 161 104 69 64 129 142 77 182 133 17 178 11 225 110 174 195 175 192 204 174 168 45 156 219 29 38 100 25 129 132 203 164 30 153 97 20 9 242 203 7 82 228 18 236 194 41 65 132 121 22 120 252 33 141 22 1 106 104 252 165 44 150 129 6 26 29 4 13 227 146 243 31 153 9 4 138 202 236 38 247 194 130 14 50 90 117 33 192 56 70 91 38 145 24 76 86 228 24 136 144 196 79 247 211 181 133 45 9 174 180 122 3 98 255 210 158 129 116 8 62 32 19 72 24 22 166 216 221 124 43 44 233 72 167 85 93 33 12 188 72 84 32 243 107 155 88 1 19 153 122 126 108 32 6 155 80 22 41 40 72 208 220 75 178 38 10 76 54 125 162 142 85 255 172 239 18 195 232 172 103 205 101 188 209 38 129 160 251 163 140 179 4 18 37 19 97 161 169 4 65 170 99 194 224 147 216 153 232 58 165 171 199 41 84 116 9 91 232 131 18 172 249 44 32 224 225 215 138 152 130 109 102 241 237 24 62 106 47 169 164 182 56 98 152 79 98 94 121 178 176 156 55 164 82 13 12 65 151 135 142 121 228 162 187 95 18 5 48 248 193 139 151 90 66 187 128 200 135 186 40 82 10 117 128 55 172 129 9 152 114 147 128 133 66 186 4 15 135 12 12 22 156 97 164 210 89 171 56 74 128 110 5 153 137 5 107 176 55 169 146 60 33 57 232 177 136 87 244 34 23 189 136 69 33 30 161 15 127 244 163 24 39 230 133 140 103 76 99 26 15 131 130 5 121 196 49 50 161 9 76 144 2 18 32 130 196 34 134 76 228 33 231 195 25 72 118 198 117 174 145 228 38 59 99 182 4 17 10 51 146 129 133 37 88 121 39 109 184 6 201 150 199 100 39 59 249 117 63 185 6 81 150 192 132 49 56 227 27 127 240 134 151 145 124 13 248 133 248 255 205 112 14 177 59 220 28 231 58 19 132 37 120 182 179 158 93 146 231 61 251 249 207 128 14 180 160 7 77 232 66 27 250 208 62 241 66 9 126 16 20 40 12 196 209 3 73 131 27 232 44 201 52 156 225 140 118 240 194 239 206 224 134 42 32 250 211 160 254 201 19 50 96 7 22 216 192 11 35 168 176 28 74 6 20 12 184 65 32 62 216 67 5 103 61 144 42 156 129 137 2 49 129 26 8 82 225 10 211 0 10 158 106 9 57 231 208 7 57 80 58 212 200 254 243 31 14 16 149 46 80 64 3 27 200 192 23 124 144 5 24 196 192 3 127 88 64 20 76 80 134 0 148 97 2 72 120 128 30 118 224 2 11 176 196 13 3 152 194 13 92 176 129 111 32 96 7 14 232 195 5 140 80 129 62 160 224 5 25 248 67 4 248 176 129 25 188 128 223 51 80 128 30 56 112 6 20 80 97 5 18 152 67 178 23 30 232 60 64 64 32 44 120 66 3 252 224 132 30 56 192 11 5 72 65 2 212 48 128 19 252 193 12 29 224 131 2 254 96 129 50 8 32 5 5 255 200 19 31 34 176 6 2 164 192 0 102 184 0 32 22 64 7 9 0 66 2 92 0 193 31 46 128 135 8 156 192 11 127 96 0 10 170 176 142 4 112 161 4 37 224 2 0 82 160 0 48 48 252 233 123 214 195 200 211 112 128 53 48 128 228 111 112 0 13 136 112 13 42 152 32 10 13 248 195 9 182 240 132 26 248 33 2 78 24 2 54 166 224 145 31 180 160 8 68 168 134 21 80 224 133 60 76 160 5 79 176 131 4 122 80 132 62 52 160 7 57 216 183 23 58 96 129 57 60 129 5 27 64 195 3 186 16 130 118 72 1 234 144 183 51 15 46 16 130 57 112 65 6 36 0 66 19 108 160 7 16 132 160 14 65 248 6 17 220 0 5 25 28 65 15 117 120 2 31 68 16 2 52 8 228 11 36 176 131 8 64 128 134 33 248 65 13 92 216 65 31 206 16 133 61 124 128 4 104 56 2 31 204 240 129 21 236 65 11 42 48 0 29 132 96 247 63 140 0 4 91 136 188 244 253 108 134 7 240 225 216 160 238 195 3 116 96 130 63 204 193 1 95 88 94 2 64 0 0 59 ]!

excelBigGif
	"'imgs/excel_icon.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 34 0 32 0 135 0 0 0 0 0 0 128 0 128 128 128 192 192 192 192 220 192 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 3 0 0 4 0 44 0 0 0 0 34 0 32 0 0 8 255 0 9 8 28 72 176 160 193 131 8 13 10 88 200 176 161 67 134 9 15 10 40 64 177 162 197 139 5 4 0 136 88 112 34 198 143 20 23 110 84 24 64 64 201 147 38 83 158 4 41 96 128 70 131 40 99 170 76 57 160 102 205 138 19 93 142 28 104 18 164 197 158 31 61 234 36 88 178 0 74 156 69 139 6 173 56 84 96 207 153 25 87 154 180 73 85 39 128 171 88 5 38 53 58 51 105 75 139 3 192 50 29 9 52 0 215 163 81 195 50 21 75 113 192 72 165 70 207 122 228 90 181 238 88 167 102 207 202 53 59 149 109 219 187 4 188 174 60 90 82 237 223 181 109 201 242 141 169 119 106 93 170 128 5 171 60 91 216 111 1 195 110 241 6 69 217 23 241 225 203 111 231 250 44 252 216 38 224 174 168 79 26 190 12 50 115 224 212 168 87 51 189 153 56 225 220 199 151 105 155 174 141 240 54 219 221 187 65 219 246 204 58 183 93 222 18 103 87 53 222 150 182 240 222 196 213 2 119 238 58 249 231 226 211 49 239 84 168 188 244 241 234 220 125 138 23 71 30 126 188 79 240 29 189 171 167 186 189 32 214 247 240 227 203 231 72 159 126 64 0 59 ]!

excelSmallPng
	"'imgs/ikone-dok/corendal-excel.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 130 73 68 65 84 120 156 98 248 15 3 155 14 221 216 120 240 250 134 3 215 214 237 187 178 118 239 165 213 187 46 174 218 121 126 197 182 179 203 182 157 94 186 229 212 191 127 80 101 0 1 196 144 187 33 61 115 109 82 234 242 232 248 133 193 81 179 60 131 39 59 248 246 152 185 183 234 58 53 168 218 85 203 125 254 254 239 237 151 191 115 86 31 48 247 78 253 7 214 4 16 64 32 13 255 113 0 227 2 222 47 223 255 189 255 242 119 234 146 157 187 142 94 129 232 1 8 32 144 134 201 135 250 82 86 36 4 77 247 0 42 58 115 235 116 220 140 80 32 154 179 97 182 113 46 223 151 31 127 223 127 253 59 121 209 118 160 106 8 2 8 32 134 244 85 241 79 223 60 157 124 164 55 107 77 170 83 167 105 201 210 130 196 5 17 238 29 214 215 30 93 51 206 228 159 176 238 26 4 45 221 115 103 201 238 187 64 13 0 1 196 144 184 40 4 104 240 249 187 231 103 29 155 22 189 40 194 170 86 221 40 67 227 192 197 3 64 65 147 100 193 207 63 64 78 2 106 120 248 230 207 194 93 119 205 188 82 0 2 136 33 98 134 59 80 110 194 222 238 136 121 65 211 142 76 4 234 177 46 84 42 152 157 123 255 229 125 147 56 17 184 13 247 95 253 158 187 227 30 80 3 64 0 49 248 247 89 2 85 219 148 203 91 229 203 153 37 75 3 217 30 147 236 173 51 228 22 110 158 111 18 33 10 52 254 213 71 144 13 119 95 254 158 185 237 1 80 3 64 0 49 184 181 232 32 135 76 251 202 86 203 2 57 211 56 169 132 186 24 147 32 113 184 13 183 158 253 158 186 249 17 80 3 64 0 49 216 215 42 226 10 86 83 95 137 23 239 255 60 122 243 231 206 139 223 215 158 252 234 223 248 24 168 1 32 128 24 172 202 37 129 225 109 146 203 7 12 19 147 20 33 147 56 97 160 75 76 130 197 77 124 37 77 61 165 128 170 239 190 248 13 180 225 210 195 95 93 235 158 0 53 0 4 16 3 220 188 153 43 246 189 248 240 247 229 135 191 64 242 249 251 63 79 223 254 121 248 26 164 244 250 211 95 64 242 220 189 159 173 107 158 1 53 0 4 16 66 195 180 101 187 31 189 249 13 119 52 200 221 207 127 193 217 167 110 255 104 92 254 28 168 1 32 128 16 26 128 241 15 244 217 173 231 191 111 62 251 125 227 233 175 107 79 126 95 126 244 251 194 131 159 103 238 254 56 121 251 231 241 91 63 106 150 188 4 106 0 8 32 132 6 96 252 95 122 244 107 222 142 251 192 224 155 186 229 209 196 141 143 122 214 63 233 88 251 180 101 245 179 134 229 207 171 151 190 168 88 252 26 168 1 32 128 16 26 128 28 98 16 64 128 1 0 75 134 252 209 86 255 47 249 0 0 0 0 73 69 78 68 174 66 96 130 ]!

favicon
	"'imgs/favicon.ico' asFilename contentsAsMethod"
^#[0 0 1 0 2 0 16 16 0 0 0 0 0 0 104 5 0 0 38 0 0 0 16 16 0 0 0 0 0 0 104 3 0 0 142 5 0 0 40 0 0 0 16 0 0 0 32 0 0 0 1 0 8 0 0 0 0 0 64 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 255 0 0 0 0 0 153 204 255 0 102 153 204 0 191 191 191 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 255 255 255 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 4 4 4 4 4 1 1 1 1 1 1 2 2 1 3 3 1 1 4 4 4 4 1 1 1 2 2 2 2 1 3 3 3 3 1 4 4 4 1 1 2 2 2 2 2 1 3 3 3 3 3 1 4 1 1 1 2 2 2 2 2 1 3 3 3 3 3 1 1 1 1 1 2 2 2 2 2 1 3 3 3 3 3 1 1 1 1 1 2 2 2 2 2 1 3 3 3 3 3 1 1 1 1 1 2 2 2 2 2 1 3 3 3 3 3 1 1 1 1 1 2 2 2 1 1 2 1 1 3 3 3 1 1 1 1 1 2 1 1 2 2 2 2 2 1 1 3 1 1 1 1 1 1 2 2 2 2 2 2 2 2 2 1 1 1 1 1 1 1 1 1 2 2 2 2 2 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 255 19 156 248 1 16 160 224 0 19 92 192 0 16 160 128 1 19 100 128 3 16 160 128 3 19 108 128 3 16 160 128 3 19 116 128 3 16 160 128 3 19 124 192 7 16 160 224 15 19 132 248 63 16 160 255 255 19 140 255 255 16 160 40 0 0 0 16 0 0 0 32 0 0 0 1 0 24 0 0 0 0 0 64 3 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 191 191 191 191 191 191 191 191 191 191 191 191 191 191 191 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 0 0 0 0 0 0 191 191 191 191 191 191 191 191 191 191 191 191 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 191 191 191 191 191 191 191 191 191 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 191 191 191 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 102 153 204 102 153 204 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 0 0 0 0 0 0 153 204 255 0 0 0 0 0 0 102 153 204 102 153 204 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 0 0 0 102 153 204 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 153 204 255 153 204 255 153 204 255 153 204 255 153 204 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 255 19 156 248 1 16 160 224 0 19 92 192 0 16 160 128 1 19 100 128 3 16 160 128 3 19 108 128 3 16 160 128 3 19 116 128 3 16 160 128 3 19 124 192 7 16 160 224 15 19 132 248 63 16 160 255 255 19 140 255 255 16 160 ]!

folderYellowClosedPng
	"'imgs/suse/suse-folder_closed.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 3 0 0 0 40 45 15 83 0 0 0 129 80 76 84 69 255 255 255 204 153 51 203 152 50 201 150 48 199 148 46 255 255 255 194 143 41 255 255 153 189 138 36 186 135 33 183 132 30 181 130 28 179 128 26 176 125 23 255 247 145 255 244 142 174 123 21 102 102 102 255 235 133 255 230 128 197 146 44 192 141 39 188 137 35 184 133 31 180 129 27 255 224 122 163 112 10 255 212 110 248 197 95 160 109 7 255 204 102 239 188 86 158 107 5 230 179 77 156 105 3 191 140 38 220 169 67 154 103 1 211 160 58 153 102 0 171 120 18 168 117 15 165 114 12 116 56 156 204 0 0 0 1 116 82 78 83 0 64 230 216 102 0 0 0 1 98 75 71 68 0 136 5 29 72 0 0 0 9 112 72 89 115 0 0 14 194 0 0 14 194 1 21 40 74 128 0 0 0 7 116 73 77 69 7 210 9 10 13 46 39 87 90 186 133 0 0 0 135 73 68 65 84 120 156 101 207 235 14 130 48 12 5 224 110 48 10 58 145 194 16 1 153 136 92 212 247 127 64 55 50 146 37 251 254 245 164 73 79 1 2 140 241 40 246 103 97 37 126 128 134 72 179 211 89 94 108 192 243 171 181 239 21 100 130 168 172 212 174 190 53 119 41 1 226 86 137 67 37 58 2 213 51 60 60 112 32 72 52 199 220 121 226 72 80 107 133 165 243 194 137 32 213 111 108 157 25 23 130 76 55 216 59 43 110 230 176 233 83 124 190 191 110 24 167 101 35 219 132 124 225 175 129 63 253 91 11 53 214 159 30 119 0 0 0 0 73 69 78 68 174 66 96 130 ]!

folderYellowOpenedPng
	"'imgs/suse/suse-folder_opened.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 3 0 0 0 40 45 15 83 0 0 0 117 80 76 84 69 255 255 255 204 153 51 203 152 50 201 150 48 199 148 46 255 255 255 194 143 41 255 255 153 189 138 36 186 135 33 183 132 30 181 130 28 179 128 26 176 125 23 255 247 145 255 244 142 255 224 122 102 102 102 255 235 133 255 230 128 197 146 44 174 123 21 192 141 39 184 133 31 180 129 27 220 169 67 158 107 5 255 204 102 248 197 95 156 105 3 154 103 1 255 212 110 211 160 58 153 102 0 171 120 18 168 117 15 165 114 12 163 112 10 160 109 7 41 224 143 149 0 0 0 1 116 82 78 83 0 64 230 216 102 0 0 0 1 98 75 71 68 0 136 5 29 72 0 0 0 9 112 72 89 115 0 0 14 194 0 0 14 194 1 21 40 74 128 0 0 0 7 116 73 77 69 7 210 9 10 13 46 54 61 234 154 119 0 0 0 135 73 68 65 84 120 156 101 143 235 18 130 32 16 70 215 11 162 133 193 162 80 136 90 118 123 255 71 140 221 154 198 25 206 191 239 204 94 1 50 138 162 172 234 125 22 68 179 23 50 33 218 238 112 84 61 137 242 164 181 209 154 235 122 76 162 178 131 37 134 4 139 218 252 243 87 140 134 112 222 251 241 124 81 10 160 225 204 35 68 144 19 130 143 49 186 217 74 234 11 114 65 104 57 91 110 12 114 69 232 102 23 175 63 110 114 75 99 211 61 238 254 120 190 222 211 178 110 72 123 112 79 254 107 198 7 32 212 11 87 225 11 89 100 0 0 0 0 73 69 78 68 174 66 96 130 ]!

fontSizeText
	^'font size:'!

guestUserText
	^'Guest'!

headerBanner
	^WebElement newId: #banner!

headerColor
	^#ffff00!

headerDashboard
	"login, font size selection, etc"
	^(WebElement newId: #dashboard)
		add: self headerLogin;
		add: ((WebElement newId: #switcher)
			addHelpLink; addNbSp;
			addGif: #textFontSizeGif size: 54@15; 
			addLinkTo: '/' gif: #textSizeSmallGif title: 'Small font size' size: 16@15; 
			addLinkTo: '/' gif: #textSizeMediumGif title: 'Medium font size' size: 16@15; 
			addLinkTo: '/' gif: #textSizeLargeGif title: 'Large font size' size: 16@15; 
			yourself);
"		add: (WebElement new style: '{flow: right}'; addGif: #cornerDashboardRightGif; yourself);"
		yourself!

headerElement
	^(WebElement newId: #header)
		add: ((WebElement newId: #logo)
			addImage: '/img/eranovalogogif.gif' ); yourself!

headerLogin
	| e name |
	e := WebElement new.
	name := self app user isGuest 
		ifTrue: [self guestUserText] 
		ifFalse: [self app user name, ' ', self app user surname].
	e addNbSp: 3; addGif: #keyGif; addTextBold: ' ', name.
	self app user isGuest 
		ifTrue: [e addLinkTo: self site admin text: ' | ', self loginText view: 'login'] 
		ifFalse: [e addLinkTo: self site admin text: ' | ', self logoutText view: 'logout'].
	^e!

helpText
	^'Help'!

htmlHeaderElements
	self app addMetaDescription: 'Demo of AIDA/Web Smalltalk Web Application server'.
	self app addMetaKeywords: 'Smalltalk, Web, Web Server, Web Applications, HTML'.!

ieBigGif
	"'imgs/ie_icon.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 35 0 34 0 135 0 0 27 67 106 45 70 89 45 74 94 55 77 92 56 78 95 44 75 98 32 79 115 42 80 115 44 86 126 46 90 126 52 81 101 59 85 97 48 85 114 48 90 125 59 90 114 60 94 122 61 98 122 66 92 102 69 96 106 72 101 111 68 98 114 80 111 126 89 115 121 29 85 136 29 97 155 36 90 141 37 91 145 37 98 143 35 104 153 54 102 143 63 105 138 55 106 150 56 117 154 39 120 170 34 120 177 49 111 163 48 114 163 57 120 167 50 124 190 43 126 197 71 106 131 66 110 143 76 113 135 68 114 146 73 122 145 74 122 154 82 113 128 90 119 128 91 124 131 84 123 144 66 127 183 37 129 182 49 132 188 57 129 180 58 132 189 38 138 205 45 133 198 45 133 201 37 134 210 37 137 212 37 142 220 42 134 213 45 134 219 42 138 212 42 143 221 39 148 219 51 132 195 53 137 204 56 130 198 58 134 202 49 134 216 54 157 219 46 139 225 37 147 225 38 153 226 43 148 229 46 150 232 41 155 229 45 154 232 54 142 225 49 143 232 51 148 228 50 148 234 50 159 224 51 155 236 56 145 229 59 155 234 57 157 241 57 167 220 44 166 233 38 164 243 37 171 249 40 172 247 45 177 238 51 164 233 57 166 242 57 179 237 55 182 245 59 193 245 95 132 138 87 131 157 91 132 153 93 136 144 92 136 155 69 134 180 67 130 185 69 139 189 78 133 177 79 139 183 73 146 179 84 131 162 87 142 167 86 142 170 91 142 161 87 143 180 93 147 171 83 151 178 101 132 139 108 138 142 98 133 145 99 139 144 108 141 147 107 146 150 117 147 148 115 155 157 122 150 148 126 155 149 124 155 153 102 152 165 104 157 187 114 159 179 115 162 172 123 165 166 120 163 175 117 166 191 64 134 193 66 138 196 69 151 198 66 152 223 93 159 198 64 149 224 72 161 200 69 162 219 91 170 201 82 175 213 90 184 216 70 164 234 78 171 233 64 162 245 68 172 247 67 171 248 73 175 248 73 186 231 66 177 246 64 191 247 72 180 246 73 182 248 74 185 247 88 177 233 83 180 243 81 190 248 95 184 243 97 158 196 102 168 197 105 181 202 106 186 216 112 172 195 113 181 202 112 191 204 120 178 207 126 188 195 120 185 203 119 184 211 98 179 227 68 197 245 75 211 247 83 201 235 88 195 249 85 214 245 89 227 249 116 194 206 122 197 212 96 197 225 98 198 250 105 215 245 118 205 238 120 214 249 100 233 252 105 241 251 120 237 254 118 247 254 129 156 151 132 163 156 137 167 157 140 171 159 130 164 163 133 168 162 130 168 171 137 171 164 141 173 169 142 178 172 140 186 185 144 171 161 150 180 165 149 182 173 150 184 175 153 180 167 152 182 169 156 186 171 158 189 176 161 190 173 161 191 176 140 189 194 154 198 189 164 194 175 164 195 178 165 203 188 169 198 178 172 202 181 171 204 185 175 209 190 177 207 184 180 209 186 185 214 189 188 217 190 137 198 203 135 198 212 141 211 217 146 194 195 149 202 207 157 205 201 148 206 217 146 210 209 133 204 243 134 213 231 128 216 250 152 215 230 149 216 243 141 224 232 137 226 253 135 240 254 149 226 232 157 233 253 152 240 254 165 204 193 166 208 198 172 209 194 162 214 213 177 212 193 182 216 195 184 215 192 189 219 192 165 231 252 166 248 254 180 254 255 192 220 192 33 249 4 3 0 0 255 0 44 0 0 0 0 35 0 34 0 0 8 255 0 255 9 28 72 176 160 193 131 8 19 42 36 136 143 156 169 81 163 200 45 156 56 240 91 181 71 144 34 141 162 211 6 75 155 102 221 192 81 60 8 238 98 36 90 128 198 224 225 195 7 80 34 61 215 190 237 155 104 207 92 57 113 226 106 209 34 133 201 150 25 24 122 140 117 19 152 141 212 27 102 67 19 238 171 119 174 221 188 121 240 122 237 154 245 234 21 172 70 115 136 73 155 249 239 27 74 100 221 184 26 196 119 142 159 191 126 80 125 241 218 245 202 149 24 49 154 192 36 34 164 109 32 171 65 200 184 33 180 199 206 159 191 121 239 220 185 227 69 85 76 152 46 136 195 132 57 2 8 90 183 124 166 134 53 243 38 118 32 190 190 254 222 169 187 119 15 87 97 196 89 186 100 201 242 5 204 148 51 207 178 37 51 150 77 95 229 127 250 250 246 91 167 46 95 57 92 175 192 96 81 162 100 116 150 38 77 72 127 57 146 7 218 181 107 220 94 255 35 215 175 159 174 113 251 106 201 122 133 101 6 7 14 34 130 40 1 222 196 137 151 47 153 74 252 255 186 230 77 100 65 110 234 250 229 66 183 15 149 44 89 88 72 192 248 229 39 15 139 27 220 153 120 255 98 69 133 51 202 6 81 243 78 46 225 252 227 158 44 96 132 96 65 54 3 45 243 70 16 77 44 225 4 19 84 124 81 201 7 125 100 99 30 65 226 228 82 14 56 170 192 34 139 43 93 24 208 71 82 2 5 131 131 19 75 48 65 225 21 150 216 240 130 52 223 20 4 78 43 225 148 4 75 91 135 113 0 194 27 115 4 57 7 28 57 48 209 226 139 150 56 66 193 127 5 97 115 202 55 250 68 210 22 24 162 41 17 68 16 60 4 1 196 150 75 28 41 197 21 87 84 242 137 3 202 132 68 16 54 216 252 115 138 43 36 138 198 93 119 78 196 233 162 139 95 130 121 201 45 14 248 81 151 65 213 96 162 73 24 163 53 161 196 14 58 232 176 67 15 63 244 160 104 15 62 24 129 196 19 85 72 18 202 3 123 104 104 16 36 127 186 105 37 6 23 100 144 129 6 26 124 234 233 167 160 114 240 193 7 14 236 161 205 134 2 37 3 134 38 154 42 255 145 4 0 126 36 165 220 72 143 252 249 197 111 178 46 145 129 48 222 16 116 204 26 105 200 144 134 26 137 136 146 138 33 198 88 35 211 153 175 134 225 69 22 113 46 145 68 15 119 64 19 236 63 221 8 226 3 20 95 126 17 203 59 242 4 114 135 179 5 153 162 88 24 187 82 193 98 151 39 144 193 140 54 219 8 210 3 184 95 124 1 202 58 253 180 243 0 12 232 14 164 143 35 97 76 225 68 190 94 76 104 36 20 72 16 113 72 17 223 86 168 175 46 253 240 227 198 0 170 178 74 143 23 97 100 176 193 119 95 92 49 161 20 224 66 1 174 20 21 110 18 139 46 243 240 147 74 0 46 48 73 16 57 91 76 81 0 5 53 88 145 239 21 84 80 33 197 207 40 231 219 201 45 235 180 204 74 1 18 4 179 106 65 171 108 65 131 2 118 252 129 70 20 148 80 2 230 213 148 124 193 73 44 184 144 219 78 32 10 68 208 71 192 4 157 178 5 9 20 108 5 141 27 38 60 97 69 213 148 84 194 9 40 183 232 178 78 58 169 180 16 192 4 126 56 150 203 170 64 102 143 80 193 182 208 228 177 194 8 68 48 162 136 36 147 120 210 74 43 139 164 80 192 2 47 8 147 205 55 127 11 68 141 22 52 184 176 237 63 210 0 211 66 7 8 28 128 64 2 13 48 160 192 0 18 192 0 12 52 218 212 136 16 62 63 104 81 67 49 250 216 67 142 33 139 200 17 3 12 99 212 33 188 29 121 0 179 140 52 218 148 183 80 33 57 240 192 195 15 67 32 194 70 25 121 28 19 141 52 211 92 99 205 53 217 36 143 57 69 222 28 67 70 10 30 160 240 66 29 192 100 227 141 55 223 180 143 185 72 183 142 36 255 66 1 1 0 59 ]!

imageSmallPng
	"'imgs/ikone-dok/corendal-jpeg.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 149 73 68 65 84 120 156 98 248 15 6 237 43 239 160 161 142 213 247 90 22 95 3 50 94 127 252 249 31 9 0 4 16 3 92 195 127 84 240 239 223 255 159 127 64 226 229 91 94 165 148 246 174 218 176 251 193 227 231 63 126 254 2 8 32 236 26 32 170 191 252 250 239 178 236 59 16 57 77 126 80 215 62 253 224 209 115 111 222 125 4 8 32 132 134 95 191 126 161 169 126 251 237 255 153 171 32 180 106 243 215 250 206 45 211 231 173 186 126 243 62 64 0 33 52 252 248 241 227 255 252 138 239 185 166 255 75 205 255 247 187 253 95 19 250 255 96 226 163 143 255 239 188 251 127 237 245 255 93 39 191 20 86 117 29 58 118 22 32 128 16 26 190 125 251 246 191 61 108 103 130 225 255 114 203 255 211 60 255 111 141 250 127 119 230 255 243 101 127 87 133 76 92 123 110 239 217 207 9 25 149 219 119 31 6 8 32 132 134 207 159 191 108 183 50 202 55 209 216 100 42 124 194 90 230 170 147 252 171 72 173 119 177 58 183 61 149 218 231 30 223 117 230 115 84 114 201 150 29 7 0 2 8 161 225 221 135 79 15 38 198 205 138 54 90 144 164 243 166 217 244 115 143 249 247 125 169 95 187 205 95 181 219 119 172 60 183 253 228 39 136 6 128 0 130 106 104 94 116 245 229 155 15 215 23 214 111 175 13 78 118 214 187 61 33 252 217 204 144 111 87 170 190 223 174 191 57 57 161 121 229 149 173 39 160 26 0 2 8 170 161 113 206 249 39 47 223 29 154 51 117 87 71 85 132 163 203 246 230 130 203 243 75 158 30 107 122 123 170 230 224 132 218 154 229 183 54 30 253 8 209 0 16 64 80 13 181 83 79 220 127 246 102 205 244 53 253 181 75 115 50 119 44 107 155 242 248 72 211 175 231 109 255 159 53 108 157 62 185 116 233 189 245 135 63 64 52 0 4 16 84 67 85 255 161 219 143 94 205 152 116 168 171 113 219 132 198 245 147 155 214 172 154 48 251 230 174 182 39 7 234 230 246 172 40 89 241 108 245 65 168 6 128 0 130 106 40 235 216 125 245 254 139 139 47 254 174 187 244 109 229 133 111 75 206 126 91 112 250 219 156 147 223 166 31 255 54 249 200 183 165 23 255 174 216 255 30 162 1 32 128 160 26 138 155 182 94 188 253 236 226 139 255 103 158 253 63 250 232 255 193 7 255 119 223 253 191 237 214 255 141 55 254 175 186 242 127 233 165 255 75 247 190 139 78 41 221 186 243 32 64 0 65 53 228 215 172 155 187 246 230 172 21 215 102 44 187 60 125 201 165 153 11 207 76 159 119 114 218 156 99 83 103 30 153 60 237 96 247 196 109 221 125 59 210 11 234 119 237 61 10 16 64 80 13 103 206 95 233 155 178 32 45 191 14 104 12 208 106 52 4 20 4 74 1 21 0 149 1 4 24 0 49 85 52 237 131 13 12 50 0 0 0 0 73 69 78 68 174 66 96 130 ]!

infoBigGif
	"'imgs/info.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 35 0 34 0 135 0 0 1 1 61 1 1 73 9 27 70 13 30 74 1 18 80 3 30 88 1 1 100 1 8 101 1 11 110 1 12 125 1 25 127 14 35 81 19 38 77 20 41 83 25 45 84 27 49 87 28 50 88 20 52 110 27 54 100 31 56 112 33 52 90 37 56 93 35 59 98 33 60 106 40 63 103 35 64 110 43 67 102 45 66 101 38 68 115 41 76 124 51 69 100 50 71 105 55 73 102 57 77 109 50 75 117 54 81 127 62 83 121 68 86 111 67 90 121 76 99 126 82 100 122 1 28 131 1 28 139 1 33 141 5 45 129 1 39 146 1 43 151 1 43 154 3 49 143 1 48 156 25 63 137 1 48 163 11 63 166 29 68 141 27 74 170 27 79 189 28 81 190 44 74 132 32 72 147 50 80 133 62 95 135 61 100 149 63 98 155 41 94 204 44 96 204 64 99 142 75 101 135 66 99 155 89 108 129 82 110 149 95 112 131 93 117 141 78 109 162 87 125 167 99 119 137 103 123 138 105 124 138 97 118 150 96 127 163 87 128 172 93 138 185 109 128 142 110 132 147 113 133 147 124 142 150 100 136 172 106 129 167 97 138 180 104 140 177 102 145 190 109 146 185 113 138 180 114 144 179 112 149 190 123 155 188 79 134 223 82 133 227 100 135 201 106 141 193 117 150 201 116 154 192 123 149 192 120 151 200 124 154 201 111 161 214 121 160 198 113 161 212 115 170 223 125 168 215 128 146 154 136 154 159 137 155 160 128 153 177 128 159 191 136 156 189 143 161 164 132 162 191 145 162 165 150 168 170 155 173 171 150 174 180 170 175 189 165 182 178 174 191 183 173 190 184 133 157 199 131 157 200 130 163 196 129 165 206 132 169 202 139 170 196 139 172 203 129 168 218 138 175 212 140 178 211 148 173 194 146 174 204 153 174 194 153 174 212 147 177 205 154 176 195 154 178 203 146 180 212 147 182 216 150 184 219 152 182 211 158 185 213 155 187 216 146 188 227 162 183 204 166 185 202 171 187 195 169 187 201 163 189 212 178 191 205 177 195 188 178 196 188 180 197 188 158 193 229 156 196 236 157 193 241 173 195 195 167 192 214 172 197 219 180 195 205 185 195 205 187 204 194 177 196 213 176 198 222 180 201 223 184 198 211 188 201 214 163 196 229 164 198 232 170 198 226 170 199 232 172 201 231 163 203 244 165 207 249 167 209 253 172 210 250 180 204 227 180 207 235 184 206 228 188 210 229 178 212 245 176 212 248 182 216 241 180 217 252 185 215 246 185 216 245 187 221 253 189 226 255 195 205 215 193 209 197 198 216 206 201 218 203 197 210 210 192 210 218 202 211 221 210 214 220 210 216 221 220 222 222 198 217 235 203 220 238 196 218 243 194 222 250 220 222 224 207 224 208 208 224 207 208 225 208 212 228 209 215 231 212 214 233 223 219 235 214 223 239 217 196 226 254 202 228 254 205 232 255 212 227 228 221 227 235 223 236 229 219 234 236 210 226 242 209 230 253 211 234 254 218 230 243 221 233 244 219 237 254 211 243 255 220 241 255 223 249 255 224 240 217 226 242 220 227 244 221 230 246 221 231 248 223 228 228 226 225 229 233 230 232 235 232 231 231 236 237 237 227 235 243 225 239 255 230 246 226 227 242 254 227 250 255 234 245 254 236 250 255 240 240 238 245 245 243 241 246 251 243 251 254 249 248 246 253 254 254 0 0 0 33 249 4 3 0 0 236 0 44 0 0 0 0 35 0 34 0 0 8 255 0 217 9 28 72 176 160 193 131 8 19 178 163 183 205 93 188 135 249 30 202 243 54 44 154 66 133 197 144 233 219 232 175 163 199 126 253 252 241 187 100 241 34 193 110 238 64 246 227 231 177 84 30 125 30 249 133 28 105 82 224 54 120 249 96 122 244 71 2 0 128 2 33 61 238 219 231 111 149 169 139 219 218 189 35 186 243 88 128 20 42 12 108 217 41 82 30 63 102 124 18 38 93 26 147 165 188 3 49 190 204 80 36 242 30 75 127 251 228 221 27 181 231 96 53 101 238 152 242 219 199 175 174 191 62 54 192 132 41 123 175 47 203 123 227 238 193 57 90 240 216 51 121 29 231 210 197 119 86 36 223 123 245 34 179 28 55 110 217 148 130 213 144 113 187 135 246 30 62 207 68 207 242 235 107 47 242 188 211 230 248 225 251 102 174 201 29 130 198 146 113 171 219 183 54 62 43 19 114 236 136 64 64 14 191 122 243 204 145 27 94 15 31 184 111 163 148 148 100 87 234 216 184 207 145 33 123 238 195 34 129 138 21 8 202 240 19 62 156 92 184 112 246 192 45 255 195 21 34 171 192 82 193 196 65 54 61 79 50 63 29 45 98 164 240 195 207 187 247 239 225 204 125 195 133 139 194 156 129 165 172 242 205 61 168 205 67 142 57 230 212 195 15 18 41 200 119 6 62 247 129 19 14 56 18 102 115 11 46 16 184 49 16 41 2 34 216 221 112 249 225 51 68 131 41 60 24 142 54 218 128 131 162 54 225 56 115 203 45 15 104 40 144 37 170 48 195 221 125 223 145 99 207 136 242 153 97 207 137 217 100 163 77 144 218 52 83 139 43 49 14 148 137 38 198 128 131 227 132 223 157 195 99 10 62 14 153 13 54 87 94 105 11 42 143 100 56 80 40 152 156 210 204 119 43 170 24 206 57 62 144 56 198 57 87 98 227 166 155 189 184 50 74 17 14 212 49 16 52 162 96 146 74 54 42 90 41 164 57 105 202 55 134 57 111 2 99 232 47 175 100 226 200 5 32 152 39 208 33 150 88 82 11 54 67 186 41 164 148 41 184 160 128 24 246 96 3 204 47 191 96 195 203 43 146 76 146 196 0 75 72 67 144 53 116 36 82 73 45 206 96 255 233 166 54 190 200 16 3 13 46 212 176 139 167 191 0 51 106 36 139 144 177 128 7 119 168 83 80 40 130 28 210 136 43 190 184 89 14 32 7 188 112 3 16 63 224 0 3 33 162 234 194 138 35 139 164 145 129 3 83 44 71 16 30 94 48 210 136 36 172 228 2 140 46 160 240 34 75 44 177 0 51 139 44 186 180 2 201 34 139 116 193 1 3 70 152 178 206 65 235 216 81 69 178 136 68 50 73 186 188 248 98 232 186 158 56 130 200 32 129 60 209 64 3 68 108 98 44 66 233 232 113 4 22 116 8 34 72 32 129 12 98 136 39 180 196 2 201 195 127 92 193 193 2 21 68 209 201 197 9 173 35 12 21 66 240 224 132 23 94 196 17 199 32 159 124 82 136 22 65 116 32 0 5 40 212 65 76 77 2 89 211 9 21 68 152 128 129 8 92 240 28 11 32 18 48 224 1 17 111 8 99 13 210 171 90 99 141 41 37 140 80 8 37 179 176 81 1 19 124 16 131 14 215 9 17 227 65 22 148 196 162 198 6 175 177 125 17 31 26 64 17 11 26 22 216 30 97 183 73 166 156 160 198 26 22 252 247 183 73 82 244 176 129 157 135 155 164 71 27 156 52 46 185 65 1 1 0 59 ]!

initResources
	resources := Dictionary new!

isBrowserMSIE
	^self session isFromMSIE!

isBrowserNetscape
	^self session isFromNetscape!

javaBigGif
	"'imgs/sunjava-java_logo.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 38 0 66 0 196 31 0 254 35 13 52 71 158 255 145 134 154 163 207 205 210 231 254 49 28 255 228 226 254 76 59 254 115 101 103 117 182 255 173 165 255 242 241 255 201 195 230 233 243 255 214 210 243 244 249 254 90 74 254 63 43 128 140 195 192 198 225 116 129 188 77 94 170 254 132 119 255 187 180 167 175 213 179 186 219 90 106 176 255 159 150 218 221 237 141 152 201 65 83 164 255 255 255 33 249 4 1 0 0 31 0 44 0 0 0 0 38 0 66 0 0 5 255 224 39 142 100 105 138 203 169 174 236 136 180 112 252 33 151 108 159 136 112 239 227 161 243 55 3 96 3 188 65 0 142 162 108 3 128 40 99 10 0 242 217 18 72 21 212 213 2 33 125 161 20 8 98 214 113 144 90 68 6 75 1 145 202 50 10 87 145 160 80 168 101 63 81 64 33 185 40 31 12 119 31 14 112 123 31 125 0 7 109 119 17 82 118 22 122 138 89 66 136 40 93 129 34 14 82 63 12 150 151 31 112 155 82 5 128 151 86 94 159 157 129 11 116 109 86 82 98 129 153 94 11 140 122 158 120 0 118 131 82 183 120 5 109 143 17 189 120 94 86 118 74 13 25 3 20 24 36 12 34 7 167 35 29 9 21 1 20 15 43 15 25 26 1 18 28 42 2 88 43 18 1 26 42 13 30 1 222 224 42 15 4 4 202 20 9 18 13 36 214 4 42 3 214 235 253 254 255 21 40 12 104 71 162 91 62 22 240 148 13 88 184 48 3 60 123 43 26 172 203 214 162 193 0 32 15 186 93 108 49 193 27 139 6 4 6 80 20 145 49 192 198 22 24 250 255 85 72 192 178 101 183 126 30 154 125 152 224 33 1 65 24 19 36 240 251 183 142 30 134 118 29 58 64 4 2 18 30 129 155 119 8 72 24 70 130 67 0 15 29 6 24 77 56 32 1 133 131 200 118 242 244 183 244 198 131 9 11 39 136 200 64 65 235 186 128 24 134 146 24 89 130 0 5 111 19 216 142 40 42 247 68 7 172 35 50 172 235 144 133 67 135 10 106 69 188 237 151 96 0 134 135 238 140 98 88 150 192 28 134 108 19 240 126 8 41 33 129 186 173 152 3 172 28 48 193 222 182 4 231 90 188 131 183 152 225 66 163 67 27 128 109 236 225 228 138 9 212 36 152 142 172 112 225 188 151 53 165 238 0 9 214 180 239 195 146 153 10 47 162 0 130 147 225 174 134 127 72 142 156 23 10 6 208 73 25 128 78 194 1 3 82 11 160 95 255 96 192 1 41 57 188 12 148 145 98 6 215 20 17 154 196 147 239 114 1 192 15 240 0 12 173 17 32 224 72 174 73 103 184 55 250 148 163 126 156 18 204 145 176 138 123 31 248 33 66 123 0 124 55 2 159 40 38 4 72 194 17 58 48 145 224 114 0 8 99 2 132 13 58 103 0 2 112 144 167 67 38 67 20 8 128 23 27 214 162 73 134 241 237 18 129 5 2 48 242 3 35 16 44 176 159 1 112 172 216 34 129 0 242 194 197 113 31 96 248 193 35 0 68 81 128 8 92 28 48 130 143 36 36 119 68 126 34 134 162 199 136 34 28 113 74 25 239 141 144 28 23 5 40 160 192 120 239 117 8 192 51 51 92 177 229 137 57 166 232 101 1 84 186 32 133 133 130 156 153 102 9 101 28 103 192 6 226 44 48 221 119 211 109 55 194 156 117 222 89 66 30 85 222 34 161 145 194 57 16 65 160 183 132 0 0 59 ]!

javascript
	"concatenate all js* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new javascript"
	| stream |
	stream := WriteStream on: String new. 
	self allJavascriptMethods do: [:method | 
		stream nextPut: Character cr;   nextPut: Character lf.
		stream nextPutAll: ('/*', self class name, ' ', method asString, '*/'). 
		stream nextPut: Character cr;  nextPut: Character lf.
		stream nextPutAll: (self perform: method)].
		stream nextPut: Character cr;  nextPut: Character lf.
	^stream contents!

javascriptResource
	" /scripts.js , returns all js* methods (alphabetically sorted) concatenated "
	"WebStyle new javascriptResource"
	^self resources at: #javascript ifAbsentPut:
		[WebMethodResource 
			fromMethod: #javascript on: self 
			contentType: 'text/javascript' preferedUrl: '/scripts.js' site: self site].!

jsCommon
	"common javaScript methods"
	^'
function nic() 
	{}
function popUpPage(url, parameters, name)
{
}'!

jsPrototypeFramework
	^'
/*  Prototype JavaScript framework, version 1.4.0
 *  (c) 2005 Sam Stephenson <sam@conio.net>
 *
 *  THIS FILE IS AUTOMATICALLY GENERATED. When sending patches, please diff
 *  against the source tree, available from the Prototype darcs repository.
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *
 *  For details, see the Prototype web site: http://prototype.conio.net/
 *
/*--------------------------------------------------------------------------*/

var Prototype = {
  Version: ''1.4.0'',
  ScriptFragment: ''(?:<script.*?>)((\n|\r|.)*?)(?:<\/script>)'',

  emptyFunction: function() {},
  K: function(x) {return x}
}

var Class = {
  create: function() {
    return function() {
      this.initialize.apply(this, arguments);
    }
  }
}

var Abstract = new Object();

Object.extend = function(destination, source) {
  for (property in source) {
    destination[property] = source[property];
  }
  return destination;
}

Object.inspect = function(object) {
  try {
    if (object == undefined) return ''undefined'';
    if (object == null) return ''null'';
    return object.inspect ? object.inspect() : object.toString();
  } catch (e) {
    if (e instanceof RangeError) return ''...'';
    throw e;
  }
}

Function.prototype.bind = function() {
  var __method = this, args = $A(arguments), object = args.shift();
  return function() {
    return __method.apply(object, args.concat($A(arguments)));
  }
}

Function.prototype.bindAsEventListener = function(object) {
  var __method = this;
  return function(event) {
    return __method.call(object, event || window.event);
  }
}

Object.extend(Number.prototype, {
  toColorPart: function() {
    var digits = this.toString(16);
    if (this < 16) return ''0'' + digits;
    return digits;
  },

  succ: function() {
    return this + 1;
  },

  times: function(iterator) {
    $R(0, this, true).each(iterator);
    return this;
  }
});

var Try = {
  these: function() {
    var returnValue;

    for (var i = 0; i < arguments.length; i++) {
      var lambda = arguments[i];
      try {
        returnValue = lambda();
        break;
      } catch (e) {}
    }

    return returnValue;
  }
}

/*--------------------------------------------------------------------------*/

var PeriodicalExecuter = Class.create();
PeriodicalExecuter.prototype = {
  initialize: function(callback, frequency) {
    this.callback = callback;
    this.frequency = frequency;
    this.currentlyExecuting = false;

    this.registerCallback();
  },

  registerCallback: function() {
    setInterval(this.onTimerEvent.bind(this), this.frequency * 1000);
  },

  onTimerEvent: function() {
    if (!!this.currentlyExecuting) {
      try {
        this.currentlyExecuting = true;
        this.callback();
      } finally {
        this.currentlyExecuting = false;
      }
    }
  }
}

/*--------------------------------------------------------------------------*/

function $() {
  var elements = new Array();

  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    if (typeof element == ''string'')
      element = document.getElementById(element);

    if (arguments.length == 1)
      return element;

    elements.push(element);
  }

  return elements;
}
Object.extend(String.prototype, {
  stripTags: function() {
    return this.replace(/<\/?[^>]+>/gi, '''');
  },

  stripScripts: function() {
    return this.replace(new RegExp(Prototype.ScriptFragment, ''img''), '''');
  },

  extractScripts: function() {
    var matchAll = new RegExp(Prototype.ScriptFragment, ''img'');
    var matchOne = new RegExp(Prototype.ScriptFragment, ''im'');
    return (this.match(matchAll) || []).map(function(scriptTag) {
      return (scriptTag.match(matchOne) || ['''', ''''])[1];
    });
  },

  evalScripts: function() {
    return this.extractScripts().map(eval);
  },

  escapeHTML: function() {
    var div = document.createElement(''div'');
    var text = document.createTextNode(this);
    div.appendChild(text);
    return div.innerHTML;
  },

  unescapeHTML: function() {
    var div = document.createElement(''div'');
    div.innerHTML = this.stripTags();
    return div.childNodes[0] ? div.childNodes[0].nodeValue : '''';
  },

  toQueryParams: function() {
    var pairs = this.match(/^\??(.*)$/)[1].split(''&'');
    return pairs.inject({}, function(params, pairString) {
      var pair = pairString.split(''='');
      params[pair[0]] = pair[1];
      return params;
    });
  },

  toArray: function() {
    return this.split('''');
  },

  camelize: function() {
    var oStringList = this.split(''-'');
    if (oStringList.length == 1) return oStringList[0];

    var camelizedString = this.indexOf(''-'') == 0
      ? oStringList[0].charAt(0).toUpperCase() + oStringList[0].substring(1)
      : oStringList[0];

    for (var i = 1, len = oStringList.length; i < len; i++) {
      var s = oStringList[i];
      camelizedString += s.charAt(0).toUpperCase() + s.substring(1);
    }

    return camelizedString;
  },

  inspect: function() {
    return "''" + this.replace(''\\'', ''\\\\'').replace("''", ''\\\'''') + "''";
  }
});

String.prototype.parseQuery = String.prototype.toQueryParams;

var $break    = new Object();
var $continue = new Object();

var Enumerable = {
  each: function(iterator) {
    var index = 0;
    try {
      this._each(function(value) {
        try {
          iterator(value, index++);
        } catch (e) {
          if (e !!= $continue) throw e;
        }
      });
    } catch (e) {
      if (e !!= $break) throw e;
    }
  },

  all: function(iterator) {
    var result = true;
    this.each(function(value, index) {
      result = result && !!!!(iterator || Prototype.K)(value, index);
      if (!!result) throw $break;
    });
    return result;
  },

  any: function(iterator) {
    var result = true;
    this.each(function(value, index) {
      if (result = !!!!(iterator || Prototype.K)(value, index))
        throw $break;
    });
    return result;
  },

  collect: function(iterator) {
    var results = [];
    this.each(function(value, index) {
      results.push(iterator(value, index));
    });
    return results;
  },

  detect: function (iterator) {
    var result;
    this.each(function(value, index) {
      if (iterator(value, index)) {
        result = value;
        throw $break;
      }
    });
    return result;
  },

  findAll: function(iterator) {
    var results = [];
    this.each(function(value, index) {
      if (iterator(value, index))
        results.push(value);
    });
    return results;
  },

  grep: function(pattern, iterator) {
    var results = [];
    this.each(function(value, index) {
      var stringValue = value.toString();
      if (stringValue.match(pattern))
        results.push((iterator || Prototype.K)(value, index));
    })
    return results;
  },

  include: function(object) {
    var found = false;
    this.each(function(value) {
      if (value == object) {
        found = true;
        throw $break;
      }
    });
    return found;
  },

  inject: function(memo, iterator) {
    this.each(function(value, index) {
      memo = iterator(memo, value, index);
    });
    return memo;
  },

  invoke: function(method) {
    var args = $A(arguments).slice(1);
    return this.collect(function(value) {
      return value[method].apply(value, args);
    });
  },

  max: function(iterator) {
    var result;
    this.each(function(value, index) {
      value = (iterator || Prototype.K)(value, index);
      if (value >= (result || value))
        result = value;
    });
    return result;
  },

  min: function(iterator) {
    var result;
    this.each(function(value, index) {
      value = (iterator || Prototype.K)(value, index);
      if (value <= (result || value))
        result = value;
    });
    return result;
  },

  partition: function(iterator) {
    var trues = [], falses = [];
    this.each(function(value, index) {
      ((iterator || Prototype.K)(value, index) ?
        trues : falses).push(value);
    });
    return [trues, falses];
  },

  pluck: function(property) {
    var results = [];
    this.each(function(value, index) {
      results.push(value[property]);
    });
    return results;
  },

  reject: function(iterator) {
    var results = [];
    this.each(function(value, index) {
      if (!!iterator(value, index))
        results.push(value);
    });
    return results;
  },

  sortBy: function(iterator) {
    return this.collect(function(value, index) {
      return {value: value, criteria: iterator(value, index)};
    }).sort(function(left, right) {
      var a = left.criteria, b = right.criteria;
      return a < b ? -1 : a > b ? 1 : 0;
    }).pluck(''value'');
  },

  toArray: function() {
    return this.collect(Prototype.K);
  },

  zip: function() {
    var iterator = Prototype.K, args = $A(arguments);
    if (typeof args.last() == ''function'')
      iterator = args.pop();

    var collections = [this].concat(args).map($A);
    return this.map(function(value, index) {
      iterator(value = collections.pluck(index));
      return value;
    });
  },

  inspect: function() {
    return ''#<Enumerable:'' + this.toArray().inspect() + ''>'';
  }
}

Object.extend(Enumerable, {
  map:     Enumerable.collect,
  find:    Enumerable.detect,
  select:  Enumerable.findAll,
  member:  Enumerable.include,
  entries: Enumerable.toArray
});
var $A = Array.from = function(iterable) {
  if (!!iterable) return [];
  if (iterable.toArray) {
    return iterable.toArray();
  } else {
    var results = [];
    for (var i = 0; i < iterable.length; i++)
      results.push(iterable[i]);
    return results;
  }
}

Object.extend(Array.prototype, Enumerable);

Array.prototype._reverse = Array.prototype.reverse;

Object.extend(Array.prototype, {
  _each: function(iterator) {
    for (var i = 0; i < this.length; i++)
      iterator(this[i]);
  },

  clear: function() {
    this.length = 0;
    return this;
  },

  first: function() {
    return this[0];
  },

  last: function() {
    return this[this.length - 1];
  },

  compact: function() {
    return this.select(function(value) {
      return value !!= undefined || value !!= null;
    });
  },

  flatten: function() {
    return this.inject([], function(array, value) {
      return array.concat(value.constructor == Array ?
        value.flatten() : [value]);
    });
  },

  without: function() {
    var values = $A(arguments);
    return this.select(function(value) {
      return !!values.include(value);
    });
  },

  indexOf: function(object) {
    for (var i = 0; i < this.length; i++)
      if (this[i] == object) return i;
    return -1;
  },

  reverse: function(inline) {
    return (inline !!== false ? this : this.toArray())._reverse();
  },

  shift: function() {
    var result = this[0];
    for (var i = 0; i < this.length - 1; i++)
      this[i] = this[i + 1];
    this.length--;
    return result;
  },

  inspect: function() {
    return ''['' + this.map(Object.inspect).join('', '') + '']'';
  }
});
var Hash = {
  _each: function(iterator) {
    for (key in this) {
      var value = this[key];
      if (typeof value == ''function'') continue;

      var pair = [key, value];
      pair.key = key;
      pair.value = value;
      iterator(pair);
    }
  },

  keys: function() {
    return this.pluck(''key'');
  },

  values: function() {
    return this.pluck(''value'');
  },

  merge: function(hash) {
    return $H(hash).inject($H(this), function(mergedHash, pair) {
      mergedHash[pair.key] = pair.value;
      return mergedHash;
    });
  },

  toQueryString: function() {
    return this.map(function(pair) {
      return pair.map(encodeURIComponent).join(''='');
    }).join(''&'');
  },

  inspect: function() {
    return ''#<Hash:{'' + this.map(function(pair) {
      return pair.map(Object.inspect).join('': '');
    }).join('', '') + ''}>'';
  }
}

function $H(object) {
  var hash = Object.extend({}, object || {});
  Object.extend(hash, Enumerable);
  Object.extend(hash, Hash);
  return hash;
}
ObjectRange = Class.create();
Object.extend(ObjectRange.prototype, Enumerable);
Object.extend(ObjectRange.prototype, {
  initialize: function(start, end, exclusive) {
    this.start = start;
    this.end = end;
    this.exclusive = exclusive;
  },

  _each: function(iterator) {
    var value = this.start;
    do {
      iterator(value);
      value = value.succ();
    } while (this.include(value));
  },

  include: function(value) {
    if (value < this.start)
      return false;
    if (this.exclusive)
      return value < this.end;
    return value <= this.end;
  }
});

var $R = function(start, end, exclusive) {
  return new ObjectRange(start, end, exclusive);
}

var Ajax = {
  getTransport: function() {
    return Try.these(
      function() {return new ActiveXObject(''Msxml2.XMLHTTP'')},
      function() {return new ActiveXObject(''Microsoft.XMLHTTP'')},
      function() {return new XMLHttpRequest()}
    ) || false;
  },

  activeRequestCount: 0
}

Ajax.Responders = {
  responders: [],

  _each: function(iterator) {
    this.responders._each(iterator);
  },

  register: function(responderToAdd) {
    if (!!this.include(responderToAdd))
      this.responders.push(responderToAdd);
  },

  unregister: function(responderToRemove) {
    this.responders = this.responders.without(responderToRemove);
  },

  dispatch: function(callback, request, transport, json) {
    this.each(function(responder) {
      if (responder[callback] && typeof responder[callback] == ''function'') {
        try {
          responder[callback].apply(responder, [request, transport, json]);
        } catch (e) {}
      }
    });
  }
};

Object.extend(Ajax.Responders, Enumerable);

Ajax.Responders.register({
  onCreate: function() {
    Ajax.activeRequestCount++;
  },

  onComplete: function() {
    Ajax.activeRequestCount--;
  }
});

Ajax.Base = function() {};
Ajax.Base.prototype = {
  setOptions: function(options) {
    this.options = {
      method:       ''post'',
      asynchronous: true,
      parameters:   ''''
    }
    Object.extend(this.options, options || {});
  },

  responseIsSuccess: function() {
    return this.transport.status == undefined
        || this.transport.status == 0
        || (this.transport.status >= 200 && this.transport.status < 300);
  },

  responseIsFailure: function() {
    return !!this.responseIsSuccess();
  }
}

Ajax.Request = Class.create();
Ajax.Request.Events =
  [''Uninitialized'', ''Loading'', ''Loaded'', ''Interactive'', ''Complete''];

Ajax.Request.prototype = Object.extend(new Ajax.Base(), {
  initialize: function(url, options) {
    this.transport = Ajax.getTransport();
    this.setOptions(options);
    this.request(url);
  },

  request: function(url) {
    var parameters = this.options.parameters || '''';
    if (parameters.length > 0) parameters += ''&_='';

    try {
      this.url = url;
      if (this.options.method == ''get'' && parameters.length > 0)
        this.url += (this.url.match(/\?/) ? ''&'' : ''?'') + parameters;

      Ajax.Responders.dispatch(''onCreate'', this, this.transport);

      this.transport.open(this.options.method, this.url,
        this.options.asynchronous);

      if (this.options.asynchronous) {
        this.transport.onreadystatechange = this.onStateChange.bind(this);
        setTimeout((function() {this.respondToReadyState(1)}).bind(this), 10);
      }

      this.setRequestHeaders();

      var body = this.options.postBody ? this.options.postBody : parameters;
      this.transport.send(this.options.method == ''post'' ? body : null);

    } catch (e) {
      this.dispatchException(e);
    }
  },

  setRequestHeaders: function() {
    var requestHeaders =
      [''X-Requested-With'', ''XMLHttpRequest'',
       ''X-Prototype-Version'', Prototype.Version];

    if (this.options.method == ''post'') {
      requestHeaders.push(''Content-type'',
        ''application/x-www-form-urlencoded'');

      /* Force "Connection: close" for Mozilla browsers to work around
       * a bug where XMLHttpReqeuest sends an incorrect Content-length
       * header. See Mozilla Bugzilla #246651.
       */
      if (this.transport.overrideMimeType)
        requestHeaders.push(''Connection'', ''close'');
    }

    if (this.options.requestHeaders)
      requestHeaders.push.apply(requestHeaders, this.options.requestHeaders);

    for (var i = 0; i < requestHeaders.length; i += 2)
      this.transport.setRequestHeader(requestHeaders[i], requestHeaders[i+1]);
  },

  onStateChange: function() {
    var readyState = this.transport.readyState;
    if (readyState !!= 1)
      this.respondToReadyState(this.transport.readyState);
  },

  header: function(name) {
    try {
      return this.transport.getResponseHeader(name);
    } catch (e) {}
  },

  evalJSON: function() {
    try {
      return eval(this.header(''X-JSON''));
    } catch (e) {}
  },

  evalResponse: function() {
    try {
      return eval(this.transport.responseText);
    } catch (e) {
      this.dispatchException(e);
    }
  },

  respondToReadyState: function(readyState) {
    var event = Ajax.Request.Events[readyState];
    var transport = this.transport, json = this.evalJSON();

    if (event == ''Complete'') {
      try {
        (this.options[''on'' + this.transport.status]
         || this.options[''on'' + (this.responseIsSuccess() ? ''Success'' : ''Failure'')]
         || Prototype.emptyFunction)(transport, json);
      } catch (e) {
        this.dispatchException(e);
      }

      if ((this.header(''Content-type'') || '''').match(/^text\/javascript/i))
        this.evalResponse();
    }

    try {
      (this.options[''on'' + event] || Prototype.emptyFunction)(transport, json);
      Ajax.Responders.dispatch(''on'' + event, this, transport, json);
    } catch (e) {
      this.dispatchException(e);
    }

    /* Avoid memory leak in MSIE: clean up the oncomplete event handler */
    if (event == ''Complete'')
      this.transport.onreadystatechange = Prototype.emptyFunction;
  },

  dispatchException: function(exception) {
    (this.options.onException || Prototype.emptyFunction)(this, exception);
    Ajax.Responders.dispatch(''onException'', this, exception);
  }
});

Ajax.Updater = Class.create();

Object.extend(Object.extend(Ajax.Updater.prototype, Ajax.Request.prototype), {
  initialize: function(container, url, options) {
    this.containers = {
      success: container.success ? $(container.success) : $(container),
      failure: container.failure ? $(container.failure) :
        (container.success ? null : $(container))
    }

    this.transport = Ajax.getTransport();
    this.setOptions(options);

    var onComplete = this.options.onComplete || Prototype.emptyFunction;
    this.options.onComplete = (function(transport, object) {
      this.updateContent();
      onComplete(transport, object);
    }).bind(this);

    this.request(url);
  },

  updateContent: function() {
    var receiver = this.responseIsSuccess() ?
      this.containers.success : this.containers.failure;
    var response = this.transport.responseText;

    if (!!this.options.evalScripts)
      response = response.stripScripts();

    if (receiver) {
      if (this.options.insertion) {
        new this.options.insertion(receiver, response);
      } else {
        Element.update(receiver, response);
      }
    }

    if (this.responseIsSuccess()) {
      if (this.onComplete)
        setTimeout(this.onComplete.bind(this), 10);
    }
  }
});

Ajax.PeriodicalUpdater = Class.create();
Ajax.PeriodicalUpdater.prototype = Object.extend(new Ajax.Base(), {
  initialize: function(container, url, options) {
    this.setOptions(options);
    this.onComplete = this.options.onComplete;

    this.frequency = (this.options.frequency || 2);
    this.decay = (this.options.decay || 1);

    this.updater = {};
    this.container = container;
    this.url = url;

    this.start();
  },

  start: function() {
    this.options.onComplete = this.updateComplete.bind(this);
    this.onTimerEvent();
  },

  stop: function() {
    this.updater.onComplete = undefined;
    clearTimeout(this.timer);
    (this.onComplete || Prototype.emptyFunction).apply(this, arguments);
  },

  updateComplete: function(request) {
    if (this.options.decay) {
      this.decay = (request.responseText == this.lastText ?
        this.decay * this.options.decay : 1);

      this.lastText = request.responseText;
    }
    this.timer = setTimeout(this.onTimerEvent.bind(this),
      this.decay * this.frequency * 1000);
  },

  onTimerEvent: function() {
    this.updater = new Ajax.Updater(this.container, this.url, this.options);
  }
});
document.getElementsByClassName = function(className, parentElement) {
  var children = ($(parentElement) || document.body).getElementsByTagName(''*'');
  return $A(children).inject([], function(elements, child) {
    if (child.className.match(new RegExp("(^|\\s)" + className + "(\\s|$)")))
      elements.push(child);
    return elements;
  });
}

/*--------------------------------------------------------------------------*/

if (!!window.Element) {
  var Element = new Object();
}

Object.extend(Element, {
  visible: function(element) {
    return $(element).style.display !!= ''none'';
  },

  toggle: function() {
    for (var i = 0; i < arguments.length; i++) {
      var element = $(arguments[i]);
      Element[Element.visible(element) ? ''hide'' : ''show''](element);
    }
  },

  hide: function() {
    for (var i = 0; i < arguments.length; i++) {
      var element = $(arguments[i]);
      element.style.display = ''none'';
    }
  },

  show: function() {
    for (var i = 0; i < arguments.length; i++) {
      var element = $(arguments[i]);
      element.style.display = '''';
    }
  },

  remove: function(element) {
    element = $(element);
    element.parentNode.removeChild(element);
  },

  update: function(element, html) {
    $(element).innerHTML = html.stripScripts();
    setTimeout(function() {html.evalScripts()}, 10);
  },

  getHeight: function(element) {
    element = $(element);
    return element.offsetHeight;
  },

  classNames: function(element) {
    return new Element.ClassNames(element);
  },

  hasClassName: function(element, className) {
    if (!!(element = $(element))) return;
    return Element.classNames(element).include(className);
  },

  addClassName: function(element, className) {
    if (!!(element = $(element))) return;
    return Element.classNames(element).add(className);
  },

  removeClassName: function(element, className) {
    if (!!(element = $(element))) return;
    return Element.classNames(element).remove(className);
  },

  // removes whitespace-only text node children
  cleanWhitespace: function(element) {
    element = $(element);
    for (var i = 0; i < element.childNodes.length; i++) {
      var node = element.childNodes[i];
      if (node.nodeType == 3 && !!/\S/.test(node.nodeValue))
        Element.remove(node);
    }
  },

  empty: function(element) {
    return $(element).innerHTML.match(/^\s*$/);
  },

  scrollTo: function(element) {
    element = $(element);
    var x = element.x ? element.x : element.offsetLeft,
        y = element.y ? element.y : element.offsetTop;
    window.scrollTo(x, y);
  },

  getStyle: function(element, style) {
    element = $(element);
    var value = element.style[style.camelize()];
    if (!!value) {
      if (document.defaultView && document.defaultView.getComputedStyle) {
        var css = document.defaultView.getComputedStyle(element, null);
        value = css ? css.getPropertyValue(style) : null;
      } else if (element.currentStyle) {
        value = element.currentStyle[style.camelize()];
      }
    }

    if (window.opera && [''left'', ''top'', ''right'', ''bottom''].include(style))
      if (Element.getStyle(element, ''position'') == ''static'') value = ''auto'';

    return value == ''auto'' ? null : value;
  },

  setStyle: function(element, style) {
    element = $(element);
    for (name in style)
      element.style[name.camelize()] = style[name];
  },

  getDimensions: function(element) {
    element = $(element);
    if (Element.getStyle(element, ''display'') !!= ''none'')
      return {width: element.offsetWidth, height: element.offsetHeight};

    // All *Width and *Height properties give 0 on elements with display none,
    // so enable the element temporarily
    var els = element.style;
    var originalVisibility = els.visibility;
    var originalPosition = els.position;
    els.visibility = ''hidden'';
    els.position = ''absolute'';
    els.display = '''';
    var originalWidth = element.clientWidth;
    var originalHeight = element.clientHeight;
    els.display = ''none'';
    els.position = originalPosition;
    els.visibility = originalVisibility;
    return {width: originalWidth, height: originalHeight};
  },

  makePositioned: function(element) {
    element = $(element);
    var pos = Element.getStyle(element, ''position'');
    if (pos == ''static'' || !!pos) {
      element._madePositioned = true;
      element.style.position = ''relative'';
      // Opera returns the offset relative to the positioning context, when an
      // element is position relative but top and left have not been defined
      if (window.opera) {
        element.style.top = 0;
        element.style.left = 0;
      }
    }
  },

  undoPositioned: function(element) {
    element = $(element);
    if (element._madePositioned) {
      element._madePositioned = undefined;
      element.style.position =
        element.style.top =
        element.style.left =
        element.style.bottom =
        element.style.right = '''';
    }
  },

  makeClipping: function(element) {
    element = $(element);
    if (element._overflow) return;
    element._overflow = element.style.overflow;
    if ((Element.getStyle(element, ''overflow'') || ''visible'') !!= ''hidden'')
      element.style.overflow = ''hidden'';
  },

  undoClipping: function(element) {
    element = $(element);
    if (element._overflow) return;
    element.style.overflow = element._overflow;
    element._overflow = undefined;
  }
});

var Toggle = new Object();
Toggle.display = Element.toggle;

/*--------------------------------------------------------------------------*/

Abstract.Insertion = function(adjacency) {
  this.adjacency = adjacency;
}

Abstract.Insertion.prototype = {
  initialize: function(element, content) {
    this.element = $(element);
    this.content = content.stripScripts();

    if (this.adjacency && this.element.insertAdjacentHTML) {
      try {
        this.element.insertAdjacentHTML(this.adjacency, this.content);
      } catch (e) {
        if (this.element.tagName.toLowerCase() == ''tbody'') {
          this.insertContent(this.contentFromAnonymousTable());
        } else {
          throw e;
        }
      }
    } else {
      this.range = this.element.ownerDocument.createRange();
      if (this.initializeRange) this.initializeRange();
      this.insertContent([this.range.createContextualFragment(this.content)]);
    }

    setTimeout(function() {content.evalScripts()}, 10);
  },

  contentFromAnonymousTable: function() {
    var div = document.createElement(''div'');
    div.innerHTML = ''<table><tbody>'' + this.content + ''</tbody></table>'';
    return $A(div.childNodes[0].childNodes[0].childNodes);
  }
}

var Insertion = new Object();

Insertion.Before = Class.create();
Insertion.Before.prototype = Object.extend(new Abstract.Insertion(''beforeBegin''), {
  initializeRange: function() {
    this.range.setStartBefore(this.element);
  },

  insertContent: function(fragments) {
    fragments.each((function(fragment) {
      this.element.parentNode.insertBefore(fragment, this.element);
    }).bind(this));
  }
});

Insertion.Top = Class.create();
Insertion.Top.prototype = Object.extend(new Abstract.Insertion(''afterBegin''), {
  initializeRange: function() {
    this.range.selectNodeContents(this.element);
    this.range.collapse(true);
  },

  insertContent: function(fragments) {
    fragments.reverse(false).each((function(fragment) {
      this.element.insertBefore(fragment, this.element.firstChild);
    }).bind(this));
  }
});

Insertion.Bottom = Class.create();
Insertion.Bottom.prototype = Object.extend(new Abstract.Insertion(''beforeEnd''), {
  initializeRange: function() {
    this.range.selectNodeContents(this.element);
    this.range.collapse(this.element);
  },

  insertContent: function(fragments) {
    fragments.each((function(fragment) {
      this.element.appendChild(fragment);
    }).bind(this));
  }
});

Insertion.After = Class.create();
Insertion.After.prototype = Object.extend(new Abstract.Insertion(''afterEnd''), {
  initializeRange: function() {
    this.range.setStartAfter(this.element);
  },

  insertContent: function(fragments) {
    fragments.each((function(fragment) {
      this.element.parentNode.insertBefore(fragment,
        this.element.nextSibling);
    }).bind(this));
  }
});

/*--------------------------------------------------------------------------*/

Element.ClassNames = Class.create();
Element.ClassNames.prototype = {
  initialize: function(element) {
    this.element = $(element);
  },

  _each: function(iterator) {
    this.element.className.split(/\s+/).select(function(name) {
      return name.length > 0;
    })._each(iterator);
  },

  set: function(className) {
    this.element.className = className;
  },

  add: function(classNameToAdd) {
    if (this.include(classNameToAdd)) return;
    this.set(this.toArray().concat(classNameToAdd).join('' ''));
  },

  remove: function(classNameToRemove) {
    if (!!this.include(classNameToRemove)) return;
    this.set(this.select(function(className) {
      return className !!= classNameToRemove;
    }).join('' ''));
  },

  toString: function() {
    return this.toArray().join('' '');
  }
}

Object.extend(Element.ClassNames.prototype, Enumerable);
var Field = {
  clear: function() {
    for (var i = 0; i < arguments.length; i++)
      $(arguments[i]).value = '''';
  },

  focus: function(element) {
    $(element).focus();
  },

  present: function() {
    for (var i = 0; i < arguments.length; i++)
      if ($(arguments[i]).value == '''') return false;
    return true;
  },

  select: function(element) {
    $(element).select();
  },

  activate: function(element) {
    element = $(element);
    element.focus();
    if (element.select)
      element.select();
  }
}

/*--------------------------------------------------------------------------*/

var Form = {
  serialize: function(form) {
    var elements = Form.getElements($(form));
    var queryComponents = new Array();

    for (var i = 0; i < elements.length; i++) {
      var queryComponent = Form.Element.serialize(elements[i]);
      if (queryComponent)
        queryComponents.push(queryComponent);
    }

    return queryComponents.join(''&'');
  },

  getElements: function(form) {
    form = $(form);
    var elements = new Array();

    for (tagName in Form.Element.Serializers) {
      var tagElements = form.getElementsByTagName(tagName);
      for (var j = 0; j < tagElements.length; j++)
        elements.push(tagElements[j]);
    }
    return elements;
  },

  getInputs: function(form, typeName, name) {
    form = $(form);
    var inputs = form.getElementsByTagName(''input'');

    if (!!typeName && !!name)
      return inputs;

    var matchingInputs = new Array();
    for (var i = 0; i < inputs.length; i++) {
      var input = inputs[i];
      if ((typeName && input.type !!= typeName) ||
          (name && input.name !!= name))
        continue;
      matchingInputs.push(input);
    }

    return matchingInputs;
  },

  disable: function(form) {
    var elements = Form.getElements(form);
    for (var i = 0; i < elements.length; i++) {
      var element = elements[i];
      element.blur();
      element.disabled = ''true'';
    }
  },

  enable: function(form) {
    var elements = Form.getElements(form);
    for (var i = 0; i < elements.length; i++) {
      var element = elements[i];
      element.disabled = '''';
    }
  },

  findFirstElement: function(form) {
    return Form.getElements(form).find(function(element) {
      return element.type !!= ''hidden'' && !!element.disabled &&
        [''input'', ''select'', ''textarea''].include(element.tagName.toLowerCase());
    });
  },

  focusFirstElement: function(form) {
    Field.activate(Form.findFirstElement(form));
  },

  reset: function(form) {
    $(form).reset();
  }
}

Form.Element = {
  serialize: function(element) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    var parameter = Form.Element.Serializers[method](element);

    if (parameter) {
      var key = encodeURIComponent(parameter[0]);
      if (key.length == 0) return;

      if (parameter[1].constructor !!= Array)
        parameter[1] = [parameter[1]];

      return parameter[1].map(function(value) {
        return key + ''='' + encodeURIComponent(value);
      }).join(''&'');
    }
  },

  getValue: function(element) {
    element = $(element);
    var method = element.tagName.toLowerCase();
    var parameter = Form.Element.Serializers[method](element);

    if (parameter)
      return parameter[1];
  }
}

Form.Element.Serializers = {
  input: function(element) {
    switch (element.type.toLowerCase()) {
      case ''submit'':
      case ''hidden'':
      case ''password'':
      case ''text'':
        return Form.Element.Serializers.textarea(element);
      case ''checkbox'':
      case ''radio'':
        return Form.Element.Serializers.inputSelector(element);
    }
    return false;
  },

  inputSelector: function(element) {
    if (element.checked)
      return [element.name, element.value];
  },

  textarea: function(element) {
    return [element.name, element.value];
  },

  select: function(element) {
    return Form.Element.Serializers[element.type == ''select-one'' ?
      ''selectOne'' : ''selectMany''](element);
  },

  selectOne: function(element) {
    var value = '''', opt, index = element.selectedIndex;
    if (index >= 0) {
      opt = element.options[index];
      value = opt.value;
      if (!!value && !!(''value'' in opt))
        value = opt.text;
    }
    return [element.name, value];
  },

  selectMany: function(element) {
    var value = new Array();
    for (var i = 0; i < element.length; i++) {
      var opt = element.options[i];
      if (opt.selected) {
        var optValue = opt.value;
        if (!!optValue && !!(''value'' in opt))
          optValue = opt.text;
        value.push(optValue);
      }
    }
    return [element.name, value];
  }
}

/*--------------------------------------------------------------------------*/

var $F = Form.Element.getValue;

/*--------------------------------------------------------------------------*/

Abstract.TimedObserver = function() {}
Abstract.TimedObserver.prototype = {
  initialize: function(element, frequency, callback) {
    this.frequency = frequency;
    this.element   = $(element);
    this.callback  = callback;

    this.lastValue = this.getValue();
    this.registerCallback();
  },

  registerCallback: function() {
    setInterval(this.onTimerEvent.bind(this), this.frequency * 1000);
  },

  onTimerEvent: function() {
    var value = this.getValue();
    if (this.lastValue !!= value) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  }
}

Form.Element.Observer = Class.create();
Form.Element.Observer.prototype = Object.extend(new Abstract.TimedObserver(), {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.Observer = Class.create();
Form.Observer.prototype = Object.extend(new Abstract.TimedObserver(), {
  getValue: function() {
    return Form.serialize(this.element);
  }
});

/*--------------------------------------------------------------------------*/

Abstract.EventObserver = function() {}
Abstract.EventObserver.prototype = {
  initialize: function(element, callback) {
    this.element  = $(element);
    this.callback = callback;

    this.lastValue = this.getValue();
    if (this.element.tagName.toLowerCase() == ''form'')
      this.registerFormCallbacks();
    else
      this.registerCallback(this.element);
  },

  onElementEvent: function() {
    var value = this.getValue();
    if (this.lastValue !!= value) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  },

  registerFormCallbacks: function() {
    var elements = Form.getElements(this.element);
    for (var i = 0; i < elements.length; i++)
      this.registerCallback(elements[i]);
  },

  registerCallback: function(element) {
    if (element.type) {
      switch (element.type.toLowerCase()) {
        case ''checkbox'':
        case ''radio'':
          Event.observe(element, ''click'', this.onElementEvent.bind(this));
          break;
        case ''password'':
        case ''text'':
        case ''textarea'':
        case ''select-one'':
        case ''select-multiple'':
          Event.observe(element, ''change'', this.onElementEvent.bind(this));
          break;
      }
    }
  }
}

Form.Element.EventObserver = Class.create();
Form.Element.EventObserver.prototype = Object.extend(new Abstract.EventObserver(), {
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.EventObserver = Class.create();
Form.EventObserver.prototype = Object.extend(new Abstract.EventObserver(), {
  getValue: function() {
    return Form.serialize(this.element);
  }
});
if (!!window.Event) {
  var Event = new Object();
}

Object.extend(Event, {
  KEY_BACKSPACE: 8,
  KEY_TAB:       9,
  KEY_RETURN:   13,
  KEY_ESC:      27,
  KEY_LEFT:     37,
  KEY_UP:       38,
  KEY_RIGHT:    39,
  KEY_DOWN:     40,
  KEY_DELETE:   46,

  element: function(event) {
    return event.target || event.srcElement;
  },

  isLeftClick: function(event) {
    return (((event.which) && (event.which == 1)) ||
            ((event.button) && (event.button == 1)));
  },

  pointerX: function(event) {
    return event.pageX || (event.clientX +
      (document.documentElement.scrollLeft || document.body.scrollLeft));
  },

  pointerY: function(event) {
    return event.pageY || (event.clientY +
      (document.documentElement.scrollTop || document.body.scrollTop));
  },

  stop: function(event) {
    if (event.preventDefault) {
      event.preventDefault();
      event.stopPropagation();
    } else {
      event.returnValue = false;
      event.cancelBubble = true;
    }
  },

  // find the first node with the given tagName, starting from the
  // node the event was triggered on; traverses the DOM upwards
  findElement: function(event, tagName) {
    var element = Event.element(event);
    while (element.parentNode && (!!element.tagName ||
        (element.tagName.toUpperCase() !!= tagName.toUpperCase())))
      element = element.parentNode;
    return element;
  },

  observers: false,

  _observeAndCache: function(element, name, observer, useCapture) {
    if (!!this.observers) this.observers = [];
    if (element.addEventListener) {
      this.observers.push([element, name, observer, useCapture]);
      element.addEventListener(name, observer, useCapture);
    } else if (element.attachEvent) {
      this.observers.push([element, name, observer, useCapture]);
      element.attachEvent(''on'' + name, observer);
    }
  },

  unloadCache: function() {
    if (!!Event.observers) return;
    for (var i = 0; i < Event.observers.length; i++) {
      Event.stopObserving.apply(this, Event.observers[i]);
      Event.observers[i][0] = null;
    }
    Event.observers = false;
  },

  observe: function(element, name, observer, useCapture) {
    var element = $(element);
    useCapture = useCapture || false;

    if (name == ''keypress'' &&
        (navigator.appVersion.match(/Konqueror|Safari|KHTML/)
        || element.attachEvent))
      name = ''keydown'';

    this._observeAndCache(element, name, observer, useCapture);
  },

  stopObserving: function(element, name, observer, useCapture) {
    var element = $(element);
    useCapture = useCapture || false;

    if (name == ''keypress'' &&
        (navigator.appVersion.match(/Konqueror|Safari|KHTML/)
        || element.detachEvent))
      name = ''keydown'';

    if (element.removeEventListener) {
      element.removeEventListener(name, observer, useCapture);
    } else if (element.detachEvent) {
      element.detachEvent(''on'' + name, observer);
    }
  }
});

/* prevent memory leaks in IE */
Event.observe(window, ''unload'', Event.unloadCache, false);
var Position = {
  // set to true if needed, warning: firefox performance problems
  // NOT neeeded for page scrolling, only if draggable contained in
  // scrollable elements
  includeScrollOffsets: false,

  // must be called before calling withinIncludingScrolloffset, every time the
  // page is scrolled
  prepare: function() {
    this.deltaX =  window.pageXOffset
                || document.documentElement.scrollLeft
                || document.body.scrollLeft
                || 0;
    this.deltaY =  window.pageYOffset
                || document.documentElement.scrollTop
                || document.body.scrollTop
                || 0;
  },

  realOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.scrollTop  || 0;
      valueL += element.scrollLeft || 0;
      element = element.parentNode;
    } while (element);
    return [valueL, valueT];
  },

  cumulativeOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      element = element.offsetParent;
    } while (element);
    return [valueL, valueT];
  },

  positionedOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      element = element.offsetParent;
      if (element) {
        p = Element.getStyle(element, ''position'');
        if (p == ''relative'' || p == ''absolute'') break;
      }
    } while (element);
    return [valueL, valueT];
  },

  offsetParent: function(element) {
    if (element.offsetParent) return element.offsetParent;
    if (element == document.body) return element;

    while ((element = element.parentNode) && element !!= document.body)
      if (Element.getStyle(element, ''position'') !!= ''static'')
        return element;

    return document.body;
  },

  // caches x/y coordinate pair to use with overlap
  within: function(element, x, y) {
    if (this.includeScrollOffsets)
      return this.withinIncludingScrolloffsets(element, x, y);
    this.xcomp = x;
    this.ycomp = y;
    this.offset = this.cumulativeOffset(element);

    return (y >= this.offset[1] &&
            y <  this.offset[1] + element.offsetHeight &&
            x >= this.offset[0] &&
            x <  this.offset[0] + element.offsetWidth);
  },

  withinIncludingScrolloffsets: function(element, x, y) {
    var offsetcache = this.realOffset(element);

    this.xcomp = x + offsetcache[0] - this.deltaX;
    this.ycomp = y + offsetcache[1] - this.deltaY;
    this.offset = this.cumulativeOffset(element);

    return (this.ycomp >= this.offset[1] &&
            this.ycomp <  this.offset[1] + element.offsetHeight &&
            this.xcomp >= this.offset[0] &&
            this.xcomp <  this.offset[0] + element.offsetWidth);
  },

  // within must be called directly before
  overlap: function(mode, element) {
    if (!!mode) return 0;
    if (mode == ''vertical'')
      return ((this.offset[1] + element.offsetHeight) - this.ycomp) /
        element.offsetHeight;
    if (mode == ''horizontal'')
      return ((this.offset[0] + element.offsetWidth) - this.xcomp) /
        element.offsetWidth;
  },

  clone: function(source, target) {
    source = $(source);
    target = $(target);
    target.style.position = ''absolute'';
    var offsets = this.cumulativeOffset(source);
    target.style.top    = offsets[1] + ''px'';
    target.style.left   = offsets[0] + ''px'';
    target.style.width  = source.offsetWidth + ''px'';
    target.style.height = source.offsetHeight + ''px'';
  },

  page: function(forElement) {
    var valueT = 0, valueL = 0;

    var element = forElement;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;

      // Safari fix
      if (element.offsetParent==document.body)
        if (Element.getStyle(element,''position'')==''absolute'') break;

    } while (element = element.offsetParent);

    element = forElement;
    do {
      valueT -= element.scrollTop  || 0;
      valueL -= element.scrollLeft || 0;
    } while (element = element.parentNode);

    return [valueL, valueT];
  },

  clone: function(source, target) {
    var options = Object.extend({
      setLeft:    true,
      setTop:     true,
      setWidth:   true,
      setHeight:  true,
      offsetTop:  0,
      offsetLeft: 0
    }, arguments[2] || {})

    // find page position of source
    source = $(source);
    var p = Position.page(source);

    // find coordinate system to use
    target = $(target);
    var delta = [0, 0];
    var parent = null;
    // delta [0,0] will do fine with position: fixed elements,
    // position:absolute needs offsetParent deltas
    if (Element.getStyle(target,''position'') == ''absolute'') {
      parent = Position.offsetParent(target);
      delta = Position.page(parent);
    }

    // correct by body offsets (fixes Safari)
    if (parent == document.body) {
      delta[0] -= document.body.offsetLeft;
      delta[1] -= document.body.offsetTop;
    }

    // set position
    if(options.setLeft)   target.style.left  = (p[0] - delta[0] + options.offsetLeft) + ''px'';
    if(options.setTop)    target.style.top   = (p[1] - delta[1] + options.offsetTop) + ''px'';
    if(options.setWidth)  target.style.width = source.offsetWidth + ''px'';
    if(options.setHeight) target.style.height = source.offsetHeight + ''px'';
  },

  absolutize: function(element) {
    element = $(element);
    if (element.style.position == ''absolute'') return;
    Position.prepare();

    var offsets = Position.positionedOffset(element);
    var top     = offsets[1];
    var left    = offsets[0];
    var width   = element.clientWidth;
    var height  = element.clientHeight;

    element._originalLeft   = left - parseFloat(element.style.left  || 0);
    element._originalTop    = top  - parseFloat(element.style.top || 0);
    element._originalWidth  = element.style.width;
    element._originalHeight = element.style.height;

    element.style.position = ''absolute'';
    element.style.top    = top + ''px'';;
    element.style.left   = left + ''px'';;
    element.style.width  = width + ''px'';;
    element.style.height = height + ''px'';;
  },

  relativize: function(element) {
    element = $(element);
    if (element.style.position == ''relative'') return;
    Position.prepare();

    element.style.position = ''relative'';
    var top  = parseFloat(element.style.top  || 0) - (element._originalTop || 0);
    var left = parseFloat(element.style.left || 0) - (element._originalLeft || 0);

    element.style.top    = top + ''px'';
    element.style.left   = left + ''px'';
    element.style.height = element._originalHeight;
    element.style.width  = element._originalWidth;
  }
}

// Safari returns margins on body which is incorrect if the child is absolutely
// positioned.  For performance reasons, redefine Position.cumulativeOffset for
// KHTML/WebKit only.
if (/Konqueror|Safari|KHTML/.test(navigator.userAgent)) {
  Position.cumulativeOffset = function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      if (element.offsetParent == document.body)
        if (Element.getStyle(element, ''position'') == ''absolute'') break;

      element = element.offsetParent;
    } while (element);

    return [valueL, valueT];
  }
}
'!

jsPrototypeFramework131
	^'
/*  Prototype JavaScript framework, version 1.3.1
 *  (c) 2005 Sam Stephenson <sam@conio.net>
 *
 *  THIS FILE IS AUTOMATICALLY GENERATED. When sending patches, please diff
 *  against the source tree, available from the Prototype darcs repository. 
 *
 *  Prototype is freely distributable under the terms of an MIT-style license.
 *
 *  For details, see the Prototype web site: http://prototype.conio.net/
 *
/*--------------------------------------------------------------------------*/

var Prototype = {
  Version: ''1.3.1'',
  emptyFunction: function() {}
}

var Class = {
  create: function() {
    return function() { 
      this.initialize.apply(this, arguments);
    }
  }
}

var Abstract = new Object();

Object.extend = function(destination, source) {
  for (property in source) {
    destination[property] = source[property];
  }
  return destination;
}

Object.prototype.extend = function(object) {
  return Object.extend.apply(this, [this, object]);
}

Function.prototype.bind = function(object) {
  var __method = this;
  return function() {
    __method.apply(object, arguments);
  }
}

Function.prototype.bindAsEventListener = function(object) {
  var __method = this;
  return function(event) {
    __method.call(object, event || window.event);
  }
}

Number.prototype.toColorPart = function() {
  var digits = this.toString(16);
  if (this < 16) return ''Nothing more expected ->0'' + digits;
  return digits;
}

var Try = {
  these: function() {
    var returnValue;

    for (var i = 0; i < arguments.length; i++) {
      var lambda = arguments[i];
      try {
        returnValue = lambda();
        break;
      } catch (e) {}
    }

    return returnValue;
  }
}

/*--------------------------------------------------------------------------*/

var PeriodicalExecuter = Class.create();
PeriodicalExecuter.prototype = {
  initialize: function(callback, frequency) {
    this.callback = callback;
    this.frequency = frequency;
    this.currentlyExecuting = false;

    this.registerCallback();
  },

  registerCallback: function() {
    setInterval(this.onTimerEvent.bind(this), this.frequency * 1000);
  },

  onTimerEvent: function() {
    if (!!this.currentlyExecuting) {
      try { 
        this.currentlyExecuting = true;
        this.callback(); 
      } finally { 
        this.currentlyExecuting = false;
      }
    }
  }
}

/*--------------------------------------------------------------------------*/

function $() {
  var elements = new Array();

  for (var i = 0; i < arguments.length; i++) {
    var element = arguments[i];
    if (typeof element == ''string'')
      element = document.getElementById(element);

    if (arguments.length == 1) 
      return element;

    elements.push(element);
  }

  return elements;
}

if (!!Array.prototype.push) {
  Array.prototype.push = function() {
		var startLength = this.length;
		for (var i = 0; i < arguments.length; i++)
      this[startLength + i] = arguments[i];
	  return this.length;
  }
}

if (!!Function.prototype.apply) {
  // Based on code from http://www.youngpup.net/
  Function.prototype.apply = function(object, parameters) {
    var parameterStrings = new Array();
    if (!!object)     object = window;
    if (!!parameters) parameters = new Array();
    
    for (var i = 0; i < parameters.length; i++)
      parameterStrings[i] = ''parameters['' + i + '']'';
    
    object.__apply__ = this;
    var result = eval(''object.__apply__('' + 
      parameterStrings.join('', '') + '')'');
    object.__apply__ = null;
    
    return result;
  }
}

String.prototype.extend({
  stripTags: function() {
    return this.replace(/<\/?[^>]+>/gi, '''');
  },

  escapeHTML: function() {
    var div = document.createElement(''div'');
    var text = document.createTextNode(this);
    div.appendChild(text);
    return div.innerHTML;
  },

  unescapeHTML: function() {
    var div = document.createElement(''div'');
    div.innerHTML = this.stripTags();
    return div.childNodes[0].nodeValue;
  }
});

var Ajax = {
  getTransport: function() {
    return Try.these(
      function() {return new ActiveXObject(''Msxml2.XMLHTTP'')},
      function() {return new ActiveXObject(''Microsoft.XMLHTTP'')},
      function() {return new XMLHttpRequest()}
    ) || false;
  }
}

Ajax.Base = function() {};
Ajax.Base.prototype = {
  setOptions: function(options) {
    this.options = {
      method:       ''post'',
      asynchronous: true,
      parameters:   ''''
    }.extend(options || {});
  },

  responseIsSuccess: function() {
    return this.transport.status == undefined
        || this.transport.status == 0 
        || (this.transport.status >= 200 && this.transport.status < 300);
  },

  responseIsFailure: function() {
    return !!this.responseIsSuccess();
  }
}

Ajax.Request = Class.create();
Ajax.Request.Events = 
  [''Uninitialized'', ''Loading'', ''Loaded'', ''Interactive'', ''Complete''];

Ajax.Request.prototype = (new Ajax.Base()).extend({
  initialize: function(url, options) {
    this.transport = Ajax.getTransport();
    this.setOptions(options);
    this.request(url);
  },

  request: function(url) {
    var parameters = this.options.parameters || '''';
    if (parameters.length > 0) parameters += ''&_='';

    try {
      if (this.options.method == ''get'')
        url += ''?'' + parameters;

      this.transport.open(this.options.method, url,
        this.options.asynchronous);

      if (this.options.asynchronous) {
        this.transport.onreadystatechange = this.onStateChange.bind(this);
        setTimeout((function() {this.respondToReadyState(1)}).bind(this), 10);
      }

      this.setRequestHeaders();

      var body = this.options.postBody ? this.options.postBody : parameters;
      this.transport.send(this.options.method == ''post'' ? body : null);

    } catch (e) {
    }
  },

  setRequestHeaders: function() {
    var requestHeaders = 
      [''X-Requested-With'', ''XMLHttpRequest'',
       ''X-Prototype-Version'', Prototype.Version];

    if (this.options.method == ''post'') {
      requestHeaders.push(''Content-type'', 
        ''application/x-www-form-urlencoded'');

      /* Force "Connection: close" for Mozilla browsers to work around
       * a bug where XMLHttpReqeuest sends an incorrect Content-length
       * header. See Mozilla Bugzilla #246651. 
       */
      if (this.transport.overrideMimeType)
        requestHeaders.push(''Connection'', ''close'');
    }

    if (this.options.requestHeaders)
      requestHeaders.push.apply(requestHeaders, this.options.requestHeaders);

    for (var i = 0; i < requestHeaders.length; i += 2)
      this.transport.setRequestHeader(requestHeaders[i], requestHeaders[i+1]);
  },

  onStateChange: function() {
    var readyState = this.transport.readyState;
    if (readyState !!= 1)
      this.respondToReadyState(this.transport.readyState);
  },

  respondToReadyState: function(readyState) {
    var event = Ajax.Request.Events[readyState];

    if (event == ''Complete'')
      (this.options[''on'' + this.transport.status]
       || this.options[''on'' + (this.responseIsSuccess() ? ''Success'' : ''Failure'')]
       || Prototype.emptyFunction)(this.transport);

    (this.options[''on'' + event] || Prototype.emptyFunction)(this.transport);

    /* Avoid memory leak in MSIE: clean up the oncomplete event handler */
    if (event == ''Complete'')
      this.transport.onreadystatechange = Prototype.emptyFunction;
  }
});

Ajax.Updater = Class.create();
Ajax.Updater.ScriptFragment = ''(?:<script.*?>)((\n|.)*?)(?:<\/script>)'';

Ajax.Updater.prototype.extend(Ajax.Request.prototype).extend({
  initialize: function(container, url, options) {
    this.containers = {
      success: container.success ? $(container.success) : $(container),
      failure: container.failure ? $(container.failure) :
        (container.success ? null : $(container))
    }

    this.transport = Ajax.getTransport();
    this.setOptions(options);

    var onComplete = this.options.onComplete || Prototype.emptyFunction;
    this.options.onComplete = (function() {
      this.updateContent();
      onComplete(this.transport);
    }).bind(this);

    this.request(url);
  },

  updateContent: function() {
    var receiver = this.responseIsSuccess() ?
      this.containers.success : this.containers.failure;

    var match    = new RegExp(Ajax.Updater.ScriptFragment, ''img'');
    var response = this.transport.responseText.replace(match, '''');
    var scripts  = this.transport.responseText.match(match);

    if (receiver) {
      if (this.options.insertion) {
        new this.options.insertion(receiver, response);
      } else {
        receiver.innerHTML = response;
      }
    }

    if (this.responseIsSuccess()) {
      if (this.onComplete)
        setTimeout((function() {this.onComplete(
          this.transport)}).bind(this), 10);
    }

    if (this.options.evalScripts && scripts) {
      match = new RegExp(Ajax.Updater.ScriptFragment, ''im'');
      setTimeout((function() {
        for (var i = 0; i < scripts.length; i++)
          eval(scripts[i].match(match)[1]);
      }).bind(this), 10);
    }
  }
});

Ajax.PeriodicalUpdater = Class.create();
Ajax.PeriodicalUpdater.prototype = (new Ajax.Base()).extend({
  initialize: function(container, url, options) {
    this.setOptions(options);
    this.onComplete = this.options.onComplete;

    this.frequency = (this.options.frequency || 2);
    this.decay = 1;

    this.updater = {};
    this.container = container;
    this.url = url;

    this.start();
  },

  start: function() {
    this.options.onComplete = this.updateComplete.bind(this);
    this.onTimerEvent();
  },

  stop: function() {
    this.updater.onComplete = undefined;
    clearTimeout(this.timer);
    (this.onComplete || Ajax.emptyFunction).apply(this, arguments);
  },

  updateComplete: function(request) {
    if (this.options.decay) {
      this.decay = (request.responseText == this.lastText ? 
        this.decay * this.options.decay : 1);

      this.lastText = request.responseText;
    }
    this.timer = setTimeout(this.onTimerEvent.bind(this), 
      this.decay * this.frequency * 1000);
  },

  onTimerEvent: function() {
    this.updater = new Ajax.Updater(this.container, this.url, this.options);
  }
});

document.getElementsByClassName = function(className) {
  var children = document.getElementsByTagName(''*'') || document.all;
  var elements = new Array();
  
  for (var i = 0; i < children.length; i++) {
    var child = children[i];
    var classNames = child.className.split('' '');
    for (var j = 0; j < classNames.length; j++) {
      if (classNames[j] == className) {
        elements.push(child);
        break;
      }
    }
  }
  
  return elements;
}

/*--------------------------------------------------------------------------*/

if (!!window.Element) {
  var Element = new Object();
}

Object.extend(Element, {
  toggle: function() {
    for (var i = 0; i < arguments.length; i++) {
      var element = $(arguments[i]);
      element.style.display = 
        (element.style.display == ''none'' ? '''' : ''none'');
    }
  },

  hide: function() {
    for (var i = 0; i < arguments.length; i++) {
      var element = $(arguments[i]);
      element.style.display = ''none'';
    }
  },

  show: function() {
    for (var i = 0; i < arguments.length; i++) {
      var element = $(arguments[i]);
      element.style.display = '''';
    }
  },

  remove: function(element) {
    element = $(element);
    element.parentNode.removeChild(element);
  },
   
  getHeight: function(element) {
    element = $(element);
    return element.offsetHeight; 
  },

  hasClassName: function(element, className) {
    element = $(element);
    if (!!element)
      return;
    var a = element.className.split('' '');
    for (var i = 0; i < a.length; i++) {
      if (a[i] == className)
        return true;
    }
    return false;
  },

  addClassName: function(element, className) {
    element = $(element);
    Element.removeClassName(element, className);
    element.className += '' '' + className;
  },

  removeClassName: function(element, className) {
    element = $(element);
    if (!!element)
      return;
    var newClassName = '''';
    var a = element.className.split('' '');
    for (var i = 0; i < a.length; i++) {
      if (a[i] !!= className) {
        if (i > 0)
          newClassName += '' '';
        newClassName += a[i];
      }
    }
    element.className = newClassName;
  },
  
  // removes whitespace-only text node children
  cleanWhitespace: function(element) {
    var element = $(element);
    for (var i = 0; i < element.childNodes.length; i++) {
      var node = element.childNodes[i];
      if (node.nodeType == 3 && !!/\S/.test(node.nodeValue)) 
        Element.remove(node);
    }
  }
});

var Toggle = new Object();
Toggle.display = Element.toggle;

/*--------------------------------------------------------------------------*/

Abstract.Insertion = function(adjacency) {
  this.adjacency = adjacency;
}

Abstract.Insertion.prototype = {
  initialize: function(element, content) {
    this.element = $(element);
    this.content = content;
    
    if (this.adjacency && this.element.insertAdjacentHTML) {
      this.element.insertAdjacentHTML(this.adjacency, this.content);
    } else {
      this.range = this.element.ownerDocument.createRange();
      if (this.initializeRange) this.initializeRange();
      this.fragment = this.range.createContextualFragment(this.content);
      this.insertContent();
    }
  }
}

var Insertion = new Object();

Insertion.Before = Class.create();
Insertion.Before.prototype = (new Abstract.Insertion(''beforeBegin'')).extend({
  initializeRange: function() {
    this.range.setStartBefore(this.element);
  },
  
  insertContent: function() {
    this.element.parentNode.insertBefore(this.fragment, this.element);
  }
});

Insertion.Top = Class.create();
Insertion.Top.prototype = (new Abstract.Insertion(''afterBegin'')).extend({
  initializeRange: function() {
    this.range.selectNodeContents(this.element);
    this.range.collapse(true);
  },
  
  insertContent: function() {  
    this.element.insertBefore(this.fragment, this.element.firstChild);
  }
});

Insertion.Bottom = Class.create();
Insertion.Bottom.prototype = (new Abstract.Insertion(''beforeEnd'')).extend({
  initializeRange: function() {
    this.range.selectNodeContents(this.element);
    this.range.collapse(this.element);
  },
  
  insertContent: function() {
    this.element.appendChild(this.fragment);
  }
});

Insertion.After = Class.create();
Insertion.After.prototype = (new Abstract.Insertion(''afterEnd'')).extend({
  initializeRange: function() {
    this.range.setStartAfter(this.element);
  },
  
  insertContent: function() {
    this.element.parentNode.insertBefore(this.fragment, 
      this.element.nextSibling);
  }
});

var Field = {
  clear: function() {
    for (var i = 0; i < arguments.length; i++)
      $(arguments[i]).value = '''';
  },

  focus: function(element) {
    $(element).focus();
  },
  
  present: function() {
    for (var i = 0; i < arguments.length; i++)
      if ($(arguments[i]).value == '''') return false;
    return true;
  },
  
  select: function(element) {
    $(element).select();
  },
   
  activate: function(element) {
    $(element).focus();
    $(element).select();
  }
}

/*--------------------------------------------------------------------------*/

var Form = {
  serialize: function(form) {
    var elements = Form.getElements($(form));
    var queryComponents = new Array();
    
    for (var i = 0; i < elements.length; i++) {
      var queryComponent = Form.Element.serialize(elements[i]);
      if (queryComponent)
        queryComponents.push(queryComponent);
    }
    
    return queryComponents.join(''&'');
  },
  
  getElements: function(form) {
    var form = $(form);
    var elements = new Array();

    for (tagName in Form.Element.Serializers) {
      var tagElements = form.getElementsByTagName(tagName);
      for (var j = 0; j < tagElements.length; j++)
        elements.push(tagElements[j]);
    }
    return elements;
  },
  
  getInputs: function(form, typeName, name) {
    var form = $(form);
    var inputs = form.getElementsByTagName(''input'');
    
    if (!!typeName && !!name)
      return inputs;
      
    var matchingInputs = new Array();
    for (var i = 0; i < inputs.length; i++) {
      var input = inputs[i];
      if ((typeName && input.type !!= typeName) ||
          (name && input.name !!= name)) 
        continue;
      matchingInputs.push(input);
    }

    return matchingInputs;
  },

  disable: function(form) {
    var elements = Form.getElements(form);
    for (var i = 0; i < elements.length; i++) {
      var element = elements[i];
      element.blur();
      element.disabled = ''true'';
    }
  },

  enable: function(form) {
    var elements = Form.getElements(form);
    for (var i = 0; i < elements.length; i++) {
      var element = elements[i];
      element.disabled = '''';
    }
  },

  focusFirstElement: function(form) {
    var form = $(form);
    var elements = Form.getElements(form);
    for (var i = 0; i < elements.length; i++) {
      var element = elements[i];
      if (element.type !!= ''hidden'' && !!element.disabled) {
        Field.activate(element);
        break;
      }
    }
  },

  reset: function(form) {
    $(form).reset();
  }
}

Form.Element = {
  serialize: function(element) {
    var element = $(element);
    var method = element.tagName.toLowerCase();
    var parameter = Form.Element.Serializers[method](element);
    
    if (parameter)
      return encodeURIComponent(parameter[0]) + ''='' + 
        encodeURIComponent(parameter[1]);                   
  },
  
  getValue: function(element) {
    var element = $(element);
    var method = element.tagName.toLowerCase();
    var parameter = Form.Element.Serializers[method](element);
    
    if (parameter) 
      return parameter[1];
  }
}

Form.Element.Serializers = {
  input: function(element) {
    switch (element.type.toLowerCase()) {
      case ''submit'':
      case ''hidden'':
      case ''password'':
      case ''text'':
        return Form.Element.Serializers.textarea(element);
      case ''checkbox'':  
      case ''radio'':
        return Form.Element.Serializers.inputSelector(element);
    }
    return false;
  },

  inputSelector: function(element) {
    if (element.checked)
      return [element.name, element.value];
  },

  textarea: function(element) {
    return [element.name, element.value];
  },

  select: function(element) {
    var value = '''';
    if (element.type == ''select-one'') {
      var index = element.selectedIndex;
      if (index >= 0)
        value = element.options[index].value || element.options[index].text;
    } else {
      value = new Array();
      for (var i = 0; i < element.length; i++) {
        var opt = element.options[i];
        if (opt.selected)
          value.push(opt.value || opt.text);
      }
    }
    return [element.name, value];
  }
}

/*--------------------------------------------------------------------------*/

var $F = Form.Element.getValue;

/*--------------------------------------------------------------------------*/

Abstract.TimedObserver = function() {}
Abstract.TimedObserver.prototype = {
  initialize: function(element, frequency, callback) {
    this.frequency = frequency;
    this.element   = $(element);
    this.callback  = callback;
    
    this.lastValue = this.getValue();
    this.registerCallback();
  },
  
  registerCallback: function() {
    setInterval(this.onTimerEvent.bind(this), this.frequency * 1000);
  },
  
  onTimerEvent: function() {
    var value = this.getValue();
    if (this.lastValue !!= value) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  }
}

Form.Element.Observer = Class.create();
Form.Element.Observer.prototype = (new Abstract.TimedObserver()).extend({
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.Observer = Class.create();
Form.Observer.prototype = (new Abstract.TimedObserver()).extend({
  getValue: function() {
    return Form.serialize(this.element);
  }
});

/*--------------------------------------------------------------------------*/

Abstract.EventObserver = function() {}
Abstract.EventObserver.prototype = {
  initialize: function(element, callback) {
    this.element  = $(element);
    this.callback = callback;
    
    this.lastValue = this.getValue();
    if (this.element.tagName.toLowerCase() == ''form'')
      this.registerFormCallbacks();
    else
      this.registerCallback(this.element);
  },
  
  onElementEvent: function() {
    var value = this.getValue();
    if (this.lastValue !!= value) {
      this.callback(this.element, value);
      this.lastValue = value;
    }
  },
  
  registerFormCallbacks: function() {
    var elements = Form.getElements(this.element);
    for (var i = 0; i < elements.length; i++)
      this.registerCallback(elements[i]);
  },
  
  registerCallback: function(element) {
    if (element.type) {
      switch (element.type.toLowerCase()) {
        case ''checkbox'':  
        case ''radio'':
          element.target = this;
          element.prev_onclick = element.onclick || Prototype.emptyFunction;
          element.onclick = function() {
            this.prev_onclick(); 
            this.target.onElementEvent();
          }
          break;
        case ''password'':
        case ''text'':
        case ''textarea'':
        case ''select-one'':
        case ''select-multiple'':
          element.target = this;
          element.prev_onchange = element.onchange || Prototype.emptyFunction;
          element.onchange = function() {
            this.prev_onchange(); 
            this.target.onElementEvent();
          }
          break;
      }
    }    
  }
}

Form.Element.EventObserver = Class.create();
Form.Element.EventObserver.prototype = (new Abstract.EventObserver()).extend({
  getValue: function() {
    return Form.Element.getValue(this.element);
  }
});

Form.EventObserver = Class.create();
Form.EventObserver.prototype = (new Abstract.EventObserver()).extend({
  getValue: function() {
    return Form.serialize(this.element);
  }
});


if (!!window.Event) {
  var Event = new Object();
}

Object.extend(Event, {
  KEY_BACKSPACE: 8,
  KEY_TAB:       9,
  KEY_RETURN:   13,
  KEY_ESC:      27,
  KEY_LEFT:     37,
  KEY_UP:       38,
  KEY_RIGHT:    39,
  KEY_DOWN:     40,
  KEY_DELETE:   46,

  element: function(event) {
    return event.target || event.srcElement;
  },

  isLeftClick: function(event) {
    return (((event.which) && (event.which == 1)) ||
            ((event.button) && (event.button == 1)));
  },

  pointerX: function(event) {
    return event.pageX || (event.clientX + 
      (document.documentElement.scrollLeft || document.body.scrollLeft));
  },

  pointerY: function(event) {
    return event.pageY || (event.clientY + 
      (document.documentElement.scrollTop || document.body.scrollTop));
  },

  stop: function(event) {
    if (event.preventDefault) { 
      event.preventDefault(); 
      event.stopPropagation(); 
    } else {
      event.returnValue = false;
    }
  },

  // find the first node with the given tagName, starting from the
  // node the event was triggered on; traverses the DOM upwards
  findElement: function(event, tagName) {
    var element = Event.element(event);
    while (element.parentNode && (!!element.tagName ||
        (element.tagName.toUpperCase() !!= tagName.toUpperCase())))
      element = element.parentNode;
    return element;
  },

  observers: false,
  
  _observeAndCache: function(element, name, observer, useCapture) {
    if (!!this.observers) this.observers = [];
    if (element.addEventListener) {
      this.observers.push([element, name, observer, useCapture]);
      element.addEventListener(name, observer, useCapture);
    } else if (element.attachEvent) {
      this.observers.push([element, name, observer, useCapture]);
      element.attachEvent(''on'' + name, observer);
    }
  },
  
  unloadCache: function() {
    if (!!Event.observers) return;
    for (var i = 0; i < Event.observers.length; i++) {
      Event.stopObserving.apply(this, Event.observers[i]);
      Event.observers[i][0] = null;
    }
    Event.observers = false;
  },

  observe: function(element, name, observer, useCapture) {
    var element = $(element);
    useCapture = useCapture || false;
    
    if (name == ''keypress'' &&
        ((navigator.appVersion.indexOf(''AppleWebKit'') > 0) 
        || element.attachEvent))
      name = ''keydown'';
    
    this._observeAndCache(element, name, observer, useCapture);
  },

  stopObserving: function(element, name, observer, useCapture) {
    var element = $(element);
    useCapture = useCapture || false;
    
    if (name == ''keypress'' &&
        ((navigator.appVersion.indexOf(''AppleWebKit'') > 0) 
        || element.detachEvent))
      name = ''keydown'';
    
    if (element.removeEventListener) {
      element.removeEventListener(name, observer, useCapture);
    } else if (element.detachEvent) {
      element.detachEvent(''on'' + name, observer);
    }
  }
});

/* prevent memory leaks in IE */
Event.observe(window, ''unload'', Event.unloadCache, false);

var Position = {

  // set to true if needed, warning: firefox performance problems
  // NOT neeeded for page scrolling, only if draggable contained in
  // scrollable elements
  includeScrollOffsets: false, 

  // must be called before calling withinIncludingScrolloffset, every time the
  // page is scrolled
  prepare: function() {
    this.deltaX =  window.pageXOffset 
                || document.documentElement.scrollLeft 
                || document.body.scrollLeft 
                || 0;
    this.deltaY =  window.pageYOffset 
                || document.documentElement.scrollTop 
                || document.body.scrollTop 
                || 0;
  },

  realOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.scrollTop  || 0;
      valueL += element.scrollLeft || 0; 
      element = element.parentNode;
    } while (element);
    return [valueL, valueT];
  },

  cumulativeOffset: function(element) {
    var valueT = 0, valueL = 0;
    do {
      valueT += element.offsetTop  || 0;
      valueL += element.offsetLeft || 0;
      element = element.offsetParent;
    } while (element);
    return [valueL, valueT];
  },

  // caches x/y coordinate pair to use with overlap
  within: function(element, x, y) {
    if (this.includeScrollOffsets)
      return this.withinIncludingScrolloffsets(element, x, y);
    this.xcomp = x;
    this.ycomp = y;
    this.offset = this.cumulativeOffset(element);

    return (y >= this.offset[1] &&
            y <  this.offset[1] + element.offsetHeight &&
            x >= this.offset[0] && 
            x <  this.offset[0] + element.offsetWidth);
  },

  withinIncludingScrolloffsets: function(element, x, y) {
    var offsetcache = this.realOffset(element);

    this.xcomp = x + offsetcache[0] - this.deltaX;
    this.ycomp = y + offsetcache[1] - this.deltaY;
    this.offset = this.cumulativeOffset(element);

    return (this.ycomp >= this.offset[1] &&
            this.ycomp <  this.offset[1] + element.offsetHeight &&
            this.xcomp >= this.offset[0] && 
            this.xcomp <  this.offset[0] + element.offsetWidth);
  },

  // within must be called directly before
  overlap: function(mode, element) {  
    if (!!mode) return 0;  
    if (mode == ''vertical'') 
      return ((this.offset[1] + element.offsetHeight) - this.ycomp) / 
        element.offsetHeight;
    if (mode == ''horizontal'')
      return ((this.offset[0] + element.offsetWidth) - this.xcomp) / 
        element.offsetWidth;
  },

  clone: function(source, target) {
    source = $(source);
    target = $(target);
    target.style.position = ''absolute'';
    var offsets = this.cumulativeOffset(source);
    target.style.top    = offsets[1] + ''px'';
    target.style.left   = offsets[0] + ''px'';
    target.style.width  = source.offsetWidth + ''px'';
    target.style.height = source.offsetHeight + ''px'';
  }
}
'!

keyGif
	"'imgs/fast/fast-key.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 18 0 8 0 145 2 0 209 173 75 221 185 87 245 245 236 245 216 100 33 249 4 1 0 0 2 0 44 0 0 0 0 18 0 8 0 0 2 32 148 134 99 203 156 217 226 155 20 29 4 64 157 33 229 20 116 67 216 5 23 103 132 139 153 62 108 212 144 47 108 20 0 59 13 10 ]!

leftCornerGif
	"'imgs/fast/fast-left_corner.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 4 0 4 0 128 1 0 255 255 255 229 236 243 33 249 4 1 0 0 1 0 44 0 0 0 0 4 0 4 0 0 2 6 132 17 97 169 12 5 0 59 13 10 ]!

leftStripeGif
	"'imgs/fast/fast-left_stripe.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 8 0 1 0 128 0 0 170 167 153 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 8 0 1 0 0 2 3 132 111 5 0 59 13 10 ]!

loginBelowMessage
	^''!

loginButton
	^'Login'!

loginErrorText
	^'<b style={color:red}>Login failed!! Please check your entry and try again!!</b>'!

loginText
	^'Login'!

loginTitle
	^'AIDA/Web Login'!

loginWelcomeMessage
	^'<h1>Welcome to AIDA/Web Smalltalk Web Application Server!!</h1>
      <br><br>
      Please login to enter a site: '!

logoutText
	^'Logout'!

multimediaSmallPng
	"'imgs/ikone-dok/corendal-wave.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 143 73 68 65 84 120 156 98 248 15 3 237 43 239 160 161 142 213 247 90 22 95 43 105 216 116 247 238 221 175 95 191 66 148 1 4 16 3 92 195 212 67 95 255 254 251 143 9 128 26 10 23 159 56 122 244 40 68 15 64 0 33 52 76 218 251 1 168 1 19 101 101 207 222 119 234 191 211 212 39 16 61 0 1 132 208 208 191 245 5 80 250 231 159 255 63 254 128 72 56 3 168 1 130 106 27 87 3 245 0 4 16 66 195 132 29 175 222 205 153 0 68 83 118 39 47 221 183 98 201 201 55 39 159 254 255 252 243 255 231 31 32 18 104 73 85 221 242 206 206 78 128 0 130 106 248 182 116 210 207 16 157 255 110 74 64 84 124 128 49 101 33 99 65 191 209 244 157 231 151 93 253 255 250 219 255 55 95 255 239 61 245 191 164 98 113 97 97 33 64 0 129 52 124 95 53 253 79 144 250 255 134 248 175 179 59 239 110 234 88 117 43 170 110 47 95 204 36 198 168 114 217 174 237 119 55 220 250 255 228 211 255 93 167 254 231 23 205 3 106 0 8 0 49 0 206 255 0 248 235 231 247 88 47 255 125 91 244 175 155 144 146 146 214 220 226 240 235 248 211 225 189 125 173 37 81 120 1 102 123 97 119 192 254 219 237 255 183 204 255 104 106 151 113 113 113 2 136 225 203 250 57 127 60 197 255 79 46 251 246 249 109 94 94 30 80 104 222 188 121 239 95 127 219 113 126 114 116 179 136 109 132 66 214 238 255 151 95 254 223 114 230 127 98 242 4 160 44 64 0 49 108 158 181 74 189 246 126 252 214 159 16 13 106 106 106 140 140 140 201 201 153 64 61 47 15 171 28 95 46 149 177 231 223 153 167 255 55 156 253 31 29 211 13 212 0 16 64 12 109 171 111 179 86 125 128 104 48 51 53 145 145 145 169 171 175 191 126 235 241 255 191 47 63 157 182 4 106 72 217 245 239 200 163 255 107 207 254 15 11 107 7 106 0 8 32 134 163 103 238 200 38 156 6 90 178 254 236 91 160 99 174 93 189 4 10 181 191 47 95 95 74 1 218 48 165 221 56 117 215 191 253 247 255 175 62 251 63 40 168 25 168 1 32 128 24 126 252 248 30 152 187 69 208 247 152 81 225 229 238 245 111 79 92 121 244 253 217 194 215 23 18 94 157 48 59 177 136 189 112 230 198 190 99 255 79 221 248 191 242 28 84 3 64 0 129 130 245 254 253 135 22 126 11 197 172 182 200 187 29 1 162 87 199 244 95 31 81 60 182 144 179 36 55 54 45 99 74 124 226 132 152 152 158 136 200 206 208 176 54 160 6 128 0 130 70 220 253 251 247 138 203 103 169 27 76 80 55 232 235 169 214 238 169 210 206 206 72 40 42 42 42 68 5 83 167 78 5 8 32 68 210 0 38 44 96 50 190 136 23 0 21 0 4 24 0 34 93 26 208 218 204 108 191 0 0 0 0 73 69 78 68 174 66 96 130 ]!

navBarAdminElement
	| element |
	self app user isAdmin ifFalse: [^WebElement new]. 
	element := (WebElement newClass: #navdiv)
		add: (self navHeader: ' ADMIN' bullet: #bulletManTranspWhiteGif);
		add: (WebList newUnordered
			addLinkTo: self site admin text: 'Login' view: 'login'; 
			addLinkTo: self site admin text: 'Logout'  view: 'logout'; 
			addSecureLinkTo: self site admin text: 'Settings' view: 'settings'; 
			addSecureLinkTo: self site securityManager text: 'Security';
			addSecureLinkTo: self site admin text: 'Uptime' view: 'serverStatistics'; 
			addSecureLinkTo: self site statistics text: 'Statistics';
			addSecureLinkTo: self site admin text: 'Tests' view: #tests;
			yourself);
		yourself.
	^element!

navBarContactElement
	| element |
	element := (WebElement newClass: #navdiv)
		add: (self navLinkTo: 'mailto:info@eranova.si' 
			header: 'info@eranova.si' bullet: #bulletLetterTranspWhiteGif);
		yourself. 
	^element!

navBarDemosIn: element
	element 	add: ((WebElement newClass: #navdiv)
		add: (self navHeader: ' DEMOS' bullet: #bulletStarTranspWhiteGif);
		add: (WebList newUnordered
			addLinkTo: self site discussions text: 'Discussions'; 
			addLinkTo: self site demo	text: 'Image gallery' view: #imageGallery; 
"			addLinkTo: self site demo text: 'File upload' view: #fileUpload; "
			addLinkTo: self site demo text: 'Tabs' view: #tabs; 
			addLinkTo: self site demo text: 'Grid, tabs, menus' view: #grid; 
			addLinkTo: self site demo text: 'Javascript' view: #javascript; 
			addLinkTo: self site demo text: 'Ajax' view: #ajax; 
			addLinkTo: self site demo text: 'Rich Editor' view: #richEditor; 
			addLinkTo: self site demo text: 'Calendar' view: #calendar; 
			yourself);
		yourself)!

navBarMainLinksElement
	| element |
	element 	:= (WebElement newClass: #navdiv)
		add: (self navHeader: ' LINKS' bullet: #bulletSquareDownTranspWhiteGif);
		add: (WebList newUnordered
"			addLinkTo: '/' text: 'Home'; "
"			addLinkTo: self site news text: 'News';  "
			addLinkTo: 'http://www.eranova.si/aida/' text: 'Aida home';
			addLinkTo: 'http://www.eranova.si/aida/faq.htm' text: 'FAQ';
			yourself);
		yourself. 
	^element!

navHeader: aString bullet: aSymbol
	^(WebText header: 3)
		addGif: aSymbol size: 13@13; addText: aString; yourself.!

navHeader: aString bullet: aSymbol linkTo: anObject
	^(WebText header: 3)
		addGif: aSymbol size: 13@13; addLinkTo: anObject text: aString; yourself.!

navHeader: aString bullet: aSymbol linkTo: anObject view: aView
	^(WebText header: 3)
		addGif: aSymbol size: 13@13; addLinkTo: anObject text: aString view: aView; yourself.!

navigationBarElement
	| element |
	element := WebElement newId: #navigation.
	element 	add: self navBarMainLinksElement.
	element add: self navBarAdminElement.
	self navBarDemosIn: element.
"	element add: self navBarSearchElement."
	element add: self navBarContactElement.
	^element!

navigatorColor
	^#yellow!

navLeftGif
	"'imgs/fast/fast-nav_left.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 7 0 82 0 128 0 0 127 160 177 255 255 255 33 249 4 1 0 0 0 0 44 0 0 0 0 7 0 82 0 0 2 64 140 143 6 144 139 203 14 124 78 86 117 195 180 17 119 157 109 30 245 137 96 25 166 232 74 182 156 59 190 114 76 159 176 61 227 181 201 171 119 207 202 1 127 62 97 113 119 212 41 135 198 32 210 185 76 50 159 68 232 20 211 248 28 10 0 59 13 10 ]!

navLinkTo: anObject header: aString bullet: aSymbol
	| element |
	element := WebText header: 3.
	element 	
		addGif: aSymbol size: 13@13;
		addLinkTo: anObject text: ' ', aString.
	^element!

observee

	^self app observee!

outlookBigGif
	"'imgs/outlook_icon.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 30 0 30 0 135 0 0 128 128 0 153 153 51 204 204 153 192 220 192 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 3 0 0 3 0 44 0 0 0 0 30 0 30 0 0 8 206 0 7 8 28 72 176 160 193 131 3 1 40 92 200 176 161 195 135 2 31 74 156 200 48 34 197 139 14 45 2 32 192 177 163 199 143 32 9 44 212 232 81 64 128 133 1 4 132 244 56 114 192 194 142 39 29 6 88 201 177 229 75 2 49 85 114 20 160 112 230 74 155 10 9 240 220 40 146 104 81 157 32 129 110 60 169 51 232 78 0 62 147 42 36 233 180 40 75 163 31 149 90 173 201 112 171 84 0 84 141 54 44 250 144 44 73 166 33 135 150 213 58 52 164 66 164 92 205 186 116 154 179 227 80 159 47 131 106 229 24 179 97 212 188 27 247 114 69 9 23 176 220 155 113 105 118 212 59 117 46 86 198 14 175 30 174 106 85 162 100 193 94 21 67 38 185 24 99 87 204 158 63 55 70 172 152 38 230 210 110 71 135 246 172 113 53 197 214 174 37 34 156 77 155 96 64 0 59 ]!

pageContentWideWidth
	"for things in extensionElement, which is full page wide"
	^800!

pageContentWidth
	^660!

pageFrameWideNoNavigationWith: aWebElement title: aTitleString
	"set a web page just with header and wide element below"
	| element |
	self app clear;  title: aTitleString. self app htmlHeaderElements.
"	self app	add: self headerBanner. "
	element := (WebElement newId: #container)
		add: self headerElement; 	add: self headerDashboard;
		add: ((WebElement newId: #contentWide)
			add: aWebElement; yourself);
		yourself.
	^self app add: element; yourself!

pageFrameWith: aWebElement title: aTitleString
	"set a web page with standard  page look (navigation bar, header) "
	^self pageFrameWith: aWebElement wide: WebElement new title: aTitleString!

pageFrameWith: aWebElement wide: aWideElement title: aTitleString
	"set a web page with standard  page look (navigation bar, header) "
	"Wide element comes below content besides navigation and it have full page width"
	| element |
	self app clear;  title: aTitleString. self app htmlHeaderElements.
"	self app	add: self headerBanner. "
	element := (WebElement newId: #container)
		add: self headerElement; 	add: self headerDashboard;
		add: ((WebElement newId: #content) 
			add: self navigationBarElement; add: aWebElement;  yourself); 
		add: ((WebElement newId: #contentWide)
			add: aWideElement; yourself);
		yourself.
	^self app add: element; yourself!

pageFrameWith: aWebElement wide: aWideElement title: aTitleString printHeader: aHeaderElement
	"set a web page with standard  page look (navigation bar, header) "
	"Wide element comes below content besides navigation and it have full page width"
	"printHeader if exist is added first, out of all other elements"
	| element containerId |
	self app clear;  title: aTitleString. self app htmlHeaderElements.
"	self app	add: self headerBanner. "
	containerId := aHeaderElement elements notEmpty ifTrue: [#containerPadded] ifFalse: [#container].
	element := (WebElement newId: containerId)
		add: self headerElement; 	add: self headerDashboard;
		add: ((WebElement newId: #content) 
			add: self navigationBarElement; add: aWebElement;  yourself); 
		add: ((WebElement newId: #contentWide)
			add: aWideElement; yourself);
		yourself.
	^self app 
		add: aHeaderElement; "print header"
		add: element; yourself!

pageWidth
	^800!

passwordText
	^'Password: '!

pasteIconGif
	"'imgs/jure-paste.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 11 0 12 0 196 0 0 0 0 0 255 255 255 242 244 240 139 158 117 152 169 132 177 190 162 203 212 193 216 222 209 49 82 9 62 93 24 88 115 55 101 125 71 114 136 86 127 147 102 165 179 147 229 233 224 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 16 0 44 0 0 0 0 11 0 12 0 64 5 59 96 32 142 164 120 32 8 83 142 4 90 4 45 98 136 15 106 35 137 32 42 55 126 136 133 197 226 183 18 17 142 4 135 65 39 50 160 22 4 158 76 196 64 53 6 9 220 8 165 48 120 73 5 20 161 72 22 133 0 0 59 ]!

pdfBigGif
	"'imgs/pdf_icon.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 35 0 35 0 135 0 0 48 49 51 56 55 58 59 59 60 62 62 65 59 67 59 60 69 60 77 1 1 66 65 67 66 66 68 69 69 69 71 71 73 73 73 76 79 79 83 79 91 79 82 82 86 84 84 86 84 84 88 90 90 93 93 93 94 95 95 97 96 96 99 98 98 101 101 101 102 103 103 104 104 104 109 108 108 110 110 110 114 114 114 117 121 121 122 122 122 126 121 121 129 185 79 82 179 88 89 201 1 4 206 3 6 208 2 6 215 3 6 214 5 8 217 4 7 221 6 9 225 5 8 230 7 10 227 8 11 234 6 9 236 7 10 236 8 12 242 8 11 241 10 13 245 9 12 247 12 15 255 7 10 248 10 13 255 10 14 247 13 16 250 14 17 254 14 17 254 18 21 249 23 26 254 22 25 254 25 29 255 28 31 255 30 33 228 63 63 234 50 50 255 33 37 255 37 41 255 40 43 255 41 45 255 46 49 255 48 50 255 53 55 255 53 57 255 56 58 255 57 60 255 61 63 255 62 64 214 109 112 222 123 124 226 78 78 232 76 76 231 87 88 230 88 88 231 91 92 230 93 94 234 87 87 233 89 89 236 89 89 255 71 74 255 81 83 255 91 93 254 93 96 232 96 97 234 100 100 232 105 106 233 108 108 230 112 112 230 115 116 231 124 125 236 117 118 233 121 122 233 123 124 254 98 101 251 109 111 252 110 112 254 114 116 255 119 122 255 122 124 222 127 129 227 127 129 254 126 128 129 129 130 133 133 137 141 141 141 143 143 145 143 143 148 137 156 137 145 145 148 150 150 154 151 151 156 153 153 154 154 154 157 159 159 159 159 159 163 159 159 168 145 166 145 156 178 156 163 163 164 165 165 168 166 166 174 167 169 175 170 167 175 169 169 173 169 169 177 173 172 178 174 174 181 176 176 178 177 176 181 181 181 182 180 180 185 181 182 189 185 185 189 188 188 191 187 187 194 189 188 194 190 190 197 173 199 173 178 204 178 182 208 182 186 213 186 189 217 189 214 140 143 217 135 138 211 157 160 221 176 179 225 129 131 230 129 130 228 131 132 232 134 135 233 135 136 235 136 137 235 139 140 238 141 142 226 145 146 231 144 146 232 153 155 232 156 157 252 132 133 253 135 136 253 138 139 253 143 144 252 146 148 252 150 152 231 158 160 230 160 162 230 165 167 231 167 170 236 162 163 233 171 172 234 173 174 234 175 176 225 181 181 232 177 178 235 182 183 236 179 180 239 182 182 234 182 184 194 194 194 193 192 198 197 197 198 194 194 201 196 195 202 197 197 202 198 198 204 196 201 196 200 199 206 200 200 200 200 201 205 202 202 208 203 204 209 205 205 210 205 206 212 192 220 192 196 218 196 201 209 201 200 218 200 209 209 213 210 212 214 214 214 214 212 212 217 215 215 220 209 216 209 216 216 219 217 217 221 219 220 223 220 220 222 222 221 225 223 224 227 229 197 200 238 193 194 235 198 200 228 221 223 236 209 210 237 215 216 235 216 217 235 218 220 236 220 221 254 219 220 228 222 224 238 223 225 224 224 225 226 226 229 228 228 230 230 230 233 229 229 236 231 232 234 233 225 228 232 231 234 238 230 232 232 232 234 234 234 236 235 236 238 239 232 233 236 235 237 236 236 238 238 238 240 234 241 246 240 228 228 255 224 224 240 240 241 243 243 244 245 245 246 247 247 248 251 251 251 251 251 252 254 254 254 0 0 0 33 249 4 3 0 0 201 0 44 0 0 0 0 35 0 35 0 0 8 255 0 147 9 28 72 176 160 193 131 8 17 82 146 36 41 18 195 135 12 41 81 74 72 81 96 165 57 132 2 17 26 100 232 16 162 142 27 7 37 26 20 172 226 193 139 128 2 5 18 84 168 144 161 150 131 98 14 186 195 107 24 179 132 168 84 165 66 117 202 84 155 54 106 210 164 65 67 244 140 209 163 102 62 216 73 84 110 152 180 74 7 87 149 209 130 229 202 18 36 68 132 104 13 194 21 72 15 30 59 116 228 192 97 192 207 32 127 214 120 45 139 90 53 73 145 123 226 218 220 16 71 55 11 13 186 226 102 184 88 177 194 192 32 63 254 252 53 93 91 80 213 21 37 69 132 136 219 33 110 174 140 187 56 196 217 168 241 162 133 10 20 6 14 229 9 140 86 23 225 129 169 150 24 17 2 132 174 154 185 58 24 71 22 103 170 69 138 19 36 12 32 250 195 89 240 48 101 4 83 29 33 18 164 199 189 29 59 122 136 227 161 163 177 184 24 47 86 156 40 49 194 64 163 68 112 162 231 209 245 140 23 65 84 137 135 12 185 199 187 52 93 45 54 196 237 255 69 97 66 68 8 3 137 70 198 252 147 231 142 174 73 3 79 25 65 130 196 72 226 32 64 194 234 184 97 67 239 10 20 36 132 112 222 49 198 16 227 203 35 140 48 226 135 31 125 12 4 130 1 16 70 40 225 132 20 94 19 141 51 199 0 179 139 35 139 252 49 7 69 23 21 115 12 52 212 88 131 205 57 230 112 227 4 45 231 160 120 13 53 208 32 35 204 46 144 64 242 97 66 23 65 51 141 53 215 84 131 141 57 41 174 216 162 57 47 198 56 163 47 192 220 136 208 69 214 80 115 77 57 39 170 243 206 60 83 212 242 206 59 234 156 131 13 140 25 10 67 140 146 39 205 81 14 143 230 156 227 206 60 244 116 227 195 24 104 206 227 206 57 22 58 83 76 49 200 128 105 208 69 112 70 41 15 62 248 132 178 137 23 218 208 67 207 60 234 152 83 77 140 199 52 99 103 65 23 169 83 142 57 232 184 67 15 62 237 84 225 141 45 92 8 74 207 59 112 78 211 12 50 138 130 56 135 163 144 190 35 40 46 83 12 10 198 39 242 204 51 15 58 229 80 255 227 76 51 161 226 56 135 60 144 186 35 15 61 246 80 113 203 160 237 120 97 69 41 179 200 226 74 38 206 24 227 204 162 4 93 132 206 179 238 192 67 79 40 80 144 163 77 41 160 108 210 197 22 63 64 193 70 19 151 16 179 172 168 238 68 122 229 55 79 192 18 139 44 219 128 227 234 59 217 136 162 201 26 150 0 83 235 146 115 96 201 142 59 235 116 66 70 59 248 12 250 46 58 68 70 131 9 19 189 220 27 38 60 238 176 83 11 43 82 128 83 15 29 135 160 147 142 4 4 255 146 1 58 197 248 2 201 49 204 14 116 209 166 164 180 242 197 43 229 30 96 1 58 190 44 144 14 48 199 56 208 12 52 139 44 242 72 200 22 205 129 79 46 97 120 194 137 59 234 92 99 193 27 138 8 48 65 28 3 216 177 0 2 127 68 0 129 33 56 39 115 81 62 180 136 49 138 58 207 242 66 129 27 23 236 66 1 5 139 40 240 134 30 1 96 128 0 212 162 238 147 15 61 242 148 139 14 30 21 88 224 0 36 17 76 96 72 2 29 212 1 128 6 132 32 90 18 245 69 253 232 147 207 60 239 148 235 198 49 135 112 48 193 6 114 48 80 135 3 16 236 241 128 7 104 219 234 15 63 106 211 3 15 167 216 196 10 77 178 51 114 168 136 33 132 56 242 55 31 13 16 80 192 234 172 183 238 58 235 4 52 192 71 69 145 240 49 199 237 184 231 174 187 238 124 68 98 210 239 192 7 47 188 64 1 1 0 59 ]!

pdfMediumGif
	"'imgs/sigov-pdf.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 16 0 16 0 247 0 0 0 0 0 128 0 0 0 128 0 128 128 0 0 0 128 128 0 128 0 128 128 192 192 192 192 220 192 166 202 240 0 0 0 16 16 16 255 0 0 231 41 41 231 49 49 239 57 57 231 57 66 231 66 66 231 74 74 239 66 74 231 82 90 231 90 90 239 82 82 239 90 90 231 99 99 231 107 107 231 115 115 231 123 123 231 132 132 231 140 140 231 156 156 231 173 173 231 181 181 231 181 189 231 189 189 222 206 206 222 214 214 222 222 222 222 231 231 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 255 251 240 160 160 164 128 128 128 255 0 0 0 255 0 255 255 0 0 0 255 255 0 255 0 255 255 255 255 255 33 249 4 1 0 0 39 0 44 0 0 0 0 16 0 16 0 0 8 130 0 79 8 4 64 176 96 193 5 11 4 42 4 80 162 161 195 134 11 24 36 52 72 145 96 137 136 18 1 48 216 200 145 35 195 131 26 59 118 100 232 112 65 69 138 15 19 14 124 40 225 195 195 139 11 31 66 240 240 82 229 9 146 13 27 104 112 104 2 230 202 134 30 70 116 200 144 50 102 9 18 23 62 128 112 240 32 2 133 16 54 73 114 136 208 97 3 136 15 29 48 76 136 90 162 66 132 151 71 69 68 205 32 97 4 216 18 38 162 90 56 91 82 33 194 183 112 225 6 4 0 59 ]!

pdfSmallGif
	"'imgs/ibm-pdf.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 11 0 12 0 162 0 0 0 0 0 204 204 204 153 153 153 204 0 0 255 255 255 254 1 2 0 0 0 0 0 0 33 249 4 5 20 0 5 0 44 0 0 0 0 11 0 12 0 0 3 39 72 176 204 42 48 6 48 169 157 181 181 192 129 226 193 48 128 30 197 137 228 119 142 157 138 162 101 40 206 67 137 130 45 192 226 147 162 53 9 0 59 ]!

pdfSmallPng
	"'imgs/ikone-dok/corendal-pdf.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 131 73 68 65 84 120 156 98 248 15 3 183 111 223 222 186 117 235 198 141 27 55 108 216 0 33 33 96 243 230 205 47 94 188 128 43 3 8 32 6 56 235 200 145 35 135 15 159 222 183 239 216 158 61 135 118 237 58 176 105 211 142 21 43 214 116 116 244 222 191 127 31 168 237 209 163 71 16 101 0 1 196 240 175 182 225 127 118 238 255 144 240 255 158 190 255 157 92 255 219 57 252 183 176 254 111 100 250 91 223 248 182 148 92 99 99 235 239 223 191 129 122 214 172 89 3 209 3 16 64 12 255 75 203 255 155 91 253 87 82 253 47 38 245 159 87 232 63 59 247 127 70 214 175 140 44 47 25 89 87 51 177 22 21 149 252 6 3 160 158 245 235 215 191 121 243 6 32 128 24 254 39 165 252 215 208 254 47 45 255 95 88 226 63 143 192 127 86 206 95 140 44 239 24 89 110 51 178 116 51 50 119 117 245 150 150 86 20 23 151 214 215 55 246 244 244 221 188 121 19 32 128 24 174 75 201 2 37 176 162 70 86 246 103 207 158 157 62 125 250 232 209 163 187 119 239 62 113 226 196 161 67 135 0 2 8 225 233 227 199 143 95 185 114 229 204 153 51 23 46 92 184 119 239 222 229 160 224 59 183 111 63 120 240 224 198 141 27 151 46 93 2 202 2 141 223 179 103 15 64 0 161 104 0 74 95 189 122 245 238 221 187 95 190 124 185 239 239 247 248 209 99 160 163 159 62 125 10 12 241 115 231 206 61 124 248 112 251 246 237 0 1 132 162 225 201 147 39 183 110 221 2 42 122 113 251 246 93 27 235 23 179 230 2 117 190 123 247 14 168 7 104 249 243 231 207 55 109 218 4 16 64 40 26 128 66 64 99 190 126 253 250 170 182 230 229 219 143 207 250 39 188 90 181 250 219 183 111 192 136 3 26 244 242 229 75 160 6 128 0 66 209 0 52 251 213 171 87 175 47 95 123 233 227 251 114 213 42 32 122 238 233 245 220 195 227 109 112 240 237 150 182 143 31 63 2 53 0 4 16 138 134 79 159 62 125 254 252 249 113 116 244 171 61 251 222 223 186 243 254 195 167 15 255 255 63 121 251 225 198 182 157 151 83 51 129 102 1 53 0 4 16 138 134 247 143 158 62 138 75 120 218 219 15 212 246 250 245 107 160 11 129 174 7 134 4 208 61 103 207 158 5 6 6 80 3 64 0 161 104 120 88 80 248 180 176 16 104 53 208 247 64 207 220 185 115 7 24 166 23 47 94 4 6 244 129 3 7 46 95 190 12 212 0 16 64 8 13 192 216 1 146 223 191 127 127 251 246 45 208 118 96 148 1 19 15 68 15 48 30 142 29 59 6 212 0 76 133 0 1 132 208 112 248 240 97 71 71 71 53 28 64 94 94 30 40 187 119 239 94 128 0 3 0 11 108 48 6 214 146 182 59 0 0 0 0 73 69 78 68 174 66 96 130 ]!

powerpointSmallPng
	"'imgs/ikone-dok/corendal-powerpoint.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 166 73 68 65 84 120 156 98 248 15 3 155 14 221 216 120 240 250 134 3 215 214 237 187 178 118 239 165 213 187 46 174 218 121 126 197 182 179 203 182 157 94 186 229 212 191 127 80 101 0 1 196 112 187 57 9 136 110 54 38 92 173 137 185 80 30 113 166 48 228 120 182 255 225 84 239 253 137 30 123 227 92 63 127 255 247 246 203 223 57 171 15 152 123 167 254 3 107 2 8 32 144 6 32 245 239 249 237 13 241 46 19 173 140 129 104 110 172 199 183 107 199 128 130 64 13 95 190 255 123 255 229 239 212 37 59 119 29 189 2 209 3 16 64 12 55 27 226 129 170 215 187 91 254 249 242 254 255 239 239 97 60 252 64 61 109 218 186 64 61 219 35 28 191 252 248 251 254 235 223 201 139 182 3 85 67 16 64 0 49 92 173 141 1 154 253 231 243 219 255 127 126 253 255 251 27 168 225 102 164 246 135 217 233 64 193 245 1 214 19 214 93 131 160 165 123 238 44 217 125 23 168 1 32 128 24 46 150 71 76 50 213 253 90 237 244 174 41 228 69 127 214 30 127 253 15 211 179 62 44 43 1 10 46 113 55 249 252 3 228 164 151 31 254 60 124 243 103 225 174 187 102 94 41 0 1 196 112 166 48 120 162 181 201 135 147 211 63 156 93 248 97 111 247 135 137 233 32 180 32 31 168 97 166 141 14 220 134 251 175 126 207 221 113 15 168 1 32 128 24 78 100 251 3 109 255 48 39 238 195 209 73 31 182 53 126 152 89 248 97 90 246 135 137 32 119 246 26 170 2 141 127 245 241 239 147 183 127 238 190 252 61 115 219 3 160 6 128 0 98 56 156 230 13 241 244 135 185 177 31 150 102 125 152 150 241 97 82 244 6 75 125 160 96 179 134 28 220 134 91 207 126 79 221 252 8 168 1 32 128 24 14 36 122 64 130 245 96 73 244 68 115 131 73 102 122 64 6 144 11 20 172 81 144 120 241 254 207 163 55 127 238 188 248 125 237 201 175 254 141 143 129 26 0 2 136 1 24 216 59 162 156 54 5 219 174 242 177 88 228 98 12 114 183 137 122 135 142 98 131 138 76 153 148 8 220 134 75 15 127 117 173 123 2 212 0 16 64 12 240 164 49 115 197 190 23 31 128 1 242 23 72 62 127 255 231 233 219 63 15 95 255 6 154 125 253 233 175 203 143 126 157 187 247 179 117 205 51 160 6 128 0 66 104 152 182 108 247 163 55 191 129 14 128 132 9 220 108 8 58 117 251 71 227 242 231 64 13 0 1 132 208 0 140 127 160 207 110 61 255 125 243 217 239 27 79 127 93 123 242 251 242 163 223 23 30 252 60 115 247 199 201 219 63 143 223 250 81 179 228 37 80 3 64 0 33 52 0 227 255 210 163 95 243 118 220 7 6 223 212 45 143 38 110 124 212 179 254 73 199 218 167 45 171 159 53 44 127 94 189 244 69 197 226 215 64 13 0 1 132 208 0 228 16 131 0 2 12 0 18 21 0 105 149 238 239 221 0 0 0 0 73 69 78 68 174 66 96 130 ]!

printCssResource
	" /print.css , returns all cssPrint* methods (alphabetically sorted) concatenated "
	"WebStyle new printCssResource"
	^self resources at: #cssPrint ifAbsentPut:
		[WebMethodResource 
			fromMethod: #printStyleSheet on: self 
			contentType: 'text/css' preferedUrl: '/print.css' site: self site].!

printerJpg
	"'imgs/toledo-printer.jpg' asFilename contentsAsMethod"
^#[255 216 255 224 0 16 74 70 73 70 0 1 1 1 0 72 0 72 0 0 255 219 0 67 0 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 219 0 67 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 1 255 192 0 17 8 0 22 0 20 3 1 34 0 2 17 1 3 17 1 255 196 0 31 0 0 1 5 1 1 1 1 1 1 0 0 0 0 0 0 0 0 1 2 3 4 5 6 7 8 9 10 11 255 196 0 181 16 0 2 1 3 3 2 4 3 5 5 4 4 0 0 1 125 1 2 3 0 4 17 5 18 33 49 65 6 19 81 97 7 34 113 20 50 129 145 161 8 35 66 177 193 21 82 209 240 36 51 98 114 130 9 10 22 23 24 25 26 37 38 39 40 41 42 52 53 54 55 56 57 58 67 68 69 70 71 72 73 74 83 84 85 86 87 88 89 90 99 100 101 102 103 104 105 106 115 116 117 118 119 120 121 122 131 132 133 134 135 136 137 138 146 147 148 149 150 151 152 153 154 162 163 164 165 166 167 168 169 170 178 179 180 181 182 183 184 185 186 194 195 196 197 198 199 200 201 202 210 211 212 213 214 215 216 217 218 225 226 227 228 229 230 231 232 233 234 241 242 243 244 245 246 247 248 249 250 255 196 0 31 1 0 3 1 1 1 1 1 1 1 1 1 0 0 0 0 0 0 1 2 3 4 5 6 7 8 9 10 11 255 196 0 181 17 0 2 1 2 4 4 3 4 7 5 4 4 0 1 2 119 0 1 2 3 17 4 5 33 49 6 18 65 81 7 97 113 19 34 50 129 8 20 66 145 161 177 193 9 35 51 82 240 21 98 114 209 10 22 36 52 225 37 241 23 24 25 26 38 39 40 41 42 53 54 55 56 57 58 67 68 69 70 71 72 73 74 83 84 85 86 87 88 89 90 99 100 101 102 103 104 105 106 115 116 117 118 119 120 121 122 130 131 132 133 134 135 136 137 138 146 147 148 149 150 151 152 153 154 162 163 164 165 166 167 168 169 170 178 179 180 181 182 183 184 185 186 194 195 196 197 198 199 200 201 202 210 211 212 213 214 215 216 217 218 226 227 228 229 230 231 232 233 234 242 243 244 245 246 247 248 249 250 255 218 0 12 3 1 0 2 17 3 17 0 63 0 254 205 254 42 248 150 223 225 223 197 164 93 102 105 46 244 31 136 158 17 147 94 211 18 238 254 241 97 208 252 73 224 43 237 63 68 214 173 99 34 230 24 173 237 252 71 163 120 191 68 190 210 236 98 24 55 62 26 241 93 244 155 140 200 34 229 126 19 124 105 117 253 160 238 188 7 37 196 255 0 240 175 190 32 252 59 26 247 132 181 11 155 139 137 180 93 39 226 103 131 53 147 99 226 111 6 218 106 183 114 73 109 30 173 226 239 7 235 26 87 138 244 79 14 165 201 190 189 183 240 71 143 181 123 75 87 180 210 245 57 45 190 102 241 254 183 30 181 226 47 136 94 33 248 185 55 196 63 7 90 106 255 0 16 126 34 248 58 215 197 119 26 222 181 109 240 235 89 240 87 194 223 138 94 59 208 188 45 163 105 154 239 132 245 43 221 47 193 239 6 139 100 210 106 122 30 191 31 132 124 109 172 234 218 150 179 172 120 58 227 84 212 144 220 105 158 7 175 254 208 191 0 175 109 78 145 240 235 225 245 231 142 32 136 188 95 240 144 234 22 158 34 214 244 141 57 132 13 9 212 127 225 97 252 81 215 244 123 61 46 242 202 218 121 26 41 238 175 36 241 21 128 103 146 207 66 186 12 209 201 239 75 52 203 231 147 44 12 178 185 60 198 209 143 246 146 197 168 193 66 157 104 78 31 236 107 12 249 167 236 99 236 37 47 172 71 79 222 107 38 209 229 172 22 49 102 127 92 89 132 150 13 198 207 47 116 28 147 147 167 200 218 174 235 174 85 237 57 106 164 168 189 83 141 236 238 191 160 10 43 241 175 246 28 253 178 124 109 227 31 134 190 55 182 212 116 169 47 52 191 7 252 80 191 240 207 131 207 136 245 185 53 237 106 223 194 23 94 4 248 127 227 45 34 11 205 114 218 218 198 61 86 47 51 197 183 115 233 211 165 172 22 214 218 84 246 58 118 153 20 122 69 150 159 26 21 243 240 148 103 8 206 46 241 156 99 56 187 53 120 205 41 69 217 164 213 211 78 205 38 186 164 207 77 53 40 198 73 221 74 42 81 125 212 146 105 217 234 174 154 118 122 247 62 203 248 175 251 47 248 138 254 251 198 158 45 248 17 241 22 79 135 218 255 0 143 45 117 51 227 127 135 94 50 178 159 198 223 2 188 125 171 234 54 115 91 73 226 61 71 194 82 220 65 173 120 7 198 51 23 140 223 248 179 225 158 181 225 248 252 67 177 102 241 223 134 252 111 113 109 166 201 97 249 109 225 63 248 36 79 237 11 23 139 244 255 0 29 248 255 0 226 183 192 63 21 120 147 80 182 182 131 81 130 227 195 63 23 117 63 1 252 62 22 75 50 66 124 25 240 230 247 199 22 154 95 139 238 164 136 219 43 203 174 234 190 18 209 37 187 130 107 237 95 195 26 242 94 77 96 10 43 69 38 148 146 229 247 151 43 188 99 38 149 212 189 215 36 220 29 210 247 160 227 43 94 55 229 148 147 127 215 245 223 230 126 161 124 27 253 136 62 28 124 42 240 222 167 166 234 254 40 241 175 196 143 18 248 143 94 147 197 30 41 241 126 187 54 129 225 79 237 29 102 77 23 68 240 250 71 163 120 59 225 190 135 224 239 2 248 63 195 246 58 71 135 180 171 45 43 195 158 25 240 237 134 159 99 20 12 248 158 230 121 238 37 40 162 164 15 255 217 ]!

printSeconds: aNumber

	^(aNumber // 3600) printString, ':',
	(self twoDigits: aNumber \\ 3600 // 60), ':',
	(self twoDigits: aNumber \\ 60)!

printStamp: aTimestamp

	| stamp |
	stamp := (aTimestamp isKindOf: Integer)
		ifTrue: [Timestamp fromSeconds: aTimestamp]
		ifFalse: [aTimestamp isNil 
			ifTrue: [Timestamp now] ifFalse: [aTimestamp]].
	^stamp asDate shortPrintSloString, ' ', 
		stamp asTime hours printString, ':', 
		(self twoDigits: stamp asTime minutes)!

printStyleSheet
	"concatenate all cssPrint* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new printStyleSheet"
	| stream |
	stream := WriteStream on: String new.
	self allCssPrintMethods do: [:method | 
		stream nextPut: Character cr.
		stream nextPutAll: ('/*', self class name, ' ', method asString, '*/').
		stream nextPut: Character cr.
		stream nextPutAll: (self perform: method)].
	^stream contents!

redPixelGif
	"'imgs/redpix.gif' asFilename contentsAsMethod"
	 ^#[71 73 70 56 57 97 1 0 1 0 145 255 0 255 255 255 196 0 67 
		0 0 0 0 0 0 44 0 0 0 0 1 0 1 0 0 2 2 76 1 0 59 ]!

reportHeaderColor
	^#silver!

resources
	resources isNil ifTrue: [self initResources].
	^resources!

richEditorCssResource
	" for JavaScript rich text editor, see WebRichEditor"
	"WebStyle new richEditorCssResource"
	^self resources at: #cssRichEditor ifAbsentPut:
		[WebMethodResource 
			fromMethod: #richEditorStyleSheet on: self 
			contentType: 'text/css' preferedUrl: '/rich-editor.css' site: self site].!

richEditorStyleSheet
	" for  text area in JavaScript rich text editor, see WebRichEditor"
	"WebStyle new richEditorStyleSheet"
	| stream |
	stream := WriteStream on: String new.
	stream nextPutAll: '
body {
	font-family: verdana, sans-serif;
	font-color: #666;
	font-size: 90%;
	background-color: #FFFFFF;
.mceVisualAid {
	border: 1px dashed #BBBBBB;
	}
'.
	#(css21Text css22Links) do: [:method | 
		stream nextPut: Character cr.
		stream nextPutAll: ('/*', self class name, ' ', method asString, '*/').
		stream nextPut: Character cr.
		stream nextPutAll: (self perform: method)].
	^stream contents!

screenCssResource
	" /screen.css , returns all css* methods (alphabetically sorted) concatenated "
	"WebStyle new screenCssResource"
	^self resources at: #cssScreen ifAbsentPut:
		[WebMethodResource 
			fromMethod: #screenStyleSheet on: self 
			contentType: 'text/css' preferedUrl: '/screen.css' site: self site].!

screenStyleSheet
	"concatenate all css* methods together, sorted my method name alphabeticaly!! "
	"WebStyle new screenStyleSheet"
	| stream |
	stream := WriteStream on: String new.
	self allCssScreenMethods do: [:method | 
		stream nextPut: Character cr.
		stream nextPutAll: ('/*', self class name, ' ', method asString, '*/').
		stream nextPut: Character cr.
		stream nextPutAll: (self perform: method)].
	^stream contents!

scriptaculousBuilderJs
	"builder.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// Copyright (c) 2005 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//
// See scriptaculous.js for full license.

var Builder = {
  NODEMAP: {
    AREA: ''map'',
    CAPTION: ''table'',
    COL: ''table'',
    COLGROUP: ''table'',
    LEGEND: ''fieldset'',
    OPTGROUP: ''select'',
    OPTION: ''select'',
    PARAM: ''object'',
    TBODY: ''table'',
    TD: ''table'',
    TFOOT: ''table'',
    TH: ''table'',
    THEAD: ''table'',
    TR: ''table''
  },
  // note: For Firefox < 1.5, OPTION and OPTGROUP tags are currently broken,
  //       due to a Firefox bug
  node: function(elementName) {
    elementName = elementName.toUpperCase();
    
    // try innerHTML approach
    var parentTag = this.NODEMAP[elementName] || ''div'';
    var parentElement = document.createElement(parentTag);
    try { // prevent IE "feature": http://dev.rubyonrails.org/ticket/2707
      parentElement.innerHTML = "<" + elementName + "></" + elementName + ">";
    } catch(e) {}
    var element = parentElement.firstChild || null;
      
    // see if browser added wrapping tags
    if(element && (element.tagName !!= elementName))
      element = element.getElementsByTagName(elementName)[0];
    
    // fallback to createElement approach
    if(!!element) element = document.createElement(elementName);
    
    // abort if nothing could be created
    if(!!element) return;

    // attributes (or text)
    if(arguments[1])
      if(this._isStringOrNumber(arguments[1]) ||
        (arguments[1] instanceof Array)) {
          this._children(element, arguments[1]);
        } else {
          var attrs = this._attributes(arguments[1]);
          if(attrs.length) {
            try { // prevent IE "feature": http://dev.rubyonrails.org/ticket/2707
              parentElement.innerHTML = "<" +elementName + " " +
                attrs + "></" + elementName + ">";
            } catch(e) {}
            element = parentElement.firstChild || null;
            // workaround firefox 1.0.X bug
            if(!!element) {
              element = document.createElement(elementName);
              for(attr in arguments[1]) 
                element[attr == ''class'' ? ''className'' : attr] = arguments[1][attr];
            }
            if(element.tagName !!= elementName)
              element = parentElement.getElementsByTagName(elementName)[0];
            }
        } 

    // text, or array of children
    if(arguments[2])
      this._children(element, arguments[2]);

     return element;
  },
  _text: function(text) {
     return document.createTextNode(text);
  },
  _attributes: function(attributes) {
    var attrs = [];
    for(attribute in attributes)
      attrs.push((attribute==''className'' ? ''class'' : attribute) +
          ''="'' + attributes[attribute].toString().escapeHTML() + ''"'');
    return attrs.join(" ");
  },
  _children: function(element, children) {
    if(typeof children==''object'') { // array can hold nodes and text
      children.flatten().each( function(e) {
        if(typeof e==''object'')
          element.appendChild(e)
        else
          if(Builder._isStringOrNumber(e))
            element.appendChild(Builder._text(e));
      });
    } else
      if(Builder._isStringOrNumber(children)) 
         element.appendChild(Builder._text(children));
  },
  _isStringOrNumber: function(param) {
    return(typeof param==''string'' || typeof param==''number'');
  }
}
'!

scriptaculousBuilderJsResource
	"WebStyle new scriptaculousBuilderJsResource"
	^self resources at: #jsScriptaculousBuilder ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousBuilderJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/builder.js' site: self site].!

scriptaculousControlsJs
	"controls.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// Copyright (c) 2005 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
//           (c) 2005 Ivan Krstic (http://blogs.law.harvard.edu/ivan)
//           (c) 2005 Jon Tirsen (http://www.tirsen.com)
// Contributors:
//  Richard Livsey
//  Rahul Bhargava
//  Rob Wills
// 
// See scriptaculous.js for full license.

// Autocompleter.Base handles all the autocompletion functionality 
// that''s independent of the data source for autocompletion. This
// includes drawing the autocompletion menu, observing keyboard
// and mouse events, and similar.
//
// Specific autocompleters need to provide, at the very least, 
// a getUpdatedChoices function that will be invoked every time
// the text inside the monitored textbox changes. This method 
// should get the text for which to provide autocompletion by
// invoking this.getToken(), NOT by directly accessing
// this.element.value. This is to allow incremental tokenized
// autocompletion. Specific auto-completion logic (AJAX, etc)
// belongs in getUpdatedChoices.
//
// Tokenized incremental autocompletion is enabled automatically
// when an autocompleter is instantiated with the ''tokens'' option
// in the options parameter, e.g.:
// new Ajax.Autocompleter(''id'',''upd'', ''/url/'', { tokens: '','' });
// will incrementally autocomplete with a comma as the token.
// Additionally, '','' in the above example can be replaced with
// a token array, e.g. { tokens: ['','', ''\n''] } which
// enables autocompletion on multiple tokens. This is most 
// useful when one of the tokens is \n (a newline), as it 
// allows smart autocompletion after linebreaks.

var Autocompleter = {}
Autocompleter.Base = function() {};
Autocompleter.Base.prototype = {
  baseInitialize: function(element, update, options) {
    this.element     = $(element); 
    this.update      = $(update);  
    this.hasFocus    = false; 
    this.changed     = false; 
    this.active      = false; 
    this.index       = 0;     
    this.entryCount  = 0;

    if (this.setOptions)
      this.setOptions(options);
    else
      this.options = options || {};

    this.options.paramName    = this.options.paramName || this.element.name;
    this.options.tokens       = this.options.tokens || [];
    this.options.frequency    = this.options.frequency || 0.4;
    this.options.minChars     = this.options.minChars || 1;
    this.options.onShow       = this.options.onShow || 
    function(element, update){ 
      if(!!update.style.position || update.style.position==''absolute'') {
        update.style.position = ''absolute'';
        Position.clone(element, update, {setHeight: false, offsetTop: element.offsetHeight});
      }
      Effect.Appear(update,{duration:0.15});
    };
    this.options.onHide = this.options.onHide || 
    function(element, update){ new Effect.Fade(update,{duration:0.15}) };

    if (typeof(this.options.tokens) == ''string'') 
      this.options.tokens = new Array(this.options.tokens);

    this.observer = null;
    
    this.element.setAttribute(''autocomplete'',''off'');

    Element.hide(this.update);

    Event.observe(this.element, "blur", this.onBlur.bindAsEventListener(this));
    Event.observe(this.element, "keypress", this.onKeyPress.bindAsEventListener(this));
  },

  show: function() {
    if(Element.getStyle(this.update, ''display'')==''none'') this.options.onShow(this.element, this.update);
    if(!!this.iefix && 
      (navigator.appVersion.indexOf(''MSIE'')>0) &&
      (navigator.userAgent.indexOf(''Opera'')<0) &&
      (Element.getStyle(this.update, ''position'')==''absolute'')) {
      new Insertion.After(this.update, 
       ''<iframe id="'' + this.update.id + ''_iefix" ''+
       ''style="display:none;position:absolute;filter:progid:DXImageTransform.Microsoft.Alpha(opacity=0);" '' +
       ''src="javascript:false;" frameborder="0" scrolling="no"></iframe>'');
      this.iefix = $(this.update.id+''_iefix'');
    }
    if(this.iefix) setTimeout(this.fixIEOverlapping.bind(this), 50);
  },
  
  fixIEOverlapping: function() {
    Position.clone(this.update, this.iefix);
    this.iefix.style.zIndex = 1;
    this.update.style.zIndex = 2;
    Element.show(this.iefix);
  },

  hide: function() {
    this.stopIndicator();
    if(Element.getStyle(this.update, ''display'')!!=''none'') this.options.onHide(this.element, this.update);
    if(this.iefix) Element.hide(this.iefix);
  },

  startIndicator: function() {
    if(this.options.indicator) Element.show(this.options.indicator);
  },

  stopIndicator: function() {
    if(this.options.indicator) Element.hide(this.options.indicator);
  },

  onKeyPress: function(event) {
    if(this.active)
      switch(event.keyCode) {
       case Event.KEY_TAB:
       case Event.KEY_RETURN:
         this.selectEntry();
         Event.stop(event);
       case Event.KEY_ESC:
         this.hide();
         this.active = false;
         Event.stop(event);
         return;
       case Event.KEY_LEFT:
       case Event.KEY_RIGHT:
         return;
       case Event.KEY_UP:
         this.markPrevious();
         this.render();
         if(navigator.appVersion.indexOf(''AppleWebKit'')>0) Event.stop(event);
         return;
       case Event.KEY_DOWN:
         this.markNext();
         this.render();
         if(navigator.appVersion.indexOf(''AppleWebKit'')>0) Event.stop(event);
         return;
      }
     else 
      if(event.keyCode==Event.KEY_TAB || event.keyCode==Event.KEY_RETURN) 
        return;

    this.changed = true;
    this.hasFocus = true;

    if(this.observer) clearTimeout(this.observer);
      this.observer = 
        setTimeout(this.onObserverEvent.bind(this), this.options.frequency*1000);
  },

  onHover: function(event) {
    var element = Event.findElement(event, ''LI'');
    if(this.index !!= element.autocompleteIndex) 
    {
        this.index = element.autocompleteIndex;
        this.render();
    }
    Event.stop(event);
  },
  
  onClick: function(event) {
    var element = Event.findElement(event, ''LI'');
    this.index = element.autocompleteIndex;
    this.selectEntry();
    this.hide();
  },
  
  onBlur: function(event) {
    // needed to make click events working
    setTimeout(this.hide.bind(this), 250);
    this.hasFocus = false;
    this.active = false;     
  }, 
  
  render: function() {
    if(this.entryCount > 0) {
      for (var i = 0; i < this.entryCount; i++)
        this.index==i ? 
          Element.addClassName(this.getEntry(i),"selected") : 
          Element.removeClassName(this.getEntry(i),"selected");
        
      if(this.hasFocus) { 
        this.show();
        this.active = true;
      }
    } else {
      this.active = false;
      this.hide();
    }
  },
  
  markPrevious: function() {
    if(this.index > 0) this.index--
      else this.index = this.entryCount-1;
  },
  
  markNext: function() {
    if(this.index < this.entryCount-1) this.index++
      else this.index = 0;
  },
  
  getEntry: function(index) {
    return this.update.firstChild.childNodes[index];
  },
  
  getCurrentEntry: function() {
    return this.getEntry(this.index);
  },
  
  selectEntry: function() {
    this.active = false;
    this.updateElement(this.getCurrentEntry());
  },

  updateElement: function(selectedElement) {
    if (this.options.updateElement) {
      this.options.updateElement(selectedElement);
      return;
    }

    var value = Element.collectTextNodesIgnoreClass(selectedElement, ''informal'');
    var lastTokenPos = this.findLastToken();
    if (lastTokenPos !!= -1) {
      var newValue = this.element.value.substr(0, lastTokenPos + 1);
      var whitespace = this.element.value.substr(lastTokenPos + 1).match(/^\s+/);
      if (whitespace)
        newValue += whitespace[0];
      this.element.value = newValue + value;
    } else {
      this.element.value = value;
    }
    this.element.focus();
    
    if (this.options.afterUpdateElement)
      this.options.afterUpdateElement(this.element, selectedElement);
  },

  updateChoices: function(choices) {
    if(!!this.changed && this.hasFocus) {
      this.update.innerHTML = choices;
      Element.cleanWhitespace(this.update);
      Element.cleanWhitespace(this.update.firstChild);

      if(this.update.firstChild && this.update.firstChild.childNodes) {
        this.entryCount = 
          this.update.firstChild.childNodes.length;
        for (var i = 0; i < this.entryCount; i++) {
          var entry = this.getEntry(i);
          entry.autocompleteIndex = i;
          this.addObservers(entry);
        }
      } else { 
        this.entryCount = 0;
      }

      this.stopIndicator();

      this.index = 0;
      this.render();
    }
  },

  addObservers: function(element) {
    Event.observe(element, "mouseover", this.onHover.bindAsEventListener(this));
    Event.observe(element, "click", this.onClick.bindAsEventListener(this));
  },

  onObserverEvent: function() {
    this.changed = false;   
    if(this.getToken().length>=this.options.minChars) {
      this.startIndicator();
      this.getUpdatedChoices();
    } else {
      this.active = false;
      this.hide();
    }
  },

  getToken: function() {
    var tokenPos = this.findLastToken();
    if (tokenPos !!= -1)
      var ret = this.element.value.substr(tokenPos + 1).replace(/^\s+/,'''').replace(/\s+$/,'''');
    else
      var ret = this.element.value;

    return /\n/.test(ret) ? '''' : ret;
  },

  findLastToken: function() {
    var lastTokenPos = -1;

    for (var i=0; i<this.options.tokens.length; i++) {
      var thisTokenPos = this.element.value.lastIndexOf(this.options.tokens[i]);
      if (thisTokenPos > lastTokenPos)
        lastTokenPos = thisTokenPos;
    }
    return lastTokenPos;
  }
}

Ajax.Autocompleter = Class.create();
Object.extend(Object.extend(Ajax.Autocompleter.prototype, Autocompleter.Base.prototype), {
  initialize: function(element, update, url, options) {
	  this.baseInitialize(element, update, options);
    this.options.asynchronous  = true;
    this.options.onComplete    = this.onComplete.bind(this);
    this.options.defaultParams = this.options.parameters || null;
    this.url                   = url;
  },

  getUpdatedChoices: function() {
    entry = encodeURIComponent(this.options.paramName) + ''='' + 
      encodeURIComponent(this.getToken());

    this.options.parameters = this.options.callback ?
      this.options.callback(this.element, entry) : entry;

    if(this.options.defaultParams) 
      this.options.parameters += ''&'' + this.options.defaultParams;

    new Ajax.Request(this.url, this.options);
  },

  onComplete: function(request) {
    this.updateChoices(request.responseText);
  }

});

// The local array autocompleter. Used when you''d prefer to
// inject an array of autocompletion options into the page, rather
// than sending out Ajax queries, which can be quite slow sometimes.
//
// The constructor takes four parameters. The first two are, as usual,
// the id of the monitored textbox, and id of the autocompletion menu.
// The third is the array you want to autocomplete from, and the fourth
// is the options block.
//
// Extra local autocompletion options:
// - choices - How many autocompletion choices to offer
//
// - partialSearch - If false, the autocompleter will match entered
//                    text only at the beginning of strings in the 
//                    autocomplete array. Defaults to true, which will
//                    match text at the beginning of any *word* in the
//                    strings in the autocomplete array. If you want to
//                    search anywhere in the string, additionally set
//                    the option fullSearch to true (default: off).
//
// - fullSsearch - Search anywhere in autocomplete array strings.
//
// - partialChars - How many characters to enter before triggering
//                   a partial match (unlike minChars, which defines
//                   how many characters are required to do any match
//                   at all). Defaults to 2.
//
// - ignoreCase - Whether to ignore case when autocompleting.
//                 Defaults to true.
//
// It''s possible to pass in a custom function as the ''selector'' 
// option, if you prefer to write your own autocompletion logic.
// In that case, the other options above will not apply unless
// you support them.

Autocompleter.Local = Class.create();
Autocompleter.Local.prototype = Object.extend(new Autocompleter.Base(), {
  initialize: function(element, update, array, options) {
    this.baseInitialize(element, update, options);
    this.options.array = array;
  },

  getUpdatedChoices: function() {
    this.updateChoices(this.options.selector(this));
  },

  setOptions: function(options) {
    this.options = Object.extend({
      choices: 10,
      partialSearch: true,
      partialChars: 2,
      ignoreCase: true,
      fullSearch: false,
      selector: function(instance) {
        var ret       = []; // Beginning matches
        var partial   = []; // Inside matches
        var entry     = instance.getToken();
        var count     = 0;

        for (var i = 0; i < instance.options.array.length &&  
          ret.length < instance.options.choices ; i++) { 

          var elem = instance.options.array[i];
          var foundPos = instance.options.ignoreCase ? 
            elem.toLowerCase().indexOf(entry.toLowerCase()) : 
            elem.indexOf(entry);

          while (foundPos !!= -1) {
            if (foundPos == 0 && elem.length !!= entry.length) { 
              ret.push("<li><strong>" + elem.substr(0, entry.length) + "</strong>" + 
                elem.substr(entry.length) + "</li>");
              break;
            } else if (entry.length >= instance.options.partialChars && 
              instance.options.partialSearch && foundPos !!= -1) {
              if (instance.options.fullSearch || /\s/.test(elem.substr(foundPos-1,1))) {
                partial.push("<li>" + elem.substr(0, foundPos) + "<strong>" +
                  elem.substr(foundPos, entry.length) + "</strong>" + elem.substr(
                  foundPos + entry.length) + "</li>");
                break;
              }
            }

            foundPos = instance.options.ignoreCase ? 
              elem.toLowerCase().indexOf(entry.toLowerCase(), foundPos + 1) : 
              elem.indexOf(entry, foundPos + 1);

          }
        }
        if (partial.length)
          ret = ret.concat(partial.slice(0, instance.options.choices - ret.length))
        return "<ul>" + ret.join('''') + "</ul>";
      }
    }, options || {});
  }
});

// AJAX in-place editor
//
// see documentation on http://wiki.script.aculo.us/scriptaculous/show/Ajax.InPlaceEditor

// Use this if you notice weird scrolling problems on some browsers,
// the DOM might be a bit confused when this gets called so do this
// waits 1 ms (with setTimeout) until it does the activation
Field.scrollFreeActivate = function(field) {
  setTimeout(function() {
    Field.activate(field);
  }, 1);
}

Ajax.InPlaceEditor = Class.create();
Ajax.InPlaceEditor.defaultHighlightColor = "#FFFF99";
Ajax.InPlaceEditor.prototype = {
  initialize: function(element, url, options) {
    this.url = url;
    this.element = $(element);

    this.options = Object.extend({
      okText: "ok",
      cancelText: "cancel",
      savingText: "Saving...",
      clickToEditText: "Click to edit",
      okText: "ok",
      rows: 1,
      onComplete: function(transport, element) {
        new Effect.Highlight(element, {startcolor: this.options.highlightcolor});
      },
      onFailure: function(transport) {
        alert("Error communicating with the server: " + transport.responseText.stripTags());
      },
      callback: function(form) {
        return Form.serialize(form);
      },
      handleLineBreaks: true,
      loadingText: ''Loading...'',
      savingClassName: ''inplaceeditor-saving'',
      loadingClassName: ''inplaceeditor-loading'',
      formClassName: ''inplaceeditor-form'',
      highlightcolor: Ajax.InPlaceEditor.defaultHighlightColor,
      highlightendcolor: "#FFFFFF",
      externalControl:	null,
      ajaxOptions: {}
    }, options || {});

    if(!!this.options.formId && this.element.id) {
      this.options.formId = this.element.id + "-inplaceeditor";
      if ($(this.options.formId)) {
        // there''s already a form with that name, don''t specify an id
        this.options.formId = null;
      }
    }
    
    if (this.options.externalControl) {
      this.options.externalControl = $(this.options.externalControl);
    }
    
    this.originalBackground = Element.getStyle(this.element, ''background-color'');
    if (!!this.originalBackground) {
      this.originalBackground = "transparent";
    }
    
    this.element.title = this.options.clickToEditText;
    
    this.onclickListener = this.enterEditMode.bindAsEventListener(this);
    this.mouseoverListener = this.enterHover.bindAsEventListener(this);
    this.mouseoutListener = this.leaveHover.bindAsEventListener(this);
    Event.observe(this.element, ''click'', this.onclickListener);
    Event.observe(this.element, ''mouseover'', this.mouseoverListener);
    Event.observe(this.element, ''mouseout'', this.mouseoutListener);
    if (this.options.externalControl) {
      Event.observe(this.options.externalControl, ''click'', this.onclickListener);
      Event.observe(this.options.externalControl, ''mouseover'', this.mouseoverListener);
      Event.observe(this.options.externalControl, ''mouseout'', this.mouseoutListener);
    }
  },
  enterEditMode: function(evt) {
    if (this.saving) return;
    if (this.editing) return;
    this.editing = true;
    this.onEnterEditMode();
    if (this.options.externalControl) {
      Element.hide(this.options.externalControl);
    }
    Element.hide(this.element);
    this.createForm();
    this.element.parentNode.insertBefore(this.form, this.element);
    Field.scrollFreeActivate(this.editField);
    // stop the event to avoid a page refresh in Safari
    if (evt) {
      Event.stop(evt);
    }
    return false;
  },
  createForm: function() {
    this.form = document.createElement("form");
    this.form.id = this.options.formId;
    Element.addClassName(this.form, this.options.formClassName)
    this.form.onsubmit = this.onSubmit.bind(this);

    this.createEditField();

    if (this.options.textarea) {
      var br = document.createElement("br");
      this.form.appendChild(br);
    }

    okButton = document.createElement("input");
    okButton.type = "submit";
    okButton.value = this.options.okText;
    this.form.appendChild(okButton);

    cancelLink = document.createElement("a");
    cancelLink.href = "#";
    cancelLink.appendChild(document.createTextNode(this.options.cancelText));
    cancelLink.onclick = this.onclickCancel.bind(this);
    this.form.appendChild(cancelLink);
  },
  hasHTMLLineBreaks: function(string) {
    if (!!this.options.handleLineBreaks) return false;
    return string.match(/<br/i) || string.match(/<p>/i);
  },
  convertHTMLLineBreaks: function(string) {
    return string.replace(/<br>/gi, "\n").replace(/<br\/>/gi, "\n").replace(/<\/p>/gi, "\n").replace(/<p>/gi, "");
  },
  createEditField: function() {
    var text;
    if(this.options.loadTextURL) {
      text = this.options.loadingText;
    } else {
      text = this.getText();
    }
    
    if (this.options.rows == 1 && !!this.hasHTMLLineBreaks(text)) {
      this.options.textarea = false;
      var textField = document.createElement("input");
      textField.type = "text";
      textField.name = "value";
      textField.value = text;
      textField.style.backgroundColor = this.options.highlightcolor;
      var size = this.options.size || this.options.cols || 0;
      if (size !!= 0) textField.size = size;
      this.editField = textField;
    } else {
      this.options.textarea = true;
      var textArea = document.createElement("textarea");
      textArea.name = "value";
      textArea.value = this.convertHTMLLineBreaks(text);
      textArea.rows = this.options.rows;
      textArea.cols = this.options.cols || 40;
      this.editField = textArea;
    }
    
    if(this.options.loadTextURL) {
      this.loadExternalText();
    }
    this.form.appendChild(this.editField);
  },
  getText: function() {
    return this.element.innerHTML;
  },
  loadExternalText: function() {
    Element.addClassName(this.form, this.options.loadingClassName);
    this.editField.disabled = true;
    new Ajax.Request(
      this.options.loadTextURL,
      Object.extend({
        asynchronous: true,
        onComplete: this.onLoadedExternalText.bind(this)
      }, this.options.ajaxOptions)
    );
  },
  onLoadedExternalText: function(transport) {
    Element.removeClassName(this.form, this.options.loadingClassName);
    this.editField.disabled = false;
    this.editField.value = transport.responseText.stripTags();
  },
  onclickCancel: function() {
    this.onComplete();
    this.leaveEditMode();
    return false;
  },
  onFailure: function(transport) {
    this.options.onFailure(transport);
    if (this.oldInnerHTML) {
      this.element.innerHTML = this.oldInnerHTML;
      this.oldInnerHTML = null;
    }
    return false;
  },
  onSubmit: function() {
    // onLoading resets these so we need to save them away for the Ajax call
    var form = this.form;
    var value = this.editField.value;
    
    // do this first, sometimes the ajax call returns before we get a chance to switch on Saving...
    // which means this will actually switch on Saving... *after* we''ve left edit mode causing Saving...
    // to be displayed indefinitely
    this.onLoading();
    
    new Ajax.Updater(
      { 
        success: this.element,
         // don''t update on failure (this could be an option)
        failure: null
      },
      this.url,
      Object.extend({
        parameters: this.options.callback(form, value),
        onComplete: this.onComplete.bind(this),
        onFailure: this.onFailure.bind(this)
      }, this.options.ajaxOptions)
    );
    // stop the event to avoid a page refresh in Safari
    if (arguments.length > 1) {
      Event.stop(arguments[0]);
    }
    return false;
  },
  onLoading: function() {
    this.saving = true;
    this.removeForm();
    this.leaveHover();
    this.showSaving();
  },
  showSaving: function() {
    this.oldInnerHTML = this.element.innerHTML;
    this.element.innerHTML = this.options.savingText;
    Element.addClassName(this.element, this.options.savingClassName);
    this.element.style.backgroundColor = this.originalBackground;
    Element.show(this.element);
  },
  removeForm: function() {
    if(this.form) {
      if (this.form.parentNode) Element.remove(this.form);
      this.form = null;
    }
  },
  enterHover: function() {
    if (this.saving) return;
    this.element.style.backgroundColor = this.options.highlightcolor;
    if (this.effect) {
      this.effect.cancel();
    }
    Element.addClassName(this.element, this.options.hoverClassName)
  },
  leaveHover: function() {
    if (this.options.backgroundColor) {
      this.element.style.backgroundColor = this.oldBackground;
    }
    Element.removeClassName(this.element, this.options.hoverClassName)
    if (this.saving) return;
    this.effect = new Effect.Highlight(this.element, {
      startcolor: this.options.highlightcolor,
      endcolor: this.options.highlightendcolor,
      restorecolor: this.originalBackground
    });
  },
  leaveEditMode: function() {
    Element.removeClassName(this.element, this.options.savingClassName);
    this.removeForm();
    this.leaveHover();
    this.element.style.backgroundColor = this.originalBackground;
    Element.show(this.element);
    if (this.options.externalControl) {
      Element.show(this.options.externalControl);
    }
    this.editing = false;
    this.saving = false;
    this.oldInnerHTML = null;
    this.onLeaveEditMode();
  },
  onComplete: function(transport) {
    this.leaveEditMode();
    this.options.onComplete.bind(this)(transport, this.element);
  },
  onEnterEditMode: function() {},
  onLeaveEditMode: function() {},
  dispose: function() {
    if (this.oldInnerHTML) {
      this.element.innerHTML = this.oldInnerHTML;
    }
    this.leaveEditMode();
    Event.stopObserving(this.element, ''click'', this.onclickListener);
    Event.stopObserving(this.element, ''mouseover'', this.mouseoverListener);
    Event.stopObserving(this.element, ''mouseout'', this.mouseoutListener);
    if (this.options.externalControl) {
      Event.stopObserving(this.options.externalControl, ''click'', this.onclickListener);
      Event.stopObserving(this.options.externalControl, ''mouseover'', this.mouseoverListener);
      Event.stopObserving(this.options.externalControl, ''mouseout'', this.mouseoutListener);
    }
  }
};

// Delayed observer, like Form.Element.Observer, 
// but waits for delay after last key input
// Ideal for live-search fields

Form.Element.DelayedObserver = Class.create();
Form.Element.DelayedObserver.prototype = {
  initialize: function(element, delay, callback) {
    this.delay     = delay || 0.5;
    this.element   = $(element);
    this.callback  = callback;
    this.timer     = null;
    this.lastValue = $F(this.element); 
    Event.observe(this.element,''keyup'',this.delayedListener.bindAsEventListener(this));
  },
  delayedListener: function(event) {
    if(this.lastValue == $F(this.element)) return;
    if(this.timer) clearTimeout(this.timer);
    this.timer = setTimeout(this.onTimerEvent.bind(this), this.delay * 1000);
    this.lastValue = $F(this.element);
  },
  onTimerEvent: function() {
    this.timer = null;
    this.callback(this.element, $F(this.element));
  }
};
'!

scriptaculousControlsJsResource
	"WebStyle new scriptaculousControlsJsResource"
	^self resources at: #jsScriptaculousControls ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousControlsJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/controls.js' site: self site].!

scriptaculousDragDropJs
	"dragdrop.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// Copyright (c) 2005 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
// 
// See scriptaculous.js for full license.

/*--------------------------------------------------------------------------*/

var Droppables = {
  drops: [],

  remove: function(element) {
    this.drops = this.drops.reject(function(d) { return d.element==$(element) });
  },

  add: function(element) {
    element = $(element);
    var options = Object.extend({
      greedy:     true,
      hoverclass: null  
    }, arguments[1] || {});

    // cache containers
    if(options.containment) {
      options._containers = [];
      var containment = options.containment;
      if((typeof containment == ''object'') && 
        (containment.constructor == Array)) {
        containment.each( function(c) { options._containers.push($(c)) });
      } else {
        options._containers.push($(containment));
      }
    }
    
    if(options.accept) options.accept = [options.accept].flatten();

    Element.makePositioned(element); // fix IE
    options.element = element;

    this.drops.push(options);
  },

  isContained: function(element, drop) {
    var parentNode = element.parentNode;
    return drop._containers.detect(function(c) { return parentNode == c });
  },

  isAffected: function(point, element, drop) {
    return (
      (drop.element!!=element) &&
      ((!!drop._containers) ||
        this.isContained(element, drop)) &&
      ((!!drop.accept) ||
        (Element.classNames(element).detect( 
          function(v) { return drop.accept.include(v) } ) )) &&
      Position.within(drop.element, point[0], point[1]) );
  },

  deactivate: function(drop) {
    if(drop.hoverclass)
      Element.removeClassName(drop.element, drop.hoverclass);
    this.last_active = null;
  },

  activate: function(drop) {
    if(drop.hoverclass)
      Element.addClassName(drop.element, drop.hoverclass);
    this.last_active = drop;
  },

  show: function(point, element) {
    if(!!this.drops.length) return;
    
    if(this.last_active) this.deactivate(this.last_active);
    this.drops.each( function(drop) {
      if(Droppables.isAffected(point, element, drop)) {
        if(drop.onHover)
           drop.onHover(element, drop.element, Position.overlap(drop.overlap, drop.element));
        if(drop.greedy) { 
          Droppables.activate(drop);
          throw $break;
        }
      }
    });
  },

  fire: function(event, element) {
    if(!!this.last_active) return;
    Position.prepare();

    if (this.isAffected([Event.pointerX(event), Event.pointerY(event)], element, this.last_active))
      if (this.last_active.onDrop) 
        this.last_active.onDrop(element, this.last_active.element, event);
  },

  reset: function() {
    if(this.last_active)
      this.deactivate(this.last_active);
  }
}

var Draggables = {
  drags: [],
  observers: [],
  
  register: function(draggable) {
    if(this.drags.length == 0) {
      this.eventMouseUp   = this.endDrag.bindAsEventListener(this);
      this.eventMouseMove = this.updateDrag.bindAsEventListener(this);
      this.eventKeypress  = this.keyPress.bindAsEventListener(this);
      
      Event.observe(document, "mouseup", this.eventMouseUp);
      Event.observe(document, "mousemove", this.eventMouseMove);
      Event.observe(document, "keypress", this.eventKeypress);
    }
    this.drags.push(draggable);
  },
  
  unregister: function(draggable) {
    this.drags = this.drags.reject(function(d) { return d==draggable });
    if(this.drags.length == 0) {
      Event.stopObserving(document, "mouseup", this.eventMouseUp);
      Event.stopObserving(document, "mousemove", this.eventMouseMove);
      Event.stopObserving(document, "keypress", this.eventKeypress);
    }
  },
  
  activate: function(draggable) {
    window.focus(); // allows keypress events if window isn''t currently focused, fails for Safari
    this.activeDraggable = draggable;
  },
  
  deactivate: function(draggbale) {
    this.activeDraggable = null;
  },
  
  updateDrag: function(event) {
    if(!!this.activeDraggable) return;
    var pointer = [Event.pointerX(event), Event.pointerY(event)];
    // Mozilla-based browsers fire successive mousemove events with
    // the same coordinates, prevent needless redrawing (moz bug?)
    if(this._lastPointer && (this._lastPointer.inspect() == pointer.inspect())) return;
    this._lastPointer = pointer;
    this.activeDraggable.updateDrag(event, pointer);
  },
  
  endDrag: function(event) {
    if(!!this.activeDraggable) return;
    this._lastPointer = null;
    this.activeDraggable.endDrag(event);
  },
  
  keyPress: function(event) {
    if(this.activeDraggable)
      this.activeDraggable.keyPress(event);
  },
  
  addObserver: function(observer) {
    this.observers.push(observer);
    this._cacheObserverCallbacks();
  },
  
  removeObserver: function(element) {  // element instead of observer fixes mem leaks
    this.observers = this.observers.reject( function(o) { return o.element==element });
    this._cacheObserverCallbacks();
  },
  
  notify: function(eventName, draggable, event) {  // ''onStart'', ''onEnd'', ''onDrag''
    if(this[eventName+''Count''] > 0)
      this.observers.each( function(o) {
        if(o[eventName]) o[eventName](eventName, draggable, event);
      });
  },
  
  _cacheObserverCallbacks: function() {
    [''onStart'',''onEnd'',''onDrag''].each( function(eventName) {
      Draggables[eventName+''Count''] = Draggables.observers.select(
        function(o) { return o[eventName]; }
      ).length;
    });
  }
}

/*--------------------------------------------------------------------------*/

var Draggable = Class.create();
Draggable.prototype = {
  initialize: function(element) {
    var options = Object.extend({
      handle: false,
      starteffect: function(element) { 
        new Effect.Opacity(element, {duration:0.2, from:1.0, to:0.7}); 
      },
      reverteffect: function(element, top_offset, left_offset) {
        var dur = Math.sqrt(Math.abs(top_offset^2)+Math.abs(left_offset^2))*0.02;
        element._revert = new Effect.MoveBy(element, -top_offset, -left_offset, {duration:dur});
      },
      endeffect: function(element) { 
        new Effect.Opacity(element, {duration:0.2, from:0.7, to:1.0}); 
      },
      zindex: 1000,
      revert: false,
      snap: false   // false, or xy or [x,y] or function(x,y){ return [x,y] }
    }, arguments[1] || {});

    this.element = $(element);
    
    if(options.handle && (typeof options.handle == ''string''))
      this.handle = Element.childrenWithClassName(this.element, options.handle)[0];  
    if(!!this.handle) this.handle = $(options.handle);
    if(!!this.handle) this.handle = this.element;

    Element.makePositioned(this.element); // fix IE    

    this.delta    = this.currentDelta();
    this.options  = options;
    this.dragging = false;   

    this.eventMouseDown = this.initDrag.bindAsEventListener(this);
    Event.observe(this.handle, "mousedown", this.eventMouseDown);
    
    Draggables.register(this);
  },
  
  destroy: function() {
    Event.stopObserving(this.handle, "mousedown", this.eventMouseDown);
    Draggables.unregister(this);
  },
  
  currentDelta: function() {
    return([
      parseInt(this.element.style.left || ''0''),
      parseInt(this.element.style.top || ''0'')]);
  },
  
  initDrag: function(event) {
    if(Event.isLeftClick(event)) {    
      // abort on form elements, fixes a Firefox issue
      var src = Event.element(event);
      if(src.tagName && (
        src.tagName==''INPUT'' ||
        src.tagName==''SELECT'' ||
        src.tagName==''BUTTON'' ||
        src.tagName==''TEXTAREA'')) return;
        
      if(this.element._revert) {
        this.element._revert.cancel();
        this.element._revert = null;
      }
      
      var pointer = [Event.pointerX(event), Event.pointerY(event)];
      var pos     = Position.cumulativeOffset(this.element);
      this.offset = [0,1].map( function(i) { return (pointer[i] - pos[i]) });
      
      Draggables.activate(this);
      Event.stop(event);
    }
  },
  
  startDrag: function(event) {
    this.dragging = true;
    
    if(this.options.zindex) {
      this.originalZ = parseInt(Element.getStyle(this.element,''z-index'') || 0);
      this.element.style.zIndex = this.options.zindex;
    }
    
    if(this.options.ghosting) {
      this._clone = this.element.cloneNode(true);
      Position.absolutize(this.element);
      this.element.parentNode.insertBefore(this._clone, this.element);
    }
    
    Draggables.notify(''onStart'', this, event);
    if(this.options.starteffect) this.options.starteffect(this.element);
  },
  
  updateDrag: function(event, pointer) {
    if(!!this.dragging) this.startDrag(event);
    Position.prepare();
    Droppables.show(pointer, this.element);
    Draggables.notify(''onDrag'', this, event);
    this.draw(pointer);
    if(this.options.change) this.options.change(this);
    
    // fix AppleWebKit rendering
    if(navigator.appVersion.indexOf(''AppleWebKit'')>0) window.scrollBy(0,0);
    Event.stop(event);
  },
  
  finishDrag: function(event, success) {
    this.dragging = false;

    if(this.options.ghosting) {
      Position.relativize(this.element);
      Element.remove(this._clone);
      this._clone = null;
    }

    if(success) Droppables.fire(event, this.element);
    Draggables.notify(''onEnd'', this, event);

    var revert = this.options.revert;
    if(revert && typeof revert == ''function'') revert = revert(this.element);
    
    var d = this.currentDelta();
    if(revert && this.options.reverteffect) {
      this.options.reverteffect(this.element, 
        d[1]-this.delta[1], d[0]-this.delta[0]);
    } else {
      this.delta = d;
    }

    if(this.options.zindex)
      this.element.style.zIndex = this.originalZ;

    if(this.options.endeffect) 
      this.options.endeffect(this.element);

    Draggables.deactivate(this);
    Droppables.reset();
  },
  
  keyPress: function(event) {
    if(!!event.keyCode==Event.KEY_ESC) return;
    this.finishDrag(event, false);
    Event.stop(event);
  },
  
  endDrag: function(event) {
    if(!!this.dragging) return;
    this.finishDrag(event, true);
    Event.stop(event);
  },
  
  draw: function(point) {
    var pos = Position.cumulativeOffset(this.element);
    var d = this.currentDelta();
    pos[0] -= d[0]; pos[1] -= d[1];
    
    var p = [0,1].map(function(i){ return (point[i]-pos[i]-this.offset[i]) }.bind(this));
    
    if(this.options.snap) {
      if(typeof this.options.snap == ''function'') {
        p = this.options.snap(p[0],p[1]);
      } else {
      if(this.options.snap instanceof Array) {
        p = p.map( function(v, i) {
          return Math.round(v/this.options.snap[i])*this.options.snap[i] }.bind(this))
      } else {
        p = p.map( function(v) {
          return Math.round(v/this.options.snap)*this.options.snap }.bind(this))
      }
    }}
    
    var style = this.element.style;
    if((!!this.options.constraint) || (this.options.constraint==''horizontal''))
      style.left = p[0] + "px";
    if((!!this.options.constraint) || (this.options.constraint==''vertical''))
      style.top  = p[1] + "px";
    if(style.visibility=="hidden") style.visibility = ""; // fix gecko rendering
  }
}

/*--------------------------------------------------------------------------*/

var SortableObserver = Class.create();
SortableObserver.prototype = {
  initialize: function(element, observer) {
    this.element   = $(element);
    this.observer  = observer;
    this.lastValue = Sortable.serialize(this.element);
  },
  
  onStart: function() {
    this.lastValue = Sortable.serialize(this.element);
  },
  
  onEnd: function() {
    Sortable.unmark();
    if(this.lastValue !!= Sortable.serialize(this.element))
      this.observer(this.element)
  }
}

var Sortable = {
  sortables: new Array(),
  
  options: function(element){
    element = $(element);
    return this.sortables.detect(function(s) { return s.element == element });
  },
  
  destroy: function(element){
    element = $(element);
    this.sortables.findAll(function(s) { return s.element == element }).each(function(s){
      Draggables.removeObserver(s.element);
      s.droppables.each(function(d){ Droppables.remove(d) });
      s.draggables.invoke(''destroy'');
    });
    this.sortables = this.sortables.reject(function(s) { return s.element == element });
  },
  
  create: function(element) {
    element = $(element);
    var options = Object.extend({ 
      element:     element,
      tag:         ''li'',       // assumes li children, override with tag: ''tagname''
      dropOnEmpty: false,
      tree:        false,      // fixme: unimplemented
      overlap:     ''vertical'', // one of ''vertical'', ''horizontal''
      constraint:  ''vertical'', // one of ''vertical'', ''horizontal'', false
      containment: element,    // also takes array of elements (or id''s); or false
      handle:      false,      // or a CSS class
      only:        false,
      hoverclass:  null,
      ghosting:    false,
      format:      null,
      onChange:    Prototype.emptyFunction,
      onUpdate:    Prototype.emptyFunction
    }, arguments[1] || {});

    // clear any old sortable with same element
    this.destroy(element);

    // build options for the draggables
    var options_for_draggable = {
      revert:      true,
      ghosting:    options.ghosting,
      constraint:  options.constraint,
      handle:      options.handle };

    if(options.starteffect)
      options_for_draggable.starteffect = options.starteffect;

    if(options.reverteffect)
      options_for_draggable.reverteffect = options.reverteffect;
    else
      if(options.ghosting) options_for_draggable.reverteffect = function(element) {
        element.style.top  = 0;
        element.style.left = 0;
      };

    if(options.endeffect)
      options_for_draggable.endeffect = options.endeffect;

    if(options.zindex)
      options_for_draggable.zindex = options.zindex;

    // build options for the droppables  
    var options_for_droppable = {
      overlap:     options.overlap,
      containment: options.containment,
      hoverclass:  options.hoverclass,
      onHover:     Sortable.onHover,
      greedy:      !!options.dropOnEmpty
    }

    // fix for gecko engine
    Element.cleanWhitespace(element); 

    options.draggables = [];
    options.droppables = [];

    // make it so

    // drop on empty handling
    if(options.dropOnEmpty) {
      Droppables.add(element,
        {containment: options.containment, onHover: Sortable.onEmptyHover, greedy: false});
      options.droppables.push(element);
    }

    (this.findElements(element, options) || []).each( function(e) {
      // handles are per-draggable
      var handle = options.handle ? 
        Element.childrenWithClassName(e, options.handle)[0] : e;    
      options.draggables.push(
        new Draggable(e, Object.extend(options_for_draggable, { handle: handle })));
      Droppables.add(e, options_for_droppable);
      options.droppables.push(e);      
    });

    // keep reference
    this.sortables.push(options);

    // for onupdate
    Draggables.addObserver(new SortableObserver(element, options.onUpdate));

  },

  // return all suitable-for-sortable elements in a guaranteed order
  findElements: function(element, options) {
    if(!!element.hasChildNodes()) return null;
    var elements = [];
    $A(element.childNodes).each( function(e) {
      if(e.tagName && e.tagName.toUpperCase()==options.tag.toUpperCase() &&
        (!!options.only || (Element.hasClassName(e, options.only))))
          elements.push(e);
      if(options.tree) {
        var grandchildren = this.findElements(e, options);
        if(grandchildren) elements.push(grandchildren);
      }
    });

    return (elements.length>0 ? elements.flatten() : null);
  },

  onHover: function(element, dropon, overlap) {
    if(overlap>0.5) {
      Sortable.mark(dropon, ''before'');
      if(dropon.previousSibling !!= element) {
        var oldParentNode = element.parentNode;
        element.style.visibility = "hidden"; // fix gecko rendering
        dropon.parentNode.insertBefore(element, dropon);
        if(dropon.parentNode!!=oldParentNode) 
          Sortable.options(oldParentNode).onChange(element);
        Sortable.options(dropon.parentNode).onChange(element);
      }
    } else {
      Sortable.mark(dropon, ''after'');
      var nextElement = dropon.nextSibling || null;
      if(nextElement !!= element) {
        var oldParentNode = element.parentNode;
        element.style.visibility = "hidden"; // fix gecko rendering
        dropon.parentNode.insertBefore(element, nextElement);
        if(dropon.parentNode!!=oldParentNode) 
          Sortable.options(oldParentNode).onChange(element);
        Sortable.options(dropon.parentNode).onChange(element);
      }
    }
  },

  onEmptyHover: function(element, dropon) {
    if(element.parentNode!!=dropon) {
      var oldParentNode = element.parentNode;
      dropon.appendChild(element);
      Sortable.options(oldParentNode).onChange(element);
      Sortable.options(dropon).onChange(element);
    }
  },

  unmark: function() {
    if(Sortable._marker) Element.hide(Sortable._marker);
  },

  mark: function(dropon, position) {
    // mark on ghosting only
    var sortable = Sortable.options(dropon.parentNode);
    if(sortable && !!sortable.ghosting) return; 

    if(!!Sortable._marker) {
      Sortable._marker = $(''dropmarker'') || document.createElement(''DIV'');
      Element.hide(Sortable._marker);
      Element.addClassName(Sortable._marker, ''dropmarker'');
      Sortable._marker.style.position = ''absolute'';
      document.getElementsByTagName("body").item(0).appendChild(Sortable._marker);
    }    
    var offsets = Position.cumulativeOffset(dropon);
    Sortable._marker.style.left = offsets[0] + ''px'';
    Sortable._marker.style.top = offsets[1] + ''px'';
    
    if(position==''after'')
      if(sortable.overlap == ''horizontal'') 
        Sortable._marker.style.left = (offsets[0]+dropon.clientWidth) + ''px'';
      else
        Sortable._marker.style.top = (offsets[1]+dropon.clientHeight) + ''px'';
    
    Element.show(Sortable._marker);
  },

  serialize: function(element) {
    element = $(element);
    var sortableOptions = this.options(element);
    var options = Object.extend({
      tag:  sortableOptions.tag,
      only: sortableOptions.only,
      name: element.id,
      format: sortableOptions.format || /^[^_]*_(.*)$/
    }, arguments[1] || {});
    return $(this.findElements(element, options) || []).map( function(item) {
      return (encodeURIComponent(options.name) + "[]=" + 
              encodeURIComponent(item.id.match(options.format) ? item.id.match(options.format)[1] : ''''));
    }).join("&");
  }
}
'!

scriptaculousDragDropJsResource
	"WebStyle new scriptaculousDragDropJsResource"
	^self resources at: #jsScriptaculousDragDrop ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousDragDropJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/dragdrop.js' site: self site].!

scriptaculousEffectsJs
	"effects.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// Copyright (c) 2005 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
// Contributors:
//  Justin Palmer (http://encytemedia.com/)
//  Mark Pilgrim (http://diveintomark.org/)
//  Martin Bialasinki
// 
// See scriptaculous.js for full license.  

/* ------------- element ext -------------- */  
 
// converts rgb() and #xxx to #xxxxxx format,  
// returns self (or first argument) if not convertable  
String.prototype.parseColor = function() {  
  var color = ''#'';  
  if(this.slice(0,4) == ''rgb('') {  
    var cols = this.slice(4,this.length-1).split('','');  
    var i=0; do { color += parseInt(cols[i]).toColorPart() } while (++i<3);  
  } else {  
    if(this.slice(0,1) == ''#'') {  
      if(this.length==4) for(var i=1;i<4;i++) color += (this.charAt(i) + this.charAt(i)).toLowerCase();  
      if(this.length==7) color = this.toLowerCase();  
    }  
  }  
  return(color.length==7 ? color : (arguments[0] || this));  
}  

Element.collectTextNodesIgnoreClass = function(element, ignoreclass) {  
  var children = $(element).childNodes;  
  var text     = '''';  
  var classtest = new RegExp(''^([^ ]+ )*'' + ignoreclass+ ''( [^ ]+)*$'',''i'');  
 
  for (var i = 0; i < children.length; i++) {  
    if(children[i].nodeType==3) {  
      text+=children[i].nodeValue;  
    } else {  
      if((!!children[i].className.match(classtest)) && children[i].hasChildNodes())  
        text += Element.collectTextNodesIgnoreClass(children[i], ignoreclass);  
    }  
  }  
 
  return text;
}

Element.setStyle = function(element, style) {
  element = $(element);
  for(k in style) element.style[k.camelize()] = style[k];
}

Element.setContentZoom = function(element, percent) {  
  Element.setStyle(element, {fontSize: (percent/100) + ''em''});   
  if(navigator.appVersion.indexOf(''AppleWebKit'')>0) window.scrollBy(0,0);  
}

Element.getOpacity = function(element){  
  var opacity;
  if (opacity = Element.getStyle(element, ''opacity''))  
    return parseFloat(opacity);  
  if (opacity = (Element.getStyle(element, ''filter'') || '''').match(/alpha\(opacity=(.*)\)/))  
    if(opacity[1]) return parseFloat(opacity[1]) / 100;  
  return 1.0;  
}

Element.setOpacity = function(element, value){  
  element= $(element);  
  if (value == 1){
    Element.setStyle(element, { opacity: 
      (/Gecko/.test(navigator.userAgent) && !!/Konqueror|Safari|KHTML/.test(navigator.userAgent)) ? 
      0.999999 : null });
    if(/MSIE/.test(navigator.userAgent))  
      Element.setStyle(element, {filter: Element.getStyle(element,''filter'').replace(/alpha\([^\)]*\)/gi,'''')});  
  } else {  
    if(value < 0.00001) value = 0;  
    Element.setStyle(element, {opacity: value});
    if(/MSIE/.test(navigator.userAgent))  
     Element.setStyle(element, 
       { filter: Element.getStyle(element,''filter'').replace(/alpha\([^\)]*\)/gi,'''') +
                 ''alpha(opacity=''+value*100+'')'' });  
  }   
}  
 
Element.getInlineOpacity = function(element){  
  return $(element).style.opacity || '''';
}  

Element.childrenWithClassName = function(element, className) {  
  return $A($(element).getElementsByTagName(''*'')).select(
    function(c) { return Element.hasClassName(c, className) });
}

Array.prototype.call = function() {
  var args = arguments;
  this.each(function(f){ f.apply(this, args) });
}

/*--------------------------------------------------------------------------*/

var Effect = {
  tagifyText: function(element) {
    var tagifyStyle = ''position:relative'';
    if(/MSIE/.test(navigator.userAgent)) tagifyStyle += '';zoom:1'';
    element = $(element);
    $A(element.childNodes).each( function(child) {
      if(child.nodeType==3) {
        child.nodeValue.toArray().each( function(character) {
          element.insertBefore(
            Builder.node(''span'',{style: tagifyStyle},
              character == '' '' ? String.fromCharCode(160) : character), 
              child);
        });
        Element.remove(child);
      }
    });
  },
  multiple: function(element, effect) {
    var elements;
    if(((typeof element == ''object'') || 
        (typeof element == ''function'')) && 
       (element.length))
      elements = element;
    else
      elements = $(element).childNodes;
      
    var options = Object.extend({
      speed: 0.1,
      delay: 0.0
    }, arguments[2] || {});
    var masterDelay = options.delay;

    $A(elements).each( function(element, index) {
      new effect(element, Object.extend(options, { delay: index * options.speed + masterDelay }));
    });
  }
};

var Effect2 = Effect; // deprecated

/* ------------- transitions ------------- */

Effect.Transitions = {}

Effect.Transitions.linear = function(pos) {
  return pos;
}
Effect.Transitions.sinoidal = function(pos) {
  return (-Math.cos(pos*Math.PI)/2) + 0.5;
}
Effect.Transitions.reverse  = function(pos) {
  return 1-pos;
}
Effect.Transitions.flicker = function(pos) {
  return ((-Math.cos(pos*Math.PI)/4) + 0.75) + Math.random()/4;
}
Effect.Transitions.wobble = function(pos) {
  return (-Math.cos(pos*Math.PI*(9*pos))/2) + 0.5;
}
Effect.Transitions.pulse = function(pos) {
  return (Math.floor(pos*10) % 2 == 0 ? 
    (pos*10-Math.floor(pos*10)) : 1-(pos*10-Math.floor(pos*10)));
}
Effect.Transitions.none = function(pos) {
  return 0;
}
Effect.Transitions.full = function(pos) {
  return 1;
}

/* ------------- core effects ------------- */

Effect.Queue = {
  effects:  [],
  _each: function(iterator) {
    this.effects._each(iterator);
  },
  interval: null,
  add: function(effect) {
    var timestamp = new Date().getTime();
    
    switch(effect.options.queue) {
      case ''front'':
        // move unstarted effects after this effect  
        this.effects.findAll(function(e){ return e.state==''idle'' }).each( function(e) {
            e.startOn  += effect.finishOn;
            e.finishOn += effect.finishOn;
          });
        break;
      case ''end'':
        // start effect after last queued effect has finished
        timestamp = this.effects.pluck(''finishOn'').max() || timestamp;
        break;
    }
    
    effect.startOn  += timestamp;
    effect.finishOn += timestamp;
    this.effects.push(effect);
    if(!!this.interval) 
      this.interval = setInterval(this.loop.bind(this), 40);
  },
  remove: function(effect) {
    this.effects = this.effects.reject(function(e) { return e==effect });
    if(this.effects.length == 0) {
      clearInterval(this.interval);
      this.interval = null;
    }
  },
  loop: function() {
    var timePos = new Date().getTime();
    this.effects.invoke(''loop'', timePos);
  }
}
Object.extend(Effect.Queue, Enumerable);

Effect.Base = function() {};
Effect.Base.prototype = {
  position: null,
  setOptions: function(options) {
    this.options = Object.extend({
      transition: Effect.Transitions.sinoidal,
      duration:   1.0,   // seconds
      fps:        25.0,  // max. 25fps due to Effect.Queue implementation
      sync:       false, // true for combining
      from:       0.0,
      to:         1.0,
      delay:      0.0,
      queue:      ''parallel''
    }, options || {});
  },
  start: function(options) {
    this.setOptions(options || {});
    this.currentFrame = 0;
    this.state        = ''idle'';
    this.startOn      = this.options.delay*1000;
    this.finishOn     = this.startOn + (this.options.duration*1000);
    this.event(''beforeStart'');
    if(!!this.options.sync) Effect.Queue.add(this);
  },
  loop: function(timePos) {
    if(timePos >= this.startOn) {
      if(timePos >= this.finishOn) {
        this.render(1.0);
        this.cancel();
        this.event(''beforeFinish'');
        if(this.finish) this.finish(); 
        this.event(''afterFinish'');
        return;  
      }
      var pos   = (timePos - this.startOn) / (this.finishOn - this.startOn);
      var frame = Math.round(pos * this.options.fps * this.options.duration);
      if(frame > this.currentFrame) {
        this.render(pos);
        this.currentFrame = frame;
      }
    }
  },
  render: function(pos) {
    if(this.state == ''idle'') {
      this.state = ''running'';
      this.event(''beforeSetup'');
      if(this.setup) this.setup();
      this.event(''afterSetup'');
    }
    if(this.state == ''running'') {
      if(this.options.transition) pos = this.options.transition(pos);
      pos *= (this.options.to-this.options.from);
      pos += this.options.from;
      this.position = pos;
      this.event(''beforeUpdate'');
      if(this.update) this.update(pos);
      this.event(''afterUpdate'');
    }
  },
  cancel: function() {
    if(!!this.options.sync) Effect.Queue.remove(this);
    this.state = ''finished'';
  },
  event: function(eventName) {
    if(this.options[eventName + ''Internal'']) this.options[eventName + ''Internal''](this);
    if(this.options[eventName]) this.options[eventName](this);
  },
  inspect: function() {
    return ''#<Effect:'' + $H(this).inspect() + '',options:'' + $H(this.options).inspect() + ''>'';
  }
}

Effect.Parallel = Class.create();
Object.extend(Object.extend(Effect.Parallel.prototype, Effect.Base.prototype), {
  initialize: function(effects) {
    this.effects = effects || [];
    this.start(arguments[1]);
  },
  update: function(position) {
    this.effects.invoke(''render'', position);
  },
  finish: function(position) {
    this.effects.each( function(effect) {
      effect.render(1.0);
      effect.cancel();
      effect.event(''beforeFinish'');
      if(effect.finish) effect.finish(position);
      effect.event(''afterFinish'');
    });
  }
});

Effect.Opacity = Class.create();
Object.extend(Object.extend(Effect.Opacity.prototype, Effect.Base.prototype), {
  initialize: function(element) {
    this.element = $(element);
    // make this work on IE on elements without ''layout''
    if(/MSIE/.test(navigator.userAgent) && (!!this.element.hasLayout))
      Element.setStyle(this.element, {zoom: 1});
    var options = Object.extend({
      from: Element.getOpacity(this.element) || 0.0,
      to:   1.0
    }, arguments[1] || {});
    this.start(options);
  },
  update: function(position) {
    Element.setOpacity(this.element, position);
  }
});

Effect.MoveBy = Class.create();
Object.extend(Object.extend(Effect.MoveBy.prototype, Effect.Base.prototype), {
  initialize: function(element, toTop, toLeft) {
    this.element      = $(element);
    this.toTop        = toTop;
    this.toLeft       = toLeft;
    this.start(arguments[3]);
  },
  setup: function() {
    // Bug in Opera: Opera returns the "real" position of a static element or
    // relative element that does not have top/left explicitly set.
    // ==> Always set top and left for position relative elements in your stylesheets 
    // (to 0 if you do not need them) 
    Element.makePositioned(this.element);
    this.originalTop  = parseFloat(Element.getStyle(this.element,''top'')  || ''0'');
    this.originalLeft = parseFloat(Element.getStyle(this.element,''left'') || ''0'');
  },
  update: function(position) {
    Element.setStyle(this.element, {
      top:  this.toTop  * position + this.originalTop + ''px'',
      left: this.toLeft * position + this.originalLeft + ''px''
    });
  }
});

Effect.Scale = Class.create();
Object.extend(Object.extend(Effect.Scale.prototype, Effect.Base.prototype), {
  initialize: function(element, percent) {
    this.element = $(element)
    var options = Object.extend({
      scaleX: true,
      scaleY: true,
      scaleContent: true,
      scaleFromCenter: false,
      scaleMode: ''box'',        // ''box'' or ''contents'' or {} with provided values
      scaleFrom: 100.0,
      scaleTo:   percent
    }, arguments[2] || {});
    this.start(options);
  },
  setup: function() {
    this.restoreAfterFinish = this.options.restoreAfterFinish || false;
    this.elementPositioning = Element.getStyle(this.element,''position'');
    
    this.originalStyle = {};
    [''top'',''left'',''width'',''height'',''fontSize''].each( function(k) {
      this.originalStyle[k] = this.element.style[k];
    }.bind(this));
      
    this.originalTop  = this.element.offsetTop;
    this.originalLeft = this.element.offsetLeft;
    
    var fontSize = Element.getStyle(this.element,''font-size'') || ''100%'';
    [''em'',''px'',''%''].each( function(fontSizeType) {
      if(fontSize.indexOf(fontSizeType)>0) {
        this.fontSize     = parseFloat(fontSize);
        this.fontSizeType = fontSizeType;
      }
    }.bind(this));
    
    this.factor = (this.options.scaleTo - this.options.scaleFrom)/100;
    
    this.dims = null;
    if(this.options.scaleMode==''box'')
      this.dims = [this.element.offsetHeight, this.element.offsetWidth];
    if(/^content/.test(this.options.scaleMode))
      this.dims = [this.element.scrollHeight, this.element.scrollWidth];
    if(!!this.dims)
      this.dims = [this.options.scaleMode.originalHeight,
                   this.options.scaleMode.originalWidth];
  },
  update: function(position) {
    var currentScale = (this.options.scaleFrom/100.0) + (this.factor * position);
    if(this.options.scaleContent && this.fontSize)
      Element.setStyle(this.element, {fontSize: this.fontSize * currentScale + this.fontSizeType });
    this.setDimensions(this.dims[0] * currentScale, this.dims[1] * currentScale);
  },
  finish: function(position) {
    if (this.restoreAfterFinish) Element.setStyle(this.element, this.originalStyle);
  },
  setDimensions: function(height, width) {
    var d = {};
    if(this.options.scaleX) d.width = width + ''px'';
    if(this.options.scaleY) d.height = height + ''px'';
    if(this.options.scaleFromCenter) {
      var topd  = (height - this.dims[0])/2;
      var leftd = (width  - this.dims[1])/2;
      if(this.elementPositioning == ''absolute'') {
        if(this.options.scaleY) d.top = this.originalTop-topd + ''px'';
        if(this.options.scaleX) d.left = this.originalLeft-leftd + ''px'';
      } else {
        if(this.options.scaleY) d.top = -topd + ''px'';
        if(this.options.scaleX) d.left = -leftd + ''px'';
      }
    }
    Element.setStyle(this.element, d);
  }
});

Effect.Highlight = Class.create();
Object.extend(Object.extend(Effect.Highlight.prototype, Effect.Base.prototype), {
  initialize: function(element) {
    this.element = $(element);
    var options = Object.extend({ startcolor: ''#ffff99'' }, arguments[1] || {});
    this.start(options);
  },
  setup: function() {
    // Prevent executing on elements not in the layout flow
    if(Element.getStyle(this.element, ''display'')==''none'') { this.cancel(); return; }
    // Disable background image during the effect
    this.oldStyle = {
      backgroundImage: Element.getStyle(this.element, ''background-image'') };
    Element.setStyle(this.element, {backgroundImage: ''none''});
    if(!!this.options.endcolor)
      this.options.endcolor = Element.getStyle(this.element, ''background-color'').parseColor(''#ffffff'');
    if(!!this.options.restorecolor)
      this.options.restorecolor = Element.getStyle(this.element, ''background-color'');
    // init color calculations
    this._base  = $R(0,2).map(function(i){ return parseInt(this.options.startcolor.slice(i*2+1,i*2+3),16) }.bind(this));
    this._delta = $R(0,2).map(function(i){ return parseInt(this.options.endcolor.slice(i*2+1,i*2+3),16)-this._base[i] }.bind(this));
  },
  update: function(position) {
    Element.setStyle(this.element,{backgroundColor: $R(0,2).inject(''#'',function(m,v,i){
      return m+(Math.round(this._base[i]+(this._delta[i]*position)).toColorPart()); }.bind(this)) });
  },
  finish: function() {
    Element.setStyle(this.element, Object.extend(this.oldStyle, {
      backgroundColor: this.options.restorecolor
    }));
  }
});

Effect.ScrollTo = Class.create();
Object.extend(Object.extend(Effect.ScrollTo.prototype, Effect.Base.prototype), {
  initialize: function(element) {
    this.element = $(element);
    this.start(arguments[1] || {});
  },
  setup: function() {
    Position.prepare();
    var offsets = Position.cumulativeOffset(this.element);
    if(this.options.offset) offsets[1] += this.options.offset;
    var max = window.innerHeight ? 
      window.height - window.innerHeight :
      document.body.scrollHeight - 
        (document.documentElement.clientHeight ? 
          document.documentElement.clientHeight : document.body.clientHeight);
    this.scrollStart = Position.deltaY;
    this.delta = (offsets[1] > max ? max : offsets[1]) - this.scrollStart;
  },
  update: function(position) {
    Position.prepare();
    window.scrollTo(Position.deltaX, 
      this.scrollStart + (position*this.delta));
  }
});

/* ------------- combination effects ------------- */

Effect.Fade = function(element) {
  var oldOpacity = Element.getInlineOpacity(element);
  var options = Object.extend({
  from: Element.getOpacity(element) || 1.0,
  to:   0.0,
  afterFinishInternal: function(effect) { with(Element) { 
    if(effect.options.to!!=0) return;
    hide(effect.element);
    setStyle(effect.element, {opacity: oldOpacity}); }}
  }, arguments[1] || {});
  return new Effect.Opacity(element,options);
}

Effect.Appear = function(element) {
  var options = Object.extend({
  from: (Element.getStyle(element, ''display'') == ''none'' ? 0.0 : Element.getOpacity(element) || 0.0),
  to:   1.0,
  beforeSetup: function(effect) { with(Element) {
    setOpacity(effect.element, effect.options.from);
    show(effect.element); }}
  }, arguments[1] || {});
  return new Effect.Opacity(element,options);
}

Effect.Puff = function(element) {
  element = $(element);
  var oldStyle = { opacity: Element.getInlineOpacity(element), position: Element.getStyle(element, ''position'') };
  return new Effect.Parallel(
   [ new Effect.Scale(element, 200, 
      { sync: true, scaleFromCenter: true, scaleContent: true, restoreAfterFinish: true }), 
     new Effect.Opacity(element, { sync: true, to: 0.0 } ) ], 
     Object.extend({ duration: 1.0, 
      beforeSetupInternal: function(effect) { with(Element) {
        setStyle(effect.effects[0].element, {position: ''absolute''}); }},
      afterFinishInternal: function(effect) { with(Element) {
         hide(effect.effects[0].element);
         setStyle(effect.effects[0].element, oldStyle); }}
     }, arguments[1] || {})
   );
}

Effect.BlindUp = function(element) {
  element = $(element);
  Element.makeClipping(element);
  return new Effect.Scale(element, 0, 
    Object.extend({ scaleContent: false, 
      scaleX: false, 
      restoreAfterFinish: true,
      afterFinishInternal: function(effect) { with(Element) {
        [hide, undoClipping].call(effect.element); }} 
    }, arguments[1] || {})
  );
}

Effect.BlindDown = function(element) {
  element = $(element);
  var oldHeight = Element.getStyle(element, ''height'');
  var elementDimensions = Element.getDimensions(element);
  return new Effect.Scale(element, 100, 
    Object.extend({ scaleContent: false, 
      scaleX: false,
      scaleFrom: 0,
      scaleMode: {originalHeight: elementDimensions.height, originalWidth: elementDimensions.width},
      restoreAfterFinish: true,
      afterSetup: function(effect) { with(Element) {
        makeClipping(effect.element);
        setStyle(effect.element, {height: ''0px''});
        show(effect.element); 
      }},  
      afterFinishInternal: function(effect) { with(Element) {
        undoClipping(effect.element);
        setStyle(effect.element, {height: oldHeight});
      }}
    }, arguments[1] || {})
  );
}

Effect.SwitchOff = function(element) {
  element = $(element);
  var oldOpacity = Element.getInlineOpacity(element);
  return new Effect.Appear(element, { 
    duration: 0.4,
    from: 0,
    transition: Effect.Transitions.flicker,
    afterFinishInternal: function(effect) {
      new Effect.Scale(effect.element, 1, { 
        duration: 0.3, scaleFromCenter: true,
        scaleX: false, scaleContent: false, restoreAfterFinish: true,
        beforeSetup: function(effect) { with(Element) {
          [makePositioned,makeClipping].call(effect.element);
        }},
        afterFinishInternal: function(effect) { with(Element) {
          [hide,undoClipping,undoPositioned].call(effect.element);
          setStyle(effect.element, {opacity: oldOpacity});
        }}
      })
    }
  });
}

Effect.DropOut = function(element) {
  element = $(element);
  var oldStyle = {
    top: Element.getStyle(element, ''top''),
    left: Element.getStyle(element, ''left''),
    opacity: Element.getInlineOpacity(element) };
  return new Effect.Parallel(
    [ new Effect.MoveBy(element, 100, 0, { sync: true }), 
      new Effect.Opacity(element, { sync: true, to: 0.0 }) ],
    Object.extend(
      { duration: 0.5,
        beforeSetup: function(effect) { with(Element) {
          makePositioned(effect.effects[0].element); }},
        afterFinishInternal: function(effect) { with(Element) {
          [hide, undoPositioned].call(effect.effects[0].element);
          setStyle(effect.effects[0].element, oldStyle); }} 
      }, arguments[1] || {}));
}

Effect.Shake = function(element) {
  element = $(element);
  var oldStyle = {
    top: Element.getStyle(element, ''top''),
    left: Element.getStyle(element, ''left'') };
  return new Effect.MoveBy(element, 0, 20, 
    { duration: 0.05, afterFinishInternal: function(effect) {
  new Effect.MoveBy(effect.element, 0, -40, 
    { duration: 0.1, afterFinishInternal: function(effect) {
  new Effect.MoveBy(effect.element, 0, 40, 
    { duration: 0.1, afterFinishInternal: function(effect) {
  new Effect.MoveBy(effect.element, 0, -40, 
    { duration: 0.1, afterFinishInternal: function(effect) {
  new Effect.MoveBy(effect.element, 0, 40, 
    { duration: 0.1, afterFinishInternal: function(effect) {
  new Effect.MoveBy(effect.element, 0, -20, 
    { duration: 0.05, afterFinishInternal: function(effect) { with(Element) {
        undoPositioned(effect.element);
        setStyle(effect.element, oldStyle);
  }}}) }}) }}) }}) }}) }});
}

Effect.SlideDown = function(element) {
  element = $(element);
  Element.cleanWhitespace(element);
  // SlideDown need to have the content of the element wrapped in a container element with fixed height!!
  var oldInnerBottom = Element.getStyle(element.firstChild, ''bottom'');
  var elementDimensions = Element.getDimensions(element);
  return new Effect.Scale(element, 100, Object.extend({ 
    scaleContent: false, 
    scaleX: false, 
    scaleFrom: 0,
    scaleMode: {originalHeight: elementDimensions.height, originalWidth: elementDimensions.width},
    restoreAfterFinish: true,
    afterSetup: function(effect) { with(Element) {
      makePositioned(effect.element);
      makePositioned(effect.element.firstChild);
      if(window.opera) setStyle(effect.element, {top: ''''});
      makeClipping(effect.element);
      setStyle(effect.element, {height: ''0px''});
      show(element); }},
    afterUpdateInternal: function(effect) { with(Element) {
      setStyle(effect.element.firstChild, {bottom:
        (effect.dims[0] - effect.element.clientHeight) + ''px'' }); }},
    afterFinishInternal: function(effect) { with(Element) {
      undoClipping(effect.element); 
      undoPositioned(effect.element.firstChild);
      undoPositioned(effect.element);
      setStyle(effect.element.firstChild, {bottom: oldInnerBottom}); }}
    }, arguments[1] || {})
  );
}
  
Effect.SlideUp = function(element) {
  element = $(element);
  Element.cleanWhitespace(element);
  var oldInnerBottom = Element.getStyle(element.firstChild, ''bottom'');
  return new Effect.Scale(element, 0, 
   Object.extend({ scaleContent: false, 
    scaleX: false, 
    scaleMode: ''box'',
    scaleFrom: 100,
    restoreAfterFinish: true,
    beforeStartInternal: function(effect) { with(Element) {
      makePositioned(effect.element);
      makePositioned(effect.element.firstChild);
      if(window.opera) setStyle(effect.element, {top: ''''});
      makeClipping(effect.element);
      show(element); }},  
    afterUpdateInternal: function(effect) { with(Element) {
      setStyle(effect.element.firstChild, {bottom:
        (effect.dims[0] - effect.element.clientHeight) + ''px'' }); }},
    afterFinishInternal: function(effect) { with(Element) {
        [hide, undoClipping].call(effect.element); 
        undoPositioned(effect.element.firstChild);
        undoPositioned(effect.element);
        setStyle(effect.element.firstChild, {bottom: oldInnerBottom}); }}
   }, arguments[1] || {})
  );
}

// Bug in opera makes the TD containing this element expand for a instance after finish 
Effect.Squish = function(element) {
  return new Effect.Scale(element, window.opera ? 1 : 0, 
    { restoreAfterFinish: true,
      beforeSetup: function(effect) { with(Element) {
        makeClipping(effect.element); }},  
      afterFinishInternal: function(effect) { with(Element) {
        hide(effect.element); 
        undoClipping(effect.element); }}
  });
}

Effect.Grow = function(element) {
  element = $(element);
  var options = Object.extend({
    direction: ''center'',
    moveTransistion: Effect.Transitions.sinoidal,
    scaleTransition: Effect.Transitions.sinoidal,
    opacityTransition: Effect.Transitions.full
  }, arguments[1] || {});
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    height: element.style.height,
    width: element.style.width,
    opacity: Element.getInlineOpacity(element) };

  var dims = Element.getDimensions(element);    
  var initialMoveX, initialMoveY;
  var moveX, moveY;
  
  switch (options.direction) {
    case ''top-left'':
      initialMoveX = initialMoveY = moveX = moveY = 0; 
      break;
    case ''top-right'':
      initialMoveX = dims.width;
      initialMoveY = moveY = 0;
      moveX = -dims.width;
      break;
    case ''bottom-left'':
      initialMoveX = moveX = 0;
      initialMoveY = dims.height;
      moveY = -dims.height;
      break;
    case ''bottom-right'':
      initialMoveX = dims.width;
      initialMoveY = dims.height;
      moveX = -dims.width;
      moveY = -dims.height;
      break;
    case ''center'':
      initialMoveX = dims.width / 2;
      initialMoveY = dims.height / 2;
      moveX = -dims.width / 2;
      moveY = -dims.height / 2;
      break;
  }
  
  return new Effect.MoveBy(element, initialMoveY, initialMoveX, { 
    duration: 0.01, 
    beforeSetup: function(effect) { with(Element) {
      hide(effect.element);
      makeClipping(effect.element);
      makePositioned(effect.element);
    }},
    afterFinishInternal: function(effect) {
      new Effect.Parallel(
        [ new Effect.Opacity(effect.element, { sync: true, to: 1.0, from: 0.0, transition: options.opacityTransition }),
          new Effect.MoveBy(effect.element, moveY, moveX, { sync: true, transition: options.moveTransition }),
          new Effect.Scale(effect.element, 100, {
            scaleMode: { originalHeight: dims.height, originalWidth: dims.width }, 
            sync: true, scaleFrom: window.opera ? 1 : 0, transition: options.scaleTransition, restoreAfterFinish: true})
        ], Object.extend({
             beforeSetup: function(effect) { with(Element) {
               setStyle(effect.effects[0].element, {height: ''0px''});
               show(effect.effects[0].element); }},
             afterFinishInternal: function(effect) { with(Element) {
               [undoClipping, undoPositioned].call(effect.effects[0].element); 
               setStyle(effect.effects[0].element, oldStyle); }}
           }, options)
      )
    }
  });
}

Effect.Shrink = function(element) {
  element = $(element);
  var options = Object.extend({
    direction: ''center'',
    moveTransistion: Effect.Transitions.sinoidal,
    scaleTransition: Effect.Transitions.sinoidal,
    opacityTransition: Effect.Transitions.none
  }, arguments[1] || {});
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    height: element.style.height,
    width: element.style.width,
    opacity: Element.getInlineOpacity(element) };

  var dims = Element.getDimensions(element);
  var moveX, moveY;
  
  switch (options.direction) {
    case ''top-left'':
      moveX = moveY = 0;
      break;
    case ''top-right'':
      moveX = dims.width;
      moveY = 0;
      break;
    case ''bottom-left'':
      moveX = 0;
      moveY = dims.height;
      break;
    case ''bottom-right'':
      moveX = dims.width;
      moveY = dims.height;
      break;
    case ''center'':  
      moveX = dims.width / 2;
      moveY = dims.height / 2;
      break;
  }
  
  return new Effect.Parallel(
    [ new Effect.Opacity(element, { sync: true, to: 0.0, from: 1.0, transition: options.opacityTransition }),
      new Effect.Scale(element, window.opera ? 1 : 0, { sync: true, transition: options.scaleTransition, restoreAfterFinish: true}),
      new Effect.MoveBy(element, moveY, moveX, { sync: true, transition: options.moveTransition })
    ], Object.extend({            
         beforeStartInternal: function(effect) { with(Element) {
           [makePositioned, makeClipping].call(effect.effects[0].element) }},
         afterFinishInternal: function(effect) { with(Element) {
           [hide, undoClipping, undoPositioned].call(effect.effects[0].element);
           setStyle(effect.effects[0].element, oldStyle); }}
       }, options)
  );
}

Effect.Pulsate = function(element) {
  element = $(element);
  var options    = arguments[1] || {};
  var oldOpacity = Element.getInlineOpacity(element);
  var transition = options.transition || Effect.Transitions.sinoidal;
  var reverser   = function(pos){ return transition(1-Effect.Transitions.pulse(pos)) };
  reverser.bind(transition);
  return new Effect.Opacity(element, 
    Object.extend(Object.extend({  duration: 3.0, from: 0,
      afterFinishInternal: function(effect) { Element.setStyle(effect.element, {opacity: oldOpacity}); }
    }, options), {transition: reverser}));
}

Effect.Fold = function(element) {
  element = $(element);
  var oldStyle = {
    top: element.style.top,
    left: element.style.left,
    width: element.style.width,
    height: element.style.height };
  Element.makeClipping(element);
  return new Effect.Scale(element, 5, Object.extend({   
    scaleContent: false,
    scaleX: false,
    afterFinishInternal: function(effect) {
    new Effect.Scale(element, 1, { 
      scaleContent: false, 
      scaleY: false,
      afterFinishInternal: function(effect) { with(Element) {
        [hide, undoClipping].call(effect.element); 
        setStyle(effect.element, oldStyle);
      }} });
  }}, arguments[1] || {}));
}
'!

scriptaculousEffectsJsResource
	"WebStyle new scriptaculousEffectsJsResource"
	^self resources at: #jsScriptaculousEffects ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousEffectsJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/effects.js' site: self site].!

scriptaculousJs
	"script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// Copyright (c) 2005 Thomas Fuchs (http://script.aculo.us, http://mir.aculo.us)
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

var Scriptaculous = {
  Version: ''1.5.0'',
  require: function(libraryName) {
    // inserting via DOM fails in Safari 2.0, so brute force approach
    document.write(''<script type="text/javascript" src="''+libraryName+''"></script>'');
  },
  load: function() {
//    if((typeof Prototype==''undefined'') ||
//      parseFloat(Prototype.Version.split(".")[0] + "." +
//                 Prototype.Version.split(".")[1]) < 1.4)
//      throw("script.aculo.us requires the Prototype JavaScript framework >= 1.4.0");
    var scriptTags = document.getElementsByTagName("script");
    for(var i=0;i<scriptTags.length;i++) {
      if(scriptTags[i].src && scriptTags[i].src.match(/scriptaculous\.js(\?.*)?$/)) {
        var path = scriptTags[i].src.replace(/scriptaculous\.js(\?.*)?$/,'''');
        this.require(path + ''builder.js'');
        this.require(path + ''effects.js'');
        this.require(path + ''dragdrop.js'');
        this.require(path + ''controls.js'');
        this.require(path + ''slider.js'');
        break;
      }
    }
  }
}

Scriptaculous.load();
'!

scriptaculousJsResource
	"WebStyle new scriptaculousJsResource"
	^self resources at: #jsScriptaculous ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/scriptaculous.js' site: self site].!

scriptaculousSliderJs
	"slider.js from script.aculo.us AJAX framework, see http://script.aculo.us"
	^'
// Copyright (c) 2005 Marty Haught, Thomas Fuchs 
//
// See http://script.aculo.us for more info
// 
// Permission is hereby granted, free of charge, to any person obtaining
// a copy of this software and associated documentation files (the
// "Software"), to deal in the Software without restriction, including
// without limitation the rights to use, copy, modify, merge, publish,
// distribute, sublicense, and/or sell copies of the Software, and to
// permit persons to whom the Software is furnished to do so, subject to
// the following conditions:
// 
// The above copyright notice and this permission notice shall be
// included in all copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
// EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
// MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
// NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
// LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
// OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
// WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

if(!!Control) var Control = {};
Control.Slider = Class.create();

// options:
//  axis: ''vertical'', or ''horizontal'' (default)
//
// callbacks:
//  onChange(value)
//  onSlide(value)
Control.Slider.prototype = {
  initialize: function(handle, track, options) {
    var slider = this;
    
    if(handle instanceof Array) {
      this.handles = handle.collect( function(e) { return $(e) });
    } else {
      this.handles = [$(handle)];
    }
    
    this.track   = $(track);
    this.options = options || {};

    this.axis      = this.options.axis || ''horizontal'';
    this.increment = this.options.increment || 1;
    this.step      = parseInt(this.options.step || ''1'');
    this.range     = this.options.range || $R(0,1);
    
    this.value     = 0; // assure backwards compat
    this.values    = this.handles.map( function() { return 0 });
    this.spans     = this.options.spans ? this.options.spans.map(function(s){ return $(s) }) : false;
    this.options.startSpan = $(this.options.startSpan || null);
    this.options.endSpan   = $(this.options.endSpan || null);

    this.restricted = this.options.restricted || false;

    this.maximum   = this.options.maximum || this.range.end;
    this.minimum   = this.options.minimum || this.range.start;

    // Will be used to align the handle onto the track, if necessary
    this.alignX = parseInt(this.options.alignX || ''0'');
    this.alignY = parseInt(this.options.alignY || ''0'');
    
    this.trackLength = this.maximumOffset() - this.minimumOffset();
    this.handleLength = this.isVertical() ? this.handles[0].offsetHeight : this.handles[0].offsetWidth;

    this.active   = false;
    this.dragging = false;
    this.disabled = false;

    if(this.options.disabled) this.setDisabled();

    // Allowed values array
    this.allowedValues = this.options.values ? this.options.values.sortBy(Prototype.K) : false;
    if(this.allowedValues) {
      this.minimum = this.allowedValues.min();
      this.maximum = this.allowedValues.max();
    }

    this.eventMouseDown = this.startDrag.bindAsEventListener(this);
    this.eventMouseUp   = this.endDrag.bindAsEventListener(this);
    this.eventMouseMove = this.update.bindAsEventListener(this);

    // Initialize handles in reverse (make sure first handle is active)
    this.handles.each( function(h,i) {
      i = slider.handles.length-1-i;
      slider.setValue(parseFloat(
        (slider.options.sliderValue instanceof Array ? 
          slider.options.sliderValue[i] : slider.options.sliderValue) || 
         slider.range.start), i);
      Element.makePositioned(h); // fix IE
      Event.observe(h, "mousedown", slider.eventMouseDown);
    });
    
    Event.observe(this.track, "mousedown", this.eventMouseDown);
    Event.observe(document, "mouseup", this.eventMouseUp);
    Event.observe(document, "mousemove", this.eventMouseMove);
    
    this.initialized = true;
  },
  dispose: function() {
    var slider = this;    
    Event.stopObserving(this.track, "mousedown", this.eventMouseDown);
    Event.stopObserving(document, "mouseup", this.eventMouseUp);
    Event.stopObserving(document, "mousemove", this.eventMouseMove);
    this.handles.each( function(h) {
      Event.stopObserving(h, "mousedown", slider.eventMouseDown);
    });
  },
  setDisabled: function(){
    this.disabled = true;
  },
  setEnabled: function(){
    this.disabled = false;
  },  
  getNearestValue: function(value){
    if(this.allowedValues){
      if(value >= this.allowedValues.max()) return(this.allowedValues.max());
      if(value <= this.allowedValues.min()) return(this.allowedValues.min());
      
      var offset = Math.abs(this.allowedValues[0] - value);
      var newValue = this.allowedValues[0];
      this.allowedValues.each( function(v) {
        var currentOffset = Math.abs(v - value);
        if(currentOffset <= offset){
          newValue = v;
          offset = currentOffset;
        } 
      });
      return newValue;
    }
    if(value > this.range.end) return this.range.end;
    if(value < this.range.start) return this.range.start;
    return value;
  },
  setValue: function(sliderValue, handleIdx){
    if(!!this.active) {
      this.activeHandle    = this.handles[handleIdx];
      this.activeHandleIdx = handleIdx;
      this.updateStyles();
    }
    handleIdx = handleIdx || this.activeHandleIdx || 0;
    if(this.initialized && this.restricted) {
      if((handleIdx>0) && (sliderValue<this.values[handleIdx-1]))
        sliderValue = this.values[handleIdx-1];
      if((handleIdx < (this.handles.length-1)) && (sliderValue>this.values[handleIdx+1]))
        sliderValue = this.values[handleIdx+1];
    }
    sliderValue = this.getNearestValue(sliderValue);
    this.values[handleIdx] = sliderValue;
    this.value = this.values[0]; // assure backwards compat
    
    this.handles[handleIdx].style[this.isVertical() ? ''top'' : ''left''] = 
      this.translateToPx(sliderValue);
    
    this.drawSpans();
    if(!!this.dragging || !!this.event) this.updateFinished();
  },
  setValueBy: function(delta, handleIdx) {
    this.setValue(this.values[handleIdx || this.activeHandleIdx || 0] + delta, 
      handleIdx || this.activeHandleIdx || 0);
  },
  translateToPx: function(value) {
    return Math.round(
      ((this.trackLength-this.handleLength)/(this.range.end-this.range.start)) * 
      (value - this.range.start)) + "px";
  },
  translateToValue: function(offset) {
    return ((offset/(this.trackLength-this.handleLength) * 
      (this.range.end-this.range.start)) + this.range.start);
  },
  getRange: function(range) {
    var v = this.values.sortBy(Prototype.K); 
    range = range || 0;
    return $R(v[range],v[range+1]);
  },
  minimumOffset: function(){
    return(this.isVertical() ? this.alignY : this.alignX);
  },
  maximumOffset: function(){
    return(this.isVertical() ?
      this.track.offsetHeight - this.alignY : this.track.offsetWidth - this.alignX);
  },  
  isVertical:  function(){
    return (this.axis == ''vertical'');
  },
  drawSpans: function() {
    var slider = this;
    if(this.spans)
      $R(0, this.spans.length-1).each(function(r) { slider.setSpan(slider.spans[r], slider.getRange(r)) });
    if(this.options.startSpan)
      this.setSpan(this.options.startSpan,
        $R(0, this.values.length>1 ? this.getRange(0).min() : this.value ));
    if(this.options.endSpan)
      this.setSpan(this.options.endSpan, 
        $R(this.values.length>1 ? this.getRange(this.spans.length-1).max() : this.value, this.maximum));
  },
  setSpan: function(span, range) {
    if(this.isVertical()) {
      span.style.top = this.translateToPx(range.start);
      span.style.height = this.translateToPx(range.end - range.start);
    } else {
      span.style.left = this.translateToPx(range.start);
      span.style.width = this.translateToPx(range.end - range.start);
    }
  },
  updateStyles: function() {
    this.handles.each( function(h){ Element.removeClassName(h, ''selected'') });
    Element.addClassName(this.activeHandle, ''selected'');
  },
  startDrag: function(event) {
    if(Event.isLeftClick(event)) {
      if(!!this.disabled){
        this.active = true;
        
        var handle = Event.element(event);
        var pointer  = [Event.pointerX(event), Event.pointerY(event)];
        if(handle==this.track) {
          var offsets  = Position.cumulativeOffset(this.track); 
          this.event = event;
          this.setValue(this.translateToValue( 
           (this.isVertical() ? pointer[1]-offsets[1] : pointer[0]-offsets[0])-(this.handleLength/2)
          ));
          var offsets  = Position.cumulativeOffset(this.activeHandle);
          this.offsetX = (pointer[0] - offsets[0]);
          this.offsetY = (pointer[1] - offsets[1]);
        } else {
          // find the handle (prevents issues with Safari)
          while((this.handles.indexOf(handle) == -1) && handle.parentNode) 
            handle = handle.parentNode;
        
          this.activeHandle    = handle;
          this.activeHandleIdx = this.handles.indexOf(this.activeHandle);
          this.updateStyles();
        
          var offsets  = Position.cumulativeOffset(this.activeHandle);
          this.offsetX = (pointer[0] - offsets[0]);
          this.offsetY = (pointer[1] - offsets[1]);
        }
      }
      Event.stop(event);
    }
  },
  update: function(event) {
   if(this.active) {
      if(!!this.dragging) this.dragging = true;
      this.draw(event);
      // fix AppleWebKit rendering
      if(navigator.appVersion.indexOf(''AppleWebKit'')>0) window.scrollBy(0,0);
      Event.stop(event);
   }
  },
  draw: function(event) {
    var pointer = [Event.pointerX(event), Event.pointerY(event)];
    var offsets = Position.cumulativeOffset(this.track);
    pointer[0] -= this.offsetX + offsets[0];
    pointer[1] -= this.offsetY + offsets[1];
    this.event = event;
    this.setValue(this.translateToValue( this.isVertical() ? pointer[1] : pointer[0] ));
    if(this.initialized && this.options.onSlide)
      this.options.onSlide(this.values.length>1 ? this.values : this.value, this);
  },
  endDrag: function(event) {
    if(this.active && this.dragging) {
      this.finishDrag(event, true);
      Event.stop(event);
    }
    this.active = false;
    this.dragging = false;
  },  
  finishDrag: function(event, success) {
    this.active = false;
    this.dragging = false;
    this.updateFinished();
  },
  updateFinished: function() {
    if(this.initialized && this.options.onChange) 
      this.options.onChange(this.values.length>1 ? this.values : this.value, this);
    this.event = null;
  }
}
'!

scriptaculousSliderJsResource
	"WebStyle new scriptaculousSliderJsResource"
	^self resources at: #jsScriptaculousSlider ifAbsentPut:
		[WebMethodResource 
			fromMethod: #scriptaculousSliderJs on: self 
			contentType: 'text/javascript' preferedUrl: '/scriptaculous/slider.js' site: self site].!

searchButton
	searchButton isNil ifTrue: 
		[searchButton := WebButton new
			title: 'Search'; text: 'S'; action: #search; style: '{font-size: 90%}';
			tabIndex: 99;
			id: #search234;
			yourself].
	^searchButton!

session
	"try to find a first sender up in calling stack, who is AIDASite and find a session in 
	arguments of its local variable stack"
	| stackFrame |
	stackFrame := Processor activeProcess frameAtAddress: thisContext.
	[stackFrame class == StackFrame or: [stackFrame class == BlockFrame] ] whileTrue: [
		(stackFrame receiver class == AIDASite) ifTrue: 
			[^stackFrame arguments detect: [:each | each class == WebSession] ifNone: [nil] ].
		stackFrame := stackFrame sender].
	^nil
!

site
	^site!

site: anAIDASite
	site := anAIDASite!

smallNumber: aNumber

	^self smallText: aNumber printDotString!

smallNumber: aNumber attributes: aSymbol

	^self smallText: aNumber printDotString attributes: aSymbol!

smallText: aText

	| text |
	text := aText isEmpty ifTrue: ['&nbsp;'] ifFalse: [aText].
	^(WebText text: text) size: -1; font: #helvetica!

smallText: aText attributes: aSymbol

	| text |
	text := aText isEmpty ifTrue: ['&nbsp;'] ifFalse: [aText].
	^(WebText text: text attributes: aSymbol) size: -1; font: #helvetica!

tab1BgGif
	"'/home/mivsek/download/tab1bg.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 1 0 45 0 132 32 0 221 227 213 219 225 211 254 254 254 242 244 238 230 233 224 218 224 210 252 252 252 245 247 242 249 249 247 234 237 228 224 228 214 229 232 222 238 241 234 237 240 233 239 242 235 226 229 218 248 248 246 247 247 245 243 245 240 233 236 227 250 250 248 251 251 251 235 238 231 119 102 85 227 230 219 228 231 221 253 253 253 236 239 232 225 228 217 241 243 238 224 227 216 232 235 226 44 0 0 0 0 1 0 45 0 0 5 33 96 81 4 36 96 42 232 131 101 11 225 78 73 98 109 13 227 12 221 32 29 71 4 33 8 74 197 96 208 8 142 151 16 0 59 ]!

tab1LeftGif
	"'imgs/tab1left.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 9 0 150 0 196 31 0 183 174 136 239 237 229 224 220 204 236 234 224 241 239 233 231 228 216 215 210 189 219 214 196 214 209 187 244 243 237 251 251 250 246 245 242 232 229 218 223 219 203 248 247 244 217 213 194 225 222 208 241 239 232 240 238 231 197 190 160 235 232 222 237 235 226 238 236 227 249 248 246 220 216 198 188 180 144 211 207 183 216 211 191 238 236 228 229 226 212 199 192 163 226 229 218 33 249 4 1 0 0 31 0 44 0 0 0 0 9 0 150 0 0 5 240 224 39 66 136 151 1 128 120 76 199 224 40 202 247 104 4 108 67 83 4 95 206 178 104 15 5 111 145 40 78 24 195 4 33 34 201 36 122 202 8 199 2 232 17 9 1 75 165 234 75 72 44 3 10 160 139 173 80 196 100 51 131 49 86 6 40 133 14 4 80 148 12 10 16 65 131 46 165 116 26 24 15 0 4 18 21 12 16 129 27 131 1 3 135 7 27 8 139 119 2 7 6 145 88 147 149 151 140 5 148 150 146 157 154 160 158 155 153 159 152 161 167 156 164 163 162 168 172 175 174 171 178 166 165 169 182 176 179 170 181 173 187 183 189 184 180 191 177 190 185 188 196 193 197 194 198 195 186 201 207 192 209 200 210 206 212 199 213 211 217 216 219 215 221 205 222 204 225 203 227 202 229 208 218 224 228 231 220 223 237 226 230 214 238 234 241 239 235 233 240 232 242 248 236 245 244 243 249 253 0 254 227 55 240 158 61 125 7 3 18 220 103 208 31 67 132 14 19 22 132 40 240 161 194 134 21 37 90 10 1 0 59 ]!

tab1LeftOnGif
	"'imgs/tab1lefton.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 9 0 150 0 196 31 0 255 255 255 119 102 85 254 254 254 253 253 252 250 250 248 249 249 247 253 253 253 252 252 250 249 248 246 248 247 245 245 244 239 246 245 241 244 242 237 242 241 235 246 245 240 247 246 242 221 217 213 187 179 170 245 244 243 129 113 97 233 230 227 152 139 126 147 133 120 147 133 119 174 164 154 214 212 204 242 241 234 214 212 203 196 189 180 185 177 167 183 174 164 226 229 218 33 249 4 1 0 0 31 0 44 0 0 0 0 9 0 150 0 0 5 223 224 39 102 93 53 5 129 200 89 17 36 1 192 199 97 20 108 111 87 109 195 94 180 219 21 200 15 54 121 13 3 67 24 18 38 104 54 3 78 131 97 64 13 76 7 7 2 161 80 8 80 179 136 68 226 17 208 22 16 15 135 130 81 62 39 212 141 70 59 236 96 52 52 229 109 98 177 102 103 207 15 124 10 1 7 127 97 11 11 94 88 91 8 97 86 83 89 91 93 82 87 133 7 80 77 148 85 76 78 79 73 0 75 71 159 161 63 164 59 166 54 168 74 163 172 73 170 160 173 162 174 177 165 180 167 182 169 184 171 179 188 178 190 181 189 192 191 183 193 196 195 185 197 200 199 187 203 176 201 204 194 209 198 210 202 212 208 211 216 213 217 215 218 221 220 223 206 205 175 227 186 225 214 230 219 232 222 234 224 228 207 236 240 238 226 229 242 231 245 233 247 235 249 237 244 253 239 251 241 252 205 251 39 208 94 65 124 7 245 37 4 23 2 0 59 ]!

tab1RightGif
	"'imgs/tab1right.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 144 1 150 0 196 31 0 213 208 186 183 174 136 210 204 181 217 212 193 226 222 208 233 230 219 222 218 201 243 242 236 214 209 188 235 232 222 214 208 187 236 234 224 240 238 231 247 246 243 238 236 227 231 228 216 250 250 248 253 253 252 201 194 166 212 207 184 208 202 178 205 199 173 203 196 169 192 184 151 229 226 212 220 216 198 216 211 191 207 201 176 206 200 174 202 195 167 252 252 251 226 229 218 33 249 4 1 0 0 31 0 44 0 0 0 0 144 1 150 0 0 5 255 96 32 142 100 105 158 104 170 174 108 235 190 112 44 207 116 109 223 120 174 239 176 68 101 159 96 100 72 44 26 143 200 164 114 201 108 58 159 208 168 116 74 173 90 175 216 172 118 203 117 122 32 7 130 224 34 8 66 206 232 180 122 205 110 187 223 240 184 124 78 175 219 239 248 188 126 207 239 251 255 128 115 13 7 12 9 6 18 101 13 138 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 163 150 7 7 11 15 4 3 23 25 166 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 186 12 14 9 24 6 25 29 22 12 209 210 211 212 213 214 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 232 233 234 221 202 169 205 99 14 241 242 243 244 245 246 247 248 249 250 251 252 253 254 255 0 3 10 28 72 176 160 193 131 8 19 42 236 151 160 0 179 12 3 16 4 88 64 177 162 197 139 24 51 106 220 200 177 163 199 143 32 67 138 28 73 178 164 201 147 40 83 255 170 92 201 178 229 199 4 9 30 60 28 160 33 0 204 155 56 115 234 220 201 179 167 207 159 64 131 10 29 74 180 168 209 163 72 147 42 93 202 180 169 211 167 67 11 184 203 160 65 98 129 171 88 179 106 221 202 181 171 215 175 96 195 138 29 75 182 172 217 179 104 211 170 93 203 182 173 219 183 112 199 202 36 0 17 129 196 7 120 243 234 221 203 183 175 223 191 128 3 11 30 76 184 176 225 195 136 19 43 94 204 184 177 227 199 144 35 19 198 64 160 153 221 9 1 8 104 222 204 185 179 231 207 160 67 139 30 77 186 180 233 211 168 83 171 94 205 186 181 235 215 176 99 203 158 125 186 153 6 0 2 4 4 48 192 187 183 239 223 192 131 11 31 78 188 184 241 227 200 147 43 95 206 188 185 243 231 208 163 75 159 78 189 250 241 12 16 53 76 160 64 97 67 128 1 224 195 139 31 79 190 188 249 243 232 211 171 95 207 190 189 251 247 240 227 203 159 79 191 190 253 251 248 243 179 175 186 157 67 133 10 1 216 37 224 128 4 22 104 224 129 8 38 168 224 255 130 12 54 232 224 131 16 70 40 225 132 20 86 104 225 133 24 102 168 225 131 19 8 176 65 5 22 116 16 224 134 36 150 104 226 137 40 166 168 226 138 44 182 168 33 0 29 82 224 95 7 34 2 96 227 141 56 230 168 227 142 60 246 232 227 143 64 6 41 228 144 68 22 105 228 145 72 38 169 228 146 76 54 233 228 147 65 78 16 35 136 29 72 16 0 148 88 102 169 229 150 92 118 233 229 151 96 134 9 165 148 2 80 64 165 149 98 166 169 230 154 108 182 233 230 155 112 226 72 166 153 33 162 25 231 157 120 230 169 231 158 124 114 57 231 153 87 246 41 232 160 132 22 106 168 155 127 214 25 232 161 140 54 234 232 163 144 242 152 104 149 139 70 106 233 165 152 102 202 230 164 118 106 234 233 167 160 134 122 36 167 149 138 106 234 169 168 122 74 106 170 172 182 234 234 161 171 190 42 235 172 180 182 25 107 173 184 230 170 235 147 183 238 234 235 175 192 250 216 107 176 196 22 187 235 176 198 38 171 108 171 200 46 235 236 179 170 78 169 40 180 212 86 139 105 255 179 214 102 171 45 159 216 110 235 237 183 182 74 75 41 184 228 150 187 169 184 157 154 171 238 186 90 118 203 238 187 240 18 233 110 188 244 214 171 227 188 246 230 75 47 190 250 246 187 46 191 254 6 12 46 192 2 23 156 45 193 6 39 252 44 194 10 55 108 44 195 14 71 252 43 196 18 87 140 43 197 22 103 252 42 198 26 119 140 42 199 30 135 12 42 200 34 151 124 45 186 165 154 172 50 179 40 175 236 178 171 36 191 44 243 160 49 207 108 179 158 53 223 172 51 156 57 239 236 243 154 61 255 44 52 152 65 15 109 244 150 69 31 173 52 175 45 47 237 116 158 73 63 45 181 145 81 79 109 117 148 77 95 173 117 152 85 111 237 181 156 89 127 45 54 150 93 143 189 117 217 102 95 141 118 218 83 175 205 246 211 110 191 189 116 220 114 31 77 119 221 67 223 141 247 207 122 239 189 115 223 126 223 12 120 224 51 15 78 248 203 134 31 190 114 226 138 155 204 120 227 34 63 14 185 199 146 79 174 113 229 150 91 140 121 230 18 111 206 185 195 158 127 174 112 254 232 162 27 76 122 233 2 159 142 186 191 170 175 174 111 235 174 219 11 123 236 251 134 77 251 215 179 223 254 110 238 186 255 107 123 239 106 255 14 124 219 194 15 15 119 241 198 207 141 124 242 118 47 207 124 222 206 63 207 119 244 210 255 77 125 245 130 95 143 125 225 218 111 143 120 247 222 47 14 126 248 142 143 79 126 228 230 159 79 121 250 234 95 206 126 251 154 191 15 127 231 242 207 15 122 253 246 143 142 127 254 166 239 207 127 234 254 251 31 235 2 40 192 215 17 176 128 178 59 32 2 107 87 38 64 45 208 101 188 123 96 174 34 40 193 90 81 176 130 179 186 32 6 55 166 192 13 154 75 131 30 100 21 8 67 248 177 14 146 240 91 35 60 161 168 82 168 194 145 153 176 133 7 123 33 12 171 197 194 25 102 170 134 54 188 20 14 115 24 169 29 242 240 81 62 252 97 163 130 40 68 88 201 176 136 15 59 34 18 137 69 196 37 210 76 137 78 156 24 20 163 120 172 41 82 113 130 86 188 162 5 179 168 197 12 114 177 139 28 108 160 162 66 0 0 59 ]!

tab1RightOnGif
	"'imgs/tab1righton.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 144 1 150 0 196 31 0 255 255 255 253 253 252 254 254 254 244 242 237 249 249 247 242 241 234 119 102 85 242 241 235 250 250 248 247 246 242 246 245 241 248 247 245 209 205 193 145 131 116 229 225 213 232 230 218 239 237 230 174 164 150 249 248 246 234 232 222 237 234 226 231 227 216 245 244 239 246 245 240 253 253 253 241 240 233 252 252 250 240 238 231 189 181 169 235 233 223 128 112 95 226 229 218 33 249 4 1 0 0 31 0 44 0 0 0 0 144 1 150 0 0 5 255 160 33 142 100 105 158 104 170 174 108 235 190 112 44 207 116 109 223 120 174 239 175 215 68 140 143 16 64 44 26 143 200 164 114 201 108 58 159 208 168 116 74 173 90 175 216 172 118 203 237 58 5 1 9 133 17 105 112 134 222 180 122 205 110 187 223 240 184 156 11 150 88 54 227 200 121 206 239 251 255 128 129 130 131 69 117 22 16 29 15 12 13 12 132 142 143 144 145 146 147 109 134 136 15 14 17 17 148 156 157 158 159 160 129 150 137 21 139 161 167 168 169 170 171 75 163 152 14 30 172 178 179 180 181 162 97 135 164 14 6 2 189 190 191 192 193 194 195 196 197 198 199 200 201 202 203 204 205 206 207 208 209 210 211 212 213 214 199 24 26 18 3 151 14 187 1 224 225 226 227 228 229 230 231 232 233 234 235 236 237 238 239 240 241 242 243 244 245 246 247 248 249 234 26 4 9 220 19 175 12 16 24 72 176 160 193 131 8 19 42 92 200 176 161 195 135 16 35 74 156 72 177 162 197 139 24 51 106 220 200 209 225 130 11 5 40 60 168 224 205 64 130 147 40 83 255 170 92 201 178 165 203 151 48 99 202 156 73 179 166 205 155 56 115 234 220 201 179 167 207 159 64 99 42 184 112 96 67 34 111 187 6 40 93 202 180 169 211 167 80 163 74 157 74 181 170 213 171 88 179 106 221 202 181 171 215 175 96 195 138 29 75 245 64 81 10 0 145 26 40 192 182 173 219 183 112 227 202 157 75 183 174 221 187 120 243 234 221 203 183 175 223 191 128 3 11 30 76 184 240 221 12 16 208 190 218 101 184 177 227 199 144 35 75 158 76 185 178 229 194 25 54 36 38 85 161 130 1 179 160 67 139 30 77 186 180 233 211 168 83 171 94 205 186 181 235 215 176 99 203 158 77 187 182 237 219 184 87 23 64 76 33 209 131 7 6 200 10 31 78 188 184 241 227 200 147 43 95 46 252 0 111 10 189 13 40 152 78 189 186 245 235 216 179 107 223 206 189 187 247 239 224 195 139 31 79 190 188 249 243 232 211 171 95 207 190 251 133 11 22 6 236 214 12 193 192 130 251 248 243 235 223 207 191 191 255 255 0 6 40 224 128 4 22 104 224 129 8 38 168 224 255 130 12 54 232 224 131 16 10 120 18 124 3 128 38 80 71 24 102 168 225 134 28 118 232 225 135 32 134 216 145 4 11 36 48 221 123 6 32 160 226 138 44 182 232 226 139 48 198 40 227 140 52 214 104 227 141 56 230 168 227 142 60 246 232 227 143 64 6 41 228 144 55 14 36 193 145 18 24 160 207 146 76 54 233 228 147 80 70 41 229 148 84 50 169 193 149 43 242 114 205 150 92 118 233 229 151 96 134 41 230 152 100 110 137 193 153 104 26 96 203 154 108 182 233 102 26 106 190 41 231 156 116 214 89 68 156 118 230 169 231 158 168 224 201 231 159 128 6 42 136 159 130 22 106 232 161 112 34 170 232 162 140 78 65 104 163 144 70 202 232 163 146 86 106 233 159 148 94 170 233 166 111 102 202 233 167 160 178 226 105 168 164 150 218 201 168 166 166 170 234 32 168 174 234 234 171 113 180 10 235 172 180 118 33 107 173 184 230 234 168 174 188 246 122 197 173 190 6 235 43 176 194 22 139 43 177 198 38 251 42 178 202 54 107 42 179 206 70 251 41 180 210 86 107 41 255 181 214 102 219 40 182 218 118 123 40 183 222 134 11 40 184 226 150 155 39 185 230 166 43 39 186 234 182 187 38 187 238 198 43 11 188 242 214 219 167 189 248 242 73 111 190 252 78 178 111 191 0 59 242 111 192 4 3 50 112 193 8 207 113 112 194 12 187 177 112 195 16 39 26 241 196 167 82 108 177 191 23 103 252 200 195 26 119 236 4 199 30 135 156 4 200 34 151 76 4 201 38 139 140 114 202 30 175 204 178 198 46 191 124 113 204 50 83 76 115 205 17 223 140 115 195 58 239 156 112 207 62 23 12 116 208 1 15 77 116 191 70 31 157 111 210 74 219 203 116 211 242 62 13 181 187 82 79 173 110 213 86 155 139 117 214 226 110 205 181 183 94 127 173 109 216 98 91 75 118 217 210 158 141 182 179 106 175 173 108 219 110 27 11 119 220 194 206 77 247 176 119 251 108 119 222 186 238 205 247 177 127 215 236 119 224 179 14 78 248 178 135 179 108 120 226 170 46 206 248 179 143 151 236 120 228 161 78 78 249 180 151 183 156 121 199 150 111 126 105 231 158 87 10 122 140 232 145 142 78 250 182 167 219 156 250 196 166 175 142 104 235 174 27 10 123 236 130 206 78 251 184 183 255 156 59 194 182 239 174 103 239 190 219 9 124 240 116 14 79 252 186 199 35 157 60 191 198 47 207 102 243 206 219 2 125 244 180 76 79 253 188 215 71 157 125 188 214 111 159 74 247 222 159 2 126 248 160 140 79 190 39 230 159 207 73 250 234 99 220 126 184 236 191 15 73 252 242 11 92 127 183 244 223 63 168 254 217 230 207 255 31 254 251 95 31 2 40 64 133 21 48 90 4 60 32 28 18 168 64 135 53 240 109 33 0 0 59 ]!

tab2BottomGif
	"'imgs/tab2bottom.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 1 0 1 0 128 0 0 204 204 204 0 0 0 33 249 4 0 0 0 0 0 44 0 0 0 0 1 0 1 0 0 2 2 68 1 0 59 13 10 ]!

tab3BackGif
	"'imgs/jure-tabs-back.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 7 0 24 0 213 0 0 0 0 0 255 255 255 254 255 254 254 255 253 251 252 250 251 252 249 250 251 248 250 251 247 248 249 245 247 248 242 245 246 240 244 245 238 243 244 237 242 243 236 243 244 236 242 243 235 243 243 234 243 243 235 242 242 234 244 244 237 243 243 236 242 242 235 247 247 241 246 246 240 245 245 239 244 244 238 243 243 237 248 248 243 247 247 242 246 246 241 249 249 245 247 247 243 246 246 242 252 252 249 251 251 248 250 250 247 252 252 250 250 250 248 254 254 253 253 253 252 247 246 242 251 250 247 254 253 252 252 251 250 254 254 254 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 45 0 44 0 0 0 0 7 0 24 0 64 6 88 192 71 37 242 128 72 32 30 15 34 153 12 56 159 1 140 116 138 97 153 88 44 1 107 0 125 106 40 140 73 216 97 65 129 56 40 139 37 180 34 21 8 132 85 119 78 127 70 40 148 72 227 190 232 103 22 127 23 10 23 29 131 29 9 28 31 31 27 139 34 6 7 41 37 35 37 39 149 39 42 42 39 117 155 156 157 80 65 0 59 ]!

tab5BgGif
	"'imgs/jure-tab-bg.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 20 0 45 0 196 0 0 221 227 213 219 225 211 254 254 254 242 244 238 230 233 224 218 224 210 252 252 252 245 247 242 249 249 247 234 237 228 224 228 214 229 232 222 238 241 234 237 240 233 239 242 235 226 229 218 248 248 246 247 247 245 243 245 240 233 236 227 250 250 248 251 251 251 235 238 231 119 102 85 227 230 219 228 231 221 253 253 253 236 239 232 225 228 217 241 243 238 224 227 216 232 235 226 44 0 0 0 0 20 0 45 0 0 5 40 160 32 142 100 105 158 104 170 174 108 235 190 112 44 207 116 109 223 120 174 239 124 239 255 192 160 112 72 44 26 143 200 228 204 194 108 58 159 207 16 0 59 ]!

tab5LeftGif
	"'imgs/jure-tab-left.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 9 0 142 0 213 0 0 0 0 0 255 255 255 214 226 233 133 176 198 132 175 197 131 174 196 131 173 195 129 171 193 128 170 191 134 177 199 130 172 193 129 170 192 128 169 190 127 168 189 135 177 199 131 172 193 125 164 184 136 178 200 136 177 199 136 178 199 134 175 197 135 176 197 131 170 191 128 167 187 127 165 185 130 169 189 135 173 193 132 168 187 144 177 194 154 184 200 185 206 217 198 215 224 209 223 230 211 224 231 235 241 244 130 173 194 132 175 196 135 178 199 134 177 198 132 175 195 134 177 197 133 174 194 129 169 188 126 165 184 140 175 192 152 183 198 172 197 209 171 196 208 253 254 254 252 253 253 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 50 0 44 0 0 0 0 9 0 142 0 0 6 191 192 128 80 8 19 184 90 195 128 168 131 89 173 134 159 77 211 41 244 56 87 153 20 37 16 114 94 42 145 200 36 198 90 89 36 225 201 4 4 121 168 223 165 151 10 94 42 57 56 168 122 221 193 215 240 255 14 9 9 10 130 133 9 38 38 39 136 139 136 3 4 3 144 145 146 147 148 145 4 151 152 153 154 155 156 36 152 36 160 161 162 163 164 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 200 201 181 5 204 205 206 205 6 206 6 211 212 213 214 213 35 217 218 35 6 217 10 223 223 222 224 227 223 7 230 231 7 10 232 235 231 11 238 232 238 241 239 238 8 245 245 241 245 12 250 247 8 250 254 251 255 2 254 107 240 47 8 0 59 ]!

tab5LeftOnGif
	"'imgs/jure-tab-left-on.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 9 0 142 0 213 0 0 0 0 0 255 255 255 228 228 219 225 225 216 224 224 215 223 223 214 222 222 213 240 240 231 239 239 230 238 238 229 237 237 228 236 236 227 235 235 226 234 234 225 232 232 223 231 231 222 227 227 219 226 226 218 225 225 217 224 224 216 223 223 215 222 222 214 221 221 213 220 220 212 219 219 211 218 218 210 217 217 209 216 216 208 240 240 232 239 239 231 236 236 228 234 234 226 233 233 225 232 232 224 230 230 222 220 220 213 215 215 208 214 214 207 228 228 221 226 226 219 224 224 217 236 236 230 231 231 225 229 229 223 239 239 234 242 242 238 245 245 242 245 245 243 244 244 242 250 250 249 254 254 254 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 51 0 44 0 0 0 0 9 0 142 0 0 6 255 192 128 112 248 74 169 134 129 152 106 82 144 12 91 17 138 193 224 12 176 8 149 138 32 145 8 184 38 134 129 130 195 149 153 10 162 14 135 156 128 77 66 235 53 55 5 137 31 14 220 149 231 206 231 158 16 124 119 92 19 129 130 9 132 133 131 133 120 135 139 138 137 9 20 8 147 148 92 146 148 147 150 152 153 145 156 92 92 21 159 162 9 161 163 160 166 167 168 165 166 171 163 173 162 175 159 177 169 172 168 164 182 179 183 170 184 188 187 190 181 191 174 189 192 196 194 193 176 195 198 197 200 199 178 201 204 203 206 205 180 202 213 208 214 210 209 212 215 220 217 216 219 222 221 224 227 186 218 229 223 231 226 233 225 236 228 185 239 207 237 235 238 241 244 211 243 248 240 247 250 230 252 232 254 234 0 202 19 104 175 95 189 124 7 9 38 176 160 160 161 67 46 12 27 46 104 200 101 196 130 139 24 43 98 204 152 96 4 131 143 32 185 92 96 240 161 100 73 46 24 76 154 68 9 162 165 75 46 25 92 190 76 16 19 68 136 155 32 96 222 220 25 130 139 134 18 16 14 130 6 245 25 244 129 81 7 92 54 216 34 177 212 86 16 0 59 ]!

tab5RightGif
	"'imgs/jure-tab-right.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 236 0 142 0 213 0 0 0 0 0 255 255 255 133 176 198 132 175 197 131 174 196 131 173 195 129 171 193 128 170 191 126 167 188 124 164 185 134 177 199 130 172 193 129 170 192 128 169 190 127 168 189 126 166 187 125 165 186 124 164 184 123 163 183 135 177 199 129 169 190 125 164 184 123 162 182 136 178 200 136 178 199 135 176 198 134 175 197 137 178 200 137 179 200 133 173 194 127 165 185 138 179 200 139 180 201 139 179 200 133 172 192 131 169 189 130 168 187 129 167 186 128 166 185 141 181 202 140 180 201 139 178 199 138 178 198 130 167 186 142 182 202 134 172 191 132 169 188 131 168 187 134 170 189 130 173 194 132 175 196 125 166 186 135 178 199 134 177 198 131 173 193 127 166 185 126 165 184 130 170 189 140 181 201 137 177 196 131 169 187 132 169 187 133 170 188 255 255 255 33 249 4 1 0 0 63 0 44 0 0 0 0 236 0 142 0 0 6 255 64 83 169 180 34 189 120 61 151 111 185 132 57 159 208 168 116 74 173 90 175 216 172 118 203 237 122 191 93 230 210 213 235 253 206 232 223 77 72 52 34 147 226 184 124 78 175 219 239 248 188 126 207 239 251 255 128 118 46 100 60 47 47 105 63 30 38 108 69 134 111 73 131 145 146 147 148 149 150 151 152 153 154 155 156 157 158 159 160 161 162 131 101 60 133 36 43 105 28 31 31 32 32 40 58 58 39 179 44 181 182 183 184 185 186 187 188 189 190 191 192 193 194 195 196 197 198 199 185 41 59 45 43 67 38 103 27 171 173 174 176 178 179 215 216 217 218 219 220 221 222 223 224 225 226 227 228 229 230 231 231 182 218 177 42 35 37 207 63 23 209 172 211 175 213 214 232 249 250 251 252 253 254 255 249 98 233 64 129 2 68 8 17 38 110 252 192 32 143 131 180 122 246 8 74 156 72 177 162 197 139 24 51 106 220 200 177 163 199 143 32 67 138 252 40 112 160 68 87 174 88 117 240 240 131 6 195 134 15 33 162 156 73 179 166 205 155 56 115 234 220 201 179 167 207 255 159 64 131 10 29 106 147 222 7 14 57 112 76 112 201 112 67 180 152 70 163 74 157 74 181 170 213 171 88 179 106 221 202 181 171 215 175 96 89 205 164 234 112 67 134 10 10 150 50 189 32 207 169 67 168 97 227 202 157 75 183 174 221 187 88 223 58 101 139 129 66 141 180 106 49 8 102 219 214 169 225 195 136 19 43 94 204 184 177 227 199 144 35 75 158 76 185 178 229 201 111 57 36 38 44 152 134 141 26 127 21 0 166 65 90 240 96 194 168 83 171 94 205 186 181 235 215 176 99 203 158 77 187 182 237 219 184 83 155 238 76 99 130 6 1 2 64 135 6 60 65 45 233 227 200 147 43 95 206 188 185 243 231 208 163 75 159 78 189 186 245 235 212 119 51 47 62 65 52 240 239 193 65 139 30 207 189 188 249 243 232 211 171 95 207 190 189 251 247 240 227 203 159 79 191 126 250 241 162 65 15 24 0 190 191 240 255 0 6 40 224 128 4 22 104 224 129 8 38 168 224 130 12 54 232 224 131 195 229 71 32 112 251 85 184 95 127 24 102 168 225 134 28 118 232 255 225 135 32 134 40 226 136 36 150 104 226 137 26 90 168 226 133 40 182 232 226 139 48 198 40 227 140 38 174 184 34 141 56 230 168 227 142 60 186 104 227 143 44 246 40 228 144 68 22 137 34 144 72 86 104 228 146 76 54 201 100 146 80 58 41 229 148 84 194 8 101 148 85 102 169 229 150 27 94 153 36 151 96 134 153 165 151 72 138 105 230 153 70 146 9 36 154 108 182 153 163 154 63 186 41 231 156 45 194 105 35 157 120 230 9 162 157 55 234 233 231 159 224 241 169 34 160 132 250 41 168 133 133 38 74 231 161 74 42 234 40 155 140 6 249 232 164 96 70 202 31 165 152 110 105 105 166 156 86 185 105 167 160 54 249 105 168 164 18 57 106 169 168 238 120 106 170 172 206 184 106 171 176 250 24 105 172 180 190 248 106 173 184 134 120 107 174 188 114 184 107 175 192 246 247 107 176 196 14 75 44 176 198 30 203 107 178 202 226 202 108 179 180 62 11 45 172 210 78 203 106 181 214 162 138 109 182 164 110 203 45 168 222 126 203 105 184 226 98 74 110 185 147 158 139 255 174 163 234 174 155 104 187 238 18 10 111 188 127 206 75 175 158 246 222 139 103 190 250 206 201 111 191 110 254 11 48 164 179 14 172 109 193 6 119 139 112 194 224 46 204 240 184 14 63 108 110 196 18 167 75 113 197 236 94 140 241 187 26 111 44 111 199 30 215 11 114 200 248 142 76 242 190 38 159 236 111 202 42 7 204 114 203 4 51 10 51 199 50 207 252 113 205 54 139 140 115 206 37 239 204 51 202 62 255 188 114 208 66 187 76 116 209 49 31 138 52 208 74 47 61 116 211 78 27 13 117 212 73 11 74 181 212 86 95 93 53 159 90 111 109 103 215 104 10 12 118 140 98 143 109 235 203 102 23 89 118 218 71 162 205 182 144 107 191 93 98 220 114 143 72 119 221 186 186 141 247 155 122 239 77 227 221 126 119 8 120 224 93 246 77 184 149 134 31 46 235 209 138 247 56 120 227 129 38 14 121 141 146 79 78 226 227 150 99 62 185 230 144 115 222 184 231 138 131 126 184 232 132 147 30 184 233 126 163 190 183 234 120 91 42 169 229 124 67 41 195 236 50 184 110 255 251 237 184 231 174 251 238 188 211 46 3 1 192 7 79 128 239 196 23 111 252 241 200 39 175 252 242 204 55 239 252 243 208 71 47 253 244 209 11 47 124 1 216 103 175 253 246 214 119 239 253 247 224 135 47 254 248 228 151 111 254 249 232 167 175 254 250 215 111 239 126 246 4 188 95 64 12 244 211 47 255 253 248 231 175 255 254 252 247 239 255 255 0 12 160 0 7 248 190 250 217 79 126 6 92 128 2 23 200 192 6 58 240 129 16 140 160 4 39 72 193 10 90 240 130 24 204 160 6 55 200 65 12 26 112 126 11 52 128 8 71 72 194 18 154 240 132 40 76 161 10 87 200 194 22 186 240 133 48 140 161 12 103 72 67 25 46 48 6 11 40 33 3 118 200 128 3 248 240 135 64 12 162 16 135 72 196 34 26 241 136 72 76 162 18 151 200 196 38 58 241 137 80 20 34 15 25 80 194 28 138 112 135 63 108 128 22 183 200 197 46 122 241 139 96 12 163 24 199 72 198 50 154 241 140 104 76 163 26 215 200 70 49 254 112 135 36 196 98 23 29 64 199 58 218 255 241 142 120 204 163 30 247 200 199 62 250 241 143 128 12 164 32 7 73 200 66 26 82 143 93 60 0 28 123 120 128 45 222 17 1 144 140 164 36 39 73 201 74 90 242 146 152 204 164 38 55 201 201 78 122 242 147 160 12 165 40 37 121 199 45 250 176 135 142 164 227 36 31 192 202 86 186 242 149 176 140 165 44 103 73 203 90 218 242 150 184 204 165 46 119 201 203 94 250 146 149 147 172 163 41 27 217 0 85 66 146 149 51 72 166 50 151 201 204 102 58 243 153 208 140 166 52 167 73 205 106 90 243 154 216 204 166 54 183 217 76 96 66 146 142 90 36 166 3 34 249 128 100 66 224 156 232 76 167 58 215 201 206 118 186 243 157 240 140 167 60 231 73 207 122 218 243 158 248 204 103 59 147 249 128 72 58 192 145 199 156 1 58 19 64 208 8 24 244 160 8 77 168 66 23 202 208 134 58 244 161 16 141 168 68 39 74 209 138 90 244 162 24 53 40 65 19 128 206 25 244 19 1 255 84 101 57 207 89 80 9 152 244 164 40 77 169 74 87 202 210 150 186 244 165 65 48 141 169 76 103 74 211 154 218 244 166 56 85 105 4 8 122 78 143 130 212 152 2 133 64 2 34 128 82 11 24 245 168 72 77 170 82 151 202 212 166 58 245 169 80 141 170 84 167 74 213 170 90 245 170 88 53 42 74 119 218 211 111 6 1 0 59 ]!

tab5RightOnGif
	"'imgs/jure-tab-right-on.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 236 0 142 0 213 0 0 0 0 0 255 255 255 209 209 200 205 205 196 230 230 221 229 229 220 228 228 219 227 227 218 226 226 217 225 225 216 224 224 215 223 223 214 222 222 213 221 221 212 220 220 211 219 219 210 218 218 209 217 217 208 216 216 207 215 215 206 214 214 205 211 211 202 241 241 232 240 240 231 239 239 230 238 238 229 237 237 228 236 236 227 235 235 226 232 232 223 231 231 222 226 226 218 225 225 217 224 224 216 223 223 215 222 222 214 213 213 205 212 212 204 208 208 200 207 207 199 206 206 198 205 205 197 241 241 233 240 240 232 237 237 229 234 234 226 233 233 225 232 232 224 230 230 223 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 49 0 44 0 0 0 0 236 0 142 0 0 6 255 64 145 98 24 42 134 18 72 144 114 201 108 58 159 208 168 116 74 173 90 175 216 172 118 203 93 34 19 197 152 120 28 19 45 206 162 180 144 104 108 187 223 240 184 124 78 175 219 239 248 188 126 207 239 191 135 10 34 97 100 11 35 103 11 106 105 128 139 140 141 142 143 144 145 146 147 148 149 150 151 152 153 154 155 145 137 10 132 22 161 162 22 42 165 166 167 168 169 170 171 172 173 174 175 176 177 178 179 180 181 182 183 172 44 45 5 102 67 98 11 163 193 184 195 196 197 198 199 200 201 195 161 44 8 11 159 49 11 43 193 212 164 202 215 216 217 218 219 184 212 23 48 35 34 209 43 211 213 230 231 232 233 234 235 236 237 238 239 240 241 242 243 241 47 11 227 228 229 244 251 252 253 254 255 0 3 238 251 112 230 66 62 114 2 19 42 92 200 176 97 194 21 27 22 48 184 64 241 96 62 135 24 51 106 220 24 208 162 68 138 32 45 138 28 73 178 164 201 147 40 83 170 92 201 178 165 203 151 48 83 142 58 121 225 35 200 155 6 99 234 220 201 179 167 207 255 159 64 123 130 180 137 179 168 209 163 72 147 42 93 202 180 169 211 167 80 163 74 157 250 244 224 82 6 19 169 106 221 202 181 171 215 175 96 195 30 101 208 0 131 216 179 104 211 170 93 203 150 34 89 12 112 227 182 157 75 183 174 221 180 111 227 234 133 123 183 175 223 191 128 111 230 221 171 55 176 225 195 136 187 234 109 80 150 112 225 196 144 35 75 6 233 24 46 227 202 114 39 107 222 236 23 51 134 203 158 57 139 30 189 214 243 231 198 152 73 171 94 237 213 52 232 212 172 99 203 126 234 26 117 229 217 184 115 31 173 109 90 183 111 223 188 67 255 30 46 59 56 108 226 200 73 27 191 157 188 57 231 229 142 157 75 159 12 157 240 244 235 137 171 239 197 206 61 176 246 199 221 195 219 253 158 89 188 249 182 228 249 158 95 175 54 189 89 246 240 197 186 143 79 255 235 252 250 248 181 222 207 207 31 234 254 254 0 46 245 95 128 4 26 53 96 129 8 82 116 96 130 5 46 200 96 128 14 62 216 95 132 18 230 71 97 133 245 93 136 97 124 26 110 200 255 94 135 30 158 7 98 136 226 141 72 98 119 38 158 136 93 138 42 78 199 98 139 206 189 8 99 114 50 206 72 92 141 54 254 134 99 142 186 237 200 35 110 62 254 88 156 103 175 49 39 164 121 65 30 185 90 146 74 42 71 164 109 209 53 25 30 147 82 62 247 100 111 85 114 71 101 150 212 93 41 28 151 46 122 121 28 152 49 138 105 36 153 205 109 137 38 98 106 174 105 88 155 110 2 6 103 156 157 153 25 37 157 195 205 137 231 120 118 90 183 167 142 125 110 247 39 112 129 130 55 40 144 133 150 119 232 108 122 46 90 90 162 234 57 58 36 102 69 222 41 41 107 141 94 122 86 166 154 134 197 105 167 246 65 250 30 168 78 82 10 165 159 164 142 246 105 170 91 173 202 42 85 174 190 42 85 172 178 250 39 106 173 155 209 138 107 83 186 238 42 224 173 190 70 214 107 176 72 13 75 172 129 192 30 123 152 177 202 222 196 108 179 10 38 11 237 95 207 66 91 109 179 215 42 155 237 177 219 18 219 109 176 223 250 26 238 174 227 226 90 110 173 231 202 154 255 238 171 235 178 218 110 170 239 146 26 47 168 243 118 90 175 166 247 94 154 175 164 251 58 218 239 162 255 30 234 94 164 211 214 101 154 101 14 100 160 240 193 12 55 236 240 195 16 71 44 241 196 20 87 108 113 196 10 103 224 192 3 26 116 236 113 198 32 135 44 242 200 36 151 108 242 201 40 167 172 242 202 44 183 236 242 203 48 175 236 177 199 15 60 176 193 205 56 231 172 243 204 60 247 236 243 207 64 7 45 244 208 68 23 109 244 209 72 39 173 244 210 58 55 157 115 205 78 115 32 181 212 78 87 109 245 213 88 103 173 245 214 92 119 237 245 215 96 135 45 246 212 84 55 93 51 217 45 164 173 246 218 108 183 237 246 219 112 199 45 247 220 116 215 109 247 221 120 231 173 247 222 119 147 253 0 4 106 187 32 248 224 132 23 110 248 225 136 39 174 248 226 140 55 238 248 227 144 71 46 249 228 148 75 174 54 4 17 20 254 194 230 47 116 224 249 231 160 135 46 250 232 164 151 110 250 233 168 167 174 250 234 172 183 238 250 235 176 139 206 249 11 133 71 32 255 129 224 155 127 238 193 238 188 247 238 251 239 192 7 47 252 240 196 23 111 252 241 200 39 175 252 242 204 55 63 252 231 155 11 46 129 4 185 251 78 192 245 216 103 175 253 246 220 119 239 253 247 224 135 47 254 248 228 151 111 254 249 232 167 223 189 239 29 108 46 193 4 158 243 126 125 1 244 27 96 255 253 248 231 175 255 254 252 247 239 255 255 0 12 160 0 7 72 192 2 26 240 128 8 196 31 253 10 112 61 222 121 110 2 20 144 95 253 240 119 128 10 90 240 130 24 204 160 6 55 200 193 14 122 240 131 32 12 161 8 71 72 194 18 154 240 132 21 204 31 253 8 192 59 10 68 208 3 4 40 192 253 42 136 128 26 218 240 134 56 204 161 14 119 200 195 30 250 240 135 64 12 162 16 135 72 196 34 26 241 136 57 76 161 253 24 184 59 10 144 192 3 50 180 223 1 106 216 133 42 90 241 138 88 204 162 22 183 88 197 26 30 224 126 5 240 0 9 72 64 0 41 34 96 9 70 72 132 26 215 200 198 54 186 241 141 112 140 163 28 231 72 199 58 218 119 241 142 120 204 99 27 141 176 4 4 124 209 0 4 32 65 9 100 56 69 37 20 65 4 35 72 164 34 23 201 200 70 58 242 145 144 140 164 36 39 73 201 74 90 242 146 152 204 164 38 55 217 72 65 132 64 9 126 52 64 1 74 80 130 10 84 64 0 38 48 193 9 80 144 130 86 166 96 0 176 140 165 44 103 73 203 90 218 242 150 184 204 165 46 119 201 203 94 250 242 151 192 12 166 48 97 233 202 20 160 224 4 169 20 128 41 75 16 4 0 59 ]!

tableHeaderColor
	^#thistle!

tableRowColor
	^#fffbf0!

tableSumaColor
	^#mediumgoldenrod!

textFontSizeGif
	"'imgs/fast/fast-font_size.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 54 0 14 0 128 1 0 153 153 153 238 238 238 33 249 4 1 0 0 1 0 44 0 0 0 0 54 0 14 0 0 2 75 140 143 169 203 237 15 163 76 0 204 139 143 189 251 245 252 69 97 230 85 155 169 161 129 57 170 167 186 86 200 215 213 134 189 46 33 173 245 247 236 203 9 133 163 27 110 24 131 81 130 39 95 209 249 3 42 120 169 99 109 39 139 178 170 71 146 247 11 14 139 199 228 114 163 0 0 59 13 10 ]!

textSizeLargeGif
	"'imgs/fast/fast-t_lg.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 16 0 15 0 196 28 0 249 249 246 250 250 248 254 254 253 252 252 250 252 252 251 246 246 242 248 248 245 247 247 244 243 243 238 241 241 235 245 245 240 255 255 254 247 247 243 242 242 237 251 251 250 244 244 239 244 244 240 249 249 247 200 200 185 253 253 253 245 245 241 240 240 233 242 242 236 250 250 247 254 254 254 253 253 252 251 251 249 245 245 236 177 176 176 232 232 222 196 196 181 255 255 255 33 249 4 1 0 0 28 0 44 0 0 0 0 16 0 15 0 0 5 96 224 182 117 100 105 146 226 248 173 108 187 122 170 43 191 221 60 123 245 202 237 252 206 226 50 159 11 232 18 178 22 196 150 17 35 200 36 89 62 102 134 160 121 234 56 147 204 64 19 0 60 23 152 221 246 2 56 20 136 82 130 35 16 49 152 21 15 92 154 11 48 48 10 10 68 35 1 147 108 187 118 20 16 8 22 9 21 48 34 30 138 139 140 138 34 33 0 59 13 10 ]!

textSizeMediumGif
	"'imgs/fast/fast-t_med.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 16 0 15 0 196 28 0 249 249 246 252 252 251 250 250 248 254 254 253 252 252 250 248 248 245 246 246 242 243 243 238 247 247 243 245 245 240 241 241 235 255 255 254 253 253 253 247 247 244 200 200 185 250 250 247 242 242 237 245 245 241 240 240 233 242 242 236 251 251 250 244 244 240 249 249 247 244 244 239 254 254 254 253 253 252 251 251 249 245 245 236 177 176 176 232 232 222 196 196 181 255 255 255 33 249 4 1 0 0 28 0 44 0 0 0 0 16 0 15 0 0 5 96 224 182 117 100 105 146 226 248 173 108 187 122 170 43 191 221 60 123 181 237 226 45 231 255 45 158 203 231 90 8 123 28 22 102 144 57 178 136 203 76 64 227 92 249 24 25 130 70 0 112 46 48 140 128 246 1 104 24 132 209 0 69 96 41 152 19 23 92 122 11 40 32 12 137 3 68 1 115 104 185 118 17 21 7 19 10 18 48 34 30 138 139 140 138 34 33 0 59 13 10 ]!

textSizeSmallGif
	"'imgs/fast/fast-t_med.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 16 0 15 0 196 28 0 249 249 246 252 252 251 250 250 248 254 254 253 252 252 250 248 248 245 246 246 242 243 243 238 247 247 243 245 245 240 241 241 235 255 255 254 253 253 253 247 247 244 200 200 185 250 250 247 242 242 237 245 245 241 240 240 233 242 242 236 251 251 250 244 244 240 249 249 247 244 244 239 254 254 254 253 253 252 251 251 249 245 245 236 177 176 176 232 232 222 196 196 181 255 255 255 33 249 4 1 0 0 28 0 44 0 0 0 0 16 0 15 0 0 5 96 224 182 117 100 105 146 226 248 173 108 187 122 170 43 191 221 60 123 181 237 226 45 231 255 45 158 203 231 90 8 123 28 22 102 144 57 178 136 203 76 64 227 92 249 24 25 130 70 0 112 46 48 140 128 246 1 104 24 132 209 0 69 96 41 152 19 23 92 122 11 40 32 12 137 3 68 1 115 104 185 118 17 21 7 19 10 18 48 34 30 138 139 140 138 34 33 0 59 13 10 ]!

twoDigits: aNumber
	
	aNumber < 10
		ifTrue: [^'0',aNumber printString]
		ifFalse: [^aNumber printString]!

txtSmallPng
	"'imgs/ikone-dok/corendal-txt.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 1 95 73 68 65 84 120 156 98 248 143 23 252 252 254 9 77 4 32 128 24 224 172 51 27 75 238 156 206 155 90 104 181 126 74 8 144 177 109 217 20 32 185 105 201 226 157 75 187 145 53 0 4 16 84 195 175 95 127 55 111 190 83 81 113 112 66 182 225 158 85 19 123 43 243 119 110 187 188 114 66 254 190 45 187 128 26 158 61 123 6 215 0 16 64 80 13 64 213 71 142 61 106 203 116 122 249 229 19 144 124 243 237 11 144 252 254 251 23 144 4 202 174 92 185 18 174 1 32 128 16 26 118 159 189 0 84 13 65 64 13 31 127 124 7 106 248 243 247 47 154 6 128 0 66 104 56 120 254 26 49 26 0 2 8 161 97 255 185 171 64 165 117 245 245 16 180 123 239 94 172 26 0 2 8 73 195 217 171 196 216 0 16 64 8 13 251 46 92 68 182 1 98 9 68 22 89 3 64 0 33 105 56 123 133 24 27 0 2 8 201 73 167 110 16 99 3 64 0 33 133 210 185 155 196 216 0 16 64 8 13 123 206 92 129 216 0 52 24 143 6 128 0 66 104 248 240 229 43 196 248 215 95 63 191 249 250 229 200 169 147 123 15 30 92 188 108 233 164 201 147 111 220 184 1 215 0 16 64 136 196 247 245 219 247 187 247 239 55 180 180 228 21 20 228 228 228 148 149 149 29 58 116 232 210 165 75 143 30 61 250 249 243 39 92 25 64 0 33 52 0 193 135 15 31 94 190 124 249 233 211 39 160 138 191 96 199 96 2 128 0 3 0 49 229 159 98 54 52 32 115 0 0 0 0 73 69 78 68 174 66 96 130 ]!

unknownSmallPng
	"'imgs/ikone-dok/corendal-unk.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 1 250 73 68 65 84 120 156 98 248 255 255 255 133 11 231 175 92 185 120 249 50 20 93 189 122 5 130 128 130 231 207 159 123 248 240 225 127 36 0 16 64 12 64 12 84 244 31 7 248 248 241 195 129 3 251 144 245 0 4 16 1 13 47 95 190 2 146 103 207 158 122 244 232 17 68 4 32 128 8 104 248 250 245 211 221 187 183 15 29 218 63 101 202 20 136 8 64 0 129 52 92 185 114 9 72 222 188 245 240 194 133 199 151 47 223 7 162 75 151 238 159 63 255 16 136 46 92 120 112 254 252 213 75 151 206 246 246 246 64 52 0 4 16 92 195 191 240 208 94 57 169 76 14 238 137 28 28 19 132 4 38 105 106 214 105 106 86 201 201 85 7 4 128 204 62 115 230 4 68 3 64 0 65 53 252 249 243 123 254 130 5 123 54 175 222 186 100 253 198 77 187 150 173 223 188 103 207 150 109 91 118 172 88 190 170 171 171 15 168 230 226 197 75 16 13 0 1 4 213 240 227 199 247 131 39 143 126 220 178 234 82 150 223 147 175 95 53 250 230 3 197 211 139 174 102 231 175 95 182 108 246 191 127 255 46 92 184 0 209 0 16 64 72 26 14 238 59 118 124 255 180 185 61 47 95 127 40 173 219 250 243 231 159 105 11 23 207 89 188 104 222 220 57 200 26 0 2 8 161 97 215 190 237 191 31 126 253 191 247 253 15 80 200 204 253 241 235 235 199 45 155 111 174 93 49 109 14 138 13 0 1 132 208 112 228 212 193 43 43 207 31 204 221 253 234 237 141 186 6 247 31 223 190 44 136 138 88 221 92 55 127 201 98 100 13 0 1 4 213 240 243 231 143 89 51 167 207 95 50 187 111 70 215 198 13 235 59 58 186 118 237 218 214 57 169 119 202 204 201 109 173 173 255 65 201 7 170 1 32 128 16 161 52 121 242 100 96 96 79 156 56 1 72 78 158 60 169 167 167 123 210 164 137 221 221 93 171 87 175 6 170 57 127 254 60 68 3 64 0 17 136 105 56 56 119 238 28 132 1 16 64 32 13 87 175 94 38 168 225 226 69 168 161 0 1 4 210 112 228 200 33 160 19 207 225 6 64 247 236 218 181 11 162 1 32 192 0 104 150 135 8 60 245 67 255 0 0 0 0 73 69 78 68 174 66 96 130 ]!

usernameText
	^'Username: '!

wordBigGif
	"'imgs/word_icon.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 34 0 32 0 135 0 0 0 0 0 0 0 255 128 128 128 192 192 192 192 220 192 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 3 0 0 4 0 44 0 0 0 0 34 0 32 0 0 8 255 0 9 8 28 72 176 160 193 131 8 13 10 88 200 176 161 67 134 9 15 10 40 64 177 162 197 139 5 4 0 136 88 112 34 198 143 20 23 110 52 8 32 64 201 147 38 83 162 4 41 96 128 70 131 42 99 162 60 201 178 128 203 145 3 75 130 180 168 179 226 128 159 46 41 222 36 104 114 103 197 162 62 129 122 180 249 82 224 76 153 49 45 254 12 9 160 170 213 145 81 83 22 144 57 213 230 197 1 62 71 206 44 64 179 108 0 169 93 187 218 196 10 128 236 89 173 38 39 154 76 11 214 103 88 167 111 159 150 4 219 83 232 84 160 119 9 20 213 139 116 110 93 160 136 3 235 132 123 210 99 95 163 107 5 14 158 188 151 162 97 196 152 21 231 221 220 150 226 99 163 3 216 66 222 10 0 179 105 205 132 159 142 22 202 22 170 94 211 153 89 39 92 186 26 99 232 217 73 97 195 14 44 177 54 200 219 8 151 234 214 205 91 161 239 143 192 123 143 62 45 59 248 113 219 56 141 63 151 26 189 227 116 234 179 135 107 71 92 157 224 213 239 224 195 91 5 229 72 158 124 64 0 59 ]!

wordSmallPng
	"'imgs/ikone-dok/corendal-word.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 120 73 68 65 84 120 156 98 248 15 3 155 14 221 216 120 240 250 134 3 215 214 237 187 178 118 239 165 213 187 46 174 218 121 126 197 182 179 203 182 157 94 186 229 212 191 127 80 101 0 1 196 48 121 245 51 32 234 92 250 178 97 222 179 154 233 55 210 187 174 70 212 93 12 42 63 229 148 119 68 43 105 251 231 239 255 222 126 249 59 103 245 1 115 239 212 127 96 77 0 1 4 210 240 31 7 224 244 222 244 229 251 191 247 95 254 78 93 178 115 215 209 43 16 61 0 1 196 0 52 123 213 190 143 205 115 110 37 52 158 189 118 231 21 144 188 243 232 75 104 238 146 238 37 119 65 26 126 252 125 255 245 239 228 69 219 129 170 33 8 32 128 24 128 46 1 170 0 106 136 175 61 12 100 184 100 237 4 146 190 89 203 203 187 230 0 53 76 88 119 13 136 94 126 252 187 116 207 157 37 187 239 2 53 0 4 16 67 249 196 171 64 219 129 36 80 233 250 61 247 21 125 102 1 205 182 138 154 113 242 210 35 54 167 217 159 127 252 3 105 248 240 231 225 155 63 11 119 221 53 243 74 1 8 32 6 160 47 129 26 210 235 54 3 53 196 150 174 102 53 107 50 138 222 166 97 151 11 20 4 106 248 244 13 164 225 217 187 63 247 95 253 158 187 227 30 80 3 64 0 49 132 86 159 3 202 1 29 13 52 117 251 137 47 64 13 64 180 118 215 5 160 32 135 77 7 208 199 64 13 79 222 254 185 251 242 247 204 109 15 128 26 0 2 136 193 179 228 12 72 78 191 219 34 113 221 135 79 191 128 170 29 210 182 64 66 9 200 134 248 225 225 171 223 183 158 253 158 186 249 17 80 3 64 0 49 88 101 238 192 21 172 140 70 21 47 222 255 121 244 230 207 157 23 191 175 61 249 213 191 241 49 80 3 64 0 49 0 99 7 24 26 16 4 116 52 4 1 29 3 52 30 168 1 98 195 245 167 191 47 61 252 213 181 238 9 80 3 64 0 49 192 205 155 185 98 223 139 15 127 95 126 248 11 36 159 191 255 243 244 237 159 135 175 127 3 205 190 254 244 215 229 71 191 206 221 251 217 186 230 25 80 3 64 0 33 52 76 91 182 251 209 155 223 64 7 64 76 69 70 231 238 253 56 117 251 71 227 242 231 64 13 0 1 132 208 0 140 127 160 207 110 61 255 125 243 217 239 27 79 127 93 123 242 251 242 163 223 23 30 252 60 115 247 199 201 219 63 143 223 250 81 179 228 37 80 3 64 0 33 52 0 227 255 210 163 95 243 118 220 7 6 223 212 45 143 38 110 124 212 179 254 73 199 218 167 45 171 159 53 44 127 94 189 244 69 197 226 215 64 13 0 1 132 208 0 228 16 131 0 2 12 0 71 114 23 164 38 70 157 109 0 0 0 0 73 69 78 68 174 66 96 130 ]!

xmlBigGif
	"'imgs/xml.gif' asFilename contentsAsMethod"
^#[71 73 70 56 57 97 32 0 32 0 179 10 0 153 102 153 128 128 128 17 17 17 198 198 198 204 204 204 102 102 102 102 51 102 0 0 0 204 153 204 255 255 255 255 255 255 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 33 249 4 1 0 0 10 0 44 0 0 0 0 32 0 32 0 0 4 255 80 73 5 140 189 56 235 12 166 50 72 40 142 100 73 26 30 24 30 34 139 184 237 90 162 147 138 20 236 81 200 163 11 139 52 137 237 166 107 193 14 190 89 138 244 67 174 112 188 81 240 211 131 62 115 175 40 112 25 59 102 177 217 19 247 181 179 98 193 191 208 84 85 12 65 89 184 157 15 233 68 172 221 164 50 254 230 46 248 119 118 99 38 131 131 107 27 135 136 23 30 7 9 141 142 143 144 145 144 7 139 146 150 151 141 148 19 140 152 157 143 154 18 156 158 158 160 10 162 163 152 165 167 168 150 140 2 175 176 177 177 172 9 7 2 163 3 183 168 182 9 3 190 191 192 190 1 186 146 116 198 183 192 2 190 202 191 195 150 4 7 4 210 208 5 200 203 201 205 196 144 208 211 58 10 214 204 216 3 206 146 220 212 18 200 225 193 202 228 145 220 222 232 189 185 193 243 227 218 143 208 240 241 191 234 225 195 198 0 245 237 227 119 45 219 159 131 127 60 12 164 7 108 152 194 135 10 217 5 152 72 177 98 128 92 16 51 42 72 32 171 35 172 4 26 3 33 70 0 0 59 ]!

xmlSmallPng
	"'imgs/ikone-dok/corendal-xml.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 0 208 73 68 65 84 120 156 98 104 35 2 252 71 2 0 1 196 128 198 199 4 7 14 28 64 86 3 16 64 56 53 124 252 248 17 66 2 53 0 25 112 101 0 1 132 208 0 87 129 70 50 32 1 32 23 32 128 160 26 128 114 203 78 125 128 170 104 104 0 34 227 180 255 232 226 96 13 0 1 4 213 0 20 101 96 152 9 81 13 36 141 129 104 38 80 69 3 88 221 76 136 30 136 6 128 0 2 105 128 171 6 137 2 205 6 170 62 3 212 0 84 208 0 51 123 38 88 13 72 3 64 0 161 219 0 116 9 208 108 176 106 236 54 0 4 16 54 63 48 52 64 16 86 63 0 4 16 225 80 130 147 16 13 0 1 132 176 193 56 109 38 46 132 108 3 64 0 145 108 3 64 0 145 108 3 64 0 145 108 3 64 0 33 108 32 72 66 52 0 4 16 3 73 0 168 1 32 192 0 122 128 24 248 27 252 237 14 0 0 0 0 73 69 78 68 174 66 96 130 ]!

zipSmallPng
	"'imgs/ikone-dok/corendal-zip.png' asFilename contentsAsMethod"
^#[137 80 78 71 13 10 26 10 0 0 0 13 73 72 68 82 0 0 0 16 0 0 0 16 8 2 0 0 0 144 145 104 54 0 0 0 4 103 65 77 65 0 0 88 199 252 71 224 2 0 0 0 32 99 72 82 77 0 0 122 37 0 0 128 131 0 0 249 255 0 0 128 230 0 0 117 46 0 0 234 95 0 0 58 151 0 0 23 111 105 228 196 43 0 0 2 37 73 68 65 84 120 156 98 248 143 1 90 14 127 110 60 240 169 122 207 199 210 237 31 242 54 190 75 91 243 54 113 197 107 184 44 64 0 49 188 184 216 126 126 33 31 4 1 217 64 185 47 255 255 31 127 243 119 207 211 223 107 111 255 156 125 254 107 199 225 207 101 219 63 120 182 95 132 104 0 8 32 6 160 186 143 146 140 16 4 100 171 103 30 71 67 86 13 23 98 86 127 139 158 121 157 197 123 3 80 3 64 0 1 53 8 220 218 162 117 115 187 230 205 253 90 55 247 235 220 220 163 127 115 187 225 237 157 198 183 118 153 222 219 103 189 165 134 31 168 168 105 227 253 210 141 79 32 26 0 2 136 225 234 106 165 127 127 103 254 255 127 228 255 255 157 255 255 175 255 255 119 201 255 223 179 254 255 154 240 255 71 219 231 39 185 155 106 249 128 138 38 108 187 15 244 24 68 3 64 0 49 92 93 37 255 235 219 228 159 223 158 254 120 119 234 215 203 181 191 30 247 255 190 87 242 231 102 196 191 203 22 247 182 50 66 52 76 219 121 191 251 212 79 136 6 128 0 98 184 2 212 240 117 226 239 207 231 126 189 222 252 251 249 244 63 143 106 127 223 77 249 123 211 253 207 21 67 172 26 0 2 136 40 13 83 182 35 52 0 4 16 208 73 138 191 190 78 248 253 97 239 175 23 11 255 60 105 253 115 47 247 239 173 192 191 87 45 191 157 213 129 107 152 177 243 126 231 201 239 16 13 0 1 196 112 105 153 200 247 247 77 55 214 105 92 89 46 125 117 153 216 213 101 2 87 151 114 95 89 204 113 105 1 59 92 195 132 205 247 138 54 62 131 104 0 8 32 134 157 173 154 155 170 149 87 231 242 174 202 229 93 83 34 139 25 15 133 115 46 23 172 127 23 187 244 53 68 3 64 0 49 160 165 11 72 76 103 108 255 159 184 249 127 209 238 255 21 251 64 8 168 218 186 234 8 68 1 64 0 161 107 128 232 209 201 218 173 145 186 77 57 126 3 16 41 70 175 133 152 13 1 0 1 132 69 3 154 102 228 148 7 4 0 1 132 93 67 240 172 71 37 75 30 228 46 124 16 53 229 134 95 255 13 231 174 235 150 173 215 133 252 87 2 165 0 2 8 151 134 39 39 110 124 219 114 254 219 140 67 95 203 183 124 9 91 246 197 98 230 103 177 128 229 64 41 128 0 3 0 79 174 47 198 171 105 151 124 0 0 0 0 73 69 78 68 174 66 96 130 ]! !
!WebStyle categoriesFor: #addBreaksTo:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #addHelpText!private!texts! !
!WebStyle categoriesFor: #addParagraphsTo:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #adminColor!private!private-obsolete-colors! !
!WebStyle categoriesFor: #adobeLeafGif!imgs-other!private! !
!WebStyle categoriesFor: #allCssPrintMethods!private!private-css! !
!WebStyle categoriesFor: #allCssScreenMethods!private!private-css! !
!WebStyle categoriesFor: #allJavascriptMethods!private!private-javascript! !
!WebStyle categoriesFor: #app!accessing!private! !
!WebStyle categoriesFor: #arrowBigBlueGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowBigRedGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowBigYellowGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowCircledGreyGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowCircledRedGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowDownBigRedGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowNextRedPng!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowOrangeDownGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowOrangeLeftGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowOrangeRightGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowOrangeUpGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowPreviousRedPng!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowSmallBlackGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowTriangleRedGif!imgs-bullets!private! !
!WebStyle categoriesFor: #arrowTriangleYellowGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bannerLeftGif!imgs-other!private! !
!WebStyle categoriesFor: #bucketTopGif!imgs-other!private! !
!WebStyle categoriesFor: #bulletBookTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletBubbleTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletCalendarTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletCheckTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletConnectTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletFindTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletFolderTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletGraphTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletGuidesTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletIssueTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletLetterTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletManTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletNoteTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletPencilTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletQuoteTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletRelatedTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletSquareDownTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletSquareLeftWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletSquareRightTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletStarTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletToolsTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #bulletTriangleRightTranspWhiteGif!imgs-bullets!private! !
!WebStyle categoriesFor: #buttonBackWhiteGif!imgs-buttons!private! !
!WebStyle categoriesFor: #buttonBeginWhiteGif!imgs-buttons!private! !
!WebStyle categoriesFor: #buttonEditGif!imgs-buttons!private! !
!WebStyle categoriesFor: #buttonEndWhiteGif!imgs-buttons!private! !
!WebStyle categoriesFor: #buttonNextWhiteGif!imgs-buttons!private! !
!WebStyle categoriesFor: #buttonUpWhiteGif!imgs-buttons!private! !
!WebStyle categoriesFor: #calendar1Gif!imgs-common symbols!private! !
!WebStyle categoriesFor: #calendar2Gif!imgs-common symbols!private! !
!WebStyle categoriesFor: #calendar3Gif!imgs-common symbols!private! !
!WebStyle categoriesFor: #calendar4Gif!imgs-common symbols!private! !
!WebStyle categoriesFor: #calendar5Gif!imgs-common symbols!private! !
!WebStyle categoriesFor: #calendarButtonGif!imgs-common symbols!private! !
!WebStyle categoriesFor: #calendarCSS!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarCSSResource!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarJavascript!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarJsResource!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarLangEnglish!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarLangJavascript!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarLangJsResource!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarLangSlovenian!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarSetupJavascript!private!scripts-calendar! !
!WebStyle categoriesFor: #calendarSetupJsResource!private!scripts-calendar! !
!WebStyle categoriesFor: #contactElement!frame printing!private! !
!WebStyle categoriesFor: #copyIconGif!imgs-other!private! !
!WebStyle categoriesFor: #copyrightElement!frame printing!private! !
!WebStyle categoriesFor: #cornerDashboardLeftGif!imgs-other!private! !
!WebStyle categoriesFor: #cornerDashboardRightGif!imgs-other!private! !
!WebStyle categoriesFor: #css1Body!private!styles-screen! !
!WebStyle categoriesFor: #css21Text!private!styles-screen! !
!WebStyle categoriesFor: #css22Links!private!styles-screen! !
!WebStyle categoriesFor: #css23Inputs!private!styles-screen! !
!WebStyle categoriesFor: #css24WebGrid!private!styles-screen! !
!WebStyle categoriesFor: #css25AutocompleteField!private!styles-screen! !
!WebStyle categoriesFor: #css26Popup!private!styles-screen! !
!WebStyle categoriesFor: #css3Header!private!styles-screen! !
!WebStyle categoriesFor: #css40NavigationBar!private!styles-screen! !
!WebStyle categoriesFor: #css41Login!private!styles-screen! !
!WebStyle categoriesFor: #css42ErrorReport!private!styles-screen! !
!WebStyle categoriesFor: #css43Buckets!private!styles-screen! !
!WebStyle categoriesFor: #css44ContentHierarchy!private!styles-screen! !
!WebStyle categoriesFor: #css451Document!private!styles-screen! !
!WebStyle categoriesFor: #css452DocumentActions!private!styles-screen! !
!WebStyle categoriesFor: #css453ClassificationLevel!private!styles-screen! !
!WebStyle categoriesFor: #css46Search!private!styles-screen! !
!WebStyle categoriesFor: #css47Comments!private!styles-screen! !
!WebStyle categoriesFor: #css51Wiki!private!styles-screen! !
!WebStyle categoriesFor: #css9Hide!private!styles-screen! !
!WebStyle categoriesFor: #cssPrintBody!private!styles-print! !
!WebStyle categoriesFor: #cssPrintDocFooter!private!styles-print! !
!WebStyle categoriesFor: #cssPrintDocHeader!private!styles-print! !
!WebStyle categoriesFor: #cssPrintDocTitle!private!styles-print! !
!WebStyle categoriesFor: #cssPrintHide!private!styles-print! !
!WebStyle categoriesFor: #cssPrintShow!private!styles-print! !
!WebStyle categoriesFor: #cssTabs1!private!styles-screen! !
!WebStyle categoriesFor: #cssTabs2!private!styles-screen! !
!WebStyle categoriesFor: #cssTabs3!private!styles-screen! !
!WebStyle categoriesFor: #cssTabs4!private!styles-screen! !
!WebStyle categoriesFor: #cssTabs5!private!styles-screen! !
!WebStyle categoriesFor: #cutIconGif!imgs-other!private! !
!WebStyle categoriesFor: #defaultPageTitle!frame printing!private! !
!WebStyle categoriesFor: #delimiterColor!private!private-obsolete-colors! !
!WebStyle categoriesFor: #docYellowPng!imgs-bullets!private! !
!WebStyle categoriesFor: #emailJpg!imgs-common symbols!private! !
!WebStyle categoriesFor: #emailSmall1Gif!imgs-common symbols!private! !
!WebStyle categoriesFor: #emailSmall2Gif!imgs-common symbols!private! !
!WebStyle categoriesFor: #emailSmall3Gif!imgs-common symbols!private! !
!WebStyle categoriesFor: #ensureJavascriptAndCssForCalendarInHeader!private!scripts-calendar! !
!WebStyle categoriesFor: #ensureJavascriptForScriptaculousInHeader!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #ensureJsResourceForCalendarSetup!private!scripts-calendar! !
!WebStyle categoriesFor: #ensureJsResourceForScriptaculous!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #eranovaHeaderGif!imgs-common symbols!private! !
!WebStyle categoriesFor: #eranovaLogoGif!imgs-common symbols!private! !
!WebStyle categoriesFor: #excelBigGif!imgs-filetype icons!private! !
!WebStyle categoriesFor: #excelSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #favicon!imgs-other!private! !
!WebStyle categoriesFor: #folderYellowClosedPng!imgs-bullets!private! !
!WebStyle categoriesFor: #folderYellowOpenedPng!imgs-bullets!private! !
!WebStyle categoriesFor: #fontSizeText!private!texts! !
!WebStyle categoriesFor: #guestUserText!private!texts! !
!WebStyle categoriesFor: #headerBanner!frame printing!private! !
!WebStyle categoriesFor: #headerColor!private!private-obsolete-colors! !
!WebStyle categoriesFor: #headerDashboard!frame printing!private! !
!WebStyle categoriesFor: #headerElement!frame printing!private! !
!WebStyle categoriesFor: #headerLogin!frame printing!private! !
!WebStyle categoriesFor: #helpText!public! !
!WebStyle categoriesFor: #htmlHeaderElements!frame printing!private! !
!WebStyle categoriesFor: #ieBigGif!imgs-common symbols!private! !
!WebStyle categoriesFor: #imageSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #infoBigGif!imgs-common symbols!private! !
!WebStyle categoriesFor: #initResources!private! !
!WebStyle categoriesFor: #isBrowserMSIE!private!testing! !
!WebStyle categoriesFor: #isBrowserNetscape!private!testing! !
!WebStyle categoriesFor: #javaBigGif!imgs-common symbols!private! !
!WebStyle categoriesFor: #javascript!private!private-javascript! !
!WebStyle categoriesFor: #javascriptResource!private!private-javascript! !
!WebStyle categoriesFor: #jsCommon!private!scripts! !
!WebStyle categoriesFor: #jsPrototypeFramework!private!scripts! !
!WebStyle categoriesFor: #jsPrototypeFramework131!private!scripts! !
!WebStyle categoriesFor: #keyGif!imgs-bullets!private! !
!WebStyle categoriesFor: #leftCornerGif!imgs-other!private! !
!WebStyle categoriesFor: #leftStripeGif!imgs-other!private! !
!WebStyle categoriesFor: #loginBelowMessage!private!texts! !
!WebStyle categoriesFor: #loginButton!private!texts! !
!WebStyle categoriesFor: #loginErrorText!private!texts! !
!WebStyle categoriesFor: #loginText!private!texts! !
!WebStyle categoriesFor: #loginTitle!private!texts! !
!WebStyle categoriesFor: #loginWelcomeMessage!private!texts! !
!WebStyle categoriesFor: #logoutText!private!texts! !
!WebStyle categoriesFor: #multimediaSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #navBarAdminElement!frame navigation!private! !
!WebStyle categoriesFor: #navBarContactElement!frame navigation!private! !
!WebStyle categoriesFor: #navBarDemosIn:!frame navigation!private! !
!WebStyle categoriesFor: #navBarMainLinksElement!frame navigation!private! !
!WebStyle categoriesFor: #navHeader:bullet:!frame navigation!private! !
!WebStyle categoriesFor: #navHeader:bullet:linkTo:!frame navigation!private! !
!WebStyle categoriesFor: #navHeader:bullet:linkTo:view:!frame navigation!private! !
!WebStyle categoriesFor: #navigationBarElement!frame navigation!private! !
!WebStyle categoriesFor: #navigatorColor!private!private-obsolete-colors! !
!WebStyle categoriesFor: #navLeftGif!imgs-other!private! !
!WebStyle categoriesFor: #navLinkTo:header:bullet:!frame navigation!private! !
!WebStyle categoriesFor: #observee!accessing!private! !
!WebStyle categoriesFor: #outlookBigGif!imgs-common symbols!private! !
!WebStyle categoriesFor: #pageContentWideWidth!private!styles-screen! !
!WebStyle categoriesFor: #pageContentWidth!private!styles-screen! !
!WebStyle categoriesFor: #pageFrameWideNoNavigationWith:title:!frame printing!private! !
!WebStyle categoriesFor: #pageFrameWith:title:!frame printing!private! !
!WebStyle categoriesFor: #pageFrameWith:wide:title:!frame printing!private! !
!WebStyle categoriesFor: #pageFrameWith:wide:title:printHeader:!frame printing!private! !
!WebStyle categoriesFor: #pageWidth!private!styles-screen! !
!WebStyle categoriesFor: #passwordText!private!texts! !
!WebStyle categoriesFor: #pasteIconGif!imgs-other!private! !
!WebStyle categoriesFor: #pdfBigGif!imgs-filetype icons!private! !
!WebStyle categoriesFor: #pdfMediumGif!imgs-filetype icons!private! !
!WebStyle categoriesFor: #pdfSmallGif!imgs-filetype icons!private! !
!WebStyle categoriesFor: #pdfSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #powerpointSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #printCssResource!private!private-css! !
!WebStyle categoriesFor: #printerJpg!imgs-common symbols!private! !
!WebStyle categoriesFor: #printSeconds:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #printStamp:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #printStyleSheet!private!private-css! !
!WebStyle categoriesFor: #redPixelGif!imgs-other!private! !
!WebStyle categoriesFor: #reportHeaderColor!private!private-obsolete-colors! !
!WebStyle categoriesFor: #resources!private! !
!WebStyle categoriesFor: #richEditorCssResource!private!scripts-calendar! !
!WebStyle categoriesFor: #richEditorStyleSheet!private!scripts-calendar! !
!WebStyle categoriesFor: #screenCssResource!private!private-css! !
!WebStyle categoriesFor: #screenStyleSheet!private!private-css! !
!WebStyle categoriesFor: #scriptaculousBuilderJs!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousBuilderJsResource!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousControlsJs!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousControlsJsResource!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousDragDropJs!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousDragDropJsResource!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousEffectsJs!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousEffectsJsResource!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousJs!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousJsResource!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousSliderJs!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #scriptaculousSliderJsResource!private!scripts-scriptaculous! !
!WebStyle categoriesFor: #searchButton!frame printing!private! !
!WebStyle categoriesFor: #session!accessing!private! !
!WebStyle categoriesFor: #site!accessing!private! !
!WebStyle categoriesFor: #site:!private! !
!WebStyle categoriesFor: #smallNumber:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #smallNumber:attributes:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #smallText:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #smallText:attributes:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #tab1BgGif!imgs-other!private! !
!WebStyle categoriesFor: #tab1LeftGif!imgs-other!private! !
!WebStyle categoriesFor: #tab1LeftOnGif!imgs-other!private! !
!WebStyle categoriesFor: #tab1RightGif!imgs-other!private! !
!WebStyle categoriesFor: #tab1RightOnGif!imgs-other!private! !
!WebStyle categoriesFor: #tab2BottomGif!imgs-other!private! !
!WebStyle categoriesFor: #tab3BackGif!imgs-other!private! !
!WebStyle categoriesFor: #tab5BgGif!imgs-other!private! !
!WebStyle categoriesFor: #tab5LeftGif!imgs-other!private! !
!WebStyle categoriesFor: #tab5LeftOnGif!imgs-other!private! !
!WebStyle categoriesFor: #tab5RightGif!imgs-other!private! !
!WebStyle categoriesFor: #tab5RightOnGif!imgs-other!private! !
!WebStyle categoriesFor: #tableHeaderColor!private!private-obsolete-colors! !
!WebStyle categoriesFor: #tableRowColor!private!private-obsolete-colors! !
!WebStyle categoriesFor: #tableSumaColor!private!private-obsolete-colors! !
!WebStyle categoriesFor: #textFontSizeGif!imgs-other!private! !
!WebStyle categoriesFor: #textSizeLargeGif!imgs-other!private! !
!WebStyle categoriesFor: #textSizeMediumGif!imgs-other!private! !
!WebStyle categoriesFor: #textSizeSmallGif!imgs-other!private! !
!WebStyle categoriesFor: #twoDigits:!private!private-obsolete-printing-elements! !
!WebStyle categoriesFor: #txtSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #unknownSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #usernameText!private!texts! !
!WebStyle categoriesFor: #wordBigGif!imgs-filetype icons!private! !
!WebStyle categoriesFor: #wordSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #xmlBigGif!imgs-filetype icons!private! !
!WebStyle categoriesFor: #xmlSmallPng!imgs-filetype icons!private! !
!WebStyle categoriesFor: #zipSmallPng!imgs-filetype icons!private! !

!WebStyle class methodsFor!

default
	^AIDASite default style!

newOnSite: anAIDASite

	^super new site: anAIDASite! !
!WebStyle class categoriesFor: #default!accessing!private! !
!WebStyle class categoriesFor: #newOnSite:!instance creation!private! !

WebTransactionMonitor guid: (GUID fromString: '{C9D38970-725B-4CE2-99B6-EFEE619C068E}')!
WebTransactionMonitor comment: ''!
!WebTransactionMonitor categoriesForClass!Unclassified! !
!WebTransactionMonitor class methodsFor!

addServer: aWebServer
!

commit!

critical: aBlock
	"For protecting critical sections in parallel execution of web requests. Use it always
	when you do things, which cannot be disturbed by another request. Example:
		WebTransactionMonitor critical: [<a block with critical section>]. "

	^aBlock value "TEMPORARY!!"
	"^self lock critical: aBlock."! !
!WebTransactionMonitor class categoriesFor: #addServer:!local servers!private! !
!WebTransactionMonitor class categoriesFor: #commit!critical sections!private! !
!WebTransactionMonitor class categoriesFor: #critical:!critical sections!private! !

WebUser guid: (GUID fromString: '{780904EA-45F7-4892-B95B-70DAC50CA95A}')!
WebUser comment: ''!
!WebUser categoriesForClass!Unclassified! !
!WebUser methodsFor!

address
	address isNil ifTrue: [^'']. 
	^address!

address: aString
	address := aString.!

addToActivatingGroup
	self parent addActivatingUser: self!

addToGroup: aWebUserGroup
 	self groups add: aWebUserGroup!

addToRegisteredGroup
	self parent addRegisteredUser: self!

allGroups 
	^groups copy!

asPerson
	"parallel Person object (from Party framework)"
	^self otherValuesAt: #Person!

asWebUser
	^self!

autoLogout
	"logout after 15min of inactivity. default is NO!! "
	^self otherValuesAt: #AutoLogout ifAbsent: [false]!

autoLogout: aBoolean
	"logout after 15min of inactivity"
	^self otherValuesAt: #AutoLogout put: aBoolean!

becomeAdmin
	self parent adminGroup addUser: self!

city
	city isNil ifTrue: [^'']. 
	^city!

city: aString
	city := aString.!

company
	company isNil ifTrue: [^'']. 
	^company!

company: aString 
	company := aString.!

country
	country isNil ifTrue: [^'']. 
	^country!

country: aString
	country := aString.!

email 
	email isNil ifTrue: [^''].
	^email!

email: aString
	email := aString.!

fax
	fax isNil ifTrue: [^''].
	^fax!

fax: aString 
	fax := aString.!

groups 
	groups isNil ifTrue: [self initGroups].
	^groups!

hasEMail 

	"at least email must be entered to accept a new user"
	
	^self email ~= ''!

id
	"unique id of that user"
	^id!

id: aNumber
	id := aNumber.!

initGroups
	groups := Set new.!

initialize
	self initId!

initId
	self id: (Random new next * 1000000000) asInteger.!

initOtherValues
	otherValues := Dictionary new.!

isActivating
	"user needs to confirm registration"
	^self groups contains: [:each | each isActivatingGroup]!

isAdmin
	"all from Administrators group are admins, also default Admin user"
	^self groups contains: [:each | each isAdminGroup]!

isGuest
	"all non registered visitors have the same user: a Guest"
	^self name = 'Guest' and: [(self username = 'guest') & (self password = 'guest')]!

isRegistered
	^self groups contains: [:each | each isRegisteredGroup]!

isWebUser
	^true!

isWebUserGroup
	^false!

lastAppUrl
	"an url which last WebApplication was called. "
	^self otherValuesAt: #LastAppUrl ifAbsent: [nil].!

lastAppUrl: aString
	"an url which last WebApplication was called. It is set AFTER the app view is generated!!"
	^self otherValuesAt: #LastAppUrl put: aString!

logoutFromUrl
	"From which page user logout. To be redirected back after login"
	^self otherValuesAt: #LogoutFromUrl ifAbsent: [nil].!

logoutFromUrl: aString
	"From which page user logout. To be redirected back after login"
	^self otherValuesAt: #LogoutFromUrl put: aString!

menuName
	"in dropdown menus"
	^self surnameName!

migrateToUnicode
	"from iso8859-2"
	"WebUser allInstances do: [:each | each migrateToUnicode]"
	username notNil ifTrue: [username := username ensureUnicodeSloveneChars].
	password notNil ifTrue: [password := password ensureUnicodeSloveneChars].
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].
	surname notNil ifTrue: [surname := surname ensureUnicodeSloveneChars].
	company notNil ifTrue: [company := company ensureUnicodeSloveneChars].
	city notNil ifTrue: [city := city ensureUnicodeSloveneChars].
	country notNil ifTrue: [country := country ensureUnicodeSloveneChars].!

name
	self asPerson notNil ifTrue: [^self asPerson name].
	name isNil ifTrue: [^''].
	^name!

name: aString 
	self asPerson notNil ifTrue: [^self asPerson name: aString].
	name := aString.!

nameSurname 
	^self name, ' ', self surname!

otherValues
	^otherValues!

otherValuesAt: aString
	^self otherValuesAt: aString ifAbsent: [nil]!

otherValuesAt: aString ifAbsent: aBlock
	self otherValues isNil ifTrue: [^aBlock value].
	^self otherValues at: aString ifAbsent: [aBlock value]!

otherValuesAt: aString put: anObject
	self otherValues isNil ifTrue: [self initOtherValues].
	^self otherValues at: aString put: anObject!

parent
	^parent!

parent: aWebSecurityManager
	parent := aWebSecurityManager!

password		 
	password isNil ifTrue: [^''].
	^password!

password: aString	
	password := aString asLowercase.!

person: aPerson
	"connect to parrallel Person from Party framework"
	self otherValuesAt: #Person put: aPerson.
	aPerson asWebUser ~= self ifTrue: [aPerson webUser: self].!

phone 
	phone isNil ifTrue: [^''].
	^phone!

phone: aString 
	phone := aString.!

printString 
	^'aWebUser named ', self surname, ', ', self name, ' (', self username, ') '!

removeFromGroup: aWebUserGroup 
	self groups remove: aWebUserGroup ifAbsent: []!

someId
	"just return some text, possibly surnameName"
	self surnameName trimBlanks notEmpty ifTrue: [^self surnameName].
	self email notEmpty ifTrue: [^self email].
	^'----'!

surname
	self asPerson notNil ifTrue: [^self asPerson surname].
	surname isNil ifTrue: [^''].
	^surname!

surname: aString 
	self asPerson notNil ifTrue: [^self asPerson surname: aString].
	surname := aString.!

surnameName
	^self surname, ' ', self name!

username
 
	username isNil ifTrue: [^''].
	^username.!

username: aString 
	username := aString asLowercase.!

uuid
	"some unique identifier. Hash for now, probably unique enough!! "
	^self hash printString!

zip
	zip isNil ifTrue: [^'']. 
	^zip!

zip: aString
	zip := aString.! !
!WebUser categoriesFor: #address!accessing!private! !
!WebUser categoriesFor: #address:!accessing!private! !
!WebUser categoriesFor: #addToActivatingGroup!groups!private! !
!WebUser categoriesFor: #addToGroup:!groups!private! !
!WebUser categoriesFor: #addToRegisteredGroup!groups!private! !
!WebUser categoriesFor: #allGroups!accessing!private! !
!WebUser categoriesFor: #asPerson!accessing!private! !
!WebUser categoriesFor: #asWebUser!accessing!private! !
!WebUser categoriesFor: #autoLogout!accessing-other!private! !
!WebUser categoriesFor: #autoLogout:!accessing-other!private! !
!WebUser categoriesFor: #becomeAdmin!groups!private! !
!WebUser categoriesFor: #city!accessing!private! !
!WebUser categoriesFor: #city:!accessing!private! !
!WebUser categoriesFor: #company!accessing!private! !
!WebUser categoriesFor: #company:!accessing!private! !
!WebUser categoriesFor: #country!accessing!private! !
!WebUser categoriesFor: #country:!accessing!private! !
!WebUser categoriesFor: #email!accessing!private! !
!WebUser categoriesFor: #email:!accessing!private! !
!WebUser categoriesFor: #fax!accessing!private! !
!WebUser categoriesFor: #fax:!accessing!private! !
!WebUser categoriesFor: #groups!private! !
!WebUser categoriesFor: #hasEMail!private!testing! !
!WebUser categoriesFor: #id!accessing!private! !
!WebUser categoriesFor: #id:!accessing!private! !
!WebUser categoriesFor: #initGroups!private! !
!WebUser categoriesFor: #initialize!initialize-release!private! !
!WebUser categoriesFor: #initId!initialize-release!private! !
!WebUser categoriesFor: #initOtherValues!initialize-release!private! !
!WebUser categoriesFor: #isActivating!private!testing! !
!WebUser categoriesFor: #isAdmin!private!testing! !
!WebUser categoriesFor: #isGuest!private!testing! !
!WebUser categoriesFor: #isRegistered!private!testing! !
!WebUser categoriesFor: #isWebUser!private!testing! !
!WebUser categoriesFor: #isWebUserGroup!private!testing! !
!WebUser categoriesFor: #lastAppUrl!accessing-other!private! !
!WebUser categoriesFor: #lastAppUrl:!accessing-other!private! !
!WebUser categoriesFor: #logoutFromUrl!accessing-other!private! !
!WebUser categoriesFor: #logoutFromUrl:!accessing-other!private! !
!WebUser categoriesFor: #menuName!accessing!private! !
!WebUser categoriesFor: #migrateToUnicode!private! !
!WebUser categoriesFor: #name!accessing!private! !
!WebUser categoriesFor: #name:!accessing!private! !
!WebUser categoriesFor: #nameSurname!accessing!private! !
!WebUser categoriesFor: #otherValues!private! !
!WebUser categoriesFor: #otherValuesAt:!private! !
!WebUser categoriesFor: #otherValuesAt:ifAbsent:!private! !
!WebUser categoriesFor: #otherValuesAt:put:!private! !
!WebUser categoriesFor: #parent!private! !
!WebUser categoriesFor: #parent:!private! !
!WebUser categoriesFor: #password!accessing!private! !
!WebUser categoriesFor: #password:!accessing!private! !
!WebUser categoriesFor: #person:!private! !
!WebUser categoriesFor: #phone!accessing!private! !
!WebUser categoriesFor: #phone:!accessing!private! !
!WebUser categoriesFor: #printString!printing!private! !
!WebUser categoriesFor: #removeFromGroup:!groups!private! !
!WebUser categoriesFor: #someId!accessing!private! !
!WebUser categoriesFor: #surname!accessing!private! !
!WebUser categoriesFor: #surname:!accessing!private! !
!WebUser categoriesFor: #surnameName!accessing!private! !
!WebUser categoriesFor: #username!accessing!private! !
!WebUser categoriesFor: #username:!accessing!private! !
!WebUser categoriesFor: #uuid!accessing!private! !
!WebUser categoriesFor: #zip!accessing!private! !
!WebUser categoriesFor: #zip:!accessing!private! !

!WebUser class methodsFor!

adminEMail
	^'admin'!

adminName
	^'Admin'!

adminPassword
	^'password'!

adminSurname
	^''!

adminUsername
	^'admin'!

guestEMail
	^'guest'!

guestName
	^'Guest'!

guestPassword
	^'guest'!

guestSurname
	^''!

guestUsername
	^'guest'!

new
	^super new initialize!

newAdmin
	^self new
		name: self adminName;
		surname: self adminSurname;
		email: self adminEMail;
		username: self adminUsername;
		password: self adminPassword!

newGuest
	^self new
		name: self guestName;
		surname: self guestSurname;
		email: self guestEMail;
		username: self guestUsername;
		password: self guestPassword! !
!WebUser class categoriesFor: #adminEMail!defaults!private! !
!WebUser class categoriesFor: #adminName!defaults!private! !
!WebUser class categoriesFor: #adminPassword!defaults!private! !
!WebUser class categoriesFor: #adminSurname!defaults!private! !
!WebUser class categoriesFor: #adminUsername!defaults!private! !
!WebUser class categoriesFor: #guestEMail!defaults!private! !
!WebUser class categoriesFor: #guestName!defaults!private! !
!WebUser class categoriesFor: #guestPassword!defaults!private! !
!WebUser class categoriesFor: #guestSurname!defaults!private! !
!WebUser class categoriesFor: #guestUsername!defaults!private! !
!WebUser class categoriesFor: #new!instance creation!private! !
!WebUser class categoriesFor: #newAdmin!instance creation!private! !
!WebUser class categoriesFor: #newGuest!instance creation!private! !

WebUserGroup guid: (GUID fromString: '{F74C8706-278C-4DEB-A6E6-44B2A6DEAB06}')!
WebUserGroup comment: ''!
!WebUserGroup categoriesForClass!Unclassified! !
!WebUserGroup methodsFor!

addUser: aWebUser
 	self users add: aWebUser.
	aWebUser addToGroup: self.!

allUsers
	^self users copy!

includes: aWebUser
	^self users includes: aWebUser!

initUsers 
	users  := Set new.!

isActivatingGroup
	"group of users waiting to confirm registration"
	^self name = self class activatingGroupName!

isAdminGroup
	^self name = self class adminGroupName!

isAllUsersGroup
	^self name = self class allUsersGroupName!

isGuestGroup
	^self name = self class guestGroupName!

isRegisteredGroup
	^self name = self class registeredGroupName!

isWebUser
	^false!

isWebUserGroup
	^true!

menuName
	"in dropdown menus"
	^name!

migrateToUnicode
	"from iso8859-2"
	"WebUserGroup allInstances do: [:each | each migrateToUnicode]"
	name notNil ifTrue: [name := name ensureUnicodeSloveneChars].!

name
	name isNil ifTrue: [self name: '']. 
	^name!

name: aString
	name := aString.!

printString
	^'aWebUserGroup: ', self name!

removeUser: aWebUser
 	self users remove: aWebUser ifAbsent: [].
	aWebUser removeFromGroup: self.!

users
	users isNil ifTrue: [self initUsers]. 
	^users!

uuid
	"some unique identifier. Hash for now, probably unique enough!! "
	^self hash printString! !
!WebUserGroup categoriesFor: #addUser:!adding - removing!private! !
!WebUserGroup categoriesFor: #allUsers!accessing!private! !
!WebUserGroup categoriesFor: #includes:!private!testing! !
!WebUserGroup categoriesFor: #initUsers!private! !
!WebUserGroup categoriesFor: #isActivatingGroup!private!testing! !
!WebUserGroup categoriesFor: #isAdminGroup!private!testing! !
!WebUserGroup categoriesFor: #isAllUsersGroup!private!testing! !
!WebUserGroup categoriesFor: #isGuestGroup!private!testing! !
!WebUserGroup categoriesFor: #isRegisteredGroup!private!testing! !
!WebUserGroup categoriesFor: #isWebUser!private!testing! !
!WebUserGroup categoriesFor: #isWebUserGroup!private!testing! !
!WebUserGroup categoriesFor: #menuName!accessing!private! !
!WebUserGroup categoriesFor: #migrateToUnicode!private! !
!WebUserGroup categoriesFor: #name!accessing!private! !
!WebUserGroup categoriesFor: #name:!accessing!private! !
!WebUserGroup categoriesFor: #printString!printing!private! !
!WebUserGroup categoriesFor: #removeUser:!adding - removing!private! !
!WebUserGroup categoriesFor: #users!private! !
!WebUserGroup categoriesFor: #uuid!accessing!private! !

!WebUserGroup class methodsFor!

activatingGroupName
	"group of users waiting to confirm registration"
	^'Users waiting activation'!

adminGroupName
	"return a name of group for administrators" 
	^'Administrators'!

allUsersGroupName
	"return a name of group, where all users are there by default" 
	^'AllUsers'!

guestGroupName
	"return a name of group for guests" 
	^self allUsersGroupName!

newActivating
	^super new name: self activatingGroupName!

newAdmin
	^super new name: self adminGroupName!

newAllUsers
	^super new name: self allUsersGroupName!

newRegistered
	^super new name: self registeredGroupName!

registeredGroupName
	"return a name of group of registered users" 
	^'Registered Users'! !
!WebUserGroup class categoriesFor: #activatingGroupName!defaults!private! !
!WebUserGroup class categoriesFor: #adminGroupName!defaults!private! !
!WebUserGroup class categoriesFor: #allUsersGroupName!defaults!private! !
!WebUserGroup class categoriesFor: #guestGroupName!defaults!private! !
!WebUserGroup class categoriesFor: #newActivating!instance creation!private! !
!WebUserGroup class categoriesFor: #newAdmin!instance creation!private! !
!WebUserGroup class categoriesFor: #newAllUsers!instance creation!private! !
!WebUserGroup class categoriesFor: #newRegistered!instance creation!private! !
!WebUserGroup class categoriesFor: #registeredGroupName!defaults!private! !

BmpImageStream guid: (GUID fromString: '{52EC3B41-A50A-44A7-8530-3205042D60B3}')!
BmpImageStream comment: ''!
!BmpImageStream categoriesForClass!Unclassified! !
!BmpImageStream methodsFor!

colorValueFrom: rgbInteger 
	| scalingValue |
	scalingValue := ColorValue scalingValue.
	^ColorValue
		scaledRed: (self
				convertValue: ((rgbInteger bitShift: -16)
						bitAnd: 255)
				from: 255
				to: scalingValue)
		scaledGreen: (self
				convertValue: ((rgbInteger bitShift: -8)
						bitAnd: 255)
				from: 255
				to: scalingValue)
		scaledBlue: (self
				convertValue: (rgbInteger bitAnd: 255)
				from: 255
				to: scalingValue)!

nextImage
	self readBitmapFileHeader.
	self readBitmapInfoHeader.
	self readImagePalette.
	self readImageData.
	^imageObject!

nextLSBLong
	^self next + (self next bitShift: 8) + (self next bitShift: 16) + (self next bitShift: 24)!

nextLSBLongPut: a32BitW 
	self nextPut: (a32BitW bitAnd: 255).
	self nextPut: ((a32BitW bitShift: -8)
			bitAnd: 255).
	self nextPut: ((a32BitW bitShift: -16)
			bitAnd: 255).
	self nextPut: ((a32BitW bitShift: -24)
			bitAnd: 255)!

nextLSBWord
	^self next + (self next bitShift: 8)!

nextLSBWordPut: a16BitW 
	self nextPut: (a16BitW bitAnd: 255).
	self nextPut: ((a16BitW bitShift: -8)
			bitAnd: 255)!

nextPutImage: anImage 
	(anImage isKindOf: Image)
		ifFalse: [^self errorCanNotWrite].
	(anImage bitsPerPixel = 8 or: [anImage bitsPerPixel = 24])
		ifTrue: [imageObject := anImage]
		ifFalse: [anImage bitsPerPixel > 8
				ifTrue: [imageObject := anImage convertToPalette: (FixedPalette
									redShift: 16
									redMask: 255
									greenShift: 8
									greenMask: 255
									blueShift: 0
									blueMask: 255)]
				ifFalse: [Cursor wait showWhile: [imageObject := anImage convertToPalette: self class colorPalette256 renderedBy: ErrorDiffusion new]]].
	self writeBitmapFileHeader.
	self writeBitmapInfoHeader.
	self writeImagePalette.
	self writeImageData.
	bfSize := self position.
	^anImage!

readBitmapFileHeader
	| position |
	position := self position.
	(self hasMagicNumber: 'BM' asByteArray)
		ifFalse: [^self errorCanNotRead].
	self position: position.
	bfType := self nextWord.
	bfSize := self nextLSBLong.
	bfReserved1 := self nextLSBWord.
	bfReserved2 := self nextLSBWord.
	bfOffBits := self nextLSBLong!

readBitmapInfoHeader
	biSize := self nextLSBLong.
	biWidth := self nextLSBLong.
	biHeight := self nextLSBLong.
	biPlanes := self nextLSBWord.
	biBitCount := self nextLSBWord.
	biCompression := self nextLSBLong.
	biSizeImage := self nextLSBLong.
	biXPelsPerMeter := self nextLSBLong.
	biYPelsPerMeter := self nextLSBLong.
	biClrUsed := self nextLSBLong.
	biClrImportant := self nextLSBLong!

readDepth1Data
	| image total progress count index |
	self position: bfOffBits.
	image := Image
				extent: biWidth @ biHeight
				depth: biBitCount
				palette: imagePalette.
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total.
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 128.
			0 to: biWidth - 1
				do: 
					[:x | 
					count = 128 ifTrue: [index := self next].
					image
						atX: x
						y: y
						put: (index bitAnd: count).
					count := count / 2.
					count < 1 ifTrue: [count := 128].
					progress := progress + 1.
					self progress: progress / total]].
	^image!

readDepth1Palette
	^MappedPalette blackWhite!

readDepth24Data
	| image total progress count rgb color index |
	self position: bfOffBits.
	image := Image
				extent: biWidth @ biHeight
				depth: biBitCount
				palette: imagePalette.
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total.
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 0.
			0 to: biWidth - 1
				do: 
					[:x | 
					rgb := self next + (self next bitShift: 8) + (self next bitShift: 16).
					color := self colorValueFrom: rgb.
					index := image palette indexOfPaintNearest: color.
					image
						atX: x
						y: y
						put: index.
					count := count + 3.
					progress := progress + 1.
					self progress: progress / total].
			[count \\ 4 = 0]
				whileFalse: 
					[self next.
					count := count + 1]].
	^image!

readDepth24Palette
	^FixedPalette
		redShift: 16
		redMask: 255
		greenShift: 8
		greenMask: 255
		blueShift: 0
		blueMask: 255!

readDepth8Data
	| image total progress count index |
	self position: bfOffBits.
	image := Image
				extent: biWidth @ biHeight
				depth: biBitCount
				palette: imagePalette.
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total.
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 0.
			0 to: biWidth - 1
				do: 
					[:x | 
					index := self next.
					image
						atX: x
						y: y
						put: index.
					count := count + 1.
					progress := progress + 1.
					self progress: progress / total].
			[count \\ 4 = 0]
				whileFalse: 
					[self next.
					count := count + 1]].
	^image!

readDepth8Palette
	| size colors rgb color |
	size := 1 bitShift: biBitCount.
	biClrUsed = 0 ifFalse: [size := biClrUsed].
	colors := Array new: size.
	1 to: size
		do: 
			[:index | 
			rgb := self next + (self next bitShift: 8) + (self next bitShift: 16).
			self next.
			color := self colorValueFrom: rgb.
			colors at: index put: color].
	^MappedPalette withColors: colors!

readImageData
	biCompression = 0 ifFalse: [^self errorCanNotRead].
	imageObject := nil.
	biBitCount = 24 ifTrue: [imageObject := self readDepth24Data].
	biBitCount = 8 ifTrue: [imageObject := self readDepth8Data].
	biBitCount = 1 ifTrue: [imageObject := self readDepth1Data].
	imageObject isNil ifTrue: [^self errorCanNotRead].
	^imageObject!

readImagePalette
	imagePalette := nil.
	biBitCount = 24 ifTrue: [imagePalette := self readDepth24Palette].
	biBitCount = 8 ifTrue: [imagePalette := self readDepth8Palette].
	biBitCount = 1 ifTrue: [imagePalette := self readDepth1Palette].
	imagePalette isNil ifTrue: [^self errorCanNotRead]!

rgbIntegerArrayFor: aPalette 
	| colors |
	colors := Array new: aPalette maxIndex + 1.
	1 to: colors size do: [:i | colors at: i put: (self rgbIntegerFrom: (aPalette at: i - 1 ifAbsent: [ColorValue white]))].
	^colors!

rgbIntegerFrom: aColorValue 
	| scalingValue |
	scalingValue := ColorValue scalingValue.
	^((self
		convertValue: aColorValue scaledRed
		from: scalingValue
		to: 255)
		bitShift: 16)
		+ ((self
				convertValue: aColorValue scaledGreen
				from: scalingValue
				to: 255)
				bitShift: 8) + (self
			convertValue: aColorValue scaledBlue
			from: scalingValue
			to: 255)!

writeBitmapFileHeader
	bfType := ($B asInteger bitShift: 8)
				+ $M asInteger.
	bfSize := 0.
	bfReserved1 := 0.
	bfReserved2 := 0.
	bfOffBits := nil.
	imageObject bitsPerPixel = 8 ifTrue: [bfOffBits := 54 + (imageObject palette size * 4)].
	imageObject bitsPerPixel = 24 ifTrue: [bfOffBits := 54].
	bfOffBits isNil ifTrue: [^self errorCanNotWrite].
	self nextWordPut: bfType.
	self nextLSBLongPut: bfSize.
	self nextLSBWordPut: bfReserved1.
	self nextLSBWordPut: bfReserved2.
	self nextLSBLongPut: bfOffBits!

writeBitmapInfoHeader
	biSize := 40.
	biWidth := imageObject width.
	biHeight := imageObject height.
	biPlanes := 1.
	biBitCount := imageObject bitsPerPixel.
	biCompression := 0.
	biSizeImage := 0.
	biXPelsPerMeter := 0.
	biYPelsPerMeter := 0.
	biClrUsed := 0.
	imageObject bitsPerPixel = 8 ifTrue: [biClrUsed := (imageObject palette size)].
	biClrImportant := 0.
	self nextLSBLongPut: biSize.
	self nextLSBLongPut: biWidth.
	self nextLSBLongPut: biHeight.
	self nextLSBWordPut: biPlanes.
	self nextLSBWordPut: biBitCount.
	self nextLSBLongPut: biCompression.
	self nextLSBLongPut: biSizeImage.
	self nextLSBLongPut: biXPelsPerMeter.
	self nextLSBLongPut: biYPelsPerMeter.
	self nextLSBLongPut: biClrUsed.
	self nextLSBLongPut: biClrImportant!

writeDepth24Data
	| total progress count index color rgb |
	self position = bfOffBits ifFalse: [^self errorCanNotWrite].
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total.
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 0.
			0 to: biWidth - 1
				do: 
					[:x | 
					index := imageObject atX: x y: y.
					color := imageObject palette at: index.
					rgb := self rgbIntegerFrom: color.
					self nextPut: (rgb bitAnd: 255).
					self nextPut: ((rgb bitShift: -8)
							bitAnd: 255).
					self nextPut: ((rgb bitShift: -16)
							bitAnd: 255).
					count := count + 3.
					progress := progress + 1.
					self progress: progress / total].
			[count \\ 4 = 0]
				whileFalse: 
					[self nextPut: 0.
					count := count + 1]].
	^imageObject!

writeDepth24Palette
	^imageObject palette!

writeDepth8Data
	| count index |
	self position = bfOffBits ifFalse: [^self errorCanNotWrite].
"
	total := biWidth * biHeight.
	progress := 0.
	self progress: progress / total. 
"
	biHeight - 1
		to: 0
		by: -1
		do: 
			[:y | 
			count := 0.
			0 to: biWidth - 1
				do: 
					[:x | 
					index := imageObject atX: x y: y.
					self nextPut: index.
					count := count + 1.
"					progress := progress + 1.
					self progress: progress / total
"
					].
			[count \\ 4 = 0]
				whileFalse: 
					[self nextPut: 0.
					count := count + 1]].
	^imageObject!

writeDepth8Palette
	| size palette array |
	size := 1 bitShift: biBitCount.
	palette := imageObject palette.
	palette size = size ifFalse: [self errorCanNotWrite].
	array := self rgbIntegerArrayFor: palette.
	array
		do: 
			[:rgb | 
			self nextPut: (rgb bitAnd: 255).
			self nextPut: ((rgb bitShift: -8)
					bitAnd: 255).
			self nextPut: ((rgb bitShift: -16)
					bitAnd: 255).
			self nextPut: 0].
	^imageObject palette!

writeImageData
	biCompression = 0 ifFalse: [^self errorCanNotWrite].
	biBitCount = 24 ifTrue: [^self writeDepth24Data].
	biBitCount = 8 ifTrue: [^self writeDepth8Data].
	^self errorCanNotWrite!

writeImagePalette
	imagePalette := nil.
	biBitCount = 24 ifTrue: [imagePalette := self writeDepth24Palette].
	biBitCount = 8 ifTrue: [imagePalette := self writeDepth8Palette].
	imagePalette isNil ifTrue: [^self errorCanNotWrite]! !
!BmpImageStream categoriesFor: #colorValueFrom:!private! !
!BmpImageStream categoriesFor: #nextImage!accessing!private! !
!BmpImageStream categoriesFor: #nextLSBLong!private!stream access! !
!BmpImageStream categoriesFor: #nextLSBLongPut:!private!stream access! !
!BmpImageStream categoriesFor: #nextLSBWord!private!stream access! !
!BmpImageStream categoriesFor: #nextLSBWordPut:!private!stream access! !
!BmpImageStream categoriesFor: #nextPutImage:!accessing!private! !
!BmpImageStream categoriesFor: #readBitmapFileHeader!decoding!private! !
!BmpImageStream categoriesFor: #readBitmapInfoHeader!decoding!private! !
!BmpImageStream categoriesFor: #readDepth1Data!decoding!private! !
!BmpImageStream categoriesFor: #readDepth1Palette!decoding!private! !
!BmpImageStream categoriesFor: #readDepth24Data!decoding!private! !
!BmpImageStream categoriesFor: #readDepth24Palette!decoding!private! !
!BmpImageStream categoriesFor: #readDepth8Data!decoding!private! !
!BmpImageStream categoriesFor: #readDepth8Palette!decoding!private! !
!BmpImageStream categoriesFor: #readImageData!decoding!private! !
!BmpImageStream categoriesFor: #readImagePalette!decoding!private! !
!BmpImageStream categoriesFor: #rgbIntegerArrayFor:!private! !
!BmpImageStream categoriesFor: #rgbIntegerFrom:!private! !
!BmpImageStream categoriesFor: #writeBitmapFileHeader!encoding!private! !
!BmpImageStream categoriesFor: #writeBitmapInfoHeader!encoding!private! !
!BmpImageStream categoriesFor: #writeDepth24Data!encoding!private! !
!BmpImageStream categoriesFor: #writeDepth24Palette!encoding!private! !
!BmpImageStream categoriesFor: #writeDepth8Data!encoding!private! !
!BmpImageStream categoriesFor: #writeDepth8Palette!encoding!private! !
!BmpImageStream categoriesFor: #writeImageData!encoding!private! !
!BmpImageStream categoriesFor: #writeImagePalette!encoding!private! !

!BmpImageStream class methodsFor!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!

example1
	"BmpImageStream example1."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename writeStream.
	[Cursor write showWhile: [stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example2
	"BmpImageStream example2."

	| filename stream image |
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename readStream.
	[Cursor read showWhile: [image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example3
	"BmpImageStream example3."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example4
	"BmpImageStream example4."

	| filename stream image |
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example5
	"BmpImageStream example5."

	| image filename stream progress |
	image := Image fromUser.
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[progress := Progress new.
			stream compute: [:value | progress value: value].
			progress message: 'writing bmp...'.
			progress do: [stream nextPutImage: image]]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example6
	"BmpImageStream example6."

	| filename stream progress image |
	filename := 'zzz.bmp' asFilename.
	stream := BmpImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[progress := Progress new.
			stream compute: [:value | progress value: value].
			progress message: 'reading bmp...'.
			progress do: [image := stream nextImage]]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

system
	^'Goodies'!

version
	^'003'! !
!BmpImageStream class categoriesFor: #copyright!copyright!private! !
!BmpImageStream class categoriesFor: #example1!examples!private! !
!BmpImageStream class categoriesFor: #example2!examples!private! !
!BmpImageStream class categoriesFor: #example3!examples!private! !
!BmpImageStream class categoriesFor: #example4!examples!private! !
!BmpImageStream class categoriesFor: #example5!examples!private! !
!BmpImageStream class categoriesFor: #example6!examples!private! !
!BmpImageStream class categoriesFor: #system!copyright!private! !
!BmpImageStream class categoriesFor: #version!copyright!private! !

BosImageStream guid: (GUID fromString: '{CF8E1717-8245-484E-B829-E665D8C361F7}')!
BosImageStream comment: ''!
!BosImageStream categoriesForClass!Unclassified! !
!BosImageStream methodsFor!

nextImage
	| size process bos image |
	self readHeader isNil ifTrue: [^nil].
	size := imageStream size max: 1.0e-6.
	process := [[imageStream position < size]
				whileTrue: 
					[self progress: imageStream position / size.
					(Delay forMilliseconds: 3) wait]] newProcess.
	process priority: Processor activeProcess priority + 5.
	process resume.
	
	[bos := BinaryObjectStorage onOldNoScan: imageStream.
	self progress: 0.
	image := bos next.
	self progress: 1]
		valueNowOrOnUnwindDo: 
			[process terminate.
			process := nil].
	^image!

nextPutImage: anImage 
	| size process bos bytes |
	(anImage isKindOf: Image) not ifTrue: [^self errorCanNotWrite].
	self writeHeader.
	bytes := WriteStream on: (bytes := ByteArray new: 1024).
	self size timesRepeat: [bytes nextPut: 0].
	bos := BinaryObjectStorage onNew: bytes.
	bos nextPut: anImage asImage.
	size := bytes contents size max: 1.0e-6.
	process := [[imageStream position < size]
				whileTrue: 
					[self progress: imageStream position / size.
					(Delay forMilliseconds: 3) wait]] newProcess.
	process priority: Processor activeProcess priority + 5.
	process resume.
	
	[bos := BinaryObjectStorage onNew: imageStream.
	self progress: 0.
	bos nextPut: anImage asImage.
	self progress: 1]
		valueNowOrOnUnwindDo: 
			[process terminate.
			process := nil].
	^anImage!

readHeader
	(self hasMagicNumber: 'BosImage' asByteArray)
		ifFalse: [^self errorCanNotRead]!

writeHeader
	self nextPutAll: 'BosImage' asByteArray.! !
!BosImageStream categoriesFor: #nextImage!accessing!private! !
!BosImageStream categoriesFor: #nextPutImage:!accessing!private! !
!BosImageStream categoriesFor: #readHeader!decoding!private! !
!BosImageStream categoriesFor: #writeHeader!encoding!private! !

!BosImageStream class methodsFor!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!

example1
	"BosImageStream example1."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename writeStream.
	[Cursor write showWhile: [stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example2
	"BosImageStream example2."

	| filename stream image |
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename readStream.
	[Cursor read showWhile: [image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example3
	"BosImageStream example3."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example4
	"BosImageStream example4."

	| filename stream image |
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example5
	"BosImageStream example5."

	| image filename stream progress |
	image := Image fromUser.
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[progress := Progress new.
			stream compute: [:value | progress value: value].
			progress message: 'writing bos...'.
			progress do: [stream nextPutImage: image]]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example6
	"BosImageStream example6."

	| filename stream image progress |
	filename := 'zzz.bos' asFilename.
	stream := BosImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[progress := Progress new.
			stream compute: [:value | progress value: value].
			progress message: 'reading bos...'.
			progress do: [image := stream nextImage]]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

system
	^'Goodies'!

version
	^'003'! !
!BosImageStream class categoriesFor: #copyright!copyright!private! !
!BosImageStream class categoriesFor: #example1!examples!private! !
!BosImageStream class categoriesFor: #example2!examples!private! !
!BosImageStream class categoriesFor: #example3!examples!private! !
!BosImageStream class categoriesFor: #example4!examples!private! !
!BosImageStream class categoriesFor: #example5!examples!private! !
!BosImageStream class categoriesFor: #example6!examples!private! !
!BosImageStream class categoriesFor: #system!copyright!private! !
!BosImageStream class categoriesFor: #version!copyright!private! !

GifImageStream guid: (GUID fromString: '{CB629B48-2AE6-4EC7-9187-DA35963637A9}')!
GifImageStream comment: ''!
!GifImageStream categoriesForClass!Unclassified! !
!GifImageStream methodsFor!

checkCodeSize
	(freeCode > maxCode and: [codeSize < 12])
		ifTrue:
			[codeSize := codeSize + 1.
			maxCode := (1 bitShift: codeSize) - 1]!

colorValueFrom: rgbInteger 
	| scalingValue |
	scalingValue := ColorValue scalingValue.
	^ColorValue
		scaledRed: (self
				convertValue: ((rgbInteger bitShift: -16)
						bitAnd: 255)
				from: 255
				to: scalingValue)
		scaledGreen: (self
				convertValue: ((rgbInteger bitShift: -8)
						bitAnd: 255)
				from: 255
				to: scalingValue)
		scaledBlue: (self
				convertValue: (rgbInteger bitAnd: 255)
				from: 255
				to: scalingValue)!

convertToCoverageWithTransparentPixel: pixelValue with: anImage 
	| image row |
	image := Image
				extent: anImage extent
				depth: 1
				palette: CoveragePalette monoMaskPalette.
	0 to: anImage height - 1
		do: 
			[:i | 
			row := anImage rowAt: i.
			row := row collect: [:p | p = pixelValue
							ifTrue: [0]
							ifFalse: [1]].
			image rowAt: i putAll: row].
	^image!

convertToGray: coverageValue 
	coverageValue = CoverageValue transparent ifTrue: [^ColorValue white].
	coverageValue = CoverageValue opaque ifTrue: [^ColorValue black].
	^ColorValue brightness: coverageValue coverage!

convertToMappedPalette: coveragePalette 
	coveragePalette size = 2 ifTrue: [^MappedPalette whiteBlack].
	^MappedPalette withColors: (coveragePalette collect: [:coverage | self convertToGray: coverage])!

fillBuffer
	| packSize |
	packSize := self next.
	bufStream := ReadStream on: (self next: packSize)!

flushBits
	remainBitCount = 0
		ifFalse: 
			[self nextBytePut: bufByte.
			remainBitCount := 0].
	self flushBuffer!

flushBuffer
	bufStream isEmpty ifTrue: [^self].
	self nextPut: bufStream size.
	self nextPutAll: bufStream contents.
	bufStream := WriteStream on: (ByteArray new: 256)!

flushCode
	self flushBits!

nextBits
	| integer readBitCount shiftCount |
	integer := 0.
	remainBitCount = 0
		ifTrue: 
			[readBitCount := 8.
			shiftCount := 0]
		ifFalse: 
			[readBitCount := remainBitCount.
			shiftCount := remainBitCount - 8].
	[readBitCount < codeSize]
		whileTrue: 
			[self peekByte isNil ifTrue: [^eoiCode].
			integer := integer + (self nextByte bitShift: shiftCount).
			shiftCount := shiftCount + 8.
			readBitCount := readBitCount + 8].
	self peekByte isNil ifTrue: [^eoiCode].
	(remainBitCount := readBitCount - codeSize) = 0
		ifTrue: [integer := integer + (self nextByte bitShift: shiftCount)]
		ifFalse: [integer := integer + (self peekByte bitShift: shiftCount)].
	^integer bitAnd: maxCode!

nextBitsPut: anInteger 
	| integer writeBitCount shiftCount |
	shiftCount := 0.
	remainBitCount = 0
		ifTrue: 
			[writeBitCount := 8.
			integer := anInteger]
		ifFalse: 
			[writeBitCount := remainBitCount.
			integer := bufByte + (anInteger bitShift: 8 - remainBitCount)].
	[writeBitCount < codeSize]
		whileTrue: 
			[self nextBytePut: ((integer bitShift: shiftCount)
					bitAnd: 255).
			shiftCount := shiftCount - 8.
			writeBitCount := writeBitCount + 8].
	(remainBitCount := writeBitCount - codeSize) = 0
		ifTrue: [self nextBytePut: (integer bitShift: shiftCount)]
		ifFalse: [bufByte := integer bitShift: shiftCount].
	^anInteger!

nextByte
	bufStream atEnd
		ifTrue:
			[self atEnd ifTrue: [^nil].
			self fillBuffer].
	^bufStream next!

nextBytePut: aByte
	bufStream nextPut: aByte.
	bufStream size >= 254 ifTrue: [self flushBuffer]!

nextImage
	| bits depth image |
	self readHeader isNil ifTrue: [^nil].
	bits := self readBitData.
	depth := bitsPerPixel > 8
				ifTrue: [^self error: 'unexpected bits per pixel']
				ifFalse: [bitsPerPixel = 1
						ifTrue: [1]
						ifFalse: [bitsPerPixel = 2
								ifTrue: [2]
								ifFalse: [bitsPerPixel <= 4
										ifTrue: [4]
										ifFalse: [8]]]].
	depth < 8 ifTrue: [bits := self
					packBits: bits
					depthFrom8To: depth
					width: width
					height: height
					pad: 8].
	image := Image
				extent: width @ height
				depth: depth
				palette: colorPalette
				bits: bits
				pad: 8.
	transparentPixel notNil ifTrue: [image := OpaqueImage figure: image shape: (CachedImage on: (self convertToCoverageWithTransparentPixel: transparentPixel with: image) asRetainedMedium)].
	^image!

nextPutImage: anImage 
	| theImage trueBitsPerPixel achievableBitsPerPixel bits |
	(anImage isKindOf: Image)
		ifFalse: [^self errorCanNotWrite].
	anImage bitsPerPixel > 8
		ifTrue: [theImage := anImage convertToPalette: self class colorPalette256 "renderedBy: ErrorDiffusion new"]
		ifFalse: [theImage := anImage].
	width := theImage width.
	height := theImage height.
	colorPalette := theImage palette.
	trueBitsPerPixel := theImage bitsPerPixel.
	achievableBitsPerPixel := 2 raisedTo: ((colorPalette size - 1) highBit - 1) highBit.
	bitsPerPixel := achievableBitsPerPixel.
	colorPalette := theImage palette.
	colorPalette paintBasis == CoverageValue
		ifTrue: 
			[transparentPixel := 0.
			colorPalette := self convertToMappedPalette: colorPalette].
	bits := theImage bits.
	trueBitsPerPixel < 8 ifTrue: [bits := self
					unpackBits: bits
					depthTo8From: bitsPerPixel
					width: theImage width
					height: theImage height
					pad: 32].
	interlace := true.
	
	[self writeHeader.
	self writeBitData: bits]
		valueNowOrOnUnwindDo: [self close].
	^theImage!

packBits: bits depthFrom8To: depth width: xSize height: ySize pad: pad 
	| maxPixelVal pixelInByte bitsWidth pBitsWidth pBits |
	(#(1 2 4) includes: depth)
		ifFalse: [^self error: 'depth must be 1, 2, or 4'].
	(#(8 16 32) includes: pad)
		ifFalse: [^self error: 'pad must be 8, 16, or 32'].
	maxPixelVal := (1 bitShift: depth)
				- 1.
	pixelInByte := 8 / depth.
	bitsWidth := xSize * 8 + pad - 1 // pad * (pad / 8).
	pBitsWidth := xSize * depth + pad - 1 // pad * (pad / 8).
	pBits := ByteArray new: pBitsWidth * ySize.
	1 to: ySize
		do: 
			[:i | 
			| bitIndex pBitIndex pixelVal count |
			bitIndex := i - 1 * bitsWidth.
			pBitIndex := i - 1 * pBitsWidth.
			pixelVal := 0.
			count := 0.
			1 to: xSize
				do: 
					[:j | 
					| val |
					val := bits at: (bitIndex := bitIndex + 1).
					val > maxPixelVal ifTrue: [^self error: 'can''t pack bits'].
					pixelVal := (pixelVal bitShift: depth)
								+ val.
					(count := count + 1) >= pixelInByte
						ifTrue: 
							[pBits at: (pBitIndex := pBitIndex + 1) put: pixelVal.
							pixelVal := 0.
							count := 0]].
			count > 0 ifTrue: [pBits at: (pBitIndex := pBitIndex + 1) put: (pixelVal bitShift: depth * (pixelInByte - count))]].
	^pBits!

peekByte
	bufStream atEnd
		ifTrue:
			[self atEnd ifTrue: [^nil].
			self fillBuffer].
	^bufStream peek!

readBitData
	| bits outCodes outCount bitMask initCodeSize code curCode oldCode inCode finChar set |
	pass := 0.
	xpos := 0.
	ypos := 0.
	rowByteSize := width * 8 + 7 // 8.
	remainBitCount := 0.
	bufByte := 0.
	bufStream := ReadStream on: ByteArray new.
	bits := ByteArray new: width * height.
	outCodes := ByteArray new: 1025.
	outCount := 0.
	bitMask := (1 bitShift: bitsPerPixel)
				- 1.
	prefixTable := Array new: 4096.
	suffixTable := Array new: 4096.
	initCodeSize := self next.
	self setParameters: initCodeSize.
	set := Set new: height.
	self progress: set size / height.
	[(code := self readCode) = eoiCode]
		whileFalse: [code = clearCode
				ifTrue: 
					[self setParameters: initCodeSize.
					curCode := oldCode := code := self readCode.
					finChar := curCode bitAnd: bitMask.
					set add: ypos.
					self progress: set size / height.
					self writePixel: finChar to: bits]
				ifFalse: 
					[curCode := inCode := code.
					curCode >= freeCode
						ifTrue: 
							[curCode := oldCode.
							outCodes at: (outCount := outCount + 1) put: finChar].
					[curCode > bitMask]
						whileTrue: 
							[outCount > 1024 ifTrue: [^self error: 'corrupt GIF file (OutCount)'].
							outCodes at: (outCount := outCount + 1) put: (suffixTable at: curCode + 1).
							curCode := prefixTable at: curCode + 1].
					finChar := curCode bitAnd: bitMask.
					outCodes at: (outCount := outCount + 1) put: finChar.
					outCount
						to: 1
						by: -1
						do: 
							[:i | 
							set add: ypos.
							self progress: set size / height.
							self writePixel: (outCodes at: i)
								to: bits].
					outCount := 0.
					prefixTable at: freeCode + 1 put: oldCode.
					suffixTable at: freeCode + 1 put: finChar.
					oldCode := inCode.
					freeCode := freeCode + 1.
					self checkCodeSize]].
	prefixTable := suffixTable := nil.
	^bits!

readCode
	^self nextBits!

readExtension
	| label |
	label := self next.
	label == GraphicControlLabel
		ifTrue: [self readGraphicControlExtensionBlock]
		ifFalse: [self error: 'unsupported extension block']!

readGraphicControlExtensionBlock
	| isTransparent |
	self next.
	isTransparent := (self next bitAnd: 1)
				= 1.
	self next: 2.
	isTransparent
		ifTrue: [transparentPixel := self next]
		ifFalse: [self next].
	self next!

readHeader
	| byte hasColorMap |
	((self hasMagicNumber: 'GIF89a' asByteArray)
		or: [self hasMagicNumber: 'GIF87a' asByteArray])
		ifFalse: [^self errorCanNotRead].
	self readWord.
	self readWord.
	byte := self next.
	hasColorMap := (byte bitAnd: 128)
				~= 0.
	bitsPerPixel := (byte bitAnd: 7)
				+ 1.
	byte := self next.
	byte := self next.
	hasColorMap
		ifTrue: 
			[| array |
			array := Array new: (1 bitShift: bitsPerPixel).
			1 to: array size do: [:i | array at: i put: (self colorValueFrom: (self next bitShift: 16)
							+ (self next bitShift: 8) + self next)].
			colorPalette := MappedPalette withColors: array]
		ifFalse: 
			[Transcript cr; show: 'GIF file does not have a color map.'.
			colorPalette := MappedPalette monochromeDefault].
	
	[byte := self next.
	byte == Extension]
		whileTrue: [self readExtension].
	byte = ImageSeparator ifFalse: [^self error: 'corrupt GIF file (nosep)'].
	self readWord.
	self readWord.
	width := self readWord.
	height := self readWord.
	interlace := (self next bitAnd: 64)
				~= 0!

readPixelFrom: bits
	| pixel |
	ypos >= height ifTrue: [^nil].
	pixel := bits at: (ypos * rowByteSize + xpos + 1).
	self updatePixelPosition.
	^pixel!

readWord
	^self next + (self next bitShift: 8)!

rgbIntegerArrayFor: aPalette 
	| colors |
	colors := Array new: aPalette maxIndex + 1.
	1 to: colors size do: [:i | colors at: i put: (self rgbIntegerFrom: (aPalette at: i - 1 ifAbsent: [ColorValue white]))].
	^colors!

rgbIntegerFrom: aColorValue 
	| scalingValue |
	scalingValue := ColorValue scalingValue.
	^((self
		convertValue: aColorValue scaledRed
		from: scalingValue
		to: 255)
		bitShift: 16)
		+ ((self
				convertValue: aColorValue scaledGreen
				from: scalingValue
				to: 255)
				bitShift: 8) + (self
			convertValue: aColorValue scaledBlue
			from: scalingValue
			to: 255)!

setParameters: initCodeSize
	clearCode := 1 bitShift: initCodeSize.
	eoiCode := clearCode + 1.
	freeCode := clearCode + 2.
	codeSize := initCodeSize + 1.
	maxCode := (1 bitShift: codeSize) - 1!

transparentPixel: aPixelValueOrNil 
	transparentPixel := aPixelValueOrNil!

unpackBits: bits depthTo8From: depth width: xSize height: ySize pad: pad 
	| bitMask pixelInByte bitsWidth upBitsWidth stopWidth trailingSize upBits |
	(#(1 2 4) includes: depth)
		ifFalse: [^self error: 'depth must be 1, 2, or 4'].
	(#(8 16 32) includes: pad)
		ifFalse: [^self error: 'pad must be 8, 16, or 32'].
	bitMask := (1 bitShift: depth)
				- 1.
	pixelInByte := 8 / depth.
	bitsWidth := xSize * depth + pad - 1 // pad * (pad / 8).
	upBitsWidth := xSize * 8 + pad - 1 // pad * (pad / 8).
	stopWidth := xSize * depth + 7 // 8.
	trailingSize := xSize - (stopWidth - 1 * pixelInByte).
	upBits := ByteArray new: upBitsWidth * ySize.
	1 to: ySize
		do: 
			[:i | 
			| bitIndex upBitIndex val |
			bitIndex := i - 1 * bitsWidth.
			upBitIndex := i - 1 * upBitsWidth.
			1 to: stopWidth - 1
				do: 
					[:j | 
					val := bits at: (bitIndex := bitIndex + 1).
					upBitIndex := upBitIndex + pixelInByte.
					1 to: pixelInByte
						do: 
							[:k | 
							upBits at: upBitIndex - k + 1 put: (val bitAnd: bitMask).
							val := val bitShift: depth negated]].
			val := (bits at: (bitIndex := bitIndex + 1))
						bitShift: depth negated * (pixelInByte - trailingSize).
			upBitIndex := upBitIndex + trailingSize.
			1 to: trailingSize
				do: 
					[:k | 
					upBits at: upBitIndex - k + 1 put: (val bitAnd: bitMask).
					val := val bitShift: depth negated]].
	^upBits!

updatePixelPosition
	(xpos := xpos + 1) >= width ifFalse: [^self].
	xpos := 0.
	interlace
		ifFalse: 
			[ypos := ypos + 1.
			^self].
	pass = 0
		ifTrue: 
			[(ypos := ypos + 8) >= height
				ifTrue: 
					[pass := pass + 1.
					ypos := 4].
			^self].
	pass = 1
		ifTrue: 
			[(ypos := ypos + 8) >= height
				ifTrue: 
					[pass := pass + 1.
					ypos := 2].
			^self].
	pass = 2
		ifTrue: 
			[(ypos := ypos + 4) >= height
				ifTrue: 
					[pass := pass + 1.
					ypos := 1].
			^self].
	pass = 3
		ifTrue: 
			[ypos := ypos + 2.
			^self].
	^self error: 'can''t happen'!

writeBitData: bits 
	| maxBits maxMaxCode tSize initCodeSize ent tShift fCode pixel set |

	pass := 0.
	xpos := 0.
	ypos := 0.
	rowByteSize := width * 8 + 31 // 32 * 4.
	remainBitCount := 0.
	bufByte := 0.
	bufStream := WriteStream on: (ByteArray new: 256).
	maxBits := 12.
	maxMaxCode := 1 bitShift: maxBits.
	tSize := 5003.
	prefixTable := Array new: tSize.
	suffixTable := Array new: tSize.
	initCodeSize := bitsPerPixel <= 1
				ifTrue: [2]
				ifFalse: [bitsPerPixel].
	self nextPut: initCodeSize.
	self setParameters: initCodeSize.
	tShift := 0.
	fCode := tSize.
	[fCode < 65536]
		whileTrue: 
			[tShift := tShift + 1.
			fCode := fCode * 2].
	tShift := 8 - tShift.
	1 to: tSize do: [:i | suffixTable at: i put: -1].

"	set := Set new: height.
	self progress: set size / height.
	set add: ypos. 
	self progress: set size / height."

	self writeCodeAndCheckCodeSize: clearCode.
	ent := self readPixelFrom: bits.
	[(pixel := self readPixelFrom: bits) == nil]
		whileFalse: 
			[| index disp nomatch |

"			set add: ypos. 
			self progress: set size / height."

			fCode := (pixel bitShift: maxBits)
						+ ent.
			index := ((pixel bitShift: tShift)
						bitXor: ent)
						+ 1.
			(suffixTable at: index)
				= fCode
				ifTrue: [ent := prefixTable at: index]
				ifFalse: 
					[nomatch := true.
					(suffixTable at: index)
						>= 0
						ifTrue: 
							[disp := tSize - index + 1.
							index = 1 ifTrue: [disp := 1].
							
							[(index := index - disp) < 1 ifTrue: [index := index + tSize].
							(suffixTable at: index)
								= fCode
								ifTrue: 
									[ent := prefixTable at: index.
									nomatch := false].
							nomatch and: [(suffixTable at: index)
									> 0]] whileTrue].
					nomatch
						ifTrue: 
							[self writeCodeAndCheckCodeSize: ent.
							ent := pixel.
							freeCode < maxMaxCode
								ifTrue: 
									[prefixTable at: index put: freeCode.
									suffixTable at: index put: fCode.
									freeCode := freeCode + 1]
								ifFalse: 
									[self writeCodeAndCheckCodeSize: clearCode.
									1 to: tSize do: [:i | suffixTable at: i put: -1].
									self setParameters: initCodeSize]]].
"			set add: ypos. 
			self progress: set size / height"].

	prefixTable := suffixTable := nil.
	self writeCodeAndCheckCodeSize: ent.
	self writeCodeAndCheckCodeSize: eoiCode.
	self flushCode.
	self nextPut: 0.
	self nextPut: Terminator!

writeCode: aCode
	self nextBitsPut: aCode!

writeCodeAndCheckCodeSize: aCode
	self writeCode: aCode.
	self checkCodeSize!

writeGraphicControlExtensionBlock
	self nextPut: Extension.
	self nextPut: GraphicControlLabel.
	self nextPut: 4.
	transparentPixel notNil
		ifTrue: [self nextPut: 1]
		ifFalse: [self nextPut: 0].
	self nextPut: 0.
	self nextPut: 0.
	transparentPixel notNil
		ifTrue: [self nextPut: transparentPixel]
		ifFalse: [self nextPut: 0].
	self nextPut: 0!

writeHeader
	| byte array |
	self nextPutAll: 'GIF89a' asByteArray.
	self writeWord: width.
	self writeWord: height.
	byte := 128.
	byte := byte bitOr: (bitsPerPixel - 1 bitShift: 5).
	byte := byte bitOr: bitsPerPixel - 1.
	self nextPut: byte.
	self nextPut: 0.
	self nextPut: 0.
	array := self rgbIntegerArrayFor: colorPalette.
	array do: [:rgb | self nextPut: ((rgb bitShift: -16)
				bitAnd: 255); nextPut: ((rgb bitShift: -8)
				bitAnd: 255); nextPut: (rgb bitAnd: 255)].
	array size + 1 to: (1 bitShift: bitsPerPixel)
		do: [:i | self nextPut: 0; nextPut: 0; nextPut: 0].
	transparentPixel notNil ifTrue: [self writeGraphicControlExtensionBlock].
	self nextPut: ImageSeparator.
	self writeWord: 0.
	self writeWord: 0.
	self writeWord: width.
	self writeWord: height.
	byte := interlace
				ifTrue: [64]
				ifFalse: [0].
	self nextPut: byte!

writePixel: pixel to: bits 
	bits at: ypos * rowByteSize + xpos + 1 put: pixel.
	self updatePixelPosition!

writeWord: aWord 
	self nextPut: (aWord bitAnd: 255).
	self nextPut: ((aWord bitShift: -8)
			bitAnd: 255).
	^aWord! !
!GifImageStream categoriesFor: #checkCodeSize!private! !
!GifImageStream categoriesFor: #colorValueFrom:!private! !
!GifImageStream categoriesFor: #convertToCoverageWithTransparentPixel:with:!private! !
!GifImageStream categoriesFor: #convertToGray:!private! !
!GifImageStream categoriesFor: #convertToMappedPalette:!private! !
!GifImageStream categoriesFor: #fillBuffer!packing!private! !
!GifImageStream categoriesFor: #flushBits!bits access!private! !
!GifImageStream categoriesFor: #flushBuffer!packing!private! !
!GifImageStream categoriesFor: #flushCode!encoding!private! !
!GifImageStream categoriesFor: #nextBits!bits access!private! !
!GifImageStream categoriesFor: #nextBitsPut:!bits access!private! !
!GifImageStream categoriesFor: #nextByte!packing!private! !
!GifImageStream categoriesFor: #nextBytePut:!packing!private! !
!GifImageStream categoriesFor: #nextImage!accessing!private! !
!GifImageStream categoriesFor: #nextPutImage:!accessing!private! !
!GifImageStream categoriesFor: #packBits:depthFrom8To:width:height:pad:!private! !
!GifImageStream categoriesFor: #peekByte!packing!private! !
!GifImageStream categoriesFor: #readBitData!decoding!private! !
!GifImageStream categoriesFor: #readCode!decoding!private! !
!GifImageStream categoriesFor: #readExtension!GIF89a!private! !
!GifImageStream categoriesFor: #readGraphicControlExtensionBlock!GIF89a!private! !
!GifImageStream categoriesFor: #readHeader!decoding!private! !
!GifImageStream categoriesFor: #readPixelFrom:!encoding!private! !
!GifImageStream categoriesFor: #readWord!decoding!private! !
!GifImageStream categoriesFor: #rgbIntegerArrayFor:!private! !
!GifImageStream categoriesFor: #rgbIntegerFrom:!private! !
!GifImageStream categoriesFor: #setParameters:!private! !
!GifImageStream categoriesFor: #transparentPixel:!GIF89a!private! !
!GifImageStream categoriesFor: #unpackBits:depthTo8From:width:height:pad:!private! !
!GifImageStream categoriesFor: #updatePixelPosition!private! !
!GifImageStream categoriesFor: #writeBitData:!encoding!private! !
!GifImageStream categoriesFor: #writeCode:!encoding!private! !
!GifImageStream categoriesFor: #writeCodeAndCheckCodeSize:!encoding!private! !
!GifImageStream categoriesFor: #writeGraphicControlExtensionBlock!GIF89a!private! !
!GifImageStream categoriesFor: #writeHeader!encoding!private! !
!GifImageStream categoriesFor: #writePixel:to:!decoding!private! !
!GifImageStream categoriesFor: #writeWord:!encoding!private! !

!GifImageStream class methodsFor!

copyright
	^'Copyright (C) 1995-1998 AOKI Atsushi, All Rights Reserved.'!

example1
	"GifImageStream example1."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename writeStream.
	[Cursor write showWhile: [stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example2
	"GifImageStream example2."

	| filename stream image |
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename readStream.
	[Cursor read showWhile: [image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example3
	"GifImageStream example3."

	| image filename stream |
	image := Image fromUser.
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			stream nextPutImage: image]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example4
	"GifImageStream example4."

	| filename stream image |
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[stream compute: [:value | Transcript cr; show: value printString].
			image := stream nextImage]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

example5
	"GifImageStream example5."

	| image filename stream progress |
	image := Image fromUser.
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename writeStream.
	[Cursor write
		showWhile: 
			[progress := Progress new.
			stream compute: [:value | progress value: value].
			progress message: 'writing gif...'.
			progress do: [stream nextPutImage: image]]]
		valueNowOrOnUnwindDo: [stream close].
	^image!

example6
	"GifImageStream example6."

	| filename stream image progress |
	filename := 'zzz.gif' asFilename.
	stream := GifImageStream on: filename readStream.
	[Cursor read
		showWhile: 
			[progress := Progress new.
			stream compute: [:value | progress value: value].
			progress message: 'reading gif...'.
			progress do: [image := stream nextImage]]]
		valueNowOrOnUnwindDo: [stream close].
	stream show: image.
	^image!

initialize
	"GifImageStream initialize."

	ImageSeparator := $, asInteger.
	Extension := $!! asInteger.
	Terminator := $; asInteger.
	GraphicControlLabel := 249!

system
	^'Goodies'!

version
	^'003'! !
!GifImageStream class categoriesFor: #copyright!copyright!private! !
!GifImageStream class categoriesFor: #example1!examples!private! !
!GifImageStream class categoriesFor: #example2!examples!private! !
!GifImageStream class categoriesFor: #example3!examples!private! !
!GifImageStream class categoriesFor: #example4!examples!private! !
!GifImageStream class categoriesFor: #example5!examples!private! !
!GifImageStream class categoriesFor: #example6!examples!private! !
!GifImageStream class categoriesFor: #initialize!class initialization!private! !
!GifImageStream class categoriesFor: #system!copyright!private! !
!GifImageStream class categoriesFor: #version!copyright!private! !

FixedPoint guid: (GUID fromString: '{E148AEE7-AA47-4A30-8D98-9EC2C47361E3}')!
FixedPoint comment: ''!
!FixedPoint categoriesForClass!Unclassified! !
!FixedPoint methodsFor!

printDotString
	^self printString! !
!FixedPoint categoriesFor: #printDotString!public! !

AspectAdaptor guid: (GUID fromString: '{CBC84F03-674A-43F5-9A9B-27FD2E777698}')!
AspectAdaptor comment: ''!
!AspectAdaptor categoriesForClass!Unclassified! !
!AspectAdaptor methodsFor!

aspect
	^aspect!

aspect: aSymbol
	aspect := aSymbol!

value
	^self subject perform: self aspect!

value: aValue
	self subject perform: (self aspect asString, ':') asSymbol with: aValue! !
!AspectAdaptor categoriesFor: #aspect!accessing!public! !
!AspectAdaptor categoriesFor: #aspect:!accessing!public! !
!AspectAdaptor categoriesFor: #value!accessing!public! !
!AspectAdaptor categoriesFor: #value:!accessing!public! !

!AspectAdaptor class methodsFor!

forAspect: aSymbol
	^super new aspect: aSymbol! !
!AspectAdaptor class categoriesFor: #forAspect:!instance creation!public! !

IndexedAdaptor guid: (GUID fromString: '{267CEF4E-F2EF-445B-B043-125B4CBED3A6}')!
IndexedAdaptor comment: ''!
!IndexedAdaptor categoriesForClass!Unclassified! !
!IndexedAdaptor methodsFor!

index
	^index!

index: aNumber
	index := aNumber!

value
	self subject at: self index!

value: aValue
	self subject at: self index put: aValue! !
!IndexedAdaptor categoriesFor: #index!accessing!public! !
!IndexedAdaptor categoriesFor: #index:!accessing!public! !
!IndexedAdaptor categoriesFor: #value!accessing!public! !
!IndexedAdaptor categoriesFor: #value:!accessing!public! !

!IndexedAdaptor class methodsFor!

forIndex: aNumber
	^super new index: aNumber! !
!IndexedAdaptor class categoriesFor: #forIndex:!instance creation!public! !

AIDASite guid: (GUID fromString: '{EEF2D63F-E166-4C47-8427-EC08AC930581}')!
AIDASite comment: ''!
!AIDASite categoriesForClass!Unclassified! !
!AIDASite methodsFor!

addAllowHeaderTo: aHTTPResponse
	| methods |
	methods := 'OPTIONS,GET,HEAD,POST,DELETE,TRACE,PROPFIND,PROPPATCH,PUT'.
	aHTTPResponse addHeaderName: 'Allow' value: methods!

addDontCacheHeaderTo: aHTTPResponse forPage: aWebPage
	| object value |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	value := object aidaDontCache.
	value ifFalse: [value := aWebPage aidaDontCache].
	value ifTrue: [aHTTPResponse 
		addHeaderName: 'Cache-Control' value: 'no-store, no-cache, must-revalidate'].!

addExpiresHeaderTo: aHTTPResponse forPage: aWebPage
	| object value |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	value := object expiresTimestamp.
	value isNil ifTrue: [value := aWebPage expiresTimestamp].
	value notNil ifTrue: [aHTTPResponse 
		addHeaderName: 'Expires' value: value rfc1123String].!

addModifiedHeaderTo: aHTTPResponse forPage: aWebPage
	| object value |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	value := object modifiedTimestamp.
	value isNil ifTrue: [value := aWebPage modifiedTimestamp].
	value notNil ifTrue: [aHTTPResponse 
		addHeaderName: 'Last-Modified' value: value rfc1123String].!

addResponseHeadersTo: aHTTPResponse forPage: aWebPage
	"use observee in app to find timestamps, because observee points 
	to right version of an object!! "
	| object |
	object := aWebPage isWebApplication ifTrue: [aWebPage observee] ifFalse: [aWebPage].
	aHTTPResponse addHeaderName: 'Content-Type' value: object contentType.
	self addModifiedHeaderTo: aHTTPResponse forPage: aWebPage.
	self addExpiresHeaderTo: aHTTPResponse forPage: aWebPage.
	self addDontCacheHeaderTo: aHTTPResponse forPage: aWebPage.!

addressTextFor: anIPAddress

	^((anIPAddress hostAddress at: 1) printString, '.',
	(anIPAddress hostAddress at: 2) printString, '.',
	(anIPAddress hostAddress at: 3) printString, '.',
	(anIPAddress hostAddress at: 4) printString)!

addSystemService: aServiceObject named: aSymbol 
	"add a new system service (e.g URLResolver) to the dictionary of services"
	self systemServices
		at: aSymbol asSymbol put: aServiceObject!

addToRunningHistoryCrashed: aBoolean
	"Call it at server startup (in setStartedTimestamp). It reads old timestamps (started and
	last alive) and add it to the history" 
	| array |
	array := Array new: 3.
	array
		at: 1 put: self startedTimestamp asSeconds;
		at: 2 put: self lastTimeAliveTimestamp asSeconds;
		at: 3 put: aBoolean.  "true if server crashed"
	self runningHistoryCollection add: array.!

addUserService: aServiceObject named: aSymbol 
	"add a new user service (e.g WebIndex) to the dictionary of services"
	self userServices
		at: aSymbol asSymbol put: aServiceObject

"
WebServer default 
	addUserService: (URLResolver default ooRefFromURL: '/koledar.html')
	named: #Koledar
"!

admin
	^self systemServices 
		at: #Admin
		ifAbsent: 
			[self addSystemService: (WebAdmin new) named: #Admin.
			self urlResolver defaultURL: '/admin.html' forObject: self admin.
			^self admin].!

afterLogin
	^self settings at: #afterLogin ifAbsentPut: [#lastPage]. "back to last page before logout"!

afterLogin: aSymbol
	"#lastPage - bak to a page before logout
	#defaultPage - '/' "
	self settings  at: #afterLogin put: aSymbol!

answer: anObject to: aRequest on: aWebSession
	aRequest isGet | aRequest isPost | aRequest isHead
		ifTrue: [^self answer: anObject toGetOrPost: aRequest on: aWebSession].
	aRequest isOptions ifTrue: [^self answer: anObject toOptions: aRequest on: aWebSession].
	aRequest isPropFind ifTrue: [^self answer: anObject toPropFind: aRequest on: aWebSession].
	aRequest isLock ifTrue: [^self answer: anObject toLock: aRequest on: aWebSession].
	aRequest isUnlock ifTrue: [^self answer: anObject toUnlock: aRequest on: aWebSession].
	aRequest isPut ifTrue: [^self answer: anObject toPut: aRequest on: aWebSession].
	^HTTPException notImplemented!

answer: anObject toGetOrPost: aRequest on: aWebSession
	| page stream response |
	page := aRequest isWebRequest
		ifTrue: [anObject printWebPageFor: aWebSession]
		ifFalse: [anObject printWapDocumentFor: aWebSession].
	page isNil ifTrue: [^HTTPException notFound].
	aWebSession isHttpAuthenticationNeeded "because of logout" ifTrue:  [^self unauthorizedResponse].
	aWebSession redirectLink notNil ifTrue: [^self redirectOn: aWebSession].
	self log: 'h'.
	stream := WriteStream on: String new.
	page isWebPage | page isWebElement
		ifTrue: [page printHTMLPageOn: stream forSession: aWebSession]
		ifFalse: [page printWMLDocumentOn: stream forSession: aWebSession].
	response := HTTPResponse ok.
	self addResponseHeadersTo: response forPage: page.
	response entity: (self properString: stream contents).
	aWebSession cookie ifFalse: [response cookie: (self cookieHeaderFor: aWebSession)].
	self log: ' done'.
	^response!

answer: anObject toLock: aRequest on: aWebSession
	"WebDAV lock request for that object"
	|  rsp |
	"Temporary!!!! just return a fake lock!!"
	rsp := Swazoo.HTTPLockResponse new.
	rsp start.
	rsp addTagName: 'locktype' value: #write.
	rsp addTagName: 'lockscope' value: #exclusive.
	rsp addTagName: 'depth' value: '0'.
	rsp addLockOwner: 'Administrator'.
	rsp addTagName: 'timeout' value: 'Second-604800'.  "one week, temporary!!"
	rsp addLockToken: 'opaquelocktoken:89001c0a-23f2-0310-b37d-c58bc335a1ff'.
	^rsp!

answer: anObject toOptions: aRequest on: aWebSession
	| response |
	response := HTTPResponse ok.
	self isWebDAVEnabled ifTrue: 
	 	[response addHeaderName: 'DAV' value: '1'.
		"without following header Windows refuse to add new Web folder!! "
		response addHeaderName: 'MS-Author-Via' value: 'DAV'].
	self addAllowHeaderTo: response.
	^response!

answer: anObject toPropFind: aRequest on: aWebSession
	"WebDAV properties request from object"
	|  multiResponse |
	"Temporary!!!! Now it just return empty collection, which is enough for MS web folders to add new!! "
	multiResponse := Swazoo.HTTPPropFindResponse new.
	multiResponse multiStart.
	multiResponse startResponseFor: aRequest uri value.
	multiResponse addPropertyName: 'getlastmodified' value: 'Mon, 21 Feb 2005 14:11:01 GMT'.
	aRequest uri value last = $/ ifTrue: "directory"
		[multiResponse addPropertyName: 'resourcetype' value: #collection].
	multiResponse endResponseWithStatusCode: 200.
	multiResponse multiEnd.
	^multiResponse!

answer: anObject toPut: aRequest on: aWebSession
	"WebDAV: try to PUT content into that object"
	(anObject isKindOf: FileProxy) ifFalse: [^HTTPException forbidden].
	anObject put: aRequest putData.
	^HTTPResponse ok!

answer: anObject toUnlock: aRequest on: aWebSession
	"WebDAV unlock request for that object"
	^HTTPResponse noContent. "204"!

answerTo: aRequest 
	| session object |
	[self	log: self cr , (self logStringFor: aRequest) , self cr , '              s'.
	self shouldRedirect ifTrue: [^self redirectToOtherHost: aRequest].
	session := self sessionManager findOrMakeSessionFor: aRequest.
	session isHttpAuthenticationNeeded ifTrue: [session authenticateFrom: aRequest].
	session isHttpAuthenticationNeeded "still" ifTrue: [^self unauthorizedResponse].
	self log: 'p'.
	object := self objectTo: aRequest forSession: session.
	object isNil ifTrue: [^HTTPResponse notFound].
	^self answer: object to: aRequest on: session]
		on: Error
		do: [:exception |
			exception class == HTTPException ifTrue: [^exception response].
self halt.
			Transcript show: 'error in aida code: ', exception errorString; cr.
			exception defaultAction. 
			HTTPException raiseResponse: (self httpResponseOnException: exception)].!

authenticationScheme
	"#Basic or #Digest, see rfc2617. Digest is recomended because password
	goes encrypted to server"
	self securityManager hasHttpBasicAuthenticationScheme ifTrue: [^#Basic].
	self securityManager hasHttpDigestAuthenticationScheme ifTrue: [^#Digest].
	^#None!

availability
	"return server availability from first run in %"
	"AIDASite default availability"
	| uptime downtime |
	uptime := self totalUptime.
	downtime := self totalDowntime.
	^((uptime / ((uptime + downtime) max: 1)) * 100) asFixedPoint: 2!

backupToFile
	"boss out all object tree to file aidasite-<sitename>.boss"
	"(AIDASite named: 'test') backupToFile"
	| filename boss |
	filename := ('aidasite-', self name, '.boss') asFilename.
	filename exists ifTrue: [filename copyTo: ('aidasite-', self name, '-old.boss')].
	boss := BinaryObjectStorage onNew: filename writeStream.
	[boss nextPut: self] ensure: [boss close].!

cookieHeaderFor: aSession 
	"set a permanent cookie on client (up to year 2010, enough?) "

	"for secure sessions different id as for usual !! "

	| id |
	id := aSession lastRequest isEncrypted 
				ifTrue: [aSession secureId]
				ifFalse: [aSession id].
	^(WriteStream on: String new)
		nextPutAll: self cookieName;
		nextPutAll: '=';
		nextPutAll: id printString;
		nextPutAll: '; path=/; expires=Friday, 01-Jan-2010 01:00:00 GMT';
		contents!

cookieName
	"this is the name for our cookie. It shold be unique, so it is a bit strange"
	^'aida9357'!

counters

	counters isNil ifTrue: [self initCounters].
	^counters

"WebServer default counters"!

countingPolicy
	^self settings at: #countingPolicy ifAbsentPut: [#all].!

countingPolicy: aSymbol
	"from who to count requests with WebCounters: #all, #excludeAdmins, #onlyGuests, #none"
	self settings  at: #countingPolicy put: aSymbol!

cr
	^String with: Character cr!

createdTimestamp
	"time and date of  server creation"
	^Timestamp fromSeconds:
		(self timestamps at: #Created ifAbsentPut: 	[Timestamp now asSeconds])!

critical: aBlock

	"For protecting critical sections in parallel execution of web requests. Use it always
	when you do things, which cannot be disturbed by another request. Exmaple:
		aServer critical: [<a block with critical section>]. "

	^WebTransactionMonitor critical: aBlock!

defaultUserService
	"which will be accessible with url: http:/hostname/ "
	^self admin!

demo
	^self userServices at: #WebDemo
		ifAbsent: 
			[self addUserService: WebDemo new named: #WebDemo.
			self urlResolver defaultURL: '/demo.html' forObject: self demo.
			^self demo]!

diagnostics

	"if true, diagnostic messages are written on transcript for every web request"
	^self settings  at: #diagnostics ifAbsentPut: [true].!

diagnostics: aBoolean
	"if true, diagnostic messages are written on transcript for every web request"
	self settings  at: #diagnostics put: aBoolean.

"WebServer default diagnostics: true"!

disableWebDAVSupport
	"Web Distributed Authoring and Versioning (WebDAV, www.webdav.org) is disabled on this site"
	"AIDASite default disableWebDAVSupport"
	self settings at: #WebDAVEnabled put: false!

discussions
	^self userServices 
		at: #WebDiscussions
		ifAbsent: 
			[self addUserService: (WebDiscussions new) named: #WebDiscussions.
			self urlResolver defaultURL: '/discussions.html' forObject: self discussions.
			^self discussions].!

enableWebDAVSupport
	"Web Distributed Authoring and Versioning (WebDAV, www.webdav.org) is enabled on this site"
	"AIDASite default enableWebDAVSupport"
	self settings at: #WebDAVEnabled put: true!

help
	^self systemServices 
		at: #Help
		ifAbsent: 
			[self addSystemService: (WebHelp new) named: #Help.
			self urlResolver defaultURL: '/help.html' forObject: self help.
			^self help].!

helpDirectory

	^self settings  at: #helpDirectory ifAbsent: [^'']!

helpDirectory: aString
	" a directory, where help html dokuments are stored. See WebApplication help pages category for 
 	details"
	self settings  at: #helpDirectory put: aString.!

helpURL

	^self settings  at: #helpURL ifAbsent: [^'']!

helpURL: aString
	self settings at: #helpURL put: aString.!

homeDirectory

	^self settings  at: #homeDirectory ifAbsent: [^'']!

homeDirectory: aString
	" a directory, which is the root for static html dokuments. Used for anAIDASite, when it searches 
	for usual html files. "
	self settings  at: #homeDirectory put: aString.!

hourlyStatsProcess

	"hourly report to transcript"
	"WebServer default hourlyStatsProcess"
	| hits pages new returning afterHits afterPages afterNew afterReturning |
	[
		hits := self totalCounter total.
		pages := self pagesCounter total.
		new :=	self newVisitorsCounter total.
		returning := self returningVisitorsCounter total.
		(Delay forSeconds: self secondsToHour) wait.
		[self isServing] whileTrue: 
			[afterHits := self totalCounter total.
			afterPages := self pagesCounter total.
			afterNew := self newVisitorsCounter total.
			afterReturning := self returningVisitorsCounter total.
			Transcript cr; show: '***'; cr; show:
				'***  ',  self name, ' ', 
				Time now hours printString, ':', Time now minutes printString, ' ',
				'    last hour hits: ', (afterHits - hits) printDotString, 
				'    pages: ', (afterPages - pages) printDotString, 
				'    visitors new: ', (afterNew - new) printDotString, 
				'    returning: ', (afterReturning - returning) printDotString;
				cr; show: '***'.
			self registerTopHourHits: (afterHits - hits) pages: (afterPages - pages).
			hits := afterHits. pages := afterPages.
			new := afterNew. returning := afterReturning.
			(Delay forSeconds: self secondsToHour) wait].
	] fork.!

httpResponseOnException: anException
	| response |
	response := HTTPResponse internalServerError.
	response entity: '
<HTML>
<HEAD><TITLE>', response codeText, '</TITLE></HEAD>
  <BODY>
   <H2>', response code printString, ' ', response codeText, '</H2>
   <P>The server experienced an error while processing this request. <BR>
   If this problem persists, please contact the webmaster.</P>
  <P>Error description:</P>
  <P>', anException messageText, '</P>
  <P>Stack:</P>
  <P>
, </P>
  </BODY>
</HTML>'.
	^response!

incNotFoundCounter

	"call this after each request is processed"


	self critical:
		[self notFoundCounter incCounter].!

incRequestCounterFor: anObject

	"call this after each request is processed"


	self critical:
		[self totalCounter incCounter.
		(anObject contentType = 'text/html') 
			ifTrue: [self pagesCounter incCounter] ].!

index
	^self userServices 
		at: #WebIndex
		ifAbsent: 
			[self addUserService: WebIndex new named: #WebIndex.
			self urlResolver defaultURL: '/search.html' forObject: self index.
			^self index].!

initCounters
	"counters of web requests: total and by year/day of year"
	self critical: 
		[counters := IdentityDictionary new.
		self pagesCounter.
		self totalCounter.
		self newVisitorsCounter.
		self returningVisitorsCounter.
		self notFoundCounter].

"WebServer default initCounters"!

initFavicon
	"/favicon.ico, a small icon shown in browser near url address"
	"(AIDASite named: 'biart') initFavicon."
	| icon |
	icon := WebMethodImage 
		fromMethod: #favicon on: self style contentType: 'image/x-icon' site: self.
	self urlResolver defaultURL: '/favicon.ico' forObject: icon.!

initialize
	super initialize.
	WebTransactionMonitor addServer: self.
	self initializeDefaultSettings.
	self initUrlsForSystemServices.
	self initFavicon.
	WebTransactionMonitor commit.!

initializeDefaultSettings

	self host: 'localhost' ip: '127.0.0.1'  port: 8888.
	self homeDirectory: './'.
	self helpDirectory: './help'.
	self helpURL: '/help'.
	self styleClass: 'WebStyle'.
	self diagnostics: false.
	self loggingPolicy: #none.
	self countingPolicy: #all.
	self smtpServer: self ip.
	self urgentNotificationEMail: 'info@eranova.si'.!

initTimestamps
	timestamps := IdentityDictionary new.
	self setLastTimeAliveTimestamp.
	self setCreatedTimestamp.

"WebServer default initTimestamps"!

initUrlsForSystemServices

	"register urls for access to system services if not already done"

	self admin.
	self securityManager.
	self webMsgs.
	self statistics

"WebServer default initUrlsForSystemServices"!

isWebDAVEnabled
	"Is Web Distributed Authoring and Versioning (WebDAV, www.webdav.org) ienabled on this site"
		^(self settings includesKey: #WebDAVEnabled)
			 and: [self settings includesKey: #WebDAVEnabled]!

lastCommitTimestamp
	"time and date of last commit to the database. If noone yet, return nil"
	^Timestamp fromSeconds: (self timestamps at: #LastCommit ifAbsent: [^nil])!

lastRequestTimestamp
	"time and date of last web request. If noone yet, return nil"
	^Timestamp fromSeconds: (self timestamps at: #LastRequest ifAbsent: [^nil])!

lastTimeAliveTimestamp
	"lastTimeAliveThread writes to timestamps every minute and commit. 
	Used in case of crash to determine, when a server was last time alive 
	and worked properly"
	^Timestamp fromSeconds: 
		(self timestamps at: #LastTimeAlive ifAbsentPut: [Timestamp now asSeconds])!

log: aString
	self diagnostics ifTrue: [Transcript show: aString].!

logging

	"if true, all requests are logged into a database"
	^self settings  at: #logging ifAbsentPut: [false].!

loggingPolicy
	^self settings at: #loggingPolicy ifAbsentPut: [#none].!

loggingPolicy: aSymbol
	"from who to log requests with WebCounters: #all, #excludeAdmins, #onlyGuests, #none"
	self settings  at: #loggingPolicy put: aSymbol!

logStringFor: aRequest
	^self name, ' ',
 		Date today dayOfMonth printString, '.',
		Date today monthIndex printString, ' ',
		Time now hours printString, ':', 
		Time now minutes printString,
		' from ', (aRequest peer notNil ifTrue: [aRequest peer] ifFalse: ['']), ' url: ',
		aRequest urlString!

mimeMap
	^self systemServices 
		at: #MimeMap
		ifAbsent: 
			[self addSystemService: MIMEMap new named: #MimeMap.
			^self mimeMap].!

minuteStatsProcess

	"every minute report to transcript"
	"WebServer default minuteStatsProcess"
	| hits pages new returning afterHits afterPages afterNew afterReturning |
	[
		hits := self totalCounter total.
		pages := self pagesCounter total.
		new :=	self newVisitorsCounter total.
		returning := self returningVisitorsCounter total.
		(Delay forSeconds: self secondsToMinute) wait.
		[self isServing] whileTrue: 
			[afterHits := self totalCounter total.
			afterPages := self pagesCounter total.
			afterNew := self newVisitorsCounter total.
			afterReturning := self returningVisitorsCounter total.
			Transcript cr; show: 
				self name, ' ', 
				Time now hours printString, ':', Time now minutes printString, ' ',
				'    last minute hits: ', (afterHits - hits) printDotString, 
				'    pages: ', (afterPages - pages) printDotString, 
				'    visitors new: ', (afterNew - new) printDotString, 
				'    returning: ', (afterReturning - returning) printDotString.
			self registerTopMinuteHits: (afterHits - hits) pages: (afterPages - pages).
			hits := afterHits. pages := afterPages.
			new := afterNew. returning := afterReturning.
			(Delay forSeconds: self secondsToMinute) wait].
	] fork.!

news
	^self userServices at: #WebNews
		ifAbsent: 
			[self addUserService: WebNews new named: #WebNews.
			self urlResolver defaultURL: '/news.html' forObject: self news.
			^self news]!

newVisitorsCounter
	"counter of new sessions"
	(self counters includesKey: #NewVisitors) ifFalse: 
 		["self error: 'newVisitorsCounter ??'."
		self counters at: #NewVisitors put: WebCounter new].
	^self counters at: #NewVisitors

"WebServer default newVisitorsCounter"!

notFoundCounter
	"counter of not found errors"
	(self counters includesKey: #NotFound) ifFalse: 
 		[self counters at: #NotFound put: WebCounter new].
	^self counters at: #NotFound

"WebServer default notFoundCounter"!

objectTo: aRequest  forSession: aSession
	^aRequest isWapRequest
		ifTrue: [self objectToWap: aRequest  forSession: aSession]
		ifFalse: [self objectToWeb: aRequest  forSession: aSession] " ]
			on: Error
			do: [:exception | exception defaultAction]."!

objectToWap: aRequest  forSession: aSession
	| object  |
	object := self urlResolver  ooRefFromURL: aRequest path.
	object notNil 
		ifTrue: 
			[self urlResolver incCounterFor: object.
			self incRequestCounterFor: object]
		ifFalse: 
			[self incNotFoundCounter.
			self log: ' not found: ', aRequest url, ' '.
			^nil ].
	self statistics collectStatsFrom: aRequest.
	^object!

objectToWeb: aRequest  forSession: aSession
	| object  | 
	object := self urlResolver  ooRefFromURL: aRequest uriString.
	aSession shouldCountRequests ifFalse: [^object].    "to skip admin requests etc."
	object notNil 
		ifTrue: 
			[self urlResolver incCounterFor: object.
			self incRequestCounterFor: object]
		ifFalse: 
			[self incNotFoundCounter.
			self log: ' not found: ', aRequest uriString, ' '.
			^nil ].
	self statistics collectStatsFrom: aRequest.
	^object!

pagesCounter
	"counter of only text/html pages"
	(self counters includesKey: #Pages) ifFalse: 
 		["self error: 'pagesCounter ??'."
		self counters 	at: #Pages put: WebCounter new].
	^self counters at: #Pages

"WebServer default pagesCounter"!

printString

	^'anAIDASite named: ', self name!

properString: aString 
	"if two byte string, convert it to one byte, cut twobyte characters, make them $? "

	| stream |
	stream := WriteStream on: String new.
	aString 
		do: [:char | stream nextPut: (char asInteger < 256 ifTrue: [char] ifFalse: [$?])].
	^stream contents!

redirectOn: aSession
	| response |
	response := HTTPResponse redirectLink 
		location: (aSession redirectLink composeURLOn: aSession).
	aSession redirectLink: nil.
	^response.!

redirectToHost
	"if set, all requests are redirected to that hostname!!"
	| host |
	host := self settings  at: #redirectToHost ifAbsent: [^nil].
	(host isNil or: [host isEmpty]) ifTrue: [^nil].
	^host!

redirectToHost: aHostnameString
	"if set, all requests are redirected to that hostname!!"
	self settings  at: #redirectToHost put: aHostnameString!

redirectToOtherHost: aRequest
	| response |
	response := HTTPResponse redirectLink 
		location: (aRequest urlString copyReplaceAll: self host with: self redirectToHost).
	^response.!

registerTopHourHits: aHitNumber pages: aPageNumber
	(self topHour at: 2) < aHitNumber ifTrue: 
		[self topHour
			at: 1 put: Timestamp now;
			at: 2 put: aHitNumber;
			at: 3 put: aPageNumber].!

registerTopMinuteHits: aHitNumber pages: aPageNumber
	(self topMinute at: 2) < aHitNumber ifTrue: 
		[self topMinute
			at: 1 put: Timestamp now;
			at: 2 put: aHitNumber;
			at: 3 put: aPageNumber].!

requestsInYear: aYearNumber
	"return a number of requests on specified year"

	| count |
	count := 0.
	((self counters at: #Daily) at: aYearNumber ifAbsent: [^0]) do: [:dayCount |
		count := count + dayCount].
	^count!

requestsOnDate: aDate
	"return a number of requests on specified date"

	^self totalCounter countsOnDate: aDate!

restart
	self stop.
	self start.!

returningVisitorsCounter
	"counter of returning sessions"
	(self counters includesKey: #ReturningVisitors) ifFalse: 
 		["self error: 'returningVisitorsCounter ??'."
		self counters
			at: #ReturningVisitors put: WebCounter new].
	^self counters at: #ReturningVisitors

"WebServer default returningVisitorsCounter"!

runningHistory
	"return a collection of server runs as array of:
		started timestamp,
		last alive = stopped (more or less) timestamp,
		uptime in seconds,
		downtime from previous run in seconds,
		crashed or not.
	Used to determine history 
	of server runnings and to calculate server avaiability. Last entry in collection is current run
	with last alive no more than minute before current time"
	"AIDASite default runningHistory"
	| collection newArray  arry |
	collection := OrderedCollection new.
	self runningHistoryCollection do: [:array |
		newArray := Array new: 5.
		newArray 
			at: 1 put: (Timestamp fromSeconds: (array at: 1));
			at: 2 put: (Timestamp fromSeconds: (array at: 2));
			at: 3 put: (((array at: 2) - (array at: 1)) max: 0);
			at: 4 put: 0;  "we will calculate later"
			at: 5 put: ((array size < 3) ifTrue: [true] ifFalse: [array at:3]).
		collection add: newArray copy].
	newArray := Array new: 5.
	newArray
		at: 1 put: self startedTimestamp;
		at: 2 put: self lastTimeAliveTimestamp;
		at: 3 put: (self lastTimeAliveTimestamp asSeconds - 
			self startedTimestamp asSeconds);
		at: 4 put: 0;  "we will calculate later"
		at: 5 put: false. "current run not crashed"
	collection add: newArray copy.
	2 to: collection size do: [:inx |
		arry := collection at: inx.
		arry at: 4 put:   "this started - previous last alived"
			((arry at: 1) asSeconds - ((collection at: inx-1) at: 2) asSeconds)
		].
	^collection!

runningHistoryCollection
	^self timestamps at: #RunningHistory ifAbsentPut: [OrderedCollection new].!

scheduler
	^self systemServices 
		at: #Scheduler
		ifAbsent: 
			[self 
				addSystemService: (Scheduler newOn: self) 
				named: #Scheduler.
			^self scheduler].!

secondsToHour

	| now | 
	now := Time now asSeconds.
	^(3600 - (now - (now // 3600 * 3600))) max: 0

"WebServer default secondsToHour"!

secondsToMinute

	| now | 
	now := Time now asSeconds.
	^(60 - (now - (now // 60 * 60))) max: 0

"WebServer default secondsToMinute"!

securityManager
	^self systemServices 
		at: #SecurityManager
		ifAbsent: 
			[self 
				addSystemService: (WebSecurityManager newOn: self)
				named: #SecurityManager.
			self urlResolver defaultURL: '/security.html' forObject: self securityManager.
			^self securityManager].!

sessionManager
	^self systemServices 
		at: #SessionManager
		ifAbsent: 
			[self 
				addSystemService: (WebSessionManager newOn: self)
				named: #SessionManager.
			^self sessionManager].!

setCreatedTimestamp
	"set the server creation timestamp to current date and time."
	self timestamps 
		at: #Created put: Timestamp now asSeconds.!

setLastCommitTimestamp
	"set the last commit timestamp to current date and time"
	self critical: [
		self timestamps 
			at: #LastCommit 
			put: Timestamp now asSeconds].!

setLastRequestTimestamp
	"set the last web request timestamp to current date and time"
	self critical: [
		self timestamps at: #LastRequest put: Timestamp now asSeconds].!

setLastTimeAliveTimestamp
	"A lastTimeAliveThread sets this timestamp every minute"
	self critical: [
		self timestamps at: #LastTimeAlive put: Timestamp now asSeconds].!

setStartedTimestampCrashed: aBoolean
	"set the last server startup timestamp to current date and time.  
	Before that records old created and last alive timestamp to a running history.
	Argument shows if server was running, therefore crashed, or was stoped normaly"
	self addToRunningHistoryCrashed: aBoolean.
	self timestamps 
		at: #Started put: Timestamp now asSeconds.!

settings
	settings isNil ifTrue: 
		[settings := Dictionary new. 
		self initializeDefaultSettings].
	^settings

"WebServer default settings"!

settingsReport
	"a brief report of current settings to transcript, used at site startup"
	Transcript cr; show: 'server diagnostics: '.
	self diagnostics
		ifTrue: [Transcript show: 'ON']
		ifFalse: [Transcript show: 'OFF'].
	Transcript cr.!

shouldRedirect
	^self redirectToHost notNil!

smtpServer

	"an address of email server for outgoing mails (notifications, mailing lists etc.)"

	^self settings  at: #smtpServer ifAbsentPut: [self address].

"WebServer default smtpServer"!

smtpServer: anAddressString
	"an address of email server for outgoing mails (notifications, mailing lists etc.)"
	self settings  at: #smtpServer put: anAddressString.!

start
	self setStartedTimestampCrashed: self isServing.
	self setLastTimeAliveTimestamp.
	super start.
	self startServices.!

startedTimestamp
	"time and date of last server startup"
	^Timestamp fromSeconds:
		(self timestamps at: #Started ifAbsentPut: [Timestamp now asSeconds])!

startServices
	self systemServices values do: [:service | (service class canUnderstand: #start) ifTrue: [service start] ].
	self userServices values do: [:service | (service class canUnderstand: #start) ifTrue: [service start] ].!

statistics
	^self systemServices 
		at: #Statistics
		ifAbsent: 
			[self 
				addSystemService: (WebStatistics newOn: self)
				named: #Statistics.
			self urlResolver defaultURL: '/stat.html' forObject: self statistics.
			^self statistics].!

stop
	super stop.
	self stopServices.
	self setLastTimeAliveTimestamp.!

stopServices
	self systemServices values do: [:service | (service class canUnderstand: #stop) ifTrue: [service stop] ].
	self userServices values do: [:service | (service class canUnderstand: #stop) ifTrue: [service stop] ].!

stopWatchdog
	self watchdog notNil ifTrue: 
		[self watchdog terminate.
		self watchdog: nil].!

style
	style isNil ifTrue: [self style: ((Smalltalk at: self styleClass) newOnSite: self)].
	^style

!

style: aWebStyle
	style := aWebStyle.!

styleClass
	(self settings includesKey: #styleClass) ifFalse: 
		[self styleClass: 'WebStyle' ].
	^(self settings  at: #styleClass) asString!

styleClass: aString
	"name of a class to provide a style support for this site. Default is WebStyle"
	self settings  at: #styleClass put: aString.!

systemServiceNamed: aSymbol

	"return a system service object with a specified name"

	^self systemServices at: aSymbol asSymbol ifAbsent: [^nil]!

systemServices
	"return a dictionary of system services (e.g. URLResolver, ImageManager etc.)"
	systemServices isNil 
		ifTrue: [systemServices := Dictionary new].
	^systemServices!

timestamps
	timestamps isNil ifTrue: [self initTimestamps].
	^timestamps!

topHour
	"a hour of most hits, an array with timestamp, hits and pages"
	(self counters includesKey: #TopHour) ifFalse: 
 		[self counters at: #TopHour put: (Array with: Timestamp now with: 0 with: 0)].
	^self counters at: #TopHour

"WebServer default topHour"!

topMinute
	"a minute of most hits, an array with timestamp, hits and pages"
	(self counters includesKey: #TopMinute) ifFalse: 
 		[self counters at: #TopMinute put:  (Array with: Timestamp now with: 0 with: 0)].
	^self counters at: #TopMinute

"WebServer default topMinute"!

totalCounter
	"counter of all web requests"
	(self counters includesKey: #Total) ifFalse: 
 		["self error: 'totalCounter ??'."
		self counters at: #Total put: WebCounter new].
	^self counters at: #Total

"WebServer default totalCounter"!

totalDowntime
	"return downtime between all server runs in seconds"
	"AIDASite default totalDowntime"
	| history downtime |
	history := self runningHistory.
	downtime := 0.
	history do: [:array | downtime := downtime + (array at: 4)].
	^downtime!

totalRequests
	"return a number of requests from server creation"

	^self totalCounter total.!

totalUptime
	"return uptime of all server runs in seconds"
	"AIDASite default totalUptime"
	| history uptime |
	history := self runningHistory.
	uptime := 0.
	history do: [:array | uptime := uptime + (array at: 3)].
	^uptime!

uptime
	"return uptime of current server run in seconds (with 60s precision)"
	"AIDASite default uptime"
	^self lastTimeAliveTimestamp asSeconds - self startedTimestamp asSeconds!

urgentNotificationEMail

	"an email address or addresses (separated by comma) of all recipients of urgent server notifications "

	^self settings  at: #urgentNotificationEMail ifAbsentPut: ['janko.mivsek@eranova.si'].!

urgentNotificationEMail: anEMailAddressString
	"an email address or addresses (separated by comma) of all recipients of urgent server notifications "
	self settings  at: #urgentNotificationEMail put: anEMailAddressString.!

urlResolver
	^self systemServices 
		at: #URLResolver
		ifAbsent: 
			[self 
				addSystemService: (URLResolver newOn: self) 
				named: #URLResolver.
			^self urlResolver].!

userServiceNamed: aSymbol

	"return a user service object with a specified name"

	^self userServices at: aSymbol asSymbol ifAbsent: [^nil]!

userServices
	"return a dictionary of user services (e.g. WebIndex, WebNews etc.)"
	userServices isNil ifTrue: [userServices := Dictionary new. ].
	^userServices!

watchdogOther
	"override this if you like some other periodic activity"!

webMsgs
	^self systemServices 
		at: #WebMsgs
		ifAbsent: 
			[self addSystemService: (WebMsgs new)	named: #WebMsgs.
			^self webMsgs].!

webServerEMail

	"an email address of this web server "

	^self settings  at: #webServerEMail ifAbsentPut: ['aida-web@eranova.si'].!

webServerEMail: anEMailString
	"an email address of this web server "
	self settings  at: #webServerEMail put: anEMailString.! !
!AIDASite categoriesFor: #addAllowHeaderTo:!private!private-serving! !
!AIDASite categoriesFor: #addDontCacheHeaderTo:forPage:!private!private-serving! !
!AIDASite categoriesFor: #addExpiresHeaderTo:forPage:!private!private-serving! !
!AIDASite categoriesFor: #addModifiedHeaderTo:forPage:!private!private-serving! !
!AIDASite categoriesFor: #addResponseHeadersTo:forPage:!private!private-serving! !
!AIDASite categoriesFor: #addressTextFor:!private!private-serving! !
!AIDASite categoriesFor: #addSystemService:named:!private!system services! !
!AIDASite categoriesFor: #addToRunningHistoryCrashed:!private! !
!AIDASite categoriesFor: #addUserService:named:!private!user services! !
!AIDASite categoriesFor: #admin!private!system services! !
!AIDASite categoriesFor: #afterLogin!accessing-settings!private! !
!AIDASite categoriesFor: #afterLogin:!accessing-settings!private! !
!AIDASite categoriesFor: #answer:to:on:!private!serving! !
!AIDASite categoriesFor: #answer:toGetOrPost:on:!private!serving! !
!AIDASite categoriesFor: #answer:toLock:on:!private!serving! !
!AIDASite categoriesFor: #answer:toOptions:on:!private!serving! !
!AIDASite categoriesFor: #answer:toPropFind:on:!private!serving! !
!AIDASite categoriesFor: #answer:toPut:on:!private!serving! !
!AIDASite categoriesFor: #answer:toUnlock:on:!private!serving! !
!AIDASite categoriesFor: #answerTo:!private!serving! !
!AIDASite categoriesFor: #authenticationScheme!private! !
!AIDASite categoriesFor: #availability!private!statistics! !
!AIDASite categoriesFor: #backupToFile!private!private-backup/restore! !
!AIDASite categoriesFor: #cookieHeaderFor:!private!private-serving! !
!AIDASite categoriesFor: #cookieName!private!private-serving! !
!AIDASite categoriesFor: #counters!private!private - counters! !
!AIDASite categoriesFor: #countingPolicy!accessing-settings!private! !
!AIDASite categoriesFor: #countingPolicy:!accessing-settings!private! !
!AIDASite categoriesFor: #cr!private! !
!AIDASite categoriesFor: #createdTimestamp!private!statistics! !
!AIDASite categoriesFor: #critical:!accessing!private! !
!AIDASite categoriesFor: #defaultUserService!private!user services! !
!AIDASite categoriesFor: #demo!private!user services! !
!AIDASite categoriesFor: #diagnostics!accessing-settings!private! !
!AIDASite categoriesFor: #diagnostics:!accessing-settings!private! !
!AIDASite categoriesFor: #disableWebDAVSupport!accessing-settings!private! !
!AIDASite categoriesFor: #discussions!private!user services! !
!AIDASite categoriesFor: #enableWebDAVSupport!accessing-settings!private! !
!AIDASite categoriesFor: #help!private!system services! !
!AIDASite categoriesFor: #helpDirectory!accessing-settings!private! !
!AIDASite categoriesFor: #helpDirectory:!accessing-settings!private! !
!AIDASite categoriesFor: #helpURL!accessing-settings!private! !
!AIDASite categoriesFor: #helpURL:!accessing-settings!private! !
!AIDASite categoriesFor: #homeDirectory!accessing-settings!private! !
!AIDASite categoriesFor: #homeDirectory:!accessing-settings!private! !
!AIDASite categoriesFor: #hourlyStatsProcess!private!statistics - counters! !
!AIDASite categoriesFor: #httpResponseOnException:!private!private-serving! !
!AIDASite categoriesFor: #incNotFoundCounter!private!private - counters! !
!AIDASite categoriesFor: #incRequestCounterFor:!private!private - counters! !
!AIDASite categoriesFor: #index!private!user services! !
!AIDASite categoriesFor: #initCounters!private!private - counters! !
!AIDASite categoriesFor: #initFavicon!initialize-release!private! !
!AIDASite categoriesFor: #initialize!initialize-release!private! !
!AIDASite categoriesFor: #initializeDefaultSettings!accessing-settings!private! !
!AIDASite categoriesFor: #initTimestamps!initialize-release!private! !
!AIDASite categoriesFor: #initUrlsForSystemServices!private!system services! !
!AIDASite categoriesFor: #isWebDAVEnabled!accessing-settings!private! !
!AIDASite categoriesFor: #lastCommitTimestamp!private!statistics! !
!AIDASite categoriesFor: #lastRequestTimestamp!private!statistics! !
!AIDASite categoriesFor: #lastTimeAliveTimestamp!private!statistics! !
!AIDASite categoriesFor: #log:!printing!private! !
!AIDASite categoriesFor: #logging!accessing-settings!private! !
!AIDASite categoriesFor: #loggingPolicy!accessing-settings!private! !
!AIDASite categoriesFor: #loggingPolicy:!accessing-settings!private! !
!AIDASite categoriesFor: #logStringFor:!private!private-serving! !
!AIDASite categoriesFor: #mimeMap!private!system services! !
!AIDASite categoriesFor: #minuteStatsProcess!private!statistics - counters! !
!AIDASite categoriesFor: #news!private!user services! !
!AIDASite categoriesFor: #newVisitorsCounter!private!private - counters! !
!AIDASite categoriesFor: #notFoundCounter!private!private - counters! !
!AIDASite categoriesFor: #objectTo:forSession:!private!private-serving! !
!AIDASite categoriesFor: #objectToWap:forSession:!private!private-serving! !
!AIDASite categoriesFor: #objectToWeb:forSession:!private!private-serving! !
!AIDASite categoriesFor: #pagesCounter!private!private - counters! !
!AIDASite categoriesFor: #printString!printing!private! !
!AIDASite categoriesFor: #properString:!private! !
!AIDASite categoriesFor: #redirectOn:!private!private-serving! !
!AIDASite categoriesFor: #redirectToHost!accessing-settings!private! !
!AIDASite categoriesFor: #redirectToHost:!accessing-settings!private! !
!AIDASite categoriesFor: #redirectToOtherHost:!private!private-serving! !
!AIDASite categoriesFor: #registerTopHourHits:pages:!private!statistics - counters! !
!AIDASite categoriesFor: #registerTopMinuteHits:pages:!private!statistics - counters! !
!AIDASite categoriesFor: #requestsInYear:!private!statistics - counters! !
!AIDASite categoriesFor: #requestsOnDate:!private!statistics - counters! !
!AIDASite categoriesFor: #restart!private!start/stop! !
!AIDASite categoriesFor: #returningVisitorsCounter!private!private - counters! !
!AIDASite categoriesFor: #runningHistory!private!statistics! !
!AIDASite categoriesFor: #runningHistoryCollection!private! !
!AIDASite categoriesFor: #scheduler!private!system services! !
!AIDASite categoriesFor: #secondsToHour!private!statistics - counters! !
!AIDASite categoriesFor: #secondsToMinute!private!statistics - counters! !
!AIDASite categoriesFor: #securityManager!private!system services! !
!AIDASite categoriesFor: #sessionManager!private!system services! !
!AIDASite categoriesFor: #setCreatedTimestamp!private! !
!AIDASite categoriesFor: #setLastCommitTimestamp!private! !
!AIDASite categoriesFor: #setLastRequestTimestamp!private! !
!AIDASite categoriesFor: #setLastTimeAliveTimestamp!private! !
!AIDASite categoriesFor: #setStartedTimestampCrashed:!private! !
!AIDASite categoriesFor: #settings!private! !
!AIDASite categoriesFor: #settingsReport!accessing-settings!private! !
!AIDASite categoriesFor: #shouldRedirect!private!private-serving! !
!AIDASite categoriesFor: #smtpServer!accessing-settings!private! !
!AIDASite categoriesFor: #smtpServer:!accessing-settings!private! !
!AIDASite categoriesFor: #start!private!start/stop! !
!AIDASite categoriesFor: #startedTimestamp!private!statistics! !
!AIDASite categoriesFor: #startServices!private! !
!AIDASite categoriesFor: #statistics!private!system services! !
!AIDASite categoriesFor: #stop!private!start/stop! !
!AIDASite categoriesFor: #stopServices!private! !
!AIDASite categoriesFor: #stopWatchdog!private! !
!AIDASite categoriesFor: #style!accessing!private! !
!AIDASite categoriesFor: #style:!private! !
!AIDASite categoriesFor: #styleClass!accessing-settings!private! !
!AIDASite categoriesFor: #styleClass:!accessing-settings!private! !
!AIDASite categoriesFor: #systemServiceNamed:!private!system services! !
!AIDASite categoriesFor: #systemServices!private! !
!AIDASite categoriesFor: #timestamps!private! !
!AIDASite categoriesFor: #topHour!private!private - counters! !
!AIDASite categoriesFor: #topMinute!private!private - counters! !
!AIDASite categoriesFor: #totalCounter!private!private - counters! !
!AIDASite categoriesFor: #totalDowntime!private!statistics! !
!AIDASite categoriesFor: #totalRequests!private!statistics - counters! !
!AIDASite categoriesFor: #totalUptime!private!statistics! !
!AIDASite categoriesFor: #uptime!private!statistics! !
!AIDASite categoriesFor: #urgentNotificationEMail!accessing-settings!private! !
!AIDASite categoriesFor: #urgentNotificationEMail:!accessing-settings!private! !
!AIDASite categoriesFor: #urlResolver!private!system services! !
!AIDASite categoriesFor: #userServiceNamed:!private!user services! !
!AIDASite categoriesFor: #userServices!private! !
!AIDASite categoriesFor: #watchdogOther!private! !
!AIDASite categoriesFor: #webMsgs!private!system services! !
!AIDASite categoriesFor: #webServerEMail!accessing-settings!private! !
!AIDASite categoriesFor: #webServerEMail:!accessing-settings!private! !

!AIDASite class methodsFor!

charc
	"return internal  unicode code for slovene character: lowercase c"
	^16r010D asCharacter!

charC
	"return internal  unicode code for slovene character: uppercase c"
	^16r010C asCharacter!

charCszSet
	^Set new
		add: self charc; add: self charC;
		add: self chars; add: self charS;
		add: self charz; add: self charZ;
		yourself!

chars
	"return internal  unicode code for slovene character: lowercase s"
	^16r0161 asCharacter!

charS
	"return internal  unicode code for slovene character: uppercase s"
	^16r0160 asCharacter!

charz
	"return internal unicode code for slovene character: lowercase z"
	^16r017E asCharacter!

charZ
	"return internal unicode code for slovene character: uppercase z"
	^16r017D asCharacter!

convert: aString fromCodepage: aSymbol
	"convert aString to internal unicode"
	^aString
"
	| encoding |
	(#(#'win-1250' #'win1250' #'Windows-1250' cp1250) includes: aSymbol) 
		ifTrue: [encoding := #'Windows-1250'].
	(#(#'iso-8859-2' #'iso8859-2' #'ISO-8859-2' iso2) includes: aSymbol) 
		ifTrue: [encoding := #'ISO-8859-2'].
	(#(#utf8 #'utf-8' #'utf_8' #UTF8 #'UTF-8' #'UTF_8') includes: aSymbol) ifTrue: [encoding := #'UTF_8'].
	encoding isNil ifTrue: [^aString].
	^(EncodedStream 
		on: aString asIntegerArray readStream 
		encodedBy: (StreamEncoder new: encoding)) contents
"
"AIDASite convert: (String with: 16rE8 asCharacter) fromCodepage: #'iso-8859-2' "
"AIDASite convert: (String with: 16rC4 asCharacter with: 16r8D asCharacter) fromCodepage: #utf8 "!

convert: aString toCodepage: aSymbol
	"convert internal unicode aString to codepage). "
	| encoding |
	(self inOldEncoding: aString) ifTrue: [^self oldconvert: aString toCodepage: aSymbol].
	(#(#'win-1250' #'win1250' #'Windows-1250' cp1250) includes: aSymbol) 
		ifTrue: [encoding := #'Windows-1250'].
	(#(#'iso-8859-2' #'iso8859-2' #'ISO-8859-2' iso2) includes: aSymbol) 
		ifTrue: [encoding := #'ISO-8859-2'].
	(#(#utf8 #'utf-8' #'utf_8' #UTF8 #'UTF-8' #'UTF_8') includes: aSymbol) ifTrue: [encoding := #'UTF_8'].
	encoding isNil ifTrue: [^aString].
	^([aString asByteArrayEncoding: encoding] on: Error do: [:ex | ^aString]) asByteString

"AIDASite convert: (String with: 16r010D asCharacter) toCodepage: #iso2 "
"AIDASite convert: (String with: 16r010D asCharacter) toCodepage: #utf8 "!

convertFromWeb: aString on: aSession
	"convert aString, which is in code page, defined in aSession to an internal unicode "
	^self convert: aString fromCodepage: aSession codePage!

convertFromWebString: aString
	"converts special chars in http stream: 
		'+' as ' '
		%xx as appropriate ASCII char
	"
	| newString |
	newString := aString copyReplaceAll: '+' with: ' '.
	newString := self convertNextWebSpecialChar: newString fromPos: 1.
	newString := AIDASite convert:newString fromCodepage: #'utf-8'.
	^newString!

convertNextWebSpecialChar: aString fromPos: aNumber 
	"find first http special char in format %xx and converts all occurences in an appropriate
	 ASCII char. Recursivelly repeat until all chars converted"
	| index code chr newString |
	index := aString findString: '%' startingAt: aNumber ifAbsent: [^aString].
	(index + 2) <= aString size ifFalse: [^aString].
	code := aString copyFrom: index to: index+2.
	((self fromHexValue: (code at:2)) notNil & (self fromHexValue: (code at:3)) notNil) 
		ifTrue:[chr := ( (self fromHexValue: (aString at: index+1))  * 16 + 
				(self fromHexValue: (aString at: index+2)) ) asCharacter .
				chr = 18 asCharacter ifTrue: [chr := AIDASite charc].
			newString := aString copyReplaceAll: code with: chr asSymbol asString]
		ifFalse: [newString := aString].
	^self convertNextWebSpecialChar: newString fromPos: index+1.!

convertToWeb: aString on: aSession
	"rconver internal unicode aString to a proper code page, defined in aSession"
	^self convert: aString toCodepage: aSession codePage!

convertToWebString: aString
	"converts some special chars in http stream: 
		' ' as '+'
		%xx as appropriate ASCII char
	"
	^self convertToWebStringAbstract: aString space:$+  prefix:$%.!

convertToWebStringAbstract: aString space: aSpace prefix: aPrefix
	"converts some special chars in CGI stream: 
		' ' as '+'
		%xx as appropriate ASCII char
	"
	| newString specialChars ISOString |
	newString := String new.
	specialChars := Dictionary new.
	ISOString := AIDASite convert: aString toCodepage: #iso2.
	specialChars at: $  put: (String with:aSpace).
	ISOString do: [:each | 
		(each isAlphaNumeric & (each ~= aPrefix) )
			ifTrue: [newString := newString, each asSymbol asString] 
			ifFalse: 
				[(specialChars includesKey: each )
					ifTrue:  [newString := 
						newString, (specialChars at: each)]
					ifFalse: 
						[newString := newString, (String with: aPrefix),
							(self hexCharFrom: 	(each asInteger // 16)) 
								asSymbol asString,
							(self hexCharFrom: (each asInteger \\ 16)) 
								asSymbol asString]
			]
		].
	^newString!

default
	"make a site with that name a default one"
	| sites |
	Default isNil ifTrue:
		[sites := SwazooServer singleton allSites.
		sites isEmpty ifTrue: [^self error: 'no default site'].
		Default := sites first].
	^Default!

default: aString
	"make a site with that name a default one"
	| site |
	site := SwazooServer singleton siteNamed: aString.
	site isNil ifTrue: [^self error: 'site with that name does not exist!!'].
	Default := site.
	^site!

fromHexValue: aCharacter
	aCharacter isDigit 
		ifTrue: [^aCharacter asInteger - $0 asInteger]
		ifFalse: [
			(aCharacter asLowercase between: $a and: $f)
				ifTrue: [^aCharacter asLowercase asInteger - $a asInteger+10]
				ifFalse: [^nil]].!

hexCharFrom: aNumber
	^aNumber < 10 
		ifTrue: [($0 asInteger + aNumber) asCharacter]
		ifFalse: [($A asInteger + aNumber - 10) asCharacter]!

initialize
!

initSloveneCharacters
	"AIDASite initSloveneCharacters"
	SloveneCharacters := Set new: 6.
	^SloveneCharacters 
		add: self charC;
		add: self charc;
		add: self charS;
		add: self chars;
		add: self charZ;
		add: self charz;
		yourself!

inOldEncoding: aString
	^aString contains: [:ch | #(61346 61552 252 9839 235 227) includes: ch asInteger].!

isSloveneCharacter: aCharacter
	"return true if character is slovene"
	SloveneCharacters isNil ifTrue: [self initSloveneCharacters].
	^SloveneCharacters includes: aCharacter

"AIDASite isSloveneCharacter: AIDASite charC"!

named: aString
	^SwazooServer singleton siteNamed: aString!

newNamed: aString
	| site |
	site := self new name: aString.
	SwazooServer singleton addSite: site.
	site initialize.
	^site!

oldconvert: aString fromCodepage: aSymbol

	"convert aString, which is in defined code page, defined in aSession to an internal 
	Smalltalk codepage (Unicode in future). "

	(aString isKindOf: String) ifTrue:
		[aSymbol = #cp1250 ifTrue: [^self returnCP852FromCP1250String: aString].
		aSymbol = #iso2 ifTrue: [^self returnCP852FromISO2String: aString].
		aSymbol = #csz   ifTrue: [^aString].  "you cannot convert!!"
		aSymbol = #'7bit' ifTrue: [^self returnCP852From7BitString: aString]. 
		^aString].
	^aString.  "if not String, then return whatever is"!

oldconvert: aString toCodepage: aSymbol

	"return aString in a proper code page"

	aSymbol = #cp1250 ifTrue: [^self returnCP1250FromCP852String: aString].
	aSymbol = #csz   ifTrue: [^self returnCSZFromCP852String: aString].
	aSymbol = #'7bit' ifTrue: [^self return7BitFromCP852String: aString].
	aSymbol = #iso2 ifTrue: [^self returnISO2FromCP852String: aString].
	^aString!

return7BitFromCP852String: aString


	^aString collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch asInteger = 61346 ifTrue: [$~]
					ifFalse: [ ch asInteger = 61552 ifTrue: [$^]
					ifFalse: [ ch asInteger = 252 ifTrue: [${]
					ifFalse: [ ch asInteger = 9839 ifTrue: [$[]
					ifFalse: [ ch asInteger = 235 ifTrue: [$`] 
					ifFalse: [ ch asInteger = 227 ifTrue: [$@]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		].

"WebServer returnCZSFromCP852String: 'Miv'"!

returnCP1250FromCP852String: aString


	^(aString asWordArray collect: 
		[:ch | ch > 127 
			ifTrue:
				[ch  = 61346 ifTrue: [232 ]
					ifFalse: [ ch  = 61552 ifTrue: [200 ]
					ifFalse: [ ch  = 252 ifTrue: [154 ]
					ifFalse: [ ch  = 9839 ifTrue: [138 ]
					ifFalse: [ ch  = 235 ifTrue: [158 ]
					ifFalse: [ ch  = 227 ifTrue: [142 ]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		]) asString.

"WebServer returnCZSFromCP852String: 'Miv'"!

returnCP852From7BitString: aString


	^(aString asWordArray collect: 
		[:ch | 
			ch  = $~ asInteger ifTrue: [61346 ]
				ifFalse: [ ch  =   $^ asInteger 	ifTrue: [61552 ]
				ifFalse: [ ch  = ${ asInteger 	ifTrue: [252 ]
				ifFalse: [ ch  =   $[ asInteger 	ifTrue: [9839 ]
				ifFalse: [ ch  =   $` asInteger 	ifTrue: [235 ]
				ifFalse: [ ch  =    $@ asInteger	ifTrue: [227 ]
				ifFalse: [ch]]]]]]
		]) asString.

"WebServer returnCP852From7BitString: 'Miv{ek'"!

returnCP852FromCP1250String: aString


	^(aString asWordArray collect: 
		[:ch | ch > 127 
			ifTrue:
				[ch  = 232 ifTrue: [61346 ]
					ifFalse: [ ch  = 200 ifTrue: [61552 ]
					ifFalse: [ ch  = 154 ifTrue: [252 ]
					ifFalse: [ ch  = 138 ifTrue: [9839 ]
					ifFalse: [ ch  = 158 ifTrue: [235 ]
					ifFalse: [ ch  = 142 ifTrue: [227 ]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		]) asString.

"WebServer returnCP852FromCP1250String: 'Miv'"!

returnCP852FromISO2String: aString


	^(aString asWordArray collect: 
		[:ch | ch  > 127 
			ifTrue:
				[ch  = 232 ifTrue: [61346 ]
					ifFalse: [ ch  = 200 ifTrue: [61552 ]
					ifFalse: [ ch  = 185 ifTrue: [252 ]
					ifFalse: [ ch  = 169 ifTrue: [9839 ]
					ifFalse: [ ch  = 190 ifTrue: [235 ]
					ifFalse: [ ch  = 174 ifTrue: [227 ]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		]) asString.

"WebServer returnCP852FromISO2String: 'Mivsek'"!

returnCSZFromCP852String: aString


	^aString collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch asInteger = 61346 ifTrue: [$c]
					ifFalse: [ ch asInteger = 61552 ifTrue: [$C]
					ifFalse: [ ch asInteger = 252 ifTrue: [$s]
					ifFalse: [ ch asInteger = 9839 ifTrue: [$S]
					ifFalse: [ ch asInteger = 235 ifTrue: [$z]
					ifFalse: [ ch asInteger = 227 ifTrue: [$Z]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		].

"WebServer returnCZSFromCP852String: 'Miv'"!

returnCZSFromCP852String: aString


	^aString collect: 
		[:ch | ch asInteger > 127 
			ifTrue:
				[ch asInteger = 61346 ifTrue: [$c]
					ifFalse: [ ch asInteger = 61552 ifTrue: [$C]
					ifFalse: [ ch asInteger = 252 ifTrue: [$s]
					ifFalse: [ ch asInteger = 9839 ifTrue: [$S]
					ifFalse: [ ch asInteger = 235 ifTrue: [$z]
					ifFalse: [ ch asInteger = 227 ifTrue: [$Z]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		].

"WebServer returnCZSFromCP852String: 'Miv'"!

returnISO2FromCP852String: aString


	^(aString asWordArray collect: 
		[:ch | ch  > 127 
			ifTrue:
				[ch  = 61346 ifTrue: [232 ]
					ifFalse: [ ch  = 61552 ifTrue: [200 ]
					ifFalse: [ ch  = 252 ifTrue: [185 ]
					ifFalse: [ ch  = 9839 ifTrue: [169 ]
					ifFalse: [ ch  = 235 ifTrue: [190 ]
					ifFalse: [ ch  = 227 ifTrue: [174 ]
					ifFalse: [ch]]]]]]
				]
			ifFalse: [ch]
		]) asString.

"WebServer returnCZSFromCP852String: 'Miv'"!

slash
	"return '/'  on Unix, '\' on PC platforms, for making full filenames"
	^'\'!

slashCh
	"return '/'  on Unix, '\' on PC platforms, for making full filenames"
	^'\'!

sloveneLowercase: aString
	^aString collect: [:chr | 
		(AIDASite isSloveneCharacter: chr)
			ifTrue: 	[(chr = AIDASite charC) ifTrue: [AIDASite charc]
				ifFalse: [(chr = AIDASite charS) ifTrue: [AIDASite chars]
					ifFalse: [(chr = AIDASite charZ) ifTrue: [AIDASite charz]
						ifFalse: [chr] ]]]
			ifFalse: [chr asLowercase]
		].!

sloveneUppercase: aString
	^aString collect: [:chr | 
		(AIDASite isSloveneCharacter: chr)
			ifTrue: 	[(chr = AIDASite charc) ifTrue: [AIDASite charC]
				ifFalse: [(chr = AIDASite chars) ifTrue: [AIDASite charS]
					ifFalse: [(chr = AIDASite charz) ifTrue: [AIDASite charZ]
						ifFalse: [chr] ]]]
			ifFalse: [chr asUppercase]
		].! !
!AIDASite class categoriesFor: #charc!private!slovene characters! !
!AIDASite class categoriesFor: #charC!private!slovene characters! !
!AIDASite class categoriesFor: #charCszSet!private!slovene characters! !
!AIDASite class categoriesFor: #chars!private!slovene characters! !
!AIDASite class categoriesFor: #charS!private!slovene characters! !
!AIDASite class categoriesFor: #charz!private!slovene characters! !
!AIDASite class categoriesFor: #charZ!private!slovene characters! !
!AIDASite class categoriesFor: #convert:fromCodepage:!codepage converting!private! !
!AIDASite class categoriesFor: #convert:toCodepage:!codepage converting!private! !
!AIDASite class categoriesFor: #convertFromWeb:on:!codepage converting!private! !
!AIDASite class categoriesFor: #convertFromWebString:!private!web converting! !
!AIDASite class categoriesFor: #convertNextWebSpecialChar:fromPos:!private!web converting! !
!AIDASite class categoriesFor: #convertToWeb:on:!codepage converting!private! !
!AIDASite class categoriesFor: #convertToWebString:!private!web converting! !
!AIDASite class categoriesFor: #convertToWebStringAbstract:space:prefix:!private!web converting! !
!AIDASite class categoriesFor: #default!accessing!private! !
!AIDASite class categoriesFor: #default:!accessing!private! !
!AIDASite class categoriesFor: #fromHexValue:!private!web converting! !
!AIDASite class categoriesFor: #hexCharFrom:!private!web converting! !
!AIDASite class categoriesFor: #initialize!initialize!private! !
!AIDASite class categoriesFor: #initSloveneCharacters!private!slovene characters! !
!AIDASite class categoriesFor: #inOldEncoding:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #isSloveneCharacter:!private!slovene characters! !
!AIDASite class categoriesFor: #named:!accessing!private! !
!AIDASite class categoriesFor: #newNamed:!instance creation!private! !
!AIDASite class categoriesFor: #oldconvert:fromCodepage:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #oldconvert:toCodepage:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #return7BitFromCP852String:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #returnCP1250FromCP852String:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #returnCP852From7BitString:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #returnCP852FromCP1250String:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #returnCP852FromISO2String:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #returnCSZFromCP852String:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #returnCZSFromCP852String:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #returnISO2FromCP852String:!codepages-obsolete!private! !
!AIDASite class categoriesFor: #slash!private!utilities! !
!AIDASite class categoriesFor: #slashCh!private!utilities! !
!AIDASite class categoriesFor: #sloveneLowercase:!private!slovene characters! !
!AIDASite class categoriesFor: #sloveneUppercase:!private!slovene characters! !

WebComment guid: (GUID fromString: '{FAB883D5-94DF-4423-988A-7EF245761BFD}')!
WebComment comment: ''!
!WebComment categoriesForClass!Unclassified! !
!WebComment methodsFor!

initialize
	text := ''.!

printHTMLPageOn: aStream forSession: aSession
	aStream nextPutAll: self ident, '<!!-- '.
	aStream nextPutAll: self text.
	aStream nextPutAll: ' -->', self eol.!

shouldIdent
	^false!

text
	^text!

text: aString
	text := aString.! !
!WebComment categoriesFor: #initialize!initialize-release!private! !
!WebComment categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebComment categoriesFor: #shouldIdent!private! !
!WebComment categoriesFor: #text!accessing!private! !
!WebComment categoriesFor: #text:!accessing!private! !

!WebComment class methodsFor!

new
	^super new initialize!

text: aString
	^self new text: aString

"WebText text: 'test'"! !
!WebComment class categoriesFor: #new!instance creation!private! !
!WebComment class categoriesFor: #text:!instance creation!private! !

WebFieldSet guid: (GUID fromString: '{7DD773C4-3A6C-49F9-95C5-8594907515B7}')!
WebFieldSet comment: 'FieldSet element groups one or more input fields together. It usually (depends on style) also enclose them with border. Legend is for writing a name of the filedset on the corner'!
!WebFieldSet categoriesForClass!Unclassified! !
!WebFieldSet methodsFor!

initialize
	"Initialize a newly created instance. This method must answer the receiver."

	" *** Replace this comment with the appropriate initialization code *** "
	^self!

legend
	^legend!

legend: aString
	"a label to be shown on left top corner of fieldset"
	legend := aString!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	aStream nextPutAll: self ident, '<fieldset'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	self legend notNil ifTrue: 
		[aStream nextPutAll: self identMore, '<legend>', self legend, '</legend>', self eol].
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</fieldset>', self eol.! !
!WebFieldSet categoriesFor: #initialize!initialize-release!private! !
!WebFieldSet categoriesFor: #legend!accessing!private! !
!WebFieldSet categoriesFor: #legend:!accessing!private! !
!WebFieldSet categoriesFor: #printHTMLPageOn:forSession:!printing!private! !

!WebFieldSet class methodsFor!

new
	"Answer a newly created and initialized instance."
	^super new initialize!

newLegend: aString
	^self new legend: aString! !
!WebFieldSet class categoriesFor: #new!instance creation!private! !
!WebFieldSet class categoriesFor: #newLegend:!instance creation!private! !

WebForm guid: (GUID fromString: '{32B4336F-85D6-4788-8F42-C288905AEECA}')!
WebForm comment: ''!
!WebForm categoriesForClass!Unclassified! !
!WebForm methodsFor!

acceptFormInputFrom: aRequest
 	"read a post data from request and write values to the valueModels of fields in a form.
	For checkboxes and radiobuttons, a set of values is expected under the same name"
	| postData |
	postData := HTTPPostDataArray new. "like Dictionary, but multiple values per key"
	self uncheckAllChecboxes. self uncheckAllRadioButtons.
	aRequest  postKeysAndValuesDo: [:key :value | postData at: key put: value].
	self fields keysAndValuesDo: [:key :field | 
		(postData includesKey: key) ifTrue:
			[field isCheckBox ifTrue: [field acceptFormInputFrom: postData].
			field isRadioButton ifTrue: [field acceptFormInputFrom: postData].
			field isMenu ifTrue: [field acceptFormInputFrom: postData].
			field isButton ifTrue: ["do nothing"].
			field isFileInputField ifTrue: 
				[field valueModel value: (postData at: key). 
				field acceptFileAttributesFrom: aRequest field: key].
			(field isInputField | field isTextArea)  
				ifTrue: [field saveThroughAdapterValue: (postData at: key)]
				]]!

adaptFormElement: aWebFormElement
	"set appropriate aspect adaptor for that element"
	aWebFormElement isFormElement ifFalse: [^nil].
	(aWebFormElement isRadioButton | aWebFormElement isCheckBox)
		ifTrue: [aWebFormElement joinToForm: self]
		ifFalse:	[aWebFormElement adapt]!

addToFields: aWebFormElement
	(self alreadyRegistered: aWebFormElement) ifTrue: [^self error: 'already exist!!'].
	self fields at: aWebFormElement name put: aWebFormElement.
	^self fieldSet add: aWebFormElement!

ajaxAcceptFormInputFrom: aRequest
 	"Ajax have only one input per request!!"
	| k postData |
	aRequest isPost not ifTrue:
			[k :=  aRequest queryData keys detect: [:each | 'field*' match: each] ifNone: nil.
			postData := Dictionary new at: k put: (aRequest queryAt: k); yourself]
		ifFalse: 
			[k :=  aRequest postData keys detect: [:each | 'field*' match: each] ifNone: nil.
			postData := Dictionary new at: k put: (aRequest postDataAt: k) value; yourself].
	self fields keysAndValuesDo: [:key :field | 
		(postData includesKey: key) ifTrue:
			[field isCheckBox ifTrue: [field acceptFormInputFrom: postData].
			field isRadioButton ifTrue: [field acceptFormInputFrom: postData].
			field isMenu ifTrue: [field acceptFormInputFrom: postData].
			field isButton ifTrue: ["do nothing"].
			field isFileInputField ifTrue: 
				[field valueModel value: (postData at: key). 
				field acceptFileAttributesFrom: aRequest field: key].
			(field isInputField | field isTextArea) 
				ifTrue: [field saveThroughAdapterValue: (postData at: key)]
				]]!

alreadyRegistered: aWebFormElement
	^self fieldSet includes: aWebFormElement!

clear
	"delete all elements of thi form. Also reset instance variables fields and fieldNum"
	super clear.
	self initFields!

fields
	"return a dictionary of all fields in this form. a field name is used as a key"
	fields isNil ifTrue: [self initFields].
	^fields!

fieldSet
	^self fields at: #set ifAbsent: [self initFieldSet].!

initFields
	fields := Dictionary new.
	self initFieldSet. "with all fields for fast check, if field is already registered"!

initFieldSet
	"with all fields for fast check, if field is already registered"
	^self fields at: #set put: Set new.!

name
	"name of a WebForm, used to start the right action when
	submitting a form. Initialy is set automaticaly by a WebApplication
	in format formxxx, eg. form1 or form123"
	^name!

name: aString
	name := aString.!

onReset: aJavascriptCode
	self attributesAt: #onReset put: aJavascriptCode!

onSubmit: aJavascriptCode
	self attributesAt: #onSubmit put: aJavascriptCode!

printHTMLPageOn: aStream forSession: aSession
	| action |
	self prepareToHTMLPrintOn: aSession.
	action := aSession fullUrlForCurrentPage.
	aStream nextPutAll: 
		self ident, '<form  method=post action="', action, '"', ' enctype="multipart/form-data"'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll:  self ident, '</form>', self eol.!

registerFormElementsIn: aWebElement
	"find and register (add to fields ans set aspect adapters) all form elements in this and subelements"
	aWebElement isNil ifTrue: [^nil]. 
	aWebElement isFormElement ifTrue:
		[(aWebElement name isNil or: [aWebElement name isEmpty]) 
			ifTrue:
				[aWebElement name: 'field', (self fields size + 1 - 1"set") printString.
				self addToFields: aWebElement]
			ifFalse: 
				[(self alreadyRegistered: aWebElement) ifFalse: [self addToFields: aWebElement]].
		self adaptFormElement: aWebElement].
	aWebElement isComposite ifTrue: 
		[aWebElement elements do: [:each | self registerFormElementsIn: each] ]!

shouldIdent
	^true!

uncheckAllChecboxes
	self fieldSet do: [:each | each isCheckBox ifTrue: [each uncheckValue] ]!

uncheckAllRadioButtons! !
!WebForm categoriesFor: #acceptFormInputFrom:!model adapting!private! !
!WebForm categoriesFor: #adaptFormElement:!model adapting!private! !
!WebForm categoriesFor: #addToFields:!private! !
!WebForm categoriesFor: #ajaxAcceptFormInputFrom:!model adapting!private! !
!WebForm categoriesFor: #alreadyRegistered:!private! !
!WebForm categoriesFor: #clear!accessing!private! !
!WebForm categoriesFor: #fields!accessing!private! !
!WebForm categoriesFor: #fieldSet!accessing!private! !
!WebForm categoriesFor: #initFields!initialize-release!private! !
!WebForm categoriesFor: #initFieldSet!initialize-release!private! !
!WebForm categoriesFor: #name!accessing!private! !
!WebForm categoriesFor: #name:!accessing!private! !
!WebForm categoriesFor: #onReset:!events!private! !
!WebForm categoriesFor: #onSubmit:!events!private! !
!WebForm categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebForm categoriesFor: #registerFormElementsIn:!model adapting!private! !
!WebForm categoriesFor: #shouldIdent!private! !
!WebForm categoriesFor: #uncheckAllChecboxes!model adapting!private! !
!WebForm categoriesFor: #uncheckAllRadioButtons!model adapting!private! !

!WebForm class methodsFor!

idFieldName
	"this name is used to name a hidden field which is included in every form to identify 
	it from other forms. The name is so strange so that you probably won't name your field the same"

	^'id5273'! !
!WebForm class categoriesFor: #idFieldName!constants!private! !

WebFormElement guid: (GUID fromString: '{C265F717-B807-48B8-8466-78D318608A34}')!
WebFormElement comment: ''!
!WebFormElement categoriesForClass!Unclassified! !
!WebFormElement methodsFor!

activate
	"move focus and select the text in that form field. (focus+select)"
	self registerId.
	self scriptAfter: 'Field.activate(''', self id, ''')'!

adapt
	"set appropriate aspect adaptor for that element"
	(self aspect isKindOf: Symbol) ifTrue:
		[self valueModel: ((AspectAdaptor forAspect: self aspect) subject: self object)].
	(self aspect  isKindOf: Number) ifTrue:  
		"adapt to an element of collection"
		[self valueModel: ((IndexedAdaptor forIndex: self aspect) subject: self object)]!

aspect
	^aspect!

aspect: aSymbol
	aspect := aSymbol.!

aspect: aSymbol for: anObject
	"set the link between this form element and an aspect (name of instance variable) 
	of an object , which value is presented in this webFormElement. The appropriate 
	aspect adaptor is generated after page composition in aWebApplication printWebView 
	method to check also elements which were added to subelements later!!. Name of a form 
	element is set to an aspect name, if not already set differently"
	self aspect: aSymbol.
	self object: anObject!

focus
	"move the input focus to that form field"
	self registerId.
	self scriptAfter: 'Field.focus(''', self id, ''')'!

initialize
	self name: ''.
	self valueModel: '' asValue.
"	self app form registerFormElementsIn: self "!

isAutocompleteField
	^false!

isButton
	^false!

isCheckBox
	^false!

isDateInputField
	^false!

isEmpty
	"input field is empty or nil"
	| vlue |
	vlue := self object perform: self aspect.
	^vlue isNil 
		or: [((vlue isKindOf: String) and: [vlue isEmpty])
			or: [(vlue isKindOf: Number) and: [vlue = 0] ]]!

isFileInputField
	^false!

isFormElement
	^true!

isInputField
	^false!

isListBox
	^false!

isMenu
	^false!

isRadioButton
	^false!

isTextArea
	^false!

name
	^self attributesAt: #name!

name: aString
	self attributesAt: #name put: aString!

object
	^object!

object: anObject

	"set the object, which instance variable is presented as aspect in this fom element"

	object := anObject.!

onChange: aJavascriptCode
	self attributesAt: #onChange add: aJavascriptCode!

onChangePost
	"after field change immediatelly post contents to server (AJAX)"
	self onChangePostAndUpdate: nil!

onChangePostAndUpdate: anElementOrId
	"after field change, post contents to server and AJAX update anElementOrId  "
	self onChange: (self scriptForPostAndUpdate: anElementOrId with: nil)!

onChangePostAndUpdate: anElementOrId with: aParmString
	"after field change, post contents to server and AJAX update anElementOrId  "
	self onChange: (self scriptForPostAndUpdate: anElementOrId with: aParmString)!

onChangePostAndUpdateSelf
	"DONT WORK YET!!"
	"after field change, post contents to server and AJAX update that form element  "
	self registerId.
	self onChangePostAndUpdate: self!

onFocus: aJavascriptCode
	self attributesAt: #onFocus add: aJavascriptCode!

onKeyPressPostAndUpdate: anElementOrId
	"after fany key press in a field, post contents to server (AJAX)"
	self onKeyPress: (self scriptForPostAndUpdate: anElementOrId  with: nil)!

onKeyUpPostAndUpdate: anElementOrId
	"after any key  release in a field, post contents to server (AJAX)"
	self onKeyUp: (self scriptForPostAndUpdate: anElementOrId with: nil)!

onSelect: aJavascriptCode
	self attributesAt: #onSelect add: aJavascriptCode!

scriptForPostAndUpdate: anElementOrId
	| url idSymbol parms |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] 
		ifFalse: [anElementOrId isNil 
			ifTrue: [#nil] ifFalse: [anElementOrId registerId. anElementOrId id] ].
	self registerId.
	url := self ajaxCallUrl. 
	parms := self ajaxCallUrlParametersFor: anElementOrId.
	^'var field = Form.Element.serialize(''', self id asString, '''); new Ajax.Updater(''', idSymbol asString, ''', ''', "url, ''', {method: ''get'', parameters: ''', parms, ''' + field, evalScripts: true})'"
url, ''', {method: ''post'', postBody: field + ''', ('&', parms), ''', evalScripts: true})'!

scriptForPostAndUpdate: anElementOrId with: aParmString
	| url idSymbol parms |
	idSymbol := anElementOrId isSymbol 
		ifTrue: [anElementOrId] 
		ifFalse: [anElementOrId isNil 
			ifTrue: [#nil] ifFalse: [anElementOrId registerId. anElementOrId id] ].
	self registerId.
	url := self ajaxCallUrl. 
	parms := self ajaxCallUrlParametersFor: anElementOrId.
	aParmString notNil ifTrue: [parms := parms, '&parm=', aParmString].
	^'var field = Form.Element.serialize(''', self id asString, '''); new Ajax.Updater(''', idSymbol asString, ''', ''', "url, ''', {method: ''get'', parameters: ''', parms, ''' + field, evalScripts: true})'"
url, ''', {method: ''post'', postBody: field + ''', ('&', parms), ''', evalScripts: true})'!

select
	"select the text in that form field"
	self registerId.
	self scriptAfter: 'Field.select(''', self id, ''')'!

tabIndex: aNumber
	"This attribute specifies the position of the current element in the tabbing order 
	for the current document"
	self attributes at: #tabindex put: aNumber printString!

type: aString
	"set the type of  this form element"
	self attributesAt: #type put: aString!

value
	^self valueModel value!

value: aValue
	"set the value of this form element"
	self valueModel value:  aValue.!

valueModel
	^valueModel!

valueModel: aValueModel

	"default valueHolder of input field at form creation, written value at form 	submission"

	valueModel := aValueModel.! !
!WebFormElement categoriesFor: #activate!events-ajax!private! !
!WebFormElement categoriesFor: #adapt!model adapting!private! !
!WebFormElement categoriesFor: #aspect!accessing!private! !
!WebFormElement categoriesFor: #aspect:!accessing!private! !
!WebFormElement categoriesFor: #aspect:for:!model adapting!private! !
!WebFormElement categoriesFor: #focus!events-ajax!private! !
!WebFormElement categoriesFor: #initialize!initialize-release!private! !
!WebFormElement categoriesFor: #isAutocompleteField!private!testing! !
!WebFormElement categoriesFor: #isButton!private!testing! !
!WebFormElement categoriesFor: #isCheckBox!private!testing! !
!WebFormElement categoriesFor: #isDateInputField!private!testing! !
!WebFormElement categoriesFor: #isEmpty!private!testing! !
!WebFormElement categoriesFor: #isFileInputField!private!testing! !
!WebFormElement categoriesFor: #isFormElement!private!testing! !
!WebFormElement categoriesFor: #isInputField!private!testing! !
!WebFormElement categoriesFor: #isListBox!private!testing! !
!WebFormElement categoriesFor: #isMenu!private!testing! !
!WebFormElement categoriesFor: #isRadioButton!private!testing! !
!WebFormElement categoriesFor: #isTextArea!private!testing! !
!WebFormElement categoriesFor: #name!attributes!private! !
!WebFormElement categoriesFor: #name:!attributes!private! !
!WebFormElement categoriesFor: #object!accessing!private! !
!WebFormElement categoriesFor: #object:!accessing!private! !
!WebFormElement categoriesFor: #onChange:!events!private! !
!WebFormElement categoriesFor: #onChangePost!events-ajax!private! !
!WebFormElement categoriesFor: #onChangePostAndUpdate:!events-ajax!private! !
!WebFormElement categoriesFor: #onChangePostAndUpdate:with:!events-ajax!private! !
!WebFormElement categoriesFor: #onChangePostAndUpdateSelf!events-ajax!private! !
!WebFormElement categoriesFor: #onFocus:!events!private! !
!WebFormElement categoriesFor: #onKeyPressPostAndUpdate:!events-ajax!private! !
!WebFormElement categoriesFor: #onKeyUpPostAndUpdate:!events-ajax!private! !
!WebFormElement categoriesFor: #onSelect:!events!private! !
!WebFormElement categoriesFor: #scriptForPostAndUpdate:!private!private-ajax! !
!WebFormElement categoriesFor: #scriptForPostAndUpdate:with:!private!private-ajax! !
!WebFormElement categoriesFor: #select!events-ajax!private! !
!WebFormElement categoriesFor: #tabIndex:!attributes!private! !
!WebFormElement categoriesFor: #type:!attributes!private! !
!WebFormElement categoriesFor: #value!accessing!private! !
!WebFormElement categoriesFor: #value:!accessing!private! !
!WebFormElement categoriesFor: #valueModel!accessing!private! !
!WebFormElement categoriesFor: #valueModel:!accessing!private! !

!WebFormElement class methodsFor!

autoConvertString: aString toObject: anObject
	"try to convert string depending on object type"
	(anObject isKindOf: String) ifTrue: [^aString].
	(anObject isKindOf: Integer) ifTrue: [^aString asInteger].
	(anObject isKindOf: FixedPoint) ifTrue: [^aString asFixedPoint: anObject scale].
	(anObject isKindOf: Date) ifTrue: [^Date readSloFrom: aString readStream].
	anObject isNil ifTrue: [^aString].
	^aString!

autoConvertToString: anObject
	"try to convert object to string depending on object type"
	(anObject isKindOf: String) ifTrue: [^anObject].
	(anObject isKindOf: Integer) ifTrue: [^anObject printDotString].
	(anObject isKindOf: FixedPoint) ifTrue: [^anObject printDotString].
	(anObject isKindOf: Date) ifTrue: [^anObject shortPrintSloString].
	^anObject printString!

new
	^super new initialize! !
!WebFormElement class categoriesFor: #autoConvertString:toObject:!auto type converting!private! !
!WebFormElement class categoriesFor: #autoConvertToString:!auto type converting!private! !
!WebFormElement class categoriesFor: #new!instance creation!private! !

WebGrid guid: (GUID fromString: '{0CA05494-FA0C-4DD9-ADF4-5B646D0C27A8}')!
WebGrid comment: ''!
!WebGrid categoriesForClass!Unclassified! !
!WebGrid methodsFor!

addNewColumn
	self columns add: ((WebGridColumn newOn: self) id: (self columns size + 1))!

ajaxUpdateWith: aParmString
	| id |
	(aParmString notNil and: ['sort-*' match: aParmString]) ifTrue: 
		[id := aParmString readStream upTo: $-; upToEnd.
		(self columnWithId: id asInteger) sort]. "or toogle sort order"
	^self!

buildTable
	self initElements; initTable.
	self table class: self cssClass. self initFiltered.
	self tableWidth notNil ifTrue: [self table width: self tableWidth].
	self buildTableHeader.
	self sortColumnsIfNessesary.
	self hasFilters ifTrue: [self buildTableFilterRow. self filterRows].
	self buildTableRows.
	self needsSummary ifTrue: [self buildTableSummaryRow].
	self app form registerFormElementsIn: self.  "this will add registrations to grid form elements"!

buildTableFilterRow
	| field |
	self newRow.
	self columns do: [:each | 
		each align notNil ifTrue: [self cell align: each align].
		each filter notNil ifTrue: 
			[field := WebInputField aspect: #filter for: each size: 10.
			field adapt. "because we are not part of a form"
			(self wasFilterChangedFor: each on: field) ifTrue: [field focus].
			field onKeyUpPostAndUpdate: self.
			self cell add: field].
		each ~= self columns last ifTrue: [self newCell] ].!

buildTableHeader
	self columns do: [:each | 
		self cell setHeader.
		each align notNil ifTrue: [self cell align: each align].
		each name notNil ifTrue: [self cell add: (self sortLinkColumn: each)].
		each isSortedAscending ifTrue: [self cell addGif: #arrowOrangeUpGif].
		each isSortedDescending ifTrue: [self cell addGif: #arrowOrangeDownGif].
		each ~= self columns last ifTrue: [self newCell] ].!

buildTableRows
	| inx objects |
	inx := 1.
	self collection notEmpty ifTrue: [self newRow].
	objects := self filtered isNil ifTrue: [self collection] ifFalse: [self filtered].
	self resetSummary.
	objects do: [:object |
		self setRowAttributesFor: self row object: object.
		self columns do: [:column |
			(object == objects first and: [column width notNil]) 
				ifTrue: [self cell width: column width].
			self printColumn: column index: inx object: object in: self cell.
			self summaryForColumn: column index: inx object: object.
			column ~= self columns last ifTrue: [self newCell] ].
		object ~= objects last ifTrue: [self newRow].
		inx := inx + 1 ]!

buildTableSummaryRow
	self newRow. self row class: #summary.
	self columns do: [:each | 
		each align notNil ifTrue: [self cell align: each align].
		each name notNil ifTrue: [self cell addText: each summaryValue].
		each ~= self columns last ifTrue: [self newCell] ].!

canFilterObject: anObject onColumns: aColumnsToFilter
	aColumnsToFilter do: [:column |
		column aspect notNil ifTrue: 
			[((column filter, '*') match: (anObject perform: column aspect)) ifFalse: [^false] ] ].
	^true!

checkboxes
	"nil or column"
	^self settingsAt: #checkboxesColumn ifAbsent: [nil]!

checkboxes: aColumnId
	^self settingsAt: #checkboxesColumn put: aColumnId!

checkboxesCollection
	"collection of checked row objects"
	^self settingsAt: #checkboxesCollection ifAbsent: [nil]!

checkboxesCollection: aCollection
	^self settingsAt: #checkboxesCollection put: aCollection!

checkboxesColumn: aColumnId collection: aCollection
	"this column will have checboxes. Checked row objects will be in aCollection.
	preselected rows are done from initial aCollection"
	self checkboxes: aColumnId.
	self checkboxesCollection: aCollection!

collection
	collection isNil ifTrue: [^#()].
	^collection!

collection: aCollection
	collection := aCollection!

column: aColumnId addBlock: aBlock
	"this block will be called with current row object as an argument. 
	It must return kind of WebElement which will be added to the table cell"
	self columns size < aColumnId ifTrue: [self addNewColumn].
	(self columns at: aColumnId) addBlock: aBlock!

column: aColumnId viewBlock: aBlock
	"this block will be called with current row object as an argument. It must return plain string!!"
	self columns size < aColumnId ifTrue: [self addNewColumn]. "?"
	(self columns at: aColumnId) viewBlock: aBlock!

columnAlign: anArrayOfSymbols
	"#left #right #center, nil if default left is used"
	| inx |
	inx := 1.
	anArrayOfSymbols do: [:each |
		self columns size < inx ifTrue: [self addNewColumn].
		(self columns at: inx) align: each.
		inx := inx + 1]!

columnAspects: anArrayOfSymbols
	"methods to be called for each column on every object in collection"
	| inx |
	inx := 1.
	anArrayOfSymbols do: [:each |
		self columns size < inx ifTrue: [self addNewColumn].
		(self columns at: inx) aspect: each.
		inx := inx + 1]!

columnLinkAspects: anArrayOfSymbols
	"url link to an aspects of an object. Specify views with separate columnLinkViews: method"
	| inx |
	inx := 1.
	anArrayOfSymbols do: [:each |
		self columns size < inx ifTrue: [self addNewColumn].
		(self columns at: inx) linkAspect:  each.
		inx := inx + 1]!

columnLinkViews: anArrayOfSymbols
	"link to an aspect of object(if set with cloumnLinks:, otherwise to object itself) with a view 
	will be shown in thi column"
	| inx |
	inx := 1.
	anArrayOfSymbols do: [:each |
		self columns size < inx ifTrue: [self addNewColumn].
		(self columns at: inx) linkView:  each.
		inx := inx + 1]!

columnNames: anArrayOfStrings
	"set names of columns to be shown in header of table"
	| inx |
	inx := 1.
	anArrayOfStrings do: [:each |
		self columns size < inx ifTrue: [self addNewColumn].
		(self columns at: inx) name: each.
		inx := inx + 1]!

columns
	columns isNil ifTrue: [self initColumns].
	^columns!

columnWidth: anArrayOfNumbers
	"width of column or nil."
	| inx |
	inx := 1.
	anArrayOfNumbers do: [:each |
		self columns size < inx ifTrue: [self addNewColumn].
		(self columns at: inx) width: each.
		inx := inx + 1]!

columnWithId: aNumber
	aNumber > self columns size ifTrue: [^nil].
	^self columns at: aNumber!

cssClass
	^self settingsAt: #cssClass ifAbsent: [self defaultCssClass]!

defaultCssClass
	^#webGrid!

defaultTableWidth
	^1 "100%"!

endTagFor: anObject
	(self rowBoldBlock notNil and: [self rowBoldBlock value: anObject]) ifTrue: [^'</b>'].
	^''!

filtered
	"objects which pass filter criteria. if nil, filters are not set"
	^filtered!

filtered: aSet
	filtered := aSet!

filterRow: anArrayOfSymbolsOrStrings
	"row with filter input fields, put true on a column to add filter"
	| inx |
	inx := 1.
	anArrayOfSymbolsOrStrings do: [:each |
		self columns size < inx ifTrue: [self addNewColumn].
		each = true ifTrue: [(self columns at: inx) setFilter].
		inx := inx + 1]!

filterRows
	| columnsToFilter | 
	columnsToFilter := self columns select: [:each | each filter notNil]. columnsToFilter isEmpty ifTrue: [^nil].
	self filtered: (self collection select: [:object | self canFilterObject: object onColumns: columnsToFilter]).!

hasFilters
	"any column has a filter"
	^self columns contains: [:each | each filter notNil].!

hasNoZeros
	"don't show zeros"
	^self settingsAt: #noZeros ifAbsent: [false]!

hasShortDates
	"year in two digits only"
	^self settingsAt: #shortDates ifAbsent: [false]!

initColumns
	columns := OrderedCollection new!

initFiltered
	filtered := nil.!

initialize
	self method: #ajaxUpdateWith: "this method will be called after ajax update"!

initSettings
	settings := Dictionary new.!

insideDivTag
	"to enclose or not in div tag. Only if element have any attribute!!"
	^self div | self attributes notNil.!

lastColumn
	^self columns notEmpty ifTrue: [self columns last] ifFalse: [nil].!

needsSummary
	"summary row needed or not"
	^self columns contains: [:each | each needsSummary].!

noZeros
	"don't show if value is zero"
	^self settingsAt: #noZeros put: true!

numbering
	"false or column"
	^self settingsAt: #numberingColumn ifAbsent: [nil]!

numbering: aColumnId
	"false or column"
	^self settingsAt: #numberingColumn put: aColumnId!

parent: aWebElement
	"self buildTable." "build just before rendering!!"
	^super parent: aWebElement!

prepareToHTMLPrintOn: aSession
	super prepareToHTMLPrintOn: aSession.
	self buildTable!

printCheckboxIndex: aNumber object: anObject in: anElement
	| field |
	field := WebCheckBox object: anObject from: self checkboxesCollection.
"	self app form registerFormElementsIn: field.  "
	anElement add: field.!

printColumn: aColumn index: aNumber object: anObject in: anElement
	aColumn align notNil ifTrue: [anElement align: aColumn align].
	aColumn isNumbered  ifTrue: [^self printNumber: aNumber object: anObject in: anElement].
	aColumn isCheckboxed  ifTrue: [^self printCheckboxIndex: aNumber object: anObject in: anElement].
	aColumn hasLink ifTrue: [^self printLinkTo: anObject column: aColumn in: anElement]. 
	aColumn hasAddBlock ifTrue: [^anElement add: (aColumn addBlock value: anObject)].
	anElement addText: 
		(self startTagFor: anObject), (aColumn viewBlock value: anObject), (self endTagFor: anObject)!

printHTMLPageOn: aStream forSession: aSession
	"self buildTable." "not so late, build imediately after adding to some parent!!"
	self prepareToHTMLPrintOn: aSession. "buildTable"
	aStream nextPutAll: self ident, '<div'. self printAttributesOn: aStream for: aSession. 
	aStream nextPutAll: '>', self eol.
	elements notNil ifTrue: [elements do: [:element | 
		element notNil ifTrue: [element printHTMLPageOn: aStream forSession: aSession] ] ].
	aStream nextPutAll: self ident, '</div>', self eol.!

printLinkTo: anObject column: aColumn in: anElement
	| view object linkText |
	view := aColumn linkView notNil ifTrue: [aColumn linkView] ifFalse: [#main].
	object := aColumn linkAspect notNil 
		ifTrue: [anObject perform: aColumn linkAspect] ifFalse: [anObject].
	linkText := (self startTagFor: anObject), (aColumn viewBlock value: anObject), 
		(self endTagFor: anObject).
	object notNil
		ifTrue: [anElement addLinkTo: object text: linkText view: view]
		ifFalse: [anElement addText: linkText]!

printNumber: aNumber object: anObject in: anElement
	anElement addText: 
		(self startTagFor: anObject), aNumber printDotString, '.', (self endTagFor: anObject)!

removeLastColumn
	self columns notEmpty ifTrue: [self columns remove: self lastColumn].!

resetSummary
	self columns do: [:each | each resetSummary].!

rowBlueBlock
	^self settingsAt: #rowBlueBlock!

rowBlueIfTrue: aBlock
	^self settingsAt: #rowBlueBlock put: aBlock!

rowBoldBlock
	^self settingsAt: #rowBoldBlock!

rowBoldIfTrue: aBlock
	^self settingsAt: #rowBoldBlock put: aBlock!

rowGrayBlock
	^self settingsAt: #rowGrayBlock!

rowGrayIfTrue: aBlock
	^self settingsAt: #rowGrayBlock put: aBlock!

rowGreenBlock
	^self settingsAt: #rowGreenBlock!

rowGreenIfTrue: aBlock
	^self settingsAt: #rowGreenBlock put: aBlock!

rowRedBlock
	^self settingsAt: #rowRedBlock!

rowRedIfTrue: aBlock
	^self settingsAt: #rowRedBlock put: aBlock!

rowYellowBlock
	^self settingsAt: #rowYellowBlock!

rowYellowIfTrue: aBlock
	^self settingsAt: #rowYellowBlock put: aBlock!

setNumbering
	"in first column a sequential nr. of this row will be shown"
	self setNumberingOn: 1!

setNumberingOn: aColumnId
	"in this column a sequential nr. of this row will be shown"
	self numbering: aColumnId!

setRowAttributesFor: aWebRow object: anObject
	(self rowRedBlock notNil and: [self rowRedBlock value: anObject]) 
		ifTrue: [^aWebRow class: #red].
	(self rowGreenBlock notNil and: [self rowGreenBlock value: anObject]) 
		ifTrue: [^aWebRow class: #green].
	(self rowBlueBlock notNil and: [self rowBlueBlock value: anObject]) 
		ifTrue: [^aWebRow class: #blue].
	(self rowYellowBlock notNil and: [self rowYellowBlock value: anObject]) 
		ifTrue: [^aWebRow class: #yellow].
	(self rowGrayBlock notNil and: [self rowGrayBlock value: anObject]) 
		ifTrue: [^aWebRow class: #gray].!

settings
	settings isNil ifTrue: [self initSettings].
	^settings!

settingsAt: aSymbol
	^self settingsAt: aSymbol ifAbsent: [nil]!

settingsAt: aSymbol ifAbsent: aBlock
	^self settings at: aSymbol ifAbsent: aBlock!

settingsAt: aSymbol put: aValue
	self settings at: aSymbol put: aValue!

shortDates
	"year in two digits only"
	^self settingsAt: #shortDates put: true!

sortAscendingOn: aColumnId
	"this column will be sorted ascending"
	self sortColumn: aColumnId.
	self sortOrder: #ascending!

sortColumn
	"false or column"
	^self settingsAt: #sortColumn ifAbsent: [nil]!

sortColumn: aColumnId
	"false or column"
	^self settingsAt: #sortColumn put: aColumnId!

sortColumnsIfNessesary
	| column sortBlock | 
	 self sortColumn isNil ifTrue: [^nil].
	column := self columns at: self sortColumn.
	sortBlock := (self sortOrder = #ascending)
		ifTrue: [ [:a :b | (a perform: column aspect) < (b perform: column aspect)] ]
		ifFalse: [ [:a :b | (a perform: column aspect) > (b perform: column aspect)] ].
	self collection: (SortedCollection withAll: self collection sortBlock: sortBlock) asOrderedCollection.!

sortDescendingOn: aColumnId
	"this column will be sorted ascending"
	self sortColumn: aColumnId.
	self sortOrder: #descending!

sortLinkColumn: aWebGridColumn
	| dummyLink |
	dummyLink := WebLink text: aWebGridColumn name linkTo: (Array with: self app observee with: '-').
	self app inDefaultView ifFalse: [dummyLink view: self app view].
	dummyLink onClickUpdate: self with: 'sort-', aWebGridColumn id printString.
	^dummyLink!

sortOn: aColumnId
	"this column will be sorted ascending"
	self sortAscendingOn: aColumnId!

sortOrder
	^self settingsAt: #sortOrder ifAbsent: [#ascending]!

sortOrder: aSymbol
	"#ascending or #descending"
	^self settingsAt: #sortOrder put: aSymbol!

startTagFor: anObject
	(self rowBoldBlock notNil and: [self rowBoldBlock value: anObject]) ifTrue: [^'<b>'].
	^''!

summaryForColumn: aColumn index: aNumber object: anObject
	aColumn needsSummary ifFalse: [^nil].
	aColumn addToSummary: anObject.!

summaryRow: anArrayOfSymbolsOrStrings
	"if you want a summary row, define for desired column: #sum, #count or 'some text' "
	| inx |
	inx := 1.
	anArrayOfSymbolsOrStrings do: [:each |
		self columns size < inx ifTrue: [self addNewColumn].
		(self columns at: inx) summaryType:  each.
		inx := inx + 1]!

tableWidth
	^self settingsAt: #tableWidth ifAbsent: [self defaultTableWidth]!

wasFilterChangedFor: aWebGridColumn on: anInputField
	| request vlue |
	request := self app session lastRequest.
	(request isAjaxRequest and: [request isPost]) ifFalse: [^false].
	request postKeysAndValuesDo: [:key :value |
		(('field', '*') match: key) ifTrue: [vlue := value] ].
	^vlue = aWebGridColumn filter! !
!WebGrid categoriesFor: #addNewColumn!private! !
!WebGrid categoriesFor: #ajaxUpdateWith:!private!private-printing! !
!WebGrid categoriesFor: #buildTable!private!private-printing! !
!WebGrid categoriesFor: #buildTableFilterRow!private!private-printing! !
!WebGrid categoriesFor: #buildTableHeader!private!private-printing! !
!WebGrid categoriesFor: #buildTableRows!private!private-printing! !
!WebGrid categoriesFor: #buildTableSummaryRow!private!private-printing! !
!WebGrid categoriesFor: #canFilterObject:onColumns:!private!private-printing! !
!WebGrid categoriesFor: #checkboxes!private! !
!WebGrid categoriesFor: #checkboxes:!private! !
!WebGrid categoriesFor: #checkboxesCollection!private! !
!WebGrid categoriesFor: #checkboxesCollection:!private! !
!WebGrid categoriesFor: #checkboxesColumn:collection:!private!settings-column! !
!WebGrid categoriesFor: #collection!accessing!private! !
!WebGrid categoriesFor: #collection:!accessing!private! !
!WebGrid categoriesFor: #column:addBlock:!private!settings-column! !
!WebGrid categoriesFor: #column:viewBlock:!private!settings-column! !
!WebGrid categoriesFor: #columnAlign:!private!settings-column! !
!WebGrid categoriesFor: #columnAspects:!private!settings-column! !
!WebGrid categoriesFor: #columnLinkAspects:!private!settings-column! !
!WebGrid categoriesFor: #columnLinkViews:!private!settings-column! !
!WebGrid categoriesFor: #columnNames:!private!settings-column! !
!WebGrid categoriesFor: #columns!private! !
!WebGrid categoriesFor: #columnWidth:!private!settings-column! !
!WebGrid categoriesFor: #columnWithId:!accessing!private! !
!WebGrid categoriesFor: #cssClass!private! !
!WebGrid categoriesFor: #defaultCssClass!accessing!private! !
!WebGrid categoriesFor: #defaultTableWidth!accessing!private! !
!WebGrid categoriesFor: #endTagFor:!private!private-printing! !
!WebGrid categoriesFor: #filtered!private! !
!WebGrid categoriesFor: #filtered:!private! !
!WebGrid categoriesFor: #filterRow:!private!settings-column! !
!WebGrid categoriesFor: #filterRows!private!private-printing! !
!WebGrid categoriesFor: #hasFilters!private! !
!WebGrid categoriesFor: #hasNoZeros!private! !
!WebGrid categoriesFor: #hasShortDates!private! !
!WebGrid categoriesFor: #initColumns!initialize-release!private! !
!WebGrid categoriesFor: #initFiltered!initialize-release!private! !
!WebGrid categoriesFor: #initialize!initialize-release!private! !
!WebGrid categoriesFor: #initSettings!initialize-release!private! !
!WebGrid categoriesFor: #insideDivTag!private! !
!WebGrid categoriesFor: #lastColumn!private! !
!WebGrid categoriesFor: #needsSummary!private! !
!WebGrid categoriesFor: #noZeros!private!settings-column! !
!WebGrid categoriesFor: #numbering!private! !
!WebGrid categoriesFor: #numbering:!private! !
!WebGrid categoriesFor: #parent:!private! !
!WebGrid categoriesFor: #prepareToHTMLPrintOn:!private!private-printing! !
!WebGrid categoriesFor: #printCheckboxIndex:object:in:!private!private-printing! !
!WebGrid categoriesFor: #printColumn:index:object:in:!private!private-printing! !
!WebGrid categoriesFor: #printHTMLPageOn:forSession:!private!private-printing! !
!WebGrid categoriesFor: #printLinkTo:column:in:!private!private-printing! !
!WebGrid categoriesFor: #printNumber:object:in:!private!private-printing! !
!WebGrid categoriesFor: #removeLastColumn!private! !
!WebGrid categoriesFor: #resetSummary!private!private-printing! !
!WebGrid categoriesFor: #rowBlueBlock!private! !
!WebGrid categoriesFor: #rowBlueIfTrue:!private!settings-row! !
!WebGrid categoriesFor: #rowBoldBlock!private! !
!WebGrid categoriesFor: #rowBoldIfTrue:!private!settings-row! !
!WebGrid categoriesFor: #rowGrayBlock!private! !
!WebGrid categoriesFor: #rowGrayIfTrue:!private!settings-row! !
!WebGrid categoriesFor: #rowGreenBlock!private! !
!WebGrid categoriesFor: #rowGreenIfTrue:!private!settings-row! !
!WebGrid categoriesFor: #rowRedBlock!private! !
!WebGrid categoriesFor: #rowRedIfTrue:!private!settings-row! !
!WebGrid categoriesFor: #rowYellowBlock!private! !
!WebGrid categoriesFor: #rowYellowIfTrue:!private!settings-row! !
!WebGrid categoriesFor: #setNumbering!private!settings-column! !
!WebGrid categoriesFor: #setNumberingOn:!private!settings-column! !
!WebGrid categoriesFor: #setRowAttributesFor:object:!private!private-printing! !
!WebGrid categoriesFor: #settings!private! !
!WebGrid categoriesFor: #settingsAt:!private! !
!WebGrid categoriesFor: #settingsAt:ifAbsent:!private! !
!WebGrid categoriesFor: #settingsAt:put:!private! !
!WebGrid categoriesFor: #shortDates!private!settings-column! !
!WebGrid categoriesFor: #sortAscendingOn:!private!settings-column! !
!WebGrid categoriesFor: #sortColumn!private! !
!WebGrid categoriesFor: #sortColumn:!private! !
!WebGrid categoriesFor: #sortColumnsIfNessesary!private!private-printing! !
!WebGrid categoriesFor: #sortDescendingOn:!private!settings-column! !
!WebGrid categoriesFor: #sortLinkColumn:!private!private-printing! !
!WebGrid categoriesFor: #sortOn:!private!settings-column! !
!WebGrid categoriesFor: #sortOrder!private! !
!WebGrid categoriesFor: #sortOrder:!private! !
!WebGrid categoriesFor: #startTagFor:!private!private-printing! !
!WebGrid categoriesFor: #summaryForColumn:index:object:!private!private-printing! !
!WebGrid categoriesFor: #summaryRow:!private!settings-column! !
!WebGrid categoriesFor: #tableWidth!private! !
!WebGrid categoriesFor: #wasFilterChangedFor:on:!private! !

!WebGrid class methodsFor!

new
	^super new initialize! !
!WebGrid class categoriesFor: #new!instance creation!private! !

WebIFrame guid: (GUID fromString: '{A541D23C-B52E-4525-9A1E-1FE192DAF910}')!
WebIFrame comment: 'WebIFrame is frame, inserted within a block of text. See IFRAME tag in HTML 4.01 spec
'!
!WebIFrame categoriesForClass!Unclassified! !
!WebIFrame methodsFor!

frameBorder: aNumber
	"1 yes (default), 0 no"
	self attributesAt: #frameborder put: aNumber!

height: aNumber
	self attributesAt: #height put: aNumber!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession. 
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self ident, '<iframe'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>'.
	aStream nextPutAll: '</iframe>'.
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].!

scrolling: aSymbol
	"#yes #no #auto (default)"
	self attributesAt: #scrolling put: aSymbol!

size: aPoint
	"set the size of frame area in format width@height pixels"
	self width: aPoint x.
	self height: aPoint y.!

src: anUrlString
	self attributesAt: #src put: anUrlString!

width: aNumber
	self attributesAt: #width put: aNumber! !
!WebIFrame categoriesFor: #frameBorder:!attributes!private! !
!WebIFrame categoriesFor: #height:!attributes!private! !
!WebIFrame categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebIFrame categoriesFor: #scrolling:!attributes!private! !
!WebIFrame categoriesFor: #size:!attributes!private! !
!WebIFrame categoriesFor: #src:!attributes!private! !
!WebIFrame categoriesFor: #width:!attributes!private! !

WebImage guid: (GUID fromString: '{13F1A3B8-7BF1-49D7-8EA9-A583C79AF5F1}')!
WebImage comment: ''!
!WebImage categoriesForClass!Unclassified! !
!WebImage methodsFor!

alt: aString
	self attributes at: #alt put: aString!

border: aNumber
	self attributesAt: #border put: aNumber printString!

height: aNumber
	self attributesAt: #height put: aNumber printString!

hspace: aNumber
	self attributesAt: #hspace put: aNumber printString!

image
	^image!

image: anImage
	"set the image object of WebImage. 
	If nil, then urlreference should exist for image somewhere else"
	image := anImage.!

image: anImage align: aSymbol
	"set the image object of WebImage. and aligment"
	self image: anImage.
	self align: aSymbol!

imageAlign: aSymbol
	"#left #center #right"
	self attributesAt: #align put: aSymbol asString!

imageMap
	^imageMap!

imageMap: anImageMap
	imageMap := anImageMap!

initialize
	self border: 0!

name: aString
	self attributesAt: #name put: aString!

prepareAttributesToPrintOn: aSession
	self src: (self urlOnSession: aSession).
	self imageMap notNil ifTrue: [self usemap: self imageMap name].!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession. 
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self ident, '<img'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>'.
	self imageMap notNil ifTrue: [imageMap printHTMLPageOn: aStream forSession: aSession].
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].!

shouldIdent
	^false!

size: aPoint
	"set the size of an image in format width@height"
	self width: aPoint x.
	self height: aPoint y.!

src: aString
	self attributesAt: #src put: aString!

urlForLiveImageOn: aSession
	 ^aSession site urlResolver halfUrlFor: self image!

urlForMethodImageOn: aSession
	 ^aSession site urlResolver halfUrlFor: self image!

urlOnSession: aSession
	self image isNil ifTrue: [^''].
	self image isString ifTrue: [^self image].
	(self image isKindOf: WebLiveImage) ifTrue: [^self urlForLiveImageOn: aSession].
	(self image isKindOf: WebMethodImage) ifTrue: [^self urlForMethodImageOn: aSession].
	^aSession site urlResolver halfUrlFor: self image.!

usemap: aString
	self attributesAt: #usemap put: aString!

width: aNumber
	self attributesAt: #width put: aNumber printString! !
!WebImage categoriesFor: #alt:!attributes!private! !
!WebImage categoriesFor: #border:!attributes!private! !
!WebImage categoriesFor: #height:!attributes!private! !
!WebImage categoriesFor: #hspace:!attributes!private! !
!WebImage categoriesFor: #image!accessing!private! !
!WebImage categoriesFor: #image:!accessing!private! !
!WebImage categoriesFor: #image:align:!accessing!private! !
!WebImage categoriesFor: #imageAlign:!attributes!private! !
!WebImage categoriesFor: #imageMap!accessing!private! !
!WebImage categoriesFor: #imageMap:!accessing!private! !
!WebImage categoriesFor: #initialize!initialize-release!private! !
!WebImage categoriesFor: #name:!attributes!private! !
!WebImage categoriesFor: #prepareAttributesToPrintOn:!printing!private! !
!WebImage categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebImage categoriesFor: #shouldIdent!private!testing! !
!WebImage categoriesFor: #size:!attributes!private! !
!WebImage categoriesFor: #src:!attributes!private! !
!WebImage categoriesFor: #urlForLiveImageOn:!private!urls! !
!WebImage categoriesFor: #urlForMethodImageOn:!private!urls! !
!WebImage categoriesFor: #urlOnSession:!private!urls! !
!WebImage categoriesFor: #usemap:!attributes!private! !
!WebImage categoriesFor: #width:!attributes!private! !

!WebImage class methodsFor!

gif: aSymbol
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	| methodImage image |
	image := self new.
	methodImage := WebMethodImage
		fromMethod: aSymbol 
		on: image style 
		contentType: 'image/gif' 
		site: image site.
	^image image: methodImage!

gif: aSymbol  size: aPoint
	"this method will be called in your webStyle and this method 
	should return a gif in byte array format"
	| methodImage image |
	image := self new.
	methodImage := WebMethodImage
		fromMethod: aSymbol 
		on: image style 
		contentType: 'image/gif' 
		site: image site.
	^image image: methodImage;  size: aPoint!

image: anImage
	^self new image: anImage!

image: anImage align: aSymbol
	^self new image: anImage align: aSymbol!

image: anImage size: aPoint
	^self new image: anImage; size: aPoint!

jpeg: aSymbol
	"this method will be called in your webStyle and this method 
	should return a jpeg in byte array format"
	| methodImage image |
	image := self new.
	methodImage := WebMethodImage
		fromMethod: aSymbol 
		on: image style 
		contentType: 'image/jpeg' 
		site: image site.
	^image image: methodImage!

jpeg: aSymbol  size: aPoint
	"this method will be called in your webStyle and this method 
	should return a jpeg in byte array format"
	| methodImage image |
	image := self new.
	methodImage := WebMethodImage
		fromMethod: aSymbol 
		on: image style 
		contentType: 'image/jpeg' 
		site: image site.
	^image image: methodImage;  size: aPoint!

new
	^super new initialize!

png: aSymbol
	"this method will be called in your webStyle and this method 
	should return a png in byte array format"
	| methodImage image |
	image := self new.
	methodImage := WebMethodImage
		fromMethod: aSymbol 
		on: image style 
		contentType: 'image/png' 
		site: image site.
	^image image: methodImage!

png: aSymbol  size: aPoint
	"this method will be called in your webStyle and this method 
	should return a jpeg in byte array format"
	| methodImage image |
	image := self new.
	methodImage := WebMethodImage
		fromMethod: aSymbol 
		on: image style 
		contentType: 'image/png' 
		site: image site.
	^image image: methodImage;  size: aPoint! !
!WebImage class categoriesFor: #gif:!instance creation!private! !
!WebImage class categoriesFor: #gif:size:!instance creation!private! !
!WebImage class categoriesFor: #image:!instance creation!private! !
!WebImage class categoriesFor: #image:align:!instance creation!private! !
!WebImage class categoriesFor: #image:size:!instance creation!private! !
!WebImage class categoriesFor: #jpeg:!instance creation!private! !
!WebImage class categoriesFor: #jpeg:size:!instance creation!private! !
!WebImage class categoriesFor: #new!instance creation!private! !
!WebImage class categoriesFor: #png:!instance creation!private! !
!WebImage class categoriesFor: #png:size:!instance creation!private! !

WebImageMap guid: (GUID fromString: '{DC0A048E-25FA-4DE1-998B-226200E2BD75}')!
WebImageMap comment: ''!
!WebImageMap categoriesForClass!Unclassified! !
!WebImageMap methodsFor!

addCirclePos: aPositionPoint diameter: aNumber  link: aWebLink

	| coords |
	coords := Array
		with: aPositionPoint x
		with: aPositionPoint y
		with: aNumber.
	self addShape: #circle coordinates: coords link: aWebLink!

addRectanglePos: aPositionPoint size: aSizePoint  link: aWebLink

	| coords |
	coords := Array
		with: aPositionPoint x
		with: aPositionPoint y
		with: (aPositionPoint + aSizePoint) x
		with: (aPositionPoint + aSizePoint) y.
	self addShape: #rect coordinates: coords link: aWebLink!

addShape: aShapeSymbol coordinates: anArray link: aWebLink

	self areas add: 
		(Array with: aShapeSymbol with: anArray with: aWebLink)!

areas
	^areas!

initialize
	self name: self randomName.
	areas := OrderedCollection new.!

name: aString
	self attributesAt: #name put: aString.!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession. 
	aStream nextPutAll: self ident, '<map'.
	self printAttributesOn: aStream for: aSession.	
	aStream nextPutAll: '"> ', self eol.
	self areas do: [:area |
		aStream nextPutAll: self identMore, 
			'<area shape="'; nextPutAll: (area at: 1) asString; nextPutAll: '" coords="'.
		 1 to: (area at: 2) size do: [:inx  |
			inx > 1 ifTrue: [aStream nextPutAll: ','].
			aStream nextPutAll: ((area at: 2) at: inx) printString].
		aStream 
			nextPutAll: '" href="'; 	nextPutAll: ((area at: 3) composeURLOn: aSession); 
			nextPutAll: '"> ', self eol].
	aStream nextPutAll: self ident, '</map>', self eol.!

randomName

	^'map', ((Random new next * 100) truncated) printString!

shouldIdent
	^true! !
!WebImageMap categoriesFor: #addCirclePos:diameter:link:!adding areas!private! !
!WebImageMap categoriesFor: #addRectanglePos:size:link:!adding areas!private! !
!WebImageMap categoriesFor: #addShape:coordinates:link:!adding areas!private! !
!WebImageMap categoriesFor: #areas!private! !
!WebImageMap categoriesFor: #initialize!initialize - release!private! !
!WebImageMap categoriesFor: #name:!attributes!private! !
!WebImageMap categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebImageMap categoriesFor: #randomName!private! !
!WebImageMap categoriesFor: #shouldIdent!private! !

!WebImageMap class methodsFor!

new
	^super new initialize! !
!WebImageMap class categoriesFor: #new!instance creation!private! !

WebList guid: (GUID fromString: '{0B2BD486-326A-45E2-ACFF-635D4B67F473}')!
WebList comment: ''!
!WebList categoriesForClass!Unclassified! !
!WebList methodsFor!

add: anElement
	"ensure always WebListItem as subelement of list"
	| element |
	element := (anElement class == WebListItem)
		ifTrue: [anElement] 
		ifFalse: [WebListItem newListItem add: anElement; yourself].
	^super add: element!

addDefinition: anElement
	"ensure always WebListItem as subelement of list"
	| element |
	element := (anElement class == WebListItem)
		ifTrue: [anElement setDefinition] 
		ifFalse: [WebListItem newDefinition add: anElement; yourself].
	^super add: element!

addDefinitionTerm: anElement
	"ensure always WebListItem as subelement of list"
	| element |
	element := (anElement class == WebListItem)
		ifTrue: [anElement setDefinitionTerm] 
		ifFalse: [WebListItem newDefinitionTerm add: anElement; yourself].
	^super add: element!

addLinkTo: anObject text: aString 
	"add new line to the list with text and link to some object" 
	| line |
	line := WebListItem new.
	line	addLinkTo: anObject text: aString.
	self add: line!

addLinkTo: anObject text: aString class: aSymbol
	"add new line to the list with text and link to some object. Set class for CSS too" 
	| line |
	line := WebListItem new class: aSymbol.
	line	addLinkTo: anObject text: aString.
	self add: line!

addLinkTo: anObject text: aString id: aSymbol
	"add new line to the list with text and link to some object. set id too" 
	| line |
	line := WebListItem new id: aSymbol.
	line	addLinkTo: anObject text: aString.
	self add: line!

addLinkTo: anObject text: aString withBullet: anImageOrURL
	"add new line to the list with bullet image and text and link to some object" 
	| line |
	line := WebListItem new.
	line add: (WebImage image: anImageOrURL); add: (WebLink text: aString linkTo: anObject).
	self  add: line!

addText: aString
	"make a new element with aString. Attributes are same as previous text." 
	| line |
	line := WebListItem new.
	line addText: aString.
	self  add: line!

addText: aString class: aSymbol
	"add list item with specified text. set class for CSS to that item too" 
	| line |
	line := WebListItem new class: aSymbol.
	line addText: aString.
	self  add: line!

addText: aString id: aSymbol
	"add list item with specified text. set id to that item too" 
	| line |
	line := WebListItem new id: aSymbol.
	line addText: aString.
	self  add: line!

addText: aString withBullet: anImageOrURL
	"add new line to the list with bullet image and text" 
	| line |
	line := WebListItem new.
	line add: (WebImage image: anImageOrURL); addText: aString.
	self  add: line!

initialize
	kind := #definition.   
!

kind
	^kind!

kind: aSymbol
	"should be #ordered, #unordered, #definition. By default is #definition"

	kind := aSymbol.!

name
	^name!

name:  aString
	"set the name of this list. Used for accessing the selections from WebForm or WebApplication"

	name := aString.!

printHTMLPageOn: aStream forSession: aSession
	| tag |
	self prepareToHTMLPrintOn: aSession. 
	self kind == #ordered ifTrue: [tag := 'ol'].
	self kind == #unordered ifTrue: [tag := 'ul'].
	self kind == #definition ifTrue: [tag := 'dl'].
	aStream nextPutAll: self ident, '<', tag.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</', tag, '>', self eol.!

shouldIdent
	^true! !
!WebList categoriesFor: #add:!adding/removing!private! !
!WebList categoriesFor: #addDefinition:!adding/removing!private! !
!WebList categoriesFor: #addDefinitionTerm:!adding/removing!private! !
!WebList categoriesFor: #addLinkTo:text:!adding/removing!private! !
!WebList categoriesFor: #addLinkTo:text:class:!adding/removing!private! !
!WebList categoriesFor: #addLinkTo:text:id:!adding/removing!private! !
!WebList categoriesFor: #addLinkTo:text:withBullet:!adding/removing!private! !
!WebList categoriesFor: #addText:!adding/removing!private! !
!WebList categoriesFor: #addText:class:!adding/removing!private! !
!WebList categoriesFor: #addText:id:!adding/removing!private! !
!WebList categoriesFor: #addText:withBullet:!adding/removing!private! !
!WebList categoriesFor: #initialize!initialize-release!private! !
!WebList categoriesFor: #kind!accessing!private! !
!WebList categoriesFor: #kind:!accessing!private! !
!WebList categoriesFor: #name!accessing!private! !
!WebList categoriesFor: #name:!accessing!private! !
!WebList categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebList categoriesFor: #shouldIdent!private!testing! !

!WebList class methodsFor!

kind: aSymbol
	"should be #ordered, #unordered, #definition"

	^self new initialize kind: aSymbol!

new
	^super new initialize!

newDefinition
	^self kind: #definition!

newOrdered
	^self kind: #ordered!

newUnordered
	^self kind: #unordered! !
!WebList class categoriesFor: #kind:!instance creation!private! !
!WebList class categoriesFor: #new!instance creation!private! !
!WebList class categoriesFor: #newDefinition!instance creation!private! !
!WebList class categoriesFor: #newOrdered!instance creation!private! !
!WebList class categoriesFor: #newUnordered!instance creation!private! !

WebListItem guid: (GUID fromString: '{DAAC29DF-7518-45E6-9D92-B7486C1B99A4}')!
WebListItem comment: ''!
!WebListItem categoriesForClass!Unclassified! !
!WebListItem methodsFor!

initialize
	self setListItem!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession. 
	aStream nextPutAll: self ident, '<', self tag.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>'.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</', self tag, '>', self eol.!

setDefinition
	self tag: 'dd'!

setDefinitionTerm
	self tag: 'dt'!

setListItem
	self tag: 'li'!

shouldIdent
	^false!

tag
	^tag!

tag: aString
	tag := aString! !
!WebListItem categoriesFor: #initialize!initialize-release!private! !
!WebListItem categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebListItem categoriesFor: #setDefinition!accessing!private! !
!WebListItem categoriesFor: #setDefinitionTerm!accessing!private! !
!WebListItem categoriesFor: #setListItem!accessing!private! !
!WebListItem categoriesFor: #shouldIdent!private!testing! !
!WebListItem categoriesFor: #tag!accessing!private! !
!WebListItem categoriesFor: #tag:!accessing!private! !

!WebListItem class methodsFor!

new
	^super new initialize!

newDefinition
	^self new setDefinition "dd"!

newDefinitionTerm
	^self new setDefinitionTerm "dt"!

newListItem
	^self new setListItem "li"! !
!WebListItem class categoriesFor: #new!instance creation!private! !
!WebListItem class categoriesFor: #newDefinition!instance creation!private! !
!WebListItem class categoriesFor: #newDefinitionTerm!instance creation!private! !
!WebListItem class categoriesFor: #newListItem!instance creation!private! !

WebPage guid: (GUID fromString: '{F6D400C6-7CA1-4A84-BDA4-88F7A3DD3F5E}')!
WebPage comment: ''!
!WebPage categoriesForClass!Unclassified! !
!WebPage methodsFor!

addHeader: aTagString value: aString
	self headers isNil ifTrue: [self initHeaders].
	self headers add: (aTagString -> aString)!

addJavascript: aScriptString
	self addScriptWithParms: 'language="JavaScript" type="text/javascript"' script: aScriptString!

addLinkToAlternateScreenStyleSheet: anObjectOrUrl
	| url |
	url := anObjectOrUrl isString
		ifTrue: [anObjectOrUrl]
		ifFalse: [self site urlResolver halfUrlFor: anObjectOrUrl].
	self addHeader: 'link' value: 'rel="alternate stylesheet" type="text/css" media="screen" href="', url, '" '!

addLinkToJavascript: anObjectOrUrl
	| url |
	url := anObjectOrUrl isString
		ifTrue: [anObjectOrUrl]
		ifFalse: [self site urlResolver halfUrlFor: anObjectOrUrl].
	self addScriptWithParms: ' src="', url, '" language="JavaScript" type="text/javascript"' script: ''.!

addLinkToPrintStyleSheet: anObjectOrUrl
	| url |
	url := anObjectOrUrl isString
		ifTrue: [anObjectOrUrl]
		ifFalse: [self site urlResolver halfUrlFor: anObjectOrUrl].
	self addHeader: 'link' value: 'rel="stylesheet" type="text/css" media="print" href="', url, '" '!

addLinkToScreenStyleSheet: anObjectOrUrl
	| url |
	url := anObjectOrUrl isString
		ifTrue: [anObjectOrUrl]
		ifFalse: [self site urlResolver halfUrlFor: anObjectOrUrl].
	self addHeader: 'link' value: 'rel="stylesheet" type="text/css" media="screen" href="', url, '" '!

addMetaContentType: aString
	"example: 'text/html; charset=iso8859-2'"
	self addHeader: 'meta' value: 'http-equiv="Content-Type"  content="', aString, '" '!

addMetaDescription: aString
	self addHeader: 'meta' value: 'name="description" content="', aString, '"'!

addMetaKeywords: aString
	"keywords separated with , "
	self addHeader: 'meta' value: 'name="keywords" content="', aString, '"'!

addScriptWithParms: aString script: aScriptString
	self headers isNil ifTrue: [self initHeaders].
	self headers add: ('script' -> (Array with: aString with: aScriptString) )!

alink: aSymbol
	"set the color of active link text. It can be in hex format (for example #00FF00) 
	or name of color (for example #White)"
	self attributesAt: #alink put: (self colorValue: aSymbol)!

alinkColor: aSymbol
	self alink: aSymbol.!

app
	"return anApplication on which we are composing this web page"
	self session isNil ifTrue: [^nil].
	^self session lastApp!

background: anImageOrURL
	"set the URL for the background image"
	self attributesAt: #background put:
		(anImageOrURL isString 
			ifTrue: [anImageOrURL]
			ifFalse: [self site urlResolver halfUrlFor: anImageOrURL]).!

bgColor: aSymbol
	"set the color of page background)"
	self attributesAt: #bgcolor put: (self colorValue: aSymbol)!

bgImage: anImageOrURL
	self background: anImageOrURL.!

cleanup
	"clear all elements and web table info, when page is not needed anymore"
	self initElements.
	self initAttributes.
	self script: nil.
	self initPageHeaderLinks.
	self clearTableInfo.!

contentType
	"return 'text/html' as content type for web pages"
	^'text/html'!

headers
	^headers!

identDepth
	identDepth isNil ifTrue: [self identDepth: 0].
	^identDepth!

identDepth: aNumber
	"current depth of identation. IF 0, the we are at the start of the line"
	identDepth := aNumber!

initHeaders
	headers := OrderedCollection new.!

initialize
	title := ''.!

initPageHeaderLinks
	headers := nil.
	self site isNil ifTrue: [^nil].
"	self addMetaContentType: 'text/html; charset=iso-8859-2'."
	self addMetaContentType: 'text/html; charset=UTF-8'.
	self addLinkToScreenStyleSheet: self site style screenCssResource.
	self addLinkToPrintStyleSheet: self site style printCssResource.
	self addLinkToJavascript: self site style javascriptResource.!

isComposite

	"a WebPage is a composite element"
	^true!

isNewline
	^self identDepth = 0!

isWapDocument
	^false!

isWebPage
	^true!

link: aSymbol
	"set the color of link text."
	self attributesAt: #link put: (self colorValue: aSymbol).!

linkColor: aSymbol
	self vlink: aSymbol.!

name
	^name!

name: aString

	"name is relative URL of this web page. It is used for automatic  object reference to URL resolution.
Examples:
1. If the page name is 'example' then direct url for it is:
	http://www.any.com/cgi-bin/stweb?demo/example.html

2. A link from this page to page 'mypage' will be:
	http://www.any.com/cgi-bin/stweb?demo/example/mypage.html
"

	name := aString.      
	title = '' ifTrue: [title := name.    ].	"default title"!

postInitialize
	self initPageHeaderLinks!

printDummyJavascriptSnippetOn: aStream
| snippet |
	snippet :=
'<script language="JavaScript">
...
</script>'.
	aStream nextPutAll: snippet!

printHeaderElementsOn: aStream
	self headers isNil ifTrue: [^self].
	self headers do: [:assoc | 
		aStream nextPutAll: '  <', assoc key, ' '.
		assoc key = 'script' 
			ifTrue: [| array | array := assoc value class == Array 
				ifTrue: [assoc value] ifFalse: [Array with: assoc value with: ''].
				aStream nextPutAll: (array at: 1), '>', (array at: 2), '</script>']
			ifFalse: [aStream nextPutAll: assoc value, '>'].
		aStream nextPutAll: self eol].!

printHTMLPageOn: aStream forSession: aSession
	aStream 
		nextPutAll: '<!!-- AIDA/Web, Smalltalk Web Application Server -->', self eol;
		nextPutAll: '<!!-- (C) EraNova d.o.o., Ljubljana, Slovenia (www.eranova.si) -->', self eol.
	aStream 
		nextPutAll: '<html>', self eol, ' <head>', self eol;
		nextPutAll: '  <title>' ,  (AIDASite convertToWeb: title on: aSession), '</title>', self eol.
	self printHeaderElementsOn: aStream.
	self script notNil ifTrue: [aStream nextPutAll: self script. self eol].
	aStream nextPutAll: ' </head>', self eol.
	aStream nextPutAll: ' <body'. self printAttributesOn: aStream for: aSession. 
	aStream nextPutAll: '>', self eol.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll:  self ident, ' </body>', self eol, '</html>', self eol.
	self cleanup.!

printWebPageFor: aSession
	^self!

redirectAfter: aSecondsNumber toUrl: aString
	"redirection or refresh of specified url, does not work on Mozilla!! "
	self addHeader: 'meta' value: 'http-equiv="REFRESH"  content="', 
		aSecondsNumber printString, '; url=', aString, '" '!

script
	"script element, together with opening and closing tag!!"
	^script!

script: aString
	script := aString.!

session
	"reference to a session on which this page is created"
	^session!

session: aSession
	session := aSession!

setNewline
	self identDepth: 0!

shouldIdent
	^false!

text: aSymbol
	"set the color of page text."
	self attributesAt: #text put: (self colorValue: aSymbol).!

textColor: aSymbol
	self text: aSymbol.!

title
	^title!

title: aString
	title := aString convertToSloveneChars.!

vlink: aSymbol
	"set the color of visited link text."
	self attributesAt: #vlink put: (self colorValue: aSymbol).!

vlinkColor: aSymbol
	self vlink: aSymbol.! !
!WebPage categoriesFor: #addHeader:value:!private! !
!WebPage categoriesFor: #addJavascript:!header elements!private! !
!WebPage categoriesFor: #addLinkToAlternateScreenStyleSheet:!header elements!private! !
!WebPage categoriesFor: #addLinkToJavascript:!header elements!private! !
!WebPage categoriesFor: #addLinkToPrintStyleSheet:!header elements!private! !
!WebPage categoriesFor: #addLinkToScreenStyleSheet:!header elements!private! !
!WebPage categoriesFor: #addMetaContentType:!header elements!private! !
!WebPage categoriesFor: #addMetaDescription:!header elements!private! !
!WebPage categoriesFor: #addMetaKeywords:!header elements!private! !
!WebPage categoriesFor: #addScriptWithParms:script:!private! !
!WebPage categoriesFor: #alink:!attributes!private! !
!WebPage categoriesFor: #alinkColor:!attributes!private! !
!WebPage categoriesFor: #app!accessing!private! !
!WebPage categoriesFor: #background:!attributes!private! !
!WebPage categoriesFor: #bgColor:!attributes!private! !
!WebPage categoriesFor: #bgImage:!attributes!private! !
!WebPage categoriesFor: #cleanup!initialize - release!private! !
!WebPage categoriesFor: #contentType!accessing!private! !
!WebPage categoriesFor: #headers!private! !
!WebPage categoriesFor: #identDepth!private! !
!WebPage categoriesFor: #identDepth:!private! !
!WebPage categoriesFor: #initHeaders!private! !
!WebPage categoriesFor: #initialize!initialize - release!private! !
!WebPage categoriesFor: #initPageHeaderLinks!initialize - release!private! !
!WebPage categoriesFor: #isComposite!private!testing! !
!WebPage categoriesFor: #isNewline!private! !
!WebPage categoriesFor: #isWapDocument!private!testing! !
!WebPage categoriesFor: #isWebPage!private!testing! !
!WebPage categoriesFor: #link:!attributes!private! !
!WebPage categoriesFor: #linkColor:!attributes!private! !
!WebPage categoriesFor: #name!accessing!private! !
!WebPage categoriesFor: #name:!accessing!private! !
!WebPage categoriesFor: #postInitialize!initialize - release!private! !
!WebPage categoriesFor: #printDummyJavascriptSnippetOn:!header elements!private! !
!WebPage categoriesFor: #printHeaderElementsOn:!printing!private! !
!WebPage categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebPage categoriesFor: #printWebPageFor:!printing!private! !
!WebPage categoriesFor: #redirectAfter:toUrl:!header elements!private! !
!WebPage categoriesFor: #script!accessing!private! !
!WebPage categoriesFor: #script:!accessing!private! !
!WebPage categoriesFor: #session!accessing!private! !
!WebPage categoriesFor: #session:!private! !
!WebPage categoriesFor: #setNewline!private! !
!WebPage categoriesFor: #shouldIdent!private!testing! !
!WebPage categoriesFor: #text:!attributes!private! !
!WebPage categoriesFor: #textColor:!attributes!private! !
!WebPage categoriesFor: #title!accessing!private! !
!WebPage categoriesFor: #title:!accessing!private! !
!WebPage categoriesFor: #vlink:!attributes!private! !
!WebPage categoriesFor: #vlinkColor:!attributes!private! !

!WebPage class methodsFor!

buildNotFoundPage

	"this page report an URL not found error"

	| page |
	page := WebPage new.
	page
		name: 'URLNotFound';
		title: 'URL not found error'.
	page
		add: 
			((WebText
				text: 'Error')
				header: 1);
		add: (WebSeparator rulerSize: 5);
		add:
			((WebText 
				text: 'Document with this URL not found on our server, 
						Please correct and try again. Thank you.')
				attributes: #bold);
		add: (WebSeparator rulerSize: 5);
		add:
			((WebText
				text: 'AIDA/Web, Smalltalk Web Server, (C) EraNova d.o.o., Ljubljana, Slovenia')).

	^page!

initWellKnownPages

	"make a dictionary of well known pages, such as error reporting etc."

	WellKnownPages := Dictionary new.
	WellKnownPages at: #URLNotFound put: self buildNotFoundPage.

"WebPage initWellKnownPages"!

new
	^super new initialize!

newOn: aSession
	^self new session: aSession!

wellKnownPages

	"return a dictionary of well known WebPages, such as error reporting 	pages etc."

"	(WellKnownPages notNil)
		ifTrue: [^WellKnownPages]
		ifFalse: [self initWellKnownPages. #WellKnownPages]
"
	self initWellKnownPages.
	^WellKnownPages! !
!WebPage class categoriesFor: #buildNotFoundPage!initialize!private! !
!WebPage class categoriesFor: #initWellKnownPages!initialize!private! !
!WebPage class categoriesFor: #new!instance creation!private! !
!WebPage class categoriesFor: #newOn:!instance creation!private! !
!WebPage class categoriesFor: #wellKnownPages!accessing!private! !

WebScript guid: (GUID fromString: '{3E26B19C-8F47-4B49-B585-5AD398D0A0F7}')!
WebScript comment: ''!
!WebScript categoriesForClass!Unclassified! !
!WebScript methodsFor!

printHTMLPageOn: aStream forSession: aSession
	aStream nextPutAll: '<script type="text/javascript">'. 
	script notNil ifTrue: [aStream nextPutAll: script].
	aStream nextPutAll: '</script>', self eol.!

script
	^script!

script: aString
	"add to others if already exists, separate with JavaScript separator ; "
	script isNil ifTrue: [script := ''].
	(script notEmpty and: [script trimBlanks last = $; ]) ifFalse: [script := script, '; '].
	script := script, aString! !
!WebScript categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebScript categoriesFor: #script!accessing!private! !
!WebScript categoriesFor: #script:!accessing!private! !

!WebScript class methodsFor!

script: aString
	^super new script: aString! !
!WebScript class categoriesFor: #script:!instance creation!private! !

WebSeparator guid: (GUID fromString: '{327DBE8B-77FE-49E3-8411-E531024BC69D}')!
WebSeparator comment: ''!
!WebSeparator categoriesForClass!Unclassified! !
!WebSeparator methodsFor!

printHTMLPageOn: aStream forSession: aSession
	| tag |
	self prepareToHTMLPrintOn: aSession. 
	type = #paragraph ifTrue: [tag := 'p'].
	type = #break ifTrue: [tag := 'br'].
	type = #ruler ifTrue: [tag := 'hr'].
	aStream nextPutAll: self ident, '<', tag.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.!

shouldIdent
	^self type ~= #break!

size: aNumber
	"size of a ruler"
	self attributesAt: #size put: aNumber printString.!

type
	^type!

type: aSymbol
	"#ruler #paragraph #break"
	type := aSymbol.! !
!WebSeparator categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebSeparator categoriesFor: #shouldIdent!private!testing! !
!WebSeparator categoriesFor: #size:!attributes!private! !
!WebSeparator categoriesFor: #type!accessing!private! !
!WebSeparator categoriesFor: #type:!accessing!private! !

!WebSeparator class methodsFor!

break
	
	^ self new type: #break!

paragraph
	
	^ self new type: #paragraph!

rulerSize: aNumber
	
	^(self new) type: #ruler; size: aNumber! !
!WebSeparator class categoriesFor: #break!instance creation!private! !
!WebSeparator class categoriesFor: #paragraph!instance creation!private! !
!WebSeparator class categoriesFor: #rulerSize:!instance creation!private! !

WebTable guid: (GUID fromString: '{97508A55-32C2-47A3-A4C9-6DB1998319A7}')!
WebTable comment: ''!
!WebTable categoriesForClass!Unclassified! !
!WebTable methodsFor!

bgColor: aColorSymbol
	self attributesAt: #bgcolor put: (self colorValue: aColorSymbol)!

border: aNumber
	"set the width of table border. default is 0"
	self attributesAt: #border put: aNumber printString.!

cellPadding: aNumber
	"define spacing between vertically adjacent cells"
	self attributesAt: #cellpadding put: aNumber printString.!

cellSpacing: aNumber
	"define spacing between adjacent cells horizontally"
	self attributesAt: #cellspacing put: aNumber printString.!

color: aColorSymbol
	self	bgColor: aColorSymbol!

height: aNumber
	| text |
	text := aNumber <= 1 
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #height put: text!

initialize
	"self border: 0."!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession. 
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self ident, '<table'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</table>', self eol.
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].!

shouldIdent
	^true!

width: aNumber
	"set the width of entire table If nil, then table automaticaly addjust itself. 
	If number is between 0 and 1 then width is percent of document width.
	If number above 1 then width in pixels"
	| text |
	text := aNumber <= 1 
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #width put: text! !
!WebTable categoriesFor: #bgColor:!attributes!private! !
!WebTable categoriesFor: #border:!attributes!private! !
!WebTable categoriesFor: #cellPadding:!attributes!private! !
!WebTable categoriesFor: #cellSpacing:!attributes!private! !
!WebTable categoriesFor: #color:!attributes!private! !
!WebTable categoriesFor: #height:!attributes!private! !
!WebTable categoriesFor: #initialize!initialize-release!private! !
!WebTable categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebTable categoriesFor: #shouldIdent!private!testing! !
!WebTable categoriesFor: #width:!attributes!private! !

!WebTable class methodsFor!

new
	^super new initialize! !
!WebTable class categoriesFor: #new!instance creation!private! !

WebTableCell guid: (GUID fromString: '{AA4D69AC-1969-416A-9337-18FDE04F8E41}')!
WebTableCell comment: ''!
!WebTableCell categoriesForClass!Unclassified! !
!WebTableCell methodsFor!

align: aSymbol
	"set a horizontal aligment if cell content. It can be #left, #center or #right"
	self attributesAt: #align put: aSymbol asString.!

background: aWebImage
	"bachground image"
	self attributesAt: #background put:
		(((aWebImage isKindOf: WebImage) ifTrue: [aWebImage] ifFalse: [WebImage image: aWebImage]) 
			urlOnSession: self session)!

bgColor: aColorSymbol
	"set the color of table cell background. It can be in hex format (for example #00FF00) 
	or name of color (for example #White)"
	self attributesAt: #bgcolor put: (self colorValue: aColorSymbol)!

color: aColorSymbol
	self	bgColor: aColorSymbol!

colspan: aNumber
	"set the number of columns this cell will span"
	self attributesAt: #colspan put: aNumber printString.!

height: aNumber
	| text |
	text := aNumber <= 1 
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #height put: text!

initialize!

isTableHeader
	^false!

nowrap: aBoolean
	"if true then text is not wrapped in new lines of a cell but a cell is expanded to carry all the text"
	self attributesAt: #nowrap put: aBoolean.!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession. 
	aStream nextPutAll: self ident, '<td'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>'.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</td>', self eol.!

rowspan: aNumber
	"set the number of rows this cell will span"
	self attributesAt: #rowspan put: aNumber printString.!

setHeader
	self becomeA: WebTableHeader!

shouldIdent
	^false!

valign: aSymbol
	"set a verttical aligment if cell content. It can be #top, #middle, #bottom or #centerline"
	self attributesAt: #valign put: aSymbol asString.!

width: aNumber
	"set the width of a cell. If nil, then cell automaticaly addjust itself. 
	If number is between 0 and 1 then width is percent of table width. 
	If number above 1 then width in pixels"
	| text |
	text := aNumber <= 1 
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #width put: text! !
!WebTableCell categoriesFor: #align:!attributes!private! !
!WebTableCell categoriesFor: #background:!attributes!private! !
!WebTableCell categoriesFor: #bgColor:!attributes!private! !
!WebTableCell categoriesFor: #color:!attributes!private! !
!WebTableCell categoriesFor: #colspan:!attributes!private! !
!WebTableCell categoriesFor: #height:!attributes!private! !
!WebTableCell categoriesFor: #initialize!initialize-release!private! !
!WebTableCell categoriesFor: #isTableHeader!private!testing! !
!WebTableCell categoriesFor: #nowrap:!attributes!private! !
!WebTableCell categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebTableCell categoriesFor: #rowspan:!attributes!private! !
!WebTableCell categoriesFor: #setHeader!attributes!private! !
!WebTableCell categoriesFor: #shouldIdent!private!testing! !
!WebTableCell categoriesFor: #valign:!attributes!private! !
!WebTableCell categoriesFor: #width:!attributes!private! !

!WebTableCell class methodsFor!

new
	^super new initialize! !
!WebTableCell class categoriesFor: #new!instance creation!private! !

WebTableRow guid: (GUID fromString: '{931B549A-E463-45D6-A2C7-922187AD69AA}')!
WebTableRow comment: ''!
!WebTableRow categoriesForClass!Unclassified! !
!WebTableRow methodsFor!

align: aSymbol
	"set a horizontal aligment for all cells in this row. It can be #left, #center or #right"
	self attributesAt: #align put: aSymbol asString.!

bgColor: aColorSymbol
	"set the color of table row background. It can be in hex format (for example #00FF00) 
	or name of color (for example #White)"
	self attributesAt: #bgcolor put: (self colorValue: aColorSymbol)!

color: aColorSymbol
	self	bgColor: aColorSymbol!

height: aNumber
	| text |
	text := aNumber <= 1 
			ifTrue: [(aNumber * 100) asInteger printString, '%']
			ifFalse: [aNumber asInteger printString].
	self attributesAt: #height put: text!

initialize!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession. 
	aStream nextPutAll: self ident, '<tr'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>', self eol.
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll: self ident, '</tr>', self eol.!

shouldIdent
	^true!

valign: aSymbol
	"set a vertical aligment for all cells in this row. It can be #top, #middle, #bottom or #baseline"
	self attributesAt: #valign put: aSymbol asString.! !
!WebTableRow categoriesFor: #align:!attributes!private! !
!WebTableRow categoriesFor: #bgColor:!attributes!private! !
!WebTableRow categoriesFor: #color:!attributes!private! !
!WebTableRow categoriesFor: #height:!attributes!private! !
!WebTableRow categoriesFor: #initialize!initialize-release!private! !
!WebTableRow categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebTableRow categoriesFor: #shouldIdent!private!testing! !
!WebTableRow categoriesFor: #valign:!attributes!private! !

!WebTableRow class methodsFor!

new
	^super new initialize! !
!WebTableRow class categoriesFor: #new!instance creation!private! !

WebText guid: (GUID fromString: '{5CE6A623-B528-4CC3-8BD9-71521B9AFAF9}')!
WebText comment: ''!
!WebText categoriesForClass!Unclassified! !
!WebText methodsFor!

addText: aString
	"make a new element with aString. Attributes are same as previous text." 

	self add: (WebText text: aString attributes: self attributes)!

addText: aString attributes: anArray
	"make a new element with aString. Attributes are same as previous text." 

	self add: (WebText text: aString attributes: anArray)!

color: aString
	self style: '{color: ', aString asString, '}'.!

font
	^font!

font: aString
	font := aString!

header
	^header!

header: aNumber
	
	"Assigns this WebText as a header text. Parameter can be 1 .. 5. If this parameter is nil then WebText is not a header"

	aNumber < 1 
		ifTrue: [header:= 1.   ]
		ifFalse:
			[aNumber > 5 ifTrue: [header := 5.] ifFalse: [header := aNumber.]].
	^self!

initialize
	text := ''.   
	paragraph := false.!

insideSpanTag
	"to enclose or not in span tag. Only if element have any attribute!!"
	^self attributes notNil and: [self isLink not]!

isLink
	^false!

paragraph
	^paragraph!

paragraph: aBoolean
	
	"call this method if you want this text in a new paragraph"

	paragraph := aBoolean.!

printHTMLPageOn: aStream forSession: aSession
	"make a header"
	self prepareToHTMLPrintOn: aSession. 
	aStream nextPutAll: self ident.
	self insideSpanTag ifTrue: 
		[aStream nextPutAll: '<span'. self printAttributesOn: aStream for: aSession. aStream nextPutAll: '>'].
	header notNil ifTrue: [aStream nextPutAll: '<h', header printString, '>'].
	"font size, color, face"
	(size notNil | font notNil ) ifTrue:
		[aStream nextPutAll: '<font '.
		size notNil ifTrue:
			[aStream nextPutAll: 'size=', (size > 0 ifTrue: ['+'] ifFalse: ['']),	size printString, ' '].
		font notNil ifTrue:	[aStream nextPutAll: 'face=', font, ' '].
		aStream nextPutAll: '> ' ].
	"set text attributes, if any"
	textAttributes notNil ifTrue: 
		[textAttributes do: [:attribute |  aStream nextPutAll: '<', (AttributeMarkup at: attribute), '>']].
	"print a text"
	text notNil ifTrue: [aStream nextPutAll: (AIDASite convertToWeb: text on: aSession)].
	"print composite elements"
	super printHTMLPageOn: aStream forSession: aSession.
	"reset text attributes"
	textAttributes notNil ifTrue: 
		[textAttributes do: [:attribute |  aStream nextPutAll: '</', (AttributeMarkup at: attribute), '>']].
	"end of font adjustment"
	(size notNil | font notNil ) ifTrue: [aStream nextPutAll: '</font>'].
	header notNil ifTrue: [aStream nextPutAll: '</h', header printString, '>', self eol].
	self insideSpanTag ifTrue: [aStream nextPutAll: '</span>', self eol].!

printString

	^'''', [self text isNil ifTrue: [''] ifFalse: [self text] ] value,''''!

shouldIdent
	^false!

size
	^size!

size: aNumber
	
	"larger or smaller text for aNumber factor. Range -7..+7"

	aNumber < -7 
		ifTrue: [size := -7.  ]
		ifFalse:
			[aNumber > 7 ifTrue: [size := 7.  ] ifFalse: [size := aNumber.]].
	^self!

text
	^text!

text: aString
	text := WebFormElement autoConvertToString: aString.
	"slovene csz are converted if char ^ is after such a char"
	(text includes: $^ ) ifTrue: [text := text convertToSloveneChars].!

text: aString attributes: anArray
	self text: aString.
	self textAttributes: anArray.!

textAttributes
	"get the attributes of a text" 
	^textAttributes!

textAttributes: anArray
	"check and set the attributes of a text. Atribute can be one or a set of them. Attribute is ignored if not correct. See class variable AttributeMarkup or method WebText initialize for list of allowed attributes" 

	(anArray isKindOf: Symbol)		"if only one attribute, convert to an Array"
		ifTrue: [textAttributes := Array with: anArray.       ]
		ifFalse: [(anArray isKindOf: Array)
			ifTrue: [textAttributes := anArray.      ]
			ifFalse: [anArray isNil
				ifTrue: [textAttributes := nil.     ]
				ifFalse: 
					[Smalltalk error: 'Text attributes should be Array of Symbols']]].

	"attribute correctness check. Ignore if attribute not correct"
	textAttributes isNil ifFalse:
		[textAttributes := textAttributes select:
			[:attribute | (AttributeMarkup  at: attribute ifAbsent: [false])  ~~ false ].    ]

"WebText text: 'test' attributes: #bold"
"WebText text: 'test' attributes: #( #bold #italic)"
"WebText text: 'test' attributes: nil"! !
!WebText categoriesFor: #addText:!accessing!private! !
!WebText categoriesFor: #addText:attributes:!accessing!private! !
!WebText categoriesFor: #color:!accessing!private! !
!WebText categoriesFor: #font!accessing!private! !
!WebText categoriesFor: #font:!accessing!private! !
!WebText categoriesFor: #header!accessing!private! !
!WebText categoriesFor: #header:!accessing!private! !
!WebText categoriesFor: #initialize!initialize-release!private! !
!WebText categoriesFor: #insideSpanTag!private! !
!WebText categoriesFor: #isLink!private!testing! !
!WebText categoriesFor: #paragraph!accessing!private! !
!WebText categoriesFor: #paragraph:!accessing!private! !
!WebText categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebText categoriesFor: #printString!printing!private! !
!WebText categoriesFor: #shouldIdent!private! !
!WebText categoriesFor: #size!accessing!private! !
!WebText categoriesFor: #size:!accessing!private! !
!WebText categoriesFor: #text!accessing!private! !
!WebText categoriesFor: #text:!accessing!private! !
!WebText categoriesFor: #text:attributes:!accessing!private! !
!WebText categoriesFor: #textAttributes!private! !
!WebText categoriesFor: #textAttributes:!private! !

!WebText class methodsFor!

example1
	"examples of use a WebText."

	| text stream |
	text := WebText header: 1 text: 'Hello' .
	text addText: 'String Hello' attributes: #bold.
	text addText: 'String and Italic Hello' attributes: #(#bold #italic).
"	text addText: 'Strong Hello again' prevAttributes."

	stream := WriteStream on: String new.
	text printHTMLPageOn: stream.
	^stream contents.!

header: aNumber

	"create an empty header. You can add elements such as images and text later"

	^(self new) header: aNumber.

"| a | 
a := (WebText header: 1).
a add: (WebImage urlReference: 'http://pu/stefan.gif').
a inspect"!

header: aNumber text: aString

	"create a header text"

	^(self new) header: aNumber; text: aString.

"WebText header: 1 text: 'test'"!

initialize
	"set the AttributeMarkup dictionary with the allowed atributes and their HTML markup symbols"
	AttributeMarkup := IdentityDictionary new.
	AttributeMarkup
		at: #bold		put: 'b';
		at: #italic		put: 'I';
		at: #teletype 	put: 'tt';
		at: #address 	put: 'address';
		at: #cite			put: 'cite';
		at: #code		put: 'code';
		at: #sequence 	put: 'samp';
		at: #blockquote 	put: 'blockquote';
		at: #definition 	put: 'dfn';
		at: #emphasized put: 'em';
		at: #keyboard 	put: 'kbd';
		at: #strong 		put: 'strong';
		at: #variable 	put: 'var'.

"WebText initialize"!

new
	^super new initialize!

newParagraph

	"To open a new paragraph. Use addText: for adding a paragraph text."

	^self new paragraph: true.!

text: aString
	^self new text: aString

"WebText text: 'test'"!

text: aString attributes: anArray

	^self new text: aString attributes: anArray

"WebText text: 'test' attributes: #bold"! !
!WebText class categoriesFor: #example1!examples!private! !
!WebText class categoriesFor: #header:!instance creation!private! !
!WebText class categoriesFor: #header:text:!instance creation!private! !
!WebText class categoriesFor: #initialize!initialization!private! !
!WebText class categoriesFor: #new!instance creation!private! !
!WebText class categoriesFor: #newParagraph!instance creation!private! !
!WebText class categoriesFor: #text:!instance creation!private! !
!WebText class categoriesFor: #text:attributes:!instance creation!private! !

WebButton guid: (GUID fromString: '{D8414B74-4500-4043-8E67-D82D7CDFAA93}')!
WebButton comment: ''!
!WebButton categoriesForClass!Unclassified! !
!WebButton methodsFor!

action: aSymbol
	self name: aSymbol asString!

initialize
	self type: 'submit'.!

isButton
	^true!

isEmpty
	^true!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	aStream nextPutAll: self ident, '<input'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>'.
"
	super printHTMLPageOn: aStream forSession: aSession.
	aStream nextPutAll:  '</button>'.
"!

shouldIdent
	^false!

text
	^self attributesAt: #value!

text: aString
	"set the text to be shown in a button, It is actually a value attribute in input tag"
	| txt |
	"slovene csz are converted if char ^ is after such a char"
	txt := (aString includes: $^ ) ifTrue: [aString convertToSloveneChars] ifFalse: [aString].
	self attributesAt: #value put: txt.
	self addText: txt! !
!WebButton categoriesFor: #action:!accessing!private! !
!WebButton categoriesFor: #initialize!initialize-release!private! !
!WebButton categoriesFor: #isButton!private!testing! !
!WebButton categoriesFor: #isEmpty!private!testing! !
!WebButton categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebButton categoriesFor: #shouldIdent!private!testing! !
!WebButton categoriesFor: #text!accessing!private! !
!WebButton categoriesFor: #text:!accessing!private! !

!WebButton class methodsFor!

text: aString

	^self type: #submit text: aString!

text: aString action: aSymbol

	^self type: #submit text: aString action: aSymbol!

type: aSymbol message: aMsgSymbol

	^self new type: aSymbol; message: aMsgSymbol!

type: aSymbol text: aString

	^self new type: aSymbol; text: aString!

type: aSymbol text: aString action: anActionSymbol

	^self new type: aSymbol; text: aString; action: anActionSymbol! !
!WebButton class categoriesFor: #text:!instance creation!private! !
!WebButton class categoriesFor: #text:action:!instance creation!private! !
!WebButton class categoriesFor: #type:message:!instance creation!private! !
!WebButton class categoriesFor: #type:text:!instance creation!private! !
!WebButton class categoriesFor: #type:text:action:!instance creation!private! !

WebCheckBox guid: (GUID fromString: '{C28AFD49-B066-4218-B118-F94D42533028}')!
WebCheckBox comment: ''!
!WebCheckBox categoriesForClass!Unclassified! !
!WebCheckBox methodsFor!

acceptFormInputFrom: aPostDataDictionary
	(aPostDataDictionary at: self name) = 'on' ifTrue: [self checkValue]!

addObjectToSelected
	(self selected includes: self object) ifFalse: [self selected add: self object]!

checked
	^checked!

checked: aBoolean
	checked := aBoolean!

checkValue
	self aspect notNil ifTrue: [self setAspectTrue].
	self selected notNil ifTrue: [self addObjectToSelected]!

initialize
	super initialize.
	self type: 'checkbox'.
	self checked: false.!

isCheckBox
	^true!

isChecked
	| value |
	self aspect notNil ifTrue:
		[value := self object perform: self aspect.
		^value == true].  "so that false will be returned even if value is not so"
	self selected notNil ifTrue: [^self selected includes: self object]. 
	^self checked!

joinToForm: aWebForm
	aWebForm fields keysAndValuesDo: [:fname :element | 
		element == self ifTrue: [self name: fname]. ^self]!

object: anObject from: aCollection
	"if checked, this object will be put in collection. If object is initially in collection, 
	checkbox will be checked"
	"Usefull for easy selection among many objects"
	self object: anObject.
	self selected: aCollection.!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	aStream nextPutAll: self ident, '<input'.
	self printAttributesOn: aStream for: aSession.
	self isChecked ifTrue: [aStream nextPutAll: ' checked'].
	aStream nextPutAll: '>'.!

removeObjectFromSelected
	(self selected includes: self object) ifTrue: [self selected remove: self object]!

selected
	^selected!

selected: aCollection
	"checked objects"
	selected := aCollection!

setAspectFalse
	self object perform: (self aspect asString, ':') asSymbol with: false!

setAspectTrue
	self object perform: (self aspect asString, ':') asSymbol with: true!

setChecked
	self checked: true!

setUnchecked
	self checked: false!

shouldIdent
	^false!

uncheckValue
	self aspect notNil ifTrue: [self setAspectFalse].
	self selected notNil ifTrue: [self removeObjectFromSelected]!

value
	^self attributesAt: 'value'!

value: aString
	"set the value name  of the  check box"
	^self attributesAt: 'value' put: aString! !
!WebCheckBox categoriesFor: #acceptFormInputFrom:!private! !
!WebCheckBox categoriesFor: #addObjectToSelected!private! !
!WebCheckBox categoriesFor: #checked!private! !
!WebCheckBox categoriesFor: #checked:!private! !
!WebCheckBox categoriesFor: #checkValue!private! !
!WebCheckBox categoriesFor: #initialize!initialize-release!private! !
!WebCheckBox categoriesFor: #isCheckBox!private!testing! !
!WebCheckBox categoriesFor: #isChecked!private!testing! !
!WebCheckBox categoriesFor: #joinToForm:!private! !
!WebCheckBox categoriesFor: #object:from:!private! !
!WebCheckBox categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebCheckBox categoriesFor: #removeObjectFromSelected!private! !
!WebCheckBox categoriesFor: #selected!accessing!private! !
!WebCheckBox categoriesFor: #selected:!private! !
!WebCheckBox categoriesFor: #setAspectFalse!private! !
!WebCheckBox categoriesFor: #setAspectTrue!private! !
!WebCheckBox categoriesFor: #setChecked!accessing!private! !
!WebCheckBox categoriesFor: #setUnchecked!accessing!private! !
!WebCheckBox categoriesFor: #shouldIdent!private!testing! !
!WebCheckBox categoriesFor: #uncheckValue!private! !
!WebCheckBox categoriesFor: #value!private! !
!WebCheckBox categoriesFor: #value:!private! !

!WebCheckBox class methodsFor!

aspect: aSymbol for: anObject
	"this method will be called and true/false will be set/clear on an object"
	^self new aspect: aSymbol for: anObject!

object: anObject from: aCollection
	"if checked, this object will be put in collection. If object is initially in collection, 
	checkbox will be checked"
	"Usefull for easy selection among many objects"
	^self new object: anObject from: aCollection! !
!WebCheckBox class categoriesFor: #aspect:for:!instance creation!private! !
!WebCheckBox class categoriesFor: #object:from:!instance creation!private! !

WebInPlaceEditableText guid: (GUID fromString: '{C8649D77-D25F-45AE-B748-9F7C1C518994}')!
WebInPlaceEditableText comment: ''!
!WebInPlaceEditableText categoriesForClass!Unclassified! !
!WebInPlaceEditableText methodsFor!

addSetupScript
	| url urlFormated |
	url := self ajaxCallUrl, '?', (self ajaxCallUrlParametersFor: self id), '&ajaxInPlaceEditing'.
	urlFormated := self isFormated ifTrue: [url, '&wikiFormated'] ifFalse: [url].
	self scriptAfter: 'new Ajax.InPlaceEditor(''', self id asString, 
		''', ''', urlFormated, ''', {', self rowsCols, self textOptions, self externalControl, 
		(self isFormated ifTrue: [',loadTextURL:''', url, ''''] ifFalse: ['']), '})'!

allow
	"is edit allowed at all?"
	allow isNil ifTrue: [^true].
	^allow!

allow: aBoolean
	allow := aBoolean!

attribute
	"<b> etc"
	attribute isNil ifTrue: [^''].
	^attribute!

attribute: aString
	attribute := aString!

bold
	self attribute: '<b>'!

cancelText
	^'Cancel'!

columns
	"length of edit field or textarea"
	self size isNil ifTrue: [^20].
	self size class == Point ifTrue: [^self size x].
	^self size!

endAttributeTag
	self attribute isEmpty ifTrue: [^''].
	^'</', self attribute copyFrom: 3 to: 5!

externalControl
	| idSymbol |
	self triggerElement isNil ifTrue: [^''].
	idSymbol := self triggerElement isSymbol 
		ifTrue: [self triggerElement] ifFalse: [self triggerElement registerId. self triggerElement id].
	^', externalControl:''', idSymbol asString, ''''!

initialize
	super initialize.
	self app style ensureJavascriptForScriptaculousInHeader.
	self app style ensureJsResourceForScriptaculous.!

isFormated
	^formated notNil and: [formated]!

okText
	^'OK'!

printHTMLPageOn: aStream forSession: aSession
	self registerId. 
	self prepareToHTMLPrintOn: aSession.
	self allow ifTrue: [self addSetupScript].
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self startAttributeTag.
	aStream nextPutAll: '<span '. self printAttributesOn: aStream for: aSession. aStream nextPut: $>. 
	aStream nextPutAll: (self properlyFormatedValueOn: aSession).
	aStream nextPutAll: '</span>', self endAttributeTag.
	(self allow and: [self triggerElement isKindOf: WebElement])
		ifTrue: [self triggerElement printHTMLPageOn: aStream forSession: aSession].
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].!

properlyFormatedValueOn: aSession
	| value |
	value := self valueModel value.
	self isFormated ifTrue: [value := value asWikiHtml].
	^AIDASite convertToWeb:  (WebFormElement autoConvertToString: value) on: aSession!

rows
	"number of lines in edit area"
	self size isNil ifTrue: [^1].
	self size class == Point ifTrue: [^self size y].
	^1!

rowsCols
	^'rows:', self rows printString, ',cols:', self columns printString!

savingText
	^'...'!

size
	"if number, then editor is one line, if point, it is text area!!"
	^size!

size: aNumberOrPoint
	"if number, then editor is one line, if point, it is text area!!"
	size := aNumberOrPoint!

startAttributeTag
	^self attribute!

textOptions
	| text |
	text := ', okText:''', self okText, ''', cancelText:''', self cancelText, ''', savingText:''', self savingText, ''''.
	^AIDASite convertToWeb: text on: self app session!

triggerElement
	"element which triggers edit mode. If it is real element and not only id, it will be 
       added after editable text, "
	^triggerElement!

triggerElement: aWebElementOrId
	triggerElement := aWebElementOrId!

wikiFormated
	"source text is formated in wiki format"
	formated := true! !
!WebInPlaceEditableText categoriesFor: #addSetupScript!private! !
!WebInPlaceEditableText categoriesFor: #allow!accessing!private! !
!WebInPlaceEditableText categoriesFor: #allow:!private! !
!WebInPlaceEditableText categoriesFor: #attribute!private! !
!WebInPlaceEditableText categoriesFor: #attribute:!private! !
!WebInPlaceEditableText categoriesFor: #bold!accessing!private! !
!WebInPlaceEditableText categoriesFor: #cancelText!private!settings! !
!WebInPlaceEditableText categoriesFor: #columns!private!settings! !
!WebInPlaceEditableText categoriesFor: #endAttributeTag!private! !
!WebInPlaceEditableText categoriesFor: #externalControl!private! !
!WebInPlaceEditableText categoriesFor: #initialize!initialize-release!private! !
!WebInPlaceEditableText categoriesFor: #isFormated!private! !
!WebInPlaceEditableText categoriesFor: #okText!private!settings! !
!WebInPlaceEditableText categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebInPlaceEditableText categoriesFor: #properlyFormatedValueOn:!private! !
!WebInPlaceEditableText categoriesFor: #rows!private!settings! !
!WebInPlaceEditableText categoriesFor: #rowsCols!private! !
!WebInPlaceEditableText categoriesFor: #savingText!private!settings! !
!WebInPlaceEditableText categoriesFor: #size!private! !
!WebInPlaceEditableText categoriesFor: #size:!accessing!private! !
!WebInPlaceEditableText categoriesFor: #startAttributeTag!private! !
!WebInPlaceEditableText categoriesFor: #textOptions!private! !
!WebInPlaceEditableText categoriesFor: #triggerElement!accessing!private! !
!WebInPlaceEditableText categoriesFor: #triggerElement:!accessing!private! !
!WebInPlaceEditableText categoriesFor: #wikiFormated!accessing!private! !

!WebInPlaceEditableText class methodsFor!

aspect: aSymbol for: anObject
	^self new aspect: aSymbol for: anObject!

aspect: aSymbol for: anObject size: aNumberOrPoint
	^self new aspect: aSymbol for: anObject; size: aNumberOrPoint!

aspect: aSymbol for: anObject size: aNumberOrPoint allow: aBoolean
	^self new aspect: aSymbol for: anObject; 
		size: aNumberOrPoint;
		allow: aBoolean	"is edit allowed at all?"! !
!WebInPlaceEditableText class categoriesFor: #aspect:for:!instance creation!private! !
!WebInPlaceEditableText class categoriesFor: #aspect:for:size:!instance creation!private! !
!WebInPlaceEditableText class categoriesFor: #aspect:for:size:allow:!instance creation!private! !

WebInputField guid: (GUID fromString: '{69948949-EB5C-4921-AEF3-70102FB27D54}')!
WebInputField comment: ''!
!WebInputField categoriesForClass!Unclassified! !
!WebInputField methodsFor!

aspect: aSymbol for: anObject size: aNumber
	^self aspect: aSymbol for: anObject; size: aNumber!

hidden
	^self type = 'hidden'!

hidden: aBoolean
	"make this input field hidden one"
	aBoolean ifTrue: [self type: 'hidden']!

initialize
	super initialize.
	self type: 'text'.!

isHidden
	^self type = 'hidden'!

isInputField
	^true!

isPassword
	^self type = 'password'!

maxLength: aNumber
	"maximum number of characters allowed in this input field"
	self attributesAt: #maxlength put: aNumber printString!

password
	^self type = 'password'!

password: aBoolean
	"if true, then value will not be shown in input field"
	self type: 'password'.!

prepareAttributesToPrintOn: aSession
	self value notNil ifTrue:
		[self attributesAt: #value put: 
			(WebFormElement autoConvertToString: self valueModel value)]!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self ident, '<input'.
	self printAttributesOn: aStream for: aSession.
	aStream nextPutAll: '>'.
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].!

resetHidden
	self hidden: false!

resetPassword
	self password: false!

saveThroughAdapterValue: aValueString
	| vlue |
	vlue :=  AIDASite convertFromWeb: aValueString on: self session. "ensure unicode!!"
	vlue := (WebFormElement autoConvertString:  vlue toObject: self valueModel value).
	self valueModel value: vlue.!

setHidden
	self hidden: true!

setPassword
	self password: true!

shouldIdent
	^false!

size: aNumber
	"number of characters displayed in this input field"
	self attributesAt: #size put: aNumber printString! !
!WebInputField categoriesFor: #aspect:for:size:!initialize-release!private! !
!WebInputField categoriesFor: #hidden!private! !
!WebInputField categoriesFor: #hidden:!private! !
!WebInputField categoriesFor: #initialize!initialize-release!private! !
!WebInputField categoriesFor: #isHidden!private!testing! !
!WebInputField categoriesFor: #isInputField!private!testing! !
!WebInputField categoriesFor: #isPassword!private!testing! !
!WebInputField categoriesFor: #maxLength:!attributes!private! !
!WebInputField categoriesFor: #password!private! !
!WebInputField categoriesFor: #password:!private! !
!WebInputField categoriesFor: #prepareAttributesToPrintOn:!printing!private! !
!WebInputField categoriesFor: #printHTMLPageOn:forSession:!printing!private! !
!WebInputField categoriesFor: #resetHidden!attributes!private! !
!WebInputField categoriesFor: #resetPassword!attributes!private! !
!WebInputField categoriesFor: #saveThroughAdapterValue:!private! !
!WebInputField categoriesFor: #setHidden!attributes!private! !
!WebInputField categoriesFor: #setPassword!attributes!private! !
!WebInputField categoriesFor: #shouldIdent!private!testing! !
!WebInputField categoriesFor: #size:!attributes!private! !

!WebInputField class methodsFor!

adaptIndex: aNumber ofCollection: aCollection

	^self new aspect: aNumber for: aCollection!

aspect: aSymbol for: anObject
	^self new aspect: aSymbol for: anObject!

aspect: aSymbol for: anObject size: aNumber
	^self new aspect: aSymbol for: anObject size: aNumber!

size: aNumber aspect: aSymbol forObject: anObject
	"OBSOLETE!!"
	^self new size: aNumber; aspect: aSymbol for: anObject! !
!WebInputField class categoriesFor: #adaptIndex:ofCollection:!instance creation!private! !
!WebInputField class categoriesFor: #aspect:for:!instance creation!private! !
!WebInputField class categoriesFor: #aspect:for:size:!instance creation!private! !
!WebInputField class categoriesFor: #size:aspect:forObject:!instance creation!private! !

WebMenu guid: (GUID fromString: '{334917AE-65B9-4F47-901D-89357DABC222}')!
WebMenu comment: 'WebMenu is a dropdown menu, which can select single or multiple options. Options are read from a collection, selected options are put in selected. You can set aspect of each option if options are not plain text. 

Example:

	WebMenu aspect: #name collection: self persons selected: self selectedPersons

will show dropdown menu of all persons, shown by name. Selected person will be stored in selectedPersons collection. Above menu is  single selection, it can be multiple selection too if you do:

	aWebMenu setMultiple.'!
!WebMenu categoriesForClass!Unclassified! !
!WebMenu methodsFor!

acceptFormInputFrom: aPostDataArray
	| option result values |
	self selected isNil ifTrue: [self selected: OrderedCollection new]. "we need a collection!! "
	self selected copy do: [:each | self selected remove: each].
	values := aPostDataArray class == Dictionary
		ifTrue:  [Set new add: (aPostDataArray at: self name); yourself]
		ifFalse: [(aPostDataArray allAt: self name) asSet].
	self selected addAll: 
		(self collection select:  [:each |
			option := self aspect isNil ifTrue: [each] ifFalse: [each perform: self aspect].
			option := AIDASite convertToWeb: option on: self app session.
			values includes: option trimBlanks]).
	self aspectToStore notNil ifTrue: 
		[result := self selected notEmpty ifTrue: [self selected asOrderedCollection first] ifFalse: [nil].
		self objectToStore perform: (self aspectToStore asString, ':') asSymbol with: result]!

aspect: aSymbol collection: aCollection selected: aSelectedCollection
	self aspect: aSymbol.
	self collection: aCollection.
	self selected: aSelectedCollection.
	self setMultiple.
	self size: 4.!

aspect: aSymbol collection: aCollection selectedToAspect: aSymbol2 of: anObject
	self multiple: false.
	self aspect: aSymbol.
	self collection: aCollection.
	self aspectToStore: aSymbol2.
	self objectToStore: anObject!

aspectToStore
	^aspectToStore!

aspectToStore: aSymbol
	"a name of a method to call on objectToStore, to write down a result from selection"
	aspectToStore := aSymbol!

collection
	^collection!

collection: aCollection
	collection := aCollection!

collection: aCollection selected: aSelectedCollection
	self collection: aCollection.
	self selected: aSelectedCollection.
	self setMultiple.
	self size: 4.!

collection: aCollection selectedToAspect: aSymbol of: anObject
	self multiple: false.
	self collection: aCollection.
	self aspectToStore: aSymbol.
	self objectToStore: anObject!

initialize
	super initialize.
	self resetMultiple.!

isEmpty
	"input field is empty or nil"
	| vlue |
	self objectToStore notNil ifTrue: [vlue := self objectToStore perform: self aspectToStore].
	^vlue isNil 
		or: [((vlue isKindOf: String) and: [vlue isEmpty])
			or: [(vlue isKindOf: Number) and: [vlue = 0] ]]!

isMenu
	^true!

isMultiple
	"multiple selection?"
	^self multiple!

joinToForm: aWebForm
	aWebForm fields keysAndValuesDo: [:fname :element | 
		element == self ifTrue: [self name: fname]. ^self]!

multiple
	^multiple!

multiple: aBoolean
	multiple := aBoolean!

objectToStore
	^objectToStore!

objectToStore: anObject
	"an object in which to write down a result from selection"
	objectToStore := anObject!

prepareSelected
	"add aspect of objectToStore selected result. There a preselection can reside"
	self aspectToStore isNil ifTrue: [^nil]. "multiple selections used, selected already set"
	self selected: (Set with: (self objectToStore perform: self aspectToStore))!

printHTMLPageOn: aStream forSession: aSession
	self prepareToHTMLPrintOn: aSession.
	self scriptBefore notNil ifTrue: [self scriptBefore printHTMLPageOn: aStream forSession: aSession].
	aStream nextPutAll: self ident, '<select'.
	self printAttributesOn: aStream for: aSession.
	self isMultiple ifTrue: [aStream nextPutAll: ' multiple'].
	aStream nextPutAll: '>'.
	self printOptionsOn: aStream.
	aStream nextPutAll: '</select>'.
	self scriptAfter notNil ifTrue: [self scriptAfter printHTMLPageOn: aStream forSession: aSession].!

printOptionsOn: aStream
	| option preselected |
	self collection isEmpty ifTrue: [^nil].
	self prepareSelected.
	preselected := self selected notNil ifTrue: [self selected asSet] ifFalse: [#()].
	aStream nextPutAll: '<option></option>'. "empty choice"
	self collection do: [:each |
		option := self aspect isNil ifTrue: [each] ifFalse: [each perform: self aspect]. 
		option := AIDASite convertToWeb: option on: self app session.
		aStream nextPutAll: '<option'.
		aStream nextPutAll: ((preselected includes: each) ifTrue: [' selected>'] ifFalse: ['>']).
 		aStream nextPutAll: option; nextPutAll: '</option> ' ]!

resetMultiple
	self multiple: false!

selected
	"selected options wiil be stored here"
	^selected!

selected: aCollection
	selected := aCollection!

setMultiple
	self multiple: true!

shouldIdent
	^false!

size: aRowNumbe