Object subclass: #WPerson
	instanceVariableNames: 'book name surname partner'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'AidaTutorial'!

!WPerson methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 11:34'!
book
	 ^book! !

!WPerson methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 11:33'!
book: aWeedingBook
	 book := aWeedingBook! !

!WPerson methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 11:42'!
name
	name isNil ifTrue: [^''].
	 ^name! !

!WPerson methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 11:36'!
name: aString
	 name := aString! !

!WPerson methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 12:07'!
partner
	 ^partner! !

!WPerson methodsFor: 'accessing' stamp: 'jm 9/2/2009 22:05'!
partner: aPerson
	 partner := aPerson.
! !

!WPerson methodsFor: 'accessing' stamp: 'jm 9/1/2009 17:01'!
preferedUrl
	^'/', self name, '-', self surname! !

!WPerson methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 11:43'!
surname
	surname isNil ifTrue: [^''].
	 ^surname! !

!WPerson methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 11:36'!
surname: aString
	 surname := aString! !


WebApplication subclass: #WPersonApp
	instanceVariableNames: ''
	classVariableNames: ''
	poolDictionaries: ''
	category: 'AidaTutorial'!

!WPersonApp methodsFor: 'views' stamp: 'jm 9/2/2009 21:39'!
detailsElement
	| e |
	e := WebElement new.
	e addText: self observee name. e addBreak.
	e addText: self observee surname. e addBreak.
	e addText: 'Status: '; add: self statusElement. e addBreak.
	e addText: 'Choose partner: '.
	(e addMenuAspect: #name collection: self observee book persons
		selectedToAspect: #partner of: self observee)
			onChangePostAndUpdate: e.
	 ^e! !

!WPersonApp methodsFor: 'views' stamp: 'jm 9/2/2009 18:51'!
statusElement
	| e |
	e := WebElement new.
	self observee partner isNil
		ifTrue: [e addTextBold: 'Free']
		ifFalse: [e addText: 'Married to: '; addTextBold: self observee partner name].
	^e! !

!WPersonApp methodsFor: 'views' stamp: 'jm 9/2/2009 21:39'!
viewMain
	| e |
	e := WebElement new.
	e addLinkTo: self observee book text: 'Back to book'.
	e addTextH1: 'Person details'.
	e add: self detailsElement.
	self style pageFrameWith: e title: 'Person'! !


WebWidget subclass: #WPersonEditWidget
	instanceVariableNames: 'person'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'AidaTutorial'!

!WPersonEditWidget methodsFor: 'accessing' stamp: 'jm 9/2/2009 17:53'!
element
 	^element! !

!WPersonEditWidget methodsFor: 'accessing' stamp: 'jm 9/2/2009 17:53'!
element: aWebElement
 	element := aWebElement! !

!WPersonEditWidget methodsFor: 'accessing' stamp: 'jm 9/1/2009 17:24'!
person
 	^person! !

!WPersonEditWidget methodsFor: 'accessing' stamp: 'jm 9/1/2009 17:23'!
person: aPerson
 	person := aPerson! !


!WPersonEditWidget methodsFor: 'views' stamp: 'jm 9/2/2009 17:35'!
ajaxUpdate
	^self build! !

!WPersonEditWidget methodsFor: 'views' stamp: 'jm 9/2/2009 17:52'!
build
	self clear.
	self registerId.
	self addTextH1: 'Edit person details'.
	self addInputFieldAspect: #name for: self person. 
	self addBreak.
	self addInputFieldAspect: #surname for: self person. 
	self addBreak.
	(self addButtonText: 'Save' action: #save)
		ajaxSubmit;
		onSubmitUpdate: self element. 
	self addSpace.
	self addCloseWindowText: 'Cancel'
	
! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

WPersonEditWidget class
	instanceVariableNames: ''!

!WPersonEditWidget class methodsFor: 'instance creation' stamp: 'jm 9/2/2009 17:40'!
new
	^super new
		method: #ajaxUpdate! !


Object subclass: #WeddingBook
	instanceVariableNames: 'persons'
	classVariableNames: 'Singleton'
	poolDictionaries: ''
	category: 'AidaTutorial'!

!WeddingBook methodsFor: 'initialize-release' stamp: 'JankoMivsek 9/1/2009 11:39'!
initPersons
	persons := OrderedCollection new! !


!WeddingBook methodsFor: 'adding-removing' stamp: 'JankoMivsek 9/1/2009 11:40'!
addPerson: aPerson
	self persons add: aPerson.
	aPerson book: self! !


!WeddingBook methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 11:37'!
persons
	persons isNil ifTrue: [self initPersons].
	^persons! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

WeddingBook class
	instanceVariableNames: ''!

!WeddingBook class methodsFor: 'accessing' stamp: 'JankoMivsek 9/1/2009 12:00'!
singleton
	Singleton ifNil: [Singleton := WeddingBook new].
	^Singleton! !


WebApplication subclass: #WeddingBookApp
	instanceVariableNames: 'person'
	classVariableNames: ''
	poolDictionaries: ''
	category: 'AidaTutorial'!

!WeddingBookApp methodsFor: 'accesssing' stamp: 'jm 9/1/2009 18:03'!
newPerson
	^person := WPerson new.! !

!WeddingBookApp methodsFor: 'accesssing' stamp: 'jm 9/1/2009 18:04'!
person
	^person! !


!WeddingBookApp methodsFor: 'views' stamp: 'jm 9/2/2009 17:54'!
viewMain
	| e |
	e := WebElement new.
	e addTextH1: 'Wedding Book'.
	self observee persons do: [:person |
		e addLinkTo: person text: person name, ' ', person surname.
		e addBreak].
	e addBreak.
	(e addNilLinkText: 'Add new person')
		onClickPopup: (WPersonEditWidget new person: self newPerson; element: e).
	self style pageFrameWith: e title: 'Wedding Book'! !


!WeddingBookApp methodsFor: 'actions' stamp: 'jm 9/2/2009 17:57'!
viewMainSave
	self observee addPerson: self person! !
